<?php
 /**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Accounting extends MY_Controller
{

   /*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	public function __construct() {
          parent::__construct();
          //load the models
          $this->load->model('Xin_model');
		  $this->load->model('Finance_model');
		  $this->load->model('Expense_model');
		  $this->load->model('Invoices_model');
		  $this->load->model('Employees_model');
		  $this->load->model('Department_model');
		  $this->load->model('Project_model');
		  $this->load->model('Awards_model');
		  $this->load->model('Training_model');
     }
	public function index()
     {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_finance').' | '.$this->Xin_model->site_title();
		
		$data['breadcrumbs'] = $this->lang->line('xin_hr_finance');
		$data['path_url'] = 'accounting';
		$data['get_invoice_payments'] = $this->Finance_model->get_invoice_payments();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('72',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/finance", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
     }
	 public function accounting_dashboard()
     {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('hr_accounting_dashboard_title').' | '.$this->Xin_model->site_title();
		
		$data['breadcrumbs'] = $this->lang->line('hr_accounting_dashboard_title');
		$data['path_url'] = 'projects_dashboard';
		$data['get_invoice_payments'] = $this->Finance_model->get_invoice_payments();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('507',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/accounting_dashboard", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
     } 
	public function deposit() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_deposit').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_deposit');
		$data['path_url'] = 'accounting_deposit';
		$data['all_payers'] = $this->Finance_model->all_payers();
		$data['all_bank_cash'] = $this->Finance_model->all_bank_cash();
		$data['all_income_categories_list'] = $this->Finance_model->all_income_categories_list();
		$data['get_all_payment_method'] = $this->Finance_model->get_all_payment_method();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('523',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/deposit_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function transfer() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_transfer').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_transfer');
		$data['path_url'] = 'accounting_transfer';
		$data['all_bank_cash'] = $this->Finance_model->all_bank_cash();
		$data['all_income_categories_list'] = $this->Finance_model->all_income_categories_list();
		$data['get_all_payment_method'] = $this->Finance_model->get_all_payment_method();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('538',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/transfer_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function expense() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_expense').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_expense');
		$data['path_url'] = 'accounting_expense';
		$data['all_payees'] = $this->Finance_model->all_payees();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_expense_types'] = $this->Expense_model->all_expense_types();
		$data['all_bank_cash'] = $this->Finance_model->all_bank_cash();
		$data['all_income_categories_list'] = $this->Finance_model->all_income_categories_list();
		$data['get_all_payment_method'] = $this->Finance_model->get_all_payment_method();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('530',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/expense_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	// get company > employees
	 public function get_employees() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 // get company > expense_types
	 public function get_company_expense_types() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/get_company_expense_types", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 // get company > expense_types
	 public function get_expense_types() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/get_expense_types", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 // get company > expense_types
	 public function get_expense_type_reports() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/get_expense_type_reports", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	public function payers() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_payers').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = "Payees";
		$data['path_url'] = 'accounting_payers';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('549',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/payers_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function payees() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_payees_n_payers').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_payees_n_payers');
		$data['path_url'] = 'accounting_payees';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('545',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/payees_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	public function bank_cash() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_accounts').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_accounts');
		$data['path_url'] = 'accounting_bank_cash';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('511',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/bank_cash_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function account_balances() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_account_balances').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_account_balances');
		$data['path_url'] = 'accounting_account_balances';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('513',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/account_balances", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function transactions() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_transactions').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_transactions');
		$data['path_url'] = 'accounting_transactions';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('543',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/transaction_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	 
	 public function read() {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		/*$id = $this->input->get('bankcash_id');
		$result = $this->Finance_model->read_bankcash_information($id);
		$data = array(
				'bankcash_id' => $result[0]->bankcash_id,
				'account_name' => $result[0]->account_name,
				'account_balance' => $result[0]->account_balance,
				'account_number' => $result[0]->account_number,
				'branch_code' => $result[0]->branch_code,
				'bank_branch' => $result[0]->bank_branch,
				'created_at' => $result[0]->created_at
				);*/
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	public function read_payer() {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('payer_id');
		$result = $this->Finance_model->read_payer_info($id);
		$data = array(
				'payer_id' => $result[0]->payer_id,
				'payer_name' => $result[0]->payer_name,
				'contact_number' => $result[0]->contact_number,
				'created_at' => $result[0]->created_at
				);
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	
	public function read_payee() {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('payee_id');
		$result = $this->Finance_model->read_payee_info($id);
		$data = array(
				'payee_id' => $result[0]->payee_id,
				'payee_name' => $result[0]->payee_name,
				'contact_number' => $result[0]->contact_number,
				'created_at' => $result[0]->created_at
				);
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	// payers list
	public function payers_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/payers_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$payer = $this->Finance_model->get_payers();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();

          foreach($payer->result() as $r) {
			  
		   // create at
			$created_at = $this->Xin_model->set_date_format($r->created_at);
			if(in_array('551',$role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".add-modal-data"  data-payer_id="'. $r->payer_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if(in_array('552',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->payer_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			
			$combhr = $edit.$delete;
			
	    if(in_array('551',$role_resources_ids) || in_array('552',$role_resources_ids)) {
          $data[] = array(
            
            $r->payer_name,
            $r->contact_number,
            $created_at,
            $combhr,
          );
        } else { 
          $data[] = array(
            $r->payer_name,
            $r->contact_number,
            $created_at
          );  
        } 
        
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $payer->num_rows(),
                 "recordsFiltered" => $payer->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	 // payees list
	public function payees_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/payees_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$payee = $this->Finance_model->get_payees();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();

          foreach($payee->result() as $r) {
			  
		   // create at
			$created_at = $this->Xin_model->set_date_format($r->created_at);
			if(in_array('547',$role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".add-modal-data"  data-payee_id="'. $r->payee_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if(in_array('548',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->payee_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			
			$combhr = $edit.$delete;
			
		if(in_array('547',$role_resources_ids) || in_array('548',$role_resources_ids)) {
          $data[] = array(
            
            $r->payee_name,
            $r->contact_number,
            $created_at,
            $combhr,
          );
        } else { 
          $data[] = array(
            $r->payee_name,
            $r->contact_number,
            $created_at
          );  
        }
        
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $payee->num_rows(),
                 "recordsFiltered" => $payee->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	 // bank and cash list
	public function bank_cash_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/bank_cash_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$bankcash = $this->Finance_model->get_bankcash();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();

          foreach($bankcash->result() as $r) {
			  
			// get currency
			$account_balance = $this->Xin_model->currency_sign($r->account_balance);
			$bank_cash = $this->Finance_model->read_transaction_by_bank_info($r->bankcash_id);
			if(!is_null($bank_cash)){
				$account = '<a data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_acc_ledger_view').'" href="'.site_url('admin/accounting/accounts_ledger/'.$r->bankcash_id.'').'" target="_blank">'.$r->account_name.'</a>';
			} else {
				$account = $r->account_name;
			}
			if(in_array('513',$role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target="#edit-modal-data"  data-bankcash_id="'. $r->bankcash_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
		    if(in_array('514',$role_resources_ids)) { //edit
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->bankcash_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
		
			
			$combhr = $edit.$delete;

		if(in_array('513',$role_resources_ids) || in_array('514',$role_resources_ids)) {
          $data[] = array(
            
            $account,
            $r->account_number,
            $r->branch_code,
            $account_balance,
            $r->bank_branch,
            $combhr,
          );
        } else { 
          $data[] = array(
            $account,
            $r->account_number,
            $r->branch_code,
            $account_balance,
            $r->bank_branch
          );  
        } 
        
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $bankcash->num_rows(),
                 "recordsFiltered" => $bankcash->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	 
	 // account balances list
	public function account_balances_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/account_balances", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$bankcash = $this->Finance_model->get_bankcash();
		
		$data = array();

          foreach($bankcash->result() as $r) {
			  
			  // get currency
			  $account_balance = $this->Xin_model->currency_sign($r->account_balance);
			  $bank_cash = $this->Finance_model->read_transaction_by_bank_info($r->bankcash_id);
			  if(!is_null($bank_cash)){
			  	$account = '<a data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_acc_ledger_view').'" href="'.site_url('admin/accounting/accounts_ledger/'.$r->bankcash_id.'').'" target="_blank">'.$r->account_name.'</a>';
			  } else {
				  $account = $r->account_name;
			  }

               $data[] = array(
                    $account,
                    $account_balance
               );
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $bankcash->num_rows(),
                 "recordsFiltered" => $bankcash->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	 
	 // deposit list
	public function deposit_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/deposit_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$deposit = $this->Finance_model->get_deposit();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();

          foreach($deposit->result() as $r) {
			  
			// get amount
			$amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			// account type
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account = $acc_type[0]->account_name;
			} else {
				$account = '--';	
			}
			
			// get user > added by
			$payer = $this->Finance_model->read_payer_info($r->payer_payee_id);
			// user full name
			if(!is_null($payer)){
				$full_name = $payer[0]->payer_name;
			} else {
				$full_name = '--';	
			}
			
			// deposit date
			$deposit_date = $this->Xin_model->set_date_format($r->transaction_date);
			// category
			$category_id = $this->Finance_model->read_income_category($r->transaction_cat_id);
			if(!is_null($category_id)){
				$category = $category_id[0]->name;
			} else {
				$category = '--';	
			}
			// payment method 
			$payment_method = $this->Xin_model->read_payment_method($r->payment_method_id);
			if(!is_null($payment_method)){
				$method_name = $payment_method[0]->method_name;
			} else {
				$method_name = '--';	
			}
			if(in_array('525',$role_resources_ids)) { //edit
			    $edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-deposit_id="'. $r->transaction_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if(in_array('526',$role_resources_ids)) { //edit
			   	$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->transaction_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
					
			$combhr = $edit.$delete;

		if(in_array('525',$role_resources_ids) || in_array('526',$role_resources_ids)) {
          $data[] = array(
            
            $account,
            $full_name,
            $amount,
            $category,
            $r->reference,
            $method_name,
            $deposit_date,
            $combhr,
          );
        } else { 
          $data[] = array(
            $account,
            $full_name,
            $amount,
            $category,
            $r->reference,
            $method_name,
            $deposit_date
          );  
        } 
        
	  }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $deposit->num_rows(),
			 "recordsFiltered" => $deposit->num_rows(),
			 "data" => $data
		);
	  echo json_encode($output);
	  exit();
     }
	 
	 // expense list
	public function expense_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/expense_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$expense = $this->Finance_model->get_expense();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();

          foreach($expense->result() as $r) {
			  
			// get amount
			$amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			// account type
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account = $acc_type[0]->account_name;
			} else {
				$account = '--';	
			}
			
			// get user > added by
			if($r->payee_option == 1){
				$payee = $this->Xin_model->read_user_info($r->payer_payee_id);
				// user full name
				if(!is_null($payee)){
					$full_name = $payee[0]->first_name.' '.$payee[0]->last_name;
				} else {
					$full_name = '--';	
				}
			} else {
				$payee = $this->Finance_model->read_payee_info($r->payer_payee_id);
				// user full name
				if(!is_null($payee)){
					$full_name = $payee[0]->payee_name;
				} else {
					$full_name = '--';	
				}
			}
			//
			
						
			// deposit date
			$expense_date = $this->Xin_model->set_date_format($r->transaction_date);
			// category
			$expense_type = $this->Expense_model->read_expense_type_information($r->transaction_cat_id);
			if(!is_null($expense_type)){
				$category = $expense_type[0]->name;
			} else {
				$category = '--';	
			}
			
			// payment method 
			$payment_method = $this->Xin_model->read_payment_method($r->payment_method_id);
			if(!is_null($payment_method)){
				$method_name = $payment_method[0]->method_name;
			} else {
				$method_name = '--';	
			}
				if(in_array('532',$role_resources_ids)) { //edit
			  	$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-expense_id="'. $r->transaction_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
				if(in_array('533',$role_resources_ids)) { //edit
			   	$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->transaction_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
		
					
			$combhr = $edit.$delete;

		if(in_array('532',$role_resources_ids) || in_array('533',$role_resources_ids)) {
          $data[] = array(
            
            $account,
            $full_name,
            $amount,
            $category,
            $r->reference,
            $method_name,
            $expense_date,
            $combhr,
          );
        } else { 
          $data[] = array(
            $account,
            $full_name,
            $amount,
            $category,
            $r->reference,
            $method_name,
            $expense_date
          );  
        } 
        
	  }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $expense->num_rows(),
			 "recordsFiltered" => $expense->num_rows(),
			 "data" => $data
		);
	  echo json_encode($output);
	  exit();
     }	 
	 
	// transactions list
	public function transaction_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/transaction_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$transaction = $this->Finance_model->get_transaction();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();
		$balance2 = 0;
	
          foreach($transaction->result() as $r) {
		
			// transaction date
			$transaction_date = $this->Xin_model->set_date_format($r->transaction_date);
			// get currency
			$total_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			// credit
			$cr_dr = $r->dr_cr=="dr" ? "Debit" : "Credit";
			
			// account type
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account = '<a href="'.site_url('admin/accounting/accounts_ledger/'.$r->account_id.'').'" title="'.$this->lang->line('xin_acc_ledger_view').'" target="_blank">'.$acc_type[0]->account_name.'</a>';
			} else {
				$account = '--';	
			}
			//
			if($r->dr_cr=="cr"){
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".view-modal-data-bg"  data-deposit_id="'. $r->transaction_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-expense_id="'. $r->transaction_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			}
			$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->transaction_id . '"><span class="fas fa-trash-restore"></span></button></span>';			
			$combhr = $edit.$delete;
			
			$data[] = array(
				$transaction_date,
				$account,
				$cr_dr,
				$r->transaction_type,
				$total_amount,
				$r->reference
			);
		  }
	

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $transaction->num_rows(),
                 "recordsFiltered" => $transaction->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	 
	 // Validate and add info in database
	public function add_deposit() {
	
		if($this->input->post('add_type')=='deposit') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('deposit_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		}
// 		else if($_FILES['deposit_file']['size'] == 0) {
// 			$fname = 'no_file';
// 		}
// 		else if(is_uploaded_file($_FILES['deposit_file']['tmp_name'])) {
// 			//checking image type
// 			//$Return['error'] = $this->lang->line('xin_acc_error_attachment');
// 			$allowed =  array('PNG','JPG','JPEG','PDF','GIF','png','jpg','jpeg','pdf','gif','txt','doc','docx','xls','xlsx');
// 			$filename = $_FILES['deposit_file']['name'];
// 			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			
// 			if(in_array($ext,$allowed)){
// 				$tmp_name = $_FILES["deposit_file"]["tmp_name"];
// 				$profile = "uploads/accounting/deposit/";
// 				$set_img = base_url()."uploads/accounting/deposit/";
// 				// basename() may prevent filesystem traversal attacks;
// 				// further validation/sanitation of the filename may be appropriate
// 				$name = basename($_FILES["deposit_file"]["name"]);
// 				$newfilename = 'deposit_'.round(microtime(true)).'.'.$ext;
// 				move_uploaded_file($tmp_name, $profile.$newfilename);
// 				$fname = $newfilename;					
// 			} else {
// 				$Return['error'] = $this->lang->line('xin_acc_error_attachment');
// 			}
// 		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		$data = array(
		'account_id' => $this->input->post('bank_cash_id'),
		'amount' => $this->input->post('amount'),
		'transaction_type' => 'income',
		'dr_cr' => 'dr',
		'transaction_date' => $this->input->post('deposit_date'),
		'attachment_file' => $this->input->post('attachment'),
		'transaction_cat_id' => $this->input->post('category_id'),
		'payer_payee_id' => $this->input->post('payer_id'),
		'payment_method_id' => $this->input->post('payment_method'),
		'description' => 'Deposit Amount',
		'reference' => $this->input->post('deposit_reference'),
		'invoice_id' => 0,
		'created_at' => date('Y-m-d H:i:s')
		);
		$result = $this->Finance_model->add_transactions($data);
		if ($result == TRUE) {			
			// add data to bank account>cr
			$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
			$acc_balance = $account_id[0]->account_balance + $this->input->post('amount');
			
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
		
			$Return['result'] = $this->lang->line('xin_acc_success_deposit_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
	
		
		}
	} 
	
	// Validate and add info in database
	public function add_expense() {
	
		if($this->input->post('add_type')=='expense') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		$bank_cash = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('amount') > $bank_cash[0]->account_balance) {
			$Return['error'] = $this->lang->line('xin_acc_error_amount_should_be_less_than_current');
		} else if($this->input->post('expense_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_expense_date');
		} else if($this->input->post('company')==='') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if($this->input->post('payee_id')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_payee_name');
		}
// 		else if($_FILES['expense_file']['size'] == 0) {
// 			$fname = 'no_file';
// 		}
// 		else if(is_uploaded_file($_FILES['expense_file']['tmp_name'])) {
// 			//checking image type
// 			$allowed =  array('png','jpg','jpeg','pdf','gif','txt','doc','docx','xls','xlsx');
// 			$filename = $_FILES['expense_file']['name'];
// 			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			
// 			if(in_array($ext,$allowed)){
// 				$tmp_name = $_FILES["expense_file"]["tmp_name"];
// 				$profile = "uploads/accounting/expense/";
// 				$set_img = base_url()."uploads/accounting/expense/";
// 				// basename() may prevent filesystem traversal attacks;
// 				// further validation/sanitation of the filename may be appropriate
// 				$name = basename($_FILES["expense_file"]["name"]);
// 				$newfilename = 'expense_'.round(microtime(true)).'.'.$ext;
// 				move_uploaded_file($tmp_name, $profile.$newfilename);
// 				$fname = $newfilename;					
// 			} else {
// 				$Return['error'] = $this->lang->line('xin_acc_error_attachment');
// 			}
// 		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		$data = array(
		'account_id' => $this->input->post('bank_cash_id'),
		'amount' => $this->input->post('amount'),
		'transaction_type' => 'expense',
		'dr_cr' => 'cr',
		'transaction_date' => $this->input->post('expense_date'),
		'attachment_file' => $this->input->post('attachment'),
		'transaction_cat_id' => $this->input->post('category_id'),
		'payer_payee_id' => $this->input->post('payee_id'),
		'payee_option' => $this->input->post('payee_option'),
		'company_id' => $this->input->post('company'),
		'payment_method_id' => $this->input->post('payment_method'),
		'description' => $qt_description,
		'reference' => $this->input->post('expense_reference'),
		'invoice_id' => 0,
		'created_at' => date('Y-m-d H:i:s')
		);
		$result = $this->Finance_model->add_transactions($data);
		if ($result == TRUE) {			
			// update data in bank account
			$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
			$acc_balance = $account_id[0]->account_balance - $this->input->post('amount');
			
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
			
			$Return['result'] = $this->lang->line('xin_acc_success_expense_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
	
		
		}
	} 
	
	// Validate and add info in database
	public function add_invoice_payment() {
	
		if($this->input->post('add_type')=='invoice_payment') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		$invoice_tr = $this->Finance_model->read_invoice_transaction($this->input->post('invoice_id'));
		if ($invoice_tr->num_rows() > 0) {
			$Return['error'] = $this->lang->line('xin_acc_inv_paid_already');
		} 
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		if($this->input->post('bank_cash_id')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('add_invoice_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		} else if($this->input->post('payment_method')==='') {
			$Return['error'] = $this->lang->line('xin_error_makepayment_payment_method');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		$invoice_id = $this->input->post('invoice_id');
		$data = array(
		'account_id' => $this->input->post('bank_cash_id'),
		'amount' => $this->input->post('amount'),
		'transaction_type' => 'income',
		'invoice_type' => 'customer',
		'dr_cr' => 'dr',
		'transaction_date' => $this->input->post('add_invoice_date'),
		'attachment_file' => '',
		'transaction_cat_id' => $this->input->post('category_id'),
		'payer_payee_id' => $this->input->post('payer_id'),
		'payment_method_id' => $this->input->post('payment_method'),
		'description' => $qt_description,
		'reference' => $this->input->post('reference'),
		'invoice_id' => $invoice_id,
		'created_at' => date('Y-m-d H:i:s')
		);
		$result = $this->Finance_model->add_transactions($data);
		if ($result == TRUE) {			
			// add data to bank account>cr
			$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
			$acc_balance = $account_id[0]->account_balance + $this->input->post('amount');
			
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
			$data = array(
				'status' => 1,
			);
			$result = $this->Invoices_model->update_invoice_record($data,$invoice_id);
		
			$Return['result'] = $this->lang->line('xin_acc_success_deposit_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
	
		
		}
	}
	// Validate and add info in database
	public function add_direct_invoice_payment() {
	
		if($this->input->post('add_type')=='invoice_payment') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		$invoice_tr = $this->Finance_model->read_invoice_transaction($this->input->post('invoice_id'));
		if ($invoice_tr->num_rows() > 0) {
			$Return['error'] = $this->lang->line('xin_acc_inv_paid_already');
		} 
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		if($this->input->post('bank_cash_id')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('add_invoice_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		} else if($this->input->post('payment_method')==='') {
			$Return['error'] = $this->lang->line('xin_error_makepayment_payment_method');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		$invoice_id = $this->input->post('invoice_id');
		$data = array(
		'account_id' => $this->input->post('bank_cash_id'),
		'amount' => $this->input->post('amount'),
		'transaction_type' => 'income',
		'invoice_type' => 'direct',
		'dr_cr' => 'dr',
		'transaction_date' => $this->input->post('add_invoice_date'),
		'attachment_file' => '',
		'transaction_cat_id' => $this->input->post('category_id'),
		'payer_payee_id' => $this->input->post('payer_id'),
		'payment_method_id' => $this->input->post('payment_method'),
		'description' => $qt_description,
		'reference' => $this->input->post('reference'),
		'invoice_id' => $invoice_id,
		'created_at' => date('Y-m-d H:i:s')
		);
		$result = $this->Finance_model->add_transactions($data);
		if ($result == TRUE) {			
			// add data to bank account>cr
			$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
			$acc_balance = $account_id[0]->account_balance + $this->input->post('amount');
			
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
			$data = array(
				'status' => 1,
			);
			$result = $this->Invoices_model->update_direct_invoice_record($data,$invoice_id);
		
			$Return['result'] = $this->lang->line('xin_acc_success_deposit_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
	
		
		}
	}
	
	// Validate and add info in database
	public function add_transfer() {
	
// 		if($this->input->post('add_type')=='transfer') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('from_bank_cash_id')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_from_account');
		} else if($this->input->post('to_bank_cash_id')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_to_account');
		} else if($this->input->post('from_bank_cash_id')== $this->input->post('to_bank_cash_id')) {
        	$Return['error'] = $this->lang->line('xin_acc_error_transer_to_same_account');
		} else if($this->input->post('transfer_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_transer_date');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('amount') > $this->input->post('account_balance')) {
			$Return['error'] = $this->lang->line('xin_acc_error_amount_should_be_less_than_current');
		}
						
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		$from_account_id = $this->Finance_model->read_bankcash_information($this->input->post('from_bank_cash_id'));
		$frm_acc = $from_account_id[0]->account_balance - $this->input->post('amount');
		
		$to_bank_cash_id = $this->Finance_model->read_bankcash_information($this->input->post('to_bank_cash_id'));
		$to_acc = $to_bank_cash_id[0]->account_balance + $this->input->post('amount');
		
		$data = array(
		'account_id' => $this->input->post('from_bank_cash_id'),
		'amount' => $this->input->post('amount'),
		'transaction_type' => 'transfer',
		'dr_cr' => 'cr',
		'transaction_date' => $this->input->post('transfer_date'),
		'attachment_file' => '',
		'transaction_cat_id' => 0,
		'payer_payee_id' => 0,
		'payment_method_id' => $this->input->post('payment_method'),
		'description' => $qt_description,
		'reference' => $this->input->post('transfer_reference'),
		'invoice_id' => 0,
		'created_at' => date('Y-m-d H:i:s')
		);
		$result = $this->Finance_model->add_transactions($data);
		
		$data2 = array(
		'account_balance' => $frm_acc
		);
		$result2 = $this->Finance_model->update_bankcash_record($data2,$this->input->post('from_bank_cash_id'));
		
		$data3 = array(
		'account_balance' => $to_acc
		);
		$result3 = $this->Finance_model->update_bankcash_record($data3,$this->input->post('to_bank_cash_id'));
		
		if ($result == TRUE) {
			
			$data4 = array(
				'account_id' => $this->input->post('to_bank_cash_id'),
				'amount' => $this->input->post('amount'),
				'transaction_type' => 'transfer',
				'dr_cr' => 'dr',
				'transaction_date' => $this->input->post('transfer_date'),
				'attachment_file' => '',
				'transaction_cat_id' => 0,
				'payer_payee_id' => 0,
				'payment_method_id' => $this->input->post('payment_method'),
				'description' => $qt_description,
				'reference' => $this->input->post('transfer_reference'),
				'invoice_id' => 0,
				'created_at' => date('Y-m-d H:i:s')
			);
			$result4 = $this->Finance_model->add_transactions($data4);
			
			$Return['result'] = $this->lang->line('xin_acc_success_transfer_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
	
		
// 		}
	}
	
	// Validate and add info in database> add bank-cash
	public function add_bankcash() {
	
		if($this->input->post('add_type')=='bankcash') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		$bank_branch = $this->input->post('bank_branch');
		$account_number =$this->input->post('account_number');
		$qt_bank_branch = htmlspecialchars(addslashes($bank_branch), ENT_QUOTES);
			
		/* Server side PHP input validation */
		if($this->input->post('account_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_account_name_field');
		} else if($this->input->post('account_balance')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_account_balance_field');
		} 
		else if($this->input->post('account_number')==='') {
			$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
		}
		
		$hello= $this->Xin_model->read_account_template($account_number);

		
		 if($hello) 
		{
			$Return['error'] = "Account Exist";
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'account_name' => $this->input->post('account_name'),
		'account_balance' => $this->input->post('account_balance'),
		'account_opening_balance' => $this->input->post('account_balance'),
		'account_number' => $this->input->post('account_number'),
		'branch_code' => $this->input->post('branch_code'),
		'bank_branch' => $qt_bank_branch,
		'created_at' => date('d-m-Y h:i:s'),
		
		);
		$result = $this->Finance_model->add_bankcash($data);
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_acc_success_bank_cash_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	} 
	
	// Validate and add info in database> add bank-cash
	public function bankcash_update_validate() {
	
		if($this->input->post('edit_type')=='bankcash') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		$bank_branch = $this->input->post('bank_branch');
		$qt_bank_branch = htmlspecialchars(addslashes($bank_branch), ENT_QUOTES);
			
		/* Server side PHP input validation */
		if($this->input->post('account_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_account_name_field');
		} else if($this->input->post('account_balance')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_account_balance_field');
		} else if($this->input->post('account_number')==='') {
			$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
		} 
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
    	
		$this->output($Return);
		exit;
		}
	} 
	
	public function bankcash_update() {
	
		if($this->input->post('edit_type')=='bankcash') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		$bank_branch = $this->input->post('bank_branch');
		$qt_bank_branch = htmlspecialchars(addslashes($bank_branch), ENT_QUOTES);
			
		/* Server side PHP input validation */
		if($this->input->post('account_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_account_name_field');
		} else if($this->input->post('account_balance')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_account_balance_field');
		} else if($this->input->post('account_number')==='') {
			$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
		} 
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'account_name' => $this->input->post('account_name'),
		'account_balance' => $this->input->post('account_balance'),
		'account_number' => $this->input->post('account_number'),
		'branch_code' => $this->input->post('branch_code'),
		'bank_branch' => $qt_bank_branch,
		);
		$result = $this->Finance_model->update_bankcash_record($data,$id);
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_acc_success_bank_cash_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	} 
		 
	 // delete record
	public function delete() {
		
		if($this->input->post('is_ajax')=='2') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Finance_model->delete_bankcash_record($id);
			if(isset($id)) {
				$Return['result'] = $this->lang->line('xin_acc_success_bank_cash_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	// delete record
	public function delete_deposit_transaction() {
		
		if($this->input->post('is_ajax')=='2') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Finance_model->read_transaction_information($id);
		    $account_type_id =  $result[0]->account_id;
		    $account_amt =  $result[0]->amount;
			$account_id = $this->Finance_model->read_bankcash_information($account_type_id);
			$acc_balance = $account_id[0]->account_balance - $account_amt;
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$account_type_id);
			$result = $this->Finance_model->delete_transaction_record($id);
			if(isset($id)) {
				$Return['result'] = $this->lang->line('xin_acc_success_deposit_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	// delete record
	public function delete_expense() {
		
		if($this->input->post('is_ajax')=='2') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Finance_model->read_transaction_information($id);
		    $account_type_id =  $result[0]->account_id;
		    $account_amt =  $result[0]->amount;
			$account_id = $this->Finance_model->read_bankcash_information($account_type_id);
			$acc_balance = $account_id[0]->account_balance + $account_amt;
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$account_type_id);
			$result = $this->Finance_model->delete_transaction_record($id);
			if(isset($id)) {
				$Return['result'] = $this->lang->line('xin_acc_success_expense_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	// delete record
	public function delete_transaction() {
		
		if($this->input->post('is_ajax')=='2') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Finance_model->delete_transaction_record($id);
			if(isset($id)) {
				$Return['result'] = $this->lang->line('xin_acc_transaction_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	public function read_invoice()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$invoice_id = $this->input->get('invoice_id');
		$invoice_type = $this->input->get('data');
		if($invoice_type == 'customer'){
			$result = $this->Invoices_model->read_invoice_info($invoice_id);
		} else {
			$result = $this->Invoices_model->read_direct_invoice_info($invoice_id);
		}
		$data = array(
				'invoice_id' => $result[0]->invoice_id,
				'invoice_number' => $result[0]->invoice_number,
				'grand_total' => $result[0]->grand_total,
				'all_payers' => $this->Customers_model->get_all_customers(),
				'all_bank_cash' => $this->Finance_model->all_bank_cash(),
				'all_income_categories_list' => $this->Finance_model->all_income_categories_list(),
				'get_all_payment_method' => $this->Finance_model->get_all_payment_method()
				);
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	
	public function read_deposit()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		/*$id = $this->input->get('deposit_id');
		$result = $this->Finance_model->read_transaction_information($id);
		$data = array(
				'deposit_id' => $result[0]->transaction_id,
				'account_type_id' => $result[0]->account_id,
				'amount' => $result[0]->amount,
				'deposit_date' => $result[0]->transaction_date,
				'categoryid' => $result[0]->transaction_cat_id,
				'payer_id' => $result[0]->payer_payee_id,
				'payment_method_id' => $result[0]->payment_method_id,
				'deposit_reference' => $result[0]->reference,
				'deposit_file' => $result[0]->attachment_file,
				'description' => $result[0]->description,
				'created_at' => $result[0]->created_at,
				'all_payers' => $this->Finance_model->all_payers(),
				'all_bank_cash' => $this->Finance_model->all_bank_cash(),
				'all_income_categories_list' => $this->Finance_model->all_income_categories_list(),
				'get_all_payment_method' => $this->Finance_model->get_all_payment_method()
				);*/
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	
	// Validate and update info in database
	public function deposit_update_validate() {
	
		$id = $this->uri->segment(4);
		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('deposit_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		}/* Check if file uploaded..*/
		else if($_FILES['deposit_file']['size'] != 0) {
		    
			if(is_uploaded_file($_FILES['deposit_file']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['deposit_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["deposit_file"]["tmp_name"];
					$bill_copy = "uploads/accounting/deposit/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["deposit_file"]["name"]);
					$newfilename = 'deposit_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
					
					
				} else {
					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				}
			}
		}
	
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		
		$this->output($Return);
		exit;
		
	}
	
	public function deposit_update() {
	
		if($this->input->post('edit_type')=='deposit') {
			
		$id = $this->uri->segment(4);
		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('deposit_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		}/* Check if file uploaded..*/
		else if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {
		    $result = $this->Finance_model->read_transaction_information($id);
    	    $account_type_id =  $result[0]->account_id;
    	    $account_amt =  $result[0]->amount;
    		$account_id = $this->Finance_model->read_bankcash_information($account_type_id);
    		$acc_balance = $account_id[0]->account_balance - $account_amt;
    		$data3 = array(
    		'account_balance' => $acc_balance
    		);
    		$this->Finance_model->update_bankcash_record($data3,$account_type_id);
		    
			 $fname = 'no_file';
			 $data = array(
			'account_id' => $this->input->post('bank_cash_id'),
			'amount' => $this->input->post('amount'),
			'transaction_date' => $this->input->post('deposit_date'),
			'transaction_cat_id' => $this->input->post('category_id'),
			'payer_payee_id' => $this->input->post('payer_id'),
			'payment_method_id' => $this->input->post('payment_method'),
			'description' => $qt_description,
			'reference' => $this->input->post('deposit_reference'),		
			);
			 $result = $this->Finance_model->update_transaction_record($data,$id);
			 
    	 	// add data to bank account>cr
        		$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
        		$acc_balance = $account_id[0]->account_balance + $this->input->post('amount');
        		
        		$data3 = array(
        		'account_balance' => $acc_balance
        		);
        		$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
        		
			 
		} else {
		    $result = $this->Finance_model->read_transaction_information($id);
    	    $account_type_id =  $result[0]->account_id;
    	    $account_amt =  $result[0]->amount;
    		$account_id = $this->Finance_model->read_bankcash_information($account_type_id);
    		$acc_balance = $account_id[0]->account_balance - $account_amt;
    		$data3 = array(
    		'account_balance' => $acc_balance
    		);
    		$this->Finance_model->update_bankcash_record($data3,$account_type_id);
    		
					$fname = $this->input->post('attachment');
					 $data = array(
					'account_id' => $this->input->post('bank_cash_id'),
					'amount' => $this->input->post('amount'),
					'transaction_date' => $this->input->post('deposit_date'),
					'attachment_file' => $fname,
					'transaction_cat_id' => $this->input->post('category_id'),
					'payer_payee_id' => $this->input->post('payer_id'),
					'payment_method_id' => $this->input->post('payment_method'),
					'description' => $qt_description,
					'reference' => $this->input->post('deposit_reference'),	
					);
					// update record > model
					$result = $this->Finance_model->update_transaction_record($data,$id);
					
					// add data to bank account>cr
            		$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
            		$acc_balance = $account_id[0]->account_balance + $this->input->post('amount');
            		
            		$data3 = array(
            		'account_balance' => $acc_balance
            		);
            		$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
            		
		}
		
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_acc_success_deposit_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
		}
	}
	
	// Validate and update info in database
	public function transaction_update() {
	
		if($this->input->post('edit_type')=='deposit') {
			
		$id = $this->uri->segment(4);
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('deposit_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		}		
		/* Check if file uploaded..*/
		else if($_FILES['deposit_file']['size'] == 0) {
			 $fname = 'no_file';
			 $data = array(
			'transaction_date' => $this->input->post('deposit_date'),
			'transaction_cat_id' => $this->input->post('category_id'),
			'payer_payee_id' => $this->input->post('payer_id'),
			'payment_method_id' => $this->input->post('payment_method'),
			'description' => $qt_description,
			'reference' => $this->input->post('deposit_reference'),		
			);
			 $result = $this->Finance_model->update_transaction_record($data,$id);
		} else {
			if(is_uploaded_file($_FILES['deposit_file']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['deposit_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["deposit_file"]["tmp_name"];
					$bill_copy = "uploads/accounting/deposit/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["deposit_file"]["name"]);
					$newfilename = 'deposit_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$fname = $newfilename;
					 $data = array(
					'transaction_date' => $this->input->post('deposit_date'),
					'attachment_file' => $fname,
					'transaction_cat_id' => $this->input->post('category_id'),
					'payer_payee_id' => $this->input->post('payer_id'),
					'payment_method_id' => $this->input->post('payment_method'),
					'description' => $qt_description,
					'reference' => $this->input->post('deposit_reference'),	
					);
					// update record > model
					$result = $this->Finance_model->update_transaction_record($data,$id);
				} else {
					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				}
			}
		}
		
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_inv_transaction_edited_successfully');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
		}
	}
	
	public function read_expense()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('expense_id');
		$result = $this->Finance_model->read_transaction_information($id);
		$data = array(
				'expense_id' => $result[0]->transaction_id,
				'account_type_id' => $result[0]->account_id,
				'amount' => $result[0]->amount,
				'expense_date' => $result[0]->transaction_date,
				'categoryid' => $result[0]->transaction_cat_id,
				'payee_id' => $result[0]->payer_payee_id,
				'payee_option' => $result[0]->payee_option,
				'company_id' => $result[0]->company_id,
				'payment_method_id' => $result[0]->payment_method_id,
				'expense_reference' => $result[0]->reference,
				'expense_file' => $result[0]->attachment_file,
				'description' => $result[0]->description,
				'created_at' => $result[0]->created_at,
				'all_payees' => $this->Finance_model->all_payees(),
				'all_bank_cash' => $this->Finance_model->all_bank_cash(),
				'all_expense_types' => $this->Expense_model->all_expense_types(),
				'all_income_categories_list' => $this->Finance_model->all_income_categories_list(),
				'get_all_payment_method' => $this->Finance_model->get_all_payment_method(),
				'all_employees' => $this->Xin_model->all_employees(),
				'all_companies' => $this->Xin_model->get_companies()
				);
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	
	// Validate and update info in database
	public function expense_update_validate() {
	
			
		$id = $this->uri->segment(4);
		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} /*else if($this->input->post('amount') > $this->input->post('account_balance')) {
			$Return['error'] = $this->lang->line('xin_acc_error_amount_should_be_less_than_current');
		}*/ else if($this->input->post('expense_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_expense_date');
		} else if($this->input->post('company')==='') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if($this->input->post('employee_id')==='') {
			$Return['error'] = $this->lang->line('xin_error_employee_id');
		}	
		/* Check if file uploaded..*/
		else if($_FILES['expense_file']['size'] != 0) {
		   
			if(is_uploaded_file($_FILES['expense_file']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['expense_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["expense_file"]["tmp_name"];
					$bill_copy = "uploads/accounting/deposit/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["expense_file"]["name"]);
					$newfilename = 'expense_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
					
					// update record > model
				
				} else {
					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				}
			}
			
		}
		
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		$this->output($Return);
		exit;
	
	}
	
	public function expense_update() {
	
		if($this->input->post('edit_type')=='expense') {
			
		$id = $this->uri->segment(4);
		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} /*else if($this->input->post('amount') > $this->input->post('account_balance')) {
			$Return['error'] = $this->lang->line('xin_acc_error_amount_should_be_less_than_current');
		}*/ else if($this->input->post('expense_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_expense_date');
		} else if($this->input->post('company')==='') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if($this->input->post('employee_id')==='') {
			$Return['error'] = $this->lang->line('xin_error_employee_id');
		}	
		/* Check if file uploaded..*/
		else if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined')  {
		        $id = $this->input->post('pop_expense_ids_edit');
    		    $result = $this->Finance_model->read_transaction_information($id);
        	    $account_type_id =  $result[0]->account_id;
        	    $account_amt =  $result[0]->amount;
        		$account_id = $this->Finance_model->read_bankcash_information($account_type_id);
        // 		print_r($account_id);
        // 		exit();
        		$acc_balance = $account_id[0]->account_balance + $account_amt;
        		$data3 = array(
        		'account_balance' => $acc_balance
        		);
        		$this->Finance_model->update_bankcash_record($data3,$account_type_id);
		    
			 $fname = 'no_file';
			 $data = array(
			'account_id' => $this->input->post('bank_cash_id'),
			'amount' => $this->input->post('amount'),
			'transaction_date' => $this->input->post('expense_date'),
			'transaction_cat_id' => $this->input->post('category_id'),
			'payer_payee_id' => $this->input->post('payee_id'),
			'company_id' => $this->input->post('company'),
			'payment_method_id' => $this->input->post('payment_method'),
			'description' => $qt_description,
			'reference' => $this->input->post('expense_reference'),		
			);
			 $result = $this->Finance_model->update_transaction_record($data,$id);
			 
			 
			 $account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
			$acc_balance = $account_id[0]->account_balance - $this->input->post('amount');
			
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
			
		} else {
		    $result = $this->Finance_model->read_transaction_information($id);
    	    $account_type_id =  $result[0]->account_id;
    	    $account_amt =  $result[0]->amount;
    		$account_id = $this->Finance_model->read_bankcash_information($account_type_id);
    		$acc_balance = $account_id[0]->account_balance + $account_amt;
    		$data3 = array(
    		'account_balance' => $acc_balance
    		);
    		$this->Finance_model->update_bankcash_record($data3,$account_type_id);
			if(is_uploaded_file($_FILES['expense_file']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','gif');
				$filename = $_FILES['expense_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["expense_file"]["tmp_name"];
					$bill_copy = "uploads/accounting/deposit/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$lname = basename($_FILES["expense_file"]["name"]);
					$newfilename = 'expense_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $bill_copy.$newfilename);
					$fname = $newfilename;
					 $data = array(
					'account_id' => $this->input->post('bank_cash_id'),
					'amount' => $this->input->post('amount'),
					'transaction_date' => $this->input->post('expense_date'),
					'attachment_file' => $fname,
					'transaction_cat_id' => $this->input->post('category_id'),
					'payer_payee_id' => $this->input->post('payee_id'),
					'company_id' => $this->input->post('company'),
					'payment_method_id' => $this->input->post('payment_method'),
					'description' => $qt_description,
					'reference' => $this->input->post('expense_reference'),	
					);
					// update record > model
					$result = $this->Finance_model->update_transaction_record($data,$id);
				} else {
					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				}
			}
			$account_id = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
			$acc_balance = $account_id[0]->account_balance - $this->input->post('amount');
			
			$data3 = array(
			'account_balance' => $acc_balance
			);
			$this->Finance_model->update_bankcash_record($data3,$this->input->post('bank_cash_id'));
			
		}
		
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_acc_success_expense_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error');
		}
		$this->output($Return);
		exit;
		}
	}
	
	/****AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA*/////	
	public function accounts_ledger() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$id = $this->uri->segment(4);
		$bac_id = $this->Finance_model->read_transaction_by_bank_info($id);
		$acc_bal = $this->Finance_model->read_bankcash_information($id);
		if(is_null($bac_id)){
			redirect('admin/accounting/transactions');
		}
		$system = $this->Xin_model->read_setting_info(1);
		$data['title'] = $this->lang->line('xin_acc_ledger_account_of').' '.$acc_bal[0]->account_name;
		$data['breadcrumbs'] = $this->lang->line('xin_acc_ledger_account');
		$data['path_url'] = 'accounting_bankwise_transactions';
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(!empty($session)){ 
			if(in_array('4',$role_resources_ids)) {
				$data['subview'] = $this->load->view("admin/accounting/ledger_account_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard');
			}
		} else {
			redirect('admin/');
		}
	}
	
	public function ledger_accounts() {
	
		$system = $this->Xin_model->read_setting_info(1);
		$data['title'] = $this->lang->line('xin_acc_ledger_account').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_ledger_account');
		$data['path_url'] = 'xin_ledger_accounts';
		$session = $this->session->userdata('username');
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(!empty($session)){ 
			if(in_array('4',$role_resources_ids)) {
				$data['subview'] = $this->load->view("admin/accounting/full_ledger_account_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard');
			}
		} else {
			redirect('admin/');
		}
	}
	
	public function account_statement() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_account_statement').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_account_statement');
		$data['path_url'] = 'accounting_report_statement';
		$data['all_bank_cash'] = $this->Finance_model->all_bank_cash();
		$data['all_income_categories_list'] = $this->Finance_model->all_income_categories_list();
		$data['get_all_payment_method'] = $this->Finance_model->get_all_payment_method();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('651',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/report_account_statement", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function expense_report() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_expense_reports').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_expense_reports');
		$data['path_url'] = 'accounting_report_expense';
		$data['all_bank_cash'] = $this->Finance_model->all_bank_cash();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_expense_types'] = $this->Expense_model->all_expense_types();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('652',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/report_expense", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function income_report() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_income_reports').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_income_reports');
		$data['path_url'] = 'accounting_report_income';
		$data['all_bank_cash'] = $this->Finance_model->all_bank_cash();
		$data['all_income_categories_list'] = $this->Finance_model->all_income_categories_list();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('653',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/report_income", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function transfer_report() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_accounting!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('xin_acc_transfer_report').' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_transfer_report');
		$data['path_url'] = 'accounting_report_transfer';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('654',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/accounting/report_transfer", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
		
	public function read_transfer()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('transfer_id');
		$result = $this->Finance_model->read_transfer_information($id);
		$data = array(
				'transfer_id' => $result[0]->transfer_id,
				'from_account_id' => $result[0]->from_account_id,
				'to_account_id' => $result[0]->to_account_id,
				'transfer_date' => $result[0]->transfer_date,
				'transfer_amount' => $result[0]->transfer_amount,
				'payment_method_id' => $result[0]->payment_method,
				'transfer_reference' => $result[0]->transfer_reference,
				'description' => $result[0]->description,
				'created_at' => $result[0]->created_at,
				'all_bank_cash' => $this->Finance_model->all_bank_cash(),
				'get_all_payment_method' => $this->Finance_model->get_all_payment_method()
				);
		if(!empty($session)){ 
			$this->load->view('admin/accounting/dialog_accounting', $data);
		} else {
			redirect('admin/');
		}
	}
	 
	 /****Reports ***/
    	 
	// report account statement > search
	public function report_statement_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/report_account_statement", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
				
		$transactions = $this->Finance_model->account_statement_search($this->input->get('from_date'),$this->input->get('to_date'),$this->input->get('account_id'));
		
		$data = array();
		$crd_total = 0; $deb_total = 0;$balance=0; $balance2 = 0;
        foreach($transactions->result() as $r) {
			  
		   // transaction date
			$transaction_date = $this->Xin_model->set_date_format($r->transaction_date);
			// get currency
			$total_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account_balance = $acc_type[0]->account_opening_balance;
			} else {
				$account_balance = 0;	
			}
			
			if($r->dr_cr == 'cr') {
				$balance2 = $balance2 - $r->amount;
			} else {
				$balance2 = $balance2 + $r->amount;
			}
			if($r->credit!=0):
				$crd = $r->credit;
				$crd_total += $crd;
			else:
				$crd = 0;	
				$crd_total += $crd;
			endif;
			if($r->debit!=0):
				$deb = $r->debit;
				$deb_total += $deb;
			else:
				$deb = 0;	
				$deb_total += $deb;
			endif;
			//$fbalance = $account_balance + $balance2;
			
			$data[] = array(
				$transaction_date,
				$r->transaction_type,
				$r->description,
				$this->Xin_model->company_currency_sign($crd,$r->company_id),
				$this->Xin_model->company_currency_sign($deb,$r->company_id)
		   );
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $transactions->num_rows(),
                 "recordsFiltered" => $transactions->num_rows(),
                 "data" => $data
            );
          $output['csrf_hash'] = $this->security->get_csrf_hash();
          echo json_encode($output);
          exit();
     }
     
     public function account_statement_pdf_get(){
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;

      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $system = $this->Xin_model->read_setting_info(1);
      $p_method = '';
      if (!is_null($company)) {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;

          if ($company_logo) {
              $logo = '../../../../../uploads/company/' . $company_logo;
          } else {
              $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
          }

      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }

      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
        
        
        $transactions = $this->Finance_model->account_statement_search($this->input->post('p_from_date'),$this->input->post('p_to_date'),$this->input->post('p_account'));


		$data = array();
		$crd_total = 0;
		$deb_total = 0;
		$balance=0; 
		$balance2 = 0;
        foreach($transactions->result() as $r) {
			  
		   // transaction date
			$transaction_date = $this->Xin_model->set_date_format($r->transaction_date);
			// get currency
			$total_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account_balance = $acc_type[0]->account_opening_balance;
			} else {
				$account_balance = 0;	
			}
			
			if($r->dr_cr == 'cr') {
				$balance2 = $balance2 - $r->amount;
			} else {
				$balance2 = $balance2 + $r->amount;
			}
			if($r->credit!=0):
				$crd = $r->credit;
				$crd_total += $crd;
			else:
				$crd = 0;	
				$crd_total += $crd;
			endif;
			
			if($r->debit!=0):
				$deb = $r->debit;
				$deb_total += $deb;
			else:
				$deb = 0;	
				$deb_total += $deb;
			endif;
			
			
			//$fbalance = $account_balance + $balance2;
			
			$data[] = array(
				"transaction_date" => $transaction_date,
				"transaction_type" => $r->transaction_type,
				"description" => $r->description,
				"credit" => $this->Xin_model->company_currency_sign($crd,$r->company_id),
				"debit" => $this->Xin_model->company_currency_sign($deb,$r->company_id)
		   );
          }
          
          $this->load->library('M_pdf');
          $mpdf = $this->m_pdf->load([
             'mode' => 'utf-8',
             'format' => 'A4'
          ]);
          $res['lists'] = $data;
          $res['crd_total'] = $crd_total;
          $res['deb_total'] = $deb_total;
          $res['header_string'] = $email_phone_address;
          $res['company_name'] = $company_name;
          $res['logo'] = $logo;
          $html = $this->load->view("admin/accounting/account_statement_pdf_format", $res, true);
          $mpdf->WriteHTML($html);
          $mpdf->Output('account_statement_report.pdf', 'D'); //
     }
	 
	 // get statement footer - data
	 public function get_statement_footer() {

		$data['title'] = $this->Xin_model->site_title();
		
		$data = array(
			'from_date' => $this->input->get('from_date'),
			'to_date' => $this->input->get('to_date'),
			'account_id' => $this->input->get('account_id')
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/footer/get_statement_footer", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 
	 // report expense list
	public function report_expense_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/report_expense", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$expense = $this->Finance_model->get_expense_search($this->input->get('from_date'),$this->input->get('to_date'),$this->input->get('type_id'),$this->input->get('company_id'));
		
		$data = array();

          foreach($expense->result() as $r) {
			  
			// get amount
			$amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			// account type
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account = $acc_type[0]->account_name;
			} else {
				$account = '--';	
			}
			
			/*// get payee
			$payee = $this->Xin_model->read_user_info($r->payer_payee_id);
			// user full name
			if(!is_null($payee)){
				$full_name = $payee[0]->first_name.' '.$payee[0]->last_name;
			} else {
				$full_name = '--';	
			}*/
			
			// get user > added by
			if($r->payee_option == 1){
				$payee = $this->Xin_model->read_user_info($r->payer_payee_id);
				// user full name
				if(!is_null($payee)){
					$full_name = $payee[0]->first_name.' '.$payee[0]->last_name;
				} else {
					$full_name = '--';	
				}
			} else {
				$payee = $this->Finance_model->read_payee_info($r->payer_payee_id);
				// user full name
				if(!is_null($payee)){
					$full_name = $payee[0]->payee_name;
				} else {
					$full_name = '--';	
				}
			}
			
			// deposit date
			$expense_date = $this->Xin_model->set_date_format($r->transaction_date);
			// category
			$expense_type = $this->Expense_model->read_expense_type_information($r->transaction_cat_id);
			if(!is_null($expense_type)){
				$category = $expense_type[0]->name;
			} else {
				$category = '--';	
			}
			
		   $data[] = array(
				$expense_date,
				$account,
				$category,
				$full_name,
				$amount,
		   );
	  }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $expense->num_rows(),
			 "recordsFiltered" => $expense->num_rows(),
			 "data" => $data
		);
	  $output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
     }
     
    public function report_accounting_pdf_get(){

	  $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;
      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

      $company_id = $this->input->post('p_company_id');
      $type_id = $this->input->post('p_type_id');
      $start_date = $this->input->post('p_from_date');
      $end_date = $this->input->post('p_to_date');


    $expense = $this->Finance_model->get_expense_search($start_date, $end_date, $type_id, $company_id);

    $expense_count = $this->Finance_model->get_expense_search_count($start_date, $end_date, $type_id, $company_id);

    	//empty data display code start
	    if(empty($expense_count)){
	    	$logo_empty = "<img src='".$logo."' style='width:25%;'>";
            $company_name_empty = $company_name;
            $email_phone_address_empty = $email_phone_address;
	    	$empty_text = 'No Data Available In PDF';
	    }else{
	    	$logo_empty = '';
            $company_name_empty = '';
            $email_phone_address_empty = '';
	    	$empty_text = '';
	    }
	    //empty data display code end
  
        $data = array();

		foreach($expense_count as $key => $val) {


		   
          $company = $this->Xin_model->read_company_info($val['company_id']);


          if (!is_null($company)) 
          {
             $company_name = $company[0]->name;
             $address_1 = $company[0]->address_1;
             $address_2 = $company[0]->address_2;
             $city = $company[0]->city;
             $state = $company[0]->state;
             $company_logo = $company[0]->logo;
             $zipcode = $company[0]->zipcode;
             $country = $this->Xin_model->read_country_info($company[0]->country);
             if (!is_null($country)) {
                $country_name = $country[0]->country_name;
             } else {
                $country_name = '--';
             }
             $c_info_email = $company[0]->email;
             $c_info_phone = $company[0]->contact_number;
             if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
             } else {
                // $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
                $logo = '';
             }
          } else {
             $company_name = '';
             $address_1 = '';
             $address_2 = '';
             $city = '';
             $state = '';
             $zipcode = '';
             $country_name = '';
             $c_info_email = '';
             $c_info_phone = '';
             $logo = '';
          }
            $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

            $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
            
            if(!empty($company_name)){
                $expense_count[$key]['header_string'] = $email_phone_address;
            }else{
                $expense_count[$key]['header_string'] = '';
            }
            
            if(!empty($company_name)){
                $expense_count[$key]['company_name'] = $company_name;
            }else{
                $expense_count[$key]['company_name'] = 'External Payees';
            }
            
            if(!empty($logo)){
                $expense_count[$key]['logo'] = "<img src='".$logo."' style='width:25%;'>";
            }else{
                $expense_count[$key]['logo'] = '';
            }
            
            
        }


    foreach($expense->result() as $r) {
        
      // get amount
      $amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
      
      // account type
      $acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
      if(!is_null($acc_type)){
        $account = $acc_type[0]->account_name;
      } else {
        $account = '--';  
      }
      
      // get user > added by
      if($r->payee_option == 1){
        $payee = $this->Xin_model->read_user_info($r->payer_payee_id);
        // user full name
        if(!is_null($payee)){
          $full_name = $payee[0]->first_name.' '.$payee[0]->last_name;
        } else {
          $full_name = '--';  
        }
      } else {
        $payee = $this->Finance_model->read_payee_info($r->payer_payee_id);
        // user full name
        if(!is_null($payee)){
          $full_name = $payee[0]->payee_name;
        } else {
          $full_name = '--';  
        }
      }
      
      // deposit date
      $expense_date = $this->Xin_model->set_date_format($r->transaction_date);
      
      // category
      $expense_type = $this->Expense_model->read_expense_type_information($r->transaction_cat_id);
      if(!is_null($expense_type)){
        $category = $expense_type[0]->name;
      } else {
        $category = '--'; 
      }
      
       $data[] = array(
        'expense_date' => $expense_date,
        'account' => $account,
        'category' => $category,
        'full_name' => $full_name,
        'amount' => $amount,
        'company_id' => $r->company_id
       );
    }


     $this->load->library('M_pdf');
      $mpdf = $this->m_pdf->load([
         'mode' => 'utf-8',
         'format' => 'A4'
      ]);
      $res['lists'] = $data;
      $res['expense_count'] = $expense_count;
      $res['from_date'] = $start_date;
      $res['to_date'] = $end_date;
      $res['company_id'] = $company_id;
      $res['type_id'] = $type_id;
      $res['empty_text'] = $empty_text;
      $res['header_string'] = $email_phone_address_empty;
      $res['company_name'] = $company_name_empty;
      $res['logo'] = $logo_empty;
      $html = $this->load->view("admin/accounting/expense_report_pdf_format", $res, true);
      $mpdf->WriteHTML($html);
      $mpdf->Output('Expense_Report.pdf', 'D'); //


    } 
	 
	 // get expense footer - data
	 public function get_expense_footer() {

		$data['title'] = $this->Xin_model->site_title();
		
		$data = array(
			'from_date' => $this->input->get('from_date'),
			'to_date' => $this->input->get('to_date'),
			'type_id' => $this->input->get('type_id'),
			'company_id' => $this->input->get('company_id')
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/footer/get_expense_footer", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 
	 // income report list
	public function report_income_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/report_income", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$deposit = $this->Finance_model->get_deposit_search($this->input->get('from_date'),$this->input->get('to_date'),$this->input->get('type_id'));
		
		$data = array();

          foreach($deposit->result() as $r) {
			  
			// account type
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account = $acc_type[0]->account_name;
			} else {
				$account = '--';	
			}
			
			// get payee
			$payer = $this->Finance_model->read_payer_info($r->payer_payee_id);
			// user full name
			if(!is_null($payer)){
				$full_name = $payer[0]->payer_name;
			} else {
				$full_name = '--';	
			}
			
			// deposit date
			$deposit_date = $this->Xin_model->set_date_format($r->transaction_date);
			// category
			$category_id = $this->Finance_model->read_income_category($r->transaction_cat_id);
			if(!is_null($category_id)){
				$category = $category_id[0]->name;
			} else {
				$category = '--';	
			}
			// get amount
			$amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);

		   $data[] = array(
				$deposit_date,
				$account,
				$category,
				$full_name,
				$amount		
		   );
	  }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $deposit->num_rows(),
			 "recordsFiltered" => $deposit->num_rows(),
			 "data" => $data
		);
	  $output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
     } 
     
    public function income_report_pdf_get(){

      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;

      $type_id = $this->input->post('p_type_id');
      $start_date = $this->input->post('p_from_date');
      $end_date = $this->input->post('p_to_date');

      $deposit = $this->Finance_model->get_deposit_search($start_date, $end_date, $type_id);

      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $system = $this->Xin_model->read_setting_info(1);
      $p_method = '';
      if (!is_null($company)) {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;

          if ($company_logo) {
              $logo = '../../../../../uploads/company/' . $company_logo;
          } else {
              $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
          }

      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }

      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


    $data = array();
    $total_amount = 0;
    foreach($deposit->result() as $r) {
        
      // account type
      $acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
      if(!is_null($acc_type)){
        $account = $acc_type[0]->account_name;
      } else {
        $account = '--';  
      }
      
      // get payee
      $payer = $this->Finance_model->read_payer_info($r->payer_payee_id);
      // user full name
      if(!is_null($payer)){
        $full_name = $payer[0]->payer_name;
      } else {
        $full_name = '--';  
      }
      
      // deposit date
      $deposit_date = $this->Xin_model->set_date_format($r->transaction_date);
      // category
      $category_id = $this->Finance_model->read_income_category($r->transaction_cat_id);
      if(!is_null($category_id)){
        $category = $category_id[0]->name;
      } else {
        $category = '--'; 
      }
      // get amount
      $amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
      
      $total_amount += $r->amount;

       $data[] = array(
              'deposit_date' => $deposit_date,
              'account' => $account,
              'category' => $category,
              'full_name' => $full_name,
              'amount' => $amount,
       );
    }


     $this->load->library('M_pdf');
      $mpdf = $this->m_pdf->load([
         'mode' => 'utf-8',
         'format' => 'A4'
      ]);
      $res['lists'] = $data;
      $res['from_date'] = $start_date;
      $res['to_date'] = $end_date;
      $res['total_amount'] = $total_amount;
      $res['header_string'] = $email_phone_address;
      $res['company_name'] = $company_name;
      $res['logo'] = $logo;
      $html = $this->load->view("admin/accounting/income_report_pdf_format", $res, true);
      $mpdf->WriteHTML($html);
      $mpdf->Output('Income_Report.pdf', 'D'); //


    }
	 
	// report transfer list
    public function report_transfer_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/report_transfer", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$transfer = $this->Finance_model->get_transfer_search($this->input->get('from_date'),$this->input->get('to_date'));
		
		$data = array();

        foreach($transfer->result() as $r) {
			  
			// get amount
			$amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			if($r->dr_cr == 'cr') {
				$xin_acc = $this->lang->line('xin_acc_credit');
			} else {
				$xin_acc = $this->lang->line('xin_acc_debit');
			}			
			// transfer date
			$transfer_date = $this->Xin_model->set_date_format($r->transaction_date);
			// payment method 
			$payment_method = $this->Xin_model->read_payment_method($r->payment_method_id);
			if(!is_null($payment_method)){
				$method_name = $payment_method[0]->method_name;
			} else {
				$method_name = '--';	
			}
			$r->dr_cr=="dr" ? $this->lang->line('xin_acc_debit') : $this->lang->line('xin_acc_credit');
			$r->debit!=NULL ? $db_am = "- ".$this->Xin_model->company_currency_sign($r->debit,$r->company_id) : $db_am ="";
			$r->credit!=NULL ? $cr_am = "+ ".$this->Xin_model->company_currency_sign($r->credit,$r->company_id) : $cr_am ="";
			// account type
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account = $acc_type[0]->account_name;
			} else {
				$account = '--';	
			}
		   $data[] = array(
				$transfer_date,
				$r->description,
				$account,
				$xin_acc,
				$db_am,
				$cr_am
		   );
	  }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $transfer->num_rows(),
			 "recordsFiltered" => $transfer->num_rows(),
			 "data" => $data
		);
	  $output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
     } 

    public function transfer_report_pdf_get(){

      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;

      $start_date = $this->input->post('p_from_date');
      $end_date = $this->input->post('p_to_date');

      $transfer = $this->Finance_model->get_transfer_search($start_date, $end_date);

      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $system = $this->Xin_model->read_setting_info(1);
      $p_method = '';
      if (!is_null($company)) {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;

          if ($company_logo) {
              $logo = '../../../../../uploads/company/' . $company_logo;
          } else {
              $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
          }

      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }

      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


    $data = array();
    $total_amount = 0;
    foreach($transfer->result() as $r) {
        
      // get amount
      $amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
      if($r->dr_cr == 'cr') {
        $xin_acc = $this->lang->line('xin_acc_credit');
      } else {
        $xin_acc = $this->lang->line('xin_acc_debit');
      }     
      // transfer date
      $transfer_date = $this->Xin_model->set_date_format($r->transaction_date);
      // payment method 
      $payment_method = $this->Xin_model->read_payment_method($r->payment_method_id);
      if(!is_null($payment_method)){
        $method_name = $payment_method[0]->method_name;
      } else {
        $method_name = '--';  
      }
      $r->dr_cr=="dr" ? $this->lang->line('xin_acc_debit') : $this->lang->line('xin_acc_credit');
      $r->debit!=NULL ? $db_am = "- ".$this->Xin_model->company_currency_sign($r->debit,$r->company_id) : $db_am ="";
      $r->credit!=NULL ? $cr_am = "+ ".$this->Xin_model->company_currency_sign($r->credit,$r->company_id) : $cr_am ="";
      // account type
      $acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
      if(!is_null($acc_type)){
        $account = $acc_type[0]->account_name;
      } else {
        $account = '--';  
      }

      $total_amount += $r->amount;
       $data[] = array(
                'transfer_date' => $transfer_date,
                'description' => $r->description,
                'account' => $account,
                'xin_acc' => $xin_acc,
                'db_am' => $db_am,
                'cr_am' => $cr_am
       );
    }


     $this->load->library('M_pdf');
      $mpdf = $this->m_pdf->load([
         'mode' => 'utf-8',
         'format' => 'A4'
      ]);
      $res['lists'] = $data;
      $res['from_date'] = $start_date;
      $res['to_date'] = $end_date;
      $res['total_amount'] = $total_amount;
      $res['header_string'] = $email_phone_address;
      $res['company_name'] = $company_name;
      $res['logo'] = $logo;
      $html = $this->load->view("admin/accounting/transfer_report_pdf_format", $res, true);
      $mpdf->WriteHTML($html);
      $mpdf->Output('Transfer_Report.pdf', 'D'); //


    }
	 
	 // report income vs expense > search
	public function report_income_expense_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
				
		$account_statement = $this->Finance_model->get_income_expense_search($this->input->get('from_date'),$this->input->get('to_date'));
		
		$data = array();
		$debit="";
		$debit_total=0;
		$credit="";
		$credit_total=0;
        foreach($account_statement->result() as $r) {
			  		  
			if($r->transaction_credit!=0.00 && $r->transaction_credit > 0){
				$credit_total=$credit_total+$r->transaction_credit;
			}
			else if($r->transaction_debit!=0.00 && $r->transaction_debit > 0){
				$debit_total = $debit_total+$r->transaction_debit;
			}
		 }
		 
		 $totalD = "<b class='pull-right'>".$this->lang->line('xin_acc_total_credit').": ".$this->Xin_model->company_currency_sign($debit_total,$r->company_id)."</b>";
		 $totalC = "<b class='pull-right'>".$this->lang->line('xin_acc_total_debit').": ".$this->Xin_model->company_currency_sign($credit_total,$r->company_id)."</b>";
		 $data[] = array(
			$totalC.' '.$totalC,
			$totalD.' '.$totalD
	   );
          
          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $account_statement->num_rows(),
                 "recordsFiltered" => $account_statement->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	 
	 // ***** LISTING 
	 // sales_report_list
	public function accounts_ledger_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/full_ledger_account_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$acc_ledger = $this->Finance_model->get_ledger_accounts($this->input->get('from_date'),$this->input->get('to_date'));
		
		$data = array();
		$crd_total = 0; $deb_total = 0;$balance=0; $balance2 = 0;
        foreach($acc_ledger->result() as $r) {
			  
			// transaction date
			$transaction_date = $this->Xin_model->set_date_format($r->transaction_date);
			// get currency
			$total_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			$acc_type = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($acc_type)){
				$account_balance = $acc_type[0]->account_opening_balance;
			} else {
				$account_balance = 0;	
			}
			
			if($r->dr_cr == 'cr') {
				$balance2 = $balance2 - $r->amount;
			} else {
				$balance2 = $balance2 + $r->amount;
			}
			if($r->credit!=0):
				$crd = $r->credit;
				$crd_total += $crd;
			else:
				$crd = 0;	
				$crd_total += $crd;
			endif;
			if($r->debit!=0):
				$deb = $r->debit;
				$deb_total += $deb;
			else:
				$deb = 0;	
				$deb_total += $deb;
			endif;
			$fbalance = $account_balance + $balance2;
			
		   $data[] = array(
				$transaction_date,
				$r->transaction_type,
				$r->description,
				$this->Xin_model->company_currency_sign($crd,$r->company_id),
				$this->Xin_model->company_currency_sign($deb,$r->company_id),
				$this->Xin_model->company_currency_sign($fbalance,$r->company_id)
		   );
	  }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $acc_ledger->num_rows(),
			 "recordsFiltered" => $acc_ledger->num_rows(),
			 "data" => $data
		);
	  echo json_encode($output);
	  exit();
     } 
	 
	 // get sales footer - data
	 public function get_accounts_ledger_footer() {

		$data['title'] = $this->Xin_model->site_title();
		
		$data = array(
			'from_date' => $this->input->get('from_date'),
			'to_date' => $this->input->get('to_date')
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/footer/get_ledger_accounts_footer", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 // Validate and add info in database
	public function add_payer() {
	
		if($this->input->post('add_type')=='add_payer') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */		
		if($this->input->post('payer_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payer_name');
		}else if($this->input->post('contact_number')==='') {
        	$Return['error'] = "Contact Number Required";
		}else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_number'))) {
            $Return['error'] = 'Invalid contact number';
		//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
		}
		
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
    	
    	$payer              = $this->input->post('payer_name');
	    $contact_number     = $this->input->post('contact_number');
		
		$payercheck = $this->Xin_model->checkpayer_exists($payer,$contact_number);
				
		 if($payercheck > 0) 
		{
			$Return['error'] = "Payer Exist";
			$this->output($Return);
		}
	
		$data = array(
		'payer_name' => $this->input->post('payer_name'),
		'contact_number' => $this->input->post('contact_number'),
		'created_at' => date('d-m-Y h:i:s')
		);
		
		$result = $this->Finance_model->add_payer_record($data);
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_acc_success_payer_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	// Validate and add info in database
	public function add_payee() {
	
		if($this->input->post('add_type')=='add_payee') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */		
		if($this->input->post('payee_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payee_name');
		}else if($this->input->post('contact_number')==='') {
        	$Return['error'] = "Contact Number Required";
		}else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_number'))) {
            $Return['error'] = 'Invalid contact number';
		//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
		}
		
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	 
	 $payee = $this->input->post('payee_name');
	 $contact_number=$this->input->post('contact_number');
		
	/*	$hello = $this->Xin_model->read_contact_number($contact_number);*/
		$payeecheck = $this->Xin_model->checkpayee_exists($payee,$contact_number);
				
		 if($payeecheck > 0) 
		{
			$Return['error'] = "Payee Exist";
			$this->output($Return);
		}
		
	   
	
		$data = array(
		'payee_name' => $this->input->post('payee_name'),
		'contact_number' => $this->input->post('contact_number'),
		'created_at' => date('d-m-Y h:i:s')
		);
		
		
		
		$result = $this->Finance_model->add_payee_record($data);
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_acc_success_payee_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
	    
		}
	}
	
	// Validate and add info in database
	public function update_payer_validate() {
	
		if($this->input->post('edit_type')=='payer') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		/* Server side PHP input validation */		
		if($this->input->post('payer_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payer_name');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'payer_name' => $this->input->post('payer_name'),
		'contact_number' => $this->input->post('contact_number'),
		);
		
		$result = $this->Finance_model->update_payer_record($data,$id);
		if ($id) {
			$Return['result'] = $this->lang->line('xin_acc_success_payer_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	public function update_payer() {
	
		if($this->input->post('edit_type')=='payer') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		/* Server side PHP input validation */		
		if($this->input->post('payer_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payer_name');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'payer_name' => $this->input->post('payer_name'),
		'contact_number' => $this->input->post('contact_number'),
		);
		
		$result = $this->Finance_model->update_payer_record($data,$id);
		if ($id) {
			$Return['result'] = $this->lang->line('xin_acc_success_payer_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	// Validate and add info in database
	public function update_payee_validate() {
	
		if($this->input->post('edit_type')=='payee') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		/* Server side PHP input validation */		
		if($this->input->post('payee_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payee_name');
		}else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_number'))) {
            $Return['error'] = 'Invalid phone number';
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
	    $this->output($Return);
		exit;
		}
	}
	
	public function update_payee() {
	
		if($this->input->post('edit_type')=='payee') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		/* Server side PHP input validation */		
		if($this->input->post('payee_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payee_name');
		}else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_number'))) {
            $Return['error'] = 'Invalid phone number';
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'payee_name' => $this->input->post('payee_name'),
		'contact_number' => $this->input->post('contact_number'),
		);
		
		$result = $this->Finance_model->update_payee_record($data,$id);
		if ($id) {
			$Return['result'] = $this->lang->line('xin_acc_success_payee_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	// delete record
	public function delete_payer() {
		
		if($this->input->post('is_ajax')=='2') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Finance_model->delete_payer_record($id);
			if(isset($id)) {
				$Return['result'] = $this->lang->line('xin_acc_success_payer_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	// delete record
	public function delete_payee() {
		
		if($this->input->post('is_ajax')=='2') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Finance_model->delete_payee_record($id);
			if(isset($id)) {
				$Return['result'] = $this->lang->line('xin_acc_success_payee_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	// bank wise transactions list
	public function bankwise_transactions_list() {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/accounting/full_ledger_account_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$ac_id = $this->uri->segment(4);
		$transactions = $this->Finance_model->get_bankwise_transactions($ac_id);
		
		$data = array();
		$balance2 = 0;
          foreach($transactions->result() as $r) {
			  
			// transaction date
			$transaction_date = $this->Xin_model->set_date_format($r->transaction_date);
			// get currency
			$total_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			// bank account
			$baccount = $this->Finance_model->read_bankcash_information($r->account_id);
			if(!is_null($baccount)) {
				
				$account_balance = 0;
				$account_balance = $baccount[0]->account_opening_balance;//str_replace(',','',$baccount[0]->account_opening_balance);
				if($account_balance == ''){
					$account_balance = 0;
				} else {
					$account_balance = $account_balance;
				}
				// balance
				if($r->dr_cr == 'cr') {
					$dr_amount = $this->Xin_model->company_currency_sign(0,$r->company_id);
					$cr_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
					$balance2 = $balance2 - $r->credit;
					//$db_amount = $balance2 - $r->account_opening_balance;
				} else {
					$dr_amount = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
					$cr_amount = $this->Xin_model->company_currency_sign(0,$r->company_id);
					$balance2 = $balance2 + $r->debit;
				}
				
				$fbalance = $account_balance + $balance2;
				$fbalance = $this->Xin_model->company_currency_sign($fbalance,$r->company_id);
				
				$data[] = array(
					$transaction_date,
					$r->transaction_type,
					$r->description,
					$cr_amount,
					$dr_amount,
					$fbalance
				);
			}
          }

          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $transactions->num_rows(),
                 "recordsFiltered" => $transactions->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     } 	
	 // get income footer - data
	 public function get_income_footer() {

		$data['title'] = $this->Xin_model->site_title();
		
		$data = array(
			'from_date' => $this->input->get('from_date'),
			'to_date' => $this->input->get('to_date'),
			'type_id' => $this->input->get('type_id')
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/footer/get_income_footer", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 // get transfer footer - data
	 public function get_transfer_footer() {

		$data['title'] = $this->Xin_model->site_title();
		
		$data = array(
			'from_date' => $this->input->get('from_date'),
			'to_date' => $this->input->get('to_date')
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/accounting/footer/get_transfer_footer", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 // get company > payee
	 public function get_all_payee() {

		$data['title'] = $this->Xin_model->site_title();
		$id = 1;		
		$data = array(
		'hrsale' => $id
		);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$data = $this->security->xss_clean($data);
			$this->load->view("admin/accounting/get_all_payee", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 ////////////////////////////////////////////////////////////////////////////////
	 public function add_bankcash_validate() {
	
		if($this->input->post('add_type')=='bankcash') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		$bank_branch = $this->input->post('bank_branch');
		$account_number =$this->input->post('account_number');
		$qt_bank_branch = htmlspecialchars(addslashes($bank_branch), ENT_QUOTES);
			
		/* Server side PHP input validation */
		if($this->input->post('account_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_account_name_field');
		} else if($this->input->post('account_balance')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_account_balance_field');
		} 
		else if($this->input->post('account_number')==='') {
			$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
		}
		
		$hello= $this->Xin_model->read_account_template($account_number);

		
		 if($hello) 
		{
			$Return['error'] = "Account Exist";
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	    $Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
		}
	} 
	/////////////////////////////////////////////////////////////////////////////////////////////
		public function add_deposit_validate() {
	
		if($this->input->post('add_type')=='deposit') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('deposit_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_deposit_date');
		}
		else if($_FILES['deposit_file']['size'] == 0) {
			$fname = 'no_file';
		}
		else if(is_uploaded_file($_FILES['deposit_file']['tmp_name'])) {
			//checking image type
			//$Return['error'] = $this->lang->line('xin_acc_error_attachment');
			$allowed =  array('PNG','JPG','JPEG','PDF','GIF','png','jpg','jpeg','pdf','gif','txt','doc','docx','xls','xlsx');
			$filename = $_FILES['deposit_file']['name'];
			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			
			if(in_array($ext,$allowed)){
				$tmp_name = $_FILES["deposit_file"]["tmp_name"];
				$profile = "uploads/accounting/deposit/";
				$set_img = base_url()."uploads/accounting/deposit/";
				// basename() may prevent filesystem traversal attacks;
				// further validation/sanitation of the filename may be appropriate
				$name = basename($_FILES["deposit_file"]["name"]);
				$newfilename = 'deposit_'.round(microtime(true)).'.'.$ext;
				move_uploaded_file($tmp_name, $profile.$newfilename);
				$fname = $newfilename;	
				$Return['fileName'] = $fname;
			} else {
				$Return['error'] = $this->lang->line('xin_acc_error_attachment');
			}
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
    	$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
	
		
		}
	} 
	///////////////////////////////////////////////////////////////////////////////////////////
	public function add_expense_validate() {
	
		if($this->input->post('add_type')=='expense') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		$bank_cash = $this->Finance_model->read_bankcash_information($this->input->post('bank_cash_id'));
		if($this->input->post('bank_cash_id')==='') {
        $Return['error'] = $this->lang->line('xin_acc_error_account_field');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('amount') > $bank_cash[0]->account_balance) {
			$Return['error'] = $this->lang->line('xin_acc_error_amount_should_be_less_than_current');
		} else if($this->input->post('expense_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_expense_date');
		} else if($this->input->post('company')==='') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if($this->input->post('payee_id')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_payee_name');
		}
		else if($_FILES['expense_file']['size'] == 0) {
			$fname = 'no_file';
		}
		else if(is_uploaded_file($_FILES['expense_file']['tmp_name'])) {
			//checking image type
			$allowed =  array('png','jpg','jpeg','pdf','gif','txt','doc','docx','xls','xlsx');
			$filename = $_FILES['expense_file']['name'];
			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			
			if(in_array($ext,$allowed)){
				$tmp_name = $_FILES["expense_file"]["tmp_name"];
				$profile = "uploads/accounting/expense/";
				$set_img = base_url()."uploads/accounting/expense/";
				// basename() may prevent filesystem traversal attacks;
				// further validation/sanitation of the filename may be appropriate
				$name = basename($_FILES["expense_file"]["name"]);
				$newfilename = 'expense_'.round(microtime(true)).'.'.$ext;
				move_uploaded_file($tmp_name, $profile.$newfilename);
				$fname = $newfilename;	
				$Return['fileName'] = $fname;
			} else {
				$Return['error'] = $this->lang->line('xin_acc_error_attachment');
			}
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
	
		
		}
	} 
	public function add_transfer_validate() {
	
		if($this->input->post('add_type')=='transfer') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$description = $this->input->post('description');
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('from_bank_cash_id')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_from_account');
		} else if($this->input->post('to_bank_cash_id')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_to_account');
		} else if($this->input->post('from_bank_cash_id')== $this->input->post('to_bank_cash_id')) {
        	$Return['error'] = $this->lang->line('xin_acc_error_transer_to_same_account');
		} else if($this->input->post('transfer_date')==='') {
			$Return['error'] = $this->lang->line('xin_acc_error_transer_date');
		} else if($this->input->post('amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if($this->input->post('amount') > $this->input->post('account_balance')) {
			$Return['error'] = $this->lang->line('xin_acc_error_amount_should_be_less_than_current');
		}
						
		if($Return['error']!=''){
       		$this->output($Return);
    	}
    	$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
	
		
		}
	}
	public function add_payee_validate() {
	
		if($this->input->post('add_type')=='add_payee') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */		
		if($this->input->post('payee_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payee_name');
		}else if($this->input->post('contact_number')==='') {
        	$Return['error'] = "Contact Number Required";
		}else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_number'))) {
            $Return['error'] = 'Invalid contact number';
		//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
		}
		
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	 
	 $payee = $this->input->post('payee_name');
	 $contact_number=$this->input->post('contact_number');
		
	/*	$hello = $this->Xin_model->read_contact_number($contact_number);*/
		$payeecheck = $this->Xin_model->checkpayee_exists($payee,$contact_number);
				
		 if($payeecheck > 0) 
		{
			$Return['error'] = "Payee Exist";
			$this->output($Return);
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
	    
		}
	}
	public function add_payer_validate() {
	
		if($this->input->post('add_type')=='add_payer') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */		
		if($this->input->post('payer_name')==='') {
        	$Return['error'] = $this->lang->line('xin_acc_error_payer_name');
		}else if($this->input->post('contact_number')==='') {
        	$Return['error'] = "Contact Number Required";
		}else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_number'))) {
            $Return['error'] = 'Invalid contact number';
		//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
		}
		
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
    	
    	$payer              = $this->input->post('payer_name');
	    $contact_number     = $this->input->post('contact_number');
		
		$payercheck = $this->Xin_model->checkpayer_exists($payer,$contact_number);
				
		 if($payercheck > 0) 
		{
			$Return['error'] = "Payer Exist";
			$this->output($Return);
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
		}
	}
}
