<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Airticket extends MY_Controller
{

	public function __construct()
	{
		parent::__construct();
		//load the model
		$this->load->model("Airticket_model");
		$this->load->model("Xin_model");
		$this->load->library('email');
		$this->load->model("Designation_model");
		$this->load->model("Department_model");
		$this->load->model("Custom_fields_model");
		$this->load->model("Employees_model");
		$this->load->model("Timesheet_model");
	}

	/*Function to set JSON output*/
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

	public function index()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}
// 		$data['title'] = 'Airtickets' . ' | ' . $this->Xin_model->site_title();
		$data['title'] = 'Air Ticket Issue' ;
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['breadcrumbs'] = 'Air Ticket Issue';
		$data['path_url'] = 'Airtickets';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('290', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/airticket/airticket_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// get company > departments
	public function get_ticket_departments()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/get_ticket_departments", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}
	public function get_ticket_departments_edit()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/get_ticket_departments_edit", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}
	// get company > employees
	public function get_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}
	
	public function ticketencashment()
	{   
	    $session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}
		$data['title'] = 'Air Ticket Encashments' . ' | ' . $this->Xin_model->site_title();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = 'Air Ticket Encashments';
		$data['path_url']    = 'airticket_encashment';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('303', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/airticket/encashment_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	    
	    
	}
	
	/*public function encashment_edit(){
	    $session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}
		$data['title'] = 'Air Ticket Encashments' . ' | ' . $this->Xin_model->site_title();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = 'Air Ticket Encashments';
		//$data['path_url']    = 'airticket_encashment';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('10004', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/airticket/encashment_edit", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	    
	}*/
	
	public function add_ticketencashment(){
	    $session_id = $this->input->post('session_id');
	    $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		global $encash_eligible;
	   /* $com_id     = $this->Airticket_model->airticket($session_id);
		$empid      = $com_id[0]->user_id;
		$duration   = $this->Airticket_model->getemp_duration($empid);
			if($duration){
				$emp_years  = $duration[0]->type;
				$emp_days   = $emp_years * 365;
				}
			else{
				$emp_days   = 365;
				}*/
				
				
		//if(in_array('508',$role_resources_ids)) {
		if(in_array('304',$role_resources_ids) || in_array('305',$role_resources_ids) || in_array('306',$role_resources_ids)) {
		$employeeid             = $this->input->post('employee_id');
		$start_date             = $this->input->post('start_date');
		$end_date               = $this->input->post('end_date');
		$no_of_tickets          = $this->input->post('no_of_tickets');
		$tickets_for_encash     = $this->input->post('tickets_for_encash');
		$place_to               = $this->input->post('place_to');
		$amount                 = $this->input->post('amount');
		$reason                 = $this->input->post('reason');
		$payroll_month          = $this->input->post('month_year');
		$status                 = $this->input->post('status');
		
		
		$getemp_payroll_status = $this->Airticket_model->getemp_payroll_status($employeeid,$payroll_month);
		if($getemp_payroll_status > 0){
			    $Return['error'] = 'Employee Payment already done for this month.';
			    $this->output($Return);
		}
		
		$duration   = $this->Airticket_model->getemp_duration($employeeid);
			if($duration){
				$emp_years  = $duration[0]->type;
				$emp_days   = $emp_years * 365;
				$tickets = $duration[0]->no_of_tickets;
				}
			else{
				$emp_days   = 365;
				$tickets    = 1;
				}
				
		$today     =  date('Y-m-d');
		if(strtotime($end_date) >= strtotime($today)){
                $encash_eligible = "no";
                }
		
		if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for this date range.';
			    $this->output($Return);
			}
			
		if($tickets_for_encash > $no_of_tickets){
			    $Return['error'] = 'Tickets to be Encashed should be less than or equal to number of tickets';
			    $this->output($Return);
		}
		
		if($no_of_tickets >= $tickets_for_encash && $emp_days == 365){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}
		
		if($no_of_tickets >= $tickets_for_encash && $emp_days == 730){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*730;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*730;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}
		
		/*if($no_of_tickets >= $tickets_for_encash){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}*/
			
			
		/*$newEndingDate       = date('Y-m-d', strtotime($start_date. ' + ' .$emp_days.' days'));		
		if(strtotime($end_date) <= strtotime($newEndingDate)){
                $encash_eligible = "no";
                }
		
		if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for this date range.';
			    $this->output($Return);
			}*/
	/*	$startingDate        = date('Y-m', strtotime($payroll_month. ' - ' .$emp_days.' days'));
		$joiningdate         = $this->Timesheet_model->joining_date($empid);
		$joining_date        = $joiningdate[0]->date_of_joining;
		$newEndingDate       = date('Y-m-d', strtotime($joining_date. ' + ' .$emp_days.' days'));
		$emp_encashed_month  = $this->Airticket_model->getemp_encashedmonth($empid);
		$empdate             = $this->Airticket_model->getemp_ticketdate($empid);
			if(isset($empdate) && isset($emp_encashed_month)){
				$empticketdate = $empdate[0]->end_date;
				$emp_encashmonth = $emp_encashed_month[0]->payroll_month;
				if(strtotime($empticketdate) >= strtotime($startingDate) && strtotime($empticketdate) <= strtotime($payroll_month)){
                $encash_eligible = "no";
                }elseif(strtotime($emp_encashmonth) >= strtotime($startingDate) && strtotime($emp_encashmonth) <= strtotime($payroll_month)){
                $encash_eligible = "no";
                } else{
                $encash_eligible = "yes";
                }
				}
				
			elseif(isset($empdate)){
				$empticketdate = $empdate[0]->end_date;
				if(strtotime($payroll_month) <= strtotime($newEndingDate)){
				$encash_eligible = "no";
                }elseif(strtotime($empticketdate) >= strtotime($startingDate) && strtotime($empticketdate) <= strtotime($payroll_month)){
                $encash_eligible = "no";
                } else{
                $encash_eligible = "yes";
                }
				}
		    elseif(isset($emp_encashed_month)){
				$emp_encashmonth = $emp_encashed_month[0]->payroll_month;
				if(strtotime($payroll_month) <= strtotime($newEndingDate)){
				$encash_eligible = "no";
                }elseif(strtotime($emp_encashmonth) >= strtotime($startingDate) && strtotime($emp_encashmonth) <= strtotime($payroll_month)){
                $encash_eligible = "no";
                } else{
                $encash_eligible = "yes";
                }
				}
			else{
			
                if(strtotime($payroll_month) >= strtotime($newEndingDate)){
                    $encash_eligible = "yes";
                }else{
                    $encash_eligible = "no";
                }
                
				}*/
	    	/*if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for the specified month';
			    $this->output($Return);
			}
			else{*/
			    	$data = array(
					'employee_id'       => $employeeid,
					'from_date'         => $start_date,
					'to_date'           => $end_date,
					'no_of_tickets'     => $no_of_tickets,
					'tickets_for_encash'=> $tickets_for_encash,
					'place_to'          => $place_to,
					'amount'            => $amount,
					'reason'            => $reason,
					'payroll_month'     => $payroll_month,
					'status'            => $status,
					'created_at'        => date('d-m-Y h:i:s')
				);
				
				$iresult = $this->Airticket_model->add_encashment_request($data);
				if ($iresult) {
					$Return['result'] = 'Airticket Encashment Request Added';
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
				$this->output($Return);
				exit;
			//}
		}
		else{
		$com_id     = $this->Airticket_model->airticket($session_id);
		$empid      = $com_id[0]->user_id;
		
		$duration   = $this->Airticket_model->getemp_duration($empid);
			if($duration){
				$emp_years  = $duration[0]->type;
				$emp_days   = $emp_years * 365;
				$tickets = $duration[0]->no_of_tickets;
				}
			else{
				$emp_days   = 365;
				$tickets = 1;
				}
		
		$start_date             = $this->input->post('start_date');
		$end_date               = $this->input->post('end_date');
		$no_of_tickets          = $this->input->post('no_of_tickets');
		$tickets_for_encash     = $this->input->post('tickets_for_encash');
		$place_to               = $this->input->post('place_to');
		$amount                 = $this->input->post('amount');
		$reason                 = $this->input->post('reason');	
		
		if(empty($end_date)){
			    $Return['error'] = 'Not eligible for encashment now';
			    $this->output($Return);
			}
		
		$today           =  date('Y-m-d');
		if(strtotime($end_date) >= strtotime($today)){
                $encash_eligible = "no";
            }
		
		if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for this date range.';
			    $this->output($Return);
			}
		if($tickets_for_encash > $no_of_tickets){
			    $Return['error'] = 'Tickets to be Encashed should be less than or equal to number of tickets';
			    $this->output($Return);
		}
		
		if($no_of_tickets >= $tickets_for_encash && $emp_days == 365){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}
		
		if($no_of_tickets >= $tickets_for_encash && $emp_days == 730){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*730;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*730;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}
		
		/*if($no_of_tickets >= $tickets_for_encash){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}*/
		
	/*	$newEndingDate       = date('Y-m-d', strtotime($start_date. ' + ' .$emp_days.' days'));	
		$empdate             = $this->Airticket_model->getemp_ticketdate($empid);*/
		
		/*if(isset($empdate)){
			$empticketdate = $empdate[0]->end_date;
			if(strtotime($empticketdate) >= strtotime($start_date) && strtotime($empticketdate) <= strtotime($newEndingDate)){
                $encash_eligible = "no";
            }
		}
		if(strtotime($end_date) <= strtotime($newEndingDate)){
                $encash_eligible = "no";
        }
        
		if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for this date range.';
			    $this->output($Return);
		}*/
			$data = array(
					'employee_id'        => $empid,
					'from_date'          => $start_date,
					'to_date'            => $end_date,
					'no_of_tickets'      => $no_of_tickets,
					'tickets_for_encash' => $tickets_for_encash,
					'place_to'           => $place_to,
					'amount'             => $amount,
					'reason'             => $reason,
					'status'             => "Pending",
					'created_at'         => date('d-m-Y h:i:s')
				);
				
				$iresult = $this->Airticket_model->add_encashment_request($data);
				if ($iresult) {
					$Return['result'] = 'Airticket Encashment Request Added';
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
				$this->output($Return);
				exit;
		
		}
			
			
	}
	
	
	// Validate and add info in database
	public function add_ticket()
	{

		if ($this->input->post('add_type') == 'ticket') {
		    $description = '';
			$session_id = $this->input->post('session_id');
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$role_resources_ids = $this->Xin_model->user_role_resource();
			if ($session_id == 1) {
				$assigned_to = $this->input->post('employee_id');
				/* Server side PHP input validation */
				/*if ($this->input->post('company') === '') {
					$Return['error'] = $this->lang->line('xin_error_company');
				} else if ($this->input->post('department_id') === '') {
					$Return['error'] = $this->lang->line('xin_employee_error_department');
				}*/  if (empty($assigned_to)) {
					$Return['error'] = $this->lang->line('xin_error_employee_id');
				} /*else if ($this->input->post('amount_collected_from_emp') === '') {
					$Return['error'] = 'Amount collected from employee is required';
				}*/
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}
			else{
			    $today = date("Y-m-d");
			    //$emergency = $this->input->post('emergency');
			    $emergency = 0;
			    if($this->input->post('emergency')){
			        $emergency = 1;
			    }
			    if($this->input->post('ticket_date_annual')){
			        $ticketdate = $this->input->post('ticket_date_annual');
                    $newEndingDate = date('Y-m-d', strtotime($today. ' +  60 days'));
			    }
			    else{
			        $ticketdate = $this->input->post('end_date');
                    $newEndingDate = date('Y-m-d', strtotime($today. ' +  60 days'));
			    }
			    $visit = $this->input->post('vist_type');
                if(strtotime($ticketdate) <= strtotime($newEndingDate) && $emergency == 0 && $visit == 1){
                    //$emergency = 1;
                    $Return['error'] = 'You should choose a ticket date after 2 months';
                    $this->output($Return);
                    
                }/*else{
                    //$emergency = 0;
                }*/
			}
			/* visit type validations */
			if ($this->input->post('vist_type') === '') {
				$Return['error'] = $this->lang->line('xin_error_visit_type');
			} else  if ($this->input->post('ticket_status') === '') {
				$Return['error'] = 'Status';
			}
			if ($this->input->post('vist_type') == 1) {
				/*annual visit type validations */
				if ($this->input->post('ticket_date_annual') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline_annual') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from_annual') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to_annual') === '') {
					$Return['error'] = 'Place To';
				} /*else if ($this->input->post('amount_annual') === '') {
					$Return['error'] = 'Amount';
				}*/ /*else if ($this->input->post('ticket_code_annual') === '') {
					$Return['error'] = 'Ticket Number is required';
				}*/ else if ($this->input->post('two_way_air_ticket1') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} /*else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					}*/ else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} /*else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}*/
					/* end Others two way ticket  validations */
				}
				/*end annual visit type validations */
			} else if ($this->input->post('vist_type') == 2) {
				/* others visit type validations */
				if ($this->input->post('end_date') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to') === '') {
					$Return['error'] = 'Place To';
				} else if ($this->input->post('place_vist') === '') {
					$Return['error'] = 'Place Of Visit';
				} else if ($this->input->post('subject') === '') {
					$Return['error'] = 'Purpose of Visit';
				} /*else if ($this->input->post('amount') === '') {
					$Return['error'] = 'Amount';
				}*/ /*else if ($this->input->post('ticket_code') === '') {
					$Return['error'] = 'Ticket Number is required';
				}*/ else if ($this->input->post('two_way_air_ticket') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} /*else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					}*/ else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} /*else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}*/
					/* end Others two way ticket  validations */
				}
				/* end others visit type validations */
			}
			/*end visit type validations */

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$two_way = $Return_descption = $ticket_code = $place_from = $place_to = $ticket_date = $airline_name = $amount = $place_visit = $purpose_visit = $fname  = '';
			$return_from = $return_to = $return_return_ticket_date = $return_ticket_number = $airline_return = $amount_return = $fname_return = '';
			$fname_return = 0;
			if ($this->input->post('vist_type') == 1) {
				$description = $this->input->post('description_annual');
				$two_way = $this->input->post('two_way_air_ticket1');
				// if ($this->input->post('two_way_air_ticket1') == 1) {
				// 	$Return_descption =  $this->input->post('description_return');
				// 	$return_from = $this->input->post('place_return_from');
				// 	$return_to = $this->input->post('return_place_to');
				// 	$return_return_ticket_date = $this->input->post('return_ticket_date');
				// 	$return_ticket_number = $this->input->post('return_ticket_number');
				// 	$airline_return = $this->input->post('airline_return');
				// 	$amount_return = $this->input->post('amount_return');
				// 	if ($_FILES['attachment_return']['size'] > 0) {
				// 		if (is_uploaded_file($_FILES['attachment_return']['tmp_name'])) {
				// 			//checking image type
				// 			$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
				// 			$filename = $_FILES['attachment_return']['name'];
				// 			$ext = pathinfo($filename, PATHINFO_EXTENSION);

				// 			if (in_array($ext, $allowed)) {
				// 				$tmp_name = $_FILES["attachment_return"]["tmp_name"];
				// 				$profile = "uploads/airticket/";
				// 				$set_img = base_url() . "uploads/airticket/";
				// 				// basename() may prevent filesystem traversal attacks;
				// 				// further validation/sanitation of the filename may be appropriate
				// 				$name = basename($_FILES["attachment_return"]["name"]);
				// 				$newfilename = 'ticket_attachment_return_' . round(microtime(true)) . '.' . $ext;
				// 				move_uploaded_file($tmp_name, $profile . $newfilename);
				// 				$fname_return = $newfilename;
				// 			} else {
				// 				$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				// 			}
				// 		}
				// 	} else {
				// 		$fname_return = 0;
				// 	}
				// }
				$place_from = $this->input->post('place_from_annual');
				$ticket_code = $this->input->post('ticket_code_annual');
				$place_to = $this->input->post('place_to_annual');
				$ticket_date = $this->input->post('ticket_date_annual');
				$airline_name = $this->input->post('airline_annual');
				$amount =  $this->input->post('amount_annual');

				// if ($_FILES['attachment_annual']['size'] > 0) {
				// 	if (is_uploaded_file($_FILES['attachment_annual']['tmp_name'])) {
				// 		//checking image type
				// 		$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
				// 		$filename = $_FILES['attachment_annual']['name'];
				// 		$ext = pathinfo($filename, PATHINFO_EXTENSION);

				// 		if (in_array($ext, $allowed)) {
				// 			$tmp_name = $_FILES["attachment_annual"]["tmp_name"];
				// 			$profile = "uploads/airticket/";
				// 			$set_img = base_url() . "uploads/airticket/";
				// 			// basename() may prevent filesystem traversal attacks;
				// 			// further validation/sanitation of the filename may be appropriate
				// 			$name = basename($_FILES["attachment_annual"]["name"]);
				// 			$newfilename = 'ticket_attachment_' . round(microtime(true)) . '.' . $ext;
				// 			move_uploaded_file($tmp_name, $profile . $newfilename);
				// 			$fname = $newfilename;
				// 		} else {
				// 			$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				// 		}
				// 	}
				// } else {
				// 	$fname = '0';
				// }
			} else if ($this->input->post('vist_type') == 2) {
				$description = $this->input->post('description');
				if ($this->input->post('two_way_air_ticket') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
				// 	if ($_FILES['attachment_return']['size'] > 0) {
				// 		if (is_uploaded_file($_FILES['attachment_return']['tmp_name'])) {
				// 			//checking image type
				// 			$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
				// 			$filename = $_FILES['attachment_return']['name'];
				// 			$ext = pathinfo($filename, PATHINFO_EXTENSION);

				// 			if (in_array($ext, $allowed)) {
				// 				$tmp_name = $_FILES["attachment_return"]["tmp_name"];
				// 				$profile = "uploads/airticket/";
				// 				$set_img = base_url() . "uploads/airticket/";
				// 				// basename() may prevent filesystem traversal attacks;
				// 				// further validation/sanitation of the filename may be appropriate
				// 				$name = basename($_FILES["attachment_return"]["name"]);
				// 				$newfilename = 'ticket_attachment_return_' . round(microtime(true)) . '.' . $ext;
				// 				move_uploaded_file($tmp_name, $profile . $newfilename);
				// 				$fname_return = $newfilename;
				// 			} else {
				// 				$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				// 			}
				// 		}
				// 	} else {
				// 		$fname_return = 0;
				// 	}
				}
				$ticket_code = $this->input->post('ticket_code');
				$place_from = $this->input->post('place_from');
				$place_to = $this->input->post('place_to');
				$ticket_date = $this->input->post('end_date');
				$airline_name = $this->input->post('airline');
				$amount =  $this->input->post('amount');
				$place_visit = $this->input->post('place_visit');
				$purpose_visit = $this->input->post('subject');
				$two_way = $this->input->post('two_way_air_ticket');

				// if ($_FILES['attachment']['size'] > 0) {
				// 	if (is_uploaded_file($_FILES['attachment']['tmp_name'])) {
				// 		//checking image type
				// 		$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
				// 		$filename = $_FILES['attachment']['name'];
				// 		$ext = pathinfo($filename, PATHINFO_EXTENSION);

				// 		if (in_array($ext, $allowed)) {
				// 			$tmp_name = $_FILES["attachment"]["tmp_name"];
				// 			$profile = "uploads/airticket/";
				// 			$set_img = base_url() . "uploads/airticket/";
				// 			// basename() may prevent filesystem traversal attacks;
				// 			// further validation/sanitation of the filename may be appropriate
				// 			$name = basename($_FILES["attachment"]["name"]);
				// 			$newfilename = 'ticket_attachment_' . round(microtime(true)) . '.' . $ext;
				// 			move_uploaded_file($tmp_name, $profile . $newfilename);
				// 			$fname = $newfilename;
				// 		} else {
				// 			$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				// 		}
				// 	}
				// } else {
				// 	$fname = '0';
				// }
			}
			
			

			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
			$qt_description_return = htmlspecialchars(addslashes($Return_descption), ENT_QUOTES);
			global $last_duration;
			
			if ($session_id == 1 && in_array('507', $role_resources_ids)) {
				$session        = $this->session->userdata('username');
				$ticket_status  = $this->input->post('ticket_status');
				if($ticket_status == "1"){
				    $final_approval = 1;
				}else{
				    $final_approval = 0;
				}
				
				$empid      = $this->input->post('employee_id');
			    $duration   = $this->Airticket_model->getemp_duration($empid);
				if($duration){
				    $emp_years     = $duration[0]->type;
				    $no_of_tickets = $duration[0]->no_of_tickets;
    				    if (is_numeric($emp_years)) {
    				        $emp_days      = $emp_years * 365;
    				    }
    				    else
    				    {
    				        $emp_days = 365;
    				    }
				    }
				else{
				    $no_of_tickets = 1;
				    $emp_days      = 365;
				    }
				    
				    $empdate    = $this->Airticket_model->getemp_ticketdate($empid);
				if($empdate){
				    /*$empticketdate = $empdate[0]->end_date;
				    $newEndingDate = date('Y-m-d', strtotime($empticketdate. ' + ' .$emp_days.' days'));*/
				    
				    $StartDate     = $empdate[0]->duration_from;
				    $EndingDate = date('Y-m-d', strtotime($StartDate. ' + ' .$emp_days.' days'));
				    
				    $enddate = $empdate[0]->duration_to;
				    $duration_start = date('Y-m-d', strtotime($enddate. ' + 1 days'));
				    $newEndingDate = date('Y-m-d', strtotime($duration_start. ' + ' .$emp_days.' days'));
                    $duration_end = $newEndingDate;
                    
                    $tickets_taken = $this->Airticket_model->emp_tickets_taken($empid, $StartDate, $EndingDate);
				    if($tickets_taken < $no_of_tickets){
                        $duration_start = $StartDate;
                        $duration_end   = $EndingDate;
                    }
                    
				    if(strtotime($ticket_date) >= strtotime($newEndingDate)){
                    $tckt_eligible = "yes";
                    } else{
                    $tckt_eligible = "no";
                    }
				    }
				else{
				    $joining_date= $this->Timesheet_model->joining_date($empid);
                    if($joining_date){
                    $joining_date = $joining_date[0]->date_of_joining;
                    $newEndingDate = date('Y-m-d', strtotime($joining_date. ' + ' .$emp_days.' days'));
                    $duration_start = $joining_date;
                    $duration_end = $newEndingDate;
                    if(strtotime($ticket_date) >= strtotime($newEndingDate)){
                    $tckt_eligible = "yes";
                    }else{
                    $tckt_eligible = "no";
                    }
                    }
				    }
				    
				    $check_encashment = $this->Airticket_model->getemp_encashedmonth($empid);
				    if($check_encashment){
				        $last_duration = $check_encashment[0]->to_date;
				        $duration_start = date('Y-m-d', strtotime($last_duration. ' + 1 days'));
				        $duration_end = date('Y-m-d', strtotime($duration_start. ' + ' .$emp_days.' days'));
				    }
				// $fname='';
				// if($this->input->post('attachment1')!=undefined)
				// {
				//     $fname=$this->input->post('attachment1');
				// }else{
				    $fname=$this->input->post('attachment2');
				// }
				
				$emp_ticket_request_check = $this->Airticket_model->getemp_ticket_requestcheck($empid,$ticket_date);
				if($emp_ticket_request_check > 0){
				    $Return['error'] = "Employee already applied air ticket for this date";
				    $this->output($Return);
				}
				
				$data = array(
					'employee_id' => $this->input->post('employee_id'),
					'visit_type' => $this->input->post('vist_type'),
					'place_from' => $place_from,
					'place_to' => $place_to,
					'end_date' => $ticket_date,
					'ticket_code' => $ticket_code,
					'airline' => $airline_name,
					'amount' => $amount,
					'place_visit' => $place_visit,
					'subject' => $purpose_visit,
					'ticket_image' => $fname,
					'description' => $qt_description,
					'two_way_or_not' => $two_way,
					'return_from' => $return_from,
					'return_to' => $return_to,
					'return_ticket_date' => $return_return_ticket_date,
					'return_ticket_number' => $return_ticket_number,
					'airline_return' => $airline_return,
					'amount_return' => $amount_return,
					'return_descption' => $Return_descption,
					'return_attachment' => $this->input->post('attachment3'),
					'amt_collected_from_emp' => $this->input->post('amount_collected_from_emp'),
					'paid_status' => $this->input->post('amt_paid_status'),
					'ticket_status' => $this->input->post('ticket_status'),
					'final_approval' => $final_approval,
					'is_notify' => '1',
					'created_by' => $session['user_id'],
					'created_at' => date('d-m-Y h:i:s'),
					'ticket_eligibility' => $tckt_eligible,
					'duration_from' => $duration_start,
					'duration_to'  => $duration_end,
				);
				$iresult = $this->Airticket_model->add($data);
				// 		if ($iresult) {
				// 			$Return['result'] = $this->lang->line('xin_success_ticket_created');

				// 			$id = $iresult;

				// 			//get setting info 
				// 			$setting = $this->Xin_model->read_setting_info(1);
				// // 			if($setting[0]->enable_email_notification == 'yes') {

				// // 				$this->email->set_mailtype("html");
				// // 				//get company info
				// // 				$cinfo = $this->Xin_model->read_company_setting_info(1);
				// // 				//get email template
				// // 				$template = $this->Xin_model->read_email_template(15);
				// // 				//get employee info
				// // 				$user_info = $this->Xin_model->read_user_info($this->input->post('employee_id'));

				// // 				$full_name = $user_info[0]->first_name.' '.$user_info[0]->last_name;

				// // 				$subject = str_replace('{var ticket_code}',$ticket_code,$template[0]->subject);
				// // 				$logo = base_url().'uploads/logo/signin/'.$cinfo[0]->sign_in_logo;

				// // 				$message = '
				// // 			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
				// // 			<img src="'.$logo.'" title="'.$cinfo[0]->company_name.'"><br>'.str_replace(array("{var site_name}","{var site_url}","{var ticket_code}"),array($cinfo[0]->company_name,site_url(),$ticket_code),htmlspecialchars_decode(stripslashes($template[0]->message))).'</div>';

				// // 				hrsale_mail($user_info[0]->email,$full_name,$cinfo[0]->email,$subject,$message);				
				// // 			}		
				// 		
				if ($iresult) {
					$Return['result'] = $this->lang->line('xin_success_ticket_created');
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
				$this->output($Return);
				exit;
			} else {
				    $com_id     = $this->Airticket_model->airticket($session_id);
				    $empid      = $com_id[0]->user_id;
				    $duration   = $this->Airticket_model->getemp_duration($empid);
				if($duration){
				    $emp_years     = $duration[0]->type;
				    $no_of_tickets = $duration[0]->no_of_tickets;
				    $emp_days      = $emp_years * 365;
				    }
				else{
				    $no_of_tickets = 1;
				    $emp_days      = 365;
				    }
				    
				    $empdate    = $this->Airticket_model->getemp_ticketdate($empid);
				if($empdate){
				    /*$empticketdate = $empdate[0]->end_date;
				    $newEndingDate = date('Y-m-d', strtotime($empticketdate. ' + ' .$emp_days.' days'));*/
				    
				    $StartDate  = $empdate[0]->duration_from;
				    $EndingDate = date('Y-m-d', strtotime($StartDate. ' + ' .$emp_days.' days'));
				    
				    $enddate = $empdate[0]->duration_to;
				    $duration_start = date('Y-m-d', strtotime($enddate. ' + 1 days'));
				    $newEndingDate = date('Y-m-d', strtotime($duration_start. ' + ' .$emp_days.' days'));
                    $duration_end = $newEndingDate;
                    
				    $tickets_taken = $this->Airticket_model->emp_tickets_taken($empid, $StartDate, $EndingDate);
				    if($tickets_taken < $no_of_tickets){
                        $duration_start = $StartDate;
                        $duration_end   = $EndingDate;
                    }
				    /*if($tickets_taken == $no_of_tickets){
                    $Return['error'] = 'Available Number of tickets limit exceeded';
                    $this->output($Return);
                    }elseif($tickets_taken < $no_of_tickets){
                        $duration_start = $StartDate;
                        $duration_end   = $EndingDate;
                    }*/
				    /*if(strtotime($ticket_date) <= strtotime($newEndingDate) && $tickets_taken == $no_of_tickets){
                    $Return['error'] = 'Available Number of tickets limit exceeded';
                    $this->output($Return);
                    }*/
				    if(strtotime($ticket_date) >= strtotime($newEndingDate)){
                    $tckt_eligible = "yes";
                    } else{
                    $tckt_eligible = "no";
                    }
				    }
				else{
				    $joining_date= $this->Timesheet_model->joining_date($empid);
                    if($joining_date){
                    $joining_date = $joining_date[0]->date_of_joining;
                    $newEndingDate = date('Y-m-d', strtotime($joining_date. ' + ' .$emp_days.' days'));
                    $duration_start = $joining_date;
                    $duration_end = $newEndingDate;
                    //$tickets_taken = $this->Airticket_model->emp_tickets_taken($empid, $joining_date, $newEndingDate);
                    
                    
                    /*if($tickets_taken == $no_of_tickets){
                    $Return['error'] = 'Available Number of tickets limit exceeded';
                    $this->output($Return);
                    }*/
                    /*if(strtotime($ticket_date) <= strtotime($newEndingDate) && $tickets_taken == $no_of_tickets){
                    $Return['error'] = 'Available Number of tickets limit exceeded';
                    $this->output($Return);
                    }*/
                    
                    if(strtotime($ticket_date) >= strtotime($newEndingDate)){
                    $tckt_eligible = "yes";
                    }else{
                    $tckt_eligible = "no";
                    }
                    }
				    }
				    
				    $check_encashment = $this->Airticket_model->getemp_encashedmonth($empid);
				    if($check_encashment){
				        $last_duration = $check_encashment[0]->to_date;
				        $duration_start = date('Y-m-d', strtotime($last_duration. ' + 1 days'));
				        $duration_end = date('Y-m-d', strtotime($duration_start. ' + ' .$emp_days.' days'));
				    }
				
				
			//	$ticket_code = '--';
			
			    $emp_ticket_request_check = $this->Airticket_model->getemp_ticket_requestcheck($empid,$ticket_date);
				if($emp_ticket_request_check > 0){
				    $Return['error'] = "You have already applied air ticket for this date";
				    $this->output($Return);
				}
				
				$data = array(
					'employee_id' => $com_id[0]->user_id,
					'visit_type' => $this->input->post('vist_type'),
					'place_from' => $place_from,
					'place_to' => $place_to,
					'end_date' => $ticket_date,
					'ticket_code' => $ticket_code,
					'airline' => $airline_name,
					'amount' => $amount,
					'place_visit' => $place_visit,
					'subject' => $purpose_visit,
					'ticket_image' => $fname,
					'description' => $qt_description,
					'two_way_or_not' => $two_way,
					'return_from' => $return_from,
					'return_to' => $return_to,
					'return_ticket_date' => $return_return_ticket_date,
					'return_ticket_number' => $return_ticket_number,
					'airline_return' => $airline_return,
					'amount_return' => $amount_return,
					'return_descption' => $Return_descption,
					'return_attachment' => $fname_return,
					'ticket_status' =>3,
					'is_notify' => '1',
					'created_by' => $session_id,
					'created_at' => date('d-m-Y h:i:s'),
					'ticket_eligibility' => $tckt_eligible,
					'duration_from' => $duration_start,
					'duration_to'  => $duration_end,
					'emergency' => $emergency
				);
				/*$data = array(
					'ticket_code' => $ticket_code,
					'subject' => $this->input->post('subject'),
					'company_id' => $com_id[0]->company_id,
					'employee_id' => $com_id[0]->user_id,
					'department_id' => $com_id[0]->department_id,
					'ticket_image' => '--',
					'end_date' => '--',
					'description' => '--',
					'ticket_status' => '1',
					'is_notify' => '1',
					'airline' => '--',
					'place_from' => $this->input->post('place_from'),
					'place_to' => $this->input->post('place_to'),
					'place_visit' => '--',
					'amount' => '--',
					'created_by' => $session_id,
					'created_at' => date('d-m-Y h:i:s'),
				); //print_r($data);exit;*/
				$iresult = $this->Airticket_model->add($data);
				if ($iresult) {
					$Return['result'] = $this->lang->line('xin_success_ticket_created');
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
				$this->output($Return);
				exit;
			}
		}
	}
	

	public function airticket_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/airticket_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id == 2){
		    $ticket = $this->Airticket_model->read_employee_ticketinfo($session['user_id']);
		}
		else{
		    $ticket = $this->Airticket_model->get_tickets();
		}
		//$ticket = $this->Airticket_model->get_tickets();
	
		/*	if (in_array('309', $role_resources_ids)) {
				$ticket = $this->Airticket_model->get_company_tickets($user_info[0]->company_id);
			}else if(in_array('507', $role_resources_ids)){
			    $ticket = $this->Airticket_model->get_company_ticketsnew($user_info[0]->company_id,'first',$session['user_id']);
			}else if(in_array('508', $role_resources_ids)){
			    $ticket = $this->Airticket_model->get_company_ticketsnew($user_info[0]->company_id, 'final',$session['user_id']);
			}  else {
				$ticket = $this->Airticket_model->get_employee_tickets($session['user_id']);
			}*/
		
	//	print_R($this->db->last_query());exit;
		$data = array();
		$cdate = strtotime(date('Y-m-d'));
		foreach ($ticket->result() as $r) {

			// priority
			if ($r->ticket_status == 1) :
				$priority = 'Approved';
			elseif ($r->ticket_status == 2) :
				$priority = 'Cancelled';
			elseif ($r->ticket_status == 3) :
			$priority = 'Pending';

			endif;
			$eend_date = strtotime($r->end_date);
		/*	if ($cdate > $eend_date) {
				$xpired = '<span class="badge bg-red">' . $this->lang->line('xin_expired_title') . '</span>';
			} else {
				$xpired = '';
			}*/
			$end_date = $this->Xin_model->set_date_format($r->end_date);

			// status 
			if ($r->ticket_status == 1) :
				$status = '<span class="badge bg-orange">' . 'Approved ' . '</span> ';
			else :
				$status = '<span class="badge bg-green">' . 'Cancelled' . '</span> ';
			endif;
				if ($r->ticket_status == 3) {
        			if ($r->first_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
        			}
        			if ($r->second_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
        			}
        			if ($r->final_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
        			}
        		}
        		
        		if ($r->ticket_status == 2) {
        			if ($r->rejection_status == 1) {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First Rejection</span>';
        			}
        			elseif ($r->rejection_status == 2) {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second Rejection</span>';
        			} 
        			elseif ($r->rejection_status == 3) {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final Rejection</span>';
        			} 
        		}
        		
			// ticket date and time
			$created_at = date('h:i A', strtotime($r->created_at));
			$_date = explode(' ', $r->created_at);
			$edate = $this->Xin_model->set_date_format($_date[0]);
			$_created_at = $edate . ' ' . $created_at;

			// get company name
			$p_company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($p_company)) {
				$company = $p_company[0]->name;
			} else {
				$company = '--';
			}
			// created by
			$created_by = $this->Xin_model->read_user_info($r->created_by);
			if (!is_null($created_by)) {
				$ticket_created_by = $created_by[0]->first_name . ' ' . $created_by[0]->last_name;
			} else {
				$ticket_created_by = '';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			// ticket attachment
			 if($r->ticket_image && $r->ticket_image != '0' && $r->ticket_image != '--') {
				$timage = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'uploads/airticket/' . $r->ticket_image . '" target="_blank" download><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light"><span class="fa fa-download"></span></button></a></span>';
			}else {
				$timage = '';
			}

			$user_id = $session['user_id'];
			$role = $this->Airticket_model->role($user_id);


			if (in_array('292', $role_resources_ids)) { //edit
			 
			     $edit = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '">
			    <button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data"  data-ticket_id="' . $r->ticket_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			
			 
			} else {
				$edit = ' ';
			}
			
			
			if (in_array('293', $role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-xs btn-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->ticket_id . '"><span class="fa fa-trash"></span></button></span>';
			} else {
				$delete = ' ';
			}

			//if(in_array('309',$role_resources_ids)) { //view
			if (in_array('294', $role_resources_ids)) {
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/airticket/details/' . $r->ticket_id . '"><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {
				$view = '';
			}
			/*if ($user_id == '1') {
				$combhr = $timage . $edit . $view . $delete;
			} else {
				$combhr = $timage . $edit . $view;
			}*/
            $combhr = $timage . $edit . $view . $delete;

			$eticket_info = $this->Airticket_model->get_ticket_employees($r->employee_id);
			$ol = $assigned_name = '';

			$assigned_to = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($assigned_to)) {

				$assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
				if ($assigned_to[0]->profile_picture != '' && $assigned_to[0]->profile_picture != 'no file') {
					$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $assigned_to[0]->profile_picture . '" class="user-image-hr" alt=""></span></a>';
				} else {
					if ($assigned_to[0]->gender == 'Male') {
						$de_file = base_url() . 'uploads/profile/default_male.jpg';
					} else {
						$de_file = base_url() . 'uploads/profile/default_female.jpg';
					}
					$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . $de_file . '" class="user-image-hr" alt=""></span></a>';
				}
			} ////
			else {
				$ol .= '';
			}

			$ol .= '';
			$iemployee_name = '<span class="badge bg-orange">'.$assigned_name.'</span>';
			$iticket_code = $r->ticket_code . '<br><small class="text-muted"><i>' . $status . '<i></i></i></small>';
			$ipriority = $priority . '<br><small class="text-muted"><i>' . $end_date . '<i></i></i></small>';
			
		if(in_array('292',$role_resources_ids) || in_array('293',$role_resources_ids) || in_array('294',$role_resources_ids)) {
          $data[] = array(
            
            //$iticket_code,
            $iemployee_name,
            /*($r->visit_type == 1) ? 'Annual Air Ticket' : 'Others',*/
            //$r->subject,
            $ipriority,
            $_created_at,
            $ticket_created_by,
            $combhr,
          );
        } else { 
          $data[] = array(
            //$iticket_code,
            $iemployee_name,
            /*($r->visit_type == 1) ? 'Annual Air Ticket' : 'Others',*/
            //$r->subject,
            $ipriority,
            $_created_at,
            $ticket_created_by
          );  
        }
        
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $ticket->num_rows(),
			"recordsFiltered" => $ticket->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}
	
	public function airticket_encashmentlist()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/encashment_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$encashment = $this->Airticket_model->get_ticket_encashments();
		

		$data = array();
		$cdate = strtotime(date('Y-m-d'));
		foreach ($encashment->result() as $r) {
		
			
			// ticket date and time
			$created_at = date('h:i A', strtotime($r->created_at));
			$_date = explode(' ', $r->created_at);
			$edate = $this->Xin_model->set_date_format($_date[0]);
			$_created_at = $edate . ' ' . $created_at;
	

			$user_id = $session['user_id'];
		
			$role = $this->Airticket_model->role($user_id)->result();
            $delete = $approve = '';
			/*if (in_array('304', $role_resources_ids) || in_array('305', $role_resources_ids) || in_array('306', $role_resources_ids) || in_array('745', $role_resources_ids)) {
    			$approve = '<span data-toggle="tooltip" data-placement="top" title="View Details"><a href="' . site_url() . 'admin/airticket/encashment_details/' . $r->encash_id . '"><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light"><span class="fa fa-arrow-circle-right"></span></button></a></span>';
			}*/
			if (in_array('744', $role_resources_ids)) {
			    $delete = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-xs btn-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->encash_id . '"><span class="fa fa-trash"></span></button></span>';
			}
			
			

			//if(in_array('309',$role_resources_ids)) { //view
			if (in_array('304', $role_resources_ids) || in_array('305', $role_resources_ids) || in_array('306', $role_resources_ids) || in_array('745', $role_resources_ids)) {
				$view = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/airticket/encashment_details/' . $r->encash_id . '"><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {
				$view = '';
			}
			
			if (in_array('304', $role_resources_ids) || in_array('305', $role_resources_ids) || in_array('306', $role_resources_ids) || in_array('745', $role_resources_ids)) {
			        $combhr = $view . $delete;
			   
			} else {
				    $combhr = $delete;
			}
			/*$user_id = $session['user_id'];
			if($user_id == 1){
			    if($r->status == "Pending"){
			        $combhr = $approve . $delete;
			    }else{
			        $combhr = $delete;
			    }
			    
			}else{
			    $combhr = $delete;
			}*/
			
			
			$assigned_to   = $this->Xin_model->read_user_info($r->employee_id);
		    $assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
		
            if ($r->status == "Approved") :
				$priority = 'Approved';
			elseif ($r->status == "Pending") :
				$priority = 'Pending';
			elseif ($r->status == "Cancelled") :
			$priority = 'Cancelled';

			endif;




            /*if ($r->status == "Approved") {
				$status = '<span class="badge bg-orange">' . 'Approved ' . '</span> ';
            }elseif ($r->status == "Pending") {
				$status = '<span class="badge bg-green">' . 'Pending' . '</span> ';
            }else {
				$status = '<span class="badge bg-green">' . 'Cancelled' . '</span> ';
            }*/
				if ($r->status == "Pending") {
        			if ($r->first_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
        			}
        			if ($r->second_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
        			}
        			if ($r->final_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
        			}
        		}
        		
        
	
		if(in_array('744',$role_resources_ids) || in_array('745',$role_resources_ids)) {
          $data[] = array(
            
            $assigned_name,
            $r->from_date,
            $r->to_date,
            $this->Xin_model->company_currency_sign($r->amount,$role[0]->company_id),
            //$r->status,
            $priority,
            $_created_at,
            $combhr,
          );
        } else { 
          $data[] = array(
            $assigned_name,
            $r->from_date,
            $r->to_date,
            $this->Xin_model->company_currency_sign($r->amount,$role[0]->company_id),
            //$r->status,
            $priority,
            $_created_at
          );  
        }
        
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $encashment->num_rows(),
			"recordsFiltered" => $encashment->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}
	public function read()
	{
		$data['title'] = $this->Xin_model->site_title();
		// 		$id = $this->input->get('ticket_id');
		// 		$result = $this->Airticket_model->read_ticket_information($id);
		// 		$data = array(
		// 				'ticket_id' => $result[0]->ticket_id,
		// 				'company_id' => $result[0]->company_id,
		// 				'department_id' => $result[0]->department_id,
		// 				'ticket_code' => $result[0]->ticket_code,
		// 				'subject' => $result[0]->subject,
		// 				'employee_id' => $result[0]->employee_id,
		// 				'ticket_status' => $result[0]->ticket_status,
		// 				'all_companies' => $this->Xin_model->get_companies(),
		// 				'all_departments' => $this->Xin_model->all_department(),
		// 				'description' => $result[0]->description,
		// 				'all_employees' => $this->Xin_model->all_employees(),
		// 				'airline' => $result[0]->airline,
		// 				'place_from' => $result[0]->place_from,
		// 				'place_to' => $result[0]->place_to,
		// 				'end_date' => $result[0]->end_date,
		// 				'amount' => $result[0]->amount,
		// 				'place_visit' => $result[0]->place_visit,
		// 				'description'=>$result[0]->description,
		// 				);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/airticket/dialog_ticket', $data);
		} else {
			redirect('admin/');
		}
	}
	
	
	/*public function approve_encashment()
	{
		$id     = $this->uri->segment(4);
		$data = array(
				'status' => "Approved"
			);
		$this->Airticket_model->approve_ticketencashment($data,$id);
		redirect('admin/airticket/ticketencashment');
	}*/
	
	
	public function update_encashstatus()
	{
		$encash_id     = $this->input->post('status_encash_id');
		$payroll_month = $this->input->post('month_year');
		$status        = $this->input->post('status');
    	
    	$role_resources_ids = $this->Xin_model->user_role_resource(); 
    	
            /*if (in_array('1003', $role_resources_ids)) {*/
            
            if (in_array('304', $role_resources_ids)) {    
                
            if($status == '4'){
                $data = array(
				'status' => "Pending",
				'payroll_month' =>  $payroll_month,
				'first_approval' => 1
			);
            }elseif($status == '2'){
                $data = array(
				'status' => "Cancelled",
				'payroll_month' =>  $payroll_month,
				'first_approval' => 0
			);
            }else{
                $data = array(
				'status' => "Pending",
				'payroll_month' =>  $payroll_month,
				'first_approval' => 0
			);
            }
            }
            /*elseif (in_array('1004', $role_resources_ids)){*/
            if (in_array('305', $role_resources_ids)){
                if($status == '5'){
                $data = array(
				'status' => "Pending",
				'payroll_month' =>  $payroll_month,
				'second_approval' => 1
			);
            }elseif($status == '2'){
                $data = array(
				'status' => "Cancelled",
				'payroll_month' =>  $payroll_month,
				'first_approval' => 0,
				'second_approval' => 0
			);
            }else{
                $data = array(
				'status' => "Pending",
				'payroll_month' =>  $payroll_month,
				'second_approval' => 0
			);
            }
            }
            /*elseif (in_array('1005', $role_resources_ids)){*/
            if (in_array('306', $role_resources_ids)){
                if($status == '1'){
                $data = array(
				'status' => "Approved",
				'payroll_month' =>  $payroll_month,
				'final_approval' => 1
			);
            }elseif($status == '2'){
                $data = array(
				'status' => "Cancelled",
				'payroll_month' =>  $payroll_month,
				'first_approval' => 0,
				'second_approval' => 0,
				'final_approval' => 0
			);
            }else{
                $data = array(
				'status' => "Pending",
				'payroll_month' =>  $payroll_month,
				'final_approval' => 0
			);
            }
            }
		
		
	/*	$data = array(
		        'payroll_month' =>  $payroll_month,
				'status'        =>  $status
			);*/
			
		$this->Airticket_model->approve_ticketencashment($data,$encash_id);
		redirect('admin/airticket/ticketencashment');
	}

	// Validate and update info in database
	public function update_validate()
	{

		if ($this->input->post('edit_type') == 'ticket') {

			$id = $this->uri->segment(4);

			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			$description = $this->input->post('description');
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$module_attributes = $this->Custom_fields_model->tickets_hrsale_module_attributes();
			$count_module_attributes = $this->Custom_fields_model->count_tickets_module_attributes();
			$i = 1;
			if ($count_module_attributes > 0) {
				foreach ($module_attributes as $mattribute) {
					if ($mattribute->validation == 1) {
						if ($i != 1) {
						} else if ($this->input->post($mattribute->attribute) == '') {
							$Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
						}
					}
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}
			$session_id = $this->input->post('session_id');
			if ($session_id == 1) {
				$assigned_to = $this->input->post('employee_id');
				/* Server side PHP input validation */
				if ($this->input->post('company') === '') {
					$Return['error'] = $this->lang->line('xin_error_company');
				} else if ($this->input->post('department_id') === '') {
					$Return['error'] = $this->lang->line('xin_employee_error_department');
				} else if (empty($assigned_to)) {
					$Return['error'] = $this->lang->line('xin_error_employee_id');
				} else if ($this->input->post('amount_collected_from_emp') === '') {
					$Return['error'] = 'Amount collected from employee is required';
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}
			/* visit type validations */
			if ($this->input->post('vist_type') === '') {
				$Return['error'] = $this->lang->line('xin_error_visit_type');
			} else  if ($this->input->post('ticket_status') === '') {
				$Return['error'] = 'Status';
			}
			if ($this->input->post('vist_type') == 1) {
				/*annual visit type validations */
				if ($this->input->post('ticket_date_annual') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline_annual') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from_annual') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to_annual') === '') {
					$Return['error'] = 'Place To';
				} /*else if ($this->input->post('amount_annual') === '') {
					$Return['error'] = 'Amount';
				} else if ($this->input->post('ticket_code_annual') === '') {
					$Return['error'] = 'Ticket Number is required';
				}*/ else if ($this->input->post('two_way_air_ticket1') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}
					/* end Others two way ticket  validations */
				}
				/*end annual visit type validations */
			} else if ($this->input->post('vist_type') == 2) {
				/* others visit type validations */
				if ($this->input->post('end_date') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to') === '') {
					$Return['error'] = 'Place To';
				} else if ($this->input->post('place_vist') === '') {
					$Return['error'] = 'Place Of Visit';
				} else if ($this->input->post('subject') === '') {
					$Return['error'] = 'Purpose of Visit';
				} else if ($this->input->post('amount') === '') {
					$Return['error'] = 'Amount';
				} else if ($this->input->post('ticket_code') === '') {
					$Return['error'] = 'Ticket Number is required';
				} else if ($this->input->post('two_way_air_ticket') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}
					/* end Others two way ticket  validations */
				}
				/* end others visit type validations */
			}
			/*end visit type validations */

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$two_way = $Return_descption = $ticket_code = $place_from = $place_to = $ticket_date = $airline_name = $amount = $place_visit = $purpose_visit = $fname  = '';
			$return_from = $return_to = $return_return_ticket_date = $return_ticket_number = $airline_return = $amount_return = $fname_return = '';
			$fname_return = 0;
			if ($this->input->post('vist_type') == 1) {
				$description = $this->input->post('description_annual');
				$two_way = $this->input->post('two_way_air_ticket1');
				if ($this->input->post('two_way_air_ticket1') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
					if ($_FILES['attachment_return']['size'] > 0) {
						if (is_uploaded_file($_FILES['attachment_return']['tmp_name'])) {
							//checking image type
							$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
							$filename = $_FILES['attachment_return']['name'];
							$ext = pathinfo($filename, PATHINFO_EXTENSION);

							if (in_array($ext, $allowed)) {
								$tmp_name = $_FILES["attachment_return"]["tmp_name"];
								$profile = "uploads/airticket/";
								$set_img = base_url() . "uploads/airticket/";
								// basename() may prevent filesystem traversal attacks;
								// further validation/sanitation of the filename may be appropriate
								$name = basename($_FILES["attachment_return"]["name"]);
								$newfilename = 'ticket_attachment_return_' . round(microtime(true)) . '.' . $ext;
								move_uploaded_file($tmp_name, $profile . $newfilename);
								$fname_return = $newfilename;
								$Return['fileName'] = $newfilename;
							} else {
								$Return['error'] = $this->lang->line('xin_error_attatchment_type');
							}
						}
					} else {
						$fname_return = $this->input->post('attachment_return_old');
					}
				}
				$place_from = $this->input->post('place_from_annual');
				$ticket_code = $this->input->post('ticket_code_annual');
				$place_to = $this->input->post('place_to_annual');
				$ticket_date = $this->input->post('ticket_date_annual');
				$airline_name = $this->input->post('airline_annual');
				$amount =  $this->input->post('amount_annual');

				if ($_FILES['attachment_annual']['size'] > 0) {
					if (is_uploaded_file($_FILES['attachment_annual']['tmp_name'])) {
						//checking image type
						$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
						$filename = $_FILES['attachment_annual']['name'];
						$ext = pathinfo($filename, PATHINFO_EXTENSION);

						if (in_array($ext, $allowed)) {
							$tmp_name = $_FILES["attachment_annual"]["tmp_name"];
							$profile = "uploads/airticket/";
							$set_img = base_url() . "uploads/airticket/";
							// basename() may prevent filesystem traversal attacks;
							// further validation/sanitation of the filename may be appropriate
							$name = basename($_FILES["attachment_annual"]["name"]);
							$newfilename = 'ticket_attachment_' . round(microtime(true)) . '.' . $ext;
							move_uploaded_file($tmp_name, $profile . $newfilename);
							$fname = $newfilename;
							$Return['fileName'] = $newfilename;
						} else {
							$Return['error'] = $this->lang->line('xin_error_attatchment_type');
						}
					}
				} else {
					$fname = $this->input->post('attachment_annual_old');
				}
			} else if ($this->input->post('vist_type') == 2) {
				$description = $this->input->post('description');
				if ($this->input->post('two_way_air_ticket') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
					if ($_FILES['attachment_return']['size'] > 0) {
						if (is_uploaded_file($_FILES['attachment_return']['tmp_name'])) {
							//checking image type
							$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
							$filename = $_FILES['attachment_return']['name'];
							$ext = pathinfo($filename, PATHINFO_EXTENSION);

							if (in_array($ext, $allowed)) {
								$tmp_name = $_FILES["attachment_return"]["tmp_name"];
								$profile = "uploads/airticket/";
								$set_img = base_url() . "uploads/airticket/";
								// basename() may prevent filesystem traversal attacks;
								// further validation/sanitation of the filename may be appropriate
								$name = basename($_FILES["attachment_return"]["name"]);
								$newfilename = 'ticket_attachment_return_' . round(microtime(true)) . '.' . $ext;
								move_uploaded_file($tmp_name, $profile . $newfilename);
								$fname_return = $newfilename;
								$Return['fileName'] = $newfilename;
							} else {
								$Return['error'] = $this->lang->line('xin_error_attatchment_type');
							}
						}
					} else {
						$fname_return = $this->input->post('attachment_return_old');
					}
				}
				
				$ticket_code = $this->input->post('ticket_code');
				$place_from = $this->input->post('place_from');
				$place_to = $this->input->post('place_to');
				$ticket_date = $this->input->post('end_date');
				$airline_name = $this->input->post('airline');
				$amount =  $this->input->post('amount');
				$place_visit = $this->input->post('place_visit');
				$purpose_visit = $this->input->post('subject');
				$two_way = $this->input->post('two_way_air_ticket');

				if ($_FILES['attachment']['size'] > 0) {
					if (is_uploaded_file($_FILES['attachment']['tmp_name'])) {
						//checking image type
						$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
						$filename = $_FILES['attachment']['name'];
						$ext = pathinfo($filename, PATHINFO_EXTENSION);

						if (in_array($ext, $allowed)) {
							$tmp_name = $_FILES["attachment"]["tmp_name"];
							$profile = "uploads/airticket/";
							$set_img = base_url() . "uploads/airticket/";
							// basename() may prevent filesystem traversal attacks;
							// further validation/sanitation of the filename may be appropriate
							$name = basename($_FILES["attachment"]["name"]);
							$newfilename = 'ticket_attachment_' . round(microtime(true)) . '.' . $ext;
							move_uploaded_file($tmp_name, $profile . $newfilename);
							$fname = $newfilename;
							$Return['fileName'] = $newfilename;
						} else {
							$Return['error'] = $this->lang->line('xin_error_attatchment_type');
						}
					}
				} else {
					$fname = $this->input->post('attachment_others');
				}
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}
	
	public function update()
	{

		if ($this->input->post('edit_type') == 'ticket') {

			$id = $this->uri->segment(4);

			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			$description = $this->input->post('description');
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$module_attributes = $this->Custom_fields_model->tickets_hrsale_module_attributes();
			$count_module_attributes = $this->Custom_fields_model->count_tickets_module_attributes();
			$i = 1;
			if ($count_module_attributes > 0) {
				foreach ($module_attributes as $mattribute) {
					if ($mattribute->validation == 1) {
						if ($i != 1) {
						} else if ($this->input->post($mattribute->attribute) == '') {
							$Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
						}
					}
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}
			$session_id = $this->input->post('session_id');
			if ($session_id == 1) {
				$assigned_to = $this->input->post('employee_id');
				/* Server side PHP input validation */
				if ($this->input->post('company') === '') {
					$Return['error'] = $this->lang->line('xin_error_company');
				} else if ($this->input->post('department_id') === '') {
					$Return['error'] = $this->lang->line('xin_employee_error_department');
				} else if (empty($assigned_to)) {
					$Return['error'] = $this->lang->line('xin_error_employee_id');
				} else if ($this->input->post('amount_collected_from_emp') === '') {
					$Return['error'] = 'Amount collected from employee is required';
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}
			/* visit type validations */
			if ($this->input->post('vist_type') === '') {
				$Return['error'] = $this->lang->line('xin_error_visit_type');
			} else  if ($this->input->post('ticket_status') === '') {
				$Return['error'] = 'Status';
			}
			if ($this->input->post('vist_type') == 1) {
				/*annual visit type validations */
				if ($this->input->post('ticket_date_annual') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline_annual') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from_annual') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to_annual') === '') {
					$Return['error'] = 'Place To';
				} /*else if ($this->input->post('amount_annual') === '') {
					$Return['error'] = 'Amount';
				} else if ($this->input->post('ticket_code_annual') === '') {
					$Return['error'] = 'Ticket Number is required';
				}*/ else if ($this->input->post('two_way_air_ticket1') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}
					/* end Others two way ticket  validations */
				}
				/*end annual visit type validations */
			} else if ($this->input->post('vist_type') == 2) {
				/* others visit type validations */
				if ($this->input->post('end_date') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to') === '') {
					$Return['error'] = 'Place To';
				} else if ($this->input->post('place_vist') === '') {
					$Return['error'] = 'Place Of Visit';
				} else if ($this->input->post('subject') === '') {
					$Return['error'] = 'Purpose of Visit';
				} else if ($this->input->post('amount') === '') {
					$Return['error'] = 'Amount';
				} else if ($this->input->post('ticket_code') === '') {
					$Return['error'] = 'Ticket Number is required';
				} else if ($this->input->post('two_way_air_ticket') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}
					/* end Others two way ticket  validations */
				}
				/* end others visit type validations */
			}
			/*end visit type validations */

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$two_way = $Return_descption = $ticket_code = $place_from = $place_to = $ticket_date = $airline_name = $amount = $place_visit = $purpose_visit = $fname  = '';
			$return_from = $return_to = $return_return_ticket_date = $return_ticket_number = $airline_return = $amount_return = $fname_return = '';
			$fname_return = 0;
			if ($this->input->post('vist_type') == 1) {
				$description = $this->input->post('description_annual');
				$two_way = $this->input->post('two_way_air_ticket1');
				if ($this->input->post('two_way_air_ticket1') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
					if ($this->input->post('attachment') =='' || $this->input->post('attachment') == 'undefined') 
					{
								$fname_return = $this->input->post('attachment');
						
					} 
					else 
					{
						$fname_return = $this->input->post('attachment_return_old');
					}
				}
				$place_from = $this->input->post('place_from_annual');
				$ticket_code = $this->input->post('ticket_code_annual');
				$place_to = $this->input->post('place_to_annual');
				$ticket_date = $this->input->post('ticket_date_annual');
				$airline_name = $this->input->post('airline_annual');
				$amount =  $this->input->post('amount_annual');

				if ($this->input->post('attachment') =='' || $this->input->post('attachment') == 'undefined') 
				{
					$fname = $this->input->post('attachment');
				} 
				else 
				{
					$fname = $this->input->post('attachment_annual_old');
				}
			} else if ($this->input->post('vist_type') == 2) {
				$description = $this->input->post('description');
				if ($this->input->post('two_way_air_ticket') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
					if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {
					
								$fname_return = $this->input->post('attachment');
						
					} else {
						$fname_return = $this->input->post('attachment_return_old');
					}
				}
				
				$ticket_code = $this->input->post('ticket_code');
				$place_from = $this->input->post('place_from');
				$place_to = $this->input->post('place_to');
				$ticket_date = $this->input->post('end_date');
				$airline_name = $this->input->post('airline');
				$amount =  $this->input->post('amount');
				$place_visit = $this->input->post('place_visit');
				$purpose_visit = $this->input->post('subject');
				$two_way = $this->input->post('two_way_air_ticket');

			}
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
			$qt_description_return = htmlspecialchars(addslashes($Return_descption), ENT_QUOTES);
			
			$session = $this->session->userdata('username');
    		$user_info = $this->Xin_model->read_user_info($session['user_id']);
    		$role_resources_ids = $this->Xin_model->user_role_resource();
    		$first_approval = $final_approval = 0;
    		$approved_by = $this->input->post('first_approvel_by');
    		$approved_by_final = $this->input->post('final_approvel_by');
    		if($user_info[0]->user_role_id==1){
    			 $status_updated = $this->input->post('ticket_status');
    			 
    			 if ($status_updated == 1) {
    			 	$first_approval = $final_approval = 1;
    			 	$approved_by_final = $session['user_id'];
    			 }
    		} else if (in_array('507', $role_resources_ids)) {
    			$status_updated = 3;//$this->input->post('status_old');
    
    			if ($this->input->post('ticket_status') == 1) {
    				$first_approval = 1;
    				$approved_by = $session['user_id'];
    			}
    		} else if (in_array('508', $role_resources_ids)) {
    			$status_updated = 3;//$this->input->post('status_old');
    
    			if ($this->input->post('ticket_status') == 1) {
    				$first_approval = $final_approval = 1;
    				$status_updated = 1;
    				$approved_by_final = $session['user_id'];
    			}
    		} else{
    			$status_updated = $this->input->post('ticket_status_old');
    		}

			if ($session_id == 1 || in_array('507', $role_resources_ids) || in_array('508', $role_resources_ids) ) {
				$session = $this->session->userdata('username');
				$data = array(
					'employee_id' => $this->input->post('employee_id'),
					'visit_type' => $this->input->post('vist_type'),
					'place_from' => $place_from,
					'place_to' => $place_to,
					'end_date' => $ticket_date,
					'ticket_code' => $ticket_code,
					'airline' => $airline_name,
					'amount' => $amount,
					'place_visit' => $place_visit,
					'subject' => $purpose_visit,
					'ticket_image' => $fname,
					'description' => $qt_description,
					'two_way_or_not' => $two_way,
					'return_from' => $return_from,
					'return_to' => $return_to,
					'return_ticket_date' => $return_return_ticket_date,
					'return_ticket_number' => $return_ticket_number,
					'airline_return' => $airline_return,
					'amount_return' => $amount_return,
					'return_descption' => $Return_descption,
					'return_attachment' => $fname_return,
				//  'ticket_status' => $status_updated,
					'is_notify' => '1',
				//	'created_by' => $session['user_id'],
					'created_at' => date('d-m-Y h:i:s'),
            		'first_approval' => $first_approval,
            		'final_approval' => $final_approval,
            		'approved_by_first'=>$approved_by,
            		'approved_by_final'=>$approved_by_final
				);
				$result = $this->Airticket_model->update_record($data, $id);
			} else {
			    //$emergency =  $this->input->post('emergency');
			    $today = date("Y-m-d");
			    $emergency = 0;
			    if($this->input->post('emergency')){
			        $emergency = 1;
			    }
			    
			    $ticket_date = $this->input->post('ticket_date_annual');
                $newEndingDate = date('Y-m-d', strtotime($today. ' +  60 days'));
			    $visit = $this->input->post('vist_type');
                if(strtotime($ticket_date) <= strtotime($newEndingDate) && $emergency == 0 && $visit == 1){
                    //$emergency = 1;
                    $Return['error'] = 'You should choose a ticket date after 2 months';
                    $this->output($Return);
                    
                }
				$data = array(
					'visit_type' => $this->input->post('vist_type'),
					'place_from' => $place_from,
					'place_to' => $place_to,
					'end_date' => $ticket_date,
					//'ticket_code' => $ticket_code,
					'airline' => $airline_name,
					//'amount' => $amount,
					'place_visit' => $place_visit,
					'subject' => $purpose_visit,
					'ticket_image' => $fname,
					'description' => $qt_description,
					'two_way_or_not' => $two_way,
					'return_from' => $return_from,
					'return_to' => $return_to,
					'return_ticket_date' => $return_return_ticket_date,
					'return_ticket_number' => $return_ticket_number,
					'airline_return' => $airline_return,
					'amount_return' => $amount_return,
					'return_descption' => $Return_descption,
					'return_attachment' => $fname_return,
					'emergency' => $emergency,
				//	'created_by' => $session_id,
					'created_at' => date('d-m-Y h:i:s'),
				);
				$result = $this->Airticket_model->update_record($data, $id);
			}
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_ticket_updated');
				if ($count_module_attributes > 0) {
					foreach ($module_attributes as $mattribute) {

						//
						$count_exist_values = $this->Custom_fields_model->count_module_attributes_values($id, $mattribute->custom_field_id);
						if ($count_exist_values > 0) {
							if ($mattribute->attribute_type == 'fileupload') {
								if ($_FILES[$mattribute->attribute]['size'] != 0) {
									if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
										//checking image type
										$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
										$filename = $_FILES[$mattribute->attribute]['name'];
										$ext = pathinfo($filename, PATHINFO_EXTENSION);

										if (in_array($ext, $allowed)) {
											$tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
											$profile = "uploads/custom_files/";
											$set_img = base_url() . "uploads/custom_files/";
											// basename() may prevent filesystem traversal attacks;
											// further validation/sanitation of the filename may be appropriate
											$name = basename($_FILES[$mattribute->attribute]["name"]);
											$newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
											move_uploaded_file($tmp_name, $profile . $newfilename);
											$fname = $newfilename;
										}
										$iattr_data = array(
											'attribute_value' => $fname
										);
										$this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
									}
								} else {
								}
							} else if ($mattribute->attribute_type == 'multiselect') {
								$multisel_val = $this->input->post($mattribute->attribute);
								if (!empty($multisel_val)) {
									$newdata = implode(',', $this->input->post($mattribute->attribute));
									$iattr_data = array(
										'attribute_value' => $newdata,
									);
									$this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
								}
							} else {
								$attr_data = array(
									'attribute_value' => $this->input->post($mattribute->attribute),
								);
								$this->Custom_fields_model->update_att_record($attr_data, $id, $mattribute->custom_field_id);
							}
						} else {
							if ($mattribute->attribute_type == 'fileupload') {
								if ($_FILES[$mattribute->attribute]['size'] != 0) {
									if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
										//checking image type
										$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
										$filename = $_FILES[$mattribute->attribute]['name'];
										$ext = pathinfo($filename, PATHINFO_EXTENSION);

										if (in_array($ext, $allowed)) {
											$tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
											$profile = "uploads/custom_files/";
											$set_img = base_url() . "uploads/custom_files/";
											// basename() may prevent filesystem traversal attacks;
											// further validation/sanitation of the filename may be appropriate
											$name = basename($_FILES[$mattribute->attribute]["name"]);
											$newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
											move_uploaded_file($tmp_name, $profile . $newfilename);
											$fname = $newfilename;
										}
										$iattr_data = array(
											'user_id' => $id,
											'module_attributes_id' => $mattribute->custom_field_id,
											'attribute_value' => $fname,
											'created_at' => date('Y-m-d h:i:s')
										);
										$this->Custom_fields_model->add_values($iattr_data);
									}
								} else {
									if ($this->input->post($mattribute->attribute) == '') {
										$file_val = '';
									} else {
										$file_val = $this->input->post($mattribute->attribute);
									}
									$iattr_data = array(
										'user_id' => $id,
										'module_attributes_id' => $mattribute->custom_field_id,
										'created_at' => date('Y-m-d h:i:s')
									);
									$this->Custom_fields_model->add_values($iattr_data);
								}
							} else if ($mattribute->attribute_type == 'multiselect') {
								$multisel_val = $this->input->post($mattribute->attribute);
								if (!empty($multisel_val)) {
									$newdata = implode(',', $this->input->post($mattribute->attribute));
									$iattr_data = array(
										'user_id' => $id,
										'module_attributes_id' => $mattribute->custom_field_id,
										'attribute_value' => $newdata,
										'created_at' => date('Y-m-d h:i:s')
									);
									$this->Custom_fields_model->add_values($iattr_data);
								}
							} else {
								if ($this->input->post($mattribute->attribute) == '') {
									$file_val = '';
								} else {
									$file_val = $this->input->post($mattribute->attribute);
								}
								$iattr_data = array(
									'user_id' => $id,
									'module_attributes_id' => $mattribute->custom_field_id,
									'attribute_value' => $file_val,
									'created_at' => date('Y-m-d h:i:s')
								);
								$this->Custom_fields_model->add_values($iattr_data);
							}
						}
					}
				}
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}
	public function details()
	{
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$result = $this->Airticket_model->read_ticket_information($id);
		if (is_null($result)) {
			redirect('admin/airticket');
		}
		$edata = array(
			'is_notify' => 0,
		);
		$this->Airticket_model->update_record($edata, $id);
		$user = $this->Xin_model->read_user_info($result[0]->created_by);
		if (!is_null($user)) {
			$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
		} else {
			$full_name = '--';
		}
		$data = array(
			'company_id' => $result[0]->company_id,
			'title' => $this->Xin_model->site_title(),
			'ticket_id' => $result[0]->ticket_id,
			'subject' => $result[0]->subject,
			'ticket_code' => $result[0]->ticket_code,
			'end_date' => $result[0]->end_date,
			'ticket_image' => $result[0]->ticket_image,
			'department_id' => $result[0]->department_id,
			'employee_id' => $result[0]->employee_id,
			'full_name' => $full_name,
			'ticket_priority' => $result[0]->ticket_priority,
			'created_at' => $result[0]->created_at,
			'description' => $result[0]->description,
			'assigned_to' => $result[0]->assigned_to,
			'ticket_status' => $result[0]->ticket_status,
			'ticket_eligibility' => $result[0]->ticket_eligibility,
			'ticket_note' => $result[0]->ticket_note,
			'ticket_remarks' => $result[0]->ticket_remarks,
			'message' => $result[0]->message,
			'airline' => $result[0]->airline,
			'place_from' => $result[0]->place_from,
			'place_to' => $result[0]->place_to,
			'visit_type' => $result[0]->visit_type,
			'amount' => $result[0]->amount,
			'ticket_image' => $result[0]->ticket_image,
			'two_way' => $result[0]->two_way_or_not,
			'return_from' => $result[0]->return_from,
			'return_to' => $result[0]->return_from,
			'return_ticket_date' => $result[0]->return_ticket_date,
			'return_ticket_number' => $result[0]->return_ticket_number,
			'amount_return' => $result[0]->amount_return,
			'return_attachment' => $result[0]->return_attachment,
			'amt_collected_from_emp' => $result[0]->amt_collected_from_emp,
			'paid_status' => $result[0]->paid_status,
			'first_approval' => $result[0]->first_approval,
			'second_approval' => $result[0]->second_approval,
			'final_approval' => $result[0]->final_approval,
			'emergency'    => $result[0]->emergency,
			'all_employees' => $this->Xin_model->all_employees(),
		);
		$data['breadcrumbs'] = $this->lang->line('xin_ticket_details');
		$data['path_url'] = 'tickets_detail';
		$session = $this->session->userdata('username');
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/airticket/ticket_details", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/');
		}
	}
	
	public function encashment_details()
	{
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$result = $this->Airticket_model->read_ticket_encashment_information($id);
		if (is_null($result)) {
			redirect('admin/airticket/ticketencashment');
		}
		/*$edata = array(
			'is_notify' => 0,
		);
		$this->Airticket_model->update_record($edata, $id);
		$user = $this->Xin_model->read_user_info($result[0]->created_by);
		if (!is_null($user)) {
			$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
		} else {
			$full_name = '--';
		}*/
		$data = array(
			'encash_id' => $result[0]->encash_id,
			'employee_id' => $result[0]->employee_id,
			'from_date' => $result[0]->from_date,
			'to_date' => $result[0]->to_date,
			'amount' => $result[0]->amount,
			'reason' => $result[0]->reason,
			'payroll_month' => $result[0]->payroll_month,
			'status' => $result[0]->status,
			'first_approval' => $result[0]->first_approval,
			'second_approval' => $result[0]->second_approval,
			'final_approval' => $result[0]->final_approval,
			'created_at' => $result[0]->created_at
		);
		$data['breadcrumbs'] = 'Encashment Details';
		$data['title']       = 'Encashment Details';
		//$data['path_url'] = 'tickets_detail';
		$session = $this->session->userdata('username');
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/airticket/ticket_encashment_details", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/');
		}
	}
	public function assign_ticket()
	{

		if ($this->input->post('type') == 'ticket_user') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (null != $this->input->post('assigned_to')) {
				$assigned_ids = implode(',', $this->input->post('assigned_to'));
				$employee_ids = $assigned_ids;
			} else {
				$employee_ids = '';
			}

			$data = array(
				'assigned_to' => $employee_ids
			);
			$id = $this->input->post('ticket_id');
			$result = $this->Airticket_model->assign_ticket_user($data, $id);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_ticket_assigned_employee');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}
	public function update_status_validate()
	{

		if ($this->input->post('type') == 'update_status') {
		    
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
	        
	        if ($this->input->post('status') === '') {

				$Return['error'] = "Status is required";
			}
			$this->output($Return);
			exit;
		}
		$this->output($Return);
		exit;
	}
	
	public function update_status()
	{

		if ($this->input->post('type') == 'update_status') {
		    
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
	            $session = $this->session->userdata('username');
    	//	$user_info = $this->Xin_model->read_user_info($session['user_id']);
    	
    	$status   =  $this->input->post('status');
    	
    	$role_resources_ids = $this->Xin_model->user_role_resource(); 
            if (in_array('295', $role_resources_ids)) {
                
            if($status == '4'){
                $data = array(
				'ticket_status' => 3,
				'ticket_remarks' => $this->input->post('remarks'),
				'first_approval' => 1
			);
            }elseif($status == '2'){
                $data = array(
				'ticket_status' => 2,
				'ticket_remarks' => $this->input->post('remarks'),
				'first_approval' => 0,
				'rejection_status' => 1
			);
            }else{
                $data = array(
				'ticket_status' => 3,
				'ticket_remarks' => $this->input->post('remarks'),
				'first_approval' => 0
			);
            }
            }elseif (in_array('296', $role_resources_ids)){
                if($status == '5'){
                $data = array(
				'ticket_status' => 3,
				'ticket_remarks' => $this->input->post('remarks'),
				'second_approval' => 1
			);
            }elseif($status == '2'){
                $data = array(
				'ticket_status' => 2,
				'ticket_remarks' => $this->input->post('remarks'),
				'first_approval' => 0,
				'second_approval' => 0,
				'rejection_status' => 2
			);
            }else{
                $data = array(
				'ticket_status' => $status,
				'ticket_remarks' => $this->input->post('remarks'),
				'second_approval' => 0
			);
            }
            }elseif (in_array('297', $role_resources_ids)){
                if($status == '1'){
                $data = array(
				'ticket_status' => $status,
				'ticket_remarks' => $this->input->post('remarks'),
				'final_approval' => $status
			);
            }elseif($status == '2'){
                $data = array(
				'ticket_status' => 2,
				'ticket_remarks' => $this->input->post('remarks'),
				'first_approval' => 0,
				'second_approval' => 0,
				'final_approval' => 0,
				'rejection_status' => 3
			);
            }else{
                $data = array(
				'ticket_status' => $status,
				'ticket_remarks' => $this->input->post('remarks'),
				'final_approval' => 0
			);
            }
            }
            
		/*	$data = array(
				'ticket_status' => $this->input->post('status'),
				'ticket_remarks' => $this->input->post('remarks'),
				'approved_by_final'=>$session['user_id']
			);*/
			
			$id = $this->input->post('status_ticket_id');
			$result = $this->Airticket_model->update_status($data, $id);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_ticket_status_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}
	
	public function add_note_validate()
	{

		if ($this->input->post('type') == 'add_note') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('ticket_note') === '') {

				$Return['error'] = "Enter any note ";
			}
			$this->output($Return);
			exit;
		}
	}
	
	public function add_note()
	{

		if ($this->input->post('type') == 'add_note') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$data = array(
				'ticket_note' => $this->input->post('ticket_note')
			);
			$id = $this->input->post('token_note_id');
			$result = $this->Airticket_model->update_note($data, $id);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_ticket_note_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function ticket_users()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'ticket_id' => $id,
			'all_designations' => $this->Designation_model->all_designations(),
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/get_ticket_users", $data);
		} else {
			redirect('');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function delete()
	{
		if ($this->input->post('is_ajax') == 2) {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Airticket_model->delete_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_ticket_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	public function encashment_delete()
	{
		if ($this->input->post('is_ajax') == 2) {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Airticket_model->delete_encashrecord($id);
			if (isset($id)) {
				$Return['result'] = 'Air ticket Encashment Deleted';
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	public function comment_delete()
	{
		if ($this->input->post('data') == 'ticket_comment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Airticket_model->delete_comment_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_ticket_comment_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	public function attachment_delete()
	{
		if ($this->input->post('data') == 'ticket_attachment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Airticket_model->delete_attachment_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_ticket_attachment_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	public function comments_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		//$id = $this->input->get('ticket_id');
		$id = $this->uri->segment(4);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/airticket_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$comments = $this->Airticket_model->get_comments($id);

		$data = array();

		foreach ($comments->result() as $r) {

			// get user > employee_
			$employee = $this->Xin_model->read_user_info($r->user_id);
			// employee full name
			if (!is_null($employee)) {
				$employee_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
				// get designation
				$_designation = $this->Designation_model->read_designation_information($employee[0]->designation_id);
				if (!is_null($_designation)) {
					$designation_name = $_designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// profile picture
				if ($employee[0]->profile_picture != '' && $employee[0]->profile_picture != 'no file') {
					$u_file = base_url() . 'uploads/profile/' . $employee[0]->profile_picture;
				} else {
					if ($employee[0]->gender == 'Male') {
						$u_file = base_url() . 'uploads/profile/default_male.jpg';
					} else {
						$u_file = base_url() . 'uploads/profile/default_female.jpg';
					}
				}
			} else {
				$employee_name = '--';
				$designation_name = '--';
				$u_file = '--';
			}
			// created at
			$created_at = date('h:i A', strtotime($r->created_at));
			$_date = explode(' ', $r->created_at);
			$date = $this->Xin_model->set_date_format($_date[0]);
			///
			$link = '<a class="c-user text-black" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><span class="underline">' . $employee_name . ' (' . $designation_name . ')</span></a>';


			if ($employee[0]->user_role_id == 1) {
				$dlink = '<div class="media-right">
						<div class="c-rating">
						<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '">
							<a class="btn btn-danger btn-sm delete" href="#" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->comment_id . '">
		  <i class="fa fa-trash m-r-0-5"></i>' . $this->lang->line('xin_delete') . '</a></span>
						</div>
					</div>';
			} else {
				$dlink = '';
			}

			$function = '<div class="c-item">
					<div class="media">
						<div class="media-left">
							<div class="avatar box-48">
							<img class="b-a-radius-circle" src="' . $u_file . '" style="width: 50px">
							</div>
						</div>
						<div class="media-body">
							<div class="mb-0-5">
								' . $link . '
								<span class="font-90 text-muted">' . $date . ' ' . $created_at . '</span>
							</div>
							<div class="c-text">' . $r->ticket_comments . '</div>
						</div>
						' . $dlink . '
					</div>
				</div>';

			$data[] = array(
				$function
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $comments->num_rows(),
			"recordsFiltered" => $comments->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function set_comment_validate()
	{

		if ($this->input->post('add_type') == 'set_comment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('xin_comment') === '') {
				$Return['error'] = $this->lang->line('xin_error_comment_field');
			}
			$xin_comment = $this->input->post('xin_comment');
			$qt_xin_comment = htmlspecialchars(addslashes($xin_comment), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$this->output($Return);
			exit;
		}
	}
	
	public function set_comment()
	{

		if ($this->input->post('add_type') == 'set_comment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('xin_comment') === '') {
				$Return['error'] = $this->lang->line('xin_error_comment_field');
			}
			$xin_comment = $this->input->post('xin_comment');
			$qt_xin_comment = htmlspecialchars(addslashes($xin_comment), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'ticket_comments' => $qt_xin_comment,
				'ticket_id' => $this->input->post('comment_ticket_id'),
				'user_id' => $this->input->post('user_id'),
				'created_at' => date('d-m-Y h:i:s')

			);
			$result = $this->Airticket_model->add_comment($data);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_ticket_comment_added');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}
	
	public function add_attachment_validate()
	{

		if ($this->input->post('add_type') == 'dfile_attachment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('file_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_name');
			} else if ($_FILES['attachment_file']['size'] == 0) {
				$Return['error'] = $this->lang->line('xin_error_task_file');
			} else if ($this->input->post('file_description') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_description');
			}
			$description = $this->input->post('file_description');
			$file_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			// is file upload
			if (is_uploaded_file($_FILES['attachment_file']['tmp_name'])) {
				//checking image type
				$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'doc', 'docx', 'xls', 'xlsx', 'txt');
				$filename = $_FILES['attachment_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);

				if (in_array($ext, $allowed)) {
					$tmp_name = $_FILES["attachment_file"]["tmp_name"];
					$attachment_file = "uploads/airticket/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$name = basename($_FILES["attachment_file"]["name"]);
					$newfilename = 'ticket_' . round(microtime(true)) . '.' . $ext;
					move_uploaded_file($tmp_name, $attachment_file . $newfilename);
					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
				} else {
					$Return['error'] = $this->lang->line('xin_error_task_file_attachment');
				}
			}

			$this->output($Return);
			exit;
		}
	}
	
	public function add_attachment()
	{

		if ($this->input->post('add_type') == 'dfile_attachment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('file_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_name');
			} else if ($this->input->post('file_description') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_description');
			}
			$description = $this->input->post('file_description');
			$file_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			// is file upload
			if ($this->input->post('attachment') != '' || $this->input->post('attachment') != 'undefined'){
					$fname = $this->input->post('attachment');
				
			}
			else
			{
			    $fname = '';
			}

			$data = array(
				'ticket_id' => $this->input->post('c_ticket_id'),
				'upload_by' => $this->input->post('user_file_id'),
				'file_title' => $this->input->post('file_name'),
				'file_description' => $file_description,
				'attachment_file' => $fname,
				'created_at' => date('d-m-Y h:i:s')
			);
			$result = $this->Airticket_model->add_new_attachment($data);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_ticket_attachment_added');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}
	public function attachment_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		//$id = $this->input->get('ticket_id');
		$id = $this->uri->segment(4);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/airticket/airticket_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$attachments = $this->Airticket_model->get_attachments($id);
		if ($attachments->num_rows() > 0) {
			$data = array();

			foreach ($attachments->result() as $r) {
				$employee = $this->Xin_model->read_user_info($r->upload_by);
				if ($employee[0]->user_role_id == 1) {

					$delopt = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn btn-danger btn-sm m-b-0-0 waves-effect waves-light delete-file" data-toggle="modal" data-target=".delete-modal-file" data-record-id="' . $r->ticket_attachment_id . '"><i class="fa fa-trash"></i></button></span>';
				} else {
					$delopt = '';
				}

				$data[] = array(
					'<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/download/?type=airticket/&filename=' . $r->attachment_file . '"><button type="button" class="btn btn-secondary btn-sm m-b-0-0 waves-effect waves-light"><i class="fa fa-download"></i></button></a></span>' . $delopt,
					$r->file_title,
					$r->file_description,
					$r->created_at
				);
			}

			$output = array(
				"draw" => $draw,
				"recordsTotal" => $attachments->num_rows(),
				"recordsFiltered" => $attachments->num_rows(),
				"data" => $data
			);
		} else {
			$data[] = array('', '', '', '');


			$output = array(
				"draw" => $draw,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => $data
			);
		}
		echo json_encode($output);
		exit();
	}
	public function get_employees_year_check()
	{
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(5);
		$ticke_date = $this->uri->segment(4);
        $joining_date=$this->Timesheet_model->joining_date($id);
        if($joining_date){
            $joining_date = $joining_date[0]->date_of_joining;
            $newEndingDate = date('Y-m-d', strtotime($joining_date. ' +  365 days'));
            if(strtotime($ticke_date) >= strtotime($newEndingDate)){
                $html ="<br/><span style='padding-left: 34px;color:red;'><b>Note*</b> :One year completed this employee</span>";
            }else{
                $html ="<br/><span style='padding-left: 34px;color:red;'><b>Note*</b> :This employee not completed one year</span>";
            }
            print_r($html);
		exit();
           
        }
		
	}
	
	public function getemp_encash_amt(){
    // POST data
    $postData = $this->input->post();
    // get data
    $data                = $this->Employees_model->getemp_encashamount($postData);
    /*$data['totaltickets']        = $postData['totaltickets'];
    $data['tickets_for_encash']  = $postData['tickets_for_encash'];*/
    
    echo json_encode($data);
  
    }
    
    public function getemp_no_of_tickets(){
    // POST data
    $postData = $this->input->post();
    // get data
    $data = $this->Employees_model->getemp_no_of_tickets($postData);

    echo json_encode($data);
  
    }
    
    public function get_date_of_join(){
    // POST data
    $postData = $this->input->post();
    // get data
    $data = $this->Employees_model->getemp_date_of_join($postData);

    echo json_encode($data);
  
    }
    
    public function get_encash_startdate(){
        $postData = array();
        $response = array();
        $postData = $this->input->post();
        $empdata  = $this->Employees_model->get_employee_date_of_join($postData['empid']);
        $doj      = $empdata[0]->date_of_joining;
		$duration = $this->Airticket_model->getemp_duration($postData['empid']);
		$empdate  = $this->Airticket_model->getemp_ticketdate($postData['empid']);
		//$emp_encash        = $this->Airticket_model->getemp_encashments($postData['empid']);
		$emp_encash        = $this->Airticket_model->getemp_encashmentinfo($postData['empid']);
		if($empdate && $emp_encash){
		       /*$startdate   = $empdate[0]->end_date;*/
		       $ticket_end = $empdate[0]->duration_to;
		       $encash_end = $emp_encash[0]->to_date;
		       $dates      = array($ticket_end, $encash_end);
               $startdate  = max($dates);
		       
		       //$startdate   = $empdate[0]->duration_to;
		       $startdate   = date('Y-m-d', strtotime($startdate. ' +1 days'));
			   
		}elseif($empdate){
		       /*$startdate   = $empdate[0]->end_date;*/
		       $startdate   = $empdate[0]->duration_to;
		       $startdate   = date('Y-m-d', strtotime($startdate. ' +1 days'));
			   
		}else{
		    //$emp_encash        = $this->Airticket_model->getemp_encashments($postData['empid']);
		    if($emp_encash){
		       $startdate      = $emp_encash[0]->to_date;
		       $startdate      = date('Y-m-d', strtotime($startdate. ' +1 days'));
		    }else{
		       $startdate      = $empdata[0]->date_of_joining;
		    }
		}
		  $response['newStartingDate']      = $startdate;
		
			if($duration){
				$emp_years  = $duration[0]->type;
				$emp_days   = $emp_years * 365;
				}
			else{
				$emp_days   = 365;
			}
		$years = 0;
		for($i = strtotime($startdate); $i< time(); ){
		    
			$i = $i + ($emp_days*3600*24);
			if($i> time()){
			     break;
			 }
		  if($emp_days == 365){
		      $years += $emp_days/365;
		  }else{
		      $years += $emp_days/730;
		  }
		  
		  $response['newEndingDate']    = date('Y-m-d', $i);
			      
		}
		  $response['years'] = $years;
		  $no_oftickets = $this->Employees_model->getemp_no_of_tickets($postData);
		  if($no_oftickets){
		      $response['no_of_tickets'] = (int)$no_oftickets[0]['no_of_tickets'] * $years;
		  }else{
		      $response['no_of_tickets'] = 0;
		  }
		  $role_resources_ids = $this->Xin_model->user_role_resource();
		  
		  
		// For getting count of feb 29 in between two date ranges
		if(isset($response['newEndingDate'] )){
		$j = 0;
		$date1 = $response['newStartingDate'];
		$date2 = $response['newEndingDate'];
        for($i= strtotime($date1); $i <= strtotime($date2);){
            
            $daysinmonth = date('t', $i);
            
            if(date('n',$i) == 2){
                if($daysinmonth > 28){
                    $j++;
                }
            }
            
            $i = $i + (3600*24*$daysinmonth);
            
        }
        
        $j -= 1;
        
        $response['newEndingDate']  = date('Y-m-d', strtotime($date2. '+'.$j.' days'));
		}
	
		
		if(in_array('508',$role_resources_ids)) {
		if(!isset($response['newEndingDate'] )){
		  $response['error'] = "You are not eligible for encashment now";
		}
		}
		  echo json_encode($response);
    }
    public function getempnames(){
        $states = array();
        $location_id = $this->input->post('location_id');
        if($location_id){
            $con['conditions'] = array('location_id'=>$location_id);
            $states = $this->Airticket_model->getEmpRows($con);
        }
        echo json_encode($states);
    }
    //////////////////////////////////////////////////////////////////////////////////////////////
    public function add_ticket_validate()
	{

		if ($this->input->post('add_type') == 'ticket') {
		    $description = '';
			$session_id = $this->input->post('session_id');
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$role_resources_ids = $this->Xin_model->user_role_resource();
			if ($session_id == 1) {
				$assigned_to = $this->input->post('employee_id');
				/* Server side PHP input validation */
				/*if ($this->input->post('company') === '') {
					$Return['error'] = $this->lang->line('xin_error_company');
				} else if ($this->input->post('department_id') === '') {
					$Return['error'] = $this->lang->line('xin_employee_error_department');
				}*/  if (empty($assigned_to)) {
					$Return['error'] = $this->lang->line('xin_error_employee_id');
				} /*else if ($this->input->post('amount_collected_from_emp') === '') {
					$Return['error'] = 'Amount collected from employee is required';
				}*/
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}
			else{
			    $today = date("Y-m-d");
			    //$emergency = $this->input->post('emergency');
			    $emergency = 0;
			    if($this->input->post('emergency')){
			        $emergency = 1;
			    }
			    if($this->input->post('ticket_date_annual')){
			        $ticketdate = $this->input->post('ticket_date_annual');
                    $newEndingDate = date('Y-m-d', strtotime($today. ' +  60 days'));
			    }
			    else{
			        $ticketdate = $this->input->post('end_date');
                    $newEndingDate = date('Y-m-d', strtotime($today. ' +  60 days'));
			    }
			    
			    $visit = $this->input->post('vist_type');
                if(strtotime($ticketdate) <= strtotime($newEndingDate) && $emergency == 0 && $visit == 1){
                    //$emergency = 1;
                    $Return['error'] = 'You should choose a ticket date after 2 months';
                    $this->output($Return);
                    
                }/*else{
                    //$emergency = 0;
                }*/
			}
			/* visit type validations */
			if ($this->input->post('vist_type') === '') {
				$Return['error'] = $this->lang->line('xin_error_visit_type');
			} else  if ($this->input->post('ticket_status') === '') {
				$Return['error'] = 'Status';
			}
			if ($this->input->post('vist_type') == 1) {
				/*annual visit type validations */
				if ($this->input->post('ticket_date_annual') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline_annual') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from_annual') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to_annual') === '') {
					$Return['error'] = 'Place To';
				} /*else if ($this->input->post('amount_annual') === '') {
					$Return['error'] = 'Amount';
				}*/ /*else if ($this->input->post('ticket_code_annual') === '') {
					$Return['error'] = 'Ticket Number is required';
				}*/ else if ($this->input->post('two_way_air_ticket1') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} /*else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					} else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					}*/ else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} /*else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}*/
					/* end Others two way ticket  validations */
				}
				/*end annual visit type validations */
			} else if ($this->input->post('vist_type') == 2) {
				/* others visit type validations */
				if ($this->input->post('end_date') === '') {
					$Return['error'] = 'Ticket Date';
				} else if ($this->input->post('airline') === '') {
					$Return['error'] = 'Name of Airline';
				} else if ($this->input->post('place_from') === '') {
					$Return['error'] = 'Place From';
				} else if ($this->input->post('place_to') === '') {
					$Return['error'] = 'Place To';
				} else if ($this->input->post('place_vist') === '') {
					$Return['error'] = 'Place Of Visit';
				} else if ($this->input->post('subject') === '') {
					$Return['error'] = 'Purpose of Visit';
				} /*else if ($this->input->post('amount') === '') {
					$Return['error'] = 'Amount';
				}*/ /*else if ($this->input->post('ticket_code') === '') {
					$Return['error'] = 'Ticket Number is required';
				}*/ else if ($this->input->post('two_way_air_ticket') == 1) {
					/* Others two way ticket  validations */
					if ($this->input->post('place_return_from') === '') {
						$Return['error'] = 'Return From is required';
					} else if ($this->input->post('return_place_to') === '') {
						$Return['error'] = 'Place To is required';
					} else if ($this->input->post('return_ticket_date') === '') {
						$Return['error'] = 'Return Ticket Date is required';
					} /*else if ($this->input->post('return_ticket_number') === '') {
						$Return['error'] = 'Return Ticket Number is required';
					}*/ else if ($this->input->post('airline_return') === '') {
						$Return['error'] = 'Name of Airlines Return is required';
					} /*else if ($this->input->post('amount_return') === '') {
						$Return['error'] = 'Return Amount is required';
					}*/
					/* end Others two way ticket  validations */
				}
				/* end others visit type validations */
			}
			/*end visit type validations */

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$two_way = $Return_descption = $ticket_code = $place_from = $place_to = $ticket_date = $airline_name = $amount = $place_visit = $purpose_visit = $fname  = '';
			$return_from = $return_to = $return_return_ticket_date = $return_ticket_number = $airline_return = $amount_return = $fname_return = '';
			$fname_return = 0;
			if ($this->input->post('vist_type') == 1) {
				$description = $this->input->post('description_annual');
				$two_way = $this->input->post('two_way_air_ticket1');
				if ($this->input->post('two_way_air_ticket1') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
					if ($_FILES['attachment_return']['size'] > 0) {
						if (is_uploaded_file($_FILES['attachment_return']['tmp_name'])) {
							//checking image type
							$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
							$filename = $_FILES['attachment_return']['name'];
							$ext = pathinfo($filename, PATHINFO_EXTENSION);

							if (in_array($ext, $allowed)) {
								$tmp_name = $_FILES["attachment_return"]["tmp_name"];
								$profile = "uploads/airticket/";
								$set_img = base_url() . "uploads/airticket/";
								// basename() may prevent filesystem traversal attacks;
								// further validation/sanitation of the filename may be appropriate
								$name = basename($_FILES["attachment_return"]["name"]);
								$newfilename = 'ticket_attachment_return_' . round(microtime(true)) . '.' . $ext;
								move_uploaded_file($tmp_name, $profile . $newfilename);
								$fname_return = $newfilename;
								$Return['fileName3'] = $fname;
							} else {
								$Return['error'] = $this->lang->line('xin_error_attatchment_type');
							}
						}
					} else {
						$fname_return = 0;
					}
				}
				$place_from = $this->input->post('place_from_annual');
				$ticket_code = $this->input->post('ticket_code_annual');
				$place_to = $this->input->post('place_to_annual');
				$ticket_date = $this->input->post('ticket_date_annual');
				$airline_name = $this->input->post('airline_annual');
				$amount =  $this->input->post('amount_annual');

				if ($_FILES['attachment_annual']['size'] > 0) {
					if (is_uploaded_file($_FILES['attachment_annual']['tmp_name'])) {
						//checking image type
						$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
						$filename = $_FILES['attachment_annual']['name'];
						$ext = pathinfo($filename, PATHINFO_EXTENSION);

						if (in_array($ext, $allowed)) {
							$tmp_name = $_FILES["attachment_annual"]["tmp_name"];
							$profile = "uploads/airticket/";
							$set_img = base_url() . "uploads/airticket/";
							// basename() may prevent filesystem traversal attacks;
							// further validation/sanitation of the filename may be appropriate
							$name = basename($_FILES["attachment_annual"]["name"]);
							$newfilename = 'ticket_attachment_' . round(microtime(true)) . '.' . $ext;
							move_uploaded_file($tmp_name, $profile . $newfilename);
							$fname = $newfilename;
							$Return['fileName2'] = $fname;
						} else {
							$Return['error'] = $this->lang->line('xin_error_attatchment_type');
						}
					}
				} else {
					$fname = '0';
				}
			} else if ($this->input->post('vist_type') == 2) {
				$description = $this->input->post('description');
				if ($this->input->post('two_way_air_ticket') == 1) {
					$Return_descption =  $this->input->post('description_return');
					$return_from = $this->input->post('place_return_from');
					$return_to = $this->input->post('return_place_to');
					$return_return_ticket_date = $this->input->post('return_ticket_date');
					$return_ticket_number = $this->input->post('return_ticket_number');
					$airline_return = $this->input->post('airline_return');
					$amount_return = $this->input->post('amount_return');
					if ($_FILES['attachment_return']['size'] > 0) {
						if (is_uploaded_file($_FILES['attachment_return']['tmp_name'])) {
							//checking image type
							$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
							$filename = $_FILES['attachment_return']['name'];
							$ext = pathinfo($filename, PATHINFO_EXTENSION);

							if (in_array($ext, $allowed)) {
								$tmp_name = $_FILES["attachment_return"]["tmp_name"];
								$profile = "uploads/airticket/";
								$set_img = base_url() . "uploads/airticket/";
								// basename() may prevent filesystem traversal attacks;
								// further validation/sanitation of the filename may be appropriate
								$name = basename($_FILES["attachment_return"]["name"]);
								$newfilename = 'ticket_attachment_return_' . round(microtime(true)) . '.' . $ext;
								move_uploaded_file($tmp_name, $profile . $newfilename);
								$fname_return = $newfilename;
								$Return['fileName3'] = $fname;
							} else {
								$Return['error'] = $this->lang->line('xin_error_attatchment_type');
							}
						}
					} else {
						$fname_return = 0;
					}
				}
				$ticket_code = $this->input->post('ticket_code');
				$place_from = $this->input->post('place_from');
				$place_to = $this->input->post('place_to');
				$ticket_date = $this->input->post('end_date');
				$airline_name = $this->input->post('airline');
				$amount =  $this->input->post('amount');
				$place_visit = $this->input->post('place_visit');
				$purpose_visit = $this->input->post('subject');
				$two_way = $this->input->post('two_way_air_ticket');

				if ($_FILES['attachment']['size'] > 0) {
					if (is_uploaded_file($_FILES['attachment']['tmp_name'])) {
						//checking image type
						$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
						$filename = $_FILES['attachment']['name'];
						$ext = pathinfo($filename, PATHINFO_EXTENSION);

						if (in_array($ext, $allowed)) {
							$tmp_name = $_FILES["attachment"]["tmp_name"];
							$profile = "uploads/airticket/";
							$set_img = base_url() . "uploads/airticket/";
							// basename() may prevent filesystem traversal attacks;
							// further validation/sanitation of the filename may be appropriate
							$name = basename($_FILES["attachment"]["name"]);
							$newfilename = 'ticket_attachment_' . round(microtime(true)) . '.' . $ext;
							move_uploaded_file($tmp_name, $profile . $newfilename);
							$fname = $newfilename;
							$Return['fileName1'] = $fname;
						} else {
							$Return['error'] = $this->lang->line('xin_error_attatchment_type');
						}
					}
				} else {
					$fname = '0';
				}
				$this->output($Return);
				exit;
			}
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
	}
	public function add_ticketencashment_validate(){
	    $session_id = $this->input->post('session_id');
	    $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		global $encash_eligible;
		if(in_array('508',$role_resources_ids)) {
		    
		$employeeid             = $this->input->post('employee_id');
		$start_date             = $this->input->post('start_date');
		$end_date               = $this->input->post('end_date');
		$no_of_tickets          = $this->input->post('no_of_tickets');
		$tickets_for_encash     = $this->input->post('tickets_for_encash');
		$place_to               = $this->input->post('place_to');
		$amount                 = $this->input->post('amount');
		$reason                 = $this->input->post('reason');
		$payroll_month          = $this->input->post('month_year');
		$status                 = $this->input->post('status');
		
		
		$getemp_payroll_status = $this->Airticket_model->getemp_payroll_status($employeeid,$payroll_month);
		if($getemp_payroll_status > 0){
			    $Return['error'] = 'Employee Payment already done for this month.';
			    $this->output($Return);
		}
		
		$duration   = $this->Airticket_model->getemp_duration($employeeid);
			if($duration){
				$emp_years  = $duration[0]->type;
				$emp_days   = $emp_years * 365;
				$tickets = $duration[0]->no_of_tickets;
				}
			else{
				$emp_days   = 365;
				$tickets    = 1;
				}
				
		$today     =  date('Y-m-d');
		if(strtotime($end_date) >= strtotime($today)){
                $encash_eligible = "no";
                }
		
		if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for this date range.';
			    $this->output($Return);
			}
			
		if($tickets_for_encash > $no_of_tickets){
			    $Return['error'] = 'Tickets to be Encashed should be less than or equal to number of tickets';
			    $this->output($Return);
		}
		
		if($no_of_tickets >= $tickets_for_encash){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}
			    	
		$this->output($Return);
		exit;
		}
		else{
		$com_id     = $this->Airticket_model->airticket($session_id);
		$empid      = $com_id[0]->user_id;
		
		$duration   = $this->Airticket_model->getemp_duration($empid);
			if($duration){
				$emp_years  = $duration[0]->type;
				$emp_days   = $emp_years * 365;
				$tickets = $duration[0]->no_of_tickets;
				}
			else{
				$emp_days   = 365;
				$tickets = 1;
				}
		
		$start_date             = $this->input->post('start_date');
		$end_date               = $this->input->post('end_date');
		$no_of_tickets          = $this->input->post('no_of_tickets');
		$tickets_for_encash     = $this->input->post('tickets_for_encash');
		$place_to               = $this->input->post('place_to');
		$amount                 = $this->input->post('amount');
		$reason                 = $this->input->post('reason');	
		
		if(empty($end_date)){
			    $Return['error'] = 'Not eligible for encashment now';
			    $this->output($Return);
			}
		
		$today           =  date('Y-m-d');
		if(strtotime($end_date) >= strtotime($today)){
                $encash_eligible = "no";
            }
		
		if($encash_eligible == "no"){
			    $Return['error'] = 'You are not eligible to apply for this date range.';
			    $this->output($Return);
			}
		if($tickets_for_encash > $no_of_tickets){
			    $Return['error'] = 'Tickets to be Encashed should be less than or equal to number of tickets';
			    $this->output($Return);
		}
		
		if($no_of_tickets >= $tickets_for_encash){
		    if($tickets == 1){
		        $end            = $tickets_for_encash*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		    }elseif($tickets == 2){
		        $check_no = $tickets_for_encash % 2;
		      if($check_no !== 0){
		        $Return['error'] = 'Tickets to be Encashed should be multiple of 2';
			    $this->output($Return);
		      }else{
		        $end            = ($tickets_for_encash/2)*365;
		        $end_date       = date('Y-m-d', strtotime($start_date. ' + ' .$end.' days'));
		      }
		      
		    }
		}
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
		
		}
	}
	public function get_airtickets_pdf() {
	   	$data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        
			// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id == 2){
		    $ticket = $this->Airticket_model->read_employee_ticketinfo($session['user_id']);
		}
		else{
		    $ticket = $this->Airticket_model->get_tickets();
		}
	
		$data = array();
		$cdate = strtotime(date('Y-m-d'));
		foreach ($ticket->result() as $r) {

			// priority
			if ($r->ticket_status == 1) :
				$priority = 'Approved';
			elseif ($r->ticket_status == 2) :
				$priority = 'Cancelled';
			elseif ($r->ticket_status == 3) :
			$priority = 'Pending';

			endif;
			$eend_date = strtotime($r->end_date);
		/*	if ($cdate > $eend_date) {
				$xpired = '<span class="badge bg-red">' . $this->lang->line('xin_expired_title') . '</span>';
			} else {
				$xpired = '';
			}*/
			$end_date = $this->Xin_model->set_date_format($r->end_date);

			// status 
			if ($r->ticket_status == 1) :
				$status = '<span class="badge bg-orange">' . 'Approved ' . '</span> ';
			else :
				$status = '<span class="badge bg-green">' . 'Cancelled' . '</span> ';
			endif;
				if ($r->ticket_status == 3) {
        			if ($r->first_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
        			}
        			if ($r->second_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
        			}
        			if ($r->final_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
        			}
        		}
        		
        		if ($r->ticket_status == 2) {
        			if ($r->rejection_status == 1) {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First Rejection</span>';
        			}
        			elseif ($r->rejection_status == 2) {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second Rejection</span>';
        			} 
        			elseif ($r->rejection_status == 3) {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final Rejection</span>';
        			} 
        		}
        		
			// ticket date and time
			$created_at = date('h:i A', strtotime($r->created_at));
			$_date = explode(' ', $r->created_at);
			$edate = $this->Xin_model->set_date_format($_date[0]);
			$_created_at = $edate . ' ' . $created_at;

			// get company name
			$p_company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($p_company)) {
				$company = $p_company[0]->name;
			} else {
				$company = '--';
			}
			// created by
			$created_by = $this->Xin_model->read_user_info($r->created_by);
			if (!is_null($created_by)) {
				$ticket_created_by = $created_by[0]->first_name . ' ' . $created_by[0]->last_name;
			} else {
				$ticket_created_by = '';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			// ticket attachment
			 if($r->ticket_image && $r->ticket_image != '0' && $r->ticket_image != '--') {
				$timage = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'uploads/airticket/' . $r->ticket_image . '" target="_blank" download><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light"><span class="fa fa-download"></span></button></a></span>';
			}else {
				$timage = '';
			}

			$user_id = $session['user_id'];
			$role = $this->Airticket_model->role($user_id);

			$eticket_info = $this->Airticket_model->get_ticket_employees($r->employee_id);
			$ol = $assigned_name = '';

			$assigned_to = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($assigned_to)) {

				$assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
				if ($assigned_to[0]->profile_picture != '' && $assigned_to[0]->profile_picture != 'no file') {
					$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $assigned_to[0]->profile_picture . '" class="user-image-hr" alt=""></span></a>';
				} else {
					if ($assigned_to[0]->gender == 'Male') {
						$de_file = base_url() . 'uploads/profile/default_male.jpg';
					} else {
						$de_file = base_url() . 'uploads/profile/default_female.jpg';
					}
					$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . $de_file . '" class="user-image-hr" alt=""></span></a>';
				}
			} ////
			else {
				$ol .= '';
			}

			$ol .= '';
			$iemployee_name = '<span class="badge bg-orange">'.$assigned_name.'</span>';
			$iticket_code = $r->ticket_code . '<br><small class="text-muted"><i>' . $status . '<i></i></i></small>';
			$ipriority = $priority . '<br><small class="text-muted"><i>' . $end_date . '<i></i></i></small>';
		
			   $data[] = array(
			   
				'iemployee_name' => $iemployee_name,
				'created_at' => $_created_at,
				'ticket_created_by' => $ticket_created_by,
				'ipriority' => $ipriority,
			
			    ); 
			
			
		}
    // print_r($data);exit;
 	//--------------------------------------

    $this->load->library('M_pdf');
    $mpdf = $this->m_pdf->load([
    'mode' => 'utf-8',
    'format' => 'A4'
    ]);
    $res['lists'] = $data;
    $html = $this->load->view("admin/airticket/get_airticket_pdf_format", $res, true);
    $mpdf->WriteHTML($html);
    $mpdf->Output('Airticket.pdf', 'D'); //
		
      

	}
	public function get_encashment_pdf() {
	   	$data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        
	// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$encashment = $this->Airticket_model->get_ticket_encashments();


		$data = array();
		$cdate = strtotime(date('Y-m-d'));
		foreach ($encashment->result() as $r) {
		
			
			// ticket date and time
			$created_at = date('h:i A', strtotime($r->created_at));
			$_date = explode(' ', $r->created_at);
			$edate = $this->Xin_model->set_date_format($_date[0]);
			$_created_at = $edate . ' ' . $created_at;
	

			$user_id = $session['user_id'];
			$role = $this->Airticket_model->role($user_id);

			
			$approve = '<span data-toggle="tooltip" data-placement="top" title="View Details"><a href="' . site_url() . 'admin/airticket/encashment_details/' . $r->encash_id . '"><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light"><span class="fa fa-arrow-circle-right"></span></button></a></span>';
			
			$assigned_to   = $this->Xin_model->read_user_info($r->employee_id);
		    $assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
            
            if ($r->status == "Approved") :
				$priority = 'Approved';
			elseif ($r->status == "Pending") :
				$priority = 'Pending';
			elseif ($r->status == "Cancelled") :
			$priority = 'Cancelled';

			endif;

				if ($r->status == "Pending") {
        			if ($r->first_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
        			}
        			if ($r->second_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
        			}
        			if ($r->final_approval == 1) {
        				$priority .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
        			} else {
        				$priority .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
        			}
        		}
        		
			$data[] = array(
			'assigned_name' => $assigned_name,
			'from_date' => 	$r->from_date,
			'to_date' =>  $r->to_date,
			'amount' =>  $this->Xin_model->company_currency_sign($r->amount, $role[0]->company_id),
			'priority' =>  $priority,
			'created_at,' =>  $_created_at,
			);
		} 	//--------------------------------------

    $this->load->library('M_pdf');
    $mpdf = $this->m_pdf->load([
    'mode' => 'utf-8',
    'format' => 'A4'
    ]);
    $res['lists'] = $data;
    $html = $this->load->view("admin/airticket/get_encahment_pdf_format", $res, true);
    $mpdf->WriteHTML($html);
    $mpdf->Output('Airticket Encashment.pdf', 'D'); //
		
      

	}
}
