<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Artify_api extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        //load the model
        $this->load->model("Timesheet_model");
        $this->load->model("Xin_model");
        $this->load->model("Employees_model");
        $this->load->library('email');
    }

    public function leave_details()
    {
        $Return = array('result' => '', 'error' => '', 'csrf_hash' => '', 'probation_check' => '');
        $leave_id = $this->input->post('leave_id');
        $employee_id = $this->input->post('employee_id');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $leave_type_id = $this->input->post('leave_type_id');

        $result = $this->Timesheet_model->read_leave_information($leave_id);
        $probation_check = $result[0]->probation_check;
        $leave_type_id = $result[0]->leave_type_id;
        $date_current = date('Y-m-d');
        $user_leave = $this->Xin_model->read_user_info($employee_id);
        $d1 = strtotime($date_current);
        $d2 = strtotime($user_leave[0]->date_of_joining);
        $totalSecondsDiff = abs($d1 - $d2);
        $totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;
        $probation_period = $user_leave[0]->probation_period;

        if ($totalMonthsDiff < $probation_period && $probation_check == '' && $leave_type_id != 8 && $leave_type_id != 5 && $leave_type_id != 6) {
            $Return['probation_check'] = "lop";
        } else if (($totalMonthsDiff < $probation_period && $probation_check == '') || ($totalMonthsDiff <= 12) && $leave_type_id == 5 || $leave_type_id == 6) {
            $Return['probation_check'] = "from_leave";
        }

        $leave_paid_start = $leave_paid_end = $upaid_leaves_start = $leave_half_pay_start = $leave_half_pay_end = $upaid_leaves_end = '';
        $sick_leave_exceed_limit_flag = 0;
        if ($leave_type_id == 4) {

            $flag_unpaid_exta = $sick_leave_exceed_limit_flag = 0;
            $carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employee_id, $leave_type_id);
            $count = '';
            $check_date = '';
            $leave = $this->Timesheet_model->get_leave_employees_new_Cron($employee_id, 4);
            foreach ($leave->result() as $r) {
                if ($r->type_name) {
                    $emp = $this->Timesheet_model->get_em($r->employee_id);
                    $emp[0]->leave_updated_date;
                    $start_date_y = date('Y', strtotime($emp[0]->leave_updated_date));
                    $date_value = date('Y-m-d');
                    $compaire = date('Y', strtotime($start_date_y));
                    $check_date = date('Y', strtotime($r->created_at));
                    if ($r->leave_type == '3' || $r->leave_type == '4') {
                        if ($check_date != $compaire) {
                            $count = '0';
                        } else {
                            $count = $r->leave_count;
                        }
                    } else {
                        $count = $r->leave_count;
                    }
                }
            }
            if (isset($carry_count[0]->remaing_leave_count)) {
                $emp_leave_count = ($count) ? $count : $carry_count[0]->remaing_leave_count;
            } else {
                $emp_leave_count = 0;
            }

            /* Employee informations */
            $emp_info = $this->Employees_model->read_emp($employee_id);
            /* End Employee leave information */
            $cond = array('leave_id' => $leave_id, 'emp_id' => $employee_id, 'status' => 'Y');
            $check_sick_mangement_exists = $this->Timesheet_model->common_select('xin_emp_sickleave_manage', $cond);
            if ($check_sick_mangement_exists) {
                $leave_paid_start = $check_sick_mangement_exists[0]->paid_start_date;
                $leave_paid_end = $check_sick_mangement_exists[0]->paid_end_date;
                $leave_half_pay_start = $check_sick_mangement_exists[0]->halfpaid_start_date;
                $leave_half_pay_end = $check_sick_mangement_exists[0]->halfpaid_end_date;
                $upaid_leaves_start = $check_sick_mangement_exists[0]->unpaid_start_date;
                $upaid_leaves_end = $check_sick_mangement_exists[0]->unpaid_end_date;
            } else {

                $datetime1 = new DateTime($from_date);
                $datetime2 = new DateTime($to_date);
                $interval = $datetime1->diff($datetime2);

                $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employee_id, $leave_type_id);
                if (isset($carry_count[0])) {
                    $total = $carry_count[0]->remaing_leave_count;
                    $yr_check_sick = date('Y', strtotime($carry_count[0]->create_date));
                } else {
                    $total = $emp_leave_count;
                    $yr_check_sick = date('Y', strtotime($check_date));
                }

                $total_paid_count_exits = $this->Timesheet_model->select_leave_paid_list($employee_id, $yr_check_sick);

                $paid_flag = $halfpaid_flag = $unpaid_flag = 0;
                if (strtotime($from_date) == strtotime($to_date)) {
                    $leave_duration_count = 1;
                } else {
                    $leave_duration_count = $interval->format('%a') + 1;
                }
                if (isset($total_paid_count_exits[0]->id)) {
                    $total_sick_leave_count = $total_paid_count_exits[0]->total_paid_counts + $total_paid_count_exits[0]->total_half_paid_counts + $total_paid_count_exits[0]->total_unpaid_counts;

                    if ($total_sick_leave_count >= $emp_leave_count) {
                        $sick_leave_exceed_limit_flag = 1;
                    }

                    if ($total_paid_count_exits[0]->total_paid_counts >= $emp_info[0]->paid_sick_leave_count) {

                        $leave_paid_start = '';
                        $leave_paid_end = '';
                        $paid_flag = 1;

                        if ($total_paid_count_exits[0]->total_half_paid_counts < $emp_info[0]->half_paid_sick_leave_count) {

                            $leave_half_pay_start = $from_date;
                            $halfpaid_flag = 1;
                            $remaining_half_counts = $emp_info[0]->half_paid_sick_leave_count - $total_paid_count_exits[0]->total_half_paid_counts;
                            if ($leave_duration_count <= $remaining_half_counts) {
                                $leave_half_pay_end = $to_date;
                            } else {
                                if ($total_paid_count_exits[0]->total_half_paid_counts < $emp_info[0]->half_paid_sick_leave_count) {
                                    $neg_count = $emp_info[0]->half_paid_sick_leave_count - $total_paid_count_exits[0]->total_half_paid_counts;
                                } else {
                                    $neg_count = 0;
                                }
                                if ($neg_count > 1) {
                                    $neg_count = $neg_count - 1;
                                }
                                $leave_half_pay_end = date('Y-m-d', strtotime($leave_half_pay_start . ' +' . $neg_count . ' days'));
                                $upaid_leaves_start = date('Y-m-d', strtotime($leave_half_pay_end . ' + 1 days'));
                                $upaid_leaves_end = $to_date;
                            }
                        } else {
                            $leave_half_pay_start = '';
                            $leave_half_pay_end = '';
                            $upaid_leaves_start = date('Y-m-d', strtotime($from_date));
                            if ($total_paid_count_exits[0]->total_unpaid_counts < $emp_info[0]->unpaid_sick_leave_count) {
                                $neg_count_unpaid = $emp_info[0]->unpaid_sick_leave_count - $total_paid_count_exits[0]->total_unpaid_counts;
                            } else {
                                $neg_count_unpaid = 0;
                            }
                            if ($leave_duration_count < $neg_count_unpaid && $total_paid_count_exits[0]->total_unpaid_counts < $emp_info[0]->unpaid_sick_leave_count) {
                                $leave_duration_count = $leave_duration_count - 1;
                                $upaid_leaves_end = date('Y-m-d', strtotime($upaid_leaves_start . ' +' . $leave_duration_count . ' days'));
                            } else {
                                $flag_unpaid_exta = $leave_duration_count - $neg_count_unpaid;
                                $neg_count_unpaid = $neg_count_unpaid - 1;
                                $upaid_leaves_end = date('Y-m-d', strtotime($upaid_leaves_start . ' +' . $neg_count_unpaid . ' days'));
                            }

                            //$upaid_leaves_end = $to_date;
                        }
                    } else {
                        $leave_paid_start = $from_date;
                        $leave_paid_end = $to_date;
                    }
                } else {

                    if ($leave_duration_count > $emp_info[0]->paid_sick_leave_count) {
                        $emp_alloted_leave = $emp_info[0]->paid_sick_leave_count + $emp_info[0]->half_paid_sick_leave_count + $emp_info[0]->unpaid_sick_leave_count;

                        if ($emp_info[0]->paid_sick_leave_count > 0) {
                            $leave_paid_start = $from_date;
                            $adding_val_paid = $emp_info[0]->paid_sick_leave_count - 1;

                            $leave_paid_end = date('Y-m-d', strtotime($from_date . ' +' . $adding_val_paid . ' days'));
                            if ($leave_duration_count > $emp_info[0]->paid_sick_leave_count && $emp_info[0]->half_paid_sick_leave_count == 0 && $emp_info[0]->half_paid_sick_leave_count == 0) {
                                $flag_unpaid_exta = $leave_duration_count - $emp_info[0]->paid_sick_leave_count;
                            } else {
                                $leave_half_pay_start = date('Y-m-d', strtotime($leave_paid_end . ' + 1 days'));
                                $leave_duration_count = $leave_duration_count - $adding_val_paid;
                            }
                        } else {
                            if ($emp_info[0]->half_paid_sick_leave_count > 0) {
                                $leave_half_pay_start = $from_date;
                            } else if ($emp_info[0]->unpaid_sick_leave_count > 0) {
                                $upaid_leaves_start = $from_date;
                            }
                        }
                        if ($leave_duration_count < $emp_alloted_leave) {
                            if ($leave_duration_count <= $emp_info[0]->half_paid_sick_leave_count) {
                                $leave_half_pay_end = $to_date;
                            } else {
                                $total_leave_list_count = $emp_info[0]->paid_sick_leave_count + $emp_info[0]->half_paid_sick_leave_count;
                                $remaing_unpaid_count = $leave_duration_count - $total_leave_list_count;
                                if ($remaing_unpaid_count > $emp_info[0]->unpaid_sick_leave_count) {
                                    $flag_unpaid_exta = $remaing_unpaid_count - $emp_info[0]->unpaid_sick_leave_count;
                                    $adding_val_halfpaid = $emp_info[0]->unpaid_sick_leave_count - 1;
                                    $leave_half_pay_end = date('Y-m-d', strtotime($leave_half_pay_start . ' + ' . $adding_val_halfpaid . ' days'));
                                    $upaid_leaves_start = date('Y-m-d', strtotime($leave_half_pay_end . ' + 1 days'));
                                    $upaid_leaves_end = date('Y-m-d', strtotime($to_date . ' - ' . $flag_unpaid_exta . ' days'));
                                } else {

                                    $adding_val_halfpaid = $emp_info[0]->half_paid_sick_leave_count - 1;
                                    $leave_half_pay_end = date('Y-m-d', strtotime($leave_half_pay_start . ' + ' . $adding_val_halfpaid . ' days'));
                                    $upaid_leaves_start = date('Y-m-d', strtotime($leave_half_pay_end . ' + 1 days'));
                                    $upaid_leaves_end = $to_date;
                                }
                            }
                        } else {
                            if ($emp_info[0]->half_paid_sick_leave_count > 0) {
                                if ($emp_alloted_leave <= $emp_info[0]->half_paid_sick_leave_count) {
                                    $leave_half_pay_end = $to_date;
                                } else {
                                    $adding_val_halfpaid = $emp_alloted_leave - 1;
                                    $leave_half_pay_end = date('Y-m-d', strtotime($leave_half_pay_start . ' + ' . $adding_val_halfpaid . ' days'));
                                    $flag_unpaid_exta = $leave_duration_count - $emp_alloted_leave;
                                }
                            } else if ($emp_info[0]->unpaid_sick_leave_count > 0) {
                                if ($emp_alloted_leave <= $emp_info[0]->unpaid_sick_leave_count) {
                                    $upaid_leaves_end = $to_date;
                                } else {
                                    $adding_val_halfpaid = $emp_alloted_leave - 1;
                                    $upaid_leaves_end = date('Y-m-d', strtotime($upaid_leaves_start . ' + ' . $adding_val_halfpaid . ' days'));
                                    $flag_unpaid_exta = $leave_duration_count - $emp_alloted_leave;
                                }
                            }
                        }
                    } else {
                        $leave_paid_start = $from_date;
                        $leave_paid_end = $to_date;
                    }
                }
            }
        }
        $Return['sick_leave_exceed_limit_flag'] = $sick_leave_exceed_limit_flag;
        $Return['leave_paid_start'] = $leave_paid_start;
        $Return['leave_paid_end'] = $leave_paid_end;
        $Return['leave_half_pay_start'] = $leave_half_pay_start;
        $Return['leave_half_pay_end'] = $leave_half_pay_end;
        $Return['upaid_leaves_start'] = $upaid_leaves_start;
        $Return['upaid_leaves_end'] =  $upaid_leaves_end;
        header('Content-Type: application/json');
        echo json_encode($Return);
    }

    function update_leave_status_api()
    {

        $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
        if ($this->input->post('user_id') == '') {
            $Return['error'] = "User id is required";
        } else if ($this->input->post('leave_id') == '') {
            $Return['error'] = "Leave id is required";
        } else if ($this->input->post('status') == '') {
            $Return['error'] = "Status is required";
        } else if ($this->input->post('remarks') == '') {
            $Return['error'] = "Remarks is required";
        }
        if ($Return['error'] != '') {
            $Return['code'] = "201";
            $Return['msg'] = 'Data Validation Error';
            header('Content-Type: application/json');
            echo json_encode($Return);
            exit();
        }

        // if ($this->input->post('update_type') == 'leave') {
        $user_id = $this->input->post('user_id');
        if ($this->input->post('probation_check')) {
            $probation_check = $this->input->post('probation_check');
        } else {
            $probation_check = 'null';
        }
        $unpaid_leave_id = 0;
        $check_flag = 0;
        $no_of_days_annual_remain = 0;
        $sick_leave_noti = 'N';
        $id = $this->input->post('leave_id');
        $leave_claim_row = $this->db->get_where('xin_leave_applications', array('leave_id' => $id))->row();
        // $session = $this->session->userdata('username');
        $user_info = $this->Xin_model->read_user_info($user_id);
        $role_resources_ids = $this->Xin_model->user_role_resource_api($user_id);
        $first_approval = $second_approval = $final_approval = 0;
        $approved_by_first = $approved_by_second = $approved_by_final = '';
        $status = $this->input->post('status');
        $leave_probation_check = $this->input->post('leave_probation_check');
        $sick_leave_exceed_limit_flag = $this->input->post('sick_leave_exceed_limit_flag');
        $sick_leave_type = $this->input->post('sick_leave_type');
        $start_date_paid = $this->input->post('start_date_paid');
        $start_date_half = $this->input->post('start_date_half');
        $end_date_paid = $this->input->post('end_date_paid');
        $end_date_half = $this->input->post('end_date_half');
        $start_date_unpaid = $this->input->post('start_date_unpaid');
        $end_date_unpaid = $this->input->post('end_date_unpaid');
        $reason = $this->input->post('reason');


        if ($status == 2) {
            $first_approval = $second_approval = $final_approval = 1;
            $old_first_val = $leave_claim_row->first_approval;
            if ($old_first_val) {
                $approved_by_first = $leave_claim_row->approved_by_first;
            } else {
                $approved_by_first = $user_id;
            }
            $old_second_val = $leave_claim_row->second_approval;
            if ($old_second_val) {
                $approved_by_second = $leave_claim_row->approved_by_second;
            } else {
                $approved_by_second = $user_id;
            }
            $old_final_val = $leave_claim_row->final_approval;
            if ($old_final_val) {
                $approved_by_final = $leave_claim_row->approved_by_final;
            } else {
                $approved_by_final = $user_id;
            }
        } else if ($status == 3) {
            $final_approval = 2;
            $approved_by_final = $user_id;
        }

        $timesheet = $this->Timesheet_model->read_leave_information($id);
        if ($timesheet[0]->leave_type_id == 4) {
            if (!empty($leave_probation_check) == 0 || ($leave_probation_check == 1) && ($probation_check == 'from_leave')) {
                if ($status == '2' && $sick_leave_exceed_limit_flag == 0) {
                    /* validation part */
                    if (empty($sick_leave_type)) {
                        $Return['error'] = 'Sick leave type field is required';
                    }
                    if ($sick_leave_type) {
                        $sick_leave_type_array = $sick_leave_type;
                        foreach ($sick_leave_type_array as $type_array) {
                            if ($type_array == 1) {
                                if (empty($start_date_paid)) {
                                    $Return['error'] = 'Sick leave paid start date is required';
                                } else if (empty($end_date_paid)) {
                                    $Return['error'] = 'Sick leave paid end date is required';
                                } else if (strtotime($start_date_paid) > strtotime($end_date_paid)) {
                                    $Return['error'] = 'Paid ' . $this->lang->line('xin_error_start_end_date');
                                }
                            }
                            if ($type_array == 2) {
                                if (empty($start_date_half)) {
                                    $Return['error'] = 'Sick leave half paid start date is required';
                                } else if (empty($end_date_half)) {
                                    $Return['error'] = 'Sick leave  half paid end date is required';
                                } else if (strtotime($start_date_half) > strtotime($end_date_half)) {
                                    $Return['error'] = 'Half Paid ' . $this->lang->line('xin_error_start_end_date');
                                }
                            }
                            if ($type_array == 3) {
                                if (empty($start_date_unpaid)) {
                                    $Return['error'] = 'Sick leave unpaid start date is required';
                                } else if (empty($end_date_unpaid)) {
                                    $Return['error'] = 'Sick leave unpaid end date is required';
                                } else if (strtotime($start_date_unpaid) > strtotime($end_date_unpaid)) {
                                    $Return['error'] = 'Unpaid ' . $this->lang->line('xin_error_start_end_date');
                                }
                            }
                        }
                    }

                    if ($Return['error'] != '') {
                        $Return['code'] = '201';
                        $Return['msg'] = $Return['error'];
                        header('Content-Type: application/json');
                        echo json_encode($Return);
                        exit();
                    }
                    /* end validation part */
                    $paid_start_date = $paid_end_date = $halfpaid_start_date = $halfpaid_end_date = $unpaid_start_date = $unpaid_end_date = '';
                    if ($sick_leave_type) {
                        $sick_leave_type_array = $sick_leave_type;
                        foreach ($sick_leave_type_array as $type_array) {
                            if ($type_array == 1) {
                                $paid_start_date = $start_date_paid;
                                $paid_end_date = $end_date_paid;
                            }
                            if ($type_array == 2) {
                                $halfpaid_start_date = $start_date_half;
                                $halfpaid_end_date = $end_date_half;
                            }
                            if ($type_array == 3) {
                                $unpaid_start_date = $start_date_unpaid;
                                $unpaid_end_date = $end_date_unpaid;
                            }
                        }
                    }
                    $total_paid_count = 0;
                    if ($paid_start_date && $paid_end_date) {
                        $datetime1 = new DateTime($paid_start_date);
                        $datetime2 = new DateTime($paid_end_date);
                        $interval = $datetime1->diff($datetime2);
                        if (strtotime($paid_start_date) == strtotime($paid_end_date)) {
                            $total_paid_count = 1;
                        } else {
                            $total_paid_count = $interval->format('%a') + 1;
                        }
                    }
                    $total_halfpaid_count = 0;
                    if ($halfpaid_start_date && $halfpaid_end_date) {
                        $datetime1 = new DateTime($halfpaid_start_date);
                        $datetime2 = new DateTime($halfpaid_end_date);
                        $interval = $datetime1->diff($datetime2);
                        if (strtotime($halfpaid_start_date) == strtotime($halfpaid_end_date)) {
                            $total_halfpaid_count = 1;
                        } else {
                            $total_halfpaid_count = $interval->format('%a') + 1;
                        }
                    }
                    $total_unpaid_count = 0;
                    if ($unpaid_start_date && $unpaid_end_date) {
                        $datetime1 = new DateTime($unpaid_start_date);
                        $datetime2 = new DateTime($unpaid_end_date);
                        $interval = $datetime1->diff($datetime2);
                        if (strtotime($unpaid_start_date) == strtotime($unpaid_end_date)) {
                            $total_unpaid_count = 1;
                        } else {
                            $total_unpaid_count = $interval->format('%a') + 1;
                        }
                    }
                    $cond = array('leave_id' => $id, 'emp_id' => $timesheet[0]->employee_id);
                    $check_sick_mangement_exists = $this->Timesheet_model->common_select('xin_emp_sickleave_manage', $cond);
                    if ($check_sick_mangement_exists) {
                        $sick_leave_details_array = array(
                            'emp_id' => $timesheet[0]->employee_id,
                            'leave_id' => $id,
                            'leave_type_id' => 4,
                            'paid_start_date' => $paid_start_date,
                            'paid_end_date' => $paid_end_date,
                            'halfpaid_start_date' => $halfpaid_start_date,
                            'halfpaid_end_date' => $halfpaid_end_date,
                            'unpaid_start_date' => $unpaid_start_date,
                            'unpaid_end_date' => $unpaid_end_date,
                            'total_paid_count' => $total_paid_count,
                            'total_half_paid_count' => $total_halfpaid_count,
                            'total_unpaid_count' => $total_unpaid_count,
                            'status' => 'Y',
                            'date' => date('Y-m-d')
                        );
                        $result_sick = $this->Timesheet_model->update_common('xin_emp_sickleave_manage', $sick_leave_details_array, $check_sick_mangement_exists[0]->id);
                        $leaves_id = $timesheet[0]->leave_type_id;
                        $employees_id = $timesheet[0]->employee_id;
                        $type = $this->Timesheet_model->read_leave_type_information($leaves_id);
                        $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
                        $carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employees_id, $leaves_id);
                        $total = $carry_count[0]->remaing_leave_count;
                        $days = $timesheet[0]->days;
                        if ($timesheet[0]->is_half_day == 1) {
                            $days = 0.5;
                        }
                        if ($leaves_id == 7) {
                            $leave_remaining_total = $total - $days;
                            if ($leave_remaining_total < 0) {
                                $leave_remaining_total = 0;
                            } else {
                                $leave_remaining_total = $leave_remaining_total;
                            }
                        } else {
                            $leave_remaining_total = $total + $days;
                        }
                        $date_arr = explode("-", $timesheet[0]->from_date);
                        $year_check = $date_arr[0];
                        $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                        if ($result->num_rows() == 0) {
                            $data_insert = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => $leave_remaining_total,
                                'create_date' => date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_insert($data_insert);
                        } else {
                            $carry_leave = $result->result(); //print_r($carry_leave);exit;
                            $data_update = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => $leave_remaining_total,
                                //'create_date'=> date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                        }
                    } else {
                        $sick_leave_details_array = array(
                            'emp_id' => $timesheet[0]->employee_id,
                            'leave_id' => $id,
                            'leave_type_id' => 4,
                            'paid_start_date' => $paid_start_date,
                            'paid_end_date' => $paid_end_date,
                            'halfpaid_start_date' => $halfpaid_start_date,
                            'halfpaid_end_date' => $halfpaid_end_date,
                            'unpaid_start_date' => $unpaid_start_date,
                            'unpaid_end_date' => $unpaid_end_date,
                            'total_paid_count' => $total_paid_count,
                            'total_half_paid_count' => $total_halfpaid_count,
                            'total_unpaid_count' => $total_unpaid_count,
                            'status' => 'Y',
                            'date' => date('Y-m-d')
                        );
                        $result_sick = $this->Timesheet_model->insert_common('xin_emp_sickleave_manage', $sick_leave_details_array);
                    }
                    if ($result_sick) {
                        $no_of_days = $total_paid_count + $total_halfpaid_count + $total_unpaid_count;
                        $data = array(
                            'remarks' => $this->input->post('remarks'),
                            'days' => $no_of_days,
                            'status' => $status,
                            'first_approval' => $first_approval,
                            'second_approval' => $second_approval,
                            'final_approval' => $final_approval,
                            'approved_by_first' => $approved_by_first,
                            'approved_by_second' => $approved_by_second,
                            'approved_by_final' => $approved_by_final,
                            'updated_date' => date('Y-m-d')
                        );
                        $result = $this->Timesheet_model->update_leave_record($data, $id);
                    } else {
                        $Return['error'] = $this->lang->line('xin_error_msg');
                    }
                } else {
                    $cond = array('leave_id' => $id, 'emp_id' => $timesheet[0]->employee_id);
                    $check_sick_mangement_exists = $this->Timesheet_model->common_select('xin_emp_sickleave_manage', $cond);
                    if ($check_sick_mangement_exists) {
                        $sick_leave_details_array = array(
                            'status' => 'N',
                            'date' => date('Y-m-d')
                        );
                        $result_sick = $this->Timesheet_model->update_common('xin_emp_sickleave_manage', $sick_leave_details_array, $check_sick_mangement_exists[0]->id);
                    }
                }
            }
        }
        if ($status == '2' && $timesheet[0]->cleared_status != 1) {

            /* Leave unpaid make */
            $no_of_days = $timesheet[0]->days;
            $aval_leaves = 0;
            $check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, $timesheet[0]->leave_type_id);
            if (!empty($check_annual_leave_aval)) {
                $aval_leaves = $check_annual_leave_aval[0]->leave_count;
            }
            $date_arr = explode("-", $timesheet[0]->from_date);
            $year_check = $date_arr[0];
            $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
            $carry_leave_exced = $result_carry->result();
            if ($result_carry->num_rows() > 0) {
                if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
                    if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
                        if ($carry_leave_exced[0]->leave_type_id == 4) {
                            $sick_leave_noti = 'Y';
                        }
                        $no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
                        $no_of_days = $carry_leave_exced[0]->remaing_leave_count;
                        $aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
                        $inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
                        $next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
                    } else {
                        $next_form_date_ann = $timesheet[0]->to_date;
                    }
                } else {
                    if ($no_of_days > $aval_leaves) {
                        $sick_leave_noti = 'Y';
                        $no_of_days_annual_remain = $no_of_days - $aval_leaves;
                        $no_of_days = $aval_leaves;
                        $inc_days = $aval_leaves - 1;
                        $next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
                    } else {
                        $next_form_date_ann = $timesheet[0]->to_date;
                    }
                }
            } else {
                if ($no_of_days > $aval_leaves) {
                    $no_of_days_annual_remain = $no_of_days - $aval_leaves;
                    $no_of_days = $aval_leaves;
                    $inc_days = $aval_leaves - 1;
                    $next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
                } else {
                    $next_form_date_ann = $timesheet[0]->to_date;
                }
            }
            /* end leave unpaid */
            /* in probation time */
            $haj = 0;
            if ($timesheet[0]->leave_type_id == 8) {
                $user_leave = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                $date11 = strtotime($user_leave[0]->date_of_joining);
                $date21 = strtotime(date('Y-m-d'));
                $diff1 = abs($date21 - $date11);
                $years = floor($diff1 / (365 * 60 * 60 * 24));
                if ($years <= 5) {
                    $haj = 1;
                }
            }

            if ((!empty($probation_check) && $probation_check == 'lop') || $haj == 1) {
                $timesheet_exceeds = $this->Timesheet_model->read_leave_information($id);
                $check_flag = 3;
                $no_of_days_annual_remain = 0;
                $data = array(
                    'employee_id' => $timesheet_exceeds[0]->employee_id,
                    'company_id' => $timesheet_exceeds[0]->company_id,
                    'leave_type_id' => 7,
                    'from_date' => $timesheet_exceeds[0]->from_date,
                    'to_date' => $timesheet_exceeds[0]->to_date,
                    'applied_on' => $timesheet_exceeds[0]->applied_on,
                    'remarks' => $this->input->post('remarks'),
                    'status' => '2',
                    'is_notify' => '1',
                    'created_at' => date('Y-m-d h:i:s'),
                    'days' => $timesheet_exceeds[0]->days,
                    'cleared_status' => 1,
                    'probation_check' => $probation_check
                );
                $result = $this->Timesheet_model->add_leave_record_new($data);
                $unpaid_leave_id = $result;
                /* Leave carryforward management */
                $timesheet = $this->Timesheet_model->read_leave_information($result);
                //carryforward
                $date_arr = explode("-", $timesheet[0]->from_date);
                $year_check = $date_arr[0];
                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                //end				
                if (($status == '2') && (isset($timesheet[0]->status) !== '2')) {
                    $hlfcounts = 0;
                    $count_ls = 0;
                    $leaves_id = $timesheet[0]->leave_type_id;
                    $employees_id = $timesheet[0]->employee_id;
                    $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                    $count = $xin_leave_type[0]->leave_count;
                    $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);

                    $leave_half_day_opt = $timesheet[0]->is_half_day;
                    $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                    foreach ($leave_halfday_cals as $lhalfday) :
                        $hlfcounts += 0.5;
                    endforeach;
                    $count_ls = count_leaves_info($leaves_id, $employees_id);
                    $count_ls = $count_ls - $hlfcounts;
                    $va = $count_leave_type[0]->days_per_year;
                    $type = $this->Timesheet_model->read_leave_type_information($leaves_id);
                    $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
                    //$total =$type[0]->days_per_year;
                    if ($emp_leaves_data) {
                        $total = $emp_leaves_data[0]->leave_count;
                    } else {
                        $total = 0;
                    }
                    $carry_leave = $result_carry->result();
                    if ($carry_leave) {
                        $total = $carry_leave[0]->remaing_leave_count;
                    } else {
                        $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                        if (!empty($emp_leave_count)) {
                            $total = $emp_leave_count[0]->leave_count;
                        } else {
                            $total = 0;
                        }
                    }

                    $taked_leaves = $timesheet[0]->days;

                    if ($leaves_id == 7) {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        }
                        /*if($leave_half_day_opt == 1){
                                $leave_remaining_total = $leave_remaining_total - 0.5;
                            }*/
                        $leave_remaining_total = abs($leave_remaining_total);
                    } else {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        }

                        $leave_remaining_total = $leave_remaining_total;
                    }
                    $date_arr = explode("-", $timesheet[0]->from_date);
                    $year_check = $date_arr[0];
                    $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                    if ($result->num_rows() == 0) {
                        $data_insert = array(
                            'employee_id' => $timesheet[0]->employee_id,
                            'leave_type_id' => $timesheet[0]->leave_type_id,
                            'remaing_leave_count' => abs($leave_remaining_total),
                            'create_date' => date('Y-m-d')
                        );
                        $data_result = $this->Timesheet_model->carry_insert($data_insert);
                    } else {
                        $carry_leave = $result->result();
                        $data_update = array(
                            'employee_id' => $timesheet[0]->employee_id,
                            'leave_type_id' => $timesheet[0]->leave_type_id,
                            'remaing_leave_count' => abs($leave_remaining_total),
                            //'create_date'=> date('Y-m-d')
                        );
                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                    }
                } else if ($status != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {

                    $carry_leave = $result_carry->result();
                    $hlfcounts = 0;
                    $count_ls = 0;
                    $leaves_id = $timesheet[0]->leave_type_id;
                    $employees_id = $timesheet[0]->employee_id;
                    $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                    $count = $xin_leave_type[0]->leave_count;
                    $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                    $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                    foreach ($leave_halfday_cals as $lhalfday) :
                        $hlfcounts += 0.5;
                    endforeach;
                    $count_ls = count_leaves_info($leaves_id, $employees_id);
                    $count_ls = $count_ls - $hlfcounts;

                    $leave_half_day_opt = $timesheet[0]->is_half_day;
                    $leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
                    $carry_leave = $result_carry->result();
                    if ($carry_leave) {
                        $total = $carry_leave[0]->remaing_leave_count;
                    } else {
                        $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                        $total = $emp_leave_count[0]->leave_count;
                    }

                    $taked_leaves = $timesheet[0]->days;

                    if ($leaves_id == 7) {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        }
                        $leave_remaining_total = abs($leave_remaining_total);
                    } else {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        }

                        $leave_remaining_total = $leave_remaining_total;
                    }
                    $data_update = array(
                        'employee_id' => $timesheet[0]->employee_id,
                        'leave_type_id' => $timesheet[0]->leave_type_id,
                        'remaing_leave_count' => abs($leave_remaining_total),
                        //'create_date'=> date('Y-m-d')
                    );
                    $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                }
                $result_dlt_exits = $this->Timesheet_model->delete_leave_record($timesheet_exceeds[0]->leave_id);
            } else {

                /*end probation time calc */
                //check leave exceeds
                $timesheet_exceeds = $this->Timesheet_model->read_leave_information($id);
                $date_arr = explode("-", $timesheet_exceeds[0]->from_date);
                $year_check = $date_arr[0];
                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet_exceeds[0]->employee_id, $timesheet_exceeds[0]->leave_type_id, $year_check);
                $carry_leave_exced = $result_carry->result();
                if ($result_carry->num_rows() > 0) {
                    if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
                        $check_flag = 1;
                        $no_of_days_annual_remain = 0;
                        $data = array(
                            'employee_id' => $timesheet_exceeds[0]->employee_id,
                            'company_id' => $timesheet_exceeds[0]->company_id,
                            'leave_type_id' => 7,
                            'from_date' => $timesheet_exceeds[0]->from_date,
                            'to_date' => $timesheet_exceeds[0]->to_date,
                            'applied_on' => $timesheet_exceeds[0]->applied_on,
                            'remarks' => $this->input->post('remarks'),
                            'status' => '2',
                            'is_notify' => '1',
                            'created_at' => date('Y-m-d h:i:s'),
                            'days' => $timesheet_exceeds[0]->days,
                            'cleared_status' => 1,
                            'probation_check' => $probation_check
                        );
                        $result = $this->Timesheet_model->add_leave_record_new($data);
                        $unpaid_leave_id = $result;
                        /* Leave carryforward management */
                        $timesheet = $this->Timesheet_model->read_leave_information($result);
                        $date_arr = explode("-", $timesheet[0]->from_date);
                        $year_check = $date_arr[0];
                        $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                        //end				
                        if (($status == '2') && (isset($timesheet[0]->status) !== '2')) {
                            $hlfcounts = 0;
                            $count_ls = 0;
                            $leaves_id = $timesheet[0]->leave_type_id;
                            $employees_id = $timesheet[0]->employee_id;
                            $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                            $count = $xin_leave_type[0]->leave_count;
                            $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);

                            $leave_half_day_opt = $timesheet[0]->is_half_day;
                            $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                            foreach ($leave_halfday_cals as $lhalfday) :
                                $hlfcounts += 0.5;
                            endforeach;
                            $count_ls = count_leaves_info($leaves_id, $employees_id);
                            $count_ls = $count_ls - $hlfcounts;
                            $va = $count_leave_type[0]->days_per_year;
                            $type = $this->Timesheet_model->read_leave_type_information($leaves_id);
                            $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
                            //$total =$type[0]->days_per_year;
                            if ($emp_leaves_data) {
                                $total = $emp_leaves_data[0]->leave_count;
                            } else {
                                $total = 0;
                            }
                            $carry_leave = $result_carry->result();
                            if ($carry_leave) {
                                $total = $carry_leave[0]->remaing_leave_count;
                            } else {
                                $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                $total = $emp_leave_count[0]->leave_count;
                            }

                            $taked_leaves = $timesheet[0]->days;

                            if ($leaves_id == 7) {
                                if ($status != 2) {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total - 0.5;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                } else {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total + 0.5;
                                    } else {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    }
                                }
                                $leave_remaining_total = abs($leave_remaining_total);
                            } else {
                                if ($status != 2) {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total + 0.5;
                                    } else {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    }
                                } else {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total - 0.5;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                }

                                $leave_remaining_total = $leave_remaining_total;
                            }
                            $date_arr = explode("-", $timesheet[0]->from_date);
                            $year_check = $date_arr[0];
                            $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                            if ($result->num_rows() == 0) {
                                $data_insert = array(
                                    'employee_id' => $timesheet[0]->employee_id,
                                    'leave_type_id' => $timesheet[0]->leave_type_id,
                                    'remaing_leave_count' => abs($leave_remaining_total),
                                    'create_date' => date('Y-m-d')
                                );
                                $data_result = $this->Timesheet_model->carry_insert($data_insert);
                            } else {
                                $carry_leave = $result->result();
                                $data_update = array(
                                    'employee_id' => $timesheet[0]->employee_id,
                                    'leave_type_id' => $timesheet[0]->leave_type_id,
                                    'remaing_leave_count' => abs($leave_remaining_total),
                                    //'create_date'=> date('Y-m-d')
                                );
                                $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                            }
                        } else if ($status != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {

                            $carry_leave = $result_carry->result();
                            $hlfcounts = 0;
                            $count_ls = 0;
                            $leaves_id = $timesheet[0]->leave_type_id;
                            $employees_id = $timesheet[0]->employee_id;
                            $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                            $count = $xin_leave_type[0]->leave_count;
                            $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                            $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                            foreach ($leave_halfday_cals as $lhalfday) :
                                $hlfcounts += 0.5;
                            endforeach;
                            $count_ls = count_leaves_info($leaves_id, $employees_id);
                            $count_ls = $count_ls - $hlfcounts;

                            $leave_half_day_opt = $timesheet[0]->is_half_day;
                            $leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
                            $carry_leave = $result_carry->result();
                            if ($carry_leave) {
                                $total = $carry_leave[0]->remaing_leave_count;
                            } else {
                                $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                $total = $emp_leave_count[0]->leave_count;
                            }

                            $taked_leaves = $timesheet[0]->days;

                            if ($leaves_id == 7) {
                                if ($status != 2) {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total - 0.5;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                } else {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total + 0.5;
                                    } else {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    }
                                }
                                $leave_remaining_total = abs($leave_remaining_total);
                            } else {
                                if ($status != 2) {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total + 0.5;
                                    } else {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    }
                                } else {
                                    if ($leave_half_day_opt == 1) {
                                        $leave_remaining_total = $total - 0.5;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                }

                                $leave_remaining_total = $leave_remaining_total;
                            }
                            $data_update = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => abs($leave_remaining_total),
                                //'create_date'=> date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                        }
                        $result_dlt_exits = $this->Timesheet_model->delete_leave_record($timesheet_exceeds[0]->leave_id);
                    } else {
                        $data = array(
                            'status' => $status,
                            'remarks' => $this->input->post('remarks'),
                            'allotted_leave' => $aval_leaves,
                            'to_date' => $next_form_date_ann,
                            'days' => $no_of_days,
                            'cleared_status' => 1,
                            'sick_leave_noti' => $sick_leave_noti,
                            'first_approval' => $first_approval,
                            'second_approval' => $second_approval,
                            'final_approval' => $final_approval,
                            'approved_by_first' => $approved_by_first,
                            'approved_by_second' => $approved_by_second,
                            'approved_by_final' => $approved_by_final,
                            'updated_date' => date('Y-m-d')

                        );
                        $result = $this->Timesheet_model->update_leave_record($data, $id);
                    }
                } else {
                    $data = array(
                        'status' => $status,
                        'remarks' => $this->input->post('remarks'),
                        'allotted_leave' => $aval_leaves,
                        'to_date' => $next_form_date_ann,
                        'days' => $no_of_days,
                        'cleared_status' => 1,
                        'sick_leave_noti' => $sick_leave_noti,
                        'first_approval' => $first_approval,
                        'second_approval' => $second_approval,
                        'final_approval' => $final_approval,
                        'approved_by_first' => $approved_by_first,
                        'approved_by_second' => $approved_by_second,
                        'approved_by_final' => $approved_by_final,
                        'updated_date' => date('Y-m-d')
                    );

                    $result = $this->Timesheet_model->update_leave_record($data, $id);
                }
            }
        } else {
            if ($status != '2' && $timesheet[0]->status != 2) {
                $check_flag = 2;
            }
            $data = array(
                'status' => $status,
                'remarks' => $this->input->post('remarks'),
                'sick_leave_noti' => 'N',
                'first_approval' => $first_approval,
                'second_approval' => $second_approval,
                'final_approval' => $final_approval,
                'approved_by_first' => $approved_by_first,
                'approved_by_second' => $approved_by_second,
                'approved_by_final' => $approved_by_final,
                'updated_date' => date('Y-m-d')
            );
            $result = $this->Timesheet_model->update_leave_record($data, $id);
        }
        //end check leave exceeds
        if ($result == TRUE) {
            if ($no_of_days_annual_remain > 0) {
                $next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
                $checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
                if (!empty($checl_already_exists_annual)) {
                    $data = array(
                        'from_date' => $next_form_date,
                        'to_date' => $timesheet[0]->to_date,
                        'remarks' => $this->input->post('remarks'),
                        'status' => '2',
                        'is_notify' => '1',
                        'days' => $no_of_days_annual_remain,
                        'leave_unpaid_auto' => $id,
                        'cleared_status' => 1,
                        'probation_check' => $probation_check,
                        'sick_leave_noti' => $sick_leave_noti,
                        'first_approval' => $first_approval,
                        'second_approval' => $second_approval,
                        'final_approval' => $final_approval,
                        'approved_by_first' => $approved_by_first,
                        'approved_by_second' => $approved_by_second,
                        'approved_by_final' => $approved_by_final,
                        'updated_date' => date('Y-m-d')
                    );
                    $result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
                    /* Leave carryforward management */
                    $timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
                    $date_arr = explode("-", $timesheet[0]->from_date);
                    $year_check = $date_arr[0];
                    $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                    //end				
                    if (($status == '2') && (isset($timesheet[0]->status) !== '2')) {
                        $hlfcounts = 0;
                        $count_ls = 0;
                        $leaves_id = $timesheet[0]->leave_type_id;
                        $employees_id = $timesheet[0]->employee_id;
                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                        $count = $xin_leave_type[0]->leave_count;
                        $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);


                        $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                        foreach ($leave_halfday_cals as $lhalfday) :
                            $hlfcounts += 0.5;
                        endforeach;
                        $count_ls = count_leaves_info($leaves_id, $employees_id);
                        $count_ls = $count_ls - $hlfcounts;
                        $va = $count_leave_type[0]->days_per_year;
                        $type = $this->Timesheet_model->read_leave_type_information($leaves_id);
                        $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
                        //$total =$type[0]->days_per_year;
                        $total = $emp_leaves_data[0]->leave_count;
                        $leave_remaining_total = $total - $count_ls;
                        $c = $count - $va;
                        $re = $total - $count_ls;
                        if ($leave_remaining_total == 0) {
                            $lr = 0;
                            $hr = 0;
                        } elseif ($leave_remaining_total < $count_ls) {
                            $lr = 0;
                            $hr = $c;
                        } else {
                            $lr = $leave_remaining_total;
                            $hr = 0;
                        }
                        $date_arr = explode("-", $timesheet[0]->from_date);
                        $year_check = $date_arr[0];
                        $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                        if ($result->num_rows() == 0) {
                            $data_insert = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => abs($leave_remaining_total),
                                'create_date' => date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_insert($data_insert);
                        } else {
                            $carry_leave = $result->result(); //print_r($carry_leave);exit;
                            $data_update = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => abs($leave_remaining_total),
                                //'create_date'=> date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                        }
                    } else if ($status != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                        //pending or rejected
                        $carry_leave = $result_carry->result();
                        $hlfcounts = 0;
                        $count_ls = 0;
                        $leaves_id = $timesheet[0]->leave_type_id;
                        $employees_id = $timesheet[0]->employee_id;
                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                        $count = $xin_leave_type[0]->leave_count;
                        $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                        $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                        foreach ($leave_halfday_cals as $lhalfday) :
                            $hlfcounts += 0.5;
                        endforeach;
                        $count_ls = count_leaves_info($leaves_id, $employees_id);
                        $count_ls = $count_ls - $hlfcounts;
                        $leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
                        $data_update = array(
                            'employee_id' => $timesheet[0]->employee_id,
                            'leave_type_id' => $timesheet[0]->leave_type_id,
                            'remaing_leave_count' => abs($leave_remaining_total),
                            //'create_date'=> date('Y-m-d')
                        );
                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                    }
                    /* End Leave carryforward management */
                } else {

                    $data = array(
                        'employee_id' => $timesheet[0]->employee_id,
                        'company_id' => $timesheet[0]->company_id,
                        'leave_type_id' => 7,
                        'from_date' => $next_form_date,
                        'to_date' => $timesheet[0]->to_date,
                        'applied_on' => date('Y-m-d h:i:s'),
                        'remarks' => $this->input->post('remarks'),
                        'status' => '2',
                        'is_notify' => '1',
                        'created_at' => date('Y-m-d h:i:s'),
                        'days' => $no_of_days_annual_remain,
                        'leave_unpaid_auto' => $id,
                        'cleared_status' => 1,
                        'probation_check' => $probation_check
                    );
                    $result = $this->Timesheet_model->add_leave_record_new($data);
                    $unpaid_leave_id = $result;
                    /* Leave carryforward management */
                    $timesheet = $this->Timesheet_model->read_leave_information($result);
                    //carryforward
                    $date_arr = explode("-", $timesheet[0]->from_date);
                    $year_check = $date_arr[0];
                    $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                    //end				
                    if (($status == '2') && (isset($timesheet[0]->status) !== '2')) {
                        $hlfcounts = 0;
                        $count_ls = 0;
                        $leaves_id = $timesheet[0]->leave_type_id;
                        $employees_id = $timesheet[0]->employee_id;
                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                        $count = $xin_leave_type[0]->leave_count;
                        $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);


                        $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                        foreach ($leave_halfday_cals as $lhalfday) :
                            $hlfcounts += 0.5;
                        endforeach;
                        $count_ls = count_leaves_info($leaves_id, $employees_id);
                        $count_ls = $count_ls - $hlfcounts;
                        $va = $count_leave_type[0]->days_per_year;
                        $type = $this->Timesheet_model->read_leave_type_information($leaves_id);
                        $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
                        //$total =$type[0]->days_per_year;
                        if ($emp_leaves_data) {
                            $total = $emp_leaves_data[0]->leave_count;
                        } else {
                            $total = 0;
                        }
                        $leave_remaining_total = $total - $count_ls;
                        $c = $count - $va;
                        $re = $total - $count_ls;
                        if ($leave_remaining_total == 0) {
                            $lr = 0;
                            $hr = 0;
                        } elseif ($leave_remaining_total < $count_ls) {
                            $lr = 0;
                            $hr = $c;
                        } else {
                            $lr = $leave_remaining_total;
                            $hr = 0;
                        }
                        $date_arr = explode("-", $timesheet[0]->from_date);
                        $year_check = $date_arr[0];
                        $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                        if ($result->num_rows() == 0) {
                            $data_insert = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => abs($leave_remaining_total),
                                'create_date' => date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_insert($data_insert);
                        } else {
                            $carry_leave = $result->result(); //print_r($carry_leave);exit;
                            $data_update = array(
                                'employee_id' => $timesheet[0]->employee_id,
                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                'remaing_leave_count' => abs($leave_remaining_total),
                                //'create_date'=> date('Y-m-d')
                            );
                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                        }
                    } else if ($status != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                        //pending or rejected
                        $carry_leave = $result_carry->result();
                        $hlfcounts = 0;
                        $count_ls = 0;
                        $leaves_id = $timesheet[0]->leave_type_id;
                        $employees_id = $timesheet[0]->employee_id;
                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                        $count = $xin_leave_type[0]->leave_count;
                        $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                        $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                        foreach ($leave_halfday_cals as $lhalfday) :
                            $hlfcounts += 0.5;
                        endforeach;
                        $count_ls = count_leaves_info($leaves_id, $employees_id);
                        $count_ls = $count_ls - $hlfcounts;
                        $leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
                        //$leave_remaining_total = $leave_remaining_total - $hlfcounts;
                        $data_update = array(
                            'employee_id' => $timesheet[0]->employee_id,
                            'leave_type_id' => $timesheet[0]->leave_type_id,
                            'remaing_leave_count' => abs($leave_remaining_total),
                            //'create_date'=> date('Y-m-d')
                        );
                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                    }
                    /* End Leave carryforward management */
                }
            }
            if ($check_flag == 0) {
                /* Leave carryforward management */
                $timesheet = $this->Timesheet_model->read_leave_information($id);
                //carryforward
                $date_arr = explode("-", $timesheet[0]->from_date);
                $year_check = $date_arr[0];
                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                //end			
                if (($status == '2') && (isset($timesheet[0]->status) !== '2')) {
                    $hlfcounts = 0;
                    $count_ls = 0;
                    $leaves_id = $timesheet[0]->leave_type_id;
                    $employees_id = $timesheet[0]->employee_id;
                    $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                    $count = $xin_leave_type[0]->leave_count;
                    $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                    $leave_half_day_opt = $timesheet[0]->is_half_day;

                    $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                    foreach ($leave_halfday_cals as $lhalfday) :
                        $hlfcounts += 0.5;
                    endforeach;
                    $count_ls = count_leaves_info($leaves_id, $employees_id);
                    $count_ls = $count_ls - $hlfcounts;
                    $carry_leave = $result_carry->result();
                    if ($carry_leave) {
                        $total = $carry_leave[0]->remaing_leave_count;
                    } else {
                        $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                        $total = $emp_leave_count[0]->leave_count;
                    }

                    $taked_leaves = $timesheet[0]->days;

                    if ($leaves_id == 7) {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        }
                        $leave_remaining_total = abs($leave_remaining_total);
                    } else {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        }

                        $leave_remaining_total = $leave_remaining_total;
                    }

                    $date_arr = explode("-", $timesheet[0]->from_date);
                    $year_check = $date_arr[0];
                    $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                    if ($result->num_rows() == 0) {
                        $data_insert = array(
                            'employee_id' => $timesheet[0]->employee_id,
                            'leave_type_id' => $timesheet[0]->leave_type_id,
                            'remaing_leave_count' => $leave_remaining_total,
                            'create_date' => date('Y-m-d')
                        );
                        $data_result = $this->Timesheet_model->carry_insert($data_insert);
                    } else {
                        $carry_leave = $result->result();
                        $data_update = array(
                            'employee_id' => $timesheet[0]->employee_id,
                            'leave_type_id' => $timesheet[0]->leave_type_id,
                            'remaing_leave_count' => $leave_remaining_total,
                            //'create_date'=> date('Y-m-d')
                        );
                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                    }
                } else if ($status !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                    //pending or rejected
                    $carry_leave = $result_carry->result();
                    $hlfcounts = 0;
                    $count_ls = 0;
                    $leave_half_day_opt = $timesheet[0]->is_half_day;
                    $leaves_id = $timesheet[0]->leave_type_id;
                    $employees_id = $timesheet[0]->employee_id;
                    $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                    $count = $xin_leave_type[0]->leave_count;
                    $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                    $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                    foreach ($leave_halfday_cals as $lhalfday) :
                        $hlfcounts += 0.5;
                    endforeach;
                    $count_ls = count_leaves_info($leaves_id, $employees_id);
                    $count_ls = $count_ls - $hlfcounts;
                    $leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

                    $total = $carry_leave[0]->remaing_leave_count;
                    $taked_leaves = $timesheet[0]->days;
                    //print_r($taked_leaves);exit;

                    if ($leaves_id == 7) {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                            //$leave_remaining_total = $total + $taked_leaves;
                        }
                        $leave_remaining_total = abs($leave_remaining_total);
                    } else {
                        if ($status != 2) {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total + 0.5;
                            } else {
                                $leave_remaining_total = $total + $taked_leaves;
                            }
                        } else {
                            if ($leave_half_day_opt == 1) {
                                $leave_remaining_total = $total - 0.5;
                            } else {
                                $leave_remaining_total = $total - $taked_leaves;
                            }
                        }
                        $leave_remaining_total = $leave_remaining_total;
                    }
                    $data_update = array(
                        'employee_id' => $timesheet[0]->employee_id,
                        'leave_type_id' => $timesheet[0]->leave_type_id,
                        'remaing_leave_count' => $leave_remaining_total,
                        //'create_date'=> date('Y-m-d')
                    );
                    $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                }
                /* End Leave carryforward management */
                $Return['result'] = $this->lang->line('xin_success_leave__status_updated');
            } else if ($check_flag == 1) {
                $Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
            } else {
                $Return['result'] = $this->lang->line('xin_success_leave__status_updated');
            }

            $nticket_data = array(
                'module_name' => 'leave_approve',
                'module_id' => $id,
                'employee_id' => $timesheet[0]->employee_id,
                'is_notify' => '1',
                'created_at' => date('d-m-Y h:i:s'),
            );
            $this->Xin_model->add_notifications($nticket_data);


            $setting = $this->Xin_model->read_setting_info(1);
            if ($setting[0]->enable_email_notification == 'yes') {

                if ($status == 2) {

                    $this->email->set_mailtype("html");

                    //get leave info
                    $timesheet = $this->Timesheet_model->read_leave_information($id);
                    if (empty($timesheet) && $unpaid_leave_id != 0) {
                        $timesheet = $this->Timesheet_model->read_leave_information($unpaid_leave_id);
                    }
                    //get company info
                    $cinfo = $this->Xin_model->read_company_setting_info(1);
                    //get email template
                    $template = $this->Xin_model->read_email_template(6);
                    //get employee info
                    $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

                    $full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

                    $from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
                    $to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

                    $subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
                    $logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

                    $message = '
                        <div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
                        <img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

                    hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
                } else if ($status == 3) { // rejected

                    $this->email->set_mailtype("html");

                    //get leave info
                    $timesheet = $this->Timesheet_model->read_leave_information($id);
                    //get company info
                    $cinfo = $this->Xin_model->read_company_setting_info(1);
                    //get email template
                    $template = $this->Xin_model->read_email_template(7);
                    //get employee info
                    $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

                    $full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

                    $from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
                    $to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

                    $subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
                    $logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

                    $message = '
                        <div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
                        <img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

                    hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
                }
            }
        }
        if ($Return['error'] != '') {
            $Return['code'] = '201';
            $Return['msg'] = $Return['error'];
            header('Content-Type: application/json');
            echo json_encode($Return);
        }
        $Return['code'] = '200';
        $Return['msg'] = $Return['result'];
        header('Content-Type: application/json');
        echo json_encode($Return);
    }
    
    
    
    public function leave_annual_details_api()
     {
           
        $leave_id = $this->input->post('leave_id');
   
        if($leave_id==NULL)
        {
            $Return = array('result' => '', 'message' => 'Leave id is needed');
        }else {
            $result = $this->Timesheet_model->read_annual_leave_information($leave_id);
            if($result==NULL)
            {
                $Return = array('result' => '', 'message' => 'No Data Found');
            }else{
                $annual_leave_amt=$result[0]->annua_amt;
                 $data = array(
                    'annual_leave_amt' => $annual_leave_amt,
                    'remarks' => $result[0]->remarks,
                );
                $Return = array('result' => $data , 'message' => 'Success');
            }
        }
        echo json_encode($Return);

     }
     
     
      public function AnnualCalcCommon($id)
    {
        $timesheet = $this->Timesheet_model->read_annual_leave_information($id);
        $user_id = $timesheet[0]->employee_id;
        $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
        $basic_salary = $user_info[0]->basic_salary;
        $year_annual = $months_annual = $leave_days = 0;
        $annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
        //print_r($this->db->last_query());exit;
        if ($annual_leaves_exits) {
            $joining_date = $this->Timesheet_model->joining_date($user_id);
            $start_date_y_m = date('Y-m', strtotime($annual_leaves_exits[0]->from_date));
        } else {
            $joining_date = $this->Timesheet_model->joining_date($user_id);
            $start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
        }

        $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
        $present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
        $absent_count = 0;
        $leave_count = 0;

        $from_Date = $timesheet[0]->from_date;
        $to_Date = $timesheet[0]->to_date;
        $ann_all_dect = $this->Xin_model->payroll_all_dedctions_and_additions_annual($user_id, $basic_salary, $from_Date, $to_Date);
        $allowance_amount = $ann_all_dect[0];
        $commissions_amount = $ann_all_dect[1];
        $other_payments_amount = $ann_all_dect[2];
        $statutory_deductions_amount = $ann_all_dect[3];
        $loan_de_amount = $ann_all_dect[4];

        $anual_days_leave = $timesheet[0]->days;
        $check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid_new($user_id, $from_Date);
        if ($check_already_exists_paid) {
            if ($check_already_exists_paid[0]->from_date) {
                $annual_calc_start_date = $check_already_exists_paid[0]->from_date;
            } else {
                $annual_calc_start_date = $user_info[0]->leave_salary_calculated_date;
            }
            $annual_calc_end_date = date('Y-m-d', strtotime('-1 day', strtotime($from_Date)));
        } else {
            if ($user_info[0]->leave_salary_calculated_date) {
                $annual_calc_start_date = $user_info[0]->leave_salary_calculated_date;
            } else {
                $annual_calc_start_date = $joining_date[0]->date_of_joining;
            }
            $annual_calc_end_date = date('Y-m-d', strtotime('-1 day', strtotime($from_Date)));
        }
        //print_r($annual_calc_start_date);echo '<pre>';print_r($annual_calc_end_date);exit;
        $startDate = new DateTime($annual_calc_start_date);
        $endDate = new DateTime($annual_calc_end_date);
        $difference = $endDate->diff($startDate);
        $difference_days = $difference->format("%a") + 1;
        if ($difference_days > 0) {
            $year_annual = $difference_days / 365;
            $months_annual = $year_annual * 12;
            $leave_const_count = $this->Timesheet_model->read_leave_type_information(3);
            $leave_const_count = $leave_const_count[0]->days_per_year;
            $per_month = $leave_const_count / 12;
            $leave_days = $months_annual * $per_month;
            if ($basic_salary > 0) {
                $total_earning = $basic_salary + $allowance_amount;
                $annual_amt = $total_earning / 30 * $leave_days;
            } else {
                $annual_amt = 0;
            }
        }
        $annual_amt = number_format($annual_amt, 3);
        return array($annual_amt, $allowance_amount, $commissions_amount, $other_payments_amount, $statutory_deductions_amount, $loan_de_amount, $year_annual, $months_annual, $leave_days);
     
    }
     
     public function refreshAnnualLeaveCalc_api()
     {
        
        $leave_id = $this->input->post('leave_id');
        if($leave_id==NULL)
        {
            $Return = array('result' => '', 'message' => 'Leave id is needed');
        }else {
            $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
            if($timesheet==NULL)
            {
                $Return = array('result' => '', 'message' => 'No Data Found');
            }else{
                $user_id = $timesheet[0]->employee_id;
                $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                //Check annual leave exists for the corresponding employee 

                // end annual leave exists check 
                $net_annual_amt = 0;
                $annul_days = 0;
                $annual_amt_pay = $anual_days_leave = 0;
                $basic_salary = $user_info[0]->basic_salary;

                if ($timesheet[0]->paid_status == 'N') {

                    $ann_calc_common = $this->AnnualCalcCommon($leave_id);
                    if ($ann_calc_common) {
                        $annual_amt_pay = $ann_calc_common[0];
                        $allowance_amount = $ann_calc_common[1];
                        $commissions_amount = $ann_calc_common[2];
                        $other_payments_amount = $ann_calc_common[3];
                        $statutory_deductions_amount = $ann_calc_common[4];
                        $loan_de_amount = $ann_calc_common[5];
                    } else {
                    $annual_amt_pay = $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
                    }
                $dataaa = array(
                    'annua_amt' => $annual_amt_pay,
                    'allowance' => $allowance_amount,
                    'commissions_amount' => $commissions_amount,
                    'other_payments_amount' => $other_payments_amount,
                    'statutory_deductions_amount' => $statutory_deductions_amount,
                    'loan_de_amount' => $loan_de_amount,
                    'updated_date' => date('Y-m-d')
                );
                $result = $this->Timesheet_model->update_annual_leave_record($dataaa, $leave_id);
                if ($result) {
                    $Return['message'] = 'Success';
                } else {
                    $Return['message'] = 'Something went to wrong';
                }
            } else {
                $Return['message'] = 'Amount already paid';
            }
        
            }
        }
        echo json_encode($Return);
     }
     
       public function update_annual_leave_status_api()
       
     {
         
        $leave_id = $this->input->post('leave_id');
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
        $remarks = $this->input->post('remarks');
       
       
        if($leave_id==NULL)
        {
            $Return = array('result' => '', 'message' => 'Leave id is needed');
        }else {
            $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
            if($timesheet==NULL)
            {
                $Return = array('result' => '', 'message' => 'No Data Found');
            }else{
                if($remarks==NULL)
                {
                    $Return = array('result' => '', 'message' => 'Remarks is needed');
                }else{
                    $qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
                    $check_flag = 0;
                    $no_of_days_annual_remain = 0;
                    if ($this->input->get('probation_check')) {
                        $probation_check = $this->input->get('probation_check');
                    } else {
                        $probation_check = 'null';
                    }
                    $clr_d_msg = '';
                    
                     $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
            if($timesheet==NULL)
            {
                $Return = array('result' => '', 'message' => 'No Data Found');
            }else{
                $user_id = $timesheet[0]->employee_id;
                $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                
            }
                    // $session = $this->session->userdata('username');
                   
                      $role_role_id = $user_info[0]->user_role_id;
                      
                        $role_user = $this->Xin_model->read_user_role_info($role_role_id);

                       $role_resources_ids = $role_user[0]->role_resources;
                       
                   // $role_resources_ids = $this->Xin_model->user_role_resource();
                   
                    $first_approval = $second_approval = $final_approval = 0;
                    $approved_by_first = $approved_by_second = $approved_by_final = '';
                    if ($this->input->post('status') == null) {
                        $first_approval = $timesheet[0]->first_approval;
                        $second_approval = $timesheet[0]->second_approval;
                        $final_approval = $timesheet[0]->final_approval;
                        $status_updated = $timesheet[0]->status;
                        $approved_by_first = $timesheet[0]->approved_by_first;
                        $approved_by_second = $timesheet[0]->approved_by_second;
                        $approved_by_final = $timesheet[0]->approved_by_final;
                    } else {
                        if ($user_info[0]->user_role_id == 1) {
                            $status_updated = $this->input->post('status');

                            if ($status_updated == 2) {
                                $first_approval = $second_approval = $final_approval = 1;
                                $old_first_val = $timesheet[0]->first_approval;
                                if ($old_first_val) {
                                    $approved_by_first = $timesheet[0]->approved_by_first;
                                } else {
                                    $approved_by_first = $session['user_id'];
                                }
                                $old_second_val = $timesheet[0]->second_approval;
                                if ($old_second_val) {
                                    $approved_by_second = $timesheet[0]->approved_by_second;
                                } else {
                                    $approved_by_second = $session['user_id'];
                                }
                                $old_final_val = $timesheet[0]->final_approval;
                                if ($old_final_val) {
                                    $approved_by_final = $timesheet[0]->approved_by_final;
                                } else {
                                    $approved_by_final = $session['user_id'];
                                }
                            } else if ($status_updated == 3) {
                                $final_approval = 2;
                                $approved_by_final = $session['user_id'];
                            }

                            if ($status_updated == 3 || $status_updated == 1) {
                                $clr_d_msg = 0;
                            }
                        } elseif (in_array('256', $role_resources_ids) || in_array('258', $role_resources_ids) || in_array('257', $role_resources_ids)) {
                            if (in_array('256', $role_resources_ids)) {
                                $status_updated = 1; //$this->input->post('status_old');

                                if ($this->input->post('status') == 2) {
                                    $first_approval = 1;
                                    $old_first_val = $timesheet[0]->first_approval;
                                    if ($old_first_val) {
                                        $approved_by_first = $timesheet[0]->approved_by_first;
                                    } else {
                                        $approved_by_first = $session['user_id'];
                                    }
                                } elseif ($this->input->post('status') == 3) {
                                    $first_approval = 2;
                                    $approved_by_first = $session['user_id'];
                                }
                            }
                            if (in_array('257', $role_resources_ids)) { //second approval
                                $status_updated = 1; //$this->input->post('status_old');

                                if ($this->input->post('status') == 2 && $timesheet[0]->first_approval) {
                                    $first_approval = $second_approval = 1;
                                    $old_second_val = $timesheet[0]->second_approval;
                                    if ($old_second_val) {
                                        $approved_by_second = $timesheet[0]->approved_by_second;
                                    } else {
                                        $approved_by_second = $session['user_id'];
                                    }
                                } elseif ($this->input->post('status') == 3) {
                                    $second_approval = 2;
                                    $approved_by_second = $session['user_id'];
                                }
                            }
                            if (in_array('258', $role_resources_ids)) {
                                $status_updated = 1; //$this->input->post('status_old');

                                if ($this->input->post('status') == 2) {
                                    $first_approval = $second_approval = $final_approval = 1;
                                    $status_updated = 2;
                                    $old_first_val = $timesheet[0]->first_approval;
                                    if ($old_first_val) {
                                        $approved_by_first = $timesheet[0]->approved_by_first;
                                    } else {
                                        $approved_by_first = $session['user_id'];
                                    }
                                    $old_second_val = $timesheet[0]->second_approval;
                                    if ($old_second_val) {
                                        $approved_by_second = $timesheet[0]->approved_by_second;
                                    } else {
                                        $approved_by_second = $session['user_id'];
                                    }
                                    $old_final_val = $timesheet[0]->final_approval;
                                    if ($old_final_val) {
                                        $approved_by_final = $timesheet[0]->approved_by_final;
                                    } else {
                                        $approved_by_final = $session['user_id'];
                                    }
                                } elseif ($this->input->post('status') == 3) {
                                    $final_approval = 2;
                                    $approved_by_final = $session['user_id'];
                                }
                            }
                        } else {
                            $status_updated = $this->input->post('leave_status_old');
                        }
                    }
                    $check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
                    if (!empty($check_annual_leave_aval)) {
                        $yr_duration_strat = $check_annual_leave_aval[0]->annual_leave_duration_start;
                        $yr_duration_end = $check_annual_leave_aval[0]->annual_leave_duration_end;
                    } else {
                        $yr_duration_strat = '';
                        $yr_duration_end = '';
                    }
                    $clr_check = $timesheet[0]->cleared_status;
                    if (($user_info[0]->user_role_id == 1)) {

                        if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {
                            $no_of_days = $timesheet[0]->days;
                            $aval_leaves = 0;
                            $check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
                            if (!empty($check_annual_leave_aval)) {
                                $aval_leaves = $check_annual_leave_aval[0]->leave_count;
                            }
                            $date_arr = explode("-", $timesheet[0]->from_date);
                            $year_check = $date_arr[0];
                            $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                            $input = $user[0]->leave_updated_date;
                            $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                            $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_starndrd($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                            $carry_leave_exced = $result_carry->result();
                            if ($result_carry->num_rows() > 0) {
                                if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
                                    if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
                                        $no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
                                        $no_of_days = $carry_leave_exced[0]->remaing_leave_count;
                                        $aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
                                        $inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
                                        $next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
                                    } else {
                                        $next_form_date_ann = $timesheet[0]->to_date;
                                    }
                                } else {
                                    if ($no_of_days > $aval_leaves) {
                                        $no_of_days_annual_remain = $no_of_days - $aval_leaves;
                                        $no_of_days = $aval_leaves;
                                        $inc_days = $aval_leaves - 1;
                                        $next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
                                    } else {
                                        $next_form_date_ann = $timesheet[0]->to_date;
                                    }
                                }
                            } else {

                                if ($no_of_days > $aval_leaves) {
                                    $no_of_days_annual_remain = $no_of_days - $aval_leaves;
                                    $no_of_days = $aval_leaves;
                                    $inc_days = $aval_leaves - 1;
                                    $next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
                                } else {
                                    $next_form_date_ann = $timesheet[0]->to_date;
                                }
                            }
                            if ((!empty($this->input->get('probation_check')) && $probation_check == 'lop')) {
                                $timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($leave_id);
                                $check_flag = 3;
                                $no_of_days_annual_remain = 0;
                                $data = array(
                                    'employee_id' => $timesheet_exceeds[0]->employee_id,
                                    'company_id' => $timesheet_exceeds[0]->company_id,
                                    'leave_type_id' => 7,
                                    'from_date' => $timesheet_exceeds[0]->from_date,
                                    'to_date' => $timesheet_exceeds[0]->to_date,
                                    'applied_on' => $timesheet_exceeds[0]->applied_on,
                                    'reason' => $timesheet_exceeds[0]->remarks,
                                    'remarks' => $timesheet_exceeds[0]->remarks,
                                    'status' => '2',
                                    'is_notify' => '1',
                                    'created_at' => date('Y-m-d h:i:s'),
                                    'days' => $timesheet_exceeds[0]->days,
                                    'cleared_status' => 1,
                                    'probation_check' => $probation_check
                                );
                                $result = $this->Timesheet_model->add_leave_record_new($data);
                                $unpaid_leave_id = $result;
                                $timesheet = $this->Timesheet_model->read_leave_information($result);
                                $date_arr = explode("-", $timesheet[0]->from_date);
                                $year_check = $date_arr[0];
                                //$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                                $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                $input = $user[0]->leave_updated_date;
                                $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
                                    $leaves_id = $timesheet[0]->leave_type_id;
                                    $employees_id = $timesheet[0]->employee_id;
                                    $emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
                                    if ($emp_leaves_data) {
                                        $total = $emp_leaves_data[0]->leave_count;
                                    } else {
                                        $total = 0;
                                    }
                                    $carry_leave = $result_carry->result();
                                    if ($carry_leave) {
                                        $total = $carry_leave[0]->remaing_leave_count;
                                    } else {
                                        $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                        $total = $emp_leave_count[0]->leave_count;
                                    }
                                    $taked_leaves = $timesheet[0]->days;
                                    if ($this->input->post('status') == 2) {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                    $leave_remaining_total = $leave_remaining_total;
                                    $date_arr = explode("-", $timesheet[0]->from_date);
                                    $year_check = $date_arr[0];
                                    //$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                                    $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                    $input = $user[0]->leave_updated_date;
                                    $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                    $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                    if ($result->num_rows() == 0) {
                                        $data_insert = array(
                                            'employee_id' => $timesheet[0]->employee_id,
                                            'leave_type_id' => $timesheet[0]->leave_type_id,
                                            'remaing_leave_count' => abs($leave_remaining_total),
                                            'create_date' => date('Y-m-d'),
                                            'annual_leave_duration_start' => $yr_duration_strat,
                                            'annual_leave_duration_end' => $yr_duration_end
                                        );
                                        $data_result = $this->Timesheet_model->carry_insert($data_insert);
                                    } else {
                                        $carry_leave = $result->result(); //print_r($carry_leave);exit;
                                        $data_update = array(
                                            'employee_id' => $timesheet[0]->employee_id,
                                            'leave_type_id' => $timesheet[0]->leave_type_id,
                                            'remaing_leave_count' => abs($leave_remaining_total),
                                            //'create_date'=> date('Y-m-d')
                                        );
                                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                    }
                                } else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                                    $carry_leave = $result_carry->result();
                                    $hlfcounts = 0;
                                    $count_ls = 0;
                                    $leaves_id = $timesheet[0]->leave_type_id;
                                    $employees_id = $timesheet[0]->employee_id;
                                    if ($carry_leave) {
                                        $total = $carry_leave[0]->remaing_leave_count;
                                    } else {
                                        $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                        $total = $emp_leave_count[0]->leave_count;
                                    }
                                    $taked_leaves = $timesheet[0]->days;
                                    if ($this->input->post('status') == 2) {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                    $leave_remaining_total = $leave_remaining_total;
                                    $data_update = array(
                                        'employee_id' => $timesheet[0]->employee_id,
                                        'leave_type_id' => $timesheet[0]->leave_type_id,
                                        'remaing_leave_count' => abs($leave_remaining_total),
                                        //'create_date'=> date('Y-m-d')
                                    );
                                    $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                }
                                $result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
                            } else {
                                $timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($leave_id);
                                $date_arr = explode("-", $timesheet_exceeds[0]->from_date);
                                $year_check = $date_arr[0];
                                $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                $input = $user[0]->leave_updated_date;
                                $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet_exceeds[0]->employee_id, 3, $input, $newEndingDate);
                                $carry_leave_exced = $result_carry->result();
                                if ($result_carry->num_rows() > 0) {

                                    if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
                                        $check_flag = 1;
                                        $no_of_days_annual_remain = 0;
                                        $data = array(
                                            'employee_id' => $timesheet_exceeds[0]->employee_id,
                                            'company_id' => $timesheet_exceeds[0]->company_id,
                                            'leave_type_id' => 7,
                                            'from_date' => $timesheet_exceeds[0]->from_date,
                                            'to_date' => $timesheet_exceeds[0]->to_date,
                                            'applied_on' => $timesheet_exceeds[0]->applied_on,
                                            'reason' => $timesheet_exceeds[0]->remarks,
                                            'remarks' => $timesheet_exceeds[0]->remarks,
                                            'status' => '2',
                                            'is_notify' => '1',
                                            'created_at' => date('Y-m-d h:i:s'),
                                            'days' => $timesheet_exceeds[0]->days,
                                            'cleared_status' => 1,
                                            'probation_check' => $probation_check
                                        );
                                        $result = $this->Timesheet_model->add_leave_record_new($data);
                                        $unpaid_leave_id = $result;
                                        $timesheet = $this->Timesheet_model->read_leave_information($result);
                                        if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {

                                            $hlfcounts = 0;
                                            $count_ls = 0;
                                            $leaves_id = $timesheet[0]->leave_type_id;
                                            $employees_id = $timesheet[0]->employee_id;
                                            $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                            $count = $xin_leave_type[0]->leave_count;
                                            $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                                            $emp_leaves_data = $this->Timesheet_model->annual_leave_availablefor_emp_limt($employees_id, $leaves_id);
                                            if ($emp_leaves_data) {
                                                $total = $emp_leaves_data[0]->leave_count;
                                            } else {
                                                $total = 0;
                                            }
                                            //  $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                                            $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                            $input = $user[0]->leave_updated_date;
                                            $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                            $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                            $carry_leave = $result_carry->result();
                                            if ($carry_leave) {
                                                $total = $carry_leave[0]->remaing_leave_count;
                                            } else {
                                                $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                                $total = $emp_leave_count[0]->leave_count;
                                            }
                                            $taked_leaves = $timesheet[0]->days;
                                            if ($this->input->post('status') == 2) {
                                                $leave_remaining_total = $total - $taked_leaves;
                                            } else {
                                                $leave_remaining_total = $total + $taked_leaves;
                                            }
                                            $leave_remaining_total = $leave_remaining_total;
                                            $date_arr = explode("-", $timesheet[0]->from_date);
                                            $year_check = $date_arr[0];
                                            $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                                            $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                            $input = $user[0]->leave_updated_date;
                                            $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                            $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet_exceeds[0]->employee_id, 3, $input, $newEndingDate);
                                            if ($result->num_rows() == 0) {
                                                $data_insert = array(
                                                    'employee_id' => $timesheet[0]->employee_id,
                                                    'leave_type_id' => $timesheet[0]->leave_type_id,
                                                    'remaing_leave_count' => abs($leave_remaining_total),
                                                    'create_date' => date('Y-m-d'),
                                                    'annual_leave_duration_start' => $yr_duration_strat,
                                                    'annual_leave_duration_end' => $yr_duration_end
                                                );
                                                $data_result = $this->Timesheet_model->carry_insert($data_insert);
                                            } else {
                                                $carry_leave = $result_carry->result(); //print_r($carry_leave);exit;
                                                $data_update = array(
                                                    'employee_id' => $timesheet[0]->employee_id,
                                                    'leave_type_id' => $timesheet[0]->leave_type_id,
                                                    'remaing_leave_count' => abs($leave_remaining_total),
                                                    //'create_date'=> date('Y-m-d')
                                                );
                                                $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                            }
                                        } else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                                            $carry_leave = $result_carry->result();
                                            $hlfcounts = 0;
                                            $count_ls = 0;
                                            $leaves_id = $timesheet[0]->employee_id;
                                            $employees_id = $timesheet[0]->employee_id;
                                            $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                            if ($carry_leave) {
                                                $total = $carry_leave[0]->remaing_leave_count;
                                            } else {
                                                $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                                $total = $emp_leave_count[0]->leave_count;
                                            }
                                            $taked_leaves = $timesheet[0]->days;
                                            if ($this->input->post('status') == 2) {
                                                $leave_remaining_total = $total + $taked_leaves;
                                            } else {
                                                $leave_remaining_total = $total - $taked_leaves;
                                            }
                                            $leave_remaining_total = $leave_remaining_total;
                                            $data_update = array(
                                                'employee_id' => $timesheet[0]->employee_id,
                                                'leave_type_id' => $timesheet[0]->leave_type_id,
                                                'remaing_leave_count' => abs($leave_remaining_total),
                                                //'create_date'=> date('Y-m-d')
                                            );
                                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                        }
                                        $result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
                                    } else {
                                        $data = array(
                                            'status' => $this->input->post('status'),
                                            'remarks' => $qt_remarks,
                                            'allotted_leave' => $aval_leaves,
                                            'to_date' => $next_form_date_ann,
                                            'days' => $no_of_days,
                                            'cleared_status' => 1,
                                            'annua_amt' => $this->input->post('annual_leave_amt'),
                                            'first_approval' => $first_approval,
                                            'second_approval' => $second_approval,
                                            'final_approval' => $final_approval,
                                            'approved_by_first' => $approved_by_first,
                                            'approved_by_second' => $approved_by_second,
                                            'approved_by_final' => $approved_by_final,
                                            'updated_date' => date('Y-m-d')
                                        );
                                        
                                   
                                        $result = $this->Timesheet_model->update_annual_leave_record($data, $leave_id);
                                    }
                                } else {
                                    $data = array(
                                        'status' => $this->input->post('status'),
                                        'remarks' => $qt_remarks,
                                        'allotted_leave' => $aval_leaves,
                                        'to_date' => $next_form_date_ann,
                                        'days' => $no_of_days,
                                        'cleared_status' => 1,
                                        'annua_amt' => $this->input->post('annual_leave_amt'),
                                        'first_approval' => $first_approval,
                                        'second_approval' => $second_approval,
                                        'final_approval' => $final_approval,
                                        'approved_by_first' => $approved_by_first,
                                        'approved_by_second' => $approved_by_second,
                                        'approved_by_final' => $approved_by_final,
                                        'updated_date' => date('Y-m-d')
                                    );
                                    $result = $this->Timesheet_model->update_annual_leave_record($data, $leave_id);
                                }
                            }
                        } else {

                            if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
                                $check_flag = 2;
                            }
                            $data = array(
                                'status' => $this->input->post('status'),
                                'annua_amt' => $this->input->post('annual_leave_amt'),
                                'remarks' => $this->input->post('remarks'),
                                'first_approval' => $first_approval,
                                'second_approval' => $second_approval,
                                'final_approval' => $final_approval,
                                'approved_by_first' => $approved_by_first,
                                'approved_by_second' => $approved_by_second,
                                'approved_by_final' => $approved_by_final,
                                'updated_date' => date('Y-m-d')
                            );
                            
                            $result = $this->Timesheet_model->update_annual_leave_record($data, $leave_id);
                        }
                        if ($result == TRUE) {
                            if ($no_of_days_annual_remain > 0) {
                                $next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
                                $checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
                                if (!empty($checl_already_exists_annual)) {
                                    $data = array(
                                        'from_date' => $next_form_date,
                                        'to_date' => $timesheet[0]->to_date,
                                        'reason' => $qt_remarks,
                                        'remarks' => $qt_remarks,
                                        'status' => '2',
                                        'is_notify' => '1',
                                        'days' => $no_of_days_annual_remain,
                                        'is_annual' => $leave_id,
                                        'cleared_status' => 1,
                                        'probation_check' => $probation_check,
                                        'updated_date' => date('Y-m-d')
                                    );
                                    
                                        
                                    $result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
                                    $timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
                                    $date_arr = explode("-", $timesheet[0]->from_date);
                                    $year_check = $date_arr[0];
                                    //  $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                                    $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                    $input = $user[0]->leave_updated_date;
                                    $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                    $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                    if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {


                                        $carry_leave = $result_carry->result();
                                        $leaves_id = $timesheet[0]->leave_type_id;
                                        $employees_id = $timesheet[0]->employee_id;
                                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                        if ($carry_leave) {
                                            $total = $carry_leave[0]->remaing_leave_count;
                                        } else {
                                            $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                            $total = $emp_leave_count[0]->leave_count;
                                        }
                                        $taked_leaves = $timesheet[0]->days;
                                        if ($this->input->post('status') != 2) {
                                            $leave_remaining_total = $total + $taked_leaves;
                                        } else {
                                            $leave_remaining_total = $total - $taked_leaves;
                                        }
                                        $leave_remaining_total = $leave_remaining_total;
                                        $date_arr = explode("-", $timesheet[0]->from_date);
                                        $year_check = $date_arr[0];
                                        //  $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
                                        $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                        $input = $user[0]->leave_updated_date;
                                        $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                        $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                        if ($result->num_rows() == 0) {
                                            $data_insert = array(
                                                'employee_id' => $timesheet[0]->employee_id,
                                                'leave_type_id' => $leaves_id,
                                                'remaing_leave_count' => abs($leave_remaining_total),
                                                'create_date' => date('Y-m-d'),
                                                'annual_leave_duration_start' => $yr_duration_strat,
                                                'annual_leave_duration_end' => $yr_duration_end
                                            );
                                            $data_result = $this->Timesheet_model->carry_insert($data_insert);
                                        } else {
                                            $carry_leave = $result->result(); //print_r($carry_leave);exit;
                                            $data_update = array(
                                                'employee_id' => $timesheet[0]->employee_id,
                                                'leave_type_id' => $leaves_id,
                                                'remaing_leave_count' => abs($leave_remaining_total),
                                                //'create_date'=> date('Y-m-d')
                                            );
                                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                        }
                                    } else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                                        $carry_leave = $result_carry->result();
                                        $leaves_id = $timesheet[0]->leave_type_id;
                                        $employees_id = $timesheet[0]->employee_id;
                                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                        if ($carry_leave) {
                                            $total = $carry_leave[0]->remaing_leave_count;
                                        } else {
                                            $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                            $total = $emp_leave_count[0]->leave_count;
                                        }
                                        $taked_leaves = $timesheet[0]->days;
                                        if ($this->input->post('status') != 2) {
                                            $leave_remaining_total = $total + $taked_leaves;
                                        } else {
                                            $leave_remaining_total = $total - $taked_leaves;
                                        }
                                        $leave_remaining_total = $leave_remaining_total;
                                        $data_update = array(
                                            'employee_id' => $timesheet[0]->employee_id,
                                            'leave_type_id' => $leaves_id,
                                            'remaing_leave_count' => abs($leave_remaining_total),
                                            //'create_date'=> date('Y-m-d')
                                        );
                                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                    }
                                } else {
                                    $data = array(
                                        'employee_id' => $timesheet[0]->employee_id,
                                        'company_id' => $timesheet[0]->company_id,
                                        'leave_type_id' => 7,
                                        'from_date' => $next_form_date,
                                        'to_date' => $timesheet[0]->to_date,
                                        'applied_on' => date('Y-m-d h:i:s'),
                                        'reason' => $qt_remarks,
                                        'remarks' => $qt_remarks,
                                        'status' => '2',
                                        'is_notify' => '1',
                                        'created_at' => date('Y-m-d h:i:s'),
                                        'days' => $no_of_days_annual_remain,
                                        'is_annual' => $leave_id,
                                        'cleared_status' => 1,
                                        'probation_check' => $probation_check
                                    );
                                    $result = $this->Timesheet_model->add_leave_record_new($data);
                                    $unpaid_leave_id = $result;
                                    $timesheet = $this->Timesheet_model->read_leave_information($result);
                                    $date_arr = explode("-", $timesheet[0]->from_date);
                                    $year_check = $date_arr[0];
                                    //  $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
                                    $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                    $input = $user[0]->leave_updated_date;
                                    $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                    $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                    if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
                                        $carry_leave = $result_carry->result();
                                        $hlfcounts = 0;
                                        $count_ls = 0;
                                        $leaves_id = $timesheet[0]->leave_type_id;
                                        $employees_id = $timesheet[0]->employee_id;
                                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                        if ($carry_leave) {
                                            $total = $carry_leave[0]->remaing_leave_count;
                                        } else {
                                            $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                            $total = $emp_leave_count[0]->leave_count;
                                        }
                                        $taked_leaves = $timesheet[0]->days;
                                        if ($this->input->post('status') != 2) {
                                            $leave_remaining_total = $total + $taked_leaves;
                                        } else {
                                            $leave_remaining_total = $total - $taked_leaves;
                                        }
                                        //print_r($leave_remaining_total);exit;

                                        $leave_remaining_total = $leave_remaining_total;
                                        $date_arr = explode("-", $timesheet[0]->from_date);
                                        $year_check = $date_arr[0];
                                        //$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $leaves_id, $year_check);
                                        $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                        $input = $user[0]->leave_updated_date;
                                        $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                        $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                        if ($result->num_rows() == 0) {
                                            $data_insert = array(
                                                'employee_id' => $timesheet[0]->employee_id,
                                                'leave_type_id' => $leaves_id,
                                                'remaing_leave_count' => abs($leave_remaining_total),
                                                'create_date' => date('Y-m-d'),
                                                'annual_leave_duration_start' => $yr_duration_strat,
                                                'annual_leave_duration_end' => $yr_duration_end
                                            );
                                            $data_result = $this->Timesheet_model->carry_insert($data_insert);
                                        } else {
                                            $carry_leave = $result->result(); //print_r($carry_leave);exit;
                                            $data_update = array(
                                                'employee_id' => $timesheet[0]->employee_id,
                                                'leave_type_id' => $leaves_id,
                                                'remaing_leave_count' => abs($leave_remaining_total),
                                                //'create_date'=> date('Y-m-d')
                                            );
                                            $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                        }
                                    } else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                                        $carry_leave = $result_carry->result();
                                        $leaves_id = $timesheet[0]->leave_type_id;
                                        $employees_id = $timesheet[0]->employee_id;
                                        $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                        if ($carry_leave) {
                                            $total = $carry_leave[0]->remaing_leave_count;
                                        } else {
                                            $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                            $total = $emp_leave_count[0]->leave_count;
                                        }
                                        $taked_leaves = $timesheet[0]->days;
                                        if ($this->input->post('status') != 2) {
                                            $leave_remaining_total = $total + $taked_leaves;
                                        } else {
                                            $leave_remaining_total = $total - $taked_leaves;
                                        }
                                        $leave_remaining_total = $leave_remaining_total;
                                        $data_update = array(
                                            'employee_id' => $timesheet[0]->employee_id,
                                            'leave_type_id' => $leaves_id,
                                            'remaing_leave_count' => abs($leave_remaining_total),
                                            //'create_date'=> date('Y-m-d')
                                        );
                                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                    }
                                }
                            }
                            if ($check_flag == 0) {
                                /* Leave carryforward management */
                                $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
                                //carryforward
                                $date_arr = explode("-", $timesheet[0]->from_date);
                                $year_check = $date_arr[0];
                                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
                                $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                $input = $user[0]->leave_updated_date;
                                $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                $result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                //end           
                                if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2') && (isset($clr_check) != 1)) {
                                    $hlfcounts = 0;
                                    $count_ls = 0;
                                    $leaves_id = 3;
                                    $employees_id = $timesheet[0]->employee_id;
                                    $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                    $count = $xin_leave_type[0]->leave_count;
                                    $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                                    //$leave_half_day_opt = $timesheet[0]->is_half_day;

                                    $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                                    foreach ($leave_halfday_cals as $lhalfday) :
                                        $hlfcounts += 0.5;
                                    endforeach;
                                    $count_ls = count_leaves_info($leaves_id, $employees_id);
                                    $count_ls = $count_ls - $hlfcounts;
                                    $carry_leave = $result_carry->result();
                                    if ($carry_leave) {
                                        $total = $carry_leave[0]->remaing_leave_count;
                                    } else {
                                        $emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
                                        $total = $emp_leave_count[0]->leave_count;
                                    }

                                    $taked_leaves = $timesheet[0]->days;

                                    if ($this->input->get('status') != 2) {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }

                                    $leave_remaining_total = $leave_remaining_total;

                                    $date_arr = explode("-", $timesheet[0]->from_date);
                                    $year_check = $date_arr[0];
                                    $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
                                    $user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                    $input = $user[0]->leave_updated_date;
                                    $newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
                                    $result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
                                    if ($result->num_rows() == 0) {
                                        $data_insert = array(
                                            'employee_id' => $timesheet[0]->employee_id,
                                            'leave_type_id' => 3,
                                            'remaing_leave_count' => $leave_remaining_total,
                                            'create_date' => date('Y-m-d'),
                                            'annual_leave_duration_start' => $yr_duration_strat,
                                            'annual_leave_duration_end' => $yr_duration_end
                                        );
                                        $data_result = $this->Timesheet_model->carry_insert($data_insert);
                                    } else {
                                        $carry_leave = $result->result();
                                        $data_update = array(
                                            'employee_id' => $timesheet[0]->employee_id,
                                            'leave_type_id' => 3,
                                            'remaing_leave_count' => $leave_remaining_total,
                                            //'create_date'=> date('Y-m-d')
                                        );
                                        $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                    }
                                } else if ($this->input->get('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
                                    //pending or rejected
                                    $carry_leave = $result_carry->result();
                                    $hlfcounts = 0;
                                    $count_ls = 0;
                                    //$leave_half_day_opt = $timesheet[0]->is_half_day;
                                    $leaves_id = $timesheet[0]->leave_type_id;
                                    $employees_id = $timesheet[0]->employee_id;
                                    $xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
                                    $count = $xin_leave_type[0]->leave_count;
                                    $count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
                                    $leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
                                    foreach ($leave_halfday_cals as $lhalfday) :
                                        $hlfcounts += 0.5;
                                    endforeach;
                                    $count_ls = count_leaves_info($leaves_id, $employees_id);
                                    $count_ls = $count_ls - $hlfcounts;
                                    $leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

                                    $total = $carry_leave[0]->remaing_leave_count;
                                    $taked_leaves = $timesheet[0]->days;
                                    if ($this->input->get('status') != 2) {
                                        $leave_remaining_total = $total + $taked_leaves;
                                    } else {
                                        $leave_remaining_total = $total - $taked_leaves;
                                    }
                                    $leave_remaining_total = $leave_remaining_total;
                                    $data_update = array(
                                        'employee_id' => $timesheet[0]->employee_id,
                                        'leave_type_id' => $timesheet[0]->leave_type_id,
                                        'remaing_leave_count' => $leave_remaining_total,
                                        //'create_date'=> date('Y-m-d')
                                    );
                                    $data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
                                }
                                /* End Leave carryforward management */
                                $Return['result'] = $this->lang->line('xin_success_leave__status_updated');
                            } else if ($check_flag == 1) {
                                $Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
                            } else {
                                $Return['result'] = $this->lang->line('xin_success_leave__status_updated');
                            }
                            if ($this->input->get('annual_leave_amt') == 0) {
                                $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
                                if (isset($timesheet[0]->paid_status) == 'N') {
                                    $ann_calc_common = $this->AnnualCalcCommon($leave_id);
                                    if ($ann_calc_common) {
                                        $annual_amt_pay = $ann_calc_common[0];
                                        $allowance_amount = $ann_calc_common[1];
                                        $commissions_amount = $ann_calc_common[2];
                                        $other_payments_amount = $ann_calc_common[3];
                                        $statutory_deductions_amount = $ann_calc_common[4];
                                        $loan_de_amount = $ann_calc_common[5];
                                        $annual_yr = $ann_calc_common[6];
                                        $annual_months = $ann_calc_common[7];
                                        $annual_days = $ann_calc_common[8];
                                    } else {
                                        $annual_amt_pay = $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = $annual_yr = $annual_months = $annual_days = 0;
                                    }
                                    $dataaa = array(
                                        'annua_amt' => $annual_amt_pay,
                                        'allowance' => $allowance_amount,
                                        'commissions_amount' => $commissions_amount,
                                        'other_payments_amount' => $other_payments_amount,
                                        'statutory_deductions_amount' => $statutory_deductions_amount,
                                        'loan_de_amount' => $loan_de_amount,
                                        'annual_year' => $annual_yr,
                                        'annual_month' => $annual_months,
                                        'annual_days' => $annual_days,
                                        'updated_date' => date('Y-m-d')
                                    );
                                   
                                    $result = $this->Timesheet_model->update_annual_leave_record($dataaa, $leave_id);
                                    //print_r($annual_amt_pay);exit;
                                }
                            } else {
                                $data = array(
                                    'annua_amt' => $this->input->get('annual_leave_amt'),
                                    'first_approval' => $first_approval,
                                    'second_approval' => $second_approval,
                                    'final_approval' => $final_approval,
                                    'approved_by_first' => $approved_by_first,
                                    'approved_by_second' => $approved_by_second,
                                    'approved_by_final' => $approved_by_final,
                                    'updated_date' => date('Y-m-d')
                                );
                                
                                 
                                $result = $this->Timesheet_model->update_annual_leave_record($data, $leave_id);
                            }
                            $data = array(
                                'probation_check' => $probation_check,
                                'updated_date' => date('Y-m-d')
                            );
                           
                            $result = $this->Timesheet_model->update_annual_leave_record($data, $leave_id);
                            $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
                            if (($this->input->get('status') == '2') && (isset($timesheet[0]->final_approval) == '1')) {
                                $nticket_data = array(
                                    'module_name' => 'annual_leave_approve',
                                    'module_id' => $leave_id,
                                    'employee_id' => $timesheet[0]->employee_id,
                                    'is_notify' => '1',
                                    'created_at' => date('d-m-Y h:i:s'),
                                );
                                $this->Xin_model->add_notifications($nticket_data);
                            } else if (($this->input->get('status') == '1')) {
                                $nticket_data = array(
                                    'module_name' => 'annual_leave_approve_pending',
                                    'module_id' => $leave_id,
                                    'employee_id' => $timesheet[0]->employee_id,
                                    'is_notify' => '1',
                                    'created_at' => date('d-m-Y h:i:s'),
                                );
                                $this->Xin_model->add_notifications($nticket_data);
                            } else if (($this->input->get('status') == '3')) {
                                $nticket_data = array(
                                    'module_name' => 'annual_leave_approve_rejected',
                                    'module_id' => $leave_id,
                                    'employee_id' => $timesheet[0]->employee_id,
                                    'is_notify' => '1',
                                    'created_at' => date('d-m-Y h:i:s'),
                                );
                                $this->Xin_model->add_notifications($nticket_data);
                            }
                            /* End Annual Settlement amount calc  */
                            if ($check_flag == 0) {
                                //$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
                                $setting = $this->Xin_model->read_setting_info(1);
                                if ($setting[0]->enable_email_notification == 'yes') {
                                    if ($this->input->get('status') == 2) {
                                        $this->email->set_mailtype("html");
                                        //get leave info
                                        $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
                                        //get company info
                                        $cinfo = $this->Xin_model->read_company_setting_info(1);
                                        //get email template
                                        $template = $this->Xin_model->read_email_template(6);
                                        //get employee info
                                        $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
                                        $full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

                                        $from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
                                        $to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

                                        $subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
                                        $logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

                                        $message = '
                            <div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
                            <img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

                                        hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
                                    } else if ($this->input->get('status') == 3) { // rejected
                                        $this->email->set_mailtype("html");
                                        //get leave info
                                        $timesheet = $this->Timesheet_model->read_annual_leave_information($leave_id);
                                        //get company info
                                        $cinfo = $this->Xin_model->read_company_setting_info(1);
                                        //get email template
                                        $template = $this->Xin_model->read_email_template(7);
                                        //get employee info
                                        $user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

                                        $full_name = $user_info[0]->first_name . ' ' . $user_info[0]->last_name;

                                        $from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
                                        $to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

                                        $subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
                                        $logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

                                        $message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
                                <img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
                                        hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
                                    }
                                }
                                $Return['result'] = $this->lang->line('xin_success_leave__status_updated');
                                $this->output($Return);
                                exit;
                            } else {
                                $Return['result'] = $this->lang->line('xin_success_leave__status_updated');
                                $this->output($Return);
                                exit;
                            }
                        }
            
                    }
                    else {
                        $data = array(
                            'status' =>$this->input->post('status'),
                            'cleared_status' => ($clr_d_msg != '') ? $clr_d_msg : 1,
                            'first_approval' => $first_approval,
                            'second_approval' => $second_approval,
                            'final_approval' => $final_approval,
                            'approved_by_first' => $approved_by_first,
                            'approved_by_second' => $approved_by_second,
                            'approved_by_final' => $approved_by_final,
                            'updated_date' => date('Y-m-d'),
                                 'remarks' => $qt_remarks
                            
                        );
                        //   print_r($data);
                        //                 exit();
                        $result = $this->Timesheet_model->update_annual_leave_record($data, $leave_id);
                        $Return['message'] = $this->lang->line('xin_success_leave__status_updated');
                        // $this->output($Return);
                        // exit;
                        
                        $Return = array('result' => $result , 'message' => 'Success');
                    }
                }
            }
        }
        echo json_encode($Return);

     }
    
    
    
    
}
