<?php
 /**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Assetreport extends MY_Controller
{

   /*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	public function __construct()
     {
          parent::__construct();
          //load the login model
          $this->load->model('Assetreport_model');
          $this->load->model('Company_model');
		  $this->load->model('Xin_model');
		  $this->load->model('Exin_model');
		  $this->load->model('Department_model');
		  $this->load->model('Payroll_model');
		  $this->load->model('Reports_model');
		  $this->load->model('Timesheet_model');
		  $this->load->model('Training_model');
		  $this->load->model('Trainers_model');
		  $this->load->model("Project_model");
		  $this->load->model("Roles_model");
		  $this->load->model("Employees_model");
		  $this->load->model("Designation_model");
		  $this->load->model("Misc_model");
		  $this->load->model("Location_model");
		  $this->load->library('Pdf');

     }
	 
	// reports
	public function index() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		
	}
	public function assets_issued_to_employee_page(){
	    $session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$data['title'] = "Asset Issued".' | '.$this->Xin_model->site_title();
        $data['breadcrumbs'] = "Asset Issued";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		
		if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/reports/assets_report", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
			redirect('admin/dashboard');
		}
	    
	}
	public function asset_received_from_employee_page(){
         
        $session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}

            $data['title'] = "Asset Return".' | '.$this->Xin_model->site_title();
            $data['breadcrumbs'] = "Asset Return";
            $data['all_companies'] = $this->Xin_model->get_companies();
    		$data['all_departments'] = $this->Department_model->all_departments();
    		$data['all_employees'] = $this->Xin_model->all_employees();
    		$data['all_location'] = $this->Location_model->all_office_locations();


			if(!empty($session)){
			$data['subview'] = $this->load->view("admin/reports/asset_received_from_employee_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
     }
     public function employee_document_expiry(){
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_hr_employee_document_expired').' | '.$this->Xin_model->site_title();
		$data['path_url'] = 'reports_employees';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_document_expired');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_documents'] = $this->Department_model->all_documents();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();
		if($data){
		    $data['subview'] = $this->load->view("admin/reports/employee_document_expiry", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		}
		else{
			redirect('admin/dashboard');
		}
	}
    public function assets_issued() {

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');  
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length")); 
		
        $endd_date =$_GET['end_date'];
		$department_id =$_GET['department_id'];
		$employee_id =$_GET['employee_id'];
		$location_id =$_GET['location_id'];
		$start_date =$_GET['start_date'];
		$company_id =$_GET['company'];
	
// 			var_dump($status_id);die();
		$employee_asset_report = $this->Assetreport_model->assets_issued_to_employee_query($company_id,$department_id,$employee_id,$start_date,$endd_date, $location_id);
		$data = array();

        foreach($employee_asset_report->result() as $get) {	 
            // get company
			$company = $this->Xin_model->read_company_info($get->company_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;  
			} else {
				$comp_name = '--';	    
			}
			
			// get emp id
			$emp_id = $this->Reports_model->employee_data_get($get->user_id);
			if(!is_null($emp_id)){
				$emp_id_get = $emp_id[0]->employee_id; 
			} else {
				$emp_id_get = '--';	
			}
			
			// user full name 
			$full_name = $get->first_name.' '.$get->last_name;			
			
			// get status
			if($get->is_active==0): $status = $this->lang->line('xin_employees_inactive');
			elseif($get->is_active==1): $status = $this->lang->line('xin_employees_active'); endif;
			
			// get designation
			$designation = $this->Designation_model->read_designation_information($get->designation_id);
			if(!is_null($designation)){
				$designation_name = $designation[0]->designation_name; 
			} else {
				$designation_name = '--';	
			}
			
			// department
			$department = $this->Department_model->read_department_information($get->department_id);
			if(!is_null($department)){
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';	 
			} 
			
						
			$data[] = array(
		    	$emp_id_get,
				$full_name,
				$comp_name,
				$department_name,
				$designation_name, 
				$get->date_of_joining,
				$get->asset_assigned_date,
				$get->name,
				$get->manufacturer,
				$get->company_asset_code,
				$get->serial_number
			);
      
	  }
	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $employee_asset_report->num_rows(),
			 "recordsFiltered" => $employee_asset_report->num_rows(),
			 "data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
     }
     public function asset_received_from_employee_get(){
         
        $data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');  
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length")); 
		
		$aj_company =$_GET['company_id'];
		$department_id =$_GET['department_id'];
		$employee_id =$_GET['employee_id'];
		$location_id =$_GET['location_id'];
		$start_date =$_GET['start_date'];
		$end_date =$_GET['end_date'];

		$asset_recevied_report = $this->Assetreport_model->asset_recevied_report_query($end_date,$aj_company,$department_id,$employee_id,$start_date, $location_id);
		$data = array();

        foreach($asset_recevied_report->result() as $get) {	 
            

            
            // get company
			$company = $this->Xin_model->read_company_info($get->company_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;  
			} else {
				$comp_name = '--';	    
			}
			
			// get emp id
			$emp_id = $this->Reports_model->employee_data_get($get->user_id);
			if(!is_null($emp_id)){
				$emp_id_get = $emp_id[0]->employee_id; 
			} else {
				$emp_id_get = '--';	
			}
			
			// user full name 
			$full_name = $get->first_name.' '.$get->last_name;
			
			// get status
			if($get->is_active==0): $status = $this->lang->line('xin_employees_inactive');
			elseif($get->is_active==1): $status = $this->lang->line('xin_employees_active'); endif;
			
			// get designation
			$designation = $this->Designation_model->read_designation_information($get->designation_id);
			if(!is_null($designation)){
				$designation_name = $designation[0]->designation_name; 
			} else {
				$designation_name = '--';	
			}
			
			// department
			$department = $this->Department_model->read_department_information($get->department_id);
			if(!is_null($department)){
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';	 
			}
			
			

			
						
			$data[] = array(
		    	$emp_id_get,
				$full_name,
				$department_name,
				$designation_name, 
				$get->asset_assigned_date,
				$get->handover_date,
				$get->name,
				$get->company_asset_code,
				$get->serial_number
			);
      
	  }
	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $asset_recevied_report->num_rows(),
			 "recordsFiltered" => $asset_recevied_report->num_rows(),
			 "data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
         
     }
     public function employee_document_expiry_report(){
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
        $company_id =$_GET['company_id'];
		$department_id =$_GET['aj_department'];
		$location_id =$_GET['location_id'];
		$document_id =$_GET['document_selected'];
		$from_date =$_GET['from_date'];
		$to_date =$_GET['to_date'];
		$employee_id =$_GET['employee_id'];

		$employee = $this->Assetreport_model->employee_document_expiry_report($company_id,$department_id,$location_id,$document_id,$from_date,$to_date,$employee_id);
     
		$data = array();

        foreach($employee->result() as $r) {	
          
			$company = $this->Xin_model->read_company_info($r->company_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';	
			}
			
			// user full name 
			$full_name = $r->first_name.' '.$r->last_name;	

			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if(!is_null($designation)){
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';	
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if(!is_null($department)){
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';	
			}
			$data[] = array(
			    $comp_name,
				$full_name,
				$department_name,
				$designation_name,
				$r->date_of_joining,
				$r->title,
			    $r->date_of_issue,
				$r->date_of_expiry
			);
      
	  }
	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $employee->num_rows(),
			 "recordsFiltered" => $employee->num_rows(),
			 "data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
	}
	public function get_departments() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/report_get_departments", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 } 
	 public function designation() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'department_id' => $id,
			'all_designations' => $this->Designation_model->all_designations(),
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/report_get_designations", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	  public function get_employees_depart() {
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(

			'department_id' => $id

			);
		$session = $this->session->userdata('username');

		if(!empty($session)){ 

			$this->load->view("admin/reports/get_employees_depart_new", $data);

		} else {
			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

	 }
	 public function get_location(){
        
        $data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'department_id' => $id

			);

		$session = $this->session->userdata('username');

		if(!empty($session)){ 

			$this->load->view("admin/reports/get_location", $data);

		} else {

			redirect('admin/');

		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
        
    }
     public function get_status_dropdown(){
        
        $data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'any_id' => $id

			);

		$session = $this->session->userdata('username');

		if(!empty($session)){ 

			$this->load->view("admin/reports/get_status_dropdown", $data);

		} else {

			redirect('admin/');

		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
        
    }
    public function assets_issued_to_employee_pdf()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;
      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
      
        $endd_date =$this->input->post('e_end_date');
		$department_id =$this->input->post('e_department_id');
		$employee_id =$this->input->post('e_employee_id');
		$location_id =$this->input->post('e_location_id');
		$start_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$employee_asset_report = $this->Assetreport_model->assets_issued_to_employee_query_pdf($company_id,$department_id,$employee_id,$start_date,$endd_date, $location_id);
		$employee_count = $this->Assetreport_model->assets_issued_to_employee_count($company_id,$department_id,$employee_id,$start_date,$endd_date, $location_id);
	//empty data display code start
      if(empty($employee_count)){
        $logo_empty = "<img src='".$logo."' style='width:25%;'>";
            $company_name_empty = $company_name;
            $email_phone_address_empty = $email_phone_address;
        $empty_text = 'No Data Available In PDF';
      }else{
        $logo_empty = '';
            $company_name_empty = '';
            $email_phone_address_empty = '';
        $empty_text = '';
      }
		$data = array();
		foreach($employee_count as $key => $val) {
          $company = $this->Xin_model->read_company_info($val['company_id']);
          if (!is_null($company)) 
          {
             $company_name = $company[0]->name;
             $address_1 = $company[0]->address_1;
             $address_2 = $company[0]->address_2;
             $city = $company[0]->city;
             $state = $company[0]->state;
             $company_logo = $company[0]->logo;
             $zipcode = $company[0]->zipcode;
             $country = $this->Xin_model->read_country_info($company[0]->country);
             if (!is_null($country)) {
                $country_name = $country[0]->country_name;
             } else {
                $country_name = '--';
             }
             $c_info_email = $company[0]->email;
             $c_info_phone = $company[0]->contact_number;
             if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
             } else {
                // $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
                $logo = '';
             }
          } else {
             $company_name = '';
             $address_1 = '';
             $address_2 = '';
             $city = '';
             $state = '';
             $zipcode = '';
             $country_name = '';
             $c_info_email = '';
             $c_info_phone = '';
             $logo = '';
          }
            $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

            $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
            $employee_count[$key]['header_string'] = $email_phone_address;
            $employee_count[$key]['company_name'] = $company_name;
            $employee_count[$key]['logo'] = $logo;
        }
		foreach($employee_asset_report as $key => $val) {
		    $data[$key]['date_of_joining']=$val['date_of_joining'];
		    $data[$key]['asset_assigned_date']=$val['asset_assigned_date'];
		    $data[$key]['assestname']=$val['name'];
		    $data[$key]['manufacturer']=$val['manufacturer'];
		    $data[$key]['company_asset_code']=$val['company_asset_code'];
		    $data[$key]['serial_number']=$val['serial_number'];
		    $data[$key]['user_id']=$val['user_id'];
		    $data[$key]['company_id']=$val['company_id'];
		    
		    $company = $this->Xin_model->read_company_info($val['company_id']);
			if(!is_null($company)){
				$comp_name = $company[0]->name;  
			} else {
				$comp_name = '--';	    
			}
			$data[$key]['comp_name']=$comp_name;
			$emp_id = $this->Reports_model->employee_data_get($val['user_id']);
			if(!is_null($emp_id)){
				$emp_id_get = $emp_id[0]->employee_id; 
			} else {
				$emp_id_get = '--';	
			}
			$data[$key]['empcode']=$emp_id_get;
			$full_name =$val['first_name'].' '.$val['last_name'];	
			$data[$key]['empname']=$full_name;
			
			if($val['is_active']==0): $status = $this->lang->line('xin_employees_inactive');
			elseif($val['is_active']==1): $status = $this->lang->line('xin_employees_active'); endif;
			$designation = $this->Designation_model->read_designation_information($val['designation_id']);
			if(!is_null($designation)){
				$designation_name = $designation[0]->designation_name; 
			} else {
				$designation_name = '--';	
			}
			$data[$key]['designation_name']=$designation_name;
			$department = $this->Department_model->read_department_information($val['department_id']);
			if(!is_null($department)){
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';	 
			} 
			$data[$key]['department_name']=$department_name;
		}
      
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
    	$res['employee_count']=$employee_count;
	    $res['lists'] = $data;
	    $res['empty_text'] = $empty_text;
        $res['header_string'] = $email_phone_address_empty;
        $res['company_name'] = $company_name_empty;
        $res['logo_empty'] = $logo_empty;
        $res['start_date'] = $start_date;
        $res['end_date'] = $endd_date;
    	$html = $this->load->view("admin/reports/assets_issued_to_employee_pdf_format", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('assets_issued.pdf','D');// 
   }
   public function asset_received_from_employee_pdf()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;
      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
      
        $endd_date =$this->input->post('e_end_date');
		$department_id =$this->input->post('e_department_id');
		$employee_id =$this->input->post('e_employee_id');
		$start_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$location_id =$this->input->post('e_location_id');
		
		$employee_asset_report = $this->Assetreport_model->asset_recevied_report_query_pdf($endd_date,$company_id,$department_id,$employee_id,$start_date, $location_id);
		$employee_count = $this->Assetreport_model->assets_received_from_employee_count($endd_date,$company_id,$department_id,$employee_id,$start_date, $location_id);
		$data = array();
// 			$employee_count = $this->Assetreport_model->assets_issued_to_employee_count($company_id,$department_id,$employee_id,$start_date,$endd_date,$status_id);
    	//empty data display code start
          if(empty($employee_count)){
            $logo_empty = "<img src='".$logo."' style='width:25%;'>";
                $company_name_empty = $company_name;
                $email_phone_address_empty = $email_phone_address;
            $empty_text = 'No Data Available In PDF';
          }else{
            $logo_empty = '';
                $company_name_empty = '';
                $email_phone_address_empty = '';
            $empty_text = '';
          }
          //////////////////////////////
		foreach($employee_count as $key => $val) {
          $company = $this->Xin_model->read_company_info($val['company_id']);
          if (!is_null($company)) 
          {
             $company_name = $company[0]->name;
             $address_1 = $company[0]->address_1;
             $address_2 = $company[0]->address_2;
             $city = $company[0]->city;
             $state = $company[0]->state;
             $company_logo = $company[0]->logo;
             $zipcode = $company[0]->zipcode;
             $country = $this->Xin_model->read_country_info($company[0]->country);
             if (!is_null($country)) {
                $country_name = $country[0]->country_name;
             } else {
                $country_name = '--';
             }
             $c_info_email = $company[0]->email;
             $c_info_phone = $company[0]->contact_number;
             if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
             } else {
                // $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
                $logo = '';
             }
          } else {
             $company_name = '';
             $address_1 = '';
             $address_2 = '';
             $city = '';
             $state = '';
             $zipcode = '';
             $country_name = '';
             $c_info_email = '';
             $c_info_phone = '';
             $logo = '';
          }
            $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

            $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
            $employee_count[$key]['header_string'] = $email_phone_address;
            $employee_count[$key]['company_name'] = $company_name;
            $employee_count[$key]['logo'] = $logo;
        }
		foreach($employee_asset_report as $key => $val) {
		    $company = $this->Xin_model->read_company_info($val['company_id']);
			if(!is_null($company)){
				$comp_name = $company[0]->name;  
			} else {
				$comp_name = '--';	    
			}
			$emp_id = $this->Reports_model->employee_data_get($val['user_id']);
			if(!is_null($emp_id)){
				$emp_id_get = $emp_id[0]->employee_id; 
			} else {
				$emp_id_get = '--';	
			}
			$full_name = $val['first_name'].' '.$val['last_name'];
			if($val['is_active']==0): $status = $this->lang->line('xin_employees_inactive');
			elseif($val['is_active']==1): $status = $this->lang->line('xin_employees_active'); endif;
			
			$designation = $this->Designation_model->read_designation_information($val['designation_id']);
			if(!is_null($designation)){
				$designation_name = $designation[0]->designation_name; 
			} else {
				$designation_name = '--';	
			}
			$department = $this->Department_model->read_department_information($val['department_id']);
			if(!is_null($department)){
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';	 
			}
			
			$data[$key]['comp_name']=$comp_name;
			$data[$key]['emp_code']=$val['employee_id'];
			$data[$key]['full_name']=$full_name;
			$data[$key]['designation_name']=$designation_name;
			$data[$key]['department_name']=$department_name;
		
		    $data[$key]['asset_assigned_date']=$val['asset_assigned_date'];
		    $data[$key]['name']=$val['name'];
		    $data[$key]['company_asset_code']=$val['company_asset_code'];
		    $data[$key]['serial_number']=$val['serial_number'];
		    $data[$key]['user_id']=$val['user_id'];
		    $data[$key]['company_id']=$val['company_id'];
		    
		}
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
	    $res['empty_text'] = $empty_text;
        $res['header_string'] = $email_phone_address_empty;
        $res['company_name'] = $company_name_empty;
        $res['logo_empty'] = $logo_empty;
        $res['employee_count']=$employee_count;
        $res['start_date']=$start_date;
        $res['end_date']=$endd_date;
    	$html = $this->load->view("admin/reports/asset_received_from_employee_pdf_format", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('asset_received.pdf','D');// 
   }
    public function employee_document_expiry_pdf() {
       
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      $user = $this->Xin_model->read_user_info($session['user_id']);
      $user_id = $user[0]->user_id;
      $system = $this->Xin_model->read_setting_info(1);

      $to_date = $this->input->post('e_end_date');
      $department_id = $this->input->post('e_department_id');
      $from_date = $this->input->post('e_start_date');
      $document_id = $this->input->post('e_document');
      $location_id = $this->input->post('e_location');
      $company_id = $this->input->post('e_company');
      $employee_id = $this->input->post('e_employee_id');
      $employee = $this->Assetreport_model->employee_document_expiry_report($company_id,$department_id,$location_id,$document_id,$from_date,$to_date,$employee_id);


      $company = $this->Xin_model->read_company_info($user[0]->company_id);
      $p_method = '';
      if (!is_null($company)) {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;

    //------------------------------------------
         
         if($company_id == 0){

	        if ($company_logo) {
	            $logo = '../../../../../uploads/company/' . $company_logo;
	        } else {
	            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
	        }

         }else{

         	$company_wise_data = $this->Xin_model->company_wise_data_get($company_id);
         	$company_wise_data_get = $company_wise_data[0]->logo;
         	$company_name = $company_wise_data[0]->name;
         	$address_1 = $company_wise_data[0]->address_1;
            $address_2 = $company_wise_data[0]->address_2;
            $city = $company_wise_data[0]->city;
            $zipcode = $company_wise_data[0]->zipcode;
            $c_info_phone = $company_wise_data[0]->contact_number;
            $c_info_email = $company_wise_data[0]->email;

         	if ($company_wise_data_get) {
            	$logo = '../../../../../uploads/company/' . $company_wise_data_get;
	        } else {
	            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
	        }

         }
         
    //--------------------------------------

      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }

      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


      $data = array();

        foreach($employee->result() as $r) { 
          
         $company = $this->Xin_model->read_company_info($r->company_id);
         if(!is_null($company)){
            $comp_name = $company[0]->name;
         } else {
            $comp_name = '--';   
         }
         
         // user full name 
         $full_name = $r->first_name.' '.$r->last_name;  

         // get designation
         $designation = $this->Designation_model->read_designation_information($r->designation_id);
         if(!is_null($designation)){
            $designation_name = $designation[0]->designation_name;
         } else {
            $designation_name = '--';  
         }
         // department
         $department = $this->Department_model->read_department_information($r->department_id);
         if(!is_null($department)){
            $department_name = $department[0]->department_name;
         } else {
            $department_name = '--';   
         }
         $data[] = array(
            'comp_name' => $comp_name,
            'full_name' => $full_name,
            'department_name' => $department_name,
            'designation_name' => $designation_name,
            'date_of_joining' => $r->date_of_joining,
            'title' => $r->title,
            'date_of_issue' => $r->date_of_issue,
            'date_of_expiry' => $r->date_of_expiry
         );
      
     }



     $this->load->library('M_pdf');
      $mpdf = $this->m_pdf->load([
         'mode' => 'utf-8',
         'format' => 'A4'
      ]);
      $res['lists'] = $data;
      $res['start_date'] = $from_date;
      $res['end_date'] = $to_date;
      $res['header_string'] = $email_phone_address;
      $res['company_name'] = $company_name;
      $res['logo'] = $logo;
      $html = $this->load->view("admin/reports/employee_expired_documents_pdf_format", $res, true);
      $mpdf->WriteHTML($html);
      $mpdf->Output('employee_expired_documents.pdf', 'D'); 


    }
   ///////////////////////////////advance///////////////////////
  public function advance_loan_report(){
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = 'Employee Advance Report';
		$data['path_url'] = 'reports_employees';
		$data['breadcrumbs'] = 'Employee Advance Report';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if($data){
		    $data['subview'] = $this->load->view("admin/reports/employee_advance_loan", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		}
		else{
			redirect('admin/dashboard');
		}
	}
	public function employee_loan_salary()
   {
      $session = $this->session->userdata('username');
      if (empty($session)) {
         redirect('admin/');
      }
      $data['title'] = ' Loan Outstanding Summery ' . ' | ' . $this->Xin_model->site_title();
      $data['path_url'] = 'employee losn report';
      $data['breadcrumbs'] = ' Loan Outstanding Summery ';
      $data['all_companies'] = $this->Xin_model->get_companies();
      $data['all_employees'] = $this->Xin_model->all_employees();
      //$data['all_departments'] = $this->Department_model->all_departments();
      $data['all_locations'] = $this->Xin_model->all_locations();
      //print_r($data);
      if ($data) {
         $data['subview'] = $this->load->view("admin/reports/employee_loan", $data, TRUE);
         $this->load->view('admin/layout/layout_main', $data); //page load
      } else {
         redirect('admin/dashboard');
      }
   }
	public function employee_advance_loan_outstanding_details(){
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_employee_advance_loan_outstanding_details').' | '.$this->Xin_model->site_title();
		$data['path_url'] = 'Advance Loan Outstanding Report';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_loan_outstanding_details');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if($data){
		    $data['subview'] = $this->load->view("admin/reports/employee_advance_loan_outstanding_details", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		}
		else{
			redirect('admin/dashboard');
		}
	}
	public function loan_report() {
        $session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = "Loan Report".' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = "Loan Report";
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_time'] = $this->Timesheet_model->get_timetable();
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('28',$role_resources_ids)) {
			if(!empty($session)){
			$data['subview'] = $this->load->view("admin/reports/loan_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}	
		} else {
			redirect('admin/dashboard');
		}	  
	
	}

	public function employee_advance_loan_report(){
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$company_id =$_GET['company_id'];
		$location_id =$_GET['location_id'];
		$department_id =$_GET['aj_department'];
		$employee_id =$_GET['employee_id'];
		$from_date =$_GET['from_date'];
		$to_date =$_GET['to_date'];
		
		
		if ($from_date!=0 || $to_date!=0) {
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
		}
		
		$employee = $this->Assetreport_model->employee_advance_loan_report($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		$data = array();
        foreach($employee as $key => $val) {
			$company = $this->Xin_model->read_company_info($val['company_id']);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';	
			}
			$full_name = $val['first_name'].' '.$val['last_name'];	
			$adjusted_amount = 0.00;
			$total_deduct_amount=$val['total_paidd'];
			$closing_balance = round($val['advance_amount'] - $total_deduct_amount,3);
			$data[] = array(
				$val['employee_id'],
				$full_name,
				$val['created_at'],
				$val['advance_type'],
				$val['advance_amount'],
				$val['monthly_installment'],
				$total_deduct_amount,
				// $adjusted_amount = 0.00,
				$closing_balance
			);
	  }
	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => count($employee),
			 "recordsFiltered" => count($employee),
			 "data" => $data
		);
	  $output['csrf_hash'] = $this->security->get_csrf_hash();
	  echo json_encode($output);
	  exit();
	}
	public function employee_advance_loan_pdf()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        $to_date =$this->input->post('e_end_date');
		$location_id =$this->input->post('e_location_id');
		$employee_id =$this->input->post('e_employee_id');
		$from_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$department_id =$this->input->post('e_department_id');
		
		$employee = $this->Assetreport_model->employee_advance_loan_report($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		$company_count = $this->Assetreport_model->employee_advance_loan_company_count($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		$data = array();
	  $company = $this->Xin_model->read_company_info($user[0]->company_id);
	  $system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
      //empty data display code start
          if(empty($company_count)){
            $logo_empty = "<img src='".$logo."' style='width:25%;'>";
                $company_name_empty = $company_name;
                $email_phone_address_empty = $email_phone_address;
            $empty_text = 'No Data Available In PDF';
          }else{
            $logo_empty = '';
                $company_name_empty = '';
                $email_phone_address_empty = '';
            $empty_text = '';
          }
          ////////////////////
        foreach($company_count as $key => $val) {
              $company = $this->Xin_model->read_company_info($val['company_id']);
              if (!is_null($company)) 
              {
                 $company_name = $company[0]->name;
                 $address_1 = $company[0]->address_1;
                 $address_2 = $company[0]->address_2;
                 $city = $company[0]->city;
                 $state = $company[0]->state;
                 $company_logo = $company[0]->logo;
                 $zipcode = $company[0]->zipcode;
                 $country = $this->Xin_model->read_country_info($company[0]->country);
                 if (!is_null($country)) {
                    $country_name = $country[0]->country_name;
                 } else {
                    $country_name = '--';
                 }
                 $c_info_email = $company[0]->email;
                 $c_info_phone = $company[0]->contact_number;
                 if ($company_logo) {
                    $logo = '../../../../../uploads/company/' . $company_logo;
                 } else {
                    $logo = '';
                 }
              } else {
                 $company_name = '';
                 $address_1 = '';
                 $address_2 = '';
                 $city = '';
                 $state = '';
                 $zipcode = '';
                 $country_name = '';
                 $c_info_email = '';
                 $c_info_phone = '';
                 $logo = '';
              }
                $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

                $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
                $company_count[$key]['header_string'] = $email_phone_address;
                $company_count[$key]['company_name'] = $company_name;
                $company_count[$key]['logo'] = $logo;
                $company_count[$key]['from_date'] = $from_date;
                $company_count[$key]['to_date'] = $to_date;
        }
		foreach($employee as $key => $val) {
		   	$company = $this->Xin_model->read_company_info($val['company_id']);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';	
			}
			$full_name = $val['first_name'].' '.$val['last_name'];	
			$adjusted_amount = 0.00;
			$total_deduct_amount=$val['total_paidd'];
			$closing_balance = round($val['advance_amount'] - $total_deduct_amount,3);
			$data[$key]['employee_id']=$val['employee_id'];
			$data[$key]['user_id']=$val['user_id'];
			$data[$key]['company_id']=$val['company_id'];
			$data[$key]['full_name']=$full_name;
			$data[$key]['created_at']=$val['created_at'];
			$data[$key]['advance_type']=$val['advance_type'];
			$data[$key]['advance_amount']=$val['advance_amount'];
			$data[$key]['monthly_installment']=$val['monthly_installment'];
			$data[$key]['total_deduct_amount']=$total_deduct_amount;
			$data[$key]['adjusted_amount']=0;
			$data[$key]['closing_balance']=$closing_balance;
		}  
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
        $res['company_count']=$company_count;
        $res['empty_text'] = $empty_text;
        $res['header_string'] = $email_phone_address_empty;
        $res['company_name'] = $company_name_empty;
        $res['logo_empty'] = $logo_empty;
    	$html = $this->load->view("admin/reports/employee_advance_pdf_format", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('employee_advance.pdf','D');// 
   }
   public function employee_loan_report()
   {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/employees", $data);
      } else {
         redirect('admin/');
      }

      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
      
        $company_id =$_GET['company_id'];
        $location_id =$_GET['location_id'];
        $department_id =$_GET['aj_department'];
        $employee_id =$_GET['employee_id'];
        $from_date =$_GET['from_date'];
        $to_date =$_GET['to_date'];
      

      //change date format from dd-mm-yyyy to yyyy-mm-dd
      if ($from_date != 0 || $to_date != 0) {
         # code...
         $from_date = date("Y-m-d", strtotime($from_date));
         $to_date = date("Y-m-d", strtotime($to_date));
      }
      $employee = $this->Assetreport_model->employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
      $data = array();
      if(!empty($employee))
      {
    	  foreach($employee as $key => $val) {
	      if($val['loan_deduction_id']!=NULL)
	      {
    	     $company = $this->Xin_model->read_company_info($val['company_id']);
             if (!is_null($company)) {
                $comp_name = $company[0]->name;
             } else {
                $comp_name = '--';
             }
             $total_deduct_amount=round($this->Assetreport_model->employee_loan_total_deduct($val['loan_deduction_id'],$from_date,$to_date),3);
             $closing_balance = round($val['Total_loan_amount'] - $total_deduct_amount,2);
             $full_name = $val['first_name'] . ' ' . $val['last_name'];
             if ($val['status'] == 0) : $status = 'pending';
             elseif ($val['status'] == 1) : $status = 'approved';
             elseif ($val['status'] == 2) : $status = 'rejected';
             endif;
             if ($val['loan_options'] == 2)
             {
                $loan_type='Personal Loan';
             }else{
                $loan_type='Other Loan';
             }
             $adjusted_amount = 0.00;
             $data[] = array(
                $val['employee_id'],
                $full_name,
                $val['start_date'],
                $loan_type,
                $val['Total_loan_amount'],
                $val['loan_deduction_amount'],
                $total_deduct_amount,
                // $adjusted_amount,
                $closing_balance
             );
    	  }
        }
      }
      $output = array(
         "draw" => $draw,
         "recordsTotal" => count($employee),
         "recordsFiltered" => count($employee),
         "data" => $data
      );
      $output['csrf_hash'] = $this->security->get_csrf_hash();
      echo json_encode($output);
      exit();
   }
   public function employee_loan_pdf()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        $to_date =$this->input->post('e_end_date');
		$location_id =$this->input->post('e_location_id');
		$employee_id =$this->input->post('e_employee_id');
		$from_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$department_id =$this->input->post('e_department_id');
		
		if ($from_date != 0 || $to_date != 0) {
         # code...
         $from_date = date("Y-m-d", strtotime($from_date));
         $to_date = date("Y-m-d", strtotime($to_date));
        }
        $company = $this->Xin_model->read_company_info($user[0]->company_id);
        $system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
        $employee = $this->Assetreport_model->employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
		$company_count = $this->Assetreport_model->employee_loan_company_count($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
		$data = array();
		//empty data display code start
      if(empty($company_count)){
        $logo_empty = "<img src='".$logo."' style='width:25%;'>";
            $company_name_empty = $company_name;
            $email_phone_address_empty = $email_phone_address;
        $empty_text = 'No Data Available In PDF';
      }else{
        $logo_empty = '';
            $company_name_empty = '';
            $email_phone_address_empty = '';
        $empty_text = '';
      }
      //empty data display code end
        foreach($company_count as $key => $val) {
              $company = $this->Xin_model->read_company_info($val['company_id']);
              if (!is_null($company)) 
              {
                 $company_name = $company[0]->name;
                 $address_1 = $company[0]->address_1;
                 $address_2 = $company[0]->address_2;
                 $city = $company[0]->city;
                 $state = $company[0]->state;
                 $company_logo = $company[0]->logo;
                 $zipcode = $company[0]->zipcode;
                 $country = $this->Xin_model->read_country_info($company[0]->country);
                 if (!is_null($country)) {
                    $country_name = $country[0]->country_name;
                 } else {
                    $country_name = '--';
                 }
                 $c_info_email = $company[0]->email;
                 $c_info_phone = $company[0]->contact_number;
                 if ($company_logo) {
                    $logo = '../../../../../uploads/company/' . $company_logo;
                 } else {
                    $logo = '';
                 }
              } else {
                 $company_name = '';
                 $address_1 = '';
                 $address_2 = '';
                 $city = '';
                 $state = '';
                 $zipcode = '';
                 $country_name = '';
                 $c_info_email = '';
                 $c_info_phone = '';
                 $logo = '';
              }
                $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

                $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
                $company_count[$key]['header_string'] = $email_phone_address;
                $company_count[$key]['company_name'] = $company_name;
                $company_count[$key]['logo'] = $logo;
                $company_count[$key]['from_date'] = $from_date;
                $company_count[$key]['to_date'] = $to_date;
        }
		foreach($employee as $key => $val) {
		   if($val['loan_deduction_id']!=NULL)
	      {
    		   	$company = $this->Xin_model->read_company_info($val['company_id']);
    			if(!is_null($company)){
    				$comp_name = $company[0]->name;
    			} else {
    				$comp_name = '--';	
    			}
    			if ($val['loan_options'] == 2)
                {
                    $loan_type='Personal Loan';
                }else{
                    $loan_type='Other Loan';
                }
    			$total_deduct_amount=round($this->Assetreport_model->employee_loan_total_deduct($val['loan_deduction_id'],$from_date,$to_date),3);
                $closing_balance = round($val['Total_loan_amount'] - $total_deduct_amount,2);
    			$full_name = $val['first_name'].' '.$val['last_name'];	
    			$adjusted_amount = 0.00;
    			$data[$key]['employee_id']=$val['employee_id'];
    			$data[$key]['user_id']=$val['user_id'];
    			$data[$key]['company_id']=$val['company_id'];
    			$data[$key]['full_name']=$full_name;
    			$data[$key]['start_date']=$val['start_date'];
    			$data[$key]['loan_type']=$loan_type;
    			$data[$key]['loan_amount']=$val['Total_loan_amount'];
    			$data[$key]['monthly_installments']=$val['loan_deduction_amount'];
    			$data[$key]['total_deduct_amount']=$total_deduct_amount;
    			$data[$key]['adjusted_amount']=0;
    			$data[$key]['closing_balance']=$closing_balance;
	      }
		}  
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
        $res['company_count']=$company_count;
       $res['empty_text'] = $empty_text;
      $res['header_string'] = $email_phone_address_empty;
      $res['company_name'] = $company_name_empty;
      $res['logo_empty'] = $logo_empty;
    	$html = $this->load->view("admin/reports/employee_loan_pdf_format", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('employee_loan.pdf','D');// 
   }
   ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   public function employee_advance_loan_outstanding_detailsss()
   {
      $session = $this->session->userdata('username');
      if (empty($session)) {
         redirect('admin/');
      }
      $data['title'] = ' Advance Outstanding Details ' . ' | ' . $this->Xin_model->site_title();
      $data['path_url'] = 'Advance Loan Outstanding Report';
      $data['breadcrumbs'] = ' Advance Outstanding Details ';
      $data['all_companies'] = $this->Xin_model->get_companies();
      $data['all_employees'] = $this->Xin_model->all_employees();
      //$data['all_departments'] = $this->Department_model->all_departments();
      $data['all_locations'] = $this->Xin_model->all_locations();
      //print_r($data);
      if ($data) {
         $data['subview'] = $this->load->view("admin/reports/employee_advance_loan_outstanding_details", $data, TRUE);
         $this->load->view('admin/layout/layout_main', $data); //page load
      } else {
         redirect('admin/dashboard');
      }
   }
   public function employee_advance_details_pdf()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        $to_date =$this->input->post('e_end_date');
		$location_id =$this->input->post('e_location_id');
		$employee_id =$this->input->post('e_employee_id');
		$from_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$department_id =$this->input->post('e_department_id');
		
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
		$employee = $this->Assetreport_model->employee_advance_details_report($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		$company_count = $this->Assetreport_model->employee_advance_loan_company_count($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		//empty data display code start
          if(empty($company_count)){
            $logo_empty = "<img src='".$logo."' style='width:25%;'>";
                $company_name_empty = $company_name;
                $email_phone_address_empty = $email_phone_address;
            $empty_text = 'No Data Available In PDF';
          }else{
            $logo_empty = '';
                $company_name_empty = '';
                $email_phone_address_empty = '';
            $empty_text = '';
          }
      //empty data display code end

		$data = array();
        foreach($company_count as $key => $val) {
              $company = $this->Xin_model->read_company_info($val['company_id']);
              if (!is_null($company)) 
              {
                 $company_name = $company[0]->name;
                 $address_1 = $company[0]->address_1;
                 $address_2 = $company[0]->address_2;
                 $city = $company[0]->city;
                 $state = $company[0]->state;
                 $company_logo = $company[0]->logo;
                 $zipcode = $company[0]->zipcode;
                 $country = $this->Xin_model->read_country_info($company[0]->country);
                 if (!is_null($country)) {
                    $country_name = $country[0]->country_name;
                 } else {
                    $country_name = '--';
                 }
                 $c_info_email = $company[0]->email;
                 $c_info_phone = $company[0]->contact_number;
                 if ($company_logo) {
                    $logo = '../../../../../uploads/company/' . $company_logo;
                 } else {
                    $logo = '';
                 }
              } else {
                 $company_name = '';
                 $address_1 = '';
                 $address_2 = '';
                 $city = '';
                 $state = '';
                 $zipcode = '';
                 $country_name = '';
                 $c_info_email = '';
                 $c_info_phone = '';
                 $logo = '';
              }
                $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
                $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
                $company_count[$key]['header_string'] = $email_phone_address;
                $company_count[$key]['company_name'] = $company_name;
                $company_count[$key]['logo'] = $logo;
                $company_count[$key]['from_date'] = $from_date;
                $company_count[$key]['to_date'] = $to_date;
        }
		foreach($employee as $key => $val) {
		   	$company = $this->Xin_model->read_company_info($val['company_id']);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';	
			}
			$full_name = $val['first_name'].' '.$val['last_name'];	
			$adjusted_amount = 0.00;
			$total_deduct_amount=$val['total_paid'];
			$closing_balance = $val['advance_amount'] - $total_deduct_amount;
			$data[$key]['employee_id']=$val['employee_id'];
			$data[$key]['user_id']=$val['user_id'];
			$data[$key]['company_id']=$val['company_id'];
			$data[$key]['full_name']=$full_name;
			$data[$key]['created_at']=$val['created_at'];
			$data[$key]['advance_type']=$val['advance_type'];
			$data[$key]['advance_amount']=$val['advance_amount'];
			$data[$key]['monthly_installment']=$val['monthly_installment'];
			$data[$key]['total_deduct_amount']=$total_deduct_amount;
			$data[$key]['adjusted_amount']=0;
			$data[$key]['closing_balance']=$closing_balance;
			$data[$key]['list']=$val['list'];
		}  
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
        $res['company_count']=$company_count;
       $res['empty_text'] = $empty_text;
      $res['header_string'] = $email_phone_address_empty;
      $res['company_name'] = $company_name_empty;
      $res['logo_empty'] = $logo_empty;
    	$html = $this->load->view("admin/reports/employee_advance_details_pdf_format", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('employee_advance_details.pdf','D');// 
   }
   public function employee_loan_outstanding_detailsss()
   {
      $session = $this->session->userdata('username');
      if (empty($session)) {
         redirect('admin/');
      }
      $data['title'] = ' Loan Outstanding Details ' . ' | ' . $this->Xin_model->site_title();
      $data['path_url'] = 'employee losn report';
      $data['breadcrumbs'] = ' Loan Outstanding Details ';
      $data['all_companies'] = $this->Xin_model->get_companies();
      $data['all_employees'] = $this->Xin_model->all_employees();
      $data['all_locations'] = $this->Xin_model->all_locations();
      //print_r($data);
      if ($data) {
         $data['subview'] = $this->load->view("admin/reports/employee_loan_details", $data, TRUE);
         $this->load->view('admin/layout/layout_main', $data); //page load
      } else {
         redirect('admin/dashboard');
      }
   }
   public function employee_loan_details_pdf()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        $to_date =$this->input->post('e_end_date');
		$location_id =$this->input->post('e_location_id');
		$employee_id =$this->input->post('e_employee_id');
		$from_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$department_id =$this->input->post('e_department_id');
		
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
		$employee = $this->Assetreport_model->employee_loan_details_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
	
		$company_count = $this->Assetreport_model->employee_loan_company_count($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
			//empty data display code start
          if(empty($company_count)){
            $logo_empty = "<img src='".$logo."' style='width:25%;'>";
                $company_name_empty = $company_name;
                $email_phone_address_empty = $email_phone_address;
            $empty_text = 'No Data Available In PDF';
          }else{
            $logo_empty = '';
                $company_name_empty = '';
                $email_phone_address_empty = '';
            $empty_text = '';
          }
      //empty data display code end
		$data = array();
        foreach($company_count as $key => $val) {
              $company = $this->Xin_model->read_company_info($val['company_id']);
              if (!is_null($company)) 
              {
                 $company_name = $company[0]->name;
                 $address_1 = $company[0]->address_1;
                 $address_2 = $company[0]->address_2;
                 $city = $company[0]->city;
                 $state = $company[0]->state;
                 $company_logo = $company[0]->logo;
                 $zipcode = $company[0]->zipcode;
                 $country = $this->Xin_model->read_country_info($company[0]->country);
                 if (!is_null($country)) {
                    $country_name = $country[0]->country_name;
                 } else {
                    $country_name = '--';
                 }
                 $c_info_email = $company[0]->email;
                 $c_info_phone = $company[0]->contact_number;
                 if ($company_logo) {
                    $logo = '../../../../../uploads/company/' . $company_logo;
                 } else {
                    $logo = '';
                 }
              } else {
                 $company_name = '';
                 $address_1 = '';
                 $address_2 = '';
                 $city = '';
                 $state = '';
                 $zipcode = '';
                 $country_name = '';
                 $c_info_email = '';
                 $c_info_phone = '';
                 $logo = '';
              }
                $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
                $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
                $company_count[$key]['header_string'] = $email_phone_address;
                $company_count[$key]['company_name'] = $company_name;
                $company_count[$key]['logo'] = $logo;
                $company_count[$key]['from_date'] = $from_date;
                $company_count[$key]['to_date'] = $to_date;
        }
		foreach($employee as $key => $val) {
		   	$company = $this->Xin_model->read_company_info($val['company_id']);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';	
			}
			if ($val['loan_options'] == 2)
            {
                $loan_type='Personal Loan';
            }else{
                $loan_type='Other Loan';
            }
			$full_name = $val['first_name'].' '.$val['last_name'];	
			$adjusted_amount = 0.00;
			$data[$key]['employee_id']=$val['employee_id'];
			$data[$key]['user_id']=$val['user_id'];
			$data[$key]['company_id']=$val['company_id'];
			$data[$key]['full_name']=$full_name;
			$data[$key]['created_at']=$val['start_date'];
			$data[$key]['advance_type']=$loan_type;
			$data[$key]['advance_amount']=$val['Total_loan_amount'];
			$data[$key]['monthly_installment']=$val['loan_deduction_amount'];
			$data[$key]['adjusted_amount']=0;
			$data[$key]['list']=$val['list'];
		}  
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
        $res['company_count']=$company_count;
       $res['empty_text'] = $empty_text;
      $res['header_string'] = $email_phone_address_empty;
      $res['company_name'] = $company_name_empty;
      $res['logo_empty'] = $logo_empty;
    	$html = $this->load->view("admin/reports/employee_loan_details_pdf_format", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('employee_loan_details.pdf','D');// 
   }
   public function employee_advance_loan_register()
   {
      $session = $this->session->userdata('username');
      if (empty($session)) {
         redirect('admin/');
      }
      $data['title'] = 'Advance Register Report' . ' | ' . $this->Xin_model->site_title();
      $data['path_url'] = 'Advance Register Report';
      $data['breadcrumbs'] = 'Advance Register Report';
      $data['all_companies'] = $this->Xin_model->get_companies();
      $data['all_employees'] = $this->Xin_model->all_employees();
      //$data['all_departments'] = $this->Department_model->all_departments();
      $data['all_locations'] = $this->Xin_model->all_locations();
      //print_r($data);
      if ($data) {
         $data['subview'] = $this->load->view("admin/reports/employee_advance_loan_register", $data, TRUE);
         $this->load->view('admin/layout/layout_main', $data); //page load
      } else {
         redirect('admin/dashboard');
      }
   }
   public function employee_advance_loan_register_report()
   {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/employees", $data);
      } else {
         redirect('admin/');
      }
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
      
        $company_id =$_GET['company_id'];
        $location_id =$_GET['location_id'];
        $department_id =$_GET['aj_department'];
        $employee_id =$_GET['employee_id'];
        $from_date =$_GET['from_date'];
        $to_date =$_GET['to_date'];
      
      //change date format from dd-mm-yyyy to yyyy-mm-dd
      if ($from_date != 0 || $to_date != 0) {
         # code...
         $from_date = date("Y-m-d", strtotime($from_date));
         $to_date = date("Y-m-d", strtotime($to_date));
      }
      //change date format from dd-mm-yyyy to yyyy-mm-dd
      $employee = $this->Assetreport_model->employee_advance_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
      $data = array();
      foreach ($employee as $key => $val) {
         $company = $this->Xin_model->read_company_info($val['company_id']);
         if (!is_null($company)) {
            $comp_name = $company[0]->name;
         } else {
            $comp_name = '--';
         }
         $full_name = $val['first_name'] . ' ' . $val['last_name'];
         $data[] = array(
            $val['employee_id'],
            $full_name,
            $val['created_at'],
            $val['advance_type'],
            $val['advance_amount'],
            $val['number_of_installment'],
            $val['month_year'],
            $val['monthly_installment']
         );
      }
      $output = array(
         "draw" => $draw,
         "recordsTotal" => count($employee),
         "recordsFiltered" => count($employee),
         "data" => $data
      );
      $output['csrf_hash'] = $this->security->get_csrf_hash();
      echo json_encode($output);
      exit();
   }
   public function employee_advance_loan_register_report_pdf()
   {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        $to_date =$this->input->post('e_end_date');
		$location_id =$this->input->post('e_location_id');
		$employee_id =$this->input->post('e_employee_id');
		$from_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$department_id =$this->input->post('e_department_id');
		
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
		$employee = $this->Assetreport_model->employee_advance_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
		$company_count = $this->Assetreport_model->employee_advance_loan_register_company_count($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		//empty data display code start
      if(empty($company_count)){
        $logo_empty = "<img src='".$logo."' style='width:25%;'>";
            $company_name_empty = $company_name;
            $email_phone_address_empty = $email_phone_address;
        $empty_text = 'No Data Available In PDF';
      }else{
        $logo_empty = '';
            $company_name_empty = '';
            $email_phone_address_empty = '';
        $empty_text = '';
      }
      //empty data display code end

		$data = array();
        foreach($company_count as $key => $val) {
              $company = $this->Xin_model->read_company_info($val['company_id']);
              if (!is_null($company)) 
              {
                 $company_name = $company[0]->name;
                 $address_1 = $company[0]->address_1;
                 $address_2 = $company[0]->address_2;
                 $city = $company[0]->city;
                 $state = $company[0]->state;
                 $company_logo = $company[0]->logo;
                 $zipcode = $company[0]->zipcode;
                 $country = $this->Xin_model->read_country_info($company[0]->country);
                 if (!is_null($country)) {
                    $country_name = $country[0]->country_name;
                 } else {
                    $country_name = '--';
                 }
                 $c_info_email = $company[0]->email;
                 $c_info_phone = $company[0]->contact_number;
                 if ($company_logo) {
                    $logo = '../../../../../uploads/company/' . $company_logo;
                 } else {
                    $logo = '';
                 }
              } else {
                 $company_name = '';
                 $address_1 = '';
                 $address_2 = '';
                 $city = '';
                 $state = '';
                 $zipcode = '';
                 $country_name = '';
                 $c_info_email = '';
                 $c_info_phone = '';
                 $logo = '';
              }
                $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
                $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
                $company_count[$key]['header_string'] = $email_phone_address;
                $company_count[$key]['company_name'] = $company_name;
                $company_count[$key]['logo'] = $logo;
                $company_count[$key]['from_date'] = $from_date;
                $company_count[$key]['to_date'] = $to_date;
        }
		foreach($employee as $key => $val) {
			$full_name = $val['first_name'].' '.$val['last_name'];	
			$data[$key]['employee_id']=$val['employee_id'];
			$data[$key]['user_id']=$val['user_id'];
			$data[$key]['company_id']=$val['company_id'];
			$data[$key]['full_name']=$full_name;
			$data[$key]['created_at']=$val['created_at'];
			$data[$key]['advance_type']=$val['advance_type'];
			$data[$key]['advance_amount']=$val['advance_amount'];
			$data[$key]['monthly_installment']=$val['monthly_installment'];
			$data[$key]['month_year']=$val['month_year'];
			$data[$key]['number_of_installment']=$val['number_of_installment'];
			$data[$key]['list']=$val['list'];
		}  
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
        $res['company_count']=$company_count;
       $res['empty_text'] = $empty_text;
      $res['header_string'] = $email_phone_address_empty;
      $res['company_name'] = $company_name_empty;
      $res['logo_empty'] = $logo_empty;
    	$html = $this->load->view("admin/reports/employee_advance_loan_register_report_pdf", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('employee_advance_register_details.pdf','D');// 
    }
    public function loan_register_report()
   {
      $session = $this->session->userdata('username');
      if (empty($session)) {
         redirect('admin/');
      }
      $data['title'] = 'Loan Register Report' . ' | ' . $this->Xin_model->site_title();
      $data['path_url'] = 'Loan Register Report';
      $data['breadcrumbs'] = 'Loan Register Report';
      $data['all_companies'] = $this->Xin_model->get_companies();
      $data['all_employees'] = $this->Xin_model->all_employees();
      //$data['all_departments'] = $this->Department_model->all_departments();
      $data['all_locations'] = $this->Xin_model->all_locations();
      //print_r($data);
      if ($data) {
         $data['subview'] = $this->load->view("admin/reports/employee_loan_register", $data, TRUE);
         $this->load->view('admin/layout/layout_main', $data); //page load
      } else {
         redirect('admin/dashboard');
      }
   }
   public function employee_loan_register_report()
   {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/employees", $data);
      } else {
         redirect('admin/');
      }
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));

      
            $company_id =$_GET['company_id'];
            $location_id =$_GET['location_id'];
            $department_id =$_GET['aj_department'];
            $employee_id =$_GET['employee_id'];
            $from_date =$_GET['from_date'];
            $to_date =$_GET['to_date'];
            
            
      //change date format from dd-mm-yyyy to yyyy-mm-dd
      if ($from_date != 0 || $to_date != 0) {
         # code...
         $from_date = date("Y-m-d", strtotime($from_date));
         $to_date = date("Y-m-d", strtotime($to_date));
      }
      //change date format from dd-mm-yyyy to yyyy-mm-dd
      $employee = $this->Assetreport_model->employee_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
      $data = array();
      foreach ($employee as $key => $val) {
         $company = $this->Xin_model->read_company_info($val['company_id']);
         if (!is_null($company)) {
            $comp_name = $company[0]->name;
         } else {
            $comp_name = '--';
         }
         if ($val['loan_options'] == 2)
         {
            $loan_type='Personal Loan';
         }else{
            $loan_type='Other Loan';
         }
         $full_name = $val['first_name'] . ' ' . $val['last_name'];
         $data[] = array(
            $val['employee_id'],
            $full_name,
            $val['start_date'],
            $loan_type,
            $val['monthly_installment'],
            $val['loan_time'],
            $val['month_year'],
            $val['loan_deduction_amount']
         );
      }
      $output = array(
         "draw" => $draw,
         "recordsTotal" => count($employee),
         "recordsFiltered" => count($employee),
         "data" => $data
      );
      $output['csrf_hash'] = $this->security->get_csrf_hash();
      echo json_encode($output);
      exit();
   }
   public function employee_loan_register_report_pdf()
   {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        $to_date =$this->input->post('e_end_date');
		$location_id =$this->input->post('e_location_id');
		$employee_id =$this->input->post('e_employee_id');
		$from_date =$this->input->post('e_start_date');
		$company_id =$this->input->post('e_company');
		$department_id =$this->input->post('e_department_id');
		
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
      if (!is_null($company)) 
      {
         $company_name = $company[0]->name;
         $address_1 = $company[0]->address_1;
         $address_2 = $company[0]->address_2;
         $city = $company[0]->city;
         $state = $company[0]->state;
         $company_logo = $company[0]->logo;
         $zipcode = $company[0]->zipcode;
         $country = $this->Xin_model->read_country_info($company[0]->country);
         if (!is_null($country)) {
            $country_name = $country[0]->country_name;
         } else {
            $country_name = '--';
         }
         $c_info_email = $company[0]->email;
         $c_info_phone = $company[0]->contact_number;
         if ($company_logo) {
            $logo = '../../../../../uploads/company/' . $company_logo;
            //	echo $logo;
         } else {
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
         }
      } else {
         $company_name = '--';
         $address_1 = '--';
         $address_2 = '--';
         $city = '--';
         $state = '--';
         $zipcode = '--';
         $country_name = '--';
         $c_info_email = '--';
         $c_info_phone = '--';
         $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
      }
      $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

      $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
		$employee = $this->Assetreport_model->employee_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
		$company_count = $this->Assetreport_model->employee_loan_register_company_count($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		//empty data display code start
      if(empty($company_count)){
        $logo_empty = "<img src='".$logo."' style='width:25%;'>";
            $company_name_empty = $company_name;
            $email_phone_address_empty = $email_phone_address;
        $empty_text = 'No Data Available In PDF';
      }else{
        $logo_empty = '';
            $company_name_empty = '';
            $email_phone_address_empty = '';
        $empty_text = '';
      }
      //empty data display code end
		$data = array();
        foreach($company_count as $key => $val) {
              $company = $this->Xin_model->read_company_info($val['company_id']);
              if (!is_null($company)) 
              {
                 $company_name = $company[0]->name;
                 $address_1 = $company[0]->address_1;
                 $address_2 = $company[0]->address_2;
                 $city = $company[0]->city;
                 $state = $company[0]->state;
                 $company_logo = $company[0]->logo;
                 $zipcode = $company[0]->zipcode;
                 $country = $this->Xin_model->read_country_info($company[0]->country);
                 if (!is_null($country)) {
                    $country_name = $country[0]->country_name;
                 } else {
                    $country_name = '--';
                 }
                 $c_info_email = $company[0]->email;
                 $c_info_phone = $company[0]->contact_number;
                 if ($company_logo) {
                    $logo = '../../../../../uploads/company/' . $company_logo;
                 } else {
                    $logo = '';
                 }
              } else {
                 $company_name = '';
                 $address_1 = '';
                 $address_2 = '';
                 $city = '';
                 $state = '';
                 $zipcode = '';
                 $country_name = '';
                 $c_info_email = '';
                 $c_info_phone = '';
                 $logo = '';
              }
                $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
                $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
                $company_count[$key]['header_string'] = $email_phone_address;
                $company_count[$key]['company_name'] = $company_name;
                $company_count[$key]['logo'] = $logo;
                $company_count[$key]['from_date'] = $from_date;
                $company_count[$key]['to_date'] = $to_date;
        }
		foreach($employee as $key => $val) {
		    if ($val['loan_options'] == 2)
            {
                $loan_type='Personal Loan';
            }else{
                $loan_type='Other Loan';
            }
			$full_name = $val['first_name'].' '.$val['last_name'];	
			$data[$key]['employee_id']=$val['employee_id'];
			$data[$key]['user_id']=$val['user_id'];
			$data[$key]['company_id']=$val['company_id'];
			$data[$key]['full_name']=$full_name;
			$data[$key]['created_at']=$val['start_date'];
			$data[$key]['advance_type']=$loan_type;
			$data[$key]['advance_amount']=$val['monthly_installment'];
			$data[$key]['monthly_installment']=$val['loan_deduction_amount'];
			$data[$key]['month_year']=$val['month_year'];
			$data[$key]['number_of_installment']=$val['loan_time'];
			$data[$key]['list']=$val['list'];
		}  
        $this->load->library('M_pdf');
    	$mpdf = $this->m_pdf->load([
    		'mode' => 'utf-8',
    		'format' => 'A4'
    	]);
	    $res['lists'] = $data;
        $res['company_count']=$company_count;
        $res['empty_text'] = $empty_text;
      $res['header_string'] = $email_phone_address_empty;
      $res['company_name'] = $company_name_empty;
      $res['logo_empty'] = $logo_empty;
    	$html = $this->load->view("admin/reports/employee_loan_register_report_pdf", $res, true);
    	$mpdf->WriteHTML($html);
    	$mpdf->Output('employee_loan_register_details.pdf','D');// 
    }
    public function employee_advance_loan_report_details(){
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$company_id =$_GET['company_id'];
		$location_id =$_GET['location_id'];
		$department_id =$_GET['aj_department'];
		$employee_id =$_GET['employee_id'];
		$from_date =$_GET['from_date'];
		$to_date =$_GET['to_date'];
		
		
		if ($from_date!=0 || $to_date!=0) {
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
		}
		
		// $employee = $this->Assetreport_model->employee_advance_loan_report($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		$employee = $this->Assetreport_model->employee_advance_details_report($company_id,$employee_id,$location_id,$from_date,$to_date,$department_id);
		$table = "";
		$table .="<span class='card-header-title mr-2'><strong>Employee Advance Outstanding Details</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_advance_details_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_advance_details_table'>
	                      <thead>
	                        <tr>
                                <th>Emp. Code</th>
                                <th style='padding-right: 110px;'>Employee</th>
                                <th>Advance Date</th>
                                <th>Advance Type</th>
                                <th>Advance Amount</th>
                                <th>Monthly Deduction</th>
                                <th>Deduction Month,Year</th>
                                <th>Deducted Amount</th>
                                <th>Closing Balance</th>
                            </tr>
                           </thead>";
		$data = array();
        foreach($employee as $key => $val) {
        	$full_name = $val['first_name'].' '.$val['last_name'];	
        	$table .="<tr><th style='border-right-width: 0px;'>".$val['employee_id']."</th>
					  <th style='border-right-width: 0px;'>Name: ".$full_name."</th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th></tr>";
			foreach ($val['list'] as $k1 => $li) {
				      $month_array=explode("-",$li['month_year']);
                      $monthNum  = $month_array[1];
                      $dateObj   = DateTime::createFromFormat('!m', $monthNum);
                      $monthName = $dateObj->format('F');
                      $monthName_str=$monthName.' ,'.$month_array[0];
				$table .="<tr>";
		        $table .="<td></td>
		                    <td></td>
		                    <td>".$val['created_at']."</td>
		                    <td>".$val['advance_type']."</td>
		                    <td>".$val['advance_amount']."</td>
		                    <td>".$li['amount']."</td>
		                    <td>".$monthName_str."</td>
		                    <td>".$li['monthly_deduct']."</td>
		                    <td>".$li['closing_balance']."</td>";    
		        $table .="</tr>";
			}
	  }
	  $table .="</tbody></table></div></div>";

	    header("Content-type: application/json");
	    $result[0] = $table;
        $result[1] = $this->security->get_csrf_hash();
        echo json_encode($result);
	  	exit();
	}
	public function employee_loan_report_detils()
    {
      $data['title'] = $this->Xin_model->site_title();
      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/employees", $data);
      } else {
         redirect('admin/');
      }

      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
      
        $company_id =$_GET['company_id'];
        $location_id =$_GET['location_id'];
        $department_id =$_GET['aj_department'];
        $employee_id =$_GET['employee_id'];
        $from_date =$_GET['from_date'];
        $to_date =$_GET['to_date'];
      

      //change date format from dd-mm-yyyy to yyyy-mm-dd
      if ($from_date != 0 || $to_date != 0) {
         # code...
         $from_date = date("Y-m-d", strtotime($from_date));
         $to_date = date("Y-m-d", strtotime($to_date));
      }
      // $employee = $this->Assetreport_model->employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
      $employee = $this->Assetreport_model->employee_loan_details_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id);
      $data = array();
      $table = "";
			$table .="<span class='card-header-title mr-2'><strong>Employee Loan Outstanding Details</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_loan_details_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='loan_details_table'>
	                      <thead>
	                        <tr>
                                <th>Emp. Code</th>
                                <th style='padding-right: 110px;'>Employee</th>
                                <th>Loan Date</th>
                                <th>Loan Type</th>
                                <th>Loan Amount</th>
                                <th>Monthly Deduction</th>
                                <th>Deduction Month,Year</th>
                                <th>Deducted Amount</th>
                                <th>Closing Balance</th>

                            </tr>
                           </thead>";
      if(!empty($employee))
      {
    	  foreach($employee as $key => $val) {
		      if($val['loan_deduction_id']!=NULL)
		      {
	            $full_name = $val['first_name'] . ' ' . $val['last_name'];
	    	    $table .="<tr><th style='border-right-width: 0px;'>".$val['employee_id']."</th>
					  <th style='border-right-width: 0px;'>".$full_name."</th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th></tr>";
	             if ($val['status'] == 0) : $status = 'pending';
	             elseif ($val['status'] == 1) : $status = 'approved';
	             elseif ($val['status'] == 2) : $status = 'rejected';
	             endif;
	             if ($val['loan_options'] == 2)
	             {
	                $loan_type='Personal Loan';
	             }else{
	                $loan_type='Other Loan';
	             }
	             foreach ($val['list'] as $k1 => $li) {
	             	  $month_array=explode("-",$li['month_year']);
                      $monthNum  = $month_array[1];
                      $dateObj   = DateTime::createFromFormat('!m', $monthNum);
                      $monthName = $dateObj->format('F');
                      $monthName_str=$monthName.' ,'.$month_array[0];
	             	$table .="<tr>";
			        $table .="<td></td>
			                    <td></td>
			                    <td>".$val['start_date']."</td>
			                    <td>".$loan_type."</td>
			                    <td>".$val['Total_loan_amount']."</td>
			                    <td>".$li['amount']."</td>
			                    <td>".$monthName_str."</td>
			                    <td>".$li['monthly_deduct']."</td>
			                    <td>".$li['closing_balance']."</td>";    
			        $table .="</tr>";
	             }
	            
	    	  }
       	 	}
      }
      $table .="</tbody></table></div></div>";

	    header("Content-type: application/json");
	    $result[0] = $table;
        $result[1] = $this->security->get_csrf_hash();
        echo json_encode($result);
	  	exit();
   }
    //////////////////////////////////////shift allocation report/////////////////////////////////////////////////////////////////////
    public function employee_shift_allocation()
   {
      $session = $this->session->userdata('username');
      if (empty($session)) {
         redirect('admin/');
      }
      $data['title'] = $this->lang->line('xin_hr_employee_loan_register') . ' | ' . $this->Xin_model->site_title();
      $data['path_url'] = 'Loan Register Report';
      $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_loan_register');
      $data['all_companies'] = $this->Xin_model->get_companies();
      $data['all_employees'] = $this->Xin_model->all_employees();
      //$data['all_departments'] = $this->Department_model->all_departments();
      $data['all_locations'] = $this->Xin_model->all_locations();
      //print_r($data);
      if ($data) {
         $data['subview'] = $this->load->view("admin/reports/employee_shift_allocation", $data, TRUE);
         $this->load->view('admin/layout/layout_main', $data); //page load
      } else {
         redirect('admin/dashboard');
      }
   }
     ///////////////////////////////////////////////////////////////
     ///////////////////////////////for filters/////////////////////////////
	public function get_locations_new() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/filters/report_get_locations_new", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 } 
	 public function get_location_employees_new() {
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$data = array(
			'location_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/reports/filters/report_get_location_employee_new", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	 
	 
	// get company > departments (rahul update)
    public function get_departments_new() {

      $data['title'] = $this->Xin_model->site_title();
      $company_id =$_GET['company_id'];
      $location_id =$_GET['location_id'];
      $check =$_GET['check'];

      $data = array(
         'company_id' => $company_id,
         'location_id' => $location_id,
         'check' => $check
      );
      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/filters/report_get_departments_new", $data);
      } else {
         redirect('admin/');
      }
      // Datatables Variables
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
    }
    
    public function get_location_new() {

      $data['title'] = $this->Xin_model->site_title();
      $company_id =$_GET['company_id'];
      $check =$_GET['check'];
	  
      $data = array(
         'company_id' => $company_id,
         'check' => $check
      );

      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/filters/get_location_new", $data);
      } else {
         redirect('admin/');
      }

      // Datatables Variables
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
    }
    
    public function get_employee_loca_new() {

      $data['title'] = $this->Xin_model->site_title();
      $company_id =$_GET['company_id'];
	  $department_id =$_GET['department_id'];
	  $location_id =$_GET['location_id'];
	  
	  
      $data = array(
         'company_id' => $company_id,
         'department_id' => $department_id,
         'location_id' => $location_id
      );

      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/filters/get_employee_loca_new", $data);
      } else {
         redirect('admin/');
      }

      // Datatables Variables
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
    }
    
	///////////////////////////////for filters/////////////////////////////
} 
?>