<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Assets extends MY_Controller
{

    /*Function to set JSON output*/
    public function output($Return = array())
    {
        /*Set response header*/
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json; charset=UTF-8");
        /*Final JSON response*/
        exit(json_encode($Return));
    }

    public function __construct()
    {
        parent::__construct();
        //load the models
        $this->load->model('Xin_model');
        $this->load->model('Employees_model');
        $this->load->model('Department_model');
        $this->load->model('Assets_model');
        $this->load->model('Custom_fields_model');
        $this->load->model('Location_model');
    }

    public function index()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $system = $this->Xin_model->read_setting_info(1);
        if ($system[0]->module_assets != 'true') {
            redirect('admin/dashboard');
        }
        $data['title'] = $this->lang->line('left_issue') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('left_issue');
        $data['path_url'] = 'assets';
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_assets_categories'] = $this->Assets_model->get_all_assets_categories();
        if (in_array('195', $role_resources_ids)) {
            $id = $this->uri->segment(4);
            $edata = array(
                'is_notify' => 0,
            );
            $this->Xin_model->update_notification_record($edata, $id, $session['user_id'], 'asset');
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/assets/assets_list", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function category()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_categories') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_categories');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['path_url'] = 'assets_category';
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('235', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/assets/assets_category_list", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    // get company > employees
    public function get_employees()
    {

        $data['title'] = $this->Xin_model->site_title();
        $id = $this->uri->segment(4);

        $data = array(
            'company_id' => $id
        );
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/assets/get_employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
    }

    // category list
    public function category_list()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        if (!empty($session)) {
            $this->load->view("admin/languages/languages_list", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));


        $assets_category = $this->Assets_model->get_assets_categories();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $data = array();

        foreach ($assets_category->result() as $r) {

            if (in_array('237', $role_resources_ids)) { //edit
                $edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->assets_category_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
            } else {
                $edit = '';
            }
            if (in_array('238', $role_resources_ids)) { // delete
                $delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->assets_category_id . '"><span class="fas fa-trash-restore"></span></button></span>';
            } else {
                $delete = '';
            }

            $combhr = $edit . $delete;

            if (in_array('237', $role_resources_ids) || in_array('238', $role_resources_ids)) {
                $data[] = array(

                    $r->category_name,
                    $combhr,
                );
            } else {
                $data[] = array(
                    $r->category_name
                );
            }
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $assets_category->num_rows(),
            "recordsFiltered" => $assets_category->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    // assets list
    public function assets_list()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        if (!empty($session)) {
            $this->load->view("admin/languages/languages_list", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $role_resources_ids = $this->Xin_model->user_role_resource();
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id == 1 || in_array('200', $role_resources_ids)) {
            $assets = $this->Assets_model->get_assets();
        } else {
            if (in_array('199', $role_resources_ids)) {
                $assets = $this->Assets_model->get_company_assets($user_info[0]->company_id);
            } else {
                $assets = $this->Assets_model->get_employee_assets($session['user_id']);
            }
        }
        $data = array();

        foreach ($assets->result() as $r) {
            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }
            // get category
            $assets_category = $this->Assets_model->read_assets_category_info($r->assets_category_id);
            $category = '--';
            //print_r($assets_category);
            if ($assets_category) {
                $category = $assets_category[0]->category_name;
            }

            //working?
            if ($r->is_working == 1) {
                $working = $this->lang->line('xin_yes');
            } else {
                $working = $this->lang->line('xin_no');
            }
            // get user > added by
            $user = $this->Xin_model->read_user_info($r->employee_id);
            // user full name
            if (!is_null($user)) {
                $full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
            } else {
                $full_name = '--';
            }

            if (in_array('197', $role_resources_ids) || in_array('202', $role_resources_ids)) { //edit
                $edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->assets_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
            } else {
                $edit = '';
            }
            if (in_array('198', $role_resources_ids) || in_array('203', $role_resources_ids)) { // delete
                $delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->assets_id . '"><span class="fas fa-trash-restore"></span></button></span>';
            } else {
                $delete = '';
            }
            if (in_array('199', $role_resources_ids) || in_array('204', $role_resources_ids)) { //view
                $view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-asset_id="' . $r->assets_id . '"><span class="fa fa-eye"></span></button></span>';
            } else {
                $view = '';
            }
            $combhr = $edit . $view . $delete;
            $created_at = $this->Xin_model->set_date_format($r->created_at);
            $iname = $r->name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_created_at') . ': ' . $created_at . '<i></i></i></small>';
            $name = $r->name;

            $this->db->where('id', $name);
            $asset = $this->db->get('xin_assets_master')->row();
            if ($asset) $name = $asset->name;

            if (in_array('197', $role_resources_ids) || in_array('202', $role_resources_ids) || in_array('198', $role_resources_ids) || in_array('203', $role_resources_ids) || in_array('199', $role_resources_ids) || in_array('204', $role_resources_ids)) {
                $data[] = array(
     $r->company_asset_code,
                    $name,
                    $category,
               
                    $working,
                    $full_name,
                    $comp_name,
                    $combhr,
                );
            } else {
                $data[] = array(
                         $r->company_asset_code,
                    $name,
                    $category,
                    $r->company_asset_code,
                    $working,
                    $full_name,
                    $comp_name
                );
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $assets->num_rows(),
            "recordsFiltered" => $assets->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function asset_read()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        $id = $this->input->get('asset_id');
        $result = $this->Assets_model->read_assets_info($id);

        $name = $result[0]->name;

        $this->db->where('id', $name);
        $asset = $this->db->get('xin_assets_master')->row();
        if ($asset) $name = $asset->name;

        $data = array(
            'assets_id' => $result[0]->assets_id,
            'assets_category_id' => $result[0]->assets_category_id,
            'company_id' => $result[0]->company_id,
            'location_id' => $result[0]->location_id,
            'employee_id' => $result[0]->employee_id,
            'company_asset_code' => $result[0]->company_asset_code,
            'name' => $result[0]->name,
            'purchase_date' => $result[0]->purchase_date,
            'asset_assigned_date' => $result[0]->asset_assigned_date,
            'invoice_number' => $result[0]->invoice_number,
            'manufacturer' => $result[0]->manufacturer,
            'serial_number' => $result[0]->serial_number,
            'warranty_end_date' => $result[0]->warranty_end_date,
            'asset_note' => $result[0]->asset_note,
            'asset_image' => $result[0]->asset_image,
            'is_working' => $result[0]->is_working,
            'created_at' => $result[0]->created_at,
            'all_employees' => $this->Xin_model->all_employees(),
            'all_assets_categories' => $this->Assets_model->get_all_assets_categories(),
            'all_companies' => $this->Xin_model->get_companies()
        );
        if (!empty($session)) {
            $this->load->view('admin/assets/dialog_asset', $data);
        } else {
            redirect('admin/');
        }
    }

    // Validate and add info in database
    public function add_category()
    {

        if ($this->input->post('add_type') == 'add_category') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('name') === '') {
                $Return['error'] = $this->lang->line('xin_error_cat_name_field');
            }

            $dup_name = $this->input->post('name');
            $sql = "SELECT * from xin_assets_categories where category_name = '$dup_name'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $count = 1;
            } else {
                $count = 0;
            }

            if ($count == '1') {
                $Return['error'] = 'Category All Ready Exist';
            }



            if ($Return['error'] != '') {
                $this->output($Return);
            }

            // set data
            $data = array(
                'category_name' => $this->input->post('name'),
                'created_at' => date('d-m-Y h:i:s')
            );

            $result = $this->Assets_model->add_assets_category($data);
            if ($result == TRUE) {
                $Return['result'] = $this->lang->line('xin_success_assets_category_added');
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
            $this->output($Return);
            exit;
        }
        else
        {
            redirect('admin/assets/category');
        }
    }

    // Validate and add info in database
    public function add_asset()
    {
$name= $this->input->post('asset_id');
        if ($this->input->post('add_type') == 'add_asset') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('category_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_category_field');
            } else if ($this->input->post('company_id') === '') {
                $Return['error'] = $this->lang->line('error_company_field');
            } else if ($this->input->post('employee_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_employee_id');
            } else {
                $this->input->post('asset_id');
              
                
                $this->db->where('id', $this->input->post('asset_id'));
                $this->db->where('return_status', 1);
               $assest_assigned = $this->db->get('xin_assets_master');
                //
         
                if ($assest_assigned->num_rows() > 0) {
                    
                    $Return['error'] = "Asset already assigned";
                }
            }

            if ($Return['error'] != '') {
                $this->output($Return);
            }
            // if (is_uploaded_file($_FILES['asset_image']['tmp_name'])) {
            //     //checking image type
            //     $allowed = array('png', 'jpg', 'jpeg', 'gif');
            //     $filename = $_FILES['asset_image']['name'];
            //     $ext = pathinfo($filename, PATHINFO_EXTENSION);

            //     if (in_array($ext, $allowed)) {
            //         $tmp_name = $_FILES["asset_image"]["tmp_name"];
            //         $asset_image = "uploads/asset_image/";
            //         // basename() may prevent filesystem traversal attacks;
            //         // further validation/sanitation of the filename may be appropriate
            //         $lname = basename($_FILES["asset_image"]["name"]);
            //         $newfilename = 'asset_image_' . round(microtime(true)) . '.' . $ext;
            //         move_uploaded_file($tmp_name, $asset_image . $newfilename);
            //         $fname = $newfilename;
            //     } else {
            //         $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
            //     }
            // } else {
            //     $fname = '';
            // }
            $module_attributes = $this->Custom_fields_model->assets_hrsale_module_attributes();
            $count_module_attributes = $this->Custom_fields_model->count_assets_module_attributes();
            $i = 1;
            if ($count_module_attributes > 0) {
                foreach ($module_attributes as $mattribute) {
                    if ($mattribute->validation == 1) {
                        if ($i != 1) {
                        } else if ($this->input->post($mattribute->attribute) == '') {
                            $Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
                        }
                    }
                }
                if ($Return['error'] != '') {
                    $this->output($Return);
                }
            }
            // set data
            $data = array(
                'assets_category_id' => $this->input->post('category_id'),
                'name' => $this->input->post('asset_id'),
                'company_asset_code' => $this->input->post('code'),
                'is_working' => $this->input->post('is_working'),
                'company_id' => $this->input->post('company_id'),
                'location_id' => $this->input->post('location_id'),
                'employee_id' => $this->input->post('employee_id'),
                'purchase_date' => $this->input->post('purchase_date'),
                'asset_assigned_date' => $this->input->post('asset_assigned_date'),
                'invoice_number' => $this->input->post('invoice_number'),
                'manufacturer' => $this->input->post('manufacturer'),
                'serial_number' => $this->input->post('serial_number'),
                'warranty_end_date' => $this->input->post('warranty_end_date'),
                'asset_note' => $this->input->post('asset_note'),
                'asset_image' => $this->input->post('attachment'),
                'created_at' => date('d-m-Y h:i:s')
            );

            $iresult = $this->Assets_model->add_asset($data);
            // $icheck =$this->Assets_model->ifalreadyinreturn($name);
            if ($iresult) {
                 $this->db->set('status', 'In Use');
                        $this->db->set('return_status', '1');
                        $this->db->where('id', $name);
                        $this->db->update('xin_assets_master ');


                        $this->db->set('status', '1');
                        $this->db->where('asset_master_id', $name);
                        $this->db->update('xin_assets_returns');

                $Return['result'] = $this->lang->line('xin_success_asset_added');
                $id = $iresult;
                // notificaions
                $nticket_data = array(
                    'module_name' => 'asset',
                    'module_id' => $id,
                    'employee_id' => $this->input->post('employee_id'),
                    'is_notify' => '1',
                    'created_at' => date('d-m-Y h:i:s'),
                );
                $this->Xin_model->add_notifications($nticket_data);
                if ($count_module_attributes > 0) {
                    foreach ($module_attributes as $mattribute) {
                        /*$attr_data = array(
						   'user_id' => $iresult,
						   'module_attributes_id' => $mattribute->custom_field_id,
						   'attribute_value' => $this->input->post($mattribute->attribute),
						   'created_at' => date('Y-m-d h:i:s')
					   );
					   $this->Custom_fields_model->add_values($attr_data);*/
                        if ($mattribute->attribute_type == 'fileupload') {
                            if ($_FILES[$mattribute->attribute]['size'] != 0) {
                                if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
                                    //checking image type
                                    $allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
                                    $filename = $_FILES[$mattribute->attribute]['name'];
                                    $ext = pathinfo($filename, PATHINFO_EXTENSION);

                                    if (in_array($ext, $allowed)) {
                                        $tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
                                        $profile = "uploads/custom_files/";
                                        $set_img = base_url() . "uploads/custom_files/";
                                        // basename() may prevent filesystem traversal attacks;
                                        // further validation/sanitation of the filename may be appropriate
                                        $name = basename($_FILES[$mattribute->attribute]["name"]);
                                        $newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
                                        move_uploaded_file($tmp_name, $profile . $newfilename);
                                        $fname = $newfilename;
                                    }
                                    $iattr_data = array(
                                        'user_id' => $id,
                                        'module_attributes_id' => $mattribute->custom_field_id,
                                        'attribute_value' => $fname,
                                        'created_at' => date('Y-m-d h:i:s')
                                    );
                                    $this->Custom_fields_model->add_values($iattr_data);
                                }
                            } else {
                                $iattr_data = array(
                                    'user_id' => $id,
                                    'module_attributes_id' => $mattribute->custom_field_id,
                                    'attribute_value' => '',
                                    'created_at' => date('Y-m-d h:i:s')
                                );
                                $this->Custom_fields_model->add_values($iattr_data);
                            }
                        } else if ($mattribute->attribute_type == 'multiselect') {
                            $multisel_val = $this->input->post($mattribute->attribute);
                            if (!empty($multisel_val)) {
                                $newdata = implode(',', $this->input->post($mattribute->attribute));
                                $iattr_data = array(
                                    'user_id' => $id,
                                    'module_attributes_id' => $mattribute->custom_field_id,
                                    'attribute_value' => $newdata,
                                    'created_at' => date('Y-m-d h:i:s')
                                );
                                $this->Custom_fields_model->add_values($iattr_data);
                            }
                        } else {
                            if ($this->input->post($mattribute->attribute) == '') {
                                $file_val = '';
                            } else {
                                $file_val = $this->input->post($mattribute->attribute);
                            }
                            $iattr_data = array(
                                'user_id' => $id,
                                'module_attributes_id' => $mattribute->custom_field_id,
                                'attribute_value' => $file_val,
                                'created_at' => date('Y-m-d h:i:s')
                            );
                            $this->Custom_fields_model->add_values($iattr_data);
                        }
                        /*$attr_orig_value = $this->Custom_fields_model->read_hrsale_module_attributes_values($result,$mattribute->custom_field_id);
						if($attr_orig_value->module_attributes_id != $mattribute->custom_field_id) {
							$this->Custom_fields_model->add_values($attr_data);
						}*/
                    }
                }
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
            $this->output($Return);
            exit;
        }
    }

    // Validate and add info in database
    public function update_asset_validate()
    {
        // echo "<pre>";print_r($this->input->post());exit;
        if ($this->input->post('edit_type') == 'update_asset') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('category_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_category_field');
            } else if ($this->input->post('asset_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_asset_name_field');
            } /*else if($this->input->post('company_asset_code')==='') {
        	$Return['error'] = $this->lang->line('xin_error_cat_name_field');
		}*/ else if ($this->input->post('company_id') === '') {
                $Return['error'] = $this->lang->line('error_company_field');
            } else if ($this->input->post('employee_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_employee_id');
            } /*else if($this->input->post('manufacturer')==='') {
        	$Return['error'] = $this->lang->line('xin_error_manufacturer_field');
		} else if($this->input->post('asset_note')==='') {
        	$Return['error'] = $this->lang->line('xin_error_asset_note_field');
		}*/
            /* Check if file uploaded..*/ else if ($_FILES['asset_image']['size'] == 0) {
                // set data
                $module_attributes = $this->Custom_fields_model->assets_hrsale_module_attributes();
                $count_module_attributes = $this->Custom_fields_model->count_assets_module_attributes();
                $i = 1;
                if ($count_module_attributes > 0) {
                    foreach ($module_attributes as $mattribute) {
                        if ($mattribute->validation == 1) {
                            if ($i != 1) {
                            } else if ($this->input->post($mattribute->attribute) == '') {
                                $Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
                            }
                        }
                    }
                    if ($Return['error'] != '') {
                        $this->output($Return);
                    }
                }
                if ($count_module_attributes > 0) {
                    foreach ($module_attributes as $mattribute) {

                        //
                        $count_exist_values = $this->Custom_fields_model->count_module_attributes_values($id, $mattribute->custom_field_id);
                        if ($count_exist_values > 0) {
                            if ($mattribute->attribute_type == 'fileupload') {
                                if ($_FILES[$mattribute->attribute]['size'] != 0) {
                                    if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
                                        //checking image type
                                        $allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
                                        $filename = $_FILES[$mattribute->attribute]['name'];
                                        $ext = pathinfo($filename, PATHINFO_EXTENSION);

                                        if (in_array($ext, $allowed)) {
                                            $tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
                                            $profile = "uploads/custom_files/";
                                            $set_img = base_url() . "uploads/custom_files/";
                                            // basename() may prevent filesystem traversal attacks;
                                            // further validation/sanitation of the filename may be appropriate
                                            $name = basename($_FILES[$mattribute->attribute]["name"]);
                                            $newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
                                            move_uploaded_file($tmp_name, $profile . $newfilename);
                                            $fname = $newfilename;
                                            $Return['fileName'] = $newfilename;
                                        }
                                        $iattr_data = array(
                                            'attribute_value' => $fname
                                        );
                                        $this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
                                    }
                                } else {
                                }
                            } else if ($mattribute->attribute_type == 'multiselect') {
                                $multisel_val = $this->input->post($mattribute->attribute);
                                if (!empty($multisel_val)) {
                                    $newdata = implode(',', $this->input->post($mattribute->attribute));
                                    $iattr_data = array(
                                        'attribute_value' => $newdata,
                                    );
                                    $this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
                                }
                            } else {
                                $attr_data = array(
                                    'attribute_value' => $this->input->post($mattribute->attribute),
                                );
                                $this->Custom_fields_model->update_att_record($attr_data, $id, $mattribute->custom_field_id);
                            }
                        } else {
                            if ($mattribute->attribute_type == 'fileupload') {
                                if ($_FILES[$mattribute->attribute]['size'] != 0) {
                                    if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
                                        //checking image type
                                        $allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
                                        $filename = $_FILES[$mattribute->attribute]['name'];
                                        $ext = pathinfo($filename, PATHINFO_EXTENSION);

                                        if (in_array($ext, $allowed)) {
                                            $tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
                                            $profile = "uploads/custom_files/";
                                            $set_img = base_url() . "uploads/custom_files/";
                                            // basename() may prevent filesystem traversal attacks;
                                            // further validation/sanitation of the filename may be appropriate
                                            $name = basename($_FILES[$mattribute->attribute]["name"]);
                                            $newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
                                            move_uploaded_file($tmp_name, $profile . $newfilename);
                                            $fname = $newfilename;
                                            $Return['fileName'] = $newfilename;
                                        }
                                        $iattr_data = array(
                                            'user_id' => $id,
                                            'module_attributes_id' => $mattribute->custom_field_id,
                                            'attribute_value' => $fname,
                                            'created_at' => date('Y-m-d h:i:s')
                                        );
                                        $this->Custom_fields_model->add_values($iattr_data);
                                    }
                                } else {
                                    if ($this->input->post($mattribute->attribute) == '') {
                                        $file_val = '';
                                    } else {
                                        $file_val = $this->input->post($mattribute->attribute);
                                    }
                                    $iattr_data = array(
                                        'user_id' => $id,
                                        'module_attributes_id' => $mattribute->custom_field_id,
                                        'created_at' => date('Y-m-d h:i:s')
                                    );
                                    $this->Custom_fields_model->add_values($iattr_data);
                                }
                            } else if ($mattribute->attribute_type == 'multiselect') {
                                $multisel_val = $this->input->post($mattribute->attribute);
                                if (!empty($multisel_val)) {
                                    $newdata = implode(',', $this->input->post($mattribute->attribute));
                                    $iattr_data = array(
                                        'user_id' => $id,
                                        'module_attributes_id' => $mattribute->custom_field_id,
                                        'attribute_value' => $newdata,
                                        'created_at' => date('Y-m-d h:i:s')
                                    );
                                    $this->Custom_fields_model->add_values($iattr_data);
                                }
                            } else {
                                if ($this->input->post($mattribute->attribute) == '') {
                                    $file_val = '';
                                } else {
                                    $file_val = $this->input->post($mattribute->attribute);
                                }
                                $iattr_data = array(
                                    'user_id' => $id,
                                    'module_attributes_id' => $mattribute->custom_field_id,
                                    'attribute_value' => $file_val,
                                    'created_at' => date('Y-m-d h:i:s')
                                );
                                $this->Custom_fields_model->add_values($iattr_data);
                            }
                        }
                    }
                }
            } else {
                $module_attributes = $this->Custom_fields_model->assets_hrsale_module_attributes();
                $count_module_attributes = $this->Custom_fields_model->count_assets_module_attributes();
                $i = 1;
                if ($count_module_attributes > 0) {
                    foreach ($module_attributes as $mattribute) {
                        if ($mattribute->validation == 1) {
                            if ($i != 1) {
                            } else if ($this->input->post($mattribute->attribute) == '') {
                                $Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
                            }
                        }
                    }
                    if ($Return['error'] != '') {
                        $this->output($Return);
                    }
                }
                if (is_uploaded_file($_FILES['asset_image']['tmp_name'])) {
                    //checking image type
                    $allowed = array('png', 'jpg', 'jpeg', 'gif');
                    $filename = $_FILES['asset_image']['name'];
                    $ext = pathinfo($filename, PATHINFO_EXTENSION);

                    if (in_array($ext, $allowed)) {
                        $tmp_name = $_FILES["asset_image"]["tmp_name"];
                        $asset_image = "uploads/asset_image/";
                        // basename() may prevent filesystem traversal attacks;
                        // further validation/sanitation of the filename may be appropriate
                        $lname = basename($_FILES["asset_image"]["name"]);
                        $newfilename = 'asset_image_' . round(microtime(true)) . '.' . $ext;
                        move_uploaded_file($tmp_name, $asset_image . $newfilename);
                        $fname = $newfilename;
                        $Return['fileName'] = $newfilename;

                        if ($count_module_attributes > 0) {
                            foreach ($module_attributes as $mattribute) {

                                //
                                $count_exist_values = $this->Custom_fields_model->count_module_attributes_values($id, $mattribute->custom_field_id);
                                if ($count_exist_values > 0) {
                                    if ($mattribute->attribute_type == 'fileupload') {
                                        if ($_FILES[$mattribute->attribute]['size'] != 0) {
                                            if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
                                                //checking image type
                                                $allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
                                                $filename = $_FILES[$mattribute->attribute]['name'];
                                                $ext = pathinfo($filename, PATHINFO_EXTENSION);

                                                if (in_array($ext, $allowed)) {
                                                    $tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
                                                    $profile = "uploads/custom_files/";
                                                    $set_img = base_url() . "uploads/custom_files/";
                                                    // basename() may prevent filesystem traversal attacks;
                                                    // further validation/sanitation of the filename may be appropriate
                                                    $name = basename($_FILES[$mattribute->attribute]["name"]);
                                                    $newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
                                                    move_uploaded_file($tmp_name, $profile . $newfilename);
                                                    $fname = $newfilename;
                                                    $Return['fileName'] = $newfilename;
                                                }
                                                $iattr_data = array(
                                                    'attribute_value' => $fname
                                                );
                                                $this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
                                            }
                                        } else {
                                        }
                                    } else if ($mattribute->attribute_type == 'multiselect') {
                                        $multisel_val = $this->input->post($mattribute->attribute);
                                        if (!empty($multisel_val)) {
                                            $newdata = implode(',', $this->input->post($mattribute->attribute));
                                            $iattr_data = array(
                                                'attribute_value' => $newdata,
                                            );
                                            $this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
                                        }
                                    } else {
                                        $attr_data = array(
                                            'attribute_value' => $this->input->post($mattribute->attribute),
                                        );
                                        $this->Custom_fields_model->update_att_record($attr_data, $id, $mattribute->custom_field_id);
                                    }
                                } else {
                                    if ($mattribute->attribute_type == 'fileupload') {
                                        if ($_FILES[$mattribute->attribute]['size'] != 0) {
                                            if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {
                                                //checking image type
                                                $allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');
                                                $filename = $_FILES[$mattribute->attribute]['name'];
                                                $ext = pathinfo($filename, PATHINFO_EXTENSION);

                                                if (in_array($ext, $allowed)) {
                                                    $tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];
                                                    $profile = "uploads/custom_files/";
                                                    $set_img = base_url() . "uploads/custom_files/";
                                                    // basename() may prevent filesystem traversal attacks;
                                                    // further validation/sanitation of the filename may be appropriate
                                                    $name = basename($_FILES[$mattribute->attribute]["name"]);
                                                    $newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;
                                                    move_uploaded_file($tmp_name, $profile . $newfilename);
                                                    $fname = $newfilename;
                                                    $Return['fileName'] = $newfilename;
                                                }
                                                $iattr_data = array(
                                                    'user_id' => $id,
                                                    'module_attributes_id' => $mattribute->custom_field_id,
                                                    'attribute_value' => $fname,
                                                    'created_at' => date('Y-m-d h:i:s')
                                                );
                                                $this->Custom_fields_model->add_values($iattr_data);
                                            }
                                        } else {
                                            if ($this->input->post($mattribute->attribute) == '') {
                                                $file_val = '';
                                            } else {
                                                $file_val = $this->input->post($mattribute->attribute);
                                            }
                                            $iattr_data = array(
                                                'user_id' => $id,
                                                'module_attributes_id' => $mattribute->custom_field_id,
                                                'created_at' => date('Y-m-d h:i:s')
                                            );
                                            $this->Custom_fields_model->add_values($iattr_data);
                                        }
                                    } else if ($mattribute->attribute_type == 'multiselect') {
                                        $multisel_val = $this->input->post($mattribute->attribute);
                                        if (!empty($multisel_val)) {
                                            $newdata = implode(',', $this->input->post($mattribute->attribute));
                                            $iattr_data = array(
                                                'user_id' => $id,
                                                'module_attributes_id' => $mattribute->custom_field_id,
                                                'attribute_value' => $newdata,
                                                'created_at' => date('Y-m-d h:i:s')
                                            );
                                            $this->Custom_fields_model->add_values($iattr_data);
                                        }
                                    } else {
                                        if ($this->input->post($mattribute->attribute) == '') {
                                            $file_val = '';
                                        } else {
                                            $file_val = $this->input->post($mattribute->attribute);
                                        }
                                        $iattr_data = array(
                                            'user_id' => $id,
                                            'module_attributes_id' => $mattribute->custom_field_id,
                                            'attribute_value' => $file_val,
                                            'created_at' => date('Y-m-d h:i:s')
                                        );
                                        $this->Custom_fields_model->add_values($iattr_data);
                                    }
                                }
                            }
                        }
                    } else {
                        $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
                    }
                }
            }

            if ($Return['error'] != '') {
                $this->output($Return);
            }
            $this->output($Return);
            exit;
        }
    }

    public function update_asset()
    {
        // print_r($this->input->post('code'));
        // exit;
        // echo "<pre>";print_r($this->input->post());exit;
        if ($this->input->post('edit_type') == 'update_asset') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('category_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_category_field');
            } else if ($this->input->post('asset_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_asset_name_field');
            } /*else if($this->input->post('company_asset_code')==='') {
        	$Return['error'] = $this->lang->line('xin_error_cat_name_field');
		}*/ else if ($this->input->post('company_id') === '') {
                $Return['error'] = $this->lang->line('error_company_field');
            } else if ($this->input->post('employee_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_employee_id');
            } /*else if($this->input->post('manufacturer')==='') {
        	$Return['error'] = $this->lang->line('xin_error_manufacturer_field');
		} else if($this->input->post('asset_note')==='') {
        	$Return['error'] = $this->lang->line('xin_error_asset_note_field');
		}*/
            /* Check if file uploaded..*/ else if ($this->input->post('attachment') == '') {
                // set data
                $module_attributes = $this->Custom_fields_model->assets_hrsale_module_attributes();
                $count_module_attributes = $this->Custom_fields_model->count_assets_module_attributes();
                $i = 1;
                if ($count_module_attributes > 0) {
                    foreach ($module_attributes as $mattribute) {
                        if ($mattribute->validation == 1) {
                            if ($i != 1) {
                            } else if ($this->input->post($mattribute->attribute) == '') {
                                $Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
                            }
                        }
                    }
                    if ($Return['error'] != '') {
                        $this->output($Return);
                    }
                }
                $data = array(
                    //'assets_category_id' => $this->input->post('category_id'),
                    
                    'name' => $this->input->post('ext_name'),
                    'company_asset_code' => $this->input->post('code'),
                    'is_working' => $this->input->post('is_working'),
                    //'company_id' => $this->input->post('company_id'),
                    'employee_id' => $this->input->post('employee_id'),
                    'purchase_date' => $this->input->post('purchase_date'),
                    'asset_assigned_date' => $this->input->post('asset_assigned_date'),
                    'invoice_number' => $this->input->post('invoice_number'),
                    'manufacturer' => $this->input->post('manufacturer'),
                    'serial_number' => $this->input->post('serial_number'),
                    'warranty_end_date' => $this->input->post('warranty_end_date'),
                    'asset_note' => $this->input->post('asset_note'),
                 
                );

                $result = $this->Assets_model->update_assets_record($data, $id);
                if ($count_module_attributes > 0) {
                    foreach ($module_attributes as $mattribute) {

                        //
                        $count_exist_values = $this->Custom_fields_model->count_module_attributes_values($id, $mattribute->custom_field_id);
                    }
                }
            } else {
                $module_attributes = $this->Custom_fields_model->assets_hrsale_module_attributes();
                $count_module_attributes = $this->Custom_fields_model->count_assets_module_attributes();
                $i = 1;
                $fname = $this->input->post('attachment');
    // $name = $this->input->post('ext_name');
                // set data
                $data = array(
                    //'assets_category_id' => $this->input->post('category_id'),
                    'name' => $this->input->post('ext_name'),
                    'company_asset_code' => $this->input->post('code'),
                    'is_working' => $this->input->post('is_working'),
                    //'company_id' => $this->input->post('company_id'),
                    'employee_id' => $this->input->post('employee_id'),
                    'purchase_date' => $this->input->post('purchase_date'),
                    'invoice_number' => $this->input->post('invoice_number'),
                    'manufacturer' => $this->input->post('manufacturer'),
                    'serial_number' => $this->input->post('serial_number'),
                    'warranty_end_date' => $this->input->post('warranty_end_date'),
                    'asset_note' => $this->input->post('asset_note'),
                    'asset_image' => $fname
                );
       
                $result = $this->Assets_model->update_assets_record($data, $id);
            }

            if ($Return['error'] != '') {
                $this->output($Return);
            }

            if ($result == TRUE) {

                $Return['result'] = $this->lang->line('xin_success_asset_updated');
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
            $this->output($Return);
            exit;
        }
    }
    // Validate and update info in database
    public function update_assets_category_validate()
    {

        if ($this->input->post('edit_type') == 'assets_category') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('name') === '') {
                $Return['error'] = $this->lang->line('xin_error_cat_name_field');
            }

            $dup_name = $this->input->post('name');
            $asset_name_check = $this->Assets_model->update_assets_category_name_check($id);
            if (!is_null($asset_name_check)) {
                $asset_name_get = $asset_name_check[0]->category_name;
            } else {
                $asset_name_get = '';
            }

            if ($dup_name == $asset_name_get) {

                if ($Return['error'] != '') {
                    $this->output($Return);
                }
            } else {

                $sql = "SELECT * from xin_assets_categories where category_name = '$dup_name'";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $count = 1;
                } else {
                    $count = 0;
                }

                if ($count == '1') {
                    $Return['error'] = 'Category All Ready Exist';
                }

                if ($Return['error'] != '') {
                    $this->output($Return);
                }
            }

            $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $this->output($Return);
            exit;
        }
    }

    public function update_assets_category()
    {

        if ($this->input->post('edit_type') == 'assets_category') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('name') === '') {
                $Return['error'] = $this->lang->line('xin_error_cat_name_field');
            }

            $dup_name = $this->input->post('name');
            $asset_name_check = $this->Assets_model->update_assets_category_name_check($id);
            if (!is_null($asset_name_check)) {
                $asset_name_get = $asset_name_check[0]->category_name;
            } else {
                $asset_name_get = '';
            }

            if ($dup_name == $asset_name_get) {

                if ($Return['error'] != '') {
                    $this->output($Return);
                }

                // set data
                $data = array(
                    'category_name' => $this->input->post('name')
                );

                $result = $this->Assets_model->update_assets_category_record($data, $id);
                if ($result == TRUE) {
                    $Return['result'] = $this->lang->line('xin_success_assets_category_updated');
                } else {
                    $Return['error'] = $this->lang->line('xin_error_msg');
                }
            } else {

                $sql = "SELECT * from xin_assets_categories where category_name = '$dup_name'";
                $query = $this->db->query($sql);
                if ($query->num_rows() > 0) {
                    $count = 1;
                } else {
                    $count = 0;
                }

                if ($count == '1') {
                    $Return['error'] = 'Category All Ready Exist';
                }

                if ($Return['error'] != '') {
                    $this->output($Return);
                }

                // set data
                $data = array(
                    'category_name' => $this->input->post('name')
                );

                $result = $this->Assets_model->update_assets_category_record($data, $id);
                if ($result == TRUE) {
                    $Return['result'] = $this->lang->line('xin_success_assets_category_updated');
                } else {
                    $Return['error'] = $this->lang->line('xin_error_msg');
                }
            }


            $this->output($Return);
            exit;
        }
    }

    public function read_assets_category()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        $id = $this->input->get('assets_category_id');
        $result = $this->Assets_model->read_assets_category_info($id);
        $data = array(
            'assets_category_id' => $result[0]->assets_category_id,
            'company_id' => $result[0]->company_id,
            'category_name' => $result[0]->category_name,
            'created_at' => $result[0]->created_at
        );
        if (!empty($session)) {
            $this->load->view('admin/assets/dialog_assets_category', $data);
        } else {
            redirect('admin/');
        }
    }

    // delete record > table
    public function delete_asset()
    {
        if ($this->input->post('type') == 'delete_record') {
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            //  Delete master entry when request from master section
            if (isset($_SERVER['HTTP_REFERER'])) {
                if (strpos($_SERVER['HTTP_REFERER'], 'assets/add') !== false) {
                    $this->db->where('id', $id);
                    $asset = $this->db->get('xin_assets_master')->row();

                    if ($asset) {
                        $image = $asset->image;
                        $asset_image = "uploads/asset_image/";

                        @unlink($asset_image . $image);

                        $this->db->where('id', $asset->id);
                        $this->db->delete('xin_assets_master');

                        $Return['result'] = $this->lang->line('xin_success_asset_deleted');
                    }

                    $this->output($Return);
                }
            }

            /* Define return | here result is used to return user data and error for error message */
            $result = $this->Assets_model->delete_assets_record($id);
            if (isset($id)) {
                $Return['result'] = $this->lang->line('xin_success_asset_deleted');
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
            $this->output($Return);
        }
    }

    // delete record > table
    public function delete_assets_category()
    {

        if ($this->input->post('type') == 'delete_record') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $result = $this->Assets_model->delete_assets_category_record($id);
            if (isset($id)) {
                $Return['result'] = $this->lang->line('xin_success_assets_category_deleted');
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
            $this->output($Return);
        }
    }

    public function assets_returns_page()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $system = $this->Xin_model->read_setting_info(1);
        if ($system[0]->module_assets != 'true') {
            redirect('admin/dashboard');
        }
        $data['title'] = $this->lang->line('left_return') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('left_return');
        $data['path_url'] = 'asset_return';
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_assets_names'] = $this->Assets_model->get_all_assets_name();
        $data['all_assets_categories'] = $this->Assets_model->get_all_assets_categories();
        if (in_array('206', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/assets/assets_returnslist", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function get_assets_name()
    {
        $assets_name = $this->input->get('assets_name');
        $session = $this->session->userdata('username');
        $data = $this->Assets_model->get_all_assets_name_single('', $assets_name, $session);
        $data_array = [];

        for ($i = 0; $i < count($data); $i++) {

            $data_array['assets_id'] = $data[$i]->assets_id;
            $data_array['name'] = $data[$i]->name;
            $data_array['assets_category_id'] = $data[$i]->assets_category_id;
            $data_array['company_asset_code'] = $data[$i]->company_asset_code;
            $data_array['company_id'] = $data[$i]->company_id;
            $data_array['created_at'] = $data[$i]->created_at;
            $data_array['employee_id'] = $data[$i]->employee_id;
            $data_array['invoice_number'] = $data[$i]->invoice_number;
            $data_array['is_working'] = $data[$i]->is_working;
            $data_array['manufacturer'] = $data[$i]->manufacturer;
            $data_array['purchase_date'] = $data[$i]->purchase_date;
            $data_array['asset_image'] = $data[$i]->asset_image;
            $data_array['asset_note'] = $data[$i]->asset_note;
            $data_array['serial_number'] = $data[$i]->serial_number;
            $data_array['warranty_end_date'] = $data[$i]->warranty_end_date;
            $data_array['company_asset_code'] = $data[$i]->company_asset_code;
        }
        print_r(json_encode($data_array));
    }

    public function save_asset_return()
    {
        $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
        $Return['csrf_hash'] = $this->security->get_csrf_hash();

        /* Server side PHP input validation */
        if ($this->input->post('handover_date') == '') {
            $Return['error'] = 'Handover Date feild is required';
        } else if ($this->input->post('handover_by') == '') {
            $Return['error'] = 'Handover By feild is required';
        } else if ($this->input->post('hidden_assets_id') == '') {
            $Return['error'] = $this->lang->line('xin_error_asset_name_field');
        }

        if ($Return['error'] != '') {
            $this->output($Return);
            exit();
        }

        // if (isset($_FILES['asset_handover_image']['tmp_name'])) {
        //     if (is_uploaded_file($_FILES['asset_handover_image']['tmp_name'])) {
        //         //checking image type
        //         $allowed = array('png', 'jpg', 'jpeg', 'gif');
        //         $filename = $_FILES['asset_handover_image']['name'];
        //         $ext = pathinfo($filename, PATHINFO_EXTENSION);

        //         if (in_array($ext, $allowed)) {
        //             $tmp_name = $_FILES["asset_handover_image"]["tmp_name"];
        //             $asset_image = "uploads/asset_image/";
        //             // basename() may prevent filesystem traversal attacks;
        //             // further validation/sanitation of the filename may be appropriate
        //             $lname = basename($_FILES["asset_handover_image"]["name"]);
        //             $newfilename = 'asset_handover_image_' . round(microtime(true)) . '.' . $ext;
        //             move_uploaded_file($tmp_name, $asset_image . $newfilename);
        //             $fname = $newfilename;
        //         } else {
        //             $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
        //         }
        //     } else {
        //         $fname = '';
        //     }
        // } else {
        //     $fname = '';
        // }

        $assets_id = $this->input->post('hidden_assets_id');
                $asset_master_id= $this->Assets_model->get_asset_id_from_asset_master($assets_id);
        $name=$asset_master_id[0]->name;
   
              
        $data = array(
      
            'handover_date' => $this->input->post('handover_date'),
            'handever_by' => $this->input->post('handover_by'),
            'enter_by' => $this->input->post('entered_by'),
            'hand_over_image' =>  $this->input->post('attachment'),
            'assets_id' => $this->input->post('hidden_assets_id'),
            'asset_master_id'=>$name,
            'hand_is_working' => $this->input->post('handover_is_working'),
            'cash_collected' => $this->input->post('cash_collected'),
            'description' => $this->input->post('description'),
            'status'=>'0'
           
        );
    

        $Return['error'] = "";
        // $assets_id_details = $this->Assets_model->get_asset_return($assets_id);
   $assets_id_details = $this->Assets_model->get_asset_return_check($name);

        if (empty($assets_id_details)) {
            if (isset($assets_id)) {
                $result = $this->Assets_model->update_asset_return($data, $assets_id);
                  $this->db->set('status', 'Not In Use');
              $this->db->set('return_status', '0');
$this->db->where('id', $name);
$this->db->update('xin_assets_master');
                $Return['result'] = "Data Saved success";
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
        } else {
            $Return['error'] = 'Asset already returned';
        }

        $this->output($Return);
        exit;
    }

    public function update_asset_return_validate()
    {
        $old_asset_return = $this->Assets_model->get_all_assets_return_single_val($this->input->post('hidden_assets_id'));
        if ($this->input->post('handover_date_edit') === '') {
				$Return['error'] = "Select handover date";
			} else if ($this->input->post('handover_by_edit') === '') {
				$Return['error'] = "Enter handover by";
			} else if ($this->input->post('entered_by') === '') {
				$Return['error'] = "Entered by is required";
			} else if (isset($_FILES['asset_handover_image']['tmp_name'])) {
            if (is_uploaded_file($_FILES['asset_handover_image']['tmp_name'])) {
                //checking image type
                $allowed = array('png', 'jpg', 'jpeg', 'gif');
                $filename = $_FILES['asset_handover_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);

                if (in_array($ext, $allowed)) {
                    $tmp_name = $_FILES["asset_handover_image"]["tmp_name"];
                    $asset_image = "uploads/asset_image/";
                    // basename() may prevent filesystem traversal attacks;
                    // further validation/sanitation of the filename may be appropriate
                    $lname = basename($_FILES["asset_handover_image"]["name"]);
                    $newfilename = 'asset_handover_image_' . round(microtime(true)) . '.' . $ext;
                    move_uploaded_file($tmp_name, $asset_image . $newfilename);
                    $fname = $newfilename;
                    $Return['fileName'] = $newfilename;
                    
                } else {
                    $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
                }
            } else {
                $fname = $old_asset_return[0]->hand_over_image;
            }
        }
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $Return['error'] = '';
        
        $this->output($Return);
        exit;
    }
    
    public function update_asset_return()
    {
        $old_asset_return = $this->Assets_model->get_all_assets_return_single_val($this->input->post('hidden_assets_id'));
  
        if ($this->input->post('hand_over_is_working_edit') == 0) {
            $cash_collected = $this->input->post('cash_collected_edit');
        } else {
            $cash_collected = '';
        }
        $assets_id = $this->input->post('hidden_assets_id');
        
        if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {
        $data = array(
            'handover_date' => $this->input->post('handover_date_edit'),
            'handever_by' => $this->input->post('handover_by_edit'),
            'enter_by' => $this->input->post('entered_by'),
            'hand_is_working' => $this->input->post('hand_over_is_working_edit'),
            'cash_collected' => $cash_collected,
            'description' => $this->input->post('description_return_edit')
        );
        }
        else
        {
            $data = array(
            'handover_date' => $this->input->post('handover_date_edit'),
            'handever_by' => $this->input->post('handover_by_edit'),
            'enter_by' => $this->input->post('entered_by'),
            'hand_over_image' => $this->input->post('attachment'),
            'hand_is_working' => $this->input->post('hand_over_is_working_edit'),
            'cash_collected' => $cash_collected,
            'description' => $this->input->post('description_return_edit')
        );
        }
        //echo $assets_id;exit;
        if (isset($assets_id)) {
            $result = $this->Assets_model->update_asset_return_new($data, $assets_id);
            $Return['error'] = '';
            $Return['result'] = "Data Updated";
        } else {
            $Return['error'] = $this->lang->line('xin_error_msg');
        }

        $this->output($Return);
        exit;
    }

    public function assets_list_returns()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();

        if (!empty($session)) {
            $this->load->view("admin/languages/languages_list", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $role_resources_ids = $this->Xin_model->user_role_resource();
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        $assets = $this->Assets_model->get_assets_return();

        $data = array();

        foreach ($assets->result() as $r) {
            // get company

            if (!is_null($r->handover_date)) {
                $handover_date = $r->handover_date;
            } else {
                $handover_date = '--';
            }
            if (!is_null($r->handever_by)) {
                $handover_by = $r->handever_by;
            } else {
                $handover_by = '--';
            }
            if (!is_null($r->enter_by)) {
                $enter_by = $r->enter_by;
                $enter_bynew = $this->Assets_model->get_employee($enter_by);
                
                
                if ($enter_bynew) {
                    $enter_by_name = $enter_bynew[0]->first_name . " " . $enter_bynew[0]->middle_name . ' ' . $enter_bynew[0]->last_name;
                }
            } else {
                $enter_by_name = '--';
            }
            if (!is_null($r->assets_id)) {
                $assets_id = $r->assets_id;
            } else {
                $assets_id = '--';
            }
            if (!is_null($r->hand_is_working)) {
                if ($r->hand_is_working == 1) {
                    $hand_is_working = 'Working';
                } else {
                    $hand_is_working = "Not working";
                }
            } else {
                $hand_is_working = '--';
            }
            if (!is_null($r->cash_collected)) {
                $cash_collected = $r->cash_collected;
            } else {
                $cash_collected = '--';
            }
            if (!is_null($r->description)) {
                $description = $r->description;
            } else {
                $description = '--';
            }
            if (in_array('208', $role_resources_ids)) { //edit
                //		$edit = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_edit').'"><input type="hidden" value="ar" id="page_return"><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->assets_id . '"><span class="fa fa-pencil"></span></button></span>';
                $edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><input type="hidden" value="ar" id="page_return"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '"><span class="fas fa-pencil-alt"></span></button></span>';
            } else {
                $edit = '';
            }
            if (in_array('209', $role_resources_ids)) { // delete
                // $delete = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-xs btn-danger waves-effect waves-light delete_return" data-toggle="modal" data-target=".delete-modal" data-record-ret-id="' . $r->assets_id . '"><span class="fa fa-trash"></span></button></span>';
                $delete = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete_return" data-toggle="modal" data-target=".delete-modal" data-record-ret-id="' . $r->assets_id . '"><span class="fas fa-trash-restore"></span></button></span>';
            } else {
                $delete = '';
            }
            if (in_array('210', $role_resources_ids)) { //view
                //	$view = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_view').'"><input type="hidden" value="ar" id="page_return_view"><button type="button" class="btn icon-btn btn-xs btn-default waves-effect waves-light" data-toggle="modal" data-target=".view-modal-data" data-asset_id="'. $r->assets_id . '"><span class="fa fa-eye"></span></button></span>';
                //	$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".view-modal-data" data-field_id="'. $r->assets_id . '"><span class="fa fa-eye"></span></button></span>';
                $view = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><input type="hidden" value="ar" id="page_return_view"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-asset_id="' . $r->id . '"><span class="fa fa-eye"></span></button></span>';
            } else {
                $view = '';
            }
            $combhr = $edit . $view . $delete;
            $result_Assets = $this->Assets_model->read_assets_info($r->assets_id);
            //  var_dump( $result_Assets[0]->employee_id);
            if ($result_Assets) {
                $this->db->where('id', $result_Assets[0]->name);
                $asset_master = $this->db->get('xin_assets_master')->row();
                if ($asset_master) {
                    $name_asset = $asset_master->name;
                } else {
                    $name_asset = $result_Assets[0]->name;
                }
                $assign_date = $result_Assets[0]->asset_assigned_date;
                // get category
                $assets_category = $this->Assets_model->read_assets_category_info($result_Assets[0]->assets_category_id);
                if (!is_null($assets_category)) {
                    $category = $assets_category[0]->category_name;
                } else {
                    $category = '--';
                }
                $enter_by_Assets = $this->Assets_model->get_employee($result_Assets[0]->employee_id);
                // print_r($enter_by_Assets);
                if ($enter_by_Assets) {
                    $enter_by_Assets = $enter_by_Assets[0]->first_name . " " . $enter_by_Assets[0]->middle_name . ' ' . $enter_by_Assets[0]->last_name;
                } else {
                    $enter_by_Assets = '--';
                }
            } else {
                $name_asset = '';
                $assign_date = '--';
                $enter_by_Assets = '--';
                $category = '--';
            }

            if (in_array('208', $role_resources_ids) || in_array('209', $role_resources_ids) || in_array('210', $role_resources_ids)) {
                $data[] = array(

                    $name_asset,
                    $category,
                    $enter_by_Assets,
                    $assign_date,
                    $handover_date,
                    //  $handover_by,

                    $hand_is_working,
                    //  $cash_collected,
                    //  $description
                    $combhr,
                );
            } else {
                $data[] = array(
                    $name_asset,
                    $category,
                    $enter_by_name,
                    $assign_date,
                    $handover_date,
                    //  $handover_by,

                    $hand_is_working,
                    //  $cash_collected,
                    //  $description
                );
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $assets->num_rows(),
            "recordsFiltered" => $assets->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function delete_asset_ret()
    {
        $id = $this->uri->segment(4);
        if ($this->input->post('type') == 'delete_record') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $id = $this->uri->segment(4);
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $result = $this->Assets_model->delete_assets_ret_record($id);
            if (isset($id)) {
                $Return['result'] = "Assets return deleted";
            } else {
                $Return['error'] = $this->lang->line('xin_error_msg');
            }
            $this->output($Return);
        }
    }

    function asset_read_return()
    {
        // echo "hi";exit;
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        $id = $this->input->get('asset_id');

        $result1 = $this->Assets_model->read_assets_return_info_new($id);
        $assets_id = $result1[0]->assets_id;
        $result2 = $this->Assets_model->read_assets_info($assets_id);

        if (isset($result2[0]->invoice_number)) {
            $inv_no = $result2[0]->invoice_number;
        } else {
            $inv_no = '';
        }
        if (isset($result2[0]->assets_category_id)) {
            $ast_cat_id = $result2[0]->assets_category_id;
        } else {
            $ast_cat_id = '';
        }
        if (isset($result2[0]->assets_id)) {
            $asset_id = $result2[0]->assets_id;
        } else {
            $asset_id = '';
        }
        if (isset($result2[0]->purchase_date)) {
            $purchase_date = $result2[0]->purchase_date;
        } else {
            $purchase_date = '';
        }
        if (isset($result2[0]->manufacturer)) {
            $manufacturer = $result2[0]->manufacturer;
        } else {
            $manufacturer = '';
        }
        if (isset($result2[0]->company_id)) {
            $company_id = $result2[0]->company_id;
        } else {
            $company_id = '';
        }
        if (isset($result2[0]->employee_id)) {
            $employee_id = $result2[0]->employee_id;
        } else {
            $employee_id = '';
        }
        if (isset($result2[0]->company_asset_code)) {
            $company_asset_code = $result2[0]->company_asset_code;
        } else {
            $company_asset_code = '';
        }
        if (isset($result2[0]->name)) {
            $name = $result2[0]->name;
        } else {
            $name = '';
        }
        if (isset($result2[0]->serial_number)) {
            $serial_number = $result2[0]->serial_number;
        } else {
            $serial_number = '';
        }
        if (isset($result2[0]->warranty_end_date)) {
            $warranty_end_date = $result2[0]->warranty_end_date;
        } else {
            $warranty_end_date = '';
        }

        if (isset($result2[0]->asset_note)) {
            $asset_note = $result2[0]->asset_note;
        } else {
            $asset_note = '';
        }

        if (isset($result2[0]->asset_note)) {
            $asset_image = $result2[0]->asset_image;
        } else {
            $asset_image = '';
        }
        if (isset($result2[0]->is_working)) {
            $is_working = $result2[0]->is_working;
        } else {
            $is_working = '';
        }
        if (isset($result2[0]->created_at)) {
            $created_at = $result2[0]->created_at;
        } else {
            $created_at = '';
        }
        if (!is_null($result1[0]->enter_by)) {
            $enter_by = $result1[0]->enter_by;
            $enter_by = $this->Assets_model->get_employee($enter_by);
            if ($enter_by) {
                $enter_by = $enter_by[0]->first_name . " " . $enter_by[0]->middle_name . ' ' . $enter_by[0]->last_name;
            }
        } else {
            $enter_by = '--';
        }
        //print_R($result1[0]);exit;//
        $data = array(
            'id' => $result1[0]->id,
            'assets_id' => $asset_id,
            'assets_category_id' => $ast_cat_id,
            'company_id' => $company_id,
            'employee_id' => $employee_id,
            'company_asset_code' => $company_asset_code,
            'name' => $name,
            'purchase_date' => $purchase_date,
            'invoice_number' => $inv_no,
            'manufacturer' => $manufacturer,
            'serial_number' => $serial_number,
            'warranty_end_date' => $warranty_end_date,
            'asset_note' => $asset_note,
            'asset_image' => $asset_image,
            'is_working' => $is_working,
            'created_at' => $created_at,
            'all_employees' => $this->Xin_model->all_employees(),
            'all_assets_categories' => $this->Assets_model->get_all_assets_categories(),
            'all_companies' => $this->Xin_model->get_companies(),
            'assets_id_return' => $result1[0]->assets_id,
            'assets_return_id' => $result1[0]->id,
            'handover_date_return' => $result1[0]->handover_date,
            'handever_by_return' => $result1[0]->handever_by,
            'enter_by_return' => $enter_by,
            'hand_over_image_return' => $result1[0]->hand_over_image,
            'hand_is_working_return' => $result1[0]->hand_is_working,
            'cash_collected_return' => $result1[0]->cash_collected,
            'description_return' => $result1[0]->description,
            'enter_by_return_id' => $result1[0]->enter_by,
        );
        if (!empty($session)) {
            $this->load->view('admin/assets/dialog_asset_return', $data);
        } else {
            redirect('admin/');
        }
    }

    public function get_all_assets_name()
    {
        $asset_name = $this->input->get('assets_name');
        $category_id = $this->input->get('category_id');

        $data = $this->Assets_model->get_all_assets_name_single($category_id, $asset_name, '');
        $arr = [];
        for ($i = 0; $i < count($data); $i++) {
            if (isset($data[$i]->is_wroking) && $data[$i]->is_wroking != '') {
                $is_working = $data[$i]->is_wroking;
            } else {
                $is_working = '';
            }
            $cat = $this->Assets_model->get_cat($data[$i]->assets_category_id);
            $company = $this->Assets_model->get_company($data[$i]->company_id);
            $emp = $this->Assets_model->get_employee($data[$i]->employee_id);
            // print_r($cat[0]->category_name);
            $employee_id = $data[$i]->employee_id;
            $full_name = $this->Assets_model->get_all_emp_name_single($employee_id);
            $arr['emp_name'] = $emp[0]->first_name . ' ' . $emp[0]->middle_name . ' ' . $emp[0]->last_name;
            $arr['assets_id'] = $data[$i]->assets_id;
            $arr['assets_category_id'] = $cat[0]->category_name;
            $arr['category_id'] = $cat[0]->assets_category_id;
            $arr['company_id'] = $company[0]->name;
            $arr['employee_id'] = $emp[0]->first_name;
            $arr['name'] = $data[$i]->name;
            $arr['purchase_date'] = $data[$i]->purchase_date;
            $arr['invoice_number'] = $data[$i]->invoice_number;
            $arr['manufacturer'] = $data[$i]->manufacturer;
            $arr['serial_number'] = $data[$i]->serial_number;
            $arr['warranty_end_date'] = $data[$i]->warranty_end_date;
            $arr['asset_note'] = $data[$i]->asset_note;
            $arr['asset_image'] = $data[$i]->asset_image;
            $arr['is_wroking'] = $is_working;
            $arr['company_asset_code'] = $data[$i]->company_asset_code;
        }

        $status = json_encode($arr);
        print_r($status);
        exit;
    }

    public function get_select_assets_name()
    {
        $assets_id = $this->input->get('assets_id');
        $type = $this->input->get('type');
        $data['assets_id'] = $assets_id;
        $data['type'] = $type;
        if ($type == 0) {
            $data['all_assets_names'] = $this->Assets_model->get_all_assets_name();
        } else {
            $data['all_assets_categories'] = $this->Assets_model->get_all_assets_categories();
        }
        $this->load->view('admin/assets/select_box_assets_return', $data);
    }

    public function get_all_detailes_by_cat()
    {
        $html = '';
        $category_id = $this->input->get('cat_id');
        $data = $this->Assets_model->get_all_assets_name_single_val($category_id);
        $html .= '<option value=""></option>';
        if ($data) {
            foreach ($data as $asset_det) {
                $html .= '<option value="' . $asset_det->assets_id . '">' . $asset_det->name . '</option>';
            }
        }

        $status = json_encode($html);
        print_r($status);
        exit;
    }

    // List Assets master data
    public function assets_master_list()
    {
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $output = array(
            "draw" => $draw,
            "recordsTotal" => 0,
            "recordsFiltered" => 0,
            "data" => array(),
        );

        $session = $this->session->userdata('username');
        if (empty($session)) {
            $this->output($output);
        }

        $role_resources_ids = $this->Xin_model->user_role_resource();
        $user_info = $this->Xin_model->read_user_info($session['user_id']);

        $assets = $this->db->get('xin_assets_master');

        $data = array();

        foreach ($assets->result() as $asset) {
            $company = $this->Xin_model->read_company_info($asset->company_id);

            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            $location = $this->Location_model->read_location_information($asset->location_id);

            if (!is_null($location)) {
                $location_name = $location[0]->location_name;
            } else {
                $location_name = '--';
            }

            // get category
            $assets_category = $this->Assets_model->read_assets_category_info($asset->category_id);
            $assets_type = $this->Assets_model->read_assets_asset_type($asset->id);
            $asset_type = $assets_type[0]->asset_type;
            
            $custdy = $this->Assets_model->get_assets_assigned_employee($asset->id);

// print_r($custdy);
// exit;
            if (!empty($custdy)) {
                //   print_r($custdy);
                // list is empty.

                $user1 = $custdy[0]->employee_id;
                 
                $user = $this->Xin_model->read_user_info($custdy[0]->employee_id);

                if ($user1 && $asset->status =="In Use") {

                    $custody1 = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
                    $custody2 = $user[0]->first_name;

                    $custody = '<span data-toggle="tooltip" data-placement="top" data-state="primary" 
				title="' . $custody1  . '">
				<a href="' . site_url() . 'admin/assets/assets_details/id/' . $custdy[0]->employee_id . '/' . $custody2 . '">
				' . $custody1 . '</a></span>';
                } else {


                    $custody = '--';
                }
            } else {
                $custody = '--';
            }






            if (!is_null($assets_category)) {
                $category = $assets_category[0]->category_name;
            } else {
                $category = '--';
            }

            if (in_array('245', $role_resources_ids)) { //edit
                $edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $asset->id . '"><span class="fas fa-pencil-alt"></span></button></span>';
            } else {
                $edit = '';
            }
            if (in_array('246', $role_resources_ids)) { // delete
                $delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $asset->id . '"><span class="fas fa-trash-restore"></span></button></span>';
            } else {
                $delete = '';
            }
            if (in_array('247', $role_resources_ids)) { //view
                $view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-asset_id="' . $asset->id . '"><span class="fa fa-eye"></span></button></span>';
            } else {
                $view = '';
            }

            $combhr = $edit . $view . $delete;

            if (in_array('245', $role_resources_ids) || in_array('246', $role_resources_ids) || in_array('247', $role_resources_ids)) {
                $data[] = array(
                    $asset->code,
                            $asset->name,
                    $comp_name,
                    $location_name,
            
                      $asset->status,
                    $asset_type,
                    $custody,
                    $combhr,

                );
            } else {
                $data[] = array(
                          $asset->code,
                            $asset->name,
                      $comp_name,
                    $location_name,
            
                    $asset->status,
                    $asset_type->asset_type,
                    $custody,

                );
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $assets->num_rows(),
            "recordsFiltered" => $assets->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    // 	Read Assets master data
    public function asset_master_read()
    {
        $id = $this->input->get('asset_id');

        $this->db->where('id', $id);
        $asset = $this->db->get('xin_assets_master')->row();

        $data = array(
            'asset' => $asset,
            'all_employees' => $this->Xin_model->all_employees(),
            'all_assets_categories' => $this->Assets_model->get_all_assets_categories(),
            'all_companies' => $this->Xin_model->get_companies()
        );

        $this->load->view('admin/assets/dialog_asset_master', $data);
    }

    // Assets master data
    public function add_validate()
    {
        if ($this->input->post('add_assets')) {
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            if ($this->input->post('company_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_company');
            } else if ($this->input->post('location_id') === '') {
                $Return['error'] = "Select company location";
            } else if ($this->input->post('category_id') === '') {
                $Return['error'] = "Select category";
            } else if ($this->input->post('name') === '') {
                $Return['error'] = "Enter asset name";
            } else if ($this->input->post('asset_type') === '') {
                $Return['error'] = "Select asset type";
            } else if ($this->input->post('code') === '') {
                $Return['error'] = "Enter company asset code";
            } else if ($this->input->post('purchase_date') === '') {
                $Return['error'] = "Enter purchase date";
            } else if ($this->input->post('invoice_number') === '') {
                $Return['error'] = "Enter invoice number";
            } else if ($this->input->post('warrenty_end_date') === '') {
                $Return['error'] = "Enter warrenty end date";
            } else if ($this->input->post('assetImage') == 0) {
                $Return['error'] = "Select asset image";
            } else if ($this->input->post('manufacturer') === '') {
                $Return['error'] = "Manufacturer is required";
            } else if ($this->input->post('serial_number') === '') {
                $Return['error'] = "Serial number is required";
            }
   
            $dup_code = $this->input->post('code');
                $company_id=$this->input->post('company_id');
            $sql = "SELECT * from xin_assets_master where code = '$dup_code' AND company_id='$company_id'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $count = 1;
            } else {
                $count = 0;
            }

            if ($count == '1') {

                $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
                $Return['csrf_hash'] = $this->security->get_csrf_hash();
                $Return['error'] = 'Company Asset Code All Ready Exist';
            } else {

                $image = NULL;

                if (is_uploaded_file($_FILES['asset_image']['tmp_name'])) {
                    $allowed = array('png', 'jpg', 'jpeg', 'gif');
                    $filename = $_FILES['asset_image']['name'];
                    $ext = pathinfo($filename, PATHINFO_EXTENSION);

                    if (in_array($ext, $allowed)) {
                        $tmp_name = $_FILES["asset_image"]["tmp_name"];
                        $asset_image = "uploads/asset_image/";
                        $lname = basename($_FILES["asset_image"]["name"]);
                        $newfilename = 'asset_master_' . round(microtime(true)) . '.' . $ext;
                        move_uploaded_file($tmp_name, $asset_image . $newfilename);
                        $image = $newfilename;
                        $Return['fileName'] = $newfilename;
                    }
                }
            }

            $this->output($Return);
        }


        $data['title'] = $this->lang->line('xin_assets') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_assets');
        $data['path_url'] = 'assets';
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_assets_categories'] = $this->Assets_model->get_all_assets_categories();
        if (in_array('244', $role_resources_ids)) {
            $id = $this->uri->segment(4);
            $edata = array(
                'is_notify' => 0,
            );
            $this->Xin_model->update_notification_record($edata, $id, $session['user_id'], 'asset');
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/assets/assets_add", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function add()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $system = $this->Xin_model->read_setting_info(1);
        if ($system[0]->module_assets != 'true') {
            redirect('admin/dashboard');
        }



        if ($this->input->post('add_assets')) {

            $dup_code = $this->input->post('code');
            $company_id=$this->input->post('company_id');
            $sql = "SELECT * from xin_assets_master where code = '$dup_code' AND company_id='$company_id'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $count = 1;
            } else {
                $count = 0;
            }

            if ($count == '1') {

                $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
                $Return['csrf_hash'] = $this->security->get_csrf_hash();
                $Return['error'] = 'Company Asset Code All Ready Exist';
            } else {

                $image = NULL;


                $this->db->insert('xin_assets_master', array(
                    'company_id' => $this->input->post('company_id'),
                    'location_id' => $this->input->post('location_id'),
                    'category_id' => $this->input->post('category_id'),
                    'name' => $this->input->post('name'),
                    'asset_type' => $this->input->post('asset_type'),
                    'code' => $this->input->post('code'),
                    'purchase_date' => $this->input->post('purchase_date'),
                    'invoice_number' => $this->input->post('invoice_number'),
                    'warrenty_end_date' => $this->input->post('warrenty_end_date'),
                    'manufacturer' => $this->input->post('manufacturer'),
                    'serial_number' => $this->input->post('serial_number'),
                    'remarks' => $this->input->post('remarks'),
                       'status' => "Not In Use",
                    'image' => $this->input->post('attachment'),
                ));

                $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
                $Return['csrf_hash'] = $this->security->get_csrf_hash();
                $Return['result'] = $this->lang->line('xin_success_asset_added');
                $Return['form_status'] = 1;
            }

            $this->output($Return);
        }

        $data['title'] = $this->lang->line('xin_assets') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_assets');
        $data['path_url'] = 'assets';
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_assets_categories'] = $this->Assets_model->get_all_assets_categories();
        if (in_array('244', $role_resources_ids)) {
            $id = $this->uri->segment(4);
            $edata = array(
                'is_notify' => 0,
            );
            $this->Xin_model->update_notification_record($edata, $id, $session['user_id'], 'asset');
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/assets/assets_add", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    // Update Assets master
    public function update_master_validate($id)
    {
        $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
        if ($this->input->post('company_id') === '') {
            $Return['error'] = $this->lang->line('xin_error_company');
        } else if ($this->input->post('location_id') === '') {
            $Return['error'] = "Select company location";
        } else if ($this->input->post('category_id') === '') {
            $Return['error'] = "Select category";
        } else if ($this->input->post('name') === '') {
            $Return['error'] = "Enter asset name";
        } else if ($this->input->post('asset_type') === '') {
            $Return['error'] = "Select asset type";
        } else if ($this->input->post('code') === '') {
            $Return['error'] = "Enter company asset code";
        } else if ($this->input->post('purchase_date') === '') {
            $Return['error'] = "Enter purchase date";
        } else if ($this->input->post('invoice_number') === '') {
            $Return['error'] = "Enter invoice number";
        } else if ($this->input->post('warrenty_end_date') === '') {
            $Return['error'] = "Enter warrenty end date";
        } else if ($this->input->post('manufacturer') === '') {
            $Return['error'] = "Manufacturer is required";
        } else if ($this->input->post('serial_number') === '') {
            $Return['error'] = "Serial number is required";
        }

        if (is_uploaded_file($_FILES['asset_image']['tmp_name'])) {
            $allowed = array('png', 'jpg', 'jpeg', 'gif');
            $filename = $_FILES['asset_image']['name'];
            $ext = pathinfo($filename, PATHINFO_EXTENSION);

            if (in_array($ext, $allowed)) {
                $asset_image = "uploads/asset_image/";
                $tmp_name = $_FILES["asset_image"]["tmp_name"];
                $lname = basename($_FILES["asset_image"]["name"]);
                $newfilename = 'asset_master_' . round(microtime(true)) . '.' . $ext;
                move_uploaded_file($tmp_name, $asset_image . $newfilename);
                $image = $newfilename;
                $Return['fileName'] = $newfilename;
            }
        }
        $this->output($Return);
    }

    public function update_master($id)
    {

        if ($id == '') {
            $id = $this->input->post('pop_asset_ids_edit');
        }
        $this->db->where('id', $id);
        $asset = $this->db->get('xin_assets_master')->row();

        $image = $asset->image;
        if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined'){
            $image = $asset->image;
        }
        else
        {
            $image = $this->input->post('attachment');
        }

        $dup_code = $this->input->post('code');
        $asset_code_check = $this->Assets_model->update_master_asset_code_check($id);
        if (!is_null($asset_code_check)) {
            $asset_code_get = $asset_code_check[0]->code;
        } else {
            $asset_code_get = '';
        }

        if ($dup_code == $asset_code_get) {

            $this->db->where('id', $asset->id);
            $this->db->update('xin_assets_master', array(
                'company_id' => $this->input->post('company_id'),
                'location_id' => $this->input->post('location_id'),
                'category_id' => $this->input->post('category_id'),
                'name' => $this->input->post('name'),
                     'asset_type' => $this->input->post('asset_type'),
                'code' => $this->input->post('code'),
                'purchase_date' => $this->input->post('purchase_date'),
                'invoice_number' => $this->input->post('invoice_number'),
                'warrenty_end_date' => $this->input->post('warranty_end_date'),
                'manufacturer' => $this->input->post('manufacturer'),
                'serial_number' => $this->input->post('serial_number'),
                'remarks' => $this->input->post('remarks'),
                'image' => $image,
                'status' => $this->input->post('status')
            ));

            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $Return['result'] = $this->lang->line('xin_success_asset_updated');
        } else {

            $sql = "SELECT * from xin_assets_master where code = '$dup_code'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $count = 1;
            } else {
                $count = 0;
            }

            if ($count == '1') {

                $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
                $Return['csrf_hash'] = $this->security->get_csrf_hash();
                $Return['error'] = 'Company Asset Code All Ready Exist';
            } else {


                $this->db->where('id', $asset->id);
                $this->db->update('xin_assets_master', array(
                    'company_id' => $this->input->post('company_id'),
                    'location_id' => $this->input->post('location_id'),
                    'category_id' => $this->input->post('category_id'),
                    'name' => $this->input->post('name'),
                    'code' => $this->input->post('code'),
                    'purchase_date' => $this->input->post('purchase_date'),
                    'invoice_number' => $this->input->post('invoice_number'),
                    'warrenty_end_date' => $this->input->post('warranty_end_date'),
                    'manufacturer' => $this->input->post('manufacturer'),
                    'serial_number' => $this->input->post('serial_number'),
                    'remarks' => $this->input->post('remarks'),
                    'image' => $image,
                ));

                $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
                $Return['csrf_hash'] = $this->security->get_csrf_hash();
                $Return['result'] = $this->lang->line('xin_success_asset_updated');
            }
        }

        $this->output($Return);
    }
        public function asset_master_options_return()
    {
        $company_id = (int) $this->input->get('company_id');
        $location_id = (int) $this->input->get('location_id');
        $category_id = (int) $this->input->get('category_id');

        if ($company_id > 0)
            $this->db->where('company_id', $company_id);
        if ($location_id > 0)
            $this->db->where('location_id', $location_id);
        if ($category_id > 0)
            $this->db->where('category_id', $category_id);
               $this->db->where('return_status',1);
        $assets = $this->db->get('xin_assets_master');
        $output = '<select name="asset_id" id="asset_id" data-plugin="select_hrm" class="form-control">';
        $output .= '<option value="0"></option>';
        foreach ($assets->result() as $asset) {
            $output .= '<option value="' . $asset->id . '">' . $asset->name . '</option>';
        }
        $output .= '</select>';
        $this->output(array(
            'options' => $output,
        ));
    }

    public function asset_master_options()
    {
        $company_id = (int) $this->input->get('company_id');
        $location_id = (int) $this->input->get('location_id');
        $category_id = (int) $this->input->get('category_id');

        if ($company_id > 0)
            $this->db->where('company_id', $company_id);
        if ($location_id > 0)
            $this->db->where('location_id', $location_id);
        if ($category_id > 0)
            $this->db->where('category_id', $category_id);
     
        $assets = $this->db->get('xin_assets_master');
        $output = '<select name="asset_id" id="asset_id" data-plugin="select_hrm" class="form-control">';
        $output .= '<option value="0"></option>';
        foreach ($assets->result() as $asset) {
            $output .= '<option value="' . $asset->id . '">' . $asset->name . '</option>';
        }
        $output .= '</select>';
        $this->output(array(
            'options' => $output,
        ));
    }

    public function asset_master_read_ajax()
    {
        $asset_id = $this->input->get('asset_id');

        $this->db->where('id', $asset_id);
        $asset = $this->db->get('xin_assets_master')->row();

        $this->output($asset);
    }

    public function asset_assigned_data()
    {
        $asset_id = $this->input->get('asset_id');

        $this->db->where('name', $asset_id);
        $this->db->order_by('assets_id','DESC');
        $asset = $this->db->get('xin_assets')->row();

        $employee = $this->Employees_model->read_employee_information($asset->employee_id);
        $asset->employee_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

        $this->output($asset);
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function add_category_validate()
    {

        if ($this->input->post('add_type') == 'add_category') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('name') === '') {
                $Return['error'] = $this->lang->line('xin_error_cat_name_field');
            }

            $dup_name = $this->input->post('name');
            $sql = "SELECT * from xin_assets_categories where category_name = '$dup_name'";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                $count = 1;
            } else {
                $count = 0;
            }

            if ($count == '1') {
                $Return['error'] = 'Category All Ready Exist';
            }



            if ($Return['error'] != '') {
                $this->output($Return);
            }
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $this->output($Return);
            exit;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////// 

    public function assets_details()
    {

        $session = $this->session->userdata('username');

        $id = $this->uri->segment(5);
        $name = $this->uri->segment(6);

        if (empty($session)) {
            redirect('admin/');
        }
        $system = $this->Xin_model->read_setting_info(1);
        if ($system[0]->module_assets != 'true') {
            redirect('admin/dashboard');
        }
        $data['title'] = $this->lang->line('left_issue') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = '';
        $data['path_url'] = 'assets';
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_assets_categories'] = $this->Assets_model->read_assets_info_emo($id);


        if (in_array('195', $role_resources_ids)) {
            $id = $this->uri->segment(4);
            $edata = array(
                'is_notify' => 0,
            );
            $this->Xin_model->update_notification_record($edata, $id, $session['user_id'], 'asset');
            if (!empty($session)) {

                $data['subview'] = $this->load->view("admin/assets/assets_list_view", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {

                redirect('admin/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////
    public function add_asset_validate()
    {
       

        if ($this->input->post('add_type') == 'add_asset') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('category_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_category_field');
            } else if ($this->input->post('asset_id') == 0) {
                $Return['error'] ="Asset Name is required"; }
                else if ($this->input->post('company_id') === '') {
                $Return['error'] = $this->lang->line('error_company_field');
            } else if ($this->input->post('employee_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_employee_id');
            }
               else if ($_FILES['asset_image']['size'] == 0) {
$Return['error'] = "No file choosen";

            } else {
                $this->input->post('asset_id');
              
                
                $this->db->where('id', $this->input->post('asset_id'));
                $this->db->where('return_status', 1);
               $assest_assigned = $this->db->get('xin_assets_master');
           
         
                if ($assest_assigned->num_rows() > 0) {
                    
                    $Return['error'] = "Asset already assigned";
                }
            }

            if ($Return['error'] != '') {
                $this->output($Return);
            }
            if (is_uploaded_file($_FILES['asset_image']['tmp_name'])) {
                //checking image type
                $allowed = array('png', 'jpg', 'jpeg', 'gif');
                $filename = $_FILES['asset_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);

                if (in_array($ext, $allowed)) {
                    $tmp_name = $_FILES["asset_image"]["tmp_name"];
                    $asset_image = "uploads/asset_image/";
                    // basename() may prevent filesystem traversal attacks;
                    // further validation/sanitation of the filename may be appropriate
                    $lname = basename($_FILES["asset_image"]["name"]);
                    $newfilename = 'asset_image_' . round(microtime(true)) . '.' . $ext;
                    move_uploaded_file($tmp_name, $asset_image . $newfilename);
                    $fname = $newfilename;
                    $Return['fileName'] = $fname;
                } else {
                    $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
                }
            } else {
                $fname = '';
            }
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
            $this->output($Return);
            exit;
        }
    }
    public function save_asset_return_validate()
    {
        $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
        $Return['csrf_hash'] = $this->security->get_csrf_hash();

        /* Server side PHP input validation */
        if ($this->input->post('handover_date') == '') {
            $Return['error'] = 'Handover Date feild is required';
        } else if ($this->input->post('handover_by') == '') {
            $Return['error'] = 'Handover By feild is required';
        } else if ($this->input->post('hidden_assets_id') == '') {
            $Return['error'] = $this->lang->line('xin_error_asset_name_field');
        }

        if ($Return['error'] != '') {
            $this->output($Return);
            exit();
        }
        if (isset($_FILES['asset_handover_image']['tmp_name'])) {
            if (is_uploaded_file($_FILES['asset_handover_image']['tmp_name'])) {
                //checking image type
                $allowed = array('png', 'jpg', 'jpeg', 'gif');
                $filename = $_FILES['asset_handover_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if (in_array($ext, $allowed)) {
                    $tmp_name = $_FILES["asset_handover_image"]["tmp_name"];
                    $asset_image = "uploads/asset_image/";
                    // basename() may prevent filesystem traversal attacks;
                    // further validation/sanitation of the filename may be appropriate
                    $lname = basename($_FILES["asset_handover_image"]["name"]);
                    $newfilename = 'asset_handover_image_' . round(microtime(true)) . '.' . $ext;
                    move_uploaded_file($tmp_name, $asset_image . $newfilename);
                    $fname = $newfilename;
                    $Return['fileName'] = $fname;
                } else {
                    $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
                }
            } else {
                $fname = '';
            }
        } else {
            $fname = '';
        }
        if (isset($_FILES['asset_image']['tmp_name'])) {
            if (is_uploaded_file($_FILES['asset_image']['tmp_name'])) {
                //checking image type
                $allowed = array('png', 'jpg', 'jpeg', 'gif');
                $filename = $_FILES['asset_image']['name'];
                $ext = pathinfo($filename, PATHINFO_EXTENSION);
                if (in_array($ext, $allowed)) {
                    $tmp_name = $_FILES["asset_image"]["tmp_name"];
                    $asset_image = "uploads/asset_image/";
                    // basename() may prevent filesystem traversal attacks;
                    // further validation/sanitation of the filename may be appropriate
                    $lname = basename($_FILES["asset_image"]["name"]);
                    $newfilename = 'asset_image_' . round(microtime(true)) . '.' . $ext;
                    move_uploaded_file($tmp_name, $asset_image . $newfilename);
                    $fname1 = $newfilename;
                    $Return['fileName1'] = $fname1;
                } else {
                    $Return['error'] = $this->lang->line('xin_error_asset_image_attachment');
                }
            } else {
                $fname = '';
            }
        } else {
            $fname = '';
        }
                    $assets_id = $this->input->post('hidden_assets_id');
            $asset_master_id= $this->Assets_model->get_asset_id_from_asset_master($assets_id);
            $name=$asset_master_id[0]->name;
            
            $Return['error'] = "";
            $assets_id_details = $this->Assets_model->get_asset_return_check($name);
            
            
            
            if (empty($assets_id_details)) {
            $Return['error'] = '';
            
            } else {
            $Return['error'] = 'Asset already returned';
                }
        $this->output($Return);
        exit;
    }
}
