<?php

/**

 * NOTICE OF LICENSE

 *

 * This source file is subject to the HRSALE License

 * that is bundled with this package in the file license.txt.

 * It is also available through the world-wide-web at this URL:

 * http://www.hrsale.com/license.txt

 * If you did not receive a copy of the license and are unable to

 * obtain it through the world-wide-web, please send an email

 * to hrsalesoft@gmail.com so we can send you a copy immediately.

 *

 * @author   HRSALE

 * @author-email  hrsalesoft@gmail.com

 * @copyright  Copyright © hrsale.com. All Rights Reserved

 */

defined('BASEPATH') or exit('No direct script access allowed');



class Checklist extends MY_Controller
{



	public function __construct()
	{

		parent::__construct();

		//load the models

		$this->load->model("Employees_model");

		$this->load->model("Xin_model");

		$this->load->model("Department_model");

		$this->load->model("Designation_model");

		$this->load->model("Roles_model");

		$this->load->model("Location_model");

		$this->load->model("Company_model");

		$this->load->model("Timesheet_model");

		$this->load->model("Custom_fields_model");

		$this->load->model("Assets_model");

		$this->load->model("Training_model");

		$this->load->model("Trainers_model");

		$this->load->library("pagination");

		$this->load->model("Awards_model");

		$this->load->model("Travel_model");

		$this->load->model("Tickets_model");

		$this->load->model("Transfers_model");

		$this->load->model("Promotion_model");

		$this->load->model("Complaints_model");

		$this->load->model("Warning_model");

		$this->load->model("Project_model");

		$this->load->model("Payroll_model");

		$this->load->model("Events_model");

		$this->load->model("Meetings_model");

		$this->load->model('Exin_model');
		
		$this->load->model('Office_shift_custom_model');

		$this->load->library('Pdf');

		$this->load->helper('string');
	}



	/*Function to set JSON output*/

	public function output($Return = array())
	{

		/*Set response header*/

		header("Access-Control-Allow-Origin: *");

		header("Content-Type: application/json; charset=UTF-8");

		/*Final JSON response*/

		exit(json_encode($Return));
	}
	
	public function onboard(){
	    $session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}

		$data['title'] = 'Onboard Checklist' ;
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['breadcrumbs'] = 'Onboard Checklist';
		$data['path_url'] = 'Onboard';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('290', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/employees/onboard", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function offboard(){
	    $session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}

		$data['title'] = 'Offboard Checklist' ;
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['breadcrumbs'] = 'Offboard Checklist';
		$data['path_url'] = 'Offboard';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('290', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/employees/offboard", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function get_employees_onboard_checklist()
	{
		$data['title']            = $this->Xin_model->site_title();
		$id                       = $this->uri->segment(4);
		$desigid                  = $this->Employees_model->read_employee_information($id);
		$designation              = $desigid[0]->designation_id;
		$html                     =  "";
		
		$empchecklist_exists      = $this->Employees_model->read_employee_onboardchecklist_check($id);
		if($empchecklist_exists){
		    
		    foreach ($empchecklist_exists as $chklist) {
		    $empchecklists = unserialize($chklist->checklists);
		        if($empchecklists){
		        foreach ($empchecklists as $name) {
		         
		          $html .="<span><input type='checkbox' name='checklist[]' value='".$name."' checked>
                                      <label for='checklist'> ".$name."</label></span><br>";
		        }
		        }
		    }
		    
		}else{
		
		$checklist                = $this->Employees_model->read_employee_onboardchecklist($designation);
		if($checklist){
		    
		
    		foreach ($checklist as $chk) {
    		    $html .="<span><input type='checkbox' name='checklist[]' value='".$chk->name."' checked>
                                          <label for='checklist'> ".$chk->name."</label></span><br>";
    		}
		}
    	}
		print_r($html);
		exit();
		
	}
	
	public function get_employees_offboard_checklist()
	{
		$data['title']  = $this->Xin_model->site_title();
		$id             = $this->uri->segment(4);
		$desigid        = $this->Employees_model->read_employee_information($id);
		$designation    = $desigid[0]->designation_id;
		$html           =  "";
		
		$empchecklist_exists      = $this->Employees_model->read_employee_offboardchecklist_check($id);
		if($empchecklist_exists){
		    
		    foreach ($empchecklist_exists as $chklist) {
		    $empchecklists = unserialize($chklist->checklists);
		        if($empchecklists){
		            
		        foreach ($empchecklists as $name) {
		         
		          $html .="<span><input type='checkbox' name='checklist[]' value='".$name."' checked>
                                      <label for='checklist'> ".$name."</label></span><br>";
		        }
		        }
		    }
		    
		}else{
		
		$checklist                = $this->Employees_model->read_employee_offboardchecklist($designation);
		if($checklist){
    		foreach ($checklist as $chk) {
    		    $html .="<span><input type='checkbox' name='checklist[]' value='".$chk->name."' checked>
                                          <label for='checklist'> ".$chk->name."</label></span><br>";
    		}
		}
    	}
		print_r($html);
		exit();
		
	}
	
	public function add_emp_onboard_checklist()
	{

		
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

		
			$empid              = $this->input->post('employee_id');
			$checklist          = $this->input->post('checklist');
			$newchecklist       = $this->input->post('new_checklist');
			/*if($newchecklist != ""){
			    array_push($checklist,$newchecklist);
			}*/
			$onboard_checklist  = serialize($checklist);
			
			$empcheck  = $this->Employees_model->read_employee_onboardchecklist_check($empid);
			if($empcheck){
			    $data = array(
    				'employee_id' => $empid,
    				'checklists'  => $onboard_checklist
    				
    			);
			    $result = $this->Employees_model->update_onboard_checklist($data, $empid);
			}else{
			
    			$data = array(
    				'employee_id' => $empid,
    				'checklists'  => $onboard_checklist
    				
    			);
			    $result = $this->Employees_model->add_onboard_checklist($data);
			}
			if ($result == true) {
				$Return['result'] = "Checklist Added";
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		
	}
	
	public function add_emp_offboard_checklist()
	{

		
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

		
			$empid              = $this->input->post('employee_id');
			$checklist          = $this->input->post('checklist');
			$newchecklist       = $this->input->post('new_checklist');
			/*if($newchecklist != ""){
			    array_push($checklist,$newchecklist);
			}*/
			$onboard_checklist  = serialize($checklist);
			
			$empcheck  = $this->Employees_model->read_employee_offboardchecklist_check($empid);
			if($empcheck){
			    $data = array(
    				'employee_id' => $empid,
    				'checklists'  => $onboard_checklist
    				
    			);
			    $result = $this->Employees_model->update_offboard_checklist($data, $empid);
			}else{
			
    			$data = array(
    				'employee_id' => $empid,
    				'checklists'  => $onboard_checklist
    				
    			);
			    $result = $this->Employees_model->add_offboard_checklist($data);
			}
			if ($result == true) {
				$Return['result'] = "Checklist Added";
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function add_emp_onboard_checklist_validate()
	{
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if ($this->input->post('company_id') === '') {

			$Return['error'] = "Company is required";
		} else if ($this->input->post('location') === '') {

			$Return['error'] = "Location is required";
		} else if ($this->input->post('employee_id') === '') {

			$Return['error'] = "Employee is required";
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
		exit;
		
	}
	public function add_emp_offboard_checklist_validate()
	{
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			if ($this->input->post('company_id') === '') {

            $Return['error'] = "Company is required";
            
            } else if ($this->input->post('location') === ''){
            
            $Return['error'] = "Location is required";
            
            } else if ($this->input->post('employee_id') === ''){
            
            $Return['error'] = "Employee is required";
            
            }
			$empid              = $this->input->post('employee_id');
			$checklist          = $this->input->post('checklist');
			$newchecklist       = $this->input->post('new_checklist');
			/*if($newchecklist != ""){
			    array_push($checklist,$newchecklist);
			}*/
			$onboard_checklist  = serialize($checklist);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		
	}


  
  
}
