<?php

/**

 * NOTICE OF LICENSE

 *

 * This source file is subject to the HRSALE License

 * that is bundled with this package in the file license.txt.

 * It is also available through the world-wide-web at this URL:

 * http://www.hrsale.com/license.txt

 * If you did not receive a copy of the license and are unable to

 * obtain it through the world-wide-web, please send an email

 * to hrsalesoft@gmail.com so we can send you a copy immediately.

 *

 * @author   HRSALE

 * @author-email  hrsalesoft@gmail.com

 * @copyright  Copyright © hrsale.com. All Rights Reserved

 */

defined('BASEPATH') or exit('No direct script access allowed');



class Employees extends MY_Controller
{



	public function __construct()
	{

		parent::__construct();

		//load the models

		$this->load->model("Employees_model");

		$this->load->model("Xin_model");

		$this->load->model("Department_model");

		$this->load->model("Designation_model");

		$this->load->model("Roles_model");

		$this->load->model("Location_model");

		$this->load->model("Company_model");

		$this->load->model("Timesheet_model");

		$this->load->model("Custom_fields_model");

		$this->load->model("Assets_model");

		$this->load->model("Training_model");

		$this->load->model("Trainers_model");

		$this->load->library("pagination");

		$this->load->model("Awards_model");

		$this->load->model("Travel_model");

		$this->load->model("Tickets_model");

		$this->load->model("Transfers_model");

		$this->load->model("Promotion_model");

		$this->load->model("Complaints_model");

		$this->load->model("Warning_model");

		$this->load->model("Project_model");

		$this->load->model("Payroll_model");

		$this->load->model("Events_model");

		$this->load->model("Meetings_model");

		$this->load->model('Exin_model');

		$this->load->model('Office_shift_custom_model');

		$this->load->library('Pdf');

		$this->load->helper('string');
	}



	/*Function to set JSON output*/

	public function output($Return = array())
	{

		/*Set response header*/

		header("Access-Control-Allow-Origin: *");

		header("Content-Type: application/json; charset=UTF-8");

		/*Final JSON response*/

		exit(json_encode($Return));
	}


	public function employee_update()

	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$data['title'] = $this->lang->line('xin_employees') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_office_shifts'] = $this->Employees_model->all_office_shifts();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();

		$data['breadcrumbs'] = $this->lang->line('xin_employees');

		if (!in_array('79', $role_resources_ids)) {

			$data['path_url'] = 'myteam_employees';
		} else {

			$data['path_url'] = 'employees';
		}



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('79', $role_resources_ids) || $reports_to > 0) {

			if (!empty($session)) {



				$data['subview'] = $this->load->view("admin/employees/employee_detail_update", $data, TRUE);

				$this->load->view('admin/layout/layout_main', $data); //page load

			} else {

				redirect('admin/');
			}
		} else {

			redirect('admin/dashboard');
		}
	}

	public function onboard()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}

		$data['title'] = 'Onboard Checklist';
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['breadcrumbs'] = 'Onboard Checklist';
		$data['path_url'] = 'Onboard';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('290', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/employees/onboard", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function offboard()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_inquiry != 'true') {
			redirect('admin/dashboard');
		}

		$data['title'] = 'Offboard Checklist';
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$data['breadcrumbs'] = 'Offboard Checklist';
		$data['path_url'] = 'Offboard';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('290', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/employees/offboard", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function get_employees_onboard_checklist()
	{
		$data['title']  = $this->Xin_model->site_title();
		$id             = $this->uri->segment(5);
		$desigid        = $this->Employees_model->read_employee_information($id);
		$designation    = $desigid[0]->designation_id;

		$checklist      = $this->Employees_model->read_employee_onboardchecklist($designation);
		$html = "";
		foreach ($checklist as $chk) {
			$html .= "<input type='checkbox' name='checklist[]' value='" . $chk->name . "' checked>
                                      <label for='checklist'> " . $chk->name . "</label><br>";
		}
		print_r($html);
		exit();
	}

	public function get_employees_offboard_checklist()
	{
		$data['title']  = $this->Xin_model->site_title();
		$id             = $this->uri->segment(5);
		$desigid        = $this->Employees_model->read_employee_information($id);
		$designation    = $desigid[0]->designation_id;

		$checklist      = $this->Employees_model->read_employee_offboardchecklist($designation);
		$html = "";
		foreach ($checklist as $chk) {
			$html .= "<input type='checkbox' name='checklist[]' value='" . $chk->name . "' checked>
                                      <label for='checklist'> " . $chk->name . "</label><br>";
		}
		print_r($html);
		exit();
	}

	public function add_emp_onboard_checklist()
	{


		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();


		$empid              = $this->input->post('employee_id');
		$checklist          = $this->input->post('checklist');
		$newchecklist       = $this->input->post('new_checklist');
		if ($newchecklist != "") {
			array_push($checklist, $newchecklist);
		}
		$onboard_checklist  = serialize($checklist);


		$data = array(
			'employee_id' => $empid,
			'checklists'  => $onboard_checklist

		);
		$result = $this->Employees_model->add_onboard_checklist($data);
		if ($result == true) {
			$Return['result'] = "Checklist Added";
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
	}


	public function employees_list_new()

	{

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_update", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$system = $this->Xin_model->read_setting_info(1);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($this->input->get("ihr") == 'true') {

			if ($this->input->get("company_id") == 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_employees_update();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_company_employees_flt($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_company_location_employees_flt($this->input->get("company_id"), $this->input->get("location_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_company_location_department_employees_flt($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") != 0) {

				$employee = $this->Employees_model->get_company_location_department_designation_employees_flt($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"), $this->input->get("designation_id"));
			}
		} else {

			if ($user_info[0]->user_role_id == 1) {

				$employee = $this->Employees_model->get_employees_update();
				// 	var_dump($employee);die();

				//	print_r($employee);

			} else {




				$employee = $this->Employees_model->get_employees_update_emp($session['user_id']);
			}
		}



		$data = array();


		// var_dump($employee->result());die();
		foreach ($employee->result() as $r) {


			$employee_ids = $r->emp_id;
			//                 var_dump($employee_ids);die();
			// 			// get company

			$company = $this->Xin_model->read_company_info($r->company_id);

			if (!is_null($company)) {

				$comp_name = $company[0]->name;
			} else {

				$comp_name = '--';
			}



			// user full name 

			$full_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;

			// user role

			$role = $this->Xin_model->read_user_role_info($r->user_role_id);

			if (!is_null($role)) {

				$role_name = $role[0]->role_name;
			} else {

				$role_name = '--';
			}

			// get report to

			$reports_to = $this->Xin_model->read_user_info($r->reports_to);

			// user full name

			if (!is_null($reports_to)) {

				$manager_name = $reports_to[0]->first_name . ' ' . $reports_to[0]->middle_name . ' ' . $reports_to[0]->last_name;
			} else {

				$manager_name = '--';
			}

			// get designation

			$designation = $this->Designation_model->read_designation_information($r->designation_id);

			if (!is_null($designation)) {

				$designation_name = $designation[0]->designation_name;
			} else {

				$designation_name = '--';
			}

			// department

			$department = $this->Department_model->read_department_information($r->department_id);

			if (!is_null($department)) {

				$department_name = $department[0]->department_name;
			} else {

				$department_name = '--';
			}

			// location

			$location = $this->Location_model->read_location_information($r->location_id);

			if (!is_null($location)) {

				$location_name = $location[0]->location_name;
			} else {

				$location_name = '--';
			}





			$department_designation = $designation_name . ' (' . $department_name . ')';

			/*// get status

			if($r->is_active==0): $status = '<span class="badge badge-pill badge-danger">'.$this->lang->line('xin_employees_inactive').'</span>';

			elseif($r->is_active==1): $status = '<span class="badge badge-pill badge-success">'.$this->lang->line('xin_employees_active').'</span>';endif;*/



			if ($r->user_id != '1') {

				if (in_array('203', $role_resources_ids)) {
					$del_opt = '';
					// 	$del_opt = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->user_id . '"><span class="fas fa-trash-restore"></span></button></span>';
				} else {

					$del_opt = '';
				}
			} else {

				$del_opt = '';
			}

			if (in_array('202', $role_resources_ids)) {

				$view_opt = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {

				$view_opt = '';
			}

			$function = $view_opt . $del_opt . '';

			if ($r->wages_type == 1) {

				$bsalary = $this->Xin_model->company_currency_sign($r->basic_salary, $r->company_id);
			} else {

				$bsalary = $this->Xin_model->company_currency_sign($r->daily_wages, $r->company_id);
			}





			if ($r->profile_picture != '' && $r->profile_picture != 'no file') {

				$ol = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $r->profile_picture . '" class="d-block ui-w-30 rounded-circle" alt=""></span></a>';
			} else {

				if ($r->gender == 'Male') {

					$de_file = base_url() . 'uploads/profile/default_male.jpg';
				} else {

					$de_file = base_url() . 'uploads/profile/default_female.jpg';
				}

				$ol = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><span class="avatar box-32"><img src="' . $de_file . '" class="d-block ui-w-30 rounded-circle" alt=""></span></a>';
			}

			//shift info

			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

			if (!is_null($office_shift)) {

				$shift = $office_shift[0]->shift_name;
			} else {

				$shift = '<a href="javascript:void(0)" class="badge badge-danger">' . $this->lang->line('xin_office_shift_not_assigned') . '</a>';
			}

			if (in_array('202', $role_resources_ids)) {

				$ename = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '" class="d-block text-primary">' . $full_name . '</a>';
			} else {

				$ename = '<span class="d-block text-primary">' . $full_name . '</span>';
			}

			// 1: salary type

			if ($r->wages_type == 1) {

				$wages_type = $this->lang->line('xin_payroll_basic_salary');

				if ($system[0]->is_half_monthly == 1) {

					$basic_salary = $r->basic_salary / 2;
				} else {

					$basic_salary = $r->basic_salary;
				}
			} else if ($r->wages_type == 2) {

				$wages_type = $this->lang->line('xin_employee_daily_wages');

				$basic_salary = $r->basic_salary;
			} else {

				$wages_type = $this->lang->line('xin_payroll_basic_salary');

				if ($system[0]->is_half_monthly == 1) {

					$basic_salary = $r->basic_salary / 2;
				} else {

					$basic_salary = $r->basic_salary;
				}
			}

			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary, $r->company_id);

			$employee_name = '<div class="media align-items-center">

			' . $ol . '

			<div class="media-body ml-2">

			  ' . $ename . '

			  <div class="text-muted small text-truncate">' . $this->lang->line('xin_e_details_shift') . ': ' . $shift . '</div>';

			if (in_array('84', $role_resources_ids)) {

				$employee_name .= '<div class="text-muted small text-truncate"><a target="_blank" href="' . site_url('admin/employees/download_profile/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="' . $this->lang->line('xin_download_profile_title') . '">' . $this->lang->line('xin_download_profile_title') . ' <i class="fas fa-arrow-circle-right"></i></a></div>';
			}

			if (in_array('83', $role_resources_ids)) {

				$employee_name .= '<div class="text-info small text-truncate"><a href="' . site_url('admin/employees/setup_salary/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="' . $this->lang->line('xin_salary_title') . '">' . $this->lang->line('xin_employee_set_salary') . ': ' . $basic_salary . ' <i class="fas fa-arrow-circle-right"></i></a></div><div class="text-success small text-truncate"><a href="' . site_url('admin/employees/setup_salary/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="' . $this->lang->line('xin_employee_set_salary') . '">' . $this->lang->line('left_payroll') . ': ' . $wages_type . ' <i class="fas fa-arrow-circle-right"></i></a></div>';
			} else {

				$employee_name .= '<div class="text-info small text-truncate">' . $this->lang->line('xin_employee_set_salary') . ': ' . $basic_salary . '</div><div class="text-success small text-truncate">' . $this->lang->line('left_payroll') . ': ' . $wages_type . '</div>';
			}

			$employee_name .= '</div>

		  </div>';



			$comp_name = '<div class="media align-items-center">

				<div class="media-body flex-truncate">

				  ' . $comp_name . '

				  <div class="text-muted small text-truncate">' . $this->lang->line('xin_location') . ': ' . $location_name . '</div>

				  <div class="text-muted small text-truncate">' . $this->lang->line('left_department') . ': ' . $department_name . '</div>

				  <div class="text-muted small text-truncate">' . $this->lang->line('left_designation') . ': ' . $designation_name . '</div>

				</div>

			  </div>';

			$contact_info = '<i class="fa fa-user text-muted" data-toggle="tooltip" data-state="primary" data-placement="top"  title="' . $this->lang->line('dashboard_username') . '"></i> ' . $r->username . '<br><i class="fa fa-envelope text-muted" data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('dashboard_email') . '"></i> ' . $r->email . '<br><i class="text-muted fa fa-phone" data-state="primary" data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_contact_number') . '"></i> ' . $r->contact_no;


			// get status

			if ($r->is_active == 0) : $status_btn = 'btn-outline-danger';
				$status_title = $this->lang->line('xin_employees_inactive');

			elseif ($r->is_active == 1) : $status_btn = 'btn-success';
				$status_title = $this->lang->line('xin_employees_active');
			endif;

			$role_resources_ids = $this->Xin_model->user_role_resource();

			if (in_array("efapproval", $role_resources_ids, TRUE)) {

				$employee = $this->Employees_model->get_employees_update();

				//   $r->user_id='204';
				$update_contract_count = $this->Xin_model->hrsale_contract_count_id($r->user_id);
				$update_visa_count = $this->Xin_model->hrsale_visa_countnew_id($r->user_id);
				$update_passport_count = $this->Xin_model->hrsale_passport_countnew_id($r->user_id);
				$update_CPR_count = $this->Xin_model->hrsale_CPR_countnew_id($r->user_id);
				$update_Insurance_count = $this->Xin_model->update_Insurance_count_id($r->user_id);
				$update_License_count = $this->Xin_model->update_License_count_id($r->user_id);


				$update_immigration_count = $this->Xin_model->update_immigration_count($r->user_id);
				$update_social_count = $this->Xin_model->update_social_count($r->user_id);
				$update_qualification_count = $this->Xin_model->update_qualification_count($r->user_id);
				$update_document_count = $this->Xin_model->update_document_count($r->user_id);
				$update_profile_picture_count = $this->Xin_model->update_profile_picture_count($r->user_id);
				$update_basic_count = $this->Xin_model->update_basic_count($r->user_id);

				$update_emergency_contact_count = $this->Xin_model->update_emergency_count($r->user_id);
				$update_work_count = $this->Xin_model->update_work_count($r->user_id);
				$update_bank_count = $this->Xin_model->update_bank_count($r->user_id);
				$update_vehicle_count = $this->Xin_model->update_vehicle_count($r->user_id);
				$update_security_count = $this->Xin_model->update_security_count($r->user_id);
				$update_mang_leave_count = $this->Xin_model->update_mang_leave_count($r->user_id);


				if ($update_basic_count) {
					$basic_title1 = "Basic Information Update";
					$basic_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
							
							<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-basic_info">
							
							<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_title1 . '</button>
						</a></div>';
				} else {
					$basic_status1 = '';
				}
				if ($update_profile_picture_count) {
					$profile_picture_title1 = "Profile Picture Update";
					$profile_picture_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
							
							<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-profile_picture">
							
							<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $profile_picture_title1 . '</button>
						</a></div>';
				} else {
					$profile_picture_status1 = '';
				}
				if ($update_document_count) {
					$document_title1 = "Document Update";
					$document_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
							
							<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-document">
							
							<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $document_title1 . '</button>
						</a></div>';
				} else {
					$document_status1 = '';
				}
				if ($update_qualification_count) {
					$qualification_title1 = "Qualification Update";
					$qualification_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
							
							<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-qualification">
							
							<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $qualification_title1 . '</button>
						</a></div>';
				} else {
					$qualification_status1 = '';
				}
				if ($update_immigration_count) {
					$immigration_title1 = "Immigration Update";
					$immigration_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
							
							<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-immigration">
							
							<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $immigration_title1 . '</button>
						</a></div>';
				} else {
					$immigration_status1 = '';
				}
				if ($update_social_count) {
					$socials_title1 = "Social Networking Update";
					$social_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
							
							<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-social">
							
							<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $socials_title1 . '</button>
						</a></div>';
				} else {
					$social_status1 = '';
				}

				if ($update_contract_count) {
					$status_title1 = "Contract Update";
					$role_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
			
			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-contract">
			
			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $status_title1 . '</button>
		</a></div>';
				} else {
					$role_status1 = '';
				}

				if ($update_visa_count) {
					$Visa_title1 = "Visa Update";
					$role_status2 = '<br><div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
			
			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-visa">
			
			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $Visa_title1 . '</button></a></div>';
				} else {
					$role_status2 = '';
				}

				if ($update_passport_count) {

					$passport_title1 = "Passport Update";
					$role_status3 = '<br><div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
			
			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-passport">
			
			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $passport_title1 . '</button>
		</a></div>';
				} else {
					$role_status3 = '';
				}

				if ($update_CPR_count) {

					$CPR_title1 = "CPR Update";
					$role_status4 = '<br><div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" >
			
			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-cpr">
			
			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $CPR_title1 . '</button>
		</a></div>';
				} else {
					$role_status4 = '';
				}



				if ($update_Insurance_count) {

					$Insurance_title1 = "Insurance Update";
					$role_status5 = '<br><div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" >
			
			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-insurance">
			
			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $Insurance_title1 . '</button>
		</a></div>';
				} else {
					$role_status5 = '';
				}


				if ($update_License_count) {


					$License_title1 = "License Update";


					$role_status6 = '<br><div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" >
			
			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-license">
			
			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $License_title1 . '</button>
		</a></div>';
				} else {
					$role_status6 = '';
				}
				if ($update_emergency_contact_count) {
					$basic_emergency_title1 = "Emergency Update";
					$basic_emergency_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
    			
    			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-contacts">
    			
    			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_emergency_title1 . '</button>
    		</a></div>';
				} else {
					$basic_emergency_status1 = '';
				}
				if ($update_work_count) {
					$basic_work_title1 = "Work Experience Update";
					$basic_work_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
    			
    			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-experience">
    			
    			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_work_title1 . '</button>
    		</a></div>';
				} else {
					$basic_work_status1 = '';
				}
				if ($update_bank_count) {
					$basic_bank_title1 = "Bank Account Update";
					$basic_bank_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
    			
    			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-baccount">
    			
    			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_bank_title1 . '</button>
    		</a></div>';
				} else {
					$basic_bank_status1 = '';
				}
				if ($update_vehicle_count) {
					$basic_vehicle_title1 = "Vehicle Update";
					$basic_vehicle_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
    			
    			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-vehicle">
    			
    			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_vehicle_title1 . '</button>
    		</a></div>';
				} else {
					$basic_vehicle_status1 = '';
				}
				if ($update_security_count) {
					$basic_security_title1 = "Security Update";
					$basic_security_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
    			
    			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-security_level">
    			
    			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_security_title1 . '</button>
    		</a></div>';
				} else {
					$basic_security_status1 = '';
				}
				if ($update_mang_leave_count) {
					$basic_mang_leave_title1 = "Leave Update";
					$basic_mang_leave_status1 = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" style="display: inline-block;">
    			
    			<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '#account-security_level">
    			
    			<button type="button"  class="btn btn-xs btn-primary" style="margin: 3px;">' . $basic_mang_leave_title1 . '</button>
    		</a></div>';
				} else {
					$basic_mang_leave_status1 = '';
				}
				$role_status = $role_status1 . '' . $role_status2 . '' . $role_status3 . '' . $role_status4 . '' . $role_status5 . '' . $role_status6 . '' . $basic_status1 . '' . $profile_picture_status1 . '' . $document_status1 . '' . $qualification_status1 . '' . $immigration_status1 . '' . $social_status1 . '' . $basic_emergency_status1 . '' . $basic_work_status1 . '' . $basic_bank_status1 . '' . $basic_vehicle_status1 . '' . $basic_security_status1 . '' . $basic_mang_leave_status1;
			} else {
				$role_status = '';
			}


			/*if ($r->black_list_status == 'Y') {
				$status_val = 2;
				$black_list = '<br/><a href="javascript:void(0)"  onClick="Make_User_BlackList(' . $r->user_id . ',' . $status_val . ')" class="text-dark collapsed">
					<button type="button" class="btn btn-xs btn-primary">' . $this->lang->line('xin_make_black_list_remove') . '</button>
					</a>';
			} else {
				$status_val = 1;
				$black_list = '<br/><a href="javascript:void(0)"  onClick="Make_User_BlackList(' . $r->user_id . ',' . $status_val . ')" class="text-dark collapsed">
				<button type="button" class="btn btn-xs btn-primary">' . $this->lang->line('xin_make_black_list') . '</button>
				</a>';
			}*/

			if ((in_array('202', $role_resources_ids)) || (in_array('203', $role_resources_ids))) {


				$data[] = array(



					$employee_ids,

					$employee_name,

					$comp_name,

					//$contact_info,

					//	$manager_name,

					$role_status,

					$function,

				);
			} else {

				$data[] = array(



					$employee_ids,

					$employee_name,

					$comp_name,

					//$contact_info,

					//	$manager_name,

					$role_status,

				);
			}


			//($r->black_list_status == 'Y') ? 'black listed' : ''

		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $employee->num_rows(),

			"recordsFiltered" => $employee->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}


	public function index()

	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$data['title'] = $this->lang->line('xin_add_employee') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_office_shifts'] = $this->Employees_model->all_office_shifts();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();

		$data['breadcrumbs'] = $this->lang->line('xin_add_employee');

		if (!in_array('79', $role_resources_ids)) {

			$data['path_url'] = 'myteam_employees';
		} else {

			$data['path_url'] = 'employees';
		}



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('79', $role_resources_ids) || $reports_to > 0) {

			if (!empty($session)) {

				$data['subview'] = $this->load->view("admin/employees/employees_list", $data, TRUE);

				$this->load->view('admin/layout/layout_main', $data); //page load

			} else {

				redirect('admin/');
			}
		} else {

			redirect('admin/dashboard');
		}
	}

	public function staff_dashboard()

	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('hr_staff_dashboard_title') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_office_shifts'] = $this->Employees_model->all_office_shifts();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();

		$data['breadcrumbs'] = $this->lang->line('hr_staff_dashboard_title');

		$data['path_url'] = 'employees';

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('422', $role_resources_ids)) {

			if (!empty($session)) {

				$data['subview'] = $this->load->view("admin/employees/staff_dashboard", $data, TRUE);

				$this->load->view('admin/layout/layout_main', $data); //page load

			} else {

				redirect('admin/');
			}
		} else {

			redirect('admin/dashboard');
		}
	}



	// employees directory/hr

	public function hr()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('left_active') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();



		if (in_array('127', $role_resources_ids)) {

			$data['breadcrumbs'] = $this->lang->line('left_active');
		} else {

			$data['breadcrumbs'] = $this->lang->line('left_active') . ' - ' . $this->lang->line('xin_my_team');
		}

		$data['path_url'] = 'employees_directory';



		// init params

		$config = array();

		$limit_per_page = 40;

		$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;

		if ($this->input->post("hrsale_directory") == 1) {

			if ($this->input->post("company_id") == 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees($limit_per_page, $page * $limit_per_page);
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_employees($this->input->post("company_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_employees_flt($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_employees($this->input->post("company_id"), $this->input->post("location_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_employees_flt($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_employees($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_employees_flt($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") != 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_designation_employees($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_designation_employees_flt($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));
			}
		} else {

			if (in_array('127', $role_resources_ids)) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees($limit_per_page, $page * $limit_per_page);
			} else {

				$total_records = $this->Employees_model->record_count_myteam($session['user_id']);

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_team_employees($limit_per_page, $page * $limit_per_page);
			}
		}

		$config['base_url'] = site_url() . "admin/employees/hr";

		$config['total_rows'] = $total_records;

		$config['per_page'] = $limit_per_page;

		$config["uri_segment"] = 4;



		// custom paging configuration

		// $config['num_links'] = 2;

		$config['use_page_numbers'] = TRUE;

		$config['reuse_query_string'] = FALSE;

		//$config['page_query_string'] = TRUE;



		//$config['use_page_numbers'] = TRUE;

		$config['num_links'] = $total_records;

		$config['cur_tag_open'] = '&nbsp;<a>';

		$config['cur_tag_close'] = '</a>';

		//$config['next_link'] = '»';

		//$config['prev_link'] = '«';



		$this->pagination->initialize($config);



		// build paging links

		$data["links"] = $this->pagination->create_links();

		//$str_links = $this->pagination->create_links();

		//$data["links"] = explode('&nbsp;',$str_links );

		$data["total_record"] = $total_records;

		// View data according to array.



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('127', $role_resources_ids) || $reports_to > 0) {

			$data['subview'] = $this->load->view("admin/employees/directory", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}
	public function hr_this_month()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('left_active') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();



		if (in_array('127', $role_resources_ids)) {

			$data['breadcrumbs'] = "Employees Onboard This Month";
		} else {

			$data['breadcrumbs'] = "Employees Onboard This Month";
		}

		$data['path_url'] = 'employees_directory';



		// init params

		$config = array();

		$limit_per_page = 40;

		$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;

		if ($this->input->post("hrsale_directory") == 1) {

			if ($this->input->post("company_id") == 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees_this_month($limit_per_page, $page * $limit_per_page);
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_employees_this_month_this_month($this->input->post("company_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_employees_flt_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_employees_this_month($this->input->post("company_id"), $this->input->post("location_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_employees_flt_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_employees_this_month($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_employees_flt_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") != 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_designation_employees_this_month($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_designation_employees_flt_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));
			}
		} else {

			if (in_array('127', $role_resources_ids)) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees_this_month($limit_per_page, $page * $limit_per_page);
			} else {

				$total_records = $this->Employees_model->record_count_myteam($session['user_id']);

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_team_employees_this_month($limit_per_page, $page * $limit_per_page);
			}
		}

		$config['base_url'] = site_url() . "admin/employees/hr_this_month";

		$config['total_rows'] = $total_records;

		$config['per_page'] = $limit_per_page;

		$config["uri_segment"] = 4;



		// custom paging configuration

		// $config['num_links'] = 2;

		$config['use_page_numbers'] = TRUE;

		$config['reuse_query_string'] = FALSE;

		//$config['page_query_string'] = TRUE;



		//$config['use_page_numbers'] = TRUE;

		$config['num_links'] = $total_records;

		$config['cur_tag_open'] = '&nbsp;<a>';

		$config['cur_tag_close'] = '</a>';

		//$config['next_link'] = '»';

		//$config['prev_link'] = '«';



		$this->pagination->initialize($config);



		// build paging links

		$data["links"] = $this->pagination->create_links();

		//$str_links = $this->pagination->create_links();

		//$data["links"] = explode('&nbsp;',$str_links );

		$data["total_record"] = $total_records;

		// View data according to array.



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('127', $role_resources_ids) || $reports_to > 0) {

			$data['subview'] = $this->load->view("admin/employees/directory_this_month", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}
	public function archive_this_month()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_employees_archive_directory') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();



		if (in_array('128', $role_resources_ids)) {

			$data['breadcrumbs'] = "Employees Offboard This Month";
		} else {

			$data['breadcrumbs'] = "Employees Offboard This Month";
		}

		$data['path_url'] = 'employees_directory';



		// init params

		$config = array();

		$limit_per_page = 40;

		$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;

		if ($this->input->post("hrsale_directory") == 1) {

			if ($this->input->post("company_id") == 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees_archive_this_month($limit_per_page, $page * $limit_per_page);
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_employees_archive_this_month($this->input->post("company_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_employees_flt_archive_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_employees_archive_this_month($this->input->post("company_id"), $this->input->post("location_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_employees_flt_archive_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_employees_archive_this_month($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_employees_flt_archive_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") != 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_designation_employees_archive_this_month($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_designation_employees_flt_archive_this_month($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));
			}
		} else {

			if (in_array('128', $role_resources_ids)) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees_archive_this_month($limit_per_page, $page * $limit_per_page);
			} else {

				$total_records = $this->Employees_model->record_count_myteam($session['user_id']);

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_team_employees_archive_this_month($limit_per_page, $page * $limit_per_page);
			}
		}

		$config['base_url'] = site_url() . "admin/employees/archive_this_month";

		$config['total_rows'] = $total_records;

		$config['per_page'] = $limit_per_page;

		$config["uri_segment"] = 4;



		// custom paging configuration

		// $config['num_links'] = 2;

		$config['use_page_numbers'] = TRUE;

		$config['reuse_query_string'] = FALSE;

		//$config['page_query_string'] = TRUE;



		//$config['use_page_numbers'] = TRUE;

		$config['num_links'] = $total_records;

		$config['cur_tag_open'] = '&nbsp;<a>';

		$config['cur_tag_close'] = '</a>';

		//$config['next_link'] = '»';

		//$config['prev_link'] = '«';



		$this->pagination->initialize($config);



		// build paging links

		$data["links"] = $this->pagination->create_links();

		//$str_links = $this->pagination->create_links();

		//$data["links"] = explode('&nbsp;',$str_links );

		$data["total_record"] = $total_records;

		// View data according to array.



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('128', $role_resources_ids) || $reports_to > 0) {

			$data['subview'] = $this->load->view("admin/employees/archive_this_month", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}
	public function archive()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_employees_archive_directory') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();



		if (in_array('128', $role_resources_ids)) {

			$data['breadcrumbs'] = $this->lang->line('xin_employees_archive_directory');
		} else {

			$data['breadcrumbs'] = $this->lang->line('xin_employees_archive_directory') . ' - ' . $this->lang->line('xin_my_team');
		}

		$data['path_url'] = 'employees_directory';



		// init params

		$config = array();

		$limit_per_page = 40;

		$page = ($this->uri->segment(4)) ? ($this->uri->segment(4) - 1) : 0;

		if ($this->input->post("hrsale_directory") == 1) {

			if ($this->input->post("company_id") == 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees_archive($limit_per_page, $page * $limit_per_page);
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_employees_archive($this->input->post("company_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_employees_flt_archive($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") == 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_employees_archive($this->input->post("company_id"), $this->input->post("location_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_employees_flt_archive($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") == 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_employees_archive($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_employees_flt_archive($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0 && $this->input->post("designation_id") != 0) {

				$total_records = $this->Employees_model->record_count_company_location_department_designation_employees_archive($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_company_location_department_designation_employees_flt_archive($limit_per_page, $page * $limit_per_page, $this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("designation_id"));
			}
		} else {

			if (in_array('128', $role_resources_ids)) {

				$total_records = $this->Employees_model->record_count();

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_employees_archive($limit_per_page, $page * $limit_per_page);
			} else {

				$total_records = $this->Employees_model->record_count_myteam($session['user_id']);

				// get current page records

				$data["results"] = $this->Employees_model->fetch_all_team_employees_archive($limit_per_page, $page * $limit_per_page);
			}
		}

		$config['base_url'] = site_url() . "admin/employees/archive";

		$config['total_rows'] = $total_records;

		$config['per_page'] = $limit_per_page;

		$config["uri_segment"] = 4;



		// custom paging configuration

		// $config['num_links'] = 2;

		$config['use_page_numbers'] = TRUE;

		$config['reuse_query_string'] = FALSE;

		//$config['page_query_string'] = TRUE;



		//$config['use_page_numbers'] = TRUE;

		$config['num_links'] = $total_records;

		$config['cur_tag_open'] = '&nbsp;<a>';

		$config['cur_tag_close'] = '</a>';

		//$config['next_link'] = '»';

		//$config['prev_link'] = '«';



		$this->pagination->initialize($config);



		// build paging links

		$data["links"] = $this->pagination->create_links();

		//$str_links = $this->pagination->create_links();

		//$data["links"] = explode('&nbsp;',$str_links );

		$data["total_record"] = $total_records;

		// View data according to array.



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('128', $role_resources_ids) || $reports_to > 0) {

			$data['subview'] = $this->load->view("admin/employees/archive", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}


	public function employees_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employees_list", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$dname = $this->input->get("dname");
		$degnid = $this->input->get("degnid");
		//var_dump($dname);die;
		$role_resources_ids = $this->Xin_model->user_role_resource();

		$system = $this->Xin_model->read_setting_info(1);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		// var_dump($this->input->get());

		if ($this->input->get("ihr") == 'true') {

			if ($this->input->get("company_id") == 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_employees();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_company_employees_flt($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_company_location_employees_flt($this->input->get("company_id"), $this->input->get("location_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") == 0) {

				$employee = $this->Employees_model->get_company_location_department_employees_flt($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") != 0) {

				$employee = $this->Employees_model->get_company_location_department_designation_employees_flt($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"), $this->input->get("designation_id"));
			}
		} elseif ($this->input->get("dname") != '' && $dname != '' && $dname != 'undefined' && $dname != 'null' && $dname != 'NULL' && $dname != NULL && $dname != null) {

			$employee = $this->Employees_model->get_all_employees_deptwise($this->input->get("dname"));
		} elseif ($this->input->get("degnid") != '' && $degnid != '' && $degnid != 'undefined' && $degnid != 'null' && $degnid != 'NULL' && $degnid != NULL && $degnid != null) {

			$employee = $this->Employees_model->get_all_employees_degnwise($this->input->get("degnid"));
		} else {

			if ($user_info[0]->user_role_id == 1 || in_array('90', $role_resources_ids)) {

				$employee = $this->Employees_model->get_employees();
			} else {

				if (in_array('86', $role_resources_ids)) {

					$employee = $this->Employees_model->get_employees_for_other($user_info[0]->company_id);
				} else if (in_array('87', $role_resources_ids)) {

					$employee = $this->Employees_model->get_employees_for_location($user_info[0]->location_id);
				} else {

					$employee = $this->Employees_model->get_employees_for_location($user_info[0]->location_id);
				}
			}
		}



		$data = array();



		foreach ($employee->result() as $r) {



			// get company

			$company = $this->Xin_model->read_company_info($r->company_id);

			if (!is_null($company)) {

				$comp_name = $company[0]->name;
			} else {

				$comp_name = '--';
			}



			// user full name 

			$full_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;

			// user role

			$role = $this->Xin_model->read_user_role_info($r->user_role_id);

			if (!is_null($role)) {

				$role_name = $role[0]->role_name;
			} else {

				$role_name = '--';
			}

			// get report to

			$reports_to = $this->Xin_model->read_user_info($r->reports_to);

			// user full name

			if (!is_null($reports_to)) {

				$manager_name = $reports_to[0]->first_name . ' ' . $reports_to[0]->middle_name . ' ' . $reports_to[0]->last_name;
			} else {

				$manager_name = '--';
			}

			// get designation

			$designation = $this->Designation_model->read_designation_information($r->designation_id);

			if (!is_null($designation)) {

				$designation_name = $designation[0]->designation_name;
			} else {

				$designation_name = '--';
			}

			// department

			$department = $this->Department_model->read_department_information($r->department_id);

			if (!is_null($department)) {

				$department_name = $department[0]->department_name;
			} else {

				$department_name = '--';
			}

			// location

			$location = $this->Location_model->read_location_information($r->location_id);

			if (!is_null($location)) {

				$location_name = $location[0]->location_name;
			} else {

				$location_name = '--';
			}



			$edit = "edit";

			$department_designation = $designation_name . ' (' . $department_name . ')';

			/*// get status

      if($r->is_active==0): $status = '<span class="badge badge-pill badge-danger">'.$this->lang->line('xin_employees_inactive').'</span>';

      elseif($r->is_active==1): $status = '<span class="badge badge-pill badge-success">'.$this->lang->line('xin_employees_active').'</span>';endif;*/



			if ($r->user_id != '1') {

				if (in_array('82', $role_resources_ids) || in_array('93', $role_resources_ids)) {

					$del_opt = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->user_id . '"><span class="fas fa-trash-restore"></span></button></span>';
				} else {

					$del_opt = '';
				}
			} else {

				$del_opt = '';
			}

			if (in_array('802', $role_resources_ids) || in_array('803', $role_resources_ids)) {

				$view_opt = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/employees/detail_view/' . $r->user_id . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {

				$view_opt = '';
			}
			if (in_array('81', $role_resources_ids) || in_array('92', $role_resources_ids)) {

				$edit_opt = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $edit . '"><a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fas fa-pencil-alt"></span></button></a></span>';
			} else {

				$edit_opt = '';
			}

			$function = $edit_opt . $view_opt . $del_opt . '';

			if ($r->wages_type == 1) {

				$bsalary = $this->Xin_model->company_currency_sign($r->basic_salary, $r->company_id);
			} else {

				$bsalary = $this->Xin_model->company_currency_sign($r->daily_wages, $r->company_id);
			}





			if ($r->profile_picture != '' && $r->profile_picture != 'no file') {

				$ol = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $r->profile_picture . '" class="d-block ui-w-30 rounded-circle" alt=""></span></a>';
			} else {

				if ($r->gender == 'Male') {

					$de_file = base_url() . 'uploads/profile/default_male.jpg';
				} else {

					$de_file = base_url() . 'uploads/profile/default_female.jpg';
				}

				$ol = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><span class="avatar box-32"><img src="' . $de_file . '" class="d-block ui-w-30 rounded-circle" alt=""></span></a>';
			}

			//shift info
			$shift_name = '';

			if ($r->office_shift_id == 0) {
				$office_shift = $this->Office_shift_custom_model->employee_current_shift($r->user_id, date('Y-m'));
				if ($office_shift)
					$shift_name = 'CUST: ' . $office_shift['name'];
				else
					$shift_name = 'CUST: <span class="badge badge-danger">Not assigned</span>';
			} else {
				$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);
				if ($office_shift)
					$shift_name = $office_shift[0]->shift_name;
			}

			if (!empty($shift_name)) {
				$shift = $shift_name;
			} else {
				$shift = '<a href="javascript:void(0)" class="badge badge-danger">' . $this->lang->line('xin_office_shift_not_assigned') . '</a>';
			}

			if (in_array('202', $role_resources_ids)) {

				$ename = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '" class="d-block text-primary">' . $full_name . '</a>';
			} else {

				$ename = '<span class="d-block text-primary">' . $full_name . '</span>';
			}

			// 1: salary type

			if ($r->wages_type == 1) {

				$wages_type = $this->lang->line('xin_payroll_basic_salary');

				if ($system[0]->is_half_monthly == 1) {

					$basic_salary = $r->basic_salary / 2;
				} else {

					$basic_salary = $r->basic_salary;
				}
			} else if ($r->wages_type == 2) {

				$wages_type = $this->lang->line('xin_employee_daily_wages');

				$basic_salary = $r->basic_salary;
			} else {

				$wages_type = $this->lang->line('xin_payroll_basic_salary');

				if ($system[0]->is_half_monthly == 1) {

					$basic_salary = $r->basic_salary / 2;
				} else {

					$basic_salary = $r->basic_salary;
				}
			}

			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary, $r->company_id);

			/*$employee_name = '<div class="media align-items-center">

      ' . $ol . '

      <div class="media-body ml-2">

        ' . $ename . '

        <div class="text-muted small text-truncate">' . $this->lang->line('xin_e_details_shift') . ': ' . $shift . '</div>';*/

			$employee_name = '<div class="media align-items-center">

      ' . $ol . '

      <div class="media-body ml-2">
      <a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '" class="d-block text-primary">

        ' . $ename . '</a></div>';

			/*if (in_array('84', $role_resources_ids)) {

        $employee_name .= '<div class="text-muted small text-truncate"><a target="_blank" href="' . site_url('admin/employees/download_profile/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="' . $this->lang->line('xin_download_profile_title') . '">' . $this->lang->line('xin_download_profile_title') . ' <i class="fas fa-arrow-circle-right"></i></a></div>';
      }

      if (in_array('83', $role_resources_ids)) {

        $employee_name .= '<div class="text-info small text-truncate"><a href="' . site_url('admin/employees/setup_salary/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="' . $this->lang->line('xin_salary_title') . '">' . $this->lang->line('xin_employee_set_salary') . ': ' . $basic_salary . ' <i class="fas fa-arrow-circle-right"></i></a></div><div class="text-success small text-truncate"><a href="' . site_url('admin/employees/setup_salary/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="' . $this->lang->line('xin_employee_set_salary') . '">' . $this->lang->line('left_payroll') . ': ' . $wages_type . ' <i class="fas fa-arrow-circle-right"></i></a></div>';
      } else {

        $employee_name .= '<div class="text-info small text-truncate">' . $this->lang->line('xin_employee_set_salary') . ': ' . $basic_salary . '</div><div class="text-success small text-truncate">' . $this->lang->line('left_payroll') . ': ' . $wages_type . '</div>';
      }

      $employee_name .= '</div>

      </div>';*/



			/*$comp_name = '<div class="media align-items-center">

        <div class="media-body flex-truncate">

          ' . $comp_name . '

          <div class="text-muted small text-truncate">' . $this->lang->line('xin_location') . ': ' . $location_name . '</div>

          <div class="text-muted small text-truncate">' . $this->lang->line('left_department') . ': ' . $department_name . '</div>

          <div class="text-muted small text-truncate">' . $this->lang->line('left_designation') . ': ' . $designation_name . '</div>

        </div>

        </div>';*/

			$contact_info = '<i class="fa fa-user text-muted" data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('dashboard_username') . '"></i> ' . $r->username . '<br><i class="fa fa-envelope text-muted" data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('dashboard_email') . '"></i> ' . $r->email . '<br><i class="text-muted fa fa-phone" data-state="primary" data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_contact_number') . '"></i> ' . $r->contact_no;



			// get status

			if ($r->is_active == 0) : $status_btn = 'btn-outline-danger';
				$status_title = $this->lang->line('xin_employees_inactive');

			elseif ($r->is_active == 1) : $status_btn = 'btn-success';
				$status_title = $this->lang->line('xin_employees_active');
			endif;



			$role_status = $role_name;
			$status = '<div class="btn-group" data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_change_status') . '"><button type="button" class="btn btn-sm md-btn-flat dropdown-toggle ' . $status_btn . '" data-toggle="dropdown">' . $status_title . '</button><div class="dropdown-menu"><a class="dropdown-item statusinfo" href="javascript:void(0)" data-status="1" data-user-id="' . $r->user_id . '">' . $this->lang->line('xin_employees_active') . '</a><a class="dropdown-item statusinfo" href="javascript:void(0)" data-status="2" data-user-id="' . $r->user_id . '">' . $this->lang->line('xin_employees_inactive') . '</a></div></div>';
			if ($r->black_list_status == 'Y') {
				$status_val = 2;
				$black_list = '<br/><a href="javascript:void(0)"  onClick="Make_User_BlackList(' . $r->user_id . ',' . $status_val . ')" class="text-dark collapsed">
          <button type="button" class="btn btn-xs btn-primary">' . $this->lang->line('xin_make_black_list_remove') . '</button>
          </a>';
			} else {
				$status_val = 1;
				$black_list = '<br/><a href="javascript:void(0)"  onClick="Make_User_BlackList(' . $r->user_id . ',' . $status_val . ')" class="text-dark collapsed">
        <button type="button" class="btn btn-xs btn-primary">' . $this->lang->line('xin_make_black_list') . '</button>
        </a>';
			}


			if (in_array('82', $role_resources_ids) || in_array('93', $role_resources_ids) || in_array('802', $role_resources_ids) || in_array('803', $role_resources_ids) || in_array('81', $role_resources_ids) || in_array('92', $role_resources_ids)) {
				$data[] = array(
					$r->employee_id,
					//$employee_name,
					$employee_name,
					$comp_name,
					//$contact_info,
					//$manager_name,
					$department_name,
					$role_status,
					$status,
					$function
					//$black_list,
					//($r->black_list_status == 'Y') ? 'black listed' : ''
				);
			} else {
				$data[] = array(
					$r->employee_id,
					//$employee_name,
					$employee_name,
					$comp_name,
					//$contact_info,
					//$manager_name,
					$department_name,
					$role_status,
					$status
					//$black_list,
					//($r->black_list_status == 'Y') ? 'black listed' : ''
				);
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $employee->num_rows(),

			"recordsFiltered" => $employee->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function myteam_employees_list()

	{



		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employees_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$system = $this->Xin_model->read_setting_info(1);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		$employee = $this->Employees_model->get_my_team_employees($session['user_id']);



		$data = array();



		foreach ($employee->result() as $r) {



			// get company

			$company = $this->Xin_model->read_company_info($r->company_id);

			if (!is_null($company)) {

				$comp_name = $company[0]->name;
			} else {

				$comp_name = '--';
			}



			// user full name 

			$full_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;

			// user role

			$role = $this->Xin_model->read_user_role_info($r->user_role_id);

			if (!is_null($role)) {

				$role_name = $role[0]->role_name;
			} else {

				$role_name = '--';
			}

			// get report to

			$reports_to = $this->Xin_model->read_user_info($r->reports_to);

			// user full name

			if (!is_null($reports_to)) {

				$manager_name = $reports_to[0]->first_name . ' ' . $reports_to[0]->middle_name . ' ' . $reports_to[0]->last_name;
			} else {

				$manager_name = '--';
			}

			// get designation

			$designation = $this->Designation_model->read_designation_information($r->designation_id);

			if (!is_null($designation)) {

				$designation_name = $designation[0]->designation_name;
			} else {

				$designation_name = '--';
			}

			// department

			$department = $this->Department_model->read_department_information($r->department_id);

			if (!is_null($department)) {

				$department_name = $department[0]->department_name;
			} else {

				$department_name = '--';
			}

			// location

			$location = $this->Location_model->read_location_information($r->location_id);

			if (!is_null($location)) {

				$location_name = $location[0]->location_name;
			} else {

				$location_name = '--';
			}





			$department_designation = $designation_name . ' (' . $department_name . ')';

			// get status

			if ($r->is_active == 0) : $status = '<span class="badge bg-red">' . $this->lang->line('xin_employees_inactive') . '</span>';

			elseif ($r->is_active == 1) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_employees_active') . '</span>';
			endif;



			if ($r->user_id != '1') {

				if (in_array('203', $role_resources_ids) || in_array('11104', $role_resources_ids)) {

					$del_opt = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->user_id . '"><span class="fas fa-trash-restore"></span></button></span>';
				} else {

					$del_opt = '';
				}
			} else {

				$del_opt = '';
			}

			if (in_array('202', $role_resources_ids) || in_array('11103', $role_resources_ids)) {

				$view_opt = ' <span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-arrow-circle-right"></span></button></a></span>';
			} else {

				$view_opt = '';
			}

			$function = $view_opt . $del_opt . '';

			if ($r->wages_type == 1) {

				$bsalary = $this->Xin_model->company_currency_sign($r->basic_salary, $r->company_id);
			} else {

				$bsalary = $this->Xin_model->company_currency_sign($r->daily_wages, $r->company_id);
			}





			if ($r->profile_picture != '' && $r->profile_picture != 'no file') {

				$ol = '<a href="javascript:void(0);"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $r->profile_picture . '" class="d-block ui-w-30 rounded-circle" alt=""></span></a>';
			} else {

				if ($r->gender == 'Male') {

					$de_file = base_url() . 'uploads/profile/default_male.jpg';
				} else {

					$de_file = base_url() . 'uploads/profile/default_female.jpg';
				}

				$ol = '<a href="javascript:void(0);"><span class="avatar box-32"><img src="' . $de_file . '" class="d-block ui-w-30 rounded-circle" alt=""></span></a>';
			}

			//shift info

			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

			if (!is_null($office_shift)) {

				$shift = $office_shift[0]->shift_name;
			} else {

				$shift = '--';
			}

			if (in_array('202', $role_resources_ids)) {

				$ename = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '" class="d-block text-primary">' . $full_name . '</a>';
			} else {

				$ename = '<span class="d-block text-primary">' . $full_name . '</span>';
			}

			$employee_name = '<div class="media align-items-center">

			' . $ol . '

			<div class="media-body ml-2">

			  ' . $ename . '

			  <div class="text-muted small text-truncate">' . $this->lang->line('xin_e_details_shift') . ': ' . $shift . '</div>';

			if (in_array('84', $role_resources_ids)) {

				$employee_name .= '<div class="text-muted small text-truncate"><a target="_blank" href="' . site_url('admin/employees/download_profile/') . $r->user_id . '" class="text-muted">' . $this->lang->line('xin_download_profile_title') . ' <i class="fas fa-arrow-circle-right"></i></a></div>';
			}

			$employee_name .= '</div>

		  </div>';



			$comp_name = '<div class="media align-items-center">

				<div class="media-body flex-truncate">

				  ' . $comp_name . '

				  <div class="text-muted small text-truncate">' . $this->lang->line('xin_location') . ': ' . $location_name . '</div>

				  <div class="text-muted small text-truncate">' . $this->lang->line('left_department') . ': ' . $department_name . '</div>

				  <div class="text-muted small text-truncate">' . $this->lang->line('left_designation') . ': ' . $designation_name . '</div>

				</div>

			  </div>';

			$contact_info = '<i class="fa fa-user text-muted" data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('dashboard_username') . '"></i> ' . $r->username . '<br><i class="fa fa-envelope text-muted" data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('dashboard_email') . '"></i> ' . $r->email . '<br><i class="text-muted fa fa-phone" data-state="primary" data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_contact_number') . '"></i> ' . $r->contact_no;



			// get status

			if ($r->is_active == 0) : $status_btn = 'btn-outline-danger';
				$status_title = $this->lang->line('xin_employees_inactive');

			elseif ($r->is_active == 1) : $status_btn = 'btn-success';
				$status_title = $this->lang->line('xin_employees_active');
			endif;

			$role_status = $role_name . '<br>' . $status_title;

			$data[] = array(

				$function,

				$r->employee_id,

				$employee_name,

				$comp_name,

				$contact_info,

				$manager_name,

				$role_status,

			);
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $employee->num_rows(),

			"recordsFiltered" => $employee->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	public function download_profile()
	{

		$system = $this->Xin_model->read_setting_info(1);

		// create new PDF document

		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$key = $this->uri->segment(4);

		$user = $this->Xin_model->read_user_info($key);

		if (is_null($user)) {

			redirect('admin/employees');
		}

		if (!in_array('84', $role_resources_ids)) {

			redirect('admin/employees');
		}



		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);

		if (!is_null($_des_name)) {

			$_designation_name = $_des_name[0]->designation_name;
		} else {

			$_designation_name = '';
		}

		$department = $this->Department_model->read_department_information($user[0]->department_id);

		if (!is_null($department)) {

			$_department_name = $department[0]->department_name;
		} else {

			$_department_name = '';
		}

		$fname = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;

		// company info

		$company = $this->Xin_model->read_company_info($user[0]->company_id);

		if (!is_null($company)) {

			$company_name = $company[0]->name;

			$address_1 = $company[0]->address_1;

			$address_2 = $company[0]->address_2;

			$city = $company[0]->city;

			$state = $company[0]->state;

			$zipcode = $company[0]->zipcode;

			$country = $this->Xin_model->read_country_info($company[0]->country);

			if (!is_null($country)) {

				$country_name = $country[0]->country_name;
			} else {

				$country_name = '--';
			}

			$c_info_email = $company[0]->email;

			$c_info_phone = $company[0]->contact_number;
		} else {

			$company_name = '--';

			$address_1 = '--';

			$address_2 = '--';

			$city = '--';

			$state = '--';

			$zipcode = '--';

			$country_name = '--';

			$c_info_email = '--';

			$c_info_phone = '--';
		}

		$location = $this->Location_model->read_location_information($user[0]->location_id);

		if (!is_null($location)) {

			$location_name = $location[0]->location_name;
		} else {

			$location_name = '--';
		}

		$user_role = $this->Roles_model->read_role_information($user[0]->user_role_id);

		if (!is_null($user_role)) {

			$iuser_role = $user_role[0]->role_name;
		} else {

			$iuser_role = '--';
		}

		// set default header data

		//$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode.', '.$country_name;

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		//$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email ";



		$company_info = $this->lang->line('left_company') . ": $company_name | " . $this->lang->line('left_location') . ": $location_name \n";

		$designation_info = $this->lang->line('left_department') . ": $_department_name | " . $this->lang->line('left_designation') . ": $_designation_name \n";



		$header_string = "$company_info" . "$designation_info";

		// set document information

		$pdf->SetCreator('HRSALE');

		$pdf->SetAuthor('HRSALE');

		//$pdf->SetTitle('Workable-Zone - Payslip');

		//$pdf->SetSubject('TCPDF Tutorial');

		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

		if ($user[0]->profile_picture != '' && $user[0]->profile_picture != 'no file') {

			$ol = 'uploads/profile/' . $user[0]->profile_picture;
		} else {

			if ($user[0]->gender == 'Male') {

				$de_file = 'uploads/profile/default_male.jpg';
			} else {

				$de_file = 'uploads/profile/default_female.jpg';
			}

			$ol = $de_file;
		}



		$header_namae = $fname . ' ' . $this->lang->line('xin_profile');

		$pdf->SetHeaderData('../../../' . $ol, 15, $header_namae, $header_string);



		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));



		// set header and footer fonts

		$pdf->setHeaderFont(array('helvetica', '', 11.5));

		$pdf->setFooterFont(array('helvetica', '', 9));



		// set default monospaced font

		$pdf->SetDefaultMonospacedFont('courier');



		// set margins

		$pdf->SetMargins(15, 27, 15);

		$pdf->SetHeaderMargin(5);

		$pdf->SetFooterMargin(10);



		// set auto page breaks

		$pdf->SetAutoPageBreak(TRUE, 25);



		// set image scale factor

		$pdf->setImageScale(1.25);

		$pdf->SetAuthor('HRSALE');

		$pdf->SetTitle($company_name . ' - ' . $this->lang->line('xin_download_profile_title'));

		$pdf->SetSubject($this->lang->line('xin_download_profile_title'));

		$pdf->SetKeywords($this->lang->line('xin_download_profile_title'));

		// set font

		$pdf->SetFont('helvetica', 'B', 10);



		// set header and footer fonts

		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));



		// set default monospaced font

		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);



		// set margins

		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);



		// set auto page breaks

		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);



		// set image scale factor

		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);



		// ---------------------------------------------------------



		// set default font subsetting mode

		$pdf->setFontSubsetting(true);



		// Set font

		// dejavusans is a UTF-8 Unicode font, if you only need to

		// print standard ASCII chars, you can use core fonts like

		// helvetica or times to reduce file size.

		$pdf->SetFont('dejavusans', '', 10, '', true);



		// Add a page

		// This method has several options, check the source code documentation for more information.

		$pdf->AddPage();

		/*$tbl = '<br>

		<table cellpadding="1" cellspacing="1" border="0">

			<tr>

				<td align="center"><h1>'.$fname.'</h1></td>

			</tr>

		</table>

		';

		$pdf->writeHTML($tbl, true, false, false, false, '');*/

		// -----------------------------------------------------------------------------

		$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);



		// set cell padding

		$pdf->setCellPaddings(1, 1, 1, 1);



		// set cell margins

		$pdf->setCellMargins(0, 0, 0, 0);



		// set color for background

		$pdf->SetFillColor(255, 255, 127);

		/////////////////////////////////////////////////////////////////////////////////

		if ($user[0]->marital_status == 'Single') {

			$mstatus = $this->lang->line('xin_status_single');
		} else if ($user[0]->marital_status == 'Married') {

			$mstatus = $this->lang->line('xin_status_married');
		} else if ($user[0]->marital_status == 'Widowed') {

			$mstatus = $this->lang->line('xin_status_widowed');
		} else if ($user[0]->marital_status == 'Divorced or Separated') {

			$mstatus = $this->lang->line('xin_status_divorced_separated');
		} else {

			$mstatus = $this->lang->line('xin_status_single');
		}

		if ($user[0]->is_active == '0') {

			$isactive = $this->lang->line('xin_employees_inactive');
		} else if ($user[0]->is_active == '1') {

			$isactive = $this->lang->line('xin_employees_active');
		} else {

			$isactive = $this->lang->line('xin_employees_inactive');
		}

		$tbl_2 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0" >

			<td colspan="6"><strong>' . $this->lang->line('xin_e_details_basic') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('dashboard_username') . '</b></td>

				<td colspan="2">' . $user[0]->username . '</td>

				<td><b>' . $this->lang->line('dashboard_email') . '</b></td>

				<td colspan="2">' . $user[0]->email . '</td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('dashboard_employee_id') . '</b></td>

				<td colspan="2">' . $user[0]->employee_id . '</td>

				<td><b>' . $this->lang->line('xin_employee_role') . '</b></td>

				<td colspan="2">' . $iuser_role . '</td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('dashboard_xin_status') . '</b></td>

				<td>' . $isactive . '</td>

				<td><b>' . $this->lang->line('xin_employee_gender') . '</b></td>

				<td>' . $user[0]->gender . '</td>

				<td><b>' . $this->lang->line('xin_employee_mstatus') . '</b></td>

				<td>' . $mstatus . '</td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_employee_doj') . '</b></td>

				<td colspan="2">' . $date_of_joining . '</td>

				<td><b>' . $this->lang->line('dashboard_contact') . '</b></td>

				<td colspan="2">' . $user[0]->contact_no . '</td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_state') . '</b></td>

				<td>' . $user[0]->state . '</td>

				<td><b>' . $this->lang->line('xin_city') . '</b></td>

				<td>' . $user[0]->city . '</td>

				<td><b>' . $this->lang->line('xin_zipcode') . '</b></td>

				<td>' . $user[0]->pincode	. '</td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_employee_address') . '</b></td>

				<td colspan="5">' . $user[0]->address . '</td>

			</tr>

		</table>';

		$pdf->writeHTML($tbl_2, true, false, false, false, '');

		//salary

		if ($user[0]->wages_type == 1) {

			$salary_opt = $this->lang->line('xin_payroll_basic_salary');
		} else {

			$salary_opt = $this->lang->line('xin_employee_daily_wages');
		}

		$tbl_3 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="4"><b>' . $this->lang->line('xin_salary_title') . '</b></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_salary_title') . '</b></td>

				<td>' . $this->Xin_model->company_currency_sign($user[0]->basic_salary, $user[0]->company_id) . '</td>

				<td><b>' . $this->lang->line('xin_employee_type_wages') . '</b></td>

				<td>' . $salary_opt . '</td>

			</tr>

			</table>';

		$pdf->writeHTML($tbl_3, true, false, false, false, '');

		//CORE HR

		// awards

		$count_awards = $this->Xin_model->get_employee_awards_count($user[0]->user_id);

		if ($count_awards > 0) {

			$tbl_4 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="3"><strong>' . $this->lang->line('left_awards') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_award_name') . '</b></td>

				<td><b>' . $this->lang->line('xin_gift') . '</b></td>

				<td><b>' . $this->lang->line('xin_award_month_year') . '</b></td>

			</tr>';

			$award = $this->Awards_model->get_employee_awards($user[0]->user_id);

			foreach ($award->result() as $r) {

				// get award type

				$award_type = $this->Awards_model->read_award_type_information($r->award_type_id);

				if (!is_null($award_type)) {

					$award_type = $award_type[0]->award_type;
				} else {

					$award_type = '--';
				}

				$d = explode('-', $r->award_month_year);

				$get_month = date('F', mktime(0, 0, 0, $d[1], 10));

				$award_date = $get_month . ', ' . $d[0];

				// get currency

				if ($r->cash_price == '') {

					$currency = $this->Xin_model->company_currency_sign(0, $r->company_id);
				} else {

					$currency = $this->Xin_model->company_currency_sign($r->cash_price, $r->company_id);
				}

				$tbl_4 .= '

			<tr>

				<td>' . $award_type . '</td>

				<td>' . $r->gift_item . '</td>

				<td>' . $award_date . '</td>

			</tr>';
			}

			$tbl_4 .= '</table>';

			$pdf->writeHTML($tbl_4, true, false, false, false, '');
		}

		// TRAINING

		$count_training = $this->Xin_model->get_employee_training_count($user[0]->user_id);

		if ($count_training > 0) {

			$tbl_5 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="4"><strong>' . $this->lang->line('left_training') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('left_training_type') . '</b></td>

				<td><b>' . $this->lang->line('xin_trainer') . '</b></td>

				<td><b>' . $this->lang->line('xin_training_duration') . '</b></td>

				<td><b>' . $this->lang->line('xin_cost') . '</b></td>

			</tr>';

			$training = $this->Training_model->get_employee_training($user[0]->user_id);

			foreach ($training->result() as $tr_in) {

				// get training type

				$type = $this->Training_model->read_training_type_information($tr_in->training_type_id);

				if (!is_null($type)) {

					$itype = $type[0]->type;
				} else {

					$itype = '--';
				}

				// get trainer

				$trainer = $this->Xin_model->read_user_info($tr_in->trainer_id);

				// employee full name

				if (!is_null($trainer)) {

					$trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->middle_name . ' ' . $trainer[0]->last_name;
				} else {

					$trainer_name = '--';
				}

				// get end date

				$finish_date = $this->Xin_model->set_date_format($tr_in->finish_date);

				if ($tr_in->training_status == 0) :

					$training_status = $this->lang->line('xin_pending');

				elseif ($tr_in->training_status == 1) :

					$training_status = $this->lang->line('xin_started');

				elseif ($tr_in->training_status == 2) :

					$training_status = $this->lang->line('xin_completed');

				else :

					$training_status = $this->lang->line('xin_terminated');

				endif;

				$tbl_5 .= '

			<tr>

				<td><b>' . $itype . '</b></td>

				<td><b>' . $trainer_name . '</b></td>

				<td><b>' . $finish_date . '</b></td>

				<td><b>' . $training_status . '</b></td>

			</tr>';
			}

			$tbl_5 .= '</table>';

			$pdf->writeHTML($tbl_5, true, false, false, false, '');
		}

		// warning

		$count_warning = $this->Xin_model->get_employee_warning_count($user[0]->user_id);

		if ($count_warning > 0) {

			$tbl_5 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="4"><strong>' . $this->lang->line('left_warnings') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_subject') . '</b></td>

				<td><b>' . $this->lang->line('xin_warning_type') . '</b></td>

				<td><b>' . $this->lang->line('xin_warning_date') . '</b></td>

				<td><b>' . $this->lang->line('xin_warning_by') . '</b></td>

			</tr>';

			$warning = $this->Warning_model->get_employee_warning($user[0]->user_id);

			foreach ($warning->result() as $wr) {

				// get warning date

				$warning_date = $this->Xin_model->set_date_format($wr->warning_date);

				// get warning type

				$warning_type = $this->Warning_model->read_warning_type_information($wr->warning_type_id);

				if (!is_null($warning_type)) {

					$wtype = $warning_type[0]->type;
				} else {

					$wtype = '--';
				}

				// get user > warning by

				$user_by = $this->Xin_model->read_user_info($wr->warning_by);

				// user full name

				if (!is_null($user_by)) {

					$warning_by = $user_by[0]->first_name . ' ' . $user_by[0]->middle_name . ' ' . $user_by[0]->last_name;
				} else {

					$warning_by = '--';
				}

				$tbl_5 .= '

			<tr>

				<td>' . $wr->subject . '</td>

				<td>' . $wtype . '</td>

				<td>' . $warning_date . '</td>

				<td>' . $warning_by . '</td>

			</tr>';
			}

			$tbl_5 .= '</table>';

			$pdf->writeHTML($tbl_5, true, false, false, false, '');
		}

		// travel

		$travel_count = $this->Xin_model->get_employee_travel_count($user[0]->user_id);

		if ($travel_count > 0) {

			$tbl_6 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="5"><strong>' . $this->lang->line('xin_travel') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_visit_place') . '</b></td>

				<td colspan="2"><b>' . $this->lang->line('xin_budget_title') . '</b></td>

				<td><b>' . $this->lang->line('dashboard_xin_status') . '</b></td>

				<td><b>' . $this->lang->line('xin_end_date') . '</b></td>

			</tr>';

			$travel = $this->Travel_model->get_employee_travel($user[0]->user_id);

			foreach ($travel->result() as $trv) {

				// get warning date

				//$warning_date = $this->Xin_model->set_date_format($trv->warning_date);

				if ($trv->status == 0) :

					$status = $this->lang->line('xin_pending');

				elseif ($trv->status == 1) :

					$status = $this->lang->line('xin_accepted');

				else :

					$status = $this->lang->line('xin_rejected');

				endif;

				$expected_budget = $this->Xin_model->company_currency_sign($trv->expected_budget, $trv->company_id);

				$actual_budget = $this->Xin_model->company_currency_sign($trv->actual_budget, $trv->company_id);

				$t_budget = $this->lang->line('xin_expected_travel_budget') . ': ' . $expected_budget . '<br>' . $this->lang->line('xin_actual_travel_budget') . ': ' . $expected_budget;

				// get end date

				$end_date = $this->Xin_model->set_date_format($trv->end_date);

				$tbl_6 .= '

			<tr>

				<td>' . $trv->visit_place . '</td>

				<td colspan="2">' . $t_budget . '</td>

				<td>' . $status . '</td>

				<td>' . $end_date . '</td>

			</tr>';
			}

			$tbl_6 .= '</table>';

			$pdf->writeHTML($tbl_6, true, false, false, false, '');
		}



		// tickets

		$tickets_count = $this->Xin_model->get_employee_tickets_count($user[0]->user_id);

		if ($tickets_count > 0) {

			$tbl_7 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="5"><strong>' . $this->lang->line('left_tickets') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_ticket_code') . '</b></td>

				<td><b>' . $this->lang->line('xin_subject') . '</b></td>

				<td><b>' . $this->lang->line('xin_p_priority') . '</b></td>

				<td  colspan="2"><b>' . $this->lang->line('xin_e_details_date') . '</b></td>

			</tr>';

			$ticket = $this->Tickets_model->get_employee_tickets($user[0]->user_id);

			foreach ($ticket->result() as $tkts) {



				if ($tkts->ticket_priority == 0) :

					$ticket_priority = $this->lang->line('xin_low');

				elseif ($tkts->ticket_priority == 2) :

					$ticket_priority = $this->lang->line('xin_medium');

				elseif ($tkts->ticket_priority == 3) :

					$ticket_priority = $this->lang->line('xin_high');

				elseif ($tkts->ticket_priority == 4) :

					$ticket_priority = $this->lang->line('xin_critical');

				else :

					$ticket_priority = $this->lang->line('xin_low');

				endif;

				if ($tkts->ticket_status == 1) :

					$status = $this->lang->line('xin_open');

				else :

					$status = $this->lang->line('xin_closed');

				endif;



				// ticket_code

				$iticket_code = $tkts->ticket_code . '<br>' . $status;

				$created_at = date('h:i A', strtotime($tkts->created_at));

				$_date = explode(' ', $tkts->created_at);

				$edate = $this->Xin_model->set_date_format($_date[0]);

				$_created_at = $edate . ' ' . $created_at;



				$tbl_7 .= '

			<tr>

				<td>' . $iticket_code . '</td>

				<td>' . $tkts->subject . '</td>

				<td>' . $ticket_priority . '</td>

				<td colspan="2">' . $_created_at . '</td>

			</tr>';
			}

			$tbl_7 .= '</table>';

			$pdf->writeHTML($tbl_7, true, false, false, false, '');
		}



		// projects

		$projects_count = $this->Xin_model->get_employee_projects_count($user[0]->user_id);

		if ($projects_count > 0) {

			$tbl_8 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="5"><strong>' . $this->lang->line('left_projects') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('dashboard_xin_title') . '</b></td>

				<td><b>' . $this->lang->line('dashboard_xin_progress') . '</b></td>

				<td><b>' . $this->lang->line('xin_end_date') . '</b></td>

				<td  colspan="2"><b>' . $this->lang->line('dashboard_xin_status') . '</b></td>

			</tr>';

			$project = $this->Project_model->get_employee_projects($user[0]->user_id);

			foreach ($project->result() as $prj) {



				if ($prj->status == 0) {

					$status = $this->lang->line('xin_not_started');
				} else if ($prj->status == 1) {

					$status = $this->lang->line('xin_in_progress');
				} else if ($prj->status == 2) {

					$status = $this->lang->line('xin_completed');
				} else {

					$status = $this->lang->line('xin_deffered');
				}



				$pdate = $this->Xin_model->set_date_format($prj->end_date);



				$tbl_8 .= '

				<tr>

					<td>' . $prj->title . '</td>

					<td>' . $prj->project_progress . '% ' . $this->lang->line('xin_completed') . '</td>

					<td>' . $pdate . '</td>

					<td colspan="2">' . $status . '</td>

				</tr>';
			}

			$tbl_8 .= '</table>';

			$pdf->writeHTML($tbl_8, true, false, false, false, '');
		}

		// tasks

		$tasks_count = $this->Xin_model->get_employee_tasks_count($user[0]->user_id);

		if ($tasks_count > 0) {

			$tbl_9 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="5"><strong>' . $this->lang->line('left_tasks') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('dashboard_xin_title') . '</b></td>

				<td><b>' . $this->lang->line('dashboard_xin_progress') . '</b></td>

				<td><b>' . $this->lang->line('xin_end_date') . '</b></td>

				<td  colspan="2"><b>' . $this->lang->line('dashboard_xin_status') . '</b></td>

			</tr>';

			$task = $this->Timesheet_model->get_employee_tasks($user[0]->user_id);

			foreach ($task->result() as $tsk) {



				// task end date

				$tdate = $this->Xin_model->set_date_format($tsk->end_date);

				// task status

				if ($tsk->task_status == 0) {

					$status = $this->lang->line('xin_not_started');
				} else if ($tsk->task_status == 1) {

					$status = $this->lang->line('xin_in_progress');
				} else if ($tsk->task_status == 2) {

					$status = $this->lang->line('xin_completed');
				} else {

					$status = $this->lang->line('xin_deffered');
				}



				$tbl_9 .= '

				<tr>

					<td>' . $tsk->task_name . '</td>

					<td>' . $tsk->task_progress . '% ' . $this->lang->line('xin_completed') . '</td>

					<td>' . $tdate . '</td>

					<td colspan="2">' . $status . '</td>

				</tr>';
			}

			$tbl_9 .= '</table>';

			$pdf->writeHTML($tbl_9, true, false, false, false, '');
		}

		// assets

		$assets_count = $this->Xin_model->get_employee_assets_count($user[0]->user_id);

		if ($assets_count > 0) {

			$tbl_10 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="5"><strong>' . $this->lang->line('xin_assets') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_asset_name') . '</b></td>

				<td><b>' . $this->lang->line('xin_acc_category') . '</b></td>

				<td colspan="2"><b>' . $this->lang->line('xin_company_asset_code') . '</b></td>

				<td><b>' . $this->lang->line('xin_is_working') . '</b></td>

			</tr>';

			$assets = $this->Assets_model->get_employee_assets($user[0]->user_id);

			foreach ($assets->result() as $asts) {



				// get category

				$assets_category = $this->Assets_model->read_assets_category_info($asts->assets_category_id);

				if (!is_null($assets_category)) {

					$category = $assets_category[0]->category_name;
				} else {

					$category = '--';
				}

				//working?

				if ($asts->is_working == 1) {

					$working = $this->lang->line('xin_yes');
				} else {

					$working = $this->lang->line('xin_no');
				}



				$tbl_10 .= '

				<tr>

					<td>' . $asts->name . '</td>

					<td>' . $category . '</td>

					<td colspan="2">' . $asts->company_asset_code . '</td>

					<td>' . $working . '</td>

				</tr>';
			}

			$tbl_10 .= '</table>';

			$pdf->writeHTML($tbl_10, true, false, false, false, '');
		}

		// meetings

		$meetings_count = $this->Xin_model->get_employee_meetings_count($user[0]->user_id);

		if ($meetings_count > 0) {

			$tbl_11 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="3"><strong>' . $this->lang->line('xin_hr_meetings') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_hr_meeting_title') . '</b></td>

				<td><b>' . $this->lang->line('xin_hr_meeting_date') . '</b></td>

				<td><b>' . $this->lang->line('xin_hr_meeting_time') . '</b></td>

			</tr>';

			$meetings = $this->Meetings_model->get_employee_meetings($user[0]->user_id);

			foreach ($meetings->result() as $meetings_hr) {



				// get start date and end date

				$meeting_date = $this->Xin_model->set_date_format($meetings_hr->meeting_date);

				$meeting_time = new DateTime($meetings_hr->meeting_time);

				$metime = $meeting_time->format('h:i a');



				$tbl_11 .= '

				<tr>

					<td>' . $meetings_hr->meeting_title . '</td>

					<td>' . $meeting_date . '</td>

					<td>' . $metime . '</td>

				</tr>';
			}

			$tbl_11 .= '</table>';

			$pdf->writeHTML($tbl_11, true, false, false, false, '');
		}

		// events

		$events_count = $this->Xin_model->get_employee_events_count($user[0]->user_id);

		if ($events_count > 0) {

			$tbl_12 = '

		<table cellpadding="2" cellspacing="0" border="1">

			<tr bgcolor="#e0e0e0">

			<td colspan="3"><strong>' . $this->lang->line('xin_hr_events') . '</strong></td>

			</tr>

			<tr>

				<td><b>' . $this->lang->line('xin_hr_event_title') . '</b></td>

				<td><b>' . $this->lang->line('xin_hr_event_date') . '</b></td>

				<td><b>' . $this->lang->line('xin_hr_event_time') . '</b></td>

			</tr>';

			$events = $this->Events_model->get_employee_events($user[0]->user_id);

			foreach ($events->result() as $events_hr) {



				// get start date and end date

				$sdate = $this->Xin_model->set_date_format($events_hr->event_date);

				// get time am/pm

				$event_time = new DateTime($events_hr->event_time);

				$etime = $event_time->format('h:i a');



				$tbl_12 .= '

				<tr>

					<td>' . $events_hr->event_title . '</td>

					<td>' . $sdate . '</td>

					<td>' . $etime . '</td>

				</tr>';
			}

			$tbl_12 .= '</table>';

			$pdf->writeHTML($tbl_12, true, false, false, false, '');
		}





		$fname = strtolower($fname);

		$pay_month = strtolower(date("F Y"));

		//Close and output PDF document

		ob_start();

		$pdf->Output('payslip_' . $fname . '_' . $pay_month . '.pdf', 'I');

		ob_end_flush();
	}



	public function employees_cards_list()

	{



		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employees_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));





		$employee = $this->Employees_model->get_employees();

		$countries = $this->Xin_model->get_countries();



		$data = array();

		$function = '<table>';

		foreach (array_chunk($countries, 4) as $row) {

			$function .= '<tr>';

			foreach ($row as $value) {

				$function .= '<td>

        <div class="col-xl-12 col-md-12 col-xs-12">

                    <div class="card">

                        <div class="text-xs-center">

                            <div class="card-block">

                                <img src="' . base_url() . 'skin/app-assets/images/portrait/medium/avatar-m-4.png" class="rounded-circle  height-150" alt="Card image">

                            </div>

                            <div class="card-block">

                                <h4 class="card-title">asddd</h4>

                                <h6 class="card-subtitle text-muted">asddd</h6>

                            </div>

                            <div class="text-xs-center">

                                <a href="#" class="btn btn-social-icon mr-1 mb-1 btn-outline-facebook"><span class="fa fa-facebook"></span></a>

                                <a href="#" class="btn btn-social-icon mr-1 mb-1 btn-outline-twitter"><span class="fa fa-twitter"></span></a>

                                <a href="#" class="btn btn-social-icon mb-1 btn-outline-linkedin"><span class="fa fa-linkedin font-medium-4"></span></a>

                            </div>

                        </div>

                    </div>

                </div>

                </td>';

				$function .= '</tr>';
			}

			$data[] = array(

				$function

			);
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $employee->num_rows(),

			"recordsFiltered" => $employee->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function detail_view()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$id = $this->uri->segment(4);

		$result = $this->Employees_model->read_employee_information($id);

		if (is_null($result)) {

			redirect('admin/employees');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$check_role = $this->Employees_model->read_employee_information($session['user_id']);

		if (!in_array('79', $role_resources_ids)) {

			redirect('admin/employees');
		}

		/*if($check_role[0]->user_id!=$result[0]->user_id) {

			redirect('admin/employees');

		}*/



		//$role_resources_ids = $this->Xin_model->user_role_resource();

		//$data['breadcrumbs'] = $this->lang->line('xin_employee_details');

		//$data['path_url'] = 'employees_detail';	

		/*$search_detail = $this->uri->segment(5);
  if(isset($search_detail) == 'search'){
      $breadcrumbs = $this->lang->line('xin_employee_detail').' : '.$result[0]->first_name.' '.$result[0]->last_name;
  }else{
      $breadcrumbs = $this->lang->line('xin_employee_detail');
  }*/
		$printed = '';
		if ($result[0]->serialized != "" && $result[0]->serialized != 'null' && $result[0]->serialized != 'NULL' && $result[0]->serialized != NULL && $result[0]->serialized != null) {
			$printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($result[0]->serialized);
			if ($result[0]->first_name != $ress['first_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_first_name') . " : " . $ress['first_name'] . "</span></br>";
			}
			if ($result[0]->middle_name != $ress['middle_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_middle_name') . " : " . $ress['middle_name'] . "</span></br>";
			}
			if ($result[0]->last_name != $ress['last_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_last_name') . " : " . $ress['last_name'] . "</span></br>";
			}
			if ($result[0]->arabic_name != $ress['arabic_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_arabic_name') . " : " . $ress['arabic_name'] . "</span></br>";
			}
			if ($result[0]->address != $ress['address']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_address') . " : " . $ress['address'] . "</span></br>";
			}
			if ($result[0]->company_id != $ress['company_id']) {
				$get_all_companies = $this->Xin_model->get_companies();
				$all_company = '';
				foreach ($get_all_companies as $company) {
					if (isset($_GET)) {
						if (in_array($company->company_id, explode(",", $ress['company_id']))) {
							$all_company = $all_company . $company->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('left_company') . " : " . $all_company . "</span></br>";
			}
			if ($result[0]->location_id != $ress['location_id']) {
				$all_office_locations = $this->Location_model->all_office_locations();
				$all_locations = '';
				foreach ($all_office_locations as $location) {
					if (isset($_GET)) {
						if (in_array($location->location_id, explode(",", $ress['location_id']))) {
							$all_locations = $all_locations . $location->location_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('left_location') . " : " . $all_locations . "</span></br>";
			}
			if ($result[0]->username != $ress['username']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_username') . " : " . $ress['username'] . "</span></br>";
			}
			if ($result[0]->email != $ress['email']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_email') . " : " . $ress['email'] . "</span></br>";
			}
			if ($result[0]->date_of_birth != $ress['date_of_birth']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_dob') . " : " . $ress['date_of_birth'] . "</span></br>";
			}
			if ($result[0]->gender != $ress['gender']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_gender') . " : " . $ress['gender'] . "</span></br>";
			}
			if ($result[0]->user_role_id != $ress['user_role_id']) {
				$all_user_roles = $this->Roles_model->all_user_roles();
				$all_user_roless = '';
				// var_dump($all_user_roles);
				foreach ($all_user_roles as $role) {
					if (isset($_GET)) {
						if (in_array($role->role_id, explode(",", $ress['user_role_id']))) {
							$all_user_roless = $all_user_roless . $role->role_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_role') . " : " . $all_user_roless . "</span></br>";
			}
			if ($result[0]->department_id != $ress['department_id']) {
				$all_departments = $this->Department_model->all_departments();
				$all_department = '';
				// var_dump($all_departments);
				foreach ($all_departments as $department) {
					if (isset($_GET)) {
						if (in_array($department->department_id, explode(",", $ress['department_id']))) {
							$all_department = $all_department . $department->department_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_department') . " : " . $all_department . "</span></br>";
			}
			if ($result[0]->sub_department_id != $ress['sub_department_id']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_department') . " : " . $ress['sub_department_id'] . "</span></br>";
			}
			if ($result[0]->designation_id != $ress['designation_id']) {
				$all_designation = $this->Designation_model->all_designations();
				$all_designations = '';
				foreach ($all_designation as $designation) {
					if (isset($_GET)) {
						if (in_array($designation->designation_id, explode(",", $ress['designation_id']))) {
							$all_designations = $all_designations . $designation->designation_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_designation') . " : " . $all_designations . "</span></br>";
			}
			if ($result[0]->date_of_joining != $ress['date_of_joining']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_doj') . " : " . $ress['date_of_joining'] . "</span></br>";
			}
			if ($result[0]->leave_updated_date != $ress['leave_updated_date']) {
				$printed = $printed . "<span>Leave Updated : " . $ress['leave_updated_date'] . "</span></br>";
			}
			if ($result[0]->contact_no != $ress['contact_no']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_contact_number') . " : " . $ress['contact_no'] . "</span></br>";
			}
			if ($result[0]->state != $ress['state']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_state') . " : " . $ress['state'] . "</span></br>";
			}
			if ($result[0]->city != $ress['city']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_city') . " : " . $ress['city'] . "</span></br>";
			}
			if ($result[0]->pincode != $ress['pincode']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_pincode') . " : " . $ress['pincode'] . "</span></br>";
			}
			if ($result[0]->ethnicity_type != $ress['ethnicity_type']) {
				$all_ethnicity_types = $this->Employees_model->all_ethnicity_type();
				$all_ethnicity_type = '';
				foreach ($all_ethnicity_types as $ethnicity_type) {
					if (isset($_GET)) {
						if (in_array($ethnicity_type->ethnicity_type_id, explode(",", $ress['ethnicity_type']))) {
							$all_ethnicity_type = $all_ethnicity_type . $ethnicity_type->type;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_ethnicity_type_title') . " : " . $all_ethnicity_type . "</span></br>";
			}
			if ($result[0]->leave_categories != $ress['leave_categories']) {
				$all_leaves = ' ';
				$i = 0;
				$get_all_leave_types = $this->Timesheet_model->all_leave_types();
				foreach ($get_all_leave_types as $leave_type) {
					if (isset($_GET)) {
						if (in_array($leave_type->leave_type_id, explode(",", $ress['leave_categories']))) {
							if ($i != 0) {
								$all_leaves = $all_leaves . ',';
							}
							$all_leaves = $all_leaves . $leave_type->type_name;
							$i++;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_hr_leave_cat') . " : " . $all_leaves . "</span></br>";
			}
			if ($result[0]->view_companies_id != $ress['view_companies_id']) {
				$all_companies_id = ' ';
				$i = 0;
				$get_all_companies_id = $this->Xin_model->get_companies();
				foreach ($get_all_companies_id as $company) {
					if (isset($_GET)) {
						if (in_array($company->company_id, explode(",", $ress['view_companies_id']))) {
							if ($i != 0) {
								$all_companies_id = $all_companies_id . ',';
							}
							$all_companies_id = $all_companies_id . $company->name;
							$i++;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_view_companies_data') . " : " . $all_companies_id . "</span></br>";
			}
			if ($result[0]->date_of_leaving != $ress['date_of_leaving']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_dol') . " : " . $ress['date_of_leaving'] . "</span></br>";
			}
			if ($result[0]->marital_status != $ress['marital_status']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_mstatus') . " : " . $ress['marital_status'] . "</span></br>";
			}
			if ($result[0]->blood_group != $ress['blood_group']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_blood_group') . " : " . $ress['blood_group'] . "</span></br>";
			}
			if ($result[0]->citizenship_id != $ress['citizenship_id']) {
				$all_citizenships = $this->Xin_model->get_countries();
				$all_citizenship = '';
				foreach ($all_citizenships as $citizenship) {
					if (isset($_GET)) {
						if (in_array($citizenship->country_id, explode(",", $ress['citizenship_id']))) {
							$all_citizenship = $all_citizenship . $citizenship->country_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_citizenship') . " : " . $all_citizenship . "</span></br>";
			}
			if ($result[0]->nationality_id != $ress['nationality_id']) {
				$all_citizenships = $this->Xin_model->get_countries();
				$all_citizenship = '';
				foreach ($all_citizenships as $citizenship) {
					if (isset($_GET)) {
						if (in_array($citizenship->country_id, explode(",", $ress['nationality_id']))) {
							$all_citizenship = $all_citizenship . $citizenship->country_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_nationality') . " : " . $all_citizenship . "</span></br>";
			}
			if ($result[0]->is_active != $ress['is_active']) {
				if ($ress['is_active'] == 0) {
					$printed = $printed . "<span>" . $this->lang->line('dashboard_xin_status') . " : Inactive</span></br>";
				} else {
					$printed = $printed . "<span>" . $this->lang->line('dashboard_xin_status') . " : Active</span></br>";
				}
			}
			if ($result[0]->resignation_date != $ress['resignation_date']) {
				$printed = $printed . "<span>Date of Regsignation : " . $ress['resignation_date'] . "</span></br>";
			}
			if ($result[0]->notice_period != $ress['notice_period']) {
				$printed = $printed . "<span>Notice Period : " . $ress['notice_period'] . "</span></br>";
			}
			if ($result[0]->final_remark != $ress['final_remark']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_final_Settlement_remarks') . " : " . $ress['final_remark'] . "</span></br>";
			}
			if ($result[0]->nature_of_leaving != $ress['nature_of_leaving']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_natureof_leaving') . " : " . $ress['nature_of_leaving'] . "</span></br>";
			}
			if ($result[0]->serial_no != $ress['serial_no']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_employee_code') . " : " . $ress['serial_no'] . "</span></br>";
			}
			if ($result[0]->ot_eligible != $ress['ot_eligible']) {
				$printed = $printed . "<span> Overtime Eligibility' : " . $ress['ot_eligible'] . "</span></br>";
			}
			if ($result[0]->annual_leave_expire_months != $ress['annual_leave_expire_months']) {
				$printed = $printed . "<span>Annual leave duration to expiry in months : " . $ress['annual_leave_expire_months'] . "</span></br>";
			}
			$printed = $printed . "</div>";
			$result[0]->first_name = $ress['first_name'];
			$result[0]->middle_name = $ress['middle_name'];
			$result[0]->last_name = $ress['last_name'];
			$result[0]->arabic_name = $ress['arabic_name'];
			$result[0]->address = $ress['address'];
			$result[0]->company_id = $ress['company_id'];
			$result[0]->location_id = $ress['location_id'];
			$result[0]->username = $ress['username'];
			$result[0]->email = $ress['email'];
			$result[0]->date_of_birth = $ress['date_of_birth'];
			$result[0]->gender = $ress['gender'];
			$result[0]->user_role_id = $ress['user_role_id'];
			$result[0]->department_id = $ress['department_id'];
			$result[0]->sub_department_id = $ress['sub_department_id'];
			$result[0]->designation_id = $ress['designation_id'];
			$result[0]->date_of_joining = $ress['date_of_joining'];
			$result[0]->leave_updated_date = $ress['leave_updated_date'];
			$result[0]->contact_no = $ress['contact_no'];
			$result[0]->state = $ress['state'];
			$result[0]->city = $ress['city'];
			$result[0]->pincode = $ress['pincode'];
			$result[0]->ethnicity_type = $ress['ethnicity_type'];
			$result[0]->leave_categories = $ress['leave_categories'];
			$result[0]->view_companies_id = $ress['view_companies_id'];
			$result[0]->date_of_leaving = $ress['date_of_leaving'];
			$result[0]->marital_status = $ress['marital_status'];
			$result[0]->blood_group = $ress['blood_group'];
			$result[0]->citizenship_id = $ress['citizenship_id'];
			$result[0]->nationality_id = $ress['nationality_id'];
			$result[0]->is_active = $ress['is_active'];
			$result[0]->resignation_date = $ress['resignation_date'];
			$result[0]->notice_period = $ress['notice_period'];
			$result[0]->final_remark = $ress['final_remark'];
			$result[0]->nature_of_leaving = $ress['nature_of_leaving'];
			$result[0]->serial_no = $ress['serial_no'];
			$result[0]->company_code = $ress['company_code'];
			$result[0]->dept_code = $ress['dept_code'];
			$result[0]->designation_code = $ress['designation_code'];
			$result[0]->ot_eligible = $ress['ot_eligible'];
			$result[0]->annual_leave_expire_months = $ress['annual_leave_expire_months'];
		}
		$profile_printed = '';
		if ($result[0]->serialize_profile_picture != "") {
			$profile_printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$profile = unserialize($result[0]->serialize_profile_picture);
			if ($result[0]->profile_picture != $profile['profile_picture']) {
				$profile_printed = $profile_printed . "<span>" . $this->lang->line('xin_download_profile_title') . " : " . $profile['profile_picture'] . "</span></br>";
			}
			$profile_printed = $profile_printed . '</div>';
			$result[0]->profile_picture = $profile['profile_picture'];
		}
		$social_printed = '';
		if ($result[0]->serialized_social != "" && $result[0]->serialized_social != 'null' && $result[0]->serialized_social != 'NULL' && $result[0]->serialized_social != NULL && $result[0]->serialized_social != null) {
			$social_printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$social = unserialize($result[0]->serialized_social);
			if ($result[0]->facebook_link != $social['facebook_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_fb_profile') . " : " . $social['facebook_link'] . "</span></br>";
			}
			if ($result[0]->twitter_link != $social['twitter_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_twit_profile') . " : " . $social['twitter_link'] . "</span></br>";
			}
			if ($result[0]->blogger_link != $social['blogger_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_blogr_profile') . " : " . $social['blogger_link'] . "</span></br>";
			}
			if ($result[0]->linkdedin_link != $social['linkdedin_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_linkd_profile') . " : " . $social['linkdedin_link'] . "</span></br>";
			}
			if ($result[0]->google_plus_link != $social['google_plus_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_gplus_profile') . " : " . $social['google_plus_link'] . "</span></br>";
			}
			if ($result[0]->instagram_link != $social['instagram_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_insta_profile') . " : " . $social['instagram_link'] . "</span></br>";
			}
			if ($result[0]->pinterest_link != $social['pinterest_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_pintrst_profile') . " : " . $social['pinterest_link'] . "</span></br>";
			}
			if ($result[0]->youtube_link != $social['youtube_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_utube_profile') . " : " . $social['youtube_link'] . "</span></br>";
			}
			$social_printed = $social_printed . '</div>';
			$result[0]->facebook_link = $social['facebook_link'];
			$result[0]->twitter_link = $social['twitter_link'];
			$result[0]->blogger_link = $social['blogger_link'];
			$result[0]->linkdedin_link = $social['linkdedin_link'];
			$result[0]->google_plus_link = $social['google_plus_link'];
			$result[0]->instagram_link = $social['instagram_link'];
			$result[0]->pinterest_link = $social['pinterest_link'];
			$result[0]->youtube_link = $social['youtube_link'];
		}
		$data = array(

			'breadcrumbs' => $this->lang->line('xin_employee_detail') . ' : ' . $result[0]->first_name . ' ' . $result[0]->last_name,

			'path_url' => 'employees_details_view',

			'first_name' => $result[0]->first_name,

			'middle_name' => $result[0]->middle_name,
			'arabic_name' => $result[0]->arabic_name,
			'employee_code' => $result[0]->employee_code,

			'last_name' => $result[0]->last_name,

			'user_id' => $result[0]->user_id,

			'employee_id' => $result[0]->employee_id,

			'company_id' => $result[0]->company_id,

			'location_id' => $result[0]->location_id,

			'office_shift_id' => $result[0]->office_shift_id,

			'ereports_to' => $result[0]->reports_to,

			'username' => $result[0]->username,

			'email' => $result[0]->email,

			'department_id' => $result[0]->department_id,

			'sub_department_id' => $result[0]->sub_department_id,

			'designation_id' => $result[0]->designation_id,

			'user_role_id' => $result[0]->user_role_id,

			'date_of_birth' => $result[0]->date_of_birth,

			'date_of_leaving' => $result[0]->date_of_leaving,

			'gender' => $result[0]->gender,

			'marital_status' => $result[0]->marital_status,

			'contact_no' => $result[0]->contact_no,

			'state' => $result[0]->state,

			'city' => $result[0]->city,

			'zipcode' => $result[0]->pincode,

			'blood_group' => $result[0]->blood_group,

			'citizenship_id' => $result[0]->citizenship_id,

			'nationality_id' => $result[0]->nationality_id,

			'iethnicity_type' => $result[0]->ethnicity_type,

			'address' => $result[0]->address,

			'wages_type' => $result[0]->wages_type,

			'basic_salary' => $result[0]->basic_salary,

			'is_active' => $result[0]->is_active,

			'date_of_joining' => $result[0]->date_of_joining,

			'all_departments' => $this->Department_model->all_departments(),

			'all_designations' => $this->Designation_model->all_designations(),

			'all_user_roles' => $this->Roles_model->all_user_roles(),

			'title' => $this->lang->line('xin_employee_detail') . ' | ' . $this->Xin_model->site_title(),

			'profile_picture' => $result[0]->profile_picture,

			'facebook_link' => $result[0]->facebook_link,

			'twitter_link' => $result[0]->twitter_link,

			'blogger_link' => $result[0]->blogger_link,

			'linkdedin_link' => $result[0]->linkdedin_link,

			'google_plus_link' => $result[0]->google_plus_link,

			'instagram_link' => $result[0]->instagram_link,

			'pinterest_link' => $result[0]->pinterest_link,

			'youtube_link' => $result[0]->youtube_link,

			'leave_categories' => $result[0]->leave_categories,

			'view_companies_id' => $result[0]->view_companies_id,

			'all_countries' => $this->Xin_model->get_countries(),

			'all_document_types' => $this->Employees_model->all_document_types(),

			'all_education_level' => $this->Employees_model->all_education_level(),

			'all_qualification_language' => $this->Employees_model->all_qualification_language(),

			'all_qualification_skill' => $this->Employees_model->all_qualification_skill(),

			'all_contract_types' => $this->Employees_model->all_contract_types(),

			'all_contracts' => $this->Employees_model->all_contracts(),

			'all_office_shifts' => $this->Employees_model->all_office_shifts(),

			'get_all_companies' => $this->Xin_model->get_companies(),

			'all_office_locations' => $this->Location_model->all_office_locations(),

			'all_leave_types' => $this->Timesheet_model->all_leave_types(),

			'all_countries' => $this->Xin_model->get_countries(),

			'final_remark' => $result[0]->final_settlement_remark,

			'resignation_date' => $result[0]->resignation_date,

			'notice_period' => $result[0]->notice_period,

			'nature_of_leaving' => $result[0]->nature_of_leaving,

			'serial_no' => $result[0]->serial_no,

			'ot_eligible'  => $result[0]->ot_eligible,
			'annual_leave_expire_months' => $result[0]->annual_leave_expire_months,
			//'late_deduction' => $result[0]->late_deduction,
			'emp_probation_period_in_months' => $result[0]->probation_period,
			'leave_salary_calculated_date' => $result[0]->leave_salary_calculated_date

		);


		$data['printed'] = $printed;
		$data['social_printed'] = $social_printed;
		$data['profile_printed'] = $profile_printed;
		$data['profile_approval_status'] = $result[0]->profile_approval_status;
		$data['subview'] = $this->load->view("admin/employees/employee_detail_view", $data, TRUE);

		$this->load->view('admin/layout/layout_main', $data); //page load



		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}


	public function detail()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$id = $this->uri->segment(4);

		$result = $this->Employees_model->read_employee_information($id);

		if (is_null($result)) {

			redirect('admin/employees');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$check_role = $this->Employees_model->read_employee_information($session['user_id']);

		if (!in_array('79', $role_resources_ids)) {

			redirect('admin/employees');
		}

		/*if($check_role[0]->user_id!=$result[0]->user_id) {

			redirect('admin/employees');

		}*/



		//$role_resources_ids = $this->Xin_model->user_role_resource();

		//$data['breadcrumbs'] = $this->lang->line('xin_employee_details');

		//$data['path_url'] = 'employees_detail';	

		/*$search_detail = $this->uri->segment(5);
  if(isset($search_detail) == 'search'){
      $breadcrumbs = $this->lang->line('xin_employee_detail').' : '.$result[0]->first_name.' '.$result[0]->last_name;
  }else{
      $breadcrumbs = $this->lang->line('xin_employee_detail');
  }*/
		$printed = '';
		if ($result[0]->serialized != "" && $result[0]->serialized != 'null' && $result[0]->serialized != 'NULL' && $result[0]->serialized != NULL && $result[0]->serialized != null) {
			$printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($result[0]->serialized);
			if ($result[0]->first_name != $ress['first_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_first_name') . " : " . $ress['first_name'] . "</span></br>";
			}
			if ($result[0]->middle_name != $ress['middle_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_middle_name') . " : " . $ress['middle_name'] . "</span></br>";
			}
			if ($result[0]->last_name != $ress['last_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_last_name') . " : " . $ress['last_name'] . "</span></br>";
			}
			if ($result[0]->arabic_name != $ress['arabic_name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_arabic_name') . " : " . $ress['arabic_name'] . "</span></br>";
			}
			if ($result[0]->address != $ress['address']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_address') . " : " . $ress['address'] . "</span></br>";
			}
			if ($result[0]->company_id != $ress['company_id']) {
				$get_all_companies = $this->Xin_model->get_companies();
				$all_company = '';
				foreach ($get_all_companies as $company) {
					if (isset($_GET)) {
						if (in_array($company->company_id, explode(",", $ress['company_id']))) {
							$all_company = $all_company . $company->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('left_company') . " : " . $all_company . "</span></br>";
			}
			if ($result[0]->location_id != $ress['location_id']) {
				$all_office_locations = $this->Location_model->all_office_locations();
				$all_locations = '';
				foreach ($all_office_locations as $location) {
					if (isset($_GET)) {
						if (in_array($location->location_id, explode(",", $ress['location_id']))) {
							$all_locations = $all_locations . $location->location_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('left_location') . " : " . $all_locations . "</span></br>";
			}
			if ($result[0]->username != $ress['username']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_username') . " : " . $ress['username'] . "</span></br>";
			}
			if ($result[0]->email != $ress['email']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_email') . " : " . $ress['email'] . "</span></br>";
			}
			if ($result[0]->date_of_birth != $ress['date_of_birth']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_dob') . " : " . $ress['date_of_birth'] . "</span></br>";
			}
			if ($result[0]->gender != $ress['gender']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_gender') . " : " . $ress['gender'] . "</span></br>";
			}
			if ($result[0]->user_role_id != $ress['user_role_id']) {
				$all_user_roles = $this->Roles_model->all_user_roles();
				$all_user_roless = '';
				// var_dump($all_user_roles);
				foreach ($all_user_roles as $role) {
					if (isset($_GET)) {
						if (in_array($role->role_id, explode(",", $ress['user_role_id']))) {
							$all_user_roless = $all_user_roless . $role->role_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_role') . " : " . $all_user_roless . "</span></br>";
			}
			if ($result[0]->department_id != $ress['department_id']) {
				$all_departments = $this->Department_model->all_departments();
				$all_department = '';
				// var_dump($all_departments);
				foreach ($all_departments as $department) {
					if (isset($_GET)) {
						if (in_array($department->department_id, explode(",", $ress['department_id']))) {
							$all_department = $all_department . $department->department_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_department') . " : " . $all_department . "</span></br>";
			}
			if ($result[0]->sub_department_id != $ress['sub_department_id']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_department') . " : " . $ress['sub_department_id'] . "</span></br>";
			}
			if ($result[0]->designation_id != $ress['designation_id']) {
				$all_designation = $this->Designation_model->all_designations();
				$all_designations = '';
				foreach ($all_designation as $designation) {
					if (isset($_GET)) {
						if (in_array($designation->designation_id, explode(",", $ress['designation_id']))) {
							$all_designations = $all_designations . $designation->designation_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_designation') . " : " . $all_designations . "</span></br>";
			}
			if ($result[0]->date_of_joining != $ress['date_of_joining']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_doj') . " : " . $ress['date_of_joining'] . "</span></br>";
			}
			if ($result[0]->leave_updated_date != $ress['leave_updated_date']) {
				$printed = $printed . "<span>Leave Updated : " . $ress['leave_updated_date'] . "</span></br>";
			}
			if ($result[0]->contact_no != $ress['contact_no']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_contact_number') . " : " . $ress['contact_no'] . "</span></br>";
			}
			if ($result[0]->state != $ress['state']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_state') . " : " . $ress['state'] . "</span></br>";
			}
			if ($result[0]->city != $ress['city']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_city') . " : " . $ress['city'] . "</span></br>";
			}
			if ($result[0]->pincode != $ress['pincode']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_pincode') . " : " . $ress['pincode'] . "</span></br>";
			}
			if ($result[0]->ethnicity_type != $ress['ethnicity_type']) {
				$all_ethnicity_types = $this->Employees_model->all_ethnicity_type();
				$all_ethnicity_type = '';
				foreach ($all_ethnicity_types as $ethnicity_type) {
					if (isset($_GET)) {
						if (in_array($ethnicity_type->ethnicity_type_id, explode(",", $ress['ethnicity_type']))) {
							$all_ethnicity_type = $all_ethnicity_type . $ethnicity_type->type;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_ethnicity_type_title') . " : " . $all_ethnicity_type . "</span></br>";
			}
			if ($result[0]->leave_categories != $ress['leave_categories']) {
				$all_leaves = ' ';
				$i = 0;
				$get_all_leave_types = $this->Timesheet_model->all_leave_types();
				foreach ($get_all_leave_types as $leave_type) {
					if (isset($_GET)) {
						if (in_array($leave_type->leave_type_id, explode(",", $ress['leave_categories']))) {
							if ($i != 0) {
								$all_leaves = $all_leaves . ',';
							}
							$all_leaves = $all_leaves . $leave_type->type_name;
							$i++;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_hr_leave_cat') . " : " . $all_leaves . "</span></br>";
			}
			if ($result[0]->view_companies_id != $ress['view_companies_id']) {
				$all_companies_id = ' ';
				$i = 0;
				$get_all_companies_id = $this->Xin_model->get_companies();
				foreach ($get_all_companies_id as $company) {
					if (isset($_GET)) {
						if (in_array($company->company_id, explode(",", $ress['view_companies_id']))) {
							if ($i != 0) {
								$all_companies_id = $all_companies_id . ',';
							}
							$all_companies_id = $all_companies_id . $company->name;
							$i++;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_view_companies_data') . " : " . $all_companies_id . "</span></br>";
			}
			if ($result[0]->date_of_leaving != $ress['date_of_leaving']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_dol') . " : " . $ress['date_of_leaving'] . "</span></br>";
			}
			if ($result[0]->marital_status != $ress['marital_status']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_mstatus') . " : " . $ress['marital_status'] . "</span></br>";
			}
			if ($result[0]->blood_group != $ress['blood_group']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_blood_group') . " : " . $ress['blood_group'] . "</span></br>";
			}
			if ($result[0]->citizenship_id != $ress['citizenship_id']) {
				$all_citizenships = $this->Xin_model->get_countries();
				$all_citizenship = '';
				foreach ($all_citizenships as $citizenship) {
					if (isset($_GET)) {
						if (in_array($citizenship->country_id, explode(",", $ress['citizenship_id']))) {
							$all_citizenship = $all_citizenship . $citizenship->country_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_citizenship') . " : " . $all_citizenship . "</span></br>";
			}
			if ($result[0]->nationality_id != $ress['nationality_id']) {
				$all_citizenships = $this->Xin_model->get_countries();
				$all_citizenship = '';
				foreach ($all_citizenships as $citizenship) {
					if (isset($_GET)) {
						if (in_array($citizenship->country_id, explode(",", $ress['nationality_id']))) {
							$all_citizenship = $all_citizenship . $citizenship->country_name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_nationality') . " : " . $all_citizenship . "</span></br>";
			}
			if ($result[0]->is_active != $ress['is_active']) {
				if ($ress['is_active'] == 0) {
					$printed = $printed . "<span>" . $this->lang->line('dashboard_xin_status') . " : Inactive</span></br>";
				} else {
					$printed = $printed . "<span>" . $this->lang->line('dashboard_xin_status') . " : Active</span></br>";
				}
			}
			if ($result[0]->resignation_date != $ress['resignation_date']) {
				$printed = $printed . "<span>Date of Regsignation : " . $ress['resignation_date'] . "</span></br>";
			}
			if ($result[0]->notice_period != $ress['notice_period']) {
				$printed = $printed . "<span>Notice Period : " . $ress['notice_period'] . "</span></br>";
			}
			if ($result[0]->final_remark != $ress['final_remark']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_final_Settlement_remarks') . " : " . $ress['final_remark'] . "</span></br>";
			}
			if ($result[0]->nature_of_leaving != $ress['nature_of_leaving']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_employee_natureof_leaving') . " : " . $ress['nature_of_leaving'] . "</span></br>";
			}
			if ($result[0]->serial_no != $ress['serial_no']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_employee_code') . " : " . $ress['serial_no'] . "</span></br>";
			}
			if ($result[0]->ot_eligible != $ress['ot_eligible']) {
				$printed = $printed . "<span> Overtime Eligibility' : " . $ress['ot_eligible'] . "</span></br>";
			}
			if ($result[0]->annual_leave_expire_months != $ress['annual_leave_expire_months']) {
				$printed = $printed . "<span>Annual leave duration to expiry in months : " . $ress['annual_leave_expire_months'] . "</span></br>";
			}
			$printed = $printed . "</div>";
			$result[0]->first_name = $ress['first_name'];
			$result[0]->middle_name = $ress['middle_name'];
			$result[0]->last_name = $ress['last_name'];
			$result[0]->arabic_name = $ress['arabic_name'];
			$result[0]->address = $ress['address'];
			$result[0]->company_id = $ress['company_id'];
			$result[0]->location_id = $ress['location_id'];
			$result[0]->username = $ress['username'];
			$result[0]->email = $ress['email'];
			$result[0]->date_of_birth = $ress['date_of_birth'];
			$result[0]->gender = $ress['gender'];
			$result[0]->user_role_id = $ress['user_role_id'];
			$result[0]->department_id = $ress['department_id'];
			$result[0]->sub_department_id = $ress['sub_department_id'];
			$result[0]->designation_id = $ress['designation_id'];
			$result[0]->date_of_joining = $ress['date_of_joining'];
			$result[0]->leave_updated_date = $ress['leave_updated_date'];
			$result[0]->contact_no = $ress['contact_no'];
			$result[0]->state = $ress['state'];
			$result[0]->city = $ress['city'];
			$result[0]->pincode = $ress['pincode'];
			$result[0]->ethnicity_type = $ress['ethnicity_type'];
			$result[0]->leave_categories = $ress['leave_categories'];
			$result[0]->view_companies_id = $ress['view_companies_id'];
			$result[0]->date_of_leaving = $ress['date_of_leaving'];
			$result[0]->marital_status = $ress['marital_status'];
			$result[0]->blood_group = $ress['blood_group'];
			$result[0]->citizenship_id = $ress['citizenship_id'];
			$result[0]->nationality_id = $ress['nationality_id'];
			$result[0]->is_active = $ress['is_active'];
			$result[0]->resignation_date = $ress['resignation_date'];
			$result[0]->notice_period = $ress['notice_period'];
			$result[0]->final_remark = $ress['final_remark'];
			$result[0]->nature_of_leaving = $ress['nature_of_leaving'];
			$result[0]->serial_no = $ress['serial_no'];
			$result[0]->company_code = $ress['company_code'];
			$result[0]->dept_code = $ress['dept_code'];
			$result[0]->designation_code = $ress['designation_code'];
			$result[0]->ot_eligible = $ress['ot_eligible'];
			$result[0]->annual_leave_expire_months = $ress['annual_leave_expire_months'];
		}
		$profile_printed = '';
		if ($result[0]->serialize_profile_picture != "") {
			$profile_printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$profile = unserialize($result[0]->serialize_profile_picture);
			if ($result[0]->profile_picture != $profile['profile_picture']) {
				$profile_printed = $profile_printed . "<span>" . $this->lang->line('xin_download_profile_title') . " : " . $profile['profile_picture'] . "</span></br>";
			}
			$profile_printed = $profile_printed . '</div>';
			$result[0]->profile_picture = $profile['profile_picture'];
		}
		$social_printed = '';
		if ($result[0]->serialized_social != "" && $result[0]->serialized_social != 'null' && $result[0]->serialized_social != 'NULL' && $result[0]->serialized_social != NULL && $result[0]->serialized_social != null) {
			$social_printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$social = unserialize($result[0]->serialized_social);
			if ($result[0]->facebook_link != $social['facebook_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_fb_profile') . " : " . $social['facebook_link'] . "</span></br>";
			}
			if ($result[0]->twitter_link != $social['twitter_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_twit_profile') . " : " . $social['twitter_link'] . "</span></br>";
			}
			if ($result[0]->blogger_link != $social['blogger_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_blogr_profile') . " : " . $social['blogger_link'] . "</span></br>";
			}
			if ($result[0]->linkdedin_link != $social['linkdedin_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_linkd_profile') . " : " . $social['linkdedin_link'] . "</span></br>";
			}
			if ($result[0]->google_plus_link != $social['google_plus_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_gplus_profile') . " : " . $social['google_plus_link'] . "</span></br>";
			}
			if ($result[0]->instagram_link != $social['instagram_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_insta_profile') . " : " . $social['instagram_link'] . "</span></br>";
			}
			if ($result[0]->pinterest_link != $social['pinterest_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_pintrst_profile') . " : " . $social['pinterest_link'] . "</span></br>";
			}
			if ($result[0]->youtube_link != $social['youtube_link']) {
				$social_printed = $social_printed . "<span>" . $this->lang->line('xin_e_details_utube_profile') . " : " . $social['youtube_link'] . "</span></br>";
			}
			$social_printed = $social_printed . '</div>';
			$result[0]->facebook_link = $social['facebook_link'];
			$result[0]->twitter_link = $social['twitter_link'];
			$result[0]->blogger_link = $social['blogger_link'];
			$result[0]->linkdedin_link = $social['linkdedin_link'];
			$result[0]->google_plus_link = $social['google_plus_link'];
			$result[0]->instagram_link = $social['instagram_link'];
			$result[0]->pinterest_link = $social['pinterest_link'];
			$result[0]->youtube_link = $social['youtube_link'];
		}
		$data = array(

			'breadcrumbs' => $this->lang->line('xin_employee_detail') . ' : ' . $result[0]->first_name . ' ' . $result[0]->last_name,

			'path_url' => 'employees_detail',

			'first_name' => $result[0]->first_name,

			'middle_name' => $result[0]->middle_name,
			'arabic_name' => $result[0]->arabic_name,
			'employee_code' => $result[0]->employee_code,

			'last_name' => $result[0]->last_name,

			'user_id' => $result[0]->user_id,

			'employee_id' => $result[0]->employee_id,

			'company_id' => $result[0]->company_id,

			'location_id' => $result[0]->location_id,

			'office_shift_id' => $result[0]->office_shift_id,

			'ereports_to' => $result[0]->reports_to,

			'username' => $result[0]->username,

			'email' => $result[0]->email,

			'department_id' => $result[0]->department_id,

			'sub_department_id' => $result[0]->sub_department_id,

			'designation_id' => $result[0]->designation_id,

			'user_role_id' => $result[0]->user_role_id,

			'date_of_birth' => $result[0]->date_of_birth,

			'date_of_leaving' => $result[0]->date_of_leaving,

			'gender' => $result[0]->gender,

			'marital_status' => $result[0]->marital_status,

			'contact_no' => $result[0]->contact_no,

			'state' => $result[0]->state,

			'city' => $result[0]->city,

			'zipcode' => $result[0]->pincode,

			'blood_group' => $result[0]->blood_group,

			'citizenship_id' => $result[0]->citizenship_id,

			'nationality_id' => $result[0]->nationality_id,

			'iethnicity_type' => $result[0]->ethnicity_type,

			'address' => $result[0]->address,

			'wages_type' => $result[0]->wages_type,

			'basic_salary' => $result[0]->basic_salary,

			'is_active' => $result[0]->is_active,

			'date_of_joining' => $result[0]->date_of_joining,

			'all_departments' => $this->Department_model->all_departments(),

			'all_designations' => $this->Designation_model->all_designations(),

			'all_user_roles' => $this->Roles_model->all_user_roles(),

			'title' => $this->lang->line('xin_employee_detail') . ' | ' . $this->Xin_model->site_title(),

			'profile_picture' => $result[0]->profile_picture,

			'facebook_link' => $result[0]->facebook_link,

			'twitter_link' => $result[0]->twitter_link,

			'blogger_link' => $result[0]->blogger_link,

			'linkdedin_link' => $result[0]->linkdedin_link,

			'google_plus_link' => $result[0]->google_plus_link,

			'instagram_link' => $result[0]->instagram_link,

			'pinterest_link' => $result[0]->pinterest_link,

			'youtube_link' => $result[0]->youtube_link,

			'leave_categories' => $result[0]->leave_categories,

			'view_companies_id' => $result[0]->view_companies_id,

			'all_countries' => $this->Xin_model->get_countries(),

			'all_document_types' => $this->Employees_model->all_document_types(),

			'all_education_level' => $this->Employees_model->all_education_level(),

			'all_qualification_language' => $this->Employees_model->all_qualification_language(),

			'all_qualification_skill' => $this->Employees_model->all_qualification_skill(),

			'all_contract_types' => $this->Employees_model->all_contract_types(),

			'all_contracts' => $this->Employees_model->all_contracts(),

			'all_office_shifts' => $this->Employees_model->all_office_shifts(),

			'get_all_companies' => $this->Xin_model->get_companies(),

			'all_office_locations' => $this->Location_model->all_office_locations(),

			'all_leave_types' => $this->Timesheet_model->all_leave_types(),

			'all_countries' => $this->Xin_model->get_countries(),

			'final_remark' => $result[0]->final_settlement_remark,

			'resignation_date' => $result[0]->resignation_date,

			'notice_period' => $result[0]->notice_period,

			'nature_of_leaving' => $result[0]->nature_of_leaving,

			'serial_no' => $result[0]->serial_no,

			'ot_eligible'  => $result[0]->ot_eligible,
			'annual_leave_expire_months' => $result[0]->annual_leave_expire_months,
			//'late_deduction' => $result[0]->late_deduction,
			'emp_probation_period_in_months' => $result[0]->probation_period,
			'leave_salary_calculated_date' => $result[0]->leave_salary_calculated_date

		);


		$data['printed'] = $printed;
		$data['social_printed'] = $social_printed;
		$data['profile_printed'] = $profile_printed;
		$data['profile_approval_status'] = $result[0]->profile_approval_status;
		$data['subview'] = $this->load->view("admin/employees/employee_detail", $data, TRUE);

		$this->load->view('admin/layout/layout_main', $data); //page load



		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	public function setup_salary()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$id = $this->uri->segment(4);

		$result = $this->Employees_model->read_employee_information($id);

		if (is_null($result)) {

			redirect('admin/employees');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$check_role = $this->Employees_model->read_employee_information($session['user_id']);

		if (!in_array('83', $role_resources_ids)) {

			redirect('admin/employees');
		}

		/*if($check_role[0]->user_id!=$result[0]->user_id) {

			redirect('admin/employees');

		}*/



		//$role_resources_ids = $this->Xin_model->user_role_resource();

		//$data['breadcrumbs'] = $this->lang->line('xin_employee_details');

		//$data['path_url'] = 'employees_detail';	



		$data = array(

			'breadcrumbs' => $this->lang->line('xin_employee_set_salary'),

			'path_url' => 'setup_salary',

			'first_name' => $result[0]->first_name,

			'last_name' => $result[0]->last_name,

			'user_id' => $result[0]->user_id,

			'employee_id' => $result[0]->employee_id,

			'company_id' => $result[0]->company_id,

			'location_id' => $result[0]->location_id,

			'office_shift_id' => $result[0]->office_shift_id,

			'ereports_to' => $result[0]->reports_to,

			'username' => $result[0]->username,

			'email' => $result[0]->email,

			'department_id' => $result[0]->department_id,

			'sub_department_id' => $result[0]->sub_department_id,

			'designation_id' => $result[0]->designation_id,

			'user_role_id' => $result[0]->user_role_id,

			'date_of_birth' => $result[0]->date_of_birth,

			'date_of_leaving' => $result[0]->date_of_leaving,

			'gender' => $result[0]->gender,

			'marital_status' => $result[0]->marital_status,

			'contact_no' => $result[0]->contact_no,

			'state' => $result[0]->state,

			'city' => $result[0]->city,

			'zipcode' => $result[0]->zipcode,

			'blood_group' => $result[0]->blood_group,

			'citizenship_id' => $result[0]->citizenship_id,

			'nationality_id' => $result[0]->nationality_id,

			'iethnicity_type' => $result[0]->ethnicity_type,

			'address' => $result[0]->address,

			'wages_type' => $result[0]->wages_type,

			'basic_salary' => $result[0]->basic_salary,

			'is_active' => $result[0]->is_active,

			'date_of_joining' => $result[0]->date_of_joining,

			'all_departments' => $this->Department_model->all_departments(),

			'all_designations' => $this->Designation_model->all_designations(),

			'all_user_roles' => $this->Roles_model->all_user_roles(),

			'title' => $this->lang->line('xin_employee_detail') . ' | ' . $this->Xin_model->site_title(),

			'profile_picture' => $result[0]->profile_picture,

			'facebook_link' => $result[0]->facebook_link,

			'twitter_link' => $result[0]->twitter_link,

			'blogger_link' => $result[0]->blogger_link,

			'linkdedin_link' => $result[0]->linkdedin_link,

			'google_plus_link' => $result[0]->google_plus_link,

			'instagram_link' => $result[0]->instagram_link,

			'pinterest_link' => $result[0]->pinterest_link,

			'youtube_link' => $result[0]->youtube_link,

			'leave_categories' => $result[0]->leave_categories,

			'view_companies_id' => $result[0]->view_companies_id,

			'all_countries' => $this->Xin_model->get_countries(),

			'all_document_types' => $this->Employees_model->all_document_types(),

			'all_education_level' => $this->Employees_model->all_education_level(),

			'all_qualification_language' => $this->Employees_model->all_qualification_language(),

			'all_qualification_skill' => $this->Employees_model->all_qualification_skill(),

			'all_contract_types' => $this->Employees_model->all_contract_types(),

			'all_contracts' => $this->Employees_model->all_contracts(),

			'all_office_shifts' => $this->Employees_model->all_office_shifts(),

			'get_all_companies' => $this->Xin_model->get_companies(),

			'all_office_locations' => $this->Location_model->all_office_locations(),

			'all_leave_types' => $this->Timesheet_model->all_leave_types(),

			'all_countries' => $this->Xin_model->get_countries()

		);



		$data['subview'] = $this->load->view("admin/employees/setup_employee_salary", $data, TRUE);

		$this->load->view('admin/layout/layout_main', $data); //page load



		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}



	// get company > departments

	public function get_departments()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = array(

			'company_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/get_departments", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	/* // get location > departments

	 public function get_company_elocations() {



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		

		$data = array(

			'location_id' => $id

			);

		$session = $this->session->userdata('username');

		if(!empty($session)){ 

			$this->load->view("admin/employees/get_company_elocations", $data);

		} else {

			redirect('admin/');

		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

	 } */



	public function dialog_contact()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_contact_information($id);

		$data = array(

			'contact_id' => $result[0]->contact_id,

			'employee_id' => $result[0]->employee_id,

			'relation' => $result[0]->relation,

			'is_primary' => $result[0]->is_primary,

			'is_dependent' => $result[0]->is_dependent,

			'contact_name' => $result[0]->contact_name,

			'work_phone' => $result[0]->work_phone,

			'work_phone_extension' => $result[0]->work_phone_extension,

			'mobile_phone' => $result[0]->mobile_phone,

			'home_phone' => $result[0]->home_phone,

			'work_email' => $result[0]->work_email,

			'personal_email' => $result[0]->personal_email,

			'address_1' => $result[0]->address_1,

			'address_2' => $result[0]->address_2,

			'city' => $result[0]->city,

			'state' => $result[0]->state,

			'zipcode' => $result[0]->zipcode,

			'icountry' => $result[0]->country,

			'all_countries' => $this->Xin_model->get_countries()

		);
		$local_store = $this->Employees_model->read_contact_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['relation'] = $un_local['relation'];
			$data['work_email'] = $un_local['work_email'];
			$data['personal_email'] = $un_local['personal_email'];
			$data['address_1'] = $un_local['address_1'];
			$data['address_2'] = $un_local['address_2'];
			$data['work_phone'] = $un_local['work_phone'];
			$data['work_phone_extension'] = $un_local['work_phone_extension'];
			$data['contact_name'] = $un_local['contact_name'];
			$data['mobile_phone'] = $un_local['mobile_phone'];
			$data['city'] = $un_local['city'];
			$data['is_primary'] = $un_local['is_primary'];
			$data['is_dependent'] = $un_local['is_dependent'];
			$data['home_phone'] = $un_local['home_phone'];
			$data['state'] = $un_local['state'];
			$data['zipcode'] = $un_local['zipcode'];
			$data['country'] = $un_local['country'];
			$data['icountry'] = $un_local['country'];
		}
		$data['changes'] = $this->Employees_model->read_changes_local($id);
		$data['local_store'] = $this->Employees_model->read_local_store($id);

		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	// get company > locations

	public function get_company_elocations()
	{



		$data['title'] = $this->Xin_model->site_title();

		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));

		if (is_numeric($keywords[0])) {

			$id = $keywords[0];



			$data = array(

				'company_id' => $id

			);

			$session = $this->session->userdata('username');

			if (!empty($session)) {

				$data = $this->security->xss_clean($data);

				$this->load->view("admin/employees/get_company_elocations", $data);
			} else {

				redirect('admin/');
			}
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	// get company > office shifts

	public function get_company_office_shifts()
	{



		$data['title'] = $this->Xin_model->site_title();

		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));

		if (is_numeric($keywords[0])) {

			$id = $keywords[0];



			$data = array(

				'company_id' => $id

			);

			$session = $this->session->userdata('username');

			if (!empty($session)) {

				$data = $this->security->xss_clean($data);

				$this->load->view("admin/employees/get_company_office_shifts", $data);
			} else {

				redirect('admin/');
			}
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	// get location > departments

	public function get_location_departments()
	{



		$data['title'] = $this->Xin_model->site_title();

		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));

		if (is_numeric($keywords[0])) {

			$id = $keywords[0];



			$data = array(

				'location_id' => $id

			);

			$session = $this->session->userdata('username');

			if (!empty($session)) {

				$data = $this->security->xss_clean($data);

				$this->load->view("admin/employees/get_location_departments", $data);
			} else {

				redirect('admin/');
			}
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	public function dialog_document()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_document_information($id);
		$document_printed = '';
		if ($document[0]->serialized != "" && $document[0]->serialized != 'null' && $document[0]->serialized != 'NULL' && $document[0]->serialized != NULL && $document[0]->serialized != null) {
			$document_printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($document[0]->serialized);
			if ($document[0]->document_type_id != $ress['document_type_id']) {
				$all_document_types = $this->Employees_model->all_document_types();
				$all_document = '';
				foreach ($all_document_types as $documentss) {
					// var_dump($document);die();
					if (isset($_GET)) {
						if (in_array($documentss->document_type_id, explode(",", $ress['document_type_id']))) {
							$all_document = $all_document . $documentss->document_type;
						}
					}
				}
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_e_details_document') . " : " . $all_document . "</span></br>";
			}
			if ($document[0]->date_of_expiry != $ress['date_of_expiry']) {
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_e_details_doe') . " : " . $ress['date_of_expiry'] . "</span></br>";
			}
			if ($document[0]->title != $ress['title']) {
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_payroll_hourly_wage_title_single') . " : " . $ress['title'] . "</span></br>";
			}
			if ($document[0]->description != $ress['description']) {
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_description') . " : " . $ress['description'] . "</span></br>";
			}
			if (isset($ress['document_file'])) {
				if ($document[0]->document_file != $ress['document_file']) {
					$document_printed = $document_printed . "<span>" . $this->lang->line('xin_e_details_document_file') . " : " . $ress['document_file'] . "</span></br>";
				}
				$document[0]->document_file = $ress['document_file'];
			}
			$document[0]->document_type_id = $ress['document_type_id'];
			$document[0]->date_of_expiry = $ress['date_of_expiry'];
			$document[0]->title = $ress['title'];
			$document[0]->description = $ress['description'];
			$document_printed = $document_printed . '</div>';
		}

		$data = array(

			'document_id' => $document[0]->document_id,

			'document_type_id' => $document[0]->document_type_id,

			'd_employee_id' => $document[0]->employee_id,

			'all_document_types' => $this->Employees_model->all_document_types(),

			'date_of_expiry' => $document[0]->date_of_expiry,

			'title' => $document[0]->title,

			//'is_alert' => $document[0]->is_alert,

			'description' => $document[0]->description,

			//'notification_email' => $document[0]->notification_email,

			'document_file' => $document[0]->document_file

		);

		if (!empty($session)) {
			$data['document_printed'] = $document_printed;

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_imgdocument()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_imgdocument_information($id);
		$immiprinted = '';
		if ($document[0]->serialized != "" && $document[0]->serialized != 'null' && $document[0]->serialized != 'NULL' && $document[0]->serialized != NULL && $document[0]->serialized != null) {
			$immiprinted = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($document[0]->serialized);
			// var_dump($ress);	die();
			if ($document[0]->document_number != $ress['document_number']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_employee_document_number') . " : " . $ress['document_number'] . "</span></br>";
			}
			$document[0]->document_number = $ress['document_number'];
			if (isset($ress['document_file'])) {
				if ($document[0]->document_file != $ress['document_file']) {
					$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_e_details_document_file') . " : " . $ress['document_file'] . "</span></br>";
				}
				$document[0]->document_file = $ress['document_file'];
			}

			if ($document[0]->issue_date != $ress['issue_date']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_issue_date') . " : " . $ress['issue_date'] . "</span></br>";
			}
			$document[0]->issue_date = $ress['issue_date'];

			if ($document[0]->expiry_date != $ress['expiry_date']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_expiry_date') . " : " . $ress['expiry_date'] . "</span></br>";
			}
			$document[0]->expiry_date = $ress['expiry_date'];

			if ($document[0]->eligible_review_date != $ress['eligible_review_date']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_eligible_review_date') . " : " . $ress['eligible_review_date'] . "</span></br>";
			}
			$document[0]->eligible_review_date = $ress['eligible_review_date'];

			if ($document[0]->document_type_id != $ress['document_type_id']) {
				$all_document_types = $this->Employees_model->all_document_types();
				$all_docs = '';
				foreach ($all_document_types as $docs) {
					if (isset($_GET)) {
						if (in_array($docs->document_type_id, explode(",", $ress['document_type_id']))) {
							$all_docs = $all_docs . $docs->document_type;
						}
					}
				}
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_e_details_document') . " : " . $all_docs . "</span></br>";
			}
			$document[0]->document_type_id = $ress['document_type_id'];

			if ($document[0]->country_id != $ress['country_id']) {
				$get_countries = $this->Xin_model->get_countries();
				$all_docs = '';
				foreach ($get_countries as $docs) {
					if (isset($_GET)) {
						if (in_array($docs->country_id, explode(",", $ress['country_id']))) {
							$all_docs = $all_docs . $docs->country_name;
						}
					}
				}
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_country') . " : " . $all_docs . "</span></br>";
			}
			$document[0]->country_id = $ress['country_id'];

			$immiprinted = $immiprinted . '</div>';
		}

		$data = array(

			'immigration_id' => $document[0]->immigration_id,

			'document_type_id' => $document[0]->document_type_id,

			'd_employee_id' => $document[0]->employee_id,

			'all_document_types' => $this->Employees_model->all_document_types(),

			'all_countries' => $this->Xin_model->get_countries(),

			'document_number' => $document[0]->document_number,

			'document_file' => $document[0]->document_file,

			'issue_date' => $document[0]->issue_date,

			'expiry_date' => $document[0]->expiry_date,

			'country_id' => $document[0]->country_id,

			'eligible_review_date' => $document[0]->eligible_review_date,

		);

		if (!empty($session)) {
			$data['immiprinted'] = $immiprinted;

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_qualification()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_qualification_information($id);

		$printed = '';
		if ($result[0]->serialized != "" && $result[0]->serialized != 'null' && $result[0]->serialized != 'NULL' && $result[0]->serialized != NULL && $result[0]->serialized != null) {
			$printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($result[0]->serialized);
			if ($result[0]->name != $ress['name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_inst_name') . " : " . $ress['name'] . "</span></br>";
			}
			$result[0]->name = $ress['name'];
			if ($result[0]->education_level_id != $ress['education_level_id']) {
				$all_education_level = $this->Employees_model->all_education_level();
				$all_education = '';
				foreach ($all_education_level as $education_level) {
					if (isset($_GET)) {
						if (in_array($education_level->education_level_id, explode(",", $ress['education_level_id']))) {
							$all_education = $all_education . $education_level->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_edu_level') . " : " . $all_education . "</span></br>";
			}
			$result[0]->education_level_id = $ress['education_level_id'];
			if ($result[0]->from_year != $ress['from_year']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_from') . " : " . $ress['from_year'] . "</span></br>";
			}
			$result[0]->from_year = $ress['from_year'];
			if ($result[0]->to_year != $ress['to_year']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_to') . " : " . $ress['to_year'] . "</span></br>";
			}
			$result[0]->to_year = $ress['to_year'];
			if ($result[0]->language_id != $ress['language_id']) {
				$all_qualification_language = $this->Employees_model->all_qualification_language();
				$all_education_lng = '';
				foreach ($all_qualification_language as $education_lng) {
					if (isset($_GET)) {
						if (in_array($education_lng->language_id, explode(",", $ress['language_id']))) {
							$all_education_lng = $all_education_lng . $education_lng->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_language') . " : " . $all_education_lng . "</span></br>";
			}
			$result[0]->language_id = $ress['language_id'];
			if ($result[0]->description != $ress['description']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_description') . " : " . $ress['description'] . "</span></br>";
			}
			$result[0]->description = $ress['description'];
			if ($result[0]->skill_id != $ress['skill_id']) {
				$all_qualification_skill = $this->Employees_model->all_qualification_skill();
				$all_education_skill = '';
				foreach ($all_qualification_skill as $education_skill) {
					if (isset($_GET)) {
						if (in_array($education_skill->skill_id, explode(",", $ress['skill_id']))) {
							$all_education_skill = $all_education_skill . $education_skill->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_skill') . " : " . $all_education_skill . "</span></br>";
			}
			$result[0]->skill_id = $ress['skill_id'];
			$printed = $printed . '</div>';
		}

		$data = array(

			'qualification_id' => $result[0]->qualification_id,

			'employee_id' => $result[0]->employee_id,

			'name' => $result[0]->name,

			'education_level_id' => $result[0]->education_level_id,

			'from_year' => $result[0]->from_year,

			'language_id' => $result[0]->language_id,

			'to_year' => $result[0]->to_year,

			'skill_id' => $result[0]->skill_id,

			'description' => $result[0]->description,

			'all_education_level' => $this->Employees_model->all_education_level(),

			'all_qualification_language' => $this->Employees_model->all_qualification_language(),

			'all_qualification_skill' => $this->Employees_model->all_qualification_skill()

		);

		if (!empty($session)) {
			$data['printed'] = $printed;

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function dialog_work_experience()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_work_experience_information($id);

		$data = array(

			'work_experience_id' => $result[0]->work_experience_id,

			'employee_id' => $result[0]->employee_id,

			'company_name' => $result[0]->company_name,

			'from_date' => $result[0]->from_date,

			'to_date' => $result[0]->to_date,

			'post' => $result[0]->post,

			'description' => $result[0]->description

		);
		$local_store = $this->Employees_model->read_experience_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['company_name'] = $un_local['company_name'];
			$data['post'] = $un_local['post'];
			$data['from_date'] = $un_local['from_date'];
			$data['to_date'] = $un_local['to_date'];
			$data['description'] = $un_local['description'];
		}
		$data['changes_exp'] = $this->Employees_model->read_experience_changes_local($id);
		$data['local_w_store'] = $this->Employees_model->read_work_local_store($id);
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_bank_account()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_bank_account_information($id);

		$data = array(

			'bankaccount_id' => $result[0]->bankaccount_id,

			'employee_id' => $result[0]->employee_id,

			'is_primary' => $result[0]->is_primary,

			'account_title' => $result[0]->account_title,

			'account_number' => $result[0]->account_number,

			'bank_name' => $result[0]->bank_name,

			'bank_code' => $result[0]->bank_code,

			'bank_branch' => $result[0]->bank_branch

		);
		$local_store = $this->Employees_model->read_bank_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['account_title'] = $un_local['account_title'];
			$data['bank_name'] = $un_local['bank_name'];
			$data['account_number'] = $un_local['account_number'];
			$data['bank_code'] = $un_local['bank_code'];
			$data['bank_branch'] = $un_local['bank_branch'];
		}
		$data['contact_changes'] = $this->Employees_model->read_contact_changes_local($id);
		$data['local_bank_store'] = $this->Employees_model->read_bank_local_store($id);
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {
			redirect('admin/');
		}
	}



	public function dialog_contract()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$role_resources_ids = $this->Xin_model->user_role_resource();


		$efapproval = $role_resources_ids[9];

		$edit = $role_resources_ids[5];


		$result = $this->Employees_model->read_contract_information($id);
		$update_value = $result[0]->update_value;






		if (($update_value) && ($efapproval == 'efapproval') && ($edit == '202')) {
			$data_new = (unserialize($update_value));

			$idnew = $data_new['contract_type_id'];

			$resultnew = $this->Employees_model->all_contract_types_name($idnew);
			$contract_type_name = $resultnew[0]->name;


			if ($result[0]->contract_type_id != $data_new['contract_type_id']) {

				$contract_type_id_new = 'Contract type : ' . $contract_type_name;
			} else {
				$contract_type_id_new = '';
			}

			if ($result[0]->from_date != $data_new['from_date']) {
				$from_date_new = 'From date : ' . $data_new['from_date'];
			} else {
				$from_date_new = '';
			}

			if ($result[0]->designation_id != $data_new['designation_id']) {

				$Designation_new = 'Designation :' . $data_new['designation_id'];
			} else {
				$Designation_new = '';
			}

			if ($result[0]->title != $data_new['title']) {
				$Title_new = 'Title :' . $data_new['title'];
			} else {
				$Title_new = '';
			}

			if ($result[0]->to_date != $data_new['to_date']) {
				$to_date_new = 'Todate :' . $data_new['to_date'];
			} else {
				$to_date_new = '';
			}
			if ($result[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}




			$data = array(

				'contract_id' => $result[0]->contract_id,

				'employee_id' =>  $result[0]->employee_id,



				'contract_type_id' => $data_new['contract_type_id'],

				'from_date' => $data_new['from_date'],

				'designation_id' => $data_new['designation_id'],

				'title' => $data_new['title'],

				'to_date' => $data_new['to_date'],

				'description' => $data_new['description'],

				'update_value' => 'yes',



				'contract_type_id_new' => $contract_type_id_new,

				'from_date_new' => $from_date_new,

				'Designation_new' => $Designation_new,

				'Title_new' => $Title_new,

				'to_date_new' => $to_date_new,

				'description_new' => $description_new,


				'all_contract_types' => $this->Employees_model->all_contract_types(),

				'all_designations' => $this->Designation_model->all_designations(),





			);
		} else {

			$data = array(

				'contract_id' => $result[0]->contract_id,

				'employee_id' => $result[0]->employee_id,

				'contract_type_id' => $result[0]->contract_type_id,

				'from_date' => $result[0]->from_date,

				'designation_id' => $result[0]->designation_id,

				'title' => $result[0]->title,

				'to_date' => $result[0]->to_date,

				'description' => $result[0]->description,

				'file_new' => $result[0]->file,

				'update_value' => 'nill',

				'all_contract_types' => $this->Employees_model->all_contract_types(),

				'all_designations' => $this->Designation_model->all_designations(),

			);
		}
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	/*public function dialog_leave() {

		

		$session = $this->session->userdata('username');

		if(empty($session)){ 

			redirect('admin/');

		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_leave_information($id);

		$data = array(

				'leave_id' => $result[0]->leave_id,

				'employee_id' => $result[0]->employee_id,

				'contract_id' => $result[0]->contract_id,

				'casual_leave' => $result[0]->casual_leave,

				'medical_leave' => $result[0]->medical_leave

				);

		if(!empty($session)){ 

			$this->load->view('admin/employees/dialog_employee_details', $data);

		} else {

			redirect('admin/');

		}

	}*/

	public function dialog_leave()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Timesheet_model->get($id);

		$data = array(

			'leave_id' => $result[0]->id,

			'employee_id' => $result[0]->employee_id,

			'type_name' => $result[0]->type_name,

			'leave_count' => $result[0]->leave_count,
			'leave_type_id' => $result[0]->leave_type,

		);
		$local_store = $this->Employees_model->read_leave_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['leave_count'] = $un_local['leave_count'];
		}
		$data['leave_changes'] = $this->Employees_model->read_leave_changes_local($id);
		$data['local_leave_store'] = $this->Employees_model->read_local_leave_store($id);
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_shift()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_emp_shift_information($id);

		$data = array(

			'emp_shift_id' => $result[0]->emp_shift_id,

			'employee_id' => $result[0]->employee_id,

			'shift_id' => $result[0]->shift_id,

			'from_date' => $result[0]->from_date,

			'to_date' => $result[0]->to_date

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_location()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_location_information($id);

		$data = array(

			'office_location_id' => $result[0]->office_location_id,

			'employee_id' => $result[0]->employee_id,

			'location_id' => $result[0]->location_id,

			'from_date' => $result[0]->from_date,

			'to_date' => $result[0]->to_date

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_salary_allowance()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		/*$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_allowance($id);

		$data = array(

				'allowance_id' => $result[0]->allowance_id,

				'employee_id' => $result[0]->employee_id,

				'is_allowance_taxable' => $result[0]->is_allowance_taxable,

				'amount_option' => $result[0]->amount_option,

				'allowance_title' => $result[0]->allowance_title,

				'allowance_amount' => $result[0]->allowance_amount

				);

				*/

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function dialog_salary_commissions()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_commissions($id);

		$data = array(

			'salary_commissions_id' => $result[0]->salary_commissions_id,

			'employee_id' => $result[0]->employee_id,

			'is_commission_taxable' => $result[0]->is_commission_taxable,

			'amount_option' => $result[0]->amount_option,

			'commission_title' => $result[0]->commission_title,

			'commission_amount' => $result[0]->commission_amount,

			'allowance_payslip_commission' => $result[0]->applicable_for_paysalary

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function dialog_salary_statutory_deductions()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_statutory_deduction($id);

		//$emp=$this->Employees_model->read_emp($id);

		$emp = $this->Employees_model->read_emp($result[0]->employee_id);

		$data = array(

			'statutory_deductions_id' => $result[0]->statutory_deductions_id,

			'employee_id' => $result[0]->employee_id,

			'deduction_title' => $result[0]->deduction_title,

			'deduction_amount' => $result[0]->deduction_amount,

			'statutory_options' => $result[0]->statutory_options,

			'basic_salary' => $emp[0]->basic_salary,

			'wages_type' => $emp[0]->wages_type,

			'nationality_id' => $emp[0]->nationality_id,

			'allowance_payslip_deduction' => $result[0]->applicable_for_paysalary



		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function dialog_salary_other_payments()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_other_payment($id);

		$data = array(

			'other_payments_id' => $result[0]->other_payments_id,

			'employee_id' => $result[0]->employee_id,

			'payments_title' => $result[0]->payments_title,

			'payments_amount' => $result[0]->payments_amount,

			'is_otherpayment_taxable' => $result[0]->is_otherpayment_taxable,

			'amount_option' => $result[0]->amount_option,

			'allowance_payslip_deduction' => $result[0]->applicable_for_paysalary

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_salary_loan()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_loan_deductions($id);
		// 		var_dump($this->input->get());die();

		$data = array(

			'loan_deduction_id' => $result[0]->loan_deduction_id,

			'employee_id' => $result[0]->employee_id,

			'loan_deduction_title' => $result[0]->loan_deduction_title,

			'start_date' => $result[0]->start_date,

			'end_date' => $result[0]->end_date,

			'loan_options' => $result[0]->loan_options,

			'monthly_installment' => $result[0]->monthly_installment,

			'reason' => $result[0]->reason,

			'created_at' => $result[0]->created_at,

			'first_approval' => $result[0]->first_approval,

			'second_approval' => $result[0]->second_approval,

			'third_approval' => $result[0]->third_approval,

			'final_approval' => $result[0]->final_approval

		);
		$data['role_resources_ids'] = $this->Xin_model->user_role_resource();

		if (!empty($session)) {
			// 		var_dump($data);die();

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function dialog_emp_overtime()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_salary_overtime_record($id);

		$data = array(

			'salary_overtime_id' => $result[0]->salary_overtime_id,

			'employee_id' => $result[0]->employee_id,

			'overtime_type' => $result[0]->overtime_type,

			'no_of_days' => $result[0]->no_of_days,

			'overtime_hours' => $result[0]->overtime_hours,

			'overtime_rate' => $result[0]->overtime_rate

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	// get departmens > designations

	public function designation()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = array(

			'subdepartment_id' => $id,

			'all_designations' => $this->Designation_model->all_designations(),

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/get_designations", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}



	public function is_designation()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = array(

			'department_id' => $id,

			'all_designations' => $this->Designation_model->all_designations(),

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/get_designations", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	// get main department > sub departments

	public function get_sub_departments()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = array(

			'department_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/get_sub_departments", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}



	public function read()

	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('warning_id');

		/*$result = $this->Warning_model->read_warning_information($id);

		$data = array(

				'warning_id' => $result[0]->warning_id,

				'warning_to' => $result[0]->warning_to,

				'warning_by' => $result[0]->warning_by,

				'warning_date' => $result[0]->warning_date,

				'warning_type_id' => $result[0]->warning_type_id,

				'subject' => $result[0]->subject,

				'description' => $result[0]->description,

				'status' => $result[0]->status,

				'all_employees' => $this->Xin_model->all_employees(),

				'all_warning_types' => $this->Warning_model->all_warning_types(),

				);*/

		if (!empty($session)) {

			$this->load->view('admin/warning/dialog_warning', $data);
		} else {

			redirect('admin/');
		}
	}



	// Validate and add info in database
	public function add_employee_validate()
	{


		error_reporting(0);
		//$this->CI =& get_instance();

		if ($this->input->post('add_type') == 'employee') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$office_shift_id = $this->input->post('office_shift_id');

			$system = $this->Xin_model->read_setting_info(1);

			/* Server side PHP input validation */

			/*if ($this->input->post('employee_code') == '0') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			} else if ($this->input->post('employee_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			}*/
			if ($this->input->post('first_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_first_name');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('first_name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('last_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_last_name');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('last_name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('employee_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_employee_id');
			} else if ($this->Employees_model->check_employee_id($this->input->post('employee_id')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_id_already_exist');
			} else if ($this->input->post('date_of_joining') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_joining_date');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_joining'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('company_id') === '') {

				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('department_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_department');
			} else if ($this->input->post('subdepartment_id') === '') {

				$Return['error'] = $this->lang->line('xin_hr_sub_department_field_error');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			} else if ($this->input->post('username') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_username');
			} else if ($this->Employees_model->check_employee_username($this->input->post('username')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_username_already_exist');
			}
			/*else if ($this->input->post('email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_email');
			} else if (!filter_var($this->input->post('email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->Employees_model->check_employee_email($this->input->post('email')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_email_already_exist');
			}*/ else if ($this->input->post('date_of_birth') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_date_of_birth');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_birth'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('contact_no') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_number');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {
				$Return['error'] = 'Invalid phone number';
				//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('password') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_password');
			} else if (strlen($this->input->post('password')) < 6) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_least');
			} else if ($this->input->post('password') !== $this->input->post('confirm_password')) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_not_match');
			} else if ($this->input->post('role') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_user_role');
			} else if ($this->input->post('pin_code') === '') {

				$Return['error'] = $this->lang->line('xin_pincode_field_error');
			} /*else if (!filter_var($this->input->post('pin_code'), FILTER_VALIDATE_INT)) {

				$Return['error'] = $this->lang->line('xin_pincode_should_be_digits_error');
			} else if (strlen($this->input->post('pin_code')) < 6) {

				$Return['error'] = $this->lang->line('xin_pincode_six_digits_error');
			}*/ else if (count($this->input->post('leave_categories')) == 1) {
				$Return['error'] = 'Leave category  field is required';
			} else if ($this->input->post('nationality_id') == '') {
				$Return['error'] = 'Nationality is required';
			} else if ($this->input->post('citizenship_id') == '') {
				$Return['error'] = 'Citizenship  is required';
			} else if ($this->input->post('date_of_birth')) {
				$today = date("Y-m-d");
				$diff = date_diff(date_create($this->input->post('date_of_birth')), date_create($today));
				if ($diff->format('%y%') < 16) {
					$Return['error'] = 'Please Provide valid date of birth';
				}
			}
			if ($office_shift_id == '') {

				$Return['error'] = $this->lang->line('xin_office_shift_field_error');
			}


			/*else if($this->Employees_model->check_employee_pincode($this->input->post('pin_code')) > 0) {

 			 $Return['error'] = $this->lang->line('xin_pincode_already_exist');

 		}*/

			//	echo $this->input->post('employee_code');exit;

			if ($this->input->post('employeecode') !== '') {
				$empcode = $this->input->post('employeecode');
				$empcodecount = $this->Employees_model->get_employeecode_duplication($empcode);
				if ($empcodecount > 0) {
					$Return['error'] = 'Employee Code Already Exists';
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			//print_r($leave_type);exit;

			$this->output($Return);

			exit;
		}
	}

	public function add_employee()
	{


		error_reporting(0);
		//$this->CI =& get_instance();

		if ($this->input->post('add_type') == 'employee') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$office_shift_id = $this->input->post('office_shift_id');

			$system = $this->Xin_model->read_setting_info(1);

			/* Server side PHP input validation */

			/*if ($this->input->post('employee_code') == '0') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			} else if ($this->input->post('employee_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			}*/
			if ($this->input->post('first_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_first_name');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('first_name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('last_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_last_name');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('last_name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('employee_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_employee_id');
			} else if ($this->Employees_model->check_employee_id($this->input->post('employee_id')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_id_already_exist');
			} else if ($this->input->post('date_of_joining') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_joining_date');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_joining'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('company_id') === '') {

				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('department_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_department');
			} else if ($this->input->post('subdepartment_id') === '') {

				$Return['error'] = $this->lang->line('xin_hr_sub_department_field_error');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			} else if ($this->input->post('username') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_username');
			} else if ($this->Employees_model->check_employee_username($this->input->post('username')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_username_already_exist');
			}
			/*else if ($this->input->post('email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_email');
			} else if (!filter_var($this->input->post('email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->Employees_model->check_employee_email($this->input->post('email')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_email_already_exist');
			}*/ else if ($this->input->post('date_of_birth') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_date_of_birth');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_birth'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('contact_no') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_number');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {
				$Return['error'] = 'Invalid phone number';
				//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('password') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_password');
			} else if (strlen($this->input->post('password')) < 6) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_least');
			} else if ($this->input->post('password') !== $this->input->post('confirm_password')) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_not_match');
			} else if ($this->input->post('role') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_user_role');
			} else if ($this->input->post('pin_code') === '') {

				$Return['error'] = $this->lang->line('xin_pincode_field_error');
			} /*else if (!filter_var($this->input->post('pin_code'), FILTER_VALIDATE_INT)) {

				$Return['error'] = $this->lang->line('xin_pincode_should_be_digits_error');
			} else if (strlen($this->input->post('pin_code')) < 6) {

				$Return['error'] = $this->lang->line('xin_pincode_six_digits_error');
			}*/ else if (count($this->input->post('leave_categories')) == 1) {
				$Return['error'] = 'Leave category  field is required';
			} else if ($this->input->post('nationality_id') == '') {
				$Return['error'] = 'Nationality is required';
			} else if ($this->input->post('citizenship_id') == '') {
				$Return['error'] = 'Citizenship  is required';
			} else if ($this->input->post('date_of_birth')) {
				$today = date("Y-m-d");
				$diff = date_diff(date_create($this->input->post('date_of_birth')), date_create($today));
				if ($diff->format('%y%') < 16) {
					$Return['error'] = 'Please Provide valid date of birth';
				}
			}
			if ($office_shift_id == '') {

				$Return['error'] = $this->lang->line('xin_office_shift_field_error');
			}


			/*else if($this->Employees_model->check_employee_pincode($this->input->post('pin_code')) > 0) {

 			 $Return['error'] = $this->lang->line('xin_pincode_already_exist');

 		}*/

			//	echo $this->input->post('employee_code');exit;

			if ($this->input->post('employeecode') !== '') {
				$empcode = $this->input->post('employeecode');
				$empcodecount = $this->Employees_model->get_employeecode_duplication($empcode);
				if ($empcodecount > 0) {
					$Return['error'] = 'Employee Code Already Exists';
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			/*if($system[0]->multi_shifts == '1'){

			if(empty($office_shift_id)) {

				$Return['error'] = $this->lang->line('xin_office_shift_field_error');

			}

		}*/





			//	if($Return['error']!=''){

			// 		$this->output($Return);

			//	}



			$module_attributes = $this->Custom_fields_model->all_hrsale_module_attributes();

			$count_module_attributes = $this->Custom_fields_model->count_module_attributes();

			$i = 1;

			if ($count_module_attributes > 0) {

				foreach ($module_attributes as $mattribute) {

					if ($mattribute->validation == 1) {

						if ($i != 1) {
						} else if ($this->input->post($mattribute->attribute) == '') {

							$Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
						}
					}
				}

				if ($Return['error'] != '') {

					$this->output($Return);
				}
			}



			$first_name = $this->Xin_model->clean_post($this->input->post('first_name'));

			$last_name = $this->Xin_model->clean_post($this->input->post('last_name'));

			$middle_name = $this->Xin_model->clean_post($this->input->post('middle_name'));

			$employee_id = $this->Xin_model->clean_post($this->input->post('employee_id'));

			$employee_code = $this->Xin_model->clean_post($this->input->post('employee_code'));
			$connectToCrm = $this->Xin_model->clean_post($this->input->post('connectToCrm'));

            
			$date_of_joining = $this->Xin_model->clean_date_post($this->input->post('date_of_joining'));

			$username = $this->Xin_model->clean_post($this->input->post('username'));

			$date_of_birth = $this->Xin_model->clean_date_post($this->input->post('date_of_birth'));

			$contact_no = $this->Xin_model->clean_post($this->input->post('contact_no'));

			$address = $this->Xin_model->clean_post($this->input->post('address'));

			$ot_eligible = $this->Xin_model->clean_post($this->input->post('ot_eligible'));

			$options = array('cost' => 12);

			$password_hash = password_hash($this->input->post('password'), PASSWORD_BCRYPT, $options);

			$leave_categories = array($this->input->post('leave_categories'));

			$cat_ids = implode(',', $this->input->post('leave_categories'));

			//print_r($leave_categories);exit;

			$designation_code = $dept_code = $company_code = '';

			/* To get company details */

			$company_det = $this->Company_model->read_company_information($this->input->post('company_id'));

			if ($company_det) {

				$company_code = $company_det[0]->company_code;
			}

			/* company details end */

			/* To get departments details */

			$dept_det = $this->Department_model->read_department_information($this->input->post('department_id'));

			if ($dept_det) {

				$dept_code = $dept_det[0]->department_code;
			}

			/* departments details end */

			/* To get designation details */

			$designation_det = $this->Designation_model->read_designation_information($this->input->post('designation_id'));

			if ($designation_det) {

				$designation_code = $designation_det[0]->designation_code;
			}

			/* designation details end */





			$cat_ids = implode(',', $this->input->post('leave_categories'));

			//$serial_no=$this->Employees_model->get_last_serial_no();

			//$get_serial_no=$serial_no+1;
			$input = $date_of_joining;
			$d1 = new DateTime($input);
			$date1 = date('Y-m-d');
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date1 = $new . '-' . $month . '-' . $day;


			$data = array(

				'employee_id' => $employee_id,

				'employee_code' => $employee_code,

				'office_shift_id' => $this->input->post('office_shift_id'),

				'reports_to' => $this->input->post('reports_to'),
				'arabic_name' => $this->input->post('arabic_name'),
				'first_name' => $first_name,

				'last_name' => $last_name,

				'middle_name' => $middle_name,

				'username' => $username,

				'company_id' => $this->input->post('company_id'),

				'location_id' => $this->input->post('location_id'),

				'email' => $this->input->post('email'),

				'password' => $password_hash,

				'pincode' => $this->input->post('pin_code'),

				'date_of_birth' => $date_of_birth,

				'gender' => $this->input->post('gender'),

				'user_role_id' => $this->input->post('role'),

				'department_id' => $this->input->post('department_id'),

				'sub_department_id' => $this->input->post('subdepartment_id'),

				'designation_id' => $this->input->post('designation_id'),

				'date_of_joining' => $date_of_joining,
				'leave_salary_calculated_date' => $date_of_joining,
				'leave_updated_date' => $update_date1,
			 

				'contact_no' => $contact_no,

				'address' => $address,

				'is_active' => 1,

				'leave_categories' => $cat_ids,

				'serial_no' => $this->input->post('serial_no'),

				'created_at' => date('Y-m-d h:i:s'),

				'company_code' => $company_code,

				'dept_code' => $dept_code,

				'designation_code' => $designation_code,
				'paid_sick_leave_count' => 15,
				'unpaid_sick_leave_count' => 20,
				'half_paid_sick_leave_count' => 20,
				'ot_eligible' => $ot_eligible,
				'state' => $this->input->post('estate'),
				'city' => $this->input->post('ecity'),
				'ethnicity_type' => $this->input->post('ethnicity_type'),
				'blood_group' => $this->input->post('blood_group'),
				'citizenship_id' => $this->input->post('citizenship_id'),
				'nationality_id' => $this->input->post('nationality_id'),
		 


			);

			    //print_r($data);exit;

			$iresult = $this->Employees_model->add($data);
				if($connectToCrm == 'Yes')
			{
				$datacrm = array(
                'employeeID'  =>$iresult,
				'email' =>$this->input->post('email'),

				'firstname' => $first_name,

				'lastname' => $last_name." ".$middle_name,

				'phonenumber' => $this->input->post('phonenumber'),
				'password' => $password_hash,
			 

			 

				'datecreated' => date('Y-m-d h:i:s'),

			 


			);
			
			 
				
					$iresultset = $this->Employees_model->addCrm($datacrm);
			}
			 
		
			$input = $date_of_joining;
			$d1 = new DateTime($input);
			$date1 = date('Y-m-d');
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;

			foreach ($leave_categories as $x => $val) {

				foreach ($val as $data) {

					if ($data == 0) {

						continue;
					}

					//print_r($data);exit;

					$leave_type = $this->Employees_model->get_leaves($data);

					//  print_r($leave_type[0]->days_per_year);exit;

					$data_leave = array(

						'employee_id' => $iresult,

						'leave_type' => $data,

						'leave_count' => $leave_type[0]->days_per_year,

						'created_at' => $update_date

					);

					$re_le = $this->Employees_model->add_leaves($data_leave);
				}
			}



			//print_r($leave_type);exit;





			if ($iresult) {

				$designation_id = $this->input->post('designation_id');

				$this->Employees_model->update_dept_count($designation_id);

				$id = $iresult;

				if ($count_module_attributes > 0) {

					foreach ($module_attributes as $mattribute) {

						/*$attr_data = array(

						'user_id' => $iresult,

						'module_attributes_id' => $mattribute->custom_field_id,

						'attribute_value' => $this->input->post($mattribute->attribute),

						'created_at' => date('Y-m-d h:i:s')

					);

					$this->Custom_fields_model->add_values($attr_data);*/

						if ($mattribute->attribute_type == 'fileupload') {

							if ($_FILES[$mattribute->attribute]['size'] != 0) {

								if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {

									//checking image type

									$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');

									$filename = $_FILES[$mattribute->attribute]['name'];

									$ext = pathinfo($filename, PATHINFO_EXTENSION);



									if (in_array($ext, $allowed)) {

										$tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];

										$profile = "uploads/custom_files/";

										$set_img = base_url() . "uploads/custom_files/";

										// basename() may prevent filesystem traversal attacks;

										// further validation/sanitation of the filename may be appropriate

										$name = basename($_FILES[$mattribute->attribute]["name"]);

										$newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;

										move_uploaded_file($tmp_name, $profile . $newfilename);

										$fname = $newfilename;
									}

									$iattr_data = array(

										'user_id' => $id,

										'module_attributes_id' => $mattribute->custom_field_id,

										'attribute_value' => $fname,

										'created_at' => date('Y-m-d h:i:s')

									);

									$this->Custom_fields_model->add_values($iattr_data);
								}
							} else {

								$iattr_data = array(

									'user_id' => $id,

									'module_attributes_id' => $mattribute->custom_field_id,

									'attribute_value' => '',

									'created_at' => date('Y-m-d h:i:s')

								);

								$this->Custom_fields_model->add_values($iattr_data);
							}
						} else if ($mattribute->attribute_type == 'multiselect') {

							$multisel_val = $this->input->post($mattribute->attribute);

							if (!empty($multisel_val)) {

								$newdata = implode(',', $this->input->post($mattribute->attribute));

								$iattr_data = array(

									'user_id' => $id,

									'module_attributes_id' => $mattribute->custom_field_id,

									'attribute_value' => $newdata,

									'created_at' => date('Y-m-d h:i:s')

								);

								$this->Custom_fields_model->add_values($iattr_data);
							}
						} else {

							if ($this->input->post($mattribute->attribute) == '') {

								$file_val = '';
							} else {

								$file_val = $this->input->post($mattribute->attribute);
							}

							$iattr_data = array(

								'user_id' => $id,

								'module_attributes_id' => $mattribute->custom_field_id,

								'attribute_value' => $file_val,

								'created_at' => date('Y-m-d h:i:s')

							);

							$this->Custom_fields_model->add_values($iattr_data);
						}

						/*$attr_orig_value = $this->Custom_fields_model->read_hrsale_module_attributes_values($result,$mattribute->custom_field_id);

					if($attr_orig_value->module_attributes_id != $mattribute->custom_field_id) {

						$this->Custom_fields_model->add_values($attr_data);

					}*/
					}
				}

				//get setting info 

				$setting = $this->Xin_model->read_setting_info(1);

				$company = $this->Xin_model->read_company_setting_info(1);

				if ($setting[0]->enable_email_notification == 'yes') {

					// load email library

					$this->load->library('email');

					$this->email->set_mailtype("html");



					//get company info

					$cinfo = $this->Xin_model->read_company_setting_info(1);

					//get email template

					$template = $this->Xin_model->read_email_template(8);



					$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;

					$logo = base_url() . 'uploads/logo/signin/' . $company[0]->sign_in_logo;



					// get user full name

					$full_name = $this->input->post('first_name') . ' ' . $this->input->post('last_name');



					$message = '

			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">

			<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var username}", "{var employee_id}", "{var employee_name}", "{var email}", "{var password}"), array($cinfo[0]->company_name, site_url(), $this->input->post('username'), $this->input->post('employee_id'), $full_name, $this->input->post('email'), $this->input->post('password')), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';



					hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $this->input->post('email'), $subject, $message);
				}

				if ($this->input->post('nationality_id') == 17) {
					$category = 'bahraini';
				} else {
					$category = 'expat';
				}

				$this->Employees_model->set_employees_leave_salary($category, $iresult);

				$Return['result'] = $this->lang->line('xin_success_add_employee');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function add_employee_bkp_31_03()
	{


		error_reporting(0);
		//$this->CI =& get_instance();

		if ($this->input->post('add_type') == 'employee') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$office_shift_id = $this->input->post('office_shift_id');

			$system = $this->Xin_model->read_setting_info(1);

			/* Server side PHP input validation */

			/*if ($this->input->post('employee_code') == '0') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			} else if ($this->input->post('employee_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			}*/
			if ($this->input->post('first_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_first_name');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('first_name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('last_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_last_name');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('last_name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('employee_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_employee_id');
			} else if ($this->Employees_model->check_employee_id($this->input->post('employee_id')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_id_already_exist');
			} else if ($this->input->post('date_of_joining') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_joining_date');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_joining'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('company_id') === '') {

				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('department_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_department');
			} else if ($this->input->post('subdepartment_id') === '') {

				$Return['error'] = $this->lang->line('xin_hr_sub_department_field_error');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			} else if ($this->input->post('username') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_username');
			} else if ($this->Employees_model->check_employee_username($this->input->post('username')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_username_already_exist');
			}
			/*else if ($this->input->post('email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_email');
			} else if (!filter_var($this->input->post('email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->Employees_model->check_employee_email($this->input->post('email')) > 0) {

				$Return['error'] = $this->lang->line('xin_employee_email_already_exist');
			}*/ else if ($this->input->post('date_of_birth') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_date_of_birth');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_birth'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('contact_no') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_number');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {
				$Return['error'] = 'Invalid phone number';
				//	$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('password') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_password');
			} else if (strlen($this->input->post('password')) < 6) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_least');
			} else if ($this->input->post('password') !== $this->input->post('confirm_password')) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_not_match');
			} else if ($this->input->post('role') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_user_role');
			} else if ($this->input->post('pin_code') === '') {

				$Return['error'] = $this->lang->line('xin_pincode_field_error');
			} /*else if (!filter_var($this->input->post('pin_code'), FILTER_VALIDATE_INT)) {

				$Return['error'] = $this->lang->line('xin_pincode_should_be_digits_error');
			} else if (strlen($this->input->post('pin_code')) < 6) {

				$Return['error'] = $this->lang->line('xin_pincode_six_digits_error');
			}*/ else if (count($this->input->post('leave_categories')) == 1) {
				$Return['error'] = 'Leave category  field is required';
			} else if ($this->input->post('nationality_id') == '') {
				$Return['error'] = 'Nationality is required';
			} else if ($this->input->post('citizenship_id') == '') {
				$Return['error'] = 'Citizenship  is required';
			} else if ($this->input->post('date_of_birth')) {
				$today = date("Y-m-d");
				$diff = date_diff(date_create($this->input->post('date_of_birth')), date_create($today));
				if ($diff->format('%y%') < 16) {
					$Return['error'] = 'Please Provide valid date of birth';
				}
			}
			if ($office_shift_id == '') {

				$Return['error'] = $this->lang->line('xin_office_shift_field_error');
			}


			/*else if($this->Employees_model->check_employee_pincode($this->input->post('pin_code')) > 0) {

 			 $Return['error'] = $this->lang->line('xin_pincode_already_exist');

 		}*/

			//	echo $this->input->post('employee_code');exit;

			if ($this->input->post('employeecode') !== '') {
				$empcode = $this->input->post('employeecode');
				$empcodecount = $this->Employees_model->get_employeecode_duplication($empcode);
				if ($empcodecount > 0) {
					$Return['error'] = 'Employee Code Already Exists';
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			/*if($system[0]->multi_shifts == '1'){

			if(empty($office_shift_id)) {

				$Return['error'] = $this->lang->line('xin_office_shift_field_error');

			}

		}*/





			//	if($Return['error']!=''){

			// 		$this->output($Return);

			//	}



			$module_attributes = $this->Custom_fields_model->all_hrsale_module_attributes();

			$count_module_attributes = $this->Custom_fields_model->count_module_attributes();

			$i = 1;

			if ($count_module_attributes > 0) {

				foreach ($module_attributes as $mattribute) {

					if ($mattribute->validation == 1) {

						if ($i != 1) {
						} else if ($this->input->post($mattribute->attribute) == '') {

							$Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
						}
					}
				}

				if ($Return['error'] != '') {

					$this->output($Return);
				}
			}



			$first_name = $this->Xin_model->clean_post($this->input->post('first_name'));

			$last_name = $this->Xin_model->clean_post($this->input->post('last_name'));

			$middle_name = $this->Xin_model->clean_post($this->input->post('middle_name'));

			$employee_id = $this->Xin_model->clean_post($this->input->post('employee_id'));

			$employee_code = $this->Xin_model->clean_post($this->input->post('employee_code'));


			$date_of_joining = $this->Xin_model->clean_date_post($this->input->post('date_of_joining'));

			$username = $this->Xin_model->clean_post($this->input->post('username'));

			$date_of_birth = $this->Xin_model->clean_date_post($this->input->post('date_of_birth'));

			$contact_no = $this->Xin_model->clean_post($this->input->post('contact_no'));

			$address = $this->Xin_model->clean_post($this->input->post('address'));

			$ot_eligible = $this->Xin_model->clean_post($this->input->post('ot_eligible'));

			$options = array('cost' => 12);

			$password_hash = password_hash($this->input->post('password'), PASSWORD_BCRYPT, $options);

			$leave_categories = array($this->input->post('leave_categories'));

			$cat_ids = implode(',', $this->input->post('leave_categories'));

			//print_r($leave_categories);exit;

			$designation_code = $dept_code = $company_code = '';

			/* To get company details */

			$company_det = $this->Company_model->read_company_information($this->input->post('company_id'));

			if ($company_det) {

				$company_code = $company_det[0]->company_code;
			}

			/* company details end */

			/* To get departments details */

			$dept_det = $this->Department_model->read_department_information($this->input->post('department_id'));

			if ($dept_det) {

				$dept_code = $dept_det[0]->department_code;
			}

			/* departments details end */

			/* To get designation details */

			$designation_det = $this->Designation_model->read_designation_information($this->input->post('designation_id'));

			if ($designation_det) {

				$designation_code = $designation_det[0]->designation_code;
			}

			/* designation details end */





			$cat_ids = implode(',', $this->input->post('leave_categories'));

			//$serial_no=$this->Employees_model->get_last_serial_no();

			//$get_serial_no=$serial_no+1;
			$input = $date_of_joining;
			$d1 = new DateTime($input);
			$date1 = date('Y-m-d');
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date1 = $new . '-' . $month . '-' . $day;


			$data = array(

				'employee_id' => $employee_id,

				'employee_code' => $employee_code,

				'office_shift_id' => $this->input->post('office_shift_id'),

				'reports_to' => $this->input->post('reports_to'),
				'arabic_name' => $this->input->post('arabic_name'),
				'first_name' => $first_name,

				'last_name' => $last_name,

				'middle_name' => $middle_name,

				'username' => $username,

				'company_id' => $this->input->post('company_id'),

				'location_id' => $this->input->post('location_id'),

				'email' => $this->input->post('email'),

				'password' => $password_hash,

				'pincode' => $this->input->post('pin_code'),

				'date_of_birth' => $date_of_birth,

				'gender' => $this->input->post('gender'),

				'user_role_id' => $this->input->post('role'),

				'department_id' => $this->input->post('department_id'),

				'sub_department_id' => $this->input->post('subdepartment_id'),

				'designation_id' => $this->input->post('designation_id'),

				'date_of_joining' => $date_of_joining,
				'leave_salary_calculated_date' => $date_of_joining,
				'leave_updated_date' => $update_date1,

				'contact_no' => $contact_no,

				'address' => $address,

				'is_active' => 1,

				'leave_categories' => $cat_ids,

				'serial_no' => $this->input->post('serial_no'),

				'created_at' => date('Y-m-d h:i:s'),

				'company_code' => $company_code,

				'dept_code' => $dept_code,

				'designation_code' => $designation_code,
				'paid_sick_leave_count' => 15,
				'unpaid_sick_leave_count' => 20,
				'half_paid_sick_leave_count' => 20,
				'ot_eligible' => $ot_eligible,
				'state' => $this->input->post('estate'),
				'city' => $this->input->post('ecity'),
				'ethnicity_type' => $this->input->post('ethnicity_type'),
				'blood_group' => $this->input->post('blood_group'),
				'citizenship_id' => $this->input->post('citizenship_id'),
				'nationality_id' => $this->input->post('nationality_id'),
				//'late_deduction' => $this->input->post('late_deduction'),


			);

			//print_r($data);exit;

			$iresult = $this->Employees_model->add($data);
			$input = $date_of_joining;
			$d1 = new DateTime($input);
			$date1 = date('Y-m-d');
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;

			foreach ($leave_categories as $x => $val) {

				foreach ($val as $data) {

					if ($data == 0) {

						continue;
					}

					//print_r($data);exit;

					$leave_type = $this->Employees_model->get_leaves($data);

					//  print_r($leave_type[0]->days_per_year);exit;

					$data_leave = array(

						'employee_id' => $iresult,

						'leave_type' => $data,

						'leave_count' => $leave_type[0]->days_per_year,

						'created_at' => $update_date

					);

					$re_le = $this->Employees_model->add_leaves($data_leave);
				}
			}



			//print_r($leave_type);exit;





			if ($iresult) {

				$designation_id = $this->input->post('designation_id');

				$this->Employees_model->update_dept_count($designation_id);

				$id = $iresult;

				if ($count_module_attributes > 0) {

					foreach ($module_attributes as $mattribute) {

						/*$attr_data = array(

						'user_id' => $iresult,

						'module_attributes_id' => $mattribute->custom_field_id,

						'attribute_value' => $this->input->post($mattribute->attribute),

						'created_at' => date('Y-m-d h:i:s')

					);

					$this->Custom_fields_model->add_values($attr_data);*/

						if ($mattribute->attribute_type == 'fileupload') {

							if ($_FILES[$mattribute->attribute]['size'] != 0) {

								if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {

									//checking image type

									$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');

									$filename = $_FILES[$mattribute->attribute]['name'];

									$ext = pathinfo($filename, PATHINFO_EXTENSION);



									if (in_array($ext, $allowed)) {

										$tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];

										$profile = "uploads/custom_files/";

										$set_img = base_url() . "uploads/custom_files/";

										// basename() may prevent filesystem traversal attacks;

										// further validation/sanitation of the filename may be appropriate

										$name = basename($_FILES[$mattribute->attribute]["name"]);

										$newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;

										move_uploaded_file($tmp_name, $profile . $newfilename);

										$fname = $newfilename;
									}

									$iattr_data = array(

										'user_id' => $id,

										'module_attributes_id' => $mattribute->custom_field_id,

										'attribute_value' => $fname,

										'created_at' => date('Y-m-d h:i:s')

									);

									$this->Custom_fields_model->add_values($iattr_data);
								}
							} else {

								$iattr_data = array(

									'user_id' => $id,

									'module_attributes_id' => $mattribute->custom_field_id,

									'attribute_value' => '',

									'created_at' => date('Y-m-d h:i:s')

								);

								$this->Custom_fields_model->add_values($iattr_data);
							}
						} else if ($mattribute->attribute_type == 'multiselect') {

							$multisel_val = $this->input->post($mattribute->attribute);

							if (!empty($multisel_val)) {

								$newdata = implode(',', $this->input->post($mattribute->attribute));

								$iattr_data = array(

									'user_id' => $id,

									'module_attributes_id' => $mattribute->custom_field_id,

									'attribute_value' => $newdata,

									'created_at' => date('Y-m-d h:i:s')

								);

								$this->Custom_fields_model->add_values($iattr_data);
							}
						} else {

							if ($this->input->post($mattribute->attribute) == '') {

								$file_val = '';
							} else {

								$file_val = $this->input->post($mattribute->attribute);
							}

							$iattr_data = array(

								'user_id' => $id,

								'module_attributes_id' => $mattribute->custom_field_id,

								'attribute_value' => $file_val,

								'created_at' => date('Y-m-d h:i:s')

							);

							$this->Custom_fields_model->add_values($iattr_data);
						}

						/*$attr_orig_value = $this->Custom_fields_model->read_hrsale_module_attributes_values($result,$mattribute->custom_field_id);

					if($attr_orig_value->module_attributes_id != $mattribute->custom_field_id) {

						$this->Custom_fields_model->add_values($attr_data);

					}*/
					}
				}

				//get setting info 

				$setting = $this->Xin_model->read_setting_info(1);

				$company = $this->Xin_model->read_company_setting_info(1);

				if ($setting[0]->enable_email_notification == 'yes') {

					// load email library

					$this->load->library('email');

					$this->email->set_mailtype("html");



					//get company info

					$cinfo = $this->Xin_model->read_company_setting_info(1);

					//get email template

					$template = $this->Xin_model->read_email_template(8);



					$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;

					$logo = base_url() . 'uploads/logo/signin/' . $company[0]->sign_in_logo;



					// get user full name

					$full_name = $this->input->post('first_name') . ' ' . $this->input->post('last_name');



					$message = '

			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">

			<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var username}", "{var employee_id}", "{var employee_name}", "{var email}", "{var password}"), array($cinfo[0]->company_name, site_url(), $this->input->post('username'), $this->input->post('employee_id'), $full_name, $this->input->post('email'), $this->input->post('password')), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';



					hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $this->input->post('email'), $subject, $message);
				}

				if ($this->input->post('nationality_id') == 17) {
					$category = 'bahraini';
				} else {
					$category = 'expat';
				}

				$this->Employees_model->set_employees_leave_salary($category, $iresult);

				$Return['result'] = $this->lang->line('xin_success_add_employee');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	/*  add and update employee details info */

	// Validate and update info in database // basic info

	public function basic_info_validate()
	{

		if ($this->input->post('type') == 'basic_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$system = $this->Xin_model->read_setting_info(1);

			/* Server side PHP input validation */
			if ($this->input->post('first_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_first_name');
			} else if ($this->input->post('last_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_last_name');
			} else if ($this->input->post('employee_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_employee_id');
			} else if ($this->input->post('username') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_username');
			} else if ($this->input->post('company_id') === '') {

				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('location_id') === '') {

				$Return['error'] = $this->lang->line('xin_location_field_error');
			} else if ($this->input->post('department_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_department');
			} else if ($this->input->post('subdepartment_id') === '') {

				$Return['error'] = $this->lang->line('xin_hr_sub_department_field_error');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			} else if ($this->input->post('date_of_birth') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_date_of_birth');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_birth'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('date_of_joining') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_joining_date');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_joining'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('role') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_user_role');
			} else if ($this->input->post('contact_no') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_number');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {
				$Return['error'] = 'Invalid phone number';
				//$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('date_of_birth')) {
				$today = date("Y-m-d");
				$diff = date_diff(date_create($this->input->post('date_of_birth')), date_create($today));
				if ($diff->format('%y%') < 16) {
					$Return['error'] = 'Please Provide valid date of birth';
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function basic_info()
	{

		if ($this->input->post('type') == 'basic_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//$office_shift_id = $this->input->post('office_shift_id');

			$system = $this->Xin_model->read_setting_info(1);



			/* Server side PHP input validation */

			/*if ($this->input->post('employee_code') == '0') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			} else if ($this->input->post('employee_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_code');
			}*/
			if ($this->input->post('first_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_first_name');
			} /*else if(preg_match("/^(\pL{1,}[ ]?)+$/u",$this->input->post('first_name'))!=1) {

			$Return['error'] = $this->lang->line('xin_hr_string_error');

		}*/ else if ($this->input->post('last_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_last_name');
			} /*else if(preg_match("/^(\pL{1,}[ ]?)+$/u",$this->input->post('last_name'))!=1) {

			$Return['error'] = $this->lang->line('xin_hr_string_error');

		}*/ else if ($this->input->post('employee_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_employee_id');
			} else if ($this->input->post('username') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_username');
			}
			/*else if ($this->input->post('email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_email');
			} else if (!filter_var($this->input->post('email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			}*/ else if ($this->input->post('company_id') === '') {

				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('location_id') === '') {

				$Return['error'] = $this->lang->line('xin_location_field_error');
			} else if ($this->input->post('department_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_department');
			} else if ($this->input->post('subdepartment_id') === '') {

				$Return['error'] = $this->lang->line('xin_hr_sub_department_field_error');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			} else if ($this->input->post('date_of_birth') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_date_of_birth');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_birth'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('date_of_joining') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_joining_date');
			} else if ($this->Xin_model->validate_date($this->input->post('date_of_joining'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('role') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_user_role');
			} else if ($this->input->post('contact_no') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_number');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {
				$Return['error'] = 'Invalid phone number';
				//$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('date_of_birth')) {
				$today = date("Y-m-d");
				$diff = date_diff(date_create($this->input->post('date_of_birth')), date_create($today));
				if ($diff->format('%y%') < 16) {
					$Return['error'] = 'Please Provide valid date of birth';
				}
			}




			if ($Return['error'] != '') {

				$this->output($Return);
			}

			/*if($system[0]->multi_shifts == '1'){

			if(empty($office_shift_id)) {

				$Return['error'] = $this->lang->line('xin_office_shift_field_error');

			}

			$office_shift_ids = implode(',',$this->input->post('office_shift_id'));

			$column_shift = $office_shift_ids;

		} else {

			$column_shift = $this->input->post('office_shift_id');

		}*/



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$first_name = $this->Xin_model->clean_post($this->input->post('first_name'));

			$middle_name = $this->Xin_model->clean_post($this->input->post('middle_name'));

			$last_name = $this->Xin_model->clean_post($this->input->post('last_name'));

			$employee_id = $this->input->post('employee_id');

			$date_of_joining = $this->Xin_model->clean_date_post($this->input->post('date_of_joining'));

			//$username = $this->Xin_model->clean_post($this->input->post('username'));

			$username = $this->input->post('username');

			$date_of_birth = $this->Xin_model->clean_date_post($this->input->post('date_of_birth'));

			$contact_no = $this->Xin_model->clean_post($this->input->post('contact_no'));

			$address = $this->input->post('address');

			$leave_categories = array($this->input->post('leave_categories'));

			$cat_ids = implode(',', $this->input->post('leave_categories'));

			$view_companies_id = implode(',', $this->input->post('view_companies_id'));

			$leave_categories_new = array_filter($this->input->post('leave_categories'));

			$ot_eligible = $this->input->post('ot_eligible');

			$employee_code = $this->input->post('employeecode');



			$module_attributes = $this->Custom_fields_model->all_hrsale_module_attributes();

			$count_module_attributes = $this->Custom_fields_model->count_module_attributes();

			$i = 1;

			if ($count_module_attributes > 0) {

				foreach ($module_attributes as $mattribute) {

					if ($mattribute->validation == 1) {

						if ($i != 1) {
						} else if ($this->input->post($mattribute->attribute) == '') {

							$Return['error'] = $this->lang->line('xin_hrsale_custom_field_the') . ' ' . $mattribute->attribute_label . ' ' . $this->lang->line('xin_hrsale_custom_field_is_required');
						}
					}
				}

				if ($Return['error'] != '') {

					$this->output($Return);
				}
			}



			$designation_code = $dept_code = $company_code = '';

			/* To get company details */

			$company_det = $this->Company_model->read_company_information($this->input->post('company_id'));

			if ($company_det) {

				$company_code = $company_det[0]->company_code;
			}

			/* company details end */

			/* To get departments details */

			$dept_det = $this->Department_model->read_department_information($this->input->post('department_id'));

			if ($dept_det) {

				$dept_code = $dept_det[0]->department_code;
			}

			/* departments details end */

			/* To get designation details */

			$designation_det = $this->Designation_model->read_designation_information($this->input->post('designation_id'));

			if ($designation_det) {

				$designation_code = $designation_det[0]->designation_code;
			}

			/* designation details end */
			$input = $date_of_joining;
			$d1 = new DateTime($input);
			$date1 = date('Y-m-d');
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;


			$data = array(

				//'employee_id' => $employee_id,

				//'employee_code' => $employee_code,

				'office_shift_id' => $this->input->post('office_shift_id'),

				'reports_to' => $this->input->post('reports_to'),

				'first_name' => $first_name,

				'last_name' => $last_name,

				'middle_name' => $middle_name,
				'arabic_name' => $this->input->post('arabic_name'),
				'username' => $username,

				'company_id' => $this->input->post('company_id'),

				'location_id' => $this->input->post('location_id'),

				'email' => $this->input->post('email'),

				'date_of_birth' => $date_of_birth,

				'gender' => $this->input->post('gender'),

				'user_role_id' => $this->input->post('role'),

				'department_id' => $this->input->post('department_id'),

				'sub_department_id' => $this->input->post('subdepartment_id'),

				'designation_id' => $this->input->post('designation_id'),

				'date_of_joining' => $date_of_joining,
				'leave_updated_date' => $update_date,



				'contact_no' => $contact_no,

				'address' => $address,

				'state' => $this->input->post('estate'),

				'city' => $this->input->post('ecity'),

				'pincode' => $this->input->post('ezipcode'),

				'ethnicity_type' => $this->input->post('ethnicity_type'),

				'leave_categories' => $cat_ids,

				'view_companies_id' => $view_companies_id,

				'date_of_leaving' => $this->input->post('date_of_leaving'),

				'marital_status' => $this->input->post('marital_status'),

				'blood_group' => $this->input->post('blood_group'),

				'citizenship_id' => $this->input->post('citizenship_id'),

				'nationality_id' => $this->input->post('nationality_id'),

				'is_active' => $this->input->post('status'),

				'resignation_date' => $this->input->post('date_of_resignation'),

				'notice_period' => $this->input->post('notice_period'),

				'final_remark' => $this->input->post('final_remark'),

				'nature_of_leaving' => $this->input->post('nature_of_leaving'),

				'serial_no' => $this->input->post('serial_no'),

				'company_code' => $company_code,

				'dept_code' => $dept_code,

				'designation_code' => $designation_code,

				'ot_eligible' => $ot_eligible,
				'annual_leave_expire_months' => $this->input->post('annual_leave_expire_months'),
				//'late_deduction' => $this->input->post('late_deduction'),
				'probation_period' => $this->input->post('emp_probation_period_in_months'),
				'leave_salary_calculated_date' => $this->input->post('leave_salary_calculated_date')
			);

                $datacrm = array(
               
				'email' => $this->input->post('email'),

				'firstname' => $first_name,

				'lastname' => $last_name." ".$middle_name,

				'phonenumber' => $contact_no
				);
				
				
					$iresultset = $this->Employees_model->update_recordCRm($datacrm,$id);
			 
			 

			 

			













			$id = $this->input->post('user_id');
			foreach ($leave_categories_new as $x => $val) {
				if ($val != 0) {
					$check_exists = $this->Employees_model->get_employee_leave_type($val, $id, $update_date);
					if (empty($check_exists)) {
						$leave_type = $this->Employees_model->get_leaves($val);
						$data_leave = array(

							'employee_id' => $id,

							'leave_type' => $val,

							'leave_count' => $leave_type[0]->days_per_year,

							'created_at' => $update_date

						);
						$re_le = $this->Employees_model->add_leaves($data_leave);
					}
				}
			}

			$check_emp_already_exits = $this->Timesheet_model->available_leaves_emp($id);

			if ($check_emp_already_exits) {

				foreach ($check_emp_already_exits as $val_list) {

					$check_exits_carryforward =  $this->Employees_model->check_already_exists_leave_carryforward($cond = array('employee_id' => $id, 'leave_type_id' => $val_list->leave_type));

					if ($check_exits_carryforward) {

						foreach ($check_exits_carryforward as $check_exits_carryforwards) {

							$dlt = $this->Employees_model->delete_current_employee_leaves_carryforward(array('id' => $check_exits_carryforwards->id));
						}
					}

					$check_exits_leave_encashment =  $this->Employees_model->check_already_exists_leave_encashment($cond = array('employee_id' => $id, 'leave_type_id' => $val_list->leave_type));

					if ($check_exits_leave_encashment) {

						foreach ($check_exits_leave_encashment as $check_exits_leave_encashment) {

							$dlt = $this->Employees_model->delete_current_employee_leaves_encashment(array('id' => $check_exits_leave_encashment->id));
						}
					}
				}

				//$dlt = $this->Employees_model->delete_current_employee_leaves($id);
			}

			$all_leave_types = $this->Employees_model->get_leave_types();

			foreach ($all_leave_types as $leave_type) {
				if (in_array($leave_type->leave_type_id, $leave_categories_new)) {
				} else {
					$dlt = $this->Employees_model->delete_current_employee_leave_type($id, $leave_type->leave_type_id, $update_date);
				}
			}



			// 			$result = $this->Employees_model->basic_info($data, $id);
			$insdata = serialize($data);
			if ($this->input->post('approval_status') == 'approve') {
				$data["serialized"] = '';
				$result = $this->Employees_model->basic_info($data, $id);
			} elseif ($this->input->post('approval_status') == 'reject') {
				$insdata = '';
				$result = $this->Employees_model->basic_info_serialized($insdata, $id);
			} elseif ($this->input->post('approval_status') == 'pending') {
				$result = $this->Employees_model->basic_info_serialized($insdata, $id);
			} else {
				$result = $this->Employees_model->basic_info_serialized($insdata, $id);
			}

			if ($result) {

				$department_id = $this->input->post('department_id');

				$this->Employees_model->update_dept_count($department_id);


				if ($this->input->post('date_of_resignation')) {
					$employee_id = $id;

					$session = $this->session->userdata('username');
					$added_by = $session['user_id'];

					$this->db->where('employee_id', $employee_id);
					$resignation = $this->db->get('xin_employee_resignations');

					if ($resignation->num_rows() == 0) {
						$this->db->insert('xin_employee_resignations', array(
							'company_id' => $this->input->post('company_id'),
							'designation_id' => $this->input->post('designation_id'),
							'employee_id' => $employee_id,
							'resignation_date' => $this->input->post('date_of_resignation'),
							'notice_date' => $this->input->post('date_of_leaving'),
							'reason' => $this->input->post('nature_of_leaving'),
							'added_by' => $added_by,
							'status' => 0,
							'created_at' => date('d-m-Y'),
						));
					} else {
						$this->db->where('employee_id', $employee_id);
						$this->db->update('xin_employee_resignations', array(
							'resignation_date' => $this->input->post('date_of_resignation'),
							'notice_date' => $this->input->post('date_of_leaving'),
							'reason' => $this->input->post('nature_of_leaving'),
							'added_by' => $added_by,
						));
					}
				}
			}

			if ($count_module_attributes > 0) {

				foreach ($module_attributes as $mattribute) {



					//

					$count_exist_values = $this->Custom_fields_model->count_module_attributes_values($id, $mattribute->custom_field_id);

					if ($count_exist_values > 0) {

						if ($mattribute->attribute_type == 'fileupload') {

							if ($_FILES[$mattribute->attribute]['size'] != 0) {

								if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {

									//checking image type

									$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');

									$filename = $_FILES[$mattribute->attribute]['name'];

									$ext = pathinfo($filename, PATHINFO_EXTENSION);



									if (in_array($ext, $allowed)) {

										$tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];

										$profile = "uploads/custom_files/";

										$set_img = base_url() . "uploads/custom_files/";

										// basename() may prevent filesystem traversal attacks;

										// further validation/sanitation of the filename may be appropriate

										$name = basename($_FILES[$mattribute->attribute]["name"]);

										$newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;

										move_uploaded_file($tmp_name, $profile . $newfilename);

										$fname = $newfilename;
									}

									$iattr_data = array(

										'attribute_value' => $fname

									);

									$this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
								}
							} else {
							}
						} else if ($mattribute->attribute_type == 'multiselect') {

							$multisel_val = $this->input->post($mattribute->attribute);

							if (!empty($multisel_val)) {

								$newdata = implode(',', $this->input->post($mattribute->attribute));

								$iattr_data = array(

									'attribute_value' => $newdata,

								);

								$this->Custom_fields_model->update_att_record($iattr_data, $id, $mattribute->custom_field_id);
							}
						} else {

							$attr_data = array(

								'attribute_value' => $this->input->post($mattribute->attribute),

							);

							$this->Custom_fields_model->update_att_record($attr_data, $id, $mattribute->custom_field_id);
						}
					} else {

						if ($mattribute->attribute_type == 'fileupload') {

							if ($_FILES[$mattribute->attribute]['size'] != 0) {

								if (is_uploaded_file($_FILES[$mattribute->attribute]['tmp_name'])) {

									//checking image type

									$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'xls', 'doc', 'xlsx', 'docx');

									$filename = $_FILES[$mattribute->attribute]['name'];

									$ext = pathinfo($filename, PATHINFO_EXTENSION);



									if (in_array($ext, $allowed)) {

										$tmp_name = $_FILES[$mattribute->attribute]["tmp_name"];

										$profile = "uploads/custom_files/";

										$set_img = base_url() . "uploads/custom_files/";

										// basename() may prevent filesystem traversal attacks;

										// further validation/sanitation of the filename may be appropriate

										$name = basename($_FILES[$mattribute->attribute]["name"]);

										$newfilename = 'custom_file_' . round(microtime(true)) . '.' . $ext;

										move_uploaded_file($tmp_name, $profile . $newfilename);

										$fname = $newfilename;
									}

									$iattr_data = array(

										'user_id' => $id,

										'module_attributes_id' => $mattribute->custom_field_id,

										'attribute_value' => $fname,

										'created_at' => date('Y-m-d h:i:s')

									);

									$this->Custom_fields_model->add_values($iattr_data);
								}
							} else {

								if ($this->input->post($mattribute->attribute) == '') {

									$file_val = '';
								} else {

									$file_val = $this->input->post($mattribute->attribute);
								}

								$iattr_data = array(

									'user_id' => $id,

									'module_attributes_id' => $mattribute->custom_field_id,

									'created_at' => date('Y-m-d h:i:s')

								);

								$this->Custom_fields_model->add_values($iattr_data);
							}
						} else if ($mattribute->attribute_type == 'multiselect') {

							$multisel_val = $this->input->post($mattribute->attribute);

							if (!empty($multisel_val)) {

								$newdata = implode(',', $this->input->post($mattribute->attribute));

								$iattr_data = array(

									'user_id' => $id,

									'module_attributes_id' => $mattribute->custom_field_id,

									'attribute_value' => $newdata,

									'created_at' => date('Y-m-d h:i:s')

								);

								$this->Custom_fields_model->add_values($iattr_data);
							}
						} else {

							if ($this->input->post($mattribute->attribute) == '') {

								$file_val = '';
							} else {

								$file_val = $this->input->post($mattribute->attribute);
							}

							$iattr_data = array(

								'user_id' => $id,

								'module_attributes_id' => $mattribute->custom_field_id,

								'attribute_value' => $file_val,

								'created_at' => date('Y-m-d h:i:s')

							);

							$this->Custom_fields_model->add_values($iattr_data);
						}
					}
				}
			}

			if ($result == TRUE) {

				if ($this->input->post('approval_status') == 'approve') {
					$Return['result'] = $this->lang->line('xin_employee_basic_info_approve');
				} elseif ($this->input->post('approval_status') == 'reject') {
					$Return['result'] = $this->lang->line('xin_employee_basic_info_rejected');
				} elseif ($this->input->post('approval_status') == 'pending') {
					$Return['result'] = $this->lang->line('xin_employee_basic_info_pending');
				} else {
					$Return['result'] = $this->lang->line('xin_employee_basic_info_updated');
				}

				// $Return['result'] = $this->lang->line('xin_employee_basic_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update status info in database // status info

	public function update_status_info()
	{

		/* Define return | here result is used to return user data and error for error message */

		$status_id = $this->uri->segment(4);

		if ($status_id == 2) {

			$status_id = 0;
		}

		$user_id = $this->uri->segment(5);

		$user = $this->Xin_model->read_user_info($user_id);

		$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;

		$data = array(

			'is_active' => $status_id,

		);

		//$id = $this->input->post('user_id');

		$this->Employees_model->basic_info($data, $user_id);

		//$Return['result'] = $this->lang->line('xin_employee_basic_info_updated');

		echo $full_name . ' ' . $this->lang->line('xin_employee_status_updated');

		//$this->output($Return);

		//exit;

	}



	// Validate and update info in database // social info

	public function profile_picture_validate()
	{

		if ($this->input->post('type') == 'profile_picture') {

			$Return['fileName'] = '';
			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->input->post('user_id');

			if ($_FILES['p_file']['size'] == 0 && null == $this->input->post('remove_profile_picture')) {
				$Return['error'] = $this->lang->line('xin_employee_select_picture');
			}

			/* Check if file uploaded..*/
			if ($this->input->post('pro_file') != '' && $this->input->post('pro_file') != null && null == $this->input->post('remove_profile_picture')) {
				$data = array('profile_picture' => $this->input->post('pro_file'));
				$insdata = serialize($data);
				if ($this->input->post('profile_approval_status') == 'approve') {

					$data["serialize_profile_picture"] = '';
					$result = $this->Employees_model->profile_picture($data, $id);
				} elseif ($this->input->post('profile_approval_status') == 'reject') {
					$insdata = '';

					$result = $this->Employees_model->profile_picture_serialized($insdata, $id);
				} elseif ($this->input->post('profile_approval_status') == 'pending') {

					$result = $this->Employees_model->profile_picture_serialized($insdata, $id);
				} else {

					// 	$result = $this->Employees_model->profile_picture_serialized($insdata, $id);
					$result = $this->Employees_model->profile_picture($data, $id);
				}
				$this->Employees_model->save_profile_picture_approval_status($id, $this->input->post('profile_approval_status'));
				if ($result == TRUE) {
					$set_img = base_url() . "uploads/profile/";

					$Return['result'] = $this->lang->line('xin_employee_picture_updated');
					$Return['img'] = $set_img . $this->input->post('pro_file');
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
				$this->output($Return);
				exit;
			} else if ($_FILES['p_file']['size'] != 0 && null == $this->input->post('remove_profile_picture')) {
				if (is_uploaded_file($_FILES['p_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'gif', 'PNG');

					$filename = $_FILES['p_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["p_file"]["tmp_name"];

						$profile = "uploads/profile/";

						$set_img = base_url() . "uploads/profile/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["p_file"]["name"]);

						$newfilename = 'profile_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $profile . $newfilename);

						$fname = $newfilename;

						$Return['fileName'] = $fname;

						$this->output($Return);

						exit;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_picture_type');
					}
				}
			} else if (null != $this->input->post('remove_profile_picture')) {

				$Return['error'] = '';

				$this->output($Return);

				exit;
			}
			if ($Return['error'] != '') {

				$this->output($Return);
			}
		}
	}

	public function profile_picture()
	{

		if ($this->input->post('type') == 'profile_picture') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->input->post('user_id');

			$fname = $this->input->post('attachment');

			//UPDATE Employee info in DB

			$data = array('profile_picture' => $fname);
			$insdata = serialize($data);

			if ($this->input->post('profile_approval_status') == 'approve') {
				$data["serialized"] = '';
				$result = $this->Employees_model->profile_picture($data, $id);
			} elseif ($this->input->post('profile_approval_status') == 'reject') {
				$insdata = '';
				$result = $this->Employees_model->profile_picture_serialized($insdata, $id);
			} elseif ($this->input->post('profile_approval_status') == 'pending') {
				$result = $this->Employees_model->profile_picture_serialized($insdata, $id);
			} else {
				$result = $this->Employees_model->profile_picture($data, $id);
			}
			$set_img = base_url() . "uploads/profile/";
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			if ($result) {
				$Return['error'] = '';
				$Return['result'] = $this->lang->line('xin_employee_picture_updated');
				$Return['img'] = $set_img . $fname;
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			if (null != $this->input->post('remove_profile_picture')) {
				//UPDATE Employee info in DB

				$data = array('profile_picture' => 'no file');

				$row = $this->Employees_model->read_employee_information($id);

				$profile = base_url() . "uploads/profile/";

				$result = $this->Employees_model->profile_picture($data, $id);

				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_picture_updated');

					if ($row[0]->gender == 'Male') {

						$Return['img'] = $profile . 'default_male.jpg';
					} else {

						$Return['img'] = $profile . 'default_female.jpg';
					}
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}

				$this->output($Return);

				exit;
			}

			$this->output($Return);
			exit;
		}
	}

	// Validate and update info in database // basic info

	public function social_info_validate()
	{

		if ($this->input->post('type') == 'social_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '' || $this->input->post('facebook_link') == '') {

				$Return['error'] = "Add any social media link";
			} else if ($this->input->post('facebook_link') !== '' && !filter_var($this->input->post('facebook_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_fb_field_error');
			} else if ($this->input->post('twitter_link') !== '' && !filter_var($this->input->post('twitter_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_twitter_field_error');
			} else if ($this->input->post('blogger_link') !== '' && !filter_var($this->input->post('blogger_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_blogger_field_error');
			} else if ($this->input->post('linkdedin_link') !== '' && !filter_var($this->input->post('linkdedin_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_linkedin_field_error');
			} else if ($this->input->post('google_plus_link') !== '' && !filter_var($this->input->post('google_plus_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_gplus_field_error');
			} else if ($this->input->post('instagram_link') !== '' && !filter_var($this->input->post('instagram_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_instagram_field_error');
			} else if ($this->input->post('pinterest_link') !== '' && !filter_var($this->input->post('pinterest_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_pinterest_field_error');
			} else if ($this->input->post('youtube_link') !== '' && !filter_var($this->input->post('youtube_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_youtube_field_error');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function social_info()
	{



		if ($this->input->post('type') == 'social_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('facebook_link') !== '' && !filter_var($this->input->post('facebook_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_fb_field_error');
			} else if ($this->input->post('twitter_link') !== '' && !filter_var($this->input->post('twitter_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_twitter_field_error');
			} else if ($this->input->post('blogger_link') !== '' && !filter_var($this->input->post('blogger_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_blogger_field_error');
			} else if ($this->input->post('linkdedin_link') !== '' && !filter_var($this->input->post('linkdedin_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_linkedin_field_error');
			} else if ($this->input->post('google_plus_link') !== '' && !filter_var($this->input->post('google_plus_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_gplus_field_error');
			} else if ($this->input->post('instagram_link') !== '' && !filter_var($this->input->post('instagram_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_instagram_field_error');
			} else if ($this->input->post('pinterest_link') !== '' && !filter_var($this->input->post('pinterest_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_pinterest_field_error');
			} else if ($this->input->post('youtube_link') !== '' && !filter_var($this->input->post('youtube_link'), FILTER_VALIDATE_URL)) {

				$Return['error'] = $this->lang->line('xin_hr_youtube_field_error');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'facebook_link' => $this->input->post('facebook_link'),

				'twitter_link' => $this->input->post('twitter_link'),

				'blogger_link' => $this->input->post('blogger_link'),

				'linkdedin_link' => $this->input->post('linkdedin_link'),

				'google_plus_link' => $this->input->post('google_plus_link'),

				'instagram_link' => $this->input->post('instagram_link'),

				'pinterest_link' => $this->input->post('pinterest_link'),

				'youtube_link' => $this->input->post('youtube_link')

			);

			$id = $this->input->post('user_id');
			$insdata = serialize($data);
			if ($this->input->post('social_approval_status') == 'approve') {
				$data["serialized_social"] = '';
				$result = $this->Employees_model->social_info($data, $id);
			} elseif ($this->input->post('social_approval_status') == 'reject') {
				$insdata = '';
				$result = $this->Employees_model->social_info_serialized($insdata, $id);
			} elseif ($this->input->post('social_approval_status') == 'pending') {
				$result = $this->Employees_model->social_info_serialized($insdata, $id);
			} else {
				$result = $this->Employees_model->social_info_serialized($insdata, $id);
			}
			
			
				$dataCrm = array(

				'facebook' => $this->input->post('facebook_link'),

				'linkedin' => $this->input->post('linkdedin_link'),
 

			);
			
				$iresultset = $this->Employees_model->update_recordCRm($dataCrm,$id);
			
			
			
			
			
			
			
			
			
			

			// 			$result = $this->Employees_model->social_info($data, $id);

			if ($result == TRUE) {
				if ($this->input->post('social_approval_status') == 'approve') {
					$Return['result'] = $this->lang->line('xin_success_update_social_info_approve');
				} elseif ($this->input->post('social_approval_status') == 'reject') {
					$Return['result'] = $this->lang->line('xin_success_update_social_info_rejected');
				} elseif ($this->input->post('social_approval_status') == 'pending') {
					$Return['result'] = $this->lang->line('xin_success_update_social_info_pending');
				} else {
					$Return['result'] = $this->lang->line('xin_success_update_social_info');
				}

				// $Return['result'] = $this->lang->line('xin_success_update_social_info');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update info in database // contact info

	public function update_contacts_info()
	{



		if ($this->input->post('type') == 'contact_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			/* Server side PHP input validation */

			if ($this->input->post('salutation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_salutation');
			} else if ($this->input->post('contact_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_name');
			} else if ($this->input->post('relation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_grp');
			} else if ($this->input->post('primary_email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_pemail');
			} else if ($this->input->post('mobile_phone') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_mobile');
			} else if ($this->input->post('city') === '') {

				$Return['error'] = $this->lang->line('xin_error_city_field');
			} else if ($this->input->post('country') === '') {

				$Return['error'] = $this->lang->line('xin_error_country_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'salutation' => $this->input->post('salutation'),

				'contact_name' => $this->input->post('contact_name'),

				'relation' => $this->input->post('relation'),

				'company' => $this->input->post('company'),

				'job_title' => $this->input->post('job_title'),

				'primary_email' => $this->input->post('primary_email'),

				'mobile_phone' => $this->input->post('mobile_phone'),

				'address' => $this->input->post('address'),

				'city' => $this->input->post('city'),

				'state' => $this->input->post('state'),

				'zipcode' => $this->input->post('zipcode'),

				'country' => $this->input->post('country'),

				'employee_id' => $this->input->post('user_id'),

				'contact_type' => 'permanent'

			);



			$query = $this->Employees_model->check_employee_contact_permanent($this->input->post('user_id'));

			if ($query->num_rows() > 0) {

				$res = $query->result();

				$e_field_id = $res[0]->contact_id;

				$result = $this->Employees_model->contact_info_update($data, $e_field_id);
			} else {

				$result = $this->Employees_model->contact_info_add($data);
			}



			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and update info in database //  econtact info

	public function update_contact_info()
	{



		if ($this->input->post('type') == 'contact_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			/* Server side PHP input validation */

			if ($this->input->post('salutation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_salutation');
			} else if ($this->input->post('contact_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_name');
			} else if ($this->input->post('relation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_grp');
			} else if ($this->input->post('primary_email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_pemail');
			} else if ($this->input->post('mobile_phone') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_mobile');
			} else if ($this->input->post('city') === '') {

				$Return['error'] = $this->lang->line('xin_error_city_field');
			} else if ($this->input->post('country') === '') {

				$Return['error'] = $this->lang->line('xin_error_country_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'salutation' => $this->input->post('salutation'),

				'contact_name' => $this->input->post('contact_name'),

				'relation' => $this->input->post('relation'),

				'company' => $this->input->post('company'),

				'job_title' => $this->input->post('job_title'),

				'primary_email' => $this->input->post('primary_email'),

				'mobile_phone' => $this->input->post('mobile_phone'),

				'address' => $this->input->post('address'),

				'city' => $this->input->post('city'),

				'state' => $this->input->post('state'),

				'zipcode' => $this->input->post('zipcode'),

				'country' => $this->input->post('country'),

				'employee_id' => $this->input->post('user_id'),

				'contact_type' => 'current'

			);



			$query = $this->Employees_model->check_employee_contact_current($this->input->post('user_id'));

			if ($query->num_rows() > 0) {

				$res = $query->result();

				$e_field_id = $res[0]->contact_id;

				$result = $this->Employees_model->contact_info_update($data, $e_field_id);
			} else {

				$result = $this->Employees_model->contact_info_add($data);
			}

			//$e_field_id = 1;



			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and update info in database // contact info

	public function contact_info_validate()
	{

		if ($this->input->post('type') == 'contact_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('relation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_relation');
			} else if ($this->input->post('contact_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_name');
			} else if (!preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('contact_name'))) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('contact_no') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('work_phone') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('work_phone'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('work_phone_extension') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('work_phone_extension'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('mobile_phone') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_mobile');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('mobile_phone'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('home_phone') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('home_phone'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('work_email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_email');
			} else if (!filter_var($this->input->post('work_email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->input->post('personal_email') !== '' && !filter_var($this->input->post('personal_email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->input->post('zipcode') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('zipcode'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			}

			$this->output($Return);

			exit;
		}
	}

	public function contact_info()
	{



		if ($this->input->post('type') == 'contact_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('relation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_relation');
			} else if ($this->input->post('contact_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_name');
			} else if (!preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('contact_name'))) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('contact_no') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('contact_no'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('work_phone') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('work_phone'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('work_phone_extension') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('work_phone_extension'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('mobile_phone') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_mobile');
			} else if (!preg_match('/^([0-9]*)$/', $this->input->post('mobile_phone'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('home_phone') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('home_phone'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			} else if ($this->input->post('work_email') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_email');
			} else if (!filter_var($this->input->post('work_email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->input->post('personal_email') !== '' && !filter_var($this->input->post('personal_email'), FILTER_VALIDATE_EMAIL)) {

				$Return['error'] = $this->lang->line('xin_employee_error_invalid_email');
			} else if ($this->input->post('zipcode') !== '' && !preg_match('/^([0-9]*)$/', $this->input->post('zipcode'))) {

				$Return['error'] = $this->lang->line('xin_hr_numeric_error');
			}



			if (null != $this->input->post('is_primary')) {

				$is_primary = $this->input->post('is_primary');
			} else {

				$is_primary = '';
			}

			if (null != $this->input->post('is_dependent')) {

				$is_dependent = $this->input->post('is_dependent');
			} else {

				$is_dependent = '';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$contact_name = $this->Xin_model->clean_post($this->input->post('contact_name'));

			$address_1 = $this->Xin_model->clean_post($this->input->post('address_1'));

			$address_2 = $this->Xin_model->clean_post($this->input->post('address_2'));

			$city = $this->Xin_model->clean_post($this->input->post('city'));

			$state = $this->Xin_model->clean_post($this->input->post('state'));



			$data = array(

				'relation' => $this->input->post('relation'),

				'work_email' => $this->input->post('work_email'),

				'is_primary' => $is_primary,

				'is_dependent' => $is_dependent,

				'personal_email' => $this->input->post('personal_email'),

				'contact_name' => $contact_name,

				'address_1' => $address_1,

				'work_phone' => $this->input->post('work_phone'),

				'work_phone_extension' => $this->input->post('work_phone_extension'),

				'address_2' => $address_2,

				'mobile_phone' => $this->input->post('mobile_phone'),

				'city' => $city,

				'state' => $state,

				'zipcode' => $this->input->post('zipcode'),

				'home_phone' => $this->input->post('home_phone'),

				'country' => $this->input->post('country'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->contact_info_add($data);

			if ($result == TRUE) {
				$all_countries = $this->Xin_model->get_countries();
				//   var_dump($all_countries);
				$contries = '<select class="form-control" name="country" id="country" data-plugin="select_hrm" data-placeholder="Country">
                    <option default selected value="">Select Country</option>';
				foreach ($all_countries as $country) {
					$contries .= '<option value=' . $country->country_id . '>' . $country->country_name . '</option>';
				}

				$contries .= '</select>';
				$Return['contries'] = $contries;
				$Return['result'] = $this->lang->line('xin_employee_contact_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update info in database //  econtact info

	public function e_contact_info_validate()
	{
		// var_dump($this->input->post('save_status'));die();
		if ($this->input->post('type') == 'e_contact_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('relation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_relation');
			} else if ($this->input->post('contact_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_name');
			} else if ($this->input->post('mobile_phone') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_mobile');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$this->output($Return);

			exit;
		}
	}

	public function e_contact_info()
	{
		// var_dump($this->input->post('save_status'));die();
		if ($this->input->post('type') == 'e_contact_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('relation') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_relation');
			} else if ($this->input->post('contact_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contact_name');
			} else if ($this->input->post('mobile_phone') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_mobile');
			}



			if (null != $this->input->post('is_primary')) {

				$is_primary = $this->input->post('is_primary');
			} else {

				$is_primary = '';
			}

			if (null != $this->input->post('is_dependent')) {

				$is_dependent = $this->input->post('is_dependent');
			} else {

				$is_dependent = '';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'relation' => $this->input->post('relation'),

				'work_email' => $this->input->post('work_email'),

				'is_primary' => $is_primary,

				'is_dependent' => $is_dependent,

				'personal_email' => $this->input->post('personal_email'),

				'contact_name' => $this->input->post('contact_name'),

				'address_1' => $this->input->post('address_1'),

				'work_phone' => $this->input->post('work_phone'),

				'work_phone_extension' => $this->input->post('work_phone_extension'),

				'address_2' => $this->input->post('address_2'),

				'mobile_phone' => $this->input->post('mobile_phone'),

				'city' => $this->input->post('city'),

				'state' => $this->input->post('state'),

				'zipcode' => $this->input->post('zipcode'),

				'home_phone' => $this->input->post('home_phone'),

				'country' => $this->input->post('country')

			);



			$e_field_id = $this->input->post('e_field_id');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			// var_dump($this->input->post('save_status'));die();
			if ($this->input->post('save_status') == 'pending') {
				$result = $this->Employees_model->contact_info_update($data, $e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_status') == 'rejected') {
				$result = $this->Employees_model->contact_info_rejected($e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_contact_info_rejected');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_status') == 'approved') {
				$result = $this->Employees_model->contact_info_approved($data, $e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$result = $this->Employees_model->contact_info_approved($data, $e_field_id);
					if ($result == TRUE) {

						$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} else {
					$result = $this->Employees_model->contact_info_update($data, $e_field_id);
					if ($result == TRUE) {

						$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				}
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // document info

	public function document_info_validate()
	{



		if ($this->input->post('type') == 'document_info' && $this->input->post('data') == 'document_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('document_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_type');
			} /*else if($this->Xin_model->validate_date($this->input->post('date_of_expiry'),'Y-m-d') == false) {

			 $Return['error'] = $this->lang->line('xin_hr_date_format_error');

		}*/ else if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_document_title');
			} else if ($_FILES['document_file']['size'] == 0) {

				$fname = '';
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function document_info()
	{



		if ($this->input->post('type') == 'document_info' && $this->input->post('data') == 'document_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('document_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_type');
			} /*else if($this->Xin_model->validate_date($this->input->post('date_of_expiry'),'Y-m-d') == false) {

			 $Return['error'] = $this->lang->line('xin_hr_date_format_error');

		}*/ else if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_document_title');
			} else if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$fname = '';
			} else {
				$fname = $this->input->post('attachment');
			}


			if ($Return['error'] != '') {

				$this->output($Return);
			}



			//clean simple fields

			$title = $this->Xin_model->clean_post($this->input->post('title'));

			$description = $this->Xin_model->clean_post($this->input->post('description'));

			// clean date fields

			$date_of_expiry = $this->Xin_model->clean_date_post($this->input->post('date_of_expiry'));



			$data = array(

				'document_type_id' => $this->input->post('document_type_id'),

				'date_of_expiry' => $date_of_expiry,

				'document_file' => $fname,

				'title' => $title,

				//'notification_email' => $this->input->post('email'),

				//'is_alert' => $this->input->post('send_mail'),

				'description' => $description,

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->document_info_add($data);

			if ($result == TRUE) {
				$all_document_types = $this->Employees_model->all_document_types();
				$documents = '<label for="relation">' . $this->lang->line('xin_e_details_dtype') . '</label><select class="form-control" name="document_type_id" id="document_type_id" data-plugin="select_hrm" data-placeholder="' . $this->lang->line('xin_e_details_choose_dtype') . '">
                    <option default selected value="">' . $this->lang->line('xin_e_details_choose_dtype') . '</option>';
				foreach ($all_document_types as $document_type) {
					$documents .= '<option value=' . $document_type->document_type_id . '>' . $document_type->document_type . '</option>';
				}
				$documents .= '</select>';

				$send_mail = '<label for="send_mail">' . $this->lang->line("xin_e_details_send_notifyemail") . '</label><select name="send_mail" id="send_mail" class="form-control" data-plugin="select_hrm">
                <option value="1">' . $this->lang->line("xin_yes") . '</option><option value="2">' . $this->lang->line("xin_no") . '</option></select>';

				$Return['documents'] = $documents;
				$Return['send_mail'] = $send_mail;

				$Return['result'] = $this->lang->line('xin_employee_d_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // document info

	public function immigration_info_validate()
	{



		if ($this->input->post('type') == 'immigration_info' && $this->input->post('data') == 'immigration_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('document_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_type');
			} else if ($this->input->post('document_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_number');
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}



			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/immigration/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$this->output($Return);

			exit;
		}
	}

	public function immigration_info()
	{



		if ($this->input->post('type') == 'immigration_info' && $this->input->post('data') == 'immigration_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('document_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_type');
			} else if ($this->input->post('document_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_number');
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$document_number = $this->Xin_model->clean_post($this->input->post('document_number'));

			$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

			$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));

			$eligible_review_date = $this->Xin_model->clean_date_post($this->input->post('eligible_review_date'));

			$data = array(

				'document_type_id' => $this->input->post('document_type_id'),

				'document_number' => $document_number,

				'document_file' => $this->input->post('attachment'),

				'issue_date' => $issue_date,

				'expiry_date' => $expiry_date,

				'country_id' => $this->input->post('country'),

				'eligible_review_date' => $eligible_review_date,

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y h:i:s'),

			);

			$result = $this->Employees_model->immigration_info_add($data);



			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_img_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // document info

	public function e_immigration_info()
	{

		if ($this->input->post('type') == 'e_immigration_info' && $this->input->post('data') == 'e_immigration_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('document_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_type');
			} else if ($this->input->post('document_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_number');
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			}



			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$data = array(

					'document_type_id' => $this->input->post('document_type_id'),

					'document_number' => $this->input->post('document_number'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),

					'country_id' => $this->input->post('country'),

					'eligible_review_date' => $this->input->post('eligible_review_date'),

				);

				$e_field_id = $this->input->post('e_field_id');
				$insdata = serialize($data);
				if ($this->input->post('immigration_approval_status') == 'approve') {
					$data["serialized"] = '';
					$result = $this->Employees_model->img_document_info_update($data, $e_field_id);
				} elseif ($this->input->post('immigration_approval_status') == 'reject') {
					$insdata = '';
					$result = $this->Employees_model->img_document_info_serialized($insdata, $e_field_id);
				} elseif ($this->input->post('immigration_approval_status') == 'pending') {
					$result = $this->Employees_model->img_document_info_serialized($insdata, $e_field_id);
				} else {
					$result = $this->Employees_model->img_document_info_serialized($insdata, $e_field_id);
				}

				// $result = $this->Employees_model->img_document_info_update($data, $e_field_id);

				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_img_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}

				$this->output($Return);

				exit;
			} else {
				$fname = $this->input->post('attachment');

				$data = array(

					'document_type_id' => $this->input->post('document_type_id'),

					'document_number' => $this->input->post('document_number'),

					'document_file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),

					'country_id' => $this->input->post('country'),

					'eligible_review_date' => $this->input->post('eligible_review_date'),

				);

				$e_field_id = $this->input->post('e_field_id');
				$insdata = serialize($data);
				if ($this->input->post('immigration_approval_status') == 'approve') {
					$data["serialized"] = '';
					$result = $this->Employees_model->img_document_info_update($data, $e_field_id);
				} elseif ($this->input->post('immigration_approval_status') == 'reject') {
					$insdata = '';
					$result = $this->Employees_model->img_document_info_serialized($insdata, $e_field_id);
				} elseif ($this->input->post('immigration_approval_status') == 'pending') {
					$result = $this->Employees_model->img_document_info_serialized($insdata, $e_field_id);
				} else {
					$result = $this->Employees_model->img_document_info_serialized($insdata, $e_field_id);
				}

				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_d_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}

				$this->output($Return);

				exit;
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_img_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function e_immigration_info_validate()
	{



		if ($this->input->post('type') == 'e_immigration_info' && $this->input->post('data') == 'e_immigration_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('document_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_type');
			} else if ($this->input->post('document_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_number');
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			}

			if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

				//checking image type

				$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

				$filename = $_FILES['document_file']['name'];

				$ext = pathinfo($filename, PATHINFO_EXTENSION);



				if (in_array($ext, $allowed)) {

					$tmp_name = $_FILES["document_file"]["tmp_name"];

					$documentd = "uploads/document/immigration/";

					// basename() may prevent filesystem traversal attacks;

					// further validation/sanitation of the filename may be appropriate

					$name = basename($_FILES["document_file"]["name"]);

					$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

					move_uploaded_file($tmp_name, $documentd . $newfilename);

					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
					$this->output($Return);
					exit;
				} else {

					$Return['error'] = $this->lang->line('xin_employee_document_file_type');
				}
			}




			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$Return['error'] = '';
			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // e_document info

	public function e_document_info_validate()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		/* Server side PHP input validation */

		if ($this->input->post('document_type_id') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_type');
		} else if ($this->input->post('title') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_document_title');
		}

		/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] != 0) {

			if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

				//checking image type

				$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

				$filename = $_FILES['document_file']['name'];

				$ext = pathinfo($filename, PATHINFO_EXTENSION);

				if (in_array($ext, $allowed)) {

					$tmp_name = $_FILES["document_file"]["tmp_name"];

					$documentd = "uploads/document/";

					// basename() may prevent filesystem traversal attacks;

					// further validation/sanitation of the filename may be appropriate

					$name = basename($_FILES["document_file"]["name"]);

					$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

					move_uploaded_file($tmp_name, $documentd . $newfilename);

					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
					$this->output($Return);
					exit;
				} else {

					$Return['error'] = $this->lang->line('xin_employee_document_file_type');
				}
			}
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		}
		$this->output($Return);
	}

	public function e_document_info()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('document_type_id') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_type');
		} else if ($this->input->post('title') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_document_title');
		}



		/* Check if file uploaded..*/ else if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

			$data = array(

				'document_type_id' => $this->input->post('document_type_id'),

				'date_of_expiry' => $this->input->post('date_of_expiry'),

				'title' => $this->input->post('title'),

				//'notification_email' => $this->input->post('email'),

				//'is_alert' => $this->input->post('send_mail'),

				'description' => $this->input->post('description')

			);

			$e_field_id = $this->input->post('e_field_id');
			$insdata = serialize($data);
			if ($this->input->post('document_approval_status') == 'approve') {
				$data["serialized"] = '';
				$result = $this->Employees_model->document_info_update($data, $e_field_id);
			} elseif ($this->input->post('document_approval_status') == 'reject') {
				$insdata = '';
				$result = $this->Employees_model->document_info_serialized($insdata, $e_field_id);
			} elseif ($this->input->post('document_approval_status') == 'pending') {
				$result = $this->Employees_model->document_info_serialized($insdata, $e_field_id);
			} else {
				$result = $this->Employees_model->document_info_serialized($insdata, $e_field_id);
			}

			// $result = $this->Employees_model->document_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_d_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		} else {

			$fname = $this->input->post('attachment');

			$data = array(

				'document_type_id' => $this->input->post('document_type_id'),

				'date_of_expiry' => $this->input->post('date_of_expiry'),

				'document_file' => $fname,

				'title' => $this->input->post('title'),

				//'notification_email' => $this->input->post('email'),

				//'is_alert' => $this->input->post('send_mail'),

				'description' => $this->input->post('description')

			);

			$e_field_id = $this->input->post('e_field_id');
			$insdata = serialize($data);
			if ($this->input->post('document_approval_status') == 'approve') {
				$data["serialized"] = '';
				$result = $this->Employees_model->document_info_update($data, $e_field_id);
			} elseif ($this->input->post('document_approval_status') == 'reject') {
				$insdata = '';
				$result = $this->Employees_model->document_info_serialized($insdata, $e_field_id);
			} elseif ($this->input->post('document_approval_status') == 'pending') {
				$result = $this->Employees_model->document_info_serialized($insdata, $e_field_id);
			} else {
				$result = $this->Employees_model->document_info_serialized($insdata, $e_field_id);
			}

			// 		$result = $this->Employees_model->document_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_d_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}



		if ($Return['error'] != '') {

			$this->output($Return);
		}
		$this->output($Return);
	}

	// Validate and add info in database // qualification info

	public function qualification_info_validate()
	{



		if ($this->input->post('type') == 'qualification_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			$from_year = $this->input->post('from_year');

			$to_year = $this->input->post('to_year');

			$st_date = strtotime($from_year);

			$ed_date = strtotime($to_year);



			if ($this->input->post('name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_sch_uni');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('from_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->Xin_model->validate_date($this->input->post('from_year'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('to_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($this->Xin_model->validate_date($this->input->post('to_year'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($st_date > $ed_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function qualification_info()
	{



		if ($this->input->post('type') == 'qualification_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			$from_year = $this->input->post('from_year');

			$to_year = $this->input->post('to_year');

			$st_date = strtotime($from_year);

			$ed_date = strtotime($to_year);



			if ($this->input->post('name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_sch_uni');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('name')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('from_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->Xin_model->validate_date($this->input->post('from_year'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('to_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($this->Xin_model->validate_date($this->input->post('to_year'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($st_date > $ed_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$name = $this->Xin_model->clean_post($this->input->post('name'));

			$from_year = $this->Xin_model->clean_date_post($this->input->post('from_year'));

			$to_year = $this->Xin_model->clean_date_post($this->input->post('to_year'));

			$description = $this->Xin_model->clean_post($this->input->post('description'));

			$data = array(

				'name' => $name,

				'education_level_id' => $this->input->post('education_level'),

				'from_year' => $from_year,

				'language_id' => $this->input->post('language'),

				'to_year' => $this->input->post('to_year'),

				'skill_id' => $this->input->post('skill'),

				'description' => $description,

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->qualification_info_add($data);

			if ($result == TRUE) {
				$all_education_level = $this->Employees_model->all_education_level();
				$all_qualification_language = $this->Employees_model->all_qualification_language();
				$education_level = '<label for="education_level" class="control-label">' . $this->lang->line("xin_e_details_edu_level") . '</label><select class="form-control" name="education_level" data-plugin="select_hrm" data-placeholder="' . $this->lang->line("xin_e_details_edu_level") . '">';
				foreach ($all_education_level as $education_lvl) {
					$education_level .= '<option value="' . $education_lvl->education_level_id . '">' . $education_lvl->name . '</option> ';
				}
				$education_level .= '</select>';
				$qualification = '<label for="language" class="control-label">' . $this->lang->line("xin_e_details_language") . '</label><select class="form-control" name="language" data-plugin="select_hrm" data-placeholder="' . $this->lang->line("xin_e_details_language") . '"> ';
				foreach ($all_qualification_language as $qualification_language) {
					$qualification .= '<option value="' . $qualification_language->language_id . '">' . $qualification_language->name . '</option>';
				}
				$qualification .= '</select>';
				$Return['education_level'] = $education_level;
				$Return['qualification'] = $qualification;
				$Return['result'] = $this->lang->line('xin_employee_error_q_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // qualification info

	public function e_qualification_info_validate()
	{

		if ($this->input->post('type') == 'e_qualification_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			$from_year = $this->input->post('from_year');

			$to_year = $this->input->post('to_year');

			$st_date = strtotime($from_year);

			$ed_date = strtotime($to_year);



			if ($this->input->post('name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_sch_uni');
			} else if ($this->input->post('from_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($st_date > $ed_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function e_qualification_info()
	{

		if ($this->input->post('type') == 'e_qualification_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			$from_year = $this->input->post('from_year');

			$to_year = $this->input->post('to_year');

			$st_date = strtotime($from_year);

			$ed_date = strtotime($to_year);



			if ($this->input->post('name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_sch_uni');
			} else if ($this->input->post('from_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_year') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($st_date > $ed_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'name' => $this->input->post('name'),

				'education_level_id' => $this->input->post('education_level'),

				'from_year' => $this->input->post('from_year'),

				'language_id' => $this->input->post('language'),

				'to_year' => $this->input->post('to_year'),

				'skill_id' => $this->input->post('skill'),

				'description' => $this->input->post('description')

			);

			$e_field_id = $this->input->post('e_field_id');
			$insdata = serialize($data);
			if ($this->input->post('approval_status') == 'approve') {
				$data["serialized"] = '';
				$result = $this->Employees_model->qualification_info_update($data, $e_field_id);
			} elseif ($this->input->post('approval_status') == 'reject') {
				$insdata = '';
				$result = $this->Employees_model->qualification_info_serialized($insdata, $e_field_id);
			} elseif ($this->input->post('approval_status') == 'pending') {
				$result = $this->Employees_model->qualification_info_serialized($insdata, $e_field_id);
			} else {
				$result = $this->Employees_model->qualification_info_serialized($insdata, $e_field_id);
			}

			// 			$result = $this->Employees_model->qualification_info_update($data, $e_field_id);

			if ($result == TRUE) {
				if ($this->input->post('social_approval_status') == 'approve') {
					$Return['result'] = $this->lang->line('xin_employee_error_q_info_approved');
				} elseif ($this->input->post('social_approval_status') == 'reject') {
					$Return['result'] = $this->lang->line('xin_employee_error_q_info_rejected');
				} elseif ($this->input->post('social_approval_status') == 'pending') {
					$Return['result'] = $this->lang->line('xin_employee_error_q_info_pending');
				} else {
					$Return['result'] = $this->lang->line('xin_employee_error_q_info_updated');
				}

				// $Return['result'] = $this->lang->line('xin_employee_error_q_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // work experience info

	public function work_experience_info_validate()
	{



		if ($this->input->post('type') == 'work_experience_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			/* Server side PHP input validation */

			if ($this->input->post('company_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_company_name');
			} else if ($this->input->post('post') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_post');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function work_experience_info()
	{



		if ($this->input->post('type') == 'work_experience_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			/* Server side PHP input validation */

			if ($this->input->post('company_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_company_name');
			} else if ($this->input->post('post') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_post');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'company_name' => $this->input->post('company_name'),

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date'),

				'post' => $this->input->post('post'),

				'description' => $this->input->post('description'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->work_experience_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_error_w_exp_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function e_work_experience_info_validate()
	{

		if ($this->input->post('type') == 'e_work_experience_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			/* Server side PHP input validation */

			if ($this->input->post('company_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_company_name');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			} else if ($this->input->post('post') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_post');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$this->output($Return);

			exit;
		}
	}

	public function e_work_experience_info()
	{



		if ($this->input->post('type') == 'e_work_experience_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			/* Server side PHP input validation */

			if ($this->input->post('company_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_company_name');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_date_shouldbe');
			} else if ($this->input->post('post') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_post');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'company_name' => $this->input->post('company_name'),

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date'),

				'post' => $this->input->post('post'),

				'description' => $this->input->post('description')

			);

			$e_field_id = $this->input->post('e_field_id');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			if ($this->input->post('save_status_exp') == 'pending') {
				$result = $this->Employees_model->work_experience_info_update($data, $e_field_id);

				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_error_w_exp_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_status_exp') == 'rejected') {
				$result = $this->Employees_model->experience_info_rejected($e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_exp_info_rejected');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_status_exp') == 'approved') {
				$result = $this->Employees_model->exp_info_approved($data, $e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$result = $this->Employees_model->exp_info_approved($data, $e_field_id);
					if ($result == TRUE) {

						$Return['result'] = $this->lang->line('xin_employee_contact_info_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} else {
					$result = $this->Employees_model->work_experience_info_update($data, $e_field_id);

					if ($result == TRUE) {

						$Return['result'] = $this->lang->line('xin_employee_error_w_exp_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				}
			}
			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database // bank account info

	public function bank_account_info_validate()
	{



		if ($this->input->post('type') == 'bank_account_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('account_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_title');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('account_title')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('account_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
			} else if ($this->input->post('bank_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_name');
			} else if ($this->input->post('bank_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_code');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function bank_account_info()
	{



		if ($this->input->post('type') == 'bank_account_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('account_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_title');
			} else if (preg_match("/^(\pL{1,}[ ]?)+$/u", $this->input->post('account_title')) != 1) {

				$Return['error'] = $this->lang->line('xin_hr_string_error');
			} else if ($this->input->post('account_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
			} else if ($this->input->post('bank_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_name');
			} else if ($this->input->post('bank_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_code');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'account_title' => $this->input->post('account_title'),

				'account_number' => $this->input->post('account_number'),

				'bank_name' => $this->input->post('bank_name'),

				'bank_code' => $this->input->post('bank_code'),

				'bank_branch' => $this->input->post('bank_branch'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->bank_account_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_error_bank_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // bank account info

	public function add_security_level_validate()
	{

		if ($this->input->post('type') == 'security_level_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('security_level') === '') {

				$Return['error'] = $this->lang->line('xin_error_security_level_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function add_security_level()
	{



		if ($this->input->post('type') == 'security_level_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('security_level') === '') {

				$Return['error'] = $this->lang->line('xin_error_security_level_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'security_type' => $this->input->post('security_level'),

				'expiry_date' => $this->input->post('expiry_date'),

				'date_of_clearance' => $this->input->post('date_of_clearance'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->security_level_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_security_level_emp_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database // ebank account info

	public function e_security_level_info_validate()
	{
		if ($this->input->post('type') == 'e_security_level_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('security_level') === '') {

				$Return['error'] = $this->lang->line('xin_error_security_level_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function e_security_level_info()
	{
		if ($this->input->post('type') == 'e_security_level_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('security_level') === '') {

				$Return['error'] = $this->lang->line('xin_error_security_level_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'security_type' => $this->input->post('security_level'),

				'expiry_date' => $this->input->post('expiry_date'),

				'date_of_clearance' => $this->input->post('date_of_clearance')

			);

			$e_field_id = $this->input->post('e_field_id');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			if ($this->input->post('security_save_status') == 'pending') {

				$result = $this->Employees_model->security_level_info_update($data, $e_field_id);

				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_security_level_emp_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('security_save_status') == 'rejected') {
				$result = $this->Employees_model->security_info_rejected($e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_security_info_rejected');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('security_save_status') == 'approved') {
				$result = $this->Employees_model->security_info_approved($data, $e_field_id);
				if ($result == TRUE) {
					$Return['result'] = $this->lang->line('xin_security_level_emp_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$result = $this->Employees_model->security_info_approved($data, $e_field_id);
					if ($result == TRUE) {
						$Return['result'] = $this->lang->line('xin_security_level_emp_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} else {
					$result = $this->Employees_model->security_level_info_update($data, $e_field_id);
					if ($result == TRUE) {
						$Return['result'] = $this->lang->line('xin_security_level_emp_updated');
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				}
			}

			$this->output($Return);

			exit;
		}
	}

	// delete security level record

	public function delete_security_level()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_security_level_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_security_level_emp_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	// Validate and add info in database // ebank account info

	public function e_bank_account_info_validate()
	{

		if ($this->input->post('type') == 'e_bank_account_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('account_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_title');
			} else if ($this->input->post('account_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
			} else if ($this->input->post('bank_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_name');
			} else if ($this->input->post('bank_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_code');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$Return['error'] = '';
			$this->output($Return);

			exit;
		}
	}

	public function e_bank_account_info()
	{

		if ($this->input->post('type') == 'e_bank_account_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('account_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_title');
			} else if ($this->input->post('account_number') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_acc_number');
			} else if ($this->input->post('bank_name') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_name');
			} else if ($this->input->post('bank_code') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_bank_code');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$data = array(

				'account_title' => $this->input->post('account_title'),

				'account_number' => $this->input->post('account_number'),

				'bank_name' => $this->input->post('bank_name'),

				'bank_code' => $this->input->post('bank_code'),

				'bank_branch' => $this->input->post('bank_branch')

			);

			$e_field_id = $this->input->post('e_field_id');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);

			if ($this->input->post('save_cont_status') == 'pending') {
				$result = $this->Employees_model->bank_account_info_update($data, $e_field_id);

				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_error_bank_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_cont_status') == 'rejected') {
				$result = $this->Employees_model->bank_info_rejected($e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_bank_info_rejected');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_cont_status') == 'approved') {
				$result = $this->Employees_model->bank_info_approved($data, $e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_error_bank_info_updated');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$result = $this->Employees_model->bank_info_approved($data, $e_field_id);
					if ($result == TRUE) {

						$Return['result'] = $this->lang->line('xin_employee_error_bank_info_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} else {
					$result = $this->Employees_model->bank_account_info_update($data, $e_field_id);

					if ($result == TRUE) {

						$Return['result'] = $this->lang->line('xin_employee_error_bank_info_updated');
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				}
			}
			$this->output($Return);

			exit;
		}
	}


	// Validate and add info in database //contract info

	public function contract_info_validate()
	{

		if ($this->input->post('type') == 'contract_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			if ($_FILES['document_file_contract']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file_contract']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file_contract']['name'];


					$ext = pathinfo($filename, PATHINFO_EXTENSION);


					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file_contract"]["tmp_name"];

						$documentd = "uploads/document/visa/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file_contract"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}


			/* Server side PHP input validation */

			if ($this->input->post('contract_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_type');
			} else if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_title');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_to_date');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function contract_info()
	{



		if ($this->input->post('type') == 'contract_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {


				$fname = '';
			} else {

				$fname = $this->input->post('attachment');
			}



			/* Server side PHP input validation */

			if ($this->input->post('contract_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_type');
			} else if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_title');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_to_date');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'contract_type_id' => $this->input->post('contract_type_id'),

				'title' => $this->input->post('title'),

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date'),

				'designation_id' => $this->input->post('designation_id'),

				'description' => $this->input->post('description'),

				'file'  => $fname,

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->contract_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_contract_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database //e contract info

	public function e_contract_info_validate()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		$frm_date = strtotime($this->input->post('from_date'));

		$to_date = strtotime($this->input->post('to_date'));

		/* Server side PHP input validation */

		if ($this->input->post('contract_type_id') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_contract_type');
		} else if ($this->input->post('title') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_contract_title');
		} else if ($this->input->post('from_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
		} else if ($this->input->post('to_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_to_date');
		} else if ($frm_date > $to_date) {

			$Return['error'] = $this->lang->line('xin_employee_error_frm_to_date');
		} else if ($this->input->post('designation_id') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_designation');
		}



		if ($Return['error'] != '') {

			$this->output($Return);
		} else {

			if ($_FILES['document_file_contract']['size'] != 0) {

				if (is_uploaded_file($_FILES['document_file_contract']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file_contract']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file_contract"]["tmp_name"];

						$documentd = "uploads/document/visa/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file_contract"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					}
				}
			}
			$Return['error'] = '';
		}

		$this->output($Return);

		exit;
	}

	public function e_contract_info()
	{



		if ($this->input->post('type') == 'e_contract_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			$frm_date = strtotime($this->input->post('from_date'));

			$to_date = strtotime($this->input->post('to_date'));

			/* Server side PHP input validation */

			if ($this->input->post('contract_type_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_type');
			} else if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_title');
			} else if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('to_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_to_date');
			} else if ($frm_date > $to_date) {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_to_date');
			} else if ($this->input->post('designation_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_designation');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}


			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(

					'contract_type_id' => $this->input->post('contract_type_id'),

					'title' => $this->input->post('title'),

					'from_date' => $this->input->post('from_date'),

					'to_date' => $this->input->post('to_date'),

					'designation_id' => $this->input->post('designation_id'),

					'description' => $this->input->post('description'),

					'update_value' => $update_value
				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'contract_type_id' => $this->input->post('contract_type_id'),

					'title' => $this->input->post('title'),

					'from_date' => $this->input->post('from_date'),

					'to_date' => $this->input->post('to_date'),

					'designation_id' => $this->input->post('designation_id'),

					'description' => $this->input->post('description')
				);

				$arr = serialize($data1);
				$data = array(
					'update_value' => $arr
				);
			}

			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$data = array(

					'contract_type_id' => $this->input->post('contract_type_id'),

					'title' => $this->input->post('title'),

					'from_date' => $this->input->post('from_date'),

					'to_date' => $this->input->post('to_date'),

					'designation_id' => $this->input->post('designation_id'),

					'description' => $this->input->post('description')

				);
			} else {
				$fname = $this->input->post('attachment');

				$data = array(

					'contract_type_id' => $this->input->post('contract_type_id'),

					'title' => $this->input->post('title'),

					'from_date' => $this->input->post('from_date'),

					'to_date' => $this->input->post('to_date'),

					'designation_id' => $this->input->post('designation_id'),

					'description' => $this->input->post('description'),

					'file' => $fname

				);
			}

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->contract_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_contract_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database //leave_info

	public function leave_info()
	{



		if ($this->input->post('type') == 'leave_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('contract_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_contract_f');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'contract_id' => $this->input->post('contract_id'),

				'casual_leave' => $this->input->post('casual_leave'),

				'medical_leave' => $this->input->post('medical_leave'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->leave_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_leave_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database //Eleave_info

	public function e_leave_info()
	{
		if ($this->input->post('type') == 'e_leave_info') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$data = array(
				'casual_leave' => $this->input->post('casual_leave'),
				'medical_leave' => $this->input->post('medical_leave')

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->leave_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_leave_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database // shift info

	public function shift_info()
	{



		if ($this->input->post('type') == 'shift_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('shift_id') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_shift_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date'),

				'shift_id' => $this->input->post('shift_id'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->shift_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_shift_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database // eshift info

	public function e_shift_info()
	{



		if ($this->input->post('type') == 'e_shift_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			}



			$data = array(

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date')

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->shift_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_shift_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database // location info

	public function location_info()
	{



		if ($this->input->post('type') == 'location_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('location_id') === '') {

				$Return['error'] = $this->lang->line('error_location_dept_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date'),

				'location_id' => $this->input->post('location_id'),

				'employee_id' => $this->input->post('user_id'),

				'created_at' => date('d-m-Y'),

			);

			$result = $this->Employees_model->location_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_location_info_added');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database // elocation info

	public function e_location_info()
	{



		if ($this->input->post('type') == 'e_location_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('from_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_frm_date');
			} else if ($this->input->post('location_id') === '') {

				$Return['error'] = $this->lang->line('error_location_dept_field');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'from_date' => $this->input->post('from_date'),

				'to_date' => $this->input->post('to_date')

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->location_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_location_info_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and add info in database // update_allowance_info

	public function update_allowance_info_validate()
	{

		if ($this->input->post('type') == 'e_allowance_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('allowance_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_title_error');
			} else if ($this->input->post('allowance_amount') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_amount_error');
			} else if ($this->input->post('allowance_amount') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function update_allowance_info()
	{



		if ($this->input->post('type') == 'e_allowance_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('allowance_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_title_error');
			} else if ($this->input->post('allowance_amount') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_amount_error');
			} else if ($this->input->post('allowance_amount') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'allowance_title' => $this->input->post('allowance_title'),

				'allowance_amount' => $this->input->post('allowance_amount'),

				'is_allowance_taxable' => $this->input->post('is_allowance_taxable'),

				'amount_option' => $this->input->post('amount_option'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary')

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->salary_allowance_update_record($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_updated_allowance_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database //

	public function update_commissions_info_validate()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();


		/* Server side PHP input validation */

		if ($this->input->post('title') === '') {

			$Return['error'] = $this->lang->line('xin_error_title');
		} else if ($this->input->post('amount') === '') {

			$Return['error'] = $this->lang->line('xin_error_amount_field');
		} else if ($this->input->post('amount') < 0) {

			$Return['error'] = 'Negative value is not allowed';
		}


		if ($Return['error'] != '') {

			$this->output($Return);
		}

		$this->output($Return);

		exit;
	}

	public function update_commissions_info()
	{



		if ($this->input->post('type') == 'e_salary_commissions_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'commission_title' => $this->input->post('title'),

				'commission_amount' => $this->input->post('amount'),

				'is_commission_taxable' => $this->input->post('is_commission_taxable'),

				'amount_option' => $this->input->post('amount_option'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary_commission')

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->salary_commissions_update_record($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_update_commission_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database //

	public function update_statutory_deductions_info()
	{



		if ($this->input->post('type') == 'e_salary_statutory_deductions_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'deduction_title' => $this->input->post('title'),

				'deduction_amount' => $this->input->post('amount'),

				'statutory_options' => $this->input->post('statutory_options'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary_deductions'),

				//'amount_option' => $this->input->post('amount_option')

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->salary_statutory_deduction_update_record($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_update_statutory_deduction_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and add info in database //

	public function update_other_payment_info_validate()
	{

		if ($this->input->post('type') == 'e_salary_other_payments_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}


			if ($Return['error'] != '') {

				$this->output($Return);
			}


			$this->output($Return);

			exit;
		}
	}

	public function update_other_payment_info()
	{



		if ($this->input->post('type') == 'e_salary_other_payments_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'payments_title' => $this->input->post('title'),

				'payments_amount' => $this->input->post('amount'),

				'is_otherpayment_taxable' => $this->input->post('is_otherpayment_taxable'),

				'amount_option' => $this->input->post('amount_option'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary_deductions'),

			);

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->salary_other_payment_update_record($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_update_otherpayments_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update info in database // change password

	public function change_password_validate()
	{


		if ($this->input->post('type') == 'change_password') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			/*if (trim($this->input->post('old_password')) === '') {

				$Return['error'] = $this->lang->line('xin_old_password_error_field');
			} else if ($this->Employees_model->check_old_password($this->input->post('old_password'), $this->input->post('user_id')) != 1) {

				$Return['error'] = $this->lang->line('xin_old_password_does_not_match');
			} else */
			if (trim($this->input->post('new_password')) === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_newpassword');
			} else if (strlen($this->input->post('new_password')) < 6) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_least');
			} else if (trim($this->input->post('new_password_confirm')) === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_new_cpassword');
			} else if ($this->input->post('new_password') != $this->input->post('new_password_confirm')) {

				$Return['error'] = $this->lang->line('xin_employee_error_old_new_cpassword');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function change_password()
	{



		if ($this->input->post('type') == 'change_password') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			/*if (trim($this->input->post('old_password')) === '') {

				$Return['error'] = $this->lang->line('xin_old_password_error_field');
			} else if ($this->Employees_model->check_old_password($this->input->post('old_password'), $this->input->post('user_id')) != 1) {

				$Return['error'] = $this->lang->line('xin_old_password_does_not_match');
			} else */
			if (trim($this->input->post('new_password')) === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_newpassword');
			} else if (strlen($this->input->post('new_password')) < 6) {

				$Return['error'] = $this->lang->line('xin_employee_error_password_least');
			} else if (trim($this->input->post('new_password_confirm')) === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_new_cpassword');
			} else if ($this->input->post('new_password') != $this->input->post('new_password_confirm')) {

				$Return['error'] = $this->lang->line('xin_employee_error_old_new_cpassword');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$options = array('cost' => 12);

			$password_hash = password_hash($this->input->post('new_password'), PASSWORD_BCRYPT, $options);



			$data = array(

				'password' => $password_hash

			);

			$id = $this->input->post('user_id');

			$result = $this->Employees_model->change_password($data, $id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_password_update');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	/*  get all employee details lisitng */ /////////////////



	public function security_level_list()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$security_level = $this->Employees_model->set_employee_security_level($id);



		$data = array();



		foreach ($security_level->result() as $r) {

			$security_type = $this->Xin_model->read_security_level($r->security_type);

			if (!is_null($security_type)) {

				$sc_type = $security_type[0]->name;
			} else {

				$sc_type = '--';
			}
			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$sc_type,

				$r->expiry_date,

				$r->date_of_clearance,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->security_level_id . '" data-field_type="security_level"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->security_level_id . '" data-token_type="security_level"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $security_level->num_rows(),

			"recordsFiltered" => $security_level->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee contacts - listing

	public function contacts()

	{

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);
		//  $uri = $_SERVER['REQUEST_URI'];
		// echo $uri;
		// exit;
		$contacts = $this->Employees_model->set_employee_contacts($id);



		$data = array();



		foreach ($contacts->result() as $r) {



			if ($r->is_primary == 1) {

				$primary = '<span class="tag tag-success">' . $this->lang->line('xin_employee_primary') . '</span><br/>';
			} else {

				$primary = '';
			}

			if ($r->is_dependent == 2) {

				$dependent = '<span class="tag tag-danger">' . $this->lang->line('xin_employee_dependent') . '</span>';
			} else {

				$dependent = '';
			}


			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			if (in_array('954', $role_resources_ids)) {

				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->contact_id . '" data-field_type="contact"><i class="fas fa-pencil-alt"></i></button></span>';
			} else {

				$edit = '';
			}
			if (in_array('955', $role_resources_ids)) {

				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->contact_id . '" data-token_type="contact"><i class="fas fa-trash-restore"></i></button></span>';
			} else {

				$delete = '';
			}
			$function = $edit . $delete;
			if (in_array('955', $role_resources_ids) || in_array('954', $role_resources_ids)) {
				$data[] = array(


					$r->contact_name,

					$primary . '  ' . $dependent,

					$r->relation,

					$r->work_email,

					$r->mobile_phone,

					$function,

					$style

				);
			} else {
				$data[] = array(


					$r->contact_name,

					$primary . '  ' . $dependent,

					$r->relation,

					$r->work_email,

					$r->mobile_phone,

					$style

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $contacts->num_rows(),

			"recordsFiltered" => $contacts->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function contacts_view()

	{



		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$contacts = $this->Employees_model->set_employee_contacts($id);



		$data = array();



		foreach ($contacts->result() as $r) {



			if ($r->is_primary == 1) {

				$primary = '<span class="tag tag-success">' . $this->lang->line('xin_employee_primary') . '</span><br/>';
			} else {

				$primary = '';
			}

			if ($r->is_dependent == 2) {

				$dependent = '<span class="tag tag-danger">' . $this->lang->line('xin_employee_dependent') . '</span>';
			} else {

				$dependent = '';
			}


			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$r->contact_name,
				$primary . '  ' . $dependent,

				$r->relation,

				$r->work_email,

				$r->mobile_phone,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->contact_id . '" data-field_type="contact_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->contact_id . '" data-token_type="contact"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $contacts->num_rows(),

			"recordsFiltered" => $contacts->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}


	// employee documents - listing

	public function documents()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$documents = $this->Employees_model->set_employee_documents($id);



		$data = array();



		foreach ($documents->result() as $r) {



			$d_type = $this->Employees_model->read_document_type_information($r->document_type_id);

			if (!is_null($d_type)) {

				$document_d = $d_type[0]->document_type;
			} else {

				$document_d = '--';
			}

			if ($r->date_of_expiry == '') {

				$date_of_expiry = '';
			} else {

				$date_of_expiry = $this->Xin_model->set_date_format($r->date_of_expiry);
			}

			if ($r->document_file != '' && $r->document_file != 'no file' && in_array('959', $role_resources_ids)) {

				$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document&filename=' . $r->document_file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
			} else {

				$functions = '';
			}




			/*if($r->is_alert==1){

			 	$alert = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_e_details_alert_notifyemail').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><i class="fa fa-bell"></i></button></span>';

			 } else {

				 $alert = '';

			 }*/
			if ($r->serialized != '' && $r->serialized != 'null' && $r->serialized != 'NULL' && $r->serialized != NULL && $r->serialized != null) {
				$color = 'style="color:red"';
				$style = "red";
			} else {
				$color = 'style="color:green"';
				$style = "";
			}
			if (in_array('957', $role_resources_ids)) {

				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->document_id . '" data-field_type="document"><i class="fas fa-pencil-alt"></i></button></span>';
			} else {

				$edit = '';
			}
			if (in_array('958', $role_resources_ids)) {

				$delete = '	<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->document_id . '" data-token_type="document"><i class="fas fa-trash-restore"></i></button></span>';
			} else {

				$delete = '';
			}
			$action = $edit . $delete . $functions;

			if (in_array('957', $role_resources_ids) || in_array('958', $role_resources_ids) || in_array('959', $role_resources_ids)) {
				$data[] = array(


					$document_d,

					$r->title,

					$date_of_expiry,

					$action,

					$style

				);
			} else {
				$data[] = array(


					$document_d,

					$r->title,

					$date_of_expiry,

					$style

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $documents->num_rows(),

			"recordsFiltered" => $documents->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee immigration - listing

	public function immigration()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$immigration = $this->Employees_model->set_employee_immigration($id);



		$data = array();



		foreach ($immigration->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);

			$eligible_review_date = $this->Xin_model->set_date_format($r->eligible_review_date);

			$d_type = $this->Employees_model->read_document_type_information($r->document_type_id);

			if (!is_null($d_type)) {

				$document_d = $d_type[0]->document_type . '<br>' . $r->document_number;
			} else {

				$document_d = $r->document_number;
			}

			$country = $this->Xin_model->read_country_info($r->country_id);

			if (!is_null($country)) {

				$c_name = $country[0]->country_name;
			} else {

				$c_name = '--';
			}
			if ($r->serialized != '' && $r->serialized != 'null' && $r->serialized != 'NULL' && $r->serialized != NULL && $r->serialized != null) {
				$color = 'style="color:red"';
				$style = "red";
			} else {
				$color = 'style="color:green"';
				$style = "";
			}
			if (in_array('951', $role_resources_ids)) {

				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->immigration_id . '" data-field_type="imgdocument"><i class="fas fa-pencil-alt"></i></button></span>';
			} else {

				$edit = '';
			}
			if (in_array('952', $role_resources_ids)) {

				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->immigration_id . '" data-token_type="imgdocument"><i class="fas fa-trash-restore"></i></button></span>';
			} else {

				$delete = '';
			}
			$function = $edit . $delete;
			if (in_array('951', $role_resources_ids) || in_array('952', $role_resources_ids)) {
				$data[] = array(


					$document_d,

					$issue_date,

					$expiry_date,

					$c_name,

					$eligible_review_date,

					$function,

					$style,


				);
			} else {
				$data[] = array(


					$document_d,

					$issue_date,

					$expiry_date,

					$c_name,

					$eligible_review_date,

					$style,


				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $immigration->num_rows(),

			"recordsFiltered" => $immigration->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee qualification - listing

	public function qualification()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$qualification = $this->Employees_model->set_employee_qualification($id);



		$data = array();



		foreach ($qualification->result() as $r) {



			$education = $this->Employees_model->read_education_information($r->education_level_id);

			if (!is_null($education)) {

				$edu_name = $education[0]->name;
			} else {

				$edu_name = '--';
			}

			//	$language = $this->Employees_model->read_qualification_language_information($r->language_id);



			/*if($r->skill_id == 'no course') {

				$ol = 'No Course';

			} else {

				$ol = '<ol class="nl">';

				foreach(explode(',',$r->skill_id) as $desig_id) {

					$skill = $this->Employees_model->read_qualification_skill_information($desig_id);

					$ol .= '<li>'.$skill[0]->name.'</li>';

				 }

				 $ol .= '</ol>';

			}*/

			$sdate = $this->Xin_model->set_date_format($r->from_year);

			$edate = $this->Xin_model->set_date_format($r->to_year);



			$time_period = $sdate . ' - ' . $edate;

			// get date

			$pdate = $time_period;
			if ($r->serialized != '' && $r->serialized != 'null' && $r->serialized != 'NULL' && $r->serialized != NULL && $r->serialized != null) {
				$color = 'color:red';
				$style = 'red';
			} else {
				$color = 'color:green';
				$style = '';
			}

			$data[] = array(


				$r->name,

				$pdate,

				$edu_name,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->qualification_id . '" data-field_type="qualification"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->qualification_id . '" data-token_type="qualification"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $qualification->num_rows(),

			"recordsFiltered" => $qualification->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee work experience - listing

	public function experience()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$experience = $this->Employees_model->set_employee_experience($id);



		$data = array();



		foreach ($experience->result() as $r) {



			$from_date = $this->Xin_model->set_date_format($r->from_date);

			$to_date = $this->Xin_model->set_date_format($r->to_date);




			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$r->company_name,

				$from_date,

				$to_date,

				$r->post,

				$r->description,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->work_experience_id . '" data-field_type="work_experience"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->work_experience_id . '" data-token_type="work_experience"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $experience->num_rows(),

			"recordsFiltered" => $experience->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee bank account - listing

	public function bank_account()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$bank_account = $this->Employees_model->set_employee_bank_account($id);



		$data = array();



		foreach ($bank_account->result() as $r) {


			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$r->account_title,

				$r->account_number,

				$r->bank_name,

				$r->bank_code,

				$r->bank_branch,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->bankaccount_id . '" data-field_type="bank_account"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->bankaccount_id . '" data-token_type="bank_account"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $bank_account->num_rows(),

			"recordsFiltered" => $bank_account->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee contract - listing

	public function contract()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$contract = $this->Employees_model->set_employee_contract($id);



		$data = array();



		foreach ($contract->result() as $r) {

			// designation

			$designation = $this->Designation_model->read_designation_information($r->designation_id);

			if (!is_null($designation)) {

				$designation_name = $designation[0]->designation_name;
			} else {

				$designation_name = '--';
			}

			//contract type
			$update_value = $r->update_value;
			$contract_type = $this->Employees_model->read_contract_type_information($r->contract_type_id);

			if (!is_null($contract_type)) {

				$ctype = $contract_type[0]->name;
			} else {

				$ctype = '--';
			}

			// date

			$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);


			if ($update_value) {
				$data[] = array(


					$duration,

					$designation_name,

					$ctype,

					$r->title,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->contract_id . '" data-field_type="contract">
				<i class="fas fa-pencil-alt" style="
    /* background-color: red; */
    /* border: solid 2px;
     /*padding: 3px;
     /*border-radius: 8px;
    /* border: 9px; */
/*    color: red; */
"></i>
				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->contract_id . '" data-token_type="contract">
				<i class="fas fa-trash-restore"></i></button></span>',

				);
			} else {
				$data[] = array(


					$duration,

					$designation_name,

					$ctype,

					$r->title,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->contract_id . '" data-field_type="contract">
				<i class="fas fa-pencil-alt" style="
    /* background-color: red; */
    /* border: solid 2px;
     /*padding: 3px;
     /*border-radius: 8px;
    /* border: 9px; */
    /* color: green; */
"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->contract_id . '" data-token_type="contract">
				<i class="fas fa-trash-restore"></i></button></span>',

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $contract->num_rows(),

			"recordsFiltered" => $contract->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee leave - listing

	public function leave()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$leave = $this->Timesheet_model->get_leave_employees($id);



		$data = array();

		foreach ($leave->result() as $r) {

			// contract

			$data[] = array(

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '" data-field_type="leave"><i class="fas fa-pencil-alt"></i></button></span>',

				$contracti,

				$r->type_name,

				$r->leave_count

			);
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $leave->num_rows(),

			"recordsFiltered" => $leave->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	/*public function leave() {

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if(!empty($session)){ 

			$this->load->view("admin/employees/employee_detail", $data);

		} else {

			redirect('admin/');

		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		

		$id = $this->uri->segment(4);

		$leave = $this->Employees_model->set_employee_leave($id);

		

		$data = array();



        foreach($leave->result() as $r) {			

			

			

			

			// contract

			$contract = $this->Employees_model->read_contract_information($r->contract_id);

			if(!is_null($contract)){

				// contract duration

			$duration = $this->Xin_model->set_date_format($contract[0]->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($contract[0]->to_date);

				$ctitle = $contract[0]->title.' '.$duration;

			} else {

				$ctitle = '--';

			}

			

			$contracti = $ctitle;

		

		$data[] = array(

			'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->leave_id . '" data-field_type="leave"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->leave_id . '" data-token_type="leave"><i class="fas fa-trash-restore"></i></button></span>',

			$contracti,

			$r->casual_leave,

			$r->medical_leave

		);

      }



	  $output = array(

		   "draw" => $draw,

			 "recordsTotal" => $leave->num_rows(),

			 "recordsFiltered" => $leave->num_rows(),

			 "data" => $data

		);

	  echo json_encode($output);

	  exit();

     }*/



	// employee office shift - listing

	public function shift()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$shift = $this->Employees_model->set_employee_shift($id);



		$data = array();



		foreach ($shift->result() as $r) {

			// contract

			$shift_info = $this->Employees_model->read_shift_information($r->shift_id);

			// contract duration

			$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);



			if (!is_null($shift_info)) {

				$shift_name = $shift_info[0]->shift_name;
			} else {

				$shift_name = '--';
			}



			$data[] = array(

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->emp_shift_id . '" data-field_type="shift"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->emp_shift_id . '" data-token_type="shift"><i class="fas fa-trash-restore"></i></button></span>',

				$duration,

				$shift_name

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $shift->num_rows(),

			"recordsFiltered" => $shift->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee location - listing

	public function location()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$location = $this->Employees_model->set_employee_location($id);



		$data = array();



		foreach ($location->result() as $r) {

			// contract

			$of_location = $this->Location_model->read_location_information($r->location_id);

			// contract duration

			$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);

			if (!is_null($of_location)) {

				$location_name = $of_location[0]->location_name;
			} else {

				$location_name = '--';
			}



			$data[] = array(

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->office_location_id . '" data-field_type="location"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->office_location_id . '" data-token_type="location"><i class="fas fa-trash-restore"></i></button></span>',

				$duration,

				$location_name

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $location->num_rows(),

			"recordsFiltered" => $location->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// Validate and update info in database

	public function update()
	{



		if ($this->input->post('edit_type') == 'warning') {



			$id = $this->uri->segment(4);



			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			$description = $this->input->post('description');

			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);



			if ($this->input->post('warning_to') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_warning');
			} else if ($this->input->post('type') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_warning_type');
			} else if ($this->input->post('subject') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_subject');
			} else if ($this->input->post('warning_by') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_warning_by');
			} else if ($this->input->post('warning_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_warning_date');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'warning_to' => $this->input->post('warning_to'),

				'warning_type_id' => $this->input->post('type'),

				'description' => $qt_description,

				'subject' => $this->input->post('subject'),

				'warning_by' => $this->input->post('warning_by'),

				'warning_date' => $this->input->post('warning_date'),

				'status' => $this->input->post('status'),

			);



			$result = $this->Warning_model->update_record($data, $id);



			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_warning_updated');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// import > employees

	public function import()

	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_import_employees') . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = $this->lang->line('xin_import_employees');

		$data['path_url'] = 'import_employees';

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_office_shifts'] = $this->Employees_model->all_office_shifts();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('92', $role_resources_ids)) {

			if (!empty($session)) {

				$data['subview'] = $this->load->view("admin/employees/employes_import", $data, TRUE);

				$this->load->view('admin/layout/layout_main', $data); //page load

			} else {

				redirect('admin/');
			}
		} else {

			redirect('admin/dashboard');
		}
	}







	// delete contact record

	public function delete_contact()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_contact_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_contact_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete document record

	public function delete_document()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$id = $this->uri->segment(4);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$result = $this->Employees_model->delete_document_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_document_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete document record

	public function delete_imgdocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_imgdocument_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_img_document_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete qualification record

	public function delete_qualification()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_qualification_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_qualification_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete work_experience record

	public function delete_work_experience()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_work_experience_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_work_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete bank_account record

	public function delete_bank_account()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_bank_account_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_bankaccount_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete contract record

	public function delete_contract()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_contract_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_contract_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete leave record

	public function delete_leave()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_leave_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_leave_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete shift record

	public function delete_shift()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_shift_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_shift_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete location record

	public function delete_location()
	{


		if ($this->input->post('data') == 'delete_record') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$id = $this->uri->segment(4);
			$result = $this->Employees_model->delete_location_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_employee_location_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}



	// delete employee record

	public function delete()
	{



		if ($this->input->post('is_ajax') == '2') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_current_deleted');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// Validate and update info in database // basic info

	public function update_salary_option_validate()
	{

		if ($this->input->post('type') == 'employee_update_salary') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('basic_salary') === '') {

				$Return['error'] = $this->lang->line('xin_employee_salary_error_basic');
			} else if ($this->input->post('basic_salary') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function update_salary_option()
	{

		if ($this->input->post('type') == 'employee_update_salary') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('basic_salary') === '') {

				$Return['error'] = $this->lang->line('xin_employee_salary_error_basic');
			} else if ($this->input->post('basic_salary') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'wages_type' => $this->input->post('wages_type'),

				'basic_salary' => $this->input->post('basic_salary')

			);

			$id = $this->input->post('user_id');

			$result = $this->Employees_model->basic_info($data, $id);

			if ($result == TRUE) {

				$Return['basic_salary'] = $this->input->post('basic_salary');

				$Return['result'] = $this->lang->line('xin_employee_updated_salary_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function update_salary_option_history_validate()
	{

		if ($this->input->post('type') == 'employee_update_salary_his') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('basic_salary_his') === '') {

				$Return['error'] = $this->lang->line('xin_employee_salary_error_basic');
			} else if ($this->input->post('basic_salary_his') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}

			$inc_or_dec = '';

			$id = $this->input->post('user_id');

			$current_basic_pay = $this->input->post('current_basic_pay');

			$inc_basic_pay = $this->input->post('basic_salary_his');

			$diff = $inc_basic_pay - $current_basic_pay;

			if ($current_basic_pay == $inc_basic_pay) {

				$Return['error'] = 'No difference in salary..';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$this->output($Return);

			exit;
		}
	}

	public function update_salary_option_history()
	{

		if ($this->input->post('type') == 'employee_update_salary_his') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('basic_salary_his') === '') {

				$Return['error'] = $this->lang->line('xin_employee_salary_error_basic');
			} else if ($this->input->post('basic_salary_his') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}

			$inc_or_dec = '';

			$id = $this->input->post('user_id');

			$current_basic_pay = $this->input->post('current_basic_pay');

			$inc_basic_pay = $this->input->post('basic_salary_his');

			$diff = $inc_basic_pay - $current_basic_pay;

			if ($current_basic_pay == $inc_basic_pay) {

				$Return['error'] = 'No difference in salary..';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			if ($diff > 0 && $inc_basic_pay > $current_basic_pay) {
				$inc_or_dec = 'inc';

				$inc_amt = abs($diff);
				$in_perce = ($inc_amt * 100) / $current_basic_pay;
			} else {
				$inc_amt = abs($diff);
				$in_perce = ($inc_amt * 100) / $current_basic_pay;
				$inc_or_dec = 'dec';
			}

			$commissions = $this->Employees_model->set_employee_sal_history($id, 1);

			if ($commissions->result()) {
				$data = array(
					//'wages_type' => $this->input->post('wages_type_his'),
					'amount' => $this->input->post('basic_salary_his'),
					'date' => date('Y-m-d'),
					'employee_id' => $id,
					'inc_amt' => $inc_amt,
					'inc_or_dec' => $inc_or_dec,
					'inc_percentage' => $in_perce,
					'history_type' => 1
				);

				$result = $this->Employees_model->emp_salary_inc_history($data);
			} else {
				$emp_info =  $this->Employees_model->read_employee_information($id);
				$normal_basic =	$emp_info[0]->basic_salary;
				if ($current_basic_pay == $normal_basic) {
					$data = array(
						'amount' => $current_basic_pay,
						'date' => date('Y-m-d', strtotime($emp_info[0]->created_at)),
						'employee_id' => $id,
						'inc_amt' => 0,
						'inc_or_dec' => 0,
						'history_type' => 1,
						'inc_percentage' => $in_perce,

					);
				} else {
					$data = array(
						'amount' => $current_basic_pay,
						'date' => date('Y-m-d'),
						'employee_id' => $id,
						'inc_amt' => 0,
						'inc_or_dec' => 0,
						'history_type' => 1,
						'inc_percentage' => $in_perce,
					);
				}



				$result = $this->Employees_model->emp_salary_inc_history($data);

				$data = array(

					//'wages_type' => $this->input->post('wages_type_his'),

					'amount' => $this->input->post('basic_salary_his'),
					'date' => date('Y-m-d'),
					'employee_id' => $id,
					'inc_amt' => $inc_amt,
					'inc_or_dec' => $inc_or_dec,
					'inc_percentage' => $in_perce,
					'history_type' => 1

				);

				$result = $this->Employees_model->emp_salary_inc_history($data);
			}



			if ($result == TRUE) {

				$data_basic = array(

					//'wages_type' => $this->input->post('wages_type_his'),

					'basic_salary' => $this->input->post('basic_salary_his')

				);

				$result = $this->Employees_model->basic_info($data_basic, $id);

				$Return['basic_salary'] = $this->input->post('basic_salary_his');

				$Return['result'] = $this->lang->line('xin_employee_updated_salary_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function salary_all_history()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_sal_history($id, 1);



		$data = array();

		$emp_info =  $this->Employees_model->read_employee_information($id);

		if ($emp_info) {

			if ($commissions->result()) {

				foreach ($commissions->result() as $r) {

					/*if($r->wages_type==1){

					$wages_type = $this->lang->line('xin_payroll_basic_salary');

				} else if($r->wages_type==2){

					$wages_type = $this->lang->line('xin_employee_daily_wages');

				}*/

					if ($r->inc_or_dec == 'inc') {

						//	$inc_or_dec = $r->inc_amt.' incremented';
						$inc_or_dec = round($r->inc_percentage, 3) . '% incremented';
					} else if ($r->inc_or_dec == 'dec') {

						$inc_or_dec = round($r->inc_percentage, 3) . '% decremented';
					}

					//<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span>



					$data[] = array(


						//$wages_type,

						$r->amount,

						date('Y-m-d', strtotime($r->date)),

						($r->inc_amt == 0 && $r->inc_or_dec == 0) ? 'First basic pay' : $inc_or_dec,

						'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="emp_salary_his"><span class="fas fa-trash-restore"></span></button></span>',


					);
				}
			} else {

				$data[] = array(



					//$wages_type,

					$emp_info[0]->basic_salary,

					date('Y-m-d', strtotime($emp_info[0]->created_at)),

					'Basic Salary',

					'#',

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function delete_emp_allowance_history()
	{

		$temp = $this->uri->segment(5);

		if ($temp == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);
			$get_emp_informations = $this->Employees_model->read_employee_his_info_by_id($id);
			if (!empty($get_emp_informations)) {
				$emp_info = $this->Employees_model->read_emp($get_emp_informations[0]->employee_id);
				if (!empty($emp_info)) {
					if ($get_emp_informations[0]->history_type == 2) {
						$emp_allowance_det = $this->Employees_model->read_single_salary_allowance($get_emp_informations[0]->allowance_id);
						$prev_allowance_amt = $emp_allowance_det[0]->allowance_amount;
						if ($get_emp_informations[0]->inc_or_dec == 'inc') {
							$emp_allowance_changes = $prev_allowance_amt - $get_emp_informations[0]->inc_amt;
						} else {
							$emp_allowance_changes = $prev_allowance_amt + $get_emp_informations[0]->inc_amt;
						}
						$data = array('allowance_amount' => $emp_allowance_changes);
						$update_chaanges = $this->Employees_model->salary_allowance_update_record($data, $get_emp_informations[0]->allowance_id);
					}
				}
			}
			$result = $this->Employees_model->delete_emp_salary_history($id);

			if (isset($id)) {

				$Return['result'] = 'Deleted';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	public function delete_emp_deduction_history()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);
			$get_emp_informations = $this->Employees_model->read_employee_his_info_by_id($id);
			if (!empty($get_emp_informations)) {
				$emp_info = $this->Employees_model->read_emp($get_emp_informations[0]->employee_id);
				if (!empty($emp_info)) {
					if ($get_emp_informations[0]->history_type == 3) {
						$emp_allowance_det = $this->Employees_model->read_single_salary_statutory_deduction($get_emp_informations[0]->allowance_id);
						$prev_allowance_amt = $emp_allowance_det[0]->deduction_amount;
						if ($get_emp_informations[0]->inc_or_dec == 'inc') {
							$emp_allowance_changes = $prev_allowance_amt - $get_emp_informations[0]->inc_amt;
						} else {
							$emp_allowance_changes = $prev_allowance_amt + $get_emp_informations[0]->inc_amt;
						}
						$data = array('deduction_amount' => $emp_allowance_changes);
						$update_chaanges = $this->Employees_model->salary_statutory_deduction_update_record($data, $get_emp_informations[0]->allowance_id);
					}
				}
			}
			$result = $this->Employees_model->delete_emp_salary_history($id);

			if (isset($id)) {

				$Return['result'] = 'Deleted';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	public function delete_emp_salary_his()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);
			$get_emp_informations = $this->Employees_model->read_employee_his_info_by_id($id);
			if (!empty($get_emp_informations)) {
				$emp_info = $this->Employees_model->read_emp($get_emp_informations[0]->employee_id);
				if (!empty($emp_info)) {
					if ($get_emp_informations[0]->history_type == 1) {
						$emp_basic_pay = $emp_info[0]->basic_salary;
						if ($get_emp_informations[0]->inc_or_dec == 'inc') {
							$emp_basic_pay_changes = $emp_basic_pay - $get_emp_informations[0]->inc_amt;
						} else {
							$emp_basic_pay_changes = $emp_basic_pay + $get_emp_informations[0]->inc_amt;
						}
						$data = array('basic_salary' => $emp_basic_pay_changes);
						$update_emp_info = $this->Employees_model->update_record($data, $get_emp_informations[0]->employee_id);
					}
				}

				//print_r($emp_basic_pay_changes);exit;

			}
			//	print_r($get_emp_informations);exit;

			$result = $this->Employees_model->delete_emp_salary_history($id);

			if (isset($id)) {

				$Return['result'] = 'Deleted';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	public function get_employee_allowance_amount()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = $this->Employees_model->read_single_salary_allowance($id);

		$drp = '';

		if ($data[0]->amount_option == 0) {

			$drp = '<option value="0" selected>' . $this->lang->line('xin_title_tax_fixed') . '</option><option value="1" >' . $this->lang->line('xin_title_tax_percent') . '</option>';
		} else {

			$drp = '<option value="0">' . $this->lang->line('xin_title_tax_fixed') . '</option><option value="1" selected>' . $this->lang->line('xin_title_tax_percent') . '</option>';
		}



		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$output = array(

				"amount" => $data[0]->allowance_amount,

				"drp" => $drp

			);

			echo json_encode($output);

			exit();
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	public function get_employee_deduction_amount()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = $this->Employees_model->read_single_salary_statutory_deduction($id);

		$drp = '';

		if ($data[0]->statutory_options == 0) {

			$drp = '<option value="0" selected>' . $this->lang->line('xin_title_tax_fixed') . '</option><option value="1" >' . $this->lang->line('xin_title_tax_percent') . '</option>';
		} else {

			$drp = '<option value="0">' . $this->lang->line('xin_title_tax_fixed') . '</option><option value="1" selected>' . $this->lang->line('xin_title_tax_percent') . '</option>';
		}



		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$output = array(

				"amount" => $data[0]->deduction_amount,

				"drp" => $drp

			);

			echo json_encode($output);

			exit();
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	public function employee_allowance_option_increment_validate()
	{

		if ($this->input->post('type') == 'employee_update_allowance_inc') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('allowance_title_salary_his') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_title_error');
			} else if ($this->input->post('allowance_amount_sal_his') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_amount_error');
			} else if ($this->input->post('allowance_amount_sal_his') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$allownace_id = $this->input->post('allowance_title_salary_his');

			$allowance_data = $this->Employees_model->read_single_salary_allowance($allownace_id);

			$allowance_amount_old_amt = $allowance_data[0]->allowance_amount;

			$new_amt = $this->input->post('allowance_amount_sal_his');

			if ($allowance_amount_old_amt == $new_amt && $allowance_data[0]->amount_option == $this->input->post('amount_option_salary_his_allowance')) {

				$Return['error'] = 'No difference in amount..';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function employee_allowance_option_increment()
	{



		if ($this->input->post('type') == 'employee_update_allowance_inc') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('allowance_title_salary_his') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_title_error');
			} else if ($this->input->post('allowance_amount_sal_his') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_amount_error');
			} else if ($this->input->post('allowance_amount_sal_his') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$allownace_id = $this->input->post('allowance_title_salary_his');

			$allowance_data = $this->Employees_model->read_single_salary_allowance($allownace_id);

			$allowance_amount_old_amt = $allowance_data[0]->allowance_amount;

			$new_amt = $this->input->post('allowance_amount_sal_his');

			if ($allowance_amount_old_amt == $new_amt && $allowance_data[0]->amount_option == $this->input->post('amount_option_salary_his_allowance')) {

				$Return['error'] = 'No difference in amount..';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$diff = $new_amt - $allowance_amount_old_amt;

			if ($diff > 0) {

				$inc_or_dec = 'inc';

				$inc_amt = abs($diff);
				if ($allowance_amount_old_amt == 0) {
					$in_perce = $inc_amt;
				} else {
					$in_perce = ($inc_amt * 100) / $allowance_amount_old_amt;
				}
			} else {

				$inc_amt = abs($diff);

				$inc_or_dec = 'dec';
				if ($allowance_amount_old_amt == 0) {
					$in_perce = $inc_amt;
				} else {
					$in_perce = ($inc_amt * 100) / $allowance_amount_old_amt;
				}
			}

			$commissions = $this->Employees_model->set_employee_sal_history_by_id($this->input->post('user_id'), 2, $this->input->post('allowance_title_salary_his'));

			if ($commissions->result()) {

				$data = array(

					'allowance_id' => $this->input->post('allowance_title_salary_his'),

					'amount' => $this->input->post('allowance_amount_sal_his'),

					'employee_id' => $this->input->post('user_id'),

					'date' => date('Y-m-d'),

					'inc_amt' => $inc_amt,

					'inc_or_dec' => $inc_or_dec,
					'inc_percentage' => $in_perce,
					'history_type' => 2

				);

				$result = $this->Employees_model->emp_salary_inc_history($data);
			} else {

				$allowances = $this->Employees_model->set_employee_allowances($this->input->post('user_id'));

				if ($allowances->result()) {

					foreach ($allowances->result() as $r) {

						$commissions = $this->Employees_model->set_employee_sal_history_by_id($this->input->post('user_id'), 3, $r->allowance_id);

						if (!$commissions->result()) {

							$data = array(

								'allowance_id' =>  $r->allowance_id,

								'amount' => $r->allowance_amount,

								'employee_id' => $r->employee_id,

								'date' =>  date('Y-m-d'),

								'inc_amt' => 0,

								'inc_or_dec' => '',
								'inc_percentage' => 0,
								'history_type' => 2

							);

							$result = $this->Employees_model->emp_salary_inc_history($data);
						}
					}
				}

				$data = array(

					'allowance_id' => $this->input->post('allowance_title_salary_his'),

					'amount' => $this->input->post('allowance_amount_sal_his'),

					'employee_id' => $this->input->post('user_id'),

					'date' => date('Y-m-d'),

					'inc_amt' => $inc_amt,
					'inc_or_dec' => $inc_or_dec,
					'inc_percentage' => $in_perce,
					'history_type' => 2

				);

				$result = $this->Employees_model->emp_salary_inc_history($data);
			}



			if ($result == TRUE) {

				$datas = array(

					'allowance_amount' => $this->input->post('allowance_amount_sal_his'),

					'amount_option' => $this->input->post('amount_option_salary_his_allowance')

				);

				$e_field_id = $this->input->post('allowance_title_salary_his');

				$result = $this->Employees_model->salary_allowance_update_record($datas, $e_field_id);

				$Return['result'] = $this->lang->line('xin_employee_set_allowance_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function employee_deduction_option_increment_validate()
	{

		if ($this->input->post('type') == 'employee_update_deduction_inc') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('deduction_salary_his') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('deduction_amount_sal_his') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('deduction_amount_sal_his') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$allownace_id = $this->input->post('deduction_salary_his');

			$allowance_data = $this->Employees_model->read_single_salary_statutory_deduction($allownace_id);

			$allowance_amount_old_amt = $allowance_data[0]->deduction_amount;

			$new_amt = $this->input->post('deduction_amount_sal_his');

			if ($allowance_amount_old_amt == $new_amt && $allowance_data[0]->statutory_options == $this->input->post('amount_option_salary_his_deduction')) {

				$Return['error'] = 'No difference in amount..';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}


			$this->output($Return);

			exit;
		}
	}

	public function employee_deduction_option_increment()
	{



		if ($this->input->post('type') == 'employee_update_deduction_inc') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('deduction_salary_his') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('deduction_amount_sal_his') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('deduction_amount_sal_his') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$allownace_id = $this->input->post('deduction_salary_his');

			$allowance_data = $this->Employees_model->read_single_salary_statutory_deduction($allownace_id);

			$allowance_amount_old_amt = $allowance_data[0]->deduction_amount;

			$new_amt = $this->input->post('deduction_amount_sal_his');

			if ($allowance_amount_old_amt == $new_amt && $allowance_data[0]->statutory_options == $this->input->post('amount_option_salary_his_deduction')) {

				$Return['error'] = 'No difference in amount..';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$diff = $new_amt - $allowance_amount_old_amt;

			if ($diff > 0) {

				$inc_or_dec = 'inc';

				$inc_amt = abs($diff);
				if ($allowance_amount_old_amt == 0) {
					$in_perce = $inc_amt;
				} else {
					$in_perce = ($inc_amt * 100) / $allowance_amount_old_amt;
				}
			} else {

				$inc_amt = abs($diff);

				$inc_or_dec = 'dec';
				if ($allowance_amount_old_amt == 0) {
					$in_perce = $inc_amt;
				} else {
					$in_perce = ($inc_amt * 100) / $allowance_amount_old_amt;
				}
			}

			$commissions = $this->Employees_model->set_employee_sal_history_by_id($this->input->post('user_id'), 3, $this->input->post('deduction_salary_his'));

			if ($commissions->result()) {

				$data = array(

					'allowance_id' => $this->input->post('deduction_salary_his'),

					'amount' => $this->input->post('deduction_amount_sal_his'),

					'employee_id' => $this->input->post('user_id'),

					'date' => date('Y-m-d'),

					'inc_amt' => $inc_amt,

					'inc_or_dec' => $inc_or_dec,
					'inc_percentage' => $in_perce,
					'history_type' => 3

				);

				$result = $this->Employees_model->emp_salary_inc_history($data);
			} else {

				$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($this->input->post('user_id'));

				if ($statutory_deductions->result()) {

					foreach ($statutory_deductions->result() as $r) {

						$commissions = $this->Employees_model->set_employee_sal_history_by_id($this->input->post('user_id'), 3, $r->statutory_deductions_id);

						if (!$commissions->result()) {

							$data = array(

								'allowance_id' => $r->statutory_deductions_id,

								'amount' => $r->deduction_amount,

								'employee_id' =>  $r->employee_id,

								'date' => date('Y-m-d'),

								'inc_amt' => 0,

								'inc_or_dec' => 0,
								'inc_percentage' => 0,
								'history_type' => 3

							);

							$result = $this->Employees_model->emp_salary_inc_history($data);
						}
					}
				}

				$data = array(

					'allowance_id' => $this->input->post('deduction_salary_his'),

					'amount' => $this->input->post('deduction_amount_sal_his'),

					'employee_id' => $this->input->post('user_id'),

					'date' => date('Y-m-d'),

					'inc_amt' => $inc_amt,

					'inc_or_dec' => $inc_or_dec,
					'inc_percentage' => $in_perce,
					'history_type' => 3

				);

				$result = $this->Employees_model->emp_salary_inc_history($data);
			}



			if ($result == TRUE) {

				$datas = array(

					'deduction_amount' => $this->input->post('deduction_amount_sal_his'),

					'statutory_options' => $this->input->post('amount_option_salary_his_deduction')

				);

				$e_field_id = $this->input->post('deduction_salary_his');

				$result = $this->Employees_model->salary_statutory_deduction_update_record($datas, $e_field_id);

				$Return['result'] = $this->lang->line('xin_employee_update_statutory_deduction_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function allowance_all_history()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_sal_history($id, 2);



		$data = array();

		$allowance_option = '';

		$inc_or_dec = '';

		$emp_info =  $this->Employees_model->read_employee_information($id);

		if ($commissions->result()) {

			foreach ($commissions->result() as $r) {

				$allowance_det_emp = $this->Employees_model->read_single_salary_allowance($r->allowance_id);

				if ($allowance_det_emp) {

					$allowance_det = $this->Xin_model->read_single_allowance($allowance_det_emp[0]->allowance_title);

					if ($allowance_det_emp[0]->amount_option == 0) {

						$allowance_option = $this->lang->line('xin_title_tax_fixed');
					} else if ($allowance_det_emp[0]->amount_option == 1) {

						$allowance_option = $this->lang->line('xin_title_tax_percent');
					}

					if ($r->inc_or_dec == 'inc') {

						//$inc_or_dec = $r->inc_amt.' incremented';
						$inc_or_dec = round($r->inc_percentage, 3) . '% incremented';
					} else if ($r->inc_or_dec == 'dec') {
						$inc_or_dec = round($r->inc_percentage, 3) . '% decremented';
						//$inc_or_dec = $r->inc_amt.' decremented';

					}



					//<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span>

					$data[] = array(


						$allowance_det[0]->name,

						$allowance_option,

						$r->amount,

						$r->date,

						($r->inc_amt == 0) ? 'First allowance amount' : $inc_or_dec,

						'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="emp_allowance_history"><span class="fas fa-trash-restore"></span></button></span>',


					);
				}
			}
		} else {

			$allowances = $this->Employees_model->set_employee_allowances($id);

			if ($allowances->result()) {

				foreach ($allowances->result() as $r) {

					//$current_amount = $r->allowance_amount * $current_rate;

					if ($r->amount_option == 0) {

						$allowance_amount_opt = $this->lang->line('xin_title_tax_fixed');
					} else {

						$allowance_amount_opt = $this->lang->line('xin_title_tax_percent');
					}

					if ($r->is_allowance_taxable == 0) {

						$allowance_opt = $this->lang->line('xin_salary_allowance_non_taxable');
					} else if ($r->is_allowance_taxable == 1) {

						$allowance_opt = $this->lang->line('xin_fully_taxable');
					} else {

						$allowance_opt = $this->lang->line('xin_partially_taxable');
					}

					//$allo=$this->Xin_model->read_allo($r->allowance_title);

					$allo = $this->Xin_model->read_single_allowance($r->allowance_title);

					$data[] = array(



						(isset($allo[0]->name)) ? $allo[0]->name : '',

						$r->allowance_amount,

						$allowance_opt,

						$r->created_at,

						'',

						'#',

					);
				}
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function deduction_all_history()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_sal_history($id, 3);



		$data = array();

		$allowance_option = '';

		$inc_or_dec = '';

		if ($commissions->result()) {

			foreach ($commissions->result() as $r) {

				$allowance_det_emp = $this->Employees_model->read_single_salary_statutory_deduction($r->allowance_id);

				if ($allowance_det_emp) {

					$allowance_det = $this->Xin_model->read_single_allowance($allowance_det_emp[0]->deduction_title);

					if ($allowance_det_emp[0]->statutory_options == 0) {

						$allowance_option = $this->lang->line('xin_title_tax_fixed');
					} else if ($allowance_det_emp[0]->statutory_options == 1) {

						$allowance_option = $this->lang->line('xin_title_tax_percent');
					}

					if ($r->inc_or_dec == 'inc') {

						//$inc_or_dec = $r->inc_amt.' incremented';
						$inc_or_dec = round($r->inc_percentage, 3) . '% incremented';
					} else if ($r->inc_or_dec == 'dec') {
						$inc_or_dec = round($r->inc_percentage, 3) . '% decremented';
						//$inc_or_dec = $r->inc_amt.' decremented';

					}



					//<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span>

					$data[] = array(


						$allowance_det[0]->name,

						$allowance_option,

						$r->amount,

						($r->inc_amt == 0) ? '' : $r->date,

						($r->inc_amt == 0) ? '' : $inc_or_dec,

						'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="emp_deduction_history"><span class="fas fa-trash-restore"></span></button></span>',


					);
				}
			}
		} else {

			$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($id);

			if ($statutory_deductions->result()) {

				foreach ($statutory_deductions->result() as $r) {

					if ($r->statutory_options == 0) {

						$sd_amount_opt = $this->lang->line('xin_title_tax_fixed');
					} else {

						$sd_amount_opt = $this->lang->line('xin_title_tax_percent');
					}

					$allo = $this->Xin_model->read_constant_allowance($r->deduction_title);
					if ($allo) {
						$allo_name = $allo[0]->name;
					} else {
						$allo_name = "";
					}
					$data[] = array(



						$allo_name,

						$sd_amount_opt,

						$r->deduction_amount,

						$r->created_at,

						'',

						'#',

					);
				}
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// Validate and update info in database // basic info

	public function set_overtime()
	{



		if ($this->input->post('type') == 'emp_overtime') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('overtime_type') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_title_error');
			} else if ($this->input->post('no_of_days') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_no_of_days_error');
			} else if ($this->input->post('overtime_hours') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_hours_error');
			} else if ($this->input->post('overtime_rate') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_rate_error');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'employee_id' => $this->input->post('user_id'),

				'overtime_type' => $this->input->post('overtime_type'),

				'no_of_days' => $this->input->post('no_of_days'),

				'overtime_hours' => $this->input->post('overtime_hours'),

				'overtime_rate' => $this->input->post('overtime_rate')

			);

			$id = $this->input->post('user_id');

			$result = $this->Employees_model->add_salary_overtime($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_added_overtime_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and update info in database // basic info

	public function update_overtime_info()
	{



		if ($this->input->post('type') == 'e_overtime_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('overtime_type') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_title_error');
			} else if ($this->input->post('no_of_days') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_no_of_days_error');
			} else if ($this->input->post('overtime_hours') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_hours_error');
			} else if ($this->input->post('overtime_rate') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_overtime_rate_error');
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$id = $this->input->post('e_field_id');

			$data = array(

				'overtime_type' => $this->input->post('overtime_type'),

				'no_of_days' => $this->input->post('no_of_days'),

				'overtime_hours' => $this->input->post('overtime_hours'),

				'overtime_rate' => $this->input->post('overtime_rate')

			);

			//$id = $this->input->post('user_id');

			$result = $this->Employees_model->salary_overtime_update_record($data, $id);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_updated_overtime_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}



	// Validate and update info in database // basic info

	public function employee_allowance_option_validate()
	{

		if ($this->input->post('type') == 'employee_update_allowance') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('allowance_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_title_error');
			} else if ($this->input->post('allowance_amount') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_amount_error');
			} else if ($this->input->post('allowance_amount') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_single_salary_allowance_empid_alloid($this->input->post('allowance_title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This allowance type already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function employee_allowance_option()
	{



		if ($this->input->post('type') == 'employee_update_allowance') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('allowance_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_title_error');
			} else if ($this->input->post('allowance_amount') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_allowance_amount_error');
			} else if ($this->input->post('allowance_amount') < 0) {
				$Return['error'] = 'Negative values not acceptable';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_single_salary_allowance_empid_alloid($this->input->post('allowance_title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This allowance type already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'allowance_title' => $this->input->post('allowance_title'),

				'allowance_amount' => $this->input->post('allowance_amount'),

				'employee_id' => $this->input->post('user_id'),

				'is_allowance_taxable' => $this->input->post('is_allowance_taxable'),

				'amount_option' => $this->input->post('amount_option'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary'),
				'created_at' => date('Y-m-d')

			);

			$data_new = '';

			$result = $this->Employees_model->add_salary_allowances_new($data);

			if ($result) {

				$all_al = $this->Xin_model->get_allowances_employees($this->input->post('user_id'));

				$data_new = '<option value="">' . $this->lang->line('xin_select_one') . '</option>';

				if ($all_al) {

					foreach ($all_al as $value) {

						$allowance_det = $this->Xin_model->read_single_allowance($value->allowance_title);

						if ($allowance_det[0]->type_id == 1) {

							$data_new .= ' <option value="' . $value->allowance_id . '">' . $allowance_det[0]->name . '</option>';
						}
					}
				}

				/* Set Leave salary settings Auto */
				/*	$user = $this->Xin_model->read_user_info($this->input->post('user_id'));
                	if(!empty($user)){
                	    // Nationality Check
                	    if($user[0]->nationality_id == 17){
                	        $category = 'bahraini';
                	    }else{
                	        $category = 'expat';
                	    }
            	    	$this->db->where('category', $category);
                		$leave_salary_info = $this->db->get('leave_salaries')->row();
                		if ($leave_salary_info){
                		    $allowances_leave = array();
                    		if (!empty($leave_salary_info->allowances)){
                    		    $allowances_leave = unserialize($leave_salary_info->allowances);
                    		}
                    		 print_R($allowances_leave);exit;   
                		}
		
                	}*/
				/* End Leave salary settings end */

				$Return['result'] = $this->lang->line('xin_employee_set_allowance_success');

				$Return['new_drp'] = $data_new;
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update info in database // basic info

	public function employee_commissions_option_validate()
	{

		if ($this->input->post('type') == 'employee_update_commissions') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative values not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_salary_commissions_empid_alloid($this->input->post('title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This commission type already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function employee_commissions_option()
	{



		if ($this->input->post('type') == 'employee_update_commissions') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative values not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_salary_commissions_empid_alloid($this->input->post('title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This commission type already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'commission_title' => $this->input->post('title'),

				'commission_amount' => $this->input->post('amount'),

				'employee_id' => $this->input->post('user_id'),

				'is_commission_taxable' => $this->input->post('is_commission_taxable'),

				'amount_option' => $this->input->post('amount_option'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary_commission')

			);

			$result = $this->Employees_model->add_salary_commissions($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_set_commission_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update info in database // basic info

	public function set_statutory_deductions_validate()
	{
		if ($this->input->post('type') == 'statutory_deductions_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative values not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_salary_deductions_empid_alloid($this->input->post('title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This statutory deduction is already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function set_statutory_deductions()
	{

		if ($this->input->post('type') == 'statutory_deductions_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative values not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_salary_deductions_empid_alloid($this->input->post('title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This statutory deduction is already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'deduction_title' => $this->input->post('title'),

				'deduction_amount' => $this->input->post('amount'),

				'statutory_options' => $this->input->post('statutory_options'),

				'employee_id' => $this->input->post('user_id'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary_deductions'),
				'created_at' => date('Y-m-d')

			);

			$data_new = '';

			$result = $this->Employees_model->add_salary_statutory_deductions($data);

			if ($result == TRUE) {

				$all_al = $this->Employees_model->set_employee_statutory_deductions($this->input->post('user_id'));

				$data_new = '<option value="">' . $this->lang->line('xin_select_one') . '</option>';

				if ($all_al) {

					foreach ($all_al->result() as $value) {

						$allowance_det = $this->Xin_model->read_single_allowance($value->deduction_title);

						if ($allowance_det[0]->type_id == 3) {

							$data_new .= ' <option value="' . $value->statutory_deductions_id . '">' . $allowance_det[0]->name . '</option>';
						}
					}
				}

				$Return['new_drp'] = $data_new;

				$Return['result'] = $this->lang->line('xin_employee_set_statutory_deduction_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// Validate and update info in database // basic info

	public function set_other_payments_validate()
	{

		if ($this->input->post('type') == 'other_payments_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative values not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_other_payments_empid_alloid($this->input->post('title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This other payment option is already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function set_other_payments()
	{



		if ($this->input->post('type') == 'other_payments_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('title') === '') {

				$Return['error'] = $this->lang->line('xin_error_title');
			} else if ($this->input->post('amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('amount') < 0) {

				$Return['error'] = 'Negative values not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_other_payments_empid_alloid($this->input->post('title'), $this->input->post('user_id'));

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This other payment option is already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$data = array(

				'payments_title' => $this->input->post('title'),

				'payments_amount' => $this->input->post('amount'),

				'employee_id' => $this->input->post('user_id'),

				'is_otherpayment_taxable' => $this->input->post('is_otherpayment_taxable'),

				'amount_option' => $this->input->post('amount_option'),

				'applicable_for_paysalary' => $this->input->post('applicable_paysalary_other_payments')

			);

			$result = $this->Employees_model->add_salary_other_payments($data);

			if ($result == TRUE) {

				$Return['result'] = $this->lang->line('xin_employee_set_otherpayments_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	// delete allowances record

	public function delete_all_allowances()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$check_allowance_exists_in_history = $this->Employees_model->CheckAllowanceExistsInSalaryHistory($id, 2);

			if (count($check_allowance_exists_in_history->result()) > 0) {

				foreach ($check_allowance_exists_in_history->result() as $r) {

					$res = $this->Employees_model->delete_emp_salary_history($r->id);
				}
			}

			$result = $this->Employees_model->delete_allowance_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_delete_allowance_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	// delete commissions record

	public function delete_all_commissions()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_commission_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_delete_commission_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	// delete statutory_deductions record

	public function delete_all_statutory_deductions()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$check_allowance_exists_in_history = $this->Employees_model->CheckAllowanceExistsInSalaryHistory($id, 3);

			if (count($check_allowance_exists_in_history->result()) > 0) {

				foreach ($check_allowance_exists_in_history->result() as $r) {

					$res = $this->Employees_model->delete_emp_salary_history($r->id);
				}
			}

			$result = $this->Employees_model->delete_statutory_deductions_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_delete_statutory_deduction_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	// delete other payments record

	public function delete_all_other_payments()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_other_payments_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_delete_otherpayments_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// delete deductions record

	public function delete_all_deductions()
	{

		// var_dump($this->input->post('data'));die();

		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);
			$result1 = $this->Employees_model->read_single_loan_deductions($id);
			$check_distributions_exits = $this->Employees_model->get_employee_loan_distrubtion($result1[0]->employee_id, $id);
			if ($check_distributions_exits) {
				$dlt_loan_distribution = $this->Employees_model->dlt_loan_distrbutions($result1[0]->employee_id, $id);
			}
			$result = $this->Employees_model->delete_loan_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_delete_loan_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	// delete overtime record

	public function delete_emp_overtime()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_overtime_record($id);

			if (isset($id)) {

				$Return['result'] = $this->lang->line('xin_employee_delete_overtime_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}



	// employee all_allowances

	public function salary_all_allowances()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$allowances = $this->Employees_model->set_employee_allowances($id);



		$data = array();

		/*$system = $this->Xin_model->read_setting_info(1);

		$default_currency = $this->Xin_model->read_currency_con_info($system[0]->default_currency_id);

		if(!is_null($default_currency)) {

			$current_rate = $default_currency[0]->to_currency_rate;

			$current_title = $default_currency[0]->to_currency_title;

		} else {

			$current_rate = 1;

			$current_title = 'USD';

		}*/



		foreach ($allowances->result() as $r) {

			//$current_amount = $r->allowance_amount * $current_rate;

			if ($r->amount_option == 0) {

				$allowance_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$allowance_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			if ($r->is_allowance_taxable == 0) {

				$allowance_opt = $this->lang->line('xin_salary_allowance_non_taxable');
			} else if ($r->is_allowance_taxable == 1) {

				$allowance_opt = $this->lang->line('xin_fully_taxable');
			} else {

				$allowance_opt = $this->lang->line('xin_partially_taxable');
			}

			//$allo=$this->Xin_model->read_allo($r->allowance_title);

			$allo = $this->Xin_model->read_single_allowance($r->allowance_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			$status = '<input type="radio" value="Y"  name="status_allowance' . $r->allowance_id . '" id="status_allowance' . $r->allowance_id . '" ';

			if ($r->status == 'Y') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status(' . $r->allowance_id . ',' . $status_val . ')">

					Active <br/>

					<input type="radio" value="N"

						name="status_allowance' . $r->allowance_id . '" id="status_allowance' . $r->allowance_id . '"';

			if ($r->status == 'N') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status(' . $r->allowance_id . ',' . $status_val . ')">Inactive';

			$data[] = array(



				(isset($allo[0]->name)) ? $allo[0]->name : '',

				$r->allowance_amount,

				$allowance_opt,

				$allowance_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->allowance_id . '" data-field_type="salary_allowance"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->allowance_id . '" data-token_type="all_allowances"><span class="fas fa-trash-restore"></span></button></span>',

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $allowances->num_rows(),

			"recordsFiltered" => $allowances->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	// employee commissions

	public function salary_all_commissions()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_commissions($id);



		$data = array();



		foreach ($commissions->result() as $r) {

			if ($r->amount_option == 0) {

				$commission_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$commission_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			if ($r->is_commission_taxable == 0) {

				$commission_opt = $this->lang->line('xin_salary_allowance_non_taxable');
			} else if ($r->is_commission_taxable == 1) {

				$commission_opt = $this->lang->line('xin_fully_taxable');
			} else {

				$commission_opt = $this->lang->line('xin_partially_taxable');
			}

			$allo = $this->Xin_model->read_allo($r->commission_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			$status = '<input type="radio" value="Y"  name="status_commission' . $r->salary_commissions_id . '" id="status_commission' . $r->salary_commissions_id . '" ';

			if ($r->status == 'Y') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_commissions(' . $r->salary_commissions_id . ',' . $status_val . ')">

						Active <br/>

						<input type="radio" value="N"

							name="status_commission' . $r->salary_commissions_id . '" id="status_commission' . $r->salary_commissions_id . '"';

			if ($r->status == 'N') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_commissions(' . $r->salary_commissions_id . ',' . $status_val . ')">Inactive';

			$data[] = array(


				$allo[0]->name,

				$r->commission_amount,

				$commission_opt,

				$commission_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->salary_commissions_id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->salary_commissions_id . '" data-token_type="all_commissions"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	// employee statutory_deductions

	public function salary_all_statutory_deductions()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($id);



		$data = array();



		foreach ($statutory_deductions->result() as $r) {



			if ($r->statutory_options == 0) {

				$sd_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$sd_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			$allo = $this->Xin_model->read_constant_allowance($r->deduction_title);
			if ($allo) {
				$allo_name = $allo[0]->name;
			} else {
				$allo_name = "";
			}
			$status_val = ($r->status == 'Y') ? 1 : 2;

			$status = '<input type="radio" value="Y"  name="status_dedu' . $r->statutory_deductions_id  . '" id="status_dedu' . $r->statutory_deductions_id  . '" ';

			if ($r->status == 'Y') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_deductions(' . $r->statutory_deductions_id . ',' . $status_val . ')">

						Active <br/>

						<input type="radio" value="N"

							name="status_dedu' . $r->statutory_deductions_id . '" id="status_dedu' . $r->statutory_deductions_id . '"';

			if ($r->status == 'N') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_deductions(' . $r->statutory_deductions_id . ',' . $status_val . ')">Inactive';

			$data[] = array(


				$allo_name,

				$r->deduction_amount,

				$sd_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->statutory_deductions_id . '" data-field_type="salary_statutory_deductions"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->statutory_deductions_id . '" data-token_type="all_statutory_deductions"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $statutory_deductions->num_rows(),

			"recordsFiltered" => $statutory_deductions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	// employee other payments

	public function salary_all_other_payments()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$other_payment = $this->Employees_model->set_employee_other_payments($id);



		$data = array();



		foreach ($other_payment->result() as $r) {

			if ($r->amount_option == 0) {

				$other_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$other_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			if ($r->is_otherpayment_taxable == 0) {

				$other_opt = $this->lang->line('xin_salary_allowance_non_taxable');
			} else if ($r->is_otherpayment_taxable == 1) {

				$other_opt = $this->lang->line('xin_fully_taxable');
			} else {

				$other_opt = $this->lang->line('xin_partially_taxable');
			}

			$allo = $this->Xin_model->read_constant_allowance($r->payments_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			$status = '<input type="radio" value="Y"  name="status_other' . $r->other_payments_id . '" id="status_other' . $r->other_payments_id . '" ';

			if ($r->status == 'Y') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_other_payments(' . $r->other_payments_id . ',' . $status_val . ')">

						Active <br/>

						<input type="radio" value="N"

							name="status_other' . $r->other_payments_id . '" id="status_other' . $r->other_payments_id . '"';

			if ($r->status == 'N') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_other_payments(' . $r->other_payments_id . ',' . $status_val . ')">Inactive';

			$data[] = array(


				(isset($allo[0]->name)) ? $allo[0]->name : '',

				$r->payments_amount,

				$other_opt,

				$other_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->other_payments_id . '" data-field_type="salary_other_payments"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->other_payments_id . '" data-token_type="all_other_payments"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $other_payment->num_rows(),

			"recordsFiltered" => $other_payment->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee overtime

	public function salary_overtime()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$overtime = $this->Employees_model->set_employee_overtime($id);

		$system = $this->Xin_model->read_setting_info(1);

		$data = array();



		foreach ($overtime->result() as $r) {

			$current_amount = $r->overtime_rate;

			$data[] = array(

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->salary_overtime_id . '" data-field_type="emp_overtime"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->salary_overtime_id . '" data-token_type="emp_overtime"><span class="fas fa-trash-restore"></span></button></span>',

				$r->overtime_type,

				$r->no_of_days,

				$r->overtime_hours,

				$current_amount

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $overtime->num_rows(),

			"recordsFiltered" => $overtime->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// employee salary_all_deductions

	public function salary_all_deductions($employee_id = 0)
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$deductions = $this->Employees_model->set_employee_deductions($id);

		/*$system = $this->Xin_model->read_setting_info(1);

		$default_currency = $this->Xin_model->read_currency_con_info($system[0]->default_currency_id);

		if(!is_null($default_currency)) {

			$current_rate = $default_currency[0]->to_currency_rate;

			$current_title = $default_currency[0]->to_currency_title;

		} else {

			$current_rate = 1;

			$current_title = 'USD';

		}*/

		$data = array();



		foreach ($deductions->result() as $r) {



			$sdate = $this->Xin_model->set_date_format($r->start_date);

			$edate = $this->Xin_model->set_date_format($r->end_date);

			// loan time

			if ($r->loan_time < 2) {

				$loan_time = $r->loan_time . ' ' . $this->lang->line('xin_employee_loan_time_single_month');
			} else {

				$loan_time = $r->loan_time . ' ' . $this->lang->line('xin_employee_loan_time_more_months');
			}

			if ($r->loan_options == 1) {

				$loan_options = $this->lang->line('xin_loan_ssc_title');
			} else if ($r->loan_options == 2) {

				//	$loan_options = $this->lang->line('xin_loan_hdmf_title');
				$loan_options = 'Personal Loan';
			} else {
				$loan_options = 'Other Loan';
				//$loan_options = $this->lang->line('xin_loan_other_sd_title');

			}

			$loan_details = '<div class="text-semibold">' . $this->lang->line('dashboard_xin_title') . ': ' . $r->loan_deduction_title . '</div>

								<div class="text-muted">' . $this->lang->line('xin_salary_loan_options') . ': ' . $loan_options . '</div><div class="text-muted">' . $this->lang->line('xin_start_date') . ': ' . $sdate . '</div><div class="text-muted">' . $this->lang->line('xin_end_date') . ': ' . $edate . '</div><div class="text-muted">' . $this->lang->line('xin_reason') . ': ' . $r->reason . '</div>';

			//$eoption_removed = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-info waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->loan_deduction_id . '" data-field_type="salary_loan"><span class="fas fa-pencil-alt"></span></button></span>';

			$status_val = ($r->loan_status == 'Y') ? 1 : 2;

			$status = '<input type="radio" value="Y"  name="status_loan' . $r->loan_deduction_id . '" id="status_loan' . $r->loan_deduction_id . '" ';

			if ($r->loan_status == 'Y') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_loans(' . $r->loan_deduction_id . ',' . $status_val . ')">

					Active <br/>

					<input type="radio" value="N"

						name="status_loan' . $r->loan_deduction_id . '" id="status_loan' . $r->loan_deduction_id . '"';

			if ($r->loan_status == 'N') {

				$status .= 'checked="checked"';
			}

			$role_ids = $this->Xin_model->user_role_resource();
			//  var_dump($role_ids);die();
			$disable = '';
			if ($r->status != 0 && !in_array('9807', $role_ids) && !in_array('9808', $role_ids) && !in_array('9809', $role_ids) && !in_array('9810', $role_ids)) {
				$disable = 'disabled="true"';
			}

			$status .= ' onClick="update_status_loans(' . $r->loan_deduction_id . ',' . $status_val . ')">Inactive';
			if (in_array('9803', $role_ids)) {
				$edit_res =  '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" ' . $disable . ' class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->loan_deduction_id . '" data-field_type="salary_loan" ><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit_res =  '';
			}
			if (in_array('9804', $role_ids)) {
				$dlt_res =  '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" ' . $disable . ' class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->loan_deduction_id . '" data-token_type="all_deductions"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$dlt_res =  '';
			}
			if (in_array('9805', $role_ids)) {
				$loan_approve = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Approve loan"><a class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" ' . $disable . ' href="' . base_url('admin/employees_loan?id=' . $r->loan_deduction_id) . '"><i class="fas fa-vote-yea"></i></a></span>';
			} else {
				$loan_approve =  '';
			}
			if (in_array('9806', $role_ids)) {
				$loan_extend = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Extend loan"><button type="button" ' . $disable . ' class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data-loan-dec" data-field_id="' . $r->loan_deduction_id . '" data-field_type="salary_loan_extend" ><span class="fas fa-calendar-alt"></span></button></span>';
			} else {
				$loan_extend =  '';
			}
			$combhr = $edit_res . $dlt_res . $loan_extend . $loan_approve;
			// $combhr='';
			$data[] = array(

				$loan_details,
				$r->monthly_installment,
				$loan_time,
				//	($r->applicable_for_paysalary == 1)?'Yes':'No',
				//	$status
				$combhr,
			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $deductions->num_rows(),

			"recordsFiltered" => $deductions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}



	// Validate and add info in database

	public function update_loan_info_validate_validate()
	{
		if ($this->input->post('type') == 'loan_info') {
			$session = $this->session->userdata('username');
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$id = $this->input->post('e_field_id');
			/* Server side PHP input validation */
			if ($this->input->post('loan_deduction_title') === '') {
				$Return['error'] = $this->lang->line('xin_employee_set_loan_title_error');
			} else if ($this->input->post('monthly_installment') === '') {
				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('final_amount_val') != $this->input->post('monthly_installment')) {
				$Return['error'] = 'The loan amount and the final amount is not equal..';
			} else if ($this->input->post('monthly_installment') < 0) {
				$Return['error'] = 'Negative value is not allowed';
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$this->output($Return);
			exit;
		}
	}

	public function update_loan_info_validate()
	{
		if ($this->input->post('type') == 'loan_info') {
			$session = $this->session->userdata('username');
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$id = $this->input->post('e_field_id');
			/* Server side PHP input validation */
			if ($this->input->post('loan_deduction_title') === '') {
				$Return['error'] = $this->lang->line('xin_employee_set_loan_title_error');
			} else if ($this->input->post('monthly_installment') === '') {
				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('final_amount_val') != $this->input->post('monthly_installment')) {
				$Return['error'] = 'The loan amount and the final amount is not equal..';
			} else if ($this->input->post('monthly_installment') < 0) {
				$Return['error'] = 'Negative value is not allowed';
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$this->output($Return);
			exit;
		}
	}
	public function update_loan_info()
	{
		if ($this->input->post('type') == 'loan_info') {
			$session = $this->session->userdata('username');
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$id = $this->input->post('e_field_id');
			/* Server side PHP input validation */
			if ($this->input->post('loan_deduction_title') === '') {
				$Return['error'] = $this->lang->line('xin_employee_set_loan_title_error');
			} else if ($this->input->post('monthly_installment') === '') {
				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('final_amount_val') != $this->input->post('monthly_installment')) {
				$Return['error'] = 'The loan amount and the final amount is not equal..';
			} else if ($this->input->post('monthly_installment') < 0) {
				$Return['error'] = 'Negative value is not allowed';
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$first_approval = $this->input->post('first_approval');
			$second_approval = $this->input->post('second_approval');
			$third_approval = $this->input->post('third_approval');
			$final_approval = $this->input->post('final_approval');
			$rslt = $this->Employees_model->read_single_loan_deductions($this->input->post('e_field_id'));

			if ($first_approval == 'null' || $first_approval == 'NULL' || $first_approval == NULL || $first_approval == null) {
				$first_approval = $rslt[0]->first_approval;
			}
			if ($second_approval == 'null' || $second_approval == 'NULL' || $second_approval == NULL || $second_approval == null) {
				$second_approval = $rslt[0]->second_approval;
			}
			if ($third_approval == 'null' || $third_approval == 'NULL' || $third_approval == NULL || $third_approval == null) {
				$third_approval = $rslt[0]->third_approval;
			}
			if ($final_approval == 'null' || $final_approval == 'NULL' || $final_approval == NULL || $final_approval == null) {
				$final_approval = $rslt[0]->final_approval;
			}
			if ($rslt[0]->first_approval != $first_approval) {
				$first_approved_user =  $session['user_id'];
			} else {
				$first_approved_user = $rslt[0]->first_approved_user;
			}
			if ($rslt[0]->second_approval != $second_approval) {
				$second_approved_user =  $session['user_id'];
			} else {
				$second_approved_user = $rslt[0]->second_approved_user;
			}
			if ($rslt[0]->third_approval != $third_approval) {
				$third_approved_user =  $session['user_id'];
			} else {
				$third_approved_user = $rslt[0]->third_approved_user;
			}
			if ($rslt[0]->final_approval != $final_approval) {
				$final_approved_user =  $session['user_id'];
			} else {
				$final_approved_user = $rslt[0]->final_approved_user;
			}
			if ($final_approval == 1) {
				$loan_status = 'Y';
			} else {
				$loan_status = 'N';
			}
			$data = array(
				'loan_deduction_title' => $this->input->post('loan_deduction_title'),
				'reason' => $qt_reason,
				'monthly_installment' => $this->input->post('monthly_installment'),
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'loan_options' => $this->input->post('loan_options'),
				'first_approval' => $first_approval,
				'second_approval' => $second_approval,
				'third_approval' => $third_approval,
				'final_approval' => $final_approval,
				'status' => $final_approval,
				'first_approved_user' => $first_approved_user,
				'second_approved_user' => $second_approved_user,
				'third_approved_user' => $third_approved_user,
				'final_approved_user' => $final_approved_user,
				'loan_status' => $loan_status
			);
			// 			var_dump($data);die();
			$result = $this->Employees_model->salary_loan_update_record($data, $id);

			if ($result == TRUE) {
				$get_loan_distrubtion = $this->Employees_model->get_employee_loan_distrubtion($this->input->post('user_id'), $id);
				if ($get_loan_distrubtion) {
					foreach ($get_loan_distrubtion as $val) {
						$data1 = array(
							'amount' => $this->input->post('amount_changes_' . $val->id),
						);
						$result_1 = $this->Employees_model->salary_loan_distrubution_record($data1, $val->id);
					}
				}
				$Return['result'] = $this->lang->line('xin_employee_update_loan_success');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database

	public function employee_loan_info_validate()
	{

		if ($this->input->post('type') == 'loan_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$reason = $this->input->post('reason');

			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$role_ids = $this->Xin_model->user_role_ids();

			$start_date = $this->input->post('start_date');

			$end_date = $this->input->post('end_date');

			$st_date = strtotime($start_date);

			$ed_date = strtotime($end_date);



			$user_id = $this->input->post('user_id');



			/* Server side PHP input validation */

			if ($this->input->post('loan_deduction_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_loan_title_error');
			} else if ($this->input->post('monthly_installment') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('start_date') === '') {

				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {

				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {

				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('monthly_installment') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('monthly_installment') < 0) {

				$Return['error'] = 'Negative Value is not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_loans_empid_alloid($this->input->post('loan_options'), $user_id);

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This loan type is already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);
			exit;
		}
	}

	public function employee_loan_info()
	{



		if ($this->input->post('type') == 'loan_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$reason = $this->input->post('reason');

			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$role_ids = $this->Xin_model->user_role_ids();

			$start_date = $this->input->post('start_date');

			$end_date = $this->input->post('end_date');

			$st_date = strtotime($start_date);

			$ed_date = strtotime($end_date);



			$user_id = $this->input->post('user_id');



			/* Server side PHP input validation */

			if ($this->input->post('loan_deduction_title') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_loan_title_error');
			} else if ($this->input->post('monthly_installment') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('start_date') === '') {

				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {

				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {

				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('monthly_installment') === '') {

				$Return['error'] = $this->lang->line('xin_employee_set_mins_title_error');
			} else if ($this->input->post('monthly_installment') < 0) {

				$Return['error'] = 'Negative Value is not allowed';
			}

			$check_allo_exists_or_not = $this->Employees_model->read_loans_empid_alloid($this->input->post('loan_options'), $user_id);

			if (!empty($check_allo_exists_or_not)) {

				$Return['error'] = 'This loan type is already exists';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}



			//$tm = $this->Employees_model->get_month_diff($this->input->post('start_date'),$this->input->post('end_date'));
			$start    = new DateTime($this->input->post('start_date'));
			$start->modify('first day of this month');
			$end      = new DateTime($this->input->post('end_date'));
			$end->modify('first day of next month');
			$interval = DateInterval::createFromDateString('1 month');
			$period   = new DatePeriod($start, $interval, $end);
			$array_dates = array();
			foreach ($period as $dt) {
				$array_dates[] = $dt->format("Y-m");
			}
			$final_month_diff = 0;
			$tm = count($array_dates);
			if ($tm < 1) {
				$m_ins = $this->input->post('monthly_installment');
			} else {
				$m_ins = $this->input->post('monthly_installment') / $tm;
				$m_ins = round($m_ins, 3);
				$check_final_val = $m_ins * $tm;
				if ($check_final_val != $this->input->post('monthly_installment')) {
					$final_month_diff = $this->input->post('monthly_installment') - $check_final_val;
					$final_month_diff = $m_ins + $final_month_diff;
				}
			}

			$data = array(
				'loan_deduction_title' => $this->input->post('loan_deduction_title'),
				'reason' => $qt_reason,
				'monthly_installment' => $this->input->post('monthly_installment'),
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'loan_options' => $this->input->post('loan_options'),
				'loan_time' => $tm,
				'loan_deduction_amount' => $m_ins,
				'employee_id' => $user_id,
				//'applicable_for_paysalary' => $this->input->post('applicable_paysalary_loan'),
			);
			$result = $this->Employees_model->add_salary_loan($data);
			if ($result) {
				$start    = new DateTime($this->input->post('start_date'));
				$start->modify('first day of this month');
				$end      = new DateTime($this->input->post('end_date'));
				$end->modify('first day of next month');
				$interval = DateInterval::createFromDateString('1 month');
				$period   = new DatePeriod($start, $interval, $end);
				$i = 1;
				foreach ($period as $dt) {
					if ($i == $tm && $final_month_diff > 0) {
						$m_ins = $final_month_diff;
					}
					$data1 = array(
						'loan_id' => $result,
						'month_year' => $dt->format("Y-m"),
						'amount' => $m_ins,
						'employee_id' => $user_id
					);
					$result_1 = $this->Employees_model->add_salary_loan_month_wise_dedec($data1);
					$i++;
				}
				$Return['result'] = $this->lang->line('xin_employee_add_loan_success');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// get company > locations

	public function filter_company_flocations()
	{



		$data['title'] = $this->Xin_model->site_title();

		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));

		if (is_numeric($keywords[0])) {

			$id = $keywords[0];



			$data = array(

				'company_id' => $id

			);

			$session = $this->session->userdata('username');

			if (!empty($session)) {

				$data = $this->security->xss_clean($data);

				$this->load->view("admin/filter/filter_company_flocations", $data);
			} else {

				redirect('admin/');
			}
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	// get location > departments

	public function filter_location_fdepartments()
	{



		$data['title'] = $this->Xin_model->site_title();

		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));

		if (is_numeric($keywords[0])) {

			$id = $keywords[0];



			$data = array(

				'location_id' => $id

			);

			$session = $this->session->userdata('username');

			if (!empty($session)) {

				$data = $this->security->xss_clean($data);

				$this->load->view("admin/filter/filter_location_fdepartments", $data);
			} else {

				redirect('admin/');
			}
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	public function filter_location_fdesignation()
	{



		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);



		$data = array(

			'department_id' => $id,

			'all_designations' => $this->Designation_model->all_designations(),

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/filter/filter_location_fdesignation", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}



	public function expired_documents()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_e_details_exp_documents') . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = $this->lang->line('xin_e_details_exp_documents');

		$data['path_url'] = 'employees_expired_documents';

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('557', $role_resources_ids)) {

			$data['subview'] = $this->load->view("admin/employees/expired_documents_list", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}



	// employee documents - listing

	public function expired_documents_list()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/expired_documents_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$documents = $this->Employees_model->get_documents_expired_all();
		} else {

			$documents = $this->Employees_model->get_user_documents_expired_all($session['user_id']);
		}





		$data = array();



		foreach ($documents->result() as $r) {



			$d_type = $this->Employees_model->read_document_type_information($r->document_type_id);
			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($d_type) && !is_null($xuser_info)) {
				if ($d_type[0]->document_type) {
					$document_d = $d_type[0]->document_type;
				} else {
					$document_d = '--';
				}

				$date_of_expiry = $this->Xin_model->set_date_format($r->date_of_expiry);
				if (in_array('854', $role_resources_ids)) {
					if ($r->document_file != '' && $r->document_file != 'no file') {

						$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document&filename=' . $r->document_file . '"><button type="button" class="btn icon-btn btn-outline-secondary btn-sm waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
					} else {

						$functions = '';
					}
				} else {
					$functions = '';
				}
				//userinfo

				if (in_array('853', $role_resources_ids)) { //edit
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary"  title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-outline-secondary btn-sm waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->document_id . '" data-field_type="document"><i class="fas fa-pencil-alt"></i></button></span>';
				} else {
					$edit = '';
				}

				if (!is_null($xuser_info)) {

					if ($user_info[0]->user_role_id == 1) {

						$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
					} else {

						$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
					}
				} else {

					$fc_name = '--';
				}
				$combhr = $edit . $functions;
				if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
					$data[] = array(

						$fc_name,
						$document_d,
						$r->title,
						$date_of_expiry,
						$combhr,
					);
				} else {
					$data[] = array(
						$fc_name,
						$document_d,
						$r->title,
						$date_of_expiry
					);
				}
			}
		}

		if (isset($data)) {
			$output = array(

				"draw" => $draw,

				"recordsTotal" => $documents->num_rows(),

				"recordsFiltered" => $documents->num_rows(),

				"data" => $data

			);
		} else {
			$output = array(
				"draw" => $draw,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => ''
			);
		}


		echo json_encode($output);

		exit();
	}



	// employee immigration - listing

	public function expired_immigration_list()
	{

		//set data
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/expired_documents_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		//	$id = $this->uri->segment(4);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$immigration = $this->Employees_model->get_img_documents_expired_all();
		} else {

			$immigration = $this->Employees_model->get_user_img_documents_expired_all($session['user_id']);
		}





		$data = array();



		foreach ($immigration->result() as $r) {
			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($xuser_info)) {
				$issue_date = $this->Xin_model->set_date_format($r->issue_date);
				$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);

				$eligible_review_date = $this->Xin_model->set_date_format($r->eligible_review_date);
				$d_type = $this->Employees_model->read_document_type_information($r->document_type_id);

				if (!is_null($d_type)) {
					$document_d = $d_type[0]->document_type . '<br>' . $r->document_number;
				} else {
					$document_d = $r->document_number;
				}

				$country = $this->Xin_model->read_country_info($r->country_id);
				if (!is_null($country)) {
					$c_name = $country[0]->country_name;
				} else {
					$c_name = '--';
				}

				//userinfo
				if (!is_null($xuser_info)) {
					if ($user_info[0]->user_role_id == 1) {
						$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
					} else {
						$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
					}
				} else {
					$fc_name = '--';
				}
				if (in_array('854', $role_resources_ids)) {
					if ($r->document_file != '' && $r->document_file != 'no file') {
						$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document/immigration&filename=' . $r->document_file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
					} else {
						$functions = '';
					}
				} else {
					$functions = '';
				}

				if (in_array('853', $role_resources_ids)) { //edit
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->immigration_id . '" data-field_type="imgdocument"><i class="fas fa-pencil-alt"></i></button></span>';
				} else {
					$edit = '';
				}
				$combhr = $edit . $functions;
				if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
					$data[] = array(

						$fc_name,
						$document_d,
						$issue_date,
						$expiry_date,
						$c_name,
						$combhr,
					);
				} else {
					$data[] = array(
						$fc_name,
						$document_d,
						$issue_date,
						$expiry_date,
						$c_name,
					);
				}
			}
		}
		if (isset($data)) {
			$output = array(
				"draw" => $draw,
				"recordsTotal" => $immigration->num_rows(),
				"recordsFiltered" => $immigration->num_rows(),
				"data" => $data
			);
			echo json_encode($output);
			exit();
		} else {
			$output = array(
				"draw" => $draw,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => ''
			);
			echo json_encode($output);
			exit();
		}
	}

	public function exp_company_license_list()

	{



		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/expired_documents_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$role_resources_ids = $this->Xin_model->user_role_resource();

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$company = $this->Employees_model->company_license_expired_all();
		} else {

			$company = $this->Employees_model->get_company_license_expired($user_info[0]->company_id);
		}

		$data = array();



		foreach ($company->result() as $r) {



			if (in_array('853', $role_resources_ids)) { //edit

				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-field_id="' . $r->document_id . '" data-field_type="company_license_expired"><i class="fas fa-pencil-alt"></i></button></span>';
			} else {

				$edit = '';
			}

			$company_id = $this->Company_model->read_company_information($r->company_id);

			if (!is_null($company_id)) {

				$company_name = $company_id[0]->name;
			} else {

				$company_name = '--';
			}


			if (in_array('854', $role_resources_ids)) {
				if ($r->document != '' && $r->document != 'no file') {

					$doc_view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_download') . '"><a href="' . base_url() . 'admin/download?type=company/official_documents&filename=' . $r->document . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
				} else {

					$doc_view = '';
				}
			} else {

				$doc_view = '';
			}

			$combhr = $doc_view . $edit;

			$ilicense_name = $r->license_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_hr_official_license_number') . ': ' . $r->license_number . '<i></i></i></small>';

			if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
				$data[] = array(

					$ilicense_name,
					$company_name,
					$r->expiry_date,
					$combhr,
				);
			} else {
				$data[] = array(
					$ilicense_name,
					$company_name,
					$r->expiry_date
				);
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $company->num_rows(),

			"recordsFiltered" => $company->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	// assets warranty list

	public function assets_warranty_list()

	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		if (!empty($session)) {

			$this->load->view("admin/employees/expired_documents_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$role_resources_ids = $this->Xin_model->user_role_resource();

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$assets = $this->Employees_model->warranty_assets_expired_all();
		} else {

			if (in_array('265', $role_resources_ids)) {

				$assets = $this->Employees_model->company_warranty_assets_expired_all($user_info[0]->company_id);
			} else {

				$assets = $this->Employees_model->user_warranty_assets_expired_all($session['user_id']);
			}
		}

		$data = array();



		foreach ($assets->result() as $r) {



			// get category

			$assets_category = $this->Assets_model->read_assets_category_info($r->assets_category_id);

			if (!is_null($assets_category)) {

				$category = $assets_category[0]->category_name;
			} else {

				$category = '--';
			}

			//working?

			if ($r->is_working == 1) {

				$working = $this->lang->line('xin_yes');
			} else {

				$working = $this->lang->line('xin_no');
			}

			// get user > added by

			$user = $this->Xin_model->read_user_info($r->employee_id);

			// user full name

			if (!is_null($user)) {

				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
			} else {

				$full_name = '--';
			}



			if (in_array('853', $role_resources_ids)) { //edit

				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->assets_id . '" data-field_type="assets_warranty_expired"><i class="fas fa-pencil-alt"></i></button></span>';
			} else {

				$edit = '';
			}



			if (in_array('854', $role_resources_ids)) { //view

				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".view-modal-data" data-asset_id="' . $r->assets_id . '"><span class="fa fa-eye"></span></button></span>';
			} else {

				$view = '';
			}

			$combhr = $edit;

			$created_at = $this->Xin_model->set_date_format($r->created_at);

			$iname = $r->name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_created_at') . ': ' . $created_at . '<i></i></i></small>';

			if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
				$data[] = array(

					$iname,
					$category,
					$r->company_asset_code,
					$working,
					$full_name,
					$combhr,
				);
			} else {
				$data[] = array(
					$iname,
					$category,
					$r->company_asset_code,
					$working,
					$full_name
				);
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $assets->num_rows(),

			"recordsFiltered" => $assets->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function dialog_exp_document()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_document_information($id);

		$data = array(

			'document_id' => $document[0]->document_id,

			'document_type_id' => $document[0]->document_type_id,

			'd_employee_id' => $document[0]->employee_id,

			'all_document_types' => $this->Employees_model->all_document_types(),

			'date_of_expiry' => $document[0]->date_of_expiry,

			'title' => $document[0]->title,

			'is_alert' => $document[0]->is_alert,

			'description' => $document[0]->description,

			'notification_email' => $document[0]->notification_email,

			'document_file' => $document[0]->document_file

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_exp_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_exp_imgdocument()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_imgdocument_information($id);

		$data = array(

			'immigration_id' => $document[0]->immigration_id,

			'document_type_id' => $document[0]->document_type_id,

			'd_employee_id' => $document[0]->employee_id,

			'all_document_types' => $this->Employees_model->all_document_types(),

			'all_countries' => $this->Xin_model->get_countries(),

			'document_number' => $document[0]->document_number,

			'document_file' => $document[0]->document_file,

			'issue_date' => $document[0]->issue_date,

			'expiry_date' => $document[0]->expiry_date,

			'country_id' => $document[0]->country_id,

			'eligible_review_date' => $document[0]->eligible_review_date,

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_exp_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function dialog_exp_company_license_expired()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		// $data['all_countries'] = $this->xin_model->get_countries();

		$result = $this->Company_model->read_company_document_info($id);

		$data = array(

			'document_id' => $result[0]->document_id,

			'license_name' => $result[0]->license_name,

			'company_id' => $result[0]->company_id,

			'expiry_date' => $result[0]->expiry_date,

			'license_number' => $result[0]->license_number,

			'license_notification' => $result[0]->license_notification,

			'document' => $result[0]->document,

			'all_countries' => $this->Xin_model->get_countries(),

			'get_all_companies' => $this->Xin_model->get_companies(),

			'get_company_types' => $this->Company_model->get_company_types()

		);

		$this->load->view('admin/employees/dialog_employee_exp_details', $data);
	}

	public function dialog_exp_assets_warranty_expired()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Assets_model->read_assets_info($id);

		$data = array(

			'assets_id' => $result[0]->assets_id,

			'assets_category_id' => $result[0]->assets_category_id,

			'company_id' => $result[0]->company_id,

			'employee_id' => $result[0]->employee_id,

			'company_asset_code' => $result[0]->company_asset_code,

			'name' => $result[0]->name,

			'purchase_date' => $result[0]->purchase_date,

			'invoice_number' => $result[0]->invoice_number,

			'manufacturer' => $result[0]->manufacturer,

			'serial_number' => $result[0]->serial_number,

			'warranty_end_date' => $result[0]->warranty_end_date,

			'asset_note' => $result[0]->asset_note,

			'asset_image' => $result[0]->asset_image,

			'is_working' => $result[0]->is_working,

			'created_at' => $result[0]->created_at,

			'all_employees' => $this->Xin_model->all_employees(),

			'all_assets_categories' => $this->Assets_model->get_all_assets_categories(),

			'all_companies' => $this->Xin_model->get_companies()

		);

		$this->load->view('admin/employees/dialog_employee_exp_details', $data);
	}

	public function dialog_security_level()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_security_level_information($id);

		$data = array(

			'security_level_id' => $result[0]->security_level_id,

			'employee_id' => $result[0]->employee_id,

			'security_type' => $result[0]->security_type,

			'date_of_clearance' => $result[0]->date_of_clearance,

			'expiry_date' => $result[0]->expiry_date

		);
		$local_store = $this->Employees_model->read_security_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['security_type'] = $un_local['security_type'];
			$data['date_of_clearance'] = $un_local['date_of_clearance'];
			$data['expiry_date'] = $un_local['expiry_date'];
		}
		$data['security_changes'] = $this->Employees_model->read_security_changes_local($id);
		$data['local_security_store'] = $this->Employees_model->read_local_security_store($id);
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}



	public function airtickets($employee_id = 0)

	{

		$data['title'] = $this->Xin_model->site_title();



		$session = $this->session->userdata('username');



		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		if (empty($session)) {

			$output = array(

				"draw" => $draw,

				"recordsTotal" => 0,

				"recordsFiltered" => 0,

				"data" => array(),

			);



			echo json_encode($output);
		}



		$this->db->where('user_id', $session['user_id']);

		$employee = $this->db->get('xin_employees')->row();

		$airtickets = $this->Employees_model->get_airtickets($employee_id);

		$data = array();



		foreach ($airtickets->result() as $r) {

			if ($employee->user_role_id == 1) {

				$tmp[] = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn btn-secondary btn-sm m-b-0-0 waves-effect waves-light" data-toggle="modal" data-target="#edit-modal-air_ticket" data-air_ticket_id="' . $r->id . '"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn btn-danger btn-sm m-b-0-0 waves-effect waves-light" data-toggle="modal" data-target=".delete-modal-air_ticket" data-air_ticket_id="' . $r->id . '"><i class="fa fa-trash-restore"></i></button></span>';
			} else {
				$tmp[] = '';
			}

			$tmp[] = $r->from_airport;

			$tmp[] = $r->to_airport;

			$tmp[] = $r->type;

			$tmp[] = $r->no_of_tickets;

			$data[] = $tmp;

			unset($tmp);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $airtickets->num_rows(),

			"recordsFiltered" => $airtickets->num_rows(),

			"data" => $data

		);



		echo json_encode($output);



		exit();
	}

	public function car_travel($employee_id = 0)

	{

		$data['title'] = $this->Xin_model->site_title();



		$session = $this->session->userdata('username');



		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}



		$this->db->where('user_id', $session['user_id']);

		$employee = $this->db->get('xin_employees')->row();



		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$airtickets = $this->Employees_model->get_car_travels($employee_id);



		$data = array();


		if ($airtickets->result()) {
			foreach ($airtickets->result() as $r) {

				$tmp[] = ($r->vehicle_car_travel == 1) ? 'Yes' : 'No';

				$tmp[] = $r->vehicle_model . '<br><small></small>';

				$tmp[] = $r->vehicle_number . '<br><small></small>';

				$tmp[] = $r->vehicle_type . '<br><small></small>';

				$tmp[] = ucfirst($r->with_without_fuel);

				if ($employee->user_role_id == 1) {

					$tmp[] = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#edit-modal-car_travels" data-car_ticket_id="' . $r->id . '"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light " data-toggle="modal" data-target=".delete-modal-car_travels" data-car_ticket_id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
				}

				$data[] = $tmp;

				unset($tmp);
			}
		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => $airtickets->num_rows(),

			"recordsFiltered" => $airtickets->num_rows(),

			"data" => $data

		);



		echo json_encode($output);



		exit();
	}

	public function accomodation($employee_id = 0)

	{

		$data['title'] = $this->Xin_model->site_title();



		$session = $this->session->userdata('username');



		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}



		$this->db->where('user_id', $session['user_id']);

		$employee = $this->db->get('xin_employees')->row();



		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$airtickets = $this->Employees_model->get_accomodation($employee_id);



		$data = array();



		foreach ($airtickets->result() as $r) {

			$tmp[] = ($r->vehicle_accomodation == 1) ? 'Yes' : 'No';

			$tmp[] = $r->type_accomodation . '<br><small></small>';

			$tmp[] = $r->house_villa_flat_no . '<br><small></small>';

			$tmp[] = $r->accomodation_city . '<br><small></small>';

			$tmp[] = ucfirst($r->accomodation_address);

			$tmp[] = ucfirst($r->accomodation_paid_unpaid);

			if ($employee->user_role_id == 1) {

				$tmp[] = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#edit-modal-accomodation" data-acco_ticket_id="' . $r->id . '"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light " data-toggle="modal" data-target=".delete-modal-accomodation" data-acco_ticket_id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
			}

			$data[] = $tmp;

			unset($tmp);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $airtickets->num_rows(),

			"recordsFiltered" => $airtickets->num_rows(),

			"data" => $data

		);



		echo json_encode($output);



		exit();
	}

	public function airticket_save_validate()
	{

		if ($this->input->post('air_ticket_from_airport') === '') {

			$Return['error'] = "Place From is required";
		} else if ($this->input->post('air_ticket_to_airport') === '') {

			$Return['error'] = "Place To is required";
		} else if ($this->input->post('air_ticket_type') === '') {

			$Return['error'] = "Eligible After Years is required";
		} else if ($this->input->post('no_of_air_tickets') === '') {

			$Return['error'] = "Number of Tickets is required";
		} else {
			$Return['error'] = '';
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();;

		$this->output($Return);
	}

	public function airticket_save()

	{
		if ($this->input->post('air_ticket_from_airport') === '') {

			$Return['error'] = "Place From is required";
		} else if ($this->input->post('air_ticket_to_airport') === '') {

			$Return['error'] = "Place To is required";
		} else if ($this->input->post('air_ticket_type') === '') {

			$Return['error'] = "Eligible After Years is required";
		} else if ($this->input->post('no_of_air_tickets') === '') {

			$Return['error'] = "Number of Tickets is required";
		} else {

			$empid    = $_POST['employee_id'];
			$empcheck = $this->Employees_model->emp_duplication_check($empid);
			if ($empcheck == 1) {

				$editid = $this->Employees_model->get_employee_no_of_tickets($empid);
				$id     = $editid[0]->id;

				$sql = "UPDATE `xin_airtickets` SET


				`from_airport`='" . $_POST['air_ticket_from_airport'] . "',

				`to_airport`='" . $_POST['air_ticket_to_airport'] . "',
				
				`no_of_tickets`='" . $_POST['no_of_air_tickets'] . "',

				`type`='" . $_POST['air_ticket_type'] . "' WHERE `id`='$id'";

				$this->db->query($sql);

				$Return['sql'] = $sql;

				$Return['result'] = 'Data has been updated.';

				$Return['error'] = '';

				$Return['csrf_hash'] = $this->security->get_csrf_hash();

				$this->output($Return);

				/*$Return['error'] = "Only one air ticket can be added for each employee.";
				    $this->output($Return);*/
			} else {


				$sql = "INSERT INTO `xin_airtickets` SET

				    `employee_id`='" . $_POST['employee_id'] . "',

				    `from_airport`='" . $_POST['air_ticket_from_airport'] . "',
    
				    `to_airport`='" . $_POST['air_ticket_to_airport'] . "',
				    
				    `no_of_tickets`='" . $_POST['no_of_air_tickets'] . "',

				    `type`='" . $_POST['air_ticket_type'] . "'";

				$this->db->query($sql);

				$Return['result'] = 'Data has been saved.';

				$Return['error'] = '';

				$Return['csrf_hash'] = $this->security->get_csrf_hash();;

				$this->output($Return);
			}
		}
	}

	public function airticket($id)

	{

		$airticket = $this->Employees_model->get_airticket($id);

		$this->output($airticket);
	}



	public function get_car_travels_data($id)

	{

		$airticket = $this->Employees_model->get_car_travelsdata($id);

		$this->output($airticket);
	}



	public function get_accomodation_data($id)

	{

		$airticket = $this->Employees_model->get_accomodationdata($id);

		$this->output($airticket);
	}





	public function airticket_update()

	{

		$id = $_POST['airticket_id'];

		$sql = "UPDATE `xin_airtickets` SET


				`from_airport`='" . $_POST['air_ticket_from_airport'] . "',

				`to_airport`='" . $_POST['air_ticket_to_airport'] . "',
				
				`no_of_tickets`='" . $_POST['no_of_airtickets'] . "',

				`type`='" . $_POST['air_ticket_type'] . "' WHERE `id`='$id'";

		$this->db->query($sql);

		$Return['sql'] = $sql;

		$Return['result'] = 'Data has been updated.';

		$Return['error'] = '';

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$this->output($Return);
	}

	public function accomodation_update_validate()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if (empty($this->input->post('house_villa_flat_no'))) {

			$Return['error'] = 'House/Villa/Flat No is required';
		} else if (empty($this->input->post('accomodation_city'))) {

			$Return['error'] = 'Accomodation City is required';
		} else if (empty($this->input->post('accomodation_address'))) {

			$Return['error'] = 'Accomodation Address is required';
		} else {
			$Return['error'] = '';
		}

		$this->output($Return);

		exit;
	}

	public function accomodation_update()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();


		$id = $_POST['acco_edit_id'];



		$sql = "UPDATE `accomodation` SET

				`vehicle_accomodation`='" . $_POST['accomodation_options'] . "',

				`type_accomodation`='" . $_POST['type_accomodation_options'] . "',

				`house_villa_flat_no`='" . $_POST['house_villa_flat_no'] . "',

				`accomodation_city`='" . $_POST['accomodation_city'] . "',

				`accomodation_address`='" . $_POST['accomodation_address'] . "',

				`accomodation_paid_unpaid`='" . $_POST['accomodation_paid_unpaid'] . "' WHERE

				`id`='$id'";

		$this->db->query($sql);



		$Return['result'] = 'Data has been updated.';

		$Return['error'] = '';



		$this->output($Return);
	}

	public function car_travels_update_validate()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if (empty($this->input->post('car_travel_options_edit'))) {

			$Return['error'] = 'Select travel option';
		} else if (empty($this->input->post('model_car'))) {

			$Return['error'] = 'Vehicle Model is required';
		} else if (empty($this->input->post('vehicle_number_car'))) {

			$Return['error'] = 'Vehicle No is required';
		} else {
			$Return['error'] = '';
		}

		$this->output($Return);

		exit;
	}

	public function car_travels_update()
	{

		$id = $_POST['car_travel_edit_id'];

		$car_travel_options_edit = $_POST['car_travel_options_edit'];

		$sql = "UPDATE `car_travel` SET

				`vehicle_car_travel`='" . $car_travel_options_edit . "',

				`vehicle_type`='" . $_POST['type_vehicle_options'] . "',

				`vehicle_model`='" . $_POST['model_car'] . "',

				`vehicle_number`='" . $_POST['vehicle_number_car'] . "',

				`with_without_fuel`='" . $_POST['with_with_out_fuel_options'] . "' WHERE

				`id`='$id'";

		$this->db->query($sql);

		$Return['sql'] = $sql;

		$Return['result'] = 'Data has been updated.';

		$Return['error'] = '';

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		$this->output($Return);
	}

	public function delete_airticket()

	{

		$id = $this->input->post('id');

		$airticket = $this->Employees_model->get_airticket($id);

		$Return['error'] = $Return['result'] = '';



		if ($airticket) {

			$this->Employees_model->delete_airticket($id);

			$Return['result'] = 'Air Ticket has been deleted.';
		} else {

			$Return['error'] = 'Air Ticket not found.';
		}

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$this->output($Return);
	}

	public function delete_car_travels()
	{

		$id = $this->input->post('id');

		$airticket = $this->Employees_model->get_car_travelsdata($id);

		$Return['error'] = $Return['result'] = '';



		if ($airticket) {

			$this->Employees_model->delete_cartravels($id);

			$Return['result'] = 'Car travel has been deleted.';
		} else {

			$Return['error'] = 'Car travel not found.';
		}

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$this->output($Return);
	}

	public function delete_accomodation()
	{

		$id = $this->input->post('acc0_id');

		$airticket = $this->Employees_model->get_accomodationdata($id);

		$Return['error'] = $Return['result'] = '';



		if ($airticket) {

			$this->Employees_model->delete_accomodation($id);

			$Return['result'] = 'Accomodation has been deleted.';
		} else {

			$Return['error'] = 'Accomodation not found.';
		}

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$this->output($Return);
	}

	public function  save_car_travel_validate()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if (empty($this->input->post('car_travel_options'))) {

			$Return['error'] = 'Select travel option';
		} else if (empty($this->input->post('model_car'))) {

			$Return['error'] = 'Vehicle Model is required';
		} else if (empty($this->input->post('vehicle_number_car'))) {

			$Return['error'] = 'Vehicle No is required';
		} else {
			$Return['error'] = '';
		}

		$this->output($Return);

		exit;
	}

	public function  save_car_travel()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$user_id = $this->input->post('user_id');

		$car_travel_options = $this->input->post('car_travel_options');

		$type_vehicle_options = $this->input->post('type_vehicle_options');

		$model_car = $this->input->post('model_car');

		$vehicle_number_car = $this->input->post('vehicle_number_car');

		$with_with_out_fuel_options = $this->input->post('with_with_out_fuel_options');

		$data = array(

			"user_id" => $user_id,

			"vehicle_car_travel" => $car_travel_options,

			"vehicle_type" => $type_vehicle_options,

			"vehicle_model" => $model_car,

			"vehicle_number" =>	$vehicle_number_car,

			"with_without_fuel" => $with_with_out_fuel_options

		);

		$result = $this->Employees_model->save_car_travel_data($data);

		if ($result == TRUE) {

			$Return['result'] = "Data Save successfully";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}

	public function save_accomodation_validate()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if (empty($this->input->post('house_villa_flat_no'))) {

			$Return['error'] = 'House/Villa/Flat No is required';
		} else if (empty($this->input->post('accomodation_city'))) {

			$Return['error'] = 'Accomodation City is required';
		} else if (empty($this->input->post('accomodation_address'))) {

			$Return['error'] = 'Accomodation Address is required';
		} else {
			$Return['error'] = '';
		}

		$this->output($Return);

		exit;
	}

	public function save_accomodation()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$user_id = $this->input->post('user_id');

		$accomodation_options = $this->input->post('accomodation_options');

		$type_accomodation_options = $this->input->post('type_accomodation_options');

		$house_villa_flat_no = $this->input->post('house_villa_flat_no');

		$accomodation_city = $this->input->post('accomodation_city');

		$accomodation_address = $this->input->post('accomodation_address');

		$accomodation_paid_unpaid = $this->input->post('accomodation_paid_unpaid');

		$data = array(

			"user_id" => $user_id,

			"vehicle_accomodation" => $accomodation_options,

			"type_accomodation" => $type_accomodation_options,

			"house_villa_flat_no" => $house_villa_flat_no,

			"accomodation_city" =>	$accomodation_city,

			"accomodation_address" => $accomodation_address,

			"accomodation_paid_unpaid" => $accomodation_paid_unpaid

		);

		$result = $this->Employees_model->save_accomodation_data($data);

		if ($result == TRUE) {

			$Return['result'] = "Data Save successfully";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}

	public function cron()
	{
		$date1 = date('Y-m-d');
		$sql = 'SELECT * FROM xin_employees where user_id!=1';
		$query = $this->db->query($sql);
		$data = $query->result();
		foreach ($data as $data_value) {
			$leave_updated_date = $data_value->leave_updated_date;
			$diff = abs(time() - strtotime($leave_updated_date));
			$years = floor($diff / ((60 * 60) * 24 * 365));
			$input = $data_value->leave_updated_date;
			$d1 = new DateTime($input);
			$d2 = new DateTime($date1);
			$diff = $d2->diff($d1);
			$save = $diff->y;
			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;

			if ($years < 1) {
				continue;
			}
			$actual_leave_count_data = $this->Timesheet_model->read_leave_type_information(3);
			if ($actual_leave_count_data) {
				$actual_leave_count = $actual_leave_count_data[0]->days_per_year;
			} else {
				$actual_leave_count = 30;
			}
			$actual_leave_count_data_sick = $this->Timesheet_model->read_leave_type_information(4);
			if ($actual_leave_count_data_sick) {
				$actual_leave_count_sick = $actual_leave_count_data_sick[0]->days_per_year;
			} else {
				$actual_leave_count_sick = 30;
			}
			$user_id = $data_value->user_id;
			$sql2 = 'SELECT * FROM employee_leave where employee_leave.employee_id=' . $user_id . ' and leave_type = 3  order by id DESC limit 1';
			$query_data = $this->db->query($sql2);

			$leave_user = $this->Xin_model->read_user_info($user_id);
			$leave_categories_ids = explode(',', $leave_user[0]->leave_categories);

			//$data_query=$query_data->result();
			if ($query_data->num_rows() == 1) {
				$data_query = $query_data->result();
				$sql_carry = 'SELECT * FROM carry_leaves where carry_leaves.employee_id=' . $user_id . ' and carry_leaves.leave_type_id=3  order by id DESC limit 1';
				$query_data_carry = $this->db->query($sql_carry);
				if ($query_data_carry->num_rows() == 1) {
					$data_query_carry = $query_data_carry->result();
					$reamining_count = $data_query_carry[0]->remaing_leave_count;
				} else {
					$reamining_count = $data_query[0]->leave_count;
				}
				$actual_leave_count = $actual_leave_count + $reamining_count;

				$data = array(
					'leave_type' => 3,
					'leave_count' => $actual_leave_count,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				$data1 = array(
					'leave_type' => 4,
					'leave_count' => $actual_leave_count_sick,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);

				if (in_array(3, $leave_categories_ids)) {
					$result = $this->Timesheet_model->auto_insert($data);
					$data3 = array(
						'leave_updated_date' => $update_date
					);
					$result3 = $this->Employees_model->auto_update($data3, $user_id);
				}
				if (in_array(4, $leave_categories_ids)) {
					$result1 = $this->Timesheet_model->auto_insert1($data1);
					$data3 = array(
						'leave_updated_date' => $update_date
					);
					$result3 = $this->Employees_model->auto_update($data3, $user_id);
				}



				// 	Update leave_updated_date with current date
			} else {
				$sql_carry = 'SELECT * FROM carry_leaves where carry_leaves.employee_id=' . $user_id . ' and carry_leaves.leave_type_id=3  order by id DESC limit 1';
				$query_data_carry = $this->db->query($sql_carry);
				if ($query_data_carry->num_rows() == 1) {
					$data_query_carry = $query_data_carry->result();
					$reamining_count = $data_query_carry[0]->remaing_leave_count;
				}
				$data = array(
					'leave_type' => 3,
					'leave_count' => $actual_leave_count,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				$data1 = array(
					'leave_type' => 4,
					'leave_count' => $actual_leave_count_sick,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				if (in_array(3, $leave_categories_ids)) {
					$result = $this->Timesheet_model->auto_insert($data);
					$data3 = array(
						'leave_updated_date' => $update_date
					);
					$result3 = $this->Employees_model->auto_update($data3, $user_id);
				}
				if (in_array(4, $leave_categories_ids)) {
					$result1 = $this->Timesheet_model->auto_insert1($data1);
					$data3 = array(
						'leave_updated_date' => $update_date
					);
					$result3 = $this->Employees_model->auto_update($data3, $user_id);
				}
			}
			echo "$user_id => $data_value->first_name updated.";
			echo "<br>";
		}
		echo "Cron job finished.<br>";
	}
	public function cron_bk24032022()
	{

		$date1 = date('Y-m-d');

		$sql = 'SELECT * FROM xin_employees where user_id!=1';

		$query = $this->db->query($sql);

		$data = $query->result();


		foreach ($data as $data_value) {
			$leave_updated_date = $data_value->leave_updated_date;
			$diff = abs(time() - strtotime($leave_updated_date));
			$years = floor($diff / ((60 * 60) * 24 * 365));
			$update_date = date('Y-m-d', strtotime('+1 year', strtotime($data_value->leave_updated_date)));

			if ($years < 1) {

				continue;
			}


			$user_id = $data_value->user_id;

			$sql2 = 'SELECT * FROM employee_leave where employee_leave.employee_id=' . $user_id . '  order by id DESC limit 1';


			$query_data = $this->db->query($sql2);


			//  print_r($query_data);exit;

			//$data_query=$query_data->result();


			if ($query_data->num_rows() == 1) {

				// delete old leaves

				$this->db->where('employee_id', $user_id);
				$this->db->delete('employee_leave');

				/// end 

				$data = array(

					'leave_type' => 3,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$data1 = array(

					'leave_type' => 4,

					'leave_count' => 55,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);
				$result = $this->Timesheet_model->auto_insert($data);

				$result1 = $this->Timesheet_model->auto_insert1($data1);

				$data3 = array(

					'leave_updated_date' => $update_date
				);

				$result3 = $this->Employees_model->auto_update($data3, $user_id);


				// 	Update leave_updated_date with current date


			} else {

				$data = array(

					'leave_type' => 3,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$data1 = array(

					'leave_type' => 4,

					'leave_count' => 55,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$result = $this->Timesheet_model->auto_insert($data);

				$result1 = $this->Timesheet_model->auto_insert1($data1);

				$data3 = array(

					'leave_updated_date' => $update_date
				);

				$result3 = $this->Employees_model->auto_update($data3, $user_id);
			}

			echo "$user_id => $data_value->first_name updated.";
			echo "<br>";
		}

		echo "Cron job finished.<br>";
	}

	public function cron_04032022()
	{

		$date1 = date('Y-m-d');

		$sql = 'SELECT * FROM xin_employees where user_id!=1';

		$query = $this->db->query($sql);

		$data = $query->result();



		foreach ($data as $data_value) {

			// print_r($data_value);exit;

			$leave_updated_date = $data_value->leave_updated_date;

			$diff = abs(time() - strtotime($leave_updated_date));

			$years = floor($diff / ((60 * 60) * 24 * 365));

			$input = $data_value->leave_updated_date;
			$d1 = new DateTime($input);
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;

			if ($years < 1) {

				continue;
			}



			$user_id = $data_value->user_id;

			$sql2 = 'SELECT * FROM employee_leave where employee_leave.employee_id=' . $user_id . '  order by id DESC limit 1';

			$query_data = $this->db->query($sql2);

			//  print_r($query_data);exit;

			//$data_query=$query_data->result();




			if ($query_data->num_rows() == 1) {

				$data_query = $query_data->result();




				$data = array(

					'leave_type' => 3,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$data1 = array(

					'leave_type' => 4,

					'leave_count' => 55,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);
				// 		print_r($data1);
				// 		print_r($data);

				// 	$result=$this->Timesheet_model->auto_update($data,$user_id,3);

				// 	$result1=$this->Timesheet_model->auto_update3($data1,$user_id,4);
				$result = $this->Timesheet_model->auto_insert($data);

				$result1 = $this->Timesheet_model->auto_insert1($data1);

				$data3 = array(

					'leave_updated_date' => $update_date
				);

				$result3 = $this->Employees_model->auto_update($data3, $user_id);



				// 	Update leave_updated_date with current date



			} else {

				$data = array(

					'leave_type' => 3,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$data1 = array(

					'leave_type' => 4,

					'leave_count' => 55,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$result = $this->Timesheet_model->auto_insert($data);

				$result1 = $this->Timesheet_model->auto_insert1($data1);

				$data3 = array(

					'leave_updated_date' => $update_date
				);

				$result3 = $this->Employees_model->auto_update($data3, $user_id);
			}

			echo "$user_id => $data_value->first_name updated.";
			echo "<br>";
		}

		echo "Cron job finished.<br>";
	}
	public function cron_bkkk()
	{
		$date1 = date('Y-m-d');
		$sql = 'SELECT * FROM xin_employees where user_id!=1';
		$query = $this->db->query($sql);
		$data = $query->result();
		foreach ($data as $data_value) {
			// print_r($data_value);exit;
			$leave_updated_date = $data_value->leave_updated_date;
			$diff = abs(time() - strtotime($leave_updated_date));
			$years = floor($diff / ((60 * 60) * 24 * 365));
			$input = $data_value->leave_updated_date;
			$d1 = new DateTime($input);
			$d2 = new DateTime($date1);
			$diff = $d2->diff($d1);
			$save = $diff->y;
			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;

			if ($years < 1) {
				continue;
			}
			$actual_leave_count = 30;
			$user_id = $data_value->user_id;
			$sql2 = 'SELECT * FROM employee_leave where employee_leave.employee_id=' . $user_id . ' and leave_type = 3  order by id DESC limit 1';
			$query_data = $this->db->query($sql2);
			//$data_query=$query_data->result();
			if ($query_data->num_rows() == 1) {
				$data_query = $query_data->result();
				$sql_carry = 'SELECT * FROM carry_leaves where carry_leaves.employee_id=' . $user_id . ' and carry_leaves.leave_type_id=3  order by id DESC limit 1';
				$query_data_carry = $this->db->query($sql_carry);
				if ($query_data_carry->num_rows() == 1) {
					$data_query_carry = $query_data_carry->result();
					$reamining_count = $data_query_carry[0]->remaing_leave_count;
					if ($reamining_count > 0) {
						$actual_leave_count = $reamining_count + $actual_leave_count;
						$data_insert = array('date' => $update_date, 'count' => $reamining_count, 'employee_id' => $user_id);
						$result_insert = $this->Timesheet_model->insert_common('xin_annual_leave_notify', $data_insert);
					}
				} else {
					$reamining_count = $data_query[0]->leave_count;
					if ($reamining_count > 0) {
						$actual_leave_count = $reamining_count + $actual_leave_count;
						$data_insert = array('date' => $update_date, 'count' => $reamining_count, 'employee_id' => $user_id);
						$result_insert = $this->Timesheet_model->insert_common('xin_annual_leave_notify', $data_insert);
					}
				}
				$data = array(
					'leave_type' => 3,
					'leave_count' => $actual_leave_count,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				$data1 = array(
					'leave_type' => 4,
					'leave_count' => 30,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				// 		print_r($data1);
				// 		print_r($data);
				// 	$result=$this->Timesheet_model->auto_update($data,$user_id,3);
				// 	$result1=$this->Timesheet_model->auto_update3($data1,$user_id,4);
				$result = $this->Timesheet_model->auto_insert($data);
				$result1 = $this->Timesheet_model->auto_insert1($data1);
				$data3 = array(
					'leave_updated_date' => $update_date
				);
				$result3 = $this->Employees_model->auto_update($data3, $user_id);
				// 	Update leave_updated_date with current date
			} else {
				$sql_carry = 'SELECT * FROM carry_leaves where carry_leaves.employee_id=' . $user_id . ' and carry_leaves.leave_type_id=3  order by id DESC limit 1';
				$query_data_carry = $this->db->query($sql_carry);
				if ($query_data_carry->num_rows() == 1) {
					$data_query_carry = $query_data_carry->result();
					$reamining_count = $data_query_carry[0]->remaing_leave_count;
					if ($reamining_count > 0) {
						$actual_leave_count = $reamining_count + $actual_leave_count;
						$data_insert = array('date' => $update_date, 'count' => $reamining_count, 'employee_id' => $user_id);
						$result_insert = $this->Timesheet_model->insert_common('xin_annual_leave_notify', $data_insert);
					}
				}
				$data = array(
					'leave_type' => 3,
					'leave_count' => $actual_leave_count,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				$data1 = array(
					'leave_type' => 4,
					'leave_count' => 30,
					'employee_id' => $user_id,
					'created_at' => $update_date
				);
				$result = $this->Timesheet_model->auto_insert($data);
				$result1 = $this->Timesheet_model->auto_insert1($data1);
				$data3 = array(
					'leave_updated_date' => $update_date
				);
				$result3 = $this->Employees_model->auto_update($data3, $user_id);
			}
			echo "$user_id => $data_value->first_name updated.";
			echo "<br>";
		}
		echo "Cron job finished.<br>";
	}
	public function cron_bk()
	{

		$date1 = date('Y-m-d');

		$sql = 'SELECT * FROM xin_employees where user_id!=1';

		$query = $this->db->query($sql);

		$data = $query->result();



		foreach ($data as $data_value) {

			// print_r($data_value);exit;

			$leave_updated_date = $data_value->leave_updated_date;

			$diff = abs(time() - strtotime($leave_updated_date));

			$years = floor($diff / ((60 * 60) * 24 * 365));

			$input = $data_value->leave_updated_date;
			$d1 = new DateTime($input);
			$d2 = new DateTime($date1);

			$diff = $d2->diff($d1);

			$save = $diff->y;

			//echo$explode_date=explode('-',2019-03-12);

			$time  = strtotime($input);
			$day   = date('d', $time);
			$month = date('m', $time);
			$year  = date('Y', $time);
			$new = $year + $save;
			$update_date = $new . '-' . $month . '-' . $day;

			if ($years < 1) {

				continue;
			}



			$user_id = $data_value->user_id;

			$sql2 = 'SELECT * FROM employee_leave where employee_leave.employee_id=' . $user_id . '  order by id DESC limit 1';

			$query_data = $this->db->query($sql2);

			//  print_r($query_data);exit;

			//$data_query=$query_data->result();




			if ($query_data->num_rows() == 1) {

				$data_query = $query_data->result();




				$data = array(

					'leave_type' => 3,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$data1 = array(

					'leave_type' => 4,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);
				// 		print_r($data1);
				// 		print_r($data);

				// 	$result=$this->Timesheet_model->auto_update($data,$user_id,3);

				// 	$result1=$this->Timesheet_model->auto_update3($data1,$user_id,4);
				$result = $this->Timesheet_model->auto_insert($data);

				$result1 = $this->Timesheet_model->auto_insert1($data1);

				$data3 = array(

					'leave_updated_date' => $update_date
				);

				$result3 = $this->Employees_model->auto_update($data3, $user_id);



				// 	Update leave_updated_date with current date



			} else {

				$data = array(

					'leave_type' => 3,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$data1 = array(

					'leave_type' => 4,

					'leave_count' => 30,

					'employee_id' => $user_id,

					'created_at' => $update_date

				);

				$result = $this->Timesheet_model->auto_insert($data);

				$result1 = $this->Timesheet_model->auto_insert1($data1);

				$data3 = array(

					'leave_updated_date' => $update_date
				);

				$result3 = $this->Employees_model->auto_update($data3, $user_id);
			}

			echo "$user_id => $data_value->first_name updated.";
			echo "<br>";
		}

		echo "Cron job finished.<br>";
	}



	public function getEmployeesCode()
	{

		$data_array = array(

			'company_id' => $this->input->get('company_id'),

			'departments_id' => $this->input->get('departments_id'),

			'designation_id' => $this->input->get('designation_id')

		);

		$get_all_code = $this->Employees_model->get_all_code($data_array);

		//   echo $get_all_code;exit;

		$serial_no = $this->Employees_model->get_last_serial_no();

		$get_all_code = $get_all_code . '' . $serial_no;

		$this->output($get_all_code);

		exit;
	}

	public function getEmployeesCode_Det()
	{

		$company_id = $this->input->get('company_id');

		$dept_id = $this->input->get('departments_id');

		$designation_id = $this->input->get('designation_id');

		$company_code = $dept_code = $designation_code = $emp_code = $serial_no_new = '';

		if ($company_id && $dept_id && $designation_id) {

			/* To get company details */

			$company_det = $this->Company_model->read_company_information($company_id);

			if ($company_det) {

				$company_code = $company_det[0]->company_code;
			}

			/* company details end */

			/* To get departments details */

			$dept_det = $this->Department_model->read_department_information($dept_id);

			if ($dept_det) {

				$dept_code = $dept_det[0]->department_code;
			}

			/* departments details end */

			/* To get designation details */

			$designation_det = $this->Designation_model->read_designation_information($designation_id);

			if ($designation_det) {

				$designation_code = $designation_det[0]->designation_code;
			}

			/* designation details end */

			/* get leatest serial no */

			$serial_no = $this->Employees_model->get_last_serial_no_emp($dept_code, $designation_code);

			if ($serial_no) {

				$serial_no_new = $serial_no[0]->serial_no + 1;


				$serial_no_new = str_pad($serial_no_new, 4, "0", STR_PAD_LEFT);

				$emp_code = $company_code . $dept_code . $designation_code . $serial_no_new;
			} else {

				$serial_no_new = '0010';

				$emp_code = $company_code . $dept_code . $designation_code . $serial_no_new;
			}

			$arry_data = array(

				'emp_code' => $emp_code,

				'serial_no' => $serial_no_new

			);

			echo json_encode($arry_data);
			exit;

			/*end latest serial no */
		}
	}

	public function get_indemninty_calc_bk()
	{

		$data['title'] = $this->Xin_model->site_title();

		$yr = $this->uri->segment(4);

		$ye_data = explode("-", $yr);

		$year = $ye_data[0];

		$user_id = $this->uri->segment(5);

		$result = $this->Employees_model->read_employee_information($user_id);

		if (is_null($result)) {

			redirect('admin/employees');
		}

		$basic_salary  = $result[0]->basic_salary;

		$joing_date  = $result[0]->date_of_joining;

		$Indemnity = 0;

		if ($year <= 3) {

			$lop_leave_count = 0;

			$yearly_indemninty = 0;

			$enddate_leave_count = date('Y-m-d', strtotime('+' . $year . ' years', strtotime($joing_date)));

			$emp_leaves = $this->Employees_model->empLeaveFetchForIndemnintyCalc($user_id, $joing_date, $enddate_leave_count);

			if ($emp_leaves) {

				foreach ($emp_leaves as $emp_leave) {

					$sql = "Select *, SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id

									WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and (p.from_date >= '" . date('Y-m-d H:i:s', strtotime($joing_date)) . "' and p.to_date <= '" . date('Y-m-d H:i:s', strtotime($enddate_leave_count)) . "')";



					$binds = array($emp_leave->employee_id);

					$query = $this->db->query($sql, $binds);

					$tmp = $query->result();

					$leaves_in_year_org = $tmp[0]->days_per_year * $year;

					$tot_leaves = $emp_leave->total_leaves;

					$leaves_in_year = $leaves_in_year_org - $tot_leaves;

					if ($leaves_in_year < 0) {

						$lop_leave_count += abs($leaves_in_year);
					}
				}
			}



			$no_of_days = ($year * 365) - $lop_leave_count;

			$tot_cal_indemninty = (15 / 365) * $year;

			$no_days = $tot_cal_indemninty * $no_of_days;

			$Indemnity  = ($basic_salary / 30) * $no_days;
		} else if ($year >= 4) {

			$lop_leave_count = 0;

			$yearly_indemninty = 0;

			$enddate_leave_count = date('Y-m-d', strtotime('+' . $year . ' years', strtotime($joing_date)));

			$emp_leaves = $this->Employees_model->empLeaveFetchForIndemnintyCalc($user_id, $joing_date, $enddate_leave_count);

			if ($emp_leaves) {

				foreach ($emp_leaves as $emp_leave) {

					$sql = "Select *, SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id

									WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and (p.from_date >= '" . date('Y-m-d H:i:s', strtotime($joing_date)) . "' and p.to_date <= '" . date('Y-m-d H:i:s', strtotime($enddate_leave_count)) . "')";



					$binds = array($emp_leave->employee_id);

					$query = $this->db->query($sql, $binds);

					$tmp = $query->result();

					$leaves_in_year_org = $tmp[0]->days_per_year * $year;

					$tot_leaves = $emp_leave->total_leaves;

					$leaves_in_year = $leaves_in_year_org - $tot_leaves;

					if ($leaves_in_year < 0) {

						$lop_leave_count += abs($leaves_in_year);
					}
				}
			}

			$no_of_days = ($year * 365) - $lop_leave_count;

			$tot_cal_indemninty = (30 / 365) * $year;

			$no_days = $tot_cal_indemninty * $no_of_days;

			$Indemnity  = ($basic_salary / 30) * $no_days;
		}

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$output = array(

				"amount" => number_format((float)$Indemnity, 2, '.', '')

			);

			echo json_encode($output);

			exit();
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}
	public function get_indemninty_calc()
	{

		$data['title'] = $this->Xin_model->site_title();

		$yr = $this->uri->segment(4);

		//$ye_data = explode("-", $yr);
		//$year = $ye_data[0];
		$end_date = $yr;
		$start_date = $this->uri->segment(5);
		$user_id = $this->uri->segment(6);

		$result = $this->Employees_model->read_employee_information($user_id);

		if (is_null($result)) {

			redirect('admin/employees');
		}
		$totl_num_days_pres = 0;

		$basic_salary  = $result[0]->basic_salary;

		$joing_date  = $result[0]->date_of_joining;

		$Indemnity = $total_years = 0;
		$Indemnity = $total_years = 0;




		$d1 = new DateTime($start_date);
		$d2 = new DateTime($end_date);
		$diff = $d2->diff($d1);

		$checkYearExists = $this->Employees_model->CheckEmployeeYearExistsIndemnity($user_id);
		if ($checkYearExists) {
			foreach ($checkYearExists as $val_years) {
				$total_years += $val_years->year;
			}
			$year = $diff->y;
		} else {
			$year = $diff->y + 1;
		}

		$year_text =  $total_years + $year;
		if ($year < 1) {
			$year = 1;
		}

		//Using attendance;
		$arry_years = array();
		$st = '';
		$p_count_val = 0;
		$start_date_co = $start_date;
		$end_date_co = $end_date;
		$off_day_arr = array();
		$holiday_arr = array();
		$office_shift = $this->Timesheet_model->read_office_shift_information($result[0]->office_shift_id);

		$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
		$absent_count = 0;
		$leave_count = 0;
		$user = $this->Xin_model->read_user_info($user_id);
		$Indemnity = 0;
		if ($user[0]->date_of_leaving) {
			if (strtotime($start_date) > strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving)))) {
				$difference_days  = 0;
				$pre_days = 0;
				$output = array(
					"amount" => number_format((float)$Indemnity, 3, '.', ''),
					"year" => 0

				);
				echo json_encode($output);
				exit();
			} else if (strtotime($end_date) >= strtotime($user[0]->date_of_leaving)) {

				$startDate = new DateTime($start_date);
				$endDate = new DateTime($user[0]->date_of_leaving);
				$difference = $endDate->diff($startDate);
				$difference_days  = $difference->format("%a") + 1;
				$startDate = $start_date;
				$endDate = $user[0]->date_of_leaving;
			} else {
				$startDate = new DateTime($start_date);
				$endDate = new DateTime($end_date);
				$difference = $endDate->diff($startDate);
				$difference_days  = $difference->format("%a") + 1;
				$startDate = $start_date;
				$endDate = $end_date;
				//	$endDate = date('Y-m-d', strtotime($endDate . ' +1 day'));
			}
		} else {
			$startDate = new DateTime($start_date);
			$endDate = new DateTime($end_date);
			$difference = $endDate->diff($startDate);
			$difference_days  = $difference->format("%a") + 1;
			$startDate = $start_date;
			$endDate = $end_date;
			//$endDate = date('Y-m-d', strtotime($endDate . ' +1 day'));
		}


		//Ideminity common
		$Indemnity = $this->Xin_model->Inderminity_calc_common($year, $year_text, $total_years, $user[0]->date_of_leaving, $result[0]->office_shift_id, $startDate, $endDate, $result[0]->company_id, $result[0]->user_id, $difference_days, $basic_salary);
		//end inderminity common


		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$output = array(

				"amount" => number_format((float)$Indemnity, 3, '.', ''),
				"year" => $year

			);

			echo json_encode($output);

			exit();
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}
	public function employee_indemnity_option_validate()
	{

		if ($this->input->post('type') == 'employee_update_indemnity') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$st_date = strtotime($this->input->post('start_date_inderminity'));
			$ed_date = strtotime($this->input->post('end_date_inderminity'));
			if ($this->input->post('start_date_inderminity') === '') {

				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date_inderminity') === '') {

				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('indemninty_amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('indemninty_month') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_retrive_month');
			} else if ($this->input->post('indemninty_amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			} else if ($this->input->post('balance_amount') < 0) {

				$Return['error'] = 'Negative value is not allowed in balance amount';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function employee_indemnity_option()
	{

		if ($this->input->post('type') == 'employee_update_indemnity') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$st_date = strtotime($this->input->post('start_date_inderminity'));
			$ed_date = strtotime($this->input->post('end_date_inderminity'));
			if ($this->input->post('start_date_inderminity') === '') {

				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date_inderminity') === '') {

				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('indemninty_amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('indemninty_month') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_retrive_month');
			} else if ($this->input->post('indemninty_amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			} else if ($this->input->post('balance_amount') < 0) {

				$Return['error'] = 'Negative value is not allowed in balance amount';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			/*$yr = $this->input->post('indemninty_years_count');

			$ye_data = explode("-", $yr);

			$year = $ye_data[0];

			$year_desc = $ye_data[1];*/
			$balance_old=$this->input->post('indemninty_balance');
		
			$inderminty_id=$this->input->post('indemninty_id');
			$year = $this->input->post('indemninty_yrs_count');
			$year_desc =  $this->input->post('start_date_inderminity') . 'to' . $this->input->post('end_date_inderminity');
			$data = array(

				'year' => $year,

				'amount' => $this->input->post('indemninty_amount'),
				'balance_amount' => $this->input->post('balance_amount'),
				'employee_id' => $this->input->post('user_id'),

				'date' => date('d-m-Y'),

				'indemninty_month' => $this->input->post('indemninty_month'),

				'year_desc' => $year_desc,

				'from_date' => $this->input->post('start_date_inderminity'),

				'to_date' => $this->input->post('end_date_inderminity'),

				'status' => $this->input->post('indminity_paid_status'),
				'by_cash' => $this->input->post('indeminity_paycash')

			);
			 $balance=$this->Employees_model->get_employee_balance($this->input->post('user_id')); 
		  if(!empty($balance))
				{
			$data2 = [
				'balance_amount_old' => $balance_old,
				'balance_amount'=>0
			];
			$this->db->where('id',$inderminty_id);
			$this->db->update('xin_employee_indemnity', $data2);
		}
	
			// 			var_dump($data);die();

			$result = $this->Employees_model->emp_indeminty_add($data);

			if ($result == TRUE) {

				$user_id =  $this->input->post('user_id');

				$date_of_joining = $this->input->post('indemninty_join');

				$arry_years = array();

				$checkYearExists = $this->Employees_model->CheckEmployeeYearExistsIndemnity($user_id);

				if ($checkYearExists) {

					foreach ($checkYearExists as $val_years) {

						$arry_years[] = $val_years->year;
					}
				}

				$from_date_submitted = '';

				if (!empty($arry_years)) {

					$from_date_submitted = $this->Employees_model->GetFromAndToDateOfIndemnity($user_id, max($arry_years));
				}

				if ($from_date_submitted) {

					$date_joins = $from_date_submitted->to_date;

					$date = date_create($date_joins);

					$date_join = date_format($date, "Y/m/d");

					$todays_date  = date('Y-m-d');

					$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));

					$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				} else {

					$date_join = $date_of_joining;

					$todays_date  = date('Y-m-d');

					$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));

					$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				}

				$data = '<option value="">Select</option>';

				if ($years > 0) {

					if (!empty($arry_years)) {

						for ($i = 1; $i <= $years; $i++) {

							$date_join_date = date('d F, Y', strtotime($date_join)) . ' to ' . (date('d F, Y', strtotime($date_join . ' + ' . $i . ' year')));

							$date_join_date_saved = date('Y/m/d', strtotime($date_join)) . ' to ' . (date('Y/m/d', strtotime($date_join . ' + ' . $i . ' year')));

							$data .= '<option value="' . $i . '-' . $date_join_date_saved . '">' . $i . '- (' . $date_join_date . ')' . '</option>';
						}
					} else {

						for ($i = 1; $i <= $years; $i++) {

							$date_join_date = date('d F, Y', strtotime($date_join)) . ' to ' . (date('d F, Y', strtotime($date_join . ' + ' . $i . ' year')));

							$date_join_date_saved = date('Y/m/d', strtotime($date_join)) . ' to ' . (date('Y/m/d', strtotime($date_join . ' + ' . $i . ' year')));

							$data .= '<option value="' . $i . '-' . $date_join_date_saved . '">' . $i . '- (' . $date_join_date . ')' . '</option>';
						}
					}
				}

				$Return['result_data'] = $data;

				$Return['result'] = $this->lang->line('xin_employee_set_indemnity_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}
		
			$this->output($Return);

			exit;
		}
	}

	public function employee_indemnity_option_bk()
	{

		if ($this->input->post('type') == 'employee_update_indemnity') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('indemninty_years_count') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_year');
			} else if ($this->input->post('indemninty_amount') === '') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');
			} else if ($this->input->post('indemninty_month') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_retrive_month');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$yr = $this->input->post('indemninty_years_count');

			$ye_data = explode("-", $yr);

			$year = $ye_data[0];

			$year_desc = $ye_data[1];

			$data = array(

				'year' => $year,

				'amount' => $this->input->post('indemninty_amount'),
				'balance_amount' => $this->input->post('balance_amount'),
				'employee_id' => $this->input->post('user_id'),

				'date' => date('d-m-Y'),

				'indemninty_month' => $this->input->post('indemninty_month'),

				'year_desc' => $year_desc,

				'from_date' => $this->input->post('indemninty_from_date'),

				'to_date' => $this->input->post('indemninty_to_date'),

				'status' => $this->input->post('indminity_paid_status'),
				'by_cash' => $this->input->post('indeminity_paycash')

			);

			$result = $this->Employees_model->emp_indeminty_add($data);

			if ($result == TRUE) {

				$user_id =  $this->input->post('user_id');

				$date_of_joining = $this->input->post('indemninty_join');

				$arry_years = array();

				$checkYearExists = $this->Employees_model->CheckEmployeeYearExistsIndemnity($user_id);

				if ($checkYearExists) {

					foreach ($checkYearExists as $val_years) {

						$arry_years[] = $val_years->year;
					}
				}

				$from_date_submitted = '';

				if (!empty($arry_years)) {

					$from_date_submitted = $this->Employees_model->GetFromAndToDateOfIndemnity($user_id, max($arry_years));
				}

				if ($from_date_submitted) {

					$date_joins = $from_date_submitted->to_date;

					$date = date_create($date_joins);

					$date_join = date_format($date, "Y/m/d");

					$todays_date  = date('Y-m-d');

					$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));

					$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				} else {

					$date_join = $date_of_joining;

					$todays_date  = date('Y-m-d');

					$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));

					$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				}

				$data = '<option value="">Select</option>';

				if ($years > 0) {

					if (!empty($arry_years)) {

						for ($i = 1; $i <= $years; $i++) {

							$date_join_date = date('d F, Y', strtotime($date_join)) . ' to ' . (date('d F, Y', strtotime($date_join . ' + ' . $i . ' year')));

							$date_join_date_saved = date('Y/m/d', strtotime($date_join)) . ' to ' . (date('Y/m/d', strtotime($date_join . ' + ' . $i . ' year')));

							$data .= '<option value="' . $i . '-' . $date_join_date_saved . '">' . $i . '- (' . $date_join_date . ')' . '</option>';
						}
					} else {

						for ($i = 1; $i <= $years; $i++) {

							$date_join_date = date('d F, Y', strtotime($date_join)) . ' to ' . (date('d F, Y', strtotime($date_join . ' + ' . $i . ' year')));

							$date_join_date_saved = date('Y/m/d', strtotime($date_join)) . ' to ' . (date('Y/m/d', strtotime($date_join . ' + ' . $i . ' year')));

							$data .= '<option value="' . $i . '-' . $date_join_date_saved . '">' . $i . '- (' . $date_join_date . ')' . '</option>';
						}
					}
				}

				$Return['result_data'] = $data;

				$Return['result'] = $this->lang->line('xin_employee_set_indemnity_success');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function emp_all_indemnity()
	{

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$allowances = $this->Employees_model->set_employee_indemnity($id);



		$data = array();

		$status = '';

		foreach ($allowances->result() as $r) {
			if ($r->status == 1) {
				$status = 'Unpaid';
			} else if ($r->status == 2) {
				$status = 'Paid';
			}
			$act = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '" data-field_type="emp_indeminty"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="all_emp_indeminty"><span class="fas fa-trash-restore"></span></button></span>';
			$year_desc = date('d F, Y', strtotime($r->from_date)) . ' to ' . (date('d F, Y', strtotime($r->to_date)));

			if ($r->by_cash == 'on') {
				$status_cash = 'Yes';
			} else {
				$status_cash = 'No';
			}

			$data[] = array(



				$r->year . '- (' . $year_desc . ')',

				$r->amount,
				$r->balance_amount,
				$r->indemninty_month,

				$status,
				$status_cash,
				$act,


			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $allowances->num_rows(),

			"recordsFiltered" => $allowances->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function delete_all_emp_indeminty()
	{

		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_emp_indeminty($id);

			if (isset($id)) {

				$Return['result'] = 'Deleted';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	public function dialog_emp_indeminty()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function edit_indeminty_details_validate()
	{

		if ($this->input->post('type') == 'edit_indeminty_details') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			/*if($this->input->post('indemninty_years_count')==='') {

				$Return['error'] = $this->lang->line('xin_employee_error_year');

			} else if($this->input->post('indemninty_amount')==='') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');

			}else*/

			if ($this->input->post('indemninty_month') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_retrive_month');
			} else if ($this->input->post('paid_amount') < 0) {

				$Return['error'] = 'Negative value is not allowed';
			} else if ($this->input->post('balance_amount') < 0) {

				$Return['error'] = 'Negative value is not allowed in balance amount';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function edit_indeminty_details()
	{
		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		/* Server side PHP input validation */

		/*if($this->input->post('indemninty_years_count')==='') {

				$Return['error'] = $this->lang->line('xin_employee_error_year');

			} else if($this->input->post('indemninty_amount')==='') {

				$Return['error'] = $this->lang->line('xin_error_amount_field');

			}else*/

		if ($this->input->post('indemninty_month') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_retrive_month');
		} else if ($this->input->post('paid_amount') < 0) {

			$Return['error'] = 'Negative value is not allowed';
		} else if ($this->input->post('balance_amount') < 0) {

			$Return['error'] = 'Negative value is not allowed in balance amount';
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		}

		/*$yr = $this->input->post('indemninty_years_count');

			$ye_data = explode("-",$yr);

			$year = $ye_data[0];

			$year_desc = $ye_data[1];*/

		$data = array(

			//'year' => $year,

			//'amount' => $this->input->post('indemninty_amount'),

			'indemninty_month' => $this->input->post('indemninty_month'),
			'amount' => $this->input->post('paid_amount'),
			'balance_amount' => $this->input->post('balance_amount'),
			'status' => $this->input->post('indminity_paid_status_edit'),
			'by_cash' => $this->input->post('indeminity_paycash_edit')
			//'year_desc'=>$year_desc

		);

		$e_field_id = $this->input->post('e_field_id');

		$result = $this->Employees_model->indeminty_details_update($data, $e_field_id);

		if ($result == TRUE) {

			$Return['result'] = $this->lang->line('xin_employee_indemnity_info_updated');
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}

	public function change_status()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$id = $this->input->get('id');

		$status = $this->input->get('status');

		$data = array(

			'status' => $status

		);

		$result = $this->Employees_model->salary_allowance_update_record($data, $id);

		if ($result == TRUE) {

			$Return['result'] = $this->lang->line('xin_employee_updated_allowance_success');
		} else {

			$Return['result'] = $this->lang->line('xin_error_msg');
		}



		$this->output($Return);

		exit;
	}

	public function update_status_commissions()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$id = $this->input->get('id');

		$status = $this->input->get('status');

		$data = array(

			'status' => $status

		);

		$result = $this->Employees_model->salary_commissions_update_record($data, $id);

		if ($result == TRUE) {

			$Return['result'] = $this->lang->line('xin_employee_update_commission_success');
		} else {

			$Return['result'] = $this->lang->line('xin_error_msg');
		}



		$this->output($Return);

		exit;
	}

	public function update_status_deductions()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$id = $this->input->get('id');

		$status = $this->input->get('status');

		$data = array(

			'status' => $status

		);

		$result = $this->Employees_model->salary_statutory_deduction_update_record($data, $id);

		if ($result == TRUE) {

			$Return['result'] = $this->lang->line('xin_employee_update_statutory_deduction_success');
		} else {

			$Return['result'] = $this->lang->line('xin_error_msg');
		}



		$this->output($Return);

		exit;
	}

	public function update_status_other_payments()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$id = $this->input->get('id');

		$status = $this->input->get('status');

		$data = array(

			'status' => $status

		);

		$result = $this->Employees_model->salary_other_payment_update_record($data, $id);

		if ($result == TRUE) {

			$Return['result'] = $this->lang->line('xin_employee_update_otherpayments_success');
		} else {

			$Return['result'] = $this->lang->line('xin_error_msg');
		}



		$this->output($Return);

		exit;
	}

	public function update_status_loans()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$id = $this->input->get('id');

		$status = $this->input->get('status');

		$data = array(

			'loan_status' => $status

		);

		$result = $this->Employees_model->salary_loan_update_record($data, $id);

		if ($result == TRUE) {

			$Return['result'] = $this->lang->line('xin_employee_update_loan_success');
		} else {

			$Return['result'] = $this->lang->line('xin_error_msg');
		}



		$this->output($Return);

		exit;
	}

	public function dialog_leave_carryforward()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function add_leave_carryforward()
	{

		if ($this->input->post('type') == 'add_leave_carryforward') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('remaining_leaves') === '') {

				$Return['error'] = 'Please add carry forwarded leaves';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$Cond = array(

				'leave_type_id' => $this->input->post('e_field_id'),

				'employee_id' => $this->input->post('user_id'),

				'leave_start_date >=' => $this->input->post('leave_start_date'),

				'leave_ending_date <=' => $this->input->post('leave_ending_date'),

			);

			$check_already_exists_or_not = $this->Employees_model->check_already_exists_leave_carryforward($Cond);

			if (empty($check_already_exists_or_not)) {

				$data = array(

					'remaining_leaves' => $this->input->post('remaining_leaves'),

					'leave_type_id' => $this->input->post('e_field_id'),

					'employee_id' => $this->input->post('user_id'),

					'leave_start_date' => $this->input->post('leave_start_date'),

					'leave_ending_date' => $this->input->post('leave_ending_date'),

					'total' => $this->input->post('remaining_leaves')

				);

				$result = $this->Employees_model->add_leave_carry_forward($data);
			} else {

				$data = array(

					'remaining_leaves' => $this->input->post('remaining_leaves'),

					'leave_type_id' => $this->input->post('e_field_id'),

					'employee_id' => $this->input->post('user_id'),

					'leave_start_date' => $this->input->post('leave_start_date'),

					'leave_ending_date' => $this->input->post('leave_ending_date'),

					'total' => $this->input->post('remaining_leaves')

				);

				$result = $this->Employees_model->edit_common('xin_employees_leave_carryfowards', $Cond, $data);
			}



			if ($result == TRUE) {

				if ($this->input->post('leave_carryforward_id') > 0) {

					$carry_details = $this->Timesheet_model->GetCarrySingleData($this->input->post('leave_carryforward_id'));
					if ($carry_details) {

						$carry_now = $carry_details[0]->remaing_leave_count - $this->input->post('remaining_leaves');

						if ($carry_now >= 0) {

							$carry_now = $carry_now;
						} else {

							$carry_now = 0;
						}

						$data_update = array(

							'remaing_leave_count' => $carry_now

						);

						$data_result = $this->Timesheet_model->carry_update($data_update, $this->input->post('leave_carryforward_id'));

						$starting_date_next = $this->input->post('leave_ending_date');

						$ending_date_next = date('Y-m-d', strtotime($this->input->post('leave_ending_date') . ' + 1 year'));

						//	$find_all_total_carry = $this->Timesheet_model->carryLeavesData($this->input->post('user_id'), $this->input->post('e_field_id'), $starting_date_next, $ending_date_next);
						$find_all_total_carry = $this->Timesheet_model->annual_leave_availablefor_emp_carry($this->input->post('user_id'), 3);


						//$emp_leave_details = $this->Employees_model->emp_leave_taken_for_leave_his($this->input->post('user_id'), $starting_date_next, $ending_date_next, $this->input->post('e_field_id'));
						$emp_leave_details = $this->Timesheet_model->annual_leave_availablefor_emp($this->input->post('user_id'), 3);
						if ($find_all_total_carry) {
							if (date('Y', strtotime($find_all_total_carry[0]->create_date)) == date('Y')) {
								$carry_now_next = $find_all_total_carry[0]->remaing_leave_count + $this->input->post('remaining_leaves');
								if ($carry_now_next >= 0) {
									$carry_now_next = $carry_now_next;
								} else {
									$carry_now_next = 0;
								}
								$data_update1 = array(
									'remaing_leave_count' => $carry_now_next
								);

								$data_result = $this->Timesheet_model->carry_update($data_update1, $find_all_total_carry[0]->id);
							} else {
								if ($emp_leave_details) {
									$carry_now_next = $emp_leave_details[0]->leave_count + $this->input->post('remaining_leaves');
									$data_insert = array(
										'employee_id' => $this->input->post('user_id'),
										'leave_type_id' => $this->input->post('e_field_id'),
										'remaing_leave_count' => $carry_now_next,
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								}
							}
						} else {

							if ($emp_leave_details) {

								$carry_now_next = $emp_leave_details[0]->leave_count + $this->input->post('remaining_leaves');
								$data_insert = array(

									'employee_id' => $this->input->post('user_id'),

									'leave_type_id' => $this->input->post('e_field_id'),

									'remaing_leave_count' => $carry_now_next,

									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							}
						}

						if ($emp_leave_details) {

							$empl_now_next = $emp_leave_details[0]->leave_count + $this->input->post('remaining_leaves');

							$data_update2 = array(

								'leave_count' => $empl_now_next

							);

							$data_result = $this->Timesheet_model->emp_leave_update($data_update2, $emp_leave_details[0]->id);
						}
					}
				}

				$Return['result'] = $this->lang->line('xin_leave_carryfoward_completed');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function dialog_leave_encashment()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function add_leave_encashment()
	{

		if ($this->input->post('type') == 'add_leave_encashment') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$remaining_leaves = $this->input->post('remaining_leaves');

			$current_leave_ench = $this->input->post('current_leave_ench');

			if ($this->input->post('remaining_leaves') == '') {

				$Return['error'] = 'Please add count of leaves encashed';
			} else if ($current_leave_ench < $remaining_leaves) {

				$Return['error'] = 'You have ' . $this->input->post('current_leave_ench') . ' leaves for encash. Leave count must be less than ' . $this->input->post('current_leave_ench');
			} else if (empty($this->input->post('leave_encashment_month'))) {

				$Return['error'] = 'Retrive month field is required';
			} else if (empty($this->input->post('encashment_amt'))) {

				$Return['error'] = 'Amount field is required';
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$Cond = array(

				'leave_type_id' => $this->input->post('e_field_id'),

				'employee_id' => $this->input->post('user_id'),

				'leave_start_date >=' => $this->input->post('leave_start_date'),

				'leave_ending_date <=' => $this->input->post('leave_ending_date'),

			);

			$check_already_exists_or_not = $this->Employees_model->check_already_exists_leave_encashment($Cond);

			if (empty($check_already_exists_or_not)) {

				$data = array(

					'remaining_leaves' => $this->input->post('remaining_leaves'),

					'leave_type_id' => $this->input->post('e_field_id'),

					'employee_id' => $this->input->post('user_id'),

					'leave_start_date' => $this->input->post('leave_start_date'),

					'leave_ending_date' => $this->input->post('leave_ending_date'),

					'amount' => $this->input->post('encashment_amt'),

					'retrive_month' => $this->input->post('leave_encashment_month')

				);

				$result = $this->Employees_model->add_employees_leave_encashment($data);
			} else {

				$data = array(

					'remaining_leaves' => $this->input->post('remaining_leaves'),

					'leave_type_id' => $this->input->post('e_field_id'),

					'employee_id' => $this->input->post('user_id'),

					'leave_start_date' => $this->input->post('leave_start_date'),

					'leave_ending_date' => $this->input->post('leave_ending_date'),

					'amount' => $this->input->post('encashment_amt'),

					'retrive_month' => $this->input->post('leave_encashment_month')

				);

				$result = $this->Employees_model->edit_common('xin_employees_leave_encashment', $Cond, $data);
			}



			if ($result == TRUE) {

				if ($this->input->post('leave_carryforward_id') > 0) {

					$carry_details = $this->Timesheet_model->GetCarrySingleData($this->input->post('leave_carryforward_id'));

					if ($carry_details) {

						$carry_now = $carry_details[0]->remaing_leave_count - $this->input->post('remaining_leaves');

						if ($carry_now >= 0) {

							$carry_now = $carry_now;
						} else {

							$carry_now = 0;
						}

						$data_update = array(

							'remaing_leave_count' => $carry_now

						);

						$data_result = $this->Timesheet_model->carry_update($data_update, $this->input->post('leave_carryforward_id'));
					}
				}

				$Return['result'] = $this->lang->line('xin_leave_encashment_completed');
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}


	public function manage_leave_update_validate()
	{

		if ($this->input->post('type') == 'manage_leave_update') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$get_id = $this->Timesheet_model->get_id($this->input->post('type_name'));

			if ($get_id[0]->leave_type_id == 4) {

				if ($this->input->post('paid_sick_leave') == '') {
					$Return['error'] = 'Paid sick leave count is required';
				} else if ($this->input->post('halfpaid_sick_leave_count') == '') {
					$Return['error'] = 'Half paid sick leave count is required';
				} else if ($this->input->post('unpaid_sick_leave') == '') {
					$Return['error'] = 'Unpaid sick leave count is required';
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
				$total_sick = $this->input->post('paid_sick_leave') + $this->input->post('halfpaid_sick_leave_count') + $this->input->post('unpaid_sick_leave');
				if ($total_sick != $this->input->post('leave_count')) {
					$Return['error'] = 'Sick leave count  breakup is not matching to the Leave Assigned For Employee';
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
			}

			$this->output($Return);
			exit;
		}
	}

	public function manage_leave_update()
	{

		if ($this->input->post('type') == 'manage_leave_update') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$get_id = $this->Timesheet_model->get_id($this->input->post('type_name'));

			if ($get_id[0]->leave_type_id == 4) {
				/*$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($this->input->post('user_id'), $get_id[0]->leave_type_id);
				if(isset($carry_count[0]->create_date)){
					$yr_check_sick = date('Y', strtotime($carry_count[0]->create_date));
				}else{
					$yr_check_sick = date('Y');
				}				
				$total_paid_count_exits = $this->Timesheet_model->select_leave_paid_list($this->input->post('user_id'), $yr_check_sick);
				if (isset($total_paid_count_exits[0]->id)) {
					$total_sick_leave_count = $total_paid_count_exits[0]->total_paid_counts + $total_paid_count_exits[0]->total_half_paid_counts + $total_paid_count_exits[0]->total_unpaid_counts;
				}*/


				if ($this->input->post('paid_sick_leave') == '') {
					$Return['error'] = 'Paid sick leave count is required';
				} else if ($this->input->post('halfpaid_sick_leave_count') == '') {
					$Return['error'] = 'Half paid sick leave count is required';
				} else if ($this->input->post('unpaid_sick_leave') == '') {
					$Return['error'] = 'Unpaid sick leave count is required';
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
				$total_sick = $this->input->post('paid_sick_leave') + $this->input->post('halfpaid_sick_leave_count') + $this->input->post('unpaid_sick_leave');
				if ($total_sick != $this->input->post('leave_count')) {
					$Return['error'] = 'Sick leave count  breakup is not matching to the Leave Assigned For Employee';
				}
				if ($Return['error'] != '') {
					$this->output($Return);
				}
				$data = array(
					'paid_sick_leave_count' => $this->input->post('paid_sick_leave'),
					'half_paid_sick_leave_count' => $this->input->post('halfpaid_sick_leave_count'),
					'unpaid_sick_leave_count' => $this->input->post('unpaid_sick_leave')
				);
				$res_sick_sub =  $this->Employees_model->update_record($data, $this->input->post('user_id'));
			}


			$data = array(
				'leave_type' => $get_id[0]->leave_type_id,
				'leave_count' => $this->input->post('leave_count')
			);
			$e_field_id = $this->input->post('e_field_id');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			if ($this->input->post('save_leave_status') == 'pending') {
				$result = $this->Timesheet_model->leave_update($data, $e_field_id);
			} else if ($this->input->post('save_leave_status') == 'rejected') {
				$result = $this->Employees_model->leave_info_rejected($e_field_id);
			} else if ($this->input->post('save_leave_status') == 'approved') {
				$result = $this->Employees_model->leave_info_approved($data, $e_field_id);
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$result = $this->Employees_model->leave_info_approved($data, $e_field_id);
				} else {
					$result = $this->Timesheet_model->leave_update($data, $e_field_id);
				}
			}
			//	header("Refresh:0; url=page2.php");
			if ($result == TRUE) {

				$check_leave_remaining_section_is_there = $this->Timesheet_model->get_employee_extra_remaining_leaves($this->input->post('user_id'), $get_id[0]->leave_type_id);
				if ($check_leave_remaining_section_is_there) {
					$old_count = $this->input->post('old_leave_count');
					$addition_day_added =  $old_count - $this->input->post('leave_count');
					if ($old_count < $this->input->post('leave_count')) {
						if ($addition_day_added > 0) {
							$remaing_leave_count = $check_leave_remaining_section_is_there[0]->remaing_leave_count + $addition_day_added;
						} else {
							$remaing_leave_count = $check_leave_remaining_section_is_there[0]->remaing_leave_count - $addition_day_added;
							if ($remaing_leave_count < 0) {
								$remaing_leave_count = 0;
							}
						}
					} else {
						$remaing_leave_count = $this->input->post('leave_count');
					}

					$data = array('remaing_leave_count' => $remaing_leave_count);
					$carry = $this->Timesheet_model->carry_update($data, $check_leave_remaining_section_is_there[0]->id);
				}
				$Return['result'] = $this->lang->line('xin_employee_leave_info_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function make_user_to_blacklist()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$id = $this->input->get('id');
		$status = $this->input->get('status');
		$data = array(
			'black_list_status' => $status
		);
		$result = $this->Employees_model->update_record($data, $id);
		if ($result == TRUE) {
			$Return['result'] = 'Black List Updated';
		} else {
			$Return['result'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
	}
	public function dialog_salary_loan_extend()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('field_id');
		$result = $this->Employees_model->read_single_loan_deductions($id);
		if ($result) {
			$data = array(
				'loan_deduction_id' => $result[0]->loan_deduction_id,
				'employee_id' => $result[0]->employee_id,
				'loan_deduction_title' => $result[0]->loan_deduction_title,
				'start_date' => $result[0]->start_date,
				'end_date' => $result[0]->end_date,
				'loan_options' => $result[0]->loan_options,
				'monthly_installment' => $result[0]->monthly_installment,
				'reason' => $result[0]->reason,
				'created_at' => $result[0]->created_at
			);
		}
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {
			redirect('admin/');
		}
	}
	public function update_loan_info_extend_validate()
	{
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$reason = $this->input->post('reason');
		$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$end_date_old = $this->input->post('old_end_date_new');
		$st_date = strtotime($start_date);
		$ed_date = strtotime($end_date);
		$old_end_date = strtotime($end_date_old);
		$id = $this->input->post('e_field_id');
		/* Server side PHP input validation */
		if ($this->input->post('start_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_start_date');
		} else if ($this->input->post('end_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_end_date');
		} else if ($st_date > $ed_date) {
			$Return['error'] = $this->lang->line('xin_error_start_end_date');
		} else if ($ed_date <= $old_end_date) {
			$Return['error'] = 'End date must be greater than the existing end date';
		}
		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$this->output($Return);
		exit;
	}

	public function update_loan_info_extend()
	{
		if ($this->input->post('type') == 'loan_info_extend') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$end_date_old = $this->input->post('old_end_date_new');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$old_end_date = strtotime($end_date_old);
			$id = $this->input->post('e_field_id');
			/* Server side PHP input validation */
			if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($ed_date <= $old_end_date) {
				$Return['error'] = 'End date must be greater than the existing end date';
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$start    = new DateTime($this->input->post('start_date'));
			$start->modify('first day of this month');
			$end      = new DateTime($this->input->post('end_date'));
			$end->modify('first day of next month');
			$interval = DateInterval::createFromDateString('1 month');
			$period   = new DatePeriod($start, $interval, $end);
			$array_dates = array();
			foreach ($period as $dt) {
				$array_dates[] = $dt->format("Y-m");
			}
			$tm = count($array_dates);
			if ($tm < 1) {
				$m_ins = $this->input->post('monthly_installment');
			} else {
				$m_ins = $this->input->post('monthly_installment') / $tm;
			}

			$data = array(
				'reason' => $qt_reason,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'loan_time' => $tm,
			);
			$result = $this->Employees_model->salary_loan_update_record($data, $id);

			if ($result == TRUE) {
				$paid_amount = 0;
				$get_loan_distrubtion = $this->Employees_model->get_employee_loan_distrubtion($this->input->post('user_id'), $id);
				if ($get_loan_distrubtion) {
					$last_date = $this->Employees_model->get_employee_loan_distrubtion_latest($this->input->post('user_id'), $id);
					if ($last_date) {
						foreach ($get_loan_distrubtion as $val) {
							if ($val->month_year > date('Y-m', strtotime($this->input->post('end_date')))) {
								$dlt_loan_distribution_list =  $this->Employees_model->delete_loan_distribution_list_de($val->id);
							}
						}
						$latest_loan_due_year = strtotime($last_date[0]->month_year);
						$next_start = date("Y-m", strtotime("+1 month", $latest_loan_due_year));
						$start    = new DateTime($next_start);
						$start->modify('first day of this month');
						$end      = new DateTime($this->input->post('end_date'));
						$end->modify('first day of next month');
						$interval = DateInterval::createFromDateString('1 month');
						$period   = new DatePeriod($start, $interval, $end);
						foreach ($period as $dt) {
							$data1 = array(
								'loan_id' => $id,
								'month_year' => $dt->format("Y-m"),
								'amount' => 0,
								'employee_id' => $this->input->post('user_id')
							);
							$result_1 = $this->Employees_model->add_salary_loan_month_wise_dedec($data1);
						}
					}
					//$dlt_loan_distribution_list =  $this->Employees_model->delete_loan_distribution_list($this->input->post('user_id'),$id);				
				} else {
					$start    = new DateTime($this->input->post('start_date'));
					$start->modify('first day of this month');
					$end      = new DateTime($this->input->post('end_date'));
					$end->modify('first day of next month');
					$interval = DateInterval::createFromDateString('1 month');
					$period   = new DatePeriod($start, $interval, $end);
					foreach ($period as $dt) {
						$data1 = array(
							'loan_id' => $id,
							'month_year' => $dt->format("Y-m"),
							'amount' => $m_ins,
							'employee_id' => $this->input->post('user_id')
						);
						$result_1 = $this->Employees_model->add_salary_loan_month_wise_dedec($data1);
					}
				}

				$Return['result'] = $this->lang->line('xin_employee_update_loan_success');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function visa_info_validate()
	{
		if ($this->input->post('type') == 'visa_info' && $this->input->post('data') == 'visa_info') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('visa_id') === '') {

				$Return['error'] = 'Enter the Visa ID';
			} else if ($this->input->post('title') === '') {

				$Return['error'] = 'Enter the Title';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}



			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/visa/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);
			exit;
		}
	}

	public function visa_info()
	{
		if ($this->input->post('type') == 'visa_info' && $this->input->post('data') == 'visa_info') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('visa_id') === '') {

				$Return['error'] = 'Enter the Visa ID';
			} else if ($this->input->post('title') === '') {

				$Return['error'] = 'Enter the Title';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}


			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$fname = '';
			} else {

				$fname = $this->input->post('attachment');
			}
		}




		if ($Return['error'] != '') {

			$this->output($Return);
		}

		$description = $this->input->post('reason');

		$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

		$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));


		$data = array(

			'visa_id_num' => $this->input->post('visa_id'),

			'title' => $this->input->post('title'),

			'file' => $fname,

			'issue_date' => $issue_date,

			'expiry_date' => $expiry_date,

			'employee_id' => $this->input->post('user_id'),

			'description' => $description,

			'created_at' => date('d-m-Y h:i:s'),

		);

		$result = $this->Employees_model->visa_info_add($data);



		if ($result == TRUE) {

			$Return['result'] = 'Visa Details Added Success';
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}


	public function visa()
	{


		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$visa = $this->Employees_model->set_employee_visa($id);



		$data = array();



		foreach ($visa->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);


			$update_value = $r->update_value;
			if ($update_value) {

				$color = 'red';
				$data[] = array(


					$r->visa_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->visa_id . '" data-field_type="visadocument">
				<i class="fas fa-pencil-alt" style="
    /* background-color: red; */
    /* border: solid 2px;
     /*padding: 3px;
     /*border-radius: 8px;
    /* border: 9px; */
    /* color: red; */
"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->visa_id . '" data-token_type="visadocument">
				<i class="fas fa-trash-restore"></i></button></span>',

					$color,



				);
			} else {

				$color = 'green';
				$data[] = array(



					$r->visa_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->visa_id . '" data-field_type="visadocument">
				<i class="fas fa-pencil-alt"style="
    /* background-color: red; */
    /* border: solid 2px;
     /*padding: 3px;
     /*border-radius: 8px;
    /* border: 9px; */
    /* color: green; */
"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->visa_id . '" data-token_type="visadocument">
				<i class="fas fa-trash-restore"></i></button></span>',

					$color,

					// 			$c_name,

					// 			$eligible_review_date,

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $visa->num_rows(),

			"recordsFiltered" => $visa->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function dialog_visadocument()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_visadocument_information($id);

		$update_value = $document[0]->update_value;

		if ($update_value) {
			$data_new = (unserialize($update_value));
			//print_r($data_new);

			if ($document[0]->visa_id_num != $data_new['visa_id_num']) {
				$visa_up_num = 'VISA Number :' . $data_new['visa_id_num'];
			} else {
				$visa_up_num = '';
			}

			if ($document[0]->title != $data_new['title']) {
				$Title = 'Title : ' . $data_new['title'];
			} else {
				$Title = '';
			}

			if ($document[0]->file != $data_new['file']) {

				$File = 'File :' . $data_new['file'];
			} else {
				$File = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$issue_date = 'Issue date :' . $data_new['issue_date'];
			} else {
				$issue_date = '';
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$expiry_date = 'Expiry date :' . $data_new['expiry_date'];
			} else {
				$expiry_date = '';
			}
			if ($document[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}

			$data = array(

				'visa_up_num' => $data_new['visa_id_num'],
				'visa_id' => $document[0]->visa_id,
				'title' => $data_new['title'],
				'd_employee_id' => $document[0]->employee_id,
				'document_file' => $data_new['file'],
				'issue_date' => $data_new['issue_date'],
				'expiry_date' => $data_new['expiry_date'],
				'description' => $data_new['description'],
				'update_value' => 'yes',
				//   'visa_id' => $visa_id,
				'Title' => $Title,
				'File' => $File,
				'Issue_date' => $issue_date,
				'Expiry_date' => $expiry_date,
				'description_new' => $description_new,

			);
		} else {

			$data = array(

				'visa_up_num' => $document[0]->visa_id_num,
				'visa_id' => $document[0]->visa_id,
				'title' => $document[0]->title,
				'd_employee_id' => $document[0]->employee_id,
				'document_file' => $document[0]->file,
				'issue_date' => $document[0]->issue_date,
				'expiry_date' => $document[0]->expiry_date,
				'description' => $document[0]->description,
				'update_value' => 'no',

			);
		}

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function e_visa_info_validate()
	{

		if ($this->input->post('type') == 'e_visa_info' && $this->input->post('data') == 'e_visa_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			if ($this->input->post('visa_num') === '') {

				$Return['error'] = "Enter the Visa Number";
			} else if ($this->input->post('title') === '') {

				$Return['error'] = "Enter the Title";
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			}

			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] != 0) {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/visa/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
						$this->output($Return);
						exit;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$Return['error'] = '';
			$this->output($Return);

			exit;
		}
	}

	public function e_visa_info()
	{

		$session = $this->session->userdata('username');

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('visa_num') === '') {

			$Return['error'] = "Enter the Visa Number";
		} else if ($this->input->post('title') === '') {

			$Return['error'] = "Enter the Title";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}



		if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {


			$title = $this->input->post('update');
	
			if (($title == 'Approved') || ($session['user_id'])) {


				$update_value = '';
				$data = array(

					'visa_id_num' => $this->input->post('visa_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					//  'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'visa_id_num' => $this->input->post('visa_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $this->input->post('hello'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr

				);
			}


			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->visa_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = "Updated Success";
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		} else {

			$fname = $this->input->post('attachment');


			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(

					'visa_id_num' => $this->input->post('visa_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'visa_id_num' => $this->input->post('visa_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr

				);
			}



			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->visa_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = 'Update Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}



		if ($Return['error'] != '') {

			$this->output($Return);
		}



		if ($result == TRUE) {

			$Return['result'] = "Added Success";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		}

		$Return['error'] = '';
		$this->output($Return);

		exit;
	}

	// public function e_visa_info(){

	//         if ($this->input->post('type') == 'e_visa_info' && $this->input->post('data') == 'e_visa_info') {

	//           /* Define return | here result is used to return user data and error for error message */

	//           $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

	//           $Return['csrf_hash'] = $this->security->get_csrf_hash();



	//           /* Server side PHP input validation */

	//           if ($this->input->post('visa_num') === '') {

	//               $Return['error'] = "Enter the Visa Number";
	//           } else if ($this->input->post('title') === '') {

	//             $Return['error'] = "Enter the Title";
	//           } else if ($this->input->post('issue_date') === '') {

	//             $Return['error'] = $this->lang->line('xin_employee_error_d_issue');
	//           } else if ($this->input->post('expiry_date') === '') {

	//             $Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
	//           }



	//           /* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {


	//                 $title = $this->input->post('update');

	//           if($title=='Approved')
	//           {


	//           $update_value='';
	//             $data = array(

	//                   'visa_id_num' => $this->input->post('visa_num'),

	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                 //  'file' => $fname,

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//                   'update_value' =>$update_value

	//                 );

	//           }

	//           elseif($title=='Rejected')


	//           {

	//              $update_value='';
	//             $data= array(
	//           'update_value' =>$update_value); 



	//           }

	//         else{

	//           $data1= array(

	//                   'visa_id_num' => $this->input->post('visa_num'),

	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                   'file' => $this->input->post('hello'),

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//             );

	//           $arr=serialize($data1);


	//             $data = array(
	//             'update_value' => $arr

	//           );  



	//           }


	//             $e_field_id = $this->input->post('e_field_id');

	//             $result = $this->Employees_model->visa_info_update($data, $e_field_id);

	//             if ($result == TRUE) {

	//               $Return['result'] = "Updated Success";
	//             } else {

	//               $Return['error'] = $this->lang->line('xin_error_msg');
	//             }

	//             $this->output($Return);

	//             exit;
	//           } 
	//           else {

	//             if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

	//               //checking image type

	//               $allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

	//               $filename = $_FILES['document_file']['name'];

	//               $ext = pathinfo($filename, PATHINFO_EXTENSION);



	//               if (in_array($ext, $allowed)) {

	//                 $tmp_name = $_FILES["document_file"]["tmp_name"];

	//                 $documentd = "uploads/document/visa/";

	//                 // basename() may prevent filesystem traversal attacks;

	//                 // further validation/sanitation of the filename may be appropriate

	//                 $name = basename($_FILES["document_file"]["name"]);

	//                 $newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

	//                 move_uploaded_file($tmp_name, $documentd . $newfilename);

	//                 $fname = $newfilename;


	//                 $title = $this->input->post('update');


	//           if($title=='Approved')
	//           {


	//           $update_value='';
	//             $data = array(

	//                   'visa_id_num' => $this->input->post('visa_num'),

	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                   'file' => $fname,

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//                   'update_value' =>$update_value

	//                 );

	//           }

	//           elseif($title=='Rejected')


	//           {

	//              $update_value='';
	//             $data= array(
	//           'update_value' =>$update_value); 



	//           }

	//         else{

	//           $data1= array(

	//                   'visa_id_num' => $this->input->post('visa_num'),

	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                   'file' => $fname,

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//             );

	//           $arr=serialize($data1);


	//             $data = array(
	//             'update_value' => $arr

	//           );  



	//           }



	//                 $e_field_id = $this->input->post('e_field_id');

	//                 $result = $this->Employees_model->visa_info_update($data, $e_field_id);

	//                 if ($result == TRUE) {

	//                   $Return['result'] = 'Update Success';
	//                 } else {

	//                   $Return['error'] = $this->lang->line('xin_error_msg');
	//                 }

	//                 $this->output($Return);

	//                 exit;
	//               } else {

	//                 $Return['error'] = $this->lang->line('xin_employee_document_file_type');
	//               }
	//             }
	//           }



	//           if ($Return['error'] != '') {

	//             $this->output($Return);
	//           }



	//           if ($result == TRUE) {

	//             $Return['result'] = "Added Success";
	//           } else {

	//             $Return['error'] = $this->lang->line('xin_error_msg');
	//           }

	//           if ($Return['error'] != '') {

	//             $this->output($Return);
	//           }

	//         $Return['error'] = '';
	//         $this->output($Return);

	//           exit;
	//         }
	// }

	public function delete_visadocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_visa_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = 'Deleted Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}
	//passport session start
	public function passport_info_validate()
	{

		if ($this->input->post('type') == 'passport_info' && $this->input->post('data') == 'passport_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('passport_id') === '') {

				$Return['error'] = 'Enter the Passport ID';
			} else if ($this->input->post('title') === '') {

				$Return['error'] = 'Enter the Title';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}



			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/passport/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function passport_info()
	{

		if ($this->input->post('type') == 'passport_info' && $this->input->post('data') == 'passport_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('passport_id') === '') {

				$Return['error'] = 'Enter the Passport ID';
			} else if ($this->input->post('title') === '') {

				$Return['error'] = 'Enter the Title';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else {
			}

			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				//checking image type

				$fname = '';
			} else {

				$fname = $this->input->post('attachment');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$description = $this->input->post('reason');

			$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

			$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));


			$data = array(

				'passport_id_num' => $this->input->post('passport_id'),

				'title' => $this->input->post('title'),

				'file' => $fname,

				'issue_date' => $issue_date,

				'expiry_date' => $expiry_date,

				'employee_id' => $this->input->post('user_id'),

				'description' => $description,

				'created_at' => date('d-m-Y h:i:s'),

			);

			$result = $this->Employees_model->passport_info_add($data);

			if ($result == TRUE) {

				$Return['result'] = 'Passport Details Added Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function passport()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$passport = $this->Employees_model->set_employee_passport($id);



		$data = array();



		foreach ($passport->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);


			$update_value = $r->update_value;
			if ($update_value) {

				$style = 'red';

				$data[] = array(


					$r->passport_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					// 			$c_name,

					// 			$eligible_review_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->passport_id . '" data-field_type="passportdocument">
						 <i class="fas fa-pencil-alt" style="
    /* background-color: red; */
    /* border: solid 2px;
     /*padding: 3px;
     /*border-radius: 8px;
    /* border: 9px; */
    /* color: red;*/
"></i>
				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->passport_id . '" data-token_type="passportdocument"><i class="fas fa-trash-restore"></i></button></span>',


					$style

				);
			} else {

				$style = '';
				$data[] = array(



					$r->passport_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					// 			$c_name,

					// 			$eligible_review_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->passport_id . '" data-field_type="passportdocument">
			 <i class="fas fa-pencil-alt" style="
    /* background-color: red; */
    /* border: solid 2px;
     /*padding: 3px;
     /*border-radius: 8px;
    /* border: 9px; */
    /* color: green; */
"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->passport_id . '" data-token_type="passportdocument">
				<i class="fas fa-trash-restore"></i></button></span>',

					$style

				);
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $passport->num_rows(),

			"recordsFiltered" => $passport->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function dialog_passportdocument()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_passportdocument_information($id);


		$update_value = $document[0]->update_value;


		if ($update_value) {
			$data_new = (unserialize($update_value));


			if ($document[0]->passport_id_num != $data_new['passport_id_num']) {
				$passport_up_num = 'Passport Number : ' . $data_new['passport_id_num'];
			} else {
				$passport_up_num = '';
			}


			if ($document[0]->title != $data_new['title']) {
				$Title = 'Title : ' . $data_new['title'];
			} else {
				$Title = '';
			}

			if ($document[0]->file != $data_new['file']) {

				$File = 'File :' . $data_new['file'];
			} else {
				$File = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$issue_date = 'Issue date :' . $data_new['issue_date'];
			} else {
				$issue_date = '';
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$expiry_date = 'Expiry date :' . $data_new['expiry_date'];
			} else {
				$expiry_date = '';
			}
			if ($document[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}

			$data = array(

				'passport_id' => $document[0]->passport_id,
				'passport_up_num' => $data_new['passport_id_num'],

				'title' => $data_new['title'],

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $data_new['file'],

				'issue_date' => $data_new['issue_date'],

				'expiry_date' => $data_new['expiry_date'],
				'description' => $data_new['description'],
				'update_value' => 'yes',

				'Title' => $Title,

				'File' => $File,

				'Issue_date' => $issue_date,

				'Expiry_date' => $expiry_date,

				'description_new' => $description_new,

			);
		} else {
			$data = array(

				'passport_id' => $document[0]->passport_id,

				'passport_up_num' => $document[0]->passport_id_num,

				'title' => $document[0]->title,

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $document[0]->file,

				'issue_date' => $document[0]->issue_date,

				'expiry_date' => $document[0]->expiry_date,
				'description' => $document[0]->description,
				'update_value' => 'no',

			);
		}

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function e_passport_info_validate()
	{

		if ($this->input->post('type') == 'e_passport_info' && $this->input->post('data') == 'e_passport_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('passport_num') === '') {

				$Return['error'] = "Enter the Passport Number";
			} else if ($this->input->post('title') === '') {

				$Return['error'] = "Enter the Title";
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			}



			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {


				$title = $this->input->post('update');

				$session = $this->session->userdata('username');
				if ($title == 'Approved') {

					$update_value = '';
					$data = array(

						'passport_id_num' => $this->input->post('passport_num'),

						'title' => $this->input->post('title'),

						'description' => $this->input->post('description'),

						//  'file' => $fname,

						'issue_date' => $this->input->post('issue_date'),

						'expiry_date' => $this->input->post('expiry_date'),
						'update_value' => $update_value

					);
				} elseif ($title == 'Rejected') {

					$update_value = '';
					$data = array(
						'update_value' => $update_value
					);
				} else {

					$data1 = array(
						'passport_id_num' => $this->input->post('passport_num'),
						'title' => $this->input->post('title'),

						'description' => $this->input->post('description'),

						'file' => $this->input->post('hello'),

						'issue_date' => $this->input->post('issue_date'),

						'expiry_date' => $this->input->post('expiry_date'),
					);

					$arr = serialize($data1);


					$data = array(
						'update_value' => $arr

					);
				}

				$e_field_id = $this->input->post('e_field_id');

				$result = $this->Employees_model->passport_info_update($data, $e_field_id);

				if ($result == TRUE) {

					$Return['result'] = "Updated Success";
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}

				$this->output($Return);

				exit;
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/passport/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;





						$title = $this->input->post('update');


						if ($title == 'Approved') {


							$update_value = '';
							$data = array(
								'passport_num' => $this->input->post('passport_num'),
								'title' => $this->input->post('title'),

								'description' => $this->input->post('description'),

								'file' => $fname,

								'issue_date' => $this->input->post('issue_date'),

								'expiry_date' => $this->input->post('expiry_date'),
								'update_value' => $update_value

							);
						} elseif ($title == 'Rejected') {

							$update_value = '';
							$data = array(
								'update_value' => $update_value
							);
						} else {

							$data1 = array(
								'passport_num' => $this->input->post('passport_num'),
								'title' => $this->input->post('title'),

								'description' => $this->input->post('description'),

								'file' => $fname,

								'issue_date' => $this->input->post('issue_date'),

								'expiry_date' => $this->input->post('expiry_date'),
							);

							$arr = serialize($data1);


							$data = array(
								'update_value' => $arr
							);
						}

						$e_field_id = $this->input->post('e_field_id');

						exit();

						$result = $this->Employees_model->passport_info_update($data, $e_field_id);

						if ($result == TRUE) {

							$Return['result'] = 'Update Success';
						} else {

							$Return['error'] = $this->lang->line('xin_error_msg');
						}

						$this->output($Return);

						exit;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			if ($result == TRUE) {

				$Return['result'] = "Added Success";
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function e_passport_info()
	{
		$session = $this->session->userdata('username');

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		/* Server side PHP input validation */

		if ($this->input->post('passport_num') === '') {

			$Return['error'] = "Enter the Passport Number";
		} else if ($this->input->post('title') === '') {

			$Return['error'] = "Enter the Title";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}

		if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

			$title = $this->input->post('update');

			$session = $this->session->userdata('username');
			if (($title == 'Approved') || ($session['user_id']==1 )) {

				$update_value = '';
				$data = array(

					'passport_id_num' => $this->input->post('passport_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					//  'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(
					'passport_id_num' => $this->input->post('passport_num'),
					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $this->input->post('hello'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr

				);
			}

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->passport_info_update($data, $e_field_id);
		} else {

			$fname = $this->input->post('attachment');

			$title = $this->input->post('update');

			if ($title == 'Approved') {


				$update_value = '';
				$data = array(
					'passport_num' => $this->input->post('passport_num'),
					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(
					'passport_num' => $this->input->post('passport_num'),
					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr
				);
			}

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->passport_info_update($data, $e_field_id);
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		}

		if ($result == TRUE) {

			$Return['result'] = "Update Success";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}

	// public function e_passport_info(){

	//         if ($this->input->post('type') == 'e_passport_info' && $this->input->post('data') == 'e_passport_info') {

	//           /* Define return | here result is used to return user data and error for error message */

	//           $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

	//           $Return['csrf_hash'] = $this->security->get_csrf_hash();



	//           /* Server side PHP input validation */

	//           if ($this->input->post('passport_num') === '') {

	//               $Return['error'] = "Enter the Passport Number";
	//           } else if ($this->input->post('title') === '') {

	//             $Return['error'] = "Enter the Title";
	//           } else if ($this->input->post('issue_date') === '') {

	//             $Return['error'] = $this->lang->line('xin_employee_error_d_issue');
	//           } else if ($this->input->post('expiry_date') === '') {

	//             $Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
	//           }



	//           /* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {


	//         $title = $this->input->post('update');

	//         $session = $this->session->userdata('username');
	//           if($title=='Approved')
	//           {

	//           $update_value='';
	//             $data = array(

	//                   'passport_id_num' => $this->input->post('passport_num'),

	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                     //  'file' => $fname,

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//                   'update_value' =>$update_value

	//                 );

	//           }

	//           elseif($title=='Rejected')

	//           {

	//             $update_value='';
	//             $data= array(
	//           'update_value' =>$update_value); 

	//           }

	//         else{

	//           $data1= array(
	//                   'passport_id_num' => $this->input->post('passport_num'),
	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                   'file' => $this->input->post('hello'),

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//             );

	//           $arr=serialize($data1);


	//             $data = array(
	//                 'update_value' => $arr

	//           );  

	//           }

	//             $e_field_id = $this->input->post('e_field_id');

	//             $result = $this->Employees_model->passport_info_update($data, $e_field_id);

	//             if ($result == TRUE) {

	//               $Return['result'] = "Updated Success";
	//             } else {

	//               $Return['error'] = $this->lang->line('xin_error_msg');
	//             }

	//             $this->output($Return);

	//             exit;
	//           } else {

	//             if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

	//               //checking image type

	//               $allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

	//               $filename = $_FILES['document_file']['name'];

	//               $ext = pathinfo($filename, PATHINFO_EXTENSION);



	//               if (in_array($ext, $allowed)) {

	//                 $tmp_name = $_FILES["document_file"]["tmp_name"];

	//                 $documentd = "uploads/document/passport/";

	//                 // basename() may prevent filesystem traversal attacks;

	//                 // further validation/sanitation of the filename may be appropriate

	//                 $name = basename($_FILES["document_file"]["name"]);

	//                 $newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

	//                 move_uploaded_file($tmp_name, $documentd . $newfilename);

	//                 $fname = $newfilename;





	//                 $title = $this->input->post('update');


	//           if($title=='Approved')
	//           {


	//           $update_value='';
	//             $data = array(
	//                   'passport_num' => $this->input->post('passport_num'),
	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                   'file' => $fname,

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//                   'update_value' =>$update_value

	//                 );

	//           }

	//           elseif($title=='Rejected')


	//           {

	//              $update_value='';
	//             $data= array(
	//           'update_value' =>$update_value); 



	//           }

	//         else{

	//           $data1= array(
	//                   'passport_num' => $this->input->post('passport_num'),
	//                   'title' => $this->input->post('title'),

	//                   'description' => $this->input->post('description'),

	//                   'file' => $fname,

	//                   'issue_date' => $this->input->post('issue_date'),

	//                   'expiry_date' => $this->input->post('expiry_date'),
	//             );

	//           $arr=serialize($data1);


	//             $data = array(
	//                 'update_value' => $arr
	//             );  

	//           }

	//                 $e_field_id = $this->input->post('e_field_id');

	//                 exit();

	//                 $result = $this->Employees_model->passport_info_update($data, $e_field_id);

	//                 if ($result == TRUE) {

	//                   $Return['result'] = 'Update Success';
	//                 } else {

	//                   $Return['error'] = $this->lang->line('xin_error_msg');
	//                 }

	//                 $this->output($Return);

	//                 exit;
	//               } else {

	//                 $Return['error'] = $this->lang->line('xin_employee_document_file_type');
	//               }
	//             }
	//           }

	//           if ($Return['error'] != '') {

	//             $this->output($Return);
	//           }

	//           if ($result == TRUE) {

	//             $Return['result'] = "Added Success";
	//           } else {

	//             $Return['error'] = $this->lang->line('xin_error_msg');
	//           }

	//           $this->output($Return);

	//           exit;
	//         }
	// }

	public function delete_passportdocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_passport_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = 'Deleted Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}
	//Passport Session End
	// 	CPR session Start
	public function cpr_info_validate()
	{

		if ($this->input->post('type') == 'cpr_info' && $this->input->post('data') == 'cpr_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('cpr_num') === '') {

				$Return['error'] = 'Enter the CPR Number';
			} else if ($this->input->post('title') === '') {

				$Return['error'] = 'Enter the Title';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}



			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/cpr/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$description = $this->input->post('reason');

			$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

			$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));

			$this->output($Return);

			exit;
		}
	}

	public function cpr_info()
	{

		if ($this->input->post('type') == 'cpr_info' && $this->input->post('data') == 'cpr_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('cpr_num') === '') {

				$Return['error'] = 'Enter the CPR Number';
			} else if ($this->input->post('title') === '') {

				$Return['error'] = 'Enter the Title';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else {
			}

			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$fname = '';
			} else {

				$fname = $this->input->post('attachment');
			}





			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$description = $this->input->post('reason');

			$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

			$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));


			$data = array(

				'cpr_num' => $this->input->post('cpr_num'),

				'title' => $this->input->post('title'),

				'file' => $fname,

				'issue_date' => $issue_date,

				'expiry_date' => $expiry_date,

				'employee_id' => $this->input->post('user_id'),

				'description' => $description,

				'created_at' => date('d-m-Y h:i:s'),

			);

			$result = $this->Employees_model->cpr_info_add($data);



			if ($result == TRUE) {

				$Return['result'] = 'Cpr Details Added Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function cpr()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$cpr = $this->Employees_model->set_employee_cpr($id);



		$data = array();



		foreach ($cpr->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);


			$update_value = $r->update_value;
			if ($update_value) {
				$color = 'red';

				$data[] = array(


					$r->cpr_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->cpr_id . '" data-field_type="cprdocument">
				<i class="fas fa-pencil-alt" style="/* color: red; */">	</i>
			
				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->cpr_id . '" data-token_type="cprdocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color
					// 			$c_name,

					// 			$eligible_review_date,

				);
			} else {
				$color = 'green';
				$data[] = array(


					$r->cpr_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->cpr_id . '" data-field_type="cprdocument">
				<i class="fas fa-pencil-alt" style="/* color: green; */">	</i>
				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->cpr_id . '" data-token_type="cprdocument"><i class="fas fa-trash-restore"></i></button></span>',

					$color

					// 			$c_name,

					// 			$eligible_review_date,

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $cpr->num_rows(),

			"recordsFiltered" => $cpr->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function dialog_cprdocument()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_cprdocument_information($id);


		$update_value = $document[0]->update_value;
		if ($update_value) {
			$data_new = (unserialize($update_value));
			//  var_dump($data_new);
			$printed_cpr = '';
			if ($document[0]->cpr_num != $data_new['cpr_num']) {
				$printed_cpr = $printed_cpr . "<span>CPR Number : " . $data_new['cpr_num'] . "</span></br>";
				$printed_cpr_num_up =  $data_new['cpr_num'];
			} else {
				$printed_cpr_num_up =  $document[0]->cpr_num;
			}


			if ($document[0]->title != $data_new['title']) {
				$printed_cpr = $printed_cpr . "<span>Title : " . $data_new['title'] . "</span></br>";
				$printed_title_up =  $data_new['title'];
			} else {
				$printed_title_up =  $document[0]->title;
			}

			if ($document[0]->file != $data_new['file']) {
				$printed_cpr = $printed_cpr . "<span>File : " . $data_new['file'] . "</span></br>";
				$printed_file_up =  $data_new['file'];
			} else {
				$printed_file_up =  $document[0]->file;
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$printed_cpr = $printed_cpr . "<span>Issue date : " . $data_new['issue_date'] . "</span></br>";
				$printed_issue_date_up =  $data_new['issue_date'];
			} else {
				$printed_issue_date_up =  $document[0]->issue_date;
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$printed_cpr = $printed_cpr . "<span>Expiry date : " . $data_new['expiry_date'] . "</span></br>";
				$printed_expiry_date_up =  $data_new['expiry_date'];
			} else {
				$printed_expiry_date_up =  $document[0]->expiry_date;
			}

			if ($document[0]->description != $data_new['description']) {
				$printed_cpr = $printed_cpr . "<span>Description : " . $data_new['description'] . "</span></br>";
				$printed_description_up =  $data_new['description'];
			} else {
				$printed_description_up =  $document[0]->description;
			}

			if ($printed_cpr != '') {
				$printed_cpr = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>' . $printed_cpr;
			} else {
				$printed_cpr =  '';
			}

			$update_value = 'yes';
		} else {
			$printed_cpr = '';
			$update_value = 'no';
			$printed_cpr_num_up = $document[0]->cpr_num;
			$printed_title_up = $document[0]->title;
			$printed_file_up = $document[0]->file;
			$printed_issue_date_up = $document[0]->issue_date;
			$printed_expiry_date_up = $document[0]->expiry_date;
			$printed_description_up = $document[0]->description;
		}

		$data = array(
			'cpr_id' => $document[0]->cpr_id,
			'cpr_up_num' => $printed_cpr_num_up,
			'title' => $printed_title_up,
			'd_employee_id' => $document[0]->employee_id,
			'document_file' => $printed_file_up,
			'issue_date' => $printed_issue_date_up,
			'expiry_date' => $printed_expiry_date_up,
			'description' => $printed_description_up,
			'update_value' => $update_value,
			'printed_cpr' => $printed_cpr
		);

		//    if($update_value)
		//    {
		//  $data_new = (unserialize($update_value));
		// // print_r($data_new);


		//     if($document[0]->title!=$data_new['title'])
		//   {
		//       $Title='Title : '.$data_new['title'];

		//   }
		//   else
		//   {
		//      $Title=''; 


		//   }

		//       if($document[0]->file!=$data_new['file'])
		//   {

		//     $File='File :'.$data_new['file'];

		//   }
		//   else
		//   {
		//       $File='';   

		//   }

		//       if($document[0]->issue_date!=$data_new['issue_date'])
		//   {
		//         $issue_date='Issue date :'.$data_new['issue_date'];
		//   }
		//   else
		//   {
		//      $issue_date='';     
		//   }

		//       if($document[0]->expiry_date!=$data_new['expiry_date'])
		//   {
		//       $expiry_date='Expiry date :'.$data_new['expiry_date'];


		//   }

		//   else
		//   {
		//       $expiry_date='';  
		//   }
		//       if($document[0]->description!=$data_new['description'])
		//   {

		//       $description_new='Discription : '.$data_new['description'];

		//   }

		//   else
		//   {
		//     $description_new='';   
		//   }



		//    $data = array(

		//      'cpr_id' => $document[0]->cpr_id,
		//             'd_employee_id' => $document[0]->employee_id,
		//            'title' => $data_new['title'],
		//       'document_file' => $data_new['file'],

		//      'issue_date' => $data_new['issue_date'],

		//      'expiry_date' => $data_new['expiry_date'],
		//      'description' => $data_new['description'],
		//       'update_value' => 'yes',

		//      'Title' => $Title,

		//      'File' => $File,

		//      'Issue_date' => $issue_date,

		//      'Expiry_date' =>$expiry_date,

		//      'description_new' => $description_new,



		//    );
		//    }

		//    else

		//    {
		//          $data = array(

		//      'cpr_id' => $document[0]->cpr_id,

		//      'title' => $document[0]->title,

		//      'd_employee_id' => $document[0]->employee_id,

		//      'document_file' => $document[0]->file,

		//      'issue_date' => $document[0]->issue_date,

		//      'expiry_date' => $document[0]->expiry_date,
		//      'description' => $document[0]->description,
		//      'update_value' => 'no',

		//    );  
		//    }

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function e_cpr_info_validate()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('cpr_num') === '') {

			$Return['error'] = "Enter the CPR Number";
		} else if ($this->input->post('title') === '') {

			$Return['error'] = "Enter the Title";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}

		/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] != 0) {

			if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

				//checking image type

				$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

				$filename = $_FILES['document_file']['name'];

				$ext = pathinfo($filename, PATHINFO_EXTENSION);



				if (in_array($ext, $allowed)) {

					$tmp_name = $_FILES["document_file"]["tmp_name"];

					$documentd = "uploads/document/cpr/";

					// basename() may prevent filesystem traversal attacks;

					// further validation/sanitation of the filename may be appropriate

					$name = basename($_FILES["document_file"]["name"]);

					$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

					move_uploaded_file($tmp_name, $documentd . $newfilename);

					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
				} else {

					$Return['error'] = $this->lang->line('xin_employee_document_file_type');
				}
			}
		}


		if ($Return['error'] != '') {

			$this->output($Return);
		}

		$Return['error'] = '';
		$this->output($Return);

		exit;
	}

	public function e_cpr_info()
	{

		$session = $this->session->userdata('username');
		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('cpr_num') === '') {

			$Return['error'] = "Enter the CPR Number";
		} else if ($this->input->post('title') === '') {

			$Return['error'] = "Enter the Title";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}

		if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

			$title = $this->input->post('update');

			if (($title == 'Approved') || ($session['user_id'])) {

				$update_value = '';
				$data = array(

					'cpr_num' => $this->input->post('cpr_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					//  'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'cpr_num' => $this->input->post('cpr_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $this->input->post('hello'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr
				);
			}

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->cpr_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = "Updated Success";
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		} else {


			$fname = $this->input->post('attachment');

			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(

					'cpr_num' => $this->input->post('cpr_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'cpr_num' => $this->input->post('cpr_num'),

					'title' => $this->input->post('title'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr

				);
			}

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->cpr_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = 'Update Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}



		if ($Return['error'] != '') {

			$this->output($Return);
		}



		if ($result == TRUE) {

			$Return['result'] = "Added Success";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}

	public function delete_cprdocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_cpr_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = 'Deleted Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}
	//CPR end
	// insurance start
	public function insurance_info_validate()
	{

		if ($this->input->post('type') == 'insurance_info' && $this->input->post('data') == 'insurance_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('list') === '') {

				$Return['error'] = 'Select the List';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}

			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/insurance/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}
			$this->output($Return);

			exit;
		}
	}

	public function insurance_info()
	{




		if ($this->input->post('type') == 'insurance_info' && $this->input->post('data') == 'insurance_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('list') === '') {

				$Return['error'] = 'Select the List';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else {
			}

			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$fname = '';
			} else {

				$fname = $this->input->post('attachment');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$description = $this->input->post('reason');

			$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

			$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));


			$data = array(

				'list' => $this->input->post('list'),
				'company_name' => $this->input->post('company_name'),

				'file' => $fname,

				'issue_date' => $issue_date,

				'expiry_date' => $expiry_date,

				'employee_id' => $this->input->post('user_id'),

				'description' => $description,

				'created_at' => date('d-m-Y h:i:s'),

			);

			$result = $this->Employees_model->insurance_info_add($data);



			if ($result == TRUE) {

				$Return['result'] = 'Insurance Details Added Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}
	public function insurance()
	{


		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$insurance = $this->Employees_model->set_employee_insurance($id);



		$data = $output = array();
		foreach ($insurance->result() as $r) {
			$issue_date = $this->Xin_model->set_date_format($r->issue_date);
			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			if ($r->company_name == '') {
				$company = '';
			} else {
				$company = $r->company_name;
			}
			$update_value = $r->update_value;
			if ($update_value) {
				$data[] = array(


					$r->list,

					$company,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
        				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->insurance_id . '" data-field_type="insurancedocument">
        					<i class="fas fa-pencil-alt" style="/* color: red;*/"></i>
        				</i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->insurance_id . '" data-token_type="insurancedocument"><i class="fas fa-trash-restore"></i></button></span>',


					// 			$c_name,

					// 			$eligible_review_date,

				);
				$output = array(

					"draw" => $draw,

					"recordsTotal" => $insurance->num_rows(),

					"recordsFiltered" => $insurance->num_rows(),

					"data" => $data

				);
			} else {
				$data[] = array(


					$r->list,

					$company,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->insurance_id . '" data-field_type="insurancedocument">
            			<i class="fas fa-pencil-alt" style="/* color: green; */"></i>
            			</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->insurance_id . '" data-token_type="insurancedocument"><i class="fas fa-trash-restore"></i></button></span>',


					// 			$c_name,

					// 			$eligible_review_date,

				);
				$output = array(
					"draw" => $draw,
					"recordsTotal" => $insurance->num_rows(),
					"recordsFiltered" => $insurance->num_rows(),
					"data" => $data

				);
			}
		}
		if (empty($output)) {
			$output = array(
				"draw" => $draw,
				"recordsTotal" => $insurance->num_rows(),
				"recordsFiltered" => $insurance->num_rows(),
				"data" => $data

			);
		}

		echo json_encode($output);
		exit();
	}
	public function dialog_insurancedocument()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_insurancedocument_information($id);


		$update_value = $document[0]->update_value;

		if ($update_value) {
			$data_new = (unserialize($update_value));
			//print_r($data_new);


			if ($document[0]->list != $data_new['list']) {
				$list = 'List : ' . $data_new['list'];
			} else {
				$list = '';
			}

			if ($document[0]->company_name != $data_new['company_name']) {

				$company_name = 'Company Name :' . $data_new['company_name'];
			} else {
				$company_name = '';
			}

			if (($document[0]->file != $data_new['file']) and ($data_new['file'] != '')) {
				$file = 'File :' . $data_new['file'];
			} else {
				$file = '';
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$expiry_date = 'Expiry Date :' . $data_new['expiry_date'];
			} else {
				$expiry_date = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$issue_date = 'Issue_date :' . $data_new['issue_date'];
			} else {
				$issue_date = '';
			}





			if ($document[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}







			$data = array(

				'insurance_id' => $document[0]->insurance_id,

				'list' => $data_new['list'],
				'company_name' => $data_new['company_name'],

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $data_new['file'],

				'issue_date' => $data_new['issue_date'],

				'expiry_date' => $data_new['expiry_date'],
				'description' => $data_new['description'],

				'update_value' => 'yes',

				'List' => $list,

				'Company_name' => $company_name,

				'Document_file' => $file,

				'Issue_date' => $issue_date,
				'Expiry_date' => $expiry_date,


				'description_new' => $description_new,
				'update_value' => 'yes',


			);
		} else {

			$data = array(

				'insurance_id' => $document[0]->insurance_id,

				'list' => $document[0]->list,
				'company_name' => $document[0]->company_name,

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $document[0]->file,

				'issue_date' => $document[0]->issue_date,

				'expiry_date' => $document[0]->expiry_date,
				'description' => $document[0]->description,
				'update_value' => 'no',

			);
		}



		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function e_insurance_info_validate()
	{


		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('list') === '') {

			$Return['error'] = "Select the List";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}



		/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] != 0) {

			//checking image type

			$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

			$filename = $_FILES['document_file']['name'];

			$ext = pathinfo($filename, PATHINFO_EXTENSION);



			if (in_array($ext, $allowed)) {

				$tmp_name = $_FILES["document_file"]["tmp_name"];

				$documentd = "uploads/document/insurance/";

				// basename() may prevent filesystem traversal attacks;

				// further validation/sanitation of the filename may be appropriate

				$name = basename($_FILES["document_file"]["name"]);

				$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

				move_uploaded_file($tmp_name, $documentd . $newfilename);

				$fname = $newfilename;
				$Return['fileName'] = $newfilename;

				$this->output($Return);

				exit;
			} else {

				$Return['error'] = $this->lang->line('xin_employee_document_file_type');
			}
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		}

		$this->output($Return);

		exit;
	}

	public function e_insurance_info()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('list') === '') {

			$Return['error'] = "Select the List";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}



		/* Check if file uploaded..*/ else if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(

					'list' => $this->input->post('list'),
					'company_name' => $this->input->post('company_name'),

					'description' => $this->input->post('description'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'list' => $this->input->post('list'),
					'company_name' => $this->input->post('company_name'),

					'description' => $this->input->post('description'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'file' => $this->input->post('hello'),

				);

				$arr = serialize($data1);

				$data = array('update_value' => $arr);
			}

			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->insurance_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = "Updated Success";
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		} else {
			$fname = $this->input->post('attachment');


			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(

					'list' => $this->input->post('list'),
					'company_name' => $this->input->post('company_name'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value

				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array(
					'update_value' => $update_value
				);
			} else {

				$data1 = array(

					'list' => $this->input->post('list'),
					'company_name' => $this->input->post('company_name'),

					'description' => $this->input->post('description'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
				);

				$arr = serialize($data1);


				$data = array(
					'update_value' => $arr

				);
			}



			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->insurance_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = 'Update Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		}



		if ($result == TRUE) {

			$Return['result'] = "Added Success";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}

	public function delete_insurancedocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_insurance_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = 'Deleted Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}
	// insurance end
	//License start

	public function license_info_validate()
	{

		if ($this->input->post('type') == 'license_info' && $this->input->post('data') == 'license_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('list') === '') {

				$Return['error'] = 'Select the List';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			}



			/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] == 0) {

				$Return['error'] = $this->lang->line('xin_employee_select_d_file');
			} else {

				if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

					//checking image type

					$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

					$filename = $_FILES['document_file']['name'];

					$ext = pathinfo($filename, PATHINFO_EXTENSION);



					if (in_array($ext, $allowed)) {

						$tmp_name = $_FILES["document_file"]["tmp_name"];

						$documentd = "uploads/document/license/";

						// basename() may prevent filesystem traversal attacks;

						// further validation/sanitation of the filename may be appropriate

						$name = basename($_FILES["document_file"]["name"]);

						$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

						move_uploaded_file($tmp_name, $documentd . $newfilename);

						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {

						$Return['error'] = $this->lang->line('xin_employee_document_file_type');
					}
				}
			}



			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function license_info()
	{




		if ($this->input->post('type') == 'license_info' && $this->input->post('data') == 'license_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('list') === '') {

				$Return['error'] = 'Select the List';
			} else if ($this->input->post('issue_date') === '') {

				$Return['error'] = 'Start Date';
			} else if ($this->Xin_model->validate_date($this->input->post('issue_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else if ($this->input->post('expiry_date') === '') {

				$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
			} else if ($this->Xin_model->validate_date($this->input->post('expiry_date'), 'Y-m-d') == false) {

				$Return['error'] = $this->lang->line('xin_hr_date_format_error');
			} else {
			}

			if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {

				$fname = '';
			} else {

				$fname = $this->input->post('attachment');
			}

			if ($Return['error'] != '') {

				$this->output($Return);
			}

			// 		$description = $this->input->post('reason');	

			$issue_date = $this->Xin_model->clean_date_post($this->input->post('issue_date'));

			$expiry_date = $this->Xin_model->clean_date_post($this->input->post('expiry_date'));


			$data = array(

				'list' => $this->input->post('list'),
				'renew_date' => $this->input->post('renew_date'),

				'file' => $fname,

				'issue_date' => $issue_date,

				'expiry_date' => $expiry_date,

				'employee_id' => $this->input->post('user_id'),


				'created_at' => date('d-m-Y h:i:s'),

			);

			$result = $this->Employees_model->license_info_add($data);



			if ($result == TRUE) {

				$Return['result'] = 'License Details Added Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function license()
	{


		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$license = $this->Employees_model->set_employee_license($id);



		$data = array();



		foreach ($license->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);



			$update_value = $r->update_value;
			if ($update_value) {
				$color = 'red';

				$data[] = array(


					$r->list,



					$issue_date,

					$expiry_date,

					// 			$c_name,

					$r->renew_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->license_id . '" data-field_type="licensedocument">
			<i class="fas fa-pencil-alt"></i>
				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->license_id . '" data-token_type="licensedocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color,

				);
			} else {
				$color = 'green';
				$data[] = array(


					$r->list,

					$issue_date,

					$expiry_date,

					// 			$c_name,

					$r->renew_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->license_id . '" data-field_type="licensedocument">
			<i class="fas fa-pencil-alt"></i>
			
				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->license_id . '" data-token_type="licensedocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color,

				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $license->num_rows(),

			"recordsFiltered" => $license->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function dialog_licensedocument()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_licensedocument_information($id);



		$update_value = $document[0]->update_value;


		if ($update_value) {



			$data_new = (unserialize($update_value));



			if ($document[0]->list != $data_new['list']) {
				$List = 'List : ' . $data_new['list'];
			} else {
				$List = '';
			}

			if ($document[0]->file != $data_new['file']) {

				$File = 'File :' . $data_new['file'];
			} else {
				$File = '';
			}

			if ($document[0]->renew_date != $data_new['renew_date']) {
				$Renew_date = 'Renew_date :' . $data_new['renew_date'];
			} else {
				$Renew_date = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$Issue_date = 'Issue_date :' . $data_new['issue_date'];
			} else {
				$Issue_date = '';
			}
			if ($document[0]->expiry_date != $data_new['expiry_date']) {

				$Expiry_date = 'expiry_date : ' . $data_new['expiry_date'];
			} else {
				$Expiry_date = '';
			}






			$data = array(

				'license_id' => $document[0]->license_id,

				'list' => $data_new['list'],
				'renew_date' => $data_new['renew_date'],

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $data_new['file'],

				'issue_date' => $data_new['issue_date'],

				'expiry_date' => $data_new['expiry_date'],

				'update_value' => 'yes',

				'List' => $List,

				'File' => $File,

				'Renew_date' => $Renew_date,

				'Expiry_date' => $Expiry_date,

				'Issue_date' => $Issue_date,







			);
		} else {
			$data = array(

				'license_id' => $document[0]->license_id,

				'list' => $document[0]->list,
				'renew_date' => $document[0]->renew_date,

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $document[0]->file,

				'issue_date' => $document[0]->issue_date,

				'expiry_date' => $document[0]->expiry_date,
				'update_value' => 'no',


				'List' => '',

				'File' => '',

				'Renew_date' => '',

				'Expiry_date' => '',

				'Issue_date' => '',




			);
		}




		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function e_license_info_validate()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('list') === '') {

			$Return['error'] = "Select the List";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}



		/* Check if file uploaded..*/ else if ($_FILES['document_file']['size'] != 0) {

			if (is_uploaded_file($_FILES['document_file']['tmp_name'])) {

				//checking image type

				$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'txt', 'pdf', 'xls', 'xlsx', 'doc', 'docx');

				$filename = $_FILES['document_file']['name'];

				$ext = pathinfo($filename, PATHINFO_EXTENSION);



				if (in_array($ext, $allowed)) {

					$tmp_name = $_FILES["document_file"]["tmp_name"];

					$documentd = "uploads/document/license/";

					// basename() may prevent filesystem traversal attacks;

					// further validation/sanitation of the filename may be appropriate

					$name = basename($_FILES["document_file"]["name"]);

					$newfilename = 'document_' . round(microtime(true)) . '.' . $ext;

					move_uploaded_file($tmp_name, $documentd . $newfilename);

					$fname = $newfilename;
					$Return['fileName'] = $newfilename;

					$this->output($Return);

					exit;
				} else {

					$Return['error'] = $this->lang->line('xin_employee_document_file_type');
				}
			}
		}

		if ($Return['error'] != '') {

			$this->output($Return);
		} else {
			$Return['error'] = '';

			$this->output($Return);
		}
	}

	public function e_license_info()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('list') === '') {

			$Return['error'] = "Select the List";
		} else if ($this->input->post('issue_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_d_issue');
		} else if ($this->input->post('expiry_date') === '') {

			$Return['error'] = $this->lang->line('xin_employee_error_expiry_date');
		}



		/* Check if file uploaded..*/ else if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {





			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(

					'list' => $this->input->post('list'),

					'renew_date' => $this->input->post('renew_date'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value
				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array('update_value' => $update_value);
			} else {

				$data1 = array(


					'list' => $this->input->post('list'),

					'renew_date' => $this->input->post('renew_date'),

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'file' => $this->input->post('hello'),


				);

				$arr = serialize($data1);
				$data = array('update_value' => $arr);
			}
			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->license_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = "Updated Success";
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		} else {

			$fname = $this->input->post('attachment');

			$data = array(

				'list' => $this->input->post('list'),
				'renew_date' => $this->input->post('renew_date'),

				'file' => $fname,

				'issue_date' => $this->input->post('issue_date'),

				'expiry_date' => $this->input->post('expiry_date'),


			);

			$title = $this->input->post('update');


			if ($title == 'Approved') {


				$update_value = '';
				$data = array(
					'list' => $this->input->post('list'),
					'renew_date' => $this->input->post('renew_date'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),
					'update_value' => $update_value
				);
			} elseif ($title == 'Rejected') {

				$update_value = '';
				$data = array('update_value' => $update_value);
			} else {

				$data1 = array(


					'list' => $this->input->post('list'),
					'renew_date' => $this->input->post('renew_date'),

					'file' => $fname,

					'issue_date' => $this->input->post('issue_date'),

					'expiry_date' => $this->input->post('expiry_date'),


				);

				$arr = serialize($data1);
				$data = array('update_value' => $arr);
			}
			$e_field_id = $this->input->post('e_field_id');

			$result = $this->Employees_model->license_info_update($data, $e_field_id);

			if ($result == TRUE) {

				$Return['result'] = 'Update Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;

			if ($Return['error'] != '') {

				$this->output($Return);
			}
		}

		if ($result == TRUE) {

			$Return['result'] = "Added Success";
		} else {

			$Return['error'] = $this->lang->line('xin_error_msg');
		}

		$this->output($Return);

		exit;
	}


	public function delete_licensedocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_license_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = 'Deleted Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	// License end
	public function expired_visa_list()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/expired_documents_list", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		//	$id = $this->uri->segment(4);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$visa = $this->Employees_model->get_visa_expired_all();
		} else {

			$visa = $this->Employees_model->get_user_ivisa_expired_all($session['user_id']);
		}





		$data = array();



		foreach ($visa->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);

			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			//userinfo
			if (!is_null($xuser_info)) {
				if ($user_info[0]->user_role_id == 1) {
					$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
				} else {
					$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
				}
			} else {
				$fc_name = '--';
			}
			if (in_array('854', $role_resources_ids)) {
				if ($r->file != '') {
					$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document/visa&filename=' . $r->file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
				} else {
					$functions = '';
				}
			} else {
				$functions = '';
			}
			if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
				$data[] = array(

					//.'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->visa_id . '" data-field_type="visadocument"><i class="fas fa-pencil-alt"></i></button></span>',
					$fc_name,
					$r->title,
					$issue_date,
					$expiry_date,
					//      $c_name,
					//      $eligible_review_date,
					$functions,
				);
			} else {
				$data[] = array(
					//.'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->visa_id . '" data-field_type="visadocument"><i class="fas fa-pencil-alt"></i></button></span>',
					$fc_name,
					$r->title,
					$issue_date,
					$expiry_date,
					//      $c_name,
					//      $eligible_review_date,
				);
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $visa->num_rows(),

			"recordsFiltered" => $visa->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function dialog_exp_visadocument()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_visadocument_information($id);

		$data = array(

			'visa_id' => $document[0]->visa_id,

			'title' => $document[0]->title,

			'd_employee_id' => $document[0]->employee_id,


			'description' => $document[0]->description,

			'document_file' => $document[0]->file,

			'issue_date' => $document[0]->issue_date,

			'expiry_date' => $document[0]->expiry_date,



		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_exp_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function expired_passport_list()
	{



		//set data
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/dialog_employee_exp_details", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$passport = $this->Employees_model->get_passport_expired_all();
		} else {

			$passport = $this->Employees_model->get_user_passport_expired_all($session['user_id']);
		}




		$data = array();



		foreach ($passport->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($xuser_info)) {
				$issue_date = $this->Xin_model->set_date_format($r->issue_date);
				$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
				//userinfo
				if (!is_null($xuser_info)) {
					if ($user_info[0]->user_role_id == 1) {
						$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
					} else {
						$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
					}
				} else {
					$fc_name = '--';
				}
				if (in_array('854', $role_resources_ids)) {
					if ($r->file != '' && $r->file != 'no file') {
						$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document/passport&filename=' . $r->file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
					} else {
						$functions = '';
					}
				} else {
					$functions = '';
				}

				if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
					$data[] = array(

						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->passport_id . '" data-field_type="passportdocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->title,
						$issue_date,
						$expiry_date,
						//      $c_name,
						//      $eligible_review_date,
						$functions,
					);
				} else {
					$data[] = array(
						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->passport_id . '" data-field_type="passportdocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->title,
						$issue_date,
						$expiry_date,
						//      $c_name,
						//      $eligible_review_date,
					);
				}
			}
		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => $passport->num_rows(),

			"recordsFiltered" => $passport->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function expired_cpr_list()
	{



		//set data
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/dialog_employee_exp_details", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$cpr = $this->Employees_model->get_cpr_expired_all();
		} else {

			$cpr = $this->Employees_model->get_user_cpr_expired_all($session['user_id']);
		}




		$data = array();



		foreach ($cpr->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($xuser_info)) {
				$issue_date = $this->Xin_model->set_date_format($r->issue_date);
				$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
				//userinfo
				if (!is_null($xuser_info)) {
					if ($user_info[0]->user_role_id == 1) {
						$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
					} else {
						$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
					}
				} else {
					$fc_name = '--';
				}
				if (in_array('854', $role_resources_ids)) {
					if ($r->file != '' && $r->file != 'no file') {
						$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document/cpr&filename=' . $r->file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
					} else {
						$functions = '';
					}
				} else {
					$functions = '';
				}

				if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
					$data[] = array(

						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->cpr_id . '" data-field_type="cprdocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->title,
						$issue_date,
						$expiry_date,
						//      $c_name,
						//      $eligible_review_date,
						$functions,
					);
				} else {
					$data[] = array(
						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->cpr_id . '" data-field_type="cprdocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->title,
						$issue_date,
						$expiry_date,
						//      $c_name,
						//      $eligible_review_date,
					);
				}
			}
		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => $cpr->num_rows(),

			"recordsFiltered" => $cpr->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function expired_insurance_list()
	{



		//set data
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/dialog_employee_exp_details", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$insurance = $this->Employees_model->get_insurance_expired_all();
		} else {

			$insurance = $this->Employees_model->get_user_insurance_expired_all($session['user_id']);
		}




		$data = array();



		foreach ($insurance->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($xuser_info)) {
				$issue_date = $this->Xin_model->set_date_format($r->issue_date);
				$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
				//userinfo
				if (!is_null($xuser_info)) {
					if ($user_info[0]->user_role_id == 1) {
						$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
					} else {
						$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
					}
				} else {
					$fc_name = '--';
				}
				if (in_array('854', $role_resources_ids)) {
					if ($r->file != '' && $r->file != 'no file') {
						$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document/insurance&filename=' . $r->file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
					} else {
						$functions = '';
					}
				} else {
					$functions = '';
				}

				if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
					$data[] = array(

						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->insurance_id . '" data-field_type="cprdocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->list,
						$issue_date,
						$expiry_date,
						//      $c_name,
						//      $eligible_review_date,
						$functions,
					);
				} else {
					$data[] = array(
						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->insurance_id . '" data-field_type="cprdocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->list,
						$issue_date,
						$expiry_date,
						//      $c_name,
						//      $eligible_review_date,
					);
				}
			}
		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => $insurance->num_rows(),

			"recordsFiltered" => $insurance->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function expired_license_list()
	{



		//set data
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/dialog_employee_exp_details", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {

			$license = $this->Employees_model->get_license_expired_all();
		} else {

			$license = $this->Employees_model->get_user_license_expired_all($session['user_id']);
		}




		$data = array();



		foreach ($license->result() as $r) {



			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			$xuser_info = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($xuser_info)) {
				$issue_date = $this->Xin_model->set_date_format($r->issue_date);
				$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
				//userinfo
				if (!is_null($xuser_info)) {
					if ($user_info[0]->user_role_id == 1) {
						$fc_name = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->employee_id . '">' . $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name . '</a>';
					} else {
						$fc_name = $xuser_info[0]->first_name . ' ' . $xuser_info[0]->middle_name . ' ' . $xuser_info[0]->last_name;
					}
				} else {
					$fc_name = '--';
				}
				if (in_array('854', $role_resources_ids)) {
					if ($r->file != '' && $r->file != 'no file') {
						$functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document/license&filename=' . $r->file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
					} else {
						$functions = '';
					}
				} else {
					$functions = '';
				}

				if (in_array('854', $role_resources_ids) || in_array('853', $role_resources_ids)) {
					$data[] = array(

						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->license_id . '" data-field_type="licensedocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->list,
						$issue_date,
						$expiry_date,
						//    $c_name,
						//      $eligible_review_date,
						$functions,
					);
				} else {
					$data[] = array(
						//   .'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->license_id . '" data-field_type="licensedocument"><i class="fas fa-pencil-alt"></i></button></span>',
						$fc_name,
						$r->list,
						$issue_date,
						$expiry_date,
						//    $c_name,
						//      $eligible_review_date,
					);
				}
			}
		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => $license->num_rows(),

			"recordsFiltered" => $license->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function dialog_exp_passportdocument()
	{



		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_passportdocument_information($id);

		$data = array(

			'passport_id' => $document[0]->passport_id,

			'title' => $document[0]->title,

			'd_employee_id' => $document[0]->employee_id,


			'description' => $document[0]->description,

			'document_file' => $document[0]->file,

			'issue_date' => $document[0]->issue_date,

			'expiry_date' => $document[0]->expiry_date,



		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_exp_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function vehicle_info_validate()
	{

		if ($this->input->post('type') == 'vehicle_info' && $this->input->post('data') == 'vehicle_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('vehicle_type') === '') {

				$Return['error'] = 'Enter the vehicle';
			} else if ($this->input->post('number') === '') {

				$Return['error'] = 'Resignation Number';
			} else if ($this->input->post('assign_date') === '') {

				$Return['error'] = 'Assigned Date';
			}


			if ($Return['error'] != '') {

				$this->output($Return);
			}

			$this->output($Return);

			exit;
		}
	}

	public function vehicle_info()
	{




		if ($this->input->post('type') == 'vehicle_info' && $this->input->post('data') == 'vehicle_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			//preg_match("/^(\pL{1,}[ ]?)+$/u",

			/* Server side PHP input validation */

			if ($this->input->post('vehicle_type') === '') {

				$Return['error'] = 'Enter the vehicle';
			} else if ($this->input->post('number') === '') {

				$Return['error'] = 'Resignation Number';
			} else if ($this->input->post('assign_date') === '') {

				$Return['error'] = 'Assigned Date';
			}



			/* Check if file uploaded..*/





			if ($Return['error'] != '') {

				$this->output($Return);
			}



			$data = array(

				'type' => $this->input->post('vehicle_type'),

				'number' => $this->input->post('number'),

				'date' => $this->input->post('assign_date'),

				'employee_id' => $this->input->post('user_id'),

			);

			$result = $this->Employees_model->vehicle_info_add($data);



			if ($result == TRUE) {
				$vehicle_list = $this->Xin_model->get_vehicle_type();
				$Select = '<label for="document_number" class="control-label">Vehicle<i class="hrsale-asterisk">*</i></label>
                    <select class="form-control" name="vehicle_type" id="vehicle_type" data-plugin="select_hrm" data-placeholder="Select Vehicle">
                    <option default selected value="">Select vehicle</option>';
				foreach ($vehicle_list->result() as $row) {
					$Select .= '<option value=' . $row->vehicle_id . '>' . $row->type . '</option>';
				}

				$Select .= '</select>';
				$Return['Select'] = $Select;
				$Return['result'] = 'Vehicle Details Added Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function vehicle()
	{


		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$vehicle = $this->Employees_model->set_employee_vehicle($id);



		$data = array();



		foreach ($vehicle->result() as $r) {
			$vehicle_name = $this->Employees_model->vehicle($r->type);




			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$vehicle_name[0]->type,

				$r->number,

				$r->date,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '" data-field_type="vehicledocument"><i class="fas fa-pencil-alt"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="vehicledocument"><i class="fas fa-trash-restore"></i></button></span>',


				$style

				// 			$c_name,

				// 			$eligible_review_date,

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $vehicle->num_rows(),

			"recordsFiltered" => $vehicle->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function dialog_vehicledocument()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_vehicledocument_information($id);

		$data = array(

			'vehicle_id' => $document[0]->id,

			'type' => $document[0]->type,
			'all_vehicle' => $this->Xin_model->get_all_vehicle(),

			'd_employee_id' => $document[0]->employee_id,

			'number' => $document[0]->number,

			'date' => $document[0]->date,



		);
		$local_store = $this->Employees_model->read_vehicle_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['type'] = $un_local['type'];
			$data['number'] = $un_local['number'];
			$data['date'] = $un_local['date'];
		}
		$data['vehicle_changes'] = $this->Employees_model->read_vehicle_changes_local($id);
		$data['local_vehicle_store'] = $this->Employees_model->read_local_vehicle_store($id);
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function e_vehicle_info_validate()
	{

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();



		/* Server side PHP input validation */

		if ($this->input->post('vehicle_type') === '') {

			$Return['error'] = "Enter the type";
		} else if ($this->input->post('number') === '') {

			$Return['error'] = "Enter Number";
		} else if ($this->input->post('assign_date') === '') {

			$Return['error'] = "Enter Date";
		} else {

			$Return['error'] = '';
		}



		$this->output($Return);

		exit;
	}

	public function e_vehicle_info()
	{
		if ($this->input->post('type') == 'e_vehicle_info' && $this->input->post('data') == 'e_vehicle_info') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();



			/* Server side PHP input validation */

			if ($this->input->post('vehicle_type') === '') {

				$Return['error'] = "Enter the type";
			}



			/* Check if file uploaded..*/



			$data = array(

				'type' => $this->input->post('vehicle_type'),

				'number' => $this->input->post('number'),

				'date' => $this->input->post('assign_date'),


			);

			$e_field_id = $this->input->post('e_field_id');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			if ($this->input->post('save_status_vehicle') == 'pending') {
				$result = $this->Employees_model->vehicle_info_update($data, $e_field_id);

				if ($result == TRUE) {

					$Return['result'] = "Updated Success";
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_status_vehicle') == 'rejected') {
				$result = $this->Employees_model->vehicle_info_rejected($e_field_id);
				if ($result == TRUE) {

					$Return['result'] = $this->lang->line('xin_employee_vehicle_info_rejected');
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($this->input->post('save_status_vehicle') == 'approved') {
				$result = $this->Employees_model->vehicle_info_approved($data, $e_field_id);
				if ($result == TRUE) {

					$Return['result'] = 'Updated Success';
				} else {

					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$result = $this->Employees_model->vehicle_info_approved($data, $e_field_id);
					if ($result == TRUE) {

						$Return['result'] = 'Updated Success';
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} else {
					$result = $this->Employees_model->vehicle_info_update($data, $e_field_id);
					if ($result == TRUE) {

						$Return['result'] = "Updated Success";
					} else {

						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				}
			}
			$this->output($Return);

			exit;





			if ($Return['error'] != '') {

				$this->output($Return);
			}



			if ($result == TRUE) {

				$Return['result'] = "Added Success";
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);

			exit;
		}
	}

	public function delete_vehicledocument()
	{



		if ($this->input->post('data') == 'delete_record') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');



			$id = $this->uri->segment(4);

			$result = $this->Employees_model->delete_vehicle_record($id);

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (isset($id)) {

				$Return['result'] = 'Deleted Success';
			} else {

				$Return['error'] = $this->lang->line('xin_error_msg');
			}

			$this->output($Return);
		}
	}

	public function getempname()
	{
		// POST data
		$postData = $this->input->post();

		// Get data
		$data = $this->Employees_model->getempname($postData);

		echo json_encode($data);
	}

	public function getempid()
	{
		// POST data
		$postData = $this->input->post();

		// Get data
		$data = $this->Employees_model->getempid($postData);

		echo json_encode($data);
	}

	public function getbankcode()
	{
		// POST data
		$postData = $this->input->post();

		// Get data
		$data = $this->Employees_model->getbankcode($postData);

		echo json_encode($data);
	}

	public function getsearchdetails()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {
			redirect('admin/');
		}

		$category = $this->input->post("category_select");
		$item = $this->input->post("customsearch");
		// var_dump($category);
		if ($category == "Employee Name") {
			$name = explode(' ', $item);
			$first_name = $name[0];
			$last_name = $name[1];
			$id = $this->Employees_model->get_userid_fromempname($first_name, $last_name);
			$result = $this->Employees_model->read_employee_information($id[0]->user_id);
		} elseif ($category == "Employee ID") {
			$id = $this->Employees_model->get_userid_fromempid($item);
			$result = $this->Employees_model->read_employee_information($id[0]->user_id);
		}

		if (!is_null($result)) {
			/*redirect('admin/employees/detail/'.$result[0]->user_id.'/search');*/
			redirect('admin/employees/detail/' . $result[0]->user_id);
		}
	}

	public function employee_bankdetails()
	{
		// POST data
		$postData = $this->input->post();
		// get data
		$data = $this->Employees_model->getbankcode($postData);

		echo json_encode($data);
	}
	public function preditallemployeedetails()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		// 		var_dump($this->input->post('category'));
		$result = $this->Employees_model->preditallemployeedetails($this->input->post('category'));
		// 		var_dump($result);
		echo json_encode($result);
	}
	public function employeesdata()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$data['title'] = $this->lang->line('xin_employees') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_office_shifts'] = $this->Employees_model->all_office_shifts();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();

		$data['breadcrumbs'] = $this->lang->line('xin_employees');

		$data['popup'] = 'NO DATA FOUND';

		if (!in_array('79', $role_resources_ids)) {

			$data['path_url'] = 'myteam_employees';
		} else {

			$data['path_url'] = 'employees';
		}



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('79', $role_resources_ids) || $reports_to > 0) {

			if (!empty($session)) {

				$data['subview'] = $this->load->view("admin/employees/employees_datas", $data, TRUE);

				$this->load->view('admin/layout/layout_main', $data); //page load

			} else {

				redirect('admin/');
			}
		} else {

			redirect('admin/dashboard');
		}
	}
	public function getemployeesearchdetails()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$category = $this->input->post("category_select");
		$item = $this->input->post("customsearch");
		// $url = $this->input->post("url");
		// var_dump($item);die();
		if ($item != '' && $item != NULL && $item != 'undefined') {
			redirect('admin/employees/detail/' . $item);
		} else {
			$data = array();
			$data['status'] = 'No Data Found';
			// var_dump($data);
			redirect('admin/employees/employeesdata/', $data);
		}
	}
	public function filter_employee_details()
	{
		$data['title'] = $this->Xin_model->site_title();
		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));
		// if ($keywords[0]!='') {
		$id = $keywords[0];
		$data = array('category' => $id);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			// var_dump($data);die();
			$data = $this->security->xss_clean($data);
			$this->load->view("admin/components/search_employee_details", $data);
		} else {
			redirect('admin/');
		}
		// }    
		// Datatables Variables    
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function manage_onboard()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		$data['title'] = $this->lang->line('xin_employees_onboard_manage') . ' | ' . $this->Xin_model->site_title();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_designations'] = $this->Designation_model->all_designations();

		$data['all_user_roles'] = $this->Roles_model->all_user_roles();

		$data['all_office_shifts'] = $this->Employees_model->all_office_shifts();

		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();

		$data['breadcrumbs'] = $this->lang->line('xin_employees_onboard_manage');

		if (!in_array('79', $role_resources_ids)) {

			$data['path_url'] = 'myteam_employees';
		} else {

			$data['path_url'] = 'employees';
		}



		// reports to 

		$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('79', $role_resources_ids) || $reports_to > 0) {

			if (!empty($session)) {

				$data['subview'] = $this->load->view("admin/employees/employees_edit", $data, TRUE);
				$data['dname'] = $this->input->get("dname");
				$data['degnid'] = $this->input->get("degnid");
				$this->load->view('admin/layout/layout_main', $data); //page load

			} else {

				redirect('admin/');
			}
		} else {

			redirect('admin/dashboard');
		}
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	public function documents_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$documents = $this->Employees_model->set_employee_documents($id);
		$data = array();
		foreach ($documents->result() as $r) {
			$d_type = $this->Employees_model->read_document_type_information($r->document_type_id);

			if (!is_null($d_type)) {

				$document_d = $d_type[0]->document_type;
			} else {

				$document_d = '--';
			}

			if ($r->date_of_expiry == '') {

				$date_of_expiry = '';
			} else {

				$date_of_expiry = $this->Xin_model->set_date_format($r->date_of_expiry);
			}

			if ($r->document_file != '' && $r->document_file != 'no file') {

				// $functions = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Download"><a href="' . site_url() . 'admin/download?type=document&filename=' . $r->document_file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" title="' . $this->lang->line('xin_download') . '"><i class="oi oi-cloud-download"></i></button></a></span>';
				$functions = '';
			} else {

				$functions = '';
			}

			/*if($r->is_alert==1){

			 	$alert = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_e_details_alert_notifyemail').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><i class="fa fa-bell"></i></button></span>';

			 } else {

				 $alert = '';

			 }*/
			if ($r->serialized != '' && $r->serialized != 'null' && $r->serialized != 'NULL' && $r->serialized != NULL && $r->serialized != null) {
				$color = 'style="color:red"';
				$style = "red";
			} else {
				$color = 'style="color:green"';
				$style = "";
			}



			$data[] = array(


				$document_d,

				$r->title,

				$date_of_expiry,

				$functions . '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->document_id . '" data-field_type="document_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->document_id . '" data-token_type="document"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $documents->num_rows(),

			"recordsFiltered" => $documents->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function qualification_view()
	{
		//set data
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);
		$qualification = $this->Employees_model->set_employee_qualification($id);
		$data = array();
		foreach ($qualification->result() as $r) {
			$education = $this->Employees_model->read_education_information($r->education_level_id);

			if (!is_null($education)) {

				$edu_name = $education[0]->name;
			} else {

				$edu_name = '--';
			}

			//	$language = $this->Employees_model->read_qualification_language_information($r->language_id);

			/*if($r->skill_id == 'no course') {

				$ol = 'No Course';

			} else {

				$ol = '<ol class="nl">';

				foreach(explode(',',$r->skill_id) as $desig_id) {

					$skill = $this->Employees_model->read_qualification_skill_information($desig_id);

					$ol .= '<li>'.$skill[0]->name.'</li>';

				 }

				 $ol .= '</ol>';

			}*/

			$sdate = $this->Xin_model->set_date_format($r->from_year);

			$edate = $this->Xin_model->set_date_format($r->to_year);
			$time_period = $sdate . ' - ' . $edate;

			// get date

			$pdate = $time_period;
			if ($r->serialized != '' && $r->serialized != 'null' && $r->serialized != 'NULL' && $r->serialized != NULL && $r->serialized != null) {
				$color = 'color:red';
				$style = 'red';
			} else {
				$color = 'color:green';
				$style = '';
			}

			$data[] = array(


				$r->name,

				$pdate,

				$edu_name,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->qualification_id . '" data-field_type="qualification_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->qualification_id . '" data-token_type="qualification"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $qualification->num_rows(),

			"recordsFiltered" => $qualification->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function experience_view()
	{

		//set data
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$experience = $this->Employees_model->set_employee_experience($id);
		$data = array();
		foreach ($experience->result() as $r) {
			$from_date = $this->Xin_model->set_date_format($r->from_date);

			$to_date = $this->Xin_model->set_date_format($r->to_date);
			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$r->company_name,

				$from_date,

				$to_date,

				$r->post,

				$r->description,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->work_experience_id . '" data-field_type="work_experience_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->work_experience_id . '" data-token_type="work_experience"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $experience->num_rows(),

			"recordsFiltered" => $experience->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function bank_account_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$bank_account = $this->Employees_model->set_employee_bank_account($id);
		$data = array();
		foreach ($bank_account->result() as $r) {
			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$r->account_title,

				$r->account_number,

				$r->bank_name,

				$r->bank_code,

				$r->bank_branch,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->bankaccount_id . '" data-field_type="bank_account_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->bankaccount_id . '" data-token_type="bank_account"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $bank_account->num_rows(),

			"recordsFiltered" => $bank_account->num_rows(),

			"data" => $data

		);
		echo json_encode($output);

		exit();
	}
	public function security_level_list_view()
	{

		//set data
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$security_level = $this->Employees_model->set_employee_security_level($id);
		$data = array();
		foreach ($security_level->result() as $r) {

			$security_type = $this->Xin_model->read_security_level($r->security_type);

			if (!is_null($security_type)) {

				$sc_type = $security_type[0]->name;
			} else {

				$sc_type = '--';
			}
			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$sc_type,

				$r->expiry_date,

				$r->date_of_clearance,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->security_level_id . '" data-field_type="security_level_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->security_level_id . '" data-token_type="security_level"><i class="fas fa-trash-restore"></i></button></span>',


				$style

			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $security_level->num_rows(),

			"recordsFiltered" => $security_level->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function contract_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$contract = $this->Employees_model->set_employee_contract($id);
		$data = array();
		foreach ($contract->result() as $r) {

			// designation

			$designation = $this->Designation_model->read_designation_information($r->designation_id);

			if (!is_null($designation)) {

				$designation_name = $designation[0]->designation_name;
			} else {

				$designation_name = '--';
			}

			//contract type
			$update_value = $r->update_value;
			$contract_type = $this->Employees_model->read_contract_type_information($r->contract_type_id);

			if (!is_null($contract_type)) {

				$ctype = $contract_type[0]->name;
			} else {

				$ctype = '--';
			}

			// date

			$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);


			if ($update_value) {
				$data[] = array(

					$duration,

					$designation_name,

					$ctype,

					$r->title,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->contract_id . '" data-field_type="contract_view">
            				<i class="fa fa-eye" style="
                /* background-color: red; */
                /* border: solid 2px;
                 /*padding: 3px;
                 /*border-radius: 8px;
                /* border: 9px; */
            /*    color: red; */
            "></i>
            				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->contract_id . '" data-token_type="contract">
            				<i class="fas fa-trash-restore"></i></button></span>',


				);
			} else {
				$data[] = array(

					$duration,

					$designation_name,

					$ctype,

					$r->title,

					'
            <span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->contract_id . '" data-field_type="contract_view">
            				<i class="fa fa-eye" style="
                /* background-color: red; */
                /* border: solid 2px;
                 /*padding: 3px;
                 /*border-radius: 8px;
                /* border: 9px; */
                /* color: green; */
            "></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->contract_id . '" data-token_type="contract">
            				<i class="fas fa-trash-restore"></i></button></span>',


				);
			}
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $contract->num_rows(),

			"recordsFiltered" => $contract->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_overtime_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$id = $this->uri->segment(4);

		$overtime = $this->Employees_model->set_employee_overtime($id);

		$system = $this->Xin_model->read_setting_info(1);

		$data = array();



		foreach ($overtime->result() as $r) {

			$current_amount = $r->overtime_rate;

			$data[] = array(

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->salary_overtime_id . '" data-field_type="emp_overtime_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->salary_overtime_id . '" data-token_type="emp_overtime"><span class="fas fa-trash-restore"></span></button></span>',

				$r->overtime_type,

				$r->no_of_days,

				$r->overtime_hours,

				$current_amount

			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $overtime->num_rows(),

			"recordsFiltered" => $overtime->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function visa_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$visa = $this->Employees_model->set_employee_visa($id);
		$data = array();
		foreach ($visa->result() as $r) {
			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);


			$update_value = $r->update_value;
			if ($update_value) {

				$color = 'red';
				$data[] = array(

					$r->visa_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->visa_id . '" data-field_type="visadocument_view">
            				<i class="fa fa-eye" style="
                /* background-color: red; */
                /* border: solid 2px;
                 /*padding: 3px;
                 /*border-radius: 8px;
                /* border: 9px; */
                /* color: red; */
            "></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->visa_id . '" data-token_type="visadocument">
            				<i class="fas fa-trash-restore"></i></button></span>',


					$color,



				);
			} else {

				$color = 'green';
				$data[] = array(

					$r->visa_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->visa_id . '" data-field_type="visadocument_view">
            				<i class="fa fa-eye" style="
                /* background-color: red; */
                /* border: solid 2px;
                 /*padding: 3px;
                 /*border-radius: 8px;
                /* border: 9px; */
                /* color: green; */
            "></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->visa_id . '" data-token_type="visadocument">
            				<i class="fas fa-trash-restore"></i></button></span>',


					$color,

					// 			$c_name,

					// 			$eligible_review_date,

				);
			}
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $visa->num_rows(),

			"recordsFiltered" => $visa->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function vehicle_view()
	{
		//set data
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$vehicle = $this->Employees_model->set_employee_vehicle($id);
		$data = array();
		foreach ($vehicle->result() as $r) {
			$vehicle_name = $this->Employees_model->vehicle($r->type);
			if ($r->local_store != '' && $r->local_store != 'NULL' && $r->local_store != NULL) {
				$change = 'color: red;';
				$style = 'red';
			} else {
				$change = 'color: green;';
				$style = '';
			}
			$data[] = array(


				$vehicle_name[0]->type,

				$r->number,

				$r->date,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '" data-field_type="vehicledocument_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="vehicledocument"><i class="fas fa-trash-restore"></i></button></span>',


				$style

				// 			$c_name,

				// 			$eligible_review_date,

			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $vehicle->num_rows(),

			"recordsFiltered" => $vehicle->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function insurance_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$insurance = $this->Employees_model->set_employee_insurance($id);
		$data = $output = array();
		foreach ($insurance->result() as $r) {
			$issue_date = $this->Xin_model->set_date_format($r->issue_date);
			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			if ($r->company_name == '') {
				$company = '';
			} else {
				$company = $r->company_name;
			}
			$update_value = $r->update_value;
			if ($update_value) {
				$data[] = array(


					$r->list,

					$company,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
        				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->insurance_id . '" data-field_type="insurancedocument_view">
        					<i class="fa fa-eye" style="/* color: red;*/"></i>
        				</i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->insurance_id . '" data-token_type="insurancedocument"><i class="fas fa-trash-restore"></i></button></span>',


					// 			$c_name,

					// 			$eligible_review_date,

				);
				$output = array(

					"draw" => $draw,

					"recordsTotal" => $insurance->num_rows(),

					"recordsFiltered" => $insurance->num_rows(),

					"data" => $data

				);
			} else {
				$data[] = array(


					$r->list,

					$company,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->insurance_id . '" data-field_type="insurancedocument_view">
            			<i class="fa fa-eye" style="/* color: green; */"></i>
            			</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->insurance_id . '" data-token_type="insurancedocument"><i class="fas fa-trash-restore"></i></button></span>',


					// 			$c_name,

					// 			$eligible_review_date,

				);
				$output = array(
					"draw" => $draw,
					"recordsTotal" => $insurance->num_rows(),
					"recordsFiltered" => $insurance->num_rows(),
					"data" => $data

				);
			}
		}
		if (empty($output)) {
			$output = array(
				"draw" => $draw,
				"recordsTotal" => $insurance->num_rows(),
				"recordsFiltered" => $insurance->num_rows(),
				"data" => $data

			);
		}

		echo json_encode($output);
		exit();
	}
	public function license_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$license = $this->Employees_model->set_employee_license($id);
		$data = array();
		foreach ($license->result() as $r) {
			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);

			$update_value = $r->update_value;
			if ($update_value) {
				$color = 'red';

				$data[] = array(


					$r->list,



					$issue_date,

					$expiry_date,

					// 			$c_name,

					$r->renew_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->license_id . '" data-field_type="licensedocument_view">
            			<i class="fa fa-eye"></i>
            				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->license_id . '" data-token_type="licensedocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color,

				);
			} else {
				$color = 'green';
				$data[] = array(


					$r->list,
					$issue_date,

					$expiry_date,

					// 			$c_name,

					$r->renew_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->license_id . '" data-field_type="licensedocument_view">
            			<i class="fa fa-eye"></i>
            			
            				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->license_id . '" data-token_type="licensedocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color,

				);
			}
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $license->num_rows(),

			"recordsFiltered" => $license->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function passport_view()
	{
		//set data
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$passport = $this->Employees_model->set_employee_passport($id);
		$data = array();
		foreach ($passport->result() as $r) {
			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);


			$update_value = $r->update_value;
			if ($update_value) {

				$style = 'red';

				$data[] = array(

					$r->passport_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					// 			$c_name,

					// 			$eligible_review_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
        				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->passport_id . '" data-field_type="passportdocument_view">
        						<i class="fa fa-eye" style="
            /* background-color: red; */
            /* border: solid 2px;
             /*padding: 3px;
             /*border-radius: 8px;
            /* border: 9px; */
            /* color: red;*/
        "></i>
        				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->passport_id . '" data-token_type="passportdocument"><i class="fas fa-trash-restore"></i></button></span>',



					$style

				);
			} else {

				$style = '';
				$data[] = array(

					$r->passport_id_num,

					$r->title,

					$issue_date,

					$expiry_date,

					// 			$c_name,

					// 			$eligible_review_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
        				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->passport_id . '" data-field_type="passportdocument_view">
        			 <i class="fa fa-eye"  style="
            /* background-color: red; */
            /* border: solid 2px;
             /*padding: 3px;
             /*border-radius: 8px;
            /* border: 9px; */
            /* color: green; */
        "></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
        				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->passport_id . '" data-token_type="passportdocument">
        				<i class="fas fa-trash-restore"></i></button></span>',



					$style

				);
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $passport->num_rows(),

			"recordsFiltered" => $passport->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function cpr_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$cpr = $this->Employees_model->set_employee_cpr($id);
		$data = array();
		foreach ($cpr->result() as $r) {
			$issue_date = $this->Xin_model->set_date_format($r->issue_date);

			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);
			$update_value = $r->update_value;
			if ($update_value) {
				$color = 'red';

				$data[] = array(


					$r->cpr_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->cpr_id . '" data-field_type="cprdocument_view">
            				<i class="fa fa-eye" style="/* color: red; */">	</i>
            			
            				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->cpr_id . '" data-token_type="cprdocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color
					// 			$c_name,

					// 			$eligible_review_date,

				);
			} else {
				$color = 'green';
				$data[] = array(


					$r->cpr_num,

					$r->title,

					$issue_date,

					$expiry_date,

					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->cpr_id . '" data-field_type="cprdocument_view">
            				<i class="fa fa-eye" style="/* color: green; */">	</i>
            				</button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
            				<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->cpr_id . '" data-token_type="cprdocument"><i class="fas fa-trash-restore"></i></button></span>',


					$color

					// 			$c_name,

					// 			$eligible_review_date,

				);
			}
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $cpr->num_rows(),

			"recordsFiltered" => $cpr->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function deduction_all_history_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_sal_history($id, 3);
		$data = array();

		$allowance_option = '';

		$inc_or_dec = '';

		if ($commissions->result()) {

			foreach ($commissions->result() as $r) {

				$allowance_det_emp = $this->Employees_model->read_single_salary_statutory_deduction($r->allowance_id);

				if ($allowance_det_emp) {

					$allowance_det = $this->Xin_model->read_single_allowance($allowance_det_emp[0]->deduction_title);

					if ($allowance_det_emp[0]->statutory_options == 0) {

						$allowance_option = $this->lang->line('xin_title_tax_fixed');
					} else if ($allowance_det_emp[0]->statutory_options == 1) {

						$allowance_option = $this->lang->line('xin_title_tax_percent');
					}

					if ($r->inc_or_dec == 'inc') {

						//$inc_or_dec = $r->inc_amt.' incremented';
						$inc_or_dec = round($r->inc_percentage, 3) . '% incremented';
					} else if ($r->inc_or_dec == 'dec') {
						$inc_or_dec = round($r->inc_percentage, 3) . '% decremented';
						//$inc_or_dec = $r->inc_amt.' decremented';

					}
					//<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span>

					$data[] = array(

						// 		'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="emp_deduction_history"><span class="fas fa-trash-restore"></span></button></span>',

						$allowance_det[0]->name,

						$allowance_option,

						$r->amount,

						($r->inc_amt == 0) ? '' : $r->date,

						($r->inc_amt == 0) ? '' : $inc_or_dec

					);
				}
			}
		} else {

			$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($id);

			if ($statutory_deductions->result()) {

				foreach ($statutory_deductions->result() as $r) {

					if ($r->statutory_options == 0) {

						$sd_amount_opt = $this->lang->line('xin_title_tax_fixed');
					} else {

						$sd_amount_opt = $this->lang->line('xin_title_tax_percent');
					}

					$allo = $this->Xin_model->read_constant_allowance($r->deduction_title);

					if ($allo) {
						$allo_name = $allo[0]->name;
					} else {
						$allo_name = "";
					}

					$data[] = array(

						// 		'#',

						$allo_name,

						$sd_amount_opt,

						$r->deduction_amount,

						$r->created_at,

						'',

					);
				}
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function allowance_all_history_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_sal_history($id, 2);
		$data = array();

		$allowance_option = '';

		$inc_or_dec = '';

		$emp_info =  $this->Employees_model->read_employee_information($id);

		if ($commissions->result()) {

			foreach ($commissions->result() as $r) {

				$allowance_det_emp = $this->Employees_model->read_single_salary_allowance($r->allowance_id);

				if ($allowance_det_emp) {

					$allowance_det = $this->Xin_model->read_single_allowance($allowance_det_emp[0]->allowance_title);

					if ($allowance_det_emp[0]->amount_option == 0) {

						$allowance_option = $this->lang->line('xin_title_tax_fixed');
					} else if ($allowance_det_emp[0]->amount_option == 1) {

						$allowance_option = $this->lang->line('xin_title_tax_percent');
					}

					if ($r->inc_or_dec == 'inc') {

						//$inc_or_dec = $r->inc_amt.' incremented';
						$inc_or_dec = round($r->inc_percentage, 3) . '% incremented';
					} else if ($r->inc_or_dec == 'dec') {
						$inc_or_dec = round($r->inc_percentage, 3) . '% decremented';
						//$inc_or_dec = $r->inc_amt.' decremented';

					}



					//<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span>

					$data[] = array(

						// 		'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="emp_allowance_history"><span class="fas fa-trash-restore"></span></button></span>',

						$allowance_det[0]->name,

						$allowance_option,

						$r->amount,

						$r->date,

						($r->inc_amt == 0) ? 'First allowance amount' : $inc_or_dec

					);
				}
			}
		} else {

			$allowances = $this->Employees_model->set_employee_allowances($id);

			if ($allowances->result()) {

				foreach ($allowances->result() as $r) {

					//$current_amount = $r->allowance_amount * $current_rate;

					if ($r->amount_option == 0) {

						$allowance_amount_opt = $this->lang->line('xin_title_tax_fixed');
					} else {

						$allowance_amount_opt = $this->lang->line('xin_title_tax_percent');
					}

					if ($r->is_allowance_taxable == 0) {

						$allowance_opt = $this->lang->line('xin_salary_allowance_non_taxable');
					} else if ($r->is_allowance_taxable == 1) {

						$allowance_opt = $this->lang->line('xin_fully_taxable');
					} else {

						$allowance_opt = $this->lang->line('xin_partially_taxable');
					}

					//$allo=$this->Xin_model->read_allo($r->allowance_title);

					$allo = $this->Xin_model->read_single_allowance($r->allowance_title);

					$data[] = array(

						// 		'#',

						(isset($allo[0]->name)) ? $allo[0]->name : '',

						$r->allowance_amount,

						$allowance_opt,

						$r->created_at,

						''

					);
				}
			}
		}



		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_all_allowances_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$allowances = $this->Employees_model->set_employee_allowances($id);
		$data = array();

		/*$system = $this->Xin_model->read_setting_info(1);

		$default_currency = $this->Xin_model->read_currency_con_info($system[0]->default_currency_id);

		if(!is_null($default_currency)) {

			$current_rate = $default_currency[0]->to_currency_rate;

			$current_title = $default_currency[0]->to_currency_title;

		} else {

			$current_rate = 1;

			$current_title = 'USD';

		}*/



		foreach ($allowances->result() as $r) {

			//$current_amount = $r->allowance_amount * $current_rate;

			if ($r->amount_option == 0) {

				$allowance_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$allowance_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			if ($r->is_allowance_taxable == 0) {

				$allowance_opt = $this->lang->line('xin_salary_allowance_non_taxable');
			} else if ($r->is_allowance_taxable == 1) {

				$allowance_opt = $this->lang->line('xin_fully_taxable');
			} else {

				$allowance_opt = $this->lang->line('xin_partially_taxable');
			}

			//$allo=$this->Xin_model->read_allo($r->allowance_title);

			$allo = $this->Xin_model->read_single_allowance($r->allowance_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			// 			$status = '<input type="radio" value="Y"  name="status_allowance' . $r->allowance_id . '" id="status_allowance' . $r->allowance_id . '" ';
			$status = '';

			if ($r->status == 'Y') {

				$status = 'Active';
			}

			// 			$status .= ' onClick="update_status(' . $r->allowance_id . ',' . $status_val . ')">

			// 					Active <br/>

			// 					<input type="radio" value="N"

			// 						name="status_allowance' . $r->allowance_id . '" id="status_allowance' . $r->allowance_id . '"';

			if ($r->status == 'N') {

				$status = 'Inactive';
			}

			// 			$status .= ' onClick="update_status(' . $r->allowance_id . ',' . $status_val . ')">Inactive';

			$data[] = array(


				(isset($allo[0]->name)) ? $allo[0]->name : '',

				$r->allowance_amount,

				$allowance_opt,

				$allowance_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->allowance_id . '" data-field_type="salary_allowance_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->allowance_id . '" data-token_type="all_allowances"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $allowances->num_rows(),

			"recordsFiltered" => $allowances->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_all_history_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_sal_history($id, 1);
		$data = array();

		$emp_info =  $this->Employees_model->read_employee_information($id);

		if ($emp_info) {

			if ($commissions->result()) {

				foreach ($commissions->result() as $r) {

					/*if($r->wages_type==1){

					$wages_type = $this->lang->line('xin_payroll_basic_salary');

				} else if($r->wages_type==2){

					$wages_type = $this->lang->line('xin_employee_daily_wages');

				}*/

					if ($r->inc_or_dec == 'inc') {

						//	$inc_or_dec = $r->inc_amt.' incremented';
						$inc_or_dec = round($r->inc_percentage, 3) . '% incremented';
					} else if ($r->inc_or_dec == 'dec') {

						$inc_or_dec = round($r->inc_percentage, 3) . '% decremented';
					}

					//<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->id . '" data-field_type="salary_commissions"><span class="fas fa-pencil-alt"></span></button></span>



					$data[] = array(

						// 		'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="emp_salary_his"><span class="fas fa-trash-restore"></span></button></span>',

						//$wages_type,

						$r->amount,

						date('Y-m-d', strtotime($r->date)),

						($r->inc_amt == 0 && $r->inc_or_dec == 0) ? 'First basic pay' : $inc_or_dec

					);
				}
			} else {

				$data[] = array(

					// 	'#',

					//$wages_type,

					$emp_info[0]->basic_salary,

					date('Y-m-d', strtotime($emp_info[0]->created_at)),

					'Basic Salary'

				);
			}
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function emp_all_indemnity_view()
	{

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$allowances = $this->Employees_model->set_employee_indemnity($id);
		$data = array();

		$status = '';

		foreach ($allowances->result() as $r) {
			if ($r->status == 1) {
				$status = 'Unpaid';
			} else if ($r->status == 2) {
				$status = 'Paid';
			}
			$act = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '" data-field_type="emp_indeminty_view"><i class="fa fa-eye"></i></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '" data-token_type="all_emp_indeminty"><span class="fas fa-trash-restore"></span></button></span>';
			$year_desc = date('d F, Y', strtotime($r->from_date)) . ' to ' . (date('d F, Y', strtotime($r->to_date)));

			if ($r->by_cash == 'on') {
				$status_cash = 'Yes';
			} else {
				$status_cash = 'No';
			}

			$data[] = array(



				$r->year . '- (' . $year_desc . ')',

				$r->amount,
				$r->balance_amount,
				$r->indemninty_month,

				$status,
				$status_cash,
				$act,


			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $allowances->num_rows(),

			"recordsFiltered" => $allowances->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_all_commissions_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$commissions = $this->Employees_model->set_employee_commissions($id);
		$data = array();
		foreach ($commissions->result() as $r) {

			if ($r->amount_option == 0) {

				$commission_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$commission_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			if ($r->is_commission_taxable == 0) {

				$commission_opt = $this->lang->line('xin_salary_allowance_non_taxable');
			} else if ($r->is_commission_taxable == 1) {

				$commission_opt = $this->lang->line('xin_fully_taxable');
			} else {

				$commission_opt = $this->lang->line('xin_partially_taxable');
			}

			$allo = $this->Xin_model->read_allo($r->commission_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			// 			$status = '<input type="radio" value="Y"  name="status_commission' . $r->salary_commissions_id . '" id="status_commission' . $r->salary_commissions_id . '" ';
			$status = '';
			if ($r->status == 'Y') {

				$status = 'Active';
			}

			// 			$status .= ' onClick="update_status_commissions(' . $r->salary_commissions_id . ',' . $status_val . ')">

			// 						Active <br/>

			// 						<input type="radio" value="N"

			// 							name="status_commission' . $r->salary_commissions_id . '" id="status_commission' . $r->salary_commissions_id . '"';

			if ($r->status == 'N') {

				$status = 'Inactive';
			}

			// 			$status .= ' onClick="update_status_commissions(' . $r->salary_commissions_id . ',' . $status_val . ')">Inactive';

			$data[] = array(


				$allo[0]->name,

				$r->commission_amount,

				$commission_opt,

				$commission_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->salary_commissions_id . '" data-field_type="salary_commissions_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->salary_commissions_id . '" data-token_type="all_commissions"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $commissions->num_rows(),

			"recordsFiltered" => $commissions->num_rows(),

			"data" => $data

		);
		echo json_encode($output);

		exit();
	}
	public function leave_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);

		$leave = $this->Timesheet_model->get_leave_employees($id);



		$data = array();

		foreach ($leave->result() as $r) {

			// contract

			$data[] = array(

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->id . '" data-field_type="leave_view"><i class="fa fa-eye"></i></button></span>',

				$contracti,

				$r->type_name,

				$r->leave_count

			);
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => $leave->num_rows(),

			"recordsFiltered" => $leave->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_all_statutory_deductions_view()
	{

		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($id);
		$data = array();
		foreach ($statutory_deductions->result() as $r) {
			if ($r->statutory_options == 0) {

				$sd_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$sd_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			$allo = $this->Xin_model->read_constant_allowance($r->deduction_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			// 			$status = '<input type="radio" value="Y"  name="status_dedu' . $r->statutory_deductions_id  . '" id="status_dedu' . $r->statutory_deductions_id  . '" ';
			$status = '';
			if ($r->status == 'Y') {

				$status = 'Active';
			}

			// 			$status .= ' onClick="update_status_deductions(' . $r->statutory_deductions_id . ',' . $status_val . ')">

			// 						Active <br/>

			// 						<input type="radio" value="N"

			// 							name="status_dedu' . $r->statutory_deductions_id . '" id="status_dedu' . $r->statutory_deductions_id . '"';

			if ($r->status == 'N') {

				$status = 'Inactive';
			}

			// 			$status .= ' onClick="update_status_deductions(' . $r->statutory_deductions_id . ',' . $status_val . ')">Inactive';

			if ($allo) {
				$allo_name = $allo[0]->name;
			} else {
				$allo_name = "";
			}
			$data[] = array(


				$allo_name,

				$r->deduction_amount,

				$sd_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->statutory_deductions_id . '" data-field_type="salary_statutory_deductions_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->statutory_deductions_id . '" data-token_type="all_statutory_deductions"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $statutory_deductions->num_rows(),

			"recordsFiltered" => $statutory_deductions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_all_other_payments_view()
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$other_payment = $this->Employees_model->set_employee_other_payments($id);
		$data = array();
		foreach ($other_payment->result() as $r) {

			if ($r->amount_option == 0) {

				$other_amount_opt = $this->lang->line('xin_title_tax_fixed');
			} else {

				$other_amount_opt = $this->lang->line('xin_title_tax_percent');
			}

			if ($r->is_otherpayment_taxable == 0) {

				$other_opt = $this->lang->line('xin_salary_allowance_non_taxable');
			} else if ($r->is_otherpayment_taxable == 1) {

				$other_opt = $this->lang->line('xin_fully_taxable');
			} else {

				$other_opt = $this->lang->line('xin_partially_taxable');
			}

			$allo = $this->Xin_model->read_constant_allowance($r->payments_title);

			$status_val = ($r->status == 'Y') ? 1 : 2;

			// 			$status = '<input type="radio" value="Y"  name="status_other' . $r->other_payments_id . '" id="status_other' . $r->other_payments_id . '" ';
			$status = '';

			if ($r->status == 'Y') {

				$status = 'Active';
			}

			// 			$status .= ' onClick="update_status_other_payments(' . $r->other_payments_id . ',' . $status_val . ')">

			// 						Active <br/>

			// 						<input type="radio" value="N"

			// 							name="status_other' . $r->other_payments_id . '" id="status_other' . $r->other_payments_id . '"';

			if ($r->status == 'N') {

				$status = 'Inactive';
			}

			// 			$status .= ' onClick="update_status_other_payments(' . $r->other_payments_id . ',' . $status_val . ')">Inactive';

			$data[] = array(


				(isset($allo[0]->name)) ? $allo[0]->name : '',

				$r->payments_amount,

				$other_opt,

				$other_amount_opt,

				($r->applicable_for_paysalary == 1) ? 'Yes' : 'No',

				$status,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->other_payments_id . '" data-field_type="salary_other_payments_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->other_payments_id . '" data-token_type="all_other_payments"><span class="fas fa-trash-restore"></span></button></span>',


			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $other_payment->num_rows(),

			"recordsFiltered" => $other_payment->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function salary_all_deductions_view($employee_id = 0)
	{
		//set data

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$id = $this->uri->segment(4);

		$deductions = $this->Employees_model->set_employee_deductions($id);

		/*$system = $this->Xin_model->read_setting_info(1);

		$default_currency = $this->Xin_model->read_currency_con_info($system[0]->default_currency_id);

		if(!is_null($default_currency)) {

			$current_rate = $default_currency[0]->to_currency_rate;

			$current_title = $default_currency[0]->to_currency_title;

		} else {

			$current_rate = 1;

			$current_title = 'USD';

		}*/

		$data = array();
		foreach ($deductions->result() as $r) {
			$sdate = $this->Xin_model->set_date_format($r->start_date);

			$edate = $this->Xin_model->set_date_format($r->end_date);

			// loan time

			if ($r->loan_time < 2) {

				$loan_time = $r->loan_time . ' ' . $this->lang->line('xin_employee_loan_time_single_month');
			} else {

				$loan_time = $r->loan_time . ' ' . $this->lang->line('xin_employee_loan_time_more_months');
			}

			if ($r->loan_options == 1) {

				$loan_options = $this->lang->line('xin_loan_ssc_title');
			} else if ($r->loan_options == 2) {

				//	$loan_options = $this->lang->line('xin_loan_hdmf_title');
				$loan_options = 'Personal Loan';
			} else {
				$loan_options = 'Other Loan';
				//$loan_options = $this->lang->line('xin_loan_other_sd_title');

			}

			$loan_details = '<div class="text-semibold">' . $this->lang->line('dashboard_xin_title') . ': ' . $r->loan_deduction_title . '</div>

								<div class="text-muted">' . $this->lang->line('xin_salary_loan_options') . ': ' . $loan_options . '</div><div class="text-muted">' . $this->lang->line('xin_start_date') . ': ' . $sdate . '</div><div class="text-muted">' . $this->lang->line('xin_end_date') . ': ' . $edate . '</div><div class="text-muted">' . $this->lang->line('xin_reason') . ': ' . $r->reason . '</div>';

			//$eoption_removed = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-info waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->loan_deduction_id . '" data-field_type="salary_loan"><span class="fas fa-pencil-alt"></span></button></span>';

			$status_val = ($r->loan_status == 'Y') ? 1 : 2;

			$status = '<input type="radio" value="Y"  name="status_loan' . $r->loan_deduction_id . '" id="status_loan' . $r->loan_deduction_id . '" ';

			if ($r->loan_status == 'Y') {

				$status .= 'checked="checked"';
			}

			$status .= ' onClick="update_status_loans(' . $r->loan_deduction_id . ',' . $status_val . ')">

					Active <br/>

					<input type="radio" value="N"

						name="status_loan' . $r->loan_deduction_id . '" id="status_loan' . $r->loan_deduction_id . '"';

			if ($r->loan_status == 'N') {

				$status .= 'checked="checked"';
			}

			$role_ids = $this->Xin_model->user_role_resource();
			//  var_dump($role_ids);die();
			$disable = '';
			if ($r->status != 0 && !in_array('9807', $role_ids) && !in_array('9808', $role_ids) && !in_array('9809', $role_ids) && !in_array('9810', $role_ids)) {
				$disable = 'disabled="true"';
			}

			$status .= ' onClick="update_status_loans(' . $r->loan_deduction_id . ',' . $status_val . ')">Inactive';
			if (in_array('9803', $role_ids)) {
				$edit_res =  '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" ' . $disable . ' class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->loan_deduction_id . '" data-field_type="salary_loan_view" ><i class="fa fa-eye"></i></button></span>';
			} else {
				$edit_res =  '';
			}
			if (in_array('9804', $role_ids)) {
				//  $dlt_res =  '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" '.$disable.' class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->loan_deduction_id . '" data-token_type="all_deductions"><span class="fas fa-trash-restore"></span></button></span>';

				$dlt_res =  '';
			} else {
				$dlt_res =  '';
			}
			if (in_array('9805', $role_ids)) {
				//  $loan_approve = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Approve loan"><a class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" '.$disable.' href="'.base_url('admin/employees_loan?id='.$r->loan_deduction_id).'"><i class="fas fa-vote-yea"></i></a></span>';

				$loan_approve =  '';
			} else {
				$loan_approve =  '';
			}
			if (in_array('9806', $role_ids)) {
				//   $loan_extend = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Extend loan"><button type="button" '.$disable.' class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data-loan-dec" data-field_id="' . $r->loan_deduction_id . '" data-field_type="salary_loan_extend" ><span class="fas fa-calendar-alt"></span></button></span>';

				$loan_extend =  '';
			} else {
				$loan_extend =  '';
			}
			$combhr = $edit_res . $dlt_res . $loan_extend . $loan_approve;
			// $combhr='';
			$data[] = array(

				$loan_details,
				$r->monthly_installment,
				$loan_time,
				//	($r->applicable_for_paysalary == 1)?'Yes':'No',
				//	$status
				$combhr,
			);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $deductions->num_rows(),

			"recordsFiltered" => $deductions->num_rows(),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}
	public function car_travel_view($employee_id = 0)
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		$this->db->where('user_id', $session['user_id']);

		$employee = $this->db->get('xin_employees')->row();
		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$airtickets = $this->Employees_model->get_car_travels($employee_id);
		$data = array();
		if ($airtickets->result()) {
			foreach ($airtickets->result() as $r) {

				if ($employee->user_role_id == 1) {

					$tmp[] = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#edit-modal-car_travels" data-car_ticket_id="' . $r->id . '"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light " data-toggle="modal" data-target=".delete-modal-car_travels" data-car_ticket_id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
				}

				$tmp[] = ($r->vehicle_car_travel == 1) ? 'Yes' : 'No';

				$tmp[] = $r->vehicle_type . '<br><small></small>';

				$tmp[] = $r->vehicle_model . '<br><small></small>';

				$tmp[] = $r->vehicle_number . '<br><small></small>';

				$tmp[] = ucfirst($r->with_without_fuel);
				$data[] = $tmp;

				unset($tmp);
			}
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $airtickets->num_rows(),

			"recordsFiltered" => $airtickets->num_rows(),

			"data" => $data

		);
		echo json_encode($output);
		exit();
	}
	public function accomodation_view($employee_id = 0)
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {

			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {

			redirect('admin/');
		}
		$this->db->where('user_id', $session['user_id']);

		$employee = $this->db->get('xin_employees')->row();
		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
		$airtickets = $this->Employees_model->get_accomodation($employee_id);
		$data = array();
		foreach ($airtickets->result() as $r) {

			if ($employee->user_role_id == 1) {

				$tmp[] = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#edit-modal-accomodation" data-acco_ticket_id="' . $r->id . '"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light " data-toggle="modal" data-target=".delete-modal-accomodation" data-acco_ticket_id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
			}

			$tmp[] = ($r->vehicle_accomodation == 1) ? 'Yes' : 'No';

			$tmp[] = $r->type_accomodation . '<br><small></small>';

			$tmp[] = $r->house_villa_flat_no . '<br><small></small>';

			$tmp[] = $r->accomodation_city . '<br><small></small>';

			$tmp[] = ucfirst($r->accomodation_address);

			$tmp[] = ucfirst($r->accomodation_paid_unpaid);
			$data[] = $tmp;

			unset($tmp);
		}
		$output = array(

			"draw" => $draw,

			"recordsTotal" => $airtickets->num_rows(),

			"recordsFiltered" => $airtickets->num_rows(),

			"data" => $data

		);
		echo json_encode($output);
		exit();
	}
	public function dialog_contact_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_contact_information($id);

		$data = array(

			'contact_id' => $result[0]->contact_id,

			'employee_id' => $result[0]->employee_id,

			'relation' => $result[0]->relation,

			'is_primary' => $result[0]->is_primary,

			'is_dependent' => $result[0]->is_dependent,

			'contact_name' => $result[0]->contact_name,

			'work_phone' => $result[0]->work_phone,

			'work_phone_extension' => $result[0]->work_phone_extension,

			'mobile_phone' => $result[0]->mobile_phone,

			'home_phone' => $result[0]->home_phone,

			'work_email' => $result[0]->work_email,

			'personal_email' => $result[0]->personal_email,

			'address_1' => $result[0]->address_1,

			'address_2' => $result[0]->address_2,

			'city' => $result[0]->city,

			'state' => $result[0]->state,

			'zipcode' => $result[0]->zipcode,

			'icountry' => $result[0]->country,

			'all_countries' => $this->Xin_model->get_countries()

		);
		$local_store = $this->Employees_model->read_contact_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['relation'] = $un_local['relation'];
			$data['work_email'] = $un_local['work_email'];
			$data['personal_email'] = $un_local['personal_email'];
			$data['address_1'] = $un_local['address_1'];
			$data['address_2'] = $un_local['address_2'];
			$data['work_phone'] = $un_local['work_phone'];
			$data['work_phone_extension'] = $un_local['work_phone_extension'];
			$data['contact_name'] = $un_local['contact_name'];
			$data['mobile_phone'] = $un_local['mobile_phone'];
			$data['city'] = $un_local['city'];
			$data['is_primary'] = $un_local['is_primary'];
			$data['is_dependent'] = $un_local['is_dependent'];
			$data['home_phone'] = $un_local['home_phone'];
			$data['state'] = $un_local['state'];
			$data['zipcode'] = $un_local['zipcode'];
			$data['country'] = $un_local['country'];
			$data['icountry'] = $un_local['country'];
		}
		$data['changes'] = $this->Employees_model->read_changes_local($id);
		$data['local_store'] = $this->Employees_model->read_local_store($id);

		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_imgdocument_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_imgdocument_information($id);
		$immiprinted = '';
		if ($document[0]->serialized != "" && $document[0]->serialized != 'null' && $document[0]->serialized != 'NULL' && $document[0]->serialized != NULL && $document[0]->serialized != null) {
			$immiprinted = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($document[0]->serialized);
			// var_dump($ress);	die();
			if ($document[0]->document_number != $ress['document_number']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_employee_document_number') . " : " . $ress['document_number'] . "</span></br>";
			}
			$document[0]->document_number = $ress['document_number'];
			if (isset($ress['document_file'])) {
				if ($document[0]->document_file != $ress['document_file']) {
					$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_e_details_document_file') . " : " . $ress['document_file'] . "</span></br>";
				}
				$document[0]->document_file = $ress['document_file'];
			}
			if ($document[0]->issue_date != $ress['issue_date']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_issue_date') . " : " . $ress['issue_date'] . "</span></br>";
			}
			$document[0]->issue_date = $ress['issue_date'];

			if ($document[0]->expiry_date != $ress['expiry_date']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_expiry_date') . " : " . $ress['expiry_date'] . "</span></br>";
			}
			$document[0]->expiry_date = $ress['expiry_date'];

			if ($document[0]->eligible_review_date != $ress['eligible_review_date']) {
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_eligible_review_date') . " : " . $ress['eligible_review_date'] . "</span></br>";
			}
			$document[0]->eligible_review_date = $ress['eligible_review_date'];

			if ($document[0]->document_type_id != $ress['document_type_id']) {
				$all_document_types = $this->Employees_model->all_document_types();
				$all_docs = '';
				foreach ($all_document_types as $docs) {
					if (isset($_GET)) {
						if (in_array($docs->document_type_id, explode(",", $ress['document_type_id']))) {
							$all_docs = $all_docs . $docs->document_type;
						}
					}
				}
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_e_details_document') . " : " . $all_docs . "</span></br>";
			}
			$document[0]->document_type_id = $ress['document_type_id'];

			if ($document[0]->country_id != $ress['country_id']) {
				$get_countries = $this->Xin_model->get_countries();
				$all_docs = '';
				foreach ($get_countries as $docs) {
					if (isset($_GET)) {
						if (in_array($docs->country_id, explode(",", $ress['country_id']))) {
							$all_docs = $all_docs . $docs->country_name;
						}
					}
				}
				$immiprinted = $immiprinted . "<span>" . $this->lang->line('xin_country') . " : " . $all_docs . "</span></br>";
			}
			$document[0]->country_id = $ress['country_id'];

			$immiprinted = $immiprinted . '</div>';
		}
		$data = array(

			'immigration_id' => $document[0]->immigration_id,

			'document_type_id' => $document[0]->document_type_id,

			'd_employee_id' => $document[0]->employee_id,

			'all_document_types' => $this->Employees_model->all_document_types(),

			'all_countries' => $this->Xin_model->get_countries(),

			'document_number' => $document[0]->document_number,

			'document_file' => $document[0]->document_file,

			'issue_date' => $document[0]->issue_date,

			'expiry_date' => $document[0]->expiry_date,

			'country_id' => $document[0]->country_id,

			'eligible_review_date' => $document[0]->eligible_review_date,
		);
		if (!empty($session)) {
			$data['immiprinted'] = $immiprinted;

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_document_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_document_information($id);
		$document_printed = '';
		if ($document[0]->serialized != "" && $document[0]->serialized != 'null' && $document[0]->serialized != 'NULL' && $document[0]->serialized != NULL && $document[0]->serialized != null) {
			$document_printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($document[0]->serialized);
			if ($document[0]->document_type_id != $ress['document_type_id']) {
				$all_document_types = $this->Employees_model->all_document_types();
				$all_document = '';
				foreach ($all_document_types as $documentss) {
					// var_dump($document);die();
					if (isset($_GET)) {
						if (in_array($documentss->document_type_id, explode(",", $ress['document_type_id']))) {
							$all_document = $all_document . $documentss->document_type;
						}
					}
				}
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_e_details_document') . " : " . $all_document . "</span></br>";
			}
			if ($document[0]->date_of_expiry != $ress['date_of_expiry']) {
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_e_details_doe') . " : " . $ress['date_of_expiry'] . "</span></br>";
			}
			if ($document[0]->title != $ress['title']) {
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_payroll_hourly_wage_title_single') . " : " . $ress['title'] . "</span></br>";
			}
			if ($document[0]->description != $ress['description']) {
				$document_printed = $document_printed . "<span>" . $this->lang->line('xin_description') . " : " . $ress['description'] . "</span></br>";
			}
			if (isset($ress['document_file'])) {
				if ($document[0]->document_file != $ress['document_file']) {
					$document_printed = $document_printed . "<span>" . $this->lang->line('xin_e_details_document_file') . " : " . $ress['document_file'] . "</span></br>";
				}
				$document[0]->document_file = $ress['document_file'];
			}
			$document[0]->document_type_id = $ress['document_type_id'];
			$document[0]->date_of_expiry = $ress['date_of_expiry'];
			$document[0]->title = $ress['title'];
			$document[0]->description = $ress['description'];
			$document_printed = $document_printed . '</div>';
		}

		$data = array(

			'document_id' => $document[0]->document_id,

			'document_type_id' => $document[0]->document_type_id,

			'd_employee_id' => $document[0]->employee_id,

			'all_document_types' => $this->Employees_model->all_document_types(),

			'date_of_expiry' => $document[0]->date_of_expiry,

			'title' => $document[0]->title,

			//'is_alert' => $document[0]->is_alert,

			'description' => $document[0]->description,

			//'notification_email' => $document[0]->notification_email,

			'document_file' => $document[0]->document_file

		);
		if (!empty($session)) {
			$data['document_printed'] = $document_printed;

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_visadocument_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_visadocument_information($id);

		$update_value = $document[0]->update_value;

		if ($update_value) {
			$data_new = (unserialize($update_value));
			//print_r($data_new);

			if ($document[0]->visa_id_num != $data_new['visa_id_num']) {
				$visa_up_num = 'VISA Number :' . $data_new['visa_id_num'];
			} else {
				$visa_up_num = '';
			}

			if ($document[0]->title != $data_new['title']) {
				$Title = 'Title : ' . $data_new['title'];
			} else {
				$Title = '';
			}

			if ($document[0]->file != $data_new['file']) {

				$File = 'File :' . $data_new['file'];
			} else {
				$File = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$issue_date = 'Issue date :' . $data_new['issue_date'];
			} else {
				$issue_date = '';
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$expiry_date = 'Expiry date :' . $data_new['expiry_date'];
			} else {
				$expiry_date = '';
			}
			if ($document[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}

			$data = array(

				'visa_up_num' => $data_new['visa_id_num'],
				'visa_id' => $document[0]->visa_id,
				'title' => $data_new['title'],
				'd_employee_id' => $document[0]->employee_id,
				'document_file' => $data_new['file'],
				'issue_date' => $data_new['issue_date'],
				'expiry_date' => $data_new['expiry_date'],
				'description' => $data_new['description'],
				'update_value' => 'yes',
				//   'visa_id' => $visa_id,
				'Title' => $Title,
				'File' => $File,
				'Issue_date' => $issue_date,
				'Expiry_date' => $expiry_date,
				'description_new' => $description_new,

			);
		} else {
			$data = array(

				'visa_up_num' => $document[0]->visa_id_num,
				'visa_id' => $document[0]->visa_id,
				'title' => $document[0]->title,
				'd_employee_id' => $document[0]->employee_id,
				'document_file' => $document[0]->file,
				'issue_date' => $document[0]->issue_date,
				'expiry_date' => $document[0]->expiry_date,
				'description' => $document[0]->description,
				'update_value' => 'no',
			);
		}
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_passportdocument_view()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_passportdocument_information($id);
		$update_value = $document[0]->update_value;
		if ($update_value) {
			$data_new = (unserialize($update_value));
			if ($document[0]->passport_id_num != $data_new['passport_id_num']) {
				$passport_up_num = 'Passport Number : ' . $data_new['passport_id_num'];
			} else {
				$passport_up_num = '';
			}


			if ($document[0]->title != $data_new['title']) {
				$Title = 'Title : ' . $data_new['title'];
			} else {
				$Title = '';
			}

			if ($document[0]->file != $data_new['file']) {

				$File = 'File :' . $data_new['file'];
			} else {
				$File = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$issue_date = 'Issue date :' . $data_new['issue_date'];
			} else {
				$issue_date = '';
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$expiry_date = 'Expiry date :' . $data_new['expiry_date'];
			} else {
				$expiry_date = '';
			}
			if ($document[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}

			$data = array(

				'passport_id' => $document[0]->passport_id,
				'passport_up_num' => $data_new['passport_id_num'],

				'title' => $data_new['title'],

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $data_new['file'],

				'issue_date' => $data_new['issue_date'],

				'expiry_date' => $data_new['expiry_date'],
				'description' => $data_new['description'],
				'update_value' => 'yes',

				'Title' => $Title,

				'File' => $File,

				'Issue_date' => $issue_date,

				'Expiry_date' => $expiry_date,

				'description_new' => $description_new,

			);
		} else {
			$data = array(

				'passport_id' => $document[0]->passport_id,

				'passport_up_num' => $document[0]->passport_id_num,

				'title' => $document[0]->title,

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $document[0]->file,

				'issue_date' => $document[0]->issue_date,

				'expiry_date' => $document[0]->expiry_date,
				'description' => $document[0]->description,
				'update_value' => 'no',

			);
		}

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_cprdocument_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_cprdocument_information($id);
		$update_value = $document[0]->update_value;
		if ($update_value) {
			$data_new = (unserialize($update_value));
			//  var_dump($data_new);
			$printed_cpr = '';
			if ($document[0]->cpr_num != $data_new['cpr_num']) {
				$printed_cpr = $printed_cpr . "<span>CPR Number : " . $data_new['cpr_num'] . "</span></br>";
				$printed_cpr_num_up =  $data_new['cpr_num'];
			} else {
				$printed_cpr_num_up =  $document[0]->cpr_num;
			}


			if ($document[0]->title != $data_new['title']) {
				$printed_cpr = $printed_cpr . "<span>Title : " . $data_new['title'] . "</span></br>";
				$printed_title_up =  $data_new['title'];
			} else {
				$printed_title_up =  $document[0]->title;
			}

			if ($document[0]->file != $data_new['file']) {
				$printed_cpr = $printed_cpr . "<span>File : " . $data_new['file'] . "</span></br>";
				$printed_file_up =  $data_new['file'];
			} else {
				$printed_file_up =  $document[0]->file;
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$printed_cpr = $printed_cpr . "<span>Issue date : " . $data_new['issue_date'] . "</span></br>";
				$printed_issue_date_up =  $data_new['issue_date'];
			} else {
				$printed_issue_date_up =  $document[0]->issue_date;
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$printed_cpr = $printed_cpr . "<span>Expiry date : " . $data_new['expiry_date'] . "</span></br>";
				$printed_expiry_date_up =  $data_new['expiry_date'];
			} else {
				$printed_expiry_date_up =  $document[0]->expiry_date;
			}

			if ($document[0]->description != $data_new['description']) {
				$printed_cpr = $printed_cpr . "<span>Description : " . $data_new['description'] . "</span></br>";
				$printed_description_up =  $data_new['description'];
			} else {
				$printed_description_up =  $document[0]->description;
			}

			if ($printed_cpr != '') {
				$printed_cpr = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>' . $printed_cpr;
			} else {
				$printed_cpr =  '';
			}

			$update_value = 'yes';
		} else {
			$printed_cpr = '';
			$update_value = 'no';
			$printed_cpr_num_up = $document[0]->cpr_num;
			$printed_title_up = $document[0]->title;
			$printed_file_up = $document[0]->file;
			$printed_issue_date_up = $document[0]->issue_date;
			$printed_expiry_date_up = $document[0]->expiry_date;
			$printed_description_up = $document[0]->description;
		}

		$data = array(
			'cpr_id' => $document[0]->cpr_id,
			'cpr_up_num' => $printed_cpr_num_up,
			'title' => $printed_title_up,
			'd_employee_id' => $document[0]->employee_id,
			'document_file' => $printed_file_up,
			'issue_date' => $printed_issue_date_up,
			'expiry_date' => $printed_expiry_date_up,
			'description' => $printed_description_up,
			'update_value' => $update_value,
			'printed_cpr' => $printed_cpr
		);
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_qualification_view()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('field_id');
		$result = $this->Employees_model->read_qualification_information($id);
		$printed = '';
		if ($result[0]->serialized != "" && $result[0]->serialized != 'null' && $result[0]->serialized != 'NULL' && $result[0]->serialized != NULL && $result[0]->serialized != null) {
			$printed = '<div style="color:black;font-weight: bold;"> New Updations Are  </br>';
			$ress = unserialize($result[0]->serialized);
			if ($result[0]->name != $ress['name']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_inst_name') . " : " . $ress['name'] . "</span></br>";
			}
			$result[0]->name = $ress['name'];
			if ($result[0]->education_level_id != $ress['education_level_id']) {
				$all_education_level = $this->Employees_model->all_education_level();
				$all_education = '';
				foreach ($all_education_level as $education_level) {
					if (isset($_GET)) {
						if (in_array($education_level->education_level_id, explode(",", $ress['education_level_id']))) {
							$all_education = $all_education . $education_level->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_edu_level') . " : " . $all_education . "</span></br>";
			}
			$result[0]->education_level_id = $ress['education_level_id'];
			if ($result[0]->from_year != $ress['from_year']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_from') . " : " . $ress['from_year'] . "</span></br>";
			}
			$result[0]->from_year = $ress['from_year'];
			if ($result[0]->to_year != $ress['to_year']) {
				$printed = $printed . "<span>" . $this->lang->line('dashboard_to') . " : " . $ress['to_year'] . "</span></br>";
			}
			$result[0]->to_year = $ress['to_year'];
			if ($result[0]->language_id != $ress['language_id']) {
				$all_qualification_language = $this->Employees_model->all_qualification_language();
				$all_education_lng = '';
				foreach ($all_qualification_language as $education_lng) {
					if (isset($_GET)) {
						if (in_array($education_lng->language_id, explode(",", $ress['language_id']))) {
							$all_education_lng = $all_education_lng . $education_lng->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_language') . " : " . $all_education_lng . "</span></br>";
			}
			$result[0]->language_id = $ress['language_id'];
			if ($result[0]->description != $ress['description']) {
				$printed = $printed . "<span>" . $this->lang->line('xin_description') . " : " . $ress['description'] . "</span></br>";
			}
			$result[0]->description = $ress['description'];
			if ($result[0]->skill_id != $ress['skill_id']) {
				$all_qualification_skill = $this->Employees_model->all_qualification_skill();
				$all_education_skill = '';
				foreach ($all_qualification_skill as $education_skill) {
					if (isset($_GET)) {
						if (in_array($education_skill->skill_id, explode(",", $ress['skill_id']))) {
							$all_education_skill = $all_education_skill . $education_skill->name;
						}
					}
				}
				$printed = $printed . "<span>" . $this->lang->line('xin_e_details_skill') . " : " . $all_education_skill . "</span></br>";
			}
			$result[0]->skill_id = $ress['skill_id'];
			$printed = $printed . '</div>';
		}
		$data = array(

			'qualification_id' => $result[0]->qualification_id,

			'employee_id' => $result[0]->employee_id,

			'name' => $result[0]->name,

			'education_level_id' => $result[0]->education_level_id,

			'from_year' => $result[0]->from_year,

			'language_id' => $result[0]->language_id,

			'to_year' => $result[0]->to_year,

			'skill_id' => $result[0]->skill_id,

			'description' => $result[0]->description,

			'all_education_level' => $this->Employees_model->all_education_level(),

			'all_qualification_language' => $this->Employees_model->all_qualification_language(),

			'all_qualification_skill' => $this->Employees_model->all_qualification_skill()

		);

		if (!empty($session)) {
			$data['printed'] = $printed;

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_work_experience_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_work_experience_information($id);

		$data = array(

			'work_experience_id' => $result[0]->work_experience_id,

			'employee_id' => $result[0]->employee_id,

			'company_name' => $result[0]->company_name,

			'from_date' => $result[0]->from_date,

			'to_date' => $result[0]->to_date,

			'post' => $result[0]->post,

			'description' => $result[0]->description

		);
		$local_store = $this->Employees_model->read_experience_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['company_name'] = $un_local['company_name'];
			$data['post'] = $un_local['post'];
			$data['from_date'] = $un_local['from_date'];
			$data['to_date'] = $un_local['to_date'];
			$data['description'] = $un_local['description'];
		}
		$data['changes_exp'] = $this->Employees_model->read_experience_changes_local($id);
		$data['local_w_store'] = $this->Employees_model->read_work_local_store($id);
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_bank_account_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_bank_account_information($id);

		$data = array(

			'bankaccount_id' => $result[0]->bankaccount_id,

			'employee_id' => $result[0]->employee_id,

			'is_primary' => $result[0]->is_primary,

			'account_title' => $result[0]->account_title,

			'account_number' => $result[0]->account_number,

			'bank_name' => $result[0]->bank_name,

			'bank_code' => $result[0]->bank_code,

			'bank_branch' => $result[0]->bank_branch

		);
		$local_store = $this->Employees_model->read_bank_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['account_title'] = $un_local['account_title'];
			$data['bank_name'] = $un_local['bank_name'];
			$data['account_number'] = $un_local['account_number'];
			$data['bank_code'] = $un_local['bank_code'];
			$data['bank_branch'] = $un_local['bank_branch'];
		}
		$data['contact_changes'] = $this->Employees_model->read_contact_changes_local($id);
		$data['local_bank_store'] = $this->Employees_model->read_bank_local_store($id);
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {
			redirect('admin/');
		}
	}
	public function dialog_security_level_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_security_level_information($id);

		$data = array(

			'security_level_id' => $result[0]->security_level_id,

			'employee_id' => $result[0]->employee_id,

			'security_type' => $result[0]->security_type,

			'date_of_clearance' => $result[0]->date_of_clearance,

			'expiry_date' => $result[0]->expiry_date
		);
		$local_store = $this->Employees_model->read_security_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['security_type'] = $un_local['security_type'];
			$data['date_of_clearance'] = $un_local['date_of_clearance'];
			$data['expiry_date'] = $un_local['expiry_date'];
		}
		$data['security_changes'] = $this->Employees_model->read_security_changes_local($id);
		$data['local_security_store'] = $this->Employees_model->read_local_security_store($id);
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_contract_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$efapproval = $role_resources_ids[9];
		$edit = $role_resources_ids[5];
		$result = $this->Employees_model->read_contract_information($id);
		$update_value = $result[0]->update_value;
		if (($update_value) && ($efapproval == 'efapproval') && ($edit == '202')) {
			$data_new = (unserialize($update_value));

			$idnew = $data_new['contract_type_id'];

			$resultnew = $this->Employees_model->all_contract_types_name($idnew);
			$contract_type_name = $resultnew[0]->name;


			if ($result[0]->contract_type_id != $data_new['contract_type_id']) {

				$contract_type_id_new = 'Contract type : ' . $contract_type_name;
			} else {
				$contract_type_id_new = '';
			}

			if ($result[0]->from_date != $data_new['from_date']) {
				$from_date_new = 'From date : ' . $data_new['from_date'];
			} else {
				$from_date_new = '';
			}

			if ($result[0]->designation_id != $data_new['designation_id']) {

				$Designation_new = 'Designation :' . $data_new['designation_id'];
			} else {
				$Designation_new = '';
			}

			if ($result[0]->title != $data_new['title']) {
				$Title_new = 'Title :' . $data_new['title'];
			} else {
				$Title_new = '';
			}

			if ($result[0]->to_date != $data_new['to_date']) {
				$to_date_new = 'Todate :' . $data_new['to_date'];
			} else {
				$to_date_new = '';
			}
			if ($result[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}

			$data = array(

				'contract_id' => $result[0]->contract_id,

				'employee_id' =>  $result[0]->employee_id,



				'contract_type_id' => $data_new['contract_type_id'],

				'from_date' => $data_new['from_date'],

				'designation_id' => $data_new['designation_id'],

				'title' => $data_new['title'],

				'to_date' => $data_new['to_date'],

				'description' => $data_new['description'],

				'update_value' => 'yes',



				'contract_type_id_new' => $contract_type_id_new,

				'from_date_new' => $from_date_new,

				'Designation_new' => $Designation_new,

				'Title_new' => $Title_new,

				'to_date_new' => $to_date_new,

				'description_new' => $description_new,


				'all_contract_types' => $this->Employees_model->all_contract_types(),

				'all_designations' => $this->Designation_model->all_designations(),

			);
		} else {

			$data = array(

				'contract_id' => $result[0]->contract_id,

				'employee_id' => $result[0]->employee_id,

				'contract_type_id' => $result[0]->contract_type_id,

				'from_date' => $result[0]->from_date,

				'designation_id' => $result[0]->designation_id,

				'title' => $result[0]->title,

				'to_date' => $result[0]->to_date,

				'description' => $result[0]->description,

				'file_new' => $result[0]->file,

				'update_value' => 'nill',

				'all_contract_types' => $this->Employees_model->all_contract_types(),

				'all_designations' => $this->Designation_model->all_designations(),

			);
		}
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_insurancedocument_view()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_insurancedocument_information($id);
		$update_value = $document[0]->update_value;
		if ($update_value) {
			$data_new = (unserialize($update_value));
			//print_r($data_new);
			if ($document[0]->list != $data_new['list']) {
				$list = 'List : ' . $data_new['list'];
			} else {
				$list = '';
			}

			if ($document[0]->company_name != $data_new['company_name']) {

				$company_name = 'Company Name :' . $data_new['company_name'];
			} else {
				$company_name = '';
			}

			if (($document[0]->file != $data_new['file']) and ($data_new['file'] != '')) {
				$file = 'File :' . $data_new['file'];
			} else {
				$file = '';
			}

			if ($document[0]->expiry_date != $data_new['expiry_date']) {
				$expiry_date = 'Expiry Date :' . $data_new['expiry_date'];
			} else {
				$expiry_date = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$issue_date = 'Issue_date :' . $data_new['issue_date'];
			} else {
				$issue_date = '';
			}

			if ($document[0]->description != $data_new['description']) {

				$description_new = 'Discription : ' . $data_new['description'];
			} else {
				$description_new = '';
			}
			$data = array(

				'insurance_id' => $document[0]->insurance_id,

				'list' => $data_new['list'],
				'company_name' => $data_new['company_name'],

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $data_new['file'],

				'issue_date' => $data_new['issue_date'],

				'expiry_date' => $data_new['expiry_date'],
				'description' => $data_new['description'],

				'update_value' => 'yes',

				'List' => $list,

				'Company_name' => $company_name,

				'Document_file' => $file,

				'Issue_date' => $issue_date,
				'Expiry_date' => $expiry_date,


				'description_new' => $description_new,
				'update_value' => 'yes',


			);
		} else {

			$data = array(

				'insurance_id' => $document[0]->insurance_id,

				'list' => $document[0]->list,
				'company_name' => $document[0]->company_name,

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $document[0]->file,

				'issue_date' => $document[0]->issue_date,

				'expiry_date' => $document[0]->expiry_date,
				'description' => $document[0]->description,
				'update_value' => 'no',

			);
		}
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_licensedocument_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_licensedocument_information($id);
		$update_value = $document[0]->update_value;
		if ($update_value) {
			$data_new = (unserialize($update_value));
			if ($document[0]->list != $data_new['list']) {
				$List = 'List : ' . $data_new['list'];
			} else {
				$List = '';
			}
			if ($document[0]->file != $data_new['file']) {

				$File = 'File :' . $data_new['file'];
			} else {
				$File = '';
			}
			if ($document[0]->renew_date != $data_new['renew_date']) {
				$Renew_date = 'Renew_date :' . $data_new['renew_date'];
			} else {
				$Renew_date = '';
			}

			if ($document[0]->issue_date != $data_new['issue_date']) {
				$Issue_date = 'Issue_date :' . $data_new['issue_date'];
			} else {
				$Issue_date = '';
			}
			if ($document[0]->expiry_date != $data_new['expiry_date']) {

				$Expiry_date = 'expiry_date : ' . $data_new['expiry_date'];
			} else {
				$Expiry_date = '';
			}
			$data = array(

				'license_id' => $document[0]->license_id,

				'list' => $data_new['list'],
				'renew_date' => $data_new['renew_date'],

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $data_new['file'],

				'issue_date' => $data_new['issue_date'],

				'expiry_date' => $data_new['expiry_date'],

				'update_value' => 'yes',

				'List' => $List,

				'File' => $File,

				'Renew_date' => $Renew_date,

				'Expiry_date' => $Expiry_date,

				'Issue_date' => $Issue_date,
			);
		} else {
			$data = array(

				'license_id' => $document[0]->license_id,

				'list' => $document[0]->list,
				'renew_date' => $document[0]->renew_date,

				'd_employee_id' => $document[0]->employee_id,

				'document_file' => $document[0]->file,

				'issue_date' => $document[0]->issue_date,

				'expiry_date' => $document[0]->expiry_date,
				'update_value' => 'no',


				'List' => '',

				'File' => '',

				'Renew_date' => '',

				'Expiry_date' => '',

				'Issue_date' => '',
			);
		}

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_vehicledocument_view()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {

			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$document = $this->Employees_model->read_vehicledocument_information($id);

		$data = array(

			'vehicle_id' => $document[0]->id,

			'type' => $document[0]->type,
			'all_vehicle' => $this->Xin_model->get_all_vehicle(),

			'd_employee_id' => $document[0]->employee_id,

			'number' => $document[0]->number,

			'date' => $document[0]->date,
		);
		$local_store = $this->Employees_model->read_vehicle_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['type'] = $un_local['type'];
			$data['number'] = $un_local['number'];
			$data['date'] = $un_local['date'];
		}
		$data['vehicle_changes'] = $this->Employees_model->read_vehicle_changes_local($id);
		$data['local_vehicle_store'] = $this->Employees_model->read_local_vehicle_store($id);
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_leave_view()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Timesheet_model->get($id);

		$data = array(

			'leave_id' => $result[0]->id,

			'employee_id' => $result[0]->employee_id,

			'type_name' => $result[0]->type_name,

			'leave_count' => $result[0]->leave_count,
			'leave_type_id' => $result[0]->leave_type,

		);
		$local_store = $this->Employees_model->read_leave_local($id);
		if ($local_store['local_store'] != '' && $local_store['local_store'] != 'NULL' && $local_store['local_store'] != NULL) {
			$un_local = unserialize($local_store['local_store']);
			$data['leave_count'] = $un_local['leave_count'];
		}
		$data['leave_changes'] = $this->Employees_model->read_leave_changes_local($id);
		$data['local_leave_store'] = $this->Employees_model->read_local_leave_store($id);
		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_emp_overtime_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_salary_overtime_record($id);

		$data = array(

			'salary_overtime_id' => $result[0]->salary_overtime_id,

			'employee_id' => $result[0]->employee_id,

			'overtime_type' => $result[0]->overtime_type,

			'no_of_days' => $result[0]->no_of_days,

			'overtime_hours' => $result[0]->overtime_hours,

			'overtime_rate' => $result[0]->overtime_rate

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_salary_allowance_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		/*$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_allowance($id);

		$data = array(

				'allowance_id' => $result[0]->allowance_id,

				'employee_id' => $result[0]->employee_id,

				'is_allowance_taxable' => $result[0]->is_allowance_taxable,

				'amount_option' => $result[0]->amount_option,

				'allowance_title' => $result[0]->allowance_title,

				'allowance_amount' => $result[0]->allowance_amount

				);

				*/

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_emp_indeminty_view()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_salary_commissions_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_commissions($id);

		$data = array(

			'salary_commissions_id' => $result[0]->salary_commissions_id,

			'employee_id' => $result[0]->employee_id,

			'is_commission_taxable' => $result[0]->is_commission_taxable,

			'amount_option' => $result[0]->amount_option,

			'commission_title' => $result[0]->commission_title,

			'commission_amount' => $result[0]->commission_amount,

			'allowance_payslip_commission' => $result[0]->applicable_for_paysalary

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function dialog_salary_statutory_deductions_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_statutory_deduction($id);

		//$emp=$this->Employees_model->read_emp($id);

		$emp = $this->Employees_model->read_emp($result[0]->employee_id);

		$data = array(

			'statutory_deductions_id' => $result[0]->statutory_deductions_id,

			'employee_id' => $result[0]->employee_id,

			'deduction_title' => $result[0]->deduction_title,

			'deduction_amount' => $result[0]->deduction_amount,

			'statutory_options' => $result[0]->statutory_options,

			'basic_salary' => $emp[0]->basic_salary,

			'wages_type' => $emp[0]->wages_type,

			'nationality_id' => $emp[0]->nationality_id,

			'allowance_payslip_deduction' => $result[0]->applicable_for_paysalary
		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}









	public function dialog_salary_other_payments_view()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_salary_other_payment($id);

		$data = array(

			'other_payments_id' => $result[0]->other_payments_id,

			'employee_id' => $result[0]->employee_id,

			'payments_title' => $result[0]->payments_title,

			'payments_amount' => $result[0]->payments_amount,

			'is_otherpayment_taxable' => $result[0]->is_otherpayment_taxable,

			'amount_option' => $result[0]->amount_option,

			'allowance_payslip_deduction' => $result[0]->applicable_for_paysalary

		);

		if (!empty($session)) {

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
	public function immigration_view()
	{



		//set data
		$data['title'] = $this->Xin_model->site_title();



		$session = $this->session->userdata('username');



		if (!empty($session)) {



			$this->load->view("admin/employees/employee_detail_view", $data);
		} else {



			redirect('admin/');
		}
		// Datatables Variables



		$draw = intval($this->input->get("draw"));



		$start = intval($this->input->get("start"));



		$length = intval($this->input->get("length"));



		$id = $this->uri->segment(4);
		$immigration = $this->Employees_model->set_employee_immigration($id);



		$data = array();
		foreach ($immigration->result() as $r) {





			$issue_date = $this->Xin_model->set_date_format($r->issue_date);



			$expiry_date = $this->Xin_model->set_date_format($r->expiry_date);



			$eligible_review_date = $this->Xin_model->set_date_format($r->eligible_review_date);



			$d_type = $this->Employees_model->read_document_type_information($r->document_type_id);



			if (!is_null($d_type)) {



				$document_d = $d_type[0]->document_type . '<br>' . $r->document_number;
			} else {



				$document_d = $r->document_number;
			}



			$country = $this->Xin_model->read_country_info($r->country_id);



			if (!is_null($country)) {



				$c_name = $country[0]->country_name;
			} else {



				$c_name = '--';
			}
			if ($r->serialized != '' && $r->serialized != 'null' && $r->serialized != 'NULL' && $r->serialized != NULL && $r->serialized != null) {
				$color = 'style="color:red"';
				$style = "red";
			} else {
				$color = 'style="color:green"';
				$style = "";
			}





			$data[] = array(




				$document_d,



				$issue_date,



				$expiry_date,



				$c_name,



				$eligible_review_date,

				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $r->immigration_id . '" data-field_type="imgdocument_view"><i class="fa fa-eye"></i></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->immigration_id . '" data-token_type="imgdocument"><i class="fas fa-trash-restore"></i></button></span>',




				$style



			);
		}
		$output = array(



			"draw" => $draw,



			"recordsTotal" => $immigration->num_rows(),



			"recordsFiltered" => $immigration->num_rows(),



			"data" => $data



		);



		echo json_encode($output);



		exit();
	}
	public function dialog_salary_loan_view()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_loan_deductions($id);
		// 		var_dump($this->input->get());die();

		$data = array(

			'loan_deduction_id' => $result[0]->loan_deduction_id,

			'employee_id' => $result[0]->employee_id,

			'loan_deduction_title' => $result[0]->loan_deduction_title,

			'start_date' => $result[0]->start_date,

			'end_date' => $result[0]->end_date,

			'loan_options' => $result[0]->loan_options,

			'monthly_installment' => $result[0]->monthly_installment,

			'reason' => $result[0]->reason,

			'created_at' => $result[0]->created_at,

			'first_approval' => $result[0]->first_approval,

			'second_approval' => $result[0]->second_approval,

			'third_approval' => $result[0]->third_approval,

			'final_approval' => $result[0]->final_approval

		);
		$data['role_resources_ids'] = $this->Xin_model->user_role_resource();

		if (!empty($session)) {
			// 		var_dump($data);die();

			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
}
