<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Employees_loan extends MY_Controller
{
	public function __construct()
	{
		parent::__construct();
		
		$this->load->model("Employees_model");
		$this->load->model("Xin_model");
	}
	
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	public function index()
	{
	    if ($this->input->get('id')) {
	        $id = $this->input->get('id');
	    } else {
	        $id = 0;
	    }
	    
		$session = $this->session->userdata('username');

		if (empty($session)) {
			redirect('admin/');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['title'] = 'Loan Details | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Loan Details';
		$data['loan_id'] = $id;

        if (in_array('395', $role_resources_ids) || $reports_to > 0) {
       

			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/employees_loan/index", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function list()
	{
	    // Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$session = $this->session->userdata('username');
		$user_info = $this->Employees_model->read_employee_information($session['user_id']);
		$role_resources_ids = $this->Xin_model->user_role_resource();
		
// 		if ($user_info[0]->user_role_id != 1)
// 		{
		    if (!in_array('9810', $role_resources_ids) && !in_array('9809', $role_resources_ids) && !in_array('9808', $role_resources_ids) && !in_array('9807', $role_resources_ids)){
		      //  var_dump($user_info[0]->user_id);
		      $this->db->where('employee_id', $user_info[0]->user_id);
		    }
// 		}
		
		if ($this->input->get('id') > 0) {
	        $this->db->where('loan_deduction_id', $this->input->get('id'));
	    }
		
		$loans = $this->db->get('xin_salary_loan_deductions');
		$data = array();
		$employees = $companies = array();
		
		foreach ($loans->result() as $loan)
		{
		    if (! array_key_exists($loan->employee_id, $employees))
		    {
		      //  var_dump($loan->employee_id);
		        $employee = $this->Employees_model->read_employee_information($loan->employee_id);
		        $employee_name = '';
		        
		        if ($employee)
		        {
		            if ($user_info[0]->user_role_id != 1)
		            {
		                if ($user_info[0]->company_id != $employee[0]->company_id)
		                {
		                    continue;
		                }
		            }
		            
		            $employee_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
		            
		            $this->db->where('company_id', $employee[0]->company_id);
		            $company = $this->db->get('xin_companies');
		            $company_name = '';
		            
		            if ($company->num_rows() == 1)
		            {
		                $company_name = $company->result()[0]->name;
		            }
		            
		            $companies[$loan->employee_id] = $company_name;
		        }
		        else
		        {
		            continue;
		        }
		        
		        $employees[$loan->employee_id] = $employee_name;
		    }
		    else
		    {
		        $employee_name = $employees[$loan->employee_id];
		    }
		    
		    $status = 'Pending';
		    
		    if ($loan->status == 1)
		      //  $status = 'Approved';
		      $status='<span class="small text-nowrap text-success"><i class="fas fa-check"></i> Approved</span>';
		    else if ($loan->status == 2)
		      //  $status = 'Rejected';
		        $status='<span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Rejected</span>';
		    
		    if ($loan->status == 0) {
    			if ($loan->first_approval == 1) {
    				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
    			} else if($loan->first_approval == 2){
    			    $status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First rejected</span>';
    			} else {
    				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
    			}
    			if ($loan->second_approval == 1) {
    				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
    			} else if($loan->second_approval == 2){
    			    $status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second rejected</span>';
    			} else {
    				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
    			}
    			if ($loan->third_approval == 1) {
    				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Third approval</span>';
    			} else if($loan->third_approval == 2){
    			    $status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third rejected</span>';
    			} else {
    				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third approval</span>';
    			}
    			if ($loan->final_approval == 1) {
    				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
    			} else if($loan->final_approval == 2){
    			    $status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final rejected</span>';
    			} else {
    				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
    			}
    	    }
		    
		  //  $buttons = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="" data-original-title="Update Status">
		  //  <button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-clame_id="'.$loan->loan_deduction_id.'"><span class="fas fa-pencil-alt"></span></button>
		  //  </span>';
		  if(in_array('9803', $role_resources_ids)){
		  $buttons='<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
		            <button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-field_id="' . $loan->loan_deduction_id . '" data-field_type="salary_loan" ><span class="fas fa-pencil-alt"></span>
		            </button></span>';
		            
		  }else{
		      $buttons='';
		  }
		    
		if(in_array('9803',$role_resources_ids)) {
          $data[] = array(
            
            $employee_name . '<br><small><i>'.$companies[$loan->employee_id].'</i></small>',
            $loan->loan_deduction_title,
            $loan->monthly_installment,
            $loan->loan_time . ' Months',
            $status,
            $buttons,
          );
        } else { 
          $data[] = array(
            $employee_name . '<br><small><i>'.$companies[$loan->employee_id].'</i></small>',
            $loan->loan_deduction_title,
            $loan->monthly_installment,
            $loan->loan_time . ' Months',
            $status,
          );  
        } 
        
		}
		
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $loans->num_rows(),
            "recordsFiltered" => $loans->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
	}
	
	public function read()
	{
	    $data['title'] = $this->Xin_model->site_title();
	    
	    $clame_id = $this->input->get('clame_id');
	    
	    $this->db->where('loan_deduction_id', $clame_id);
	    $loan = $this->db->get('xin_salary_loan_deductions')->row();
	    
	    $this->load->view('admin/employees_loan/dialog_loan', array(
	        'loan' => $loan,
	        'clame_id' => $clame_id,
	    ));
	}
	
	public function update($clame_id = 0)
	{
	    $Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		$session = $this->session->userdata('username');
		$user_info = $this->Employees_model->read_employee_information($session['user_id']);
		$role_resources_ids = $this->Xin_model->user_role_resource();
		
		$first_approval = $final_approval = $status = 0;
		
		if ($this->input->post('status') == 1)
		{
    		if ($user_info[0]->user_role_id == 1)
    		{
    		    $first_approval = $final_approval = $status = 1;
    		}
    		else if (in_array('516', $role_resources_ids))
    		{
    		    $first_approval = 1;
    		}
    		else if (in_array('517', $role_resources_ids))
    		{
    		    $first_approval = $final_approval = 1;
    		    $status = 1;
    		}
		}
		else
		{
		    $status = $this->input->post('status');
		}
	    
	    $this->db->where('loan_deduction_id', $clame_id);
	    $result = $this->db->update('xin_salary_loan_deductions', array(
	        'status' => $status,
	        'first_approval' => $first_approval,
	        'final_approval' => $final_approval,
	    ));
	    
	    if ($result == TRUE)
	    {
			$Return['result'] = 'Status updated';
		}
		else
		{
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		
		$this->output($Return);
		exit;
	}
}
