<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
defined('BASEPATH') or exit('No direct script access allowed');

class expenseclaim extends MY_Controller
{

	public function __construct()
	{
		parent::__construct();
		//load the model
		$this->load->model("Travel_model");
		$this->load->model("Xin_model");
		$this->load->model("Department_model");
		$this->load->model("Finance_model");
	}

	/*Function to set JSON output*/
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

	public function index()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_travel != 'true') {
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('left_expense_clame') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['travel_arrangement_types'] = $this->Travel_model->travel_arrangement_types();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_all_head'] = $this->Xin_model->get_all_head();
		$data['breadcrumbs'] = $this->lang->line('left_expense_clame');
		$data['path_url'] = 'expenseclame';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('367', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/expenseclame/expense_clame_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// get company > employees
	public function get_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/travel/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function expenseclame_list()
	{
		$exp_clame = '';
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/expenseclame/expense_clame_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('377', $role_resources_ids)) {
			$exp_clame = $this->Travel_model->get_expenseclame();
		} else {
			if (in_array('235', $role_resources_ids)) {
				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id);
			} else if (in_array('373', $role_resources_ids)) {

				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id, 'first');

			} else if (in_array('374', $role_resources_ids)) {

				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id, 'second');

			} else if (in_array('375', $role_resources_ids)) {

				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id, 'third');

			} else if (in_array('376', $role_resources_ids)) {

				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id, 'final');

			}

			if (empty($exp_clame)) {
				$exp_clame = $this->Travel_model->get_employee_expenseclameNew($session['user_id']);
			}
		}
		$data = array();
		$company_names = array();

		foreach ($exp_clame->result() as $r) {

			// get user > employee_
			$employee = $this->Xin_model->read_user_info($r->employee_id);
			// employee full name
			if (!is_null($employee)) {
				$employee_name = $employee[0]->first_name . ' ' . $employee[0]->middle_name . ' ' . $employee[0]->last_name;
			} else {
				$employee_name = '--';
			}
			// get start date
			$expense_date = $this->Xin_model->set_date_format($r->expense_date);
			// get end date
			$voucher_date = $this->Xin_model->set_date_format($r->voucher_date);
			// get company
			$amunt = $this->Xin_model->company_currency_sign($r->amount,$r->company_id);
			$expense_head = $this->Xin_model->read_head_info($r->expense_head);
			if (!is_null($expense_head)) {
				$expense_head = $expense_head[0]->name;
			} else {
				$expense_head = '--';
			}
			$expense_head = $expense_head;

			if (!isset($company_names[$r->company_id])) {
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}
				$company_names[$r->company_id] = $comp_name;
			} else {
				$comp_name = $company_names[$r->company_id];
			}
			// status
			if ($r->status == 1): $status = $this->lang->line('xin_pending');
// 		elseif($r->status==1): $status = $this->lang->line('xin_accepted'); else: $status = $this->lang->line('xin_rejected'); endif;
			elseif ($r->status == 2): $status = $status = '<span class="small text-nowrap text-success"><i class="fas fa-check"></i> Approved</span>';
			else: $status = '<span class="small text-nowrap text-danger"><i class="fas fa-check"></i> Rejected</span>'; endif;

			if ($r->status == 1) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} else if ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} else if ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->third_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Third approval</span>';
				} else if ($r->third_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} else if ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}

			if (in_array('379', $role_resources_ids) || in_array('370', $role_resources_ids)) { //edit
				// if ($r->status == 1 || $user_info[0]->user_role_id == 1) {
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-clame_id="' . $r->id . '"><span class="fas fa-pencil-alt"></span></button></span>';
				// } else {
				// 	$edit = '';
				// }
			} else {
				$edit = '';
			}
			
		
    		
			if (in_array('380', $role_resources_ids) || in_array('371', $role_resources_ids)) { // delete
				// if ($r->status == 1 || $user_info[0]->user_role_id == 1) {
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
				// } else {
				// 	$delete = '';
				// }
			} else {
				$delete = '';
			}
			if (in_array('381', $role_resources_ids) || in_array('372', $role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-clame_id="' . $r->id . '"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}
			$xin_document = '';
			if ($r->document && file_exists('uploads/expenseclame/'.$r->document)) {
				$xin_document = '<a href="' . base_url() . 'uploads/expenseclame/' . $r->document . '" target="_blank">click here </a>';
			}
			$combhr = $edit . $view . $delete;

			$iemployee_name = $employee_name;

		if(in_array('379',$role_resources_ids) || in_array('370',$role_resources_ids) || in_array('380',$role_resources_ids) || in_array('371',$role_resources_ids) || in_array('381',$role_resources_ids) || in_array('372',$role_resources_ids)) {
          $data[] = array(
            
            //'<strong>' . $iemployee_name . '</strong>' .
            //'<br><span class="small text-muted text-nowrap">' . $comp_name . '</span>',
            $employee_name,
            $expense_head,
            $status,
            $xin_document,
            $expense_date,
            /*$voucher_date,*/
            $amunt,
            ($r->paid == 1) ? 'Yes' : 'No',
            $combhr,
          );
        } else { 
          $data[] = array(
            //'<strong>' . $iemployee_name . '</strong>' .
            //'<br><span class="small text-muted text-nowrap">' . $comp_name . '</span>',
            $employee_name,
            $expense_head,
            $status,
            $xin_document,
            $expense_date,
            /*$voucher_date,*/
            $amunt,
            ($r->paid == 1) ? 'Yes' : 'No'
          );  
        }
        
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $exp_clame->num_rows(),
			"recordsFiltered" => $exp_clame->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function read()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('clame_id');

		$result = $this->Travel_model->read_expenseclame_information($id);
// 		print_r($result);
		$payment_date = '';
		if (!empty($result[0]->payment_date) && $result[0]->payment_date != '0000-00-00') {
			$payment_date = $result[0]->payment_date;
		}
		$data = array(
			'clame_id' => $result[0]->id,
			'company_id' => $result[0]->company_id,
			'employee_id' => $result[0]->employee_id,
			/*'voucher_date' => $result[0]->voucher_date,*/
			'payment_date' => $payment_date,
			'expense_date' => $result[0]->expense_date,
			'expense_head' => $result[0]->expense_head,
			'amount' => $result[0]->amount,
			'paycash' => $result[0]->paycash,
			'remarks' => $result[0]->remarks,
			'status' => $result[0]->status,
			'document' => $result[0]->document,
			'all_employees' => $this->Xin_model->all_employees(),
			'get_all_companies' => $this->Xin_model->get_companies(),
			'get_all_head' => $this->Xin_model->get_all_head(),
			'first_approval' => $result[0]->first_approval,
			'second_approval' => $result[0]->second_approval,
			'third_approval' => $result[0]->third_approval,
			'final_approval' => $result[0]->final_approval,
			'paid' => $result[0]->paid,
			'payment_method' => $result[0]->payment_method,
			'payment_method_month_year' => $result[0]->payment_method_month_year
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/expenseclame/dialog_expenseclame', $data);
		} else {
			redirect('admin/');
		}
	}

	// Validate and add info in database
	public function add_expenseclame()
	{
		error_reporting(0);
		if ($this->input->post('add_type') == 'expenseclame') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
			$paid = $this->input->post('paid');
    		if(empty($paid)){
    		    $paid = 0;
    		}

			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('expense_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_date');
			} /*else if($this->input->post('voucher_date')==='') {
				$Return['error'] = $this->lang->line('xin_error_voucher_date');
			}*/
			else if ($this->input->post('expense_head') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_head');
			} else if ($this->input->post('expense_amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_emount');
			} else if ($this->input->post('payment_method') === 'payroll') {
				if ($this->input->post('payment_method_month_year') === '') {
					$Return['error'] = $this->lang->line('xin_error_payment_method_month_year');
				}
			} else {
				// if (is_uploaded_file($_FILES['document_upload']['tmp_name'])) {
				// 	//checking image type
				// 	$allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'doc');
				// 	$filename = $_FILES['document_upload']['name'];
				// 	$ext = pathinfo($filename, PATHINFO_EXTENSION);

				// 	if (in_array($ext, $allowed)) {
				// 		$tmp_name = $_FILES["document_upload"]["tmp_name"];
				// 		$profile = "uploads/expenseclame/";
				// 		$set_img = base_url() . "uploads/expenseclame/";
				// 		// basename() may prevent filesystem traversal attacks;
				// 		// further validation/sanitation of the filename may be appropriate
				// 		$name = basename($_FILES["document_upload"]["name"]);
				// 		$newfilename = 'expenseclame_' . round(microtime(true)) . '.' . $ext;
				// 		move_uploaded_file($tmp_name, $profile . $newfilename);
				// 		$fname = $newfilename;
				// 	} else {
				// 		$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				// 	}
				// } else {
				// 	$fname = '';
				// }
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			/*if($this->input->post('expense_paycash')==''){
				$expense_paycash=0;
			}else{
				$expense_paycash=1;
			}
			*/

			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_employee_info($session['user_id']);

			$status_updated = 1;
			$first_approval = $second_approval = $final_approval = $third_approval = 0;
			if ($this->input->post('payment_method') != 'payroll') {
				$payment_date = $this->input->post('payment_date');
				$payment_method_month_year = null;
			} else {
				$payment_date = null;
				$payment_method_month_year = $this->input->post('payment_method_month_year');
				$employee_id = $this->input->post('employee_id');
		        $getemp_payroll_status = $this->Department_model->getemp_payroll_status($employee_id,$payment_method_month_year);
		        if($getemp_payroll_status > 0){
			    $Return['error'] = 'Employee Payment already done for this month.';
			    $this->output($Return);
		        }
			}

			$data = array(
				'employee_id' => $this->input->post('employee_id'),
				'company_id' => $this->input->post('company_id'),
				'expense_date' => $this->input->post('expense_date'),
				'payment_date' => $payment_date,
// 		'voucher_date' => $this->input->post('voucher_date'),
				'expense_head' => $this->input->post('expense_head'),
				'amount' => $this->input->post('expense_amount'),
				'remarks' => $this->input->post('expense_remarks'),
// 		'paycash' =>$expense_paycash,
				'document' => $this->input->post('attachment'),
				'added_by' => $this->input->post('user_id'),
				'created_at' => date('Y-m-d'),
				'status' => $status_updated,
				'first_approval' => $first_approval,
				'second_approval' => $second_approval,
				'third_approval' => $third_approval,
				'final_approval' => $final_approval,
				'paid' => $paid,
				'payment_method' => $this->input->post('payment_method'),
				'payment_method_month_year' => $payment_method_month_year
			);
			//print_r($data);exit;
			$result = $this->Travel_model->addExpenseClame($data);
			//	echo $result;exit;
			if ($result == TRUE) {
				$row = $this->db->select("*")->limit(1)->order_by('id', "DESC")->get("xin_expense_clame")->row();
				$Return['result'] = $this->lang->line('xin_success_expenseclame_added');
				$Return['re_last_id'] = $row->id;
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and update info in database
	public function update_validate()
	{
// 		print_r($_POST);exit;
		if ($this->input->post('edit_type') == 'expenseclame') {

			$id = $this->uri->segment(4);
// 		var_dump($this->input->post('final_approval'));die();
			$expense_claim_row = $this->db->get_where('xin_expense_clame', array('id' => $id))->row();
			// print_r($expense_claim_row);exit;
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			$expense_date = $this->input->post('expense_date');
			$payment_date = $this->input->post('payment_date');
// 		$voucher_date = $this->input->post('voucher_date');
			$expense_head = $this->input->post('expense_head');
			$expense_remarks = $this->input->post('expense_remarks');
			$expense_amount = $this->input->post('expense_amount');
// 		$expense_paycash = $this->input->post('expense_paycash');
			$expense_date = date('Y-m-d', strtotime($expense_date));
// 		$voucher_date = date('Y-m-d',strtotime($voucher_date));
			$payment_date = date('Y-m-d', strtotime($payment_date));
			$paid = $this->input->post('paid');

			/*if($this->input->post('expense_paycash')==''){
				$expense_paycash=0;
			}else{
				$expense_paycash=1;
			}*/
			if ($this->input->post('expense_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_date');
			} /*else if($this->input->post('voucher_date')==='') {
				$Return['error'] = $this->lang->line('xin_error_voucher_date');
			}*/
			else if ($this->input->post('expense_head') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_head');
			} else if ($this->input->post('expense_amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_emount');
			} else {
				if (is_uploaded_file($_FILES['document_upload']['tmp_name'])) {
					//checking image type
					$allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'doc');
					$filename = $_FILES['document_upload']['name'];
					$ext = pathinfo($filename, PATHINFO_EXTENSION);

					if (in_array($ext, $allowed)) {
						$tmp_name = $_FILES["document_upload"]["tmp_name"];
						$profile = "uploads/expenseclame/";
						$set_img = base_url() . "uploads/expenseclame/";
						// basename() may prevent filesystem traversal attacks;
						// further validation/sanitation of the filename may be appropriate
						$name = basename($_FILES["document_upload"]["name"]);
						$newfilename = 'expenseclame_' . round(microtime(true)) . '.' . $ext;
						move_uploaded_file($tmp_name, $profile . $newfilename);
						$fname = $newfilename;
						$Return['fileName'] = $newfilename;
					} else {
						$Return['error'] = $this->lang->line('xin_error_attatchment_type');
					}
				} else {
					$fname = $this->input->post('old_doc_name');
				}
			}
			$this->output($Return);
			exit;
		}

	}
	
	public function update()
	{
// 		print_r($_POST);exit;
		if ($this->input->post('edit_type') == 'expenseclame') {

			$id = $this->uri->segment(4);
// 		var_dump($this->input->post('final_approval'));die();
			$expense_claim_row = $this->db->get_where('xin_expense_clame', array('id' => $id))->row();
			// print_r($expense_claim_row);exit;
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			$expense_date = $this->input->post('expense_date');
			$payment_date = $this->input->post('payment_date');
// 		$voucher_date = $this->input->post('voucher_date');
			$expense_head = $this->input->post('expense_head');
			$expense_remarks = $this->input->post('expense_remarks');
			$expense_amount = $this->input->post('expense_amount');
// 		$expense_paycash = $this->input->post('expense_paycash');
			$expense_date = date('Y-m-d', strtotime($expense_date));
// 		$voucher_date = date('Y-m-d',strtotime($voucher_date));
			$payment_date = date('Y-m-d', strtotime($payment_date));
			$paid = $this->input->post('paid');

			/*if($this->input->post('expense_paycash')==''){
				$expense_paycash=0;
			}else{
				$expense_paycash=1;
			}*/
			if ($this->input->post('expense_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_date');
			} /*else if($this->input->post('voucher_date')==='') {
				$Return['error'] = $this->lang->line('xin_error_voucher_date');
			}*/
			else if ($this->input->post('expense_head') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_head');
			} else if ($this->input->post('expense_amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_emount');
			} else {
				if ($this->input->post('attachment') == '' || $this->input->post('attachment') == 'undefined') {
					//checking image type
				$fname = $this->input->post('old_doc_name');

					
				} else {
					$fname =$this->input->post('attachment');
				}
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $second_approval = $final_approval = $third_approval = $status = 0;
			$status_updated = $this->input->post('final_approval');
			if ($this->input->post('status') == null) {
				$first_approval = $expense_claim_row->first_approval;
				$second_approval = $expense_claim_row->second_approval;
				$third_approval = $expense_claim_row->third_approval;
				$final_approval = $expense_claim_row->final_approval;
				$status_updated = $expense_claim_row->status;

			} else {
				if ($user_info[0]->user_role_id == 1) {
					$status_updated = $this->input->post('status');
					//$status_updated = $this->input->post('final_approval');

					if ($status_updated == 2) {
						$first_approval = $second_approval = $final_approval = $third_approval = 1;
						$status = 2;
					} else if ($status_updated == 3) {
					    $status = 3;
					    $final_approval = 2;
					} else{
					    $status = 1;
					    $first_approval = $second_approval = $final_approval = $third_approval = 0;
					}
				} elseif (in_array('373', $role_resources_ids) || in_array('374', $role_resources_ids) || in_array('375', $role_resources_ids) || in_array('376', $role_resources_ids)) {

					if (in_array('373', $role_resources_ids)) {
						$status_updated = 1;//$this->input->post('status_old');
						if ($this->input->post('status') == 2) {
							// 			if ($this->input->post('status') == 2) {
							$first_approval = 1;
						} elseif ($this->input->post('status') == 3) {
					    	$first_approval = 2;
						}
					}
					if (in_array('374', $role_resources_ids)) { //second approval
						$status_updated = 1;//$this->input->post('status_old');
						if ($this->input->post('status') == 2 && $expense_claim_row->first_approval) {// second condition checks if first approval beforehand
							$second_approval = 1;
						} elseif ($this->input->post('status') == 3) {
					    	$second_approval = 2;
						}
					}
					if (in_array('375', $role_resources_ids)) { //third approval
						$status_updated = 1;//$this->input->post('status_old');
						if ($this->input->post('status') == 2 && $expense_claim_row->first_approval && $expense_claim_row->second_approval) {// third condition checks if first approval beforehand
							$third_approval = 1;
						} elseif ($this->input->post('status') == 3) {
					    	$third_approval = 2;
						}
					}
					if (in_array('376', $role_resources_ids)) {
						$status_updated = 1;//$this->input->post('status_old');
						if ($this->input->post('status') == 2) {
							$first_approval = $second_approval = $third_approval = $final_approval = 1;
							$status = 2;
							$status_updated = 2;
						} elseif ($this->input->post('status') == 3) {
						    $status = 3;
					    	$final_approval = 2;
						}
					}
				} else {
					$status_updated = $this->input->post('status_old');
				}
			}
			//payment_method based mont_year
			if ($this->input->post('payment_method') != 'payroll') {
				$payment_method_month_year = null;
			} else {
				$payment_method_month_year = $this->input->post('payment_method_month_year');
			}
			/*$first_approval = $this->input->post('first_approval');
			$second_approval = $this->input->post('second_approval');
			$third_approval = $this->input->post('third_approval');
			$final_approval = $this->input->post('final_approval');*/
			$rslt = $this->Travel_model->read_expence_claim($id);

			if ($first_approval == 'null' || $first_approval == 'NULL' || $first_approval == NULL || $first_approval == null) {
				$first_approval = $rslt[0]->first_approval;
			}
			if ($second_approval == 'null' || $second_approval == 'NULL' || $second_approval == NULL || $second_approval == null) {
				$second_approval = $rslt[0]->second_approval;
			}
			if ($third_approval == 'null' || $third_approval == 'NULL' || $third_approval == NULL || $third_approval == null) {
				$third_approval = $rslt[0]->third_approval;
			}
			if ($final_approval == 'null' || $final_approval == 'NULL' || $final_approval == NULL || $final_approval == null) {
				$final_approval = $rslt[0]->final_approval;
			}
			if ($rslt[0]->first_approval != $first_approval) {
				$first_approved_user = $session['user_id'];
			} else {
				$first_approved_user = $rslt[0]->first_approved_user;
			}
			if ($rslt[0]->second_approval != $second_approval) {
				$second_approved_user = $session['user_id'];
			} else {
				$second_approved_user = $rslt[0]->second_approved_user;
			}
			if ($rslt[0]->third_approval != $third_approval) {
				$third_approved_user = $session['user_id'];
			} else {
				$third_approved_user = $rslt[0]->third_approved_user;
			}
			if ($rslt[0]->final_approval != $final_approval) {
				$final_approved_user = $session['user_id'];
			} else {
				$final_approved_user = $rslt[0]->final_approved_user;
			}
			$data = array(
				'employee_id' => $this->input->post('employee_id'),
				'company_id' => $this->input->post('company_id'),
				'expense_date' => $expense_date,
// 		'voucher_date' => $voucher_date,
				'payment_date' => $payment_date,
				'expense_head' => $expense_head,
				'amount' => $expense_amount,
				'remarks' => $expense_remarks,
// 		'paycash' =>$expense_paycash,
				'document' => $fname,
// 		'status'=>$status_updated,
// 		'first_approval' => $this->input->post('first_approval'),
// 		'second_approval' => $this->input->post('second_approval'),
// 		'third_approval' => $this->input->post('third_approval'),
// 		'final_approval' => $this->input->post('final_approval'),
				'first_approval' => $first_approval,
				'second_approval' => $second_approval,
				'third_approval' => $third_approval,
				'final_approval' => $final_approval,
				'status' => $status,
				'first_approved_user' => $first_approved_user,
				'second_approved_user' => $second_approved_user,
				'third_approved_user' => $third_approved_user,
				'final_approved_user' => $final_approved_user,
				'paid' => $paid,
				'payment_method' => $this->input->post('payment_method'),
				'payment_method_month_year' => $payment_method_month_year
			);
// 		print_r($data);exit;
			$result = $this->Travel_model->update_clame_record($data, $id);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_exp_clame_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}

	}

	public function delete()
	{
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$result = $this->Travel_model->delete_record($id);
		if (isset($id)) {
			$Return['result'] = $this->lang->line('xin_success_travel_deleted');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}

	public function delete_clame()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$result = $this->Travel_model->delete_clame_record($id);
		if (isset($id)) {
			$Return['result'] = $this->lang->line('xin_success_clame_deleted');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}
	////////////////////////////////////////////////////////////////////////////////////////////////
	public function add_expenseclame_validate()
	{
		error_reporting(0);
		if ($this->input->post('add_type') == 'expenseclame') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
			$paid = $this->input->post('paid');
    		if(empty($paid)){
    		    $paid = 0;
    		}

			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('expense_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_date');
			} /*else if($this->input->post('voucher_date')==='') {
				$Return['error'] = $this->lang->line('xin_error_voucher_date');
			}*/
			else if ($this->input->post('expense_head') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_head');
			} else if ($this->input->post('expense_amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_expense_emount');
			} else if ($this->input->post('payment_method') === 'payroll') {
				if ($this->input->post('payment_method_month_year') === '') {
					$Return['error'] = $this->lang->line('xin_error_payment_method_month_year');
				}
			} else {
				if (is_uploaded_file($_FILES['document_upload']['tmp_name'])) {
					//checking image type
					$allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif', 'doc');
					$filename = $_FILES['document_upload']['name'];
					$ext = pathinfo($filename, PATHINFO_EXTENSION);

					if (in_array($ext, $allowed)) {
						$tmp_name = $_FILES["document_upload"]["tmp_name"];
						$profile = "uploads/expenseclame/";
						$set_img = base_url() . "uploads/expenseclame/";
						// basename() may prevent filesystem traversal attacks;
						// further validation/sanitation of the filename may be appropriate
						$name = basename($_FILES["document_upload"]["name"]);
						$newfilename = 'expenseclame_' . round(microtime(true)) . '.' . $ext;
						move_uploaded_file($tmp_name, $profile . $newfilename);
						$fname = $newfilename;
						$Return['fileName'] = $fname;
					} else {
						$Return['error'] = $this->lang->line('xin_error_attatchment_type');
					}
				} else {
					$fname = '';
				}
			}
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_employee_info($session['user_id']);

			$status_updated = 1;
			$first_approval = $second_approval = $final_approval = $third_approval = 0;
			if ($this->input->post('payment_method') != 'payroll') {
				$payment_date = $this->input->post('payment_date');
				$payment_method_month_year = null;
			} else {
				$payment_date = null;
				$payment_method_month_year = $this->input->post('payment_method_month_year');
				$employee_id = $this->input->post('employee_id');
		        $getemp_payroll_status = $this->Department_model->getemp_payroll_status($employee_id,$payment_method_month_year);
		        if($getemp_payroll_status > 0){
			    $Return['error'] = 'Employee Payment already done for this month.';
			    $this->output($Return);
		        }
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}
	public function get_expense_clame_pdf() {
	   	$data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $user_id = $user[0]->user_id;
        
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id==1 || in_array('368',$role_resources_ids)){
			$exp_clame = $this->Travel_model->get_expenseclame();
		} else {
			if(in_array('184',$role_resources_ids)) {
				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id);
			}  else if (in_array('373', $role_resources_ids)) {
				
				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id, 'first');

			} else if (in_array('376', $role_resources_ids)) {
				
				$exp_clame = $this->Travel_model->get_company_expenseclameNew($user_info[0]->company_id, 'final');
				
			}
			
			if(empty($exp_clame)) {
				$exp_clame = $this->Travel_model->get_employee_expenseclameNew($session['user_id']);
			}
		}
		$data = array();
		$company_names = array();

        foreach($exp_clame->result() as $r) {
			 			  	
		// get user > employee_
		$employee = $this->Xin_model->read_user_info($r->employee_id);
		// employee full name
		if(!is_null($employee)){
			$employee_name = $employee[0]->first_name.' '.$employee[0]->middle_name.' '.$employee[0]->last_name;
		} else {
			$employee_name = '--';	
		}
		// get start date
		$expense_date = $this->Xin_model->set_date_format($r->expense_date);
		// get end date
		$voucher_date = $this->Xin_model->set_date_format($r->voucher_date);
		// get company
		$amunt=$this->Xin_model->company_currency_sign($r->amount, $r->company_id);
		$expense_head=$this->Xin_model->read_head_info($r->expense_head);
		if(!is_null($expense_head)){
			$expense_head = $expense_head[0]->name;
		} else {
			$expense_head = '--';	
		}
		$expense_head=$expense_head;
		
		if (! isset($company_names[$r->company_id])) {
		    $company = $this->Xin_model->read_company_info($r->company_id);
    		if(!is_null($company)){
    			$comp_name = $company[0]->name;
    		} else {
    			$comp_name = '--';	
    		}
    		$company_names[$r->company_id] = $comp_name;
		} else {
		    $comp_name = $company_names[$r->company_id];
		}
		// status
		if ($r->status == 1): $status = $this->lang->line('xin_pending');
// 		elseif($r->status==1): $status = $this->lang->line('xin_accepted'); else: $status = $this->lang->line('xin_rejected'); endif;
			elseif ($r->status == 2): $status = $status = '<span class="small text-nowrap text-success"><i class="fas fa-check"></i> Approved</span>';
			else: $status = '<span class="small text-nowrap text-danger"><i class="fas fa-check"></i> Rejected</span>'; endif;
			
			
		if ($r->status == 1) {
			if ($r->first_approval == 1) {
				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
			}else if ($r->first_approval == 2) {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-check"></i> Rejected</span>';
			} else {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
			}
			if ($r->second_approval == 1) {
				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
			}else if ($r->second_approval == 2) {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-check"></i> Rejected</span>';
			} else {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
			}
			if ($r->third_approval == 1) {
				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Third approval</span>';
			}else if ($r->third_approval == 2) {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-check"></i> Rejected</span>';
			} else {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third approval</span>';
			}
			if ($r->final_approval == 1) {
				$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
			}else if ($r->final_approval == 2) {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-check"></i> Rejected</span>';
			} else {
				$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
			}
		}
		
		

		if(in_array('370',$role_resources_ids) || in_array('379',$role_resources_ids)) { //edit
			if($r->status != 1){
			  $edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-clame_id="'. $r->id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			}else{
				$edit = '';
			}
		} else {
			$edit = '';
		}
		
		if(in_array('371',$role_resources_ids) || in_array('380',$role_resources_ids)) { // delete
			if($r->status != 1){
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
			}else{
				$delete = '';
			}
		} else {
			$delete = '';
		}
		if(in_array('372',$role_resources_ids) || in_array('381',$role_resources_ids)) { //view
			$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-clame_id="'. $r->id . '"><span class="fa fa-eye"></span></button></span>';
		} else {
			$view = '';
		}
		$xin_document = '';
		if($r->document && file_exists('uploads/expenseclame/'.$r->document)){
			$xin_document = '<a href="'.base_url().'uploads/expenseclame/'.$r->document.'" target="_blank">click here </a>';
		}
		$combhr = $edit.$view.$delete;
		
		$iemployee_name = $employee_name;
	
		$data[] = array(
		    'employee_name' => 	'<strong>'.$iemployee_name.'</strong>',
			'comp_name' => $comp_name,
			'expense_head' => $expense_head,
			'xin_document' => $xin_document,
			'expense_date' => $expense_date,
			'amount' => $amunt,
			'paid' => 	($r->paid == 1) ? 'Yes' : 'No',
			'status' => $status,
		);
		
      }
 	//--------------------------------------

    $this->load->library('M_pdf');
    $mpdf = $this->m_pdf->load([
    'mode' => 'utf-8',
    'format' => 'A4'
    ]);
    $res['lists'] = $data;
    $html = $this->load->view("admin/expenseclame/get_expense_clame_pdf_format", $res, true);
    $mpdf->WriteHTML($html);
    $mpdf->Output('Expenseclaim.pdf', 'D'); //
		
      

	}
}
