<?php
 /**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class expenseclame extends MY_Controller {
	
	 public function __construct() {
        parent::__construct();
		//load the model
		$this->load->model("Travel_model");
		$this->load->model("Xin_model");
		$this->load->model("Department_model");
		$this->load->model("Finance_model");
	}
	
	/*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	 public function index()
     {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_travel!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('left_expense_clame').' | '.$this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['travel_arrangement_types'] = $this->Travel_model->travel_arrangement_types();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_all_head']=$this->Xin_model->get_all_head();
		$data['breadcrumbs'] = $this->lang->line('left_expense_clame');
		$data['path_url'] = 'expenseclame';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('17',$role_resources_ids)) {
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/expenseclame/expense_clame_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
     }
        	 
	 // get company > employees
	 public function get_employees() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/travel/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 } 
 
    public function expenseclame_list()
     {

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/expenseclame/expense_clame_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id==1){
			$exp_clame = $this->Travel_model->get_expenseclame();
		} else {
			if(in_array('235',$role_resources_ids)) {
				$exp_clame = $this->Travel_model->get_company_expenseclame($user_info[0]->company_id);
			} else {
				$exp_clame = $this->Travel_model->get_employee_expenseclame($session['user_id']);
			}
		}
		$data = array();

        foreach($exp_clame->result() as $r) {
			 			  	
		// get user > employee_
		$employee = $this->Xin_model->read_user_info($r->employee_id);
		// employee full name
		if(!is_null($employee)){
			$employee_name = $employee[0]->first_name.' '.$employee[0]->last_name;
		} else {
			$employee_name = '--';	
		}
		// get start date
		$expense_date = $this->Xin_model->set_date_format($r->expense_date);
		// get end date
		$voucher_date = $this->Xin_model->set_date_format($r->voucher_date);
		// get company
		$amunt=$this->Xin_model->company_currency_sign($r->amount,$r->company_id);
		$expense_head=$this->Xin_model->read_head_info($r->expense_head);
		if(!is_null($expense_head)){
			$expense_head = $expense_head[0]->name;
		} else {
			$expense_head = '--';	
		}
		$expense_head=$expense_head;
		$company = $this->Xin_model->read_company_info($r->company_id);
		if(!is_null($company)){
			$comp_name = $company[0]->name;
		} else {
			$comp_name = '--';	
		}
		// status
		//if($r->status==0): $status = $this->lang->line('xin_pending');
		//elseif($r->status==1): $status = $this->lang->line('xin_accepted'); else: $status = $this->lang->line('xin_rejected'); endif;

		if(in_array('217',$role_resources_ids)) { //edit
			$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-clame_id="'. $r->id . '"><span class="fas fa-pencil-alt"></span></button></span>';
		} else {
			$edit = '';
		}
		if(in_array('218',$role_resources_ids)) { // delete
			$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
		} else {
			$delete = '';
		}
		if(in_array('235',$role_resources_ids)) { //view
			$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-clame_id="'. $r->id . '"><span class="fa fa-eye"></span></button></span>';
		} else {
			$view = '';
		}
	
		$combhr = $edit.$view.$delete;
		
		$iemployee_name = $employee_name;
		
		$data[] = array(
			$combhr,
			$iemployee_name,
			$comp_name,
			$expense_head,	
			$expense_date,
			$voucher_date,
			$amunt
		);
      }

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $exp_clame->num_rows(),
			 "recordsFiltered" => $exp_clame->num_rows(),
			 "data" => $data
		);
	  echo json_encode($output);
	  exit();
     }
	 
	 public function read()
	{
	    
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('clame_id');
	   
		$result = $this->Travel_model->read_expenseclame_information($id);
		$data = array(
				'clame_id' => $result[0]->id,
				'company_id' => $result[0]->company_id,
				'employee_id' => $result[0]->employee_id,
				'voucher_date' => $result[0]->voucher_date,
				'expense_date' => $result[0]->expense_date,
				'expense_head' => $result[0]->expense_head,
				'amount' => $result[0]->amount,
				'paycash' => $result[0]->paycash,
				'remarks' => $result[0]->remarks,
				'all_employees' => $this->Xin_model->all_employees(),
				'get_all_companies' => $this->Xin_model->get_companies(),
				'get_all_head'=>$this->Xin_model->get_all_head()
				);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view('admin/expenseclame/dialog_expenseclame', $data);
		} else {
			redirect('admin/');
		}
	}
	
	// Validate and add info in database
	public function add_expenseclame() {
	  
		if($this->input->post('add_type')=='expenseclame') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$description = $this->input->post('description');
		$st_date = strtotime($start_date);
		$ed_date = strtotime($end_date);
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);
		
		if($this->input->post('company_id')==='') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if($this->input->post('employee_id')==='') {
        	$Return['error'] = $this->lang->line('xin_error_employee_id');
		} else if($this->input->post('expense_date')==='') {
			$Return['error'] = $this->lang->line('xin_error_expense_date');
		} else if($this->input->post('voucher_date')==='') {
			$Return['error'] = $this->lang->line('xin_error_voucher_date');
		} else if($this->input->post('expense_head')==='') {
			$Return['error'] = $this->lang->line('xin_error_expense_head');
		} else if($this->input->post('expense_amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_expense_emount');
		}else{
		    if(is_uploaded_file($_FILES['document_upload']['tmp_name'])) {
				//checking image type
				$allowed =  array('png','jpg','jpeg','pdf','gif','doc');
				$filename = $_FILES['document_upload']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);
				
				if(in_array($ext,$allowed)){
					$tmp_name = $_FILES["document_upload"]["tmp_name"];
					$profile = "uploads/expenseclame/";
					$set_img = base_url()."uploads/expenseclame/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$name = basename($_FILES["document_upload"]["name"]);
					$newfilename = 'expenseclame_'.round(microtime(true)).'.'.$ext;
					move_uploaded_file($tmp_name, $profile.$newfilename);
					$fname = $newfilename;			
				} else {
					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				}
			} else {
				$fname = '';
			}
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	    if($this->input->post('expense_paycash')==''){
	        $expense_paycash=0;
	    }else{
	        $expense_paycash=1;
	    }
		$data = array(
		'employee_id' => $this->input->post('employee_id'),
		'company_id' => $this->input->post('company_id'),
		'expense_date' => $this->input->post('expense_date'),
		'voucher_date' => $this->input->post('voucher_date'),
		'expense_head' => $this->input->post('expense_head'),
		'amount' => $this->input->post('expense_amount'),
		'remarks' => $this->input->post('expense_remarks'),
		'paycash' =>$expense_paycash,
		'document'=>$fname,
		'added_by' => $this->input->post('user_id'),
		'created_at' => date('Y-m-d'),
		
		);
		//print_r($data);exit;
		$result = $this->Travel_model->addExpenseClame($data);
	//	echo $result;exit;
		if ($result == TRUE) {
			$row = $this->db->select("*")->limit(1)->order_by('id',"DESC")->get("xin_expense_clame")->row();
			$Return['result'] = $this->lang->line('xin_success_expenseclame_added');	
			$Return['re_last_id'] = $row->id;
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	// Validate and update info in database
	public function update() {
		
		if($this->input->post('edit_type')=='expenseclame') {
			
		$id = $this->uri->segment(4);
	
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */
		$expense_date = $this->input->post('expense_date');
		$voucher_date = $this->input->post('voucher_date');
		$expense_head = $this->input->post('expense_head');
		$expense_remarks = $this->input->post('expense_remarks');
		$expense_amount = $this->input->post('expense_amount');
		$expense_paycash = $this->input->post('expense_paycash');
		$expense_date = date('Y-m-d',strtotime($expense_date));
		$voucher_date = date('Y-m-d',strtotime($voucher_date));
	
		if($this->input->post('expense_paycash')==''){
	        $expense_paycash=0;
	    }else{
	        $expense_paycash=1;
	    }
       if($this->input->post('expense_date')==='') {
			$Return['error'] = $this->lang->line('xin_error_expense_date');
		} else if($this->input->post('voucher_date')==='') {
			$Return['error'] = $this->lang->line('xin_error_voucher_date');
		} else if($this->input->post('expense_head')==='') {
			$Return['error'] = $this->lang->line('xin_error_expense_head');
		} else if($this->input->post('expense_amount')==='') {
			$Return['error'] = $this->lang->line('xin_error_expense_emount');
		}
				
		if($Return['error']!=''){
       		$this->output($Return);
    	}
	
		$data = array(
		'expense_date' => $expense_date,
		'voucher_date' => $voucher_date,
		'expense_head' => $expense_head,
		'amount' => $expense_amount,
		'remarks' => $expense_remarks,
		'paycash' =>$expense_paycash
		);
		//print_r($data);exit;
		$result = $this->Travel_model->update_clame_record($data,$id);	
	
		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_success_exp_clame_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	
	public function delete() {
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$result = $this->Travel_model->delete_record($id);
		if(isset($id)) {
			$Return['result'] = $this->lang->line('xin_success_travel_deleted');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}
	public function delete_clame(){
	    	$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$result = $this->Travel_model->delete_clame_record($id);
		if(isset($id)) {
			$Return['result'] = $this->lang->line('xin_success_clame_deleted');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}
}
