<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Final_settlement extends MY_Controller
{

	public function __construct()
	{
		parent::__construct();
		//load the model
		$this->load->model("Employees_model");
		$this->load->model("Xin_model");
		$this->load->model("Designation_model");
		$this->load->model("Department_model");
		$this->load->model("Roles_model");
		$this->load->model("Location_model");
		$this->load->model("Company_model");
		$this->load->model("Timesheet_model");
		$this->load->model("Custom_fields_model");
		$this->load->model("Assets_model");
		$this->load->model("Training_model");
		$this->load->model("Trainers_model");
		$this->load->library("pagination");
		$this->load->model("Awards_model");
		$this->load->model("Travel_model");
		$this->load->model("Tickets_model");
		$this->load->model("Transfers_model");
		$this->load->model("Promotion_model");
		$this->load->model("Complaints_model");
		$this->load->model("Airticket_model");
		$this->load->model("Warning_model");
		$this->load->model("Project_model");
		$this->load->model("Events_model");
		$this->load->model("Meetings_model");
		$this->load->model("Payroll_model");
		$this->load->library('Pdf');
		$this->load->helper('string');
		$this->load->model("Overtime_request_model");
		$this->load->model("Resignation_model");
		$this->load->model("Loan");
		$this->load->model("Misc_model");
		$this->load->model("Office_shift_custom_model");
	}

	/*Function to set JSON output*/
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

	public function index()
	{
		$session = $this->session->userdata('username');
		// 		var_dump($session);
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Final Settlement" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Final Settlement';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'final_settlement';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		// reports to 
		//$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('355', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/final_settlement/final_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function final_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/final_settlement/final_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		// reports to 
		$reports_to = get_reports_team_data($session['user_id']);


		$page_count = 0;
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->final_settlement();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->get_company_employees_final($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->get_company_location_employees_final($this->input->get("company_id"), $this->input->get("location_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->get_company_location_department_employees_final($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") != 0) {
				$employee = $this->Employees_model->get_company_location_department_designation_employees_final($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"), $this->input->get("designation_id"));
			}
		} else {
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			if ($user_info[0]->user_role_id == 1) {
				$employee = $this->Employees_model->final_settlement();
			} else if ($reports_to > 0) {
				$employee = $this->Employees_model->get_employees_my_team($session['user_id']);
			} else {
				$employee = $this->Employees_model->get_employees_for_other($user_info[0]->company_id);
			}
		}
		$page_count = 0;
		$data = array();
		if ($employee->result()) {
			foreach ($employee->result() as $r) {
				$resignation = $this->Resignation_model->get_employee_resignation_final($r->user_id);
				if ($resignation->result()) {
					$page_count++;
					// login date and time
					if ($r->last_login_date == '') {
						$edate = '-';
						$etime = '-';
					} else {
						$edate = $this->Xin_model->set_date_format($r->last_login_date);
						$last_login =  new DateTime($r->last_login_date);
						$etime = $last_login->format('h:i a');
					}
					// employee link
					$role_resources_ids = $this->Xin_model->user_role_resource();
					if (in_array('202', $role_resources_ids)) {
						$emp_link = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '" data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '">' . $r->employee_id . '</a>';
					} else {
						$emp_link = $r->employee_id;
					}
					// user full name
					$full_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
					// user role
					$role = $this->Xin_model->read_user_role_info($r->user_role_id);
					if (!is_null($role)) {
						$role_name = $role[0]->role_name;
					} else {
						$role_name = '--';
					}
					// get company
					$company = $this->Xin_model->read_company_info($r->company_id);
					if (!is_null($company)) {
						$comp_name = $company[0]->name;
					} else {
						$comp_name = '--';
					}
					/* get status*/
					if ($r->is_active == 0) : $status = '<span class="badge bg-red">' . $this->lang->line('xin_employees_inactive') . '</span>';
					elseif ($r->is_active == 1) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_employees_active') . '</span>';
					endif;
					// get designation
					$designation = $this->Designation_model->read_designation_information($r->designation_id);
					if (!is_null($designation)) {
						$designation_name = $designation[0]->designation_name;
					} else {
						$designation_name = '--';
					}
					// department
					$department = $this->Department_model->read_department_information($r->department_id);
					if (!is_null($department)) {
						$department_name = $department[0]->department_name;
					} else {
						$department_name = '--';
					}
					$department_designation = $designation_name . ' (' . $department_name . ')';
					$employee_name = $full_name . '<br><small class="text-muted"><i>' . $department_designation . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('xin_employees_id') . ': ' . $emp_link . '<i></i></i></small>';
					$doc = $this->Employees_model->doc($r->user_id);
					if ($doc != '') {
						$download_file = '';
						$upload_file = '<a target="_blank" title="Add more document" href="' . site_url('admin/final_settlement/final_upload/') . $r->user_id . '"> <i class="fa fa-folder"></i></a>';
					} else {
						$download_file = '<a target="_blank" title="Final Settlement Form" href="' . site_url('admin/final_settlement/final_profile/') . $r->user_id . '"> <i class="fa fa-arrow-circle-down"></i></a>';
						$upload_file = '<a target="_blank" title="Upload Final Settlement Form" href="' . site_url('admin/final_settlement/final_upload/') . $r->user_id . '"> <i class="fa fa-arrow-circle-up"></i></a>';
					}
					if ($r->final_settlement_remark != '') {
						$print = '<a  title="Final Settlement Form" href="' . site_url('admin/final_settlement/print_final_profile/') . $r->user_id . '"> <i class="fa fa-print"></i></a>';
					} else {
						$print = '';
					}
					if ($r->final_settlement_status == 'Y') {
						$final_sttlmnt = '<a target="_blank" title="Final Settlement Form" href="' . site_url('admin/final_settlement/dwnld_final_settlement/') . $r->user_id . '"> <i class="fa fa-arrow-circle-down"></i></a>';
					} else {
						$final_sttlmnt = '';
					}
					
					if ($r->final_settlement_status == 'N') {
					    $view = '<a  title="View details" href="' . site_url('admin/final_settlement/view_details/') . $r->user_id . '"> <i class="fa fa-eye"></i></a>';
					} else {
					    $view = '';
					}
					$delete = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-xs btn-danger waves-effect waves-light delete-final" data-toggle="modal" data-target=".delete_modal-final" data-record-id="' . $r->user_id . '"><span class="fa fa-trash"></span></button></span>';
					$status_val = ($r->final_settlement_status == 'Y') ? 1 : 2;
					$status = '<input type="radio" value="Y"  name="status_allowance' . $r->user_id . '" id="status_allowance' . $r->user_id . '" ';
					if ($r->final_settlement_status == 'Y') {
						$status .= 'checked="checked"';
					}
					$status .= ' onClick="update_status(' . $r->user_id . ',' . $status_val . ')">
					Paid <br/>
					<input type="radio" value="N"
						name="status_allowance' . $r->user_id . '" id="status_allowance' . $r->user_id . '"';
					if ($r->final_settlement_status == 'N') {
						$status .= 'checked="checked"';
					}
					$status .= ' onClick="update_status(' . $r->user_id . ',' . $status_val . ')">Unpaid';
					// last login date and time
					$elast_login = $edate . ' ' . $etime;
					$data[] = array(
						$r->employee_id,
						$employee_name,
						$comp_name,
						$department_name,
						$download_file,
						$upload_file,
						// 			$print,
						$view,
						$delete,
						$status,
						$final_sttlmnt,

					);
				}
			}
		}
		
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $page_count,
			"recordsFiltered" => $page_count,
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}
	public function final_upload()
	{
		$id = $this->uri->segment(4);
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Document Uploads" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Document Uploads';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'final_settlement';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		// reports to 
		//$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('355', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/final_settlement/final_page_upload", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	public function delete_doc()
	{


		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$result = $this->Employees_model->delete_final_records_doc($id);
		if (isset($id)) {

			$Return['result'] = 'Deleted';

			/*<script>
				alert('Final settlement remarks deleted successfully');
				     document.location.href='/admin/final_settlement';
				</script>*/
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}
	public function final_page_upload_validate()
	{
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$id = $this->input->post('user_id');
		/* Check if file uploaded..*/
		if ($_FILES['p_file']['size'] == 0 && null == $this->input->post('remove_profile_picture')) {
			$Return['error'] = $this->lang->line('xin_employee_select_picture');
		} else {
			if (is_uploaded_file($_FILES['p_file']['tmp_name'])) {
				//checking image type
				$allowed =  array('png', 'jpg', 'jpeg', 'pdf', 'gif');
				$filename = $_FILES['p_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);

				if (in_array($ext, $allowed)) {
					$tmp_name = $_FILES["p_file"]["tmp_name"];
					$profile = "uploads/int_file/";
					$set_img = base_url() . "uploads/int_file/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$name = basename($_FILES["p_file"]["name"]);
					$newfilename = 'final_doc' . round(microtime(true)) . '.' . $ext;
					move_uploaded_file($tmp_name, $profile . $newfilename);
					$fname = $newfilename;
                    $Return['fileName'] = $newfilename;
					//UPDATE Employee info in DB
				
				} else {
					$Return['error'] = $this->lang->line('xin_employee_picture_type');
				}
			}
		}
		if ($Return['error'] != '') {
			$this->output($Return);
			exit;
		}
		$this->output($Return);
	}
	
	public function final_page_upload()
	{
		if ($this->input->post('add_type') == 'final_settlement') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$id = $this->input->post('user_id');

						//UPDATE Employee info in DB
						$data = array(
							'employee_id' => $this->input->post('int_id'),
							'final_doc' => $this->input->post('attachment'),
						);
						$result = $this->Employees_model->final_doc($data);

						$insertId = $this->db->insert_id();
						$val = $this->Employees_model->get_id($insertId);
						if ($insertId != '') {
							$Return['result'] = 'Document upload Success...'; //echo$id;exit;
						}
						$this->output($Return);
						exit;
					
			if ($Return['error'] != '') {
				$this->output($Return);
				exit;
			}
		}
		$this->output($Return);
	}

	public function final_profile()
	{
		$system = $this->Xin_model->read_setting_info(1);
		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$key = $this->uri->segment(4);
		$user = $this->Xin_model->read_user_info($key);
		if (is_null($user)) {
			redirect('admin/employees');
		}

		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($_des_name)) {
			$_designation_name = $_des_name[0]->designation_name;
		} else {
			$_designation_name = '';
		}
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$_department_name = $department[0]->department_name;
		} else {
			$_department_name = '';
		}
		$fname = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
		// company info
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
		}
		$location = $this->Location_model->read_location_information($user[0]->location_id);
		if (!is_null($location)) {
			$location_name = $location[0]->location_name;
		} else {
			$location_name = '--';
		}
		$user_role = $this->Roles_model->read_role_information($user[0]->user_role_id);
		if (!is_null($user_role)) {
			$iuser_role = $user_role[0]->role_name;
		} else {
			$iuser_role = '--';
		}
		// set default header data
		//$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode.', '.$country_name;
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
		//$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email ";

		$company_info = $this->lang->line('left_company') . ": $company_name | " . $this->lang->line('left_location') . ": $location_name \n";
		$designation_info = $this->lang->line('left_department') . ": $_department_name | " . $this->lang->line('left_designation') . ": $_designation_name \n";

		$header_string = "$company_info" . "$designation_info";
		// set document information
		$pdf->SetCreator('HRSALE');
		$pdf->SetAuthor('HRSALE');
		//$pdf->SetTitle('Workable-Zone - Payslip');
		//$pdf->SetSubject('TCPDF Tutorial');
		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
		if ($user[0]->profile_picture != '' && $user[0]->profile_picture != 'no file') {
			$ol = 'uploads/profile/' . $user[0]->profile_picture;
		} else {
			if ($user[0]->gender == 'Male') {
				$de_file = 'uploads/profile/default_male.jpg';
			} else {
				$de_file = 'uploads/profile/default_female.jpg';
			}
			$ol = $de_file;
		}

		$header_namae = 'Full and Final Settlement Form';
		$pdf->SetHeaderData('../../../' . $ol, 15, $header_namae);

		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

		// set header and footer fonts
		$pdf->setHeaderFont(array('helvetica', '', 11.5));
		$pdf->setFooterFont(array('helvetica', '', 9));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont('courier');

		// set margins
		$pdf->SetMargins(15, 27, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, 25);

		// set image scale factor
		$pdf->setImageScale(1.25);
		$pdf->SetAuthor('HRSALE');
		$pdf->SetTitle($company_name . ' - ' . 'Final Settlement');
		$pdf->SetSubject($this->lang->line('xin_download_profile_title'));
		$pdf->SetKeywords($this->lang->line('xin_download_profile_title'));
		// set font
		$pdf->SetFont('helvetica', 'B', 10);

		// set header and footer fonts
		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// ---------------------------------------------------------

		// set default font subsetting mode
		$pdf->setFontSubsetting(true);

		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 10, '', true);

		// Add a page
		// This method has several options, check the source code documentation for more information.
		$pdf->AddPage();
		/*$tbl = '<br>
		<table cellpadding="1" cellspacing="1" border="0">
			<tr>
				<td align="center"><h1>'.$fname.'</h1></td>
			</tr>
		</table>
		';
		$pdf->writeHTML($tbl, true, false, false, false, '');*/
		// -----------------------------------------------------------------------------
		$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);

		// set cell padding
		$pdf->setCellPaddings(1, 1, 1, 1);

		// set cell margins
		$pdf->setCellMargins(0, 0, 0, 0);

		// set color for background
		$pdf->SetFillColor(255, 255, 127);
		/////////////////////////////////////////////////////////////////////////////////
		if ($user[0]->marital_status == 'Single') {
			$mstatus = $this->lang->line('xin_status_single');
		} else if ($user[0]->marital_status == 'Married') {
			$mstatus = $this->lang->line('xin_status_married');
		} else if ($user[0]->marital_status == 'Widowed') {
			$mstatus = $this->lang->line('xin_status_widowed');
		} else if ($user[0]->marital_status == 'Divorced or Separated') {
			$mstatus = $this->lang->line('xin_status_divorced_separated');
		} else {
			$mstatus = $this->lang->line('xin_status_single');
		}
		if ($user[0]->is_active == '0') {
			$isactive = $this->lang->line('xin_employees_inactive');
		} else if ($user[0]->is_active == '1') {
			$isactive = $this->lang->line('xin_employees_active');
		} else {
			$isactive = $this->lang->line('xin_employees_inactive');
		}
		$tbl_2 = '
		
		<table cellpadding="2" cellspacing="0" border="1">
			<tr bgcolor="#e0e0e0" >
			<td colspan="6"><strong>' . $this->lang->line('xin_e_details_basic') . '</strong></td>
			</tr>
			<tr>
				<td>' . $this->lang->line('dashboard_username') . '</td>
				<td colspan="2">' . $user[0]->first_name . ' ' . $user[0]->middle_name . '.' . $user[0]->last_name . '</td>
				<td>' . $this->lang->line('dashboard_email') . '</td>
				<td colspan="2">' . $user[0]->email . '</td>
			</tr>
			<tr>
				<td>Company Details</td>
				<td colspan="2">' . $company_name . '</td>
				<td>Department</td>
				<td colspan="2">' . $_department_name . '</td>
				
			</tr>
			<tr>
			   <td>Designation</td>
				<td colspan="2">' . $_designation_name . '</td>
				<td>' . $this->lang->line('dashboard_employee_id') . '</td>
				<td colspan="2">' . $user[0]->employee_id . '</td>
			</tr>
			
			
			<tr>
				<td>' . $this->lang->line('xin_employee_doj') . '</td>
				<td colspan="2">' . $date_of_joining . '</td>
				<td>Resignation Date</td>
				<td colspan="2">' . $user[0]->resignation_date . '</td>
			</tr>
			
			<tr>
				
				<td>Notice Period</td>
				<td colspan="2">' . $user[0]->notice_period . '</td>
				<td>Date Of Leaving</td>
				<td colspan="2">' . $user[0]->date_of_leaving . '</td>
			</tr>
			
		</table>';
		$pdf->writeHTML($tbl_2, true, false, false, false, '');
		//salary
		if ($user[0]->wages_type == 1) {
			$salary_opt = $this->lang->line('xin_payroll_basic_salary');
		} else {
			$salary_opt = $this->lang->line('xin_employee_daily_wages');
		}
		$tbl_3 = '<p>It is the responsibility of the employee to ensure that this document is completed and submitted to the HR Department at least two days before the last date of employment.  Each of the sections has to be agreed and signed off by the concerned department head.  This document is to be attached to the financial settlement to enable the processing of the financial settlement.  </p>
		<table cellpadding="2" cellspacing="0" border="1">
			<tr bgcolor="#e0e0e0">
			<td colspan="5"><strong>1.	Line Manager </strong></td>
			</tr>
			<tr>
				<td colspan="4"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
				<td colspan="2">Job related handover completed  </td>
				<td colspan="1">Yes</td>
				<td colspan="1">No</td>
			</tr>
			<tr>
				<td colspan="2">Handover notes prepared  </td>
				<td colspan="1">Yes</td>
				<td colspan="1">No</td>
			</tr>
			<tr>
				<td >Email access  </td>
				<td >Disable  </td>
				<td >Delete    </td>
				<td >Forward</td>
			</tr>
			<tr>
			<td colspan="2">If email to be forwarded, staff to forward to. *</td>
			<td colspan="2"></td>
			</tr>
			</table>*Mail box will be disabled after 1 month as per IT policy<br>';
		$pdf->writeHTML($tbl_3, true, false, false, false, '');

		$tbl_4 = '
		<table cellpadding="2" cellspacing="0" border="1">
			<tr bgcolor="#e0e0e0">
			<td colspan="5"><strong>2. Information Systems</strong></td>
			</tr>
			<tr>
				<td colspan="4"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
				<td >Laptop returned </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
			</tr>
			<tr>
				<td >Mailbox duplicated  </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
			</tr>
			<tr>
				<td >Email access</td>
				<td >Disabled  </td>
				<td >Delete    </td>
				<td >Forward</td>
			</tr>
			<tr>
				<td >Change password for internet access</td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
			</tr>
			<tr bgcolor="#e0e0e0">
			<td colspan="5"><strong>3.	Finance & Accounts</strong></td>
			</tr>
			<tr>
				<td colspan="4"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
			    <td >Corporate Credit card returned </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
				
			</tr>
			<tr>
				<td >Credit card bills settled  </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
				
			</tr>
			<tr>
			    <td >Cash advances cleared</td>
				<td >Yes  </td>
				<td >Final settlement    </td>
				<td >NA</td>
			</tr>
			<tr>
			<td >Cancel Signatory Status  </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
				
			</tr>
			<tr>
				<td >Cancel retail outlet discount.  </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
				
			</tr>
			<tr bgcolor="#e0e0e0">
			<td colspan="5"></td>
			</tr>
			
			<br><br>
			<tr bgcolor="#e0e0e0">
			<td colspan="5"><strong>4.	Administration</strong></td>
			</tr>
			<tr>
				<td colspan="4"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
				<td >Mobile phone & SIM returned  </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
			</tr>
			<tr>
				<td >Roaming service on phone cancelled? </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
			</tr>
			<tr>
				<td >Vehicle returned? </td>
				<td >Disabled  </td>
				<td >Delete    </td>
				<td >Forward</td>
			</tr>
			<tr>
				<td >Accommodation evacuated & Assets returned?  </td>
				<td >Yes  </td>
				<td >No    </td>
				<td >NA</td>
			</tr>
			<tr bgcolor="#e0e0e0">
			<td colspan="5"><strong>5.	Human Resources</strong></td>
			</tr>
			<tr>
				<td colspan="4"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
				<td colspan="2">Leave Balance   </td>
				<td colspan="2">Yes  </td>
				
			</tr>
			<tr>
				<td colspan="2">colspan="4" </td>
				<td colspan="2">1 month  </td>
				
			</tr>
			<tr>
				<td colspan="2">Notice period waived   </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No    </td>
			</tr>
			<tr>
				<td colspan="2">Notice Period Served  </td>
				<td colspan="2"></td>
				
			</tr>
			<tr>
				<td colspan="2">Authority who has waived the notice period  </td>
				<td colspan="2"></td>
				
			</tr>
			</table>';
		$pdf->writeHTML($tbl_4, true, false, false, false, '');


		$tbl_5 = 'Visa / Insurance / Passport  <br><br>
		<table cellpadding="6" cellspacing="0" border="1">
			
			<tr>
				<td colspan="5"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
				<td colspan="2">Visa Status of employee** </td>
				<td colspan="1">Cancel  </td>
				<td colspan="1">Transfer  </td>
				<td colspan="1">To be kept on hold  </td>
			</tr>
			<tr>
				<td colspan="2">Visa Status of employee’s family </td>
				<td colspan="1">Cancel  </td>
				<td colspan="1">Transfer  </td>
				<td colspan="1">To be kept on hold  </td>
			</tr>
			<tr>
				<td colspan="2">If visa is on hold,  when will it be cancelled   </td>
				<td colspan="3">  </td>
				
			</tr>
			<tr>
				<td colspan="2">Visa cancelled on   </td>
				<td colspan="3">  </td>
				
			</tr>
			<tr>
				<td colspan="2">Passport returned to staff  </td>
				<td colspan="1">  Yes </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="2">Medical insurance ***  </td>
				<td colspan="1">Cancel  </td>
				<td colspan="1">Keep valid  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="2">Medical insurance card returned  </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="2">Medical  Insurance cancelled on	 	   </td>
				<td colspan="3">  </td>
				
			</tr>
			
			<tr>
				<td colspan="2">If medical insurance to be kept valid,  when will it be cancelled  </td>
				<td colspan="3"></td>
				
			</tr>
			<tr>
				<td colspan="2">Life Insurance    </td>
				<td colspan="1">Cancel   </td>
				<td colspan="1">Keep valid  </td>
				<td colspan="1">NA  </td>
			</tr>
			
			</table>
			<p>** If the visa not to be cancelled, a written request from the employee is required. 50% of the final settlement will be retained till the visa is cancelled.</p>
<p>*** If the medical insurance is not to be cancelled, a written request from the employee is required.</p>
 <br>
';
		$pdf->writeHTML($tbl_5, true, false, false, false, '');


		$tbl_5 = '
		<table cellpadding="7" cellspacing="0" border="1">
			<tr>
				<td colspan="6"></td>
				<td> Signed by / Date</td>
				
			</tr>
			<tr>
				<td colspan="3">Office access card returned </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="3">Phone bill cleared </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="3">Air fare to be paid </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="3">Repatriation quotes received  </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="3">Obtain forwarding address / phone no. </td>
				<td colspan="1">Yes  </td>
				<td colspan="1">No  </td>
				<td colspan="1">NA  </td>
			</tr>
			<tr>
				<td colspan="3">Remove from ‘payroll’ </td>
				<td colspan="2">Yes</td>
				<td colspan="1">No</td>
				
			</tr>
			<tr>
				<td colspan="3">Loans with bank </td>
				<td colspan="2">Yes</td>
				<td colspan="1">No</td>
				
			</tr>
			<tr>
				<td colspan="3">Final settlement to be sent to local bank </td>
				<td colspan="2">Yes</td>
				<td colspan="1">No</td>
				
			</tr>
			<tr>
				<td colspan="3">If final settlement to be sent to non local bank, details of Bank and Account No: </td>
				<td colspan="3">Yes</td>
			</tr>
			<tr>
				<td colspan="3">‘Exit Interview’  conducted </td>
				<td colspan="2">Yes</td>
				<td colspan="1">No</td>
				
			</tr>
			<tr>
				<td colspan="3">Resignation acceptance letter </td>
				<td colspan="2">Yes</td>
				<td colspan="1">No</td>
				
			</tr>
			<tr>
				<td colspan="3">Service certificate given </td>
				<td colspan="2">Yes</td>
				<td colspan="1">No</td>
				
			</tr>
			<tr>
				<td colspan="3">Others</td>
				<td colspan="3"></td>
			</tr>
			</table>';
		$pdf->writeHTML($tbl_5, true, false, false, false, '');

		$tbl_6 = '
		<table cellpadding="9" cellspacing="0" border="1">
			<tr >
			<td colspan="3">Employee Name</td>
			<td colspan="3">Employee Signature</td>
			<td colspan="3">Date</td>
			</tr>
			<tr >
			<td colspan="3"></td>
			<td colspan="3"></td>
			<td colspan="3"></td>
			</tr>
			</table>';
		$pdf->writeHTML($tbl_6, true, false, false, false, '');

		$fname = strtolower($fname);
		$pay_month = strtolower(date("F Y"));
		//Close and output PDF document
		ob_start();
		$pdf->Output('finalsettlement_' . $fname . '_' . $pay_month . '.pdf', 'I');
		ob_end_flush();
	}
	public function print_final_profile()
	{
		$system = $this->Xin_model->read_setting_info(1);
		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$key = $this->uri->segment(4);
		$user = $this->Xin_model->read_user_info($key);
		if (is_null($user)) {
			redirect('admin/final_settlement');
		}
		$eid = $user[0]->user_id;
		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($_des_name)) {
			$_designation_name = $_des_name[0]->designation_name;
		} else {
			$_designation_name = '';
		}
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$_department_name = $department[0]->department_name;
		} else {
			$_department_name = '';
		}
		$fname = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
		// company info
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$zipcode = $company[0]->zipcode;
			$logo = '<img alt="<?php echo $system[0]->application_name;?>" src="<?php echo base_url();?>uploads/logo/<?php echo $company[0]->logo;?>" class="brand-logo" style="width:32px;">';
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '--';
		}
		$month_year = $user[0]->date_of_leaving;
		$start_date_y_m = date('Y-m', strtotime($month_year));
		$pay_date = date('Y-m', strtotime($month_year));
		$result = $this->Payroll_model->read_employee_payslip_info_key($key, $start_date_y_m);
		if ($result != '') {
			$make_payment_id = $result[0]->payslip_id;
			$wages_type = $result[0]->wages_type;
			$payment_date = $result[0]->salary_month;
			$year_to_date = $result[0]->year_to_date;
			$basic_salary = $result[0]->basic_salary;
			$daily_wages = $result[0]->daily_wages;
			$total_allowances = $result[0]->total_allowances;
			$total_loan = $result[0]->total_loan;
			$total_overtime = $result[0]->total_overtime;
			$total_commissions = $result[0]->total_commissions;
			$total_statutory_deductions = $result[0]->total_statutory_deductions;
			$total_other_payments = $result[0]->total_other_payments;
			$net_salary = $result[0]->net_salary;
			$other_payment = $result[0]->other_payment;
			$payslip_key = $result[0]->payslip_key;
			$payslip_type = $result[0]->payslip_type;
			$hours_worked = $result[0]->hours_worked;
			$pay_comments = $result[0]->pay_comments;
			$is_payment = $result[0]->is_payment;
			$approval_status = $result[0]->status;
		} else {
			$make_payment_id = '';
			$wages_type = '';
			$payment_date = '';
			$year_to_date = '';
			$basic_salary = '';
			$daily_wages = '';
			$total_allowances = '';
			$total_loan = '';
			$total_overtime = '';
			$total_commissions = '';
			$total_statutory_deductions = '';
			$total_other_payments = '';
			$net_salary = '';
			$other_payment = '';
			$payslip_key = '';
			$payslip_type = '';
			$hours_worked = '';
			$pay_comments = '';
			$is_payment = '';
			$approval_status = '';
		}


		$location = $this->Location_model->read_location_information($user[0]->location_id);
		if (!is_null($location)) {
			$location_name = $location[0]->location_name;
		} else {
			$location_name = '--';
		}
		$user_role = $this->Roles_model->read_role_information($user[0]->user_role_id);
		if (!is_null($user_role)) {
			$iuser_role = $user_role[0]->role_name;
		} else {
			$iuser_role = '--';
		}
		// set default header data
		//$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode.', '.$country_name;
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
		//$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email ";

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$header_string = $email_phone_address;
		// set document information
		$pdf->SetCreator('HRSALE');
		$pdf->SetAuthor('HRSALE');
		//$pdf->SetTitle('Workable-Zone - Payslip');
		//$pdf->SetSubject('TCPDF Tutorial');
		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
		$pdf->SetHeaderData('../../../uploads/logo/' . $logo, 15, $company_name, $header_string);

		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

		// set header and footer fonts
		$pdf->setHeaderFont(array('helvetica', '', 11.5));
		$pdf->setFooterFont(array('helvetica', '', 9));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont('courier');

		// set margins
		$pdf->SetMargins(15, 27, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, 25);

		// set image scale factor
		$pdf->setImageScale(1.25);
		$pdf->SetAuthor('HRSALE');
		$pdf->SetTitle($company_name . ' - ' . 'Final Settlement');
		$pdf->SetSubject($this->lang->line('xin_download_profile_title'));
		$pdf->SetKeywords($this->lang->line('xin_download_profile_title'));
		// set font
		$pdf->SetFont('helvetica', 'B', 10);

		// set header and footer fonts
		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// ---------------------------------------------------------

		// set default font subsetting mode
		$pdf->setFontSubsetting(true);

		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 10, '', true);

		// Add a page
		// This method has several options, check the source code documentation for more information.
		$pdf->AddPage();
		/*$tbl = '<br>
		<table cellpadding="1" cellspacing="1" border="0">
			<tr>
				<td align="center"><h1>'.$fname.'</h1></td>
			</tr>
		</table>
		';
		$pdf->writeHTML($tbl, true, false, false, false, '');*/
		// -----------------------------------------------------------------------------
		$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);

		// set cell padding
		$pdf->setCellPaddings(1, 1, 1, 1);

		// set cell margins
		$pdf->setCellMargins(0, 0, 0, 0);

		// set color for background
		$pdf->SetFillColor(255, 255, 127);
		/////////////////////////////////////////////////////////////////////////////////
		if ($user[0]->marital_status == 'Single') {
			$mstatus = $this->lang->line('xin_status_single');
		} else if ($user[0]->marital_status == 'Married') {
			$mstatus = $this->lang->line('xin_status_married');
		} else if ($user[0]->marital_status == 'Widowed') {
			$mstatus = $this->lang->line('xin_status_widowed');
		} else if ($user[0]->marital_status == 'Divorced or Separated') {
			$mstatus = $this->lang->line('xin_status_divorced_separated');
		} else {
			$mstatus = $this->lang->line('xin_status_single');
		}
		if ($user[0]->is_active == '0') {
			$isactive = $this->lang->line('xin_employees_inactive');
		} else if ($user[0]->is_active == '1') {
			$isactive = $this->lang->line('xin_employees_active');
		} else {
			$isactive = $this->lang->line('xin_employees_inactive');
		}
		$allowances = $this->Employees_model->set_employee_allowances($eid);




		$tbl_2 = '
		<table cellpadding="2" cellspacing="0" border="0">
		<tr >
			<td colspan="6"><strong>Date of Joining :</strong>   ' . $user[0]->date_of_joining . '</td>
			<td colspan="6"><strong>Date of Leaving :</strong> ' . $user[0]->date_of_leaving . '</td>
			</tr>
		<br><br>
		</table>
		<br><br><br>
		<table cellpadding="2" cellspacing="0" border="1">
		
			<tr >
			<td colspan="6"><strong>Basic Details....</strong></td>
			</tr>
			<tr>
				<td>' . $this->lang->line('dashboard_username') . '</td>
				<td colspan="2">' . $user[0]->first_name . ' ' . $user[0]->middle_name . '.' . $user[0]->last_name . '</td>
				<td>Employee code</td>
				<td colspan="2">' . $user[0]->employee_id . '</td>
				<td>' . $this->lang->line('dashboard_email') . '</td>
				<td colspan="2">' . $user[0]->email . '</td>
			</tr>
			<tr>
				<td>Company Details</td>
				<td colspan="2">' . $company_name . '</td>
				<td>Department</td>
				<td colspan="2">' . $_department_name . '</td>
				
			</tr>
			<tr>
			   <td>Designation</td>
				<td colspan="2">' . $_designation_name . '</td>
				<td>' . $this->lang->line('dashboard_employee_id') . '</td>
				<td colspan="2">' . $user[0]->employee_id . '</td>
			</tr>
			
			
		</table>';
		$pdf->writeHTML($tbl_2, true, false, false, false, '');
		//salary
		if ($user[0]->wages_type == 1) {
			$salary_opt = $this->lang->line('xin_payroll_basic_salary');
		} else {
			$salary_opt = $this->lang->line('xin_employee_daily_wages');
		}
		$tbl_3 = '<table cellpadding="2" cellspacing="0" border="1">
			<tr >
			<td colspan="5"><strong>	Monthly Package </strong></td>
				<td colspan="3"><strong>Amount</strong></td>
			</tr>
			<tr>
			<td colspan="5">Basic Salary</td>
			<td colspan="3">' . $this->Xin_model->company_currency_sign($user[0]->basic_salary, $user[0]->company_id) . '</td>
			
			</tr>';
		$total_allowance = $sum = $total_commissions = $total_overtime = $total_loan = $total_other_payments = $total_sum = $total_allowance1 = $total = 0;
		foreach ($allowances->result() as $sl_allowances) {
			$allo = $this->Xin_model->read_single_allowance($sl_allowances->allowance_title);
			$tbl_3 .= '<tr>
					<td colspan="5">' . $allo[0]->name . '(Allowances)</td>
					<td colspan="3">' . $this->Xin_model->company_currency_sign($sl_allowances->allowance_amount, $user[0]->company_id) . '</td>	
					</tr>';
			$total_allowance += $sl_allowances->allowance_amount;
		}
		$commissions = $this->Employees_model->set_employee_commissions_payslip($make_payment_id, $eid, $pay_date); //print_r($commissions);
		if (!is_null($commissions)) :
			$commissions_amount = 0;
			foreach ($commissions->result() as $sl_commissions) {

				$pg_commissions_amount = $sl_commissions->commission_amount;
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$ecommissions_amount = $sl_commissions->commission_amount / 2;
					} else {
						$ecommissions_amount = $sl_commissions->commission_amount;
					}
				} else {
					$ecommissions_amount = $sl_commissions->commission_amount;
				}
				$commissions_amount += $ecommissions_amount;

				//$commissions_amount += $sl_commissions->commission_amount;
				$tbl_3 .= '<tr>
					<td colspan="5">' . $sl_commissions->name . '(Commission)</td>
					<td colspan="3">' . $this->Xin_model->company_currency_sign($ecommissions_amount, $user[0]->company_id) . '</td>	
					</tr>';

				$total += $ecommissions_amount;
			}
		endif;

		$sum = $total_allowance + $user[0]->basic_salary + $total;
		$tbl_3 .= '<tr><td colspan="5">Total</td>
				<td colspan="3">' . $this->Xin_model->company_currency_sign($sum, $user[0]->company_id) . '</td></tr></table>';

		$pdf->writeHTML($tbl_3, true, false, false, false, '');

		$tbl_4 = '
		<table cellpadding="2" cellspacing="0" border="1">
			<tr >
			<td colspan="5"><strong>Salary For   ' . $start_date_y_m . '</strong></td>
				<td colspan="3">Days</td>
				<td colspan="3">Amount</td>
			</tr>
			<tr>
				<td colspan="5">Basic Salary </td>
				<td colspan="3">30  </td>
				<td colspan="3">' . $this->Xin_model->company_currency_sign($user[0]->basic_salary, $user[0]->company_id) . '</td>
			</tr>';
		foreach ($allowances->result() as $sl_allowances) {
			$allo = $this->Xin_model->read_single_allowance($sl_allowances->allowance_title);
			$tbl_4 .= '<tr>
					<td colspan="5">' . $allo[0]->name . '(Allowances)</td>
					<td colspan="3">30  </td>
					<td colspan="3">' . $this->Xin_model->company_currency_sign($sl_allowances->allowance_amount, $user[0]->company_id) . '</td>	
					</tr>';
			$total_allowance1 += $sl_allowances->allowance_amount;
		}
		$count_commissions = $this->Employees_model->count_employee_commissions_payslip($make_payment_id);
		$commissions = $this->Employees_model->set_employee_commissions_payslip($make_payment_id, $eid, $pay_date);
		if ($count_commissions > 0) {
			$commissions_amount = 0;
			foreach ($commissions->result() as $sl_commissions) {
				$tbl_4 .= '<tr>
					<td colspan="5">' . $sl_commissions->name . '(Commission)</td>
					<td colspan="3">30  </td>
					<td colspan="3">' . $this->Xin_model->company_currency_sign($sl_commissions->commission_amount, $user[0]->company_id) . '</td>	
					</tr>';
				$total_commissions += $sl_commissions->commission_amount;
			}
		}
		$count_overtime = $this->Employees_model->count_employee_overtime_payslip($make_payment_id);
		$overtime = $this->Employees_model->set_employee_overtime_payslip($make_payment_id);
		if ($count_overtime > 0) {
			foreach ($overtime->result() as $r_overtime) {
				$overtime_total = $r_overtime->overtime_hours * $r_overtime->overtime_rate;
				$tbl_4 .= '<tr>
					<td colspan="5">' . $r_overtime->overtime_title . '(Overtime)</td>
					<td colspan="3">30  </td>
					<td colspan="3">' . $this->Xin_model->company_currency_sign($overtime_total, $user[0]->company_id) . '</td>	
					</tr>';
				$total_overtime += $overtime_total;
			}
		}
		$count_loan = $this->Employees_model->count_employee_deductions_payslip($make_payment_id);
		$loan = $this->Employees_model->set_employee_deductions_payslip($make_payment_id, $eid, $pay_date);
		//loan
		if ($count_loan > 0) {
			foreach ($loan->result() as $r_loan) {
				$tbl_4 .= '<tr>
					<td colspan="5">' . $r_loan->loan_title . '(Loan)</td>
					<td colspan="3">30</td>	
					<td colspan="3">' . $this->Xin_model->company_currency_sign($r_loan->loan_amount, $user[0]->company_id) . '</td>	
					</tr>';
				$total_loan += $r_loan->loan_amount;
			}
		}
		$count_other_payments = $this->Employees_model->count_employee_other_payments_payslip($make_payment_id);
		//	$other_payments = $this->Employees_model->set_employee_other_payments_payslip($make_payment_id);
		//other_payments
		// 			if($count_other_payments > 0) {
		// 				foreach($other_payments->result() as $sl_other_payments) {
		// 				$tbl_4 .= '<tr>
		// 					<td colspan="5">'.$sl_other_payments->payments_title.'(Other Payment)</td>
		// 						<td colspan="3">30</td>	
		// 					<td colspan="3">'.$this->Xin_model->company_currency_sign($sl_other_payments->payments_amount,$user[0]->company_id).'</td>	

		// 					</tr>';
		// 					$total_other_payments+=$sl_other_payments->payments_amount;
		// 				}
		// 			}
		$total_sum = $total_allowance1 + $total_commissions + $total_overtime - $total_loan + $user[0]->basic_salary;
		$tbl_4 .= '<tr>
					<td colspan="5">Gross Pay</td>
						<td colspan="3"> </td>	
					<td colspan="3">' . $this->Xin_model->company_currency_sign($total_sum, $user[0]->company_id) . '</td>	
							
					</tr>';
		$tbl_4 .= '</table>';
		$pdf->writeHTML($tbl_4, true, false, false, false, '');


		$tbl_5 = '
		<table cellpadding="8" cellspacing="0" border="1">
			<tr>
				<td colspan="6"> <strong>Deduction</strong></td>
			</tr>';
		$total_statutory_deductions = 0;
		$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions_payslip($make_payment_id);
		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_payslip($make_payment_id, $eid, $pay_date);
		$statutory_deductions_amount = 0;
		foreach ($statutory_deductions->result() as $sl_statutory_deductions) {

			if ($system[0]->statutory_fixed != 'yes') :
				$sta_salary = $basic_salary;
				$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
				$statutory_deductions_amount += $st_amount;
				$single_sd = $st_amount;
			else :
				$statutory_deductions_amount += $sl_statutory_deductions->deduction_amount;
				$single_sd = $sl_statutory_deductions->deduction_amount;
			endif;
			$tbl_5 .= '<tr>
					<td colspan="5">' . $sl_statutory_deductions->name . '</td>
				
					<td colspan="2">' . $this->Xin_model->company_currency_sign($sl_statutory_deductions->deduction_amount, $user[0]->company_id) . '</td>			
					</tr>';
		}
		// 			else{
		// 			    $tbl_5 .= '<tr>
		// 					<td colspan="6"></td>

		// 					<td colspan="2"></td>			
		// 					</tr>';

		// 			}	

		$totol_leave = 0;
		$month_year = $user[0]->date_of_leaving;
		$start_date_y = date('Y', strtotime($month_year));
		$start_date_y_m = date('Y-m', strtotime($month_year));
		$emp_leave = $this->Employees_model->emp_leave($user[0]->user_id, $start_date_y);
		$date = strtotime(date("Y-m-d"));
		if (!isset($month_year)) {
			$day = date('d', $date);
			$month = date('m', $date);
			$year = date('Y', $date);
			$month_year = date('Y-m');
		} else {
			$imonth_year = explode('-', $month_year);
			$day = date('d', $date);
			$month = date($imonth_year[1], $date);
			$year = date($imonth_year[0], $date);
			$month_year = $month_year;
		}
		//$daysInMonth = cal_days_in_month(0, $month, $year);
		if (!is_null($emp_leave)) {
			$emp_leave_in_year_count = 0;
			$month_year_end = date("Y-m-t", strtotime("$month_year-02"));
			$totol_deduction = 0;
			foreach ($emp_leave as $emp_leave) {
				$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user[0]->user_id, $start_date_y_m, $emp_leave->leave_type_id);
				$sql = "Select SUM(total_days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
                                    WHERE employee_id=? and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.created_at <= '" . date('Y-m-d H:i:s', strtotime($month_year_end)) . "'";
				$binds = array($emp_leave->employee_id);
				$query = $this->db->query($sql, $binds);
				$tmp = $query->result();
				// $leaves_in_year = $emp_leave->total_leaves;
				$leaves_in_year_org = $tmp[0]->total_days;
				$leaves_in_year = $leaves_in_year_org - $emp_leave_in_month;
				$basic = $user[0]->basic_salary;
				$per_day_salary = $basic;
				$no_paid_leave_amount = $half_paid_leave_amount = $half_num = $full_num = $totol = 0;
				$status = '';
				if ($emp_leave->leave_type_id == 2) {
					// Calculation for sick leave

					for ($i = 1; $i <= $emp_leave_in_month; $i++) {
						$leaves_in_year += 1;

						if ($leaves_in_year > 30) {
							// No paid leaves
							$no_paid_leave_amount += $per_day_salary;
							$status = "Full Paids";
							//  $full_num=$leaves_in_year-30;
						} else if ($leaves_in_year > 15 && $leaves_in_year <= 30) {
							// echo "$leaves_in_year <br>";
							// Half paid leaves
							$half_paid_leave_amount += ($per_day_salary / 2);
							$status = "Half Paid";
							// $half_num=$leaves_in_year-15;
						}
					}
					$totol_deduction +=  $half_paid_leave_amount + $no_paid_leave_amount;
				} else if ($emp_leave->leave_type_id == 1) {
					// Calculation for Cashual leave
					for ($i = 1; $i <= $emp_leave_in_month; $i++) {
						$leaves_in_year += 1;

						if ($leaves_in_year > 0) {
							// No paid leaves
							$no_paid_leave_amount += $per_day_salary;
							$half_paid_leave_amount += 0;
							$status = "Full Paid";
						} else {
							$status = "No Paid";
						}
					}
					$totol_deduction +=  $no_paid_leave_amount;
				}
			}
			$totol_leave +=  $totol_deduction;
		} else {
			$totol_leave = 0;
		}

		if (!is_null($emp_leave)) {
			$tbl_5 .= '<tr>
					<td colspan="5">Leave</td>
					<td colspan="2">' . $this->Xin_model->company_currency_sign($totol_leave, $user[0]->company_id) . '</td>	
					</tr>';
		}
		$sum_deduction = 0;
		$sum_deduction = $totol_leave + $total_statutory_deductions;
		$tbl_5 .= '<tr>
					<td colspan="5">Total Deduction</td>
					<td colspan="2">' . $this->Xin_model->company_currency_sign($sum_deduction, $user[0]->company_id) . '</td>	
					</tr>';
		$tbl_5 .= '</table>';
		$pdf->writeHTML($tbl_5, true, false, false, false, '');
		if ($sum_deduction > $total_sum) {
			$final_amount = $sum_deduction - $total_sum;
		} else {
			$final_amount = $total_sum - $sum_deduction;
		}

		$tbl_6 = '
		<table cellpadding="9" cellspacing="0" border="1">
			<tr >
			<td colspan="6">Net Payable</td>
			
			<td colspan="2">' . number_format($final_amount, 2) . '</td>
			</tr>

			</table>';
		$pdf->writeHTML($tbl_6, true, false, false, false, '');
		$tbl_7 = '
		<table cellpadding="13" cellspacing="0" border="1">
			<tr>
				<td colspan="4">Prepared By</td>
				<td colspan="5"> Reviewed By</td>
				<td colspan="4">Approved By</td>
			</tr>
			<tr>
				<td colspan="2"></td>
				<td colspan="2">  </td>
				<td colspan="1">  </td>
				<td colspan="1">  </td>
				<td colspan="1">  </td>
				<td colspan="1">  </td>
				<td colspan="1">  </td>
				<td colspan="2">  </td>
				<td colspan="2">  </td>
			</tr>
			<tr>
				<td colspan="3"> </td>
				<td colspan="3">  </td>
				<td colspan="3">  </td>
				<td colspan="4">  </td>
			</tr>
		
			</table>';
		$pdf->writeHTML($tbl_7, true, false, false, false, '');
		$fname = strtolower($fname);
		$pay_month = strtolower(date("F Y"));
		//Close and output PDF document
		ob_start();
		$pdf->Output('payslip_' . $fname . '_' . $pay_month . '.pdf', 'I');
		ob_end_flush();
	}
	public function employees_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/employees/employees_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$system = $this->Xin_model->read_setting_info(1);
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->final_settlement();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->get_company_employees_flt($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") == 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->get_company_location_employees_flt($this->input->get("company_id"), $this->input->get("location_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") == 0) {
				$employee = $this->Employees_model->get_company_location_department_employees_flt($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0 && $this->input->get("designation_id") != 0) {
				$employee = $this->Employees_model->get_company_location_department_designation_employees_flt($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"), $this->input->get("designation_id"));
			} else {
				$output = array(
					"draw" => $draw,
					"recordsTotal" => 0,
					"recordsFiltered" => 0,
					"data" => array()
				);
				echo json_encode($output);
				exit();
			}
		} else {
			$user_info = $this->Xin_model->read_user_info($session['user_id']);

			$employee = $this->Employees_model->final_settlement();

			$role_resources_ids = $this->Xin_model->user_role_resource();
		}

		$data = array();

		foreach ($employee->result() as $r) {

			// login date and time
			if ($r->last_login_date == '') {
				$edate = '-';
				$etime = '-';
			} else {
				$edate = $this->Xin_model->set_date_format($r->last_login_date);
				$last_login =  new DateTime($r->last_login_date);
				$etime = $last_login->format('h:i a');
			}
			// employee link
			//$role_resources_ids = $this->Xin_model->user_role_resource();
			if (in_array('202', $role_resources_ids)) {
				$emp_link = '<a href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '" data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '">' . $r->employee_id . '</a>';
			} else {
				$emp_link = $r->employee_id;
			}
			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			// user role
			$role = $this->Xin_model->read_user_role_info($r->user_role_id);
			if (!is_null($role)) {
				$role_name = $role[0]->role_name;
			} else {
				$role_name = '--';
			}
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			/* get status*/
			if ($r->is_active == 0) : $status = '<span class="badge bg-red">' . $this->lang->line('xin_employees_inactive') . '</span>';
			elseif ($r->is_active == 1) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_employees_active') . '</span>';
			endif;
			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			$department_designation = $designation_name . ' (' . $department_name . ')';
			$employee_name = $full_name . '<br><small class="text-muted"><i>' . $department_designation . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('xin_employees_id') . ': ' . $emp_link . '<i></i></i></small>';
			$download_file = '<a target="_blank" title="Final Settlement Form" href="' . site_url('admin/final_settlement/final_profile/') . $r->user_id . '"> <i class="fa fa-arrow-circle-down"></i></a>';
			$upload_file = '<a target="_blank" title="Final Settlement Form" href="' . site_url('admin/final_settlement/final_upload/') . $r->user_id . '"> <i class="fa fa-arrow-circle-up"></i></a>';


			// last login date and time
			$elast_login = $edate . ' ' . $etime;
			$data[] = array(
				$r->employee_id,
				$employee_name,

				$comp_name,
				$department_name,
				$download_file,
				$upload_file,
				'-',
				'-',
				'-'

			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}
	public function view_details()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Final Settlement details" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Final Settlement';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'final_settlement';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$key = $this->uri->segment(4);
		// reports to 
		//$reports_to = get_reports_team_data($session['user_id']);

		if (in_array('355', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/final_settlement/view_page", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function add_final_remarks()
	{
		// echo "<pre>";print_r($this->input->post());exit;

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if ($Return['error'] != '') {
			$this->output($Return);
		}
		
		$employee = $this->Employees_model->read_employee_information($this->input->post('user_id'));
        $employee_id = $employee[0]->user_id;
        
        $check_emp_final_settlement_details_exists = $this->Employees_model->check_emp_final_settlement_details_exists($employee_id);
		if ($check_emp_final_settlement_details_exists) {
			$final_datas = array(
				'employee_id' => $this->input->post('eid'),
				'emp_code' => $this->input->post('emp_code'),
				'current_month_salary' => $this->input->post('current_month_salary'),
				'advance_outstanding_amt' => $this->input->post('advance_outstanding_amt'),
				'loan_outstanding_amt' => $this->input->post('loan_outstanding_amt'),
				'asset_complaint_amt' => $this->input->post('asset_complaint_amt'),
				'airticket_encashment_amt' => $this->input->post('airticket_encash_amount'),
				'annual_leave_encashment_amt' => $this->input->post('annual_leave_outstanding_amount'),
				'indemnity_amt' => $this->input->post('indemnity'),
				'total_out_standing_amt' => $this->input->post('total_out_standing_amt'),
				'final_net_payable' => $this->input->post('final_net_payable'),
				'net_payable' => $this->input->post('net_payable'),
				'amount_paid' => $this->input->post('amount_paid'),
				'adjusted_amount' => $this->input->post('adjusted_amount'),
			);
			$this->Employees_model->update_final_Settlement_record($final_datas, $check_emp_final_settlement_details_exists[0]->final_settlement_id);
			$final_settlement_id = $check_emp_final_settlement_details_exists[0]->final_settlement_id;
		} else {
			$final_datas = array(
				'employee_id' => $this->input->post('eid'),
				'emp_code' => $this->input->post('emp_code'),
				'current_month_salary' => $this->input->post('current_month_salary'),
				'advance_outstanding_amt' => $this->input->post('advance_outstanding_amt'),
				'loan_outstanding_amt' => $this->input->post('loan_outstanding_amt'),
				'asset_complaint_amt' => $this->input->post('asset_complaint_amt'),
				'airticket_encashment_amt' => $this->input->post('airticket_encash_amount'),
				'annual_leave_encashment_amt' => $this->input->post('annual_leave_outstanding_amount'),
				'indemnity_amt' => $this->input->post('indemnity'),
				'total_out_standing_amt' => $this->input->post('total_out_standing_amt'),
				'final_net_payable' => $this->input->post('final_net_payable'),
				'net_payable' => $this->input->post('net_payable'),
				'amount_paid' => $this->input->post('amount_paid'),
				'adjusted_amount' => $this->input->post('adjusted_amount'),
			);
			$final_settlement_id = $this->Employees_model->insert_final_settlemet_details($final_datas);
		}

		// ADD: Indemnity
		$indemnity =  $this->input->post('indemninty_amount');
		if ($indemnity > 0) {
			$Indemnityamt = number_format((float)$indemnity, 3, '.', '');
			$year_desc = $this->input->post('start_date_inderminity') . ' to ' . $this->input->post('end_date_inderminity');

			$datas = array(
				'year' => $this->input->post('year'),
				'amount' => $Indemnityamt,
				'balance_amount' => 0,
				'employee_id' => $employee_id,
				'date' => date('d-m-Y'),
				'indemninty_month' => date('Y-m-01'),
				'year_desc' => $year_desc,
				'from_date' => $this->input->post('start_date_inderminity'),
				'to_date' => $this->input->post('end_date_inderminity'),
				'status' => 2,
				'final_settlement_id' => $final_settlement_id,
			);
			$this->Employees_model->emp_indeminty_add($datas);
		}
		
		// UPDATE: Asset complaint deduction
		$asset_complaint_amt = $this->input->post('asset_complaint_amt');
		if ($asset_complaint_amt > 0)
		{
		    $check_emp_assets = $this->Assets_model->get_employee_assets($employee_id);
		    foreach($check_emp_assets->result() as $val_asset)
		    {
		        $check_asset_return_or_not = $this->Assets_model->read_assets_return_info($val_asset->assets_id);
		        if($check_asset_return_or_not)
		        {
                    $this->db->where('id', $check_asset_return_or_not[0]->id);
                    $this->db->update('xin_assets_returns', array(
                        'status' => 1,
                        'final_settlement_id' => $final_settlement_id,
                    ));
		        }
		    }
		}
		
        // UPDATE: Expense claim
        $expense_claim_amt = $this->input->post('expense_claim_amt');
        if ($expense_claim_amt > 0)
        {
            $this->db->where('employee_id', $employee_id);
            $this->db->where('status', 1);
            $this->db->where('paid', 0);
            $this->db->where('final_approval', 1);
            $expenses = $this->db->update('xin_expense_clame', array(
                'paid' => 1,
                'final_settlement_id' => $final_settlement_id,
            ));
        }
        
        // UPDATE: Annual leave encashments
        $annual_leave_outstanding_amount = $this->input->post('annual_leave_outstanding_amount');
        if ($annual_leave_outstanding_amount > 0)
        {
            // Delete unpaid encashments
            $this->db->where('employee_id', $employee_id);
            $this->db->where('status', 'Unpaid');
            $this->db->delete('xin_encashment');
            
            // Find start date and end date to encash
            $start_date = $employee[0]->date_of_joining;
            $end_date = $employee[0]->date_of_leaving;
            
            $this->db->where('employee_id', $employee_id);
            $this->db->where('status', 'Paid');
            $this->db->order_by('end_date', 'asc');
            $ann_encashments = $this->db->get('xin_encashment');
            if ($ann_encashments->num_rows() > 0)
            {
                foreach ($ann_encashments->result() as $ann_encashment)
                {
                    $start_date = $ann_encashment->end_date;
                }
            }
            
            $date_range = "$start_date/$end_date";
            $leave_count = $encashment_day = 0;
            $amount = $annual_leave_outstanding_amount;
            $given_methode = 'Not_Connect_To_Payroll';
            $retrive_month = date('Y-m');
            $retrive_date = date('Y-m-d');
            $payment_mode = '';
            $pay_discription = 'Final settlement';
            $status = 'Paid';
            $balance_en_day = 0;
            $approval_status = 1;
            $date_of_application = date('Y-m-d');
            $designation_id = 0;
            $date_of_joining = '';
            $ticket = '';
            $cheque_number = '';
            $dated = '';
            
            $earlier = new DateTime($start_date);
            $later = new DateTime($end_date);
            $abs_diff = $later->diff($earlier)->format("%a");
            $year = $abs_diff / 365;
            $amonth = $year * 12;
            
            $result = $this->Department_model->ajax_employee_leave_count($start_date, $end_date, $employee_id);
            $day_leaves1 = 0;
            
            if (! empty($result))
            {
                $result1 = $this->Department_model->ajax_employee_leave_count_value($start_date, $end_date, $employee_id);
                
                foreach($result1 as $employee_count_value)
                {
                    $val = $employee_count_value->count_leave;
                    $valdaily = $val/12;
                    
                    $day_leaves1 = $amonth * $valdaily;
                }
            }
            else
            {
                $result1 = $this->Department_model->ajax_employee_leave_count_value($start_date, $end_date, $employee_id);
                
                foreach($result1 as $employee_count_value)
                {
                    $val = $employee_count_value->count_leave;
                    $valdaily = $val/12;
                    
                    $day_leaves1 = $amonth * $valdaily;
                }
            }
            
            $leave_count = round($day_leaves1, 0);
            $encashment_day = $leave_count;
            
            $this->db->insert('xin_encashment', array(
                'company_id' => $employee[0]->company_id,
                'employee_id' => $employee_id,
                'date_range' => $date_range,
                'leave_count' => $leave_count,
                'encashment_day' => $encashment_day,
                'amount' => $amount,
                'given_methode' => $given_methode,
                'retrive_month' => $retrive_month,
                'retrive_date' => $retrive_date,
                'payment_mode' => $payment_mode,
                'pay_discription' => $pay_discription,
                'status' => $status,
                'start_date' => $start_date,
                'end_date' => $end_date,
                'balance_en_day' => $balance_en_day,
                'approval_status' => $approval_status,
                /*'date_of_application' => $date_of_application,
                'designation_id' => $designation_id,
                'date_of_joining' => $date_of_joining,
                'ticket' => $ticket,
                'cheque_number' => $cheque_number,
                'dated' => $dated,*/
                'final_settlement_id' => $final_settlement_id,
            ));
        }
        // Annual leave encashment end ----->
        
        // UPDATE: Airticket encashments
        $airticket_encash_amount = $this->input->post("airticket_encash_amount");
        if ($airticket_encash_amount > 0)
        {
            $duration = $this->Airticket_model->getemp_duration($this->input->post('user_id'));
    		$empdate = $this->Airticket_model->getemp_ticketdate($this->input->post('user_id'));
    		$emp_encash = $this->Airticket_model->getemp_encashments($this->input->post('user_id'));
    		
    		if($empdate && $emp_encash){
    	       $ticket_end = $empdate[0]->duration_to;
    	       $encash_end = $emp_encash[0]->to_date;
    	       $dates      = array($ticket_end, $encash_end);
               $startdate  = max($dates);
    	       $startdate   = date('Y-m-d', strtotime($startdate. ' +1 days'));
    		}elseif($empdate){
    	       $startdate   = $empdate[0]->duration_to;
    	       $startdate   = date('Y-m-d', strtotime($startdate. ' +1 days'));
    		}else{
    		    if($emp_encash){
    		       $startdate      = $emp_encash[0]->to_date;
    		       $startdate      = date('Y-m-d', strtotime($startdate. ' +1 days'));
    		    }else{
    		       $startdate      = $employee[0]->date_of_joining;
    		    }
    		}
    		
            if($duration){
                $emp_years  = $duration[0]->type;
                $emp_days   = $emp_years * 365;
            }else{
                $emp_days   = 365;
            }
            
            $years = 0;
            $end_date = '';
            for($i = strtotime($startdate); $i< time(); ){
                $i = $i + ($emp_days*3600*24);
                if($i> time()){
                    break;
                }
                if($emp_days == 365){
                    $years += $emp_days/365;
                }else{
                    $years += $emp_days/730;
                }
                
                $end_date = date('Y-m-d', $i);
            }
            
            $no_oftickets = $this->Employees_model->getemp_no_of_tickets(array('empid' => $this->input->post('user_id')));
            
            if($no_oftickets){
                $no_of_tickets = (int)$no_oftickets[0]['no_of_tickets'] * $years;
            }else{
                $no_of_tickets = 0;
            }
    
    		// For getting count of feb 29 in between two date ranges
    		if(isset($end_date)){
        		$j = 0;
        		$date1 = $startdate;
        		$date2 = $end_date;
        		
        		for($i= strtotime($date1); $i <= strtotime($date2);){
        		    $daysinmonth = date('t', $i);
        		    
        		    if(date('n',$i) == 2){
        		        if($daysinmonth > 28){
        		            $j++;
        		        }
        		    }
        		    $i = $i + (3600*24*$daysinmonth);
                }
                $j -= 1;
                $end_date = date('Y-m-d', strtotime($date2. '+'.$j.' days'));
            }
            
            $place_to = $employee[0]->nationality_id;
            $reason = 'Final settlement';
            $payroll_month = '';
            $status = 'Approved';
            
            $data = array(
    			'employee_id'       => $this->input->post('user_id'),
    			'from_date'         => $startdate,
    			'to_date'           => $end_date,
    			'no_of_tickets'     => $no_of_tickets,
    			'tickets_for_encash'=> $no_of_tickets,
    			'place_to'          => $place_to,
    			'amount'            => $airticket_encash_amount,
    			'reason'            => $reason,
    			'payroll_month'     => $payroll_month,
    			'status'            => $status,
    			'created_at'        => date('d-m-Y h:i:s'),
    			'final_settlement_id' => $final_settlement_id,
    		);
    		$this->Airticket_model->add_encashment_request($data);
        }
		// Airticket encashment end ----->
		
		// UPDATE: Advance outstanding
		$advance_outstanding_amt = $this->input->post('advance_outstanding_amt');
		if ($advance_outstanding_amt > 0)
		{
		    $advance_salaries = $this->Payroll_model->advance_salary_by_employee_id($employee[0]->user_id);
		    foreach ($advance_salaries as $advance_salary)
		    {
		        $advance_amount =  $advance_salary->advance_amount;
		        $total_paid =  $advance_salary->total_paid;
		        if($advance_amount > $total_paid){
		            $this->db->where('advance_salary_id', $advance_salary->advance_salary_id);
    		        $this->db->update('xin_advance_salaries', array(
        		        'total_paid' => $advance_amount,
        		        'final_settlement_id' => $final_settlement_id,
        		    ));
		        }
		    }
		}
		
		// UPDATE: Loan outstanding
		$loan_outstanding_amt = $this->input->post('loan_outstanding_amt');
		if ($loan_outstanding_amt > 0)
		{
		    $loans = $this->Loan->get(array(
                'employee_id' => $employee[0]->user_id,
                'status' => 1
            ));
            foreach ($loans->result() as $loan)
            {
                $this->db->insert('xin_salary_payslip_loan', array(
                    'payslip_id' => 0,
                    'employee_id' => $employee[0]->user_id,
                    'loan_title' => $loan->loan_deduction_title,
                    'loan_amount' => $loan_outstanding_amt,
                    'salary_month' => date('Y-m'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'loan_id' => $loan->loan_deduction_id,
                    'final_settlement_id' => $final_settlement_id,
                ));
            }
		}
		
		$id = $this->input->post('eid');

		$result = $this->Employees_model->update_final_remark(array(
			'final_settlement_remark' => $this->input->post('final_remark'),
			'final_settlement_status' => 'Y',
		), $id);

		$Return['result'] = 'Final settlement info has been saved.';

		$this->output($Return);
		exit;
	}
	
	public function removeEntries($employee_id)
	{
	    $this->db->where('employee_id', $employee_id);
	    $final_settlement = $this->db->get('final_settlement')->row();
	    
	    if (! $final_settlement) return false;
	    
	    $final_settlement_id = $final_settlement->final_settlement_id;
	    
	    $this->db->where('final_settlement_id', $final_settlement_id);
	    $this->db->delete('xin_employee_indemnity');
	    
	    $this->db->where('final_settlement_id', $final_settlement_id);
	    $this->db->update('xin_assets_returns', array(
            'status' => 0,
        ));
        
        $this->db->where('final_settlement_id', $final_settlement_id);
        $this->db->update('xin_expense_clame', array(
            'paid' => 0,
        ));
        
        $this->db->where('final_settlement_id', $final_settlement_id);
	    $this->db->delete('xin_encashment');
	    
	    $this->db->where('final_settlement_id', $final_settlement_id);
	    $this->db->delete('xin_airticket_encashment_requests');
	    
	    $this->db->where('employee_id', $employee_id);
	    $this->db->delete('xin_employee_resignations');
	    
	    $advance_outstanding_amt = $final_settlement->advance_outstanding_amt;
	    
	    $this->db->where('final_settlement_id', $final_settlement_id);
	    $advance_outstanding = $this->db->get('xin_advance_salaries')->row();
	    if ($advance_outstanding)
	    {
	        $total_paid = $advance_outstanding->total_paid - $advance_outstanding_amt;
	        if ($total_paid < 0) $total_paid = 0;
    	    $this->db->set('total_paid', $total_paid);
    	    $this->db->where('final_settlement_id', $final_settlement_id);
            $this->db->update('xin_advance_salaries');
	    }
        
        $this->db->where('final_settlement_id', $final_settlement_id);
	    $this->db->delete('xin_salary_payslip_loan');
	}

	public function delete()
	{


		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$data = array(
			'final_settlement_status' => 'N',
			'resignation_date' => '',
			'date_of_leaving' => ''
		);
		$result1 = $this->Employees_model->update_final_remark($data, $id);
	//	$result = $this->Employees_model->delete_final_records($id);
		if (isset($id)) {
		    
		    $this->removeEntries($id);
            $result = $this->Employees_model->delete_final_records($id);
			$Return['result'] = 'Deleted';

			/*<script>
				alert('Final settlement remarks deleted successfully');
				     document.location.href='/admin/final_settlement';
				</script>*/
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}
	public function change_status()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$id = $this->input->get('id');

		$status = $this->input->get('status');

		$data = array(

			'final_settlement_status' => $status

		);

		$result = $this->Employees_model->update_final_remark($data, $id);

		if ($result == TRUE) {
		    
		    if ($status == 'N')
		    {
		        $this->removeEntries($id);
		    }

			$Return['result'] = 'Status Updated';
		} else {

			$Return['result'] = $this->lang->line('xin_error_msg');
		}



		$this->output($Return);

		exit;
	}


	//      public function view_page()
	//      {

	//          	$data['title'] = $this->Xin_model->site_title();
	// 		$session = $this->session->userdata('username');
	// 		if(!empty($session)){ 
	// 			$this->load->view("admin/final_settlement/view_details", $data);
	// 		} else {
	// 			redirect('admin/');
	// 		}


	//     	$key = $this->uri->segment(4);
	// 	    $user = $this->Xin_model->read_user_info($key);
	// 	    // user full name
	// 		if(!is_null($user)){
	// 			$first_name = $user[0]->first_name;
	// 			$last_name = $user[0]->last_name;
	// 		} else {
	// 			$first_name = '--';
	// 			$last_name = '--';
	// 		}
	// 		// get designation
	// 		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
	// 		if(!is_null($designation)){
	// 			$designation_name = $designation[0]->designation_name;
	// 		} else {
	// 			$designation_name = '--';	
	// 		}
	// 		// department
	// 		$department = $this->Department_model->read_department_information($user[0]->department_id);
	// 		if(!is_null($department)){
	// 			$department_name = $department[0]->department_name;
	// 		} else {
	// 			$department_name = '--';	
	// 		}
	// 		//$department_designation = $designation[0]->designation_name.'('.$department[0]->department_name.')';
	// 		$data['all_employees'] = $this->Xin_model->all_employees();
	// 		$data = array(
	// 		    'first_name' => $first_name,
	// 				'last_name' => $last_name,
	// 				'employee_id' => $user[0]->employee_id,
	// 				'euser_id' => $user[0]->user_id,
	// 				'company_id' => $user[0]->company_id,
	// 				'contact_no' => $user[0]->contact_no,
	// 				'date_of_joining' => $user[0]->date_of_joining,
	// 				'department_name' => $department_name,
	// 				'designation_name' => $designation_name,
	// 				'profile_picture' => $user[0]->profile_picture,
	// 				'gender' => $user[0]->gender,
	// 				'retire'=>$user[0]->date_of_leaving,
	// 		    );
	// 		    $data['breadcrumbs'] = $this->lang->line('xin_payroll_employee_payslip');
	// 		$data['path_url'] = 'final_settlement';
	// 		$role_resources_ids = $this->Xin_model->user_role_resource();

	//     }
	public function dwnld_final_settlement(){
		$system = $this->Xin_model->read_setting_info(1);
		 // create new PDF document
   		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$key = $this->uri->segment(4);
		$user = $this->Xin_model->read_user_info($key);	
		if(is_null($user)){
			redirect('admin/final_settlement');
		}
		$eid=$user[0]->user_id;
		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);
// 		var_dump($user);die();
		if(!is_null($_des_name)){
			$_designation_name = $_des_name[0]->designation_name;
		} else {
			$_designation_name = '';
		}
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if(!is_null($department)){
			$_department_name = $department[0]->department_name;
		} else {
			$_department_name = '';
		}
		$fname = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;
		// company info
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		if(!is_null($company)){
		  $company_name = $company[0]->name;
		  $address_1 = $company[0]->address_1;
		  $address_2 = $company[0]->address_2;
		  $city = $company[0]->city;
		  $state = $company[0]->state;
		  $zipcode = $company[0]->zipcode;
		  $logo='<img alt="<?php echo $system[0]->application_name;?>" src="<?php echo base_url();?>uploads/logo/<?php echo $company[0]->logo;?>" class="brand-logo" style="width:32px;">';
		  $country = $this->Xin_model->read_country_info($company[0]->country);
		  if(!is_null($country)){
			  $country_name = $country[0]->country_name;
		  } else {
			  $country_name = '--';
		  }
		  $c_info_email = $company[0]->email;
		  $c_info_phone = $company[0]->contact_number;
		} else {
		  $company_name = '--';
		  $address_1 = '--';
		  $address_2 = '--';
		  $city = '--';
		  $state = '--';
		  $zipcode = '--';
		  $country_name = '--';
		  $c_info_email = '--';
		  $c_info_phone = '--';
		  $logo='--';
		}
		$month_year=$user[0]->date_of_leaving;
        $start_date_y_m = date('Y-m', strtotime($month_year));
        $pay_date = date('Y-m', strtotime($month_year));
        $result = $this->Payroll_model->read_employee_payslip_info_key($key,$start_date_y_m);
		$location = $this->Location_model->read_location_information($user[0]->location_id);
		$user_role = $this->Roles_model->read_role_information($user[0]->user_role_id);
    	$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode;
		
		$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email \n";
		
// 		$header_string = $email_phone_address;	
        $header_string='Final Settlement Details';
		// set document information
		$pdf->SetCreator('HRSALE');
		$pdf->SetAuthor('HRSALE');
		//$pdf->SetTitle('Workable-Zone - Payslip');
		//$pdf->SetSubject('TCPDF Tutorial');
		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
		
// 		$pdf->SetHeaderData('../../../uploads/logo/'.$logo, 15, $company_name, $header_string);
			
		$pdf->setFooterData(array(0,64,0), array(0,64,128));
		
		// set header and footer fonts
		$pdf->setHeaderFont(Array('helvetica', '', 11.5));
		$pdf->setFooterFont(Array('helvetica', '', 9));
		
		// set default monospaced font
		$pdf->SetDefaultMonospacedFont('courier');
		
		// set margins
		$pdf->SetMargins(15, 27, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		
		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, 25);
		
		// set image scale factor
		$pdf->setImageScale(1.25);
		$pdf->SetAuthor('HRSALE');
		$pdf->SetTitle($company_name.' - '.'Final Settlement');
		$pdf->SetSubject($this->lang->line('xin_download_profile_title'));
		$pdf->SetKeywords($this->lang->line('xin_download_profile_title'));
		// set font
		$pdf->SetFont('helvetica', 'B', 10);
				
		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		
		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		
		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
		
		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
		
		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
		
		// ---------------------------------------------------------
		
		// set default font subsetting mode
		$pdf->setFontSubsetting(true);
		
		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 10, '', true);
		
		// Add a page
		// This method has several options, check the source code documentation for more information.
		$pdf->AddPage();
		/*$tbl = '<br>
		<table cellpadding="1" cellspacing="1" border="0">
			<tr>
				<td align="center"><h1>'.$fname.'</h1></td>
			</tr>
		</table>
		';
		$pdf->writeHTML($tbl, true, false, false, false, '');*/
		// -----------------------------------------------------------------------------
		$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);
		
		// set cell padding
		$pdf->setCellPaddings(1, 1, 1, 1);
		
		// set cell margins
		$pdf->setCellMargins(0, 0, 0, 0);
		
		// set color for background
		$pdf->SetFillColor(255, 255, 127);
		$allowances = $this->Employees_model->other_employee_allowances($eid);
		$total_allowance=$sum=$total_commissions=$total_overtime=$total_loan=$total_other_payments=$total_sum=$total_allowance1=$total=0;
		foreach($allowances->result() as $sl_allowances) {
		    $total_allowance+=$sl_allowances->allowance_amount;
		}
		$hr_allowance = $this->Employees_model->hr_employee_allowances($eid);
		$hra=$sum=$total_commissions=$total_overtime=$total_loan=$total_other_payments=$total_sum=$total_allowance1=$total=0;
	    foreach($hr_allowance->result() as $sl_allowances) {
		    $hra+=$sl_allowances->allowance_amount;
		}
		$month_year_att =$user[0]->date_of_joining;
        $month_year_att_end =  $user[0]->date_of_leaving;
        $startDate = new DateTime($month_year_att);
        $endDate = new DateTime($month_year_att_end);
        $difference = $endDate->diff($startDate);
        $difference_days_yre  = $difference->format("%y Years %m Months %d Days ");
        $month_year=$user[0]->date_of_leaving;
        $pay_date = date('Y-m', strtotime($month_year));
        $date = strtotime(date("Y-m-d"));
        
        if(!isset($pay_date)){
          $day = date('d', $date);
          $month = date('m', $date);
          $year = date('Y', $date);
          $pay_date = date('Y-m');
        } else {
          $imonth_year = explode('-',$pay_date);
          $day = date('d', $date);
          $month = date($imonth_year[1], $date);
          $year = date($imonth_year[0], $date);
          $pay_date = $pay_date;
        }
          $arry_years = array();
          $st = '';
          $p_count_val = 0;
          $joining_date = $user[0]->date_of_joining;
          $month_year_new = date('Y-m', strtotime($month_year));
          $start_date_co = $joining_date;
          $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
          $end_date_co = $user[0]->date_of_leaving;
          $off_day_arr = array();
          $holiday_arr = array();
          $office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
          if(!is_null($office_shift)){
            $start_date_co = $joining_date;
            $present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
            $absent_count = $flag = 0;
            $leave_count = 0;
            $month_year = date('Y-m', strtotime($month_year));
            $month_year_att = $joining_date;
            $month_year_att_end = $user[0]->date_of_leaving;
            $startDate = new DateTime($month_year_att);
            $endDate = new DateTime($month_year_att_end);
            $difference = $endDate->diff($startDate);
            $difference_days  = $difference->format("%a") + 1;
            $attendence = $this->Xin_model->AttendnceCount_calc_common($user[0]->office_shift_id,$month_year_att,$month_year_att_end,$user[0]->company_id,$user[0]->user_id,$difference_days,$years='',$monthss='','inderminity');
            if($attendence){
    		      $tot_days_lop_normal = $attendence[0];
    		      $totl_num_days_pres = $attendence[1];
      		  }else{
    		      $tot_days_lop_normal = 0;
    		      $totl_num_days_pres = 0;
      		  }
        }
        
        $startDate=$date1 = $user[0]->date_of_joining;
        $endDate=$date2 = $user[0]->date_of_leaving;
        $diff = abs(strtotime($date2) - strtotime($date1));
        $years = floor($diff / (365*60*60*24));
        $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
        $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
        $startTimestamp = strtotime($startDate);
        $endTimestamp = strtotime($endDate);
        $workingDays=0;
        for($i=$startTimestamp; $i<=$endTimestamp; $i = $i+(60*60*24) ){
        if(date("N",$i) <= 5)
          $workingDays = $workingDays + 1;
        } 
        
        if($years != 0){ 
            $arry_years = array();
            $basic_salary  = $user[0]->basic_salary;
            $joing_date  = $user[0]->date_of_joining;
            $Indemnity = $total_years = 0;
            $checkYearExists = $this->Employees_model->CheckEmployeeYearExistsIndemnity($user[0]->user_id);
            if($checkYearExists){
                foreach($checkYearExists as $val_years){
                  $arry_years[] =$val_years->year;
                }
            }
            $from_date_submitted ='';
            if(!empty($arry_years)){
                $from_date_submitted = $this->Employees_model->GetFromAndToDateOfIndemnity($user[0]->user_id,max($arry_years));
            }                                
            if($from_date_submitted){
                $date_joins = $from_date_submitted->to_date;
                $date_joins = date('Y-m-d', strtotime($date_joins . ' +1 day'));
                $date=date_create($date_joins);
                $date_join = date_format($date,"Y/m/d");
                $todays_date  = $user[0]->date_of_leaving;
                $date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
                $years = floor($date_diff_calc / (365*60*60*24));
            }else{
                $date_join = $user[0]->date_of_joining;
                $todays_date  = $user[0]->date_of_leaving;
                $date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
                $years = floor($date_diff_calc / (365*60*60*24));
            } 
            $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
            $end_date_co = $todays_date;
            $present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
            $absent_count = $flag = 0;
            $leave_count = 0;
            $month_year = date('Y-m', strtotime($month_year));
            //find_diff
            $month_year_att = $date_join;
            $month_year_att_end = $todays_date;
            $startDate = new DateTime($month_year_att);
            $endDate = new DateTime($month_year_att_end);
            $difference = $endDate->diff($startDate);
            $difference_days  = $difference->format("%a") + 1;
            //changes 
            $d1 = new DateTime($month_year_att);
            $d2 = new DateTime($month_year_att_end);
            $diff = $d2->diff($d1);
            $checkYearExists = $this->Employees_model->CheckEmployeeYearExistsIndemnity($user[0]->user_id);
            if($checkYearExists){
              foreach($checkYearExists as $val_years){
                $total_years += $val_years->year;
              }
              $year = $diff->y;
            }else{
                $year = $diff->y + 1;
            }
    		
            $year_text =  $total_years + $year;
            if($year < 1){
                    $year = 1;
                }
            $Indemnity = $this->Xin_model->Inderminity_calc_common($year,$year_text,$total_years,$user[0]->date_of_leaving,$user[0]->office_shift_id,$month_year_att,$month_year_att_end,$user[0]->company_id,$user[0]->user_id,$difference_days,$basic_salary); 
        }else{
            $Indemnity = 0;
        }
        $Indemnity = $this->Xin_model->company_currency_sign(number_format((float)$Indemnity, 3, '.', ''),$user[0]->company_id);
        $Outstanding_Amt = $loan_outstanding_amount = 0;
        $re_amount = 0;
        $advance_salary = $this->Payroll_model->advance_salary_by_employee_id($user[0]->user_id);
        $emp_value = $this->Payroll_model->get_paid_salary_by_employee_id($user[0]->user_id);
        if($advance_salary){
            foreach($advance_salary as $advance_salary){
                $monthly_installment =  $advance_salary->monthly_installment;
                $advance_amount =  $advance_salary->advance_amount;
                $total_paid =  $advance_salary->total_paid;  
                $em_advance_amount =  $advance_salary->advance_amount;
                $em_total_paid =  $advance_salary->total_paid;
                if($em_advance_amount > $em_total_paid){
                    if($monthly_installment!='' || $monthly_installment!=0) {                                     
                        $re_amount = $em_advance_amount - $em_total_paid;
                        $Outstanding_Amt += $re_amount ;
                    }
                }
            }
        }
        $loan = $this->Employees_model->set_employee_deductions_with_status($user[0]->user_id);
        $loan_outstanding_amount = 0; 
        if($loan->result()){
          	foreach($loan->result() as $r_loan) { 
        	    $check_loan_payed = $this->Employees_model->read_salary_loan_deductions_with_loan_id($user[0]->user_id,$r_loan->loan_deduction_id);
        	    if(empty(isset($check_loan_payed[0]->loan_amount))){ 
        	        if($r_loan->monthly_installment){
        	           $loan_outstanding_amount += $r_loan->monthly_installment; 
        	        }
                }else{
                    if($r_loan->monthly_installment > $check_loan_payed[0]->loan_amount_total){
        	            $remaining_amt_loan =  $r_loan->monthly_installment - $check_loan_payed[0]->loan_amount_total;
        	            $loan_outstanding_amount += $remaining_amt_loan;
                	}
                }
            }
        }
        // var_dump($re_amount,$loan_outstanding_amount);die();
        
        $this->db->where('employee_id', $user[0]->user_id);
        $final_settlement = $this->db->get('final_settlement')->row();
        
        $split_val = explode(".", $final_settlement->amount_paid);
        	if (count($split_val) > 1) {
				$word_amt = $this->Xin_model->wholeconvertNumberToWord($split_val[0],$split_val[1],'Qatari Rials','& Fils','Only');
			} else {
				$word_amt = $this->Xin_model->wholeconvertNumberToWord($final_settlement->amount_paid,'','','','');
			}
        
		
		$tbl_2 = '
		<table cellpadding="2" cellspacing="0" border="0">
		<tr style="">
		    <td colspan="13" style="text-align:center;background-color:#e5dfdf;text-decoration: underline;" border="1"><h1>Final Settlement Details</h1></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;">FINAL SETTLEMENT OF '.$user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name.' (Emp ID: '.$user[0]->employee_id.')</td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">DATE OF JOINING </td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;">'.$user[0]->date_of_joining.'</td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">DATE OF RESIGNATION </td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;">'.$user[0]->date_of_leaving.'</td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">BASIC SALARY</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($user[0]->basic_salary,$user[0]->company_id).'</td>
		</tr>';
		$allowances_total = 0;
		$allowances = $this->Employees_model->set_employee_allowances($eid);
		if ($allowances->num_rows() > 0) {
		    $tbl_2 .= '<tr><td colspan="13" border="1" style="border-style: dotted !important;"></td></tr>
		    <tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><b>ALLOWANCES</b></td>
		</tr>';
		}
		foreach ($allowances->result() as $allowance) {
		    if ($allowance->status != 'Y') continue;
		    
		    $this->db->where('id', $allowance->allowance_title);
		    $query = $this->db->get('allowance');
		    $allowance_title = $query->row();
		    if (! $allowance_title) continue;
		$tbl_2 .= '
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;'.$allowance_title->name.'</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($allowance->allowance_amount,$user[0]->company_id).'</td>
		</tr>';
		    $allowances_total += $sl_allowances->allowance_amount;
		}
		
		$commissions = $this->Employees_model->set_employee_commissions_with_status($eid);
        if($commissions->num_rows() > 0){
            $tbl_2 .= '<tr><td colspan="13" border="1" style="border-style: dotted !important;"></td></tr>
            <tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><b>COMMISSIONS</b></td>
		</tr>';
		    foreach($commissions->result() as $sl_commissions) {
		        if($system[0]->is_half_monthly==1){
                    if($system[0]->half_deduct_month==2){
                        $ecommissions_amount = $sl_commissions->commission_amount/2;
                    } else {
                        $ecommissions_amount = $sl_commissions->commission_amount;
                    }
                } else {
                    if($sl_commissions->is_commission_taxable == 1) {
                        if($sl_commissions->amount_option == 0) {
                            $ecommissions_amount = $sl_commissions->commission_amount;
                        } else {
                            $ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
                        }
                    } else if($sl_commissions->is_commission_taxable == 2) {
                        if($sl_commissions->amount_option == 0) {
                            $ecommissions_amount = $sl_commissions->commission_amount / 2;
                        } else {
                            $ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
                        }
                    } else {
                        if($sl_commissions->amount_option == 0) {
                            $ecommissions_amount = $sl_commissions->commission_amount;
                        } else {
                            $ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
                        }
                    }
                }
                $allo = $this->Xin_model->read_single_allowance($sl_commissions->commission_title);
                $tbl_2 .= '
        		<tr >
        			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;'.$allo[0]->name.'</td>
        			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
        			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($ecommissions_amount,$user[0]->company_id).'</td>
        		</tr>';
		    }
        }
        
        $statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_with_status($eid);
        if($statutory_deductions->num_rows() > 0){
            $tbl_2 .= '<tr><td colspan="13" border="1" style="border-style: dotted !important;"></td></tr>
            <tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><b>DEDUCTIONS</b></td>
		</tr>';
		    foreach($statutory_deductions->result() as $sl_statutory_deductions) {
                $allo = $this->Xin_model->read_constant_allowance($sl_statutory_deductions->deduction_title);
                $sta_salary = $basic_salary;
                $st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
                
                if($system[0]->is_half_monthly==1){
                    if($system[0]->half_deduct_month==2){
                      $single_sd = $st_amount/2;
                    } else {
                      $single_sd = $st_amount;
                    }
                } else {
                    if($sl_statutory_deductions->statutory_options == 0) {
                      $single_sd = $sl_statutory_deductions->deduction_amount;
                    } else {
                        if ($sl_statutory_deductions->deduction_title == 7) {
                            $single_sd = ($basic_salary + $allowances_total) / 100 * $sl_statutory_deductions->deduction_amount;
                        } else {
                            $single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
                        }
                    }
                }
                $tbl_2 .= '
        		<tr >
        			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;'.$allo[0]->name.'</td>
        			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
        			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($single_sd,$user[0]->company_id).'</td>
        		</tr>';
		    }
        }
        
        $other_payments = $this->Employees_model->set_employee_other_payments_with_status($eid);
        if($other_payments->num_rows() > 0) {
            $tbl_2 .= '<tr><td colspan="13" border="1" style="border-style: dotted !important;"></td></tr>
            <tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><b>OTHER PAYMENTS</b></td>
		</tr>';
		    foreach($other_payments->result() as $sl_other_payments) {
                $allo = $this->Xin_model->read_constant_allowance($sl_other_payments->payments_title);
                
                if($system[0]->is_half_monthly==1){
                  if($system[0]->half_deduct_month==2){
                    $epayments_amount = $sl_other_payments->payments_amount/2;
                  } else {
                    $epayments_amount = $sl_other_payments->payments_amount;
                  }
                } else {
                    //$epayments_amount = $sl_other_payments->payments_amount;
                    if($sl_other_payments->is_otherpayment_taxable == 1) {
                      if($sl_other_payments->amount_option == 0) {
                        $epayments_amount = $sl_other_payments->payments_amount;
                      } else {
                        $epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
                      }
                    } else if($sl_other_payments->is_otherpayment_taxable == 2) {
                      if($sl_other_payments->amount_option == 0) {
                        $epayments_amount = $sl_other_payments->payments_amount / 2;
                      } else {
                        $epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
                      }
                    } else {
                      if($sl_other_payments->amount_option == 0) {
                        $epayments_amount = $sl_other_payments->payments_amount;
                      } else {
                        $epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
                      }
                    }
                }
                
                $tbl_2 .= '
        		<tr >
        			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;'.$allo[0]->name.'</td>
        			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
        			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($epayments_amount,$user[0]->company_id).'</td>
        		</tr>';
		    }
        }
        
		$tbl_2 .= '
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><strong>INDEMNITY</strong></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;INDEMNITY FOR SERVICE - '.$user[0]->date_of_joining.'  To '.$user[0]->date_of_leaving.'</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->indemnity_amt,$user[0]->company_id).'</td>
		</tr>';
		
		$tbl_2 .= '<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><b>ENCASHMENT</b></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Air Ticket Encashment</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->airticket_encashment_amt,$user[0]->company_id).'</td>
		</tr>';
		
		$emp_expense_claim = $this->Xin_model->FindExpenseClaimTotal($eid);
		$tbl_2 .= '<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Expense Encashment</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($emp_expense_claim,$user[0]->company_id).'</td>
		</tr>';
		
		$tbl_2 .= '<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Annual Leave Encashment</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->annual_leave_encashment_amt,$user[0]->company_id).'</td>
		</tr>';
		
		$tbl_2 .= '<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><b>OUTSTANDINGS</b></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Advance Outstanding</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->advance_outstanding_amt,$user[0]->company_id).'</td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Loan Outstanding</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->loan_outstanding_amt,$user[0]->company_id).'</td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><strong>LEAVE PAY</strong></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Leave pay entitled on Resignation - </td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->annual_leave_encashment_amt,$user[0]->company_id).'</td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;(Gross Salary/365*No of Days Worked)</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="13" border="1" style="border-style: dotted !important;"><strong>OTHER DEDUCTIONS</strong></td>
		</tr>';
		$month_year = $user[0]->date_of_leaving;
        $leaving_month = date('Y-m', strtotime($month_year));
        
        $asset_complaint_amt = 0;
        $check_emp_assets = $this->Assets_model->get_employee_assets($eid);
        if($check_emp_assets->result()){
            foreach($check_emp_assets->result() as $val_asset){
                $check_asset_return_or_not = $this->Assets_model->read_assets_return_info($val_asset->assets_id);
                if($check_asset_return_or_not){
                    $handover_date = date('Y-m', strtotime($check_asset_return_or_not[0]->handover_date));
                    if($handover_date == $leaving_month && !empty($check_asset_return_or_not[0]->cash_collected)){
                        $asset_complaint_amt += $check_asset_return_or_not[0]->cash_collected;
                    }
                }
            }
        }
        
		$tbl_2 .= '<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Asset Complaint</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($asset_complaint_amt,$user[0]->company_id).'</td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;">&nbsp;&nbsp;Adjusted Amount</td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;">'.$this->Xin_model->company_currency_sign($final_settlement->adjusted_amount,$user[0]->company_id).'</td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;"></td>
			<td colspan="2" border="1" style="border-style: dotted !important;"></td>
			<td colspan="3" border="1" style="border-style: dotted !important;"></td>
		</tr>
		<tr >
			<td colspan="8" border="1" style="border-style: dotted !important;"><strong style="text-align:center">Total</strong></td>
			<td colspan="2" border="1" style="border-style: dotted !important;"><strong style="text-align:center"></strong></td>
			<td colspan="3" border="1" style="border-style: dotted !important;text-align:right;"><strong>'.$this->Xin_model->company_currency_sign($final_settlement->amount_paid,$user[0]->company_id).'</strong></td>
		</tr>
		<tr>
		    <td colspan="13" style="border-style: dotted !important;" border="1">'.$this->Xin_model->company_currency_sign($final_settlement->amount_paid,$user[0]->company_id).' ONLY</td>
		</tr>
		<tr>
		    <td colspan="13" style="border-style: dotted !important;" border="1"><br><br><br>Prepared by .......................................<span style="color:white">............</span>Checked / Approved by..................................................</td>
		</tr>
		<tr>
		    <td colspan="13" style="border-style: dotted !important;" border="1"></td>
		</tr>
		<tr>
		    <td colspan="10" style="border-style: dotted !important;" border="1">I '.$user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name.',  (Emp ID: '.$user[0]->employee_id.') do hereby declare that I have received  the sum of '.$this->Xin_model->company_currency_sign($final_settlement->amount_paid,$user[0]->company_id).' ('.$word_amt.' )  by Bank Transfer  from Final Settlement,  in full and final settlement of all my dues  as detailed above and I shall not have any further claims whatsoever.</td>
		    <td colspan="3" border="1" style="border-style: dotted !important;">'.$this->Xin_model->company_currency_sign($final_settlement->amount_paid,$user[0]->company_id).'</td>
		</tr>
		<tr>
		    <td colspan="13" style="border-style: dotted !important;" border="1"><br><br><br>Date: .................................................. <span style="color:white">.................................</span> Signature:..............................................</td>
		</tr>
		</table>';
		$pdf->writeHTML($tbl_2, true, false, false, false, '');
		$fname = strtolower($fname);
		$pay_month = strtolower(date("F Y"));
		//Close and output PDF document
		ob_start();
		$pdf->Output('payslip_'.$fname.'_'.$pay_month.'.pdf', 'I');
		ob_end_flush();
		 
	}
}
