<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');

class History extends MY_Controller
{
	public function __construct()
	{
		parent::__construct();

		$this->load->model("Employees_model");
		$this->load->model("Timesheet_model");
	}

	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");

		/*Final JSON response*/
		exit(json_encode($Return));
	}

	public function assign_leave()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$employee_id = $this->input->post('emp_id');
		$leave_type = $this->input->post('type');
		$leave_count = $this->input->post('count');
		$created_at = $this->input->post('created_at');

		$year = date('Y', strtotime($created_at));

		$this->db->where('employee_id', $employee_id);
		$this->db->where('leave_type', $leave_type);
		$this->db->like('created_at', $year, 'after');
		$assigned_leaves = $this->db->get('employee_leave');

		if ($assigned_leaves->num_rows() > 0) {
			$Return['error'] = 'Leave already assigned.';
		} else {
			$this->db->insert('employee_leave', array(
				'employee_id' => $employee_id,
				'leave_type' => $leave_type,
				'leave_count' => $leave_count,
				'created_at' => $created_at,
			));

			$this->db->insert('carry_leaves', array(
				'employee_id' => $employee_id,
				'leave_type_id' => $leave_type,
				'remaing_leave_count' => $leave_count,
				'create_date' => $created_at,
			));

			$Return['result'] = 'Leave saved.';
		}

		$this->output($Return);
	}

	public function leaves_assigned($employee_id, $created_at)
	{
		$year = date('Y', strtotime($created_at));

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$this->db->where('employee_id', $employee_id);
		$this->db->like('created_at', $year, 'after');
		$assigned_leaves = $this->db->get('employee_leave');

		$data = array();

		foreach ($assigned_leaves->result() as $item) {
			$this->db->where('leave_type_id', $item->leave_type);
			$leave_type = $this->db->get('xin_leave_type')->row();

			$data[] = array(
				'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
                <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-leave-counts-modal" data-record-id="' . $item->id . '">
                <span class="fas fa-trash-restore"></span>
                </button>
                </span>',
				$leave_type->type_name,
				$item->leave_count,
				$item->created_at,
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $assigned_leaves->num_rows(),
			"recordsFiltered" => $assigned_leaves->num_rows(),
			"data" => $data
		);

		$this->output($output);
	}


	public function leaves_assigned_added($employee_id, $created_at)
	{
		$year = date('Y', strtotime($created_at));
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$this->db->where('employee_id', $employee_id);
		$this->db->like('created_at', $year, 'after');
		$assigned_leaves = $this->db->get('employee_leave');

		$data = array();

		foreach ($assigned_leaves->result() as $item) {
			$this->db->where('leave_type_id', $item->leave_type);
			$leave_type = $this->db->get('xin_leave_type')->row();

			$data[] = array(
				'<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
                <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-leave-counts-modal" data-record-id="' . $item->id . '">
                <span class="fas fa-trash-restore"></span>
                </button>
                </span>',
				$leave_type->type_name,
				$item->leave_count,
				$item->created_at,
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $assigned_leaves->num_rows(),
			"recordsFiltered" => $assigned_leaves->num_rows(),
			"data" => $data
		);

		$this->output($output);
	}

	public function delete_leaves_assigned()
	{
		$id = $this->input->post('_token');

		$this->db->where('id', $id);
		$this->db->delete('employee_leave');

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$Return['result'] = 'Assigned Leave deleted.';

		$this->output($Return);
	}


	public function delete_leave_history()
	{
		$id = $this->input->post('id');
		$this->db->where('leave_id', $id);
		$this->db->delete('xin_employee_leave_applications_history');

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$Return['result'] = 'Leave History deleted.';

		$this->output($Return);
	}

	public function add_leave()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$remarks = $this->input->post('remarks');

		$st_date = strtotime($start_date);
		$ed_date = strtotime($end_date);
		$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
		$no_of_days_annual_remain = 0;

		/* Server side PHP input validation */
		if ($this->input->post('leave_type') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_field');
		} else if ($this->input->post('start_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_start_date');
		} else if ($this->input->post('end_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_end_date');
		} else if ($st_date > $ed_date) {
			$Return['error'] = $this->lang->line('xin_error_start_end_date');
		} else if ($this->input->post('company_id') === '') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if ($this->input->post('employee_id') === '') {
			$Return['error'] = $this->lang->line('xin_error_employee_id');
		} else if ($this->input->post('reason') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
		}

		$datetime1 = new DateTime($this->input->post('start_date'));
		$datetime2 = new DateTime($this->input->post('end_date'));
		$interval = $datetime1->diff($datetime2);
		$no_of_days = $interval->format('%a') + 1;

		if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
			$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$date = date('Y-m-d');
		$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));

		//condition for Haj leave
		if ($this->input->post('leave_type') == 8) {
			if ($joining_date[0]->ethnicity_type != 2) {
				$Return['error'] = "Only Muslim Can Apply for this leave";
			}
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$eremaining_leave = 0; //$user_info_all[0]->leave_days;
		$count_l = 0;
		$leave_halfday_cal = employee_leave_halfday_cal($this->input->post('leave_type'), $this->input->post('employee_id'));

		foreach ($leave_halfday_cal as $lhalfday) :
			$count_l += 0.5;
		endforeach;

		$remaining_leave = count_leaves_info($this->input->post('leave_type'), $this->input->post('employee_id'));
		$remaining_leave = $remaining_leave - $count_l;

		$type = $this->Timesheet_model->read_leave_type_information($this->input->post('leave_type'));

		if (!is_null($type)) {
			$total = $type[0]->days_per_year;
			$leave_remaining_total = $total - $remaining_leave;
		} else {
			$leave_remaining_total = 0;
		}

		if (in_array($this->input->post('leave_type'), array(3, 4, 5, 7))) {
			$leave_remaining_total = $leave_remaining_total + $eremaining_leave;
		} else {
			$leave_remaining_total = $leave_remaining_total;
		}

		if ($this->input->post('leave_half_day') != 1) {
			$leave_half_day_opt = 0;
		} else {
			$leave_half_day_opt = $this->input->post('leave_half_day');
		}

		if ($this->input->post('start_date') == $this->input->post('end_date')) {
			$no_of_days = 1;
		} else {
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);

			$no_of_days = $interval->format('%a') + 1;
		}

		$data = array(
			'employee_id' => $this->input->post('employee_id'),
			'company_id' => $this->input->post('company_id'),
			'leave_type_id' => $this->input->post('leave_type'),
			'from_date' => $this->input->post('start_date'),
			'to_date' => $this->input->post('end_date'),
			'applied_on' => date('Y-m-d h:i:s'),
			'reason' => $this->input->post('reason'),
			'remarks' => $qt_remarks,
			'leave_attachment' => '',
			'status' => '2',
			'is_notify' => '1',
			'is_half_day' => $leave_half_day_opt,
			'created_at' => $this->input->post('start_date'),
			'days' => $no_of_days,
			'history' => 1
		);
		$result = $this->Timesheet_model->add_leave_record_new($data);

		$this->db->where('employee_id', $this->input->post('employee_id'));
		$this->db->where('leave_type_id', $this->input->post('leave_type'));
		$this->db->like('create_date', date('Y', strtotime($this->input->post('create_date'))));
		$carry_leave = $this->db->get('carry_leaves')->row();

		if ($carry_leave) {
			$remaing_leave_count = $carry_leave->remaing_leave_count - $no_of_days;

			$this->db->where('id', $carry_leave->id);
			$this->db->update('carry_leaves', array(
				'remaing_leave_count' => $remaing_leave_count
			));
		}

		$Return['result'] = 'Leave added.';

		$this->output($Return);
	}

	public function add_leave_history_validate()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$remarks = $this->input->post('remarks');

		$st_date = strtotime($start_date);
		$ed_date = strtotime($end_date);
		$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
		$no_of_days_annual_remain = 0;

		/* Server side PHP input validation */
		if ($this->input->post('leave_type') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_field');
		} else if ($this->input->post('start_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_start_date');
		} else if ($this->input->post('end_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_end_date');
		} else if ($st_date > $ed_date) {
			$Return['error'] = $this->lang->line('xin_error_start_end_date');
		} else if ($this->input->post('company_id') === '') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if ($this->input->post('employee_id') === '') {
			$Return['error'] = $this->lang->line('xin_error_employee_id');
		} else if ($this->input->post('reason') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
		}

		$datetime1 = new DateTime($this->input->post('start_date'));
		$datetime2 = new DateTime($this->input->post('end_date'));
		$interval = $datetime1->diff($datetime2);
		$no_of_days = $interval->format('%a') + 1;

		if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
			$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$date = date('Y-m-d');
		$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));

		//condition for Haj leave
		if ($this->input->post('leave_type') == 8) {
			if ($joining_date[0]->ethnicity_type != 2) {
				$Return['error'] = "Only Muslim Can Apply for this leave";
			}
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
	}
    
    public function add_leave_history()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		
		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$remarks = $this->input->post('remarks');

		$st_date = strtotime($start_date);
		$ed_date = strtotime($end_date);
		$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
		$no_of_days_annual_remain = 0;

		/* Server side PHP input validation */
		if ($this->input->post('leave_type') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_field');
		} else if ($this->input->post('start_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_start_date');
		} else if ($this->input->post('end_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_end_date');
		} else if ($st_date > $ed_date) {
			$Return['error'] = $this->lang->line('xin_error_start_end_date');
		} else if ($this->input->post('company_id') === '') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if ($this->input->post('employee_id') === '') {
			$Return['error'] = $this->lang->line('xin_error_employee_id');
		} else if ($this->input->post('reason') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
		}

		$datetime1 = new DateTime($this->input->post('start_date'));
		$datetime2 = new DateTime($this->input->post('end_date'));
		$interval = $datetime1->diff($datetime2);
		$no_of_days = $interval->format('%a') + 1;

		if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
			$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$date = date('Y-m-d');
		$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));

		//condition for Haj leave
		if ($this->input->post('leave_type') == 8) {
			if ($joining_date[0]->ethnicity_type != 2) {
				$Return['error'] = "Only Muslim Can Apply for this leave";
			}
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		if ($this->input->post('leave_half_day') != 1) {
			$leave_half_day_opt = 0;
		} else {
			$leave_half_day_opt = $this->input->post('leave_half_day');
		}

		if ($this->input->post('start_date') == $this->input->post('end_date')) {
			$no_of_days = 1;
		} else {
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);

			$no_of_days = $interval->format('%a') + 1;
		}

		$data = array(
			'employee_id' => $this->input->post('employee_id'),
			'company_id' => $this->input->post('company_id'),
			'leave_type_id' => $this->input->post('leave_type'),
			'from_date' => $this->input->post('start_date'),
			'to_date' => $this->input->post('end_date'),
			'applied_on' => date('Y-m-d h:i:s'),
			'reason' => $this->input->post('reason'),
			'remarks' => $qt_remarks,
			'leave_attachment' => '',
			'status' => '2',
			'is_notify' => '1',
			'is_half_day' => $leave_half_day_opt,
			'created_at' => $this->input->post('start_date'),
			'days' => $no_of_days,
			'history' => 1
		);
		$result = $this->Timesheet_model->add_leave_history_record($data);
		$Return['result'] = 'Leave added.';
        $Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
	}

	public function leaves_history_added($employee_id)
	{
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$this->db->where('employee_id', $employee_id);
		$leave_histories = $this->db->get('xin_employee_leave_applications_history');

		$data = array();

		foreach ($leave_histories->result() as $item) {
			$this->db->where('leave_type_id', $item->leave_type_id);
			$leave_type = $this->db->get('xin_leave_type')->row();

			$data[] = array(
				
				date('d-m-Y', strtotime($item->from_date)),
				date('d-m-Y', strtotime($item->to_date)),
				$leave_type->type_name,
				$item->days,
				$item->created_at,
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-history-modal-data" data-field_id="' . $item->leave_id . '"
				data-field_id="' . $item->leave_id . '" data-employee_id="' . $item->employee_id . '" data-leave_type_id="' . $item->leave_type_id . '" data-from_date="' . $item->from_date . '" data-to_date="' . $item->to_date . '"
				data-leave_half_day="' . $item->is_half_day . '" data-reason="' . $item->reason . '" data-remark="' . $item->remarks . '" data-field_type="leavehistory">
		        <i class="fas fa-pencil-alt"></i>
		        </button>
		        </span>
	            
	            <span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
                <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete_leave_history_btn" data-toggle="modal" data-target=".delete-leave-history-modal" data-record-id="' . $item->leave_id . '">
                <span class="fas fa-trash-restore"></span>
                </button>
                </span>',
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $leave_histories->num_rows(),
			"recordsFiltered" => $leave_histories->num_rows(),
			"data" => $data
		);

		$this->output($output);
	}
	
	public function dialog_leavehistory(){
	    $session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_details', $data);
		} else {

			redirect('admin/');
		}
	}
	
	public function edit_leave_history_validate(){
	    
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$start_date = $this->input->post('start_date');
    		$end_date = $this->input->post('end_date');
    		$remarks = $this->input->post('remarks');
    
    		$st_date = strtotime($start_date);
    		$ed_date = strtotime($end_date);
    		$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
    		$no_of_days_annual_remain = 0;

			if ($this->input->post('leave_type') === '') {
    			$Return['error'] = $this->lang->line('xin_error_leave_type_field');
    		} else if ($this->input->post('start_date') === '') {
    			$Return['error'] = $this->lang->line('xin_error_start_date');
    		} else if ($this->input->post('end_date') === '') {
    			$Return['error'] = $this->lang->line('xin_error_end_date');
    		} else if ($st_date > $ed_date) {
    			$Return['error'] = $this->lang->line('xin_error_start_end_date');
    		} else if ($this->input->post('reason') === '') {
    			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
    		}
			
			$datetime1 = new DateTime($this->input->post('start_date'));
    		$datetime2 = new DateTime($this->input->post('end_date'));
    		$interval = $datetime1->diff($datetime2);
    		$no_of_days = $interval->format('%a') + 1;
    
    		if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
    			$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
    		}

			if ($Return['error'] != '') {

				$this->output($Return);
			}
			
			$date = date('Y-m-d');
    		$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));
    
    		//condition for Haj leave
    		if ($this->input->post('leave_type') == 8) {
    			if ($joining_date[0]->ethnicity_type != 2) {
    				$Return['error'] = "Only Muslim Can Apply for this leave";
    			}
    		}
    
    		if ($Return['error'] != '') {
    			$this->output($Return);
    		}
    		
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
    		$this->output($Return);
		
			exit;
	}
	
	public function edit_leave_history(){
	    
	    if ($this->input->post('type') == 'edit_leave_history') {

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			
			$start_date = $this->input->post('start_date');
    		$end_date = $this->input->post('end_date');
    		$remarks = $this->input->post('remarks');
    
    		$st_date = strtotime($start_date);
    		$ed_date = strtotime($end_date);
    		$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
    		$no_of_days_annual_remain = 0;

			if ($this->input->post('leave_type') === '') {
    			$Return['error'] = $this->lang->line('xin_error_leave_type_field');
    		} else if ($this->input->post('start_date') === '') {
    			$Return['error'] = $this->lang->line('xin_error_start_date');
    		} else if ($this->input->post('end_date') === '') {
    			$Return['error'] = $this->lang->line('xin_error_end_date');
    		} else if ($st_date > $ed_date) {
    			$Return['error'] = $this->lang->line('xin_error_start_end_date');
    		} else if ($this->input->post('reason') === '') {
    			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
    		}
			
			$datetime1 = new DateTime($this->input->post('start_date'));
    		$datetime2 = new DateTime($this->input->post('end_date'));
    		$interval = $datetime1->diff($datetime2);
    		$no_of_days = $interval->format('%a') + 1;
    
    		if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
    			$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
    		}

			if ($Return['error'] != '') {

				$this->output($Return);
			}
			
			
			
			$date = date('Y-m-d');
    		$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));
    
    		//condition for Haj leave
    		if ($this->input->post('leave_type') == 8) {
    			if ($joining_date[0]->ethnicity_type != 2) {
    				$Return['error'] = "Only Muslim Can Apply for this leave";
    			}
    		}
    
    		if ($Return['error'] != '') {
    			$this->output($Return);
    		}
    
    		if ($this->input->post('leave_half_day') != 1) {
    			$leave_half_day_opt = 0;
    		} else {
    			$leave_half_day_opt = $this->input->post('leave_half_day');
    		}
    
    		if ($this->input->post('start_date') == $this->input->post('end_date')) {
    			$no_of_days = 1;
    		} else {
    			$datetime1 = new DateTime($this->input->post('start_date'));
    			$datetime2 = new DateTime($this->input->post('end_date'));
    			$interval = $datetime1->diff($datetime2);
    
    			$no_of_days = $interval->format('%a') + 1;
    		}
    		$leave_history_id =  $this->input->post('id');
    
    		$data = array(
    			'leave_type_id' => $this->input->post('leave_type'),
    			'from_date' => $this->input->post('start_date'),
    			'to_date' => $this->input->post('end_date'),
    			'reason' => $this->input->post('reason'),
    			'remarks' => $qt_remarks,
    			'is_half_day' => $leave_half_day_opt,
    			'days' => $no_of_days,
    		);
    		$result = $this->Timesheet_model->edit_leave_history_record($data,$leave_history_id);
    		$Return['result'] = 'Leave History Updated.';
            $Return['csrf_hash'] = $this->security->get_csrf_hash();
    		$this->output($Return);
		
			exit;
		}
	    
	}


	public function leaves_types_assigned_options($employee_id, $created_at)
	{
		$year = date('Y', strtotime($created_at));

		$this->db->where('employee_id', $employee_id);
		$this->db->like('created_at', $year, 'after');
		$assigned_leaves = $this->db->get('employee_leave');

		$options = '<option value="">-- Select --</option>';

		foreach ($assigned_leaves->result() as $item) {
			$this->db->where('leave_type_id', $item->leave_type);
			$leave_info = $this->db->get('xin_leave_type')->row();

			if (!empty($leave_info))
				$options .= '<option value="' . $leave_info->leave_type_id . '">' . $leave_info->type_name . '</option>';
		}

		echo $options;
		exit;
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	public function leaves_history_added_view($employee_id)
	{
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$this->db->where('employee_id', $employee_id);
		$leave_histories = $this->db->get('xin_employee_leave_applications_history');

		$data = array();

		foreach ($leave_histories->result() as $item) {
			$this->db->where('leave_type_id', $item->leave_type_id);
			$leave_type = $this->db->get('xin_leave_type')->row();

			$data[] = array(
			    date('d-m-Y', strtotime($item->from_date)),
				date('d-m-Y', strtotime($item->to_date)),
				$leave_type->type_name,
				$item->days,
				$item->created_at,
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '">
				<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-history-modal-data" data-field_id="' . $item->leave_id . '"
				data-field_id="' . $item->leave_id . '" data-employee_id="' . $item->employee_id . '" data-leave_type_id="' . $item->leave_type_id . '" data-from_date="' . $item->from_date . '" data-to_date="' . $item->to_date . '"
				data-leave_half_day="' . $item->is_half_day . '" data-reason="' . $item->reason . '" data-remark="' . $item->remarks . '" data-field_type="leavehistory_view">
		        <i class="fa fa-eye"></i>
		        </button>
		        </span>
	            
	            <span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
                <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete_leave_history_btn" data-toggle="modal" data-target=".delete-leave-history-modal" data-record-id="' . $item->leave_id . '">
                <span class="fas fa-trash-restore"></span>
                </button>
                </span>',
				
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $leave_histories->num_rows(),
			"recordsFiltered" => $leave_histories->num_rows(),
			"data" => $data
		);

		$this->output($output);
	}
	public function dialog_leavehistory_view(){
	    $session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();
		if (!empty($session)) {
			$this->load->view('admin/employees/dialog_employee_view_details', $data);
		} else {

			redirect('admin/');
		}
	}
}
