<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */

if (!defined('BASEPATH')) exit('No direct script access allowed');


class Import extends MY_Controller

{


	/*Function to set JSON output*/

	public function output($Return = array())
	{

		/*Set response header*/

		header("Access-Control-Allow-Origin: *");

		header("Content-Type: application/json; charset=UTF-8");

		/*Final JSON response*/

		exit(json_encode($Return));
	}


	public function __construct()

	{

		parent::__construct();

		//load the models

		$this->load->library('spreadsheet');

		//	$this->load->library('PhpSpreadsheet/IOFactory');

		$this->load->model("Employees_model");

		$this->load->model("Xin_model");

		$this->load->model("Department_model");

		$this->load->model("Designation_model");

		$this->load->model("Roles_model");

		$this->load->model("Location_model");

		$this->load->model("Company_model");

		$this->load->model("Timesheet_model");

		$this->load->model("Custom_fields_model");

		$this->load->model("Assets_model");

		$this->load->model("Training_model");

		$this->load->model("Trainers_model");

		$this->load->library("pagination");

		$this->load->model("Awards_model");

		$this->load->model("Travel_model");

		$this->load->model("Tickets_model");

		$this->load->model("Transfers_model");

		$this->load->model("Promotion_model");

		$this->load->model("Complaints_model");

		$this->load->model("Warning_model");

		$this->load->model("Project_model");

		$this->load->model("Payroll_model");

		$this->load->model("Events_model");

		$this->load->model("Meetings_model");

		$this->load->model('Exin_model');

		$this->load->model('Misc_model');

		$this->load->model('Office_shift_custom_model');

		$this->load->library('Pdf');

		$this->load->helper('string');
	}


	// import

	public function index()
	{


		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_hr_imports') . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = $this->lang->line('xin_hr_imports');

		$data['path_url'] = 'hrsale_import';

		$data['all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('428', $role_resources_ids)) {

			$data['subview'] = $this->load->view("admin/layout/hrsale_import", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}


	public function employee_import()
	{


		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = $this->lang->line('xin_hr_imports') . ' Employees' . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = $this->lang->line('xin_hr_imports') . ' Employees';

		$data['path_url'] = 'hrsale_import';

		$data['all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('428', $role_resources_ids)) {

			$data['subview'] = $this->load->view("admin/layout/hrsale_import_employee", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');

		}

	}

	public function attendence_import()
	{


		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = $this->lang->line('xin_hr_imports') . ' Attendance' . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = $this->lang->line('xin_hr_imports') . ' Attendance';

		$data['path_url'] = 'hrsale_import';

		$data['all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('429', $role_resources_ids)) {

			$data['subview'] = $this->load->view("admin/layout/hrsale_import_attendence", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');

		}

	}

	public function leads_import()
	{


		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = $this->lang->line('xin_hr_imports') . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Import Leads";

		$data['path_url'] = 'hrsale_import';

		$data['all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('505', $role_resources_ids)) {

			$data['subview'] = $this->load->view("admin/layout/hrsale_import_leads", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');

		}

	}


	// Validate and add info in database

	public function import_employees()
	{

		error_reporting(0);
		if (isset($_SESSION['failed']))
			unset($_SESSION['failed']);

		$_SESSION['failed'] = array();
		if ($this->input->post('is_ajax') == '3') {
			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$inputFileName = $_FILES["file"]["tmp_name"];

			$inputFileType = $this->spreadsheet->identify($inputFileName);

			$reader = $this->spreadsheet->createReader($inputFileType);

			$spreadsheet = $reader->load($inputFileName);
			// echo "<pre>";print_r($spreadsheet);exit();

			// $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
			$sheetData = $spreadsheet->getActiveSheet()->toArray();
			$employees = array();

			$keys = $sheetData[0];
			$keys = array_filter($keys, 'strlen');
			$keys[] = 'Reason';
			$_SESSION['failed'][] = $keys;
			// $arr = array_values($keys);
			//count(($keys)-1) = $keys;
			unset($sheetData[0]);

			$i = 0;
			foreach ($sheetData as $data) {
				if (empty($data[0])) break;
				$k = 0;
				foreach ($data as $d) {
					if (!isset($keys[$k])) break;
					$employees[$i][$keys[$k]] = $d;
					$k++;
				}
				$i++;
			}
			if (empty($employees)) {
				$Return['error'] = $this->lang->line('xin_error_not_employee_import');
				$this->output($Return);
				exit;
			}
			foreach ($employees as $employee) {
				$error = '';
				$email_validation = $this->Employees_model->email_validation($employee['Email']);
				if ($email_validation == 1) {
					$email = $employee['Email'];
					$error = "Email .'$email.' is Already Exist. ";
					$arr = array_values($employee);
					$arr[count($keys) - 1] = $error;
					$_SESSION['failed'][] = $arr;
					continue;
				}
				if (!filter_var($employee['Email'], FILTER_VALIDATE_EMAIL)) {
					$email = $employee['Email'];
					$error = "Invalid email formate. $email";
					$arr = array_values($employee);
					$arr[count($keys) - 1] = $error;
					$_SESSION['failed'][] = $arr;
					continue;
				}
				//Employee id
				$employee_id = $this->Employees_model->employee_id($employee['Employee ID']);
				if ($employee_id == 1) {
					$emp_id = $employee['Employee ID'];
					$error = "Employee Id(.'$emp_id'.) Already exit. ";
					$arr = array_values($employee);
					$arr[count($keys) - 1] = $error;
					$_SESSION['failed'][] = $arr;
					continue;
				}
				//Employee Code
				/*$employee_code=$this->Employees_model->employee_code($employee['Employee Code']);
						if ($employee_code == 1) {
						  $code=$employee['Employee Code'];
						  $error = "Employee Code $code Already exit. ";
						  $arr = array_values($employee);
						  $arr[count($keys)-1] = $error;
						  $_SESSION['failed'][] = $arr;
						   continue;
						}*/
				//mobile
				$mob_validation = $this->Employees_model->mobile_validation($employee['Contact Number']);
				if ($mob_validation == 1) {
					$mob = $employee['Contact Number'];
					$error = "Mobile $mob Already exit. ";
					$arr = array_values($employee);
					$arr[count($keys) - 1] = $error;
					$_SESSION['failed'][] = $arr;
					continue;
				}
				$date_check = DateTime::createFromFormat('Y-m-d', trim($employee['Date of Joining']));
				if (!$date_check) {
					$error = 'Incorrect Date format<br>Eg: ' . date('Y-m-d', strtotime($employee['Date of Joining']));
					$arr = array_values($employee);
					$arr[count($keys) - 1] = $error;
					$_SESSION['failed'][] = $arr;
					continue;
				}
				$options = array('cost' => 12);

				$password_hash = password_hash($employee['Password'], PASSWORD_BCRYPT, $options);

				$employee_data['first_name'] = $employee['First Name'];
				$employee_data['middle_name'] = $employee['Middle Name'];
				$employee_data['last_name'] = $employee['Last Name'];
				$employee_data['username'] = $employee['Username'];
				$employee_data['email'] = $employee['Email'];
				$employee_data['password'] = $password_hash;
				$employee_data['employee_id'] = $employee['Employee ID'];
				$employee_data['employee_code'] = $employee['Employee Code'];
				$employee_data['date_of_joining'] = $employee['Date of Joining'];
				$employee_data['gender'] = $employee['Gender'];
				$employee_data['date_of_birth'] = $employee['Date of Birth'];
				$employee_data['contact_no'] = $employee['Contact Number'];
				$employee_data['company_id'] = $employee['Company ID'];
				$employee_data['location_id'] = $employee['Location ID'];
				$employee_data['department_id'] = $employee['Departmend ID'];
				$employee_data['designation_id'] = $employee['Designation ID'];
				$employee_data['user_role_id'] = $employee['Role ID'];
				$employee_data['marital_status'] = $employee['Marital Status'];
				$employee_data['is_active'] = $employee['Status'];
				$employee_data['office_shift_id'] = $employee['Office Shift'];
				$employee_data['leave_categories'] = $employee['Leave Category'];

				$employee_data['serial_no'] = $employee['Serial No'];
				$employee_data['company_code'] = $employee['Company Code'];
				$employee_data['dept_code'] = $employee['Department Code'];
				$employee_data['designation_code'] = $employee['Designation Code'];


				$input = $employee_data['date_of_joining'];
				$d1 = new DateTime($input);
				$date1 = date('Y-m-d');
				$d2 = new DateTime($date1);

				$diff = $d2->diff($d1);

				$save = $diff->y;

				//echo$explode_date=explode('-',2019-03-12);

				$time = strtotime($input);
				$day = date('d', $time);
				$month = date('m', $time);
				$year = date('Y', $time);
				$new = $year + $save;
				$update_date1 = $new . '-' . $month . '-' . $day;


				$employee_data['leave_updated_date'] = $update_date1;
				$employee_data['leave_salary_calculated_date'] = $employee['Leave Salary Calculated Date'];
				// print_r($employee_data['leave_updated_date']);
				$employee_data['created_at'] = date('Y-m-d h:i:s');
				$last_insert_id = $this->Employees_model->add($employee_data);

				$get_leaves = $this->Employees_model->employee_get_leave($last_insert_id);
				// print_r($leave=explode(',', $get_leaves[0]->leave_categories));
				$leave = explode(',', $get_leaves[0]->leave_categories);
				foreach ($leave as $val) {
					// //print_r($val);
					//foreach($val as $data){

					if ($val == 0) {

						continue;
					}

					//print_r($data);exit;

					$leave_type = $this->Employees_model->get_leaves($val);

					//  print_r($leave_type[0]->days_per_year);exit;

					$data_leave = array(

						'employee_id' => $last_insert_id,

						'leave_type' => $val,

						'leave_count' => $leave_type[0]->days_per_year,

						'created_at' => $update_date1

					);

					$re_le = $this->Employees_model->add_leaves($data_leave);
					//	}

				}


				$immigration_data['document_type_id'] = $employee['Document Type'];
				$immigration_data['document_number'] = $employee['Document Number'];
				// $immigration_data['document_file'] = $employee['Document File'];
				$immigration_data['issue_date'] = $employee['Issue Date'];
				$immigration_data['expiry_date'] = $employee['Expiry Date'];
				$immigration_data['country_id'] = $employee['Country ID'];
				$immigration_data['eligible_review_date'] = $employee['Eligible Review Date'];
				$immigration_data['employee_id'] = $last_insert_id;
				$immigration_data['created_at'] = date('Y-m-d h:i:s');
				$iimmigration = $this->Employees_model->immigration_info_add($immigration_data);

				$contact_data['relation'] = $employee['Relation'];
				$contact_data['work_email'] = $employee['Work Email'];
				$contact_data['is_primary'] = $employee['Is Primary?'];
				$contact_data['is_dependent'] = $employee['Is Dependent?'];
				$contact_data['personal_email'] = $employee['Personal Email'];
				$contact_data['contact_name'] = $employee['Contact Name'];
				$contact_data['address_1'] = $employee['Address 1'];
				$contact_data['work_phone'] = $employee['Work Phone'];
				$contact_data['work_phone_extension'] = $employee['Work Phone Extension'];
				$contact_data['address_2'] = $employee['Address 2'];
				$contact_data['mobile_phone'] = $employee['Mobile Number'];
				$contact_data['city'] = $employee['City'];
				$contact_data['state'] = $employee['State'];
				$contact_data['zipcode'] = $employee['Zip Code'];
				$contact_data['home_phone'] = $employee['Home Phone'];
				$contact_data['country'] = $employee['CountryID'];
				$contact_data['employee_id'] = $last_insert_id;
				$contact_data['created_at'] = date('Y-m-d h:i:s');
				$icontact = $this->Employees_model->contact_info_add($contact_data);

				$document_data['document_type_id'] = $employee['DocumentType'];
				if ($employee['Date of Expiry'] == '') {
					$document_data['date_of_expiry'] = '0000-00-00';
				} else {
					$document_data['date_of_expiry'] = $employee['Date of Expiry'];
				}
				//$document_data['date_of_expiry'] = $employee['Date of Expiry'];//exit;
				$document_data['title'] = $employee['DocumentTitle'];
				$document_data['notification_email'] = $employee['Notification Email'];
				$document_data['description'] = $employee['Description'];
				//$document_data['document_file'] = $employee['Document File'];
				if ($employee['Send notification email when expired?'] == '') {
					$document_data['is_alert'] = '--';
				} else {
					$document_data['is_alert'] = $employee['Send notification email when expired?'];
				}
				$document_data['employee_id'] = $last_insert_id;
				$document_data['created_at'] = date('Y-m-d h:i:s');
				$idocument = $this->Employees_model->document_info_add($document_data);

				$qualificaton_data['name'] = $employee['School/University'];
				$qualificaton_data['education_level_id'] = $employee['Educational Level ID'];
				$qualificaton_data['from_year'] = $employee['Year period from'];
				$qualificaton_data['to_year'] = $employee['Year period to'];
				$qualificaton_data['skill_id'] = $employee['Professional Course ID'];
				$qualificaton_data['language_id'] = $employee['Language ID'];
				$qualificaton_data['description'] = $employee['Descriptions'];
				$qualificaton_data['employee_id'] = $last_insert_id;
				$qualificaton_data['created_at'] = date('Y-m-d h:i:s');
				$iqualificaton = $this->Employees_model->qualification_info_add($qualificaton_data);

				$experience_data['company_name'] = $employee['Company Name'];
				$experience_data['post'] = $employee['Post'];
				$experience_data['from_date'] = $employee['Time period from'];
				$experience_data['to_date'] = $employee['Time period to'];
				$experience_data['description'] = $employee['Qualification Description'];
				$experience_data['employee_id'] = $last_insert_id;
				$experience_data['created_at'] = date('Y-m-d h:i:s');
				$iexperience = $this->Employees_model->work_experience_info_add($experience_data);

				$bank_account_data['account_title'] = $employee['Account Title'];
				$bank_account_data['account_number'] = $employee['Account Number'];
				$bank_account_data['bank_name'] = $employee['Bank Name'];
				$bank_account_data['bank_code'] = $employee['Bank Code'];
				$bank_account_data['bank_branch'] = $employee['Bank Branch'];
				$bank_account_data['employee_id'] = $last_insert_id;
				$bank_account_data['created_at'] = date('Y-m-d h:i:s');
				$ibank_account = $this->Employees_model->bank_account_info_add($bank_account_data);
			}
			$Return['failed'] = $_SESSION['failed'];
			$count = count($_SESSION['failed']) - 1;
			$Return['result'] = 'Employee detailes import Successfully.... <br>' . 'The Failed Entries - ' . $count;
		}

		//echo "<pre>";print_r($Return);echo "</pre>";
		$this->output($Return);
		exit;
	}


	// Validate and add info in database

	public function import_attendance()
	{
		error_reporting(0);

		if (isset($_SESSION['value']))
			unset($_SESSION['value']);

		$_SESSION['value'] = array();

		if ($this->input->post('is_ajax') == '3') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			//validate whether uploaded file is a csv file

			$inputFileName = $_FILES["file"]["tmp_name"];

			$inputFileType = $this->spreadsheet->identify($inputFileName);

			$reader = $this->spreadsheet->createReader($inputFileType);

			$spreadsheet = $reader->load($inputFileName);
			// echo "<pre>";print_r($spreadsheet);exit();

			// $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);
			$sheetData = $spreadsheet->getActiveSheet()->toArray();

			$products = array();

			$keys = $sheetData[0];
			$keys = array_filter($keys, 'strlen');
			$keys[] = 'Reason';
			$_SESSION['value'][] = $keys;

			unset($sheetData[0]);

			$i = 0;
			foreach ($sheetData as $data) {
				if (empty($data[0])) break;
				$k = 0;
				foreach ($data as $d) {
					if (!isset($keys[$k])) break;
					$products[$i][$keys[$k]] = $d;
					$k++;
				}
				$i++;
			}

			if (empty($products)) {
				// $this->session->set_flashdata('error',$this->lang->line('bulk_data'));
				$Return['error'] = $this->lang->line('xin_error_not_attendance_import');
			}

			foreach ($products as $product) {
				$error = '';
				$count = '';

				//$user_id= $product['AC-No.'];
				$user_id = $product['Employee ID'];
				$attendance_date = $product['Attendance Date'];
				$clock_in = $product['Clock In Time'];
				$clock_out = $product['Clock Out Time'];
				$clockin_date = $product['Clock In Date'];
				$clockout_date = $product['Clock Out Date'];
				$clkin_parse = date_parse_from_format('d/m/Y', trim($clockin_date));

				$clock_in = trim($clock_in);
				$clock_out = trim($clock_out);
				if ($clock_in == '' || $clock_out == '') {
					continue;
				}

				if ($clkin_parse['warning_count'] > 0) {
					$error = 'Invalid Date - ' . $clockin_date;
					$arr = array_values($product);
					$arr[count($keys) - 1] = $error;
					$_SESSION['value'][] = $arr;

					continue;
				}
				//checking leave dates and preventing them from being inserted to mark them as 'leave'
				$attendance_date_parse = date_parse_from_format('d/m/Y', trim($attendance_date));

				$year = $attendance_date_parse['year'];
				$month = str_pad($attendance_date_parse['month'], 2, "0", STR_PAD_LEFT);
				$day = str_pad($attendance_date_parse['day'], 2, "0", STR_PAD_LEFT);
				$iso_attendance_date = "$year-$month-$day";

				$user_info = $this->Employees_model->read_user_by_employee_id($user_id);
				// print_r($user_info);
				if ($user_info) {
					$leave_records = $this->db->get_where('xin_leave_applications', array('employee_id =' => $user_info[0]->user_id))->result();
					// print_r($leave_records);exit;
					$leave_flag = false;
					foreach ($leave_records as $l) {
						$str_from_date = strtotime($l->from_date);
						$str_attendance_date = strtotime($iso_attendance_date);
						$str_to_date = strtotime($l->to_date);

						//  if(strtotime($l->from_date))
						if ($str_from_date <= $str_attendance_date && $str_to_date >= $str_attendance_date) {
							$leave_flag = true;
							break;
						}
					}
					if ($leave_flag == true) {
						$error = 'Employee ' . $user_id . ' is on leave for the Date - ' . $attendance_date;
						$arr = array_values($product);
						$arr[count($keys) - 1] = $error;
						$_SESSION['value'][] = $arr;

						continue;
					}
				}
				$year = $clkin_parse['year'];
				$month = str_pad($clkin_parse['month'], 2, "0", STR_PAD_LEFT);
				$day = str_pad($clkin_parse['day'], 2, "0", STR_PAD_LEFT);
				$clock_in_date = "$year-$month-$day";

				$clkout_parse = date_parse_from_format('d/m/Y', trim($clockout_date));

				if ($clkout_parse['warning_count'] > 0) {
					$error = 'Invalid Date - ' . $clockin_date;
					$arr = array_values($product);
					$arr[count($keys) - 1] = $error;
					$_SESSION['value'][] = $arr;

					continue;
				}


				$emp_lastdate = $this->Employees_model->get_work_lastdate($user_id);

				if ($emp_lastdate != "" && $iso_attendance_date > $emp_lastdate) {
					$error = 'Employee already left the company on ' . $emp_lastdate;
					$arr = array_values($product);
					$arr[count($keys) - 1] = $error;
					$_SESSION['value'][] = $arr;

					continue;

				}

				$emp_firstdate = $this->Employees_model->get_work_firstdate($user_id);

				if ($iso_attendance_date < $emp_firstdate) {
					$error = 'Employee joining date is on ' . $emp_firstdate;
					$arr = array_values($product);
					$arr[count($keys) - 1] = $error;
					$_SESSION['value'][] = $arr;

					continue;

				}

				$user = $this->Employees_model->read_user_by_employee_id($user_id);
				$user_info = $user;

				if ($clock_in == '' || $clock_out == '') {
					$date_parse = date_parse_from_format('d/m/Y', trim($attendance_date));
					$year = $date_parse['year'];
					$month = str_pad($date_parse['month'], 2, "0", STR_PAD_LEFT);
					$day = str_pad($date_parse['day'], 2, "0", STR_PAD_LEFT);
					$date_convert = "$year-$month-$day";

					if ($clock_in == '') {
						$clock_in2 = '';
					} else {
						$clock_in2 = $date_convert . ' ' . $clock_in;
					}

					if ($clock_out == '') {
						$clock_out2 = '';
					} else {
						$clock_out2 = $date_convert . ' ' . $clock_out;
					}

					$this->Employees_model->add_employee_attendance(array(
						'employee_id' => $user_info[0]->user_id,
						'attendance_date' => $date_convert,
						'clock_in' => $clock_in2,
						'clock_in_time' => $clock_in,
						'clock_out' => $clock_out2,
						'clock_out_time' => $clock_out,
						'time_late' => $clock_in2,
						'total_work' => '',
						'early_leaving' => $clock_out2,
						'overtime' => $clock_out2,
						'attendance_status' => 'Present',
						'clock_in_out' => '0',
					));
					continue;
				}

				$year = $clkout_parse['year'];
				$month = str_pad($clkout_parse['month'], 2, "0", STR_PAD_LEFT);
				$day = str_pad($clkout_parse['day'], 2, "0", STR_PAD_LEFT);
				$clock_out_date = "$year-$month-$day";

				$clockin = $clock_in_date . ' ' . $clock_in;
				$clockout = $clock_out_date . ' ' . $clock_out;

				/*$timetable=$product['Timetable'];
						if($timetable==''){
							$timetable='Null';
						}else{
							$timetable;
						}
						$on_duty=$product['On duty'];
						if($on_duty==''){
							$on_duty='Null';
						}else{
							$on_duty;
						}
						$off_duty=$product['Off duty'];
						if($off_duty==''){
							$off_duty='Null';
						}else{
							$off_duty;
						}
						$late=$product['Late'];
						if($late==''){
							$late='0:00';
						}else{
							$late;
						}
						$absent=$product['Absent'];
						if($absent==''){
							$absent='NULL';
						}else{
							$absent;
						}

						$attendance_date = $product['Date'];

						$clock_in = $product['Clock In'];

						$clock_out = $product['Clock Out'];*/

				if ($clock_in != '' && $clock_out != '') {
					$total_work_cin = new DateTime($clockin);
					$total_work_cout = new DateTime($clockout);
					$interval_cin = $total_work_cout->diff($total_work_cin);
					$hours_in = $interval_cin->format('%h');
					$minutes_in = $interval_cin->format('%i');
					$total_work = $hours_in . ":" . $minutes_in;
					$work_mins_to_hour = round($minutes_in / 60, 2);
					$work_by_hours = $hours_in + $work_mins_to_hour;
				} else {
					$total_work = '';
				}

				if ($clock_in == '' && $clock_out == '') {
					$date_parse = date_parse_from_format('d/m/Y', trim($attendance_date));
					$year = $date_parse['year'];
					$month = str_pad($date_parse['month'], 2, "0", STR_PAD_LEFT);
					$day = str_pad($date_parse['day'], 2, "0", STR_PAD_LEFT);
					$date_convert = "$year-$month-$day";

					if ($clock_in == '') {
						$clock_in2 = '';
					} else {
						$clock_in2 = $date_convert . ' ' . $clock_in;
					}

					if ($clock_out == '') {
						$clock_out2 = '';
					} else {
						$clock_out2 = $date_convert . ' ' . $clock_out;
					}

					$new_data['employee_id'] = $user[0]->user_id;

					$new_data['attendance_date'] = $date_convert;

					$new_data['clock_in'] = $clock_in2;

					$new_data['clock_in_time'] = '00:00';

					$new_data['clock_out'] = $clock_out2;

					$new_data['clock_out_time'] = '00:00';

					$new_data['time_late'] = $clock_in2;

					$new_data['total_work'] = $total_work;

					$new_data['early_leaving'] = $clock_out2;

					$new_data['overtime'] = $clock_out2;

					$new_data['attendance_status'] = 'Present';

					$new_data['clock_in_out'] = '0';

					//$new_data['timetable']=$timetable;

					//$new_data['on_duty']=$on_duty;

					//$new_data['off_duty']=$off_duty;

					//$new_data['late']=$late;

					//$new_data['absent']=$absent;

					//print_r($product_data);

					$result = $this->Employees_model->new_employee_attendance($new_data);
				} else {
					$date_parse = date_parse_from_format('d/m/Y', trim($attendance_date));

					if ($date_parse['warning_count'] > 0) {
						$error = 'Invalid Date - ' . $attendance_date;
						$arr = array_values($product);
						$arr[count($keys) - 1] = $error;
						$_SESSION['value'][] = $arr;

						continue;
					}

					$year = $date_parse['year'];
					$month = str_pad($date_parse['month'], 2, "0", STR_PAD_LEFT);
					$day = str_pad($date_parse['day'], 2, "0", STR_PAD_LEFT);
					$date = "$year-$month-$day";
					$date_convert = $date;
					$emp_id = $this->Employees_model->employee_exist($user_id);

					if ($emp_id != 1) {
						$error = "Employee ID .'$user_id.' Not  Exist. ";
						$arr = array_values($product);
						$arr[count($keys) - 1] = $error;

						$_SESSION['value'][] = $arr;
						continue;
					}

					/* $clock_in3  = $date.' '.$clock_in;
							  $clock_out3 = $date.' '.$clock_out;*/

					$cmp_id = $this->Employees_model->get_employee_details($user[0]->user_id);
					if ($cmp_id[0]->office_shift_id == 0) {
						$late_by_hours = 0;
						$late_deduct = 0;
					} else {
						$late_allowed = $this->Employees_model->get_lateallowed_foremployee($cmp_id[0]->office_shift_id);
						$on_duty3 = $date . ' ' . $late_allowed[0]->late_allowed_till;
					}

					$product_data['employee_id'] = $user[0]->user_id;

					$product_data['attendance_date'] = $date;

					//$product_data['clock_in'] = $clock_in3;

					//$product_data['clock_out'] = $clock_out3;

					$product_data['clock_in'] = $clockin;

					$product_data['clock_in_time'] = $clock_in;

					$product_data['clock_out'] = $clockout;

					$product_data['clock_out_time'] = $clock_out;

					$product_data['time_late'] = $clockin;

					$product_data['total_work'] = $total_work;

					$product_data['early_leaving'] = $clockout;

					$product_data['overtime'] = $clockout;

					$product_data['attendance_status'] = 'Present';

					$product_data['clock_in_out'] = '0';

					//$product_data['timetable']=$timetable;

					//$product_data['on_duty']=$on_duty;

					//$product_data['off_duty']=$off_duty;

					//$product_data['late']=$late;

					//$product_data['absent']=$absent;

					global $holiday_check;
					global $weekends;
					$overtime_consts = $this->Xin_model->get_all_overtime_constants();
					$weekend = $overtime_consts[0]->weekend;
					$holiday = $overtime_consts[0]->holiday;
					$workingday = $overtime_consts[0]->workingday;
					$timeshift_from = $overtime_consts[0]->timeshift_from;
					$timeshift_to = $overtime_consts[0]->timeshift_to;
					$timeshift_percent = $overtime_consts[0]->timeshift_percent;
					$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
					$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
					$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;

					$timeshiftfrom = $date . ' ' . $timeshift_from;
					$nextdate = date('Y-m-d', strtotime($date . " +1 days"));
					$timeshiftto = $nextdate . ' ' . $timeshift_to;

					$off_time = $date . ' ' . $evening_timeshift_from;
					$diff = strtotime($off_time) - strtotime($clockout);
					$timestamp = strtotime($date);
					$day = date('l', $timestamp);

					$comp_id = $user[0]->company_id;
					$holidays = $this->Employees_model->get_holidays($comp_id);

					if (isset($holidays)) {
						foreach ($holidays as $row) {
							$startDate = $row->start_date;
							$endDate = $row->end_date;

							if (($date >= $startDate) && ($date <= $endDate)) {
								$holiday_check = "yes";
							}
						}
					}

					if ($day === "Friday") {
						$ot = "yes";
						$basic_pay = $user[0]->basic_salary;
						$clk_out = new DateTime($clockout);
						$clk_in = new DateTime($clockin);
						$interval = $clk_out->diff($clk_in);
						$hours_in = $interval->format('%h');
						$minutes_in = $interval->format('%i');
						$min_to_hour = $minutes_in / 60;
						$normalot_hours = 0;
						$weekendpercent = ($weekend * 100) / 100;
						$extra_ot_hours = $hours_in + $min_to_hour;
						$extraot_hours = round($extra_ot_hours, 2);
						$amount = (($basic_pay / 30) / 8) * $extraot_hours * $weekendpercent;
						$roundamount = round($amount, 3);
					} elseif ($holiday_check === "yes") {
						$ot = "yes";
						$basic_pay = $user[0]->basic_salary;
						$clk_out = new DateTime($clockout);
						$clk_in = new DateTime($clockin);
						$interval = $clk_out->diff($clk_in);
						$hours_in = $interval->format('%h');
						$minutes_in = $interval->format('%i');
						$min_to_hour = $minutes_in / 60;
						$normalot_hours = 0;
						$holidaypercent = ($holiday * 100) / 100;
						$extra_ot_hours = $hours_in + $min_to_hour;
						$extraot_hours = round($extra_ot_hours, 2);
						$amount = (($basic_pay / 30) / 8) * $extraot_hours * $holidaypercent;
						$roundamount = round($amount, 3);
						$holiday_check = "no";
					} elseif ($diff < 0 && $day !== "Friday" && $holiday_check !== "yes") {
						$ot = "yes";
						$basic_pay = $user[0]->basic_salary;
						$cutoff_time = $date . ' ' . $timeshift_from;
						$dayend_cutoff = $nextdate . ' ' . $timeshift_to;
						$diff_in_hrs = (strtotime($cutoff_time) - strtotime($clockout)) / 3600;
						$evening_cutoff_time = $date . ' ' . $evening_timeshift_to;

						$normalovertime = (strtotime($evening_timeshift_to) - strtotime($evening_timeshift_from)) / 3600;
						$extraovertime = (strtotime($timeshiftto) - strtotime($timeshiftfrom)) / 3600;

						if ($diff_in_hrs >= 0 && $diff_in_hrs <= $normalovertime) {
							$clk_out = new DateTime($clockout);
							$clk_in = new DateTime($clockin);
							$workedhours = (strtotime($off_time) - strtotime($clockin)) / 3600;

							if ($workedhours <= 0) {

								$interval = $clk_out->diff($clk_in);
								$hours_in = $interval->format('%h');
								$minutes_in = $interval->format('%i');
								$min_to_hour = $minutes_in / 60;
								$normal_ot_hours = $hours_in + $min_to_hour;
								$normalot_hours = round($normal_ot_hours, 2);
							} elseif ($workedhours > 0) {
								$interval = $clk_out->diff($clk_in);
								$hours_in = $interval->format('%h');
								$minutes_in = $interval->format('%i');
								$min_to_hour = $minutes_in / 60;
								$normal_ot_hours = $hours_in + $min_to_hour - $workedhours;
								$normalot_hours = round($normal_ot_hours, 2);
							}

							$workingdaypercent = ($workingday * 100) / 100;
							$extraot_hours = 0;
							$amount = (($basic_pay / 30) / 8) * $normalot_hours * $workingdaypercent;
							$roundamount = round($amount, 3);
						} elseif ($diff_in_hrs < 0) {
							$normalovertimehours = (strtotime($evening_cutoff_time) - strtotime($clockin)) / 3600;
							$diff_in_hrs = (strtotime($cutoff_time) - strtotime($clockout)) / 3600;

							$clk_out = new DateTime($clockout);
							$clk_in = new DateTime($clockin);
							$workedhours = (strtotime($off_time) - strtotime($clockin)) / 3600;

							if ($workedhours <= 0) {
								$interval = $clk_out->diff($clk_in);
								$hours_in = $interval->format('%h');
								$minutes_in = $interval->format('%i');
								$min_to_hour = $minutes_in / 60;
								$workingdaypercent = ($workingday * 100) / 100;
								$timeshiftpercent = ($timeshift_percent * 100) / 100;
								$extra_ot_hours = $hours_in + $min_to_hour;
								$difference_in_hrs = (strtotime($clockout) - strtotime($cutoff_time)) / 3600;

								if ($difference_in_hrs > $extraovertime) {
									$difference = $difference_in_hrs - $extraovertime;
									$extra_ot_hours = $extra_ot_hours - $difference;
								}
								if ($normalovertimehours > 0) {
									$normalot_hours = $normalovertimehours;
									$extra_ot_hours = $extra_ot_hours - $normalot_hours;
								} else {
									$normalot_hours = 0;
								}
							} elseif ($workedhours > 0) {
								$interval = $clk_out->diff($clk_in);
								$hours_in = $interval->format('%h');
								$minutes_in = $interval->format('%i');
								$min_to_hour = $minutes_in / 60;
								$workingdaypercent = ($workingday * 100) / 100;
								$timeshiftpercent = ($timeshift_percent * 100) / 100;
								$extra_ot_hours = $hours_in + $min_to_hour;

								if ($normalovertimehours > 0) {
									$normalot_hours = $normalovertimehours - $workedhours;
									$extra_ot_hours = $extra_ot_hours - $normalot_hours - $workedhours;
								} else {
									$normalot_hours = 0;
								}
							}

							$extraot_hours = round($extra_ot_hours, 2);
							$amount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshiftpercent + (($basic_pay / 30) / 8) * $normalot_hours * $workingdaypercent;
							$roundamount = round($amount, 3);
						}
					} else {
						$ot = "no";
						$normalot_hours = 0;
						$extraot_hours = 0;
						$roundamount = 0;
					}
					if ($user[0]->office_shift_id == 0) {
						/*$late_by_hours = 0;
						$late_deduct = 0;*/

						$late_allowed = $this->Office_shift_custom_model->employee_current_shift($user[0]->user_id, $date);
						$day = date('j', strtotime($date));
						$in_time = $day . "_in";
						if (!$late_allowed[$in_time]) {
							$late_by_hours = 0;
							$late_deduct = 0;
						} else {
							$on_duty3 = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' . $late_allowed['late_allowed_till'] . "mins"));
							if ($holiday_check !== "yes") {
								$attendence_check = $this->Employees_model->check_first_attendance($user[0]->user_id, $date);
								$work_clkin = new DateTime($clockin);
								$work_on_duty = new DateTime($on_duty3);
								$clkin_diff = strtotime($clockin) - strtotime($on_duty3);
								$interval_clkin = $work_clkin->diff($work_on_duty);
								$hoursin = $interval_clkin->format('%h');
								$minutesin = $interval_clkin->format('%i');
								$minutes_to_hour = round($minutesin / 60, 2);
								$late_by_hours = $hoursin + $minutes_to_hour;

								if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {
									$basic_sal = $user[0]->basic_salary;
									$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
									$late_deduct = round($latededuction, 3);
								} else {
									$late_by_hours = 0;
									$late_deduct = 0;
								}
							} else {
								$late_by_hours = 0;
								$late_deduct = 0;
							}

							unset($weekends);
							unset($holiday_check);
						}

					} else {

						// Find week day
						$week_day = date('l', strtotime($date));
						$week_day_lower = strtolower($week_day);

						// Make Table field. Eg: thursday_out_time
						$table_field_in_time = $week_day_lower . '_in_time';
						$table_field_out_time = $week_day_lower . '_out_time';

						$this->db->where('office_shift_id', $user[0]->office_shift_id);
						$office_shift = $this->db->get('xin_office_shift')->row();

						$shift_start = $office_shift->$table_field_in_time;
						$shift_end = $office_shift->$table_field_out_time;
						if (empty($shift_start)) {
							$weekends = "yes";
						}


						if ($weekends !== "yes" && $holiday_check !== "yes") {
							$attendence_check = $this->Employees_model->check_first_attendance($user[0]->user_id, $date);
							$work_clkin = new DateTime($clockin);
							$work_on_duty = new DateTime($on_duty3);
							$clkin_diff = strtotime($clockin) - strtotime($on_duty3);
							$interval_clkin = $work_clkin->diff($work_on_duty);
							$hoursin = $interval_clkin->format('%h');
							$minutesin = $interval_clkin->format('%i');
							$minutes_to_hour = round($minutesin / 60, 2);
							$late_by_hours = $hoursin + $minutes_to_hour;

							if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {
								$basic_sal = $user[0]->basic_salary;
								$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
								$late_deduct = round($latededuction, 3);
							} else {
								$late_by_hours = 0;
								$late_deduct = 0;
							}
						} else {
							$late_by_hours = 0;
							$late_deduct = 0;
						}

						unset($weekends);
						unset($holiday_check);

					}


					$product_data['ot'] = $ot;
					$product_data['normal_ot_hours'] = $normalot_hours;
					$product_data['extra_ot_hours'] = $extraot_hours;
					$product_data['ot_amount'] = $roundamount;
					$product_data['total_work_hours'] = $work_by_hours;
					$product_data['late_by_hours'] = $late_by_hours;
					$product_data['late_deduction'] = $late_deduct;

					$late_by_hours = 0;
					$late_deduct = 0;
					$emp_lastdate = $this->Employees_model->get_work_lastdate($user_id);

					$importcount = $this->Employees_model->get_import_status($user[0]->user_id, $date, $clockin, $clockout);
					if ($importcount == 0) {
						$result = $this->Employees_model->add_employee_attendance($product_data);
					}

					/*if ($emp_lastdate == "" || $date <= $emp_lastdate) {
					  $importcount = $this->Employees_model->get_import_status($user[0]->user_id, $date, $clockin, $clockout);
					  if ($importcount == 0) {
						$result = $this->Employees_model->add_employee_attendance($product_data);
					  }
					}*/
				}

				# NEW: Update totals
				$clock_in2 = $clockin;
				$empid = $user[0]->user_id;
				$late = $this->Misc_model->find_late1($date_convert, $empid);
				$early_leaving_time = $this->Misc_model->find_early_leaving1($date_convert, $empid);
				$overtime_time = $this->Misc_model->find_overtime1($date_convert, $empid);
				$rest = $this->Misc_model->find_rest($date_convert, $empid);
				$work = $this->Misc_model->find_work_total($date_convert, $empid);


				//$attendance_date = '2022-02-01';

				/*        $overtime_consts    = $this->Xin_model->get_all_overtime_constants();
						$timeshift_from     = $overtime_consts[0]->timeshift_from;
						$timeshift_to       = $overtime_consts[0]->timeshift_to;
						$evening_timeshift_from     = $overtime_consts[0]->evening_timeshift_from;
						$evening_timeshift_to       = $overtime_consts[0]->evening_timeshift_to;

						// Find week day
						$week_day = date('l', strtotime($date_convert));
						//$week_day = $this->find_week_day($date_convert);
						$week_day_lower = strtolower($week_day);

						// Make Table field. Eg: thursday_out_time
						$table_field_in_time = $week_day_lower . '_in_time';
						$table_field_out_time = $week_day_lower . '_out_time';

						//$office_shift_id = 14;
						$this->db->where('office_shift_id', $user[0]->office_shift_id);
						$office_shift = $this->db->get('xin_office_shift')->row();

						$shift_start = $office_shift->$table_field_in_time;
						$shift_end = $office_shift->$table_field_out_time;
						if(empty($shift_start)){
							$weekend = "yes";
						}

						$shift_start_secs = $this->Misc_model->hm2sec($shift_start);
						$shift_end_secs = $this->Misc_model->hm2sec($shift_end);

						$normal_ot_secs = $extra_ot_secs = 0;

						if ($shift_end_secs < $shift_start_secs) {

							$this->db->where('employee_id', $user[0]->user_id);
							$this->db->where('attendance_date', $date_convert);
							$this->db->where('clock_out !=', "");
							$this->db->order_by('time_attendance_id', 'desc');
							$last_clock_info = $this->db->get('xin_attendance_time', 1)->row();
							$clock_out       = $last_clock_info->clock_out;
							//$clock_out = '2022-02-02 07:30:00';

							$clock_out_time = strtotime($clock_out);
							$clock_out_date = date('Y-m-d', $clock_out_time);
							$shift_end = "$clock_out_date $shift_end";
							$shift_end_time = strtotime($shift_end);

							$increment = 1;




							//$normal_ot_end_secs = strtotime($clock_out_date . ' 19:30:00');
							$normal_ot_end_secs = strtotime($clock_out_date.' '.$timeshift_from);
							$extra_ot_secs = 0;
							//$extra_ot_end_secs = strtotime($clock_out_date.' 07:00:00');
							$extra_ot_end_secs = strtotime($clock_out_date.' '.$timeshift_to);

							for ($i = $shift_end_time;$i <= $clock_out_time;$i = $i + $increment)
							{
								if ($i < $extra_ot_end_secs) {
									$extra_ot_secs += 1;
								} else if ($i < $normal_ot_end_secs) {
									$normal_ot_secs += 1;
								}
							}

						} else {

							$this->db->where('employee_id', $user[0]->user_id);
							$this->db->where('attendance_date', $date_convert);
							$this->db->where('clock_out !=', "");
							$this->db->order_by('time_attendance_id', 'desc');
							$last_clock_info = $this->db->get('xin_attendance_time', 1)->row();
							$clock_out       = $last_clock_info->clock_out;

							//$clock_out = '2022-02-01 21:10:00';
							$clock_out_time = strtotime($clock_out);
							$clock_out_date = date('Y-m-d', $clock_out_time);
							$shift_end = "$clock_out_date $shift_end";
							$shift_end_time = strtotime($shift_end);

							$increment = 1;

							//$normal_ot_end_secs = strtotime($clock_out_date . ' 19:00:00');
							$normal_ot_end_secs = strtotime($clock_out_date.' '.$timeshift_from);
							$extra_ot_secs = 0;
							$clock_out_date1 = date('Y-m-d', strtotime($clock_out_date . " +1 days"));
							//$extra_ot_end_secs = strtotime($clock_out_date1.' 07:00:00');
							$extra_ot_end_secs = strtotime($clock_out_date1.' '.$timeshift_to);
							for ($i = $shift_end_time;$i <= $clock_out_time;$i = $i + $increment)
							{
								if ($i < $normal_ot_end_secs) {
									$normal_ot_secs += 1;
								} else if ($i < $extra_ot_end_secs) {
									$extra_ot_secs += 1;
								}
							}
						}*/

				/*
				echo gmdate('H:i', $normal_ot_secs);
				echo '<br>';
				echo gmdate('H:i', $extra_ot_secs);*/

				//overtime calculations start

				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$timeshift_from = $overtime_consts[0]->timeshift_from;
				$timeshift_to = $overtime_consts[0]->timeshift_to;
				$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
				$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
				/*global $weekend;
				global $holiday_check;*/

				$normal_ot_secs = 0;
				$extra_ot_secs = 0;

				if ($user[0]->office_shift_id == 0) {
					$month = date('Y-m', strtotime($date_convert));
					$office_shift = $this->Office_shift_custom_model->employee_current_shift($empid, $month);
					$day = date('j', strtotime($date_convert));
					$out_time = $day . '_out';

					$shift_end_time = strtotime($office_shift[$out_time]);

					$shift_out_time_seconds = $shift_end_time;

					$normal_ot_end_secs = strtotime($date_convert . ' 19:00:00');
					$extra_ot_secs = 0;
					$attendance_date1 = date('Y-m-d', strtotime($date_convert . " +1 days"));
					$extra_ot_end_secs = strtotime($attendance_date1 . ' 07:00:00');
					$normal_ot_end_secs_last = strtotime($attendance_date1 . ' 08:00:00');

					$this->db->where('employee_id', $empid);
					$this->db->where('attendance_date', $date_convert);
					$attendances = $this->db->get('xin_attendance_time');

					$overtime_seconds = 0;

					if ($attendances->num_rows() > 0) {
						foreach ($attendances->result() as $attendance) {

							$clock_in_seconds = strtotime($attendance->clock_in);
							$clock_out_seconds = strtotime($attendance->clock_out);

							if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
								$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

								for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
									if ($i < $normal_ot_end_secs) {
										$normal_ot_secs += 1;
									} else if ($i < $extra_ot_end_secs) {
										$extra_ot_secs += 1;
									} else if ($i < $normal_ot_end_secs_last) {
										$normal_ot_secs += 1;
									}
								}
							} else if ($clock_in_seconds > $shift_out_time_seconds) {
								$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

								for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
									if ($i < $normal_ot_end_secs) {
										$normal_ot_secs += 1;
									} else if ($i < $extra_ot_end_secs) {
										$extra_ot_secs += 1;
									} else if ($i < $normal_ot_end_secs_last) {
										$normal_ot_secs += 1;
									}
								}
							}
						}
					}

					// Deduct late time
					$late_hours = $this->Misc_model->find_late1($date_convert, $empid);
					$late_seconds = $this->Misc_model->hm2sec($late_hours);

					//$overtime_seconds -= $late_seconds;
					$normal_ot_secs -= $late_seconds;

					if ($normal_ot_secs < 0) {
						$extra_ot_secs -= abs($normal_ot_secs);
						if ($extra_ot_secs < 0)
							$extra_ot_secs = 0;
						$normal_ot_secs = 0;
					}


				} else {

					// Find week day
					$week_day = date('l', strtotime($date_convert));
					//$week_day = $this->find_week_day($date_convert);
					$week_day_lower = strtolower($week_day);

					// Make Table field. Eg: thursday_out_time
					$table_field_in_time = $week_day_lower . '_in_time';
					$table_field_out_time = $week_day_lower . '_out_time';

					$this->db->where('office_shift_id', $user[0]->office_shift_id);
					$office_shift = $this->db->get('xin_office_shift')->row();

					$shift_start = $office_shift->$table_field_in_time;
					$shift_end = $office_shift->$table_field_out_time;
					if (empty($shift_start)) {
						$weekend = "yes";
					}

					$shift_start_secs = $this->Misc_model->hm2sec($shift_start);
					$shift_end_secs = $this->Misc_model->hm2sec($shift_end);

					$normal_ot_secs = $extra_ot_secs = 0;

					if ($shift_end_secs < $shift_start_secs) {

						// Night shift ends next day
						$shift_end_date = date('Y-m-d', strtotime($date_convert . " +1 days"));

						$shift_end = "$shift_end_date $shift_end";
						$shift_end_time = strtotime($shift_end);

						$shift_out_time_seconds = $shift_end_time;


						$normal_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_from);
						$extra_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_to);
						$extra_ot_end_secs_last = strtotime($shift_end_date . ' ' . $shift_start);

						$this->db->where('employee_id', $user[0]->user_id);
						$this->db->where('attendance_date', $date_convert);
						$attendances = $this->db->get('xin_attendance_time');

						if ($attendances->num_rows() > 0) {
							foreach ($attendances->result() as $attendance) {
								$clock_in_seconds = strtotime($attendance->clock_in);
								$clock_out_seconds = strtotime($attendance->clock_out);

								if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
									for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs_last) {
											$extra_ot_secs += 1;
										}
									}
								} else if ($clock_in_seconds > $shift_out_time_seconds) {
									for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs_last) {
											$extra_ot_secs += 1;
										}
									}
								}
							}
						}

						// Deduct late time
						$late_hours = $this->Misc_model->find_late1($date_convert, $user[0]->user_id);
						$late_seconds = $this->Misc_model->hm2sec($late_hours);

						//$overtime_seconds -= $late_seconds;
						$extra_ot_secs -= $late_seconds;

						if ($extra_ot_secs < 0) {
							$normal_ot_secs -= abs($extra_ot_secs);
							if ($normal_ot_secs < 0)
								$normal_ot_secs = 0;

							$extra_ot_secs = 0;
						}
					} else {

						$shift_end = "$date_convert $shift_end";
						$shift_end_time = strtotime($shift_end);

						$shift_out_time_seconds = $shift_end_time;

						$normal_ot_end_secs = strtotime($date_convert . ' ' . $timeshift_from);
						$extra_ot_secs = 0;
						$attendance_date1 = date('Y-m-d', strtotime($date_convert . " +1 days"));
						$extra_ot_end_secs = strtotime($attendance_date1 . ' ' . $timeshift_to);
						$normal_ot_end_secs_last = strtotime($attendance_date1 . ' ' . $shift_start);

						$this->db->where('employee_id', $user[0]->user_id);
						$this->db->where('attendance_date', $date_convert);
						$attendances = $this->db->get('xin_attendance_time');

						$overtime_seconds = 0;

						if ($attendances->num_rows() > 0) {
							foreach ($attendances->result() as $attendance) {
								$clock_in_seconds = strtotime($attendance->clock_in);
								$clock_out_seconds = strtotime($attendance->clock_out);

								if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
									$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

									for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs_last) {
											$normal_ot_secs += 1;
										}
									}
								} else if ($clock_in_seconds > $shift_out_time_seconds) {
									$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

									for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs_last) {
											$normal_ot_secs += 1;
										}
									}
								}
							}
						}

						// Deduct late time
						$late_hours = $this->Misc_model->find_late1($date_convert, $user[0]->user_id);
						$late_seconds = $this->Misc_model->hm2sec($late_hours);

						//$overtime_seconds -= $late_seconds;
						$normal_ot_secs -= $late_seconds;

						if ($normal_ot_secs < 0) {
							$extra_ot_secs -= abs($normal_ot_secs);
							if ($extra_ot_secs < 0)
								$extra_ot_secs = 0;
							$normal_ot_secs = 0;
						}
					}


					/*$timestamp = strtotime($date_convert);
					$day = date('l', $timestamp);

					$comp_id       =  $user[0]->company_id;
					$holidays      =  $this->Employees_model->get_holidays($comp_id);

					  if (isset($holidays)) {
						foreach ($holidays as $row) {
						  $startDate     =  $row->start_date;
						  $endDate       =  $row->end_date;

						  if (($date_convert >= $startDate) && ($date_convert <= $endDate)) {
							$holiday_check = "yes";
						  }
						}
					  }
					if ($weekend === "yes" || $holiday_check === "yes") {
						$ot_seconds  = $this->Misc_model->hm2sec($work);
						$normal_ot_secs = 0;
						$extra_ot_secs = $ot_seconds;

					}else{
						$ot_seconds  = $this->Misc_model->hm2sec($overtime_time);
					}
					unset($weekend);
					unset($holiday_check);*/

				}
				//overtime calculations end

				// if Holiday, overtime will be total-work
				$day_status_employee = $this->Misc_model->day_status_employee($date_convert, $empid);
				if (in_array($day_status_employee, array('H', 'PH'))) {
					$overtime_time = $work;
					$extra_ot_secs = $this->Misc_model->hm2sec($overtime_time);
					$normal_ot_secs = 0;
					$late = 0;
				}

				$ot_seconds = $this->Misc_model->hm2sec($overtime_time);

				$this->Misc_model->save($date_convert, $empid, array(
					'late' => $late,
					'early_leaving' => $early_leaving_time,
					'rest' => $rest,
					'overtime' => $overtime_time,
					'work' => $work,
					'ot_seconds' => $ot_seconds,
					'normal_ot_seconds' => $normal_ot_secs,
					'extra_ot_seconds' => $extra_ot_secs
				));
				#-----------------#

			}

			//  echo "<pre>";print_r($_SESSION);print_r($products);exit;
			$Return['value'] = $_SESSION['value'];
			$count = count($_SESSION['value']) - 1;
			$Return['result'] = 'Employee attendance import Successfully.... <br>' . 'The Failed Entries - ' . $count;
		}

		/*if($Return['error']!=''){
				   $this->output($Return);
			 }*/

		$this->output($Return);
		exit;
	}


	// Validate and add info in database

	public function import_leads()
	{


		if ($this->input->post('is_ajax') == '3') {

			/* Define return | here result is used to return user data and error for error message */

			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

			$Return['csrf_hash'] = $this->security->get_csrf_hash();


			//validate whether uploaded file is a csv file

			$csvMimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain');


			if ($_FILES['file']['name'] === '') {

				$Return['error'] = $this->lang->line('xin_employee_imp_allowed_size');
			} else {

				if (in_array($_FILES['file']['type'], $csvMimes)) {

					if (is_uploaded_file($_FILES['file']['tmp_name'])) {


						// check file size

						if (filesize($_FILES['file']['tmp_name']) > 2000000) {

							$Return['error'] = $this->lang->line('xin_error_employees_import_size');
						} else {


							//open uploaded csv file with read only mode

							$csvFile = fopen($_FILES['file']['tmp_name'], 'r');


							//skip first line

							fgetcsv($csvFile);

							//parse data from csv file line by line

							while (($line = fgetcsv($csvFile)) !== FALSE) {


								$options = array('cost' => 12);

								$password_hash = password_hash($line[2], PASSWORD_BCRYPT, $options);

								$data = array(

									'name' => $line[0],

									'email' => $line[1],

									'client_password' => $password_hash,

									'contact_number' => $line[3],

									'company_name' => $line[4],

									'website_url' => $line[5],

									'address_1' => $line[6],

									'address_2' => $line[7],

									'city' => $line[8],

									'state' => $line[9],

									'zipcode' => $line[10],

									'country' => $line[11],

									'is_active' => 1,

									'created_at' => date('Y-m-d H:i:s'),

									'is_changed' => '0',

									'client_profile' => '',

								);

								$this->Clients_model->add_lead($data);
							}

							//close opened csv file

							fclose($csvFile);


							$Return['result'] = $this->lang->line('xin_success_leads_import');
						}
					} else {

						$Return['error'] = $this->lang->line('xin_error_not_leads_import');
					}
				} else {

					$Return['error'] = $this->lang->line('xin_error_invalid_file');
				}
			} // file empty


			if ($Return['error'] != '') {

				$this->output($Return);
			}


			$this->output($Return);

			exit;
		}
	}

	public function download()
	{
		error_reporting(0);
		ini_set('display_errors', FALSE);
		require_once dirname(__FILE__) . '/PHPExcel/Classes/PHPExcel.php';
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("ABBASBILJEEK")
			->setLastModifiedBy("ABBASBILJEEK")
			->setTitle("Failed Attendances");
		$i = 1;
		foreach ($_SESSION['value'] as $k => $data) {
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue("A{$i}", $data[0])
				->setCellValue("B{$i}", $data[1])
				->setCellValue("C{$i}", $data[2])
				->setCellValue("D{$i}", $data[3])
				->setCellValue("E{$i}", $data[4])
				->setCellValue("F{$i}", $data[5])
				->setCellValue("G{$i}", $data[6])
				->setCellValue("H{$i}", $data[7])
				->setCellValue("I{$i}", $data[8])
				->setCellValue("J{$i}", $data[9]);
			$i++;
		}

		$objPHPExcel->getActiveSheet()->setTitle('Failed_Attendances');
		$objPHPExcel->setActiveSheetIndex(0);

		$sheet = $objPHPExcel->getActiveSheet();
		$cellIterator = $sheet->getRowIterator()->current()->getCellIterator();
		$cellIterator->setIterateOnlyExistingCells(true);
		foreach ($cellIterator as $cell) {
			$sheet->getColumnDimension($cell->getColumn())->setAutoSize(true);
		}

		$objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);

		$filename = 'Failed_Attendances';

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-Control: cache, must-revalidate');
		header('Pragma: public');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
		exit;
	}

	public function download_employee()
	{
		error_reporting(0);
		ini_set('display_errors', FALSE);
		require_once dirname(__FILE__) . '/PHPExcel/Classes/PHPExcel.php';
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("ABBASBILJEEK")
			->setLastModifiedBy("ABBASBILJEEK")
			->setTitle("Failed Employee Detailes");
		$i = 1;
		foreach ($_SESSION['value'] as $k => $data) {
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue("A{$i}", $data[0])
				->setCellValue("B{$i}", $data[1])
				->setCellValue("C{$i}", $data[2])
				->setCellValue("D{$i}", $data[3])
				->setCellValue("E{$i}", $data[4])
				->setCellValue("F{$i}", $data[5])
				->setCellValue("G{$i}", $data[6])
				->setCellValue("H{$i}", $data[7])
				->setCellValue("I{$i}", $data[8])
				->setCellValue("J{$i}", $data[9])
				->setCellValue("K{$i}", $data[10])
				->setCellValue("L{$i}", $data[11])
				->setCellValue("M{$i}", $data[12])
				->setCellValue("N{$i}", $data[13])
				->setCellValue("O{$i}", $data[14])
				->setCellValue("P{$i}", $data[15])
				->setCellValue("Q{$i}", $data[16])
				->setCellValue("R{$i}", $data[17])
				->setCellValue("S{$i}", $data[18])
				->setCellValue("T{$i}", $data[19])
				->setCellValue("U{$i}", $data[20])
				->setCellValue("V{$i}", $data[21])
				->setCellValue("W{$i}", $data[22])
				->setCellValue("X{$i}", $data[23])
				->setCellValue("Y{$i}", $data[24])
				->setCellValue("Z{$i}", $data[25])
				->setCellValue("AA{$i}", $data[26])
				->setCellValue("AB{$i}", $data[27])
				->setCellValue("AC{$i}", $data[28])
				->setCellValue("AD{$i}", $data[29])
				->setCellValue("AE{$i}", $data[30])
				->setCellValue("AF{$i}", $data[31])
				->setCellValue("AG{$i}", $data[32])
				->setCellValue("AH{$i}", $data[33])
				->setCellValue("AI{$i}", $data[34])
				->setCellValue("AJ{$i}", $data[35])
				->setCellValue("AK{$i}", $data[36])
				->setCellValue("AL{$i}", $data[37])
				->setCellValue("AM{$i}", $data[38])
				->setCellValue("AN{$i}", $data[39])
				->setCellValue("AO{$i}", $data[40])
				->setCellValue("AP{$i}", $data[41])
				->setCellValue("AQ{$i}", $data[42])
				->setCellValue("AR{$i}", $data[43])
				->setCellValue("AS{$i}", $data[44])
				->setCellValue("AT{$i}", $data[45])
				->setCellValue("AU{$i}", $data[46])
				->setCellValue("AV{$i}", $data[47])
				->setCellValue("AW{$i}", $data[48])
				->setCellValue("AX{$i}", $data[49])
				->setCellValue("AY{$i}", $data[50])
				->setCellValue("AZ{$i}", $data[51])
				->setCellValue("BA{$i}", $data[52])
				->setCellValue("BB{$i}", $data[53])
				->setCellValue("BC{$i}", $data[54])
				->setCellValue("BD{$i}", $data[55])
				->setCellValue("BE{$i}", $data[56])
				->setCellValue("BF{$i}", $data[57])
				->setCellValue("BG{$i}", $data[58])
				->setCellValue("BH{$i}", $data[59])
				->setCellValue("BI{$i}", $data[60])
				->setCellValue("BJ{$i}", $data[61])
				->setCellValue("BK{$i}", $data[62])
				->setCellValue("BL{$i}", $data[63])
				->setCellValue("BM{$i}", $data[64])
				->setCellValue("BN{$i}", $data[65])
				->setCellValue("BO{$i}", $data[66]);
			$i++;
		}

		$objPHPExcel->getActiveSheet()->setTitle('Failed_employee');
		$objPHPExcel->setActiveSheetIndex(0);

		$sheet = $objPHPExcel->getActiveSheet();
		$cellIterator = $sheet->getRowIterator()->current()->getCellIterator();
		$cellIterator->setIterateOnlyExistingCells(true);
		foreach ($cellIterator as $cell) {
			$sheet->getColumnDimension($cell->getColumn())->setAutoSize(true);
		}

		$objPHPExcel->getActiveSheet()->getStyle('A1:N1')->getFont()->setBold(true);

		$filename = 'Failed_employeee';

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename . '.xls"');
		header('Cache-Control: max-age=0');
		header('Cache-Control: max-age=1');
		header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-Control: cache, must-revalidate');
		header('Pragma: public');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
		exit;
	}
}
