<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Leave_Salary extends MY_Controller
{
	public function __construct()
	{
        parent::__construct();
		$this->load->model("Employees_model");
    }

    /*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

    public function set()
    {
    	$session = $this->session->userdata('username');

		if(empty($session)){
			redirect('admin/');
		}

		if ($this->input->post('submit')){
			$category = $this->input->post('category');
			$deductions = $this->input->post('deductions');
			$allowances = $this->input->post('allowances');
			$commissions = $this->input->post('commissions');
			$other_payments = $this->input->post('other_payments');
			$loan = $this->input->post('loan');

			$sql = "SELECT * FROM `leave_salaries` WHERE `category` = ?";
			$query = $this->db->query($sql, array($category));

			if ($query->num_rows() > 0){
				$data['form_error'] = 'Entry already exist with category - ' . ucfirst($category);
			}else{
				$allowances_serialized = null;
				if (! empty($allowances)){
					$allowances_serialized = serialize($allowances);
				}

				$commissions_serialized = null;
				if (! empty($commissions)){
					$commissions_serialized = serialize($commissions);
				}

				$deductions_serialized = null;
				if (! empty($deductions)){
					$deductions_serialized = serialize($deductions);
				}
				$other_payments_serialized = null;
				if (! empty($other_payments)){
					$other_payments_serialized = serialize($other_payments);
				}
				$loan_serialized = null;
				if (! empty($loan)){
					$loan_serialized = serialize($loan);
				}

				$sql = "INSERT INTO `leave_salaries` SET
						category = ?,
						allowances = ?,
						deductions = ?,
						commissions = ?,
						other_payments = ?,
						loan = ?";
				$this->db->query($sql, array(
					$category,
					$allowances_serialized,
					$deductions_serialized,
					$commissions_serialized,
					$other_payments_serialized,
					$loan_serialized
				));
				$insert_id = $this->db->insert_id();
				
				$this->Employees_model->set_employees_leave_salary($category);
				
				$this->session->set_flashdata('form_success', 'Leave salary saved.');
				redirect('admin/leave_salary/set');
			}
		}

		$heading = 'Set Leave Salary';
		$data['heading'] = $heading;
		$data['title'] = $heading . ' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $heading;

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(1));
		$data['allowances'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(3));
		$data['deductions'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(2));
		$data['commissions'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(6));
		$data['other_payments'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(5));
		$data['loan'] = $query->result();

		$leave_salary = new StdClass;
		$leave_salary->id = 0;
		$leave_salary->category = '';
		$leave_salary->allowances = array();
		$leave_salary->deductions = array();
		$leave_salary->commissions = array();
		$leave_salary->other_payments = array();
		$leave_salary->loan = array();

		$data['leave_salary'] = $leave_salary;

		$data['subview'] = $this->load->view("admin/leave_salary/set", $data, TRUE);

		$this->load->view('admin/layout/layout_main', $data); //page load
    }
    
    public function set_employees_leave_salary($category, $employee_id = 0)
    {
        if($category == 'bahraini'){
			$nationality_id = 17;
		}else{
			$nationality_id = 0;
			$category = 'expat';
		}
		
		$this->db->where('category', $category);
		$leave_salary_info = $this->db->get('leave_salaries')->row();
		
		if (! $leave_salary_info)
		{
		    return false;
		}
		
		$allowances = array();
		if (! empty($leave_salary_info->allowances))
		    $allowances = unserialize($leave_salary_info->allowances);
		
		$commissions = array();
		if (! empty($leave_salary_info->commissions))
		    $commissions = unserialize($leave_salary_info->commissions);
		
		$deductions = array();
		if (! empty($leave_salary_info->deductions))
		    $deductions = unserialize($leave_salary_info->deductions);
		
		$other_payments = array();
		if (! empty($leave_salary_info->other_payments))
		    $other_payments = unserialize($leave_salary_info->other_payments);
		
		$loan = array();
		if (! empty($leave_salary_info->loan))
		    $loan = unserialize($leave_salary_info->loan);
		
		$employees = $this->Employees_model->read_all_employee_information($nationality_id);
		
		$get_all_employees = array();
		
		if ($employee_id > 0)
		{
		    foreach ($employees as $emp)
		    {
		        if ($emp->id != $employee_id)
		            continue;
		        
		        $get_all_employees[] = $emp;
		    }
		}
		
		$insert_id = $leave_salary_info->id;
		
		if (! empty($allowances)){
			foreach($get_all_employees as $emp){
				foreach($allowances as $allo){
					$allo_exists_or_not = $this->Employees_model->read_single_salary_allowance_empid_alloid($allo,$emp->user_id);
					if(empty($allo_exists_or_not)){
						$data = array(
							'allowance_title' => $allo,
							'allowance_amount' => 0,
							'employee_id' => $emp->user_id,
							'is_allowance_taxable' => 0,
							'amount_option' => 0,
							'applicable_for_paysalary' => 1,
							'leave_salaries_id'=>$insert_id
							);
						$result = $this->Employees_model->add_salary_allowances($data);
					}else{
						$data = array(
							'applicable_for_paysalary' => 1,
							);
						$result = $this->Employees_model->salary_allowance_update_record_leave_salary($data,$allo,$emp->user_id);	
							
					}	
					
				}
			}
		}

		if (! empty($commissions)){
			foreach($get_all_employees as $emp){
				foreach($commissions as $commi){
					$allo_exists_or_not = $this->Employees_model->read_salary_commissions_empid_alloid($commi,$emp->user_id);
					if(empty($allo_exists_or_not)){
						$data = array(
							'commission_title' => $commi,
							'commission_amount' => 0,
							'employee_id' => $emp->user_id,
							'is_commission_taxable' => 0,
							'amount_option' => 0,
							'applicable_for_paysalary' => 1,
							'leave_salaries_id'=>$insert_id
							);
						$result = $this->Employees_model->add_salary_commissions($data);
					}else{
						$data = array(
							'applicable_for_paysalary' => 1,
							);
						$result = $this->Employees_model->salary_commission_update_record_leave_salary($data,$commi,$emp->user_id);	
							
					}
					
				}
			}
		}

		if (! empty($deductions)){
			foreach($get_all_employees as $emp){
				foreach($deductions as $deduct){
					$allo_exists_or_not = $this->Employees_model->read_salary_deductions_empid_alloid($deduct,$emp->user_id);
					if(empty($allo_exists_or_not)){
						$data = array(
							'deduction_title' => $deduct,
							'deduction_amount' => 0,
							'employee_id' => $emp->user_id,
							'statutory_options' => 0,
							'applicable_for_paysalary' => 1,
							'leave_salaries_id'=>$insert_id
							);
						$result = $this->Employees_model->add_salary_statutory_deductions($data);
					}else{
						$data = array(
							'applicable_for_paysalary' => 1,
							);
						$result = $this->Employees_model->salary_deduction_update_record_leave_salary($data,$deduct,$emp->user_id);	
							
					}		
					
				}
			}
		}
		if (! empty($other_payments)){
			foreach($get_all_employees as $emp){
				foreach($other_payments as $other_pay){
					$allo_exists_or_not = $this->Employees_model->read_other_payments_empid_alloid($other_pay,$emp->user_id);
					if(empty($allo_exists_or_not)){
						$data = array(
							'payments_title' => $other_pay,
							'payments_amount' => 0,
							'employee_id' => $emp->user_id,
							'amount_option' => 0,
							'is_otherpayment_taxable'=> 0,
							'applicable_for_paysalary' => 1,
							'leave_salaries_id'=>$insert_id
							);
						$result = $this->Employees_model->add_salary_other_payments($data);
					}else{
						$data = array(
							'applicable_for_paysalary' => 1,
							);
						$result = $this->Employees_model->salary_other_payment_update_record_leave_salary($data,$other_pay,$emp->user_id);	
							
					}	
				}	
			}
		}
		if (! empty($loan)){
			foreach($get_all_employees as $emp){
				foreach($loan as $loans){
					$allo_exists_or_not = $this->Employees_model->read_loans_empid_alloid($loans,$emp->user_id);
					if(empty($allo_exists_or_not)){
						$data = array(
							'loan_options' => $loans,
							'loan_deduction_amount' => 0,
							'employee_id' => $emp->user_id,
							'is_deducted_from_salary' => 0,
							'status'=> 0,
							'applicable_for_paysalary' => 1,
							'leave_salaries_id'=>$insert_id
							);
						$result = $this->Employees_model->add_salary_loan($data);
					}else{
						$data = array(
							'applicable_for_paysalary' => 1,
							);
						$result = $this->Employees_model->salary_loan_update_record_leave_salary($data,$loans,$emp->user_id);	
							
					}		
					
				}
			}
		}
    }

    public function list()
    {
    	$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

    	$sql = "SELECT * FROM `leave_salaries`";
    	$query = $this->db->query($sql);
    	$data = array();

    	foreach ($query->result() as $info)
    	{
    		$allowance_names = array();
    		if ($info->allowances) {
    			$allowances = unserialize($info->allowances);
    			foreach ($allowances as $id) {
	    			$allowance_names[] = $this->get_name($id);
	    		}
    		}
    		$deduction_names = array();
    		if ($info->deductions) {
    			$deductions = unserialize($info->deductions);
    			foreach ($deductions as $id) {
	    			$deduction_names[] = $this->get_name($id);
	    		}
    		}
			
			$commissions_names = array();
    		if ($info->commissions) {
    			$commissions = unserialize($info->commissions);
    			foreach ($commissions as $id) {
	    			$commissions_names[] = $this->get_name($id);
	    		}
    		}

			$other_payments_names = array();
    		if ($info->other_payments) {
    			$other_payments = unserialize($info->other_payments);
    			foreach ($other_payments as $id) {
	    			$other_payments_names[] = $this->get_name($id);
	    		}
    		}

			$loan_names = array();
    		if ($info->loan) {
    			$loan = unserialize($info->loan);
    			foreach ($loan as $id) {
	    			$loan_names[] = $this->get_name($id);
	    		}
    		}


    		$buttons = '
    		<span data-toggle="tooltip" data-state="primary" data-placement="top" title="" data-original-title="Edit">
   				<a href="'.base_url('admin/leave_salary/edit/' . $info->id).'" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light">
   					<span class="far fa-edit"></span>
   				</a>
    		</span>
    		<span data-toggle="tooltip" data-state="danger" data-placement="top" title="" data-original-title="Delete">
    			<button type="button" class="btn icon-btn btn-sm btn-outline-danger delete" data-toggle="modal" data-target=".delete-ls-modal" data-record-id="'.$info->id.'">
    				<span class="fas fa-trash"></span>
    			</button>
    		</span>
    		';

    		$data[] = array(
    			ucfirst($info->category),
    			implode(', ', $allowance_names),
    			implode(', ', $deduction_names),
				implode(', ', $commissions_names),
				implode(', ', $other_payments_names),
				implode(', ', $loan_names),
    			"$buttons"
    		);
    	}

    	$output = array(
			"draw" => $draw,
			"recordsTotal" => $query->num_rows(),
			"recordsFiltered" => $query->num_rows(),
			"data" => $data
		);
		$this->output($output);
    }

    public function edit($id = 0)
    {
    	$sql = "SELECT * FROM leave_salaries WHERE id = ?";
    	$query = $this->db->query($sql, array($id));

    	if ($query->num_rows() == 0)
    	{
    		redirect('admin/leave_salary/set');
    	}

    	if ($this->input->post('submit'))
		{
			$old_data = $query->result();
			$category = (!empty($this->input->post('category')))?$this->input->post('category'):$old_data[0]->category;
			$deductions = $this->input->post('deductions');
			$allowances = $this->input->post('allowances');
			$commissions = $this->input->post('commissions');
			$other_payments = $this->input->post('other_payments');
			$loan = $this->input->post('loan');

			$allowances_serialized = null;
			if (! empty($allowances))
			{
				$allowances_serialized = serialize($allowances);
			}

			$deductions_serialized = null;
			if (! empty($deductions))
			{
				$deductions_serialized = serialize($deductions);
			}
			$commissions_serialized = null;
			if (! empty($commissions)){
				$commissions_serialized = serialize($commissions);
			}
			$other_payments_serialized = null;
			if (! empty($other_payments)){
				$other_payments_serialized = serialize($other_payments);
			}
			$loan_serialized = null;
			if (! empty($loan)){
				$loan_serialized = serialize($loan);
			}
			$sql = "UPDATE `leave_salaries` SET
					allowances = ?,
					deductions = ?,
					commissions = ?,
					other_payments = ?,
					loan = ? WHERE
					id = ?";
			$this->db->query($sql, array(
				$allowances_serialized,
				$deductions_serialized,
				$commissions_serialized,
				$other_payments_serialized,
				$loan_serialized,
				$id
			));
			//dlt all datas
				$sql = "SELECT * FROM  xin_salary_loan_deductions WHERE leave_salaries_id = ?";
				$query = $this->db->query($sql, array($id));
				if ($query->num_rows() > 0){
					$sql = "DELETE FROM xin_salary_loan_deductions WHERE leave_salaries_id = ?";
					$this->db->query($sql, $id);
				}
				$sql = "SELECT * FROM  xin_salary_allowances WHERE leave_salaries_id = ?";
				$query = $this->db->query($sql, array($id));
				if ($query->num_rows() > 0){
					$sql = "DELETE FROM xin_salary_allowances WHERE leave_salaries_id = ?";
					$this->db->query($sql, $id);
				}
				$sql = "SELECT * FROM  xin_salary_commissions WHERE leave_salaries_id = ?";
				$query = $this->db->query($sql, array($id));
				if ($query->num_rows() > 0){
					$sql = "DELETE FROM xin_salary_commissions WHERE leave_salaries_id = ?";
					$this->db->query($sql, $id);
				}
				$sql = "SELECT * FROM  xin_salary_other_payments WHERE leave_salaries_id = ?";
				$query = $this->db->query($sql, array($id));
				if ($query->num_rows() > 0){
					$sql = "DELETE FROM xin_salary_other_payments WHERE leave_salaries_id = ?";
					$this->db->query($sql, $id);
				}
				$sql = "SELECT * FROM  xin_salary_statutory_deductions WHERE leave_salaries_id = ?";
				$query = $this->db->query($sql, array($id));
				if ($query->num_rows() > 0){
					$sql = "DELETE FROM xin_salary_statutory_deductions WHERE leave_salaries_id = ?";
					$this->db->query($sql, $id);
				}
			//end dlt all datas
			// insert again for all employees
			$insert_id = $id;
			
			$this->Employees_model->set_employees_leave_salary($category);
			
			$this->session->set_flashdata('form_success', 'Leave salary updated.');
			redirect('admin/leave_salary/set');
		}

    	$leave_salary = $query->row();
    	if ($leave_salary->allowances) {
    		$leave_salary->allowances = unserialize($leave_salary->allowances);
    	} else {
    		$leave_salary->allowances = array();
    	}
    	if ($leave_salary->deductions) {
    		$leave_salary->deductions = unserialize($leave_salary->deductions);
    	} else {
    		$leave_salary->deductions = array();
    	}
		if ($leave_salary->commissions) {
    		$leave_salary->commissions = unserialize($leave_salary->commissions);
    	} else {
    		$leave_salary->commissions = array();
    	}
		if ($leave_salary->other_payments) {
    		$leave_salary->other_payments = unserialize($leave_salary->other_payments);
    	} else {
    		$leave_salary->other_payments = array();
    	}
		if ($leave_salary->loan) {
    		$leave_salary->loan = unserialize($leave_salary->loan);
    	} else {
    		$leave_salary->loan = array();
    	}

    	$data['leave_salary'] = $leave_salary;

    	$heading = 'Update Leave Salary';
    	$data['heading'] = $heading;
		$data['title'] = $heading . ' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = $heading;

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(1));
		$data['allowances'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(3));
		$data['deductions'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(2));
		$data['commissions'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(6));
		$data['other_payments'] = $query->result();

		$sql = "SELECT * FROM `allowance` WHERE `type_id` = ?";
		$query = $this->db->query($sql, array(5));
		$data['loan'] = $query->result();

		$data['subview'] = $this->load->view("admin/leave_salary/set", $data, TRUE);

		$this->load->view('admin/layout/layout_main', $data); //page load
    }

    public function delete()
    {
    	$id = $this->input->post('id');

    	$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
        $sql = "SELECT * FROM leave_salaries WHERE id = ?";
    	$query = $this->db->query($sql, array($id));

    	if ($query->num_rows() == 0)
    	{
    		$this->session->set_flashdata('error', 'Entry not found.');
			redirect('admin/leave_salary/set');	
    	}

		$sql = "SELECT * FROM  xin_salary_loan_deductions WHERE leave_salaries_id = ?";
    	$query = $this->db->query($sql, array($id));
		if ($query->num_rows() > 0){
    		$sql = "DELETE FROM xin_salary_loan_deductions WHERE leave_salaries_id = ?";
    		$this->db->query($sql, $id);
    	}
		$sql = "SELECT * FROM  xin_salary_allowances WHERE leave_salaries_id = ?";
    	$query = $this->db->query($sql, array($id));
		if ($query->num_rows() > 0){
    		$sql = "DELETE FROM xin_salary_allowances WHERE leave_salaries_id = ?";
    		$this->db->query($sql, $id);
    	}
		$sql = "SELECT * FROM  xin_salary_commissions WHERE leave_salaries_id = ?";
    	$query = $this->db->query($sql, array($id));
		if ($query->num_rows() > 0){
    		$sql = "DELETE FROM xin_salary_commissions WHERE leave_salaries_id = ?";
    		$this->db->query($sql, $id);
    	}
		$sql = "SELECT * FROM  xin_salary_other_payments WHERE leave_salaries_id = ?";
    	$query = $this->db->query($sql, array($id));
		if ($query->num_rows() > 0){
    		$sql = "DELETE FROM xin_salary_other_payments WHERE leave_salaries_id = ?";
    		$this->db->query($sql, $id);
    	}
		$sql = "SELECT * FROM  xin_salary_statutory_deductions WHERE leave_salaries_id = ?";
    	$query = $this->db->query($sql, array($id));
		if ($query->num_rows() > 0){
    		$sql = "DELETE FROM xin_salary_statutory_deductions WHERE leave_salaries_id = ?";
    		$this->db->query($sql, $id);
    	}
    	$sql = "DELETE FROM leave_salaries WHERE id = ?";
    	$this->db->query($sql, $id);
		
		$this->session->set_flashdata('success', 'Leave salary deleted.');
		redirect('admin/leave_salary/set');		
    }

    public function get_name($id = 0)
    {
    	$names = array();

		$sql = "SELECT name FROM allowance WHERE id = ?";
		$query = $this->db->query($sql, array($id));
		$result = $query->result();
		if (isset($result[0])) {
			return $result[0]->name;
		}
    }
}
