<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Payroll extends MY_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->library('Pdf');
		//load the model
		$this->load->model("Payroll_model");
		$this->load->model("Xin_model");
		$this->load->model("Employees_model");
		$this->load->model("Designation_model");
		$this->load->model("Department_model");
		$this->load->model("Location_model");
		$this->load->model("Timesheet_model");
		$this->load->model("Overtime_request_model");
		$this->load->model("Company_model");
		$this->load->model("Finance_model");
		$this->load->helper('string');
		$this->load->model("Roles_model");
		$this->load->model("Resignation_model");
		$this->load->model("Loan");
		$this->load->model("Advance");
		$this->load->model("Office_shift_custom_model");
	}

	/*Function to set JSON output*/
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

	// payroll templates
	public function templates()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_payroll_templates') . ' | ' . $this->Xin_model->site_title();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = $this->lang->line('left_payroll_templates');
		$data['path_url'] = 'payroll_templates';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('271', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/payroll/templates", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// generate payslips
	public function generate_payslip()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_generate_payslip') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Department_model->ajax_company_location_information('');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = $this->lang->line('left_generate_payslip');
		$data['path_url'] = 'generate_payslip';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('282', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/payroll/generate_payslip", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function get_company_locations_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/get_locations_lists", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_employees_date()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);

		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);


		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/get_emp_date", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}


	public function employee_Leave_Count()
	{

		$data['title'] = $this->Xin_model->site_title();
		$date1 = $this->uri->segment(4);
		$date2 = $this->uri->segment(5);
		$id = $this->uri->segment(6);

		$d = explode('%', $date1);
		$d1 = explode('%', $date2);


		$data = array(
			'date1' => $date1,
			'date2' => $date2,
			'emp_id' => $id,
		);


		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/employee_Leave_Count", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_employees_encashment_days()
	{

		$data['title'] = $this->Xin_model->site_title();
		$date1 = $this->uri->segment(4);
		$date2 = $this->uri->segment(5);
		$id = $this->uri->segment(6);

		$d = explode('%', $date1);
		$d1 = explode('%', $date2);


		$data = array(
			'date1' => $date1,
			'date2' => $date2,
			'emp_id' => $id,
		);


		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/get_employees_encashment_days", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}


	public function get_employees_joindate()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'employee_id' => $id
		);


		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/date_join", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}


	public function bank_format()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$month_year = '';
		if (!empty($this->uri->segment(4))) {
			$month_year = $this->uri->segment(4);
		}
		$data['title'] = 'Bank Format | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = 'Bank Format';
		$data['path_url'] = 'bank_format';
		$data['month_year'] = $month_year;
		$data['all_locations'] = $this->Xin_model->all_company_locations();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('277', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/payroll/bank_format", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function coverletter()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Cover Letter | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = 'Cover Letter';
		//$data['path_url'] = 'bank_format';
		$data['all_locations'] = $this->Xin_model->all_company_locations();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('36', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/payroll/coverletter", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function coverletter_download()
	{
	    ini_set('max_execution_time', '1000');
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$p_date = $this->input->post("month_year");
		$location_id = $this->input->post("location_id");
		$value_date = $this->input->post("value_date");
		$total_amount = 0;
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('279', $role_resources_ids)) {
			if ($location_id == 0) {
				$payslip = $this->Employees_model->get_allemployees_payslip();
			} else {
				$payslip = $this->Employees_model->get_employees_payslip_by_place($location_id);
			}
			/*if($this->input->get("employee_id")==0 && $this->input->get("company_id")==0) {
				$payslip = $this->Employees_model->get_employees_payslip($location_id);
			} else if($this->input->get("employee_id")==0 && $this->input->get("company_id")!=0) {
				$payslip = $this->Payroll_model->get_comp_template($this->input->get("company_id"),0);
			} else if($this->input->get("employee_id")!=0 && $this->input->get("company_id")!=0) {
				$payslip = $this->Payroll_model->get_employee_comp_template($this->input->get("company_id"),$this->input->get("employee_id"));
			}else {
				$payslip = $this->Employees_model->get_employees_payslip($location_id);
			}*/
		} else {
			$payslip = $this->Payroll_model->get_employee_comp_template($user_info[0]->company_id, $session['user_id']);
		}

		$system = $this->Xin_model->read_setting_info(1);
		$data = array();

		foreach ($payslip->result() as $r) {
			// user full name
			$emp_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			$full_name = '<a target="_blank" class="text-primary" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '">' . $emp_name . '</a>';

			// get total hours > worked > employee
			$pay_date = $this->input->post('month_year');
			//overtime request
			$overtime_count = $this->Overtime_request_model->get_overtime_request_count($r->user_id, $this->input->post('month_year'));
			$re_hrs_old_int1 = 0;
			$re_hrs_old_seconds = 0;
			$re_pcount = 0;
			foreach ($overtime_count as $overtime_hr) {
				// total work
				$request_clock_in = new DateTime($overtime_hr->request_clock_in);
				$request_clock_out = new DateTime($overtime_hr->request_clock_out);
				$re_interval_late = $request_clock_in->diff($request_clock_out);
				$re_hours_r = $re_interval_late->format('%h');
				$re_minutes_r = $re_interval_late->format('%i');
				$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

				$re_str_time = $re_total_time;

				$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

				sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$re_hrs_old_int1 += $re_hrs_old_seconds;

				$re_pcount = gmdate("H", $re_hrs_old_int1);
			}
			$result = $this->Payroll_model->total_hours_worked($r->user_id, $pay_date);
			$hrs_old_int1 = 0;
			$pcount = 0;
			$Trest = 0;
			$total_time_rs = 0;
			$hrs_old_int_res1 = 0;
			foreach ($result->result() as $hour_work) {
				// total work
				$clock_in = new DateTime($hour_work->clock_in);
				$clock_out = new DateTime($hour_work->clock_out);
				$interval_late = $clock_in->diff($clock_out);
				$hours_r = $interval_late->format('%h');
				$minutes_r = $interval_late->format('%i');
				$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

				$str_time = $total_time;

				$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

				sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$hrs_old_int1 += $hrs_old_seconds;

				$pcount = gmdate("H", $hrs_old_int1);
			}
			$pcount = $pcount + $re_pcount;
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// 1: salary type
			if ($r->wages_type == 1) {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			} else if ($r->wages_type == 2) {
				$wages_type = $this->lang->line('xin_employee_daily_wages');
				if ($pcount > 0) {
					$basic_salary = $pcount * $r->basic_salary;
				} else {
					$basic_salary = $pcount;
				}
				$p_class = 'emo_hourly_pay';
				$view_p_class = 'hourlywages_template_modal';
			} else {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			}
			// all allowances, all loan/deductions
			$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($r->user_id, $p_date, $basic_salary);
			$allowance_amount = $all_allo_and_dedct[0];
			$loan_de_amount = $all_allo_and_dedct[1];
			$commissions_amount = $all_allo_and_dedct[2];
			$other_payments_amount = $all_allo_and_dedct[3];
			$statutory_deductions_amount = $all_allo_and_dedct[4];
			$overtime_amount = $all_allo_and_dedct[5];
			$saudi_gosi = $all_allo_and_dedct[6];
			$advance_amount = $all_allo_and_dedct[7];


			$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount + $saudi_gosi;
			$total_deduction = $loan_de_amount + $statutory_deductions_amount;
			$total_net_salary = $total_earning - $total_deduction;
			$net_salary = $total_net_salary;
			$total_net_salary = $total_net_salary - $advance_amount;
			// make payment
			if ($system[0]->is_half_monthly == 1) {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($r->user_id, $p_date);
				$payment_last = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($r->user_id, $p_date);
				if ($payment_check->num_rows() > 1) {
					//foreach($payment_last as $payment_half_last){
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					//$mpay = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_payroll_make_payment').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".'.$p_class.'" data-employee_id="'. $r->user_id . '" data-payment_date="'. $p_date . '" data-company_id="'.$this->input->get("company_id").'"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('273', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code><br>' . '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $payment_last[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span><code>' . $this->lang->line('xin_title_second_half') . '</code>';
					//}
					//detail link
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay .= '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('273', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code>';
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					//detail link
					$detail = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $pay_date . '"><span class="fa fa-eye"></span></button></span>';

					$total_net_salary = $total_net_salary;
				}
				//detail link
				//$detail = '';
			} else {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($r->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('273', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					//$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					$total_net_salary = $total_net_salary;
				}
				//detail link
				$detail = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '"" data-net="' . $total_net_salary . '"><span class="fa fa-eye"></span></button></span>';
			}

			$net_salary = number_format((float)$total_net_salary, 2, '.', '');
			$basic_salary = number_format((float)$basic_salary, 2, '.', '');
			//}

			if ($basic_salary == 0 || $basic_salary == '') {
				$fmpay = '';
			} else {
				$fmpay = $mpay;
			}

			//new leave calc
			$month_year = $pay_date;
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leaves = $this->Employees_model->emp_leave_fetch($r->user_id, $start_date_y);

			$user_id = $r->user_id;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}
			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$k = 1;
			$extra_amount = $tot_days_lop_normal = 0;
			$tot_days = 0;

			//Using attendance
			$arry_years = array();
			$st = '';
			$p_count_val = 0;
			$start_date_co = $year . '-' . $month . '-' . '1';
			$end_date_co = $year . '-' . $month . '-' . $daysInMonth;


			$present_arr = array();
			//$st = $this->db->last_query();

			//$total_leaves = count($leave_arr) + count($half_leave_arr);
			//$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$user = $this->Xin_model->read_user_info($r->user_id);
			if (strtotime($month_year) == strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				if ($user[0]->date_of_leaving) {
					if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
						if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
							$difference_days = 0;
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else {
						$difference_days = 0;
					}
				} else {
					$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
					if ($get_attendance_last_entered) {
						$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
						//$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days = $difference->format("%a") + 1;
					} else {
						$difference_days = 0;
					}
				}
			} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
				if ($get_attendance_last_entered) {
					$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
					//$month_year_att_end = $month_year.'-'.date('d');
					$startDate = new DateTime($month_year_att);
					$endDate = new DateTime($month_year_att_end);
					$difference = $endDate->diff($startDate);
					$difference_days = $difference->format("%a") + 1;
				} else {
					$difference_days = 0;
				}
			} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
				$difference_days = 0;
			}
			if ($difference_days >= 29) {
				$difference_days = $daysInMonth;
			}


			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

			//end number of calc
			$attendence_calc = $this->Xin_model->AttendnceCount_calc_common($r->office_shift_id, $start_date_co, $end_date_co, $r->company_id, $r->user_id, $difference_days, $year, $month);
			// print_R($attendence_calc);exit;
			if ($attendence_calc) {
				$tot_days_lop_normal = $attendence_calc[0];
				$totl_num_days_pres = $attendence_calc[1];
			} else {
				$tot_days_lop_normal = 0;
				$totl_num_days_pres = 0;
			}

			$bs_pay = $r->basic_salary;
			$leave_cut_salary = ($bs_pay / 30) * $tot_days_lop;
			if ($leave_cut_salary > 0) {
				$leave_cut_salary = round($leave_cut_salary, 3);
			}
			$net_salary = ($total_net_salary / 30) * $totl_num_days_pres;
			$net_salary = $net_salary - $leave_cut_salary;
			$start_date_y_m = date('Y-m', strtotime($month_year));

			/* New Annual Leave methode */
			$holiday_count_new = 0;
			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);
			$annual_amt_pay = $anual_days_leave = 0;
			$holiday_count_new = $public_holiday_count_new = $working_days = 0;
			$leave__half_day_count_new = $leave_count_new = $present_count_new = $absent_count_new = 0;
			$tot_days_lop_new = 0;
			$total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($user_id, $start_date_y_m);
			if (!empty($total_annual_leaves[0]->id)) {
				foreach ($total_annual_leaves as $tot_ann_levs) {
					$annual_starting_date = $tot_ann_levs->from_date;
					$annual_ending_date = $tot_ann_levs->to_date;
					$anual_days_leave += $tot_ann_levs->days;
					$month_date_began = '01' . '-' . date('m-Y', strtotime($start_date_y_m));
					$month_date_end = $daysInMonth . '-' . date('m-Y', strtotime($start_date_y_m));
					$to_date = strtotime($month_date_began);
					$from_date = strtotime($annual_starting_date);
					$datediff = $from_date - $to_date;
					$mont_diff_date_start = round($datediff / (60 * 60 * 24));

					$to_from_date = strtotime($annual_ending_date);
					$to_ending_date = strtotime($month_date_end);
					$datediff1 = $to_ending_date - $to_from_date;
					$mont_diff_date_end = round($datediff1 / (60 * 60 * 24));

					if ($mont_diff_date_start == 0 && $mont_diff_date_end == 0) {
						$annual_amt_pay += $tot_ann_levs->annua_amt;
					} else {
						if ($mont_diff_date_start > 0 && date('m-Y', strtotime($start_date_y_m)) == date('m-Y', strtotime($annual_starting_date))) {
							$period = new DatePeriod(
								new DateTime($month_date_began),
								new DateInterval('P1D'),
								new DateTime($annual_starting_date)
							);

							foreach ($period as $key => $value) {
								$attendance_date = $value->format('Y-m-d');
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count_new += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count_new += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count_new += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count_new += 0.5;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($r->user_id, $attendance_date);
									$present_count_new += 1;
								} else {
									$absent_count_new += 1;
									//$pcount += 0;
								}
							}
							//Number of days calc
							$total_k = 1;
							$k = 1;
							$extra_amount = 0;
							$tot_days = 0;
							$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
							$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
							$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
							$totol_deduction = $count_l = $hlfcount = $tot_days_lop_new = 0;
							$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($r->user_id, $month_date_began, $annual_starting_date);
							if ($emp_leaves_data->num_rows() > 0) {
								$emp_leaves = $this->Timesheet_model->leave_date_new($r->user_id, $month_date_began, $annual_starting_date);
								foreach ($emp_leaves as $emp_leave) {
									$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
												WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
									$binds = array($emp_leave->employee_id);
									$query = $this->db->query($sql, $binds);
									$tmp = $query->result();
									$amt_deduct = 0;
									if ($emp_leave->leave_type_id == 7) {
										$tot_days_lop_new += $emp_leave->total_leaves;
										$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
									} else if ($emp_leave->leave_type_id == 4) {
										$tot_days_lop_new = $count_remain_again = $count_remain = 0;
										if ($emp_leave->total_leaves > 15) {
											$count_remain = $emp_leave->total_leaves - 15;
											if ($count_remain <= 20) {
												$tot_days_lop_new += $count_remain / 2;
											} else {
												$count_remain_again = $count_remain - 20;
												$tot_days_lop_new += (20 / 2);
												$tot_days_lop_new += $count_remain_again;
											}
											// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
										}
									}
								}
							}
							$working_days = ($absent_count_new + $present_count_new + $holiday_count_new + $public_holiday_count_new + $leave_count_new + $leave__half_day_count_new) - ($tot_days_lop_new + $absent_count_new);
							$diff_start = $mont_diff_date_start;
						} else {
							$diff_start = 0;
						}
						if ($mont_diff_date_end > 0 && date('m-Y', strtotime($start_date_y_m)) == date('m-Y', strtotime($annual_ending_date))) {
							$next_monn_beg = date('d-m-Y', strtotime($month_date_end . ' +1 day'));
							$period = new DatePeriod(
								new DateTime($annual_ending_date),
								new DateInterval('P1D'),
								new DateTime($month_date_end)
							);

							foreach ($period as $key => $value) {
								$attendance_date = $value->format('Y-m-d');
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								$holiday_arr = array();
								$leave_arr = array();
								$half_leave_arr = array();
								//	print_r($user_id);exit;
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count_new += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count_new += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count_new += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count_new += 0.5;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($r->user_id, $attendance_date);
									$present_count_new += 1;
								} else {
									$absent_count_new += 1;
									//$pcount += 0;
								}
							}
							//Number of days calc
							$total_k = 1;
							$k = 1;
							$extra_amount = 0;
							$tot_days = 0;
							$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
							$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
							$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
							$totol_deduction = $count_l = $hlfcount = $tot_days_lop_new = 0;
							$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($r->user_id, $annual_ending_date, $month_date_end);
							if ($emp_leaves_data->num_rows() > 0) {
								$emp_leaves = $this->Timesheet_model->leave_date_new($r->user_id, $annual_ending_date, $month_date_end);
								foreach ($emp_leaves as $emp_leave) {
									$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
													WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
									$binds = array($emp_leave->employee_id);
									$query = $this->db->query($sql, $binds);
									$tmp = $query->result();
									$amt_deduct = 0;
									if ($emp_leave->leave_type_id == 7) {
										$tot_days_lop_new += $emp_leave->total_leaves;
										$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
									} else if ($emp_leave->leave_type_id == 4) {
										$tot_days_lop_new = $count_remain_again = $count_remain = 0;
										if ($emp_leave->total_leaves > 15) {
											$count_remain = $emp_leave->total_leaves - 15;
											if ($count_remain <= 20) {
												$tot_days_lop_new += $count_remain / 2;
											} else {
												$count_remain_again = $count_remain - 20;
												$tot_days_lop_new += (20 / 2);
												$tot_days_lop_new += $count_remain_again;
											}
											// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
										}
									}
								}
							}
							$working_days = ($absent_count_new + $present_count_new + $holiday_count_new + $public_holiday_count_new + $leave_count_new + $leave__half_day_count_new) - ($tot_days_lop_new + $absent_count_new);

							$diff_end = $mont_diff_date_end;
						} else {
							$diff_end = 0;
						}
						$annual_cut_days = $diff_start + $diff_end;
						if ($annual_cut_days == 0) {
							$annual_cut_days = 1;
						} else {
							//	$working_days += $annual_cut_days;
							$annual_cut_days = $daysInMonth - $annual_cut_days;
						}
						if ($tot_ann_levs->annua_amt) {
							$annual_amt_pay_v = $tot_ann_levs->annua_amt / $tot_ann_levs->days;
							$annual_amt_pay += $annual_cut_days * $annual_amt_pay_v;
						} else {
							$annual_amt_pay += 0;
						}
					}
				}

				$days_in_month = date('t', strtotime($this->input->post('month_year')));
				if (!is_null($total_annual_leaves)) {
					$normal_pay_days = $days_in_month - $anual_days_leave;
					$normal_pay_days = $normal_pay_days - $tot_days_lop_normal;
					if ($normal_pay_days >= 0) {
						$normal_pay_days = $normal_pay_days;
					} else {
						$normal_pay_days = 0;
					}
					$net_salary = ($total_net_salary / 30) * $working_days;
				} else {
					$net_salary = ($total_net_salary / 30) * $totl_num_days_pres;
				}
			}

			/* End New Annual Leave Method */

			//end annual leave calc

			//Indemnity calc
			/*$start_date_y = date('m', strtotime($month_year));
				$start_date_y_m = date('Y-m', strtotime($month_year));
				$emp_Indemnity=$this->Employees_model->emp_indemnity_fetch($user_id,$start_date_y);

				$totl_amt = 0;
				if($emp_Indemnity){
					foreach($emp_Indemnity as $emp_leave) {
						$totl_amt += $emp_leave->amount;
					  }
				}*/
			$totl_amt = 0;
			//leave encashment calc
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

			$totl_amt_leva = 0;
			if ($emp_leave_enchas) {
				foreach ($emp_leave_enchas as $emp_leave_ench) {
					$totl_amt_leva += $emp_leave_ench->amount;
				}
			}
			//$net_salary = $net_salary+$totl_amt+$totl_amt_leva+$overtime_amount + $annual_amt_pay;
			$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $annual_amt_pay;
			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary,$r->company_id);
			if ($net_salary < 0) {
				$net_salary = '0.00';
			}
			$iemp_name = $emp_name ;

			//action link
			$act = $detail . $fmpay . $delete;
			if ($r->wages_type == 1) {
				if ($system[0]->is_half_monthly == 1) {
					$emp_payroll_wage = $wages_type ;
				} else {
					$emp_payroll_wage = $wages_type;
				}
			} else {
				$emp_payroll_wage = $wages_type;
			}
			if (in_array('83', $role_resources_ids)) {
				$emp_id = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="Employee Detail">' . $r->employee_id . ' <i class="fas fa-arrow-circle-right"></i></a>';
			} else {
				$emp_id = $r->employee_id;
			}

			$paymonth = date('m', strtotime($pay_date));
			$payyear = date('Y', strtotime($pay_date));

			$total = 0;
			$totaldeduct = 0;
			//$loan_m = date('m', strtotime($p_date));
			$late_totaldetails = $this->Employees_model->getemployeelatedetails($user_id, $paymonth, $payyear);
			$total_work = $this->Employees_model->get_employee_workdone($user_id, $paymonth, $payyear);
			if (isset($late_totaldetails)) {
				foreach ($late_totaldetails as $latedetails) {
					$day = $latedetails->attendance_date;
					$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id, $day);
					$total_work = $this->Employees_model->get_employee_workdone($user_id, $day);
					$latededuction = (float)$latecome_deduct[0]->late_deduction;
					if ($total_work[0]->totalhours < 8 && $total_work[0]->totalhours > 0) {
						$latehours = 8 - round($total_work[0]->totalhours, 2);
						$empdata = $this->Employees_model->get_employee_details($user_id);
						$basepay = $empdata[0]->basic_salary;
						$hourdeduct = round(($basepay / 30) / 8 * $latehours, 3);

						$halfdays = $this->Employees_model->get_halfdays($user_id);
						if (isset($halfdays)) {
							foreach ($halfdays as $row) {

								$startDate = $row->from_date;
								//echo $startDate;
								if ($day == $startDate && $latehours > 4) {
									//$halfday = "yes";
									$latebyhours = 4 - round($total_work[0]->totalhours, 2);
									$hourdeduct = round(($basepay / 30) / 8 * $latebyhours, 3);
								} elseif ($day == $startDate && $latehours <= 4) {
									$hourdeduct = 0;
								}
							}
						}

						$totaldeduct = $hourdeduct + $latededuction;
						$total += $hourdeduct + $latededuction;
					} else {
						$total += $latededuction;
					}
				}
			}

			if (!is_null($total)) {

				//$late_deduct_amt = $totaldeduct;
				$late_deduct_amt = round($total, 3);
			} else {
				$late_deduct_amt = 0;
			}

			$overtime_totalpay = $this->Employees_model->get_employee_overtime_total($user_id, $paymonth, $payyear);
			//$bsalary             = $this->Employees_model->get_employee_salary($user_id);
			//$finalamount         = ($bsalary[0]->basic_salary/30)* $tot_days_lop;
			//$leave_dedc          = number_format($finalamount,2);
			$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
			$otstatus = $overtimestatus[0]->ot_eligible;
			if ($otstatus == "yes") {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary + $overtime_totalpay[0]->totalrate - $late_deduct_amt;
				}
			} else {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary - $late_deduct_amt;
				}
			}

			$days_in_month = $days = date("t");
			//	$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id,$start_date_y_m);
			$companybank = $this->Xin_model->get_company_bankdetails();
			$companyaccno = $companybank[0]->account_no;
			/*  $bankdetails  =  $this->Employees_model->get_bank_details($user_id);
			$bankcode     =  $bankdetails[0]->bank_code;
			$bankname     =  $bankdetails[0]->bank_name;*/

			$total_amount += $nettotal;
			//echo $nettotal;

		}
		$res["salary_month"] = $p_date;
		$res["bankaccount"] = $companyaccno;
		$res["nettotal"] = $total_amount;


		if (isset($_POST['pdfdownload'])) {
			$this->load->library('dpdf');
			$html = $this->load->view("admin/payroll/coverletter_format", $res, true);
			$this->dpdf->createPDF($html, 'coverletter', true);
		} elseif (isset($_POST['worddownload'])) {
			$this->load->library('HTML_TO_DOC');
			//Initialize class
			$htd = new HTML_TO_DOC();
			$html = '<table class="table table-striped table-hover">
        <tbody><tr><td>Bank Account Number</td><td>' . $res["bankaccount"] . '</td></tr>
        <tr><td>Salary for the month</td><td>' . $res["salary_month"] . '</td></tr>
        <tr><td>Total Amount</td><td>' . $this->Xin_model->currency_sign($res["nettotal"]) . '</td></tr><tbody></table>';
			$htd->createDoc($html, 'htmldoc', true);
		}
	}


	public function management_approval()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Management Approval | ' . $this->Xin_model->site_title();
		//$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = 'Management Approval';
		$data['all_locations'] = $this->Xin_model->all_company_locations();
		$data['path_url'] = 'management_approval';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('272', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/payroll/management_approval", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function management_payroll_approval()
	{
		$location_id = $this->input->post('location_id');
		$month_year = $this->input->post('month_year');
		$count = $this->Payroll_model->get_management_approval_count($location_id, $month_year);
		if ($count == 0) {
			$data = array(
				'location_id' => $location_id,
				'month_year' => $month_year,
				'status' => $this->input->post('status')

			);
			$this->Payroll_model->add_management_approval($data);
		}
		redirect('admin/payroll/bank_format');
	}

	public function management_approval_list()
	{
	    ini_set('max_execution_time', '1000');
		error_reporting(0);

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		// date and employee id/company id
		$p_date = $this->input->get("month_year");
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('275', $role_resources_ids)) {
			$payslip = $this->Payroll_model->get_management_approval_list($this->input->get("location_id"), $p_date);
			$payslip_count = count($payslip);
		} else {
			$payslip = '';
			$payslip_count = 0;
		}
		$system = $this->Xin_model->read_setting_info(1);
		$data = array();
		if (!empty($payslip)) {
			foreach ($payslip as $r) {
				// user full name
				$emp_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
				$full_name = '<a target="_blank" class="text-primary" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '">' . $emp_name . '</a>';

				// get total hours > worked > employee
				$pay_date = $this->input->get('month_year');
				//overtime request
				$overtime_count = $this->Overtime_request_model->get_overtime_request_count($r->user_id, $this->input->get('month_year'));
				$re_hrs_old_int1 = 0;
				$re_hrs_old_seconds = 0;
				$re_pcount = 0;
				foreach ($overtime_count as $overtime_hr) {
					// total work
					$request_clock_in = new DateTime($overtime_hr->request_clock_in);
					$request_clock_out = new DateTime($overtime_hr->request_clock_out);
					$re_interval_late = $request_clock_in->diff($request_clock_out);
					$re_hours_r = $re_interval_late->format('%h');
					$re_minutes_r = $re_interval_late->format('%i');
					$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

					$re_str_time = $re_total_time;

					$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

					sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

					$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

					$re_hrs_old_int1 += $re_hrs_old_seconds;

					$re_pcount = gmdate("H", $re_hrs_old_int1);
				}
				$result = $this->Payroll_model->total_hours_worked($r->user_id, $pay_date);
				$hrs_old_int1 = 0;
				$pcount = 0;
				$Trest = 0;
				$total_time_rs = 0;
				$hrs_old_int_res1 = 0;
				foreach ($result->result() as $hour_work) {
					// total work
					$clock_in = new DateTime($hour_work->clock_in);
					$clock_out = new DateTime($hour_work->clock_out);
					$interval_late = $clock_in->diff($clock_out);
					$hours_r = $interval_late->format('%h');
					$minutes_r = $interval_late->format('%i');
					$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

					$str_time = $total_time;

					$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

					sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

					$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

					$hrs_old_int1 += $hrs_old_seconds;

					$pcount = gmdate("H", $hrs_old_int1);
				}
				$pcount = $pcount + $re_pcount;
				// get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// 1: salary type
				if ($r->wages_type == 1) {
					$wages_type = $this->lang->line('xin_payroll_basic_salary');
					if ($system[0]->is_half_monthly == 1) {
						$basic_salary = $r->basic_salary / 2;
					} else {
						$basic_salary = $r->basic_salary;
					}
					$p_class = 'emo_monthly_pay';
					$view_p_class = 'payroll_template_modal';
				} else if ($r->wages_type == 2) {
					$wages_type = $this->lang->line('xin_employee_daily_wages');
					if ($pcount > 0) {
						$basic_salary = $pcount * $r->basic_salary;
					} else {
						$basic_salary = $pcount;
					}
					$p_class = 'emo_hourly_pay';
					$view_p_class = 'hourlywages_template_modal';
				} else {
					$wages_type = $this->lang->line('xin_payroll_basic_salary');
					if ($system[0]->is_half_monthly == 1) {
						$basic_salary = $r->basic_salary / 2;
					} else {
						$basic_salary = $r->basic_salary;
					}
					$p_class = 'emo_monthly_pay';
					$view_p_class = 'payroll_template_modal';
				}
				// all allowances, all loan/deductions
				$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($r->user_id, $p_date, $basic_salary);
				$salary_calc = $this->Xin_model->payroll_GrossSalary($r->user_id, $p_date, $basic_salary, $all_allo_and_dedct);
				$total_net_salary = $salary_calc[0];
				// make payment
				//   var_dump($system[0]->is_half_monthly);die();
				$status_pay_value = 0;
				if ($system[0]->is_half_monthly == 1) {
					$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($r->user_id, $p_date);
					$payment_last = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($r->user_id, $p_date);
					if ($payment_check->num_rows() > 1) {
						//foreach($payment_last as $payment_half_last){
						$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
						$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

						$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
						$status_pay_value = 1;
						//$mpay = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_payroll_make_payment').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".'.$p_class.'" data-employee_id="'. $r->user_id . '" data-payment_date="'. $p_date . '" data-company_id="'.$this->input->get("company_id").'"><span class="far fa-money-bill-alt"></span></button></span>';
						$mpay = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
						if (in_array('273', $role_resources_ids)) {
							$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
						} else {
							$delete = '';
						}
						$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code><br>' . '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $payment_last[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span><code>' . $this->lang->line('xin_title_second_half') . '</code>';
						//}
						//detail link
						$detail = '';
						$total_net_salary = $make_payment[0]->net_salary;
					} else if ($payment_check->num_rows() > 0) {
						$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
						$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

						$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
						$status_pay_value = 1;
						$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
						$mpay .= '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
						if (in_array('273', $role_resources_ids)) {
							$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
						} else {
							$delete = '';
						}
						$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code>';
						$detail = '';
						$total_net_salary = $make_payment[0]->net_salary;
					} else {
						$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
						$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
						$delete = '';
						//detail link
						$detail = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $pay_date . '"><span class="fa fa-eye"></span></button></span>';

						$total_net_salary = $total_net_salary;
					}
					//detail link
					//$detail = '';
				} else {
					$payment_check = $this->Payroll_model->read_make_payment_payslip_check($r->user_id, $p_date);
					if ($payment_check->num_rows() > 0) {
						$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
						$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

						$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
						$status_pay_value = 1;
						$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
						if (in_array('273', $role_resources_ids)) {
							$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
						} else {
							$delete = '';
						}
						//$total_net_salary = $make_payment[0]->net_salary;
					} else {
						$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
						$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
						$delete = '';
						$total_net_salary = $total_net_salary;
					}
					//detail link
					if (in_array('276', $role_resources_ids)) {
						$detail = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '"" data-net="' . $total_net_salary . '"><span class="fa fa-eye"></span></button></span>';
					} else {
						$detail  = '';
					}
				}

				$net_salary = number_format((float)$total_net_salary, 2, '.', '');
				$basic_salary = number_format((float)$basic_salary, 2, '.', '');
				//}

				if ($basic_salary == 0 || $basic_salary == '') {
					$fmpay = '';
				} else {
					$fmpay = $mpay;
				}

				//new leave calc
				$month_year = $pay_date;
				$start_date_y = date('m', strtotime($month_year));
				$start_date_y_m = date('Y-m', strtotime($month_year));
				$emp_leaves = $this->Employees_model->emp_leave_fetch($r->user_id, $start_date_y);

				$user_id = $r->user_id;
				$date = strtotime(date("Y-m-d"));
				if (!isset($month_year)) {
					$day = date('d', $date);
					$month = date('m', $date);
					$year = date('Y', $date);
					$month_year = date('Y-m');
				} else {
					$imonth_year = explode('-', $month_year);
					$day = date('d', $date);
					$month = date($imonth_year[1], $date);
					$year = date($imonth_year[0], $date);
					$month_year = $month_year;
				}
				$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
				$k = 1;
				$extra_amount = $tot_days_lop_normal = 0;
				$tot_days = 0;

				//Using attendance
				$arry_years = array();
				$st = '';
				$p_count_val = 0;
				$start_date_co = $year . '-' . $month . '-' . '01';
				$end_date_co = $year . '-' . $month . '-' . $daysInMonth;


				$present_arr = array();
				//$st = $this->db->last_query();
				$leave_arr = $half_leave_arr = array();
				$total_leaves = count($leave_arr) + count($half_leave_arr);
				$p_count_val += abs($total_leaves - $tot_days);
				$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
				$absent_count = 0;
				$leave_count = 0;
				$user = $this->Xin_model->read_user_info($r->user_id);
				if (strtotime($month_year) == strtotime(date('Y-m'))) {
					$month_year_att = $month_year . '-01';
					if ($user[0]->date_of_leaving) {
						if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
							if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
								$difference_days = 0;
							} else {
								$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
								if ($get_attendance_last_entered) {
									$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
									//$month_year_att_end = $month_year.'-'.date('d');
									$startDate = new DateTime($month_year_att);
									$endDate = new DateTime($month_year_att_end);
									$difference = $endDate->diff($startDate);
									$difference_days = $difference->format("%a") + 1;
								} else {
									$difference_days = 0;
								}
							}
						} else {
							$difference_days = 0;
						}
					} else {
						$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
						if ($get_attendance_last_entered) {
							$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
							//$month_year_att_end = $month_year.'-'.date('d');
							$startDate = new DateTime($month_year_att);
							$endDate = new DateTime($month_year_att_end);
							$difference = $endDate->diff($startDate);
							$difference_days = $difference->format("%a") + 1;
						} else {
							$difference_days = 0;
						}
					}
				} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
					$month_year_att = $month_year . '-01';
					$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
					if ($get_attendance_last_entered) {
						$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
						//$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days = $difference->format("%a") + 1;
					} else {
						$difference_days = 0;
					}
				} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
					$difference_days = 0;
				}
				if ($difference_days >= 25) {
					$difference_days = $daysInMonth;
				}


				$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

				//Number of days calc
				$total_k = 1;
				$k = 1;
				$extra_amount = 0;
				$tot_days = 0;
				$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
				$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
				$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
				$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

				//end number of calc
				$attendence_calc = $this->Xin_model->AttendnceCount_calc_common($r->office_shift_id, $start_date_co, $end_date_co, $r->company_id, $r->user_id, $difference_days, $year, $month);
				if ($attendence_calc) {
					$tot_days_lop_normal = $attendence_calc[0];
					$totl_num_days_pres = $attendence_calc[1];
				} else {
					$tot_days_lop_normal = 0;
					$totl_num_days_pres = 0;
				}
				$tot_days_lop = $tot_days_lop_normal;

				$bs_pay = $r->basic_salary;
				/* Net salary calculations */
				$net_salary_calc = $this->Xin_model->NetsalaryCalcCommon($total_net_salary, $daysInMonth, $totl_num_days_pres);
				$net_salary = $net_salary_calc[0];


				/* Lop Calc Common */
				$lop_calc = $this->Xin_model->LopCalcCommon($net_salary, $daysInMonth, $tot_days_lop);
				$leave_cut_salary = $lop_calc[0];
				/* End Lop calc Common */

				/* Final Net salary */
				$final_net_salary = $this->Xin_model->FinalNetSalaryCalcCommon($net_salary, $leave_cut_salary, $all_allo_and_dedct);
				$net_salary = $final_net_salary[0];

				$start_date_y_m = date('Y-m', strtotime($month_year));

				$totl_amt = 0;
				//leave encashment calc
				$start_date_y = date('m', strtotime($month_year));
				$start_date_y_m = date('Y-m', strtotime($month_year));
				$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

				$totl_amt_leva = $annual_amt_pay = 0;
				if ($emp_leave_enchas) {
					foreach ($emp_leave_enchas as $emp_leave_ench) {
						$totl_amt_leva += $emp_leave_ench->amount;
					}
				}
				
				$encashment = $this->Payroll_model->GetEncashmentamount($user_id, $start_date_y_m);
            	foreach ($encashment as $emp_leave) {
            		if ($emp_leave->given_methode == 'Connect_To_Payroll') {
            			$annual_amt_pay += $emp_leave->amount;
            		}
            	}
        	
				$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $annual_amt_pay;

				$basic_salary = $this->Xin_model->company_currency_sign($basic_salary,$r->company_id);
				if ($net_salary < 0) {
					$net_salary = '0.00';
				}
				$iemp_name = $emp_name;

				//action link
				$act = $detail . $fmpay . $delete;
				if ($r->wages_type == 1) {
					if ($system[0]->is_half_monthly == 1) {
						$emp_payroll_wage = $wages_type;
					} else {
						$emp_payroll_wage = $wages_type;
					}
				} else {
					$emp_payroll_wage = $wages_type;
				}
				if (in_array('83', $role_resources_ids)) {
					$emp_id = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="Employee Detail">' . $r->employee_id . ' <i class="fas fa-arrow-circle-right"></i></a>';
				} else {
					$emp_id = $r->employee_id;
				}

				$paymonth = date('m', strtotime($pay_date));
				$payyear = date('Y', strtotime($pay_date));
				$empdata = $this->Employees_model->get_employee_details($user_id);
				$basepay = $empdata[0]->basic_salary;
				$no_of_days = date('t', strtotime($pay_date));


				$latededuction = $this->Payroll_model->GetLateDeductionCalcCommon($user_id, $paymonth, $payyear, $no_of_days);
				$late_amount = $latededuction[0];
				$userinfo = $this->Employees_model->get_employee_details($user_id);
				$companyinfo = $this->Employees_model->get_company_details($userinfo[0]->company_id);
				$late_status = $companyinfo[0]->late_deduction;
				if ($late_status == 'yes') {
					$late_amount = $late_amount;
				} else {
					$late_amount = 0;
				}

				// Get Overtime Amount
				$overtime = $this->Payroll_model->GetOvertimeCalcCommon($user_id, $paymonth, $payyear);
				$overtime_amount = $overtime[0];
				// End Overtime Amount

				// Air ticket Encashment Start
				$encashment_check = $this->Employees_model->employee_encashment_check($user_id, $month_year);
				if (!empty($encashment_check)) {
					$encashstatus = $encashment_check[0]->status;
					if (!is_null($encashstatus)) {
						$encashrate = $this->Employees_model->get_employee_encashrate_payroll($user_id, $month_year);
						$encash_amt = $encashrate[0]->amount;
					} else {
						$encash_amt = 0;
					}
				} else {
					$encash_amt = 0;
				}

				// Air ticket Encashment End
				//$nettotal = $net_salary;
				$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
				$otstatus = $overtimestatus[0]->ot_eligible;
				if ($otstatus == "yes") {
					if ($net_salary == 0) {
						$nettotal = 0.000;
					} else {
						$nettotal = $net_salary + $overtime_amount - $late_amount;
					}
				} else {
					if ($net_salary == 0) {
						$nettotal = 0.000;
					} else {
						$nettotal = $net_salary - $late_amount;
					}
				}


				/* Expense Claim Start */
				if ($nettotal > 0) {
					$expense_total_claim = $this->Xin_model->FindExpenseClaimTotal($user_id, $this->input->get('month_year'));
					$nettotal = $nettotal + $expense_total_claim + $encash_amt;
				}
				/* Expense Claim End */
				$nettotal_salary = $nettotal;
				$nettotal = $this->Xin_model->company_currency_sign($nettotal,$r->company_id);


				$location_id = $r->location_id;
				$monthyear = $payyear . "-" . $paymonth;
				$get_management_status = $this->Employees_model->get_management_employee_status($r->user_id, $location_id, $p_date);


				$days_in_month = $days = date("t");

				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($user_id, $p_date);
				if ($payment_check->num_rows() > 0) {

					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$nettotal = $this->Xin_model->company_currency_sign($make_payment[0]->net_salary,$r->company_id);
					$nettotal_salary = $make_payment[0]->net_salary;
				}
				$management_status_val = 1;
				if (empty($get_management_status)) {
					$management_status_val = 1;
					$disable = '';
					if ($nettotal_salary <= 0) {
						$disable = 'disabled';
					} else {
						$disable = 'checked';
					}
					$management_status = '<input type="checkbox" class="editor-active check_management_status" name="status_val" value="' . $r->user_id . '" ' . $disable . '>';
				} else {
					$management_status_val = 0;
					$management_status = '<input type="checkbox" class="editor-active check_management_status" name="status_val" value="' . $r->user_id . '" checked>';
				}
				$current_month = date('Y-m');
				$search_month = date('Y-m', strtotime($month_year));
				if (strtotime($search_month) > strtotime($current_month)) {
					$nettotal = $this->Xin_model->company_currency_sign(0,$r->company_id);
				}

				//	$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id,$start_date_y_m);
				if ($status_pay_value < 1 && $management_status_val > 0) {
					if (in_array('276', $role_resources_ids) || in_array('273', $role_resources_ids)) {
						$data[] = array(

							$emp_id,
							$iemp_name,
							$emp_payroll_wage,
							$basic_salary,
							$nettotal,
							$status_pay,
							$management_status,
							$act,
						);
					} else {
						$data[] = array(
							$emp_id,
							$iemp_name,
							$emp_payroll_wage,
							$basic_salary,
							$nettotal,
							$status_pay,
							$management_status
						);
					}
				}
			}
			if (sizeof($data) > 0) {
				usort($data, function ($a, $b) {
					return $a[5] > $b[5];
				});
			}
		}


		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip_count,
			"recordsFiltered" => $payslip_count,
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function management_payroll_approval_status_change()
	{
		$location_id = $this->input->post('e_location_id');
		$month_year = $this->input->post('e_month_year');
		$checked_ids = $this->input->post('e_checked_ids');
		if (!empty($checked_ids)) {
			//$this->Payroll_model->delete_management_payroll_approvals_items($location_id,$month_year);
			$approved_employees_ids = explode(',', $checked_ids);
			foreach ($approved_employees_ids as $employee_id) {
				$employee_detail = $this->Employees_model->read_employee_information($employee_id);
				if (!empty($employee_detail)) {
					$data = array(
						'employee_id' => $employee_id,
						'location_id' => $employee_detail[0]->location_id,
						'month_year' => $month_year,
						'status' => 'Approved'
					);
					$this->Payroll_model->add_management_approval($data);
				}
			}
			redirect('admin/payroll/bank_format/' . $month_year);
		} else {
			redirect('admin/payroll/management_approval');
		}
	}


	// payment history
	public function payment_history()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_payslip_history');
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['breadcrumbs'] = $this->lang->line('xin_payslip_history');
		$data['path_url'] = 'payment_history';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('287', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/payroll/payment_history", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// advance salary
	public function advance_salary()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$role_id = '';
		if (!empty($session)) {
			$role_id = $this->Xin_model->user_role_name($session['user_id']);
		}
		$data['title'] = $this->lang->line('xin_advanced') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = $this->lang->line('xin_advanced');
		$data['path_url'] = 'advance_salary';
		$data['role_id'] = $role_id;
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('383', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/payroll/advance_salary", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// advance salary report
	public function advance_salary_report()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_advance_salary_report') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = $this->lang->line('xin_advance_salary_report');
		$data['path_url'] = 'advance_salary_report';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('468', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/payroll/advance_salary_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// payslip > employees
	public function payslip_list_bk123()
	{
		error_reporting(0);

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/generate_payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		// date and employee id/company id
		$p_date = $this->input->get("month_year");
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('279', $role_resources_ids)) {
			if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") == 0) {
				$payslip = $this->Employees_model->get_employees_payslip();
			} else if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") != 0) {
				$payslip = $this->Payroll_model->get_comp_template($this->input->get("company_id"), 0);
			} else if ($this->input->get("employee_id") != 0 && $this->input->get("company_id") != 0) {
				$payslip = $this->Payroll_model->get_employee_comp_template($this->input->get("company_id"), $this->input->get("employee_id"));
			} else {
				$payslip = $this->Employees_model->get_employees_payslip();
			}
		} else {
			$payslip = $this->Payroll_model->get_employee_comp_template($user_info[0]->company_id, $session['user_id']);
		}
		$system = $this->Xin_model->read_setting_info(1);
		$data = array();

		foreach ($payslip->result() as $r) {
			// user full name
			$emp_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			$full_name = '<a target="_blank" class="text-primary" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '">' . $emp_name . '</a>';

			// get total hours > worked > employee
			$pay_date = $this->input->get('month_year');
			//overtime request
			$overtime_count = $this->Overtime_request_model->get_overtime_request_count($r->user_id, $this->input->get('month_year'));
			$re_hrs_old_int1 = 0;
			$re_hrs_old_seconds = 0;
			$re_pcount = 0;
			foreach ($overtime_count as $overtime_hr) {
				// total work
				$request_clock_in = new DateTime($overtime_hr->request_clock_in);
				$request_clock_out = new DateTime($overtime_hr->request_clock_out);
				$re_interval_late = $request_clock_in->diff($request_clock_out);
				$re_hours_r = $re_interval_late->format('%h');
				$re_minutes_r = $re_interval_late->format('%i');
				$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

				$re_str_time = $re_total_time;

				$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

				sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$re_hrs_old_int1 += $re_hrs_old_seconds;

				$re_pcount = gmdate("H", $re_hrs_old_int1);
			}
			$result = $this->Payroll_model->total_hours_worked($r->user_id, $pay_date);
			$hrs_old_int1 = 0;
			$pcount = 0;
			$Trest = 0;
			$total_time_rs = 0;
			$hrs_old_int_res1 = 0;
			foreach ($result->result() as $hour_work) {
				// total work
				$clock_in = new DateTime($hour_work->clock_in);
				$clock_out = new DateTime($hour_work->clock_out);
				$interval_late = $clock_in->diff($clock_out);
				$hours_r = $interval_late->format('%h');
				$minutes_r = $interval_late->format('%i');
				$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

				$str_time = $total_time;

				$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

				sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$hrs_old_int1 += $hrs_old_seconds;

				$pcount = gmdate("H", $hrs_old_int1);
			}
			$pcount = $pcount + $re_pcount;
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// 1: salary type
			if ($r->wages_type == 1) {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			} else if ($r->wages_type == 2) {
				$wages_type = $this->lang->line('xin_employee_daily_wages');
				if ($pcount > 0) {
					$basic_salary = $pcount * $r->basic_salary;
				} else {
					$basic_salary = $pcount;
				}
				$p_class = 'emo_hourly_pay';
				$view_p_class = 'hourlywages_template_modal';
			} else {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			}
			// 2: all allowances
			$salary_allowances = $this->Employees_model->read_salary_allowances_with_status($r->user_id);
			$count_allowances = $this->Employees_model->count_employee_allowances_with_status($r->user_id);
			$allowance_amount = 0;
			if ($count_allowances > 0) {
				foreach ($salary_allowances as $sl_allowances) {
					if ($system[0]->is_half_monthly == 1) {
						if ($system[0]->half_deduct_month == 2) {
							$eallowance_amount = $sl_allowances->allowance_amount / 2;
						} else {
							$eallowance_amount = $sl_allowances->allowance_amount;
						}
						$allowance_amount += $eallowance_amount;
					} else {
						//$eallowance_amount = $sl_allowances->allowance_amount;
						if ($sl_allowances->is_allowance_taxable == 1) {
							if ($sl_allowances->amount_option == 0) {
								$iallowance_amount = $sl_allowances->allowance_amount;
							} else {
								$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
							}
							$allowance_amount -= $iallowance_amount;
						} else if ($sl_allowances->is_allowance_taxable == 2) {
							if ($sl_allowances->amount_option == 0) {
								$iallowance_amount = $sl_allowances->allowance_amount / 2;
							} else {
								$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
							}
							$allowance_amount -= $iallowance_amount;
						} else {
							if ($sl_allowances->amount_option == 0) {
								$iallowance_amount = $sl_allowances->allowance_amount;
							} else {
								$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
							}
							$allowance_amount += $iallowance_amount;
						}
					}
				}
			} else {
				$allowance_amount = 0;
			}

			// 3: all loan/deductions
			$loan_m = date('m', strtotime($p_date));
			$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions_with_status($r->user_id, $loan_m);
			$count_loan_deduction = $this->Employees_model->count_employee_deductions_with_status($r->user_id, $loan_m);
			$loan_de_amount = 0;
			if ($count_loan_deduction > 0) {
				foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
					/*if($system[0]->is_half_monthly==1){
					  	  if($system[0]->half_deduct_month==2){
							  $er_loan = $sl_salary_loan_deduction->loan_deduction_amount/2;
						  } else {
							  $er_loan = $sl_salary_loan_deduction->loan_deduction_amount;
						  }
                     	 } else {
						  $er_loan = $sl_salary_loan_deduction->loan_deduction_amount;
                      	}*/
					$get_loan_distrbutions = $this->Employees_model->get_employee_loan_distrubtion($r->user_id, $sl_salary_loan_deduction->loan_deduction_id);
					if ($get_loan_distrbutions) {
						foreach ($get_loan_distrbutions as $distr) {
							if ($distr->month_year == $pay_date) {
								$loan_de_amount += $distr->amount;
							}
						}
					} else {
						$loan_de_amount += 0;
					}
					//$loan_de_amount += $er_loan;
				}
			} else {
				$loan_de_amount = 0;
			}

			// commissions
			$count_commissions = $this->Employees_model->count_employee_commissions_with_status($r->user_id);
			$commissions = $this->Employees_model->set_employee_commissions_with_status($r->user_id);
			$commissions_amount = 0;
			if ($count_commissions > 0) {
				foreach ($commissions->result() as $sl_salary_commissions) {
					if ($system[0]->is_half_monthly == 1) {
						if ($system[0]->half_deduct_month == 2) {
							$ecommissions_amount = $sl_salary_commissions->commission_amount / 2;
						} else {
							$ecommissions_amount = $sl_salary_commissions->commission_amount;
						}
						$commissions_amount += $ecommissions_amount;
					} else {
						// $ecommissions_amount = $sl_salary_commissions->commission_amount;
						if ($sl_salary_commissions->is_commission_taxable == 1) {
							if ($sl_salary_commissions->amount_option == 0) {
								$ecommissions_amount = $sl_salary_commissions->commission_amount;
							} else {
								$ecommissions_amount = $basic_salary / 100 * $sl_salary_commissions->commission_amount;
							}
							$commissions_amount -= $ecommissions_amount;
						} else if ($sl_salary_commissions->is_commission_taxable == 2) {
							if ($sl_salary_commissions->amount_option == 0) {
								$ecommissions_amount = $sl_salary_commissions->commission_amount / 2;
							} else {
								$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_salary_commissions->commission_amount;
							}
							$commissions_amount -= $ecommissions_amount;
						} else {
							if ($sl_salary_commissions->amount_option == 0) {
								$ecommissions_amount = $sl_salary_commissions->commission_amount;
							} else {
								$ecommissions_amount = $basic_salary / 100 * $sl_salary_commissions->commission_amount;
							}
							$commissions_amount += $ecommissions_amount;
						}
					}
				}
			} else {
				$commissions_amount = 0;
			}
			// otherpayments
			$count_other_payments = $this->Employees_model->count_employee_other_payments_with_status($r->user_id);
			$other_payments = $this->Employees_model->set_employee_other_payments_with_status($r->user_id);
			$other_payments_amount = 0;
			if ($count_other_payments > 0) {
				foreach ($other_payments->result() as $sl_other_payments) {
					if ($system[0]->is_half_monthly == 1) {
						if ($system[0]->half_deduct_month == 2) {
							$epayments_amount = $sl_other_payments->payments_amount / 2;
						} else {
							$epayments_amount = $sl_other_payments->payments_amount;
						}
						$other_payments_amount += $epayments_amount;
					} else {
						// $epayments_amount = $sl_other_payments->payments_amount;
						if ($sl_other_payments->is_otherpayment_taxable == 1) {
							if ($sl_other_payments->amount_option == 0) {
								$epayments_amount = $sl_other_payments->payments_amount;
							} else {
								$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
							}
							$other_payments_amount -= $epayments_amount;
						} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
							if ($sl_other_payments->amount_option == 0) {
								$epayments_amount = $sl_other_payments->payments_amount / 2;
							} else {
								$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
							}
							$other_payments_amount -= $epayments_amount;
						} else {
							if ($sl_other_payments->amount_option == 0) {
								$epayments_amount = $sl_other_payments->payments_amount;
							} else {
								$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
							}
							$other_payments_amount += $epayments_amount;
						}
					}
				}
			} else {
				$other_payments_amount = 0;
			}
			// statutory_deductions
			$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions_with_status($r->user_id);
			$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_with_status($r->user_id);
			$statutory_deductions_amount = 0;
			if ($count_statutory_deductions > 0) {
				foreach ($statutory_deductions->result() as $sl_salary_statutory_deductions) {
					if ($system[0]->is_half_monthly == 1) {
						if ($system[0]->half_deduct_month == 2) {
							$single_sd = $sl_salary_statutory_deductions->deduction_amount / 2;
						} else {
							$single_sd = $sl_salary_statutory_deductions->deduction_amount;
						}
						$statutory_deductions_amount += $single_sd;
					} else {
						//$single_sd = $sl_salary_statutory_deductions->deduction_amount;
						if ($sl_salary_statutory_deductions->statutory_options == 0) {
							$single_sd = $sl_salary_statutory_deductions->deduction_amount;
						} else {
							$single_sd = $basic_salary / 100 * $sl_salary_statutory_deductions->deduction_amount;
						}
						$statutory_deductions_amount += $single_sd;
					}
				}
			} else {
				$statutory_deductions_amount = 0;
			}

			// 5: overtime
			$salary_overtime = $this->Employees_model->read_salary_overtime($r->user_id);
			$count_overtime = $this->Employees_model->count_employee_overtime($r->user_id);
			$overtime_amount = 0;
			if ($count_overtime > 0) {
				foreach ($salary_overtime as $sl_overtime) {
					if ($system[0]->is_half_monthly == 1) {
						if ($system[0]->half_deduct_month == 2) {
							$eovertime_hours = $sl_overtime->overtime_hours / 2;
							$eovertime_rate = $sl_overtime->overtime_rate / 2;
						} else {
							$eovertime_hours = $sl_overtime->overtime_hours;
							$eovertime_rate = $sl_overtime->overtime_rate;
						}
					} else {
						$eovertime_hours = $sl_overtime->overtime_hours;
						$eovertime_rate = $sl_overtime->overtime_rate;
					}
					$overtime_total = $eovertime_hours * $eovertime_rate;
					//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
					$overtime_amount += $overtime_total;
				}
			} else {
				$overtime_amount = 0;
			}
			//6.Leave deduction


			// saudi gosi
			if ($system[0]->enable_saudi_gosi != 0) {
				$gois_amn = $basic_salary + $allowance_amount;
				$enable_saudi_gosi = $gois_amn / 100 * $system[0]->enable_saudi_gosi;
				$saudi_gosi = $enable_saudi_gosi;
			} else {
				$saudi_gosi = 0;
			}
			// add amount
			//	$total_earning = $basic_salary + $allowance_amount + $overtime_amount + $commissions_amount + $other_payments_amount + $saudi_gosi;
			$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount + $saudi_gosi;
			$total_deduction = $loan_de_amount + $statutory_deductions_amount;
			$total_net_salary = $total_earning - $total_deduction;
			$net_salary = $total_net_salary;
			$advance_amount = 0;
			// get advance salary
			$advance_salary = $this->Payroll_model->advance_salary_by_employee_id($r->user_id);
			$emp_value = $this->Payroll_model->get_paid_salary_by_employee_id($r->user_id);

			if (!is_null($advance_salary)) {
				/*$monthly_installment = $advance_salary[0]->monthly_installment;
					$advance_amount = $advance_salary[0]->advance_amount;
					$total_paid = $advance_salary[0]->total_paid;
					//check ifpaid
					$em_advance_amount = $advance_salary[0]->advance_amount;
					$em_total_paid = $advance_salary[0]->total_paid;

					if($em_advance_amount > $em_total_paid){
						if($monthly_installment=='' || $monthly_installment==0) {

							$ntotal_paid = $emp_value[0]->total_paid;
							$nadvance = $emp_value[0]->advance_amount;
							$i_net_salary = $nadvance - $ntotal_paid;
							//$pay_amount = $net_salary - $i_net_salary;
							$advance_amount = $i_net_salary;
						} else {
							//
							$re_amount = $em_advance_amount - $em_total_paid;
							if($monthly_installment > $re_amount){
								$advance_amount = $re_amount;
								//$total_net_salary = $net_salary - $re_amount;
								$pay_amount = $net_salary - $re_amount;
							} else {
								$advance_amount = $monthly_installment;
								//$total_net_salary = $net_salary - $monthly_installment;
								$pay_amount = $net_salary - $monthly_installment;
							}
						}

					} else {
						$i_net_salary = $net_salary - 0;
						$pay_amount = $net_salary - 0;
						$advance_amount = 0;
					}
					*/
				foreach ($advance_salary as $val_adv) {
					$get_advance_distrbutions = $this->Payroll_model->get_employee_advance_salary_distrubtion($r->user_id, $val_adv->advance_salary_id);
					if ($get_advance_distrbutions) {
						foreach ($get_advance_distrbutions as $distr) {
							if ($distr->month_year == $pay_date) {
								$advance_amount += $distr->amount;
							}
						}
					} else {
						$advance_amount += 0;
					}
				}
			} else {
				$pay_amount = $net_salary - 0;
				$i_net_salary = $net_salary - 0;
				$advance_amount = 0;
			}
			$total_net_salary = $total_net_salary - $advance_amount;

			//	$net_salary = $fnet_salary - $loan_de_amount;

			//$basic_salary_cal = $basic_salary * $current_rate;

			//$allinfo = $basic_salary  .' - '.  $allowance_amount  .' - '.  $all_other_payment  .' - '.  $loan_de_amount  .' - '.  $overtime_amount  .' - '.  $statutory_deductions; // for testing purpose
			// make payment
			if ($system[0]->is_half_monthly == 1) {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($r->user_id, $p_date);
				$payment_last = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($r->user_id, $p_date);
				if ($payment_check->num_rows() > 1) {
					//foreach($payment_last as $payment_half_last){
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					//$mpay = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_payroll_make_payment').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".'.$p_class.'" data-employee_id="'. $r->user_id . '" data-payment_date="'. $p_date . '" data-company_id="'.$this->input->get("company_id").'"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('273', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code><br>' . '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $payment_last[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span><code>' . $this->lang->line('xin_title_second_half') . '</code>';
					//}
					//detail link
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay .= '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('273', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code>';
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					//detail link
					$detail = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $pay_date . '"><span class="fa fa-eye"></span></button></span>';

					$total_net_salary = $total_net_salary;
				}
				//detail link
				//$detail = '';
			} else {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($r->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('273', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					//$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					$total_net_salary = $total_net_salary;
				}
				//detail link
				$detail = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '"" data-net="' . $total_net_salary . '"><span class="fa fa-eye"></span></button></span>';
			}

			$net_salary = number_format((float)$total_net_salary, 2, '.', '');
			$basic_salary = number_format((float)$basic_salary, 2, '.', '');
			//}

			if ($basic_salary == 0 || $basic_salary == '') {
				$fmpay = '';
			} else {
				$fmpay = $mpay;
			}
			
			//leave calculation
			/*	$extra_amount = 0;
				$month_year=$pay_date;
				$start_date_y = date('Y', strtotime($month_year));
           		$start_date_y_m = date('Y-m', strtotime($month_year));
           		$emp_leave=$this->Employees_model->emp_leave($r->user_id,$start_date_y);
           		$user_id=$r->user_id;
           		$date = strtotime(date("Y-m-d"));
                  if(!isset($month_year)){
                    $day = date('d', $date);
                    $month = date('m', $date);
                    $year = date('Y', $date);
                    $month_year = date('Y-m');
                  } else {
                    $imonth_year = explode('-',$month_year);
                    $day = date('d', $date);
                    $month = date($imonth_year[1], $date);
                    $year = date($imonth_year[0], $date);
                    $month_year = $month_year;
                  }
                  $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
                  $emp_leave_in_year_count =$extra_in_month= $total_final=$final_amount=0;
                  if($emp_leave){
				  	$month_year_end = date("Y-m-t", strtotime("$month_year-02"));
                	$totol_deduction = $count_l =$hlfcount =0;
                		foreach($emp_leave as $emp_leave) {
                    		$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id,$start_date_y_m,$emp_leave->leave_type_id);
                 		 	$sql="Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
                                    WHERE employee_id=? and p.leave_type_id='".$emp_leave->leave_type_id."' and p.created_at <= '".date('Y-m-d H:i:s', strtotime($month_year_end))."'";
                            $binds = array($emp_leave->employee_id);
                            $query = $this->db->query($sql, $binds);
                            $tmp = $query->result();
                             $leaves_in_year_org = $tmp[0]->total_days;
                             $leaves_in_year = $leaves_in_year_org - $emp_leave_in_month;
                             $leave_halfday_cal = employee_leave_halfday_cal($emp_leave->leave_type_id,$user_id);
							 if($leave_halfday_cal){
								foreach($leave_halfday_cal as $lhalfday):
									$hlfcount += 0.5;
								 endforeach;
							 }
							 $count_l = count_leaves_info($emp_leave->leave_type_id,$user_id);
							 $count_l = $count_l - $hlfcount;
                             $total_days_per_year=$emp_leave->days_per_year;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($emp_leave->leave_type_id,$user_id);
								$count =$xin_leave_type[0]->leave_count;
								$leave_remaining_total = $total_days_per_year - $count_l;
								$extra= $total_days_per_year - $count ;
								if(abs($leave_remaining_total)==0){
                    			    $remain=0;
                    			    $extra_leave=0;
                    			}elseif(abs($leave_remaining_total)<$count_l){
                    			     $remain=0;
                    			     $extra_leave=$extra;
                    			}else{
                    			     $remain=$leave_remaining_total;
                    			     $extra_leave=0;
                    			     $extra_amount=0;
                    			}
								if($extra_leave <0 || $extra_leave==0){
									$extra_in_month=0;
								 }elseif($extra_leave > 0 || $extra_leave!=0){
								   if($emp_leave_in_month !='' || $emp_leave_in_month!=0) {
									   $in_month=$emp_leave_in_month-$extra_leave;
									   $extra_amount=$emp_leave_in_month - $in_month;
									   $extra_amount=$daysInMonth - $count;
								   }
								 }
								 if($extra_amount!=0){
									$final_amount=($total_net_salary/$daysInMonth)* $extra_amount;
								 }
								 $total_final = $final_amount;
								// $total_final += $final_amount;

                		 }
                  }
                  $net_salary=$total_net_salary-$total_final;
                        */
			//new leave calc
			$month_year = $pay_date;
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leaves = $this->Employees_model->emp_leave_fetch($r->user_id, $start_date_y);

			$user_id = $r->user_id;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}
			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$k = 1;
			$extra_amount = $tot_days_lop_normal = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_finals = $final_amounts = 0;
			//$month_year_end = date("Y-m-t", strtotime("$month_year-02"));
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = 0;
			if ($emp_leaves) {
				foreach ($emp_leaves as $emp_leave) {
					$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id, $start_date_y_m, $emp_leave->leave_type_id);

					$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
								WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . date('Y-m-d H:i:s', strtotime($month_year_end)) . "'";

					$binds = array($emp_leave->employee_id);
					$query = $this->db->query($sql, $binds);
					$tmp = $query->result();
					$leaves_in_year_org = $tmp[0]->total_days;
					$leaves_in_year = $leaves_in_year_org - $emp_leave_in_month;
					$joining_date = $this->Timesheet_model->joining_date($emp_leave->employee_id);
					$leave_halfday_cal = employee_leave_halfday_cal($emp_leave->leave_type_id, $user_id);
					foreach ($leave_halfday_cal as $lhalfday) :
						$hlfcount += 0.5;
					endforeach;
					$count_l = count_leaves_info($emp_leave->leave_type_id, $user_id);
					$count_l = $count_l - $hlfcount;
					$total_days_per_year = $emp_leave->days_per_year;
					$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($emp_leave->leave_type_id, $user_id);
					$count = $xin_leave_type[0]->leave_count;
					$leave_remaining_total = $total_days_per_year - $count_l;
					if ($count > $total_days_per_year) {
						$extra = $count - $total_days_per_year;
					} else {
						$extra = 0;
					}
					if (abs($leave_remaining_total) == 0) {
						$remain = 0;
						$extra_leave = 0;
					} elseif (abs($leave_remaining_total) < $count_l) {
						$remain = 0;
						$extra_leave = $extra;
					} else {
						$remain = $leave_remaining_total;
						$extra_leave = 0;
						$extra_amount = 0;
						if ($emp_leave->leave_type_id == 5) {
							$d1 = strtotime(date('Y-m-d'));
							$d2 = strtotime($joining_date[0]->date_of_joining);
							$totalSecondsDiff = abs($d1 - $d2);
							$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

							if ($totalMonthsDiff <= 12) {
								$extra_leave = $leave_remaining_total;
							}
						}
					}

					//  print_r($count_l);
					//  print_r($extra_leave);
					$date = date($emp_leave->from_date);
					$date1 = date_create($date);
					$date2 = date_create($emp_leave->to_date);
					$diff = date_diff($date1, $date2);
					$day_diff = $diff->format("%a") + 1;

					$date1 = strtotime($joining_date[0]->date_of_joining);
					$date2 = strtotime(date('Y-m-d'));
					$diff = abs($date2 - $date1);
					$years = floor($diff / (365 * 60 * 60 * 24));
					$extra_amount = $daysInMonth;

					$d1 = strtotime(date('Y-m-d'));
					$d2 = strtotime($joining_date[0]->date_of_joining);
					$totalSecondsDiff = abs($d1 - $d2);
					$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

					if ($extra_leave < 0 || $extra_leave == 0) {
						$extra_in_month = 0;
					} elseif ($extra_leave > 0 || $extra_leave != 0) {
						if ($emp_leave_in_month != '' || $emp_leave_in_month != 0) {
							$in_month = $emp_leave_in_month - $extra_leave;
							$extra_amount = $emp_leave_in_month - $in_month;
							if ($emp_leave->leave_type_id == 8) {
								//Haj leave
								if ($joining_date[0]->ethnicity_type == 2) {
									if ($years <= 5) {
										$extra_amount = $daysInMonth - $count;
										$extra_leave = $count;
									} else {
										if ($count > $emp_leave->days_per_year) {
											$val = $count - $emp_leave->days_per_year;
											$extra_amount = $daysInMonth - $val;
										} else {
											$extra_amount = $daysInMonth;
										}
									}
								}
							} else if ($emp_leave->leave_type_id == 5) {
								//Maternity Leave
								if ($totalMonthsDiff <= 12) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else if ($emp_leave->leave_type_id == 4) {
								//Sick Leave
								if ($totalMonthsDiff < 3) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										if ($val <= 20) {
											$val = $val / 2;
										} else {
											$val = $val;
										}
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else if ($emp_leave->leave_type_id == 3) {
								//Annuval Leave
								if ($totalMonthsDiff < 3) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else if ($emp_leave->leave_type_id == 6) {
								//Marriage Leave
								if ($totalMonthsDiff < 3) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else {
								if ($count > $emp_leave->days_per_year) {
									$val = $count - $emp_leave->days_per_year;
									$extra_amount = $daysInMonth - $val;
								} else {
									$extra_amount = $daysInMonth;
								}
							}
						}
					}

					if ($extra_amount != 0) {
						$total_finals = ($total_net_salary / $daysInMonth) * $extra_amount;
					}


					$total_finals += $final_amounts;
					$original_leave_count = 0;
					if ($xin_leave_type[0]->leave_count > $daysInMonth) {
						$date = date($emp_leave->from_date);
						$month_frm_date = date('m', strtotime($date));
						if ($month_frm_date == date('m', strtotime(date("Y-m-d")))) {
							$date = date($emp_leave->from_date);
							$date1 = date_create($date);
							$date2 = date_create(date("Y-m-d", strtotime("$month_year-$daysInMonth")));
							$diff = date_diff($date1, $date2);
						} else {
							$date = date($emp_leave->to_date);
							$date1 = date_create($date);
							$date2 = date_create(date("Y-m-d", strtotime("$month_year-01")));
							$diff = date_diff($date1, $date2);
						}
						$day_diff = $diff->format("%a") + 1;
						$original_leave_count = $day_diff;
						$current_monthleave = $original_leave_count;
						if ($emp_leave->leave_type_id == 5) {
							//Maternity Leave
							$d1 = strtotime(date('Y-m-d'));
							$d2 = strtotime($joining_date[0]->date_of_joining);
							$totalSecondsDiff = abs($d1 - $d2);
							$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

							if ($totalMonthsDiff <= 12) {
								$tot_days += $original_leave_count;
							} else {
								$tot_days += $extra_leave;
							}
						}
					} else {
						$date = date($emp_leave->from_date);
						$month_frm_date = date('m', strtotime($date));
						$month_to_dte = date('m', strtotime($emp_leave->to_date));
						$today_month = date('m', strtotime(date("Y-m-d")));
						if ($month_frm_date != $today_month || $month_to_dte != $today_month) {

							if ($month_frm_date == $today_month) {
								$date = date($emp_leave->from_date);
								$date1 = date_create($date);
								$date2 = date_create(date("Y-m-d", strtotime("$month_year-$daysInMonth")));
								$diff = date_diff($date1, $date2);
							} else {
								$date = date($emp_leave->to_date);
								$date1 = date_create($date);
								$date2 = date_create(date("Y-m-d", strtotime("$month_year-01")));
								$diff = date_diff($date1, $date2);
							}
							$day_diff = $diff->format("%a") + 1;
							$current_monthleave = $day_diff;
							$original_leave_count = $xin_leave_type[0]->leave_count;

							if ($today_month == $month_to_dte) {
								$tot_days += 0;
							} else {
								$tot_days += $extra_leave;
							}
						} else {
							if ($emp_leave->leave_type_id == 8) {
								//Haj leave
								if ($joining_date[0]->ethnicity_type == 2) {
									if ($years <= 5) {
										$extra_amount = $daysInMonth - $count;
										$tot_days = $count;
									} else {
										if ($count >= $emp_leave->days_per_year) {
											$val = $count - $emp_leave->days_per_year;
											$tot_days += $val;
										} else {
											$tot_days += $daysInMonth;
										}
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
							} else if ($emp_leave->leave_type_id == 4) {
								//Sick Leave
								if ($totalMonthsDiff < 3) {
									$tot_days += $count;
								} else {
									if ($count >= $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										if ($val <= 20) {
											$val = $val / 2;
										} else {
											$val = $val;
										}
										$tot_days += $val;
									} else {
										$tot_days += $daysInMonth;
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
								//$original_leave_count = $xin_leave_type[0]->leave_count ;
							} else if ($emp_leave->leave_type_id == 3) {
								//Annuval Leave
								if ($totalMonthsDiff < 3) {
									$tot_days += $count;
								} else {
									if ($count >= $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$tot_days += $val;
									} else {
										$tot_days += $daysInMonth;
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
							} else if ($emp_leave->leave_type_id == 6) {
								//Marriage Leave
								if ($totalMonthsDiff < 3) {
									$tot_days += $count;
								} else {
									if ($count >= $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$tot_days += $val;
									} else {
										$tot_days += $daysInMonth;
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
							} else if ($emp_leave->leave_type_id == 5) {
								//Maternity Leave
								$d1 = strtotime(date('Y-m-d'));
								$d2 = strtotime($joining_date[0]->date_of_joining);
								$totalSecondsDiff = abs($d1 - $d2);
								$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
								if ($totalMonthsDiff <= 12) {
									$tot_days += $original_leave_count;
								} else {
									$tot_days += $extra_leave;
								}
							} else if ($emp_leave->leave_type_id == 7) {
								//Unpaid Leave
								$tot_days += $xin_leave_type[0]->leave_count;
								$current_monthleave = $xin_leave_type[0]->leave_count;
								$original_leave_count = $xin_leave_type[0]->leave_count;
							} else {
								$tot_days += $extra_leave;
								$current_monthleave = $xin_leave_type[0]->leave_count;
								$original_leave_count = $xin_leave_type[0]->leave_count;
							}
						}
					}
				}
			}
			//end new calc
			//Using attendance
			$arry_years = array();
			$st = '';
			$p_count_val = 0;
			$start_date_co = $year . '-' . $month . '-' . '1';
			$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
			$off_day_arr = array();
			$holiday_arr = array();
			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);
			if (!is_null($office_shift)) {
				$start_date_co = $year . '-' . $month . '-' . '01';
				$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
				$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $r->company_id);
				if ($h_date_chck->num_rows() > 0) {
					$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $r->company_id);
					foreach ($h_date as $val) {
						$begin = new DateTime($val->start_date);
						$end = new DateTime($val->end_date);
						$end = $end->modify('+1 day');

						$interval = new DateInterval('P1D');
						$daterange = new DatePeriod($begin, $interval, $end);

						foreach ($daterange as $date) {
							$holiday_arr[] = $date->format("Y-m-d");
						}
					}
					$p_count_val += count($holiday_arr);
				}
			}
			if ($office_shift) {
				if ($office_shift[0]->monday_in_time == '') {
					$off_day_arr[] = 'Mon';
				}
				if ($office_shift[0]->tuesday_in_time == '') {
					$off_day_arr[] = 'Tue';
				}
				if ($office_shift[0]->wednesday_in_time == '') {
					$off_day_arr[] = 'Wed';
				}
				if ($office_shift[0]->thursday_in_time == '') {
					$off_day_arr[] = 'Thu';
				}
				if ($office_shift[0]->friday_in_time == '') {
					$off_day_arr[] = 'Fri';
				}
				if ($office_shift[0]->saturday_in_time == '') {
					$off_day_arr[] = 'Sat';
				}
				if ($office_shift[0]->sunday_in_time == '') {
					$off_day_arr[] = 'Sun';
				}
				$p_count_val += $this->calculateSatuSundDaysInMonth($year, $month, $off_day_arr);
			}


			$leave_arr = array();
			$half_leave_arr = array();
			$leave_date_chck = $this->Timesheet_model->leave_date_check_new($r->user_id, $start_date_co, $end_date_co);
			if ($leave_date_chck->num_rows() > 0) {
				$leave_date = $this->Timesheet_model->leave_date_check_new($r->user_id, $start_date_co, $end_date_co);
				foreach ($leave_date->result() as $leave_dates) {
					$begin1 = new DateTime($leave_dates->from_date);
					$end1 = new DateTime($leave_dates->to_date);
					$end1 = $end1->modify('+1 day');
					$half_day_check = $leave_dates->is_half_day;
					$interval1 = new DateInterval('P1D');
					$daterange1 = new DatePeriod($begin1, $interval1, $end1);

					foreach ($daterange1 as $date1) {
						if ($half_day_check == 1) {
							$half_leave_arr[] = $date1->format("Y-m-d");
						} else {
							$leave_arr[] = $date1->format("Y-m-d");
						}
					}
				}
			}
			$present_arr = array();
			//$st = $this->db->last_query();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$user = $this->Xin_model->read_user_info($r->user_id);
			if (strtotime($month_year) == strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				if ($user[0]->date_of_leaving) {
					/*if(strtotime($month_year) == strtotime(date("Y-m",strtotime($user[0]->date_of_leaving)))){

						        $month_year_att_end = $user[0]->date_of_leaving;
						        $startDate = new DateTime($month_year_att);
        						$endDate = new DateTime($month_year_att_end);
        						$difference = $endDate->diff($startDate);
        						$difference_days  = $difference->format("%a");
						    }else if($month_year > date("Y-m",strtotime($user[0]->date_of_leaving))){
								$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days  = $difference->format("%a");
							}else{
						        $difference_days = 0;
						    }*/
					if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
						/*$month_year_att_end = $user[0]->date_of_leaving;
						        $startDate = new DateTime($month_year_att);
        						$endDate = new DateTime($month_year_att_end);
        						$difference = $endDate->diff($startDate);
        						$difference_days  = $difference->format("%a") + 1;*/
						if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
							$difference_days = 0;
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else {
						$difference_days = 0;
					}
				} else {
					$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
					if ($get_attendance_last_entered) {
						$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
						//$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days = $difference->format("%a") + 1;
					} else {
						$difference_days = 0;
					}
				}
			} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
				//$difference_days  = $daysInMonth;
				$month_year_att = $month_year . '-01';
				$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
				if ($get_attendance_last_entered) {
					$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
					//$month_year_att_end = $month_year.'-'.date('d');
					$startDate = new DateTime($month_year_att);
					$endDate = new DateTime($month_year_att_end);
					$difference = $endDate->diff($startDate);
					$difference_days = $difference->format("%a") + 1;
				} else {
					$difference_days = 0;
				}
			} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
				$difference_days = 0;
			}
			if ($difference_days >= 29) {
				$difference_days = $daysInMonth;
			}

			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);
			if (!is_null($office_shift)) {

				for ($i = 1; $i <= $difference_days; $i++) :
					$i = str_pad($i, 2, 0, STR_PAD_LEFT);
					// get date <
					$attendance_date = $year . '-' . $month . '-' . $i;
					$tdate = $year . '-' . $month . '-' . $i;
					$get_day = strtotime($attendance_date);
					$day = date('l', $get_day);
					$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
					if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
						$holiday_count += 1;
					} else if (in_array($attendance_date, $holiday_arr)) { // holiday
						$public_holiday_count += 1;
					} else if (in_array($attendance_date, $leave_arr)) { // on leave
						$leave_count += 1;
					} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
						$status = 'HDL';
						$leave__half_day_count += 0.5;
					} else if ($check->num_rows() > 0) {
						$attendance = $this->Timesheet_model->attendance_first_in($r->user_id, $attendance_date);
						$present_count += 1;
					} else {
						$absent_count += 1;
						//$pcount += 0;
					}

				endfor;
			}
			//$p_count_val  = $check;
			//$p_count_val = $tot_days;
			//End attendance based
			//print_r($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count);exit;

			/*$final_amounts=($total_net_salary/$daysInMonth)* $tot_days;
				  	$net_salary = $total_net_salary-$final_amounts;
				  */
			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;
			$emp_leaves = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
			if ($emp_leaves) {
				foreach ($emp_leaves->result() as $emp_leave) {
					$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id, $start_date_y_m, $emp_leave->leave_type_id);

					$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
                                      WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . date('Y-m-d H:i:s', strtotime($month_year_end)) . "'";
					$binds = array($emp_leave->employee_id);
					$query = $this->db->query($sql, $binds);
					$tmp = $query->result();
					$amt_deduct = 0;
					if ($emp_leave->leave_type_id == 7) {
						$tot_days_lop += $emp_leave->total_leaves;
						$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
					} else if ($emp_leave->leave_type_id == 4) {

						$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($user_id, 4);
						if (isset($carry_count[0]->create_date)) {
							$yr_check_sick = date('Y', strtotime($carry_count[0]->create_date));
						} else {
							$yr_check_sick = date('Y');
						}
						$total_half_paid_counts = $total_unpaid_counts = $total_paid_counts = $half_present_days = 0;
						$total_paid_count_exits = $this->Timesheet_model->select_leave_paid_list_new($user_id, $yr_check_sick, $emp_leave->leave_id);
						if (isset($total_paid_count_exits[0])) {
							if ($emp_leave->is_half_day == 1) {
								$leave__half_day_count += 0.5;
							}
							foreach ($total_paid_count_exits as $sickleave_calc) {
								$total_half_paid_counts += $sickleave_calc->total_half_paid_count;
								$total_unpaid_counts += $sickleave_calc->total_unpaid_count;
								$total_paid_counts += $sickleave_calc->total_paid_count;
							}
							if ($total_half_paid_counts > 0) {
								$tot_days_lop += $total_half_paid_counts / 2;
								$half_present_days = $total_half_paid_counts / 2;
							}
							if ($total_unpaid_counts > 0) {
								$tot_days_lop += $total_unpaid_counts;
							}
							if ($total_paid_counts > 0 || $half_present_days > 0) {

								// $present_count += $total_paid_counts + $half_present_days;
							}
						}
						/* Commented for sick leave seperation */
						/*	$tot_days_lop = $count_remain_again = $count_remain =  0;
                                if($emp_leave->total_leaves > 15){
                                  $count_remain = $emp_leave->total_leaves - 15;
                                  if($count_remain <=  20){
                                    $tot_days_lop += $count_remain / 2;
                                  }else{
                                      $count_remain_again =  $count_remain - 20;
                                      $tot_days_lop += (20 /2);
                                      $tot_days_lop +=  $count_remain_again;
                                  }
                                 // $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
                                }*/
						/* End the commented section for sick leave separation */
					}
				}
			}
			//$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
			//end number of calc
			$tot_days_lop_normal = $tot_days_lop;
			/*if(($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) >= 30){
				     // $totl_num_days_pres = 30 - ($tot_days_lop + $absent_count);
					 $totl_num_days_pres = 31 - ($absent_count);
				  }else{
				      //$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
					  $totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($absent_count);
				  }*/
			$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($absent_count);
			//print_R($totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count));exit;

			//$net_salary =($total_net_salary/30) * $p_count_val;
			$bs_pay = $r->basic_salary;
			$leave_cut_salary = ($bs_pay / 30) * $tot_days_lop;
			if ($leave_cut_salary > 0) {
				$leave_cut_salary = round($leave_cut_salary, 3);
			}
			$net_salary = ($total_net_salary / 30) * $totl_num_days_pres;
			$net_salary = $net_salary - $leave_cut_salary;
			$start_date_y_m = date('Y-m', strtotime($month_year));
			//Annual leave calc
			/* $joining_date=$this->Timesheet_model->joining_date($user_id);

				  $net_annual_amt = 0;
				  $annual_amt_pay = $anual_days_leave =0;
				 // $allowance_amount = 0;$statutory_deductions_amount = 0; $commissions_amount = 0; $loan_de_amount = 0;$other_payments_amount = 0;
				  $emp_annuval_leave=$this->Employees_model->emp_annuval_leave_fetch($user_id,$start_date_y_m);
				 //$emp_annuval_leave = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($user_id,$joining_date[0]->date_of_joining);
				  if(!is_null($emp_annuval_leave)){
				    $allowance_amount =  $commissions_amount = $other_payments_amount = $statutory_deductions_amount = 0;
					$allowances = $this->Employees_model->set_employee_allowances_for_leavesalary($user_id);
					$system = $this->Xin_model->read_setting_info(1);
					if(!empty($allowances->result())){
						foreach($allowances->result() as $sl_allowances) {
							if($system[0]->is_half_monthly==1){
								if($system[0]->half_deduct_month==2){
								  $iallowance_amount = $sl_allowances->allowance_amount/2;
								} else {
								  $iallowance_amount = $sl_allowances->allowance_amount;
								}
											$allowance_amount += $iallowance_amount;
							  }else{
											//$eallowance_amount = $sl_allowances->allowance_amount;
								if($sl_allowances->is_allowance_taxable == 1) {
								  if($sl_allowances->amount_option == 0) {
									$iallowance_amount = $sl_allowances->allowance_amount;
								  } else {
									$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
								  }
								  $allowance_amount -= $iallowance_amount;
								} else if($sl_allowances->is_allowance_taxable == 2) {
								  if($sl_allowances->amount_option == 0) {
									$iallowance_amount = $sl_allowances->allowance_amount / 2;
								  } else {
									$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
								  }
								  $allowance_amount -= $iallowance_amount;
								} else {
								  if($sl_allowances->amount_option == 0) {
									$iallowance_amount = $sl_allowances->allowance_amount;
								  } else {
									$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
								  }
								  $allowance_amount += $iallowance_amount;
								}
							}
						}
					}
					$commissions = $this->Employees_model->set_employee_commissions_for_leavesalary($user_id);
					if(!empty($commissions->result())){
						foreach($commissions->result() as $sl_commissions) {
							$pg_commissions_amount = $sl_commissions->commission_amount;
							if($system[0]->is_half_monthly==1){
								if($system[0]->half_deduct_month==2){
								  $ecommissions_amount = $sl_commissions->commission_amount/2;
								} else {
								  $ecommissions_amount = $sl_commissions->commission_amount;
								}
								$commissions_amount += $ecommissions_amount;
							} else {
							  if($sl_commissions->is_commission_taxable == 1) {
								if($sl_commissions->amount_option == 0) {
								  $ecommissions_amount = $sl_commissions->commission_amount;
								} else {
								  $ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
								}
								$commissions_amount -= $ecommissions_amount;
							  } else if($sl_commissions->is_commission_taxable == 2) {
								if($sl_commissions->amount_option == 0) {
								  $ecommissions_amount = $sl_commissions->commission_amount / 2;
								} else {
								  $ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
								}
								$commissions_amount -= $ecommissions_amount;
							  } else {
								if($sl_commissions->amount_option == 0) {
								  $ecommissions_amount = $sl_commissions->commission_amount;
								} else {
								  $ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
								}
								$commissions_amount += $ecommissions_amount;
							  }
						 }
						}
					}
					$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_for_leavesalary($user_id);
					if(!empty($statutory_deductions->result())){
						foreach($statutory_deductions->result() as $sl_statutory_deductions) {
							$sta_salary = $basic_salary;
                              $st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
                              if($system[0]->is_half_monthly==1){
                                if($system[0]->half_deduct_month==2){
                                    $single_sd = $st_amount/2;
                                } else {
                                  $single_sd = $st_amount;
                                }
                                $statutory_deductions_amount += $single_sd;
                              } else {
                                if($sl_statutory_deductions->statutory_options == 0) {
                                  $single_sd = $sl_statutory_deductions->deduction_amount;
                                } else {
                                  $single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
                                }
                                $statutory_deductions_amount += $single_sd;
                              }
						}
					}
					$other_payments = $this->Employees_model->set_employee_other_payments_leave_salary($user_id);
					if(!empty($other_payments->result())){
						foreach($other_payments->result() as $sl_other_payments) {
							if($system[0]->is_half_monthly==1){
								if($system[0]->half_deduct_month==2){
									$epayments_amount = $sl_other_payments->payments_amount/2;
								} else {
								$epayments_amount = $sl_other_payments->payments_amount;
								}
								$other_payments_amount += $epayments_amount;
							} else {
									//$epayments_amount = $sl_other_payments->payments_amount;
									if($sl_other_payments->is_otherpayment_taxable == 1) {
										if($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount;
										} else {
											$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount -= $epayments_amount;
									} else if($sl_other_payments->is_otherpayment_taxable == 2) {
										if($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount / 2;
										} else {
										$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
										}
													$other_payments_amount -= $epayments_amount;
									}else {
										if($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount;
										} else {
											$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount += $epayments_amount;
									}
							}
						}
					}



					$total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($user_id,$start_date_y_m);
					if($total_annual_leaves){
						$anual_days_leave = $total_annual_leaves[0]->days;
						$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id,$joining_date[0]->date_of_joining);
						if($check_already_exists_paid){
							$applied_date = $check_already_exists_paid[0]->applied_on;
							$date_arr = explode("-", $applied_date);
							$yr_d_paid = $date_arr[0];

							$date=date_create($total_annual_leaves[0]->applied_on);
							$not_paid_year = date_format($date,"Y");
						    $difference_years = $not_paid_year - $yr_d_paid;

							//joining date difference
								$date_joins = $joining_date[0]->date_of_joining;
								$date=date_create($date_joins);
								$date_join = date_format($date,"Y");
								$todays_date  = date('Y',strtotime($check_already_exists_paid[0]->applied_on));
								$join_differ = $todays_date -$date_join;
								if($join_differ > 0){
									$days_add_start = $join_differ * 365;
								}else{
									$days_add_start = 1 * 365;
								}

							//end joining date difference
							if($difference_years > 0){
								$days_add = $difference_years * 365;
							}else{
								$days_add = 1 * 365;
							}

							$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining. ' + '.$days_add_start.' days'));
					    	$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining. ' + '.$days_add.' days'));

						}else{
							$date_joins = $joining_date[0]->date_of_joining;
							$date=date_create($date_joins);
							$date_join = date_format($date,"Y/m/d");
							$todays_date  = date('Y-m-d');
							$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
							$years = floor($date_diff_calc / (365*60*60*24));
							$days_add = $years * 365;
							$start_date_co = $joining_date[0]->date_of_joining;
					    	$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining. ' + '.$days_add.' days'));
						}

					}
					$arry_years = array();
					$st = '';
				    $p_count_val = 0;
					$off_day_arr = array();
					$holiday_arr = array();
					$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);
					if(!is_null($office_shift)){
						$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co,$end_date_co,$r->company_id);
						if($h_date_chck->num_rows() > 0){
							$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co,$end_date_co,$r->company_id);
							foreach($h_date as $val){
								$begin = new DateTime( $val->start_date );
								$end = new DateTime( $val->end_date);
								$end = $end->modify( '+1 day' );

								$interval = new DateInterval('P1D');
								$daterange = new DatePeriod($begin, $interval ,$end);

								foreach($daterange as $date){
									$holiday_arr[] =  $date->format("Y-m-d");
								}
							}
							$p_count_val += count($holiday_arr);
						}

					}
					$leave_arr = array();
					$half_leave_arr = array();
					$leave_date_chck = $this->Timesheet_model->leave_date_check_new($r->user_id,$start_date_co,$end_date_co);
					if($leave_date_chck->num_rows() > 0){
						$leave_date = $this->Timesheet_model->leave_date_new($r->user_id,$start_date_co,$end_date_co);
						foreach($leave_date as $leave_dates){
							$begin1 = new DateTime( $leave_dates->from_date);
							$end1 = new DateTime( $leave_dates->to_date);
							$end1 = $end1->modify( '+1 day' );
							$half_day_check = $leave_dates->is_half_day;
							$interval1 = new DateInterval('P1D');
							$daterange1 = new DatePeriod($begin1, $interval1 ,$end1);

							foreach($daterange1 as $date1){
								if($half_day_check == 1){
										$half_leave_arr[] =  $date1->format("Y-m-d");
								}else{
										$leave_arr[] =  $date1->format("Y-m-d");
								}

							}
						}
					}
					$present_arr = array();
					//$st = $this->db->last_query();
					$total_leaves = count($leave_arr) + count($half_leave_arr);
					$p_count_val += abs($total_leaves - $tot_days);
					$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
					$absent_count = 0;
					$leave_count = 0;
					$month_year = date('Y-m',strtotime($start_date_co));
					if(strtotime($month_year) == strtotime(date('Y-m'))){
						$month_year_att = $month_year.'-01';
						$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days  = $difference->format("%a");
					}else if(strtotime($month_year) <= strtotime(date('Y-m'))){
						$month_year_att = $start_date_co;
						$month_year_att_end = $end_date_co;
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days  = $difference->format("%a");
					}else if(strtotime($month_year) >= strtotime(date('Y-m'))){
						$difference_days  = 0;
					}
					$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);
					if(!is_null($office_shift)){
						for($i = 1; $i <= $difference_days; $i++):
							$i = str_pad($i, 2, 0, STR_PAD_LEFT);
							// get date <
							$attendance_date = $month_year.'-'.$i;
							$tdate = date('Y-m',strtotime($end_date_co)).'-'.$i;
							$get_day = strtotime($attendance_date);
							$day = date('l', $get_day);
							$check = $this->Timesheet_model->attendance_first_in_check($user_id,$attendance_date);
							if($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
								$holiday_count += 1;
							} else if($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
								$holiday_count += 1;
							} else if($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
								$holiday_count += 1;
							} else if($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
								$holiday_count += 1;
							} else if($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
								$holiday_count += 1;
							} else if($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
								$holiday_count += 1;
							} else if($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
								$holiday_count += 1;
							} else if(in_array($attendance_date,$holiday_arr)) { // holiday
								$public_holiday_count += 1;
							} else if(in_array($attendance_date,$leave_arr)) { // on leave
								$leave_count += 1;
							}else if(in_array($attendance_date,$half_leave_arr)) { // on leave
								$status = 'HDL';
								$leave__half_day_count += 0.5;
							} else if($check->num_rows() > 0){
								$attendance = $this->Timesheet_model->attendance_first_in($r->user_id,$attendance_date);
								$present_count += 1;
							} else {
								$absent_count += 1;
								//$pcount += 0;
							}

						endfor;
					}
					//$p_count_val  = $check;
					//$p_count_val = $tot_days;
				  //End attendance based


				  //final_amounts=($total_net_salary/$daysInMonth)* $tot_days;
				  //	$net_salary = $total_net_salary-$final_amounts;

				  //Number of days calc
				  $total_k = 1;
				  $k=1; $extra_amount = 0;
                          $tot_days = 0;
                          $emp_leave_in_year_count =$extra_in_month= $total_final=$final_amount=0;
                          $month_year_end = date("Y-m-d", strtotime("$month_year-01"));
                          $month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
                          $totol_deduction = $count_l =$hlfcount = $tot_days_lop = 0;
						  $emp_leaves_data = $this->Timesheet_model->leave_date_check_new($r->user_id,$start_date_co,$end_date_co);
						  if($emp_leaves_data->num_rows() > 0){
							$emp_leaves = $this->Timesheet_model->leave_date_new($r->user_id,$start_date_co,$end_date_co);
                            foreach($emp_leaves as $emp_leave) {
                              $sql="Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
                                      WHERE employee_id=? and p.status='2' and p.leave_type_id='".$emp_leave->leave_type_id."' and p.from_date >= '".$start_date_co."'  and to_date <= '".$end_date_co."'";
                              $binds = array($emp_leave->employee_id);
                              $query = $this->db->query($sql, $binds);
                              $tmp = $query->result();
                              $amt_deduct = 0;
                              if($emp_leave->leave_type_id == 7){
                                  $tot_days_lop += $emp_leave->total_leaves;
                                $amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
                              }else if($emp_leave->leave_type_id == 4){
                                $tot_days_lop = $count_remain_again = $count_remain =  0;
                                if($emp_leave->total_leaves > 15){
                                  $count_remain = $emp_leave->total_leaves - 15;
                                  if($count_remain <=  20){
                                    $tot_days_lop += $count_remain / 2;
                                  }else{
                                      $count_remain_again =  $count_remain - 20;
                                      $tot_days_lop += (20 /2);
                                      $tot_days_lop +=  $count_remain_again;
                                  }
                                 // $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
                                }
                              }
							}
						}

				  //$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
				  //end number of calc.
				  //annual leave exists then normal pay
				  //$days_in_month  = date("t");
				  $days_in_month  = date('t',strtotime($this->input->get('month_year')));
					if(!is_null($emp_annuval_leave)){
						$normal_pay_days = $days_in_month - $anual_days_leave;
						$normal_pay_days = $normal_pay_days - $tot_days_lop_normal;
						if($normal_pay_days >= 0){
						$normal_pay_days=$normal_pay_days;
						}else{
						$normal_pay_days = 0;
						}
						$net_salary =($total_net_salary/30) * $normal_pay_days;
					}else{
						$net_salary =($total_net_salary/30) * $totl_num_days_pres;
					}

				  //end
				  if($net_salary == 0){
					$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
					if(!empty($loan->result())){
						foreach($loan->result() as $r_loan) {
							$loan_de_amount += $r_loan->loan_deduction_amount;
						}
					}
				  }
				  $total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
				  $total_deduction = $statutory_deductions_amount + $loan_de_amount;
				  $net_annual_amt  = $total_earning - $total_deduction;

				$date_joins = $start_date_co;
				$date=date_create($date_joins);
				$date_join = date_format($date,"Y/m/d");
				$todays_date  = $end_date_co;
				$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
				$years_count = floor($date_diff_calc / (365*60*60*24));
				  if($years_count > 0){
					$years_count = $years_count;
				  }else{
					$years_count = 1;
				  }
				//  $totl_num_days_pres = (365 * $years_count )  - ($tot_days_lop + $absent_count);
				 $totl_num_days_pres = (365 * $years_count )  - ($tot_days_lop);
				   $no_days_ann = (30/ 365) * $totl_num_days_pres;
				  $annual_amt_pay =  ($net_annual_amt / 30) * $no_days_ann;
				  //print_r($annual_amt_pay);exit;

			 }*/
			/* New Annual Leave methode */
			$annual_amt_pay = $anual_days_leave = 0;
			$holiday_count_new = $public_holiday_count_new = $working_days = 0;
			$leave__half_day_count_new = $leave_count_new = $present_count_new = $absent_count_new = 0;
			$tot_days_lop_new = 0;
			$total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($user_id, $start_date_y_m);
			if (!empty($total_annual_leaves[0]->id)) {
				foreach ($total_annual_leaves as $tot_ann_levs) {
					$annual_starting_date = $tot_ann_levs->from_date;
					$annual_ending_date = $tot_ann_levs->to_date;
					$anual_days_leave += $tot_ann_levs->days;
					$month_date_began = '01' . '-' . date('m-Y', strtotime($start_date_y_m));
					$month_date_end = $daysInMonth . '-' . date('m-Y', strtotime($start_date_y_m));
					$to_date = strtotime($month_date_began);
					$from_date = strtotime($annual_starting_date);
					$datediff = $from_date - $to_date;
					$mont_diff_date_start = round($datediff / (60 * 60 * 24));

					$to_from_date = strtotime($annual_ending_date);
					$to_ending_date = strtotime($month_date_end);
					$datediff1 = $to_ending_date - $to_from_date;
					$mont_diff_date_end = round($datediff1 / (60 * 60 * 24));

					if ($mont_diff_date_start == 0 && $mont_diff_date_end == 0) {
						$annual_amt_pay += $tot_ann_levs->annua_amt;
					} else {
						if ($mont_diff_date_start > 0 && date('m-Y', strtotime($start_date_y_m)) == date('m-Y', strtotime($annual_starting_date))) {
							$period = new DatePeriod(
								new DateTime($month_date_began),
								new DateInterval('P1D'),
								new DateTime($annual_starting_date)
							);

							foreach ($period as $key => $value) {
								$attendance_date = $value->format('Y-m-d');
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count_new += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count_new += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count_new += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count_new += 0.5;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($r->user_id, $attendance_date);
									$present_count_new += 1;
								} else {
									$absent_count_new += 1;
									//$pcount += 0;
								}
							}
							//Number of days calc
							$total_k = 1;
							$k = 1;
							$extra_amount = 0;
							$tot_days = 0;
							$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
							$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
							$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
							$totol_deduction = $count_l = $hlfcount = $tot_days_lop_new = 0;
							$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($r->user_id, $month_date_began, $annual_starting_date);
							if ($emp_leaves_data->num_rows() > 0) {
								$emp_leaves = $this->Timesheet_model->leave_date_new($r->user_id, $month_date_began, $annual_starting_date);
								foreach ($emp_leaves as $emp_leave) {
									$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
												WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
									$binds = array($emp_leave->employee_id);
									$query = $this->db->query($sql, $binds);
									$tmp = $query->result();
									$amt_deduct = 0;
									if ($emp_leave->leave_type_id == 7) {
										$tot_days_lop_new += $emp_leave->total_leaves;
										$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
									} else if ($emp_leave->leave_type_id == 4) {
										$tot_days_lop_new = $count_remain_again = $count_remain = 0;
										if ($emp_leave->total_leaves > 15) {
											$count_remain = $emp_leave->total_leaves - 15;
											if ($count_remain <= 20) {
												$tot_days_lop_new += $count_remain / 2;
											} else {
												$count_remain_again = $count_remain - 20;
												$tot_days_lop_new += (20 / 2);
												$tot_days_lop_new += $count_remain_again;
											}
											// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
										}
									}
								}
							}
							$working_days = ($absent_count_new + $present_count_new + $holiday_count_new + $public_holiday_count_new + $leave_count_new + $leave__half_day_count_new) - ($tot_days_lop_new + $absent_count_new);
							$diff_start = $mont_diff_date_start;
						} else {
							$diff_start = 0;
						}
						if ($mont_diff_date_end > 0 && date('m-Y', strtotime($start_date_y_m)) == date('m-Y', strtotime($annual_ending_date))) {
							$next_monn_beg = date('d-m-Y', strtotime($month_date_end . ' +1 day'));
							$period = new DatePeriod(
								new DateTime($annual_ending_date),
								new DateInterval('P1D'),
								new DateTime($month_date_end)
							);

							foreach ($period as $key => $value) {
								$attendance_date = $value->format('Y-m-d');
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count_new += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count_new += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count_new += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count_new += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count_new += 0.5;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($r->user_id, $attendance_date);
									$present_count_new += 1;
								} else {
									$absent_count_new += 1;
									//$pcount += 0;
								}
							}
							//Number of days calc
							$total_k = 1;
							$k = 1;
							$extra_amount = 0;
							$tot_days = 0;
							$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
							$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
							$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
							$totol_deduction = $count_l = $hlfcount = $tot_days_lop_new = 0;
							$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($r->user_id, $annual_ending_date, $month_date_end);
							if ($emp_leaves_data->num_rows() > 0) {
								$emp_leaves = $this->Timesheet_model->leave_date_new($r->user_id, $annual_ending_date, $month_date_end);
								foreach ($emp_leaves as $emp_leave) {
									$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
													WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
									$binds = array($emp_leave->employee_id);
									$query = $this->db->query($sql, $binds);
									$tmp = $query->result();
									$amt_deduct = 0;
									if ($emp_leave->leave_type_id == 7) {
										$tot_days_lop_new += $emp_leave->total_leaves;
										$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
									} else if ($emp_leave->leave_type_id == 4) {
										$tot_days_lop_new = $count_remain_again = $count_remain = 0;
										if ($emp_leave->total_leaves > 15) {
											$count_remain = $emp_leave->total_leaves - 15;
											if ($count_remain <= 20) {
												$tot_days_lop_new += $count_remain / 2;
											} else {
												$count_remain_again = $count_remain - 20;
												$tot_days_lop_new += (20 / 2);
												$tot_days_lop_new += $count_remain_again;
											}
											// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
										}
									}
								}
							}
							$working_days = ($absent_count_new + $present_count_new + $holiday_count_new + $public_holiday_count_new + $leave_count_new + $leave__half_day_count_new) - ($tot_days_lop_new + $absent_count_new);

							$diff_end = $mont_diff_date_end;
						} else {
							$diff_end = 0;
						}
						$annual_cut_days = $diff_start + $diff_end;
						if ($annual_cut_days == 0) {
							$annual_cut_days = 1;
						} else {
							//	$working_days += $annual_cut_days;
							$annual_cut_days = $daysInMonth - $annual_cut_days;
						}
						if ($tot_ann_levs->annua_amt) {
							$annual_amt_pay_v = $tot_ann_levs->annua_amt / $tot_ann_levs->days;
							$annual_amt_pay += $annual_cut_days * $annual_amt_pay_v;
						} else {
							$annual_amt_pay += 0;
						}
					}
				}

				$days_in_month = date('t', strtotime($this->input->get('month_year')));
				if (!is_null($total_annual_leaves)) {
					$normal_pay_days = $days_in_month - $anual_days_leave;
					$normal_pay_days = $normal_pay_days - $tot_days_lop_normal;
					if ($normal_pay_days >= 0) {
						$normal_pay_days = $normal_pay_days;
					} else {
						$normal_pay_days = 0;
					}
					$net_salary = ($total_net_salary / 30) * $working_days;
				} else {
					$net_salary = ($total_net_salary / 30) * $totl_num_days_pres;
				}
			}

			/* End New Annual Leave Method */

			//end annual leave calc

			//Indemnity calc
			/*$start_date_y = date('m', strtotime($month_year));
				$start_date_y_m = date('Y-m', strtotime($month_year));
				$emp_Indemnity=$this->Employees_model->emp_indemnity_fetch($user_id,$start_date_y);

				$totl_amt = 0;
				if($emp_Indemnity){
					foreach($emp_Indemnity as $emp_leave) {
						$totl_amt += $emp_leave->amount;
					  }
				}*/
			$totl_amt = 0;
			//leave encashment calc
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

			$totl_amt_leva = 0;
			if ($emp_leave_enchas) {
				foreach ($emp_leave_enchas as $emp_leave_ench) {
					$totl_amt_leva += $emp_leave_ench->amount;
				}
			}
			$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $annual_amt_pay;
			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary,$r->company_id);
			if ($net_salary < 0) {
				$net_salary = '0.00';
			}
			$iemp_name = $emp_name;

			//action link
			$act = $detail . $fmpay . $delete;
			if ($r->wages_type == 1) {
				if ($system[0]->is_half_monthly == 1) {
					$emp_payroll_wage = $wages_type ;
				} else {
					$emp_payroll_wage = $wages_type;
				}
			} else {
				$emp_payroll_wage = $wages_type;
			}
			if (in_array('83', $role_resources_ids)) {
				$emp_id = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="Employee Detail">' . $r->employee_id . ' <i class="fas fa-arrow-circle-right"></i></a>';
			} else {
				$emp_id = $r->employee_id;
			}

			$paymonth = date('m', strtotime($pay_date));
			$payyear = date('Y', strtotime($pay_date));


			$totaldeduct = 0;
			$late_totaldetails = $this->Employees_model->getemployeelatedetails($user_id, $loan_m, $year);
			$empdatas = $this->Employees_model->get_employee_data($user_id);
			$latestatus = $empdatas[0]->late_deduction;
			//$total_work = $this->Employees_model->get_employee_workdone($user_id,$loan_m,$year);
			if ($latestatus == "hours_deduction") {

				if (isset($late_totaldetails)) {
					foreach ($late_totaldetails as $latedetails) {
						$day = $latedetails->attendance_date;
						$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id, $day);
						$total_work = $this->Employees_model->get_employee_workdone($user_id, $day);
						$latededuction = $latecome_deduct[0]->late_deduction;
						if ($total_work[0]->totalhours < 8 && $total_work[0]->totalhours > 0) {
							$latehours = 8 - round($total_work[0]->totalhours, 2);
							$empdata = $this->Employees_model->get_employee_details($user_id);
							$basepay = $empdata[0]->basic_salary;
							$hourdeduct = round(($basepay / 30) / 8 * $latehours, 3);

							$halfdays = $this->Employees_model->get_halfdays($user_id);
							if (isset($halfdays)) {
								foreach ($halfdays as $row) {

									$startDate = $row->from_date;
									//echo $startDate;
									if ($day == $startDate && $latehours > 4) {
										//$halfday = "yes";
										$latebyhours = 4 - round($total_work[0]->totalhours, 2);
										$hourdeduct = round(($basepay / 30) / 8 * $latebyhours, 3);
									} elseif ($day == $startDate && $latehours <= 4) {
										$hourdeduct = 0;
									}
								}
							}

							$totaldeduct = $hourdeduct + $latededuction;
							$total += $hourdeduct + $latededuction;
						} else {
							$total += $latededuction;
						}
					}
				}
			} elseif ($latestatus == "hoursandlate_deduction") {
				if (isset($late_totaldetails)) {
					foreach ($late_totaldetails as $latedetails) {
						$day = $latedetails->attendance_date;
						$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id, $day);
						$total_work = $this->Employees_model->get_employee_workdone($user_id, $day);
						$latededuction = $latecome_deduct[0]->late_deduction;
						if ($total_work[0]->totalhours < 8 && $total_work[0]->totalhours > 0) {
							$latehours = 8 - round($total_work[0]->totalhours, 2);
							$empdata = $this->Employees_model->get_employee_details($user_id);
							$basepay = $empdata[0]->basic_salary;
							$hourdeduct = round(($basepay / 30) / 8 * $latehours, 3);

							$halfdays = $this->Employees_model->get_halfdays($user_id);
							if (isset($halfdays)) {
								foreach ($halfdays as $row) {

									$startDate = $row->from_date;
									//echo $startDate;
									if ($day == $startDate && $latehours > 4) {
										//$halfday = "yes";
										$latebyhours = 4 - round($total_work[0]->totalhours, 2);
										$hourdeduct = round(($basepay / 30) / 8 * $latebyhours, 3);
									} elseif ($day == $startDate && $latehours <= 4) {
										$hourdeduct = 0;
									}
								}
							}

							$totaldeduct = $hourdeduct + $latededuction;
							$total += $hourdeduct + $latededuction;
						} else {
							$total += $latededuction;
						}
					}
				}
			}


			echo $total;
			if (!is_null($total)) {

				//$late_deduct_amt = $totaldeduct;
				$late_deduct_amt = $total;
			} else {
				$late_deduct_amt = 0;
			}

			$overtime_totalpay = $this->Employees_model->get_employee_overtime_total($user_id, $loan_m, $year);
			//$bsalary             = $this->Employees_model->get_employee_salary($user_id);
			//$finalamount         = ($bsalary[0]->basic_salary/30)* $tot_days_lop;
			//$leave_dedc          = number_format($finalamount,2);
			$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
			$otstatus = $overtimestatus[0]->ot_eligible;
			if ($otstatus == "yes") {
				//$nettotal = "BD".(($bsalary[0]->basic_salary + $overtime_totalpay[0]->totalrate) - ($leave_dedc + $statutory_deductions_amount));

				$nettotal = $this->Xin_model->company_currency_sign(($net_salary + $overtime_totalpay[0]->totalrate - $late_deduct_amt),$r->company_id);
			} else {
				$nettotal = $this->Xin_model->company_currency_sign(($net_salary - $late_deduct_amt),$r->company_id);
			}

			$days_in_month = $days = date("t");
			$data[] = array(
				$act,
				$emp_id,
				$iemp_name,
				$emp_payroll_wage,
				$basic_salary,
				$net_salary,
				//$totl_num_days_pres,
				//$days_in_month
				$status_pay
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip->num_rows(),
			"recordsFiltered" => $payslip->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function payslip_list()
	{
		error_reporting(0);
		ini_set('max_execution_time', '1000');
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/generate_payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		// date and employee id/company id
		$p_date = $this->input->get("month_year");
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('285', $role_resources_ids)) {
			if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") == 0) {
				$payslip = $this->Employees_model->get_employees_payslip();
			} else if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") != 0) {
				$payslip = $this->Payroll_model->get_comp_template($this->input->get("company_id"), 0);
			} else if ($this->input->get("employee_id") != 0 && $this->input->get("company_id") != 0) {
				$payslip = $this->Payroll_model->get_employee_comp_template($this->input->get("company_id"), $this->input->get("employee_id"));
			} else {
				$payslip = $this->Employees_model->get_employees_payslip();
			}
		} else {
			$payslip = $this->Payroll_model->get_employee_comp_template($user_info[0]->company_id, $session['user_id']);
		}
		$system = $this->Xin_model->read_setting_info(1);
		$data = array();

		foreach ($payslip->result() as $r) {
			// user full name
			$emp_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			$full_name = '<a target="_blank" class="text-primary" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '">' . $emp_name . '</a>';

			// get total hours > worked > employee
			$pay_date = $this->input->get('month_year');
			//overtime request
			$overtime_count = $this->Overtime_request_model->get_overtime_request_count($r->user_id, $this->input->get('month_year'));
			$re_hrs_old_int1 = 0;
			$re_hrs_old_seconds = 0;
			$re_pcount = 0;
			foreach ($overtime_count as $overtime_hr) {
				// total work
				$request_clock_in = new DateTime($overtime_hr->request_clock_in);
				$request_clock_out = new DateTime($overtime_hr->request_clock_out);
				$re_interval_late = $request_clock_in->diff($request_clock_out);
				$re_hours_r = $re_interval_late->format('%h');
				$re_minutes_r = $re_interval_late->format('%i');
				$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

				$re_str_time = $re_total_time;

				$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

				sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$re_hrs_old_int1 += $re_hrs_old_seconds;

				$re_pcount = gmdate("H", $re_hrs_old_int1);
			}
			$result = $this->Payroll_model->total_hours_worked($r->user_id, $pay_date);
			$hrs_old_int1 = 0;
			$pcount = 0;
			$Trest = 0;
			$total_time_rs = 0;
			$hrs_old_int_res1 = 0;
			foreach ($result->result() as $hour_work) {
				// total work
				$clock_in = new DateTime($hour_work->clock_in);
				$clock_out = new DateTime($hour_work->clock_out);
				$interval_late = $clock_in->diff($clock_out);
				$hours_r = $interval_late->format('%h');
				$minutes_r = $interval_late->format('%i');
				$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

				$str_time = $total_time;

				$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

				sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$hrs_old_int1 += $hrs_old_seconds;

				$pcount = gmdate("H", $hrs_old_int1);
			}
			$pcount = $pcount + $re_pcount;
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// 1: salary type
			if ($r->wages_type == 1) {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			} else if ($r->wages_type == 2) {
				$wages_type = $this->lang->line('xin_employee_daily_wages');
				if ($pcount > 0) {
					$basic_salary = $pcount * $r->basic_salary;
				} else {
					$basic_salary = $pcount;
				}
				$p_class = 'emo_hourly_pay';
				$view_p_class = 'hourlywages_template_modal';
			} else {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			}

			$location_id = $r->location_id;
			$monthyear = $payyear . "-" . $paymonth;
			$get_management_status = $this->Employees_model->get_management_employee_status($r->user_id, $location_id, $p_date);
			if (empty($get_management_status)) {
				$management_status_val = 1;
			} else {
				$management_status_val = 2;
			}

			// all allowances, all loan/deductions
			$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($r->user_id, $p_date, $basic_salary);
			$salary_calc = $this->Xin_model->payroll_GrossSalary($r->user_id, $p_date, $basic_salary, $all_allo_and_dedct);
			$total_net_salary = $salary_calc[0];
			// make payment
			//   var_dump($system[0]->is_half_monthly);die();
			if ($system[0]->is_half_monthly == 1) {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($r->user_id, $p_date);
				$payment_last = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($r->user_id, $p_date);
				if ($payment_check->num_rows() > 1) {
					//foreach($payment_last as $payment_half_last){
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success" style="color: rgb(35, 232, 71)">' . $this->lang->line('xin_payroll_paid') . '</span>';
					//$mpay = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_payroll_make_payment').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".'.$p_class.'" data-employee_id="'. $r->user_id . '" data-payment_date="'. $p_date . '" data-company_id="'.$this->input->get("company_id").'"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('283', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code><br>' . '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $payment_last[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span><code>' . $this->lang->line('xin_title_second_half') . '</code>';
					//}
					//detail link
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success" style="color: rgb(35, 232, 71)"">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '"  data-payment_date="' . $p_date . '" data-management_status="' . $management_status_val . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay .= '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('283', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code>';
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-management_status="' . $management_status_val . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					//detail link
					$detail = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $pay_date . '"><span class="fa fa-eye"></span></button></span>';

					$total_net_salary = $total_net_salary;
				}
				//detail link
				//$detail = '';
			} else {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($r->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success" style="color: rgb(35, 232, 71)">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('283', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					//$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-management_status="' . $management_status_val . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					$total_net_salary = $total_net_salary;
				}
				//detail link
				if (in_array('286', $role_resources_ids)) {
					$detail = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '"" data-net="' . $total_net_salary . '"><span class="fa fa-eye"></span></button></span>';
				} else {
					$detail = '';
				}
			}

			$net_salary = number_format((float)$total_net_salary, 2, '.', '');
			$basic_salary = number_format((float)$basic_salary, 2, '.', '');
			//}

			if ($basic_salary == 0 || $basic_salary == '') {
				$fmpay = '';
			} else {
				$fmpay = $mpay;
			}

			//new leave calc
			$month_year = $pay_date;
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leaves = $this->Employees_model->emp_leave_fetch($r->user_id, $start_date_y);

			$user_id = $r->user_id;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}
			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$k = 1;
			$extra_amount = $tot_days_lop_normal = 0;
			$tot_days = 0;

			//Using attendance
			$arry_years = array();
			$st = '';
			$p_count_val = 0;
			//$start_date_co = $year . '-' . $month . '-' . '01';
			$user = $this->Xin_model->read_user_info($r->user_id);
			if (strtotime(date('Y-m', strtotime($user[0]->date_of_joining))) == strtotime($month_year)) {
				$start_date_co = $user[0]->date_of_joining;
			} else {
				$start_date_co = $year . '-' . $month . '-' . '01';
			}
			$end_date_co = $year . '-' . $month . '-' . $daysInMonth;


			$present_arr = array();
			//$st = $this->db->last_query();
			$leave_arr = $half_leave_arr = array();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$user = $this->Xin_model->read_user_info($r->user_id);
			if (strtotime($month_year) == strtotime(date('Y-m'))) {
				//	$month_year_att = $month_year . '-01';
				if (strtotime(date('Y-m', strtotime($user[0]->date_of_joining))) == strtotime($month_year)) {
					$month_year_att = $user[0]->date_of_joining;
				} else {
					$month_year_att = $month_year . '-01';
				}
				if ($user[0]->date_of_leaving) {
					if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
						if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
							$difference_days = 0;
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else {
						$difference_days = 0;
					}
				} else {
					$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
					if ($get_attendance_last_entered) {
						$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
						//$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days = $difference->format("%a") + 1;
					} else {
						$difference_days = 0;
					}
				}
			} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
				//$month_year_att = $month_year . '-01';
				if (strtotime(date('Y-m', strtotime($user[0]->date_of_joining))) == strtotime($month_year)) {
					$month_year_att = $user[0]->date_of_joining;
				} else {
					$month_year_att = $month_year . '-01';
				}
				$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
				if ($get_attendance_last_entered) {
					$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
					//$month_year_att_end = $month_year.'-'.date('d');
					$startDate = new DateTime($month_year_att);
					$endDate = new DateTime($month_year_att_end);
					$difference = $endDate->diff($startDate);
					$difference_days = $difference->format("%a") + 1;
				} else {
					$difference_days = 0;
				}
			} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
				$difference_days = 0;
			}
			if ($difference_days >= 25) {
				$difference_days = $daysInMonth;
			}


			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

			//end number of calc
			$attendence_calc = $this->Xin_model->AttendnceCount_calc_common($r->office_shift_id, $start_date_co, $end_date_co, $r->company_id, $r->user_id, $difference_days, $year, $month);
			if ($attendence_calc) {
				$tot_days_lop_normal = $attendence_calc[0];
				$totl_num_days_pres = $attendence_calc[1];
			} else {
				$tot_days_lop_normal = 0;
				$totl_num_days_pres = 0;
			}
			$tot_days_lop = $tot_days_lop_normal;

			$bs_pay = $r->basic_salary;

			/* Lop Calc Common */
			$lop_calc = $this->Xin_model->LopCalcCommon($net_salary, $daysInMonth, $tot_days_lop);
			$leave_cut_salary = $lop_calc[0];
			/* End Lop calc Common */
			/* Net salary calculations */
			$net_salary_calc = $this->Xin_model->NetsalaryCalcCommon($total_net_salary, $daysInMonth, $totl_num_days_pres);
			$net_salary = $net_salary_calc[0];




			/* Final Net salary */
			$final_net_salary = $this->Xin_model->FinalNetSalaryCalcCommon($net_salary, $leave_cut_salary, $all_allo_and_dedct);
			$net_salary = $final_net_salary[0];

			$start_date_y_m = date('Y-m', strtotime($month_year));
			//Indemnity calc
			/*$start_date_y = date('m', strtotime($month_year));
				$start_date_y_m = date('Y-m', strtotime($month_year));
				$emp_Indemnity=$this->Employees_model->emp_indemnity_fetch($user_id,$start_date_y);

				$totl_amt = 0;
				if($emp_Indemnity){
					foreach($emp_Indemnity as $emp_leave) {
						$totl_amt += $emp_leave->amount;
					  }
				}*/
			$totl_amt = 0;
			//leave encashment calc
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

			$totl_amt_leva = $annual_amt_pay = 0;
			if ($emp_leave_enchas) {
				foreach ($emp_leave_enchas as $emp_leave_ench) {
					$totl_amt_leva += $emp_leave_ench->amount;
				}
			}
			$encashment = $this->Payroll_model->GetEncashmentamount($user_id, $start_date_y_m);
        	foreach ($encashment as $emp_leave) {
        		if ($emp_leave->given_methode == 'Connect_To_Payroll') {
        			$annual_amt_pay += $emp_leave->amount;
        		}
        	}
			$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $annual_amt_pay;
			if ($net_salary < 0 || $basic_salary <= 0) {
				$net_salary = '0.00';
			}
			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary,$r->company_id);

			$iemp_name = $emp_name;

			//action link
			$act = $detail . $fmpay . $delete;
			if ($r->wages_type == 1) {
				if ($system[0]->is_half_monthly == 1) {
					$emp_payroll_wage = $wages_type ;
				} else {
					$emp_payroll_wage = $wages_type;
				}
			} else {
				$emp_payroll_wage = $wages_type;
			}
			if (in_array('83', $role_resources_ids)) {
				$emp_id = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="Employee Detail">' . $r->employee_id . ' <i class="fas fa-arrow-circle-right"></i></a>';
			} else {
				$emp_id = $r->employee_id;
			}

			$paymonth = date('m', strtotime($pay_date));
			$payyear = date('Y', strtotime($pay_date));
			$empdata = $this->Employees_model->get_employee_details($user_id);
			$basepay = $empdata[0]->basic_salary;
			$no_of_days = date('t', strtotime($pay_date));
			/*$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($user_id,$pay_date,$basepay);
           $allowance_amount   = $all_allo_and_dedct[0];
           $no_of_days         = date('t', strtotime($pay_date));*/

			// Late Deduction Start

			$latededuction = $this->Payroll_model->GetLateDeductionCalcCommon($user_id, $paymonth, $payyear, $no_of_days);
			$late_amount = $latededuction[0];

			// Late Deduction End


			/*   $total = 0;
         $totaldeduct = 0;

               $late_totaldetails = $this->Employees_model->getemployeelatedetails($user_id,$paymonth,$payyear);
               $empdatas     = $this->Employees_model->get_employee_data($user_id);
               $latestatus   = $empdatas[0]->late_deduction;
               if($latestatus == "hours_deduction"){
               if(isset($late_totaldetails)){
               foreach($late_totaldetails as $latedetails){
                     $day = $latedetails->attendance_date;
                     $total_work = $this->Employees_model->get_employee_workdone($user_id,$day);
                     $latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id,$day);
                     $latededuction = $latecome_deduct[0]->late_deduction;
                     if($total_work[0]->totalhours< 8 && $total_work[0]->totalhours> 0){
                                   $latehours = 8 - round($total_work[0]->totalhours,2);
                                   $empdata = $this->Employees_model->get_employee_details($user_id);
                                   $basepay       = $empdata[0]->basic_salary;
                                   $hourdeduct = round(($basepay/30)/8 * $latehours,3);

                                   $halfdays      =  $this->Employees_model->get_halfdays($user_id);
         						   if(isset($halfdays)){
         						   foreach ($halfdays as $row) {

         						    $startDate     =  $row->from_date;
         						    if($day == $startDate && $latehours > 4){

         						        $latebyhours = 4 - round($total_work[0]->totalhours,2);
         						        $hourdeduct = round(($basepay/30)/8 * $latebyhours,3);
         						        $latededuction = 0;
         						    }elseif($day == $startDate && $latehours <= 4){
         						        $hourdeduct = 0;
         						        $latededuction = 0;
         						    }

         					     	}
         						    }

                                   $total += $hourdeduct;

                     }

               }
               }
               }elseif($latestatus == "hoursandlate_deduction"){
                   if(isset($late_totaldetails)){
                     foreach($late_totaldetails as $latedetails){
                     $day = $latedetails->attendance_date;
                     $total_work = $this->Employees_model->get_employee_workdone($user_id,$day);
                     $latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id,$day);
                     $latededuction = $latecome_deduct[0]->late_deduction;
                     if($total_work[0]->totalhours< 8 && $total_work[0]->totalhours> 0){
                                   $latehours = 8 - round($total_work[0]->totalhours,2);
                                   $empdata = $this->Employees_model->get_employee_details($user_id);
                                   $basepay       = $empdata[0]->basic_salary;
                                   $hourdeduct = round(($basepay/30)/8 * $latehours,3);

                                   $halfdays      =  $this->Employees_model->get_halfdays($user_id);
         						   if(isset($halfdays)){
         						   foreach ($halfdays as $row) {

         						    $startDate     =  $row->from_date;
         						    if($day == $startDate && $latehours > 4){

        						        $latebyhours = 4 - round($total_work[0]->totalhours,2);
         						        $hourdeduct = round(($basepay/30)/8 * $latebyhours,3);
         						        $latededuction = 0;
         						    }elseif($day == $startDate && $latehours <= 4){
         						        $hourdeduct = 0;
         						        $latededuction = 0;
         						    }

         					     	}
         						    }
                                   $totaldeduct = $hourdeduct + $latededuction;
                                   $total += $hourdeduct + $latededuction;

                     }
                     elseif($total_work[0]->totalhours> 8 && $latededuction > 0){
                                   $total +=  $latededuction;
                     }
               }
               }
               }*/


			$userinfo = $this->Employees_model->get_employee_details($user_id);
			$companyinfo = $this->Employees_model->get_company_details($userinfo[0]->company_id);
			$late_status = $companyinfo[0]->late_deduction;
			if ($late_status == 'yes') {
				$late_amount = $late_amount;
			} else {
				$late_amount = 0;
			}

			// Get Overtime Amount
			$overtime = $this->Payroll_model->GetOvertimeCalcCommon($user_id, $paymonth, $payyear);
			$overtime_amount = $overtime[0];
			// End Overtime Amount

			// Air ticket Encashment Start
			$encashment_check = $this->Employees_model->employee_encashment_check($user_id, $month_year);
			if (!empty($encashment_check)) {
				$encashstatus = $encashment_check[0]->status;
				if (!is_null($encashstatus)) {
					$encashrate = $this->Employees_model->get_employee_encashrate_payroll($user_id, $month_year);
					$encash_amt = $encashrate[0]->amount;
					/*$empinfo     = $this->Employees_model->read_employee_information($user_id);
                $nation_id   = $empinfo[0]->nationality_id;
                $encashrate  = $this->Employees_model->get_employee_encashrate($nation_id);
                $encash_amt  = $encashrate[0]->encash_amount;*/
				} else {
					$encash_amt = 0;
				}
			} else {
				$encash_amt = 0;
			}

			// Air ticket Encashment End
			//$nettotal = $net_salary;
			$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
			$otstatus = $overtimestatus[0]->ot_eligible;
			if ($otstatus == "yes") {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary + $overtime_amount - $late_amount;
				}
			} else {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary - $late_amount;
				}
			}


			/* Expense Claim Start */
			if ($nettotal > 0) {
				$expense_total_claim = $this->Xin_model->FindExpenseClaimTotal($user_id, $this->input->get('month_year'));
				$nettotal = $nettotal + $expense_total_claim + $encash_amt;
			}
			/* Expense Claim End */

			$nettotal = $this->Xin_model->company_currency_sign($nettotal,$r->company_id);


			$location_id = $r->location_id;
			$monthyear = $payyear . "-" . $paymonth;
			$get_management_status = $this->Employees_model->get_management_employee_status($user_id, $location_id, $p_date);

			if (empty($get_management_status)) {
				$management_status = "Pending";
			} else {
				$management_status = $get_management_status[0]->status;
			}


			$days_in_month = $days = date("t");

			$payment_check = $this->Payroll_model->read_make_payment_payslip_check($user_id, $p_date);

			if ($payment_check->num_rows() > 0) {

				$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
				$nettotal = $this->Xin_model->company_currency_sign($make_payment[0]->net_salary,$r->company_id);
			}
			$current_month = date('Y-m');
			$search_month = date('Y-m', strtotime($month_year));
			if (strtotime($search_month) > strtotime($current_month)) {
				$nettotal = $this->Xin_model->company_currency_sign('0',$r->company_id);
			}

			//	$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id,$start_date_y_m);
			if (in_array('286', $role_resources_ids) || in_array('283', $role_resources_ids)) {
				$data[] = array(

					$emp_id,
					$iemp_name,
					$emp_payroll_wage,
					$basic_salary,
					//$nettotal,
					$nettotal,
					$status_pay,
					$management_status,
					$act,
				);
			} else {
				$data[] = array(
					$emp_id,
					$iemp_name,
					$emp_payroll_wage,
					$basic_salary,
					//$nettotal,
					$nettotal,
					$status_pay,
					$management_status
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip->num_rows(),
			"recordsFiltered" => $payslip->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}


	public function bank_format_details()
	{
		error_reporting(0);
        ini_set('max_execution_time', '1000');
		$data['title'] = $this->Xin_model->site_title();
		$data['path_url'] = 'bank_format';
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/generate_payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		// date and employee id/company id
		$p_date = $this->input->get("month_year");
		$location_id = $this->input->get("location_id");
		$value_date = $this->input->get("value_date");
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('280', $role_resources_ids)) {
			$payslip = $this->Payroll_model->bank_format_details_list($location_id, $p_date, '', '');
		} else {
			$payslip = $this->Payroll_model->bank_format_details_list('', '', $user_info[0]->company_id, $session['user_id']);
		}

		$system = $this->Xin_model->read_setting_info(1);
		$data = array();

		foreach ($payslip->result() as $r) {
			// user full name
			$emp_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			$full_name = '<a target="_blank" class="text-primary" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '">' . $emp_name . '</a>';

			// get total hours > worked > employee
			$pay_date = $this->input->get('month_year');
			//overtime request
			$overtime_count = $this->Overtime_request_model->get_overtime_request_count($r->user_id, $this->input->get('month_year'));
			$re_hrs_old_int1 = 0;
			$re_hrs_old_seconds = 0;
			$re_pcount = 0;
			foreach ($overtime_count as $overtime_hr) {
				// total work
				$request_clock_in = new DateTime($overtime_hr->request_clock_in);
				$request_clock_out = new DateTime($overtime_hr->request_clock_out);
				$re_interval_late = $request_clock_in->diff($request_clock_out);
				$re_hours_r = $re_interval_late->format('%h');
				$re_minutes_r = $re_interval_late->format('%i');
				$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

				$re_str_time = $re_total_time;

				$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

				sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$re_hrs_old_int1 += $re_hrs_old_seconds;

				$re_pcount = gmdate("H", $re_hrs_old_int1);
			}
			$result = $this->Payroll_model->total_hours_worked($r->user_id, $pay_date);
			$hrs_old_int1 = 0;
			$pcount = 0;
			$Trest = 0;
			$total_time_rs = 0;
			$hrs_old_int_res1 = 0;
			foreach ($result->result() as $hour_work) {
				// total work
				$clock_in = new DateTime($hour_work->clock_in);
				$clock_out = new DateTime($hour_work->clock_out);
				$interval_late = $clock_in->diff($clock_out);
				$hours_r = $interval_late->format('%h');
				$minutes_r = $interval_late->format('%i');
				$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

				$str_time = $total_time;

				$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

				sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$hrs_old_int1 += $hrs_old_seconds;

				$pcount = gmdate("H", $hrs_old_int1);
			}
			$pcount = $pcount + $re_pcount;
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// 1: salary type
			if ($r->wages_type == 1) {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			} else if ($r->wages_type == 2) {
				$wages_type = $this->lang->line('xin_employee_daily_wages');
				if ($pcount > 0) {
					$basic_salary = $pcount * $r->basic_salary;
				} else {
					$basic_salary = $pcount;
				}
				$p_class = 'emo_hourly_pay';
				$view_p_class = 'hourlywages_template_modal';
			} else {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			}

			$location_id = $r->location_id;
			$monthyear = $payyear . "-" . $paymonth;
			$get_management_status = $this->Employees_model->get_management_employee_status($r->user_id, $location_id, $p_date);
			if (empty($get_management_status)) {
				$management_status_val = 1;
			} else {
				$management_status_val = 2;
			}

			// all allowances, all loan/deductions
			$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($r->user_id, $p_date, $basic_salary);
			$salary_calc = $this->Xin_model->payroll_GrossSalary($r->user_id, $p_date, $basic_salary, $all_allo_and_dedct);
			$total_net_salary = $salary_calc[0];
			$status_pay_val = 0;
			// make payment
			if ($system[0]->is_half_monthly == 1) {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($r->user_id, $p_date);
				$payment_last = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($r->user_id, $p_date);
				if ($payment_check->num_rows() > 1) {
					//foreach($payment_last as $payment_half_last){
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$status_pay_val = 1;
					//$mpay = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_payroll_make_payment').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".'.$p_class.'" data-employee_id="'. $r->user_id . '" data-payment_date="'. $p_date . '" data-company_id="'.$this->input->get("company_id").'"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('278', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code><br>' . '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $payment_last[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span><code>' . $this->lang->line('xin_title_second_half') . '</code>';
					//}
					//detail link
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$status_pay_val = 1;
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay .= '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('278', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code>';
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					//detail link
					$detail = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $pay_date . '"><span class="fa fa-eye"></span></button></span>';

					$total_net_salary = $total_net_salary;
				}
				//detail link
				//$detail = '';
			} else {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($r->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$status_pay_val = 1;
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('278', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					//$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					$total_net_salary = $total_net_salary;
				}
				//detail link
				$detail = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '"" data-net="' . $total_net_salary . '"><span class="fa fa-eye"></span></button></span>';
			}

			$net_salary = number_format((float)$total_net_salary, 2, '.', '');
			$basic_salary = number_format((float)$basic_salary, 2, '.', '');
			//}

			if ($basic_salary == 0 || $basic_salary == '') {
				$fmpay = '';
			} else {
				$fmpay = $mpay;
			}

			//new leave calc
			$month_year = $pay_date;
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leaves = $this->Employees_model->emp_leave_fetch($r->user_id, $start_date_y);

			$user_id = $r->user_id;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}
			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$k = 1;
			$extra_amount = $tot_days_lop_normal = 0;
			$tot_days = 0;

			//Using attendance
			$arry_years = array();
			$st = '';
			$p_count_val = 0;
			$start_date_co = $year . '-' . $month . '-' . '01';
			$end_date_co = $year . '-' . $month . '-' . $daysInMonth;


			$present_arr = array();
			//$st = $this->db->last_query();
			$leave_arr = $half_leave_arr = array();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$user = $this->Xin_model->read_user_info($r->user_id);
			if (strtotime($month_year) == strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				if ($user[0]->date_of_leaving) {
					if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
						if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
							$difference_days = 0;
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else {
						$difference_days = 0;
					}
				} else {
					$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
					if ($get_attendance_last_entered) {
						$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
						//$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days = $difference->format("%a") + 1;
					} else {
						$difference_days = 0;
					}
				}
			} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
				if ($get_attendance_last_entered) {
					$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
					//$month_year_att_end = $month_year.'-'.date('d');
					$startDate = new DateTime($month_year_att);
					$endDate = new DateTime($month_year_att_end);
					$difference = $endDate->diff($startDate);
					$difference_days = $difference->format("%a") + 1;
				} else {
					$difference_days = 0;
				}
			} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
				$difference_days = 0;
			}
			if ($difference_days >= 25) {
				$difference_days = $daysInMonth;
			}


			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

			//end number of calc
			$attendence_calc = $this->Xin_model->AttendnceCount_calc_common($r->office_shift_id, $start_date_co, $end_date_co, $r->company_id, $r->user_id, $difference_days, $year, $month);
			if ($attendence_calc) {
				$tot_days_lop_normal = $attendence_calc[0];
				$totl_num_days_pres = $attendence_calc[1];
			} else {
				$tot_days_lop_normal = 0;
				$totl_num_days_pres = 0;
			}
			$tot_days_lop = $tot_days_lop_normal;

			$bs_pay = $r->basic_salary;
			/* Net salary calculations */
			$net_salary_calc = $this->Xin_model->NetsalaryCalcCommon($total_net_salary, $daysInMonth, $totl_num_days_pres);
			$net_salary = $net_salary_calc[0];


			/* Lop Calc Common */
			$lop_calc = $this->Xin_model->LopCalcCommon($net_salary, $daysInMonth, $tot_days_lop);
			$leave_cut_salary = $lop_calc[0];
			/* End Lop calc Common */

			/* Final Net salary */
			$final_net_salary = $this->Xin_model->FinalNetSalaryCalcCommon($net_salary, $leave_cut_salary, $all_allo_and_dedct);
			$net_salary = $final_net_salary[0];

			$start_date_y_m = date('Y-m', strtotime($month_year));
			//Indemnity calc

			$totl_amt = 0;
			//leave encashment calc
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

			$totl_amt_leva = $annual_amt_pay = 0;
			if ($emp_leave_enchas) {
				foreach ($emp_leave_enchas as $emp_leave_ench) {
					$totl_amt_leva += $emp_leave_ench->amount;
				}
			}
			
			$encashment = $this->Payroll_model->GetEncashmentamount($user_id, $start_date_y_m);
        	foreach ($encashment as $emp_leave) {
        		if ($emp_leave->given_methode == 'Connect_To_Payroll') {
        			$annual_amt_pay += $emp_leave->amount;
        		}
        	}
			$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $annual_amt_pay;
			if ($net_salary < 0 || $basic_salary <= 0) {
				$net_salary = '0.00';
			}
			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary,$r->company_id);

			$iemp_name = $emp_name ;

			//action link
			$act = $detail . $fmpay . $delete;
			if ($r->wages_type == 1) {
				if ($system[0]->is_half_monthly == 1) {
					$emp_payroll_wage = $wages_type ;
				} else {
					$emp_payroll_wage = $wages_type;
				}
			} else {
				$emp_payroll_wage = $wages_type;
			}
			if (in_array('83', $role_resources_ids)) {
				$emp_id = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="Employee Detail">' . $r->employee_id . ' <i class="fas fa-arrow-circle-right"></i></a>';
			} else {
				$emp_id = $r->employee_id;
			}

			$paymonth = date('m', strtotime($pay_date));
			$payyear = date('Y', strtotime($pay_date));
			$empdata = $this->Employees_model->get_employee_details($user_id);
			$basepay = $empdata[0]->basic_salary;
			$no_of_days = date('t', strtotime($pay_date));


			// Late Deduction Start

			$latededuction = $this->Payroll_model->GetLateDeductionCalcCommon($user_id, $paymonth, $payyear, $no_of_days);
			$late_amount = $latededuction[0];

			// Late Deduction End


			$userinfo = $this->Employees_model->get_employee_details($user_id);
			$companyinfo = $this->Employees_model->get_company_details($userinfo[0]->company_id);
			$late_status = $companyinfo[0]->late_deduction;
			if ($late_status == 'yes') {
				$late_amount = $late_amount;
			} else {
				$late_amount = 0;
			}

			// Get Overtime Amount
			$overtime = $this->Payroll_model->GetOvertimeCalcCommon($user_id, $paymonth, $payyear);
			$overtime_amount = $overtime[0];
			// End Overtime Amount

			// Air ticket Encashment Start
			$encashment_check = $this->Employees_model->employee_encashment_check($user_id, $month_year);
			if (!empty($encashment_check)) {
				$encashstatus = $encashment_check[0]->status;
				if (!is_null($encashstatus)) {
					$encashrate = $this->Employees_model->get_employee_encashrate_payroll($user_id, $month_year);
					$encash_amt = $encashrate[0]->amount;
				} else {
					$encash_amt = 0;
				}
			} else {
				$encash_amt = 0;
			}

			// Air ticket Encashment End
			//$nettotal = $net_salary;
			$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
			$otstatus = $overtimestatus[0]->ot_eligible;
			if ($otstatus == "yes") {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary + $overtime_amount - $late_amount;
				}
			} else {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary - $late_amount;
				}
			}


			/* Expense Claim Start */
			if ($nettotal > 0) {
				$expense_total_claim = $this->Xin_model->FindExpenseClaimTotal($user_id, $this->input->get('month_year'));
				$nettotal = $nettotal + $expense_total_claim + $encash_amt;
			}
			/* Expense Claim End */

			$nettotal = $this->Xin_model->company_currency_sign($nettotal,$r->company_id);


			$location_id = $r->location_id;
			$monthyear = $payyear . "-" . $paymonth;
			$get_management_status = $this->Employees_model->get_management_employee_status($user_id, $location_id, $p_date);

			if (empty($get_management_status)) {
				$management_status = "Pending";
			} else {
				$management_status = $get_management_status[0]->status;
			}


			$days_in_month = $days = date("t");

			$payment_check = $this->Payroll_model->read_make_payment_payslip_check($user_id, $p_date);

			if ($payment_check->num_rows() > 0) {

				$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
				$nettotal = $this->Xin_model->company_currency_sign($make_payment[0]->net_salary,$r->company_id);
			}

			$companybank = $this->Xin_model->get_company_bankdetails();
			$companyaccno = $companybank[0]->account_no;
			$bankdetails = $this->Employees_model->get_bank_details($user_id);
			$bankcode = $bankdetails[0]->bank_code;
			$bankname = $bankdetails[0]->bank_name;
			$bank_account_number = $bankdetails[0]->account_number;
			$current_month = date('Y-m');
			$search_month = date('Y-m', strtotime($month_year));
			if (strtotime($search_month) > strtotime($current_month)) {
				$nettotal = $this->Xin_model->company_currency_sign('0',$r->company_id);
			}
			if ($management_status_val > 1 && $status_pay_val < 1) {
				$data[] = array(
					$bankcode,
					$bank_account_number,
					$emp_name,
					$nettotal,
					$companyaccno,
					$value_date
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip->num_rows(),
			"recordsFiltered" => $payslip->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function calculateSatuSundDaysInMonth($year = '', $month = '', $off_day_arr)
	{
		//in case no values are passed to the function, use the current month and year
		if ($year == '') {
			$year = date('Y');
		}
		if ($month == '') {
			$month = date('m');
		}
		//create a start and an end datetime value based on the input year
		$startdate = strtotime($year . '-' . $month . '-01');
		$Todaysdate = strtotime(date('Y-m-d'));

		$enddate = strtotime('+' . (date('t', $startdate) - 1) . ' days', $startdate);
		$currentdate = $startdate;
		//get the total number of days in the month
		$return = 0;
		//$return = intval((date('t',$startdate)),10);
		//loop through the dates, from the start date to the end date
		while ($currentdate <= $Todaysdate) {
			//if($currentdate <= $Todaysdate ){
			//if you encounter a Saturday or Sunday, remove from the total days count
			if ((in_array(date('D', $currentdate), $off_day_arr))) {
				$return += 1;
			}
			$currentdate = strtotime('+1 day', $currentdate);
			//}

		} //end date walk loop
		//return the number of working days
		return $return;
	}

	// advance salary list
	public function advance_salary_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/advance_salary", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		// print_r($user_info);exit;
		$role_resources_ids = $this->Xin_model->user_role_resource();

		if ($user_info[0]->user_role_id == 1 || in_array("384", $role_resources_ids) || in_array('393', $role_resources_ids)) {
			$advance_salary = $this->Payroll_model->get_advance_salaries();
		} else {
			if (in_array("384", $role_resources_ids) || in_array("385", $role_resources_ids) || in_array("386", $role_resources_ids) || in_array("387", $role_resources_ids)) {
				$advance_salary = $this->Payroll_model->get_advance_salaries($user_info[0]->company_id);
			} else {
				$advance_salary = $this->Payroll_model->get_advance_salaries_single($user_info[0]->user_id);
			}
		}
		$data = array();

		foreach ($advance_salary->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
			} else {
				$full_name = '--';
			}

			$d = explode('-', $r->month_year);
			$get_month = date('F', mktime(0, 0, 0, $d[1], 10));
			$month_year = $get_month . ', ' . $d[0];
			// get net salary
			$advance_amount = $this->Xin_model->company_currency_sign($r->advance_amount,$r->company_id);
			// get date > created at > and format
			$cdate = $this->Xin_model->set_date_format($r->created_at);
			// get status
			if ($r->status == 0) : $status = $this->lang->line('xin_pending');
			elseif ($r->status == 1) : $status = $this->lang->line('xin_accepted');
			else : $status = $this->lang->line('xin_rejected');
			endif;

			if ($r->status == 0) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} elseif ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} elseif ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->third_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Third approval</span>';
				} elseif ($r->third_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Third approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} elseif ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}
			// get monthly installment
			$monthly_installment = $this->Xin_model->company_currency_sign($r->monthly_installment,$r->company_id);

			// get onetime deduction value
			if ($r->one_time_deduct == 1) : $onetime = $this->lang->line('xin_yes');
			else : $onetime = $this->lang->line('xin_no');
			endif;
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			$combhr = '';
			if (in_array("389", $role_resources_ids)) {
				$combhr .= '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-advance_salary_id="' . $r->advance_salary_id . '"><span class="fa fa-eye"></span></button></span>';
			}
			if (in_array("392", $role_resources_ids)) {
				$combhr .= '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Extend Date"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data-loan-dec" data-field_id="' . $r->advance_salary_id . '" data-field_type="salary_loan_extend" ><span class="fas fa-calendar-alt"></span></button></span>';
			}

			if (in_array("390", $role_resources_ids)) {
				if ($user_info[0]->user_role_id == 1) {
					$combhr .= '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-advance_salary_id="' . $r->advance_salary_id . '"><span class="fas fa-pencil-alt"></span>';
				} else {
					if ($r->status == 0) {
						$combhr .= '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-advance_salary_id="' . $r->advance_salary_id . '"><span class="fas fa-pencil-alt"></span>';
					}
				}
				// $combhr .= '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-advance_salary_id="' . $r->advance_salary_id . '"><span class="fas fa-pencil-alt"></span>';
			}
			if (in_array("391", $role_resources_ids)) {
				$combhr .= '</button></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->advance_salary_id . '"><span class="far fa-trash-alt"></span></button></span>';
			}
			// 			$combhr = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-advance_salary_id="'. $r->advance_salary_id . '"><span class="fa fa-eye"></span></button></span>';
			// 			if ($user_info[0]->user_role_id == 1) {
			// 			    $combhr .= '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Extend Date"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data-loan-dec" data-field_id="'. $r->advance_salary_id . '" data-field_type="salary_loan_extend" ><span class="fas fa-calendar-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-advance_salary_id="'. $r->advance_salary_id . '"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-xs btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->advance_salary_id . '"><span class="far fa-trash-alt"></span></button></span>';
			// 			} else if (in_array("513", $role_resources_ids) || in_array("514", $role_resources_ids)) {
			// 			    $combhr .= '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light"  data-toggle="modal" data-target=".edit-modal-data"  data-advance_salary_id="'. $r->advance_salary_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			// 			}

			if (in_array('389', $role_resources_ids) || in_array('392', $role_resources_ids) || in_array('390', $role_resources_ids) || in_array('391', $role_resources_ids)) {
				$data[] = array(

					$comp_name,
					$full_name,
					$advance_amount,
					$month_year,
					$onetime,
					$monthly_installment,
					$cdate,
					$status,
					$combhr,
				);
			} else {
				$data[] = array(
					$comp_name,
					$full_name,
					$advance_amount,
					$month_year,
					$onetime,
					$monthly_installment,
					$cdate,
					$status
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $advance_salary->num_rows(),
			"recordsFiltered" => $advance_salary->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// advance salary report list
	public function advance_salary_report_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/advance_salary", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$advance_salary = $this->Payroll_model->get_advance_salaries_report();

		$data = array();

		foreach ($advance_salary->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
			} else {
				$full_name = '--';
			}

			$d = explode('-', $r->month_year);
			$get_month = date('F', mktime(0, 0, 0, $d[1], 10));
			$month_year = $get_month . ', ' . $d[0];
			// get net salary
			$advance_amount = $this->Xin_model->company_currency_sign($r->advance_amount,$r->company_id);
			// get date > created at > and format
			$cdate = $this->Xin_model->set_date_format($r->created_at);
			// get status
			if ($r->status == 0) : $status = $this->lang->line('xin_pending');
			elseif ($r->status == 1) : $status = $this->lang->line('xin_accepted');
			else : $status = $this->lang->line('xin_rejected');
			endif;
			// get monthly installment
			$monthly_installment = $this->Xin_model->company_currency_sign($r->monthly_installment,$r->company_id);

			$remainig_amount = $r->advance_amount - $r->total_paid;
			$ramount = $this->Xin_model->company_currency_sign($remainig_amount,$r->company_id);

			// get onetime deduction value
			if ($r->one_time_deduct == 1) : $onetime = $this->lang->line('xin_yes');
			else : $onetime = $this->lang->line('xin_no');
			endif;
			if ($r->advance_amount == $r->total_paid) {
				$all_paid = '<span class="badge badge-success">' . $this->lang->line('xin_all_paid') . '</span>';
			} else {
				$all_paid = '<span class="badge badge-warning">' . $this->lang->line('xin_remaining') . '</span>';
			}
			//total paid
			$total_paid = $this->Xin_model->company_currency_sign($r->total_paid,$r->company_id);
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$data[] = array(
				'<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-info waves-effect waves-light" data-toggle="modal" data-target=".view-modal-data" data-employee_id="' . $r->employee_id . '"><span class="fa fa-eye"></span></button></span>',
				$comp_name,
				$full_name,
				$advance_amount,
				$total_paid,
				$ramount,
				$all_paid,
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $advance_salary->num_rows(),
			"recordsFiltered" => $advance_salary->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// get payroll template info by id
	public function payroll_template_read()
	{

		$session = $this->session->userdata('username');
		// 		var_dump($session);die();
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');

		// get addd by > template
		$user = $this->Xin_model->read_user_info($id);
		// user full name
		$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_name = $designation[0]->designation_name;
		} else {
			$designation_name = '--';
		}
		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_name = $department[0]->department_name;
		} else {
			$department_name = '--';
		}
		$month_year = $this->input->get('month_year');
		$net_amount = $this->input->get('net_amount');
		$start_date_y = date('Y', strtotime($this->input->get('month_year')));
		$start_date_y_m = date('Y-m', strtotime($this->input->get('month_year')));
		$emp_leave_in_year = $this->Employees_model->emp_leave_in_year($id, $start_date_y);

		$employee_in_notice_period = 0;
		$resignation = $this->Resignation_model->get_employee_resignation_final_by_date($user[0]->user_id, $month_year);
		$loan_outstanding_amount = $advance_outstanding_amount = 0;
		if ($resignation->num_rows() > 0) {
			$resignation = $resignation->result()[0];

			$employee_in_notice_period = 1;
			if (strtotime($resignation->notice_date) < time())
				$employee_in_notice_period = 2;

			$loan_outstanding_amount = $this->Loan->getOutstandingAmount($user[0]->user_id);
			$advance_outstanding_amount = $this->Advance->getOutstandingAmount($user[0]->user_id);
		}

		$data = array(
			'first_name' => $user[0]->first_name,
			'middle_name' => $user[0]->middle_name,
			'last_name' => $user[0]->last_name,
			'company_id' => $user[0]->company_id,
			'employee_id' => $user[0]->employee_id,
			'user_id' => $user[0]->user_id,
			'department_name' => $month_year,
			'designation_name' => $designation_name,
			'date_of_joining' => $user[0]->date_of_joining,
			'profile_picture' => $user[0]->profile_picture,
			'gender' => $user[0]->gender,
			'wages_type' => $user[0]->wages_type,
			'basic_salary' => $user[0]->basic_salary,
			'daily_wages' => $user[0]->daily_wages,
			'month_year' => $month_year,
			'month_year_check' => $month_year,
			'net_amount' => $net_amount,
			//'late_deduction' => $user[0]->late_deduction,
			'employee_in_notice_period' => $employee_in_notice_period,
			'resignation' => $resignation,
			'loan_outstanding_amount' => $loan_outstanding_amount,
			'advance_outstanding_amount' => $advance_outstanding_amount,
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_templates', $data);
		} else {
			redirect('admin/');
		}
	}

	// pay hourly read > payslip
	public function hourlywage_template_read()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$month_year = $this->input->get('month_year');
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		// get addd by > template
		$user = $this->Xin_model->read_user_info($id);
		// user full name
		$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_name = $designation[0]->designation_name;
		} else {
			$designation_name = '--';
		}
		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_name = $department[0]->department_name;
		} else {
			$department_name = '--';
		}
		$data = array(
			'first_name' => $user[0]->first_name,
			'company_id' => $user[0]->company_id,
			'middle_name' => $user[0]->middle_name,
			'last_name' => $user[0]->last_name,
			'employee_id' => $user[0]->employee_id,
			'user_id' => $user[0]->user_id,
			'euser_id' => $user[0]->user_id,
			'department_name' => $department_name,
			'designation_name' => $designation_name,
			'date_of_joining' => $user[0]->date_of_joining,
			'profile_picture' => $user[0]->profile_picture,
			'gender' => $user[0]->gender,
			'wages_type' => $user[0]->wages_type,
			'basic_salary' => $user[0]->basic_salary,
			'daily_wages' => $user[0]->daily_wages,
			'month_year' => $month_year,
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_templates', $data);
		} else {
			redirect('admin/');
		}
	}

	// pay monthly > create payslip
	public function pay_salary()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		// get addd by > template
		$user = $this->Xin_model->read_user_info($id);
		$result = $this->Payroll_model->read_template_information($user[0]->monthly_grade_id);
		//$department = $this->Department_model->read_department_information($user[0]->department_id);
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_id = $designation[0]->designation_id;
		} else {
			$designation_id = 1;
		}
		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_id = $department[0]->department_id;
		} else {
			$department_id = 1;
		}

		$month_year = $this->input->get('pay_date');
		$employee_in_notice_period = 0;
		$resignation = $this->Resignation_model->get_employee_resignation_final_by_date($user[0]->user_id, $month_year);
		$loan_outstanding_amount = $advance_outstanding_amount = $airticket_outstanding_amount = 0;
		if ($resignation->num_rows() > 0) {
			$resignation = $resignation->result()[0];

			$employee_in_notice_period = 1;
			if (strtotime($resignation->notice_date) < time())
				$employee_in_notice_period = 2;

			$loan_outstanding_amount = $this->Loan->getOutstandingAmount($user[0]->user_id);
			$advance_outstanding_amount = $this->Advance->getOutstandingAmount($user[0]->user_id);
		}

		//$location = $this->Location_model->read_location_information($department[0]->location_id);
		$data = array(
			'department_id' => $department_id,
			'designation_id' => $designation_id,
			'company_id' => $user[0]->company_id,
			'location_id' => $user[0]->location_id,
			'user_id' => $user[0]->user_id,
			'wages_type' => $user[0]->wages_type,
			'basic_salary' => $user[0]->basic_salary,
			'daily_wages' => $user[0]->daily_wages,
			//'emp_late_deduction' => $user[0]->late_deduction,
			'employee_in_notice_period' => $employee_in_notice_period,
			'resignation' => $resignation,
			'loan_outstanding_amount' => $loan_outstanding_amount,
			'advance_outstanding_amount' => $advance_outstanding_amount,
			'airticket_outstanding_amount' => $airticket_outstanding_amount,
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_make_payment', $data);
		} else {
			redirect('admin/');
		}
	}


	public function pay_salary_new()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		$management_status = $this->input->get('management_status');
		// get addd by > template
		$user = $this->Xin_model->read_user_info($id);
		$result = $this->Payroll_model->read_template_information($user[0]->monthly_grade_id);
		//$department = $this->Department_model->read_department_information($user[0]->department_id);
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_id = $designation[0]->designation_id;
		} else {
			$designation_id = 1;
		}
		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_id = $department[0]->department_id;
		} else {
			$department_id = 1;
		}

		$month_year = $this->input->get('pay_date');
		$employee_in_notice_period = 0;
		$resignation = $this->Resignation_model->get_employee_resignation_final_by_date($user[0]->user_id, $month_year);
		$loan_outstanding_amount = $advance_outstanding_amount = 0;
		if ($resignation->num_rows() > 0) {
			$resignation = $resignation->result()[0];

			$employee_in_notice_period = 1;
			if (strtotime($resignation->notice_date) < time())
				$employee_in_notice_period = 2;

			$loan_outstanding_amount = $this->Loan->getOutstandingAmount($user[0]->user_id);
			$advance_outstanding_amount = $this->Advance->getOutstandingAmount($user[0]->user_id);
		}

		//$location = $this->Location_model->read_location_information($department[0]->location_id);
		$data = array(
			'department_id' => $department_id,
			'designation_id' => $designation_id,
			'management_status' => $management_status,
			'company_id' => $user[0]->company_id,
			'location_id' => $user[0]->location_id,
			'user_id' => $user[0]->user_id,
			'wages_type' => $user[0]->wages_type,
			'basic_salary' => $user[0]->basic_salary,
			'daily_wages' => $user[0]->daily_wages,
			//'emp_late_deduction' => $user[0]->late_deduction,
			'employee_in_notice_period' => $employee_in_notice_period,
			'resignation' => $resignation,
			'loan_outstanding_amount' => $loan_outstanding_amount,
			'advance_outstanding_amount' => $advance_outstanding_amount,
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_make_payment', $data);
		} else {
			redirect('admin/');
		}
	}

	// pay hourly > create payslip
	public function pay_hourly()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		// get addd by > template
		$user = $this->Xin_model->read_user_info($id);
		$result = $this->Payroll_model->read_template_information($user[0]->monthly_grade_id);
		//$department = $this->Department_model->read_department_information($user[0]->department_id);
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_id = $designation[0]->designation_id;
		} else {
			$designation_id = 1;
		}
		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_id = $department[0]->department_id;
		} else {
			$department_id = 1;
		}
		//$location = $this->Location_model->read_location_information($department[0]->location_id);
		$data = array(
			'department_id' => $department_id,
			'designation_id' => $designation_id,
			'company_id' => $user[0]->company_id,
			'location_id' => $user[0]->location_id,
			'user_id' => $user[0]->user_id,
			'euser_id' => $user[0]->user_id,
			'wages_type' => $user[0]->wages_type,
			'basic_salary' => $user[0]->basic_salary,
			'daily_wages' => $user[0]->daily_wages,
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_make_payment', $data);
		} else {
			redirect('admin/');
		}
	}

	// Validate and add info in database > add monthly payment
	public function add_pay_monthly()
	{

		if ($this->input->post('add_type') == 'add_monthly_payment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			/*if($Return['error']!=''){
       		$this->output($Return
			);
    	}*/
			$basic_salary = $this->input->post('basic_salary');
			$system = $this->Xin_model->read_setting_info(1);
			$euser_info = $this->Xin_model->read_user_info($this->input->post('emp_id'));
			if ($system[0]->is_half_monthly == 1) {
				$is_half_monthly_payroll = 1;
			} else {
				$is_half_monthly_payroll = 0;
			}

			// get advance salary
			$advance_salary = $this->Payroll_model->advance_salary_by_employee_id($this->input->post('emp_id'));
			$is_advance_deducted = $deduct_salary = $advance_salary_id = 0;
			if (!is_null($advance_salary)) {
				$emp_value = $this->Payroll_model->get_paid_salary_by_employee_id($this->input->post('emp_id'));
				$monthly_installment = $advance_salary[0]->monthly_installment;
				$total_paid = $advance_salary[0]->total_paid;
				$advance_amount = $advance_salary[0]->advance_amount;
				$advance_salary_id = $advance_salary[0]->advance_salary_id;
				//check ifpaid
				$em_advance_amount = $emp_value[0]->advance_amount;
				$em_total_paid = $emp_value[0]->total_paid;
				if ($em_advance_amount > $em_total_paid) {
					if ($monthly_installment == '' || $monthly_installment == 0) {
						$add_amount = $em_total_paid + $this->input->post('advance_amount');
						//pay_date //emp_id
						$adv_data = array('total_paid' => $add_amount);
						$payslip_deduct = $this->input->post('advance_amount');
						//
						$this->Payroll_model->updated_advance_salary_paid_amount($adv_data, $this->input->post('emp_id'));
						$deduct_salary = $payslip_deduct;
						$is_advance_deducted = 1;
					} else {
						$add_amount = $em_total_paid + $this->input->post('advance_amount');
						$payslip_deduct = $this->input->post('advance_amount');
						//pay_date //emp_id
						$adv_data = array('total_paid' => $add_amount);
						//
						$this->Payroll_model->updated_advance_salary_paid_amount($adv_data, $this->input->post('emp_id'));
						$deduct_salary = $payslip_deduct;
						$is_advance_deducted = 1;
					}
				}
			} else {
				$deduct_salary = 0;
				$is_advance_deducted = 0;
			}
			if ($this->input->post('total_outstanding')) {
				$total_outstanding = $this->input->post('total_outstanding');
			} else {
				$total_outstanding = 0;
			}
			if ($this->input->post('asset_complaint')) {
				$asset_complaint_amt = $this->input->post('asset_complaint');
			} else {
				$asset_complaint_amt = 0;
			}
			if ($this->input->post('final_settlement_id')) {
				$final_settlement_id = $this->input->post('final_settlement_id');
			} else {
				$final_settlement_id = 0;
			}
			$jurl = random_string('alnum', 40);
			$data = array(
				'employee_id' => $this->input->post('emp_id'),
				'department_id' => $this->input->post('department_id'),
				'company_id' => $this->input->post('company_id'),
				'location_id' => $this->input->post('location_id'),
				'designation_id' => $this->input->post('designation_id'),
				'salary_month' => $this->input->post('pay_date'),
				'basic_salary' => $basic_salary,
				'net_salary' => $this->input->post('net_salary'),
				'wages_type' => $this->input->post('wages_type'),
				'is_half_monthly_payroll' => $is_half_monthly_payroll,
				'total_commissions' => $this->input->post('total_commissions'),
				'total_statutory_deductions' => $this->input->post('total_statutory_deductions'),
				'total_other_payments' => $this->input->post('total_other_payments'),
				'total_allowances' => $this->input->post('total_allowances'),
				'total_loan' => $this->input->post('total_loan'),
				'total_overtime' => $this->input->post('total_overtime'),
				'total_late_deduction' => $this->input->post('late_deduction'),
				'saudi_gosi_amount' => $this->input->post('saudi_gosi_amount'),
				'saudi_gosi_percent' => $this->input->post('saudi_gosi_percent'),
				'is_advance_salary_deduct' => $is_advance_deducted,
				'advance_salary_amount' => $deduct_salary,
				'is_payment' => '1',
				'status' => '0',
				'payslip_type' => 'full_monthly',
				'payslip_key' => $jurl,
				'year_to_date' => date('d-m-Y'),
				'created_at' => date('d-m-Y h:i:s'),
				'leave_deduction' => $this->input->post('leave_deduction'),
				'amt_indemnity' => $this->input->post('totl_amt_indemnity'),
				'amt_leave_encashment' => $this->input->post('totl_amt_leav_encashment'),
				'annual_leave_amt' => $this->input->post('leave_salary'),
				'total_outstanding' => $total_outstanding,
				'asset_complaint_amt' => $asset_complaint_amt,
				'final_settlement_id' => $final_settlement_id,
				'monthy_present_days' => $this->input->post('monthy_present_days'),
				'expense_claim' => $this->input->post('expenses_amount'),
				'airticket_encashment' => $this->input->post('airticket_encash'),
				'status' => 2 //setting status to full approval on making payment
			);
			$result = $this->Payroll_model->add_salary_payslip($data);

			$system_settings = system_settings_info(1);
			if ($system_settings->online_payment_account == '') {
				$online_payment_account = 0;
			} else {
				$online_payment_account = $system_settings->online_payment_account;
			}

			if ($result) {

				$ivdata = array(
					'amount' => $this->input->post('net_salary'),
					'account_id' => $online_payment_account,
					'transaction_type' => 'expense',
					'dr_cr' => 'cr',
					'transaction_date' => date('Y-m-d'),
					'payer_payee_id' => $this->input->post('emp_id'),
					'payment_method_id' => 3,
					'description' => 'Payroll Payments',
					'reference' => 'Payroll Payments',
					'invoice_id' => $result,
					'client_id' => $this->input->post('emp_id'),
					'created_at' => date('Y-m-d H:i:s')
				);
				$this->Finance_model->add_transactions($ivdata);
				// update data in bank account
				$account_id = $this->Finance_model->read_bankcash_information($online_payment_account);
				if (isset($account_id[0])) {
					$acc_balance = $account_id[0]->account_balance - $this->input->post('net_salary');
					$data3 = array(
						'account_balance' => $acc_balance
					);
					$this->Finance_model->update_bankcash_record($data3, $online_payment_account);
				}


				// set allowance
				$salary_allowances = $this->Employees_model->read_salary_allowances_with_status($this->input->post('emp_id'));
				$count_allowances = $this->Employees_model->count_employee_allowances_with_status($this->input->post('emp_id'));
				$allowance_amount = 0;
				if ($count_allowances > 0) {
					foreach ($salary_allowances as $sl_allowances) {
						$esl_allowances = $sl_allowances->allowance_amount;
						if ($system[0]->is_half_monthly == 1) {
							if ($system[0]->half_deduct_month == 2) {
								$eallowance_amount = $esl_allowances / 2;
							} else {
								$eallowance_amount = $esl_allowances;
							}
						} else {
							$eallowance_amount = $esl_allowances;
						}
						$allowance_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'allowance_title' => $sl_allowances->allowance_title,
							'allowance_amount' => $eallowance_amount,
							'is_allowance_taxable' => $sl_allowances->is_allowance_taxable,
							'amount_option' => $sl_allowances->amount_option,
							'created_at' => date('d-m-Y h:i:s')
						);
						$_allowance_data = $this->Payroll_model->add_salary_payslip_allowances($allowance_data);
						$allowance_amount += $eallowance_amount;
					}
				}
				// set commissions
				$salary_commissions = $this->Employees_model->read_salary_commissions_with_status($this->input->post('emp_id'));
				$count_commission = $this->Employees_model->count_employee_commissions_with_status($this->input->post('emp_id'));
				$commission_amount = 0;
				if ($count_commission > 0) {
					foreach ($salary_commissions as $sl_commission) {
						$esl_commission = $sl_commission->commission_amount;
						if ($system[0]->is_half_monthly == 1) {
							if ($system[0]->half_deduct_month == 2) {
								$ecommission_amount = $esl_commission / 2;
							} else {
								$ecommission_amount = $esl_commission;
							}
						} else {
							$ecommission_amount = $esl_commission;
						}
						$commissions_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'commission_title' => $sl_commission->commission_title,
							'commission_amount' => $ecommission_amount,
							'is_commission_taxable' => $sl_commission->is_commission_taxable,
							'amount_option' => $sl_commission->amount_option,
							'created_at' => date('d-m-Y h:i:s')
						);
						$this->Payroll_model->add_salary_payslip_commissions($commissions_data);
					}
				}
				// set other payments
				$salary_other_payments = $this->Employees_model->read_salary_other_payments_with_status($this->input->post('emp_id'));
				$count_other_payment = $this->Employees_model->count_employee_other_payments_with_status($this->input->post('emp_id'));
				$other_payment_amount = 0;
				if ($count_other_payment > 0) {
					foreach ($salary_other_payments as $sl_other_payments) {
						$esl_other_payments = $sl_other_payments->payments_amount;
						if ($system[0]->is_half_monthly == 1) {
							if ($system[0]->half_deduct_month == 2) {
								$epayments_amount = $esl_other_payments / 2;
							} else {
								$epayments_amount = $esl_other_payments;
							}
						} else {
							$epayments_amount = $esl_other_payments;
						}
						$other_payments_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'payments_title' => $sl_other_payments->payments_title,
							'payments_amount' => $epayments_amount,
							'is_otherpayment_taxable' => $sl_other_payments->is_otherpayment_taxable,
							'amount_option' => $sl_other_payments->amount_option,
							'created_at' => date('d-m-Y h:i:s')
						);
						$this->Payroll_model->add_salary_payslip_other_payments($other_payments_data);
					}
				}
				// set statutory_deductions
				$salary_statutory_deductions = $this->Employees_model->read_salary_statutory_deductions_with_status($this->input->post('emp_id'));
				$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions_with_status($this->input->post('emp_id'));
				$statutory_deductions_amount = 0;
				if ($count_statutory_deductions > 0) {
					foreach ($salary_statutory_deductions as $sl_statutory_deduction) {
						$esl_statutory_deduction = $sl_statutory_deduction->deduction_amount;
						if ($sl_statutory_deduction->deduction_title == 7) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$ededuction_amount = $sl_statutory_deduction->deduction_amount / 2;
								} else {
									$ededuction_amount = $sl_statutory_deduction->deduction_amount;
								}
							} else {
								if ($sl_statutory_deduction->statutory_options == 0) {
									$ededuction_amount = $sl_statutory_deduction->deduction_amount;
								} else {
									$ededuction_amount = ($basic_salary + $allowance_amount) / 100 * $sl_statutory_deduction->deduction_amount;
								}
							}
						} else {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$ededuction_amount = $sl_statutory_deduction->deduction_amount / 2;
								} else {
									$ededuction_amount = $sl_statutory_deduction->deduction_amount;
								}
							} else {
								$ededuction_amount = $sl_statutory_deduction->deduction_amount;
							}
						}
						$statutory_deduction_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'deduction_title' => $sl_statutory_deduction->deduction_title,
							'statutory_options' => $sl_statutory_deduction->statutory_options,
							'deduction_amount' => $ededuction_amount,
							'created_at' => date('d-m-Y h:i:s')
						);
						$this->Payroll_model->add_salary_payslip_statutory_deductions($statutory_deduction_data);
					}
				}
				// set loan
				$loan_m = date('m', strtotime($this->input->post('pay_date')));
				$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions_with_status_new($this->input->post('emp_id'), $loan_m);
				$count_loan_deduction = $this->Employees_model->count_employee_deductions_with_status_new($this->input->post('emp_id'), $loan_m);
				$loan_de_amount = 0;
				if ($count_loan_deduction > 0) {
					foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
						$esl_salary_loan_deduction = $sl_salary_loan_deduction->loan_deduction_amount;
						if ($system[0]->is_half_monthly == 1) {
							if ($system[0]->half_deduct_month == 2) {
								$eloan_deduction_amount = $esl_salary_loan_deduction / 2;
							} else {
								$eloan_deduction_amount = $esl_salary_loan_deduction;
							}
						} else {
							$eloan_deduction_amount = $esl_salary_loan_deduction;
						}
						$loan_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'loan_title' => $sl_salary_loan_deduction->loan_deduction_title,
							'loan_amount' => $eloan_deduction_amount,
							'created_at' => date('d-m-Y h:i:s'),
							'loan_id' => $sl_salary_loan_deduction->loan_deduction_id,
						);
						$_loan_data = $this->Payroll_model->add_salary_payslip_loan($loan_data);
					}
				}
				// set overtime
				$salary_overtime = $this->Employees_model->read_salary_overtime($this->input->post('emp_id'));
				$count_overtime = $this->Employees_model->count_employee_overtime($this->input->post('emp_id'));
				$overtime_amount = 0;
				if ($count_overtime > 0) {
					foreach ($salary_overtime as $sl_overtime) {
						$eovertime_hours = $sl_overtime->overtime_hours;
						$eovertime_rate = $sl_overtime->overtime_rate;
						if ($system[0]->is_half_monthly == 1) {
							if ($system[0]->half_deduct_month == 2) {
								$esl_overtime_hr = $eovertime_hours / 2;
								$esl_overtime_rate = $eovertime_rate / 2;
							} else {
								$esl_overtime_hr = $eovertime_hours;
								$esl_overtime_rate = $eovertime_rate;
							}
						} else {
							$esl_overtime_hr = $eovertime_hours;
							$esl_overtime_rate = $eovertime_rate;
						}
						$overtime_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'overtime_salary_month' => $this->input->post('pay_date'),
							'overtime_title' => $sl_overtime->overtime_type,
							'overtime_no_of_days' => $sl_overtime->no_of_days,
							'overtime_hours' => $esl_overtime_hr,
							'overtime_rate' => $esl_overtime_rate,
							'created_at' => date('d-m-Y h:i:s')
						);
						$_overtime_data = $this->Payroll_model->add_salary_payslip_overtime($overtime_data);
					}
				}


				// expense claim
				$expense_claims = $this->Payroll_model->read_expense_claims($this->input->post('emp_id'), $this->input->post('pay_date'));
				if (!empty($expense_claims)) {
					foreach ($expense_claims as $expense) {
						$data = array(
							'paid' => 1,
						);
						$expense_results = $this->Payroll_model->expense_claims_update($data, $expense->id);

						$expense_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'expense_claim_id' => $expense->id,
							'company_id' => $expense->company_id,
							'expense_date' => $expense->expense_date,
							'amount' => $expense->amount,
							'payslip_pay_date' => $this->input->post('pay_date'),
							'created_at' => date('d-m-Y h:i:s')
						);
						$_expense_claim = $this->Payroll_model->add_expense_claims($expense_data);
					}
				}


				// Advance amount
				if ($is_advance_deducted == 1) {
					//$advance_amount_lists = $this->Payroll_model->read_advance_amount_lists($this->input->post('emp_id'), $this->input->post('pay_date'));
					//if (!empty($advance_amount_lists)) {
					//foreach ($advance_amount_lists as $advance_amount_list) {
					if ($advance_salary_id > 0) {
						$advance_amount_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'advance_salary_id' => $advance_salary_id,
							// 'amount' => $advance_amount_list->advance_amount,
							'amount' => $this->input->post('advance_amount'),
							'payslip_pay_date' => $this->input->post('pay_date'),
							'created_at' => date('d-m-Y h:i:s')
						);
						$_advance_amount = $this->Payroll_model->add_advance_amount_lists($advance_amount_data);
					}
					//}
					//}
				}

				// set indeminty
				$start_date_y = date('m', strtotime($this->input->post('pay_date')));
				$start_date_y_m = date('Y-m', strtotime($this->input->post('pay_date')));
				$emp_Indemnity = $this->Employees_model->emp_indemnity_fetch($this->input->post('emp_id'), $start_date_y);
				if ($emp_Indemnity) {
					foreach ($emp_Indemnity as $emp_leave) {
						$data = array(
							'status' => 2,
							'payslip_id' => $result
						);
						$results = $this->Employees_model->indeminty_details_update($data, $emp_leave->id);
					}
				}
				// set leave encashment
				$start_date_y = date('m', strtotime($this->input->post('pay_date')));
				$start_date_y_m = date('Y-m', strtotime($this->input->post('pay_date')));
				$emp_leave_encash = $this->Employees_model->emp_leave_encashment_fetch($this->input->post('emp_id'), $start_date_y);
				if ($emp_leave_encash) {
					foreach ($emp_leave_encash as $emp_leave) {
						$cond = array('id' => $emp_leave->id);
						$data = array(
							'status' => 2,
							'payslip_id' => $result
						);
						$resultss = $this->Employees_model->edit_common('xin_employees_leave_encashment', $cond, $data);
					}
				}
				
				
				/// set Annual Leave encashment
				
				$annual_leave_encashment = $this->Payroll_model->GetEncashmentamount($this->input->post('emp_id'), $start_date_y_m);
            	if ($annual_leave_encashment){
            		foreach ($annual_leave_encashment as $annu_leave) {
            			if ($annu_leave->given_methode == 'Connect_To_Payroll') {
            			    $cond = array('id' => $annu_leave->id);
            				$data = array(
    							'status' => 'Paid',
    							'payslip_id' => $result
    						);
    						$resultss = $this->Employees_model->edit_common('xin_encashment', $cond, $data);
            			}
            		}
            	}
				
				
				//Annual leave
				$annual_leave_details = $this->Employees_model->annual_leave_details_by_id($this->input->post('annual_pay_id'));
				if ($annual_leave_details) {
					$cond = array('id' => $annual_leave_details[0]->id);
					$data = array(
						'paid_status' => 'Y',
						'payslip_id' => $result
					);
					$resultss = $this->Employees_model->edit_common('xin_annual_leave_applications', $cond, $data);
				}

				if ($this->input->post('expenses_amount') > 0) {
					$this->db->where('employee_id', $this->input->post('emp_id'));
					$this->db->where('paid', 0);
					$this->db->where('payment_method', 'payroll');
					$this->db->where('payment_method_month_year', $this->input->post('pay_date'));
					$this->db->update('xin_expense_clame', array(
						'paid' => 1,
					));
				}

				$Return['result'] = $this->lang->line('xin_success_payment_paid');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database > add monthly payment
	public function add_pay_hourly()
	{

		if ($this->input->post('add_type') == 'add_pay_hourly') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */

			/*if($Return['error']!=''){
       		$this->output($Return);
    	}*/
			$basic_salary = $this->input->post('basic_salary');
			$jurl = random_string('alnum', 40);
			$data = array(
				'employee_id' => $this->input->post('emp_id'),
				'department_id' => $this->input->post('department_id'),
				'company_id' => $this->input->post('company_id'),
				'location_id' => $this->input->post('location_id'),
				'designation_id' => $this->input->post('designation_id'),
				'salary_month' => $this->input->post('pay_date'),
				'basic_salary' => $basic_salary,
				'net_salary' => $this->input->post('net_salary'),
				'wages_type' => $this->input->post('wages_type'),
				'is_half_monthly_payroll' => 0,
				'total_commissions' => $this->input->post('total_commissions'),
				'total_statutory_deductions' => $this->input->post('total_statutory_deductions'),
				'total_other_payments' => $this->input->post('total_other_payments'),
				'total_allowances' => $this->input->post('total_allowances'),
				'total_loan' => $this->input->post('total_loan'),
				'total_overtime' => $this->input->post('total_overtime'),
				'hours_worked' => $this->input->post('hours_worked'),
				'saudi_gosi_amount' => $this->input->post('saudi_gosi_amount'),
				'saudi_gosi_percent' => $this->input->post('saudi_gosi_percent'),
				'is_payment' => '1',
				'status' => '0',
				'payslip_type' => 'hourly',
				'payslip_key' => $jurl,
				'year_to_date' => date('d-m-Y'),
				'created_at' => date('d-m-Y h:i:s')
			);
			$result = $this->Payroll_model->add_salary_payslip($data);
			$system_settings = system_settings_info(1);
			if ($system_settings->online_payment_account == '') {
				$online_payment_account = 0;
			} else {
				$online_payment_account = $system_settings->online_payment_account;
			}
			if ($result) {
				$ivdata = array(
					'amount' => $this->input->post('net_salary'),
					'account_id' => $online_payment_account,
					'transaction_type' => 'expense',
					'dr_cr' => 'cr',
					'transaction_date' => date('Y-m-d'),
					'payer_payee_id' => $this->input->post('emp_id'),
					'payment_method_id' => 3,
					'description' => 'Payroll Payments',
					'reference' => 'Payroll Payments',
					'invoice_id' => $result,
					'client_id' => $this->input->post('emp_id'),
					'created_at' => date('Y-m-d H:i:s')
				);
				$this->Finance_model->add_transactions($ivdata);
				// update data in bank account
				$account_id = $this->Finance_model->read_bankcash_information($online_payment_account);
				$acc_balance = $account_id[0]->account_balance - $this->input->post('net_salary');

				$data3 = array(
					'account_balance' => $acc_balance
				);
				$this->Finance_model->update_bankcash_record($data3, $online_payment_account);
				// set allowance
				$salary_allowances = $this->Employees_model->read_salary_allowances($this->input->post('emp_id'));
				$count_allowances = $this->Employees_model->count_employee_allowances($this->input->post('emp_id'));
				$allowance_amount = 0;
				if ($count_allowances > 0) {
					foreach ($salary_allowances as $sl_allowances) {
						$allowance_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'allowance_title' => $sl_allowances->allowance_title,
							'allowance_amount' => $sl_allowances->allowance_amount,
							'is_allowance_taxable' => $sl_allowances->is_allowance_taxable,
							'amount_option' => $sl_allowances->amount_option,
							'created_at' => date('d-m-Y h:i:s')
						);
						$_allowance_data = $this->Payroll_model->add_salary_payslip_allowances($allowance_data);
					}
				}
				// set commissions
				$salary_commissions = $this->Employees_model->read_salary_commissions($this->input->post('emp_id'));
				$count_commission = $this->Employees_model->count_employee_commissions($this->input->post('emp_id'));
				$commission_amount = 0;
				if ($count_commission > 0) {
					foreach ($salary_commissions as $sl_commission) {
						$commissions_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'commission_title' => $sl_commission->commission_title,
							'commission_amount' => $sl_commission->commission_amount,
							'is_commission_taxable' => $sl_commission->is_commission_taxable,
							'amount_option' => $sl_commission->amount_option,
							'created_at' => date('d-m-Y h:i:s')
						);
						$this->Payroll_model->add_salary_payslip_commissions($commissions_data);
					}
				}
				// set other payments
				$salary_other_payments = $this->Employees_model->read_salary_other_payments($this->input->post('emp_id'));
				$count_other_payment = $this->Employees_model->count_employee_other_payments($this->input->post('emp_id'));
				$other_payment_amount = 0;
				if ($count_other_payment > 0) {
					foreach ($salary_other_payments as $sl_other_payments) {
						$other_payments_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'payments_title' => $sl_other_payments->payments_title,
							'payments_amount' => $sl_other_payments->payments_amount,
							'is_otherpayment_taxable' => $sl_other_payments->is_otherpayment_taxable,
							'amount_option' => $sl_other_payments->amount_option,
							'created_at' => date('d-m-Y h:i:s')
						);
						$this->Payroll_model->add_salary_payslip_other_payments($other_payments_data);
					}
				}
				// set statutory_deductions
				$salary_statutory_deductions = $this->Employees_model->read_salary_statutory_deductions($this->input->post('emp_id'));
				$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions($this->input->post('emp_id'));
				$statutory_deductions_amount = 0;
				if ($count_statutory_deductions > 0) {
					foreach ($salary_statutory_deductions as $sl_statutory_deduction) {
						$statutory_deduction_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'deduction_title' => $sl_statutory_deduction->deduction_title,
							'deduction_amount' => $sl_statutory_deduction->deduction_amount,
							'statutory_options' => $sl_statutory_deduction->statutory_options,
							'created_at' => date('d-m-Y h:i:s')
						);
						$this->Payroll_model->add_salary_payslip_statutory_deductions($statutory_deduction_data);
					}
				}
				// set loan
				$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($this->input->post('emp_id'));
				$count_loan_deduction = $this->Employees_model->count_employee_deductions($this->input->post('emp_id'));
				$loan_de_amount = 0;
				if ($count_loan_deduction > 0) {
					foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
						$loan_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'salary_month' => $this->input->post('pay_date'),
							'loan_title' => $sl_salary_loan_deduction->loan_deduction_title,
							'loan_amount' => $sl_salary_loan_deduction->loan_deduction_amount,
							'created_at' => date('d-m-Y h:i:s')
						);
						$_loan_data = $this->Payroll_model->add_salary_payslip_loan($loan_data);
					}
				}
				// set overtime
				$salary_overtime = $this->Employees_model->read_salary_overtime($this->input->post('emp_id'));
				$count_overtime = $this->Employees_model->count_employee_overtime($this->input->post('emp_id'));
				$overtime_amount = 0;
				if ($count_overtime > 0) {
					foreach ($salary_overtime as $sl_overtime) {
						//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
						$overtime_data = array(
							'payslip_id' => $result,
							'employee_id' => $this->input->post('emp_id'),
							'overtime_salary_month' => $this->input->post('pay_date'),
							'overtime_title' => $sl_overtime->overtime_type,
							'overtime_no_of_days' => $sl_overtime->no_of_days,
							'overtime_hours' => $sl_overtime->overtime_hours,
							'overtime_rate' => $sl_overtime->overtime_rate,
							'created_at' => date('d-m-Y h:i:s')
						);
						$_overtime_data = $this->Payroll_model->add_salary_payslip_overtime($overtime_data);
					}
				}

				$Return['result'] = $this->lang->line('xin_success_payment_paid');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database > add monthly payment
	public function add_half_pay_to_all()
	{

		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if ($this->input->post('add_type') == 'payroll') {
			if ($this->input->post('company_id') == 0 && $this->input->post('location_id') == 0 && $this->input->post('department_id') == 0) {
				$result = $this->Xin_model->all_employees();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') == 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_company_payroll_employees($this->input->post('company_id'));
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') != 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_company_location_payroll_employees($this->input->post('company_id'), $this->input->post('location_id'));
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') != 0 && $this->input->post('department_id') != 0) {
				$eresult = $this->Payroll_model->get_company_location_dep_payroll_employees($this->input->post('company_id'), $this->input->post('location_id'), $this->input->post('department_id'));
				$result = $eresult->result();
			} else {
				$Return['error'] = $this->lang->line('xin_record_not_found');
			}
			$system = $this->Xin_model->read_setting_info(1);
			$system_settings = system_settings_info(1);
			if ($system_settings->online_payment_account == '') {
				$online_payment_account = 0;
			} else {
				$online_payment_account = $system_settings->online_payment_account;
			}
			foreach ($result as $empid) {
				$user_id = $empid->user_id;
				$user = $this->Xin_model->read_user_info($user_id);

				if ($system[0]->is_half_monthly == 1) {
					$is_half_monthly_payroll = 1;
				} else {
					$is_half_monthly_payroll = 0;
				}
				/* Server side PHP input validation */
				if ($empid->wages_type == 1) {
					if ($system[0]->is_half_monthly == 1) {
						$basic_salary = $empid->basic_salary / 2;
					} else {
						$basic_salary = $empid->basic_salary;
					}
				} else {
					$basic_salary = $empid->daily_wages;
				}
				if ($basic_salary > 0) {
					// get designation
					$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
					if (!is_null($designation)) {
						$designation_id = $designation[0]->designation_id;
					} else {
						$designation_id = 1;
					}
					// department
					$department = $this->Department_model->read_department_information($user[0]->department_id);
					if (!is_null($department)) {
						$department_id = $department[0]->department_id;
					} else {
						$department_id = 1;
					}

					$salary_allowances = $this->Employees_model->read_salary_allowances($user_id);
					$count_allowances = $this->Employees_model->count_employee_allowances($user_id);
					$allowance_amount = 0;
					if ($count_allowances > 0) {
						foreach ($salary_allowances as $sl_allowances) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$eallowance_amount = $sl_allowances->allowance_amount / 2;
								} else {
									$eallowance_amount = $sl_allowances->allowance_amount;
								}
							} else {
								$eallowance_amount = $sl_allowances->allowance_amount;
							}
							$allowance_amount += $eallowance_amount;
							//  $allowance_amount += $sl_allowances->allowance_amount;
						}
					} else {
						$allowance_amount = 0;
					}
					// 3: all loan/deductions
					$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($user_id);
					$count_loan_deduction = $this->Employees_model->count_employee_deductions($user_id);
					$loan_de_amount = 0;
					if ($count_loan_deduction > 0) {
						foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$er_loan = $sl_salary_loan_deduction->loan_deduction_amount / 2;
								} else {
									$er_loan = $sl_salary_loan_deduction->loan_deduction_amount;
								}
							} else {
								$er_loan = $sl_salary_loan_deduction->loan_deduction_amount;
							}
							$loan_de_amount += $er_loan;
							// $loan_de_amount += $sl_salary_loan_deduction->loan_deduction_amount;
						}
					} else {
						$loan_de_amount = 0;
					}


					// 5: overtime
					$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
					$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
					$overtime_amount = 0;
					if ($count_overtime > 0) {
						foreach ($salary_overtime as $sl_overtime) {
							//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
							//$overtime_amount += $overtime_total;
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$eovertime_hours = $sl_overtime->overtime_hours / 2;
									$eovertime_rate = $sl_overtime->overtime_rate / 2;
								} else {
									$eovertime_hours = $sl_overtime->overtime_hours;
									$eovertime_rate = $sl_overtime->overtime_rate;
								}
							} else {
								$eovertime_hours = $sl_overtime->overtime_hours;
								$eovertime_rate = $sl_overtime->overtime_rate;
							}
							$overtime_amount += $eovertime_hours * $eovertime_rate;
						}
					} else {
						$overtime_amount = 0;
					}


					// 6: statutory deductions
					// 4: other payment
					$other_payments = $this->Employees_model->set_employee_other_payments($user_id);
					$other_payments_amount = 0;
					if (!is_null($other_payments)) :
						foreach ($other_payments->result() as $sl_other_payments) {
							//$other_payments_amount += $sl_other_payments->payments_amount;
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$epayments_amount = $sl_other_payments->payments_amount / 2;
								} else {
									$epayments_amount = $sl_other_payments->payments_amount;
								}
							} else {
								$epayments_amount = $sl_other_payments->payments_amount;
							}
							$other_payments_amount += $epayments_amount;
						}
					endif;
					// all other payment
					$all_other_payment = $other_payments_amount;
					// 5: commissions
					$commissions = $this->Employees_model->set_employee_commissions($user_id);
					if (!is_null($commissions)) :
						$commissions_amount = 0;
						foreach ($commissions->result() as $sl_commissions) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$ecommissions_amount = $sl_commissions->commission_amount / 2;
								} else {
									$ecommissions_amount = $sl_commissions->commission_amount;
								}
							} else {
								$ecommissions_amount = $sl_commissions->commission_amount;
							}
							$commissions_amount += $ecommissions_amount;
							// $commissions_amount += $sl_commissions->commission_amount;
						}
					endif;
					// 6: statutory deductions
					$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($user_id);
					if (!is_null($statutory_deductions)) :
						$statutory_deductions_amount = 0;
						foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
							if ($system[0]->statutory_fixed != 'yes') :
								$sta_salary = $basic_salary;
								$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$single_sd = $st_amount / 2;
									} else {
										$single_sd = $st_amount;
									}
								} else {
									$single_sd = $st_amount;
								}
								$statutory_deductions_amount += $single_sd;
							else :
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$single_sd = $sl_statutory_deductions->deduction_amount / 2;
									} else {
										$single_sd = $sl_statutory_deductions->deduction_amount;
									}
								} else {
									$single_sd = $sl_statutory_deductions->deduction_amount;
								}
								$statutory_deductions_amount += $single_sd;
							//$statutory_deductions_amount += $sl_statutory_deductions->deduction_amount;
							endif;
						}
					endif;

					// add amount
					$add_salary = $allowance_amount + $basic_salary + $overtime_amount + $other_payments_amount + $commissions_amount;
					// add amount
					$net_salary_default = $add_salary - $loan_de_amount - $statutory_deductions_amount;
					$net_salary = $net_salary_default;
					$net_salary = number_format((float)$net_salary, 2, '.', '');
					$jurl = random_string('alnum', 40);
					$data = array(
						'employee_id' => $user_id,
						'department_id' => $department_id,
						'company_id' => $user[0]->company_id,
						'designation_id' => $designation_id,
						'salary_month' => $this->input->post('month_year'),
						'basic_salary' => $basic_salary,
						'net_salary' => $net_salary,
						'wages_type' => $empid->wages_type,
						'total_allowances' => $allowance_amount,
						'total_loan' => $loan_de_amount,
						'total_overtime' => $overtime_amount,
						'total_commissions' => $commissions_amount,
						'total_statutory_deductions' => $statutory_deductions_amount,
						'total_other_payments' => $other_payments_amount,
						'is_half_monthly_payroll' => $is_half_monthly_payroll,
						'is_payment' => '1',
						'payslip_type' => 'full_monthly',
						'payslip_key' => $jurl,
						'year_to_date' => date('d-m-Y'),
						'created_at' => date('d-m-Y h:i:s')
					);
					$result = $this->Payroll_model->add_salary_payslip($data);

					if ($result) {
						$ivdata = array(
							'amount' => $net_salary,
							'account_id' => $online_payment_account,
							'transaction_type' => 'expense',
							'dr_cr' => 'cr',
							'transaction_date' => date('Y-m-d'),
							'payer_payee_id' => $user_id,
							'payment_method_id' => 3,
							'description' => 'Payroll Payments',
							'reference' => 'Payroll Payments',
							'invoice_id' => $result,
							'client_id' => $user_id,
							'created_at' => date('Y-m-d H:i:s')
						);
						$this->Finance_model->add_transactions($ivdata);
						// update data in bank account
						$account_id = $this->Finance_model->read_bankcash_information($online_payment_account);
						$acc_balance = $account_id[0]->account_balance - $net_salary;

						$data3 = array(
							'account_balance' => $acc_balance
						);
						$this->Finance_model->update_bankcash_record($data3, $online_payment_account);

						$salary_allowances = $this->Employees_model->read_salary_allowances($user_id);
						$count_allowances = $this->Employees_model->count_employee_allowances($user_id);
						$allowance_amount = 0;
						if ($count_allowances > 0) {
							foreach ($salary_allowances as $sl_allowances) {
								$allowance_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'allowance_title' => $sl_allowances->allowance_title,
									'allowance_amount' => $sl_allowances->allowance_amount,
									'is_allowance_taxable' => $sl_allowances->is_allowance_taxable,
									'amount_option' => $sl_allowances->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_allowance_data = $this->Payroll_model->add_salary_payslip_allowances($allowance_data);
							}
						}
						// set commissions
						$salary_commissions = $this->Employees_model->read_salary_commissions($user_id);
						$count_commission = $this->Employees_model->count_employee_commissions($user_id);
						$commission_amount = 0;
						if ($count_commission > 0) {
							foreach ($salary_commissions as $sl_commission) {
								$commissions_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'commission_title' => $sl_commission->commission_title,
									'commission_amount' => $sl_commission->commission_amount,
									'is_commission_taxable' => $sl_commission->is_commission_taxable,
									'amount_option' => $sl_commission->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_commissions($commissions_data);
							}
						}
						// set other payments
						$salary_other_payments = $this->Employees_model->read_salary_other_payments($user_id);
						$count_other_payment = $this->Employees_model->count_employee_other_payments($user_id);
						$other_payment_amount = 0;
						if ($count_other_payment > 0) {
							foreach ($salary_other_payments as $sl_other_payments) {
								$other_payments_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'payments_title' => $sl_other_payments->payments_title,
									'payments_amount' => $sl_other_payments->payments_amount,
									'is_otherpayment_taxable' => $sl_other_payments->is_otherpayment_taxable,
									'amount_option' => $sl_other_payments->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_other_payments($other_payments_data);
							}
						}
						// set statutory_deductions
						$salary_statutory_deductions = $this->Employees_model->read_salary_statutory_deductions($user_id);
						$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions($user_id);
						$statutory_deductions_amount = 0;
						if ($count_statutory_deductions > 0) {
							foreach ($salary_statutory_deductions as $sl_statutory_deduction) {
								$esl_statutory_deduction = $sl_statutory_deduction->deduction_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$ededuction_amount = $esl_statutory_deduction / 2;
									} else {
										$ededuction_amount = $esl_statutory_deduction;
									}
								} else {
									$ededuction_amount = $esl_statutory_deduction;
								}

								$statutory_deduction_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'deduction_title' => $sl_statutory_deduction->deduction_title,
									'statutory_options' => $sl_statutory_deduction->statutory_options,
									'deduction_amount' => $ededuction_amount,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_statutory_deductions($statutory_deduction_data);
							}
						}
						$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($user_id);
						$count_loan_deduction = $this->Employees_model->count_employee_deductions($user_id);
						$loan_de_amount = 0;
						if ($count_loan_deduction > 0) {
							foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
								$loan_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'loan_title' => $sl_salary_loan_deduction->loan_deduction_title,
									'loan_amount' => $sl_salary_loan_deduction->loan_deduction_amount,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_loan_data = $this->Payroll_model->add_salary_payslip_loan($loan_data);
							}
						}
						$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
						$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
						$overtime_amount = 0;
						if ($count_overtime > 0) {
							foreach ($salary_overtime as $sl_overtime) {
								//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
								$overtime_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'overtime_salary_month' => $this->input->post('month_year'),
									'overtime_title' => $sl_overtime->overtime_type,
									'overtime_no_of_days' => $sl_overtime->no_of_days,
									'overtime_hours' => $sl_overtime->overtime_hours,
									'overtime_rate' => $sl_overtime->overtime_rate,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_overtime_data = $this->Payroll_model->add_salary_payslip_overtime($overtime_data);
							}
						}

						$Return['result'] = $this->lang->line('xin_success_payment_paid');
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} // if basic salary
			}
			$Return['result'] = $this->lang->line('xin_success_payment_paid');
			$this->output($Return);
			exit;
		} // f
	}

	// Validate and add info in database > add monthly payment
	/*public function add_pay_to_all() {
		//Define return | here result is used to return user data and error for error message
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if($this->input->post('add_type')=='payroll') {
			if($this->input->post('company_id')==0 && $this->input->post('location_id')==0 && $this->input->post('department_id')==0) {
				$eresult = $this->Payroll_model->get_all_employees();
				$result = $eresult->result();
			} else if($this->input->post('company_id')!=0 && $this->input->post('location_id')==0 && $this->input->post('department_id')==0) {
				$eresult = $this->Payroll_model->get_company_payroll_employees($this->input->post('company_id'));
				$result = $eresult->result();
			} else if($this->input->post('company_id')!=0 && $this->input->post('location_id')!=0 && $this->input->post('department_id')==0) {
				$eresult = $this->Payroll_model->get_company_location_payroll_employees($this->input->post('company_id'),$this->input->post('location_id'));
				$result = $eresult->result();
			} else if($this->input->post('company_id')!=0 && $this->input->post('location_id')!=0 && $this->input->post('department_id')!=0) {
				$eresult = $this->Payroll_model->get_company_location_dep_payroll_employees($this->input->post('company_id'),$this->input->post('location_id'),$this->input->post('department_id'));
				$result = $eresult->result();
			} else {
				$Return['error'] = $this->lang->line('xin_record_not_found');
			}
			$system = $this->Xin_model->read_setting_info(1);
			$system_settings = system_settings_info(1);
			if($system_settings->online_payment_account == ''){
				$online_payment_account = 0;
			} else {
				$online_payment_account = $system_settings->online_payment_account;
			}
			foreach($result as $empid) {
				$user_id = $empid->user_id;
				$user = $this->Xin_model->read_user_info($user_id);
				 //Server side PHP input validation
				if($empid->wages_type==1){
					$basic_salary = $empid->basic_salary;
				} else {
					$basic_salary = $empid->daily_wages;
				}
				$pay_count = $this->Payroll_model->read_make_payment_payslip_check($user_id,$this->input->post('month_year'));
				if($pay_count->num_rows() > 0){
					$pay_val = $this->Payroll_model->read_make_payment_payslip($user_id,$this->input->post('month_year'));
					$this->payslip_delete_all($pay_val[0]->payslip_id);
				}
				if($basic_salary > 0) {

					// get designation
					$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
					if(!is_null($designation)){
						$designation_id = $designation[0]->designation_id;
					} else {
						$designation_id = 1;
					}
					// department
					$department = $this->Department_model->read_department_information($user[0]->department_id);
					if(!is_null($department)){
						$department_id = $department[0]->department_id;
					} else {
						$department_id = 1;
					}

					$salary_allowances = $this->Employees_model->read_salary_allowances($user_id);
					$count_allowances = $this->Employees_model->count_employee_allowances($user_id);
					$allowance_amount = 0;
					if($count_allowances > 0) {
						foreach($salary_allowances as $sl_allowances){
							$allowance_amount += $sl_allowances->allowance_amount;
						}
					} else {
						$allowance_amount = 0;
					}
					// 3: all loan/deductions
					$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($user_id);
					$count_loan_deduction = $this->Employees_model->count_employee_deductions($user_id);
					$loan_de_amount = 0;
					if($count_loan_deduction > 0) {
						foreach($salary_loan_deduction as $sl_salary_loan_deduction){
							$loan_de_amount += $sl_salary_loan_deduction->loan_deduction_amount;
						}
					} else {
						$loan_de_amount = 0;
					}


					// 5: overtime
					$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
					$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
					$overtime_amount = 0;
					if($count_overtime > 0) {
						foreach($salary_overtime as $sl_overtime){
							$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
							$overtime_amount += $overtime_total;
						}
					} else {
						$overtime_amount = 0;
					}



					// 6: statutory deductions
					// 4: other payment
					$other_payments = $this->Employees_model->set_employee_other_payments($user_id);
					$other_payments_amount = 0;
					if(!is_null($other_payments)):
						foreach($other_payments->result() as $sl_other_payments) {
							$other_payments_amount += $sl_other_payments->payments_amount;
						}
					endif;
					// all other payment
					$all_other_payment = $other_payments_amount;
					// 5: commissions
					$commissions = $this->Employees_model->set_employee_commissions($user_id);
					if(!is_null($commissions)):
						$commissions_amount = 0;
						foreach($commissions->result() as $sl_commissions) {
							$commissions_amount += $sl_commissions->commission_amount;
						}
					endif;
					// 6: statutory deductions
					$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions($user_id);
					if(!is_null($statutory_deductions)):
						$statutory_deductions_amount = 0;
						foreach($statutory_deductions->result() as $sl_statutory_deductions) {
							if($system[0]->statutory_fixed!='yes'):
								$sta_salary = $basic_salary;
								$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
								$statutory_deductions_amount += $st_amount;
							else:
								$statutory_deductions_amount += $sl_statutory_deductions->deduction_amount;
							endif;
						}
					endif;

					// add amount
					$add_salary = $allowance_amount + $basic_salary + $overtime_amount + $other_payments_amount + $commissions_amount;
					// add amount
					$net_salary_default = $add_salary - $loan_de_amount - $statutory_deductions_amount;
					$net_salary = $net_salary_default;
					$net_salary = number_format((float)$net_salary, 2, '.', '');
					$jurl = random_string('alnum', 40);
					$data = array(
					'employee_id' => $user_id,
					'department_id' => $department_id,
					'company_id' => $user[0]->company_id,
					'designation_id' => $designation_id,
					'salary_month' => $this->input->post('month_year'),
					'basic_salary' => $basic_salary,
					'net_salary' => $net_salary,
					'wages_type' => $empid->wages_type,
					'total_allowances' => $allowance_amount,
					'total_loan' => $loan_de_amount,
					'total_overtime' => $overtime_amount,
					'total_commissions' => $commissions_amount,
					'total_statutory_deductions' => $statutory_deductions_amount,
					'total_other_payments' => $other_payments_amount,
					'is_payment' => '1',
					'payslip_type' => 'full_monthly',
					'payslip_key' => $jurl,
					'year_to_date' => date('d-m-Y'),
					'created_at' => date('d-m-Y h:i:s')
					);
					$result = $this->Payroll_model->add_salary_payslip($data);

					if ($result) {
						$ivdata = array(
						'amount' => $net_salary,
						'account_id' => $online_payment_account,
						'transaction_type' => 'expense',
						'dr_cr' => 'cr',
						'transaction_date' => date('Y-m-d'),
						'payer_payee_id' => $user_id,
						'payment_method_id' => 3,
						'description' => 'Payroll Payments',
						'reference' => 'Payroll Payments',
						'invoice_id' => $result,
						'client_id' => $user_id,
						'created_at' => date('Y-m-d H:i:s')
						);
						$this->Finance_model->add_transactions($ivdata);
						// update data in bank account
						$account_id = $this->Finance_model->read_bankcash_information($online_payment_account);
						$acc_balance = $account_id[0]->account_balance - $net_salary;

						$data3 = array(
						'account_balance' => $acc_balance
						);
						$this->Finance_model->update_bankcash_record($data3,$online_payment_account);

						$salary_allowances = $this->Employees_model->read_salary_allowances($user_id);
						$count_allowances = $this->Employees_model->count_employee_allowances($user_id);
						$allowance_amount = 0;
						if($count_allowances > 0) {
							foreach($salary_allowances as $sl_allowances){
								$allowance_data = array(
								'payslip_id' => $result,
								'employee_id' => $user_id,
								'salary_month' => $this->input->post('month_year'),
								'allowance_title' => $sl_allowances->allowance_title,
								'allowance_amount' => $sl_allowances->allowance_amount,
								'is_allowance_taxable' => $sl_allowances->is_allowance_taxable,
								'amount_option' => $sl_allowances->amount_option,
								'created_at' => date('d-m-Y h:i:s')
								);
								$_allowance_data = $this->Payroll_model->add_salary_payslip_allowances($allowance_data);
							}
						}
						// set commissions
					$salary_commissions = $this->Employees_model->read_salary_commissions($user_id);
					$count_commission = $this->Employees_model->count_employee_commissions($user_id);
					$commission_amount = 0;
					if($count_commission > 0) {
						foreach($salary_commissions as $sl_commission){
							$commissions_data = array(
							'payslip_id' => $result,
							'employee_id' => $user_id,
							'salary_month' => $this->input->post('month_year'),
							'commission_title' => $sl_commission->commission_title,
							'commission_amount' => $sl_commission->commission_amount,
							'is_commission_taxable' => $sl_commission->is_commission_taxable,
							'amount_option' => $sl_commission->amount_option,
							'created_at' => date('d-m-Y h:i:s')
							);
							$this->Payroll_model->add_salary_payslip_commissions($commissions_data);
						}
					}
					// set other payments
					$salary_other_payments = $this->Employees_model->read_salary_other_payments($user_id);
					$count_other_payment = $this->Employees_model->count_employee_other_payments($user_id);
					$other_payment_amount = 0;
					if($count_other_payment > 0) {
						foreach($salary_other_payments as $sl_other_payments){
							$other_payments_data = array(
							'payslip_id' => $result,
							'employee_id' => $user_id,
							'salary_month' => $this->input->post('month_year'),
							'payments_title' => $sl_other_payments->payments_title,
							'payments_amount' => $sl_other_payments->payments_amount,
							'is_otherpayment_taxable' => $sl_other_payments->is_otherpayment_taxable,
							'amount_option' => $sl_other_payments->amount_option,
							'created_at' => date('d-m-Y h:i:s')
							);
							$this->Payroll_model->add_salary_payslip_other_payments($other_payments_data);
						}
					}
					// set statutory_deductions
					$salary_statutory_deductions = $this->Employees_model->read_salary_statutory_deductions($user_id);
					$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions($user_id);
					$statutory_deductions_amount = 0;
					if($count_statutory_deductions > 0) {
						foreach($salary_statutory_deductions as $sl_statutory_deduction){

							$esl_statutory_deduction = $sl_statutory_deduction->deduction_amount;
							 if($system[0]->is_half_monthly==1){
								 if($system[0]->half_deduct_month==2){
									 $ededuction_amount = $esl_statutory_deduction/2;
								 } else {
									 $ededuction_amount = $esl_statutory_deduction;
								 }
							  } else {
								  $ededuction_amount = $esl_statutory_deduction;
							  }
							 $statutory_deduction_data = array(
							'payslip_id' => $result,
							'employee_id' => $user_id,
							'salary_month' => $this->input->post('month_year'),
							'deduction_title' => $sl_statutory_deduction->deduction_title,
							//'deduction_amount' => $sl_statutory_deduction->deduction_amount,
							'statutory_options' => $sl_statutory_deduction->statutory_options,
							'deduction_amount' => $ededuction_amount,
							'created_at' => date('d-m-Y h:i:s')
							);
							$this->Payroll_model->add_salary_payslip_statutory_deductions($statutory_deduction_data);
						}
					}
					$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($user_id);
						$count_loan_deduction = $this->Employees_model->count_employee_deductions($user_id);
						$loan_de_amount = 0;
						if($count_loan_deduction > 0) {
							foreach($salary_loan_deduction as $sl_salary_loan_deduction){
								$loan_data = array(
								'payslip_id' => $result,
								'employee_id' => $user_id,
								'salary_month' => $this->input->post('month_year'),
								'loan_title' => $sl_salary_loan_deduction->loan_deduction_title,
								'loan_amount' => $sl_salary_loan_deduction->loan_deduction_amount,
								'created_at' => date('d-m-Y h:i:s')
								);
								$_loan_data = $this->Payroll_model->add_salary_payslip_loan($loan_data);
							}
						}
						$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
						$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
						$overtime_amount = 0;
						if($count_overtime > 0) {
							foreach($salary_overtime as $sl_overtime){
								//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
								$overtime_data = array(
								'payslip_id' => $result,
								'employee_id' => $user_id,
								'overtime_salary_month' => $this->input->post('month_year'),
								'overtime_title' => $sl_overtime->overtime_type,
								'overtime_no_of_days' => $sl_overtime->no_of_days,
								'overtime_hours' => $sl_overtime->overtime_hours,
								'overtime_rate' => $sl_overtime->overtime_rate,
								'created_at' => date('d-m-Y h:i:s')
								);
								$_overtime_data = $this->Payroll_model->add_salary_payslip_overtime($overtime_data);
							}
						}

						$Return['result'] = $this->lang->line('xin_success_payment_paid');
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}


				} // if basic salary

			}
			$Return['result'] = $this->lang->line('xin_success_payment_paid');
			$this->output($Return);
			exit;
			} // f
	}*/
	public function add_pay_to_all()
	{
		/*	Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if ($this->input->post('add_type') == 'payroll') {
			if ($this->input->post('company_id') == 0 && $this->input->post('location_id') == 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_all_employees();
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') == 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_company_payroll_employees($this->input->post('company_id'));
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') != 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_company_location_payroll_employees($this->input->post('company_id'), $this->input->post('location_id'));
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') != 0 && $this->input->post('department_id') != 0) {
				$eresult = $this->Payroll_model->get_company_location_dep_payroll_employees($this->input->post('company_id'), $this->input->post('location_id'), $this->input->post('department_id'));
				$result = $eresult->result();
			} else {
				$Return['error'] = $this->lang->line('xin_record_not_found');
			}
			$system = $this->Xin_model->read_setting_info(1);
			$system_settings = system_settings_info(1);
			if ($system_settings->online_payment_account == '') {
				$online_payment_account = 0;
			} else {
				$online_payment_account = $system_settings->online_payment_account;
			}
			foreach ($result as $empid) {
				$user_id = $empid->user_id;
				$user = $this->Xin_model->read_user_info($user_id);
				/* Server side PHP input validation */
				if ($empid->wages_type == 1) {
					$basic_salary = $empid->basic_salary;
				} else {
					$basic_salary = $empid->daily_wages;
				}
				$pay_count = $this->Payroll_model->read_make_payment_payslip_check($user_id, $this->input->post('month_year'));
				if ($pay_count->num_rows() > 0) {
					$pay_val = $this->Payroll_model->read_make_payment_payslip($user_id, $this->input->post('month_year'));
					$this->payslip_delete_all($pay_val[0]->payslip_id);
				}
				if ($basic_salary > 0) {

					// get designation
					$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
					if (!is_null($designation)) {
						$designation_id = $designation[0]->designation_id;
					} else {
						$designation_id = 1;
					}
					// department
					$department = $this->Department_model->read_department_information($user[0]->department_id);
					if (!is_null($department)) {
						$department_id = $department[0]->department_id;
					} else {
						$department_id = 1;
					}

					// changed files
					$pay_date = $this->input->post('month_year');
					//overtime request
					$overtime_count = $this->Overtime_request_model->get_overtime_request_count($user_id, $this->input->post('month_year'));
					$re_hrs_old_int1 = 0;
					$re_hrs_old_seconds = 0;
					$re_pcount = 0;
					foreach ($overtime_count as $overtime_hr) {
						// total work
						$request_clock_in = new DateTime($overtime_hr->request_clock_in);
						$request_clock_out = new DateTime($overtime_hr->request_clock_out);
						$re_interval_late = $request_clock_in->diff($request_clock_out);
						$re_hours_r = $re_interval_late->format('%h');
						$re_minutes_r = $re_interval_late->format('%i');
						$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

						$re_str_time = $re_total_time;

						$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

						sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

						$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

						$re_hrs_old_int1 += $re_hrs_old_seconds;

						$re_pcount = gmdate("H", $re_hrs_old_int1);
					}
					$result = $this->Payroll_model->total_hours_worked($user_id, $pay_date);
					$hrs_old_int1 = 0;
					$pcount = 0;
					$Trest = 0;
					$total_time_rs = 0;
					$hrs_old_int_res1 = 0;
					foreach ($result->result() as $hour_work) {
						// total work
						$clock_in = new DateTime($hour_work->clock_in);
						$clock_out = new DateTime($hour_work->clock_out);
						$interval_late = $clock_in->diff($clock_out);
						$hours_r = $interval_late->format('%h');
						$minutes_r = $interval_late->format('%i');
						$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

						$str_time = $total_time;

						$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

						sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

						$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

						$hrs_old_int1 += $hrs_old_seconds;

						$pcount = gmdate("H", $hrs_old_int1);
					}
					$pcount = $pcount + $re_pcount;
					// get company
					$company = $this->Xin_model->read_company_info($user[0]->company_id);
					if (!is_null($company)) {
						$comp_name = $company[0]->name;
					} else {
						$comp_name = '--';
					}

					// 1: salary type
					if ($user[0]->wages_type == 1) {
						$wages_type = $this->lang->line('xin_payroll_basic_salary');
						if ($system[0]->is_half_monthly == 1) {
							$basic_salary = $user[0]->basic_salary / 2;
						} else {
							$basic_salary = $user[0]->basic_salary;
						}
						$p_class = 'emo_monthly_pay';
						$view_p_class = 'payroll_template_modal';
					} else if ($user[0]->wages_type == 2) {
						$wages_type = $this->lang->line('xin_employee_daily_wages');
						if ($pcount > 0) {
							$basic_salary = $pcount * $user[0]->basic_salary;
						} else {
							$basic_salary = $pcount;
						}
						$p_class = 'emo_hourly_pay';
						$view_p_class = 'hourlywages_template_modal';
					} else {
						$wages_type = $this->lang->line('xin_payroll_basic_salary');
						if ($system[0]->is_half_monthly == 1) {
							$basic_salary = $user[0]->basic_salary / 2;
						} else {
							$basic_salary = $user[0]->basic_salary;
						}
						$p_class = 'emo_monthly_pay';
						$view_p_class = 'payroll_template_modal';
					}
					// 2: all allowances
					// all allowances, all loan/deductions
					$advance_amount = 0;
					$p_date = $this->input->post('month_year');
					$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($user_id, $p_date, $basic_salary);
					$allowance_amount = $all_allo_and_dedct[0];
					$loan_de_amount = $all_allo_and_dedct[1];
					$commissions_amount = $all_allo_and_dedct[2];
					$other_payments_amount = $all_allo_and_dedct[3];
					$statutory_deductions_amount = $all_allo_and_dedct[4];
					$overtime_amount = $all_allo_and_dedct[5];
					$saudi_gosi = $all_allo_and_dedct[6];
					$advance_amount = $all_allo_and_dedct[7];
					$new_gosi_amt = $all_allo_and_dedct[8];
					$salary_calc = $this->Xin_model->payroll_GrossSalary($user_id, $p_date, $basic_salary, $all_allo_and_dedct);
					$total_net_salary = $salary_calc[0];

					//Using attendance
					$month_year = $pay_date;
					$start_date_y = date('m', strtotime($month_year));
					$start_date_y_m = date('Y-m', strtotime($month_year));
					$emp_leaves = $this->Employees_model->emp_leave_fetch($user_id, $start_date_y);
					$date = strtotime(date("Y-m-d"));
					if (!isset($month_year)) {
						$day = date('d', $date);
						$month = date('m', $date);
						$year = date('Y', $date);
						$month_year = date('Y-m');
					} else {
						$imonth_year = explode('-', $month_year);
						$day = date('d', $date);
						$month = date($imonth_year[1], $date);
						$year = date($imonth_year[0], $date);
						$month_year = $month_year;
					}
					$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

					$arry_years = array();
					$st = '';
					$p_count_val = 0;
					$start_date_co = $year . '-' . $month . '-' . '1';
					$user = $this->Xin_model->read_user_info($user_id);
					if (strtotime(date('Y-m', strtotime($user[0]->date_of_joining))) == strtotime($month_year)) {
						$start_date_co = $user[0]->date_of_joining;
					} else {
						$start_date_co = $year . '-' . $month . '-' . '01';
					}
					$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
					$off_day_arr = array();
					$holiday_arr = array();
					$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);


					$leave_arr = array();
					$half_leave_arr = array();

					$present_arr = array();
					$tot_days = 0;
					//$st = $this->db->last_query();
					$total_leaves = count($leave_arr) + count($half_leave_arr);
					$p_count_val += abs($total_leaves - $tot_days);
					$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
					$absent_count = 0;
					$leave_count = 0;

					$user = $this->Xin_model->read_user_info($user_id);
					if (strtotime($month_year) == strtotime(date('Y-m'))) {
						$month_year_att = $month_year . '-01';
						if ($user[0]->date_of_leaving) {
							if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
								if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
									$difference_days = 0;
								} else {
									$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
									if ($get_attendance_last_entered) {
										$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
										//$month_year_att_end = $month_year.'-'.date('d');
										$startDate = new DateTime($month_year_att);
										$endDate = new DateTime($month_year_att_end);
										$difference = $endDate->diff($startDate);
										$difference_days = $difference->format("%a") + 1;
									} else {
										$difference_days = 0;
									}
								}
							} else {
								$difference_days = 0;
							}
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
						$month_year_att = $month_year . '-01';
						$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
						if ($get_attendance_last_entered) {
							$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
							//$month_year_att_end = $month_year.'-'.date('d');
							$startDate = new DateTime($month_year_att);
							$endDate = new DateTime($month_year_att_end);
							$difference = $endDate->diff($startDate);
							$difference_days = $difference->format("%a") + 1;
						} else {
							$difference_days = 0;
						}
					} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
						$difference_days = 0;
					}
					if ($difference_days >= 25) {
						$difference_days = $daysInMonth;
					}
					$tot_days_lop_normal = 0;
					$totl_num_days_pres = 0;
					$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
					if (!is_null($office_shift)) {
						$attendence_calc = $this->Xin_model->AttendnceCount_calc_common($user[0]->office_shift_id, $start_date_co, $end_date_co, $user[0]->company_id, $user[0]->user_id, $difference_days, $year, $month);
						// print_R($attendence_calc);exit;
						if ($attendence_calc) {
							$tot_days_lop_normal = $attendence_calc[0];
							$totl_num_days_pres = $attendence_calc[1];
						} else {
							$tot_days_lop_normal = 0;
							$totl_num_days_pres = 0;
						}
					}

					//$p_count_val  = $check;
					//$p_count_val = $tot_days;
					//End attendance based


					$tot_days_lop = $tot_days_lop_normal;
					$bs_pay = $user[0]->basic_salary;
					/* Lop Calc Common */
					$lop_calc = $this->Xin_model->LopCalcCommon($net_salary, $daysInMonth, $tot_days_lop);
					$leave_cut_salary = $lop_calc[0];
					/* End Lop calc Common */

					/* Net salary calculations */
					$net_salary_calc = $this->Xin_model->NetsalaryCalcCommon($total_net_salary, $daysInMonth, $totl_num_days_pres);
					$net_salary = $net_salary_calc[0];



					/* Final Net salary */
					$final_net_salary = $this->Xin_model->FinalNetSalaryCalcCommon($net_salary, $leave_cut_salary, $all_allo_and_dedct);
					$net_salary = $final_net_salary[0];


					/* End final net salary */


					//Indemnity calc
					/*	$start_date_y = date('m', strtotime($month_year));
    				$start_date_y_m = date('Y-m', strtotime($month_year));
    				$emp_Indemnity=$this->Employees_model->emp_indemnity_fetch($user_id,$start_date_y);

    				$totl_amt = 0;
    				if($emp_Indemnity){
    					foreach($emp_Indemnity as $emp_leave) {
    						$totl_amt += $emp_leave->amount;
    					  }
    				}*/
					$totl_amt = 0;
					//leave encashment calc
					$start_date_y = date('m', strtotime($month_year));
					$start_date_y_m = date('Y-m', strtotime($month_year));
					$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

					$totl_amt_leva = $annual_amt_pay = 0;
					if ($emp_leave_enchas) {
						foreach ($emp_leave_enchas as $emp_leave_ench) {
							$totl_amt_leva += $emp_leave_ench->amount;
						}
					}
					$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $annual_amt_pay;
					if ($net_salary < 0 || $basic_salary <= 0) {
						$net_salary = '0.00';
					}
					$basic_salary = $basic_salary;
					$paymonth = date('m', strtotime($pay_date));
					$payyear = date('Y', strtotime($pay_date));


					$empdata = $this->Employees_model->get_employee_details($user_id);
					$basepay = $empdata[0]->basic_salary;
					$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($user_id, $pay_date, $basepay);
					$allowance_amount = $all_allo_and_dedct[0];
					$no_of_days = date('t', strtotime($pay_date));


					// Get Late Deduction Amount

					$latededuction = $this->Payroll_model->GetLateDeductionCalcCommon($user_id, $paymonth, $payyear, $no_of_days);
					$late_amount = $latededuction[0];

					// End Late Deduction Amount

					//Late Deduction Start
					/*$total = 0;
         $totaldeduct = 0;


               $late_totaldetails = $this->Employees_model->getemployeelatedetails($user_id,$paymonth,$payyear);
               $empdatas     = $this->Employees_model->get_employee_data($user_id);
               $latestatus   = $empdatas[0]->late_deduction;
               if($latestatus == "hours_deduction"){
               if(isset($late_totaldetails)){
               foreach($late_totaldetails as $latedetails){
                     $day = $latedetails->attendance_date;
                     $total_work = $this->Employees_model->get_employee_workdone($user_id,$day);
                     $latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id,$day);
                     $latededuction = $latecome_deduct[0]->late_deduction;
                     if($total_work[0]->totalhours< 8 && $total_work[0]->totalhours> 0){
                                   $latehours = 8 - round($total_work[0]->totalhours,2);
                                   $empdata = $this->Employees_model->get_employee_details($user_id);
                                   $basepay       = $empdata[0]->basic_salary;
                                   $hourdeduct = round(($basepay/30)/8 * $latehours,3);

                                   $halfdays      =  $this->Employees_model->get_halfdays($user_id);
         						   if(isset($halfdays)){
         						   foreach ($halfdays as $row) {

         						    $startDate     =  $row->from_date;
         						    if($day == $startDate && $latehours > 4){

         						        $latebyhours = 4 - round($total_work[0]->totalhours,2);
         						        $hourdeduct = round(($basepay/30)/8 * $latebyhours,3);
         						        $latededuction = 0;
         						    }elseif($day == $startDate && $latehours <= 4){
         						        $hourdeduct = 0;
         						        $latededuction = 0;
         						    }

         					     	}
         						    }

                                   $total += $hourdeduct;

                     }

               }
               }
               }elseif($latestatus == "hoursandlate_deduction"){
                   if(isset($late_totaldetails)){
                     foreach($late_totaldetails as $latedetails){
                     $day = $latedetails->attendance_date;
                     $total_work = $this->Employees_model->get_employee_workdone($user_id,$day);
                     $latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($user_id,$day);
                     $latededuction = $latecome_deduct[0]->late_deduction;
                     if($total_work[0]->totalhours< 8 && $total_work[0]->totalhours> 0){
                                   $latehours = 8 - round($total_work[0]->totalhours,2);
                                   $empdata = $this->Employees_model->get_employee_details($user_id);
                                   $basepay       = $empdata[0]->basic_salary;
                                   $hourdeduct = round(($basepay/30)/8 * $latehours,3);

                                   $halfdays      =  $this->Employees_model->get_halfdays($user_id);
         						   if(isset($halfdays)){
         						   foreach ($halfdays as $row) {

         						    $startDate     =  $row->from_date;
         						    if($day == $startDate && $latehours > 4){

        						        $latebyhours = 4 - round($total_work[0]->totalhours,2);
         						        $hourdeduct = round(($basepay/30)/8 * $latebyhours,3);
         						        $latededuction = 0;
         						    }elseif($day == $startDate && $latehours <= 4){
         						        $hourdeduct = 0;
         						        $latededuction = 0;
         						    }

         					     	}
         						    }
                                   $totaldeduct = $hourdeduct + $latededuction;
                                   $total += $hourdeduct + $latededuction;

                     }
                     elseif($total_work[0]->totalhours> 8 && $latededuction > 0){
                                   $total +=  $latededuction;
                     }
               }
               }
               }*/


					$userinfo = $this->Employees_model->get_employee_details($user_id);
					$companyinfo = $this->Employees_model->get_company_details($userinfo[0]->company_id);
					$late_status = $companyinfo[0]->late_deduction;
					if ($late_status == 'yes') {
						$late_amount = $late_amount;
					} else {
						$late_amount = 0;
					}
					// Late Deduction End


					// Overtime Start

					/*$overtime_totalpay   = $this->Employees_model->get_employee_overtime_total($user_id,$paymonth,$payyear);
	    $overtimestatus      = $this->Employees_model->get_employee_overtimestatus($user_id);
        $otstatus            = $overtimestatus[0]->ot_eligible;
            if($otstatus == "yes"){
                $ot_amount = $overtime_totalpay[0]->totalrate;
                $net_salary = $net_salary + $overtime_totalpay[0]->totalrate - $late_deduct_amt;
            }
            else{
                $ot_amount = 0;
                $net_salary = $net_salary - $late_deduct_amt;
            }

				$monthy_present_days = $totl_num_days_pres;
				if($net_salary > 0){
					    $net_salary = $net_salary;
				}else{
					    $net_salary = '0.000';
				}*/

					// Overtime End


					// Get Overtime Amount

					$overtime = $this->Payroll_model->GetOvertimeCalcCommon($user_id, $paymonth, $payyear);
					$overtime_amount = $overtime[0];

					// End Overtime Amount


					// Air ticket Encashment Start

					$encashment_check = $this->Employees_model->employee_encashment_check($user_id, $month_year);
					if (!empty($encashment_check)) {
						$encashstatus = $encashment_check[0]->status;
						if (!is_null($encashstatus)) {
							$encashrate = $this->Employees_model->get_employee_encashrate_payroll($user_id, $month_year);
							$encash_amt = $encashrate[0]->amount;
							/*$empinfo     = $this->Employees_model->read_employee_information($user_id);
                $nation_id   = $empinfo[0]->nationality_id;
                $encashrate  = $this->Employees_model->get_employee_encashrate($nation_id);
                $encash_amt  = $encashrate[0]->encash_amount;*/
						} else {
							$encash_amt = 0;
						}
					} else {
						$encash_amt = 0;
					}
					// Air ticket Encashment End


					$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
					$otstatus = $overtimestatus[0]->ot_eligible;
					if ($otstatus == "yes") {

						$net_salary = $net_salary + $overtime_amount - $late_amount;
					} else {

						$net_salary = $net_salary - $late_amount;
					}

					$monthy_present_days = $totl_num_days_pres - $tot_days_lop;
					if ($net_salary > 0) {
						$net_salary = $net_salary;
					} else {
						$net_salary = '0.000';
					}


					if (is_null($overtime_amount)) {
						$overtime_amount = 0;
					}
					if (is_null($late_amount)) {
						$late_amount = 0;
					}

					/* Expense Claim Start */
					$expense_claim = 0;
					if ($net_salary > 0) {
						$expense_total_claim = $this->Xin_model->FindExpenseClaimTotal($user_id);
						$expense_claim = $expense_total_claim + $encash_amt;
						$net_salary = $net_salary + $expense_claim;
					}
					/* Expense Claim End */

					$net_salary = number_format($net_salary, 3, '.', '');
					$jurl = random_string('alnum', 40);
					$data = array(
						'employee_id' => $user_id,
						'department_id' => $department_id,
						'company_id' => $user[0]->company_id,
						'designation_id' => $designation_id,
						'salary_month' => $this->input->post('month_year'),
						'basic_salary' => $basic_salary,
						'net_salary' => $net_salary,
						'wages_type' => $empid->wages_type,
						'total_allowances' => $allowance_amount,
						'total_loan' => $loan_de_amount,
						'total_overtime' => $overtime_amount,
						'total_late_deduction' => $late_amount,
						'total_commissions' => $commissions_amount,
						'total_statutory_deductions' => $statutory_deductions_amount,
						'total_other_payments' => $other_payments_amount,
						'is_payment' => '1',
						'payslip_type' => 'full_monthly',
						'payslip_key' => $jurl,
						'year_to_date' => date('d-m-Y'),
						'created_at' => date('d-m-Y h:i:s'),
						'monthy_present_days' => $monthy_present_days,
						'airticket_encashment ' => $encash_amt,
						'expense_claim' => $expense_claim,
						'status' => 2
					);
					$result = $this->Payroll_model->add_salary_payslip($data);

					if ($result) {
						$ivdata = array(
							'amount' => $net_salary,
							'account_id' => $online_payment_account,
							'transaction_type' => 'expense',
							'dr_cr' => 'cr',
							'transaction_date' => date('Y-m-d'),
							'payer_payee_id' => $user_id,
							'payment_method_id' => 3,
							'description' => 'Payroll Payments',
							'reference' => 'Payroll Payments',
							'invoice_id' => $result,
							'client_id' => $user_id,
							'created_at' => date('Y-m-d H:i:s')
						);
						$this->Finance_model->add_transactions($ivdata);
						// update data in bank account
						$account_id = $this->Finance_model->read_bankcash_information($online_payment_account);
						if ($account_id) {
							if ($account_id[0]->account_balance > 0) {
								$acc_balance = $account_id[0]->account_balance - $net_salary;
							} else {
								$acc_balance = 0;
							}
						} else {
							$acc_balance = 0;
						}


						$data3 = array(
							'account_balance' => $acc_balance
						);
						$this->Finance_model->update_bankcash_record($data3, $online_payment_account);

						$salary_allowances = $this->Employees_model->read_salary_allowances($user_id);
						$count_allowances = $this->Employees_model->count_employee_allowances($user_id);
						$allowance_amount = 0;
						if ($count_allowances > 0) {
							foreach ($salary_allowances as $sl_allowances) {
								$allowance_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'allowance_title' => $sl_allowances->allowance_title,
									'allowance_amount' => $sl_allowances->allowance_amount,
									'is_allowance_taxable' => $sl_allowances->is_allowance_taxable,
									'amount_option' => $sl_allowances->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_allowance_data = $this->Payroll_model->add_salary_payslip_allowances($allowance_data);
							}
						}
						// set commissions
						$salary_commissions = $this->Employees_model->read_salary_commissions($user_id);
						$count_commission = $this->Employees_model->count_employee_commissions($user_id);
						$commission_amount = 0;
						if ($count_commission > 0) {
							foreach ($salary_commissions as $sl_commission) {
								$commissions_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'commission_title' => $sl_commission->commission_title,
									'commission_amount' => $sl_commission->commission_amount,
									'is_commission_taxable' => $sl_commission->is_commission_taxable,
									'amount_option' => $sl_commission->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_commissions($commissions_data);
							}
						}
						// set other payments
						$salary_other_payments = $this->Employees_model->read_salary_other_payments($user_id);
						$count_other_payment = $this->Employees_model->count_employee_other_payments($user_id);
						$other_payment_amount = 0;
						if ($count_other_payment > 0) {
							foreach ($salary_other_payments as $sl_other_payments) {
								$other_payments_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'payments_title' => $sl_other_payments->payments_title,
									'payments_amount' => $sl_other_payments->payments_amount,
									'is_otherpayment_taxable' => $sl_other_payments->is_otherpayment_taxable,
									'amount_option' => $sl_other_payments->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_other_payments($other_payments_data);
							}
						}
						// set statutory_deductions
						$salary_statutory_deductions = $this->Employees_model->read_salary_statutory_deductions($user_id);
						$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions($user_id);
						$statutory_deductions_amount = 0;
						if ($count_statutory_deductions > 0) {
							foreach ($salary_statutory_deductions as $sl_statutory_deduction) {

								$esl_statutory_deduction = $sl_statutory_deduction->deduction_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$ededuction_amount = $esl_statutory_deduction / 2;
									} else {
										$ededuction_amount = $esl_statutory_deduction;
									}
								} else {
									$ededuction_amount = $esl_statutory_deduction;
								}
								$statutory_deduction_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'deduction_title' => $sl_statutory_deduction->deduction_title,
									//'deduction_amount' => $sl_statutory_deduction->deduction_amount,
									'statutory_options' => $sl_statutory_deduction->statutory_options,
									'deduction_amount' => $ededuction_amount,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_statutory_deductions($statutory_deduction_data);
							}
						}
						$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($user_id);
						$count_loan_deduction = $this->Employees_model->count_employee_deductions($user_id);
						$loan_de_amount = 0;
						if ($count_loan_deduction > 0) {
							foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
								$loan_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'loan_title' => $sl_salary_loan_deduction->loan_deduction_title,
									'loan_amount' => $sl_salary_loan_deduction->loan_deduction_amount,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_loan_data = $this->Payroll_model->add_salary_payslip_loan($loan_data);
							}
						}
						$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
						$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
						$overtime_amount = 0;
						if ($count_overtime > 0) {
							foreach ($salary_overtime as $sl_overtime) {
								//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
								$overtime_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'overtime_salary_month' => $this->input->post('month_year'),
									'overtime_title' => $sl_overtime->overtime_type,
									'overtime_no_of_days' => $sl_overtime->no_of_days,
									'overtime_hours' => $sl_overtime->overtime_hours,
									'overtime_rate' => $sl_overtime->overtime_rate,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_overtime_data = $this->Payroll_model->add_salary_payslip_overtime($overtime_data);
							}
						}

						$Return['result'] = $this->lang->line('xin_success_payment_paid');
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} // if basic salary

			}
			$Return['result'] = $this->lang->line('xin_success_payment_paid');
			$this->output($Return);
			exit;
		} // f
	}

	public function add_pay_to_all_bk14122021()
	{
		/*	Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		if ($this->input->post('add_type') == 'payroll') {
			if ($this->input->post('company_id') == 0 && $this->input->post('location_id') == 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_all_employees();
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') == 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_company_payroll_employees($this->input->post('company_id'));
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') != 0 && $this->input->post('department_id') == 0) {
				$eresult = $this->Payroll_model->get_company_location_payroll_employees($this->input->post('company_id'), $this->input->post('location_id'));
				$result = $eresult->result();
			} else if ($this->input->post('company_id') != 0 && $this->input->post('location_id') != 0 && $this->input->post('department_id') != 0) {
				$eresult = $this->Payroll_model->get_company_location_dep_payroll_employees($this->input->post('company_id'), $this->input->post('location_id'), $this->input->post('department_id'));
				$result = $eresult->result();
			} else {
				$Return['error'] = $this->lang->line('xin_record_not_found');
			}
			$system = $this->Xin_model->read_setting_info(1);
			$system_settings = system_settings_info(1);
			if ($system_settings->online_payment_account == '') {
				$online_payment_account = 0;
			} else {
				$online_payment_account = $system_settings->online_payment_account;
			}
			foreach ($result as $empid) {
				$user_id = $empid->user_id;
				$user = $this->Xin_model->read_user_info($user_id);
				/* Server side PHP input validation */
				if ($empid->wages_type == 1) {
					$basic_salary = $empid->basic_salary;
				} else {
					$basic_salary = $empid->daily_wages;
				}
				$pay_count = $this->Payroll_model->read_make_payment_payslip_check($user_id, $this->input->post('month_year'));
				if ($pay_count->num_rows() > 0) {
					$pay_val = $this->Payroll_model->read_make_payment_payslip($user_id, $this->input->post('month_year'));
					$this->payslip_delete_all($pay_val[0]->payslip_id);
				}
				if ($basic_salary > 0) {

					// get designation
					$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
					if (!is_null($designation)) {
						$designation_id = $designation[0]->designation_id;
					} else {
						$designation_id = 1;
					}
					// department
					$department = $this->Department_model->read_department_information($user[0]->department_id);
					if (!is_null($department)) {
						$department_id = $department[0]->department_id;
					} else {
						$department_id = 1;
					}

					// changed files
					$pay_date = $this->input->post('month_year');
					//overtime request
					$overtime_count = $this->Overtime_request_model->get_overtime_request_count($user_id, $this->input->post('month_year'));
					$re_hrs_old_int1 = 0;
					$re_hrs_old_seconds = 0;
					$re_pcount = 0;
					foreach ($overtime_count as $overtime_hr) {
						// total work
						$request_clock_in = new DateTime($overtime_hr->request_clock_in);
						$request_clock_out = new DateTime($overtime_hr->request_clock_out);
						$re_interval_late = $request_clock_in->diff($request_clock_out);
						$re_hours_r = $re_interval_late->format('%h');
						$re_minutes_r = $re_interval_late->format('%i');
						$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

						$re_str_time = $re_total_time;

						$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

						sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

						$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

						$re_hrs_old_int1 += $re_hrs_old_seconds;

						$re_pcount = gmdate("H", $re_hrs_old_int1);
					}
					$result = $this->Payroll_model->total_hours_worked($user_id, $pay_date);
					$hrs_old_int1 = 0;
					$pcount = 0;
					$Trest = 0;
					$total_time_rs = 0;
					$hrs_old_int_res1 = 0;
					foreach ($result->result() as $hour_work) {
						// total work
						$clock_in = new DateTime($hour_work->clock_in);
						$clock_out = new DateTime($hour_work->clock_out);
						$interval_late = $clock_in->diff($clock_out);
						$hours_r = $interval_late->format('%h');
						$minutes_r = $interval_late->format('%i');
						$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

						$str_time = $total_time;

						$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

						sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

						$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

						$hrs_old_int1 += $hrs_old_seconds;

						$pcount = gmdate("H", $hrs_old_int1);
					}
					$pcount = $pcount + $re_pcount;
					// get company
					$company = $this->Xin_model->read_company_info($user[0]->company_id);
					if (!is_null($company)) {
						$comp_name = $company[0]->name;
					} else {
						$comp_name = '--';
					}

					// 1: salary type
					if ($user[0]->wages_type == 1) {
						$wages_type = $this->lang->line('xin_payroll_basic_salary');
						if ($system[0]->is_half_monthly == 1) {
							$basic_salary = $user[0]->basic_salary / 2;
						} else {
							$basic_salary = $user[0]->basic_salary;
						}
						$p_class = 'emo_monthly_pay';
						$view_p_class = 'payroll_template_modal';
					} else if ($user[0]->wages_type == 2) {
						$wages_type = $this->lang->line('xin_employee_daily_wages');
						if ($pcount > 0) {
							$basic_salary = $pcount * $user[0]->basic_salary;
						} else {
							$basic_salary = $pcount;
						}
						$p_class = 'emo_hourly_pay';
						$view_p_class = 'hourlywages_template_modal';
					} else {
						$wages_type = $this->lang->line('xin_payroll_basic_salary');
						if ($system[0]->is_half_monthly == 1) {
							$basic_salary = $user[0]->basic_salary / 2;
						} else {
							$basic_salary = $user[0]->basic_salary;
						}
						$p_class = 'emo_monthly_pay';
						$view_p_class = 'payroll_template_modal';
					}
					// 2: all allowances
					$salary_allowances = $this->Employees_model->read_salary_allowances_with_status($user_id);
					$count_allowances = $this->Employees_model->count_employee_allowances_with_status($user_id);
					$allowance_amount = 0;
					if ($count_allowances > 0) {
						foreach ($salary_allowances as $sl_allowances) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$eallowance_amount = $sl_allowances->allowance_amount / 2;
								} else {
									$eallowance_amount = $sl_allowances->allowance_amount;
								}
								$allowance_amount += $eallowance_amount;
							} else {
								//$eallowance_amount = $sl_allowances->allowance_amount;
								if ($sl_allowances->is_allowance_taxable == 1) {
									if ($sl_allowances->amount_option == 0) {
										$iallowance_amount = $sl_allowances->allowance_amount;
									} else {
										$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
									}
									$allowance_amount -= $iallowance_amount;
								} else if ($sl_allowances->is_allowance_taxable == 2) {
									if ($sl_allowances->amount_option == 0) {
										$iallowance_amount = $sl_allowances->allowance_amount / 2;
									} else {
										$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
									}
									$allowance_amount -= $iallowance_amount;
								} else {
									if ($sl_allowances->amount_option == 0) {
										$iallowance_amount = $sl_allowances->allowance_amount;
									} else {
										$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
									}
									$allowance_amount += $iallowance_amount;
								}
							}
						}
					} else {
						$allowance_amount = 0;
					}
					// 3: all loan/deductions
					$loan_m = date('m', strtotime($this->input->post('month_year')));
					//$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions_with_status_new($user_id,$loan_m);
					//$count_loan_deduction = $this->Employees_model->count_employee_deductions_with_status_new($user_id,$loan_m);
					$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions_with_status($user_id, $loan_m);
					$count_loan_deduction = $this->Employees_model->count_employee_deductions_with_status($user_id, $loan_m);
					$loan_de_amount = 0;
					if ($count_loan_deduction > 0) {
						foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
							/*if($system[0]->is_half_monthly==1){
        					  	  if($system[0]->half_deduct_month==2){
        							  $er_loan = $sl_salary_loan_deduction->loan_deduction_amount/2;
        						  } else {
        							  $er_loan = $sl_salary_loan_deduction->loan_deduction_amount;
        						  }
                            	} else {
        						  $er_loan = $sl_salary_loan_deduction->loan_deduction_amount;
                              	}*/
							$get_loan_distrbutions = $this->Employees_model->get_employee_loan_distrubtion($user_id, $sl_salary_loan_deduction->loan_deduction_id);
							if ($get_loan_distrbutions) {
								foreach ($get_loan_distrbutions as $distr) {
									if ($distr->month_year == date('Y-m', strtotime($this->input->post('month_year')))) {
										$loan_de_amount += $distr->amount;
									}
								}
							} else {
								$loan_de_amount += 0;
							}
							//$loan_de_amount += $er_loan;
						}
					} else {
						$loan_de_amount = 0;
					}
					// commissions
					$count_commissions = $this->Employees_model->count_employee_commissions_with_status($user_id);
					$commissions = $this->Employees_model->set_employee_commissions_with_status($user_id);
					$commissions_amount = 0;
					if ($count_commissions > 0) {
						foreach ($commissions->result() as $sl_salary_commissions) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$ecommissions_amount = $sl_salary_commissions->commission_amount / 2;
								} else {
									$ecommissions_amount = $sl_salary_commissions->commission_amount;
								}
								$commissions_amount += $ecommissions_amount;
							} else {
								// $ecommissions_amount = $sl_salary_commissions->commission_amount;
								if ($sl_salary_commissions->is_commission_taxable == 1) {
									if ($sl_salary_commissions->amount_option == 0) {
										$ecommissions_amount = $sl_salary_commissions->commission_amount;
									} else {
										$ecommissions_amount = $basic_salary / 100 * $sl_salary_commissions->commission_amount;
									}
									$commissions_amount -= $ecommissions_amount;
								} else if ($sl_salary_commissions->is_commission_taxable == 2) {
									if ($sl_salary_commissions->amount_option == 0) {
										$ecommissions_amount = $sl_salary_commissions->commission_amount / 2;
									} else {
										$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_salary_commissions->commission_amount;
									}
									$commissions_amount -= $ecommissions_amount;
								} else {
									if ($sl_salary_commissions->amount_option == 0) {
										$ecommissions_amount = $sl_salary_commissions->commission_amount;
									} else {
										$ecommissions_amount = $basic_salary / 100 * $sl_salary_commissions->commission_amount;
									}
									$commissions_amount += $ecommissions_amount;
								}
							}
						}
					} else {
						$commissions_amount = 0;
					}
					// otherpayments
					$count_other_payments = $this->Employees_model->count_employee_other_payments_with_status($user_id);
					$other_payments = $this->Employees_model->set_employee_other_payments_with_status($user_id);
					$other_payments_amount = 0;
					if ($count_other_payments > 0) {
						foreach ($other_payments->result() as $sl_other_payments) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$epayments_amount = $sl_other_payments->payments_amount / 2;
								} else {
									$epayments_amount = $sl_other_payments->payments_amount;
								}
								$other_payments_amount += $epayments_amount;
							} else {
								// $epayments_amount = $sl_other_payments->payments_amount;
								if ($sl_other_payments->is_otherpayment_taxable == 1) {
									if ($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount;
									} else {
										$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
									}
									$other_payments_amount -= $epayments_amount;
								} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
									if ($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount / 2;
									} else {
										$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
									}
									$other_payments_amount -= $epayments_amount;
								} else {
									if ($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount;
									} else {
										$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
									}
									$other_payments_amount += $epayments_amount;
								}
							}
						}
					} else {
						$other_payments_amount = 0;
					}
					// statutory_deductions
					$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions_with_status($user_id);
					$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_with_status($user_id);
					$statutory_deductions_amount = 0;
					if ($count_statutory_deductions > 0) {
						foreach ($statutory_deductions->result() as $sl_salary_statutory_deductions) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$single_sd = $sl_salary_statutory_deductions->deduction_amount / 2;
								} else {
									$single_sd = $sl_salary_statutory_deductions->deduction_amount;
								}
								$statutory_deductions_amount += $single_sd;
							} else {
								//$single_sd = $sl_salary_statutory_deductions->deduction_amount;
								if ($sl_salary_statutory_deductions->statutory_options == 0) {
									$single_sd = $sl_salary_statutory_deductions->deduction_amount;
								} else {
									$single_sd = $basic_salary / 100 * $sl_salary_statutory_deductions->deduction_amount;
								}
								$statutory_deductions_amount += $single_sd;
							}
						}
					} else {
						$statutory_deductions_amount = 0;
					}
					// 5: overtime
					$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
					$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
					$overtime_amount = 0;
					if ($count_overtime > 0) {
						foreach ($salary_overtime as $sl_overtime) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$eovertime_hours = $sl_overtime->overtime_hours / 2;
									$eovertime_rate = $sl_overtime->overtime_rate / 2;
								} else {
									$eovertime_hours = $sl_overtime->overtime_hours;
									$eovertime_rate = $sl_overtime->overtime_rate;
								}
							} else {
								$eovertime_hours = $sl_overtime->overtime_hours;
								$eovertime_rate = $sl_overtime->overtime_rate;
							}
							$overtime_total = $eovertime_hours * $eovertime_rate;
							//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
							$overtime_amount += $overtime_total;
						}
					} else {
						$overtime_amount = 0;
					}
					// saudi gosi
					if ($system[0]->enable_saudi_gosi != 0) {
						$gois_amn = $basic_salary + $allowance_amount;
						$enable_saudi_gosi = $gois_amn / 100 * $system[0]->enable_saudi_gosi;
						$saudi_gosi = $enable_saudi_gosi;
					} else {
						$saudi_gosi = 0;
					}
					$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount + $saudi_gosi;
					$total_deduction = $loan_de_amount + $statutory_deductions_amount;
					$total_net_salary = $total_earning - $total_deduction;
					$net_salary = $total_net_salary;
					$advance_amount = 0;
					// get advance salary
					$advance_salary = $this->Payroll_model->advance_salary_by_employee_id($user_id);
					$emp_value = $this->Payroll_model->get_paid_salary_by_employee_id($user_id);

					if (!is_null($advance_salary)) {
						/*$monthly_installment = $advance_salary[0]->monthly_installment;
        					$advance_amount = $advance_salary[0]->advance_amount;
        					$total_paid = $advance_salary[0]->total_paid;
        					//check ifpaid
        					$em_advance_amount = $advance_salary[0]->advance_amount;
        					$em_total_paid = $advance_salary[0]->total_paid;

        					if($em_advance_amount > $em_total_paid){
        						if($monthly_installment=='' || $monthly_installment==0) {

        							$ntotal_paid = $emp_value[0]->total_paid;
        							$nadvance = $emp_value[0]->advance_amount;
        							$i_net_salary = $nadvance - $ntotal_paid;
        							//$pay_amount = $net_salary - $i_net_salary;
        							$advance_amount = $i_net_salary;
        						} else {
        							//
        							$re_amount = $em_advance_amount - $em_total_paid;
        							if($monthly_installment > $re_amount){
        								$advance_amount = $re_amount;
        								//$total_net_salary = $net_salary - $re_amount;
        								$pay_amount = $net_salary - $re_amount;
        							} else {
        								$advance_amount = $monthly_installment;
        								//$total_net_salary = $net_salary - $monthly_installment;
        								$pay_amount = $net_salary - $monthly_installment;
        							}
        						}

        					} else {
        						$i_net_salary = $net_salary - 0;
        						$pay_amount = $net_salary - 0;
        						$advance_amount = 0;
        					}*/
						foreach ($advance_salary as $val_adv) {
							$get_advance_distrbutions = $this->Payroll_model->get_employee_advance_salary_distrubtion($user_id, $val_adv->advance_salary_id);
							if ($get_advance_distrbutions) {
								foreach ($get_advance_distrbutions as $distr) {
									if ($distr->month_year == date('Y-m', strtotime($this->input->post('month_year')))) {
										$advance_amount += $distr->amount;
									}
								}
							} else {
								$advance_amount += 0;
							}
						}
					} else {
						$pay_amount = $net_salary - 0;
						$i_net_salary = $net_salary - 0;
						$advance_amount = 0;
					}
					$total_net_salary = $total_net_salary - $advance_amount;

					//Using attendance
					$month_year = $pay_date;
					$start_date_y = date('m', strtotime($month_year));
					$start_date_y_m = date('Y-m', strtotime($month_year));
					$emp_leaves = $this->Employees_model->emp_leave_fetch($user_id, $start_date_y);
					$date = strtotime(date("Y-m-d"));
					if (!isset($month_year)) {
						$day = date('d', $date);
						$month = date('m', $date);
						$year = date('Y', $date);
						$month_year = date('Y-m');
					} else {
						$imonth_year = explode('-', $month_year);
						$day = date('d', $date);
						$month = date($imonth_year[1], $date);
						$year = date($imonth_year[0], $date);
						$month_year = $month_year;
					}
					$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

					$arry_years = array();
					$st = '';
					$p_count_val = 0;
					$start_date_co = $year . '-' . $month . '-' . '1';
					$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
					$off_day_arr = array();
					$holiday_arr = array();
					$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
					if (!is_null($office_shift)) {
						$start_date_co = $year . '-' . $month . '-' . '01';
						$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
						$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $user[0]->company_id);
						if ($h_date_chck->num_rows() > 0) {
							$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $user[0]->company_id);
							foreach ($h_date as $val) {
								$begin = new DateTime($val->start_date);
								$end = new DateTime($val->end_date);
								$end = $end->modify('+1 day');

								$interval = new DateInterval('P1D');
								$daterange = new DatePeriod($begin, $interval, $end);

								foreach ($daterange as $date) {
									$holiday_arr[] = $date->format("Y-m-d");
								}
							}
							$p_count_val += count($holiday_arr);
						}
					}
					if ($office_shift) {
						if ($office_shift[0]->monday_in_time == '') {
							$off_day_arr[] = 'Mon';
						}
						if ($office_shift[0]->tuesday_in_time == '') {
							$off_day_arr[] = 'Tue';
						}
						if ($office_shift[0]->wednesday_in_time == '') {
							$off_day_arr[] = 'Wed';
						}
						if ($office_shift[0]->thursday_in_time == '') {
							$off_day_arr[] = 'Thu';
						}
						if ($office_shift[0]->friday_in_time == '') {
							$off_day_arr[] = 'Fri';
						}
						if ($office_shift[0]->saturday_in_time == '') {
							$off_day_arr[] = 'Sat';
						}
						if ($office_shift[0]->sunday_in_time == '') {
							$off_day_arr[] = 'Sun';
						}
						$p_count_val += $this->calculateSatuSundDaysInMonth($year, $month, $off_day_arr);
					}


					$leave_arr = array();
					$half_leave_arr = array();
					$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user[0]->user_id, $start_date_co, $end_date_co);
					if ($leave_date_chck->num_rows() > 0) {
						$leave_date = $this->Timesheet_model->leave_date_new($user[0]->user_id, $start_date_co, $end_date_co);
						foreach ($leave_date as $leave_dates) {
							$begin1 = new DateTime($leave_dates->from_date);
							$end1 = new DateTime($leave_dates->to_date);
							$end1 = $end1->modify('+1 day');
							$half_day_check = $leave_dates->is_half_day;
							$interval1 = new DateInterval('P1D');
							$daterange1 = new DatePeriod($begin1, $interval1, $end1);

							foreach ($daterange1 as $date1) {
								if ($half_day_check == 1) {
									$half_leave_arr[] = $date1->format("Y-m-d");
								} else {
									$leave_arr[] = $date1->format("Y-m-d");
								}
							}
						}
					}
					$present_arr = array();
					$tot_days = 0;
					//$st = $this->db->last_query();
					$total_leaves = count($leave_arr) + count($half_leave_arr);
					$p_count_val += abs($total_leaves - $tot_days);
					$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
					$absent_count = 0;
					$leave_count = 0;
					/*if(strtotime($month_year) == strtotime(date('Y-m'))){
    						$month_year_att = $month_year.'-01';
    						$month_year_att_end = $month_year.'-'.date('d');
    						$startDate = new DateTime($month_year_att);
    						$endDate = new DateTime($month_year_att_end);
    						$difference = $endDate->diff($startDate);
    						$difference_days  = $difference->format("%a");
    					}else if(strtotime($month_year) <= strtotime(date('Y-m'))){
    						$difference_days  = $daysInMonth;
    					}else if(strtotime($month_year) >= strtotime(date('Y-m'))){
    						$difference_days  = 0;
    					}*/
					$user = $this->Xin_model->read_user_info($r->user_id);
					if (strtotime($month_year) == strtotime(date('Y-m'))) {
						$month_year_att = $month_year . '-01';
						if ($user[0]->date_of_leaving) {
							/*if(strtotime($month_year) == strtotime(date("Y-m",strtotime($user[0]->date_of_leaving)))){

						        $month_year_att_end = $user[0]->date_of_leaving;
						        $startDate = new DateTime($month_year_att);
        						$endDate = new DateTime($month_year_att_end);
        						$difference = $endDate->diff($startDate);
        						$difference_days  = $difference->format("%a");
						    }else if($month_year > date("Y-m",strtotime($user[0]->date_of_leaving))){
								$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days  = $difference->format("%a");
							}else{
						        $difference_days = 0;
						    }*/
							if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
								$month_year_att_end = $user[0]->date_of_leaving;
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
						//$difference_days  = $daysInMonth;
						$month_year_att = $month_year . '-01';
						$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
						if ($get_attendance_last_entered) {
							$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
							//$month_year_att_end = $month_year.'-'.date('d');
							$startDate = new DateTime($month_year_att);
							$endDate = new DateTime($month_year_att_end);
							$difference = $endDate->diff($startDate);
							$difference_days = $difference->format("%a") + 1;
						} else {
							$difference_days = 0;
						}
					} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
						$difference_days = 0;
					}
					$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
					if (!is_null($office_shift)) {
						for ($i = 1; $i <= $difference_days; $i++) :
							$i = str_pad($i, 2, 0, STR_PAD_LEFT);
							// get date <
							$attendance_date = $year . '-' . $month . '-' . $i;
							$tdate = $year . '-' . $month . '-' . $i;
							$get_day = strtotime($attendance_date);
							$day = date('l', $get_day);
							$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
							if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
								$holiday_count += 1;
							} else if (in_array($attendance_date, $holiday_arr)) { // holiday
								$public_holiday_count += 1;
							} else if (in_array($attendance_date, $leave_arr)) { // on leave
								$leave_count += 1;
							} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
								$status = 'HDL';
								$leave__half_day_count += 0.5;
							} else if ($check->num_rows() > 0) {
								$attendance = $this->Timesheet_model->attendance_first_in($user[0]->user_id, $attendance_date);
								$present_count += 1;
							} else {
								$absent_count += 1;
								//$pcount += 0;
							}

						endfor;
					}

					//$p_count_val  = $check;
					//$p_count_val = $tot_days;
					//End attendance based
					//Number of days calc
					$total_k = 1;
					$k = 1;
					$extra_amount = 0;
					$tot_days = $monthy_present_days = 0;
					$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
					$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
					$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
					$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;
					$emp_leaves = $this->Employees_model->emp_leave_fetch($user[0]->user_id, $start_date_y);
					if ($emp_leaves) {
						foreach ($emp_leaves as $emp_leave) {
							$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id, $start_date_y_m, $emp_leave->leave_type_id);

							$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
                                      WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . date('Y-m-d H:i:s', strtotime($month_year_end)) . "'";
							$binds = array($emp_leave->employee_id);
							$query = $this->db->query($sql, $binds);
							$tmp = $query->result();
							$amt_deduct = 0;
							if ($emp_leave->leave_type_id == 7) {
								$tot_days_lop += $emp_leave->total_leaves;
								$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
							} else if ($emp_leave->leave_type_id == 4) {
								$tot_days_lop = $count_remain_again = $count_remain = 0;
								if ($emp_leave->total_leaves > 15) {
									$count_remain = $emp_leave->total_leaves - 15;
									if ($count_remain <= 20) {
										$tot_days_lop += $count_remain / 2;
									} else {
										$count_remain_again = $count_remain - 20;
										$tot_days_lop += (20 / 2);
										$tot_days_lop += $count_remain_again;
									}
									// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
								}
							}
						}
					}
					$tot_days_lop_normal = $tot_days_lop;
					// $totl_num_days_pres = 30 - ($tot_days_lop + $absent_count);
					if (($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) >= 30) {
						//$totl_num_days_pres = 30 - ($tot_days_lop + $absent_count);
						$totl_num_days_pres = 30 - ($absent_count);
					} else {
						//$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
						$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($absent_count);
					}
					$lop_count_salary = ($basic_salary / 30) * $tot_days_lop;
					$monthy_present_days = $totl_num_days_pres;
					$net_salary = ($total_net_salary / 30) * $totl_num_days_pres;
					$net_salary = $net_salary - $lop_count_salary;
					//Annual leave calc
					$joining_date = $this->Timesheet_model->joining_date($user_id);
					$start_date_y_m = date('Y-m', strtotime($month_year));
					$net_annual_amt = 0;
					$annual_amt_pay = $anual_days_leave = 0;
					//  $allowance_amount = 0;$statutory_deductions_amount = 0; $commissions_amount = 0; $loan_de_amount = 0;$other_payments_amount = 0;
					$emp_annuval_leave = $this->Employees_model->emp_annuval_leave_fetch($user_id, $start_date_y_m);
					//$emp_annuval_leave = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($user_id,$joining_date[0]->date_of_joining);
					if (!is_null($emp_annuval_leave)) {
						$allowances = $this->Employees_model->set_employee_allowances_for_leavesalary($user_id);
						$system = $this->Xin_model->read_setting_info(1);
						if (!empty($allowances->result())) {
							foreach ($allowances->result() as $sl_allowances) {
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$iallowance_amount = $sl_allowances->allowance_amount / 2;
									} else {
										$iallowance_amount = $sl_allowances->allowance_amount;
									}
									$allowance_amount += $iallowance_amount;
								} else {
									//$eallowance_amount = $sl_allowances->allowance_amount;
									if ($sl_allowances->is_allowance_taxable == 1) {
										if ($sl_allowances->amount_option == 0) {
											$iallowance_amount = $sl_allowances->allowance_amount;
										} else {
											$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
										}
										$allowance_amount -= $iallowance_amount;
									} else if ($sl_allowances->is_allowance_taxable == 2) {
										if ($sl_allowances->amount_option == 0) {
											$iallowance_amount = $sl_allowances->allowance_amount / 2;
										} else {
											$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
										}
										$allowance_amount -= $iallowance_amount;
									} else {
										if ($sl_allowances->amount_option == 0) {
											$iallowance_amount = $sl_allowances->allowance_amount;
										} else {
											$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
										}
										$allowance_amount += $iallowance_amount;
									}
								}
							}
						}
						$commissions = $this->Employees_model->set_employee_commissions_for_leavesalary($user_id);
						if (!empty($commissions->result())) {
							foreach ($commissions->result() as $sl_commissions) {
								$pg_commissions_amount = $sl_commissions->commission_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$ecommissions_amount = $sl_commissions->commission_amount / 2;
									} else {
										$ecommissions_amount = $sl_commissions->commission_amount;
									}
									$commissions_amount += $ecommissions_amount;
								} else {
									if ($sl_commissions->is_commission_taxable == 1) {
										if ($sl_commissions->amount_option == 0) {
											$ecommissions_amount = $sl_commissions->commission_amount;
										} else {
											$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
										}
										$commissions_amount -= $ecommissions_amount;
									} else if ($sl_commissions->is_commission_taxable == 2) {
										if ($sl_commissions->amount_option == 0) {
											$ecommissions_amount = $sl_commissions->commission_amount / 2;
										} else {
											$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
										}
										$commissions_amount -= $ecommissions_amount;
									} else {
										if ($sl_commissions->amount_option == 0) {
											$ecommissions_amount = $sl_commissions->commission_amount;
										} else {
											$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
										}
										$commissions_amount += $ecommissions_amount;
									}
								}
							}
						}
						$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_for_leavesalary($user_id);
						if (!empty($statutory_deductions->result())) {
							foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
								$sta_salary = $basic_salary;
								$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$single_sd = $st_amount / 2;
									} else {
										$single_sd = $st_amount;
									}
									$statutory_deductions_amount += $single_sd;
								} else {
									if ($sl_statutory_deductions->statutory_options == 0) {
										$single_sd = $sl_statutory_deductions->deduction_amount;
									} else {
										$single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
									}
									$statutory_deductions_amount += $single_sd;
								}
							}
						}
						$other_payments = $this->Employees_model->set_employee_other_payments_leave_salary($user_id);
						if (!empty($other_payments->result())) {
							foreach ($other_payments->result() as $sl_other_payments) {
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$epayments_amount = $sl_other_payments->payments_amount / 2;
									} else {
										$epayments_amount = $sl_other_payments->payments_amount;
									}
									$other_payments_amount += $epayments_amount;
								} else {
									//$epayments_amount = $sl_other_payments->payments_amount;
									if ($sl_other_payments->is_otherpayment_taxable == 1) {
										if ($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount;
										} else {
											$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount -= $epayments_amount;
									} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
										if ($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount / 2;
										} else {
											$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount -= $epayments_amount;
									} else {
										if ($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount;
										} else {
											$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount += $epayments_amount;
									}
								}
							}
						}


						$total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($user_id, $start_date_y_m);
						if ($total_annual_leaves) {
							$anual_days_leave = $total_annual_leaves[0]->days;
							$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id, $joining_date[0]->date_of_joining);
							if ($check_already_exists_paid) {
								$applied_date = $check_already_exists_paid[0]->applied_on;
								$date_arr = explode("-", $applied_date);
								$yr_d_paid = $date_arr[0];

								$date = date_create($total_annual_leaves[0]->applied_on);
								$not_paid_year = date_format($date, "Y");
								$difference_years = $not_paid_year - $yr_d_paid;

								//joining date difference
								$date_joins = $joining_date[0]->date_of_joining;
								$date = date_create($date_joins);
								$date_join = date_format($date, "Y");
								$todays_date = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
								$join_differ = $todays_date - $date_join;
								if ($join_differ > 0) {
									$days_add_start = $join_differ * 365;
								} else {
									$days_add_start = 1 * 365;
								}

								//end joining date difference
								if ($difference_years > 0) {
									$days_add = $difference_years * 365;
								} else {
									$days_add = 1 * 365;
								}

								$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
								$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
							} else {
								$date_joins = $joining_date[0]->date_of_joining;
								$date = date_create($date_joins);
								$date_join = date_format($date, "Y/m/d");
								$todays_date = date('Y-m-d');
								$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
								$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
								$days_add = $years * 365;
								$start_date_co = $joining_date[0]->date_of_joining;
								$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
							}
						}
						$arry_years = array();
						$st = '';
						$p_count_val = 0;
						$off_day_arr = array();
						$holiday_arr = array();
						$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
						if (!is_null($office_shift)) {
							$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $user[0]->company_id);
							if ($h_date_chck->num_rows() > 0) {
								$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $user[0]->company_id);
								foreach ($h_date as $val) {
									$begin = new DateTime($val->start_date);
									$end = new DateTime($val->end_date);
									$end = $end->modify('+1 day');

									$interval = new DateInterval('P1D');
									$daterange = new DatePeriod($begin, $interval, $end);

									foreach ($daterange as $date) {
										$holiday_arr[] = $date->format("Y-m-d");
									}
								}
								$p_count_val += count($holiday_arr);
							}
						}
						$leave_arr = array();
						$half_leave_arr = array();
						$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
						if ($leave_date_chck->num_rows() > 0) {
							$leave_date = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
							foreach ($leave_date as $leave_dates) {
								$begin1 = new DateTime($leave_dates->from_date);
								$end1 = new DateTime($leave_dates->to_date);
								$end1 = $end1->modify('+1 day');
								$half_day_check = $leave_dates->is_half_day;
								$interval1 = new DateInterval('P1D');
								$daterange1 = new DatePeriod($begin1, $interval1, $end1);

								foreach ($daterange1 as $date1) {
									if ($half_day_check == 1) {
										$half_leave_arr[] = $date1->format("Y-m-d");
									} else {
										$leave_arr[] = $date1->format("Y-m-d");
									}
								}
							}
						}
						$present_arr = array();
						//$st = $this->db->last_query();
						$total_leaves = count($leave_arr) + count($half_leave_arr);
						$p_count_val += abs($total_leaves - $tot_days);
						$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
						$absent_count = 0;
						$leave_count = 0;
						$month_year = date('Y-m', strtotime($start_date_co));
						/*if(strtotime($month_year) == strtotime(date('Y-m'))){
    						$month_year_att = $month_year.'-01';
    						$month_year_att_end = $month_year.'-'.date('d');
    						$startDate = new DateTime($month_year_att);
    						$endDate = new DateTime($month_year_att_end);
    						$difference = $endDate->diff($startDate);
    						$difference_days  = $difference->format("%a");
    					}else if(strtotime($month_year) <= strtotime(date('Y-m'))){
    						$month_year_att = $start_date_co;
    						$month_year_att_end = $end_date_co;
    						$startDate = new DateTime($month_year_att);
    						$endDate = new DateTime($month_year_att_end);
    						$difference = $endDate->diff($startDate);
    						$difference_days  = $difference->format("%a");
    					}else if(strtotime($month_year) >= strtotime(date('Y-m'))){
    						$difference_days  = 0;
    					}*/
						$user = $this->Xin_model->read_user_info($r->user_id);
						if (strtotime($month_year) == strtotime(date('Y-m'))) {
							$month_year_att = $month_year . '-01';
							if ($user[0]->date_of_leaving) {
								/*if(strtotime($month_year) == strtotime(date("Y-m",strtotime($user[0]->date_of_leaving)))){

						        $month_year_att_end = $user[0]->date_of_leaving;
						        $startDate = new DateTime($month_year_att);
        						$endDate = new DateTime($month_year_att_end);
        						$difference = $endDate->diff($startDate);
        						$difference_days  = $difference->format("%a");
						    }else if($month_year > date("Y-m",strtotime($user[0]->date_of_leaving))){
								$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days  = $difference->format("%a");
							}else{
						        $difference_days = 0;
						    }*/
								if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
									$month_year_att_end = $user[0]->date_of_leaving;
									$startDate = new DateTime($month_year_att);
									$endDate = new DateTime($month_year_att_end);
									$difference = $endDate->diff($startDate);
									$difference_days = $difference->format("%a") + 1;
								} else {
									$difference_days = 0;
								}
							} else {
								$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
								if ($get_attendance_last_entered) {
									$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
									//$month_year_att_end = $month_year.'-'.date('d');
									$startDate = new DateTime($month_year_att);
									$endDate = new DateTime($month_year_att_end);
									$difference = $endDate->diff($startDate);
									$difference_days = $difference->format("%a") + 1;
								} else {
									$difference_days = 0;
								}
							}
						} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
							//$difference_days  = $daysInMonth;
							$month_year_att = $month_year . '-01';
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
							$difference_days = 0;
						}
						$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
						if (!is_null($office_shift)) {
							for ($i = 1; $i <= $difference_days; $i++) :
								$i = str_pad($i, 2, 0, STR_PAD_LEFT);
								// get date <
								$attendance_date = $month_year . '-' . $i;
								$tdate = date('Y-m', strtotime($end_date_co)) . '-' . $i;
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count += 0.5;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
									$present_count += 1;
								} else {
									$absent_count += 1;
									//$pcount += 0;
								}

							endfor;
						}
						//$p_count_val  = $check;
						//$p_count_val = $tot_days;
						//End attendance based


						/*$final_amounts=($total_net_salary/$daysInMonth)* $tot_days;
    				  	$net_salary = $total_net_salary-$final_amounts;
    				  */
						//Number of days calc
						$total_k = 1;
						$k = 1;
						$extra_amount = 0;
						$tot_days = 0;
						$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
						$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
						$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
						$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;
						$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
						if ($emp_leaves_data->num_rows() > 0) {
							$emp_leaves = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
							foreach ($emp_leaves as $emp_leave) {
								$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
                                          WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
								$binds = array($emp_leave->employee_id);
								$query = $this->db->query($sql, $binds);
								$tmp = $query->result();
								$amt_deduct = 0;
								if ($emp_leave->leave_type_id == 7) {
									$tot_days_lop += $emp_leave->total_leaves;
									$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
								} else if ($emp_leave->leave_type_id == 4) {
									$tot_days_lop = $count_remain_again = $count_remain = 0;
									if ($emp_leave->total_leaves > 15) {
										$count_remain = $emp_leave->total_leaves - 15;
										if ($count_remain <= 20) {
											$tot_days_lop += $count_remain / 2;
										} else {
											$count_remain_again = $count_remain - 20;
											$tot_days_lop += (20 / 2);
											$tot_days_lop += $count_remain_again;
										}
										// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
									}
								}
							}
						}

						//$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
						//end number of calc.
						//annual leave exists then normal pay
						if (!is_null($emp_annuval_leave)) {
							$days_in_month = $days = date("t");
							$normal_pay_days = $days_in_month - $anual_days_leave;
							$normal_pay_days = $normal_pay_days - $tot_days_lop_normal;
							if ($normal_pay_days >= 0) {
								$normal_pay_days = $normal_pay_days;
							} else {
								$normal_pay_days = 0;
							}
							$net_salary = ($total_net_salary / 30) * $normal_pay_days;
						} else {
							$net_salary = ($total_net_salary / 30) * $totl_num_days_pres;
						}
						//end
						if ($net_salary == 0) {
							$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
							if (!empty($loan->result())) {
								foreach ($loan->result() as $r_loan) {
									$loan_de_amount += $r_loan->loan_deduction_amount;
								}
							}
						}
						$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
						$total_deduction = $statutory_deductions_amount + $loan_de_amount;
						$net_annual_amt = $total_earning - $total_deduction;

						$date_joins = $start_date_co;
						$date = date_create($date_joins);
						$date_join = date_format($date, "Y/m/d");
						$todays_date = $end_date_co;
						$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
						$years_count = floor($date_diff_calc / (365 * 60 * 60 * 24));
						if ($years_count > 0) {
							$years_count = $years_count;
						} else {
							$years_count = 1;
						}
						$totl_num_days_pres = (365 * $years_count) - ($tot_days_lop + $absent_count);
						$no_days_ann = (30 / 365) * $totl_num_days_pres;
						$annual_amt_pay = ($net_annual_amt / 30) * $no_days_ann;
					}

					//end annual leave calc

					//Indemnity calc
					$start_date_y = date('m', strtotime($month_year));
					$start_date_y_m = date('Y-m', strtotime($month_year));
					$emp_Indemnity = $this->Employees_model->emp_indemnity_fetch($user_id, $start_date_y);

					$totl_amt = 0;
					if ($emp_Indemnity) {
						foreach ($emp_Indemnity as $emp_leave) {
							$totl_amt += $emp_leave->amount;
						}
					}
					//leave encashment calc
					$start_date_y = date('m', strtotime($month_year));
					$start_date_y_m = date('Y-m', strtotime($month_year));
					$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

					$totl_amt_leva = 0;
					if ($emp_leave_enchas) {
						foreach ($emp_leave_enchas as $emp_leave_ench) {
							$totl_amt_leva += $emp_leave_ench->amount;
						}
					}
					$net_salary = $net_salary + $totl_amt + $totl_amt_leva + $overtime_amount + $annual_amt_pay;
					$basic_salary = $basic_salary;
					

					$net_salary = number_format((float)$net_salary, 2, '.', '');
					$jurl = random_string('alnum', 40);
					$data = array(
						'employee_id' => $user_id,
						'department_id' => $department_id,
						'company_id' => $user[0]->company_id,
						'designation_id' => $designation_id,
						'salary_month' => $this->input->post('month_year'),
						'basic_salary' => $basic_salary,
						'net_salary' => $net_salary,
						'wages_type' => $empid->wages_type,
						'total_allowances' => $allowance_amount,
						'total_loan' => $loan_de_amount,
						'total_overtime' => $overtime_amount,
						'total_commissions' => $commissions_amount,
						'total_statutory_deductions' => $statutory_deductions_amount,
						'total_other_payments' => $other_payments_amount,
						'is_payment' => '1',
						'payslip_type' => 'full_monthly',
						'payslip_key' => $jurl,
						'year_to_date' => date('d-m-Y'),
						'created_at' => date('d-m-Y h:i:s'),
						'monthy_present_days' => $monthy_present_days
					);
					$result = $this->Payroll_model->add_salary_payslip($data);

					if ($result) {
						$ivdata = array(
							'amount' => $net_salary,
							'account_id' => $online_payment_account,
							'transaction_type' => 'expense',
							'dr_cr' => 'cr',
							'transaction_date' => date('Y-m-d'),
							'payer_payee_id' => $user_id,
							'payment_method_id' => 3,
							'description' => 'Payroll Payments',
							'reference' => 'Payroll Payments',
							'invoice_id' => $result,
							'client_id' => $user_id,
							'created_at' => date('Y-m-d H:i:s')
						);
						$this->Finance_model->add_transactions($ivdata);
						// update data in bank account
						$account_id = $this->Finance_model->read_bankcash_information($online_payment_account);
						$acc_balance = $account_id[0]->account_balance - $net_salary;

						$data3 = array(
							'account_balance' => $acc_balance
						);
						$this->Finance_model->update_bankcash_record($data3, $online_payment_account);

						$salary_allowances = $this->Employees_model->read_salary_allowances($user_id);
						$count_allowances = $this->Employees_model->count_employee_allowances($user_id);
						$allowance_amount = 0;
						if ($count_allowances > 0) {
							foreach ($salary_allowances as $sl_allowances) {
								$allowance_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'allowance_title' => $sl_allowances->allowance_title,
									'allowance_amount' => $sl_allowances->allowance_amount,
									'is_allowance_taxable' => $sl_allowances->is_allowance_taxable,
									'amount_option' => $sl_allowances->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_allowance_data = $this->Payroll_model->add_salary_payslip_allowances($allowance_data);
							}
						}
						// set commissions
						$salary_commissions = $this->Employees_model->read_salary_commissions($user_id);
						$count_commission = $this->Employees_model->count_employee_commissions($user_id);
						$commission_amount = 0;
						if ($count_commission > 0) {
							foreach ($salary_commissions as $sl_commission) {
								$commissions_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'commission_title' => $sl_commission->commission_title,
									'commission_amount' => $sl_commission->commission_amount,
									'is_commission_taxable' => $sl_commission->is_commission_taxable,
									'amount_option' => $sl_commission->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_commissions($commissions_data);
							}
						}
						// set other payments
						$salary_other_payments = $this->Employees_model->read_salary_other_payments($user_id);
						$count_other_payment = $this->Employees_model->count_employee_other_payments($user_id);
						$other_payment_amount = 0;
						if ($count_other_payment > 0) {
							foreach ($salary_other_payments as $sl_other_payments) {
								$other_payments_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'payments_title' => $sl_other_payments->payments_title,
									'payments_amount' => $sl_other_payments->payments_amount,
									'is_otherpayment_taxable' => $sl_other_payments->is_otherpayment_taxable,
									'amount_option' => $sl_other_payments->amount_option,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_other_payments($other_payments_data);
							}
						}
						// set statutory_deductions
						$salary_statutory_deductions = $this->Employees_model->read_salary_statutory_deductions($user_id);
						$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions($user_id);
						$statutory_deductions_amount = 0;
						if ($count_statutory_deductions > 0) {
							foreach ($salary_statutory_deductions as $sl_statutory_deduction) {

								$esl_statutory_deduction = $sl_statutory_deduction->deduction_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$ededuction_amount = $esl_statutory_deduction / 2;
									} else {
										$ededuction_amount = $esl_statutory_deduction;
									}
								} else {
									$ededuction_amount = $esl_statutory_deduction;
								}
								$statutory_deduction_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'deduction_title' => $sl_statutory_deduction->deduction_title,
									//'deduction_amount' => $sl_statutory_deduction->deduction_amount,
									'statutory_options' => $sl_statutory_deduction->statutory_options,
									'deduction_amount' => $ededuction_amount,
									'created_at' => date('d-m-Y h:i:s')
								);
								$this->Payroll_model->add_salary_payslip_statutory_deductions($statutory_deduction_data);
							}
						}
						$salary_loan_deduction = $this->Employees_model->read_salary_loan_deductions($user_id);
						$count_loan_deduction = $this->Employees_model->count_employee_deductions($user_id);
						$loan_de_amount = 0;
						if ($count_loan_deduction > 0) {
							foreach ($salary_loan_deduction as $sl_salary_loan_deduction) {
								$loan_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'salary_month' => $this->input->post('month_year'),
									'loan_title' => $sl_salary_loan_deduction->loan_deduction_title,
									'loan_amount' => $sl_salary_loan_deduction->loan_deduction_amount,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_loan_data = $this->Payroll_model->add_salary_payslip_loan($loan_data);
							}
						}
						$salary_overtime = $this->Employees_model->read_salary_overtime($user_id);
						$count_overtime = $this->Employees_model->count_employee_overtime($user_id);
						$overtime_amount = 0;
						if ($count_overtime > 0) {
							foreach ($salary_overtime as $sl_overtime) {
								//$overtime_total = $sl_overtime->overtime_hours * $sl_overtime->overtime_rate;
								$overtime_data = array(
									'payslip_id' => $result,
									'employee_id' => $user_id,
									'overtime_salary_month' => $this->input->post('month_year'),
									'overtime_title' => $sl_overtime->overtime_type,
									'overtime_no_of_days' => $sl_overtime->no_of_days,
									'overtime_hours' => $sl_overtime->overtime_hours,
									'overtime_rate' => $sl_overtime->overtime_rate,
									'created_at' => date('d-m-Y h:i:s')
								);
								$_overtime_data = $this->Payroll_model->add_salary_payslip_overtime($overtime_data);
							}
						}

						$Return['result'] = $this->lang->line('xin_success_payment_paid');
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');
					}
				} // if basic salary

			}
			$Return['result'] = $this->lang->line('xin_success_payment_paid');
			$this->output($Return);
			exit;
		} // f
	}

	// hourly_list > templates
	public function payment_history_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/payment_history", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0) {
				if ($this->input->get("salary_month") == '') {
					$history = $this->Payroll_model->all_employees_payment_history();
				} else {
					$history = $this->Payroll_model->all_employees_payment_history_month($this->input->get("salary_month"));
				}
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") == 0 && $this->input->get("department_id") == 0) {
				if ($this->input->get("salary_month") == '') {
					$history = $this->Payroll_model->get_company_payslip_history($this->input->get("company_id"));
				} else {
					$history = $this->Payroll_model->get_company_payslip_history_month($this->input->get("company_id"), $this->input->get("salary_month"));
				}
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") == 0) {
				if ($this->input->get("salary_month") == '') {
					$history = $this->Payroll_model->get_company_location_payslips($this->input->get("company_id"), $this->input->get("location_id"));
				} else {
					$history = $this->Payroll_model->get_company_location_payslips_month($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("salary_month"));
				}
			} else if ($this->input->get("company_id") != 0 && $this->input->get("location_id") != 0 && $this->input->get("department_id") != 0) {
				if ($this->input->get("salary_month") == '') {
					$history = $this->Payroll_model->get_company_location_department_payslips($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"));
				} else {
					$history = $this->Payroll_model->get_company_location_department_payslips_month($this->input->get("company_id"), $this->input->get("location_id"), $this->input->get("department_id"), $this->input->get("salary_month"));
				}
			}/**/ /*else if($this->input->get("company_id")!=0 && $this->input->get("location_id")!=0 && $this->input->get("department_id")!=0 && $this->input->get("designation_id")!=0){
				$history = $this->Payroll_model->get_company_location_department_designation_payslips($this->input->get("company_id"),$this->input->get("location_id"),$this->input->get("department_id"),$this->input->get("designation_id"));
			}*/
		} else {
			if ($user_info[0]->user_role_id == 1) {
				$history = $this->Payroll_model->employees_payment_history();
			} else {
				if (in_array('288', $role_resources_ids)) {
					$history = $this->Payroll_model->get_company_payslips($user_info[0]->company_id);
				} else {
					$history = $this->Payroll_model->get_payroll_slip($session['user_id']);
				}
			}
		}
		$data = array();

		foreach ($history->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				$emp_link = $user[0]->employee_id;
				$month_payment = date("F, Y", strtotime($r->salary_month));

				$p_amount = $this->Xin_model->company_currency_sign($r->net_salary,$r->company_id);

				// get date > created at > and format
				$created_at = $this->Xin_model->set_date_format($r->created_at);
				// get designation
				$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
				$department_designation = $designation_name . ' (' . $department_name . ')';
				// get company
				$company = $this->Xin_model->read_company_info($user[0]->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}
				// bank account
				$bank_account = $this->Employees_model->get_employee_bank_account_last($user[0]->user_id);
				if (!is_null($bank_account)) {
					$account_number = $bank_account[0]->account_number;
				} else {
					$account_number = '--';
				}
				if (in_array('288', $role_resources_ids)) {
					$payslip = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $r->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $r->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
				} else {
					$payslip = '';
				}
				$ifull_name = nl2br($full_name . "\r\n <small class='text-muted'><i>" . $this->lang->line('xin_employees_id') . ': ' . $emp_link . "<i></i></i></small>\r\n <small class='text-muted'><i>" . $department_designation . '<i></i></i></small>');
				if (in_array('288', $role_resources_ids)) {
					$data[] = array(
						$full_name,
						$comp_name,
						$account_number,
						$p_amount,
						$month_payment,
						$created_at,
						$payslip,
					);
				} else {
					$data[] = array(
						$full_name,
						$comp_name,
						$account_number,
						$p_amount,
						$month_payment,
						$created_at,
					);
				}
			}
		} // if employee available

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $history->num_rows(),
			"recordsFiltered" => $history->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// payment history
	public function payslip()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		//$data['title'] = $this->Xin_model->site_title();
		$key = $this->uri->segment(5);

		$result = $this->Payroll_model->read_salary_payslip_info_key($key);
		if (is_null($result)) {
			redirect('admin/payroll/generate_payslip');
		}
		$p_method = '';
		/*$payment_method = $this->Xin_model->read_payment_method($result[0]->payment_method);
		if(!is_null($payment_method)){
		  $p_method = $payment_method[0]->method_name;
		} else {
		  $p_method = '--';
		}*/
		// get addd by > template
		$user = $this->Xin_model->read_user_info($result[0]->employee_id);
		// user full name
		if (!is_null($user)) {
			$first_name = $user[0]->first_name;
			$middle_name = $user[0]->middle_name;
			$last_name = $user[0]->last_name;
		} else {
			$first_name = '--';
			$middle_name = '--';
			$last_name = '--';
		}
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_name = $designation[0]->designation_name;
		} else {
			$designation_name = '--';
		}

		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_name = $department[0]->department_name;
		} else {
			$department_name = '--';
		}
		//$department_designation = $designation[0]->designation_name.'('.$department[0]->department_name.')';
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data = array(
			'title' => $this->lang->line('xin_payroll_employee_payslip') . ' | ' . $this->Xin_model->site_title(),
			'first_name' => $first_name,
			'middle_name' => $middle_name,
			'last_name' => $last_name,
			'company_id' => $user[0]->company_id,
			'employee_id' => $user[0]->employee_id,
			'euser_id' => $user[0]->user_id,
			'contact_no' => $user[0]->contact_no,
			'date_of_joining' => $user[0]->date_of_joining,
			'department_name' => $department_name,
			'designation_name' => $designation_name,
			'date_of_joining' => $user[0]->date_of_joining,
			'profile_picture' => $user[0]->profile_picture,
			'gender' => $user[0]->gender,
			'make_payment_id' => $result[0]->payslip_id,
			'wages_type' => $result[0]->wages_type,
			'payment_date' => $result[0]->salary_month,
			'year_to_date' => $result[0]->year_to_date,
			'basic_salary' => $result[0]->basic_salary,
			'daily_wages' => $result[0]->daily_wages,
			'payment_method' => $p_method,
			'total_allowances' => $result[0]->total_allowances,
			'total_loan' => $result[0]->total_loan,
			'total_overtime' => $result[0]->total_overtime,
			'total_late_deduction' => $result[0]->total_late_deduction,
			'total_commissions' => $result[0]->total_commissions,
			'total_statutory_deductions' => $result[0]->total_statutory_deductions,
			'total_other_payments' => $result[0]->total_other_payments,
			'net_salary' => $result[0]->net_salary,
			'other_payment' => $result[0]->other_payment,
			'payslip_key' => $result[0]->payslip_key,
			'payslip_type' => $result[0]->payslip_type,
			'hours_worked' => $result[0]->hours_worked,
			'pay_comments' => $result[0]->pay_comments,
			'saudi_gosi_percent' => $result[0]->saudi_gosi_percent,
			'saudi_gosi_amount' => $result[0]->saudi_gosi_amount,
			'is_advance_salary_deduct' => $result[0]->is_advance_salary_deduct,
			'advance_salary_amount' => $result[0]->advance_salary_amount,
			'is_payment' => $result[0]->is_payment,
			'approval_status' => $result[0]->status,
			'leave_deduction' => $result[0]->leave_deduction,
			'indeminty_amt_det' => $result[0]->amt_indemnity,
			'annual_leave_amt' => $result[0]->annual_leave_amt,
			'total_outstanding' => $result[0]->total_outstanding,
			'asset_complaint_amt' => $result[0]->asset_complaint_amt,
			'monthy_present_days' => $result[0]->monthy_present_days,
			'expense_claim' => $result[0]->expense_claim,
			'airticket_encashment' => $result[0]->airticket_encashment
		);
		$data['breadcrumbs'] = $this->lang->line('xin_payroll_employee_payslip');
		$data['path_url'] = 'payslip';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (!empty($session)) {
			if ($result[0]->payslip_type == 'hourly') {
				$data['subview'] = $this->load->view("admin/payroll/hourly_payslip", $data, TRUE);
			} else {
				$data['subview'] = $this->load->view("admin/payroll/payslip", $data, TRUE);
			}
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/');
		}
	}

	public function pdf_create()
	{

		//$this->load->library('Pdf');
		$system = $this->Xin_model->read_setting_info(1);
		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$key = $this->uri->segment(5);
		$payment = $this->Payroll_model->read_salary_payslip_info_key($key);
		if (is_null($payment)) {
			redirect('admin/payroll/generate_payslip');
		}
		$user = $this->Xin_model->read_user_info($payment[0]->employee_id);

		// if password generate option enable
		if ($system[0]->is_payslip_password_generate == 1) {
			/**
			 * Protect PDF from being printed, copied or modified. In order to being viewed, the user needs
			 * to provide password as selected format in settings module.
			 */
			if ($system[0]->payslip_password_format == 'dateofbirth') {
				$password_val = date("dmY", strtotime($user[0]->date_of_birth));
			} else if ($system[0]->payslip_password_format == 'contact_no') {
				$password_val = $user[0]->contact_no;
			} else if ($system[0]->payslip_password_format == 'full_name') {
				$password_val = $user[0]->first_name . $user[0]->middle_name . $user[0]->last_name;
			} else if ($system[0]->payslip_password_format == 'email') {
				$password_val = $user[0]->email;
			} else if ($system[0]->payslip_password_format == 'employee_id') {
				$password_val = $user[0]->employee_id;
			} else if ($system[0]->payslip_password_format == 'dateofbirth_name') {
				$dob = date("dmY", strtotime($user[0]->date_of_birth));
				$fname = $user[0]->first_name;
				$lname = $user[0]->last_name;
				$password_val = $dob . $fname[0] . $lname[0];
			}
			$pdf->SetProtection(array('print', 'copy', 'modify'), $password_val, $password_val, 0, null);
		}

		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($_des_name)) {
			$_designation_name = $_des_name[0]->designation_name;
		} else {
			$_designation_name = '';
		}
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$_department_name = $department[0]->department_name;
		} else {
			$_department_name = '';
		}
		//$location = $this->Xin_model->read_location_info($department[0]->location_id);
		// company info
		$company = $this->Xin_model->read_company_info($user[0]->company_id);

		$user_id = $user[0]->user_id;
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		//$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
		// set default header data
		//$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode.', '.$country_name;
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
		//$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email ";

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$header_string = $email_phone_address;
		// set document information
		$pdf->SetCreator('HRSALE');
		$pdf->SetAuthor('HRSALE');
		//$pdf->SetTitle('Workable-Zone - Payslip');
		//$pdf->SetSubject('TCPDF Tutorial');
		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
		$pdf->SetHeaderData($logo, 15, $company_name, $header_string);

		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

		// set header and footer fonts
		$pdf->setHeaderFont(array('helvetica', '', 11.5));
		$pdf->setFooterFont(array('helvetica', '', 9));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont('courier');

		// set margins
		$pdf->SetMargins(15, 27, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, 25);

		// set image scale factor
		$pdf->setImageScale(1.25);
		$pdf->SetAuthor('HRSALE');
		$pdf->SetTitle($company_name . ' - ' . $this->lang->line('xin_print_payslip'));
		$pdf->SetSubject($this->lang->line('xin_payslip'));
		$pdf->SetKeywords($this->lang->line('xin_payslip'));
		// set font
		$pdf->SetFont('helvetica', 'B', 10);

		// set header and footer fonts
		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// ---------------------------------------------------------

		// set default font subsetting mode
		$pdf->setFontSubsetting(true);

		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 10, '', true);

		// Add a page
		// This method has several options, check the source code documentation for more information.
		$pdf->AddPage();
		// -----------------------------------------------------------------------------
		$fname = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
		$created_at = $this->Xin_model->set_date_format($payment[0]->created_at);
		$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);
		$salary_month = $this->Xin_model->set_date_format($payment[0]->salary_month);
		// check
		$half_title = '';
		if ($system[0]->is_half_monthly == 1) {
			$payment_check1 = $this->Payroll_model->read_make_payment_payslip_half_month_check_first($payment[0]->employee_id, $payment[0]->salary_month);
			$payment_check2 = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($payment[0]->employee_id, $payment[0]->salary_month);
			$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($payment[0]->employee_id, $payment[0]->salary_month);
			if ($payment_check->num_rows() > 1) {
				if ($payment_check2[0]->payslip_key == $this->uri->segment(5)) {
					$half_title = '(' . $this->lang->line('xin_title_second_half') . ')';
				} else if ($payment_check1[0]->payslip_key == $this->uri->segment(5)) {
					$half_title = '(' . $this->lang->line('xin_title_first_half') . ')';
				} else {
					$half_title = '';
				}
			} else {
				$half_title = '(' . $this->lang->line('xin_title_first_half') . ')';
			}
			$half_title = $half_title;
		} else {
			$half_title = '';
		}

		// basic salary
		$bs = 0;
		$bs = $payment[0]->basic_salary;
		// allowances
		$count_allowances = $this->Employees_model->count_employee_allowances_payslip($payment[0]->payslip_id);
		$allowances = $this->Employees_model->set_employee_allowances_payslip($payment[0]->payslip_id);
		// commissions
		$count_commissions = $this->Employees_model->count_employee_commissions_payslip($payment[0]->payslip_id);
		$commissions = $this->Employees_model->set_employee_commissions_payslip($payment[0]->payslip_id);
		// otherpayments
		$count_other_payments = $this->Employees_model->count_employee_other_payments_payslip($payment[0]->payslip_id);
		$other_payments = $this->Employees_model->set_employee_other_payments_payslip($payment[0]->payslip_id);
		// statutory_deductions
		$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions_payslip($payment[0]->payslip_id);
		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_payslip($payment[0]->payslip_id);
		// overtime
		/*$count_overtime = $this->Employees_model->count_employee_overtime_payslip($payment[0]->payslip_id);
        $overtime = $this->Employees_model->set_employee_overtime_payslip($payment[0]->payslip_id);*/
		// Air ticket Encashment
		$count_airticket_encash = $this->Employees_model->count_employee_airticket_encash_payslip($payment[0]->payslip_id);
		$airticket_encash = $this->Employees_model->get_employee_airticket_encash_payslip($payment[0]->payslip_id);
		$airticket_encash_amt = $airticket_encash[0]->airticket_encashment;
		// loan
		$count_loan = $this->Employees_model->count_employee_deductions_payslip($payment[0]->payslip_id);
		$loan = $this->Employees_model->set_employee_deductions_payslip($payment[0]->payslip_id);
		// indemnity
		/*$count_emp_indemnity = $this->Employees_model->count_employee_indeminity_payslip($payment[0]->payslip_id);
		$emp_indemnity = $this->Employees_model->set_employee_indeminity_payslip($payment[0]->payslip_id);*/
		//
		// leave encashment
		$count_leave_encashment = $this->Employees_model->count_employee_leave_encashment_payslip($payment[0]->payslip_id);
		$leave_encashment_det = $this->Employees_model->set_employee_leave_encashment_payslip($payment[0]->payslip_id);
		//

		$statutory_deduction_amount = 0;
		$loan_de_amount = 0;
		$emp_indemnity_amount = 0;
		$emp_leave_encash_amount = 0;
		$allowance_amount = 0;
		$deallowance_amount = 0;
		$add_deduction_allowance = 0;
		$commissions_amount = 0;
		$decommissions_amount = 0;
		$add_deduct_commissions_amount = 0;
		$other_payments_amount = 0;
		$deother_payments_amount = 0;
		$add_deduct_other_payments_amount = 0;
		$overtime_amount = 0;

		$tbl = '<br><br>
		<table cellpadding="1" cellspacing="1" border="0">
			<tr>
				<td align="center"><h1>' . $this->lang->line('xin_payslip') . '</h1></td>
			</tr>
			<tr>
				<td align="center">' . $this->lang->line('xin_payroll_year_date') . ': ' . $half_title . ' <strong>' . date("F Y", strtotime($payment[0]->salary_month)) . '</strong></td>
			</tr>
		</table>
		';
		$pdf->writeHTML($tbl, true, false, false, false, '');
		// -----------------------------------------------------------------------------
		// set cell padding
		$pdf->setCellPaddings(1, 1, 1, 1);

		// set cell margins
		$pdf->setCellMargins(0, 0, 0, 0);

		// set color for background
		$pdf->SetFillColor(255, 255, 127);
		// set some text for example
		//$txt = 'Employee Details';
		// Multicell
		//$pdf->MultiCell(180, 6, $txt, 0, 'L', 11, 0, '', '', true);
		//$pdf->Ln(7);
		$tbl1 = '
		<table cellpadding="3" cellspacing="0" border="1">
			<tr bgcolor="#69e48a">
			<td colspan="4" align="center"><strong>Employee Details</strong></td>
			</tr>
			<tr>
				<td>' . $this->lang->line('xin_name') . '</td>
				<td>' . $fname . '</td>
				<td>' . $this->lang->line('dashboard_employee_id') . '</td>
				<td>' . $user[0]->employee_id . '</td>
			</tr>
			<tr>
				<td>' . $this->lang->line('left_department') . '</td>
				<td>' . $_department_name . '</td>
				<td>' . $this->lang->line('left_designation') . '</td>
				<td>' . $_designation_name . '</td>
			</tr>';
		//shift info
		$office_shift = $this->Timesheet_model->read_office_shift_information($user[0]->office_shift_id);
		if (!is_null($office_shift)) {
			$shift = $office_shift[0]->shift_name;
		} else {
			$shift = '--';
		}
		if ($payment[0]->payslip_type == 'hourly') {
			$hcount = $payment[0]->hours_worked;
			$tbl1 .= '<tr>
				<td>' . $this->lang->line('xin_employee_doj') . '</td>
				<td>' . $date_of_joining . '</td>
				<td>' . $this->lang->line('xin_payroll_hours_worked_total') . '</td>
				<td>' . $hcount . '</td>
			</tr>';
		} else {
			$date = strtotime($payment[0]->salary_month);
			$day = date('d', $date);
			$month = date('m', $date);
			$year = date('Y', $date);
			// total days in month
			$daysInMonth = date('t', strtotime($payment[0]->salary_month . '-01')); //$daysInMonth =  date('t');
			$imonth = date('F', $date);
			$r = $this->Xin_model->read_user_info($user[0]->user_id);
			$pcount = 0;
			$acount = 0;
			$lcount = 0;
			for ($i = 1; $i <= $daysInMonth; $i++) :
				$i = str_pad($i, 2, 0, STR_PAD_LEFT);
				// get date <
				$attendance_date = $year . '-' . $month . '-' . $i;
				$get_day = strtotime($attendance_date);
				$day = date('l', $get_day);
				$user_id = $r[0]->user_id;
				$office_shift_id = $r[0]->office_shift_id;
				$attendance_status = '';
				// get holiday
				$h_date_chck = $this->Timesheet_model->holiday_date_check($attendance_date);
				$holiday_arr = array();
				if ($h_date_chck->num_rows() == 1) {
					$h_date = $this->Timesheet_model->holiday_date($attendance_date);
					$begin = new DateTime($h_date[0]->start_date);
					$end = new DateTime($h_date[0]->end_date);
					$end = $end->modify('+1 day');

					$interval = new DateInterval('P1D');
					$daterange = new DatePeriod($begin, $interval, $end);

					foreach ($daterange as $date) {
						$holiday_arr[] = $date->format("Y-m-d");
					}
				} else {
					$holiday_arr[] = '99-99-99';
				}
				// get leave/employee
				$leave_date_chck = $this->Timesheet_model->leave_date_check($user_id, $attendance_date);
				$leave_arr = array();
				if ($leave_date_chck->num_rows() == 1) {
					$leave_date = $this->Timesheet_model->leave_date($user_id, $attendance_date);
					$begin1 = new DateTime($leave_date[0]->from_date);
					$end1 = new DateTime($leave_date[0]->to_date);
					$end1 = $end1->modify('+1 day');

					$interval1 = new DateInterval('P1D');
					$daterange1 = new DatePeriod($begin1, $interval1, $end1);

					foreach ($daterange1 as $date1) {
						$leave_arr[] = $date1->format("Y-m-d");
					}
				} else {
					$leave_arr[] = '99-99-99';
				}
				$office_shift = $this->Timesheet_model->read_office_shift_information($office_shift_id);
				$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
				// get holiday>events
				if (!empty($office_shift)) {
				if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if (in_array($attendance_date, $holiday_arr)) { // holiday
					$status = 'H';
					$pcount += 0;
					//$lcount += 0;
				} else if (in_array($attendance_date, $leave_arr)) { // on leave
					$status = 'L';
					$pcount += 0;
					//$lcount += 1;
					//	$acount += 0;
				} else if ($check->num_rows() > 0) {
					$pcount += 1;
					//$lcount += 0;
				} else {
					$status = 'A';
					//	$lcount += 0;
					$pcount += 0;
					// set to present date
					$iattendance_date = strtotime($attendance_date);
					$icurrent_date = strtotime(date('Y-m-d'));
					if ($iattendance_date <= $icurrent_date) {
						$acount += 1;
					} else {
						$acount += 0;
					}
				}
				}

			endfor;
			//new leave calc
			$month_year = $payment[0]->salary_month;
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leaves = $this->Employees_model->emp_leave_fetch($user[0]->user_id, $start_date_y);

			$user_id = $user[0]->user_id;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}
			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_finals = $final_amounts = 0;
			//$month_year_end = date("Y-m-t", strtotime("$month_year-02"));
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = 0;
			if ($emp_leaves) {
				foreach ($emp_leaves as $emp_leave) {
					$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id, $start_date_y_m, $emp_leave->leave_type_id);

					$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
								WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . date('Y-m-d H:i:s', strtotime($month_year_end)) . "'";

					$binds = array($emp_leave->employee_id);
					$query = $this->db->query($sql, $binds);
					$tmp = $query->result();
					$leaves_in_year_org = $tmp[0]->total_days;
					$leaves_in_year = $leaves_in_year_org - $emp_leave_in_month;
					$joining_date = $this->Timesheet_model->joining_date($emp_leave->employee_id);
					$leave_halfday_cal = employee_leave_halfday_cal($emp_leave->leave_type_id, $user_id);
					foreach ($leave_halfday_cal as $lhalfday) :
						$hlfcount += 0.5;
					endforeach;
					$count_l = count_leaves_info($emp_leave->leave_type_id, $user_id);
					$count_l = $count_l - $hlfcount;
					$total_days_per_year = $emp_leave->days_per_year;
					$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($emp_leave->leave_type_id, $user_id);
					$count = $xin_leave_type[0]->leave_count;
					$leave_remaining_total = $total_days_per_year - $count_l;
					if ($count > $total_days_per_year) {
						$extra = $count - $total_days_per_year;
					} else {
						$extra = 0;
					}
					if (abs($leave_remaining_total) == 0) {
						$remain = 0;
						$extra_leave = 0;
					} elseif (abs($leave_remaining_total) < $count_l) {
						$remain = 0;
						$extra_leave = $extra;
					} else {
						$remain = $leave_remaining_total;
						$extra_leave = 0;
						$extra_amount = 0;
						if ($emp_leave->leave_type_id == 5) {
							$d1 = strtotime(date('Y-m-d'));
							$d2 = strtotime($joining_date[0]->date_of_joining);
							$totalSecondsDiff = abs($d1 - $d2);
							$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

							if ($totalMonthsDiff <= 12) {
								$extra_leave = $leave_remaining_total;
							}
						}
					}

					//  print_r($count_l);
					//  print_r($extra_leave);
					$date = date($emp_leave->from_date);
					$date1 = date_create($date);
					$date2 = date_create($emp_leave->to_date);
					$diff = date_diff($date1, $date2);
					$day_diff = $diff->format("%a") + 1;

					$date1 = strtotime($joining_date[0]->date_of_joining);
					$date2 = strtotime(date('Y-m-d'));
					$diff = abs($date2 - $date1);
					$years = floor($diff / (365 * 60 * 60 * 24));
					$extra_amount = $daysInMonth;

					$d1 = strtotime(date('Y-m-d'));
					$d2 = strtotime($joining_date[0]->date_of_joining);
					$totalSecondsDiff = abs($d1 - $d2);
					$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

					if ($extra_leave < 0 || $extra_leave == 0) {
						$extra_in_month = 0;
					} elseif ($extra_leave > 0 || $extra_leave != 0) {
						if ($emp_leave_in_month != '' || $emp_leave_in_month != 0) {
							$in_month = $emp_leave_in_month - $extra_leave;
							$extra_amount = $emp_leave_in_month - $in_month;
							if ($emp_leave->leave_type_id == 8) {
								//Haj leave
								if ($joining_date[0]->ethnicity_type == 2) {
									if ($years <= 5) {
										$extra_amount = $daysInMonth - $count;
										$extra_leave = $count;
									} else {
										if ($count > $emp_leave->days_per_year) {
											$val = $count - $emp_leave->days_per_year;
											$extra_amount = $daysInMonth - $val;
										} else {
											$extra_amount = $daysInMonth;
										}
									}
								}
							} else if ($emp_leave->leave_type_id == 5) {
								//Maternity Leave
								if ($totalMonthsDiff <= 12) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else if ($emp_leave->leave_type_id == 4) {
								//Sick Leave
								if ($totalMonthsDiff < 3) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										if ($val <= 20) {
											$val = $val / 2;
										} else {
											$val = $val;
										}
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else if ($emp_leave->leave_type_id == 3) {
								//Annuval Leave
								if ($totalMonthsDiff < 3) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else if ($emp_leave->leave_type_id == 6) {
								//Marriage Leave
								if ($totalMonthsDiff < 3) {
									$extra_amount = $daysInMonth - $count;
									$extra_leave = $count;
								} else {
									if ($count > $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$extra_amount = $daysInMonth - $val;
									} else {
										$extra_amount = $daysInMonth;
									}
								}
							} else {
								if ($count > $emp_leave->days_per_year) {
									$val = $count - $emp_leave->days_per_year;
									$extra_amount = $daysInMonth - $val;
								} else {
									$extra_amount = $daysInMonth;
								}
							}
						}
					}
					$total_net_salary = $payment[0]->net_salary;
					if ($extra_amount != 0) {
						$total_finals = ($total_net_salary / $daysInMonth) * $extra_amount;
					}


					$total_finals += $final_amounts;
					$original_leave_count = 0;
					if ($xin_leave_type[0]->leave_count > $daysInMonth) {
						$date = date($emp_leave->from_date);
						$month_frm_date = date('m', strtotime($date));
						if ($month_frm_date == date('m', strtotime(date("Y-m-d")))) {
							$date = date($emp_leave->from_date);
							$date1 = date_create($date);
							$date2 = date_create(date("Y-m-d", strtotime("$month_year-$daysInMonth")));
							$diff = date_diff($date1, $date2);
						} else {
							$date = date($emp_leave->to_date);
							$date1 = date_create($date);
							$date2 = date_create(date("Y-m-d", strtotime("$month_year-01")));
							$diff = date_diff($date1, $date2);
						}
						$day_diff = $diff->format("%a") + 1;
						$original_leave_count = $day_diff;
						$current_monthleave = $original_leave_count;
						if ($emp_leave->leave_type_id == 5) {
							//Maternity Leave
							$d1 = strtotime(date('Y-m-d'));
							$d2 = strtotime($joining_date[0]->date_of_joining);
							$totalSecondsDiff = abs($d1 - $d2);
							$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

							if ($totalMonthsDiff <= 12) {
								$tot_days += $original_leave_count;
							} else {
								$tot_days += $extra_leave;
							}
						}
					} else {
						$date = date($emp_leave->from_date);
						$month_frm_date = date('m', strtotime($date));
						$month_to_dte = date('m', strtotime($emp_leave->to_date));
						$today_month = date('m', strtotime(date("Y-m-d")));
						if ($month_frm_date != $today_month || $month_to_dte != $today_month) {

							if ($month_frm_date == $today_month) {
								$date = date($emp_leave->from_date);
								$date1 = date_create($date);
								$date2 = date_create(date("Y-m-d", strtotime("$month_year-$daysInMonth")));
								$diff = date_diff($date1, $date2);
							} else {
								$date = date($emp_leave->to_date);
								$date1 = date_create($date);
								$date2 = date_create(date("Y-m-d", strtotime("$month_year-01")));
								$diff = date_diff($date1, $date2);
							}
							$day_diff = $diff->format("%a") + 1;
							$current_monthleave = $day_diff;
							$original_leave_count = $xin_leave_type[0]->leave_count;

							if ($today_month == $month_to_dte) {
								$tot_days += 0;
							} else {
								$tot_days += $extra_leave;
							}
						} else {
							if ($emp_leave->leave_type_id == 8) {
								//Haj leave
								if ($joining_date[0]->ethnicity_type == 2) {
									if ($years <= 5) {
										$extra_amount = $daysInMonth - $count;
										$tot_days = $count;
									} else {
										if ($count >= $emp_leave->days_per_year) {
											$val = $count - $emp_leave->days_per_year;
											$tot_days += $val;
										} else {
											$tot_days += $daysInMonth;
										}
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
							} else if ($emp_leave->leave_type_id == 4) {
								//Sick Leave
								if ($totalMonthsDiff < 3) {
									$tot_days += $count;
								} else {
									if ($count >= $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										if ($val <= 20) {
											$val = $val / 2;
										} else {
											$val = $val;
										}
										$tot_days += $val;
									} else {
										$tot_days += $daysInMonth;
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
								//$original_leave_count = $xin_leave_type[0]->leave_count ;
							} else if ($emp_leave->leave_type_id == 3) {
								//Annuval Leave
								if ($totalMonthsDiff < 3) {
									$tot_days += $count;
								} else {
									if ($count >= $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$tot_days += $val;
									} else {
										$tot_days += $daysInMonth;
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
							} else if ($emp_leave->leave_type_id == 6) {
								//Marriage Leave
								if ($totalMonthsDiff < 3) {
									$tot_days += $count;
								} else {
									if ($count >= $emp_leave->days_per_year) {
										$val = $count - $emp_leave->days_per_year;
										$tot_days += $val;
									} else {
										$tot_days += $daysInMonth;
									}
								}
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
							} else if ($emp_leave->leave_type_id == 5) {
								//Maternity Leave
								$d1 = strtotime(date('Y-m-d'));
								$d2 = strtotime($joining_date[0]->date_of_joining);
								$totalSecondsDiff = abs($d1 - $d2);
								$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;
								$original_leave_count = $xin_leave_type[0]->leave_count;
								$current_monthleave = $original_leave_count;
								if ($totalMonthsDiff <= 12) {
									$tot_days += $original_leave_count;
								} else {
									$tot_days += $extra_leave;
								}
							} else if ($emp_leave->leave_type_id == 7) {
								//Unpaid Leave
								$tot_days += $xin_leave_type[0]->leave_count;
								$current_monthleave = $xin_leave_type[0]->leave_count;
								$original_leave_count = $xin_leave_type[0]->leave_count;
							} else {
								$tot_days += $extra_leave;
								$current_monthleave = $xin_leave_type[0]->leave_count;
								$original_leave_count = $xin_leave_type[0]->leave_count;
							}
						}
					}
				}
			}
			//end new calc


			//Using attendance
			$emp_more_det = $this->Employees_model->read_emp($user_id);
			$st = '';
			$p_count_val = 0;
			$start_date_co = $year . '-' . $month . '-' . '1';
			$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
			$off_day_arr = array();
			$holiday_arr = array();
			$office_shift = $this->Timesheet_model->read_office_shift_information($emp_more_det[0]->office_shift_id);
			if (!is_null($office_shift)) {
				$start_date_co = $year . '-' . $month . '-' . '01';
				$end_date_co = $year . '-' . $month . '-' . $daysInMonth;
				$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $emp_more_det[0]->company_id);
				if ($h_date_chck->num_rows() > 0) {
					$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $emp_more_det[0]->company_id);
					foreach ($h_date as $val) {
						$begin = new DateTime($val->start_date);
						$end = new DateTime($val->end_date);
						$end = $end->modify('+1 day');

						$interval = new DateInterval('P1D');
						$daterange = new DatePeriod($begin, $interval, $end);

						foreach ($daterange as $date) {
							$holiday_arr[] = $date->format("Y-m-d");
						}
					}
					$p_count_val += count($holiday_arr);
				}
			}
			if ($office_shift) {
				if ($office_shift[0]->monday_in_time == '') {
					$off_day_arr[] = 'Mon';
				}
				if ($office_shift[0]->tuesday_in_time == '') {
					$off_day_arr[] = 'Tue';
				}
				if ($office_shift[0]->wednesday_in_time == '') {
					$off_day_arr[] = 'Wed';
				}
				if ($office_shift[0]->thursday_in_time == '') {
					$off_day_arr[] = 'Thu';
				}
				if ($office_shift[0]->friday_in_time == '') {
					$off_day_arr[] = 'Fri';
				}
				if ($office_shift[0]->saturday_in_time == '') {
					$off_day_arr[] = 'Sat';
				}
				if ($office_shift[0]->sunday_in_time == '') {
					$off_day_arr[] = 'Sun';
				}
				$p_count_val += $this->Timesheet_model->calculateSatuSundDaysInMonth($year, $month, $off_day_arr);
			}


			$leave_arr = array();
			$half_leave_arr = array();
			$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
			if ($leave_date_chck->num_rows() > 0) {
				$leave_date = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
				foreach ($leave_date as $leave_dates) {
					$begin1 = new DateTime($leave_dates->from_date);
					$end1 = new DateTime($leave_dates->to_date);
					$end1 = $end1->modify('+1 day');
					$half_day_check = $leave_dates->is_half_day;
					$interval1 = new DateInterval('P1D');
					$daterange1 = new DatePeriod($begin1, $interval1, $end1);

					foreach ($daterange1 as $date1) {
						if ($half_day_check == 1) {
							$half_leave_arr[] = $date1->format("Y-m-d");
						} else {
							$leave_arr[] = $date1->format("Y-m-d");
						}
					}
				}
			}
			//$st = $this->db->last_query();
			$present_arr = array();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			for ($i = 1; $i <= $daysInMonth; $i++) :
				$i = str_pad($i, 2, 0, STR_PAD_LEFT);
				// get date <
				$eattendance_date = $year . '-' . $month . '-' . $i;
				$check = $this->Timesheet_model->attendance_first_in_check($user_id, $eattendance_date);
				if ($check->num_rows() > 0) {
					//$p_count_val += $check->num_rows();
					foreach ($check->result() as $checkss) {
						if (!in_array($checkss->attendance_date, $leave_arr)) {
							$present_arr[] = $checkss->attendance_date;
							$p_count_val += 1;
						}
					}
				} else {
					$p_count_val += 0;
				}

			endfor;
			//$p_count_val = $tot_days;
			//End attendance based

			$tbl1 .= '<tr>
				<td>' . $this->lang->line('xin_employee_doj') . '</td>
				<td>' . $date_of_joining . '</td>
				<td>' . $this->lang->line('xin_timesheet_workdays') . '</td>
				<td>' . $payment[0]->monthy_present_days . '</td>
			</tr>';
		}
		$total_leave = $this->Xin_model->total_leave_payslip($payment[0]->salary_month, $user_id);
		$tbl1 .= '<tr>
				<td>' . $this->lang->line('left_office_shift') . '</td>
				<td>' . $shift . '</td>
				<td>' . $this->lang->line('xin_attendance_total_leave') . '</td>
				<td>' . $total_leave . '</td>
			</tr>';
		$bank_account_no = $this->Employees_model->get_employee_bank_account_last_first($user_id);
		if (isset($bank_account_no[0]->bank_name)) {
			$bank_name = $bank_account_no[0]->bank_name;
		} else {
			$bank_name = '----';
		}
		if (isset($bank_account_no[0]->account_number)) {
			$bank_ac_nu = $bank_account_no[0]->account_number;
		} else {
			$bank_ac_nu = '----';
		}
		$tbl1 .= '<tr>
				<td>Bank Account Number</td>
				<td>' . $bank_ac_nu . '</td>
				<td>Bank Name</td>
				<td>' . $bank_name . '</td>
			</tr>';
		$tbl1 .= '</table>';

		$pdf->writeHTML($tbl1, true, false, true, false, '');

		$count_leave = $this->Xin_model->count_total_leave_payslip($payment[0]->salary_month, $user_id);
		if ($count_leave > 0) {
			$tbl1_lv = '
			<table cellpadding="3" cellspacing="0" border="1">
				<tr bgcolor="#69e48a">
				<td colspan="4" align="center"><strong>Leave Details</strong></td>
				</tr>
				<tr bgcolor="#69e48a">
				<td>' . $this->lang->line('xin_leave_type') . '</td>
				<td>' . $this->lang->line('xin_title_from') . '</td>
				<td>' . $this->lang->line('xin_title_to') . '</td>
				<td>' . $this->lang->line('xin_hrsale_total_days') . '</td>
				</tr>';
			$res_leave = $this->Xin_model->res_total_leave_payslip($payment[0]->salary_month, $user_id);
			foreach ($res_leave as $rleave) {
				// get leave type
				$leave_type = $this->Timesheet_model->read_leave_type_information($rleave->leave_type_id);
				if (!is_null($leave_type)) {
					$type_name = $leave_type[0]->type_name;
				} else {
					$type_name = '--';
				}
				$datetime1 = new DateTime($rleave->from_date);
				$datetime2 = new DateTime($rleave->to_date);
				$interval = $datetime1->diff($datetime2);
				if (strtotime($rleave->from_date) == strtotime($rleave->to_date)) {
					$no_of_days = 1;
				} else {
					$no_of_days = $interval->format('%a') + 1;
				}
				if ($rleave->is_half_day == 1) {
					$tbl1_lv .= '<tr>
						<td>' . $type_name . '</td>
						<td>' . $rleave->from_date . '</td>
						<td>' . $rleave->to_date . '</td>
						<td>' . $this->lang->line('xin_hr_leave_half_day') . '</td>
					</tr>';
				} else {
					$tbl1_lv .= '<tr>
						<td>' . $type_name . '</td>
						<td>' . $rleave->from_date . '</td>
						<td>' . $rleave->to_date . '</td>
						<td>' . $no_of_days . '</td>
					</tr>';
				}
			}
			// Annual Leave
			$count_annual_leave = $this->Employees_model->count_employee_annual_leave_payslip($payment[0]->payslip_id);
			$leave_annual_det = $this->Employees_model->set_employee_leave_annual_payslip($payment[0]->payslip_id);
			if ($count_annual_leave > 0) {
				foreach ($leave_annual_det->result() as $val) {
					$tbl1_lv .= '<tr>
						<td>Annual Leave</td>
						<td>' . $val->from_date . '</td>
						<td>' . $val->to_date . '</td>
						<td>' . $val->days . '</td>
					</tr>';
				}
			}
			//


			$tbl1_lv .= '</table>';
			$pdf->writeHTML($tbl1_lv, true, false, true, false, '');
		}
		//// break..
		$pdf->Ln(7);
		$tblbrk = '<table cellpadding="3" cellspacing="0" border="1"><tr bgcolor="#69e48a">
				<td colspan="2" align="center"><strong>' . $this->lang->line('xin_description') . '</strong></td>
				<td align="center"><strong>' . $this->lang->line('xin_payslip_earning') . '</strong></td>	
				<td align="center"><strong>' . $this->lang->line('xin_deductions') . '</strong></td>			
			</tr>';
		if ($payment[0]->payslip_type != 'hourly') {
			$tblbrk .= '<tr>
					<td colspan="2">' . $this->lang->line('xin_payroll_basic_salary') . '</td>
					<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($bs,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>				
				</tr>';
		} else {
			$itotal_count = $hcount * $bs;
			$tblbrk .= '<tr>
					<td colspan="2">' . $this->lang->line('xin_payroll_hourly_rate') . ' x ' . $this->lang->line('xin_payroll_hours_worked_total') . '<br> ' . $this->Xin_model->company_currency_sign($bs,$user[0]->company_id) . ' x ' . $hcount . '</td>
					<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($itotal_count,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>				
				</tr>';
		}

		if ($payment[0]->leave_deduction > 0) {
			$tblbrk .= '<tr>
					<td colspan="2">Leave Deduction</td>
					<td>&nbsp;</td>		
					<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($payment[0]->leave_deduction,$user[0]->company_id) . '</td>	
							
				</tr>';
		}
		if ($payment[0]->total_outstanding > 0) {
			$tblbrk .= '<tr>
					<td colspan="2">Total Outstanding Amount</td>
					<td>&nbsp;</td>		
					<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($payment[0]->total_outstanding,$user[0]->company_id) . '</td>	
							
				</tr>';
		}
		if ($payment[0]->asset_complaint_amt > 0) {
			$tblbrk .= '<tr>
					<td colspan="2">Asset Compliant Amount</td>
					<td>&nbsp;</td>		
					<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($payment[0]->asset_complaint_amt,$user[0]->company_id) . '</td>	
							
				</tr>';
		}
		if ($payment[0]->annual_leave_amt) {
			$tblbrk .= '<tr>
					<td colspan="2">Annual leave</td>						
					<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($payment[0]->annual_leave_amt,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>			
				</tr>';
		}
		//allowances
		if ($count_allowances > 0) {
			foreach ($allowances->result() as $sl_allowances) {
				if ($sl_allowances->amount_option == 0) {
					$allowance_amount_opt = $this->lang->line('xin_title_tax_fixed');
				} else {
					$allowance_amount_opt = $this->lang->line('xin_title_tax_percent');
				}
				if ($sl_allowances->is_allowance_taxable == 0) {
					$allowance_opt = $this->lang->line('xin_salary_allowance_non_taxable');
				} else if ($sl_allowances->is_allowance_taxable == 1) {
					$allowance_opt = $this->lang->line('xin_fully_taxable');
				} else {
					$allowance_opt = $this->lang->line('xin_partially_taxable');
				}
				if ($sl_allowances->is_allowance_taxable == 1) {
					if ($sl_allowances->amount_option == 0) {
						$iallowance_amount = $sl_allowances->allowance_amount;
					} else {
						$iallowance_amount = $bs / 100 * $sl_allowances->allowance_amount;
					}
					$allowance_amount += 0;
					$deallowance_amount -= $iallowance_amount;
					$add_deduction_allowance += $iallowance_amount;
					$allo = $this->Xin_model->read_single_allowance($sl_allowances->allowance_title);
					$tblbrk .= '<tr>
					<td colspan="2"> Allowance - ' . $allo[0]->name . ' (' . $allowance_amount_opt . ') (' . $allowance_opt . ')</td>
					
					<td>&nbsp;</td>			
					<td align="center">' . $this->Xin_model->company_currency_sign($iallowance_amount,$user[0]->company_id) . '</td>		
					</tr>';
				} else if ($sl_allowances->is_allowance_taxable == 2) {
					if ($sl_allowances->amount_option == 0) {
						$iallowance_amount = $sl_allowances->allowance_amount / 2;
					} else {
						$iallowance_amount = ($bs / 100) / 2 * $sl_allowances->allowance_amount;
					}
					$allowance_amount += 0;
					$deallowance_amount -= $iallowance_amount;
					$add_deduction_allowance += $iallowance_amount;
					$allo = $this->Xin_model->read_single_allowance($sl_allowances->allowance_title);
					$tblbrk .= '<tr>
					<td colspan="2"> Allowance - ' . $allo[0]->name . ' (' . $allowance_amount_opt . ') (' . $allowance_opt . ')</td>
					
					<td>&nbsp;</td>			
					<td align="center">' . $this->Xin_model->company_currency_sign($iallowance_amount,$user[0]->company_id) . '</td>		
					</tr>';
				} else {
					if ($sl_allowances->amount_option == 0) {
						$iallowance_amount = $sl_allowances->allowance_amount;
					} else {
						$iallowance_amount = $bs / 100 * $sl_allowances->allowance_amount;
					}
					$allowance_amount += $iallowance_amount;
					$deallowance_amount += 0;
					$add_deduction_allowance += 0;
					$allo = $this->Xin_model->read_single_allowance($sl_allowances->allowance_title);
					$tblbrk .= '<tr>
					<td colspan="2">Allowance - ' . $allo[0]->name . ' (' . $allowance_amount_opt . ') (' . $allowance_opt . ')</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($iallowance_amount,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>				
					</tr>';
				}
			}
		}


		//commissions
		if ($count_commissions > 0) {
			foreach ($commissions->result() as $sl_commissions) {
				if ($sl_commissions->amount_option == 0) {
					$commission_amount_opt = $this->lang->line('xin_title_tax_fixed');
				} else {
					$commission_amount_opt = $this->lang->line('xin_title_tax_percent');
				}
				if ($sl_commissions->is_commission_taxable == 0) {
					$commission_opt = $this->lang->line('xin_salary_allowance_non_taxable');
				} else if ($sl_commissions->is_commission_taxable == 1) {
					$commission_opt = $this->lang->line('xin_fully_taxable');
				} else {
					$commission_opt = $this->lang->line('xin_partially_taxable');
				}
				if ($sl_commissions->is_commission_taxable == 1) {
					if ($sl_commissions->amount_option == 0) {
						$ecommissions_amount = $sl_commissions->commission_amount;
					} else {
						$ecommissions_amount = $bs / 100 * $sl_commissions->commission_amount;
					}
					$commissions_amount += 0;
					$decommissions_amount -= $ecommissions_amount;
					$add_deduct_commissions_amount += $ecommissions_amount;
					$allo = $this->Xin_model->read_single_allowance($sl_commissions->commission_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' (' . $commission_amount_opt . ') (' . $commission_opt . ')</td>
					<td>&nbsp;</td>				
					<td align="center">' . $this->Xin_model->company_currency_sign($ecommissions_amount,$user[0]->company_id) . '</td>
					</tr>';
				} else if ($sl_commissions->is_commission_taxable == 2) {
					if ($sl_commissions->amount_option == 0) {
						$ecommissions_amount = $sl_commissions->commission_amount / 2;
					} else {
						$ecommissions_amount = ($bs / 100) / 2 * $sl_commissions->commission_amount;
					}
					$commissions_amount += 0;
					$decommissions_amount -= $ecommissions_amount;
					$add_deduct_commissions_amount += $ecommissions_amount;
					$allo = $this->Xin_model->read_single_allowance($sl_commissions->commission_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' (' . $commission_amount_opt . ') (' . $commission_opt . ')</td>	
					<td>&nbsp;</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($ecommissions_amount,$user[0]->company_id) . '</td>
					</tr>';
				} else {
					if ($sl_commissions->amount_option == 0) {
						$ecommissions_amount = $sl_commissions->commission_amount;
					} else {
						$ecommissions_amount = $bs / 100 * $sl_commissions->commission_amount;
					}
					$commissions_amount += $ecommissions_amount;
					$decommissions_amount += 0;
					$add_deduct_commissions_amount += 0;
					$allo = $this->Xin_model->read_single_allowance($sl_commissions->commission_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' (' . $commission_amount_opt . ') (' . $commission_opt . ')</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($ecommissions_amount,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>				
					</tr>';
				}
			}
		}
		//other_payments
		if ($count_other_payments > 0) {
			foreach ($other_payments->result() as $sl_other_payments) {
				if ($sl_other_payments->amount_option == 0) {
					$other_amount_opt = $this->lang->line('xin_title_tax_fixed');
				} else {
					$other_amount_opt = $this->lang->line('xin_title_tax_percent');
				}
				if ($sl_other_payments->is_otherpayment_taxable == 0) {
					$other_opt = $this->lang->line('xin_salary_allowance_non_taxable');
				} else if ($sl_other_payments->is_otherpayment_taxable == 1) {
					$other_opt = $this->lang->line('xin_fully_taxable');
				} else {
					$other_opt = $this->lang->line('xin_partially_taxable');
				}
				if ($sl_other_payments->is_otherpayment_taxable == 1) {
					if ($sl_other_payments->amount_option == 0) {
						$epayments_amount = $sl_other_payments->payments_amount;
					} else {
						$epayments_amount = $bs / 100 * $sl_other_payments->payments_amount;
					}
					$deother_payments_amount -= $epayments_amount;
					$other_payments_amount += 0;
					$add_deduct_other_payments_amount += $epayments_amount;
					$allo = $this->Xin_model->read_single_allowance($sl_other_payments->payments_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' (' . $other_amount_opt . ') (' . $other_opt . ')</td>	
					<td>&nbsp;</td>				
					<td align="center">' . $this->Xin_model->company_currency_sign($epayments_amount,$user[0]->company_id) . '</td>
					</tr>';
				} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
					if ($sl_other_payments->amount_option == 0) {
						$epayments_amount = $sl_other_payments->payments_amount / 2;
					} else {
						$epayments_amount = ($bs / 100) / 2 * $sl_other_payments->payments_amount;
					}
					$deother_payments_amount -= $epayments_amount;
					$other_payments_amount += 0;
					$add_deduct_other_payments_amount += $epayments_amount;
					$allo = $this->Xin_model->read_single_allowance($sl_other_payments->payments_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' (' . $other_amount_opt . ') (' . $other_opt . ')</td>
					<td>&nbsp;</td>	
					<td align="center">' . $this->Xin_model->company_currency_sign($epayments_amount,$user[0]->company_id) . '</td>			
					</tr>';
				} else {
					if ($sl_other_payments->amount_option == 0) {
						$epayments_amount = $sl_other_payments->payments_amount;
					} else {
						$epayments_amount = $bs / 100 * $sl_other_payments->payments_amount;
					}
					$other_payments_amount += $epayments_amount;
					$deother_payments_amount += 0;
					$add_deduct_other_payments_amount += 0;
					$allo = $this->Xin_model->read_single_allowance($sl_other_payments->payments_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' (' . $other_amount_opt . ') (' . $other_opt . ')</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($epayments_amount,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>				
					</tr>';
				}
			}
		}

		//statutory_deductions
		if ($count_statutory_deductions > 0) {
			foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
				if ($sl_statutory_deductions->deduction_title != 7) {
					if ($sl_statutory_deductions->statutory_options == 0) {
						$st_amount = $sl_statutory_deductions->deduction_amount;
					} else {
						$st_amount = $bs / 100 * $sl_statutory_deductions->deduction_amount;
					}
					$statutory_deduction_amount += $st_amount;
					if ($sl_statutory_deductions->statutory_options == 0) {
						$sd_amount_opt = $this->lang->line('xin_title_tax_fixed');
					} else {
						$sd_amount_opt = $this->lang->line('xin_title_tax_percent');
					}
					$allo = $this->Xin_model->read_constant_allowance($sl_statutory_deductions->deduction_title);
					$tblbrk .= '<tr>
					<td colspan="2">Statutory deductions - ' . $allo[0]->name . ' (' . $sd_amount_opt . ')</td>
					<td>&nbsp;</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($st_amount,$user[0]->company_id) . '</td>			
					</tr>';
				}
			}
		}
		//gosi
		$statutory_deduction_amount_gosi = 0;
		if ($count_statutory_deductions > 0) {
			foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
				if ($sl_statutory_deductions->deduction_title == 7) {
					if ($sl_statutory_deductions->statutory_options == 0) {
						$st_amount = $sl_statutory_deductions->deduction_amount;
					} else {
						// $st_amount = $bs / 100 * $sl_statutory_deductions->deduction_amount;
						$st_amount = $sl_statutory_deductions->deduction_amount;
					}
					$statutory_deduction_amount_gosi += $st_amount;
					if ($sl_statutory_deductions->statutory_options == 0) {
						$sd_amount_opt = $this->lang->line('xin_title_tax_fixed');
					} else {
						$sd_amount_opt = $this->lang->line('xin_title_tax_percent');
					}
					$allo = $this->Xin_model->read_constant_allowance($sl_statutory_deductions->deduction_title);
					$tblbrk .= '<tr>
					<td colspan="2">' . $allo[0]->name . ' - (' . $sd_amount_opt . ')</td>
					<td>&nbsp;</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($st_amount,$user[0]->company_id) . '</td>			
					</tr>';
				}
			}
		}

		//overtime
		/*if($count_overtime > 0) {
				foreach($overtime->result() as $r_overtime) {
					$overtime_total = $r_overtime->overtime_hours * $r_overtime->overtime_rate;
				$tblbrk .= '<tr>
					<td colspan="2">'.$r_overtime->overtime_title.'</td>
					<td align="center">'.$this->Xin_model->currency_sign($overtime_total).'</td>
					<td>&nbsp;</td>
					</tr>';
				}
			}*/

		//air ticket encashment
		if ($count_airticket_encash > 0) {

			$tblbrk .= '<tr>
					<td colspan="2">Air ticket Encashment</td>
					<td align="center">' . $this->Xin_model->company_currency_sign($airticket_encash_amt,$user[0]->company_id) . '</td>	
					<td>&nbsp;</td>				
					</tr>';
		}

		//loan
		$loan_de_amount = 0;
		if ($count_loan > 0) {
			foreach ($loan->result() as $r_loan) {
				$loan_de_amount += $r_loan->loan_amount;
				$tblbrk .= '<tr>
					<td colspan="2">' . $r_loan->loan_title . '</td>
					<td>&nbsp;</td>	
					<td align="center">' . $this->Xin_model->company_currency_sign($r_loan->loan_amount,$user[0]->company_id) . '</td>	
					</tr>';
			}
		}
		//Indemnity
		/*$emp_indemnity_amount = 0;
			if($count_emp_indemnity > 0) {
				foreach($emp_indemnity->result() as $sl_emp_indemnity) {
					$emp_indemnity_amount += $sl_emp_indemnity->amount;
					$tblbrk .= '<tr>
						<td colspan="2">'.$this->lang->line('xin_employee_indemnity').'( ' .$sl_emp_indemnity->year.' year - '.$sl_emp_indemnity->from_date.' to '.$sl_emp_indemnity->to_date.')</td>
						<td align="center"  valign="bottom">'.$this->Xin_model->currency_sign($sl_emp_indemnity->amount).'</td>
						<td>&nbsp;</td>
						</tr>';
				}
			}*/
		//Leave_encashment
		$emp_leave_encash_amount = 0;
		if ($count_leave_encashment > 0) {
			foreach ($leave_encashment_det->result() as $sl_emp_indemnity) {
				$emp_leave_encash_amount += $sl_emp_indemnity->amount;
				$leave_type_name = $this->Employees_model->get_leaves($sl_emp_indemnity->leave_type_id);
				$tblbrk .= '<tr>
						<td colspan="2">Leave Encashment (' . $leave_type_name[0]->type_name . '- ' . $sl_emp_indemnity->leave_start_date . ' to ' . $sl_emp_indemnity->leave_ending_date . ')</td>
						<td align="center"  valign="bottom">' . $this->Xin_model->company_currency_sign($sl_emp_indemnity->amount,$user[0]->company_id) . '</td>			
						<td>&nbsp;</td>		
						</tr>';
			}
		}
		if ($payment[0]->annual_leave_amt) {
			$annu = $payment[0]->annual_leave_amt;
		} else {
			$annu = 0;
		}

		if ($payment[0]->is_advance_salary_deduct == 1) {
			$tblbrk .= '<tr>
					<td colspan="2">' . $this->lang->line('xin_advance_deducted_salary') . '</td>
					<td>&nbsp;</td>	
					<td align="center">' . $this->Xin_model->company_currency_sign($payment[0]->advance_salary_amount,$user[0]->company_id) . '</td>	
					</tr>';
			$advance_salary_tkn = $payment[0]->advance_salary_amount;
		} else {
			$advance_salary_tkn = 0;
		}

		$tblbrk .= '<tr>
			    <td colspan="2">Expense Claim</td>
			    <td align="center">' . $this->Xin_model->company_currency_sign($payment[0]->expense_claim,$user[0]->company_id) . '</td>
			    <td></td>
			</tr>';

		if ($payment[0]->payslip_type == 'hourly') {
			$etotal_count = $hcount * $bs;
			$total_earning = $etotal_count + $allowance_amount + $overtime_amount + $commissions_amount + $other_payments_amount + $annu;
			$total_deduction = $loan_de_amount + $statutory_deduction_amount + $add_deduct_other_payments_amount + $add_deduct_commissions_amount + $add_deduction_allowance + $advance_salary_tkn;

			$total_net_salary = $total_earning - $total_deduction;
			$etotal_earning = $total_earning;
			$fsalary = $total_earning - $total_deduction;


			$tblbrk .= '
			<tr><td colspan="2" align="center"><strong>Total</strong></td>
					<td align="center"><strong>' . $this->Xin_model->company_currency_sign($etotal_earning,$user[0]->company_id) . '</strong></td>
					<td align="center"><strong>' . $this->Xin_model->company_currency_sign($total_deduction,$user[0]->company_id) . '</strong></td>	
					</tr></table>
					<table cellpadding="3" cellspacing="0" border="1">
					<tr><td colspan="2" align="center">&nbsp;</td>
					<td colspan="2" align="center" bgcolor="#69e48a"><strong>NET PAY</strong></td>
					</tr><tr><td colspan="2" align="center">' . ucwords($this->Xin_model->convertNumberToWord($fsalary)) . '</td>
					<td colspan="2" align="center"><strong>' . $this->Xin_model->company_currency_sign($fsalary,$user[0]->company_id) . '</strong></td>
					</tr></table>';
		} else {
			$getpaymentinfo = $this->Payroll_model->read_salary_payslip_info($payment[0]->payslip_id);
			$overtimeamount = $getpaymentinfo[0]->total_overtime;
			$latededuction = $getpaymentinfo[0]->total_late_deduction;
			$total_earning = $bs + $allowance_amount + $commissions_amount + $other_payments_amount + $overtimeamount + $airticket_encash_amt;
			$total_deduction = $loan_de_amount + $statutory_deduction_amount + $add_deduct_other_payments_amount + $add_deduct_commissions_amount + $add_deduction_allowance + $advance_salary_tkn + $payment[0]->leave_deduction + $latededuction;
			$total_net_salary = $total_earning - $total_deduction;
			$net_salary = ($total_net_salary / $daysInMonth) * $p_count_val;
			//$net_sal = $net_salary + $emp_indemnity_amount+$emp_leave_encash_amount + $annu + $overtime_amount;
			$net_sal = $net_salary + $emp_leave_encash_amount + $annu + $overtime_amount;
			$split_val = explode(".", $payment[0]->net_salary);
			if (count($split_val) > 1) {
				$word_amt = $this->Xin_model->wholeconvertNumberToWord($split_val[0], $split_val[1], 'Bahraini Dinars', '& Fils', 'Only');

			} else {
				$word_amt = $this->Xin_model->convertNumberToWord($payment[0]->net_salary);
				
			}
			$tblbrk .= '
			<tr><td colspan="2">Overtime Amount</td>
			<td align="center">' . $this->Xin_model->company_currency_sign($overtimeamount,$user[0]->company_id) . '</td>
			<td>&nbsp;</td>	
					</tr><tr><td colspan="2">Late Deduction</td>
					<td>&nbsp;</td>	
					<td align="center">' . $this->Xin_model->company_currency_sign($latededuction,$user[0]->company_id) . '</td>	
					</tr><tr><td colspan="2" align="center"><strong>Total</strong></td>
					<td align="center"><strong>' . $this->Xin_model->company_currency_sign($total_earning,$user[0]->company_id) . '</strong></td>
					<td align="center"><strong>' . $this->Xin_model->company_currency_sign($total_deduction,$user[0]->company_id) . '</strong></td>	
					</tr></table>
					<table cellpadding="3" cellspacing="0" border="1">
					<tr><td colspan="2" align="center">&nbsp;</td>
					<td colspan="2" align="center" bgcolor="#69e48a"><strong>NET PAY</strong></td>
				
					</tr><tr><td colspan="2" align="center">' . ucwords($word_amt) . '</td>
					<td colspan="2" align="center"><strong>' . $this->Xin_model->company_currency_sign($payment[0]->net_salary,$user[0]->company_id) . '</strong></td>
					</tr></table>';
		}
		$pdf->writeHTML($tblbrk, true, false, true, false, '');

		////////////////// end break salary..
		$tbl = '
		<table cellpadding="5" cellspacing="0" border="0">
			<tr>
				<td align="right" colspan="1">This is a computer generated slip and does not require signature.</td>
			</tr>
		</table>';
		$pdf->writeHTML($tbl, true, false, false, false, '');

		// ---------------------------------------------------------

		// Close and output PDF document
		// This method has several options, check the source code documentation for more information.
		$fname = strtolower($fname);
		$pay_month = strtolower(date("F Y", strtotime($payment[0]->year_to_date)));
		//Close and output PDF document
		ob_start();
		$pdf->Output('payslip_' . $fname . '_' . $pay_month . '.pdf', 'I');
		ob_end_flush();
	}

	public function pdf_createv2()
	{

		//$this->load->library('Pdf');
		$system = $this->Xin_model->read_setting_info(1);
		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$id = $this->uri->segment(5);
		$payment = $this->Payroll_model->read_salary_payslip_info($id);
		$user = $this->Xin_model->read_user_info($payment[0]->employee_id);

		// if password generate option enable
		if ($system[0]->is_payslip_password_generate == 1) {
			/**
			 * Protect PDF from being printed, copied or modified. In order to being viewed, the user needs
			 * to provide password as selected format in settings module.
			 */
			if ($system[0]->payslip_password_format == 'dateofbirth') {
				$password_val = date("dmY", strtotime($user[0]->date_of_birth));
			} else if ($system[0]->payslip_password_format == 'contact_no') {
				$password_val = $user[0]->contact_no;
			} else if ($system[0]->payslip_password_format == 'full_name') {
				$password_val = $user[0]->first_name . $user[0]->last_name;
			} else if ($system[0]->payslip_password_format == 'email') {
				$password_val = $user[0]->email;
			} else if ($system[0]->payslip_password_format == 'password') {
				$password_val = $user[0]->password;
			} else if ($system[0]->payslip_password_format == 'user_password') {
				$password_val = $user[0]->username . $user[0]->password;
			} else if ($system[0]->payslip_password_format == 'employee_id') {
				$password_val = $user[0]->employee_id;
			} else if ($system[0]->payslip_password_format == 'employee_id_password') {
				$password_val = $user[0]->employee_id . $user[0]->password;
			} else if ($system[0]->payslip_password_format == 'dateofbirth_name') {
				$dob = date("dmY", strtotime($user[0]->date_of_birth));
				$fname = $user[0]->first_name;
				$lname = $user[0]->last_name;
				$password_val = $dob . $fname[0] . $lname[0];
			}
			$pdf->SetProtection(array('print', 'copy', 'modify'), $password_val, $password_val, 0, null);
		}


		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($_des_name)) {
			$_designation_name = $_des_name[0]->designation_name;
		} else {
			$_designation_name = '';
		}
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$_department_name = $department[0]->department_name;
		} else {
			$_department_name = '';
		}
		//$location = $this->Xin_model->read_location_info($department[0]->location_id);
		// company info
		$company = $this->Xin_model->read_company_info($user[0]->company_id);


		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
		}
		//$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
		// set default header data
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode . ', ' . $country_name;
		$email_phone_address = "" . $this->lang->line('dashboard_email') . " : $c_info_email | " . $this->lang->line('xin_phone') . " : $c_info_phone \n" . $this->lang->line('xin_address') . ": $c_info_address";
		$header_string = $email_phone_address;
		// set document information
		$pdf->SetCreator('HRSALE');
		$pdf->SetAuthor('HRSALE');
		//$pdf->SetTitle('Workable-Zone - Payslip');
		//$pdf->SetSubject('TCPDF Tutorial');
		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
		$pdf->SetHeaderData('../../../uploads/logo/payroll/' . $system[0]->payroll_logo, 40, $company_name, $header_string);

		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

		// set header and footer fonts
		$pdf->setHeaderFont(array('helvetica', '', 11.5));
		$pdf->setFooterFont(array('helvetica', '', 9));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont('courier');

		// set margins
		$pdf->SetMargins(15, 27, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, 25);

		// set image scale factor
		$pdf->setImageScale(1.25);
		$pdf->SetAuthor('HRSALE');
		$pdf->SetTitle($company_name . ' - ' . $this->lang->line('xin_print_payslip'));
		$pdf->SetSubject($this->lang->line('xin_payslip'));
		$pdf->SetKeywords($this->lang->line('xin_payslip'));
		// set font
		$pdf->SetFont('helvetica', 'B', 10);

		// set header and footer fonts
		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// ---------------------------------------------------------

		// set default font subsetting mode
		$pdf->setFontSubsetting(true);

		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 10, '', true);

		// Add a page
		// This method has several options, check the source code documentation for more information.
		$pdf->AddPage();
		// -----------------------------------------------------------------------------
		$fname = $user[0]->first_name . ' ' . $user[0]->last_name;
		$created_at = $this->Xin_model->set_date_format($payment[0]->created_at);
		$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);
		$salary_month = $this->Xin_model->set_date_format($payment[0]->salary_month);
		// basic salary
		$bs = 0;
		if ($payment[0]->basic_salary != '') {
			$bs = $payment[0]->basic_salary;
		} else {
			$bs = $payment[0]->daily_wages;
		}
		// allowances
		$count_allowances = $this->Employees_model->count_employee_allowances_payslip($payment[0]->payslip_id);
		$allowances = $this->Employees_model->set_employee_allowances_payslip($payment[0]->payslip_id);
		// commissions
		$count_commissions = $this->Employees_model->count_employee_commissions_payslip($payment[0]->payslip_id);
		$commissions = $this->Employees_model->set_employee_commissions_payslip($payment[0]->payslip_id);
		// otherpayments
		$count_other_payments = $this->Employees_model->count_employee_other_payments_payslip($payment[0]->payslip_id);
		$other_payments = $this->Employees_model->set_employee_other_payments_payslip($payment[0]->payslip_id);
		// statutory_deductions
		$count_statutory_deductions = $this->Employees_model->count_employee_statutory_deductions_payslip($payment[0]->payslip_id);
		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_payslip($payment[0]->payslip_id);
		// overtime
		$count_overtime = $this->Employees_model->count_employee_overtime_payslip($payment[0]->payslip_id);
		$overtime = $this->Employees_model->set_employee_overtime_payslip($payment[0]->payslip_id);
		// loan
		$count_loan = $this->Employees_model->count_employee_deductions_payslip($payment[0]->payslip_id);
		$loan = $this->Employees_model->set_employee_deductions_payslip($payment[0]->payslip_id);
		//
		$statutory_deduction_amount = 0;
		$loan_de_amount = 0;
		$allowances_amount = 0;
		$commissions_amount = 0;
		$other_payments_amount = 0;
		$overtime_amount = 0;
		// laon
		if ($count_loan > 0) :
			foreach ($loan->result() as $r_loan) {
				$loan_de_amount += $r_loan->loan_amount;
			}
			$loan_de_amount = $loan_de_amount;
		else :
			$loan_de_amount = 0;
		endif;
		// allowances
		$allowances_amount = 0;
		foreach ($allowances->result() as $sl_allowances) {
			$allowances_amount += $sl_allowances->allowance_amount;
		}
		// commission
		$commissions_amount = 0;
		foreach ($commissions->result() as $sl_commissions) {
			$commissions_amount += $sl_commissions->commission_amount;
		}
		// statutory deduction
		$statutory_deduction_amount = 0;
		foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
			//$statutory_deduction_amount += $sl_statutory_deductions->deduction_amount;
			if ($system[0]->statutory_fixed != 'yes') :
				$sta_salary = $bs;
				$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
				$statutory_deduction_amount += $st_amount;
			else :
				$statutory_deduction_amount += $sl_statutory_deductions->deduction_amount;
			endif;
		}
		// other amount
		$other_payments_amount = 0;
		foreach ($other_payments->result() as $sl_other_payments) {
			$other_payments_amount += $sl_other_payments->payments_amount;
		}
		// overtime
		$overtime_amount = 0;
		foreach ($overtime->result() as $r_overtime) {
			$overtime_total = $r_overtime->overtime_hours * $r_overtime->overtime_rate;
			$overtime_amount += $overtime_total;
		}
		$tbl = '<br><br>
		<table cellpadding="1" cellspacing="1" border="0">
			<tr>
				<td align="center"><h1>' . $this->lang->line('xin_payslip') . '</h1></td>
			</tr>
			<tr>
				<td align="center"><strong>' . $this->lang->line('xin_payslip_number') . ':</strong> #' . $payment[0]->payslip_id . '</td>
			</tr>
			<tr>
				<td align="center"><strong>' . $this->lang->line('xin_salary_month') . ':</strong> ' . date("F Y", strtotime($payment[0]->year_to_date)) . '</td>
			</tr>
		</table>
		';
		$pdf->writeHTML($tbl, true, false, false, false, '');
		// -----------------------------------------------------------------------------
		// set cell padding
		$pdf->setCellPaddings(1, 1, 1, 1);

		// set cell margins
		$pdf->setCellMargins(0, 0, 0, 0);

		// set color for background
		$pdf->SetFillColor(255, 255, 127);
		// set some text for example
		$txt = 'Employee Details';
		// Multicell
		$pdf->MultiCell(180, 6, $txt, 0, 'L', 11, 0, '', '', true);
		$pdf->Ln(7);
		$tbl1 = '
		<table cellpadding="3" cellspacing="0" border="1">
			<tr>
				<td>' . $this->lang->line('xin_name') . '</td>
				<td>' . $fname . '</td>
				<td>' . $this->lang->line('dashboard_employee_id') . '</td>
				<td>' . $user[0]->employee_id . '</td>
			</tr>
			<tr>
				<td>' . $this->lang->line('left_department') . '</td>
				<td>' . $_department_name . '</td>
				<td>' . $this->lang->line('left_designation') . '</td>
				<td>' . $_designation_name . '</td>
			</tr>
			<tr>
				<td>' . $this->lang->line('xin_e_details_date') . '</td>
				<td>' . date("d F, Y") . '</td>
				<td>' . $this->lang->line('xin_payslip_number') . '</td>
				<td>' . $payment[0]->payslip_id . '</td>
			</tr>
		</table>
		';

		$pdf->writeHTML($tbl1, true, false, true, false, '');

		$total_earning = $bs + $allowances_amount + $commissions_amount + $other_payments_amount + $overtime_amount;
		$total_deductions = $loan_de_amount + $statutory_deduction_amount;
		$pdf->Ln(7);
		$tblc = '<table cellpadding="3" cellspacing="0" border="1"><tr>
				<td colspan="2">' . $this->lang->line('xin_payroll_total_earning') . '</td>
				<td colspan="2">' . $this->lang->line('xin_payroll_total_deductions') . '</td>				
			</tr>
			<tr>
				<td colspan="2">' . $this->Xin_model->company_currency_sign($total_earning,$user[0]->company_id) . '</td>
				<td colspan="2">' . $this->Xin_model->company_currency_sign($total_deductions,$user[0]->company_id) . '</td>				
			</tr>
			</table>';
		$pdf->writeHTML($tblc, true, false, true, false, '');

		if (null != $this->uri->segment(4) && $this->uri->segment(4) == 'p') {
			// -----------------------------------------------------------------------------
			$tbl2 = '';
			// -----------------------------------------------------------------------------
			$txt = 'Payslip Details';

			// Multicell test
			$pdf->MultiCell(180, 6, $txt, 0, 'L', 11, 0, '', '', true);
			$pdf->Ln(7);
			$tbl2 .= '
		<table cellpadding="3" cellspacing="0" border="1">';
			if ($payment[0]->wages_type == 1) {
				$tbl2 .= ' <tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_payroll_basic_salary') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->basic_salary,$user[0]->company_id) . '</td>
			</tr>';
			} else {
				$tbl2 .= ' <tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_employee_daily_wages') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->daily_wages,$user[0]->company_id) . '</td>
			</tr>';
			}
			if ($payment[0]->total_allowances != 0 || $payment[0]->total_allowances != '') :
				$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_payroll_total_allowance') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->total_allowances,$user[0]->company_id) . '</td>
			</tr>';
			endif;
			if ($payment[0]->total_commissions != 0 || $payment[0]->total_commissions != '') :
				$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_hr_commissions') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->total_commissions,$user[0]->company_id) . '</td>
			</tr>';
			endif;
			if ($payment[0]->total_loan != 0 || $payment[0]->total_loan != '') :
				$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_payroll_total_loan') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->total_loan,$user[0]->company_id) . '</td>
			</tr>';
			endif;
			if ($payment[0]->total_overtime != 0 || $payment[0]->total_overtime != '') :
				$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_payroll_total_overtime') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->total_overtime,$user[0]->company_id) . '</td>
			</tr>';
			endif;
			if ($payment[0]->total_statutory_deductions != 0 || $payment[0]->total_statutory_deductions != '') :
				$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_employee_set_statutory_deductions') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->total_statutory_deductions,$user[0]->company_id) . '</td>
			</tr>';
			endif;
			if ($payment[0]->total_other_payments != 0 || $payment[0]->total_other_payments != '') :
				$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_employee_set_other_payment') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign($payment[0]->total_other_payments,$user[0]->company_id) . '</td>
			</tr>';
			endif;
			/*if($payment[0]->wages_type == 1){
				$bs = $payment[0]->basic_salary;
			} else {
				$bs = $payment[0]->daily_wages;
			}*/
			$total_earning = $bs + $allowances_amount + $overtime_amount + $commissions_amount + $other_payments_amount;
			$total_deduction = $loan_de_amount + $statutory_deduction_amount;
			$total_net_salary = $total_earning - $total_deduction;
			$tbl2 .= '<tr>
				<td colspan="2">&nbsp;</td>
				<td>' . $this->lang->line('xin_payroll_net_salary') . '</td>
				<td align="right">' . $this->Xin_model->company_currency_sign((number_format($total_net_salary, 2, '.', ',')),$user[0]->company_id) . '</td>
			</tr>
		</table>
		';

			$pdf->writeHTML($tbl2, true, false, false, false, '');
		}
		$tbl = '
		<table cellpadding="5" cellspacing="0" border="0">
			<tr>
				<td align="right" colspan="1">This is a computer generated slip and does not require signature.</td>
			</tr>
		</table>';
		$pdf->writeHTML($tbl, true, false, false, false, '');

		// ---------------------------------------------------------

		// Close and output PDF document
		// This method has several options, check the source code documentation for more information.
		$fname = strtolower($fname);
		$pay_month = strtolower(date("F Y", strtotime($payment[0]->year_to_date)));
		//Close and output PDF document
		ob_start();
		$pdf->Output('payslip_' . $fname . '_' . $pay_month . '.pdf', 'I');
		ob_end_flush();
	}

	// get company > employees
	public function get_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// make payment info by id
	public function make_payment_view()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('pay_id');
		// $data['all_countries'] = $this->xin_model->get_countries();
		$result = $this->Payroll_model->read_make_payment_information($id);
		// get addd by > template
		$user = $this->Xin_model->read_user_info($result[0]->employee_id);
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$designation_name = $designation[0]->designation_name;
		} else {
			$designation_name = '--';
		}
		// department
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$department_name = $department[0]->department_name;
		} else {
			$department_name = '--';
		}

		$data = array(
			'first_name' => $user[0]->first_name,
			'last_name' => $user[0]->last_name,
			'company_id' => $user[0]->company_id,
			'employee_id' => $user[0]->employee_id,
			'department_name' => $department_name,
			'designation_name' => $designation_name,
			'date_of_joining' => $user[0]->date_of_joining,
			'profile_picture' => $user[0]->profile_picture,
			'gender' => $user[0]->gender,
			'monthly_grade_id' => $user[0]->monthly_grade_id,
			'hourly_grade_id' => $user[0]->hourly_grade_id,
			'basic_salary' => $result[0]->basic_salary,
			//'is_half_monthly' => $user[0]->is_half_monthly,
			//'half_deduct_month' => $user[0]->half_deduct_month,
			'payment_date' => $result[0]->payment_date,
			'payment_method' => $result[0]->payment_method,
			'overtime_rate' => $result[0]->overtime_rate,
			'hourly_rate' => $result[0]->hourly_rate,
			'total_hours_work' => $result[0]->total_hours_work,
			'is_payment' => $result[0]->is_payment,
			'is_advance_salary_deduct' => $result[0]->is_advance_salary_deduct,
			'advance_salary_amount' => $result[0]->advance_salary_amount,
			'house_rent_allowance' => $result[0]->house_rent_allowance,
			'medical_allowance' => $result[0]->medical_allowance,
			'travelling_allowance' => $result[0]->travelling_allowance,
			'dearness_allowance' => $result[0]->dearness_allowance,
			'provident_fund' => $result[0]->provident_fund,
			'security_deposit' => $result[0]->security_deposit,
			'tax_deduction' => $result[0]->tax_deduction,
			'gross_salary' => $result[0]->gross_salary,
			'total_allowances' => $result[0]->total_allowances,
			'total_deductions' => $result[0]->total_deductions,
			'net_salary' => $result[0]->net_salary,
			'payment_amount' => $result[0]->payment_amount,
			'comments' => $result[0]->comments,
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_payslip', $data);
		} else {
			redirect('admin/');
		}
	}

	public function payslip_delete()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$payslip_expense_claim_information = $this->Payroll_model->read_payslip_expense_claims_information($id);
		if (isset($payslip_expense_claim_information)) {
			foreach ($payslip_expense_claim_information as $payslip_expense) {
				$data = array(
					'paid' => 0,
				);
				$expense_results = $this->Payroll_model->expense_claims_update($data, $payslip_expense->expense_claim_id);
			}
		}
		$result = $this->Payroll_model->delete_record($id);
		if (isset($id)) {
			$this->Payroll_model->delete_payslip_allowances_items($id);
			$this->Payroll_model->delete_payslip_expense_claims($id);
			$this->Payroll_model->delete_payslip_commissions_items($id);
			$this->Payroll_model->delete_payslip_other_payment_items($id);
			$this->Payroll_model->delete_payslip_statutory_deductions_items($id);
			$this->Payroll_model->delete_payslip_overtime_items($id);
			$this->Payroll_model->delete_payslip_loan_items($id);
			$this->Payroll_model->delete_payslip_advance_items($id);
			$data = array('payslip_id' => '', 'status' => 1);
			$this->Payroll_model->delete_payslip_indemnity_items($data, $id);
			$data = array('payslip_id' => '', 'paid_status' => 'N');
			$this->Employees_model->delete_payslip_annual_leave($data, $id);
			$Return['result'] = $this->lang->line('xin_hr_payslip_deleted');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
	}

	public function payslip_delete_all($id)
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $id;
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->Payroll_model->delete_record($id);
		$this->Payroll_model->delete_payslip_allowances_items($id);
		$this->Payroll_model->delete_payslip_commissions_items($id);
		$this->Payroll_model->delete_payslip_other_payment_items($id);
		$this->Payroll_model->delete_payslip_statutory_deductions_items($id);
		$this->Payroll_model->delete_payslip_overtime_items($id);
		$this->Payroll_model->delete_payslip_loan_items($id);
		$this->Payroll_model->delete_payslip_advance_items($id);
	}

	// get company > locations
	public function get_company_plocations()
	{

		$data['title'] = $this->Xin_model->site_title();
		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));
		if (is_numeric($keywords[0])) {
			$id = $keywords[0];

			$data = array(
				'company_id' => $id
			);
			$session = $this->session->userdata('username');
			if (!empty($session)) {
				$data = $this->security->xss_clean($data);
				$this->load->view("admin/payroll/get_company_plocations", $data);
			} else {
				redirect('admin/');
			}
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get location > departments
	public function get_location_pdepartments()
	{

		$data['title'] = $this->Xin_model->site_title();
		$keywords = preg_split("/[\s,]+/", $this->uri->segment(4));
		if (is_numeric($keywords[0])) {
			$id = $keywords[0];

			$data = array(
				'location_id' => $id
			);
			$session = $this->session->userdata('username');
			if (!empty($session)) {
				$data = $this->security->xss_clean($data);
				$this->load->view("admin/payroll/get_location_pdepartments", $data);
			} else {
				redirect('admin/');
			}
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_department_pdesignations()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'department_id' => $id,
			'all_designations' => $this->Designation_model->all_designations(),
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/get_department_pdesignations", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// Validate and update info in database // update_status
	public function update_payroll_status()
	{

		if ($this->input->post('type') == 'update_status') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			if ($this->input->post('status') === '') {
				$Return['error'] = $this->lang->line('xin_error_template_status');
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$data = array(
				'status' => $this->input->post('status'),
			);
			$id = $this->input->post('payroll_id');
			$result = $this->Payroll_model->update_payroll_status($data, $id);
			if ($result == TRUE) {
				if ($this->input->post('status') == 1) {
					$Return['result'] = $this->lang->line('xin_role_first_level_approved');
				} else if ($this->input->post('status') == 2) {
					$Return['result'] = $this->lang->line('xin_approved_final_payroll_title');
				} else {
					$Return['result'] = $this->lang->line('xin_disabled_payroll_title');
				}
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// get company > employees > advance salary
	public function get_advance_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/get_advance_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// Validate and add info in database
	public function add_advance_salary()
	{

		if ($this->input->post('add_type') == 'advance_salary') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_id = $this->Xin_model->user_role_name($session['user_id']);
			if ($role_id == '1') {
				$company = $this->input->post('company');
				$employee_id = $this->input->post('employee_id');
			} else {
				$company = $user_info[0]->company_id;
				$employee_id = $user_info[0]->user_id;
			}
			/* Server side PHP input validation */
			if ($company === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($employee_id === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('month_year') === '') {
				$Return['error'] = $this->lang->line('xin_error_advance_salary_month_year');
			} else if ($this->input->post('amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_amount_field');
			}
			// get one time value
			if ($this->input->post('one_time_deduct') == 1) {
				$m_ins = $this->input->post('amount');
				$start_date = '';
				$end_date = '';
			} else {

				$start = new DateTime($this->input->post('start_date'));
				$start->modify('first day of this month');
				$end = new DateTime($this->input->post('end_date'));
				$end->modify('first day of next month');
				$interval = DateInterval::createFromDateString('1 month');
				$period = new DatePeriod($start, $interval, $end);
				$array_dates = array();
				foreach ($period as $dt) {
					$array_dates[] = $dt->format("Y-m");
				}
				$final_month_diff = 0;
				$tm = count($array_dates);
				if ($tm < 1) {
					$m_ins = $this->input->post('amount');
				} else {
					$m_ins = $this->input->post('amount') / $tm;
					$m_ins = round($m_ins, 3);
					$check_final_val = $m_ins * $tm;
					if ($check_final_val != $this->input->post('amount')) {
						$final_month_diff = $this->input->post('amount') - $check_final_val;
						$final_month_diff = $m_ins + $final_month_diff;
					}
				}


				//$monthly_installment = $this->input->post('monthly_installment');
				$start_date = $this->input->post('start_date');
				$end_date = $this->input->post('end_date');
				$st_date = strtotime($start_date);
				$ed_date = strtotime($end_date);
				if ($this->input->post('start_date') === '') {
					$Return['error'] = $this->lang->line('xin_error_start_date');
				} else if ($this->input->post('end_date') === '') {
					$Return['error'] = $this->lang->line('xin_error_end_date');
				} else if ($st_date > $ed_date) {
					$Return['error'] = $this->lang->line('xin_error_start_end_date');
				}
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'employee_id' => $employee_id,
				'company_id' => $company,
				'reason' => $qt_reason,
				'month_year' => $this->input->post('month_year'),
				'advance_amount' => $this->input->post('amount'),
				'monthly_installment' => $m_ins,
				'total_paid' => 0,
				'one_time_deduct' => $this->input->post('one_time_deduct'),
				'status' => 0,
				'created_at' => ($user_info[0]->user_role_id == 1 && $this->input->post('applied_on')) ? $this->input->post('applied_on') : date('Y-m-d h:i:s'),
				'start_date' => $start_date,
				'end_date' => $end_date
			);


			$result = $this->Payroll_model->add_advance_salary_payroll($data);

			if ($result) {
				if ($this->input->post('one_time_deduct') == 1) {
					$data1 = array(
						'advance_id' => $result,
						'month_year' => $this->input->post('month_year'),
						'amount' => $this->input->post('amount'),
						'employee_id' => $employee_id
					);
					$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
				} else {
					$start = new DateTime($this->input->post('start_date'));
					$start->modify('first day of this month');
					$end = new DateTime($this->input->post('end_date'));
					$end->modify('first day of next month');
					$interval = DateInterval::createFromDateString('1 month');
					$period = new DatePeriod($start, $interval, $end);
					$i = 1;
					foreach ($period as $dt) {
						if ($i == $tm && $final_month_diff > 0) {
							$m_ins = $final_month_diff;
						}
						$data1 = array(
							'advance_id' => $result,
							'month_year' => $dt->format("Y-m"),
							'amount' => $m_ins,
							'employee_id' => $employee_id
						);
						$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
					}
				}

				$Return['result'] = $this->lang->line('xin_success_request_sent_advance_salary');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// updated advance salary
	// Validate and add info in database
	public function update_advance_salary_validate()
	{

		if ($this->input->post('edit_type') == 'advance_salary') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$role_id = $this->Xin_model->user_role_name($session['user_id']);
			$company = $this->input->post('company');
			$employee_id = $this->input->post('employee_id');

			/* Server side PHP input validation */
			if ($company === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($employee_id === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('month_year') === '') {
				$Return['error'] = $this->lang->line('xin_error_advance_salary_month_year');
			} else if ($this->input->post('amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_amount_field');
			}

			if ($this->input->post('one_time_deduct_id') == 1) {
				$monthly_installment = $this->input->post('amount');
			} else {
				$monthly_installment = $this->input->post('monthly_installment');
				if ($this->input->post('final_amount_val') != $this->input->post('amount')) {
					$Return['error'] = 'The advance amount and the total amount is not equal..';
				}
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$this->output($Return);
			exit;
		}
	}

	public function update_advance_salary()
	{

		if ($this->input->post('edit_type') == 'advance_salary') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$role_id = $this->Xin_model->user_role_name($session['user_id']);
			$company = $this->input->post('company');
			$employee_id = $this->input->post('employee_id');

			/* Server side PHP input validation */
			if ($company === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($employee_id === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('month_year') === '') {
				$Return['error'] = $this->lang->line('xin_error_advance_salary_month_year');
			} else if ($this->input->post('amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_amount_field');
			}
			//print_r($this->input->post('one_time_deduct'));exit;
			// get one time value
			if ($this->input->post('one_time_deduct_id') == 1) {
				$monthly_installment = $this->input->post('amount');
			} else {
				$monthly_installment = $this->input->post('monthly_installment');
				if ($this->input->post('final_amount_val') != $this->input->post('amount')) {
					$Return['error'] = 'The advance amount and the total amount is not equal..';
				}
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$role_resources_ids = $this->Xin_model->user_role_resource();

			$first_approval = $second_approval = $third_approval = $final_approval = $status = 0;

			$first_approved_user = 0;
			$second_approved_user = 0;
			$third_approved_user = 0;
			$final_approved_user = 0;
			// 		if ($user_info[0]->user_role_id == 1) {
			//             $first_approval = $final_approval = $status = $this->input->post('status');
			// 	    } else if (in_array("513", $role_resources_ids)){
			// 	        if ($this->input->post('status') == 1) {
			// 	            $first_approval = 1;
			// 		    } else if ($this->input->post('status') == 2) {
			// 		         $first_approval = $final_approval = $status = 2;
			// 		    }
			// 	    } else if (in_array("514", $role_resources_ids)){
			//             $first_approval = $final_approval = $status = $this->input->post('status');
			// 	    }
			if (in_array("384", $role_resources_ids)) {
				if ($this->input->post('first_approval') == 1) {
					$first_approval = 1;
				} else if ($this->input->post('first_approval') == 2) {
					$first_approval = 2;
				}
			}
			if (in_array("385", $role_resources_ids)) {
				if ($this->input->post('second_approval') == 1) {
					$second_approval = 1;
				} else if ($this->input->post('second_approval') == 2) {
					$second_approval = 2;
				}
			}
			if (in_array("386", $role_resources_ids)) {
				if ($this->input->post('third_approval') == 1) {
					$third_approval = 1;
				} else if ($this->input->post('third_approval') == 2) {
					$third_approval = 2;
				}
			}
			if (in_array("387", $role_resources_ids)) {
				if ($this->input->post('final_approval') == 1) {
					// 	$final_approval = 1;
					$first_approval = $second_approval = $third_approval = $final_approval = $status = 1;
				} else if ($this->input->post('final_approval') == 2) {
					// 	$final_approval = 2;
					$first_approval = $second_approval = $third_approval = $final_approval = $status = 2;
				}
			}
			$result = $this->Payroll_model->read_advance_salary_info($id);
			///////////////////////////////////////
			if ($this->input->post('first_approval') == NULL || $this->input->post('first_approval') == 'NULL') {
				$first_approval = $result[0]->first_approval;
			}
			if ($this->input->post('second_approval') == NULL || $this->input->post('second_approval') == 'NULL') {
				$second_approval = $result[0]->second_approval;
			}
			if ($this->input->post('third_approval') == NULL || $this->input->post('third_approval') == 'NULL') {
				$third_approval = $result[0]->third_approval;
			}
			////////////////////////
			if ($result[0]->first_approval != $first_approval) {
				$first_approved_user = $session['user_id'];
			} else {
				$first_approved_user = $result[0]->first_approved_user;
			}
			if ($result[0]->second_approval != $second_approval) {
				$second_approved_user = $session['user_id'];
			} else {
				$second_approved_user = $result[0]->second_approved_user;
			}
			if ($result[0]->third_approval != $third_approval) {
				$third_approved_user = $session['user_id'];
			} else {
				$third_approved_user = $result[0]->third_approved_user;
			}
			if ($result[0]->final_approval != $final_approval) {
				$final_approved_user = $session['user_id'];
			} else {
				$final_approved_user = $result[0]->final_approved_user;
			}
			$data = array(
				'employee_id' => $employee_id,
				'company_id' => $company,
				'reason' => $qt_reason,
				'month_year' => $this->input->post('month_year'),
				'monthly_installment' => $monthly_installment,
				'one_time_deduct' => $this->input->post('one_time_deduct'),
				'advance_amount' => $this->input->post('amount'),
				'status' => $status,
				'created_at' => ($user_info[0]->user_role_id == 1) ? $this->input->post('applied_on') : $this->input->post('applied_on_old'),
				'first_approval' => $first_approval,
				'final_approval' => $final_approval,
				'second_approval' => $second_approval,
				'third_approval' => $third_approval,
				'first_approved_user' => $first_approved_user,
				'second_approved_user' => $second_approved_user,
				'third_approved_user' => $third_approved_user,
				'final_approved_user' => $final_approved_user,
			);

			$result = $this->Payroll_model->updated_advance_salary_payroll($data, $id);

			if ($result == TRUE) {
				if ($this->input->post('one_time_deduct_id') == 1) {
					$dlt_distribution_list = $this->Payroll_model->delete_advance_distribution_list($employee_id, $id);
					$data1 = array(
						'advance_id' => $id,
						'month_year' => $this->input->post('month_year'),
						'amount' => $monthly_installment,
						'employee_id' => $employee_id
					);
					$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
				} else {
					/*$dlt_distribution_list =  $this->Payroll_model->delete_advance_distribution_list($this->input->post('employee_id'),$id);
				$start    = new DateTime($this->input->post('start_date'));
				$start->modify('first day of this month');
				$end      = new DateTime($this->input->post('end_date'));
				$end->modify('first day of next month');
				$interval = DateInterval::createFromDateString('1 month');
				$period   = new DatePeriod($start, $interval, $end);
				foreach ($period as $dt) {
					$data1 = array(
							'advance_id' => $id,
							'month_year' => $dt->format("Y-m"),
							'amount' => $monthly_installment,
							'employee_id' => $this->input->post('employee_id')
							);
						$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
					}
					*/
					$get_loan_distrubtion = $this->Payroll_model->get_employee_advance_salary_distrubtion($employee_id, $id);
					if ($get_loan_distrubtion) {
						foreach ($get_loan_distrubtion as $val) {
							$data1 = array(
								'amount' => $this->input->post('amount_changes_' . $val->id),
							);
							$result_1 = $this->Payroll_model->adv_salary_distrubution_record_update($data1, $val->id);
						}
					}
				}
				$Return['result'] = $this->lang->line('xin_success_advance_salary_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function delete_advance_salary()
	{
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$result1 = $this->Payroll_model->read_advance_salary_info($id);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$role_id = $this->Xin_model->user_role_name($session['user_id']);
		}
		if ($role_id == '1') {
			if ($result1) {
				$check_distributions_exits = $this->Payroll_model->get_employee_advance_salary_distrubtion($result1[0]->employee_id, $id);
				if ($check_distributions_exits) {
					$dlt_loan_distribution = $this->Payroll_model->dlt_advance_distrbutions($result1[0]->employee_id, $id);
				}
			}
			$result = $this->Payroll_model->delete_advance_salary_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_advance_salary_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
		} else {
			if ($result1 != NULL && $result1 != 'NULL') {
				if ($result1[0]->status == '1') {
					$Return['result'] = 'approved_data';
					$Return['error'] = $this->lang->line('xin_advance_salary_del_rjet');
				} else {
					if ($result1) {
						$check_distributions_exits = $this->Payroll_model->get_employee_advance_salary_distrubtion($result1[0]->employee_id, $id);
						if ($check_distributions_exits) {
							$dlt_loan_distribution = $this->Payroll_model->dlt_advance_distrbutions($result1[0]->employee_id, $id);
						}
					}
					$result = $this->Payroll_model->delete_advance_salary_record($id);
					if (isset($id)) {
						$Return['result'] = $this->lang->line('xin_success_advance_salary_deleted');
					} else {
						$Return['error'] = $this->lang->line('xin_error_msg');;
					}
				}
			}
		}
		$this->output($Return);
	}

	// get advance salary info by id
	public function advance_salary_read()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('advance_salary_id');
		// $data['all_countries'] = $this->xin_model->get_countries();
		$result = $this->Payroll_model->read_advance_salary_info($id);
		$status = $result[0]->status;
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array("384", $role_resources_ids)) {
			$status = $result[0]->first_approval;
		} else if (in_array("387", $role_resources_ids)) {
			$status = $result[0]->final_approval;
		}
		if (!empty($session)) {
			$role_id = $this->Xin_model->user_role_name($session['user_id']);
		}
		if ($result[0]->status == '1') {
			$approved_data = 'approved_data';
		} else {
			$approved_data = '';
		}
		$first = '';
		$second = '';
		$third = '';
		$final = '';
		$final_aprvd = '';
		///////////role check////////////
		if (!in_array("384", $role_resources_ids)) {
			$first = 'first_approval';
		}
		if (!in_array("385", $role_resources_ids)) {
			$second = 'second_approval';
		}
		if (!in_array("386", $role_resources_ids)) {
			$third = 'third_approval';
		}
		if (!in_array("387", $role_resources_ids)) {
			$final = 'final_approval';
			// $final_aprvd = 'final_approved';
		}
		// var_dump($final);
		////////final approved/////
		if ($result[0]->final_approval != 0) {
			if ($result[0]->final_approval == 1) {
				$result[0]->first_approval = 1;
				$result[0]->second_approval = 1;
				$result[0]->third_approval = 1;
			} else if ($result[0]->final_approval == 2) {
				$result[0]->first_approval = 2;
				$result[0]->second_approval = 2;
				$result[0]->third_approval = 2;
			}
		}


		/////////////////previos approved/////////
		if ($result[0]->first_approval == 0) {
			$second = 'second_approval';
		}
		if ($result[0]->second_approval == 0) {
			$third = 'third_approval';
		}
		///////////reverce approve/////////
		// var_dump($result[0]);
		if ($result[0]->second_approval != 0) {
			$first = 'first_approval';
		}
		if ($result[0]->third_approval != 0) {
			$second = 'second_approval';
		}
		if ($result[0]->final_approval != 0) {
			$third = 'third_approval';
		}
		// if ($result[0]->final_approval != 0) {
		//     $final = 'final_approved';
		// }
		// var_dump($final);
		if ($result[0]->final_approval != 0) {
			$final_aprvd = 'final_approved';
		}
		$data = array(
			'advance_salary_id' => $result[0]->advance_salary_id,
			'company_id' => $result[0]->company_id,
			'employee_id' => $result[0]->employee_id,
			'month_year' => $result[0]->month_year,
			'advance_amount' => $result[0]->advance_amount,
			'one_time_deduct' => $result[0]->one_time_deduct,
			'monthly_installment' => $result[0]->monthly_installment,
			'start_date' => $result[0]->start_date,
			'end_date' => $result[0]->end_date,
			'reason' => $result[0]->reason,
			'status' => $status,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'get_all_companies' => $this->Xin_model->get_companies(),
			'role_id' => $role_id,
			'approved_data' => $approved_data,
			'one_time_deduct' => $result[0]->one_time_deduct,
			'first' => $first,
			'second' => $second,
			'third' => $third,
			'final' => $final,
			'final_aprvd' => $final_aprvd,
			'first_approval' => $result[0]->first_approval,
			'second_approval' => $result[0]->second_approval,
			'third_approval' => $result[0]->third_approval,
			'final_approval' => $result[0]->final_approval
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_advance_salary', $data);
		} else {
			redirect('admin/');
		}
	}

	// get advance salary info by id
	public function advance_salary_report_read()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		// $data['all_countries'] = $this->xin_model->get_countries();
		$result = $this->Payroll_model->advance_salaries_report_view($id);
		$data = array(
			'advance_salary_id' => $result[0]->advance_salary_id,
			'employee_id' => $result[0]->employee_id,
			'company_id' => $result[0]->company_id,
			'month_year' => $result[0]->month_year,
			'advance_amount' => $result[0]->advance_amount,
			'total_paid' => $result[0]->total_paid,
			'one_time_deduct' => $result[0]->one_time_deduct,
			'monthly_installment' => $result[0]->monthly_installment,
			'reason' => $result[0]->reason,
			'status' => $result[0]->status,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'get_all_companies' => $this->Xin_model->get_companies()
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_advance_salary', $data);
		} else {
			redirect('admin/');
		}
	}

	public function dialog_salary_loan_extend()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('field_id');
		$result = $this->Payroll_model->read_advance_salary_info($id);
		$data = array(
			'advance_salary_id' => $result[0]->advance_salary_id,
			'company_id' => $result[0]->company_id,
			'employee_id' => $result[0]->employee_id,
			'month_year' => $result[0]->month_year,
			'advance_amount' => $result[0]->advance_amount,
			'one_time_deduct' => $result[0]->one_time_deduct,
			'monthly_installment' => $result[0]->monthly_installment,
			'start_date' => $result[0]->start_date,
			'end_date' => $result[0]->end_date,
			'reason' => $result[0]->reason,
			'status' => $result[0]->status,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'get_all_companies' => $this->Xin_model->get_companies()
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_advance_salary', $data);
		} else {
			redirect('admin/');
		}
	}

    public function update_advance_salary_extend_validate()
	{
	    $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
	    if ($this->input->post('start_date') === '') {

			$Return['error'] = "Start Date is required";
		} else if ($this->input->post('old_end_date_new') === '') {

			$Return['error'] = "End Date is required";
		}
		if ($Return['error'] != '') {

			$this->output($Return);
		}
		$this->output($Return);
	}
	public function update_advance_salary_extend()
	{
		if ($this->input->post('edit_type') == 'advance_salary_extend') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			/* Server side PHP input validation */
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$end_date_old = $this->input->post('old_end_date_new');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$old_end_date = strtotime($end_date_old);

			$session = $this->session->userdata('username');
			if (!empty($session)) {
				$role_id = $this->Xin_model->user_role_name($session['user_id']);
			}
			$result1 = $this->Payroll_model->read_advance_salary_info($id);
			if ($role_id == '1') {
				if ($this->input->post('start_date') === '') {
					$Return['error'] = $this->lang->line('xin_error_start_date');
				} else if ($this->input->post('end_date') === '') {
					$Return['error'] = $this->lang->line('xin_error_end_date');
				} else if ($st_date > $ed_date) {
					$Return['error'] = $this->lang->line('xin_error_start_end_date');
				} else if ($ed_date <= $old_end_date) {
					$Return['error'] = 'End date must be greater than the existing end date';
				}

				// get one time value

				if ($Return['error'] != '') {
					$this->output($Return);
				}

				$data = array(
					'start_date' => $this->input->post('start_date'),
					'end_date' => $this->input->post('end_date')
				);

				$result = $this->Payroll_model->updated_advance_salary_payroll($data, $id);
				if ($result == TRUE) {
					$get_loan_distrubtion = $this->Payroll_model->get_employee_advance_salary_distrubtion($this->input->post('user_id'), $id);
					if ($get_loan_distrubtion) {
						$last_date = $this->Payroll_model->get_employee_adv_sal_distrubtion_latest($this->input->post('user_id'), $id);
						if ($last_date) {
							foreach ($get_loan_distrubtion as $val) {
								if ($val->month_year > date('Y-m', strtotime($this->input->post('end_date')))) {
									$dlt_loan_distribution_list = $this->Employees_model->delete_advance_distribution_list_de($val->id);
								}
							}
							$latest_loan_due_year = strtotime($last_date[0]->month_year);
							$next_start = date("Y-m", strtotime("+1 month", $latest_loan_due_year));
							$start = new DateTime($next_start);
							$start->modify('first day of this month');
							$end = new DateTime($this->input->post('end_date'));
							$end->modify('first day of next month');
							$interval = DateInterval::createFromDateString('1 month');
							$period = new DatePeriod($start, $interval, $end);
							foreach ($period as $dt) {
								$data1 = array(
									'advance_id' => $id,
									'month_year' => $dt->format("Y-m"),
									'amount' => 0,
									'employee_id' => $this->input->post('user_id')
								);
								$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
							}
						}
					} else {
						$start = new DateTime($this->input->post('start_date'));
						$start->modify('first day of this month');
						$end = new DateTime($this->input->post('end_date'));
						$end->modify('first day of next month');
						$interval = DateInterval::createFromDateString('1 month');
						$period = new DatePeriod($start, $interval, $end);
						foreach ($period as $dt) {
							$data1 = array(
								'advance_id' => $id,
								'month_year' => $dt->format("Y-m"),
								'amount' => $this->input->post('amount'),
								'employee_id' => $this->input->post('user_id')
							);
							$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
						}
					}
					$Return['result'] = $this->lang->line('xin_success_advance_salary_updated');
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else {
				if ($result1 != NULL && $result1 != 'NULL') {
					if ($result1[0]->status == '1') {
						$Return['result'] = 'approved_data';
						$Return['error'] = $this->lang->line('xin_advance_salary_ext_rjet');
					} else {
						if ($this->input->post('start_date') === '') {
							$Return['error'] = $this->lang->line('xin_error_start_date');
						} else if ($this->input->post('end_date') === '') {
							$Return['error'] = $this->lang->line('xin_error_end_date');
						} else if ($st_date > $ed_date) {
							$Return['error'] = $this->lang->line('xin_error_start_end_date');
						} else if ($ed_date <= $old_end_date) {
							$Return['error'] = 'End date must be greater than the existing end date';
						}

						// get one time value

						if ($Return['error'] != '') {
							$this->output($Return);
						}

						$data = array(
							'start_date' => $this->input->post('start_date'),
							'end_date' => $this->input->post('end_date')
						);

						$result = $this->Payroll_model->updated_advance_salary_payroll($data, $id);
						if ($result == TRUE) {
							$get_loan_distrubtion = $this->Payroll_model->get_employee_advance_salary_distrubtion($this->input->post('user_id'), $id);
							if ($get_loan_distrubtion) {
								$last_date = $this->Payroll_model->get_employee_adv_sal_distrubtion_latest($this->input->post('user_id'), $id);
								if ($last_date) {
									foreach ($get_loan_distrubtion as $val) {
										if ($val->month_year > date('Y-m', strtotime($this->input->post('end_date')))) {
											$dlt_loan_distribution_list = $this->Employees_model->delete_advance_distribution_list_de($val->id);
										}
									}
									$latest_loan_due_year = strtotime($last_date[0]->month_year);
									$next_start = date("Y-m", strtotime("+1 month", $latest_loan_due_year));
									$start = new DateTime($next_start);
									$start->modify('first day of this month');
									$end = new DateTime($this->input->post('end_date'));
									$end->modify('first day of next month');
									$interval = DateInterval::createFromDateString('1 month');
									$period = new DatePeriod($start, $interval, $end);
									foreach ($period as $dt) {
										$data1 = array(
											'advance_id' => $id,
											'month_year' => $dt->format("Y-m"),
											'amount' => 0,
											'employee_id' => $this->input->post('user_id')
										);
										$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
									}
								}
							} else {
								$start = new DateTime($this->input->post('start_date'));
								$start->modify('first day of this month');
								$end = new DateTime($this->input->post('end_date'));
								$end->modify('first day of next month');
								$interval = DateInterval::createFromDateString('1 month');
								$period = new DatePeriod($start, $interval, $end);
								foreach ($period as $dt) {
									$data1 = array(
										'advance_id' => $id,
										'month_year' => $dt->format("Y-m"),
										'amount' => $this->input->post('amount'),
										'employee_id' => $this->input->post('user_id')
									);
									$result_1 = $this->Payroll_model->add_advance_sal_month_wise_dedec($data1);
								}
							}
							$Return['result'] = $this->lang->line('xin_success_advance_salary_updated');
						} else {
							$Return['error'] = $this->lang->line('xin_error_msg');
						}
					}
				}
			}
			$this->output($Return);
			exit;
		}
	}
	////////////////////////////////////////////////////////////////////////////////////////////////
	public function add_advance_salary_validate()
	{
		if ($this->input->post('add_type') == 'advance_salary') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$reason = $this->input->post('reason');
			$qt_reason = htmlspecialchars(addslashes($reason), ENT_QUOTES);
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_id = $this->Xin_model->user_role_name($session['user_id']);
			if ($role_id == '1') {
				$company = $this->input->post('company');
				$employee_id = $this->input->post('employee_id');
			} else {
				$company = $user_info[0]->company_id;
				$employee_id = $user_info[0]->user_id;
			}
			/* Server side PHP input validation */
			if ($company === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($employee_id === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('month_year') === '') {
				$Return['error'] = $this->lang->line('xin_error_advance_salary_month_year');
			} else if ($this->input->post('amount') === '') {
				$Return['error'] = $this->lang->line('xin_error_amount_field');
			}
			// get one time value
			if ($this->input->post('one_time_deduct') == 1) {
				$m_ins = $this->input->post('amount');
				$start_date = '';
				$end_date = '';
			} else {

				$start = new DateTime($this->input->post('start_date'));
				$start->modify('first day of this month');
				$end = new DateTime($this->input->post('end_date'));
				$end->modify('first day of next month');
				$interval = DateInterval::createFromDateString('1 month');
				$period = new DatePeriod($start, $interval, $end);
				$array_dates = array();
				foreach ($period as $dt) {
					$array_dates[] = $dt->format("Y-m");
				}
				$final_month_diff = 0;
				$tm = count($array_dates);
				if ($tm < 1) {
					$m_ins = (float)$this->input->post('amount');
				} else {
					$m_ins = (float)$this->input->post('amount') / $tm;
					$m_ins = round($m_ins, 3);
					$check_final_val = $m_ins * $tm;
					if ($check_final_val != $this->input->post('amount')) {
						$final_month_diff = $this->input->post('amount') - $check_final_val;
						$final_month_diff = $m_ins + $final_month_diff;
					}
				}


				//$monthly_installment = $this->input->post('monthly_installment');
				$start_date = $this->input->post('start_date');
				$end_date = $this->input->post('end_date');
				$st_date = strtotime($start_date);
				$ed_date = strtotime($end_date);
				if ($this->input->post('start_date') === '') {
					$Return['error'] = $this->lang->line('xin_error_start_date');
				} else if ($this->input->post('end_date') === '') {
					$Return['error'] = $this->lang->line('xin_error_end_date');
				} else if ($st_date > $ed_date) {
					$Return['error'] = $this->lang->line('xin_error_start_end_date');
				}
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}
	public function payment_history_pdf()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/payment_history", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->post("company_id") == 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0) {
				if ($this->input->post("salary_month") == '') {
					$history = $this->Payroll_model->all_employees_payment_history();
				} else {
					$history = $this->Payroll_model->all_employees_payment_history_month($this->input->post("salary_month"));
				}
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") == 0 && $this->input->post("department_id") == 0) {
				if ($this->input->post("salary_month") == '') {
					$history = $this->Payroll_model->get_company_payslip_history($this->input->post("company_id"));
				} else {
					$history = $this->Payroll_model->get_company_payslip_history_month($this->input->post("company_id"), $this->input->post("salary_month"));
				}
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") == 0) {
				if ($this->input->post("salary_month") == '') {
					$history = $this->Payroll_model->get_company_location_payslips($this->input->post("company_id"), $this->input->post("location_id"));
				} else {
					$history = $this->Payroll_model->get_company_location_payslips_month($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("salary_month"));
				}
			} else if ($this->input->post("company_id") != 0 && $this->input->post("location_id") != 0 && $this->input->post("department_id") != 0) {
				if ($this->input->post("salary_month") == '') {
					$history = $this->Payroll_model->get_company_location_department_payslips($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"));
				} else {
					$history = $this->Payroll_model->get_company_location_department_payslips_month($this->input->post("company_id"), $this->input->post("location_id"), $this->input->post("department_id"), $this->input->post("salary_month"));
				}
			}/**/ /*else if($this->input->get("company_id")!=0 && $this->input->get("location_id")!=0 && $this->input->get("department_id")!=0 && $this->input->get("designation_id")!=0){
				$history = $this->Payroll_model->get_company_location_department_designation_payslips($this->input->get("company_id"),$this->input->get("location_id"),$this->input->get("department_id"),$this->input->get("designation_id"));
			}*/
		} else {
			if ($user_info[0]->user_role_id == 1) {
				$history = $this->Payroll_model->employees_payment_history();
			} else {
				if (in_array('288', $role_resources_ids)) {
					$history = $this->Payroll_model->get_company_payslips($user_info[0]->company_id);
				} else {
					$history = $this->Payroll_model->get_payroll_slip($session['user_id']);
				}
			}
		}
		$data = array();

		foreach ($history->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				$emp_link = $user[0]->employee_id;
				$month_payment = date("F, Y", strtotime($r->salary_month));

				$p_amount = $this->Xin_model->company_currency_sign($r->net_salary,$r->company_id);

				// get date > created at > and format
				$created_at = $this->Xin_model->set_date_format($r->created_at);
				// get designation
				$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
				$department_designation = $designation_name . ' (' . $department_name . ')';
				// get company
				$company = $this->Xin_model->read_company_info($user[0]->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}
				// bank account
				$bank_account = $this->Employees_model->get_employee_bank_account_last($user[0]->user_id);
				if (!is_null($bank_account)) {
					$account_number = $bank_account[0]->account_number;
				} else {
					$account_number = '--';
				}
				if (in_array('288', $role_resources_ids)) {
					$payslip = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $r->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $r->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
				} else {
					$payslip = '';
				}
				$ifull_name = nl2br($full_name . "\r\n <small class='text-muted'><i>" . $this->lang->line('xin_employees_id') . ': ' . $emp_link . "<i></i></i></small>\r\n <small class='text-muted'><i>" . $department_designation . '<i></i></i></small>');
				if (in_array('288', $role_resources_ids)) {
					$data[] = array(
					'full_name'=>	$full_name,
					'comp_name'=>	$comp_name,
					'account_number'=>	$account_number,
					'p_amount'=>	$p_amount,
					'month_payment'=>	$month_payment,
					'created_at'=>		$created_at,
					'payslip'=>	$payslip,
					);
				}
			}
		} // if employee available

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
		'mode' => 'utf-8',
		'format' => 'A4'
		]);
		$res['lists'] = $data;
		$html = $this->load->view("admin/payroll/get_payment_history_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Payment_history.pdf', 'D'); //

	}
	public function bank_format_pdf()
	{
		error_reporting(0);

		$data['title'] = $this->Xin_model->site_title();
		$data['path_url'] = 'bank_format';
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/payroll/generate_payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		// date and employee id/company id
		$p_date = $this->input->post("p_month_year");
		$location_id = $this->input->post("p_location_id");
		$value_date = $this->input->post("p_value_date");
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('280', $role_resources_ids)) {
			$payslip = $this->Payroll_model->bank_format_details_list($location_id, $p_date, '', '');
		} else {
			$payslip = $this->Payroll_model->bank_format_details_list('', '', $user_info[0]->company_id, $session['user_id']);
		}

		$system = $this->Xin_model->read_setting_info(1);
		$data = array();

		foreach ($payslip->result() as $r) {
			// user full name
			$emp_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			$full_name = '<a target="_blank" class="text-primary" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '">' . $emp_name . '</a>';

			// get total hours > worked > employee
			$pay_date = $this->input->post('month_year');
			//overtime request
			$overtime_count = $this->Overtime_request_model->get_overtime_request_count($r->user_id, $this->input->post('month_year'));
			$re_hrs_old_int1 = 0;
			$re_hrs_old_seconds = 0;
			$re_pcount = 0;
			foreach ($overtime_count as $overtime_hr) {
				// total work
				$request_clock_in = new DateTime($overtime_hr->request_clock_in);
				$request_clock_out = new DateTime($overtime_hr->request_clock_out);
				$re_interval_late = $request_clock_in->diff($request_clock_out);
				$re_hours_r = $re_interval_late->format('%h');
				$re_minutes_r = $re_interval_late->format('%i');
				$re_total_time = $re_hours_r . ":" . $re_minutes_r . ":" . '00';

				$re_str_time = $re_total_time;

				$re_str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $re_str_time);

				sscanf($re_str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$re_hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$re_hrs_old_int1 += $re_hrs_old_seconds;

				$re_pcount = gmdate("H", $re_hrs_old_int1);
			}
			$result = $this->Payroll_model->total_hours_worked($r->user_id, $pay_date);
			$hrs_old_int1 = 0;
			$pcount = 0;
			$Trest = 0;
			$total_time_rs = 0;
			$hrs_old_int_res1 = 0;
			foreach ($result->result() as $hour_work) {
				// total work
				$clock_in = new DateTime($hour_work->clock_in);
				$clock_out = new DateTime($hour_work->clock_out);
				$interval_late = $clock_in->diff($clock_out);
				$hours_r = $interval_late->format('%h');
				$minutes_r = $interval_late->format('%i');
				$total_time = $hours_r . ":" . $minutes_r . ":" . '00';

				$str_time = $total_time;

				$str_time = preg_replace("/^([\d]{1,2})\:([\d]{2})$/", "00:$1:$2", $str_time);

				sscanf($str_time, "%d:%d:%d", $hours, $minutes, $seconds);

				$hrs_old_seconds = $hours * 3600 + $minutes * 60 + $seconds;

				$hrs_old_int1 += $hrs_old_seconds;

				$pcount = gmdate("H", $hrs_old_int1);
			}
			$pcount = $pcount + $re_pcount;
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// 1: salary type
			if ($r->wages_type == 1) {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			} else if ($r->wages_type == 2) {
				$wages_type = $this->lang->line('xin_employee_daily_wages');
				if ($pcount > 0) {
					$basic_salary = $pcount * $r->basic_salary;
				} else {
					$basic_salary = $pcount;
				}
				$p_class = 'emo_hourly_pay';
				$view_p_class = 'hourlywages_template_modal';
			} else {
				$wages_type = $this->lang->line('xin_payroll_basic_salary');
				if ($system[0]->is_half_monthly == 1) {
					$basic_salary = $r->basic_salary / 2;
				} else {
					$basic_salary = $r->basic_salary;
				}
				$p_class = 'emo_monthly_pay';
				$view_p_class = 'payroll_template_modal';
			}

			$location_id = $r->location_id;
			$monthyear = $payyear . "-" . $paymonth;
			$get_management_status = $this->Employees_model->get_management_employee_status($r->user_id, $location_id, $p_date);
			if (empty($get_management_status)) {
				$management_status_val = 1;
			} else {
				$management_status_val = 2;
			}

			// all allowances, all loan/deductions
			$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($r->user_id, $p_date, $basic_salary);
			$salary_calc = $this->Xin_model->payroll_GrossSalary($r->user_id, $p_date, $basic_salary, $all_allo_and_dedct);
			$total_net_salary = $salary_calc[0];
			$status_pay_val = 0;
			// make payment
			if ($system[0]->is_half_monthly == 1) {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_half_month_check($r->user_id, $p_date);
				$payment_last = $this->Payroll_model->read_make_payment_payslip_half_month_check_last($r->user_id, $p_date);
				if ($payment_check->num_rows() > 1) {
					//foreach($payment_last as $payment_half_last){
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$status_pay_val = 1;
					//$mpay = '<span data-toggle="tooltip" data-placement="top" title="'.$this->lang->line('xin_payroll_make_payment').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".'.$p_class.'" data-employee_id="'. $r->user_id . '" data-payment_date="'. $p_date . '" data-company_id="'.$this->input->get("company_id").'"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('278', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code><br>' . '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . site_url() . 'admin/payroll/payslip/id/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $payment_last[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $payment_last[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span><code>' . $this->lang->line('xin_title_second_half') . '</code>';
					//}
					//detail link
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$status_pay_val = 1;
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$mpay .= '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('278', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					$delete = $delete . '<code>' . $this->lang->line('xin_title_first_half') . '</code>';
					$detail = '';
					$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					//detail link
					$detail = '<span data-toggle="tooltip" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-xs btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $pay_date . '"><span class="fa fa-eye"></span></button></span>';

					$total_net_salary = $total_net_salary;
				}
				//detail link
				//$detail = '';
			} else {
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($r->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
					$view_url = site_url() . 'admin/payroll/payslip/id/' . $make_payment[0]->payslip_key;

					$status_pay = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
					$status_pay_val = 1;
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_view_payslip') . '"><a href="' . $view_url . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="far fa-arrow-alt-circle-right"></span></button></a></span><span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/payroll/pdf_create/p/' . $make_payment[0]->payslip_key . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span>';
					if (in_array('278', $role_resources_ids)) {
						$delete = '<span data-toggle="tooltip" data-state="danger" data-placement="top" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $make_payment[0]->payslip_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					//$total_net_salary = $make_payment[0]->net_salary;
				} else {
					$status_pay = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
					$mpay = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_payroll_make_payment') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".' . $p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '" data-company_id="' . $this->input->get("company_id") . '"><span class="far fa-money-bill-alt"></span></button></span>';
					$delete = '';
					$total_net_salary = $total_net_salary;
				}
				//detail link
				$detail = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#' . $view_p_class . '" data-employee_id="' . $r->user_id . '" data-payment_date="' . $p_date . '"" data-net="' . $total_net_salary . '"><span class="fa fa-eye"></span></button></span>';
			}

			$net_salary = number_format((float)$total_net_salary, 2, '.', '');
			$basic_salary = number_format((float)$basic_salary, 2, '.', '');
			//}

			if ($basic_salary == 0 || $basic_salary == '') {
				$fmpay = '';
			} else {
				$fmpay = $mpay;
			}

			//new leave calc
			$month_year = $pay_date;
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leaves = $this->Employees_model->emp_leave_fetch($r->user_id, $start_date_y);

			$user_id = $r->user_id;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}
			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$k = 1;
			$extra_amount = $tot_days_lop_normal = 0;
			$tot_days = 0;

			//Using attendance
			$arry_years = array();
			$st = '';
			$p_count_val = 0;
			$start_date_co = $year . '-' . $month . '-' . '01';
			$end_date_co = $year . '-' . $month . '-' . $daysInMonth;


			$present_arr = array();
			//$st = $this->db->last_query();
			$leave_arr = $half_leave_arr = array();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$user = $this->Xin_model->read_user_info($r->user_id);
			if (strtotime($month_year) == strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				if ($user[0]->date_of_leaving) {
					if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
						if (strtotime(date("Y-m-d", strtotime($user[0]->date_of_leaving))) > strtotime(date("Y-m-d"))) {
							$difference_days = 0;
						} else {
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						}
					} else {
						$difference_days = 0;
					}
				} else {
					$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
					if ($get_attendance_last_entered) {
						$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
						//$month_year_att_end = $month_year.'-'.date('d');
						$startDate = new DateTime($month_year_att);
						$endDate = new DateTime($month_year_att_end);
						$difference = $endDate->diff($startDate);
						$difference_days = $difference->format("%a") + 1;
					} else {
						$difference_days = 0;
					}
				}
			} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
				if ($get_attendance_last_entered) {
					$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
					//$month_year_att_end = $month_year.'-'.date('d');
					$startDate = new DateTime($month_year_att);
					$endDate = new DateTime($month_year_att_end);
					$difference = $endDate->diff($startDate);
					$difference_days = $difference->format("%a") + 1;
				} else {
					$difference_days = 0;
				}
			} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
				$difference_days = 0;
			}
			if ($difference_days >= 25) {
				$difference_days = $daysInMonth;
			}


			$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

			//end number of calc
			$attendence_calc = $this->Xin_model->AttendnceCount_calc_common($r->office_shift_id, $start_date_co, $end_date_co, $r->company_id, $r->user_id, $difference_days, $year, $month);
			if ($attendence_calc) {
				$tot_days_lop_normal = $attendence_calc[0];
				$totl_num_days_pres = $attendence_calc[1];
			} else {
				$tot_days_lop_normal = 0;
				$totl_num_days_pres = 0;
			}
			$tot_days_lop = $tot_days_lop_normal;

			$bs_pay = $r->basic_salary;
			/* Net salary calculations */
			$net_salary_calc = $this->Xin_model->NetsalaryCalcCommon($total_net_salary, $daysInMonth, $totl_num_days_pres);
			$net_salary = $net_salary_calc[0];


			/* Lop Calc Common */
			$lop_calc = $this->Xin_model->LopCalcCommon($net_salary, $daysInMonth, $tot_days_lop);
			$leave_cut_salary = $lop_calc[0];
			/* End Lop calc Common */

			/* Final Net salary */
			$final_net_salary = $this->Xin_model->FinalNetSalaryCalcCommon($net_salary, $leave_cut_salary, $all_allo_and_dedct);
			$net_salary = $final_net_salary[0];

			$start_date_y_m = date('Y-m', strtotime($month_year));
			//Indemnity calc

			$totl_amt = 0;
			//leave encashment calc
			$start_date_y = date('m', strtotime($month_year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$emp_leave_enchas = $this->Employees_model->emp_leave_encashment_fetch($user_id, $start_date_y);

			$totl_amt_leva = 0;
			if ($emp_leave_enchas) {
				foreach ($emp_leave_enchas as $emp_leave_ench) {
					$totl_amt_leva += $emp_leave_ench->amount;
				}
			}
			$net_salary = $net_salary + $totl_amt + $totl_amt_leva;
			if ($net_salary < 0 || $basic_salary <= 0) {
				$net_salary = '0.00';
			}
			$basic_salary = $this->Xin_model->company_currency_sign($basic_salary,$r->company_id);

			$iemp_name = $emp_name . '<small class="text-muted"><i> (' . $comp_name . ')<i></i></i></small>';

			//action link
			$act = $detail . $fmpay . $delete;
			if ($r->wages_type == 1) {
				if ($system[0]->is_half_monthly == 1) {
					$emp_payroll_wage = $wages_type . '<br><small class="text-muted"><i>' . $this->lang->line('xin_half_monthly') . '<i></i></i></small>';
				} else {
					$emp_payroll_wage = $wages_type;
				}
			} else {
				$emp_payroll_wage = $wages_type;
			}
			if (in_array('83', $role_resources_ids)) {
				$emp_id = '<a target="_blank" href="' . site_url('admin/employees/detail/') . $r->user_id . '" class="text-muted" data-state="primary" data-placement="top" data-toggle="tooltip" title="Employee Detail">' . $r->employee_id . ' <i class="fas fa-arrow-circle-right"></i></a>';
			} else {
				$emp_id = $r->employee_id;
			}

			$paymonth = date('m', strtotime($pay_date));
			$payyear = date('Y', strtotime($pay_date));
			$empdata = $this->Employees_model->get_employee_details($user_id);
			$basepay = $empdata[0]->basic_salary;
			$no_of_days = date('t', strtotime($pay_date));


			// Late Deduction Start

			$latededuction = $this->Payroll_model->GetLateDeductionCalcCommon($user_id, $paymonth, $payyear, $no_of_days);
			$late_amount = $latededuction[0];

			// Late Deduction End


			$userinfo = $this->Employees_model->get_employee_details($user_id);
			$companyinfo = $this->Employees_model->get_company_details($userinfo[0]->company_id);
			$late_status = $companyinfo[0]->late_deduction;
			if ($late_status == 'yes') {
				$late_amount = $late_amount;
			} else {
				$late_amount = 0;
			}

			// Get Overtime Amount
			$overtime = $this->Payroll_model->GetOvertimeCalcCommon($user_id, $paymonth, $payyear);
			$overtime_amount = $overtime[0];
			// End Overtime Amount

			// Air ticket Encashment Start
			$encashment_check = $this->Employees_model->employee_encashment_check($user_id, $month_year);
			if (!empty($encashment_check)) {
				$encashstatus = $encashment_check[0]->status;
				if (!is_null($encashstatus)) {
					$encashrate = $this->Employees_model->get_employee_encashrate_payroll($user_id, $month_year);
					$encash_amt = $encashrate[0]->amount;
				} else {
					$encash_amt = 0;
				}
			} else {
				$encash_amt = 0;
			}

			// Air ticket Encashment End
			//$nettotal = $net_salary;
			$overtimestatus = $this->Employees_model->get_employee_overtimestatus($user_id);
			$otstatus = $overtimestatus[0]->ot_eligible;
			if ($otstatus == "yes") {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary + $overtime_amount - $late_amount;
				}
			} else {
				if ($net_salary == 0) {
					$nettotal = 0.000;
				} else {
					$nettotal = $net_salary - $late_amount;
				}
			}


			/* Expense Claim Start */
			if ($nettotal > 0) {
				$expense_total_claim = $this->Xin_model->FindExpenseClaimTotal($user_id, $this->input->get('month_year'));
				$nettotal = $nettotal + $expense_total_claim + $encash_amt;
			}
			/* Expense Claim End */

			$nettotal = $this->Xin_model->company_currency_sign($nettotal,$r->company_id);


			$location_id = $r->location_id;
			$monthyear = $payyear . "-" . $paymonth;
			$get_management_status = $this->Employees_model->get_management_employee_status($user_id, $location_id, $p_date);

			if (empty($get_management_status)) {
				$management_status = "Pending";
			} else {
				$management_status = $get_management_status[0]->status;
			}


			$days_in_month = $days = date("t");

			$payment_check = $this->Payroll_model->read_make_payment_payslip_check($user_id, $p_date);

			if ($payment_check->num_rows() > 0) {

				$make_payment = $this->Payroll_model->read_make_payment_payslip($r->user_id, $p_date);
				$nettotal = $this->Xin_model->company_currency_sign($make_payment[0]->net_salary,$r->company_id);
			}

			$companybank = $this->Xin_model->get_company_bankdetails();
			$companyaccno = $companybank[0]->account_no;
			$bankdetails = $this->Employees_model->get_bank_details($user_id);
			$bankcode = $bankdetails[0]->bank_code;
			$bankname = $bankdetails[0]->bank_name;
			$bank_account_number = $bankdetails[0]->account_number;
			$current_month = date('Y-m');
			$search_month = date('Y-m', strtotime($month_year));
			if (strtotime($search_month) > strtotime($current_month)) {
				$nettotal = $this->Xin_model->company_currency_sign('0',$r->company_id);
			}
			if ($management_status_val > 1 && $status_pay_val < 1) {
				$data[] = array(
					'bankcode'=>$bankcode,
					'bank_account_number'=>$bank_account_number,
					'emp_name'=>$emp_name,
					'nettotal'=>$nettotal,
					'companyaccno'=>$companyaccno,
					'value_date'=>$value_date
				);
			}
		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
		'mode' => 'utf-8',
		'format' => 'A4'
		]);
		$res['lists'] = $data;
		$html = $this->load->view("admin/payroll/get_bank_format_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Bank_format.pdf', 'D'); //

	}
	
}
