<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends MY_Controller
{

	/*Function to set JSON output*/
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

	public function __construct()
	{
		parent::__construct();
		//load the login model
		$this->load->model('Assetreport_model');
		$this->load->model('Company_model');
		$this->load->model('Xin_model');
		$this->load->model('Exin_model');
		$this->load->model('Department_model');
		$this->load->model('Payroll_model');
		$this->load->model('Reports_model');
		$this->load->model('Timesheet_model');
		$this->load->model('Training_model');
		$this->load->model('Trainers_model');
		$this->load->model("Project_model");
		$this->load->model("Roles_model");
		$this->load->model("Employees_model");
		$this->load->model("Designation_model");
		$this->load->model("Misc_model");
		$this->load->model("Location_model");
	}

	// reports
	public function index()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_report_title') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_report_title');
		$data['path_url'] = 'hrsale_reports';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('110', $role_resources_ids) || in_array('111', $role_resources_ids) || in_array('112', $role_resources_ids) || in_array('113', $role_resources_ids) || in_array('114', $role_resources_ids) || in_array('115', $role_resources_ids) || in_array('116', $role_resources_ids) || in_array('117', $role_resources_ids) || in_array('409', $role_resources_ids) || in_array('83', $role_resources_ids) || in_array('84', $role_resources_ids) || in_array('85', $role_resources_ids) || in_array('86', $role_resources_ids) || in_array('87', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/layout/hrsale_reports", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// payslip reports > employees and company
	public function payslip()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_payslip') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_reports_payslip');
		$data['path_url'] = 'reports_payslip';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('610', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/payslip", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	//increment report
	public function increment_report()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_increment_employee') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_reports_increment_employee');
		$data['path_url'] = 'reports_employee_attendance';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$allowance = $this->Xin_model->get_allowance();
		$data['allowance'] = $allowance;
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('655', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/increment_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// projects report
	public function projects()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_projects') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_reports_projects');
		$data['path_url'] = 'reports_project';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('648', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/projects", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// tasks report
	public function tasks()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_tasks') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_reports_tasks');
		$data['path_url'] = 'reports_task';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('649', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/tasks", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// roles/privileges report
	public function roles()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_report_user_roles_report') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_report_user_roles_report');
		$data['path_url'] = 'reports_roles';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_location'] = $this->Location_model->all_office_locations();
		//print_r($data['all_location']);exit();
		$data['all_user_roles'] = $this->Roles_model->all_user_roles();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('650', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/roles", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// employees report
	public function employees()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_report_employees') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees');
		$data['path_url'] = 'reports_employees';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_designations'] = $this->Designation_model->all_designations();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('620', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/employees", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// get company > departments
	public function get_departments()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/report_get_departments", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get departmens > designations
	public function designation()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'department_id' => $id,
			'all_designations' => $this->Designation_model->all_designations(),
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/report_get_designations", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// reports > employee attendance
	public function employee_attendance()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_attendance_employee') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_reports_attendance_employee');
		$data['path_url'] = 'reports_employee_attendance';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('112', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/employee_attendance", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// reports > employee leave
	public function employee_leave()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_leave_status') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_leave_status');
		$data['path_url'] = 'reports_employee_leave';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('264', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/employee_leave", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// reports > employee training
	public function employee_training()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_training') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_hr_reports_training');
		$data['path_url'] = 'reports_employee_training';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('647', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/employee_training", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	// Validate and add info in database
	public function payslip_report()
	{

		if ($this->input->post('type') == 'payslip_report') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('month_year') === '') {
				$Return['error'] = $this->lang->line('xin_hr_report_error_month_field');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['result'] = $this->lang->line('xin_hr_request_submitted');
			$this->output($Return);
		}
	}

	public function role_employees_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/roles", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$roleId = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$location_id = $this->uri->segment(6);

		//print_r($roleId);print_r($location_id);print_r($company_id);exit();

		$employee = $this->Reports_model->get_roles_employees($roleId, $company_id, $location_id);

		$data = array();

		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			// get status
			if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
			endif;
			// user role
			$role = $this->Xin_model->read_user_role_info($r->user_role_id);
			if (!is_null($role)) {
				$role_name = $role[0]->role_name;
			} else {
				$role_name = '--';
			}
			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			$department_designation = $designation_name . ' (' . $department_name . ')';

			$data[] = array(
				$r->employee_id,
				$full_name,
				$comp_name,
				$r->email,
				$role_name,
				$department_designation,
				$status
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function user_role_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$roleId = $this->input->post('p_role');
		$company_id = $this->input->post('p_company');
		$location_id = $this->input->post('p_location');

		$employee = $this->Reports_model->get_roles_employees($roleId, $company_id, $location_id);

		//print_r($employee->result());exit();

		$user_role_report_count = $this->Reports_model->user_role_report_query_count($roleId, $company_id, $location_id);

		//empty data display code start
		if (empty($user_role_report_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		//print_r($user_role_report_count->result());exit();

		$data = array();
		foreach ($user_role_report_count as $key => $val) {

			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$user_role_report_count[$key]['header_string'] = $email_phone_address;
			$user_role_report_count[$key]['company_name'] = $company_name;
			$user_role_report_count[$key]['logo'] = $logo;
		}

		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			// get status
			if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
			endif;
			// user role
			$role = $this->Xin_model->read_user_role_info($r->user_role_id);
			if (!is_null($role)) {
				$role_name = $role[0]->role_name;
			} else {
				$role_name = '--';
			}
			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			$department_designation = $designation_name . ' (' . $department_name . ')';

			$data[] = array(
				"company_id" => $r->company_id,
				"employee_id" => $r->employee_id,
				"name" => $full_name,
				"company" => $comp_name,
				"email" => $r->email,
				"role" => $role_name,
				"designation" => $department_designation,
				"status" => $status
			);
		}

		//print_r($data);exit();

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['user_role_report_count'] = $user_role_report_count;

		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;

		$html = $this->load->view("admin/reports/user_role_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('user_role_report.pdf', 'D'); //
	}

	public function report_employees_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $this->uri->segment(4);
		$department_id = $this->uri->segment(5);
		$designation_id = $this->uri->segment(6);

		$employee = $this->Reports_model->get_employees_reports($company_id, $department_id, $designation_id);

		$data = array();

		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			// get status
			if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
			endif;
			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}

			$data[] = array(
				$r->employee_id,
				$full_name,
				$comp_name,
				$r->email,
				$department_name,
				$designation_name,
				$status
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function employee_list_reports_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$designation_id = $this->input->post('p_designation');

		$employee = $this->Reports_model->get_employees_reports($company_id, $department_id, $designation_id);
		$employee_count = $this->Reports_model->get_employees_reports_count($company_id, $department_id, $designation_id);

		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}
		foreach ($employee->result_array() as $key => $val) {

			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $val['first_name'] . ' ' . $val['last_name'];
			// get status
			if ($val['is_active'] == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($val['is_active'] == 1) : $status = $this->lang->line('xin_employees_active');
			endif;
			// get designation
			$designation = $this->Designation_model->read_designation_information($val['designation_id']);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($val['department_id']);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}


			$data[$key]['employee_id'] = $val['employee_id'];
			$data[$key]['full_name'] = $full_name;
			$data[$key]['comp_name'] = $comp_name;
			$data[$key]['country_name'] = $val['email'];
			$data[$key]['department_name'] = $department_name;
			$data[$key]['designation_name'] = $designation_name;
			$data[$key]['status'] = $status;
			$data[$key]['company_id'] = $val['company_id'];

		}

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['employee_count'] = $employee_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/employees_report_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Employees_Report.pdf', 'D'); //


	}

	public function task_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/tasks", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$taskId = $this->uri->segment(4);
		$taskStatus = $this->uri->segment(5);
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1) {
			$tasks = $this->Reports_model->get_task_list($taskId, $taskStatus);
		} else {
			$tasks = $this->Timesheet_model->get_employee_tasks($session['user_id']);
		}
		$data = array();

		foreach ($tasks->result() as $r) {

			// get start date
			$start_date = $this->Xin_model->set_date_format($r->start_date);
			// get end date
			$end_date = $this->Xin_model->set_date_format($r->end_date);

			//status
			if ($r->task_status == 0) {
				$status = $this->lang->line('xin_not_started');
			} else if ($r->task_status == 1) {
				$status = $this->lang->line('xin_in_progress');
			} else if ($r->task_status == 2) {
				$status = $this->lang->line('xin_completed');
			} else {
				$status = $this->lang->line('xin_deffered');
			}

			//assigned user
			if ($r->assigned_to == '') {
				$ol = $this->lang->line('xin_not_assigned');
			} else {
				$ol = '';
				$assigned_names = array();
				foreach (explode(',', $r->assigned_to) as $desig_id) {
					$assigned_to = $this->Xin_model->read_user_info($desig_id);
					if (!is_null($assigned_to)) {

						$assigned_names[] = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->last_name;
						//  $ol .= '<li>'.$assigned_name.'</li>';
					}

					$ol = implode(', ', $assigned_names);
				}
			}
			// task category
			$task_catname = $r->task_name;
			$data[] = array(
				$task_catname, $start_date, $end_date, $ol, $status,
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $tasks->num_rows(),
			"recordsFiltered" => $tasks->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function task_status_pdf_get()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$taskId = $this->input->post('p_project');
		$taskStatus = $this->input->post('p_status');

		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1) {
			$tasks = $this->Reports_model->get_task_list($taskId, $taskStatus);
		} else {
			$tasks = $this->Timesheet_model->get_employee_tasks($session['user_id']);
		}
		$data = array();

		foreach ($tasks->result() as $r) {

			// get start date
			$start_date = $this->Xin_model->set_date_format($r->start_date);
			// get end date
			$end_date = $this->Xin_model->set_date_format($r->end_date);

			//status
			if ($r->task_status == 0) {
				$status = $this->lang->line('xin_not_started');
			} else if ($r->task_status == 1) {
				$status = $this->lang->line('xin_in_progress');
			} else if ($r->task_status == 2) {
				$status = $this->lang->line('xin_completed');
			} else {
				$status = $this->lang->line('xin_deffered');
			}

			//assigned user
			if ($r->assigned_to == '') {
				$ol = $this->lang->line('xin_not_assigned');
			} else {
				$ol = '';
				$assigned_names = array();
				foreach (explode(',', $r->assigned_to) as $desig_id) {
					$assigned_to = $this->Xin_model->read_user_info($desig_id);
					if (!is_null($assigned_to)) {

						$assigned_names[] = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->last_name;
						//  $ol .= '<li>'.$assigned_name.'</li>';
					}

					$ol = implode(', ', $assigned_names);
				}
			}
			// task category
			$task_catname = $r->task_name;
			$data[] = array(
				"title" => $task_catname,
				"start_date" => $start_date,
				"end_date" => $end_date,
				"assigned_to" => $ol,
				"status" => $status,
			);
		}

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/task_report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('task_report.pdf', 'D'); //
	}

	public function project_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/projects", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$projId = $this->uri->segment(4);
		$projStatus = $this->uri->segment(5);
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1) {
			$project = $this->Reports_model->get_project_list($projId, $projStatus);
		} else {
			$project = $this->Project_model->get_employee_projects($session['user_id']);
		}
		$data = array();

		foreach ($project->result() as $r) {

			// get start date
			$start_date = $this->Xin_model->set_date_format($r->start_date);
			// get end date
			$end_date = $this->Xin_model->set_date_format($r->end_date);

			$pbar = '<p class="m-b-0-5">' . $this->lang->line('xin_completed') . ' ' . $r->project_progress . '%</p>';

			//status
			if ($r->status == 0) {
				$status = $this->lang->line('xin_not_started');
			} else if ($r->status == 1) {
				$status = $this->lang->line('xin_in_progress');
			} else if ($r->status == 2) {
				$status = $this->lang->line('xin_completed');
			} else {
				$status = $this->lang->line('xin_deffered');
			}

			// priority
			if ($r->priority == 1) {
				$priority = '<span class="tag tag-danger">' . $this->lang->line('xin_highest') . '</span>';
			} else if ($r->priority == 2) {
				$priority = '<span class="tag tag-danger">' . $this->lang->line('xin_high') . '</span>';
			} else if ($r->priority == 3) {
				$priority = '<span class="tag tag-primary">' . $this->lang->line('xin_normal') . '</span>';
			} else {
				$priority = '<span class="tag tag-success">' . $this->lang->line('xin_low') . '</span>';
			}

			//assigned user
			if ($r->assigned_to == '') {
				$ol = $this->lang->line('xin_not_assigned');
			} else {
				$ol = '';
				$assigned_names = array();
				foreach (explode(',', $r->assigned_to) as $desig_id) {
					$assigned_to = $this->Xin_model->read_user_info($desig_id);
					if (!is_null($assigned_to)) {

						$assigned_names[] = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->last_name;
						//  $ol .= $assigned_name."<br>";
					}

					$ol = implode(', ', $assigned_names);
				}
				$ol .= '';
			}
			$new_time = $this->Xin_model->actual_hours_timelog($r->project_id);

			//echo $new_time;
			$project_summary = '<div class="text-semibold"><a href="' . site_url() . 'admin/project/detail/' . $r->project_id . '">' . $r->title . '</a></div>';
			$data[] = array(
				$project_summary,
				$priority,
				$start_date,
				$end_date,
				$status,
				$pbar,
				$ol,
				$r->budget_hours,
				$new_time,

			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $project->num_rows(),
			"recordsFiltered" => $project->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function project_status_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$projId = $this->input->post('p_project');
		$projStatus = $this->input->post('p_status');

		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1) {
			$project = $this->Reports_model->get_project_list($projId, $projStatus);
		} else {
			$project = $this->Project_model->get_employee_projects($session['user_id']);
		}
		$data = array();

		foreach ($project->result() as $r) {

			// get start date
			$start_date = $this->Xin_model->set_date_format($r->start_date);
			// get end date
			$end_date = $this->Xin_model->set_date_format($r->end_date);

			$pbar = '<p class="m-b-0-5">' . $this->lang->line('xin_completed') . ' ' . $r->project_progress . '%</p>';

			//status
			if ($r->status == 0) {
				$status = $this->lang->line('xin_not_started');
			} else if ($r->status == 1) {
				$status = $this->lang->line('xin_in_progress');
			} else if ($r->status == 2) {
				$status = $this->lang->line('xin_completed');
			} else {
				$status = $this->lang->line('xin_deffered');
			}

			// priority
			if ($r->priority == 1) {
				$priority = '<span class="tag tag-danger">' . $this->lang->line('xin_highest') . '</span>';
			} else if ($r->priority == 2) {
				$priority = '<span class="tag tag-danger">' . $this->lang->line('xin_high') . '</span>';
			} else if ($r->priority == 3) {
				$priority = '<span class="tag tag-primary">' . $this->lang->line('xin_normal') . '</span>';
			} else {
				$priority = '<span class="tag tag-success">' . $this->lang->line('xin_low') . '</span>';
			}

			//assigned user
			if ($r->assigned_to == '') {
				$ol = $this->lang->line('xin_not_assigned');
			} else {
				$ol = '';
				$assigned_names = array();
				foreach (explode(',', $r->assigned_to) as $desig_id) {
					$assigned_to = $this->Xin_model->read_user_info($desig_id);
					if (!is_null($assigned_to)) {

						$assigned_names[] = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->last_name;
						//  $ol .= $assigned_name."<br>";
					}

					$ol = implode(', ', $assigned_names);
				}
				$ol .= '';
			}
			$new_time = $this->Xin_model->actual_hours_timelog($r->project_id);

			//echo $new_time;
			//$project_summary = '<div class="text-semibold"><a href="' . site_url() . 'admin/project/detail/' . $r->project_id . '">' . $r->title . '</a></div>';
			$data[] = array(
				"project_tit" => $r->title,
				"priority" => $priority,
				"start_date" => $start_date,
				"end_date" => $end_date,
				"status" => $status,
				"pbar" => $pbar,
				"project_mem" => $ol,
				"budget_hours" => $r->budget_hours,
				"actual_hours" => $new_time,

			);
		}

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/project_status_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('project_report.pdf', 'D'); //
	}

	public function training_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_training", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$cid = $_GET['company_id'];
		$uid = $_GET['user_id'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];


		$training = $this->Reports_model->get_training_list($uid, $cid, $start_date, $end_date);

		$data = array();

		foreach ($training->result() as $r) {


			// get training type
			$type = $this->Training_model->read_training_type_information($r->training_type_id);
			if (!is_null($type)) {
				$itype = $type[0]->type;
			} else {
				$itype = '--';
			}


			// get trainer
			if ($r->trainer_option == 2) {
				$trainer = $this->Trainers_model->read_trainer_information($r->trainer_id);
				// trainer full name
				if (!is_null($trainer)) {
					$trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->last_name;
				} else {
					$trainer_name = '--';
				}
			} elseif ($r->trainer_option == 1) {
				// get user > employee_
				$trainer = $this->Xin_model->read_user_info($r->trainer_id);
				// employee full name
				if (!is_null($trainer)) {
					$trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->last_name;
				} else {
					$trainer_name = '--';
				}
			} else {
				$trainer_name = '--';
			}


			// get start date
			$start_date = $this->Xin_model->set_date_format($r->start_date);
			// get end date
			$finish_date = $this->Xin_model->set_date_format($r->finish_date);
			// training date
			$training_date = $start_date . ' ' . $this->lang->line('dashboard_to') . ' ' . $finish_date;


			// set currency
			$training_cost = $this->Xin_model->company_currency_sign($r->training_cost, $r->company_id);


			if ($r->employee_id == '') {
				$ol = '--';
			} else {
				$ol = '<ol class="nl">';
				foreach (explode(',', $r->employee_id) as $uid) {
					$user = $this->Xin_model->read_user_info($uid);
					if (!is_null($user)) {
						$ol .= '<li>' . $user[0]->first_name . ' ' . $user[0]->last_name . '</li>';
					} else {
						$ol .= '--';
					}
				}
				$ol .= '</ol>';
			}


			// status
			if ($r->training_status == 0): $status = '<span class="badge badge-warning">' . $this->lang->line('xin_pending') . '</span>';
			elseif ($r->training_status == 1): $status = '<span class="badge badge-info">' . $this->lang->line('xin_started') . '</span>';
			elseif ($r->training_status == 2): $status = '<span class="badge badge-success">' . $this->lang->line('xin_completed') . '</span>';
			else: $status = '<span class="badge badge-danger">' . $this->lang->line('xin_terminated') . '</span>'; endif;


			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$iitype = '<br><small class="text-muted"><i>' . $status . '<i></i></i></small>';

			$data[] = array(
				$comp_name,
				$ol,
				$itype,
				$trainer_name,
				$training_date,
				$training_cost,
				$iitype
			);

		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $training->num_rows(),
			"recordsFiltered" => $training->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function employee_training_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;


		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$sdate = $this->input->post('p_start_date');
		$edate = $this->input->post('p_end_date');
		$uid = $this->input->post('p_employee_id');
		$cid = $this->input->post('p_company_id');

		$training = $this->Reports_model->get_training_list($uid, $cid, $sdate, $edate);

		$training_count = $this->Reports_model->get_training_list_count($uid, $cid, $sdate, $edate);

		//empty data display code start
		if (empty($training_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($training_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$training_count[$key]['header_string'] = $email_phone_address;
			$training_count[$key]['company_name'] = $company_name;
			$training_count[$key]['logo'] = $logo;
		}


		foreach ($training->result() as $r) {


			// get training type
			$type = $this->Training_model->read_training_type_information($r->training_type_id);
			if (!is_null($type)) {
				$itype = $type[0]->type;
			} else {
				$itype = '--';
			}


			// get trainer
			if ($r->trainer_option == 2) {
				$trainer = $this->Trainers_model->read_trainer_information($r->trainer_id);
				// trainer full name
				if (!is_null($trainer)) {
					$trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->last_name;
				} else {
					$trainer_name = '--';
				}
			} elseif ($r->trainer_option == 1) {
				// get user > employee_
				$trainer = $this->Xin_model->read_user_info($r->trainer_id);
				// employee full name
				if (!is_null($trainer)) {
					$trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->last_name;
				} else {
					$trainer_name = '--';
				}
			} else {
				$trainer_name = '--';
			}


			// get start date
			$start_date = $this->Xin_model->set_date_format($r->start_date);
			// get end date
			$finish_date = $this->Xin_model->set_date_format($r->finish_date);
			// training date
			$training_date = $start_date . ' ' . $this->lang->line('dashboard_to') . ' ' . $finish_date;


			// set currency
			$training_cost = $this->Xin_model->company_currency_sign($r->training_cost, $r->company_id);


			if ($r->employee_id == '') {
				$ol = '--';
			} else {
				$ol = '<ol class="nl">';
				foreach (explode(',', $r->employee_id) as $uid) {
					$user = $this->Xin_model->read_user_info($uid);
					if (!is_null($user)) {
						$ol .= '<li>' . $user[0]->first_name . ' ' . $user[0]->last_name . '</li>';
					} else {
						$ol .= '--';
					}
				}
				$ol .= '</ol>';
			}


			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}


			$data[] = array(
				'comp_name' => $comp_name,
				'ol' => $ol,
				'itype' => $itype,
				'trainer_name' => $trainer_name,
				'training_date' => $training_date,
				'training_cost' => $training_cost,
				'training_status' => $r->training_status,
				'company_id' => $r->company_id
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['training_count'] = $training_count;
		$res['from_date'] = $sdate;
		$res['to_date'] = $edate;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/employee_training_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('employee_training_report.pdf', 'D'); //
	}

	public function payroll_report_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/payroll", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$cid = $this->uri->segment(4);
		$eid = $this->uri->segment(5);
		$re_date = $this->uri->segment(6);


		$payslip_re = $this->Reports_model->get_payroll_list($cid, $eid, $re_date);

		$data = array();

		foreach ($payslip_re->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
				$emp_link = $user[0]->employee_id;

				$month_payment = date("F, Y", strtotime($r->salary_month));

				$p_amount = $this->Xin_model->company_currency_sign($r->net_salary, $r->company_id);
				if ($r->wages_type == 1) {
					$payroll_type = $this->lang->line('xin_payroll_basic_salary');
				} else {
					$payroll_type = $this->lang->line('xin_employee_daily_wages');
				}

				// get date > created at > and format
				$created_at = $this->Xin_model->set_date_format($r->created_at);

				$data[] = array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
			}
		} // if employee available

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip_re->num_rows(),
			"recordsFiltered" => $payslip_re->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// hourly_list > templates

	public function payslip_report_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$cid = $_GET['aj_company'];
		$eid = $_GET['employee_id'];
		$re_date_data = $_GET['month_year'];

		$re_date = str_replace("%20%", "-", $re_date_data);


		$payslip_re = $this->Reports_model->get_payslip_list($cid, $eid, $re_date);

		$data = array();

		foreach ($payslip_re->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
				$emp_link = $user[0]->employee_id;

				$month_payment = date("F, Y", strtotime($r->salary_month));

				$p_amount = $this->Xin_model->company_currency_sign($r->net_salary, $r->company_id);
				if ($r->wages_type == 1) {
					$payroll_type = $this->lang->line('xin_payroll_basic_salary');
				} else {
					$payroll_type = $this->lang->line('xin_employee_daily_wages');
				}

				// get date > created at > and format
				$created_at = $this->Xin_model->set_date_format($r->created_at);

				$data[] = array(
					$emp_link,
					$full_name,
					$p_amount,
					$month_payment,
					$created_at,
					$payroll_type
				);
			}
		} // if employee available

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip_re->num_rows(),
			"recordsFiltered" => $payslip_re->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function payslip_report_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$cid = $this->input->post('p_company_id');
		$eid = $this->input->post('p_employee_id');
		$re_date_data = $this->input->post('p_month');
		$re_date = str_replace("%20%", "-", $re_date_data);

		$payslip_re = $this->Reports_model->get_payslip_list($cid, $eid, $re_date);
		$data = array();

		if (!empty($cid)) {
			//$company_id_array = explode(',',$aj_company);
			$title_company_id = $cid;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------

		foreach ($payslip_re->result() as $r) {

			// get addd by > template
			$user = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
				$emp_link = $user[0]->employee_id;

				$month_payment = date("F, Y", strtotime($r->salary_month));

				$p_amount = $this->Xin_model->company_currency_sign($r->net_salary, $r->company_id);
				if ($r->wages_type == 1) {
					$payroll_type = $this->lang->line('xin_payroll_basic_salary');
				} else {
					$payroll_type = $this->lang->line('xin_employee_daily_wages');
				}

				// get date > created at > and format
				$created_at = $this->Xin_model->set_date_format($r->created_at);

				$data[] = array(
					"emp_link" => $emp_link,
					"full_name" => $full_name,
					"p_amount" => $p_amount,
					"month_payment" => $month_payment,
					"created_at" => $created_at,
					"payroll_type" => $payroll_type
				);
			}
		}

		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['main_data'] = $data;
		$res['month'] = $re_date_data;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/payslip_report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Payslip_Report.pdf', 'I');
	}


	// get company > employees
	public function get_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//rahul update

	// get department > employees

	public function get_employees_depart()
	{


		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'department_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/get_employees_depart", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	public function get_location()
	{

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'department_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/get_location", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}


	//company >> location
	public function get_com_location()
	{

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'company_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/get_com_location", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	//employee >> leave type
	public function get_leave_type()
	{

		$data['title'] = $this->Xin_model->site_title();


		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/get_leave_type");
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}


	public function get_employee_loca()
	{

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'location_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/get_employee_loca", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}


	public function get_status_dropdown()
	{

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->uri->segment(4);

		$data = array(

			'any_id' => $id

		);

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/get_status_dropdown", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));
	}

	//rahul update end

	// get company > employees
	public function get_employees_att()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/get_employees_att", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_get", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//begin increment report

	public function empdtwise_increment_list()
	{
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$start_date = $this->input->get("start_date");
		$end_date = $this->input->get("end_date");

		$this->db->order_by('id', 'asc');
		$allowances = $this->db->get('allowance');

		$main_emp_id = $this->Reports_model->empdtwise_increment_list_query($start_date, $end_date);

		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Increment Report</strong></span>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='increment_datewise_report_datatable'>
                    <table class='datatables-demo table table-striped table-bordered' id='increment_datewise_report_table'>
                          <thead>
                            <tr>
                                <th style='padding-right: 155px;'>Increment Date</th>
                                <th>Basic Salary Increment</th>";
		$this->db->order_by('id', 'asc');
		$allowances = $this->db->get('allowance');
		foreach ($allowances->result() as $r) {
			$tittle = $r->name;
			$tittle_get = strtolower($tittle);
			$table .= "<th style='text-transform: capitalize'>" . $tittle_get . " Increment</th>";
		}
		$table .= "</tr>
                          </thead>";

		foreach ($main_emp_id->result() as $emp_id) {
			$user_id = $emp_id->user_id;
			$emp_full_name = $emp_id->first_name . ' ' . $emp_id->last_name;

			$table .= "<tr style='background-color: #E0E0EB;'>
                            <th style='border-right-width: 0px;'>Employee Name : </th>
                            <th style='border-right-width: 0px;'>" . $emp_full_name . "</th>";
			$this->db->order_by('id', 'asc');
			$allowances = $this->db->get('allowance');
			foreach ($allowances->result() as $r) {
				$table .= "<th style='border-right-width: 0px;'></th>";
			}
			$table .= "</tr>";


			$sql = "SELECT * FROM `xin_employee_salary_history` WHERE date >= '$start_date-01-01' AND date <= '$end_date-12-31' AND inc_amt > 0 AND inc_or_dec != '' AND employee_id = $user_id";
			$progresses = $this->db->query($sql);

			foreach ($progresses->result() as $progress) {
				$table .= "<tr>";

				$table .= "<td><span class='text-nowrap'>" . $progress->date . "</span></td>";

				$employee = $this->Xin_model->read_employee_info($progress->employee_id)[0];

				/*if (! empty($employee)) {
				$emp_basic_salary = $employee->basic_salary;
			} else {
				$emp_basic_salary ='0';
			}

			$table .="<td>".$emp_basic_salary."</td>";*/

				$basic_salary_progress = '';

				if ($progress->history_type == 1) {
					if ($progress->inc_or_dec == 'inc') {
						$basic_salary_progress = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
					} else if ($progress->inc_or_dec == 'dec') {
						$basic_salary_progress = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
					}
				}

				if ($basic_salary_progress != '') {
					$basic_salary_progress_data = $basic_salary_progress;
				} else {
					$basic_salary_progress_data = 0;
				}

				$table .= "<td>" . $basic_salary_progress_data . "</td>";

				foreach ($allowances->result() as $allowance) {
					if ($progress->history_type == 2) {
						$this->db->where('allowance_id', $progress->allowance_id);
						$salary_allowance = $this->db->get('xin_salary_allowances')->row();

						if ($salary_allowance) {
							if ($allowance->id == $salary_allowance->allowance_title) {
								if ($progress->inc_or_dec == 'inc') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;</i>)</span>';
								} else if ($progress->inc_or_dec == 'dec') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
								}

							} else {
								$allowance_amount = '';
							}
						}
					} else if ($progress->history_type == 3) {
						$this->db->where('statutory_deductions_id', $progress->allowance_id);
						$salary_statutory_deduction = $this->db->get('xin_salary_statutory_deductions')->row();

						if ($salary_statutory_deduction) {
							if ($allowance->id == $salary_statutory_deduction->deduction_title) {
								if ($progress->inc_or_dec == 'inc') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;</i>)</span>';
								} else if ($progress->inc_or_dec == 'dec') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
								}
							} else {
								$allowance_amount = '';
							}
						}
					} else {
						$allowance_amount = '';
					}

					if ($allowance_amount != '') {

						$allowance_amount_data = $allowance_amount;

					} else {

						$allowance_amount_data = 0;

					}

					$table .= "<td>" . $allowance_amount_data . "</td>";
				}

				$table .= "</tr>";

			}

		}

		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function increment_datewise_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$start_date = $this->input->post("p_start_date");
		$end_date = $this->input->post("p_end_date");

		$progresses_main = $this->Reports_model->empdtwise_increment_list_query($start_date, $end_date);

		$progresses_company_count = $this->Reports_model->empdtwise_increment_list_query_count($start_date, $end_date);

		//empty data display code start
		if (empty($progresses_company_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($progresses_company_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$progresses_company_count[$key]['header_string'] = $email_phone_address;
			$progresses_company_count[$key]['company_name'] = $company_name;
			$progresses_company_count[$key]['logo'] = $logo;
		}


		foreach ($progresses_main->result() as $value) {

			$data[] = array(
				"user_id" => $value->user_id,
				"first_name" => $value->first_name,
				"last_name" => $value->last_name,
				"company_id" => $value->company_id
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['main_data'] = $data;
		$res['progresses_company_count'] = $progresses_company_count;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/increment_datewise_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Increment_Report.pdf', 'D'); //


	}

	//end increment report
	// daily attendance list > timesheet
	public function empdtwise_attendance_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_attendance", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$employee = $this->Xin_model->read_user_attendance_info();

		$data = array();

		foreach ($employee->result() as $r) {
			$data[] = array('', '', '', '', '', '', '', '');
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// date wise attendance list > timesheet
	public function employee_date_wise_list()
	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_attendance", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$employee_id = $this->input->get("user_id");
		$company_id = $this->input->get("company_id");
		$start_date = $this->input->get("start_date");
		$end_date = $this->input->get("end_date");

		if ($employee_id == 0) {
			$employee = $this->Xin_model->get_company_employees_new($company_id, $start_date, $end_date);
		} else if ($employee_id != 0) {
			$employee = $this->Xin_model->get_employees_com_new($employee_id, $company_id, $start_date, $end_date);
		}

		$attendance_arr = array();

		$data = array();
		$totalTimeSeconds = 0;

		foreach ($employee->result() as $r) {

			$employee_id = $r->user_id;

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '';
			}

			$attendance_date = $r->attendance_date;

			$tdate = $attendance_date;
			$clkIn = $clkOut = $attendance_date;
			$clkInLast = $clkOutLast = '-';
			$status = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('attendance_date', $attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {
				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						$status = $att->attendance_status;
						$clkIn = $att->clock_in_time;
						$clkOut = $att->clock_out_time;
						break;
					}
				}

				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						if ($clkInLast == '-')
							$clkInLast = $att->clock_in_time;

						$clkOutLast = $att->clock_out_time;
					}
				}
			}

			$total_time_l = '-';
			$total_time_e = '-';
			$overtime2 = '-';
			$total_work = '-';
			$Trest = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('date', $attendance_date);
			$totals = $this->db->get('xin_attendance_time_total');

			if ($totals->num_rows() > 0) {
				foreach ($totals->result() as $total) {
					$total_time_l = $total->late;
					$total_time_e = $total->early_leaving;
					$overtime2 = $total->overtime;
					$total_work = $total->work;
					$Trest = $total->rest;
				}
			}

			$week_day = date('l', strtotime($attendance_date));
			$week_day_lower = strtolower($week_day);

			$table_field = $week_day_lower . '_in_time';
			$this->db->where('office_shift_id', $r->office_shift_id);
			$office_shift = $this->db->get('xin_office_shift')->row();

			if ($office_shift) {
				if (trim($office_shift->$table_field) == '') {
					$status = 'Holiday';
				}
			}

			if ($status == 'Leave' || $status == 'Absent') {
				$clkInLast = $clkOutLast = '-';
			}

			if ($clkInLast != '-') {
				$clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
			}
			if ($clkOutLast != '-' && !is_null($clkOutLast)) {
				$clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
			}

			$time_arr = explode(':', $total_work);
			$total_workSeconds = 0;

			if (isset($time_arr[0])) {
				if (is_numeric($time_arr[0])) {
					$total_workSeconds += $time_arr[0] * 3600;
					$totalTimeSeconds += $time_arr[0] * 3600;
				}
			}

			if (isset($time_arr[1])) {
				if (is_numeric($time_arr[1])) {
					$total_workSeconds += $time_arr[1] * 60;
					$totalTimeSeconds += $time_arr[1] * 60;
				}
			}

			//get_emp_info
			$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
			if (!empty($employee_info)) {
				$full_name = $employee_info->first_name . " " . $employee_info->last_name;
			} else {
				$full_name = '--';
			}

			$data[] = array(
				$full_name,
				$comp_name,
				$status,
				'<span class="text-nowrap">' . $tdate . '</span>',
				'<span class="text-nowrap">' . $clkInLast . '</span>',
				'<span class="text-nowrap">' . $clkOutLast . '</span>',
				$total_work,
				$total_workSeconds,
			);
		}

		$x = gmdate("H:i:s", $totalTimeSeconds);
		$v = array('total' => $x);
		$this->db->empty_table('get_total');
		$t = $this->Reports_model->in_t($v);

		$output = array(
			"draw" => $draw,
			// "recordsTotal" => count($date_range),
			//"recordsFiltered" => count($date_range),
			"data" => $data,
			"value" => $x,
		);

		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function attendance_datewise_report_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$start_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');
		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');


		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;

			//------------------------------------------

			if ($company_id == 0) {

				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			} else {

				$company_wise_data = $this->Xin_model->company_wise_data_get($company_id);
				$company_wise_data_get = $company_wise_data[0]->logo;
				$company_name = $company_wise_data[0]->name;
				$address_1 = $company_wise_data[0]->address_1;
				$address_2 = $company_wise_data[0]->address_2;
				$city = $company_wise_data[0]->city;
				$zipcode = $company_wise_data[0]->zipcode;
				$c_info_phone = $company_wise_data[0]->contact_number;
				$c_info_email = $company_wise_data[0]->email;

				if ($company_wise_data_get) {
					$logo = '../../../../../uploads/company/' . $company_wise_data_get;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			}

			//--------------------------------------


		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		if ($employee_id == 0) {
			$employee = $this->Xin_model->get_company_employees_new($company_id, $start_date, $end_date);
		} else if ($employee_id != 0) {
			$employee = $this->Xin_model->get_employees_com_new($employee_id, $company_id, $start_date, $end_date);
		}

		$attendance_arr = array();

		$data = array();
		$totalTimeSeconds = 0;

		foreach ($employee->result() as $r) {

			$employee_id = $r->user_id;

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '';
			}

			$attendance_date = $r->attendance_date;

			$tdate = $attendance_date;
			$clkIn = $clkOut = $attendance_date;
			$clkInLast = $clkOutLast = '-';
			$status = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('attendance_date', $attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {
				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						$status = $att->attendance_status;
						$clkIn = $att->clock_in_time;
						$clkOut = $att->clock_out_time;
						break;
					}
				}

				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						if ($clkInLast == '-')
							$clkInLast = $att->clock_in_time;

						$clkOutLast = $att->clock_out_time;
					}
				}
			}

			$total_time_l = '-';
			$total_time_e = '-';
			$overtime2 = '-';
			$total_work = '-';
			$Trest = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('date', $attendance_date);
			$totals = $this->db->get('xin_attendance_time_total');

			if ($totals->num_rows() > 0) {
				foreach ($totals->result() as $total) {
					$total_time_l = $total->late;
					$total_time_e = $total->early_leaving;
					$overtime2 = $total->overtime;
					$total_work = $total->work;
					$Trest = $total->rest;
				}
			}

			$week_day = date('l', strtotime($attendance_date));
			$week_day_lower = strtolower($week_day);

			$table_field = $week_day_lower . '_in_time';
			$this->db->where('office_shift_id', $r->office_shift_id);
			$office_shift = $this->db->get('xin_office_shift')->row();

			if ($office_shift) {
				if (trim($office_shift->$table_field) == '') {
					$status = 'Holiday';
				}
			}

			if ($status == 'Leave' || $status == 'Absent') {
				$clkInLast = $clkOutLast = '-';
			}

			if ($clkInLast != '-') {
				$clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
			}
			if ($clkOutLast != '-' && !is_null($clkOutLast)) {
				$clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
			}

			$time_arr = explode(':', $total_work);
			$total_workSeconds = 0;

			if (isset($time_arr[0])) {
				if (is_numeric($time_arr[0])) {
					$total_workSeconds += $time_arr[0] * 3600;
					$totalTimeSeconds += $time_arr[0] * 3600;
				}
			}

			if (isset($time_arr[1])) {
				if (is_numeric($time_arr[1])) {
					$total_workSeconds += $time_arr[1] * 60;
					$totalTimeSeconds += $time_arr[1] * 60;
				}
			}

			//get_emp_info
			$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
			if (!empty($employee_info)) {
				$full_name = $employee_info->first_name . " " . $employee_info->last_name;
			} else {
				$full_name = '--';
			}

			$data[] = array(
				'full_name' => $full_name,
				'comp_name' => $comp_name,
				'status' => $status,
				'tdate' => '<span class="text-nowrap">' . $tdate . '</span>',
				'clkInLast' => '<span class="text-nowrap">' . $clkInLast . '</span>',
				'clkOutLast' => '<span class="text-nowrap">' . $clkOutLast . '</span>',
				'total_work' => $total_work,
				'total_workSeconds' => $total_workSeconds
			);


		}

		$total_time = $totalTimeSeconds;


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['main_data'] = $data;
		$res['from_date'] = $start_date;
		$res['to_date'] = $end_date;
		$res['total_time'] = $total_time;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/attendance_report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Attendances_Report.pdf', 'D'); //


	}

	public function total_hour_calculate()
	{
	}

	public function employee_leave_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$sd = $this->uri->segment(4);
		$ed = $this->uri->segment(5);
		$user_id = $this->uri->segment(6);
		$company_id = $this->uri->segment(7);
		if ($user_id == '') {
			$employee = $this->Reports_model->get_leave_application_list();
		} else {
			$employee = $this->Reports_model->get_leave_application_filter_list($sd, $ed, $user_id, $company_id);
		}
		$data = array();

		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			$employee = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($employee)) {
				$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
			} else {
				$full_name = '--';
			}
			//approved leave
			$rapproved = $this->Reports_model->get_approved_leave_application_list($r->employee_id);
			$approved = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Approved" data-employee_id="' . $r->employee_id . '">' . $rapproved . ' ' . $this->lang->line('xin_view') . '</a>';
			// pending leave
			$rpending = $this->Reports_model->get_pending_leave_application_list($r->employee_id);
			$pending = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Pending" data-employee_id="' . $r->employee_id . '">' . $rpending . ' ' . $this->lang->line('xin_view') . '</a>';
			//upcoming leave
			$rupcoming = $this->Reports_model->get_upcoming_leave_application_list($r->employee_id);
			$upcoming = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Upcoming" data-employee_id="' . $r->employee_id . '">' . $rupcoming . ' ' . $this->lang->line('xin_view') . '</a>';
			//rejected leave
			$rrejected = $this->Reports_model->get_rejected_leave_application_list($r->employee_id);
			$rejected = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Rejected" data-employee_id="' . $r->employee_id . '">' . $rrejected . ' ' . $this->lang->line('xin_view') . '</a>';

			$data[] = array(
				$comp_name,
				$full_name,
				$approved,
				$pending,
				$upcoming,
				$rejected,
			);
		}
		$output = array(
			"draw" => $draw,
			//"recordsTotal" => $employee->num_rows(),
			//"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function read_leave_details()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		//$result = $this->Job_post_model->read_job_application_info($id);
		$data = 'A';
		if (!empty($session)) {
			$this->load->view('admin/reports/dialog_leave_details', $data);
		} else {
			redirect('admin/');
		}
	}

	public function payroll()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = 'Montly Pay Sheet | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = 'Montly Pay Sheet';

		$data['path_url'] = 'reports_payslip';

		$data['all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();


		if (in_array('111', $role_resources_ids)) {

			$data['subview'] = $this->load->view("admin/reports/payroll", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard');
		}
	}

	public function payroll_report()

	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');


		if (!empty($session)) {

			$this->load->view("admin/reports/payroll", $data);
		} else {

			redirect('admin/');
		}


		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));


		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$employee_id = $_GET['employee_id'];
		$month_year = $_GET['month_year'];


		$payslip_re = $this->Reports_model->get_payslip($aj_company, $aj_department, $employee_id, $month_year);

		//print_r($payslip_re);exit;

		$payslip_demo_data = $this->demo_data();

		$data_filtered = array();


		$data = array();

		if (count($payslip_re) > 0) {

			foreach ($payslip_re as $value) {

				$employee = $this->Reports_model->read_employee_info($value->employee_id);

				if (!is_null($employee)) {

					$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

					$emp_id = $employee[0]->employee_id;

					$date_of_joining = $employee[0]->date_of_joining;

					$basic_salary = $employee[0]->basic_salary;
				} else {

					$full_name = '--';

					$emp_id = '--';

					$date_of_joining = '--';

					$basic_salary = '--';
				}

				$month_year = $month_year;

				$date = strtotime(date("Y-m-d"));

				if (!isset($month_year)) {

					$day = date('d', $date);

					$month = date('m', $date);

					$year = date('Y', $date);

					$month_year = date('Y-m');
				} else {

					$imonth_year = explode('-', $month_year);

					$day = date('d', $date);

					$month = date($imonth_year[1], $date);

					$year = date($imonth_year[0], $date);

					$month_year = $month_year;
				}


				$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

				$start_date_y_m = date('Y-m', strtotime($month_year));

				$work_day = $this->Reports_model->work_day($year, $month);


				$emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);

				if ($emp_leave_in_month != '') {

					$lop = $emp_leave_in_month[0]->monthly_leaves;
				} else {

					$lop = '--';
				}


				// department
				$department = $this->Department_model->read_department_information($value->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($value->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// Employee Account
				$account_id = $this->Reports_model->emp_bank_account($value->employee_id);
				if (!is_null($account_id)) {
					$account_number = $account_id[0]->account_number;
				} else {
					$account_number = '--';
				}


				//test
				$sql1 = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ?';
				$binds1 = array($value->employee_id);
				$payslip_allowance = $this->db->query($sql1, $binds1)->row();

				if (!empty($payslip_allowance)) {
					$amount1 = $payslip_allowance->allowance_amount;
				} else {
					$amount1 = '0';
				}

				$sql2 = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ?';
				$binds2 = array($value->employee_id);
				$payslip_commission = $this->db->query($sql2, $binds2)->row();

				if (!empty($payslip_commission)) {
					$amount2 = $payslip_commission->commission_amount;
				} else {
					$amount2 = '0';
				}

				$sql3 = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ?';
				$binds3 = array($value->employee_id);
				$payslip_other_payments = $this->db->query($sql3, $binds3)->row();

				if (!empty($payslip_other_payments)) {
					$amount3 = $payslip_other_payments->payments_amount;
				} else {
					$amount3 = '0';
				}

				$month_total_allo = $value->basic_salary + $amount1 + $amount2 + $amount3;


				$tmp = array(

					$emp_id,

					$full_name,

					$department_name,

					$designation_name,

					$account_number,

					$date_of_joining,

					$value->net_salary,

					$value->basic_salary,

					// $daysInMonth,

					$lop,

					//$work_day,

					$value->monthy_present_days

				);


				$gross_salary = $value->basic_salary;


				$allowances = $this->db->get('allowance');


				foreach ($allowances->result() as $allowance) {

					if ($allowance->type_id == 1) {

						$sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';

						$binds = array($value->employee_id, $allowance->id, $month_year);

						$payslip_allowance = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_allowance)) {

							$amount = $payslip_allowance->allowance_amount;

							$gross_salary += $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 2) {

						$sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and commission_title=? and salary_month=?';

						$binds = array($value->employee_id, $allowance->id, $month_year);

						$payslip_commission = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_commission)) {

							$amount = $payslip_commission->commission_amount;

							$gross_salary += $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 3) {

						$sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and deduction_title=? and salary_month=?';

						$binds = array($value->employee_id, $allowance->id, $month_year);

						$statutory_deduction = $this->db->query($sql, $binds)->row();


						if (!empty($statutory_deduction)) {

							$amount = $statutory_deduction->deduction_amount;

							$gross_salary -= $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 4) {

						$sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';

						$binds = array($value->employee_id, $month_year);

						$payslip_other_payments = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_other_payments)) {

							$amount = $payslip_other_payments->payments_amount;

							$gross_salary += $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 5) {

						$sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';

						$binds = array($value->employee_id, $month_year);

						$payslip_loan = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_loan)) {

							$amount = $payslip_loan->loan_amount;

							$gross_salary -= $amount;
						} else

							$amount = '--';
					}


					array_push($tmp, $amount);
				}

				//late deduction
				$emp_main_id = $value->employee_id;
				$sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

				$late_deduction_data = $this->db->query($sql_late)->row();
				if (!empty($late_deduction_data)) {
					$late_deduction_data_get = $late_deduction_data->total_late_deduction;
				} else {
					$late_deduction_data_get = '0';
				}

				array_push(
					$tmp,

					$value->amt_leave_encashment,

					$value->total_other_payments,

					$value->total_overtime,

					$value->advance_salary_amount,

					$value->amt_indemnity,

					$late_deduction_data_get,

					$value->leave_deduction,

					$value->net_salary

				);


				$data[] = $tmp;
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);


		echo json_encode($output);

		exit();
	}

	public function payroll_report_bk18()
	{
		error_reporting(E_ALL);
		ini_set("display_errors", "On");

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		if (!empty($session)) {
			$this->load->view("admin/reports/payroll", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$cid = $this->uri->segment(4);
		$eid = $this->uri->segment(5);
		$re_date = $this->uri->segment(6);

		$payslip_re = $this->Reports_model->get_payslip($cid, $eid, $re_date);
		//print_r($payslip_re);exit;
		$payslip_demo_data = $this->demo_data();
		$data_filtered = array();

		$data = array();
		if (count($payslip_re) > 0) {
			foreach ($payslip_re as $value) {
				$employee = $this->Reports_model->read_employee_info($value->employee_id);
				if (!is_null($employee)) {
					$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
					$emp_id = $employee[0]->employee_id;
					$date_of_joining = $employee[0]->date_of_joining;
					$basic_salary = $employee[0]->basic_salary;
				} else {
					$full_name = '--';
					$emp_id = '--';
					$date_of_joining = '--';
					$basic_salary = '--';
				}
				$month_year = $re_date;
				$date = strtotime(date("Y-m-d"));
				if (!isset($month_year)) {
					$day = date('d', $date);
					$month = date('m', $date);
					$year = date('Y', $date);
					$month_year = date('Y-m');
				} else {
					$imonth_year = explode('-', $month_year);
					$day = date('d', $date);
					$month = date($imonth_year[1], $date);
					$year = date($imonth_year[0], $date);
					$month_year = $month_year;
				}

				$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
				$start_date_y_m = date('Y-m', strtotime($month_year));
				$work_day = $this->Reports_model->work_day($year, $month);

				// print_r($work_day);exit;
				/*$hra=$this->Reports_model->hra($value->employee_id,11,$month_year);
                      if($hra!=''){
                          $hra_amount=$hra[0]->allowance_amount;
                      }else{
                          $hra_amount='--';
                      }
                      $medi=$this->Reports_model->medi($value->employee_id,1,$month_year);
                      if($medi!=''){
                          $medi_amount=$medi[0]->allowance_amount;
                      }else{
                          $medi_amount='--';
                      }
                      $car=$this->Reports_model->car($value->employee_id,12,$month_year);
                      if($car!=''){
                          $car_amount=$car[0]->allowance_amount;
                      }else{
                          $car_amount='--';
                      }$mob=$this->Reports_model->mob($value->employee_id,13,$month_year);
                      if($mob!=''){
                          $mob_amount=$mob[0]->allowance_amount;
                      }else{
                          $mob_amount='--';
                      }$fuel=$this->Reports_model->fuel($value->employee_id,14,$month_year);
                      if($fuel!=''){
                          $fuel_amount=$fuel[0]->allowance_amount;
                      }else{
                          $fuel_amount='--';
                      }$tran=$this->Reports_model->tran($value->employee_id,15,$month_year);
                      if($tran!=''){
                          $tran_amount=$tran[0]->allowance_amount;
                      }else{
                          $tran_amount='--';
                      }*/


				$emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);
				if ($emp_leave_in_month != '') {
					$lop = $emp_leave_in_month[0]->monthly_leaves;
				} else {
					$lop = '--';
				}


				$tmp = array(
					$emp_id,
					$full_name,
					$date_of_joining,
					$daysInMonth,
					$lop,
					//$work_day,
					$value->monthy_present_days,
					$value->basic_salary
				);

				$gross_salary = $value->basic_salary;

				$allowances = $this->db->get('allowance');

				foreach ($allowances->result() as $allowance) {
					if ($allowance->type_id == 1) {
						$sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';
						$binds = array($value->employee_id, $allowance->id, $month_year);
						$payslip_allowance = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_allowance)) {
							$amount = $payslip_allowance->allowance_amount;
							$gross_salary += $amount;
						} else
							$amount = '--';
					} else if ($allowance->type_id == 2) {
						$sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and commission_title=? and salary_month=?';
						$binds = array($value->employee_id, $allowance->id, $month_year);
						$payslip_commission = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_commission)) {
							$amount = $payslip_commission->commission_amount;
							$gross_salary += $amount;
						} else
							$amount = '--';
					} else if ($allowance->type_id == 3) {
						$sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and deduction_title=? and salary_month=?';
						$binds = array($value->employee_id, $allowance->id, $month_year);
						$statutory_deduction = $this->db->query($sql, $binds)->row();

						if (!empty($statutory_deduction)) {
							$amount = $statutory_deduction->deduction_amount;
							$gross_salary -= $amount;
						} else
							$amount = '--';
					} else if ($allowance->type_id == 4) {
						$sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';
						$binds = array($value->employee_id, $month_year);
						$payslip_other_payments = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_other_payments)) {
							$amount = $payslip_other_payments->payments_amount;
							$gross_salary += $amount;
						} else
							$amount = '--';
					} else if ($allowance->type_id == 5) {
						$sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';
						$binds = array($value->employee_id, $month_year);
						$payslip_loan = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_loan)) {
							$amount = $payslip_loan->loan_amount;
							$gross_salary -= $amount;
						} else
							$amount = '--';
					}

					array_push($tmp, $amount);
				}

				array_push(
					$tmp,
					$value->amt_leave_encashment,
					$value->total_other_payments,
					$value->total_overtime,
					$value->total_late_deduction,
					$value->advance_salary_amount,
					$value->amt_indemnity,
					$value->leave_deduction,
					$value->net_salary
				);

				$data[] = $tmp;
			}
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => count($data),
			"recordsFiltered" => count($data),
			"data" => $data
		);

		echo json_encode($output);
		exit();
	}

	function demo_data()
	{
		$data[1]['2021-02'][7] = array(
			'614185',
			'Anu K',
			'01-03-2019',
			'31',
			'',
			'26',
			'200.000',
			'10.000',
			'5.000',
			'20.000',
			'10.000',
			'10.000',
			'',
			'',
			'',
			'255.000',
			'',
			'2.000',
			'',
			'',
			'2.000',
			'253.000'
		);

		$data[1]['2021-02'][8] = array(
			'987180',
			'Aryasree P S',
			'15-05-2018',
			'31',
			'',
			'26',
			'250.000',
			'10.000',
			'',
			'20.000',
			'',
			'10.000',
			'',
			'',
			'',
			'290.000',
			'15.000',
			'2.500',
			'',
			'',
			'17.500',
			'272.500'
		);

		$data[1]['2021-02'][9] = array(
			'987181',
			'Adwaith P',
			'05-01-2019',
			'31',
			'',
			'26',
			'100.000',
			'10.000',
			'',
			'',
			'',
			'',
			'5.000',
			'',
			'',
			'115.000',
			'',
			'7.000',
			'5.000',
			'',
			'12.000',
			'103.000'
		);

		$data[1]['2021-02'][10] = array(
			'987182',
			'Arjun K',
			'06-08-2018',
			'31',
			'',
			'26',
			'150.000',
			'10.000',
			'5.000',
			'20.000',
			'',
			'10.000',
			'',
			'',
			'',
			'195.000',
			'',
			'1.500',
			'',
			'',
			'1.500',
			'193.500'
		);

		$data[1]['2021-02'][11] = array(
			'440759',
			'Manu Yadav',
			'06-12-2015',
			'31',
			'',
			'26',
			'200.000',
			'10.000',
			'',
			'20.000',
			'',
			'10.000',
			'',
			'',
			'',
			'240.000',
			'',
			'14.000',
			'5.000',
			'',
			'19.000',
			'221.000'
		);

		$data[1]['2021-02'][12] = array(
			'440760',
			'Kavya P',
			'04-10-2020',
			'31',
			'',
			'23',
			'300.000',
			'10.000',
			'',
			'',
			'',
			'',
			'5.000',
			'',
			'',
			'315.000',
			'',
			'3.00',
			'',
			'',
			'3.000',
			'312.000'
		);

		$data[1]['2021-03'][7] = array(
			'614185',
			'Anu K',
			'09-11-2019',
			'31',
			'',
			'26',
			'200.000',
			'10.000',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'210.000',
			'',
			'2.000',
			'',
			'',
			'2.000',
			'208.000'
		);

		$data[1]['2021-03'][8] = array(
			'987180',
			'Aryasree P S',
			'14-12-2020',
			'31',
			'',
			'24',
			'150.000',
			'10.000',
			'5.000',
			'',
			'',
			'',
			'5.000',
			'',
			'',
			'170.000',
			'10.000',
			'1.500',
			'',
			'',
			'11.500',
			'158.500'
		);

		$data[1]['2021-03'][9] = array(
			'987181',
			'Adwaith P',
			'13-02-2011',
			'31',
			'',
			'26',
			'150.000',
			'10.000',
			'',
			'',
			'10.000',
			'',
			'',
			'',
			'',
			'170.000',
			'',
			'10.500',
			'5.000',
			'',
			'15.500',
			'154.500'
		);

		$data[1]['2021-03'][10] = array(
			'987182',
			'Arjun K',
			'16-08-2016',
			'31',
			'',
			'25',
			'250.000',
			'10.000',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'260.000',
			'',
			'2.500',
			'',
			'',
			'2.500',
			'257.500'
		);

		$data[1]['2021-03'][11] = array(
			'440759',
			'Manu Yadav',
			'14-12-2020',
			'31',
			'',
			'26',
			'250.000',
			'10.000',
			'',
			'',
			'10.000',
			'',
			'5.000',
			'',
			'',
			'275.000',
			'',
			'2.500',
			'',
			'',
			'2.500',
			'272.500'
		);

		$data[1]['2021-03'][12] = array(
			'440760',
			'Kavya P',
			'09-11-2019',
			'31',
			'',
			'20',
			'250.000',
			'10.000',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'260.000',
			'',
			'2.500',
			'',
			'',
			'2.500',
			'257.500'
		);

		return $data;
	}

	public function employee_annual_leave()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_annual_leave_status') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_annual_leave_status');
		$data['path_url'] = 'reports_employee_leave_annual';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('269', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/employee_annual_leave", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_annual_leave_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_annual_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$sd = $this->uri->segment(4);
		$ed = $this->uri->segment(5);
		$user_id = $this->uri->segment(6);
		$company_id = $this->uri->segment(7);
		if ($user_id == '') {
			$employee = $this->Reports_model->get_annual_leave_application_list();
		} else {
			$employee = $this->Reports_model->get_annual_leave_application_filter_list($sd, $ed, $user_id, $company_id);
		}
		$data = array();
		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			$employee = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($employee)) {
				$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
			} else {
				$full_name = '--';
			}
			//approved leave
			$rapproved = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 2);
			$approved = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Approved" data-employee_id="' . $r->employee_id . '">' . $rapproved . ' ' . $this->lang->line('xin_view') . '</a>';
			// pending leave
			$rpending = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 1);
			$pending = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Pending" data-employee_id="' . $r->employee_id . '">' . $rpending . ' ' . $this->lang->line('xin_view') . '</a>';
			//upcoming leave
			$rupcoming = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 4);
			$upcoming = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Upcoming" data-employee_id="' . $r->employee_id . '">' . $rupcoming . ' ' . $this->lang->line('xin_view') . '</a>';
			//rejected leave
			$rrejected = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 3);
			$rejected = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Rejected" data-employee_id="' . $r->employee_id . '">' . $rrejected . ' ' . $this->lang->line('xin_view') . '</a>';

			$data[] = array(
				$comp_name,
				$full_name,
				$approved,
				$pending,
				$upcoming,
				$rejected,
			);
		}
		$output = array(
			"draw" => $draw,
			//"recordsTotal" => $employee->num_rows(),
			//"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function detailed_report()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_reports_attendance_employee') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Detailed  ' . $this->lang->line('xin_hr_reports_attendance_employee');
		$data['path_url'] = 'reports_detailed_attendance';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('112', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/detailed_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_detailed_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if (!empty($session)) {
			$this->load->view("admin/reports/detailed_report", $data);
		} else {
			redirect('admin/');
		}
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$attendance_date = $this->input->get("attendance_date");
		$ref_location_id = $this->input->get("location_id");

		$employee_id = $this->input->get("user_id");
		$company_id = $this->input->get("company_id");

		$system = $this->Xin_model->read_setting_info(1);
		$start_date = $this->input->get("start_date");
		$end_date = $this->input->get("end_date");

		if ($employee_id == 0) {
			$employee = $this->Xin_model->get_company_employees_new($company_id, $start_date, $end_date);
		} else if ($employee_id != 0) {
			$employee = $this->Xin_model->get_employees_com_new($employee_id, $company_id, $start_date, $end_date);
		}

		$attendance_arr = array();

		$data = array();
		$company_names = array();

		foreach ($employee->result() as $r) {
			if ($r->user_role_id == 1)
				continue;


			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '';
			}

			//get_emp_info
			$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
			if (!empty($employee_info)) {
				$full_name = $employee_info->first_name . " " . $employee_info->last_name;
				$emp_code = $employee_info->employee_id;
			} else {
				$full_name = '--';
				$emp_code = '--';
			}


			$employee_details = '<strong class="text-nowrap">' . $full_name . '</strong>';
			$employee_details .= '<br>';
			$employee_details .= '<span class="text-muted small text-truncate">' . $emp_code . '</span>';
			$employee_details .= '<br>';
			$employee_details .= '<span class="text-muted small text-nowrap">' . $comp_name . '</span>';

			$employee_id = $r->user_id;


			$attendance_date = $r->attendance_date;


			$tdate = $attendance_date;
			$clkIn = $clkOut = $attendance_date;
			$clkInLast = $clkOutLast = '-';
			$status = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('attendance_date', $attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {
				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						$status = $att->attendance_status;
						$clkIn = $att->clock_in_time;
						$clkOut = $att->clock_out_time;
						break;
					}
				}

				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						if ($clkInLast == '-')
							$clkInLast = $att->clock_in_time;

						$clkOutLast = $att->clock_out_time;
					}
				}
			}

			$total_time_l = '-';
			$total_time_e = '-';
			$overtime2 = '-';
			$total_work = '-';
			$Trest = '-';

			$this->db->where('employee_id', $r->user_id);
			$this->db->where('date', $attendance_date);
			$totals = $this->db->get('xin_attendance_time_total');

			if ($totals->num_rows() > 0) {
				foreach ($totals->result() as $total) {
					$total_time_l = $total->late;
					$total_time_e = $total->early_leaving;
					$overtime2 = $total->overtime;
					$total_work = $total->work;
					$Trest = $total->rest;
				}
			}

			$week_day = date('l', strtotime($attendance_date));
			$week_day_lower = strtolower($week_day);

			$table_field = $week_day_lower . '_in_time';
			$this->db->where('office_shift_id', $r->office_shift_id);
			$office_shift = $this->db->get('xin_office_shift')->row();

			if ($office_shift) {
				if (trim($office_shift->$table_field) == '') {
					$status = 'Holiday';
				}
			}

			if ($status == 'Leave' || $status == 'Absent') {
				$clkInLast = $clkOutLast = '-';
			}

			if ($clkInLast != '-') {
				$clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
			}
			if ($clkOutLast != '-' && !is_null($clkOutLast)) {
				$clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
			}

			$data[] = array(
				$employee_details,
				$status,
				'<span class="text-nowrap">' . $tdate . '</span>',
				'<span class="text-nowrap">' . $clkInLast . '</span>',
				'<span class="text-nowrap">' . $clkOutLast . '</span>',
				$total_time_l,
				$total_time_e,
				$total_work,
				$Trest
			);

		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function detailed_attendance_datewise_report_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$start_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');
		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');


		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;

			//------------------------------------------

			if ($company_id == 0) {

				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			} else {

				$company_wise_data = $this->Xin_model->company_wise_data_get($company_id);
				$company_wise_data_get = $company_wise_data[0]->logo;
				$company_name = $company_wise_data[0]->name;
				$address_1 = $company_wise_data[0]->address_1;
				$address_2 = $company_wise_data[0]->address_2;
				$city = $company_wise_data[0]->city;
				$zipcode = $company_wise_data[0]->zipcode;
				$c_info_phone = $company_wise_data[0]->contact_number;
				$c_info_email = $company_wise_data[0]->email;

				if ($company_wise_data_get) {
					$logo = '../../../../../uploads/company/' . $company_wise_data_get;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			}

			//--------------------------------------


		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		if ($employee_id == 0) {
			$employee = $this->Xin_model->get_company_employees_new($company_id, $start_date, $end_date);
		} else if ($employee_id != 0) {
			$employee = $this->Xin_model->get_employees_com_new($employee_id, $company_id, $start_date, $end_date);
		}

		$attendance_arr = array();

		$data = array();
		$company_names = array();

		foreach ($employee->result() as $r) {
			if ($r->user_role_id == 1)
				continue;


			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '';
			}

			//get_emp_info
			$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
			if (!empty($employee_info)) {
				$full_name = $employee_info->first_name . " " . $employee_info->last_name;
				$emp_code = $employee_info->employee_id;
			} else {
				$full_name = '--';
				$emp_code = '--';
			}


			$employee_details = '<strong class="text-nowrap">' . $full_name . '</strong>';
			$employee_details .= '<br>';
			$employee_details .= '<span class="text-muted small text-truncate">' . $emp_code . '</span>';
			$employee_details .= '<br>';
			$employee_details .= '<span class="text-muted small text-nowrap">' . $comp_name . '</span>';

			$employee_id = $r->user_id;


			$attendance_date = $r->attendance_date;


			$tdate = $attendance_date;
			$clkIn = $clkOut = $attendance_date;
			$clkInLast = $clkOutLast = '-';
			$status = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('attendance_date', $attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {
				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						$status = $att->attendance_status;
						$clkIn = $att->clock_in_time;
						$clkOut = $att->clock_out_time;
						break;
					}
				}

				foreach ($attendance->result() as $att) {
					if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
						if ($clkInLast == '-')
							$clkInLast = $att->clock_in_time;

						$clkOutLast = $att->clock_out_time;
					}
				}
			}

			$total_time_l = '-';
			$total_time_e = '-';
			$overtime2 = '-';
			$total_work = '-';
			$Trest = '-';

			$this->db->where('employee_id', $r->user_id);
			$this->db->where('date', $attendance_date);
			$totals = $this->db->get('xin_attendance_time_total');

			if ($totals->num_rows() > 0) {
				foreach ($totals->result() as $total) {
					$total_time_l = $total->late;
					$total_time_e = $total->early_leaving;
					$overtime2 = $total->overtime;
					$total_work = $total->work;
					$Trest = $total->rest;
				}
			}

			$week_day = date('l', strtotime($attendance_date));
			$week_day_lower = strtolower($week_day);

			$table_field = $week_day_lower . '_in_time';
			$this->db->where('office_shift_id', $r->office_shift_id);
			$office_shift = $this->db->get('xin_office_shift')->row();

			if ($office_shift) {
				if (trim($office_shift->$table_field) == '') {
					$status = 'Holiday';
				}
			}

			if ($status == 'Leave' || $status == 'Absent') {
				$clkInLast = $clkOutLast = '-';
			}

			if ($clkInLast != '-') {
				$clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
			}
			if ($clkOutLast != '-' && !is_null($clkOutLast)) {
				$clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
			}

			$data[] = array(
				'employee_details' => $employee_details,
				'status' => $status,
				'tdate' => '<span class="text-nowrap">' . $tdate . '</span>',
				'clkInLast' => '<span class="text-nowrap">' . $clkInLast . '</span>',
				'clkOutLast' => '<span class="text-nowrap">' . $clkOutLast . '</span>',
				'total_time_l' => $total_time_l,
				'total_time_e' => $total_time_e,
				'total_work' => $total_work,
				'Trest' => $Trest
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['main_data'] = $data;
		$res['from_date'] = $start_date;
		$res['to_date'] = $end_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/detailed_datewise_attendance_report", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Detailed_Attendances_Report.pdf', 'D'); //

	}

	public function new_report()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'New Attendances Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'New Attendances Report';
		$data['path_url'] = 'new_attendances_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('112', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/new_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function new_detailed_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if (!empty($session)) {
			$this->load->view("admin/reports/new_report", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$employee_id = $this->input->get("user_id");
		$company_id = $this->input->get("company_id");
		$start_date = $this->input->get("start_date");
		$end_date = $this->input->get("end_date");
		//$employee = $this->Xin_model->read_user_info($employee_id);

		//	$employee = $this->Xin_model->read_user_info($employee_id);

		if ($employee_id == 0) {
			$employee = $this->Xin_model->get_company_employees_new($company_id, $start_date, $end_date);
		} else if ($employee_id != 0) {
			$employee = $this->Xin_model->get_employees_com_new($employee_id, $company_id, $start_date, $end_date);
		}


		$data = array();
		$company_names = array();

		foreach ($employee->result() as $r) {
			$old_item = '';

			$getdatas = $this->Timesheet_model->get_datas($this->input->get("start_date"), $r->user_id, $this->input->get("end_date"));

			if ($r->user_role_id == 1)
				continue;

			foreach ($getdatas as $get_datas) {
				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				// get company
				if (!isset($company_names[$r->company_id])) {
					$company = $this->Xin_model->read_company_info($r->company_id);
					$company_names[$r->company_id] = $company[0]->name;
				}

				if (!is_null($company_names[$r->company_id])) {
					$comp_name = $company_names[$r->company_id];
				} else {
					$comp_name = '--';
				}
				$date = $get_datas->attendance_date;
				$timetable = $get_datas->timetable;
				if ($timetable == '') {
					$time_table = '--';
				} else {
					$time_table = $get_datas->timetable;
				}
				$onduty = $get_datas->on_duty;
				if ($onduty == '' || $onduty == 'Null') {
					$on_duty = 'NULL';
				} else {
					$on_duty = $get_datas->on_duty;
				}
				$offduty = $get_datas->off_duty;
				if ($offduty == '' || $offduty == 'Null') {
					$off_duty = '--';
				} else {
					$off_duty = $get_datas->off_duty;
				}
				$late = $get_datas->late;
				if ($late == '' || $late == 'Null') {
					$late_time = '--';
				} else {
					$late_time = $get_datas->late;
				}
				$absent = $get_datas->absent;
				if ($absent == '' || $absent == 'Null') {
					$absent_time = '--';
				} elseif ($absent == '1') {
					$absent_time = "TRUE";
				} else {
					$absent_time = $get_datas->absent;
				}
				if ($absent_time == 'NULL')
					$absent_time = '--';
				if ($get_datas->clock_in == '') {
					$clock_in2 = '-';
				} else {
					$clock_in = new DateTime($get_datas->clock_in);//print_r($get_datas->clock_in);
					$splitTimeStamp = explode(" ", $get_datas->clock_in);
					if ($splitTimeStamp[1] != '') {
						$clock_in2 = $clock_in->format('h:i A');
						$clkInIp = $clock_in2;

					} elseif ($splitTimeStamp[1] == '') {
						$clkInIp = '-';
						$clock_in2 = '-';
					} else {
						$clock_in2 = '--';
					}
				}
				if ($get_datas->clock_in == '') {
					$clock_out2 = '-';
				} else {
					$clock_out = new DateTime($get_datas->clock_out);//print_r($clock_in);
					$split = explode(" ", $get_datas->clock_out);
					if (isset($split[1])) {
						$clock_out2 = $clock_out->format('h:i A');
						$clkoutIp = $clock_out2;
					} elseif (!isset($split[1])) {
						$clkoutIp = '-';
						$clock_out2 = '-';
					} else {
						$clock_out2 = '--';
					}
				}

				$current_item = $r->user_id . "-" . $date;

				if ($current_item != $old_item) {
					$this->db->where('employee_id', $r->user_id);
					$this->db->where('date', $date);
					$totals = $this->db->get('xin_attendance_time_total');

					if ($totals->num_rows() > 0) {
						foreach ($totals->result() as $total) {
							$total_work = $total->work;
							$late_time = $total->late;
						}
					}
				}

				if ($late_time == '00:00')
					$late_time = '--';

				$old_item = $current_item;

				if ($clock_in2 != '-') {
					if ($clock_out2 != '-') {
						if (strtotime($clock_out2) <= strtotime($clock_in2)) {
							$clock_out2 = '--';
						}
					}
				}

				$data[] = array(
					$r->employee_code,
					'<strong>' . $full_name . '</strong><br>
				<span class="small text-muted">' . $comp_name . '</span>',
					'<span class="text-nowrap">' . $date . '</span>',
					ucfirst($time_table),
					$on_duty,
					$off_duty,
					'<span class="text-nowrap">' . $clock_in2 . '</span>',
					'<span class="text-nowrap">' . $clock_out2 . '</span>',
					//$total_work
					$late_time,
					$absent_time,
				);
			}
		}
		$output = array(
			"draw" => $draw,
			//"recordsTotal" => count($date_range),
			//"recordsFiltered" => count($date_range),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function attendance_datewise_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$start_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');
		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');

		$data = array();


		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;

			//------------------------------------------

			if ($company_id == 0) {

				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			} else {

				$company_wise_data = $this->Xin_model->company_wise_data_get($company_id);
				$company_wise_data_get = $company_wise_data[0]->logo;
				$company_name = $company_wise_data[0]->name;
				$address_1 = $company_wise_data[0]->address_1;
				$address_2 = $company_wise_data[0]->address_2;
				$city = $company_wise_data[0]->city;
				$zipcode = $company_wise_data[0]->zipcode;
				$c_info_phone = $company_wise_data[0]->contact_number;
				$c_info_email = $company_wise_data[0]->email;

				if ($company_wise_data_get) {
					$logo = '../../../../../uploads/company/' . $company_wise_data_get;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			}

			//--------------------------------------


		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		if ($employee_id == 0) {
			$employee = $this->Xin_model->get_company_employees_new($company_id, $start_date, $end_date);
		} else if ($employee_id != 0) {
			$employee = $this->Xin_model->get_employees_com_new($employee_id, $company_id, $start_date, $end_date);
		}


		$company_names = array();

		foreach ($employee->result() as $r) {
			$old_item = '';

			$getdatas = $this->Timesheet_model->get_datas($start_date, $r->user_id, $end_date);

			if ($r->user_role_id == 1)
				continue;

			foreach ($getdatas as $get_datas) {
				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				// get company
				if (!isset($company_names[$r->company_id])) {
					$company = $this->Xin_model->read_company_info($r->company_id);
					$company_names[$r->company_id] = $company[0]->name;
				}

				if (!is_null($company_names[$r->company_id])) {
					$comp_name = $company_names[$r->company_id];
				} else {
					$comp_name = '--';
				}
				$date = $get_datas->attendance_date;
				$timetable = $get_datas->timetable;
				if ($timetable == '') {
					$time_table = '--';
				} else {
					$time_table = $get_datas->timetable;
				}
				$onduty = $get_datas->on_duty;
				if ($onduty == '' || $onduty == 'Null') {
					$on_duty = 'NULL';
				} else {
					$on_duty = $get_datas->on_duty;
				}
				$offduty = $get_datas->off_duty;
				if ($offduty == '' || $offduty == 'Null') {
					$off_duty = '--';
				} else {
					$off_duty = $get_datas->off_duty;
				}
				$late = $get_datas->late;
				if ($late == '' || $late == 'Null') {
					$late_time = '--';
				} else {
					$late_time = $get_datas->late;
				}
				$absent = $get_datas->absent;
				if ($absent == '' || $absent == 'Null') {
					$absent_time = '--';
				} elseif ($absent == '1') {
					$absent_time = "TRUE";
				} else {
					$absent_time = $get_datas->absent;
				}
				if ($absent_time == 'NULL')
					$absent_time = '--';
				if ($get_datas->clock_in == '') {
					$clock_in2 = '-';
				} else {
					$clock_in = new DateTime($get_datas->clock_in);//print_r($get_datas->clock_in);
					$splitTimeStamp = explode(" ", $get_datas->clock_in);
					if ($splitTimeStamp[1] != '') {
						$clock_in2 = $clock_in->format('h:i A');
						$clkInIp = $clock_in2;

					} elseif ($splitTimeStamp[1] == '') {
						$clkInIp = '-';
						$clock_in2 = '-';
					} else {
						$clock_in2 = '--';
					}
				}
				if ($get_datas->clock_in == '') {
					$clock_out2 = '-';
				} else {
					$clock_out = new DateTime($get_datas->clock_out);//print_r($clock_in);
					$split = explode(" ", $get_datas->clock_out);
					if (isset($split[1])) {
						$clock_out2 = $clock_out->format('h:i A');
						$clkoutIp = $clock_out2;
					} elseif (!isset($split[1])) {
						$clkoutIp = '-';
						$clock_out2 = '-';
					} else {
						$clock_out2 = '--';
					}
				}

				$current_item = $r->user_id . "-" . $date;

				if ($current_item != $old_item) {
					$this->db->where('employee_id', $r->user_id);
					$this->db->where('date', $date);
					$totals = $this->db->get('xin_attendance_time_total');

					if ($totals->num_rows() > 0) {
						foreach ($totals->result() as $total) {
							$total_work = $total->work;
							$late_time = $total->late;
						}
					}
				}

				if ($late_time == '00:00')
					$late_time = '--';

				$old_item = $current_item;

				if ($clock_in2 != '-') {
					if ($clock_out2 != '-') {
						if (strtotime($clock_out2) <= strtotime($clock_in2)) {
							$clock_out2 = '--';
						}
					}
				}


				$data[] = array(
					'employee_code' => $r->employee_code,
					'emp_info' => '<strong>' . $full_name . '</strong><br>
			        			   <span class="small text-muted">' . $comp_name . '</span>',
					'date' => '<span class="text-nowrap">' . $date . '</span>',
					'time_table' => ucfirst($time_table),
					'on_duty' => $on_duty,
					'off_duty' => $off_duty,
					'clock_in2' => '<span class="text-nowrap">' . $clock_in2 . '</span>',
					'clock_out2' => '<span class="text-nowrap">' . $clock_out2 . '</span>',
					'late_time' => $late_time,
					'absent_time' => $absent_time
				);
			}
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['main_data'] = $data;
		$res['from_date'] = $start_date;
		$res['to_date'] = $end_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/detailed_new_attendance_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Detailed_New_Attendances_Report.pdf', 'D'); //


	}

	public function leave_count_report()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = 'Leave Count Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Detailed  ' . 'Leave Count Report';
		$data['path_url'] = 'new_attendances_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('636', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/leave_count_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function date_ranges($employee_id = 0)
	{
		$employee = $this->Employees_model->read_employee_information($employee_id)[0];
		$date_of_joining = $employee->date_of_joining;
		if ($employee->date_of_leaving) {
			$date_of_leaving = $employee->date_of_leaving;
		} else {
			$date_of_leaving = 0;
		}
		$date2 = '';
		$join_year = explode('-', $date_of_joining)[0];
		$date1 = $date_of_joining;
		$current_date = date('Y-m-d');
		$return = '<option value="">-- Select --</option>';

		for ($i = $join_year; $i < date('Y');) :
			$i++;
			$date2_time = strtotime('+1 year', strtotime($date1));
			$date2 = date('Y-m-d', $date2_time - 60 * 60 * 24);

			$return .= '<option value="' . $date1 . ':' . $date2 . '">' . $date1 . ' - ' . $date2 . '</option>';

			$date2 = date('Y-m-d', $date2_time);
			$date1 = $date2;
		endfor;
		if ($date_of_leaving != '0') {
			if (strtotime($date_of_leaving) <= strtotime($date2)) {
				$return .= '<option value="' . $date2 . ':' . $current_date . '">' . $date2 . ' - ' . $current_date . '</option>';
			} else {
				$return .= '<option value="' . $date2 . ':' . $date_of_leaving . '">' . $date2 . ' - ' . $date_of_leaving . '</option>';
			}
		} else if (strtotime($current_date) > strtotime($date2)) {
			$return .= '<option value="' . $date2 . ':' . $current_date . '">' . $date2 . ' - ' . $current_date . '</option>';
		} else if (strtotime($current_date) == strtotime($date2)) {
		}

		echo $return;
		exit;
	}

	public function assigned_leaves($employee_id, $year)
	{
		//$year = date('Y', strtotime($year));
		$splityear_range = explode(":", $year);
		// print_r($splityear_range);
		// exit();
		$date1 = $splityear_range[0];
		$date2 = $splityear_range[1];
		//$sql = "SELECT leave_type FROM `employee_leave` WHERE employee_id = '$employee_id' AND created_at LIKE '%$year%'";
		$sql = "SELECT leave_type FROM `employee_leave` WHERE employee_id = '$employee_id'  AND created_at >= '" . $date1 . "' AND created_at <='" . $date2 . "'";
		$assigned_leaves = $this->db->query($sql);
		$return = '<option value="">-- Select --</option>';

		foreach ($assigned_leaves->result() as $type) :
			$sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $type->leave_type;
			$type_info = $this->db->query($sql)->row();

			$return .= '<option value="' . $type->leave_type . '">' . $type_info->type_name . '</option>';
		endforeach;

		echo $return;
		exit;
	}

	public function list_leaves_assigned($employee_id, $year, $leave_type = 0)
	{
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$employee = $this->Employees_model->read_employee_information($employee_id)[0];

		// $year = date('Y', strtotime($year));
		$splityear_range = explode(":", $year);
		//   print_r($splityear_range);
		//   exit();
		$date1 = $splityear_range[0];
		$date2 = $splityear_range[1];
		//$sql = "SELECT * FROM `employee_leave` WHERE employee_id = $employee_id AND created_at LIKE '%$year%'";
		$sql = "SELECT * FROM `employee_leave` WHERE employee_id = $employee_id  AND created_at >= '" . $date1 . "' AND created_at <='" . $date2 . "'";
		if ($leave_type > 0)
			$sql .= " AND leave_type = $leave_type";

		$assigned_leaves = $this->db->query($sql);

		$data = array();

		foreach ($assigned_leaves->result() as $leave) {
			$sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $leave->leave_type;
			$type_info = $this->db->query($sql)->row();

			// $sql = "SELECT * FROM `carry_leaves` WHERE employee_id = $employee_id
			//         AND leave_type_id = ".$leave->leave_type."
			//         AND create_date LIKE '%$year%'";
			$sql = "SELECT * FROM `carry_leaves` WHERE employee_id = $employee_id
                    AND leave_type_id = " . $leave->leave_type . "
                    AND create_date >= '" . $date1 . "' AND create_date <='" . $date2 . "'";
			$carry_leave = $this->db->query($sql)->row();
			// if ($carry_leave)
			// {
			//     $remaing_leave_count = $carry_leave->remaing_leave_count;
			//     $leave_taken = $leave->leave_count - $remaing_leave_count;
			// }
			if ($carry_leave) {
				$remaing_leave_count = $carry_leave->remaing_leave_count;
				if ($leave->leave_count == '0') {
					$sql = "SELECT COUNT(id) as absentcount FROM `carry_leaves` WHERE employee_id = $employee_id
                    AND leave_type_id = " . $leave->leave_type . "
                    AND create_date >= '" . $date1 . "' AND create_date <='" . $date2 . "'";
					$count = $this->db->query($sql)->row();
					$leave_taken = $count->absentcount;
				} else {
					$leave_taken = $leave->leave_count - $remaing_leave_count;
				}
			} else {
				$leave_taken = 0;//$leave->leave_count;
				$remaing_leave_count = $leave->leave_count;
			}

			$this->db->where('company_id', $employee->company_id);
			$company = $this->db->get('xin_companies')->row();

			$company_name = '';

			if ($company)
				$company_name = $company->name;


			if ($leave->leave_count == 0) {
				$remaining_leave_taken_get = 0;
			} else {
				$remaining_leave_taken_get = $leave->leave_count - $leave_taken;
			}

			$data[] = array(
				'<strong>' . $employee->first_name . ' ' . $employee->middle_name . ' ' . $employee->last_name . '</strong>
                <br><small><i>' . $company_name . '</i></small>',
				'<span class="text-nowrap">' . $this->input->get('year_range') . '</span>',
				$type_info->type_name,
				$leave->leave_count,
				$leave_taken,
				round($remaining_leave_taken_get, 3),
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $assigned_leaves->num_rows(),
			"recordsFiltered" => $assigned_leaves->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	//rahul new dev

	public function detailed_leave_count_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;

		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');
		$year = $this->input->post('p_year');
		$leave_type = $this->input->post('p_leave_type');


		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;

			//------------------------------------------

			if ($company_id == 0) {

				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			} else {

				$company_wise_data = $this->Xin_model->company_wise_data_get($company_id);
				$company_wise_data_get = $company_wise_data[0]->logo;
				$company_name = $company_wise_data[0]->name;
				$address_1 = $company_wise_data[0]->address_1;
				$address_2 = $company_wise_data[0]->address_2;
				$city = $company_wise_data[0]->city;
				$zipcode = $company_wise_data[0]->zipcode;
				$c_info_phone = $company_wise_data[0]->contact_number;
				$c_info_email = $company_wise_data[0]->email;

				if ($company_wise_data_get) {
					$logo = '../../../../../uploads/company/' . $company_wise_data_get;
				} else {
					$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
				}

			}

			//--------------------------------------

		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$employee = $this->Employees_model->read_employee_information($employee_id)[0];

		// $year = date('Y', strtotime($year));
		$splityear_range = explode(":", $year);
		//   print_r($splityear_range);
		//   exit();
		$date1 = $splityear_range[0];
		$date2 = $splityear_range[1];
		//$sql = "SELECT * FROM `employee_leave` WHERE employee_id = $employee_id AND created_at LIKE '%$year%'";
		$sql = "SELECT * FROM `employee_leave` WHERE employee_id = $employee_id  AND created_at >= '" . $date1 . "' AND created_at <='" . $date2 . "'";
		if ($leave_type != '') {
			$sql .= " AND leave_type = $leave_type";
		} else {
		}

		$assigned_leaves = $this->db->query($sql);

		$data = array();

		foreach ($assigned_leaves->result() as $leave) {
			$sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $leave->leave_type;
			$type_info = $this->db->query($sql)->row();

			// $sql = "SELECT * FROM `carry_leaves` WHERE employee_id = $employee_id
			//         AND leave_type_id = ".$leave->leave_type."
			//         AND create_date LIKE '%$year%'";
			$sql = "SELECT * FROM `carry_leaves` WHERE employee_id = $employee_id
                    AND leave_type_id = " . $leave->leave_type . "
                    AND create_date >= '" . $date1 . "' AND create_date <='" . $date2 . "'";
			$carry_leave = $this->db->query($sql)->row();
			// if ($carry_leave)
			// {
			//     $remaing_leave_count = $carry_leave->remaing_leave_count;
			//     $leave_taken = $leave->leave_count - $remaing_leave_count;
			// }
			if ($carry_leave) {
				$remaing_leave_count = $carry_leave->remaing_leave_count;
				if ($leave->leave_count == '0') {
					$sql = "SELECT COUNT(id) as absentcount FROM `carry_leaves` WHERE employee_id = $employee_id
                    AND leave_type_id = " . $leave->leave_type . "
                    AND create_date >= '" . $date1 . "' AND create_date <='" . $date2 . "'";
					$count = $this->db->query($sql)->row();
					$leave_taken = $count->absentcount;
				} else {
					$leave_taken = $leave->leave_count - $remaing_leave_count;
				}
			} else {
				$leave_taken = 0;//$leave->leave_count;
				$remaing_leave_count = $leave->leave_count;
			}

			$this->db->where('company_id', $employee->company_id);
			$company = $this->db->get('xin_companies')->row();

			$company_name = '';

			if ($company)
				$company_name = $company->name;

			if ($leave->leave_count == 0) {
				$remaining_leave_taken_get = 0;
			} else {
				$remaining_leave_taken_get = $leave->leave_count - $leave_taken;
			}

			$data[] = array(
				"employee_info" => '<strong>' . $employee->first_name . ' ' . $employee->middle_name . ' ' . $employee->last_name . '</strong><br><small><i>' . $company_name . '</i></small>',
				"date_range" => '<span class="text-nowrap">' . $year . '</span>',
				"type_name" => $type_info->type_name,
				"leave_count" => $leave->leave_count,
				"leave_taken" => $leave_taken,
				"remaing_leave_count" => $remaining_leave_taken_get
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['year'] = $year;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/detailed_leave_count_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Detailed_Leave_Count.pdf', 'D'); //


	}

	//rahul new dev end

	public function leave_report()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = 'Leave Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Detailed  ' . 'Leave Report';
		$data['path_url'] = 'new_attendances_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('637', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/leave_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function list_leave_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/leave_report", $data);
		} else {
			redirect('admin/');
		}
		$company_id = $this->input->get('company_id');
		$employee_id = $this->input->get('employee_id');
		$from_date = $this->input->get('from_date');
		$end_date = $this->input->get('end_date');

		// $this->db->where('company_id', $company_id);
		// if ($employee_id > 0)
		//     $this->db->where('employee_id', $employee_id);
		// if ($from_date != '')
		//     $this->db->where('from_date >=', $from_date);
		// if ($end_date != '')
		//     $this->db->where('to_date <=', $end_date);
		// $leaves = $this->db->get('xin_leave_applications');

		$leaves = $this->Reports_model->list_leave_report_get($company_id, $employee_id, $from_date, $end_date);

		//$sql="SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE company_id='".$company_id."' and employee_id='".$employee_id."' and from_date >='".$from_date."' and to_date<='".$end_date."'
		//UNION ALL
		//SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,Null AS reason from xin_annual_leave_applications WHERE company_id='".$company_id."' and employee_id='".$employee_id."' and from_date >='".$from_date."' and to_date<='".$end_date."'";
		// $leaves = $this->db->query($sql);

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$employee_names = array();

		foreach ($leaves->result() as $leave) {
			if (!array_key_exists($leave->employee_id, $employee_names)) {
				$employee = $this->Employees_model->read_employee_information($leave->employee_id)[0];


				if ($employee)
					$employee_names[$leave->employee_id] = $employee->first_name . ' ' . $employee->middle_name . ' ' . $employee->last_name;
				else
					$employee_names[$leave->employee_id] = '--';
			}

			$this->db->where('company_id', $leave->company_id);
			$company = $this->db->get('xin_companies')->row();

			if ($company)
				$company_name = $company->name;
			else
				$company_name = '';

			$name = '<strong>' . $employee_names[$leave->employee_id] . '</strong>
            <br><small><i>' . $company_name . '</i><small>';

			$sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $leave->leave_type_id;
			$type_info = $this->db->query($sql)->row();
			$leave_type_name = '';

			if ($type_info)
				$leave_type_name = $type_info->type_name;

			$leave_type_name = $leave_type_name . '
            
            <br><small><i>Reason: ' . $leave->reason . '</i></small>
            <br><small><i>Remarks: ' . $leave->remarks . '</i></small>';

			if ($leave->status == 1)
				$status = 'Pending';
			else if ($leave->status == 2)
				$status = 'Approved';
			else
				$status = 'Rejected';

			$data[] = array(
				$name,
				$leave_type_name,
				$leave->from_date . ' - ' . $leave->to_date . '
                <br><small><i>Days: ' . $leave->days . '</i></small>',
				$status,
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $leaves->num_rows(),
			"recordsFiltered" => $leaves->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}


	//rahul new dev

	public function detailed_leave_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');


		$leaves = $this->Reports_model->list_leave_report_get($company_id, $employee_id, $from_date, $end_date);

		$leaves_count = $this->Reports_model->list_leave_report_get_count($company_id, $employee_id, $from_date, $end_date);

//empty data display code start
		if (empty($leaves_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($leaves_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$leaves_count[$key]['header_string'] = $email_phone_address;
			$leaves_count[$key]['company_name'] = $company_name;
			$leaves_count[$key]['logo'] = $logo;
		}


		$employee_names = array();

		foreach ($leaves->result() as $leave) {
			if (!array_key_exists($leave->employee_id, $employee_names)) {
				$employee = $this->Employees_model->read_employee_information($leave->employee_id)[0];


				if ($employee)
					$employee_names[$leave->employee_id] = $employee->first_name . ' ' . $employee->middle_name . ' ' . $employee->last_name;
				else
					$employee_names[$leave->employee_id] = '--';
			}

			$this->db->where('company_id', $leave->company_id);
			$company = $this->db->get('xin_companies')->row();

			if ($company)
				$company_name = $company->name;
			else
				$company_name = '';

			$name = '<strong>' . $employee_names[$leave->employee_id] . '</strong>
            <br><small><i>' . $company_name . '</i><small>';

			$sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $leave->leave_type_id;
			$type_info = $this->db->query($sql)->row();
			$leave_type_name = '';

			if ($type_info)
				$leave_type_name = $type_info->type_name;

			$leave_type_name = $leave_type_name . '
            
            <br><small><i>Reason: ' . $leave->reason . '</i></small>
            <br><small><i>Remarks: ' . $leave->remarks . '</i></small>';

			if ($leave->status == 1)
				$status = 'Pending';
			else if ($leave->status == 2)
				$status = 'Approved';
			else
				$status = 'Rejected';

			$data[] = array(
				"name" => $name,
				"leave_type_name" => $leave_type_name,
				"leave_data" => $leave->from_date . ' - ' . $leave->to_date . '
                <br><small><i>Days: ' . $leave->days . '</i></small>',
				"status" => $status,
				"company_id" => $leave->company_id
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['leaves_count'] = $leaves_count;
		$res['start_date'] = $from_date;
		$res['end_date'] = $end_date;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/detailed_leave_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Detailed_Leave.pdf', 'D'); //


	}


	public function lwp_information_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "LOP Information" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "LOP Information";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();
		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/lwp_information", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}

	}

	public function lwp_information_report_employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['company'];
		$department_id = $_GET['department_id'];
		$location_company = $_GET['location_company'];
		$emp_id = $_GET['emp_id'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];
		$summary_report = $_GET['summary_report'];

		$lwp_report = $this->Reports_model->lwp_information_report_employee_get_query($company_id, $department_id, $location_company, $emp_id, $start_date, $end_date);
		$lwp_report2 = $this->Reports_model->lwp_information_report_employee_get_table2_query($company_id, $department_id, $location_company, $emp_id, $start_date, $end_date);

		$data = array();

		if ($summary_report == 0) {


			foreach ($lwp_report->result() as $get) {

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}


				$f_date = $get->from_date;
				$f_date_get = date("d-m-Y", strtotime($f_date));

				$t_date = $get->to_date;
				$t_date_get = date("d-m-Y", strtotime($t_date));

				//lop get
				$lop_get = $f_date_get . '  -  ' . $t_date_get;

				$data[] = array(
					$get->employee_id,
					$full_name,
					$dept_name,
					$designation_name,
					$lop_get
				);

			}

			//table2
			foreach ($lwp_report2->result() as $get2) {

				// user full name
				$full_name = $get2->first_name . ' ' . $get2->last_name;

				//get department
				$department_name = $this->Xin_model->read_department_info($get2->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($get2->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}


				$f_date2 = $get2->unpaid_start_date;
				$f_date_get2 = date("d-m-Y", strtotime($f_date2));

				$t_date2 = $get2->unpaid_end_date;
				$t_date_get2 = date("d-m-Y", strtotime($t_date2));

				//lop get
				$lop_get2 = $f_date_get2 . '  -  ' . $t_date_get2;

				$data[] = array(
					$get2->employee_id,
					$full_name,
					$dept_name,
					$designation_name,
					$lop_get2
				);

			}

		} else {

			foreach ($lwp_report->result() as $get) {

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}


				$f_date = $get->from_date;
				$t_date = $get->to_date;

				$startDate = new DateTime($f_date);
				$endDate = new DateTime($t_date);

				$difference = $endDate->diff($startDate);
				$days_count = $difference->format("%a") + 1;

				$data[] = array(
					$get->employee_id,
					$full_name,
					$dept_name,
					$designation_name,
					$days_count
				);

			}

			//table 2
			foreach ($lwp_report2->result() as $get2) {

				// user full name
				$full_name = $get2->first_name . ' ' . $get2->last_name;

				//get department
				$department_name = $this->Xin_model->read_department_info($get2->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($get2->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				$f_date2 = $get2->unpaid_start_date;
				$t_date2 = $get2->unpaid_end_date;

				$startDate2 = new DateTime($f_date2);
				$endDate2 = new DateTime($t_date2);

				$difference2 = $endDate2->diff($startDate2);
				$days_count2 = $difference2->format("%a") + 1;


				$data[] = array(
					$get2->employee_id,
					$full_name,
					$dept_name,
					$designation_name,
					$days_count2
				);

			}

		}


		$total_row_count1 = $lwp_report->num_rows();
		$total_row_count2 = $lwp_report2->num_rows();


		$total_row_count = $total_row_count1 + $total_row_count2;


		$output = array(
			"draw" => $draw,
			"recordsTotal" => $total_row_count,
			"recordsFiltered" => $total_row_count,
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();

	}


	public function lwp_information_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$company_id = $this->input->post('e_company_id');
		$department_id = $this->input->post('e_department_id');
		$location_company = $this->input->post('e_location_id');
		$emp_id = $this->input->post('e_employee_id');
		$start_date = $this->input->post('e_start_date');
		$end_date = $this->input->post('e_end_date');
		$summary_report = $this->input->post('e_summary_report');


		if (!empty($company_id)) {
			$title_company_id = $company_id;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------

		if ($summary_report == 0) {
			$table_lop_tittle = "LOP (From Date - To Date)";
			$pdf_tittle = "LOP Details Report";
		} else {
			$table_lop_tittle = "LOP Total Days Count";
			$pdf_tittle = "LOP Summary Report";
		}

		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['company_id'] = $company_id;
		$res['department_id'] = $department_id;
		$res['location_company'] = $location_company;
		$res['emp_id'] = $emp_id;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['summary_report'] = $summary_report;
		$res['table_lop_tittle'] = $table_lop_tittle;
		$res['pdf_tittle'] = $pdf_tittle;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/lop_information_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Lop_Information.pdf', 'D');
	}


	//rahul new dev end


	public function overtime_report()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Overtime Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Overtime Report";
		//$data['path_url'] = 'new_attendances_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		//$data['get_emp_ot'] = $this->Timesheet_model->getemployees_overtime_details();
		$data['get_time'] = $this->Timesheet_model->get_timetable();

		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('608', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/reports/overtime_report", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
		} else {
			redirect('admin/dashboard');
		}

		/*$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$data['title'] = 'Overtime Report'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Detailed  '.'Overtime Report';
		$data['path_url'] = 'overtime_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('112',$role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/overtime_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}*/
	}


	public function overtime_report_datatable_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['company_id'];
		$employee_id = $_GET['user_id'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];

		$ot_data_get = $this->Timesheet_model->getallemployees_datewise_overtime_details_payroll_report($start_date, $end_date, $company_id, $employee_id);

		$data = array();

		if (isset($ot_data_get)) {
			foreach ($ot_data_get as $emp) {
				//$total_hours = $emp["normal_ot_hours"]+ $emp["extra_ot_hours"];


				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$weekend = $overtime_consts[0]->weekend;
				$holiday = $overtime_consts[0]->holiday;
				$timeshift_percent = $overtime_consts[0]->timeshift_percent;
				$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;
				$total_overtimeamount = 0;
				$overtimeamount = 0;
				$normal_ot_hours = $emp["normal_ot_hours"];
				$extraot_hours = $emp["extra_ot_hours"];
				$attn_date = $emp["attendance_date"];
				$timestamp = strtotime($attn_date);
				$day = date('l', $timestamp);

				$user = $this->Employees_model->read_user_by_user_id($emp["user_id"]);
				$basic_pay = $user[0]->basic_salary;
				$comp_id = $user[0]->company_id;;
				$holidays = $this->Employees_model->get_holidays($comp_id);
				global $holiday_check;

				if (isset($holidays)) {
					foreach ($holidays as $row) {
						$startDate = $row->start_date;
						$endDate = $row->end_date;

						if (($attn_date >= $startDate) && ($attn_date <= $endDate)) {
							$holiday_check = "yes";
						}
					}
				}

				$total_work = $this->Employees_model->get_employee_workdone($emp["user_id"], $attn_date);
				$total_work_hours = $total_work[0]->totalhours;
				$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($emp["user_id"], $attn_date);
				$late_by_hours = $latecome_deduct[0]->late_by_hours;
				if (!empty($latecome_deduct)) {
					$late_by_hours = $latecome_deduct[0]->late_by_hours;
					if ($late_by_hours > 0) {
						$late_by_hours = $latecome_deduct[0]->late_by_hours + 0.08;
					}
				} else {
					$late_by_hours = 0;
				}
				if ($total_work_hours <= 8 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = 0;

				} elseif ($total_work_hours > 8 && $normal_ot_hours > 0 && $late_by_hours > 0 && $extraot_hours == 0 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = $normal_ot_hours - $late_by_hours;
				}

				if ($normal_ot_hours > 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent + (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours > 0 && $extraot_hours == 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours == 0) {
					$overtimeamount = 0;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $day == "Friday") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $weekend;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $holiday_check == "yes") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $holiday;
					unset($holiday_check);
				}

				$total_hours = $normal_ot_hours + $extraot_hours;
				$clk_in = explode(" ", $emp["clock_in"]);
				$clk_out = explode(" ", $emp["clock_out"]);

				if ($overtimeamount !== 0) {

					$data[] = array(
						$emp["employee_id"],
						$emp["first_name"] . " " . $emp["last_name"],
						$emp["trading_name"],
						$emp["attendance_date"],
						$clk_in[1],
						$clk_out[1],
						$total_hours,
						$this->Xin_model->company_currency_sign($overtimeamount, $user[0]->company_id)
					);

				}
			}
		}


		if ($ot_data_get != '') {
			$total_count = count($ot_data_get);
		} else {
			$total_count = '0';
		}


		$output = array(
			"draw" => $draw,
			"recordsTotal" => $total_count,
			"recordsFiltered" => $total_count,
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();

	}

	public function overtime_report_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');
		$start_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');

		$ot_data_get = $this->Timesheet_model->getallemployees_datewise_overtime_details_payroll_report($start_date, $end_date, $company_id, $employee_id);
		$data = array();

		if (!empty($company_id)) {
			//$company_id_array = explode(',',$aj_company);
			$title_company_id = $company_id;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------

		if (isset($ot_data_get)) {
			foreach ($ot_data_get as $emp) {
				//$total_hours = $emp["normal_ot_hours"]+ $emp["extra_ot_hours"];


				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$weekend = $overtime_consts[0]->weekend;
				$holiday = $overtime_consts[0]->holiday;
				$timeshift_percent = $overtime_consts[0]->timeshift_percent;
				$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;
				$total_overtimeamount = 0;
				$overtimeamount = 0;
				$normal_ot_hours = $emp["normal_ot_hours"];
				$extraot_hours = $emp["extra_ot_hours"];
				$attn_date = $emp["attendance_date"];
				$timestamp = strtotime($attn_date);
				$day = date('l', $timestamp);

				$user = $this->Employees_model->read_user_by_user_id($emp["user_id"]);
				$basic_pay = $user[0]->basic_salary;
				$comp_id = $user[0]->company_id;;
				$holidays = $this->Employees_model->get_holidays($comp_id);
				global $holiday_check;

				if (isset($holidays)) {
					foreach ($holidays as $row) {
						$startDate = $row->start_date;
						$endDate = $row->end_date;

						if (($attn_date >= $startDate) && ($attn_date <= $endDate)) {
							$holiday_check = "yes";
						}
					}
				}

				$total_work = $this->Employees_model->get_employee_workdone($emp["user_id"], $attn_date);
				$total_work_hours = $total_work[0]->totalhours;
				$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($emp["user_id"], $attn_date);
				$late_by_hours = $latecome_deduct[0]->late_by_hours;
				if (!empty($latecome_deduct)) {
					$late_by_hours = $latecome_deduct[0]->late_by_hours;
					if ($late_by_hours > 0) {
						$late_by_hours = $latecome_deduct[0]->late_by_hours + 0.08;
					}
				} else {
					$late_by_hours = 0;
				}
				if ($total_work_hours <= 8 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = 0;

				} elseif ($total_work_hours > 8 && $normal_ot_hours > 0 && $late_by_hours > 0 && $extraot_hours == 0 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = $normal_ot_hours - $late_by_hours;
				}

				if ($normal_ot_hours > 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent + (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours > 0 && $extraot_hours == 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours == 0) {
					$overtimeamount = 0;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $day == "Friday") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $weekend;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $holiday_check == "yes") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $holiday;
					unset($holiday_check);
				}

				$total_hours = $normal_ot_hours + $extraot_hours;
				$clk_in = explode(" ", $emp["clock_in"]);
				$clk_out = explode(" ", $emp["clock_out"]);

				if ($overtimeamount !== 0) {

					$data[] = array(
						"emp_name" => $emp["first_name"] . " " . $emp["last_name"],
						"employee_id" => $emp["employee_id"],
						"trading_name" => $emp["trading_name"],
						"attendance_date" => $emp["attendance_date"],
						"clk_in" => $clk_in[1],
						"clk_out" => $clk_out[1],
						"total_hours" => $total_hours,
						"overtimeamount" => $this->Xin_model->company_currency_sign($overtimeamount, $user[0]->company_id)
					);

				}
			}
		}

		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['main_data'] = $data;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/overtime_Report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Overtime_Report.pdf', 'D');
	}


	public function overtime_datewise_report()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Overtime Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Overtime Report";
		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$company_id = $this->input->post('company_id');
		$employee_id = $this->input->post('employee_id');
		$data['start_date'] = $start_date;
		$data['end_date'] = $end_date;
		$data['company_id'] = $company_id;
		if ($employee_id == 0) {
			$data['get_all_companies'] = $this->Xin_model->get_companies();
			$data['get_emp_ot'] = $this->Timesheet_model->getallemployees_datewise_overtime_details($start_date, $end_date, $company_id);
		} else {
			$data['get_all_companies'] = $this->Xin_model->get_companies();
			$data['get_emp_ot'] = $this->Timesheet_model->getemployees_datewise_overtime_details($start_date, $end_date, $company_id, $employee_id);
		}
		/*$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_emp_ot'] = $this->Timesheet_model->get_employees_datewise_overtime_details($start_date,$end_date,$company_id,$employee_id);*/

		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('608', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/reports/overtime_report", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function loan_report()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Loan Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Loan Report";
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_time'] = $this->Timesheet_model->get_timetable();

		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('28', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/reports/loan_report", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function loan_datewise_report()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Loan Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Loan Report";
		$data['path_url'] = 'loan_detail';
		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$company_id = $this->input->post('company_id');
		$employee_id = $this->input->post('employee_id');
		$data['start_date'] = $start_date;
		$data['end_date'] = $end_date;
		$data['company_id'] = $company_id;
		if ($employee_id == 0) {
			$data['get_all_companies'] = $this->Xin_model->get_companies();
			$data['get_emp_loan'] = $this->Timesheet_model->getallemployees_datewise_loan_details($start_date, $end_date, $company_id);
		} else {
			$data['get_all_companies'] = $this->Xin_model->get_companies();
			$data['get_emp_loan'] = $this->Timesheet_model->getemployees_datewise_loan_details($start_date, $end_date, $company_id, $employee_id);
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('28', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/reports/loan_report", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function read()

	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('warning_id');

		if (!empty($session)) {

			$this->load->view('admin/warning/dialog_warning', $data);
		} else {

			redirect('admin/');
		}
	}

	public function dialog_salary_loan()
	{


		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();

		$id = $this->input->get('field_id');

		$result = $this->Employees_model->read_single_loan_deductions($id);

		$data = array(

			'loan_deduction_id' => $result[0]->loan_deduction_id,

			'employee_id' => $result[0]->employee_id,

			'loan_deduction_title' => $result[0]->loan_deduction_title,

			'start_date' => $result[0]->start_date,

			'end_date' => $result[0]->end_date,

			'loan_options' => $result[0]->loan_options,

			'monthly_installment' => $result[0]->monthly_installment,

			'reason' => $result[0]->reason,

			'created_at' => $result[0]->created_at

		);

		if (!empty($session)) {

			$this->load->view('admin/reports/dialog_loan_details', $data);
		} else {

			redirect('admin/');
		}
	}

	public function advance_report()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Advance Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Advance Report";
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_time'] = $this->Timesheet_model->get_timetable();

		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('656', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/reports/advance_report_emp", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function advance_datewise_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/payslip", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['company_id'];
		$employee_id = $_GET['user_id'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];

		$advance_data_get = $this->Timesheet_model->get_all_employees_datewise_advance_details2($start_date, $end_date, $company_id, $employee_id);

		$data = array();

		foreach ($advance_data_get->result() as $get) {

			$advance_amount = $get->advance_amount;
			$total_paid = $get->total_paid;
			$remaining = $get->advance_amount - $get->total_paid;;
			if ($advance_amount == $total_paid) {
				$all_paid = '<span class="tag tag-success">' . $this->lang->line('xin_all_paid') . '</span>';
			} else {
				$all_paid = '<span class="tag tag-warning">' . $this->lang->line('xin_remaining') . '</span>';
			}


			$data[] = array(
				$get->first_name . ' ' . $get->last_name,
				$get->start_date,
				$get->end_date,
				'BD ' . round($get->advance_amount, 3),
				'BD ' . round($get->total_paid, 3),
				'BD ' . round($remaining, 3),
				$all_paid
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $advance_data_get->num_rows(),
			"recordsFiltered" => $advance_data_get->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();

	}

	public function advance_report_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post("p_company_id");
		$employee_id = $this->input->post("p_employee_id");
		$start_date = $this->input->post("p_start_date");
		$end_date = $this->input->post("p_end_date");

		$advance_data_get = $this->Timesheet_model->get_all_employees_datewise_advance_details2($start_date, $end_date, $company_id, $employee_id);

		$advance_company_count = $this->Timesheet_model->get_all_employees_datewise_advance_details_count2($start_date, $end_date, $company_id, $employee_id);

		//empty data display code start
		if (empty($advance_company_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($advance_company_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$advance_company_count[$key]['header_string'] = $email_phone_address;
			$advance_company_count[$key]['company_name'] = $company_name;
			$advance_company_count[$key]['logo'] = $logo;
		}


		foreach ($advance_data_get->result() as $get) {

			$advance_amount = $get->advance_amount;
			$total_paid = $get->total_paid;
			$remaining = $get->advance_amount - $get->total_paid;;
			if ($advance_amount == $total_paid) {
				$all_paid = '<span class="tag tag-success">' . $this->lang->line('xin_all_paid') . '</span>';
			} else {
				$all_paid = '<span class="tag tag-warning">' . $this->lang->line('xin_remaining') . '</span>';
			}


			$data[] = array(
				"full_name" => $get->first_name . ' ' . $get->last_name,
				"start_date" => $get->start_date,
				"end_date" => $get->end_date,
				"advance_amount" => 'BD ' . round($get->advance_amount, 3),
				"total_paid" => 'BD ' . round($get->total_paid, 3),
				"remaining" => 'BD ' . round($remaining, 3),
				"all_paid" => $all_paid,
				"company_id" => $get->company_id,
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['advance_company_count'] = $advance_company_count;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/advance_report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Advance_Report.pdf', 'D'); //


	}

	public function advance_salary_report_read()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		// $data['all_countries'] = $this->xin_model->get_countries();
		$result = $this->Payroll_model->advance_salaries_report_view($id);
		$data = array(
			'advance_salary_id' => $result[0]->advance_salary_id,
			'employee_id' => $result[0]->employee_id,
			'company_id' => $result[0]->company_id,
			'month_year' => $result[0]->month_year,
			'advance_amount' => $result[0]->advance_amount,
			'total_paid' => $result[0]->total_paid,
			'one_time_deduct' => $result[0]->one_time_deduct,
			'monthly_installment' => $result[0]->monthly_installment,
			'reason' => $result[0]->reason,
			'status' => $result[0]->status,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'get_all_companies' => $this->Xin_model->get_companies()
		);
		if (!empty($session)) {
			$this->load->view('admin/payroll/dialog_advance_salary', $data);
		} else {
			redirect('admin/');
		}
	}


	public function payroll_status_report()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = 'Payroll Status Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Payroll Status Report';
		$data['path_url'] = 'new_attendances_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('611', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/payroll_status_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function list_payroll_status_report()
	{
		$company_id = $this->input->get('company_id');
		$employee_id = $this->input->get('employee_id');
		$from_date = $this->input->get('from_date');
		$end_date = $this->input->get('end_date');

		if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") == 0) {
			$payslip = $this->Employees_model->get_employees_payslip();
		} else if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") != 0) {
			$payslip = $this->Payroll_model->get_comp_template($this->input->get("company_id"), 0);
		} else if ($this->input->get("employee_id") != 0 && $this->input->get("company_id") != 0) {
			$payslip = $this->Payroll_model->get_employee_comp_template($this->input->get("company_id"), $this->input->get("employee_id"));
		} else {
			$payslip = $this->Employees_model->get_employees_payslip();
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$employee_names = array();

		$d1 = new DateTime($from_date);
		$d2 = new DateTime($end_date);
		$interval = $d1->diff($d2);
		$diffInMonths = $interval->m + 1;

		$start_month = strtotime($from_date);
		$end_month = strtotime($end_date);
		$i = 1;
		while ($start_month <= $end_month) {

			foreach ($payslip->result() as $leave) {
				$emp_name = $leave->first_name . ' ' . $leave->middle_name . ' ' . $leave->last_name;

				$this->db->where('company_id', $leave->company_id);
				$company = $this->db->get('xin_companies')->row();

				if ($company)
					$company_name = $company->name;
				else
					$company_name = '';

				$name = '<strong>' . $emp_name . '</strong>
            <br><small><i>' . $company_name . '</i><small>';

				/*$this->db->where('company_id', $company_id);
            if ($employee_id > 0)
                $this->db->where('employee_id', $employee_id);
            if ($from_date != '')
                $this->db->where('salary_month >=', $from_date);
            if ($end_date != '')
                $this->db->where('salary_month <=', $end_date);
            $leaves = $this->db->get('xin_salary_payslips');
            */
				$p_date = date('Y-m', $start_month);
				$payroll_type = $payroll_type_normal = '';
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($leave->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($leave->user_id, $p_date);
					if ($make_payment[0]->annual_leave_amt) {
						$payroll_type = 'Annual';
					}
					if ($make_payment[0]->monthy_present_days > 0) {
						$payroll_type_normal = 'Normal';
					}
					$status = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
				} else {
					$annual_amt_pay = $anual_days_leave = 0;
					$total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($leave->user_id, $p_date);
					if (!empty($total_annual_leaves[0]->id)) {
						foreach ($total_annual_leaves as $tot_ann_levs) {
							$annual_amt_pay += (float)$tot_ann_levs->annua_amt;
							$anual_days_leave += $tot_ann_levs->days;
						}
					}
					if ($annual_amt_pay > 0) {
						$payroll_type = 'Annual';
					}
					$month = date('m', $start_month);
					$year = date('Y', $start_month);
					$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
					if ($annual_amt_pay < $daysInMonth) {
						$payroll_type_normal = 'Normal';
					}
					$status = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
				}


				$data[] = array(
					$name,
					$status,
					$payroll_type . ' ' . $payroll_type_normal,
					$p_date,
				);
			}
			$start_month = strtotime("+1 month", $start_month);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip->num_rows(),
			"recordsFiltered" => $payslip->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function payroll_status_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$company_id = $this->input->post('p_company_id');
		$employee_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_month');
		$end_date = $this->input->post('p_to_month');

		if ($this->input->post("p_employee_id") == 0 && $this->input->post("p_company_id") == 0) {
			$payslip = $this->Employees_model->get_employees_payslip();
		} else if ($this->input->post("p_employee_id") == 0 && $this->input->post("p_company_id") != 0) {
			$payslip = $this->Payroll_model->get_comp_template($this->input->post("p_company_id"), 0);
		} else if ($this->input->post("p_employee_id") != 0 && $this->input->post("p_company_id") != 0) {
			$payslip = $this->Payroll_model->get_employee_comp_template($this->input->post("p_company_id"), $this->input->post("p_employee_id"));
		} else {
			$payslip = $this->Employees_model->get_employees_payslip();
		}

		$data = array();
		$employee_names = array();

		$d1 = new DateTime($from_date);
		$d2 = new DateTime($end_date);
		$interval = $d1->diff($d2);
		$diffInMonths = $interval->m + 1;

		$start_month = strtotime($from_date);
		$end_month = strtotime($end_date);
		$i = 1;


		if (!empty($company_id)) {
			//$company_id_array = explode(',',$aj_company);
			$title_company_id = $company_id;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------

		while ($start_month <= $end_month) {

			foreach ($payslip->result() as $leave) {
				$emp_name = $leave->first_name . ' ' . $leave->middle_name . ' ' . $leave->last_name;

				$this->db->where('company_id', $leave->company_id);
				$company = $this->db->get('xin_companies')->row();

				if ($company)
					$company_name = $company->name;
				else
					$company_name = '';

				$name = '<strong>' . $emp_name . '</strong>
            <br><small><i>' . $company_name . '</i><small>';

				/*$this->db->where('company_id', $company_id);
            if ($employee_id > 0)
                $this->db->where('employee_id', $employee_id);
            if ($from_date != '')
                $this->db->where('salary_month >=', $from_date);
            if ($end_date != '')
                $this->db->where('salary_month <=', $end_date);
            $leaves = $this->db->get('xin_salary_payslips');
            */
				$p_date = date('Y-m', $start_month);
				$payroll_type = $payroll_type_normal = '';
				$payment_check = $this->Payroll_model->read_make_payment_payslip_check($leave->user_id, $p_date);
				if ($payment_check->num_rows() > 0) {
					$make_payment = $this->Payroll_model->read_make_payment_payslip($leave->user_id, $p_date);
					if ($make_payment[0]->annual_leave_amt) {
						$payroll_type = 'Annual';
					}
					if ($make_payment[0]->monthy_present_days > 0) {
						$payroll_type_normal = 'Normal';
					}
					$status = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
				} else {
					$annual_amt_pay = $anual_days_leave = 0;
					$total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($leave->user_id, $p_date);
					if (!empty($total_annual_leaves[0]->id)) {
						foreach ($total_annual_leaves as $tot_ann_levs) {
							$annual_amt_pay += (float)$tot_ann_levs->annua_amt;
							$anual_days_leave += $tot_ann_levs->days;
						}
					}
					if ($annual_amt_pay > 0) {
						$payroll_type = 'Annual';
					}
					$month = date('m', $start_month);
					$year = date('Y', $start_month);
					$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
					if ($annual_amt_pay < $daysInMonth) {
						$payroll_type_normal = 'Normal';
					}
					$status = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
				}


				$data[] = array(
					"name" => $name,
					"status" => $status,
					"payroll_type" => $payroll_type . ' ' . $payroll_type_normal,
					"p_date" => $p_date,
				);
			}
			$start_month = strtotime("+1 month", $start_month);
		}

		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['main_data'] = $data;
		$res['start_date'] = $from_date;
		$res['end_date'] = $end_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/payroll_status_report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Payroll_Status_Report.pdf', 'I');
	}

	public function read_leave_details_annual()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('employee_id');
		//$result = $this->Job_post_model->read_job_application_info($id);
		$data = 'A';
		if (!empty($session)) {
			$this->load->view('admin/reports/dialog_leave_details_annual', $data);
		} else {
			redirect('admin/');
		}
	}


	//rahul report section start

	public function monthly_pay_slip_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Monthly Pay Slip" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Monthly Pay Slip";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();
		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/monthly_pay_slip_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}
	}

	public function monthly_pay_slip_report_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		// 		if(!empty($session)){
		// 			$this->load->view("admin/reports/payroll", $data);
		// 		} else {
		// 			redirect('admin/');
		// 		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		// 	$location_company =$_GET['location'];
		// 	$comapny_id =$_GET['comapny_id'];
		// 	$emp_id =$_GET['employee'];
		// 	$department_id =$_GET['department_id'];
		// 	$re_date =$_GET['month_year'];
		$location_company = $this->input->get('location');
		$comapny_id = $this->input->get('comapny_id');
		$emp_id = $this->input->get('employee');
		$department_id = $this->input->get('department_id');
		$re_date = $this->input->get('month_year');
		// echo "$location_company";
		// echo "$comapny_id";
		// echo "$emp_id";
		// echo "$re_date";
		// echo "$department_id"; exit();
		$payslip_re = $this->Reports_model->monthly_payslip_get($re_date, $comapny_id, $department_id, $emp_id, $location_company);


		$data = array();

		foreach ($payslip_re->result() as $value) {

			// get designation
			$designation = $this->Designation_model->read_designation_information($value->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}

			// department
			$department = $this->Department_model->read_department_information($value->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}

			// Employee Account
			$account_id = $this->Reports_model->emp_bank_account($value->employee_id);
			if (!is_null($account_id)) {
				$bank_code = $account_id[0]->bank_code;
				$account_number = $account_id[0]->account_number;

				$bank_acc_details = $bank_code . " & " . $account_number;
			} else {
				$bank_code = '--';
				$account_number = '--';
				$bank_acc_details = '--';
			}


			//get employee leave count
			// var_dump($emp_id);
			// var_dump($re_date);
			//var_dump($comapny_id);die();
			$employee_leave = $this->Reports_model->get_employee_leave_payslip($emp_id, $re_date, $comapny_id);
			//$employee_leave = $this->Reports_model->get_employee_leave_payslip($re_date);
			if (!is_null($employee_leave)) {
				$leave_count = $employee_leave;
			} else {
				$leave_count = '0';
			}

			$employee = $this->Reports_model->read_employee_info($value->employee_id);
			if (!is_null($employee)) {
				$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
				$emp_id = $employee[0]->employee_id;
				$date_of_joining = $employee[0]->date_of_joining;
				$basic_salary = $employee[0]->basic_salary;
			} else {
				$full_name = '--';
				$emp_id = '--';
				$date_of_joining = '--';
				$basic_salary = '--';
			}
			$month_year = $re_date;
			$date = strtotime(date("Y-m-d"));
			if (!isset($month_year)) {
				$day = date('d', $date);
				$month = date('m', $date);
				$year = date('Y', $date);
				$month_year = date('Y-m');
			} else {
				$imonth_year = explode('-', $month_year);
				$day = date('d', $date);
				$month = date($imonth_year[1], $date);
				$year = date($imonth_year[0], $date);
				$month_year = $month_year;
			}

			$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
			$start_date_y_m = date('Y-m', strtotime($month_year));
			$work_day = $this->Reports_model->work_day($year, $month);


			$emp_leave_in_month = $this->Reports_model->lop_days_get($value->employee_id, $year, $month);
			if ($emp_leave_in_month != '') {
				$lop = $emp_leave_in_month[0]->total_days;
			} else {
				$lop = '--';
			}


			$gross_salary = $value->basic_salary;

			$allowances = $this->db->get('allowance');

			foreach ($allowances->result() as $allowance) {
				$data1 = '';
				//allowance type 1
				$sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and salary_month=?';
				$binds = array($value->employee_id, $month_year);
				$payslip_allowance = $this->db->query($sql, $binds)->result();

				if (!empty($payslip_allowance)) {
					foreach ($payslip_allowance as $get) {

						$sql = 'SELECT * FROM allowance WHERE id = ?';
						$binds = array($get->allowance_title);
						$payslip_allowance_name = $this->db->query($sql, $binds)->row();

						$payslip_allowance_name = $payslip_allowance_name->name;
						$space = "&#160;:&#160;";
						$payslip_allowance_amt = $get->allowance_amount;

						$data1 .= $payslip_allowance_name . $space . $payslip_allowance_amt . '<br/>';

						$gross_salary += $payslip_allowance_amt;
					}

					//print_R($data1);exit;

				} else {

					$data1 = "";
					$payslip_allowance_amt = "0";
				}

				//allowance type 2
				$data2 = '';
				$sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and salary_month=?';
				$binds = array($value->employee_id, $month_year);
				$payslip_commission = $this->db->query($sql, $binds)->result();

				if (!empty($payslip_commission)) {
					foreach ($payslip_commission as $get1) {

						$sql = 'SELECT * FROM allowance WHERE id = ?';
						$binds = array($get1->commission_title);
						$payslip_commission_name = $this->db->query($sql, $binds)->row();

						$payslip_commission_name = $payslip_commission_name->name;
						$space = "&#160;:&#160;";
						$payslip_commission_amt = $get1->commission_amount;

						$data2 .= $payslip_commission_name . $space . $payslip_commission_amt . '<br/>';

						$gross_salary += $payslip_commission_amt;
					}
				} else {

					$data2 = "";
					$payslip_commission_amt = "0";
				}

				//allowance type 3
				$data3 = '';
				$sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and salary_month=?';
				$binds = array($value->employee_id, $month_year);
				$statutory_deduction = $this->db->query($sql, $binds)->result();

				if (!empty($statutory_deduction)) {
					foreach ($statutory_deduction as $get2) {

						$sql = 'SELECT * FROM allowance WHERE id = ?';
						$binds = array($get2->deduction_title);
						$statutory_deduction_name = $this->db->query($sql, $binds)->row();

						$statutory_deduction_name = $statutory_deduction_name->name;
						$space = "&#160;:&#160;";
						$statutory_deduction_amt = $get2->deduction_amount;

						$data3 .= $statutory_deduction_name . $space . $statutory_deduction_amt . '<br/>';
						$amount = $get2->deduction_amount;
						$gross_salary -= $amount;
					}
				} else {

					$data3 = "";
					$statutory_deduction_amt = "0";
				}

				//allowance type 4
				/*  $sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';
                		$binds = array($value->employee_id, $month_year);
                		$payslip_other_payments = $this->db->query($sql, $binds)->row();

                		if (! empty($payslip_other_payments)) {

                		    $sql = 'SELECT * FROM allowance WHERE id = ?';
                	    	$binds = array($payslip_other_payments->payments_title);
                		    $payslip_other_payments_name = $this->db->query($sql, $binds)->row();

                		    $payslip_other_payments_name = $payslip_other_payments_name->name;
                		    $space = "&#160;:&#160;";
                		    $payslip_other_payments_amt = $payslip_other_payments->payments_amount;

                		    $data4 = $payslip_other_payments_name.$space.$payslip_other_payments_amt;
                		    $amount = $payslip_other_payments->payments_amount;
                		    $gross_salary += $amount;

                		}else{

                		    $data4 = "";
                		    $payslip_other_payments_amt = "0";

                        }*/

				//allowance type 5
				$data5 = '';
				$sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';
				$binds = array($value->employee_id, $month_year);
				$payslip_loan = $this->db->query($sql, $binds)->result();

				if (!empty($payslip_loan)) {
					foreach ($payslip_loan as $get3) {

						$payslip_loan_name = $get3->loan_title;
						$space = "&#160;:&#160;";
						$amount = $get3->loan_amount;
						$gross_salary -= $amount;

						$data5 .= $payslip_loan_name . $space . $amount . '<br/>';
					}
				} else {

					$data5 = "";
					$amount = "0";
				}
			}

			//Late Deduction
			$emp_id_get = $value->employee_id;
			$sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_id_get";

			$late_deduction_data = $this->db->query($sql_late)->row();
			if (!empty($late_deduction_data)) {
				$late_deduction_data_get = $late_deduction_data->total_late_deduction;
			} else {
				$late_deduction_data_get = '0';
			}

			//Leave Deduction
			$leave_data = $value->leave_deduction;
			if (!empty($leave_data)) {
				$leave_amount = $leave_data;
			} else {
				$leave_amount = "0";
			}

			//overtime get
			$overtime_data = $value->total_overtime;
			if (!empty($overtime_data)) {
				$ot_amount = $overtime_data;
			} else {
				$ot_amount = "0";
			}

			//Advance Salary
			$adv_data = $value->advance_salary_amount;
			if (!empty($adv_data)) {
				$adv_amount = $adv_data;
			} else {
				$adv_amount = "0";
			}


			/*    $earning_details_total = $payslip_allowance_amt+$payslip_commission_amt;
                if($earning_details_total != '0'){
                    $earning_details_name = "Total Earnings";
                    $space = "&#160;:&#160;";
                    $earning_total = $earning_details_name.$space.$earning_details_total;
                }else{
                    $earning_total = "";
                }

                $deduction_details_total = $statutory_deduction_amt+$amount;
                if($deduction_details_total != '0'){
                    $deduction_details_name = "Total Deductions";
                    $space = "&#160;:&#160;";
                    $deduction_total = $deduction_details_name.$space.$deduction_details_total;
                }else{
                    $deduction_total = "";
                } */

			$basic_pay_name = "Basic Pay";
			$space = "&#160;:&#160;";
			$basic_pay = $value->basic_salary;
			$basic_amt = $basic_pay_name . $space . $basic_pay;

			$salary_period = "Monthly (1 to $daysInMonth)";

			$earning_details = $data1 . "" . $data2;

			$deduction_details = $data3 . "" . $data5;

			/* $total_final_netpay = $basic_pay + $earning_details_total;

                $total_final_netpay1 = $total_final_netpay - $deduction_details_total;

                if($total_final_netpay != 0){
                    $total_final_netpay_get = $total_final_netpay1;
                }else{
                    $total_final_netpay_get = "0";
                } */

			$leave_count_get = $daysInMonth - $value->monthy_present_days;

			$data[] = array(
				$emp_id,
				$full_name,
				$department_name,
				$designation_name,
				$bank_acc_details,
				$salary_period,
				$daysInMonth,
				$value->monthy_present_days,
				$leave_count,
				$lop,
				$basic_pay,
				"<b>" . $earning_details . "</b>",
				"<b>" . $deduction_details . "</b>",
				$late_deduction_data_get,
				$leave_amount,
				$ot_amount,
				$adv_amount,
				$value->net_salary
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $payslip_re->num_rows(),
			"recordsFiltered" => $payslip_re->num_rows(),
			"data" => $data
		);

		echo json_encode($output);
		exit();
	}


	public function monthly_payroll_summary_page()
	{


		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}


		$data['title'] = "Monthly Payroll Summary" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Monthly Payroll Summary";

		$data['all_companies'] = $this->Xin_model->get_companies();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['all_location'] = $this->Location_model->all_office_locations();

		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/monthly_payroll_summary_report", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}


	public function monthly_payroll_summary_report_get()
	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/employees", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));


		$company_id = $_GET['company_id'];

		$location_company = $_GET['location_company'];

		$department_id = $_GET['department_id'];

		$emp_id = $_GET['emp_id'];

		$month_year = $_GET['month_year'];


		$monthly_payroll_summary = $this->Reports_model->monthly_payroll_summary_get($company_id, $location_company, $department_id, $emp_id, $month_year);

		$data_filtered = array();

		$data = array();

		if (count($monthly_payroll_summary) > 0) {

			foreach ($monthly_payroll_summary as $value) {

				// department
				$department = $this->Department_model->read_department_information($value->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}


				//get head count
				$head_count = $this->Reports_model->get_head_count($value->department_id, $month_year);
				if (!is_null($head_count)) {
					$head_count_get = $head_count[0]->headcount;
				} else {
					$head_count_get = '--';
				}

				//get basic salary
				$basic_salary = $this->Reports_model->get_basic_salary($value->department_id, $month_year);
				if (!is_null($basic_salary)) {
					$basic_salary_data = $basic_salary[0]->total_salary;
				} else {
					$basic_salary_data = '--';
				}

				$tmp = array(
					$department_name,
					$head_count_get,
					$basic_salary_data,
				);

				$gross_salary = $basic_salary_data;

				$allowances = $this->db->get('allowance');

				foreach ($allowances->result() as $allowance) {

					if ($allowance->type_id == 1) {

						$sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$payslip_allowance = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_allowance)) {

							$amount_data = $payslip_allowance->allowance_amount_total;

							$gross_salary += $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_allowance->allowance_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 2) {

						$sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$payslip_commission = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_commission)) {

							$amount_data = $payslip_commission->commission_amount_total;

							$gross_salary += $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_commission->commission_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 3) {

						$sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$statutory_deduction = $this->db->query($sql, $binds)->row();

						if (!empty($statutory_deduction)) {

							$amount_data = $statutory_deduction->deduction_amount_total;

							$gross_salary -= $amount_data;

							if ($amount_data != '') {
								$amount = $statutory_deduction->deduction_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 4) {

						$sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$payslip_other_payments = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_other_payments)) {

							$amount_data = $payslip_other_payments->payments_amount_total;

							$gross_salary += $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_other_payments->payments_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 5) {

						$sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

						$binds = array($month_year, $value->department_id);

						$payslip_loan = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_loan)) {

							$amount_data = $payslip_loan->loan_amount_total;

							$gross_salary -= $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_loan->loan_amount_total;
							} else {
								$amount = '0';
							}
						}
					}

					array_push(
						$tmp,
						$amount

					);
				}

				//Late Deduction
				$sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

				$late_deduction_data = $this->db->query($sql_late)->row();
				if (!empty($late_deduction_data)) {
					$late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
				} else {
					$late_deduction_data_get = '0';
				}

				//Leave Deduction
				$sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
				$leave_data = $this->db->query($sql_leave)->row();

				if (!empty($leave_data)) {
					$leave_amount = $leave_data->total_leave_deduction_amt;
				} else {
					$leave_amount = "0";
				}

				//overtime get
				$sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
				$overtime_data = $this->db->query($sql_ot)->row();

				if (!empty($overtime_data)) {
					$ot_amount = $overtime_data->total_ot_amt;
				} else {
					$ot_amount = "0";
				}

				//Advance Salary
				$sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
				$adv_data = $this->db->query($sql_adv)->row();

				if (!empty($adv_data)) {
					$adv_amount = $adv_data->total_adv_amt;
				} else {
					$adv_amount = "0";
				}

				//get Gross salary
				$gross_salary = $this->Reports_model->get_gross_salary($value->department_id, $month_year);
				if (!is_null($gross_salary)) {
					$gross_salary_data = $gross_salary[0]->gross_salary;
				} else {
					$gross_salary_data = '--';
				}

				array_push(
					$tmp,
					$late_deduction_data_get,
					$leave_amount,
					$ot_amount,
					$adv_amount,
					$gross_salary_data
				);


				$data[] = $tmp;
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}


	//payroll reconciliation start
	public function payroll_reconciliation_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = "Payroll Reconciliation Report" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Payroll Reconciliation Report";

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/payroll_reconciliation_page", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}

	public function payroll_reconciliation_get()
	{

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/employees", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$current_month_year = $_GET['current_month_year'];
		$compare_month_year = $_GET['compare_month_year'];

		$current_date = $current_month_year;
		$compare_date = $compare_month_year;

		//current date
		$month_year_cur = $current_date;
		$year_month_spilt_cur = explode("-", $month_year_cur);
		$year_cur = $year_month_spilt_cur[0];
		$month_cur = $year_month_spilt_cur[1];

		//month character decrease
		$monthName_cur = date("F", mktime(0, 0, 0, $month_cur, 1));
		$month_name_cur_get = substr($monthName_cur, 0, 3);

		$month_year_cur_get = $month_name_cur_get . ',' . $year_cur;

		//compare date
		$month_year_com = $compare_date;
		$year_month_spilt_com = explode("-", $month_year_com);
		$year_com = $year_month_spilt_com[0];
		$month_com = $year_month_spilt_com[1];

		//month character decrease
		$monthName_com = date("F", mktime(0, 0, 0, $month_com, 1));
		$month_name_com_get = substr($monthName_com, 0, 3);

		$month_year_com_get = $month_name_com_get . ',' . $year_com;

		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Payroll Reconciliation Report (" . $month_year_cur_get . " To " . $month_year_com_get . ")</strong></span>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='payroll_reconciliation_report_datatable'>
		        <table class='datatables-demo table table-striped table-bordered' id='payroll_reconciliation_table_main'>";

		//---------------------table 1 basic salary list

		$table .= "<thead>
                      <tr><th colspan='6' style='text-align:center; border-right: 1px solid #eee;'>All Earnings List</th></tr>
                      <tr>
                      <th>Earning Description</th>
                      <th>Currency</th>
                      <th>" . $month_year_cur_get . "</th>
                      <th>" . $month_year_com_get . "</th>
                      <th>Variance</th>
                      <th style='border-right: 1px solid #eee;'>Variance %</th>
                      </tr>";

		$table .= "</thead><tbody>";


		$table .= "<tr>
                 <td>Basic Salary</td>
                 <td>Dirhams</td>";
		$basic_salary_get = $this->Reports_model->basic_salary_get($current_date);
		foreach ($basic_salary_get->result() as $get_basic_data) {

			if ($get_basic_data->total_basic_salary != '') {
				$table .= " <td>" . $get_basic_data->total_basic_salary . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_get = $this->Reports_model->compare_data_get($compare_date);
			foreach ($compare_data_get->result() as $get_compare_data) {

				if ($get_compare_data->total_compare_basic_salary != '') {
					$table .= " <td>" . $get_compare_data->total_compare_basic_salary . "</td>";
				} else {
					$table .= " <td>0</td>";
				}

				$variance = $get_basic_data->total_basic_salary - $get_compare_data->total_compare_basic_salary;


				if ($get_basic_data->total_basic_salary != 0) {
					$total_basic_salary = $get_basic_data->total_basic_salary;
				} else {
					$total_basic_salary = 1;
				}

				if ($variance != 0) {
					$variance_data = $variance;
				} else {
					$variance_data = 1;
				}

				$variance_percentage_1 = $variance_data / $total_basic_salary;
				$variance_percentage_final = $variance_percentage_1 * 100;

				if ($get_basic_data->total_basic_salary == 0 && $variance == 0) {
					$final_calu_basic_data = 0;
				} else {
					$final_calu_basic_data = $variance_percentage_final;
				}

				$table .= "<td>" . $variance . "</td>
                  <td style='border-right: 1px solid #eee;'>" . $final_calu_basic_data . "</td>";
			}
		}

		$table .= "</tr> ";


		//----------------------- table 1 allowance list


		$sql1 = "SELECT * FROM allowance WHERE type_id = 1";
		$result1 = $this->db->query($sql1);


		foreach ($result1->result() as $value1) {
			$table .= "<tr>";

			$table .= " <td>" . $value1->name . "</td>";

			$allowance_name_id = $value1->id;

			$sql1 = "SELECT SUM(allowance_amount) as sum_score FROM xin_salary_payslip_allowances WHERE allowance_title = $allowance_name_id and salary_month = '$current_date'";
			$result2 = $this->db->query($sql1);

			foreach ($result2->result() as $value2) {

				$table .= "<td>Dirhams</td>";

				if ($value2->sum_score != '') {
					$table .= " <td>" . $value2->sum_score . "</td>";
				} else {
					$table .= " <td>0</td>";
				}


				$sql2 = "SELECT SUM(allowance_amount) as sum_score FROM xin_salary_payslip_allowances WHERE allowance_title = $allowance_name_id and salary_month = '$compare_date'";
				$result3 = $this->db->query($sql2);

				foreach ($result3->result() as $value3) {


					if ($value3->sum_score != '') {
						$table .= " <td>" . $value3->sum_score . "</td>";
					} else {
						$table .= " <td>0</td>";
					}

					$variance_allow = $value2->sum_score - $value3->sum_score;

					if ($value2->sum_score != 0) {
						$total_allow = $value2->sum_score;
					} else {
						$total_allow = 1;
					}

					if ($variance_allow != 0) {
						$variance_data = $variance_allow;
					} else {
						$variance_data = 1;
					}

					$variance_allow_percentage_1 = $variance_data / $total_allow;
					$variance_allow_percentage_final = $variance_allow_percentage_1 * 100;

					if ($value2->sum_score == 0 && $variance_allow == 0) {
						$final_calu_allow_data = 0;
					} else {
						$final_calu_allow_data = $variance_allow_percentage_final;
					}


					$table .= "<td>" . $variance_allow . "</td> 
             <td style='border-right: 1px solid #eee;'>" . $final_calu_allow_data . "</td>";
				}
			}

			$table .= "</tr> ";
		}

		$table .= " </tbody>";

		//---------------------------

		//table 2 basic salary list

		$table .= "<thead>
                      <tr><th colspan='6' style='border-top: 1px solid #eee; border-bottom-style: none;'></th></tr>
                      
                      <tr><th colspan='7' style='text-align:center; border-right: 1px solid #eee;'>Employees Wise Basic Salary List</th></tr>
                      <tr>
                      <th>Emp Code</th>
                      <th>Employee</th>
                      <th>Currency</th>
                      <th>" . $month_year_cur_get . "</th>
                      <th>" . $month_year_com_get . "</th>
                      <th>Variance</th>
                      <th style='border-right: 1px solid #eee;'>Variance %</th>
                      </tr>";

		$table .= "</thead><tbody>";


		$basic_salary_details_get = $this->Reports_model->basic_salary_details_get($current_date);
		foreach ($basic_salary_details_get->result() as $details_get_basic_data) {

			$employee_main_id = $this->Reports_model->read_employee_info($details_get_basic_data->employee_id);
			if (!is_null($employee_main_id)) {
				$emp_id = $employee_main_id[0]->employee_id;
				$emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}


			$table .= "<tr>
                 <td>" . $emp_id . "</td>
                 <td>" . $emp_name . "</td>
                 <td>Dirhams</td>";

			if ($details_get_basic_data->basic_salary != '') {
				$table .= " <td>" . $details_get_basic_data->basic_salary . "</td>";
			} else {
				$table .= " <td>0</td>";
			}


			$compare_data_details_get = $this->Reports_model->compare_data_details_get($details_get_basic_data->employee_id, $compare_date);
			if (!is_null($compare_data_details_get)) {
				$compare_data_basic = $compare_data_details_get[0]->basic_salary;
			} else {
				$compare_data_basic = '0';
			}

			$table .= "<td>" . $compare_data_basic . "</td>";

			$detail_variance = $details_get_basic_data->basic_salary - $compare_data_basic;
			if ($details_get_basic_data->basic_salary != 0) {
				$details_total_basic_salary = $details_get_basic_data->basic_salary;
			} else {
				$details_total_basic_salary = 1;
			}

			if ($detail_variance != 0) {
				$detail_variance_data = $detail_variance;
			} else {
				$detail_variance_data = 1;
			}

			$variance_percentage_details = $detail_variance_data / $details_total_basic_salary;
			$variance_percentage_details_final = $variance_percentage_details * 100;

			if ($details_get_basic_data->basic_salary == 0 && $detail_variance == 0) {
				$final_calu_basic_data_details = 0;
			} else {
				$final_calu_basic_data_details = $variance_percentage_details_final;
			}

			$table .= "<td>" . $detail_variance . "</td>
                  <td style='border-right: 1px solid #eee;'>" . $final_calu_basic_data_details . "</td>";


			$table .= "</tr> ";
		}


		//----------------------- allowance
		$table .= "<tr><th colspan='7' style='border-top: 1px solid #eee; border-bottom-style: none;'></th></tr>";

		$table .= "<tr>
                      <tr><th colspan='8' style='text-align:center; border-right: 1px solid #eee;'>Employees Wise Allowance and Deduction List</th></tr>
                      <th>Allowance Name</th>
                      <th>Emp Code</th>
                      <th>Employee</th>
                      <th>Currency</th>
                      <th>" . $month_year_cur_get . "</th>
                      <th>" . $month_year_com_get . "</th>
                      <th>Variance</th>
                      <th>Variance %</th>
                      </tr>";


		$sql12 = "SELECT * FROM xin_salary_payslip_allowances WHERE salary_month = '$current_date'";
		$result12 = $this->db->query($sql12);


		foreach ($result12->result() as $value12) {
			$table .= "<tr>";

			$allowance_title_id = $value12->allowance_title;


			$allowane_title_get = $this->Reports_model->allowane_title_get($allowance_title_id);
			if (!is_null($allowane_title_get)) {
				$allowance_name = $allowane_title_get[0]->name;
			} else {
				$allowance_name = '--';
			}

			$table .= " <td>" . $allowance_name . "</td>";

			$employee_main_id_allo = $this->Reports_model->read_employee_info($value12->employee_id);
			if (!is_null($employee_main_id_allo)) {
				$emp_id = $employee_main_id_allo[0]->employee_id;
				$emp_name = $employee_main_id_allo[0]->first_name . ' ' . $employee_main_id_allo[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			$table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

			if ($value12->allowance_amount != '') {
				$table .= " <td>" . $value12->allowance_amount . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_details_allo_get = $this->Reports_model->compare_data_details_allo_get($value12->employee_id, $compare_date);
			if (!is_null($compare_data_details_allo_get)) {
				$compare_data_basic_allo = $compare_data_details_allo_get[0]->allowance_amount;
			} else {
				$compare_data_basic_allo = '0';
			}

			$table .= "<td>" . $compare_data_basic_allo . "</td>";

			$detail_variance_allo = $value12->allowance_amount - $compare_data_basic_allo;

			if ($value12->allowance_amount != 0) {
				$allo_total_basic_salary = $value12->allowance_amount;
			} else {
				$allo_total_basic_salary = 1;
			}

			if ($detail_variance_allo != 0) {
				$allo_variance_data = $detail_variance_allo;
			} else {
				$allo_variance_data = 1;
			}

			$variance_percentage_allo = $allo_variance_data / $allo_total_basic_salary;
			$variance_percentage_allo_final = $variance_percentage_allo * 100;

			if ($value12->allowance_amount == 0 && $detail_variance_allo == 0) {
				$final_calu_basic_data_allo = 0;
			} else {
				$final_calu_basic_data_allo = $variance_percentage_allo_final;
			}

			$table .= "<td>" . $detail_variance_allo . "</td>
                  <td>" . $final_calu_basic_data_allo . "</td>";

			$table .= "</tr>";
		}

		//---------------------- commission

		$sql_com = "SELECT * FROM xin_salary_payslip_commissions WHERE salary_month = '$current_date'";
		$result_com = $this->db->query($sql_com);


		foreach ($result_com->result() as $value_com) {
			$table .= "<tr>";

			$allowance_title_id = $value_com->commission_title;

			$allowane_title_get = $this->Reports_model->allowane_title_get($allowance_title_id);
			if (!is_null($allowane_title_get)) {
				$allowance_name = $allowane_title_get[0]->name;
			} else {
				$allowance_name = '--';
			}

			$table .= " <td>" . $allowance_name . "</td>";

			$employee_main_id_allo = $this->Reports_model->read_employee_info($value_com->employee_id);
			if (!is_null($employee_main_id_allo)) {
				$emp_id = $employee_main_id_allo[0]->employee_id;
				$emp_name = $employee_main_id_allo[0]->first_name . ' ' . $employee_main_id_allo[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			$table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

			if ($value_com->commission_amount != '') {
				$table .= " <td>" . $value_com->commission_amount . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_details_com_get = $this->Reports_model->compare_data_details_com_get($value_com->employee_id, $compare_date);
			if (!is_null($compare_data_details_com_get)) {
				$compare_data_basic_com = $compare_data_details_com_get[0]->commission_amount;
			} else {
				$compare_data_basic_com = '0';
			}

			$table .= "<td>" . $compare_data_basic_com . "</td>";

			$detail_variance_com = $value_com->commission_amount - $compare_data_basic_com;

			if ($value_com->commission_amount != 0) {
				$com_total_basic_salary = $value_com->commission_amount;
			} else {
				$com_total_basic_salary = 1;
			}

			if ($detail_variance_com != 0) {
				$com_variance_data = $detail_variance_com;
			} else {
				$com_variance_data = 1;
			}

			$variance_percentage_com = $com_variance_data / $com_total_basic_salary;
			$variance_percentage_com_final = $variance_percentage_com * 100;

			if ($value_com->commission_amount == 0 && $detail_variance_com == 0) {
				$final_calu_basic_data_com = 0;
			} else {
				$final_calu_basic_data_com = $variance_percentage_com_final;
			}

			$table .= "<td>" . $detail_variance_com . "</td>
                  <td>" . $final_calu_basic_data_com . "</td>";

			$table .= "</tr>";
		}

		//---------------------- other payments

		$sql_op = "SELECT * FROM xin_salary_payslip_other_payments WHERE salary_month = '$current_date'";
		$result_op = $this->db->query($sql_op);


		foreach ($result_op->result() as $value_op) {
			$table .= "<tr>";

			$allowance_title_id = $value_op->payments_title;

			$allowane_title_get = $this->Reports_model->allowane_title_get($allowance_title_id);
			if (!is_null($allowane_title_get)) {
				$allowance_name = $allowane_title_get[0]->name;
			} else {
				$allowance_name = '--';
			}

			$table .= " <td>" . $allowance_name . "</td>";

			$employee_main_id_op = $this->Reports_model->read_employee_info($value_op->employee_id);
			if (!is_null($employee_main_id_op)) {
				$emp_id = $employee_main_id_op[0]->employee_id;
				$emp_name = $employee_main_id_op[0]->first_name . ' ' . $employee_main_id_op[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			$table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

			if ($value_op->payments_amount != '') {
				$table .= " <td>" . $value_op->payments_amount . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_details_op_get = $this->Reports_model->compare_data_details_op_get($value_op->employee_id, $compare_date);
			if (!is_null($compare_data_details_op_get)) {
				$compare_data_basic_op = $compare_data_details_op_get[0]->payments_amount;
			} else {
				$compare_data_basic_op = '0';
			}

			$table .= "<td>" . $compare_data_basic_op . "</td>";

			$detail_variance_op = $value_op->payments_amount - $compare_data_basic_op;

			if ($value_op->payments_amount != 0) {
				$op_total_basic_salary = $value_op->payments_amount;
			} else {
				$op_total_basic_salary = 1;
			}

			if ($detail_variance_op != 0) {
				$op_variance_data = $detail_variance_op;
			} else {
				$op_variance_data = 1;
			}

			$variance_percentage_op = $op_variance_data / $op_total_basic_salary;
			$variance_percentage_op_final = $variance_percentage_op * 100;

			if ($value_op->payments_amount == 0 && $detail_variance_op == 0) {
				$final_calu_basic_data_op = 0;
			} else {
				$final_calu_basic_data_op = $variance_percentage_op_final;
			}

			$table .= "<td>" . $detail_variance_op . "</td>
                  <td>" . $final_calu_basic_data_op . "</td>";

			$table .= "</tr>";
		}

		//---------------------- statutory deductions

		$sql_sd = "SELECT * FROM xin_salary_payslip_statutory_deductions WHERE salary_month = '$current_date'";
		$result_sd = $this->db->query($sql_sd);


		foreach ($result_sd->result() as $value_sd) {
			$table .= "<tr>";

			$allowance_title_id = $value_sd->deduction_title;

			$allowane_title_get = $this->Reports_model->allowane_title_get($allowance_title_id);
			if (!is_null($allowane_title_get)) {
				$allowance_name = $allowane_title_get[0]->name;
			} else {
				$allowance_name = '--';
			}

			$table .= " <td>" . $allowance_name . "</td>";

			$employee_main_id_sd = $this->Reports_model->read_employee_info($value_sd->employee_id);
			if (!is_null($employee_main_id_sd)) {
				$emp_id = $employee_main_id_sd[0]->employee_id;
				$emp_name = $employee_main_id_sd[0]->first_name . ' ' . $employee_main_id_sd[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			$table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

			if ($value_sd->deduction_amount != '') {
				$table .= " <td>" . $value_sd->deduction_amount . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_details_sd_get = $this->Reports_model->compare_data_details_sd_get($value_sd->employee_id, $compare_date);
			if (!is_null($compare_data_details_sd_get)) {
				$compare_data_basic_sd = $compare_data_details_sd_get[0]->deduction_amount;
			} else {
				$compare_data_basic_sd = '0';
			}

			$table .= "<td>" . $compare_data_basic_sd . "</td>";

			$detail_variance_sd = $value_sd->deduction_amount - $compare_data_basic_sd;

			if ($value_sd->deduction_amount != 0) {
				$sd_total_basic_salary = $value_sd->deduction_amount;
			} else {
				$sd_total_basic_salary = 1;
			}

			if ($detail_variance_sd != 0) {
				$sd_variance_data = $detail_variance_sd;
			} else {
				$sd_variance_data = 1;
			}

			$variance_percentage_sd = $sd_variance_data / $sd_total_basic_salary;
			$variance_percentage_sd_final = $variance_percentage_sd * 100;

			if ($value_sd->deduction_amount == 0 && $detail_variance_sd == 0) {
				$final_calu_basic_data_sd = 0;
			} else {
				$final_calu_basic_data_sd = $variance_percentage_sd_final;
			}

			$table .= "<td>" . $detail_variance_sd . "</td>
                  <td>" . $final_calu_basic_data_sd . "</td>";

			$table .= "</tr>";
		}


		//---------------------- payslip loan

		$sql_pl = "SELECT * FROM xin_salary_payslip_loan WHERE salary_month = '$current_date'";
		$result_pl = $this->db->query($sql_pl);


		foreach ($result_pl->result() as $value_pl) {
			$table .= "<tr>";

			$allowance_title_name = $value_pl->loan_title;

			$table .= " <td>" . $allowance_title_name . "</td>";

			$employee_main_id_pl = $this->Reports_model->read_employee_info($value_pl->employee_id);
			if (!is_null($employee_main_id_pl)) {
				$emp_id = $employee_main_id_pl[0]->employee_id;
				$emp_name = $employee_main_id_pl[0]->first_name . ' ' . $employee_main_id_pl[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			$table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

			if ($value_pl->loan_amount != '') {
				$table .= " <td>" . $value_pl->loan_amount . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_details_pl_get = $this->Reports_model->compare_data_details_pl_get($value_pl->employee_id, $compare_date);
			if (!is_null($compare_data_details_pl_get)) {
				$compare_data_basic_pl = $compare_data_details_pl_get[0]->loan_amount;
			} else {
				$compare_data_basic_pl = '0';
			}

			$table .= "<td>" . $compare_data_basic_pl . "</td>";

			$detail_variance_pl = $value_pl->loan_amount - $compare_data_basic_pl;

			if ($value_pl->loan_amount != 0) {
				$pl_total_basic_salary = $value_pl->loan_amount;
			} else {
				$pl_total_basic_salary = 1;
			}

			if ($detail_variance_pl != 0) {
				$pl_variance_data = $detail_variance_pl;
			} else {
				$pl_variance_data = 1;
			}

			$variance_percentage_pl = $pl_variance_data / $pl_total_basic_salary;
			$variance_percentage_pl_final = $variance_percentage_pl * 100;

			if ($value_pl->loan_amount == 0 && $detail_variance_pl == 0) {
				$final_calu_basic_data_pl = 0;
			} else {
				$final_calu_basic_data_pl = $variance_percentage_pl_final;
			}

			$table .= "<td>" . $detail_variance_pl . "</td>
                  <td>" . $final_calu_basic_data_pl . "</td>";

			$table .= "</tr>";
		}


		//---------------------- late deduction

		$sql_ld = "SELECT * FROM xin_salary_payslips WHERE salary_month = '$current_date'";
		$result_ld = $this->db->query($sql_ld);


		foreach ($result_ld->result() as $value_ld) {
			$table .= "<tr>";

			$allowance_title_name = "Late Deduction";

			$table .= " <td>" . $allowance_title_name . "</td>";

			$employee_main_id_ld = $this->Reports_model->read_employee_info($value_ld->employee_id);
			if (!is_null($employee_main_id_ld)) {
				$emp_id = $employee_main_id_ld[0]->employee_id;
				$emp_name = $employee_main_id_ld[0]->first_name . ' ' . $employee_main_id_ld[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			$table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

			if ($value_ld->total_late_deduction != '') {
				$table .= " <td>" . $value_ld->total_late_deduction . "</td>";
			} else {
				$table .= " <td>0</td>";
			}

			$compare_data_details_ld_get = $this->Reports_model->compare_data_details_ld_get($value_ld->employee_id, $compare_date);
			if (!is_null($compare_data_details_ld_get)) {
				$compare_data_basic_ld = $compare_data_details_ld_get[0]->total_late_deduction;
			} else {
				$compare_data_basic_ld = '0';
			}

			$table .= "<td>" . $compare_data_basic_ld . "</td>";

			$detail_variance_ld = $value_ld->total_late_deduction - $compare_data_basic_ld;

			if ($value_ld->total_late_deduction != 0) {
				$ld_total_basic_salary = $value_ld->total_late_deduction;
			} else {
				$ld_total_basic_salary = 1;
			}

			if ($detail_variance_ld != 0) {
				$ld_variance_data = $detail_variance_ld;
			} else {
				$ld_variance_data = 1;
			}

			$variance_percentage_ld = $ld_variance_data / $ld_total_basic_salary;
			$variance_percentage_ld_final = $variance_percentage_ld * 100;

			if ($value_ld->total_late_deduction == 0 && $detail_variance_ld == 0) {
				$final_calu_basic_data_ld = 0;
			} else {
				$final_calu_basic_data_ld = $variance_percentage_ld_final;
			}

			$table .= "<td>" . $detail_variance_ld . "</td>
                  <td>" . $final_calu_basic_data_ld . "</td>";

			$table .= "</tr>";
		}


		$table .= " </tbody>";


		$table .= "</table>
                 </div>
                 </div>";

		header("Content-type: application/json");
		echo json_encode($table);
		exit();
	}

	//payroll reconciliation end


	public function department_wise_summary_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = "Department Wise Summary Sheet Report" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Department Wise Summary Sheet Report";

		$data['all_companies'] = $this->Xin_model->get_companies();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/department_wise_summary_page", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}

	public function department_wise_summary_get()
	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/employees", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));


		$aj_company = $_GET['aj_company'];

		$aj_department = $_GET['aj_department'];

		$location_id = $_GET['location_id'];

		$paysheet_employee_id = $_GET['paysheet_employee_id'];

		$month_year = $_GET['month_year'];


		$department_wise_summary = $this->Reports_model->department_wise_summary_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $month_year);

		$data_filtered = array();

		$data = array();

		if (count($department_wise_summary) > 0) {

			foreach ($department_wise_summary as $value) {

				// department
				$department = $this->Department_model->read_department_information($value->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}


				//get head count
				$head_count = $this->Reports_model->get_head_count($value->department_id, $month_year);
				if (!is_null($head_count)) {
					$head_count_get = $head_count[0]->headcount;
				} else {
					$head_count_get = '--';
				}

				//get basic salary
				$basic_salary = $this->Reports_model->get_basic_salary($value->department_id, $month_year);
				if (!is_null($basic_salary)) {
					$basic_salary_data = $basic_salary[0]->total_salary;
				} else {
					$basic_salary_data = '--';
				}

				$tmp = array(
					$department_name,
					$head_count_get,
					$basic_salary_data,
				);

				$gross_salary = $basic_salary_data;

				$allowances = $this->db->get('allowance');

				foreach ($allowances->result() as $allowance) {

					if ($allowance->type_id == 1) {

						$sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$payslip_allowance = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_allowance)) {

							$amount_data = $payslip_allowance->allowance_amount_total;

							$gross_salary += $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_allowance->allowance_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 2) {

						$sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$payslip_commission = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_commission)) {

							$amount_data = $payslip_commission->commission_amount_total;

							$gross_salary += $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_commission->commission_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 3) {

						$sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$statutory_deduction = $this->db->query($sql, $binds)->row();

						if (!empty($statutory_deduction)) {

							$amount_data = $statutory_deduction->deduction_amount_total;

							$gross_salary -= $amount_data;

							if ($amount_data != '') {
								$amount = $statutory_deduction->deduction_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 4) {

						$sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

						$binds = array($allowance->id, $month_year, $value->department_id);

						$payslip_other_payments = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_other_payments)) {

							$amount_data = $payslip_other_payments->payments_amount_total;

							$gross_salary += $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_other_payments->payments_amount_total;
							} else {
								$amount = '0';
							}
						}
					} else if ($allowance->type_id == 5) {

						$sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

						$binds = array($month_year, $value->department_id);

						$payslip_loan = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_loan)) {

							$amount_data = $payslip_loan->loan_amount_total;

							$gross_salary -= $amount_data;

							if ($amount_data != '') {
								$amount = $payslip_loan->loan_amount_total;
							} else {
								$amount = '0';
							}
						}
					}

					array_push(
						$tmp,
						$amount

					);
				}

				//Late Deduction
				$sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

				$late_deduction_data = $this->db->query($sql_late)->row();
				if (!empty($late_deduction_data)) {
					$late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
				} else {
					$late_deduction_data_get = '0';
				}

				//Leave Deduction
				$sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
				$leave_data = $this->db->query($sql_leave)->row();

				if (!empty($leave_data)) {
					$leave_amount = $leave_data->total_leave_deduction_amt;
				} else {
					$leave_amount = "0";
				}

				//overtime get
				$sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
				$overtime_data = $this->db->query($sql_ot)->row();

				if (!empty($overtime_data)) {
					$ot_amount = $overtime_data->total_ot_amt;
				} else {
					$ot_amount = "0";
				}

				//Advance Salary
				$sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
				$adv_data = $this->db->query($sql_adv)->row();

				if (!empty($adv_data)) {
					$adv_amount = $adv_data->total_adv_amt;
				} else {
					$adv_amount = "0";
				}

				//get Gross salary
				$gross_salary = $this->Reports_model->get_gross_salary($value->department_id, $month_year);
				if (!is_null($gross_salary)) {
					$gross_salary_data = $gross_salary[0]->gross_salary;
				} else {
					$gross_salary_data = '--';
				}

				array_push(
					$tmp,
					$late_deduction_data_get,
					$leave_amount,
					$ot_amount,
					$adv_amount,
					$gross_salary_data
				);


				$data[] = $tmp;
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	//pay sheet period
	public function pay_sheet_period_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = "Pay Sheet of a Period" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Pay Sheet in a Period";

		$data['all_companies'] = $this->Xin_model->get_companies();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/pay_sheet_period", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}

	public function pay_sheet_period_get()
	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/payroll", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$paysheet_employee_id = $_GET['paysheet_employee_id'];
		$from_month_year = $_GET['from_month_year'];
		$to_month_year = $_GET['to_month_year'];

		$payslip_re = $this->Reports_model->pay_sheet_period_data_get($aj_company, $aj_department, $location_id, $paysheet_employee_id, $from_month_year, $to_month_year);

		//print_r($payslip_re);exit;

		$payslip_demo_data = $this->demo_data();

		$data_filtered = array();

		$data = array();

		if (count($payslip_re) > 0) {

			foreach ($payslip_re as $value) {

				$employee = $this->Reports_model->read_employee_info($value->employee_id);

				if (!is_null($employee)) {

					$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

					$emp_id = $employee[0]->employee_id;

					$date_of_joining = $employee[0]->date_of_joining;

					$basic_salary = $employee[0]->basic_salary;
				} else {

					$full_name = '--';

					$emp_id = '--';

					$date_of_joining = '--';

					$basic_salary = '--';
				}

				$month_year = $from_month_year;

				$date = strtotime(date("Y-m-d"));

				if (!isset($month_year)) {

					$day = date('d', $date);

					$month = date('m', $date);

					$year = date('Y', $date);

					$month_year = date('Y-m');
				} else {

					$imonth_year = explode('-', $month_year);

					$day = date('d', $date);

					$month = date($imonth_year[1], $date);

					$year = date($imonth_year[0], $date);

					$month_year = $month_year;
				}

				$daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

				$start_date_y_m = date('Y-m', strtotime($month_year));

				$work_day = $this->Reports_model->work_day($year, $month);


				$emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);

				if ($emp_leave_in_month != '') {

					$lop = $emp_leave_in_month[0]->monthly_leaves;
				} else {

					$lop = '--';
				}

				//test
				$sql1 = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ?';
				$binds1 = array($value->employee_id);
				$payslip_allowance = $this->db->query($sql1, $binds1)->row();

				if (!empty($payslip_allowance)) {
					$amount1 = $payslip_allowance->allowance_amount;
				} else {
					$amount1 = '0';
				}

				$sql2 = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ?';
				$binds2 = array($value->employee_id);
				$payslip_commission = $this->db->query($sql2, $binds2)->row();

				if (!empty($payslip_commission)) {
					$amount2 = $payslip_commission->commission_amount;
				} else {
					$amount2 = '0';
				}

				$sql3 = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ?';
				$binds3 = array($value->employee_id);
				$payslip_other_payments = $this->db->query($sql3, $binds3)->row();

				if (!empty($payslip_other_payments)) {
					$amount3 = $payslip_other_payments->payments_amount;
				} else {
					$amount3 = '0';
				}

				//get carry leave
				$carry_leaves = $this->Reports_model->get_carry_leaves($value->employee_id);
				if (!is_null($carry_leaves)) {
					$carry_leaves_get = $carry_leaves[0]->remaing_leave_count;
				} else {
					$carry_leaves_get = '0';
				}

				$month_year = $value->salary_month;
				$year_month_spilt = explode("-", $month_year);
				$year = $year_month_spilt[0];
				$month = $year_month_spilt[1];
				$month_days = cal_days_in_month(CAL_GREGORIAN, $month, $year);

				$absent_days = $month_days - $value->monthy_present_days;

				//month character decrease
				$monthName = date("F", mktime(0, 0, 0, $month, 1));
				$month_name_get = substr($monthName, 0, 3);

				$p_a_days = 'P:' . $value->monthy_present_days . '<br>' . 'A:' . $absent_days;

				$month_total_allo = $value->basic_salary + $amount1 + $amount2 + $amount3;

				$emp_info = $emp_id . '<br>' . $full_name;

				$month_year_get = $month_name_get . ',' . $year;


				$tmp = array(

					$emp_info,

					$month_year_get,

					$p_a_days,

					$value->basic_salary,

					$value->basic_salary,

					$lop


				);

				$gross_salary = $value->basic_salary;

				$allowances = $this->db->get('allowance');

				foreach ($allowances->result() as $allowance) {

					if ($allowance->type_id == 1) {

						$sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';

						$binds = array($value->employee_id, $allowance->id, $month_year);

						$payslip_allowance = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_allowance)) {

							$amount = $payslip_allowance->allowance_amount;

							$gross_salary += $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 2) {

						$sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and commission_title=? and salary_month=?';

						$binds = array($value->employee_id, $allowance->id, $month_year);

						$payslip_commission = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_commission)) {

							$amount = $payslip_commission->commission_amount;

							$gross_salary += $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 3) {

						$sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and deduction_title=? and salary_month=?';

						$binds = array($value->employee_id, $allowance->id, $month_year);

						$statutory_deduction = $this->db->query($sql, $binds)->row();

						if (!empty($statutory_deduction)) {

							$amount = $statutory_deduction->deduction_amount;

							$gross_salary -= $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 4) {

						$sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';

						$binds = array($value->employee_id, $month_year);

						$payslip_other_payments = $this->db->query($sql, $binds)->row();


						if (!empty($payslip_other_payments)) {

							$amount = $payslip_other_payments->payments_amount;

							$gross_salary += $amount;
						} else

							$amount = '--';
					} else if ($allowance->type_id == 5) {

						$sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';

						$binds = array($value->employee_id, $month_year);

						$payslip_loan = $this->db->query($sql, $binds)->row();

						if (!empty($payslip_loan)) {

							$amount = $payslip_loan->loan_amount;

							$gross_salary -= $amount;
						} else

							$amount = '--';
					}

					array_push($tmp, $amount);
				}


				//late deduction
				$emp_main_id = $value->employee_id;
				$sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

				$late_deduction_data = $this->db->query($sql_late)->row();
				if (!empty($late_deduction_data)) {
					$late_deduction_data_get = $late_deduction_data->total_late_deduction;
				} else {
					$late_deduction_data_get = '0';
				}

				array_push(
					$tmp,

					$value->amt_leave_encashment,

					$value->total_other_payments,

					$value->total_overtime,

					$value->advance_salary_amount,

					$value->amt_indemnity,

					$value->leave_deduction,

					$late_deduction_data_get,

					$value->net_salary

				);

				$data[] = $tmp;
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}


	public function monthly_earning_deduction_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = "Monthly Earning Deduction" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Monthly Earning Deduction";

		$data['all_companies'] = $this->Xin_model->get_companies();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/monthly_earning_deduction", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}

	public function monthly_earning_deduction_get()
	{

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/employees", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$paysheet_employee_id = $_GET['paysheet_employee_id'];
		$month_year = $_GET['month_year'];

		$monthly_earning_deduction_get_data = $this->Reports_model->monthly_earning_deduction_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $month_year);
		$total_amount = array();

		//current date
		$month_year_cur = $month_year;
		$year_month_spilt_cur = explode("-", $month_year_cur);
		$year_cur = $year_month_spilt_cur[0];
		$month_cur = $year_month_spilt_cur[1];

		//month character decrease
		$monthName_cur = date("F", mktime(0, 0, 0, $month_cur, 1));
		$month_name_cur_get = substr($monthName_cur, 0, 3);
		$month_year_cur_get = $month_name_cur_get . ', ' . $year_cur;


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Monthly Earning Deduction Report (" . $month_year_cur_get . ")</strong></span> </div>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='monthly_earning_deduction_report_datatable'>
		        <table class='datatables-demo table table-striped table-bordered' id='monthly_earning_deduction_table_main'>";

		//-------------table 1 earning
		$this->db->where('type_id', 1);
		$this->db->or_where('type_id', 2);
		$this->db->or_where('type_id', 5);
		$allowance = $this->db->get('allowance');
		$allowance_count = count($allowance->result());
		$total_count_a = $allowance_count + 5;
		$table .= "<thead>
                      <tr><th colspan=" . $total_count_a . " style='text-align:center;'>Employees Wise Earning Details</th></tr>
                      
                      <tr>
                      <th style='padding-right: 87px;'>ID</th>
                      <th>Name</th>
                      <th>Basic</th>";

		$allowances = $this->db->get('allowance');
		foreach ($allowances->result() as $allowance) {
			if ($allowance->type_id == 1 || $allowance->type_id == 2 || $allowance->type_id == 5) {
				$total_amount[$allowance->id] = 0;
				$earning_header = ucfirst(strtolower($allowance->name));
				$table .= "<th>" . $earning_header . "</th>";
			}
		}

		$table .= "   <th>Overtime</th>
                      <th>Gross Salary</th>
                      </tr>";

		$table .= "</thead><tbody>";

		$basic_salary_total = '0';
		$ot_amount_total = '0';
		$net_pay_total = '0';
		$amount_total = '0';

		foreach ($monthly_earning_deduction_get_data->result() as $value_e) {

			$emp_main_id = $value_e->employee_id;
			$e_gross_salary = $value_e->basic_salary;
			$net_salary_final_data_e = $value_e->net_salary;

			$basic_salary_total += $e_gross_salary;
			$net_pay_total += $net_salary_final_data_e;

			$employee_main_id = $this->Reports_model->read_employee_info($emp_main_id);
			if (!is_null($employee_main_id)) {
				$emp_id = $employee_main_id[0]->employee_id;
				$emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}

			//overtime get
			$overtime_data = $value_e->total_overtime;
			if (!empty($overtime_data)) {
				$ot_amount = $overtime_data;
			} else {
				$ot_amount = "0";
			}
			$ot_amount_total += $ot_amount;

			$table .= "<tr>
                 <td>" . $emp_id . "</td>
                 <td>" . $emp_name . "</td>
                 <td>" . $e_gross_salary . "</td>";

			//-------------------allowance get

			foreach ($allowances->result() as $allowance) {
				$amount = "0";

				if ($allowance->type_id == 1) {

					$sql = "SELECT allowance_amount FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.user_id = ?";
					$binds = array($allowance->id, $month_year, $emp_main_id);
					$payslip_allowance = $this->db->query($sql, $binds)->row();

					if (!empty($payslip_allowance)) {

						$amount_data = $payslip_allowance->allowance_amount;
						if ($amount_data != '') {
							$amount = $payslip_allowance->allowance_amount;
							$amount_total = $payslip_allowance->allowance_amount;
							$total_amount[$allowance->id] += $amount_total;
						} else {
							$amount = 0;
							$amount_total = 0;
							$total_amount[$allowance->id] += 0;
						}
					}


					$table .= "<td>" . $amount . "</th>";

				} else if ($allowance->type_id == 2) {

					$sql = "SELECT commission_amount  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.user_id = ?";
					$binds = array($allowance->id, $month_year, $emp_main_id);
					$payslip_commission = $this->db->query($sql, $binds)->row();

					if (!empty($payslip_commission)) {

						$amount_data = $payslip_commission->commission_amount;
						if ($amount_data != '') {
							$amount = $payslip_commission->commission_amount;
							$amount_total = $payslip_commission->commission_amount;
							$total_amount[$allowance->id] += $amount_total;
						} else {
							$amount = 0;
							$amount_total = 0;
							$total_amount[$allowance->id] += 0;
						}
					}


					$table .= "<td>" . $amount . "</th>";
				} else if ($allowance->type_id == 5) {

					$sql = "SELECT payments_amount FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.user_id = ? ";
					$binds = array($allowance->id, $month_year, $emp_main_id);
					$payslip_other_payments = $this->db->query($sql, $binds)->row();

					if (!empty($payslip_other_payments)) {

						$amount_data = $payslip_other_payments->payments_amount;
						if ($amount_data != '') {
							$amount = $payslip_other_payments->payments_amount;
							$amount_total = $payslip_other_payments->payments_amount;
							$total_amount[$allowance->id] += $amount_total;
						} else {
							$amount = 0;
							$amount_total = 0;
							$total_amount[$allowance->id] += 0;
						}
					}


					$table .= "<td>" . $amount . "</td>";
				}
			}
			//-----------------------------------allowance get end


			$table .= "<td>" . $ot_amount . "</td>
                              <td>" . $net_salary_final_data_e . "</td>
                               </tr>";
		}

		$table .= "<tr style='background-color: #E0E0EB;'>
                              <th style='border-right-width: 0px;'>Grand Total :</th>
                              <th></th>
                              <th>" . round($basic_salary_total, 3) . "</th>";
		foreach ($total_amount as $key => $val) {
			$table .= "<td>" . round($val, 3) . "</th>";
		}
		$table .= "<th>" . round($ot_amount_total, 3) . "</th>
                               <th>" . round($net_pay_total, 3) . "</th>
                               </tr>";

		$table .= "</tbody>";


//----------------table 2 Deduction

		$this->db->where('type_id', 3);
		$this->db->or_where('type_id', 4);
		$deduction = $this->db->get('allowance');
		$deduction_count = count($deduction->result());
		$total_count_d = $deduction_count + 8;
		$table .= "<thead>
                      <tr><th style='background-color: #fff; border-bottom-width: 0px !important;'></th></tr>
                      <tr><th colspan=" . $total_count_d . " style='text-align:center; border-right-width: 1px;'>Employees Wise Deduction Details</th></tr>
                      <tr>
                      <th style='padding-right: 87px;'>ID</th>
                      <th>Name</th>";

		$allowances = $this->db->get('allowance');
		foreach ($allowances->result() as $allowance) {
			if ($allowance->type_id == 3 || $allowance->type_id == 4) {
				$total_amount_d[$allowance->id] = 0;
				$deduction_header = ucfirst(strtolower($allowance->name));
				$table .= "<th>" . $deduction_header . "</th>";
			}
		}

		$table .= "<th>Late Deduction</th>
                        <th>Loan Deduction</th>
                        <th>Leave Deduction</th>
                        <th>Advance Salary</th>
                        <th>Total Deduction</th>
                        <th style='border-right-width: 1px;'>Net Payable</th>
                        </tr>";

		$table .= "</thead><tbody>";

		$amount_total_d = '0';
		$late_deduction_total = 0;
		$loan_data_total = 0;
		$leave_total = 0;
		$adv_total = 0;
		$total_deduction_value_total = 0;
		$net_pay_total = 0;

		foreach ($monthly_earning_deduction_get_data->result() as $value_d) {
			$emp_main_id = $value_d->employee_id;
			$d_gross_salary = $value_d->basic_salary;
			$net_salary_final_data = $value_d->net_salary;

			$net_pay_total += $net_salary_final_data;

			$employee_main_id = $this->Reports_model->read_employee_info($emp_main_id);
			if (!is_null($employee_main_id)) {
				$emp_id = $employee_main_id[0]->employee_id;
				$emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
			} else {
				$emp_id = '--';
				$emp_name = '--';
			}


			$table .= "<tr>
                         <td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>";

			//-----------------------Deduction get
			$deduction_total = "0";
			foreach ($allowances->result() as $allowance) {
				$amount = "0";

				if ($allowance->type_id == 3) {

					$sql = "SELECT deduction_amount FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.user_id = ?";
					$binds = array($allowance->id, $month_year, $emp_main_id);
					$statutory_deduction = $this->db->query($sql, $binds)->row();

					if (!empty($statutory_deduction)) {

						$amount_data = $statutory_deduction->deduction_amount;
						if ($amount_data != '') {
							$amount = $statutory_deduction->deduction_amount;
							$amount_total_d = $statutory_deduction->deduction_amount;
							$total_amount_d[$allowance->id] += $amount_total_d;
							$deduction_total += $statutory_deduction->deduction_amount;
						} else {
							$amount = 0;
							$amount_total_d = 0;
							$total_amount_d[$allowance->id] += 0;
							$deduction_total += 0;
						}
					}

					$table .= "<td>" . $amount . "</th>";


				} else if ($allowance->type_id == 4) {

					$sql = "SELECT loan_amount FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.user_id = ?";
					$binds = array($month_year, $emp_main_id);
					$payslip_loan = $this->db->query($sql, $binds)->row();

					if (!empty($payslip_loan)) {

						$amount_data = $payslip_loan->loan_amount;
						if ($amount_data != '') {
							$amount = $payslip_loan->loan_amount;
							$amount_total_d = $payslip_loan->loan_amount;
							$total_amount_d[$allowance->id] += $amount_total_d;
							$deduction_total += $payslip_loan->loan_amount;
						} else {
							$amount = 0;
							$amount_total_d = 0;
							$total_amount_d[$allowance->id] += 0;
							$deduction_total += 0;
						}
					}

					$table .= "<td>" . $amount . "</th>";

				}
			}

			//-----------------------Deduction get end

			//Late Deduction
			$sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id ";
			$late_deduction_data = $this->db->query($sql_late)->row();
			if (!empty($late_deduction_data)) {
				$late_deduction_data_get = $late_deduction_data->total_late_deduction;
			} else {
				$late_deduction_data_get = 0;
			}

			$late_deduction_total += $late_deduction_data_get;

			//loan Deduction
			$sql_loan = "SELECT total_loan FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";
			$loan_data = $this->db->query($sql_loan)->row();
			if (!empty($loan_data)) {
				$loan_data_get = $loan_data->total_loan;
			} else {
				$loan_data_get = 0;
			}

			$loan_data_total += $loan_data_get;

			//Leave Deduction
			$sql_leave = "SELECT leave_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";
			$leave_data = $this->db->query($sql_leave)->row();
			if (!empty($leave_data)) {
				$leave_amount = $leave_data->leave_deduction;
			} else {
				$leave_amount = 0;
			}

			$leave_total += $leave_amount;

			//Advance Salary
			$sql_adv = "SELECT advance_salary_amount FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";
			$adv_data = $this->db->query($sql_adv)->row();
			if (!empty($adv_data)) {
				$adv_amount = $adv_data->advance_salary_amount;
			} else {
				$adv_amount = 0;
			}

			$adv_total += $adv_amount;


			$total_deduction_value_get = $deduction_total + $late_deduction_data_get + $loan_data_get + $leave_amount + $adv_amount;

			$total_deduction_value_total += $total_deduction_value_get;

			$table .= "<td>" . $late_deduction_data_get . "</td>
                         <td>" . $loan_data_get . "</td>
                         <td>" . $leave_amount . "</td>
                         <td>" . $adv_amount . "</td>
                         <td>" . $total_deduction_value_get . "</td>
                         <td style='border-right-width: 1px;'>" . $net_salary_final_data . "</td>
                       </tr>";
		}

		$table .= "<tr style='background-color: #E0E0EB;'>
                              <th style='border-right-width: 0px;'>Grand Total :</th>
                              <th></th>";
		foreach ($total_amount_d as $key => $val) {
			$table .= "<th>" . round($val, 3) . "</th>";
		}
		$table .= "<th>" . round($late_deduction_total, 3) . "</th>
                               <th>" . round($loan_data_total, 3) . "</th>
                               <th>" . round($leave_total, 3) . "</th>
                               <th>" . round($adv_total, 3) . "</th>
                               <th>" . round($total_deduction_value_total, 3) . "</th>
                               <th style='border-right-width: 1px;'>" . round($net_pay_total, 3) . "</th>
                            </tr>";

		$table .= "</tbody>";

		$table .= "</table>
                 </div>
                 </div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}


	public function monthly_earning_deduction_report_pdf()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$aj_company = $this->input->post('e_company_id');
		$aj_department = $this->input->post('e_department_id');
		$location_id = $this->input->post('e_location_id');
		$paysheet_employee_id = $this->input->post('e_employee_id');
		$month_year = $this->input->post('e_month_year');


		if (!empty($aj_company)) {
			//$company_id_array = explode(',',$aj_company);
			$title_company_id = $aj_company;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['aj_company'] = $aj_company;
		$res['location_id'] = $location_id;
		$res['aj_department'] = $aj_department;
		$res['paysheet_employee_id'] = $paysheet_employee_id;
		$res['month_year'] = $month_year;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/monthly_earning_eduction_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Monthly_Earning_Deduction.pdf', 'D');
	}


//yearly salary report code start

	public function year_salary_report_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = "Yearly Salary Report" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Yearly Salary Report";

		$data['all_companies'] = $this->Xin_model->get_companies();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_employees'] = $this->Xin_model->all_employees();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/year_salary_report", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}


	public function year_salary_report_get()
	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/employees", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$location_id = $_GET['location_id'];
		$aj_department = $_GET['aj_department'];
		$employee_id = $_GET['employee_id'];
		$year = $_GET['month_year'];

		$employee_id_data = $employee_id;


		$table = "";
		$table .= "<div class='card-header with-elements'> <span class='card-header-title mr-2'><strong>Yearly Salary Report (" . $year . ")</strong></span> </div>
                            <div class='card-body'>
                            <div class='box-datatable table-responsive' id='yearly_salary_report_datatable'>
                          <table class='datatables-demo table table-striped table-bordered' id='year_salary_report_table_main'>
                                  <thead>
                                  <tr>
                                     <th>Payment Head</th>
                                     <th>Jan</th>
                                     <th>Feb</th>
                                     <th>Mar</th>
                                     <th>Apr</th>
                                     <th>May</th>
                                     <th>Jun</th>
                                     <th>Jul</th>
                                     <th>Aug</th>
                                     <th>Sep</th>
                                     <th>Oct</th>
                                     <th>Nov</th>
                                     <th>Dec</th>
                                     <th>Total</th>
                                  </tr>";
		$table .= "    </thead>
                                  <tbody>";

		$department_id_main = $this->Reports_model->year_salary_report_get_data($aj_company, $aj_department, $employee_id, $year, $location_id);

		foreach ($department_id_main->result() as $value_d) {

			$depart_id_data = $value_d->department_id;
			$user_id_data = $value_d->employee_id;

			//get department
			$department_name = $this->Xin_model->read_department_info($depart_id_data);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
			} else {
				$dept_name = '--';
			}


			if ($employee_id_data == "") {

				$sql_data = "SELECT * FROM xin_salary_payslips WHERE salary_month BETWEEN '$year-01' and '$year-12' AND department_id = $depart_id_data GROUP BY employee_id";
				$emp_main_id = $this->db->query($sql_data);


			} else {

				$sql_data = "SELECT * FROM xin_salary_payslips WHERE salary_month BETWEEN '$year-01' and '$year-12' AND employee_id IN($employee_id) GROUP BY employee_id";
				$emp_main_id = $this->db->query($sql_data);

			}


			$table .= "<tr style='background-color: #E0E0EB;'>
                      <td style='border-right-width: 0px;'><b>Department :</b></td>
                      <td style='border-right-width: 0px;'>" . $dept_name . "</td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                      <td style='border-right-width: 0px;'></td>
                  </tr>";

			foreach ($emp_main_id->result() as $emp_main_id_get) {
				$employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->employee_id);

				if (!is_null($employee_info)) {
					$full_name_info = $employee_info[0]->first_name . " " . $employee_info[0]->last_name;
					$emp_code = $employee_info[0]->employee_id;
					$emp_join_date = $employee_info[0]->date_of_joining;
					$emp_depart_id = $employee_info[0]->department_id;
				} else {
					$full_name_info = '--';
					$emp_code = '--';
					$emp_join_date = '--';
					$emp_depart_id = '0';
				}

				// if (! empty($employee_info))
				// {
				//   $full_name_info = $employee_info->first_name." ".$employee_info->last_name;
				//   $emp_code = $employee_info->employee_id;
				//   $emp_join_date = $employee_info->date_of_joining;
				//   $emp_depart_id = $employee_info->department_id;
				// }
				// else
				// {
				//     $full_name_info = '--';
				//     $emp_code = '--';
				//     $emp_join_date = '--';
				//     $emp_depart_id = '0';
				// }

				$table .= "<tr style='background-color: #E0E0EB;'>
                         <td style='border-right-width: 0px;'><b>Employee :</b></td>
                         <td style='border-right-width: 0px;'>[" . $emp_code . "] " . $full_name_info . "</td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                         <td style='border-right-width: 0px;'></td>
                      </tr>";


				$emp_main_id_data = $emp_main_id_get->employee_id;


				$sql_data = "SELECT employee_id, salary_month FROM xin_salary_payslips WHERE salary_month BETWEEN '$year-01' AND '$year-12' AND employee_id = $emp_main_id_data GROUP BY employee_id";
				$year_salary_report_get_data = $this->db->query($sql_data);


				//$year_salary_report_get_data = $this->Reports_model->year_salary_report_get_data($aj_company, $aj_department, $employee_id, $year);


				foreach ($year_salary_report_get_data->result_array() as $emp_row) {
					$employee_id = $emp_row['employee_id'];


					$sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_salary_payslips.employee_id, xin_salary_payslips.salary_month from xin_employees JOIN xin_salary_payslips on xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.employee_id IN($employee_id) and xin_salary_payslips.salary_month BETWEEN '$year-01' and '$year-12' Group by xin_salary_payslips.employee_id";
					$result = $this->db->query($sql);

					//basic salary code
					foreach ($result->result_array() as $row) {

						$emp_id = $row['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}


						$table .= "<tr><td>Basic Salary</td>";

						$jan_sql = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql)) {
							$jan_sql_data = $jan_sql[0]->basic_salary;
						} else {
							$jan_sql_data = '0';
						}

						$feb_sql = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql)) {
							$feb_sql_data = $feb_sql[0]->basic_salary;
						} else {
							$feb_sql_data = '0';
						}

						$mar_sql = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql)) {
							$mar_sql_data = $mar_sql[0]->basic_salary;
						} else {
							$mar_sql_data = '0';
						}

						$apr_sql = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql)) {
							$apr_sql_data = $apr_sql[0]->basic_salary;
						} else {
							$apr_sql_data = '0';
						}

						$may_sql = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql)) {
							$may_sql_data = $may_sql[0]->basic_salary;
						} else {
							$may_sql_data = '0';
						}

						$jun_sql = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql)) {
							$jun_sql_data = $jun_sql[0]->basic_salary;
						} else {
							$jun_sql_data = '0';
						}

						$jul_sql = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql)) {
							$jul_sql_data = $jul_sql[0]->basic_salary;
						} else {
							$jul_sql_data = '0';
						}

						$aug_sql = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql)) {
							$aug_sql_data = $aug_sql[0]->basic_salary;
						} else {
							$aug_sql_data = '0';
						}

						$sep_sql = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql)) {
							$sep_sql_data = $sep_sql[0]->basic_salary;
						} else {
							$sep_sql_data = '0';
						}

						$oct_sql = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql)) {
							$oct_sql_data = $oct_sql[0]->basic_salary;
						} else {
							$oct_sql_data = '0';
						}

						$nov_sql = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql)) {
							$nov_sql_data = $nov_sql[0]->basic_salary;
						} else {
							$nov_sql_data = '0';
						}

						$dec_sql = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql)) {
							$dec_sql_data = $dec_sql[0]->basic_salary;
						} else {
							$dec_sql_data = '0';
						}

						$table .= "<td>" . $jan_sql_data . "</td>";
						$table .= "<td>" . $feb_sql_data . "</td>";
						$table .= "<td>" . $mar_sql_data . "</td>";
						$table .= "<td>" . $apr_sql_data . "</td>";
						$table .= "<td>" . $may_sql_data . "</td>";
						$table .= "<td>" . $jun_sql_data . "</td>";
						$table .= "<td>" . $jul_sql_data . "</td>";
						$table .= "<td>" . $aug_sql_data . "</td>";
						$table .= "<td>" . $sep_sql_data . "</td>";
						$table .= "<td>" . $oct_sql_data . "</td>";
						$table .= "<td>" . $nov_sql_data . "</td>";
						$table .= "<td>" . $dec_sql_data . "</td>";

						$total_value = (float)$jan_sql_data + (float)$feb_sql_data + (float)$mar_sql_data + (float)$apr_sql_data + (float)$may_sql_data + (float)$jun_sql_data + (float)$jul_sql_data + (float)$aug_sql_data + (float)$sep_sql_data + (float)$oct_sql_data + (float)$nov_sql_data + (float)$dec_sql_data;

						//total value
						$table .= "<td>" . $total_value . "</td>";

						$table .= " </tr>";
					}


					//total allowances
					foreach ($result->result_array() as $row_ta) {

						$emp_id = $row_ta['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Allowances</td>";

						$jan_sql_ta = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_ta)) {
							$jan_sql_data_ta = $jan_sql_ta[0]->total_allowances;
						} else {
							$jan_sql_data_ta = '0';
						}

						$feb_sql_ta = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_ta)) {
							$feb_sql_data_ta = $feb_sql_ta[0]->total_allowances;
						} else {
							$feb_sql_data_ta = '0';
						}

						$mar_sql_ta = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_ta)) {
							$mar_sql_data_ta = $mar_sql_ta[0]->total_allowances;
						} else {
							$mar_sql_data_ta = '0';
						}

						$apr_sql_ta = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_ta)) {
							$apr_sql_data_ta = $apr_sql_ta[0]->total_allowances;
						} else {
							$apr_sql_data_ta = '0';
						}

						$may_sql_ta = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_ta)) {
							$may_sql_data_ta = $may_sql_ta[0]->total_allowances;
						} else {
							$may_sql_data_ta = '0';
						}

						$jun_sql_ta = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_ta)) {
							$jun_sql_data_ta = $jun_sql_ta[0]->total_allowances;
						} else {
							$jun_sql_data_ta = '0';
						}

						$jul_sql_ta = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_ta)) {
							$jul_sql_data_ta = $jul_sql_ta[0]->total_allowances;
						} else {
							$jul_sql_data_ta = '0';
						}

						$aug_sql_ta = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_ta)) {
							$aug_sql_data_ta = $aug_sql_ta[0]->total_allowances;
						} else {
							$aug_sql_data_ta = '0';
						}

						$sep_sql_ta = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_ta)) {
							$sep_sql_data_ta = $sep_sql_ta[0]->total_allowances;
						} else {
							$sep_sql_data_ta = '0';
						}

						$oct_sql_ta = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_ta)) {
							$oct_sql_data_ta = $oct_sql_ta[0]->total_allowances;
						} else {
							$oct_sql_data_ta = '0';
						}

						$nov_sql_ta = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_ta)) {
							$nov_sql_data_ta = $nov_sql_ta[0]->total_allowances;
						} else {
							$nov_sql_data_ta = '0';
						}

						$dec_sql_ta = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_ta)) {
							$dec_sql_data_ta = $dec_sql_ta[0]->total_allowances;
						} else {
							$dec_sql_data_ta = '0';
						}

						$table .= "<td>" . $jan_sql_data_ta . "</td>";
						$table .= "<td>" . $feb_sql_data_ta . "</td>";
						$table .= "<td>" . $mar_sql_data_ta . "</td>";
						$table .= "<td>" . $apr_sql_data_ta . "</td>";
						$table .= "<td>" . $may_sql_data_ta . "</td>";
						$table .= "<td>" . $jun_sql_data_ta . "</td>";
						$table .= "<td>" . $jul_sql_data_ta . "</td>";
						$table .= "<td>" . $aug_sql_data_ta . "</td>";
						$table .= "<td>" . $sep_sql_data_ta . "</td>";
						$table .= "<td>" . $oct_sql_data_ta . "</td>";
						$table .= "<td>" . $nov_sql_data_ta . "</td>";
						$table .= "<td>" . $dec_sql_data_ta . "</td>";

						$total_value_ta = (float)$jan_sql_data_ta + (float)$feb_sql_data_ta + (float)$mar_sql_data_ta + (float)$apr_sql_data_ta + (float)$may_sql_data_ta + (float)$jun_sql_data_ta + (float)$jul_sql_data_ta + (float)$aug_sql_data_ta + (float)$sep_sql_data_ta + (float)$oct_sql_data_ta + (float)$nov_sql_data_ta + (float)$dec_sql_data_ta;

						//total value
						$table .= "<td>" . $total_value_ta . "</td>";

						$table .= " </tr>";
					}

					//total commissions
					foreach ($result->result_array() as $row_tc) {

						$emp_id = $row_tc['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id, $year);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Commissions</td>";

						$jan_sql_tc = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_tc)) {
							$jan_sql_data_tc = $jan_sql_tc[0]->total_commissions;
						} else {
							$jan_sql_data_tc = '0';
						}

						$feb_sql_tc = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_tc)) {
							$feb_sql_data_tc = $feb_sql_tc[0]->total_commissions;
						} else {
							$feb_sql_data_tc = '0';
						}

						$mar_sql_tc = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_tc)) {
							$mar_sql_data_tc = $mar_sql_tc[0]->total_commissions;
						} else {
							$mar_sql_data_tc = '0';
						}

						$apr_sql_tc = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_tc)) {
							$apr_sql_data_tc = $apr_sql_tc[0]->total_commissions;
						} else {
							$apr_sql_data_tc = '0';
						}

						$may_sql_tc = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_tc)) {
							$may_sql_data_tc = $may_sql_tc[0]->total_commissions;
						} else {
							$may_sql_data_tc = '0';
						}

						$jun_sql_tc = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_tc)) {
							$jun_sql_data_tc = $jun_sql_tc[0]->total_commissions;
						} else {
							$jun_sql_data_tc = '0';
						}

						$jul_sql_tc = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_tc)) {
							$jul_sql_data_tc = $jul_sql_tc[0]->total_commissions;
						} else {
							$jul_sql_data_tc = '0';
						}

						$aug_sql_tc = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_tc)) {
							$aug_sql_data_tc = $aug_sql_tc[0]->total_commissions;
						} else {
							$aug_sql_data_tc = '0';
						}

						$sep_sql_tc = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_tc)) {
							$sep_sql_data_tc = $sep_sql_tc[0]->total_commissions;
						} else {
							$sep_sql_data_tc = '0';
						}

						$oct_sql_tc = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_tc)) {
							$oct_sql_data_tc = $oct_sql_tc[0]->total_commissions;
						} else {
							$oct_sql_data_tc = '0';
						}

						$nov_sql_tc = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_tc)) {
							$nov_sql_data_tc = $nov_sql_tc[0]->total_commissions;
						} else {
							$nov_sql_data_tc = '0';
						}

						$dec_sql_tc = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_tc)) {
							$dec_sql_data_tc = $dec_sql_tc[0]->total_commissions;
						} else {
							$dec_sql_data_tc = '0';
						}

						$table .= "<td>" . $jan_sql_data_tc . "</td>";
						$table .= "<td>" . $feb_sql_data_tc . "</td>";
						$table .= "<td>" . $mar_sql_data_tc . "</td>";
						$table .= "<td>" . $apr_sql_data_tc . "</td>";
						$table .= "<td>" . $may_sql_data_tc . "</td>";
						$table .= "<td>" . $jun_sql_data_tc . "</td>";
						$table .= "<td>" . $jul_sql_data_tc . "</td>";
						$table .= "<td>" . $aug_sql_data_tc . "</td>";
						$table .= "<td>" . $sep_sql_data_tc . "</td>";
						$table .= "<td>" . $oct_sql_data_tc . "</td>";
						$table .= "<td>" . $nov_sql_data_tc . "</td>";
						$table .= "<td>" . $dec_sql_data_tc . "</td>";

						$total_value_tc = (float)$jan_sql_data_tc + (float)$feb_sql_data_tc + (float)$mar_sql_data_tc + (float)$apr_sql_data_tc + (float)$may_sql_data_tc + (float)$jun_sql_data_tc + (float)$jul_sql_data_tc + (float)$aug_sql_data_tc + (float)$sep_sql_data_tc + (float)$oct_sql_data_tc + (float)$nov_sql_data_tc + (float)$dec_sql_data_tc;

						//total value
						$table .= "<td>" . $total_value_tc . "</td>";

						$table .= " </tr>";
					}


					//total statutory deductions
					foreach ($result->result_array() as $row_tsd) {

						$emp_id = $row_tsd['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Statutory Deductions</td>";

						$jan_sql_tsd = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_tsd)) {
							$jan_sql_data_tsd = $jan_sql_tsd[0]->total_statutory_deductions;
						} else {
							$jan_sql_data_tsd = '0';
						}

						$feb_sql_tsd = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_tsd)) {
							$feb_sql_data_tsd = $feb_sql_tsd[0]->total_statutory_deductions;
						} else {
							$feb_sql_data_tsd = '0';
						}

						$mar_sql_tsd = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_tsd)) {
							$mar_sql_data_tsd = $mar_sql_tsd[0]->total_statutory_deductions;
						} else {
							$mar_sql_data_tsd = '0';
						}

						$apr_sql_tsd = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_tsd)) {
							$apr_sql_data_tsd = $apr_sql_tsd[0]->total_statutory_deductions;
						} else {
							$apr_sql_data_tsd = '0';
						}

						$may_sql_tsd = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_tsd)) {
							$may_sql_data_tsd = $may_sql_tsd[0]->total_statutory_deductions;
						} else {
							$may_sql_data_tsd = '0';
						}

						$jun_sql_tsd = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_tsd)) {
							$jun_sql_data_tsd = $jun_sql_tsd[0]->total_statutory_deductions;
						} else {
							$jun_sql_data_tsd = '0';
						}

						$jul_sql_tsd = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_tsd)) {
							$jul_sql_data_tsd = $jul_sql_tsd[0]->total_statutory_deductions;
						} else {
							$jul_sql_data_tsd = '0';
						}

						$aug_sql_tsd = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_tsd)) {
							$aug_sql_data_tsd = $aug_sql_tsd[0]->total_statutory_deductions;
						} else {
							$aug_sql_data_tsd = '0';
						}

						$sep_sql_tsd = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_tsd)) {
							$sep_sql_data_tsd = $sep_sql_tsd[0]->total_statutory_deductions;
						} else {
							$sep_sql_data_tsd = '0';
						}

						$oct_sql_tsd = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_tsd)) {
							$oct_sql_data_tsd = $oct_sql_tsd[0]->total_statutory_deductions;
						} else {
							$oct_sql_data_tsd = '0';
						}

						$nov_sql_tsd = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_tsd)) {
							$nov_sql_data_tsd = $nov_sql_tsd[0]->total_statutory_deductions;
						} else {
							$nov_sql_data_tsd = '0';
						}

						$dec_sql_tsd = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_tsd)) {
							$dec_sql_data_tsd = $dec_sql_tsd[0]->total_statutory_deductions;
						} else {
							$dec_sql_data_tsd = '0';
						}

						$table .= "<td>" . $jan_sql_data_tsd . "</td>";
						$table .= "<td>" . $feb_sql_data_tsd . "</td>";
						$table .= "<td>" . $mar_sql_data_tsd . "</td>";
						$table .= "<td>" . $apr_sql_data_tsd . "</td>";
						$table .= "<td>" . $may_sql_data_tsd . "</td>";
						$table .= "<td>" . $jun_sql_data_tsd . "</td>";
						$table .= "<td>" . $jul_sql_data_tsd . "</td>";
						$table .= "<td>" . $aug_sql_data_tsd . "</td>";
						$table .= "<td>" . $sep_sql_data_tsd . "</td>";
						$table .= "<td>" . $oct_sql_data_tsd . "</td>";
						$table .= "<td>" . $nov_sql_data_tsd . "</td>";
						$table .= "<td>" . $dec_sql_data_tsd . "</td>";

						$total_value_tsd = (float)$jan_sql_data_tsd + (float)$feb_sql_data_tsd + (float)$mar_sql_data_tsd + (float)$apr_sql_data_tsd + (float)$may_sql_data_tsd + (float)$jun_sql_data_tsd + (float)$jul_sql_data_tsd + (float)$aug_sql_data_tsd + (float)$sep_sql_data_tsd + (float)$oct_sql_data_tsd + (float)$nov_sql_data_tsd + (float)$dec_sql_data_tsd;

						//total value
						$table .= "<td>" . $total_value_tsd . "</td>";

						$table .= " </tr>";
					}


					//total loan
					foreach ($result->result_array() as $row_tl) {

						$emp_id = $row_tl['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Loan Amount</td>";

						$jan_sql_tl = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_tl)) {
							$jan_sql_data_tl = $jan_sql_tl[0]->total_loan;
						} else {
							$jan_sql_data_tl = '0';
						}

						$feb_sql_tl = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_tl)) {
							$feb_sql_data_tl = $feb_sql_tl[0]->total_loan;
						} else {
							$feb_sql_data_tl = '0';
						}

						$mar_sql_tl = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_tl)) {
							$mar_sql_data_tl = $mar_sql_tl[0]->total_loan;
						} else {
							$mar_sql_data_tl = '0';
						}

						$apr_sql_tl = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_tl)) {
							$apr_sql_data_tl = $apr_sql_tl[0]->total_loan;
						} else {
							$apr_sql_data_tl = '0';
						}

						$may_sql_tl = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_tl)) {
							$may_sql_data_tl = $may_sql_tl[0]->total_loan;
						} else {
							$may_sql_data_tl = '0';
						}

						$jun_sql_tl = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_tl)) {
							$jun_sql_data_tl = $jun_sql_tl[0]->total_loan;
						} else {
							$jun_sql_data_tl = '0';
						}

						$jul_sql_tl = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_tl)) {
							$jul_sql_data_tl = $jul_sql_tl[0]->total_loan;
						} else {
							$jul_sql_data_tl = '0';
						}

						$aug_sql_tl = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_tl)) {
							$aug_sql_data_tl = $aug_sql_tl[0]->total_loan;
						} else {
							$aug_sql_data_tl = '0';
						}

						$sep_sql_tl = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_tl)) {
							$sep_sql_data_tl = $sep_sql_tl[0]->total_loan;
						} else {
							$sep_sql_data_tl = '0';
						}

						$oct_sql_tl = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_tl)) {
							$oct_sql_data_tl = $oct_sql_tl[0]->total_loan;
						} else {
							$oct_sql_data_tl = '0';
						}

						$nov_sql_tl = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_tl)) {
							$nov_sql_data_tl = $nov_sql_tl[0]->total_loan;
						} else {
							$nov_sql_data_tl = '0';
						}

						$dec_sql_tl = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_tl)) {
							$dec_sql_data_tl = $dec_sql_tl[0]->total_loan;
						} else {
							$dec_sql_data_tl = '0';
						}

						$table .= "<td>" . $jan_sql_data_tl . "</td>";
						$table .= "<td>" . $feb_sql_data_tl . "</td>";
						$table .= "<td>" . $mar_sql_data_tl . "</td>";
						$table .= "<td>" . $apr_sql_data_tl . "</td>";
						$table .= "<td>" . $may_sql_data_tl . "</td>";
						$table .= "<td>" . $jun_sql_data_tl . "</td>";
						$table .= "<td>" . $jul_sql_data_tl . "</td>";
						$table .= "<td>" . $aug_sql_data_tl . "</td>";
						$table .= "<td>" . $sep_sql_data_tl . "</td>";
						$table .= "<td>" . $oct_sql_data_tl . "</td>";
						$table .= "<td>" . $nov_sql_data_tl . "</td>";
						$table .= "<td>" . $dec_sql_data_tl . "</td>";

						$total_value_tl = (float)$jan_sql_data_tl + (float)$feb_sql_data_tl + (float)$mar_sql_data_tl + (float)$apr_sql_data_tl + (float)$may_sql_data_tl + (float)$jun_sql_data_tl + (float)$jul_sql_data_tl + (float)$aug_sql_data_tl + (float)$sep_sql_data_tl + (float)$oct_sql_data_tl + (float)$nov_sql_data_tl + (float)$dec_sql_data_tl;

						//total value
						$table .= "<td>" . $total_value_tl . "</td>";

						$table .= " </tr>";
					}


					//leave deduction
					foreach ($result->result_array() as $row_ld) {

						$emp_id = $row_ld['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Leave Deduction</td>";

						$jan_sql_ld = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_ld)) {
							$jan_sql_data_ld = $jan_sql_ld[0]->leave_deduction;
						} else {
							$jan_sql_data_ld = '0';
						}

						$feb_sql_ld = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_ld)) {
							$feb_sql_data_ld = $feb_sql_ld[0]->leave_deduction;
						} else {
							$feb_sql_data_ld = '0';
						}

						$mar_sql_ld = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_ld)) {
							$mar_sql_data_ld = $mar_sql_ld[0]->leave_deduction;
						} else {
							$mar_sql_data_ld = '0';
						}

						$apr_sql_ld = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_ld)) {
							$apr_sql_data_ld = $apr_sql_ld[0]->leave_deduction;
						} else {
							$apr_sql_data_ld = '0';
						}

						$may_sql_ld = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_ld)) {
							$may_sql_data_ld = $may_sql_ld[0]->leave_deduction;
						} else {
							$may_sql_data_ld = '0';
						}

						$jun_sql_ld = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_ld)) {
							$jun_sql_data_ld = $jun_sql_ld[0]->leave_deduction;
						} else {
							$jun_sql_data_ld = '0';
						}

						$jul_sql_ld = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_ld)) {
							$jul_sql_data_ld = $jul_sql_ld[0]->leave_deduction;
						} else {
							$jul_sql_data_ld = '0';
						}

						$aug_sql_ld = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_ld)) {
							$aug_sql_data_ld = $aug_sql_ld[0]->leave_deduction;
						} else {
							$aug_sql_data_ld = '0';
						}

						$sep_sql_ld = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_ld)) {
							$sep_sql_data_ld = $sep_sql_ld[0]->leave_deduction;
						} else {
							$sep_sql_data_ld = '0';
						}

						$oct_sql_ld = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_ld)) {
							$oct_sql_data_ld = $oct_sql_ld[0]->leave_deduction;
						} else {
							$oct_sql_data_ld = '0';
						}

						$nov_sql_ld = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_ld)) {
							$nov_sql_data_ld = $nov_sql_ld[0]->leave_deduction;
						} else {
							$nov_sql_data_ld = '0';
						}

						$dec_sql_ld = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_ld)) {
							$dec_sql_data_ld = $dec_sql_ld[0]->leave_deduction;
						} else {
							$dec_sql_data_ld = '0';
						}

						$table .= "<td>" . $jan_sql_data_ld . "</td>";
						$table .= "<td>" . $feb_sql_data_ld . "</td>";
						$table .= "<td>" . $mar_sql_data_ld . "</td>";
						$table .= "<td>" . $apr_sql_data_ld . "</td>";
						$table .= "<td>" . $may_sql_data_ld . "</td>";
						$table .= "<td>" . $jun_sql_data_ld . "</td>";
						$table .= "<td>" . $jul_sql_data_ld . "</td>";
						$table .= "<td>" . $aug_sql_data_ld . "</td>";
						$table .= "<td>" . $sep_sql_data_ld . "</td>";
						$table .= "<td>" . $oct_sql_data_ld . "</td>";
						$table .= "<td>" . $nov_sql_data_ld . "</td>";
						$table .= "<td>" . $dec_sql_data_ld . "</td>";

						$total_value_ld = (float)(float)$jan_sql_data_ld + (float)(float)$feb_sql_data_ld + (float)(float)$mar_sql_data_ld + (float)(float)$apr_sql_data_ld + (float)(float)$may_sql_data_ld + (float)(float)$jun_sql_data_ld + (float)(float)$jul_sql_data_ld + (float)(float)$aug_sql_data_ld + (float)(float)$sep_sql_data_ld + (float)(float)$oct_sql_data_ld + (float)(float)$nov_sql_data_ld + (float)(float)$dec_sql_data_ld;

						//total value
						$table .= "<td>" . $total_value_ld . "</td>";

						$table .= " </tr>";
					}

					//Advance salary
					foreach ($result->result_array() as $row_as) {

						$emp_id = $row_as['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Advance Salary</td>";

						$jan_sql_as = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_as)) {
							$jan_sql_data_as = $jan_sql_as[0]->advance_salary_amount;
						} else {
							$jan_sql_data_as = '0';
						}

						$feb_sql_as = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_as)) {
							$feb_sql_data_as = $feb_sql_as[0]->advance_salary_amount;
						} else {
							$feb_sql_data_as = '0';
						}

						$mar_sql_as = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_as)) {
							$mar_sql_data_as = $mar_sql_as[0]->advance_salary_amount;
						} else {
							$mar_sql_data_as = '0';
						}

						$apr_sql_as = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_as)) {
							$apr_sql_data_as = $apr_sql_as[0]->advance_salary_amount;
						} else {
							$apr_sql_data_as = '0';
						}

						$may_sql_as = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_as)) {
							$may_sql_data_as = $may_sql_as[0]->advance_salary_amount;
						} else {
							$may_sql_data_as = '0';
						}

						$jun_sql_as = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_as)) {
							$jun_sql_data_as = $jun_sql_as[0]->advance_salary_amount;
						} else {
							$jun_sql_data_as = '0';
						}

						$jul_sql_as = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_as)) {
							$jul_sql_data_as = $jul_sql_as[0]->advance_salary_amount;
						} else {
							$jul_sql_data_as = '0';
						}

						$aug_sql_as = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_as)) {
							$aug_sql_data_as = $aug_sql_as[0]->advance_salary_amount;
						} else {
							$aug_sql_data_as = '0';
						}

						$sep_sql_as = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_as)) {
							$sep_sql_data_as = $sep_sql_as[0]->advance_salary_amount;
						} else {
							$sep_sql_data_as = '0';
						}

						$oct_sql_as = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_as)) {
							$oct_sql_data_as = $oct_sql_as[0]->advance_salary_amount;
						} else {
							$oct_sql_data_as = '0';
						}

						$nov_sql_as = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_as)) {
							$nov_sql_data_as = $nov_sql_as[0]->advance_salary_amount;
						} else {
							$nov_sql_data_as = '0';
						}

						$dec_sql_as = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_as)) {
							$dec_sql_data_as = $dec_sql_as[0]->advance_salary_amount;
						} else {
							$dec_sql_data_as = '0';
						}

						$table .= "<td>" . $jan_sql_data_as . "</td>";
						$table .= "<td>" . $feb_sql_data_as . "</td>";
						$table .= "<td>" . $mar_sql_data_as . "</td>";
						$table .= "<td>" . $apr_sql_data_as . "</td>";
						$table .= "<td>" . $may_sql_data_as . "</td>";
						$table .= "<td>" . $jun_sql_data_as . "</td>";
						$table .= "<td>" . $jul_sql_data_as . "</td>";
						$table .= "<td>" . $aug_sql_data_as . "</td>";
						$table .= "<td>" . $sep_sql_data_as . "</td>";
						$table .= "<td>" . $oct_sql_data_as . "</td>";
						$table .= "<td>" . $nov_sql_data_as . "</td>";
						$table .= "<td>" . $dec_sql_data_as . "</td>";


						$total_value_as = (float)$jan_sql_data_as + (float)$feb_sql_data_as + (float)$mar_sql_data_as + (float)$apr_sql_data_as + (float)$may_sql_data_as + (float)$jun_sql_data_as + (float)$jul_sql_data_as + (float)$aug_sql_data_as + (float)$sep_sql_data_as + (float)$oct_sql_data_as + (float)$nov_sql_data_as + (float)$dec_sql_data_as;

						//total value
						$table .= "<td>" . $total_value_as . "</td>";

						$table .= " </tr>";
					}

					//other payments
					foreach ($result->result_array() as $row_ot) {

						$emp_id = $row_ot['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Other Payments</td>";

						$jan_sql_ot = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_ot)) {
							$jan_sql_data_ot = $jan_sql_ot[0]->total_other_payments;
						} else {
							$jan_sql_data_ot = '0';
						}

						$feb_sql_ot = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_ot)) {
							$feb_sql_data_ot = $feb_sql_ot[0]->total_other_payments;
						} else {
							$feb_sql_data_ot = '0';
						}

						$mar_sql_ot = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_ot)) {
							$mar_sql_data_ot = $mar_sql_ot[0]->total_other_payments;
						} else {
							$mar_sql_data_ot = '0';
						}

						$apr_sql_ot = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_ot)) {
							$apr_sql_data_ot = $apr_sql_ot[0]->total_other_payments;
						} else {
							$apr_sql_data_ot = '0';
						}

						$may_sql_ot = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_ot)) {
							$may_sql_data_ot = $may_sql_ot[0]->total_other_payments;
						} else {
							$may_sql_data_ot = '0';
						}

						$jun_sql_ot = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_ot)) {
							$jun_sql_data_ot = $jun_sql_ot[0]->total_other_payments;
						} else {
							$jun_sql_data_ot = '0';
						}

						$jul_sql_ot = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_ot)) {
							$jul_sql_data_ot = $jul_sql_ot[0]->total_other_payments;
						} else {
							$jul_sql_data_ot = '0';
						}

						$aug_sql_ot = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_ot)) {
							$aug_sql_data_ot = $aug_sql_ot[0]->total_other_payments;
						} else {
							$aug_sql_data_ot = '0';
						}

						$sep_sql_ot = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_ot)) {
							$sep_sql_data_ot = $sep_sql_ot[0]->total_other_payments;
						} else {
							$sep_sql_data_ot = '0';
						}

						$oct_sql_ot = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_ot)) {
							$oct_sql_data_ot = $oct_sql_ot[0]->total_other_payments;
						} else {
							$oct_sql_data_ot = '0';
						}

						$nov_sql_ot = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_ot)) {
							$nov_sql_data_ot = $nov_sql_ot[0]->total_other_payments;
						} else {
							$nov_sql_data_ot = '0';
						}

						$dec_sql_ot = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_ot)) {
							$dec_sql_data_ot = $dec_sql_ot[0]->total_other_payments;
						} else {
							$dec_sql_data_ot = '0';
						}

						$table .= "<td>" . $jan_sql_data_ot . "</td>";
						$table .= "<td>" . $feb_sql_data_ot . "</td>";
						$table .= "<td>" . $mar_sql_data_ot . "</td>";
						$table .= "<td>" . $apr_sql_data_ot . "</td>";
						$table .= "<td>" . $may_sql_data_ot . "</td>";
						$table .= "<td>" . $jun_sql_data_ot . "</td>";
						$table .= "<td>" . $jul_sql_data_ot . "</td>";
						$table .= "<td>" . $aug_sql_data_ot . "</td>";
						$table .= "<td>" . $sep_sql_data_ot . "</td>";
						$table .= "<td>" . $oct_sql_data_ot . "</td>";
						$table .= "<td>" . $nov_sql_data_ot . "</td>";
						$table .= "<td>" . $dec_sql_data_ot . "</td>";


						$total_value_ot = (float)$jan_sql_data_ot + (float)$feb_sql_data_ot + (float)$mar_sql_data_ot + (float)$apr_sql_data_ot + (float)$may_sql_data_ot + (float)$jun_sql_data_ot + (float)$jul_sql_data_ot + (float)$aug_sql_data_ot + (float)$sep_sql_data_ot + (float)$oct_sql_data_ot + (float)$nov_sql_data_ot + (float)$dec_sql_data_ot;

						//total value
						$table .= "<td>" . $total_value_ot . "</td>";

						$table .= " </tr>";
					}

					//late deduction
					foreach ($result->result_array() as $row_ld) {

						$emp_id = $row_ld['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Late Deduction</td>";

						$jan_sql_ld = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_ld)) {
							$jan_sql_data_ld = $jan_sql_ld[0]->total_late_deduction;
						} else {
							$jan_sql_data_ld = '0';
						}

						$feb_sql_ld = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_ld)) {
							$feb_sql_data_ld = $feb_sql_ld[0]->total_late_deduction;
						} else {
							$feb_sql_data_ld = '0';
						}

						$mar_sql_ld = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_ld)) {
							$mar_sql_data_ld = $mar_sql_ld[0]->total_late_deduction;
						} else {
							$mar_sql_data_ld = '0';
						}

						$apr_sql_ld = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_ld)) {
							$apr_sql_data_ld = $apr_sql_ld[0]->total_late_deduction;
						} else {
							$apr_sql_data_ld = '0';
						}

						$may_sql_ld = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_ld)) {
							$may_sql_data_ld = $may_sql_ld[0]->total_late_deduction;
						} else {
							$may_sql_data_ld = '0';
						}

						$jun_sql_ld = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_ld)) {
							$jun_sql_data_ld = $jun_sql_ld[0]->total_late_deduction;
						} else {
							$jun_sql_data_ld = '0';
						}

						$jul_sql_ld = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_ld)) {
							$jul_sql_data_ld = $jul_sql_ld[0]->total_late_deduction;
						} else {
							$jul_sql_data_ld = '0';
						}

						$aug_sql_ld = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_ld)) {
							$aug_sql_data_ld = $aug_sql_ld[0]->total_late_deduction;
						} else {
							$aug_sql_data_ld = '0';
						}

						$sep_sql_ld = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_ld)) {
							$sep_sql_data_ld = $sep_sql_ld[0]->total_late_deduction;
						} else {
							$sep_sql_data_ld = '0';
						}

						$oct_sql_ld = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_ld)) {
							$oct_sql_data_ld = $oct_sql_ld[0]->total_late_deduction;
						} else {
							$oct_sql_data_ld = '0';
						}

						$nov_sql_ld = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_ld)) {
							$nov_sql_data_ld = $nov_sql_ld[0]->total_late_deduction;
						} else {
							$nov_sql_data_ld = '0';
						}

						$dec_sql_ld = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_ld)) {
							$dec_sql_data_ld = $dec_sql_ld[0]->total_late_deduction;
						} else {
							$dec_sql_data_ld = '0';
						}

						$table .= "<td>" . $jan_sql_data_ld . "</td>";
						$table .= "<td>" . $feb_sql_data_ld . "</td>";
						$table .= "<td>" . $mar_sql_data_ld . "</td>";
						$table .= "<td>" . $apr_sql_data_ld . "</td>";
						$table .= "<td>" . $may_sql_data_ld . "</td>";
						$table .= "<td>" . $jun_sql_data_ld . "</td>";
						$table .= "<td>" . $jul_sql_data_ld . "</td>";
						$table .= "<td>" . $aug_sql_data_ld . "</td>";
						$table .= "<td>" . $sep_sql_data_ld . "</td>";
						$table .= "<td>" . $oct_sql_data_ld . "</td>";
						$table .= "<td>" . $nov_sql_data_ld . "</td>";
						$table .= "<td>" . $dec_sql_data_ld . "</td>";


						$total_value_ld = (float)$jan_sql_data_ld + (float)$feb_sql_data_ld + (float)$mar_sql_data_ld + (float)$apr_sql_data_ld + (float)$may_sql_data_ld + (float)$jun_sql_data_ld + (float)$jul_sql_data_ld + (float)$aug_sql_data_ld + (float)$sep_sql_data_ld + (float)$oct_sql_data_ld + (float)$nov_sql_data_ld + (float)$dec_sql_data_ld;

						//total value
						$table .= "<td>" . $total_value_ld . "</td>";

						$table .= " </tr>";
					}

					//overtime
					foreach ($result->result_array() as $row_to) {

						$emp_id = $row_to['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>OverTime</td>";

						$jan_sql_to = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_to)) {
							$jan_sql_data_to = $jan_sql_to[0]->total_overtime;
						} else {
							$jan_sql_data_to = '0';
						}

						$feb_sql_to = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_to)) {
							$feb_sql_data_to = $feb_sql_to[0]->total_overtime;
						} else {
							$feb_sql_data_to = '0';
						}

						$mar_sql_to = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_to)) {
							$mar_sql_data_to = $mar_sql_to[0]->total_overtime;
						} else {
							$mar_sql_data_to = '0';
						}

						$apr_sql_to = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_to)) {
							$apr_sql_data_to = $apr_sql_to[0]->total_overtime;
						} else {
							$apr_sql_data_to = '0';
						}

						$may_sql_to = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_to)) {
							$may_sql_data_to = $may_sql_to[0]->total_overtime;
						} else {
							$may_sql_data_to = '0';
						}

						$jun_sql_to = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_to)) {
							$jun_sql_data_to = $jun_sql_to[0]->total_overtime;
						} else {
							$jun_sql_data_to = '0';
						}

						$jul_sql_to = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_to)) {
							$jul_sql_data_to = $jul_sql_to[0]->total_overtime;
						} else {
							$jul_sql_data_to = '0';
						}

						$aug_sql_to = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_to)) {
							$aug_sql_data_to = $aug_sql_to[0]->total_overtime;
						} else {
							$aug_sql_data_to = '0';
						}

						$sep_sql_to = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_to)) {
							$sep_sql_data_to = $sep_sql_to[0]->total_overtime;
						} else {
							$sep_sql_data_to = '0';
						}

						$oct_sql_to = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_to)) {
							$oct_sql_data_to = $oct_sql_to[0]->total_overtime;
						} else {
							$oct_sql_data_to = '0';
						}

						$nov_sql_to = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_to)) {
							$nov_sql_data_to = $nov_sql_to[0]->total_overtime;
						} else {
							$nov_sql_data_to = '0';
						}

						$dec_sql_to = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_to)) {
							$dec_sql_data_to = $dec_sql_to[0]->total_overtime;
						} else {
							$dec_sql_data_to = '0';
						}

						$table .= "<td>" . $jan_sql_data_to . "</td>";
						$table .= "<td>" . $feb_sql_data_to . "</td>";
						$table .= "<td>" . $mar_sql_data_to . "</td>";
						$table .= "<td>" . $apr_sql_data_to . "</td>";
						$table .= "<td>" . $may_sql_data_to . "</td>";
						$table .= "<td>" . $jun_sql_data_to . "</td>";
						$table .= "<td>" . $jul_sql_data_to . "</td>";
						$table .= "<td>" . $aug_sql_data_to . "</td>";
						$table .= "<td>" . $sep_sql_data_to . "</td>";
						$table .= "<td>" . $oct_sql_data_to . "</td>";
						$table .= "<td>" . $nov_sql_data_to . "</td>";
						$table .= "<td>" . $dec_sql_data_to . "</td>";


						$total_value_to = (float)$jan_sql_data_to + (float)$feb_sql_data_to + (float)$mar_sql_data_to + (float)$apr_sql_data_to + (float)$may_sql_data_to + (float)$jun_sql_data_to + (float)$jul_sql_data_to + (float)$aug_sql_data_to + (float)$sep_sql_data_to + (float)$oct_sql_data_to + (float)$nov_sql_data_to + (float)$dec_sql_data_to;

						//total value
						$table .= "<td>" . $total_value_to . "</td>";

						$table .= " </tr>";
					}


					//net salary
					foreach ($result->result_array() as $row_ns) {

						$emp_id = $row_ns['employee_id'];

						$employee_main_id = $this->Reports_model->read_employee_info($emp_id);
						if (!is_null($employee_main_id)) {
							$emp_main_id = $employee_main_id[0]->employee_id;
						} else {
							$emp_main_id = '--';
						}

						$table .= " <tr><td>Net Salary</td>";

						$jan_sql_ns = $this->Reports_model->jan_sql($emp_id, $year);
						if (!is_null($jan_sql_ns)) {
							$jan_sql_data_ns = $jan_sql_ns[0]->net_salary;
						} else {
							$jan_sql_data_ns = '0';
						}

						$feb_sql_ns = $this->Reports_model->feb_sql($emp_id, $year);
						if (!is_null($feb_sql_ns)) {
							$feb_sql_data_ns = $feb_sql_ns[0]->net_salary;
						} else {
							$feb_sql_data_ns = '0';
						}

						$mar_sql_ns = $this->Reports_model->mar_sql($emp_id, $year);
						if (!is_null($mar_sql_ns)) {
							$mar_sql_data_ns = $mar_sql_ns[0]->net_salary;
						} else {
							$mar_sql_data_ns = '0';
						}

						$apr_sql_ns = $this->Reports_model->apr_sql($emp_id, $year);
						if (!is_null($apr_sql_ns)) {
							$apr_sql_data_ns = $apr_sql_ns[0]->net_salary;
						} else {
							$apr_sql_data_ns = '0';
						}

						$may_sql_ns = $this->Reports_model->may_sql($emp_id, $year);
						if (!is_null($may_sql_ns)) {
							$may_sql_data_ns = $may_sql_ns[0]->net_salary;
						} else {
							$may_sql_data_ns = '0';
						}

						$jun_sql_ns = $this->Reports_model->jun_sql($emp_id, $year);
						if (!is_null($jun_sql_ns)) {
							$jun_sql_data_ns = $jun_sql_ns[0]->net_salary;
						} else {
							$jun_sql_data_ns = '0';
						}

						$jul_sql_ns = $this->Reports_model->jul_sql($emp_id, $year);
						if (!is_null($jul_sql_ns)) {
							$jul_sql_data_ns = $jul_sql_ns[0]->net_salary;
						} else {
							$jul_sql_data_ns = '0';
						}

						$aug_sql_ns = $this->Reports_model->aug_sql($emp_id, $year);
						if (!is_null($aug_sql_ns)) {
							$aug_sql_data_ns = $aug_sql_ns[0]->net_salary;
						} else {
							$aug_sql_data_ns = '0';
						}

						$sep_sql_ns = $this->Reports_model->sep_sql($emp_id, $year);
						if (!is_null($sep_sql_ns)) {
							$sep_sql_data_ns = $sep_sql_ns[0]->net_salary;
						} else {
							$sep_sql_data_ns = '0';
						}

						$oct_sql_ns = $this->Reports_model->oct_sql($emp_id, $year);
						if (!is_null($oct_sql_ns)) {
							$oct_sql_data_ns = $oct_sql_ns[0]->net_salary;
						} else {
							$oct_sql_data_ns = '0';
						}

						$nov_sql_ns = $this->Reports_model->nov_sql($emp_id, $year);
						if (!is_null($nov_sql_ns)) {
							$nov_sql_data_ns = $nov_sql_ns[0]->net_salary;
						} else {
							$nov_sql_data_ns = '0';
						}

						$dec_sql_ns = $this->Reports_model->dec_sql($emp_id, $year);
						if (!is_null($dec_sql_ns)) {
							$dec_sql_data_ns = $dec_sql_ns[0]->net_salary;
						} else {
							$dec_sql_data_ns = '0';
						}

						$table .= "<td>" . $jan_sql_data_ns . "</td>";
						$table .= "<td>" . $feb_sql_data_ns . "</td>";
						$table .= "<td>" . $mar_sql_data_ns . "</td>";
						$table .= "<td>" . $apr_sql_data_ns . "</td>";
						$table .= "<td>" . $may_sql_data_ns . "</td>";
						$table .= "<td>" . $jun_sql_data_ns . "</td>";
						$table .= "<td>" . $jul_sql_data_ns . "</td>";
						$table .= "<td>" . $aug_sql_data_ns . "</td>";
						$table .= "<td>" . $sep_sql_data_ns . "</td>";
						$table .= "<td>" . $oct_sql_data_ns . "</td>";
						$table .= "<td>" . $nov_sql_data_ns . "</td>";
						$table .= "<td>" . $dec_sql_data_ns . "</td>";

						$total_value_ns = (float)$jan_sql_data_ns + (float)$feb_sql_data_ns + (float)$mar_sql_data_ns + (float)$apr_sql_data_ns + (float)$may_sql_data_ns + (float)$jun_sql_data_ns + (float)$jul_sql_data_ns + (float)$aug_sql_data_ns + (float)$sep_sql_data_ns + (float)$oct_sql_data_ns + (float)$nov_sql_data_ns + (float)$dec_sql_data_ns;

						//total value
						$table .= "<td>" . $total_value_ns . "</td>";

						$table .= " </tr>";
					}
				}
			}
		}

		$table .= "</tr></tbody></table></div></div>";

		header("Content-type: application/json");
		// $result[0] = $table;
		// $result[1] = $this->security->get_csrf_hash();
		echo json_encode($table);
		exit();
	}

	public function yearly_salary_report_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$aj_company = $this->input->post('p_company_id');
		$location_id = $this->input->post('p_location');
		$aj_department = $this->input->post('p_department_id');
		$employee_id = $this->input->post('p_employee_id');
		$year = $this->input->post('p_yearpicker');

		if (!empty($aj_company)) {
			//$company_id_array = explode(',',$aj_company);
			$title_company_id = $aj_company;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['aj_company'] = $aj_company;
		$res['location_id'] = $location_id;
		$res['aj_department'] = $aj_department;
		$res['employee_id'] = $employee_id;
		$res['year'] = $year;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/yearly_salary_report_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Yearly_Salary_Report.pdf', 'I');
	}

	//yearly salary report end


	public function overtime_summary_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');
		}

		$data['title'] = "Overtime Summary" . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = "Overtime Summary";

		$data['all_companies'] = $this->Xin_model->get_companies();

		$data['all_departments'] = $this->Department_model->all_departments();

		$data['all_employees'] = $this->Xin_model->all_employees();

		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/overtime_summary", $data, TRUE);

			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');
		}
	}

	public function overtime_summary_get()
	{


		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');

		if (!empty($session)) {

			$this->load->view("admin/reports/payroll", $data);
		} else {

			redirect('admin/');
		}

		// Datatables Variables

		$draw = intval($this->input->get("draw"));

		$start = intval($this->input->get("start"));

		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$paysheet_employee_id = $_GET['paysheet_employee_id'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];

		$overtime_summary = $this->Reports_model->overtime_summary_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date);
		$data = array();
		if (isset($overtime_summary)) {
			foreach ($overtime_summary as $emp) {
				//$total_hours = $emp["normal_ot_hours"]+ $emp["extra_ot_hours"];

				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$weekend = $overtime_consts[0]->weekend;
				$holiday = $overtime_consts[0]->holiday;
				$timeshift_percent = $overtime_consts[0]->timeshift_percent;
				$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;
				$total_overtimeamount = 0;
				$overtimeamount = 0;
				$normal_ot_hours = $emp["normal_ot_hours"];
				$extraot_hours = $emp["extra_ot_hours"];
				$attn_date = $emp["attendance_date"];
				$timestamp = strtotime($attn_date);
				$day = date('l', $timestamp);
				$user = $this->Employees_model->read_user_by_user_id($emp["user_id"]);
				$basic_pay = $user[0]->basic_salary;
				$comp_id = $user[0]->company_id;;
				$holidays = $this->Employees_model->get_holidays($comp_id);
				global $holiday_check;

				if (isset($holidays)) {
					foreach ($holidays as $row) {
						$startDate = $row->start_date;
						$endDate = $row->end_date;

						if (($attn_date >= $startDate) && ($attn_date <= $endDate)) {
							$holiday_check = "yes";
						}
					}
				}

				$total_work = $this->Employees_model->get_employee_workdone($emp["user_id"], $attn_date);
				$total_work_hours = $total_work[0]->totalhours;
				$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($emp["user_id"], $attn_date);
				$late_by_hours = $latecome_deduct[0]->late_by_hours;
				if (!empty($latecome_deduct)) {
					$late_by_hours = $latecome_deduct[0]->late_by_hours;
					if ($late_by_hours > 0) {
						$late_by_hours = $latecome_deduct[0]->late_by_hours + 0.08;
					}
				} else {
					$late_by_hours = 0;
				}
				if ($total_work_hours <= 8 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = 0;

				} elseif ($total_work_hours > 8 && $normal_ot_hours > 0 && $late_by_hours > 0 && $extraot_hours == 0 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = $normal_ot_hours - $late_by_hours;
				}


				if ($normal_ot_hours > 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent + (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours > 0 && $extraot_hours == 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours == 0) {
					$overtimeamount = 0;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $day == "Friday") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $weekend;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $holiday_check == "yes") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $holiday;
					unset($holiday_check);
				}

				$total_hours = $normal_ot_hours + $extraot_hours;
				$clk_in = explode(" ", $emp["clock_in"]);
				$clk_out = explode(" ", $emp["clock_out"]);

				if ($overtimeamount !== 0) {

					$data[] = array(

						$emp["employee_id"],
						$emp["first_name"] . " " . $emp["last_name"],
						$emp["attendance_date"],
						$total_hours,
						$this->Xin_model->company_currency_sign($overtimeamount, $user[0]->company_id)

					);

				}
			}
		}

		if ($overtime_summary != '') {
			$total_count = count($overtime_summary);
		} else {
			$total_count = '0';
		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => $total_count,

			"recordsFiltered" => $total_count,

			"data" => $data

		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}


	public function overtime_summary_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$aj_company = $this->input->post('p_company_id');
		$location_id = $this->input->post('p_location_id');
		$aj_department = $this->input->post('p_department_id');
		$paysheet_employee_id = $this->input->post('p_employee_id');
		$start_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');

		$overtime_summary = $this->Reports_model->overtime_summary_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date);
		$data = array();


		if (!empty($aj_company)) {
			//$company_id_array = explode(',',$aj_company);
			$title_company_id = $aj_company;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------

		if (isset($overtime_summary)) {
			foreach ($overtime_summary as $emp) {
				//$total_hours = $emp["normal_ot_hours"]+ $emp["extra_ot_hours"];

				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$weekend = $overtime_consts[0]->weekend;
				$holiday = $overtime_consts[0]->holiday;
				$timeshift_percent = $overtime_consts[0]->timeshift_percent;
				$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;
				$total_overtimeamount = 0;
				$overtimeamount = 0;
				$normal_ot_hours = $emp["normal_ot_hours"];
				$extraot_hours = $emp["extra_ot_hours"];
				$attn_date = $emp["attendance_date"];
				$timestamp = strtotime($attn_date);
				$day = date('l', $timestamp);
				$user = $this->Employees_model->read_user_by_user_id($emp["user_id"]);
				$basic_pay = $user[0]->basic_salary;
				$comp_id = $user[0]->company_id;;
				$holidays = $this->Employees_model->get_holidays($comp_id);
				global $holiday_check;

				if (isset($holidays)) {
					foreach ($holidays as $row) {
						$startDate = $row->start_date;
						$endDate = $row->end_date;

						if (($attn_date >= $startDate) && ($attn_date <= $endDate)) {
							$holiday_check = "yes";
						}
					}
				}

				$total_work = $this->Employees_model->get_employee_workdone($emp["user_id"], $attn_date);
				$total_work_hours = $total_work[0]->totalhours;
				$latecome_deduct = $this->Employees_model->get_employee_latecome_deduct($emp["user_id"], $attn_date);
				$late_by_hours = $latecome_deduct[0]->late_by_hours;
				if (!empty($latecome_deduct)) {
					$late_by_hours = $latecome_deduct[0]->late_by_hours;
					if ($late_by_hours > 0) {
						$late_by_hours = $latecome_deduct[0]->late_by_hours + 0.08;
					}
				} else {
					$late_by_hours = 0;
				}
				if ($total_work_hours <= 8 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = 0;

				} elseif ($total_work_hours > 8 && $normal_ot_hours > 0 && $late_by_hours > 0 && $extraot_hours == 0 && $day !== "Friday" && $holiday_check !== "yes") {
					$normal_ot_hours = $normal_ot_hours - $late_by_hours;
				}


				if ($normal_ot_hours > 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent + (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours > 0 && $extraot_hours == 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $normal_ot_hours * $evening_timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0) {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshift_percent;
				} elseif ($normal_ot_hours == 0 && $extraot_hours == 0) {
					$overtimeamount = 0;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $day == "Friday") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $weekend;
				} elseif ($normal_ot_hours == 0 && $extraot_hours > 0 && $holiday_check == "yes") {
					$overtimeamount = (($basic_pay / 30) / 8) * $extraot_hours * $holiday;
					unset($holiday_check);
				}

				$total_hours = $normal_ot_hours + $extraot_hours;
				$clk_in = explode(" ", $emp["clock_in"]);
				$clk_out = explode(" ", $emp["clock_out"]);

				if ($overtimeamount !== 0) {

					$data[] = array(

						"employee_id" => $emp["employee_id"],
						"emp_name" => $emp["first_name"] . " " . $emp["last_name"],
						"attendance_date" => $emp["attendance_date"],
						"total_hours" => $total_hours,
						"overtimeamount" => $this->Xin_model->company_currency_sign($overtimeamount, $user[0]->company_id)

					);

				}
			}
		}


		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['main_data'] = $data;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/overtime_summary_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Overtime_Summary_Report.pdf', 'D');
	}


	public function nationality_wise_employee()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Nationality Wise Employee" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Nationality Wise Employee";
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_all_countries'] = $this->Xin_model->get_countries();
		$data['all_location'] = $this->Location_model->all_office_locations();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/nationality_wise_employee", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}
	}

	public function nationality_wise_employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['company_id'];
		$location_id = $_GET['location_id'];
		$nationality_id = $_GET['selected'];
		$status_id = $_GET['status_id'];

		$nationality_id_get = $_GET['selected'];


		$nationality_id = $this->Reports_model->nationality_wise_employee_report($company_id, $location_id, $nationality_id, $status_id);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Nationality Wise Employee</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='nationality_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='nationality_table'>
	                      <thead>
	                        <tr>
                                <th>Emp. Code</th>
                                <th style='padding-right: 110px;'>Employee Name</th>
                                <th>Department</th>
                                <th>Designation</th>
                            </tr>
                           </thead>";

		foreach ($nationality_id->result() as $nationality_id_main) {

			$nationality_id_data = $nationality_id_main->nationality_id;
			$user_id = $nationality_id_main->user_id;

			if ($company_id != '') {
				$company_str = "AND company_id IN($company_id)";
			} else {
				$company_str = "";
			}

			if ($location_id != '') {
				$location_str = "AND location_id IN($location_id)";
			} else {
				$location_str = "";
			}

			if ($nationality_id_get != '') {
				$nationality_str = "AND nationality_id IN($nationality_id_get)";
			} else {
				$nationality_str = "";
			}

			if ($status_id != 'all') {
				$status_str = "AND is_active IN($status_id)";
			} else {
				$status_str = "";
			}

			$sql_data = "SELECT * from xin_employees INNER JOIN xin_countries ON xin_employees.nationality_id = xin_countries.country_id where user_id != '' and xin_employees.nationality_id = $nationality_id_data $company_str $location_str $nationality_str $status_str";
			$nationality = $this->db->query($sql_data);


			$table .= "<tr style='background-color: #E0E0EB;'><th style='border-right-width: 0px;'>Code: " . $nationality_id_main->country_code . "</th>
					  <th style='border-right-width: 0px;'>Name: " . $nationality_id_main->country_name . "</th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th></tr>";


			foreach ($nationality->result() as $get) {

				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;
				// get status
				if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
				endif;
				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}
				// department
				$department = $this->Department_model->read_department_information($get->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}


				$table .= "<tr>";

				$table .= "<td>" . $get->employee_id . "</td>
                    <td>" . $full_name . "</td>
                    <td>" . $department_name . "</td>
                    <td>" . $designation_name . "</td>";

				$table .= "</tr>";


			}

		}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}


	public function nationality_wise_employee_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('e_company_id');
		$location_id = $this->input->post('e_location_id');
		$nationality_id = $this->input->post('e_selected');
		$status_id = $this->input->post('e_status');

		$nationality_id_data = $this->Reports_model->nationality_wise_employee_report_pdf($company_id, $location_id, $nationality_id, $status_id);


		$nationality_count = $this->Reports_model->nationality_wise_employee_report_count($company_id, $location_id, $nationality_id, $status_id);

		//empty data display code start
		if (empty($nationality_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($nationality_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$nationality_count[$key]['header_string'] = $email_phone_address;
			$nationality_count[$key]['company_name'] = $company_name;
			$nationality_count[$key]['logo'] = $logo;
		}


		foreach ($nationality_id_data as $key => $val) {


			$data[$key]['company_id'] = $val['company_id'];
			$data[$key]['country_code'] = $val['country_code'];
			$data[$key]['country_name'] = $val['country_name'];

			foreach ($val['list'] as $k => $v1) {

				// get designation
				$designation = $this->Designation_model->read_designation_information($v1['designation_id']);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				$department = $this->Department_model->read_department_information($v1['department_id']);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}

				$data[$key]['list'][$k]['employee_id'] = $v1['employee_id'];
				$data[$key]['list'][$k]['first_name'] = $v1['first_name'];
				$data[$key]['list'][$k]['last_name'] = $v1['last_name'];
				$data[$key]['list'][$k]['department_name'] = $department_name;
				$data[$key]['list'][$k]['designation_name'] = $designation_name;
				$data[$key]['list'][$k]['country_code'] = $v1['country_code'];
				$data[$key]['list'][$k]['country_name'] = $v1['country_name'];
				$data[$key]['list'][$k]['company_id'] = $v1['company_id'];


			}

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['nationality_count'] = $nationality_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/nationality_wise_employee_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Nationality_Wise_Employee.pdf', 'D'); //

	}


	public function assets_issued_to_employee_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Asset Issued To Employee" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Asset Issued To Employee";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();

		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/assets_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function assets_issued()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$endd_date = $this->uri->segment(4);

		$department_id = $this->uri->segment(5);
		$employee_id = $this->uri->segment(6);
		$start_date = $this->uri->segment(7);
		$company_id = $this->uri->segment(8);

		$status_id = $this->uri->segment(9);
		$employee_asset_report = $this->Reports_model->assets_issued_to_employee_query($company_id, $department_id, $employee_id, $start_date, $endd_date, $status_id);
		$data = array();

		foreach ($employee_asset_report->result() as $get) {


			// get company
			$company = $this->Xin_model->read_company_info($get->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// get emp id
			$emp_id = $this->Reports_model->employee_data_get($get->user_id);
			if (!is_null($emp_id)) {
				$emp_id_get = $emp_id[0]->employee_id;
			} else {
				$emp_id_get = '--';
			}

			// user full name
			$full_name = $get->first_name . ' ' . $get->last_name;

			// get status
			if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
			endif;

			// get designation
			$designation = $this->Designation_model->read_designation_information($get->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}

			// department
			$department = $this->Department_model->read_department_information($get->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}


			$data[] = array(
				$emp_id_get,
				$full_name,
				$department_name,
				$designation_name,
				$get->date_of_joining,
				$get->asset_assigned_date,
				$get->name,
				$get->manufacturer,
				$get->company_asset_code,
				$get->serial_number
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee_asset_report->num_rows(),
			"recordsFiltered" => $employee_asset_report->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function asset_received_from_employee_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Asset Received From Employee" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Asset Received From Employee";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/asset_received_from_employee_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}
	}

	public function asset_received_from_employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['company_id'];
		$department_id = $_GET['department_id'];
		$employee_id = $_GET['employee_id'];
		$employee_status = $_GET['employee_status'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];

		$asset_recevied_report = $this->Reports_model->asset_recevied_report_query($end_date, $aj_company, $department_id, $employee_id, $employee_status, $start_date);
		$data = array();

		foreach ($asset_recevied_report->result() as $get) {


			// get company
			$company = $this->Xin_model->read_company_info($get->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// get emp id
			$emp_id = $this->Reports_model->employee_data_get($get->user_id);
			if (!is_null($emp_id)) {
				$emp_id_get = $emp_id[0]->employee_id;
			} else {
				$emp_id_get = '--';
			}

			// user full name
			$full_name = $get->first_name . ' ' . $get->last_name;

			// get status
			if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
			endif;

			// get designation
			$designation = $this->Designation_model->read_designation_information($get->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}

			// department
			$department = $this->Department_model->read_department_information($get->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}


			$data[] = array(
				$emp_id_get,
				$full_name,
				$department_name,
				$designation_name,
				$get->asset_assigned_date,
				$get->handover_date,
				$get->name,
				$get->company_asset_code,
				$get->serial_number
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $asset_recevied_report->num_rows(),
			"recordsFiltered" => $asset_recevied_report->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function leave_balance_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Leave Balance" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Leave Balance";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();
		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/leave_balance_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}

	}

	public function leave_balance_report_employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$end_date = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);


		$company_id = $_GET['company_id'];
		$location_company = $_GET['location_company'];
		$emp_id = $_GET['emp_id'];
		$department_id = $_GET['department_id'];
		$leave_type = $_GET['leave_type'];
		$year = $_GET['year'];

		$leave_balance_report = $this->Reports_model->leave_balance_report_query($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);

		$leave_balance_annual_report = $this->Reports_model->leave_balance_report_annual_query($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);
		$data = array();


		if ($leave_type != 0) {

			foreach ($leave_balance_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					$emp_id_get,
					$full_name,
					$dept_name,
					$get->type_name,
					$from_date,
					$to_date,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}

		} else if ($leave_type == '0') {


			foreach ($leave_balance_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					$emp_id_get,
					$full_name,
					$dept_name,
					$get->type_name,
					$from_date,
					$to_date,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}

			//annual leave get
			foreach ($leave_balance_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					$emp_id_get,
					$full_name,
					$dept_name,
					$get->type_name,
					$from_date,
					$to_date,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}
		}


		//annual leave get
		if ($leave_type == 3) {

			//annual leave get
			foreach ($leave_balance_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					$emp_id_get,
					$full_name,
					$dept_name,
					$get->type_name,
					$from_date,
					$to_date,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}

		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $leave_balance_report->num_rows(),
			"recordsFiltered" => $leave_balance_report->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();

	}


	//rahul new dev

	public function leave_balance_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$location_company = $this->input->post('p_location');
		$emp_id = $this->input->post('p_employee_id');
		$department_id = $this->input->post('p_department_id');
		$leave_type = $this->input->post('p_leave_type');
		$year = $this->input->post('p_yearpicker');

		$leave_balance_report = $this->Reports_model->leave_balance_report_query($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);
		$leave_balance_annual_report = $this->Reports_model->leave_balance_report_annual_query($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);


		if ($leave_type != 0) {
			$leave_balance_report_count = $this->Reports_model->leave_balance_report_query_count($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);
		} else if ($leave_type == 0) {
			$leave_balance_report_count = $this->Reports_model->leave_balance_report_query_count($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);
		}

		if ($leave_type == 3) {
			$leave_balance_report_count = $this->Reports_model->leave_balance_report_annual_query_count($company_id, $location_company, $emp_id, $leave_type, $department_id, $year);
		}

		//empty data display code start
		if (empty($leave_balance_report_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($leave_balance_report_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$leave_balance_report_count[$key]['header_string'] = $email_phone_address;
			$leave_balance_report_count[$key]['company_name'] = $company_name;
			$leave_balance_report_count[$key]['logo'] = $logo;
		}


		if ($leave_type != 0) {

			foreach ($leave_balance_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $dept_name,
					"leave_type_id_get" => $get->type_name,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}

		} else if ($leave_type == '0') {


			foreach ($leave_balance_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $dept_name,
					"leave_type_id_get" => $get->type_name,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}

			//annual leave get
			foreach ($leave_balance_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $dept_name,
					"leave_type_id_get" => $get->type_name,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}
		}


		//annual leave get
		if ($leave_type == 3) {

			//annual leave get
			foreach ($leave_balance_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				//get department
				$department_name = $this->Xin_model->read_department_info($get->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
					$from_date = $taken_leave_data[0]->from_date;
					$to_date = $taken_leave_data[0]->to_date;
				} else {
					$taken_leave_data_get = '0';
					$from_date = $year . '-01-01';
					$to_date = $year . '-12-31';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $dept_name,
					"leave_type_id_get" => $get->type_name,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['leave_balance_report_count'] = $leave_balance_report_count;
		$res['year'] = $year;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/leave_balance_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Leave_balance.pdf', 'D'); //


	}

	//rahul new dev end

	public function leave_summary_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Leave Summary" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Leave Summary";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();
		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/leave_summary_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}

	}

	public function leave_summary_report_employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['company'];
		$location_company = $_GET['location_company'];
		$emp_id = $_GET['emp_id'];
		$department_id = $_GET['department_id'];
		$leave_type = $_GET['leave_type'];
		$year = $_GET['year'];


		$leave_summary_report = $this->Reports_model->leave_summary_report_query($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);

		$leave_summary_annual_report = $this->Reports_model->leave_summary_annual_report_query($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);
		$data = array();


		if ($leave_type != 0) {

			foreach ($leave_summary_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					$emp_id_get,
					$full_name,
					$get->type_name,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}

		} else if ($leave_type == '0') {


			foreach ($leave_summary_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					$emp_id_get,
					$full_name,
					$get->type_name,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}

			//annual leave get
			foreach ($leave_summary_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					$emp_id_get,
					$full_name,
					$get->type_name,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}
		}


		//annual leave get
		if ($leave_type == 3) {

			//annual leave get
			foreach ($leave_summary_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					$emp_id_get,
					$full_name,
					$get->type_name,
					$carryfowards_leave_get,
					$get->days_per_year,
					$taken_leave_data_get,
					$remaining_leave_count
				);

			}

		}


		$output = array(
			"draw" => $draw,
			"recordsTotal" => $leave_summary_report->num_rows(),
			"recordsFiltered" => $leave_summary_report->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();

	}


	//rahul new dev

	public function leave_summary_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$location_company = $this->input->post('p_location');
		$emp_id = $this->input->post('p_employee_id');
		$department_id = $this->input->post('p_department_id');
		$leave_type = $this->input->post('p_leave_type');
		$year = $this->input->post('p_yearpicker');

		$leave_summary_report = $this->Reports_model->leave_summary_report_query($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);

		$leave_summary_annual_report = $this->Reports_model->leave_summary_annual_report_query($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);

		$leave_summary_report_count = $this->Reports_model->leave_summary_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);
		$leave_summary_report_count = $this->Reports_model->leave_summary_annual_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);

		if ($leave_type != 0) {
			$leave_summary_report_count = $this->Reports_model->leave_summary_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);
		} else if ($leave_type == 0) {
			$leave_summary_report_count = $this->Reports_model->leave_summary_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);
		}

		if ($leave_type == 3) {
			$leave_summary_report_count = $this->Reports_model->leave_summary_annual_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id);
		}

		//empty data display code start
		if (empty($leave_summary_report_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($leave_summary_report_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$leave_summary_report_count[$key]['header_string'] = $email_phone_address;
			$leave_summary_report_count[$key]['company_name'] = $company_name;
			$leave_summary_report_count[$key]['logo'] = $logo;
		}


		if ($leave_type != 0) {

			foreach ($leave_summary_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"leave_type_id_get" => $get->type_name,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}

		} else if ($leave_type == '0') {


			foreach ($leave_summary_report->result() as $get) {

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}


				if ($get->leave_type == 7) {
					$remaining_leave_count = '0';
				} else {
					$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;
				}


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"leave_type_id_get" => $get->type_name,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}

			//annual leave get
			foreach ($leave_summary_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"leave_type_id_get" => $get->type_name,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}
		}


		//annual leave get
		if ($leave_type == 3) {

			//annual leave get
			foreach ($leave_summary_annual_report->result() as $get) {


				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->employee_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;

				} else {
					$emp_id_get = '--';
				}


				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;


				$carryfowards_leave_get = '0';


				$taken_leave_data = $this->Reports_model->taken_leave_count_annual_check($get->employee_id, $get->leave_type, $year);
				if (!is_null($taken_leave_data)) {
					$taken_leave_data_get = $taken_leave_data[0]->days;
				} else {
					$taken_leave_data_get = '0';
				}

				$remaining_leave_count = $get->days_per_year - $taken_leave_data_get;


				$data[] = array(
					"employee_id" => $emp_id_get,
					"full_name" => $full_name,
					"leave_type_id_get" => $get->type_name,
					"carryfowards_leave_get" => $carryfowards_leave_get,
					"allotted_leave" => $get->days_per_year,
					"days" => $taken_leave_data_get,
					"remaining_leave_count" => $remaining_leave_count,
					"company_id" => $get->company_id
				);

			}

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['leave_summary_report_count'] = $leave_summary_report_count;
		$res['year'] = $year;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/leave_summary_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Leave_summary.pdf', 'D'); //


	}

	//rahul new dev end


	//montly salary setup code
	public function monthly_salary_setup_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = "Monthly Salary Setup Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Monthly Salary Setup Report";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/monthly_salary_setup_page", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');

		}

	}

	public function monthly_salary_setup_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		if (!empty($session)) {
			$this->load->view("admin/reports/payroll", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$month_year = $_GET['month_year'];

		$payslip_re = $this->Reports_model->monthly_salary_setup_get_data($aj_company, $aj_department, $location_id, $employee_id, $month_year);


		//print_r($payslip_re);exit;

		$data_filtered = array();

		$data = array();

		if ($employee_id == '') {

			if (count($payslip_re) > 0) {

				foreach ($payslip_re as $value) {

					// department
					$department = $this->Department_model->read_department_information($value->department_id);
					if (!is_null($department)) {
						$department_name = $department[0]->department_name;
					} else {
						$department_name = '--';
					}


					//get head count
					$head_count = $this->Reports_model->get_head_count('', $value->department_id, $month_year);
					if (!is_null($head_count)) {
						$head_count_get = $head_count[0]->headcount;
					} else {
						$head_count_get = '--';
					}

					//get basic salary
					$basic_salary = $this->Reports_model->get_basic_salary('', $value->department_id, $month_year);
					if (!is_null($basic_salary)) {
						$basic_salary_data = $basic_salary[0]->total_salary;
					} else {
						$basic_salary_data = '--';
					}

					$basic_salary_value = number_format((float)$basic_salary_data, 2, '.', '');

					$tmp = array(
						$department_name,
						$head_count_get,
						$basic_salary_value,
					);

					$gross_salary = $basic_salary_data;

					$allowances = $this->db->get('allowance');

					foreach ($allowances->result() as $allowance) {

						if ($allowance->type_id == 1) {

							$sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

							$binds = array($allowance->id, $month_year, $value->department_id);

							$payslip_allowance = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_allowance)) {

								$amount_data = $payslip_allowance->allowance_amount_total;

								$gross_salary += $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_allowance->allowance_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 2) {

							$sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

							$binds = array($allowance->id, $month_year, $value->department_id);

							$payslip_commission = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_commission)) {

								$amount_data = $payslip_commission->commission_amount_total;

								$gross_salary += $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_commission->commission_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 3) {

							$sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

							$binds = array($allowance->id, $month_year, $value->department_id);

							$statutory_deduction = $this->db->query($sql, $binds)->row();

							if (!empty($statutory_deduction)) {

								$amount_data = $statutory_deduction->deduction_amount_total;

								$gross_salary -= $amount_data;

								if ($amount_data != '') {
									$amount = $statutory_deduction->deduction_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 4) {

							$sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

							$binds = array($allowance->id, $month_year, $value->department_id);

							$payslip_other_payments = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_other_payments)) {

								$amount_data = $payslip_other_payments->payments_amount_total;

								$gross_salary += $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_other_payments->payments_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 5) {

							$sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

							$binds = array($month_year, $value->department_id);

							$payslip_loan = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_loan)) {

								$amount_data = $payslip_loan->loan_amount_total;

								$gross_salary -= $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_loan->loan_amount_total;
								} else {
									$amount = '0';
								}

							}

						}

						$amount_value = number_format((float)$amount, 2, '.', '');

						array_push(
							$tmp,
							$amount_value

						);

					}

					//Late Deduction
					$sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

					$late_deduction_data = $this->db->query($sql_late)->row();
					if (!empty($late_deduction_data)) {
						$late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
					} else {
						$late_deduction_data_get = '0';
					}

					//Leave Deduction
					$sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
					$leave_data = $this->db->query($sql_leave)->row();

					if (!empty($leave_data)) {
						$leave_amount = $leave_data->total_leave_deduction_amt;
					} else {
						$leave_amount = "0";
					}

					//overtime get
					$sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
					$overtime_data = $this->db->query($sql_ot)->row();

					if (!empty($overtime_data)) {
						$ot_amount = $overtime_data->total_ot_amt;
					} else {
						$ot_amount = "0";
					}

					//Advance Salary
					$sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
					$adv_data = $this->db->query($sql_adv)->row();

					if (!empty($adv_data)) {
						$adv_amount = $adv_data->total_adv_amt;
					} else {
						$adv_amount = "0";
					}

					//Loan
					$sql_loan = "SELECT SUM(total_loan) as total_loan_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
					$loan_data = $this->db->query($sql_loan)->row();

					if (!empty($loan_data)) {
						$loan_amount = $loan_data->total_loan_amt;
					} else {
						$loan_amount = "0";
					}

					//other payments
					$sql_op = "SELECT SUM(total_other_payments) as total_other_payments FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
					$op_data = $this->db->query($sql_op)->row();

					if (!empty($op_data)) {
						$op_amount = $op_data->total_other_payments;
					} else {
						$op_amount = "0";
					}

					//get Gross salary
					$gross_salary = $this->Reports_model->get_gross_salary('', $value->department_id, $month_year);
					if (!is_null($gross_salary)) {
						$gross_salary_data = $gross_salary[0]->gross_salary;
					} else {
						$gross_salary_data = '--';
					}

					$loan_amount_value = number_format((float)$loan_amount, 2, '.', '');
					$op_amount_value = number_format((float)$op_amount, 2, '.', '');
					$late_deduction_value = number_format((float)$late_deduction_data_get, 2, '.', '');
					$leave_amount_value = number_format((float)$leave_amount, 2, '.', '');
					$ot_amount_value = number_format((float)$ot_amount, 2, '.', '');
					$adv_amount_value = number_format((float)$adv_amount, 2, '.', '');
					$gross_salary_value = number_format((float)$gross_salary_data, 2, '.', '');

					array_push($tmp,
						$loan_amount_value,
						$op_amount_value,
						$late_deduction_value,
						$leave_amount_value,
						$ot_amount_value,
						$adv_amount_value,
						round($gross_salary_data, 3)
					);


					$data[] = $tmp;

				}

			}

		} else {

			if (count($payslip_re) > 0) {

				foreach ($payslip_re as $value) {

					// department
					$department = $this->Department_model->read_department_information($value->department_id);
					if (!is_null($department)) {
						$department_name = $department[0]->department_name;
					} else {
						$department_name = '--';
					}


					//get head count
					$head_count = $this->Reports_model->get_head_count_emp($employee_id, $month_year);
					if (!is_null($head_count)) {
						$head_count_get = $head_count[0]->headcount;
					} else {
						$head_count_get = '--';
					}

					//get basic salary
					$basic_salary = $this->Reports_model->get_basic_salary_emp($employee_id, $month_year);
					if (!is_null($basic_salary)) {
						$basic_salary_data = $basic_salary[0]->total_salary;
					} else {
						$basic_salary_data = '--';
					}

					$basic_salary_value = number_format((float)$basic_salary_data, 2, '.', '');

					$tmp = array(
						$department_name,
						$head_count_get,
						$basic_salary_value,
					);

					$gross_salary = $basic_salary_data;

					$allowances = $this->db->get('allowance');

					foreach ($allowances->result() as $allowance) {

						if ($allowance->type_id == 1) {

							$sql = "SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.user_id IN($employee_id)";

							$binds = array($allowance->id, $month_year);

							$payslip_allowance = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_allowance)) {

								$amount_data = $payslip_allowance->allowance_amount_total;

								$gross_salary += $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_allowance->allowance_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 2) {

							$sql = "SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.user_id IN($employee_id)";

							$binds = array($allowance->id, $month_year);

							$payslip_commission = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_commission)) {

								$amount_data = $payslip_commission->commission_amount_total;

								$gross_salary += $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_commission->commission_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 3) {

							$sql = "SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.user_id IN($employee_id)";

							$binds = array($allowance->id, $month_year);

							$statutory_deduction = $this->db->query($sql, $binds)->row();

							if (!empty($statutory_deduction)) {

								$amount_data = $statutory_deduction->deduction_amount_total;

								$gross_salary -= $amount_data;

								if ($amount_data != '') {
									$amount = $statutory_deduction->deduction_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 4) {

							$sql = "SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.user_id IN($employee_id)";

							$binds = array($allowance->id, $month_year);

							$payslip_other_payments = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_other_payments)) {

								$amount_data = $payslip_other_payments->payments_amount_total;

								$gross_salary += $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_other_payments->payments_amount_total;
								} else {
									$amount = '0';
								}

							}

						} else if ($allowance->type_id == 5) {

							$sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.user_id IN($employee_id)";

							$binds = array($month_year);

							$payslip_loan = $this->db->query($sql, $binds)->row();

							if (!empty($payslip_loan)) {

								$amount_data = $payslip_loan->loan_amount_total;

								$gross_salary -= $amount_data;

								if ($amount_data != '') {
									$amount = $payslip_loan->loan_amount_total;
								} else {
									$amount = '0';
								}

							}

						}

						$amount_value = number_format((float)$amount, 2, '.', '');

						array_push(
							$tmp,
							$amount_value

						);

					}

					//Late Deduction
					$sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";

					$late_deduction_data = $this->db->query($sql_late)->row();
					if (!empty($late_deduction_data)) {
						$late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
					} else {
						$late_deduction_data_get = '0';
					}

					//Leave Deduction
					$sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
					$leave_data = $this->db->query($sql_leave)->row();

					if (!empty($leave_data)) {
						$leave_amount = $leave_data->total_leave_deduction_amt;
					} else {
						$leave_amount = "0";
					}

					//overtime get
					$sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
					$overtime_data = $this->db->query($sql_ot)->row();

					if (!empty($overtime_data)) {
						$ot_amount = $overtime_data->total_ot_amt;
					} else {
						$ot_amount = "0";
					}

					//Advance Salary
					$sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
					$adv_data = $this->db->query($sql_adv)->row();

					if (!empty($adv_data)) {
						$adv_amount = $adv_data->total_adv_amt;
					} else {
						$adv_amount = "0";
					}

					//Loan
					$sql_loan = "SELECT SUM(total_loan) as total_loan_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
					$loan_data = $this->db->query($sql_loan)->row();

					if (!empty($loan_data)) {
						$loan_amount = $loan_data->total_loan_amt;
					} else {
						$loan_amount = "0";
					}

					//other payments
					$sql_op = "SELECT SUM(total_other_payments) as total_other_payments FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
					$op_data = $this->db->query($sql_op)->row();

					if (!empty($op_data)) {
						$op_amount = $op_data->total_other_payments;
					} else {
						$op_amount = "0";
					}

					//get Gross salary
					$gross_salary = $this->Reports_model->get_gross_salary_emp($employee_id, $month_year);
					if (!is_null($gross_salary)) {
						$gross_salary_data = $gross_salary[0]->gross_salary;
					} else {
						$gross_salary_data = '--';
					}

					$loan_amount_value = number_format((float)$loan_amount, 2, '.', '');
					$op_amount_value = number_format((float)$op_amount, 2, '.', '');
					$late_deduction_value = number_format((float)$late_deduction_data_get, 2, '.', '');
					$leave_amount_value = number_format((float)$leave_amount, 2, '.', '');
					$ot_amount_value = number_format((float)$ot_amount, 2, '.', '');
					$adv_amount_value = number_format((float)$adv_amount, 2, '.', '');
					$gross_salary_value = number_format((float)$gross_salary_data, 2, '.', '');

					array_push($tmp,
						$loan_amount_value,
						$op_amount_value,
						$late_deduction_value,
						$leave_amount_value,
						$ot_amount_value,
						$adv_amount_value,
						round($gross_salary_data, 3)
					);


					$data[] = $tmp;

				}

			}

		}


		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);

		exit();

	}
	//montly salary setup code end


	//rahul new dev
	public function monthly_salary_setup_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$aj_company = $this->input->post('p_company_id');
		$aj_department = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$month_year = $this->input->post('p_month_year');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($aj_company);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$payslip_re = $this->Reports_model->monthly_salary_setup_get_data($aj_company, $aj_department, $location_id, $employee_id, $month_year);

		$payslip_re_count = $this->Reports_model->monthly_salary_setup_get_data_count($aj_company, $aj_department, $location_id, $employee_id, $month_year);

		//empty data display code start
		if (empty($payslip_re_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($payslip_re_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$payslip_re_count[$key]['header_string'] = $email_phone_address;
			$payslip_re_count[$key]['company_name'] = $company_name;
			$payslip_re_count[$key]['logo'] = $logo;
		}


		foreach ($payslip_re as $value) {

			$data[] = array(
				"user_id" => $value->user_id,
				"first_name" => $value->first_name,
				"last_name" => $value->last_name,
				"department_id" => $value->department_id,
				"company_id" => $value->company_id
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['main_data'] = $data;
		$res['employee_id'] = $employee_id;
		$res['payslip_re_count'] = $payslip_re_count;
		$res['month_year'] = $month_year;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/monthly_salary_setup_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Monthly_Salary_Setup.pdf', 'D'); //


	}

	//rahul new dev end


	//salary setup history start
	public function salary_setup_history_page()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = "Salary Setup History Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Salary Setup History Report";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/salary_setup_history_page", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');

		}

	}

	public function salary_setup_history_get()
	{


		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$paysheet_employee_id = $_GET['paysheet_employee_id'];
		$start_date = $_GET['from_year'];
		$end_date = $_GET['to_year'];


		$emp_main_id = $this->Reports_model->salary_setup_history_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Salary Setup History Report</strong></span>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='salary_setup_history_report_datatable'>
                <table class='datatables-demo table table-striped table-bordered' id='salary_setup_history_table'>";


		$table .= "<thead><tr>

                <th style='padding-right: 168px;'>Progression Date</th>
                <th style='padding-right: 125px;'>Position</th>
                <th>Current Basic Salary</th>
                <th>Basic Salary (Progress)</th>";
		// $sql = "SELECT * FROM `allowance` WHERE type_id IN (1,2)";
		$sql = "SELECT * FROM `allowance` WHERE type_id IN (1)";
		$allowances = $this->db->query($sql);

		foreach ($allowances->result() as $allowance) {
			$table .= "<th>" . $allowance->name . " (Progress)</th>";
		}

		$table .= "<th>Total Amount</th></tr></thead>";

		foreach ($emp_main_id->result() as $emp_main_id_get) {

			$employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->employee_id)[0];

			if (!empty($employee_info)) {
				$full_name_info = $employee_info->first_name . " " . $employee_info->last_name;
				$emp_code = $employee_info->employee_id;
			} else {
				$full_name_info = '--';
				$emp_code = '--';
			}

			$this->db->where('type_id', 1);
			// $this->db->or_where('type_id',2);
			$allowance_count = $this->db->get('allowance');

			$table .= "<tr style='background-color: rgb(245, 203, 167);'><th>Employee Name: " . $full_name_info . "</th>
                         <th>Employee Code: " . $emp_code . "</th>
                         <th></th>
                         <th></th>";

			foreach ($allowance_count->result() as $allowance_count_data) {
				$table .= "<th></th>";
			}

			$table .= "<th></th></tr>";


			$emp_main_id_data = $emp_main_id_get->employee_id;

			$sql_data = "SELECT * FROM `xin_employee_salary_history` WHERE
                date >= '$start_date-01-01' AND date <= '$end_date-12-31' AND inc_amt > 0 AND inc_or_dec = 'inc' and employee_id = $emp_main_id_data";

			$progresses = $this->db->query($sql_data);

			foreach ($progresses->result() as $progress) {

				$table .= "<tr>";

				$table .= "<td>" . $progress->date . "</td>";

				$employee = $this->Xin_model->read_employee_info($progress->employee_id)[0];

				if (!empty($employee)) {
					$depart_id = $employee->department_id;
					$emp_basic_salary = $employee->basic_salary;
				} else {
					$depart_id = '0';
					$emp_basic_salary = '0';
				}

				//get department
				$department_name = $this->Xin_model->read_department_info($depart_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				$table .= "<td>" . $dept_name . "</td>";

				$basic_salary = '';


				$basic_salary = number_format((float)$emp_basic_salary, 2, '.', '');


				$table .= "<td>" . $basic_salary . "</td>";

				$basic_salary_progress = '';

				if ($progress->history_type == 1) {
					if ($progress->inc_or_dec == 'inc') {
						$basic_salary_progress = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
						$p_amt_basic = $progress->inc_amt;
					}
					//   else if ($progress->inc_or_dec == 'dec')
					//   {
					//       $basic_salary_progress = '<span class="text-nowrap">'.$progress->amount.' ('.$progress->inc_amt . ' &#8595;)</span>';
					//       $p_amt_basic = '0';
					//   }
				}

				if ($basic_salary_progress != '') {
					$basic_salary_progress_data = $basic_salary_progress;
				} else {
					$basic_salary_progress_data = 0;
				}

				$table .= "<td>" . $basic_salary_progress_data . "</td>";

				foreach ($allowances->result() as $allowance) {
					if ($progress->history_type == 2) {
						$this->db->where('allowance_id', $progress->allowance_id);
						$salary_allowance = $this->db->get('xin_salary_allowances')->row();

						if ($salary_allowance) {
							if ($allowance->id == $salary_allowance->allowance_title) {
								if ($progress->inc_or_dec == 'inc') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
									$p_amt_allowance = $progress->amount;
								} else if ($progress->inc_or_dec == 'dec') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
									$p_amt_allowance = '0';
								}

							} else {
								$allowance_amount = '0';
							}
						}
					} else {
						$allowance_amount = '0';
					}

					$table .= "<td>" . $allowance_amount . "</td>";

				}

				if ($progress->history_type == 1) {
					// $final_total = $basic_salary + $p_amt_basic;
					$final_total = $basic_salary;
				}

				if ($progress->history_type == 2) {
					$final_total = $basic_salary + $p_amt_allowance;
				}

				$table .= "<td>" . $final_total . "</td>";

				$table .= "</tr>";
			}
		}


		$table .= "</tbody>
                 </table>
                 </div>
                 </div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();

	}
	//salary setup history end


	//rahul new dev

	public function salary_setup_history_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$aj_company = $this->input->post('p_company_id');
		$aj_department = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$paysheet_employee_id = $this->input->post('p_employee_id');
		$start_date = $this->input->post('p_from_year');
		$end_date = $this->input->post('p_to_year');

		$emp_main_id = $this->Reports_model->salary_setup_history_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date);

		$emp_main_id_count = $this->Reports_model->salary_setup_history_get_data_count($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date);

		//empty data display code start
		if (empty($emp_main_id_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($emp_main_id_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$emp_main_id_count[$key]['header_string'] = $email_phone_address;
			$emp_main_id_count[$key]['company_name'] = $company_name;
			$emp_main_id_count[$key]['logo'] = $logo;
		}


		foreach ($emp_main_id->result() as $value) {
			$data[] = array(
				"employee_id" => $value->employee_id,
				"company_id" => $value->company_id
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['emp_main_id'] = $data;
		$res['emp_main_id_count'] = $emp_main_id_count;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/salary_setup_history_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Salary_Setup_History.pdf', 'D'); //


	}

	//rahul new dev end

	public function salary_setup_history_get_anitta()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/payroll", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_year_data = $_GET['from_year'];
		$to_year_data = $_GET['to_year'];

		//from_month
		$from_year_spilt = explode("-", $from_year_data);
		$from_year = $from_year_spilt[0];
		//$month = $from_year_spilt[1];

		//to_month
		$to_year_spilt = explode("-", $to_year_data);
		$to_year = $to_year_spilt[0];
		//$month = $to_year_spilt[1];
		$salary_history = $this->Reports_model->salary_setup_history_get_data($aj_company, $aj_department, $location_id, $employee_id, $from_year, $to_year);
		//	print_r($this->db->last_query());exit;
		$data_filtered = array();
		$data = array();
		$array_dates = array();
		if (count($salary_history) > 0) {

			foreach ($salary_history as $value) {
				$array_dates[] = $value->date;
			}
		}
		$array_dates = array_unique($array_dates);
		if (count($salary_history) > 0) {
			$array = array();
			foreach ($salary_history as $value) {
				if (in_array($value->date, $array_dates)) {
					//emp_info
					$employee = $this->Reports_model->read_employee_info($value->employee_id);

					if (!is_null($employee)) {
						$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
						$emp_id = $employee[0]->employee_id;
						$date_of_joining = $employee[0]->date_of_joining;
						$basic_salary = $employee[0]->basic_salary;
					} else {
						$full_name = '--';
						$emp_id = '--';
						$date_of_joining = '--';
						$basic_salary = '--';
					}
					$amt_history_val = $basic_salary;
					$emp_info = $emp_id . '<br>' . $full_name;

					// get department
					$department_get = $this->Reports_model->employee_department_join_get($value->employee_id);

					if (!is_null($department_get)) {
						$department_name = $department_get[0]->department_name;
					} else {
						$department_name = '--';
					}

					if ($value->inc_or_dec == '0') {
						$inc_or_dec_data = '';
					} else if ($value->inc_or_dec == '') {
						$inc_or_dec_data = '';
					} else {
						$inc_or_dec_data = $value->inc_or_dec . ' : ';
					}

					$inc_dec_amt = $inc_or_dec_data . '' . $value->inc_amt;


					$emp_id_main = $value->employee_id;


					$sql_emp = "SELECT * FROM `xin_employees` WHERE user_id = $emp_id_main";
					$emp_basic_get = $this->db->query($sql_emp)->row();

					if (!empty($emp_basic_get)) {
						$emp_basic_get_data = $emp_basic_get->basic_salary;
					} else {
						$emp_basic_get_data = '0';
					}


					if ($value->history_type == 1) {
						$latest_salary = $this->Reports_model->get_emp_latest_value_from_the_date($value->employee_id, $value->date, 1);
						$amt_history_val = $latest_salary[0]->amount;
						$gross_salary_data = $emp_basic_get_data + $value->amount;
					} else {
						$gross_salary_data = 0;
					}


					$salary_amt = $value->amount;
					$tmp = array(
						$emp_info,
						$value->date,
						$department_name,
						$amt_history_val,
						($value->history_type == 1) ? $amt_history_val : $basic_salary,
						//$inc_dec_amt
					);

					$sql = "SELECT * FROM `allowance` WHERE type_id IN (1,2)";
					$allowances = $this->db->query($sql);
					foreach ($allowances->result() as $allowance) {

						if ($allowance->type_id == 1) {

							$sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_title = ? and allowance_id = ?';
							$binds = array($allowance->id, $value->allowance_id);
							$salary_allowance = $this->db->query($sql, $binds)->row();

							if (!empty($salary_allowance)) {
								$amount_data = $value->amount;
								$gross_salary_data = $emp_basic_get_data + $value->amount;
							} else {
								$amount_data = '0';
							}
						}


						if ($allowance->type_id == 3) {

							$sql_ded = 'SELECT * FROM xin_salary_statutory_deductions WHERE deduction_title = ? and statutory_deductions_id = ?';
							$binds = array($allowance->id, $value->allowance_id);
							$salary_ded = $this->db->query($sql_ded, $binds)->row();

							if (!empty($salary_ded)) {
								$amount_data = $value->amount;
								$gross_salary_data = $emp_basic_get_data + $value->amount;
							} else {
								$amount_data = '0';
							}
						}


						array_push(
							$tmp,

							$amount_data

						);
					}
					array_push(
						$tmp,
						$gross_salary_data
					);

					$data[] = $tmp;
					if (($key = array_search($value->date, $array_dates)) !== false) {
						unset($array_dates[$key]);
					}
				}
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	public function salary_setup_history_get_k()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		if (!empty($session)) {
			$this->load->view("admin/reports/payroll", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_year_data = $_GET['from_year'];
		$to_year_data = $_GET['to_year'];

		//from_month
		$from_year_spilt = explode("-", $from_year_data);
		$from_year = $from_year_spilt[0];
		//$month = $from_year_spilt[1];

		//to_month
		$to_year_spilt = explode("-", $to_year_data);
		$to_year = $to_year_spilt[0];
		//$month = $to_year_spilt[1];


		$salary_history = $this->Reports_model->salary_setup_history_get_data($aj_company, $aj_department, $location_id, $employee_id, $from_year, $to_year);

		$data_filtered = array();

		$data = array();

		if (count($salary_history) > 0) {

			foreach ($salary_history as $value) {

				//emp_info
				$employee = $this->Reports_model->read_employee_info($value->employee_id);

				if (!is_null($employee)) {
					$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
					$emp_id = $employee[0]->employee_id;
					$date_of_joining = $employee[0]->date_of_joining;
					$basic_salary = $employee[0]->basic_salary;
				} else {
					$full_name = '--';
					$emp_id = '--';
					$date_of_joining = '--';
					$basic_salary = '--';
				}

				$emp_info = $emp_id . '<br>' . $full_name;

				// get department
				$department_get = $this->Reports_model->employee_department_join_get($value->employee_id);

				if (!is_null($department_get)) {
					$department_name = $department_get[0]->department_name;
				} else {
					$department_name = '--';
				}

				if ($value->inc_or_dec == '0') {
					$inc_or_dec_data = '';
				} else if ($value->inc_or_dec == '') {
					$inc_or_dec_data = '';
				} else {
					$inc_or_dec_data = $value->inc_or_dec . ' : ';
				}

				$inc_dec_amt = $inc_or_dec_data . '' . $value->inc_amt;


				$emp_id_main = $value->employee_id;


				$sql_emp = "SELECT * FROM `xin_employees` WHERE user_id = $emp_id_main";
				$emp_basic_get = $this->db->query($sql_emp)->row();

				if (!empty($emp_basic_get)) {
					$emp_basic_get_data = $emp_basic_get->basic_salary;
				} else {
					$emp_basic_get_data = '0';
				}


				if ($value->history_type == 1) {
					$gross_salary_data = $emp_basic_get_data + $value->amount;
				} else {
					$gross_salary_data = 0;
				}


				$tmp = array(
					$emp_info,
					$value->date,
					$department_name,
					$value->amount,
					($value->history_type == 1) ? $value->amount : 0,
					//$inc_dec_amt
				);


				$sql = "SELECT * FROM `allowance` WHERE type_id IN (1,2,3)";
				$allowances = $this->db->query($sql);

				foreach ($allowances->result() as $allowance) {

					if ($allowance->type_id == 1) {

						$sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_title = ? and allowance_id = ?';
						$binds = array($allowance->id, $value->allowance_id);
						$salary_allowance = $this->db->query($sql, $binds)->row();

						if (!empty($salary_allowance)) {
							$amount_data = $value->amount;
							$gross_salary_data = $emp_basic_get_data + $value->amount;
						} else {
							$amount_data = '0';
						}
					}


					if ($allowance->type_id == 3) {

						$sql_ded = 'SELECT * FROM xin_salary_statutory_deductions WHERE deduction_title = ? and statutory_deductions_id = ?';
						$binds = array($allowance->id, $value->allowance_id);
						$salary_ded = $this->db->query($sql_ded, $binds)->row();

						if (!empty($salary_ded)) {
							$amount_data = $value->amount;
							$gross_salary_data = $emp_basic_get_data + $value->amount;
						} else {
							$amount_data = '0';
						}
					}

					array_push(
						$tmp,
						$amount_data

					);
				}

				array_push(
					$tmp,
					$gross_salary_data
				);

				$data[] = $tmp;
			}
		}

		$output = array(

			"draw" => $draw,

			"recordsTotal" => count($data),

			"recordsFiltered" => count($data),

			"data" => $data

		);

		echo json_encode($output);

		exit();
	}

	//salary setup history end


	public function leave_register_page()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = "Leave Register" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Leave Register";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();
		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


		if (!empty($session)) {
			$data['subview'] = $this->load->view("admin/reports/leave_register_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard/');
		}

	}

	public function leave_register_report_employee_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['company'];
		$department_id = $_GET['department_id'];
		$location_company = $_GET['location_company'];
		$emp_id = $_GET['emp_id'];
		$leave_type = $_GET['leave_type'];
		$start_date = $_GET['start_date'];
		$end_date = $_GET['end_date'];


		$leave_register_report = $this->Reports_model->leave_register_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);
		$leave_register_annual_report = $this->Reports_model->leave_register_annual_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);

		$data = array();

		if ($leave_type != 0) {

			foreach ($leave_register_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					$apply_date,
					$emp_id_get,
					$full_name,
					$get->department_name,
					$designation_name,
					$date_of_joining,
					$leave_type_id_get,
					$from_date,
					$to_date,
					$get->days,
					$get->reason
				);

			}

		} else if ($leave_type == '0') {

			foreach ($leave_register_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					$apply_date,
					$emp_id_get,
					$full_name,
					$get->department_name,
					$designation_name,
					$date_of_joining,
					$leave_type_id_get,
					$from_date,
					$to_date,
					$get->days,
					$get->reason
				);

			}

			//annual leave get
			foreach ($leave_register_annual_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					$apply_date,
					$emp_id_get,
					$full_name,
					$get->department_name,
					$designation_name,
					$date_of_joining,
					$leave_type_id_get,
					$from_date,
					$to_date,
					$get->days,
					$get->remarks
				);

			}
		}


		//annual leave get
		if ($leave_type == 3) {

			foreach ($leave_register_annual_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					$apply_date,
					$emp_id_get,
					$full_name,
					$get->department_name,
					$designation_name,
					$date_of_joining,
					$leave_type_id_get,
					$from_date,
					$to_date,
					$get->days,
					$get->remarks
				);

			}

		}


		$output = array(
			"draw" => $draw,
			"recordsTotal" => $leave_register_report->num_rows(),
			"recordsFiltered" => $leave_register_report->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();

	}

	//rahul new dev

	public function leave_register_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_company = $this->input->post('p_location');
		$emp_id = $this->input->post('p_employee_id');
		$leave_type = $this->input->post('p_leave_type');
		$start_date = $this->input->post('p_start_date');
		$end_date = $this->input->post('p_end_date');


		$leave_register_report = $this->Reports_model->leave_register_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);
		$leave_register_annual_report = $this->Reports_model->leave_register_annual_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);


		if ($leave_type != 0) {
			$leave_register_report_count = $this->Reports_model->leave_register_report_query_count($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);
		} else if ($leave_type == 0) {
			$leave_register_report_count = $this->Reports_model->leave_register_report_query_count($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);
		}

		if ($leave_type == 3) {
			$leave_register_report_count = $this->Reports_model->leave_register_annual_report_query_count($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);
		}


		//empty data display code start
		if (empty($leave_register_report_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($leave_register_report_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$leave_register_report_count[$key]['header_string'] = $email_phone_address;
			$leave_register_report_count[$key]['company_name'] = $company_name;
			$leave_register_report_count[$key]['logo'] = $logo;
		}


		if ($leave_type != 0) {

			foreach ($leave_register_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					"apply_date" => $apply_date,
					"emp_id_get" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $get->department_name,
					"designation_name" => $designation_name,
					"date_of_joining" => $date_of_joining,
					"leave_type_id_get" => $leave_type_id_get,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"days" => $get->days,
					"reason" => $get->reason,
					"company_id" => $get->company_id
				);

			}

		} else if ($leave_type == '0') {

			foreach ($leave_register_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					"apply_date" => $apply_date,
					"emp_id_get" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $get->department_name,
					"designation_name" => $designation_name,
					"date_of_joining" => $date_of_joining,
					"leave_type_id_get" => $leave_type_id_get,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"days" => $get->days,
					"reason" => $get->reason,
					"company_id" => $get->company_id
				);

			}

			//annual leave get
			foreach ($leave_register_annual_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					"apply_date" => $apply_date,
					"emp_id_get" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $get->department_name,
					"designation_name" => $designation_name,
					"date_of_joining" => $date_of_joining,
					"leave_type_id_get" => $leave_type_id_get,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"days" => $get->days,
					"reason" => $get->remarks,
					"company_id" => $get->company_id
				);

			}
		}


		//annual leave get
		if ($leave_type == 3) {

			foreach ($leave_register_annual_report->result() as $get) {


				// get company
				$company = $this->Xin_model->read_company_info($get->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// get emp id
				$emp_id = $this->Reports_model->employee_data_get($get->user_id);
				if (!is_null($emp_id)) {
					$emp_id_get = $emp_id[0]->employee_id;
				} else {
					$emp_id_get = '--';
				}

				// user full name
				$full_name = $get->first_name . ' ' . $get->last_name;

				// get status
				if ($get->is_active == 0): $status = $this->lang->line('xin_employees_inactive');
				elseif ($get->is_active == 1): $status = $this->lang->line('xin_employees_active'); endif;

				// get designation
				$designation = $this->Designation_model->read_designation_information($get->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// department
				/*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';
      } */

				// get leave type id
				$leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
				if (!is_null($leave_type_id)) {
					$leave_type_id_get = $leave_type_id[0]->type_name;
				} else {
					$leave_type_id_get = '--';
				}


				$date1 = $get->applied_on;
				$apply_date = date("d-m-Y", strtotime($date1));

				$date2 = $get->date_of_joining;
				$date_of_joining = date("d-m-Y", strtotime($date2));

				$date3 = $get->from_date;
				$from_date = date("d-m-Y", strtotime($date3));

				$date4 = $get->to_date;
				$to_date = date("d-m-Y", strtotime($date4));


				$data[] = array(
					"apply_date" => $apply_date,
					"emp_id_get" => $emp_id_get,
					"full_name" => $full_name,
					"department_name" => $get->department_name,
					"designation_name" => $designation_name,
					"date_of_joining" => $date_of_joining,
					"leave_type_id_get" => $leave_type_id_get,
					"from_date" => $from_date,
					"to_date" => $to_date,
					"days" => $get->days,
					"reason" => $get->remarks,
					"company_id" => $get->company_id
				);

			}

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['leave_register_report_count'] = $leave_register_report_count;
		$res['start_date'] = $start_date;
		$res['end_date'] = $end_date;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/leave_register_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Leave_register.pdf', 'D'); //


	}

	//rahul new dev end


	//rahul report section end

	public function employee_list()
	{


		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Employee List' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Employee List';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//$data['all_branches'] = $this->Department_model->all_branches();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_list", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_list_reports()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['company_id'];
		$location_id = $_GET['location_id'];
		$department_id = $_GET['aj_department'];
		$employee_id = $_GET['paysheet_employee_id'];
		$status = $_GET['status'];


		$employee = $this->Reports_model->get_employees_list_reports($company_id, $department_id, $location_id, $employee_id, $status);
		//print_r($employee);exit();
		$data = array();

		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			//print_r($full_name);exit();
			// get status
			if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
			endif;
			// get designation
			// 			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			// 			if(!is_null($designation)){
			// 				$designation_name = $designation[0]->designation_name;
			// 			} else {
			// 				$designation_name = '--';
			// 			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			//nationality

			//print_r($r->nationality_id);exit();
			$nationality = $this->Department_model->read_nationality_information($r->nationality_id);
			//print_r($nationality);exit();
			if (!is_null($nationality)) {
				$nationality_name = $nationality[0]->country_name;
			} else {
				$nationality_name = '--';
			}


			$data[] = array(
				$r->employee_id,
				$full_name,
				// $comp_name,
				$department_name,
				$r->contact_no,
				$r->email,
				$r->date_of_joining
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function employee_list_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$status = $this->input->post('p_status');


		$employee = $this->Reports_model->get_employees_list_reports($company_id, $department_id, $location_id, $employee_id, $status);

		$employee_count = $this->Reports_model->get_employees_list_reports_count($company_id, $department_id, $location_id, $employee_id, $status);

		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}
		foreach ($employee->result_array() as $key => $val) {

			// get company
			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $val['first_name'] . ' ' . $val['last_name'];

			// get status
			if ($val['is_active'] == 0) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($val['is_active'] == 1) : $status = $this->lang->line('xin_employees_active');
			endif;

			// department
			$department = $this->Department_model->read_department_information($val['department_id']);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			//nationality

			//print_r($r->nationality_id);exit();
			$nationality = $this->Department_model->read_nationality_information($val['nationality_id']);
			//print_r($nationality);exit();
			if (!is_null($nationality)) {
				$nationality_name = $nationality[0]->country_name;
			} else {
				$nationality_name = '--';
			}
			$data[$key]['company_id'] = $val['company_id'];
			$data[$key]['employee_id'] = $val['employee_id'];
			$data[$key]['full_name'] = $full_name;
			$data[$key]['comp_name'] = $comp_name;
			$data[$key]['department_name'] = $department_name;
			$data[$key]['nationality_name'] = $nationality_name;
			$data[$key]['status'] = $status;
			$data[$key]['contact'] = $val['contact_no'];
			$data[$key]['email'] = $val['email'];
			$data[$key]['date_of_joining'] = $val['date_of_joining'];

		}

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['employee_count'] = $employee_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/employee_list_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Employee_list.pdf', 'D'); //

	}


	public function department_wise_employee()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Department Wise Employee' . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'reports_employees';
		$data['breadcrumbs'] = 'Department Wise Employee';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		//print_r($data['all_departments']);exit();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/department_wise_employee", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function department_wise_employee_reports()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['company_id'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$status = $_GET['status'];


		$employee_main = $this->Reports_model->department_wise_employee_reports($company_id, $department_id, $location_id, $status);

		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Department Wise Employees Report</strong></span>
            <div class='card-body'>
            <div class='box-datatable table-responsive' id='department_wise_emp_report_datatable'>
            <table class='datatables-demo table table-striped table-bordered' id='department_wise_emp_table'>
                        <thead>
                          <tr>
                                <th>Emp. Code</th>
                                <th>Employee Name</th>
                                <th>Designation</th>
                                <th>Date of Joining</th>
                          </tr>
                        </thead>";


		foreach ($employee_main->result() as $get) {

			$table .= "<tr style='background-color: #E0E0EB;'><th style='border-right-width: 0px;'>Department Name : " . $get->department_name . "</th>
                    <th style='border-right-width: 0px;'></th>
                    <th style='border-right-width: 0px;'></th>
                    <th style='border-right-width: 0px;'></th></tr>";

			if ($company_id != '') {
				$company_str = "AND xin_employees.company_id IN($company_id)";
			} else {
				$company_str = "";
			}

			if ($department_id != '') {
				$department_str = "AND xin_employees.department_id IN($department_id)";
			} else {
				$department_str = "";
			}

			if ($location_id != '') {
				$location_str = "AND xin_employees.location_id IN($location_id)";
			} else {
				$location_str = "";
			}

			if ($status != 'all') {
				$status_str = "AND xin_employees.is_active IN($status)";
			} else {
				$status_str = "";
			}

			$department_id_data = $get->department_id;

			$sql = "SELECT xin_employees.department_id, xin_employees.designation_id,xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_companies.name, xin_departments.department_name from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE xin_employees.user_id != '1' AND xin_employees.department_id = $department_id_data $company_str $department_str $location_str $status_str ";
			$employee = $this->db->query($sql);

			foreach ($employee->result() as $r) {

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				// get status


				//  if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
				//  elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
				//  endif;


				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				$table .= "<tr>";
				$table .= "<td>" . $r->employee_id . "</td>
                        <td>" . $full_name . "</td>
                        <td>" . $designation_name . "</td>
                        <td>" . $r->date_of_joining . "</td>";
				$table .= "</tr>";

			}
		}

		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function department_wise_emp_pdf_get_old()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$status = $this->input->post('p_status');


		$employee = $this->Reports_model->department_wise_employee_reports($company_id, $department_id, $location_id, $status);
		$employee_count = $this->Reports_model->department_wise_employee_reports_count($company_id, $department_id, $location_id, $status);

		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}
		foreach ($employee->result_array() as $key => $val) {

			$full_name = $val['first_name'] . ' ' . $val['last_name'];

			if ($val['is_active'] == 2) : $status = $this->lang->line('xin_employees_inactive');
			elseif ($val['is_active'] == 1) : $status = $this->lang->line('xin_employees_active');
			endif;


			$data[$key]['employee_id'] = $val['employee_id'];
			$data[$key]['full_name'] = $full_name;
			$data[$key]['name'] = $val['name'];
			$data[$key]['department_name'] = $val['department_name'];
			$data[$key]['date_of_joining'] = $val['date_of_joining'];
			$data[$key]['status'] = $status;
			$data[$key]['company_id'] = $val['company_id'];
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['employee_count'] = $employee_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/department_wise_emp_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Department_Wise_Employee.pdf', 'D');


	}

	public function department_wise_head_count()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = 'Department Wise Head Count' . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'department wise head count report';
		$data['breadcrumbs'] = 'Department Wise Head Count';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		//print_r($data['all_designation']);exit();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/department_wise_head_count", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function department_wise_head_count_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['company_id'];
		$location_id = $_GET['location_id'];
		$department_id = $_GET['aj_department'];
		$status = $_GET['status'];

		$employee = $this->Reports_model->department_wise_head_count_report($company_id, $department_id, $location_id, $status);

		$data = array();

		foreach ($employee->result() as $r) {

			//get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			if ($r->department_code != '') {
				$dept_code = $r->department_code;
			} else {
				$dept_code = '--';
			}


			$data[] = array(
				//$comp_name,
				// $dept_code,
				$r->department_name,
				$r->headcount
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function department_wise_head_count_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$status = $this->input->post('p_status');


		$employee = $this->Reports_model->department_wise_head_count_report($company_id, $department_id, $location_id, $status);
		$employee_count = $this->Reports_model->department_wise_head_count_report_count($company_id, $department_id, $location_id, $status);

		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}
		foreach ($employee->result_array() as $key => $val) {

			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			//	$data[$key]['comp_name']=$comp_name;
			$data[$key]['department_code'] = $val['department_code'];
			$data[$key]['department_name'] = $val['department_name'];
			$data[$key]['headcount'] = $val['headcount'];
			$data[$key]['company_id'] = $val['company_id'];

		}

		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['employee_count'] = $employee_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/department_wise_head_count_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Department_Wise_head_count.pdf', 'D'); //


	}

	public function designation_wise_employee()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = 'Designation Wise Employee' . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'designation wise employee report';
		$data['breadcrumbs'] = 'Designation Wise Employee';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_designation'] = $this->Department_model->all_designation();
		//print_r($data['all_designation']);exit();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/designation_wise_employee", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function designation_wise_employee_reports()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['company_id'];
		$location_id = $_GET['location_id'];
		$department_id = $_GET['aj_department'];
		$designation_id = $_GET['designation_id'];
		$status = $_GET['status'];

		$employee_main = $this->Reports_model->designation_wise_employee_reports($company_id, $designation_id, $location_id, $status, $department_id);

		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Designation Wise Employees Report</strong></span>
            <div class='card-body'>
            <div class='box-datatable table-responsive' id='designation_report_datatable'>
            <table class='datatables-demo table table-striped table-bordered' id='designation_wise_emp_table'>
                        <thead>
                          <tr>
                                <th>Emp. Code</th>
                                <th>Employee Name</th>
                                <th>Department</th>
                                <th>Date of Joining</th>
                          </tr>
                        </thead>";


		foreach ($employee_main->result() as $get) {

			$table .= "<tr style='background-color: #E0E0EB;'><th style='border-right-width: 0px;'>Designation Name : " . $get->designation_name . "</th>
                    <th style='border-right-width: 0px;'></th>
                    <th style='border-right-width: 0px;'></th>
                    <th style='border-right-width: 0px;'></th></tr>";

			if ($company_id != '') {
				$company_str = "AND xin_designations.company_id IN($company_id)";
			} else {
				$company_str = "";
			}

			if ($designation_id != '') {
				$designation_str = "AND xin_designations.designation_id IN($designation_id)";
			} else {
				$designation_str = "";
			}

			if ($location_id != '') {
				$location_str = "AND xin_employees.location_id IN($location_id)";
			} else {
				$location_str = "";
			}

			if ($department_id != '') {
				$department_str = "AND xin_designations.department_id IN($department_id)";
			} else {
				$department_str = "";
			}

			if ($status != 'all') {
				$status_str = "AND xin_employees.is_active IN($status)";
			} else {
				$status_str = "";
			}

			$designation_id_data = $get->designation_id;

			$sql = "SELECT xin_departments.department_name as department_name,xin_employees.employee_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_employees.company_id, xin_designations.designation_name from xin_employees JOIN xin_designations on xin_designations.designation_id=xin_employees.designation_id JOIN xin_departments on xin_departments.department_id =xin_employees.department_id   JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE user_id != '1' AND xin_employees.designation_id = $designation_id_data $company_str $designation_str $location_str $department_str $status_str";
			$employee = $this->db->query($sql);

			foreach ($employee->result() as $r) {

				// get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				// get status


				//  if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
				//  elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
				//  endif;

				$table .= "<tr>";
				$table .= "<td>" . $r->employee_id . "</td>
                        <td>" . $full_name . "</td>
                        <td>" . $r->department_name . "</td>
                        <td>" . $r->date_of_joining . "</td>";
				$table .= "</tr>";

			}
		}

		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function designation_wise_emp_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$designation_id = $this->input->post('p_designation');
		$location_id = $this->input->post('p_location');
		$status = $this->input->post('p_status');
		$department_id = $this->input->post('p_department');

		$employee = $this->Reports_model->designation_wise_employee_reports_pdf($company_id, $designation_id, $location_id, $status, $department_id);

		$employee_count = $this->Reports_model->designation_wise_employee_reports_count($company_id, $designation_id, $location_id, $status, $department_id);


		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}
		foreach ($employee as $key => $val) {
			$data[$key]['company_id'] = $val['company_id'];
			$data[$key]['designation_name'] = $val['designation_name'];
			foreach ($val['list'] as $k => $v1) {
				// get company
				$company = $this->Xin_model->read_company_info($v1['company_id']);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				// user full name
				$full_name = $v1['first_name'] . ' ' . $v1['last_name'];
				// get status


				if ($v1['is_active'] == 0) : $status = $this->lang->line('xin_employees_inactive');
				elseif ($v1['is_active'] == 1) : $status = $this->lang->line('xin_employees_active');
				endif;


				$data[$key]['list'][$k]['employee_id'] = $v1['employee_id'];
				$data[$key]['list'][$k]['comp_name'] = $comp_name;
				$data[$key]['list'][$k]['full_name'] = $full_name;
				$data[$key]['list'][$k]['designation_name'] = $v1['designation_name'];
				$data[$key]['list'][$k]['date_of_joining'] = $v1['date_of_joining'];
				$data[$key]['list'][$k]['status'] = $status;
				$data[$key]['list'][$k]['company_id'] = $v1['company_id'];
				$data[$key]['list'][$k]['department_name'] = $v1['department_name'];

			}
		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['employee_count'] = $employee_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		// var_dump($data);die();
		$html = $this->load->view("admin/reports/designation_wise_employee_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Designation_Wise_Employee.pdf', 'D');


	}

	public function employee_document_expiry()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_hr_employee_document_expired') . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'reports_employees';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_document_expired');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_documents'] = $this->Department_model->all_documents();
		//print_r($data['all_designation']);exit();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_document_expiry", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_document_expiry_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $this->uri->segment(4);
		$department_id = $this->uri->segment(5);
		$location_id = $this->uri->segment(6);
		$document_id = $this->uri->segment(7);
		$from_date = $this->uri->segment(8);
		$to_date = $this->uri->segment(9);

		// 		print_r($company_id);
		// 		print_r($department_id);
		// 		print_r($location_id);
		// 		print_r($document_id);
		// 		print_r($from_date);print_r($to_date);
		// 		exit();

		$employee = $this->Reports_model->employee_document_expiry_report($company_id, $department_id, $location_id, $document_id, $from_date, $to_date);

		$data = array();

		foreach ($employee->result() as $r) {
			//print_r($r->is_active);exit();
			//get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			//print_r($full_name);exit();
			// get status


			// if($r->is_active==2): $status = $this->lang->line('xin_employees_inactive');
			// elseif($r->is_active==1): $status = $this->lang->line('xin_employees_active'); endif;


			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}

			//designation
			// $designation = $this->Department_model->read_designation_information($r->designation_id);
			// if(!is_null($designation)){
			// 	$designation_name = $designation[0]->designation_name;
			// } else {
			// 	$designation_name = '--';
			// }

			//designation
			//nationality

			//print_r($r->nationality_id);exit();


			$data[] = array(
				$comp_name,
				$full_name,
				$department_name,
				$designation_name,
				$r->date_of_joining,
				$r->title,
				$r->date_of_expiry
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function employee_monthly_leave_taken()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Monthly Leave Taken Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Monthly Leave Taken Report';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_leaves'] = $this->Department_model->all_leaves();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();
		$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();
		//print_r($data['all_locations']);exit();
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_monthly_leave_taken", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_monthly_leave_taken_report()
	{

		//print_r('hi');exit();
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

// 		$company_id = $this->uri->segment(4);
// 		$employee_id = $this->uri->segment(5);
// 		$department_id = $this->uri->segment(6);
// 		$leave_id = $this->uri->segment(7);
// 		$location_id = $this->uri->segment(8);
// 		$year = $this->uri->segment(9);
// 		$status = $this->uri->segment(10);

		$company_id = $_GET['company_selected'];
		$department_id = $_GET['department_selected'];
		$location_id = $_GET['location_company'];
		$employee_id = $_GET['employee_selected'];
		$leave_id = $_GET['leave_selected'];
		$year = $_GET['year'];


		$data = array();

		$employee = $this->Reports_model->employee_monthly_leave_taken_report($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);

		$employee_annual = $this->Reports_model->employee_monthly_annual_leave_taken_report($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);
		//print_r($employee->result());exit();

		$data = array();
		$jan_count = array();
		$feb_count = array();
		$mar_count = array();
		$april_count = array();
		$may_count = array();
		$june_count = array();
		$july_count = array();
		$august_count = array();
		$sep_count = array();
		$oct_count = array();
		$nov_count = array();
		$dec_count = array();

		if ($leave_id != 0) {

			foreach ($employee->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_count = $this->Reports_model->get_monthly_leave_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						$r->employee_id,
						$comp_name,
						$full_name,
						$dept_name,
						$designation_name,
						$leave_type_name,
						$January_leave_count,
						$feb_leave_count,
						$march_leave_count,
						$april_leave_count,
						$may_leave_count,
						$june_leave_count,
						$july_leave_count,
						$aug_leave_count,
						$sep_leave_count,
						$october_leave_count,
						$nov_leave_count,
						$dec_leave_count,
						$taken_leave_total
					);
				}
			}

		} else if ($leave_id == '0') {

			foreach ($employee->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_count = $this->Reports_model->get_monthly_leave_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						$r->employee_id,
						$comp_name,
						$full_name,
						$dept_name,
						$designation_name,
						$leave_type_name,
						$January_leave_count,
						$feb_leave_count,
						$march_leave_count,
						$april_leave_count,
						$may_leave_count,
						$june_leave_count,
						$july_leave_count,
						$aug_leave_count,
						$sep_leave_count,
						$october_leave_count,
						$nov_leave_count,
						$dec_leave_count,
						$taken_leave_total
					);
				}
			}

			//annual leave
			foreach ($employee_annual->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_annual_count = $this->Reports_model->get_monthly_leave_annual_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_annual_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						$r->employee_id,
						$comp_name,
						$full_name,
						$dept_name,
						$designation_name,
						$leave_type_name,
						$January_leave_count,
						$feb_leave_count,
						$march_leave_count,
						$april_leave_count,
						$may_leave_count,
						$june_leave_count,
						$july_leave_count,
						$aug_leave_count,
						$sep_leave_count,
						$october_leave_count,
						$nov_leave_count,
						$dec_leave_count,
						$taken_leave_total
					);
				}
			}
		}

		if ($leave_id == 3) {

			//annual leave
			foreach ($employee_annual->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_annual_count = $this->Reports_model->get_monthly_leave_annual_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_annual_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						$r->employee_id,
						$comp_name,
						$full_name,
						$dept_name,
						$designation_name,
						$leave_type_name,
						$January_leave_count,
						$feb_leave_count,
						$march_leave_count,
						$april_leave_count,
						$may_leave_count,
						$june_leave_count,
						$july_leave_count,
						$aug_leave_count,
						$sep_leave_count,
						$october_leave_count,
						$nov_leave_count,
						$dec_leave_count,
						$taken_leave_total
					);
				}
			}

		}


		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}


	//rahul new dev

	public function monthly_leave_taken_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$leave_id = $this->input->post('p_leave_type');
		$year = $this->input->post('p_year');


		$employee = $this->Reports_model->employee_monthly_leave_taken_report($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);

		$employee_annual = $this->Reports_model->employee_monthly_annual_leave_taken_report($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);


		if ($leave_id != 0) {
			$employee_count = $this->Reports_model->employee_monthly_leave_taken_report_count($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);
		} else if ($leave_id == 0) {
			$employee_count = $this->Reports_model->employee_monthly_leave_taken_report_count($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);
			// $employee_count = $this->Reports_model->employee_monthly_annual_leave_taken_report_count($company_id,$employee_id,$department_id,$leave_id,$year,$location_id);
		}

		if ($leave_id == 3) {
			$employee_count = $this->Reports_model->employee_monthly_annual_leave_taken_report_count($company_id, $employee_id, $department_id, $leave_id, $year, $location_id);
		}

		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}


		$jan_count = array();
		$feb_count = array();
		$mar_count = array();
		$april_count = array();
		$may_count = array();
		$june_count = array();
		$july_count = array();
		$august_count = array();
		$sep_count = array();
		$oct_count = array();
		$nov_count = array();
		$dec_count = array();

		if ($leave_id != 0) {

			foreach ($employee->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_count = $this->Reports_model->get_monthly_leave_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						"user_id" => $r->employee_id,
						"comp_name" => $comp_name,
						"full_name" => $full_name,
						"dept_name" => $dept_name,
						"designation_name" => $designation_name,
						"leave_type_name" => $leave_type_name,
						"January_leave_count" => $January_leave_count,
						"feb_leave_count" => $feb_leave_count,
						"march_leave_count" => $march_leave_count,
						"april_leave_count" => $april_leave_count,
						"may_leave_count" => $may_leave_count,
						"june_leave_count" => $june_leave_count,
						"july_leave_count" => $july_leave_count,
						"aug_leave_count" => $aug_leave_count,
						"sep_leave_count" => $sep_leave_count,
						"october_leave_count" => $october_leave_count,
						"nov_leave_count" => $nov_leave_count,
						"dec_leave_count" => $dec_leave_count,
						"taken_leave_total" => $taken_leave_total,
						"company_id" => $r->company_id
					);
				}
			}

		} else if ($leave_id == '0') {

			foreach ($employee->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_count = $this->Reports_model->get_monthly_leave_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						"user_id" => $r->employee_id,
						"comp_name" => $comp_name,
						"full_name" => $full_name,
						"dept_name" => $dept_name,
						"designation_name" => $designation_name,
						"leave_type_name" => $leave_type_name,
						"January_leave_count" => $January_leave_count,
						"feb_leave_count" => $feb_leave_count,
						"march_leave_count" => $march_leave_count,
						"april_leave_count" => $april_leave_count,
						"may_leave_count" => $may_leave_count,
						"june_leave_count" => $june_leave_count,
						"july_leave_count" => $july_leave_count,
						"aug_leave_count" => $aug_leave_count,
						"sep_leave_count" => $sep_leave_count,
						"october_leave_count" => $october_leave_count,
						"nov_leave_count" => $nov_leave_count,
						"dec_leave_count" => $dec_leave_count,
						"taken_leave_total" => $taken_leave_total,
						"company_id" => $r->company_id
					);
				}
			}

			//annual leave
			foreach ($employee_annual->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_annual_count = $this->Reports_model->get_monthly_leave_annual_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_annual_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						"user_id" => $r->employee_id,
						"comp_name" => $comp_name,
						"full_name" => $full_name,
						"dept_name" => $dept_name,
						"designation_name" => $designation_name,
						"leave_type_name" => $leave_type_name,
						"January_leave_count" => $January_leave_count,
						"feb_leave_count" => $feb_leave_count,
						"march_leave_count" => $march_leave_count,
						"april_leave_count" => $april_leave_count,
						"may_leave_count" => $may_leave_count,
						"june_leave_count" => $june_leave_count,
						"july_leave_count" => $july_leave_count,
						"aug_leave_count" => $aug_leave_count,
						"sep_leave_count" => $sep_leave_count,
						"october_leave_count" => $october_leave_count,
						"nov_leave_count" => $nov_leave_count,
						"dec_leave_count" => $dec_leave_count,
						"taken_leave_total" => $taken_leave_total,
						"company_id" => $r->company_id
					);
				}
			}
		}

		if ($leave_id == 3) {

			//annual leave
			foreach ($employee_annual->result() as $r) {
				//get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$department_name = $this->Xin_model->read_department_info($r->department_id);
				if (!is_null($department_name)) {
					$dept_name = $department_name[0]->department_name;
				} else {
					$dept_name = '--';
				}

				// get designation
				$designation = $this->Designation_model->read_designation_information($r->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// user full name
				$full_name = $r->first_name . ' ' . $r->last_name;
				//print_r($full_name);exit();
				//print_r($from_date);print_r($to_date);exit();
				$monthly_leave_type_annual_count = $this->Reports_model->get_monthly_leave_annual_taken($r->user_id, $year);
				//print_r($monthly_leave_type_count);exit();

				foreach ($monthly_leave_type_annual_count as $leave_type_name => $leave_type_count) {
					//print_r($leave_type_count);
					$January = 'January';
					$February = 'February';
					$March = 'March';
					$April = 'April';
					$May = 'May';
					$June = 'June';
					$July = 'July';
					$August = 'August';
					$September = 'September';
					$October = 'October';
					$November = 'November';
					$December = 'December';
					for ($times = 1; $times <= 12; $times++) {
						if (!array_key_exists($January, $leave_type_count)) {
							$leave_type_count['January'] = '0';
						} else if (!array_key_exists($February, $leave_type_count)) {
							# code...
							$leave_type_count['February'] = '0';
						} else if (!array_key_exists($March, $leave_type_count)) {
							# code...
							$leave_type_count['March'] = '0';
						} else if (!array_key_exists($April, $leave_type_count)) {
							# code...
							$leave_type_count['April'] = '0';
						} else if (!array_key_exists($May, $leave_type_count)) {
							# code...
							$leave_type_count['May'] = '0';
						} else if (!array_key_exists($June, $leave_type_count)) {
							# code...
							$leave_type_count['June'] = '0';
						} else if (!array_key_exists($July, $leave_type_count)) {
							# code...
							$leave_type_count['July'] = '0';
						} else if (!array_key_exists($August, $leave_type_count)) {
							# code...
							$leave_type_count['August'] = '0';
						} else if (!array_key_exists($September, $leave_type_count)) {
							# code...
							$leave_type_count['September'] = '0';
						} else if (!array_key_exists($October, $leave_type_count)) {
							# code...
							$leave_type_count['October'] = '0';
						} else if (!array_key_exists($November, $leave_type_count)) {
							# code...
							$leave_type_count['November'] = '0';
						} else if (!array_key_exists($December, $leave_type_count)) {
							# code...
							$leave_type_count['December'] = '0';
						}
					}
					//print_r($r->user_id);
					//print_r($leave_type_count);

					$January_leave_count = '';
					$feb_leave_count = '';
					$march_leave_count = '';
					$april_leave_count = '';
					$may_leave_count = '';
					$june_leave_count = '';
					$july_leave_count = '';
					$aug_leave_count = '';
					$sep_leave_count = '';
					$october_leave_count = '';
					$nov_leave_count = '';
					$dec_leave_count = '';
					foreach ($leave_type_count as $key => $value) {

						if ($key == 'January') {
							# code...
							$January_leave_count = $value;
						} else if ($key == 'February') {
							# code...
							$feb_leave_count = $value;
						} else if ($key == 'March') {
							# code...
							$march_leave_count = $value;
						} else if ($key == 'April') {
							# code...
							$april_leave_count = $value;
						} else if ($key == 'May') {
							# code...
							$may_leave_count = $value;
						} else if ($key == 'June') {
							# code...
							$june_leave_count = $value;
						} else if ($key == 'July') {
							# code...
							$july_leave_count = $value;
						} else if ($key == 'August') {
							# code...
							$aug_leave_count = $value;
						} else if ($key == 'September') {
							# code...
							$sep_leave_count = $value;
						} else if ($key == 'October') {
							# code...
							$october_leave_count = $value;
						} else if ($key == 'November') {
							# code...
							$nov_leave_count = $value;
						} else if ($key == 'December') {
							# code...
							$dec_leave_count = $value;
						}
						//print_r($January_leave_count);
					}

					$taken_leave_total = $January_leave_count + $feb_leave_count + $march_leave_count + $april_leave_count + $may_leave_count + $june_leave_count + $july_leave_count + $aug_leave_count + $sep_leave_count + $october_leave_count + $nov_leave_count + $dec_leave_count;

					$data[] = array(
						"user_id" => $r->employee_id,
						"comp_name" => $comp_name,
						"full_name" => $full_name,
						"dept_name" => $dept_name,
						"designation_name" => $designation_name,
						"leave_type_name" => $leave_type_name,
						"January_leave_count" => $January_leave_count,
						"feb_leave_count" => $feb_leave_count,
						"march_leave_count" => $march_leave_count,
						"april_leave_count" => $april_leave_count,
						"may_leave_count" => $may_leave_count,
						"june_leave_count" => $june_leave_count,
						"july_leave_count" => $july_leave_count,
						"aug_leave_count" => $aug_leave_count,
						"sep_leave_count" => $sep_leave_count,
						"october_leave_count" => $october_leave_count,
						"nov_leave_count" => $nov_leave_count,
						"dec_leave_count" => $dec_leave_count,
						"taken_leave_total" => $taken_leave_total,
						"company_id" => $r->company_id
					);
				}
			}

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['lists'] = $data;
		$res['employee_count'] = $employee_count;
		$res['year'] = $year;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/monthly_leave_taken_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Monthly_Leave_Taken.pdf', 'D'); //


	}

	//rahul new dev end

	public function advance_loan_report()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = $this->lang->line('xin_hr_employee_advance_report') . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'reports_employees';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_report');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_advance_loan", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_advance_loan_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $this->uri->segment(4);
		$employee_id = $this->uri->segment(5);
		$location_id = $this->uri->segment(6);
		$from_date = $this->uri->segment(7);
		$to_date = $this->uri->segment(8);
		$status = $this->uri->segment(9);

		if ($from_date != 0 || $to_date != 0) {
			# code...
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
		}

		// print_r($company_id);
		// print_r($employee_id);
		// print_r($location_id);
		// print_r($from_date);
		// print_r($to_date);
		//print_r($status);
		// exit();

		$employee = $this->Reports_model->employee_advance_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);

		//print_r($employee);exit();

		$data = array();

		foreach ($employee->result() as $r) {
			//get closing balance of each employee
			//print_r($r->user_id);print_r(" ");
			//print_r($r->Total_advance_amount);print_r(" ");

			//get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$Total_deducted_amount = $this->Reports_model->get_Total_deducted_amount($r->user_id);

			foreach ($Total_deducted_amount->result() as $d) {

				$total_deduct_amount = $d->Total_deducted_amount;
			}
			//print_r($total_deduct_amount);exit();
			$closing_balance = $r->Total_advance_amount - $total_deduct_amount;
			//print_r($closing_balance);exit();
			//get closing balance of each employee

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			//print_r($full_name);exit();
			// get status

			if ($r->status == 0) : $status = 'pending';
			elseif ($r->status == 1) : $status = 'accepted';
			elseif ($r->status == 2) : $status = 'rejected';
			endif;

			$adjusted_amount = 0.00;


			// $data[] = array(
			// 	$r->employee_id,
			// 	$comp_name,
			// 	$full_name,
			// 	$r->month_year,
			// 	$r->end_date,
			// 	$r->monthly_installment,
			// 	$r->Total_advance_amount,
			// 	$total_deduct_amount,
			// 	$adjusted_amount,
			// 	$closing_balance,
			// 	$status
			// );

			$data[] = array(
				$r->employee_id,
				$comp_name,
				$full_name,
				$r->Total_advance_amount,
				$total_deduct_amount,
				$adjusted_amount,
				$closing_balance,
				$status
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function employee_loan_salary()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_employee_loan_report') . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'employee losn report';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_loan_report');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_loan", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_loan_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $this->uri->segment(4);
		$employee_id = $this->uri->segment(5);
		$location_id = $this->uri->segment(6);
		$from_date = $this->uri->segment(7);
		$to_date = $this->uri->segment(8);
		$status = $this->uri->segment(9);

		//change date format from dd-mm-yyyy to yyyy-mm-dd
		if ($from_date != 0 || $to_date != 0) {
			# code...
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
		}
		//change date format from dd-mm-yyyy to yyyy-mm-dd

		// print_r($company_id);
		// print_r($employee_id);
		// print_r($location_id);
		// print_r($from_date_new);
		// print_r($to_date_new);
		// print_r($status);
		// exit();

		$employee = $this->Reports_model->employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);
		//print_r($employee->result());exit();

		$data = array();

		foreach ($employee->result() as $r) {

			//print_r($r->user_id);print_r(" ");
			//print_r($r->Total_advance_amount);print_r(" ");
			//get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			//get closing balance of each employee

			$Total_deducted_amount = $this->Reports_model->get_Total_deducted_amount_loan_report($r->user_id);

			foreach ($Total_deducted_amount->result() as $d) {

				$total_deduct_amount = $d->Total_deducted_amount;
			}
			$closing_balance = $r->Total_loan_amount - $total_deduct_amount;
			//print_r($closing_balance);exit();
			//get closing balance of each employee

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			//print_r($full_name);exit();
			// get status
			if ($r->status == 0) : $status = 'pending';
			elseif ($r->status == 1) : $status = 'approved';
			elseif ($r->status == 2) : $status = 'rejected';
			endif;

			$adjusted_amount = 0.00;


			// $data[] = array(
			// 	$r->employee_id,
			// 	$comp_name,
			// 	$full_name,
			// 	$r->loan_deduction_title,
			// 	$r->loan_deduction_amount,
			// 	$r->Total_loan_amount,
			// 	$total_deduct_amount,
			// 	$adjusted_amount,
			// 	$closing_balance,
			// 	$status,
			// 	$r->end_date
			// );

			$data[] = array(
				$r->employee_id,
				$comp_name,
				$full_name,
				$r->loan_deduction_title,
				$r->Total_loan_amount,
				$total_deduct_amount,
				$adjusted_amount,
				$closing_balance,
				$status,
				$r->end_date
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function employee_advance_loan_outstanding_details()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_employee_advance_loan_outstanding_details') . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'Advance Loan Outstanding Report';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_loan_outstanding_details');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_advance_loan_outstanding_details", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_advance_loan_outstanding_report()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $this->uri->segment(4);
		//$company_id = $this->input->get('company_id');
		$employee_id = $this->uri->segment(5);
		//print_r($company_id);exit();
		//$employee_id = $this->input->get('employee_id');
		$location_id = $this->uri->segment(6);
		//$location_id = $this->input->get('location_id');
		$from_date = $this->uri->segment(7);
		//print_r($from_date);exit();
		//$from_date = $this->input->get('from_date');
		$to_date = $this->uri->segment(8);
		//print_r($from_date);exit();
		$status = $this->uri->segment(9);

		//change date format from dd-mm-yyyy to yyyy-mm-dd
		if ($from_date != 0 || $to_date != 0) {
			# code...
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
		}
		//change date format from dd-mm-yyyy to yyyy-mm-dd

		$employee = $this->Reports_model->employee_advance_loan_outstanding_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);
		//print_r($employee->result());exit();

		$table = "";
		$table .= "<table class='datatables-demo table table-striped table-bordered' id='advance_loan_outstanding'>
                      <thead>
                        <tr>
                            <th>Employee ID</th>
			                <th>Company</th>
			                <th>Employee Name</th>
			                <th>Amount Type</th>
			                <th>Amount</th>
			                <th>Advance Date</th>
			                <th>Monthly Installment</th>
			                <th>Adjusted Amount</th>
			                <th>Closing Balance</th>
                        </tr>
                        </thead>
                      <tbody>";

		foreach ($employee->result() as $row) {

			//get amount type
			if ($row->table_name == 'xin_salary_loan_deductions_monthwise') {
				# code...
				$amount_type = 'Loan Amount';
			} else if ($row->table_name == 'xin_advance_deductions_monthwise') {
				$amount_type = 'Advance Amount';
			}
			//get amount type

			//get employee id
			$employee_id = $this->Xin_model->read_employee_id($row->employee_id);
			//print_r($employee_id);exit();
			if (!is_null($employee_id)) {
				$employee_id = $employee_id[0]->employee_id;
			} else {
				$employee_id = '--';
			}


			//get company
			$company = $this->Xin_model->read_company_info($row->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			//fullname
			$full_name = $row->first_name . ' ' . $row->last_name;

			//get closing balance of each employee

			$Total_deducted_amount = $this->Reports_model->get_Total_deducted_advance_loan_report($row->employee_id, $row->table_name);

			foreach ($Total_deducted_amount as $d) {

				$total_deduct_amount = $d->Total_deducted_amount;
			}
			$closing_balance = $row->Total_loan_amount - $total_deduct_amount;
			//get closing balance of each employee

			$get_advance_loan_employee = $this->Reports_model->get_advance_loan_employee($row->employee_id, $row->advance_or_loan_count_helper_id, $row->table_name);

			$table .= "<tr>
                        <td>" . $employee_id . ".</td>
                        <td>" . $comp_name . "</td>
                        <td>" . $full_name . "</td>
                        <td>" . $amount_type . "</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";

			foreach ($get_advance_loan_employee as $r) {

				$table .= "<tr>  
            			<td></td>
                        <td></td>
                        <td></td>
                        <td></td>
            			<td>" . $row->Amount . "</td>
        				<td>" . $r->month_year . "</td>
                    	<td>" . $r->monthly_installment . "</td>
                    	<td>0.00</td>
                        <td>" . $closing_balance . "</td>
                    </tr>";
			}
		}
		$table .= "</tbody>
	                <tfoot>
	                    <tr>
	                        <th>Employee ID</th>
			                <th>Company</th>
			                <th>Employee Name</th>
			                <th>Amount Type</th>
			                <th>Amount</th>
			                <th>Advance Date</th>
			                <th>Monthly Installment</th>
			                <th>Adjusted Amount</th>
			                <th>Closing Balance</th>
	                    </tr>
	                </tfoot>
	            </table>";

		//print_r($employee);exit();
		echo json_encode($table);
		exit();
	}

	public function employee_advance_loan_register()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_employee_advance_loan_register') . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'Advance Loan Register Report';
		$data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_loan_register');
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_advance_loan_register", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_advance_loan_register_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $this->uri->segment(4);
		$employee_id = $this->uri->segment(5);
		$location_id = $this->uri->segment(6);
		$from_date = $this->uri->segment(7);
		$to_date = $this->uri->segment(8);
		$status = $this->uri->segment(9);

		//change date format from dd-mm-yyyy to yyyy-mm-dd
		if ($from_date != 0 || $to_date != 0) {
			# code...
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
		}
		//change date format from dd-mm-yyyy to yyyy-mm-dd

		// print_r($company_id);
		// print_r($employee_id);
		// print_r($location_id);
		// print_r($from_date);
		// print_r($to_date);
		// print_r($status);
		// exit();

		$employee = $this->Reports_model->employee_advance_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);

		//print_r($employee->result());exit();

		$data = array();

		foreach ($employee->result() as $r) {

			//print_r($r->user_id);print_r(" ");
			//print_r($r->Total_advance_amount);print_r(" ");

			//get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			//get advance type
			if ($r->table_name == 'xin_salary_loan_deductions') {
				$type = 'Loan';
			} else {
				$type = 'Advance';
			}

			//get number of installment of advance or loan
			$advance_or_loan_count_helper_id = $this->Reports_model->read_number_of_installment_of_advance_or_loan($r->advance_or_loan_count_helper_id, $r->table_name);
			if (!is_null($advance_or_loan_count_helper_id)) {
				$num_of_installment = $advance_or_loan_count_helper_id[0]->number_of_installment;
			} else {
				$num_of_installment = '--';
			}

			// user full name
			$full_name = $r->first_name . ' ' . $r->last_name;
			//print_r($full_name);exit();
			// get status
			// if($r->status==0): $status = 'pending';
			// elseif($r->status==1): $status = 'approved';
			// elseif($r->status==2): $status = 'rejected'; endif;

			$data[] = array(
				$r->employee_id,
				$comp_name,
				$full_name,
				$type,
				$r->Amount,
				$num_of_installment,
				$r->monthly_installment,
				$r->month_year
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function employee_shift_allocation()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Employees Shift Allocation Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Employees Shift Allocation Report';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_shift_allocation", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_shift_allocation_report()
	{
		//print_r('hi');exit();
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$depart_main_id = $this->Reports_model->employee_shift_allocation_get($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Employees Shift Allocation Report</strong></span>
            <div class='card-body'>
            <div class='box-datatable table-responsive' id='employee_shift_allocation_report_datatable'>
          <table class='datatables-demo table table-striped table-bordered' id='employee_shift_allocation_report_table'>
                  <thead>
                      <tr>
                        <th style='padding-right: 65px;'>Emp. Code</th>
                        <th style='padding-right: 130px;'>Emp. Name</th>
                        <th>Date</th>
                        <th>Shift Name</th>
                        <th>Shift In</th>
                        <th>Shift Out</th>
                        <th>Late In Grace Time</th>
                        <th>Shift Hours (hh:mm)</th>
                      </tr>
                  </thead>";

		foreach ($depart_main_id->result() as $depart_main_id_get) {

			$depart_main_id_data = $depart_main_id_get->department_id;
			$user_id_data = $depart_main_id_get->user_id;

			//get department
			$department_name = $this->Xin_model->read_department_info($depart_main_id_data);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
				$dept_code = $department_name[0]->department_code;
			} else {
				$dept_name = '--';
				$dept_code = '--';
			}

			if ($employee_id == 0) {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_main_id_data";
				$employee = $this->db->query($sql_data);

			} else {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.company_id IN($company_id) and xin_employees.user_id IN($employee_id)";
				$employee = $this->db->query($sql_data);

			}

			$table .= "<tr style='background-color: #E0E0EB;'>
                <td style='border-right-width: 0px;'><b>Department :</b></td>
                <td style='border-right-width: 0px;'> " . $dept_name . "</td>
                <td style='border-right-width: 0px;'></td>
                <td style='border-right-width: 0px;'></td>
                <td style='border-right-width: 0px;'></td>
                <td style='border-right-width: 0px;'></td>
                <td style='border-right-width: 0px;'></td>
                <td style='border-right-width: 0px;'></td>
              </tr>";

			foreach ($employee->result() as $r) {


				$att_date = $r->attendance_date;
				$get_day = strtotime($att_date);
				$day = date('l', $get_day);

				$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

				if (isset($office_shift[0]->shift_name) != '') {
					$shift_name = $office_shift[0]->shift_name;
				} else {
					$shift_name = '--';
				}

				if ($day == 'Monday') {
					if (isset($office_shift[0]->monday_in_time) != '' && isset($office_shift[0]->monday_out_time) != '') {
						$shift_in_time = $office_shift[0]->monday_in_time;
						$shift_out_time = $office_shift[0]->monday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = date('h:i', strtotime($office_shift[0]->late_allowed_till));
					} else {
						$late_allowed_till = '00:00';
						$shift_in_time = '';
						$shift_out_time = '';
					}

				} else if ($day == 'Tuesday') {
					if (isset($office_shift[0]->tuesday_in_time) != '' && isset($office_shift[0]->tuesday_out_time) != '') {
						$shift_in_time = $office_shift[0]->tuesday_in_time;
						$shift_out_time = $office_shift[0]->tuesday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = date('h:i', strtotime($office_shift[0]->late_allowed_till));
					} else {
						$late_allowed_till = '00:00';
						$shift_in_time = '';
						$shift_out_time = '';
					}

				} else if ($day == 'Wednesday') {
					if (isset($office_shift[0]->wednesday_in_time) != '' && isset($office_shift[0]->wednesday_out_time) != '') {
						$shift_in_time = $office_shift[0]->wednesday_in_time;
						$shift_out_time = $office_shift[0]->wednesday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = date('h:i', strtotime($office_shift[0]->late_allowed_till));
					} else {
						$late_allowed_till = '00:00';
						$shift_in_time = '';
						$shift_out_time = '';
					}
				} else if ($day == 'Thursday') {
					if (isset($office_shift[0]->thursday_in_time) != '' && isset($office_shift[0]->thursday_out_time) != '') {
						$shift_in_time = $office_shift[0]->thursday_in_time;
						$shift_out_time = $office_shift[0]->thursday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = date('h:i', strtotime($office_shift[0]->late_allowed_till));
					} else {
						$late_allowed_till = '00:00';
						$shift_in_time = '';
						$shift_out_time = '';
					}

				} else if ($day == 'Friday') {
					if (isset($office_shift[0]->friday_in_time) != '' && isset($office_shift[0]->friday_out_time) != '') {
						$shift_in_time = $office_shift[0]->friday_in_time;
						$shift_out_time = $office_shift[0]->friday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = 'Holiday';
					} else {
						$late_allowed_till = 'Holiday';
						$shift_in_time = '';
						$shift_out_time = '';
					}

				} else if ($day == 'Saturday') {
					if (isset($office_shift[0]->saturday_in_time) != '' && isset($office_shift[0]->saturday_out_time) != '') {
						$shift_in_time = $office_shift[0]->saturday_in_time;
						$shift_out_time = $office_shift[0]->saturday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = date('h:i', strtotime($office_shift[0]->late_allowed_till));
					} else {
						$late_allowed_till = '00:00';
						$shift_in_time = '';
						$shift_out_time = '';
					}

				} else if ($day == 'Sunday') {
					if (isset($office_shift[0]->sunday_in_time) != '' && isset($office_shift[0]->sunday_out_time) != '') {
						$shift_in_time = $office_shift[0]->sunday_in_time;
						$shift_out_time = $office_shift[0]->sunday_out_time;
						//$late_allowed_till = $office_shift[0]->late_allowed_till;
						$late_allowed_till = date('h:i', strtotime($office_shift[0]->late_allowed_till));
					} else {
						$late_allowed_till = '00:00';
						$shift_in_time = '';
						$shift_out_time = '';
					}

				}
				$full_name = $r->first_name . ' ' . $r->last_name;

				$attendance_date_get = date("d-m-Y", strtotime($r->attendance_date)) . '(' . $day . ')';

				if ($shift_in_time == '') {
					$shift_in_time_get = 'Holiday';
					$shift_in_total = '00:00';
				} else {
					$shift_in_time_get = date('h:i A', strtotime($shift_in_time));
					$shift_in_total = $shift_in_time;
				}

				if ($shift_out_time == '') {
					$shift_out_time_get = 'Holiday';
					$shift_out_total = '00:00';
				} else {
					$shift_out_time_get = date('h:i A', strtotime($shift_out_time));
					$shift_out_total = $shift_out_time;
				}

				//total shift hour get
				// $shift_in_time_dif = new DateTime($shift_in_total);
				// $shift_out_time_dif = new DateTime($shift_out_total);
				// $shift_time_diff = $shift_in_time_dif->diff($shift_out_time_dif);
				// $final_shift_hour = $shift_time_diff->h.':'.$shift_time_diff->i;

				//get employee info
				$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
				if (!empty($employee_info)) {
					$emp_code = $employee_info->employee_id;
				} else {
					$emp_code = '--';
				}

				//custom shift get code
				if ($r->office_shift_id == 0) {
					$custom_shift_data = $this->Reports_model->get_custom_shift_data($r->user_id, $r->attendance_date);
					if (!empty($custom_shift_data)) {
						$shift_name = $custom_shift_data['name'];
						$cust_day = explode('-', $r->attendance_date);
						for ($i = 1; $i <= 31; $i++) {
							if ($cust_day[2] == $i) {
								if ($custom_shift_data[$i . '_in'] != NULL && $custom_shift_data[$i . '_out'] != NULL) {
									$cust_day_in_res = explode(' ', $custom_shift_data[$i . '_in']);
									$cust_day_out_res = explode(' ', $custom_shift_data[$i . '_out']);

									$shift_date_in = $cust_day_in_res[0];
									$shift_date_out = $cust_day_out_res[0];

									$shift_hours = round(abs(strtotime($cust_day_out_res[1]) - strtotime($cust_day_in_res[1])) / 3600, 2);

									$shift_in_time_get = date('h:i A', strtotime($cust_day_in_res[1]));
									$shift_in_total = date('h:i A', strtotime($cust_day_in_res[1]));

									$shift_out_time_get = date('h:i A', strtotime($cust_day_out_res[1]));
									$shift_out_total = date('h:i A', strtotime($cust_day_out_res[1]));
								} else {
									$shift_hours = 0;
									$shift_in_time_get = 0;
									$shift_out_time_get = 0;
									$shift_date_in = '';
									$shift_date_out = '';
								}

							}
						}
						$late_allowed_till = $custom_shift_data['late_allowed_till'] . ' min';
					} else {
						$shift_name = '--';
						$shift_hours = 0;
						$shift_in_time_get = 0;
						$shift_out_time_get = 0;
					}
				}
				//custom shift get code end

				//total shift hour get
				$shift_date_in = $r->attendance_date;
				if ($shift_name == 'Night') {
					$shift_date_out = date('Y-m-d', strtotime($r->attendance_date . " +1 days"));
				} else {
					$shift_date_out = $r->attendance_date;
				}
				$datetime1 = new DateTime($shift_date_in . $shift_in_total);
				$datetime2 = new DateTime($shift_date_out . $shift_out_total);
				$interval = $datetime1->diff($datetime2);
				$final_shift_hour = $interval->format('%h') . " Hours " . $interval->format('%i') . " Minutes";
				//total shift hour get end


				$table .= "<tr>";

				$table .= "<td>" . $emp_code . "</td>
                  			<td>" . $full_name . "</td>
                            <td>" . $attendance_date_get . "</td>
                            <td>" . $shift_name . "</td>
                            <td>" . $shift_in_time_get . "</td>
                            <td>" . $shift_out_time_get . "</td>
                            <td>" . $late_allowed_till . "</td>
                            <td>" . $final_shift_hour . "</td>";

				$table .= "</tr>";

			}

		}

		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();

	}

	public function employee_shift_allocation_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_date');
		$to_date = $this->input->post('p_to_date');

		$depart_main_id = $this->Reports_model->employee_shift_allocation_get($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);

		$depart_main_id_count = $this->Reports_model->employee_shift_allocation_get_count($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);

		//empty data display code start
		if (empty($depart_main_id_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($depart_main_id_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//  echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$depart_main_id_count[$key]['header_string'] = $email_phone_address;
			$depart_main_id_count[$key]['company_name'] = $company_name;
			$depart_main_id_count[$key]['logo'] = $logo;
		}


		foreach ($depart_main_id->result() as $value) {
			$data[] = array(
				"department_id" => $value->department_id,
				"user_id" => $value->user_id,
				"company_id" => $value->company_id
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['main_data'] = $data;
		$res['depart_main_id_count'] = $depart_main_id_count;
		$res['from_date'] = $from_date;
		$res['to_date'] = $to_date;
		$res['employee_id'] = $employee_id;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/employee_wise_shift_allocation_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Employee_Wise_Shift_Allocation.pdf', 'D'); //

	}

	public function employee_daily_punch_summary()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Employee Daily Punch Summary' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Employee Daily Punch Summary';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_daily_punch_summary", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_daily_punch_summary_report()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$depart_main_id = $this->Reports_model->employee_daily_punch_summary_report($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Employees Daily Punch Summary Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_daily_punch_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_daily_punch_report_table'>
	                      <thead>
	                        <tr>
	                            <th style='padding-right: 65px;'>Date</th>
				                <th style='padding-right: 160px;'>Shift</th>
				                <th style='padding-right: 65px;'>Shift Start</th>
				                <th style='padding-right: 160px;'>Shift End</th>
				                <th class='title-space'>Late In Grace Time</th>
				                <th>Clock In</th>
				                <th>Clock Out</th>
        						<th class='title-space'>Last Out - First In</th></tr></thead>";

		foreach ($depart_main_id->result() as $depart_main_id_get) {

			$depart_id_data = $depart_main_id_get->department_id;
			$user_id_data = $depart_main_id_get->user_id;

			//get department
			$department_name = $this->Xin_model->read_department_info($depart_id_data);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
				$dept_code = $department_name[0]->department_code;
			} else {
				$dept_name = '--';
				$dept_code = '--';
			}

			if ($employee_id == 0) {

				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_id_data Group by xin_attendance_time.employee_id";
				$emp_main_id = $this->db->query($sql_data);

			} else {

				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.user_id IN($employee_id) Group by xin_attendance_time.employee_id";
				$emp_main_id = $this->db->query($sql_data);

			}


			$table .= "<tr style='background-color: #E0E0EB;'>
	        		  <td style='border-right-width: 0px;'><b>Department :</b></td>
	        		  <td style='border-right-width: 0px;'>" . $dept_name . "</td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        	  </tr>";


			foreach ($emp_main_id->result() as $emp_main_id_get) {


				$employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->user_id)[0];

				if (!empty($employee_info)) {
					$full_name_info = $employee_info->first_name . " " . $employee_info->last_name;
					$emp_code = $employee_info->employee_id;
					$emp_join_date = $employee_info->date_of_joining;
					$emp_depart_id = $employee_info->department_id;
				} else {
					$full_name_info = '--';
					$emp_code = '--';
					$emp_join_date = '--';
					$emp_depart_id = '0';
				}


				$table .= "<tr style='background-color: #E0E0EB;'>
	        		  <td style='border-right-width: 0px;'><b>Employee :</b></td>
	        		  <td style='border-right-width: 0px;'>[" . $emp_code . "] " . $full_name_info . "</td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  </tr>";

				$emp_main_id_data = $emp_main_id_get->user_id;


				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_attendance_time.employee_id = $emp_main_id_data Group by xin_attendance_time.attendance_date";
				$employee = $this->db->query($sql_data);


				foreach ($employee->result() as $r) {


					# code...
					//get company
					$leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
					if ($leave != '') {
						# code...
						continue;
					}
					$company = $this->Xin_model->read_company_info($r->company_id);
					if (!is_null($company)) {
						$comp_name = $company[0]->name;
					} else {
						$comp_name = '--';
					}

					$department_name = $this->Xin_model->read_department_info($r->company_id);
					if (!is_null($department_name)) {
						$dept_name = $department_name;
					} else {
						$dept_name = '--';
					}

					$full_name = $r->first_name . ' ' . $r->last_name;


					//------------------day wise clock in and clock out start

					$clkInLast = $clkOutLast = '-';

					$this->db->where('employee_id', $r->user_id);
					$this->db->where('attendance_date', $r->attendance_date);
					$this->db->order_by('time_attendance_id', 'asc');
					$attendance = $this->db->get('xin_attendance_time');

					if ($attendance->num_rows() > 0) {

						foreach ($attendance->result() as $att) {
							$clock_in = date("H:i", strtotime($att->clock_in));
							$clock_out = date("H:i", strtotime($att->clock_out));
							if ($clock_in != '0:00' && $clock_out != '0:00') {
								if ($clkInLast == '-')
									$clkInLast = $clock_in;

								$clkOutLast = $clock_out;
							}
						}
					}

					//-----------------day wise clock in and clock out end


					$in_time_without_date = $clkInLast;
					$out_time_without_date = $clkOutLast;

					$att_date = $r->attendance_date;
					$get_day = strtotime($att_date);
					$day = date('l', $get_day);

					$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

					if (isset($office_shift[0]->shift_name) != '') {
						$shift_name = $office_shift[0]->shift_name;
					} else {
						$shift_name = '--';
					}


					if ($day == 'Monday') {
						if (isset($office_shift[0]->monday_in_time) != '' && isset($office_shift[0]->monday_out_time) != '') {
							$shift_in_time = $office_shift[0]->monday_in_time;
							$shift_out_time = $office_shift[0]->monday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}

					} else if ($day == 'Tuesday') {
						if (isset($office_shift[0]->tuesday_in_time) != '' && isset($office_shift[0]->tuesday_out_time) != '') {
							$shift_in_time = $office_shift[0]->tuesday_in_time;
							$shift_out_time = $office_shift[0]->tuesday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}

					} else if ($day == 'Wednesday') {
						if (isset($office_shift[0]->wednesday_in_time) != '' && isset($office_shift[0]->wednesday_out_time) != '') {
							$shift_in_time = $office_shift[0]->wednesday_in_time;
							$shift_out_time = $office_shift[0]->wednesday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}
					} else if ($day == 'Thursday') {
						if (isset($office_shift[0]->thursday_in_time) != '' && isset($office_shift[0]->thursday_out_time) != '') {
							$shift_in_time = $office_shift[0]->thursday_in_time;
							$shift_out_time = $office_shift[0]->thursday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}

					} else if ($day == 'Friday') {
						if (isset($office_shift[0]->friday_in_time) != '' && isset($office_shift[0]->friday_out_time) != '') {
							$shift_in_time = $office_shift[0]->friday_in_time;
							$shift_out_time = $office_shift[0]->friday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}

					} else if ($day == 'Saturday') {
						if (isset($office_shift[0]->saturday_in_time) != '' && isset($office_shift[0]->saturday_out_time) != '') {
							$shift_in_time = $office_shift[0]->saturday_in_time;
							$shift_out_time = $office_shift[0]->saturday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}

					} else if ($day == 'Sunday') {
						if (isset($office_shift[0]->sunday_in_time) != '' && isset($office_shift[0]->sunday_out_time) != '') {
							$shift_in_time = $office_shift[0]->sunday_in_time;
							$shift_out_time = $office_shift[0]->sunday_out_time;
							$in_time = $in_time_without_date;
							$out_time = $out_time_without_date;
							$late_in_grace_time = $office_shift[0]->late_allowed_till;
							$lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
						} else {
							$in_time = '00:00:00';
							$out_time = '00:00:00';
							$late_in_grace_time = '00:00:00';
							$lastout_firstin_diff = '00:00:00';
							$shift_in_time = '';
							$shift_out_time = '';
						}

					}


					$approved = 'No';

					$attendance_date_get = date("d-m-Y", strtotime($r->attendance_date));

					//clock in and out time get
					if ($in_time != '-') {
						$in_time = $this->Misc_model->time_24_to_12($in_time);
					}

					if ($out_time != '-' && !is_null($out_time)) {
						$out_time = $this->Misc_model->time_24_to_12($out_time);
					}

					//shift time get
					if ($shift_in_time == '') {
						$shift_in_time_get = 'Holiday';
					} else {
						$shift_in_time_get = date('h:i A', strtotime($shift_in_time));
					}

					if ($shift_out_time == '') {
						$shift_out_time_get = 'Holiday';
					} else {
						$shift_out_time_get = date('h:i A', strtotime($shift_out_time));
					}

					//daily attendance info data get
					$attendance_data = $this->Reports_model->get_early_leave_data($r->user_id, $att_date);
					if (!is_null($attendance_data)) {
						$work_data_get = $attendance_data[0]->work;
					} else {
						$work_data_get = '00:00';
					}


					$table .= "<tr>";

					$table .= "<td>" . $attendance_date_get . " " . $day . "</td>
							<td>" . $shift_name . "</td>
							<td>" . $shift_in_time_get . "</td>
							<td>" . $shift_out_time_get . "</td>
							<td>" . $late_in_grace_time . "</td>
							<td>" . $in_time . "</td>
							<td>" . $out_time . "</td>
							<td>" . $work_data_get . "</td>";

					$table .= "</tr>";

				}

			}

		}

		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}


	public function daily_punch_summary_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_date');
		$to_date = $this->input->post('p_to_date');


		$depart_main_id = $this->Reports_model->employee_daily_punch_summary_report($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);

		$depart_main_id_count = $this->Reports_model->employee_daily_punch_summary_report_count($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);

		//empty data display code start
		if (empty($depart_main_id_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($depart_main_id_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$depart_main_id_count[$key]['header_string'] = $email_phone_address;
			$depart_main_id_count[$key]['company_name'] = $company_name;
			$depart_main_id_count[$key]['logo'] = $logo;
		}


		foreach ($depart_main_id->result() as $value) {
			$data[] = array(
				"department_id" => $value->department_id,
				"user_id" => $value->user_id,
				"company_id" => $value->company_id
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['main_data'] = $data;
		$res['depart_main_id_count'] = $depart_main_id_count;
		$res['from_date'] = $from_date;
		$res['to_date'] = $to_date;
		$res['employee_id'] = $employee_id;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/daily_push_summary_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Daily_Push_Summary.pdf', 'D'); //


	}

	public function employee_daily_attendance_report()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = "Daily Attendance Sheet" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Daily Attendance Sheet";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_locations'] = $this->Xin_model->all_locations();
		$data['all_employees'] = $this->Xin_model->all_employees();
		//print_r($data);
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_daily_attendance_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_daily_attendance_report_result_old()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$depart_main_id = $this->Reports_model->employee_daily_attendance_report_result($company_id, $department_id, $employee_id, $location_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Daily Attendance Sheet Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_daily_attendance_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_daily_attendance_report_table'>
	                      <thead>
	                        <tr>
				                <th style='padding-right: 155px;'>Date</th>
				                <th style='padding-right: 180px;'>Shift Name</th>
				                <th>Shift Start</th>
				                <th>Shift End</th>
				                <th>Late In Grace Time</th>
				                <th>Day Type</th>
				                <th>Clock In</th>
				                <th>Clock Out</th>
				                <th>Late In (hh.mm)</th>
				                <th>Early Out (hh.mm)</th>
				                <th>Odd Punch (day)</th>
				                <th>Absent (day)</th>
				                <th>Shift Hours</th>
				                <th>Working Hours (hh.mm)</th>
				                <th>Original OT (hh.mm)</th>
                        	</tr>
        				  </thead>";

		foreach ($depart_main_id->result() as $depart_main_id_get) {

			$depart_id_data = $depart_main_id_get->department_id;
			$user_id_data = $depart_main_id_get->user_id;

			//get department
			$department_name = $this->Xin_model->read_department_info($depart_id_data);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
				$dept_code = $department_name[0]->department_code;
			} else {
				$dept_name = '--';
				$dept_code = '--';
			}

			if ($employee_id == 0) {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_employees.department_id = $depart_id_data Group by xin_attendance_time.employee_id";
				$emp_main_id = $this->db->query($sql_data);

			} else {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_employees.user_id IN($employee_id) Group by xin_attendance_time.employee_id";
				$emp_main_id = $this->db->query($sql_data);

			}


			$table .= "<tr style='background-color: #E0E0EB;'>
	        		  <td style='border-right-width: 0px;'><b>Department :</b></td>
	        		  <td style='border-right-width: 0px;'>" . $dept_name . "</td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        	  </tr>";


			foreach ($emp_main_id->result() as $emp_main_id_get) {


				$employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->user_id)[0];

				if (!empty($employee_info)) {
					$full_name_info = $employee_info->first_name . " " . $employee_info->last_name;
					$emp_code = $employee_info->employee_id;
					$emp_join_date = $employee_info->date_of_joining;
					$emp_depart_id = $employee_info->department_id;
				} else {
					$full_name_info = '--';
					$emp_code = '--';
					$emp_join_date = '--';
					$emp_depart_id = '0';
				}


				$table .= "<tr style='background-color: #E0E0EB;'>
	        		  <td style='border-right-width: 0px;'><b>Employee :</b></td>
	        		  <td style='border-right-width: 0px;'>[" . $emp_code . "] " . $full_name_info . "</td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  </tr>";

				$emp_main_id_data = $emp_main_id_get->user_id;


				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_attendance_time.employee_id = $emp_main_id_data Group by xin_attendance_time.employee_id";
				$employee = $this->db->query($sql_data);

				$late_total = array();
				$early_out_total = array();
				$odd_punch_total = array();
				$absent_total = array();
				$shift_hours_total = array();
				$work_total = array();
				$ot_total = array();

				if ($employee->num_rows() > 0) {
					foreach ($employee->result() as $r) {
						//get company
						$company = $this->Xin_model->read_company_info($r->company_id);
						if (!is_null($company)) {
							$comp_name = $company[0]->name;
						} else {
							$comp_name = '--';
						}

						$full_name = $r->first_name . ' ' . $r->last_name;

						$attendance_date = $this->Reports_model->get_all_attendance_date($r->user_id, $from_date, $to_date);

						foreach ($attendance_date as $att) {
							# code...
							foreach ($att as $date) {

								foreach ($date as $key) {

									$att_date = $key->attendance_date;
									//------------------

									$clkInLast = $clkOutLast = '-';

									$this->db->where('employee_id', $r->user_id);
									$this->db->where('attendance_date', $att_date);
									$this->db->order_by('time_attendance_id', 'asc');
									$attendance = $this->db->get('xin_attendance_time');

									if ($attendance->num_rows() > 0) {

										foreach ($attendance->result() as $att) {
											$clock_in = date("H:i", strtotime($att->clock_in));
											$clock_out = date("H:i", strtotime($att->clock_out));
											if ($clock_in != '0:00' && $clock_out != '0:00') {
												if ($clkInLast == '-')
													$clkInLast = $clock_in;

												$clkOutLast = $clock_out;
											}
										}
									}


									if ($clkInLast != '-') {
										$clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
									}
									if ($clkOutLast != '-' && !is_null($clkOutLast)) {
										$clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
									}

									//-----------------

									$clock_in = $clkInLast;
									$clock_out = $clkOutLast;

									$att_status = $key->attendance_status;

									$get_day = strtotime($att_date);
									$day = date('l', $get_day);

									$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

									$working_hours = $this->Reports_model->get_total_work_hours($r->user_id, $att_date);

									$odd_punch = $this->Reports_model->calculate_employee_odd_punch($r->user_id, $att_date);
									# code...
									if ($day == 'Monday') {
										if (isset($office_shift[0]->monday_in_time) != '') {
											$in_time = $office_shift[0]->monday_in_time;
											$out_time = $office_shift[0]->monday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Tuesday') {
										if (isset($office_shift[0]->tuesday_in_time) != '') {
											$in_time = $office_shift[0]->tuesday_in_time;
											$out_time = $office_shift[0]->tuesday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Wednesday') {
										if (isset($office_shift[0]->wednesday_in_time) != '') {
											$in_time = $office_shift[0]->wednesday_in_time;
											$out_time = $office_shift[0]->wednesday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Thursday') {
										if (isset($office_shift[0]->thursday_in_time) != '') {
											$in_time = $office_shift[0]->thursday_in_time;
											$out_time = $office_shift[0]->thursday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Friday') {
										if (isset($office_shift[0]->friday_in_time) != '') {
											$in_time = $office_shift[0]->friday_in_time;
											$out_time = $office_shift[0]->friday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Saturday') {
										if (isset($office_shift[0]->saturday_in_time) != '') {

											$in_time = $office_shift[0]->saturday_in_time;
											$out_time = $office_shift[0]->saturday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Sunday') {
										if (isset($office_shift[0]->sunday_in_time) != '') {

											$in_time = $office_shift[0]->sunday_in_time;
											$out_time = $office_shift[0]->sunday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '0';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									}

									$early_out_grace_time_min = '00:00';

									//daily attendance info data get
									$attendance_data = $this->Reports_model->get_early_leave_data($r->user_id, $att_date);
									if (!is_null($attendance_data)) {
										$early_leave_data_get = $attendance_data[0]->early_leaving;
										$late_data_get = $attendance_data[0]->late;
										$work_data_get = $attendance_data[0]->work;
										$ot_data_get = $attendance_data[0]->overtime;
									} else {
										$early_leave_data_get = '00:00';
										$late_data_get = '00:00';
										$work_data_get = '00:00';
										$ot_data_get = '00:00';
									}

									if ($att_status == 'Present') {
										if ($clock_out_data == '') {
											$odd_punch = 1;
										} else {
											$odd_punch = 0;
										}
										$absent_day = 0;
									} else {
										$odd_punch = 0;
										$absent_day = 1;
									}

									//employee wise total get
									$odd_punch_total[] = $odd_punch;
									$absent_total[] = $absent_day;
									$shift_hours_total[] = $shift_hours;

									$late_val = $late_data_get;
									$late_val_get = (explode(":", $late_val));
									$late_val_imp = $late_val_get;
									$late_val_final = implode(".", $late_val_imp);
									$late_total[] = $late_val_final;

									$early_val = $early_leave_data_get;
									$early_val_get = (explode(":", $early_val));
									$early_val_imp = $early_val_get;
									$early_val_final = implode(".", $early_val_imp);
									$early_out_total[] = $early_val_final;

									$work_val = $work_data_get;
									$work_val_get = (explode(":", $work_val));
									$work_val_imp = $work_val_get;
									$work_val_final = implode(".", $work_val_imp);
									$work_total[] = $work_val_final;

									$ot_val = $ot_data_get;
									$ot_val_get = (explode(":", $ot_val));
									$ot_val_imp = $ot_val_get;
									$ot_val_final = implode(".", $ot_val_imp);
									$ot_total[] = $ot_val_final;
									//employee wise total get end

									$attendance_date_get = date("d-m-Y", strtotime($att_date)) . ' (' . $day . ')';

									if ($in_time == '') {
										$shift_in_time = 'Holiday';
									} else {
										$shift_in_time = date('h:i A', strtotime($in_time));
									}

									if ($out_time == '') {
										$shift_out_time = 'Holiday';
									} else {
										$shift_out_time = date('h:i A', strtotime($out_time));
									}


									$table .= "<tr>";

									$table .= "<td>" . $attendance_date_get . "</td>
									  <td>" . $shift_name . "</td>
									  <td>" . $shift_in_time . "</td>
									  <td>" . $shift_out_time . "</td>
									  <td>" . $late_in_grace_time_min . "</td>
									  <td>" . $att_status . "</td>
									  <td>" . $clock_in_data . "</td>
									  <td>" . $clock_out_data . "</td>
									  <td>" . $late_data_get . "</td>
									  <td>" . $early_leave_data_get . "</td>
									  <td>" . $odd_punch . "</td>
									  <td>" . $absent_day . "</td>
									  <td>" . $shift_hours . " Hours</td>
									  <td>" . $work_data_get . "</td>
									  <td>" . $ot_data_get . "</td>";

									$table .= "</tr>";
								}
							}
						}
					}

				}
				$table .= "<tr>";

				$table .= "<td style='border-right-width: 0px;'><b>Employee Wise Total :</b></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($late_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($early_out_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($odd_punch_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($absent_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($shift_hours_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($work_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($ot_total) . "</b></td>";

				$table .= "</tr>";
			}
		}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function daily_attendance_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_date');
		$to_date = $this->input->post('p_to_date');


		$depart_main_id = $this->Reports_model->employee_daily_attendance_report_result($company_id, $department_id, $employee_id, $location_id, $from_date, $to_date);

		$depart_main_id_count = $this->Reports_model->employee_daily_attendance_report_result_count($company_id, $department_id, $employee_id, $location_id, $from_date, $to_date);

//empty data display code start
		if (empty($depart_main_id_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($depart_main_id_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$depart_main_id_count[$key]['header_string'] = $email_phone_address;
			$depart_main_id_count[$key]['company_name'] = $company_name;
			$depart_main_id_count[$key]['logo'] = $logo;
		}


		foreach ($depart_main_id->result() as $value) {
			$data[] = array(
				"department_id" => $value->department_id,
				"user_id" => $value->user_id,
				"company_id" => $value->company_id,
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['main_data'] = $data;
		$res['depart_main_id_count'] = $depart_main_id_count;
		$res['from_date'] = $from_date;
		$res['to_date'] = $to_date;
		$res['employee_id'] = $employee_id;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/daily_attendance_sheet_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Daily_Attendance_Sheet.pdf', 'D'); //


	}

	public function employee_late_in_request_status()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Employee Late In Request Status' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Employee Late In Request Status';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();

		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_late_in_request_status", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_late_in_request_status_report_old()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$depart_id = $this->Reports_model->employee_late_in_request_status_report($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Late in Request Status Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_late_in_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_late_in_report'>
	                      <thead>
	                        <tr>
	                            <th style='padding-right: 120px;'>Employee ID</th>
	                            <th>Company</th>
				                <th>Employee Name</th>
				                <th>Date</th>
				                <th>Clock IN Time</th>
				                <th>Shift IN Time</th>
				                <th>Late IN Time (hh:mm)</th>
				                <th>Applied</th></tr></thead>";

		foreach ($depart_id->result() as $depart_id_main) {


			//department wise early out condition check

			$leave1 = $this->Reports_model->check_employee_leave($depart_id_main->user_id, $depart_id_main->attendance_date);
			if ($leave1 != '') {
				continue;
			}

			//------------------day wise clock in and clock out start

			$clkInLast1 = $clkOutLast1 = '-';

			$this->db->where('employee_id', $depart_id_main->user_id);
			$this->db->where('attendance_date', $depart_id_main->attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {

				foreach ($attendance->result() as $att1) {
					$clock_in1 = date("H:i", strtotime($att1->clock_in));
					$clock_out1 = date("H:i", strtotime($att1->clock_out));
					if ($clock_in1 != '0:00' && $clock_out1 != '0:00') {
						if ($clkInLast1 == '-')
							$clkInLast1 = $clock_in1;

						$clkOutLast1 = $clock_out1;
					}
				}
			}


			//-----------------day wise clock in and clock out end


			$in_time_without_date1 = $clkInLast1;

			$att_date1 = $depart_id_main->attendance_date;
			$get_day1 = strtotime($att_date1);
			$day1 = date('l', $get_day1);

			$office_shift1 = $this->Reports_model->read_employee_office_shift($depart_id_main->office_shift_id);


			if ($day1 == 'Monday') {
				if (isset($office_shift1[0]->monday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->monday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Tuesday') {
				if (isset($office_shift1[0]->tuesday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->tuesday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Wednesday') {
				if (isset($office_shift1[0]->wednesday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->tuesday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Thursday') {
				if (isset($office_shift1[0]->thursday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->thursday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Friday') {
				if (isset($office_shift1[0]->friday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->friday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}
				}
			} else if ($day1 == 'Saturday') {
				if (isset($office_shift1[0]->saturday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->saturday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}


				}
			} else if ($day1 == 'Sunday') {
				if (isset($office_shift1[0]->sunday_in_time) != '') {

					$shift_in_time1 = $office_shift1[0]->sunday_in_time;
					if ($shift_in_time1 >= $in_time_without_date1) {
						# code...
						continue;
					}


				}
			}


			//department wise early out condition check end


			$depart_main_id_data = $depart_id_main->department_id;
			$user_id_data = $depart_id_main->user_id;

			//get department
			$department = $this->Department_model->read_department_information($depart_main_id_data);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}


			$table .= "<tr style='background-color: #E0E0EB;'>
					  <th style='border-right-width: 0px;'>Department : " . $department_name . "</th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th></tr>";

			if ($employee_id == 0) {

				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_main_id_data GROUP BY xin_attendance_time.attendance_date";

				$employee = $this->db->query($sql_data);

			} else {

				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.user_id = $user_id_data GROUP BY xin_attendance_time.attendance_date";

				$employee = $this->db->query($sql_data);

			}

			foreach ($employee->result() as $r) {
				# code...
				//get company
				$leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
				if ($leave != '') {
					# code...
					continue;
				}
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$full_name = $r->first_name . ' ' . $r->last_name;

				//------------------day wise clock in and clock out start

				$clkInLast = $clkOutLast = '-';

				$this->db->where('employee_id', $r->user_id);
				$this->db->where('attendance_date', $r->attendance_date);
				$this->db->order_by('time_attendance_id', 'asc');
				$attendance = $this->db->get('xin_attendance_time');

				if ($attendance->num_rows() > 0) {

					foreach ($attendance->result() as $att) {
						$clock_in = date("H:i", strtotime($att->clock_in));
						$clock_out = date("H:i", strtotime($att->clock_out));
						if ($clock_in != '0:00' && $clock_out != '0:00') {
							if ($clkInLast == '-')
								$clkInLast = $clock_in;

							$clkOutLast = $clock_out;
						}
					}
				}

				//-----------------day wise clock in and clock out end


				$in_time_without_date = $clkInLast;

				$att_date = $r->attendance_date;
				$get_day = strtotime($att_date);
				$day = date('l', $get_day);

				$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

				//$shift_in_time == '';

				if ($day == 'Monday') {
					if (isset($office_shift[0]->monday_in_time) != '') {

						$shift_in_time = $office_shift[0]->monday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				} else if ($day == 'Tuesday') {
					if (isset($office_shift[0]->tuesday_in_time) != '') {
						$shift_in_time = $office_shift[0]->tuesday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				} else if ($day == 'Wednesday') {
					if (isset($office_shift[0]->wednesday_in_time) != '') {
						$shift_in_time = $office_shift[0]->wednesday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				} else if ($day == 'Thursday') {
					if (isset($office_shift[0]->thursday_in_time) != '') {
						$shift_in_time = $office_shift[0]->thursday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				} else if ($day == 'Friday') {
					if (isset($office_shift[0]->friday_in_time) != '') {
						$shift_in_time = $office_shift[0]->friday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				} else if ($day == 'Saturday') {
					if (isset($office_shift[0]->saturday_in_time) != '') {
						$shift_in_time = $office_shift[0]->saturday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;

					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				} else if ($day == 'Sunday') {
					if (isset($office_shift[0]->sunday_in_time) != '') {
						$shift_in_time = $office_shift[0]->sunday_in_time;
						if ($shift_in_time >= $in_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;

					} else {
						$in_time = '00:00:00';
						$shift_in_time = '';
					}
				}

				$applied = 'No';

				$attendance_date_get = date("d-m-Y", strtotime($r->attendance_date));

				//get employee info
				$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];

				if (!empty($employee_info)) {
					$emp_code = $employee_info->employee_id;
				} else {
					$emp_code = '--';
				}

				if ($in_time != '-') {
					$in_time = $this->Misc_model->time_24_to_12($in_time);
				}

				$late_data = $this->Reports_model->get_early_leave_data($r->user_id, $r->attendance_date);
				if (!is_null($late_data)) {
					$late_data_get = $late_data[0]->late;
				} else {
					$late_data_get = '00:00';
				}


				//shift in time get
				if ($shift_in_time == '') {
					$shift_in_time_get = 'Office Shift Is Not Assigned';
				} else {
					$shift_in_time_get = date('h:i A', strtotime($shift_in_time));
				}


				if ($shift_in_time != '') {
					$table .= "<tr>";

					$table .= "<td>" . $emp_code . "</td>
    				      			<td>" . $comp_name . "</td>
    								<td>" . $full_name . "</td>
    								<td>" . $attendance_date_get . " (" . $day . ")</td>
    								<td>" . $in_time . "</td>
    								<td>" . $shift_in_time_get . "</td>
    								<td>" . $late_data_get . "</td>
    								<td>" . $applied . "</td>";

					$table .= "</tr>";
				}

			}

		}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function late_request_status_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_date');
		$to_date = $this->input->post('p_to_date');


		if (!empty($company_id)) {
			$title_company_id = $company_id;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------


		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['company_id'] = $company_id;
		$res['department_id'] = $department_id;
		$res['location_id'] = $location_id;
		$res['employee_id'] = $employee_id;
		$res['from_date'] = $from_date;
		$res['to_date'] = $to_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/late_in_request_status_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Late_In_Request_Status.pdf', 'D');
	}


	public function employee_early_out_request_status()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Employees Early out Request Status Report' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Employees Early out Request Status Report';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();

		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/employee_early_out_request_status", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_early_out_request_status_report_old()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$emp_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$depart_id = $this->Reports_model->employee_early_out_request_status_get($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Employees Early out Request Status Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_early_out_request_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_early_out_request_table'>
	                      <thead>
	                        <tr>
	                            <th style='padding-right: 200px;'>Employee ID</th>
				                <th>Employee Name</th>
				                <th>Attendance Date</th>
				                <th>Clock OUT Time</th>
				                <th>Shift OUT Time</th>
				                <th>Early OUT Time (hh:mm)</th>
        						<th>Approved</th></tr></thead>";


		foreach ($depart_id->result() as $depart_id_main) {

			//department wise early out condition check

			$leave1 = $this->Reports_model->check_employee_leave($depart_id_main->user_id, $depart_id_main->attendance_date);
			if ($leave1 != '') {
				continue;
			}


			//------------------day wise clock in and clock out start

			$clkInLast1 = $clkOutLast1 = '-';

			$this->db->where('employee_id', $depart_id_main->user_id);
			$this->db->where('attendance_date', $depart_id_main->attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {

				foreach ($attendance->result() as $att1) {
					$clock_in1 = date("H:i", strtotime($att1->clock_in));
					$clock_out1 = date("H:i", strtotime($att1->clock_out));
					if ($clock_in1 != '0:00' && $clock_out1 != '0:00') {
						if ($clkInLast1 == '-')
							$clkInLast1 = $clock_in1;

						$clkOutLast1 = $clock_out1;
					}
				}
			}


			//-----------------day wise clock in and clock out end


			$in_time_without_date1 = $clkInLast1;
			$out_time_without_date1 = $clkOutLast1;

			$att_date1 = $depart_id_main->attendance_date;
			$get_day1 = strtotime($att_date1);
			$day1 = date('l', $get_day1);

			$office_shift1 = $this->Reports_model->read_employee_office_shift($depart_id_main->office_shift_id);

			if ($day1 == 'Monday') {
				if (isset($office_shift1[0]->monday_out_time) != '') {

					$shift_out_time1 = $office_shift1[0]->monday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Tuesday') {
				if (isset($office_shift1[0]->tuesday_out_time) != '') {
					$shift_out_time1 = $office_shift1[0]->tuesday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Wednesday') {
				if (isset($office_shift1[0]->wednesday_out_time) != '') {
					$shift_out_time1 = $office_shift1[0]->wednesday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Thursday') {
				if (isset($office_shift1[0]->thursday_out_time) != '') {
					$shift_out_time1 = $office_shift1[0]->thursday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Friday') {
				if (isset($office_shift1[0]->friday_out_time) != '') {
					$shift_out_time1 = $office_shift1[0]->friday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if ($day1 == 'Saturday') {
				if (isset($office_shift1[0]->saturday_out_time) != '') {
					$shift_out_time1 = $office_shift1[0]->saturday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}


				}
			} else if ($day1 == 'Sunday') {
				if (isset($office_shift1[0]->sunday_out_time) != '') {
					$shift_out_time1 = $office_shift1[0]->sunday_out_time;
					if ($shift_out_time1 <= $out_time_without_date1) {
						# code...
						continue;
					}


				}
			}


			//department wise early out condition check end


			$depart_main_id_data = $depart_id_main->department_id;
			$user_id_data = $depart_id_main->user_id;

			//get department
			$department = $this->Department_model->read_department_information($depart_main_id_data);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}


			$table .= "<tr style='background-color: #E0E0EB;'><th>Department Name: " . $department_name . "</th>
					  <th></th>
					  <th></th>
					  <th></th>
					  <th></th>
					  <th></th>
					  <th></th></tr>";

			if ($emp_id == 0) {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_main_id_data";

				$employee = $this->db->query($sql_data);

			} else {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.user_id = $user_id_data";

				$employee = $this->db->query($sql_data);

			}


			foreach ($employee->result() as $r) {

				//get company
				$leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
				if ($leave != '') {
					# code...
					continue;
				}

				$full_name = $r->first_name . ' ' . $r->last_name;

				//------------------day wise clock in and clock out start

				$clkInLast = $clkOutLast = '-';

				$this->db->where('employee_id', $r->user_id);
				$this->db->where('attendance_date', $r->attendance_date);
				$this->db->order_by('time_attendance_id', 'asc');
				$attendance = $this->db->get('xin_attendance_time');

				if ($attendance->num_rows() > 0) {

					foreach ($attendance->result() as $att) {
						$clock_in = date("H:i", strtotime($att->clock_in));
						$clock_out = date("H:i", strtotime($att->clock_out));
						if ($clock_in != '0:00' && $clock_out != '0:00') {
							if ($clkInLast == '-')
								$clkInLast = $clock_in;

							$clkOutLast = $clock_out;
						}
					}
				}

				//-----------------day wise clock in and clock out end


				$in_time_without_date = $clkInLast;
				$out_time_without_date = $clkOutLast;

				$att_date = $r->attendance_date;
				$get_day = strtotime($att_date);
				$day = date('l', $get_day);

				$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

				if ($day == 'Monday') {
					if (isset($office_shift[0]->monday_out_time) != '') {

						$shift_out_time = $office_shift[0]->monday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;
					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				} else if ($day == 'Tuesday') {
					if (isset($office_shift[0]->tuesday_out_time) != '') {
						$shift_out_time = $office_shift[0]->tuesday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;

					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				} else if ($day == 'Wednesday') {
					if (isset($office_shift[0]->wednesday_out_time) != '') {
						$shift_out_time = $office_shift[0]->wednesday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;
					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				} else if ($day == 'Thursday') {
					if (isset($office_shift[0]->thursday_out_time) != '') {
						$shift_out_time = $office_shift[0]->thursday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;
					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				} else if ($day == 'Friday') {
					if (isset($office_shift[0]->friday_out_time) != '') {
						$shift_out_time = $office_shift[0]->friday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;
					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				} else if ($day == 'Saturday') {
					if (isset($office_shift[0]->saturday_out_time) != '') {
						$shift_out_time = $office_shift[0]->saturday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;

					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				} else if ($day == 'Sunday') {
					if (isset($office_shift[0]->sunday_out_time) != '') {
						$shift_out_time = $office_shift[0]->sunday_out_time;
						if ($shift_out_time <= $out_time_without_date) {
							# code...
							continue;
						}
						$in_time = $in_time_without_date;
						$out_time = $out_time_without_date;

					} else {
						$in_time = '00:00:00';
						$out_time = '00:00:00';
						$shift_out_time = '';
					}
				}

				$approved = 'No';

				$attendance_date_get = date("d-m-Y", strtotime($r->attendance_date));


				if ($out_time != '-' && !is_null($out_time)) {
					$out_time = $this->Misc_model->time_24_to_12($out_time);
				}


				$early_leave_data = $this->Reports_model->get_early_leave_data($r->user_id, $r->attendance_date);
				if (!is_null($early_leave_data)) {
					$early_leave_data_get = $early_leave_data[0]->early_leaving;
				} else {
					$early_leave_data_get = '00:00';
				}

				//get shift out time
				if ($shift_out_time == '') {
					$shift_out_time_get = 'Office Shift Is Not Assigned';
				} else {
					$shift_out_time_get = date('h:i A', strtotime($shift_out_time));
				}


				$table .= "<tr>";

				$table .= "<td>" . $r->employee_id . "</td>
	        		<td>" . $full_name . "</td>
	        		<td>" . $attendance_date_get . " (" . $day . ")</td>
	        		<td>" . $out_time . "</td>
	        		<td>" . $shift_out_time_get . "</td>
	        		<td>" . $early_leave_data_get . "</td>
	        		<td>" . $approved . "</td>";

				$table .= "</tr>";

			}
		}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function employee_early_out_request_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user = $this->Xin_model->read_user_info($session['user_id']);

		$aj_company = $this->input->post('p_company_id');
		$aj_department = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$emp_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_date');
		$to_date = $this->input->post('p_to_date');


		if (!empty($aj_company)) {
			$title_company_id = $aj_company;
		} else {
			$title_company_id = $user[0]->company_id;
		}


		$company = $this->Xin_model->read_company_info($title_company_id);
		$system = $this->Xin_model->read_setting_info(1);

		$p_method = '';
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//  echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		//--------------------


		//-------------------


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);

		$res['aj_company'] = $aj_company;
		$res['aj_department'] = $aj_department;
		$res['location_id'] = $location_id;
		$res['emp_id'] = $emp_id;
		$res['from_date'] = $from_date;
		$res['to_date'] = $to_date;
		$res['header_string'] = $email_phone_address;
		$res['company_name'] = $company_name;
		$res['logo'] = $logo;
		$html = $this->load->view("admin/reports/early_out_request_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Early_Out_Request.pdf', 'D');
	}


	public function starting_checkin_checkout_report()
	{

		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = "Check In Check Out Report" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Check In Check Out Report";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/employee_starting_checkin_checkout_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');

		}

	}

	public function employee_starting_checkin_checkout_report()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$emp_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$employee_checkin_checkout = $this->Reports_model->employee_starting_checkin_checkout_report($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date);

		$data = array();


		foreach ($employee_checkin_checkout->result() as $get) {

			// user full name
			$full_name = $get->first_name . ' ' . $get->last_name;

			//get department
			$department_name = $this->Xin_model->read_department_info($get->department_id);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
			} else {
				$dept_name = '--';
			}

			$attendance_date = $get->attendance_date;

			$get_day = strtotime($attendance_date);
			$day = date('l', $get_day);

			$attendance_date_get = date("d-m-Y", strtotime($attendance_date));

			if (!is_null($get->clock_in_time)) {
				$time1 = $get->clock_in_time;
				$check_in_get = date('h:i A', strtotime($time1));
			} else {
				$check_in_get = '--';
			}

			if (!is_null($get->clock_out_time)) {
				$time2 = $get->clock_out_time;
				$check_out_get = date('h:i A', strtotime($time2));
			} else {
				$check_out_get = '--';
			}


			$data[] = array(
				$get->employee_id,
				$full_name,
				$dept_name,
				$attendance_date_get . ' ' . '(' . $day . ')',
				$check_in_get,
				$check_out_get
			);

		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee_checkin_checkout->num_rows(),
			"recordsFiltered" => $employee_checkin_checkout->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	public function employee_starting_checkin_checkout_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$aj_company = $this->input->post('p_company_id');
		$aj_department = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$emp_id = $this->input->post('p_employee_id');
		$from_date = $this->input->post('p_from_year');
		$to_date = $this->input->post('p_to_year');


		$employee_checkin_checkout = $this->Reports_model->employee_starting_checkin_checkout_report($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date);

		$employee_checkin_checkout_count = $this->Reports_model->employee_starting_checkin_checkout_report_count($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date);

		//empty data display code start
		if (empty($employee_checkin_checkout_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($employee_checkin_checkout_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);


			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_checkin_checkout_count[$key]['header_string'] = $email_phone_address;
			$employee_checkin_checkout_count[$key]['company_name'] = $company_name;
			$employee_checkin_checkout_count[$key]['logo'] = $logo;
		}


		foreach ($employee_checkin_checkout->result() as $get) {

			// user full name
			$full_name = $get->first_name . ' ' . $get->last_name;

			//get department
			$department_name = $this->Xin_model->read_department_info($get->department_id);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
			} else {
				$dept_name = '--';
			}

			$attendance_date = $get->attendance_date;

			$get_day = strtotime($attendance_date);
			$day = date('l', $get_day);

			$attendance_date_get = date("d-m-Y", strtotime($attendance_date));

			if (!is_null($get->clock_in_time)) {
				$time1 = $get->clock_in_time;
				$check_in_get = date('h:i A', strtotime($time1));
			} else {
				$check_in_get = '--';
			}

			if (!is_null($get->clock_out_time)) {
				$time2 = $get->clock_out_time;
				$check_out_get = date('h:i A', strtotime($time2));
			} else {
				$check_out_get = '--';
			}


			$data[] = array(
				"employee_id" => $get->employee_id,
				"full_name" => $full_name,
				"dept_name" => $dept_name,
				"attendance_date_get" => $attendance_date_get . ' ' . '(' . $day . ')',
				"check_in_get" => $check_in_get,
				"check_out_get" => $check_out_get,
				"company_id" => $get->company_id
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$res['employee_checkin_checkout_count'] = $employee_checkin_checkout_count;
		$res['from_date'] = $from_date;
		$res['to_date'] = $to_date;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/checkin_checkout_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Check_IN_and_Check_Out.pdf', 'D'); //


	}

	public function salary_progression_history()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {

			redirect('admin/');

		}

		$data['title'] = "Salary Progression History" . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = "Salary Progression History";
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_location'] = $this->Location_model->all_office_locations();

		if (!empty($session)) {

			$data['subview'] = $this->load->view("admin/reports/salary_progression_history_page", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load

		} else {

			redirect('admin/dashboard/');

		}
	}

	public function salary_progression_history_get()
	{


		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$paysheet_employee_id = $_GET['paysheet_employee_id'];
		$year = $_GET['from_year'];

		$emp_main_id = $this->Reports_model->salary_progression_history_report($aj_company, $aj_department, $location_id, $paysheet_employee_id, $year);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Salary Setup History Report</strong></span>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='salary_progression_history_report_datatable'>
                <table class='datatables-demo table table-striped table-bordered' id='salary_progression_history_table'>";


		$table .= "<thead><tr>

                <th style='padding-right: 90px;'>Progression Date</th>
                <th style='padding-right: 165px;'>Position</th>
                <th style='padding-right: 120px;'>Current Basic Salary</th>
                <th style='padding-right: 107px;'>Basic salary (Progress)</th>";
		$sql = "SELECT * FROM `allowance` WHERE type_id IN (1)";
		$allowances = $this->db->query($sql);

		foreach ($allowances->result() as $allowance) {
			$table .= "<th>" . $allowance->name . " (Progress)</th>";
		}

		$table .= "<th>Total Amount</th></tr></thead>";

		foreach ($emp_main_id->result() as $emp_main_id_get) {

			$employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->employee_id)[0];

			if (!empty($employee_info)) {
				$full_name_info = $employee_info->first_name . " " . $employee_info->last_name;
				$emp_code = $employee_info->employee_id;
				$emp_join_date = $employee_info->date_of_joining;
				$emp_depart_id = $employee_info->department_id;
			} else {
				$full_name_info = '--';
				$emp_code = '--';
				$emp_join_date = '--';
				$emp_depart_id = '0';
			}

			//get department
			$department_name = $this->Xin_model->read_department_info($emp_depart_id);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
			} else {
				$dept_name = '--';
			}


			$emp_main_id_data = $emp_main_id_get->employee_id;

			$this->db->where('type_id', 1);
			// $this->db->or_where('type_id',2);
			$allowance_count = $this->db->get('allowance');

			$table .= "<tr style='background-color: rgb(245, 203, 167);'><th>Employee Code: " . $emp_code . "</th>
                         <th>Employee Name: " . $full_name_info . "</th>
                         <th>Current Position: " . $dept_name . "</th>
                         <th>Joining Date: " . $emp_join_date . "</th>";

			foreach ($allowance_count->result() as $allowance_count_data) {
				$table .= "<th></th>";
			}

			$table .= "<th></th></tr>";

			/* $sql_row_data = "SELECT * FROM `xin_employee_salary_history` WHERE
                EXTRACT(YEAR FROM xin_employee_salary_history.date)='$year' AND inc_amt > 0 AND inc_or_dec != '' and employee_id = $emp_main_id_data";
           $progresses_row = $this->db->query($sql_row_data);
           $allowance_row_count = count($progresses_row->result());
           $allowance_row_count_get = $allowance_row_count;

          if($allowance_row_count_get == 1){
				$style = '';
          }else{
				$style = $allowance_row_count_get.'%';
          }

      $employee_rowspan_data="<tr>
      <th style='background-color: rgb(245, 203, 167); padding-top: ".$style.";' rowspan='".$allowance_row_count_get."' >".$emp_code."</th>
      <th style='background-color: rgb(245, 203, 167); padding-top: ".$style.";' rowspan='".$allowance_row_count_get."' >".$full_name_info."</th>
      <th style='background-color: rgb(245, 203, 167); padding-top: ".$style.";' rowspan='".$allowance_row_count_get."' >".$dept_name."</th>
      <th style='background-color: rgb(245, 203, 167); padding-top: ".$style.";' rowspan='".$allowance_row_count_get."' >".$emp_join_date."</th>"; */


			$sql_data = "SELECT * FROM `xin_employee_salary_history` WHERE
                EXTRACT(YEAR FROM xin_employee_salary_history.date)='$year' AND inc_amt > 0 AND inc_or_dec = 'inc' and employee_id = $emp_main_id_data";
			$progresses = $this->db->query($sql_data);

			//$table.="<tbody>";

			foreach ($progresses->result() as $key => $progress) {


				//   if($key == 0){
				//   	$table.= $employee_rowspan_data;
				//   } else{
				//   	$table.= "<tr>";
				//   }

				$table .= "<tr>";
				$table .= "<td>" . $progress->date . "</td>";

				$employee = $this->Xin_model->read_employee_info($progress->employee_id)[0];

				if (!empty($employee)) {
					$emp_basic_salary = $employee->basic_salary;
				} else {
					$emp_basic_salary = '0';
				}

				$table .= "<td>" . $dept_name . "</td>";

				$basic_salary = '';

				$basic_salary = number_format((float)$emp_basic_salary, 2, '.', '');

				$table .= "<td>" . $basic_salary . "</td>";

				$basic_salary_progress = '';

				if ($progress->history_type == 1) {
					if ($progress->inc_or_dec == 'inc') {
						$basic_salary_progress = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
						$p_amt_basic = $progress->inc_amt;
					}
					//   else if ($progress->inc_or_dec == 'dec')
					//   {
					//       $basic_salary_progress = '<span class="text-nowrap">'.$progress->amount.' ('.$progress->inc_amt . ' &#8595;)</span>';
					//       $p_amt_basic = '0';
					//   }
				}

				if ($basic_salary_progress != '') {
					$basic_salary_progress_data = $basic_salary_progress;
				} else {
					$basic_salary_progress_data = 0;
				}

				$table .= "<td>" . $basic_salary_progress_data . "</td>";

				foreach ($allowances->result() as $allowance) {
					if ($progress->history_type == 2) {
						$this->db->where('allowance_id', $progress->allowance_id);
						$salary_allowance = $this->db->get('xin_salary_allowances')->row();

						if ($salary_allowance) {
							if ($allowance->id == $salary_allowance->allowance_title) {
								if ($progress->inc_or_dec == 'inc') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
									$p_amt_allowance = $progress->amount;
								} else if ($progress->inc_or_dec == 'dec') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
									$p_amt_allowance = '0';
								}

							} else {
								$allowance_amount = '0';
							}
						}
					} else {
						$allowance_amount = '0';
					}

					$table .= "<td>" . $allowance_amount . "</td>";

				}

				if ($progress->history_type == 1) {
					// $final_total = $basic_salary + $p_amt_basic;
					$final_total = $basic_salary;
				}

				if ($progress->history_type == 2) {
					$final_total = $basic_salary + $p_amt_allowance;
				}

				$table .= "<td>" . $final_total . "</td>";

				$table .= "</tr>";

			}

		}


		$table .= "</tbody>
                 </table>
                 </div>
                 </div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();

	}


//rahul new dev

	public function salary_progression_history_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$aj_company = $this->input->post('p_company_id');
		$aj_department = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$paysheet_employee_id = $this->input->post('p_employee_id');
		$year = $this->input->post('p_year');

		$emp_main_id = $this->Reports_model->salary_progression_history_report($aj_company, $aj_department, $location_id, $paysheet_employee_id, $year);

		$emp_main_id_count = $this->Reports_model->salary_progression_history_report_count($aj_company, $aj_department, $location_id, $paysheet_employee_id, $year);

		//empty data display code start
		if (empty($emp_main_id_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($emp_main_id_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$emp_main_id_count[$key]['header_string'] = $email_phone_address;
			$emp_main_id_count[$key]['company_name'] = $company_name;
			$emp_main_id_count[$key]['logo'] = $logo;
		}


		foreach ($emp_main_id->result() as $value) {
			$data[] = array(
				"employee_id" => $value->employee_id,
				"company_id" => $value->company_id
			);
		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['emp_main_id'] = $data;
		$res['emp_main_id_count'] = $emp_main_id_count;
		$res['year'] = $year;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/salary_progression_history_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Salary_Progression_History.pdf', 'D'); //


	}

	public function salary_progression_latest()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = 'Employee Salary Latest Progression' . ' | ' . $this->Xin_model->site_title();
		$data['path_url'] = 'reports_employees';
		$data['breadcrumbs'] = 'Employee Salary Latest Progression';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_leaves'] = $this->Department_model->all_leaves();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->all_locations();
		//print_r($data['all_locations']);exit();
		if ($data) {
			$data['subview'] = $this->load->view("admin/reports/salary_progression_latest", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function salary_progression_latest_report()
	{
		//print_r('hi');exit();
		error_reporting(E_ALL);
		ini_set("display_errors", "On");


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$year = $_GET['year'];


		$depart_id = $this->Reports_model->salary_latest_progression_history_report($company_id, $employee_id, $department_id, $location_id, $year);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Employee Latest Salary Progression Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='report_latest_salary_progress_his'>
					<table class='datatables-demo table table-striped table-bordered' id='salary_latest_progress_his'>
	                      <thead>
	                        <tr>
	                            <th style='padding-right: 120px;'>Department</th>
				                <th>Employee Code</th>
				                <th>Employee Name</th>
				                <th>Current Position</th>
				                <th>Joining Date</th>
				                <th>Progression Date</th>
				                <th>Current Basic Salary</th>
				                <th>Basic Salary (Progress)</th>";
		$sql = "SELECT * FROM `allowance` WHERE type_id IN (1)";
		$allowances = $this->db->query($sql);

		foreach ($allowances->result() as $allowance) {
			$table .= "<th>" . $allowance->name . " (Progress)</th>";
		}

		$table .= "<th>Total Amount</th></tr></thead>";

		foreach ($depart_id->result() as $depart_id_main) {
			$depart_main_id_data = $depart_id_main->department_id;


			$emp_data = $depart_id_main->user_id;

			//get department
			$department_name = $this->Xin_model->read_department_info($depart_main_id_data);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
			} else {
				$dept_name = '--';
			}
			$total_sum = array();
			foreach ($allowances->result() as $allowance) {
				$total_sum[$allowance->id] = 0;
			}

			if ($employee_id == '') {

				$sql_data = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.amount, xin_employee_salary_history.inc_amt, xin_employee_salary_history.date, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.inc_or_dec, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employees.basic_salary from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employees.user_id != 1 and xin_employees.department_id = $depart_main_id_data";

				$progresses = $this->db->query($sql_data);

				$sql_data123 = "SELECT xin_employee_salary_history.allowance_id from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employees.department_id = $depart_main_id_data and  xin_employee_salary_history.inc_or_dec = 'inc' and xin_employee_salary_history.history_type = 2 GROUP BY xin_employee_salary_history.allowance_id";

				$progresses_allowance_data = $this->db->query($sql_data123);

			} else {

				$sql_data = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.amount, xin_employee_salary_history.inc_amt, xin_employee_salary_history.date, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.inc_or_dec, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employees.basic_salary from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employees.user_id = $emp_data";

				$progresses = $this->db->query($sql_data);

				$sql_data123 = "SELECT xin_employee_salary_history.allowance_id from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employees.user_id = $emp_data and  xin_employee_salary_history.inc_or_dec = 'inc' and xin_employee_salary_history.history_type = 2 GROUP BY xin_employee_salary_history.allowance_id";

				$progresses_allowance_data = $this->db->query($sql_data123);

			}


			$data = array();

			$final_amt = array();
			foreach ($progresses->result() as $progress) {
				$department_name = $this->Xin_model->read_department_info($progress->department_id);
				if (!is_null($department_name)) {
					$dept_name_pro = $department_name[0]->department_name;
				} else {
					$dept_name_pro = '--';
				}


				//employee info get
				$employee_info = $this->Xin_model->read_employee_info($progress->employee_id)[0];
				if (!empty($employee_info)) {
					$emp_code = $employee_info->employee_id;
				} else {
					$emp_code = '--';
				}

				$full_name_info = $progress->first_name . " " . $progress->last_name;

				// get designation
				$designation = $this->Designation_model->read_designation_information($progress->designation_id);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}


				$table .= "<tr>";

				$table .= "<td>" . $dept_name_pro . "</td>
	        			<td>" . $emp_code . "</td>
	        			<td>" . $full_name_info . "</td>
	        			<td>" . $designation_name . "</td>
	        			<td>" . $progress->date_of_joining . "</td>
	        			<td>" . $progress->date . "</td>";

				$basic_salary = 0;
				$basic_salary = number_format((float)$progress->basic_salary, 2, '.', '');

				$table .= "<td>" . $basic_salary . "</td>";


				$basic_salary_progress = '';

				if ($progress->history_type == 1) {
					if ($progress->inc_or_dec == 'inc') {
						$basic_salary_progress = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
						$p_amt_basic = $progress->inc_amt;
					} else if ($progress->inc_or_dec == 'dec') {
						$basic_salary_progress = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
						$p_amt_basic = '0';
					}
				}

				$table .= "<td>" . $basic_salary_progress . "</td>";

				foreach ($allowances->result() as $allowance) {
					if ($progress->history_type == 2) {
						$this->db->where('allowance_id', $progress->allowance_id);
						$salary_allowance = $this->db->get('xin_salary_allowances')->row();
						if ($salary_allowance) {
							if ($allowance->id == $salary_allowance->allowance_title) {

								if ($progress->inc_or_dec == 'inc') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;)</span>';
									$p_amt_allowance = $progress->amount;
									$p_amt_allowance1[] = $progress->amount;
									$total_sum[$allowance->id] += $progress->amount;
								} else if ($progress->inc_or_dec == 'dec') {
									$allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
									$p_amt_allowance = '0';
									$p_amt_allowance1[] = '0';
								}
							} else {
								$allowance_amount = 0;
							}
						}
					} else {
						$allowance_amount = 0;
						$total_sum[$allowance->id] += 0;
					}


					$table .= "<td>" . $allowance_amount . "</td>";
				}

				$final_total = 0;
				if ($progress->history_type == 1) {
					//   $final_total = $basic_salary + $p_amt_basic;
					$final_total = $basic_salary;
					$final_amt[] = $final_total;
				}

				if ($progress->history_type == 2) {
					$final_total = $basic_salary + $p_amt_allowance;
					$final_amt[] = $final_total;
				}

				$table .= "<td>" . $final_total . "</td>";

				$table .= "</tr>";
			}


			$basic_sum = $this->Reports_model->basic_sum($depart_main_id_data, $year);
			if (!is_null($basic_sum)) {
				$basic_sum_data_get = $basic_sum[0]->basic_sum_data;
			} else {
				$basic_sum_data_get = '0';
			}


			$basic_progress_sum = $this->Reports_model->basic_progress_sum($depart_main_id_data, $year);
			if (!is_null($basic_progress_sum)) {
				$basic_progress_sum_data_get = $basic_progress_sum[0]->basic_progress_sum_data;
			} else {
				$basic_progress_sum_data_get = '0';
			}

			if ($basic_sum_data_get != '') {
				$basic_sum_get = number_format((float)$basic_sum_data_get, 2, '.', '');
			} else {
				$basic_sum_get = '';
			}

			if ($basic_progress_sum_data_get != '') {
				$basic_progress_get = number_format((float)$basic_progress_sum_data_get, 2, '.', '');
			} else {
				$basic_progress_get = '';
			}


			$table .= "<tr style='background-color: rgb(224, 224, 235);'>

	        	<th>" . $dept_name . " Total:</th>
	        	<th></th>
	        	<th></th>
	        	<th></th>
	        	<th></th>
	        	<th></th>
	        	<th>" . $basic_sum_get . "</th>
	        	<th>" . $basic_progress_get . "</th>";

			foreach ($allowances->result() as $allowance) {
				$table .= "<th>" . $total_sum[$allowance->id] . "</th>";
			}

			$table .= "<th>" . array_sum($final_amt) . "</th>";

			$table .= "</tr>";
		}

		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}


	public function salary_latest_progression_pdf_get()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$employee_id = $this->input->post('p_employee_id');
		$year = $this->input->post('p_year');


		$depart_id = $this->Reports_model->salary_latest_progression_history_report($company_id, $employee_id, $department_id, $location_id, $year);

		$depart_id_count = $this->Reports_model->salary_latest_progression_history_report_count($company_id, $employee_id, $department_id, $location_id, $year);

		//empty data display code start
		if (empty($depart_id_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end


		$data = array();
		foreach ($depart_id_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$depart_id_count[$key]['header_string'] = $email_phone_address;
			$depart_id_count[$key]['company_name'] = $company_name;
			$depart_id_count[$key]['logo'] = $logo;
		}


		foreach ($depart_id->result() as $value) {

			$data[] = array(
				"depart_main_id" => $value->department_id,
				"emp_main_id" => $value->user_id,
				"company_id" => $value->company_id
			);

		}


		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'format' => 'A4',
			'orientation' => 'l'
		]);
		$res['main_data'] = $data;
		$res['depart_id_count'] = $depart_id_count;
		$res['year'] = $year;
		$res['employee_id'] = $employee_id;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		$html = $this->load->view("admin/reports/salary_latest_progression_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Salary_Latest_Progression.pdf', 'D'); //


	}

	public function department_wise_emp_pdf_get()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		$user = $this->Xin_model->read_user_info($session['user_id']);
		$user_id = $user[0]->user_id;
		$company = $this->Xin_model->read_company_info($user[0]->company_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;
			if ($company_logo) {
				$logo = '../../../../../uploads/company/' . $company_logo;
				//	echo $logo;
			} else {
				$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
			}
		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
			$logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
		}
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$company_id = $this->input->post('p_company_id');
		$department_id = $this->input->post('p_department');
		$location_id = $this->input->post('p_location');
		$status = $this->input->post('p_status');


		$employee = $this->Reports_model->department_wise_employee_reports_pdf($company_id, $department_id, $location_id, $status);
		$employee_count = $this->Reports_model->department_wise_employee_reports_count($company_id, $department_id, $location_id, $status);

		//empty data display code start
		if (empty($employee_count)) {
			$logo_empty = "<img src='" . $logo . "' style='width:25%;'>";
			$company_name_empty = $company_name;
			$email_phone_address_empty = $email_phone_address;
			$empty_text = 'No Data Available In PDF';
		} else {
			$logo_empty = '';
			$company_name_empty = '';
			$email_phone_address_empty = '';
			$empty_text = '';
		}
		//empty data display code end

		$data = array();
		foreach ($employee_count as $key => $val) {


			$company = $this->Xin_model->read_company_info($val['company_id']);
			if (!is_null($company)) {
				$company_name = $company[0]->name;
				$address_1 = $company[0]->address_1;
				$address_2 = $company[0]->address_2;
				$city = $company[0]->city;
				$state = $company[0]->state;
				$company_logo = $company[0]->logo;
				$zipcode = $company[0]->zipcode;
				$country = $this->Xin_model->read_country_info($company[0]->country);
				if (!is_null($country)) {
					$country_name = $country[0]->country_name;
				} else {
					$country_name = '--';
				}
				$c_info_email = $company[0]->email;
				$c_info_phone = $company[0]->contact_number;
				if ($company_logo) {
					$logo = '../../../../../uploads/company/' . $company_logo;
					//	echo $logo;
				} else {
					// $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
					$logo = '';
				}
			} else {
				$company_name = '';
				$address_1 = '';
				$address_2 = '';
				$city = '';
				$state = '';
				$zipcode = '';
				$country_name = '';
				$c_info_email = '';
				$c_info_phone = '';
				$logo = '';
			}
			$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

			$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";
			$employee_count[$key]['header_string'] = $email_phone_address;
			$employee_count[$key]['company_name'] = $company_name;
			$employee_count[$key]['logo'] = $logo;
		}
		foreach ($employee as $key => $val) {
			foreach ($val['list'] as $k => $v1) {
				$full_name = $v1['first_name'] . ' ' . $v1['last_name'];

				if ($v1['is_active'] == 2) : $status = $this->lang->line('xin_employees_inactive');
				elseif ($v1['is_active'] == 1) : $status = $this->lang->line('xin_employees_active');
				endif;
				$designation = $this->Designation_model->read_designation_information($v1['designation_id']);
				if (!is_null($designation)) {
					$designation_name = $designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}
				$employee[$key]['list'][$k]['employee_id'] = $v1['employee_id'];
				$employee[$key]['list'][$k]['full_name'] = $full_name;
				$employee[$key]['list'][$k]['name'] = $v1['name'];
				$employee[$key]['list'][$k]['department_name'] = $v1['department_name'];
				$employee[$key]['list'][$k]['date_of_joining'] = $v1['date_of_joining'];
				$employee[$key]['list'][$k]['status'] = $status;
				$employee[$key]['list'][$k]['company_id'] = $v1['company_id'];
				$employee[$key]['list'][$k]['designation_name'] = $designation_name;
			}
		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $employee;
		$res['employee_count'] = $employee_count;
		$res['empty_text'] = $empty_text;
		$res['header_string'] = $email_phone_address_empty;
		$res['company_name'] = $company_name_empty;
		$res['logo'] = $logo_empty;
		// var_dump($res);die();
		$html = $this->load->view("admin/reports/department_wise_emp_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Department_Wise_Employee.pdf', 'D');
	}

	public function employee_daily_attendance_report_result()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$depart_main_id = $this->Reports_model->employee_daily_attendance_report_result($company_id, $department_id, $employee_id, $location_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Daily Attendance Sheet Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_daily_attendance_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_daily_attendance_report_table'>
	                      <thead>
	                        <tr>
				                <th style='padding-right: 155px;'>Date</th>
				                <th style='padding-right: 180px;'>Shift Name</th>
				                <th>Shift Start</th>
				                <th>Shift End</th>
				                <th class='title-space'>Late In Grace Time</th>
				                <th>Day Type</th>
				                <th>Clock In</th>
				                <th>Clock Out</th>
				                <th>Late In (hh.mm)</th>
				                <th class='title-space'>Early Out (hh.mm)</th>
				                <th>Odd Punch (day)</th>
				                <th>Absent (day)</th>
				                <th>Shift Hours</th>
				                <th>Working Hours (hh.mm)</th>
				                <th>Original OT (hh.mm)</th>
                        	</tr>
        				  </thead>";

		foreach ($depart_main_id->result() as $depart_main_id_get) {

			$depart_id_data = $depart_main_id_get->department_id;
			$user_id_data = $depart_main_id_get->user_id;

			//get department
			$department_name = $this->Xin_model->read_department_info($depart_id_data);
			if (!is_null($department_name)) {
				$dept_name = $department_name[0]->department_name;
				$dept_code = $department_name[0]->department_code;
			} else {
				$dept_name = '--';
				$dept_code = '--';
			}

			if ($employee_id == 0) {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_employees.department_id = $depart_id_data Group by xin_attendance_time.employee_id";
				$emp_main_id = $this->db->query($sql_data);

			} else {

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_employees.user_id IN($employee_id) Group by xin_attendance_time.employee_id";
				$emp_main_id = $this->db->query($sql_data);

			}


			$table .= "<tr style='background-color: #E0E0EB;'>
	        		  <td style='border-right-width: 0px;'><b>Department :</b></td>
	        		  <td style='border-right-width: 0px;'>" . $dept_name . "</td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        	  </tr>";


			foreach ($emp_main_id->result() as $emp_main_id_get) {


				$employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->user_id)[0];

				if (!empty($employee_info)) {
					$full_name_info = $employee_info->first_name . " " . $employee_info->last_name;
					$emp_code = $employee_info->employee_id;
					$emp_join_date = $employee_info->date_of_joining;
					$emp_depart_id = $employee_info->department_id;
				} else {
					$full_name_info = '--';
					$emp_code = '--';
					$emp_join_date = '--';
					$emp_depart_id = '0';
				}


				$table .= "<tr style='background-color: #E0E0EB;'>
	        		  <td style='border-right-width: 0px;'><b>Employee :</b></td>
	        		  <td style='border-right-width: 0px;'>[" . $emp_code . "] " . $full_name_info . "</td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  <td style='border-right-width: 0px;'></td>
	        		  </tr>";

				$emp_main_id_data = $emp_main_id_get->user_id;


				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_attendance_time.employee_id = $emp_main_id_data Group by xin_attendance_time.employee_id";
				$employee = $this->db->query($sql_data);

				$late_total = array();
				$early_out_total = array();
				$odd_punch_total = array();
				$absent_total = array();
				$shift_hours_total = array();
				$work_total = array();
				$ot_total = array();

				if ($employee->num_rows() > 0) {
					foreach ($employee->result() as $r) {
						//get company
						$company = $this->Xin_model->read_company_info($r->company_id);
						if (!is_null($company)) {
							$comp_name = $company[0]->name;
						} else {
							$comp_name = '--';
						}

						$full_name = $r->first_name . ' ' . $r->last_name;

						$attendance_date = $this->Reports_model->get_all_attendance_date($r->user_id, $from_date, $to_date);

						foreach ($attendance_date as $att) {
							# code...
							foreach ($att as $date) {

								foreach ($date as $key) {

									$att_date = $key->attendance_date;
									//------------------

									$clkInLast = $clkOutLast = '-';

									$this->db->where('employee_id', $r->user_id);
									$this->db->where('attendance_date', $att_date);
									$this->db->order_by('time_attendance_id', 'asc');
									$attendance = $this->db->get('xin_attendance_time');

									if ($attendance->num_rows() > 0) {

										foreach ($attendance->result() as $att) {
											$clock_in = date("H:i", strtotime($att->clock_in));
											$clock_out = date("H:i", strtotime($att->clock_out));
											if ($clock_in != '0:00' && $clock_out != '0:00') {
												if ($clkInLast == '-')
													$clkInLast = $clock_in;

												$clkOutLast = $clock_out;
											}
										}
									}


									if ($clkInLast != '-') {
										$clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
									}
									if ($clkOutLast != '-' && !is_null($clkOutLast)) {
										$clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
									}

									//-----------------

									$clock_in = $clkInLast;
									$clock_out = $clkOutLast;

									$att_status = $key->attendance_status;

									$get_day = strtotime($att_date);
									$day = date('l', $get_day);

									$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

									$working_hours = $this->Reports_model->get_total_work_hours($r->user_id, $att_date);

									$odd_punch = $this->Reports_model->calculate_employee_odd_punch($r->user_id, $att_date);
									# code...
									if ($day == 'Monday') {
										if (isset($office_shift[0]->monday_in_time) != '') {
											$in_time = $office_shift[0]->monday_in_time;
											$out_time = $office_shift[0]->monday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Tuesday') {
										if (isset($office_shift[0]->tuesday_in_time) != '') {
											$in_time = $office_shift[0]->tuesday_in_time;
											$out_time = $office_shift[0]->tuesday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Wednesday') {
										if (isset($office_shift[0]->wednesday_in_time) != '') {
											$in_time = $office_shift[0]->wednesday_in_time;
											$out_time = $office_shift[0]->wednesday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Thursday') {
										if (isset($office_shift[0]->thursday_in_time) != '') {
											$in_time = $office_shift[0]->thursday_in_time;
											$out_time = $office_shift[0]->thursday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Friday') {
										if (isset($office_shift[0]->friday_in_time) != '') {
											$in_time = $office_shift[0]->friday_in_time;
											$out_time = $office_shift[0]->friday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Saturday') {
										if (isset($office_shift[0]->saturday_in_time) != '') {

											$in_time = $office_shift[0]->saturday_in_time;
											$out_time = $office_shift[0]->saturday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '00:00:00';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									} else if ($day == 'Sunday') {
										if (isset($office_shift[0]->sunday_in_time) != '') {

											$in_time = $office_shift[0]->sunday_in_time;
											$out_time = $office_shift[0]->sunday_out_time;
											$late_in_grace_time_min = $office_shift[0]->late_allowed_till;
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
											$shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										} else {
											$in_time = '00:00:00';
											$out_time = '00:00:00';
											$clock_in_data = '00:00:00';
											$clock_out_data = '00:00:00';
											$shift_hours = '0';
											$late_in_grace_time_min = '00:00:00';
											if (isset($office_shift[0]->shift_name)) {
												# code...
												$shift_name = $office_shift[0]->shift_name;
											} else {
												$shift_name = '--';
											}
										}
									}

									$early_out_grace_time_min = '00:00';

									//daily attendance info data get
									$attendance_data = $this->Reports_model->get_early_leave_data($r->user_id, $att_date);
									if (!is_null($attendance_data)) {
										$early_leave_data_get = $attendance_data[0]->early_leaving;
										$late_data_get = $attendance_data[0]->late;
										$work_data_get = $attendance_data[0]->work;
										$ot_data_get = $attendance_data[0]->overtime;
									} else {
										$early_leave_data_get = '00:00';
										$late_data_get = '00:00';
										$work_data_get = '00:00';
										$ot_data_get = '00:00';
									}

									if ($att_status == 'Present') {
										if ($clock_out_data == '') {
											$odd_punch = 1;
										} else {
											$odd_punch = 0;
										}
										$absent_day = 0;
									} else {
										$odd_punch = 0;
										$absent_day = 1;
									}

									//employee wise total get
									$odd_punch_total[] = $odd_punch;
									$absent_total[] = $absent_day;
									// $shift_hours_total[] = $shift_hours;

									$late_val = $late_data_get;
									$late_val_get = (explode(":", $late_val));
									$late_val_imp = $late_val_get;
									$late_val_final = implode(".", $late_val_imp);
									$late_total[] = $late_val_final;

									$early_val = $early_leave_data_get;
									$early_val_get = (explode(":", $early_val));
									$early_val_imp = $early_val_get;
									$early_val_final = implode(".", $early_val_imp);
									$early_out_total[] = $early_val_final;

									$work_val = $work_data_get;
									$work_val_get = (explode(":", $work_val));
									$work_val_imp = $work_val_get;
									$work_val_final = implode(".", $work_val_imp);
									$work_total[] = $work_val_final;

									$ot_val = $ot_data_get;
									$ot_val_get = (explode(":", $ot_val));
									$ot_val_imp = $ot_val_get;
									$ot_val_final = implode(".", $ot_val_imp);
									$ot_total[] = $ot_val_final;
									//employee wise total get end

									$attendance_date_get = date("d-m-Y", strtotime($att_date)) . ' (' . $day . ')';

									if ($in_time == '') {
										$shift_in_time = 'Holiday';
									} else {
										$shift_in_time = date('h:i A', strtotime($in_time));
									}

									if ($out_time == '') {
										$shift_out_time = 'Holiday';
									} else {
										$shift_out_time = date('h:i A', strtotime($out_time));
									}


									if ($r->office_shift_id == 0) {
										$custom_shift_data = $this->Reports_model->get_custom_shift_data($r->user_id, $att_date);
										if (!empty($custom_shift_data)) {
											$shift_name = $custom_shift_data['name'];
											$cust_day = explode('-', $att_date);
											for ($i = 1; $i <= 31; $i++) {
												if ($cust_day[2] == $i) {
													if ($custom_shift_data[$i . '_in'] != NULL && $custom_shift_data[$i . '_out'] != NULL) {
														$cust_day_in_res = explode(' ', $custom_shift_data[$i . '_in']);
														$cust_day_out_res = explode(' ', $custom_shift_data[$i . '_out']);

														$shift_hours = round(abs(strtotime($cust_day_out_res[1]) - strtotime($cust_day_in_res[1])) / 3600, 2);

														$shift_in_time = date('h:i A', strtotime($cust_day_in_res[1]));
														$shift_out_time = date('h:i A', strtotime($cust_day_out_res[1]));
													} else {
														$shift_hours = 0;
														$shift_in_time = 0;
														$shift_out_time = 0;
													}

												}
											}
											$late_in_grace_time_min = $custom_shift_data['late_allowed_till'] . ' min';
											$clock_in_data = $clock_in;
											$clock_out_data = $clock_out;
										} else {
											$shift_name = '--';
											$shift_hours = 0;
											$shift_in_time = 0;
											$shift_out_time = 0;
										}
									}
									$shift_hours_total[] = $shift_hours;
									$table .= "<tr>";

									$table .= "<td>" . $attendance_date_get . "</td>
									  <td>" . $shift_name . "</td>
									  <td>" . $shift_in_time . "</td>
									  <td>" . $shift_out_time . "</td>
									  <td>" . $late_in_grace_time_min . "</td>
									  <td>" . $att_status . "</td>
									  <td>" . $clock_in_data . "</td>
									  <td>" . $clock_out_data . "</td>
									  <td>" . $late_data_get . "</td>
									  <td>" . $early_leave_data_get . "</td>
									  <td>" . $odd_punch . "</td>
									  <td>" . $absent_day . "</td>
									  <td>" . $shift_hours . " Hours</td>
									  <td>" . $work_data_get . "</td>
									  <td>" . $ot_data_get . "</td>";

									$table .= "</tr>";
								}
							}
						}
					}

				}
				$table .= "<tr>";

				$table .= "<td style='border-right-width: 0px;'><b>Employee Wise Total :</b></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($late_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($early_out_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($odd_punch_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($absent_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($shift_hours_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($work_total) . "</b></td>
						        		  <td style='border-right-width: 0px;'><b>" . array_sum($ot_total) . "</b></td>";

				$table .= "</tr>";
			}
		}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function employee_early_out_request_status_report()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$aj_company = $_GET['aj_company'];
		$aj_department = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$emp_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$employee = $this->Reports_model->employee_early_out_request_status_get($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date);


		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Employees Early out Request Status Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_early_out_request_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_early_out_request_table'>
	                      <thead>
	                        <tr>
	                            <th>ID</th>
				                <th>Employee Name</th>
				                <th>Department</th>
				                <th>Attendance Date</th>
				                <th>Clock OUT Time</th>
				                <th>Shift OUT Time</th>
				                <th>Early OUT Time (hh:mm)</th>
        						<th>Approved</th></tr></thead>";


		//foreach ($depart_id->result() as $depart_id_main) {

		//department wise early out condition check

		/*		$leave1 = $this->Reports_model->check_employee_leave($depart_id_main->user_id,$depart_id_main->attendance_date);
			if ($leave1!='') {
				continue;
		}


		//------------------day wise clock in and clock out start

			$clkInLast1 = $clkOutLast1 = '-';

			$this->db->where('employee_id', $depart_id_main->user_id);
			$this->db->where('attendance_date', $depart_id_main->attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0)
			{

			    foreach ($attendance->result() as $att1)
			    {
			        $clock_in1 = date("H:i",strtotime($att1->clock_in));
			    	$clock_out1 = date("H:i",strtotime($att1->clock_out));
			        if ($clock_in1 != '0:00' && $clock_out1 != '0:00')
			        {
			            if ($clkInLast1 == '-')
			                $clkInLast1 = $clock_in1;

			            $clkOutLast1 = $clock_out1;
			        }
			    }
			}


		//-----------------day wise clock in and clock out end


			$in_time_without_date1 = $clkInLast1;
			$out_time_without_date1 = $clkOutLast1;

			$att_date1 = $depart_id_main->attendance_date;
			$get_day1 = strtotime($att_date1);
			$day1 = date('l', $get_day1);

			$office_shift1 = $this->Reports_model->read_employee_office_shift($depart_id_main->office_shift_id);

			if($day1 == 'Monday') {
				if(isset($office_shift1[0]->monday_out_time)!=''){

					$shift_out_time1 = $office_shift1[0]->monday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Tuesday') {
				if(isset($office_shift1[0]->tuesday_out_time)!=''){
					$shift_out_time1 = $office_shift1[0]->tuesday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Wednesday') {
				if(isset($office_shift1[0]->wednesday_out_time)!=''){
					$shift_out_time1 = $office_shift1[0]->wednesday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Thursday') {
				if(isset($office_shift1[0]->thursday_out_time)!=''){
					$shift_out_time1 = $office_shift1[0]->thursday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Friday') {
				if(isset($office_shift1[0]->friday_out_time)!=''){
					$shift_out_time1 = $office_shift1[0]->friday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Saturday') {
				if(isset($office_shift1[0]->saturday_out_time)!=''){
					$shift_out_time1 = $office_shift1[0]->saturday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}


				}
			} else if($day1 == 'Sunday') {
				if(isset($office_shift1[0]->sunday_out_time)!=''){
					$shift_out_time1 = $office_shift1[0]->sunday_out_time;
					if ($shift_out_time1<=$out_time_without_date1) {
						# code...
						continue;
					}


				}
			}


		//department wise early out condition check end


			$depart_main_id_data = $depart_id_main->department_id;
			$user_id_data = $depart_id_main->user_id;

			//get department
			$department = $this->Department_model->read_department_information($depart_main_id_data);
			if(!is_null($department)){
			$department_name = $department[0]->department_name;
			} else {
			$department_name = '--';
			}


			$table .="<tr style='background-color: #E0E0EB;'><th>Department Name: ".$department_name."</th>
					  <th></th>
					  <th></th>
					  <th></th>
					  <th></th>
					  <th></th>
					  <th></th></tr>";

			if($emp_id == 0){

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_main_id_data";

        		$employee = $this->db->query($sql_data);

			}else{

				$sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.user_id = $user_id_data";

        		$employee = $this->db->query($sql_data);

			} */


		foreach ($employee->result() as $r) {

			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}

			//get company
			$leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
			if ($leave != '') {
				# code...
				continue;
			}

			$full_name = $r->first_name . ' ' . $r->last_name;

			//------------------day wise clock in and clock out start

			$clkInLast = $clkOutLast = '-';

			$this->db->where('employee_id', $r->user_id);
			$this->db->where('attendance_date', $r->attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {

				foreach ($attendance->result() as $att) {
					$clock_in = date("H:i", strtotime($att->clock_in));
					$clock_out = date("H:i", strtotime($att->clock_out));
					if ($clock_in != '0:00' && $clock_out != '0:00') {
						if ($clkInLast == '-')
							$clkInLast = $clock_in;

						$clkOutLast = $clock_out;
					}
				}
			}

			//-----------------day wise clock in and clock out end


			$in_time_without_date = $clkInLast;
			$out_time_without_date = $clkOutLast;

			$att_date = $r->attendance_date;
			$get_day = strtotime($att_date);
			$day = date('l', $get_day);

			$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

			if ($day == 'Monday') {
				if (isset($office_shift[0]->monday_out_time) != '') {

					$shift_out_time = $office_shift[0]->monday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;
				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			} else if ($day == 'Tuesday') {
				if (isset($office_shift[0]->tuesday_out_time) != '') {
					$shift_out_time = $office_shift[0]->tuesday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;

				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			} else if ($day == 'Wednesday') {
				if (isset($office_shift[0]->wednesday_out_time) != '') {
					$shift_out_time = $office_shift[0]->wednesday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;
				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			} else if ($day == 'Thursday') {
				if (isset($office_shift[0]->thursday_out_time) != '') {
					$shift_out_time = $office_shift[0]->thursday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;
				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			} else if ($day == 'Friday') {
				if (isset($office_shift[0]->friday_out_time) != '') {
					$shift_out_time = $office_shift[0]->friday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;
				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			} else if ($day == 'Saturday') {
				if (isset($office_shift[0]->saturday_out_time) != '') {
					$shift_out_time = $office_shift[0]->saturday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;

				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			} else if ($day == 'Sunday') {
				if (isset($office_shift[0]->sunday_out_time) != '') {
					$shift_out_time = $office_shift[0]->sunday_out_time;
					if ($shift_out_time <= $out_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
					$out_time = $out_time_without_date;

				} else {
					$in_time = '00:00:00';
					$out_time = '00:00:00';
					$shift_out_time = '';
				}
			}

			$approved = 'No';

			$attendance_date_get = date("d-m-Y", strtotime($r->attendance_date));


			if ($out_time != '-' && !is_null($out_time)) {
				$out_time = $this->Misc_model->time_24_to_12($out_time);
			}


			$early_leave_data = $this->Reports_model->get_early_leave_data($r->user_id, $r->attendance_date);
			if (!is_null($early_leave_data)) {
				$early_leave_data_get = $early_leave_data[0]->early_leaving;
			} else {
				$early_leave_data_get = '00:00';
			}

			//get shift out time
			if ($shift_out_time == '') {
				$shift_out_time_get = 'Office Shift Is Not Assigned';
			} else {
				$shift_out_time_get = date('h:i A', strtotime($shift_out_time));
			}
			if ($r->office_shift_id == 0) {
				$custom_shift_data = $this->Reports_model->get_custom_shift_data($r->user_id, $r->attendance_date);
				if (!empty($custom_shift_data)) {
					$shift_name = $custom_shift_data['name'];
					$cust_day = explode('-', $r->attendance_date);
					for ($i = 1; $i <= 31; $i++) {
						if ($cust_day[2] == $i) {
							if ($custom_shift_data[$i . '_in'] != NULL && $custom_shift_data[$i . '_out'] != NULL) {
								$cust_day_in_res = explode(' ', $custom_shift_data[$i . '_in']);
								$cust_day_out_res = explode(' ', $custom_shift_data[$i . '_out']);

								$shift_hours = round(abs(strtotime($cust_day_out_res[1]) - strtotime($cust_day_in_res[1])) / 3600, 2);

								$shift_in_time = date('h:i A', strtotime($cust_day_in_res[1]));
								$shift_out_time_get = date('h:i A', strtotime($cust_day_out_res[1]));
							} else {
								$shift_hours = 0;
								$shift_in_time = 0;
								$shift_out_time_get = 0;
							}

						}
					}
					$late_in_grace_time_min = $custom_shift_data['late_allowed_till'] . ' min';
					$clock_in_data = $clock_in;
					$clock_out_data = $clock_out;
				} else {
					$shift_name = '--';
					$shift_hours = 0;
					$shift_in_time = 0;
					$shift_out_time_get = 0;
				}
			}
			$out_time = date('h:i A', strtotime($clkOutLast));

			$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
			if (!empty($employee_info)) {
				$emp_code = $employee_info->employee_id;
			} else {
				$emp_code = '--';
			}

			if ($early_leave_data_get != '00:00') {
				$table .= "<tr>";

				$table .= "<td>" . $emp_code . "</td>
    	        		<td>" . $full_name . "</td>
    	        		<td>" . $department_name . "</td>
    	        		<td>" . $attendance_date_get . " (" . $day . ")</td>
    	        		<td>" . $out_time . "</td>
    	        		<td>" . $shift_out_time_get . "</td>
    	        		<td>" . $early_leave_data_get . "</td>
    	        		<td>" . $approved . "</td>";

				$table .= "</tr>";
			}

		}
		//}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}

	public function employee_late_in_request_status_report()
	{


		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees", $data);
		} else {
			redirect('admin/');
		}

		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['aj_company'];
		$department_id = $_GET['aj_department'];
		$location_id = $_GET['location_id'];
		$employee_id = $_GET['paysheet_employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];


		$employee = $this->Reports_model->employee_late_in_request_status_report($company_id, $department_id, $location_id, $employee_id, $from_date, $to_date);
// var_dump($depart_id->result());die();

		$table = "";
		$table .= "<span class='card-header-title mr-2'><strong>Late in Request Status Report</strong></span>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive' id='employee_late_in_report_datatable'>
					<table class='datatables-demo table table-striped table-bordered' id='employee_late_in_report'>
	                      <thead>
	                        <tr>
	                            <th>ID</th>
	                            <th>Company</th>
	                            <th>Department</th>
				                <th>Employee Name</th>
				                <th>Date</th>
				                <th>Clock IN Time</th>
				                <th>Shift IN Time</th>
				                <th>Late IN Time (hh:mm)</th>
				                <th>Applied</th></tr></thead>";

//foreach ($depart_id->result() as $depart_id_main) {

// var_dump($depart_id_main);die();
		//department wise early out condition check

		/*		$leave1 = $this->Reports_model->check_employee_leave($depart_id_main->user_id,$depart_id_main->attendance_date);
			if ($leave1!='') {
				continue;
			} */

		//------------------day wise clock in and clock out start

		/*	$clkInLast1 = $clkOutLast1 = '-';

			$this->db->where('employee_id', $depart_id_main->user_id);
			$this->db->where('attendance_date', $depart_id_main->attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0)
			{

			    foreach ($attendance->result() as $att1)
			    {
			        $clock_in1 = date("H:i",strtotime($att1->clock_in));
			    	$clock_out1 = date("H:i",strtotime($att1->clock_out));
			        if ($clock_in1 != '0:00' && $clock_out1 != '0:00')
			        {
			            if ($clkInLast1 == '-')
			                $clkInLast1 = $clock_in1;

			            $clkOutLast1 = $clock_out1;
			        }
			    }
			}


		//-----------------day wise clock in and clock out end


			$in_time_without_date1 = $clkInLast1;

			$att_date1 = $depart_id_main->attendance_date;
			$get_day1 = strtotime($att_date1);
			$day1 = date('l', $get_day1);

			$office_shift1 = $this->Reports_model->read_employee_office_shift($depart_id_main->office_shift_id);


			if($day1 == 'Monday') {
				if(isset($office_shift1[0]->monday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->monday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Tuesday') {
				if(isset($office_shift1[0]->tuesday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->tuesday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Wednesday') {
				if(isset($office_shift1[0]->wednesday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->tuesday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Thursday') {
				if(isset($office_shift1[0]->thursday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->thursday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}

				}
			} else if($day1 == 'Friday') {
				if(isset($office_shift1[0]->friday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->friday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}
				}
			} else if($day1 == 'Saturday') {
				if(isset($office_shift1[0]->saturday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->saturday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}


				}
			} else if($day1 == 'Sunday') {
				if(isset($office_shift1[0]->sunday_in_time)!=''){

					$shift_in_time1 = $office_shift1[0]->sunday_in_time;
					if ($shift_in_time1>=$in_time_without_date1) {
						# code...
						continue;
					}


				}
			}*/


		//department wise early out condition check end


		//	$depart_main_id_data = $depart_id_main->department_id;
		//	$user_id_data = $depart_id_main->user_id;

		//get department
		/*	$department = $this->Department_model->read_department_information($depart_main_id_data);
			if(!is_null($department)){
			$department_name = $department[0]->department_name;
			} else {
			$department_name = '--';
			} */


		/*	$table .="<tr style='background-color: #E0E0EB;'>
					  <th style='border-right-width: 0px;'>Department : ".$department_name."</th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th>
					  <th style='border-right-width: 0px;'></th></tr>";  */

		/*	if($employee_id == 0){

				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_main_id_data GROUP BY xin_attendance_time.attendance_date";

        		$employee = $this->db->query($sql_data);

			}else{

				$sql_data = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.user_id = $user_id_data GROUP BY xin_attendance_time.attendance_date";

        		$employee = $this->db->query($sql_data);

			}  */

		foreach ($employee->result() as $r) {
			# code...

			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}


			//get company
			$leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
			if ($leave != '') {
				# code...
				continue;
			}
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$full_name = $r->first_name . ' ' . $r->last_name;

			//------------------day wise clock in and clock out start

			$clkInLast = $clkOutLast = '-';

			$this->db->where('employee_id', $r->user_id);
			$this->db->where('attendance_date', $r->attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {

				foreach ($attendance->result() as $att) {
					$clock_in = date("H:i", strtotime($att->clock_in));
					$clock_out = date("H:i", strtotime($att->clock_out));
					if ($clock_in != '0:00' && $clock_out != '0:00') {
						if ($clkInLast == '-')
							$clkInLast = $clock_in;

						$clkOutLast = $clock_out;
					}
				}
			}

			//-----------------day wise clock in and clock out end


			$in_time_without_date = $clkInLast;

			$att_date = $r->attendance_date;
			$get_day = strtotime($att_date);
			$day = date('l', $get_day);

			$office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

			//$shift_in_time == '';

			if ($day == 'Monday') {
				if (isset($office_shift[0]->monday_in_time) != '') {

					$shift_in_time = $office_shift[0]->monday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			} else if ($day == 'Tuesday') {
				if (isset($office_shift[0]->tuesday_in_time) != '') {
					$shift_in_time = $office_shift[0]->tuesday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			} else if ($day == 'Wednesday') {
				if (isset($office_shift[0]->wednesday_in_time) != '') {
					$shift_in_time = $office_shift[0]->wednesday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			} else if ($day == 'Thursday') {
				if (isset($office_shift[0]->thursday_in_time) != '') {
					$shift_in_time = $office_shift[0]->thursday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			} else if ($day == 'Friday') {
				if (isset($office_shift[0]->friday_in_time) != '') {
					$shift_in_time = $office_shift[0]->friday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;
				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			} else if ($day == 'Saturday') {
				if (isset($office_shift[0]->saturday_in_time) != '') {
					$shift_in_time = $office_shift[0]->saturday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;

				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			} else if ($day == 'Sunday') {
				if (isset($office_shift[0]->sunday_in_time) != '') {
					$shift_in_time = $office_shift[0]->sunday_in_time;
					if ($shift_in_time >= $in_time_without_date) {
						# code...
						continue;
					}
					$in_time = $in_time_without_date;

				} else {
					$in_time = '00:00:00';
					$shift_in_time = '';
				}
			}

			$applied = 'No';

			$attendance_date_get = date("d-m-Y", strtotime($r->attendance_date));

			//get employee info
			$employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];

			if (!empty($employee_info)) {
				$emp_code = $employee_info->employee_id;
			} else {
				$emp_code = '--';
			}

			if ($in_time != '-') {
				$in_time = $this->Misc_model->time_24_to_12($in_time);
			}

			$late_data = $this->Reports_model->get_early_leave_data($r->user_id, $r->attendance_date);
			if (!is_null($late_data)) {
				$late_data_get = $late_data[0]->late;
			} else {
				$late_data_get = '00:00';
			}


			//shift in time get
			if ($shift_in_time == '') {
				$shift_in_time_get = 'Office Shift Is Not Assigned';
			} else {
				$shift_in_time_get = date('h:i A', strtotime($shift_in_time));
			}

			if ($r->office_shift_id == 0) {
				$custom_shift_data = $this->Reports_model->get_custom_shift_data($r->user_id, $r->attendance_date);
				if (!empty($custom_shift_data)) {
					$shift_name = $custom_shift_data['name'];
					$cust_day = explode('-', $r->attendance_date);
					for ($i = 1; $i <= 31; $i++) {
						if ($cust_day[2] == $i) {
							if ($custom_shift_data[$i . '_in'] != NULL && $custom_shift_data[$i . '_out'] != NULL) {
								$cust_day_in_res = explode(' ', $custom_shift_data[$i . '_in']);
								$cust_day_out_res = explode(' ', $custom_shift_data[$i . '_out']);

								$shift_hours = round(abs(strtotime($cust_day_out_res[1]) - strtotime($cust_day_in_res[1])) / 3600, 2);

								$shift_in_time_get = date('h:i A', strtotime($cust_day_in_res[1]));
								$shift_out_time_get = date('h:i A', strtotime($cust_day_out_res[1]));
							} else {
								$shift_hours = 0;
								$shift_in_time_get = 0;
								$shift_out_time_get = 0;
							}

						}
					}
					$late_in_grace_time_min = $custom_shift_data['late_allowed_till'] . ' min';
					$clock_in_data = $clock_in;
					$clock_out_data = $clock_out;
				} else {
					$shift_name = '--';
					$shift_hours = 0;
					$shift_in_time_get = 0;
					$shift_out_time_get = 0;
				}
			}
			$in_time = date('h:i A', strtotime($clkInLast));
			if ($late_data_get != '00:00') {
				$table .= "<tr>";
				$table .= "<td>" . $emp_code . "</td>
			      			<td>" . $comp_name . "</td>
			      			<td>" . $department_name . "</td>
							<td>" . $full_name . "</td>
							<td>" . $attendance_date_get . " (" . $day . ")</td>
							<td>" . $in_time . "</td>
							<td>" . $shift_in_time_get . "</td>
							<td>" . $late_data_get . "</td>
							<td>" . $applied . "</td>";

				$table .= "</tr>";
			}

		}

//}


		$table .= "</tbody></table></div></div>";

		header("Content-type: application/json");
		$result[0] = $table;
		$result[1] = $this->security->get_csrf_hash();
		echo json_encode($result);
		exit();
	}


	///////////////////////////////report for filters/////////////////////////////
	public function get_locations_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/report_get_locations_new", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_location_employees_new()
	{
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$data = array(
			'location_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/report_get_location_employee_new", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_all_countries_new()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_all_countries_new");
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > departments (rahul update)
	public function get_departments_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];
		$location_id = $_GET['location_id'];
		$check = $_GET['check'];

		$data = array(
			'company_id' => $company_id,
			'location_id' => $location_id,
			'check' => $check
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/report_get_departments_new", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_location_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];
		$check = $_GET['check'];

		$data = array(
			'company_id' => $company_id,
			'check' => $check
		);

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_location_new", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_employee_loca_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];
		$department_id = $_GET['department_id'];
		$location_id = $_GET['location_id'];


		$data = array(
			'company_id' => $company_id,
			'department_id' => $department_id,
			'location_id' => $location_id
		);

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_employee_loca_new", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}


	//employee wise designation report filter code
	public function get_designation_location_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];
		$check = $_GET['check'];

		$data = array(
			'company_id' => $company_id,
			'check' => $check
		);

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_designation_location_new", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_designation_departments_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];
		$location_id = $_GET['location_id'];
		$check = $_GET['check'];

		$data = array(
			'company_id' => $company_id,
			'location_id' => $location_id,
			'check' => $check
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_designation_departments_new", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_employee_designation_new()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];
		$department_id = $_GET['department_id'];


		$data = array(
			'company_id' => $company_id,
			'department_id' => $department_id,
		);

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_employee_designation_new", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//get nationality report filter
	public function get_nationality_new()
	{

		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_nationality_new", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//get miscelleneous filter
	public function get_employees_miscelleneous()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];

		$data = array(
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_employees_miscelleneous", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//get miscelleneous >> user roll report filter
	public function get_location_user_roll()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];

		$data = array(
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/filters/get_location_user_roll", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//get payroll >> overtime Report filter
	public function get_employees_payroll()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];

		$data = array(
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	//get leave >> Detailed Leave Count Report filter
	public function get_employees_leave_count()
	{

		$data['title'] = $this->Xin_model->site_title();
		$company_id = $_GET['company_id'];

		$data = array(
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/get_employees_leave_count_report", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function employee_annual_leave_pdf()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_annual_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$sd = $this->input->post('p_start_date');
		$ed = $this->input->post('p_end_date');
		$user_id = $this->input->post('p_user_id');
		$company_id = $this->input->post('p_company_id');

		if ($user_id == '') {
			$employee = $this->Reports_model->get_annual_leave_application_list();
		} else {
			$employee = $this->Reports_model->get_annual_leave_application_filter_list($sd, $ed, $user_id, $company_id);
		}
		$data = array();
		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			$employee = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($employee)) {
				$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
			} else {
				$full_name = '--';
			}
			//approved leave
			$rapproved = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 2);
			$approved = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Approved" data-employee_id="' . $r->employee_id . '">' . $rapproved . ' ' . $this->lang->line('xin_view') . '</a>';
			// pending leave
			$rpending = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 1);
			$pending = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Pending" data-employee_id="' . $r->employee_id . '">' . $rpending . ' ' . $this->lang->line('xin_view') . '</a>';
			//upcoming leave
			$rupcoming = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 4);
			$upcoming = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Upcoming" data-employee_id="' . $r->employee_id . '">' . $rupcoming . ' ' . $this->lang->line('xin_view') . '</a>';
			//rejected leave
			$rrejected = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 3);
			$rejected = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Rejected" data-employee_id="' . $r->employee_id . '">' . $rrejected . ' ' . $this->lang->line('xin_view') . '</a>';

			$data[] = array(
				'comp_name' => $comp_name,
				'full_name' => $full_name,
				'approved' => $approved,
				'pending' => $pending,
				'upcoming' => $upcoming,
				'rejected' => $rejected,
			);
		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$html = $this->load->view("admin/reports/get_annaual_leave_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Annual_leave_status.pdf', 'D'); //
	}

	public function employee_leave_pdf()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employee_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$sd = $this->input->post('p_start_date');
		$ed = $this->input->post('p_end_date');
		$user_id = $this->input->post('p_user_id');
		$company_id = $this->input->post('p_company_id');
		if ($user_id == '') {
			$employee = $this->Reports_model->get_leave_application_list();
		} else {
			$employee = $this->Reports_model->get_leave_application_filter_list($sd, $ed, $user_id, $company_id);
		}
		$data = array();

		foreach ($employee->result() as $r) {

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			$employee = $this->Xin_model->read_user_info($r->employee_id);
			// user full name
			if (!is_null($employee)) {
				$full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
			} else {
				$full_name = '--';
			}
			//approved leave
			$rapproved = $this->Reports_model->get_approved_leave_application_list($r->employee_id);
			$approved = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Approved" data-employee_id="' . $r->employee_id . '">' . $rapproved . ' ' . $this->lang->line('xin_view') . '</a>';
			// pending leave
			$rpending = $this->Reports_model->get_pending_leave_application_list($r->employee_id);
			$pending = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Pending" data-employee_id="' . $r->employee_id . '">' . $rpending . ' ' . $this->lang->line('xin_view') . '</a>';
			//upcoming leave
			$rupcoming = $this->Reports_model->get_upcoming_leave_application_list($r->employee_id);
			$upcoming = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Upcoming" data-employee_id="' . $r->employee_id . '">' . $rupcoming . ' ' . $this->lang->line('xin_view') . '</a>';
			//rejected leave
			$rrejected = $this->Reports_model->get_rejected_leave_application_list($r->employee_id);
			$rejected = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Rejected" data-employee_id="' . $r->employee_id . '">' . $rrejected . ' ' . $this->lang->line('xin_view') . '</a>';

			$data[] = array(
				'comp_name' => $comp_name,
				'full_name' => $full_name,
				'approved' => $approved,
				'pending' => $pending,
				'upcoming' => $upcoming,
				'rejected' => $rejected,
			);
		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$html = $this->load->view("admin/reports/get_employee_leave_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Leave_status.pdf', 'D'); //


	}


	public function employees_indemnity()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('xin_hr_report_employees') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Employees Indemnity Reports';
		$data['path_url'] = 'reports_employees_indemnity';
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_departments'] = $this->Department_model->all_departments();
		$data['all_designations'] = $this->Designation_model->all_designations();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('620', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/employees_indemnity", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}

	public function employee_indemnity_reports()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/reports/employees_indemnity", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$company_id = $_GET['company_id'];
		$designation_id = $_GET['designation_id'];
		$department_id = $_GET['aj_department'];
		$employee_id = $_GET['employee_id'];
		$from_date = $_GET['from_date'];
		$to_date = $_GET['to_date'];

		$indemnities = $this->Reports_model->get_employees_indemnity_reports($company_id, $department_id, $designation_id, $employee_id, $from_date, $to_date);
		$data = array();

		foreach ($indemnities->result() as $key => $r) {
			if ($r->status == 1) {
				$status = 'Unpaid';
			} else if ($r->status == 2) {
				$status = 'Paid';
			}

			$year_desc = date('d F, Y', strtotime($r->from_date)) . ' to ' . (date('d F, Y', strtotime($r->to_date)));

			if ($r->by_cash == 'on') {
				$status_cash = 'Yes';
			} else {
				$status_cash = 'No';
			}
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			$full_name = $r->first_name . ' ' . $r->last_name;
			// get designation
			$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			// location

			$location = $this->Location_model->read_location_information($r->location_id);
			if (!is_null($location)) {
				$location_name = $location[0]->location_name;
			} else {
				$location_name = '--';
			}

			$employee_name = '
			<div class="media align-items-center">
				<div class="media-body ml-2">
					' . $full_name . '
				</div>
		  	</div>';
			$company_name = '
			<div class="media align-items-center">

				<div class="media-body flex-truncate">

				  ' . $comp_name . '

				  <div class="text-muted small text-truncate">' . $this->lang->line('xin_location') . ': ' . $location_name . '</div>

				  <div class="text-muted small text-truncate">' . $this->lang->line('left_department') . ': ' . $department_name . '</div>

				  <div class="text-muted small text-truncate">' . $this->lang->line('left_designation') . ': ' . $designation_name . '</div>

				</div>

			  </div>';

			$data[] = array(
				$key+1,
				$full_name,
				$company_name,
				$r->year . '- (' . $year_desc . ')',
				$r->amount,
				$r->balance_amount,
				$r->balance_amount_old,
				$r->indemninty_month,
				$status,
				$status_cash
			);
		}
		$output = array(
			"draw" => $draw,
			"recordsTotal" => $indemnities->num_rows(),
			"recordsFiltered" => $indemnities->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	///////////////////////////////report for filters end/////////////////////////////

}
