<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Reports_payroll extends MY_Controller
{

    /*Function to set JSON output*/
    public function output($Return = array())
    {
        /*Set response header*/
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json; charset=UTF-8");
        /*Final JSON response*/
        exit(json_encode($Return));
    }

    public function __construct()
    {
        parent::__construct();
        //load the login model
        $this->load->model('Company_model');
        $this->load->model('Xin_model');
        $this->load->model('Exin_model');
        $this->load->model('Department_model');
        $this->load->model('Payroll_model');
        $this->load->model('Reports_model');
        $this->load->model('Timesheet_model');
        $this->load->model('Training_model');
        $this->load->model('Trainers_model');
        $this->load->model("Project_model");
        $this->load->model("Roles_model");
        $this->load->model("Employees_model");
        $this->load->model("Designation_model");
        $this->load->model("Misc_model");
        $this->load->model("Location_model");
    }

    // reports
    public function index()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_title') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_title');
        $data['path_url'] = 'hrsale_reports';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('110', $role_resources_ids) || in_array('111', $role_resources_ids) || in_array('112', $role_resources_ids) || in_array('113', $role_resources_ids) || in_array('114', $role_resources_ids) || in_array('115', $role_resources_ids) || in_array('116', $role_resources_ids) || in_array('117', $role_resources_ids) || in_array('409', $role_resources_ids) || in_array('83', $role_resources_ids) || in_array('84', $role_resources_ids) || in_array('85', $role_resources_ids) || in_array('86', $role_resources_ids)  || in_array('87', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/layout/hrsale_reports", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    // payslip reports > employees and company
    public function payslip()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_payslip') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_reports_payslip');
        $data['path_url'] = 'reports_payslip';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('111', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/payslip", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    //increment report
    public function increment_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_increment_employee') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_reports_increment_employee');
        $data['path_url'] = 'reports_employee_attendance';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $allowance = $this->Xin_model->get_allowance();
        $data['allowance'] = $allowance;
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/increment_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    // projects report
    public function projects()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_projects') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_reports_projects');
        $data['path_url'] = 'reports_project';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('114', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/projects", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    // tasks report
    public function tasks()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_tasks') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_reports_tasks');
        $data['path_url'] = 'reports_task';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('115', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/tasks", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    // roles/privileges report
    public function roles()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_user_roles_report') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_user_roles_report');
        $data['path_url'] = 'reports_roles';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_user_roles'] = $this->Roles_model->all_user_roles();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('116', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/roles", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    // employees report
    public function employees()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees');
        $data['path_url'] = 'reports_employees';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_designations'] = $this->Designation_model->all_designations();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('117', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/employees", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    // get company > departments
    public function get_departments()
    {

        $data['title'] = $this->Xin_model->site_title();
        $id = $this->uri->segment(4);

        $data = array(
            'company_id' => $id
        );
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/report_get_departments", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
    }

    // get departmens > designations
    public function designation()
    {

        $data['title'] = $this->Xin_model->site_title();
        $id = $this->uri->segment(4);

        $data = array(
            'department_id' => $id,
            'all_designations' => $this->Designation_model->all_designations(),
        );
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/report_get_designations", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
    }

    // reports > employee attendance
    public function employee_attendance()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_attendance_employee') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_reports_attendance_employee');
        $data['path_url'] = 'reports_employee_attendance';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/employee_attendance", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    // reports > employee leave
    public function employee_leave()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_leave_status') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_leave_status');
        $data['path_url'] = 'reports_employee_leave';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('31', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/employee_leave", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    // reports > employee training
    public function employee_training()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_training') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_hr_reports_training');
        $data['path_url'] = 'reports_employee_training';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('113', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/employee_training", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    // Validate and add info in database
    public function payslip_report()
    {

        if ($this->input->post('type') == 'payslip_report') {
            /* Define return | here result is used to return user data and error for error message */
            $Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
            $Return['csrf_hash'] = $this->security->get_csrf_hash();

            /* Server side PHP input validation */
            if ($this->input->post('company_id') === '') {
                $Return['error'] = $this->lang->line('error_company_field');
            } else if ($this->input->post('employee_id') === '') {
                $Return['error'] = $this->lang->line('xin_error_employee_id');
            } else if ($this->input->post('month_year') === '') {
                $Return['error'] = $this->lang->line('xin_hr_report_error_month_field');
            }

            if ($Return['error'] != '') {
                $this->output($Return);
            }
            $Return['result'] = $this->lang->line('xin_hr_request_submitted');
            $this->output($Return);
        }
    }

    public function role_employees_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/roles", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $roleId = $this->uri->segment(4);
        $employee = $this->Reports_model->get_roles_employees($roleId);

        $data = array();

        foreach ($employee->result() as $r) {

            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            // get status
            if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;
            // user role
            $role = $this->Xin_model->read_user_role_info($r->user_role_id);
            if (!is_null($role)) {
                $role_name = $role[0]->role_name;
            } else {
                $role_name = '--';
            }
            // get designation
            $designation = $this->Designation_model->read_designation_information($r->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }
            // department
            $department = $this->Department_model->read_department_information($r->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }
            $department_designation = $designation_name . ' (' . $department_name . ')';

            $data[] = array(
                $r->employee_id,
                $full_name,
                $comp_name,
                $r->email,
                $role_name,
                $department_designation,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function report_employees_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $department_id = $this->uri->segment(5);
        $designation_id = $this->uri->segment(6);
        $employee = $this->Reports_model->get_employees_reports($company_id, $department_id, $designation_id);

        $data = array();

        foreach ($employee->result() as $r) {

            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            // get status
            if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;
            // get designation
            $designation = $this->Designation_model->read_designation_information($r->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }
            // department
            $department = $this->Department_model->read_department_information($r->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }

            $data[] = array(
                $r->employee_id,
                $full_name,
                $comp_name,
                $r->email,
                $department_name,
                $designation_name,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function task_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/tasks", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $taskId = $this->uri->segment(4);
        $taskStatus = $this->uri->segment(5);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id == 1) {
            $tasks = $this->Reports_model->get_task_list($taskId, $taskStatus);
        } else {
            $tasks = $this->Timesheet_model->get_employee_tasks($session['user_id']);
        }
        $data = array();

        foreach ($tasks->result() as $r) {

            // get start date
            $start_date = $this->Xin_model->set_date_format($r->start_date);
            // get end date
            $end_date = $this->Xin_model->set_date_format($r->end_date);

            //status
            if ($r->task_status == 0) {
                $status = $this->lang->line('xin_not_started');
            } else if ($r->task_status == 1) {
                $status = $this->lang->line('xin_in_progress');
            } else if ($r->task_status == 2) {
                $status = $this->lang->line('xin_completed');
            } else {
                $status = $this->lang->line('xin_deffered');
            }

            //assigned user
            if ($r->assigned_to == '') {
                $ol = $this->lang->line('xin_not_assigned');
            } else {
                $ol = '';
                $assigned_names = array();
                foreach (explode(',', $r->assigned_to) as $desig_id) {
                    $assigned_to = $this->Xin_model->read_user_info($desig_id);
                    if (!is_null($assigned_to)) {

                        $assigned_names[] = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->last_name;
                        //  $ol .= '<li>'.$assigned_name.'</li>';
                    }

                    $ol = implode(', ', $assigned_names);
                }
            }
            // task category
            $task_catname = $r->task_name;
            $data[] = array(
                $task_catname, $start_date, $end_date, $ol, $status,
            );
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $tasks->num_rows(),
            "recordsFiltered" => $tasks->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }


    public function project_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/projects", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $projId = $this->uri->segment(4);
        $projStatus = $this->uri->segment(5);
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id == 1) {
            $project = $this->Reports_model->get_project_list($projId, $projStatus);
        } else {
            $project = $this->Project_model->get_employee_projects($session['user_id']);
        }
        $data = array();

        foreach ($project->result() as $r) {

            // get start date
            $start_date = $this->Xin_model->set_date_format($r->start_date);
            // get end date
            $end_date = $this->Xin_model->set_date_format($r->end_date);

            $pbar = '<p class="m-b-0-5">' . $this->lang->line('xin_completed') . ' ' . $r->project_progress . '%</p>';

            //status
            if ($r->status == 0) {
                $status = $this->lang->line('xin_not_started');
            } else if ($r->status == 1) {
                $status = $this->lang->line('xin_in_progress');
            } else if ($r->status == 2) {
                $status = $this->lang->line('xin_completed');
            } else {
                $status = $this->lang->line('xin_deffered');
            }

            // priority
            if ($r->priority == 1) {
                $priority = '<span class="tag tag-danger">' . $this->lang->line('xin_highest') . '</span>';
            } else if ($r->priority == 2) {
                $priority = '<span class="tag tag-danger">' . $this->lang->line('xin_high') . '</span>';
            } else if ($r->priority == 3) {
                $priority = '<span class="tag tag-primary">' . $this->lang->line('xin_normal') . '</span>';
            } else {
                $priority = '<span class="tag tag-success">' . $this->lang->line('xin_low') . '</span>';
            }

            //assigned user
            if ($r->assigned_to == '') {
                $ol = $this->lang->line('xin_not_assigned');
            } else {
                $ol = '';
                $assigned_names = array();
                foreach (explode(',', $r->assigned_to) as $desig_id) {
                    $assigned_to = $this->Xin_model->read_user_info($desig_id);
                    if (!is_null($assigned_to)) {

                        $assigned_names[] = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->last_name;
                        //  $ol .= $assigned_name."<br>";
                    }

                    $ol = implode(', ', $assigned_names);
                }
                $ol .= '';
            }
            $new_time = $this->Xin_model->actual_hours_timelog($r->project_id);

            //echo $new_time;
            $project_summary = '<div class="text-semibold"><a href="' . site_url() . 'admin/project/detail/' . $r->project_id . '">' . $r->title . '</a></div>';
            $data[] = array(
                $project_summary,
                $priority,
                $start_date,
                $end_date,
                $status,
                $pbar,
                $ol,
                $r->budget_hours,
                $new_time,

            );
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $project->num_rows(),
            "recordsFiltered" => $project->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function training_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employee_training", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $start_date = $this->uri->segment(4);
        $end_date = $this->uri->segment(5);
        $uid = $this->uri->segment(6);
        $cid = $this->uri->segment(7);

        $training = $this->Reports_model->get_training_list($cid, $start_date, $end_date);

        $data = array();

        foreach ($training->result() as $r) {

            $aim = explode(',', $r->employee_id);
            foreach ($aim as $dIds) {
                if ($uid == $dIds) {

                    // get training type
                    $type = $this->Training_model->read_training_type_information($r->training_type_id);
                    if (!is_null($type)) {
                        $itype = $type[0]->type;
                    } else {
                        $itype = '--';
                    }
                    // get trainer
                    /*$trainer = $this->Trainers_model->read_trainer_information($r->trainer_id);
		// trainer full name
		if(!is_null($trainer)){
			$trainer_name = $trainer[0]->first_name.' '.$trainer[0]->last_name;
		} else {
			$trainer_name = '--';	
		}*/
                    // get trainer
                    if ($r->trainer_option == 2) {
                        $trainer = $this->Trainers_model->read_trainer_information($r->trainer_id);
                        // trainer full name
                        if (!is_null($trainer)) {
                            $trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->last_name;
                        } else {
                            $trainer_name = '--';
                        }
                    } elseif ($r->trainer_option == 1) {
                        // get user > employee_
                        $trainer = $this->Xin_model->read_user_info($r->trainer_id);
                        // employee full name
                        if (!is_null($trainer)) {
                            $trainer_name = $trainer[0]->first_name . ' ' . $trainer[0]->last_name;
                        } else {
                            $trainer_name = '--';
                        }
                    } else {
                        $trainer_name = '--';
                    }
                    // get start date
                    $start_date = $this->Xin_model->set_date_format($r->start_date);
                    // get end date
                    $finish_date = $this->Xin_model->set_date_format($r->finish_date);
                    // training date
                    $training_date = $start_date . ' ' . $this->lang->line('dashboard_to') . ' ' . $finish_date;
                    // set currency
                    $training_cost = $this->Xin_model->company_currency_sign($r->training_cost,$r->company_id);
                    /* get Employee info*/
                    if ($uid == '') {
                        $ol = '--';
                    } else {
                        $user = $this->Exin_model->read_user_info($uid);
                        $fname = $user[0]->first_name . ' ' . $user[0]->last_name;
                    }
                    // status
                    if ($r->training_status == 0) : $status = $this->lang->line('xin_pending');
                    elseif ($r->training_status == 1) : $status = $this->lang->line('xin_started');
                    elseif ($r->training_status == 2) : $status = $this->lang->line('xin_completed');
                    else : $status = $this->lang->line('xin_terminated');
                    endif;

                    // get company
                    $company = $this->Xin_model->read_company_info($r->company_id);
                    if (!is_null($company)) {
                        $comp_name = $company[0]->name;
                    } else {
                        $comp_name = '--';
                    }

                    $data[] = array(
                        $comp_name,
                        $fname,
                        $itype,
                        $trainer_name,
                        $training_date,
                        $training_cost,
                        $status
                    );
                }
            }
        } // e- training

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $training->num_rows(),
            "recordsFiltered" => $training->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function  payroll_report_list()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/payroll", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $cid = $this->uri->segment(4);
        $eid = $this->uri->segment(5);
        $re_date = $this->uri->segment(6);


        $payslip_re = $this->Reports_model->get_payroll_list($cid, $eid, $re_date);

        $data = array();

        foreach ($payslip_re->result() as $r) {

            // get addd by > template
            $user = $this->Xin_model->read_user_info($r->employee_id);
            // user full name
            if (!is_null($user)) {
                $full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
                $emp_link = $user[0]->employee_id;

                $month_payment = date("F, Y", strtotime($r->salary_month));

                $p_amount = $this->Xin_model->company_currency_sign($r->net_salary,$r->company_id);
                if ($r->wages_type == 1) {
                    $payroll_type = $this->lang->line('xin_payroll_basic_salary');
                } else {
                    $payroll_type = $this->lang->line('xin_employee_daily_wages');
                }

                // get date > created at > and format
                $created_at = $this->Xin_model->set_date_format($r->created_at);

                $data[] = array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
            }
        } // if employee available

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $payslip_re->num_rows(),
            "recordsFiltered" => $payslip_re->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }
    // hourly_list > templates

    public function payslip_report_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/payslip", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $cid = $this->uri->segment(4);
        $eid = $this->uri->segment(5);
        $re_date = $this->uri->segment(6);


        $payslip_re = $this->Reports_model->get_payslip_list($cid, $eid, $re_date);

        $data = array();

        foreach ($payslip_re->result() as $r) {

            // get addd by > template
            $user = $this->Xin_model->read_user_info($r->employee_id);
            // user full name
            if (!is_null($user)) {
                $full_name = $user[0]->first_name . ' ' . $user[0]->last_name;
                $emp_link = $user[0]->employee_id;

                $month_payment = date("F, Y", strtotime($r->salary_month));

                $p_amount = $this->Xin_model->company_currency_sign($r->net_salary,$r->company_id);
                if ($r->wages_type == 1) {
                    $payroll_type = $this->lang->line('xin_payroll_basic_salary');
                } else {
                    $payroll_type = $this->lang->line('xin_employee_daily_wages');
                }

                // get date > created at > and format
                $created_at = $this->Xin_model->set_date_format($r->created_at);

                $data[] = array(
                    $emp_link,
                    $full_name,
                    $p_amount,
                    $month_payment,
                    $created_at,
                    $payroll_type
                );
            }
        } // if employee available

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $payslip_re->num_rows(),
            "recordsFiltered" => $payslip_re->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    // get company > employees
    public function get_employees()
    {

        $data['title'] = $this->Xin_model->site_title();
        $id = $this->uri->segment(4);

        $data = array(
            'company_id' => $id
        );
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/get_employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
    }

    //rahul update

    // get department > employees

    public function get_employees_depart()
    {



        $data['title'] = $this->Xin_model->site_title();

        $id = $this->uri->segment(4);

        $data = array(

            'department_id' => $id

        );

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/get_employees_depart", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));
    }

    public function get_location()
    {

        $data['title'] = $this->Xin_model->site_title();

        $id = $this->uri->segment(4);

        $data = array(

            'department_id' => $id

        );

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/get_location", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));
    }


    //company >> location
    public function get_com_location()
    {

        $data['title'] = $this->Xin_model->site_title();

        $id = $this->uri->segment(4);

        $data = array(

            'company_id' => $id

        );

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/get_com_location", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));
    }

    //employee >> leave type
    public function get_leave_type()
    {

        $data['title'] = $this->Xin_model->site_title();


        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/get_leave_type");
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));
    }


    public function get_employee_loca()
    {

        $data['title'] = $this->Xin_model->site_title();

        $id = $this->uri->segment(4);
        $department_id = $this->uri->segment(5);
        $data = array(

            'location_id' => $id,
            'department_id' => $department_id

        );

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/get_employee_loca", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));
    }


    public function get_status_dropdown()
    {

        $data['title'] = $this->Xin_model->site_title();

        $id = $this->uri->segment(4);

        $data = array(

            'any_id' => $id

        );

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/get_status_dropdown", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));
    }

    //rahul update end

    // get company > employees
    public function get_employees_att()
    {

        $data['title'] = $this->Xin_model->site_title();
        $id = $this->uri->segment(4);

        $data = array(
            'company_id' => $id
        );
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/get_employees_att", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
    }
    public function employee_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $id = $this->uri->segment(4);

        $data = array(
            'company_id' => $id
        );
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employee_get", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
    }
    //begin increment report

    public function empdtwise_increment_list()
    {
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $start_date = $this->input->get("start_date");
        $end_date = $this->input->get("end_date");

        $this->db->order_by('id', 'asc');
        $allowances = $this->db->get('allowance');

        $sql = "SELECT * FROM `xin_employee_salary_history` WHERE
                date >= '$start_date' AND date <= '$end_date' AND inc_amt > 0 AND inc_or_dec != ''";
        $progresses = $this->db->query($sql);
        $data = array();

        foreach ($progresses->result() as $progress) {
            $tmp = array();

            array_push($tmp, '<span class="text-nowrap">' . $progress->date . '</span>');

            $employee = $this->Xin_model->read_employee_info($progress->employee_id)[0];

            if (!empty($employee)) {
                $full_name = $employee->first_name . " " . $employee->last_name;
            } else {
                $full_name = '';
            }

            array_push($tmp, $full_name);

            $basic_salary = '';

            if ($progress->history_type == 1) {
                if ($progress->amount > 0) {
                    $basic_salary = number_format((float)$progress->amount, 2, '.', '');
                }
            }

            array_push($tmp, $basic_salary);

            $basic_salary_progress = '';

            if ($progress->history_type == 1) {
                if ($progress->inc_or_dec == 'inc') {
                    $basic_salary_progress = '<span class="text-nowrap">' . $progress->inc_amt . ' &#8593;</span>';
                } else if ($progress->inc_or_dec == 'dec') {
                    $basic_salary_progress = '<span class="text-nowrap">' . $progress->inc_amt . ' &#8595;</span>';
                }
            }

            array_push($tmp, $basic_salary_progress);

            foreach ($allowances->result() as $allowance) {
                if ($progress->history_type == 2) {
                    $this->db->where('allowance_id', $progress->allowance_id);
                    $salary_allowance = $this->db->get('xin_salary_allowances')->row();

                    if ($salary_allowance) {
                        if ($allowance->id == $salary_allowance->allowance_title) {
                            if ($progress->inc_or_dec == 'inc') {
                                $allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;</i>)</span>';
                            } else if ($progress->inc_or_dec == 'dec') {
                                $allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
                            }
                        } else {
                            $allowance_amount = '';
                        }
                    }
                } else if ($progress->history_type == 3) {
                    $this->db->where('statutory_deductions_id', $progress->allowance_id);
                    $salary_statutory_deduction = $this->db->get('xin_salary_statutory_deductions')->row();

                    if ($salary_statutory_deduction) {
                        if ($allowance->id == $salary_statutory_deduction->deduction_title) {
                            if ($progress->inc_or_dec == 'inc') {
                                $allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8593;</i>)</span>';
                            } else if ($progress->inc_or_dec == 'dec') {
                                $allowance_amount = '<span class="text-nowrap">' . $progress->amount . ' (' . $progress->inc_amt . ' &#8595;)</span>';
                            }
                        } else {
                            $allowance_amount = '';
                        }
                    }
                } else {
                    $allowance_amount = '';
                }

                array_push($tmp, $allowance_amount);
            }

            $data[] = $tmp;
        }

        // $data = array_values($data);

        $output = array(
            "draw" => $draw,
            "recordsTotal" => count($data),
            "recordsFiltered" => count($data),
            "data" => $data
        );

        echo json_encode($output);
        exit();
    }

    //end increment report
    // daily attendance list > timesheet
    public function empdtwise_attendance_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employee_attendance", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));


        $employee = $this->Xin_model->read_user_attendance_info();

        $data = array();

        foreach ($employee->result() as $r) {
            $data[] = array('', '', '', '', '', '', '', '');
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    // date wise attendance list > timesheet
    public function employee_date_wise_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $data1 = $_GET['start_date'];
        $data2 = $_GET['end_date'];


        $session = $this->session->userdata('username');
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if (!empty($session)) {
            $this->load->view("admin/reports/employee_attendance", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $employee_id = $this->input->get("user_id");
        //$employee = $this->Xin_model->read_user_info($employee_id);

        $employee = $this->Xin_model->read_user_info($employee_id);

        // get company
        $company = $this->Xin_model->read_company_info($employee[0]->company_id);
        if (!is_null($company)) {
            $comp_name = $company[0]->name;
        } else {
            $comp_name = '';
        }

        $start_date = new DateTime($this->input->get("start_date"));
        $end_date = new DateTime($this->input->get("end_date"));
        $end_date = $end_date->modify('+1 day');

        $interval_re = new DateInterval('P1D');
        $date_range = new DatePeriod($start_date, $interval_re, $end_date);
        $attendance_arr = array();

        $data = array();
        $totalTimeSeconds = 0;

        foreach ($date_range as $date) {
            $attendance_date =  $date->format("Y-m-d");

            $tdate = $attendance_date;
            $clkIn = $clkOut = $attendance_date;
            $clkInLast = $clkOutLast = '-';
            $status = '-';

            $this->db->where('employee_id', $employee_id);
            $this->db->where('attendance_date', $attendance_date);
            $this->db->order_by('time_attendance_id', 'asc');
            $attendance = $this->db->get('xin_attendance_time');

            if ($attendance->num_rows() > 0) {
                foreach ($attendance->result() as $att) {
                    if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
                        $status = $att->attendance_status;
                        $clkIn = $att->clock_in_time;
                        $clkOut = $att->clock_out_time;
                        break;
                    }
                }

                foreach ($attendance->result() as $att) {
                    if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
                        if ($clkInLast == '-')
                            $clkInLast = $att->clock_in_time;

                        $clkOutLast = $att->clock_out_time;
                    }
                }
            }

            $total_time_l = '-';
            $total_time_e = '-';
            $overtime2 = '-';
            $total_work = '-';
            $Trest = '-';

            $this->db->where('employee_id', $employee[0]->user_id);
            $this->db->where('date', $attendance_date);
            $totals = $this->db->get('xin_attendance_time_total');

            if ($totals->num_rows() > 0) {
                foreach ($totals->result() as $total) {
                    $total_time_l = $total->late;
                    $total_time_e = $total->early_leaving;
                    $overtime2 = $total->overtime;
                    $total_work = $total->work;
                    $Trest = $total->rest;
                }
            } else {
                $status = $this->Misc_model->get_leave_status($employee_id, $attendance_date, $this->input->get("start_date"), $this->input->get("end_date"), 'Absent');
            }

            $week_day = date('l', strtotime($attendance_date));
            $week_day_lower = strtolower($week_day);

            $table_field = $week_day_lower . '_in_time';
            $this->db->where('office_shift_id', $employee[0]->office_shift_id);
            $office_shift = $this->db->get('xin_office_shift')->row();

            if ($office_shift) {
                if (trim($office_shift->$table_field) == '') {
                    $status = 'Holiday';
                }
            }

            if ($status == 'Leave' || $status == 'Absent') {
                $clkInLast = $clkOutLast = '-';
            }

            if ($clkInLast != '-') {
                $clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
            }
            if ($clkOutLast != '-' && !is_null($clkOutLast)) {
                $clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
            }

            $time_arr = explode(':', $total_work);
            $total_workSeconds = 0;

            if (isset($time_arr[0])) {
                if (is_numeric($time_arr[0])) {
                    $total_workSeconds += $time_arr[0] * 3600;
                    $totalTimeSeconds += $time_arr[0] * 3600;
                }
            }

            if (isset($time_arr[1])) {
                if (is_numeric($time_arr[1])) {
                    $total_workSeconds += $time_arr[1] * 60;
                    $totalTimeSeconds += $time_arr[1] * 60;
                }
            }

            $data[] = array(
                $employee[0]->first_name . ' ' . $employee[0]->middle_name . ' ' . $employee[0]->last_name,
                $comp_name,
                $status,
                '<span class="text-nowrap">' . $tdate . '</span>',
                '<span class="text-nowrap">' . $clkInLast . '</span>',
                '<span class="text-nowrap">' . $clkOutLast . '</span>',
                $total_work,
                $total_workSeconds,
            );
        }

        $x = gmdate("H:i:s", $totalTimeSeconds);
        $v = array('total' => $x);
        $this->db->empty_table('get_total');
        $t = $this->Reports_model->in_t($v);

        $output = array(
            "draw" => $draw,
            // "recordsTotal" => count($date_range),
            //"recordsFiltered" => count($date_range),
            "data" => $data,
            "value" => $x,
        );

        echo json_encode($output);
        //$this->load->view("admin/reports/employee_attendance", $output);
        exit();
    }

    public function total_hour_calculate()
    {
    }

    public function employee_leave_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employee_leave", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $sd = $this->uri->segment(4);
        $ed = $this->uri->segment(5);
        $user_id = $this->uri->segment(6);
        $company_id = $this->uri->segment(7);
        if ($user_id == '') {
            $employee = $this->Reports_model->get_leave_application_list();
        } else {
            $employee = $this->Reports_model->get_leave_application_filter_list($sd, $ed, $user_id, $company_id);
        }
        $data = array();

        foreach ($employee->result() as $r) {

            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }
            $employee = $this->Xin_model->read_user_info($r->employee_id);
            // user full name 
            if (!is_null($employee)) {
                $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
            } else {
                $full_name = '--';
            }
            //approved leave
            $rapproved = $this->Reports_model->get_approved_leave_application_list($r->employee_id);
            $approved = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Approved" data-employee_id="' . $r->employee_id . '">' . $rapproved . ' ' . $this->lang->line('xin_view') . '</a>';
            // pending leave
            $rpending = $this->Reports_model->get_pending_leave_application_list($r->employee_id);
            $pending = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Pending" data-employee_id="' . $r->employee_id . '">' . $rpending . ' ' . $this->lang->line('xin_view') . '</a>';
            //upcoming leave
            $rupcoming = $this->Reports_model->get_upcoming_leave_application_list($r->employee_id);
            $upcoming = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Upcoming" data-employee_id="' . $r->employee_id . '">' . $rupcoming . ' ' . $this->lang->line('xin_view') . '</a>';
            //rejected leave
            $rrejected = $this->Reports_model->get_rejected_leave_application_list($r->employee_id);
            $rejected = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Rejected" data-employee_id="' . $r->employee_id . '">' . $rrejected . ' ' . $this->lang->line('xin_view') . '</a>';

            $data[] = array(
                $comp_name,
                $full_name,
                $approved,
                $pending,
                $upcoming,
                $rejected,
            );
        }
        $output = array(
            "draw" => $draw,
            //"recordsTotal" => $employee->num_rows(),
            //"recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }
    public function read_leave_details()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        $id = $this->input->get('employee_id');
        //$result = $this->Job_post_model->read_job_application_info($id);
        $data = 'A';
        if (!empty($session)) {
            $this->load->view('admin/reports/dialog_leave_details', $data);
        } else {
            redirect('admin/');
        }
    }
    public function payroll()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = 'Monthly Pay Sheet | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = 'Monthly Pay Sheet';

        $data['path_url'] = 'reports_payslip';

        $data['all_companies'] = $this->Xin_model->get_companies();

        $role_resources_ids = $this->Xin_model->user_role_resource();



        if (in_array('603', $role_resources_ids)) {

            $data['subview'] = $this->load->view("admin/reports/payroll", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard');
        }
    }

    public function payroll_report()
    {
        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');



        if (!empty($session)) {

            $this->load->view("admin/reports/payroll", $data);
        } else {

            redirect('admin/');
        }



        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));



        $aj_company = $_GET['aj_company'];
        $aj_department = $_GET['aj_department'];
        $location_id = $_GET['location_id'];
        $employee_id = $_GET['employee_id'];
        $month_year = $_GET['month_year'];
        $payslip_re = $this->Reports_model->get_payslip_report($aj_company, $aj_department, $location_id, $employee_id, $month_year);
        $data_filtered = array();



        $data = array();

        if (count($payslip_re) > 0) {

                        foreach ($payslip_re as $value) {
                $gross_deduction = $gross_earning = $gross_salary = $basic_salary_data = $total_ot_amount = 0;

                $employee = $this->Reports_model->read_employee_info($value->employee_id);

                if (!is_null($employee)) {

                    $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

                    $emp_id = $employee[0]->employee_id;

                    $date_of_joining = $employee[0]->date_of_joining;

                    $basic_salary = $employee[0]->basic_salary;
                } else {

                    $full_name = '--';

                    $emp_id = '--';

                    $date_of_joining = '--';

                    $basic_salary = '--';
                }

                $month_year = $month_year;

                $date = strtotime(date("Y-m-d"));

                if (!isset($month_year)) {

                    $day = date('d', $date);

                    $month = date('m', $date);

                    $year = date('Y', $date);

                    $month_year = date('Y-m');
                } else {

                    $imonth_year = explode('-', $month_year);

                    $day = date('d', $date);

                    $month = date($imonth_year[1], $date);

                    $year = date($imonth_year[0], $date);

                    $month_year = $month_year;
                }



                $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

                $start_date_y_m = date('Y-m', strtotime($month_year));

                $work_day = $this->Reports_model->work_day($year, $month);



                $emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);

                // if ($emp_leave_in_month != '') {

                //     $lop = $emp_leave_in_month[0]->monthly_leaves;
                // } else {

                //     $lop = '0';
                // }


                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }

                // get designation
                $designation = $this->Designation_model->read_designation_information($value->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }

                // Employee Account
                $account_id = $this->Reports_model->emp_bank_account($value->employee_id);
                if (!is_null($account_id)) {
                    $account_number = $account_id[0]->account_number;
                } else {
                    $account_number = '--';
                }



                //test
                $sql1 = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ?';
                $binds1 = array($value->employee_id);
                $payslip_allowance = $this->db->query($sql1, $binds1)->row();

                if (!empty($payslip_allowance)) {
                    $amount1 = $payslip_allowance->allowance_amount;
                } else {
                    $amount1 = '0';
                }

                $sql2 = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ?';
                $binds2 = array($value->employee_id);
                $payslip_commission = $this->db->query($sql2, $binds2)->row();

                if (!empty($payslip_commission)) {
                    $amount2 = $payslip_commission->commission_amount;
                } else {
                    $amount2 = '0';
                }

                $sql3 = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ?';
                $binds3 = array($value->employee_id);
                $payslip_other_payments = $this->db->query($sql3, $binds3)->row();

                if (!empty($payslip_other_payments)) {
                    $amount3 = $payslip_other_payments->payments_amount;
                } else {
                    $amount3 = '0';
                }

                $month_total_allo = $value->basic_salary + $amount1 + $amount2 + $amount3;


                $tmp = array(

                    $emp_id,

                    $full_name,

                    $department_name,

                    $designation_name,

                    $account_number,

                    $date_of_joining,

                    $value->net_salary,

                    $value->basic_salary,

                    $value->monthy_present_days

                );



                $gross_salary = $value->basic_salary;

                // Earning 

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        array_push(
                            $tmp,
                            $amount
                        );
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        array_push(
                            $tmp,
                            $amount
                        );
                    } else if ($allowance->type_id == 5) {

                        $sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();
                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary += $amount;
                        $gross_earning += $amount;

                        array_push(
                            $tmp,
                            $amount

                        );
                    }
                }
                
                if (!empty($value->total_overtime)) {
                    $ot_amount = $value->total_overtime;
                } else {
                    $ot_amount = 0;
                }

                if (!empty($value->amt_leave_encashment)) {
                    $leave_encashment = $value->amt_leave_encashment;
                } else {
                    $leave_encashment = 0;
                }

                if (!empty($value->amt_indemnity)) {
                    $indemnity = $value->amt_indemnity;
                } else {
                    $indemnity = 0;
                }
                $gross_earning += $ot_amount;
                $gross_earning += $leave_encashment;
                $gross_earning += $indemnity;

                array_push(
                    $tmp,
                    $ot_amount,
                    $leave_encashment,
                    $indemnity,
                    $gross_earning
                );

                // Deduction 
                $deductions = $this->db->get('allowance');
                foreach ($deductions->result() as $allowance) {

                    if ($allowance->type_id == 3) {

                        $sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;
                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        $gross_deduction += $amount;

                        array_push(
                            $tmp,
                            $amount

                        );
                    } else if ($allowance->type_id == 4) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

                        $binds = array($value->employee_id,$month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();
                        
                        
                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary -= $amount;
                        $gross_deduction += $amount;

                        array_push(
                            $tmp,
                            $amount

                        );
                    } 
                }

                //late deduction
                $emp_main_id = $value->employee_id;
                $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction;
                } else {
                    $late_deduction_data_get = 0;
                }

                // if (!empty($value->total_other_payments)) {
                //     $other_payment = $value->total_other_payments;
                // } else {
                //     $other_payment = 0;
                // }

                if (!empty($value->advance_salary_amount)) {
                    $advance_salary = $value->advance_salary_amount;
                } else {
                    $advance_salary = 0;
                }

                if (!empty($value->leave_deduction)) {
                    $leave_deduction = $value->leave_deduction;
                } else {
                    $leave_deduction = 0;
                }

                if (!empty($value->total_loan)) {
                    $loan_deduction = $value->total_loan;
                } else {
                    $loan_deduction = 0;
                }
              //  $gross_deduction += $lop;
                //$gross_deduction += $other_payment;
                $gross_deduction += $advance_salary;
                $gross_deduction += $late_deduction_data_get;
                $gross_deduction += $leave_deduction;
                $gross_deduction += $loan_deduction;
                
                $gross_deduction_get = number_format((float)$gross_deduction, 3, '.', '');

                array_push(
                    $tmp,

                   // $lop,

                    // $value->total_other_payments,

                    $value->advance_salary_amount,

                    $late_deduction_data_get,

                    $value->leave_deduction,

                    $loan_deduction,

                    $gross_deduction_get,

                    $value->net_salary

                );



                $data[] = $tmp;
            }

        }

        $output = array(

            "draw" => $draw,

            "recordsTotal" => count($data),

            "recordsFiltered" => count($data),

            "data" => $data

        );
        
        $output['csrf_hash'] = $this->security->get_csrf_hash();
        echo json_encode($output);
        exit();
    }

    public function monthly_paysheet_report_pdf()
    {
        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        
        $aj_company = $this->input->post('e_company_id');
        $aj_department = $this->input->post('e_department_id');
        $location_id = $this->input->post('e_location_id');
        $employee_id = $this->input->post('e_employee_id');
        $month_year = $this->input->post('e_month_year');
        
        if(!empty($aj_company)){
            $company_id_array = explode(',',$aj_company);
            $title_company_id = $company_id_array[0];
        } else{
            $title_company_id = $user[0]->company_id;
        }
        
        $company = $this->Xin_model->read_company_info($title_company_id);
        if (!is_null($company)) {
            $company_name = $company[0]->name;
            $company_logo = $company[0]->logo;
            $country = $this->Xin_model->read_country_info($company[0]->country);
            if (!is_null($country)) {
                $country_name = $country[0]->country_name;
            } else {
                $country_name = '--';
            }
            
            if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //  echo $logo;
            } else {
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
            }
        }else{
                $company_name = '';
                $country_name = '';
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
        }


        if (empty($session)) {
            redirect('admin/');
        }

  
        $payslip_re = $this->Reports_model->get_payslip_report($aj_company, $aj_department, $location_id, $employee_id, $month_year);
        $data_filtered = array();


        $data = array();

        if (count($payslip_re) > 0) {

                        foreach ($payslip_re as $value) {
                $gross_deduction = $gross_earning = $gross_salary = $basic_salary_data = $total_ot_amount = 0;

                $employee = $this->Reports_model->read_employee_info($value->employee_id);

                if (!is_null($employee)) {

                    $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

                    $emp_id = $employee[0]->employee_id;

                    $date_of_joining = $employee[0]->date_of_joining;

                    $basic_salary = $employee[0]->basic_salary;
                } else {

                    $full_name = '--';

                    $emp_id = '--';

                    $date_of_joining = '--';

                    $basic_salary = '--';
                }

                $month_year = $month_year;

                $date = strtotime(date("Y-m-d"));

                if (!isset($month_year)) {

                    $day = date('d', $date);

                    $month = date('m', $date);

                    $year = date('Y', $date);

                    $month_year = date('Y-m');
                } else {

                    $imonth_year = explode('-', $month_year);

                    $day = date('d', $date);

                    $month = date($imonth_year[1], $date);

                    $year = date($imonth_year[0], $date);

                    $month_year = $month_year;
                }



                $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

                $start_date_y_m = date('Y-m', strtotime($month_year));

                $work_day = $this->Reports_model->work_day($year, $month);



                $emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);

                // if ($emp_leave_in_month != '') {

                //     $lop = $emp_leave_in_month[0]->monthly_leaves;
                // } else {

                //     $lop = '0';
                // }


                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }

                // get designation
                $designation = $this->Designation_model->read_designation_information($value->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }

                // Employee Account
                $account_id = $this->Reports_model->emp_bank_account($value->employee_id);
                if (!is_null($account_id)) {
                    $account_number = $account_id[0]->account_number;
                } else {
                    $account_number = '--';
                }



                //test
                $sql1 = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ?';
                $binds1 = array($value->employee_id);
                $payslip_allowance = $this->db->query($sql1, $binds1)->row();

                if (!empty($payslip_allowance)) {
                    $amount1 = $payslip_allowance->allowance_amount;
                } else {
                    $amount1 = '0';
                }

                $sql2 = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ?';
                $binds2 = array($value->employee_id);
                $payslip_commission = $this->db->query($sql2, $binds2)->row();

                if (!empty($payslip_commission)) {
                    $amount2 = $payslip_commission->commission_amount;
                } else {
                    $amount2 = '0';
                }

                $sql3 = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ?';
                $binds3 = array($value->employee_id);
                $payslip_other_payments = $this->db->query($sql3, $binds3)->row();

                if (!empty($payslip_other_payments)) {
                    $amount3 = $payslip_other_payments->payments_amount;
                } else {
                    $amount3 = '0';
                }

                $month_total_allo = $value->basic_salary + $amount1 + $amount2 + $amount3;


                $tmp = array(

                    $emp_id,

                    $full_name,

                    $department_name,

                    $designation_name,

                    $account_number,

                    $date_of_joining,

                    $value->net_salary,

                    $value->basic_salary,

                    $value->monthy_present_days

                );



                $gross_salary = $value->basic_salary;

                // Earning 

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        array_push(
                            $tmp,
                            $amount
                        );
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        array_push(
                            $tmp,
                            $amount
                        );
                    } else if ($allowance->type_id == 5) {

                        $sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();
                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary += $amount;
                        $gross_earning += $amount;

                        array_push(
                            $tmp,
                            $amount

                        );
                    }
                }
                
                if (!empty($value->total_overtime)) {
                    $ot_amount = $value->total_overtime;
                } else {
                    $ot_amount = 0;
                }

                if (!empty($value->amt_leave_encashment)) {
                    $leave_encashment = $value->amt_leave_encashment;
                } else {
                    $leave_encashment = 0;
                }

                if (!empty($value->amt_indemnity)) {
                    $indemnity = $value->amt_indemnity;
                } else {
                    $indemnity = 0;
                }
                $gross_earning += $ot_amount;
                $gross_earning += $leave_encashment;
                $gross_earning += $indemnity;

                array_push(
                    $tmp,
                    $ot_amount,
                    $leave_encashment,
                    $indemnity,
                    $gross_earning
                );

                // Deduction 
                $deductions = $this->db->get('allowance');
                foreach ($deductions->result() as $allowance) {

                    if ($allowance->type_id == 3) {

                        $sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($value->employee_id,$allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;
                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        $gross_deduction += $amount;

                        array_push(
                            $tmp,
                            $amount

                        );
                    } else if ($allowance->type_id == 4) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_employees.user_id = ? and xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

                        $binds = array($value->employee_id,$month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();
                        
                        
                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary -= $amount;
                        $gross_deduction += $amount;

                        array_push(
                            $tmp,
                            $amount

                        );
                    } 
                }

                //late deduction
                $emp_main_id = $value->employee_id;
                $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction;
                } else {
                    $late_deduction_data_get = 0;
                }

                // if (!empty($value->total_other_payments)) {
                //     $other_payment = $value->total_other_payments;
                // } else {
                //     $other_payment = 0;
                // }

                if (!empty($value->advance_salary_amount)) {
                    $advance_salary = $value->advance_salary_amount;
                } else {
                    $advance_salary = 0;
                }

                if (!empty($value->leave_deduction)) {
                    $leave_deduction = $value->leave_deduction;
                } else {
                    $leave_deduction = 0;
                }

                if (!empty($value->total_loan)) {
                    $loan_deduction = $value->total_loan;
                } else {
                    $loan_deduction = 0;
                }
              //  $gross_deduction += $lop;
                //$gross_deduction += $other_payment;
                $gross_deduction += $advance_salary;
                $gross_deduction += $late_deduction_data_get;
                $gross_deduction += $leave_deduction;
                $gross_deduction += $loan_deduction;

                array_push(
                    $tmp,

                   // $lop,

                    // $value->total_other_payments,

                    $value->advance_salary_amount,

                    $late_deduction_data_get,

                    $value->leave_deduction,

                    $loan_deduction,

                    $gross_deduction,

                    $value->net_salary

                );



                $data[] = $tmp;
            }

        }

        $this->load->library('M_pdf');
        $mpdf = $this->m_pdf->load([
            'mode' => 'utf-8',
            'format' => 'A4',
            'orientation' => 'l'
        ]);
        $res['lists'] = $data;
        $res['month_year'] = $month_year;
        $res['company_name'] = $company_name;
        $res['logo'] = $logo;
        $res['country_name'] = $country_name;
        //$this->load->view("admin/reports/paysheet_pdf_format", $res);
        $html = $this->load->view("admin/reports/paysheet_pdf_format", $res, true);
        $mpdf->WriteHTML($html);
        $mpdf->Output('paysheet.pdf', 'D');
    }


    public function employee_annual_leave()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_annual_leave_status') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = $this->lang->line('xin_annual_leave_status');
        $data['path_url'] = 'reports_employee_leave_annual';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('31', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/employee_annual_leave", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    public function employee_annual_leave_list()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employee_annual_leave", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $sd = $this->uri->segment(4);
        $ed = $this->uri->segment(5);
        $user_id = $this->uri->segment(6);
        $company_id = $this->uri->segment(7);
        if ($user_id == '') {
            $employee = $this->Reports_model->get_annual_leave_application_list();
        } else {
            $employee = $this->Reports_model->get_annual_leave_application_filter_list($sd, $ed, $user_id, $company_id);
        }
        $data = array();
        foreach ($employee->result() as $r) {

            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }
            $employee = $this->Xin_model->read_user_info($r->employee_id);
            // user full name 
            if (!is_null($employee)) {
                $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
            } else {
                $full_name = '--';
            }
            //approved leave
            $rapproved = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 2);
            $approved = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Approved" data-employee_id="' . $r->employee_id . '">' . $rapproved . ' ' . $this->lang->line('xin_view') . '</a>';
            // pending leave
            $rpending = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 1);
            $pending = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Pending" data-employee_id="' . $r->employee_id . '">' . $rpending . ' ' . $this->lang->line('xin_view') . '</a>';
            //upcoming leave
            $rupcoming = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 4);
            $upcoming = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Upcoming" data-employee_id="' . $r->employee_id . '">' . $rupcoming . ' ' . $this->lang->line('xin_view') . '</a>';
            //rejected leave
            $rrejected = $this->Reports_model->get_status_annuval_leave_application_list($r->employee_id, 3);
            $rejected = '<a style="cursor:pointer" data-toggle="modal" data-target=".edit-modal-data" data-leave_opt="Rejected" data-employee_id="' . $r->employee_id . '">' . $rrejected . ' ' . $this->lang->line('xin_view') . '</a>';

            $data[] = array(
                $comp_name,
                $full_name,
                $approved,
                $pending,
                $upcoming,
                $rejected,
            );
        }
        $output = array(
            "draw" => $draw,
            //"recordsTotal" => $employee->num_rows(),
            //"recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function detailed_report()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_reports_attendance_employee') . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = 'Detailed  ' . $this->lang->line('xin_hr_reports_attendance_employee');
        $data['path_url'] = 'reports_detailed_attendance';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/detailed_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    public function employee_detailed_list()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if (!empty($session)) {
            $this->load->view("admin/reports/detailed_report", $data);
        } else {
            redirect('admin/');
        }
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $role_resources_ids = $this->Xin_model->user_role_resource();
        $attendance_date = $this->input->get("attendance_date");
        $ref_location_id = $this->input->get("location_id");
        $status_id = $this->input->get("status_id");
        // 		if($user_info[0]->user_role_id==1){
        // 			if($ref_location_id == 0) {
        // 				$employee = $this->Employees_model->get_attendance_employees();
        // 			} else {
        // 				$employee = $this->Employees_model->get_attendance_location_employees($ref_location_id);
        // 			}
        // 		} else {
        // 			if(in_array('397',$role_resources_ids)) {
        // 				$employee = $this->Xin_model->get_company_employees($user_info[0]->company_id);
        // 			} else {
        // 				$employee = $this->Xin_model->read_employee_info_att($session['user_id']);
        // 			}
        // 		}
        $employee_id = $this->input->get("user_id");
        $company_id = $this->input->get("company_id");
        if ($employee_id == 0) {
            $employee = $this->Xin_model->get_company_employees($company_id);
        } else if ($employee_id != 0) {
            $employee = $this->Xin_model->get_employees_com($employee_id, $company_id);
        }


        $system = $this->Xin_model->read_setting_info(1);
        //$data = array();
        $start_date = new DateTime($this->input->get("start_date"));
        $end_date = new DateTime($this->input->get("end_date"));
        $end_date = $end_date->modify('+1 day');

        $interval_re = new DateInterval('P1D');
        $date_range = new DatePeriod($start_date, $interval_re, $end_date);
        $attendance_arr = array();

        $data = array();
        $company_names = array();

        foreach ($employee->result() as $r) {
            if ($r->user_role_id == 1)
                continue;

            // user full name
            $full_name = $r->first_name . ' ' . $r->last_name;

            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '';
            }

            $employee_details = '<strong class="text-nowrap">' . $full_name . '</strong>';
            $employee_details .= '<br>';
            $employee_details .= '<span class="text-muted small text-truncate">' . $r->employee_id . '</span>';
            $employee_details .= '<br>';
            $employee_details .= '<span class="text-muted small text-nowrap">' . $comp_name . '</span>';

            $employee_id = $r->user_id;

            foreach ($date_range as $date) {
                $attendance_date =  $date->format("Y-m-d");

                $tdate = $attendance_date;
                $clkIn = $clkOut = $attendance_date;
                $clkInLast = $clkOutLast = '-';
                $status = '-';

                $this->db->where('employee_id', $employee_id);
                $this->db->where('attendance_date', $attendance_date);
                $this->db->order_by('time_attendance_id', 'asc');
                $attendance = $this->db->get('xin_attendance_time');

                if ($attendance->num_rows() > 0) {
                    foreach ($attendance->result() as $att) {
                        if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
                            $status = $att->attendance_status;
                            $clkIn = $att->clock_in_time;
                            $clkOut = $att->clock_out_time;
                            break;
                        }
                    }

                    foreach ($attendance->result() as $att) {
                        if ($att->clock_in_time != '0:00' && $att->clock_out_time != '0:00') {
                            if ($clkInLast == '-')
                                $clkInLast = $att->clock_in_time;

                            $clkOutLast = $att->clock_out_time;
                        }
                    }
                }

                $total_time_l = '-';
                $total_time_e = '-';
                $overtime2 = '-';
                $total_work = '-';
                $Trest = '-';

                $this->db->where('employee_id', $r->user_id);
                $this->db->where('date', $attendance_date);
                $totals = $this->db->get('xin_attendance_time_total');

                if ($totals->num_rows() > 0) {
                    foreach ($totals->result() as $total) {
                        $total_time_l = $total->late;
                        $total_time_e = $total->early_leaving;
                        $overtime2 = $total->overtime;
                        $total_work = $total->work;
                        $Trest = $total->rest;
                    }
                } else {
                    $status = $this->Misc_model->get_leave_status($employee_id, $attendance_date, $this->input->get("start_date"), $this->input->get("end_date"), $status_id);
                }

                $week_day = date('l', strtotime($attendance_date));
                $week_day_lower = strtolower($week_day);

                $table_field = $week_day_lower . '_in_time';
                $this->db->where('office_shift_id', $r->office_shift_id);
                $office_shift = $this->db->get('xin_office_shift')->row();

                if ($office_shift) {
                    if (trim($office_shift->$table_field) == '') {
                        $status = 'Holiday';
                    }
                }

                if ($status == 'Leave' || $status == 'Absent') {
                    $clkInLast = $clkOutLast = '-';
                }

                if ($clkInLast != '-') {
                    $clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
                }
                if ($clkOutLast != '-' && !is_null($clkOutLast)) {
                    $clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
                }

                $data[] = array(
                    $employee_details,
                    $status,
                    '<span class="text-nowrap">' . $tdate . '</span>',
                    '<span class="text-nowrap">' . $clkInLast . '</span>',
                    '<span class="text-nowrap">' . $clkOutLast . '</span>',
                    $total_time_l,
                    $total_time_e,
                    // $overtime2,
                    $total_work,
                    $Trest
                );
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function new_report()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = 'New Attendances Report' . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = 'Detailed  ' . 'New Attendances Report';
        $data['path_url'] = 'new_attendances_report';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/new_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    public function new_detailed_list()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if (!empty($session)) {
            $this->load->view("admin/reports/new_report", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $employee_id = $this->input->get("user_id");
        $company_id = $this->input->get("company_id");
        //$employee = $this->Xin_model->read_user_info($employee_id);

        //	$employee = $this->Xin_model->read_user_info($employee_id);

        if ($employee_id == 0) {
            $employee = $this->Xin_model->get_company_employees($company_id);
        } else if ($employee_id != 0) {
            $employee = $this->Xin_model->get_employees_com($employee_id, $company_id);
        }


        $data = array();
        $company_names = array();

        foreach ($employee->result() as $r) {
            $start_date = $this->input->get("start_date");
            $end_date = $this->input->get("end_date");
            $old_item = '';

            $getdatas = $this->Timesheet_model->get_datas($this->input->get("start_date"), $r->user_id, $this->input->get("end_date"));

            if ($r->user_role_id == 1)
                continue;

            foreach ($getdatas as $get_datas) {
                // user full name
                $full_name = $r->first_name . ' ' . $r->last_name;
                // get company
                if (!isset($company_names[$r->company_id])) {
                    $company = $this->Xin_model->read_company_info($r->company_id);
                    $company_names[$r->company_id] = $company[0]->name;
                }

                if (!is_null($company_names[$r->company_id])) {
                    $comp_name = $company_names[$r->company_id];
                } else {
                    $comp_name = '--';
                }
                $date = $get_datas->attendance_date;
                $timetable = $get_datas->timetable;
                if ($timetable == '') {
                    $time_table = '--';
                } else {
                    $time_table = $get_datas->timetable;
                }
                $onduty = $get_datas->on_duty;
                if ($onduty == '' || $onduty == 'Null') {
                    $on_duty = 'NULL';
                } else {
                    $on_duty = $get_datas->on_duty;
                }
                $offduty = $get_datas->off_duty;
                if ($offduty == '' || $offduty == 'Null') {
                    $off_duty = '--';
                } else {
                    $off_duty = $get_datas->off_duty;
                }
                $late = $get_datas->late;
                if ($late == '' || $late == 'Null') {
                    $late_time = '--';
                } else {
                    $late_time = $get_datas->late;
                }
                $absent = $get_datas->absent;
                if ($absent == '' || $absent == 'Null') {
                    $absent_time = '--';
                } elseif ($absent == '1') {
                    $absent_time = "TRUE";
                } else {
                    $absent_time = $get_datas->absent;
                }
                if ($absent_time == 'NULL')
                    $absent_time = '--';
                if ($get_datas->clock_in == '') {
                    $clock_in2 = '-';
                } else {
                    $clock_in = new DateTime($get_datas->clock_in); //print_r($get_datas->clock_in);
                    $splitTimeStamp = explode(" ", $get_datas->clock_in);
                    if ($splitTimeStamp[1] != '') {
                        $clock_in2 = $clock_in->format('h:i A');
                        $clkInIp = $clock_in2;
                    } elseif ($splitTimeStamp[1] == '') {
                        $clkInIp = '-';
                        $clock_in2 = '-';
                    } else {
                        $clock_in2 = '--';
                    }
                }
                if ($get_datas->clock_in == '') {
                    $clock_out2 = '-';
                } else {
                    $clock_out = new DateTime($get_datas->clock_out); //print_r($clock_in);
                    $split = explode(" ", $get_datas->clock_out);
                    if (isset($split[1])) {
                        $clock_out2 = $clock_out->format('h:i A');
                        $clkoutIp = $clock_out2;
                    } elseif (!isset($split[1])) {
                        $clkoutIp = '-';
                        $clock_out2 = '-';
                    } else {
                        $clock_out2 = '--';
                    }
                }

                $current_item = $r->user_id . "-" . $date;

                if ($current_item != $old_item) {
                    $this->db->where('employee_id', $r->user_id);
                    $this->db->where('date', $date);
                    $totals = $this->db->get('xin_attendance_time_total');

                    if ($totals->num_rows() > 0) {
                        foreach ($totals->result() as $total) {
                            $total_work = $total->work;
                            $late_time = $total->late;
                        }
                    }
                }

                if ($late_time == '00:00')
                    $late_time = '--';

                $old_item = $current_item;

                if ($clock_in2 != '-') {
                    if ($clock_out2 != '-') {
                        if (strtotime($clock_out2) <= strtotime($clock_in2)) {
                            $clock_out2 = '--';
                        }
                    }
                }

                $data[] = array(
                    $r->employee_code,
                    '<strong>' . $full_name . '</strong><br>
				<span class="small text-muted">' . $comp_name . '</span>',
                    '<span class="text-nowrap">' . $date . '</span>',
                    ucfirst($time_table),
                    $on_duty,
                    $off_duty,
                    '<span class="text-nowrap">' . $clock_in2 . '</span>',
                    '<span class="text-nowrap">' . $clock_out2 . '</span>',
                    //$total_work
                    $late_time,
                    $absent_time,
                );
            }
        }
        $output = array(
            "draw" => $draw,
            //"recordsTotal" => count($date_range),
            //"recordsFiltered" => count($date_range),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function leave_count_report()
    {
        $session = $this->session->userdata('username');

        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = 'Leave Count Report' . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = 'Detailed  ' . 'Leave Count Report';
        $data['path_url'] = 'new_attendances_report';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
        $role_resources_ids = $this->Xin_model->user_role_resource();

        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/leave_count_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function date_ranges($employee_id = 0)
    {
        $employee = $this->Employees_model->read_employee_information($employee_id)[0];
        $date_of_joining = $employee->date_of_joining;
        if ($employee->date_of_leaving) {
            $date_of_leaving = $employee->date_of_leaving;
        } else {
            $date_of_leaving = 0;
        }
        $date2 = '';
        $join_year = explode('-', $date_of_joining)[0];
        $date1 = $date_of_joining;
        $current_date = date('Y-m-d');
        $return = '<option value="">-- Select --</option>';

        for ($i = $join_year; $i < date('Y');) :
            $i++;
            $date2_time = strtotime('+1 year', strtotime($date1));
            $date2 = date('Y-m-d', $date2_time - 60 * 60 * 24);

            $return .= '<option value="' . $date1 . ':' . $date2 . '">' . $date1 . ' - ' . $date2 . '</option>';

            $date2 = date('Y-m-d', $date2_time);
            $date1 = $date2;
        endfor;
        if ($date_of_leaving != '0') {
            if (strtotime($date_of_leaving) <= strtotime($date2)) {
                $return .= '<option value="' . $date2 . ':' . $current_date . '">' . $date2 . ' - ' . $current_date . '</option>';
            } else {
                $return .= '<option value="' . $date2 . ':' . $date_of_leaving . '">' . $date2 . ' - ' . $date_of_leaving . '</option>';
            }
        } else if (strtotime($current_date) > strtotime($date2)) {
            $return .= '<option value="' . $date2 . ':' . $current_date . '">' . $date2 . ' - ' . $current_date . '</option>';
        } else if (strtotime($current_date) == strtotime($date2)) {
        }

        echo $return;
        exit;
    }

    public function assigned_leaves($employee_id, $year)
    {
        //$year = date('Y', strtotime($year));
        $splityear_range = explode(":", $year);
        // print_r($splityear_range);
        // exit();
        $date1 = $splityear_range[0];
        $date2 = $splityear_range[1];
        //$sql = "SELECT leave_type FROM `employee_leave` WHERE employee_id = '$employee_id' AND created_at LIKE '%$year%'";
        $sql = "SELECT leave_type FROM `employee_leave` WHERE employee_id = '$employee_id'  AND created_at >= '" . $date1 . "' AND created_at <='" . $date2 . "'";
        $assigned_leaves = $this->db->query($sql);
        $return = '<option value="">-- Select --</option>';

        foreach ($assigned_leaves->result() as $type) :
            $sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $type->leave_type;
            $type_info = $this->db->query($sql)->row();

            $return .= '<option value="' . $type->leave_type . '">' . $type_info->type_name . '</option>';
        endforeach;

        echo $return;
        exit;
    }

    public function list_leaves_assigned($employee_id, $year, $leave_type = 0)
    {
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $employee = $this->Employees_model->read_employee_information($employee_id)[0];

        // $year = date('Y', strtotime($year));
        $splityear_range = explode(":", $year);
        //   print_r($splityear_range);
        //   exit();
        $date1 = $splityear_range[0];
        $date2 = $splityear_range[1];
        //$sql = "SELECT * FROM `employee_leave` WHERE employee_id = $employee_id AND created_at LIKE '%$year%'";
        $sql = "SELECT * FROM `employee_leave` WHERE employee_id = $employee_id  AND created_at >= '" . $date1 . "' AND created_at <='" . $date2 . "'";
        if ($leave_type > 0)
            $sql .= " AND leave_type = $leave_type";

        $assigned_leaves = $this->db->query($sql);

        $data = array();

        foreach ($assigned_leaves->result() as $leave) {
            $sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $leave->leave_type;
            $type_info = $this->db->query($sql)->row();

            // $sql = "SELECT * FROM `carry_leaves` WHERE employee_id = $employee_id
            //         AND leave_type_id = ".$leave->leave_type."
            //         AND create_date LIKE '%$year%'";
            $sql = "SELECT * FROM `carry_leaves` WHERE employee_id = $employee_id
                    AND leave_type_id = " . $leave->leave_type . "
                    AND create_date >= '" . $date1 . "' AND create_date <='" . $date2 . "'";
            $carry_leave = $this->db->query($sql)->row();
            // if ($carry_leave)
            // {
            //     $remaing_leave_count = $carry_leave->remaing_leave_count;
            //     $leave_taken = $leave->leave_count - $remaing_leave_count;
            // }
            if ($carry_leave) {
                $remaing_leave_count = $carry_leave->remaing_leave_count;
                if ($leave->leave_count == '0') {
                    $sql = "SELECT COUNT(id) as absentcount FROM `carry_leaves` WHERE employee_id = $employee_id
                    AND leave_type_id = " . $leave->leave_type . "
                    AND create_date >= '" . $date1 . "' AND create_date <='" . $date2 . "'";
                    $count = $this->db->query($sql)->row();
                    $leave_taken = $count->absentcount;
                } else {
                    $leave_taken = $leave->leave_count - $remaing_leave_count;
                }
            } else {
                $leave_taken = 0; //$leave->leave_count;
                $remaing_leave_count = $leave->leave_count;
            }

            $this->db->where('company_id', $employee->company_id);
            $company = $this->db->get('xin_companies')->row();

            $company_name = '';

            if ($company)
                $company_name = $company->name;

            $data[] = array(
                '<strong>' . $employee->first_name . ' ' . $employee->middle_name . ' ' . $employee->last_name . '</strong>
                <br><small><i>' . $company_name . '</i></small>',
                '<span class="text-nowrap">' . $this->input->get('year_range') . '</span>',
                $type_info->type_name,
                $leave->leave_count,
                $leave_taken,
                $remaing_leave_count,
            );
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $assigned_leaves->num_rows(),
            "recordsFiltered" => $assigned_leaves->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function leave_report()
    {
        $session = $this->session->userdata('username');

        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = 'Leave Report' . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = 'Detailed  ' . 'Leave Report';
        $data['path_url'] = 'new_attendances_report';
        $data['get_all_companies'] = $this->Xin_model->get_companies();

        $role_resources_ids = $this->Xin_model->user_role_resource();

        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/leave_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function list_leave_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/leave_report", $data);
        } else {
            redirect('admin/');
        }
        $company_id = $this->input->get('company_id');
        $employee_id = $this->input->get('employee_id');
        $from_date = $this->input->get('from_date');
        $end_date = $this->input->get('end_date');

        // $this->db->where('company_id', $company_id);
        // if ($employee_id > 0)
        //     $this->db->where('employee_id', $employee_id);
        // if ($from_date != '')
        //     $this->db->where('from_date >=', $from_date);
        // if ($end_date != '')
        //     $this->db->where('to_date <=', $end_date);
        // $leaves = $this->db->get('xin_leave_applications');

        $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE company_id='" . $company_id . "' and employee_id='" . $employee_id . "' and from_date >='" . $from_date . "' and to_date<='" . $end_date . "'
        UNION ALL
        SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,Null AS reason from xin_annual_leave_applications WHERE company_id='" . $company_id . "' and employee_id='" . $employee_id . "' and from_date >='" . $from_date . "' and to_date<='" . $end_date . "'";
        $leaves = $this->db->query($sql);

        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $data = array();
        $employee_names = array();

        foreach ($leaves->result() as $leave) {
            if (!array_key_exists($leave->employee_id, $employee_names)) {
                $employee = $this->Employees_model->read_employee_information($leave->employee_id)[0];


                if ($employee)
                    $employee_names[$leave->employee_id] = $employee->first_name . ' ' . $employee->middle_name . ' ' . $employee->last_name;
                else
                    $employee_names[$leave->employee_id] = '--';
            }

            $this->db->where('company_id', $leave->company_id);
            $company = $this->db->get('xin_companies')->row();

            if ($company)
                $company_name = $company->name;
            else
                $company_name = '';

            $name = '<strong>' . $employee_names[$leave->employee_id] . '</strong>
            <br><small><i>' . $company_name . '</i><small>';

            $sql = "SELECT * FROM `xin_leave_type` WHERE leave_type_id = " . $leave->leave_type_id;
            $type_info = $this->db->query($sql)->row();
            $leave_type_name = '';

            if ($type_info)
                $leave_type_name = $type_info->type_name;

            $leave_type_name = $leave_type_name . '
            
            <br><small><i>Reason: ' . $leave->reason . '</i></small>
            <br><small><i>Remarks: ' . $leave->remarks . '</i></small>';

            if ($leave->status == 1)
                $status = 'Pending';
            else if ($leave->status == 2)
                $status = 'Approved';
            else
                $status = 'Rejected';

            $data[] = array(
                $name,
                $leave_type_name,
                $leave->from_date . ' - ' . $leave->to_date . '
                <br><small><i>Days: ' . $leave->days . '</i></small>',
                $status,
            );
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $leaves->num_rows(),
            "recordsFiltered" => $leaves->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }


    public function overtime_report()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = "Overtime Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Overtime Report";
        //$data['path_url'] = 'new_attendances_report';
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        //$data['get_emp_ot'] = $this->Timesheet_model->getemployees_overtime_details();
        $data['get_time'] = $this->Timesheet_model->get_timetable();

        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('608', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/reports/overtime_report", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/dashboard/');
            }
        } else {
            redirect('admin/dashboard');
        }

        /*$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = 'Overtime Report'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Detailed  '.'Overtime Report';
		$data['path_url'] = 'overtime_report';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if(in_array('112',$role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/reports/overtime_report", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}*/
    }



    public function overtime_datewise_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = "Overtime Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Overtime Report";
        $start_date  = $this->input->post('start_date');
        $end_date    = $this->input->post('end_date');
        $company_id  = $this->input->post('company_id');
        $employee_id = $this->input->post('employee_id');
        $data['start_date'] = $start_date;
        $data['end_date']   = $end_date;
        $data['company_id'] = $company_id;
        if ($employee_id == 0) {
            $data['get_all_companies'] = $this->Xin_model->get_companies();
            $data['get_emp_ot'] = $this->Timesheet_model->getallemployees_datewise_overtime_details($start_date, $end_date, $company_id);
        } else {
            $data['get_all_companies'] = $this->Xin_model->get_companies();
            $data['get_emp_ot'] = $this->Timesheet_model->getemployees_datewise_overtime_details($start_date, $end_date, $company_id, $employee_id);
        }
        /*$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['get_emp_ot'] = $this->Timesheet_model->get_employees_datewise_overtime_details($start_date,$end_date,$company_id,$employee_id);*/

        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('28', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/reports/overtime_report", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/dashboard/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function loan_report()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = "Loan Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Loan Report";
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $data['get_time'] = $this->Timesheet_model->get_timetable();

        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('28', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/reports/loan_report", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/dashboard/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function loan_datewise_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = "Loan Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Loan Report";
        $data['path_url'] = 'loan_detail';
        $start_date  = $this->input->post('start_date');
        $end_date    = $this->input->post('end_date');
        $company_id  = $this->input->post('company_id');
        $employee_id = $this->input->post('employee_id');
        $data['start_date'] = $start_date;
        $data['end_date']   = $end_date;
        $data['company_id'] = $company_id;
        if ($employee_id == 0) {
            $data['get_all_companies'] = $this->Xin_model->get_companies();
            $data['get_emp_loan'] = $this->Timesheet_model->getallemployees_datewise_loan_details($start_date, $end_date, $company_id);
        } else {
            $data['get_all_companies'] = $this->Xin_model->get_companies();
            $data['get_emp_loan'] = $this->Timesheet_model->getemployees_datewise_loan_details($start_date, $end_date, $company_id, $employee_id);
        }

        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('28', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/reports/loan_report", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/dashboard/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function read()

    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = $this->Xin_model->site_title();

        $id = $this->input->get('warning_id');

        if (!empty($session)) {

            $this->load->view('admin/warning/dialog_warning', $data);
        } else {

            redirect('admin/');
        }
    }

    public function dialog_salary_loan()
    {



        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = $this->Xin_model->site_title();

        $id = $this->input->get('field_id');

        $result = $this->Employees_model->read_single_loan_deductions($id);

        $data = array(

            'loan_deduction_id' => $result[0]->loan_deduction_id,

            'employee_id' => $result[0]->employee_id,

            'loan_deduction_title' => $result[0]->loan_deduction_title,

            'start_date' => $result[0]->start_date,

            'end_date' => $result[0]->end_date,

            'loan_options' => $result[0]->loan_options,

            'monthly_installment' => $result[0]->monthly_installment,

            'reason' => $result[0]->reason,

            'created_at' => $result[0]->created_at

        );

        if (!empty($session)) {

            $this->load->view('admin/reports/dialog_loan_details', $data);
        } else {

            redirect('admin/');
        }
    }

    public function advance_report()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = "Advance Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Advance Report";
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $data['get_time'] = $this->Timesheet_model->get_timetable();

        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('28', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/reports/advance_report", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/dashboard/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function advance_datewise_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Advance Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Advance Report";
        $data['path_url'] = 'advance_salary_report';
        $start_date  = $this->input->post('start_date');
        $end_date    = $this->input->post('end_date');
        $company_id  = $this->input->post('company_id');
        $employee_id = $this->input->post('employee_id');
        $data['start_date'] = $start_date;
        $data['end_date']   = $end_date;
        $data['company_id'] = $company_id;
        if ($employee_id == 0) {
            $data['get_all_companies'] = $this->Xin_model->get_companies();
            $data['get_emp_advance'] = $this->Timesheet_model->getallemployees_datewise_advance_details($start_date, $end_date, $company_id);
        } else {
            $data['get_all_companies'] = $this->Xin_model->get_companies();
            $data['get_emp_advance'] = $this->Timesheet_model->getemployees_datewise_advance_details($start_date, $end_date, $company_id, $employee_id);
        }

        $role_resources_ids = $this->Xin_model->user_role_resource();
        if (in_array('28', $role_resources_ids)) {
            if (!empty($session)) {
                $data['subview'] = $this->load->view("admin/reports/advance_report", $data, TRUE);
                $this->load->view('admin/layout/layout_main', $data); //page load
            } else {
                redirect('admin/dashboard/');
            }
        } else {
            redirect('admin/dashboard');
        }
    }

    public function advance_salary_report_read()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        $id = $this->input->get('employee_id');
        // $data['all_countries'] = $this->xin_model->get_countries();
        $result = $this->Payroll_model->advance_salaries_report_view($id);
        $data = array(
            'advance_salary_id' => $result[0]->advance_salary_id,
            'employee_id' => $result[0]->employee_id,
            'company_id' => $result[0]->company_id,
            'month_year' => $result[0]->month_year,
            'advance_amount' => $result[0]->advance_amount,
            'total_paid' => $result[0]->total_paid,
            'one_time_deduct' => $result[0]->one_time_deduct,
            'monthly_installment' => $result[0]->monthly_installment,
            'reason' => $result[0]->reason,
            'status' => $result[0]->status,
            'created_at' => $result[0]->created_at,
            'all_employees' => $this->Xin_model->all_employees(),
            'get_all_companies' => $this->Xin_model->get_companies()
        );
        if (!empty($session)) {
            $this->load->view('admin/payroll/dialog_advance_salary', $data);
        } else {
            redirect('admin/');
        }
    }


    public function payroll_status_report()
    {
        $session = $this->session->userdata('username');

        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = 'Payroll Status Report' . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = 'Payroll Status Report';
        $data['path_url'] = 'new_attendances_report';
        $data['get_all_companies'] = $this->Xin_model->get_companies();

        $role_resources_ids = $this->Xin_model->user_role_resource();

        if (in_array('112', $role_resources_ids)) {
            $data['subview'] = $this->load->view("admin/reports/payroll_status_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }
    public function list_payroll_status_report()
    {
        $company_id = $this->input->get('company_id');
        $employee_id = $this->input->get('employee_id');
        $from_date = $this->input->get('from_date');
        $end_date = $this->input->get('end_date');

        if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") == 0) {
            $payslip = $this->Employees_model->get_employees_payslip();
        } else if ($this->input->get("employee_id") == 0 && $this->input->get("company_id") != 0) {
            $payslip = $this->Payroll_model->get_comp_template($this->input->get("company_id"), 0);
        } else if ($this->input->get("employee_id") != 0 && $this->input->get("company_id") != 0) {
            $payslip = $this->Payroll_model->get_employee_comp_template($this->input->get("company_id"), $this->input->get("employee_id"));
        } else {
            $payslip = $this->Employees_model->get_employees_payslip();
        }





        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $data = array();
        $employee_names = array();

        $d1 = new DateTime($from_date);
        $d2 = new DateTime($end_date);
        $interval = $d1->diff($d2);
        $diffInMonths  = $interval->m + 1;

        $start_month = strtotime($from_date);
        $end_month = strtotime($end_date);
        $i = 1;
        while ($start_month <= $end_month) {

            foreach ($payslip->result() as $leave) {
                $emp_name = $leave->first_name . ' ' . $leave->middle_name . ' ' . $leave->last_name;

                $this->db->where('company_id', $leave->company_id);
                $company = $this->db->get('xin_companies')->row();

                if ($company)
                    $company_name = $company->name;
                else
                    $company_name = '';

                $name = '<strong>' . $emp_name . '</strong>
            <br><small><i>' . $company_name . '</i><small>';

                /*$this->db->where('company_id', $company_id);
            if ($employee_id > 0)
                $this->db->where('employee_id', $employee_id);
            if ($from_date != '')
                $this->db->where('salary_month >=', $from_date);
            if ($end_date != '')
                $this->db->where('salary_month <=', $end_date);
            $leaves = $this->db->get('xin_salary_payslips');
            */
                $p_date = date('Y-m', $start_month);
                $payroll_type = $payroll_type_normal = '';
                $payment_check = $this->Payroll_model->read_make_payment_payslip_check($leave->user_id, $p_date);
                if ($payment_check->num_rows() > 0) {
                    $make_payment = $this->Payroll_model->read_make_payment_payslip($leave->user_id, $p_date);
                    if ($make_payment[0]->annual_leave_amt) {
                        $payroll_type = 'Annual';
                    }
                    if ($make_payment[0]->monthy_present_days > 0) {
                        $payroll_type_normal = 'Normal';
                    }
                    $status = '<span class="label label-success">' . $this->lang->line('xin_payroll_paid') . '</span>';
                } else {
                    $annual_amt_pay = $anual_days_leave = 0;
                    $total_annual_leaves = $this->Employees_model->emp_total_annual_leaves_taken_not_paid($leave->user_id, $p_date);
                    if (!empty($total_annual_leaves[0]->id)) {
                        foreach ($total_annual_leaves as $tot_ann_levs) {
                            $annual_amt_pay += $tot_ann_levs->annua_amt;
                            $anual_days_leave += $tot_ann_levs->days;
                        }
                    }
                    if ($annual_amt_pay > 0) {
                        $payroll_type = 'Annual';
                    }
                    $month = date('m', $start_month);
                    $year = date('Y', $start_month);
                    $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
                    if ($annual_amt_pay < $daysInMonth) {
                        $payroll_type_normal = 'Normal';
                    }
                    $status = '<span class="label label-danger">' . $this->lang->line('xin_payroll_unpaid') . '</span>';
                }



                $data[] = array(
                    $name,
                    $status,
                    $payroll_type . ' ' . $payroll_type_normal,
                    $p_date,
                );
            }
            $start_month = strtotime("+1 month", $start_month);
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $payslip->num_rows(),
            "recordsFiltered" => $payslip->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }
    public function read_leave_details_annual()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->Xin_model->site_title();
        $id = $this->input->get('employee_id');
        //$result = $this->Job_post_model->read_job_application_info($id);
        $data = 'A';
        if (!empty($session)) {
            $this->load->view('admin/reports/dialog_leave_details_annual', $data);
        } else {
            redirect('admin/');
        }
    }



    //Edwin report section start

    public function monthly_pay_slip_page()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Monthly Pay Slip" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Monthly Pay Slip";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();
        $data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();
        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/monthly_pay_slip_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard/');
        }
    }

    public function monthly_pay_slip_report_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');


        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        // 	$location_company =$_GET['location'];
        // 	$comapny_id =$_GET['comapny_id'];
        // 	$emp_id =$_GET['employee'];
        // 	$department_id =$_GET['department_id'];
        // 	$re_date =$_GET['month_year'];
        $location_company = $this->input->get('location');
        $comapny_id = $this->input->get('comapny_id');
        $emp_id = $this->input->get('employee');
        $department_id = $this->input->get('department_id');
        $re_date = $this->input->get('month_year');
        // echo "$location_company"; 
        // echo "$comapny_id"; 
        // echo "$emp_id"; 
        // echo "$re_date"; 
        // echo "$department_id"; exit();
        $payslip_re = $this->Reports_model->monthly_payslip_get($re_date, $comapny_id, $department_id, $emp_id, $location_company);


        $data = array();
        foreach ($payslip_re->result() as $value) {

            // get designation
            $designation = $this->Designation_model->read_designation_information($value->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            // department
            $department = $this->Department_model->read_department_information($value->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }

            // Employee Account
            $account_id = $this->Reports_model->emp_bank_account($value->employee_id);
            if (!is_null($account_id)) {
                $bank_code = $account_id[0]->bank_code;
                $account_number = $account_id[0]->account_number;

                $bank_acc_details = $bank_code;
            } else {
                $bank_code = '--';
                $account_number = '--';
                $bank_acc_details = '--';
            }


            //get employee leave count
            // var_dump($emp_id);
            // var_dump($re_date);
            //var_dump($comapny_id);die();
            //print_r($value->employee_id);
            $employee_leave = $this->Reports_model->get_employee_leave_payslip($value->employee_id, $re_date, $value->company_id);
            //$employee_leave = $this->Reports_model->get_employee_leave_payslip($re_date);
            if (!is_null($employee_leave)) {
                $leave_count = $employee_leave;
            } else {
                $leave_count = '0';
            }

            $employee = $this->Reports_model->read_employee_info($value->employee_id);
            if (!is_null($employee)) {
                $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
                $emp_id = $employee[0]->employee_id;
                $date_of_joining = $employee[0]->date_of_joining;
                $basic_salary = $employee[0]->basic_salary;
            } else {
                $full_name = '--';
                $emp_id = '--';
                $date_of_joining = '--';
                $basic_salary = '--';
            }
            $month_year = $re_date;
            $date = strtotime(date("Y-m-d"));
            if (!isset($month_year)) {
                $day = date('d', $date);
                $month = date('m', $date);
                $year = date('Y', $date);
                $month_year = date('Y-m');
            } else {
                $imonth_year = explode('-', $month_year);
                $day = date('d', $date);
                $month = date($imonth_year[1], $date);
                $year = date($imonth_year[0], $date);
                $month_year = $month_year;
            }

            $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
            $start_date_y_m = date('Y-m', strtotime($month_year));
            $work_day = $this->Reports_model->work_day($year, $month);


            $emp_leave_in_month = $this->Reports_model->lop_days_get($value->employee_id, $year, $month);
            if ($emp_leave_in_month != '') {
                $lop = $emp_leave_in_month[0]->total_unpaid_count;
            } else {
                $lop = '0';
            }


            $gross_salary = $value->basic_salary;

            $allowances = $this->db->get('allowance');
            $earning_amount = $deduction_amount = 0;
            foreach ($allowances->result() as $allowance) {
                $data1 = '';
                //allowance type 1
                $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $payslip_allowance = $this->db->query($sql, $binds)->result();

                if (!empty($payslip_allowance)) {
                    foreach ($payslip_allowance as $get) {

                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get->allowance_title);
                        $payslip_allowance_name = $this->db->query($sql, $binds)->row();

                        $payslip_allowance_name = $payslip_allowance_name->name;
                        $space = "&#160;:&#160;";
                        $payslip_allowance_amt = $get->allowance_amount;

                        $data1 .= $payslip_allowance_name . $space . $payslip_allowance_amt . '<br/>';
                        $earning_amount += $payslip_allowance_amt;
                        $gross_salary += $payslip_allowance_amt;
                    }

                    //print_R($data1);exit;

                } else {

                    $data1 = "";
                    $payslip_allowance_amt = "0";
                }

                //allowance type 2
                $data2 = '';
                $sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $payslip_commission = $this->db->query($sql, $binds)->result();

                if (!empty($payslip_commission)) {
                    foreach ($payslip_commission as $get1) {

                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get1->commission_title);
                        $payslip_commission_name = $this->db->query($sql, $binds)->row();

                        $payslip_commission_name = $payslip_commission_name->name;
                        $space = "&#160;:&#160;";
                        $payslip_commission_amt = $get1->commission_amount;

                        $data2 .= $payslip_commission_name . $space . $payslip_commission_amt . '<br/>';

                        $earning_amount += $payslip_commission_amt;

                        $gross_salary += $payslip_commission_amt;
                    }
                } else {

                    $data2 = "";
                    $payslip_commission_amt = "0";
                }

                //allowance type 3
                $deduction_amount = 0;
                $data3 = '';
                $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $statutory_deduction = $this->db->query($sql, $binds)->result();

                if (!empty($statutory_deduction)) {
                    foreach ($statutory_deduction as $get2) {

                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get2->deduction_title);
                        $statutory_deduction_name = $this->db->query($sql, $binds)->row();

                        $statutory_deduction_name = $statutory_deduction_name->name;
                        $space = "&#160;:&#160;";
                        $statutory_deduction_amt = $get2->deduction_amount;

                        $data3 .= $statutory_deduction_name . $space . $statutory_deduction_amt . '<br/>';
                        $amount = $get2->deduction_amount;

                        $deduction_amount += $amount;

                        $gross_salary -= $amount;
                    }
                } else {

                    $data3 = "";
                    $statutory_deduction_amt = "0";
                }

                //allowance type 4
                $data5 = '';
                $sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';
        		$binds = array($value->employee_id, $month_year);
        		$payslip_other_payments = $this->db->query($sql, $binds)->result();
        		//echo $this->db->last_query();
        		if (!empty($payslip_other_payments)) {
                    foreach ($payslip_other_payments as $get4) {
                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get4->payments_title);
                        $payslip_other_name = $this->db->query($sql, $binds)->row();

                        $payslip_other_name = $payslip_other_name->name;
                        $space = "&#160;:&#160;";
                        $amount = $get4->payments_amount;

                        $deduction_amount += $amount;

                        $gross_salary -= $amount;

                        $data5 .= $payslip_other_name . $space . $amount . '<br/>';
                    }
                } else {

                    $data5 = "";
                    $amount = "0";
                }
        
                		/*if (! empty($payslip_other_payments)) {
                		    
                		    $sql = 'SELECT * FROM allowance WHERE id = ?';
                	    	$binds = array($payslip_other_payments->payments_title);
                		    $payslip_other_payments_name = $this->db->query($sql, $binds)->row();
                		
                		    $payslip_other_payments_name = $payslip_other_payments_name->name;
                		    $space = "&#160;:&#160;";
                		    $payslip_other_payments_amt = $payslip_other_payments->payments_amount;
                		    
                		    $data4 = $payslip_other_payments_name.$space.$payslip_other_payments_amt;
                		    $amount = $payslip_other_payments->payments_amount;
                		    $gross_salary += $amount;
                		    
                		}else{
                		
                		    $data4 = "";
                		    $payslip_other_payments_amt = "0";
                		    
                        }*/

                //allowance type 5
                
              /*  $sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $payslip_loan = $this->db->query($sql, $binds)->result();

                if (!empty($payslip_loan)) {
                    foreach ($payslip_loan as $get3) {

                        $payslip_loan_name = $get3->loan_title;
                        $space = "&#160;:&#160;";
                        $amount = $get3->loan_amount;

                        $deduction_amount += $amount;

                        $gross_salary -= $amount;

                        $data5 .= $payslip_loan_name . $space . $amount . '<br/>';
                    }
                } else {

                    $data5 .= "";
                    $amount = "0";
                } */
            }

            //Late Deduction
            $emp_id_get = $value->employee_id;
            $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_id_get";

            $late_deduction_data = $this->db->query($sql_late)->row();
            if (!empty($late_deduction_data)) {
                $late_deduction_data_get = $late_deduction_data->total_late_deduction;
            } else {
                $late_deduction_data_get = '0';
            }

            //Leave Deduction
            $leave_data = $value->leave_deduction;
            if (!empty($leave_data)) {
                $leave_amount = $leave_data;
            } else {
                $leave_amount = "0";
            }

            //overtime get
            $overtime_data = $value->total_overtime;
            if (!empty($overtime_data)) {
                $ot_amount = $overtime_data;
            } else {
                $ot_amount = "0";
            }

            //Advance Salary
            $adv_data = $value->advance_salary_amount;
            if (!empty($adv_data)) {
                $adv_amount = $adv_data;
            } else {
                $adv_amount = "0";
            }


            /*    $earning_details_total = $payslip_allowance_amt+$payslip_commission_amt;
                if($earning_details_total != '0'){
                    $earning_details_name = "Total Earnings";
                    $space = "&#160;:&#160;";
                    $earning_total = $earning_details_name.$space.$earning_details_total;
                }else{
                    $earning_total = "";
                }
                
                $deduction_details_total = $statutory_deduction_amt+$amount;
                if($deduction_details_total != '0'){
                    $deduction_details_name = "Total Deductions";
                    $space = "&#160;:&#160;";
                    $deduction_total = $deduction_details_name.$space.$deduction_details_total;
                }else{
                    $deduction_total = "";
                } */

            $basic_pay_name = "Basic Pay";
            $space = "&#160;:&#160;";
            $basic_pay = $value->basic_salary;
            $basic_amt = $basic_pay_name . $space . $basic_pay;

            $salary_period = "Monthly (1 to $daysInMonth)";
            
           
            
            if($value->total_loan != 0){
                 $loan = 'Loan : '.$value->total_loan;
            }else{
                 $loan = '';
            }
            
            if($value->total_other_payments != 0){
                 $total_other_payments = $value->total_other_payments;
            }else{
                 $total_other_payments = '';
            }

            $earning_details = $data1 . "" . $data2;

            $deduction_details = $data3 . "". $loan;

            /* $total_final_netpay = $basic_pay + $earning_details_total;
                
                $total_final_netpay1 = $total_final_netpay - $deduction_details_total;
                
                if($total_final_netpay != 0){
                    $total_final_netpay_get = $total_final_netpay1;
                }else{
                    $total_final_netpay_get = "0";
                } */

            $leave_count_get = $daysInMonth - $value->monthy_present_days;

            $data[] = array(
                $emp_id,
                $full_name,
                $department_name,
                $designation_name,
                $bank_acc_details,
                $account_number,
                $salary_period,
                $daysInMonth,
                $value->monthy_present_days,
                $leave_count,
                $lop,
                $basic_pay,
                "<b>" . $earning_details . "</b>",
                "<b>" . $deduction_details . "</b>",
                $total_other_payments,
                $late_deduction_data_get,
                $leave_amount,
                $ot_amount,
                $adv_amount,
                $value->net_salary
            );
        }

        $output = array(
            "draw" => $draw,
            "recordsTotal" => $payslip_re->num_rows(),
            "recordsFiltered" => $payslip_re->num_rows(),
            "data" => $data
        );

        $output['csrf_hash'] = $this->security->get_csrf_hash();
        echo json_encode($output);
        exit();
    }

    public function monthly_pay_slip_report_pdf()
    {

        error_reporting(E_ALL);
        ini_set("display_errors", "Off");
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $location_company = $this->input->post('e_location_id');
        $comapny_id = $this->input->post('e_company_id');
        $emp_id = $this->input->post('e_employee_id');
        $department_id = $this->input->post('e_department_id');
        $re_date = $this->input->post('e_month_year');
        $payslip_re = $this->Reports_model->monthly_payslip_get($re_date, $comapny_id, $department_id, $emp_id, $location_company);
        $data = array();

        if(!empty($comapny_id)){
            $company_id_array = explode(',',$comapny_id);
            $title_company_id = $company_id_array[0];
        } else{
            $title_company_id = $user[0]->company_id;
        }


        $company = $this->Xin_model->read_company_info($title_company_id);
        $system = $this->Xin_model->read_setting_info(1);

        $p_method = '';
        if (!is_null($company)) {
            $company_name = $company[0]->name;
            $address_1 = $company[0]->address_1;
            $address_2 = $company[0]->address_2;
            $city = $company[0]->city;
            $state = $company[0]->state;
            $company_logo = $company[0]->logo;
            $zipcode = $company[0]->zipcode;
            $country = $this->Xin_model->read_country_info($company[0]->country);
            if (!is_null($country)) {
                $country_name = $country[0]->country_name;
            } else {
                $country_name = '--';
            }
            $c_info_email = $company[0]->email;
            $c_info_phone = $company[0]->contact_number;
            if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
            } else {
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
            }
        } else {
            $company_name = '--';
            $address_1 = '--';
            $address_2 = '--';
            $city = '--';
            $state = '--';
            $zipcode = '--';
            $country_name = '--';
            $c_info_email = '--';
            $c_info_phone = '--';
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
        }

        $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

        $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


        foreach ($payslip_re->result() as $value) {

            // get designation
            $designation = $this->Designation_model->read_designation_information($value->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            // department
            $department = $this->Department_model->read_department_information($value->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }

            // Employee Account
            $account_id = $this->Reports_model->emp_bank_account($value->employee_id);
            if (!is_null($account_id)) {
                $bank_code = $account_id[0]->bank_code;
                $account_number = $account_id[0]->account_number;

                $bank_acc_details = $bank_code . " & " . $account_number;
            } else {
                $bank_code = '--';
                $account_number = '--';
                $bank_acc_details = '--';
            }
            //get employee leave count
            $employee_leave = $this->Reports_model->get_employee_leave_payslip($value->employee_id, $re_date, $value->company_id);
            //$employee_leave = $this->Reports_model->get_employee_leave_payslip($re_date);
            if (!is_null($employee_leave)) {
                $leave_count = $employee_leave;
            } else {
                $leave_count = '0';
            }

            $employee = $this->Reports_model->read_employee_info($value->employee_id);
            if (!is_null($employee)) {
                $office_shift_detail = $this->Reports_model->read_employee_office_shift($employee[0]->office_shift_id);
                $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
                $emp_id = $employee[0]->employee_id;
                $date_of_joining = $employee[0]->date_of_joining;
                $basic_salary = $employee[0]->basic_salary;
                $office_shift = $office_shift_detail[0]->shift_name;
            } else {
                $full_name = '--';
                $emp_id = '--';
                $date_of_joining = '--';
                $basic_salary = '--';
                $office_shift = '--';
            }
            $month_year = $re_date;
            $date = strtotime(date("Y-m-d"));
            if (!isset($month_year)) {
                $day = date('d', $date);
                $month = date('m', $date);
                $year = date('Y', $date);
                $month_year = date('Y-m');
            } else {
                $imonth_year = explode('-', $month_year);
                $day = date('d', $date);
                $month = date($imonth_year[1], $date);
                $year = date($imonth_year[0], $date);
                $month_year = $month_year;
            }

            $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));
            $start_date_y_m = date('Y-m', strtotime($month_year));
            $work_day = $this->Reports_model->work_day($year, $month);


            $emp_leave_in_month = $this->Reports_model->lop_days_get($value->employee_id, $year, $month);
            if ($emp_leave_in_month != '') {
                $lop = $emp_leave_in_month[0]->total_unpaid_count;
            } else {
                $lop = '--';
            }


            $gross_salary = $value->basic_salary;

            $allowances = $this->db->get('allowance');
            foreach ($allowances->result() as $allowance) {
                $data1 = '';
                $earning_amount = $deduction_amount = 0;

                //allowance type 1
                $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $payslip_allowance = $this->db->query($sql, $binds)->result();

                if (!empty($payslip_allowance)) {
                    foreach ($payslip_allowance as $get) {

                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get->allowance_title);
                        $payslip_allowance_name = $this->db->query($sql, $binds)->row();

                        $payslip_allowance_name = $payslip_allowance_name->name;
                        $space = "&#160;:&#160;";
                        $payslip_allowance_amt = $get->allowance_amount;
                        $data1 .= '<tr>
                  <td colspan="2">' . $payslip_allowance_name . '</td>
                  <td>' . $payslip_allowance_amt . '</td>
                  <td></td>';
                        $earning_amount = $earning_amount + $payslip_allowance_amt;
                        $gross_salary += $payslip_allowance_amt;
                    }
                } else {

                    $data1 = "";
                    $payslip_allowance_amt = "0";
                }

                //allowance type 2
                $data2 = '';
                $sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $payslip_commission = $this->db->query($sql, $binds)->result();

                if (!empty($payslip_commission)) {
                    foreach ($payslip_commission as $get1) {

                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get1->commission_title);
                        $payslip_commission_name = $this->db->query($sql, $binds)->row();

                        $payslip_commission_name = $payslip_commission_name->name;
                        $space = "&#160;:&#160;";
                        $payslip_commission_amt = $get1->commission_amount;
                        $data2 .= '<tr>
                  <td colspan="2">' . $payslip_commission_name . '</td>
                  <td>' . $payslip_commission_amt . '</td>
                  <td></td>';
                        $earning_amount = $earning_amount + $payslip_commission_amt;

                        $gross_salary += $payslip_commission_amt;
                    }
                } else {

                    $data2 = "";
                    $payslip_commission_amt = "0";
                }

                //allowance type 3
                $data3 = '';
                $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $statutory_deduction = $this->db->query($sql, $binds)->result();

                if (!empty($statutory_deduction)) {
                    foreach ($statutory_deduction as $get2) {

                        $sql = 'SELECT * FROM allowance WHERE id = ?';
                        $binds = array($get2->deduction_title);
                        $statutory_deduction_name = $this->db->query($sql, $binds)->row();

                        $statutory_deduction_name = $statutory_deduction_name->name;
                        $space = "&#160;:&#160;";
                        $statutory_deduction_amt = $get2->deduction_amount;
                        $data3 .= '<tr>
                  <td colspan="2">' . $statutory_deduction_name . '</td>
                  <td></td>
                  <td>' . $statutory_deduction_amt . '</td>';
                        $amount = $get2->deduction_amount;
                        $deduction_amount = $deduction_amount + $statutory_deduction_amt;

                        $gross_salary -= $amount;
                    }
                } else {

                    $data3 = "";
                    $statutory_deduction_amt = "0";
                }

                //allowance type 5
                $data5 = '';
                $sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';
                $binds = array($value->employee_id, $month_year);
                $payslip_loan = $this->db->query($sql, $binds)->result();

                if (!empty($payslip_loan)) {
                    foreach ($payslip_loan as $get3) {

                        $payslip_loan_name = $get3->loan_title;
                        $space = "&#160;:&#160;";
                        $amount = $get3->loan_amount;
                        $gross_salary -= $amount;
                        $deduction_amount = $deduction_amount + $amount;
                        $data5 .= '<tr>
                  <td colspan="2">' . $payslip_loan_name . '</td>
                  <td></td>
                  <td>' . $amount . '</td>';
                    }
                } else {

                    $data5 = "";
                    $amount = "0";
                }
            }
            
            
            //overtime get
            $basic_salary_data = $value->basic_salary;
            if (!empty($basic_salary_data)) {
                $basic_salary_data_get = $basic_salary_data;
            } else {
                $basic_salary_data_get = "0";
            }
            
            $earning_amount = $earning_amount + $basic_salary_data_get;
            $basic_salary_amt_get = '<tr>
                  <td colspan="2">Monthly Payslip </td>
                  <td>' . $basic_salary_data_get . '</td>
                  <td></td>';

            //Late Deduction
            $emp_id_get = $value->employee_id;
            $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_id_get";

            $late_deduction_data = $this->db->query($sql_late)->row();
            if (!empty($late_deduction_data)) {
                $late_deduction_data_get = $late_deduction_data->total_late_deduction;
            } else {
                $late_deduction_data_get = '0';
            }
            
            $deduction_amount = $deduction_amount + $late_deduction_data_get;
            
            $late_data = '<tr>
                  <td colspan="2">Late Deduction</td>
                  <td></td>
                  <td>' . $late_deduction_data_get . '</td>';

            //Leave Deduction
            $leave_data = $value->leave_deduction;
            if (!empty($leave_data)) {
                $leave_amount = $leave_data;
            } else {
                $leave_amount = "0";
            }
            
            $deduction_amount = $deduction_amount + $leave_amount;
            $leave_amount_data = '<tr>
                  <td colspan="2">Leave Deduction </td>
                  <td></td>
                  <td>' . $leave_amount . '</td>';

            //overtime get
            $overtime_data = $value->total_overtime;
            if (!empty($overtime_data)) {
                $ot_amount = $overtime_data;
            } else {
                $ot_amount = "0";
            }
            
            $earning_amount = $earning_amount + $ot_amount;
            $ot_amount_data = '<tr>
                  <td colspan="2">Overtime Amount </td>
                  <td>' . $ot_amount . '</td>
                  <td></td>';

            //Advance Salary
            $adv_data = $value->advance_salary_amount;
            if (!empty($adv_data)) {
                $adv_amount = $adv_data;
            } else {
                $adv_amount = "0";
            }
            
            $deduction_amount = $deduction_amount + $adv_amount;
            $adv_amount_data = '<tr>
                  <td colspan="2">Advance Deducted Salary</td>
                  <td></td>
                  <td>' . $adv_amount . '</td>';
                  
            if($value->total_loan != 0){
                 $loan = $value->total_loan;
            }else{
                 $loan = '0';
            }
            
            $deduction_amount = $deduction_amount + $loan;
            $loan_amount_data = '<tr>
                  <td colspan="2">Loan</td>
                  <td></td>
                  <td>' . $loan . '</td>';
                  
            if($value->total_other_payments != 0){
                 $total_other_payments = $value->total_other_payments;
            }else{
                 $total_other_payments = '0';
            } 
            
            $earning_amount = $earning_amount + $total_other_payments;
            $total_other_payments_get = '<tr>
                  <td colspan="2">Other Payments</td>
                  <td>' . $total_other_payments . '</td>
                  <td></td>';
                  
                  
            //-----------------------
            $tbl1_lv = "";
        $user_id = $value->employee_id;
        $count_leave = $this->Xin_model->count_total_leave_payslip($month_year,$user_id);
		if($count_leave > 0) {
			$tbl1_lv = '
			<table cellpadding="3" cellspacing="0" border="1">
				<tr bgcolor="#69e48a">
				<td colspan="4" align="center"><strong>Leave Details</strong></td>
				</tr>
				<tr bgcolor="#69e48a">
				<td>'.$this->lang->line('xin_leave_type').'</td>
				<td>'.$this->lang->line('xin_title_from').'</td>
				<td>'.$this->lang->line('xin_title_to').'</td>
				<td>'.$this->lang->line('xin_hrsale_total_days').'</td>
				</tr>';
				$res_leave = $this->Xin_model->res_total_leave_payslip($month_year,$user_id);
				foreach($res_leave as $rleave){
					// get leave type
					$leave_type = $this->Timesheet_model->read_leave_type_information($rleave->leave_type_id);
					if(!is_null($leave_type)){
						$type_name = $leave_type[0]->type_name;
					} else {
						$type_name = '--';	
					}
					$datetime1 = new DateTime($rleave->from_date);
					$datetime2 = new DateTime($rleave->to_date);
					$interval = $datetime1->diff($datetime2);
					if(strtotime($rleave->from_date) == strtotime($rleave->to_date)){
						$no_of_days =1;
					} else {
						$no_of_days = $interval->format('%a') + 1;
					}
				 if($rleave->is_half_day == 1){
					 $tbl1_lv .= '<tr>
						<td>'.$type_name.'</td>
						<td>'.$rleave->from_date.'</td>
						<td>'.$rleave->to_date.'</td>
						<td>'.$this->lang->line('xin_hr_leave_half_day').'</td>
					</tr>';
				 } else {
					$tbl1_lv .= '<tr>
						<td>'.$type_name.'</td>
						<td>'.$rleave->from_date.'</td>
						<td>'.$rleave->to_date.'</td>
						<td>'.$no_of_days.'</td>
					</tr>';
				 }
				}
				// Annual Leave
				$count_annual_leave = $this->Employees_model->count_employee_annual_leave_payslip($value->payslip_id);
				$leave_annual_det = $this->Employees_model->set_employee_leave_annual_payslip($value->payslip_id);
				if($count_annual_leave > 0){
					foreach($leave_annual_det->result() as $val){
					$tbl1_lv .= '<tr>
						<td>Annual Leave</td>
						<td>'.$val->from_date.'</td>
						<td>'.$val->to_date.'</td>
						<td>'.$val->days.'</td>
					</tr>';
					}
				}
				//
				

			$tbl1_lv .= '</table>';	
		}
            //-----------------------

            $basic_pay_name = "Basic Pay";
            $space = "&#160;:&#160;";
            $basic_pay = $value->basic_salary;
            $basic_amt = $basic_pay_name . $space . $basic_pay;

            $salary_period = "Monthly (1 to $daysInMonth)";

            $leave_count_get = $daysInMonth - $value->monthy_present_days;
            $earning_details = $data1 . "" . $data2;

            $deduction_details = $data3 . "" . $data5;
            $data[] = array(
                "employee_id" => $emp_id,
                "full_name" => $full_name,
                "date_of_joining" => $date_of_joining,
                "office_shift" => $office_shift,
                "department_name" => $department_name,
                "designation_name" => $designation_name,
                "bank_acc_details" => $bank_acc_details,
                "salary_period" => $salary_period,
                "daysInMonth" => $daysInMonth,
                "monthy_present_days" => $value->monthy_present_days,
                "leave_count" => $leave_count,
                "lop" => $lop,
                "basic_pay" => $basic_pay,
                "earning_details" => $earning_details,
                "deduction_details" => $deduction_details,
                "late_deduction_data_get" => $late_data,
                "leave_amount" => $leave_amount_data,
                "ot_amount" => $ot_amount_data,
                "adv_amount" => $adv_amount_data,
                "loan_amount" => $loan_amount_data,
                "earning_amount" => $earning_amount,
                "total_other_payments_get" => $total_other_payments_get,
                "basic_salary_amt_get" => $basic_salary_amt_get,
                "deduction_amount" => $deduction_amount,
                "tbl1_lv" => $tbl1_lv,
                "net_salary" => $value->net_salary,
            );
        }

        $this->load->library('M_pdf');
        $mpdf = $this->m_pdf->load([
            'mode' => 'utf-8',
            'format' => 'A4'
        ]);
        $res['lists'] = $data;
        $res['month_year'] = $re_date;
        $res['header_string'] = $email_phone_address;
        $res['company_name'] = $company_name;
        $res['logo'] = $logo;
        $html = $this->load->view("admin/reports/payslip_pdf_format", $res, true);
        $mpdf->WriteHTML($html);
        $mpdf->Output('payslip.pdf', 'D');
    }

    public function monthly_payroll_summary_page()
    {



        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }



        $data['title'] = "Monthly Payroll Summary" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Monthly Payroll Summary";

        $data['all_companies'] = $this->Xin_model->get_companies();

        $data['all_departments'] = $this->Department_model->all_departments();

        $data['all_employees'] = $this->Xin_model->all_employees();

        $data['all_location'] = $this->Location_model->all_office_locations();

        $data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/monthly_payroll_summary_report", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function monthly_payroll_summary_report_get()
    {
        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/employees", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));



        $company_id = $_GET['company_id'];

        $location_company = $_GET['location_company'];

        $department_id = $_GET['department_id'];

        $emp_id = $_GET['emp_id'];

        $month_year = $_GET['month_year'];


        $monthly_payroll_summary = $this->Reports_model->monthly_payroll_summary_get($company_id, $location_company, $department_id, $emp_id, $month_year);

        $data_filtered = array();

        $data = array();

        if (count($monthly_payroll_summary) > 0) {
            foreach ($monthly_payroll_summary as $value) {
                $gross_deduction = $gross_earning = $gross_salary = $basic_salary_data = $total_ot_amount = 0;

                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }


                //get head count
                $head_count = $this->Reports_model->get_head_count($emp_id, $value->department_id, $month_year);
                if (!is_null($head_count)) {
                    $head_count_get = $head_count[0]->headcount;
                } else {
                    $head_count_get = 0;
                }

                //get basic salary
                $basic_salary = $this->Reports_model->get_basic_salary($emp_id, $value->department_id, $month_year);
                if (!is_null($basic_salary)) {
                    $basic_salary_data = $basic_salary[0]->total_salary;
                } else {
                    $basic_salary_data = 0;
                }

                $tmp = array(
                    $department_name,
                    $head_count_get,
                    $basic_salary_data,
                );


                $allowances = $this->db->get('allowance');
                
                if($emp_id!='')
                {
                    $employee_str="AND xin_employees.user_id IN($emp_id)";
                }else{
                    $employee_str="";
                }
                
                if($emp_id!='')
                {
                    $employee_str2="AND xin_salary_payslips.employee_id IN($emp_id)";
                }else{
                    $employee_str2="";
                }

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {
                        

                        $sql = "SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        
                        
                        array_push(
                            $tmp,
                            $amount
                        );
                    } else if ($allowance->type_id == 2) {

                        $sql = "SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        
                        array_push(
                            $tmp,
                            $amount
                        );
                    }
                      
                    
                    else if ($allowance->type_id == 5) {

                        $sql = "SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        
                        

                        array_push(
                            $tmp,
                            $amount

                        );
                    }
                }

                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                $overtime_data = $this->db->query($sql_ot)->row();

                if (!empty($overtime_data)) {
                    $ot_amount = $overtime_data->total_ot_amt;
                } else {
                    $ot_amount = 0;
                }
                
                        
                
                 //other payments get
                // $sql_op = "SELECT SUM(total_other_payments) as total_other_payments FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                // $other_payments_data = $this->db->query($sql_op)->row();

                // if (!empty($other_payments_data)) {
                //     $other_payments_get = $other_payments_data->total_other_payments;
                // } else {
                //     $other_payments_get = 0;
                // }
                

                $gross_earning += $ot_amount;
                
                //$gross_earning += $other_payments_get;
                
                $gross_earning_get = number_format((float)$gross_earning, 3, '.', '');
                
                //$other_payments_get_data = number_format((float)$other_payments_get, 2, '.', '');

                array_push(
                    $tmp,
                    $ot_amount,
                    // $other_payments_get_data,
                    $gross_earning_get
                );


                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 3) {

                        $sql = "SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;
                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        $gross_deduction += $amount;
                        
                        

                        array_push(
                            $tmp,
                            $amount

                        );
                    } else if ($allowance->type_id == 4) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary -= $amount;
                        $gross_deduction += $amount;
                        
                        

                        array_push(
                            $tmp,
                            $amount

                        );
                    }
                }

                //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                } else {
                    $late_deduction_data_get = 0;
                }
                
                //loan Deduction
                $sql_loan = "SELECT SUM(total_loan) as total_loan FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";

                $loan_data = $this->db->query($sql_loan)->row();
                if (!empty($loan_data)) {
                    $loan_data_get = $loan_data->total_loan;
                } else {
                    $loan_data_get = 0;
                }

                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                $leave_data = $this->db->query($sql_leave)->row();

                if (!empty($leave_data)) {
                    $leave_amount = $leave_data->total_leave_deduction_amt;
                } else {
                    $leave_amount = 0;
                }

                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                $adv_data = $this->db->query($sql_adv)->row();

                if (!empty($adv_data)) {
                    $adv_amount = $adv_data->total_adv_amt;
                } else {
                    $adv_amount = 0;
                }
                
                       
                $late_deduction_get_val = number_format((float)$late_deduction_data_get, 2, '.', '');

                $gross_deduction += $late_deduction_get_val;
                $gross_deduction += $loan_data_get;
                $gross_deduction += $leave_amount;
                $gross_deduction += $adv_amount;

                $gross_deduction_get = round($gross_deduction, 3);
            
                array_push(
                    $tmp,
                    $late_deduction_get_val,
                    $loan_data_get,
                    $leave_amount,
                    $adv_amount,
                    $gross_deduction_get
                );



                //get net salary
                $gross_salary = $this->Reports_model->get_gross_salary($emp_id, $value->department_id, $month_year);
                if (!is_null($gross_salary)) {
                  $gross_net_salary_data = $gross_salary[0]->gross_salary;
                } else {
                  $gross_net_salary_data = '0';
                }
                
                $gross_net_salary_data_get = number_format((float)$gross_net_salary_data, 3, '.', '');

                array_push(
                    $tmp,
                    ($gross_net_salary_data_get)
                );


                $data[] = $tmp;
            }
        }


        $output = array(

            "draw" => $draw,

            "recordsTotal" => count($data),

            "recordsFiltered" => count($data),

            "data" => $data

        );

        $output['csrf_hash'] = $this->security->get_csrf_hash();
        echo json_encode($output);
        exit();
    }


    public function monthly_payroll_summary_report_pdf()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        
        $location_company = $this->input->post('e_location_id');
        $company_id = $this->input->post('e_company_id');
        $emp_id = $this->input->post('e_employee_id');
        $department_id = $this->input->post('e_department_id');
        $month_year = $this->input->post('e_month_year');
        
        
        $company = $this->Xin_model->read_company_info($company_id);
        $p_method = '';
        if (!is_null($company)) {
            $company_name = $company[0]->name;
            $country = $this->Xin_model->read_country_info($company[0]->country);
            if (!is_null($country)) {
                $country_name = $country[0]->country_name;
            } else {
                $country_name = '--';
            }
        } else {
            $company_name = '--';
            $country_name = '--';
        }
        
        $company_logo = $company[0]->logo;
        if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
            } else {
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
            }
            

        if (empty($session)) {
            redirect('admin/');
        }

        // Datatables Variables

       



        $monthly_payroll_summary = $this->Reports_model->monthly_payroll_summary_get($company_id, $location_company, $department_id, $emp_id, $month_year);

        $data_filtered = array();

        $data = array();

        if (count($monthly_payroll_summary) > 0) {
            foreach ($monthly_payroll_summary as $value) {
                $gross_deduction = $gross_earning = $gross_salary = $basic_salary_data = $total_ot_amount = 0;

                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }


                //get head count
                $head_count = $this->Reports_model->get_head_count($emp_id, $value->department_id, $month_year);
                if (!is_null($head_count)) {
                    $head_count_get = $head_count[0]->headcount;
                } else {
                    $head_count_get = 0;
                }

                //get basic salary
                $basic_salary = $this->Reports_model->get_basic_salary($emp_id, $value->department_id, $month_year);
                if (!is_null($basic_salary)) {
                    $basic_salary_data = $basic_salary[0]->total_salary;
                } else {
                    $basic_salary_data = 0;
                }

                $tmp = array(
                    $department_name,
                    $head_count_get,
                    $basic_salary_data,
                );

                


                $allowances = $this->db->get('allowance');
                
                if($emp_id!='')
                {
                    $employee_str="AND xin_employees.user_id IN($emp_id)";
                }else{
                    $employee_str="";
                }
                
                if($emp_id!='')
                {
                    $employee_str2="AND xin_salary_payslips.employee_id IN($emp_id)";
                }else{
                    $employee_str2="";
                }

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {
                        

                        $sql = "SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        
                        
                        array_push(
                            $tmp,
                            $amount
                        );
                    } else if ($allowance->type_id == 2) {

                        $sql = "SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        
                        array_push(
                            $tmp,
                            $amount
                        );
                    }
                      
                    
                    else if ($allowance->type_id == 5) {

                        $sql = "SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary += $amount;
                        $gross_earning += $amount;
                        
                        

                        array_push(
                            $tmp,
                            $amount

                        );
                    }
                }

                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                $overtime_data = $this->db->query($sql_ot)->row();

                if (!empty($overtime_data)) {
                    $ot_amount = $overtime_data->total_ot_amt;
                } else {
                    $ot_amount = 0;
                }
                
                        
                
                 //other payments get
                // $sql_op = "SELECT SUM(total_other_payments) as total_other_payments FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                // $other_payments_data = $this->db->query($sql_op)->row();

                // if (!empty($other_payments_data)) {
                //     $other_payments_get = $other_payments_data->total_other_payments;
                // } else {
                //     $other_payments_get = 0;
                // }
                

                $gross_earning += $ot_amount;
                
                //$gross_earning += $other_payments_get;
                
                $gross_earning_get = number_format((float)$gross_earning, 3, '.', '');
                
                //$other_payments_get_data = number_format((float)$other_payments_get, 2, '.', '');

                array_push(
                    $tmp,
                    $ot_amount,
                    // $other_payments_get_data,
                    $gross_earning_get
                );


                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 3) {

                        $sql = "SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;
                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        $gross_deduction += $amount;
                        
                        

                        array_push(
                            $tmp,
                            $amount

                        );
                    } else if ($allowance->type_id == 4) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ? $employee_str";

                        $binds = array($month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary -= $amount;
                        $gross_deduction += $amount;
                        
                        

                        array_push(
                            $tmp,
                            $amount

                        );
                    }
                }

                //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                } else {
                    $late_deduction_data_get = 0;
                }
                
                //loan Deduction
                $sql_loan = "SELECT SUM(total_loan) as total_loan FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";

                $loan_data = $this->db->query($sql_loan)->row();
                if (!empty($loan_data)) {
                    $loan_data_get = $loan_data->total_loan;
                } else {
                    $loan_data_get = 0;
                }

                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                $leave_data = $this->db->query($sql_leave)->row();

                if (!empty($leave_data)) {
                    $leave_amount = $leave_data->total_leave_deduction_amt;
                } else {
                    $leave_amount = 0;
                }

                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id $employee_str2";
                $adv_data = $this->db->query($sql_adv)->row();

                if (!empty($adv_data)) {
                    $adv_amount = $adv_data->total_adv_amt;
                } else {
                    $adv_amount = 0;
                }
                
                       
                $late_deduction_get_val = number_format((float)$late_deduction_data_get, 2, '.', '');

                $gross_deduction += $late_deduction_get_val;
                $gross_deduction += $loan_data_get;
                $gross_deduction += $leave_amount;
                $gross_deduction += $adv_amount;

                $gross_deduction_get = round($gross_deduction, 3);
            
                array_push(
                    $tmp,
                    $late_deduction_get_val,
                    $loan_data_get,
                    $leave_amount,
                    $adv_amount,
                    $gross_deduction_get
                );



                //get net salary
                $gross_salary = $this->Reports_model->get_gross_salary($emp_id, $value->department_id, $month_year);
                if (!is_null($gross_salary)) {
                  $gross_net_salary_data = $gross_salary[0]->gross_salary;
                } else {
                  $gross_net_salary_data = '0';
                }
                
                $gross_net_salary_data_get = number_format((float)$gross_net_salary_data, 2, '.', '');

                array_push(
                    $tmp,
                    ($gross_net_salary_data_get)
                );


                $data[] = $tmp;
            }
        }

        
        
        $this->load->library('M_pdf');
        $mpdf = $this->m_pdf->load([
            'mode' => 'utf-8',
            'format' => 'A4',
            'orientation' => 'l'
        ]);
        $res['lists'] = $data;
        $res['logo'] = $logo;
        $res['company_name'] = $company_name;
        $res['month_year'] = $month_year;
        $res['country_name'] = $country_name;
        //$this->load->view("admin/reports/payroll_summary_pdf_format", $res);

        $html = $this->load->view("admin/reports/payroll_summary_pdf_format", $res, true);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Monthly Payroll Summary.pdf', 'D');
    }


    //payroll reconciliation start
    public function payroll_reconciliation_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Payroll Reconciliation Report" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Payroll Reconciliation Report";

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/payroll_reconciliation_page", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function payroll_reconciliation_get()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/employees", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));

        $current_month_year = $_GET['current_month_year'];
        $compare_month_year = $_GET['compare_month_year'];

        $current_date = $current_month_year;
        $compare_date = $compare_month_year;

        //current date
        $month_year_cur = $current_date;
        $year_month_spilt_cur = explode("-", $month_year_cur);
        $year_cur = $year_month_spilt_cur[0];
        $month_cur = $year_month_spilt_cur[1];

        //month character decrease
        $monthName_cur = date("F", mktime(0, 0, 0, $month_cur, 1));
        $month_name_cur_get = substr($monthName_cur, 0, 3);

        $month_year_cur_get = $month_name_cur_get . ',' . $year_cur;

        //compare date
        $month_year_com = $compare_date;
        $year_month_spilt_com = explode("-", $month_year_com);
        $year_com = $year_month_spilt_com[0];
        $month_com = $year_month_spilt_com[1];

        //month character decrease
        $monthName_com = date("F", mktime(0, 0, 0, $month_com, 1));
        $month_name_com_get = substr($monthName_com, 0, 3);

        $month_year_com_get = $month_name_com_get . ',' . $year_com;

        $table = "";
        $table .= "<span class='card-header-title mr-2'><strong>Payroll Reconciliation Report (" . $month_year_cur_get . " To " . $month_year_com_get . ")</strong></span>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='payroll_reconciliation_report_datatable'>
		        <table class='datatables-demo table table-striped table-bordered' id='payroll_reconciliation_table_main'>";

        //---------------------table 1 basic salary list

        $table .= "<thead>
                      <tr><th colspan='6' style='text-align:center; border-right: 1px solid #eee;'>All Earnings List</th></tr>
                      <tr>
                      <th>Earning Description</th>
                      <th>Currency</th>
                      <th>" . $month_year_cur_get . "</th>
                      <th>" . $month_year_com_get . "</th>
                      <th>Variance</th>
                      <th style='border-right: 1px solid #eee;'>Variance %</th>
                      </tr>";

        $table .= "</thead><tbody>";


        $table .= "<tr>
                 <td>Basic Salary</td>
                 <td>Dirhams</td>";
        $basic_salary_get = $this->Reports_model->basic_salary_get($current_date);
        foreach ($basic_salary_get->result() as $get_basic_data) {

            if ($get_basic_data->total_basic_salary != '') {
                $table .= " <td>" . $get_basic_data->total_basic_salary . "</td>";
            } else {
                $table .= " <td>0</td>";
            }

            $compare_data_get = $this->Reports_model->compare_data_get($compare_date);
            foreach ($compare_data_get->result() as $get_compare_data) {

                if ($get_compare_data->total_compare_basic_salary != '') {
                    $table .= " <td>" . $get_compare_data->total_compare_basic_salary . "</td>";
                } else {
                    $table .= " <td>0</td>";
                }

                $variance = $get_basic_data->total_basic_salary - $get_compare_data->total_compare_basic_salary;


                if ($get_basic_data->total_basic_salary != 0) {
                    $total_basic_salary = $get_basic_data->total_basic_salary;
                } else {
                    $total_basic_salary = 1;
                }

                if ($variance != 0) {
                    $variance_data = $variance;
                } else {
                    $variance_data = 1;
                }

                $variance_percentage_1 = $variance_data / $total_basic_salary;
                $variance_percentage_final =  $variance_percentage_1 * 100;

                if ($get_basic_data->total_basic_salary == 0 && $variance == 0) {
                    $final_calu_basic_data = 0;
                } else {
                    $final_calu_basic_data = $variance_percentage_final;
                }

                $table .= "<td>" . $variance . "</td>
                  <td style='border-right: 1px solid #eee;'>" . round($final_calu_basic_data,3) . "</td>";
            }
        }

        $table .= "</tr> ";


        //----------------------- table 1 allowance list


        $sql1 = "SELECT * FROM allowance WHERE type_id = 1";
        $result1 = $this->db->query($sql1);


        foreach ($result1->result() as $value1) {
            $table .= "<tr>";

            $table .= " <td>" . $value1->name . "</td>";

            $allowance_name_id = $value1->id;

            $sql1 = "SELECT SUM(allowance_amount) as sum_score FROM xin_salary_payslip_allowances WHERE allowance_title = $allowance_name_id and salary_month = '$current_date'";
            $result2 = $this->db->query($sql1);

            foreach ($result2->result() as $value2) {

                $table .= "<td>Dirhams</td>";

                if ($value2->sum_score != '') {
                    $table .= " <td>" . $value2->sum_score . "</td>";
                } else {
                    $table .= " <td>0</td>";
                }


                $sql2 = "SELECT SUM(allowance_amount) as sum_score FROM xin_salary_payslip_allowances WHERE allowance_title = $allowance_name_id and salary_month = '$compare_date'";
                $result3 = $this->db->query($sql2);

                foreach ($result3->result() as $value3) {


                    if ($value3->sum_score != '') {
                        $table .= " <td>" . $value3->sum_score . "</td>";
                    } else {
                        $table .= " <td>0</td>";
                    }

                    $variance_allow = $value2->sum_score - $value3->sum_score;

                    if ($value2->sum_score != 0) {
                        $total_allow = $value2->sum_score;
                    } else {
                        $total_allow = 1;
                    }

                    if ($variance_allow != 0) {
                        $variance_data = $variance_allow;
                    } else {
                        $variance_data = 1;
                    }

                    $variance_allow_percentage_1 = $variance_data / $total_allow;
                    $variance_allow_percentage_final =  $variance_allow_percentage_1 * 100;

                    if ($value2->sum_score == 0 && $variance_allow == 0) {
                        $final_calu_allow_data = 0;
                    } else {
                        $final_calu_allow_data = $variance_allow_percentage_final;
                    }


                    $table .= "<td>" . $variance_allow . "</td> 
             <td style='border-right: 1px solid #eee;'>" . round($final_calu_allow_data,3) . "</td>";
                }
            }

            $table .= "</tr> ";
        }
        $table .= " </tbody>";
        //---------------------------

        //table 2 basic salary list

        $table .= "<thead>
                     <tr><th colspan='7' style='background-color: #fff;'></th></tr>
                      
                      <tr><th colspan='7' style='text-align:center; border-right: 1px solid #eee;'>Employees Wise Basic Salary List</th></tr>
                      <tr>
                          <th>Emp Code</th>
                          <th>Employee</th>
                          <th>Currency</th>
                          <th>" . $month_year_cur_get . "</th>
                          <th>" . $month_year_com_get . "</th>
                          <th>Variance</th>
                          <th style='border-right: 1px solid #eee;'>Variance %</th>
                      </tr></thead><tbody>";


        $basic_salary_details_get = $this->Reports_model->basic_salary_details_get($current_date);
        foreach ($basic_salary_details_get->result() as $details_get_basic_data) {

            $employee_main_id = $this->Reports_model->read_employee_info($details_get_basic_data->employee_id);
            if (!is_null($employee_main_id)) {
                $emp_id = $employee_main_id[0]->employee_id;
                $emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }


            $table .= "<tr>
                 <td>" . $emp_id . "</td>
                 <td>" . $emp_name . "</td>
                 <td>Dirhams</td>";

            if ($details_get_basic_data->basic_salary != '') {
                $table .= " <td>" . $details_get_basic_data->basic_salary . "</td>";
            } else {
                $table .= " <td>0</td>";
            }


            $compare_data_details_get = $this->Reports_model->compare_data_details_get($details_get_basic_data->employee_id, $compare_date);
            if (!is_null($compare_data_details_get)) {
                $compare_data_basic = $compare_data_details_get[0]->basic_salary;
            } else {
                $compare_data_basic = '0';
            }

            $table .= "<td>" . $compare_data_basic . "</td>";

            $detail_variance = $details_get_basic_data->basic_salary - $compare_data_basic;
            if ($details_get_basic_data->basic_salary != 0) {
                $details_total_basic_salary = $details_get_basic_data->basic_salary;
            } else {
                $details_total_basic_salary = 1;
            }

            if ($detail_variance != 0) {
                $detail_variance_data = $detail_variance;
            } else {
                $detail_variance_data = 1;
            }

            $variance_percentage_details = $detail_variance_data / $details_total_basic_salary;
            $variance_percentage_details_final =  $variance_percentage_details * 100;

            if ($details_get_basic_data->basic_salary == 0 && $detail_variance == 0) {
                $final_calu_basic_data_details = 0;
            } else {
                $final_calu_basic_data_details = $variance_percentage_details_final;
            }

            $table .= "<td>" . $detail_variance . "</td>
                  <td style='border-right: 1px solid #eee;'>" . round($final_calu_basic_data_details,3) . "</td>";

            $table .= "</tr> ";
        }


        //----------------------- allowance
        $table .= "<tr><th colspan='7'></th></tr>";

        $table .= "
                      <tr><th colspan='7' style='text-align:center; border-right: 1px solid #eee; background-color: #0747A3; color: white;'>Employees Wise Allowance and Deduction List</th></tr>
                      <tr>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>Emp Code</th>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>Employee</th>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>Currency</th>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>" . $month_year_cur_get . "</th>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>" . $month_year_com_get . "</th>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>Variance</th>
                      <th style='background-color: #0747A3; color: white; vertical-align: middle !important;'>Variance %</th>
                      </tr>";


        $sql112 = "SELECT * FROM allowance WHERE type_id = 1";
        $result112 = $this->db->query($sql112);
        foreach ($result112->result() as $value112) {
            
            $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Allowance Details : ".$value112->name."</th></tr>";
            $sql12 = "SELECT * FROM xin_salary_payslip_allowances WHERE salary_month = '$current_date' AND allowance_title = '$value112->id'";
            $result12 = $this->db->query($sql12);
            if(!empty($result12->result())){
                foreach ($result12->result() as $value12) {
                    $table .= "<tr>";
                    $employee_main_id_allo = $this->Reports_model->read_employee_info($value12->employee_id);
                    if (!is_null($employee_main_id_allo)) {
                        $emp_id = $employee_main_id_allo[0]->employee_id;
                        $emp_name = $employee_main_id_allo[0]->first_name . ' ' . $employee_main_id_allo[0]->last_name;
                    } else {
                        $emp_id = '--';
                        $emp_name = '--';
                    }
        
                    $table .= "<td>" . $emp_id . "</td>
                                 <td>" . $emp_name . "</td>
                                 <td>Dirhams</td>";
        
                    if ($value12->allowance_amount != '') {
                        $table .= " <td>" . $value12->allowance_amount . "</td>";
                    } else {
                        $table .= " <td>0</td>";
                    }
        
                    $compare_data_details_allo_get = $this->Reports_model->compare_data_details_allo_get($value12->employee_id, $compare_date);
                    if (!is_null($compare_data_details_allo_get)) {
                        $compare_data_basic_allo = $compare_data_details_allo_get[0]->allowance_amount;
                    } else {
                        $compare_data_basic_allo = '0';
                    }
        
                    $table .= "<td>" . $compare_data_basic_allo . "</td>";
        
                    $detail_variance_allo = $value12->allowance_amount - $compare_data_basic_allo;
        
                    if ($value12->allowance_amount != 0) {
                        $allo_total_basic_salary = $value12->allowance_amount;
                    } else {
                        $allo_total_basic_salary = 1;
                    }
        
                    if ($detail_variance_allo != 0) {
                        $allo_variance_data = $detail_variance_allo;
                    } else {
                        $allo_variance_data = 1;
                    }
        
                    $variance_percentage_allo = $allo_variance_data / $allo_total_basic_salary;
                    $variance_percentage_allo_final =  $variance_percentage_allo * 100;
        
                    if ($value12->allowance_amount == 0 && $detail_variance_allo == 0) {
                        $final_calu_basic_data_allo = 0;
                    } else {
                        $final_calu_basic_data_allo = $variance_percentage_allo_final;
                    }
        
                    $table .= "<td>" . $detail_variance_allo . "</td>
                          <td>" . round($final_calu_basic_data_allo,3) . "</td>";
        
                    $table .= "</tr>";
                }
            } else{
                 $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
            }
            
        }
        
        $table .= "<tr><th colspan='7'></th></tr>";
        //---------------------- commission
        
        $sql113 = "SELECT * FROM allowance WHERE type_id = 2";
        $result113 = $this->db->query($sql113);
         if(!empty($result113->result())){
            foreach ($result113->result() as $value113) {
                $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Commission Details : ".$value113->name."</th></tr>";
                $sql_com = "SELECT * FROM xin_salary_payslip_commissions WHERE salary_month = '$current_date' AND commission_title = '$value113->id'";
                $result_com = $this->db->query($sql_com);
                foreach ($result_com->result() as $value_com) {
                    $table .= "<tr>";
                    $employee_main_id_allo = $this->Reports_model->read_employee_info($value_com->employee_id);
                    if (!is_null($employee_main_id_allo)) {
                        $emp_id = $employee_main_id_allo[0]->employee_id;
                        $emp_name = $employee_main_id_allo[0]->first_name . ' ' . $employee_main_id_allo[0]->last_name;
                    } else {
                        $emp_id = '--';
                        $emp_name = '--';
                    }
        
                    $table .= "<td>" . $emp_id . "</td>
                                 <td>" . $emp_name . "</td>
                                 <td>Dirhams</td>";
        
                    if ($value_com->commission_amount != '') {
                        $table .= " <td>" . $value_com->commission_amount . "</td>";
                    } else {
                        $table .= " <td>0</td>";
                    }
        
                    $compare_data_details_com_get = $this->Reports_model->compare_data_details_com_get($value_com->employee_id, $compare_date);
                    if (!is_null($compare_data_details_com_get)) {
                        $compare_data_basic_com = $compare_data_details_com_get[0]->commission_amount;
                    } else {
                        $compare_data_basic_com = '0';
                    }
        
                    $table .= "<td>" . $compare_data_basic_com . "</td>";
        
                    $detail_variance_com = $value_com->commission_amount - $compare_data_basic_com;
        
                    if ($value_com->commission_amount != 0) {
                        $com_total_basic_salary = $value_com->commission_amount;
                    } else {
                        $com_total_basic_salary = 1;
                    }
        
                    if ($detail_variance_com != 0) {
                        $com_variance_data = $detail_variance_com;
                    } else {
                        $com_variance_data = 1;
                    }
        
                    $variance_percentage_com = $com_variance_data / $com_total_basic_salary;
                    $variance_percentage_com_final =  $variance_percentage_com * 100;
        
                    if ($value_com->commission_amount == 0 && $detail_variance_com == 0) {
                        $final_calu_basic_data_com = 0;
                    } else {
                        $final_calu_basic_data_com = $variance_percentage_com_final;
                    }
        
                    $table .= "<td>" . $detail_variance_com . "</td>
                          <td>" . round($final_calu_basic_data_com,3) . "</td>";
        
                    $table .= "</tr>";
                }
            
            }
            
         } else{
            $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
         }
        //---------------------- other payments
        $table .= "<tr><th colspan='7'></th></tr>";



        $sql114 = "SELECT * FROM allowance WHERE type_id = 5";
        $result114 = $this->db->query($sql114);
        if(!empty($result114->result())){
        foreach ($result114->result() as $value114) {
            $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Other Payment Details : ".$value114->name."</th></tr>";
            $sql_op = "SELECT * FROM xin_salary_payslip_other_payments WHERE salary_month = '$current_date' AND payments_title = '$value114->id'";
            $result_op = $this->db->query($sql_op);
            foreach ($result_op->result() as $value_op) {
                $table .= "<tr>";

                $employee_main_id_op = $this->Reports_model->read_employee_info($value_op->employee_id);
                if (!is_null($employee_main_id_op)) {
                    $emp_id = $employee_main_id_op[0]->employee_id;
                    $emp_name = $employee_main_id_op[0]->first_name . ' ' . $employee_main_id_op[0]->last_name;
                } else {
                    $emp_id = '--';
                    $emp_name = '--';
                }
    
                $table .= "<td>" . $emp_id . "</td>
                             <td>" . $emp_name . "</td>
                             <td>Dirhams</td>";
    
                if ($value_op->payments_amount != '') {
                    $table .= " <td>" . $value_op->payments_amount . "</td>";
                } else {
                    $table .= " <td>0</td>";
                }
    
                $compare_data_details_op_get = $this->Reports_model->compare_data_details_op_get($value_op->employee_id, $compare_date);
                if (!is_null($compare_data_details_op_get)) {
                    $compare_data_basic_op = $compare_data_details_op_get[0]->payments_amount;
                } else {
                    $compare_data_basic_op = '0';
                }
    
                $table .= "<td>" . $compare_data_basic_op . "</td>";
    
                $detail_variance_op = $value_op->payments_amount - $compare_data_basic_op;
    
                if ($value_op->payments_amount != 0) {
                    $op_total_basic_salary = $value_op->payments_amount;
                } else {
                    $op_total_basic_salary = 1;
                }
    
                if ($detail_variance_op != 0) {
                    $op_variance_data = $detail_variance_op;
                } else {
                    $op_variance_data = 1;
                }
    
                $variance_percentage_op = $op_variance_data / $op_total_basic_salary;
                $variance_percentage_op_final =  $variance_percentage_op * 100;
    
                if ($value_op->payments_amount == 0 && $detail_variance_op == 0) {
                    $final_calu_basic_data_op = 0;
                } else {
                    $final_calu_basic_data_op = $variance_percentage_op_final;
                }
    
                $table .= "<td>" . $detail_variance_op . "</td>
                      <td>" . round($final_calu_basic_data_op,3) . "</td>";
    
                $table .= "</tr>";
            }
        }
        } else{
             $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
         }
        //---------------------- statutory deductions
        $table .= "<tr><th colspan='7'></th></tr>";

        $sql115 = "SELECT * FROM allowance WHERE type_id = 3";
        $result115 = $this->db->query($sql115);
        if(!empty($result115->result())){
            foreach ($result115->result() as $value115) {
            $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Statutory Deductions Details : ".$value115->name."</th></tr>";
            $sql_sd = "SELECT * FROM xin_salary_payslip_statutory_deductions WHERE salary_month = '$current_date' AND deduction_title = '$value115->id'";
            $result_sd = $this->db->query($sql_sd);
            foreach ($result_sd->result() as $value_sd) {
                $table .= "<tr>";
                $employee_main_id_sd = $this->Reports_model->read_employee_info($value_sd->employee_id);
                if (!is_null($employee_main_id_sd)) {
                    $emp_id = $employee_main_id_sd[0]->employee_id;
                    $emp_name = $employee_main_id_sd[0]->first_name . ' ' . $employee_main_id_sd[0]->last_name;
                } else {
                    $emp_id = '--';
                    $emp_name = '--';
                }
    
                $table .= "<td>" . $emp_id . "</td>
                             <td>" . $emp_name . "</td>
                             <td>Dirhams</td>";
    
                if ($value_sd->deduction_amount != '') {
                    $table .= " <td>" . $value_sd->deduction_amount . "</td>";
                } else {
                    $table .= " <td>0</td>";
                }
    
                $compare_data_details_sd_get = $this->Reports_model->compare_data_details_sd_get($value_sd->employee_id, $compare_date);
                if (!is_null($compare_data_details_sd_get)) {
                    $compare_data_basic_sd = $compare_data_details_sd_get[0]->deduction_amount;
                } else {
                    $compare_data_basic_sd = '0';
                }
    
                $table .= "<td>" . $compare_data_basic_sd . "</td>";
    
                $detail_variance_sd = $value_sd->deduction_amount - $compare_data_basic_sd;
    
                if ($value_sd->deduction_amount != 0) {
                    $sd_total_basic_salary = $value_sd->deduction_amount;
                } else {
                    $sd_total_basic_salary = 1;
                }
    
                if ($detail_variance_sd != 0) {
                    $sd_variance_data = $detail_variance_sd;
                } else {
                    $sd_variance_data = 1;
                }
    
                $variance_percentage_sd = $sd_variance_data / $sd_total_basic_salary;
                $variance_percentage_sd_final =  $variance_percentage_sd * 100;
    
                if ($value_sd->deduction_amount == 0 && $detail_variance_sd == 0) {
                    $final_calu_basic_data_sd = 0;
                } else {
                    $final_calu_basic_data_sd = $variance_percentage_sd_final;
                }
    
                $table .= "<td>" . $detail_variance_sd . "</td>
                      <td>" . round($final_calu_basic_data_sd,3) . "</td>";
    
                $table .= "</tr>";
            }
        }
        } else{
             $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
        }
        //---------------------- payslip loan 
      /*  $table .= "<tr><th colspan='7'></th></tr>";


        $sql116 = "SELECT * FROM `xin_salary_payslip_loan` GROUP BY `loan_title`";
        $result116 = $this->db->query($sql116);
        foreach ($result116->result() as $value116) {
            $table .= "<tr><th colspan='7'>Loan Details : ".$value116->loan_title."</th></tr>";
            $sql_pl = "SELECT * FROM xin_salary_payslip_loan WHERE salary_month = '$current_date' AND loan_title = '$value116->loan_title'";
            $result_pl = $this->db->query($sql_pl);
            if(!empty($result_pl->result())){
        	    foreach ($result_pl->result() as $value_pl) {
        		$table .= "<tr>";
        
        			$employee_main_id_pl = $this->Reports_model->read_employee_info($value_pl->employee_id);
        			if (!is_null($employee_main_id_pl)) {
        			$emp_id = $employee_main_id_pl[0]->employee_id;
        			$emp_name = $employee_main_id_pl[0]->first_name . ' ' . $employee_main_id_pl[0]->last_name;
        			} else {
        			$emp_id = '--';
        			$emp_name = '--';
        			}
        
        			$table .= "<td>" . $emp_id . "</td>
        			<td>" . $emp_name . "</td>
        			<td>Dirhams</td>";
        
        			if ($value_pl->loan_amount != '') {
        			$table .= " <td>" . $value_pl->loan_amount . "</td>";
        			} else {
        			$table .= " <td>0</td>";
        			}
        
        			$compare_data_details_pl_get = $this->Reports_model->compare_data_details_pl_get($value_pl->employee_id, $compare_date);
        			if (!is_null($compare_data_details_pl_get)) {
        			$compare_data_basic_pl = $compare_data_details_pl_get[0]->loan_amount;
        			} else {
        			$compare_data_basic_pl = '0';
        			}
        
        			$table .= "<td>" . $compare_data_basic_pl . "</td>";
        
        			$detail_variance_pl = $value_pl->loan_amount - $compare_data_basic_pl;
        
        			if ($value_pl->loan_amount != 0) {
        			$pl_total_basic_salary = $value_pl->loan_amount;
        			} else {
        			$pl_total_basic_salary = 1;
        			}
        
        			if ($detail_variance_pl != 0) {
        			$pl_variance_data = $detail_variance_pl;
        			} else {
        			$pl_variance_data = 1;
        			}
        
        			$variance_percentage_pl = $pl_variance_data / $pl_total_basic_salary;
        			$variance_percentage_pl_final = $variance_percentage_pl * 100;
        
        			if ($value_pl->loan_amount == 0 && $detail_variance_pl == 0) {
        			$final_calu_basic_data_pl = 0;
        			} else {
        			$final_calu_basic_data_pl = $variance_percentage_pl_final;
        			}
        
        			$table .= "<td>" . $detail_variance_pl . "</td>
        			<td>" . round($final_calu_basic_data_pl,3) . "</td>";
        
        			$table .= "
        		</tr>";
        	}
            } else{
                $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
            }
        
        }*/
        
        
        
        //---------------------- late deduction
        $table .= "<tr><th colspan='7'></th></tr>";

        $sql_ld = "SELECT * FROM xin_salary_payslips WHERE salary_month = '$current_date'";
        $result_ld = $this->db->query($sql_ld);

        $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Late Details : Late Deduction</th></tr>";
        if(!empty($result_ld->result())){
            foreach ($result_ld->result() as $value_ld) {
            $table .= "<tr>";
            $employee_main_id_ld = $this->Reports_model->read_employee_info($value_ld->employee_id);
            if (!is_null($employee_main_id_ld)) {
                $emp_id = $employee_main_id_ld[0]->employee_id;
                $emp_name = $employee_main_id_ld[0]->first_name . ' ' . $employee_main_id_ld[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }

            $table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

            if ($value_ld->total_late_deduction != '') {
                $table .= " <td>" . $value_ld->total_late_deduction . "</td>";
            } else {
                $table .= " <td>0</td>";
            }

            $compare_data_details_ld_get = $this->Reports_model->compare_data_details_ld_get($value_ld->employee_id, $compare_date);
            if (!is_null($compare_data_details_ld_get)) {
                $compare_data_basic_ld = $compare_data_details_ld_get[0]->total_late_deduction;
            } else {
                $compare_data_basic_ld = '0';
            }

            $table .= "<td>" . $compare_data_basic_ld . "</td>";

            $detail_variance_ld = $value_ld->total_late_deduction - $compare_data_basic_ld;

            if ($value_ld->total_late_deduction != 0) {
                $ld_total_basic_salary = $value_ld->total_late_deduction;
            } else {
                $ld_total_basic_salary = 1;
            }

            if ($detail_variance_ld != 0) {
                $ld_variance_data = $detail_variance_ld;
            } else {
                $ld_variance_data = 1;
            }

            $variance_percentage_ld = $ld_variance_data / $ld_total_basic_salary;
            $variance_percentage_ld_final =  $variance_percentage_ld * 100;

            if ($value_ld->total_late_deduction == 0 && $detail_variance_ld == 0) {
                $final_calu_basic_data_ld = 0;
            } else {
                $final_calu_basic_data_ld = $variance_percentage_ld_final;
            }

            $table .= "<td>" . $detail_variance_ld . "</td>
                  <td>" . round($final_calu_basic_data_ld,3) . "</td>";

            $table .= "</tr>";
        }
        } else{
            $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
        }
        
        //---------------------- overtime
        $table .= "<tr><th colspan='7'></th></tr>";

        $sql_ot = "SELECT * FROM xin_salary_payslips WHERE salary_month = '$current_date'";
        $result_ot = $this->db->query($sql_ot);

        $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Overtime Details : Overtime</th></tr>";
        if(!empty($result_ot->result())){
            foreach ($result_ot->result() as $value_ot) {
            $table .= "<tr>";
            $employee_main_id_ot = $this->Reports_model->read_employee_info($value_ot->employee_id);
            if (!is_null($employee_main_id_ot)) {
                $emp_id = $employee_main_id_ot[0]->employee_id;
                $emp_name = $employee_main_id_ot[0]->first_name . ' ' . $employee_main_id_ot[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }

            $table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

            if ($value_ot->total_overtime != '') {
                $table .= " <td>" . $value_ot->total_overtime . "</td>";
            } else {
                $table .= " <td>0</td>";
            }

            $compare_data_details_ot_get = $this->Reports_model->compare_data_details_ld_get($value_ot->employee_id, $compare_date);
            if (!is_null($compare_data_details_ot_get)) {
                $compare_data_basic_ot = $compare_data_details_ot_get[0]->total_overtime;
            } else {
                $compare_data_basic_ot = '0';
            }

            $table .= "<td>" . $compare_data_basic_ot . "</td>";

            $detail_variance_ot = $value_ot->total_overtime - $compare_data_basic_ot;

            if ($value_ot->total_overtime != 0) {
                $ot_total_basic_salary = $value_ot->total_overtime;
            } else {
                $ot_total_basic_salary = 1;
            }

            if ($detail_variance_ot != 0) {
                $ot_variance_data = $detail_variance_ot;
            } else {
                $ot_variance_data = 1;
            }

            $variance_percentage_ot = $ot_variance_data / $ot_total_basic_salary;
            $variance_percentage_ot_final =  $variance_percentage_ot * 100;

            if ($value_ot->total_overtime == 0 && $detail_variance_ot == 0) {
                $final_calu_basic_data_ot = 0;
            } else {
                $final_calu_basic_data_ot = $variance_percentage_ot_final;
            }

            $table .= "<td>" . $detail_variance_ot . "</td>
                  <td>" . round($final_calu_basic_data_ot,3) . "</td>";

            $table .= "</tr>";
        }
        } else{
            $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
        }
        
        //---------------------- total loan
        $table .= "<tr><th colspan='7'></th></tr>";

        $sql_loan = "SELECT * FROM xin_salary_payslips WHERE salary_month = '$current_date'";
        $result_loan = $this->db->query($sql_loan);

        $table .= "<tr><th colspan='7' style='text-align: center; background-color: #698bbb; color: #fff;'>Loan Details : Loan</th></tr>";
        if(!empty($result_loan->result())){
            foreach ($result_loan->result() as $value_loan) {
            $table .= "<tr>";
            $employee_main_id_loan = $this->Reports_model->read_employee_info($value_loan->employee_id);
            if (!is_null($employee_main_id_loan)) {
                $emp_id = $employee_main_id_loan[0]->employee_id;
                $emp_name = $employee_main_id_loan[0]->first_name . ' ' . $employee_main_id_loan[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }

            $table .= "<td>" . $emp_id . "</td>
                         <td>" . $emp_name . "</td>
                         <td>Dirhams</td>";

            if ($value_loan->total_loan != '') {
                $table .= " <td>" . $value_loan->total_loan . "</td>";
            } else {
                $table .= " <td>0</td>";
            }

            $compare_data_details_loan_get = $this->Reports_model->compare_data_details_ld_get($value_loan->employee_id, $compare_date);
            if (!is_null($compare_data_details_loan_get)) {
                $compare_data_basic_loan = $compare_data_details_loan_get[0]->total_loan;
            } else {
                $compare_data_basic_loan = '0';
            }

            $table .= "<td>" . $compare_data_basic_loan . "</td>";

            $detail_variance_loan = $value_loan->total_loan - $compare_data_basic_loan;

            if ($value_loan->total_loan != 0) {
                $loan_total_basic_salary = $value_loan->total_loan;
            } else {
                $loan_total_basic_salary = 1;
            }

            if ($detail_variance_loan != 0) {
                $loan_variance_data = $detail_variance_loan;
            } else {
                $loan_variance_data = 1;
            }

            $variance_percentage_loan = $loan_variance_data / $loan_total_basic_salary;
            $variance_percentage_loan_final =  $variance_percentage_loan * 100;

            if ($value_loan->total_loan == 0 && $detail_variance_loan == 0) {
                $final_calu_basic_data_loan = 0;
            } else {
                $final_calu_basic_data_loan = $variance_percentage_loan_final;
            }

            $table .= "<td>" . $detail_variance_loan . "</td>
                  <td>" . round($final_calu_basic_data_loan,3) . "</td>";

            $table .= "</tr>";
        }
        } else{
            $table .= "<tr><td colspan='7'>No Data Found</td></tr>";
        }

        $table .= " </tbody>";


        $table .= "</table>
                 </div>
                 </div>";

        header("Content-type: application/json");
        echo json_encode($table);
        exit();
    }
    
    
    
    public function payroll_reconciliation_pdf()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        $company = $this->Xin_model->read_company_info($user[0]->company_id);
        $system = $this->Xin_model->read_setting_info(1);

        $p_method = '';
        if (!is_null($company)) {
            $company_name = $company[0]->name;
            $address_1 = $company[0]->address_1;
            $address_2 = $company[0]->address_2;
            $city = $company[0]->city;
            $state = $company[0]->state;
            $company_logo = $company[0]->logo;
            $zipcode = $company[0]->zipcode;
            $country = $this->Xin_model->read_country_info($company[0]->country);
            if (!is_null($country)) {
                $country_name = $country[0]->country_name;
            } else {
                $country_name = '--';
            }
            $c_info_email = $company[0]->email;
            $c_info_phone = $company[0]->contact_number;
            if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
            } else {
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
            }
        } else {
            $company_name = '--';
            $address_1 = '--';
            $address_2 = '--';
            $city = '--';
            $state = '--';
            $zipcode = '--';
            $country_name = '--';
            $c_info_email = '--';
            $c_info_phone = '--';
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
        }

        $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

        $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

        if (empty($session)) {

            redirect('admin/');
        }

        $format_type = $_POST['e_format_type'];

        $current_month_year = $_POST['e_current_month_year'];
        $compare_month_year = $_POST['e_compare_month_year'];

        $current_date = $current_month_year;
        $compare_date = $compare_month_year;

        //current date
        $month_year_cur = $current_date;
        $year_month_spilt_cur = explode("-", $month_year_cur);
        $year_cur = $year_month_spilt_cur[0];
        $month_cur = $year_month_spilt_cur[1];

        //month character decrease
        $monthName_cur = date("F", mktime(0, 0, 0, $month_cur, 1));
        $month_name_cur_get = substr($monthName_cur, 0, 3);

        $month_year_cur_get = $month_name_cur_get . ',' . $year_cur;

        //compare date
        $month_year_com = $compare_date;
        $year_month_spilt_com = explode("-", $month_year_com);
        $year_com = $year_month_spilt_com[0];
        $month_com = $year_month_spilt_com[1];

        //month character decrease
        $monthName_com = date("F", mktime(0, 0, 0, $month_com, 1));
        $month_name_com_get = substr($monthName_com, 0, 3);

        $month_year_com_get = $month_name_com_get . ',' . $year_com;

        $res['email_phone_address'] = $email_phone_address;
        $res['company_name'] = $company_name;
        $res['country_name'] = $country_name;
        $res['month_year_cur_get'] = $month_year_cur_get;
        $res['month_year_com_get'] = $month_year_com_get;
        $res['logo'] = $logo;
        $res['current_date'] = $current_date;
        $res['compare_date'] = $compare_date;
        $res['city'] = $city;
        
        //$this->load->view("admin/reports/reconciliation_doc_format", $res);
        $html = $this->load->view("admin/reports/reconciliation_doc_format", $res, true);

        if($format_type == 1){
            $this->load->library('M_pdf');
            $mpdf = $this->m_pdf->load([
                'mode' => 'utf-8',
                'format' => 'A4'
            ]);
            $mpdf->WriteHTML($html);
            $mpdf->Output('reconciliation.pdf', 'I');
        } else{
            $file = "reconciliation.xls";
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=$file");
            echo $html;
        }
        
    }


    public function department_wise_summary_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Department Wise Summary Sheet Report" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Department Wise Summary Sheet Report";

        $data['all_companies'] = $this->Xin_model->get_companies();

        $data['all_departments'] = $this->Department_model->all_departments();

        $data['all_employees'] = $this->Xin_model->all_employees();

        $data['all_location'] = $this->Location_model->all_office_locations();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/department_wise_summary_page", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function department_wise_summary_get()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/employees", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));



        $aj_company = $_GET['aj_company'];

        $aj_department = $_GET['aj_department'];

        $location_id = $_GET['location_id'];

        //$paysheet_employee_id = $_GET['paysheet_employee_id'];

        $month_year = $_GET['month_year'];
        $status = $_GET['status'];


        $department_wise_summary = $this->Reports_model->department_wise_summary_get_data($aj_company, $aj_department, $location_id, $month_year,$status);

        $data_filtered = array();

        $data = array();

                if (count($department_wise_summary) > 0) {
            foreach ($department_wise_summary as $value) {

                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }


                //get head count
                $head_count = $this->Reports_model->get_head_count('',$value->department_id, $month_year);
                if (!is_null($head_count)) {
                    $head_count_get = $head_count[0]->headcount;
                } else {
                    $head_count_get = '--';
                }

                //get basic salary
                $basic_salary = $this->Reports_model->get_basic_salary('', $value->department_id, $month_year);
                if (!is_null($basic_salary)) {
                    $basic_salary_data = $basic_salary[0]->total_salary;
                } else {
                    $basic_salary_data = '--';
                }

                $tmp = array(
                    $department_name,
                    // $head_count_get,
                    round($basic_salary_data,3),
                );

                $gross_salary = $basic_salary_data;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        array_push(
                            $tmp,
                            round($amount,3)
                        );
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        array_push(
                            $tmp,
                            round($amount,3)
                        );
                    }
                }

                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $overtime_data = $this->db->query($sql_ot)->row();

                if (!empty($overtime_data)) {
                    $ot_amount = $overtime_data->total_ot_amt;
                } else {
                    $ot_amount = 0;
                }


                array_push(
                    $tmp,
                    round($ot_amount,3)
                );


                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 3) {

                        $sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;
                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        array_push(
                            $tmp,
                            round($amount,3)

                        );
                    } else if ($allowance->type_id == 5) {

                        $sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        array_push(
                            $tmp,
                            round($amount,3)

                        );
                    } else if ($allowance->type_id == 4) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

                        $binds = array($month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary -= $amount;
                        array_push(
                            $tmp,
                            round($amount,3)

                        );
                    }
                }

                //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                } else {
                    $late_deduction_data_get = 0;
                }

                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $leave_data = $this->db->query($sql_leave)->row();

                if (!empty($leave_data)) {
                    $leave_amount = $leave_data->total_leave_deduction_amt;
                } else {
                    $leave_amount = 0;
                }

                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $adv_data = $this->db->query($sql_adv)->row();

                if (!empty($adv_data)) {
                    $adv_amount = $adv_data->total_adv_amt;
                } else {
                    $adv_amount = 0;
                }
                
                //loan Deduction
                $sql_loan = "SELECT SUM(total_loan) as total_loan FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

                $loan_data = $this->db->query($sql_loan)->row();
                if (!empty($loan_data)) {
                    $loan_data_get = $loan_data->total_loan;
                } else {
                    $loan_data_get = 0;
                }
                
                // //other payments///
                // $other_data = $this->Reports_model->get_other_payments($value->department_id, $month_year);

                // if ($other_data!=NULL) {
                //     $other_amount = $other_data;
                // } else {
                //     $other_amount = 0;
                // }

                array_push(
                    $tmp,
                    round($loan_data_get,3),
                    round($late_deduction_data_get,3),
                    round($leave_amount,3),
                    round($adv_amount,3)
                    //round($other_amount,3)
                );



                //get Gross salary
                $gross_salary = $this->Reports_model->get_gross_salary('', $value->department_id, $month_year);
                if (!is_null($gross_salary)) {
                    $gross_salary_data = $gross_salary[0]->gross_salary;
                } else {
                    $gross_salary_data = '--';
                }
                
                
                $gross_salary_data_get = number_format((float)$gross_salary_data, 3, '.', '');

                array_push(
                    $tmp,
                    $gross_salary_data_get
                );


                $data[] = $tmp;
            }
        }


        $output = array(

            "draw" => $draw,

            "recordsTotal" => count($data),

            "recordsFiltered" => count($data),

            "data" => $data

        );
        $output['csrf_hash'] = $this->security->get_csrf_hash();
        echo json_encode($output);

        exit();
    }
    
    public function department_wise_summary_doc_format()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);
        
        // Datatables Variables
        $format = $this->input->post('e_format');
        $location_company = $this->input->post('e_location_id');
        $company_id = $this->input->post('e_company_id');
        $department_id = $this->input->post('e_department_id');
        $month_year = $this->input->post('e_month_year');
        $status = $this->input->post('e_status');
      
        if(!empty($company_id)){
            $company_id_array = explode(',',$company_id);
            $title_company_id = $company_id_array[0];
        } else{
            $title_company_id = $user[0]->company_id;
        }
        $company = $this->Xin_model->read_company_info($title_company_id);
        $system = $this->Xin_model->read_setting_info(1);

        $p_method = '';
        if (!is_null($company)) {
            $company_name = $company[0]->name;
            $address_1 = $company[0]->address_1;
            $address_2 = $company[0]->address_2;
            $city = $company[0]->city;
            $state = $company[0]->state;
            $company_logo = $company[0]->logo;
            $zipcode = $company[0]->zipcode;
            $country = $this->Xin_model->read_country_info($company[0]->country);
            if (!is_null($country)) {
                $country_name = $country[0]->country_name;
            } else {
                $country_name = '--';
            }
            $c_info_email = $company[0]->email;
            $c_info_phone = $company[0]->contact_number;
            if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //	echo $logo;
            } else {
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
            }
        } else {
            $company_name = '--';
            $address_1 = '--';
            $address_2 = '--';
            $city = '--';
            $state = '--';
            $zipcode = '--';
            $country_name = '--';
            $c_info_email = '--';
            $c_info_phone = '--';
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
        }

        $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

        $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

        if (empty($session)) {
            redirect('admin/');
        }


        $department_wise_summary = $this->Reports_model->department_wise_summary_get_data($company_id, $department_id, $location_company, $month_year, $status);

               $data_filtered = array();

        $data = array();

                if (count($department_wise_summary) > 0) {
            foreach ($department_wise_summary as $value) {

                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }


                //get head count
                $head_count = $this->Reports_model->get_head_count('',$value->department_id, $month_year);
                if (!is_null($head_count)) {
                    $head_count_get = $head_count[0]->headcount;
                } else {
                    $head_count_get = '--';
                }

                //get basic salary
                $basic_salary = $this->Reports_model->get_basic_salary('', $value->department_id, $month_year);
                if (!is_null($basic_salary)) {
                    $basic_salary_data = $basic_salary[0]->total_salary;
                } else {
                    $basic_salary_data = '--';
                }

                $tmp = array(
                    $department_name,
                    // $head_count_get,
                    round($basic_salary_data,3),
                );

                $gross_salary = $basic_salary_data;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        array_push(
                            $tmp,
                            round($amount,3)
                        );
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary += $amount;
                        array_push(
                            $tmp,
                            round($amount,3)
                        );
                    }
                }

                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $overtime_data = $this->db->query($sql_ot)->row();

                if (!empty($overtime_data)) {
                    $ot_amount = $overtime_data->total_ot_amt;
                } else {
                    $ot_amount = 0;
                }


                array_push(
                    $tmp,
                    round($ot_amount,3)
                );


                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 3) {

                        $sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;
                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        array_push(
                            $tmp,
                            round($amount,3)

                        );
                    } else if ($allowance->type_id == 5) {

                        $sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }

                        $gross_salary -= $amount;
                        array_push(
                            $tmp,
                            round($amount,3)

                        );
                    } else if ($allowance->type_id == 4) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

                        $binds = array($month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;
                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = 0;
                            }
                        }
                        $gross_salary -= $amount;
                        array_push(
                            $tmp,
                            round($amount,3)

                        );
                    }
                }

                //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                } else {
                    $late_deduction_data_get = 0;
                }

                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $leave_data = $this->db->query($sql_leave)->row();

                if (!empty($leave_data)) {
                    $leave_amount = $leave_data->total_leave_deduction_amt;
                } else {
                    $leave_amount = 0;
                }

                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $adv_data = $this->db->query($sql_adv)->row();

                if (!empty($adv_data)) {
                    $adv_amount = $adv_data->total_adv_amt;
                } else {
                    $adv_amount = 0;
                }
                
                //loan Deduction
                $sql_loan = "SELECT SUM(total_loan) as total_loan FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

                $loan_data = $this->db->query($sql_loan)->row();
                if (!empty($loan_data)) {
                    $loan_data_get = $loan_data->total_loan;
                } else {
                    $loan_data_get = 0;
                }
                
                // //other payments///
                // $other_data = $this->Reports_model->get_other_payments($value->department_id, $month_year);

                // if ($other_data!=NULL) {
                //     $other_amount = $other_data;
                // } else {
                //     $other_amount = 0;
                // }

                array_push(
                    $tmp,
                    round($loan_data_get,3),
                    round($late_deduction_data_get,3),
                    round($leave_amount,3),
                    round($adv_amount,3)
                    //round($other_amount,3)
                );



                //get Gross salary
                $gross_salary = $this->Reports_model->get_gross_salary('', $value->department_id, $month_year);
                if (!is_null($gross_salary)) {
                    $gross_salary_data = $gross_salary[0]->gross_salary;
                } else {
                    $gross_salary_data = '--';
                }

                array_push(
                    $tmp,
                    round($gross_salary_data,3)
                );


                $data[] = $tmp;
            }
        }
        
        $allowances = $this->db->get('allowance');
        $allowance_count = count($allowances->result());
        $total_count = $allowance_count + 8;
        $res['lists'] = $data;
        $res['email_phone_address'] = $email_phone_address;
        $res['logo'] = $logo;
        $res['company_name'] = $company_name;
        $res['month_year'] = $month_year;
        $res['country_name'] = $country_name;
        $res['format']= $format;
        $res['total_count'] = $total_count;
        $res['city'] = $city;
        //$this->load->view("admin/reports/department_wise_doc_format", $res);
        $html = $this->load->view("admin/reports/department_wise_doc_format", $res, true);
        if($format == 1){
            $this->load->library('M_pdf');
            $mpdf = $this->m_pdf->load([
                'mode' => 'utf-8',
                'format' => 'A4'
            ]);
            $mpdf->WriteHTML($html);
            $mpdf->Output('department_wise.pdf', 'D');
        } else{
            $file = "department_wise.xls";
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=$file");
            echo $html;
        }
    }
    

    //pay sheet period
    public function pay_sheet_period_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Pay Sheet of a Period" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Pay Sheet of a Period";

        $data['all_companies'] = $this->Xin_model->get_companies();

        $data['all_departments'] = $this->Department_model->all_departments();

        $data['all_employees'] = $this->Xin_model->all_employees();

        $data['all_location'] = $this->Location_model->all_office_locations();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/pay_sheet_period", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function pay_sheet_period_get()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/payroll", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));

        $aj_company = $_GET['aj_company'];
        $aj_department = $_GET['aj_department'];
        $location_id = $_GET['location_id'];
        $paysheet_employee_id = $_GET['paysheet_employee_id'];
        $from_month_year = $_GET['from_month_year'];
        $to_month_year = $_GET['to_month_year'];

        $payslip_re = $this->Reports_model->pay_sheet_period_data_get($aj_company, $aj_department, $location_id, $paysheet_employee_id, $from_month_year, $to_month_year);

        $data_filtered = array();

        $data = array();

        if (count($payslip_re) > 0) {
            $emp_array = array();
            foreach ($payslip_re as $value) {

                $employee = $this->Reports_model->read_employee_info($value->employee_id);

                if (!is_null($employee)) {

                    $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

                    $emp_id = $employee[0]->employee_id;

                    $date_of_joining = $employee[0]->date_of_joining;

                    $basic_salary = $employee[0]->basic_salary;
                } else {

                    $full_name = '--';

                    $emp_id = '--';

                    $date_of_joining = '--';

                    $basic_salary = '--';
                }

                $month_year = $from_month_year;

                $date = strtotime(date("Y-m-d"));

                if (!isset($month_year)) {

                    $day = date('d', $date);

                    $month = date('m', $date);

                    $year = date('Y', $date);

                    $month_year = date('Y-m');
                } else {

                    $imonth_year = explode('-', $month_year);

                    $day = date('d', $date);

                    $month = date($imonth_year[1], $date);

                    $year = date($imonth_year[0], $date);

                    $month_year = $month_year;
                }

                $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

                $start_date_y_m = date('Y-m', strtotime($month_year));

                $work_day = $this->Reports_model->work_day($year, $month);


                // $emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);

                // if ($emp_leave_in_month != '') {

                //     $lop = $emp_leave_in_month[0]->monthly_leaves;
                // } else {

                //     $lop = '--';
                // }

                    $emp_leave_in_month = $this->Reports_model->lop_days_get($value->employee_id, date('m',strtotime($value->salary_month)), date('Y',strtotime($value->salary_month)));
                    if ($emp_leave_in_month != '') {
                        $lop = $emp_leave_in_month[0]->total_unpaid_count;
                    } else {
                        $lop = '0';
                    }

                //test
                $sql1 = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ?';
                $binds1 = array($value->employee_id);
                $payslip_allowance = $this->db->query($sql1, $binds1)->row();

                if (!empty($payslip_allowance)) {
                    $amount1 = $payslip_allowance->allowance_amount;
                } else {
                    $amount1 = '0';
                }

                $sql2 = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ?';
                $binds2 = array($value->employee_id);
                $payslip_commission = $this->db->query($sql2, $binds2)->row();

                if (!empty($payslip_commission)) {
                    $amount2 = $payslip_commission->commission_amount;
                } else {
                    $amount2 = '0';
                }

                $sql3 = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ?';
                $binds3 = array($value->employee_id);
                $payslip_other_payments = $this->db->query($sql3, $binds3)->row();

                if (!empty($payslip_other_payments)) {
                    $amount3 = $payslip_other_payments->payments_amount;
                } else {
                    $amount3 = '0';
                }

                //get carry leave
                $carry_leaves = $this->Reports_model->get_carry_leaves($value->employee_id);
                if (!is_null($carry_leaves)) {
                    $carry_leaves_get = $carry_leaves[0]->remaing_leave_count;
                } else {
                    $carry_leaves_get = '0';
                }

                $month_year = $value->salary_month;
                $year_month_spilt = explode("-", $month_year);
                $year = $year_month_spilt[0];
                $month = $year_month_spilt[1];
                $month_days = cal_days_in_month(CAL_GREGORIAN, $month, $year);

                //$absent_days =  $month_days - $value->monthy_present_days;
                
                $employee_leave = $this->Reports_model->get_employee_leave_payslip($value->employee_id, $value->salary_month, $value->company_id);
                if (!is_null($employee_leave)) {
                    $leave_count = $employee_leave;
                } else {
                    $leave_count = '0';
                }

                //month character decrease
                $monthName = date("F", mktime(0, 0, 0, $month, 1));
                $month_name_get = substr($monthName, 0, 3);

                $p_a_days = '(P:' . $value->monthy_present_days . ')<br>' . '(A:' . $leave_count.' )';

                $month_total_allo = $value->basic_salary + $amount1 + $amount2 + $amount3;

                $emp_info = '('.$emp_id . ')<br>' . $full_name;
                
                $emp_name_info = '['.$emp_id . ']<br>' . $full_name;

                $month_year_get = $month_name_get . ',' . $year;
                
                if (in_array($emp_id, $emp_array)) {
                    
                } else {
                  array_push($emp_array,$emp_id);
                  $data[] = array(
                    '<b>'.$emp_name_info.'</b>',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '',
                    '');
                }

                
                $tmp = array(

                    $emp_info,

                    $month_year_get,

                    $p_a_days,

                    $value->basic_salary,

                    $lop


                );

                $gross_salary = $value->basic_salary;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';

                        $binds = array($value->employee_id, $allowance->id, $month_year);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();



                        if (!empty($payslip_allowance)) {

                            $amount = $payslip_allowance->allowance_amount;

                            $gross_salary += $amount;
                        } else

                            $amount = '0';
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and commission_title=? and salary_month=?';

                        $binds = array($value->employee_id, $allowance->id, $month_year);

                        $payslip_commission = $this->db->query($sql, $binds)->row();



                        if (!empty($payslip_commission)) {

                            $amount = $payslip_commission->commission_amount;

                            $gross_salary += $amount;
                        } else

                            $amount = '0';
                    } else if ($allowance->type_id == 3) {

                        $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and deduction_title=? and salary_month=?';

                        $binds = array($value->employee_id, $allowance->id, $month_year);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount = $statutory_deduction->deduction_amount;

                            $gross_salary -= $amount;
                        } else

                            $amount = '0';
                    }  else if ($allowance->type_id == 4) {

                        $sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';

                        $binds = array($value->employee_id, $month_year);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount = $payslip_loan->loan_amount;

                            $gross_salary -= $amount;
                        } else

                            $amount = '0';
                    } else if ($allowance->type_id == 5) {

                        $sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';

                        $binds = array($value->employee_id, $month_year);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();



                        if (!empty($payslip_other_payments)) {

                            $amount = $payslip_other_payments->payments_amount;

                            $gross_salary += $amount;
                        } else

                            $amount = '0';
                    }

                    array_push($tmp, $amount);
                }


                //late deduction
                $emp_main_id = $value->employee_id;
                $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction;
                } else {
                    $late_deduction_data_get = '0';
                }
                if($value->amt_leave_encashment != ''){
                    $amt_leave_encashment = $value->amt_leave_encashment;
                }else{
                    $amt_leave_encashment = 0;
                }

                array_push(
                    $tmp,

                    $amt_leave_encashment,

                   // $value->total_other_payments,

                    $value->total_overtime,

                    $value->advance_salary_amount,

                    $value->amt_indemnity,

                    $value->total_loan,
                
                    $value->leave_deduction,

                    $late_deduction_data_get,

                    $value->net_salary

                );

                $data[] = $tmp;
            }
        }

        $output = array(

            "draw" => $draw,

            "recordsTotal" => count($data),

            "recordsFiltered" => count($data),

            "data" => $data

        );
        $output['csrf_hash'] = $this->security->get_csrf_hash();
        echo json_encode($output);

        exit();
    }
    
    public function paysheet_period_pdf_get() {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        $user = $this->Xin_model->read_user_info($session['user_id']);

        $aj_company = $this->input->post('p_company_id');
        $location_id = $this->input->post('p_location_id');
        $aj_department = $this->input->post('p_department_id');
        $paysheet_employee_id = $this->input->post('p_employee_id');
        $from_month_year = $this->input->post('p_from_month_year');
        $to_month_year = $this->input->post('p_to_month_year');


        if(!empty($aj_company)){
            $title_company_id = $aj_company;
        } else{
            $title_company_id = $user[0]->company_id;
        }


        $company = $this->Xin_model->read_company_info($title_company_id);
        $system = $this->Xin_model->read_setting_info(1);

        $p_method = '';
        if (!is_null($company)) {
            $company_name = $company[0]->name;
            $address_1 = $company[0]->address_1;
            $address_2 = $company[0]->address_2;
            $city = $company[0]->city;
            $state = $company[0]->state;
            $company_logo = $company[0]->logo;
            $zipcode = $company[0]->zipcode;
            $country = $this->Xin_model->read_country_info($company[0]->country);
            if (!is_null($country)) {
                $country_name = $country[0]->country_name;
            } else {
                $country_name = '--';
            }
            $c_info_email = $company[0]->email;
            $c_info_phone = $company[0]->contact_number;
            if ($company_logo) {
                $logo = '../../../../../uploads/company/' . $company_logo;
                //  echo $logo;
            } else {
                $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
            }
        } else {
            $company_name = '--';
            $address_1 = '--';
            $address_2 = '--';
            $city = '--';
            $state = '--';
            $zipcode = '--';
            $country_name = '--';
            $c_info_email = '--';
            $c_info_phone = '--';
            $logo = '../../../../../uploads/logo/payroll/' . $system[0]->payroll_logo;
        }

        $c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

        $email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


        //--------------------


        //-------------------


        $this->load->library('M_pdf');
        $mpdf = $this->m_pdf->load([
            'format' => 'A4',
    	    'orientation' => 'l'
        ]);

        $res['aj_company'] = $aj_company;
        $res['location_id'] = $location_id;
        $res['aj_department'] = $aj_department;
        $res['paysheet_employee_id'] = $paysheet_employee_id;
        $res['from_month_year'] = $from_month_year;
        $res['to_month_year'] = $to_month_year;
        $res['header_string'] = $email_phone_address;
        $res['company_name'] = $company_name;
        $res['logo'] = $logo;
        $html = $this->load->view("admin/reports/paysheet_period_pdf_format", $res, true);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Paysheet_Sheet_Period_Report.pdf', 'D');
    }


    public function monthly_earning_deduction_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Monthly Earning Deduction" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Monthly Earning Deduction";

        $data['all_companies'] = $this->Xin_model->get_companies();

        $data['all_departments'] = $this->Department_model->all_departments();

        $data['all_employees'] = $this->Xin_model->all_employees();

        $data['all_location'] = $this->Location_model->all_office_locations();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/monthly_earning_deduction", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function monthly_earning_deduction_get()
    {

        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/employees", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));

        $aj_company = $_GET['aj_company'];
        $aj_department = $_GET['aj_department'];
        $location_id = $_GET['location_id'];
        $paysheet_employee_id = $_GET['paysheet_employee_id'];
        $month_year = $_GET['month_year'];

        $monthly_earning_deduction_get_data = $this->Reports_model->monthly_earning_deduction_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $month_year);


        //current date
        $month_year_cur = $month_year;
        $year_month_spilt_cur = explode("-", $month_year_cur);
        $year_cur = $year_month_spilt_cur[0];
        $month_cur = $year_month_spilt_cur[1];

        //month character decrease
        $monthName_cur = date("F", mktime(0, 0, 0, $month_cur, 1));
        $month_name_cur_get = substr($monthName_cur, 0, 3);

        $month_year_cur_get = $month_name_cur_get . ', ' . $year_cur;


        $table = "";
        $table .= "<span class='card-header-title mr-2'><strong>Monthly Earning Deduction Report (" . $month_year_cur_get . ")</strong></span> </div>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='monthly_earning_deduction_report_datatable'>
		        <table class='datatables-demo table table-striped table-bordered' id='monthly_earning_deduction_table_main'>";

        //table 1

        $table .= "<thead>
                      <tr><th colspan='7' style='text-align:center;'>Employees Wise Earning Details</th></tr>
                      
                      <tr>
                      <th>Emp. Code</th>
                      <th>Employee Name</th>
                      <th>Payable Basic</th>
                      <th>Earning Details</th>
                      <th>Overtime</th>
                      <th>Other Payment</th>
                      <th>Gross Salary</th>
                      </tr>";

        $table .= "</thead><tbody>";

        foreach ($monthly_earning_deduction_get_data->result() as $value_e) {

            $emp_main_id = $value_e->employee_id;
            $e_gross_salary = $value_e->basic_salary;
            $net_salary_final_data_e = $value_e->net_salary;

            $employee_main_id = $this->Reports_model->read_employee_info($emp_main_id);
            if (!is_null($employee_main_id)) {
                $emp_id = $employee_main_id[0]->employee_id;
                $emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }

            //earning data 1
            $payslip_allowance_data_full = '';
            $sql = "SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and salary_month = '$month_year'";

            $binds = array($emp_main_id);
            $payslip_allowance = $this->db->query($sql, $binds)->result();

            if (!empty($payslip_allowance)) {
                foreach ($payslip_allowance as $get1) {

                    $sql = 'SELECT * FROM allowance WHERE id = ?';
                    $binds = array($get1->allowance_title);
                    $payslip_allowance_name = $this->db->query($sql, $binds)->row();

                    $payslip_allowance_name_get = $payslip_allowance_name->name;
                    $space = "&#160;:&#160;";
                    $payslip_allowance_amt = $get1->allowance_amount;
                    $payslip_allowance_amt_display = $get1->allowance_amount;
                    $payslip_allowance_data_full .= '<b>' . $payslip_allowance_name_get . $space . '</b>' . $payslip_allowance_amt_display . '<br/>';
                }
            } else {
                $payslip_allowance_data_full = "";
                $payslip_allowance_amt = "0";
            }


            //earning data 2
            $sql = "SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and salary_month = '$month_year'";

            $binds = array($emp_main_id);
            $payslip_commission = $this->db->query($sql, $binds)->row();

            if (!empty($payslip_commission)) {

                $sql = 'SELECT * FROM allowance WHERE id = ?';
                $binds = array($payslip_commission->commission_title);
                $payslip_commission_name = $this->db->query($sql, $binds)->row();

                $payslip_commission_name_get = $payslip_commission_name->name;
                $space = "&#160;:&#160;";
                $payslip_commission_amt = $payslip_commission->commission_amount;
                $payslip_commission_amt_display = $payslip_commission->commission_amount;
                $payslip_commission_data_full = '<b>' . $payslip_commission_name_get . $space . '</b>' . $payslip_commission_amt_display;
            } else {
                $payslip_commission_data_full = "";
                $payslip_commission_amt = "0";
            }


            //earning data 3
            $other_payment = $value_e->total_other_payments;
            /* $sql = "SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month = '$month_year'";

                		$binds = array($emp_main_id);
                		$payslip_other_payments = $this->db->query($sql, $binds)->row();

                		if (! empty($payslip_other_payments)) {

                		$sql = 'SELECT * FROM allowance WHERE id = ?';
                	    $binds = array($payslip_other_payments->payments_title);
                		$payslip_other_payments_name = $this->db->query($sql, $binds)->row(); */

            if (!empty($other_payment)) {
                $payslip_other_payments_amt = $other_payment;
            } else {
                $payslip_other_payments_amt = "0";
            }


            //overtime get
            $overtime_data = $value_e->total_overtime;
            if (!empty($overtime_data)) {
                $ot_amount = $overtime_data;
            } else {
                $ot_amount = "0";
            }


            $total_gross_salary =  $e_gross_salary + $payslip_allowance_amt + $payslip_commission_amt + $payslip_other_payments_amt + $ot_amount;


            $table .= "<tr>
                 <td>" . $emp_id . "</td>
                 <td>" . $emp_name . "</td>
                 <td>" . $e_gross_salary . "</td>
                 <td>" . $payslip_allowance_data_full .
                $payslip_commission_data_full .
                "</td>
                  <td>" . $ot_amount . "</td>
                  <td>" . $payslip_other_payments_amt . "</td>
                  <td>" . $net_salary_final_data_e . "</td>
                </tr>";
        }

        $table .= "</tbody>";

        //table 2

        $table .= "<thead>
                      <tr><th></th></tr>
                      <tr><th colspan='7' style='text-align:center;'>Employees Wise Deduction Details</th></tr>
                      
                      <tr>
                      <th>Emp. Code</th>
                      <th>Employee Name</th>
                      <th style='width: 25% !important;'>Deduction Details</th>
                      <th>Leave Deduction</th>
                      <th>Advance Salary</th>
                      <th>Total Deduction</th>
                      <th>Net Payable</th>
                      </tr>";

        $table .= "</thead><tbody>";

        foreach ($monthly_earning_deduction_get_data->result() as $value_d) {

            $emp_main_id = $value_d->employee_id;
            $d_gross_salary = $value_d->basic_salary;
            $net_salary_final_data = $value_d->net_salary;

            $employee_main_id = $this->Reports_model->read_employee_info($emp_main_id);
            if (!is_null($employee_main_id)) {
                $emp_id = $employee_main_id[0]->employee_id;
                $emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }


            //deduction data 1
            $statutory_deduction_data_full = '';
            $sql = "SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and salary_month = '$month_year'";
            $binds = array($emp_main_id);
            $statutory_deduction = $this->db->query($sql, $binds)->result();

            if (!empty($statutory_deduction)) {
                foreach ($statutory_deduction as $get2) {
                    $sql = 'SELECT * FROM allowance WHERE id = ?';
                    $binds = array($get2->deduction_title);
                    $statutory_deduction_name = $this->db->query($sql, $binds)->row();

                    $statutory_deduction_name_get = $statutory_deduction_name->name;
                    $space = "&#160;:&#160;";
                    $statutory_deduction_amt = $get2->deduction_amount;
                    $statutory_deduction_amt_display = $get2->deduction_amount . ',' . ' ' . ' ';
                    $statutory_deduction_data_full .= '<b>' . $statutory_deduction_name_get . $space . '</b>' . $statutory_deduction_amt_display;
                }
            } else {
                $statutory_deduction_amt = "0";
                $statutory_deduction_data_full = "";
            }


            //deduction data 2
            $sql = "SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month = '$month_year'";
            $binds = array($emp_main_id);
            $payslip_loan = $this->db->query($sql, $binds)->row();

            if (!empty($payslip_loan)) {
                $payslip_loan_name_get = $payslip_loan->loan_title;
                $space = "&#160;:&#160;";
                $payslip_loan_amount = $payslip_loan->loan_amount;
                $payslip_loan_amount_display = $payslip_loan->loan_amount . ',' . ' ' . ' ';
                $payslip_loan_data_full = '<b>' . $payslip_loan_name_get . $space . '</b>' . $payslip_loan_amount_display;
            } else {
                $payslip_loan_amount = "0";
                $payslip_loan_data_full = "";
            }

            //late deduction
            $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

            $late_deduction_data = $this->db->query($sql_late)->row();
            if (!empty($late_deduction_data)) {
                $late_deduction_data_get = $late_deduction_data->total_late_deduction;
                $late_title = 'Late deduction';
                $space = "&#160;:&#160;";
                $late_deduction_data_get_full = '<b>' . $late_title . $space . '</b>' . $late_deduction_data_get;
            } else {
                $late_deduction_data_get = '0';
                $late_deduction_data_get_full = "";
            }

            //Leave Deduction
            $leave_data = $value_d->leave_deduction;
            if (!empty($leave_data)) {
                $leave_amount = $leave_data;
            } else {
                $leave_amount = "0";
            }

            //Advance Salary
            $adv_data = $value_d->advance_salary_amount;
            if (!empty($adv_data)) {
                $adv_amount = $adv_data;
            } else {
                $adv_amount = "0";
            }

            //earning data only calculation use
            //earning data 1
            /*  $sql = "SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and salary_month = '$month_year'";
                		$binds = array($emp_main_id);
                		$payslip_allowance_dt = $this->db->query($sql, $binds)->row();

                		if (!empty($payslip_allowance_dt)) {
                		    $payslip_allowance_amt_dt = $payslip_allowance_dt->allowance_amount;
                		}else{
                		    $payslip_allowance_amt_dt = "0"; }
                        
                //earning data 2
                        $sql = "SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and salary_month = '$month_year'";
                		$binds = array($emp_main_id);
                		$payslip_commission_dt = $this->db->query($sql, $binds)->row();

                		if (!empty($payslip_commission_dt)) {
                		    $payslip_commission_amt_dt = $payslip_commission_dt->commission_amount;
                    	}else{
                		    $payslip_commission_amt_dt = "0"; }
                        
                //earning data 3
                        $sql = "SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month = '$month_year'";
                		$binds = array($emp_main_id);
                		$payslip_other_payments_dt = $this->db->query($sql, $binds)->row();

                		if (! empty($payslip_other_payments_dt)) {
                		    $payslip_other_payments_amt_dt = $payslip_other_payments_dt->payments_amount;
                		}else{
                		    $payslip_other_payments_amt_dt = "0";
                        } */


            $total_deduction_amt = $statutory_deduction_amt + $payslip_loan_amount + $late_deduction_data_get + $leave_amount + $adv_amount;
            //$total_gross_salary_amt = $d_gross_salary + $payslip_allowance_amt_dt + $payslip_commission_amt_dt + $payslip_other_payments_amt_dt;
            // $final_net_pay_amt = $total_gross_salary_amt - $total_deduction_amt;


            $table .= "<tr>
                <td>" . $emp_id . "</td>
                <td>" . $emp_name . "</td>
                 <td>" . $statutory_deduction_data_full .
                $payslip_loan_data_full .
                $late_deduction_data_get_full .
                "</td>
                 <td>" . $leave_amount . "</td>
                 <td>" . $adv_amount . "</td>
                 <td>" . $total_deduction_amt . "</td>
                 <td>" . $net_salary_final_data . "</td>
                </tr>";
        }

        //-----------------------

        $table .= "</tbody>";


        $table .= "</table>
                 </div>
                 </div>";

        header("Content-type: application/json");
        echo json_encode($table);
        exit();
    }


    //yearly salary report code start

    public function year_salary_report_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Yearly Salary Report" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Yearly Salary Report";

        $data['all_companies'] = $this->Xin_model->get_companies();

        $data['all_departments'] = $this->Department_model->all_departments();

        $data['all_employees'] = $this->Xin_model->all_employees();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/year_salary_report", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }


    public function year_salary_report_get()
    {


        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/employees", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));

        $aj_company = $_GET['aj_company'];

        $aj_department = $_GET['aj_department'];

        $employee_id = $_GET['employee_id'];

        $month_year = $_GET['month_year'];

        $month_year = $month_year;
        $year_month_spilt = explode("-", $month_year);
        $year = $year_month_spilt[0];
        //$month = $year_month_spilt[1];

        $year_salary_report_get_data = $this->Reports_model->year_salary_report_get_data($aj_company, $aj_department, $employee_id, $year);

        $table = "";
        $table .= "<div class='card-header with-elements'> <span class='card-header-title mr-2'><strong>Yearly Salary Report (" . $year . ")</strong></span> </div>
                <div class='card-body'>
                <div class='box-datatable table-responsive' id='yearly_salary_report_datatable'>
		        <table class='datatables-demo table table-striped table-bordered' id='year_salary_report_table_main'>
                      <thead>
                      
                      <tr>
                      <th>Emp. Code & Employee Name</th>
                      <th>Payment Head</th>
                      <th>Jan</th>
                      <th>Feb</th>
                      <th>Mar</th>
                      <th>Apr</th>
                      <th>May</th>
                      <th>Jun</th>
                      <th>Jul</th>
                      <th>Aug</th>
                      <th>Sep</th>
                      <th>Oct</th>
                      <th>Nov</th>
                      <th>Dec</th>
                      <th>Total</th>
                      </tr>";

        $table .= "    </thead>
                      <tbody>";

        foreach ($year_salary_report_get_data->result_array() as $emp_row) {
            $employee_id = $emp_row['employee_id'];


            $sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_salary_payslips.employee_id, xin_salary_payslips.salary_month from xin_employees JOIN xin_salary_payslips on xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.employee_id IN($employee_id) and xin_salary_payslips.salary_month BETWEEN '$year-01' and '$year-12' Group by xin_salary_payslips.employee_id";
            $result = $this->db->query($sql);

            //basic salary code
            foreach ($result->result_array() as $row) {

                $emp_id = $row['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }


                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row['first_name'] . ' ' . $row['last_name'] . "</td><td>Basic Salary</td>";

                $jan_sql = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql)) {
                    $jan_sql_data = $jan_sql[0]->basic_salary;
                } else {
                    $jan_sql_data = '0';
                }

                $feb_sql = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql)) {
                    $feb_sql_data = $feb_sql[0]->basic_salary;
                } else {
                    $feb_sql_data = '0';
                }

                $mar_sql = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql)) {
                    $mar_sql_data = $mar_sql[0]->basic_salary;
                } else {
                    $mar_sql_data = '0';
                }

                $apr_sql = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql)) {
                    $apr_sql_data = $apr_sql[0]->basic_salary;
                } else {
                    $apr_sql_data = '0';
                }

                $may_sql = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql)) {
                    $may_sql_data = $may_sql[0]->basic_salary;
                } else {
                    $may_sql_data = '0';
                }

                $jun_sql = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql)) {
                    $jun_sql_data = $jun_sql[0]->basic_salary;
                } else {
                    $jun_sql_data = '0';
                }

                $jul_sql = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql)) {
                    $jul_sql_data = $jul_sql[0]->basic_salary;
                } else {
                    $jul_sql_data = '0';
                }

                $aug_sql = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql)) {
                    $aug_sql_data = $aug_sql[0]->basic_salary;
                } else {
                    $aug_sql_data = '0';
                }

                $sep_sql = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql)) {
                    $sep_sql_data = $sep_sql[0]->basic_salary;
                } else {
                    $sep_sql_data = '0';
                }

                $oct_sql = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql)) {
                    $oct_sql_data = $oct_sql[0]->basic_salary;
                } else {
                    $oct_sql_data = '0';
                }

                $nov_sql = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql)) {
                    $nov_sql_data = $nov_sql[0]->basic_salary;
                } else {
                    $nov_sql_data = '0';
                }

                $dec_sql = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql)) {
                    $dec_sql_data = $dec_sql[0]->basic_salary;
                } else {
                    $dec_sql_data = '0';
                }

                $table .= "<td>" . $jan_sql_data . "</td>";
                $table .= "<td>" . $feb_sql_data . "</td>";
                $table .= "<td>" . $mar_sql_data . "</td>";
                $table .= "<td>" . $apr_sql_data . "</td>";
                $table .= "<td>" . $may_sql_data . "</td>";
                $table .= "<td>" . $jun_sql_data . "</td>";
                $table .= "<td>" . $jul_sql_data . "</td>";
                $table .= "<td>" . $aug_sql_data . "</td>";
                $table .= "<td>" . $sep_sql_data . "</td>";
                $table .= "<td>" . $oct_sql_data . "</td>";
                $table .= "<td>" . $nov_sql_data . "</td>";
                $table .= "<td>" . $dec_sql_data . "</td>";

                $total_value = $jan_sql_data + $feb_sql_data + $mar_sql_data + $apr_sql_data + $may_sql_data + $jun_sql_data + $jul_sql_data + $aug_sql_data + $sep_sql_data + $oct_sql_data + $nov_sql_data + $dec_sql_data;

                //total value 
                $table .= "<td>" . $total_value . "</td>";

                $table .= " </tr>";
            }


            //total allowances
            foreach ($result->result_array() as $row_ta) {

                $emp_id = $row_ta['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_ta['first_name'] . ' ' . $row_ta['last_name'] . "</td><td>Allowances</td>";

                $jan_sql_ta = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_ta)) {
                    $jan_sql_data_ta = $jan_sql_ta[0]->total_allowances;
                } else {
                    $jan_sql_data_ta = '0';
                }

                $feb_sql_ta = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_ta)) {
                    $feb_sql_data_ta = $feb_sql_ta[0]->total_allowances;
                } else {
                    $feb_sql_data_ta = '0';
                }

                $mar_sql_ta = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_ta)) {
                    $mar_sql_data_ta = $mar_sql_ta[0]->total_allowances;
                } else {
                    $mar_sql_data_ta = '0';
                }

                $apr_sql_ta = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_ta)) {
                    $apr_sql_data_ta = $apr_sql_ta[0]->total_allowances;
                } else {
                    $apr_sql_data_ta = '0';
                }

                $may_sql_ta = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_ta)) {
                    $may_sql_data_ta = $may_sql_ta[0]->total_allowances;
                } else {
                    $may_sql_data_ta = '0';
                }

                $jun_sql_ta = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_ta)) {
                    $jun_sql_data_ta = $jun_sql_ta[0]->total_allowances;
                } else {
                    $jun_sql_data_ta = '0';
                }

                $jul_sql_ta = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_ta)) {
                    $jul_sql_data_ta = $jul_sql_ta[0]->total_allowances;
                } else {
                    $jul_sql_data_ta = '0';
                }

                $aug_sql_ta = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_ta)) {
                    $aug_sql_data_ta = $aug_sql_ta[0]->total_allowances;
                } else {
                    $aug_sql_data_ta = '0';
                }

                $sep_sql_ta = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_ta)) {
                    $sep_sql_data_ta = $sep_sql_ta[0]->total_allowances;
                } else {
                    $sep_sql_data_ta = '0';
                }

                $oct_sql_ta = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_ta)) {
                    $oct_sql_data_ta = $oct_sql_ta[0]->total_allowances;
                } else {
                    $oct_sql_data_ta = '0';
                }

                $nov_sql_ta = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_ta)) {
                    $nov_sql_data_ta = $nov_sql_ta[0]->total_allowances;
                } else {
                    $nov_sql_data_ta = '0';
                }

                $dec_sql_ta = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_ta)) {
                    $dec_sql_data_ta = $dec_sql_ta[0]->total_allowances;
                } else {
                    $dec_sql_data_ta = '0';
                }

                $table .= "<td>" . $jan_sql_data_ta . "</td>";
                $table .= "<td>" . $feb_sql_data_ta . "</td>";
                $table .= "<td>" . $mar_sql_data_ta . "</td>";
                $table .= "<td>" . $apr_sql_data_ta . "</td>";
                $table .= "<td>" . $may_sql_data_ta . "</td>";
                $table .= "<td>" . $jun_sql_data_ta . "</td>";
                $table .= "<td>" . $jul_sql_data_ta . "</td>";
                $table .= "<td>" . $aug_sql_data_ta . "</td>";
                $table .= "<td>" . $sep_sql_data_ta . "</td>";
                $table .= "<td>" . $oct_sql_data_ta . "</td>";
                $table .= "<td>" . $nov_sql_data_ta . "</td>";
                $table .= "<td>" . $dec_sql_data_ta . "</td>";

                $total_value_ta = $jan_sql_data_ta + $feb_sql_data_ta + $mar_sql_data_ta + $apr_sql_data_ta + $may_sql_data_ta + $jun_sql_data_ta + $jul_sql_data_ta + $aug_sql_data_ta + $sep_sql_data_ta + $oct_sql_data_ta + $nov_sql_data_ta + $dec_sql_data_ta;

                //total value 
                $table .= "<td>" . $total_value_ta . "</td>";

                $table .= " </tr>";
            }

            //total commissions
            foreach ($result->result_array() as $row_tc) {

                $emp_id = $row_tc['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_tc['first_name'] . ' ' . $row_tc['last_name'] . "</td><td>Commissions</td>";

                $jan_sql_tc = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_tc)) {
                    $jan_sql_data_tc = $jan_sql_tc[0]->total_commissions;
                } else {
                    $jan_sql_data_tc = '0';
                }

                $feb_sql_tc = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_tc)) {
                    $feb_sql_data_tc = $feb_sql_tc[0]->total_commissions;
                } else {
                    $feb_sql_data_tc = '0';
                }

                $mar_sql_tc = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_tc)) {
                    $mar_sql_data_tc = $mar_sql_tc[0]->total_commissions;
                } else {
                    $mar_sql_data_tc = '0';
                }

                $apr_sql_tc = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_tc)) {
                    $apr_sql_data_tc = $apr_sql_tc[0]->total_commissions;
                } else {
                    $apr_sql_data_tc = '0';
                }

                $may_sql_tc = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_tc)) {
                    $may_sql_data_tc = $may_sql_tc[0]->total_commissions;
                } else {
                    $may_sql_data_tc = '0';
                }

                $jun_sql_tc = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_tc)) {
                    $jun_sql_data_tc = $jun_sql_tc[0]->total_commissions;
                } else {
                    $jun_sql_data_tc = '0';
                }

                $jul_sql_tc = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_tc)) {
                    $jul_sql_data_tc = $jul_sql_tc[0]->total_commissions;
                } else {
                    $jul_sql_data_tc = '0';
                }

                $aug_sql_tc = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_tc)) {
                    $aug_sql_data_tc = $aug_sql_tc[0]->total_commissions;
                } else {
                    $aug_sql_data_tc = '0';
                }

                $sep_sql_tc = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_tc)) {
                    $sep_sql_data_tc = $sep_sql_tc[0]->total_commissions;
                } else {
                    $sep_sql_data_tc = '0';
                }

                $oct_sql_tc = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_tc)) {
                    $oct_sql_data_tc = $oct_sql_tc[0]->total_commissions;
                } else {
                    $oct_sql_data_tc = '0';
                }

                $nov_sql_tc = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_tc)) {
                    $nov_sql_data_tc = $nov_sql_tc[0]->total_commissions;
                } else {
                    $nov_sql_data_tc = '0';
                }

                $dec_sql_tc = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_tc)) {
                    $dec_sql_data_tc = $dec_sql_tc[0]->total_commissions;
                } else {
                    $dec_sql_data_tc = '0';
                }

                $table .= "<td>" . $jan_sql_data_tc . "</td>";
                $table .= "<td>" . $feb_sql_data_tc . "</td>";
                $table .= "<td>" . $mar_sql_data_tc . "</td>";
                $table .= "<td>" . $apr_sql_data_tc . "</td>";
                $table .= "<td>" . $may_sql_data_tc . "</td>";
                $table .= "<td>" . $jun_sql_data_tc . "</td>";
                $table .= "<td>" . $jul_sql_data_tc . "</td>";
                $table .= "<td>" . $aug_sql_data_tc . "</td>";
                $table .= "<td>" . $sep_sql_data_tc . "</td>";
                $table .= "<td>" . $oct_sql_data_tc . "</td>";
                $table .= "<td>" . $nov_sql_data_tc . "</td>";
                $table .= "<td>" . $dec_sql_data_tc . "</td>";

                $total_value_tc = $jan_sql_data_tc + $feb_sql_data_tc + $mar_sql_data_tc + $apr_sql_data_tc + $may_sql_data_tc + $jun_sql_data_tc + $jul_sql_data_tc + $aug_sql_data_tc + $sep_sql_data_tc + $oct_sql_data_tc + $nov_sql_data_tc + $dec_sql_data_tc;

                //total value 
                $table .= "<td>" . $total_value_tc . "</td>";

                $table .= " </tr>";
            }


            //total statutory deductions
            foreach ($result->result_array() as $row_tsd) {

                $emp_id = $row_tsd['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_tsd['first_name'] . ' ' . $row_tsd['last_name'] . "</td><td>Statutory Deductions</td>";

                $jan_sql_tsd = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_tsd)) {
                    $jan_sql_data_tsd = $jan_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $jan_sql_data_tsd = '0';
                }

                $feb_sql_tsd = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_tsd)) {
                    $feb_sql_data_tsd = $feb_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $feb_sql_data_tsd = '0';
                }

                $mar_sql_tsd = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_tsd)) {
                    $mar_sql_data_tsd = $mar_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $mar_sql_data_tsd = '0';
                }

                $apr_sql_tsd = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_tsd)) {
                    $apr_sql_data_tsd = $apr_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $apr_sql_data_tsd = '0';
                }

                $may_sql_tsd = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_tsd)) {
                    $may_sql_data_tsd = $may_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $may_sql_data_tsd = '0';
                }

                $jun_sql_tsd = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_tsd)) {
                    $jun_sql_data_tsd = $jun_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $jun_sql_data_tsd = '0';
                }

                $jul_sql_tsd = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_tsd)) {
                    $jul_sql_data_tsd = $jul_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $jul_sql_data_tsd = '0';
                }

                $aug_sql_tsd = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_tsd)) {
                    $aug_sql_data_tsd = $aug_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $aug_sql_data_tsd = '0';
                }

                $sep_sql_tsd = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_tsd)) {
                    $sep_sql_data_tsd = $sep_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $sep_sql_data_tsd = '0';
                }

                $oct_sql_tsd = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_tsd)) {
                    $oct_sql_data_tsd = $oct_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $oct_sql_data_tsd = '0';
                }

                $nov_sql_tsd = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_tsd)) {
                    $nov_sql_data_tsd = $nov_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $nov_sql_data_tsd = '0';
                }

                $dec_sql_tsd = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_tsd)) {
                    $dec_sql_data_tsd = $dec_sql_tsd[0]->total_statutory_deductions;
                } else {
                    $dec_sql_data_tsd = '0';
                }

                $table .= "<td>" . $jan_sql_data_tsd . "</td>";
                $table .= "<td>" . $feb_sql_data_tsd . "</td>";
                $table .= "<td>" . $mar_sql_data_tsd . "</td>";
                $table .= "<td>" . $apr_sql_data_tsd . "</td>";
                $table .= "<td>" . $may_sql_data_tsd . "</td>";
                $table .= "<td>" . $jun_sql_data_tsd . "</td>";
                $table .= "<td>" . $jul_sql_data_tsd . "</td>";
                $table .= "<td>" . $aug_sql_data_tsd . "</td>";
                $table .= "<td>" . $sep_sql_data_tsd . "</td>";
                $table .= "<td>" . $oct_sql_data_tsd . "</td>";
                $table .= "<td>" . $nov_sql_data_tsd . "</td>";
                $table .= "<td>" . $dec_sql_data_tsd . "</td>";

                $total_value_tsd = $jan_sql_data_tsd + $feb_sql_data_tsd + $mar_sql_data_tsd + $apr_sql_data_tsd + $may_sql_data_tsd + $jun_sql_data_tsd + $jul_sql_data_tsd + $aug_sql_data_tsd + $sep_sql_data_tsd + $oct_sql_data_tsd + $nov_sql_data_tsd + $dec_sql_data_tsd;

                //total value 
                $table .= "<td>" . $total_value_tsd . "</td>";

                $table .= " </tr>";
            }


            //total loan
            foreach ($result->result_array() as $row_tl) {

                $emp_id = $row_tl['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_tl['first_name'] . ' ' . $row_tl['last_name'] . "</td><td>Loan Amount</td>";

                $jan_sql_tl = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_tl)) {
                    $jan_sql_data_tl = $jan_sql_tl[0]->total_loan;
                } else {
                    $jan_sql_data_tl = '0';
                }

                $feb_sql_tl = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_tl)) {
                    $feb_sql_data_tl = $feb_sql_tl[0]->total_loan;
                } else {
                    $feb_sql_data_tl = '0';
                }

                $mar_sql_tl = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_tl)) {
                    $mar_sql_data_tl = $mar_sql_tl[0]->total_loan;
                } else {
                    $mar_sql_data_tl = '0';
                }

                $apr_sql_tl = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_tl)) {
                    $apr_sql_data_tl = $apr_sql_tl[0]->total_loan;
                } else {
                    $apr_sql_data_tl = '0';
                }

                $may_sql_tl = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_tl)) {
                    $may_sql_data_tl = $may_sql_tl[0]->total_loan;
                } else {
                    $may_sql_data_tl = '0';
                }

                $jun_sql_tl = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_tl)) {
                    $jun_sql_data_tl = $jun_sql_tl[0]->total_loan;
                } else {
                    $jun_sql_data_tl = '0';
                }

                $jul_sql_tl = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_tl)) {
                    $jul_sql_data_tl = $jul_sql_tl[0]->total_loan;
                } else {
                    $jul_sql_data_tl = '0';
                }

                $aug_sql_tl = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_tl)) {
                    $aug_sql_data_tl = $aug_sql_tl[0]->total_loan;
                } else {
                    $aug_sql_data_tl = '0';
                }

                $sep_sql_tl = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_tl)) {
                    $sep_sql_data_tl = $sep_sql_tl[0]->total_loan;
                } else {
                    $sep_sql_data_tl = '0';
                }

                $oct_sql_tl = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_tl)) {
                    $oct_sql_data_tl = $oct_sql_tl[0]->total_loan;
                } else {
                    $oct_sql_data_tl = '0';
                }

                $nov_sql_tl = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_tl)) {
                    $nov_sql_data_tl = $nov_sql_tl[0]->total_loan;
                } else {
                    $nov_sql_data_tl = '0';
                }

                $dec_sql_tl = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_tl)) {
                    $dec_sql_data_tl = $dec_sql_tl[0]->total_loan;
                } else {
                    $dec_sql_data_tl = '0';
                }

                $table .= "<td>" . $jan_sql_data_tl . "</td>";
                $table .= "<td>" . $feb_sql_data_tl . "</td>";
                $table .= "<td>" . $mar_sql_data_tl . "</td>";
                $table .= "<td>" . $apr_sql_data_tl . "</td>";
                $table .= "<td>" . $may_sql_data_tl . "</td>";
                $table .= "<td>" . $jun_sql_data_tl . "</td>";
                $table .= "<td>" . $jul_sql_data_tl . "</td>";
                $table .= "<td>" . $aug_sql_data_tl . "</td>";
                $table .= "<td>" . $sep_sql_data_tl . "</td>";
                $table .= "<td>" . $oct_sql_data_tl . "</td>";
                $table .= "<td>" . $nov_sql_data_tl . "</td>";
                $table .= "<td>" . $dec_sql_data_tl . "</td>";

                $total_value_tl = $jan_sql_data_tl + $feb_sql_data_tl + $mar_sql_data_tl + $apr_sql_data_tl + $may_sql_data_tl + $jun_sql_data_tl + $jul_sql_data_tl + $aug_sql_data_tl + $sep_sql_data_tl + $oct_sql_data_tl + $nov_sql_data_tl + $dec_sql_data_tl;

                //total value 
                $table .= "<td>" . $total_value_tl . "</td>";

                $table .= " </tr>";
            }



            //leave deduction
            foreach ($result->result_array() as $row_ld) {

                $emp_id = $row_ld['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_ld['first_name'] . ' ' . $row_ld['last_name'] . "</td><td>Leave Deduction</td>";

                $jan_sql_ld = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_ld)) {
                    $jan_sql_data_ld = $jan_sql_ld[0]->leave_deduction;
                } else {
                    $jan_sql_data_ld = '0';
                }

                $feb_sql_ld = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_ld)) {
                    $feb_sql_data_ld = $feb_sql_ld[0]->leave_deduction;
                } else {
                    $feb_sql_data_ld = '0';
                }

                $mar_sql_ld = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_ld)) {
                    $mar_sql_data_ld = $mar_sql_ld[0]->leave_deduction;
                } else {
                    $mar_sql_data_ld = '0';
                }

                $apr_sql_ld = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_ld)) {
                    $apr_sql_data_ld = $apr_sql_ld[0]->leave_deduction;
                } else {
                    $apr_sql_data_ld = '0';
                }

                $may_sql_ld = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_ld)) {
                    $may_sql_data_ld = $may_sql_ld[0]->leave_deduction;
                } else {
                    $may_sql_data_ld = '0';
                }

                $jun_sql_ld = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_ld)) {
                    $jun_sql_data_ld = $jun_sql_ld[0]->leave_deduction;
                } else {
                    $jun_sql_data_ld = '0';
                }

                $jul_sql_ld = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_ld)) {
                    $jul_sql_data_ld = $jul_sql_ld[0]->leave_deduction;
                } else {
                    $jul_sql_data_ld = '0';
                }

                $aug_sql_ld = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_ld)) {
                    $aug_sql_data_ld = $aug_sql_ld[0]->leave_deduction;
                } else {
                    $aug_sql_data_ld = '0';
                }

                $sep_sql_ld = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_ld)) {
                    $sep_sql_data_ld = $sep_sql_ld[0]->leave_deduction;
                } else {
                    $sep_sql_data_ld = '0';
                }

                $oct_sql_ld = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_ld)) {
                    $oct_sql_data_ld = $oct_sql_ld[0]->leave_deduction;
                } else {
                    $oct_sql_data_ld = '0';
                }

                $nov_sql_ld = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_ld)) {
                    $nov_sql_data_ld = $nov_sql_ld[0]->leave_deduction;
                } else {
                    $nov_sql_data_ld = '0';
                }

                $dec_sql_ld = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_ld)) {
                    $dec_sql_data_ld = $dec_sql_ld[0]->leave_deduction;
                } else {
                    $dec_sql_data_ld = '0';
                }

                $table .= "<td>" . $jan_sql_data_ld . "</td>";
                $table .= "<td>" . $feb_sql_data_ld . "</td>";
                $table .= "<td>" . $mar_sql_data_ld . "</td>";
                $table .= "<td>" . $apr_sql_data_ld . "</td>";
                $table .= "<td>" . $may_sql_data_ld . "</td>";
                $table .= "<td>" . $jun_sql_data_ld . "</td>";
                $table .= "<td>" . $jul_sql_data_ld . "</td>";
                $table .= "<td>" . $aug_sql_data_ld . "</td>";
                $table .= "<td>" . $sep_sql_data_ld . "</td>";
                $table .= "<td>" . $oct_sql_data_ld . "</td>";
                $table .= "<td>" . $nov_sql_data_ld . "</td>";
                $table .= "<td>" . $dec_sql_data_ld . "</td>";

                $total_value_ld = $jan_sql_data_ld + $feb_sql_data_ld + $mar_sql_data_ld + $apr_sql_data_ld + $may_sql_data_ld + $jun_sql_data_ld + $jul_sql_data_ld + $aug_sql_data_ld + $sep_sql_data_ld + $oct_sql_data_ld + $nov_sql_data_ld + $dec_sql_data_ld;

                //total value 
                $table .= "<td>" . $total_value_ld . "</td>";

                $table .= " </tr>";
            }

            //Advance salary
            foreach ($result->result_array() as $row_as) {

                $emp_id = $row_as['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_as['first_name'] . ' ' . $row_as['last_name'] . "</td><td>Advance Salary</td>";

                $jan_sql_as = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_as)) {
                    $jan_sql_data_as = $jan_sql_as[0]->advance_salary_amount;
                } else {
                    $jan_sql_data_as = '0';
                }

                $feb_sql_as = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_as)) {
                    $feb_sql_data_as = $feb_sql_as[0]->advance_salary_amount;
                } else {
                    $feb_sql_data_as = '0';
                }

                $mar_sql_as = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_as)) {
                    $mar_sql_data_as = $mar_sql_as[0]->advance_salary_amount;
                } else {
                    $mar_sql_data_as = '0';
                }

                $apr_sql_as = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_as)) {
                    $apr_sql_data_as = $apr_sql_as[0]->advance_salary_amount;
                } else {
                    $apr_sql_data_as = '0';
                }

                $may_sql_as = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_as)) {
                    $may_sql_data_as = $may_sql_as[0]->advance_salary_amount;
                } else {
                    $may_sql_data_as = '0';
                }

                $jun_sql_as = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_as)) {
                    $jun_sql_data_as = $jun_sql_as[0]->advance_salary_amount;
                } else {
                    $jun_sql_data_as = '0';
                }

                $jul_sql_as = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_as)) {
                    $jul_sql_data_as = $jul_sql_as[0]->advance_salary_amount;
                } else {
                    $jul_sql_data_as = '0';
                }

                $aug_sql_as = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_as)) {
                    $aug_sql_data_as = $aug_sql_as[0]->advance_salary_amount;
                } else {
                    $aug_sql_data_as = '0';
                }

                $sep_sql_as = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_as)) {
                    $sep_sql_data_as = $sep_sql_as[0]->advance_salary_amount;
                } else {
                    $sep_sql_data_as = '0';
                }

                $oct_sql_as = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_as)) {
                    $oct_sql_data_as = $oct_sql_as[0]->advance_salary_amount;
                } else {
                    $oct_sql_data_as = '0';
                }

                $nov_sql_as = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_as)) {
                    $nov_sql_data_as = $nov_sql_as[0]->advance_salary_amount;
                } else {
                    $nov_sql_data_as = '0';
                }

                $dec_sql_as = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_as)) {
                    $dec_sql_data_as = $dec_sql_as[0]->advance_salary_amount;
                } else {
                    $dec_sql_data_as = '0';
                }

                $table .= "<td>" . $jan_sql_data_as . "</td>";
                $table .= "<td>" . $feb_sql_data_as . "</td>";
                $table .= "<td>" . $mar_sql_data_as . "</td>";
                $table .= "<td>" . $apr_sql_data_as . "</td>";
                $table .= "<td>" . $may_sql_data_as . "</td>";
                $table .= "<td>" . $jun_sql_data_as . "</td>";
                $table .= "<td>" . $jul_sql_data_as . "</td>";
                $table .= "<td>" . $aug_sql_data_as . "</td>";
                $table .= "<td>" . $sep_sql_data_as . "</td>";
                $table .= "<td>" . $oct_sql_data_as . "</td>";
                $table .= "<td>" . $nov_sql_data_as . "</td>";
                $table .= "<td>" . $dec_sql_data_as . "</td>";

                $total_value_as = $jan_sql_data_as + $feb_sql_data_as + $mar_sql_data_as + $apr_sql_data_as + $may_sql_data_as + $jun_sql_data_as + $jul_sql_data_as + $aug_sql_data_as + $sep_sql_data_as + $oct_sql_data_as + $nov_sql_data_as + $dec_sql_data_as;

                //total value 
                $table .= "<td>" . $total_value_as . "</td>";

                $table .= " </tr>";
            }


            //net salary
            foreach ($result->result_array() as $row_ns) {

                $emp_id = $row_ns['employee_id'];

                $employee_main_id = $this->Reports_model->read_employee_info($emp_id);
                if (!is_null($employee_main_id)) {
                    $emp_main_id = $employee_main_id[0]->employee_id;
                } else {
                    $emp_main_id = '--';
                }

                $table .= " <tr><td>" . $emp_main_id . ' & ' . $row_ns['first_name'] . ' ' . $row_ns['last_name'] . "</td><td>Total Net Salary</td>";

                $jan_sql_ns = $this->Reports_model->jan_sql($emp_id);
                if (!is_null($jan_sql_ns)) {
                    $jan_sql_data_ns = $jan_sql_ns[0]->net_salary;
                } else {
                    $jan_sql_data_ns = '0';
                }

                $feb_sql_ns = $this->Reports_model->feb_sql($emp_id);
                if (!is_null($feb_sql_ns)) {
                    $feb_sql_data_ns = $feb_sql_ns[0]->net_salary;
                } else {
                    $feb_sql_data_ns = '0';
                }

                $mar_sql_ns = $this->Reports_model->mar_sql($emp_id);
                if (!is_null($mar_sql_ns)) {
                    $mar_sql_data_ns = $mar_sql_ns[0]->net_salary;
                } else {
                    $mar_sql_data_ns = '0';
                }

                $apr_sql_ns = $this->Reports_model->apr_sql($emp_id);
                if (!is_null($apr_sql_ns)) {
                    $apr_sql_data_ns = $apr_sql_ns[0]->net_salary;
                } else {
                    $apr_sql_data_ns = '0';
                }

                $may_sql_ns = $this->Reports_model->may_sql($emp_id);
                if (!is_null($may_sql_ns)) {
                    $may_sql_data_ns = $may_sql_ns[0]->net_salary;
                } else {
                    $may_sql_data_ns = '0';
                }

                $jun_sql_ns = $this->Reports_model->jun_sql($emp_id);
                if (!is_null($jun_sql_ns)) {
                    $jun_sql_data_ns = $jun_sql_ns[0]->net_salary;
                } else {
                    $jun_sql_data_ns = '0';
                }

                $jul_sql_ns = $this->Reports_model->jul_sql($emp_id);
                if (!is_null($jul_sql_ns)) {
                    $jul_sql_data_ns = $jul_sql_ns[0]->net_salary;
                } else {
                    $jul_sql_data_ns = '0';
                }

                $aug_sql_ns = $this->Reports_model->aug_sql($emp_id);
                if (!is_null($aug_sql_ns)) {
                    $aug_sql_data_ns = $aug_sql_ns[0]->net_salary;
                } else {
                    $aug_sql_data_ns = '0';
                }

                $sep_sql_ns = $this->Reports_model->sep_sql($emp_id);
                if (!is_null($sep_sql_ns)) {
                    $sep_sql_data_ns = $sep_sql_ns[0]->net_salary;
                } else {
                    $sep_sql_data_ns = '0';
                }

                $oct_sql_ns = $this->Reports_model->oct_sql($emp_id);
                if (!is_null($oct_sql_ns)) {
                    $oct_sql_data_ns = $oct_sql_ns[0]->net_salary;
                } else {
                    $oct_sql_data_ns = '0';
                }

                $nov_sql_ns = $this->Reports_model->nov_sql($emp_id);
                if (!is_null($nov_sql_ns)) {
                    $nov_sql_data_ns = $nov_sql_ns[0]->net_salary;
                } else {
                    $nov_sql_data_ns = '0';
                }

                $dec_sql_ns = $this->Reports_model->dec_sql($emp_id);
                if (!is_null($dec_sql_ns)) {
                    $dec_sql_data_ns = $dec_sql_ns[0]->net_salary;
                } else {
                    $dec_sql_data_ns = '0';
                }

                $table .= "<td>" . $jan_sql_data_ns . "</td>";
                $table .= "<td>" . $feb_sql_data_ns . "</td>";
                $table .= "<td>" . $mar_sql_data_ns . "</td>";
                $table .= "<td>" . $apr_sql_data_ns . "</td>";
                $table .= "<td>" . $may_sql_data_ns . "</td>";
                $table .= "<td>" . $jun_sql_data_ns . "</td>";
                $table .= "<td>" . $jul_sql_data_ns . "</td>";
                $table .= "<td>" . $aug_sql_data_ns . "</td>";
                $table .= "<td>" . $sep_sql_data_ns . "</td>";
                $table .= "<td>" . $oct_sql_data_ns . "</td>";
                $table .= "<td>" . $nov_sql_data_ns . "</td>";
                $table .= "<td>" . $dec_sql_data_ns . "</td>";

                $total_value_ns = $jan_sql_data_ns + $feb_sql_data_ns + $mar_sql_data_ns + $apr_sql_data_ns + $may_sql_data_ns + $jun_sql_data_ns + $jul_sql_data_ns + $aug_sql_data_ns + $sep_sql_data_ns + $oct_sql_data_ns + $nov_sql_data_ns + $dec_sql_data_ns;

                //total value 
                $table .= "<td>" . $total_value_ns . "</td>";

                $table .= " </tr>";
            }
        }

        $table .= "</tr></tbody></table></div></div>";

        header("Content-type: application/json");
        echo json_encode($table);
        exit();
    }

    //yearly salary report end


    public function overtime_summary_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Overtime Summary" . ' | ' . $this->Xin_model->site_title();

        $data['breadcrumbs'] = "Overtime Summary";

        $data['all_companies'] = $this->Xin_model->get_companies();

        $data['all_departments'] = $this->Department_model->all_departments();

        $data['all_employees'] = $this->Xin_model->all_employees();

        $data['all_location'] = $this->Location_model->all_office_locations();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/overtime_summary", $data, TRUE);

            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function overtime_summary_get()
    {



        $data['title'] = $this->Xin_model->site_title();

        $session = $this->session->userdata('username');

        if (!empty($session)) {

            $this->load->view("admin/reports/payroll", $data);
        } else {

            redirect('admin/');
        }

        // Datatables Variables

        $draw = intval($this->input->get("draw"));

        $start = intval($this->input->get("start"));

        $length = intval($this->input->get("length"));

        $aj_company = $_GET['aj_company'];
        $aj_department = $_GET['aj_department'];
        $location_id = $_GET['location_id'];
        $paysheet_employee_id = $_GET['paysheet_employee_id'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];

        $overtime_summary = $this->Reports_model->overtime_summary_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date);
        $data = array();
        foreach ($overtime_summary->result() as $get) {

            // user full name 
            $full_name = $get->first_name . ' ' . $get->last_name;

            $total_hours = $get->normal_ot_hours + $get->extra_ot_hours;

            $total_ot_amt = number_format($get->ot_amount, 3);

            $data[] = array(

                $get->employee_id,

                $full_name,

                $get->attendance_date,

                $total_hours,

                $total_ot_amt

            );
        }

        $output = array(

            "draw" => $draw,

            "recordsTotal" => $overtime_summary->num_rows(),

            "recordsFiltered" => $overtime_summary->num_rows(),

            "data" => $data

        );

        echo json_encode($output);

        exit();
    }


    public function nationality_wise_employee()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Nationality Wise Employee" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Nationality Wise Employee";
        $data['get_all_companies'] = $this->Xin_model->get_companies();
        $data['get_all_countries'] = $this->Xin_model->get_countries();


        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/nationality_wise_employee", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard/');
        }
    }

    public function nationality_wise_employee_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));


        $company_id = $_GET['company_id'];
        $nationality_id = $_GET['selected'];
        $status_id = $_GET['status_id'];


        $nationality = $this->Reports_model->nationality_wise_employee_report($company_id, $nationality_id, $status_id);
        $data = array();

        foreach ($nationality->result() as $get) {

            // get company
            $company = $this->Xin_model->read_company_info($get->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            $full_name = $get->first_name . ' ' . $get->last_name;
            // get status
            if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;
            // get designation
            $designation = $this->Designation_model->read_designation_information($get->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }
            // department
            $department = $this->Department_model->read_department_information($get->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }


            $data[] = array(
                $comp_name,
                $get->employee_id,
                $full_name,
                $get->country_name,
                $department_name,
                $designation_name,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $nationality->num_rows(),
            "recordsFiltered" => $nationality->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function assets_issued_to_employee_page()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Asset Issued To Employee" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Asset Issued To Employee";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();

        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/assets_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function assets_issued()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $endd_date = $this->uri->segment(4);

        $department_id = $this->uri->segment(5);
        $employee_id = $this->uri->segment(6);
        $start_date = $this->uri->segment(7);
        $company_id = $this->uri->segment(8);

        $status_id = $this->uri->segment(9);
        $employee_asset_report = $this->Reports_model->assets_issued_to_employee_query($company_id, $department_id, $employee_id, $start_date, $endd_date, $status_id);
        $data = array();

        foreach ($employee_asset_report->result() as $get) {



            // get company
            $company = $this->Xin_model->read_company_info($get->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // get emp id
            $emp_id = $this->Reports_model->employee_data_get($get->user_id);
            if (!is_null($emp_id)) {
                $emp_id_get = $emp_id[0]->employee_id;
            } else {
                $emp_id_get = '--';
            }

            // user full name 
            $full_name = $get->first_name . ' ' . $get->last_name;

            // get status
            if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;

            // get designation
            $designation = $this->Designation_model->read_designation_information($get->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            // department
            $department = $this->Department_model->read_department_information($get->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }


            $data[] = array(
                $emp_id_get,
                $full_name,
                $department_name,
                $designation_name,
                $get->date_of_joining,
                $get->asset_assigned_date,
                $get->name,
                $get->manufacturer,
                $get->company_asset_code,
                $get->serial_number
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee_asset_report->num_rows(),
            "recordsFiltered" => $employee_asset_report->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function asset_received_from_employee_page()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Asset Received From Employee" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Asset Received From Employee";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();


        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/asset_received_from_employee_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard/');
        }
    }

    public function asset_received_from_employee_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $aj_company = $_GET['company_id'];
        $department_id = $_GET['department_id'];
        $employee_id = $_GET['employee_id'];
        $employee_status = $_GET['employee_status'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];

        $asset_recevied_report = $this->Reports_model->asset_recevied_report_query($end_date, $aj_company, $department_id, $employee_id, $employee_status, $start_date);
        $data = array();

        foreach ($asset_recevied_report->result() as $get) {



            // get company
            $company = $this->Xin_model->read_company_info($get->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // get emp id
            $emp_id = $this->Reports_model->employee_data_get($get->user_id);
            if (!is_null($emp_id)) {
                $emp_id_get = $emp_id[0]->employee_id;
            } else {
                $emp_id_get = '--';
            }

            // user full name 
            $full_name = $get->first_name . ' ' . $get->last_name;

            // get status
            if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;

            // get designation
            $designation = $this->Designation_model->read_designation_information($get->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            // department
            $department = $this->Department_model->read_department_information($get->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }





            $data[] = array(
                $emp_id_get,
                $full_name,
                $department_name,
                $designation_name,
                $get->asset_assigned_date,
                $get->handover_date,
                $get->name,
                $get->company_asset_code,
                $get->serial_number
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $asset_recevied_report->num_rows(),
            "recordsFiltered" => $asset_recevied_report->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function leave_balance_page()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Leave Balance" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Leave Balance";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();
        //	$data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/leave_balance_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard/');
        }
    }

    public function leave_balance_report_employee_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $end_date = $this->uri->segment(4);
        $company_id = $this->uri->segment(5);


        $company_id = $_GET['company_id'];
        $location_company = $_GET['location_company'];
        $emp_id = $_GET['emp_id'];
        $leave_type = $_GET['leave_type'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];

        $leave_balance_report = $this->Reports_model->leave_balance_report_query($end_date, $company_id, $location_company, $emp_id, $leave_type, $start_date);

        $leave_balance_annual_report = $this->Reports_model->leave_balance_report_annual_query($end_date, $company_id, $location_company, $emp_id, $leave_type, $start_date);
        $data = array();


        if ($leave_type != 0) {

            foreach ($leave_balance_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }


                $carryfowards_leave_get = '0';


                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $leave_type_id_get,
                    $get->from_date,
                    $get->to_date,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }
        } else if ($leave_type == '0') {

            foreach ($leave_balance_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }


                $carryfowards_leave_get = '0';


                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $leave_type_id_get,
                    $get->from_date,
                    $get->to_date,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }

            //annual leave get
            foreach ($leave_balance_annual_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }


                $carryfowards_leave_get = '0';


                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $leave_type_id_get,
                    $get->from_date,
                    $get->to_date,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }
        }


        //annual leave get
        if ($leave_type == 3) {

            foreach ($leave_balance_annual_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }


                $carryfowards_leave_get = '0';


                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $leave_type_id_get,
                    $get->from_date,
                    $get->to_date,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }
        }


        $output = array(
            "draw" => $draw,
            "recordsTotal" => $leave_balance_report->num_rows(),
            "recordsFiltered" => $leave_balance_report->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function leave_summary_page()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Leave Summary" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Leave Summary";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();
        $data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/leave_summary_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard/');
        }
    }

    public function leave_summary_report_employee_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));


        $company_id = $_GET['company'];
        $location_company = $_GET['location_company'];
        $emp_id = $_GET['emp_id'];
        $leave_type = $_GET['leave_type'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];


        $leave_summary_report = $this->Reports_model->leave_summary_report_query($end_date, $location_company, $emp_id, $leave_type, $start_date, $company_id);

        $leave_summary_annual_report = $this->Reports_model->leave_summary_annual_report_query($end_date, $location_company, $emp_id, $leave_type, $start_date, $company_id);
        $data = array();


        if ($leave_type != 0) {

            foreach ($leave_summary_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }


                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }

                $carryfowards_leave_get = '0';

                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $leave_type_id_get,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }
        } else if ($leave_type == '0') {

            foreach ($leave_summary_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }


                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }

                $carryfowards_leave_get = '0';

                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $leave_type_id_get,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }

            //annual leave get
            foreach ($leave_summary_annual_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }


                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }

                $carryfowards_leave_get = '0';

                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $leave_type_id_get,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }
        }


        //annual leave get
        if ($leave_type == 3) {

            foreach ($leave_summary_annual_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }


                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }


                if ($get->leave_type_id == 7) {
                    $remaining_leave_count = '';
                } else {
                    $remaining_leave_count = $get->allotted_leave - $get->days;
                }

                $carryfowards_leave_get = '0';

                $data[] = array(
                    $emp_id_get,
                    $full_name,
                    $leave_type_id_get,
                    $carryfowards_leave_get,
                    $get->allotted_leave,
                    $get->days,
                    $remaining_leave_count
                );
            }
        }


        $output = array(
            "draw" => $draw,
            "recordsTotal" => $leave_summary_report->num_rows(),
            "recordsFiltered" => $leave_summary_report->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }


    //montly salary setup code
    public function monthly_salary_setup_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Monthly Salary Setup Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Monthly Salary Setup Report";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/monthly_salary_setup_page", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function monthly_salary_setup_get()
    {



        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');

        if (!empty($session)) {
            $this->load->view("admin/reports/payroll", $data);
        } else {
            redirect('admin/');
        }

        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $aj_company = $_GET['aj_company'];
        $aj_department = $_GET['aj_department'];
        $location_id = $_GET['location_id'];
        $employee_id = $_GET['paysheet_employee_id'];
        $month_year = $_GET['month_year'];

        $payslip_re = $this->Reports_model->monthly_salary_setup_get_data($aj_company, $aj_department, $location_id, $employee_id, $month_year);

        //print_r($payslip_re);exit;

        $data_filtered = array();

        $data = array();

        if (count($payslip_re) > 0) {

            foreach ($payslip_re as $value) {

                // department
                $department = $this->Department_model->read_department_information($value->department_id);
                if (!is_null($department)) {
                    $department_name = $department[0]->department_name;
                } else {
                    $department_name = '--';
                }


                //get head count
                $head_count = $this->Reports_model->get_head_count($value->department_id, $month_year);
                if (!is_null($head_count)) {
                    $head_count_get = $head_count[0]->headcount;
                } else {
                    $head_count_get = '--';
                }

                //get basic salary
                $basic_salary = $this->Reports_model->get_basic_salary($value->department_id, $month_year);
                if (!is_null($basic_salary)) {
                    $basic_salary_data = $basic_salary[0]->total_salary;
                } else {
                    $basic_salary_data = '--';
                }

                $tmp = array(
                    $department_name,
                    $head_count_get,
                    $basic_salary_data,
                );

                $gross_salary = $basic_salary_data;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount_total;

                            $gross_salary += $amount_data;

                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount_total;
                            } else {
                                $amount = '0';
                            }
                        }
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount_total;

                            $gross_salary += $amount_data;

                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount_total;
                            } else {
                                $amount = '0';
                            }
                        }
                    } else if ($allowance->type_id == 3) {

                        $sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount_data = $statutory_deduction->deduction_amount_total;

                            $gross_salary -= $amount_data;

                            if ($amount_data != '') {
                                $amount = $statutory_deduction->deduction_amount_total;
                            } else {
                                $amount = '0';
                            }
                        }
                    } else if ($allowance->type_id == 4) {

                        $sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

                        $binds = array($allowance->id, $month_year, $value->department_id);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount_total;

                            $gross_salary += $amount_data;

                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount_total;
                            } else {
                                $amount = '0';
                            }
                        }
                    } else if ($allowance->type_id == 5) {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

                        $binds = array($month_year, $value->department_id);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount_data = $payslip_loan->loan_amount_total;

                            $gross_salary -= $amount_data;

                            if ($amount_data != '') {
                                $amount = $payslip_loan->loan_amount_total;
                            } else {
                                $amount = '0';
                            }
                        }
                    }

                    array_push(
                        $tmp,
                        $amount

                    );
                }

                //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                } else {
                    $late_deduction_data_get = '0';
                }

                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $leave_data = $this->db->query($sql_leave)->row();

                if (!empty($leave_data)) {
                    $leave_amount = $leave_data->total_leave_deduction_amt;
                } else {
                    $leave_amount = "0";
                }

                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $overtime_data = $this->db->query($sql_ot)->row();

                if (!empty($overtime_data)) {
                    $ot_amount = $overtime_data->total_ot_amt;
                } else {
                    $ot_amount = "0";
                }

                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $value->department_id";
                $adv_data = $this->db->query($sql_adv)->row();

                if (!empty($adv_data)) {
                    $adv_amount = $adv_data->total_adv_amt;
                } else {
                    $adv_amount = "0";
                }

                //get Gross salary
                $gross_salary = $this->Reports_model->get_gross_salary($value->department_id, $month_year);
                if (!is_null($gross_salary)) {
                    $gross_salary_data = $gross_salary[0]->gross_salary;
                } else {
                    $gross_salary_data = '--';
                }

                array_push(
                    $tmp,
                    $late_deduction_data_get,
                    $leave_amount,
                    $ot_amount,
                    $adv_amount,
                    $gross_salary_data
                );


                $data[] = $tmp;
            }
        }

        $output = array(

            "draw" => $draw,

            "recordsTotal" => count($data),

            "recordsFiltered" => count($data),

            "data" => $data

        );

        echo json_encode($output);

        exit();
    }
    //montly salary setup code end


    //salary setup history start
    public function salary_setup_history_page()
    {

        $session = $this->session->userdata('username');

        if (empty($session)) {

            redirect('admin/');
        }

        $data['title'] = "Salary Setup History Report" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Salary Setup History Report";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();

        if (!empty($session)) {

            $data['subview'] = $this->load->view("admin/reports/salary_setup_history_page", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load

        } else {

            redirect('admin/dashboard/');
        }
    }

    public function salary_setup_history_get()
    {



        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');

        if (!empty($session)) {
            $this->load->view("admin/reports/payroll", $data);
        } else {
            redirect('admin/');
        }

        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $aj_company = $_GET['aj_company'];
        $aj_department = $_GET['aj_department'];
        $location_id = $_GET['location_id'];
        $employee_id = $_GET['paysheet_employee_id'];
        $from_year_data = $_GET['from_year'];
        $to_year_data = $_GET['to_year'];

        //from_month
        $from_year_spilt = explode("-", $from_year_data);
        $from_year = $from_year_spilt[0];
        //$month = $from_year_spilt[1];

        //to_month
        $to_year_spilt = explode("-", $to_year_data);
        $to_year = $to_year_spilt[0];
        //$month = $to_year_spilt[1];


        $salary_history = $this->Reports_model->salary_setup_history_get_data($aj_company, $aj_department, $location_id, $employee_id, $from_year, $to_year);

        $data_filtered = array();

        $data = array();

        if (count($salary_history) > 0) {

            foreach ($salary_history as $value) {

                //emp_info
                $employee = $this->Reports_model->read_employee_info($value->employee_id);

                if (!is_null($employee)) {
                    $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;
                    $emp_id = $employee[0]->employee_id;
                    $date_of_joining = $employee[0]->date_of_joining;
                    $basic_salary = $employee[0]->basic_salary;
                } else {
                    $full_name = '--';
                    $emp_id = '--';
                    $date_of_joining = '--';
                    $basic_salary = '--';
                }

                $emp_info = $emp_id . '<br>' . $full_name;

                // get department
                $department_get = $this->Reports_model->employee_department_join_get($value->employee_id);

                if (!is_null($department_get)) {
                    $department_name = $department_get[0]->department_name;
                } else {
                    $department_name = '--';
                }

                if ($value->inc_or_dec == '0') {
                    $inc_or_dec_data = '';
                } else if ($value->inc_or_dec == '') {
                    $inc_or_dec_data = '';
                } else {
                    $inc_or_dec_data = $value->inc_or_dec . ' : ';
                }

                $inc_dec_amt = $inc_or_dec_data . '' . $value->inc_amt;


                $emp_id_main = $value->employee_id;



                $sql_emp = "SELECT * FROM `xin_employees` WHERE user_id = $emp_id_main";
                $emp_basic_get = $this->db->query($sql_emp)->row();

                if (!empty($emp_basic_get)) {
                    $emp_basic_get_data = $emp_basic_get->basic_salary;
                } else {
                    $emp_basic_get_data = '0';
                }


                if ($value->history_type == 1) {
                    $gross_salary_data = $emp_basic_get_data + $value->amount;
                } else {
                    $gross_salary_data = 0;
                }


                $tmp = array(
                    $emp_info,
                    $value->date,
                    $department_name,
                    $value->amount,
                    ($value->history_type == 1) ? $value->amount : 0,
                    //$inc_dec_amt
                );


                $sql = "SELECT * FROM `allowance` WHERE type_id IN (1,2,3)";
                $allowances = $this->db->query($sql);

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_title = ? and allowance_id = ?';
                        $binds = array($allowance->id, $value->allowance_id);
                        $salary_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($salary_allowance)) {
                            $amount_data = $value->amount;
                            $gross_salary_data = $emp_basic_get_data + $value->amount;
                        } else {
                            $amount_data = '0';
                        }
                    }


                    if ($allowance->type_id == 3) {

                        $sql_ded = 'SELECT * FROM xin_salary_statutory_deductions WHERE deduction_title = ? and statutory_deductions_id = ?';
                        $binds = array($allowance->id, $value->allowance_id);
                        $salary_ded = $this->db->query($sql_ded, $binds)->row();

                        if (!empty($salary_ded)) {
                            $amount_data = $value->amount;
                            $gross_salary_data = $emp_basic_get_data + $value->amount;
                        } else {
                            $amount_data = '0';
                        }
                    }

                    array_push(
                        $tmp,
                        $amount_data

                    );
                }

                array_push(
                    $tmp,
                    $gross_salary_data
                );

                $data[] = $tmp;
            }
        }

        $output = array(

            "draw" => $draw,

            "recordsTotal" => count($data),

            "recordsFiltered" => count($data),

            "data" => $data

        );

        echo json_encode($output);

        exit();
    }
    //salary setup history end


    public function leave_register_page()
    {

        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = "Leave Register" . ' | ' . $this->Xin_model->site_title();
        $data['breadcrumbs'] = "Leave Register";
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_location'] = $this->Location_model->all_office_locations();
        $data['all_leave_type_get'] = $this->Xin_model->get_all_leave_type();


        if (!empty($session)) {
            $data['subview'] = $this->load->view("admin/reports/leave_register_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard/');
        }
    }

    public function leave_register_report_employee_get()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }
        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));


        $company_id = $_GET['company'];
        $department_id = $_GET['department_id'];
        $location_company = $_GET['location_company'];
        $emp_id = $_GET['emp_id'];
        $leave_type = $_GET['leave_type'];
        $start_date = $_GET['start_date'];
        $end_date = $_GET['end_date'];


        $leave_register_report = $this->Reports_model->leave_register_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);
        $leave_register_annual_report = $this->Reports_model->leave_register_annual_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id);

        $data = array();

        if ($leave_type != 0) {

            foreach ($leave_register_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }

                // department
                /*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';   
      } */

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }



                $date1 = $get->applied_on;
                $apply_date = date("d-m-Y", strtotime($date1));

                $date2 = $get->date_of_joining;
                $date_of_joining = date("d-m-Y", strtotime($date2));

                $date3 = $get->from_date;
                $from_date = date("d-m-Y", strtotime($date3));

                $date4 = $get->to_date;
                $to_date = date("d-m-Y", strtotime($date4));



                $data[] = array(
                    $apply_date,
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $designation_name,
                    $date_of_joining,
                    $leave_type_id_get,
                    $from_date,
                    $to_date,
                    $get->days,
                    $get->reason
                );
            }
        } else if ($leave_type == '0') {

            foreach ($leave_register_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }

                // department
                /*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';   
      } */

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }



                $date1 = $get->applied_on;
                $apply_date = date("d-m-Y", strtotime($date1));

                $date2 = $get->date_of_joining;
                $date_of_joining = date("d-m-Y", strtotime($date2));

                $date3 = $get->from_date;
                $from_date = date("d-m-Y", strtotime($date3));

                $date4 = $get->to_date;
                $to_date = date("d-m-Y", strtotime($date4));



                $data[] = array(
                    $apply_date,
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $designation_name,
                    $date_of_joining,
                    $leave_type_id_get,
                    $from_date,
                    $to_date,
                    $get->days,
                    $get->reason
                );
            }

            //annual leave get
            foreach ($leave_register_annual_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }

                // department
                /*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';   
      } */

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }



                $date1 = $get->applied_on;
                $apply_date = date("d-m-Y", strtotime($date1));

                $date2 = $get->date_of_joining;
                $date_of_joining = date("d-m-Y", strtotime($date2));

                $date3 = $get->from_date;
                $from_date = date("d-m-Y", strtotime($date3));

                $date4 = $get->to_date;
                $to_date = date("d-m-Y", strtotime($date4));



                $data[] = array(
                    $apply_date,
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $designation_name,
                    $date_of_joining,
                    $leave_type_id_get,
                    $from_date,
                    $to_date,
                    $get->days,
                    $get->remarks
                );
            }
        }


        //annual leave get
        if ($leave_type == 3) {

            foreach ($leave_register_annual_report->result() as $get) {


                // get company
                $company = $this->Xin_model->read_company_info($get->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                // get emp id
                $emp_id = $this->Reports_model->employee_data_get($get->user_id);
                if (!is_null($emp_id)) {
                    $emp_id_get = $emp_id[0]->employee_id;
                } else {
                    $emp_id_get = '--';
                }

                // user full name 
                $full_name = $get->first_name . ' ' . $get->last_name;

                // get status
                if ($get->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
                elseif ($get->is_active == 1) : $status = $this->lang->line('xin_employees_active');
                endif;

                // get designation
                $designation = $this->Designation_model->read_designation_information($get->designation_id);
                if (!is_null($designation)) {
                    $designation_name = $designation[0]->designation_name;
                } else {
                    $designation_name = '--';
                }

                // department
                /*  $department = $this->Department_model->read_department_information($get->department_id);
      if(!is_null($department)){
        $department_name = $department[0]->department_name;
      } else {
        $department_name = '--';   
      } */

                // get leave type id
                $leave_type_id = $this->Reports_model->leave_type_data_get($get->leave_type_id);
                if (!is_null($leave_type_id)) {
                    $leave_type_id_get = $leave_type_id[0]->type_name;
                } else {
                    $leave_type_id_get = '--';
                }



                $date1 = $get->applied_on;
                $apply_date = date("d-m-Y", strtotime($date1));

                $date2 = $get->date_of_joining;
                $date_of_joining = date("d-m-Y", strtotime($date2));

                $date3 = $get->from_date;
                $from_date = date("d-m-Y", strtotime($date3));

                $date4 = $get->to_date;
                $to_date = date("d-m-Y", strtotime($date4));



                $data[] = array(
                    $apply_date,
                    $emp_id_get,
                    $full_name,
                    $get->department_name,
                    $designation_name,
                    $date_of_joining,
                    $leave_type_id_get,
                    $from_date,
                    $to_date,
                    $get->days,
                    $get->remarks
                );
            }
        }


        $output = array(
            "draw" => $draw,
            "recordsTotal" => $leave_register_report->num_rows(),
            "recordsFiltered" => $leave_register_report->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }


    //rahul report section end

    public function employee_list()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->get_countries();
        //$data['all_branches'] = $this->Department_model->all_branches();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_list", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_list_reports()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        // Datatables Variables
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $department_id = $this->uri->segment(5);
        $nationality_id = $this->uri->segment(6);
        $employee_id = $this->uri->segment(7);
        $status = $this->uri->segment(8);

        // print_r($company_id);print_r("\n");
        // print_r($department_id);print_r("\n");
        // print_r($nationality_id);print_r("\n");
        // print_r($employee_id);print_r("\n");
        // print_r($status);print_r("\n");
        // exit();

        $employee = $this->Reports_model->get_employees_list_reports($company_id, $department_id, $nationality_id, $employee_id, $status);
        //print_r($employee);exit();
        $data = array();

        foreach ($employee->result() as $r) {

            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status
            if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;
            // get designation
            // 			$designation = $this->Designation_model->read_designation_information($r->designation_id);
            // 			if(!is_null($designation)){
            // 				$designation_name = $designation[0]->designation_name;
            // 			} else {
            // 				$designation_name = '--';	
            // 			}
            // department
            $department = $this->Department_model->read_department_information($r->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }
            //nationality

            //print_r($r->nationality_id);exit();
            $nationality = $this->Department_model->read_nationality_information($r->nationality_id);
            //print_r($nationality);exit();
            if (!is_null($nationality)) {
                $nationality_name = $nationality[0]->country_name;
            } else {
                $nationality_name = '--';
            }


            $data[] = array(
                $r->employee_id,
                $full_name,
                $comp_name,
                $department_name,
                $nationality_name,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function department_wise_employee()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_department') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_department');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        //print_r($data['all_departments']);exit();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/department_wise_employee", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function department_wise_employee_reports()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $department_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $status = $this->uri->segment(7);


        // print_r($company_id);print_r("\n");
        // print_r($company_id);print_r("\n");
        // print_r($location_id);print_r("\n");
        // print_r($status);exit();

        $employee = $this->Reports_model->department_wise_employee_reports($company_id, $department_id, $location_id, $status);

        //print_r($employee->result());exit();

        $data = array();

        foreach ($employee->result() as $r) {
            //print_r($r->is_active);exit();	  
            // get company
            // $company = $this->Xin_model->read_company_info($r->company_id);
            // if(!is_null($company)){
            // 	$comp_name = $company[0]->name;
            // } else {
            // 	$comp_name = '--';	
            // }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status


            if ($r->is_active == 0) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;


            // get designation
            // 			$designation = $this->Designation_model->read_designation_information($r->designation_id);
            // 			if(!is_null($designation)){
            // 				$designation_name = $designation[0]->designation_name;
            // 			} else {
            // 				$designation_name = '--';	
            // 			}
            // department
            // $department = $this->Department_model->read_department_information($r->department_id);
            // if(!is_null($department)){
            // 	$department_name = $department[0]->department_name;
            // } else {
            // 	$department_name = '--';	
            // }

            //designation
            // $designation = $this->Department_model->read_designation_information($r->designation_id);
            // if(!is_null($designation)){
            // 	$designation_name = $designation[0]->designation_name;
            // } else {
            // 	$designation_name = '--';	
            // }

            //designation
            //nationality

            //print_r($r->nationality_id);exit();


            $data[] = array(
                $r->employee_id,
                $full_name,
                $r->name,
                $r->department_name,
                $r->date_of_joining,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function department_wise_head_count()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = $this->lang->line('xin_hr_report_department_wise_head_count') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'department wise head count report';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_department_wise_head_count');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        //print_r($data['all_designation']);exit();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/department_wise_head_count", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function department_wise_head_count_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $department_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $status = $this->uri->segment(7);

        // print_r($location_id);exit();

        $employee = $this->Reports_model->department_wise_head_count_report($company_id, $department_id, $location_id, $status);

        $data = array();

        foreach ($employee->result() as $r) {
            //print_r($r->is_active);exit();	  
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            //$full_name = $r->first_name.' '.$r->last_name;	
            //print_r($full_name);exit();
            // get status


            // if($r->is_active==2): $status = $this->lang->line('xin_employees_inactive');
            // elseif($r->is_active==1): $status = $this->lang->line('xin_employees_active'); endif;


            // get designation
            // 			$designation = $this->Designation_model->read_designation_information($r->designation_id);
            // 			if(!is_null($designation)){
            // 				$designation_name = $designation[0]->designation_name;
            // 			} else {
            // 				$designation_name = '--';	
            // 			}
            // department
            // $department = $this->Department_model->read_department_information($r->department_id);
            // if(!is_null($department)){
            // 	$department_name = $department[0]->department_name;
            // } else {
            // 	$department_name = '--';	
            // }

            //designation
            // $designation = $this->Department_model->read_designation_information($r->designation_id);
            // if(!is_null($designation)){
            // 	$designation_name = $designation[0]->designation_name;
            // } else {
            // 	$designation_name = '--';	
            // }

            //designation
            //nationality

            //print_r($r->nationality_id);exit();


            $data[] = array(
                $comp_name,
                $r->department_name,
                $r->department_code,
                $r->headcount
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function designation_wise_employee()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = $this->lang->line('xin_hr_report_employees_designation') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'designation wise employee report';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_designation');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_designation'] = $this->Department_model->all_designation();
        //print_r($data['all_designation']);exit();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/designation_wise_employee", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function designation_wise_employee_reports()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $designation_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $status = $this->uri->segment(7);

        //print_r($company_id);print_r("\n");
        //print_r($designation_id);
        //print_r($location_id);print_r("\n");
        //print_r($status);
        //exit();

        $employee = $this->Reports_model->designation_wise_employee_reports($company_id, $designation_id, $location_id, $status);

        $data = array();

        foreach ($employee->result() as $r) {
            //print_r($r->is_active);exit();	  
            // get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status


            if ($r->is_active == 2) : $status = $this->lang->line('xin_employees_inactive');
            elseif ($r->is_active == 1) : $status = $this->lang->line('xin_employees_active');
            endif;


            // get designation
            // 			$designation = $this->Designation_model->read_designation_information($r->designation_id);
            // 			if(!is_null($designation)){
            // 				$designation_name = $designation[0]->designation_name;
            // 			} else {
            // 				$designation_name = '--';	
            // 			}
            // department
            // $department = $this->Department_model->read_department_information($r->department_id);
            // if(!is_null($department)){
            // 	$department_name = $department[0]->department_name;
            // } else {
            // 	$department_name = '--';	
            // }

            //designation
            // $designation = $this->Department_model->read_designation_information($r->designation_id);
            // if(!is_null($designation)){
            // 	$designation_name = $designation[0]->designation_name;
            // } else {
            // 	$designation_name = '--';	
            // }

            //designation
            //nationality

            //print_r($r->nationality_id);exit();


            $data[] = array(
                $r->employee_id,
                $full_name,
                $comp_name,
                $r->designation_name,
                $r->date_of_joining,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_document_expiry()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = $this->lang->line('xin_hr_employee_document_expired') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_document_expired');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_documents'] = $this->Department_model->all_documents();
        //print_r($data['all_designation']);exit();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_document_expiry", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_document_expiry_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $department_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $document_id = $this->uri->segment(7);
        $from_date = $this->uri->segment(8);
        $to_date = $this->uri->segment(9);

        // 		print_r($company_id);
        // 		print_r($department_id);
        // 		print_r($location_id);
        // 		print_r($document_id);
        // 		print_r($from_date);print_r($to_date);
        // 		exit();

        $employee = $this->Reports_model->employee_document_expiry_report($company_id, $department_id, $location_id, $document_id, $from_date, $to_date);

        $data = array();

        foreach ($employee->result() as $r) {
            //print_r($r->is_active);exit();	  
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status


            // if($r->is_active==2): $status = $this->lang->line('xin_employees_inactive');
            // elseif($r->is_active==1): $status = $this->lang->line('xin_employees_active'); endif;


            // get designation
            $designation = $this->Designation_model->read_designation_information($r->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }
            // department
            $department = $this->Department_model->read_department_information($r->department_id);
            if (!is_null($department)) {
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';
            }

            //designation
            // $designation = $this->Department_model->read_designation_information($r->designation_id);
            // if(!is_null($designation)){
            // 	$designation_name = $designation[0]->designation_name;
            // } else {
            // 	$designation_name = '--';	
            // }

            //designation
            //nationality

            //print_r($r->nationality_id);exit();


            $data[] = array(
                $comp_name,
                $full_name,
                $department_name,
                $designation_name,
                $r->date_of_joining,
                $r->title,
                $r->date_of_expiry
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_monthly_leave_taken()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_monthly_leave') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_monthly_leave');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_leaves'] = $this->Department_model->all_leaves();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_monthly_leave_taken", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_monthly_leave_taken_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $department_id = $this->uri->segment(6);
        $leave_id = $this->uri->segment(7);
        $location_id = $this->uri->segment(8);
        $year = $this->uri->segment(9);
        $status = $this->uri->segment(10);

        $data = array();

        $employee = $this->Reports_model->employee_monthly_leave_taken_report($company_id, $employee_id, $department_id, $leave_id, $year, $location_id, $status);
        //print_r($employee->result());exit();

        $data = array();
        $jan_count = array();
        $feb_count = array();
        $mar_count = array();
        $april_count = array();
        $may_count = array();
        $june_count = array();
        $july_count = array();
        $august_count = array();
        $sep_count = array();
        $oct_count = array();
        $nov_count = array();
        $dec_count = array();

        foreach ($employee->result() as $r) {
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            $department_name = $this->Xin_model->read_department_info($r->company_id);
            if (!is_null($department_name)) {
                $dept_name = $department_name[0]->department_name;
            } else {
                $dept_name = '--';
            }

            // get designation
            $designation = $this->Designation_model->read_designation_information($r->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            //print_r($from_date);print_r($to_date);exit();
            $monthly_leave_type_count = $this->Reports_model->get_monthly_leave_taken($r->user_id, $year);
            //print_r($monthly_leave_type_count);exit();

            foreach ($monthly_leave_type_count as $leave_type_name => $leave_type_count) {
                //print_r($leave_type_count);
                $January = 'January';
                $February = 'February';
                $March = 'March';
                $April = 'April';
                $May = 'May';
                $June = 'June';
                $July = 'July';
                $August = 'August';
                $September = 'September';
                $October = 'October';
                $November = 'November';
                $December = 'December';
                for ($times = 1; $times <= 12; $times++) {
                    if (!array_key_exists($January, $leave_type_count)) {
                        $leave_type_count['January'] = '--';
                    } else if (!array_key_exists($February, $leave_type_count)) {
                        # code...
                        $leave_type_count['February'] = '--';
                    } else if (!array_key_exists($March, $leave_type_count)) {
                        # code...
                        $leave_type_count['March'] = '--';
                    } else if (!array_key_exists($April, $leave_type_count)) {
                        # code...
                        $leave_type_count['April'] = '--';
                    } else if (!array_key_exists($May, $leave_type_count)) {
                        # code...
                        $leave_type_count['May'] = '--';
                    } else if (!array_key_exists($June, $leave_type_count)) {
                        # code...
                        $leave_type_count['June'] = '--';
                    } else if (!array_key_exists($July, $leave_type_count)) {
                        # code...
                        $leave_type_count['July'] = '--';
                    } else if (!array_key_exists($August, $leave_type_count)) {
                        # code...
                        $leave_type_count['August'] = '--';
                    } else if (!array_key_exists($September, $leave_type_count)) {
                        # code...
                        $leave_type_count['September'] = '--';
                    } else if (!array_key_exists($October, $leave_type_count)) {
                        # code...
                        $leave_type_count['October'] = '--';
                    } else if (!array_key_exists($November, $leave_type_count)) {
                        # code...
                        $leave_type_count['November'] = '--';
                    } else if (!array_key_exists($December, $leave_type_count)) {
                        # code...
                        $leave_type_count['December'] = '--';
                    }
                }
                //print_r($r->user_id);
                //print_r($leave_type_count);

                $January_leave_count = '';
                $feb_leave_count = '';
                $march_leave_count = '';
                $april_leave_count = '';
                $may_leave_count = '';
                $june_leave_count = '';
                $july_leave_count = '';
                $aug_leave_count = '';
                $sep_leave_count = '';
                $october_leave_count = '';
                $nov_leave_count = '';
                $dec_leave_count = '';
                foreach ($leave_type_count as $key => $value) {

                    if ($key == 'January') {
                        # code...
                        $January_leave_count = $value;
                    } else if ($key == 'February') {
                        # code...
                        $feb_leave_count = $value;
                    } else if ($key == 'March') {
                        # code...
                        $march_leave_count = $value;
                    } else if ($key == 'April') {
                        # code...
                        $april_leave_count = $value;
                    } else if ($key == 'May') {
                        # code...
                        $may_leave_count = $value;
                    } else if ($key == 'June') {
                        # code...
                        $june_leave_count = $value;
                    } else if ($key == 'July') {
                        # code...
                        $july_leave_count = $value;
                    } else if ($key == 'August') {
                        # code...
                        $aug_leave_count = $value;
                    } else if ($key == 'September') {
                        # code...
                        $sep_leave_count = $value;
                    } else if ($key == 'October') {
                        # code...
                        $october_leave_count = $value;
                    } else if ($key == 'November') {
                        # code...
                        $nov_leave_count = $value;
                    } else if ($key == 'December') {
                        # code...
                        $dec_leave_count = $value;
                    }
                    //print_r($January_leave_count);
                }

                $data[] = array(
                    $r->user_id,
                    $comp_name,
                    $full_name,
                    $dept_name,
                    $designation_name,
                    $leave_type_name,
                    $January_leave_count,
                    $feb_leave_count,
                    $march_leave_count,
                    $april_leave_count,
                    $may_leave_count,
                    $june_leave_count,
                    $july_leave_count,
                    $aug_leave_count,
                    $sep_leave_count,
                    $october_leave_count,
                    $nov_leave_count,
                    $dec_leave_count
                );
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function advance_loan_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }

        $data['title'] = $this->lang->line('xin_hr_employee_advance_report') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_report');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //$data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_advance_loan", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_advance_loan_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);

        if ($from_date != 0 || $to_date != 0) {
            # code...
            $from_date = date("Y-m-d", strtotime($from_date));
            $to_date = date("Y-m-d", strtotime($to_date));
        }

        // print_r($company_id);
        // print_r($employee_id);
        // print_r($location_id);
        // print_r($from_date);
        // print_r($to_date);
        //print_r($status);
        // exit();

        $employee = $this->Reports_model->employee_advance_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);

        //print_r($employee);exit();

        $data = array();

        foreach ($employee->result() as $r) {
            //get closing balance of each employee
            //print_r($r->user_id);print_r(" ");
            //print_r($r->Total_advance_amount);print_r(" ");

            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            $Total_deducted_amount = $this->Reports_model->get_Total_deducted_amount($r->user_id);

            foreach ($Total_deducted_amount->result() as $d) {

                $total_deduct_amount = $d->Total_deducted_amount;
            }
            //print_r($total_deduct_amount);exit();
            $closing_balance = $r->Total_advance_amount - $total_deduct_amount;
            //print_r($closing_balance);exit();
            //get closing balance of each employee

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status

            if ($r->status == 0) : $status = 'pending';
            elseif ($r->status == 1) : $status = 'accepted';
            elseif ($r->status == 2) : $status = 'rejected';
            endif;

            $adjusted_amount = 0.00;


            // $data[] = array(
            // 	$r->employee_id,
            // 	$comp_name,
            // 	$full_name,
            // 	$r->month_year,
            // 	$r->end_date,
            // 	$r->monthly_installment,
            // 	$r->Total_advance_amount,
            // 	$total_deduct_amount,
            // 	$adjusted_amount,
            // 	$closing_balance,
            // 	$status
            // );

            $data[] = array(
                $r->employee_id,
                $comp_name,
                $full_name,
                $r->Total_advance_amount,
                $total_deduct_amount,
                $adjusted_amount,
                $closing_balance,
                $status
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_loan_salary()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_employee_loan_report') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'employee losn report';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_loan_report');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //$data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_loan", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_loan_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);

        //change date format from dd-mm-yyyy to yyyy-mm-dd
        if ($from_date != 0 || $to_date != 0) {
            # code...
            $from_date = date("Y-m-d", strtotime($from_date));
            $to_date = date("Y-m-d", strtotime($to_date));
        }
        //change date format from dd-mm-yyyy to yyyy-mm-dd

        // print_r($company_id);
        // print_r($employee_id);
        // print_r($location_id);
        // print_r($from_date_new);
        // print_r($to_date_new);
        // print_r($status);
        // exit();

        $employee = $this->Reports_model->employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);
        //print_r($employee->result());exit();

        $data = array();

        foreach ($employee->result() as $r) {

            //print_r($r->user_id);print_r(" ");
            //print_r($r->Total_advance_amount);print_r(" ");
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            //get closing balance of each employee

            $Total_deducted_amount = $this->Reports_model->get_Total_deducted_amount_loan_report($r->user_id);

            foreach ($Total_deducted_amount->result() as $d) {

                $total_deduct_amount = $d->Total_deducted_amount;
            }
            $closing_balance = $r->Total_loan_amount - $total_deduct_amount;
            //print_r($closing_balance);exit();
            //get closing balance of each employee

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status
            if ($r->status == 0) : $status = 'pending';
            elseif ($r->status == 1) : $status = 'approved';
            elseif ($r->status == 2) : $status = 'rejected';
            endif;

            $adjusted_amount = 0.00;


            // $data[] = array(
            // 	$r->employee_id,
            // 	$comp_name,
            // 	$full_name,
            // 	$r->loan_deduction_title,
            // 	$r->loan_deduction_amount,
            // 	$r->Total_loan_amount,
            // 	$total_deduct_amount,
            // 	$adjusted_amount,
            // 	$closing_balance,
            // 	$status,
            // 	$r->end_date
            // );

            $data[] = array(
                $r->employee_id,
                $comp_name,
                $full_name,
                $r->loan_deduction_title,
                $r->Total_loan_amount,
                $total_deduct_amount,
                $adjusted_amount,
                $closing_balance,
                $status,
                $r->end_date
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_advance_loan_outstanding_details()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_employee_advance_loan_outstanding_details') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'Advance Loan Outstanding Report';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_loan_outstanding_details');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //$data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_advance_loan_outstanding_details", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_advance_loan_outstanding_report()
    {

        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        //$company_id = $this->input->get('company_id');
        $employee_id = $this->uri->segment(5);
        //print_r($company_id);exit();
        //$employee_id = $this->input->get('employee_id');
        $location_id = $this->uri->segment(6);
        //$location_id = $this->input->get('location_id');
        $from_date = $this->uri->segment(7);
        //print_r($from_date);exit();
        //$from_date = $this->input->get('from_date');
        $to_date = $this->uri->segment(8);
        //print_r($from_date);exit();
        $status = $this->uri->segment(9);

        //change date format from dd-mm-yyyy to yyyy-mm-dd
        if ($from_date != 0 || $to_date != 0) {
            # code...
            $from_date = date("Y-m-d", strtotime($from_date));
            $to_date = date("Y-m-d", strtotime($to_date));
        }
        //change date format from dd-mm-yyyy to yyyy-mm-dd

        $employee = $this->Reports_model->employee_advance_loan_outstanding_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);
        //print_r($employee->result());exit();

        $table = "";
        $table .= "<table class='datatables-demo table table-striped table-bordered' id='advance_loan_outstanding'>
                      <thead>
                        <tr>
                            <th>Employee ID</th>
			                <th>Company</th>
			                <th>Employee Name</th>
			                <th>Amount Type</th>
			                <th>Amount</th>
			                <th>Advance Date</th>
			                <th>Monthly Installment</th>
			                <th>Adjusted Amount</th>
			                <th>Closing Balance</th>
                        </tr>
                        </thead>
                      <tbody>";

        foreach ($employee->result() as $row) {

            //get amount type
            if ($row->table_name == 'xin_salary_loan_deductions_monthwise') {
                # code...
                $amount_type = 'Loan Amount';
            } else if ($row->table_name == 'xin_advance_deductions_monthwise') {
                $amount_type = 'Advance Amount';
            }
            //get amount type

            //get employee id
            $employee_id = $this->Xin_model->read_employee_id($row->employee_id);
            //print_r($employee_id);exit();
            if (!is_null($employee_id)) {
                $employee_id = $employee_id[0]->employee_id;
            } else {
                $employee_id = '--';
            }


            //get company
            $company = $this->Xin_model->read_company_info($row->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }
            //fullname
            $full_name = $row->first_name . ' ' . $row->last_name;

            //get closing balance of each employee

            $Total_deducted_amount = $this->Reports_model->get_Total_deducted_advance_loan_report($row->employee_id, $row->table_name);

            foreach ($Total_deducted_amount as $d) {

                $total_deduct_amount = $d->Total_deducted_amount;
            }
            $closing_balance = $row->Total_loan_amount - $total_deduct_amount;
            //get closing balance of each employee

            $get_advance_loan_employee = $this->Reports_model->get_advance_loan_employee($row->employee_id, $row->advance_or_loan_count_helper_id, $row->table_name);

            $table .= "<tr>
                        <td>" . $employee_id . ".</td>
                        <td>" . $comp_name . "</td>
                        <td>" . $full_name . "</td>
                        <td>" . $amount_type . "</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";

            foreach ($get_advance_loan_employee as $r) {

                $table .= "<tr>  
            			<td></td>
                        <td></td>
                        <td></td>
                        <td></td>
            			<td>" . $row->Amount . "</td>
        				<td>" . $r->month_year . "</td>
                    	<td>" . $r->monthly_installment . "</td>
                    	<td>0.00</td>
                        <td>" . $closing_balance . "</td>
                    </tr>";
            }
        }
        $table .= "</tbody>
	                <tfoot>
	                    <tr>
	                        <th>Employee ID</th>
			                <th>Company</th>
			                <th>Employee Name</th>
			                <th>Amount Type</th>
			                <th>Amount</th>
			                <th>Advance Date</th>
			                <th>Monthly Installment</th>
			                <th>Adjusted Amount</th>
			                <th>Closing Balance</th>
	                    </tr>
	                </tfoot>
	            </table>";

        //print_r($employee);exit();
        echo json_encode($table);
        exit();
    }

    public function employee_advance_loan_register()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_employee_advance_loan_register') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'Advance Loan Register Report';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_advance_loan_register');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //$data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_advance_loan_register", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_advance_loan_register_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);

        //change date format from dd-mm-yyyy to yyyy-mm-dd
        if ($from_date != 0 || $to_date != 0) {
            # code...
            $from_date = date("Y-m-d", strtotime($from_date));
            $to_date = date("Y-m-d", strtotime($to_date));
        }
        //change date format from dd-mm-yyyy to yyyy-mm-dd

        // print_r($company_id);
        // print_r($employee_id);
        // print_r($location_id);
        // print_r($from_date);
        // print_r($to_date);
        // print_r($status);
        // exit();

        $employee = $this->Reports_model->employee_advance_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);

        //print_r($employee->result());exit();

        $data = array();

        foreach ($employee->result() as $r) {

            //print_r($r->user_id);print_r(" ");
            //print_r($r->Total_advance_amount);print_r(" ");

            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            //get advance type
            if ($r->table_name == 'xin_salary_loan_deductions') {
                $type = 'Loan';
            } else {
                $type = 'Advance';
            }

            //get number of installment of advance or loan
            $advance_or_loan_count_helper_id = $this->Reports_model->read_number_of_installment_of_advance_or_loan($r->advance_or_loan_count_helper_id, $r->table_name);
            if (!is_null($advance_or_loan_count_helper_id)) {
                $num_of_installment = $advance_or_loan_count_helper_id[0]->number_of_installment;
            } else {
                $num_of_installment = '--';
            }

            // user full name 
            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);exit();
            // get status
            // if($r->status==0): $status = 'pending';
            // elseif($r->status==1): $status = 'approved';
            // elseif($r->status==2): $status = 'rejected'; endif;			

            $data[] = array(
                $r->employee_id,
                $comp_name,
                $full_name,
                $type,
                $r->Amount,
                $num_of_installment,
                $r->monthly_installment,
                $r->month_year
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_shift_allocation()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_shift_allo') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_shift_allo');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        //$data['all_branches'] = $this->Department_model->all_branches();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_shift_allocation", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_shift_allocation_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);
        $department_id = $this->uri->segment(10);

        $data = array();

        $employee = $this->Reports_model->employee_late_in_request_status_report($company_id, $employee_id, $department_id, $location_id, $from_date, $to_date, $status);
        if ($employee) {
            foreach ($employee->result() as $r) {
                # code...
                //get company
                $leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
                if ($leave != '') {
                    # code...
                    continue;
                }
                $company = $this->Xin_model->read_company_info($r->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                $full_name = $r->first_name . ' ' . $r->last_name;
                //print_r($in_time);exit();

                $att_date = $r->attendance_date;
                $get_day = strtotime($att_date);
                $day = date('l', $get_day);

                //print_r($day);exit();

                //print_r($r->office_shift_id);exit();
                $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);
                //print_r($office_shift);exit();

                if (isset($office_shift[0]->shift_name) != '') {
                    $shift_name = $office_shift[0]->shift_name;
                } else {
                    $shift_name = '--';
                }

                if ($day == 'Monday') {
                    if (isset($office_shift[0]->monday_in_time) != '' && isset($office_shift[0]->monday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->monday_in_time;
                        $shift_out_time = $office_shift[0]->monday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->monday_in_time) == '' && isset($office_shift[0]->monday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->monday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->monday_in_time) != '' && isset($office_shift[0]->monday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->monday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                } else if ($day == 'Tuesday') {
                    if (isset($office_shift[0]->tuesday_in_time) != '' && isset($office_shift[0]->tuesday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->tuesday_in_time;
                        $shift_out_time = $office_shift[0]->tuesday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->tuesday_in_time) == '' && isset($office_shift[0]->tuesday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->tuesday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->tuesday_in_time) != '' && isset($office_shift[0]->tuesday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->tuesday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                } else if ($day == 'Wednesday') {
                    if (isset($office_shift[0]->wednesday_in_time) != '' && isset($office_shift[0]->wednesday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->wednesday_in_time;
                        $shift_out_time = $office_shift[0]->wednesday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->wednesday_in_time) == '' && isset($office_shift[0]->wednesday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->wednesday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->wednesday_in_time) != '' && isset($office_shift[0]->wednesday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->wednesday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                } else if ($day == 'Thursday') {
                    if (isset($office_shift[0]->thursday_in_time) != '' && isset($office_shift[0]->thursday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->thursday_in_time;
                        $shift_out_time = $office_shift[0]->thursday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->thursday_in_time) == '' && isset($office_shift[0]->thursday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->thursday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->thursday_in_time) != '' && isset($office_shift[0]->thursday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->thursday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                } else if ($day == 'Friday') {
                    if (isset($office_shift[0]->friday_in_time) != '' && isset($office_shift[0]->friday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->friday_in_time;
                        $shift_out_time = $office_shift[0]->friday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->friday_in_time) == '' && isset($office_shift[0]->friday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->friday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->friday_in_time) != '' && isset($office_shift[0]->friday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->friday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                } else if ($day == 'Saturday') {
                    if (isset($office_shift[0]->saturday_in_time) != '' && isset($office_shift[0]->saturday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->saturday_in_time;
                        $shift_out_time = $office_shift[0]->saturday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->saturday_in_time) == '' && isset($office_shift[0]->saturday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->saturday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->saturday_in_time) != '' && isset($office_shift[0]->saturday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->saturday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                } else if ($day == 'Sunday') {
                    if (isset($office_shift[0]->sunday_in_time) != '' && isset($office_shift[0]->sunday_out_time) != '') {
                        $shift_in_time = $office_shift[0]->sunday_in_time;
                        $shift_out_time = $office_shift[0]->sunday_out_time;
                        $shift_hours = round(abs(strtotime($shift_out_time) - strtotime($shift_in_time)) / 3600, 2);
                    } else if (isset($office_shift[0]->sunday_in_time) == '' && isset($office_shift[0]->sunday_out_time) != '') {
                        $shift_in_time = 'office shift is not assigned';
                        $shift_out_time = $office_shift[0]->sunday_out_time;
                        $shift_hours = '00:00:00';
                    } else if (isset($office_shift[0]->sunday_in_time) != '' && isset($office_shift[0]->sunday_out_time) == '') {
                        $shift_in_time = $office_shift[0]->sunday_in_time;
                        $shift_out_time = 'office shift is not assigned';
                        $shift_hours = '00:00:00';
                    }
                }
                if ($shift_in_time == '' && $shift_out_time == '') {
                    # code...
                    $shift_in_time = 'office shift is not assigned';
                    $shift_out_time = 'office shift is not assigned';
                    $shift_hours = '00:00:00';
                }
                $approved = 'No';


                $data[] = array(
                    $r->user_id,
                    $comp_name,
                    $full_name,
                    $r->attendance_date,
                    $shift_name,
                    $shift_in_time,
                    $shift_out_time,
                    $shift_hours,
                    $approved
                );
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => ($employee) ? $employee->num_rows() : 0,
            "recordsFiltered" => ($employee) ? $employee->num_rows() : 0,
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_daily_punch_summary()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_daily_pun_sum') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_daily_pun_sum');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        //$data['all_branches'] = $this->Department_model->all_branches();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_daily_punch_summary", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_daily_punch_summary_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);
        $department_id = $this->uri->segment(10);

        $data = array();

        $employee = $this->Reports_model->employee_late_in_request_status_report($company_id, $employee_id, $department_id, $location_id, $from_date, $to_date, $status);
        //print_r($employee->result());
        foreach ($employee->result() as $r) {
            # code...
            //get company
            $leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
            if ($leave != '') {
                # code...
                continue;
            }
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            $department_name = $this->Xin_model->read_department_info($r->company_id);
            if (!is_null($department_name)) {
                $dept_name = $department_name;
            } else {
                $dept_name = '--';
            }

            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($in_time);exit();

            $in_time = $this->Reports_model->get_clock_in_time($r->user_id, $r->attendance_date);

            $out_time = $this->Reports_model->get_clock_out_time($r->user_id, $r->attendance_date);

            $in_time_without_date = date("H:i", strtotime($in_time));
            $out_time_without_date = date("H:i", strtotime($out_time));

            $att_date = $r->attendance_date;
            $get_day = strtotime($att_date);
            $day = date('l', $get_day);

            //print_r($day);exit();

            print_r($r->office_shift_id);
            exit();
            $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);
            print_r($office_shift);
            exit();

            if (isset($office_shift[0]->shift_name) != '') {
                $shift_name = $office_shift[0]->shift_name;
            } else {
                $shift_name = '--';
            }

            if ($day == 'Monday') {
                if (isset($office_shift[0]->monday_in_time) != '' && isset($office_shift[0]->monday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->monday_in_time;
                    $shift_out_time = $office_shift[0]->monday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            } else if ($day == 'Tuesday') {
                if (isset($office_shift[0]->tuesday_in_time) != '' && isset($office_shift[0]->tuesday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->tuesday_in_time;
                    $shift_out_time = $office_shift[0]->tuesday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            } else if ($day == 'Wednesday') {
                if (isset($office_shift[0]->wednesday_in_time) != '' && isset($office_shift[0]->wednesday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->wednesday_in_time;
                    $shift_out_time = $office_shift[0]->wednesday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            } else if ($day == 'Thursday') {
                if (isset($office_shift[0]->thursday_in_time) != '' && isset($office_shift[0]->thursday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->thursday_in_time;
                    $shift_out_time = $office_shift[0]->thursday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            } else if ($day == 'Friday') {
                if (isset($office_shift[0]->friday_in_time) != '' && isset($office_shift[0]->friday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->friday_in_time;
                    $shift_out_time = $office_shift[0]->friday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            } else if ($day == 'Saturday') {
                if (isset($office_shift[0]->saturday_in_time) != '' && isset($office_shift[0]->saturday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->saturday_in_time;
                    $shift_out_time = $office_shift[0]->saturday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            } else if ($day == 'Sunday') {
                if (isset($office_shift[0]->sunday_in_time) != '' && isset($office_shift[0]->sunday_out_time) != '') {
                    $shift_in_time = $office_shift[0]->sunday_in_time;
                    $shift_out_time = $office_shift[0]->sunday_out_time;
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                    $lastout_firstin_diff = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                } else {
                    $late_in_grace_time = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                    $late_in_grace_time = '00:00:00';
                    $lastout_firstin_diff = '00:00:00';
                }
            }

            if ($shift_in_time == '' && $shift_out_time == '') {
                # code...
                $shift_in_time = 'office shift is not assigned';
                $shift_out_time = 'office shift is not assigned';
            }
            $early_out_grace_time = '00:00:00';
            $approved = 'No';


            $data[] = array(
                $r->user_id,
                $comp_name,
                $full_name,
                $r->attendance_date,
                $shift_name,
                $shift_in_time,
                $shift_out_time,
                $in_time,
                $out_time,
                $late_in_grace_time,
                $early_out_grace_time,
                $lastout_firstin_diff
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_daily_attendance_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //$data['all_branches'] = $this->Department_model->all_branches();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_daily_attendance_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_daily_attendance_report_result()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);

        $data = array();
        $employee = $this->Reports_model->employee_daily_attendance_report_result($company_id, $employee_id, $location_id, $from_date, $to_date, $status);
        //print_r($employee->result());exit();
        if ($employee->num_rows() > 0) {
            foreach ($employee->result() as $r) {
                # code...
                //get company
                $company = $this->Xin_model->read_company_info($r->company_id);
                if (!is_null($company)) {
                    $comp_name = $company[0]->name;
                } else {
                    $comp_name = '--';
                }

                $full_name = $r->first_name . ' ' . $r->last_name;

                //get all attendance date between from_date and to_date
                $attendance_date = $this->Reports_model->get_all_attendance_date($r->user_id, $from_date, $to_date);
                //print_r($attendance_date);exit();

                foreach ($attendance_date as $att) {
                    # code...
                    foreach ($att as $date) {

                        foreach ($date as $key) {
                            # code...
                            $att_date = $key->attendance_date;
                            //print_r($att_date);exit();
                            $att_status = $key->attendance_status;

                            $get_day = strtotime($att_date);
                            $day = date('l', $get_day);
                            //print_r($r->office_shift_id);exit();
                            $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

                            //get total work hours and details
                            //print_r($r->user_id);
                            //print_r($att_date);exit();
                            $working_hours = $this->Reports_model->get_total_work_hours($r->user_id, $att_date);
                            //print_r($working_hours);exit();
                            //print_r($office_shift[0]->tuesday_in_time);exit();
                            $odd_punch = $this->Reports_model->calculate_employee_odd_punch($r->user_id, $att_date);
                            # code...
                            if ($day == 'Monday') {
                                if (isset($office_shift[0]->monday_in_time) != '') {
                                    $in_time = $office_shift[0]->monday_in_time;
                                    $out_time = $office_shift[0]->monday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            } else if ($day == 'Tuesday') {
                                if (isset($office_shift[0]->tuesday_in_time) != '') {
                                    $in_time = $office_shift[0]->tuesday_in_time;
                                    $out_time = $office_shift[0]->tuesday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            } else if ($day == 'Wednesday') {
                                if (isset($office_shift[0]->wednesday_in_time) != '') {
                                    $in_time = $office_shift[0]->wednesday_in_time;
                                    $out_time = $office_shift[0]->wednesday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            } else if ($day == 'Thursday') {
                                if (isset($office_shift[0]->thursday_in_time) != '') {
                                    $in_time = $office_shift[0]->thursday_in_time;
                                    $out_time = $office_shift[0]->thursday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            } else if ($day == 'Friday') {
                                if (isset($office_shift[0]->friday_in_time) != '') {
                                    $in_time = $office_shift[0]->friday_in_time;
                                    $out_time = $office_shift[0]->friday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            } else if ($day == 'Saturday') {
                                if (isset($office_shift[0]->saturday_in_time) != '') {

                                    $in_time = $office_shift[0]->saturday_in_time;
                                    $out_time = $office_shift[0]->saturday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            } else if ($day == 'Sunday') {
                                if (isset($office_shift[0]->sunday_in_time) != '') {

                                    $in_time = $office_shift[0]->sunday_in_time;
                                    $out_time = $office_shift[0]->sunday_out_time;
                                    $late_allowed_till = $office_shift[0]->late_allowed_till;
                                    $late_in_grace_time = round(abs(strtotime($late_allowed_till) - strtotime($in_time)) / 3600, 2);
                                    $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600, 2);
                                    if (!empty($working_hours)) {
                                        # code...
                                        $work_hours = $working_hours[0]->work;
                                        $late_in = $working_hours[0]->late;
                                        $early_out = $working_hours[0]->early_leaving;
                                    } else {
                                        $work_hours = '00:00:00';
                                        $late_in = '00:00:00';
                                        $early_out = '00:00:00';
                                    }

                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                } else {
                                    $in_time = '00:00:00';
                                    $out_time = '00:00:00';
                                    $late_allowed_till = '00:00:00';
                                    $late_in_grace_time = '00:00:00';
                                    $shift_hours = '00:00:00';
                                    $work_hours = '00:00:00';
                                    $late_in = '00:00:00';
                                    $early_out = '00:00:00';
                                    if (isset($office_shift[0]->shift_name)) {
                                        # code...
                                        $shift_name = $office_shift[0]->shift_name;
                                    } else {
                                        $shift_name = '--';
                                    }
                                }
                            }

                            $data[] = array(
                                $r->user_id,
                                $comp_name,
                                $full_name,
                                $in_time,
                                $out_time,
                                $att_date,
                                $att_status,
                                $shift_hours,
                                $late_in_grace_time,
                                $work_hours,
                                $late_in,
                                $early_out,
                                $odd_punch,
                                $shift_name
                            );
                        }
                    }
                }
            }
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_late_in_request_status()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_late_in') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_late_in');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        //$data['all_branches'] = $this->Department_model->all_branches();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_late_in_request_status", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_late_in_request_status_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);
        $department_id = $this->uri->segment(10);

        $data = array();

        $employee = $this->Reports_model->employee_late_in_request_status_report($company_id, $employee_id, $department_id, $location_id, $from_date, $to_date, $status);
        //print_r($employee->result());exit();
        foreach ($employee->result() as $r) {
            # code...
            //get company
            $leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
            if ($leave != '') {
                # code...
                continue;
            }
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            $full_name = $r->first_name . ' ' . $r->last_name;

            $in_time = $this->Reports_model->get_clock_in_time($r->user_id, $r->attendance_date);

            $in_time_without_date = date("H:i", strtotime($in_time));
            //print_r($in_time);exit();

            $att_date = $r->attendance_date;
            $get_day = strtotime($att_date);
            $day = date('l', $get_day);

            //print_r($r->office_shift_id);exit();
            $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

            if ($day == 'Monday') {
                if (isset($office_shift[0]->monday_in_time) != '') {

                    $shift_in_time = $office_shift[0]->monday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            } else if ($day == 'Tuesday') {
                if (isset($office_shift[0]->tuesday_in_time) != '') {
                    $shift_in_time = $office_shift[0]->tuesday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            } else if ($day == 'Wednesday') {
                if (isset($office_shift[0]->wednesday_in_time) != '') {
                    $shift_in_time = $office_shift[0]->wednesday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            } else if ($day == 'Thursday') {
                if (isset($office_shift[0]->thursday_in_time) != '') {
                    $shift_in_time = $office_shift[0]->thursday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            } else if ($day == 'Friday') {
                if (isset($office_shift[0]->friday_in_time) != '') {
                    $shift_in_time = $office_shift[0]->friday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            } else if ($day == 'Saturday') {
                if (isset($office_shift[0]->saturday_in_time) != '') {
                    $shift_in_time = $office_shift[0]->saturday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            } else if ($day == 'Sunday') {
                if (isset($office_shift[0]->sunday_in_time) != '') {
                    $shift_in_time = $office_shift[0]->sunday_in_time;
                    if ($shift_in_time >= $in_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_in_time == '') {
                        # code...
                        $late_time_in_min = 'office shift is not allotted';
                    } else {
                        $late_time_in_min = round(abs(strtotime($in_time_without_date) - strtotime($shift_in_time)) / 3600, 2);
                        $late_time_in_min = round($late_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                } else {
                    $shift_in_time = '00:00:00';
                    $late_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                }
            }

            $applied = 'No';


            $data[] = array(
                $r->user_id,
                $comp_name,
                $full_name,
                $r->attendance_date,
                $in_time,
                $shift_in_time,
                $late_time_in_min,
                $applied
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function employee_early_out_request_status()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_early_out') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_early_out');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        //$data['all_branches'] = $this->Department_model->all_branches();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_early_out_request_status", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_early_out_request_status_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);
        $department_id = $this->uri->segment(10);

        $data = array();

        $employee = $this->Reports_model->employee_late_in_request_status_report($company_id, $employee_id, $department_id, $location_id, $from_date, $to_date, $status);

        foreach ($employee->result() as $r) {
            # code...
            //get company
            $leave = $this->Reports_model->check_employee_leave($r->user_id, $r->attendance_date);
            if ($leave != '') {
                # code...
                continue;
            }
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            $full_name = $r->first_name . ' ' . $r->last_name;

            $in_time = $this->Reports_model->get_clock_in_time($r->user_id, $r->attendance_date);

            $out_time = $this->Reports_model->get_clock_out_time($r->user_id, $r->attendance_date);

            $in_time_without_date = date("H:i", strtotime($in_time));
            $out_time_without_date = date("H:i", strtotime($out_time));
            //print_r($in_time);exit();

            $att_date = $r->attendance_date;
            $get_day = strtotime($att_date);
            $day = date('l', $get_day);

            //print_r($r->office_shift_id);exit();
            $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

            if ($day == 'Monday') {
                if (isset($office_shift[0]->monday_out_time) != '') {

                    $shift_out_time = $office_shift[0]->monday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            } else if ($day == 'Tuesday') {
                if (isset($office_shift[0]->tuesday_out_time) != '') {
                    $shift_out_time = $office_shift[0]->tuesday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            } else if ($day == 'Wednesday') {
                if (isset($office_shift[0]->wednesday_out_time) != '') {
                    $shift_out_time = $office_shift[0]->wednesday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            } else if ($day == 'Thursday') {
                if (isset($office_shift[0]->thursday_out_time) != '') {
                    $shift_out_time = $office_shift[0]->thursday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            } else if ($day == 'Friday') {
                if (isset($office_shift[0]->friday_out_time) != '') {
                    $shift_out_time = $office_shift[0]->friday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            } else if ($day == 'Saturday') {
                if (isset($office_shift[0]->saturday_out_time) != '') {
                    $shift_out_time = $office_shift[0]->saturday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            } else if ($day == 'Sunday') {
                if (isset($office_shift[0]->sunday_out_time) != '') {
                    $shift_out_time = $office_shift[0]->sunday_out_time;
                    if ($shift_out_time <= $out_time_without_date) {
                        # code...
                        continue;
                    } else if ($shift_out_time == '') {
                        # code...
                        $early_time_in_min = 'office shift is not allotted';
                    } else {
                        $early_time_in_min = round(abs(strtotime($shift_out_time) - strtotime($out_time_without_date)) / 3600, 2);
                        $early_time_in_min = round($early_time_in_min * 60);
                    }
                    $in_time = $in_time_without_date;
                    $out_time = $out_time_without_date;
                } else {
                    $shift_out_time = '00:00:00';
                    $early_time_in_min = '00:00:00';
                    $in_time = '00:00:00';
                    $out_time = '00:00:00';
                }
            }

            $approved = 'No';


            $data[] = array(
                $r->user_id,
                $comp_name,
                $full_name,
                $r->attendance_date,
                $in_time,
                $out_time,
                $shift_out_time,
                $early_time_in_min,
                $approved
            );
        }
        $output = array(
            "draw" => $draw,
            "recordsTotal" => $employee->num_rows(),
            "recordsFiltered" => $employee->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
    }

    public function starting_checkin_checkout_report()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_employee_checkin_checkout_report') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'Advance Loan Outstanding Report';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_employee_checkin_checkout_report');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_employees'] = $this->Xin_model->all_employees();
        //$data['all_departments'] = $this->Department_model->all_departments();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data);
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/employee_starting_checkin_checkout_report", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employee_starting_checkin_checkout_report()
    {
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $location_id = $this->uri->segment(6);
        $from_date = $this->uri->segment(7);
        $to_date = $this->uri->segment(8);
        $status = $this->uri->segment(9);

        //print_r($status);exit();

        $employee = $this->Reports_model->employee_starting_checkin_checkout_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status);

        //print_r($employee->result());exit();

        $data = array();

        $table = "";
        $table .= "<table id='indian_recharge_history' class='table table-bordered table-striped display'>
	                  <thead>
	                  <tr>
	                    <th>Employee ID</th>
	                    <th>Company Name</th>
	                    <th>Employee Name</th>
	                    <th>Attendance Date</th>
	                    <th>Checkin Time</th>
	                    <th>Checkout Time</th>
	                  </tr>
	                  </thead>
	                  <tbody>";

        foreach ($employee->result() as $r) {
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }

            //get first clock in date and time and last clock out date and time from from_date to to_date
            $clock_info = $this->Reports_model->read_clockin_datetime($r->user_id, $from_date, $to_date);
            //get employee id
            //print_r($clock_info);

            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($full_name);
            # code...
            foreach ($clock_info as $row) {

                //print_r($row);exit();
                # code...
                $table .= "<tr>
	                    <td>" . $row['employee_id'] . "</td>
	                    <td>" . $comp_name . "</td>
	                    <td>" . $full_name . "</td>
	                    <td>" . $row['attendance_date'] . "</td>
	                    <td>" . $row['clock_in'] . "</td>
	                    <td>" . $row['clock_out'] . "</td>
	                </tr>";
            }
        }
        $table .= "</tbody>
				    <tfoot>
	                  <tr>
	                    <th>Employee ID</th>
	                    <th>Company Name</th>
	                    <th>Employee Name</th>
	                    <th>Attendance Date</th>
	                    <th>Checkin Time</th>
	                    <th>Checkout Time</th>
	                  </tr>
	                </tfoot>
	            </table>";
        //print_r($table);exit();
        echo json_encode($table);
        exit();
    }

    public function salary_progression_history()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = $this->lang->line('xin_hr_report_employees_salary_progress_his') . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = $this->lang->line('xin_hr_report_employees_salary_progress_his');
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_leaves'] = $this->Department_model->all_leaves();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/salary_progression_history", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function salary_progression_history_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $department_id = $this->uri->segment(6);
        $location_id = $this->uri->segment(7);
        $year = $this->uri->segment(8);

        $data = array();
        $allowance_amount_arra = array();

        $employee = $this->Reports_model->salary_progression_history_report($company_id, $employee_id, $department_id, $location_id, $year);
        //print_r($employee->result());exit();
        $allowance_title = $this->Reports_model->get_allowance_titles($year);
        foreach ($allowance_title as $allowance_tit) {

            $basic_allowance_amount = $this->Reports_model->get_allowance_amount($allowance_tit->id);
            if (!empty($basic_allowance_amount)) {
                $allowance_amount = $basic_allowance_amount[0]->allowance_amount;
            } else {
                $allowance_amount = 0;
            }
            $allowance_amount_name_arra[$allowance_tit->name] = $allowance_amount;
            $allowance_amount_id_arra[$allowance_tit->id] = $allowance_amount;
        }

        //print_r($allowance_amount_arra);exit();

        $table = "";
        $table .= "<span class='card-header-title mr-2'><strong>Employee Salary Progression Report " . " " . $year . "</strong></span> </div>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive'>
					<table class='datatables-demo table table-striped table-bordered' id='salary_progress_his'>
	                      <thead>
	                        <tr>
	                            <th>Employee ID</th>
				                <th>Company</th>
				                <th>Employee Name</th>
				                <th>Department Name</th>
				                <th>Designation Name</th>
				                <th>Date of Joining</th>
				                <th>Progression Date</th>
				                <th>Basic Salary</th>";
        if (!empty($allowance_amount_name_arra)) {
            # code...
            foreach ($allowance_amount_name_arra as $key => $value) {

                $table .= "<th>" . $key . "</th>";
            }
        }
        $table .= "</tr>
            	</thead>
          	<tbody>";
        //print_r($allowance_amount_arra);exit();
        foreach ($employee->result() as $r) {

            //get basic salary
            $basic_salary = $r->basic_salary;
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }
            //get department
            $department_name = $this->Xin_model->read_department_info($r->department_id);
            if (!is_null($department_name)) {
                $dept_name = $department_name[0]->department_name;
            } else {
                $dept_name = '--';
            }

            // get designation
            $designation = $this->Designation_model->read_designation_information($r->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($in_time);exit();
            $progressive_basic_salary = $this->Reports_model->get_employee_basic_salary($r->user_id);
            //print_r($progressive_basic_salary);exit();

            $table .= "<tr>
	                        <td>" . $r->employee_id . ".</td>
	                        <td>" . $comp_name . "</td>
	                        <td>" . $full_name . "</td>
	                        <td>" . $dept_name . "</td>
	                        <td>" . $designation_name . "</td>
	                        <td>" . $r->date_of_joining . "</td>
	                        <td></td>
	                        <td></td>";
            if (!empty($allowance_amount_name_arra)) {
                foreach ($allowance_amount_name_arra as $key => $basic_all_amnt) {
                    # code...
                    $table .= "<td></td>";
                }
            }

            $table .= "</tr>";

            foreach ($progressive_basic_salary as $row) {

                if ($row->history_type == 1) {
                    # code...
                    $basic_salary = $basic_salary + $row->inc_amt;
                }
                // else if ($row->history_type == 2) {
                // 	# code...
                // 	$inc_allowance_amount = $row->inc_amt;
                // }
                $table .= "<tr>  
		            			<td></td>
		                        <td></td>
		                        <td></td>
		                        <td></td>
		            			<td></td>
		        				<td></td>
		                    	<td>" . $row->progression_date . "</td>
		                    	<td>" . $basic_salary . "</td>";

                foreach ($allowance_amount_id_arra as $all_amnt_id => $basic_all_amnt) {
                    # code...
                    //$progressed_allowance_amount = $basic_all_amnt + $inc_allowance_amount;
                    $progressed_allowance_amount = $this->Reports_model->get_allowance_progress_amount($all_amnt_id, $basic_all_amnt, $r->user_id, $r->progression_date);
                    $table .= "<td>" . $progressed_allowance_amount . "</td>";
                }

                $table .= "</tr>";
            }
        }
        echo json_encode($table);
        exit();
    }

    public function salary_progression_latest()
    {
        $session = $this->session->userdata('username');
        if (empty($session)) {
            redirect('admin/');
        }
        $data['title'] = 'Employee Salary Latest Progression' . ' | ' . $this->Xin_model->site_title();
        $data['path_url'] = 'reports_employees';
        $data['breadcrumbs'] = 'Employee Salary Latest Progression';
        $data['all_companies'] = $this->Xin_model->get_companies();
        $data['all_departments'] = $this->Department_model->all_departments();
        $data['all_leaves'] = $this->Department_model->all_leaves();
        $data['all_employees'] = $this->Xin_model->all_employees();
        $data['all_locations'] = $this->Xin_model->all_locations();
        //print_r($data['all_locations']);exit();
        if ($data) {
            $data['subview'] = $this->load->view("admin/reports/salary_progression_latest", $data, TRUE);
            $this->load->view('admin/layout/layout_main', $data); //page load
        } else {
            redirect('admin/dashboard');
        }
    }

    public function salary_progression_latest_report()
    {
        //print_r('hi');exit();
        $data['title'] = $this->Xin_model->site_title();
        $session = $this->session->userdata('username');
        if (!empty($session)) {
            $this->load->view("admin/reports/employees", $data);
        } else {
            redirect('admin/');
        }

        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $company_id = $this->uri->segment(4);
        $employee_id = $this->uri->segment(5);
        $department_id = $this->uri->segment(6);
        $location_id = $this->uri->segment(7);
        $year = $this->uri->segment(8);

        $data = array();
        $employee = $this->Reports_model->salary_latest_progression_history_report($company_id, $employee_id, $department_id, $location_id, $year);

        $allowance_title = $this->Reports_model->get_allowance_titles($year);

        foreach ($allowance_title as $allowance_tit) {

            //print_r($allowance_tit);
            $basic_allowance_amount = $this->Reports_model->get_allowance_amount($allowance_tit->allowance_title);
            if (!empty($basic_allowance_amount)) {
                $allowance_amount = $basic_allowance_amount[0]->allowance_amount;
            } else {
                $allowance_amount = 0;
            }

            $allowance_amount_name_arra[$allowance_tit->name] = $allowance_amount;
            $allowance_amount_id_arra[$allowance_tit->allowance_title] = $allowance_tit->allowance_id;
        }

        //print_r($allowance_amount_name_arra);exit();

        $table = "";
        $table .= "<span class='card-header-title mr-2'><strong>Employee Latest Salary Progression Report " . " " . $year . "</strong></span> </div>
      			<div class='card-body'>
        		<div class='box-datatable table-responsive'>
					<table class='datatables-demo table table-striped table-bordered' id='salary_latest_progress_his'>
	                      <thead>
	                        <tr>
	                            <th>Employee ID</th>
				                <th>Company</th>
				                <th>Employee Name</th>
				                <th>Department Name</th>
				                <th>Designation Name</th>
				                <th>Date of Joining</th>
				                <th>Progression Date</th>
				                <th>Basic Salary</th>";
        if (!empty($allowance_amount_name_arra)) {
            # code...
            foreach ($allowance_amount_name_arra as $key => $value) {

                $table .= "<th>" . $key . "</th>";
            }
        }

        $table .= "</tr>
            	</thead>
          	<tbody>";
        //print_r($employee->result());exit();
        foreach ($employee->result() as $r) {

            //get basic salary
            $basic_salary = $r->basic_salary;
            //get company
            $company = $this->Xin_model->read_company_info($r->company_id);
            if (!is_null($company)) {
                $comp_name = $company[0]->name;
            } else {
                $comp_name = '--';
            }
            //get department
            $department_name = $this->Xin_model->read_department_info($r->department_id);
            if (!is_null($department_name)) {
                $dept_name = $department_name[0]->department_name;
            } else {
                $dept_name = '--';
            }

            // get designation
            $designation = $this->Designation_model->read_designation_information($r->designation_id);
            if (!is_null($designation)) {
                $designation_name = $designation[0]->designation_name;
            } else {
                $designation_name = '--';
            }

            $full_name = $r->first_name . ' ' . $r->last_name;
            //print_r($in_time);exit();
            $progressive_basic_salary = $this->Reports_model->get_employee_basic_salary_latest($r->user_id, $year);
            //print_r($progressive_basic_salary);

            foreach ($progressive_basic_salary as $row) {

                if ($row->history_type == 1) {
                    # code...
                    $basic_salary = $row->amount;
                }

                $table .= "<tr>
		                        <td>" . $r->employee_id . ".</td>
		                        <td>" . $comp_name . "</td>
		                        <td>" . $full_name . "</td>
		                        <td>" . $dept_name . "</td>
		                        <td>" . $designation_name . "</td>
		                        <td>" . $r->date_of_joining . "</td>
		                        <td>" . $row->progression_date . "</td>
			                    <td>" . $basic_salary . "</td>";

                foreach ($allowance_amount_id_arra as $all_tit_id => $allowance_id) {
                    # code...
                    //$progressed_allowance_amount = $basic_all_amnt + $inc_allowance_amount;
                    $progressed_allowance_amount = $this->Reports_model->get_allowance_progress_amount($allowance_id, $r->user_id, $r->date);
                    $table .= "<td>" . $progressed_allowance_amount . "</td>";
                }

                $table .= "</tr>";
            }
        }
        echo json_encode($table);
        exit();
    }
    
    ///////////////////////////////report for filters/////////////////////////////
    
    // get company > departments
    public function get_departments_new() {

      $data['title'] = $this->Xin_model->site_title();
      $company_id =$_GET['company_id'];
      $location_id =$_GET['location_id'];
      $check =$_GET['check'];

      $data = array(
         'company_id' => $company_id,
         'location_id' => $location_id,
         'check' => $check
      );
      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/filters/report_get_departments_new", $data);
      } else {
         redirect('admin/');
      }
      // Datatables Variables
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
    }
    
    public function get_location_new() {

      $data['title'] = $this->Xin_model->site_title();
      $company_id =$_GET['company_id'];
      $check =$_GET['check'];
	  
      $data = array(
         'company_id' => $company_id,
         'check' => $check
      );

      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/filters/get_location_new", $data);
      } else {
         redirect('admin/');
      }

      // Datatables Variables
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
    }
    
    public function get_employee_loca_new() {

      $data['title'] = $this->Xin_model->site_title();
      $company_id =$_GET['company_id'];
	  $department_id =$_GET['department_id'];
	  $location_id =$_GET['location_id'];
	  
	  
      $data = array(
         'company_id' => $company_id,
         'department_id' => $department_id,
         'location_id' => $location_id
      );

      $session = $this->session->userdata('username');
      if (!empty($session)) {
         $this->load->view("admin/reports/filters/get_employee_loca_new", $data);
      } else {
         redirect('admin/');
      }

      // Datatables Variables
      $draw = intval($this->input->get("draw"));
      $start = intval($this->input->get("start"));
      $length = intval($this->input->get("length"));
    }
    
   ///////////////////////////////report for filters end/////////////////////////////
}
