<?php

/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reservedattendance_list
 */
defined('BASEPATH') or exit('No direct script access allowed');

class Timesheet extends MY_Controller
{

	public function __construct()
	{
		parent::__construct();
		//load the model
		$this->load->model("Timesheet_model");
		$this->load->model("Employee_exit_model");
		$this->load->model("Employees_model");
		$this->load->model("Xin_model");
		$this->load->library('email');
		$this->load->model("Department_model");
		$this->load->model("Designation_model");
		$this->load->model("Roles_model");
		$this->load->model("Project_model");
		$this->load->model("Location_model");
		$this->load->model("Misc_model");
		$this->load->model("Office_shift_custom_model");
		$this->load->model('Travel_model');
		$this->load->model('Training_model');
		$this->load->model('Goal_tracking_model');
		$this->load->model('Events_model');
		$this->load->model('Meetings_model');
		$this->load->model('Job_post_model');
		$this->load->model("Recruitment_model");
		$this->load->library('Pdf');
	}

	/*Function to set JSON output*/
	public function output($Return = array())
	{
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}

	// daily attendance > timesheet
	public function attendance()
	{
		//var_dump($this->input->get("yesterday"));die();

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('dashboard_attendance') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('dashboard_attendance');
		$data['path_url'] = 'attendance';
		$data['all_office_shifts'] = $this->Location_model->all_office_locations();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('218', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/attendance_list", $data, TRUE);
				$data['today'] = $this->input->get("today");
				$data['yesterday'] = $this->input->get("yesterday");
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/dashboard/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function attendance_dashboard()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('hr_timesheet_dashboard_title') . ' | ' . $this->Xin_model->site_title();

		$data['breadcrumbs'] = $this->lang->line('hr_timesheet_dashboard_title');
		$data['path_url'] = 'attendance_dashboard';
		//$data['get_invoice_payments'] = $this->Finance_model->get_invoice_payments();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('218', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/attendance_dashboard", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// date wise date_wise_attendance > timesheet
	public function date_wise_attendance()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_date_wise_attendance') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['breadcrumbs'] = $this->lang->line('left_date_wise_attendance');
		$data['path_url'] = 'date_wise_attendance';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('221', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/date_wise", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// update_attendance > timesheet

	public function pdf_create()
	{

		$this->load->library('Pdf');
		$system = $this->Xin_model->read_setting_info(1);
		// create new PDF document
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$ecash_id = $this->uri->segment(5);;
		//	echo $ecash_id;exit();
		$encashmentleave = $this->Timesheet_model->get_annual_encashment_id($ecash_id);
		if (is_null($encashmentleave)) {
			redirect('admin/Annual_leave/annual_leave_encashment_list');
		}
		$user = $this->Xin_model->read_user_info($encashmentleave[0]->employee_id);
		if (!is_null($user)) {
			$username = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
			$salary = $user[0]->basic_salary;
			$e_salary = round($salary, 3);
		} else {
			$user = '';
			$salary = '';
		}
		$_cmp_name = $this->Company_model->read_company_information($encashmentleave[0]->company_id);
		if (!is_null($_cmp_name)) {
			$_cmp_name = $_cmp_name[0]->name;
		} else {
			$_cmp_name = '';
		}
		$edays = $encashmentleave[0]->encashment_day;
		if ($edays != '') {
			$edays = $edays;
		} else {
			$edays = '';
		}
		$split_val = explode(".", $encashmentleave[0]->amount);
		if (count($split_val) > 1) {
			$toatal_in_words = $this->Xin_model->wholeconvertNumberToWord($split_val[0], $split_val[1], 'Bahraini Dinars', '& Fils', 'Only');
		} else {
			$toatal_in_words = $this->Xin_model->wholeconvertNumberToWord($encashmentleave[0]->amount, '', 'Bahraini Dinars', '', 'Only');
		}

		// company info
		$company = $this->Xin_model->read_company_info($encashmentleave[0]->company_id);
		if (!is_null($company)) {
			$company_name = $company[0]->name;
			$address_1 = $company[0]->address_1;
			$address_2 = $company[0]->address_2;
			$city = $company[0]->city;
			$state = $company[0]->state;
			$company_logo = $company[0]->logo;
			$zipcode = $company[0]->zipcode;
			$country = $this->Xin_model->read_country_info($company[0]->country);
			if (!is_null($country)) {
				$country_name = $country[0]->country_name;
			} else {
				$country_name = '--';
			}
			$c_info_email = $company[0]->email;
			$c_info_phone = $company[0]->contact_number;

		} else {
			$company_name = '--';
			$address_1 = '--';
			$address_2 = '--';
			$city = '--';
			$state = '--';
			$zipcode = '--';
			$country_name = '--';
			$c_info_email = '--';
			$c_info_phone = '--';
		}
		//$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
		// set default header data
		//$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode.', '.$country_name;
		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;
		//$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email ";

		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";

		$header_string = $email_phone_address;
		// set document information
		$pdf->SetCreator('HRSALE');
		$pdf->SetAuthor('HRSALE');
		//$pdf->SetTitle('Workable-Zone - Payslip');
		//$pdf->SetSubject('TCPDF Tutorial');
		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
		//$pdf->SetHeaderData($logo, 15, $company_name, $header_string);

		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));

		// set header and footer fonts
		$pdf->setHeaderFont(array('helvetica', '', 11.5));
		$pdf->setFooterFont(array('helvetica', '', 9));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont('courier');

		// set margins
		$pdf->SetMargins(15, 27, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, 25);

		// set image scale factor
		$pdf->setImageScale(1.25);
		$pdf->SetAuthor('HRSALE');
		$pdf->SetTitle($company_name . ' - ' . $this->lang->line('xin_print_payslip'));
		$pdf->SetSubject($this->lang->line('xin_payslip'));
		$pdf->SetKeywords($this->lang->line('xin_payslip'));
		// set font
		$pdf->SetFont('helvetica', 'B', 10);

		// set header and footer fonts
		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// ---------------------------------------------------------

		// set default font subsetting mode
		$pdf->setFontSubsetting(true);

		// Set font
		// dejavusans is a UTF-8 Unicode font, if you only need to
		// print standard ASCII chars, you can use core fonts like
		// helvetica or times to reduce file size.
		$pdf->SetFont('dejavusans', '', 10, '', true);

		// Add a page
		// This method has several options, check the source code documentation for more information.
		$pdf->AddPage();
		// -----------------------------------------------------------------------------
		//$fname = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;
		//$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);
		$date_range = $encashmentleave[0]->date_range;
		$encashmentamount = $encashmentleave[0]->amount;
		$e_amount = round($encashmentamount, 3);
		$dates = explode("/", $date_range);
		$date1 = $dates[0];
		$date2 = $dates[1];
		$month = date_parse_from_format("Y-m-d", $date1);
		$smonth = $month["month"];
		$dateObj = DateTime::createFromFormat('!m', $smonth);
		$monthName = $dateObj->format('F');
		$todaydate = date('d.m.Y');
		$tbl = '
		<table cellpadding="1" cellspacing="1" border="0">
			<tr>
				<td align="center"><h1>Annual Leave Settlement for <span style=" text-transform: capitalize;">' . $username . '</span> </h1></td>
			</tr>
			<tr>
				<td align="center"><strong>Total Period From ' . $date1 . ' to ' . $date2 . '</strong></td>
			</tr>
			
		</table>
		';
		$pdf->writeHTML($tbl, true, false, false, false, '');
		// -----------------------------------------------------------------------------
		// set cell padding
		$pdf->setCellPaddings(1, 1, 1, 1);

		// set cell margins
		$pdf->setCellMargins(0, 0, 0, 0);

		// set color for background
		$pdf->SetFillColor(255, 255, 127);
		// set some text for example
		//$txt = 'Employee Details';
		// Multicell
		//$pdf->MultiCell(180, 6, $txt, 0, 'L', 11, 0, '', '', true);
		//$pdf->Ln(7);


		// ---------------------------------------------------------
		$tbl1_lv = '
			<table class="table table-striped table-hover"><br><br><br><br>
				<tr>
				<td  align="left" style="width:70%;" >Leave salary period</td>
				<td  style="width:30%;text-align:end;">: ' . $date1 . ' to ' . $date2 . '</td>
				</tr><br>
				<tr>
				<td  align="left" style="width:70%">Leave salary days</td>
				<td  style="width:30%;text-align:end;">: ' . $edays . '</td>
				</tr><br>
				<tr>
				<td align="left" style="width:70%">Basic salary</td>
				<td  style="width:30%;text-align:end;">: ' . $e_salary . ' BHD</td>
				</tr><br>
				<tr>
                  <td class="top bottom left right" align="left" style="width:70%">Total leave salary</td>
                  <td  style="width:30%;text-align:end;">: ' . $e_amount . ' BHD</td>
                </tr><br>
                <tr>
                <td>(Total bahraini dinars : ' . $toatal_in_words . ')</td>
                </tr><br><br>';
		$tbl1_lv .= '</table>';
		$pdf->writeHTML($tbl1_lv, true, false, true, false, '');

		$tbl = '
    		<table cellpadding="5" cellspacing="0" border="0">
    			<tr>
    				<td>Prepared By</td>
    				<td>Verified By</td>
    				<td>Approved By</td>
    				<td>Received By</td>
    			</tr>
    		</table>';
		$pdf->writeHTML($tbl, true, false, false, false, '');
		$tbl_l = '
		<table cellpadding="5" cellspacing="0" border="0"><br><br><br><br><br><br>
			<tr>
				<td align="center"><h3><u>To  Whomsoever It  May Concern</u></h3></td>
			</tr><br><br>
				<tr>
			<td>I <span style=" text-transform: capitalize;">' . $username . '</span> hereby confirm that I have received my Annual Leave Settlement to me from the
            company from ' . $date1 . ' to ' . $date2 . '</td>
				
			</tr>
			<tr>
				<td>I further confirm that I have no claim from the company.</td>
			</tr><br><br><br><br><br><br><br><br>
			
		</table>';
		$pdf->writeHTML($tbl_l, true, false, false, false, '');
		// ---------------------------------------------------------
		$tbl1_lvs = '
			<table class="table table-striped table-hover"><br><br><br><br>
				<tr>
				<td  align="left" style="width:80%;" >Date: ' . $todaydate . '</td>
				<td  style="width:20%;text-align:end;"><span style=" text-transform: capitalize;">' . $username . '</span></td>
				</tr><br>
				<tr>
				<td  align="left" style="width:80%">Bahrain</td>
				<td  style="width:20%;text-align:end;">Signature</td>
				</tr><br>';
		$tbl1_lvs .= '</table>';
		$pdf->writeHTML($tbl1_lvs, true, false, true, false, '');
		// Close and output PDF document
		// This method has several options, check the source code documentation for more information.
		//$fname = strtolower($fname);
		//Close and output PDF document
		ob_start();
		$pdf->Output('Encashment' . $username . '_' . $date_range . '.pdf', 'I');
		ob_end_flush();
	}

	public function leave_pdf_create()

	{


		//$this->load->library('Pdf');

		$system = $this->Xin_model->read_setting_info(1);

		// create new PDF document

		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		$leave_id = $this->uri->segment(5);;

		$leave = $this->Timesheet_model->read_annual_leave_information($leave_id);

		if (is_null($leave)) {

			redirect('admin/Annual_leave/annual_leave_list');
		}

		$user = $this->Xin_model->read_user_info($leave[0]->employee_id);

		if (!is_null($user)) {

			$username = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;

			$salary = $user[0]->basic_salary;
		} else {

			$username = '';

			$salary = '';
		}

		$_cmp_name = $this->Company_model->read_company_information($leave[0]->company_id);

		if (!is_null($_cmp_name)) {

			$_cmp_name = $_cmp_name[0]->name;
		} else {

			$_cmp_name = '';
		}

		$_des_name = $this->Designation_model->read_designation_information($user[0]->designation_id);

		if (!is_null($_des_name)) {

			$_designation_name = $_des_name[0]->designation_name;
		} else {

			$_designation_name = '';
		}

		$_leave_type = $this->Timesheet_model->read_leave_type_information($leave[0]->leave_type_id);

		if (!is_null($_leave_type)) {

			$_leave_type = $_leave_type[0]->type_name;
		} else {

			$_designation_name = '';
		}

		$department = $this->Department_model->read_department_information($user[0]->department_id);

		if (!is_null($department)) {

			$_department_name = $department[0]->department_name;
		} else {

			$_department_name = '';
		}

		// company info

		$company = $this->Xin_model->read_company_info($leave[0]->company_id);


		if (!is_null($company)) {

			$company_name = $company[0]->name;

			$address_1 = $company[0]->address_1;

			$address_2 = $company[0]->address_2;

			$city = $company[0]->city;

			$state = $company[0]->state;

			$company_logo = $company[0]->logo;

			$zipcode = $company[0]->zipcode;

			$country = $this->Xin_model->read_country_info($company[0]->country);

			if (!is_null($country)) {

				$country_name = $country[0]->country_name;
			} else {

				$country_name = '--';
			}

			$c_info_email = $company[0]->email;

			$c_info_phone = $company[0]->contact_number;
		} else {

			$company_name = '--';

			$address_1 = '--';

			$address_2 = '--';

			$city = '--';

			$state = '--';

			$zipcode = '--';

			$country_name = '--';

			$c_info_email = '--';

			$c_info_phone = '--';
		}

		//$pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

		// set default header data

		//$c_info_address = $address_1.' '.$address_2.', '.$city.' - '.$zipcode.', '.$country_name;

		$c_info_address = $address_1 . ' ' . $address_2 . ', ' . $city . ' - ' . $zipcode;

		//$email_phone_address = "$c_info_address \n".$this->lang->line('xin_phone')." : $c_info_phone | ".$this->lang->line('dashboard_email')." : $c_info_email ";


		$email_phone_address = "$c_info_address \n" . $this->lang->line('xin_phone') . " : $c_info_phone | " . $this->lang->line('dashboard_email') . " : $c_info_email \n";


		$header_string = $email_phone_address;

		// set document information

		$pdf->SetCreator('HRSALE');

		$pdf->SetAuthor('HRSALE');

		//$pdf->SetTitle('Workable-Zone - Payslip');

		//$pdf->SetSubject('TCPDF Tutorial');

		//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

		//$pdf->SetHeaderData($logo, 15, $company_name, $header_string);


		$pdf->setFooterData(array(0, 64, 0), array(0, 64, 128));


		// set header and footer fonts

		$pdf->setHeaderFont(array('helvetica', '', 11.5));

		$pdf->setFooterFont(array('helvetica', '', 9));


		// set default monospaced font

		$pdf->SetDefaultMonospacedFont('courier');


		// set margins

		$pdf->SetMargins(15, 27, 15);

		$pdf->SetHeaderMargin(5);

		$pdf->SetFooterMargin(10);


		// set auto page breaks

		$pdf->SetAutoPageBreak(TRUE, 25);


		// set image scale factor

		$pdf->setImageScale(1.25);

		$pdf->SetAuthor('HRSALE');

		$pdf->SetTitle($company_name . ' - ' . $this->lang->line('xin_print_payslip'));

		$pdf->SetSubject($this->lang->line('xin_payslip'));

		$pdf->SetKeywords($this->lang->line('xin_payslip'));

		// set font

		$pdf->SetFont('helvetica', 'B', 10);


		// set header and footer fonts

		$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

		$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));


		// set default monospaced font

		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);


		// set margins

		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);

		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);


		// set auto page breaks

		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);


		// set image scale factor

		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);


		// ---------------------------------------------------------


		// set default font subsetting mode

		$pdf->setFontSubsetting(true);


		// Set font

		// dejavusans is a UTF-8 Unicode font, if you only need to

		// print standard ASCII chars, you can use core fonts like

		// helvetica or times to reduce file size.

		$pdf->SetFont('dejavusans', '', 10, '', true);


		// Add a page

		// This method has several options, check the source code documentation for more information.

		$pdf->AddPage();

		// -----------------------------------------------------------------------------

		//$fname = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;

		//$date_of_joining = $this->Xin_model->set_date_format($user[0]->date_of_joining);

		$from_date = $leave[0]->from_date;

		$to_date = $leave[0]->to_date;

		$applied_on = $leave[0]->applied_on;

		$days = $leave[0]->days;

		$r_date = $leave[0]->r_date;

		$todaydate = date('d.m.Y');

		$tbl = '

        <table cellpadding="1" cellspacing="1" border="0">

            <tr>

                <td align="center"><h1>Annual Leave  Salary process Details</h1></td>

            </tr>

        </table>

        ';

		$pdf->writeHTML($tbl, true, false, false, false, '');

		// -----------------------------------------------------------------------------

		// set cell padding

		$pdf->setCellPaddings(1, 1, 1, 1);


		// set cell margins

		$pdf->setCellMargins(0, 0, 0, 0);


		// set color for background

		$pdf->SetFillColor(255, 255, 127);

		// set some text for example

		//$txt = 'Employee Details';

		// Multicell

		//$pdf->MultiCell(180, 6, $txt, 0, 'L', 11, 0, '', '', true);

		//$pdf->Ln(7);

		$data1 = '';


		if ($leave[0]->L_S_P == '') {

			$data1 .= '<tr>

                 <td align="left" >Leave Salary Paid</td>

                 <td align="right">' . $leave[0]->annua_amt . '</td>

                 </tr>';
		} else {

			$data1 .= '<tr>

                 <td align="left" >Leave Salary Paid</td>

                 <td align="right">' . $leave[0]->L_S_P . '</td>

                 </tr>';
		}


		if ($leave[0]->Balance_Amount != '') {

			$$data1 .= '<tr>

                 <td align="left" >Balance Amount</td>

                 <td align="right">' . $leave[0]->Balance_Amount . '</td>

                 </tr>';
		}


		if ($leave[0]->type_pay != '') {

			$data1 .= '<tr>

                 <td align="left" >Payment Mode</td>

                 <td align="right">' . $leave[0]->type_pay . '</td>

                 </tr>';
		}


		if ($leave[0]->p_detils != '') {

			$data1 .= '<tr>

                 <td align="left" >Payment Details</td>

                 <td align="right">' . $leave[0]->p_detils . '</td>

                 </tr>';
		}


		// ---------------------------------------------------------

		$tbl1_lv = '

            <table cellpadding="3" cellspacing="0" border="1">

                <tr>

                <td  align="left">Employee Name</td>

                <td align="right">' . $username . '</td>

                </tr>

                <tr>

                <td align="left">Leave Type</td>

                <td align="right">' . $_leave_type . '</td>

                </tr>

                <tr>

                <td align="left">Department</td>

                <td align="right">' . $_department_name . '</td>

                </tr>

                <tr>

                  <td align="left" >Designation</td>

                  <td align="right">' . $_designation_name . '</td>

                </tr>

                <tr>

                  <td align="left" >Applied On</td>

                  <td align="right">' . $applied_on . '</td>

                </tr>

                <tr>

                 <td align="left" >Request Duration</td>

                  <td align="right">' . $from_date . ' - ' . $to_date . ' </td>

                </tr>

                 <tr>

                 <td align="left" >Total Days</td>

                  <td align="right">' . $days . '</td>

                </tr>

                 <tr>

                 <td align="left" >Retrive Date</td>

                  <td align="right">' . $r_date . '</td>

                </tr>

                 <tr>

                 <td align="left" >Status</td>

                  <td align="right">' . $leave[0]->status_p_un . '</td>

                </tr>

                ' . $data1 . '

                ';


		$tbl1_lv .= '</table>';

		$pdf->writeHTML($tbl1_lv, true, false, true, false, '');


		// Close and output PDF document

		// This method has several options, check the source code documentation for more information.

		//$fname = strtolower($fname);

		//Close and output PDF document

		ob_start();

		$pdf->Output('Annuval_leave' . $username . '_' . $from_date . '-' . $to_date . '.pdf', 'I');

		ob_end_flush();
	}

	public function update_attendance()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_update_attendance') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('left_update_attendance');
		$data['path_url'] = 'update_attendance';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('223', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/update_attendance", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// import > timesheet
	public function import()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_import_attendance') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('left_import_attendance');
		$data['path_url'] = 'import_attendance';
		$data['all_employees'] = $this->Xin_model->all_employees();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('31', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/attendance_import", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// index > timesheet
	public function index()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$month_year = $this->input->post('month_year');
		if (isset($month_year)) : $title = date('F Y', strtotime($month_year));
		else : $title = date('F Y');
		endif;
		$data['title'] = $this->lang->line('xin_month_timesheet_title') . ' | ' . $title;
		$data['breadcrumbs'] = $this->lang->line('xin_month_timesheet_title');
		$data['path_url'] = 'timesheet_monthly';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_office_shifts'] = $this->Location_model->all_office_locations();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_locations'] = $this->Xin_model->get_company_locations();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('228', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/timesheet_monthly", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// timecard > timesheet
	public function timecalendar()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		//	echo 'dfgh';exit;
		$data['title'] = $this->lang->line('xin_acc_calendar') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('xin_acc_calendar');
		$data['path_url'] = 'timesheet_calendar';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('230', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/calendar/timecalendar", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}


	public function read_annual_encash_leave_record()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_encash_leave_edit', $data);
		} else {
			redirect('admin/');
		}
	}


	// Validate and add info in database
	public function import_attendance()
	{

		if ($this->input->post('is_ajax') == '3') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			//validate whether uploaded file is a csv file
			$csvMimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain');

			if (empty($_FILES['file']['name'])) {
				$Return['error'] = $this->lang->line('xin_attendance_allowed_size');
			} else {
				if (in_array($_FILES['file']['type'], $csvMimes)) {
					if (is_uploaded_file($_FILES['file']['tmp_name'])) {

						// check file size
						if (filesize($_FILES['file']['tmp_name']) > 512000) {
							$Return['error'] = $this->lang->line('xin_error_attendance_import_size');
						} else {

							//open uploaded csv file with read only mode
							$csvFile = fopen($_FILES['file']['tmp_name'], 'r');

							//skip first line
							fgetcsv($csvFile);

							//parse data from csv file line by line
							while (($line = fgetcsv($csvFile)) !== FALSE) {

								$attendance_date = $line[1];
								$clock_in = $line[2];
								$clock_out = $line[3];
								$clock_in2 = $attendance_date . ' ' . $clock_in;
								$clock_out2 = $attendance_date . ' ' . $clock_out;

								//total work
								$total_work_cin = new DateTime($clock_in2);
								$total_work_cout = new DateTime($clock_out2);

								$interval_cin = $total_work_cout->diff($total_work_cin);
								$hours_in = $interval_cin->format('%h');
								$minutes_in = $interval_cin->format('%i');
								$total_work = $hours_in . ":" . $minutes_in;

								$user = $this->Xin_model->read_user_by_employee_id($line[0]);
								if (!is_null($user)) {
									$user_id = $user[0]->user_id;
								} else {
									$user_id = '0';
								}

								$data = array(
									'employee_id' => $user_id,
									'attendance_date' => $attendance_date,
									'clock_in' => $clock_in2,
									'clock_out' => $clock_out2,
									'time_late' => $clock_in2,
									'total_work' => $total_work,
									'early_leaving' => $clock_out2,
									'overtime' => $clock_out2,
									'attendance_status' => 'Present',
									'clock_in_out' => '0'
								);
								$result = $this->Timesheet_model->add_employee_attendance($data);
							}
							//close opened csv file
							fclose($csvFile);

							$Return['result'] = $this->lang->line('xin_success_attendance_import');
						}
					} else {
						$Return['error'] = $this->lang->line('xin_error_not_attendance_import');
					}
				} else {
					$Return['error'] = $this->lang->line('xin_error_invalid_file');
				}
			} // file empty

			if ($Return['error'] != '') {
				$this->output($Return);
			}


			$this->output($Return);
			exit;
		}
	}

	// office shift > timesheet
	public function office_shift()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		// $data['title'] = $this->lang->line('left_office_shift') . ' | ' . $this->Xin_model->site_title();
		$data['title'] = 'Manage Shifts' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Manage Shifts';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'office_shift';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('7', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/office_shift", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	public function office_shift_custom()
	{
		$session = $this->session->userdata('username');

		if (empty($session)) {
			redirect('admin/');
		}

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (!in_array('7', $role_resources_ids)) {
			redirect('admin/dashboard');
		}

		// $data['title'] = 'Custom ' . $this->lang->line('left_office_shift') . ' | ' . $this->Xin_model->site_title();
		$data['title'] = 'Custom Shifts' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Custom Shifts';
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'office_shift_custom';

		$data['subview'] = $this->load->view("admin/timesheet/office_shift_custom", $data, TRUE);
		$this->load->view('admin/layout/layout_main', $data); //page load
	}

	public function office_shift_custom_elements($month)
	{
		$days_in_month = date('t', strtotime($month));

		$html = '<div class="row">
    <div class="col-md-2">&nbsp;</div>
    <div class="col-md-3"><h5>Shift start</h5></div>
    <div class="col-md-3"><h5>Shift end</h5></div>
    <div class="col-md-2"><h5>Total Hours</h5></div>
</div>';

		for ($i = 1; $i <= $days_in_month; $i++) {
			$date = "$month-" . str_pad($i, 2, 0, STR_PAD_LEFT);
			$weekday_label = date('M d l', strtotime($date));
			$html .= '
<div class="form-group row">
    <label for="time" class="col-md-2">' . $weekday_label . '</label>
    <div class="col-md-3">
        <div class="row">
            <div class="col-md-6">
                <input class="form-control date date_in_' . $i . '" readonly name="' . $i . '_in[date]" type="text" value="' . $date . '">
            </div>
            <div class="col-md-6">
                <input class="form-control time_in_class time_in_class_' . $i . ' timepicker clear-' . $i . '" data-time_id="' . $i . '" readonly name="' . $i . '_in[time]" type="text">
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="row">
            <div class="col-md-6">
                <input class="form-control date date_out_' . $i . '" readonly name="' . $i . '_out[date]" type="text" value="' . $date . '">
            </div>
            <div class="col-md-6">
                <input class="form-control time_out_class time_out_class_' . $i . ' timepicker clear-' . $i . '" data-time_id="' . $i . '" readonly name="' . $i . '_out[time]" type="text">
            </div>
        </div>
    </div>
    <div class="col-md-2">
    <input class="form-control" name="' . $i . '_hrs" type="text" value="">
    </div>
    <div class="col-md-2">
        <button type="button" class="btn btn-primary clear-time" data-clear-id="' . $i . '">' . $this->lang->line('xin_clear') . '</button>
    </div>
</div>
';
		}

		echo $html;
	}

	public function office_shift_custom_add()
	{
		$Return = array(
			'result' => '',
			'error' => '',
			'csrf_hash' => $this->security->get_csrf_hash(),
		);

		$employee_id = $this->input->post("employee_id");
		$name = $this->input->post("name");
		$late_allowed_till = $this->input->post("late_allowed_till");
		$month = $this->input->post("month");

		if ($this->input->post('employee_id') === '') {
			$Return['error'] = 'Employee field is required';
		} else if ($name == '') {
			$Return['error'] = 'Shift name is required';
		} else if ($this->Office_shift_custom_model->assigned($employee_id, $month) > 0) {
			$Return['error'] = 'Shift already assigned for this Employee [' . $month . ']';
		} else {
			$data['name'] = $name;
			$data['employee_id'] = $employee_id;
			$data['month'] = $month;
			$data['late_allowed_till'] = $late_allowed_till;

            foreach ($this->input->post() as $key => $value) {
                if (strpos($key, '_hrs') !== false)
                    $data[$key] = $value;
                else{
                        if (strpos($key, '_in') === false)
                            if (strpos($key, '_out') === false)
                                continue;
                
                    $date = trim($value['date']);
                    $time = trim($value['time']);

                    if (empty($date) || empty($time))
                        continue;

                    $datetime = "$date $time:00";
                    $data[$key] = $datetime;
                }
                
            }

			$this->Office_shift_custom_model->save($data);

			$Return['result'] = 'Shift data has been saved.';
		}

		$this->output($Return);
	}

	public function office_shift_custom_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if ($user_info[0]->user_role_id == 1) {
			$office_shift = $this->Office_shift_custom_model->get();
		} else {
			if (in_array('682', $role_resources_ids)) {
				$office_shift = $this->Office_shift_custom_model->get();
			} else {
				$office_shift = $this->Office_shift_custom_model->get($user_info[0]->user_id);
			}
		}

		$data = $employee_names = array();

		foreach ($office_shift->result_array() as $r) {
			$edit = $delete = '';
			if (in_array('680', $role_resources_ids)) {
				$edit = '<span data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
<a class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" href="' . site_url() . 'admin/timesheet/office_shift_custom_edit/' . $r['id'] . '">
    <span class="fas fa-pencil-alt"></span>
</a>
</span>';
			}

			if (in_array('681', $role_resources_ids)) {
				$delete = '<span  data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
<button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r['id'] . '">
    <span class="fas fa-trash-restore"></span>
</button>
</span>';
			}

			$combhr = $edit . $delete;

			if (!isset($employee_names[$r['employee_id']])) {
				$employee = $this->Employees_model->read_employee_information($r['employee_id']);
				if ($employee) {
					$employee_names[$r['employee_id']] = $employee[0]->first_name . ' ' . $employee[0]->last_name;
				} else {
					continue;
				}
			}

			$employee_details = $employee_names[$r['employee_id']];

			if (in_array('680', $role_resources_ids) || in_array('681', $role_resources_ids)) {
				$tmp = array(
					$employee_details,
					$r['name'],
					date('M Y', strtotime($r['month'])),
				);

				for ($i = 1; $i <= 31; $i++) {
					$timing = '<span class="text-nowrap">';

					if ($in = $r[$i . '_in']) {
						$in = date('h:i A', strtotime($in));
						$timing .= $in;
					}

					$timing .= '</span>';

					if ($out = $r[$i . '_out']) {
						$out = date('h:i A', strtotime($out));
						$timing .= '&nbsp;=>&nbsp;<br><span class="text-nowrap">' . $out . '</span>';
					}

					array_push($tmp, $timing);
				}

				array_push($tmp, $combhr);

				$data[] = $tmp;
			} else {
				$tmp = array(
					$employee_details,
					$r['name'],
					date('M Y', strtotime($r['month'])),
				);

				for ($i = 1; $i <= 31; $i++) {
					$timing = '<span class="text-nowrap">';

					if ($in = $r[$i . '_in']) {
						$in = date('h:i A', strtotime($in));
						$timing .= $in;
					}

					$timing .= '</span>';

					if ($out = $r[$i . '_out']) {
						$out = date('h:i A', strtotime($out));
						$timing .= '&nbsp;=>&nbsp;<br><span class="text-nowrap">' . $out . '</span>';
					}

					array_push($tmp, $timing);
				}

				$data[] = $tmp;
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $office_shift->num_rows(),
			"recordsFiltered" => $office_shift->num_rows(),
			"data" => $data
		);

		$this->output($output);
	}

	public function office_shift_custom_edit($id)
	{
		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (!in_array('680', $role_resources_ids)) {
			redirect('admin/dashboard');
		}

		$data['title'] = 'Custom ' . $this->lang->line('left_office_shift') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Custom ' . $this->lang->line('left_office_shift');
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'office_shift_custom_edit';
		$data['office_shift'] = $this->Office_shift_custom_model->find($id);
		$data['employee'] = $this->Employees_model->read_employee_information($data['office_shift']['employee_id']);
		$data['subview'] = $this->load->view("admin/timesheet/office_shift_custom_edit", $data, TRUE);
		$this->load->view('admin/layout/layout_main', $data);
	}

	public function office_shift_custom_update($id)
	{
		$Return = array(
			'result' => '',
			'error' => '',
			'csrf_hash' => $this->security->get_csrf_hash(),
		);

		$employee_id = $this->input->post("employee_id");
		$name = $this->input->post("name");
		$late_allowed_till = $this->input->post("late_allowed_till");
		$month = $this->input->post("month");

		$data['name'] = $name;
		$data['month'] = $month;
		$data['late_allowed_till'] = $late_allowed_till;


        foreach ($this->input->post() as $key => $value) {

            if (strpos($key, '_hrs') !== false)
                    $data[$key] = $value;
                else{
                        if (strpos($key, '_in') === false)
                            if (strpos($key, '_out') === false)
                                continue;
                
                    $date = trim($value['date']);
                    $time = trim($value['time']);

                    if (empty($date) || empty($time))
                        continue;

                    $datetime = "$date $time:00";
                    $data[$key] = $datetime;
                }

        }

		$this->Office_shift_custom_model->update($id, $data);

		$Return['result'] = 'Shift data has been updated.';

		$this->output($Return);
	}

	/*
	Delete office shifts
	*/
	public function office_shift_custom_delete()
	{
		$Return = array(
			'result' => '',
			'error' => '',
			'csrf_hash' => $this->security->get_csrf_hash(),
		);

		$id = $this->input->post('shift_id');
		$this->Office_shift_custom_model->delete($id);

		$Return['result'] = 'Shift has been deleted.';

		$this->output($Return);
	}

	// holidays > timesheet
	public function holidays()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = $this->lang->line('left_holidays') . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = $this->lang->line('left_holidays');
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['path_url'] = 'holidays';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('418', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/holidays", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// leave > timesheet
	public function leave()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_leaves') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
		$data['breadcrumbs'] = $this->lang->line('left_leaves');
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['path_url'] = 'leave';


		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('250', $role_resources_ids) || $reports_to > 0) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/leave", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}


	public function leave_new()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->lang->line('left_leaves') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
		$data['breadcrumbs'] = $this->lang->line('left_leaves');
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['path_url'] = 'leave';


		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('250', $role_resources_ids) || $reports_to > 0) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/cancel_leave", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}


	// leave > timesheet
	public function leave_details()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$data['title'] = $this->Xin_model->site_title();
		$leave_id = $this->uri->segment(5);
		// leave applications
		$result = $this->Timesheet_model->read_leave_information($leave_id);
		$edata = array(
			'is_notify' => 0,
		);
		//	$this->Xin_model->update_notification_record_new($edata, $leave_id,'leave');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'leave');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'leave_approve');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'leave_approve_rejected');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'leave_approve_pending');
		if (is_null($result)) {
			redirect('admin/timesheet/leave');
		}

		// get leave types
		$type = $this->Timesheet_model->read_leave_type_information($result[0]->leave_type_id);
		if (!is_null($type)) {
			$type_name = $type[0]->type_name;
		} else {
			$type_name = '--';
		}
		// get employee
		$user = $this->Xin_model->read_user_info($result[0]->employee_id);
		if (!is_null($user)) {
			$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
			$u_role_id = $user[0]->user_role_id;
			$department = $this->Department_model->read_department_information($user[0]->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
		} else {
			$full_name = '--';
			$u_role_id = '--';
			$department_name = '--';
		}

		if ($session['user_id'] == 1) {
			$data = array(
				'admin_read' => 1
			);
			$this->Timesheet_model->update_leave_readrecord($data, $leave_id);
		}
		// print_r($result[0]);
		$data = array(
			'title' => $this->lang->line('xin_leave_detail') . ' | ' . $this->Xin_model->site_title(),
			'type' => $type_name,
			'role_id' => $u_role_id,
			'full_name' => $full_name,
			'eemployee_id' => $result[0]->employee_id,
			'department_name' => $department_name,
			'leave_id' => $result[0]->leave_id,
			'employee_id' => $result[0]->employee_id,
			'company_id' => $result[0]->company_id,
			'leave_type_id' => $result[0]->leave_type_id,
			'from_date' => $result[0]->from_date,
			'to_date' => $result[0]->to_date,
			'applied_on' => $result[0]->applied_on,
			'reason' => $result[0]->reason,
			'remarks' => $result[0]->remarks,
			'status' => $result[0]->status,
			'first_approval' => $result[0]->first_approval,
			'second_approval' => $result[0]->second_approval,
			'final_approval' => $result[0]->final_approval,
			'probation_check' => $result[0]->probation_check,
			'leave_attachment' => $result[0]->leave_attachment,
			'is_half_day' => $result[0]->is_half_day,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'all_leave_types' => $this->Timesheet_model->all_leave_types(),
		);
		$data['breadcrumbs'] = $this->lang->line('xin_leave_detail');
		$data['path_url'] = 'leave_details';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('250', $role_resources_ids) || $reports_to > 0) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/leave_details", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// leave > timesheet
	public function task_details()
	{

		$session = $this->session->userdata('username');
		$data['title'] = $this->Xin_model->site_title();

		$task_id = $this->uri->segment(5);
		$result = $this->Timesheet_model->read_task_information($task_id);
		if (is_null($result)) {
			redirect('admin/timesheet/tasks');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_projects_tasks != 'true') {
			redirect('admin/dashboard');
		}
		$edata = array(
			'is_notify' => 0,
		);
		$this->Xin_model->update_notification_record($edata, $task_id, $session['user_id'], 'tasks');
		/* get User info*/
		$u_created = $this->Xin_model->read_user_info($result[0]->created_by);

		if (!is_null($u_created)) {
			$f_name = $u_created[0]->first_name . ' ' . $u_created[0]->middle_name . ' ' . $u_created[0]->last_name;
		} else {
			$f_name = '--';
		}

		// task project
		$prj_task = $this->Project_model->read_project_information($result[0]->project_id);
		if (!is_null($prj_task)) {
			$prj_name = $prj_task[0]->title;
		} else {
			$prj_name = '--';
		}

		$data = array(
			'title' => $this->lang->line('xin_task_detail') . ' | ' . $this->Xin_model->site_title(),
			'task_id' => $result[0]->task_id,
			'project_name' => $prj_name,
			'created_by' => $f_name,
			'task_name' => $result[0]->task_name,
			'assigned_to' => $result[0]->assigned_to,
			'start_date' => $result[0]->start_date,
			'end_date' => $result[0]->end_date,
			'task_hour' => $result[0]->task_hour,
			'task_status' => $result[0]->task_status,
			'task_note' => $result[0]->task_note,
			'progress' => $result[0]->task_progress,
			'description' => $result[0]->description,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees()
		);
		$data['breadcrumbs'] = $this->lang->line('xin_task_detail');
		$data['path_url'] = 'task_details';
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
		$session = $this->session->userdata('username');
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('45', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/tasks/task_details", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// tasks > timesheet
	public function tasks()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_projects_tasks != 'true') {
			redirect('admin/dashboard');
		}
		$data['title'] = $this->lang->line('left_tasks') . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_projects'] = $this->Project_model->get_all_projects();
		$data['breadcrumbs'] = $this->lang->line('left_tasks');
		$data['path_url'] = 'tasks';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('473', $role_resources_ids)) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/tasks/task_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	// Validate and update info in database // assign_ticket
	public function assign_task()
	{

		if ($this->input->post('type') == 'task_user') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if (null != $this->input->post('assigned_to')) {
				$assigned_ids = implode(',', $this->input->post('assigned_to'));
				$employee_ids = $assigned_ids;
			} else {
				$employee_ids = '';
			}

			$data = array(
				'assigned_to' => $employee_ids
			);
			$id = $this->input->post('task_id');
			$result = $this->Timesheet_model->assign_task_user($data, $id);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_task_assigned');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// update task user > task details
	public function task_users()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'task_id' => $id,
			'all_employees' => $this->Xin_model->all_employees(),
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_task_users", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// Validate and update info in database // update_status
	public function update_task_status_validate()
	{

		if ($this->input->post('type') == 'update_status') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			if ($this->input->post('status') === '') {

				$Return['error'] = "Status is required";
			}
			$this->output($Return);
			exit;
		}
	}

	public function update_task_status()
	{

		if ($this->input->post('type') == 'update_status') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$data = array(
				'task_progress' => $this->input->post('progres_val'),
				'task_status' => $this->input->post('status'),
			);
			$id = $this->input->post('task_id');
			$result = $this->Timesheet_model->update_task_record($data, $id);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_task_status');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// task list > timesheet
	public function task_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1 || in_array('478', $role_resources_ids) || in_array('473', $role_resources_ids)) {
			$task = $this->Timesheet_model->get_tasks();
		} else {
			if (in_array('477', $role_resources_ids)) {
				$task = $this->Timesheet_model->get_company_tasks($user_info[0]->company_id);
			} else {
				$task = $this->Timesheet_model->get_employee_tasks($session['user_id']);
			}
		}
		$data = array();

		foreach ($task->result() as $r) {
			$aim = explode(',', $r->assigned_to);

			if ($r->assigned_to == '' || $r->assigned_to == 'None') {
				$ol = 'None';
			} else {
				$ol = '';
				foreach (explode(',', $r->assigned_to) as $uid) {
					//$user = $this->Xin_model->read_user_info($uid);
					$assigned_to = $this->Xin_model->read_user_info($uid);
					if (!is_null($assigned_to)) {

						$assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
						if ($assigned_to[0]->profile_picture != '' && $assigned_to[0]->profile_picture != 'no file') {
							$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $assigned_to[0]->profile_picture . '" class="ui-w-30 rounded-circle" alt=""></span></a>';
						} else {
							if ($assigned_to[0]->gender == 'Male') {
								$de_file = base_url() . 'uploads/profile/default_male.jpg';
							} else {
								$de_file = base_url() . 'uploads/profile/default_female.jpg';
							}
							$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . $de_file . '" class="ui-w-30 rounded-circle" alt=""></span></a>';
						}
					}
				}
				$ol .= '';
			}
			//$ol = 'A';
			/* get User info*/
			$u_created = $this->Xin_model->read_user_info($r->created_by);
			if (!is_null($u_created)) {
				$f_name = $u_created[0]->first_name . ' ' . $u_created[0]->middle_name . ' ' . $u_created[0]->last_name;
			} else {
				$f_name = '--';
			}

			// task project
			$prj_task = $this->Project_model->read_project_information($r->project_id);
			if (!is_null($prj_task)) {
				$prj_name = $prj_task[0]->title;
			} else {
				$prj_name = '--';
			}
			// task category
			$task_catname = $r->task_name;

			/// set task progress
			if ($r->task_progress == '' || $r->task_progress == 0) : $progress = 0;
			else : $progress = $r->task_progress;
			endif;
			// task progress
			if ($r->task_progress <= 20) {
				$progress_class = 'progress-bar-danger';
			} else if ($r->task_progress > 20 && $r->task_progress <= 50) {
				$progress_class = 'progress-bar-warning';
			} else if ($r->task_progress > 50 && $r->task_progress <= 75) {
				$progress_class = 'progress-bar-info';
			} else {
				$progress_class = 'progress-bar-success';
			}

			$progress_bar = '<p class="m-b-0-5">' . $this->lang->line('xin_completed') . ' <span class="pull-xs-right">' . $r->task_progress . '%</span>
	<div class="progress progress-xs"><div class="progress-bar ' . $progress_class . ' progress-bar-striped" role="progressbar" aria-valuenow="' . $r->task_progress . '" aria-valuemin="0" aria-valuemax="100" style="width: ' . $r->task_progress . '%"></div></div></p>';
			// task status
			if ($r->task_status == 0) {
				$status = '<span class="label label-warning">' . $this->lang->line('xin_not_started') . '</span>';
			} else if ($r->task_status == 1) {
				$status = '<span class="label label-primary">' . $this->lang->line('xin_in_progress') . '</span>';
			} else if ($r->task_status == 2) {
				$status = '<span class="label label-success">' . $this->lang->line('xin_completed') . '</span>';
			} else if ($r->task_status == 3) {
				$status = '<span class="label label-danger">' . $this->lang->line('xin_project_cancelled') . '</span>';
			} else {
				$status = '<span class="label label-danger">' . $this->lang->line('xin_project_hold') . '</span>';
			}
			// task start/end date
			$psdate = $this->Xin_model->set_date_format($r->start_date);
			$pedate = $this->Xin_model->set_date_format($r->end_date);
			if (in_array('475', $role_resources_ids) || in_array('480', $role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-task_id="' . $r->task_id . '" data-mname="admin"><span class="fas fa-pencil-alt"></span></button></span>';
				$add_users = ' <a href="javascript:void(0)" class="text-muted" data-toggle="modal" data-target=".edit-modal-data" data-task_id="' . $r->task_id . '" ><span class="ion ion-md-add" data-placement="top" data-state="primary" data-toggle="tooltip" title="' . $this->lang->line('xin_add_member') . '"></span></a> ';
			} else {
				$edit = '';
				$add_users = '';
			}
			if (in_array('476', $role_resources_ids) || in_array('481', $role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->task_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if (in_array('477', $role_resources_ids) || in_array('482', $role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/task_details/id/' . $r->task_id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {
				$view = '';
			}
			$combhr = $edit . $view . $delete;
			$ttask_date = $this->lang->line('xin_start_date') . ': ' . $psdate . '<br>' . $this->lang->line('xin_end_date') . ': ' . $pedate;
			if (in_array('475', $role_resources_ids) || in_array('480', $role_resources_ids) || in_array('476', $role_resources_ids) || in_array('481', $role_resources_ids) || in_array('477', $role_resources_ids) || in_array('482', $role_resources_ids)) {
				$data[] = array(

					//$task_catname . '<br>' . $this->lang->line('xin_project') . ': <a href="' . site_url() . 'admin/project/detail/' . $r->project_id . '">' . $prj_name . '</a><br>' . $this->lang->line('xin_hours') . ': ' . $r->task_hour,
					$task_catname,
					$ol . $add_users,
					//$ttask_date,
					$psdate,
					$pedate,
					$status,

					$f_name,
					$progress_bar,
					$combhr,
				);
			} else {
				$data[] = array(
					//$task_catname . '<br>' . $this->lang->line('xin_project') . ': <a href="' . site_url() . 'admin/project/detail/' . $r->project_id . '">' . $prj_name . '</a><br>' . $this->lang->line('xin_hours') . ': ' . $r->task_hour,
					$task_catname,
					$ol . $add_users,
					//$ttask_date,
					$psdate,
					$pedate,
					$status,

					$f_name,
					$progress_bar,
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $task->num_rows(),
			"recordsFiltered" => $task->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// project task list > timesheet
	public function project_task_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$id = $this->uri->segment(4);
		$task = $this->Timesheet_model->get_project_tasks($id);

		$data = array();

		foreach ($task->result() as $r) {

			if ($r->assigned_to == '' || $r->assigned_to == 'None') {
				$ol = $this->lang->line('xin_performance_none');
			} else {
				$ol = '';
				foreach (explode(',', $r->assigned_to) as $uid) {
					$assigned_to = $this->Xin_model->read_user_info($uid);
					if (!is_null($assigned_to)) {
						$assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
						if ($assigned_to[0]->profile_picture != '' && $assigned_to[0]->profile_picture != 'no file') {
							$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $assigned_to[0]->profile_picture . '" class="user-image-hr ui-w-30 rounded-circle" alt=""></span></a>';
						} else {
							if ($assigned_to[0]->gender == 'Male') {
								$de_file = base_url() . 'uploads/profile/default_male.jpg';
							} else {
								$de_file = base_url() . 'uploads/profile/default_female.jpg';
							}
							$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . $de_file . '" class="user-image-hr ui-w-30 rounded-circle" alt=""></span></a>';
						}
						//
					}
				}
				$ol .= '';
			}
			//$ol = 'A';
			/* get User info*/
			$u_created = $this->Xin_model->read_user_info($r->created_by);
			$f_name = $u_created[0]->first_name . ' ' . $u_created[0]->middle_name . ' ' . $u_created[0]->last_name;
			// task category
			$task_catname = $r->task_name;
			/// set task progress
			if ($r->task_progress == '' || $r->task_progress == 0) : $progress = 0;
			else : $progress = $r->task_progress;
			endif;


			// task progress
			if ($r->task_progress <= 20) {
				$progress_class = 'progress-danger';
			} else if ($r->task_progress > 20 && $r->task_progress <= 50) {
				$progress_class = 'progress-warning';
			} else if ($r->task_progress > 50 && $r->task_progress <= 75) {
				$progress_class = 'progress-info';
			} else {
				$progress_class = 'progress-success';
			}

			$progress_bar = '<p class="m-b-0-5">' . $this->lang->line('xin_completed') . ' <span class="pull-xs-right">' . $r->task_progress . '%</span></p><div class="progress" style="height: 7px;"><div class="progress-bar" style="width: ' . $r->task_progress . '%;"></div></div>';


			// task status
			if ($r->task_status == 0) {
				$status = $this->lang->line('xin_not_started');
			} else if ($r->task_status == 1) {
				$status = $this->lang->line('xin_in_progress');
			} else if ($r->task_status == 2) {
				$status = $this->lang->line('xin_completed');
			} else if ($r->task_status == 3) {
				$status = $this->lang->line('xin_project_cancelled');
			} else {
				$status = $this->lang->line('xin_project_hold');
			}

			// task end date
			$tdate = $this->Xin_model->set_date_format($r->end_date);

			$data[] = array(
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/task_details/id/' . $r->task_id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-arrow-circle-right"></span></button></a></span><span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-task_id="' . $r->task_id . '" data-mname="hr"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete-task" data-toggle="modal" data-target=".delete-modal-task" data-record-id="' . $r->task_id . '"><span class="fas fa-trash-restore"></span></button></span>',
				$task_catname,
				$tdate,
				$status,
				$ol,
				$f_name,
				$progress_bar
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $task->num_rows(),
			"recordsFiltered" => $task->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// project variation list > timesheet
	public function project_variation_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$id = $this->uri->segment(4);
		$task = $this->Timesheet_model->get_project_variations($id);

		$data = array();

		foreach ($task->result() as $r) {

			if ($r->assigned_to == '' || $r->assigned_to == 'None') {
				$ol = $this->lang->line('xin_performance_none');
			} else {
				$ol = '';
				foreach (explode(',', $r->assigned_to) as $uid) {
					$assigned_to = $this->Xin_model->read_user_info($uid);
					if (!is_null($assigned_to)) {
						$assigned_name = $assigned_to[0]->first_name . ' ' . $assigned_to[0]->middle_name . ' ' . $assigned_to[0]->last_name;
						if ($assigned_to[0]->profile_picture != '' && $assigned_to[0]->profile_picture != 'no file') {
							$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . base_url() . 'uploads/profile/' . $assigned_to[0]->profile_picture . '" class="user-image-hr ui-w-30 rounded-circle" alt=""></span></a>';
						} else {
							if ($assigned_to[0]->gender == 'Male') {
								$de_file = base_url() . 'uploads/profile/default_male.jpg';
							} else {
								$de_file = base_url() . 'uploads/profile/default_female.jpg';
							}
							$ol .= '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="top" title="' . $assigned_name . '"><span class="avatar box-32"><img src="' . $de_file . '" class="user-image-hr ui-w-30 rounded-circle" alt=""></span></a>';
						}
						//
					}
				}
				$ol .= '';
			}
			//$ol = 'A';
			/* get User info*/
			$u_created = $this->Xin_model->read_user_info($r->created_by);
			$f_name = $u_created[0]->first_name . ' ' . $u_created[0]->middle_name . ' ' . $u_created[0]->last_name;
			// variation category
			$task_cat = $this->Project_model->read_task_category_information($r->variation_name);
			if (!is_null($task_cat)) {
				$task_catname = $task_cat[0]->category_name;
			} else {
				$task_catname = '--';
			}

			// variation status
			if ($r->variation_status == 0) {
				$status = '<span class="label label-warning">' . $this->lang->line('xin_not_started') . '</span>';
			} else if ($r->variation_status == 1) {
				$status = '<span class="label label-primary">' . $this->lang->line('xin_in_progress') . '</span>';
			} else if ($r->variation_status == 2) {
				$status = '<span class="label label-success">' . $this->lang->line('xin_completed') . '</span>';
			} else if ($r->variation_status == 3) {
				$status = '<span class="label label-danger">' . $this->lang->line('xin_project_cancelled') . '</span>';
			} else {
				$status = '<span class="label label-danger">' . $this->lang->line('xin_project_hold') . '</span>';
			}
			if ($r->client_approval == 0) {
				$client_approval = $this->lang->line('xin_client_approval_unclaimed');
			} else {
				$client_approval = $this->lang->line('xin_client_approval_claimed');
			}
			// variation end date
			$vsdate = $this->Xin_model->set_date_format($r->start_date);
			$vedate = $this->Xin_model->set_date_format($r->end_date);
			$variation_date = $this->lang->line('xin_start_date') . ': ' . $vsdate . '<br>' . $this->lang->line('xin_end_date') . ': ' . $vedate;
			$data[] = array(
				'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-variation-data" data-variation_id="' . $r->variation_id . '" data-mname="variation"><span class="fas fa-pencil-alt"></span></button></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete-variation" data-toggle="modal" data-target=".delete-modal-variation" data-record-id="' . $r->variation_id . '"><span class="fas fa-trash-restore"></span></button></span>',
				$task_catname . '<br>' . $status,
				$r->variation_no,
				$variation_date,
				$ol,
				$client_approval
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $task->num_rows(),
			"recordsFiltered" => $task->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function comments_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		//$id = $this->input->get('ticket_id');
		$id = $this->uri->segment(4);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/task_details", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$comments = $this->Timesheet_model->get_comments($id);

		$data = array();

		foreach ($comments->result() as $r) {

			// get user > employee_
			$employee = $this->Xin_model->read_user_info($r->user_id);
			// employee full name
			if (!is_null($employee)) {
				$employee_name = $employee[0]->first_name . ' ' . $employee[0]->middle_name . ' ' . $employee[0]->last_name;
				// get designation
				$_designation = $this->Designation_model->read_designation_information($employee[0]->designation_id);
				if (!is_null($_designation)) {
					$designation_name = $_designation[0]->designation_name;
				} else {
					$designation_name = '--';
				}

				// profile picture
				if ($employee[0]->profile_picture != '' && $employee[0]->profile_picture != 'no file') {
					$u_file = base_url() . 'uploads/profile/' . $employee[0]->profile_picture;
				} else {
					if ($employee[0]->gender == 'Male') {
						$u_file = base_url() . 'uploads/profile/default_male.jpg';
					} else {
						$u_file = base_url() . 'uploads/profile/default_female.jpg';
					}
				}
			} else {
				$employee_name = '--';
				$designation_name = '--';
				$u_file = '--';
			}
			// created at
			$created_at = date('h:i A', strtotime($r->created_at));
			$_date = explode(' ', $r->created_at);
			$date = $this->Xin_model->set_date_format($_date[0]);
			//
			$link = '<a class="c-user text-black" href="' . site_url() . 'admin/employees/detail/' . $r->user_id . '"><span class="underline">' . $employee_name . ' (' . $designation_name . ')</span></a>';

			$dlink = '<div class="media-right">
							<div class="c-rating">
							<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '">
								<a class="btn icon-btn btn-sm btn-outline-danger delete" href="#" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->comment_id . '">
			  <span class="fas fa-trash-restore m-r-0-5"></span></a></span>
							</div>
						</div>';

			$function = '<div class="c-item">
					<div class="media">
						<div class="media-left">
							<div class="avatar box-48">
							<img class="user-image-hr-prj ui-w-30 rounded-circle" src="' . $u_file . '">
							</div>
						</div>
						<div class="media-body">
							<div class="mb-0-5">
								' . $link . '
								<span class="font-90 text-muted">' . $date . ' ' . $created_at . '</span>
							</div>
							<div class="c-text">' . $r->task_comments . '</div>
						</div>
						' . $dlink . '
					</div>
				</div>';

			$data[] = array(
				$function
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $comments->num_rows(),
			"recordsFiltered" => $comments->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// Validate and add info in database
	public function set_comment_validate()
	{

		if ($this->input->post('add_type') == 'set_comment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('xin_comment') === '') {
				$Return['error'] = $this->lang->line('xin_error_comment_field');
			}
			$xin_comment = $this->input->post('xin_comment');
			$qt_xin_comment = htmlspecialchars(addslashes($xin_comment), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$this->output($Return);
			exit;
		}
	}

	public function set_comment()
	{

		if ($this->input->post('add_type') == 'set_comment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('xin_comment') === '') {
				$Return['error'] = $this->lang->line('xin_error_comment_field');
			}
			$xin_comment = $this->input->post('xin_comment');
			$qt_xin_comment = htmlspecialchars(addslashes($xin_comment), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'task_comments' => $qt_xin_comment,
				'task_id' => $this->input->post('comment_task_id'),
				'user_id' => $this->input->post('user_id'),
				'created_at' => date('d-m-Y h:i:s')
			);
			$result = $this->Timesheet_model->add_comment($data);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_comment_task');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function comment_delete()
	{
		if ($this->input->post('data') == 'task_comment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_comment_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_comment_task_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	// Validate and add info in database
	public function add_attachment_validate()
	{

		if ($this->input->post('add_type') == 'dfile_attachment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('file_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_name');
			} else if ($_FILES['attachment_file']['size'] == 0) {
				$Return['error'] = $this->lang->line('xin_error_task_file');
			} else if ($this->input->post('file_description') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_description');
			}
			$description = $this->input->post('file_description');
			$file_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			// is file upload
			if (is_uploaded_file($_FILES['attachment_file']['tmp_name'])) {
				//checking image type
				$allowed = array('png', 'jpg', 'jpeg', 'gif', 'pdf', 'doc', 'docx', 'xls', 'xlsx', 'txt');
				$filename = $_FILES['attachment_file']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);

				if (in_array($ext, $allowed)) {
					$tmp_name = $_FILES["attachment_file"]["tmp_name"];
					$attachment_file = "uploads/task/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$name = basename($_FILES["attachment_file"]["name"]);
					$newfilename = 'task_' . round(microtime(true)) . '.' . $ext;
					move_uploaded_file($tmp_name, $attachment_file . $newfilename);
					$fname = $newfilename;
					$Return['fileName'] = $newfilename;
				} else {
					$Return['error'] = $this->lang->line('xin_error_task_file_attachment');
				}
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$this->output($Return);
			exit;
		}
	}

	public function add_attachment()
	{

		if ($this->input->post('add_type') == 'dfile_attachment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('file_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_name');
			} else if ($this->input->post('file_description') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_file_description');
			}
			$description = $this->input->post('file_description');
			$file_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'task_id' => $this->input->post('c_task_id'),
				'upload_by' => $this->input->post('user_id'),
				'file_title' => $this->input->post('file_name'),
				'file_description' => $file_description,
				'attachment_file' => $this->input->post('attachment'),
				'created_at' => date('d-m-Y h:i:s')
			);
			$result = $this->Timesheet_model->add_new_attachment($data);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_task_att_added');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// attachment list
	public function attachment_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		//$id = $this->input->get('ticket_id');
		$id = $this->uri->segment(4);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/task_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$attachments = $this->Timesheet_model->get_attachments($id);
		if ($attachments->num_rows() > 0) {
			$data = array();

			foreach ($attachments->result() as $r) {

				$data[] = array(
					'<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_download') . '"><a href="' . site_url() . 'admin/download?type=task&filename=' . $r->attachment_file . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="oi oi-cloud-download"></span></button></a></span><span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete-file" data-toggle="modal" data-target=".delete-modal-file" data-record-id="' . $r->task_attachment_id . '"><span class="fas fa-trash-restore"></span></button></span>',
					$r->file_title,
					$r->file_description,
					$r->created_at
				);
			}

			$output = array(
				"draw" => $draw,
				"recordsTotal" => $attachments->num_rows(),
				"recordsFiltered" => $attachments->num_rows(),
				"data" => $data
			);
		} else {
			$data[] = array('', '', '', '');


			$output = array(
				"draw" => $draw,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => $data
			);
		}
		echo json_encode($output);
		exit();
	}

	// delete task attachment
	public function attachment_delete()
	{
		if ($this->input->post('data') == 'task_attachment') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_attachment_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_task_att_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	// daily attendance list > timesheet
	public function attendance_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if (!empty($session)) {
			$this->load->view("admin/timesheet/attendance_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$attendance_date = $this->input->get("attendance_date");
		$ref_location_id = $this->input->get("location_id");
		$today = $this->input->get("today");
		$yesterday = $this->input->get("yesterday");
		//var_dump($yesterday);die;
		if ($this->input->get("today") != '' && $today != '' && $today != 'undefined' && $today != 'null' && $today != 'NULL' && $today != NULL && $today != null) {

			$employee = $this->Employees_model->get_attendance_today_employees($today);
			//  	var_dump($employee->result());exit();
		} elseif ($this->input->get("yesterday") != '' && $yesterday != '' && $yesterday != 'undefined' && $yesterday != 'null' && $yesterday != 'NULL' && $yesterday != NULL && $yesterday != null) {

			$employee = $this->Employees_model->get_attendance_yesterday_employees($yesterday);
		} elseif ($user_info[0]->user_role_id == 1 || in_array('219', $role_resources_ids)) {
			if ($ref_location_id == 0) {
				//   var_dump('1');
				$employee = $this->Employees_model->get_attendance_employees();
				// 	print_r($employee);
			} else {
				//var_dump('2');
				$employee = $this->Employees_model->get_attendance_location_employees($ref_location_id);
			}
		} else {
			if (in_array('220', $role_resources_ids)) {
				//var_dump('3');
				$employee = $this->Xin_model->get_company_employees($user_info[0]->company_id);
			} else {
				//var_dump('4');
				$employee = $this->Xin_model->read_employee_info_att($session['user_id']);
			}
		}

		$system = $this->Xin_model->read_setting_info(1);
		$data = array();
		// print_r($employee->result());exit;
		foreach ($employee->result() as $r) {
			$employee_id = $r->user_id;

			if ($r->user_role_id == 1) {
				continue;
			}

			$full_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			$company = $this->Xin_model->read_company_info($r->company_id);

			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '';
			}

			$employee_details = '<strong class="text-nowrap">' . $full_name . '</strong>';
			$employee_details .= '<br>';
			$employee_details .= '<span class="text-muted small text-truncate">' . $r->employee_id . '</span>';
			$employee_details .= '<br>';
			$employee_details .= '<span class="text-muted small text-nowrap">' . $comp_name . '</span>';

			$tdate = $attendance_date;
			$clkIn = $clkOut = $attendance_date;
			$clkInLast = $clkOutLast = '-';
			$clockInFirst = $clockOutLast = '-';
			$status = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('attendance_date', $attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {
				foreach ($attendance->result() as $att) {
					if ($clockInFirst == '-') {
						if ($att->clock_in_time != '00:00' && $att->clock_in_time != '')
							$clockInFirst = $att->clock_in_time;
					}

					if ($att->clock_out_time != '00:00' && $att->clock_out_time != '') {
						$clockOutLast = $att->clock_out_time;
					}

					if ($att->clock_in_time != '00:00' && $att->clock_out_time != '00:00') {
						$status = $att->attendance_status;
					}
				}
			}

			$total_time_l = '-';
			$total_time_e = '-';
			$overtime2 = '-';
			$total_work = '-';
			$Trest = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('date', $attendance_date);
			$totals = $this->db->get('xin_attendance_time_total');

			if ($totals->num_rows() > 0) {
				foreach ($totals->result() as $total) {
					$total_time_l = $total->late;
					$total_time_e = $total->early_leaving;
					$overtime2 = $total->overtime;
					$total_work = $total->work;
					$Trest = $total->rest;
				}
			} else {
				$status = $this->Misc_model->get_leave_status($employee_id, $attendance_date, $attendance_date, $attendance_date, 'Absent');
			}

			if ($status == 'Present') {
				$status = $this->Misc_model->get_leave_status($employee_id, $attendance_date, $attendance_date, $attendance_date, 'Present');
			}

			$week_day = date('l', strtotime($attendance_date));
			$week_day_lower = strtolower($week_day);

			$table_field = $week_day_lower . '_in_time';
			$this->db->where('company_id', $r->company_id);
			$office_shift = $this->db->get('xin_office_shift')->row();

			if ($office_shift) {
				if (trim($office_shift->$table_field) == '') {
					$status = 'Holiday';
				}
			}

			if ($clockInFirst != '-')
				$clockInFirst = $this->Misc_model->time_24_to_12($clockInFirst);
			if ($clockOutLast != '-')
				$clockOutLast = $this->Misc_model->time_24_to_12($clockOutLast);

			$data[] = array(
				$employee_details,
				'<span class="text-nowrap">' . $tdate . '</span>',
				$status,
				'<span class="text-nowrap">' . $clockInFirst . '</span>',
				'<span class="text-nowrap">' . $clockOutLast . '</span>',
				$total_time_l,
				$total_time_e,
				$overtime2,
				$total_work,
				$Trest
			);
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// get company > employees
	public function get_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > employees
	public function get_leave_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/get_leave_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > employees leave
	public function get_employees_leave()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}

		$leave_type_id = $this->uri->segment(4);
		$employee_id = $this->uri->segment(5);

		$remaining_leave = $this->Timesheet_model->count_total_leaves($leave_type_id, $employee_id);
		$type = $this->Timesheet_model->read_leave_type_information($leave_type_id);
		if (!is_null($type)) {
			$type_name = $type[0]->type_name;
			$total = $type[0]->days_per_year;
			$leave_remaining_total = $total - $remaining_leave;
		} else {
			$type_name = '--';
			$leave_remaining_total = 0;
		}
		ob_start();
		echo $leave_remaining_total . " " . $type_name . ' ' . $this->lang->line('xin_remaining');
		ob_end_flush();
	}

	// get employee assigned leave types
	public function get_employee_assigned_leave_types()
	{

		$data['title'] = $this->Xin_model->site_title();
		$employee_id = $this->uri->segment(4);

		$data = array(
			'employee_id' => $employee_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/get_employee_assigned_leave_types", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > projects
	public function get_company_project()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_project", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > employees
	public function get_company_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > locations
	public function get_company_locations()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_locations", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_company_locs()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_locs", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_company_locations_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_locations_lists", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	/// multiple
	public function get_company_multiple_locations_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_multiple_locations", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_company_location_multiple_employees_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_multiple_employees_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	/// End

	// get company > locations > employees /
	public function get_company_location_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}


	// get company > locations > employees /
	public function get_company_location_exit_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_exit_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_company_loc_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_loc_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}


	public function get_company_location_employee_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_employee_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > locations > employees / Multiple
	public function get_company_location_multiple_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_multiple_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > locations > assign employees / Multiple
	public function get_company_location_assign_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_assign_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	public function get_company_location_assign_employee_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		$company_id = $this->uri->segment(5);
		$data = array(
			'location_id' => $id,
			'company_id' => $company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/tasks/get_company_location_assign_employee_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > employees
	public function get_update_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/get_update_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > employees
	public function get_cal_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/get_update_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// get company > employees
	public function get_timesheet_employees()
	{

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);

		$data = array(
			'company_id' => $id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/get_timesheet_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	}

	// daily attendance list > timesheet
	public function dtwise_attendance_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/attendance_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$employee = $this->Xin_model->read_user_attendance_info();

		$data = array();

		foreach ($employee->result() as $r) {
			$data[] = array('', '', '', '', '', '', '', '', '', '', '');
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $employee->num_rows(),
			"recordsFiltered" => $employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// date wise attendance list > timesheet
	public function date_wise_list()
	{
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		if (!empty($session)) {
			$this->load->view("admin/timesheet/date_wise", $data);
		} else {
			redirect('admin/');
		}

		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();

		if (in_array('381', $role_resources_ids) && $user_info[0]->user_role_id != 1) {
			$employee_id = $this->input->get("user_id");
		} else if ($user_info[0]->user_role_id != 1) {
			$employee_id = $session['user_id'];
		} else {
			$employee_id = $this->input->get("user_id");
		}

		$system = $this->Xin_model->read_setting_info(1);
		$employee = $this->Xin_model->read_user_info($employee_id);
		// print_r($employee_id);exit;
		// user full name
		$full_name = $employee[0]->first_name . ' ' . $employee[0]->middle_name . ' ' . $employee[0]->last_name;

		// get company
		$company = $this->Xin_model->read_company_info($employee[0]->company_id);
		if (!is_null($company)) {
			$comp_name = $company[0]->name;
		} else {
			$comp_name = '';
		}

		$employee_details = '<strong class="text-nowrap">' . $full_name . '</strong>';
		$employee_details .= '<br>';
		$employee_details .= '<span class="text-muted small text-truncate">' . $employee[0]->employee_id . '</span>';
		$employee_details .= '<br>';
		$employee_details .= '<span class="text-muted small text-nowrap">' . $comp_name . '</span>';

		$start_date = new DateTime($this->input->get("start_date"));
		$end_date = new DateTime($this->input->get("end_date"));
		$end_date = $end_date->modify('+1 day');

		$interval_re = new DateInterval('P1D');
		$date_range = new DatePeriod($start_date, $interval_re, $end_date);
		$attendance_arr = array();

		$data = array();
		foreach ($date_range as $date) {
			$attendance_date = $date->format("Y-m-d");

			$tdate = $attendance_date;
			$clkIn = $clkOut = $attendance_date;
			$clkInLast = $clkOutLast = '-';
			$status = '-';
			$clockInFirst = $clockOutLast = '-';

			$this->db->where('employee_id', $employee_id);
			$this->db->where('attendance_date', $attendance_date);
			$this->db->order_by('time_attendance_id', 'asc');
			$attendance = $this->db->get('xin_attendance_time');

			if ($attendance->num_rows() > 0) {
				foreach ($attendance->result() as $att) {
					if ($clockInFirst == '-') {
						if ($att->clock_in_time != '00:00' && $att->clock_in_time != '')
							$clockInFirst = $att->clock_in_time;
					}

					if ($att->clock_out_time != '00:00' && $att->clock_out_time != '') {
						$clockOutLast = $att->clock_out_time;
					}

					if ($att->clock_in_time != '00:00' && $att->clock_out_time != '00:00') {
						$status = $att->attendance_status;
					}
				}
			}

			$total_time_l = '-';
			$total_time_e = '-';
			$overtime2 = '-';
			$total_work = '-';
			$Trest = '-';

			$this->db->where('employee_id', $employee[0]->user_id);
			$this->db->where('date', $attendance_date);
			$totals = $this->db->get('xin_attendance_time_total');

			if ($totals->num_rows() > 0) {
				foreach ($totals->result() as $total) {
					$total_time_l = $total->late;
					$total_time_e = $total->early_leaving;
					$overtime2 = $total->overtime;
					$total_work = $total->work;
					$Trest = $total->rest;
				}
			} else {
				$status = $this->Misc_model->get_leave_status($employee_id, $attendance_date, $this->input->get("start_date"), $this->input->get("end_date"), 'Absent');
			}

			if ($status == 'Present') {
				$status = $this->Misc_model->get_leave_status($employee_id, $attendance_date, $this->input->get("start_date"), $this->input->get("end_date"), 'Present');
			}

			$week_day = date('l', strtotime($attendance_date));
			$week_day_lower = strtolower($week_day);

			$table_field = $week_day_lower . '_in_time';
			$this->db->where('company_id', $employee[0]->company_id);
			$office_shift = $this->db->get('xin_office_shift')->row();

			if ($office_shift) {
				if (trim($office_shift->$table_field) == '') {
					$status = 'Holiday';
				}
			}

			if ($status == 'Leave' || $status == 'Absent') {
				$clkInLast = $clkOutLast = '-';
			}

			if ($clockInFirst != '-')
				$clockInFirst = $this->Misc_model->time_24_to_12($clockInFirst);
			if ($clockOutLast != '-')
				$clockOutLast = $this->Misc_model->time_24_to_12($clockOutLast);

			$data[] = array(
				$employee_details,
				'<span class="text-nowrap">' . $tdate . '</span>',
				$status,
				'<span class="text-nowrap">' . $clockInFirst . '</span>',
				'<span class="text-nowrap">' . $clockOutLast . '</span>',
				$total_time_l,
				$total_time_e,
				$overtime2,
				$total_work,
				$Trest
			);
		}

		$output = array(
			"draw" => $draw,
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// update_attendance_list > timesheet
	public function update_attendance_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		// get date
		$attendance_date = $this->input->get("attendance_date");
		// get employee id
		$employee_id = $this->input->get("employee_id");
		/*// get user info >
		$user = $this->xin_model->read_user_info($employee_id);
		// user full name
		$full_name = $user[0]->first_name.' '.$user[0]->last_name;
		// get designation
		$designation = $this->designation_model->read_designation_information($user[0]->designation_id);
		// department
		$department = $this->department_model->read_department_information($user[0]->department_id);

		$dept_des = $designation[0]->designation_name.' in '.$department[0]->department_name;
		$employee_name = $full_name.' ('.$dept_des.')';
		$data = array(
				'employee_name' => $employee_name,
				//'employee_id' => $result[0]->employee_id,
				);*/
		if (!empty($session)) {
			$this->load->view("admin/timesheet/update_attendance", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$attendance_employee = $this->Timesheet_model->attendance_employee_with_date($employee_id, $attendance_date);
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();

		foreach ($attendance_employee->result() as $r) {

			// total work

			// attendance date
			$att_date_in = explode(' ', $r->clock_in); //print_r($att_date_in);
			$att_date_out = explode(' ', $r->clock_out);

			if (isset($att_date_in[1]) && isset($att_date_out[1])) {
				$in_time = new DateTime($r->clock_in);
				$out_time = new DateTime($r->clock_out);
				$clock_in = $in_time->format('h:i a');
				$cidate = $this->Xin_model->set_date_format($att_date_in[0]);
				$cin_date = $cidate . ' ' . $clock_in;

				$clock_out = $out_time->format('h:i a');
				$interval = $in_time->diff($out_time);
				$hours = $interval->format('%h');
				$minutes = $interval->format('%i');
				$total_time = $hours . "h " . $minutes . "m";
				$codate = $this->Xin_model->set_date_format($att_date_out[0]);
				$cout_date = $codate . ' ' . $clock_out;
			} elseif (isset($att_date_in[1]) && isset($att_date_out[1])) {
				$cidate = $this->Xin_model->set_date_format($att_date_in[0]);
				$in_time = new DateTime($r->clock_in);
				$clock_in = $in_time->format('h:i a');
				$cin_date = $cidate . ' ' . $clock_in;
				$cout_date = '';
				$total_time = '';
			} elseif (isset($att_date_in[1]) && isset($att_date_out[1])) {
				$codate = $this->Xin_model->set_date_format($att_date_out[0]);
				$out_time = new DateTime($r->clock_out);
				$clock_out = $out_time->format('h:i a');
				$cin_date = '';
				$cout_date = $codate . ' ' . $clock_out;
				$total_time = '';
			}
			if (in_array('225', $role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-attendance_id="' . $r->time_attendance_id . '"><i class="fas fa-pencil-alt"></i></button></span>';
			} else {
				$edit = '';
			}
			if (in_array('226', $role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->time_attendance_id . '"><i class="fas fa-trash-restore"></i></button></span>';
			} else {
				$delete = '';
			}

			$combhr = $edit . $delete;

			if (in_array('225', $role_resources_ids) || in_array('226', $role_resources_ids)) {
				$data[] = array(
					$cin_date,
					$cout_date,
					$total_time,
					$combhr,
				);
			} else {
				$data[] = array(
					$cin_date,
					$cout_date,
					$total_time
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $attendance_employee->num_rows(),
			"recordsFiltered" => $attendance_employee->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// update_attendance_list > timesheet
	public function office_shift_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/office_shift", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));


		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($user_info[0]->user_role_id == 1) {
			$office_shift = $this->Timesheet_model->get_office_shifts();
		} else {
			if (in_array('677', $role_resources_ids)) {
				$office_shift = $this->Timesheet_model->get_company_shifts($user_info[0]->company_id);
			} else {
				$office_shift = $this->Xin_model->get_employee_shift_office($user_info[0]->office_shift_id);
			}
		}
		$data = array();

		foreach ($office_shift->result() as $r) {

			/* get Office Shift info*/
			$monday_in_time = new DateTime($r->monday_in_time);
			$monday_out_time = new DateTime($r->monday_out_time);
			$tuesday_in_time = new DateTime($r->tuesday_in_time);
			$tuesday_out_time = new DateTime($r->tuesday_out_time);
			$wednesday_in_time = new DateTime($r->wednesday_in_time);
			$wednesday_out_time = new DateTime($r->wednesday_out_time);
			$thursday_in_time = new DateTime($r->thursday_in_time);
			$thursday_out_time = new DateTime($r->thursday_out_time);
			$friday_in_time = new DateTime($r->friday_in_time);
			$friday_out_time = new DateTime($r->friday_out_time);
			$saturday_in_time = new DateTime($r->saturday_in_time);
			$saturday_out_time = new DateTime($r->saturday_out_time);
			$sunday_in_time = new DateTime($r->sunday_in_time);
			$sunday_out_time = new DateTime($r->sunday_out_time);

			if ($r->monday_in_time == '') {
				$monday = '-';
			} else {
				$monday = $monday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $monday_out_time->format('h:i a');
			}
			if ($r->tuesday_in_time == '') {
				$tuesday = '-';
			} else {
				$tuesday = $tuesday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $tuesday_out_time->format('h:i a');
			}
			if ($r->wednesday_in_time == '') {
				$wednesday = '-';
			} else {
				$wednesday = $wednesday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $wednesday_out_time->format('h:i a');
			}
			if ($r->thursday_in_time == '') {
				$thursday = '-';
			} else {
				$thursday = $thursday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $thursday_out_time->format('h:i a');
			}
			if ($r->friday_in_time == '') {
				$friday = '-';
			} else {
				$friday = $friday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $friday_out_time->format('h:i a');
			}
			if ($r->saturday_in_time == '') {
				$saturday = '-';
			} else {
				$saturday = $saturday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $saturday_out_time->format('h:i a');
			}
			if ($r->sunday_in_time == '') {
				$sunday = '-';
			} else {
				$sunday = $sunday_in_time->format('h:i a') . ' ' . $this->lang->line('dashboard_to') . ' ' . $sunday_out_time->format('h:i a');
			}

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			if (in_array('674', $role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-office_shift_id="' . $r->office_shift_id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if (in_array('675', $role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->office_shift_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			$functions = '';
			if ($r->default_shift == '' || $r->default_shift == 0) {
				if (in_array('676', $role_resources_ids)) { // default
					$functions = '<span data-toggle="tooltip" data-state="primary" data-placement="top" title="' . $this->lang->line('xin_make_default') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light default-shift" data-office_shift_id="' . $r->office_shift_id . '"><span class="ion ion-md-timer"></span></button></span>';
				} else {
					$functions = '';
				}
			} else {
				$functions = '';
			}
			$combhr = $edit . $functions . $delete;

			if ($r->default_shift == 1) {
				$success = '<span class="badge badge-success">' . $this->lang->line('xin_default') . '</span>';
			} else {
				$success = '';
			}

			if (in_array('674', $role_resources_ids) || in_array('675', $role_resources_ids) || in_array('676', $role_resources_ids)) {
				$data[] = array(
					$r->office_shift_id,
					$comp_name,
					$r->shift_name . ' ' . $success,
					$monday,
					$tuesday,
					$wednesday,
					$thursday,
					$friday,
					$saturday,
					$sunday,
					$combhr
				);
			} else {
				$data[] = array(
					$r->office_shift_id,
					$comp_name,
					$r->shift_name . ' ' . $success,
					$monday,
					$tuesday,
					$wednesday,
					$thursday,
					$friday,
					$saturday,
					$sunday
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $office_shift->num_rows(),
			"recordsFiltered" => $office_shift->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// holidays_list > timesheet
	public function holidays_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/holidays", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("status") == 'all') {
				$holidays = $this->Timesheet_model->get_holidays();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("status") == 'all') {
				$holidays = $this->Timesheet_model->filter_company_holidays($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("status") != 'all') {
				$holidays = $this->Timesheet_model->filter_company_publish_holidays($this->input->get("company_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") == 0 && $this->input->get("status") != 'all') {
				$holidays = $this->Timesheet_model->filter_notcompany_publish_holidays($this->input->get("status"));
			}
		} else {
			if ($user_info[0]->user_role_id == 1 || in_array('422', $role_resources_ids)) {
				$holidays = $this->Timesheet_model->get_holidays();
			} else {
				$holidays = $this->Timesheet_model->get_company_holidays($user_info[0]->company_id);
			}
		}
		$data = array();

		foreach ($holidays->result() as $r) {

			/* get publish/unpublish label*/
			if ($r->is_publish == 1) : $publish = '<span class="badge bg-green">' . $this->lang->line('xin_published') . '</span>';
			else : $publish = '<span class="badge bg-orange">' . $this->lang->line('xin_unpublished') . '</span>';
			endif;
			// get start date and end date
			$sdate = $this->Xin_model->set_date_format($r->start_date);
			$edate = $this->Xin_model->set_date_format($r->end_date);
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			if (in_array('420', $role_resources_ids) || in_array('425', $role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-holiday_id="' . $r->holiday_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if (in_array('421', $role_resources_ids) || in_array('426', $role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->holiday_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if (in_array('818', $role_resources_ids) || in_array('427', $role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-holiday_id="' . $r->holiday_id . '"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}
			$combhr = $edit . $view . $delete;
			$ievent_name = $r->event_name . '<br><small class="text-muted"><i>' . $comp_name . '<i></i></i></small><br><small class="text-muted"><i>' . $publish . '<i></i></i></small>';

			if (in_array('420', $role_resources_ids) || in_array('425', $role_resources_ids) || in_array('421', $role_resources_ids) || in_array('426', $role_resources_ids) || in_array('818', $role_resources_ids) || in_array('427', $role_resources_ids)) {
				$data[] = array(
					$r->event_name,
					$sdate,
					$edate,
					$combhr
				);
			} else {
				$data[] = array(
					$r->event_name,
					$sdate,
					$edate,
				);
			}
		}

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $holidays->num_rows(),
			"recordsFiltered" => $holidays->num_rows(),
			"data" => $data
		);
		$output['csrf_hash'] = $this->security->get_csrf_hash();
		echo json_encode($output);
		exit();
	}

	// leave list > timesheet
	public function leave_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->get_leaves();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_leaves($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_employees_leaves($this->input->get("company_id"), $this->input->get("employee_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_leaves_new($this->input->get("company_id"), $this->input->get("employee_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_only_status_leaves($this->input->get("company_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_only_status_leaves($this->input->get("status"));
			}
		} else {
			$view_companies_ids = explode(',', $user_info[0]->view_companies_id);
			/*if ($user_info[0]->user_role_id != 1) {
				$leave = $this->Timesheet_model->get_employee_leaves($session['user_id']);
			} else {*/

			if ($user_info[0]->user_role_id == 1 || in_array('259', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_leaves();
			} else if (in_array('256', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new($user_info[0]->company_id, 'first');
			} else if (in_array('258', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new($user_info[0]->company_id, 'final');
			} else if (in_array('255', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves($user_info[0]->company_id);
			} else {
				$leave = $this->Timesheet_model->get_employee_leaves($session['user_id']);

				//$leave = $this->Timesheet_model->get_leaves();
			}
			/*	}*/
		}

		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			// get start date and end date
			$user = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
			} else {
				$full_name = '--';
				$department_name = '--';
			}

			// get leave type
			$leave_type = $this->Timesheet_model->read_leave_type_information($r->leave_type_id);
			if (!is_null($leave_type)) {
				$type_name = $leave_type[0]->type_name;
			} else {
				$type_name = '--';
			}

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$datetime1 = new DateTime($r->from_date);
			$datetime2 = new DateTime($r->to_date);
			$interval = $datetime1->diff($datetime2);
			if (strtotime($r->from_date) == strtotime($r->to_date)) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$applied_on = $this->Xin_model->set_date_format($r->applied_on);
			/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/

			if ($r->is_half_day == 1) {
				/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $this->lang->line('xin_hr_leave_half_day');*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);
			} else {
				/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);
			}


			$check_unpaid_leaves_exits = $this->Timesheet_model->getNormalUnpaidLeaves($r->leave_id);
			if (!empty($check_unpaid_leaves_exits)) {
				$duration .= '<p style="font-size: 12px;font-style: italic;"><span style="font-size: 12px;font-style: italic;font-weight: 400;color: red;">Note* </span>: The applied leave duration is' . $r->from_date . ' to ' . $check_unpaid_leaves_exits[0]->to_date . '. The allotted leave is ' . $r->allotted_leave . ' so remaining ' . $check_unpaid_leaves_exits[0]->days . ' days move to unpaid leave section.When changed the duration automatically affected to the corresponding unpaid leave section.</p>';
			}

			if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
			elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
			elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
			else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
			endif;

			if ($r->status == 1) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} elseif ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} elseif ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} elseif ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}

			// 		if($r->leave_cancel_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-ban"></i> Leave Cancel Status Pending</span>';
			// 			}
			// 			elseif($r->leave_cancel_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-ban"></i> Leave Cancel Status Approved</span>';
			// 			}
			// 				elseif($r->leave_cancel_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-ban"></i>  Leave Cancel Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			// 				if($r->leave_postpone_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-calendar"></i> Leave Postpone Status Pending</span>';
			// 			}
			// 			elseif($r->leave_postpone_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-calendar"></i> Leave Postpone Status Approved</span>';
			// 			}
			// 				elseif($r->leave_postpone_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-calendar"></i>  Leave Postpone Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			$disable_status_block = false;
			if (
				$user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)
				|| in_array('256', $role_resources_ids) || in_array('257', $role_resources_ids)
			) {
				$disable_status_block = false;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->second_approval > 0 || $r->final_approval || $r->status == 3)
			) {
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval || $r->first_approval < 1
					|| $r->first_approval == 2 || $r->status == 3)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if ($r->status == 2) {
				$disable_status_block = true;
			}

			if ($user_info[0]->user_role_id == 1) {
				$disable_status_block = false;
			}

			if (in_array('252', $role_resources_ids) || in_array('261', $role_resources_ids)) { //edit
				if ($disable_status_block) {
					$edit = '';
				} else {
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
					<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-leave_id="' . $r->leave_id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
				}
			} else {
				$edit = '';
			}

			if (in_array('253', $role_resources_ids) || in_array('262', $role_resources_ids)) { // delete
				if ($disable_status_block) {
					$delete = '';
				} else {
					$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->leave_id . '"><span class="fas fa-trash-restore"></span></button></span>';
				}
			} else {
				$delete = '';
			}
			if (in_array('254', $role_resources_ids) || $user_info[0]->user_role_id == 1 || $reports_to > 0 || in_array('263', $role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/leave_details/id/' . $r->leave_id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {
				$view = '';
			}
			$combhr = $edit . $view . $delete;
			/*$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_reason') . ': ' . $r->reason . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';*/
			if ($r->admin_read == 0 && $user_info[0]->user_role_id == 1) {
				$type_name = '<b>' . $type_name . '</b>';
				$department_name = '<b>' . $department_name . '</b>';
				$full_name = '<b>' . $full_name . '</b>';
				$duration = '<b>' . $duration . '</b>';
				$applied_on = '<b>' . $applied_on . '</b>';
			}

			//   if ((in_array('856', $role_resources_ids)) and ($r->status!=3) ){
			//   if (($r->leave_postpone_status!='Y')and ($r->status==2))
			//   {
			//     $postpone= '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Leave postpone">
			//   <button type="button" class="btn icon-btn btn-sm btn-outline-secondary  waves-effect waves-light" data-toggle="modal" data-target=".leave-request-postpone" data-leave_postpone_id="' . $r->leave_id . '"data-field_type="leave""><span class="fa fa-calendar"></span></button></span>';
			//   }
			//   else
			//   {
			//   $postpone='';
			//   }

			//   if (($r->leave_cancel_status!='Y'))
			//   {
			//   $cancel = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Cancel Leave">
			//   <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light" data-toggle="modal" data-target=".leave-request-cancel" data-leave_c_id="' . $r->leave_id . '"data-field_type="leave""><span class="fa fa-ban"></span></button></span>';

			//   }
			//   else
			//   {
			//   $cancel='';
			//   }

			//   $combhr .= $postpone.$cancel;

			//   }


			if (in_array('252', $role_resources_ids) || in_array('261', $role_resources_ids) || in_array('253', $role_resources_ids) || in_array('262', $role_resources_ids) || in_array('254', $role_resources_ids) || in_array('263', $role_resources_ids)) {
				$data[] = array(
					$type_name,
					$department_name,
					$full_name,
					$status,
					$duration,
					$applied_on,
					$combhr,
				);
			} else {
				$data[] = array(
					$type_name,
					$department_name,
					$full_name,
					$status,
					$duration,
					$applied_on
				);
			}
		}
		$output = array(
			"draw" => $draw,
			// "recordsTotal" => $leave->num_rows(),
			// "recordsFiltered" => $leave->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// my team leave list > timesheet
	public function my_team_leave_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		$leave = $this->Timesheet_model->get_leaves();
		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			$user = $this->Xin_model->read_user_info($r->employee_id);
			if (!empty($user[0]->reports_to)) {
				if ($user[0]->reports_to == $session['user_id']) {
					// get start date and end date
					$user = $this->Xin_model->read_user_info($r->employee_id);
					if (!is_null($user)) {
						$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
						// department
						$department = $this->Department_model->read_department_information($user[0]->department_id);
						if (!is_null($department)) {
							$department_name = $department[0]->department_name;
						} else {
							$department_name = '--';
						}
					} else {
						$full_name = '--';
						$department_name = '--';
					}

					// get leave type
					$leave_type = $this->Timesheet_model->read_leave_type_information($r->leave_type_id);
					if (!is_null($leave_type)) {
						$type_name = $leave_type[0]->type_name;
					} else {
						$type_name = '--';
					}

					// get company
					$company = $this->Xin_model->read_company_info($r->company_id);
					if (!is_null($company)) {
						$comp_name = $company[0]->name;
					} else {
						$comp_name = '--';
					}

					$datetime1 = new DateTime($r->from_date);
					$datetime2 = new DateTime($r->to_date);
					$interval = $datetime1->diff($datetime2);
					if (strtotime($r->from_date) == strtotime($r->to_date)) {
						$no_of_days = 1;
					} else {
						$no_of_days = $interval->format('%a') + 1;
					}
					$applied_on = $this->Xin_model->set_date_format($r->applied_on);
					/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/

					if ($r->is_half_day == 1) {
						$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $this->lang->line('xin_hr_leave_half_day');
					} else {
						$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;
					}

					if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
					elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
					elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
					else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
					endif;


					if (in_array('288', $role_resources_ids)) { //edit
						$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-leave_id="' . $r->leave_id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
					} else {
						$edit = '';
					}
					if (in_array('289', $role_resources_ids)) { // delete
						$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->leave_id . '"><span class="fas fa-trash-restore"></span></button></span>';
					} else {
						$delete = '';
					}
					if (in_array('290', $role_resources_ids) || $reports_to > 0) { //view
						$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/leave_details/id/' . $r->leave_id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-arrow-circle-right"></span></button></a></span>';
					} else {
						$view = '';
					}
					$combhr = $edit . $view . $delete;
					$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_reason') . ': ' . $r->reason . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';

					$data[] = array(
						$combhr,
						$itype_name,
						$department_name,
						$full_name,
						$duration,
						$applied_on
					);
				}
			}
		}
		$output = array(
			"draw" => $draw,
			// "recordsTotal" => $leave->num_rows(),
			// "recordsFiltered" => $leave->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	// add attendance > modal form
	public function update_attendance_add()
	{
		$data['title'] = $this->Xin_model->site_title();
		$employee_id = $this->input->get('employee_id');
		$attendance_date = $this->input->get('attendance_date');
		$data = array(
			'employee_id' => $employee_id,
			'attendance_date' => $attendance_date,
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_attendance', $data);
		} else {
			redirect('admin/');
		}
	}

	// Validate and add info in database
	public function add_task()
	{

		if ($this->input->post('add_type') == 'task') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('task_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_name');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('task_hour') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_hour');
			} else if ($this->input->post('project_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_project_field');
			} else if ($this->input->post('assigned_to') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_assigned_user');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			if ($this->input->post('assigned_to') != '') {
				$assigned_ids = implode(',', $this->input->post('assigned_to'));
			} else {
				$assigned_ids = '';
			}
			// get company name by project id
			$co_info = $this->Project_model->read_project_information($this->input->post('project_id'));

			$data = array(
				'project_id' => $this->input->post('project_id'),
				'company_id' => $this->input->post('company_id'),
				'created_by' => $this->input->post('user_id'),
				'task_name' => $this->input->post('task_name'),
				'assigned_to' => $assigned_ids,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'task_hour' => $this->input->post('task_hour'),
				'task_progress' => '0',
				'is_notify' => '1',
				'description' => $qt_description,
				'created_at' => date('Y-m-d h:i:s')
			);
			$result = $this->Timesheet_model->add_task_record($data);

			if ($result == TRUE) {
				$row = $this->db->select("*")->limit(1)->order_by('task_id', "DESC")->get("xin_tasks")->row();
				$Return['result'] = $this->lang->line('xin_success_task_added');
				$Return['re_last_id'] = $row->task_id;
				// notificaions
				if ($this->input->post('assigned_to')) {
					foreach ($this->input->post('assigned_to') as $p_employee) {
						$nticket_data = array(
							'module_name' => 'tasks',
							'module_id' => $row->task_id,
							'employee_id' => $p_employee,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					}
				}
				//get setting info
				$setting = $this->Xin_model->read_setting_info(1);
				if ($setting[0]->enable_email_notification == 'yes') {

					$this->email->set_mailtype("html");
					$to_email = array();
					if ($this->input->post('assigned_to')) {
						foreach ($this->input->post('assigned_to') as $p_employee) {

							// assigned by
							$user_info = $this->Xin_model->read_user_info($this->input->post('user_id'));
							$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

							// assigned to
							$user_to = $this->Xin_model->read_user_info($p_employee);
							//get company info
							$cinfo = $this->Xin_model->read_company_setting_info(1);
							//get email template
							$template = $this->Xin_model->read_email_template(14);

							$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
							$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

							$message = '
			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
			<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var task_name}", "{var task_assigned_by}"), array($cinfo[0]->company_name, site_url(), $this->input->post('task_name'), $full_name), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

							hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
						}
					}
				}
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function add_project_variation()
	{

		if ($this->input->post('add_type') == 'variation') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('variation_name') === '') {
				$Return['error'] = $this->lang->line('xin_project_variation_title_field_error');
			} else if ($this->input->post('variation_no') === '') {
				$Return['error'] = $this->lang->line('xin_project_variation_field_error');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('variation_hour') === '') {
				$Return['error'] = $this->lang->line('xin_project_variation_hrs_field_error');
			} else if ($this->input->post('project_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_project_field');
			} else if ($this->input->post('assigned_to') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_assigned_user');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$assigned_ids = implode(',', $this->input->post('assigned_to'));
			// get company name by project id
			$co_info = $this->Project_model->read_project_information($this->input->post('project_id'));

			$data = array(
				'project_id' => $this->input->post('project_id'),
				'company_id' => $this->input->post('company_id'),
				'created_by' => $this->input->post('user_id'),
				'variation_name' => $this->input->post('variation_name'),
				'variation_no' => $this->input->post('variation_no'),
				'assigned_to' => $assigned_ids,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'variation_hours' => $this->input->post('variation_hour'),
				'variation_status' => $this->input->post('status'),
				'client_approval' => $this->input->post('client_approval'),
				'description' => $qt_description,
				'created_at' => date('Y-m-d h:i:s')
			);
			$result = $this->Timesheet_model->add_project_variations($data);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_task_added');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function add_leave()
	{

		if ($this->input->post('add_type') == 'leave') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$remarks = $this->input->post('remarks');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$no_of_days_annual_remain = 0;
			/* Server side PHP input validation */
			if ($this->input->post('leave_type') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_field');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			}

			$empid = $this->input->post('employee_id');
			$startdate = $this->input->post('start_date');
			$enddate = $this->input->post('end_date');
			$leave_check = $this->Timesheet_model->emp_leave_duplication_check($empid, $startdate, $enddate);
			if ($leave_check > 0) {
				$Return['error'] = "Employee already applied leave for this date.";
			}


			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			$no_of_days = $interval->format('%a') + 1;
			if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
				$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}

			if ($this->input->post('start_date') != '') {
				//3 month probation calculation
				$date = date('Y-m-d');
				$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));

				$d1 = strtotime($date);
				$d2 = strtotime($joining_date[0]->date_of_joining);
				$totalSecondsDiff = abs($d1 - $d2);
				$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;
				/* if($this->input->post('leave_type')==3 || $this->input->post('leave_type')==4){
    			   if($totalMonthsDiff < 3){
    			       $Return['error'] = 'You are Under Probation Period';
    			  }
    			 }*/
				// 1 year Maternity Leave calculation
				/*if($this->input->post('leave_type')==5){
			if($totalMonthsDiff <=12){
                    $Return['error'] = 'You cannot take Maternity leave it is only applicable after 1 year';
                }
			}*/
				if ($d2 > $st_date) {
					$Return['error'] = 'Start Date should be greater than joining date';
				} elseif ($d2 > $ed_date) {
					$Return['error'] = 'End Date should be greater than joining date';
				}
				//condition for Marriage leave
				$date = date($this->input->post('start_date'));
				$date1 = date_create($date);
				$date2 = date_create($this->input->post('end_date'));
				$diff = date_diff($date1, $date2);
				$day_diff = $diff->format("%a") + 1;
				//             if($this->input->post('leave_type')==6){
				// 			if($day_diff>3){
				// 				 $Return['error'] = "You cannot apply Continuous more than '3' days.";
				// 			}
				//           }
				//$user_info_all = $this->Employees_model->read_employee_information($this->input->post('employee_id'));
				$eremaining_leave = 0; //$user_info_all[0]->leave_days;
				//condition for Haj leave
				/*$date1 = strtotime("2016-06-01");
            $date2 = strtotime("2021-09-21"); */

				$date1 = strtotime($joining_date[0]->date_of_joining);
				$date2 = strtotime(date('Y-m-d'));
				$diff = abs($date2 - $date1);
				$years = floor($diff / (365 * 60 * 60 * 24));
				//  print_r($years);exit;
				//print_r($joining_date[0]->ethnicity_type);exit;
				if ($this->input->post('leave_type') == 8) {
					if ($joining_date[0]->ethnicity_type == 2) {
						/*if($years<=5){
			            $Return['error'] = 'You cannot take Haj leave it is only applicable after 5 year';
			           if($day_diff>14){
								$Return['error'] = "You cannot apply Continuous more than 14 days.";
						}
			        }*/
					} else {
						$Return['error'] = "Only Muslim Can Apply for this leave";
					}
				}


				$count_l = 0;
				$leave_halfday_cal = employee_leave_halfday_cal($this->input->post('leave_type'), $this->input->post('employee_id'));
				foreach ($leave_halfday_cal as $lhalfday) :
					$count_l += 0.5;
				endforeach;

				$remaining_leave = count_leaves_info($this->input->post('leave_type'), $this->input->post('employee_id'));
				$remaining_leave = $remaining_leave - $count_l;

				$type = $this->Timesheet_model->read_leave_type_information($this->input->post('leave_type'));
				if (!is_null($type)) {
					$type_name = $type[0]->type_name;
					$total = $type[0]->days_per_year;
					$leave_remaining_total = $total - $remaining_leave;
				} else {
					$type_name = '--';
					$leave_remaining_total = 0;
				}

				if ($this->input->post('leave_type') == 3 || $this->input->post('leave_type') == 4 || $this->input->post('leave_type') == 5 || $this->input->post('leave_type') == 7) {
					$leave_remaining_total = $leave_remaining_total + $eremaining_leave;
				} else {
					$leave_remaining_total = $leave_remaining_total;
				}

				// 			if($this->input->post('leave_half_day')!=1){
				// 				if($no_of_days > $leave_remaining_total){
				// 					$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan').' '.$this->lang->line('xin_day');
				// 				}
				// 			} else {
				// 				if(0.5 > $leave_remaining_total){
				// 					$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan').' '.$leave_remaining_total.' '.$this->lang->line('xin_hr_contract_days');
				// 				}
				// 			}

				// 			if($leave_remaining_total < 0.4){
				// 				$Return['error'] = $this->lang->line('xin_leave_limit_msg').' '.$this->lang->line('xin_hrsale_leave_quota_completed') .$type_name;
				// 			}

				/*$remaining_leave = count_leaves_info($this->input->post('leave_type'),$this->input->post('employee_id'));
			$type = $this->Timesheet_model->read_leave_type_information($this->input->post('leave_type'));
			if(!is_null($type)){
				$type_name = $type[0]->type_name;
				$total = $type[0]->days_per_year;
				$leave_remaining_total = $total - $remaining_leave;
			} else {
				$type_name = '--';
				$leave_remaining_total = 0;
			}

			if($leave_remaining_total == 0){
				$Return['error'] = $this->lang->line('xin_leave_limit_msg').' '.$this->lang->line('xin_hrsale_leave_quota_completed') .$type_name;
			}*/
			}
			if ($Return['error'] != '') {
				$Return['csrf_hash'] = $this->security->get_csrf_hash();
				$this->output($Return);
			}
			if ($this->input->post('leave_half_day') != 1) {
				$leave_half_day_opt = 0;
			} else {
				$leave_half_day_opt = $this->input->post('leave_half_day');
			}
			// 			if (is_uploaded_file($_FILES['attachment']['tmp_name'])) {
			// 				//checking image type
			// 				$allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif');
			// 				$filename = $_FILES['attachment']['name'];
			// 				$ext = pathinfo($filename, PATHINFO_EXTENSION);

			// 				if (in_array($ext, $allowed)) {
			// 					$tmp_name = $_FILES["attachment"]["tmp_name"];
			// 					$profile = "uploads/leave/";
			// 					$set_img = base_url() . "uploads/leave/";
			// 					// basename() may prevent filesystem traversal attacks;
			// 					// further validation/sanitation of the filename may be appropriate
			// 					$name = basename($_FILES["attachment"]["name"]);
			// 					$newfilename = 'leave_' . round(microtime(true)) . '.' . $ext;
			// 					move_uploaded_file($tmp_name, $profile . $newfilename);
			// 					$fname = $newfilename;
			// 				} else {
			// 					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
			// 				}
			// 			} else {
			// 				$fname = '';
			// 			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			if (strtotime($this->input->post('start_date')) == strtotime($this->input->post('end_date'))) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			/*$aval_leaves = 0;
		$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($this->input->post('employee_id'),$this->input->post('leave_type'));
		if(!empty($check_annual_leave_aval)){
			$aval_leaves = $check_annual_leave_aval[0]->leave_count;
		}
		if($no_of_days > $aval_leaves){
			$no_of_days_annual_remain = $no_of_days - $aval_leaves;
			$no_of_days = $aval_leaves;
			$inc_days = $aval_leaves - 1;
			$next_form_date_ann = date('Y-m-d', strtotime($this->input->post('start_date'). ' + '.$inc_days.' days'));
		}else{
			$next_form_date_ann = $this->input->post('end_date');
		}*/
			//	print_r($no_of_days);exit;
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);

			$data = array(
				'employee_id' => $this->input->post('employee_id'),
				'company_id' => $this->input->post('company_id'),
				'leave_type_id' => $this->input->post('leave_type'),
				'from_date' => $this->input->post('start_date'),
				'to_date' => $this->input->post('end_date'),
				'applied_on' => ($user_info[0]->user_role_id == 1 && $this->input->post('applied_on')) ? $this->input->post('applied_on') : date('Y-m-d h:i:s'),
				'reason' => $this->input->post('reason'),
				'remarks' => $qt_remarks,
				'leave_attachment' => $this->input->post('attachment'),
				'status' => '1',
				'is_notify' => '1',
				'is_half_day' => $leave_half_day_opt,
				'created_at' => date('Y-m-d h:i:s'),
				'days' => $no_of_days,
				//'allotted_leave'=>$aval_leaves
			);
			$result = $this->Timesheet_model->add_leave_record_new($data);
			$hlfcounts = 0;
			$count_ls = 0;
			$leaves_id = $this->input->post('leave_type');
			$employees_id = $this->input->post('employee_id');
			$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
			$count = $xin_leave_type[0]->leave_count;
			$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
			$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
			foreach ($leave_halfday_cals as $lhalfday) :
				$hlfcounts += 0.5;
			endforeach;
			$count_ls = count_leaves_info($leaves_id, $employees_id);
			// $count_1=
			$count_ls = $count_ls - $hlfcounts;
			$va = $count_leave_type[0]->days_per_year;
			$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
			$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
			//$total =$type[0]->days_per_year;
			$total = $emp_leaves_data[0]->leave_count;
			$leave_remaining_total = $total - $count_ls;
			$c = $count - $va;
			$re = $total - $count_ls;
			if ($leave_remaining_total == 0) {
				$lr = 0;
				$hr = 0;
			} elseif ($leave_remaining_total < $count_ls) {
				$lr = 0;
				$hr = $c;
			} else {
				$lr = $leave_remaining_total;
				$hr = 0;
			}
			/* $this->db->where('employee_id', $employees_id);
			 $this->db->where('leave_type_id', $leaves_id);
			 //$this->db->where('create_date', date('Y-m-d'));
			 $result = $this->db->get('carry_leaves');
			// print_r($result);exit;
			 if ($result->num_rows() == 0) {
			     $data_insert=array(
			         'employee_id'=>$employees_id,
			         'leave_type_id'=>$leaves_id,
			         'remaing_leave_count'=>$leave_remaining_total,
			         'create_date'=> date('Y-m-d'));
			         $data_result=$this->Timesheet_model->carry_insert($data_insert);
			 } else {
			     $carry_leave =  $result->result();//print_r($carry_leave);exit;
			     $data_update=array(
			         'employee_id'=>$employees_id,
			         'leave_type_id'=>$leaves_id,
			         'remaing_leave_count'=>$leave_remaining_total,
			         'create_date'=> date('Y-m-d'));
			         $data_result=$this->Timesheet_model->carry_update($data_update,$carry_leave[0]->id);
			 }
		*/

			if ($result) {
				/*if($no_of_days_annual_remain > 0){
				$next_form_date = date('Y-m-d', strtotime($this->input->post('start_date'). ' + '.$aval_leaves.' days'));
				$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
				if(!empty($checl_already_exists_annual)){
					$data = array(
						'from_date' => $next_form_date,
						'to_date' => $this->input->post('end_date'),
						'reason' => $qt_remarks,
						'remarks' => $qt_remarks,
						'status' => '1',
						'is_notify' => '1',
						'days' => $no_of_days_annual_remain,
						'leave_unpaid_auto'=>$result
						);
					$result = $this->Timesheet_model->update_leave_record($data,$checl_already_exists_annual[0]->leave_id);
				}else{
					 $data = array(
					   'employee_id' =>$this->input->post('employee_id'),
					   'company_id' =>$this->input->post('company_id'),
					   'leave_type_id' => 7,
					   'from_date' => $next_form_date,
					   'to_date' => $this->input->post('end_date'),
					   'applied_on' => date('Y-m-d h:i:s'),
					   'reason' => $qt_remarks,
					   'remarks' => $qt_remarks,
					   'status' => '1',
					   'is_notify' => '1',
					   'created_at' => date('Y-m-d h:i:s'),
					   'days' => $no_of_days_annual_remain,
					   'leave_unpaid_auto'=>$result
					   );
					   $result = $this->Timesheet_model->add_leave_record($data);
				}
			 }*/
				$row = $this->db->select("*")->limit(1)->order_by('leave_id', "DESC")->get("xin_leave_applications")->row();
				$Return['result'] = $this->lang->line('xin_success_leave_added');
				// get leave type
				$leave_type = $this->Timesheet_model->read_leave_type_information($row->leave_type_id);
				if (!is_null($leave_type)) {
					$type_name = $leave_type[0]->type_name;
				} else {
					$type_name = '--';
				}
				$Return['re_last_id'] = $row->leave_id;
				$Return['lv_type_name'] = $type_name;
				// notificaions
				$get_corresponind_emp = $this->Xin_model->all_user_for_expiry_notify(1);
				if ($get_corresponind_emp) {
					foreach ($get_corresponind_emp as $emp_det) {
						$nticket_data = array(
							'module_name' => 'leave',
							'module_id' => $row->leave_id,
							'employee_id' => $emp_det->user_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					}
				}

				//get setting info
				$setting = $this->Xin_model->read_setting_info(1);
				if ($setting[0]->enable_email_notification == 'yes') {

					$this->email->set_mailtype("html");
					//get company info
					$cinfo = $this->Xin_model->read_company_setting_info(1);
					//get email template
					$template = $this->Xin_model->read_email_template(5);
					//get employee info
					$user_info = $this->Xin_model->read_user_info($this->input->post('employee_id'));
					$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;
					//get reports to
					$reports_to = $this->Xin_model->read_user_info($user_info[0]->reports_to);

					$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
					$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

					$message = '
			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
			<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var employee_name}"), array($cinfo[0]->company_name, site_url(), $full_name), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
					if (!is_null($reports_to)) {
						hrsale_mail($user_info[0]->email, $full_name, $reports_to[0]->email, $subject, $message);
					} else {
						hrsale_mail($user_info[0]->email, $full_name, $cinfo[0]->email, $subject, $message);
					}
				}
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function add_attendance_validate()
	{
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();

		/* Server side PHP input validation */
		if ($this->input->post('attendance_date_m') === '') {
			$Return['error'] = "Attendance Date is required";
		} else if ($this->input->post('clock_in_m') === '') {
			$Return['error'] = "Office In Time is required";
		} else if ($this->input->post('clock_out_m') === '') {
			$Return['error'] = "Office Out Time is required";
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$this->output($Return);
		exit;
	}

	public function add_attendance()
	{

		if ($this->input->post('add_type') == 'attendance') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('attendance_date_m') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_date');
			} else if ($this->input->post('clock_in_m') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_in_time');
			} else if ($this->input->post('clock_out_m') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_out_time');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$user_id = $this->input->post('employee_id_m');
			$attendance_date = $this->input->post('attendance_date_m');
			$clock_in = $this->input->post('clock_in_m');
			// $clock_in_date = $this->input->post('clock_in_date');
			$clock_out = $this->input->post('clock_out_m');
			// $clock_out_date = $this->input->post('clock_out_date');

			/*$attendance_date_new = $attendance_date;
      if ($this->Misc_model->hm2sec($clock_in) > $this->Misc_model->hm2sec($clock_out)) {
        $new_date = new DateTime($attendance_date);
        $new_date->modify('+1 day');
        $attendance_date_new = $new_date->format('Y-m-d');
      }*/

			$clock_in2 = $clock_in; // $clock_in_date . ' ' . $clock_in . ':00';
			$clock_out2 = $clock_out; // $clock_out_date . ' ' . $clock_out . ':00';

			//total work
			$total_work_cin = new DateTime($clock_in2);
			$total_work_cout = new DateTime($clock_out2);

			$interval_cin = $total_work_cout->diff($total_work_cin);
			$hours_in = $interval_cin->format('%h');
			$minutes_in = $interval_cin->format('%i');
			$total_work = $hours_in . ":" . $minutes_in;
			$work_mins_to_hour = round($minutes_in / 60, 2);
			$work_by_hours = $hours_in + $work_mins_to_hour;
			global $holiday_check;
			global $weekends;

			$user = $this->Employees_model->read_user_by_user_id($user_id);
			$comp_id = $user[0]->company_id;
			$holidays = $this->Employees_model->get_holidays($comp_id);

			if (isset($holidays)) {
				foreach ($holidays as $row) {
					$startDate = $row->start_date;
					$endDate = $row->end_date;

					if (($attendance_date >= $startDate) && ($attendance_date <= $endDate)) {
						$holiday_check = "yes";
					}
				}
			}

			if ($user[0]->office_shift_id == 0) {
				$late_allowed = $this->Office_shift_custom_model->employee_current_shift($user[0]->user_id, $attendance_date);
				if ($late_allowed) {
					$day = date('j', strtotime($attendance_date));
					$in_time = $day . "_in";
					if (!empty($late_allowed[$in_time])) {
						$late_by_hours = 0;
						$late_deduct = 0;
					} else {
						$on_duty3 = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' . $late_allowed['late_allowed_till'] . "mins"));
						if ($holiday_check !== "yes") {
							$attendence_check = $this->Employees_model->check_first_attendance($user[0]->user_id, $attendance_date);
							$work_clkin = new DateTime($clock_in2);
							$work_on_duty = new DateTime($on_duty3);
							$clkin_diff = strtotime($clock_in2) - strtotime($on_duty3);
							$interval_clkin = $work_clkin->diff($work_on_duty);
							$hoursin = $interval_clkin->format('%h');
							$minutesin = $interval_clkin->format('%i');
							$minutes_to_hour = round($minutesin / 60, 2);
							$late_by_hours = $hoursin + $minutes_to_hour;

							if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {
								$basic_sal = $user[0]->basic_salary;
								$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
								$late_deduct = round($latededuction, 3);
							} else {
								$late_by_hours = 0;
								$late_deduct = 0;
							}
						} else {
							$late_by_hours = 0;
							$late_deduct = 0;
						}
					}
				}
			} else {

				$late_allowed = $this->Employees_model->get_lateallowed_foremployee($user[0]->office_shift_id);
				$on_duty3 = $attendance_date . ' ' . $late_allowed[0]->late_allowed_till;

				$timestamp = strtotime($attendance_date);
				$day = date('l', $timestamp);


				// Find week day
				$week_day = date('l', strtotime($attendance_date));
				$week_day_lower = strtolower($week_day);


				// Make Table field. Eg: thursday_out_time
				$table_field_in_time = $week_day_lower . '_in_time';
				$table_field_out_time = $week_day_lower . '_out_time';

				$this->db->where('office_shift_id', $user[0]->office_shift_id);
				$office_shift = $this->db->get('xin_office_shift')->row();

				$shift_start = $office_shift->$table_field_in_time;
				$shift_end = $office_shift->$table_field_out_time;
				if (empty($shift_start)) {
					$weekends = "yes";
				}


				if ($weekends !== "yes" && $holiday_check !== "yes") {
					$attendence_check = $this->Employees_model->check_first_attendance($user[0]->user_id, $attendance_date);
					$work_clkin = new DateTime($clock_in2);
					$work_on_duty = new DateTime($on_duty3);
					$clkin_diff = strtotime($clock_in2) - strtotime($on_duty3);
					$interval_clkin = $work_clkin->diff($work_on_duty);
					$hoursin = $interval_clkin->format('%h');
					$minutesin = $interval_clkin->format('%i');
					$minutes_to_hour = round($minutesin / 60, 2);
					$late_by_hours = $hoursin + $minutes_to_hour;

					if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {
						$basic_sal = $user[0]->basic_salary;
						$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
						$late_deduct = round($latededuction, 3);
					} else {
						$late_by_hours = 0;
						$late_deduct = 0;
					}
				} else {
					$late_by_hours = 0;
					$late_deduct = 0;
				}
			}

			$data = array(
				'employee_id' => $this->input->post('employee_id_m'),
				'attendance_date' => $attendance_date,
				'clock_in' => $clock_in2,
				'clock_in_time' => date('H:i', strtotime($clock_in2)),
				'clock_out' => $clock_out2,
				'clock_out_time' => date('H:i', strtotime($clock_out2)),
				'time_late' => $clock_in2,
				'total_work' => $total_work,
				'early_leaving' => $clock_out2,
				'overtime' => $clock_out2,
				'attendance_status' => 'Present',
				'clock_in_out' => '0',
				'total_work_hours' => $work_by_hours,
				'late_by_hours' => $late_by_hours,
				'late_deduction' => $late_deduct
			);

			// echo '<pre>';print_r($data);exit;
			$result = $this->Timesheet_model->add_employee_attendance($data);

			if ($result == TRUE) {


				$empid = $this->input->post('employee_id_m');
				$user = $this->Employees_model->read_employee_information($empid);

				# NEW: Update totals
				// $late = '00:00';
				// if ($user[0]->late_deduction == 1) {
				$late = $this->Misc_model->find_late1($attendance_date, $empid);
				// }
				$early_leaving_time = $this->Misc_model->find_early_leaving1($attendance_date, $empid);
				$overtime_time = $this->Misc_model->find_overtime1($attendance_date, $empid);
				$rest = $this->Misc_model->find_rest($attendance_date, $empid);
				$work = $this->Misc_model->find_work_total($attendance_date, $empid);


				//overtime calculations start

				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$timeshift_from = $overtime_consts[0]->timeshift_from;
				$timeshift_to = $overtime_consts[0]->timeshift_to;
				$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
				$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
				//global $weekend;


				$normal_ot_secs = 0;
				$extra_ot_secs = 0;

				if ($user[0]->office_shift_id == 0) {
					$month = date('Y-m', strtotime($attendance_date));
					$office_shift = $this->Office_shift_custom_model->employee_current_shift($empid, $month);
					$day = date('j', strtotime($attendance_date));
					$out_time = $day . '_out';

					$shift_end_time = strtotime($office_shift[$out_time]);

					$shift_out_time_seconds = $shift_end_time;

					$normal_ot_end_secs = strtotime($attendance_date . ' 19:00:00');
					$extra_ot_secs = 0;
					$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
					$extra_ot_end_secs = strtotime($attendance_date1 . ' 07:00:00');
					$normal_ot_end_secs_last = strtotime($attendance_date1 . ' 08:00:00');

					$this->db->where('employee_id', $empid);
					$this->db->where('attendance_date', $attendance_date);
					$attendances = $this->db->get('xin_attendance_time');

					$overtime_seconds = 0;

					if ($attendances->num_rows() > 0) {
						foreach ($attendances->result() as $attendance) {

							$clock_in_seconds = strtotime($attendance->clock_in);
							$clock_out_seconds = strtotime($attendance->clock_out);

							if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
								$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

								for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
									if ($i < $normal_ot_end_secs) {
										$normal_ot_secs += 1;
									} else if ($i < $extra_ot_end_secs) {
										$extra_ot_secs += 1;
									} else if ($i < $normal_ot_end_secs_last) {
										$normal_ot_secs += 1;
									}
								}
							} else if ($clock_in_seconds > $shift_out_time_seconds) {
								$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

								for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
									if ($i < $normal_ot_end_secs) {
										$normal_ot_secs += 1;
									} else if ($i < $extra_ot_end_secs) {
										$extra_ot_secs += 1;
									} else if ($i < $normal_ot_end_secs_last) {
										$normal_ot_secs += 1;
									}
								}
							}
						}
					}

					// Deduct late time
					$late_hours = $this->Misc_model->find_late1($attendance_date, $empid);
					$late_seconds = $this->Misc_model->hm2sec($late_hours);

					//$overtime_seconds -= $late_seconds;
					$normal_ot_secs -= $late_seconds;

					if ($normal_ot_secs < 0) {
						$extra_ot_secs -= abs($normal_ot_secs);
						if ($extra_ot_secs < 0)
							$extra_ot_secs = 0;
						$normal_ot_secs = 0;
					}


					//echo $office_shift[$out_time];
					//print_r($office_shift);
				} else {

					// Find week day
					$week_day = date('l', strtotime($attendance_date));
					$week_day_lower = strtolower($week_day);

					// Make Table field. Eg: thursday_out_time
					$table_field_in_time = $week_day_lower . '_in_time';
					$table_field_out_time = $week_day_lower . '_out_time';

					$this->db->where('office_shift_id', $user[0]->office_shift_id);
					$office_shift = $this->db->get('xin_office_shift')->row();

					$shift_start = $office_shift->$table_field_in_time;
					$shift_end = $office_shift->$table_field_out_time;
					if (empty($shift_start)) {
						$weekend = "yes";
					}

					$shift_start_secs = $this->Misc_model->hm2sec($shift_start);
					$shift_end_secs = $this->Misc_model->hm2sec($shift_end);

					$normal_ot_secs = $extra_ot_secs = 0;

					if ($shift_end_secs < $shift_start_secs) {

						// Night shift ends next day
						$shift_end_date = date('Y-m-d', strtotime($attendance_date . " +1 days"));

						$shift_end = "$shift_end_date $shift_end";
						$shift_end_time = strtotime($shift_end);

						$shift_out_time_seconds = $shift_end_time;

						$normal_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_from);
						$extra_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_to);
						$extra_ot_end_secs_last = strtotime($shift_end_date . ' ' . $shift_start);

						$this->db->where('employee_id', $user[0]->user_id);
						$this->db->where('attendance_date', $attendance_date);
						$attendances = $this->db->get('xin_attendance_time');

						if ($attendances->num_rows() > 0) {
							foreach ($attendances->result() as $attendance) {
								$clock_in_seconds = strtotime($attendance->clock_in);
								$clock_out_seconds = strtotime($attendance->clock_out);

								if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
									for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs_last) {
											$extra_ot_secs += 1;
										}
									}
								} else if ($clock_in_seconds > $shift_out_time_seconds) {
									for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs_last) {
											$extra_ot_secs += 1;
										}
									}
								}
							}
						}

						// Deduct late time
						$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
						$late_seconds = $this->Misc_model->hm2sec($late_hours);

						//$overtime_seconds -= $late_seconds;
						$extra_ot_secs -= $late_seconds;

						if ($extra_ot_secs < 0) {
							$normal_ot_secs -= abs($extra_ot_secs);
							if ($normal_ot_secs < 0)
								$normal_ot_secs = 0;

							$extra_ot_secs = 0;
						}
					} else {

						$shift_end = "$attendance_date $shift_end";
						$shift_end_time = strtotime($shift_end);

						$shift_out_time_seconds = $shift_end_time;

						$normal_ot_end_secs = strtotime($attendance_date . ' ' . $timeshift_from);
						$extra_ot_secs = 0;
						$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
						$extra_ot_end_secs = strtotime($attendance_date1 . ' ' . $timeshift_to);
						$normal_ot_end_secs_last = strtotime($attendance_date1 . ' ' . $shift_start);

						$this->db->where('employee_id', $user[0]->user_id);
						$this->db->where('attendance_date', $attendance_date);
						$attendances = $this->db->get('xin_attendance_time');

						$overtime_seconds = 0;

						if ($attendances->num_rows() > 0) {
							foreach ($attendances->result() as $attendance) {
								$clock_in_seconds = strtotime($attendance->clock_in);
								$clock_out_seconds = strtotime($attendance->clock_out);

								if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
									$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

									for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs_last) {
											$normal_ot_secs += 1;
										}
									}
								} else if ($clock_in_seconds > $shift_out_time_seconds) {
									$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

									for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs_last) {
											$normal_ot_secs += 1;
										}
									}
								}
							}
						}

						// Deduct late time
						$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
						$late_seconds = $this->Misc_model->hm2sec($late_hours);

						//$overtime_seconds -= $late_seconds;
						$normal_ot_secs -= $late_seconds;

						if ($normal_ot_secs < 0) {
							$extra_ot_secs -= abs($normal_ot_secs);
							if ($extra_ot_secs < 0)
								$extra_ot_secs = 0;
							$normal_ot_secs = 0;
						}
					}

					//$timestamp = strtotime($attendance_date);
					//$day = date('l', $timestamp);
					/*$comp_id       =  $user[0]->company_id;
        $holidays      =  $this->Employees_model->get_holidays($comp_id);
        $holiday_check = 'no';

        if (isset($holidays)) {
          foreach ($holidays as $row) {
            $startDate     =  $row->start_date;
            $endDate       =  $row->end_date;

            if (($attendance_date >= $startDate) && ($attendance_date <= $endDate)) {
              $holiday_check = "yes";
            }
          }
        }
        if ($weekend === "yes" || $holiday_check === "yes") {
          $ot_seconds  = $this->Misc_model->hm2sec($work);
        } else {
          $ot_seconds  = $this->Misc_model->hm2sec($overtime_time);
        }
        unset($weekend);
        unset($holiday_check);*/
				}
				//overtime calculations end

				// if Holiday, overtime will be total-work
				$day_status_employee = $this->Misc_model->day_status_employee($attendance_date, $empid);
				if (in_array($day_status_employee, array('H', 'PH'))) {
					$overtime_time = $work;
					$extra_ot_secs = $this->Misc_model->hm2sec($overtime_time);
					$normal_ot_secs = 0;
					$late = $early_leaving_time = '00:00';
				}

				$ot_seconds = $this->Misc_model->hm2sec($overtime_time);

				$this->Misc_model->save($attendance_date, $empid, array(
					'late' => $late,
					'early_leaving' => $early_leaving_time,
					'rest' => $rest,
					'overtime' => $overtime_time,
					'work' => $work,
					'ot_seconds' => $ot_seconds,
					'normal_ot_seconds' => $normal_ot_secs,
					'extra_ot_seconds' => $extra_ot_secs
				));
				#-----------------#

				$Return['result'] = $this->lang->line('xin_success_attendance_added');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function add_holiday()
	{

		if ($this->input->post('add_type') == 'holiday') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('event_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_event_name');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'event_name' => $this->input->post('event_name'),
				'company_id' => $this->input->post('company_id'),
				'description' => $qt_description,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'is_publish' => $this->input->post('is_publish'),
				'created_at' => date('Y-m-d')
			);
			$result = $this->Timesheet_model->add_holiday_record($data);

			if ($result == TRUE) {
				$row = $this->db->select("*")->limit(1)->order_by('holiday_id', "DESC")->get("xin_holidays")->row();
				$Return['result'] = $this->lang->line('xin_holiday_added');
				$Return['re_last_id'] = $row->holiday_id;
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function edit_holiday_validate()
	{

		$id = $this->uri->segment(4);
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');
		$description = $this->input->post('description');
		$st_date = strtotime($start_date);
		$ed_date = strtotime($end_date);
		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);


		/* Server side PHP input validation */
		if ($this->input->post('company_id') === '') {
			$Return['error'] = $this->lang->line('error_company_field');
		} else if ($this->input->post('event_name') === '') {
			$Return['error'] = $this->lang->line('xin_error_event_name');
		} else if ($this->input->post('start_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_start_date');
		} else if ($this->input->post('end_date') === '') {
			$Return['error'] = $this->lang->line('xin_error_end_date');
		} else if ($st_date > $ed_date) {
			$Return['error'] = $this->lang->line('xin_error_start_end_date');
		}


		if ($Return['error'] != '') {
			$this->output($Return);
		}
		$this->output($Return);
		exit;

	}

	// Validate and add info in database
	public function edit_holiday()
	{

		if ($this->input->post('edit_type') == 'holiday') {

			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('event_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_event_name');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'event_name' => $this->input->post('event_name'),
				'company_id' => $this->input->post('company_id'),
				'description' => $qt_description,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'is_publish' => $this->input->post('is_publish')
			);

			$result = $this->Timesheet_model->update_holiday_record($data, $id);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_holiday_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function edit_leave_cancel()
	{

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		if ($this->input->post('reason') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
		}


		$id = $this->uri->segment(4);
		$no_of_days_annual_remain = 0;

		$leave_cancel_status = 'Y';
		$leave_cancel_approval = '0';

		$from_date_leave = $this->input->post('from_date_leave');
		$employee_id = $this->input->post('employee_id');
		$postpone_status = $this->input->post('postpone_status');

		$postpone_approval = $this->input->post('postpone_approval');


		if (($postpone_status != 'N') and ($postpone_approval != '2')) {
			$Return['error'] = "Already sent a  request for a leave Postpone.";
		}


		if ($from_date_leave < date('Y-m-d')) {
			$Return['error'] = "Please check the dates";
		}

		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$data = array(
			'leave_cancel_reason' => $this->input->post('reason'),
			'leave_cancel_status' => $leave_cancel_status,
			'leave_cancel_approval' => $leave_cancel_approval,
			'admin_read' => '0',
			'updated_date' => date('Y-m-d')

		);


		if ($this->input->post('leave_type_name') != 'a_leave') {
			$result = $this->Timesheet_model->update_leave_record($data, $id);

			$nticket_data = array(
				'module_name' => 'leave_cancel',
				'module_id' => $id,
				'employee_id' => $employee_id,
				'is_notify' => '1',
				'created_at' => date('d-m-Y h:i:s'),
			);
			$this->Xin_model->add_notifications($nticket_data);
		} else {

			$result = $this->Timesheet_model->update_annualleave_readrecord($data, $id);
			$nticket_data = array(
				'module_name' => 'annual_leave_cancel',
				'module_id' => $id,
				'employee_id' => $employee_id,
				'is_notify' => '1',
				'created_at' => date('d-m-Y h:i:s'),
			);
			$this->Xin_model->add_notifications($nticket_data);
		}

		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_success_leave_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
	}

	// Validate and add info in database
	public function edit_leave_validate()
	{
		$no_of_days_annual_remain = 0;
		if ($this->input->post('edit_type') == 'leave') {

			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			/* Server side PHP input validation */
			if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			$no_of_days = $interval->format('%a') + 1;
			if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
				$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function edit_leave()
	{
		$no_of_days_annual_remain = 0;
		if ($this->input->post('edit_type') == 'leave') {

			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			/* Server side PHP input validation */
			if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			$no_of_days = $interval->format('%a') + 1;
			if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
				$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			if ($this->input->post('start_date') != '') {
				$date = date('Y-m-d');
				$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));

				$d1 = strtotime($date);
				$d2 = strtotime($joining_date[0]->date_of_joining);
				$totalSecondsDiff = abs($d1 - $d2);
				$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

				$date = date($this->input->post('start_date'));
				$date1 = date_create($date);
				$date2 = date_create($this->input->post('end_date'));
				$diff = date_diff($date1, $date2);
				$day_diff = $diff->format("%a") + 1;

				$eremaining_leave = 0;

				$date1 = strtotime($joining_date[0]->date_of_joining);
				$date2 = strtotime(date('Y-m-d'));
				$diff = abs($date2 - $date1);
				$years = floor($diff / (365 * 60 * 60 * 24));
				if ($this->input->post('leave_type') == 8) {
					if ($joining_date[0]->ethnicity_type == 2) {
					} else {
						$Return['error'] = "Only Muslim Can Apply for this leave";
					}
				}
				$count_l = 0;
				$leave_halfday_cal = employee_leave_halfday_cal($this->input->post('leave_type'), $this->input->post('employee_id'));
				foreach ($leave_halfday_cal as $lhalfday) :
					$count_l += 0.5;
				endforeach;

				$remaining_leave = count_leaves_info($this->input->post('leave_type'), $this->input->post('employee_id'));
				$remaining_leave = $remaining_leave - $count_l;

				$type = $this->Timesheet_model->read_leave_type_information($this->input->post('leave_type'));
				if (!is_null($type)) {
					$type_name = $type[0]->type_name;
					$total = $type[0]->days_per_year;
					$leave_remaining_total = $total - $remaining_leave;
				} else {
					$type_name = '--';
					$leave_remaining_total = 0;
				}

				if ($this->input->post('leave_type') == 3 || $this->input->post('leave_type') == 4 || $this->input->post('leave_type') == 5 || $this->input->post('leave_type') == 7) {
					$leave_remaining_total = $leave_remaining_total + $eremaining_leave;
				} else {
					$leave_remaining_total = $leave_remaining_total;
				}
			}
			if ($this->input->post('leave_half_day') != 1) {
				$leave_half_day_opt = 0;
			} else {
				$leave_half_day_opt = $this->input->post('leave_half_day');
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			if (strtotime($this->input->post('start_date')) == strtotime($this->input->post('end_date'))) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$timesheet = $this->Timesheet_model->read_leave_information($id);
			if ($timesheet[0]->status == 2 && $timesheet[0]->leave_type_id != 7) {
				$date_arr = explode("-", $timesheet[0]->from_date);
				$year_check = $date_arr[0];
				$result1 = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
				if ($result1->num_rows() > 0) {
					if ($timesheet[0]->is_half_day == 1) {
						$added_days = 0.5;
					} else {
						$added_days = $timesheet[0]->days;
					}
					$carry_leave1 = $result1->result();
					$leave_remaining_total_dec = abs($carry_leave1[0]->remaing_leave_count) + $added_days;
					$data_update = array(
						'remaing_leave_count' => $leave_remaining_total_dec,
					);
					$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave1[0]->id);
				}
				$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, $timesheet[0]->leave_type_id);
				if (!empty($check_annual_leave_aval)) {
					$aval_leaves = $check_annual_leave_aval[0]->leave_count;
				} else {
					$aval_leaves = 0;
				}
				if ($no_of_days > $aval_leaves) {
					$no_of_days_annual_remain = $no_of_days - $aval_leaves;
					$no_of_days = $aval_leaves;
					$inc_days = $aval_leaves - 1;
					$next_form_date_ann = date('Y-m-d', strtotime($this->input->post('start_date') . ' + ' . $inc_days . ' days'));
					$check_unpaid_leaves_exits = $this->Timesheet_model->getNormalUnpaidLeaves($id);
					if (!empty($check_unpaid_leaves_exits)) {
						$date_arr = explode("-", $check_unpaid_leaves_exits[0]->from_date);
						$year_check = $date_arr[0];
						$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($check_unpaid_leaves_exits[0]->employee_id, $check_unpaid_leaves_exits[0]->leave_type_id, $year_check);
						if ($result->num_rows() > 0) {
							$carry_leave = $result->result();
							$leave_remaining_total_dec = abs($carry_leave[0]->remaing_leave_count) - $check_unpaid_leaves_exits[0]->days;
							$data_update = array(
								'remaing_leave_count' => $leave_remaining_total_dec,
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
					}
				} else {
					$check_unpaid_leaves_exits = $this->Timesheet_model->getNormalUnpaidLeaves($id);
					if (!empty($check_unpaid_leaves_exits)) {
						$date_arr = explode("-", $check_unpaid_leaves_exits[0]->from_date);
						$year_check = $date_arr[0];
						$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($check_unpaid_leaves_exits[0]->employee_id, $check_unpaid_leaves_exits[0]->leave_type_id, $year_check);
						if ($result->num_rows() > 0) {
							$carry_leave = $result->result();
							$leave_remaining_total_dec = abs($carry_leave[0]->remaing_leave_count) - $check_unpaid_leaves_exits[0]->days;
							$data_update = array(
								'remaing_leave_count' => $leave_remaining_total_dec,
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						$remove_unpaid_leaves = $this->Timesheet_model->deleteUnpaidLeavesNormal($id);
					}
					$next_form_date_ann = $this->input->post('end_date');
				}
			} else {
				$date_arr = explode("-", $timesheet[0]->from_date);
				$year_check = $date_arr[0];
				$result2 = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
				if ($result2->num_rows() > 0) {
					$carry_leave2 = $result2->result();
					$leave_remaining_total_dec = abs($carry_leave2[0]->remaing_leave_count) - $timesheet[0]->days;
					$data_update = array(
						'remaing_leave_count' => abs($leave_remaining_total_dec),
					);
					$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave2[0]->id);
				}
				$next_form_date_ann = $this->input->post('end_date');
			}
			$data = array(
				'reason' => $this->input->post('reason'),
				'remarks' => $qt_remarks,
				'from_date' => $this->input->post('start_date'),
				'to_date' => $next_form_date_ann,
				'is_half_day' => $leave_half_day_opt,
				'days' => $no_of_days,
				'leave_cancel_reason' => $this->input->post('Cancel_reason'),
				'leave_postpone_reason' => $this->input->post('postpone_reason'),
				'updated_date' => date('Y-m-d')

			);
			$result = $this->Timesheet_model->update_leave_record($data, $id);

			if ($result == TRUE) {
				if ($no_of_days_annual_remain > 0 && $timesheet[0]->status == 2) {
					$next_form_date = date('Y-m-d', strtotime($this->input->post('start_date') . ' + ' . $aval_leaves . ' days'));
					$checl_already_exists_annual = $this->Timesheet_model->getNormalUnpaidLeaves($id);
					if (!empty($checl_already_exists_annual)) {
						$data = array(
							'from_date' => $next_form_date,
							'to_date' => $this->input->post('end_date'),
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '2',
							'is_notify' => '1',
							'days' => $no_of_days_annual_remain,
							'leave_unpaid_auto' => $timesheet[0]->leave_id,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
						//carryforward
						/*$this->db->where('employee_id', $timesheet[0]->employee_id);
						$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
						//$this->db->where('create_date', date('Y-m-d'));
						$result_carry = $this->db->get('carry_leaves');*/
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);


							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$va = $count_leave_type[0]->days_per_year;
							$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							//$total =$type[0]->days_per_year;
							$total = $emp_leaves_data[0]->leave_count;
							$leave_remaining_total = $total - $count_ls;
							$c = $count - $va;
							$re = $total - $count_ls;
							if ($leave_remaining_total == 0) {
								$lr = 0;
								$hr = 0;
							} elseif ($leave_remaining_total < $count_ls) {
								$lr = 0;
								$hr = $c;
							} else {
								$lr = $leave_remaining_total;
								$hr = 0;
							}
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
							//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
					} else {
						$data = array(
							'employee_id' => $timesheet[0]->employee_id,
							'company_id' => $timesheet[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $next_form_date,
							'to_date' => $this->input->post('end_date'),
							'applied_on' => date('Y-m-d h:i:s'),
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $no_of_days_annual_remain,
							'leave_unpaid_auto' => $timesheet[0]->leave_id
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						//carryforward
						/*$this->db->where('employee_id', $timesheet[0]->employee_id);
							$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
							//$this->db->where('create_date', date('Y-m-d'));
							$result_carry = $this->db->get('carry_leaves');*/
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);


							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$va = $count_leave_type[0]->days_per_year;
							$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							//$total =$type[0]->days_per_year;
							if ($emp_leaves_data) {
								$total = $emp_leaves_data[0]->leave_count;
							} else {
								$total = 0;
							}
							$leave_remaining_total = $total - $count_ls;
							$c = $count - $va;
							$re = $total - $count_ls;
							if ($leave_remaining_total == 0) {
								$lr = 0;
								$hr = 0;
							} elseif ($leave_remaining_total < $count_ls) {
								$lr = 0;
								$hr = $c;
							} else {
								$lr = $leave_remaining_total;
								$hr = 0;
							}
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$leave_remaining_total = abs($carry_leave[0]->remaing_leave_count) + $timesheet[0]->days;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
					}
				}

				//Carry leaves calcualtions
				$timesheet = $this->Timesheet_model->read_leave_information($id);
				$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, $timesheet[0]->leave_type_id);
				$date_arr = explode("-", $timesheet[0]->from_date);
				$year_check = $date_arr[0];
				$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
				if (isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
					//pending or rejected
					$leave_half_day_opt = $timesheet[0]->is_half_day;
					$carry_leave = $result_carry->result();
					$hlfcounts = 0;
					$count_ls = 0;
					$leaves_id = $timesheet[0]->leave_type_id;
					$employees_id = $timesheet[0]->employee_id;
					$days = $timesheet[0]->days;
					if ($timesheet[0]->is_half_day == 1) {
						$days = 0.5;
					}
					$total = $carry_leave[0]->remaing_leave_count;
					$taked_leaves = $timesheet[0]->days;
					//print_r($taked_leaves);exit;

					if ($leaves_id == 7) {
						if ($leave_half_day_opt == 1) {
							$leave_remaining_total = $total + 0.5;
						} else {
							$leave_remaining_total = $total + $taked_leaves;
						}
						$leave_remaining_total = abs($leave_remaining_total);
					} else {
						if ($leave_half_day_opt == 1) {
							$leave_remaining_total = $total - 0.5;
						} else {
							$leave_remaining_total = $total - $taked_leaves;
						}
						$leave_remaining_total = $leave_remaining_total;
					}
					$data_update = array(
						'employee_id' => $timesheet[0]->employee_id,
						'leave_type_id' => $timesheet[0]->leave_type_id,
						'remaing_leave_count' => $leave_remaining_total,
						//'create_date'=> date('Y-m-d')
					);
					$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
				}
				// EndCarry leaves  calcualation
				$Return['result'] = $this->lang->line('xin_success_leave_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function update_leave_status_validate()
	{
		if ($this->input->post('update_type') == 'leave') {
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$unpaid_leave_id = 0;
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			$sick_leave_noti = 'N';
			$id = $this->uri->segment(4);
			$leave_claim_row = $this->db->get_where('xin_leave_applications', array('leave_id' => $id))->row();
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $second_approval = $final_approval = 0;
			$approved_by_first = $approved_by_second = $approved_by_final = '';

			if ($user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)) {
				/* Define return | here result is used to return user data and error for error message */
				$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
				$Return['csrf_hash'] = $this->security->get_csrf_hash();
				$remarks = $this->input->post('remarks');
				$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
				$timesheet = $this->Timesheet_model->read_leave_information($id);
				if ($timesheet[0]->leave_type_id == 4) {
					if (!empty($this->input->post('leave_probation_check')) == 0 || ($this->input->post('leave_probation_check') == 1) && ($this->input->post('probation_check') == 'from_leave')) {
						if ($this->input->post('status') == '2' && $this->input->post('sick_leave_exceed_limit_flag') == 0) {
							/* validation part */
							if (empty($this->input->post('sick_leave_type'))) {
								$Return['error'] = 'Sick leave type field is required';
							}
							if ($this->input->post('sick_leave_type')) {
								$sick_leave_type_array = $this->input->post('sick_leave_type');
								foreach ($sick_leave_type_array as $type_array) {
									if ($type_array == 1) {
										if (empty($this->input->post('start_date_paid'))) {
											$Return['error'] = 'Sick leave paid start date is required';
										} else if (empty($this->input->post('end_date_paid'))) {
											$Return['error'] = 'Sick leave paid end date is required';
										} else if (strtotime($this->input->post('start_date_paid')) > strtotime($this->input->post('end_date_paid'))) {
											$Return['error'] = 'Paid ' . $this->lang->line('xin_error_start_end_date');
										}
									}
									if ($type_array == 2) {
										if (empty($this->input->post('start_date_half'))) {
											$Return['error'] = 'Sick leave half paid start date is required';
										} else if (empty($this->input->post('end_date_half'))) {
											$Return['error'] = 'Sick leave  half paid end date is required';
										} else if (strtotime($this->input->post('start_date_half')) > strtotime($this->input->post('end_date_half'))) {
											$Return['error'] = 'Half Paid ' . $this->lang->line('xin_error_start_end_date');
										}
									}
									if ($type_array == 3) {
										if (empty($this->input->post('start_date_unpaid'))) {
											$Return['error'] = 'Sick leave unpaid start date is required';
										} else if (empty($this->input->post('end_date_unpaid'))) {
											$Return['error'] = 'Sick leave unpaid end date is required';
										} else if (strtotime($this->input->post('start_date_unpaid')) > strtotime($this->input->post('end_date_unpaid'))) {
											$Return['error'] = 'Unpaid ' . $this->lang->line('xin_error_start_end_date');
										}
									}
								}
							}

							if ($Return['error'] != '') {
								$this->output($Return);
							}
							/* end validation part */
						}
					}
				}
			}
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
			$this->output($Return);
			exit;
		}
		$this->output($Return);
	}

	public function update_leave_status()
	{
		if ($this->input->post('update_type') == 'leave') {
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$unpaid_leave_id = 0;
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			$sick_leave_noti = 'N';
			$id = $this->uri->segment(4);
			$leave_claim_row = $this->db->get_where('xin_leave_applications', array('leave_id' => $id))->row();
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $second_approval = $final_approval = 0;
			$approved_by_first = $approved_by_second = $approved_by_final = '';
			if ($this->input->post('status') == null) {
				$first_approval = $leave_claim_row->first_approval;
				$second_approval = $leave_claim_row->second_approval;
				$final_approval = $leave_claim_row->final_approval;
				$status_updated = $leave_claim_row->status;
				$approved_by_first = $leave_claim_row->approved_by_first;
				$approved_by_second = $leave_claim_row->approved_by_second;
				$approved_by_final = $leave_claim_row->approved_by_final;
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$status_updated = $this->input->post('status');

					if ($status_updated == 2) {
						$first_approval = $second_approval = $final_approval = 1;
						$old_first_val = $leave_claim_row->first_approval;
						if ($old_first_val) {
							$approved_by_first = $leave_claim_row->approved_by_first;
						} else {
							$approved_by_first = $session['user_id'];
						}
						$old_second_val = $leave_claim_row->second_approval;
						if ($old_second_val) {
							$approved_by_second = $leave_claim_row->approved_by_second;
						} else {
							$approved_by_second = $session['user_id'];
						}
						$old_final_val = $leave_claim_row->final_approval;
						if ($old_final_val) {
							$approved_by_final = $leave_claim_row->approved_by_final;
						} else {
							$approved_by_final = $session['user_id'];
						}
					} else if ($status_updated == 3) {
						$final_approval = 2;
						$approved_by_final = $session['user_id'];
					}
				} elseif (in_array('256', $role_resources_ids) || in_array('258', $role_resources_ids) || in_array('257', $role_resources_ids)) {
					if (in_array('256', $role_resources_ids)) {
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2) {
							$first_approval = 1;
							$old_first_val = $leave_claim_row->first_approval;
							if ($old_first_val) {
								$approved_by_first = $leave_claim_row->approved_by_first;
							} else {
								$approved_by_first = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$first_approval = 2;
							$approved_by_first = $session['user_id'];
						}
					}
					if (in_array('257', $role_resources_ids)) { //second approval
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2 && $leave_claim_row->first_approval) {
							$first_approval = $second_approval = 1;
							$old_second_val = $leave_claim_row->second_approval;
							if ($old_second_val) {
								$approved_by_second = $leave_claim_row->approved_by_second;
							} else {
								$approved_by_second = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$second_approval = 2;
							$approved_by_second = $session['user_id'];
						}
					}
					if (in_array('258', $role_resources_ids)) {
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2) {
							$first_approval = $second_approval = $final_approval = 1;
							$status_updated = 2;
							$old_first_val = $leave_claim_row->first_approval;
							if ($old_first_val) {
								$approved_by_first = $leave_claim_row->approved_by_first;
							} else {
								$approved_by_first = $session['user_id'];
							}
							$old_second_val = $leave_claim_row->second_approval;
							if ($old_second_val) {
								$approved_by_second = $leave_claim_row->approved_by_second;
							} else {
								$approved_by_second = $session['user_id'];
							}
							$old_final_val = $leave_claim_row->final_approval;
							if ($old_final_val) {
								$approved_by_final = $leave_claim_row->approved_by_final;
							} else {
								$approved_by_final = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$final_approval = 2;
							$approved_by_final = $session['user_id'];
						}
					}
				} else {
					$status_updated = $this->input->post('leave_status_old');
				}
			}
			if ($user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)) {
				/* Define return | here result is used to return user data and error for error message */
				$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
				$Return['csrf_hash'] = $this->security->get_csrf_hash();
				$remarks = $this->input->post('remarks');
				$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
				$timesheet = $this->Timesheet_model->read_leave_information($id);
				if ($timesheet[0]->leave_type_id == 4) {
					if (!empty($this->input->post('leave_probation_check')) == 0 || ($this->input->post('leave_probation_check') == 1) && ($this->input->post('probation_check') == 'from_leave')) {
						if ($this->input->post('status') == '2' && $this->input->post('sick_leave_exceed_limit_flag') == 0) {
							/* validation part */
							if (empty($this->input->post('sick_leave_type'))) {
								$Return['error'] = 'Sick leave type field is required';
							}
							if ($this->input->post('sick_leave_type')) {
								$sick_leave_type_array = $this->input->post('sick_leave_type');
								foreach ($sick_leave_type_array as $type_array) {
									if ($type_array == 1) {
										if (empty($this->input->post('start_date_paid'))) {
											$Return['error'] = 'Sick leave paid start date is required';
										} else if (empty($this->input->post('end_date_paid'))) {
											$Return['error'] = 'Sick leave paid end date is required';
										} else if (strtotime($this->input->post('start_date_paid')) > strtotime($this->input->post('end_date_paid'))) {
											$Return['error'] = 'Paid ' . $this->lang->line('xin_error_start_end_date');
										}
									}
									if ($type_array == 2) {
										if (empty($this->input->post('start_date_half'))) {
											$Return['error'] = 'Sick leave half paid start date is required';
										} else if (empty($this->input->post('end_date_half'))) {
											$Return['error'] = 'Sick leave  half paid end date is required';
										} else if (strtotime($this->input->post('start_date_half')) > strtotime($this->input->post('end_date_half'))) {
											$Return['error'] = 'Half Paid ' . $this->lang->line('xin_error_start_end_date');
										}
									}
									if ($type_array == 3) {
										if (empty($this->input->post('start_date_unpaid'))) {
											$Return['error'] = 'Sick leave unpaid start date is required';
										} else if (empty($this->input->post('end_date_unpaid'))) {
											$Return['error'] = 'Sick leave unpaid end date is required';
										} else if (strtotime($this->input->post('start_date_unpaid')) > strtotime($this->input->post('end_date_unpaid'))) {
											$Return['error'] = 'Unpaid ' . $this->lang->line('xin_error_start_end_date');
										}
									}
								}
							}

							if ($Return['error'] != '') {
								$this->output($Return);
							}
							/* end validation part */
							$paid_start_date = $paid_end_date = $halfpaid_start_date = $halfpaid_end_date = $unpaid_start_date = $unpaid_end_date = '';
							if ($this->input->post('sick_leave_type')) {
								$sick_leave_type_array = $this->input->post('sick_leave_type');
								foreach ($sick_leave_type_array as $type_array) {
									if ($type_array == 1) {
										$paid_start_date = $this->input->post('start_date_paid');
										$paid_end_date = $this->input->post('end_date_paid');
									}
									if ($type_array == 2) {
										$halfpaid_start_date = $this->input->post('start_date_half');
										$halfpaid_end_date = $this->input->post('end_date_half');
									}
									if ($type_array == 3) {
										$unpaid_start_date = $this->input->post('start_date_unpaid');
										$unpaid_end_date = $this->input->post('end_date_unpaid');
									}
								}
							}
							$total_paid_count = 0;
							if ($paid_start_date && $paid_end_date) {
								$datetime1 = new DateTime($paid_start_date);
								$datetime2 = new DateTime($paid_end_date);
								$interval = $datetime1->diff($datetime2);
								if (strtotime($paid_start_date) == strtotime($paid_end_date)) {
									$total_paid_count = 1;
								} else {
									$total_paid_count = $interval->format('%a') + 1;
								}
							}
							$total_halfpaid_count = 0;
							if ($halfpaid_start_date && $halfpaid_end_date) {
								$datetime1 = new DateTime($halfpaid_start_date);
								$datetime2 = new DateTime($halfpaid_end_date);
								$interval = $datetime1->diff($datetime2);
								if (strtotime($halfpaid_start_date) == strtotime($halfpaid_end_date)) {
									$total_halfpaid_count = 1;
								} else {
									$total_halfpaid_count = $interval->format('%a') + 1;
								}
							}
							$total_unpaid_count = 0;
							if ($unpaid_start_date && $unpaid_end_date) {
								$datetime1 = new DateTime($unpaid_start_date);
								$datetime2 = new DateTime($unpaid_end_date);
								$interval = $datetime1->diff($datetime2);
								if (strtotime($unpaid_start_date) == strtotime($unpaid_end_date)) {
									$total_unpaid_count = 1;
								} else {
									$total_unpaid_count = $interval->format('%a') + 1;
								}
							}
							$cond = array('leave_id' => $id, 'emp_id' => $timesheet[0]->employee_id);
							$check_sick_mangement_exists = $this->Timesheet_model->common_select('xin_emp_sickleave_manage', $cond);
							if ($check_sick_mangement_exists) {
								$sick_leave_details_array = array(
									'emp_id' => $timesheet[0]->employee_id,
									'leave_id' => $id,
									'leave_type_id' => 4,
									'paid_start_date' => $paid_start_date,
									'paid_end_date' => $paid_end_date,
									'halfpaid_start_date' => $halfpaid_start_date,
									'halfpaid_end_date' => $halfpaid_end_date,
									'unpaid_start_date' => $unpaid_start_date,
									'unpaid_end_date' => $unpaid_end_date,
									'total_paid_count' => $total_paid_count,
									'total_half_paid_count' => $total_halfpaid_count,
									'total_unpaid_count' => $total_unpaid_count,
									'status' => 'Y',
									'date' => date('Y-m-d')
								);
								$result_sick = $this->Timesheet_model->update_common('xin_emp_sickleave_manage', $sick_leave_details_array, $check_sick_mangement_exists[0]->id);
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
								$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
								$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employees_id, $leaves_id);
								$total = $carry_count[0]->remaing_leave_count;
								$days = $timesheet[0]->days;
								if ($timesheet[0]->is_half_day == 1) {
									$days = 0.5;
								}
								if ($leaves_id == 7) {
									$leave_remaining_total = $total - $days;
									if ($leave_remaining_total < 0) {
										$leave_remaining_total = 0;
									} else {
										$leave_remaining_total = $leave_remaining_total;
									}
								} else {
									$leave_remaining_total = $total + $days;
								}
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => $leave_remaining_total,
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => $leave_remaining_total,
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else {
								$sick_leave_details_array = array(
									'emp_id' => $timesheet[0]->employee_id,
									'leave_id' => $id,
									'leave_type_id' => 4,
									'paid_start_date' => $paid_start_date,
									'paid_end_date' => $paid_end_date,
									'halfpaid_start_date' => $halfpaid_start_date,
									'halfpaid_end_date' => $halfpaid_end_date,
									'unpaid_start_date' => $unpaid_start_date,
									'unpaid_end_date' => $unpaid_end_date,
									'total_paid_count' => $total_paid_count,
									'total_half_paid_count' => $total_halfpaid_count,
									'total_unpaid_count' => $total_unpaid_count,
									'status' => 'Y',
									'date' => date('Y-m-d')
								);
								$result_sick = $this->Timesheet_model->insert_common('xin_emp_sickleave_manage', $sick_leave_details_array);
							}
							if ($result_sick) {
								$no_of_days = $total_paid_count + $total_halfpaid_count + $total_unpaid_count;
								$data = array(
									'reason' => $this->input->post('reason'),
									'remarks' => $qt_remarks,
									'days' => $no_of_days,
									'status' => $this->input->post('status'),
									'first_approval' => $first_approval,
									'second_approval' => $second_approval,
									'final_approval' => $final_approval,
									'approved_by_first' => $approved_by_first,
									'approved_by_second' => $approved_by_second,
									'approved_by_final' => $approved_by_final,
									'updated_date' => date('Y-m-d')
								);
								$result = $this->Timesheet_model->update_leave_record($data, $id);
							} else {
								$Return['error'] = $this->lang->line('xin_error_msg');
							}
						} else {
							$cond = array('leave_id' => $id, 'emp_id' => $timesheet[0]->employee_id);
							$check_sick_mangement_exists = $this->Timesheet_model->common_select('xin_emp_sickleave_manage', $cond);
							if ($check_sick_mangement_exists) {
								$sick_leave_details_array = array(
									'status' => 'N',
									'date' => date('Y-m-d')
								);
								$result_sick = $this->Timesheet_model->update_common('xin_emp_sickleave_manage', $sick_leave_details_array, $check_sick_mangement_exists[0]->id);
							}
							/*	$data = array(
						'reason' => $this->input->post('reason'),
						'remarks' => $qt_remarks,
						'status' => $this->input->post('status')
					);
					$result = $this->Timesheet_model->update_leave_record($data, $id);
				*/
						}
					}
				}
				if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {

					/* Leave unpaid make */
					$no_of_days = $timesheet[0]->days;
					$aval_leaves = 0;
					$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, $timesheet[0]->leave_type_id);
					if (!empty($check_annual_leave_aval)) {
						$aval_leaves = $check_annual_leave_aval[0]->leave_count;
					}
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
					$carry_leave_exced = $result_carry->result();
					if ($result_carry->num_rows() > 0) {
						if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
							if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
								if ($carry_leave_exced[0]->leave_type_id == 4) {
									$sick_leave_noti = 'Y';
								}
								$no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
								$no_of_days = $carry_leave_exced[0]->remaing_leave_count;
								$aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
								$inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						} else {
							if ($no_of_days > $aval_leaves) {
								$sick_leave_noti = 'Y';
								$no_of_days_annual_remain = $no_of_days - $aval_leaves;
								$no_of_days = $aval_leaves;
								$inc_days = $aval_leaves - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						}
					} else {
						if ($no_of_days > $aval_leaves) {
							$no_of_days_annual_remain = $no_of_days - $aval_leaves;
							$no_of_days = $aval_leaves;
							$inc_days = $aval_leaves - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					}
					/* end leave unpaid */
					/* in probation time */
					$haj = 0;
					if ($timesheet[0]->leave_type_id == 8) {
						$user_leave = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$date11 = strtotime($user_leave[0]->date_of_joining);
						$date21 = strtotime(date('Y-m-d'));
						$diff1 = abs($date21 - $date11);
						$years = floor($diff1 / (365 * 60 * 60 * 24));
						if ($years <= 5) {
							$haj = 1;
						}
					}

					if ((!empty($this->input->post('probation_check')) && $probation_check == 'lop') || $haj == 1) {
						$timesheet_exceeds = $this->Timesheet_model->read_leave_information($id);
						$check_flag = 3;
						$no_of_days_annual_remain = 0;
						$data = array(
							'employee_id' => $timesheet_exceeds[0]->employee_id,
							'company_id' => $timesheet_exceeds[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $timesheet_exceeds[0]->from_date,
							'to_date' => $timesheet_exceeds[0]->to_date,
							'applied_on' => $timesheet_exceeds[0]->applied_on,
							'reason' => $timesheet_exceeds[0]->reason,
							'remarks' => $timesheet_exceeds[0]->remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $timesheet_exceeds[0]->days,
							'cleared_status' => 1,
							'probation_check' => $probation_check
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						$unpaid_leave_id = $result;
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						//carryforward
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);

							$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$va = $count_leave_type[0]->days_per_year;
							$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							//$total =$type[0]->days_per_year;
							if ($emp_leaves_data) {
								$total = $emp_leaves_data[0]->leave_count;
							} else {
								$total = 0;
							}
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($leaves_id == 7) {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								}
								/*if($leave_half_day_opt == 1){
									$leave_remaining_total = $leave_remaining_total - 0.5;
								}*/
								$leave_remaining_total = abs($leave_remaining_total);
							} else {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								}

								$leave_remaining_total = $leave_remaining_total;
							}
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {

							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;

							$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($leaves_id == 7) {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								}
								/*if($leave_half_day_opt == 1){
										$leave_remaining_total = $leave_remaining_total - 0.5;
									}*/
								$leave_remaining_total = abs($leave_remaining_total);
							} else {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								}

								$leave_remaining_total = $leave_remaining_total;
							}
							//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						$result_dlt_exits = $this->Timesheet_model->delete_leave_record($timesheet_exceeds[0]->leave_id);
					} else {

						/*end probation time calc */
						//check leave exceeds
						$timesheet_exceeds = $this->Timesheet_model->read_leave_information($id);
						$date_arr = explode("-", $timesheet_exceeds[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet_exceeds[0]->employee_id, $timesheet_exceeds[0]->leave_type_id, $year_check);
						$carry_leave_exced = $result_carry->result();
						if ($result_carry->num_rows() > 0) {
							if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
								$check_flag = 1;
								$no_of_days_annual_remain = 0;
								$data = array(
									'employee_id' => $timesheet_exceeds[0]->employee_id,
									'company_id' => $timesheet_exceeds[0]->company_id,
									'leave_type_id' => 7,
									'from_date' => $timesheet_exceeds[0]->from_date,
									'to_date' => $timesheet_exceeds[0]->to_date,
									'applied_on' => $timesheet_exceeds[0]->applied_on,
									'reason' => $timesheet_exceeds[0]->reason,
									'remarks' => $timesheet_exceeds[0]->remarks,
									'status' => '2',
									'is_notify' => '1',
									'created_at' => date('Y-m-d h:i:s'),
									'days' => $timesheet_exceeds[0]->days,
									'cleared_status' => 1,
									'probation_check' => $probation_check
								);
								$result = $this->Timesheet_model->add_leave_record_new($data);
								$unpaid_leave_id = $result;
								/* Leave carryforward management */
								$timesheet = $this->Timesheet_model->read_leave_information($result);
								//carryforward
								/*$this->db->where('employee_id', $timesheet[0]->employee_id);
							 $this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
							 //$this->db->where('create_date', date('Y-m-d'));
							 $result_carry = $this->db->get('carry_leaves');*/
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
								//end
								if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->leave_type_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									$count = $xin_leave_type[0]->leave_count;
									$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);

									$leave_half_day_opt = $timesheet[0]->is_half_day;
									$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
									foreach ($leave_halfday_cals as $lhalfday) :
										$hlfcounts += 0.5;
									endforeach;
									$count_ls = count_leaves_info($leaves_id, $employees_id);
									$count_ls = $count_ls - $hlfcounts;
									$va = $count_leave_type[0]->days_per_year;
									$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
									$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
									//$total =$type[0]->days_per_year;
									if ($emp_leaves_data) {
										$total = $emp_leaves_data[0]->leave_count;
									} else {
										$total = 0;
									}
									$carry_leave = $result_carry->result();
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}

									$taked_leaves = $timesheet[0]->days;

									if ($leaves_id == 7) {
										if ($this->input->post('status') != 2) {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total - 0.5;
											} else {
												$leave_remaining_total = $total - $taked_leaves;
											}
										} else {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total + 0.5;
											} else {
												$leave_remaining_total = $total + $taked_leaves;
											}
										}
										/*if($leave_half_day_opt == 1){
									$leave_remaining_total = $leave_remaining_total - 0.5;
								}*/
										$leave_remaining_total = abs($leave_remaining_total);
									} else {
										if ($this->input->post('status') != 2) {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total + 0.5;
											} else {
												$leave_remaining_total = $total + $taked_leaves;
											}
										} else {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total - 0.5;
											} else {
												$leave_remaining_total = $total - $taked_leaves;
											}
										}

										$leave_remaining_total = $leave_remaining_total;
									}
									$date_arr = explode("-", $timesheet[0]->from_date);
									$year_check = $date_arr[0];
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									if ($result->num_rows() == 0) {
										$data_insert = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											'create_date' => date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_insert($data_insert);
									} else {
										$carry_leave = $result->result(); //print_r($carry_leave);exit;
										$data_update = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											//'create_date'=> date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
									}
								} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {

									$carry_leave = $result_carry->result();
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->leave_type_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									$count = $xin_leave_type[0]->leave_count;
									$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
									$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
									foreach ($leave_halfday_cals as $lhalfday) :
										$hlfcounts += 0.5;
									endforeach;
									$count_ls = count_leaves_info($leaves_id, $employees_id);
									$count_ls = $count_ls - $hlfcounts;

									$leave_half_day_opt = $timesheet[0]->is_half_day;
									$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
									$carry_leave = $result_carry->result();
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}

									$taked_leaves = $timesheet[0]->days;

									if ($leaves_id == 7) {
										if ($this->input->post('status') != 2) {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total - 0.5;
											} else {
												$leave_remaining_total = $total - $taked_leaves;
											}
										} else {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total + 0.5;
											} else {
												$leave_remaining_total = $total + $taked_leaves;
											}
										}
										/*if($leave_half_day_opt == 1){
										$leave_remaining_total = $leave_remaining_total - 0.5;
									}*/
										$leave_remaining_total = abs($leave_remaining_total);
									} else {
										if ($this->input->post('status') != 2) {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total + 0.5;
											} else {
												$leave_remaining_total = $total + $taked_leaves;
											}
										} else {
											if ($leave_half_day_opt == 1) {
												$leave_remaining_total = $total - 0.5;
											} else {
												$leave_remaining_total = $total - $taked_leaves;
											}
										}

										$leave_remaining_total = $leave_remaining_total;
									}
									//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
								$result_dlt_exits = $this->Timesheet_model->delete_leave_record($timesheet_exceeds[0]->leave_id);
							} else {
								$data = array(
									'status' => $this->input->post('status'),
									'remarks' => $qt_remarks,
									'allotted_leave' => $aval_leaves,
									'to_date' => $next_form_date_ann,
									'days' => $no_of_days,
									'cleared_status' => 1,
									'sick_leave_noti' => $sick_leave_noti,
									'first_approval' => $first_approval,
									'second_approval' => $second_approval,
									'final_approval' => $final_approval,
									'approved_by_first' => $approved_by_first,
									'approved_by_second' => $approved_by_second,
									'approved_by_final' => $approved_by_final,
									'updated_date' => date('Y-m-d')

								);
								$result = $this->Timesheet_model->update_leave_record($data, $id);
							}
						} else {
							$data = array(
								'status' => $this->input->post('status'),
								'remarks' => $qt_remarks,
								'allotted_leave' => $aval_leaves,
								'to_date' => $next_form_date_ann,
								'days' => $no_of_days,
								'cleared_status' => 1,
								'sick_leave_noti' => $sick_leave_noti,
								'first_approval' => $first_approval,
								'second_approval' => $second_approval,
								'final_approval' => $final_approval,
								'approved_by_first' => $approved_by_first,
								'approved_by_second' => $approved_by_second,
								'approved_by_final' => $approved_by_final,
								'updated_date' => date('Y-m-d')
							);

							$result = $this->Timesheet_model->update_leave_record($data, $id);
						}
					}
				} else {
					if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
						$check_flag = 2;
					}
					//$check_flag = 1;
					$data = array(
						'status' => $this->input->post('status'),
						'sick_leave_noti' => 'N',
						'first_approval' => $first_approval,
						'second_approval' => $second_approval,
						'final_approval' => $final_approval,
						'approved_by_first' => $approved_by_first,
						'approved_by_second' => $approved_by_second,
						'approved_by_final' => $approved_by_final,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_leave_record($data, $id);
				}
				//end check leave exceeds
				if ($result == TRUE) {
					if ($no_of_days_annual_remain > 0) {
						$next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
						$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
						if (!empty($checl_already_exists_annual)) {
							$data = array(
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'days' => $no_of_days_annual_remain,
								'leave_unpaid_auto' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check,
								'sick_leave_noti' => $sick_leave_noti,
								'first_approval' => $first_approval,
								'second_approval' => $second_approval,
								'final_approval' => $final_approval,
								'approved_by_first' => $approved_by_first,
								'approved_by_second' => $approved_by_second,
								'approved_by_final' => $approved_by_final,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
							/* Leave carryforward management */
							$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
							//carryforward
							/*$this->db->where('employee_id', $timesheet[0]->employee_id);
						$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
						//$this->db->where('create_date', date('Y-m-d'));
						$result_carry = $this->db->get('carry_leaves');*/
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							//end
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								$count = $xin_leave_type[0]->leave_count;
								$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);


								$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
								foreach ($leave_halfday_cals as $lhalfday) :
									$hlfcounts += 0.5;
								endforeach;
								$count_ls = count_leaves_info($leaves_id, $employees_id);
								$count_ls = $count_ls - $hlfcounts;
								$va = $count_leave_type[0]->days_per_year;
								$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
								$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
								//$total =$type[0]->days_per_year;
								$total = $emp_leaves_data[0]->leave_count;
								$leave_remaining_total = $total - $count_ls;
								$c = $count - $va;
								$re = $total - $count_ls;
								if ($leave_remaining_total == 0) {
									$lr = 0;
									$hr = 0;
								} elseif ($leave_remaining_total < $count_ls) {
									$lr = 0;
									$hr = $c;
								} else {
									$lr = $leave_remaining_total;
									$hr = 0;
								}
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								//pending or rejected
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								$count = $xin_leave_type[0]->leave_count;
								$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
								$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
								foreach ($leave_halfday_cals as $lhalfday) :
									$hlfcounts += 0.5;
								endforeach;
								$count_ls = count_leaves_info($leaves_id, $employees_id);
								$count_ls = $count_ls - $hlfcounts;
								$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
								//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
							/* End Leave carryforward management */
						} else {

							$data = array(
								'employee_id' => $timesheet[0]->employee_id,
								'company_id' => $timesheet[0]->company_id,
								'leave_type_id' => 7,
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'applied_on' => date('Y-m-d h:i:s'),
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'created_at' => date('Y-m-d h:i:s'),
								'days' => $no_of_days_annual_remain,
								'leave_unpaid_auto' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check
							);
							$result = $this->Timesheet_model->add_leave_record_new($data);
							$unpaid_leave_id = $result;
							/* Leave carryforward management */
							$timesheet = $this->Timesheet_model->read_leave_information($result);
							//carryforward
							/*$this->db->where('employee_id', $timesheet[0]->employee_id);
							$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
							//$this->db->where('create_date', date('Y-m-d'));
							$result_carry = $this->db->get('carry_leaves');*/
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							//end
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								$count = $xin_leave_type[0]->leave_count;
								$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);


								$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
								foreach ($leave_halfday_cals as $lhalfday) :
									$hlfcounts += 0.5;
								endforeach;
								$count_ls = count_leaves_info($leaves_id, $employees_id);
								$count_ls = $count_ls - $hlfcounts;
								$va = $count_leave_type[0]->days_per_year;
								$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
								$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
								//$total =$type[0]->days_per_year;
								if ($emp_leaves_data) {
									$total = $emp_leaves_data[0]->leave_count;
								} else {
									$total = 0;
								}
								$leave_remaining_total = $total - $count_ls;
								$c = $count - $va;
								$re = $total - $count_ls;
								if ($leave_remaining_total == 0) {
									$lr = 0;
									$hr = 0;
								} elseif ($leave_remaining_total < $count_ls) {
									$lr = 0;
									$hr = $c;
								} else {
									$lr = $leave_remaining_total;
									$hr = 0;
								}
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								//pending or rejected
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								$count = $xin_leave_type[0]->leave_count;
								$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
								$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
								foreach ($leave_halfday_cals as $lhalfday) :
									$hlfcounts += 0.5;
								endforeach;
								$count_ls = count_leaves_info($leaves_id, $employees_id);
								$count_ls = $count_ls - $hlfcounts;
								$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;
								//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
							/* End Leave carryforward management */
						}
					}
					if ($check_flag == 0) {
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_leave_information($id);
						//carryforward
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_half_day_opt = $timesheet[0]->is_half_day;

							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($leaves_id == 7) {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								}
								/*if($leave_half_day_opt == 1){
								$leave_remaining_total = $leave_remaining_total - 0.5;
							}*/
								$leave_remaining_total = abs($leave_remaining_total);
							} else {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								}

								$leave_remaining_total = $leave_remaining_total;
							}

							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result();
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

							$total = $carry_leave[0]->remaing_leave_count;
							$taked_leaves = $timesheet[0]->days;
							//print_r($taked_leaves);exit;

							if ($leaves_id == 7) {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
									//$leave_remaining_total = $total + $taked_leaves;
								}

								/*if($leave_half_day_opt == 1){
									$leave_remaining_total = $leave_remaining_total - 0.5;
								}*/
								$leave_remaining_total = abs($leave_remaining_total);
							} else {
								if ($this->input->post('status') != 2) {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total + 0.5;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
								} else {
									if ($leave_half_day_opt == 1) {
										$leave_remaining_total = $total - 0.5;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
								}
								/*if($leave_half_day_opt == 1){
									$leave_remaining_total = $leave_remaining_total - 0.5;
								}*/
								$leave_remaining_total = $leave_remaining_total;
							}
							//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					} else if ($check_flag == 1) {
						$Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					}

					$nticket_data = array(
						'module_name' => 'leave_approve',
						'module_id' => $id,
						'employee_id' => $timesheet[0]->employee_id,
						'is_notify' => '1',
						'created_at' => date('d-m-Y h:i:s'),
					);
					$this->Xin_model->add_notifications($nticket_data);


					$setting = $this->Xin_model->read_setting_info(1);
					if ($setting[0]->enable_email_notification == 'yes') {

						if ($this->input->post('status') == 2) {

							$this->email->set_mailtype("html");

							//get leave info
							$timesheet = $this->Timesheet_model->read_leave_information($id);
							if (empty($timesheet) && $unpaid_leave_id != 0) {
								$timesheet = $this->Timesheet_model->read_leave_information($unpaid_leave_id);
							}
							//get company info
							$cinfo = $this->Xin_model->read_company_setting_info(1);
							//get email template
							$template = $this->Xin_model->read_email_template(6);
							//get employee info
							$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

							$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

							$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
							$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

							$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
							$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

							$message = '
			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
			<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

							hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
						} else if ($this->input->post('status') == 3) { // rejected

							$this->email->set_mailtype("html");

							//get leave info
							$timesheet = $this->Timesheet_model->read_leave_information($id);
							//get company info
							$cinfo = $this->Xin_model->read_company_setting_info(1);
							//get email template
							$template = $this->Xin_model->read_email_template(7);
							//get employee info
							$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

							$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

							$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
							$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

							$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
							$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

							$message = '
			<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
			<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

							hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
						}
					}
					$this->output($Return);
					exit;
				}
			} else {
				$data = array(
					'status' => $status_updated,
					'first_approval' => $first_approval,
					'second_approval' => $second_approval,
					'final_approval' => $final_approval,
					'approved_by_first' => $approved_by_first,
					'approved_by_second' => $approved_by_second,
					'approved_by_final' => $approved_by_final,
					'updated_date' => date('Y-m-d')
				);
				$result = $this->Timesheet_model->update_leave_record($data, $id);
				$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				$this->output($Return);
				exit;
			}
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function edit_task()
	{

		if ($this->input->post('edit_type') == 'task') {

			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('project_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_project_field');
			} else if ($this->input->post('task_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_name');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('task_hour') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_hour');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			if (null != $this->input->post('assigned_to')) {
				$assigned_ids = implode(',', $this->input->post('assigned_to'));
			} else {
				$assigned_ids = 'None';
			}

			$data = array(
				'task_name' => $this->input->post('task_name'),
				'project_id' => $this->input->post('project_id'),
				'assigned_to' => $assigned_ids,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'task_hour' => $this->input->post('task_hour'),
				'description' => $qt_description
			);

			$result = $this->Timesheet_model->update_task_record($data, $id);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_task_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function edit_variation()
	{

		if ($this->input->post('edit_type') == 'variation') {

			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('variation_name') === '') {
				$Return['error'] = $this->lang->line('xin_project_variation_title_field_error');
			} else if ($this->input->post('variation_no') === '') {
				$Return['error'] = $this->lang->line('xin_project_variation_field_error');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('variation_hour') === '') {
				$Return['error'] = $this->lang->line('xin_project_variation_hrs_field_error');
			} else if ($this->input->post('assigned_to') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_assigned_user');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			if (null != $this->input->post('assigned_to')) {
				$assigned_ids = implode(',', $this->input->post('assigned_to'));
			} else {
				$assigned_ids = 'None';
			}

			$data = array(
				'variation_name' => $this->input->post('variation_name'),
				'variation_no' => $this->input->post('variation_no'),
				'assigned_to' => $assigned_ids,
				'start_date' => $this->input->post('start_date'),
				'end_date' => $this->input->post('end_date'),
				'variation_hours' => $this->input->post('variation_hour'),
				'variation_status' => $this->input->post('status'),
				'client_approval' => $this->input->post('client_approval'),
				'description' => $qt_description
			);

			$result = $this->Timesheet_model->update_project_variations($data, $id);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_project_variation_added_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// get record of leave by id > modal
	public function read_task_record()
	{
		$data['title'] = $this->Xin_model->site_title();
		$task_id = $this->input->get('task_id');
		$result = $this->Timesheet_model->read_task_information($task_id);

		$data = array(
			'task_id' => $result[0]->task_id,
			'project_id' => $result[0]->project_id,
			'company_id' => $result[0]->company_id,
			'projectid' => $result[0]->project_id,
			'created_by' => $result[0]->created_by,
			'task_name' => $result[0]->task_name,
			'assigned_to' => $result[0]->assigned_to,
			'start_date' => $result[0]->start_date,
			'end_date' => $result[0]->end_date,
			'task_hour' => $result[0]->task_hour,
			'task_status' => $result[0]->task_status,
			'task_progress' => $result[0]->task_progress,
			'description' => $result[0]->description,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'all_projects' => $this->Project_model->get_all_projects()
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/tasks/dialog_task', $data);
		} else {
			redirect('admin/');
		}
	}

	// get record of leave by id > modal
	public function read_variation_record()
	{
		$data['title'] = $this->Xin_model->site_title();
		$variation_id = $this->input->get('variation_id');
		$result = $this->Timesheet_model->read_variation_information($variation_id);

		$data = array(
			'variation_id' => $result[0]->variation_id,
			'project_id' => $result[0]->project_id,
			'company_id' => $result[0]->company_id,
			'client_approval' => $result[0]->client_approval,
			'created_by' => $result[0]->created_by,
			'variation_name' => $result[0]->variation_name,
			'assigned_to' => $result[0]->assigned_to,
			'start_date' => $result[0]->start_date,
			'end_date' => $result[0]->end_date,
			'variation_hours' => $result[0]->variation_hours,
			'variation_status' => $result[0]->variation_status,
			'variation_no' => $result[0]->variation_no,
			'description' => $result[0]->description,
			'created_at' => $result[0]->created_at,
			'all_employees' => $this->Xin_model->all_employees()
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/tasks/dialog_task', $data);
		} else {
			redirect('admin/');
		}
	}

	// get record of leave by id > modal
	public function read_leave_record()
	{
		$data['title'] = $this->Xin_model->site_title();
		/*$leave_id = $this->input->get('leave_id');
		$result = $this->Timesheet_model->read_leave_information($leave_id);

		$data = array(
				'leave_id' => $result[0]->leave_id,
				'company_id' => $result[0]->company_id,
				'employee_id' => $result[0]->employee_id,
				'leave_type_id' => $result[0]->leave_type_id,
				'from_date' => $result[0]->from_date,
				'to_date' => $result[0]->to_date,
				'applied_on' => $result[0]->applied_on,
				'is_half_day' => $result[0]->is_half_day,
				'reason' => $result[0]->reason,
				'remarks' => $result[0]->remarks,
				'status' => $result[0]->status,
				'created_at' => $result[0]->created_at,
				'all_employees' => $this->Xin_model->all_employees(),
				'get_all_companies' => $this->Xin_model->get_companies(),
				'all_leave_types' => $this->Timesheet_model->all_leave_types(),
				);*/
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_leave', $data);
		} else {
			redirect('admin/');
		}
	}


	public function read_leave_record_cancel()
	{
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_leave _cancel', $data);
		} else {
			redirect('admin/');
		}
	}


	public function read_leave_cancel()
	{
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_cancel_leave', $data);
		} else {
			redirect('admin/');
		}
	}


	public function read_postpond_leave()
	{
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_postpone', $data);
		} else {
			redirect('admin/');
		}
	}


	// get record of attendance
	public function read()
	{
		$data['title'] = $this->Xin_model->site_title();

		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_attendance', $data);
		} else {
			redirect('admin/');
		}
	}

	// get record of holiday
	public function read_holiday_record()
	{
		$data['title'] = $this->Xin_model->site_title();
		$holiday_id = $this->input->get('holiday_id');
		$result = $this->Timesheet_model->read_holiday_information($holiday_id);

		$data = array(
			'holiday_id' => $result[0]->holiday_id,
			'company_id' => $result[0]->company_id,
			'event_name' => $result[0]->event_name,
			'start_date' => $result[0]->start_date,
			'end_date' => $result[0]->end_date,
			'is_publish' => $result[0]->is_publish,
			'description' => $result[0]->description,
			'get_all_companies' => $this->Xin_model->get_companies()
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_holiday', $data);
		} else {
			redirect('admin/');
		}
	}

	// get record of office shift
	public function read_shift_record()
	{
		$data['title'] = $this->Xin_model->site_title();
		$office_shift_id = $this->input->get('office_shift_id');
		$result = $this->Timesheet_model->read_office_shift_information($office_shift_id);

		$data = array(
			'office_shift_id' => $result[0]->office_shift_id,
			'company_id' => $result[0]->company_id,
			'shift_name' => $result[0]->shift_name,
			'late_allowed_till' => $result[0]->late_allowed_till,
			'total_working_hours' => $result[0]->total_working_hours,
			'monday_in_time' => $result[0]->monday_in_time,
			'monday_out_time' => $result[0]->monday_out_time,
			'tuesday_in_time' => $result[0]->tuesday_in_time,
			'tuesday_out_time' => $result[0]->tuesday_out_time,
			'wednesday_in_time' => $result[0]->wednesday_in_time,
			'wednesday_out_time' => $result[0]->wednesday_out_time,
			'thursday_in_time' => $result[0]->thursday_in_time,
			'thursday_out_time' => $result[0]->thursday_out_time,
			'friday_in_time' => $result[0]->friday_in_time,
			'friday_out_time' => $result[0]->friday_out_time,
			'saturday_in_time' => $result[0]->saturday_in_time,
			'saturday_out_time' => $result[0]->saturday_out_time,
			'sunday_in_time' => $result[0]->sunday_in_time,
			'get_all_companies' => $this->Xin_model->get_companies(),
			'sunday_out_time' => $result[0]->sunday_out_time
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_office_shift', $data);
		} else {
			redirect('admin/');
		}
	}

	//read_map_info
	public function read_map_info()
	{
		$data['title'] = $this->Xin_model->site_title();
		//$office_shift_id = $this->input->get('office_shift_id');
		//$result = $this->Timesheet_model->read_office_shift_information($office_shift_id);

		$data = array(
			//	'office_shift_id' => $result[0]->office_shift_id,
			//'company_id' => $result[0]->company_id
		);
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_read_map', $data);
		} else {
			redirect('admin/');
		}
	}

	// Validate and update info in database
	public function edit_attendance_validate()
	{

		if ($this->input->post('edit_type') == 'attendance') {

			$id = $this->uri->segment(4);
			global $holiday_check;
			global $weekends;
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('attendance_date_e') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_date');
			} else if ($this->input->post('clock_in') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_in_time');
			} /*else if($this->input->post('clock_out')==='') {
        	$Return['error'] = "The office Out Time field is required.";
		}*/

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function edit_attendance()
	{

		if ($this->input->post('edit_type') == 'attendance') {

			$id = $this->uri->segment(4);
			global $holiday_check;
			global $weekends;
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('attendance_date_e') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_date');
			} else if ($this->input->post('clock_in') === '') {
				$Return['error'] = $this->lang->line('xin_error_attendance_in_time');
			} /*else if($this->input->post('clock_out')==='') {
        	$Return['error'] = "The office Out Time field is required.";
		}*/

            if ($Return['error'] != '') {
                $this->output($Return);
            }
            $late_by_hours = 0;
            $late_deduct = 0;
            $attendance_date = $this->input->post('attendance_date_e');
            $clock_in = $this->input->post('clock_in');
            // $clock_in_date = $this->input->post('clock_in_date');
            // $clock_out_date = $this->input->post('clock_out_date');

			$clock_in2 = $clock_in; //$clock_in_date . ' ' . $clock_in . ':00';

			//total work
			$total_work_cin = new DateTime($clock_in2);

			if ($this->input->post('clock_out') === '') {
				$empid = $this->input->post('emp_att');
				$data = array(
					'employee_id' => $empid,
					'attendance_date' => $attendance_date,
					'clock_in' => $clock_in2,
					'clock_in_time' => date('H:i', strtotime($clock_in2)),
					'time_late' => $clock_in2,
					'early_leaving' => $clock_in2,
					'overtime' => $clock_in2,
				);
			} else {
				$clock_out = $this->input->post('clock_out');
				$clock_out2 = $clock_out; // $clock_out_date . ' ' . $clock_out . ':00';
				$total_work_cout = new DateTime($clock_out2);

				$interval_cin = $total_work_cout->diff($total_work_cin);
				$hours_in = $interval_cin->format('%h');
				$minutes_in = $interval_cin->format('%i');
				$total_work = $hours_in . ":" . $minutes_in;
				$work_mins_to_hour = round($minutes_in / 60, 3);
				$work_by_hours = $hours_in + $work_mins_to_hour;


				$res = $this->Timesheet_model->get_attendance_record($id);
				$empid = $res[0]->employee_id;
				$emp_clockin = $res[0]->clock_in;
				$cmp_id = $this->Employees_model->get_employee_details($empid);

				$comp_id = $cmp_id[0]->company_id;
				$holidays = $this->Employees_model->get_holidays($comp_id);
				if (isset($holidays)) {
					foreach ($holidays as $row) {
						$startDate = $row->start_date;
						$endDate = $row->end_date;

						if (($attendance_date >= $startDate) && ($attendance_date <= $endDate)) {
							$holiday_check = "yes";
						}
					}
				}
				if ($cmp_id[0]->office_shift_id == 0) {

					$late_allowed = $this->Office_shift_custom_model->employee_current_shift($cmp_id[0]->user_id, $attendance_date);
					$day = date('j', strtotime($attendance_date));
					$in_time = $day . "_in";
					if (!$late_allowed[$in_time]) {
						$late_by_hours = 0;
						$late_deduct = 0;
					} else {
						$on_duty3 = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' . $late_allowed['late_allowed_till'] . "mins"));
						$getfirstrecord = $this->Timesheet_model->get_first_record($empid, $attendance_date);
						$first_clockin = $getfirstrecord[0]->clock_in;

						if ($emp_clockin == $first_clockin) {
							$work_clkin = new DateTime($clock_in2);
							$work_on_duty = new DateTime($on_duty3);
							$clkin_diff = strtotime($clock_in2) - strtotime($on_duty3);
							$interval_clkin = $work_clkin->diff($work_on_duty);
							$hoursin = $interval_clkin->format('%h');
							$minutesin = $interval_clkin->format('%i');
							$minutes_to_hour = round($minutesin / 60, 2);
							$late_by_hours = $hoursin + $minutes_to_hour;

							if ($late_by_hours > 0 && $clkin_diff > 0 && $holiday_check !== "yes") {
								$getemp = $this->Employees_model->get_employee_details($empid);
								$basic_sal = $getemp[0]->basic_salary;
								$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
								$late_deduct = round($latededuction, 3);
							} else {
								$late_by_hours = 0;
								$late_deduct = 0;
							}
						}
					}

					/*$late_allowed = $this->Office_shift_custom_model->employee_current_shift($cmp_id[0]->user_id, $attendance_date);
          $day          = date('j',strtotime($attendance_date));
          $in_time      = $day."_in";
          $on_duty3     = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' .$late_allowed['late_allowed_till']."mins" ));*/
					//$on_duty3     = $attendance_date . ' 00:' . $late_allowed['late_allowed_till'];
				} else {
					$late_allowed = $this->Employees_model->get_lateallowed_foremployee($cmp_id[0]->office_shift_id);
					$on_duty3 = $attendance_date . ' ' . $late_allowed[0]->late_allowed_till;


					$late_by_hours = 0;
					$late_deduct = 0;


					// Find week day
					$week_day = date('l', strtotime($attendance_date));
					$week_day_lower = strtolower($week_day);

					/*if($cmp_id[0]->office_shift_id == 0){


        }else{*/
					// Make Table field. Eg: thursday_out_time
					$table_field_in_time = $week_day_lower . '_in_time';
					$table_field_out_time = $week_day_lower . '_out_time';


					$this->db->where('office_shift_id', $cmp_id[0]->office_shift_id);
					$office_shift = $this->db->get('xin_office_shift')->row();

					$shift_start = $office_shift->$table_field_in_time;
					$shift_end = $office_shift->$table_field_out_time;
					if (empty($shift_start)) {
						$weekends = "yes";
					}

					$getfirstrecord = $this->Timesheet_model->get_first_record($empid, $attendance_date);
					$first_clockin = $getfirstrecord[0]->clock_in;

					if ($emp_clockin == $first_clockin) {
						$work_clkin = new DateTime($clock_in2);
						$work_on_duty = new DateTime($on_duty3);
						$clkin_diff = strtotime($clock_in2) - strtotime($on_duty3);
						$interval_clkin = $work_clkin->diff($work_on_duty);
						$hoursin = $interval_clkin->format('%h');
						$minutesin = $interval_clkin->format('%i');
						$minutes_to_hour = round($minutesin / 60, 2);
						$late_by_hours = $hoursin + $minutes_to_hour;

						if ($late_by_hours > 0 && $clkin_diff > 0 && $weekends !== "yes" && $holiday_check !== "yes") {
							$getemp = $this->Employees_model->get_employee_details($empid);
							$basic_sal = $getemp[0]->basic_salary;
							$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
							$late_deduct = round($latededuction, 3);
						} else {
							$late_by_hours = 0;
							$late_deduct = 0;
						}
					}
				}


				//Overtime Start


				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$weekend = $overtime_consts[0]->weekend;
				$holiday = $overtime_consts[0]->holiday;
				$workingday = $overtime_consts[0]->workingday;
				$timeshift_from = $overtime_consts[0]->timeshift_from;
				$timeshift_to = $overtime_consts[0]->timeshift_to;
				$timeshift_percent = $overtime_consts[0]->timeshift_percent;
				$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
				$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
				$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;

				$timeshiftfrom = $attendance_date . ' ' . $timeshift_from;
				$nextdate = date('Y-m-d', strtotime($attendance_date . " +1 days"));
				$timeshiftto = $nextdate . ' ' . $timeshift_to;

				$off_time = $attendance_date . ' ' . $evening_timeshift_from;
				$diff = strtotime($off_time) - strtotime($clock_out2);
				$timestamp = strtotime($attendance_date);
				$day = date('l', $timestamp);
				$user = $this->Employees_model->read_user_by_user_id($empid);
				$comp_id = $user[0]->company_id;
				$holidays = $this->Employees_model->get_holidays($comp_id);

				/* if (isset($holidays)) {
          foreach ($holidays as $row) {
            $startDate     =  $row->start_date;
            $endDate       =  $row->end_date;

            if (($attendance_date >= $startDate) && ($attendance_date <= $endDate)) {
              $holiday_check = "yes";
            }
          }
        }*/

				if ($day === "Friday") {
					$ot = "yes";
					$basic_pay = $user[0]->basic_salary;
					$p_date = date('Y-m', strtotime($attendance_date));
					$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($user[0]->user_id, $p_date, $basic_pay);
					$allowance_amount = $all_allo_and_dedct[0];
					$basic_payment = $basic_pay + $allowance_amount;
					$clk_out = new DateTime($clock_out2);
					$clk_in = new DateTime($clock_in2);
					$interval = $clk_out->diff($clk_in);
					$hours_in = $interval->format('%h');
					$minutes_in = $interval->format('%i');
					$min_to_hour = $minutes_in / 60;
					$normalot_hours = 0;
					$weekendpercent = ($weekend * 100) / 100;
					$extra_ot_hours = $hours_in + $min_to_hour;
					$extraot_hours = round($extra_ot_hours, 2);
					$amount = (($basic_payment / 30) / 8) * $extraot_hours * $weekendpercent;
					$roundamount = round($amount, 3);
				} elseif ($holiday_check === "yes") {
					$ot = "yes";
					$basic_pay = $user[0]->basic_salary;
					$p_date = date('Y-m', strtotime($attendance_date));
					$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($user[0]->user_id, $p_date, $basic_pay);
					$allowance_amount = $all_allo_and_dedct[0];
					$basic_payment = $basic_pay + $allowance_amount;
					$clk_out = new DateTime($clock_out2);
					$clk_in = new DateTime($clock_in2);
					$interval = $clk_out->diff($clk_in);
					$hours_in = $interval->format('%h');
					$minutes_in = $interval->format('%i');
					$min_to_hour = $minutes_in / 60;
					$normalot_hours = 0;
					$holidaypercent = ($holiday * 100) / 100;
					$extra_ot_hours = $hours_in + $min_to_hour;
					$extraot_hours = round($extra_ot_hours, 2);
					$amount = (($basic_payment / 30) / 8) * $extraot_hours * $holidaypercent;
					$roundamount = round($amount, 3);
					$holiday_check = "no";
				} elseif ($diff < 0 && $day !== "Friday" && $holiday_check !== "yes") {
					$ot = "yes";
					$basic_pay = $user[0]->basic_salary;
					$p_date = date('Y-m', strtotime($attendance_date));
					$all_allo_and_dedct = $this->Xin_model->payroll_all_dedctions_and_additions($user[0]->user_id, $p_date, $basic_pay);
					$allowance_amount = $all_allo_and_dedct[0];
					$basic_payment = $basic_pay + $allowance_amount;
					$cutoff_time = $attendance_date . ' ' . $timeshift_from;
					$dayend_cutoff = $nextdate . ' ' . $timeshift_to;
					$diff_in_hrs = (strtotime($cutoff_time) - strtotime($clock_out2)) / 3600;
					$evening_cutoff_time = $attendance_date . ' ' . $evening_timeshift_to;

					$normalovertime = (strtotime($evening_timeshift_to) - strtotime($evening_timeshift_from)) / 3600;
					$extraovertime = (strtotime($timeshiftto) - strtotime($timeshiftfrom)) / 3600;

					if ($diff_in_hrs >= 0 && $diff_in_hrs <= $normalovertime) {
						$clk_out = new DateTime($clock_out2);
						$clk_in = new DateTime($clock_in2);
						$workedhours = (strtotime($off_time) - strtotime($clock_in2)) / 3600;

						if ($workedhours <= 0) {

							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$normal_ot_hours = $hours_in + $min_to_hour;
							$normalot_hours = round($normal_ot_hours, 2);
						} elseif ($workedhours > 0) {
							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$normal_ot_hours = $hours_in + $min_to_hour - $workedhours;
							$normalot_hours = round($normal_ot_hours, 2);
						}

						$workingdaypercent = ($workingday * 100) / 100;
						$extraot_hours = 0;
						$amount = (($basic_payment / 30) / 8) * $normalot_hours * $workingdaypercent;
						$roundamount = round($amount, 3);
					} elseif ($diff_in_hrs < 0) {
						$normalovertimehours = (strtotime($evening_cutoff_time) - strtotime($clock_in2)) / 3600;
						$diff_in_hrs = (strtotime($cutoff_time) - strtotime($clock_out)) / 3600;

						$clk_out = new DateTime($clock_out2);
						$clk_in = new DateTime($clock_in2);
						$workedhours = (strtotime($off_time) - strtotime($clock_in2)) / 3600;

						if ($workedhours <= 0) {
							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$workingdaypercent = ($workingday * 100) / 100;
							$timeshiftpercent = ($timeshift_percent * 100) / 100;
							$extra_ot_hours = $hours_in + $min_to_hour;
							$difference_in_hrs = (strtotime($clock_out2) - strtotime($cutoff_time)) / 3600;

							if ($difference_in_hrs > $extraovertime) {
								$difference = $difference_in_hrs - $extraovertime;
								$extra_ot_hours = $extra_ot_hours - $difference;
							}
							if ($normalovertimehours > 0) {
								$normalot_hours = $normalovertimehours;
								$extra_ot_hours = $extra_ot_hours - $normalot_hours;
							} else {
								$normalot_hours = 0;
							}
						} elseif ($workedhours > 0) {
							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$workingdaypercent = ($workingday * 100) / 100;
							$timeshiftpercent = ($timeshift_percent * 100) / 100;
							$extra_ot_hours = $hours_in + $min_to_hour;

							if ($normalovertimehours > 0) {
								$normalot_hours = $normalovertimehours - $workedhours;
								$extra_ot_hours = $extra_ot_hours - $normalot_hours - $workedhours;
							} else {
								$normalot_hours = 0;
							}
						}

						$extraot_hours = round($extra_ot_hours, 2);
						$amount = (($basic_payment / 30) / 8) * $extraot_hours * $timeshiftpercent + (($basic_payment / 30) / 8) * $normalot_hours * $workingdaypercent;
						$roundamount = round($amount, 3);
					}
				} else {
					$ot = "no";
					$normalot_hours = 0;
					$extraot_hours = 0;
					$roundamount = 0;
				}

				//Overtime End

				$data = array(
					'employee_id' => $empid,
					'attendance_date' => $attendance_date,
					'clock_in' => $clock_in2,
					'clock_in_time' => date('H:i', strtotime($clock_in2)),
					'clock_out' => $clock_out2,
					'clock_out_time' => date('H:i', strtotime($clock_out2)),
					'time_late' => $clock_in2,
					'total_work' => $total_work,
					'early_leaving' => $clock_out2,
					'overtime' => $clock_out2,
					'attendance_status' => 'Present',
					'clock_in_out' => '0',
					'total_work_hours' => $work_by_hours,
					'late_by_hours' => $late_by_hours,
					'late_deduction' => $late_deduct
				);
			}

			$result = $this->Timesheet_model->update_attendance_record($data, $id);

			if ($result == TRUE) {

				# NEW: Update totals

				$user = $this->Employees_model->read_employee_information($empid);
				// $late = '00:00';
				// if ($user[0]->late_deduction == 1) {
				$late = $this->Misc_model->find_late1($attendance_date, $empid);
				// }
				$early_leaving_time = $this->Misc_model->find_early_leaving1($attendance_date, $empid);
				$overtime_time = $this->Misc_model->find_overtime1($attendance_date, $empid);
				$rest = $this->Misc_model->find_rest($attendance_date, $empid);
				$work = $this->Misc_model->find_work_total($attendance_date, $empid);


				//overtime calculations start

				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$timeshift_from = $overtime_consts[0]->timeshift_from;
				$timeshift_to = $overtime_consts[0]->timeshift_to;
				$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
				$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
				//global $weekend;

				$normal_ot_secs = 0;
				$extra_ot_secs = 0;

				if ($user[0]->office_shift_id == 0) {
					$month = date('Y-m', strtotime($attendance_date));
					$office_shift = $this->Office_shift_custom_model->employee_current_shift($empid, $month);
					$day = date('j', strtotime($attendance_date));
					$out_time = $day . '_out';

					$shift_end_time = strtotime($office_shift[$out_time]);

					$shift_out_time_seconds = $shift_end_time;

					$normal_ot_end_secs = strtotime($attendance_date . ' 19:00:00');
					$extra_ot_secs = 0;
					$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
					$extra_ot_end_secs = strtotime($attendance_date1 . ' 07:00:00');
					$normal_ot_end_secs_last = strtotime($attendance_date1 . ' 08:00:00');

					$this->db->where('employee_id', $empid);
					$this->db->where('attendance_date', $attendance_date);
					$attendances = $this->db->get('xin_attendance_time');

					$overtime_seconds = 0;

					if ($attendances->num_rows() > 0) {
						foreach ($attendances->result() as $attendance) {

							$clock_in_seconds = strtotime($attendance->clock_in);
							$clock_out_seconds = strtotime($attendance->clock_out);

							if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
								$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

								for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
									if ($i < $normal_ot_end_secs) {
										$normal_ot_secs += 1;
									} else if ($i < $extra_ot_end_secs) {
										$extra_ot_secs += 1;
									} else if ($i < $normal_ot_end_secs_last) {
										$normal_ot_secs += 1;
									}
								}
							} else if ($clock_in_seconds > $shift_out_time_seconds) {
								$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

								for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
									if ($i < $normal_ot_end_secs) {
										$normal_ot_secs += 1;
									} else if ($i < $extra_ot_end_secs) {
										$extra_ot_secs += 1;
									} else if ($i < $normal_ot_end_secs_last) {
										$normal_ot_secs += 1;
									}
								}
							}
						}
					}

					// Deduct late time
					$late_hours = $this->Misc_model->find_late1($attendance_date, $empid);
					$late_seconds = $this->Misc_model->hm2sec($late_hours);

					//$overtime_seconds -= $late_seconds;
					$normal_ot_secs -= $late_seconds;

					if ($normal_ot_secs < 0) {
						$extra_ot_secs -= abs($normal_ot_secs);
						if ($extra_ot_secs < 0)
							$extra_ot_secs = 0;
						$normal_ot_secs = 0;
					}


					//echo $office_shift[$out_time];
					//print_r($office_shift);
				} else {


					// Find week day
					$week_day = date('l', strtotime($attendance_date));
					$week_day_lower = strtolower($week_day);

					// Make Table field. Eg: thursday_out_time
					$table_field_in_time = $week_day_lower . '_in_time';
					$table_field_out_time = $week_day_lower . '_out_time';

					$this->db->where('office_shift_id', $user[0]->office_shift_id);
					$office_shift = $this->db->get('xin_office_shift')->row();

					$shift_start = $office_shift->$table_field_in_time;
					$shift_end = $office_shift->$table_field_out_time;
					if (empty($shift_start)) {
						$weekend = "yes";
					}

					$shift_start_secs = $this->Misc_model->hm2sec($shift_start);
					$shift_end_secs = $this->Misc_model->hm2sec($shift_end);

					$normal_ot_secs = $extra_ot_secs = 0;

					if ($shift_end_secs < $shift_start_secs) {

						// Night shift ends next day
						$shift_end_date = date('Y-m-d', strtotime($attendance_date . " +1 days"));

						$shift_end = "$shift_end_date $shift_end";
						$shift_end_time = strtotime($shift_end);

						$shift_out_time_seconds = $shift_end_time;


						$normal_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_from);
						$extra_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_to);
						$extra_ot_end_secs_last = strtotime($shift_end_date . ' ' . $shift_start);

						$this->db->where('employee_id', $user[0]->user_id);
						$this->db->where('attendance_date', $attendance_date);
						$attendances = $this->db->get('xin_attendance_time');

						if ($attendances->num_rows() > 0) {
							foreach ($attendances->result() as $attendance) {
								$clock_in_seconds = strtotime($attendance->clock_in);
								$clock_out_seconds = strtotime($attendance->clock_out);

								if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
									for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs_last) {
											$extra_ot_secs += 1;
										}
									}
								} else if ($clock_in_seconds > $shift_out_time_seconds) {
									for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs_last) {
											$extra_ot_secs += 1;
										}
									}
								}
							}
						}

						// Deduct late time
						$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
						$late_seconds = $this->Misc_model->hm2sec($late_hours);

						//$overtime_seconds -= $late_seconds;
						$extra_ot_secs -= $late_seconds;

						if ($extra_ot_secs < 0) {
							$normal_ot_secs -= abs($extra_ot_secs);
							if ($normal_ot_secs < 0)
								$normal_ot_secs = 0;

							$extra_ot_secs = 0;
						}
					} else {

						$shift_end = "$attendance_date $shift_end";
						$shift_end_time = strtotime($shift_end);

						$shift_out_time_seconds = $shift_end_time;

						$normal_ot_end_secs = strtotime($attendance_date . ' ' . $timeshift_from);
						$extra_ot_secs = 0;
						$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
						$extra_ot_end_secs = strtotime($attendance_date1 . ' ' . $timeshift_to);
						$normal_ot_end_secs_last = strtotime($attendance_date1 . ' ' . $shift_start);

						$this->db->where('employee_id', $user[0]->user_id);
						$this->db->where('attendance_date', $attendance_date);
						$attendances = $this->db->get('xin_attendance_time');

						$overtime_seconds = 0;

						if ($attendances->num_rows() > 0) {
							foreach ($attendances->result() as $attendance) {
								$clock_in_seconds = strtotime($attendance->clock_in);
								$clock_out_seconds = strtotime($attendance->clock_out);

								if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
									$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

									for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs_last) {
											$normal_ot_secs += 1;
										}
									}
								} else if ($clock_in_seconds > $shift_out_time_seconds) {
									$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

									for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
										if ($i < $normal_ot_end_secs) {
											$normal_ot_secs += 1;
										} else if ($i < $extra_ot_end_secs) {
											$extra_ot_secs += 1;
										} else if ($i < $normal_ot_end_secs_last) {
											$normal_ot_secs += 1;
										}
									}
								}
							}
						}

						// Deduct late time
						$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
						$late_seconds = $this->Misc_model->hm2sec($late_hours);

						//$overtime_seconds -= $late_seconds;
						$normal_ot_secs -= $late_seconds;

						if ($normal_ot_secs < 0) {
							$extra_ot_secs -= abs($normal_ot_secs);
							if ($extra_ot_secs < 0)
								$extra_ot_secs = 0;
							$normal_ot_secs = 0;
						}
					}

					//$timestamp = strtotime($attendance_date);
					//$day = date('l', $timestamp);
					/*$comp_id       =  $user[0]->company_id;
        $holidays      =  $this->Employees_model->get_holidays($comp_id);

        if (isset($holidays)) {
          foreach ($holidays as $row) {
            $startDate     =  $row->start_date;
            $endDate       =  $row->end_date;

            if (($attendance_date >= $startDate) && ($attendance_date <= $endDate)) {
              $holiday_check = "yes";
            }
          }
        }
        if ($weekend === "yes" || $holiday_check === "yes") {
          $ot_seconds  = $this->Misc_model->hm2sec($work);
        } else {
          $ot_seconds  = $this->Misc_model->hm2sec($overtime_time);
        }
        unset($weekend);
        unset($holiday_check);*/
				}
				//overtime calculations end

				// if Holiday, overtime will be total-work
				$day_status_employee = $this->Misc_model->day_status_employee($attendance_date, $empid);
				if (in_array($day_status_employee, array('H', 'PH'))) {
					$overtime_time = $work;
					$extra_ot_secs = $this->Misc_model->hm2sec($overtime_time);
					$normal_ot_secs = 0;
					$late = $early_leaving_time = '00:00';
				}

				$ot_seconds = $this->Misc_model->hm2sec($overtime_time);

				$this->Misc_model->save($attendance_date, $empid, array(
					'late' => $late,
					'early_leaving' => $early_leaving_time,
					'rest' => $rest,
					'overtime' => $overtime_time,
					'work' => $work,
					'ot_seconds' => $ot_seconds,
					'normal_ot_seconds' => $normal_ot_secs,
					'extra_ot_seconds' => $extra_ot_secs
				));
				#-----------------#

				$Return['result'] = $this->lang->line('xin_success_attendance_update');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and update info in database
	public function default_shift()
	{

		if ($this->input->get('office_shift_id')) {

			$id = $this->input->get('office_shift_id');

			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$data = array(
				'default_shift' => '0'
			);

			$data2 = array(
				'default_shift' => '1'
			);

			$result = $this->Timesheet_model->update_default_shift_zero($data);
			$result = $this->Timesheet_model->update_default_shift_record($data2, $id);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_shift_default_made');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and add info in database
	public function add_office_shift()
	{

		if ($this->input->post('add_type') == 'office_shift') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('shift_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_name_field');
			} else if ($this->input->post('monday_in_time') != '' && $this->input->post('monday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_monday_timeout');
			} else if ($this->input->post('tuesday_in_time') != '' && $this->input->post('tuesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_tuesday_timeout');
			} else if ($this->input->post('wednesday_in_time') != '' && $this->input->post('wednesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_wednesday_timeout');
			} else if ($this->input->post('thursday_in_time') != '' && $this->input->post('thursday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_thursday_timeout');
			} else if ($this->input->post('friday_in_time') != '' && $this->input->post('friday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_friday_timeout');
			} else if ($this->input->post('saturday_in_time') != '' && $this->input->post('saturday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_saturday_timeout');
			} else if ($this->input->post('sunday_in_time') != '' && $this->input->post('sunday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_sunday_timeout');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'shift_name' => $this->input->post('shift_name'),
				'company_id' => $this->input->post('company_id'),
				'late_allowed_till' => $this->input->post('late_allowed_till'),
				'total_working_hours' => $this->input->post('total_working_hours'),
				'monday_in_time' => $this->input->post('monday_in_time'),
				'monday_out_time' => $this->input->post('monday_out_time'),
				'tuesday_in_time' => $this->input->post('tuesday_in_time'),
				'tuesday_out_time' => $this->input->post('tuesday_out_time'),
				'wednesday_in_time' => $this->input->post('wednesday_in_time'),
				'wednesday_out_time' => $this->input->post('wednesday_out_time'),
				'thursday_in_time' => $this->input->post('thursday_in_time'),
				'thursday_out_time' => $this->input->post('thursday_out_time'),
				'friday_in_time' => $this->input->post('friday_in_time'),
				'friday_out_time' => $this->input->post('friday_out_time'),
				'saturday_in_time' => $this->input->post('saturday_in_time'),
				'saturday_out_time' => $this->input->post('saturday_out_time'),
				'sunday_in_time' => $this->input->post('sunday_in_time'),
				'sunday_out_time' => $this->input->post('sunday_out_time'),
				'created_at' => date('Y-m-d')
			);
			$result = $this->Timesheet_model->add_office_shift_record($data);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_shift_added');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// Validate and update info in database
	public function edit_office_shift()
	{

		if ($this->input->post('edit_type') == 'shift') {

			$id = $this->uri->segment(4);

			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('shift_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_name_field');
			} else if ($this->input->post('monday_in_time') != '' && $this->input->post('monday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_monday_timeout');
			} else if ($this->input->post('tuesday_in_time') != '' && $this->input->post('tuesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_tuesday_timeout');
			} else if ($this->input->post('wednesday_in_time') != '' && $this->input->post('wednesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_wednesday_timeout');
			} else if ($this->input->post('thursday_in_time') != '' && $this->input->post('thursday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_thursday_timeout');
			} else if ($this->input->post('friday_in_time') != '' && $this->input->post('friday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_friday_timeout');
			} else if ($this->input->post('saturday_in_time') != '' && $this->input->post('saturday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_saturday_timeout');
			} else if ($this->input->post('sunday_in_time') != '' && $this->input->post('sunday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_sunday_timeout');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}

			$data = array(
				'shift_name' => $this->input->post('shift_name'),
				'company_id' => $this->input->post('company_id'),
				'late_allowed_till' => $this->input->post('late_allowed_till'),
				'total_working_hours' => $this->input->post('total_working_hours'),
				'monday_in_time' => $this->input->post('monday_in_time'),
				'monday_out_time' => $this->input->post('monday_out_time'),
				'tuesday_in_time' => $this->input->post('tuesday_in_time'),
				'tuesday_out_time' => $this->input->post('tuesday_out_time'),
				'wednesday_in_time' => $this->input->post('wednesday_in_time'),
				'wednesday_out_time' => $this->input->post('wednesday_out_time'),
				'thursday_in_time' => $this->input->post('thursday_in_time'),
				'thursday_out_time' => $this->input->post('thursday_out_time'),
				'friday_in_time' => $this->input->post('friday_in_time'),
				'friday_out_time' => $this->input->post('friday_out_time'),
				'saturday_in_time' => $this->input->post('saturday_in_time'),
				'saturday_out_time' => $this->input->post('saturday_out_time'),
				'sunday_in_time' => $this->input->post('sunday_in_time'),
				'sunday_out_time' => $this->input->post('sunday_out_time')
			);

			$result = $this->Timesheet_model->update_shift_record($data, $id);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_shift_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// delete attendance record
	public function delete_attendance()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$attendance_info = $this->Timesheet_model->read_attendance_information($id);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_attendance_record($id);
			if (isset($id)) {
				$this->db->where('employee_id', $attendance_info[0]->employee_id);
				$this->db->where('attendance_date', $attendance_info[0]->attendance_date);
				$att = $this->db->get('xin_attendance_time');

				if ($att->num_rows() == 0) {
					$this->db->where('employee_id', $attendance_info[0]->employee_id);
					$this->db->where('date', $attendance_info[0]->attendance_date);
					$this->db->delete('xin_attendance_time_total');
				} else {
					# NEW: Update totals
					$clock_in2 = $attendance_info[0]->attendance_date;
					$empid = $attendance_info[0]->employee_id;
					$late = $this->Misc_model->find_late1($clock_in2, $empid);
					$early_leaving_time = $this->Misc_model->find_early_leaving1($clock_in2, $empid);
					$overtime_time = $this->Misc_model->find_overtime1($clock_in2, $empid);
					$rest = $this->Misc_model->find_rest($clock_in2, $empid);
					$work = $this->Misc_model->find_work_total($clock_in2, $empid);

					$this->Misc_model->save($clock_in2, $empid, array(
						'late' => $late,
						'early_leaving' => $early_leaving_time,
						'rest' => $rest,
						'overtime' => $overtime_time,
						'work' => $work,
					));
					#-----------------#
				}

				$Return['result'] = $this->lang->line('xin_success_employe_attendance_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	// delete holiday record
	public function delete_holiday()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_holiday_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_holiday_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	// delete shift record
	public function delete_shift()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_shift_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_shift_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	// delete leave record
	public function delete_leave()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$timesheet = $this->Timesheet_model->read_leave_information($id);
			if ($timesheet[0]->leave_type_id == 4) {
				$cond = array('leave_id' => $id, 'emp_id' => $timesheet[0]->employee_id);
				$check_sick_mangement_exists = $this->Timesheet_model->common_select('xin_emp_sickleave_manage', $cond);
				if ($check_sick_mangement_exists) {
					$result = $this->Timesheet_model->delete_common('xin_emp_sickleave_manage', $id);
				}
			}
			if ($timesheet[0]->status == 2) {
				$hlfcounts = 0;
				$count_ls = 0;
				$leaves_id = $timesheet[0]->leave_type_id;
				$employees_id = $timesheet[0]->employee_id;
				$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
				$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
				//$total =$type[0]->days_per_year;
				$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employees_id, $leaves_id);
				$total = $carry_count[0]->remaing_leave_count;
				$days = $timesheet[0]->days;
				if ($timesheet[0]->is_half_day == 1) {
					$days = 0.5;
				}
				if ($leaves_id == 7) {
					$leave_remaining_total = $total - $days;
					if ($leave_remaining_total < 0) {
						$leave_remaining_total = 0;
					} else {
						$leave_remaining_total = $leave_remaining_total;
					}
				} else {
					$leave_remaining_total = $total + $days;
				}

				/*$this->db->where('employee_id', $timesheet[0]->employee_id);
				$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
				//$this->db->where('create_date', date('Y-m-d'));
				$result = $this->db->get('carry_leaves');*/
				$date_arr = explode("-", $timesheet[0]->from_date);
				$year_check = $date_arr[0];
				$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
				if ($result->num_rows() == 0) {
					$data_insert = array(
						'employee_id' => $timesheet[0]->employee_id,
						'leave_type_id' => $timesheet[0]->leave_type_id,
						'remaing_leave_count' => $leave_remaining_total,
						'create_date' => date('Y-m-d')
					);
					$data_result = $this->Timesheet_model->carry_insert($data_insert);
				} else {
					$carry_leave = $result->result(); //print_r($carry_leave);exit;
					$data_update = array(
						'employee_id' => $timesheet[0]->employee_id,
						'leave_type_id' => $timesheet[0]->leave_type_id,
						'remaing_leave_count' => $leave_remaining_total,
						//'create_date'=> date('Y-m-d')
					);
					$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
				}
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			/*
			if exits in unpaid section */
			$check_unpaid_leaves_exits = $this->Timesheet_model->getNormalUnpaidLeaves($id);
			if (!empty($check_unpaid_leaves_exits)) {
				$timesheet = $this->Timesheet_model->read_leave_information($check_unpaid_leaves_exits[0]->leave_id);
				if ($timesheet[0]->status == 2) {
					$hlfcounts = 0;
					$count_ls = 0;
					$leaves_id = $timesheet[0]->leave_type_id;
					$employees_id = $timesheet[0]->employee_id;
					$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
					$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
					//$total =$type[0]->days_per_year;
					$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employees_id, $leaves_id);
					if ($carry_count) {
						$total = $carry_count[0]->remaing_leave_count;
						$days = $timesheet[0]->days;
						if ($timesheet[0]->is_half_day == 1) {
							$days = 0.5;
						}
						$leave_remaining_total = $total - $days;
					} else {
						$leave_remaining_total = 0;
					}
					if ($leaves_id == 7) {
						if ($leave_remaining_total < 0) {
							$leave_remaining_total = 0;
						}
					}
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
					if ($result->num_rows() == 0) {
						$data_insert = array(
							'employee_id' => $timesheet[0]->employee_id,
							'leave_type_id' => $timesheet[0]->leave_type_id,
							'remaing_leave_count' => $leave_remaining_total,
							'create_date' => date('Y-m-d')
						);
						$data_result = $this->Timesheet_model->carry_insert($data_insert);
					} else {
						$carry_leave = $result->result(); //print_r($carry_leave);exit;
						$data_update = array(
							'employee_id' => $timesheet[0]->employee_id,
							'leave_type_id' => $timesheet[0]->leave_type_id,
							'remaing_leave_count' => $leave_remaining_total,
							//'create_date'=> date('Y-m-d')
						);
						$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
					}
				}
				$remove_unpaid_leaves = $this->Timesheet_model->deleteUnpaidLeavesNormal($id);
			}
			/* end unpaid section */

			$result = $this->Timesheet_model->delete_leave_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_leave_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	public function delete_task()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_task_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_task_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	public function delete_variation()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Timesheet_model->delete_variation_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_project_variation_added_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	// Validate and update info in database // add_note
	public function add_note_validate()
	{

		if ($this->input->post('type') == 'add_note') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			if ($this->input->post('task_note') === '') {

				$Return['error'] = "Task note is blank";
			}
			$this->output($Return);
			exit;
		}
	}

	public function add_note()
	{

		if ($this->input->post('type') == 'add_note') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$data = array(
				'task_note' => $this->input->post('task_note')
			);
			$id = $this->input->post('note_task_id');
			$result = $this->Timesheet_model->update_task_record($data, $id);
			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_task_note_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	// monthly timesheet
	public function timesheet_monthly_employees()
	{
		/* Define return | here result is used to return user data and error for error message */
		$xin_employees = $this->Xin_model->all_employees();
		foreach ($xin_employees as $hr_user) {

			$full_name = $hr_user->first_name . ' ' . $hr_user->middle_name . ' ' . $hr_user->last_name;
			$designation = $this->Designation_model->read_designation_information($hr_user->designation_id);
			if (!is_null($designation)) {
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($hr_user->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
			$user_info = $full_name . ' (' . $designation_name . ')';

			$someArray[] = array(
				'id' => $hr_user->user_id,
				'title' => $user_info,
				'employee_present' => $hr_user->user_id
			);
		}
		$this->output($someArray);
		exit;
	}

	// monthly timesheet resources
	public function timesheet_monthly_resources()
	{
		/* Define return | here result is used to return user data and error for error message */
		$someArray = array();
		$xin_employees = $this->Xin_model->all_employees();
		/*$date = strtotime(date("Y-m-d"));
		$day = date('d', $date);
		$month = date('m', $date);
		$year = date('Y', $date);
		$month_year = date('Y-m');*/
		$month_year = $this->input->post('month_year');
		if (isset($month_year)) {
			$date = strtotime($this->input->post('month_year') . '-01');
			$imonth_year = explode('-', $this->input->post('month_year'));
			$day = date('d', $date);
			$month = date($imonth_year[1], $date);
			$year = date($imonth_year[0], $date);
			$month_year = $this->input->get('month_year');
		} else {
			$date = strtotime(date("Y-m-d"));
			//$date = strtotime('2020-05-01');
			$day = date('d', $date);
			$month = date('m', $date);
			$year = date('Y', $date);
			$month_year = date('Y-m');
		}
		// total days in month
		$daysInMonth = date('t');

		$imonth = date('F', $date);
		$j = 0;
		foreach ($xin_employees as $r) {

			// user full name
			$full_name = $r->first_name . ' ' . $r->middle_name . ' ' . $r->last_name;
			// get designation
			/*$designation = $this->Designation_model->read_designation_information($r->designation_id);
			if(!is_null($designation)){
				$designation_name = $designation[0]->designation_name;
			} else {
				$designation_name = '--';
			}
			// department
			$department = $this->Department_model->read_department_information($r->department_id);
			if(!is_null($department)){
			$department_name = $department[0]->department_name;
			} else {
			$department_name = '--';
			}*/
			//	$department_designation = $designation_name.' ('.$department_name.')';$pcount=0;

			for ($i = 1; $i <= $daysInMonth; $i++) :
				$i = str_pad($i, 2, 0, STR_PAD_LEFT);
				// get date <
				$attendance_date = $year . '-' . $month . '-' . $i;
				$tdate = $year . '-' . $month . '-' . $i;
				$get_day = strtotime($attendance_date);
				$day = date('l', $get_day);
				$user_id = $r->user_id;
				// office shift
				if ($r->office_shift_id == 0) {
					// get holiday
					$h_date_chck = $this->Timesheet_model->holiday_date_check($attendance_date);
					$holiday_arr = array();
					if ($h_date_chck->num_rows() == 1) {
						$h_date = $this->Timesheet_model->holiday_date($attendance_date);
						$begin = new DateTime($h_date[0]->start_date);
						$end = new DateTime($h_date[0]->end_date);
						$end = $end->modify('+1 day');

						$interval = new DateInterval('P1D');
						$daterange = new DatePeriod($begin, $interval, $end);

						foreach ($daterange as $date) {
							$holiday_arr[] = $date->format("Y-m-d");
						}
					} else {
						$holiday_arr[] = '99-99-99';
					}
					//echo '<pre>'; print_r($holiday_arr);
					// get leave/employee
					$leave_date_chck = $this->Timesheet_model->leave_date_check($r->user_id, $attendance_date);
					$leave_arr = array();
					if ($leave_date_chck->num_rows() == 1) {
						$leave_date = $this->Timesheet_model->leave_date($r->user_id, $attendance_date);
						$begin1 = new DateTime($leave_date[0]->from_date);
						$end1 = new DateTime($leave_date[0]->to_date);
						$end1 = $end1->modify('+1 day');

						$interval1 = new DateInterval('P1D');
						$daterange1 = new DatePeriod($begin1, $interval1, $end1);

						foreach ($daterange1 as $date1) {
							$leave_arr[] = $date1->format("Y-m-d");
						}
					} else {
						$leave_arr[] = '99-99-99';
					}

					$attendance_status = '';

					$day = date('j', $get_day);
					$table_field = $day . '_in';

					$office_shift = $this->Office_shift_custom_model->employee_current_shift($user_id, $month_year);

					if (!$office_shift) {
						$status = 'H';
					} else if (!$office_shift[$table_field] || $office_shift[$table_field] == '') {
						$status = 'H';
					} else if (in_array($attendance_date, $holiday_arr)) { // holiday
						$status = 'H';
					} else if (in_array($attendance_date, $leave_arr)) { // on leave
						$status = 'L';
					} else {
						$check = $this->Timesheet_model->attendance_first_in_check($r->user_id, $attendance_date);
						if ($check->num_rows() > 0) {
							$status = 'P';
						} else {
							$status = 'A';
						}
					}
				} else {
					$office_shift = $this->Timesheet_model->read_office_shift_information($r->office_shift_id);

					// get holiday
					$h_date_chck = $this->Timesheet_model->holiday_date_check($attendance_date);
					$holiday_arr = array();
					if ($h_date_chck->num_rows() == 1) {
						$h_date = $this->Timesheet_model->holiday_date($attendance_date);
						$begin = new DateTime($h_date[0]->start_date);
						$end = new DateTime($h_date[0]->end_date);
						$end = $end->modify('+1 day');

						$interval = new DateInterval('P1D');
						$daterange = new DatePeriod($begin, $interval, $end);

						foreach ($daterange as $date) {
							$holiday_arr[] = $date->format("Y-m-d");
						}
					} else {
						$holiday_arr[] = '99-99-99';
					}
					//echo '<pre>'; print_r($holiday_arr);
					// get leave/employee
					$leave_date_chck = $this->Timesheet_model->leave_date_check($r->user_id, $attendance_date);
					$leave_arr = array();
					if ($leave_date_chck->num_rows() == 1) {
						$leave_date = $this->Timesheet_model->leave_date($r->user_id, $attendance_date);
						$begin1 = new DateTime($leave_date[0]->from_date);
						$end1 = new DateTime($leave_date[0]->to_date);
						$end1 = $end1->modify('+1 day');

						$interval1 = new DateInterval('P1D');
						$daterange1 = new DatePeriod($begin1, $interval1, $end1);

						foreach ($daterange1 as $date1) {
							$leave_arr[] = $date1->format("Y-m-d");
						}
					} else {
						$leave_arr[] = '99-99-99';
					}
					$attendance_status = '';
					$check = $this->Timesheet_model->attendance_first_in_check($r->user_id, $attendance_date);
					if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
						$status = 'H';
					} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
						$status = 'H';
					} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
						$status = 'H';
					} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
						$status = 'H';
					} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
						$status = 'H';
					} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
						$status = 'H';
					} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
						$status = 'H';
					} else if (in_array($attendance_date, $holiday_arr)) { // holiday
						$status = 'H';
					} else if (in_array($attendance_date, $leave_arr)) { // on leave
						$status = 'L';
					} else if ($check->num_rows() > 0) {
						$attendance = $this->Timesheet_model->attendance_first_in($r->user_id, $attendance_date);
						$status = 'P';
					} else {
						$status = 'A';
						//$pcount += 0;
					}
				}
				//$pcount += $check->num_rows();
				// set to present date
				$iattendance_date = strtotime($attendance_date);
				//$icurrent_date = strtotime(date('Y-m-d'));
				$status = $status;
				/*if($iattendance_date <= $icurrent_date){
					$status = $status;
				} else {
					$status = '1';
				}*/
				$idate_of_joining = strtotime($r->date_of_joining);
				if ($idate_of_joining < $iattendance_date) {
					$status = $status;
				} else {
					$status = '';
				}

				$someArray[] = array(
					'title' => $status,
					'resourceIds' => $r->user_id,
					'start' => $attendance_date,
					//  'end'   => $attendance_date,
				);
			endfor;
		}
		$this->output($someArray);
		exit;
	}

	// set clock in - clock out > attendance
	public function set_clocking()
	{

		if ($this->input->post('type') == 'set_clocking') {
			$system = $this->Xin_model->read_setting_info(1);
			//if($system[0]->system_ip_restriction == 'yes'){
			$sys_arr = explode(',', $system[0]->system_ip_address);
			//if(in_array($this->input->ip_address(),$sys_arr)) {
			//if($system[0]->system_ip_address == $this->input->ip_address()){
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$session = $this->session->userdata('username');

			$employee_id = $session['user_id'];
			$clock_state = $this->input->post('clock_state');
			$latitude = $this->input->post('latitude');
			$longitude = $this->input->post('longitude');
			$time_id = $this->input->post('time_id');
			// set time
			$nowtime = date("Y-m-d H:i:s");
			//$date = date('Y-m-d H:i:s', strtotime($nowtime . ' + 4 hours'));
			$date = date('Y-m-d H:i:s');
			$curtime = $date;
			$today_date = date('Y-m-d');
			$user = $this->Employees_model->read_user_by_user_id($employee_id);
			$comp_id = $user[0]->company_id;

			if ($clock_state == 'clock_in') {
				$query = $this->Timesheet_model->check_user_attendance();
				$result = $query->result();
				if ($query->num_rows() < 1) {
					$total_rest = '';

					# NEW:
					// $late_time = '00:00';
					// if ($user[0]->late_deduction == 1) {
					$late_time = $this->Misc_model->find_late($curtime, $user[0]->company_id, $user[0]->office_shift_id, $user[0]->user_id, $today_date);
					// }
					$this->db->insert('xin_attendance_time_total', array(
						'employee_id' => $employee_id,
						'date' => $curtime,
						'late' => $late_time,
					));
					#-----------------#
				} else {
					$cout = new DateTime($result[0]->clock_out);
					$cin = new DateTime($curtime);

					$interval_cin = $cin->diff($cout);
					$hours_in = $interval_cin->format('%h');
					$minutes_in = $interval_cin->format('%i');
					$total_rest = $hours_in . ":" . $minutes_in;
					$late_time = '00:00';

					# NEW: Update rest time
					/*$this->db->where('employee_id', $employee_id);
				    $this->db->where('date', date('Y-m-d', strtotime($result[0]->clock_in)));
				    $attendance_time_total = $this->db->get('xin_attendance_time_total');

				    if ($attendance_time_total->num_rows() > 0)
				    {
				        foreach ($attendance_time_total->result() as $time_total)
				        {
				            $rest_seconds = $time_total->rest_seconds;
				            $rest_seconds += 3600 * $interval_cin->h;
				            $rest_seconds += 60 * $interval_cin->i;
				            $rest = gmdate("H:i", $rest_seconds);
				            $early_leaving = '00:00';

				            $this->db->where('id', $time_total->id);
				            $this->db->update('xin_attendance_time_total', array(
				                'rest_seconds' => $rest_seconds,
				                'rest' => $rest,
				                'early_leaving' => $early_leaving,
				            ));
				        }
				    }*/
					#-----------------#
				}

				$data = array(
					'employee_id' => $employee_id,
					'attendance_date' => $today_date,
					'clock_in' => $curtime,
					'clock_in_time' => date('H:i', strtotime($curtime)),
					'clock_in_ip_address' => $this->input->ip_address(),
					'clock_in_latitude' => $latitude,
					'clock_in_longitude' => $longitude,
					'time_late' => $curtime,
					'early_leaving' => $curtime,
					'overtime' => $curtime,
					'total_rest' => $total_rest,
					'attendance_status' => 'Present',
					'clock_in_out' => '1'
				);

				$result = $this->Timesheet_model->add_new_attendance($data);

				if ($result == TRUE) {
					$Return['result'] = $this->lang->line('xin_success_clocked_in');
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			} else if ($clock_state == 'clock_out') {
				global $holiday_check;
				global $weekends;
				$query = $this->Timesheet_model->check_user_attendance_clockout();
				$clocked_out = $query->result();
				$total_work_cin = new DateTime($clocked_out[0]->clock_in);
				$total_work_cout = new DateTime($curtime);


				$interval_cin = $total_work_cout->diff($total_work_cin);
				$hours_in = $interval_cin->format('%h');
				$minutes_in = $interval_cin->format('%i');
				$total_work = $hours_in . ":" . $minutes_in;
				$work_mins_to_hour = round($minutes_in / 60, 2);
				$work_by_hours = $hours_in + $work_mins_to_hour;

				//print_r($user);

				$id = $this->input->post('time_id');
				$attend_details = $this->Timesheet_model->get_attendance_details($id);
				$clockin = $attend_details[0]->clock_in;

				$cmp_id = $this->Employees_model->get_employee_details($employee_id);
				$late_allowed = $this->Employees_model->get_lateallowed($cmp_id[0]->company_id);
				$on_duty3 = $today_date . ' ' . $late_allowed[0]->late_allowed_till;

				$overtime_consts = $this->Xin_model->get_all_overtime_constants();
				$weekend = $overtime_consts[0]->weekend;
				$holiday = $overtime_consts[0]->holiday;
				$workingday = $overtime_consts[0]->workingday;
				$timeshift_from = $overtime_consts[0]->timeshift_from;
				$timeshift_to = $overtime_consts[0]->timeshift_to;
				$timeshift_percent = $overtime_consts[0]->timeshift_percent;
				$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
				$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
				$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;

				$timeshiftfrom = $today_date . ' ' . $timeshift_from;
				$nextdate = date('Y-m-d', strtotime($today_date . " +1 days"));
				$timeshiftto = $nextdate . ' ' . $timeshift_to;

				$off_time = $today_date . ' ' . $evening_timeshift_from;
				$diff = strtotime($off_time) - strtotime($curtime);
				$timestamp = strtotime($today_date);
				$day = date('l', $timestamp);

				$holidays = $this->Employees_model->get_holidays($comp_id);
				if (isset($holidays)) {
					foreach ($holidays as $row) {

						$startDate = $row->start_date;
						$endDate = $row->end_date;
						if (($today_date >= $startDate) && ($today_date <= $endDate)) {
							$holiday_check = "yes";
						}
					}
				}

				if ($day === "Friday") {
					$ot = "yes";
					$basic_pay = $user[0]->basic_salary;
					$clk_out = new DateTime($curtime);
					$clk_in = new DateTime($clockin);
					$interval = $clk_out->diff($clk_in);
					$hours_in = $interval->format('%h');
					$minutes_in = $interval->format('%i');
					$min_to_hour = $minutes_in / 60;
					$normalot_hours = 0;
					$weekendpercent = ($weekend * 100) / 100;
					$extra_ot_hours = $hours_in + $min_to_hour;
					$extraot_hours = round($extra_ot_hours, 2);
					$amount = (($basic_pay / 30) / 8) * $extraot_hours * $weekendpercent;
					$roundamount = round($amount, 3);
				} elseif ($holiday_check === "yes") {
					$ot = "yes";
					$basic_pay = $user[0]->basic_salary;
					$clk_out = new DateTime($curtime);
					$clk_in = new DateTime($clockin);
					$interval = $clk_out->diff($clk_in);
					$hours_in = $interval->format('%h');
					$minutes_in = $interval->format('%i');
					$min_to_hour = $minutes_in / 60;
					$normalot_hours = 0;
					$holidaypercent = ($holiday * 100) / 100;
					$extra_ot_hours = $hours_in + $min_to_hour;
					$extraot_hours = round($extra_ot_hours, 2);
					$amount = (($basic_pay / 30) / 8) * $extraot_hours * $holidaypercent;
					$roundamount = round($amount, 3);
					$holiday_check = "no";
				} elseif ($diff < 0 && $day !== "Friday" && $holiday_check !== "yes") {

					$ot = "yes";
					$basic_pay = $user[0]->basic_salary;
					$cutoff_time = $today_date . ' ' . $timeshift_from;
					$dayend_cutoff = $nextdate . ' ' . $timeshift_to;
					$diff_in_hrs = (strtotime($cutoff_time) - strtotime($curtime)) / 3600;
					$evening_cutoff_time = $today_date . ' ' . $evening_timeshift_to;

					$normalovertime = (strtotime($evening_timeshift_to) - strtotime($evening_timeshift_from)) / 3600;
					$extraovertime = (strtotime($timeshiftto) - strtotime($timeshiftfrom)) / 3600;
					if ($diff_in_hrs >= 0 && $diff_in_hrs <= $normalovertime) {

						$clk_out = new DateTime($curtime);
						$clk_in = new DateTime($clockin);
						$workedhours = (strtotime($off_time) - strtotime($clockin)) / 3600;
						if ($workedhours <= 0) {

							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$normal_ot_hours = $hours_in + $min_to_hour;
							$normalot_hours = round($normal_ot_hours, 2);
						} elseif ($workedhours > 0) {
							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$normal_ot_hours = $hours_in + $min_to_hour - $workedhours;
							$normalot_hours = round($normal_ot_hours, 2);
						}

						$workingdaypercent = ($workingday * 100) / 100;
						$extraot_hours = 0;
						$amount = (($basic_pay / 30) / 8) * $normalot_hours * $workingdaypercent;
						$roundamount = round($amount, 3);
					} elseif ($diff_in_hrs < 0) {
						$normalovertimehours = (strtotime($evening_cutoff_time) - strtotime($clockin)) / 3600;
						$diff_in_hrs = (strtotime($cutoff_time) - strtotime($curtime)) / 3600;

						$clk_out = new DateTime($curtime);
						$clk_in = new DateTime($clockin);
						$workedhours = (strtotime($off_time) - strtotime($clockin)) / 3600;

						if ($workedhours <= 0) {

							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$workingdaypercent = ($workingday * 100) / 100;
							$timeshiftpercent = ($timeshift_percent * 100) / 100;
							$extra_ot_hours = $hours_in + $min_to_hour;
							$difference_in_hrs = (strtotime($curtime) - strtotime($cutoff_time)) / 3600;
							if ($difference_in_hrs > $extraovertime) {
								$difference = $difference_in_hrs - $extraovertime;
								$extra_ot_hours = $extra_ot_hours - $difference;
							}
							if ($normalovertimehours > 0) {
								$normalot_hours = round($normalovertimehours, 2);
								$extra_ot_hours = $extra_ot_hours - $normalot_hours;
							} else {
								$normalot_hours = 0;
							}
						} elseif ($workedhours > 0) {
							$interval = $clk_out->diff($clk_in);
							$hours_in = $interval->format('%h');
							$minutes_in = $interval->format('%i');
							$min_to_hour = $minutes_in / 60;
							$workingdaypercent = ($workingday * 100) / 100;
							$timeshiftpercent = ($timeshift_percent * 100) / 100;
							$extra_ot_hours = $hours_in + $min_to_hour;
							if ($normalovertimehours > 0) {
								$normalot_hours = $normalovertimehours - $workedhours;
								$extra_ot_hours = $extra_ot_hours - $normalot_hours - $workedhours;
							} else {
								$normalot_hours = 0;
							}
						}

						$extraot_hours = round($extra_ot_hours, 2);

						$amount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshiftpercent + (($basic_pay / 30) / 8) * $normalot_hours * $workingdaypercent;
						$roundamount = round($amount, 3);
					}
				} else {

					$ot = "no";
					$normalot_hours = 0;
					$extraot_hours = 0;
					$roundamount = 0;
				}


				if ($user[0]->office_shift_id == 0) {

					$late_allowed = $this->Office_shift_custom_model->employee_current_shift($user[0]->user_id, $today_date);
					$day = date('j', strtotime($today_date));
					$in_time = $day . "_in";
					if (!$late_allowed[$in_time]) {
						$late_by_hours = 0;
						$late_deduct = 0;
					} else {
						$on_duty3 = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' . $late_allowed['late_allowed_till'] . "mins"));
						if ($holiday_check !== "yes") {

							$attendence_check = $this->Employees_model->check_first_attendance($employee_id, $today_date);
							$work_clkin = new DateTime($clockin);
							$work_on_duty = new DateTime($on_duty3);
							$clkin_diff = strtotime($clockin) - strtotime($on_duty3);
							$interval_clkin = $work_clkin->diff($work_on_duty);
							$hoursin = $interval_clkin->format('%h');
							$minutesin = $interval_clkin->format('%i');
							$minutes_to_hour = round($minutesin / 60, 2);
							$late_by_hours = $hoursin + $minutes_to_hour;

							if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {

								$basic_sal = $user[0]->basic_salary;
								$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
								$late_deduct = round($latededuction, 3);
							} else {
								$late_by_hours = 0;
								$late_deduct = 0;
							}
						} else {
							$late_by_hours = 0;
							$late_deduct = 0;
						}
					}


					/*$late_allowed = $this->Office_shift_custom_model->employee_current_shift($user[0]->user_id, $today_date);
          if(!$late_allowed){
              $late_by_hours = 0;
              $late_deduct = 0;
          }else{
          $day          = date('j',strtotime($today_date));
          $in_time      = $day."_in";
          $on_duty3     = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' .$late_allowed['late_allowed_till']."mins" ));
          }*/
				} else {

					// Find week day
					$week_day = date('l', strtotime($today_date));
					$week_day_lower = strtolower($week_day);

					// Make Table field. Eg: thursday_out_time
					$table_field_in_time = $week_day_lower . '_in_time';
					$table_field_out_time = $week_day_lower . '_out_time';

					$this->db->where('office_shift_id', $user[0]->office_shift_id);
					$office_shift = $this->db->get('xin_office_shift')->row();

					$shift_start = $office_shift->$table_field_in_time;
					$shift_end = $office_shift->$table_field_out_time;
					if (empty($shift_start)) {
						$weekends = "yes";
					}

					if ($weekends !== "yes" && $holiday_check !== "yes") {

						$attendence_check = $this->Employees_model->check_first_attendance($employee_id, $today_date);
						$work_clkin = new DateTime($clockin);
						$work_on_duty = new DateTime($on_duty3);
						$clkin_diff = strtotime($clockin) - strtotime($on_duty3);
						$interval_clkin = $work_clkin->diff($work_on_duty);
						$hoursin = $interval_clkin->format('%h');
						$minutesin = $interval_clkin->format('%i');
						$minutes_to_hour = round($minutesin / 60, 2);
						$late_by_hours = $hoursin + $minutes_to_hour;

						if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {

							$basic_sal = $user[0]->basic_salary;
							$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
							$late_deduct = round($latededuction, 3);
						} else {
							$late_by_hours = 0;
							$late_deduct = 0;
						}
					} else {
						$late_by_hours = 0;
						$late_deduct = 0;
					}
				}


				$data = array(
					'employee_id' => $employee_id,
					'clock_out' => $curtime,
					'clock_out_time' => date('H:i', strtotime($curtime)),
					'clock_out_ip_address' => $this->input->ip_address(),
					'clock_out_latitude' => $latitude,
					'clock_out_longitude' => $longitude,
					'clock_in_out' => '0',
					'early_leaving' => $curtime,
					'overtime' => $curtime,
					'total_work' => $total_work,
					'ot' => $ot,
					'normal_ot_hours' => $normalot_hours,
					'extra_ot_hours' => $extraot_hours,
					'ot_amount' => $roundamount,
					'total_work_hours' => $work_by_hours,
					'late_by_hours' => $late_by_hours,
					'late_deduction' => $late_deduct,


				);


				$id = $this->input->post('time_id');
				$attend_details = $this->Timesheet_model->get_attendance_details($id);
				$resuslt2 = $this->Timesheet_model->update_attendance_clockedout($data, $id);

				if ($resuslt2 == TRUE) {

					# NEW: Update totals
					$this->db->where('employee_id', $employee_id);
					$this->db->where('date', date('Y-m-d', strtotime($attend_details[0]->attendance_date)));
					$attendance_time_total = $this->db->get('xin_attendance_time_total');

					if ($attendance_time_total->num_rows() > 0) {
						foreach ($attendance_time_total->result() as $time_total) {
							$early_leaving_time = $this->Misc_model->find_early_leaving1($curtime, $time_total->employee_id);
							$overtime_time = $this->Misc_model->find_overtime1($attend_details[0]->attendance_date, $time_total->employee_id);
							// $rest = gmdate("H:i", $time_total->rest_seconds);
							$rest = $this->Misc_model->find_rest($attend_details[0]->attendance_date, $attend_details[0]->employee_id);
							$work = $this->Misc_model->find_work_total($attend_details[0]->attendance_date, $attend_details[0]->employee_id);
							$user = $this->Employees_model->read_employee_information($attend_details[0]->employee_id);
							$attendance_date = $attend_details[0]->attendance_date;

							//overtime calculations start

							$overtime_consts = $this->Xin_model->get_all_overtime_constants();
							$timeshift_from = $overtime_consts[0]->timeshift_from;
							$timeshift_to = $overtime_consts[0]->timeshift_to;
							$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
							$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
							//global $weekend;


							$normal_ot_secs = 0;
							$extra_ot_secs = 0;

							if ($user[0]->office_shift_id == 0) {
								$month = date('Y-m', strtotime($attendance_date));
								$office_shift = $this->Office_shift_custom_model->employee_current_shift($empid, $month);
								$day = date('j', strtotime($attendance_date));
								$out_time = $day . '_out';

								$shift_end_time = strtotime($office_shift[$out_time]);

								$shift_out_time_seconds = $shift_end_time;

								$normal_ot_end_secs = strtotime($attendance_date . ' 19:00:00');
								$extra_ot_secs = 0;
								$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
								$extra_ot_end_secs = strtotime($attendance_date1 . ' 07:00:00');
								$normal_ot_end_secs_last = strtotime($attendance_date1 . ' 08:00:00');

								$this->db->where('employee_id', $empid);
								$this->db->where('attendance_date', $attendance_date);
								$attendances = $this->db->get('xin_attendance_time');

								$overtime_seconds = 0;

								if ($attendances->num_rows() > 0) {
									foreach ($attendances->result() as $attendance) {

										$clock_in_seconds = strtotime($attendance->clock_in);
										$clock_out_seconds = strtotime($attendance->clock_out);

										if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
											$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

											for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
												if ($i < $normal_ot_end_secs) {
													$normal_ot_secs += 1;
												} else if ($i < $extra_ot_end_secs) {
													$extra_ot_secs += 1;
												} else if ($i < $normal_ot_end_secs_last) {
													$normal_ot_secs += 1;
												}
											}
										} else if ($clock_in_seconds > $shift_out_time_seconds) {
											$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

											for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
												if ($i < $normal_ot_end_secs) {
													$normal_ot_secs += 1;
												} else if ($i < $extra_ot_end_secs) {
													$extra_ot_secs += 1;
												} else if ($i < $normal_ot_end_secs_last) {
													$normal_ot_secs += 1;
												}
											}
										}
									}
								}

								// Deduct late time
								$late_hours = $this->Misc_model->find_late1($attendance_date, $empid);
								$late_seconds = $this->Misc_model->hm2sec($late_hours);

								//$overtime_seconds -= $late_seconds;
								$normal_ot_secs -= $late_seconds;

								if ($normal_ot_secs < 0) {
									$extra_ot_secs -= abs($normal_ot_secs);
									if ($extra_ot_secs < 0)
										$extra_ot_secs = 0;
									$normal_ot_secs = 0;
								}


								//echo $office_shift[$out_time];
								//print_r($office_shift);
							} else {


								// Find week day
								$week_day = date('l', strtotime($attendance_date));
								$week_day_lower = strtolower($week_day);

								// Make Table field. Eg: thursday_out_time
								$table_field_in_time = $week_day_lower . '_in_time';
								$table_field_out_time = $week_day_lower . '_out_time';

								$this->db->where('office_shift_id', $user[0]->office_shift_id);
								$office_shift = $this->db->get('xin_office_shift')->row();

								$shift_start = $office_shift->$table_field_in_time;
								$shift_end = $office_shift->$table_field_out_time;
								if (empty($shift_start)) {
									$weekend = "yes";
								}

								$shift_start_secs = $this->Misc_model->hm2sec($shift_start);
								$shift_end_secs = $this->Misc_model->hm2sec($shift_end);

								$normal_ot_secs = $extra_ot_secs = 0;

								if ($shift_end_secs < $shift_start_secs) {

									// Night shift ends next day
									$shift_end_date = date('Y-m-d', strtotime($attendance_date . " +1 days"));

									$shift_end = "$shift_end_date $shift_end";
									$shift_end_time = strtotime($shift_end);

									$shift_out_time_seconds = $shift_end_time;


									$normal_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_from);
									$extra_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_to);
									$extra_ot_end_secs_last = strtotime($shift_end_date . ' ' . $shift_start);

									$this->db->where('employee_id', $user[0]->user_id);
									$this->db->where('attendance_date', $attendance_date);
									$attendances = $this->db->get('xin_attendance_time');

									if ($attendances->num_rows() > 0) {
										foreach ($attendances->result() as $attendance) {
											$clock_in_seconds = strtotime($attendance->clock_in);
											$clock_out_seconds = strtotime($attendance->clock_out);

											if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
												for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
													if ($i < $extra_ot_end_secs) {
														$extra_ot_secs += 1;
													} else if ($i < $normal_ot_end_secs) {
														$normal_ot_secs += 1;
													} else if ($i < $extra_ot_end_secs_last) {
														$extra_ot_secs += 1;
													}
												}
											} else if ($clock_in_seconds > $shift_out_time_seconds) {
												for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
													if ($i < $extra_ot_end_secs) {
														$extra_ot_secs += 1;
													} else if ($i < $normal_ot_end_secs) {
														$normal_ot_secs += 1;
													} else if ($i < $extra_ot_end_secs_last) {
														$extra_ot_secs += 1;
													}
												}
											}
										}
									}

									// Deduct late time
									$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
									$late_seconds = $this->Misc_model->hm2sec($late_hours);

									//$overtime_seconds -= $late_seconds;
									$extra_ot_secs -= $late_seconds;

									if ($extra_ot_secs < 0) {
										$normal_ot_secs -= abs($extra_ot_secs);
										if ($normal_ot_secs < 0)
											$normal_ot_secs = 0;

										$extra_ot_secs = 0;
									}
								} else {

									$shift_end = "$attendance_date $shift_end";
									$shift_end_time = strtotime($shift_end);

									$shift_out_time_seconds = $shift_end_time;

									$normal_ot_end_secs = strtotime($attendance_date . ' ' . $timeshift_from);
									$extra_ot_secs = 0;
									$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
									$extra_ot_end_secs = strtotime($attendance_date1 . ' ' . $timeshift_to);
									$normal_ot_end_secs_last = strtotime($attendance_date1 . ' ' . $shift_start);

									$this->db->where('employee_id', $user[0]->user_id);
									$this->db->where('attendance_date', $attendance_date);
									$attendances = $this->db->get('xin_attendance_time');

									$overtime_seconds = 0;

									if ($attendances->num_rows() > 0) {
										foreach ($attendances->result() as $attendance) {
											$clock_in_seconds = strtotime($attendance->clock_in);
											$clock_out_seconds = strtotime($attendance->clock_out);

											if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
												$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;

												for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
													if ($i < $normal_ot_end_secs) {
														$normal_ot_secs += 1;
													} else if ($i < $extra_ot_end_secs) {
														$extra_ot_secs += 1;
													} else if ($i < $normal_ot_end_secs_last) {
														$normal_ot_secs += 1;
													}
												}
											} else if ($clock_in_seconds > $shift_out_time_seconds) {
												$overtime_seconds += $clock_out_seconds - $clock_in_seconds;

												for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
													if ($i < $normal_ot_end_secs) {
														$normal_ot_secs += 1;
													} else if ($i < $extra_ot_end_secs) {
														$extra_ot_secs += 1;
													} else if ($i < $normal_ot_end_secs_last) {
														$normal_ot_secs += 1;
													}
												}
											}
										}
									}

									// Deduct late time
									$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
									$late_seconds = $this->Misc_model->hm2sec($late_hours);

									//$overtime_seconds -= $late_seconds;
									$normal_ot_secs -= $late_seconds;

									if ($normal_ot_secs < 0) {
										$extra_ot_secs -= abs($normal_ot_secs);
										if ($extra_ot_secs < 0)
											$extra_ot_secs = 0;
										$normal_ot_secs = 0;
									}
								}


								//$timestamp = strtotime($today_date);
								//$day = date('l', $timestamp);
								/*$comp_id       =  $user[0]->company_id;
              $holidays      =  $this->Employees_model->get_holidays($comp_id);

              if (isset($holidays)) {
                foreach ($holidays as $row) {
                  $startDate     =  $row->start_date;
                  $endDate       =  $row->end_date;

                  if (($today_date >= $startDate) && ($today_date <= $endDate)) {
                    $holiday_check = "yes";
                  }
                }
              }
              if ($weekend === "yes" || $holiday_check === "yes") {
                $ot_seconds  = $this->Misc_model->hm2sec($work);
              } else {
                $ot_seconds  = $this->Misc_model->hm2sec($overtime_time);
              }
              unset($weekend);
              unset($holiday_check);*/
							}
							//overtime calculations end

							// if Holiday, overtime will be total-work
							$day_status_employee = $this->Misc_model->day_status_employee($attend_details[0]->attendance_date, $time_total->employee_id);
							if (in_array($day_status_employee, array('H', 'PH'))) {
								$overtime_time = $work;
								$extra_ot_secs = $this->Misc_model->hm2sec($overtime_time);
								$normal_ot_secs = 0;
								$late = $early_leaving_time = '00:00';
							}

							$ot_seconds = $this->Misc_model->hm2sec($overtime_time);

							$this->db->where('id', $time_total->id);
							$this->db->update('xin_attendance_time_total', array(
								'late' => $late,
								'early_leaving' => $early_leaving_time,
								'rest' => $rest,
								'overtime' => $overtime_time,
								'work' => $work,
								'ot_seconds' => $ot_seconds,
								'normal_ot_seconds' => $normal_ot_secs,
								'extra_ot_seconds' => $extra_ot_secs
							));
						}
					}
					#-----------------#

					$Return['result'] = $this->lang->line('xin_success_clocked_out');
					$Return['time_id'] = '';
				} else {
					$Return['error'] = $this->lang->line('xin_error_msg');
				}
			}

			$this->output($Return);
			exit;
		}
	}

	public function annuval_leave()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		// 		$data['title'] = $this->lang->line('xin_annual_leave_request') . ' | ' . $this->Xin_model->site_title();
		$data['title'] = 'Annual Leave Request' . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
		// 		$data['breadcrumbs'] = $this->lang->line('xin_annual_leave_request');
		$data['breadcrumbs'] = 'Annual Leave Request';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['path_url'] = 'leave';


		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('250', $role_resources_ids) || $reports_to > 0) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/annuval_leave", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}


	public function annuval_leave_new()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		// 		$data['title'] = $this->lang->line('xin_annual_leave_request') . ' | ' . $this->Xin_model->site_title();
		$data['title'] = 'Annual Leave Request' . ' | ' . $this->Xin_model->site_title();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_companies'] = $this->Xin_model->get_companies();
		$data['all_leave_types'] = $this->Timesheet_model->all_leave_types();
		// 		$data['breadcrumbs'] = $this->lang->line('xin_annual_leave_request');
		$data['breadcrumbs'] = 'Annual Leave Request';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['path_url'] = 'leave';


		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('250', $role_resources_ids) || $reports_to > 0) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/cancel_annual_leave", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}


	public function add_annuval_leave()
	{
		if ($this->input->post('add_type') == 'leave_annuval') {
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$no_of_days_annual_remain = 0;
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$remarks = $this->input->post('remarks');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);

			$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp_limt($this->input->post('employee_id'), 3);

			/* Server side PHP input validation */
			if (empty($check_annual_leave_aval)) {
				$Return['error'] = 'Annual leave not allotted for this employee';
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			$no_of_days = $interval->format('%a') + 1;
			if ($Return['error'] != '') {
				$Return['csrf_hash'] = $this->security->get_csrf_hash();
				$this->output($Return);
			}

			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			if (strtotime($this->input->post('start_date')) == strtotime($this->input->post('end_date'))) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			if (!empty($check_annual_leave_aval)) {
				$aval_leaves = $check_annual_leave_aval[0]->leave_count;
			} else {
				$aval_leaves = 30;
			}
			/*if($no_of_days > $aval_leaves){
				$no_of_days_annual_remain = $no_of_days - $aval_leaves;
				$no_of_days = $aval_leaves;
				$inc_days = $aval_leaves - 1;
				$next_form_date_ann = date('Y-m-d', strtotime($this->input->post('start_date'). ' + '.$inc_days.' days'));
			}else{
				$next_form_date_ann = $this->input->post('end_date');
			}*/
			$data = array(
				'employee_id' => $this->input->post('employee_id'),
				'company_id' => $this->input->post('company_id'),
				'from_date' => $this->input->post('start_date'),
				'to_date' => $this->input->post('end_date'),
				'applied_on' => date('Y-m-d h:i:s'),
				'remarks' => $qt_remarks,
				'status' => '1',
				'status_p_un' => 'Unpaid',
				'is_notify' => '1',
				'days' => $no_of_days,
				'allotted_leave' => $aval_leaves
			);
			$result = $this->Timesheet_model->add_annuval_leave_record($data);
			if ($result) {
				/*if($no_of_days_annual_remain > 0){
					$next_form_date = date('Y-m-d', strtotime($this->input->post('start_date'). ' + '.$aval_leaves.' days'));
					$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
					if(!empty($checl_already_exists_annual)){
						$data = array(
							'from_date' => $next_form_date,
							'to_date' => $this->input->post('end_date'),
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '1',
							'is_notify' => '1',
							'days' => $no_of_days_annual_remain,
							'is_annual'=>$result
							);
						$result = $this->Timesheet_model->update_leave_record($data,$checl_already_exists_annual[0]->leave_id);
					}else{
					     $data = array(
						   'employee_id' =>$this->input->post('employee_id'),
						   'company_id' =>$this->input->post('company_id'),
						   'leave_type_id' => 7,
						   'from_date' => $next_form_date,
						   'to_date' => $this->input->post('end_date'),
						   'applied_on' => date('Y-m-d h:i:s'),
						   'reason' => $qt_remarks,
						   'remarks' => $qt_remarks,
						   'status' => '1',
						   'is_notify' => '1',
						   'created_at' => date('Y-m-d h:i:s'),
						   'days' => $no_of_days_annual_remain,
						   'is_annual'=>$result
						   );
						   $result = $this->Timesheet_model->add_leave_record($data);
					}
				 }*/
				/*if($no_of_days > 30){
				 $next_form_date = date('Y-m-d', strtotime($this->input->post('start_date'). ' + 30 days'));
					$data = array(
						'employee_id' => $this->input->post('employee_id'),
						'company_id' => $this->input->post('company_id'),
						'leave_type_id' => 7,
						'from_date' => $next_form_date,
						'to_date' => $this->input->post('end_date'),
						'applied_on' => date('Y-m-d h:i:s'),
						'reason' => $this->input->post('reason'),
						'remarks' => $qt_remarks,
						'leave_attachment' => $fname,
						'status' => '1',
						'is_notify' => '1',
						'is_half_day' => $leave_half_day_opt,
						'created_at' => date('Y-m-d h:i:s'),
						'days' => $no_of_days,
						'is_annual'=>$result
						);
						$result = $this->Timesheet_model->add_leave_record($data);
				}*/
				$row = $this->db->select("*")->limit(1)->order_by('id', "DESC")->get("xin_annual_leave_applications")->row();
				$Return['result'] = $this->lang->line('xin_success_leave_added');
				$type_name = 'Annual Leave';
				$Return['re_last_id'] = $row->id;
				$Return['lv_type_name'] = $type_name;
				// notificaions
				// notificaions
				$get_corresponind_emp = $this->Xin_model->all_user_for_expiry_notify(1);
				if ($get_corresponind_emp) {
					foreach ($get_corresponind_emp as $emp_det) {
						$nticket_data = array(
							'module_name' => 'annual_leave',
							'module_id' => $row->id,
							'employee_id' => $emp_det->user_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					}
				}
				/*	$nticket_data = array(
					'module_name' => 'annual_leave',
					'module_id' => $row->id,
					'employee_id' => $this->input->post('employee_id'),
					'is_notify' => '1',
					'created_at' => date('d-m-Y h:i:s'),
				);
				$this->Xin_model->add_notifications($nticket_data);*/
				//get setting info
				$setting = $this->Xin_model->read_setting_info(1);
				if ($setting[0]->enable_email_notification == 'yes') {
					$this->email->set_mailtype("html");
					//get company info
					$cinfo = $this->Xin_model->read_company_setting_info(1);
					//get email template
					$template = $this->Xin_model->read_email_template(5);
					//get employee info
					$user_info = $this->Xin_model->read_user_info($this->input->post('employee_id'));
					$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;
					//get reports to
					$reports_to = $this->Xin_model->read_user_info($user_info[0]->reports_to);

					$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
					$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

					$message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
						<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var employee_name}"), array($cinfo[0]->company_name, site_url(), $full_name), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
					if (!is_null($reports_to)) {
						hrsale_mail($user_info[0]->email, $full_name, $reports_to[0]->email, $subject, $message);
					} else {
						hrsale_mail($user_info[0]->email, $full_name, $cinfo[0]->email, $subject, $message);
					}
				}
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function annual_leave_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/annuval_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->get_annual_leaves();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_annual_leaves($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_employees_annual_leaves($this->input->get("company_id"), $this->input->get("employee_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_leaves_annuval($this->input->get("company_id"), $this->input->get("employee_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_annual_leaves($this->input->get("company_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_annual($this->input->get("status"));
			}
		} else {
			$view_companies_ids = explode(',', $user_info[0]->view_companies_id);
			if ($user_info[0]->user_role_id == 1 || in_array('736', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_annual_leaves();
			} else if (in_array('256', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new_annual($user_info[0]->company_id, 'first', $session['user_id']);
				//	print_r($this->db->last_query());exit;
			} else if (in_array('258', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new_annual($user_info[0]->company_id, 'final', $session['user_id']);
			} else if (in_array('254', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_annual_leaves($user_info[0]->company_id, $session['user_id']);
			} else {
				$leave = $this->Timesheet_model->get_employee_annual_leaves($session['user_id']);
			}
		}
		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			// get start date and end date
			$user = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
			} else {
				$full_name = '--';
				$department_name = '--';
			}

			// get leave type
			$type_name = 'Annual Leave';

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$datetime1 = new DateTime($r->from_date);
			$datetime2 = new DateTime($r->to_date);
			$interval = $datetime1->diff($datetime2);
			if (strtotime($r->from_date) == strtotime($r->to_date)) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$applied_on = $this->Xin_model->set_date_format($r->applied_on);
			/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/


			/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;*/

			$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);

			if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
			elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
			elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
			else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
			endif;

			if ($r->status == 1) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} elseif ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} elseif ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} elseif ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}

			// 				if($r->leave_cancel_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-ban"></i> Leave Cancel Status Pending</span>';
			// 			}
			// 			elseif($r->leave_cancel_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-ban"></i> Leave Cancel Status Approved</span>';
			// 			}
			// 				elseif($r->leave_cancel_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-ban"></i>  Leave Cancel Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			// 				if($r->leave_postpone_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-calendar"></i> Leave Postpone Status Pending</span>';
			// 			}
			// 			elseif($r->leave_postpone_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-calendar"></i> Leave Postpone Status Approved</span>';
			// 			}
			// 				elseif($r->leave_postpone_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-calendar"></i>  Leave Postpone Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			$disable_status_block = false;
			if (
				$user_info[0]->user_role_id == 1 || in_array('256', $role_resources_ids)
				|| in_array('257', $role_resources_ids) || in_array('258', $role_resources_ids)
			) {
				$disable_status_block = false;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->second_approval > 0 || $r->final_approval || $r->status == 3)
			) {
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval || $r->first_approval < 1
					|| $r->first_approval == 2 || $r->status == 3)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if ($r->status == 2) {
				$disable_status_block = true;
			}

			if ($user_info[0]->user_role_id == 1) {
				$disable_status_block = false;
			}


			if (in_array('737', $role_resources_ids)) { //edit
				if ($disable_status_block) {
					$edit = '';
				} else {
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-field_type="annual_leave" data-annual_leave_id="' . $r->id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
				}
			} else {
				$edit = '';
			}
			if (in_array('738', $role_resources_ids)) { // delete
				if ($disable_status_block) {
					$delete = '';
				} else {
					$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete_annual_record" data-toggle="modal" data-target=".delete-modal" data-annual-record-id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
				}
			} else {
				$delete = '';
			}
			if (in_array('813', $role_resources_ids) || /*$user_info[0]->user_role_id == 1 ||*/ $reports_to > 0) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/leave_annual_details/id/' . $r->id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {
				$view = '';
			}


			$combhr = $edit . $view . $delete;
			$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_remarks') . ': ' . $r->remarks . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';


			if ($r->admin_read == 0 && $user_info[0]->user_role_id == 1) {
				$type_name = '<b>' . $type_name . '</b>';
				$department_name = '<b>' . $department_name . '</b>';
				$full_name = '<b>' . $full_name . '</b>';
				$duration = '<b>' . $duration . '</b>';
				$applied_on = '<b>' . $applied_on . '</b>';
				$status = '<b>' . $status . '</b>';
			}


			// 		 if ((in_array('861', $role_resources_ids)) and ($r->status!=3) )
			//   {
			//           if (($r->leave_postpone_status!='Y')and ($r->status==2))
			//           {
			//           $postpone= '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Leave postpone">
			//           <button type="button" class="btn icon-btn btn-sm btn-outline-secondary  waves-effect waves-light" data-toggle="modal" data-target=".leave-request-postpone" data-leave_postpone_id="' . $r->id. '"data-field_type="a_leave""><span class="fa fa-calendar"></span></button></span>';
			//           }
			//           else
			//           {
			//           $postpone='';
			//           }
			//           if (($r->leave_cancel_status!='Y'))
			//           {
			//           $cancel = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Cancel Leave">
			//           <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light" data-toggle="modal" data-target=".leave-request-cancel" data-leave_c_id="' . $r->id . '"data-field_type="a_leave""><span class="fa fa-ban"></span></button></span>';
			//           }
			//           else
			//           {
			//           $cancel='';
			//           }


			//           $combhr .= $postpone.$cancel;


			//           }

			if (in_array('737', $role_resources_ids) || in_array('738', $role_resources_ids) || in_array('813', $role_resources_ids)) {
				$data[] = array(
					$type_name,
					$department_name,
					$full_name,
					$duration,
					$status,
					$applied_on,
					$combhr,
				);
			} else {
				$data[] = array(
					$type_name,
					$department_name,
					$full_name,
					$duration,
					$status,
					$applied_on
				);
			}
		}
		$output = array(
			"draw" => $draw,
			// "recordsTotal" => $leave->num_rows(),
			// "recordsFiltered" => $leave->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function delete_annual_leave()
	{
		if ($this->input->post('type') == 'delete') {
			// Define return | here result is used to return user data and error for error message
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			//carryforward
			$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
			if ($timesheet[0]->status == 2) {
				$hlfcounts = 0;
				$count_ls = 0;
				$leaves_id = 3;
				$employees_id = $timesheet[0]->employee_id;
				$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
				$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
				//$total =$type[0]->days_per_year;
				$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employees_id, $leaves_id);
				$total = $carry_count[0]->remaing_leave_count;
				$days = $timesheet[0]->days;
				/*if($timesheet[0]->is_half_day == 1){
						$days = 0.5;
					}*/
				$leave_remaining_total = $total + $days;
				/*$this->db->where('employee_id', $timesheet[0]->employee_id);
				$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
				//$this->db->where('create_date', date('Y-m-d'));
				$result = $this->db->get('carry_leaves');*/
				$date_arr = explode("-", $timesheet[0]->from_date);
				$year_check = $date_arr[0];
				$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
				if ($result->num_rows() == 0) {
					$data_insert = array(
						'employee_id' => $timesheet[0]->employee_id,
						'leave_type_id' => 3,
						'remaing_leave_count' => $leave_remaining_total,
						'create_date' => date('Y-m-d')
					);
					$data_result = $this->Timesheet_model->carry_insert($data_insert);
				} else {
					$carry_leave = $result->result(); //print_r($carry_leave);exit;
					$data_update = array(
						'employee_id' => $timesheet[0]->employee_id,
						'leave_type_id' => 3,
						'remaing_leave_count' => $leave_remaining_total,
						//'create_date'=> date('Y-m-d')
					);
					$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
				}
			}
			//end_carryforward
			/*
			if exits in unpaid section */
			$check_unpaid_leaves_exits = $this->Timesheet_model->getAnnualUnpaidLeaves($id);
			if (!empty($check_unpaid_leaves_exits)) {
				$timesheet = $this->Timesheet_model->read_leave_information($check_unpaid_leaves_exits[0]->leave_id);
				if ($timesheet[0]->status == 2) {
					$hlfcounts = 0;
					$count_ls = 0;
					$leaves_id = $timesheet[0]->leave_type_id;
					$employees_id = $timesheet[0]->employee_id;
					$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
					$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
					//$total =$type[0]->days_per_year;
					$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($employees_id, $leaves_id);
					$total = $carry_count[0]->remaing_leave_count;
					$days = $timesheet[0]->days;
					if ($timesheet[0]->is_half_day == 1) {
						$days = 0.5;
					}
					$leave_remaining_total = $total + $days;
					/*$this->db->where('employee_id', $timesheet[0]->employee_id);
					$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
					//$this->db->where('create_date', date('Y-m-d'));
					$result = $this->db->get('carry_leaves');*/
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
					if ($result->num_rows() == 0) {
						$data_insert = array(
							'employee_id' => $timesheet[0]->employee_id,
							'leave_type_id' => $timesheet[0]->leave_type_id,
							'remaing_leave_count' => $leave_remaining_total,
							'create_date' => date('Y-m-d')
						);
						$data_result = $this->Timesheet_model->carry_insert($data_insert);
					} else {
						$carry_leave = $result->result(); //print_r($carry_leave);exit;
						$data_update = array(
							'employee_id' => $timesheet[0]->employee_id,
							'leave_type_id' => $timesheet[0]->leave_type_id,
							'remaing_leave_count' => $leave_remaining_total,
							//'create_date'=> date('Y-m-d')
						);
						$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
					}
				}
				$remove_unpaid_leaves = $this->Timesheet_model->deleteUnpaidLeaves($id);
			}
			/* end unpaid section */
			$result = $this->Timesheet_model->delete_annual_leave_record($id);
			if (isset($id)) {
				$Return['result'] = $this->lang->line('xin_success_leave_deleted');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}

	public function read_annual_leave_record()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view('admin/timesheet/dialog_leave', $data);
		} else {
			redirect('admin/');
		}
	}

	public function edit_annual_leave_validate()
	{
		if ($this->input->post('edit_type') == 'leave') {
			$id = $this->uri->segment(4);
			$no_of_days_annual_remain = 0;
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result_annual = $this->Timesheet_model->read_annual_leave_information($id);
			$remarks = $this->input->post('remarks');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($result_annual[0]->employee_id, 3);
			/* Server side PHP input validation */
			if (empty($check_annual_leave_aval)) {
				$Return['error'] = 'Annual leave not allotted for this employee';
			} else if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function edit_annual_leave()
	{
		if ($this->input->post('edit_type') == 'leave') {
			$id = $this->uri->segment(4);
			$no_of_days_annual_remain = 0;
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result_annual = $this->Timesheet_model->read_annual_leave_information($id);
			$remarks = $this->input->post('remarks');
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($result_annual[0]->employee_id, 3);
			/* Server side PHP input validation */
			if (empty($check_annual_leave_aval)) {
				$Return['error'] = 'Annual leave not allotted for this employee';
			} else if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			if (strtotime($this->input->post('start_date')) == strtotime($this->input->post('end_date'))) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			if (!empty($check_annual_leave_aval)) {
				$aval_leaves = $check_annual_leave_aval[0]->leave_count;
			} else {
				$aval_leaves = 30;
			}
			if ($no_of_days > $aval_leaves) {
				$no_of_days_annual_remain = $no_of_days - $aval_leaves;
				$no_of_days = $aval_leaves;
				$inc_days = $aval_leaves - 1;
				$next_form_date_ann = date('Y-m-d', strtotime($this->input->post('start_date') . ' + ' . $inc_days . ' days'));
			} else {
				$check_unpaid_leaves_exits = $this->Timesheet_model->getAnnualUnpaidLeaves($id);
				if (!empty($check_unpaid_leaves_exits)) {
					$remove_unpaid_leaves = $this->Timesheet_model->deleteUnpaidLeaves($id);
				}
				$next_form_date_ann = $this->input->post('end_date');
			}
			$data = array(
				'remarks' => $qt_remarks,
				'from_date' => $this->input->post('start_date'),
				'to_date' => $next_form_date_ann,
				'days' => $no_of_days,
				'allotted_leave' => $aval_leaves,
				'leave_cancel_reason' => $this->input->post('Cancel_reason'),
				'leave_postpone_reason' => $this->input->post('postpone_reason'),

				'updated_date' => date('Y-m-d')
			);
			$result = $this->Timesheet_model->update_annual_leave_record($data, $id);


			if ($result == TRUE) {
				if ($no_of_days_annual_remain > 0) {
					$next_form_date = date('Y-m-d', strtotime($this->input->post('start_date') . ' + ' . $aval_leaves . ' days'));
					$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($id);
					if (!empty($checl_already_exists_annual)) {
						$data = array(
							'from_date' => $next_form_date,
							'to_date' => $this->input->post('end_date'),
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '1',
							'is_notify' => '1',
							'days' => $no_of_days_annual_remain,
							'is_annual' => $result_annual[0]->id,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
					} else {
						$data = array(
							'employee_id' => $result_annual[0]->employee_id,
							'company_id' => $result_annual[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $next_form_date,
							'to_date' => $this->input->post('end_date'),
							'applied_on' => date('Y-m-d h:i:s'),
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '1',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $no_of_days_annual_remain,
							'is_annual' => $result_annual[0]->id
						);
						$result = $this->Timesheet_model->add_leave_record($data);
					}
				}
				$Return['result'] = $this->lang->line('xin_success_leave_updated');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function leave_annual_details()
	{
		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$leave_id = $this->uri->segment(5);
		// leave applications
		$edata = array(
			'is_notify' => 0,
		);
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'annual_leave');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'annual_leave_approve');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'annual_leave_approve_pending');
		$this->Xin_model->update_notification_record($edata, $leave_id, $session['user_id'], 'annual_leave_approve_rejected');
		$result = $this->Timesheet_model->read_annual_leave_information($leave_id);
		if (is_null($result)) {
			redirect('admin/timesheet/leave');
		}

		// get leave types
		$type_name = 'Annual Leave';
		// get employee
		$user = $this->Xin_model->read_user_info($result[0]->employee_id);
		if (!is_null($user)) {
			$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
			$u_role_id = $user[0]->user_role_id;
			$department = $this->Department_model->read_department_information($user[0]->department_id);
			if (!is_null($department)) {
				$department_name = $department[0]->department_name;
			} else {
				$department_name = '--';
			}
		} else {
			$full_name = '--';
			$u_role_id = '--';
			$department_name = '--';
		}
		if ($session['user_id'] == 1) {
			$data = array(
				'admin_read' => 1
			);
			$this->Timesheet_model->update_annualleave_readrecord($data, $leave_id);
		}

		$data = array(
			'title' => $this->lang->line('xin_annual_leave_detail') . ' | ' . $this->Xin_model->site_title(),
			'type' => $type_name,
			'role_id' => $u_role_id,
			'full_name' => $full_name,
			'eemployee_id' => $result[0]->employee_id,
			'department_name' => $department_name,
			'leave_id' => $result[0]->id,
			'employee_id' => $result[0]->employee_id,
			'company_id' => $result[0]->company_id,
			'from_date' => $result[0]->from_date,
			'to_date' => $result[0]->to_date,
			'applied_on' => $result[0]->applied_on,
			'remarks' => $result[0]->remarks,
			'status' => $result[0]->status,
			'first_approval' => $result[0]->first_approval,
			'second_approval' => $result[0]->second_approval,
			'final_approval' => $result[0]->final_approval,
			'all_employees' => $this->Xin_model->all_employees(),
			'all_leave_types' => $this->Timesheet_model->all_leave_types(),
			'probation_check' => $result[0]->probation_check,
			'annual_leave_amt' => $result[0]->annua_amt,
		);
		$data['breadcrumbs'] = $this->lang->line('xin_annual_leave_detail');
		$data['path_url'] = 'annual_leave_details';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		if (in_array('250', $role_resources_ids) || $reports_to > 0) {
			if (!empty($session)) {
				$data['subview'] = $this->load->view("admin/timesheet/annual_leave_details", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}

	/* Leave carryforward management
				//carryforward
					/*$this->db->where('employee_id', $timesheet[0]->employee_id);
					$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
					//$this->db->where('create_date', date('Y-m-d'));
					$result_carry = $this->db->get('carry_leaves');
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id,3,$year_check);
				//end
					if(($this->input->post('status') =='2') && (isset($timesheet[0]->status) !== '2')){
							$hlfcounts =0;
							$count_ls =0;
							$leaves_id=3;
							$employees_id=$timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id,$employees_id);
							$count =$xin_leave_type[0]->leave_count;
							$count_leave_type=$this->Timesheet_model->count_leave_type($leaves_id);
							$count_ls = count_annual_leaves_info($leaves_id,$employees_id);
							$va=$count_leave_type[0]->days_per_year;
							$type = $this->Timesheet_model->read_leave_type_information($leaves_id);
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id,$leaves_id);
							//$total =$type[0]->days_per_year;
							$total = $emp_leaves_data[0]->leave_count;
							$leave_remaining_total = $total - $count_ls;
							$c=$count - $va;
							$re=$total- $count_ls;
							if($leave_remaining_total==0){
								$lr=0;
								$hr=0;
							}elseif($leave_remaining_total<$count_ls){
								$lr=0;
								$hr=$c;
							}else{
								$lr=$leave_remaining_total;
								$hr=0;
							}
						//$this->db->where('employee_id', $timesheet[0]->employee_id);
						//$this->db->where('leave_type_id', $timesheet[0]->leave_type_id);
						//$this->db->where('create_date', date('Y-m-d'));
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id,3,$year_check);
						if ($result->num_rows() == 0) {
							$data_insert=array(
								'employee_id'=>$timesheet[0]->employee_id,
								'leave_type_id'=>3,
								'remaing_leave_count'=>$leave_remaining_total,
								'create_date'=> date('Y-m-d'));
								$data_result=$this->Timesheet_model->carry_insert($data_insert);
						} else {
							$carry_leave =  $result->result();//print_r($carry_leave);exit;
							$data_update=array(
								'employee_id'=>$timesheet[0]->employee_id,
								'leave_type_id'=>3,
								'remaing_leave_count'=>$leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
								$data_result=$this->Timesheet_model->carry_update($data_update,$carry_leave[0]->id);
						}
					}else if($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0){
						//pending or rejected
						$carry_leave =  $result_carry->result();
							$hlfcounts =0;
							$count_ls =0;
							$leaves_id=3;
							$employees_id=$timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id,$employees_id);
							$count =$xin_leave_type[0]->leave_count;
							$count_leave_type=$this->Timesheet_model->count_leave_type($leaves_id);
							$count_ls = count_annual_leaves_info($leaves_id,$employees_id);
							$leave_remaining_total  = $carry_leave[0]->remaing_leave_count +  $count_ls;
							//$leave_remaining_total = $leave_remaining_total - $hlfcounts;
						$data_update=array(
								'employee_id'=>$timesheet[0]->employee_id,
								'leave_type_id'=>3,
								'remaing_leave_count'=>$leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
						$data_result=$this->Timesheet_model->carry_update($data_update,$carry_leave[0]->id);
					}
			/* End Leave carryforward management
			$data = array(
			'status' => $this->input->post('status'),
			'remarks' => $qt_remarks
			);
			$result = $this->Timesheet_model->update_annual_leave_record($data,$id);
		*/
	public function update_annual_leave_status_bk()
	{
		if ($this->input->post('update_type') == 'leave') {
			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$timesheet = $this->Timesheet_model->read_annual_leave_information($id);

			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $second_approval = $final_approval = 0;
			if ($this->input->post('status') == null) {
				$first_approval = $timesheet[0]->first_approval;
				$second_approval = $timesheet[0]->second_approval;
				$final_approval = $timesheet[0]->final_approval;
				$status_updated = $timesheet[0]->status;
				$approved_by_first = $timesheet[0]->approved_by_first;
				$approved_by_second = $timesheet[0]->approved_by_second;
				$approved_by_final = $timesheet[0]->approved_by_final;
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$status_updated = $this->input->post('status');

					if ($status_updated == 2) {
						$first_approval = $second_approval = $final_approval = 1;
						$old_first_val = $timesheet[0]->first_approval;
						if ($old_first_val) {
							$approved_by_first = $timesheet[0]->approved_by_first;
						} else {
							$approved_by_first = $session['user_id'];
						}
						$old_second_val = $timesheet[0]->second_approval;
						if ($old_second_val) {
							$approved_by_second = $timesheet[0]->approved_by_second;
						} else {
							$approved_by_second = $session['user_id'];
						}
						$old_final_val = $timesheet[0]->final_approval;
						if ($old_final_val) {
							$approved_by_final = $timesheet[0]->approved_by_final;
						} else {
							$approved_by_final = $session['user_id'];
						}
					} else if ($status_updated == 3) {
						$final_approval = 2;
					}
				} elseif (in_array('256', $role_resources_ids) || in_array('258', $role_resources_ids) || in_array('257', $role_resources_ids)) {
					if (in_array('256', $role_resources_ids)) {
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2) {
							$first_approval = 1;
							$old_first_val = $timesheet[0]->first_approval;
							if ($old_first_val) {
								$approved_by_first = $timesheet[0]->approved_by_first;
							} else {
								$approved_by_first = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$first_approval = 2;
						}
					}
					if (in_array('257', $role_resources_ids)) { //second approval
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2 && $timesheet[0]->first_approval) {
							$first_approval = $second_approval = 1;
							$old_second_val = $timesheet[0]->second_approval;
							if ($old_second_val) {
								$approved_by_second = $timesheet[0]->approved_by_second;
							} else {
								$approved_by_second = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$second_approval = 2;
						}
					}
					if (in_array('258', $role_resources_ids)) {
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2) {
							$first_approval = $second_approval = $final_approval = 1;
							$status_updated = 2;
							$old_first_val = $timesheet[0]->first_approval;
							if ($old_first_val) {
								$approved_by_first = $timesheet[0]->approved_by_first;
							} else {
								$approved_by_first = $session['user_id'];
							}
							$old_second_val = $timesheet[0]->second_approval;
							if ($old_second_val) {
								$approved_by_second = $timesheet[0]->approved_by_second;
							} else {
								$approved_by_second = $session['user_id'];
							}
							$old_final_val = $timesheet[0]->final_approval;
							if ($old_final_val) {
								$approved_by_final = $timesheet[0]->approved_by_final;
							} else {
								$approved_by_final = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$final_approval = 2;
						}
					}
				} else {
					$status_updated = $this->input->post('leave_status_old');
				}
			}


			if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {
				$no_of_days = $timesheet[0]->days;
				$aval_leaves = 0;
				$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
				if (!empty($check_annual_leave_aval)) {
					$aval_leaves = $check_annual_leave_aval[0]->leave_count;
				}
				$date_arr = explode("-", $timesheet[0]->from_date);
				$year_check = $date_arr[0];
				$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
				$carry_leave_exced = $result_carry->result();
				if ($result_carry->num_rows() > 0) {
					if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
						if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
							$no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
							$no_of_days = $carry_leave_exced[0]->remaing_leave_count;
							$aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
							$inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					} else {
						if ($no_of_days > $aval_leaves) {
							$no_of_days_annual_remain = $no_of_days - $aval_leaves;
							$no_of_days = $aval_leaves;
							$inc_days = $aval_leaves - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					}
				} else {
					if ($no_of_days > $aval_leaves) {
						$no_of_days_annual_remain = $no_of_days - $aval_leaves;
						$no_of_days = $aval_leaves;
						$inc_days = $aval_leaves - 1;
						$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
					} else {
						$next_form_date_ann = $timesheet[0]->to_date;
					}
				}
				if ((!empty($this->input->post('probation_check')) && $probation_check == 'lop')) {
					$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
					$check_flag = 3;
					$no_of_days_annual_remain = 0;
					$data = array(
						'employee_id' => $timesheet_exceeds[0]->employee_id,
						'company_id' => $timesheet_exceeds[0]->company_id,
						'leave_type_id' => 7,
						'from_date' => $timesheet_exceeds[0]->from_date,
						'to_date' => $timesheet_exceeds[0]->to_date,
						'applied_on' => $timesheet_exceeds[0]->applied_on,
						'reason' => $timesheet_exceeds[0]->remarks,
						'remarks' => $timesheet_exceeds[0]->remarks,
						'status' => '2',
						'is_notify' => '1',
						'created_at' => date('Y-m-d h:i:s'),
						'days' => $timesheet_exceeds[0]->days,
						'cleared_status' => 1,
						'probation_check' => $probation_check
					);
					$result = $this->Timesheet_model->add_leave_record_new($data);
					$unpaid_leave_id = $result;
					$timesheet = $this->Timesheet_model->read_leave_information($result);
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
					if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
						$leaves_id = $timesheet[0]->leave_type_id;
						$employees_id = $timesheet[0]->employee_id;
						$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
						if ($emp_leaves_data) {
							$total = $emp_leaves_data[0]->leave_count;
						} else {
							$total = 0;
						}
						$carry_leave = $result_carry->result();
						if ($carry_leave) {
							$total = $carry_leave[0]->remaing_leave_count;
						} else {
							$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
							$total = $emp_leave_count[0]->leave_count;
						}
						$taked_leaves = $timesheet[0]->days;
						if ($this->input->post('status') == 2) {
							$leave_remaining_total = $total + $taked_leaves;
						} else {
							$leave_remaining_total = $total - $taked_leaves;
						}
						$leave_remaining_total = $leave_remaining_total;
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						if ($result->num_rows() == 0) {
							$data_insert = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								'create_date' => date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_insert($data_insert);
						} else {
							$carry_leave = $result->result(); //print_r($carry_leave);exit;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
					} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
						$carry_leave = $result_carry->result();
						$hlfcounts = 0;
						$count_ls = 0;
						$leaves_id = $timesheet[0]->leave_type_id;
						$employees_id = $timesheet[0]->employee_id;
						if ($carry_leave) {
							$total = $carry_leave[0]->remaing_leave_count;
						} else {
							$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
							$total = $emp_leave_count[0]->leave_count;
						}
						$taked_leaves = $timesheet[0]->days;
						if ($this->input->post('status') == 2) {
							$leave_remaining_total = $total + $taked_leaves;
						} else {
							$leave_remaining_total = $total - $taked_leaves;
						}
						$leave_remaining_total = $leave_remaining_total;
						$data_update = array(
							'employee_id' => $timesheet[0]->employee_id,
							'leave_type_id' => $timesheet[0]->leave_type_id,
							'remaing_leave_count' => abs($leave_remaining_total),
							//'create_date'=> date('Y-m-d')
						);
						$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
					}
					$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
				} else {
					$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
					$date_arr = explode("-", $timesheet_exceeds[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet_exceeds[0]->employee_id, 3, $year_check);
					$carry_leave_exced = $result_carry->result();
					if ($result_carry->num_rows() > 0) {
						if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
							$check_flag = 1;
							$no_of_days_annual_remain = 0;
							$data = array(
								'employee_id' => $timesheet_exceeds[0]->employee_id,
								'company_id' => $timesheet_exceeds[0]->company_id,
								'leave_type_id' => 7,
								'from_date' => $timesheet_exceeds[0]->from_date,
								'to_date' => $timesheet_exceeds[0]->to_date,
								'applied_on' => $timesheet_exceeds[0]->applied_on,
								'reason' => $timesheet_exceeds[0]->remarks,
								'remarks' => $timesheet_exceeds[0]->remarks,
								'status' => '2',
								'is_notify' => '1',
								'created_at' => date('Y-m-d h:i:s'),
								'days' => $timesheet_exceeds[0]->days,
								'cleared_status' => 1,
								'probation_check' => $probation_check
							);
							$result = $this->Timesheet_model->add_leave_record_new($data);
							$unpaid_leave_id = $result;
							$timesheet = $this->Timesheet_model->read_leave_information($result);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								$count = $xin_leave_type[0]->leave_count;
								$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
								$emp_leaves_data = $this->Timesheet_model->annual_leave_availablefor_emp_limt($employees_id, $leaves_id);
								if ($emp_leaves_data) {
									$total = $emp_leaves_data[0]->leave_count;
								} else {
									$total = 0;
								}
								$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
								$carry_leave = $result_carry->result();
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') == 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result_carry->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->employee_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') == 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
							$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
						} else {
							$data = array(
								'status' => $this->input->post('status'),
								'remarks' => $qt_remarks,
								'allotted_leave' => $aval_leaves,
								'to_date' => $next_form_date_ann,
								'days' => $no_of_days,
								'cleared_status' => 1,
								'annua_amt' => $this->input->post('annual_leave_amt'),
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
						}
					} else {
						$data = array(
							'status' => $this->input->post('status'),
							'remarks' => $qt_remarks,
							'allotted_leave' => $aval_leaves,
							'to_date' => $next_form_date_ann,
							'days' => $no_of_days,
							'cleared_status' => 1,
							'annua_amt' => $this->input->post('annual_leave_amt'),
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					}
				}
			} else {
				if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
					$check_flag = 2;
				}
				$data = array(
					'status' => $this->input->post('status'),
					'annua_amt' => $this->input->post('annual_leave_amt'),
					'updated_date' => date('Y-m-d')
				);
				$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
			}
			if ($result == TRUE) {
				if ($no_of_days_annual_remain > 0) {
					$next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
					$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
					if (!empty($checl_already_exists_annual)) {
						$data = array(
							'from_date' => $next_form_date,
							'to_date' => $timesheet[0]->to_date,
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '2',
							'is_notify' => '1',
							'days' => $no_of_days_annual_remain,
							'is_annual' => $id,
							'cleared_status' => 1,
							'probation_check' => $probation_check,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
						$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$carry_leave = $result_carry->result();
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							$carry_leave = $result_carry->result();
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $leaves_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
					} else {
						$data = array(
							'employee_id' => $timesheet[0]->employee_id,
							'company_id' => $timesheet[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $next_form_date,
							'to_date' => $timesheet[0]->to_date,
							'applied_on' => date('Y-m-d h:i:s'),
							'reason' => $qt_remarks,
							'remarks' => $qt_remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $no_of_days_annual_remain,
							'is_annual' => $id,
							'cleared_status' => 1,
							'probation_check' => $probation_check
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						$unpaid_leave_id = $result;
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $leaves_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							$carry_leave = $result_carry->result();
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $leaves_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
					}
				}
				if ($check_flag == 0) {
					/* Leave carryforward management */
					$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
					//carryforward
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
					//end
					if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
						$hlfcounts = 0;
						$count_ls = 0;
						$leaves_id = 3;
						$employees_id = $timesheet[0]->employee_id;
						$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
						$count = $xin_leave_type[0]->leave_count;
						$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
						//$leave_half_day_opt = $timesheet[0]->is_half_day;

						$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
						foreach ($leave_halfday_cals as $lhalfday) :
							$hlfcounts += 0.5;
						endforeach;
						$count_ls = count_leaves_info($leaves_id, $employees_id);
						$count_ls = $count_ls - $hlfcounts;
						$carry_leave = $result_carry->result();
						if ($carry_leave) {
							$total = $carry_leave[0]->remaing_leave_count;
						} else {
							$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
							$total = $emp_leave_count[0]->leave_count;
						}

						$taked_leaves = $timesheet[0]->days;

						if ($this->input->post('status') != 2) {
							$leave_remaining_total = $total + $taked_leaves;
						} else {
							$leave_remaining_total = $total - $taked_leaves;
						}

						$leave_remaining_total = $leave_remaining_total;

						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
						if ($result->num_rows() == 0) {
							$data_insert = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => 3,
								'remaing_leave_count' => $leave_remaining_total,
								'create_date' => date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_insert($data_insert);
						} else {
							$carry_leave = $result->result();
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => 3,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
					} else if ($this->input->post('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
						//pending or rejected
						$carry_leave = $result_carry->result();
						$hlfcounts = 0;
						$count_ls = 0;
						//$leave_half_day_opt = $timesheet[0]->is_half_day;
						$leaves_id = $timesheet[0]->leave_type_id;
						$employees_id = $timesheet[0]->employee_id;
						$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
						$count = $xin_leave_type[0]->leave_count;
						$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
						$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
						foreach ($leave_halfday_cals as $lhalfday) :
							$hlfcounts += 0.5;
						endforeach;
						$count_ls = count_leaves_info($leaves_id, $employees_id);
						$count_ls = $count_ls - $hlfcounts;
						$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

						$total = $carry_leave[0]->remaing_leave_count;
						$taked_leaves = $timesheet[0]->days;
						if ($this->input->post('status') != 2) {
							$leave_remaining_total = $total + $taked_leaves;
						} else {
							$leave_remaining_total = $total - $taked_leaves;
						}
						$leave_remaining_total = $leave_remaining_total;
						$data_update = array(
							'employee_id' => $timesheet[0]->employee_id,
							'leave_type_id' => $timesheet[0]->leave_type_id,
							'remaing_leave_count' => $leave_remaining_total,
							//'create_date'=> date('Y-m-d')
						);
						$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
					}
					/* End Leave carryforward management */
					$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				} else if ($check_flag == 1) {
					$Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
				} else {
					$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				}
				if ($this->input->post('annual_leave_amt') == 0) {

					/* Annual Settlement amount calc  */
					$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
					$user_id = $timesheet[0]->employee_id;
					$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
					//Check annual leave exists for the corresponding employee
					$annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
					if ($annual_leaves_exits) {
						//echo 'jo';exit;
					} else {
						$joining_date = $this->Timesheet_model->joining_date($user_id);
						$start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
					}
					// end annual leave exists check
					$net_annual_amt = 0;
					$annual_amt_pay = $anual_days_leave = 0;
					$basic_salary = $user_info[0]->basic_salary;
					$allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
					$allowances = $this->Employees_model->set_employee_allowances_for_leavesalary($user_id);
					$system = $this->Xin_model->read_setting_info(1);
					if (!empty($allowances->result())) {
						foreach ($allowances->result() as $sl_allowances) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$iallowance_amount = $sl_allowances->allowance_amount / 2;
								} else {
									$iallowance_amount = $sl_allowances->allowance_amount;
								}
								$allowance_amount += $iallowance_amount;
							} else {
								//$eallowance_amount = $sl_allowances->allowance_amount;
								if ($sl_allowances->is_allowance_taxable == 1) {
									if ($sl_allowances->amount_option == 0) {
										$iallowance_amount = $sl_allowances->allowance_amount;
									} else {
										$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
									}
									$allowance_amount -= $iallowance_amount;
								} else if ($sl_allowances->is_allowance_taxable == 2) {
									if ($sl_allowances->amount_option == 0) {
										$iallowance_amount = $sl_allowances->allowance_amount / 2;
									} else {
										$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
									}
									$allowance_amount -= $iallowance_amount;
								} else {
									if ($sl_allowances->amount_option == 0) {
										$iallowance_amount = $sl_allowances->allowance_amount;
									} else {
										$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
									}
									$allowance_amount += $iallowance_amount;
								}
							}
						}
					}
					$commissions = $this->Employees_model->set_employee_commissions_for_leavesalary($user_id);
					if (!empty($commissions->result())) {
						foreach ($commissions->result() as $sl_commissions) {
							$pg_commissions_amount = $sl_commissions->commission_amount;
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$ecommissions_amount = $sl_commissions->commission_amount / 2;
								} else {
									$ecommissions_amount = $sl_commissions->commission_amount;
								}
								$commissions_amount += $ecommissions_amount;
							} else {
								if ($sl_commissions->is_commission_taxable == 1) {
									if ($sl_commissions->amount_option == 0) {
										$ecommissions_amount = $sl_commissions->commission_amount;
									} else {
										$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
									}
									$commissions_amount -= $ecommissions_amount;
								} else if ($sl_commissions->is_commission_taxable == 2) {
									if ($sl_commissions->amount_option == 0) {
										$ecommissions_amount = $sl_commissions->commission_amount / 2;
									} else {
										$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
									}
									$commissions_amount -= $ecommissions_amount;
								} else {
									if ($sl_commissions->amount_option == 0) {
										$ecommissions_amount = $sl_commissions->commission_amount;
									} else {
										$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
									}
									$commissions_amount += $ecommissions_amount;
								}
							}
						}
					}
					$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_for_leavesalary($user_id);
					if (!empty($statutory_deductions->result())) {
						foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
							$sta_salary = $basic_salary;
							$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$single_sd = $st_amount / 2;
								} else {
									$single_sd = $st_amount;
								}
								$statutory_deductions_amount += $single_sd;
							} else {
								if ($sl_statutory_deductions->statutory_options == 0) {
									$single_sd = $sl_statutory_deductions->deduction_amount;
								} else {
									$single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
								}
								$statutory_deductions_amount += $single_sd;
							}
						}
					}
					$other_payments = $this->Employees_model->set_employee_other_payments_leave_salary($user_id);
					if (!empty($other_payments->result())) {
						foreach ($other_payments->result() as $sl_other_payments) {
							if ($system[0]->is_half_monthly == 1) {
								if ($system[0]->half_deduct_month == 2) {
									$epayments_amount = $sl_other_payments->payments_amount / 2;
								} else {
									$epayments_amount = $sl_other_payments->payments_amount;
								}
								$other_payments_amount += $epayments_amount;
							} else {
								//$epayments_amount = $sl_other_payments->payments_amount;
								if ($sl_other_payments->is_otherpayment_taxable == 1) {
									if ($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount;
									} else {
										$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
									}
									$other_payments_amount -= $epayments_amount;
								} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
									if ($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount / 2;
									} else {
										$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
									}
									$other_payments_amount -= $epayments_amount;
								} else {
									if ($sl_other_payments->amount_option == 0) {
										$epayments_amount = $sl_other_payments->payments_amount;
									} else {
										$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
									}
									$other_payments_amount += $epayments_amount;
								}
							}
						}
					}
					if ($timesheet[0]->paid_status == 'N') {
						$anual_days_leave = $timesheet[0]->days;
						$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id, $joining_date[0]->date_of_joining);
						if ($check_already_exists_paid) {
							$applied_date = $check_already_exists_paid[0]->applied_on;
							$date_arr = explode("-", $applied_date);
							$yr_d_paid = $date_arr[0];

							$date = date_create($check_already_exists_paid[0]->applied_on);
							$not_paid_year = date_format($date, "Y");
							$difference_years = $not_paid_year - $yr_d_paid;

							//joining date difference
							$date_joins = $joining_date[0]->date_of_joining;
							$date = date_create($date_joins);
							$date_join = date_format($date, "Y");
							$todays_date = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
							$join_differ = $todays_date - $date_join;
							if ($join_differ > 0) {
								$days_add_start = $join_differ * 365;
							} else {
								$days_add_start = 1 * 365;
							}

							//end joining date difference
							if ($difference_years > 0) {
								$days_add = $difference_years * 365;
							} else {
								$days_add = 1 * 365;
							}

							$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
							$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
						} else {
							$date_joins = $joining_date[0]->date_of_joining;
							$date = date_create($date_joins);
							$date_join = date_format($date, "Y/m/d");
							$todays_date = date('Y-m-d');
							$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
							$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
							$days_add = $years * 365;
							$start_date_co = $joining_date[0]->date_of_joining;
							$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
						}
						$arry_years = array();
						$st = '';
						$p_count_val = $tot_days = 0;
						$off_day_arr = array();
						$holiday_arr = array();
						$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
						if (!is_null($office_shift)) {
							$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
							if ($h_date_chck->num_rows() > 0) {
								$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
								foreach ($h_date as $val) {
									$begin = new DateTime($val->start_date);
									$end = new DateTime($val->end_date);
									$end = $end->modify('+1 day');

									$interval = new DateInterval('P1D');
									$daterange = new DatePeriod($begin, $interval, $end);

									foreach ($daterange as $date) {
										$holiday_arr[] = $date->format("Y-m-d");
									}
								}
								$p_count_val += count($holiday_arr);
							}
						}
						$leave_arr = array();
						$half_leave_arr = array();
						$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
						if ($leave_date_chck->num_rows() > 0) {
							$leave_date = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
							foreach ($leave_date->result() as $leave_dates) {
								$begin1 = new DateTime($leave_dates->from_date);
								$end1 = new DateTime($leave_dates->to_date);
								$end1 = $end1->modify('+1 day');
								$half_day_check = $leave_dates->is_half_day;
								$interval1 = new DateInterval('P1D');
								$daterange1 = new DatePeriod($begin1, $interval1, $end1);

								foreach ($daterange1 as $date1) {
									if ($half_day_check == 1) {
										$half_leave_arr[] = $date1->format("Y-m-d");
									} else {
										$leave_arr[] = $date1->format("Y-m-d");
									}
								}
							}
						}
						$present_arr = array();
						//$st = $this->db->last_query();
						$total_leaves = count($leave_arr) + count($half_leave_arr);
						$p_count_val += abs($total_leaves - $tot_days);
						$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
						$absent_count = 0;
						$leave_count = 0;
						$month_year = date('Y-m', strtotime($start_date_co));
						/*if (strtotime($month_year) == strtotime(date('Y-m'))) {
							$month_year_att = $month_year . '-01';
							$month_year_att_end = $month_year . '-' . date('d');
							$startDate = new DateTime($month_year_att);
							$endDate = new DateTime($month_year_att_end);
							$difference = $endDate->diff($startDate);
							$difference_days  = $difference->format("%a");
						} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
							$month_year_att = $start_date_co;
							$month_year_att_end = $end_date_co;
							$startDate = new DateTime($month_year_att);
							$endDate = new DateTime($month_year_att_end);
							$difference = $endDate->diff($startDate);
							$difference_days  = $difference->format("%a");
						} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
							$difference_days  = 0;
						}*/
						$user = $this->Xin_model->read_user_info($user_id);
						if (strtotime($month_year) == strtotime(date('Y-m'))) {
							$month_year_att = $month_year . '-01';
							if ($user[0]->date_of_leaving) {
								/*if(strtotime($month_year) == strtotime(date("Y-m",strtotime($user[0]->date_of_leaving)))){

						        $month_year_att_end = $user[0]->date_of_leaving;
						        $startDate = new DateTime($month_year_att);
        						$endDate = new DateTime($month_year_att_end);
        						$difference = $endDate->diff($startDate);
        						$difference_days  = $difference->format("%a");
						    }else if($month_year > date("Y-m",strtotime($user[0]->date_of_leaving))){
								$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days  = $difference->format("%a");
							}else{
						        $difference_days = 0;
						    }*/
								if (strtotime($month_year) == strtotime(date("Y-m", strtotime($user[0]->date_of_leaving)))) {
									$month_year_att_end = $user[0]->date_of_leaving;
									$startDate = new DateTime($month_year_att);
									$endDate = new DateTime($month_year_att_end);
									$difference = $endDate->diff($startDate);
									$difference_days = $difference->format("%a") + 1;
								} else {
									$difference_days = 0;
								}
							} else {
								$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
								if ($get_attendance_last_entered) {
									$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
									//$month_year_att_end = $month_year.'-'.date('d');
									$startDate = new DateTime($month_year_att);
									$endDate = new DateTime($month_year_att_end);
									$difference = $endDate->diff($startDate);
									$difference_days = $difference->format("%a") + 1;
								} else {
									$difference_days = 0;
								}
							}
						} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
							//$difference_days  = $daysInMonth;
							$month_year_att = $month_year . '-01';
							$get_attendance_last_entered = $this->Timesheet_model->attendance_this_month_value_last($user_id, $start_date_y_m);
							if ($get_attendance_last_entered) {
								$month_year_att_end = $get_attendance_last_entered[0]->attendance_date;
								//$month_year_att_end = $month_year.'-'.date('d');
								$startDate = new DateTime($month_year_att);
								$endDate = new DateTime($month_year_att_end);
								$difference = $endDate->diff($startDate);
								$difference_days = $difference->format("%a") + 1;
							} else {
								$difference_days = 0;
							}
						} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
							$difference_days = 0;
						}
						$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
						if (!is_null($office_shift)) {
							$day_start = date('d', strtotime($start_date_co));
							$period = new DatePeriod(
								new DateTime($month_year_att),
								new DateInterval('P1D'),
								new DateTime($month_year_att_end)
							);
							foreach ($period as $key => $value) {
								$attendance_date = $value->format('Y-m-d');
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count += 0.5;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
									$present_count += 1;
								} else {
									$absent_count += 1;
									//$pcount += 0;
								}
							}
						}

						$from_Date = $timesheet[0]->from_date;
						$to_Date = $timesheet[0]->to_date;
						$com_start = '01-' . date('m-Y', strtotime($from_Date));
						$no_of_days_from = date('t', strtotime($from_Date));
						$com_end = $no_of_days_from . date('m-Y', strtotime($from_Date));
						if (date('m-Y', strtotime($from_Date)) == date('m-Y', strtotime($to_Date))) {
							$diff_com = strtotime($from_Date) - strtotime($to_Date);
							$diff_com_val = abs(round($diff_com / 86400));
							if ($diff_com_val == $no_of_days_from) {
								$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
								if (!empty($loan->result())) {
									foreach ($loan->result() as $r_loan) {
										$loan_de_amount += $r_loan->loan_deduction_amount;
									}
								}
							}
						} else {
							$diff_com = strtotime($from_Date) - strtotime($com_start);
							$diff_com_val = abs(round($diff_com / 86400));
							$end_date_start = '01-' . date('m-Y', strtotime($to_Date));
							$diff_com1 = strtotime($to_Date) - strtotime($end_date_start);
							$diff_com_val1 = abs(round($diff_com1 / 86400));
							if ($diff_com_val == 0 && $diff_com_val1 == 0) {
								$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
								if (!empty($loan->result())) {
									foreach ($loan->result() as $r_loan) {
										$loan_de_amount += $r_loan->loan_deduction_amount;
									}
								}
							}
						}

						$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
						$total_deduction = $statutory_deductions_amount + $loan_de_amount;
						$net_annual_amt = $total_earning - $total_deduction;


						//Number of days calc
						$total_k = 1;
						$k = 1;
						$extra_amount = 0;
						$tot_days = 0;
						$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
						$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
						//$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
						$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;
						$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
						if ($emp_leaves_data->num_rows() > 0) {
							$emp_leaves = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
							foreach ($emp_leaves as $emp_leave) {
								$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
												WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
								$binds = array($emp_leave->employee_id);
								$query = $this->db->query($sql, $binds);
								$tmp = $query->result();
								$amt_deduct = 0;
								if ($emp_leave->leave_type_id == 7) {
									$tot_days_lop += $emp_leave->total_leaves;
									$amt_deduct = ($net_annual_amt / 30) * $emp_leave->total_leaves;
								} else if ($emp_leave->leave_type_id == 4) {
									$tot_days_lop = $count_remain_again = $count_remain = 0;
									if ($emp_leave->total_leaves > 15) {
										$count_remain = $emp_leave->total_leaves - 15;
										if ($count_remain <= 20) {
											$tot_days_lop += $count_remain / 2;
										} else {
											$count_remain_again = $count_remain - 20;
											$tot_days_lop += (20 / 2);
											$tot_days_lop += $count_remain_again;
										}
										// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
									}
								}
							}
						}
						$date_joins = $start_date_co;
						$date = date_create($date_joins);
						$date_join = date_format($date, "Y/m/d");
						$todays_date = $end_date_co;
						$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
						$years_count = floor($date_diff_calc / (365 * 60 * 60 * 24));
						if ($years_count > 0) {
							$years_count = $years_count;
						} else {
							$years_count = 1;
						}
						//$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
						//	print_r()
						// $totl_num_days_pres = (365 * $years_count )  - ($tot_days_lop + $absent_count);
						$totl_num_days_pres = (365 * $years_count) - ($tot_days_lop);
						$no_days_ann = (30 / 365) * $totl_num_days_pres;
						$annual_amt_pay = ($net_annual_amt / 30) * $no_days_ann;
						$dataaa = array(
							'annua_amt' => $annual_amt_pay,
							'allowance' => $allowance_amount,
							'commissions_amount' => $commissions_amount,
							'other_payments_amount' => $other_payments_amount,
							'statutory_deductions_amount' => $statutory_deductions_amount,
							'loan_de_amount' => $loan_de_amount,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
						//print_r($annual_amt_pay);exit;
					}
				} else {
					$data = array(
						'annua_amt' => $this->input->post('annual_leave_amt'),
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				}

				/* End Annual Settlement amount calc  */
				if ($check_flag == 0) {
					//$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					$setting = $this->Xin_model->read_setting_info(1);
					if ($setting[0]->enable_email_notification == 'yes') {
						if ($this->input->post('status') == 2) {
							$this->email->set_mailtype("html");
							//get leave info
							$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
							//get company info
							$cinfo = $this->Xin_model->read_company_setting_info(1);
							//get email template
							$template = $this->Xin_model->read_email_template(6);
							//get employee info
							$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

							$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
							$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

							$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
							$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

							$message = '
					<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
					<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

							hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
						} else if ($this->input->post('status') == 3) { // rejected
							$this->email->set_mailtype("html");
							//get leave info
							$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
							//get company info
							$cinfo = $this->Xin_model->read_company_setting_info(1);
							//get email template
							$template = $this->Xin_model->read_email_template(7);
							//get employee info
							$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

							$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->last_name;

							$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
							$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

							$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
							$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

							$message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
						<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
							hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
						}
					}
				}
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
			exit;
		}
	}

	public function update_annual_leave_status_bk12()
	{
		if ($this->input->post('update_type') == 'leave') {
			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $final_approval = 0;
			if ($user_info[0]->user_role_id == 1) {
				$status_updated = $this->input->post('status');

				if ($status_updated == 2) {
					$first_approval = $final_approval = 1;
				}
			} else if (in_array('256', $role_resources_ids)) {
				$status_updated = 1; //$this->input->post('status_old');

				if ($this->input->post('status') == 2) {
					$first_approval = 1;
				}
			} else if (in_array('258', $role_resources_ids)) {
				$status_updated = 1; //$this->input->post('status_old');

				if ($this->input->post('status') == 2) {
					$first_approval = $final_approval = 1;
					$status_updated = 2;
				}
			} else {
				$status_updated = $this->input->post('leave_status_old');
			}
			if ($user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)) {
				if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {
					$no_of_days = $timesheet[0]->days;
					$aval_leaves = 0;
					$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
					if (!empty($check_annual_leave_aval)) {
						$aval_leaves = $check_annual_leave_aval[0]->leave_count;
					}
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
					$carry_leave_exced = $result_carry->result();
					if ($result_carry->num_rows() > 0) {
						if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
							if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
								$no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
								$no_of_days = $carry_leave_exced[0]->remaing_leave_count;
								$aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
								$inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						} else {
							if ($no_of_days > $aval_leaves) {
								$no_of_days_annual_remain = $no_of_days - $aval_leaves;
								$no_of_days = $aval_leaves;
								$inc_days = $aval_leaves - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						}
					} else {
						if ($no_of_days > $aval_leaves) {
							$no_of_days_annual_remain = $no_of_days - $aval_leaves;
							$no_of_days = $aval_leaves;
							$inc_days = $aval_leaves - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					}
					if ((!empty($this->input->post('probation_check')) && $probation_check == 'lop')) {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$check_flag = 3;
						$no_of_days_annual_remain = 0;
						$data = array(
							'employee_id' => $timesheet_exceeds[0]->employee_id,
							'company_id' => $timesheet_exceeds[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $timesheet_exceeds[0]->from_date,
							'to_date' => $timesheet_exceeds[0]->to_date,
							'applied_on' => $timesheet_exceeds[0]->applied_on,
							'reason' => $timesheet_exceeds[0]->remarks,
							'remarks' => $timesheet_exceeds[0]->remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $timesheet_exceeds[0]->days,
							'cleared_status' => 1,
							'probation_check' => $probation_check
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						$unpaid_leave_id = $result;
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							if ($emp_leaves_data) {
								$total = $emp_leaves_data[0]->leave_count;
							} else {
								$total = 0;
							}
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
					} else {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$date_arr = explode("-", $timesheet_exceeds[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet_exceeds[0]->employee_id, 3, $year_check);
						$carry_leave_exced = $result_carry->result();
						if ($result_carry->num_rows() > 0) {
							if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
								$check_flag = 1;
								$no_of_days_annual_remain = 0;
								$data = array(
									'employee_id' => $timesheet_exceeds[0]->employee_id,
									'company_id' => $timesheet_exceeds[0]->company_id,
									'leave_type_id' => 7,
									'from_date' => $timesheet_exceeds[0]->from_date,
									'to_date' => $timesheet_exceeds[0]->to_date,
									'applied_on' => $timesheet_exceeds[0]->applied_on,
									'reason' => $timesheet_exceeds[0]->remarks,
									'remarks' => $timesheet_exceeds[0]->remarks,
									'status' => '2',
									'is_notify' => '1',
									'created_at' => date('Y-m-d h:i:s'),
									'days' => $timesheet_exceeds[0]->days,
									'cleared_status' => 1,
									'probation_check' => $probation_check
								);
								$result = $this->Timesheet_model->add_leave_record_new($data);
								$unpaid_leave_id = $result;
								$timesheet = $this->Timesheet_model->read_leave_information($result);
								if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->leave_type_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									$count = $xin_leave_type[0]->leave_count;
									$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
									$emp_leaves_data = $this->Timesheet_model->annual_leave_availablefor_emp_limt($employees_id, $leaves_id);
									if ($emp_leaves_data) {
										$total = $emp_leaves_data[0]->leave_count;
									} else {
										$total = 0;
									}
									$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									$carry_leave = $result_carry->result();
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$date_arr = explode("-", $timesheet[0]->from_date);
									$year_check = $date_arr[0];
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									if ($result->num_rows() == 0) {
										$data_insert = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											'create_date' => date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_insert($data_insert);
									} else {
										$carry_leave = $result_carry->result(); //print_r($carry_leave);exit;
										$data_update = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											//'create_date'=> date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
									}
								} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
									$carry_leave = $result_carry->result();
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->employee_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
								$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
							} else {
								$data = array(
									'status' => $this->input->post('status'),
									'remarks' => $qt_remarks,
									'allotted_leave' => $aval_leaves,
									'to_date' => $next_form_date_ann,
									'days' => $no_of_days,
									'cleared_status' => 1,
									'annua_amt' => $this->input->post('annual_leave_amt'),
									'first_approval' => $first_approval,
									'final_approval' => $final_approval,
									'updated_date' => date('Y-m-d')
								);
								$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
							}
						} else {
							$data = array(
								'status' => $this->input->post('status'),
								'remarks' => $qt_remarks,
								'allotted_leave' => $aval_leaves,
								'to_date' => $next_form_date_ann,
								'days' => $no_of_days,
								'cleared_status' => 1,
								'annua_amt' => $this->input->post('annual_leave_amt'),
								'first_approval' => $first_approval,
								'final_approval' => $final_approval,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
						}
					}
				} else {
					if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
						$check_flag = 2;
					}
					$data = array(
						'status' => $this->input->post('status'),
						'annua_amt' => $this->input->post('annual_leave_amt'),
						'first_approval' => $first_approval,
						'final_approval' => $final_approval,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				}
				if ($result == TRUE) {
					if ($no_of_days_annual_remain > 0) {
						$next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
						$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
						if (!empty($checl_already_exists_annual)) {
							$data = array(
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
							$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else {
							$data = array(
								'employee_id' => $timesheet[0]->employee_id,
								'company_id' => $timesheet[0]->company_id,
								'leave_type_id' => 7,
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'applied_on' => date('Y-m-d h:i:s'),
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'created_at' => date('Y-m-d h:i:s'),
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check
							);
							$result = $this->Timesheet_model->add_leave_record_new($data);
							$unpaid_leave_id = $result;
							$timesheet = $this->Timesheet_model->read_leave_information($result);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $leaves_id, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						}
					}
					if ($check_flag == 0) {
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						//carryforward
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = 3;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							//$leave_half_day_opt = $timesheet[0]->is_half_day;

							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}

							$leave_remaining_total = $leave_remaining_total;

							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result();
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							//$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

							$total = $carry_leave[0]->remaing_leave_count;
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					} else if ($check_flag == 1) {
						$Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					}
					if ($this->input->post('annual_leave_amt') == 0) {

						/* Annual Settlement amount calc  */
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						$user_id = $timesheet[0]->employee_id;
						$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						//Check annual leave exists for the corresponding employee
						$annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
						if ($annual_leaves_exits) {
							$joining_date = $this->Timesheet_model->joining_date($user_id);
							$start_date_y_m = date('Y-m', strtotime($annual_leaves_exits[0]->from_date));
						} else {
							$joining_date = $this->Timesheet_model->joining_date($user_id);
							$start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
						}
						// end annual leave exists check
						$net_annual_amt = 0;
						$annual_amt_pay = $anual_days_leave = 0;
						$basic_salary = $user_info[0]->basic_salary;
						$allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
						$allowances = $this->Employees_model->set_employee_allowances_for_leavesalary($user_id);
						$system = $this->Xin_model->read_setting_info(1);
						if (!empty($allowances->result())) {
							foreach ($allowances->result() as $sl_allowances) {
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$iallowance_amount = $sl_allowances->allowance_amount / 2;
									} else {
										$iallowance_amount = $sl_allowances->allowance_amount;
									}
									$allowance_amount += $iallowance_amount;
								} else {
									//$eallowance_amount = $sl_allowances->allowance_amount;
									if ($sl_allowances->is_allowance_taxable == 1) {
										if ($sl_allowances->amount_option == 0) {
											$iallowance_amount = $sl_allowances->allowance_amount;
										} else {
											$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
										}
										$allowance_amount -= $iallowance_amount;
									} else if ($sl_allowances->is_allowance_taxable == 2) {
										if ($sl_allowances->amount_option == 0) {
											$iallowance_amount = $sl_allowances->allowance_amount / 2;
										} else {
											$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
										}
										$allowance_amount -= $iallowance_amount;
									} else {
										if ($sl_allowances->amount_option == 0) {
											$iallowance_amount = $sl_allowances->allowance_amount;
										} else {
											$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
										}
										$allowance_amount += $iallowance_amount;
									}
								}
							}
						}
						$commissions = $this->Employees_model->set_employee_commissions_for_leavesalary($user_id);
						if (!empty($commissions->result())) {
							foreach ($commissions->result() as $sl_commissions) {
								$pg_commissions_amount = $sl_commissions->commission_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$ecommissions_amount = $sl_commissions->commission_amount / 2;
									} else {
										$ecommissions_amount = $sl_commissions->commission_amount;
									}
									$commissions_amount += $ecommissions_amount;
								} else {
									if ($sl_commissions->is_commission_taxable == 1) {
										if ($sl_commissions->amount_option == 0) {
											$ecommissions_amount = $sl_commissions->commission_amount;
										} else {
											$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
										}
										$commissions_amount -= $ecommissions_amount;
									} else if ($sl_commissions->is_commission_taxable == 2) {
										if ($sl_commissions->amount_option == 0) {
											$ecommissions_amount = $sl_commissions->commission_amount / 2;
										} else {
											$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
										}
										$commissions_amount -= $ecommissions_amount;
									} else {
										if ($sl_commissions->amount_option == 0) {
											$ecommissions_amount = $sl_commissions->commission_amount;
										} else {
											$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
										}
										$commissions_amount += $ecommissions_amount;
									}
								}
							}
						}
						$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_for_leavesalary($user_id);
						if (!empty($statutory_deductions->result())) {
							foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
								$sta_salary = $basic_salary;
								$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$single_sd = $st_amount / 2;
									} else {
										$single_sd = $st_amount;
									}
									$statutory_deductions_amount += $single_sd;
								} else {
									if ($sl_statutory_deductions->statutory_options == 0) {
										$single_sd = $sl_statutory_deductions->deduction_amount;
									} else {
										$single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
									}
									$statutory_deductions_amount += $single_sd;
								}
							}
						}
						$other_payments = $this->Employees_model->set_employee_other_payments_leave_salary($user_id);
						if (!empty($other_payments->result())) {
							foreach ($other_payments->result() as $sl_other_payments) {
								if ($system[0]->is_half_monthly == 1) {
									if ($system[0]->half_deduct_month == 2) {
										$epayments_amount = $sl_other_payments->payments_amount / 2;
									} else {
										$epayments_amount = $sl_other_payments->payments_amount;
									}
									$other_payments_amount += $epayments_amount;
								} else {
									//$epayments_amount = $sl_other_payments->payments_amount;
									if ($sl_other_payments->is_otherpayment_taxable == 1) {
										if ($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount;
										} else {
											$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount -= $epayments_amount;
									} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
										if ($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount / 2;
										} else {
											$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount -= $epayments_amount;
									} else {
										if ($sl_other_payments->amount_option == 0) {
											$epayments_amount = $sl_other_payments->payments_amount;
										} else {
											$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
										}
										$other_payments_amount += $epayments_amount;
									}
								}
							}
						}
						if ($timesheet[0]->paid_status == 'N') {
							$anual_days_leave = $timesheet[0]->days;
							$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id, $joining_date[0]->date_of_joining);
							if ($check_already_exists_paid) {
								$applied_date = $check_already_exists_paid[0]->applied_on;
								$date_arr = explode("-", $applied_date);
								$yr_d_paid = $date_arr[0];

								$date = date_create($check_already_exists_paid[0]->applied_on);
								$not_paid_year = date_format($date, "Y");
								$difference_years = $not_paid_year - $yr_d_paid;

								//joining date difference
								$date_joins = $joining_date[0]->date_of_joining;
								$date = date_create($date_joins);
								$date_join = date_format($date, "Y");
								$todays_date = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
								$join_differ = $todays_date - $date_join;
								if ($join_differ > 0) {
									$days_add_start = $join_differ * 365;
								} else {
									$days_add_start = 1 * 365;
								}

								//end joining date difference
								if ($difference_years > 0) {
									$days_add = $difference_years * 365;
								} else {
									$days_add = 1 * 365;
								}

								$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
								$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
							} else {
								$date_joins = $joining_date[0]->date_of_joining;
								$date = date_create($date_joins);
								$date_join = date_format($date, "Y/m/d");
								$todays_date = date('Y-m-d');
								$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
								$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
								$days_add = $years * 365;
								if ($days_add == 0) {
									$start_date_co = $joining_date[0]->date_of_joining;
									//$end_date_co = date('Y-m-d', strtotime($timesheet[0]->to_date));
									$date = date($joining_date[0]->date_of_joining);
									$date1 = date_create($date);
									$date2 = date_create(date('Y-m-d'));
									$diff = date_diff($date1, $date2);
									$day_diff = $diff->format("%a") + 1;
									if ($day_diff > 365) {
										$monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
										if (isset($timesheet[0]->days)) {
											$annul_days = $timesheet[0]->days;
										} else {
											$annul_days = 0;
										}
										$flag = 1;
									} else {
										$annul_days = 0;
										$flag = 0;
										$monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
									}

									$end_date_co = date('Y-m-d', strtotime($monthstart));
								} else {
									$start_date_co = $joining_date[0]->date_of_joining;
									$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
								}
							}

							$arry_years = array();
							$st = '';
							$p_count_val = $tot_days = 0;
							$off_day_arr = array();
							$holiday_arr = array();
							$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
							if (!is_null($office_shift)) {
								$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
								if ($h_date_chck->num_rows() > 0) {
									$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
									foreach ($h_date as $val) {
										$begin = new DateTime($val->start_date);
										$end = new DateTime($val->end_date);
										$end = $end->modify('+1 day');

										$interval = new DateInterval('P1D');
										$daterange = new DatePeriod($begin, $interval, $end);

										foreach ($daterange as $date) {
											$holiday_arr[] = $date->format("Y-m-d");
										}
									}
									$p_count_val += count($holiday_arr);
								}
							}
							$leave_arr = array();
							$half_leave_arr = array();
							$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
							if ($leave_date_chck->num_rows() > 0) {
								$leave_date = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
								foreach ($leave_date->result() as $leave_dates) {
									$begin1 = new DateTime($leave_dates->from_date);
									$end1 = new DateTime($leave_dates->to_date);
									$end1 = $end1->modify('+1 day');
									$half_day_check = $leave_dates->is_half_day;
									$interval1 = new DateInterval('P1D');
									$daterange1 = new DatePeriod($begin1, $interval1, $end1);

									foreach ($daterange1 as $date1) {
										if ($half_day_check == 1) {
											$half_leave_arr[] = $date1->format("Y-m-d");
										} else {
											$leave_arr[] = $date1->format("Y-m-d");
										}
									}
								}
							}
							$present_arr = array();
							//$st = $this->db->last_query();
							$total_leaves = count($leave_arr) + count($half_leave_arr);
							$p_count_val += abs($total_leaves - $tot_days);
							$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
							$absent_count = 0;
							$leave_count = 0;
							$month_year = date('Y-m', strtotime($start_date_co));

							$user = $this->Xin_model->read_user_info($user_id);

							$month_year_att = $start_date_co;
							$month_year_att_end = $end_date_co;
							$month_year_att_end = date('Y-m-d', strtotime($month_year_att_end . ' +1 day'));
							$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
							if (!is_null($office_shift)) {
								$day_start = date('d', strtotime($start_date_co));
								$period = new DatePeriod(
									new DateTime($month_year_att),
									new DateInterval('P1D'),
									new DateTime($month_year_att_end)
								);
								$i = 1;

								foreach ($period as $key => $value) {
									$attendance_date = $value->format('Y-m-d');
									$attendance_date_month = date('m', strtotime($attendance_date));
									$attendance_date_Year = date('Y', strtotime($attendance_date));
									$check_attendence_exists = $this->Employees_model->attendence_exists_check($user_id, $attendance_date_month, $attendance_date_Year);
									if ($check_attendence_exists) {
										$last_attendence_date = $this->Employees_model->last_attendence_in_a_month($user_id, $attendance_date_month, $attendance_date_Year);
										if ($flag = 0) {
											if (strtotime($last_attendence_date[0]->attendance_date) >= strtotime($attendance_date)) {

												$i++;
												$get_day = strtotime($attendance_date);
												$day = date('l', $get_day);
												$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
												if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
													$holiday_count += 1;
												} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
													$holiday_count += 1;
												} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
													$holiday_count += 1;
												} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
													$holiday_count += 1;
												} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
													$holiday_count += 1;
												} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
													$holiday_count += 1;
												} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
													$holiday_count += 1;
												} else if ($check->num_rows() > 0) {
													$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
													$present_count += 1;
												} else if (in_array($attendance_date, $holiday_arr)) { // holiday
													$public_holiday_count += 1;
												} else if (in_array($attendance_date, $leave_arr)) { // on leave
													$leave_count += 1;
												} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
													$status = 'HDL';
													$leave__half_day_count += 0.5;
												} else {
													$absent_count += 1;
													//$pcount += 0;
												}
											}
										} else {

											$i++;
											$get_day = strtotime($attendance_date);
											$day = date('l', $get_day);
											$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
											if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
												$holiday_count += 1;
											} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
												$holiday_count += 1;
											} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
												$holiday_count += 1;
											} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
												$holiday_count += 1;
											} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
												$holiday_count += 1;
											} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
												$holiday_count += 1;
											} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
												$holiday_count += 1;
											} else if ($check->num_rows() > 0) {
												$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
												$present_count += 1;
											} else if (in_array($attendance_date, $holiday_arr)) { // holiday
												$public_holiday_count += 1;
											} else if (in_array($attendance_date, $leave_arr)) { // on leave
												$leave_count += 1;
											} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
												$status = 'HDL';
												$leave__half_day_count += 0.5;
											} else {
												$absent_count += 1;
												//$pcount += 0;
											}
										}
									}
								}
							}
							//Number of days calc
							$total_k = 1;
							$k = 1;
							$extra_amount = 0;
							$tot_days = 0;
							$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
							$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
							//$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
							$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

							$from_Date = $timesheet[0]->from_date;
							$to_Date = $timesheet[0]->to_date;
							$com_start = '01-' . date('m-Y', strtotime($from_Date));
							$no_of_days_from = date('t', strtotime($from_Date));
							$com_end = $no_of_days_from . date('m-Y', strtotime($from_Date));
							if (date('m-Y', strtotime($from_Date)) == date('m-Y', strtotime($to_Date))) {
								$diff_com = strtotime($from_Date) - strtotime($to_Date);
								$diff_com_val = abs(round($diff_com / 86400));
								if ($diff_com_val == $no_of_days_from) {
									$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
									if (!empty($loan->result())) {
										foreach ($loan->result() as $r_loan) {
											$loan_de_amount += $r_loan->loan_deduction_amount;
										}
									}
								}
							} else {
								$diff_com = strtotime($from_Date) - strtotime($com_start);
								$diff_com_val = abs(round($diff_com / 86400));
								$end_date_start = '01-' . date('m-Y', strtotime($to_Date));
								$diff_com1 = strtotime($to_Date) - strtotime($end_date_start);
								$diff_com_val1 = abs(round($diff_com1 / 86400));
								if ($diff_com_val == 0 && $diff_com_val1 == 0) {
									$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
									if (!empty($loan->result())) {
										foreach ($loan->result() as $r_loan) {
											$loan_de_amount += $r_loan->loan_deduction_amount;
										}
									}
								}
							}

							$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
							$total_deduction = $statutory_deductions_amount + $loan_de_amount;
							$net_annual_amt = $total_earning - $total_deduction;

							$emp_leaves = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
							if ($emp_leaves->num_rows() > 0) {
								foreach ($emp_leaves->result() as $emp_leave) {
									//$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id,$start_date_y_m,$emp_leave->leave_type_id);

									$amt_deduct = 0;
									if ($emp_leave->leave_type_id == 7) {
										$tot_days_lop += $emp_leave->total_leaves;
										$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
									} else if ($emp_leave->leave_type_id == 4) {
										$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($user_id, 4);
										if (isset($carry_count[0]->create_date)) {
											$yr_check_sick = date('Y', strtotime($carry_count[0]->create_date));
										} else {
											$yr_check_sick = date('Y');
										}
										$total_half_paid_counts = $total_unpaid_counts = $total_paid_counts = $half_present_days = 0;
										$total_paid_count_exits = $this->Timesheet_model->select_leave_paid_list_new($user_id, $yr_check_sick, $emp_leave->leave_id);
										if (isset($total_paid_count_exits[0])) {
											if ($emp_leave->is_half_day == 1) {
												$leave__half_day_count += 0.5;
											}
											foreach ($total_paid_count_exits as $sickleave_calc) {
												$total_half_paid_counts += $sickleave_calc->total_half_paid_count;
												$total_unpaid_counts += $sickleave_calc->total_unpaid_count;
												$total_paid_counts += $sickleave_calc->total_paid_count;
											}
											if ($total_half_paid_counts > 0) {
												$tot_days_lop += $total_half_paid_counts / 2;
												$half_present_days = $total_half_paid_counts / 2;
											}
											if ($total_unpaid_counts > 0) {
												$tot_days_lop += $total_unpaid_counts;
											}
											if ($total_paid_counts > 0 || $half_present_days > 0) {

												// $present_count += $total_paid_counts + $half_present_days;
											}
										}
									}
								}
							}
							$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count + $annul_days) - ($tot_days_lop + $absent_count);


							//Number of days calc
							$total_k = 1;
							$k = 1;
							$extra_amount = 0;
							$tot_days = 0;
							$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
							$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
							//$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
							$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;
							$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
							if ($emp_leaves_data->num_rows() > 0) {
								$emp_leaves = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
								foreach ($emp_leaves as $emp_leave) {
									$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
												WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
									$binds = array($emp_leave->employee_id);
									$query = $this->db->query($sql, $binds);
									$tmp = $query->result();
									$amt_deduct = 0;
									if ($emp_leave->leave_type_id == 7) {
										$tot_days_lop += $emp_leave->total_leaves;
										$amt_deduct = ($net_annual_amt / 30) * $emp_leave->total_leaves;
									} else if ($emp_leave->leave_type_id == 4) {
										$tot_days_lop = $count_remain_again = $count_remain = 0;
										if ($emp_leave->total_leaves > 15) {
											$count_remain = $emp_leave->total_leaves - 15;
											if ($count_remain <= 20) {
												$tot_days_lop += $count_remain / 2;
											} else {
												$count_remain_again = $count_remain - 20;
												$tot_days_lop += (20 / 2);
												$tot_days_lop += $count_remain_again;
											}
											// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
										}
									}
								}
							}
							$date_joins = $start_date_co;
							$date = date_create($date_joins);
							$date_join = date_format($date, "Y/m/d");
							$todays_date = $end_date_co;
							$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
							$years_count = floor($date_diff_calc / (365 * 60 * 60 * 24));
							if ($years_count > 0) {
								$years_count = $years_count;
							} else {
								$years_count = 1;
							}
							//$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count) - ($tot_days_lop + $absent_count);
							//	print_r()
							// $totl_num_days_pres = (365 * $years_count )  - ($tot_days_lop + $absent_count);
							//	$totl_num_days_pres = (365 * $years_count)  - ($tot_days_lop);
							$no_days_ann = (30 / 365) * $totl_num_days_pres;
							$annual_amt_pay = ($net_annual_amt / 30) * $no_days_ann;
							$annual_amt_pay = number_format($annual_amt_pay, 3);
							$dataaa = array(
								'annua_amt' => $annual_amt_pay,
								'allowance' => $allowance_amount,
								'commissions_amount' => $commissions_amount,
								'other_payments_amount' => $other_payments_amount,
								'statutory_deductions_amount' => $statutory_deductions_amount,
								'loan_de_amount' => $loan_de_amount,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
							//print_r($annual_amt_pay);exit;
						}
					} else {
						$data = array(
							'annua_amt' => $this->input->post('annual_leave_amt'),
							'first_approval' => $first_approval,
							'final_approval' => $final_approval,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					}

					/* End Annual Settlement amount calc  */
					if ($check_flag == 0) {
						//$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$setting = $this->Xin_model->read_setting_info(1);
						if ($setting[0]->enable_email_notification == 'yes') {
							if ($this->input->post('status') == 2) {
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(6);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '
					<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
					<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							} else if ($this->input->post('status') == 3) { // rejected
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(7);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
						<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							}
						}
					}
				}
			} else {
				$data = array(
					'status' => $status_updated,
					'first_approval' => $first_approval,
					'final_approval' => $final_approval,
					'updated_date' => date('Y-m-d')
				);
				$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				$this->output($Return);
				exit;
			}
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
			$this->output($Return);
			exit;
		}
	}

	public function my_team_annual_leave_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/annuval_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		$leave = $this->Timesheet_model->get_annual_leaves();
		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			$user = $this->Xin_model->read_user_info($r->employee_id);
			if ($user[0]->reports_to == $session['user_id']) {
				// get start date and end date
				$user = $this->Xin_model->read_user_info($r->employee_id);
				if (!is_null($user)) {
					$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
					// department
					$department = $this->Department_model->read_department_information($user[0]->department_id);
					if (!is_null($department)) {
						$department_name = $department[0]->department_name;
					} else {
						$department_name = '--';
					}
				} else {
					$full_name = '--';
					$department_name = '--';
				}

				// get leave type
				$type_name = 'Annual Leave';

				// get company
				$company = $this->Xin_model->read_company_info($r->company_id);
				if (!is_null($company)) {
					$comp_name = $company[0]->name;
				} else {
					$comp_name = '--';
				}

				$datetime1 = new DateTime($r->from_date);
				$datetime2 = new DateTime($r->to_date);
				$interval = $datetime1->diff($datetime2);
				if (strtotime($r->from_date) == strtotime($r->to_date)) {
					$no_of_days = 1;
				} else {
					$no_of_days = $interval->format('%a') + 1;
				}
				$applied_on = $this->Xin_model->set_date_format($r->applied_on);
				/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;

				if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
				elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
				elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
				else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
				endif;


				if (in_array('288', $role_resources_ids)) { //edit
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-leave_id="' . $r->id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
				} else {
					$edit = '';
				}
				if (in_array('289', $role_resources_ids)) { // delete
					$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
				} else {
					$delete = '';
				}
				if (in_array('290', $role_resources_ids) || $reports_to > 0) { //view
					$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/leave_details/id/' . $r->id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
				} else {
					$view = '';
				}
				$combhr = $edit . $view . $delete;
				$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_reason') . ': ' . $r->remarks . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';

				$data[] = array(
					$combhr,
					$type_name,
					$department_name,
					$full_name,
					$duration,
					$applied_on
				);
			}
		}
		$output = array(
			"draw" => $draw,
			// "recordsTotal" => $leave->num_rows(),
			// "recordsFiltered" => $leave->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	function refreshAnnualLeaveCalc_bk1()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$id = $this->input->get('leave_id');
		/* Annual Settlement amount calc  */
		$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
		$user_id = $timesheet[0]->employee_id;
		$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
		//Check annual leave exists for the corresponding employee
		$annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
		if ($annual_leaves_exits) {
			//echo 'jo';exit;
		} else {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
		}
		// end annual leave exists check
		$net_annual_amt = 0;
		$annual_amt_pay = $anual_days_leave = 0;
		$basic_salary = $user_info[0]->basic_salary;
		$allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
		$allowances = $this->Employees_model->set_employee_allowances_for_leavesalary($user_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!empty($allowances->result())) {
			foreach ($allowances->result() as $sl_allowances) {
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$iallowance_amount = $sl_allowances->allowance_amount / 2;
					} else {
						$iallowance_amount = $sl_allowances->allowance_amount;
					}
					$allowance_amount += $iallowance_amount;
				} else {
					//$eallowance_amount = $sl_allowances->allowance_amount;
					if ($sl_allowances->is_allowance_taxable == 1) {
						if ($sl_allowances->amount_option == 0) {
							$iallowance_amount = $sl_allowances->allowance_amount;
						} else {
							$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
						}
						$allowance_amount -= $iallowance_amount;
					} else if ($sl_allowances->is_allowance_taxable == 2) {
						if ($sl_allowances->amount_option == 0) {
							$iallowance_amount = $sl_allowances->allowance_amount / 2;
						} else {
							$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
						}
						$allowance_amount -= $iallowance_amount;
					} else {
						if ($sl_allowances->amount_option == 0) {
							$iallowance_amount = $sl_allowances->allowance_amount;
						} else {
							$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
						}
						$allowance_amount += $iallowance_amount;
					}
				}
			}
		}
		$commissions = $this->Employees_model->set_employee_commissions_for_leavesalary($user_id);
		if (!empty($commissions->result())) {
			foreach ($commissions->result() as $sl_commissions) {
				$pg_commissions_amount = $sl_commissions->commission_amount;
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$ecommissions_amount = $sl_commissions->commission_amount / 2;
					} else {
						$ecommissions_amount = $sl_commissions->commission_amount;
					}
					$commissions_amount += $ecommissions_amount;
				} else {
					if ($sl_commissions->is_commission_taxable == 1) {
						if ($sl_commissions->amount_option == 0) {
							$ecommissions_amount = $sl_commissions->commission_amount;
						} else {
							$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
						}
						$commissions_amount -= $ecommissions_amount;
					} else if ($sl_commissions->is_commission_taxable == 2) {
						if ($sl_commissions->amount_option == 0) {
							$ecommissions_amount = $sl_commissions->commission_amount / 2;
						} else {
							$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
						}
						$commissions_amount -= $ecommissions_amount;
					} else {
						if ($sl_commissions->amount_option == 0) {
							$ecommissions_amount = $sl_commissions->commission_amount;
						} else {
							$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
						}
						$commissions_amount += $ecommissions_amount;
					}
				}
			}
		}
		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_for_leavesalary($user_id);
		if (!empty($statutory_deductions->result())) {
			foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
				$sta_salary = $basic_salary;
				$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$single_sd = $st_amount / 2;
					} else {
						$single_sd = $st_amount;
					}
					$statutory_deductions_amount += $single_sd;
				} else {
					if ($sl_statutory_deductions->statutory_options == 0) {
						$single_sd = $sl_statutory_deductions->deduction_amount;
					} else {
						$single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
					}
					$statutory_deductions_amount += $single_sd;
				}
			}
		}
		$other_payments = $this->Employees_model->set_employee_other_payments_leave_salary($user_id);
		if (!empty($other_payments->result())) {
			foreach ($other_payments->result() as $sl_other_payments) {
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$epayments_amount = $sl_other_payments->payments_amount / 2;
					} else {
						$epayments_amount = $sl_other_payments->payments_amount;
					}
					$other_payments_amount += $epayments_amount;
				} else {
					//$epayments_amount = $sl_other_payments->payments_amount;
					if ($sl_other_payments->is_otherpayment_taxable == 1) {
						if ($sl_other_payments->amount_option == 0) {
							$epayments_amount = $sl_other_payments->payments_amount;
						} else {
							$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
						}
						$other_payments_amount -= $epayments_amount;
					} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
						if ($sl_other_payments->amount_option == 0) {
							$epayments_amount = $sl_other_payments->payments_amount / 2;
						} else {
							$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
						}
						$other_payments_amount -= $epayments_amount;
					} else {
						if ($sl_other_payments->amount_option == 0) {
							$epayments_amount = $sl_other_payments->payments_amount;
						} else {
							$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
						}
						$other_payments_amount += $epayments_amount;
					}
				}
			}
		}
		if ($timesheet[0]->paid_status == 'N') {
			$anual_days_leave = $timesheet[0]->days;
			$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id, $joining_date[0]->date_of_joining);
			if ($check_already_exists_paid) {
				$applied_date = $check_already_exists_paid[0]->applied_on;
				$date_arr = explode("-", $applied_date);
				$yr_d_paid = $date_arr[0];

				$date = date_create($check_already_exists_paid[0]->applied_on);
				$not_paid_year = date_format($date, "Y");
				$difference_years = $not_paid_year - $yr_d_paid;

				//joining date difference
				$date_joins = $joining_date[0]->date_of_joining;
				$date = date_create($date_joins);
				$date_join = date_format($date, "Y");
				$todays_date = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
				$join_differ = $todays_date - $date_join;
				if ($join_differ > 0) {
					$days_add_start = $join_differ * 365;
				} else {
					$days_add_start = 1 * 365;
				}

				//end joining date difference
				if ($difference_years > 0) {
					$days_add = $difference_years * 365;
				} else {
					$days_add = 1 * 365;
				}

				$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
				$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
			} else {
				$date_joins = $joining_date[0]->date_of_joining;
				$date = date_create($date_joins);
				$date_join = date_format($date, "Y/m/d");
				$todays_date = date('Y-m-d');
				$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
				$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				$days_add = $years * 365;
				$start_date_co = $joining_date[0]->date_of_joining;
				$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
			}
			$arry_years = array();
			$st = '';
			$p_count_val = $tot_days = 0;
			$off_day_arr = array();
			$holiday_arr = array();
			$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
			if (!is_null($office_shift)) {
				$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
				if ($h_date_chck->num_rows() > 0) {
					$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
					foreach ($h_date as $val) {
						$begin = new DateTime($val->start_date);
						$end = new DateTime($val->end_date);
						$end = $end->modify('+1 day');

						$interval = new DateInterval('P1D');
						$daterange = new DatePeriod($begin, $interval, $end);

						foreach ($daterange as $date) {
							$holiday_arr[] = $date->format("Y-m-d");
						}
					}
					$p_count_val += count($holiday_arr);
				}
			}
			$leave_arr = array();
			$half_leave_arr = array();
			$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
			if ($leave_date_chck->num_rows() > 0) {
				$leave_date = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
				foreach ($leave_date as $leave_dates) {
					$begin1 = new DateTime($leave_dates->from_date);
					$end1 = new DateTime($leave_dates->to_date);
					$end1 = $end1->modify('+1 day');
					$half_day_check = $leave_dates->is_half_day;
					$interval1 = new DateInterval('P1D');
					$daterange1 = new DatePeriod($begin1, $interval1, $end1);

					foreach ($daterange1 as $date1) {
						if ($half_day_check == 1) {
							$half_leave_arr[] = $date1->format("Y-m-d");
						} else {
							$leave_arr[] = $date1->format("Y-m-d");
						}
					}
				}
			}
			$present_arr = array();
			//$st = $this->db->last_query();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$month_year = date('Y-m', strtotime($start_date_co));
			if (strtotime($month_year) == strtotime(date('Y-m'))) {
				$month_year_att = $month_year . '-01';
				$month_year_att_end = $month_year . '-' . date('d');
				$startDate = new DateTime($month_year_att);
				$endDate = new DateTime($month_year_att_end);
				$difference = $endDate->diff($startDate);
				$difference_days = $difference->format("%a");
			} else if (strtotime($month_year) <= strtotime(date('Y-m'))) {
				$month_year_att = $start_date_co;
				$month_year_att_end = $end_date_co;
				$startDate = new DateTime($month_year_att);
				$endDate = new DateTime($month_year_att_end);
				$difference = $endDate->diff($startDate);
				$difference_days = $difference->format("%a");
			} else if (strtotime($month_year) >= strtotime(date('Y-m'))) {
				$difference_days = 0;
			}
			$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
			if (!is_null($office_shift)) {
				$day_start = date('d', strtotime($start_date_co));
				$period = new DatePeriod(
					new DateTime($month_year_att),
					new DateInterval('P1D'),
					new DateTime($month_year_att_end)
				);
				foreach ($period as $key => $value) {
					$attendance_date = $value->format('Y-m-d');
					$get_day = strtotime($attendance_date);
					$day = date('l', $get_day);
					$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
					if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
						$holiday_count += 1;
					} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
						$holiday_count += 1;
					} else if (in_array($attendance_date, $holiday_arr)) { // holiday
						$public_holiday_count += 1;
					} else if (in_array($attendance_date, $leave_arr)) { // on leave
						$leave_count += 1;
					} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
						$status = 'HDL';
						$leave__half_day_count += 0.5;
					} else if ($check->num_rows() > 0) {
						$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
						$present_count += 1;
					} else {
						$absent_count += 1;
						//$pcount += 0;
					}
				}
			}
			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			//$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

			$from_Date = $timesheet[0]->from_date;
			$to_Date = $timesheet[0]->to_date;
			$com_start = '01-' . date('m-Y', strtotime($from_Date));
			$no_of_days_from = date('t', strtotime($from_Date));
			$com_end = $no_of_days_from . date('m-Y', strtotime($from_Date));
			if (date('m-Y', strtotime($from_Date)) == date('m-Y', strtotime($to_Date))) {
				$diff_com = strtotime($from_Date) - strtotime($to_Date);
				$diff_com_val = abs(round($diff_com / 86400));
				if ($diff_com_val == $no_of_days_from) {
					$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
					if (!empty($loan->result())) {
						foreach ($loan->result() as $r_loan) {
							$loan_de_amount += $r_loan->loan_deduction_amount;
						}
					}
				}
			} else {
				$diff_com = strtotime($from_Date) - strtotime($com_start);
				$diff_com_val = abs(round($diff_com / 86400));
				$end_date_start = '01-' . date('m-Y', strtotime($to_Date));
				$diff_com1 = strtotime($to_Date) - strtotime($end_date_start);
				$diff_com_val1 = abs(round($diff_com1 / 86400));
				if ($diff_com_val == 0 && $diff_com_val1 == 0) {
					$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
					if (!empty($loan->result())) {
						foreach ($loan->result() as $r_loan) {
							$loan_de_amount += $r_loan->loan_deduction_amount;
						}
					}
				}
			}

			$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
			$total_deduction = $statutory_deductions_amount + $loan_de_amount;
			$net_annual_amt = $total_earning - $total_deduction;


			$emp_leaves_data = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
			if ($emp_leaves_data->num_rows() > 0) {
				$emp_leaves = $this->Timesheet_model->leave_date_new($user_id, $start_date_co, $end_date_co);
				foreach ($emp_leaves as $emp_leave) {
					$sql = "Select SUM(days) AS `total_days` FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id
											WHERE employee_id=? and p.status='2' and p.leave_type_id='" . $emp_leave->leave_type_id . "' and p.from_date >= '" . $start_date_co . "'  and to_date <= '" . $end_date_co . "'";
					$binds = array($emp_leave->employee_id);
					$query = $this->db->query($sql, $binds);
					$tmp = $query->result();
					$amt_deduct = 0;
					if ($emp_leave->leave_type_id == 7) {
						$tot_days_lop += $emp_leave->total_leaves;
						$amt_deduct = ($net_annual_amt / 30) * $emp_leave->total_leaves;
					} else if ($emp_leave->leave_type_id == 4) {
						$tot_days_lop = $count_remain_again = $count_remain = 0;
						if ($emp_leave->total_leaves > 15) {
							$count_remain = $emp_leave->total_leaves - 15;
							if ($count_remain <= 20) {
								$tot_days_lop += $count_remain / 2;
							} else {
								$count_remain_again = $count_remain - 20;
								$tot_days_lop += (20 / 2);
								$tot_days_lop += $count_remain_again;
							}
							// $amt_deduct = ($net_amount / 30) *  $tot_days_lop;
						}
					}
				}
			}
			// print_r($net_annual_amt);exit;

			$date_joins = $start_date_co;
			$date = date_create($date_joins);
			$date_join = date_format($date, "Y/m/d");
			$todays_date = $end_date_co;
			$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
			$years_count = floor($date_diff_calc / (365 * 60 * 60 * 24));
			if ($years_count > 0) {
				$years_count = $years_count;
			} else {
				$years_count = 1;
			}
			// $totl_num_days_pres = (365 * $years_count )  - ($tot_days_lop + $absent_count);
			$totl_num_days_pres = (365 * $years_count) - ($tot_days_lop);
			$no_days_ann = (30 / 365) * $totl_num_days_pres;
			$annual_amt_pay = ($net_annual_amt / 30) * $no_days_ann;
			$dataaa = array(
				'annua_amt' => $annual_amt_pay,
				'allowance' => $allowance_amount,
				'commissions_amount' => $commissions_amount,
				'other_payments_amount' => $other_payments_amount,
				'statutory_deductions_amount' => $statutory_deductions_amount,
				'loan_de_amount' => $loan_de_amount,
				'updated_date' => date('Y-m-d')
			);
			$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
			if ($result) {
				$Return['result'] = 'Success';
			} else {
				$Return['error'] = 'Something went to wrong';
			}

			//print_r($annual_amt_pay);exit;
		} else {
			$Return['error'] = 'Amount already paid';
		}
		$this->output($Return);
		exit;
		/* End Annual Settlement amount calc  */
	}

	function refreshAnnualLeaveCalc_bk123()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$id = $this->input->get('leave_id');
		/* Annual Settlement amount calc  */
		$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
		$user_id = $timesheet[0]->employee_id;
		$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
		//Check annual leave exists for the corresponding employee
		$annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
		if ($annual_leaves_exits) {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($annual_leaves_exits[0]->from_date));
		} else {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
		}
		// end annual leave exists check
		$net_annual_amt = 0;
		$annual_amt_pay = $anual_days_leave = 0;
		$basic_salary = $user_info[0]->basic_salary;
		$allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
		$allowances = $this->Employees_model->set_employee_allowances_for_leavesalary($user_id);
		$system = $this->Xin_model->read_setting_info(1);
		if (!empty($allowances->result())) {
			foreach ($allowances->result() as $sl_allowances) {
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$iallowance_amount = $sl_allowances->allowance_amount / 2;
					} else {
						$iallowance_amount = $sl_allowances->allowance_amount;
					}
					$allowance_amount += $iallowance_amount;
				} else {
					//$eallowance_amount = $sl_allowances->allowance_amount;
					if ($sl_allowances->is_allowance_taxable == 1) {
						if ($sl_allowances->amount_option == 0) {
							$iallowance_amount = $sl_allowances->allowance_amount;
						} else {
							$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
						}
						$allowance_amount -= $iallowance_amount;
					} else if ($sl_allowances->is_allowance_taxable == 2) {
						if ($sl_allowances->amount_option == 0) {
							$iallowance_amount = $sl_allowances->allowance_amount / 2;
						} else {
							$iallowance_amount = ($basic_salary / 100) / 2 * $sl_allowances->allowance_amount;
						}
						$allowance_amount -= $iallowance_amount;
					} else {
						if ($sl_allowances->amount_option == 0) {
							$iallowance_amount = $sl_allowances->allowance_amount;
						} else {
							$iallowance_amount = $basic_salary / 100 * $sl_allowances->allowance_amount;
						}
						$allowance_amount += $iallowance_amount;
					}
				}
			}
		}
		$commissions = $this->Employees_model->set_employee_commissions_for_leavesalary($user_id);
		if (!empty($commissions->result())) {
			foreach ($commissions->result() as $sl_commissions) {
				$pg_commissions_amount = $sl_commissions->commission_amount;
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$ecommissions_amount = $sl_commissions->commission_amount / 2;
					} else {
						$ecommissions_amount = $sl_commissions->commission_amount;
					}
					$commissions_amount += $ecommissions_amount;
				} else {
					if ($sl_commissions->is_commission_taxable == 1) {
						if ($sl_commissions->amount_option == 0) {
							$ecommissions_amount = $sl_commissions->commission_amount;
						} else {
							$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
						}
						$commissions_amount -= $ecommissions_amount;
					} else if ($sl_commissions->is_commission_taxable == 2) {
						if ($sl_commissions->amount_option == 0) {
							$ecommissions_amount = $sl_commissions->commission_amount / 2;
						} else {
							$ecommissions_amount = ($basic_salary / 100) / 2 * $sl_commissions->commission_amount;
						}
						$commissions_amount -= $ecommissions_amount;
					} else {
						if ($sl_commissions->amount_option == 0) {
							$ecommissions_amount = $sl_commissions->commission_amount;
						} else {
							$ecommissions_amount = $basic_salary / 100 * $sl_commissions->commission_amount;
						}
						$commissions_amount += $ecommissions_amount;
					}
				}
			}
		}
		$statutory_deductions = $this->Employees_model->set_employee_statutory_deductions_for_leavesalary($user_id);
		if (!empty($statutory_deductions->result())) {
			foreach ($statutory_deductions->result() as $sl_statutory_deductions) {
				$sta_salary = $basic_salary;
				$st_amount = $sta_salary / 100 * $sl_statutory_deductions->deduction_amount;
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$single_sd = $st_amount / 2;
					} else {
						$single_sd = $st_amount;
					}
					$statutory_deductions_amount += $single_sd;
				} else {
					if ($sl_statutory_deductions->statutory_options == 0) {
						$single_sd = $sl_statutory_deductions->deduction_amount;
					} else {
						$single_sd = $basic_salary / 100 * $sl_statutory_deductions->deduction_amount;
					}
					$statutory_deductions_amount += $single_sd;
				}
			}
		}
		$other_payments = $this->Employees_model->set_employee_other_payments_leave_salary($user_id);
		if (!empty($other_payments->result())) {
			foreach ($other_payments->result() as $sl_other_payments) {
				if ($system[0]->is_half_monthly == 1) {
					if ($system[0]->half_deduct_month == 2) {
						$epayments_amount = $sl_other_payments->payments_amount / 2;
					} else {
						$epayments_amount = $sl_other_payments->payments_amount;
					}
					$other_payments_amount += $epayments_amount;
				} else {
					//$epayments_amount = $sl_other_payments->payments_amount;
					if ($sl_other_payments->is_otherpayment_taxable == 1) {
						if ($sl_other_payments->amount_option == 0) {
							$epayments_amount = $sl_other_payments->payments_amount;
						} else {
							$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
						}
						$other_payments_amount -= $epayments_amount;
					} else if ($sl_other_payments->is_otherpayment_taxable == 2) {
						if ($sl_other_payments->amount_option == 0) {
							$epayments_amount = $sl_other_payments->payments_amount / 2;
						} else {
							$epayments_amount = ($basic_salary / 100) / 2 * $sl_other_payments->payments_amount;
						}
						$other_payments_amount -= $epayments_amount;
					} else {
						if ($sl_other_payments->amount_option == 0) {
							$epayments_amount = $sl_other_payments->payments_amount;
						} else {
							$epayments_amount = $basic_salary / 100 * $sl_other_payments->payments_amount;
						}
						$other_payments_amount += $epayments_amount;
					}
				}
			}
		}
		if ($timesheet[0]->paid_status == 'N') {
			$anual_days_leave = $timesheet[0]->days;
			$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id, $joining_date[0]->date_of_joining);
			if ($check_already_exists_paid) {
				$applied_date = $check_already_exists_paid[0]->applied_on;
				$date_arr = explode("-", $applied_date);
				$yr_d_paid = $date_arr[0];

				$date = date_create($check_already_exists_paid[0]->applied_on);
				$not_paid_year = date_format($date, "Y");
				$difference_years = $not_paid_year - $yr_d_paid;

				//joining date difference
				$date_joins = $joining_date[0]->date_of_joining;
				$date = date_create($date_joins);
				$date_join = date_format($date, "Y");
				$todays_date = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
				$join_differ = $todays_date - $date_join;
				if ($join_differ > 0) {
					$days_add_start = $join_differ * 365;
				} else {
					$days_add_start = 1 * 365;
				}

				//end joining date difference
				if ($difference_years > 0) {
					$days_add = $difference_years * 365;
				} else {
					$days_add = 1 * 365;
				}

				$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
				$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
			} else {
				$date_joins = $joining_date[0]->date_of_joining;
				$date = date_create($date_joins);
				$date_join = date_format($date, "Y/m/d");
				$todays_date = date('Y-m-d');
				$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
				$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				$days_add = $years * 365;
				if ($days_add == 0) {
					$start_date_co = $joining_date[0]->date_of_joining;
					$date = date($joining_date[0]->date_of_joining);
					$date1 = date_create($date);
					$date2 = date_create(date('Y-m-d'));
					$diff = date_diff($date1, $date2);
					$day_diff = $diff->format("%a") + 1;
					if ($day_diff > 365) {
						$monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
						if (isset($timesheet[0]->days)) {
							$annul_days = $timesheet[0]->days;
						} else {
							$annul_days = 0;
						}
						$flag = 1;
					} else {
						$annul_days = 0;
						$flag = 0;
						$monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
					}

					$end_date_co = date('Y-m-d', strtotime($monthstart));
				} else {
					$start_date_co = $joining_date[0]->date_of_joining;
					$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
				}
			}

			$arry_years = array();
			$st = '';
			$p_count_val = $tot_days = 0;
			$off_day_arr = array();
			$holiday_arr = array();
			$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
			if (!is_null($office_shift)) {
				$h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
				if ($h_date_chck->num_rows() > 0) {
					$h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date_co, $end_date_co, $user_info[0]->company_id);
					foreach ($h_date as $val) {
						$begin = new DateTime($val->start_date);
						$end = new DateTime($val->end_date);
						$end = $end->modify('+1 day');

						$interval = new DateInterval('P1D');
						$daterange = new DatePeriod($begin, $interval, $end);

						foreach ($daterange as $date) {
							$holiday_arr[] = $date->format("Y-m-d");
						}
					}
					$p_count_val += count($holiday_arr);
				}
			}
			$leave_arr = array();
			$half_leave_arr = array();
			$leave_date_chck = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
			if ($leave_date_chck->num_rows() > 0) {
				$leave_date = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
				foreach ($leave_date->result() as $leave_dates) {
					$begin1 = new DateTime($leave_dates->from_date);
					$end1 = new DateTime($leave_dates->to_date);
					$end1 = $end1->modify('+1 day');
					$half_day_check = $leave_dates->is_half_day;
					$interval1 = new DateInterval('P1D');
					$daterange1 = new DatePeriod($begin1, $interval1, $end1);

					foreach ($daterange1 as $date1) {
						if ($half_day_check == 1) {
							$half_leave_arr[] = $date1->format("Y-m-d");
						} else {
							$leave_arr[] = $date1->format("Y-m-d");
						}
					}
				}
			}
			$present_arr = array();
			//$st = $this->db->last_query();
			$total_leaves = count($leave_arr) + count($half_leave_arr);
			$p_count_val += abs($total_leaves - $tot_days);
			$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
			$absent_count = 0;
			$leave_count = 0;
			$month_year = date('Y-m', strtotime($start_date_co));

			$user = $this->Xin_model->read_user_info($user_id);

			$month_year_att = $start_date_co;
			$month_year_att_end = $end_date_co;
			$month_year_att_end = date('Y-m-d', strtotime($month_year_att_end . ' +1 day'));
			$office_shift = $this->Timesheet_model->read_office_shift_information($user_info[0]->office_shift_id);
			if (!is_null($office_shift)) {
				$day_start = date('d', strtotime($start_date_co));
				$period = new DatePeriod(
					new DateTime($month_year_att),
					new DateInterval('P1D'),
					new DateTime($month_year_att_end)
				);
				$i = 1;

				foreach ($period as $key => $value) {
					$attendance_date = $value->format('Y-m-d');
					$attendance_date_month = date('m', strtotime($attendance_date));
					$attendance_date_Year = date('Y', strtotime($attendance_date));
					$check_attendence_exists = $this->Employees_model->attendence_exists_check($user_id, $attendance_date_month, $attendance_date_Year);
					if ($check_attendence_exists) {
						$last_attendence_date = $this->Employees_model->last_attendence_in_a_month($user_id, $attendance_date_month, $attendance_date_Year);
						if ($flag = 0) {
							if (strtotime($last_attendence_date[0]->attendance_date) >= strtotime($attendance_date)) {

								$i++;
								$get_day = strtotime($attendance_date);
								$day = date('l', $get_day);
								$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
								if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
									$holiday_count += 1;
								} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
									$holiday_count += 1;
								} else if ($check->num_rows() > 0) {
									$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
									$present_count += 1;
								} else if (in_array($attendance_date, $holiday_arr)) { // holiday
									$public_holiday_count += 1;
								} else if (in_array($attendance_date, $leave_arr)) { // on leave
									$leave_count += 1;
								} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
									$status = 'HDL';
									$leave__half_day_count += 0.5;
								} else {
									$absent_count += 1;
									//$pcount += 0;
								}
							}
						} else {

							$i++;
							$get_day = strtotime($attendance_date);
							$day = date('l', $get_day);
							$check = $this->Timesheet_model->attendance_first_in_check($user_id, $attendance_date);
							if ($office_shift[0]->monday_in_time == '' && $day == 'Monday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->tuesday_in_time == '' && $day == 'Tuesday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->wednesday_in_time == '' && $day == 'Wednesday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->thursday_in_time == '' && $day == 'Thursday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->friday_in_time == '' && $day == 'Friday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->saturday_in_time == '' && $day == 'Saturday') {
								$holiday_count += 1;
							} else if ($office_shift[0]->sunday_in_time == '' && $day == 'Sunday') {
								$holiday_count += 1;
							} else if ($check->num_rows() > 0) {
								$attendance = $this->Timesheet_model->attendance_first_in($user_id, $attendance_date);
								$present_count += 1;
							} else if (in_array($attendance_date, $holiday_arr)) { // holiday
								$public_holiday_count += 1;
							} else if (in_array($attendance_date, $leave_arr)) { // on leave
								$leave_count += 1;
							} else if (in_array($attendance_date, $half_leave_arr)) { // on leave
								$status = 'HDL';
								$leave__half_day_count += 0.5;
							} else {
								$absent_count += 1;
								//$pcount += 0;
							}
						}
					}
				}
			}
			//Number of days calc
			$total_k = 1;
			$k = 1;
			$extra_amount = 0;
			$tot_days = 0;
			$emp_leave_in_year_count = $extra_in_month = $total_final = $final_amount = 0;
			$month_year_end = date("Y-m-d", strtotime("$month_year-01"));
			//$month_last_date = date("Y-m-d", strtotime("$month_year-$daysInMonth"));
			$totol_deduction = $count_l = $hlfcount = $tot_days_lop = 0;

			$from_Date = $timesheet[0]->from_date;
			$to_Date = $timesheet[0]->to_date;
			$com_start = '01-' . date('m-Y', strtotime($from_Date));
			$no_of_days_from = date('t', strtotime($from_Date));
			$com_end = $no_of_days_from . date('m-Y', strtotime($from_Date));
			if (date('m-Y', strtotime($from_Date)) == date('m-Y', strtotime($to_Date))) {
				$diff_com = strtotime($from_Date) - strtotime($to_Date);
				$diff_com_val = abs(round($diff_com / 86400));
				if ($diff_com_val == $no_of_days_from) {
					$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
					if (!empty($loan->result())) {
						foreach ($loan->result() as $r_loan) {
							$loan_de_amount += $r_loan->loan_deduction_amount;
						}
					}
				}
			} else {
				$diff_com = strtotime($from_Date) - strtotime($com_start);
				$diff_com_val = abs(round($diff_com / 86400));
				$end_date_start = '01-' . date('m-Y', strtotime($to_Date));
				$diff_com1 = strtotime($to_Date) - strtotime($end_date_start);
				$diff_com_val1 = abs(round($diff_com1 / 86400));
				if ($diff_com_val == 0 && $diff_com_val1 == 0) {
					$loan = $this->Employees_model->set_employee_deductions_leave_Salary($user_id);
					if (!empty($loan->result())) {
						foreach ($loan->result() as $r_loan) {
							$loan_de_amount += $r_loan->loan_deduction_amount;
						}
					}
				}
			}

			$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
			$total_deduction = $statutory_deductions_amount + $loan_de_amount;
			$net_annual_amt = $total_earning - $total_deduction;

			$emp_leaves = $this->Timesheet_model->leave_date_check_new($user_id, $start_date_co, $end_date_co);
			if ($emp_leaves->num_rows() > 0) {
				foreach ($emp_leaves->result() as $emp_leave) {
					//$emp_leave_in_month = $this->Employees_model->emp_leave_in_month_year($user_id,$start_date_y_m,$emp_leave->leave_type_id);

					$amt_deduct = 0;
					if ($emp_leave->leave_type_id == 7) {
						$tot_days_lop += $emp_leave->total_leaves;
						$amt_deduct = ($net_salary / 30) * $emp_leave->total_leaves;
					} else if ($emp_leave->leave_type_id == 4) {
						$carry_count = $this->Timesheet_model->get_employee_extra_remaining_leaves($user_id, 4);
						if (isset($carry_count[0]->create_date)) {
							$yr_check_sick = date('Y', strtotime($carry_count[0]->create_date));
						} else {
							$yr_check_sick = date('Y');
						}
						$total_half_paid_counts = $total_unpaid_counts = $total_paid_counts = $half_present_days = 0;
						$total_paid_count_exits = $this->Timesheet_model->select_leave_paid_list_new($user_id, $yr_check_sick, $emp_leave->leave_id);
						if (isset($total_paid_count_exits[0])) {
							if ($emp_leave->is_half_day == 1) {
								$leave__half_day_count += 0.5;
							}
							foreach ($total_paid_count_exits as $sickleave_calc) {
								$total_half_paid_counts += $sickleave_calc->total_half_paid_count;
								$total_unpaid_counts += $sickleave_calc->total_unpaid_count;
								$total_paid_counts += $sickleave_calc->total_paid_count;
							}
							if ($total_half_paid_counts > 0) {
								$tot_days_lop += $total_half_paid_counts / 2;
								$half_present_days = $total_half_paid_counts / 2;
							}
							if ($total_unpaid_counts > 0) {
								$tot_days_lop += $total_unpaid_counts;
							}
							if ($total_paid_counts > 0 || $half_present_days > 0) {

								// $present_count += $total_paid_counts + $half_present_days;
							}
						}
					}
				}
			}

			$totl_num_days_pres = ($absent_count + $present_count + $holiday_count + $public_holiday_count + $leave_count + $leave__half_day_count + $annul_days) - ($tot_days_lop + $absent_count);
			//	print_R($totl_num_days_pres);exit;
			// print_r($annul_days);exit;
			$date_joins = $start_date_co;
			$date = date_create($date_joins);
			$date_join = date_format($date, "Y/m/d");
			$todays_date = $end_date_co;
			$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
			$years_count = floor($date_diff_calc / (365 * 60 * 60 * 24));
			if ($years_count > 0) {
				$years_count = $years_count;
			} else {
				$years_count = 1;
			}
			// $totl_num_days_pres = (365 * $years_count )  - ($tot_days_lop + $absent_count);
			//	$totl_num_days_pres = (365 * $years_count)  - ($tot_days_lop);

			$no_days_ann = (30 / 365) * $totl_num_days_pres;
			$annual_amt_pay = ($net_annual_amt / 30) * $no_days_ann;
			$annual_amt_pay = number_format($annual_amt_pay, 3);
			$dataaa = array(
				'annua_amt' => $annual_amt_pay,
				'allowance' => $allowance_amount,
				'commissions_amount' => $commissions_amount,
				'other_payments_amount' => $other_payments_amount,
				'statutory_deductions_amount' => $statutory_deductions_amount,
				'loan_de_amount' => $loan_de_amount,
				'updated_date' => date('Y-m-d')
			);
			$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
			if ($result) {
				$Return['result'] = 'Success';
			} else {
				$Return['error'] = 'Something went to wrong';
			}

			//print_r($annual_amt_pay);exit;
		} else {
			$Return['error'] = 'Amount already paid';
		}
		$this->output($Return);
		exit;
		/* End Annual Settlement amount calc  */
	}

	function refreshAnnualLeaveCalc()
	{
		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$id = $this->input->get('leave_id');
		/* Annual Settlement amount calc  */
		$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
		$user_id = $timesheet[0]->employee_id;
		$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
		//Check annual leave exists for the corresponding employee

		// end annual leave exists check
		$net_annual_amt = 0;
		$annul_days = 0;
		$annual_amt_pay = $anual_days_leave = 0;
		$basic_salary = $user_info[0]->basic_salary;

		if ($timesheet[0]->paid_status == 'N') {

			$ann_calc_common = $this->AnnualCalcCommon($id);
			if ($ann_calc_common) {
				$annual_amt_pay = $ann_calc_common[0];
				$allowance_amount = $ann_calc_common[1];
				$commissions_amount = $ann_calc_common[2];
				$other_payments_amount = $ann_calc_common[3];
				$statutory_deductions_amount = $ann_calc_common[4];
				$loan_de_amount = $ann_calc_common[5];
			} else {
				$annual_amt_pay = $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
			}
			$dataaa = array(
				'annua_amt' => $annual_amt_pay,
				'allowance' => $allowance_amount,
				'commissions_amount' => $commissions_amount,
				'other_payments_amount' => $other_payments_amount,
				'statutory_deductions_amount' => $statutory_deductions_amount,
				'loan_de_amount' => $loan_de_amount,
				'updated_date' => date('Y-m-d')
			);
			$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
			if ($result) {
				$Return['result'] = 'Success';
			} else {
				$Return['error'] = 'Something went to wrong';
			}
		} else {
			$Return['error'] = 'Amount already paid';
		}
		$this->output($Return);
		exit;
		/* End Annual Settlement amount calc  */
	}

	public function update_annual_leave_status_validate()
	{
		if ($this->input->post('update_type') == 'leave') {
			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			if ($this->input->post('remarks') === '') {

				$Return['error'] = "Remarks is required";
			}
			$this->output($Return);
			exit;
		}
	}

	public function update_annual_leave_status()
	{
		if ($this->input->post('update_type') == 'leave') {
			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$clr_d_msg = '';
			$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $second_approval = $final_approval = 0;
			$approved_by_first = $approved_by_second = $approved_by_final = '';
			if ($this->input->post('status') == null) {
				$first_approval = $timesheet[0]->first_approval;
				$second_approval = $timesheet[0]->second_approval;
				$final_approval = $timesheet[0]->final_approval;
				$status_updated = $timesheet[0]->status;
				$approved_by_first = $timesheet[0]->approved_by_first;
				$approved_by_second = $timesheet[0]->approved_by_second;
				$approved_by_final = $timesheet[0]->approved_by_final;
			} else {
				if ($user_info[0]->user_role_id == 1) {
					$status_updated = $this->input->post('status');

					if ($status_updated == 2) {
						$first_approval = $second_approval = $final_approval = 1;
						$old_first_val = $timesheet[0]->first_approval;
						if ($old_first_val) {
							$approved_by_first = $timesheet[0]->approved_by_first;
						} else {
							$approved_by_first = $session['user_id'];
						}
						$old_second_val = $timesheet[0]->second_approval;
						if ($old_second_val) {
							$approved_by_second = $timesheet[0]->approved_by_second;
						} else {
							$approved_by_second = $session['user_id'];
						}
						$old_final_val = $timesheet[0]->final_approval;
						if ($old_final_val) {
							$approved_by_final = $timesheet[0]->approved_by_final;
						} else {
							$approved_by_final = $session['user_id'];
						}
					} else if ($status_updated == 3) {
						$final_approval = 2;
						$approved_by_final = $session['user_id'];
					}

					if ($status_updated == 3 || $status_updated == 1) {
						$clr_d_msg = 0;
					}
				} elseif (in_array('256', $role_resources_ids) || in_array('258', $role_resources_ids) || in_array('257', $role_resources_ids)) {
					if (in_array('256', $role_resources_ids)) {
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2) {
							$first_approval = 1;
							$old_first_val = $timesheet[0]->first_approval;
							if ($old_first_val) {
								$approved_by_first = $timesheet[0]->approved_by_first;
							} else {
								$approved_by_first = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$first_approval = 2;
							$approved_by_first = $session['user_id'];
						}
					}
					if (in_array('257', $role_resources_ids)) { //second approval
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2 && $timesheet[0]->first_approval) {
							$first_approval = $second_approval = 1;
							$old_second_val = $timesheet[0]->second_approval;
							if ($old_second_val) {
								$approved_by_second = $timesheet[0]->approved_by_second;
							} else {
								$approved_by_second = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$second_approval = 2;
							$approved_by_second = $session['user_id'];
						}
					}
					if (in_array('258', $role_resources_ids)) {
						$status_updated = 1; //$this->input->post('status_old');

						if ($this->input->post('status') == 2) {
							$first_approval = $second_approval = $final_approval = 1;
							$status_updated = 2;
							$old_first_val = $timesheet[0]->first_approval;
							if ($old_first_val) {
								$approved_by_first = $timesheet[0]->approved_by_first;
							} else {
								$approved_by_first = $session['user_id'];
							}
							$old_second_val = $timesheet[0]->second_approval;
							if ($old_second_val) {
								$approved_by_second = $timesheet[0]->approved_by_second;
							} else {
								$approved_by_second = $session['user_id'];
							}
							$old_final_val = $timesheet[0]->final_approval;
							if ($old_final_val) {
								$approved_by_final = $timesheet[0]->approved_by_final;
							} else {
								$approved_by_final = $session['user_id'];
							}
						} elseif ($this->input->post('status') == 3) {
							$final_approval = 2;
							$approved_by_final = $session['user_id'];
						}
					}
				} else {
					$status_updated = $this->input->post('leave_status_old');
				}
			}


			// 			$first_approval = $final_approval = 0;
			// 			if ($user_info[0]->user_role_id == 1) {
			// 				$status_updated = $this->input->post('status');

			// 				if ($status_updated == 2) {
			// 					$first_approval = $final_approval = 1;
			// 				}
			// 				if ($status_updated == 3 || $status_updated == 1) {
			// 					$clr_d_msg = 0;
			// 				}
			// 			} else if (in_array('509', $role_resources_ids)) {
			// 				$status_updated = 1; //$this->input->post('status_old');

			// 				if ($this->input->post('status') == 2) {
			// 					$first_approval = 1;
			// 				}
			// 			} else if (in_array('258', $role_resources_ids)) {
			// 				$status_updated = 1; //$this->input->post('status_old');

			// 				if ($this->input->post('status') == 2) {
			// 					$first_approval = $final_approval = 1;
			// 					$status_updated = 2;
			// 				}
			// 			} else {
			// 				$status_updated = $this->input->post('leave_status_old');
			// 			}


			$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
			if (!empty($check_annual_leave_aval)) {
				$yr_duration_strat = $check_annual_leave_aval[0]->annual_leave_duration_start;
				$yr_duration_end = $check_annual_leave_aval[0]->annual_leave_duration_end;
			} else {
				$yr_duration_strat = '';
				$yr_duration_end = '';
			}

			$clr_check = $timesheet[0]->cleared_status;
			if (($user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids))) {
				if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {
					$no_of_days = $timesheet[0]->days;
					$aval_leaves = 0;
					$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
					if (!empty($check_annual_leave_aval)) {
						$aval_leaves = $check_annual_leave_aval[0]->leave_count;
					}
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
					$input = $user[0]->leave_updated_date;
					$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_starndrd($timesheet[0]->employee_id, 3, $input, $newEndingDate);
					$carry_leave_exced = $result_carry->result();
					if ($result_carry->num_rows() > 0) {
						if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
							if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
								$no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
								$no_of_days = $carry_leave_exced[0]->remaing_leave_count;
								$aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
								$inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						} else {
							if ($no_of_days > $aval_leaves) {
								$no_of_days_annual_remain = $no_of_days - $aval_leaves;
								$no_of_days = $aval_leaves;
								$inc_days = $aval_leaves - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						}
					} else {

						if ($no_of_days > $aval_leaves) {
							$no_of_days_annual_remain = $no_of_days - $aval_leaves;
							$no_of_days = $aval_leaves;
							$inc_days = $aval_leaves - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					}
					if ((!empty($this->input->post('probation_check')) && $probation_check == 'lop')) {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$check_flag = 3;
						$no_of_days_annual_remain = 0;
						$data = array(
							'employee_id' => $timesheet_exceeds[0]->employee_id,
							'company_id' => $timesheet_exceeds[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $timesheet_exceeds[0]->from_date,
							'to_date' => $timesheet_exceeds[0]->to_date,
							'applied_on' => $timesheet_exceeds[0]->applied_on,
							'reason' => $timesheet_exceeds[0]->remarks,
							'remarks' => $timesheet_exceeds[0]->remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $timesheet_exceeds[0]->days,
							'cleared_status' => 1,
							'probation_check' => $probation_check
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						$unpaid_leave_id = $result;
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						//$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$input = $user[0]->leave_updated_date;
						$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							if ($emp_leaves_data) {
								$total = $emp_leaves_data[0]->leave_count;
							} else {
								$total = 0;
							}
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							//$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d'),
									'annual_leave_duration_start' => $yr_duration_strat,
									'annual_leave_duration_end' => $yr_duration_end
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
					} else {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$date_arr = explode("-", $timesheet_exceeds[0]->from_date);
						$year_check = $date_arr[0];
						$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$input = $user[0]->leave_updated_date;
						$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet_exceeds[0]->employee_id, 3, $input, $newEndingDate);
						$carry_leave_exced = $result_carry->result();
						if ($result_carry->num_rows() > 0) {

							if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
								$check_flag = 1;
								$no_of_days_annual_remain = 0;
								$data = array(
									'employee_id' => $timesheet_exceeds[0]->employee_id,
									'company_id' => $timesheet_exceeds[0]->company_id,
									'leave_type_id' => 7,
									'from_date' => $timesheet_exceeds[0]->from_date,
									'to_date' => $timesheet_exceeds[0]->to_date,
									'applied_on' => $timesheet_exceeds[0]->applied_on,
									'reason' => $timesheet_exceeds[0]->remarks,
									'remarks' => $timesheet_exceeds[0]->remarks,
									'status' => '2',
									'is_notify' => '1',
									'created_at' => date('Y-m-d h:i:s'),
									'days' => $timesheet_exceeds[0]->days,
									'cleared_status' => 1,
									'probation_check' => $probation_check
								);
								$result = $this->Timesheet_model->add_leave_record_new($data);
								$unpaid_leave_id = $result;
								$timesheet = $this->Timesheet_model->read_leave_information($result);
								if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {

									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->leave_type_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									$count = $xin_leave_type[0]->leave_count;
									$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
									$emp_leaves_data = $this->Timesheet_model->annual_leave_availablefor_emp_limt($employees_id, $leaves_id);
									if ($emp_leaves_data) {
										$total = $emp_leaves_data[0]->leave_count;
									} else {
										$total = 0;
									}
									//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
									$input = $user[0]->leave_updated_date;
									$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
									$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
									$carry_leave = $result_carry->result();
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total - $taked_leaves;
									} else {
										$leave_remaining_total = $total + $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$date_arr = explode("-", $timesheet[0]->from_date);
									$year_check = $date_arr[0];
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
									$input = $user[0]->leave_updated_date;
									$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet_exceeds[0]->employee_id, 3, $input, $newEndingDate);
									if ($result->num_rows() == 0) {
										$data_insert = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											'create_date' => date('Y-m-d'),
											'annual_leave_duration_start' => $yr_duration_strat,
											'annual_leave_duration_end' => $yr_duration_end
										);
										$data_result = $this->Timesheet_model->carry_insert($data_insert);
									} else {
										$carry_leave = $result_carry->result(); //print_r($carry_leave);exit;
										$data_update = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											//'create_date'=> date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
									}
								} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
									$carry_leave = $result_carry->result();
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->employee_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
								$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
							} else {
								$data = array(
									'status' => $this->input->post('status'),
									'remarks' => $qt_remarks,
									'allotted_leave' => $aval_leaves,
									'to_date' => $next_form_date_ann,
									'days' => $no_of_days,
									'cleared_status' => 1,
									'annua_amt' => $this->input->post('annual_leave_amt'),
									'first_approval' => $first_approval,
									'second_approval' => $second_approval,
									'final_approval' => $final_approval,
									'approved_by_first' => $approved_by_first,
									'approved_by_second' => $approved_by_second,
									'approved_by_final' => $approved_by_final,
									'updated_date' => date('Y-m-d')
								);
								$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
							}
						} else {
							$data = array(
								'status' => $this->input->post('status'),
								'remarks' => $qt_remarks,
								'allotted_leave' => $aval_leaves,
								'to_date' => $next_form_date_ann,
								'days' => $no_of_days,
								'cleared_status' => 1,
								'annua_amt' => $this->input->post('annual_leave_amt'),
								'first_approval' => $first_approval,
								'second_approval' => $second_approval,
								'final_approval' => $final_approval,
								'approved_by_first' => $approved_by_first,
								'approved_by_second' => $approved_by_second,
								'approved_by_final' => $approved_by_final,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
						}
					}
				} else {

					if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
						$check_flag = 2;
					}
					$data = array(
						'status' => $this->input->post('status'),
						'annua_amt' => $this->input->post('annual_leave_amt'),
						'first_approval' => $first_approval,
						'second_approval' => $second_approval,
						'final_approval' => $final_approval,
						'approved_by_first' => $approved_by_first,
						'approved_by_second' => $approved_by_second,
						'approved_by_final' => $approved_by_final,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				}
				if ($result == TRUE) {
					if ($no_of_days_annual_remain > 0) {
						$next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
						$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
						if (!empty($checl_already_exists_annual)) {
							$data = array(
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
							$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {


								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								//	$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
								$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$input = $user[0]->leave_updated_date;
								$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d'),
										'annual_leave_duration_start' => $yr_duration_strat,
										'annual_leave_duration_end' => $yr_duration_end
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else {
							$data = array(
								'employee_id' => $timesheet[0]->employee_id,
								'company_id' => $timesheet[0]->company_id,
								'leave_type_id' => 7,
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'applied_on' => date('Y-m-d h:i:s'),
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'created_at' => date('Y-m-d h:i:s'),
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check
							);
							$result = $this->Timesheet_model->add_leave_record_new($data);
							$unpaid_leave_id = $result;
							$timesheet = $this->Timesheet_model->read_leave_information($result);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								//print_r($leave_remaining_total);exit;

								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								//$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $leaves_id, $year_check);
								$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$input = $user[0]->leave_updated_date;
								$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d'),
										'annual_leave_duration_start' => $yr_duration_strat,
										'annual_leave_duration_end' => $yr_duration_end
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						}
					}
					if ($check_flag == 0) {
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						//carryforward
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
						$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$input = $user[0]->leave_updated_date;
						$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2') && (isset($clr_check) != 1)) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = 3;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							//$leave_half_day_opt = $timesheet[0]->is_half_day;

							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}

							$leave_remaining_total = $leave_remaining_total;

							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d'),
									'annual_leave_duration_start' => $yr_duration_strat,
									'annual_leave_duration_end' => $yr_duration_end
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result();
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							//$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

							$total = $carry_leave[0]->remaing_leave_count;
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					} else if ($check_flag == 1) {
						$Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					}
					if ($this->input->post('annual_leave_amt') == 0) {
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						if (isset($timesheet[0]->paid_status) == 'N') {
							$ann_calc_common = $this->AnnualCalcCommon($id);
							if ($ann_calc_common) {
								$annual_amt_pay = $ann_calc_common[0];
								$allowance_amount = $ann_calc_common[1];
								$commissions_amount = $ann_calc_common[2];
								$other_payments_amount = $ann_calc_common[3];
								$statutory_deductions_amount = $ann_calc_common[4];
								$loan_de_amount = $ann_calc_common[5];
								$annual_yr = $ann_calc_common[6];
								$annual_months = $ann_calc_common[7];
								$annual_days = $ann_calc_common[8];
							} else {
								$annual_amt_pay = $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = $annual_yr = $annual_months = $annual_days = 0;
							}
							$dataaa = array(
								'annua_amt' => $annual_amt_pay,
								'allowance' => $allowance_amount,
								'commissions_amount' => $commissions_amount,
								'other_payments_amount' => $other_payments_amount,
								'statutory_deductions_amount' => $statutory_deductions_amount,
								'loan_de_amount' => $loan_de_amount,
								'annual_year' => $annual_yr,
								'annual_month' => $annual_months,
								'annual_days' => $annual_days,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
							//print_r($annual_amt_pay);exit;
						}
					} else {
						$data = array(
							'annua_amt' => $this->input->post('annual_leave_amt'),
							'first_approval' => $first_approval,
							'second_approval' => $second_approval,
							'final_approval' => $final_approval,
							'approved_by_first' => $approved_by_first,
							'approved_by_second' => $approved_by_second,
							'approved_by_final' => $approved_by_final,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					}
					$data = array(
						'probation_check' => $probation_check,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
					if (($this->input->post('status') == '2') && (isset($timesheet[0]->final_approval) == '1')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					} else if (($this->input->post('status') == '1')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve_pending',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					} else if (($this->input->post('status') == '3')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve_rejected',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					}
					/* End Annual Settlement amount calc  */
					if ($check_flag == 0) {
						//$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$setting = $this->Xin_model->read_setting_info(1);
						if ($setting[0]->enable_email_notification == 'yes') {
							if ($this->input->post('status') == 2) {
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(6);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '
					<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
					<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							} else if ($this->input->post('status') == 3) { // rejected
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(7);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
						<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							}
						}
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$this->output($Return);
						exit;
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$this->output($Return);
						exit;
					}
				}
			} else {
				$data = array(
					'status' => $status_updated,
					'cleared_status' => ($clr_d_msg != '') ? $clr_d_msg : 1,
					'first_approval' => $first_approval,
					'second_approval' => $second_approval,
					'final_approval' => $final_approval,
					'approved_by_first' => $approved_by_first,
					'approved_by_second' => $approved_by_second,
					'approved_by_final' => $approved_by_final,
					'updated_date' => date('Y-m-d')
				);
				$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				$this->output($Return);
				exit;
			}
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
			$this->output($Return);
			exit;
		}
	}

	public function update_annual_leave_status_bk2401()
	{
		if ($this->input->post('update_type') == 'leave') {
			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$clr_d_msg = '';
			$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $final_approval = 0;
			if ($user_info[0]->user_role_id == 1) {
				$status_updated = $this->input->post('status');

				if ($status_updated == 2) {
					$first_approval = $final_approval = 1;
				}
				if ($status_updated == 3 || $status_updated == 1) {
					$clr_d_msg = 0;
				}
			} else if (in_array('256', $role_resources_ids)) {
				$status_updated = 1; //$this->input->post('status_old');

				if ($this->input->post('status') == 2) {
					$first_approval = 1;
				}
			} else if (in_array('258', $role_resources_ids)) {
				$status_updated = 1; //$this->input->post('status_old');

				if ($this->input->post('status') == 2) {
					$first_approval = $final_approval = 1;
					$status_updated = 2;
				}
			} else {
				$status_updated = $this->input->post('leave_status_old');
			}
			$clr_check = $timesheet[0]->cleared_status;
			if (($user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids))) {
				if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {
					$no_of_days = $timesheet[0]->days;
					$aval_leaves = 0;
					$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
					if (!empty($check_annual_leave_aval)) {
						$aval_leaves = $check_annual_leave_aval[0]->leave_count;
					}
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
					$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
					$input = $user[0]->leave_updated_date;
					$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
					$carry_leave_exced = $result_carry->result();
					if ($result_carry->num_rows() > 0) {
						if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
							if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
								$no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
								$no_of_days = $carry_leave_exced[0]->remaing_leave_count;
								$aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
								$inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						} else {
							if ($no_of_days > $aval_leaves) {
								$no_of_days_annual_remain = $no_of_days - $aval_leaves;
								$no_of_days = $aval_leaves;
								$inc_days = $aval_leaves - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						}
					} else {
						if ($no_of_days > $aval_leaves) {
							$no_of_days_annual_remain = $no_of_days - $aval_leaves;
							$no_of_days = $aval_leaves;
							$inc_days = $aval_leaves - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					}
					if ((!empty($this->input->post('probation_check')) && $probation_check == 'lop')) {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$check_flag = 3;
						$no_of_days_annual_remain = 0;
						$data = array(
							'employee_id' => $timesheet_exceeds[0]->employee_id,
							'company_id' => $timesheet_exceeds[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $timesheet_exceeds[0]->from_date,
							'to_date' => $timesheet_exceeds[0]->to_date,
							'applied_on' => $timesheet_exceeds[0]->applied_on,
							'reason' => $timesheet_exceeds[0]->remarks,
							'remarks' => $timesheet_exceeds[0]->remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $timesheet_exceeds[0]->days,
							'cleared_status' => 1,
							'probation_check' => $probation_check
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						$unpaid_leave_id = $result;
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						//$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$input = $user[0]->leave_updated_date;
						$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							if ($emp_leaves_data) {
								$total = $emp_leaves_data[0]->leave_count;
							} else {
								$total = 0;
							}
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							//$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
					} else {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$date_arr = explode("-", $timesheet_exceeds[0]->from_date);
						$year_check = $date_arr[0];
						$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$input = $user[0]->leave_updated_date;
						$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet_exceeds[0]->employee_id, 3, $input, $newEndingDate);
						$carry_leave_exced = $result_carry->result();
						if ($result_carry->num_rows() > 0) {
							// print_r($carry_leave_exced);exit;
							if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
								$check_flag = 1;
								$no_of_days_annual_remain = 0;
								$data = array(
									'employee_id' => $timesheet_exceeds[0]->employee_id,
									'company_id' => $timesheet_exceeds[0]->company_id,
									'leave_type_id' => 7,
									'from_date' => $timesheet_exceeds[0]->from_date,
									'to_date' => $timesheet_exceeds[0]->to_date,
									'applied_on' => $timesheet_exceeds[0]->applied_on,
									'reason' => $timesheet_exceeds[0]->remarks,
									'remarks' => $timesheet_exceeds[0]->remarks,
									'status' => '2',
									'is_notify' => '1',
									'created_at' => date('Y-m-d h:i:s'),
									'days' => $timesheet_exceeds[0]->days,
									'cleared_status' => 1,
									'probation_check' => $probation_check
								);
								$result = $this->Timesheet_model->add_leave_record_new($data);
								$unpaid_leave_id = $result;
								$timesheet = $this->Timesheet_model->read_leave_information($result);
								if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {

									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->leave_type_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									$count = $xin_leave_type[0]->leave_count;
									$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
									$emp_leaves_data = $this->Timesheet_model->annual_leave_availablefor_emp_limt($employees_id, $leaves_id);
									if ($emp_leaves_data) {
										$total = $emp_leaves_data[0]->leave_count;
									} else {
										$total = 0;
									}
									//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
									$input = $user[0]->leave_updated_date;
									$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
									$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
									$carry_leave = $result_carry->result();
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$date_arr = explode("-", $timesheet[0]->from_date);
									$year_check = $date_arr[0];
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
									$input = $user[0]->leave_updated_date;
									$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet_exceeds[0]->employee_id, 3, $input, $newEndingDate);
									if ($result->num_rows() == 0) {
										$data_insert = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											'create_date' => date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_insert($data_insert);
									} else {
										$carry_leave = $result_carry->result(); //print_r($carry_leave);exit;
										$data_update = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											//'create_date'=> date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
									}
								} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
									$carry_leave = $result_carry->result();
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->employee_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
								$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
							} else {
								$data = array(
									'status' => $this->input->post('status'),
									'remarks' => $qt_remarks,
									'allotted_leave' => $aval_leaves,
									'to_date' => $next_form_date_ann,
									'days' => $no_of_days,
									'cleared_status' => 1,
									'annua_amt' => $this->input->post('annual_leave_amt'),
									'first_approval' => $first_approval,
									'final_approval' => $final_approval,
									'updated_date' => date('Y-m-d')
								);
								$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
							}
						} else {
							$data = array(
								'status' => $this->input->post('status'),
								'remarks' => $qt_remarks,
								'allotted_leave' => $aval_leaves,
								'to_date' => $next_form_date_ann,
								'days' => $no_of_days,
								'cleared_status' => 1,
								'annua_amt' => $this->input->post('annual_leave_amt'),
								'first_approval' => $first_approval,
								'final_approval' => $final_approval,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
						}
					}
				} else {
					if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
						$check_flag = 2;
					}
					$data = array(
						'status' => $this->input->post('status'),
						'annua_amt' => $this->input->post('annual_leave_amt'),
						'first_approval' => $first_approval,
						'final_approval' => $final_approval,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				}
				if ($result == TRUE) {
					if ($no_of_days_annual_remain > 0) {
						$next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
						$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
						if (!empty($checl_already_exists_annual)) {
							$data = array(
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
							$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {


								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								//	$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
								$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$input = $user[0]->leave_updated_date;
								$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else {
							$data = array(
								'employee_id' => $timesheet[0]->employee_id,
								'company_id' => $timesheet[0]->company_id,
								'leave_type_id' => 7,
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'applied_on' => date('Y-m-d h:i:s'),
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'created_at' => date('Y-m-d h:i:s'),
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check
							);
							$result = $this->Timesheet_model->add_leave_record_new($data);
							$unpaid_leave_id = $result;
							$timesheet = $this->Timesheet_model->read_leave_information($result);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							//	$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								//$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $leaves_id, $year_check);
								$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$input = $user[0]->leave_updated_date;
								$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						}
					}
					if ($check_flag == 0) {
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						//carryforward
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
						$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
						$input = $user[0]->leave_updated_date;
						$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2') && (isset($clr_check) != 1)) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = 3;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							//$leave_half_day_opt = $timesheet[0]->is_half_day;

							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}

							$leave_remaining_total = $leave_remaining_total;

							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
							$user = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
							$input = $user[0]->leave_updated_date;
							$newEndingDate = date('Y-m-d', strtotime(date('Y-m-d', strtotime($input)) . "+365 day"));
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums_new($timesheet[0]->employee_id, 3, $input, $newEndingDate);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result();
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							//$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

							$total = $carry_leave[0]->remaing_leave_count;
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					} else if ($check_flag == 1) {
						$Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					}
					if ($this->input->post('annual_leave_amt') == 0) {
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						if (isset($timesheet[0]->paid_status) == 'N') {
							$ann_calc_common = $this->AnnualCalcCommon($id);
							if ($ann_calc_common) {
								$annual_amt_pay = $ann_calc_common[0];
								$allowance_amount = $ann_calc_common[1];
								$commissions_amount = $ann_calc_common[2];
								$other_payments_amount = $ann_calc_common[3];
								$statutory_deductions_amount = $ann_calc_common[4];
								$loan_de_amount = $ann_calc_common[5];
							} else {
								$annual_amt_pay = $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
							}
							$dataaa = array(
								'annua_amt' => $annual_amt_pay,
								'allowance' => $allowance_amount,
								'commissions_amount' => $commissions_amount,
								'other_payments_amount' => $other_payments_amount,
								'statutory_deductions_amount' => $statutory_deductions_amount,
								'loan_de_amount' => $loan_de_amount,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
							//print_r($annual_amt_pay);exit;
						}
					} else {
						$data = array(
							'annua_amt' => $this->input->post('annual_leave_amt'),
							'first_approval' => $first_approval,
							'final_approval' => $final_approval,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					}
					$data = array(
						'probation_check' => $probation_check,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
					if (($this->input->post('status') == '2') && (isset($timesheet[0]->final_approval) == '1')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					} else if (($this->input->post('status') == '1')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve_pending',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					} else if (($this->input->post('status') == '3')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve_rejected',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					}
					/* End Annual Settlement amount calc  */
					if ($check_flag == 0) {
						//$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$setting = $this->Xin_model->read_setting_info(1);
						if ($setting[0]->enable_email_notification == 'yes') {
							if ($this->input->post('status') == 2) {
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(6);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '
					<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
					<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							} else if ($this->input->post('status') == 3) { // rejected
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(7);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
						<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							}
						}
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$this->output($Return);
						exit;
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$this->output($Return);
						exit;
					}
				}
			} else {
				$data = array(
					'status' => $status_updated,
					'cleared_status' => ($clr_d_msg != '') ? $clr_d_msg : 1,
					'first_approval' => $first_approval,
					'final_approval' => $final_approval,
					'updated_date' => date('Y-m-d')
				);
				$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				$this->output($Return);
				exit;
			}
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
			$this->output($Return);
			exit;
		}
	}

	public function update_annual_leave_status_bk16122021()
	{
		if ($this->input->post('update_type') == 'leave') {
			$id = $this->uri->segment(4);
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$remarks = $this->input->post('remarks');
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$check_flag = 0;
			$no_of_days_annual_remain = 0;
			if ($this->input->post('probation_check')) {
				$probation_check = $this->input->post('probation_check');
			} else {
				$probation_check = 'null';
			}
			$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
			$session = $this->session->userdata('username');
			$user_info = $this->Xin_model->read_user_info($session['user_id']);
			$role_resources_ids = $this->Xin_model->user_role_resource();
			$first_approval = $final_approval = 0;
			if ($user_info[0]->user_role_id == 1) {
				$status_updated = $this->input->post('status');

				if ($status_updated == 2) {
					$first_approval = $final_approval = 1;
				}
			} else if (in_array('256', $role_resources_ids)) {
				$status_updated = 1; //$this->input->post('status_old');

				if ($this->input->post('status') == 2) {
					$first_approval = 1;
				}
			} else if (in_array('258', $role_resources_ids)) {
				$status_updated = 1; //$this->input->post('status_old');

				if ($this->input->post('status') == 2) {
					$first_approval = $final_approval = 1;
					$status_updated = 2;
				}
			} else {
				$status_updated = $this->input->post('leave_status_old');
			}
			if ($user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)) {
				if ($this->input->post('status') == '2' && $timesheet[0]->cleared_status != 1) {
					$no_of_days = $timesheet[0]->days;
					$aval_leaves = 0;
					$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp($timesheet[0]->employee_id, 3);
					if (!empty($check_annual_leave_aval)) {
						$aval_leaves = $check_annual_leave_aval[0]->leave_count;
					}
					$date_arr = explode("-", $timesheet[0]->from_date);
					$year_check = $date_arr[0];
					$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
					$carry_leave_exced = $result_carry->result();
					if ($result_carry->num_rows() > 0) {
						if ($carry_leave_exced[0]->remaing_leave_count > 0 && $carry_leave_exced[0]->leave_type_id != 7) {
							if ($no_of_days > $carry_leave_exced[0]->remaing_leave_count) {
								$no_of_days_annual_remain = $no_of_days - $carry_leave_exced[0]->remaing_leave_count;
								$no_of_days = $carry_leave_exced[0]->remaing_leave_count;
								$aval_leaves = $carry_leave_exced[0]->remaing_leave_count;
								$inc_days = $carry_leave_exced[0]->remaing_leave_count - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						} else {
							if ($no_of_days > $aval_leaves) {
								$no_of_days_annual_remain = $no_of_days - $aval_leaves;
								$no_of_days = $aval_leaves;
								$inc_days = $aval_leaves - 1;
								$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
							} else {
								$next_form_date_ann = $timesheet[0]->to_date;
							}
						}
					} else {
						if ($no_of_days > $aval_leaves) {
							$no_of_days_annual_remain = $no_of_days - $aval_leaves;
							$no_of_days = $aval_leaves;
							$inc_days = $aval_leaves - 1;
							$next_form_date_ann = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $inc_days . ' days'));
						} else {
							$next_form_date_ann = $timesheet[0]->to_date;
						}
					}
					if ((!empty($this->input->post('probation_check')) && $probation_check == 'lop')) {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$check_flag = 3;
						$no_of_days_annual_remain = 0;
						$data = array(
							'employee_id' => $timesheet_exceeds[0]->employee_id,
							'company_id' => $timesheet_exceeds[0]->company_id,
							'leave_type_id' => 7,
							'from_date' => $timesheet_exceeds[0]->from_date,
							'to_date' => $timesheet_exceeds[0]->to_date,
							'applied_on' => $timesheet_exceeds[0]->applied_on,
							'reason' => $timesheet_exceeds[0]->remarks,
							'remarks' => $timesheet_exceeds[0]->remarks,
							'status' => '2',
							'is_notify' => '1',
							'created_at' => date('Y-m-d h:i:s'),
							'days' => $timesheet_exceeds[0]->days,
							'cleared_status' => 1,
							'probation_check' => $probation_check
						);
						$result = $this->Timesheet_model->add_leave_record_new($data);
						$unpaid_leave_id = $result;
						$timesheet = $this->Timesheet_model->read_leave_information($result);
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$emp_leaves_data = $this->Timesheet_model->read_emp_leave_types_information($employees_id, $leaves_id);
							if ($emp_leaves_data) {
								$total = $emp_leaves_data[0]->leave_count;
							} else {
								$total = 0;
							}
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result(); //print_r($carry_leave);exit;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $timesheet[0]->leave_type_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') == 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => abs($leave_remaining_total),
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
					} else {
						$timesheet_exceeds = $this->Timesheet_model->read_annual_leave_information($id);
						$date_arr = explode("-", $timesheet_exceeds[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet_exceeds[0]->employee_id, 3, $year_check);
						$carry_leave_exced = $result_carry->result();
						if ($result_carry->num_rows() > 0) {
							if ($carry_leave_exced[0]->remaing_leave_count <= 0 && $carry_leave_exced[0]->leave_type_id != 7) {
								$check_flag = 1;
								$no_of_days_annual_remain = 0;
								$data = array(
									'employee_id' => $timesheet_exceeds[0]->employee_id,
									'company_id' => $timesheet_exceeds[0]->company_id,
									'leave_type_id' => 7,
									'from_date' => $timesheet_exceeds[0]->from_date,
									'to_date' => $timesheet_exceeds[0]->to_date,
									'applied_on' => $timesheet_exceeds[0]->applied_on,
									'reason' => $timesheet_exceeds[0]->remarks,
									'remarks' => $timesheet_exceeds[0]->remarks,
									'status' => '2',
									'is_notify' => '1',
									'created_at' => date('Y-m-d h:i:s'),
									'days' => $timesheet_exceeds[0]->days,
									'cleared_status' => 1,
									'probation_check' => $probation_check
								);
								$result = $this->Timesheet_model->add_leave_record_new($data);
								$unpaid_leave_id = $result;
								$timesheet = $this->Timesheet_model->read_leave_information($result);
								if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->leave_type_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									$count = $xin_leave_type[0]->leave_count;
									$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
									$emp_leaves_data = $this->Timesheet_model->annual_leave_availablefor_emp_limt($employees_id, $leaves_id);
									if ($emp_leaves_data) {
										$total = $emp_leaves_data[0]->leave_count;
									} else {
										$total = 0;
									}
									$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									$carry_leave = $result_carry->result();
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$date_arr = explode("-", $timesheet[0]->from_date);
									$year_check = $date_arr[0];
									$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
									if ($result->num_rows() == 0) {
										$data_insert = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											'create_date' => date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_insert($data_insert);
									} else {
										$carry_leave = $result_carry->result(); //print_r($carry_leave);exit;
										$data_update = array(
											'employee_id' => $timesheet[0]->employee_id,
											'leave_type_id' => $timesheet[0]->leave_type_id,
											'remaing_leave_count' => abs($leave_remaining_total),
											//'create_date'=> date('Y-m-d')
										);
										$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
									}
								} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
									$carry_leave = $result_carry->result();
									$hlfcounts = 0;
									$count_ls = 0;
									$leaves_id = $timesheet[0]->employee_id;
									$employees_id = $timesheet[0]->employee_id;
									$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
									if ($carry_leave) {
										$total = $carry_leave[0]->remaing_leave_count;
									} else {
										$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
										$total = $emp_leave_count[0]->leave_count;
									}
									$taked_leaves = $timesheet[0]->days;
									if ($this->input->post('status') == 2) {
										$leave_remaining_total = $total + $taked_leaves;
									} else {
										$leave_remaining_total = $total - $taked_leaves;
									}
									$leave_remaining_total = $leave_remaining_total;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $timesheet[0]->leave_type_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
								$result_dlt_exits = $this->Timesheet_model->delete_annual_leave_record($timesheet_exceeds[0]->id);
							} else {
								$data = array(
									'status' => $this->input->post('status'),
									'remarks' => $qt_remarks,
									'allotted_leave' => $aval_leaves,
									'to_date' => $next_form_date_ann,
									'days' => $no_of_days,
									'cleared_status' => 1,
									'annua_amt' => $this->input->post('annual_leave_amt'),
									'first_approval' => $first_approval,
									'final_approval' => $final_approval,
									'updated_date' => date('Y-m-d')
								);
								$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
							}
						} else {
							$data = array(
								'status' => $this->input->post('status'),
								'remarks' => $qt_remarks,
								'allotted_leave' => $aval_leaves,
								'to_date' => $next_form_date_ann,
								'days' => $no_of_days,
								'cleared_status' => 1,
								'annua_amt' => $this->input->post('annual_leave_amt'),
								'first_approval' => $first_approval,
								'final_approval' => $final_approval,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
						}
					}
				} else {
					if ($this->input->post('status') != '2' && $timesheet[0]->status != 2) {
						$check_flag = 2;
					}
					$data = array(
						'status' => $this->input->post('status'),
						'annua_amt' => $this->input->post('annual_leave_amt'),
						'first_approval' => $first_approval,
						'final_approval' => $final_approval,
						'updated_date' => date('Y-m-d')
					);
					$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				}
				if ($result == TRUE) {
					if ($no_of_days_annual_remain > 0) {
						$next_form_date = date('Y-m-d', strtotime($timesheet[0]->from_date . ' + ' . $aval_leaves . ' days'));
						$checl_already_exists_annual = $this->Timesheet_model->getAnnualUnpaidLeaves($result);
						if (!empty($checl_already_exists_annual)) {
							$data = array(
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_leave_record($data, $checl_already_exists_annual[0]->leave_id);
							$timesheet = $this->Timesheet_model->read_leave_information($checl_already_exists_annual[0]->leave_id);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else {
							$data = array(
								'employee_id' => $timesheet[0]->employee_id,
								'company_id' => $timesheet[0]->company_id,
								'leave_type_id' => 7,
								'from_date' => $next_form_date,
								'to_date' => $timesheet[0]->to_date,
								'applied_on' => date('Y-m-d h:i:s'),
								'reason' => $qt_remarks,
								'remarks' => $qt_remarks,
								'status' => '2',
								'is_notify' => '1',
								'created_at' => date('Y-m-d h:i:s'),
								'days' => $no_of_days_annual_remain,
								'is_annual' => $id,
								'cleared_status' => 1,
								'probation_check' => $probation_check
							);
							$result = $this->Timesheet_model->add_leave_record_new($data);
							$unpaid_leave_id = $result;
							$timesheet = $this->Timesheet_model->read_leave_information($result);
							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $timesheet[0]->leave_type_id, $year_check);
							if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
								$carry_leave = $result_carry->result();
								$hlfcounts = 0;
								$count_ls = 0;
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$date_arr = explode("-", $timesheet[0]->from_date);
								$year_check = $date_arr[0];
								$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, $leaves_id, $year_check);
								if ($result->num_rows() == 0) {
									$data_insert = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										'create_date' => date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_insert($data_insert);
								} else {
									$carry_leave = $result->result(); //print_r($carry_leave);exit;
									$data_update = array(
										'employee_id' => $timesheet[0]->employee_id,
										'leave_type_id' => $leaves_id,
										'remaing_leave_count' => abs($leave_remaining_total),
										//'create_date'=> date('Y-m-d')
									);
									$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
								}
							} else if ($this->input->post('status') != 2 && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
								$carry_leave = $result_carry->result();
								$leaves_id = $timesheet[0]->leave_type_id;
								$employees_id = $timesheet[0]->employee_id;
								$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
								if ($carry_leave) {
									$total = $carry_leave[0]->remaing_leave_count;
								} else {
									$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
									$total = $emp_leave_count[0]->leave_count;
								}
								$taked_leaves = $timesheet[0]->days;
								if ($this->input->post('status') != 2) {
									$leave_remaining_total = $total + $taked_leaves;
								} else {
									$leave_remaining_total = $total - $taked_leaves;
								}
								$leave_remaining_total = $leave_remaining_total;
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => $leaves_id,
									'remaing_leave_count' => abs($leave_remaining_total),
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						}
					}
					if ($check_flag == 0) {
						/* Leave carryforward management */
						$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
						//carryforward
						$date_arr = explode("-", $timesheet[0]->from_date);
						$year_check = $date_arr[0];
						$result_carry = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
						//end
						if (($this->input->post('status') == '2') && (isset($timesheet[0]->status) !== '2')) {
							$hlfcounts = 0;
							$count_ls = 0;
							$leaves_id = 3;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							//$leave_half_day_opt = $timesheet[0]->is_half_day;

							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$carry_leave = $result_carry->result();
							if ($carry_leave) {
								$total = $carry_leave[0]->remaing_leave_count;
							} else {
								$emp_leave_count = $this->Timesheet_model->annual_leave_availablefor_emp($employees_id, $leaves_id);
								$total = $emp_leave_count[0]->leave_count;
							}

							$taked_leaves = $timesheet[0]->days;

							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}

							$leave_remaining_total = $leave_remaining_total;

							$date_arr = explode("-", $timesheet[0]->from_date);
							$year_check = $date_arr[0];
							$result = $this->Timesheet_model->get_employee_extra_remaining_leaves_nums($timesheet[0]->employee_id, 3, $year_check);
							if ($result->num_rows() == 0) {
								$data_insert = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									'create_date' => date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_insert($data_insert);
							} else {
								$carry_leave = $result->result();
								$data_update = array(
									'employee_id' => $timesheet[0]->employee_id,
									'leave_type_id' => 3,
									'remaing_leave_count' => $leave_remaining_total,
									//'create_date'=> date('Y-m-d')
								);
								$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
							}
						} else if ($this->input->post('status') !== '2' && isset($timesheet[0]->status) == 2 && $result_carry->num_rows() > 0) {
							//pending or rejected
							$carry_leave = $result_carry->result();
							$hlfcounts = 0;
							$count_ls = 0;
							//$leave_half_day_opt = $timesheet[0]->is_half_day;
							$leaves_id = $timesheet[0]->leave_type_id;
							$employees_id = $timesheet[0]->employee_id;
							$xin_leave_type = $this->Timesheet_model->xin_count_leave_type($leaves_id, $employees_id);
							$count = $xin_leave_type[0]->leave_count;
							$count_leave_type = $this->Timesheet_model->count_leave_type($leaves_id);
							$leave_halfday_cals = employee_leave_halfday_cal($leaves_id, $employees_id);
							foreach ($leave_halfday_cals as $lhalfday) :
								$hlfcounts += 0.5;
							endforeach;
							$count_ls = count_leaves_info($leaves_id, $employees_id);
							$count_ls = $count_ls - $hlfcounts;
							$leave_remaining_total = $carry_leave[0]->remaing_leave_count + $count_ls;

							$total = $carry_leave[0]->remaing_leave_count;
							$taked_leaves = $timesheet[0]->days;
							if ($this->input->post('status') != 2) {
								$leave_remaining_total = $total + $taked_leaves;
							} else {
								$leave_remaining_total = $total - $taked_leaves;
							}
							$leave_remaining_total = $leave_remaining_total;
							$data_update = array(
								'employee_id' => $timesheet[0]->employee_id,
								'leave_type_id' => $timesheet[0]->leave_type_id,
								'remaing_leave_count' => $leave_remaining_total,
								//'create_date'=> date('Y-m-d')
							);
							$data_result = $this->Timesheet_model->carry_update($data_update, $carry_leave[0]->id);
						}
						/* End Leave carryforward management */
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					} else if ($check_flag == 1) {
						$Return['result'] = 'Leave count exceeded so leave added to unpaid leave section';
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
					}
					if ($this->input->post('annual_leave_amt') == 0) {

						if ($timesheet[0]->paid_status == 'N') {
							$ann_calc_common = $this->AnnualCalcCommon($id);
							if ($ann_calc_common) {
								$annual_amt_pay = $ann_calc_common[0];
								$allowance_amount = $ann_calc_common[1];
								$commissions_amount = $ann_calc_common[2];
								$other_payments_amount = $ann_calc_common[3];
								$statutory_deductions_amount = $ann_calc_common[4];
								$loan_de_amount = $ann_calc_common[5];
							} else {
								$annual_amt_pay = $allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
							}
							$dataaa = array(
								'annua_amt' => $annual_amt_pay,
								'allowance' => $allowance_amount,
								'commissions_amount' => $commissions_amount,
								'other_payments_amount' => $other_payments_amount,
								'statutory_deductions_amount' => $statutory_deductions_amount,
								'loan_de_amount' => $loan_de_amount,
								'updated_date' => date('Y-m-d')
							);
							$result = $this->Timesheet_model->update_annual_leave_record($dataaa, $id);
							//print_r($annual_amt_pay);exit;
						}
					} else {
						$data = array(
							'annua_amt' => $this->input->post('annual_leave_amt'),
							'first_approval' => $first_approval,
							'final_approval' => $final_approval,
							'updated_date' => date('Y-m-d')
						);
						$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
					}
					$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
					if (($this->input->post('status') == '2') && (isset($timesheet[0]->final_approval) == '1')) {
						$nticket_data = array(
							'module_name' => 'annual_leave_approve',
							'module_id' => $id,
							'employee_id' => $timesheet[0]->employee_id,
							'is_notify' => '1',
							'created_at' => date('d-m-Y h:i:s'),
						);
						$this->Xin_model->add_notifications($nticket_data);
					}
					/* End Annual Settlement amount calc  */
					if ($check_flag == 0) {
						//$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$setting = $this->Xin_model->read_setting_info(1);
						if ($setting[0]->enable_email_notification == 'yes') {
							if ($this->input->post('status') == 2) {
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(6);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->middle_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '
					<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
					<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';

								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							} else if ($this->input->post('status') == 3) { // rejected
								$this->email->set_mailtype("html");
								//get leave info
								$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
								//get company info
								$cinfo = $this->Xin_model->read_company_setting_info(1);
								//get email template
								$template = $this->Xin_model->read_email_template(7);
								//get employee info
								$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);

								$full_name = $user_info[0]->first_name . ' ' . $user_info[0]->last_name;

								$from_date = $this->Xin_model->set_date_format($timesheet[0]->from_date);
								$to_date = $this->Xin_model->set_date_format($timesheet[0]->to_date);

								$subject = $template[0]->subject . ' - ' . $cinfo[0]->company_name;
								$logo = base_url() . 'uploads/logo/signin/' . $cinfo[0]->sign_in_logo;

								$message = '<div style="background:#f6f6f6;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:12px;margin:0;padding:0;padding: 20px;">
						<img src="' . $logo . '" title="' . $cinfo[0]->company_name . '"><br>' . str_replace(array("{var site_name}", "{var site_url}", "{var leave_start_date}", "{var leave_end_date}"), array($cinfo[0]->company_name, site_url(), $from_date, $to_date), htmlspecialchars_decode(stripslashes($template[0]->message))) . '</div>';
								hrsale_mail($cinfo[0]->email, $cinfo[0]->company_name, $user_info[0]->email, $subject, $message);
							}
						}
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$this->output($Return);
						exit;
					} else {
						$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
						$this->output($Return);
						exit;
					}
				}
			} else {
				$data = array(
					'status' => $status_updated,
					'first_approval' => $first_approval,
					'final_approval' => $final_approval,
					'updated_date' => date('Y-m-d')
				);
				$result = $this->Timesheet_model->update_annual_leave_record($data, $id);
				$Return['result'] = $this->lang->line('xin_success_leave__status_updated');
				$this->output($Return);
				exit;
			}
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
			$this->output($Return);
			exit;
		}
	}

	public function AnnualCalcCommon($id)
	{
		$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
		$user_id = $timesheet[0]->employee_id;
		$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
		$basic_salary = $user_info[0]->basic_salary;
		$year_annual = $months_annual = $leave_days = 0;
		$annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
		//print_r($this->db->last_query());exit;
		if ($annual_leaves_exits) {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($annual_leaves_exits[0]->from_date));
		} else {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
		}

		$allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
		$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
		$absent_count = 0;
		$leave_count = 0;

		$from_Date = $timesheet[0]->from_date;
		$to_Date = $timesheet[0]->to_date;
		$ann_all_dect = $this->Xin_model->payroll_all_dedctions_and_additions_annual($user_id, $basic_salary, $from_Date, $to_Date);
		$allowance_amount = $ann_all_dect[0];
		$commissions_amount = $ann_all_dect[1];
		$other_payments_amount = $ann_all_dect[2];
		$statutory_deductions_amount = $ann_all_dect[3];
		$loan_de_amount = $ann_all_dect[4];

		$anual_days_leave = $timesheet[0]->days;
		$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid_new($user_id, $from_Date);
		if ($check_already_exists_paid) {
			if ($check_already_exists_paid[0]->from_date) {
				$annual_calc_start_date = $check_already_exists_paid[0]->from_date;
			} else {
				$annual_calc_start_date = $user_info[0]->leave_salary_calculated_date;
			}
			$annual_calc_end_date = date('Y-m-d', strtotime('-1 day', strtotime($from_Date)));
		} else {
			if ($user_info[0]->leave_salary_calculated_date) {
				$annual_calc_start_date = $user_info[0]->leave_salary_calculated_date;
			} else {
				$annual_calc_start_date = $joining_date[0]->date_of_joining;
			}
			$annual_calc_end_date = date('Y-m-d', strtotime('-1 day', strtotime($from_Date)));
		}
		//print_r($annual_calc_start_date);echo '<pre>';print_r($annual_calc_end_date);exit;
		$startDate = new DateTime($annual_calc_start_date);
		$endDate = new DateTime($annual_calc_end_date);
		$difference = $endDate->diff($startDate);
		$difference_days = $difference->format("%a") + 1;
		if ($difference_days > 0) {
			$year_annual = $difference_days / 365;
			$months_annual = $year_annual * 12;
			$leave_const_count = $this->Timesheet_model->read_leave_type_information(3);
			$leave_const_count = $leave_const_count[0]->days_per_year;
			$per_month = $leave_const_count / 12;
			$leave_days = $months_annual * $per_month;
			if ($basic_salary > 0) {
				$total_earning = $basic_salary + $allowance_amount;
				$annual_amt = $total_earning / 30 * $leave_days;
			} else {
				$annual_amt = 0;
			}
		}
		$annual_amt = number_format($annual_amt, 3);
		return array($annual_amt, $allowance_amount, $commissions_amount, $other_payments_amount, $statutory_deductions_amount, $loan_de_amount, $year_annual, $months_annual, $leave_days);
		/*if ($check_already_exists_paid) {
			   	$applied_date = $check_already_exists_paid[0]->applied_on;
				$date_arr = explode("-", $applied_date);
				$yr_d_paid = $date_arr[0];

				$date = date_create($check_already_exists_paid[0]->applied_on);
				$not_paid_year = date_format($date, "Y");
				$difference_years = $not_paid_year - $yr_d_paid;

				//joining date difference
				$date_joins = $joining_date[0]->date_of_joining;
				$date = date_create($date_joins);
				$date_join = date_format($date, "Y");
				$todays_date  = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
				$join_differ = $todays_date - $date_join;
				if ($join_differ > 0) {
					$days_add_start = $join_differ * 365;
				} else {
					$days_add_start = 1 * 365;
				}

				//end joining date difference
				if ($difference_years > 0) {
					$days_add = $difference_years * 365;
				} else {
					$days_add = 1 * 365;
				}

				$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
				$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
			} else {
				$date_joins = $joining_date[0]->date_of_joining;
				$date = date_create($date_joins);
				$date_join = date_format($date, "Y/m/d");
				$todays_date  = date('Y-m-d');
			   //$todays_date = $timesheet[0]->applied_on;
				$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
				$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
				$days_add = $years * 365;
				if($days_add == 0){
				    $start_date_co = $joining_date[0]->date_of_joining;
				    $date = date($joining_date[0]->date_of_joining);
    				$date1 = date_create($date);
    				$date2 = date_create(date('Y-m-d'));
    				$diff = date_diff($date1, $date2);
    				$day_diff = $diff->format("%a") + 1;
    				if($day_diff > 365){
    				    $monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
    				    if(isset($timesheet[0]->days)){
                              $annul_days =$timesheet[0]->days;
                          }else{
                              $annul_days = 0;
                          }
                          $flag = 1;
    				}else{
    				   $annul_days = 0;
    				   $flag = 0;
    				   $monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
    				}

			    	$end_date_co = date('Y-m-d', strtotime($monthstart));
				}else{
				    $start_date_co = $joining_date[0]->date_of_joining;
				    if($user_info[0]->date_of_leaving){
				       $end_date_co =  $user_info[0]->date_of_leaving;
				    }else{
				        $end_date_co = date('Y-m-d', strtotime($timesheet[0]->applied_on));
				    }

			    	//$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
				}

			}
			$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
			$total_deduction = $statutory_deductions_amount + $loan_de_amount;
			$net_annual_amt  = $total_earning - $total_deduction;


			$ann_days_cal = $this->Xin_model->AttendnceCount_calc_common($user_info[0]->office_shift_id,$start_date_co,$end_date_co,$user_info[0]->company_id,$user_id,$difference_days=0,$yearsss='',$monthsss='','inderminity');
			if($ann_days_cal){
    		      $tot_days_lop = $ann_days_cal[0];
    		      $totl_num_days_pres = $ann_days_cal[1];
    		      //$totl_num_days_pres = $totl_num_days_pres-$tot_days_lop;
    		 }else{
    		      $tot_days_lop = 0;
    		      $totl_num_days_pres = 0;
    		 }
    		 $totl_num_days_pres = $totl_num_days_pres - $tot_days_lop;
    		 $no_days_ann = (30 / 365) * $totl_num_days_pres;
			$annual_amt_pay =  ($net_annual_amt / 30) * $no_days_ann;
			$annual_amt_pay = number_format($annual_amt_pay,3);*/
	}

	public function AnnualCalcCommon_bk2401($id)
	{
		$timesheet = $this->Timesheet_model->read_annual_leave_information($id);
		$user_id = $timesheet[0]->employee_id;
		$user_info = $this->Xin_model->read_user_info($timesheet[0]->employee_id);
		$basic_salary = $user_info[0]->basic_salary;

		$annual_leaves_exits = $this->Timesheet_model->annual_leaves_exitsBased_onEmp($id, $timesheet[0]->employee_id);
		if ($annual_leaves_exits) {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($annual_leaves_exits[0]->from_date));
		} else {
			$joining_date = $this->Timesheet_model->joining_date($user_id);
			$start_date_y_m = date('Y-m', strtotime($timesheet[0]->to_date));
		}

		$allowance_amount = $commissions_amount = $other_payments_amount = $statutory_deductions_amount = $loan_de_amount = 0;
		$present_count = $public_holiday_count = $holiday_count = $leave__half_day_count = 0;
		$absent_count = 0;
		$leave_count = 0;

		$from_Date = $timesheet[0]->from_date;
		$to_Date = $timesheet[0]->to_date;
		$ann_all_dect = $this->Xin_model->payroll_all_dedctions_and_additions_annual($user_id, $basic_salary, $from_Date, $to_Date);
		$allowance_amount = $ann_all_dect[0];
		$commissions_amount = $ann_all_dect[1];
		$other_payments_amount = $ann_all_dect[2];
		$statutory_deductions_amount = $ann_all_dect[3];
		$loan_de_amount = $ann_all_dect[4];

		$anual_days_leave = $timesheet[0]->days;
		$check_already_exists_paid = $this->Employees_model->emp_total_annual_leaves_taken_paid($user_id, $joining_date[0]->date_of_joining);
		if ($check_already_exists_paid) {
			$applied_date = $check_already_exists_paid[0]->applied_on;
			$date_arr = explode("-", $applied_date);
			$yr_d_paid = $date_arr[0];

			$date = date_create($check_already_exists_paid[0]->applied_on);
			$not_paid_year = date_format($date, "Y");
			$difference_years = $not_paid_year - $yr_d_paid;

			//joining date difference
			$date_joins = $joining_date[0]->date_of_joining;
			$date = date_create($date_joins);
			$date_join = date_format($date, "Y");
			$todays_date = date('Y', strtotime($check_already_exists_paid[0]->applied_on));
			$join_differ = $todays_date - $date_join;
			if ($join_differ > 0) {
				$days_add_start = $join_differ * 365;
			} else {
				$days_add_start = 1 * 365;
			}

			//end joining date difference
			if ($difference_years > 0) {
				$days_add = $difference_years * 365;
			} else {
				$days_add = 1 * 365;
			}

			$start_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add_start . ' days'));
			$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
		} else {
			$date_joins = $joining_date[0]->date_of_joining;
			$date = date_create($date_joins);
			$date_join = date_format($date, "Y/m/d");
			$todays_date = date('Y-m-d');
			//$todays_date = $timesheet[0]->applied_on;
			$date_diff_calc = abs(strtotime($todays_date) - strtotime($date_join));
			$years = floor($date_diff_calc / (365 * 60 * 60 * 24));
			$days_add = $years * 365;
			if ($days_add == 0) {
				$start_date_co = $joining_date[0]->date_of_joining;
				$date = date($joining_date[0]->date_of_joining);
				$date1 = date_create($date);
				$date2 = date_create(date('Y-m-d'));
				$diff = date_diff($date1, $date2);
				$day_diff = $diff->format("%a") + 1;
				if ($day_diff > 365) {
					$monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
					if (isset($timesheet[0]->days)) {
						$annul_days = $timesheet[0]->days;
					} else {
						$annul_days = 0;
					}
					$flag = 1;
				} else {
					$annul_days = 0;
					$flag = 0;
					$monthstart = date('Y-m-d', strtotime($timesheet[0]->from_date . ' -1 day'));
				}

				$end_date_co = date('Y-m-d', strtotime($monthstart));
			} else {
				$start_date_co = $joining_date[0]->date_of_joining;
				if ($user_info[0]->date_of_leaving) {
					$end_date_co = $user_info[0]->date_of_leaving;
				} else {
					$end_date_co = date('Y-m-d', strtotime($timesheet[0]->applied_on));
				}

				//$end_date_co = date('Y-m-d', strtotime($joining_date[0]->date_of_joining . ' + ' . $days_add . ' days'));
			}
		}
		$total_earning = $basic_salary + $allowance_amount + $commissions_amount + $other_payments_amount;
		$total_deduction = $statutory_deductions_amount + $loan_de_amount;
		$net_annual_amt = $total_earning - $total_deduction;


		/*	$ann_days_cal = $this->Xin_model->AttendnceCount_calc_common($user_info[0]->office_shift_id,$start_date_co,$end_date_co,$user_info[0]->company_id,$user_id,$difference_days=0,$yearsss='',$monthsss='','inderminity');
			if($ann_days_cal){
    		      $tot_days_lop = $ann_days_cal[0];
    		      $totl_num_days_pres = $ann_days_cal[1];
    		 }else{
    		      $tot_days_lop = 0;
    		      $totl_num_days_pres = 0;
    		 }*/
		// $totl_num_days_pres = $totl_num_days_pres - $tot_days_lop;
		//$no_days_ann = (30 / 365) * $totl_num_days_pres;
		if (isset($timesheet[0]->days)) {
			$no_days_ann = $timesheet[0]->days;
		} else {
			$no_days_ann = 0;
		}
		//$no_days_ann =
		$annual_amt_pay = ($net_annual_amt / 30) * $no_days_ann;
		$annual_amt_pay = number_format($annual_amt_pay, 3);
		return array($annual_amt_pay, $allowance_amount, $commissions_amount, $other_payments_amount, $statutory_deductions_amount, $loan_de_amount);
	}


	public function leave_cancel_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->get_leaves_cancel();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_leaves_cancel($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_employees_leaves_cancel($this->input->get("company_id"), $this->input->get("employee_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_leaves_new_cancel($this->input->get("company_id"), $this->input->get("employee_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_only_status_leaves_cancel($this->input->get("company_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_only_status_leaves_cancel($this->input->get("status"));
			}
		} else {
			$view_companies_ids = explode(',', $user_info[0]->view_companies_id);
			/*if ($user_info[0]->user_role_id != 1) {
				$leave = $this->Timesheet_model->get_employee_leaves($session['user_id']);
			} else {*/

			if ($user_info[0]->user_role_id == 1 || in_array('259', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_leaves_cancel();
			} else if (in_array('256', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new_cancel($user_info[0]->company_id, 'first');
			} else if (in_array('258', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new_cancel($user_info[0]->company_id, 'final');
			} else if (in_array('255', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_cancel($user_info[0]->company_id);
			} else {
				$leave = $this->Timesheet_model->get_employee_leaves_cancel($session['user_id']);

				//$leave = $this->Timesheet_model->get_leaves();
			}
			/*	}*/
		}

		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			// get start date and end date
			$user = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
			} else {
				$full_name = '--';
				$department_name = '--';
			}

			// get leave type
			$leave_type = $this->Timesheet_model->read_leave_type_information($r->leave_type_id);
			if (!is_null($leave_type)) {
				$type_name = $leave_type[0]->type_name;
			} else {
				$type_name = '--';
			}

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$datetime1 = new DateTime($r->from_date);
			$datetime2 = new DateTime($r->to_date);
			$interval = $datetime1->diff($datetime2);
			if (strtotime($r->from_date) == strtotime($r->to_date)) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$applied_on = $this->Xin_model->set_date_format($r->applied_on);
			/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/

			if ($r->is_half_day == 1) {
				/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $this->lang->line('xin_hr_leave_half_day');*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);
			} else {
				/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);
			}
			$check_unpaid_leaves_exits = $this->Timesheet_model->getNormalUnpaidLeaves($r->leave_id);
			if (!empty($check_unpaid_leaves_exits)) {
				$duration .= '<p style="font-size: 12px;font-style: italic;"><span style="font-size: 12px;font-style: italic;font-weight: 400;color: red;">Note* </span>: The applied leave duration is' . $r->from_date . ' to ' . $check_unpaid_leaves_exits[0]->to_date . '. The allotted leave is ' . $r->allotted_leave . ' so remaining ' . $check_unpaid_leaves_exits[0]->days . ' days move to unpaid leave section.When changed the duration automatically affected to the corresponding unpaid leave section.</p>';
			}

			if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
			elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
			elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
			else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
			endif;

			if ($r->status == 1) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} elseif ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} elseif ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} elseif ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}

			if ($r->leave_cancel_approval == '0') {
				$status1 = '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-ban"></i>  Pending</span>';
			} elseif ($r->leave_cancel_approval == '1') {
				$status1 = '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-ban"></i>  Approved</span>';
			} elseif ($r->leave_cancel_approval == '2') {
				$status1 = '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-ban"></i>   Rejected</span>';
			} else {
			}

			// 				if($r->leave_postpone_approval=='0')
			// 			{
			// 			  	$status2 = '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-calendar"></i>  Pending</span>';
			// 			}
			// 			elseif($r->leave_postpone_approval=='1')
			// 			{
			// 			   	$status2 = '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-calendar"></i>  Approved</span>';
			// 			}
			// 				elseif($r->leave_postpone_approval=='2')
			// 			{
			// 			  	$status2 = '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-calendar"></i>   Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}

			$disable_status_block = false;
			if (
				$user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)
				|| in_array('256', $role_resources_ids) || in_array('257', $role_resources_ids)
			) {
				$disable_status_block = false;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->second_approval > 0 || $r->final_approval || $r->status == 3)
			) {
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval || $r->first_approval < 1
					|| $r->first_approval == 2 || $r->status == 3)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if ($r->status == 2) {
				$disable_status_block = true;
			}

			if ($user_info[0]->user_role_id == 1) {
				$disable_status_block = false;
			}

			if (in_array('855', $role_resources_ids) || in_array('859', $role_resources_ids)) { //edit
				if ($disable_status_block) {
					$edit = '';
				} else {
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
					<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data-cancel" data-leave_id="' . $r->leave_id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
				}
			} else {
				$edit = '';
			}


			$combhr = $edit;
			/*$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_reason') . ': ' . $r->reason . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';*/
			if ($r->admin_read == 0 && $user_info[0]->user_role_id == 1) {
				$type_name = '<b>' . $type_name . '</b>';
				$department_name = '<b>' . $department_name . '</b>';
				$full_name = '<b>' . $full_name . '</b>';
				$duration = '<b>' . $duration . '</b>';
				$applied_on = '<b>' . $applied_on . '</b>';
			}

			if ((in_array('856', $role_resources_ids)) and ($r->status != 3) and ($r->leave_cancel_status != 'Y')) {

				$cancel = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Cancel Leave">
           <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light" data-toggle="modal" data-target=".leave-request-cancel" data-leave_c_id="' . $r->leave_id . '"data-field_type="leave""><span class="fa fa-ban"></span></button></span>';
				$combhr .= $cancel;
			}


			$data[] = array(
				$combhr,
				$type_name,
				$full_name,
				$status,
				$status1,

				$duration,
				$applied_on
			);
		}
		$output = array(
			"draw" => $draw,
			// "recordsTotal" => $leave->num_rows(),
			// "recordsFiltered" => $leave->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}


	public function annual_leave_cancel_list()
	{
		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/annuval_leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->get("ihr") == 'true') {
			if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->get_annual_leaves_cancel();
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_annual_leaves_cancel_get($this->input->get("company_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_employees_annual_leaves_cancel_get($this->input->get("company_id"), $this->input->get("employee_id"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") != 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_leaves_annuval_cancel_get($this->input->get("company_id"), $this->input->get("employee_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") != 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_annual_leaves_cancel_get($this->input->get("company_id"), $this->input->get("status"));
			} else if ($this->input->get("company_id") == 0 && $this->input->get("employee_id") == 0 && $this->input->get("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_annual_cancel($this->input->get("status"));
			}
		} else {
			$view_companies_ids = explode(',', $user_info[0]->view_companies_id);
			if ($user_info[0]->user_role_id == 1 || in_array('736', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_annual_leaves_cancel();
			} else if (in_array('256', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new_annual_cancel($user_info[0]->company_id, 'first', $session['user_id']);
				//	print_r($this->db->last_query());exit;
			} else if (in_array('258', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new_annual_cancel($user_info[0]->company_id, 'final', $session['user_id']);
			} else if (in_array('580', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_annual_leaves_cancel($user_info[0]->company_id, $session['user_id']);
			} else {
				$leave = $this->Timesheet_model->get_employee_annual_leaves_cancel($session['user_id']);
			}
		}
		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			// get start date and end date
			$user = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
			} else {
				$full_name = '--';
				$department_name = '--';
			}

			// get leave type
			$type_name = 'Annual Leave';

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$datetime1 = new DateTime($r->from_date);
			$datetime2 = new DateTime($r->to_date);
			$interval = $datetime1->diff($datetime2);
			if (strtotime($r->from_date) == strtotime($r->to_date)) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$applied_on = $this->Xin_model->set_date_format($r->applied_on);
			/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/


			/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;*/

			$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);

			if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
			elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
			elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
			else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
			endif;

			if ($r->status == 1) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} elseif ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} elseif ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} elseif ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}

			// 				if($r->leave_cancel_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-ban"></i> Leave Cancel Status Pending</span>';
			// 			}
			// 			elseif($r->leave_cancel_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-ban"></i> Leave Cancel Status Approved</span>';
			// 			}
			// 				elseif($r->leave_cancel_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-ban"></i>  Leave Cancel Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			$disable_status_block = false;
			if (
				$user_info[0]->user_role_id == 1 || in_array('256', $role_resources_ids)
				|| in_array('257', $role_resources_ids) || in_array('258', $role_resources_ids)
			) {
				$disable_status_block = false;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->second_approval > 0 || $r->final_approval || $r->status == 3)
			) {
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval || $r->first_approval < 1
					|| $r->first_approval == 2 || $r->status == 3)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if ($r->status == 2) {
				$disable_status_block = true;
			}

			if ($user_info[0]->user_role_id == 1) {
				$disable_status_block = false;
			}


			if (in_array('864', $role_resources_ids)) { //edit
				if ($disable_status_block) {
					$edit = '';
				} else {
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
					<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data-cancel" data-field_type="annual_leave" data-annual_leave_id="' . $r->id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
				}
			} else {
				$edit = '';
			}


			$combhr = $edit;
			$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_remarks') . ': ' . $r->remarks . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';


			if ($r->admin_read == 0 && $user_info[0]->user_role_id == 1) {
				$type_name = '<b>' . $type_name . '</b>';
				$department_name = '<b>' . $department_name . '</b>';
				$full_name = '<b>' . $full_name . '</b>';
				$duration = '<b>' . $duration . '</b>';
				$applied_on = '<b>' . $applied_on . '</b>';
				$status = '<b>' . $status . '</b>';
			}


			if ((in_array('856', $role_resources_ids)) and ($r->status != 3) and ($r->leave_cancel_status != 'Y')) {


				$cancel = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Cancel Leave">
           <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light" data-toggle="modal" data-target=".leave-request-cancel" data-leave_c_id="' . $r->id . '"data-field_type="a_leave" "><span class="fa fa-ban"></span></button></span>';

				$combhr .= $cancel;
			}
			$data[] = array(
				$combhr,
				$type_name,
				$department_name,
				$full_name,
				$duration,
				$status,
				$applied_on
			);
		}
		$output = array(
			"draw" => $draw,
			// "recordsTotal" => $leave->num_rows(),
			// "recordsFiltered" => $leave->num_rows(),
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}


	public function edit_leave_cancel_status()
	{


		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		if ($this->input->post('reason') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
		}


		$id = $this->uri->segment(4);
		$no_of_days_annual_remain = 0;


		$leave_cancel_approval = $this->input->post('status');

		$from_date_leave = $this->input->post('from_date_leave');
		$employee_id = $this->input->post('employee_id');


		$data = array(
			'remarks' => $this->input->post('remarks'),

			'leave_cancel_approval' => $leave_cancel_approval,
			'admin_read' => '0',
			'updated_date' => date('Y-m-d')

		);


		if ($this->input->post('leave_type_name') != 'a_leave') {
			$result = $this->Timesheet_model->update_leave_record($data, $id);
		} else {

			$result = $this->Timesheet_model->update_annualleave_readrecord($data, $id);
		}

		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_success_leave_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
	}


	public function edit_postpone_leave()
	{


		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		if ($this->input->post('reason') === '') {
			$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
		}


		$id = $this->uri->segment(4);


		$leave_postpone_status = 'Y';
		$leave_postpone_approval = '0';

		$from_date_leave = $this->input->post('from_date_leave');
		$employee_id = $this->input->post('employee_id');

		$start_date = $this->input->post('start_date');
		$end_date = $this->input->post('end_date');


		$datetime1 = new DateTime($this->input->post('start_date'));
		$datetime2 = new DateTime($this->input->post('end_date'));
		$interval = $datetime1->diff($datetime2);
		$no_of_days = $interval->format('%a') + 1;

		$cancel_status = $this->input->post('cancel_status');
		$cancel_approval = $this->input->post('cancel_approval');

		if (($cancel_status != 'N') and ($cancel_approval != '2')) {
			$Return['error'] = "Already sent a request for a leave cancellation.";
		}

		if ($from_date_leave < date('Y-m-d')) {
			$Return['error'] = "Please check the dates";
		}
		if ($Return['error'] != '') {
			$this->output($Return);
		}

		$data = array(
			'postpone_sdate' => $start_date,
			'postpone_edate' => $end_date,

			'leave_postpone_reason' => $this->input->post('postpone_reason'),
			'leave_postpone_status' => $leave_postpone_status,
			'leave_postpone_approval' => $leave_postpone_approval,
			'admin_read' => '0',
			'updated_date' => date('Y-m-d')

		);


		if ($this->input->post('leave_type_name') != 'a_leave') {
			$result = $this->Timesheet_model->update_leave_record($data, $id);
			$nticket_data = array(
				'module_name' => 'leave_postpone',
				'module_id' => $id,
				'employee_id' => $employee_id,
				'is_notify' => '1',
				'created_at' => date('d-m-Y h:i:s'),
			);
			$this->Xin_model->add_notifications($nticket_data);
		} else {

			$result = $this->Timesheet_model->update_annualleave_readrecord($data, $id);
			$nticket_data = array(
				'module_name' => 'annual_leave_postpone',
				'module_id' => $id,
				'employee_id' => $employee_id,
				'is_notify' => '1',
				'created_at' => date('d-m-Y h:i:s'),
			);
			$this->Xin_model->add_notifications($nticket_data);
		}

		if ($result == TRUE) {
			$Return['result'] = $this->lang->line('xin_success_leave_updated');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////
	public function add_leave_validate()
	{

		if ($this->input->post('add_type') == 'leave') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$remarks = $this->input->post('remarks');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);
			$no_of_days_annual_remain = 0;
			/* Server side PHP input validation */
			if ($this->input->post('leave_type') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_field');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			$no_of_days = $interval->format('%a') + 1;
			if ($this->input->post('leave_half_day') == 1 && $no_of_days > 1) {
				$Return['error'] = $this->lang->line('xin_hr_cant_appply_morethan') . ' 1 ' . $this->lang->line('xin_day') . ' in half day';
			}
			if ($Return['error'] != '') {
				$this->output($Return);
			}

			if ($this->input->post('start_date') != '') {
				//3 month probation calculation
				$date = date('Y-m-d');
				$joining_date = $this->Timesheet_model->joining_date($this->input->post('employee_id'));

				$d1 = strtotime($date);
				$d2 = strtotime($joining_date[0]->date_of_joining);
				$totalSecondsDiff = abs($d1 - $d2);
				$totalMonthsDiff = $totalSecondsDiff / 60 / 60 / 24 / 30;

				if ($d2 > $st_date) {
					$Return['error'] = 'Start Date should be greater than joining date';
				} elseif ($d2 > $ed_date) {
					$Return['error'] = 'End Date should be greater than joining date';
				}
				//condition for Marriage leave
				$date = date($this->input->post('start_date'));
				$date1 = date_create($date);
				$date2 = date_create($this->input->post('end_date'));
				$diff = date_diff($date1, $date2);
				$day_diff = $diff->format("%a") + 1;

				$eremaining_leave = 0; //$user_info_all[0]->leave_days;
				//condition for Haj leave
				/*$date1 = strtotime("2016-06-01");
            $date2 = strtotime("2021-09-21"); */

				$date1 = strtotime($joining_date[0]->date_of_joining);
				$date2 = strtotime(date('Y-m-d'));
				$diff = abs($date2 - $date1);
				$years = floor($diff / (365 * 60 * 60 * 24));
				//  print_r($years);exit;
				//print_r($joining_date[0]->ethnicity_type);exit;
				if ($this->input->post('leave_type') == 8) {
					if ($joining_date[0]->ethnicity_type == 2) {
					} else {
						$Return['error'] = "Only Muslim Can Apply for this leave";
					}
				}
				$count_l = 0;
				$leave_halfday_cal = employee_leave_halfday_cal($this->input->post('leave_type'), $this->input->post('employee_id'));
				foreach ($leave_halfday_cal as $lhalfday) :
					$count_l += 0.5;
				endforeach;

				$remaining_leave = count_leaves_info($this->input->post('leave_type'), $this->input->post('employee_id'));
				$remaining_leave = $remaining_leave - $count_l;

				$type = $this->Timesheet_model->read_leave_type_information($this->input->post('leave_type'));
				if (!is_null($type)) {
					$type_name = $type[0]->type_name;
					$total = $type[0]->days_per_year;
					$leave_remaining_total = $total - $remaining_leave;
				} else {
					$type_name = '--';
					$leave_remaining_total = 0;
				}

				if ($this->input->post('leave_type') == 3 || $this->input->post('leave_type') == 4 || $this->input->post('leave_type') == 5 || $this->input->post('leave_type') == 7) {
					$leave_remaining_total = $leave_remaining_total + $eremaining_leave;
				} else {
					$leave_remaining_total = $leave_remaining_total;
				}
			}
			if ($Return['error'] != '') {
				$Return['csrf_hash'] = $this->security->get_csrf_hash();
				$this->output($Return);
			}
			if ($this->input->post('leave_half_day') != 1) {
				$leave_half_day_opt = 0;
			} else {
				$leave_half_day_opt = $this->input->post('leave_half_day');
			}
			if (is_uploaded_file($_FILES['attachment']['tmp_name'])) {
				//checking image type
				$allowed = array('png', 'jpg', 'jpeg', 'pdf', 'gif');
				$filename = $_FILES['attachment']['name'];
				$ext = pathinfo($filename, PATHINFO_EXTENSION);

				if (in_array($ext, $allowed)) {
					$tmp_name = $_FILES["attachment"]["tmp_name"];
					$profile = "uploads/leave/";
					$set_img = base_url() . "uploads/leave/";
					// basename() may prevent filesystem traversal attacks;
					// further validation/sanitation of the filename may be appropriate
					$name = basename($_FILES["attachment"]["name"]);
					$newfilename = 'leave_' . round(microtime(true)) . '.' . $ext;
					move_uploaded_file($tmp_name, $profile . $newfilename);
					$fname = $newfilename;
					$Return['fileName'] = $fname;
				} else {
					$Return['error'] = $this->lang->line('xin_error_attatchment_type');
				}
			} else {
				$fname = '';
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			if (strtotime($this->input->post('start_date')) == strtotime($this->input->post('end_date'))) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function add_annuval_leave_validate()
	{
		if ($this->input->post('add_type') == 'leave_annuval') {
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$no_of_days_annual_remain = 0;
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$remarks = $this->input->post('remarks');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_remarks = htmlspecialchars(addslashes($remarks), ENT_QUOTES);

			$check_annual_leave_aval = $this->Timesheet_model->annual_leave_availablefor_emp_limt($this->input->post('employee_id'), 3);

			/* Server side PHP input validation */
			if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('employee_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_employee_id');
			} else if ($this->input->post('reason') === '') {
				$Return['error'] = $this->lang->line('xin_error_leave_type_reason');
			} else if (empty($check_annual_leave_aval)) {
				$Return['error'] = 'Annual leave not allotted for this employee';
			}
			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			$no_of_days = $interval->format('%a') + 1;
			if ($Return['error'] != '') {
				$Return['csrf_hash'] = $this->security->get_csrf_hash();
				$this->output($Return);
			}

			$datetime1 = new DateTime($this->input->post('start_date'));
			$datetime2 = new DateTime($this->input->post('end_date'));
			$interval = $datetime1->diff($datetime2);
			if (strtotime($this->input->post('start_date')) == strtotime($this->input->post('end_date'))) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			if (!empty($check_annual_leave_aval)) {
				$aval_leaves = $check_annual_leave_aval[0]->leave_count;
			} else {
				$aval_leaves = 30;
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function add_holiday_validate()
	{

		if ($this->input->post('add_type') == 'holiday') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');
			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('event_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_event_name');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function add_task_validate()
	{

		if ($this->input->post('add_type') == 'task') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			$start_date = $this->input->post('start_date');
			$end_date = $this->input->post('end_date');
			$description = $this->input->post('description');

			$st_date = strtotime($start_date);
			$ed_date = strtotime($end_date);
			$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('task_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_name');
			} else if ($this->input->post('start_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_start_date');
			} else if ($this->input->post('end_date') === '') {
				$Return['error'] = $this->lang->line('xin_error_end_date');
			} else if ($st_date > $ed_date) {
				$Return['error'] = $this->lang->line('xin_error_start_end_date');
			} else if ($this->input->post('task_hour') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_hour');
			} else if ($this->input->post('project_id') === '') {
				$Return['error'] = $this->lang->line('xin_error_project_field');
			} else if ($this->input->post('assigned_to') === '') {
				$Return['error'] = $this->lang->line('xin_error_task_assigned_user');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			if ($this->input->post('assigned_to') != '') {
				$assigned_ids = implode(',', $this->input->post('assigned_to'));
			} else {
				$assigned_ids = '';
			}
			// get company name by project id
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function add_office_shift_validate()
	{

		if ($this->input->post('add_type') == 'office_shift') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('shift_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_name_field');
			} else if ($this->input->post('total_working_hours') === '') {
				$Return['error'] = "Total Working Hours is required";
			} else if ($this->input->post('monday_in_time') != '' && $this->input->post('monday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_monday_timeout');
			} else if ($this->input->post('tuesday_in_time') != '' && $this->input->post('tuesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_tuesday_timeout');
			} else if ($this->input->post('wednesday_in_time') != '' && $this->input->post('wednesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_wednesday_timeout');
			} else if ($this->input->post('thursday_in_time') != '' && $this->input->post('thursday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_thursday_timeout');
			} else if ($this->input->post('friday_in_time') != '' && $this->input->post('friday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_friday_timeout');
			} else if ($this->input->post('saturday_in_time') != '' && $this->input->post('saturday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_saturday_timeout');
			} else if ($this->input->post('sunday_in_time') != '' && $this->input->post('sunday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_sunday_timeout');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function office_shift_custom_add_validate()
	{
		$Return = array(
			'result' => '',
			'error' => '',
			'csrf_hash' => $this->security->get_csrf_hash(),
		);

		$employee_id = $this->input->post("employee_id");
		$name = $this->input->post("name");
		$late_allowed_till = $this->input->post("late_allowed_till");
		$month = $this->input->post("month");

		if ($this->input->post('employee_id') === '') {
			$Return['error'] = 'Employee field is required';
		} else if ($name == '') {
			$Return['error'] = 'Shift name is required';
		} else if ($this->Office_shift_custom_model->assigned($employee_id, $month) > 0) {
			$Return['error'] = 'Shift already assigned for this Employee [' . $month . ']';
		} else if ($this->input->post('month') === '') {
			$Return['error'] = 'Shift Month is required';
		}
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		$this->output($Return);
	}

	public function edit_office_shift_validate()
	{

		if ($this->input->post('edit_type') == 'shift') {

			$id = $this->uri->segment(4);

			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');
			$Return['csrf_hash'] = $this->security->get_csrf_hash();

			/* Server side PHP input validation */
			if ($this->input->post('company_id') === '') {
				$Return['error'] = $this->lang->line('error_company_field');
			} else if ($this->input->post('shift_name') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_name_field');
			} else if ($this->input->post('monday_in_time') != '' && $this->input->post('monday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_monday_timeout');
			} else if ($this->input->post('tuesday_in_time') != '' && $this->input->post('tuesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_tuesday_timeout');
			} else if ($this->input->post('wednesday_in_time') != '' && $this->input->post('wednesday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_wednesday_timeout');
			} else if ($this->input->post('thursday_in_time') != '' && $this->input->post('thursday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_thursday_timeout');
			} else if ($this->input->post('friday_in_time') != '' && $this->input->post('friday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_friday_timeout');
			} else if ($this->input->post('saturday_in_time') != '' && $this->input->post('saturday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_saturday_timeout');
			} else if ($this->input->post('sunday_in_time') != '' && $this->input->post('sunday_out_time') === '') {
				$Return['error'] = $this->lang->line('xin_error_shift_sunday_timeout');
			}

			if ($Return['error'] != '') {
				$this->output($Return);
			}
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$this->output($Return);
			exit;
		}
	}

	public function current_month_holiday_get()
	{

		$session = $this->session->userdata('username');
		if (empty($session)) {
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if ($system[0]->module_assets != 'true') {
			redirect('admin/dashboard');
		}
		$user = $this->Xin_model->read_user_info($session['user_id']);
		// get designation
		$designation = $this->Designation_model->read_designation_information($user[0]->designation_id);
		if (!is_null($designation)) {
			$des_emp = $designation[0]->designation_name;
		} else {
			$des_emp = '--';
		}
		// get designation
		$department = $this->Department_model->read_department_information($user[0]->department_id);
		if (!is_null($department)) {
			$dep_emp = $department[0]->department_name;
		} else {
			$dep_emp = '--';
		}
		$data = array(
			'title' => $this->lang->line('dashboard_title') . ' | ' . $this->Xin_model->site_title(),
			'path_url' => 'dashboard',
			'first_name' => $user[0]->first_name,
			'last_name' => $user[0]->last_name,
			'employee_id' => $user[0]->employee_id,
			'username' => $user[0]->username,
			'email' => $user[0]->email,
			'designation_name' => $des_emp,
			'department_name' => $dep_emp,
			'date_of_birth' => $user[0]->date_of_birth,
			'date_of_joining' => $user[0]->date_of_joining,
			'contact_no' => $user[0]->contact_no,
			'last_four_employees' => $this->Xin_model->last_four_employees(),
			'get_last_payment_history' => $this->Xin_model->get_last_payment_history(),
			'all_holidays' => $this->Timesheet_model->get_holidays_calendar(),
			'all_leaves_request_calendar' => $this->Timesheet_model->get_leaves_request_calendar(),
			'all_upcoming_birthday' => $this->Xin_model->employees_upcoming_birthday(),
			'all_travel_request' => $this->Travel_model->get_travel(),
			'all_training' => $this->Training_model->get_training(),
			'all_projects' => $this->Project_model->get_projects(),
			'all_tasks' => $this->Timesheet_model->get_tasks(),
			'all_goals' => $this->Goal_tracking_model->get_goal_tracking(),
			'all_events' => $this->Events_model->get_events(),
			'all_meetings' => $this->Meetings_model->get_meetings(),
			'all_jobsx' => $this->Job_post_model->five_latest_jobs(),
			'all_jobs' => $this->Recruitment_model->get_all_jobs_last_desc()
		);
		$data['title'] = 'Holidays List' . ' | ' . $this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Holidays List';
		$data['path_url'] = 'dashboard';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		if (in_array('5', $role_resources_ids)) {
			$data['subview'] = $this->load->view("admin/dashboard/current_holiday_get_list", $data, TRUE);
			$this->load->view('admin/layout/layout_main', $data); //page load
		} else {
			redirect('admin/dashboard');
		}
	}


	public function current_month_holidays_list()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/dashboard/current_holiday_get_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);

		$current_month = date("Y-m");


		$holidays = $this->Timesheet_model->get_holidays_current_month_wise($current_month);

		$holidays_full = $this->Timesheet_model->get_holidays_full_list_wise($current_month);

		$data = array();

		$i = 0;

		foreach ($holidays->result() as $r) {
			$id = $r->company_id;
			$company_name = $this->Xin_model->get_company_name($id);
			// echo($company_name[0]->name);
			$i++;
			if ($r->start_date >= date("Y-m-d")) {

				$start_date = strtotime($r->start_date);
				$to_date = strtotime($r->end_date);

				$data[] = array(
					'<b style="color: #0747A3;">' . $i . '</b>',
					'<b style="color: #0747A3;">' . $company_name[0]->name . '</b>',
					'<b style="color: #0747A3;">' . $r->event_name . '</b>',

					'<b style="color: #0747A3;">' . $r->description . '</b>',
					'<b style="color: #0747A3;">' . date('d/M/Y', $start_date) . '</b>',
					'<b style="color: #0747A3;">' . date('d/M/Y', $to_date) . '</b>'
				);

			} else {

				$start_date1 = strtotime($r->start_date);
				$to_date1 = strtotime($r->end_date);

				$data[] = array(
					'<b>' . $i . '</b>',
					'<b style="color: #0747A3;">' . $company_name[0]->name . '</b>',
					'<b>' . $r->event_name . '</b>',
					'<b>' . $r->description . '</b>',
					'<b>' . date('d/M/Y', $start_date1) . '</b>',
					'<b>' . date('d/M/Y', $to_date1) . '</b>'
				);
			}

		}

		foreach ($holidays_full->result() as $f) {

			$start_date2 = strtotime($f->start_date);
			$to_date2 = strtotime($f->end_date);

			$i++;

			$data[] = array(
				$i,
				'<b style="color: #0747A3;">' . $company_name[0]->name . '</b>',
				$f->event_name,
				$f->description,
				date('d/M/Y', $start_date2),
				date('d/M/Y', $to_date2)
			);
		}

		$holidays_row1 = $holidays->num_rows();
		$holidays_row2 = $holidays_full->num_rows();

		$total_row = $holidays_row1 + $holidays_row2;

		$output = array(
			"draw" => $draw,
			"recordsTotal" => $total_row,
			"recordsFiltered" => $total_row,
			"data" => $data
		);
		echo json_encode($output);
		exit();
	}

	public function edit_task_validate()

	{


		$id = $this->uri->segment(4);

		/* Define return | here result is used to return user data and error for error message */

		$Return = array('result' => '', 'error' => '', 'csrf_hash' => '');

		$Return['csrf_hash'] = $this->security->get_csrf_hash();


		$start_date = $this->input->post('start_date');

		$end_date = $this->input->post('end_date');

		$description = $this->input->post('description');


		$st_date = strtotime($start_date);

		$ed_date = strtotime($end_date);

		$qt_description = htmlspecialchars(addslashes($description), ENT_QUOTES);


		/* Server side PHP input validation */

		if ($this->input->post('project_id') === '') {

			$Return['error'] = $this->lang->line('xin_error_project_field');

		} else if ($this->input->post('task_name') === '') {

			$Return['error'] = $this->lang->line('xin_error_task_name');

		} else if ($this->input->post('start_date') === '') {

			$Return['error'] = $this->lang->line('xin_error_start_date');

		} else if ($this->input->post('end_date') === '') {

			$Return['error'] = $this->lang->line('xin_error_end_date');

		} else if ($st_date > $ed_date) {

			$Return['error'] = $this->lang->line('xin_error_start_end_date');

		} else if ($this->input->post('task_hour') === '') {

			$Return['error'] = $this->lang->line('xin_error_task_hour');

		}


		if ($Return['error'] != '') {

			$this->output($Return);

		}


		$this->output($Return);

		exit;


	}

	public function office_shift_custom_update_validate($id)

	{

		$Return = array(

			'result' => '',

			'error' => '',

			'csrf_hash' => $this->security->get_csrf_hash(),

		);

		if ($this->input->post('name') === '') {


			$Return['error'] = "Shift Name is required";


		} else if ($this->input->post('late_allowed_till') === '') {


			$Return['error'] = "Late allowed till is required";


		}

		$this->output($Return);

	}

	public function leave_pdf()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/leave", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$data = array();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->post("ihr") == 'true') {
			if ($this->input->post("company_id") == 0 && $this->input->post("employee_id") == 0 && $this->input->post("status") == 0) {
				$leave = $this->Timesheet_model->get_leaves();
			} else if ($this->input->post("company_id") != 0 && $this->input->post("employee_id") == 0 && $this->input->post("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_leaves($this->input->post("company_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("employee_id") != 0 && $this->input->post("status") == 0) {
				$leave = $this->Timesheet_model->filter_company_employees_leaves($this->input->post("company_id"), $this->input->post("employee_id"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("employee_id") != 0 && $this->input->post("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_employees_status_leaves_new($this->input->post("company_id"), $this->input->post("employee_id"), $this->input->post("status"));
			} else if ($this->input->post("company_id") != 0 && $this->input->post("employee_id") == 0 && $this->input->post("status") != 0) {
				$leave = $this->Timesheet_model->filter_company_only_status_leaves($this->input->post("company_id"), $this->input->post("status"));
			} else if ($this->input->post("company_id") == 0 && $this->input->post("employee_id") == 0 && $this->input->post("status") != 0) {
				$leave = $this->Timesheet_model->filter_only_status_leaves($this->input->post("status"));
			}
		} else {
			$view_companies_ids = explode(',', $user_info[0]->view_companies_id);
			/*if ($user_info[0]->user_role_id != 1) {
				$leave = $this->Timesheet_model->get_employee_leaves($session['user_id']);
			} else {*/

			if ($user_info[0]->user_role_id == 1 || in_array('259', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_leaves();
			} else if (in_array('256', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new($user_info[0]->company_id, 'first');
			} else if (in_array('258', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves_new($user_info[0]->company_id, 'final');
			} else if (in_array('255', $role_resources_ids)) {
				$leave = $this->Timesheet_model->get_company_leaves($user_info[0]->company_id);
			} else {
				$leave = $this->Timesheet_model->get_employee_leaves($session['user_id']);

				//$leave = $this->Timesheet_model->get_leaves();
			}
			/*	}*/
		}

		// reports to
		$reports_to = get_reports_team_data($session['user_id']);
		foreach ($leave->result() as $r) {

			// get start date and end date
			$user = $this->Xin_model->read_user_info($r->employee_id);
			if (!is_null($user)) {
				$full_name = $user[0]->first_name . ' ' . $user[0]->middle_name . ' ' . $user[0]->last_name;
				// department
				$department = $this->Department_model->read_department_information($user[0]->department_id);
				if (!is_null($department)) {
					$department_name = $department[0]->department_name;
				} else {
					$department_name = '--';
				}
			} else {
				$full_name = '--';
				$department_name = '--';
			}

			// get leave type
			$leave_type = $this->Timesheet_model->read_leave_type_information($r->leave_type_id);
			if (!is_null($leave_type)) {
				$type_name = $leave_type[0]->type_name;
			} else {
				$type_name = '--';
			}

			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}

			$datetime1 = new DateTime($r->from_date);
			$datetime2 = new DateTime($r->to_date);
			$interval = $datetime1->diff($datetime2);
			if (strtotime($r->from_date) == strtotime($r->to_date)) {
				$no_of_days = 1;
			} else {
				$no_of_days = $interval->format('%a') + 1;
			}
			$applied_on = $this->Xin_model->set_date_format($r->applied_on);
			/*$duration = $this->Xin_model->set_date_format($r->from_date).' '.$this->lang->line('dashboard_to').' '.$this->Xin_model->set_date_format($r->to_date).'<br>'.$this->lang->line('xin_hrsale_total_days').': '.$no_of_days;*/

			if ($r->is_half_day == 1) {
				/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $this->lang->line('xin_hr_leave_half_day');*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);
			} else {
				/*$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date) . '<br>' . $this->lang->line('xin_hrsale_total_days') . ': ' . $no_of_days;*/

				$duration = $this->Xin_model->set_date_format($r->from_date) . ' ' . $this->lang->line('dashboard_to') . ' ' . $this->Xin_model->set_date_format($r->to_date);
			}


			$check_unpaid_leaves_exits = $this->Timesheet_model->getNormalUnpaidLeaves($r->leave_id);
			if (!empty($check_unpaid_leaves_exits)) {
				$duration .= '<p style="font-size: 12px;font-style: italic;"><span style="font-size: 12px;font-style: italic;font-weight: 400;color: red;">Note* </span>: The applied leave duration is' . $r->from_date . ' to ' . $check_unpaid_leaves_exits[0]->to_date . '. The allotted leave is ' . $r->allotted_leave . ' so remaining ' . $check_unpaid_leaves_exits[0]->days . ' days move to unpaid leave section.When changed the duration automatically affected to the corresponding unpaid leave section.</p>';
			}

			if ($r->status == 1) : $status = '<span class="badge bg-orange">' . $this->lang->line('xin_pending') . '</span>';
			elseif ($r->status == 2) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_approved') . '</span>';
			elseif ($r->status == 4) : $status = '<span class="badge bg-green">' . $this->lang->line('xin_role_first_level_approved') . '</span>';
			else : $status = '<span class="badge bg-red">' . $this->lang->line('xin_rejected') . '</span>';
			endif;

			if ($r->status == 1) {
				if ($r->first_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> First approval</span>';
				} elseif ($r->first_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> First approval</span>';
				}
				if ($r->second_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Second approval</span>';
				} elseif ($r->second_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Second approval</span>';
				}
				if ($r->final_approval == 1) {
					$status .= '<br><span class="small text-nowrap text-success"><i class="fas fa-check"></i> Final approval</span>';
				} elseif ($r->final_approval == 2) {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval Rejected</span>';
				} else {
					$status .= '<br><span class="small text-nowrap text-danger"><i class="fas fa-times"></i> Final approval</span>';
				}
			}

			// 		if($r->leave_cancel_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-ban"></i> Leave Cancel Status Pending</span>';
			// 			}
			// 			elseif($r->leave_cancel_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-ban"></i> Leave Cancel Status Approved</span>';
			// 			}
			// 				elseif($r->leave_cancel_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-ban"></i>  Leave Cancel Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			// 				if($r->leave_postpone_approval=='0')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f1bf09;"><i class="fa fa-calendar"></i> Leave Postpone Status Pending</span>';
			// 			}
			// 			elseif($r->leave_postpone_approval=='1')
			// 			{
			// 			   	$status .= '<br><span class="small text-nowrap " style="color: #0df109;"> <i class="fa fa-calendar"></i> Leave Postpone Status Approved</span>';
			// 			}
			// 				elseif($r->leave_postpone_approval=='2')
			// 			{
			// 			  	$status .= '<br><span class="small text-nowrap " style="color: #f50707;"><i class="fa fa-calendar"></i>  Leave Postpone Status Rejected</span>';
			// 			}
			// 			else
			// 			{

			// 			}


			$disable_status_block = false;
			if (
				$user_info[0]->user_role_id == 1 || in_array('258', $role_resources_ids)
				|| in_array('256', $role_resources_ids) || in_array('257', $role_resources_ids)
			) {
				$disable_status_block = false;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->second_approval > 0 || $r->final_approval || $r->status == 3)
			) {
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && !in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval || $r->first_approval < 1
					|| $r->first_approval == 2 || $r->status == 3)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if (
				in_array('256', $role_resources_ids) && in_array('257', $role_resources_ids)
				&& !in_array('258', $role_resources_ids) && ($r->final_approval)
			) { //257 second approval permission
				$disable_status_block = true;
			}
			if ($r->status == 2) {
				$disable_status_block = true;
			}

			if ($user_info[0]->user_role_id == 1) {
				$disable_status_block = false;
			}

			if (in_array('252', $role_resources_ids) || in_array('261', $role_resources_ids)) { //edit
				if ($disable_status_block) {
					$edit = '';
				} else {
					$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '">
					<button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-leave_id="' . $r->leave_id . '" ><span class="fas fa-pencil-alt"></span></button></span>';
				}
			} else {
				$edit = '';
			}

			if (in_array('253', $role_resources_ids) || in_array('262', $role_resources_ids)) { // delete
				if ($disable_status_block) {
					$delete = '';
				} else {
					$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->leave_id . '"><span class="fas fa-trash-restore"></span></button></span>';
				}
			} else {
				$delete = '';
			}
			if (in_array('254', $role_resources_ids) || $user_info[0]->user_role_id == 1 || $reports_to > 0 || in_array('263', $role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view_details') . '"><a href="' . site_url() . 'admin/timesheet/leave_details/id/' . $r->leave_id . '/"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light"><span class="fa fa-eye"></span></button></a></span>';
			} else {
				$view = '';
			}
			$combhr = $edit . $view . $delete;
			/*$itype_name = $type_name . '<br><small class="text-muted"><i>' . $this->lang->line('xin_reason') . ': ' . $r->reason . '<i></i></i></small><br><small class="text-muted"><i>' . $status . '<i></i></i></small><br><small class="text-muted"><i>' . $this->lang->line('left_company') . ': ' . $comp_name . '<i></i></i></small>';*/
			if ($r->admin_read == 0 && $user_info[0]->user_role_id == 1) {
				$type_name = '<b>' . $type_name . '</b>';
				$department_name = '<b>' . $department_name . '</b>';
				$full_name = '<b>' . $full_name . '</b>';
				$duration = '<b>' . $duration . '</b>';
				$applied_on = '<b>' . $applied_on . '</b>';
			}

			//   if ((in_array('856', $role_resources_ids)) and ($r->status!=3) ){
			//   if (($r->leave_postpone_status!='Y')and ($r->status==2))
			//   {
			//     $postpone= '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Leave postpone">
			//   <button type="button" class="btn icon-btn btn-sm btn-outline-secondary  waves-effect waves-light" data-toggle="modal" data-target=".leave-request-postpone" data-leave_postpone_id="' . $r->leave_id . '"data-field_type="leave""><span class="fa fa-calendar"></span></button></span>';
			//   }
			//   else
			//   {
			//   $postpone='';
			//   }

			//   if (($r->leave_cancel_status!='Y'))
			//   {
			//   $cancel = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="Cancel Leave">
			//   <button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light" data-toggle="modal" data-target=".leave-request-cancel" data-leave_c_id="' . $r->leave_id . '"data-field_type="leave""><span class="fa fa-ban"></span></button></span>';

			//   }
			//   else
			//   {
			//   $cancel='';
			//   }

			//   $combhr .= $postpone.$cancel;

			//   }


			if (in_array('252', $role_resources_ids) || in_array('261', $role_resources_ids) || in_array('253', $role_resources_ids) || in_array('262', $role_resources_ids) || in_array('254', $role_resources_ids) || in_array('263', $role_resources_ids)) {
				$data[] = array(
					'type_name' => $type_name,
					'department_name' => $department_name,
					'full_name' => $full_name,
					'status' => $status,
					'duration' => $duration,
					'applied_on' => $applied_on,

				);
			}

		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;
		$html = $this->load->view("admin/timesheet/get_leave_pdf", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Leave_report.pdf', 'D'); //
	}

	public function holidays_pdf()
	{

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		if (!empty($session)) {
			$this->load->view("admin/timesheet/holidays", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));

		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if ($this->input->post("ihr") == 'true') {
			if ($this->input->post("p_company_id") == 0 && $this->input->post("p_status_id") == 'all') {
				$holidays = $this->Timesheet_model->get_holidays();
			} else if ($this->input->post("p_company_id") != 0 && $this->input->post("p_status_id") == 'all') {
				$holidays = $this->Timesheet_model->filter_company_holidays($this->input->post("p_company_id"));
			} else if ($this->input->post("p_company_id") != 0 && $this->input->post("p_status_id") != 'all') {
				$holidays = $this->Timesheet_model->filter_company_publish_holidays($this->input->post("p_company_id"), $this->input->post("p_status_id"));
			} else if ($this->input->post("p_company_id") == 0 && $this->input->post("p_status_id") != 'all') {
				$holidays = $this->Timesheet_model->filter_notcompany_publish_holidays($this->input->post("p_status_id"));
			}
		} else {
			if ($user_info[0]->user_role_id == 1 || in_array('422', $role_resources_ids)) {
				$holidays = $this->Timesheet_model->get_holidays();
			} else {
				$holidays = $this->Timesheet_model->get_company_holidays($user_info[0]->company_id);
			}
		}
		$data = array();

		foreach ($holidays->result() as $r) {

			/* get publish/unpublish label*/
			if ($r->is_publish == 1) : $publish = '<span class="badge bg-green">' . $this->lang->line('xin_published') . '</span>';
			else : $publish = '<span class="badge bg-orange">' . $this->lang->line('xin_unpublished') . '</span>';
			endif;
			// get start date and end date
			$sdate = $this->Xin_model->set_date_format($r->start_date);
			$edate = $this->Xin_model->set_date_format($r->end_date);
			// get company
			$company = $this->Xin_model->read_company_info($r->company_id);
			if (!is_null($company)) {
				$comp_name = $company[0]->name;
			} else {
				$comp_name = '--';
			}
			if (in_array('420', $role_resources_ids) || in_array('424', $role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_edit') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light edit-data" data-toggle="modal" data-target=".edit-modal-data" data-holiday_id="' . $r->holiday_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if (in_array('421', $role_resources_ids) || in_array('425', $role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="' . $this->lang->line('xin_delete') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="' . $r->holiday_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if (in_array('826', $role_resources_ids) || in_array('426', $role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="' . $this->lang->line('xin_view') . '"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-holiday_id="' . $r->holiday_id . '"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}
			$combhr = $edit . $view . $delete;
			//$ievent_name = $r->event_name . '<br><small class="text-muted"><i>' . $comp_name . '<i></i></i></small><br><small class="text-muted"><i>' . $publish . '<i></i></i></small>';
			$ievent_name = $r->event_name;
			if (in_array('420', $role_resources_ids) || in_array('421', $role_resources_ids) || in_array('826', $role_resources_ids) || in_array('424', $role_resources_ids) || in_array('425', $role_resources_ids) || in_array('426', $role_resources_ids)) {
				$data[] = array(

					'ievent_name' => $ievent_name,
					'comp_name' => $comp_name,
					'date' => $sdate,
					'edate' => $edate,
					'publish' => $publish,

				);
			}
		}
		$this->load->library('M_pdf');
		$mpdf = $this->m_pdf->load([
			'mode' => 'utf-8',
			'format' => 'A4'
		]);
		$res['lists'] = $data;

		$html = $this->load->view("admin/timesheet/get_holidays_pdf_format", $res, true);
		$mpdf->WriteHTML($html);
		$mpdf->Output('Holidays.pdf', 'D'); //
	}

	public function get_biometric_data()
	{
		$insert_array = json_decode($this->input->post('data'));
		foreach ($insert_array as $val) {
			$check_exist = $this->Timesheet_model->get_data('bio_enteries', array('user_id' => $val->user_id, 'terminal_id' => $val->terminal_id, 'user_mode' => $val->user_mode, 'entered_date' => $val->entered_date, 'entered_time' => $val->entered_time));
			if (empty($check_exist)) {
				$insert['user_id'] = $val->user_id;
				$insert['terminal_id'] = $val->terminal_id;
				$insert['user_mode'] = $val->user_mode;
				$insert['user_name'] = $val->user_name;
				$insert['entered_date'] = $val->entered_date;
				$insert['entered_time'] = $val->entered_time;
				$biometric_id = $this->Timesheet_model->insert($insert, 'bio_enteries');
				$employee_details = $this->Timesheet_model->get_data('xin_employees', array('employee_id' => $val->employee_id));
				$user_id = $employee_details[0]->user_id;
				$attendance_date = $insert['entered_date'];
				$condition_array = array('employee_id' => $user_id, 'attendance_date' => $attendance_date);
				$attendance_details = $this->Timesheet_model->get_data_ordered('xin_attendance_time', $condition_array, 'time_attendance_id', 'desc');
				if ($val->user_mode != 3) {
					if ($val->user_mode == 2 || $val->user_mode == 4) {
						if (empty($attendance_details)) {
							$attendance_date = date('Y-m-d', strtotime($insert['entered_date'] . "-1 day"));
							$attendance_details = $this->Timesheet_model->get_data_ordered('xin_attendance_time', array('employee_id' => $user_id, 'attendance_date' => $attendance_date), 'time_attendance_id', 'desc');
						}
						if (!empty($attendance_details) && empty($attendance_details[0]->clock_out)) {
							$clock_out = $insert['entered_date'] . ' ' . $insert['entered_time'];
							$this->clock_in_clock_out_add($attendance_details[0]->time_attendance_id, $biometric_id, $user_id, $attendance_date, '', $clock_out, 'clock_out', $insert['terminal_id']);
						}
					} elseif ($val->user_mode == 1 || $val->user_mode == 5) {
						$clock_in = $insert['entered_date'] . ' ' . $insert['entered_time'];
						$this->clock_in_clock_out_add('', $biometric_id, $user_id, $insert['entered_date'], $clock_in, '', 'clock_in', $insert['terminal_id']);
					}
				} else {
					if (!empty($attendance_details) && empty($attendance_details[0]->clock_out)) {
						$clock_out = $insert['entered_date'] . ' ' . $insert['entered_time'];
						$this->clock_in_clock_out_add($attendance_details[0]->time_attendance_id, $biometric_id, $user_id, $attendance_date, '', $clock_out, 'clock_out', $insert['terminal_id']);
					} else {
						if (empty($attendance_details)) {
							$attendance_date = date('Y-m-d', strtotime($insert['entered_date'] . "-1 day"));
							$user = $this->Employees_model->read_user_by_user_id($user_id);
							if ($user[0]->office_shift_id == 0) {
								$last_day_shit = $this->Office_shift_custom_model->employee_current_shift($user[0]->user_id, $attendance_date);
								$day = date('j', strtotime($attendance_date));
								$out_time = $day . "_out";
								$shift_end = $last_day_shit[$out_time];
							} else {
								$last_day_shit = $this->Employees_model->get_lateallowed_foremployee($user[0]->office_shift_id);
								$timestamp = strtotime($attendance_date);
								$day = date('l', $timestamp);
								$week_day = date('l', strtotime($attendance_date));
								$week_day_lower = strtolower($week_day);
								$table_field_out_time = $week_day_lower . '_out_time';
								$shift_end = $last_day_shit[0]->$table_field_out_time;
							}
							$attendance_details = '';
							if (!empty($shift_end)) {
								$shift_end_time = strtotime($shift_end);
								$c_clock_out_time = strtotime($insert['entered_time']);
								$extra_over_time = strtotime($shift_end . "+8 hours");
								if (($c_clock_out_time <= $shift_end_time) || (($c_clock_out_time > $shift_end_time) && ($c_clock_out_time <= $extra_over_time))) {
									$attendance_details = $this->Timesheet_model->get_data_ordered('xin_attendance_time', array('employee_id' => $user_id, 'attendance_date' => $attendance_date), 'time_attendance_id', 'desc');
								}
							}
						}
						if (!empty($attendance_details) && empty($attendance_details[0]->clock_out)) {
							$clock_out = $insert['entered_date'] . ' ' . $insert['entered_time'];
							$this->clock_in_clock_out_add($attendance_details[0]->time_attendance_id, $biometric_id, $user_id, $attendance_date, '', $clock_out, 'clock_out', $insert['terminal_id']);
						} else {
							$clock_in = $insert['entered_date'] . ' ' . $insert['entered_time'];
							$this->clock_in_clock_out_add('', $biometric_id, $user_id, $insert['entered_date'], $clock_in, '', 'clock_in', $insert['terminal_id']);
						}
					}
				}
			}
		}
	}

	public function clock_in_clock_out_add($time_attendance_id, $biometric_id, $user_id, $attendance_date, $clock_in, $clock_out, $clock_state, $terminal_id)
	{
		$user = $this->Employees_model->read_user_by_user_id($user_id);
		$comp_id = $user[0]->company_id;
		if ($clock_state == 'clock_in') {
			$query = $this->Timesheet_model->user_attendance($attendance_date, $user_id);
			$result = $query->result();
			if ($query->num_rows() < 1) {
				$total_rest = '';

				# NEW:
				// $late_time = '00:00';
				// if ($user[0]->late_deduction == 1) {
				$late_time = $this->Misc_model->find_late($clock_in, $user[0]->company_id, $user[0]->office_shift_id, $user[0]->user_id, $attendance_date);
				// }
				$this->db->insert('xin_attendance_time_total', array(
					'employee_id' => $user_id,
					'date' => $clock_in,
					'late' => $late_time,
				));
				#-----------------#
			} else {
				$cout = new DateTime($result[0]->clock_out);
				$cin = new DateTime($clock_in);

				$interval_cin = $cin->diff($cout);
				$hours_in = $interval_cin->format('%h');
				$minutes_in = $interval_cin->format('%i');
				$total_rest = $hours_in . ":" . $minutes_in;
				$late_time = '00:00';
				#-----------------#
			}

			$data = array(
				'employee_id' => $user_id,
				'entered_type' => 2,
				'clock_in_entered_id' => $biometric_id,
				'attendance_date' => $attendance_date,
				'clock_in' => $clock_in,
				'clock_in_time' => date('H:i', strtotime($clock_in)),
				'clock_in_ip_address' => $terminal_id,
				'clock_in_latitude' => '',
				'clock_in_longitude' => '',
				'time_late' => $clock_in,
				'early_leaving' => $clock_in,
				'overtime' => $clock_in,
				'total_rest' => $total_rest,
				'attendance_status' => 'Present',
				'clock_in_out' => '1'
			);

			$result = $this->Timesheet_model->add_new_attendance($data);

			if ($result == TRUE) {
				$Return['result'] = $this->lang->line('xin_success_clocked_in');
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
		} else if ($clock_state == 'clock_out') {
			global $holiday_check;
			global $weekends;
			$query = $this->Timesheet_model->user_attendance_clockout($attendance_date, $user_id);
			$clocked_out = $query->result();
			$total_work_cin = new DateTime($clocked_out[0]->clock_in);
			$total_work_cout = new DateTime($clock_out);


			$interval_cin = $total_work_cout->diff($total_work_cin);
			$hours_in = $interval_cin->format('%h');
			$minutes_in = $interval_cin->format('%i');
			$total_work = $hours_in . ":" . $minutes_in;
			$work_mins_to_hour = round($minutes_in / 60, 2);
			$work_by_hours = $hours_in + $work_mins_to_hour;
			$id = $time_attendance_id;
			$attend_details = $this->Timesheet_model->get_attendance_details($id);
			$clockin = $attend_details[0]->clock_in;

			$cmp_id = $this->Employees_model->get_employee_details($user_id);
			$late_allowed = $this->Employees_model->get_lateallowed($cmp_id[0]->company_id);
			$on_duty3 = $attendance_date . ' ' . $late_allowed[0]->late_allowed_till;

			$overtime_consts = $this->Xin_model->get_all_overtime_constants();
			$weekend = $overtime_consts[0]->weekend;
			$holiday = $overtime_consts[0]->holiday;
			$workingday = $overtime_consts[0]->workingday;
			$timeshift_from = $overtime_consts[0]->timeshift_from;
			$timeshift_to = $overtime_consts[0]->timeshift_to;
			$timeshift_percent = $overtime_consts[0]->timeshift_percent;
			$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
			$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
			$evening_timeshift_percent = $overtime_consts[0]->evening_timeshift_percent;

			$timeshiftfrom = $attendance_date . ' ' . $timeshift_from;
			$nextdate = date('Y-m-d', strtotime($attendance_date . " +1 days"));
			$timeshiftto = $nextdate . ' ' . $timeshift_to;

			$off_time = $attendance_date . ' ' . $evening_timeshift_from;
			$diff = strtotime($off_time) - strtotime($clock_out);
			$timestamp = strtotime($attendance_date);
			$day = date('l', $timestamp);

			$holidays = $this->Employees_model->get_holidays($comp_id);
			if (isset($holidays)) {
				foreach ($holidays as $row) {

					$startDate = $row->start_date;
					$endDate = $row->end_date;
					if (($attendance_date >= $startDate) && ($attendance_date <= $endDate)) {
						$holiday_check = "yes";
					}
				}
			}

			if ($day === "Friday") {
				$ot = "yes";
				$basic_pay = $user[0]->basic_salary;
				$clk_out = new DateTime($clock_out);
				$clk_in = new DateTime($clockin);
				$interval = $clk_out->diff($clk_in);
				$hours_in = $interval->format('%h');
				$minutes_in = $interval->format('%i');
				$min_to_hour = $minutes_in / 60;
				$normalot_hours = 0;
				$weekendpercent = ($weekend * 100) / 100;
				$extra_ot_hours = $hours_in + $min_to_hour;
				$extraot_hours = round($extra_ot_hours, 2);
				$amount = (($basic_pay / 30) / 8) * $extraot_hours * $weekendpercent;
				$roundamount = round($amount, 3);
			} elseif ($holiday_check === "yes") {
				$ot = "yes";
				$basic_pay = $user[0]->basic_salary;
				$clk_out = new DateTime($clock_out);
				$clk_in = new DateTime($clockin);
				$interval = $clk_out->diff($clk_in);
				$hours_in = $interval->format('%h');
				$minutes_in = $interval->format('%i');
				$min_to_hour = $minutes_in / 60;
				$normalot_hours = 0;
				$holidaypercent = ($holiday * 100) / 100;
				$extra_ot_hours = $hours_in + $min_to_hour;
				$extraot_hours = round($extra_ot_hours, 2);
				$amount = (($basic_pay / 30) / 8) * $extraot_hours * $holidaypercent;
				$roundamount = round($amount, 3);
				$holiday_check = "no";
			} elseif ($diff < 0 && $day !== "Friday" && $holiday_check !== "yes") {
				$ot = "yes";
				$basic_pay = $user[0]->basic_salary;
				$cutoff_time = $attendance_date . ' ' . $timeshift_from;
				$dayend_cutoff = $nextdate . ' ' . $timeshift_to;
				$diff_in_hrs = (strtotime($cutoff_time) - strtotime($clock_out)) / 3600;
				$evening_cutoff_time = $attendance_date . ' ' . $evening_timeshift_to;
				$normalovertime = (strtotime($evening_timeshift_to) - strtotime($evening_timeshift_from)) / 3600;
				$extraovertime = (strtotime($timeshiftto) - strtotime($timeshiftfrom)) / 3600;
				if ($diff_in_hrs >= 0 && $diff_in_hrs <= $normalovertime) {
					$clk_out = new DateTime($clock_out);
					$clk_in = new DateTime($clockin);
					$workedhours = (strtotime($off_time) - strtotime($clockin)) / 3600;
					if ($workedhours <= 0) {
						$interval = $clk_out->diff($clk_in);
						$hours_in = $interval->format('%h');
						$minutes_in = $interval->format('%i');
						$min_to_hour = $minutes_in / 60;
						$normal_ot_hours = $hours_in + $min_to_hour;
						$normalot_hours = round($normal_ot_hours, 2);
					} elseif ($workedhours > 0) {
						$interval = $clk_out->diff($clk_in);
						$hours_in = $interval->format('%h');
						$minutes_in = $interval->format('%i');
						$min_to_hour = $minutes_in / 60;
						$normal_ot_hours = $hours_in + $min_to_hour - $workedhours;
						$normalot_hours = round($normal_ot_hours, 2);
					}
					$workingdaypercent = ($workingday * 100) / 100;
					$extraot_hours = 0;
					$amount = (($basic_pay / 30) / 8) * $normalot_hours * $workingdaypercent;
					$roundamount = round($amount, 3);
				} elseif ($diff_in_hrs < 0) {
					$normalovertimehours = (strtotime($evening_cutoff_time) - strtotime($clockin)) / 3600;
					$diff_in_hrs = (strtotime($cutoff_time) - strtotime($clock_out)) / 3600;
					$clk_out = new DateTime($clock_out);
					$clk_in = new DateTime($clockin);
					$workedhours = (strtotime($off_time) - strtotime($clockin)) / 3600;
					if ($workedhours <= 0) {
						$interval = $clk_out->diff($clk_in);
						$hours_in = $interval->format('%h');
						$minutes_in = $interval->format('%i');
						$min_to_hour = $minutes_in / 60;
						$workingdaypercent = ($workingday * 100) / 100;
						$timeshiftpercent = ($timeshift_percent * 100) / 100;
						$extra_ot_hours = $hours_in + $min_to_hour;
						$difference_in_hrs = (strtotime($clock_out) - strtotime($cutoff_time)) / 3600;
						if ($difference_in_hrs > $extraovertime) {
							$difference = $difference_in_hrs - $extraovertime;
							$extra_ot_hours = $extra_ot_hours - $difference;
						}
						if ($normalovertimehours > 0) {
							$normalot_hours = round($normalovertimehours, 2);
							$extra_ot_hours = $extra_ot_hours - $normalot_hours;
						} else {
							$normalot_hours = 0;
						}
					} elseif ($workedhours > 0) {
						$interval = $clk_out->diff($clk_in);
						$hours_in = $interval->format('%h');
						$minutes_in = $interval->format('%i');
						$min_to_hour = $minutes_in / 60;
						$workingdaypercent = ($workingday * 100) / 100;
						$timeshiftpercent = ($timeshift_percent * 100) / 100;
						$extra_ot_hours = $hours_in + $min_to_hour;
						if ($normalovertimehours > 0) {
							$normalot_hours = $normalovertimehours - $workedhours;
							$extra_ot_hours = $extra_ot_hours - $normalot_hours - $workedhours;
						} else {
							$normalot_hours = 0;
						}
					}
					$extraot_hours = round($extra_ot_hours, 2);
					$amount = (($basic_pay / 30) / 8) * $extraot_hours * $timeshiftpercent + (($basic_pay / 30) / 8) * $normalot_hours * $workingdaypercent;
					$roundamount = round($amount, 3);
				}
			} else {
				$ot = "no";
				$normalot_hours = 0;
				$extraot_hours = 0;
				$roundamount = 0;
			}
			if ($user[0]->office_shift_id == 0) {
				$late_allowed = $this->Office_shift_custom_model->employee_current_shift($user[0]->user_id, $attendance_date);
				$day = date('j', strtotime($attendance_date));
				$in_time = $day . "_in";
				if (!$late_allowed[$in_time]) {
					$late_by_hours = 0;
					$late_deduct = 0;
				} else {
					$on_duty3 = date("Y-m-d H:i:00", strtotime($late_allowed[$in_time] . '+' . $late_allowed['late_allowed_till'] . "mins"));
					if ($holiday_check !== "yes") {
						$attendence_check = $this->Employees_model->check_first_attendance($user[0]->user_id, $attendance_date);
						$work_clkin = new DateTime($clockin);
						$work_on_duty = new DateTime($on_duty3);
						$clkin_diff = strtotime($clockin) - strtotime($on_duty3);
						$interval_clkin = $work_clkin->diff($work_on_duty);
						$hoursin = $interval_clkin->format('%h');
						$minutesin = $interval_clkin->format('%i');
						$minutes_to_hour = round($minutesin / 60, 2);
						$late_by_hours = $hoursin + $minutes_to_hour;

						if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {
							$basic_sal = $user[0]->basic_salary;
							$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
							$late_deduct = round($latededuction, 3);
						} else {
							$late_by_hours = 0;
							$late_deduct = 0;
						}
					} else {
						$late_by_hours = 0;
						$late_deduct = 0;
					}

					unset($weekends);
					unset($holiday_check);
				}

			} else {

				// Find week day
				$week_day = date('l', strtotime($attendance_date));
				$week_day_lower = strtolower($week_day);

				// Make Table field. Eg: thursday_out_time
				$table_field_in_time = $week_day_lower . '_in_time';
				$table_field_out_time = $week_day_lower . '_out_time';

				$this->db->where('office_shift_id', $user[0]->office_shift_id);
				$office_shift = $this->db->get('xin_office_shift')->row();

				$shift_start = $office_shift->$table_field_in_time;
				$shift_end = $office_shift->$table_field_out_time;
				if (empty($shift_start)) {
					$weekends = "yes";
				}


				if ($weekends !== "yes" && $holiday_check !== "yes") {
					$attendence_check = $this->Employees_model->check_first_attendance($user[0]->user_id, $attendance_date);
					$work_clkin = new DateTime($clockin);
					$work_on_duty = new DateTime($on_duty3);
					$clkin_diff = strtotime($clockin) - strtotime($on_duty3);
					$interval_clkin = $work_clkin->diff($work_on_duty);
					$hoursin = $interval_clkin->format('%h');
					$minutesin = $interval_clkin->format('%i');
					$minutes_to_hour = round($minutesin / 60, 2);
					$late_by_hours = $hoursin + $minutes_to_hour;

					if ($late_by_hours > 0 && $attendence_check == 0 && $clkin_diff > 0) {
						$basic_sal = $user[0]->basic_salary;
						$latededuction = (($basic_sal / 30) / 8) * $late_by_hours;
						$late_deduct = round($latededuction, 3);
					} else {
						$late_by_hours = 0;
						$late_deduct = 0;
					}
				} else {
					$late_by_hours = 0;
					$late_deduct = 0;
				}

				unset($weekends);
				unset($holiday_check);

			}
			$data = array(
				'employee_id' => $user_id,
				'entered_type' => 2,
				'clock_out_entered_id' => $biometric_id,
				'clock_out' => $clock_out,
				'clock_out_time' => date('H:i', strtotime($clock_out)),
				'clock_out_ip_address' => $terminal_id,
				'clock_out_latitude' => '',
				'clock_out_longitude' => '',
				'clock_in_out' => '0',
				'early_leaving' => $clock_out,
				'overtime' => $clock_out,
				'total_work' => $total_work,
				'ot' => $ot,
				'normal_ot_hours' => $normalot_hours,
				'extra_ot_hours' => $extraot_hours,
				'ot_amount' => $roundamount,
				'total_work_hours' => $work_by_hours,
				'late_by_hours' => $late_by_hours,
				'late_deduction' => $late_deduct,
			);
			$id = $time_attendance_id;
			$attend_details = $this->Timesheet_model->get_attendance_details($id);
			$resuslt2 = $this->Timesheet_model->update_attendance_clockedout($data, $id);

			if ($resuslt2 == TRUE) {
				# NEW: Update totals
				$this->db->where('employee_id', $user_id);
				$this->db->where('date', date('Y-m-d', strtotime($attend_details[0]->attendance_date)));
				$attendance_time_total = $this->db->get('xin_attendance_time_total');
				if ($attendance_time_total->num_rows() > 0) {
					foreach ($attendance_time_total->result() as $time_total) {
						$early_leaving_time = $this->Misc_model->find_early_leaving1($clock_out, $time_total->employee_id);
						$overtime_time = $this->Misc_model->find_overtime1($attend_details[0]->attendance_date, $time_total->employee_id);
						// $rest = gmdate("H:i", $time_total->rest_seconds);
						$rest = $this->Misc_model->find_rest($attend_details[0]->attendance_date, $attend_details[0]->employee_id);
						$work = $this->Misc_model->find_work_total($attend_details[0]->attendance_date, $attend_details[0]->employee_id);
						$user = $this->Employees_model->read_employee_information($attend_details[0]->employee_id);
						$attendance_date = $attend_details[0]->attendance_date;

						//overtime calculations start

						$overtime_consts = $this->Xin_model->get_all_overtime_constants();
						$timeshift_from = $overtime_consts[0]->timeshift_from;
						$timeshift_to = $overtime_consts[0]->timeshift_to;
						$evening_timeshift_from = $overtime_consts[0]->evening_timeshift_from;
						$evening_timeshift_to = $overtime_consts[0]->evening_timeshift_to;
						//global $weekend;


						$normal_ot_secs = 0;
						$extra_ot_secs = 0;

						if ($user[0]->office_shift_id == 0) {
							$month = date('Y-m', strtotime($attendance_date));
							$office_shift = $this->Office_shift_custom_model->employee_current_shift($user_id, $month);
							$day = date('j', strtotime($attendance_date));
							$out_time = $day . '_out';
							$shift_end_time = strtotime($office_shift[$out_time]);
							$shift_out_time_seconds = $shift_end_time;
							$normal_ot_end_secs = strtotime($attendance_date . ' 19:00:00');
							$extra_ot_secs = 0;
							$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
							$extra_ot_end_secs = strtotime($attendance_date1 . ' 07:00:00');
							$normal_ot_end_secs_last = strtotime($attendance_date1 . ' 08:00:00');

							$this->db->where('employee_id', $user_id);
							$this->db->where('attendance_date', $attendance_date);
							$attendances = $this->db->get('xin_attendance_time');

							$overtime_seconds = 0;
							if ($attendances->num_rows() > 0) {
								foreach ($attendances->result() as $attendance) {
									$clock_in_seconds = strtotime($attendance->clock_in);
									$clock_out_seconds = strtotime($attendance->clock_out);
									if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
										$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;
										for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
											if ($i < $normal_ot_end_secs) {
												$normal_ot_secs += 1;
											} else if ($i < $extra_ot_end_secs) {
												$extra_ot_secs += 1;
											} else if ($i < $normal_ot_end_secs_last) {
												$normal_ot_secs += 1;
											}
										}
									} else if ($clock_in_seconds > $shift_out_time_seconds) {
										$overtime_seconds += $clock_out_seconds - $clock_in_seconds;
										for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
											if ($i < $normal_ot_end_secs) {
												$normal_ot_secs += 1;
											} else if ($i < $extra_ot_end_secs) {
												$extra_ot_secs += 1;
											} else if ($i < $normal_ot_end_secs_last) {
												$normal_ot_secs += 1;
											}
										}
									}
								}
							}

							// Deduct late time
							$late_hours = $this->Misc_model->find_late1($attendance_date, $user_id);
							$late_seconds = $this->Misc_model->hm2sec($late_hours);
							$normal_ot_secs -= $late_seconds;
							if ($normal_ot_secs < 0) {
								$extra_ot_secs -= abs($normal_ot_secs);
								if ($extra_ot_secs < 0)
									$extra_ot_secs = 0;
								$normal_ot_secs = 0;
							}
						} else {
							// Find week day
							$week_day = date('l', strtotime($attendance_date));
							$week_day_lower = strtolower($week_day);

							// Make Table field. Eg: thursday_out_time
							$table_field_in_time = $week_day_lower . '_in_time';
							$table_field_out_time = $week_day_lower . '_out_time';

							$this->db->where('office_shift_id', $user[0]->office_shift_id);
							$office_shift = $this->db->get('xin_office_shift')->row();

							$shift_start = $office_shift->$table_field_in_time;
							$shift_end = $office_shift->$table_field_out_time;
							if (empty($shift_start)) {
								$weekend = "yes";
							}

							$shift_start_secs = $this->Misc_model->hm2sec($shift_start);
							$shift_end_secs = $this->Misc_model->hm2sec($shift_end);
							$normal_ot_secs = $extra_ot_secs = 0;
							if ($shift_end_secs < $shift_start_secs) {
								// Night shift ends next day
								$shift_end_date = date('Y-m-d', strtotime($attendance_date . " +1 days"));
								$shift_end = "$shift_end_date $shift_end";
								$shift_end_time = strtotime($shift_end);
								$shift_out_time_seconds = $shift_end_time;

								$normal_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_from);
								$extra_ot_end_secs = strtotime($shift_end_date . ' ' . $timeshift_to);
								$extra_ot_end_secs_last = strtotime($shift_end_date . ' ' . $shift_start);

								$this->db->where('employee_id', $user[0]->user_id);
								$this->db->where('attendance_date', $attendance_date);
								$attendances = $this->db->get('xin_attendance_time');

								if ($attendances->num_rows() > 0) {
									foreach ($attendances->result() as $attendance) {
										$clock_in_seconds = strtotime($attendance->clock_in);
										$clock_out_seconds = strtotime($attendance->clock_out);
										if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
											for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
												if ($i < $extra_ot_end_secs) {
													$extra_ot_secs += 1;
												} else if ($i < $normal_ot_end_secs) {
													$normal_ot_secs += 1;
												} else if ($i < $extra_ot_end_secs_last) {
													$extra_ot_secs += 1;
												}
											}
										} else if ($clock_in_seconds > $shift_out_time_seconds) {
											for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
												if ($i < $extra_ot_end_secs) {
													$extra_ot_secs += 1;
												} else if ($i < $normal_ot_end_secs) {
													$normal_ot_secs += 1;
												} else if ($i < $extra_ot_end_secs_last) {
													$extra_ot_secs += 1;
												}
											}
										}
									}
								}

								// Deduct late time
								$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
								$late_seconds = $this->Misc_model->hm2sec($late_hours);
								$extra_ot_secs -= $late_seconds;
								if ($extra_ot_secs < 0) {
									$normal_ot_secs -= abs($extra_ot_secs);
									if ($normal_ot_secs < 0)
										$normal_ot_secs = 0;

									$extra_ot_secs = 0;
								}
							} else {

								$shift_end = "$attendance_date $shift_end";
								$shift_end_time = strtotime($shift_end);
								$shift_out_time_seconds = $shift_end_time;
								$normal_ot_end_secs = strtotime($attendance_date . ' ' . $timeshift_from);
								$extra_ot_secs = 0;
								$attendance_date1 = date('Y-m-d', strtotime($attendance_date . " +1 days"));
								$extra_ot_end_secs = strtotime($attendance_date1 . ' ' . $timeshift_to);
								$normal_ot_end_secs_last = strtotime($attendance_date1 . ' ' . $shift_start);

								$this->db->where('employee_id', $user[0]->user_id);
								$this->db->where('attendance_date', $attendance_date);
								$attendances = $this->db->get('xin_attendance_time');

								$overtime_seconds = 0;
								if ($attendances->num_rows() > 0) {
									foreach ($attendances->result() as $attendance) {
										$clock_in_seconds = strtotime($attendance->clock_in);
										$clock_out_seconds = strtotime($attendance->clock_out);

										if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds)) {
											$overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;
											for ($i = $shift_out_time_seconds; $i <= $clock_out_seconds; $i++) {
												if ($i < $normal_ot_end_secs) {
													$normal_ot_secs += 1;
												} else if ($i < $extra_ot_end_secs) {
													$extra_ot_secs += 1;
												} else if ($i < $normal_ot_end_secs_last) {
													$normal_ot_secs += 1;
												}
											}
										} else if ($clock_in_seconds > $shift_out_time_seconds) {
											$overtime_seconds += $clock_out_seconds - $clock_in_seconds;
											for ($i = $clock_in_seconds; $i <= $clock_out_seconds; $i++) {
												if ($i < $normal_ot_end_secs) {
													$normal_ot_secs += 1;
												} else if ($i < $extra_ot_end_secs) {
													$extra_ot_secs += 1;
												} else if ($i < $normal_ot_end_secs_last) {
													$normal_ot_secs += 1;
												}
											}
										}
									}
								}

								// Deduct late time
								$late_hours = $this->Misc_model->find_late1($attendance_date, $user[0]->user_id);
								$late_seconds = $this->Misc_model->hm2sec($late_hours);
								//$overtime_seconds -= $late_seconds;
								$normal_ot_secs -= $late_seconds;

								if ($normal_ot_secs < 0) {
									$extra_ot_secs -= abs($normal_ot_secs);
									if ($extra_ot_secs < 0)
										$extra_ot_secs = 0;
									$normal_ot_secs = 0;
								}
							}
						}
						//overtime calculations end

						// if Holiday, overtime will be total-work
						$day_status_employee = $this->Misc_model->day_status_employee($attend_details[0]->attendance_date, $time_total->employee_id);
						if (in_array($day_status_employee, array('H', 'PH'))) {
							$overtime_time = $work;
							$extra_ot_secs = $this->Misc_model->hm2sec($overtime_time);
							$normal_ot_secs = 0;
							$late = $early_leaving_time = '00:00';
						}
						$ot_seconds = $this->Misc_model->hm2sec($overtime_time);

						$this->db->where('id', $time_total->id);
						$this->db->update('xin_attendance_time_total', array(
							'late' => $late,
							'early_leaving' => $early_leaving_time,
							'rest' => $rest,
							'overtime' => $overtime_time,
							'work' => $work,
							'ot_seconds' => $ot_seconds,
							'normal_ot_seconds' => $normal_ot_secs,
							'extra_ot_seconds' => $extra_ot_secs
						));
					}
				}
				#-----------------#
			}
		}
	}


}
