<?php
 /**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the HRSALE License
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.hrsale.com/license.txt
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to hrsalesoft@gmail.com so we can send you a copy immediately.
 *
 * @author   HRSALE
 * @author-email  hrsalesoft@gmail.com
 * @copyright  Copyright © hrsale.com. All Rights Reserved
 */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Uniform extends MY_Controller
{

   /*Function to set JSON output*/
	public function output($Return=array()){
		/*Set response header*/
		header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		/*Final JSON response*/
		exit(json_encode($Return));
	}
	
	public function __construct()
     {
          parent::__construct();
          //load the models
          $this->load->model('Xin_model');
		  $this->load->model('Employees_model');
		  $this->load->model('Department_model');
		  $this->load->model('Assets_model');
		  $this->load->model('Custom_fields_model');
		  $this->load->model('Uniform_model');
    }
    
    public function index()
    {
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		
		redirect('admin/uniform/categories');
		
		/*$data['title'] = 'Uniform'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Uniform';
		$data['path_url'] = 'uniform_category';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('10009',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/uniform_category_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}*/
	}
    
    public function categories()
    {
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		
		$data['title'] = 'Uniform'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Uniform';
		$data['path_url'] = 'uniform_category';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('10009',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/new/categories", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function add()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		
		$data['title'] = 'Add Uniform'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Add Uniform';
		$data['path_url'] = 'uniform';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('25',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/new/add", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function return()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		
		$data['title'] = 'Uniform Return'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Uniform Return';
		$data['path_url'] = 'uniform_return';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('25',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/new/return", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function list_assigned($employee_id, $category_id = 0)
	{
	    // Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$this->db->where('uniform_employee_id', $employee_id);
		if ($category_id > 0)
		    $this->db->where('uniform_cat_id', $category_id);
		$this->db->order_by('uniform_id', 'asc');
		$uniforms = $this->db->get('uniform_employee');
		
		$data = array();
		$cat_names = array();
		
		foreach ($uniforms->result() as $item)
		{
		    if (! in_array($item->uniform_cat_id, $cat_names))
		    {
		        $this->db->where('uniform_category_id', $item->uniform_cat_id);
		        $cat = $this->db->get('uniform_category')->row();
		        $cat_names[$item->uniform_cat_id] = $cat->uniform_category_name;
		    }
		    
		    $returned = 0;
		    $last_return_date = '--';
		    
		    $query = $this->db->query('SELECT SUM(quantity) AS returned, date FROM uniform_return WHERE uniform_employee_id = '.$item->uniform_id);
		    $return = $query->row();
		    if ($return)
		    {
		        $returned = $return->returned;
		        $last_return_date = $return->date;
		    }
		    
		    if ($returned >= $item->quentity)
		        continue;
		    
		    $data[] = array(
		        $item->date_of_issue,
		        $cat_names[$item->uniform_cat_id],
		        $item->size,
		        $item->quentity,
		        (int) $returned,
		        $last_return_date,
		        '<button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#modals-slide" data-field_id="'.$item->uniform_id.'" data-type="add-return">Return</button>',
		    );
		}
		
		$output = array(
            "draw" => $draw,
            "recordsTotal" => $uniforms->num_rows(),
            "recordsFiltered" => $uniforms->num_rows(),
            "data" => $data
        );
        echo json_encode($output);
        exit();
	}
	
	public function return_add()
	{
	    $data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('uniform_id');
		
		// $result = $this->Uniform_model->read_uniform_return_info($id);
		$this->db->where('uniform_id', $id);
		$result = $this->db->get('uniform_employee')->row();
		
		$returned = 0;
	    $last_return_date = '--';
	    $balance = $result->quentity;
	    
	    $query = $this->db->query('SELECT SUM(quantity) AS returned, date FROM uniform_return WHERE uniform_employee_id = '.$result->uniform_id);
	    $return = $query->row();
	    if ($return)
	    {
	        $returned = $return->returned;
	        $last_return_date = $return->date;
	        $balance -= $returned;
	    }
        
		$data = array(
			'uniform_id' => $result->uniform_id,
			'new_description' => $result->new_description,
			'return_date' => $result->return_date,
			'status' => $result->status,
			'uniform_cat_id' => $result->uniform_cat_id,
			'company_id' => $result->uniform_company_id,
			'employee_id' => $result->uniform_employee_id,
			'quentity' => $result->quentity,
			'size' => $result->size,
			'date_of_issue' => $result->date_of_issue,
			'description' => $result->description,
			'created_at' => $result->created_at,
			'all_employees' => $this->Xin_model->all_employees(),
			'get_all_uniform_categories' => $this->Uniform_model->get_all_uniform_categories(),
			'all_companies' => $this->Xin_model->get_companies(),
			'returned' => $returned,
			'last_return_date' => $last_return_date,
			'balance' => $balance,
		);
		
		$this->load->view('admin/uniform/new/return_add', $data);
	}
	
	public function return_add_post()
	{
	    $Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		$uniform_employee_id = $this->input->post('uniform_id');
		$return_quantity = (int) $this->input->post('return_quantity');
		$return_reason = $this->input->post('return_reason');
		
		$this->db->insert('uniform_return', array(
		    'uniform_employee_id' => $uniform_employee_id,
		    'quantity' => $return_quantity,
		    'reason' => $return_reason,
		    'date' => date('Y-m-d'),
		));
		
		$Return['result'] = 'Uniform return saved.';
		
		$this->output($Return);
	}
	
	public function return_list()
	{
	    $session = $this->session->userdata('username');
	    
		$data['title'] = $this->Xin_model->site_title();
		
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		
		if($user_info[0]->user_role_id==1){
            // $uniform = $this->Uniform_model->get_uniform_return();
			$sql = "SELECT * FROM `uniform_return` AS ur, `uniform_employee` AS ue WHERE
			        ur.uniform_employee_id = ue.uniform_id";
			$uniforms = $this->db->query($sql);
		} else {
			if(in_array('265',$role_resources_ids)) {
				// $uniform = $this->Uniform_model->get_company_uniform($user_info[0]->company_id);
				$sql = "SELECT * FROM `uniform_return` AS ur, `uniform_employee` AS ue WHERE
				        ur.uniform_employee_id = ue.uniform_id AND ue.uniform_company_id = ".$user_info[0]->company_id;
				$uniforms = $this->db->query($sql);
			} else {
				// $uniform = $this->Uniform_model->get_employee_uniform($session['user_id']);
				$sql = "SELECT * FROM `uniform_return` AS ur, `uniform_employee` AS ue WHERE
				        ur.uniform_employee_id = ue.uniform_id AND ue.uniform_employee_id = ".$session['user_id'];
				$uniforms = $this->db->query($sql);
			}
		}
		
		$data = array();
		
        foreach($uniforms->result() as $r)
        {
            // get company
			$company = $this->Xin_model->read_company_info($r->uniform_company_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
			 	$comp_name = '--';	
			}
			
			// get category
			$uniform_category = $this->Uniform_model->read_uniform_cat_info($r->uniform_cat_id);
			if(!is_null($uniform_category)){
				$category = $uniform_category[0]->uniform_category_name;
			} else {
			 	$category = '--';	
			}
		
			// get user > added by
			$user = $this->Xin_model->read_user_info($r->uniform_employee_id);
			// user full name
			if(!is_null($user)){
				$full_name = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;
			} else {
				$full_name = '--';	
			}

			if(in_array('264',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if(in_array('265',$role_resources_ids)) { //view
				$view = '';// '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-field_id="'. $r->id . '" data-type="emp-info"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}

			$combhr = $view.$delete;

			$data[] = array(
			    $combhr,
			    '<strong>'.$full_name.'</strong><br><small>'.$comp_name.'</small>',
				$category,
				$r->size,
				$r->quantity,
				$r->reason,
				$r->date,
			);
		}
		
		$output = array(
		    "draw" => $draw,
		    "recordsTotal" => $uniforms->num_rows(),
		    "recordsFiltered" => $uniforms->num_rows(),
		    "data" => $data
		);
		echo json_encode($output);
		exit();
	}
	
	public function delete_clame($id)
	{
	    $Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
		
		// $result = $this->Uniform_model->delete_uniform_return($id);
		$this->db->where('id', $id);
		$this->db->delete('uniform_return');
		
		$Return['result'] = "Deleted ...";

		$this->output($Return);
	}
	
	public function uniform_category_list()
    {
        $session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/languages/languages_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		
		$uniform_category = $this->Uniform_model->get_uniform_categories();
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data = array();
		
          foreach($uniform_category->result() as $r) {						
		  			
			if(in_array('267',$role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->uniform_category_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			if(in_array('268',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->uniform_category_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			
			$combhr = $edit.$delete;
									 			  				
			$data[] = array($combhr,
				$r->uniform_category_name
			);
		}
          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $uniform_category->num_rows(),
                 "recordsFiltered" => $uniform_category->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
     	public function add_category() {
     	   
	
		if($this->input->post('add_type')=='add_category') {
		   //  echo"jj";exit;
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */		
		if($this->input->post('name')==='') {
        	$Return['error'] = $this->lang->line('xin_error_cat_name_field');
		}
						
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		// set data
		$data = array(
		'uniform_category_name' => $this->input->post('name'),
		
		);
		
		$result = $this->Uniform_model->add_uniform_category($data);
		if ($result == TRUE) {
			$Return['result'] = "Suceesfully added uniform category";
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	public function read_uniform_category() {
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('uniform_category_id');
		$result = $this->Uniform_model->read_uniform_category_info($id);
		$data = array(
				'uniform_category_id' => $result[0]->uniform_category_id,
				'uniform_category_name' => $result[0]->uniform_category_name,
				);
		if(!empty($session)){ 
			$this->load->view('admin/uniform/dialog_category', $data);
		} else {
			redirect('admin/');
		}
	}
	public function update_uniform_category() {
	
		if($this->input->post('edit_type')=='uniform_category') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		/* Server side PHP input validation */		
		if($this->input->post('name')==='') {
        	$Return['error'] = $this->lang->line('xin_error_cat_name_field');
		}
						
		if($Return['error']!=''){
       		$this->output($Return);
    	}
		
		// set data
		$data = array(
		'uniform_category_name' => $this->input->post('name')
		);
		
		$result = $this->Uniform_model->update_uniform_category_record($data,$id);
		if ($result == TRUE) {
			$Return['result'] = "Updated Success...";
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
	public function delete_uniform_category() {
		
		if($this->input->post('type')=='delete_record') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Uniform_model->delete_uniform_category_record($id);
			if(isset($id)) {
				$Return['result'] = "Deleted ...";
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	 public function get_employees() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'company_id' => $id
			);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/uniform/get_employees", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	  public function get_cat() {

		$data['title'] = $this->Xin_model->site_title();
		$id = $this->uri->segment(4);
		
		$data = array(
			'employee_id' => $id
			);//print_r($data);
		$session = $this->session->userdata('username');
		if(!empty($session)){ 
			$this->load->view("admin/uniform/get_cat", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
	 }
	
	public function uniform_add() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = 'Add Uniform'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Add Uniform';
		$data['path_url'] = 'uniform';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('25',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/uniform_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function uniform_list()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/languages/languages_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id==1){
			$uniform = $this->Uniform_model->get_uniform();
		} else {
			if(in_array('265',$role_resources_ids)) {
				$uniform = $this->Uniform_model->get_company_uniform($user_info[0]->company_id);
			} else {
				$uniform = $this->Uniform_model->get_employee_uniform($session['user_id']);
			}
		}
		$data = array();
		
          foreach($uniform->result() as $r) {						
			// get company
			$company = $this->Xin_model->read_company_info($r->uniform_company_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
			 	$comp_name = '--';	
			}
			// get category
			$uniform_category = $this->Uniform_model->read_uniform_cat_info($r->uniform_cat_id);
			if(!is_null($uniform_category)){
				$category = $uniform_category[0]->uniform_category_name;
			} else {
			 	$category = '--';	
			}
		
			// get user > added by
			$user = $this->Xin_model->read_user_info($r->uniform_employee_id);
			// user full name
			if(!is_null($user)){
				$full_name = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;
			} else {
				$full_name = '--';	
			}
			
			if(in_array('263',$role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Edit/Add"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->uniform_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			$p='<span data-toggle="tooltip" data-state="primary" data-placement="top" title="" data-original-title="Edit">
   				<a href="'.base_url('admin/uniform/edit/' . $r->uniform_id).'" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light">
   					<span class="far fa-edit"></span>
   				</a>';
			if(in_array('264',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->uniform_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if(in_array('265',$role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-field_id="'. $r->uniform_id . '"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}
			$combhr = $edit.$view.$delete;
			$created_at = $this->Xin_model->set_date_format($r->created_at);
			$iname = $category.'<br><small class="text-muted"><i>'.$this->lang->line('xin_created_at').': '.$created_at.'<i></i></i></small>';
			$count_quantity=$this->Uniform_model->count_quantity($r->uniform_employee_id,$r->uniform_cat_id);//print_r($count_quantity);
			$data[] = array($combhr,
				$iname,
				$count_quantity[0]->total,
				// $r->size,
				$r->date_of_issue,
				$full_name,
				$comp_name
			);
		}
          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $uniform->num_rows(),
                 "recordsFiltered" => $uniform->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
	public function add_uniform() {
	
		if($this->input->post('add_type')=='add_uniform') {		
    		/* Define return | here result is used to return user data and error for error message */
    		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
    		$Return['csrf_hash'] = $this->security->get_csrf_hash();
    			
    		/* Server side PHP input validation */		
    		if($this->input->post('category_id')==='') {
            	$Return['error'] = $this->lang->line('xin_error_category_field');
    		}  else if($this->input->post('company_id')==='') {
            	$Return['error'] = $this->lang->line('error_company_field');
    		} else if($this->input->post('employee_id')==='') {
            	$Return['error'] = $this->lang->line('xin_error_employee_id');
    		}  else if($this->input->post('quentity')==='') {
            	$Return['error'] = 'Enter Quentity';
    		}   else if($this->input->post('size')==='') {
            	$Return['error'] = 'Enter Size';
    		}   else if($this->input->post('issue_date')==='') {
            	$Return['error'] = 'Enter Issue Date';
    		}  else if($this->input->post('asset_note')==='') {
            	$Return['error'] = 'Enter Description';
    		} 
    				
    		if($Return['error']!=''){
           		$this->output($Return);
        	}
        	
    		// set data
    		$data = array(
        		'uniform_cat_id' => $this->input->post('category_id'),
        		'uniform_company_id' => $this->input->post('company_id'),
        		'uniform_employee_id' => $this->input->post('employee_id'),
        		'quentity' => $this->input->post('quentity'),
        		'size' => $this->input->post('size'),
        		'date_of_issue' => $this->input->post('issue_date'),
        		'description' => $this->input->post('asset_note'),
        		'created_at' => date('d-m-Y h:i:s')
    		);
    		
    		$iresult = $this->Uniform_model->add_uniform($data);
    		
    		if ($iresult) {
    			$Return['result'] = "Added Success";
    		} else {
    			$Return['error'] = $this->lang->line('xin_error_msg');
    		}
    		
    		$this->output($Return);
    		exit;
		}
	}
	
	public function uniform_read()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$data['path_url'] = 'uniform';
		$id = $this->input->get('uniform_id');
		$result = $this->Uniform_model->read_uniform_info($id);
		$data = array(
				'uniform_id' => $result[0]->uniform_id,
				'uniform_cat_id' => $result[0]->uniform_cat_id,
				'company_id' => $result[0]->uniform_company_id,
				'employee_id' => $result[0]->uniform_employee_id,
				'quentity' => $result[0]->quentity,
				'size' => $result[0]->size,
				'date_of_issue' => $result[0]->date_of_issue,
				'description' => $result[0]->description,
				'created_at' => $result[0]->created_at,
				'all_employees' => $this->Xin_model->all_employees(),
				'get_all_uniform_categories' => $this->Uniform_model->get_all_uniform_categories(),
				'all_companies' => $this->Xin_model->get_companies()
				);
		if(!empty($session)){ 
			$this->load->view('admin/uniform/dialog_uniform', $data);
		} else {
			redirect('admin/');
		}
	}
	public function update_uniform() {
	
		if($this->input->post('edit_type')=='update_uniform') {		
		/* Define return | here result is used to return user data and error for error message */
		$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');		
		$id = $this->uri->segment(4);
		$Return['csrf_hash'] = $this->security->get_csrf_hash();
			
		if($this->input->post('category_id')==='') {
        	$Return['error'] = $this->lang->line('xin_error_category_field');
		}  else if($this->input->post('company_id')==='') {
        	$Return['error'] = $this->lang->line('error_company_field');
		} else if($this->input->post('employee_id')==='') {
        	$Return['error'] = $this->lang->line('xin_error_employee_id');
		}  else if($this->input->post('quentity')==='') {
        	$Return['error'] = 'Enter Quentity';
		}   else if($this->input->post('size')==='') {
        	$Return['error'] = 'Enter Size';
		}   else if($this->input->post('issue_date')==='') {
        	$Return['error'] = 'Enter Issue Date';
		}  else if($this->input->post('asset_note')==='') {
        	$Return['error'] = 'Enter Description';
		} 
	$data = array(
		'uniform_cat_id' => $this->input->post('category_id'),
		'uniform_company_id' => $this->input->post('company_id'),
		'uniform_employee_id' => $this->input->post('employee_id'),
		'quentity' => $this->input->post('quentity'),
		'size' => $this->input->post('size'),
		'date_of_issue' => $this->input->post('issue_date'),
		'description' => $this->input->post('asset_note'),
		'created_at' => date('d-m-Y h:i:s')
		);
		
		$iresult = $this->Uniform_model->add_uniform($data);
		
		if ($iresult) {
			$Return['result'] = $this->lang->line('xin_success_asset_added');
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	}
		public function delete_uniform() {
		
		if($this->input->post('type')=='delete_record') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Uniform_model->delete_uniform_record($id);
			if(isset($id)) {
				$Return['result'] = 'Deleted...';
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
	
	public function uniform_returns_page() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = 'Uniform Return'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Uniform Return';
		$data['path_url'] = 'uniform_return';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('25',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/uniform_return_list", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
	
	public function uniform_return_list()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		
		/*if(!empty($session)){ 
			$this->load->view("admin/languages/languages_list", $data);
		} else {
			redirect('admin/');
		}*/
		
		$data['title'] = $this->Xin_model->site_title();
		
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id==1){
			$uniform = $this->Uniform_model->get_uniform_return();
		} else {
			if(in_array('265',$role_resources_ids)) {
				$uniform = $this->Uniform_model->get_company_uniform($user_info[0]->company_id);
			} else {
				$uniform = $this->Uniform_model->get_employee_uniform($session['user_id']);
			}
		}
		$data = array();
		
          foreach($uniform->result() as $r) {						
			// get company
			$company = $this->Xin_model->read_company_info($r->c_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
			 	$comp_name = '--';	
			}
			// get category
			$uniform_category = $this->Uniform_model->read_uniform_cat_info($r->cat_id);
			if(!is_null($uniform_category)){
				$category = $uniform_category[0]->uniform_category_name;
			} else {
			 	$category = '--';	
			}
		
			// get user > added by
			$user = $this->Xin_model->read_user_info($r->e_id);
			// user full name
			if(!is_null($user)){
				$full_name = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;
			} else {
				$full_name = '--';	
			}
			
// 			if(in_array('263',$role_resources_ids)) { //edit
// 				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Edit/Add"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->uniform_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
// 			} else {
// 				$edit = '';
// 			}
			
			if(in_array('264',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete_return" data-toggle="modal" data-target=".delete-modal" data-record-ret-id="'. $r->id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if(in_array('265',$role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-field_id="'. $r->id . '" data-type="emp-info"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}
			if($r->r_status=='return'){
			    $status='<p style="color:red"><b>Uniform Return</b></p>';
			}
			$t=$r->quentity -$r->return_q;
			$combhr = $view.$delete;
		//	$created_at = $this->Xin_model->set_date_format($r->created_at);
			$iname = $category;//.'<br><small class="text-muted"><i>'.$this->lang->line('xin_created_at').': '.$created_at.'<i></i></i></small>';
			$count_quantity=$this->Uniform_model->count_quantity($r->e_id,$r->cat_id);//print_r($count_quantity);
			$remain=$r->return_q;
			$data[] = array($combhr,
				$iname,
				$t,
			//	$r->remain,
				 $r->size,
				$r->date_of_issue,
				$r->date,
				$status,
				$full_name,
				$comp_name,
				'<button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#modals-slide" data-field_id="'. $r->id . '" data-type="add-return">Return</button>',
			);
		}
          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $uniform->num_rows(),
                 "recordsFiltered" => $uniform->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     
	}
	
	public function return_page(){
	    
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = 'Uniform Return'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Uniform Return';
		$data['path_url'] = 'return_uniform';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('25',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/uniform_return", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	
	}
	public function search_uniform_list(){
	    

		$data['title'] = $this->Xin_model->site_title();
		$session = $this->session->userdata('username');
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if(!empty($session)){ 
			$this->load->view("admin/uniform/uniform_return_new", $data);
		} else {
			redirect('admin/');
		}
			// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		$company_id =$this->input->get("company_id");
		$employee_id = $this->input->get("employee_id");
		$cat_id = $this->input->get("category_id");
		
		$employee = $this->Uniform_model->list_all_uniform_employee($company_id,$employee_id,$cat_id);
	//	print_r($employee);
		$data = array();
        $i=1;
        foreach($employee->result() as $r) {
            $uniform_category = $this->Uniform_model->read_uniform_cat_info($r->uniform_cat_id);
			if(!is_null($uniform_category)){
				$category = $uniform_category[0]->uniform_category_name;
			} else {
			 	$category = '--';	
			}
			$status=$r->r_status;
			if($status=='return'){
			    $o='<p style="color:red"><b>Completed</b></p>';
			}elseif($status=='un_return'){
			    $o='<p style="color:green"><b>Uniform Un Return</b></p>';
			}elseif($status==''){
			    $o='<p style="color:green"><b>Pending</b></p>';
			}
// 			if($r->status='return'){
// 			    $status='<p style="color:red"><b>Uniform Return</b></p>';
// 			}elseif($r->status  ='un_return'){
// 			    $status='<p style="color:green"><b>Uniform Not Return</b></p>';
// 			}
 $check_exist=$this->Uniform_model->check_exist($r->u_id);
         // print_r($check_exist);exit;
         if(!empty($check_exist)){
             	$count_q=$check_exist[0]->total;//exit;
             	$old_q=$r->quentity;
             	$new_q=$old_q-$count_q .' Remaining';
         }else{
             $new_q=$r->quentity .' Remaining';
         }
         $check_exist=$this->Uniform_model->check_exist($r->uniform_id);
         // print_r($check_exist);exit;
         if(!empty($check_exist)){
             	$count_q=$check_exist[0]->total;//exit;
             	$old_q=$r->quentity;
             	$new_q=$old_q-$count_q;
         }else{
             $new_q=$r->quentity;
         }
         $check_remain_exist=$this->Uniform_model->check_remain_exist($r->uniform_id);
         if(!empty($check_exist)){
             	$c_q=$check_remain_exist[0]->r;//exit;
             	$old_q=$r->quentity;
             	$n_q=$old_q-$c_q;
         }else{
             $n_q=$r->quentity;
         }
         if($r->check='1' && $r->r_status='return'){
             $checked="checked";
         }elseif($r->check='0'){
             $checked='';
         }else{
             $checked='';
         }
//$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_edit').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->uniform_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
$check='<input type="checkbox"  name="prod_access['.$r->uniform_id.']" value="'.$r->uniform_id.'">';
$des='<input type="text" class="form-control"  name="des_access['.$r->uniform_id.']" value="'.$r->des.'">';
$dat='<input type="date"  class="form-control" name="date_access['.$r->uniform_id.']" value="'.$r->date.'">';
$c_id='<input type="hidden"  class="form-control" name="cid_access['.$r->uniform_id.']" value="'.$r->uniform_company_id.'">';
$e_id='<input type="hidden"  class="form-control" name="eid_access['.$r->uniform_id.']" value="'.$r->uniform_employee_id.'">';
$cat_id='<input type="hidden"  class="form-control" name="catid_access['.$r->uniform_id.']" value="'.$r->uniform_cat_id.'">';

$quan='<input type="number"  class="form-control" name="quentity['.$r->uniform_id.']"  id="quentity"value="'.$new_q.'" onchange="changenew()">';
 $final='<input type="hidden" name="final['.$r->uniform_id.']" value="'.$n_q.'">';

			$desc=$r->new_description;
			$return_date=$r->return_date;
			$data[] = array($i,
			$check.$c_id.$e_id.$cat_id.$final,
			$category,
			$r->quentity,
			$r->size,
			$r->date_of_issue,
			$r->description,
			$quan,
			$des,
			$dat,
			$o,
			$new_q
			    );
			    $i++;
		}

	  $output = array(
		   "draw" => $draw,
			 "recordsTotal" => $employee->num_rows(),
			 "recordsFiltered" => $employee->num_rows(),
			 "data" => $data
		);
	  echo json_encode($output);
	  exit();
     
	}
		public function uniform_return_read()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$id = $this->input->get('uniform_id');
		$result = $this->Uniform_model->read_uniform_return_info($id);
		$data = array(
				'uniform_id' => $result[0]->uniform_id,
				'new_description' => $result[0]->new_description,
				'return_date' => $result[0]->return_date,
				'status' => $result[0]->status,
				'uniform_cat_id' => $result[0]->uniform_cat_id,
				'company_id' => $result[0]->uniform_company_id,
				'employee_id' => $result[0]->uniform_employee_id,
				'quentity' => $result[0]->quentity,
				'size' => $result[0]->size,
				'date_of_issue' => $result[0]->date_of_issue,
				'description' => $result[0]->description,
				'created_at' => $result[0]->created_at,
				'all_employees' => $this->Xin_model->all_employees(),
				'get_all_uniform_categories' => $this->Uniform_model->get_all_uniform_categories(),
				'all_companies' => $this->Xin_model->get_companies(),
				'remain'=>$result[0]->remain,
				'des'=>$result[0]->des,
				'date'=>$result[0]->date,
				'r_status'=>$result[0]->r_status,
				);
				
		if(!empty($session)){ 
			$this->load->view('admin/uniform/dialog_uniform_return', $data);
		} else {
			redirect('admin/');
		}
	}
	public function update_return_uniform(){
	    
	
		if($this->input->post('edit_type')=='update_return_uniform') {		
		/* Define return | here result is used to return user data and error for error message */
		$id = $this->uri->segment(4);
		if($this->input->post('status')=='return'){
		    $data = array(
		'new_description' => $this->input->post('new_description'),
		'return_date' => $this->input->post('return_date'),
		'status' => $this->input->post('status'),
		'reduced_quantity'=>$this->input->post('quentity')
		);
		}else{
		    $data = array(
		'new_description' => '',
		'return_date' => '',
		'status' => $this->input->post('status'),
		'reduced_quantity'=>$this->input->post('quentity')
		);
		}
		$final=$this->input->post('final');
		$q=$this->input->post('quentity');
		$r=$final-$q;
// 		$remain_exist=$this->Uniform_model->check_remain_exist($id);
// 		print_r($remain_exist);exit;
// 		if(!empty($remain_exist)){
// 		    $final=$this->input->post('final');
// 		    $r=$remain[0]->remain-$this->input->post('quentity');
// 		}else{
// 		    $final=$this->input->post('final');
// 		    $r=$final-$this->input->post('quentity');
// 		    print_r($r);exit;
// 		}
	   $data1 = array(
		'des' => $this->input->post('new_description'),
		'date' => $this->input->post('return_date'),
		'r_status' => $this->input->post('status'),
		'return_q'=>$this->input->post('quentity'),
		'c_id'=>$this->input->post('c_id'),
		'e_id'=>$this->input->post('e_id'),
		'cat_id'=>$this->input->post('cat_id'),
		'u_id'=>$this->input->post('u_id'),
		'remain'=>$r
		);

 

		$result = $this->Uniform_model->insert_uniform_return($data1);
		$iresult = $this->Uniform_model->update_uniform_return($data,$id);
		if ($iresult) {
			$Return['result'] = "Updated..";
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
		}
	
	}
	public function update_relate(){
	    $post_data = $this->input->post('prod_access');
	    $des_access=$this->input->post('des_access');
	    $dat = $this->input->post('date_access');
	    $c_id=$this->input->post('cid_access');
	    $e_id = $this->input->post('eid_access');
	    $cat_id=$this->input->post('catid_access');
	    $quentity=$this->input->post('quentity');
	    $final=$this->input->post('final');
		//$r=$final - $quentity;
	   // print_r($des_access);
	   $data = array();
       foreach($post_data as $id=>$value){
           $data[]= array(
                        'u_id' => $id,
                        'des'=>$des_access[$id],
                        'c_id'=>$c_id[$id],
                        'e_id'=>$e_id[$id],
                        'cat_id'=>$cat_id[$id],
                        'date'=>$dat[$id],
                        'return_q'=>$quentity[$id],
                        'r_status'=>'return',
                        'remain'=>$final[$id] - $quentity[$id]
                    );
                   
       }
       
    
  $iresult= $this->db->insert_batch('return_quantity', $data);
   $data_page['title'] = 'Uniform Return'.' | '.$this->Xin_model->site_title();
		$data_page['breadcrumbs'] = 'Uniform Return';
		$data_page['path_url'] = 'uniform_return';
   if ($iresult) {
			$Return['result'] = "Updated..";
			
		//	echo '<script>alert("Return Updated")</script>';
			//header('Location: '.$_SERVER['REQUEST_URI']);
		 header("Location: ../../uniform/return_page/");
			//	$this->load->view('admin/uniform/uniform_return_list',$data_page);
		} else {
			$Return['error'] = $this->lang->line('xin_error_msg');
		}
		$this->output($Return);
		exit;
 
//print_r($post_data);print_r($des_access);exit;
	}
	public function delete_uniform_return() {
		
		if($this->input->post('type')=='delete_record') {
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Uniform_model->delete_uniform_return($id);
			if(isset($id)) {
				$Return['result'] = "Deleted ...";
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
		public function delete_page() {
		
		if($this->input->post('type')=='delete_record') {
		    echo "hh";
			/* Define return | here result is used to return user data and error for error message */
			$Return = array('result'=>'', 'error'=>'', 'csrf_hash'=>'');
			$id = $this->uri->segment(4);
			$Return['csrf_hash'] = $this->security->get_csrf_hash();
			$result = $this->Uniform_model->delete_uniform($id);
			if(isset($id)) {
				$Return['result'] = "Deleted ...";
			} else {
				$Return['error'] = $this->lang->line('xin_error_msg');
			}
			$this->output($Return);
		}
	}
		public function edit() {
	
		$session = $this->session->userdata('username');
		if(empty($session)){
			redirect('admin/');
		}
		$system = $this->Xin_model->read_setting_info(1);
		if($system[0]->module_assets!='true'){
			redirect('admin/dashboard');
		}
		$data['title'] = 'Uniform Edit'.' | '.$this->Xin_model->site_title();
		$data['breadcrumbs'] = 'Uniform Edit';
		$data['path_url'] = 'uniform_edit';
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$data['all_companies'] = $this->Xin_model->get_companies();
		$data['all_employees'] = $this->Xin_model->all_employees();
		$data['get_all_uniform_categories'] = $this->Uniform_model->get_all_uniform_categories();
		if(in_array('25',$role_resources_ids)) {
			$id = $this->uri->segment(4);
			$edata = array(
				'is_notify' => 0,
			);
			$this->Xin_model->update_notification_record($edata,$id,$session['user_id'],'asset');
			if(!empty($session)){ 
				$data['subview'] = $this->load->view("admin/uniform/set", $data, TRUE);
				$this->load->view('admin/layout/layout_main', $data); //page load
			} else {
				redirect('admin/');
			}
		} else {
			redirect('admin/dashboard');
		}
	}
		public function set()
     {

		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		if(!empty($session)){ 
			$this->load->view("admin/languages/languages_list", $data);
		} else {
			redirect('admin/');
		}
		// Datatables Variables
		$draw = intval($this->input->get("draw"));
		$start = intval($this->input->get("start"));
		$length = intval($this->input->get("length"));
		
		$role_resources_ids = $this->Xin_model->user_role_resource();
		$user_info = $this->Xin_model->read_user_info($session['user_id']);
		if($user_info[0]->user_role_id==1){
			$uniform = $this->Uniform_model->get_uniform();
		} else {
			if(in_array('265',$role_resources_ids)) {
				$uniform = $this->Uniform_model->get_company_uniform($user_info[0]->company_id);
			} else {
				$uniform = $this->Uniform_model->get_employee_uniform($session['user_id']);
			}
		}
		$data = array();
		
          foreach($uniform->result() as $r) {						
			// get company
			$company = $this->Xin_model->read_company_info($r->uniform_company_id);
			if(!is_null($company)){
				$comp_name = $company[0]->name;
			} else {
			 	$comp_name = '--';	
			}
			// get category
			$uniform_category = $this->Uniform_model->read_uniform_cat_info($r->uniform_cat_id);
			if(!is_null($uniform_category)){
				$category = $uniform_category[0]->uniform_category_name;
			} else {
			 	$category = '--';	
			}
		
			// get user > added by
			$user = $this->Xin_model->read_user_info($r->uniform_employee_id);
			// user full name
			if(!is_null($user)){
				$full_name = $user[0]->first_name.' '.$user[0]->middle_name.' '.$user[0]->last_name;
			} else {
				$full_name = '--';	
			}
			
			if(in_array('263',$role_resources_ids)) { //edit
				$edit = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="Edit/Add"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target=".edit-modal-data" data-field_id="'. $r->uniform_id . '"><span class="fas fa-pencil-alt"></span></button></span>';
			} else {
				$edit = '';
			}
			
			if(in_array('264',$role_resources_ids)) { // delete
				$delete = '<span data-toggle="tooltip" data-placement="top" data-state="danger" title="'.$this->lang->line('xin_delete').'"><button type="button" class="btn icon-btn btn-sm btn-outline-danger waves-effect waves-light delete" data-toggle="modal" data-target=".delete-modal" data-record-id="'. $r->uniform_id . '"><span class="fas fa-trash-restore"></span></button></span>';
			} else {
				$delete = '';
			}
			if(in_array('265',$role_resources_ids)) { //view
				$view = '<span data-toggle="tooltip" data-placement="top" data-state="primary" title="'.$this->lang->line('xin_view').'"><button type="button" class="btn icon-btn btn-sm btn-outline-secondary waves-effect waves-light" data-toggle="modal" data-target="#modals-slide" data-field_id="'. $r->uniform_id . '"><span class="fa fa-eye"></span></button></span>';
			} else {
				$view = '';
			}
			$combhr = $edit.$view.$delete;
			$created_at = $this->Xin_model->set_date_format($r->created_at);
			$iname = $category.'<br><small class="text-muted"><i>'.$this->lang->line('xin_created_at').': '.$created_at.'<i></i></i></small>';
			$count_quantity=$this->Uniform_model->count_quantity($r->uniform_employee_id,$r->uniform_cat_id);//print_r($count_quantity);
			$data[] = array($combhr,
				$iname,
				$count_quantity[0]->total,
				// $r->size,
				$r->date_of_issue,
				$full_name,
				$comp_name
			);
		}
          $output = array(
               "draw" => $draw,
                 "recordsTotal" => $uniform->num_rows(),
                 "recordsFiltered" => $uniform->num_rows(),
                 "data" => $data
            );
          echo json_encode($output);
          exit();
     }
//     	public function update_table(){
// 	    $prod_q = $this->input->post('prod_q');
// 	    $prod_s=$this->input->post('prod_s');
// 	    $prod_da = $this->input->post('prod_da');
// 	    $prod_des=$this->input->post('prod_des');
// 	    $prod_e = $this->input->post('prod_e');
// 	    $prod_cat=$this->input->post('prod_cat');
// 	    $prod_com=$this->input->post('prod_com');
// 	    $prod_uid=$this->input->post('prod_uid');
// 		//$r=$final - $quentity;
// 	   // print_r($des_access);
// 	   $data = array();
//       foreach($prod_uid as $id=>$value){
//           $data[]= array(
//                         'uniform_cat_id' => $prod_cat[$id],
//                         'uniform_company_id'=>$prod_com[$id],
//                         'uniform_employee_id'=>$prod_e[$id],
//                         'quentity'=>$prod_q[$id],
//                         'size'=>$prod_s[$id],
//                         'date_of_issue'=>$prod_da[$id],
//                         'description'=>$prod_des[$id],
                       
//                     );
                   
//       }
       
//     print_r($data);exit;
//   $iresult= $this->db->insert_batch('uniform_employee', $data);
//   $data_page['title'] = 'Uniform Return'.' | '.$this->Xin_model->site_title();
// 		$data_page['breadcrumbs'] = 'Uniform Return';
// 		$data_page['path_url'] = 'uniform_return';
//   if ($iresult) {
// 			$Return['result'] = "Updated..";
			
// 		//	echo '<script>alert("Return Updated")</script>';
// 			//header('Location: '.$_SERVER['REQUEST_URI']);
// 		 header("Location: ../../uniform/uniform_add/");
// 			//	$this->load->view('admin/uniform/uniform_return_list',$data_page);
// 		} else {
// 			$Return['error'] = $this->lang->line('xin_error_msg');
// 		}
// 		$this->output($Return);
// 		exit;
 
// //print_r($post_data);print_r($des_access);exit;
// 	}
		public function delete()
	{
		$session = $this->session->userdata('username');
		if(empty($session)){ 
			redirect('admin/');
		}
		$data['title'] = $this->Xin_model->site_title();
		$data['path_url'] = 'uniform';
		$id = $this->input->get('id');
	$delete=$this->Uniform_model->delete_uniform_record($id);
//	print_r($delete);exit;
	$Return['result'] = $this->lang->line('xin_success_asset_added');
		header("Location: ../../uniform/uniform_add/");
	}
}
?>