<?php

class Advance extends CI_Model
{
    private $_table = 'xin_advance_salaries';
    
    public function get($filter = array())
    {
        if (isset($filter['employee_id']) && $filter['employee_id'] > 0)
            $this->db->where('employee_id', $filter['employee_id']);
        
        if (isset($filter['status']))
            $this->db->where('status', (int) $filter['status']);
        
        return $this->db->get($this->_table);
    }
    
    public function getMonthlyDeductions($advance_id = 0)
    {
        $this->db->where('advance_salary_id', $advance_id);
        return $deductions = $this->db->get('xin_salary_payslip_advance_amounts');
    }
    
    public function getOutstandingAmount($employee_id = 0)
    {
        $outstanding_amount = 0;
        
        $advances = $this->get(array(
            'employee_id' => $employee_id,
            'status' => 1
        ));
        
        if ($advances->num_rows() > 0)
        {
            foreach ($advances->result() as $advance)
            {
                $advance_amount = $advance->advance_amount;
                
                $monthly_deductions = $this->getMonthlyDeductions($advance->advance_salary_id);
                $deduction_total = 0;
                
                foreach ($monthly_deductions->result() as $deduction)
                {
                    $deduction_total += $deduction->amount;
                }
                
                $balance = $advance_amount - $deduction_total;
                
                if ($balance > 0)
                {
                    $outstanding_amount += $balance;
                }
            }
        }
        
        return $outstanding_amount;
    }
}