<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Airticket_model extends CI_Model {
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
	public function get_tickets() {
	  return $this->db->get("xin_support_airtickets");
	}
	
	public function get_ticket_encashments() {
	  return $this->db->get("xin_airticket_encashment_requests");
	}
	 
	public function read_ticket_information($id) {
	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE ticket_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function read_employee_ticketinfo($id) {
	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE employee_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
		/*if ($query->num_rows() > 0) {
			return $query;
		} else {
			return null;
		}*/
	}
	
	public function getemp_encashmentinfo($id) {
	
		$sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE employee_id = ? AND status != ? ORDER BY encash_id DESC limit 1';
		$binds = array($id,"Cancelled");
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function getemp_payroll_status($empid,$month) {
	
		$sql = 'SELECT * FROM xin_salary_payslips WHERE employee_id = ? AND salary_month = ?';
		$binds = array($empid,$month);
		$query = $this->db->query($sql, $binds);
		return $query->num_rows();
	}
	
	public function getemp_ticket_requestcheck($empid,$ticket_date)
    {
        $sql = "SELECT * FROM xin_support_airtickets WHERE employee_id=? and end_date=? and ticket_status = 1";
        $binds = array($empid,$ticket_date);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
	
	public function emp_tickets_taken($employee_id, $starting_date, $ending_date)
    {
        $sql = "SELECT * FROM xin_support_airtickets WHERE employee_id=? and (duration_from  = '$starting_date' and duration_to = '$ending_date') ";
        $binds = array($employee_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
        /*if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }*/
    }
	
	public function read_ticket_encashment_information($id) {
	
		$sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE encash_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	 public function company($id) {
	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE company_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	 public function airticket($id) {
	
		$sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		//print_r($query);exit;
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function getemp_duration($id) {
	
		$sql = 'SELECT * FROM xin_airtickets WHERE employee_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function getemp_ticketdate($id) {
	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE employee_id = ? AND ticket_status = 1 ORDER BY ticket_id DESC limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function getemp_encashments($id, $status = null) {
	
		$sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE employee_id = ?';
		if ($status)
		    $sql .= ' AND status = "'.$status.'"';
		
		$sql .= ' ORDER BY encash_id DESC limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function getemp_encashedmonth($id) {
	
		$sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE employee_id = ? AND status = ? ORDER BY encash_id DESC limit 1';
		$binds = array($id,"Approved");
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function getemp_pending_encashments($id) {
	
		$sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE employee_id = ? AND status = ? ORDER BY encash_id DESC limit 1';
		$binds = array($id,"Pending");
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	// Function to add record in table
	public function add($data){
		$this->db->insert('xin_support_airtickets', $data);
		if ($this->db->affected_rows() > 0) {
			return $this->db->insert_id();
		} else {
			return false;
		}
	}
	
	// Function to add record in table
	public function add_comment($data){
		$this->db->insert('xin_airtickets_comments', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	// Function to add record in table
	public function add_new_attachment($data){
		$this->db->insert('xin_airtickets_attachment', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	// Function to Delete selected record from table
	public function delete_record($id){
		$this->db->where('ticket_id', $id);
		$this->db->delete('xin_support_airtickets');
		
	}
	
	public function delete_encashrecord($id){
		$this->db->where('encash_id', $id);
		$this->db->delete('xin_airticket_encashment_requests');
		
	}
	
	// Function to Delete selected record from table
	public function delete_comment_record($id){
		$this->db->where('comment_id', $id);
		$this->db->delete('xin_airtickets_comments');
		
	}
	
	// Function to Delete selected record from table
	public function delete_attachment_record($id){
		$this->db->where('ticket_attachment_id', $id);
		$this->db->delete('xin_airtickets_attachment');
		
	}
	
	public function add_encashment_request($data){
		$this->db->insert('xin_airticket_encashment_requests', $data);
		if ($this->db->affected_rows() > 0) {
			return $this->db->insert_id();
		} else {
			return false;
		}
	}
	
	public function get_employees_tickets($id) {
	 	
		/*$this->db->select('st.*, ste.*');
		$this->db->from('xin_support_tickets as st, xin_support_tickets_employees as ste');
		$this->db->where('st.ticket_id=ste.ticket_id');
		$this->db->where('ste.employee_id',$id. '|| st.created_by = "'.$id.'"');
		$this->db->group_by('st.ticket_id');*/
		
		$sql = 'SELECT st.*, ste.* FROM xin_support_airtickets as st, xin_support_airtickets as ste WHERE st.ticket_id=ste.ticket_id and (ste.employee_id = ? || st.created_by = ?)';
		$binds = array($id,$id);
		//$this->db->group_by("st.ticket_id");
		//$query = $this->db->get();
		$query = $this->db->query($sql,$binds);
		return $query;
	}
	public function get_employee_tickets($id) {		
		$sql = 'SELECT st.*, ste.* FROM xin_support_airtickets as st, xin_support_airtickets as ste WHERE st.ticket_id=ste.ticket_id and (ste.employee_id = ? || st.created_by = ?)';
		$binds = array($id,$id);
		//$this->db->group_by("st.ticket_id");
		//$query = $this->db->get();
		$query = $this->db->query($sql,$binds);
		return $query;
	}
	public function get_company_ticketsnew($id,$approval_stage = '',$urs_id) {
	 	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE company_id = ?';
		if ($approval_stage == 'first') {

	 		$sql .= ' AND first_approval = 0 OR approved_by_first = '.$urs_id;

	 	} else if ($approval_stage == 'last') {

	 		$sql .= ' AND first_approval = 1 AND final_approval = 0 OR approved_by_final = '.$urs_id;

	 	}
	 		$sql .= ' OR employee_id ='.$urs_id;
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}
	public function get_company_tickets($id) {
	 	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE company_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}
	// Function to update record in table
	public function update_record($data, $id){
		$this->db->where('ticket_id', $id);
		if( $this->db->update('xin_support_airtickets',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to update record in table
	public function assign_ticket_user($data, $id){
		$this->db->where('ticket_id', $id);
		if( $this->db->update('xin_support_airtickets',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to update record in table
	public function update_status($data, $id){
		$this->db->where('ticket_id', $id);
		if( $this->db->update('xin_support_airtickets',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to update record in table
	public function update_note($data, $id){
		$this->db->where('ticket_id', $id);
		if( $this->db->update('xin_support_airtickets',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// get comments
	public function get_comments($id) {
	
		$sql = 'SELECT * FROM xin_airtickets_comments WHERE ticket_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		return $query;
	}
	public function role($id) {
	
		$sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
	//	print_r($query);exit;
		return $query;
	}
	// get attachments
	public function get_attachments($id) {
	
		$sql = 'SELECT * FROM xin_airtickets_attachment WHERE ticket_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		return $query;
	}
	
	// get all ticket users
	public function read_ticket_users_information($id) {
	
		$sql = 'SELECT * FROM xin_support_airtickets WHERE ticket_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		return $query->result();
	}
	
	///
	// Function to add record in table
	public function add_ticket_employees($data){
		$this->db->insert('xin_support_tickets_employees', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	// get ticket_employees
	public function get_ticket_employees($id) {
	
		$sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}
	public function update_employee_ticket_record($id) {
	
		$this->db->where('ticket_id', $id);
		if( $this->db->update('xin_support_tickets_employees',$data)) {
			return true;
		} else {
			return false;
		}
	}
	// get single record > company | employees
	 public function ajax_department_employee_info($id) {
	
		//$sql = "SELECT * FROM xin_employees WHERE company_id = ? and user_role_id!='1' and is_logged_in='1'";
		$sql = "SELECT * FROM xin_employees WHERE department_id = ? and user_role_id!='1'";
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function approve_ticketencashment($data, $id){
		$this->db->where('encash_id', $id);
		if( $this->db->update('xin_airticket_encashment_requests',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	public function getEmpRows($params = array()){
        $this->db->select('user_id, first_name, last_name');
        $this->db->from('xin_employees');
        $this->db->where("user_id !=",1);
        //fetch data by conditions
        if(array_key_exists("conditions",$params)){
            foreach ($params['conditions'] as $key => $value) {
                if(strpos($key,'.') !== false){
                    $this->db->where($key,$value);
                }else{
                    $this->db->where('xin_employees.'.$key,$value);
                }
            }
        }
        
        $query = $this->db->get();
        $result = ($query->num_rows() > 0)?$query->result_array():FALSE;

        //return fetched data
        return $result;
    }
    
    public function get_pending_encashment_amount($user_id = 0)
    {
        $amount = $tickets_encash = 0;
        
        $this->db->where('employee_id', $user_id);
        $airticket = $this->db->get('xin_airtickets')->row();
        
        if ($airticket)
        {
            $no_of_tickets = $airticket->no_of_tickets;
            
            $employee = $this->Employees_model->read_employee_information($user_id);
            $empdate = $this->Airticket_model->getemp_ticketdate($user_id);
            $emp_encash = $this->Airticket_model->getemp_encashments($user_id, 'Approved');
            
            if($empdate && $emp_encash){
                $ticket_end = $empdate[0]->duration_to;
                $encash_end = $emp_encash[0]->to_date;
                $dates = array($ticket_end, $encash_end);
                $startdate = max($dates);
                $startdate = date('Y-m-d', strtotime($startdate. ' +1 days'));
            }elseif($empdate){
                $startdate = $empdate[0]->duration_to;
                $startdate = date('Y-m-d', strtotime($startdate. ' +1 days'));
            }else{
                if($emp_encash){
                    $startdate = $emp_encash[0]->to_date;
                    $startdate = date('Y-m-d', strtotime($startdate. ' +1 days'));
                }else{
                    $startdate = $employee[0]->date_of_joining;
                }
            }
            
            $duration = $this->Airticket_model->getemp_duration($user_id);
            
            if($duration) {
                $emp_years  = is_numeric($duration[0]->type) ? $duration[0]->type : 0;
                $emp_days   = $emp_years * 365;
            } else {
                $emp_days   = 365;
            }
            
            $years = 0;
            
            for($i = strtotime($startdate); $i< time();)
            {
                $i = $i + ($emp_days * (3600*24));
                
                if($i > time()) break;
                
                if($emp_days == 365)
                    $years += 1;
                else
                    $years += $emp_days/730;
            }
            
            $tickets_encash = $no_of_tickets * $years;
            
            $nationality = $employee[0]->nationality_id;
            
            if (is_numeric($nationality))
            {
                $this->db->where('nationality_id', $nationality);
                $airticket_encashment = $this->db->get('airticket_encashments')->row();
                
                if ($airticket_encashment)
                {
                    $encash_amount = $airticket_encashment->encash_amount;
                    $amount = $tickets_encash * $encash_amount;
                }
            }
        }
        
        return array(
            'tickets' => $tickets_encash,
            'amount' => $amount,
        );
    }
}
?>