<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Assetreport_model extends CI_Model {
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    public function assets_issued_to_employee_query($company_id,$department_id,$employee_id,$start_date,$endd_date, $location_id) {
           
           if($company_id!='')
            {
                $company_str="AND xin_employees.company_id IN($company_id)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }



            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date' $company_str $department_str $location_str $employee_str";

            $query = $this->db->query($sql);
            return $query;
           
    }
    public function employee_data_get($id) {
    
        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function asset_recevied_report_query($end_date,$aj_company,$department_id,$employee_id,$start_date, $location_id) {
           
                       if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }



            $sql = "SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' $company_str $department_str $location_str $employee_str ORDER BY xin_assets.asset_assigned_date ASC";

            $query = $this->db->query($sql);
            return $query;
            
    }
        public function employee_document_expiry_report($company_id,$department_id,$location_id,$document_id,$from_date,$to_date,$employee_id)
        {
            
            
            $doc=explode("-",$document_id);
            if($document_id!='VISA' && $document_id!='PASSPORT' && $document_id!='CPR' && $document_id!='INSURANCE' && $document_id!='LICENSE')
            {
                if($doc[0]!='contract')
                {
                    if($company_id!='')
                    {
                        $company_str='AND xin_employees.company_id IN('.$company_id.')';
                    }else{
                        $company_str='';
                    }
                    if($department_id!='')
                    {
                        $department_str='AND xin_employees.department_id IN('.$department_id.')';
                    }else{
                        $department_str='';
                    }
                    if($location_id!='')
                    {
                        $location_str='AND xin_employees.location_id IN('.$location_id.')';
                    }else{
                        $location_str='';
                    }
                    if($document_id!=0)
                    {
                        $document_str='AND xin_employee_documents.document_type_id IN('.$document_id.')';
                    }else{
                        $document_str='';
                    }
                    if($employee_id!='')
                    {
                        $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
                    }else{
                        $employee_str='';
                    }
                   //  $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."".$document_str."";
                     $sql = "SELECT xin_employee_documents.created_at as date_of_issue,xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_document_type.document_type as title, xin_employee_documents.date_of_expiry,xin_employee_documents.created_at as date_of_issue from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id LEFT JOIN xin_document_type on xin_document_type.document_type_id= xin_employee_documents.document_type_id WHERE xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."".$document_str."".$employee_str."";
                     $query = $this->db->query($sql);
                     return $query;
                }else{
                    if($company_id!='')
                    {
                        $company_str='AND xin_employees.company_id IN('.$company_id.')';
                    }else{
                        $company_str='';
                    }
                    if($department_id!='')
                    {
                        $department_str='AND xin_employees.department_id IN('.$department_id.')';
                    }else{
                        $department_str='';
                    }
                    if($location_id!='')
                    {
                        $location_str='AND xin_employees.location_id IN('.$location_id.')';
                    }else{
                        $location_str='';
                    }
                    if($employee_id!='')
                    {
                        $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
                    }else{
                        $employee_str='';
                    }
                    if(isset($doc[1]))
                    {
                        if($doc[1]!=0)
                        {
                            $document_str='AND xin_employee_contract.contract_type_id IN('.$doc[1].')';
                        }
                    }
                    else{
                        $document_str='';
                    }
                    $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_contract.title, xin_employee_contract.to_date as date_of_expiry,xin_employee_contract.created_at as date_of_issue from xin_employees JOIN xin_employee_contract on xin_employee_contract.employee_id=xin_employees.user_id WHERE xin_employee_contract.to_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str.""."".$employee_str.""."".$document_str."";
                    $query = $this->db->query($sql);
                    return $query;
                }
            }else{
                if($company_id!='')
                {
                    $company_str='AND xin_employees.company_id IN('.$company_id.')';
                }else{
                    $company_str='';
                }
                if($department_id!='')
                {
                    $department_str='AND xin_employees.department_id IN('.$department_id.')';
                }else{
                    $department_str='';
                }
                if($location_id!='')
                {
                    $location_str='AND xin_employees.location_id IN('.$location_id.')';
                }else{
                    $location_str='';
                }
                if ($document_id=='VISA' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_visa.title, xin_visa.expiry_date as date_of_expiry,xin_visa.issue_date as date_of_issue from xin_employees JOIN xin_visa on xin_visa.employee_id=xin_employees.user_id WHERE xin_visa.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql);
                    return $query;
                }
                if ($document_id=='PASSPORT' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_passport.title, xin_passport.expiry_date as date_of_expiry,xin_passport.issue_date as date_of_issue from xin_employees JOIN xin_passport on xin_passport.employee_id=xin_employees.user_id WHERE xin_passport.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql);
                    return $query;
                }
                if ($document_id=='CPR' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_cpr.title, xin_cpr.expiry_date as date_of_expiry,xin_cpr.issue_date as date_of_issue from xin_employees JOIN xin_cpr on xin_cpr.employee_id=xin_employees.user_id WHERE xin_cpr.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql);
                    return $query;
                }
                if ($document_id=='INSURANCE' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_insurance.list as title, xin_insurance.expiry_date as date_of_expiry,xin_insurance.issue_date as date_of_issue from xin_employees JOIN xin_insurance on xin_insurance.employee_id=xin_employees.user_id WHERE xin_insurance.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql);
                    return $query;
                }
                if ($document_id=='LICENSE' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_license.list as title, xin_license.expiry_date as date_of_expiry,xin_license.issue_date as date_of_issue from xin_employees JOIN xin_license on xin_license.employee_id=xin_employees.user_id WHERE xin_license.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql);
                    return $query;
                }
            }
    }
    public function assets_issued_to_employee_query_pdf($company_id,$department_id,$employee_id,$start_date,$endd_date, $location_id)  {
        
           if($company_id!='')
            {
                $company_str="AND xin_employees.company_id IN($company_id)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }



            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date' $company_str $department_str $location_str $employee_str";

            $query = $this->db->query($sql)->result_array();
            return $query;
           
    }
    public function asset_recevied_report_query_pdf($end_date,$aj_company,$department_id,$employee_id,$start_date, $location_id) {
          
            if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }



            $sql = "SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' $company_str $department_str $location_str $employee_str ORDER BY xin_assets.asset_assigned_date ASC";

            $query = $this->db->query($sql)->result_array();
            return $query;
            
    }
        public function employee_document_expiry_report_pdf($company_id,$department_id,$location_id,$document_id,$from_date,$to_date,$employee_id)
        {
            
            $doc=explode("-",$document_id);
            if($document_id!='VISA' && $document_id!='PASSPORT' && $document_id!='CPR' && $document_id!='INSURANCE' && $document_id!='LICENSE')
            {
                if($doc[0]!='contract')
                {
                    if($company_id!='')
                    {
                        $company_str='AND xin_employees.company_id IN('.$company_id.')';
                    }else{
                        $company_str='';
                    }
                    if($department_id!='')
                    {
                        $department_str='AND xin_employees.department_id IN('.$department_id.')';
                    }else{
                        $department_str='';
                    }
                    if($location_id!='')
                    {
                        $location_str='AND xin_employees.location_id IN('.$location_id.')';
                    }else{
                        $location_str='';
                    }
                    if($document_id!=0)
                    {
                        $document_str='AND xin_employee_documents.document_type_id IN('.$document_id.')';
                    }else{
                        $document_str='';
                    }
                    if($employee_id!='')
                    {
                        $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
                    }else{
                        $employee_str='';
                    }
                   //  $sql = "SELECT '' as date_of_issue,xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."".$document_str."";
                    $sql = "SELECT xin_employee_documents.created_at as date_of_issue,xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_document_type.document_type as title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id LEFT JOIN xin_document_type on xin_document_type.document_type_id= xin_employee_documents.document_type_id WHERE xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."".$document_str."".$employee_str."";
                     $query = $this->db->query($sql)->result_array();
                     return $query;
                }else{
                    if($company_id!='')
                    {
                        $company_str='AND xin_employees.company_id IN('.$company_id.')';
                    }else{
                        $company_str='';
                    }
                    if($department_id!='')
                    {
                        $department_str='AND xin_employees.department_id IN('.$department_id.')';
                    }else{
                        $department_str='';
                    }
                    if($location_id!='')
                    {
                        $location_str='AND xin_employees.location_id IN('.$location_id.')';
                    }else{
                        $location_str='';
                    }
                    if($employee_id!='')
                    {
                        $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
                    }else{
                        $employee_str='';
                    }
                    if(isset($doc[1]))
                    {
                        if($doc[1]!=0)
                        {
                            $document_str='AND xin_employee_contract.contract_type_id IN('.$doc[1].')';
                        }
                    }
                    else{
                        $document_str='';
                    }
                    $sql = "SELECT xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_contract.title, xin_employee_contract.to_date as date_of_expiry,xin_employee_contract.from_date as date_of_issue from xin_employees JOIN xin_employee_contract on xin_employee_contract.employee_id=xin_employees.user_id WHERE xin_employee_contract.to_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str.""."".$employee_str.""."".$document_str."";
                    $query = $this->db->query($sql)->result_array();
                    return $query;
                }
            }else{
                if($company_id!='')
                {
                    $company_str='AND xin_employees.company_id IN('.$company_id.')';
                }else{
                    $company_str='';
                }
                if($department_id!='')
                {
                    $department_str='AND xin_employees.department_id IN('.$department_id.')';
                }else{
                    $department_str='';
                }
                if($location_id!='')
                {
                    $location_str='AND xin_employees.location_id IN('.$location_id.')';
                }else{
                    $location_str='';
                }
                if ($document_id=='VISA' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_visa.title,xin_visa.issue_date as date_of_issue, xin_visa.expiry_date as date_of_expiry from xin_employees JOIN xin_visa on xin_visa.employee_id=xin_employees.user_id WHERE xin_visa.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql)->result_array();
                    return $query;
                }
                if ($document_id=='PASSPORT' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_passport.title,xin_passport.issue_date as date_of_issue, xin_passport.expiry_date as date_of_expiry from xin_employees JOIN xin_passport on xin_passport.employee_id=xin_employees.user_id WHERE xin_passport.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql)->result_array();
                    return $query;
                }
                if ($document_id=='CPR' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_cpr.title,xin_cpr.issue_date as date_of_issue, xin_cpr.expiry_date as date_of_expiry from xin_employees JOIN xin_cpr on xin_cpr.employee_id=xin_employees.user_id WHERE xin_cpr.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql)->result_array();
                    return $query;
                }
                if ($document_id=='INSURANCE' && $from_date!=0 && $to_date!=0) {
                    $sql = "SELECT xin_employees.user_id,xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_insurance.list as title,xin_insurance.issue_date as date_of_issue, xin_insurance.expiry_date as date_of_expiry from xin_employees JOIN xin_insurance on xin_insurance.employee_id=xin_employees.user_id WHERE xin_insurance.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql)->result_array();
                    return $query;
                }
                if ($document_id=='LICENSE' && $from_date!=0 && $to_date!=0) {
                    $sql = "xin_employees.user_id,SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_license.list as title,xin_license.issue_date as date_of_issue, xin_license.expiry_date as date_of_expiry from xin_employees JOIN xin_license on xin_license.employee_id=xin_employees.user_id WHERE xin_license.expiry_date BETWEEN '$from_date' and '$to_date' ".$company_str."".$department_str."".$location_str."";
                    $query = $this->db->query($sql)->result_array();
                    return $query;
                }
            }
    }
    public function assets_issued_to_employee_count($company_id,$department_id,$employee_id,$start_date,$endd_date, $location_id) {
        
                    if($company_id!='')
            {
                $company_str="AND xin_employees.company_id IN($company_id)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }



            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date' $company_str $department_str $location_str $employee_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
           
    }
    public function assets_received_from_employee_count($end_date,$aj_company,$department_id,$employee_id,$start_date, $location_id) {
        
           if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }



            $sql = "SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' $company_str $department_str $location_str $employee_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
           
    }
    public function get_Total_deducted_amounts($user_id)
    {
        $sql = "SELECT SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_deducted_amount from xin_salary_loan_deductions_monthwise JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_salary_loan_deductions_monthwise.employee_id WHERE xin_salary_loan_deductions.status = '1' and xin_salary_loan_deductions.employee_id = '$user_id'";

        $query = $this->db->query($sql);
       
        return $query;
        
    }
    public function employee_advance_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id)
    {
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid as total_paidd from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.start_date >='$from_date' AND xin_advance_salaries.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $sql = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid as total_paidd from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.start_date >='$from_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $data = $this->db->query($sql)->result_array();
        ///////////////////////////////one time ///////////////////////////
        
         if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        $sql1 = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid as total_paidd from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.one_time_deduct =1 AND xin_advance_salaries.created_at >='$from_date' AND xin_advance_salaries.created_at<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $data1 = $this->db->query($sql1)->result_array();
        $data=array_merge($data,$data1);
        $month_year_array=explode("-",$to_date);
        $month_year=$month_year_array[0].'-'.$month_year_array[1];
        foreach ($data as $key => $value) {
            $data[$key]['total_paid']=0;
                // var_dump($month_year);die();

            $data[$key]['list']=$this->db->select('xin_advance_deductions_monthwise.*')->where('xin_advance_deductions_monthwise.advance_id',$value['advance_salary_id'])->like('month_year',$month_year)->get('xin_advance_deductions_monthwise')->result_array();
            foreach($data[$key]['list'] as $key1 => $val1) {
                $monthly_deduct=$this->db->select('IFNULL(advance_salary_amount,0) as advance_salary_amount')->where('salary_month',$val1['month_year'])->where('employee_id',$val1['employee_id'])->get('xin_salary_payslips')->result_array();
                if(!empty($monthly_deduct))
                {
                    $data[$key]['list'][$key1]['monthly_deduct']=$monthly_deduct[0]['advance_salary_amount'];
                }else{
                    $data[$key]['list'][$key1]['monthly_deduct']=0;
                }
                $data[$key]['total_paid']+=(float)$data[$key]['list'][$key1]['monthly_deduct'];
                $data[$key]['list'][$key1]['closing_balance']=(float)$val1['amount']-(float)$data[$key]['list'][$key1]['monthly_deduct'];
            }
        }
        return $data;
    }
    public function employee_advance_loan_company_count($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id) 
    {
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.start_date >='$from_date' AND xin_advance_salaries.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
        $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.start_date >='$from_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
        $data = $this->db->query($sql)->result_array();
        
        ///////////////////////////////one time ///////////////////////////
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        $sql1 = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.one_time_deduct =1 AND xin_advance_salaries.one_time_deduct =1 AND xin_advance_salaries.created_at >='$from_date' AND xin_advance_salaries.created_at<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
        $data1 = $this->db->query($sql1)->result_array();
        $data=array_merge($data,$data1);
        return $data;
    }
    public function employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id)
    {
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_salary_loan_deductions.loan_options,xin_salary_loan_deductions.loan_deduction_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,xin_salary_loan_deductions.monthly_installment AS Total_loan_amount from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id LEFT JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.loan_id=xin_salary_loan_deductions.loan_deduction_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' AND xin_salary_loan_deductions.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
         $sql = "SELECT xin_salary_loan_deductions.loan_options,xin_salary_loan_deductions.loan_deduction_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,xin_salary_loan_deductions.monthly_installment AS Total_loan_amount from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id LEFT JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.loan_id=xin_salary_loan_deductions.loan_deduction_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_salary_loan_deductions_monthwise.loan_id";
        $data = $this->db->query($sql)->result_array();
        return $data;
        
    }
    public function employee_loan_total_deduct($loan_id,$fromdate,$to_date)
    {
        $month_year_array=explode("-",$fromdate);
        $month_year=$month_year_array[0].'-'.$month_year_array[1];
        
        $month_year_array_end=explode("-",$to_date);
        $month_year_end=$month_year_array_end[0].'-'.$month_year_array_end[1];

        $this->db->select('IFNULL(SUM(loan_amount),0) as total_deduct');
        $this->db->where('loan_id',$loan_id);
        // $this->db->like('salary_month',$month_year);
        $this->db->where('salary_month >=',$month_year);
        $this->db->where('salary_month <=',$month_year_end);
        $data=$this->db->get('xin_salary_payslip_loan')->row_array();
        return $data['total_deduct'];
    }
    public function employee_loan_company_count($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id) 
    {
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id LEFT JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.loan_id=xin_salary_loan_deductions.loan_deduction_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' AND xin_salary_loan_deductions.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id LEFT JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.loan_id=xin_salary_loan_deductions.loan_deduction_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
        $data = $this->db->query($sql)->result_array();
        return $data;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function employee_advance_details_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id)
    {
       if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.start_date >='$from_date' AND xin_advance_salaries.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $sql = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.start_date >='$from_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $data = $this->db->query($sql)->result_array();
        $month_year_array=explode("-",$to_date);
        $month_year=$month_year_array[0].'-'.$month_year_array[1];
        foreach($data as $key => $val) {
            $data[$key]['list']=$this->db->select('xin_advance_deductions_monthwise.*')->where('xin_advance_deductions_monthwise.advance_id',$val['advance_salary_id'])->get('xin_advance_deductions_monthwise')->result_array();
            foreach($data[$key]['list'] as $key1 => $val1) {
                $monthly_deduct=$this->db->select('IFNULL(advance_salary_amount,0) as advance_salary_amount')->where('salary_month',$val1['month_year'])->where('employee_id',$val1['employee_id'])->get('xin_salary_payslips')->result_array();
                if(!empty($monthly_deduct))
                {
                    $data[$key]['list'][$key1]['monthly_deduct']=$monthly_deduct[0]['advance_salary_amount'];
                }else{
                    $data[$key]['list'][$key1]['monthly_deduct']=0;
                }
                $data[$key]['list'][$key1]['closing_balance']=(float)$val1['amount']-(float)$data[$key]['list'][$key1]['monthly_deduct'];
            }
        }
        $data1=array();
        ///////////////////////////////one time ///////////////////////////
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
         if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        $sql1 = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid as total_paidd from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.one_time_deduct =1 AND xin_advance_salaries.created_at >='$from_date' AND xin_advance_salaries.created_at<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $data1 = $this->db->query($sql1)->result_array();
        foreach($data1 as $key => $val) {
            $data1[$key]['list']=$this->db->select('xin_advance_deductions_monthwise.*')->where('xin_advance_deductions_monthwise.advance_id',$val['advance_salary_id'])->get('xin_advance_deductions_monthwise')->result_array();
            foreach($data1[$key]['list'] as $key1 => $val1) {
                $monthly_deduct=$this->db->select('IFNULL(advance_salary_amount,0) as advance_salary_amount')->where('salary_month',$val1['month_year'])->where('employee_id',$val1['employee_id'])->get('xin_salary_payslips')->result_array();
               if(!empty($monthly_deduct))
                {
                    $data1[$key]['list'][$key1]['monthly_deduct']=$monthly_deduct[0]['advance_salary_amount'];
                }else{
                    $data1[$key]['list'][$key1]['monthly_deduct']=0;
                }
                $data1[$key]['list'][$key1]['closing_balance']=$val1['amount']-$data1[$key]['list'][$key1]['monthly_deduct'];
            }
        }
        $data=array_merge($data,$data1);
        return $data;
    }
    public function employee_loan_details_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id)
    {
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_salary_loan_deductions.loan_options,xin_salary_loan_deductions.loan_deduction_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,xin_salary_loan_deductions.monthly_installment AS Total_loan_amount from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id LEFT JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.loan_id=xin_salary_loan_deductions.loan_deduction_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' AND xin_salary_loan_deductions.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
         $sql = "SELECT xin_salary_loan_deductions.loan_options,xin_salary_loan_deductions.loan_deduction_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,xin_salary_loan_deductions.monthly_installment AS Total_loan_amount from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id LEFT JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.loan_id=xin_salary_loan_deductions.loan_deduction_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_salary_loan_deductions_monthwise.loan_id";
        $data = $this->db->query($sql)->result_array();
        foreach($data as $key => $val) {
            $data[$key]['list']=$this->db->select('xin_salary_loan_deductions_monthwise.*')->where('xin_salary_loan_deductions_monthwise.loan_id',$val['loan_deduction_id'])->get('xin_salary_loan_deductions_monthwise')->result_array();
            // var_dump( $data[$key]['list']);die();
            foreach($data[$key]['list'] as $key1 => $val1) {
               $monthly_deduct=$this->db->select('loan_amount')->where('loan_id',$val1['loan_id'])->where('salary_month',$val1['month_year'])->where('employee_id',$val1['employee_id'])->get('xin_salary_payslip_loan')->result_array();
            //   var_dump($monthly_deduct);die();
               if(!empty($monthly_deduct))
                {
                    $data[$key]['list'][$key1]['monthly_deduct']=$monthly_deduct[0]['loan_amount'];
                }else{
                    $data[$key]['list'][$key1]['monthly_deduct']=0;
                }
                $data[$key]['list'][$key1]['closing_balance']=(float)$val1['amount']-(float)$data[$key]['list'][$key1]['monthly_deduct'];
            }
        }
        return $data;
        
    }
    public function employee_advance_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id)
    {
       
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        
        $sql = "SELECT xin_advance_salaries.advance_salary_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.created_at,'Salary Advance' as advance_type,xin_advance_salaries.advance_amount,xin_advance_salaries.monthly_installment,xin_advance_salaries.total_paid from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id  WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.created_at >='$from_date' AND xin_advance_salaries.created_at<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $data = $this->db->query($sql)->result_array();
        foreach($data as $key => $val) {
            $month_year='';
            $details=$this->db->select('*')->where('xin_advance_deductions_monthwise.advance_id',$val['advance_salary_id'])->get('xin_advance_deductions_monthwise')->result_array();
            foreach($details as $key1 => $val1) {
                $month_year.=$val1['month_year'].' ,';
            }
            $data[$key]['list']=$details;
            $data[$key]['number_of_installment']=count($details);
            $data[$key]['month_year']=$month_year;
        }
        return $data;
    }
    public function employee_advance_loan_register_company_count($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id) 
    {
      
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id  WHERE xin_advance_salaries.final_approval = 1 AND xin_advance_salaries.created_at >='$from_date' AND xin_advance_salaries.created_at<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
        $data = $this->db->query($sql)->result_array();
        return $data;
    }
    public function employee_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id)
    {
        
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_salary_loan_deductions.loan_deduction_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.created_at,xin_salary_loan_deductions.loan_options,xin_salary_loan_deductions.monthly_installment,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.loan_time,xin_salary_loan_deductions.start_date from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' AND xin_salary_loan_deductions.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str."";
        $sql = "SELECT xin_salary_loan_deductions.loan_deduction_id,xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.created_at,xin_salary_loan_deductions.loan_options,xin_salary_loan_deductions.monthly_installment,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.loan_time,xin_salary_loan_deductions.start_date from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' ".$company_str."".$location_str."".$employee_str."".$department_str."";
        $data = $this->db->query($sql)->result_array();
        foreach($data as $key => $val) {
            $month_year='';
            $details=$this->db->select('*')->where('xin_salary_loan_deductions_monthwise.loan_id',$val['loan_deduction_id'])->get('xin_salary_loan_deductions_monthwise')->result_array();
            foreach($details as $key1 => $val1) {
                $month_year.=$val1['month_year'].' ,';
            }
            $data[$key]['list']=$details;
            $data[$key]['month_year']=$month_year;
        }
        return $data;
    }
    public function employee_loan_register_company_count($company_id, $employee_id, $location_id, $from_date, $to_date, $department_id) 
    {
      $this->db->select('xin_employees.company_id,xin_employees.user_id');
        if($company_id!='')
        {
            $company_str='AND xin_employees.company_id IN('.$company_id.')';
        }else{
            $company_str='';
        }
        if($employee_id!='')
        {
            $employee_str='AND xin_employees.user_id IN('.$employee_id.')';
        }else{
            $employee_str='';
        }
        if($location_id!='')
        {
            $location_str='AND xin_employees.location_id IN('.$location_id.')';
        }else{
            $location_str='';
        }
        if($department_id!='')
        {
            $department_str='AND xin_employees.department_id IN('.$department_id.')';
        }else{
            $department_str='';
        }
        // $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' AND xin_salary_loan_deductions.end_date<= '$to_date'".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
         $sql = "SELECT xin_employees.company_id,xin_employees.user_id from xin_employees LEFT JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.final_approval = 1 AND xin_salary_loan_deductions.start_date >='$from_date' ".$company_str."".$location_str."".$employee_str."".$department_str." GROUP BY xin_employees.company_id";
        $data = $this->db->query($sql)->result_array();
        return $data;
    }
    public function ajax_department_employee_info($id) 
    {
        if($id!=0)
        {
            $sql = "SELECT * FROM xin_employees WHERE department_id = $id and user_role_id!='1'";
           $query = $this->db->query($sql);
        }else{
            $sql = "SELECT * FROM xin_employees WHERE user_role_id!='1'";
        $query = $this->db->query($sql);
        }
//      $sql = "SELECT * FROM xin_employees WHERE department_id = $id and user_role_id!='1'";
//      $query = $this->db->query($sql);
        
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    ////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////filter sections/////////////////////
    public function filter_locations_new($id){
        $ids = explode(',',$id);
        $this->db->select('*');
        $this->db->from('xin_office_location');
        if($id!=0)
        {
            $this->db->where_in('company_id',$ids);
        }
        $this->db->limit(100);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    public function filter_location_employee_new($id){
        $ids = explode(',',$id);
        $this->db->select('*');
        $this->db->where('user_role_id!=1');
        $this->db->from('xin_employees');
        if($id!=0)
        {
            $this->db->where_in('location_id',$ids);
        }
        $this->db->limit(100);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }
    //////////////////////////////////////filter sections/////////////////////
    
        
        
        
    
}
?>