<?php

	defined('BASEPATH') OR exit('No direct script access allowed');
	class Assets_model extends CI_Model
	{
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
	public function get_assets_categories() {
	  return $this->db->get("xin_assets_categories");
	}
	
	public function get_assets() {
	  return $this->db->get("xin_assets");
	}
	
	public function get_employee_assets($id) {
		
		//$id = $this->db->escape($id);
		$sql = 'SELECT * FROM xin_assets WHERE employee_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
	 	return $query;
	}
		public function get_assets_assigned_employee($id) {
		
		//$id = $this->db->escape($id);
		$sql = 'SELECT * FROM xin_assets WHERE name = ? order by assets_id DESC';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
 return $query->result();
	}
	public function get_company_assets($company_id) {
	
		$sql = 'SELECT * FROM xin_assets WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}
		
	public function get_all_assets_categories() {
	  $query = $this->db->get("xin_assets_categories");
	  return $query->result();
	}
	 
	public function read_assets_info($id) {
	
		$sql = 'SELECT * FROM xin_assets WHERE assets_id = ? ORDER BY assets_id DESC';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
		public function read_asset_status($id) {
	
		$sql = 'SELECT * FROM xin_asset_status WHERE id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
		public function get_asset_status() {
	
	return  $query = $this->db->query("SELECT * from xin_asset_status");
	}
	
	public function read_assets_category_info($id) {
	
		$sql = 'SELECT * FROM xin_assets_categories WHERE assets_category_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
		public function read_assets_asset_type($id) {
	
		$sql = 'SELECT * FROM xin_assets_master WHERE id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
			public function get_asset_id_from_asset_master($id) {
	
		$sql = 'SELECT name FROM xin_assets WHERE assets_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	// Function to add record in table
	public function add_asset($data){
		$this->db->insert('xin_assets', $data);
		if ($this->db->affected_rows() > 0) {
			return $this->db->insert_id();
		} else {
			return false;
		}
	}
	
	// Function to add record in table
	public function add_assets_category($data){
		$this->db->insert('xin_assets_categories', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
		
	// Function to Delete selected record from table
	public function delete_assets_record($id){

		$asset_master_id= $this->Assets_model->get_asset_id_from_asset_master($id);
		 $name=$asset_master_id[0]->name;

		$this->db->where('assets_id', $id);
		$this->db->delete('xin_assets');
		

$this->db->set('status', 'Not In Use');
 $this->db->set('return_status', '0');
$this->db->where('id', $name);
$this->db->update('xin_assets_master');
		
	}
	
	// Function to Delete selected record from table
	public function delete_assets_category_record($id){
		$this->db->where('assets_category_id', $id);
		$this->db->delete('xin_assets_categories');
		
	}
	
	// Function to update record in table
	public function update_assets_record($data, $id){
		$this->db->where('assets_id', $id);
		if( $this->db->update('xin_assets',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to update record in table
	public function update_assets_category_record($data, $id){
		$this->db->where('assets_category_id', $id);
		if( $this->db->update('xin_assets_categories',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	
	// Function to update record without photo > in table
	public function update_record_no_photo($data, $id){
		$this->db->where('user_id', $id);
		if( $this->db->update('xin_users',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	public function get_all_assets_name() 
	{
	  $sql = 'SELECT * FROM xin_assets WHERE assets_id NOT IN (SELECT assets_id FROM xin_assets_returns)';
	  $query = $this->db->query($sql);
	  return $query->result();
	}
	public function get_all_emp_name_single($employee_id){
	      $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
	      $binds = array($employee_id);
	      $query = $this->db->query($sql, $binds);
	      if(!empty($query->result())){
	          $data_array=$query->result();
	          if(isset($data_array[0]->first_name)){
	            $first_name=$data_array[0]->first_name;
	          }
	          if(isset($data_array[0]->last_name)){
	            $last_name=$data_array[0]->last_name;
	          }
	           $full_name=$first_name." ".$last_name;
	      }else{
	         $full_name='';
	      }
	      return $full_name;
	}
	public function get_all_assets_name_single($category_id,$assets_name,$session)
	{
		if($assets_name!=''){
	      $sql = 'SELECT * FROM xin_assets WHERE  assets_id = ?';
	      $binds = array($assets_name);
		}else{
		   $sql = 'SELECT * FROM xin_assets WHERE  assets_category_id = ?';
	       $binds = array($category_id);
	    }
	  $query = $this->db->query($sql, $binds);
	  return $query->result();
	}
	
	
		public function update_asset_return($data,$assets_id){
		 
		if($this->db->insert('xin_assets_returns', $data)) 
			{
		    
				return true;
			} 
			else {
				return false;
			}
			
			
	  /*$sql = 'SELECT * FROM xin_assets_returns WHERE assets_id = ?';
	  $binds = array($assets_id);
	  $query = $this->db->query($sql, $binds);
	  
	  if(!empty($query->result())){
		$this->db->where('assets_id', $assets_id);
		$this->db->delete('xin_assets_returns');
		$this->db->insert('xin_assets_returns', $data);
		}else{
		$this->db->insert('xin_assets_returns', $data);
		}
		return true;*/
		
		
	}
	
    public function get_asset_return($assets_id){
        $sql=$this->db->select('*')->where('assets_id',$assets_id)->get('xin_assets_returns')->result_array();
        // var_dump($sql);die();
        return $sql;
    }
    public function get_asset_return_check($assets_id){
        $sql=$this->db->select('*')->where('asset_master_id',$assets_id)->where('status',0)->get('xin_assets_returns')->result_array();
        // var_dump($sql);die();
        return $sql;
    }	
	
	
	
	
		public function update_asset_return_new($data,$assets_id){
		 
		    
			$this->db->where('id', $assets_id);
			if( $this->db->update('xin_assets_returns',$data)) 
			{
				return true;
			} else {
				return false;
			}
	  /*$sql = 'SELECT * FROM xin_assets_returns WHERE assets_id = ?';
	  $binds = array($assets_id);
	  $query = $this->db->query($sql, $binds);
	  
	  if(!empty($query->result())){
		$this->db->where('assets_id', $assets_id);
		$this->db->delete('xin_assets_returns');
		$this->db->insert('xin_assets_returns', $data);
		}else{
		$this->db->insert('xin_assets_returns', $data);
		}
		return true;*/
	}
	
	
	
	public function get_assets_return() {
	    
	  return $this->db->get("xin_assets_returns"); 
	    
	}
     public function delete_assets_ret_record($id) {
         
		$asset_master_id= $this->Assets_model->get_asset_id_from_asset_master($id);
		$name=$asset_master_id[0]->name;
     	$this->db->where('assets_id', $id);
        $this->db->delete('xin_assets_returns');


		$this->db->set('status', 'In Use');
 $this->db->set('return_status', '1');
$this->db->where('id', $name);
$this->db->update('xin_assets_master');
     }
     public function read_assets_return_info($id) {
     	$sql = 'SELECT * FROM xin_assets_returns WHERE assets_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) 
		{
			return $query->result();
		} else {
			return false;
		}
     
         
     }
     public function read_assets_return_info_new($id) {
     	$sql = 'SELECT * FROM xin_assets_returns WHERE id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) 
		{
			return $query->result();
		} else {
			return false;
		}
     
         
     }
     	public function get_cat($cid) 
     {
	  $sql = 'SELECT * FROM xin_assets_categories WHERE assets_category_id = ?';
	  $binds = array($cid);
	  $query = $this->db->query($sql, $binds);
	  return $query->result();
	}
	
		public function get_company($comid) 
		{
	  $sql = 'SELECT * FROM xin_companies WHERE company_id = ?';
	  $binds = array($comid);
	  $query = $this->db->query($sql, $binds);
	  return $query->result();
	}
	public function get_employee($emid) 
	{
	  $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
	  $binds = array($emid);
	  $query = $this->db->query($sql, $binds);
	  return $query->result();
	}
	public function get_all_assets_name_single_val($category_id) 
	{
		$sql = 'SELECT * FROM xin_assets WHERE  assets_category_id = ?';
		$binds = array($category_id);
	  $query = $this->db->query($sql, $binds);
	  return $query->result();
	}
	public function get_all_assets_return_single_val($asset_return_id) 
	{
		$sql = 'SELECT * FROM xin_assets_returns WHERE  id = ?';
		$binds = array($asset_return_id);
	  $query = $this->db->query($sql, $binds);
	  return $query->result();
	}
	
	public function update_master_asset_code_check($id)
    {
        $sql = 'SELECT * FROM xin_assets_master WHERE id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function update_assets_category_name_check($id)
    {
        $sql = 'SELECT * FROM xin_assets_categories WHERE assets_category_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
  	public function read_assets_info_emo($id) {
	
		$sql = "SELECT *
		FROM xin_assets
		INNER JOIN xin_assets_master
	ON xin_assets.name = xin_assets_master.id WHERE xin_assets.employee_id = ? AND xin_assets_master.return_status=1";
		
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
  
	
	
}
?>