<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Employees_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // get all employes
    public function get_employees()
    {
        return $this->db->get("xin_employees");
    }


    public function get_all_employees()
    {
        $query = $this->db->query("SELECT * from xin_employees where user_id!= 1");
        return $query->result();
    }

    public function get_all_airticket_locations()
    {
        $sql = "Select * FROM xin_countries right join airticket_encashments on xin_countries.country_id=airticket_encashments.nationality_id";
        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function emp_total_annual_leaves_taken_paid_emp($user_id){
		$sql="Select * FROM xin_annual_leave_applications WHERE employee_id=? and status='2'   ORDER By applied_on desc limit 1";
        $binds = array($user_id);
	    $query = $this->db->query($sql, $binds);
	    if ($query->num_rows() > 0) {
			return $query->result();
		}else{
			return null;
		}	
	}
	

    public function emp_annual_leave_encashment_detail($user_id){
		$sql="Select * FROM xin_encashment WHERE employee_id = ?  ORDER By end_date desc limit 1";
        $binds = array($user_id);
	    $query = $this->db->query($sql, $binds);
	    if ($query->num_rows() > 0) {
			return $query->result();
		}else{
			return null;
		}	
	}
    public function all_contract_types_name($id)
    {
        $query = $this->db->query("SELECT * from xin_contract_type where contract_type_id='$id'");
        return $query->result();
    }

    // get all my team employes > not super admin
    public function get_employees_my_team($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id != ? and reports_to = ?';
        $binds = array(1, $cid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }


    public function get_employees_update()
    {
        $sql = "SELECT *,xin_employees.employee_id as emp_id FROM xin_employees 
        LEFT JOIN xin_employee_contract ON xin_employees.user_id=xin_employee_contract.employee_id 
        LEFT JOIN xin_visa ON xin_employees.user_id=xin_visa.employee_id 
        LEFT JOIN xin_passport ON xin_employees.user_id=xin_passport.employee_id 
        LEFT JOIN xin_cpr ON xin_employees.user_id=xin_cpr.employee_id 
        LEFT JOIN xin_insurance ON xin_employees.user_id=xin_insurance.employee_id
        LEFT JOIN xin_license ON xin_employees.user_id=xin_license.employee_id 
        LEFT JOIN xin_employee_contacts ON xin_employees.user_id=xin_employee_contacts.employee_id 
        LEFT JOIN  xin_employee_work_experience ON xin_employees.user_id=xin_employee_work_experience.`employee_id` 
        LEFT JOIN  xin_employee_bankaccount ON xin_employees.user_id= xin_employee_bankaccount.`employee_id` 
        LEFT JOIN  xin_vehicle ON xin_employees.user_id= xin_vehicle.`employee_id` 
        LEFT JOIN  xin_employee_security_level ON xin_employees.user_id= xin_employee_security_level.`employee_id` 
        LEFT JOIN  employee_leave ON xin_employees.user_id= employee_leave.`employee_id` 
        LEFT JOIN   xin_employee_documents ON xin_employees.user_id=xin_employee_documents.`employee_id` 
        LEFT JOIN   xin_employee_qualification ON xin_employees.user_id=  xin_employee_qualification.`employee_id` 
        WHERE xin_employee_contract.update_value!='' OR xin_visa.update_value!='' OR 
        xin_passport.update_value!='' OR xin_cpr.update_value!='' 
        OR xin_insurance.update_value!='' OR xin_license.update_value!='' 
        OR xin_employee_contacts.local_store!='' OR xin_employee_work_experience.local_store!='' 
        OR xin_employee_bankaccount.local_store!='' OR xin_vehicle.local_store!='' 
        OR xin_employee_security_level.local_store!='' OR employee_leave.local_store!='' 
        OR xin_employees.serialized!='' OR xin_employees.serialized_social!='' 
        OR xin_employees.serialize_profile_picture!='' 
        OR xin_employee_documents.serialized!='' 
        OR xin_employee_qualification.serialized!='' GROUP BY xin_employees.user_id";
	  	$query = $this->db->query($sql);
        return $query;
    }



  public function get_employees_update_emp($id)
    {
        $sql = "SELECT *,xin_employees.employee_id as emp_id FROM xin_employees 
        LEFT JOIN xin_employee_contract ON xin_employees.user_id=xin_employee_contract.employee_id 
        LEFT JOIN xin_visa ON xin_employees.user_id=xin_visa.employee_id 
        LEFT JOIN xin_passport ON xin_employees.user_id=xin_passport.employee_id 
        LEFT JOIN xin_cpr ON xin_employees.user_id=xin_cpr.employee_id 
        LEFT JOIN xin_insurance ON xin_employees.user_id=xin_insurance.employee_id
        LEFT JOIN xin_license ON xin_employees.user_id=xin_license.employee_id 
        LEFT JOIN xin_employee_contacts ON xin_employees.user_id=xin_employee_contacts.employee_id 
        LEFT JOIN  xin_employee_work_experience ON xin_employees.user_id=xin_employee_work_experience.`employee_id` 
        LEFT JOIN  xin_employee_bankaccount ON xin_employees.user_id= xin_employee_bankaccount.`employee_id` 
        LEFT JOIN  xin_vehicle ON xin_employees.user_id= xin_vehicle.`employee_id` 
        LEFT JOIN  xin_employee_security_level ON xin_employees.user_id= xin_employee_security_level.`employee_id` 
        LEFT JOIN  employee_leave ON xin_employees.user_id= employee_leave.`employee_id` 
        LEFT JOIN   xin_employee_documents ON xin_employees.user_id=xin_employee_documents.`employee_id` 
        LEFT JOIN   xin_employee_qualification ON xin_employees.user_id=  xin_employee_qualification.`employee_id` 
        WHERE xin_employee_contract.update_value!='' OR xin_visa.update_value!='' OR 
        xin_passport.update_value!='' OR xin_cpr.update_value!='' 
        OR xin_insurance.update_value!='' OR xin_license.update_value!='' 
        OR xin_employee_contacts.local_store!='' OR xin_employee_work_experience.local_store!='' 
        OR xin_employee_bankaccount.local_store!='' OR xin_vehicle.local_store!='' 
        OR xin_employee_security_level.local_store!='' OR employee_leave.local_store!='' 
        OR xin_employees.serialized!='' OR xin_employees.serialized_social!='' 
        OR xin_employees.serialize_profile_picture!='' 
        OR xin_employee_documents.serialized!='' 
        OR xin_employee_qualification.serialized!='' GROUP BY xin_employees.user_id and xin_employees.employee_id='$id'";
	  	$query = $this->db->query($sql);
        return $query;
    }




    public function getproject_notstartedcount($id, $status)
    {

        $sql = 'SELECT * FROM xin_projects WHERE assigned_to = ? and status = ?';
        $binds = array($id, $status);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }

    public function emp_duplication_check($id)
    {

        $sql = 'SELECT * FROM xin_airtickets WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }

    public function gettask_notstartedcount($id, $status)
    {

        $sql = 'SELECT * FROM xin_tasks WHERE assigned_to = ? and task_status = ?';
        $binds = array($id, $status);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // get all employes > not super admin
    public function get_employees_for_other($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id != ? and company_id = ?';
        $binds = array(1, $cid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get all employes > not super admin
    public function get_employees_for_location($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id != ? and location_id = ?';
        $binds = array(1, $cid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get all employes|company>
    public function get_company_employees_flt($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ?';
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get all MY TEAM employes
    public function get_my_team_employees($reports_to)
    {

        $sql = 'SELECT * FROM xin_employees WHERE reports_to = ?';
        $binds = array($reports_to);
        $query = $this->db->query($sql, $binds);
        return $query;
    }

    // 	public function get_leaves($leave) {

    // 		$sql = 'SELECT * FROM xin_leave_type WHERE leave_type_id = ?';
    // 		$binds = array($leave);
    // 		$query = $this->db->query($sql, $binds);
    // 	    return $query;
    // 	}


    // get all employes>company|location >
    public function get_company_location_employees_flt($cid, $lid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id = ?';
        $binds = array($cid, $lid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get all employes>company|location|department >
    public function get_company_location_department_employees_flt($cid, $lid, $dep_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id = ? and department_id = ?';
        $binds = array($cid, $lid, $dep_id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get all employes>company|location|department|designation >
    public function get_company_location_department_designation_employees_flt($cid, $lid, $dep_id, $des_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id = ? and department_id = ? and designation_id = ?';
        $binds = array($cid, $lid, $dep_id, $des_id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get all employees >
    public function get_employees_payslip()
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_role_id != ?';
        $binds = array(1);
        $query = $this->db->query($sql, $binds);
        return $query;
    }

    // get all employees in bank format >
    public function get_allemployees_payslip()
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_role_id != ?';
        $binds = array(1);
        $query = $this->db->query($sql, $binds);
        return $query;
    }

    // get all employees by location in bank format >
    public function get_employees_payslip_by_place($lid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_role_id != ? and location_id = ?';
        $binds = array(1, $lid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }

    // get employes
    public function get_attendance_employees()
    {

        $sql = 'SELECT * FROM xin_employees WHERE is_active = ?';
        $binds = array(1);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employes with location
    public function get_attendance_location_employees($location_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE location_id = ? and is_active = ?';
        $binds = array($location_id, 1);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get total number of employees
    public function get_total_employees()
    {
        $query = $this->db->get("xin_employees");
        return $query->num_rows();
    }

    public function read_employee_information($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function read_employee_onboardchecklist($id)
    {

        $sql = 'SELECT * FROM xin_onboard_checklists WHERE designation_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function read_employee_onboardchecklist_check($id)
    {

        $sql = 'SELECT * FROM employee_onboard_checklist WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function read_employee_offboardchecklist_check($id)
    {

        $sql = 'SELECT * FROM employee_offboard_checklist WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function read_employee_offboardchecklist($id)
    {

        $sql = 'SELECT * FROM xin_offboard_checklists WHERE designation_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    // check employeeID
    public function check_employee_id($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // check old password
    public function check_old_password($old_password, $user_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        //$rw_password = $query->result();
        $options = array('cost' => 12);
        $password_hash = password_hash($old_password, PASSWORD_BCRYPT, $options);
        if ($query->num_rows() > 0) {
            $rw_password = $query->result();
            if (password_verify($old_password, $rw_password[0]->password)) {
                return 1;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    // check username
    public function check_employee_username($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE username = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // check email
    public function check_employee_email($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE email = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // check email
    public function check_employee_pincode($pincode)
    {

        $sql = 'SELECT * FROM xin_employees WHERE pincode = ?';
        $binds = array($pincode);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }

    // Function to add record in table
    public function add($data)
    {
        $this->db->insert('xin_employees', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function addCrm($data)
    {
        $this->db->insert('tblstaff', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    
       public function update_recordCRm($data, $id)
    {
        $this->db->where('employeeID', $id);
        if ($this->db->update('tblstaff', $data)) {
            return true;
        } else {
            return false;
        }
    }
    
    

    public function add_leaves($data)
    {
        $this->db->insert('employee_leave', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }

    public function check_first_attendance($id, $date)
    {

        $sql = "SELECT * FROM xin_attendance_time WHERE employee_id = '$id' AND attendance_date = '$date'";
        $query = $this->db->query($sql);
        return $query->num_rows();
    }

    // Function to Delete selected record from table
    public function delete_record($id)
    {
        $this->db->where('user_id', $id);
        $this->db->delete('xin_employees');
    }

    /*  Update Employee Record */

    // Function to update record in table
    public function update_record($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function emp_salary_inc_history($data)
    {
        $this->db->insert('xin_employee_salary_history', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function emp_indeminty_add($data)
    {
        $this->db->insert('xin_employee_indemnity', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function set_employee_sal_history($id, $history_type)
    {
        $sql = 'SELECT * FROM xin_employee_salary_history WHERE employee_id = ? and history_type = ? ORDER BY id DESC';
        $binds = array($id, $history_type);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function CheckAllowanceExistsInSalaryHistory($id, $history_type)
    {
        $sql = 'SELECT * FROM xin_employee_salary_history WHERE allowance_id = ? and history_type = ? ORDER BY id DESC';
        $binds = array($id, $history_type);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    /*public function set_employee_sal_historyBby_allowanceID($id) {
		$sql = 'SELECT * FROM xin_employee_salary_history WHERE employee_id = ? and history_type = ? ORDER BY id DESC';
		$binds = array($id,$history_type);
		$query = $this->db->query($sql, $binds);
		
	  	return $query;
	}*/
    public function delete_emp_indeminty($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('xin_employee_indemnity');
    }
    public function delete_emp_salary_history($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('xin_employee_salary_history');
    }
    // Function to update record in table > basic_info
    public function basic_info($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }


    public function employee_info($data1, $employee_id)
    {
        $this->db->where('user_id', $employee_id);
        if ($this->db->update('xin_employees', $data1)) {
            return true;
        } else {
            return false;
        }
    }
    public function update_onboard_checklist($data, $id)
    {
        $this->db->where('employee_id', $id);
        if ($this->db->update('employee_onboard_checklist', $data)) {
            return true;
        } else {
            return false;
        }
    }
    
    public function update_offboard_checklist($data, $id)
    {
        $this->db->where('employee_id', $id);
        if ($this->db->update('employee_offboard_checklist', $data)) {
            return true;
        } else {
            return false;
        }
    }


    public function auto_update($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table > change_password
    public function change_password($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > social_info
    public function social_info($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > profile picture
    public function profile_picture($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }



    // Function to add record in table > contact_info
    public function contact_info_add($data)
    {
        $this->db->insert('xin_employee_contacts', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > contact_info
    public function contact_info_update($data, $id)
    {
        $values = serialize($data);
        $this->db->set('local_store', $values);
        $this->db->where('contact_id', $id);
        if ($this->db->update('xin_employee_contacts')) {
            return true;
        } else {
            return false;
        }
        // 		$this->db->where('contact_id', $id);
        // 		if( $this->db->update('xin_employee_contacts',$data)) {
        // 			return true;
        // 		} else {
        // 			return false;
        // 		}		
    }

    // Function to update record in table > document_info_update
    public function document_info_update($data, $id)
    {
        $this->db->where('document_id', $id);
        if ($this->db->update('xin_employee_documents', $data)) {
            return true;
        } else {
            return false;
        }
    }
    
    public function add_onboard_checklist($data)
    {
        $this->db->insert('employee_onboard_checklist', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    
    public function add_offboard_checklist($data)
    {
        $this->db->insert('employee_offboard_checklist', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > document_info_update
    public function img_document_info_update($data, $id)
    {
        $this->db->where('immigration_id', $id);
        if ($this->db->update('xin_employee_immigration', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to add record in table > document info
    public function document_info_add($data)
    {
        $this->db->insert('xin_employee_documents', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to add record in table > immigration info
    public function immigration_info_add($data)
    {
        $this->db->insert('xin_employee_immigration', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }


    // Function to add record in table > qualification_info_add
    public function qualification_info_add($data)
    {
        $this->db->insert('xin_employee_qualification', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > qualification_info_update
    public function qualification_info_update($data, $id)
    {
        $this->db->where('qualification_id', $id);
        if ($this->db->update('xin_employee_qualification', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to add record in table > work_experience_info_add
    public function work_experience_info_add($data)
    {
        $this->db->insert('xin_employee_work_experience', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > work_experience_info_update
    public function work_experience_info_update($data, $id)
    {
        $values = serialize($data);
        $this->db->set('local_store', $values);
        $this->db->where('work_experience_id', $id);
        if ($this->db->update('xin_employee_work_experience')) {
            return true;
        } else {
            return false;
        }
        // 		$this->db->where('work_experience_id', $id);
        // 		if( $this->db->update('xin_employee_work_experience',$data)) {
        // 			return true;
        // 		} else {
        // 			return false;
        // 		}		
    }

    // Function to add record in table > bank_account_info_add
    public function bank_account_info_add($data)
    {
        $this->db->insert('xin_employee_bankaccount', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Function to add record in table > security level info_add
    public function security_level_info_add($data)
    {
        $this->db->insert('xin_employee_security_level', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > bank_account_info_update
    public function bank_account_info_update($data, $id)
    {
        $values = serialize($data);
        $this->db->set('local_store', $values);
        $this->db->where('bankaccount_id', $id);
        if ($this->db->update('xin_employee_bankaccount')) {
            return true;
        } else {
            return false;
        }
        // 		$this->db->where('bankaccount_id', $id);
        // 		if( $this->db->update('xin_employee_bankaccount',$data)) {
        // 			return true;
        // 		} else {
        // 			return false;
        // 		}		
    }
    // Function to update record in table > security_level_info_update
    public function security_level_info_update($data, $id)
    {
        $values = serialize($data);
        $this->db->set('local_store', $values);
        $this->db->where('security_level_id', $id);
        if ($this->db->update('xin_employee_security_level')) {
            return true;
        } else {
            return false;
        }
        // 		$this->db->where('security_level_id', $id);
        // 		if( $this->db->update('xin_employee_security_level',$data)) {
        // 			return true;
        // 		} else {
        // 			return false;
        // 		}		
    }

    // Function to add record in table > contract_info_add
    public function contract_info_add($data)
    {
        $this->db->insert('xin_employee_contract', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    //for current contact > employee
    public function check_employee_contact_current($id)
    {

        $sql = 'SELECT * FROM xin_employee_contacts WHERE employee_id = ? and contact_type = ? limit 1';
        $binds = array($id, 'current');
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    //for permanent contact > employee
    public function check_employee_contact_permanent($id)
    {

        $sql = 'SELECT * FROM xin_employee_contacts WHERE employee_id = ? and contact_type = ? limit 1';
        $binds = array($id, 'permanent');
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get current contacts by id
    public function read_contact_info_current($id)
    {

        $sql = 'SELECT * FROM xin_employee_contacts WHERE contact_id = ? and contact_type = ? limit 1';
        $binds = array($id, 'current');
        $query = $this->db->query($sql, $binds);

        $row = $query->row();
        return $row;
    }

    // get permanent contacts by id
    public function read_contact_info_permanent($id)
    {

        $sql = 'SELECT * FROM xin_employee_contacts WHERE contact_id = ? and contact_type = ? limit 1';
        $binds = array($id, 'permanent');
        $query = $this->db->query($sql, $binds);

        $row = $query->row();
        return $row;
    }

    // Function to update record in table > contract_info_update
    public function contract_info_update($data, $id)
    {
        $this->db->where('contract_id', $id);
        if ($this->db->update('xin_employee_contract', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to add record in table > leave_info_add
    public function leave_info_add($data)
    {
        $this->db->insert('xin_employee_leave', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table > leave_info_update
    public function leave_info_update($data, $id)
    {
        $this->db->where('leave_id', $id);
        if ($this->db->update('xin_employee_leave', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to add record in table > shift_info_add
    public function shift_info_add($data)
    {
        $this->db->insert('xin_employee_shift', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > shift_info_update
    public function shift_info_update($data, $id)
    {
        $this->db->where('emp_shift_id', $id);
        if ($this->db->update('xin_employee_shift', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // Function to add record in table > location_info_add
    public function location_info_add($data)
    {
        $this->db->insert('xin_employee_location', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    // Function to update record in table > location_info_update
    public function location_info_update($data, $id)
    {
        $this->db->where('office_location_id', $id);
        if ($this->db->update('xin_employee_location', $data)) {
            return true;
        } else {
            return false;
        }
    }

    // get all office shifts 
    public function all_office_shifts()
    {
        $query = $this->db->query("SELECT * from xin_office_shift");
        return $query->result();
    }

    // get contacts
    public function set_employee_contacts($id)
    {

        $sql = 'SELECT * FROM xin_employee_contacts WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get documents
    public function set_employee_documents($id)
    {

        $sql = 'SELECT * FROM xin_employee_documents WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get documents
    public function get_documents_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_employee_documents where date_of_expiry < '" . $curr_date . "' ORDER BY `date_of_expiry` asc");
        return $query;
    }
    // user/
    public function get_user_documents_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_employee_documents where employee_id = '" . $employee_id . "' and date_of_expiry < '" . $curr_date . "' ORDER BY `date_of_expiry` asc");
        return $query;
    }
    // get immigration documents
    public function get_img_documents_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_employee_immigration where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    //user // get immigration documents
    public function get_user_img_documents_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_employee_immigration where employee_id = '" . $employee_id . "' and expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function company_license_expired_all()
    {
        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_company_documents where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_company_license_expired($company_id)
    {

        $curr_date = date('Y-m-d');
        $sql = "SELECT * FROM xin_company_documents WHERE expiry_date < '" . $curr_date . "' and company_id = ?";
        $binds = array($company_id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // assets warranty all
    public function warranty_assets_expired_all()
    {
        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_assets where warranty_end_date < '" . $curr_date . "' ORDER BY `warranty_end_date` asc");
        return $query;
    }
    // user assets warranty all
    public function user_warranty_assets_expired_all($employee_id)
    {
        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_assets where employee_id = '" . $employee_id . "' and warranty_end_date < '" . $curr_date . "' ORDER BY `warranty_end_date` asc");
        return $query;
    }
    // company assets warranty all
    public function company_warranty_assets_expired_all($company_id)
    {
        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_assets where company_id = '" . $company_id . "' and warranty_end_date < '" . $curr_date . "' ORDER BY `warranty_end_date` asc");
        return $query;
    }
    // get immigration
    public function set_employee_immigration($id)
    {

        $sql = 'SELECT * FROM xin_employee_immigration WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee qualification
    public function set_employee_qualification($id)
    {

        $sql = 'SELECT * FROM xin_employee_qualification WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee work experience
    public function set_employee_experience($id)
    {

        $sql = 'SELECT * FROM xin_employee_work_experience WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee bank account
    public function set_employee_bank_account($id)
    {

        $sql = 'SELECT * FROM xin_employee_bankaccount WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee bank account
    public function set_employee_security_level($id)
    {

        $sql = 'SELECT * FROM xin_employee_security_level WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee bank account > Last
    public function get_employee_bank_account_last($id)
    {

        $sql = 'SELECT * FROM xin_employee_bankaccount WHERE employee_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee contract
    public function set_employee_contract($id)
    {

        $sql = 'SELECT * FROM xin_employee_contract WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee office shift
    public function set_employee_shift($id)
    {

        $sql = 'SELECT * FROM xin_employee_shift WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee leave
    public function set_employee_leave($id)
    {

        $sql = 'SELECT * FROM xin_employee_leave WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee location
    public function set_employee_location($id)
    {

        $sql = 'SELECT * FROM xin_employee_location WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get document type by id
    public function read_document_type_information($id)
    {

        $sql = 'SELECT * FROM xin_document_type WHERE document_type_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // contract type
    public function read_contract_type_information($id)
    {

        $sql = 'SELECT * FROM xin_contract_type WHERE contract_type_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // contract employee
    public function read_contract_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_contract WHERE contract_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // office shift
    public function read_shift_information($id)
    {

        $sql = 'SELECT * FROM xin_office_shift WHERE office_shift_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function emp_total_annual_leaves_taken_not_paid_new($user_id, $start_date_y, $ending_Date)
    {
        $sql = "Select *,SUM(days) as total_ann FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and (from_date >= ? and to_date <= ? ) ORDER By applied_on desc limit 1";
        $binds = array($user_id, $start_date_y, $ending_Date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get all contract types
    public function all_contract_types()
    {
        $query = $this->db->query("SELECT * from xin_contract_type");
        return $query->result();
    }

    // get all contracts
    public function all_contracts()
    {
        $query = $this->db->query("SELECT * from xin_employee_contract");
        return $query->result();
    }

    // get all document types
    public function all_document_types()
    {
        $query = $this->db->query("SELECT * from xin_document_type");
        return $query->result();
    }

    // get all education level
    public function all_education_level()
    {
        $query = $this->db->query("SELECT * from xin_qualification_education_level");
        return $query->result();
    }

    // get education level by id
    public function read_education_information($id)
    {

        $sql = 'SELECT * FROM xin_qualification_education_level WHERE education_level_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get all qualification languages
    public function all_qualification_language()
    {
        $query = $this->db->query("SELECT * from xin_qualification_language");
        return $query->result();
    }

    // get languages by id
    public function read_qualification_language_information($id)
    {

        $sql = 'SELECT * FROM xin_qualification_language WHERE language_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get all qualification skills
    public function all_qualification_skill()
    {
        $query = $this->db->query("SELECT * from xin_qualification_skill");
        return $query->result();
    }

    // get qualification by id
    public function read_qualification_skill_information($id)
    {

        $sql = 'SELECT * FROM xin_qualification_skill WHERE skill_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get contacts by id
    public function read_contact_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_contacts WHERE contact_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get documents by id
    public function read_document_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_documents WHERE document_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get documents by id
    public function read_imgdocument_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_immigration WHERE immigration_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get qualifications by id
    public function read_qualification_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_qualification WHERE qualification_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get qualifications by id
    public function read_work_experience_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_work_experience WHERE work_experience_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get bank account by id
    public function read_bank_account_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_bankaccount WHERE bankaccount_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get sc level by id
    public function read_security_level_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_security_level WHERE security_level_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get leave by id
    public function read_leave_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_leave WHERE leave_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // get shift by id
    public function read_emp_shift_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_shift WHERE emp_shift_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    // Function to Delete selected record from table
    public function delete_contact_record($id)
    {
        $this->db->where('contact_id', $id);
        $this->db->delete('xin_employee_contacts');
    }

    // Function to Delete selected record from table
    public function delete_document_record($id)
    {
        $this->db->where('document_id', $id);
        $this->db->delete('xin_employee_documents');
    }

    // Function to Delete selected record from table
    public function delete_imgdocument_record($id)
    {
        $this->db->where('immigration_id', $id);
        $this->db->delete('xin_employee_immigration');
    }

    // Function to Delete selected record from table
    public function delete_qualification_record($id)
    {
        $this->db->where('qualification_id', $id);
        $this->db->delete('xin_employee_qualification');
    }

    // Function to Delete selected record from table
    public function delete_work_experience_record($id)
    {
        $this->db->where('work_experience_id', $id);
        $this->db->delete('xin_employee_work_experience');
    }

    // Function to Delete selected record from table
    public function delete_bank_account_record($id)
    {
        $this->db->where('bankaccount_id', $id);
        $this->db->delete('xin_employee_bankaccount');
    }
    // Function to Delete selected record from table
    public function delete_security_level_record($id)
    {
        $this->db->where('security_level_id', $id);
        $this->db->delete('xin_employee_security_level');
    }

    // Function to Delete selected record from table
    public function delete_contract_record($id)
    {
        $this->db->where('contract_id', $id);
        $this->db->delete('xin_employee_contract');
    }

    // Function to Delete selected record from table
    public function delete_leave_record($id)
    {
        $this->db->where('leave_id', $id);
        $this->db->delete('xin_employee_leave');
    }

    // Function to Delete selected record from table
    public function delete_shift_record($id)
    {
        $this->db->where('emp_shift_id', $id);
        $this->db->delete('xin_employee_shift');
    }

    // Function to Delete selected record from table
    public function delete_location_record($id)
    {
        $this->db->where('office_location_id', $id);
        $this->db->delete('xin_employee_location');
    }

    // get location by id
    public function read_location_information($id)
    {

        $sql = 'SELECT * FROM xin_employee_location WHERE office_location_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function record_count()
    {
        $sql = 'SELECT * FROM xin_employees where user_role_id!=1 order by first_name ASC' ;
        $query = $this->db->query($sql);
        return $query->num_rows();
    }
    public function record_count_myteam($reports_to)
    {
        $sql = 'SELECT * FROM xin_employees where user_role_id!=1 and reports_to = ' . $reports_to . ' order by first_name ASC';
        $query = $this->db->query($sql);
        return $query->num_rows();
    }
    // read filter record
    public function get_employee_by_department($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE department_id = ?';
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
           public function record_count_company_employees_archive($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and is_active=0  order by first_name ASC  ' ;
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_employees_archive($cid, $lid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id= ? and is_active=0  order by first_name ASC ';
        $binds = array($cid, $lid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_department_employees_archive($cid, $lid, $dep_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id= ? and department_id= ? and is_active=0  order by first_name ASC ';
        $binds = array($cid, $lid, $dep_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_department_designation_employees_archive($cid, $lid, $dep_id, $des_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id= ? and department_id= ? and designation_id= ? and is_active=0  order by first_name ASC ';
        $binds = array($cid, $lid, $dep_id, $des_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function fetch_all_team_employees_archive($limit, $start)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        $this->db->where("reports_to", $session['user_id']);
        		$this->db->where("is_active=0");
        $this->db->where("user_role_id!=1");
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_employees_archive($limit, $start)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id != 1) {
            $this->db->where("company_id", $user_info[0]->company_id);
        }
        $this->db->where("user_role_id!=1");
        		$this->db->where("is_active=0");
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_employees_flt_archive($limit, $start, $cid)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id", $cid);
        		$this->db->where("is_active=0");
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_employees_flt_archive($limit, $start, $cid, $lid)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        		$this->db->where("is_active=0");
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_department_employees_flt_archive($limit, $start, $cid, $lid, $dep_id)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
        		$this->db->where("is_active=0");
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_department_designation_employees_flt_archive($limit, $start, $cid, $lid, $dep_id, $des_id)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
        $this->db->where("designation_id=", $des_id);
        		$this->db->where("is_active=0");
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    
    // read filter record
    public function record_count_company_employees($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? order by first_name ASC  ';
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // read filter record
    public function record_count_company_location_employees($cid, $lid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id= ? order by first_name ASC ' ;
        $binds = array($cid, $lid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // read filter record
    public function record_count_company_location_department_employees($cid, $lid, $dep_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id= ? and department_id= ? order by first_name ASC ';
        $binds = array($cid, $lid, $dep_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // read filter record
    public function record_count_company_location_department_designation_employees($cid, $lid, $dep_id, $des_id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE company_id = ? and location_id= ? and department_id= ? and designation_id= ? order by first_name ASC ';
        $binds = array($cid, $lid, $dep_id, $des_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    //reports_to -> my employees
    public function fetch_all_team_employees($limit, $start)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
      
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        $this->db->where("reports_to", $session['user_id']);
        $this->db->where("user_role_id!=1");
        //   $this->db->order_by("designation_id asc,first_name ");
       $this->db->order_by('first_name','ASC');
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    public function fetch_all_employees($limit, $start)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        // $this->db->order_by("designation_id asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id != 1) {
            $this->db->where("company_id", $user_info[0]->company_id);
        }
        
        $this->db->where("user_role_id!=1");
               $this->db->order_by('first_name','ASC');
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    // get company employees
    public function fetch_all_company_employees_flt($limit, $start, $cid)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        // $this->db->order_by("designation_id asc");
        $this->db->where("company_id", $cid);
             $this->db->order_by('first_name','ASC');
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    // get company|location employees
    public function fetch_all_company_location_employees_flt($limit, $start, $cid, $lid)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        // $this->db->order_by("designation_id asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
      $this->db->order_by('first_name','ASC');
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    // get company|location|department employees
    public function fetch_all_company_location_department_employees_flt($limit, $start, $cid, $lid, $dep_id)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        // $this->db->order_by("designation_id asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
            $this->db->order_by('first_name','ASC');
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    // get company|location|department|designation employees
    public function fetch_all_company_location_department_designation_employees_flt($limit, $start, $cid, $lid, $dep_id, $des_id)
    {
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        // $this->db->order_by("designation_id asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
        $this->db->where("designation_id=", $des_id);
      $this->db->order_by('first_name','ASC');
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function des_fetch_all_employees($limit, $start)
    {
        // $this->db->limit($limit, $start);

        $sql = 'SELECT * FROM xin_employees order by designation_id asc limit ?, ?';
        $binds = array($limit, $start);
        $query = $this->db->query($sql, $binds);

        //  $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    // get employee allowances
    public function set_employee_allowances($id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function other_employee_allowances($id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_title!=11 AND employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function hr_employee_allowances($id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_title=11 AND employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function set_employee_indemnity($id)
    {

        $sql = 'SELECT * FROM xin_employee_indemnity WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function get_employee_balance($id)
    {

        $sql = 'SELECT *,balance_amount as balance_amount FROM xin_employee_indemnity WHERE employee_id = ? order by id DESC ';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }
    public function indeminty_details_update($data, $id)
    {
        $this->db->where('id', $id);
        if ($this->db->update('xin_employee_indemnity', $data)) {
            return true;
        } else {
            return false;
        }
    }

    public function get_employee_encashrate($nation_id)
    {

        $sql = 'SELECT * FROM airticket_encashments WHERE nationality_id = ?';
        $binds = array($nation_id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_employee_encashrate_payroll($user_id, $month_year)
    {

        $sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE employee_id = ? AND payroll_month = ?';
        $binds = array($user_id, $month_year);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }


    // get employee commissions
    public function set_employee_commissions($id)
    {

        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee statutory deductions
    public function set_employee_statutory_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee other payments
    public function set_employee_other_payments($id)
    {

        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee overtime
    public function set_employee_overtime($id)
    {

        $sql = 'SELECT * FROM xin_salary_overtime WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee allowances
    public function set_employee_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    //-- payslip data
    // get employee allowances
    public function set_employee_allowances_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee commissions
    public function set_employee_commissions_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee other payments
    public function set_employee_other_payments_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee statutory_deductions
    public function set_employee_statutory_deductions_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function set_employee_indeminity_payslip($id)
    {

        $sql = 'SELECT * FROM  xin_employee_indemnity WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    // get employee overtime
    public function set_employee_overtime_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_overtime WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }

    // get employee air ticket encashment
    public function get_employee_airticket_encash_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslips WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    // get employee allowances
    public function set_employee_deductions_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_loan WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    //------
    // get employee allowances
    public function count_employee_allowances_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee commissions
    public function count_employee_commissions_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee statutory_deductions
    public function count_employee_statutory_deductions_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    public function count_employee_indeminity_payslip($id)
    {

        $sql = 'SELECT * FROM  xin_employee_indemnity WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee other payments
    public function count_employee_other_payments_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee overtime
    public function count_employee_overtime_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_overtime WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }

    // get employee airticket encashment
    public function count_employee_airticket_encash_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslips WHERE payslip_id = ? AND airticket_encashment > 0';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee allowances
    public function count_employee_deductions_payslip($id)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_loan WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    //////////////////////
    // get employee allowances
    public function count_employee_allowances($id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee commissions
    public function count_employee_commissions($id)
    {

        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee other payments
    public function count_employee_other_payments($id)
    {

        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee statutory deduction
    public function count_employee_statutory_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }
    // get employee overtime
    public function count_employee_overtime($id)
    {

        $sql = 'SELECT * FROM xin_salary_overtime WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }

    // get employee allowances
    public function count_employee_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->num_rows();
    }

    // get employee salary allowances
    public function read_salary_allowances($id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee salary commissions
    public function read_salary_commissions($id)
    {

        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee salary other payments
    public function read_salary_other_payments($id)
    {

        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee statutory deductions
    public function read_salary_statutory_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee overtime
    public function read_salary_overtime($id)
    {

        $sql = 'SELECT * FROM xin_salary_overtime WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee salary loan_deduction
    public function read_salary_loan_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee salary loan_deduction
    public function read_single_loan_deductions($id)
    {

        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE loan_deduction_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    //Calculates how many months is past between two timestamps.
    public function get_month_diff($start, $end = FALSE)
    {
        $end or $end = time();
        $start = new DateTime($start);
        $end   = new DateTime($end);
        $diff  = $start->diff($end);
        return $diff->format('%y') * 12 + $diff->format('%m');
    }
    // get employee salary allowances
    public function read_single_salary_allowance($id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee commissions
    public function read_single_salary_commissions($id)
    {

        $sql = 'SELECT * FROM xin_salary_commissions WHERE salary_commissions_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get
    public function read_single_salary_statutory_deduction($id)
    {

        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE statutory_deductions_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_emp($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_single_salary_other_payment($id)
    {

        $sql = 'SELECT * FROM xin_salary_other_payments WHERE other_payments_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // get employee overtime record
    public function read_salary_overtime_record($id)
    {

        $sql = 'SELECT * FROM xin_salary_overtime WHERE salary_overtime_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function get_leaves($leave)
    {

        $sql = 'SELECT * FROM xin_leave_type WHERE leave_type_id = ?';
        $binds = array($leave);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    
    public function get_leave_types()
    {

        $sql = 'SELECT * FROM xin_leave_type';
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function get_employee_leave_type($leave,$employee_id,$update_date)
    {

        $sql = 'SELECT * FROM employee_leave WHERE leave_type = ? and employee_id = ? and created_at = ?';
        $binds = array($leave,$employee_id,$update_date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function delete_current_employee_leave_type($id,$leave_type,$update_date)
    {
        $this->db->where('employee_id', $id);
        $this->db->where('leave_type', $leave_type);
        $this->db->where('created_at', $update_date);
        $this->db->delete('employee_leave');
    }
    
    
    
    // Function to add record in table > allowance
    public function add_salary_allowances($data)
    {
        $this->db->insert('xin_salary_allowances', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function add_salary_allowances_new($data)
    {
        $this->db->insert('xin_salary_allowances', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }

    // Function to add record in table > commissions
    public function add_salary_commissions($data)
    {
        $this->db->insert('xin_salary_commissions', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Function to add record in table > statutory_deductions
    public function add_salary_statutory_deductions($data)
    {
        $this->db->insert('xin_salary_statutory_deductions', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Function to add record in table > other payments
    public function add_salary_other_payments($data)
    {
        $this->db->insert('xin_salary_other_payments', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Function to add record in table > loan
    public function add_salary_loan($data)
    {
        $this->db->insert('xin_salary_loan_deductions', $data);
        if ($this->db->affected_rows() > 0) {
            return  $this->db->insert_id();
        } else {
            return false;
        }
    }
    // Function to add record in table > overtime
    public function add_salary_overtime($data)
    {
        $this->db->insert('xin_salary_overtime', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Function to Delete selected record from table
    public function delete_allowance_record($id)
    {
        $this->db->where('allowance_id', $id);
        $this->db->delete('xin_salary_allowances');
    }
    // Function to Delete selected record from table
    public function delete_commission_record($id)
    {
        $this->db->where('salary_commissions_id', $id);
        $this->db->delete('xin_salary_commissions');
    }
    // Function to Delete selected record from table
    public function delete_statutory_deductions_record($id)
    {
        $this->db->where('statutory_deductions_id', $id);
        $this->db->delete('xin_salary_statutory_deductions');
    }
    // Function to Delete selected record from table
    public function delete_other_payments_record($id)
    {
        $this->db->where('other_payments_id', $id);
        $this->db->delete('xin_salary_other_payments');
    }
    // Function to Delete selected record from table
    public function delete_loan_record($id)
    {
        $this->db->where('loan_deduction_id', $id);
        $this->db->delete('xin_salary_loan_deductions');
    }
    // Function to Delete selected record from table
    public function delete_overtime_record($id)
    {
        $this->db->where('salary_overtime_id', $id);
        $this->db->delete('xin_salary_overtime');
    }
    // Function to update record in table > update allowance record
    public function salary_allowance_update_record($data, $id)
    {
        $this->db->where('allowance_id', $id);
        if ($this->db->update('xin_salary_allowances', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table >
    public function salary_commissions_update_record($data, $id)
    {
        $this->db->where('salary_commissions_id', $id);
        if ($this->db->update('xin_salary_commissions', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table >
    public function salary_statutory_deduction_update_record($data, $id)
    {
        $this->db->where('statutory_deductions_id', $id);
        if ($this->db->update('xin_salary_statutory_deductions', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table >
    public function salary_other_payment_update_record($data, $id)
    {
        $this->db->where('other_payments_id', $id);
        if ($this->db->update('xin_salary_other_payments', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table > update allowance record
    public function salary_loan_update_record($data, $id)
    {
        $this->db->where('loan_deduction_id', $id);
        if ($this->db->update('xin_salary_loan_deductions', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to update record in table > update allowance record
    public function salary_overtime_update_record($data, $id)
    {
        $this->db->where('salary_overtime_id', $id);
        if ($this->db->update('xin_salary_overtime', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // get single record > company | office shift
    public function ajax_company_officeshift_information($id)
    {

        $sql = 'SELECT * FROM xin_office_shift WHERE company_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function get_airtickets($id)
    {
        $this->db->where('employee_id', $id);
        $this->db->order_by('date', 'desc');
        $query = $this->db->get("xin_airtickets");
        return $query;
    }

    public function get_airticket($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get("xin_airtickets");
        return $query->row();
    }

    public function get_car_travelsdata($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get("car_travel");
        return $query->row();
    }
    public function get_accomodationdata($id)
    {
        $this->db->where('id', $id);
        $query = $this->db->get("accomodation");
        return $query->row();
    }
    public function delete_accomodation($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('accomodation');
    }
    public function get_car_travels($id)
    {
        $this->db->where('user_id', $id);
        $this->db->order_by('created_at', 'desc');
        $query = $this->db->get("car_travel");
        return $query;
    }
    public function get_accomodation($id)
    {
        $this->db->where('user_id', $id);
        $this->db->order_by('created_at', 'desc');
        $query = $this->db->get("accomodation");
        return $query;
    }
    public function delete_airticket($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('xin_airtickets');
    }
    public function delete_cartravels($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('car_travel');
    }
    public function save_car_travel_data($data)
    {
        $this->db->insert('car_travel', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function save_accomodation_data($data)
    {
        $this->db->insert('accomodation', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function employee_under_probation($id)
    {
        $employee = $this->Employees_model->read_employee_information($id);
        $date_joining = strtotime($employee[0]->date_of_joining);
        $diff = time() - $date_joining;
        $months = floor($diff / (60 * 60 * 24 * 30));

        if ($months <= 3) {
            return true;
        }

        return false;
    }
    public function emp_leave($id, $start_date_y)
    {

        $sql = "Select  *,SUM(days) as total_leaves FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id WHERE employee_id=? and p.from_date LIKE '%$start_date_y%' GROUP BY type_name";

        $binds = array($id);

        $query = $this->db->query($sql, $binds);

        //	print_r($query);exit;

        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }
    public function empLeaveFetchForIndemnintyCalc($id, $start_date_y, $end_date_y)
    {
        $sql = "Select  *,SUM(days) as total_leaves FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id WHERE employee_id=? and p.status='2' and (p.from_date >= '$start_date_y' AND p.to_date <= '$end_date_y') GROUP BY type_name";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_leave_fetch($id, $start_date_y)
    {
        $sql = "Select  *,SUM(days) as total_leaves FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id WHERE employee_id=? and p.status='2' and (p.from_date LIKE '%$start_date_y%' OR p.to_date LIKE '%$start_date_y%') GROUP BY type_name";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_leave_in_month_year($id, $start_date_y_m, $type)
    {
        $sql = "Select SUM(days) as monthly_leaves FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id WHERE employee_id=? and p.status='2' and p.leave_type_id=? and p.from_date LIKE '%$start_date_y_m%'";

        $binds = array($id, $type);

        $query = $this->db->query($sql, $binds);

        $result = $query->result();

        //	print_r($result[0]->monthly_leaves);exit;

        return $result[0]->monthly_leaves;
    }

    public function emp_leave_in_year($id, $start_date_y)
    {



        $sql = "Select * FROM xin_leave_applications as p left join xin_leave_type as q on p.leave_type_id=q.leave_type_id WHERE employee_id=? and p.leave_type_id='2' and p.from_date LIKE '%$start_date_y%'";

        $binds = array($id);

        $query = $this->db->query($sql, $binds);

        //	print_r($query);exit;

        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }

    public function get_employee_data($id)
    {

        $sql = "Select xin_office_location.late_deduction FROM xin_employees left join xin_office_location on xin_employees.location_id=xin_office_location.location_id WHERE xin_employees.user_id='$id'";
        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function final_settlement()
    {
        $sql = "SELECT * FROM xin_employees WHERE resignation_date!='' order by resignation_date DESC";
        $query = $this->db->query($sql);
        return $query;
    }
    public function get_company_employees_final($cid)
    {
        $sql = "SELECT * FROM xin_employees WHERE company_id = ? and resignation_date!='' order by resignation_date DESC";
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function get_company_location_employees_final($cid, $lid)
    {
        $sql = " SELECT * FROM xin_employees WHERE company_id = ? and location_id = ? and resignation_date!='' order by resignation_date DESC";
        $binds = array($cid, $lid);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function get_company_location_department_employees_final($cid, $lid, $dep_id)
    {
        $sql = "SELECT * FROM xin_employees WHERE company_id = ? and location_id = ? and department_id = ? and resignation_date!='' order by resignation_date DESC";
        $binds = array($cid, $lid, $dep_id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function get_company_location_department_designation_employees_final($cid, $lid, $dep_id, $des_id)
    {
        $sql = "SELECT * FROM xin_employees WHERE company_id = ? and location_id = ? and department_id = ? and designation_id = ? and resignation_date!='' order by resignation_date DESC";
        $binds = array($cid, $lid, $dep_id, $des_id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function doc($id)
    {
        $sql = "Select  * FROM final_settlement_docs where employee_id=? ";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }


    public function getempname($postData)
    {

        $response = array();

        if (isset($postData['search'])) {
            // Select record
            $this->db->select('*');
            $this->db->where("first_name like '%" . $postData['search'] . "%' ");
            $this->db->or_where("last_name like '%" . $postData['search'] . "%' ");
            $records = $this->db->get('xin_employees')->result();

            foreach ($records as $row) {
                $response[] = array("label" => $row->first_name . " " . $row->last_name);
            }
        }

        return $response;
    }


    public function getempid($postData)
    {

        $response = array();

        if (isset($postData['search'])) {
            // Select record
            $this->db->select('*');
            $this->db->where("employee_id like '%" . $postData['search'] . "%' ");

            $records = $this->db->get('xin_employees')->result();

            foreach ($records as $row) {
                $response[] = array("label" => $row->employee_id);
            }
        }

        return $response;
    }




    public function get_userid_fromempname($first_name, $last_name)
    {

        $sql = "Select user_id FROM xin_employees where first_name=? and last_name =? ";
        $binds = array($first_name, $last_name);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function getemp_pending_expenseclaims($id)
    {

        $sql = 'SELECT * FROM xin_expense_clame WHERE employee_id = ? AND status != ? AND paid = 0';
        $binds = array($id, 3);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }


    public function get_userid_fromempid($id)
    {
        $sql = "Select user_id FROM xin_employees where employee_id=? ";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function update_final_remark($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->update('xin_employees', $data)) {
            return true;
        } else {
            return false;
        }
    }

    public function delete_final_records($id)
    {
        /* $this->db->where('user_id', $id);
	    $this->db->delete('xin_employees');*/
        $this->db->where('employee_id', $id);
        $this->db->delete('final_settlement');
    }


    public function getbankcode($postData = array())
    {

        $response = array();

        if (isset($postData['bankname'])) {

            // Select record
            $this->db->select('*');
            $this->db->where('bankname', $postData['bankname']);
            $records = $this->db->get('xin_banks');
            $response = $records->result_array();
        }

        return $response;
    }

    public function getemp_encashamount($postData = array())
    {

        $response = array();

        if (isset($postData['placeto'])) {

            // Select record
            $this->db->select('*');
            $this->db->where('nationality_id', $postData['placeto']);
            $records = $this->db->get('airticket_encashments');
            $response = $records->result_array();
        }

        return $response;
    }

    public function getemp_no_of_tickets($postData = array())
    {

        $response = array();

        if (isset($postData['empid'])) {

            // Select record
            $this->db->select('*');
            $this->db->where('employee_id', $postData['empid']);
            $records = $this->db->get('xin_airtickets');
            $response = $records->result_array();
        }

        return $response;
    }

    public function getemp_date_of_join($postData = array())
    {

        $response = array();

        if (isset($postData['empid'])) {

            // Select record
            $this->db->select('*');
            $this->db->where('user_id', $postData['empid']);
            $records = $this->db->get('xin_employees');
            $response = $records->result_array();
        }

        return $response;
    }

public function delete_final_records_doc($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('final_settlement_docs');
    }

    public function final_doc($data)
    {
        $this->db->insert('final_settlement_docs', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }

    public function get_employee_date_of_join($id)
    {
        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->result();
    }

    public function get_employee_no_of_tickets($id)
    {
        $sql = 'SELECT * FROM xin_airtickets WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->result();
    }

    /*public function get_all_code($data_array){
		$company_id=$data_array['company_id'];
		$departments_id=$data_array['departments_id'];
		$designation_id=$data_array['designation_id'];
		$sql="Select  * FROM xin_companies  where company_id=? ";
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		$updated_employee_code='';
		if ($query->num_rows() > 0) {
			$result=$query->result();
			$company_code=$result[0]->company_code;
			$updated_employee_code .= $result[0]->company_code;
			$sql="Select  * FROM xin_departments  where department_id=? ";
			$binds = array($departments_id);
			$query = $this->db->query($sql, $binds);
			if ($query->num_rows() > 0) {
				$result=$query->result();
				$department_code=$result[0]->department_code;
				$updated_employee_code .= $result[0]->department_code;
				$sql="Select  * FROM xin_designations  where designation_id=? ";
				$binds = array($designation_id);
				$query = $this->db->query($sql, $binds);
					if ($query->num_rows() > 0) {
						$result=$query->result();
						$designation_code=$result[0]->designation_code;
						$updated_employee_code .= $result[0]->designation_code;
				        $serial_total_no = $result[0]->serial_total_no;
				        $serial_no = $result[0]->serial_total_no;
						if($company_code && $designation_code && $department_code && $serial_total_no){						   
							return $updated_employee_code;
						}else{
							return 0;
						}
					}else{
						return 0;
					}
			}else{
				return 0;
			}
		} else {
			return 0;
		}
	}*/
    public function get_all_code($data_array)
    {
        $company_id = $data_array['company_id'];
        $departments_id = $data_array['departments_id'];
        $designation_id = $data_array['designation_id'];
        $sql = "Select  * FROM xin_companies  where company_id=? ";
        $binds = array($company_id);
        $query = $this->db->query($sql, $binds);
        $updated_employee_code = '';
        if ($query->num_rows() > 0) {
            $result = $query->result();
            $company_code = $result[0]->company_code;
            $updated_employee_code .= $result[0]->company_code;
            $sql = "Select  * FROM xin_departments  where department_id=? ";
            $binds = array($departments_id);
            $query = $this->db->query($sql, $binds);
            if ($query->num_rows() > 0) {
                $result = $query->result();
                $department_code = $result[0]->department_code;
                $updated_employee_code .= $result[0]->department_code;
                $sql = "Select  * FROM xin_designations  where designation_id=? ";
                $binds = array($designation_id);
                $query = $this->db->query($sql, $binds);
                if ($query->num_rows() > 0) {
                    $result = $query->result();
                    $designation_code = $result[0]->designation_code;
                    $updated_employee_code .= $result[0]->designation_code;
                    $serial_total_no = $result[0]->serial_total_no;
                    $serial_no = $result[0]->serial_total_no;
                    if ($company_code && $designation_code && $department_code && $serial_total_no) {
                        return $updated_employee_code;
                    } else {
                        return 0;
                    }
                } else {
                    return 0;
                }
            } else {
                return 0;
            }
        } else {
            return 0;
        }
    }
    public function update_dept_count($department_id)
    {
        $sql = "Select  * FROM xin_departments  where department_id=? ";
        $binds = array($department_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            $serial_total_no = 0;
            $department_serial_count = $query->result();
            $serial_total_no = $department_serial_count[0]->serial_total_no;
            $serial_total_no = $serial_total_no + 1;
            $data = array(
                'serial_total_no' => $serial_total_no
            );
            $this->db->where('department_id', $department_id);
            if ($this->db->update('xin_departments', $data)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    public function get_id($id)
    {
        $sql = "Select  employee_id FROM final_settlement  where final_settlement_id=? ";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_single_employee_indeminty($id)
    {
        $sql = 'SELECT * FROM xin_employee_indemnity WHERE id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function CheckEmployeeYearExistsIndemnity($userid)
    {
        $sql = "Select * FROM xin_employee_indemnity  where employee_id=? ";
        $binds = array($userid);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function GetFromAndToDateOfIndemnity($userid, $year)
    {
        $this->db->where('employee_id', $userid);
        $this->db->where('year', $year);
        $this->db->order_by('id', "desc")->limit(1);
        $query = $this->db->get("xin_employee_indemnity")->row();
        return $query;
    }
    public function emp_indemnity_fetch($id, $start_date_y)
    {
        $sql = "Select * FROM xin_employee_indemnity WHERE employee_id=? and (indemninty_month LIKE '%$start_date_y%') GROUP BY id";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_annuval_leave_fetch($id, $start_date_y)
    {
        $sql = "Select  *,SUM(days) as total_leaves FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and (from_date LIKE '%$start_date_y%' OR to_date LIKE '%$start_date_y%') GROUP BY employee_id";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function set_employee_allowances_for_leavesalary($id)
    {
        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ? and applicable_for_paysalary = ? and status = "Y"';
        $binds = array($id, 1);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_commissions_for_leavesalary($id)
    {
        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ? and applicable_for_paysalary = ? and status = "Y"';
        $binds = array($id, 1);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_statutory_deductions_for_leavesalary($id)
    {
        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ? and applicable_for_paysalary = ? and status = "Y"';
        $binds = array($id, 1);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function emp_total_annual_leaves_taken($user_id, $start_date_y)
    {
        $sql = "Select  *,SUM(days) as total_leaves FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and (from_date >= $start_date_y) GROUP BY employee_id";
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_total_annual_leaves_taken_new_di($user_id, $start_date_y)
    {
        $sql = "Select  *,SUM(days) as total_leaves FROM xin_annual_leave_applications WHERE employee_id=?  and (from_date >= $start_date_y) GROUP BY employee_id";
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function set_employee_deductions_leave_Salary($id)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ?';
        //$sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and applicable_for_paysalary = ? and loan_status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_other_payments_leave_salary($id)
    {
        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ? and applicable_for_paysalary = ? and status = "Y"';
        $binds = array($id, 1);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function read_all_employee_information($nationality_id)
    {
        if ($nationality_id > 0) {
            $sql = 'SELECT * FROM xin_employees WHERE nationality_id = ?';
            $binds = array($nationality_id);
            $query = $this->db->query($sql, $binds);
        } else {
            $sql = 'SELECT * FROM xin_employees WHERE nationality_id != ?';
            $binds = array(17);
            $query = $this->db->query($sql, $binds);
        }
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_single_salary_allowance_empid_alloid($id, $emp_id)
    {

        $sql = 'SELECT * FROM xin_salary_allowances WHERE allowance_title = ? and employee_id = ?';
        $binds = array($id, $emp_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_salary_commissions_empid_alloid($id, $emp_id)
    {

        $sql = 'SELECT * FROM xin_salary_commissions WHERE commission_title = ? and employee_id = ?';
        $binds = array($id, $emp_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_salary_deductions_empid_alloid($id, $emp_id)
    {

        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE deduction_title = ? and employee_id = ?';
        $binds = array($id, $emp_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_other_payments_empid_alloid($id, $emp_id)
    {

        $sql = 'SELECT * FROM xin_salary_other_payments WHERE payments_title  = ? and employee_id = ?';
        $binds = array($id, $emp_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_loans_empid_alloid($id, $emp_id)
    {
        $sql = 'SELECT * FROM  xin_salary_loan_deductions WHERE loan_options = ? and employee_id = ?';
        $binds = array($id, $emp_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function salary_other_payment_update_record_leave_salary($data, $id, $emp_id)
    {
        $this->db->where('payments_title', $id);
        $this->db->where('employee_id', $emp_id);
        if ($this->db->update('xin_salary_other_payments', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function salary_loan_update_record_leave_salary($data, $id, $emp_id)
    {
        $this->db->where('loan_options', $id);
        $this->db->where('employee_id', $emp_id);
        if ($this->db->update('xin_salary_loan_deductions', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function salary_deduction_update_record_leave_salary($data, $id, $emp_id)
    {
        $this->db->where('deduction_title', $id);
        $this->db->where('employee_id', $emp_id);
        if ($this->db->update('xin_salary_statutory_deductions', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function salary_commission_update_record_leave_salary($data, $id, $emp_id)
    {
        $this->db->where('commission_title', $id);
        $this->db->where('employee_id', $emp_id);
        if ($this->db->update('xin_salary_commissions', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function salary_allowance_update_record_leave_salary($data, $id, $emp_id)
    {
        $this->db->where('allowance_title', $id);
        $this->db->where('employee_id', $emp_id);
        if ($this->db->update('xin_salary_allowances', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function update_allowance_from_leavesalaries($data, $cond, $table)
    {
        $this->db->where($cond);
        if ($this->db->update($table, $data)) {
            return true;
        } else {
            return false;
        }
    }

    public function read_salary_allowances_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function count_employee_allowances_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function set_employee_allowances_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_allowances WHERE employee_id = ? and status = "Y" ';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_commissions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_statutory_deductions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function employee_encashment_check($id, $neq_mon)
    {
        $sql = 'SELECT * FROM xin_airticket_encashment_requests WHERE employee_id = ? and payroll_month = ? and status = "Approved"';
        $binds = array($id, $neq_mon);
        $query = $this->db->query($sql, $binds);
        return $query->result();
    }
    public function set_employee_other_payments_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_deductions_with_status($id, $status = null)
    {
        //$sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and loan_status = "Y"';
        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ?';
        if ($status)  $sql .= ' AND status = '.$status;
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function read_salary_loan_deductions_with_status_new($id, $date_month)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and MONTH(end_date) >= ? and MONTH(start_date) <= ? ';
        //$sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and loan_status = "Y"';
        $binds = array($id, $date_month, $date_month);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_salary_loan_deductions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and final_approval = 1';
        //$sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and loan_status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function count_employee_deductions_with_status_new($id, $date_month)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and MONTH(end_date) >= ? and MONTH(start_date) <= ? ';
        //$sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and loan_status = "Y"';
        $binds = array($id, $date_month, $date_month);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function count_employee_deductions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and final_approval = 1';
        //$sql = 'SELECT * FROM xin_salary_loan_deductions WHERE employee_id = ? and loan_status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function count_employee_commissions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function count_employee_other_payments_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function count_employee_statutory_deductions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function read_salary_commissions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_commissions WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_salary_other_payments_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_other_payments WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_salary_statutory_deductions_with_status($id)
    {
        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ? and status = "Y"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function get_employee_taken_leaves($leave)
    {
        $sql = 'SELECT * FROM xin_leave_applications WHERE leave_type_id = ?';
        $binds = array($leave);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_leave_taken_for_leave_his($empid, $start_date, $end_date, $leave_type_id)
    {
        $sql = "Select  *,SUM(leave_count) as total_leaves FROM employee_leave where employee_id=? and leave_type=? and (created_at  >= '$start_date' and created_at <='$end_date') and created_at != '0000-00-00' GROUP BY leave_type";
        $binds = array($empid, $leave_type_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_leave_taken_for_leave_not_year_calc($empid, $leave_type_id)
    {
        $sql = "Select  *,SUM(leave_count) as total_leaves FROM employee_leave where employee_id=? and leave_type=? and created_at != '0000-00-00' GROUP BY leave_type";
        $binds = array($empid, $leave_type_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function xin_count_leave_type_emp_taken($leave_cat, $employee_id, $starting_date, $ending_date)
    {
        $sql = "SELECT sum(days) as leave_count FROM xin_leave_applications WHERE leave_type_id = ? and employee_id=? and (from_date  >= '$starting_date' and to_date <='$ending_date' and status = 2)";
        $binds = array($leave_cat, $employee_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function add_leave_carry_forward($data)
    {
        $this->db->insert('xin_employees_leave_carryfowards', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function check_already_exists_leave_carryforward($cond)
    {
        $this->db->select('*');
        $this->db->from('xin_employees_leave_carryfowards');
        $this->db->where($cond);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array();
        }
    }
    function edit_common($table, $condition = array(), $data_array = array())
    {
        if ($condition) {
            $this->db->where($condition);
        }
        if ($this->db->update($table, $data_array)) {
            return true;
        } else {
            return false;
        }
    }
    public function check_already_exists_leave_encashment($cond)
    {
        $this->db->select('*');
        $this->db->from('xin_employees_leave_encashment');
        $this->db->where($cond);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array();
        }
    }
    public function add_employees_leave_encashment($data)
    {
        $this->db->insert('xin_employees_leave_encashment', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }

    public function add_employees_leave_encashment_new($data)
    {
        $this->db->insert('xin_encashment', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }


    public function xin_count_leave_type_emp_taken_annual($leave_cat, $employee_id, $starting_date, $ending_date)
    {
        $sql = "SELECT sum(days) as leave_count FROM xin_annual_leave_applications WHERE employee_id=? and (from_date  >= '$starting_date' and to_date <='$ending_date') and status = 2";
        $binds = array($employee_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function get_all_leave_carryforward_leave_annual($leave_type, $emp_id, $starting_date, $ending_date)
    {
        $this->db->select('*, sum(total) as leave_count_total');
        $this->db->from('xin_employees_leave_carryfowards');
        $this->db->join('xin_annual_leave_applications', 'xin_employees_leave_carryfowards.employee_id = xin_annual_leave_applications.employee_id');
        $this->db->where('xin_employees_leave_carryfowards.leave_type_id', $leave_type);
        $this->db->where('xin_employees_leave_carryfowards.employee_id', $emp_id);
        $this->db->where('xin_employees_leave_carryfowards.leave_start_date <', $starting_date);
        $this->db->where('xin_annual_leave_applications.status', 2);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array();
        }
    }
    public function get_all_leave_carryforward_leave($leave_type, $emp_id, $starting_date, $ending_date)
    {
        $this->db->select('*, sum(total) as leave_count_total');
        $this->db->from('xin_employees_leave_carryfowards');
        $this->db->join('xin_leave_applications', 'xin_employees_leave_carryfowards.employee_id = xin_leave_applications.employee_id');
        $this->db->where('xin_employees_leave_carryfowards.leave_type_id', $leave_type);
        $this->db->where('xin_employees_leave_carryfowards.employee_id', $emp_id);
        $this->db->where('xin_employees_leave_carryfowards.leave_start_date <', $starting_date);
        $this->db->where('xin_leave_applications.status', 2);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array();
        }
    }
    public function emp_leave_encashment_fetch($id, $start_date_y)
    {
        $sql = "Select * FROM xin_employees_leave_encashment WHERE employee_id=? and (retrive_month LIKE '%$start_date_y%') GROUP BY id";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function count_employee_leave_encashment_payslip($id)
    {
        $sql = 'SELECT * FROM  xin_employees_leave_encashment WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function set_employee_leave_encashment_payslip($id)
    {
        $sql = 'SELECT * FROM  xin_employees_leave_encashment WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function delete_current_employee_leaves($id)
    {
        $this->db->where('employee_id', $id);
        $this->db->delete('employee_leave');
    }
    public function available_leaves_emp_check($id, $leave_id)
    {
        $sql = 'SELECT * FROM employee_leave WHERE employee_id = ? and leave_type = ? GROUP BY leave_type';
        $binds = array($id, $leave_id);
        $query = $this->db->query($sql, $binds);
        return $query->result();
    }
    public function delete_current_employee_leaves_carryforward($cond)
    {
        $this->db->where($cond);
        $this->db->delete('xin_employees_leave_carryfowards');
    }
    public function delete_current_employee_leaves_encashment($cond)
    {
        $this->db->where($cond);
        $this->db->delete('xin_employees_leave_encashment');
    }
    public function work_day($year, $month)
    {
        $startdate = strtotime($year . '-' . $month . '-01');
        $enddate = strtotime('+' . (date('t', $startdate) - 1) . ' days', $startdate);
        $currentdate = $startdate;
        $return = intval((date('t', $startdate)), 10);
        //loop through the dates, from the start date to the end date
        while ($currentdate <= $enddate) {
            //if you encounter a Saturday or Sunday, remove from the total days count
            if ((date('D', $currentdate) == 'Sat') || (date('D', $currentdate) == 'Sun')) {
                $return = $return - 1;
            }
            $currentdate = strtotime('+1 day', $currentdate);
        } //end date walk loop
        //return the number of working days
        return $return;
    }
    public function set_employee_allowances_payslip_final($make_payment_id, $eid, $date)
    {

        $sql = 'SELECT * FROM xin_salary_payslip_allowances left join allowance on id=allowance_title WHERE payslip_id = ? and employee_id= ? and salary_month=?';
        $binds = array($make_payment_id, $eid, $date);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function get_employee_commissions($id, $start_date_y_m)
    {
        $sql = 'SELECT * FROM xin_salary_payslips  WHERE employee_id = ?  and salary_month =?';
        $binds = array($id, $start_date_y_m);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function set_employee_statutory_deductions_payslip_final($make_payment_id, $eid, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions  left join allowance on id=deduction_title  WHERE payslip_id = ? and employee_id= ? and salary_month=?';
        $binds = array($make_payment_id, $eid, $date);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_deductions_payslip_final($make_payment_id, $eid, $pay_date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_loan  WHERE payslip_id = ? and employee_id= ? and salary_month=?';
        $binds = array($make_payment_id, $eid, $pay_date);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function set_employee_commissions_payslip_final($make_payment_id, $eid, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_commissions allowances left join allowance on id=commission_title WHERE payslip_id = ? and employee_id= ? and salary_month=?';
        $binds = array($make_payment_id, $eid, $date);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function GetCarryLeavesAnnual($leave_type, $emp_id, $starting_date, $ending_date)
    {
        $sql = 'SELECT * FROM carry_leaves  WHERE employee_id = ? and leave_type_id = ?  order by create_date desc limit 1';
        $binds = array($emp_id, $leave_type);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    public function emp_total_annual_leaves_taken_new($user_id, $start_date_y)
    {
        $sql = "Select * FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and (from_date >= $start_date_y)";
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_total_annual_leaves_taken_not_paid($user_id, $start_date_y)
    {
        $sql = "Select *,SUM(days) as total_ann FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and (from_date LIKE '%$start_date_y%' OR to_date LIKE '%$start_date_y%') ORDER By applied_on desc limit 1";
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_total_annual_leaves_taken_paid($user_id, $start_date_y)
    {
        $sql = "Select * FROM xin_annual_leave_applications WHERE employee_id=? and status='2'  and paid_status = 'Y' ORDER By applied_on desc limit 1";
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function annual_leave_details_by_id($id)
    {
        $sql = "Select * FROM xin_annual_leave_applications WHERE id=? ";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function delete_payslip_annual_leave($data, $id)
    {
        $this->db->where('payslip_id', $id);
        if ($this->db->update('xin_annual_leave_applications', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function emp_total_annual_leaves_taken_not_paid_check($user_id, $start_date_y)
    {
        $sql = "Select * FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and (from_date >= $start_date_y) and paid_status = 'N' ORDER By applied_on desc limit 1";
        $binds = array($user_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function count_employee_annual_leave_payslip($id)
    {
        $sql = 'SELECT * FROM  xin_annual_leave_applications WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    public function set_employee_leave_annual_payslip($id)
    {
        $sql = 'SELECT * FROM  xin_annual_leave_applications WHERE payslip_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function get_gosi($id)
    {
        $sql = 'SELECT * FROM xin_salary_statutory_deductions WHERE employee_id = ? and deduction_title = "7"';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function get_working_days($date1, $date2, $workSat = FALSE, $patron = NULL)
    {
        if (!defined('SATURDAY')) define('SATURDAY', 6);
        if (!defined('SUNDAY')) define('SUNDAY', 0);
        // Array of all public festivities
        $publicHolidays = array('01-01', '01-06', '04-25', '05-01', '06-02', '08-15', '11-01', '12-08', '12-25', '12-26');
        // The Patron day (if any) is added to public festivities
        if ($patron) {
            $publicHolidays[] = $patron;
        }

        /*
			* Array of all Easter Mondays in the given interval
			*/
        $yearStart = date('Y', strtotime($date1));
        $yearEnd   = date('Y', strtotime($date2));
        for ($i = $yearStart; $i <= $yearEnd; $i++) {
            $easter = date('Y-m-d', easter_date($i));
            list($y, $m, $g) = explode("-", $easter);
            $monday = mktime(0, 0, 0, date($m), date($g) + 1, date($y));
            $easterMondays[] = $monday;
        }
        $start = strtotime($date1);
        $end   = strtotime($date2);
        $workdays = 0;
        for ($i = $start; $i <= $end; $i = strtotime("+1 day", $i)) {
            $day = date("w", $i);  // 0=sun, 1=mon, ..., 6=sat
            $mmgg = date('m-d', $i);
            if (
                $day != SUNDAY &&
                !in_array($mmgg, $publicHolidays) &&
                !in_array($i, $easterMondays) &&
                !($day == SATURDAY && $workSat == FALSE)
            ) {
                $workdays++;
            }
        }
        return intval($workdays);
    }
    public function employee_exist($id)
    {
        $sql = 'SELECT * FROM xin_employees WHERE employee_id = ? ';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function add_employee_attendance($data)
    {
        $this->db->insert('xin_attendance_time', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function get_last_serial_no($department_id, $designation_id)
    {
        $sql = "Select  serial_no FROM xin_employees WHERE designation_id='$designation_id' AND department_id='$department_id' order by user_id desc limit 1";
        $binds = array();
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            $result = $query->result();
            return $result[0]->serial_no;
        } else {
            return null;
        }
    }
    public function get_last_serial_no_d($department_id, $designation_id)
    {
        $sql = "Select  serial_no FROM xin_employees WHERE designation_id='$designation_id' AND department_id='$department_id' order by user_id desc limit 1";
        $binds = array();
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            $result = $query->result();
            return $result[0]->serial_no;
        } else {
            return null;
        }
    }
    public function read_salary_loan_deductions_with_loan_id($id, $loan_id)
    {
        $sql = 'SELECT *,SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan WHERE employee_id = ? and loan_id = ?';
        $binds = array($id, $loan_id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function insert_final_settlemet_details($data)
    {
        $this->db->insert('final_settlement', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function check_emp_final_settlement_details_exists($id)
    {
        $sql = 'SELECT * FROM final_settlement WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function update_final_Settlement_record($data, $id)
    {
        $this->db->where('final_settlement_id', $id);
        if ($this->db->update('final_settlement', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function email_validation($email)
    {
        $sql = 'SELECT * FROM xin_employees WHERE email = ? ';
        $binds = array($email);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function mobile_validation($mob)
    {
        $sql = 'SELECT * FROM xin_employees WHERE contact_no = ? ';
        $binds = array($mob);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function employee_code($code)
    {
        $sql = 'SELECT * FROM xin_employees WHERE employee_code = ? ';
        $binds = array($code);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function employee_id($id)
    {
        $sql = 'SELECT * FROM xin_employees WHERE employee_id = ? ';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function validate_mobile($mobile)
    {
        print_r(preg_match('/^[0-9]{10}+$/', $mobile));
    }

    public function read_user_by_employee_id($id)
    {



        $sql = 'SELECT * FROM xin_employees WHERE employee_id = ?';

        $binds = array($id);

        $query = $this->db->query($sql, $binds);



        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }

    public function new_employee_attendance($data)
    {
        $this->db->insert('new_attendance_time', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function get_last_serial_no_emp($dept_code, $designation_code)
    {
        $sql = 'SELECT * FROM xin_employees WHERE dept_code = ? and designation_code = ? order by serial_no  desc limit 1';
        $binds = array($dept_code, $designation_code);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function employee_get_leave($id)
    {
        $sql = 'SELECT leave_categories FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {

            return null;
        }
    }
    public function set_employee_sal_history_by_id($id, $history_type, $allow_id)
    {
        $sql = 'SELECT * FROM xin_employee_salary_history WHERE employee_id = ? and history_type = ? and allowance_id = ? ORDER BY id DESC';
        $binds = array($id, $history_type, $allow_id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function GetCheckEmployeeIncHistoryExits($start_date, $end_date)
    {
        $sql = 'SELECT * FROM xin_employee_salary_history WHERE  (date >= ? and date <= ? ) ORDER BY id DESC';
        $binds = array($start_date, $end_date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function all_user_for_expiry_notify($cid)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_role_id = ?';
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function check_Immg_doc_exp($module_name, $mode_id, $emp_id)
    {

        $sql = "SELECT * FROM xin_hrsale_notificaions WHERE module_id = ? and employee_id = ? and module_name = ?";
        $binds = array($mode_id, $emp_id, $module_name);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function delete_exists_notification_expiry($module_name, $mode_id, $emp_id)
    {
        $this->db->where('module_id', $mode_id);
        $this->db->where('employee_id', $emp_id);
        $this->db->where('module_name', $module_name);
        $this->db->delete('xin_hrsale_notificaions');
    }
    public function get_employee_bank_account_last_first($id)
    {
        $sql = 'SELECT * FROM xin_employee_bankaccount WHERE employee_id = ? order by bankaccount_id desc limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function add_salary_loan_month_wise_dedec($data)
    {
        $this->db->insert('xin_salary_loan_deductions_monthwise', $data);
        if ($this->db->affected_rows() > 0) {
            return  $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function get_employee_loan_distrubtion($id, $loan_id)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions_monthwise WHERE employee_id = ? and loan_id = ?';
        $binds = array($id, $loan_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function salary_loan_distrubution_record($data, $id)
    {
        $this->db->where('id', $id);
        if ($this->db->update('xin_salary_loan_deductions_monthwise', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function delete_loan_distribution_list($id, $loan_id)
    {
        $this->db->where('loan_id', $loan_id);
        $this->db->where('employee_id', $id);
        $this->db->delete('xin_salary_loan_deductions_monthwise');
    }
    public function delete_loan_distribution_list_de($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('xin_salary_loan_deductions_monthwise');
    }
    public function get_employee_loan_distrubtion_latest($id, $loan_id)
    {
        $sql = 'SELECT * FROM xin_salary_loan_deductions_monthwise WHERE employee_id = ? and loan_id = ? order by id desc limit 1';
        $binds = array($id, $loan_id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // Function to add record in table > visa info
    public function visa_info_add($data)
    {
        $this->db->insert('xin_visa', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function set_employee_visa($id)
    {

        $sql = 'SELECT * FROM xin_visa WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function read_visadocument_information($id)
    {

        $sql = 'SELECT * FROM xin_visa WHERE visa_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    // Function to update record in table > document_info_update
    public function visa_info_update($data, $id)
    {
        $this->db->where('visa_id', $id);
        if ($this->db->update('xin_visa', $data)) {
            return true;
        } else {
            return false;
        }
    }
    // Function to Delete selected record from table
    public function delete_visa_record($id)
    {
        $this->db->where('visa_id', $id);
        $this->db->delete('xin_visa');
    }
    public function passport_info_add($data)
    {
        $this->db->insert('xin_passport', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function set_employee_passport($id)
    {

        $sql = 'SELECT * FROM xin_passport WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function read_passportdocument_information($id)
    {

        $sql = 'SELECT * FROM xin_passport WHERE passport_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function passport_info_update($data, $id)
    {
        $this->db->where('passport_id', $id);
        if ($this->db->update('xin_passport', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function delete_passport_record($id)
    {
        $this->db->where('passport_id', $id);
        $this->db->delete('xin_passport');
    }
    public function cpr_info_add($data)
    {
        $this->db->insert('xin_cpr', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function set_employee_cpr($id)
    {

        $sql = 'SELECT * FROM xin_cpr WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function read_cprdocument_information($id)
    {

        $sql = 'SELECT * FROM xin_cpr WHERE cpr_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function cpr_info_update($data, $id)
    {
        $this->db->where('cpr_id', $id);
        if ($this->db->update('xin_cpr', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function delete_cpr_record($id)
    {
        $this->db->where('cpr_id', $id);
        $this->db->delete('xin_cpr');
    }
    public function insurance_info_add($data)
    {
        $this->db->insert('xin_insurance', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function set_employee_insurance($id)
    {

        $sql = 'SELECT * FROM xin_insurance WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function read_insurancedocument_information($id)
    {

        $sql = 'SELECT * FROM xin_insurance WHERE insurance_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function insurance_info_update($data, $id)
    {
        $this->db->where('insurance_id', $id);
        if ($this->db->update('xin_insurance', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function delete_insurance_record($id)
    {
        $this->db->where('insurance_id', $id);
        $this->db->delete('xin_insurance');
    }
    public function license_info_add($data)
    {
        $this->db->insert('xin_license', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function set_employee_license($id)
    {

        $sql = 'SELECT * FROM xin_license WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function read_licensedocument_information($id)
    {

        $sql = 'SELECT * FROM xin_license WHERE license_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function license_info_update($data, $id)
    {
        $this->db->where('license_id', $id);
        if ($this->db->update('xin_license', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function delete_license_record($id)
    {
        $this->db->where('license_id', $id);
        $this->db->delete('xin_license');
    }
    public function get_visa_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_visa where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_user_visa_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_visa where employee_id = '" . $employee_id . "' and expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_passport_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_passport where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_user_passport_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_passport where employee_id = '" . $employee_id . "' and expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_cpr_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_cpr where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_user_cpr_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_cpr where employee_id = '" . $employee_id . "' and expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_insurance_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_insurance where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_user_insurance_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_insurance where employee_id = '" . $employee_id . "' and expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_license_expired_all()
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_license where expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function get_user_license_expired_all($employee_id)
    {

        $curr_date = date('Y-m-d');
        $query = $this->db->query("SELECT * from xin_license where employee_id = '" . $employee_id . "' and expiry_date < '" . $curr_date . "' ORDER BY `expiry_date` asc");
        return $query;
    }
    public function vehicle_info_add($data)
    {
        $this->db->insert('xin_vehicle', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    public function set_employee_vehicle($id)
    {

        $sql = 'SELECT * FROM xin_vehicle WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query;
    }
    public function vehicle_info_update($data, $id)
    {
        $values = serialize($data);
        $this->db->set('local_store', $values);
        $this->db->where('id', $id);
        if ($this->db->update('xin_vehicle')) {
            return true;
        } else {
            return false;
        }
        // 			$this->db->where('id', $id);
        // 			if( $this->db->update('xin_vehicle',$data)) {
        // 				return true;
        // 			} else {
        // 				return false;
        // 			}		
    }
    public function delete_vehicle_record($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('xin_vehicle');
    }
    public function read_vehicledocument_information($id)
    {

        $sql = 'SELECT * FROM xin_vehicle WHERE id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function vehicle($id)
    {

        $sql = 'SELECT * FROM vehicle WHERE vehicle_id = ? limit 1';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function dlt_loan_distrbutions($emp_id, $loan_id)
    {
        $this->db->where('loan_id', $loan_id);
        $this->db->where('employee_id', $emp_id);
        $this->db->delete('xin_salary_loan_deductions_monthwise');
    }

    public function get_holidays($id)
    {
        $sql = "Select * FROM xin_holidays where company_id=? and is_publish = 1";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function get_halfdays($id)
    {
        $sql = "Select * FROM xin_leave_applications where employee_id= $id AND is_half_day = 1 AND final_approval = 1";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_employee_ot_total($id, $month, $year)
    {

        $sql = 'SELECT SUM(ot_amount) as totalrate FROM xin_attendance_time WHERE employee_id = ? AND monthname(attendance_date)= ? AND year(attendance_date)= ? AND ot= "yes"';
        $binds = array($id, $month, $year);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_employee_overtime_total($id, $month, $year)
    {

        $sql = 'SELECT SUM(ot_amount) as totalrate FROM xin_attendance_time WHERE employee_id = ? AND month(attendance_date)= ? AND year(attendance_date)= ? AND ot = "yes"';
        $binds = array($id, $month, $year);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_management_status($location_id, $monthyear)
    {

        $sql = "SELECT * FROM management_payroll_approval WHERE month_year = '$monthyear' AND location_id = '$location_id' OR location_id = 0";
        $query = $this->db->query($sql);
        return $query->result();
    }
    
    public function get_management_employee_status($employee_id, $location_id, $monthyear)
    {

        $sql = "SELECT * FROM management_payroll_approval WHERE employee_id = '$employee_id' AND month_year = '$monthyear' AND location_id = '$location_id' OR location_id = 0";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_bank_details($id)
    {

        $sql = 'SELECT * FROM xin_employee_bankaccount WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function read_user_by_user_id($id)
    {

        $sql = "SELECT * FROM xin_employees WHERE user_id = '$id'";

        /*$binds = array($id);*/

        $query = $this->db->query($sql);


        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }

    public function get_employee_overtimedetails($id, $month, $year)
    {

        $sql = 'SELECT * FROM xin_attendance_time_total WHERE employee_id = ? AND month(date)= ? AND year(date)= ? AND ot_seconds > 0 ORDER BY date';
        $binds = array($id, $month, $year);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_employee_salary($id)
    {

        $sql = 'SELECT basic_salary FROM xin_employees WHERE user_id = ? ';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_work_lastdate($id)
    {
        $sql = "Select date_of_leaving FROM xin_employees WHERE employee_id='$id'";
        $binds = array();
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            $result = $query->result();
            return $result[0]->date_of_leaving;
        } else {
            return null;
        }
    }
    
    public function get_work_firstdate($id){
	    $sql="Select date_of_joining FROM xin_employees WHERE employee_id='$id'";
		$binds = array();
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
		    $result=$query->result();
			return $result[0]->date_of_joining;
		} else {
			return null;
		}
	}

    public function add_employee_overtimedata($data)
    {
        $this->db->insert('overtime_rates', $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function get_employee_overtimestatus($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }
    public function read_employee_his_info_by_id($id)
    {
        $sql = 'SELECT * FROM xin_employee_salary_history WHERE id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function get_import_status($user_id, $date, $clock_in3, $clock_out3)
    {
        $sql = "SELECT * FROM xin_attendance_time WHERE employee_id = '$user_id' and attendance_date = '$date' and clock_in = '$clock_in3' and clock_out = '$clock_out3'";
        /*$binds = array($user_id,$date,$clock_in3,$clock_out3);*/
        $query = $this->db->query($sql);
        return $query->num_rows();
    }

    public function get_employee_latedetails($id, $month, $year)
    {

        $sql = 'SELECT DISTINCT attendance_date FROM xin_attendance_time WHERE employee_id = ? AND month(attendance_date)= ? AND year(attendance_date)= ?';
        $binds = array($id, $month, $year);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_employee_latecome_deduct($id, $day)
    {

        $sql = "SELECT late_by_hours FROM xin_attendance_time WHERE employee_id = '$id' AND attendance_date= '$day'";
        /*$binds = array($id,"'$day'");*/
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_employee_workdone($id, $day)
    {

        $sql = "SELECT SUM(total_work_hours) as totalhours  FROM xin_attendance_time WHERE employee_id = '$id' AND attendance_date= '$day'";
        /*$binds = array($id,"'$day'");*/
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function getemployeelatedetails($id, $month, $year)
    {

        $sql = "SELECT DISTINCT attendance_date FROM xin_attendance_time WHERE employee_id = '$id' AND month(attendance_date)= '$month' AND year(attendance_date)= '$year'";
        /*$binds = array($id,$month,$year);*/
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_employeelate_details($id, $month, $year)
    {

        $sql = "SELECT DISTINCT attendance_date FROM xin_attendance_time WHERE employee_id = '$id' AND monthname(attendance_date)= '$month' AND year(attendance_date)= '$year'";
        /*$binds = array($id,$month,$year);*/
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_employee_details($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_employee_fulldetails($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_lateallowed($id)
    {

        $sql = 'SELECT * FROM xin_office_shift WHERE company_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function get_lateallowed_foremployee($id)
    {

        $sql = 'SELECT * FROM xin_office_shift WHERE office_shift_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        return $query->result();
    }

    public function attendence_exists_check($id, $month, $year)
    {
        $sql = "SELECT DISTINCT attendance_date FROM xin_attendance_time WHERE employee_id = '$id' AND month(attendance_date)= '$month' AND year(attendance_date)= '$year'";
        // $binds = array($id);
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function  last_attendence_in_a_month($id, $month, $year)
    {
        $sql = "SELECT attendance_date FROM xin_attendance_time WHERE employee_id = '$id' AND month(attendance_date)= '$month' AND year(attendance_date)= '$year' order by attendance_date desc limit 1";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function get_employeecode_duplication($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE employee_code = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }



    public function set_employees_leave_salary($category, $employee_id = 0)
    {
        if ($category == 'bahraini') {
            $nationality_id = 17;
        } else {
            $nationality_id = 0;
            $category = 'expat';
        }

        $this->db->where('category', $category);
        $leave_salary_info = $this->db->get('leave_salaries')->row();

        if (!$leave_salary_info) {
            return false;
        }

        $allowances = array();
        if (!empty($leave_salary_info->allowances))
            $allowances = unserialize($leave_salary_info->allowances);

        $commissions = array();
        if (!empty($leave_salary_info->commissions))
            $commissions = unserialize($leave_salary_info->commissions);

        $deductions = array();
        if (!empty($leave_salary_info->deductions))
            $deductions = unserialize($leave_salary_info->deductions);

        $other_payments = array();
        if (!empty($leave_salary_info->other_payments))
            $other_payments = unserialize($leave_salary_info->other_payments);

        $loan = array();
        if (!empty($leave_salary_info->loan))
            $loan = unserialize($leave_salary_info->loan);

        $employees = $this->Employees_model->read_all_employee_information($nationality_id);

        $get_all_employees = array();

        if ($employee_id > 0) {
            foreach ($employees as $emp) {
                if ($emp->user_id != $employee_id)
                    continue;

                $get_all_employees[] = $emp;
            }
        }

        $insert_id = $leave_salary_info->id;

        if (!empty($allowances)) {
            foreach ($get_all_employees as $emp) {
                foreach ($allowances as $allo) {
                    $allo_exists_or_not = $this->Employees_model->read_single_salary_allowance_empid_alloid($allo, $emp->user_id);
                    if (empty($allo_exists_or_not)) {
                        $data = array(
                            'allowance_title' => $allo,
                            'allowance_amount' => 0,
                            'employee_id' => $emp->user_id,
                            'is_allowance_taxable' => 0,
                            'amount_option' => 0,
                            'applicable_for_paysalary' => 1,
                            'leave_salaries_id' => $insert_id
                        );
                        $result = $this->Employees_model->add_salary_allowances($data);
                    } else {
                        $data = array(
                            'applicable_for_paysalary' => 1,
                        );
                        $result = $this->Employees_model->salary_allowance_update_record_leave_salary($data, $allo, $emp->user_id);
                    }
                }
            }
        }

        if (!empty($commissions)) {
            foreach ($get_all_employees as $emp) {
                foreach ($commissions as $commi) {
                    $allo_exists_or_not = $this->Employees_model->read_salary_commissions_empid_alloid($commi, $emp->user_id);
                    if (empty($allo_exists_or_not)) {
                        $data = array(
                            'commission_title' => $commi,
                            'commission_amount' => 0,
                            'employee_id' => $emp->user_id,
                            'is_commission_taxable' => 0,
                            'amount_option' => 0,
                            'applicable_for_paysalary' => 1,
                            'leave_salaries_id' => $insert_id
                        );
                        $result = $this->Employees_model->add_salary_commissions($data);
                    } else {
                        $data = array(
                            'applicable_for_paysalary' => 1,
                        );
                        $result = $this->Employees_model->salary_commission_update_record_leave_salary($data, $commi, $emp->user_id);
                    }
                }
            }
        }

        if (!empty($deductions)) {
            foreach ($get_all_employees as $emp) {
                foreach ($deductions as $deduct) {
                    $allo_exists_or_not = $this->Employees_model->read_salary_deductions_empid_alloid($deduct, $emp->user_id);
                    if (empty($allo_exists_or_not)) {
                        $data = array(
                            'deduction_title' => $deduct,
                            'deduction_amount' => 0,
                            'employee_id' => $emp->user_id,
                            'statutory_options' => 0,
                            'applicable_for_paysalary' => 1,
                            'leave_salaries_id' => $insert_id
                        );
                        $result = $this->Employees_model->add_salary_statutory_deductions($data);
                    } else {
                        $data = array(
                            'applicable_for_paysalary' => 1,
                        );
                        $result = $this->Employees_model->salary_deduction_update_record_leave_salary($data, $deduct, $emp->user_id);
                    }
                }
            }
        }
        if (!empty($other_payments)) {
            foreach ($get_all_employees as $emp) {
                foreach ($other_payments as $other_pay) {
                    $allo_exists_or_not = $this->Employees_model->read_other_payments_empid_alloid($other_pay, $emp->user_id);
                    if (empty($allo_exists_or_not)) {
                        $data = array(
                            'payments_title' => $other_pay,
                            'payments_amount' => 0,
                            'employee_id' => $emp->user_id,
                            'amount_option' => 0,
                            'is_otherpayment_taxable' => 0,
                            'applicable_for_paysalary' => 1,
                            'leave_salaries_id' => $insert_id
                        );
                        $result = $this->Employees_model->add_salary_other_payments($data);
                    } else {
                        $data = array(
                            'applicable_for_paysalary' => 1,
                        );
                        $result = $this->Employees_model->salary_other_payment_update_record_leave_salary($data, $other_pay, $emp->user_id);
                    }
                }
            }
        }
        if (!empty($loan)) {
            foreach ($get_all_employees as $emp) {
                foreach ($loan as $loans) {
                    $allo_exists_or_not = $this->Employees_model->read_loans_empid_alloid($loans, $emp->user_id);
                    if (empty($allo_exists_or_not)) {
                        $data = array(
                            'loan_options' => $loans,
                            'loan_deduction_amount' => 0,
                            'employee_id' => $emp->user_id,
                            'is_deducted_from_salary' => 0,
                            'status' => 0,
                            'applicable_for_paysalary' => 1,
                            'leave_salaries_id' => $insert_id
                        );
                        $result = $this->Employees_model->add_salary_loan($data);
                    } else {
                        $data = array(
                            'applicable_for_paysalary' => 1,
                        );
                        $result = $this->Employees_model->salary_loan_update_record_leave_salary($data, $loans, $emp->user_id);
                    }
                }
            }
        }
    }
    ///////
    public function all_ethnicity_type()
    {
        $query = $this->db->query("SELECT * from xin_ethnicity_type");
        return $query->result();
    }
    public function basic_info_serialized($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->set('serialized', $data)->update('xin_employees')) {
            return true;
        } else {
            return false;
        }
    }
    public function social_info_serialized($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->set('serialized_social', $data)->update('xin_employees')) {
            return true;
        } else {
            return false;
        }
    }
    public function qualification_info_serialized($data, $id)
    {
        $this->db->where('qualification_id', $id);
        if ($this->db->set('serialized', $data)->update('xin_employee_qualification')) {
            return true;
        } else {
            return false;
        }
    }
    public function profile_picture_serialized($data, $id)
    {
        $this->db->where('user_id', $id);
        if ($this->db->set('serialize_profile_picture', $data)->update('xin_employees')) {
            return true;
        } else {
            return false;
        }
    }
    public function img_document_info_serialized($data, $id)
    {
        $this->db->where('immigration_id', $id);
        if ($this->db->set('serialized', $data)->update('xin_employee_immigration')) {
            return true;
        } else {
            return false;
        }
    }
    public function document_info_serialized($data, $id)
    {
        $this->db->where('document_id', $id);
        if ($this->db->set('serialized', $data)->update('xin_employee_documents')) {
            return true;
        } else {
            return false;
        }
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function read_contact_local($id)
    {
        return $this->db->select('local_store')->where('contact_id', $id)->get('xin_employee_contacts')->row_array();
    }
    public function read_changes_local($id)
    {

        $previous = $this->db->select('*')->where('contact_id', $id)->get('xin_employee_contacts')->row_array();
        $local = $this->db->select('local_store')->where('contact_id', $id)->get('xin_employee_contacts')->row_array();
        $un_local = array();
        $changes = array();

        if ($local['local_store'] != '' && $local['local_store'] != 'NULL' && $local['local_store'] != NULL) {
            $un_local = unserialize($local['local_store']);

            $country_name = $this->db->select('country_name')->where('country_id', $un_local['country'])->get('xin_countries')->row_array();
            // 			var_dump($country_name);
            if ($country_name != '' && $country_name != 'NULL' && $country_name != NULL) {
                $un_local['country_name'] = $country_name['country_name'];
            } else {
                $un_local['country_name'] = '';
            }
        }
        if (!empty($un_local)) {

            if ($previous['relation'] != $un_local['relation']) {
                $changes['Relation'] = $un_local['relation'];
            }
            if ($previous['work_email'] != $un_local['work_email']) {
                $changes['work email'] = $un_local['work_email'];
            }
            if ($previous['personal_email'] != $un_local['personal_email']) {
                $changes['personal email'] = $un_local['personal_email'];
            }
            if ($previous['address_1'] != $un_local['address_1']) {
                $changes['address 1'] = $un_local['address_1'];
            }
            if ($previous['address_2'] != $un_local['address_2']) {
                $changes['address 2'] = $un_local['address_2'];
            }
            if ($previous['work_phone'] != $un_local['work_phone']) {
                $changes['work phone'] = $un_local['work_phone'];
            }
            if ($previous['work_phone_extension'] != $un_local['work_phone_extension']) {
                $changes['work phone extension'] = $un_local['work_phone_extension'];
            }
            if ($previous['contact_name'] != $un_local['contact_name']) {
                $changes['contact name'] = $un_local['contact_name'];
            }
            if ($previous['mobile_phone'] != $un_local['mobile_phone']) {
                $changes['mobile phone'] = $un_local['mobile_phone'];
            }
            if ($previous['city'] != $un_local['city']) {
                $changes['city'] = $un_local['city'];
            }
            if ($previous['is_primary'] != $un_local['is_primary'] && $un_local['is_primary'] != 0) {
                $changes['primary contact'] = $un_local['is_primary'];
            }
            if ($previous['is_dependent'] != $un_local['is_dependent'] && $un_local['is_dependent'] != 0) {
                $changes['dependent contact'] = $un_local['is_dependent'];
            }
            if ($previous['home_phone'] != $un_local['home_phone']) {
                $changes['home phone'] = $un_local['home_phone'];
            }
            if ($previous['state'] != $un_local['state']) {
                $changes['state'] = $un_local['state'];
            }
            if ($previous['zipcode'] != $un_local['zipcode']) {
                $changes['zipcode'] = $un_local['zipcode'];
            }
            if ($previous['country'] != $un_local['country']) {
                $changes['country'] = $un_local['country_name'];
            }
        }
        return $changes;
    }
    public function contact_info_rejected($id)
    {

        $this->db->set('local_store', '');
        $this->db->where('contact_id', $id);
        if ($this->db->update('xin_employee_contacts')) {
            return true;
        } else {
            return false;
        }
    }
    public function contact_info_approved($data, $id)
    {

        $this->db->set('local_store', '');
        $this->db->where('contact_id', $id);
        $this->db->update('xin_employee_contacts');

        $this->db->where('contact_id', $id);
        if ($this->db->update('xin_employee_contacts', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function read_experience_local($id)
    {

        return $this->db->select('local_store')->where('work_experience_id', $id)->get('xin_employee_work_experience')->row_array();
    }
    public function read_experience_changes_local($id)
    {

        $previous = $this->db->select('*')->where('work_experience_id ', $id)->get('xin_employee_work_experience')->row_array();
        $local = $this->db->select('local_store')->where('work_experience_id ', $id)->get('xin_employee_work_experience')->row_array();
        $un_local = array();
        $changes = array();
        if ($local['local_store'] != '' && $local['local_store'] != 'NULL' && $local['local_store'] != NULL) {
            $un_local = unserialize($local['local_store']);
        }
        if (!empty($un_local)) {

            if ($previous['company_name'] != $un_local['company_name']) {
                $changes['company name'] = $un_local['company_name'];
            }
            if ($previous['from_date'] != $un_local['from_date']) {
                $changes['from date'] = $un_local['from_date'];
            }
            if ($previous['to_date'] != $un_local['to_date']) {
                $changes['to date'] = $un_local['to_date'];
            }
            if ($previous['post'] != $un_local['post']) {
                $changes['post'] = $un_local['post'];
            }
            if ($previous['description'] != $un_local['description']) {
                $changes['description'] = $un_local['description'];
            }
        }
        return $changes;
    }
    public function experience_info_rejected($id)
    {

        $this->db->set('local_store', '');
        $this->db->where('work_experience_id', $id);
        if ($this->db->update('xin_employee_work_experience')) {
            return true;
        } else {
            return false;
        }
    }
    public function exp_info_approved($data, $id)
    {

        $this->db->set('local_store', '');
        $this->db->where('work_experience_id ', $id);
        $this->db->update('xin_employee_work_experience');

        $this->db->where('work_experience_id', $id);
        if ($this->db->update('xin_employee_work_experience', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function read_bank_local($id)
    {
        return $this->db->select('local_store')->where('bankaccount_id', $id)->get('xin_employee_bankaccount')->row_array();
    }
    public function read_contact_changes_local($id)
    {

        $previous = $this->db->select('*')->where('bankaccount_id', $id)->get('xin_employee_bankaccount')->row_array();
        $local = $this->db->select('local_store')->where('bankaccount_id', $id)->get('xin_employee_bankaccount')->row_array();
        $un_local = array();
        $changes = array();
        if ($local['local_store'] != '' && $local['local_store'] != 'NULL' && $local['local_store'] != NULL) {
            $un_local = unserialize($local['local_store']);
        }
        if (!empty($un_local)) {

            if ($previous['account_title'] != $un_local['account_title']) {
                $changes['account title'] = $un_local['account_title'];
            }
            if ($previous['account_number'] != $un_local['account_number']) {
                $changes['account number'] = $un_local['account_number'];
            }
            if ($previous['bank_name'] != $un_local['bank_name']) {
                $changes['bank name'] = $un_local['bank_name'];
            }
            if ($previous['bank_code'] != $un_local['bank_code']) {
                $changes['bank code'] = $un_local['bank_code'];
            }
            if ($previous['bank_branch'] != $un_local['bank_branch']) {
                $changes['bank branch'] = $un_local['bank_branch'];
            }
        }
        return $changes;
    }
    public function bank_info_rejected($id)
    {

        $this->db->set('local_store', '');
        $this->db->where('bankaccount_id', $id);
        if ($this->db->update('xin_employee_bankaccount')) {
            return true;
        } else {
            return false;
        }
    }
    public function bank_info_approved($data, $id)
    {
        $this->db->set('local_store', '');
        $this->db->where('bankaccount_id ', $id);
        $this->db->update('xin_employee_bankaccount');

        $this->db->where('bankaccount_id', $id);
        if ($this->db->update('xin_employee_bankaccount', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function read_vehicle_local($id)
    {
        return $this->db->select('local_store')->where('id', $id)->get('xin_vehicle')->row_array();
    }
    public function read_vehicle_changes_local($id)
    {

        $previous = $this->db->select('*')->where('id', $id)->get('xin_vehicle')->row_array();
        $local = $this->db->select('xin_vehicle.local_store')->where('xin_vehicle.id', $id)->get('xin_vehicle')->row_array();
        $un_local = array();
        $changes = array();
        if ($local['local_store'] != '' && $local['local_store'] != 'NULL' && $local['local_store'] != NULL) {
            $un_local = unserialize($local['local_store']);
            $vehicle_name = $this->db->select('type')->where('vehicle_id', $un_local['type'])->get('vehicle')->row_array();
            $un_local['vehicle_name'] = $vehicle_name['type'];
        }
        if (!empty($un_local)) {

            if ($previous['type'] != $un_local['type']) {
                $changes['Vehicle'] = $un_local['vehicle_name'];
            }
            if ($previous['number'] != $un_local['number']) {
                $changes['Number'] = $un_local['number'];
            }
            if ($previous['date'] != $un_local['date']) {
                $changes['Date'] = $un_local['date'];
            }
        }
        return $changes;
    }
    public function vehicle_info_rejected($id)
    {
        $this->db->set('local_store', '');
        $this->db->where('id', $id);
        if ($this->db->update('xin_vehicle')) {
            return true;
        } else {
            return false;
        }
    }
    public function vehicle_info_approved($data, $id)
    {
        $this->db->set('local_store', '');
        $this->db->where('id ', $id);
        $this->db->update('xin_vehicle');

        $this->db->where('id', $id);
        if ($this->db->update('xin_vehicle', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function read_security_local($id)
    {
        return $this->db->select('local_store')->where('security_level_id', $id)->get('xin_employee_security_level')->row_array();
    }
    public function read_security_changes_local($id)
    {

        $previous = $this->db->select('*')->where('security_level_id', $id)->get('xin_employee_security_level')->row_array();
        $local = $this->db->select('xin_employee_security_level.local_store')->where('xin_employee_security_level.security_level_id', $id)->get('xin_employee_security_level')->row_array();
        $un_local = array();
        $changes = array();
        if ($local['local_store'] != '' && $local['local_store'] != 'NULL' && $local['local_store'] != NULL) {
            $un_local = unserialize($local['local_store']);
            $security_name = $this->db->select('name')->where('type_id', $un_local['security_type'])->get('xin_security_level')->row_array();
            $un_local['security_name'] = $security_name['name'];
        }
        if (!empty($un_local)) {
            if ($previous['security_type'] != $un_local['security_type']) {
                $changes['security name'] = $un_local['security_name'];
            }
            if ($previous['date_of_clearance'] != $un_local['date_of_clearance']) {
                $changes['date of clearance'] = $un_local['date_of_clearance'];
            }
            if ($previous['expiry_date'] != $un_local['expiry_date']) {
                $changes['expiry date'] = $un_local['expiry_date'];
            }
        }
        return $changes;
    }
    public function security_info_rejected($id)
    {

        $this->db->set('local_store', '');
        $this->db->where('security_level_id', $id);
        if ($this->db->update('xin_employee_security_level')) {
            return true;
        } else {
            return false;
        }
    }
    public function security_info_approved($data, $id)
    {
        $this->db->set('local_store', '');
        $this->db->where('security_level_id ', $id);
        $this->db->update('xin_employee_security_level');

        $this->db->where('security_level_id', $id);
        if ($this->db->update('xin_employee_security_level', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function read_leave_local($id)
    {
        return $this->db->select('local_store')->where('id', $id)->get('employee_leave')->row_array();
    }
    public function read_leave_changes_local($id)
    {
        $previous = $this->db->select('*')->where('id', $id)->get('employee_leave')->row_array();
        $local = $this->db->select('employee_leave.local_store')->where('employee_leave.id', $id)->get('employee_leave')->row_array();
        $un_local = array();
        $changes = array();
        if ($local['local_store'] != '' && $local['local_store'] != 'NULL' && $local['local_store'] != NULL) {
            $un_local = unserialize($local['local_store']);
        }
        if (!empty($un_local)) {

            if ($previous['leave_count'] != $un_local['leave_count']) {
                $changes['Leave Count'] = $un_local['leave_count'];
            }
        }
        return $changes;
    }
    public function leave_info_rejected($id)
    {
        $this->db->set('local_store', '');
        $this->db->where('id', $id);
        if ($this->db->update('employee_leave')) {
            return true;
        } else {
            return false;
        }
    }
    public function leave_info_approved($data, $id)
    {

        $this->db->set('local_store', '');
        $this->db->where('id', $id);
        $this->db->update('employee_leave');

        $this->db->where('id', $id);
        if ($this->db->update('employee_leave', $data)) {
            return true;
        } else {
            return false;
        }
    }
    public function get_company_details($id)
    {
        $sql = "Select * FROM xin_companies where company_id=? ";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function emp_total_annual_leaves_taken_paid_new($user_id, $start_date_y)
    {
        $sql = "Select * FROM xin_annual_leave_applications WHERE employee_id=? and status='2' and from_date < ? ORDER By applied_on desc limit 1";
        $binds = array($user_id, $start_date_y);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_local_store($id)
    {
        $data = $this->db->select('local_store')->where('contact_id', $id)->get('xin_employee_contacts')->row_array();
        if ($data['local_store'] != '' && $data['local_store'] != 'NULL' && $data['local_store'] != NULL) {
            return 1;
        } else {
            return 0;
        }
    }
    public function read_work_local_store($id)
    {
        $data = $this->db->select('local_store')->where('work_experience_id', $id)->get('xin_employee_work_experience')->row_array();
        if ($data['local_store'] != '' && $data['local_store'] != 'NULL' && $data['local_store'] != NULL) {
            return 1;
        } else {
            return 0;
        }
    }
    public function read_bank_local_store($id)
    {
        $data = $this->db->select('local_store')->where('bankaccount_id', $id)->get('xin_employee_bankaccount')->row_array();
        if ($data['local_store'] != '' && $data['local_store'] != 'NULL' && $data['local_store'] != NULL) {
            return 1;
        } else {
            return 0;
        }
    }
    public function read_local_vehicle_store($id)
    {
        $data = $this->db->select('local_store')->where('id', $id)->get('xin_vehicle')->row_array();
        if ($data['local_store'] != '' && $data['local_store'] != 'NULL' && $data['local_store'] != NULL) {
            return 1;
        } else {
            return 0;
        }
    }
    public function read_local_security_store($id)
    {
        $data = $this->db->select('local_store')->where('security_level_id', $id)->get('xin_employee_security_level')->row_array();
        if ($data['local_store'] != '' && $data['local_store'] != 'NULL' && $data['local_store'] != NULL) {
            return 1;
        } else {
            return 0;
        }
    }
    public function read_local_leave_store($id)
    {
        $data = $this->db->select('local_store')->where('id', $id)->get('employee_leave')->row_array();
        if ($data['local_store'] != '' && $data['local_store'] != 'NULL' && $data['local_store'] != NULL) {
            return 1;
        } else {
            return 0;
        }
    }
    public function preditallemployeedetails($category)
    {
        if($category=='Employee_Name'){
            $query = $this->db->select("first_name,middle_name,last_name,user_id")->where('user_id!=','1')->get('xin_employees')->result_array();
            foreach($query as $x => $val) {
                $query[$x]['name']=$val['first_name'];
                if($val['middle_name']!=''){
                    $query[$x]['name'].=' '.$val['middle_name'];
                }
                if($val['last_name']!=''){
                    $query[$x]['name'].=' '.$val['last_name'];
                }
            }
            return $query;
        }else if($category=='Employee_ID'){
            $query = $this->db->select("employee_id as name,user_id")->where('user_id!=','1')->get('xin_employees')->result_array();
            return $query;
        }else{
            // $names = $this->db->select("CONCAT(first_name,' ',middle_name,' ',last_name) as name,user_id")->get('xin_employees')->result_array();
            $names = $this->db->select("first_name,middle_name,last_name,user_id")->where('user_id!=','1')->get('xin_employees')->result_array();
            foreach($names as $x => $val) {
                $names[$x]['name']=$val['first_name'];
                if($val['middle_name']!=''){
                    $names[$x]['name'].=' '.$val['middle_name'];
                }
                if($val['last_name']!=''){
                    $names[$x]['name'].=' '.$val['last_name'];
                }
            }
            $empids = $this->db->select("employee_id as name,user_id")->where('user_id!=','1')->get('xin_employees')->result_array();
            $query = array_merge($names,$empids);
            // var_dump($query);
            return $query;
        }
    }
    public function save_profile_picture_approval_status($id,$status)
    {
        $this->db->where('user_id', $id);
        if ($this->db->set('profile_approval_status', $status)->update('xin_employees')) {
            return true;
        } else {
            return false;
        }
    }
    
    	//rahul update
    
        //location >> Employee
    public function ajax_location_employee_info($location_id) {
	    $sql = "SELECT * from xin_employees where location_id = $location_id";
		$query = $this->db->query($sql);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
			public function get_this_month_onboarding_count($last_date) {
			    $current_months=date('Y-m');
	    $sql = "SELECT  COUNT(employee_id) as emp_count FROM `xin_employees` WHERE date_of_joining BETWEEN '$current_months-01' and '$last_date-31'";
		$query = $this->db->query($sql);
        return $query->result_array();
	}
				public function get_this_month_offboarding_count($current_month,$last_date) {
	    $sql = "SELECT  COUNT(employee_id) as emp_count FROM `xin_employees` WHERE date_of_leaving BETWEEN '$current_month' and '$last_date-31'";
		$query = $this->db->query($sql);
        return $query->result_array();
	}
		public function get_this_month_expiry_visa_count($current_month,$last_date) {
	    $sql = "SELECT  COUNT(expiry_date) as not_count FROM `xin_visa` WHERE expiry_date BETWEEN '$current_month' and '$last_date-31'";
		$query = $this->db->query($sql);
        return $query->result_array();
	}
		public function get_this_month_expiry_passport_count($current_month,$last_date) {
	    $sql = "SELECT  COUNT(expiry_date) as not_count FROM `xin_passport` WHERE expiry_date BETWEEN '$current_month' and '$last_date-31'";
		$query = $this->db->query($sql);
        return $query->result_array();
	}
	//rahul update end 
	
	public function get_this_month_expiry_visa($current_month) {
	    $sql = "SELECT * FROM `xin_visa` WHERE expiry_date BETWEEN '$current_month-01' and '$current_month-31'";
		$query = $this->db->query($sql);
        return $query;
	}
    
    public function get_this_month_expiry_passport($current_month) {
	    $sql = "SELECT * FROM `xin_passport` WHERE expiry_date BETWEEN '$current_month-01' and '$current_month-31'";
		$query = $this->db->query($sql);
        return $query;
	}
	
	public function get_attendance_today_employees($today)
    {
        
        $data=$this->db->select('xin_employees.*,xin_attendance_time.*')->join('xin_employees','xin_employees.user_id=xin_attendance_time.employee_id','left')->where('attendance_date',$today)->where('attendance_status','Present')->get('xin_attendance_time');
        // var_dump($data->result_array());die();
        return $data;
    }
     public function get_attendance_yesterday_employees($yesterday)
    {
        
        $data=$this->db->select('xin_employees.*,xin_attendance_time.*')->join('xin_employees','xin_employees.user_id=xin_attendance_time.employee_id')->where('attendance_date',$yesterday)->where('attendance_status','Present')->get('xin_attendance_time');
       // var_dump($data);die();
        return $data;
    }
    
    public function get_all_employees_deptwise($dname)
    {
        $data=$this->db->select('*')->where('department_id',$dname)->get('xin_employees');
        return $data;
    }
    public function get_all_employees_degnwise($degnid)
    {
       
        $data=$this->db->select('*')->where('designation_id',$degnid)->get('xin_employees');
        return $data;
    }
    
    
          public function record_count_company_employees_archive_this_month($cid)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = 2)  and (date_of_leaving BETWEEN '$current_month-01' and '$current_month-31') order by first_name ASC  " ;
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_employees_archive_this_month($cid, $lid)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = ?) and (location_id= ?)  and (date_of_leaving BETWEEN '$current_month-01' and '$current_month-31')  order by first_name ASC ";
        $binds = array($cid, $lid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_department_employees_archive_this_month($cid, $lid, $dep_id)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = ?) and (location_id= ?) and (department_id= ?)  and (date_of_leaving BETWEEN '$current_month-01' and '$current_month-31')  order by first_name ASC ";
        $binds = array($cid, $lid, $dep_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_department_designation_employees_archive_this_month($cid, $lid, $dep_id, $des_id)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = ?)  and (location_id= ?) and (department_id= ?) and (designation_id= ?) and (date_of_leaving BETWEEN '$current_month-01' and '$current_month-31') order by first_name ASC ";
        $binds = array($cid, $lid, $dep_id, $des_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function fetch_all_team_employees_archive_this_month($limit, $start)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        $this->db->where("reports_to", $session['user_id']);
        		$this->db->where("is_active=0");
                		$this->db->where('date_of_leaving >=', $start_month);
$this->db->where('date_of_leaving <=', $end_month);
        $this->db->where("user_role_id!=1");
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_employees_archive_this_month($limit, $start)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id != 1) {
            $this->db->where("company_id", $user_info[0]->company_id);
        }
        $this->db->where("user_role_id!=1");
                		$this->db->where('date_of_leaving >=', $start_month);
$this->db->where('date_of_leaving <=', $end_month);
        
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_employees_flt_archive_this_month($limit, $start, $cid)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id", $cid);
                		$this->db->where('date_of_leaving >=', $start_month);
$this->db->where('date_of_leaving <=', $end_month);
        	
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_employees_flt_archive_this_month($limit, $start, $cid, $lid)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
                		$this->db->where('date_of_leaving >=', $start_month);
$this->db->where('date_of_leaving <=', $end_month);
        	
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_department_employees_flt_archive_this_month($limit, $start, $cid, $lid, $dep_id)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
                		$this->db->where('date_of_leaving >=', $start_month);
$this->db->where('date_of_leaving <=', $end_month);
        
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_department_designation_employees_flt_archive_this_month($limit, $start, $cid, $lid, $dep_id, $des_id)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
        $this->db->where("designation_id=", $des_id);
                		$this->db->where('date_of_leaving >=', $start_month);
$this->db->where('date_of_leaving <=', $end_month);
     
        		
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
 
 
 

 
    
    public function record_count_company_employees_this_month($cid)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = 2)  and (date_of_joining BETWEEN '$current_month-01' and '$current_month-31') order by first_name ASC  " ;
        $binds = array($cid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_employees_this_month($cid, $lid)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = ?) and (location_id= ?)  and (date_of_joining BETWEEN '$current_month-01' and '$current_month-31')  order by first_name ASC ";
        $binds = array($cid, $lid);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_department_employees_this_month($cid, $lid, $dep_id)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = ?) and (location_id= ?) and (department_id= ?)  and (date_of_joining BETWEEN '$current_month-01' and '$current_month-31')  order by first_name ASC ";
        $binds = array($cid, $lid, $dep_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function record_count_company_location_department_designation_employees_this_month($cid, $lid, $dep_id, $des_id)
    {
$current_month = date("Y-m");
        $sql = "SELECT * FROM xin_employees WHERE (company_id = ?)  and (location_id= ?) and (department_id= ?) and (designation_id= ?)and (date_of_joining BETWEEN '$current_month-01' and '$current_month-31') order by first_name ASC ";
        $binds = array($cid, $lid, $dep_id, $des_id);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
           public function fetch_all_team_employees_this_month($limit, $start)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        $this->db->where("reports_to", $session['user_id']);
        	
                		$this->db->where('date_of_joining >=', $start_month);
$this->db->where('date_of_joining <=', $end_month);
        $this->db->where("user_role_id!=1");
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_employees_this_month($limit, $start)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        //$this->db->where("user_role_id!=",1);
        $user_info = $this->Xin_model->read_user_info($session['user_id']);
        if ($user_info[0]->user_role_id != 1) {
            $this->db->where("company_id", $user_info[0]->company_id);
        }
        $this->db->where("user_role_id!=1");
                		$this->db->where('date_of_joining >=', $start_month);
$this->db->where('date_of_joining <=', $end_month);
        
        $query = $this->db->get("xin_employees");

        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_employees_flt_this_month($limit, $start, $cid)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id", $cid);
                		$this->db->where('date_of_joining >=', $start_month);
$this->db->where('date_of_joining <=', $end_month);
       
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_employees_flt_this_month($limit, $start, $cid, $lid)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
                		$this->db->where('date_of_joining >=', $start_month);
$this->db->where('date_of_joining <=', $end_month);
        
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_department_employees_flt_this_month($limit, $start, $cid, $lid, $dep_id)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
                		$this->db->where('date_of_joining >=', $start_month);
$this->db->where('date_of_joining <=', $end_month);
        
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
           public function fetch_all_company_location_department_designation_employees_flt_this_month($limit, $start, $cid, $lid, $dep_id, $des_id)
    {
        $start_month=date("Y-m-01");
        $end_month=date("Y-m-31");
        $session = $this->session->userdata('username');
        $this->db->limit($limit, $start);
        $this->db->order_by("first_name asc");
        $this->db->where("company_id=", $cid);
        $this->db->where("location_id=", $lid);
        $this->db->where("department_id=", $dep_id);
        $this->db->where("designation_id=", $des_id);
                		$this->db->where('date_of_joining >=', $start_month);
$this->db->where('date_of_joining <=', $end_month);
   
        		
        $query = $this->db->get("xin_employees");
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }
    
        public function get_resignation_status($id)
    {
    $sql = "SELECT status From xin_employee_resignations where employee_id='$id'";
    $query = $this->db->query($sql);
    if ($query->num_rows() > 0) {
    return $query->result();
    } else {
    return null;
    }
    }
    
}
