<?php

class Loan extends CI_Model
{
    private $_table = 'xin_salary_loan_deductions';
    
    public function get($filter = array())
    {
        if (isset($filter['employee_id']) && $filter['employee_id'] > 0)
            $this->db->where('employee_id', $filter['employee_id']);
        
        if (isset($filter['status']))
            $this->db->where('status', (int) $filter['status']);
        
        return $this->db->get($this->_table);
    }
    
    public function getMonthlyDeductions($loan_id = 0)
    {
        $this->db->where('loan_id', $loan_id);
        return $deductions = $this->db->get('xin_salary_payslip_loan');
    }
    
    public function getOutstandingAmount($employee_id = 0)
    {
        $outstanding_amount = 0;
        
        $loans = $this->get(array(
            'employee_id' => $employee_id,
            'status' => 1
        ));
        
        if ($loans->num_rows() > 0)
        {
            foreach ($loans->result() as $loan)
            {
                $loan_amount = $loan->monthly_installment;
                
                $monthly_deductions = $this->getMonthlyDeductions($loan->loan_deduction_id);
                $deduction_total = 0;
             
                foreach ($monthly_deductions->result() as $deduction)
                {
                    if(!empty($deduction->amount)){
                    $deduction_total += $deduction->amount;
                    }
                }
                
                $balance = $loan_amount - $deduction_total;
                
                if ($balance > 0)
                {
                    $outstanding_amount += $balance;
                }
            }
        }
        
        return $outstanding_amount;
    }
}