<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Misc_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
	public function find_late1($date, $employee_id)
	{
	    $employee = $this->Employees_model->read_employee_information($employee_id);
        $company_id = $employee[0]->company_id;
        $office_shift_id = $employee[0]->office_shift_id;
        
        $date = date('Y-m-d', strtotime($date));
        
        $this->db->where('employee_id', $employee_id);
        $this->db->where('attendance_date', $date);
        $this->db->where('clock_in !=', "");
        $this->db->order_by('time_attendance_id', 'asc');
        $first_clock_info = $this->db->get('xin_attendance_time', 1)->row();
        
        if ($first_clock_info)
        {
            return $this->find_late($first_clock_info->clock_in, $company_id, $office_shift_id, $employee_id, $first_clock_info->attendance_date);
        }
        
        return '00:00';
	}
	
	public function find_late($clock_in, $company_id, $shift_id = 0, $employee_id = 0, $attendance_date)
    {
        if ($shift_id == 0)
        {
            $month = date('Y-m', strtotime($attendance_date));
            $office_shift = $this->Office_shift_custom_model->employee_current_shift($employee_id, $month);
            
            if (! $office_shift) return '00:00';
            
            $day = date('j', strtotime($attendance_date));
            $table_field = $day . '_in';
            
            // If no shift out time, take clock out time
            if (trim($office_shift[$table_field]) == '')
                $office_shift[$table_field] = $clock_in;
                
            $office_shift_table_field = $office_shift[$table_field];
                
            $shift_in_time = $office_shift_table_field;
        }
        else
        {
            // Find week day
            $week_day = $this->find_week_day($attendance_date);
            $week_day_lower = strtolower($week_day);
            
            // Make Table field. Eg: thursday_in_time
            $table_field = $week_day_lower . '_in_time';
            
            if ($shift_id > 0)
                $this->db->where('office_shift_id', $shift_id);
            else
                $this->db->where('company_id', $company_id);
            $office_shift = $this->db->get('xin_office_shift')->row();
            
            if (! $office_shift) return '00:00';
        
            // If no shift out time, take clock out time
            if (trim($office_shift->$table_field) == '')
                $office_shift->$table_field = date("H:i", strtotime($attendance_date));
                
            $office_shift_table_field = $office_shift->$table_field;
            
            // Make shift out date time. Eg: Y-m-d H:i:s
            $shift_in_time = date('Y-m-d', strtotime($attendance_date)).' '.$office_shift_table_field . ':00';
        }
        
        if (strtotime($clock_in) > strtotime($shift_in_time))
        {
            $date1 = new DateTime($clock_in);
            $date2 = new DateTime($shift_in_time);
            $interval = $date1->diff($date2);
            
            $hours = str_pad($interval->h, 2, 0, STR_PAD_LEFT);
            $minutes = str_pad($interval->i, 2, 0, STR_PAD_LEFT);
            
            return "$hours:$minutes";
        }
        
        return '00:00';
    }
    
    public function find_overtime1($date, $employee_id)
    {
        $employee = $this->Employees_model->read_employee_information($employee_id);
        $company_id = $employee[0]->company_id;
        $date = date('Y-m-d', strtotime($date));
        
        $attendance_date = $date;
        
        // Find shift-out time
        if ($employee[0]->office_shift_id == 0)
        {
            $month = date('Y-m', strtotime($attendance_date));
            $office_shift = $this->Office_shift_custom_model->employee_current_shift($employee_id, $month);
            
            if (! $office_shift) return '00:00';
            
            $day = date('j', strtotime($attendance_date));
            $table_field = $day . '_out';
            
            // If no shift out time, take clock out time
            if (trim($office_shift[$table_field]) == '')
                return '00:00';
            else
                $shift_out_time = $office_shift[$table_field];
        }
        else
        {
            // Find week day
            $week_day = $this->find_week_day($attendance_date);
            $week_day_lower = strtolower($week_day);
            
            // Make Table field. Eg: thursday_out_time
            $table_field = $week_day_lower . '_out_time';
            $table_field_in_time = $week_day_lower . '_in_time';
            $table_field_out_time = $table_field;
            
            // $this->db->where('company_id', $company_id);
            $this->db->where('office_shift_id', $employee[0]->office_shift_id);
            $office_shift = $this->db->get('xin_office_shift')->row();
            
            if (! $office_shift) return '00:00';

            // If no shift out time, take clock out time
            if (trim($office_shift->$table_field) == '') {
                return '00:00';
            }
            
            $office_shift_table_field = $office_shift->$table_field_out_time;
            
            $shift_in = $office_shift->$table_field_in_time;
            $shift_in_secs = $this->hm2sec($shift_in);
            $shift_out = $office_shift->$table_field_out_time;
            $shift_out_secs = $this->hm2sec($shift_out);
            
            if ($shift_in_secs > $shift_out_secs) {
                $shift_end_date = date('Y-m-d', strtotime($attendance_date . " +1 days"));
            } else {
                $shift_end_date = $attendance_date;
            }
            
            // Make shift out date time. Eg: Y-m-d H:i:s
            $shift_out_time = date('Y-m-d', strtotime($shift_end_date)).' '.$office_shift_table_field . ':00';
        }
        
        $shift_out_time = strtotime($shift_out_time);
        $shift_out_time_seconds = $shift_out_time;
        
        $this->db->where('employee_id', $employee_id);
        $this->db->where('attendance_date', $date);
        $this->db->where('clock_out !=', "");
        $this->db->order_by('time_attendance_id', 'desc');
        $attendances = $this->db->get('xin_attendance_time');
        
        $overtime_seconds = 0;
        
        if ($attendances->num_rows() > 0)
        {
            foreach ($attendances->result() as $attendance)
            {
                if (date('H:i', strtotime($attendance->clock_out)) == '00:00')
                    continue;
                
                $clock_in_seconds = strtotime($attendance->clock_in);
                $clock_out_seconds = strtotime($attendance->clock_out);
                
                if (($shift_out_time_seconds >= $clock_in_seconds) && ($shift_out_time_seconds <= $clock_out_seconds))
                {
                    $overtime_seconds += $clock_out_seconds - $shift_out_time_seconds;
                }
                else if($clock_in_seconds > $shift_out_time_seconds)
                {
                    $overtime_seconds += $clock_out_seconds - $clock_in_seconds;
                }
            }
        }
        
        // Deduct late time
        $late_hours = $this->Misc_model->find_late1($attendance_date, $employee_id);
        $late_seconds = $this->Misc_model->hm2sec($late_hours);
        
        $overtime_seconds -= $late_seconds;
        
        if ($overtime_seconds < 0)
            $overtime_seconds = 0;
        
        return gmdate('H:i', $overtime_seconds);
    }
    
    public function find_overtime($clock_in, $clock_out, $company_id, $shift_id = 0)
    {
        // Find week day
        $week_day = $this->find_week_day($clock_in);
        $week_day_lower = strtolower($week_day);
        
        // Make Table field. Eg: thursday_out_time
        $table_field = $week_day_lower . '_out_time';
        
        if ($shift_id > 0)
        	$this->db->where('office_shift_id', $shift_id);
        else
        	$this->db->where('company_id', $company_id);
        $office_shift = $this->db->get('xin_office_shift')->row();
        
        if (! $office_shift) return '00:00';
        
        // If no shift out time, take clock out time
        if (trim($office_shift->$table_field) == '')
            $office_shift->$table_field = date("H:i", strtotime($clock_out));
            
        // Make shift out date time. Eg: Y-m-d H:i:s
        $shift_out_time = date('Y-m-d', strtotime($clock_in)).' '.$office_shift->$table_field . ':00';
        
        $seconds = 0;
        
        if (strtotime($clock_out) > strtotime($shift_out_time))
        {
            $date1 = new DateTime($clock_in);
            $date2 = new DateTime($clock_out);
            $interval = $date1->diff($date2);
            
            $seconds += 3600 * ($interval->d * 24);
            $seconds += 3600 * $interval->h;
            $seconds += 60 * $interval->i;
        }
        
        return gmdate('H:i', $seconds);
    }
    
    public function find_early_leaving1($date, $employee_id)
    {
        $employee = $this->Employees_model->read_employee_information($employee_id);
        $company_id = $employee[0]->company_id;
        $office_shift_id = $employee[0]->office_shift_id;
        $date = date('Y-m-d', strtotime($date));
        
        $this->db->where('employee_id', $employee_id);
        $this->db->where('attendance_date', $date);
        $this->db->where('clock_out !=', "");
        $this->db->order_by('time_attendance_id', 'desc');
        $last_clock_info = $this->db->get('xin_attendance_time', 1)->row();
        
        if ($last_clock_info)
        {
            if (strtotime($last_clock_info->clock_out) > strtotime($last_clock_info->clock_in))
                return $this->find_early_leaving($last_clock_info->clock_out, $company_id, $office_shift_id, $employee_id, $last_clock_info->attendance_date);
        }
        
        return '00:00';
    }
    
    public function find_early_leaving($clock_out, $company_id, $shift_id = 0, $employee_id = 0, $attendance_date)
    {
        if (empty($clock_out)) return '00:00';
        
        if ($shift_id == 0)
        {
            $month = date('Y-m', strtotime($attendance_date));
            $office_shift = $this->Office_shift_custom_model->employee_current_shift($employee_id, $month);
            
            if (! $office_shift) return '00:00';
            
            $day = date('j', strtotime($attendance_date));
            $table_field = $day . '_out';
            
            // If no shift out time, take clock out time
            if (trim($office_shift[$table_field]) == '')
                $shift_out_time = $clock_out;
            else
                $shift_out_time = $office_shift[$table_field];
        }
        else
        {
            // Find week day
            $week_day = $this->find_week_day($attendance_date);
            $week_day_lower = strtolower($week_day);
            
            // Make Table field. Eg: thursday_out_time
            $table_field = $week_day_lower . '_out_time';
            $table_field_in_time = $week_day_lower . '_in_time';
            $table_field_out_time = $table_field;
            
            if ($shift_id > 0)
            	$this->db->where('office_shift_id', $shift_id);
            else
            	$this->db->where('company_id', $company_id);
            $office_shift = $this->db->get('xin_office_shift')->row();
            
            if (! $office_shift) return '00:00';
            
            // If no shift out time, take clock out time
            if (trim($office_shift->$table_field) == '')
                $office_shift->$table_field = date("H:i", strtotime($clock_out));
            
            $office_shift_table_field = $office_shift->$table_field;
            
            $shift_in = $office_shift->$table_field_in_time;
            $shift_in_secs = $this->hm2sec($shift_in);
            $shift_out = $office_shift->$table_field_out_time;
            $shift_out_secs = $this->hm2sec($shift_out);
            
            if ($shift_in_secs > $shift_out_secs) {
                $shift_end_date = date('Y-m-d', strtotime($attendance_date . " +1 days"));
            } else {
                $shift_end_date = $attendance_date;
            }
            
            // Make shift out date time. Eg: Y-m-d H:i:s
            $shift_out_time = date('Y-m-d', strtotime($shift_end_date)).' '.$office_shift_table_field . ':00';
        }
        
        if (strtotime($clock_out) >= strtotime($shift_out_time))
            return '00:00';
        
        $date1 = new DateTime($clock_out);
        $date2 = new DateTime($shift_out_time);
        $interval = $date1->diff($date2);
        
        $hours = str_pad($interval->h, 2, 0, STR_PAD_LEFT);
        $minutes = str_pad($interval->i, 2, 0, STR_PAD_LEFT);
        
        $el = "$hours:$minutes";
        
        return $el;
    }
    
    public function find_week_day($date)
    {
        $week_day = date('l', strtotime($date));
        return $week_day;
    }
    
    public function find_work_total($date, $employee_id)
    {
        $date = date('Y-m-d', strtotime($date));
        
        $this->db->where('employee_id', $employee_id);
        $this->db->where('attendance_date', $date);
        $this->db->where('clock_in !=', "");
        $this->db->where('clock_out !=', "");
        $attendance = $this->db->get('xin_attendance_time');
        
        if ($attendance->num_rows() == 0)
        {
            return '00:00';
        }
    
        $seconds = 0;
        
        foreach ($attendance->result() as $obj)
        {
            $clock_in = $obj->clock_in;
            $clock_out = $obj->clock_out;
            
            if (date('H:i', strtotime($clock_in)) == '00:00') continue;
            if (date('H:i', strtotime($clock_out)) == '00:00') continue;
            
            $date1 = new DateTime($clock_in);
            $date2 = new DateTime($clock_out);
            $interval = $date1->diff($date2);
            
            $seconds += 3600 * ($interval->d * 24);
            $seconds += 3600 * $interval->h;
            $seconds += 60 * $interval->i;
        }
        
        $total_hrs = gmdate("H:i", $seconds);
        
        return $total_hrs;
    }
    
    public function find_rest($date, $employee_id)
    {
        $date = date('Y-m-d', strtotime($date));
        
        $this->db->where('employee_id', $employee_id);
        $this->db->where('attendance_date', $date);
        $this->db->where('clock_in !=', "");
        $this->db->where('clock_out !=', "");
        $query = $this->db->get('xin_attendance_time');
        
        $seconds = 0;
        
        if ($query->num_rows() > 0)
        {
            foreach ($query->result() as $result)
            {
                if (strtotime($result->clock_out) <= strtotime($result->clock_in))
                    continue;
                
                $result_next =  $query->next_row();
                if (! $result_next)
                    continue;
                
                if (strtotime($result_next->clock_in) <= strtotime($result->clock_out))
                    continue;
                
                $clock_out = new DateTime(date('Y-m-d H:i', strtotime($result->clock_out)));
                $clock_in = new DateTime(date('Y-m-d H:i', strtotime($result_next->clock_in)));
                
                $interval = $clock_in->diff($clock_out);
                
                $seconds += 3600 * ($interval->d * 24);
                $seconds += 3600 * $interval->h;
                $seconds += 60 * $interval->i;
            }
        }
        
        return gmdate('H:i', $seconds);
    }
    
    public function save($date, $employee_id, $data = array())
    {
        $date = date('Y-m-d', strtotime($date));
        
        $this->db->where('date', $date);
        $this->db->where('employee_id', $employee_id);
        $totals = $this->db->get('xin_attendance_time_total');
        
        $data['date'] = $date;
        $data['employee_id'] = $employee_id;
        
        if ($totals->num_rows() > 0)
        {
            foreach ($totals->result() as $total)
            {
                $this->db->where('id', $total->id);
                $this->db->update('xin_attendance_time_total', $data);
            }
        }
        else
        {
            $this->db->insert('xin_attendance_time_total', $data);
        }
    }
    
    public function get_leave_status($employee_id, $date_check, $start_date, $end_date, $status = 'Absent')
    {
        if ($status == 'Holiday')
            return $status;
        
        $employee = $this->Xin_model->read_user_info($employee_id);
        $h_date_chck = $this->Timesheet_model->holiday_date_check_payroll_new($start_date, $end_date, $employee[0]->company_id);
        $public_holiday_arr = array();
        
        if($h_date_chck->num_rows() > 0)
        {
            $h_date = $this->Timesheet_model->holiday_date_payroll_new($start_date, $end_date, $employee[0]->company_id);
            
            foreach($h_date as $val)
            {
                if ($val->is_publish != 1) {
                    continue;
                }
                
                $begin = new DateTime( $val->start_date );
                $end = new DateTime( $val->end_date);
                $end = $end->modify( '+1 day' ); 
                
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($begin, $interval ,$end);
                
                foreach($daterange as $date)
                {
                    $public_holiday_arr[] =  $date->format("Y-m-d");
                }
            }
        }
        
        if (in_array($date_check, $public_holiday_arr)) // holiday
        {
			$status = 'Public Holiday';
		}
		else
		{
            $leave_date_chck = $this->Timesheet_model->leave_date_check_new($employee[0]->user_id, $start_date, $end_date);
            $leave_arr = array();
            $half_leave_arr = array();
            
            if ($leave_date_chck->num_rows() > 0)
            {
                $leave_date = $this->Timesheet_model->leave_date_check_new($employee[0]->user_id, $start_date, $end_date);
                
                foreach($leave_date->result() as $leave_dates)
                {
                    $begin1 = new DateTime( $leave_dates->from_date );
                    $end1 = new DateTime( $leave_dates->to_date);
                    $end1 = $end1->modify( '+1 day' ); 
                    $half_day_check = $leave_dates->is_half_day;
                    $interval1 = new DateInterval('P1D');
                    $daterange1 = new DatePeriod($begin1, $interval1 ,$end1);
                    
                    foreach($daterange1 as $date1)
                    {
                        if($half_day_check == 1)
                        {
                            $half_leave_arr[] =  $date1->format("Y-m-d");
                        }
                        else
                        {
                            $leave_arr[] =  $date1->format("Y-m-d");
                        }
                    }
                }
            }
            else
            {
                $leave_arr[] = '99-99-99';
            }
            
            if(in_array($date_check, $leave_arr)) // on leave
            {
                $status = 'Leave';
            }
            else if(in_array($date_check, $half_leave_arr)) // on leave
            {
                $status = 'Half Day Leave';
            }
            else
            {
                $leave_date_chck_annual = $this->Timesheet_model->leave_date_check_new_annual($employee[0]->user_id, $start_date, $end_date);
                $leave_arr_annual = array();
                
                if ($leave_date_chck_annual->num_rows() > 0)
                {
                    $leave_date_ann = $this->Timesheet_model->leave_date_check_new_annual($employee[0]->user_id, $start_date, $end_date);
                    
                    foreach($leave_date_ann->result() as $leave_dates_ann)
                    {
                        $begin1 = new DateTime( $leave_dates_ann->from_date );
                        $end1 = new DateTime( $leave_dates_ann->to_date);
                        $end1 = $end1->modify( '+1 day' ); 
                        $interval1 = new DateInterval('P1D');
                        $daterange1 = new DatePeriod($begin1, $interval1 ,$end1);
                        
                        foreach($daterange1 as $date1)
                        {
                            $leave_arr_annual[] =  $date1->format("Y-m-d");
                        }
                    }
                }
                else
                {
                    $leave_arr_annual[] = '99-99-99';
                }
                
                if(in_array($date_check, $leave_arr_annual)) // on leave
                {
                    $status = 'Leave';
                }
            }
		}
		
		return $status;
    }
    
    public function time_24_to_12($time) // Parameter value format: 14:35
    {
        $time_arr = explode(':', $time);
        $hours = $minutes = $seconds = 0;
        
        if (isset($time_arr[0]))
            $hours = $time_arr[0];
        
        if (isset($time_arr[1]))
            $minutes = $time_arr[1];
        
        if (is_numeric($hours))
            $seconds += $hours * 3600;
        
        if (is_numeric($minutes))
            $seconds += $minutes * 60;
        
        return gmdate('h:i A', $seconds);
    }
    
    public function day_status_employee($date, $employee_id = 0)
    {
        $employee = $this->Employees_model->read_employee_information($employee_id);
        if (! $employee) return '-';
        
        $sql = "SELECT * FROM `xin_holidays` WHERE company_id = '".$employee[0]->company_id."' AND '$date' BETWEEN `start_date` AND `end_date` AND `is_publish`='1' LIMIT 1";
        $query = $this->db->query($sql);
        
        if ($query->num_rows() == 1) {
            return 'PH';
        } else {
            $employee = $employee[0];
            $employee_shift_id = $employee->office_shift_id;
            
            if ($employee_shift_id > 0) {
                $this->db->where('office_shift_id', $employee_shift_id);
                $office_shift = $this->db->get('xin_office_shift')->row();
                
                if (! $office_shift) {
                    return 'H';
                } else {
                    // Find week day
                    $week_day = $this->find_week_day($date);
                    $week_day_lower = strtolower($week_day);
                    
                    // Make Table field. Eg: thursday_out_time
                    $table_field = $week_day_lower . '_in_time';
                    
                    if ($office_shift->$table_field == '') {
                        return 'H';
                    } else {
                        return 'W';
                    }
                }
            } else {
                $month_year = date('Y-m', strtotime($date));
                
                $sql = "SELECT * FROM `xin_office_shift_custom` WHERE employee_id = '$employee_id' AND month = '$month_year'";
                $query = $this->db->query($sql);
                
                if ($query->num_rows() > 0) {
                    $office_shift = $query->row_array();
                    
                    if (! $office_shift) {
                        return 'H';
                    } else {
                        $day = date('j', strtotime($date));
                        $table_field = $day . '_in';
                        
                        if (!$office_shift[$table_field] || $office_shift[$table_field] == '') {
                            return 'H';
                        } else {
                            return 'W';
                        }
                    }
                }
                
                return 'H';
            }
        }
    }
    
    public function hm2sec($hm)
    {
        $seconds = 0;
        
        $hm_arr = explode(':', $hm);
        
        if (isset($hm_arr[0]) && is_numeric($hm_arr[0]))
            $seconds += $hm_arr[0] * 3600;
        
        if (isset($hm_arr[1]) && is_numeric($hm_arr[1]))
            $seconds += $hm_arr[1]* 60;
        
        return $seconds;
    }
    
    public function numberTowords($num)
    { 
        $ones = array(
            1 => "one",
            2 => "two",
            3 => "three",
            4 => "four",
            5 => "five",
            6 => "six",
            7 => "seven",
            8 => "eight",
            9 => "nine",
            10 => "ten",
            11 => "eleven",
            12 => "twelve",
            13 => "thirteen",
            14 => "fourteen",
            15 => "fifteen",
            16 => "sixteen",
            17 => "seventeen",
            18 => "eighteen",
            19 => "nineteen"
        );
        $tens = array(
            1 => "ten",
            2 => "twenty",
            3 => "thirty",
            4 => "forty",
            5 => "fifty",
            6 => "sixty",
            7 => "seventy",
            8 => "eighty",
            9 => "ninety"
        );
        $hundreds = array(
            "hundred",
            "thousand",
            "million",
            "billion",
            "trillion",
            "quadrillion"
        );
        
        $num = number_format($num,2,".",",");
        $num_arr = explode(".",$num);
        $wholenum = $num_arr[0];
        $decnum = $num_arr[1];
        $whole_arr = array_reverse(explode(",",$wholenum));
        krsort($whole_arr);
        $words = "";
        
        foreach($whole_arr as $key => $i) {
            if($i == 0) {
                continue;
            }
            if($i < 20) {
                $words .= $ones[intval($i)];
            } elseif($i < 100) {
                if(substr($i,0,1) == 0 && strlen($i) == 3) {
                    $words .= $tens[substr($i,1,1)];
                    if(substr($i,2,1) != 0) {
                        $words .= " ".$ones[substr($i,2,1)];
                    }
                } else {
                    $words .= $tens[substr($i,0,1)];
                    if(substr($i,1,1) != 0) {
                        $words .= " ".$ones[substr($i,1,1)];
                    }
                }
            } else {
                // $words .= $ones[substr($i,0,1)]." ".$hundreds[0].' and ';
                if(substr($i,1,1) != 0 || substr($i,2,1) != 0) {
                    $words .= $ones[substr($i,0,1)]." ".$hundreds[0].' and ';
                } else {
                    $words .= $ones[substr($i,0,1)]." ".$hundreds[0];
                }
                if(substr($i,1,2) < 20 && substr($i,1,1) != 0) {
                    $words .= " ".$ones[(substr($i,1,2))];
                } else {
                    if(substr($i,1,1) != 0) {
                        $words .= " ".$tens[substr($i,1,1)];
                    }
                    if(substr($i,2,1) != 0) {
                        $words .= " ".$ones[substr($i,2,1)];
                    }
                }
            }
            if($key > 0) {
                $words .= " ".$hundreds[$key]." ";
            }
        }
        
        $words .= $unit??'';
        if($decnum > 0) {
            $words .= " point ";
            if($decnum < 20) {
                $words .= $ones[intval($decnum)];
            } elseif($decnum < 100) {
                $words .= $tens[substr($decnum,0,1)];
                if(substr($decnum,1,1) != 0) {
                    $words .= " ".$ones[substr($decnum,1,1)];
                }
            }
            $words .= $subunit??'';
        }
        return $words;
    }
}
