<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Office_shift_custom_model extends CI_Model
{
    
    protected $_table = 'xin_office_shift_custom';
    
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
	public function employees()
	{
	    $this->db->where('office_shift_id', 0);
	    return $this->db->get('xin_employees');
	}
	
	public function assigned($employee_id, $month)
	{
	    $this->db->where('employee_id', $employee_id);
	    $this->db->where('month', $month);
	    $query = $this->db->get($this->_table);
	    return $query->num_rows();
	}
	
	public function save($data)
	{
	    $this->db->insert($this->_table, $data);
	}
	
	public function get($employee_id = 0, $month = '')
	{
	    if ($employee_id > 0)
	        $this->db->where('employee_id', $employee_id);
        if ($month != '')
	        $this->db->where('month', $month);
	    $this->db->order_by('month', 'asc');
	    return $this->db->get($this->_table);
	}
	
	public function find($id)
	{
	    $this->db->where('id', $id);
	    return $this->db->get($this->_table)->row_array();
	}
	
	public function update($id, $data)
	{
	    $this->db->where('id', $id);
	    $this->db->update($this->_table, $data);
	}
	
	public function delete($id)
	{
	    $this->db->where('id', $id);
	    $this->db->delete($this->_table);
	}
	
	public function employee_current_shift($employee_id, $month = null)
	{
	    if (! $month) $month = date('Y-m');
	    else $month = date('Y-m', strtotime($month));
	    
	    $this->db->where('employee_id', $employee_id);
	    $this->db->where('month', $month);
	    return $this->db->get($this->_table, 1)->row_array();
	}
}
