<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Reports_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // get payslip list> reports
    public function get_payslip_list($cid, $eid, $re_date)
    {
  
            if($cid!='')
            {
                $company_str="AND company_id IN($cid)";
            }else{
                $company_str="";
            }

            if($eid!='')
            {
                $employee_str="AND employee_id IN($eid)";
            }else{
                $employee_str="";
            }
        

            $sql = "SELECT * from xin_salary_payslips where salary_month = ? $company_str $employee_str";
            $binds = array($re_date);
            $query = $this->db->query($sql, $binds);

            return $query;

    }
    public function get_payslip_list_new($cid, $dptid, $eid, $re_date)
    {
        if ($eid == '' || $eid == 0) {

            $sql = 'SELECT * from xin_salary_payslips where salary_month = ? and company_id = ?';
            $binds = array($re_date, $cid);
            $query = $this->db->query($sql, $binds);

            return $query;
        } else {

            $sql = 'SELECT * from xin_salary_payslips where employee_id = ? and salary_month = ? and company_id = ?';
            $binds = array($eid, $re_date, $cid);
            $query = $this->db->query($sql, $binds);

            return $query;
        }
    }


    public function get_payroll_list($cid, $eid, $re_date)
    {
        if ($eid == '' || $eid == 0) {

            $sql = 'SELECT * from xin_salary_payslips';
            $binds = array($re_date, $cid);
            $query = $this->db->query($sql, $binds);

            return $query;
        } else {

            $sql = 'SELECT * from xin_salary_payslips';
            $binds = array($eid, $re_date, $cid);
            $query = $this->db->query($sql, $binds);

            return $query;
        }
    }
    
    // get training list> reports
    public function get_training_list($uid,$cid, $sdate, $edate)
    {
        
            if($cid!='')
    	    {
    	        $company_str="AND company_id IN($cid)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($uid!='')
    	    {
    	        $employee_str="AND employee_id IN($uid)";
    	    }else{
    	        $employee_str="";
    	    }

    	    
       
            $sql = "SELECT * from `xin_training` where start_date >= '$sdate' and finish_date <= '$edate'  $company_str $employee_str";
            $query = $this->db->query($sql);
            return $query;

        
    }
    
    public function get_training_list_count($uid,$cid, $sdate, $edate)
    {
        
            if($cid!='')
    	    {
    	        $company_str="AND company_id IN($cid)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($uid!='')
    	    {
    	        $employee_str="AND employee_id IN($uid)";
    	    }else{
    	        $employee_str="";
    	    }

    	    
       
            $sql = "SELECT * from `xin_training` where start_date >= '$sdate' and finish_date <= '$edate'  $company_str $employee_str GROUP BY company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;

        
    }
    

    // get leave list> reports
    
    public function get_leave_application_list()
    {

        $this->db->query("SET SESSION sql_mode = ''");
        $sql = 'SELECT * from `xin_leave_applications` group by employee_id';
        $query = $this->db->query($sql);
        return $query;
    }
    // get filter leave list> reports
    public function get_leave_application_filter_list($sd, $ed, $user_id, $company_id)
    {

        $this->db->query("SET SESSION sql_mode = ''");
        $sql = 'SELECT * from `xin_leave_applications` where company_id = ? and employee_id = ? and from_date >= ? and to_date <= ? group by employee_id';
        $binds = array($company_id, $user_id, $sd, $ed);
        $query = $this->db->query($sql, $binds);
        return $query;
    }

    // get pending leave list> reports
    public function get_pending_leave_application_list($employee_id)
    {

        $sql = 'SELECT * from `xin_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, 1);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // get approved leave list> reports
    public function get_approved_leave_application_list($employee_id)
    {

        $sql = 'SELECT * from `xin_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, 2);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // get upcoming leave list> reports
    public function get_upcoming_leave_application_list($employee_id)
    {

        $sql = 'SELECT * from `xin_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, 4);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // get rejected leave list> reports
    public function get_rejected_leave_application_list($employee_id)
    {

        $sql = 'SELECT * from `xin_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, 3);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    // get only pending leave list> reports
    public function get_pending_leave_list($employee_id, $status)
    {

        $sql = 'SELECT * from `xin_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, $status);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function get_pending_leave_list_annual($employee_id, $status)
    {

        $sql = 'SELECT * from `xin_annual_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, $status);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    // get project list> reports
    public function get_project_list($projId, $projStatus)
    {

        if ($projId == 0 && $projStatus == 'all') {
            return $query = $this->db->query("SELECT * FROM `xin_projects`");
        } else if ($projId == 0 && $projStatus != 'all') {
            $sql = 'SELECT * from `xin_projects` where status = ?';
            $binds = array($projStatus);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($projId != 0 && $projStatus == 'all') {
            $sql = 'SELECT * from `xin_projects` where project_id = ?';
            $binds = array($projId);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($projId != 0 && $projStatus != 'all') {
            $sql = 'SELECT * from `xin_projects` where project_id = ? and status = ?';
            $binds = array($projId, $projStatus);
            $query = $this->db->query($sql, $binds);
            return $query;
        }
    }
    // get employee projects
    public function get_employee_projectsx($id)
    {

        $sql = "SELECT * FROM `xin_projects` where assigned_to like '%$id,%' or assigned_to like '%,$id%' or assigned_to = '$id'";
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        return $query;
    }

    // get task list> reports
    public function get_task_list($taskId, $taskStatus)
    {

        if ($taskId == 0 && $taskStatus == 4) {
            return $query = $this->db->query("SELECT * FROM xin_tasks");
        } else if ($taskId == 0 && $taskStatus != 4) {
            $sql = 'SELECT * from xin_tasks where task_status = ?';
            $binds = array($taskStatus);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($taskId != 0 && $taskStatus == 4) {
            $sql = 'SELECT * from xin_tasks where task_id = ?';
            $binds = array($taskId);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($taskId != 0 && $taskStatus != 4) {
            $sql = 'SELECT * from xin_tasks where task_id = ? and task_status = ?';
            $binds = array($taskId, $taskStatus);
            $query = $this->db->query($sql, $binds);
            return $query;
        }
    }

    // get roles list> reports
    public function get_roles_employees($role_id,$company_id,$location_id)
    {
        
            if($company_id!='')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($role_id!=0)
    	    {
    	        $role_str="AND user_role_id IN($role_id)";
    	    }else{
    	        $role_str="";
    	    }

       
            $sql = "SELECT * from xin_employees where user_id != '' $company_str $location_str $role_str";
            $query = $this->db->query($sql);
            return $query;
            
    }
    
    public function user_role_report_query_count($role_id,$company_id,$location_id){
        
        
            if($company_id!='')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($role_id!=0)
    	    {
    	        $role_str="AND user_role_id IN($role_id)";
    	    }else{
    	        $role_str="";
    	    }

       
            $sql = "SELECT * from xin_employees where user_id != '' $company_str $location_str $role_str GROUP BY company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;
        
        
    }
    // get employees list> reports
    public function get_employees_reports($company_id, $department_id, $designation_id)
    {
        if ($company_id == 0 && $department_id == 0 && $designation_id == 0) {
            return $query = $this->db->query("SELECT * FROM xin_employees where user_id != '1'");
        } else if ($company_id != 0 && $department_id == 0 && $designation_id == 0) {
            $sql = 'SELECT * from xin_employees where company_id = ? and user_id != 1';
            $binds = array($company_id);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $designation_id == 0) {
            $sql = 'SELECT * from xin_employees where company_id = ? and department_id = ? and user_id != 1';
            $binds = array($company_id, $department_id);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $designation_id != 0) {
            $sql = 'SELECT * from xin_employees where company_id = ? and department_id = ? and designation_id = ? and user_id != 1';
            $binds = array($company_id, $department_id, $designation_id);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else {
            return $query = $this->db->query("SELECT * FROM xin_employees where user_id != '1'");
        }
    }
    
    
    public function get_employees_reports_count($company_id, $department_id, $designation_id)
    {
        if ($company_id == 0 && $department_id == 0 && $designation_id == 0) {
            return $query = $this->db->query("SELECT * FROM xin_employees GROUP BY company_id")->result_array();
        } else if ($company_id != 0 && $department_id == 0 && $designation_id == 0) {
            $sql = 'SELECT * from xin_employees where company_id = ? GROUP BY company_id';
            $binds = array($company_id);
            $query = $this->db->query($sql, $binds)->result_array();
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $designation_id == 0) {
            $sql = 'SELECT * from xin_employees where company_id = ? and department_id = ? GROUP BY company_id';
            $binds = array($company_id, $department_id);
            $query = $this->db->query($sql, $binds)->result_array();
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $designation_id != 0) {
            $sql = 'SELECT * from xin_employees where company_id = ? and department_id = ? and designation_id = ? GROUP BY company_id';
            $binds = array($company_id, $department_id, $designation_id);
            $query = $this->db->query($sql, $binds)->result_array();
            return $query;
        } else {
            return $query = $this->db->query("SELECT * FROM xin_employees GROUP BY company_id")->result_array();
        }
    }
    
    // get Leave list> reports
    public function get_leave_reports($company_id, $employee_id, $from_date, $to_date)
    {
        if ($company_id == 0 && $employee_id == 0 && $from_date == 0 && $to_date == 0) {
            return $query = $this->db->query("SELECT * FROM xin_leave_applications");
        } else if ($company_id != 0 && $employee_id == 0 && $from_date == 0 && $to_date == 0) {
            $sql = 'SELECT * from xin_leave_applications where company_id = ?';
            $binds = array($company_id);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $from_date == 0 && $to_date == 0) {
            $sql = 'SELECT * from xin_leave_applications where company_id = ? and $employee_id = ?';
            $binds = array($company_id, $employee_id);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $from_date !== 0 && $to_date == 0) {
            $sql = 'SELECT * from xin_leave_applications where company_id = ? and $employee_id = ? and from_date = ? ';
            $binds = array($company_id, $employee_id, $from_date);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $from_date !== 0 && $to_date !== 0) {
            $sql = 'SELECT * from xin_leave_applications where company_id = ? and employee_id = ? and from_date = ? and to_date = ?';
            $binds = array($company_id, $employee_id, $from_date, $end_date);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else {
            return $query = $this->db->query("SELECT * FROM xin_leave_applications");
        }
    }
    public function get_annual_leave_application_list()
    {

        $this->db->query("SET SESSION sql_mode = ''");
        $sql = 'SELECT * from `xin_annual_leave_applications` group by employee_id';
        $query = $this->db->query($sql);
        return $query;
    }
    public function get_annual_leave_application_filter_list($sd, $ed, $user_id, $company_id)
    {
        $this->db->query("SET SESSION sql_mode = ''");
        $sql = 'SELECT * from `xin_annual_leave_applications` where company_id = ? and employee_id = ? and from_date >= ? and to_date <= ? group by employee_id';
        $binds = array($company_id, $user_id, $sd, $ed);
        $query = $this->db->query($sql, $binds);
        return $query;
    }
    public function get_status_annuval_leave_application_list($employee_id, $status)
    {
        $sql = 'SELECT * from `xin_annual_leave_applications` where employee_id = ? and status = ?';
        $binds = array($employee_id, $status);
        $query = $this->db->query($sql, $binds);
        return $query->num_rows();
    }
    
    public function get_payslip($aj_company, $aj_department, $employee_id, $month_year)
    {
        if ($aj_company == '' && $aj_department == 0 && $employee_id == 0) {

            $sql = 'SELECT * from xin_salary_payslips where salary_month = ?';

            $binds = array($month_year);

            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {

                return $query->result();
            } else {

                return array();
            }
        } else if ($aj_company != '' && $aj_department == 0 && $employee_id == 0) {


            $sql = "SELECT * from xin_salary_payslips where salary_month = ? and company_id IN($aj_company)";

            $binds = array($month_year);

            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {

                return $query->result();
            } else {

                return array();
            }
        } else if ($aj_company != '' && $aj_department != 0 && $employee_id == 0) {

            $sql = "SELECT * from xin_salary_payslips where salary_month = ? and company_id IN($aj_company) and department_id = ?";

            $binds = array($month_year, $aj_department);

            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {

                return $query->result();
            } else {

                return array();
            }
        } else if ($aj_company != '' && $aj_department != 0 && $employee_id != 0) {

            $sql = "SELECT * from xin_salary_payslips where salary_month = ? and company_id IN($aj_company) and department_id = ? and employee_id = ?";

            $binds = array($month_year, $aj_department, $employee_id);

            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {

                return $query->result();
            } else {

                return array();
            }
        } else {

            $sql = 'SELECT * from xin_salary_payslips where salary_month = ?';

            $binds = array($month_year);

            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {

                return $query->result();
            } else {

                return array();
            }
        }
    }
    
        
    public function get_payslip_report($aj_company, $aj_department, $locaion_id, $employee_id, $month_year) {
        
        
            if($aj_company!='')
            {
                $company_str="AND company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($locaion_id!='')
            {
                $location_str="AND location_id IN($locaion_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND employee_id IN($employee_id)";
            }else{
                $employee_str="";
            }
            
            $sql = "SELECT * from xin_salary_payslips where salary_month = '$month_year' $company_str $department_str $location_str $employee_str";
            $query = $this->db->query($sql);
            return $query->result();

        
//      $ids = explode(',',$aj_company);
// 	    $this->db->select('*');
// 		$this->db->from('xin_salary_payslips');
// 		if(!empty($aj_company)){
// 		    $this->db->where_in('company_id',$ids);
// 		}
		
// 		if(!empty($aj_department)){
// 		    $this->db->where('department_id',$aj_department);
// 		}
		
// 		if(!empty($locaion_id)){
// 		    $this->db->where('location_id',$locaion_id);
// 		}
		
// 		if(!empty($employee_id)){
// 		    $this->db->where('employee_id',$employee_id);
// 		}
// 		if(!empty($month_year)){
// 		    $this->db->where('salary_month',$month_year);
// 		}
// 		$query = $this->db->get();
// 		return $query->result();

    }
    
    
    public function get_payslip_new($cid, $dptid, $eid, $re_date)
    {
        if ($re_date) {
            $sql = 'SELECT * from xin_salary_payslips where salary_month = ?';
            $binds = array($re_date);
            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } elseif ($eid == '' || $eid == 0) {

            $sql = 'SELECT * from xin_salary_payslips where salary_month = ? and company_id = ?';
            $binds = array($re_date, $cid);
            $query = $this->db->query($sql, $binds);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } else {

            $sql = 'SELECT * from xin_salary_payslips where employee_id = ? and salary_month = ? and company_id = ?';
            $binds = array($eid, $re_date, $cid);
            $query = $this->db->query($sql, $binds);

            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        }
    }
    public function emp_leave_in_month_year($id, $start_date_y_m)
    {
        $sql = "Select SUM(days) as monthly_leaves FROM xin_leave_applications  WHERE employee_id=?  and from_date LIKE '%$start_date_y_m%'";

        $binds = array($id);

        $query = $this->db->query($sql, $binds);
        // print_r($query);exit;

        $result = $query->result();


        return $result[0]->monthly_leaves;
    }
    public function work_day($year, $month)
    {
        $startdate = strtotime($year . '-' . $month . '-01');
        $enddate = strtotime('+' . (date('t', $startdate) - 1) . ' days', $startdate);
        $currentdate = $startdate;
        $return = intval((date('t', $startdate)), 10);
        //loop through the dates, from the start date to the end date
        while ($currentdate <= $enddate) {
            //if you encounter a Saturday or Sunday, remove from the total days count
            if ((date('D', $currentdate) == 'Sat') || (date('D', $currentdate) == 'Sun')) {
                $return = $return - 1;
            }
            $currentdate = strtotime('+1 day', $currentdate);
        } //end date walk loop
        //return the number of working days
        return $return;
    }
    public function hra($id, $h_id, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';
        $binds = array($id, $h_id, $date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function medi($id, $h_id, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';
        $binds = array($id, $h_id, $date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function car($id, $h_id, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';
        $binds = array($id, $h_id, $date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function mob($id, $h_id, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=?  and salary_month=?';
        $binds = array($id, $h_id, $date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function fuel($id, $h_id, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';
        $binds = array($id, $h_id, $date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function tran($id, $h_id, $date)
    {
        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';
        $binds = array($id, $h_id, $date);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function month_leave($id, $year, $month)
    {
        $sql = "Select SUM(days) as monthly_leaves FROM xin_leave_applications WHERE employee_id=? and YEAR(from_date) = ? AND MONTH(from_date) = ? AND leave_type_id='7'";
        $binds = array($id, $year, $month);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function get_allowances()
    {
        $sql = 'SELECT * FROM allowance WHERE type_id = 1 ';
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function read_employee_info($id)
    {
        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    public function in_t($data)
    {
        $this->db->insert('get_total', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id();
        } else {
            return false;
        }
    }
    public function get_total()
    {
        $sql = 'SELECT * FROM get_total limit 1';
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }



    //rahul report section start

    public function monthly_payslip_get($re_date, $comapny_id, $department_id, $emp_id, $location_company){

        
            if($comapny_id!='')
    	    {
    	        $company_str="AND company_id IN($comapny_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_company!='')
    	    {
    	        $location_str="AND location_id IN($location_company)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($emp_id!='')
    	    {
    	        $employee_str="AND employee_id IN($emp_id)";
    	    }else{
    	        $employee_str="";
    	    }
    	    
    	    $sql = "SELECT * from xin_salary_payslips where salary_month = '$re_date' $company_str $department_str $location_str $employee_str";
            $query = $this->db->query($sql);
            return $query;
        
    }

    public function emp_bank_account($id)
    {

        $sql = 'SELECT * FROM xin_employee_bankaccount WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function lop_days_get($id, $month, $year)
    {
        // $sql = "Select * FROM xin_leave_applications WHERE employee_id=? and YEAR(from_date) = ? AND MONTH(from_date) = ? AND leave_type_id='7'";
        // $binds = array($id, $year, $month);
        // $query = $this->db->query($sql, $binds);
        // if ($query->num_rows() > 0) {
        //     return $query->result();
        // } else {
        //     return null;
        // }
        
        $sql = "Select total_unpaid_count FROM xin_emp_sickleave_manage WHERE emp_id=? and (MONTH(unpaid_start_date) = ? OR MONTH(unpaid_end_date) = ?) and (YEAR(unpaid_start_date) = ? OR YEAR(unpaid_end_date) = ?)";
        $binds = array($id, $month, $month, $year, $year);
        $query = $this->db->query($sql, $binds);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    //  public function get_employee_leave_payslip($id) {
    public function get_employee_leave_payslip($emp_id, $re_date, $comapny_id)
    {

        $this->db->select('days');

        $this->db->where('employee_id', $emp_id);
        $this->db->where('company_id', $comapny_id)->where('status', '2');
        $this->db->like('from_date', $re_date);
        $this->db->like('to_date', $re_date);
        $data1 = $this->db->get('xin_leave_applications')->result_array();

        $leave1 = array_sum(array_column($data1, 'days'));

        $this->db->select('days');
        $this->db->where('employee_id', $emp_id)->where('company_id', $comapny_id)->where('status', '2');
        $this->db->like('from_date', $re_date);
        $this->db->like('to_date', $re_date);
        $data2 = $this->db->get('xin_annual_leave_applications')->result_array();
        $leave2 = array_sum(array_column($data2, 'days'));
        $leave_count = $leave1 + $leave2;
        return $leave_count;




        // 		$sql = 'SELECT * FROM employee_leave WHERE employee_id = ?';
        //  	$binds = array($id);
        // 		$query = $this->db->query($sql, $binds);

        // 		if ($query->num_rows() > 0) {
        //  			return $query->result();
        // 	    } else {
        // 			return null;
        //  		}
    }
    


    public function monthly_payroll_summary_get($aj_company, $location_id, $aj_department, $paysheet_employee_id, $month_year) {
        

            if($aj_company!='')
            {
                $company_str="AND xin_salary_payslips.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_salary_payslips.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_salary_payslips.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($paysheet_employee_id!='')
            {
                $employee_str="AND xin_salary_payslips.employee_id IN($paysheet_employee_id)";
            }else{
                $employee_str="";
            }
            
            $sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.company_id from xin_employees JOIN xin_salary_payslips on xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.salary_month = '$month_year' $company_str $department_str $location_str $employee_str  GROUP BY xin_employees.department_id";
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        
    }



    public function get_head_count($employee_id,$department_id, $month_year)
    {
        if($employee_id!='')
        {
            $employee_str="AND xin_salary_payslips.employee_id IN($employee_id)";
        }else{
            $employee_str="";
        }
        $sql = "SELECT COUNT(*) AS headcount from xin_salary_payslips JOIN xin_departments on xin_departments.department_id=xin_salary_payslips.department_id WHERE xin_departments.department_id = $department_id and xin_salary_payslips.salary_month = '$month_year' $employee_str";

        $binds = array($department_id);

        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }
    
    
    public function get_head_count_emp($emp_id, $month_year) 
    {

        $sql = "SELECT COUNT(*) AS headcount from xin_salary_payslips JOIN xin_departments on xin_departments.department_id=xin_salary_payslips.department_id WHERE xin_salary_payslips.employee_id  IN($emp_id) and xin_salary_payslips.salary_month = '$month_year'";

        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }



    public function basic_pay_get($department_id)
    {

        $sql = "SELECT SUM(basic_salary) AS basic_salary, SUM(total_allowances) AS total_allowances, SUM(total_commissions) AS total_commissions, SUM(total_statutory_deductions) AS total_statutory_deductions, SUM(total_other_payments) AS total_other_payments, SUM(total_loan) AS total_loan, SUM(total_overtime) AS total_overtime, SUM(saudi_gosi_amount) AS saudi_gosi_amount, SUM(statutory_deductions) AS statutory_deductions, SUM(leave_deduction) AS leave_deduction, SUM(net_salary) AS net_salary FROM `xin_salary_payslips` WHERE department_id = ?";

        $binds = array($department_id);

        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }



    //payroll reconciliation code
    public function payroll_reconciliation_get_data()
    {

        return $query = $this->db->query("SELECT * from xin_salary_payslips");
    }

    public function basic_salary_get($current_date)
    {

        return $query = $this->db->query("SELECT SUM(basic_salary) as total_basic_salary from xin_salary_payslips where salary_month = '$current_date'");
    }

    public function compare_data_get($compare_date)
    {

        return $query = $this->db->query("SELECT SUM(basic_salary) as total_compare_basic_salary from xin_salary_payslips where salary_month = '$compare_date'");
    }

    public function basic_salary_details_get($current_date)
    {

        return $query = $this->db->query("SELECT * from xin_salary_payslips where salary_month = '$current_date' Group By employee_id");
    }

    public function compare_data_details_get($emp_id, $compare_date)
    {

        $sql = "SELECT * from xin_salary_payslips where employee_id = $emp_id and salary_month = '$compare_date' Group By employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function allowane_title_get($allowance_title_id)
    {

        $sql = "SELECT * FROM allowance where id = $allowance_title_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function compare_data_details_allo_get($emp_id, $compare_date)
    {

        $sql = "SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = $emp_id and salary_month = '$compare_date' GROUP BY employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function compare_data_details_com_get($emp_id, $compare_date)
    {

        $sql = "SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = $emp_id and salary_month = '$compare_date' GROUP BY employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function compare_data_details_op_get($emp_id, $compare_date)
    {

        $sql = "SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = $emp_id and salary_month = '$compare_date' GROUP BY employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function compare_data_details_sd_get($emp_id, $compare_date)
    {

        $sql = "SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = $emp_id and salary_month = '$compare_date' GROUP BY employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function compare_data_details_pl_get($emp_id, $compare_date)
    {

        $sql = "SELECT * FROM xin_salary_payslip_loan WHERE employee_id = $emp_id and salary_month = '$compare_date' GROUP BY employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function compare_data_details_ld_get($emp_id, $compare_date)
    {

        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id = $emp_id and salary_month = '$compare_date' GROUP BY employee_id";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    //payroll reconciliation end



    //department wise summary
    public function department_wise_summary_get_data($aj_company, $aj_department, $location_id, $month_year, $status) {
        
            if($aj_company!='')
            {
                $company_str="AND xin_salary_payslips.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_salary_payslips.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_salary_payslips.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($status!='all')
            {
                $status_str="AND xin_employees.is_active IN($status)";
            }else{
                $status_str="";
            }

            $sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.company_id from xin_employees JOIN xin_salary_payslips on xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.salary_month = '$month_year' $company_str $department_str $location_str $status_str GROUP BY xin_employees.department_id";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        
    }
    //department wise summary end



    //pay sheet period
    public function pay_sheet_period_data_get($aj_company, $aj_department, $location_id, $paysheet_employee_id, $from_month_year, $to_month_year)
    {


            if($aj_company!='')
            {
                $company_str="AND company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($paysheet_employee_id!='')
            {
                $employee_str="AND employee_id IN($paysheet_employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT * from xin_salary_payslips where salary_month BETWEEN '$from_month_year' and '$to_month_year' $company_str $department_str $location_str $employee_str ORDER BY employee_id ASC";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        
    }


    public function monthly_earning_deduction_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $month_year)
    {

                    if($aj_company!='')
            {
                $company_str="AND company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($paysheet_employee_id!='')
            {
                $employee_str="AND employee_id IN($paysheet_employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT * from xin_salary_payslips where salary_month = '$month_year' $company_str $department_str $location_str $employee_str";
            $query = $this->db->query($sql);
            return $query;
       
    }


//yearly salary report start

    public function year_salary_report_get_data($aj_company, $aj_department, $employee_id, $year, $location_id) {


            if($aj_company!='')
            {
                $company_str="AND xin_salary_payslips.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_salary_payslips.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_salary_payslips.employee_id IN($employee_id)";
            }else{
                $employee_str="";
            }

        $sql = "SELECT xin_salary_payslips.department_id, xin_salary_payslips.employee_id FROM xin_salary_payslips JOIN xin_employees ON xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.salary_month BETWEEN '$year-01' and '$year-12' $company_str $department_str $location_str $employee_str GROUP BY xin_salary_payslips.department_id";
            $query = $this->db->query($sql);
            return $query;

    }

    public function jan_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-01'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function feb_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-02'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function mar_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-03'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function apr_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-04'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function may_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-05'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function jun_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-06'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function jul_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-07'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function aug_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-08'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function sep_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-09'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function oct_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-10'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function nov_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-11'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function dec_sql($emp_id, $year)
    {
        $sql = "SELECT * FROM xin_salary_payslips WHERE employee_id IN($emp_id) and salary_month = '$year-12'";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    //yearly salary report end


    public function overtime_summary_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date)
    {

            if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($paysheet_employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($paysheet_employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id, xin_companies.trading_name, xin_attendance_time.attendance_date, xin_attendance_time.attendance_date, xin_attendance_time.clock_in, xin_attendance_time.clock_out, xin_attendance_time.normal_ot_hours, xin_attendance_time.extra_ot_hours, xin_attendance_time.ot_amount FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies ON  xin_companies.company_id = xin_employees.company_id WHERE xin_attendance_time.attendance_date >= '$start_date' AND xin_attendance_time.attendance_date <= '$end_date' AND xin_attendance_time.ot = 'yes' $company_str $department_str $location_str $employee_str ORDER BY xin_attendance_time.attendance_date";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result_array();
            } else {
                return null;
            }
        
        
    }


    public function nationality_wise_employee_report($company_id, $location_id, $nationality_id, $status_id)
    {

    		if($company_id!='')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($nationality_id!='')
    	    {
    	        $nationality_str="AND nationality_id IN($nationality_id)";
    	    }else{
    	        $nationality_str="";
    	    }

    	    if($status_id!='all')
    	    {
    	        $status_str="AND is_active IN($status_id)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT * from xin_employees INNER JOIN xin_countries ON xin_employees.nationality_id = xin_countries.country_id where user_id != '' $company_str $location_str $nationality_str $status_str Group By xin_employees.nationality_id";
            $query = $this->db->query($sql);
            return $query;

    }
    
    public function nationality_wise_employee_report_pdf($company_id, $location_id, $nationality_id, $status_id){
        
            if($company_id!='')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($nationality_id!='')
    	    {
    	        $nationality_str="AND nationality_id IN($nationality_id)";
    	    }else{
    	        $nationality_str="";
    	    }

    	    if($status_id!='all')
    	    {
    	        $status_str="AND is_active IN($status_id)";
    	    }else{
    	        $status_str="";
    	    }
       
            $nationality_list = "SELECT xin_employees.company_id, xin_employees.nationality_id, xin_countries.country_name, xin_countries.country_code from xin_employees INNER JOIN xin_countries ON xin_employees.nationality_id = xin_countries.country_id where user_id != '' $company_str $location_str $nationality_str $status_str GROUP BY xin_employees.nationality_id, xin_employees.company_id";
            $nationality_list_data = $this->db->query($nationality_list)->result_array();
                
            foreach($nationality_list_data as $key => $val) {
             $sql = "SELECT * from xin_employees INNER JOIN xin_countries ON xin_employees.nationality_id = xin_countries.country_id where user_id != '1' $company_str $location_str $nationality_str $status_str AND xin_employees.nationality_id = ".$val['nationality_id']."";
            $query = $this->db->query($sql)->result_array();
            $nationality_list_data[$key]['list']=$query;
            }
     
            
            return $nationality_list_data;
            
        
    }
    
    public function nationality_wise_employee_report_count($company_id, $location_id, $nationality_id, $status_id){

        	if($company_id!='')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($nationality_id!='')
    	    {
    	        $nationality_str="AND nationality_id IN($nationality_id)";
    	    }else{
    	        $nationality_str="";
    	    }

    	    if($status_id!='all')
    	    {
    	        $status_str="AND is_active IN($status_id)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT * from xin_employees INNER JOIN xin_countries ON xin_employees.nationality_id = xin_countries.country_id where user_id != '' $company_str $location_str $nationality_str $status_str GROUP BY xin_employees.company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;
    }
    

    public function employee_data_get($id)
    {

        $sql = 'SELECT * FROM xin_employees WHERE user_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function assets_issued_to_employee_query($company_id, $department_id, $employee_id, $start_date, $endd_date, $status_id)
    {



        if ($company_id == 0 && $department_id == 0 && $employee_id == 0 && $status_id == 'all') {

            return $query = $this->db->query("SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date'");
        } else if ($company_id != 0 && $department_id == 0 && $employee_id == 0 && $status_id == 'all') {

            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id where xin_employees.company_id IN($company_id) and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date'";

            $query = $this->db->query($sql);

            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $employee_id == 0 && $status_id == 'all') {

            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id where xin_employees.company_id IN($company_id) and xin_employees.company_id IN($company_id) and xin_employees.department_id = $department_id and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date'";

            $query = $this->db->query($sql);

            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $employee_id != 0 && $status_id == 'all') {

            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id where xin_employees.company_id IN($company_id) and xin_employees.department_id = $department_id and xin_employees.user_id = $employee_id and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date'";

            $query = $this->db->query($sql);

            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $employee_id != 0 && $status_id != 'all') {

            $sql = "SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id where xin_employees.company_id IN($company_id) and xin_employees.department_id = $department_id and xin_employees.user_id = $employee_id and xin_employees.is_active = $status_id and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date'";

            $query = $this->db->query($sql);

            return $query;
        } else {

            return $query = $this->db->query("SELECT * from xin_employees INNER JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$endd_date'");
        }
    }

    public function asset_recevied_report_query($end_date, $aj_company, $department_id, $employee_id, $employee_status, $start_date)
    {


        if ($aj_company == '' && $department_id == 0 && $employee_id == 0 && $employee_status == 'all') {
            return $query = $this->db->query("SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' ORDER BY xin_assets.asset_assigned_date ASC");
        } else if ($aj_company != '' && $department_id == 0 && $employee_id == 0 && $employee_status == 'all') {
            $sql = "SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id where xin_employees.company_id IN($aj_company) and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' ORDER BY xin_assets.asset_assigned_date ASC";

            $query = $this->db->query($sql);
            return $query;
        } else if ($aj_company != '' && $department_id != 0 && $employee_id == 0 && $employee_status == 'all') {
            $sql = "SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id where xin_employees.company_id IN($aj_company) and xin_employees.department_id = ? and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' ORDER BY xin_assets.asset_assigned_date ASC";

            $binds = array($department_id);
            $query = $this->db->query($sql, $binds);
            return $query;
        } else if ($aj_company != '' && $department_id != 0 && $employee_id != 0 && $employee_status == 'all') {
            $sql = "SELECT * FROM xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id where xin_employees.company_id IN($aj_company) and xin_employees.department_id = $department_id and xin_employees.user_id = $employee_id and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' ORDER BY xin_assets.asset_assigned_date ASC";

            $query = $this->db->query($sql);
            return $query;
        } else if ($aj_company != '' && $department_id != 0 && $employee_id != 0 && $employee_status != 'all') {

            $sql = "SELECT * FROM xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id where xin_employees.company_id IN($aj_company) and xin_employees.department_id = $department_id and xin_employees.user_id = $employee_id and xin_employees.is_active = $employee_status and xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' ORDER BY xin_assets.asset_assigned_date ASC";

            $query = $this->db->query($sql);
            return $query;
        } else {
            return $query = $this->db->query("SELECT * from xin_employees JOIN xin_assets ON xin_employees.user_id = xin_assets.employee_id JOIN xin_assets_returns ON xin_assets.assets_id = xin_assets_returns.assets_id WHERE xin_assets.asset_assigned_date BETWEEN '$start_date' and '$end_date' ORDER BY xin_assets.asset_assigned_date ASC");
        }
    }


    public function taken_leave_count_check($emp_id, $leave_type, $year){

		$sql = "SELECT * FROM xin_leave_applications WHERE employee_id = ? and leave_type_id = ? and status = 2";
		$binds = array($emp_id, $leave_type);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
		}

		public function taken_leave_count_annual_check($emp_id, $leave_type, $year){

		$sql = "SELECT * FROM xin_annual_leave_applications WHERE employee_id = ? and leave_type_id = ? and status = 2";
		$binds = array($emp_id, $leave_type);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
		}
		
		
	public function leave_balance_report_query($company_id, $location_company, $emp_id, $leave_type, $department_id, $year){

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type != '3' $company_str $employees_str $department_str $location_str $leave_type_str";

            $query = $this->db->query($sql); 
            return $query; 
		    
		}
		
		public function leave_balance_report_annual_query($company_id, $location_company, $emp_id, $leave_type, $department_id, $year){

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type = '3' $company_str $employees_str $department_str $location_str $leave_type_str";

            $query = $this->db->query($sql); 
            return $query; 
		    
		}
		
		public function leave_balance_report_annual_query_count($company_id, $location_company, $emp_id, $leave_type, $department_id, $year){

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type = '3' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
		    
		}

		public function leave_balance_report_query_count($company_id, $location_company, $emp_id, $leave_type, $department_id, $year){

                if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type != '3' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
		    
		}

    public function leave_type_data_get($id)
    {

        $sql = 'SELECT * FROM xin_leave_type WHERE leave_type_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function carryfowards_leave_get($id)
    {

        $sql = 'SELECT * FROM xin_employees_leave_carryfowards WHERE leave_type_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    /* public function get_department_id($id) {
	
		$sql = 'SELECT * FROM xin_departments WHERE department_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	    } */


    public function get_carry_leaves($id)
    {

        $sql = 'SELECT * FROM carry_leaves WHERE employee_id = ?';
        $binds = array($id);
        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function leave_summary_report_query($location_company, $emp_id, $leave_type, $year, $company_id, $department_id){
	        
		if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type != '3' $company_str $employees_str $department_str $location_str $leave_type_str";

            $query = $this->db->query($sql); 
            return $query; 
		    
	}
		
		
	public function leave_summary_annual_report_query($location_company, $emp_id, $leave_type, $year, $company_id, $department_id){
	        
		    if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type = '3' $company_str $employees_str $department_str $location_str $leave_type_str";

            $query = $this->db->query($sql); 
            return $query;    
		    
	}


		public function leave_summary_annual_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id){
	        
		  if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type = '3' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
		    
		}



		public function leave_summary_report_query_count($location_company, $emp_id, $leave_type, $year, $company_id, $department_id){
	        
		    if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND employee_leave.leave_type IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT employee_leave.employee_id, employee_leave.leave_type, employee_leave.leave_count, employee_leave.created_at, xin_leave_type.type_name, xin_leave_type.days_per_year, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_employees.department_id FROM `employee_leave` JOIN xin_leave_type ON employee_leave.leave_type = xin_leave_type.leave_type_id JOIN xin_employees ON employee_leave.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM employee_leave.created_at)='$year' and employee_leave.leave_type != '3' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
		    
		}
		
		
		
    public function leave_register_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id) {

        if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND xin_leave_applications.leave_type_id IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT * from xin_employees JOIN employee_leave ON xin_employees.user_id = employee_leave.employee_id JOIN carry_leaves ON xin_employees.user_id = carry_leaves.employee_id JOIN xin_leave_applications ON xin_employees.user_id = xin_leave_applications.employee_id JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id where xin_leave_applications.from_date >= '$start_date' and xin_leave_applications.to_date <= '$end_date' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_leave_applications.from_date,xin_leave_applications.to_date ORDER BY xin_employees.first_name ASC";

            $query = $this->db->query($sql); 
            return $query; 

    }


    public function leave_register_annual_report_query($end_date, $location_company, $department_id, $emp_id, $leave_type, $start_date, $company_id) {

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND xin_annual_leave_applications.leave_type_id IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT * from xin_employees JOIN employee_leave ON xin_employees.user_id = employee_leave.employee_id JOIN carry_leaves ON xin_employees.user_id = carry_leaves.employee_id JOIN xin_annual_leave_applications ON xin_employees.user_id = xin_annual_leave_applications.employee_id JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id where xin_annual_leave_applications.from_date >= '$start_date' and xin_annual_leave_applications.to_date <= '$end_date' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_annual_leave_applications.from_date,xin_annual_leave_applications.to_date ORDER BY xin_employees.first_name ASC";

            $query = $this->db->query($sql); 
            return $query; 

    }
    
    public function leave_register_annual_report_query_count($end_date,$location_company,$department_id,$emp_id,$leave_type,$start_date,$company_id){
		    

	        if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND xin_annual_leave_applications.leave_type_id IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT * from xin_employees JOIN employee_leave ON xin_employees.user_id = employee_leave.employee_id JOIN carry_leaves ON xin_employees.user_id = carry_leaves.employee_id JOIN xin_annual_leave_applications ON xin_employees.user_id = xin_annual_leave_applications.employee_id JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id where xin_annual_leave_applications.from_date >= '$start_date' and xin_annual_leave_applications.to_date <= '$end_date' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
		    
		}


		public function leave_register_report_query_count($end_date,$location_company,$department_id,$emp_id,$leave_type,$start_date,$company_id){
		    
            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }

            if($leave_type!='0')
            {
                $leave_type_str="AND xin_leave_applications.leave_type_id IN($leave_type)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT * from xin_employees JOIN employee_leave ON xin_employees.user_id = employee_leave.employee_id JOIN carry_leaves ON xin_employees.user_id = carry_leaves.employee_id JOIN xin_leave_applications ON xin_employees.user_id = xin_leave_applications.employee_id JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id where xin_leave_applications.from_date >= '$start_date' and xin_leave_applications.to_date <= '$end_date' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();; 
            return $query; 
		    
		}
		

    //montly salary setup code start

    public function get_gross_salary($emp_id, $depart_id, $month_year)
    {
        if($emp_id!='')
	    {
	        $employees_str="AND employee_id IN($emp_id)";
	    }else{
	        $employees_str="";
	    }

        $sql = "SELECT SUM(net_salary) as gross_salary FROM `xin_salary_payslips` WHERE department_id = $depart_id and salary_month = '$month_year' $employees_str";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function get_gross_salary_emp($user_id, $month_year)
    {

        $sql = "SELECT SUM(net_salary) as gross_salary FROM `xin_salary_payslips` WHERE employee_id IN($user_id) and salary_month = '$month_year' ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function monthly_salary_setup_get_data($aj_company, $aj_department, $location_id, $employee_id, $month_year) {

            if($aj_company!='')
            {
                $company_str="AND xin_salary_payslips.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_salary_payslips.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_salary_payslips.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_salary_payslips.employee_id IN($employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.company_id from xin_employees JOIN xin_salary_payslips on xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.salary_month = '$month_year' $company_str $department_str $location_str $employee_str GROUP BY xin_employees.department_id";
            
            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        
    }
    
    
    public function monthly_salary_setup_get_data_count($aj_company, $aj_department, $location_id, $employee_id, $month_year){
	
		    if($aj_company!='')
            {
                $company_str="AND xin_salary_payslips.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_salary_payslips.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_salary_payslips.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_salary_payslips.employee_id IN($employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.company_id from xin_employees JOIN xin_salary_payslips on xin_salary_payslips.employee_id = xin_employees.user_id WHERE xin_salary_payslips.salary_month = '$month_year' $company_str $department_str $location_str $employee_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
		 	  
    }

    public function get_basic_salary($employee_id, $depart_id, $month_year)
    {
        if($employee_id!='')
        {
            $employee_str="AND xin_salary_payslips.employee_id IN($employee_id)";
        }else{
            $employee_str="";
        }
        
        $sql = "SELECT SUM(basic_salary) as total_salary FROM `xin_salary_payslips` WHERE department_id = $depart_id and salary_month = '$month_year' $employee_str";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    
    public function get_basic_salary_emp($emp_id, $month_year)
    {

        $sql = "SELECT SUM(basic_salary) as total_salary FROM `xin_salary_payslips` WHERE employee_id IN($emp_id) and salary_month = '$month_year' ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }
    //montly salary setup code end


    //salary setup history start
    public function employee_department_join_get($emp_id)
    {

        $sql = "SELECT * FROM `xin_employees` INNER JOIN xin_departments ON xin_employees.department_id = xin_departments.department_id WHERE xin_employees.user_id = $emp_id ";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function salary_setup_history_get_data_fresh($aj_company, $aj_department, $location_id, $employee_id, $from_year, $to_year)
    {

        if ($aj_company == '' && $aj_department == 0 && $location_id == 0 && $employee_id == 0) {

            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.amount, xin_employee_salary_history.date, xin_employee_salary_history.inc_amt, xin_employee_salary_history.inc_or_dec FROM xin_employee_salary_history INNER JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.inc_or_dec = 'inc' and xin_employee_salary_history.date BETWEEN '$from_year-01-01' and '$to_year-12-31' ORDER BY xin_employees.first_name";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } else if ($aj_company != '' && $aj_department == 0 && $location_id == 0 && $employee_id == 0) {


            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.amount, xin_employee_salary_history.date, xin_employee_salary_history.inc_amt, xin_employee_salary_history.inc_or_dec FROM xin_employee_salary_history INNER JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.inc_or_dec = 'inc' and xin_employees.company_id IN($aj_company) AND xin_employee_salary_history.date BETWEEN '$from_year-01-01' and '$to_year-12-31' ORDER BY xin_employees.first_name";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } else if ($aj_company != '' && $aj_department != 0 && $location_id == 0 && $employee_id == 0) {

            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.amount, xin_employee_salary_history.date, xin_employee_salary_history.inc_amt, xin_employee_salary_history.inc_or_dec FROM xin_employee_salary_history INNER JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.inc_or_dec = 'inc' and xin_employees.company_id IN($aj_company) AND xin_employees.department_id = $aj_department AND xin_employee_salary_history.date BETWEEN '$from_year-01-01' and '$to_year-12-31' ORDER BY xin_employees.first_name";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } else if ($aj_company != '' && $aj_department != 0 && $location_id != 0 && $employee_id == 0) {

            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.amount, xin_employee_salary_history.date, xin_employee_salary_history.inc_amt, xin_employee_salary_history.inc_or_dec FROM xin_employee_salary_history INNER JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.inc_or_dec = 'inc' and xin_employees.company_id IN($aj_company) AND xin_employees.department_id = $aj_department AND xin_employees.location_id = $location_id AND xin_employee_salary_history.date BETWEEN '$from_year-01-01' and '$to_year-12-31' ORDER BY xin_employees.first_name";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } else if ($aj_company != '' && $aj_department != 0 && $location_id != 0 && $employee_id != 0) {

            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employee_salary_history.history_type, xin_employee_salary_history.allowance_id, xin_employee_salary_history.amount, xin_employee_salary_history.date, xin_employee_salary_history.inc_amt, xin_employee_salary_history.inc_or_dec FROM xin_employee_salary_history INNER JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.inc_or_dec = 'inc' and xin_employees.company_id IN($aj_company) AND xin_employees.department_id = $aj_department AND xin_employees.location_id = $location_id AND xin_employees.user_id = $employee_id AND xin_employee_salary_history.date BETWEEN '$from_year-01-01' and '$to_year-12-31' ORDER BY xin_employees.first_name";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        } else {

            $sql = "SELECT * FROM xin_employee_salary_history INNER JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.inc_or_dec = 'inc' and xin_employee_salary_history.date BETWEEN '$from_year-01-01' and '$to_year-12-31' ORDER BY xin_employees.first_name";

            $query = $this->db->query($sql);
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return array();
            }
        }
    }
    
    public function salary_setup_history_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date){
        
                     if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($paysheet_employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($paysheet_employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employees.company_id FROM `xin_employee_salary_history` JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.date >= '$start_date-01-01' AND xin_employee_salary_history.date <= '$end_date-12-31' AND xin_employee_salary_history.inc_amt > 0 AND xin_employee_salary_history.inc_or_dec = 'inc' AND xin_employees.user_id != '1' $company_str $department_str $location_str $employee_str Group by xin_employee_salary_history.employee_id";

            $query = $this->db->query($sql);
            return $query;
        
    }


    public function salary_setup_history_get_data_count($aj_company, $aj_department, $location_id, $paysheet_employee_id, $start_date, $end_date){
        
            if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($paysheet_employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($paysheet_employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employees.company_id FROM `xin_employee_salary_history` JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE xin_employee_salary_history.date >= '$start_date-01-01' AND xin_employee_salary_history.date <= '$end_date-12-31' AND xin_employee_salary_history.inc_amt > 0 AND xin_employee_salary_history.inc_or_dec != '' $company_str $department_str $location_str $employee_str Group by xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
        
    }
    //salary setup history end
    
    
    public function get_emp_latest_value_from_the_date($employee_id, $date_his, $his_type)
    {



        $sql = 'SELECT * FROM xin_employee_salary_history WHERE employee_id = ? and date = ? and history_type = ? order by id desc limit 1';

        $binds = array($employee_id, $date_his, $his_type);

        $query = $this->db->query($sql, $binds);

        if ($query->num_rows() > 0) {

            return $query->result();
        } else {

            return null;
        }
    }
    //salary setup history end


        //Detailed Leave Report
    public function list_leave_report_get($company_id, $employee_id, $from_date, $end_date)
    {

        if ($company_id == 0 && $employee_id == 0) {

            $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE from_date >='" . $from_date . "' and to_date<='" . $end_date . "'
        		UNION ALL
        		SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,Null AS reason from xin_annual_leave_applications WHERE from_date >='" . $from_date . "' and to_date<='" . $end_date . "'";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id == 0) {


            $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE company_id='" . $company_id . "' and from_date >='" . $from_date . "' and to_date<='" . $end_date . "'
	        		UNION ALL
	        		SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,Null AS reason from xin_annual_leave_applications WHERE company_id='" . $company_id . "' and from_date >='" . $from_date . "' and to_date<='" . $end_date . "'";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0) {

            $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE company_id='" . $company_id . "' and employee_id='" . $employee_id . "' and from_date >='" . $from_date . "' and to_date<='" . $end_date . "'
        		UNION ALL
        		SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,Null AS reason from xin_annual_leave_applications WHERE company_id='" . $company_id . "' and employee_id='" . $employee_id . "' and from_date >='" . $from_date . "' and to_date<='" . $end_date . "'";

            $query = $this->db->query($sql);
            return $query;
        } else {

            $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE from_date >='" . $from_date . "' and to_date<='" . $end_date . "'
        		UNION ALL
        		SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,Null AS reason from xin_annual_leave_applications WHERE from_date >='" . $from_date . "' and to_date<='" . $end_date . "'";

            $query = $this->db->query($sql);
            return $query;
        }
    }
    
    
    
    public function lwp_information_report_employee_get_query($company_id,$department_id,$location_company,$emp_id,$start_date,$end_date){

	 	    if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }


            $sql = "SELECT xin_employees.company_id, xin_leave_applications.employee_id, xin_employees.department_id, xin_employees.designation_id, xin_employees.employee_id, xin_employees.first_name, xin_employees.last_name, xin_leave_applications.from_date, xin_leave_applications.to_date from xin_employees JOIN xin_leave_applications ON xin_employees.user_id = xin_leave_applications.employee_id where xin_leave_applications.status = 2 and xin_leave_applications.leave_type_id = 7 and xin_leave_applications.from_date >= '$start_date' and xin_leave_applications.to_date <= '$end_date' $company_str $employees_str $department_str $location_str";

            $query = $this->db->query($sql); 
            return $query; 
	 	
	}
	
	public function lwp_information_report_employee_get_table2_query($company_id,$department_id,$location_company,$emp_id,$start_date,$end_date){

	 	    if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }


            $sql = "SELECT xin_employees.company_id, xin_emp_sickleave_manage.emp_id, xin_employees.department_id, xin_employees.designation_id, xin_employees.employee_id, xin_employees.first_name, xin_employees.last_name, xin_emp_sickleave_manage.unpaid_start_date, xin_emp_sickleave_manage.unpaid_end_date from xin_employees JOIN xin_emp_sickleave_manage ON xin_employees.user_id = xin_emp_sickleave_manage.emp_id where xin_emp_sickleave_manage.status = 'Y' and xin_emp_sickleave_manage.unpaid_start_date >= '$start_date' and xin_emp_sickleave_manage.unpaid_end_date <= '$end_date' $company_str $employees_str $department_str $location_str";
            $query = $this->db->query($sql); 
            return $query; 
	 	
	}
	
	public function lwp_information_report_employee_get_query_count($company_id,$department_id,$location_company,$emp_id,$start_date,$end_date){

	 	    if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_company!='')
            {
                $location_str="AND xin_employees.location_id IN($location_company)";
            }else{
                $location_str="";
            }


            $sql = "SELECT xin_employees.company_id, xin_leave_applications.employee_id, xin_employees.department_id, xin_employees.designation_id, xin_employees.employee_id, xin_employees.first_name, xin_employees.last_name, xin_leave_applications.from_date, xin_leave_applications.to_date from xin_employees JOIN xin_leave_applications ON xin_employees.user_id = xin_leave_applications.employee_id where xin_leave_applications.status = 2 and xin_leave_applications.leave_type_id = 7 and xin_leave_applications.from_date >= '$start_date' and xin_leave_applications.to_date <= '$end_date' $company_str $employees_str $department_str $location_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 

	}
	
    
    public function list_leave_report_get_count($company_id, $employee_id, $from_date, $end_date){
        
                 if($company_id == 0 && $employee_id == 0) {

                $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE from_date >='".$from_date."' and to_date<='".$end_date."' GROUP BY company_id";
        
                $query = $this->db->query($sql)->result_array();
			  	return $query;
              

          } else if($company_id != 0 && $employee_id == 0) {


                    $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE company_id='".$company_id."' and from_date >='".$from_date."' and to_date<='".$end_date."' GROUP BY company_id";
            
                    $query = $this->db->query($sql)->result_array();
			  		return $query;

          } else if($company_id != 0 && $employee_id != 0) {

                  $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE company_id='".$company_id."' and employee_id='".$employee_id."' and from_date >='".$from_date."' and to_date<='".$end_date."' GROUP BY company_id";
    
                  $query = $this->db->query($sql)->result_array();
			  		return $query;

          } else {

                $sql = "SELECT employee_id,company_id,leave_type_id,from_date,to_date,remarks,status,days,reason from xin_leave_applications WHERE from_date >='".$from_date."' and to_date<='".$end_date."' GROUP BY company_id";
        
                $query = $this->db->query($sql)->result_array();
			  	return $query;

          }
    }



    //rahul report section end


    public function department_wise_employee_reports($company_id, $department_id, $location_id, $status)
    {

    		if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_employees.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND xin_employees.is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT xin_employees.department_id, xin_employees.designation_id,xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_companies.name, xin_departments.department_name from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE xin_employees.user_id != '' $company_str $department_str $location_str $status_str GROUP BY xin_employees.department_id";
            $query = $this->db->query($sql);
            return $query;

    }
    
    public function department_wise_employee_reports_count($company_id, $department_id, $location_id, $status)
    {

        	if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_employees.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND xin_employees.is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_companies.name, xin_departments.department_name from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE xin_employees.user_id != '' $company_str $department_str $location_str $status_str GROUP BY xin_employees.company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;

    }
    public function get_employees_list_reports($company, $department_id, $location_id, $employee_id, $status)
    {
    		if($company!='')
    	    {
    	        $company_str="AND company_id IN($company)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($employee_id!='')
    	    {
    	        $employee_str="AND user_id IN($employee_id)";
    	    }else{
    	        $employee_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT * from xin_employees where user_id != '' $company_str $department_str $location_str $employee_str $status_str";
            $query = $this->db->query($sql);
            return $query;
        
    }


    public function get_employees_list_reports_count($company, $department_id, $location_id, $employee_id, $status)
    {

        if($company!='')
    	    {
    	        $company_str="AND company_id IN($company)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($employee_id!='')
    	    {
    	        $employee_str="AND user_id IN($employee_id)";
    	    }else{
    	        $employee_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT * from xin_employees where user_id != '' $company_str $department_str $location_str $employee_str $status_str GROUP BY company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;
    }

    public function department_wise_head_count_report($company_id, $department_id, $location_id, $status)
    {

    		if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_employees.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND xin_employees.is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT xin_departments.department_code,xin_employees.company_id, xin_departments.department_name, COUNT(*) AS headcount from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id WHERE user_id != '' $company_str $department_str $location_str $status_str GROUP BY xin_employees.department_id,xin_employees.company_id";
            $query = $this->db->query($sql);
            return $query;

    }
    
    public function department_wise_head_count_report_count($company_id, $department_id, $location_id, $status){
        
            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_employees.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND xin_employees.is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT xin_departments.department_code,xin_employees.company_id, xin_departments.department_name, COUNT(*) AS headcount from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id WHERE user_id != '' $company_str $department_str $location_str $status_str GROUP BY xin_employees.company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;

    }

    public function designation_wise_employee_reports($company_id, $designation_id, $location_id, $status, $department_id)
    {

    		if($company_id!='')
    	    {
    	        $company_str="AND xin_designations.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($designation_id!='')
    	    {
    	        $designation_str="AND xin_designations.designation_id IN($designation_id)";
    	    }else{
    	        $designation_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }
    	    
    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_designations.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND xin_employees.is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT xin_departments.department_name as department_name, xin_employees.designation_id, xin_employees.employee_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_employees.company_id, xin_designations.designation_name from xin_employees JOIN xin_designations on xin_designations.designation_id=xin_employees.designation_id JOIN xin_departments on xin_departments.department_id =xin_employees.department_id   JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE user_id != '' $company_str $designation_str $location_str $department_str $status_str GROUP BY xin_employees.designation_id";
            $query = $this->db->query($sql);
            return $query;

    }
    
    public function designation_wise_employee_reports_count($company_id, $designation_id, $location_id, $status, $department_id){

            if($company_id!='')
    	    {
    	        $company_str="AND xin_designations.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }

    	    if($designation_id!='')
    	    {
    	        $designation_str="AND xin_designations.designation_id IN($designation_id)";
    	    }else{
    	        $designation_str="";
    	    }

    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }
    	    
    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_designations.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }

    	    if($status!='all')
    	    {
    	        $status_str="AND xin_employees.is_active IN($status)";
    	    }else{
    	        $status_str="";
    	    }
       
            $sql = "SELECT xin_employees.employee_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_employees.company_id, xin_designations.designation_name from xin_employees JOIN xin_designations on xin_designations.designation_id=xin_employees.designation_id  JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE user_id != '' $company_str $designation_str $location_str $department_str $status_str GROUP BY xin_employees.company_id";
            $query = $this->db->query($sql)->result_array();
            return $query;

    }

    public function employee_document_expiry_report($company_id, $department_id, $location_id, $document_id, $from_date, $to_date)
    {
        if ($company_id == 0 && $department_id == 0 && $location_id == 0 && $document_id == 0 && $from_date == 0 && $to_date == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $department_id == 0 && $location_id == 0 && $document_id == 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $location_id == 0 && $document_id == 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.department_id IN($department_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $location_id != 0 && $document_id == 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.department_id IN($department_id) and  xin_employees.location_id IN($location_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $department_id != 0 && $location_id != 0 && $document_id != 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.department_id IN($department_id) and  xin_employees.location_id IN($location_id) xin_employee_documents.document_id IN($document_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $department_id != 0 && $location_id == 0 && $document_id == 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employees.department_id IN($department_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $department_id == 0 && $location_id != 0 && $document_id == 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $department_id == 0 && $location_id == 0 && $document_id != 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employee_documents.document_id IN($document_id) and xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $department_id == 0 && $location_id == 0 && $document_id == 0 && $from_date != 0 && $to_date != 0) {
            # code...
            $sql = "SELECT xin_employees.company_id,xin_employees.first_name,xin_employees.last_name, xin_employees.department_id, xin_employees.designation_id, xin_employees.date_of_joining, xin_employee_documents.title, xin_employee_documents.date_of_expiry from xin_employees JOIN xin_employee_documents on xin_employee_documents.employee_id=xin_employees.user_id WHERE xin_employee_documents.date_of_expiry BETWEEN '$from_date' and '$to_date'";
            $query = $this->db->query($sql);
            return $query;
        }
    }

    public function employee_monthly_leave_taken_report($company_id, $employee_id, $department_id, $leave_id, $year, $location_id) {

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($leave_id!='0')
            {
                $leave_type_str="AND xin_leave_applications.leave_type_id IN($leave_id)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT DISTINCT xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id,xin_employees.designation_id,xin_employees.date_of_joining from xin_employees JOIN xin_leave_applications on xin_leave_applications.employee_id=xin_employees.user_id WHERE EXTRACT(YEAR FROM xin_leave_applications.from_date)='$year' $company_str $employees_str $department_str $location_str $leave_type_str";

            $query = $this->db->query($sql); 
            return $query; 

    }
    
    public function employee_monthly_annual_leave_taken_report($company_id,$employee_id,$department_id,$leave_id,$year,$location_id){

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($leave_id!='0')
            {
                $leave_type_str="AND xin_annual_leave_applications.leave_type_id IN($leave_id)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT DISTINCT xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id,xin_employees.designation_id,xin_employees.date_of_joining from xin_employees JOIN xin_annual_leave_applications on xin_annual_leave_applications.employee_id=xin_employees.user_id WHERE EXTRACT(YEAR FROM xin_annual_leave_applications.from_date)='$year' $company_str $employees_str $department_str $location_str $leave_type_str";

            $query = $this->db->query($sql); 
            return $query; 
        
	}
	
	public function employee_monthly_annual_leave_taken_report_count($company_id,$employee_id,$department_id,$leave_id,$year,$location_id){

        if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($leave_id!='0')
            {
                $leave_type_str="AND xin_annual_leave_applications.leave_type_id IN($leave_id)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT DISTINCT xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id,xin_employees.designation_id,xin_employees.date_of_joining from xin_employees JOIN xin_annual_leave_applications on xin_annual_leave_applications.employee_id=xin_employees.user_id WHERE EXTRACT(YEAR FROM xin_annual_leave_applications.from_date)='$year' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
        
	}

	public function employee_monthly_leave_taken_report_count($company_id,$employee_id,$department_id,$leave_id,$year,$location_id){

            if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($leave_id!='0')
            {
                $leave_type_str="AND xin_leave_applications.leave_type_id IN($leave_id)";
            }else{
                $leave_type_str="";
            }



            $sql = "SELECT DISTINCT xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id,xin_employees.designation_id,xin_employees.date_of_joining from xin_employees JOIN xin_leave_applications on xin_leave_applications.employee_id=xin_employees.user_id WHERE EXTRACT(YEAR FROM xin_leave_applications.from_date)='$year' $company_str $employees_str $department_str $location_str $leave_type_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 
        
	}

    public function get_monthly_leave_taken($user_id, $year)
    {
        $january_count = 1;
        $february_count = 1;
        $march_count = 1;
        $april_count = 1;
        $may_count = 1;
        $june_count = 1;
        $july_count = 1;
        $august_count = 1;
        $september_count = 1;
        $october_count = 1;
        $november_count = 1;
        $december_count = 1;
        $data = array();

         $sql = "SELECT leave_id,leave_type_id,employee_id,from_date,to_date,is_half_day from xin_leave_applications WHERE YEAR(from_date) = '$year' and employee_id='$user_id'";

        //print_r($sql);

        $query = $this->db->query($sql);

        # code...
        foreach ($query->result() as $row) {

            //get leave type name
            $sqll = "SELECT type_name from xin_leave_type WHERE leave_type_id = '$row->leave_type_id'";
            $leave_type_name = $this->db->query($sqll);
            $leave_type_name = $leave_type_name->row_array();
            $leave_type_name = $leave_type_name['type_name'];
            //get leave type name
            # code...
            $from_date = $row->from_date;
            $to_date = $row->to_date;

            if ($from_date == $to_date && $row->is_half_day == 1) {
                $january_count = 0.5;
                $february_count = 0.5;
                $march_count = 0.5;
                $april_count = 0.5;
                $may_count = 0.5;
                $june_count = 0.5;
                $july_count = 0.5;
                $august_count = 0.5;
                $september_count = 0.5;
                $october_count = 0.5;
                $november_count = 0.5;
                $december_count = 0.5;
                # code...
                $month_name = date('F', strtotime($from_date));
                if ($month_name == 'January') {
                    # code...
                    $january_count = $january_count + 0.5;
                    $data[$leave_type_name][$month_name] = $january_count;
                } else if ($month_name == 'February') {
                    # code...
                    $february_count = $february_count + 0.5;
                    $data[$leave_type_name][$month_name] = $february_count;
                } else if ($month_name == 'March') {
                    # code...
                    $march_count = $march_count + 0.5;
                    $data[$leave_type_name][$month_name] = $march_count;
                } else if ($month_name == 'April') {
                    # code...
                    $april_count = $april_count + 0.5;
                    $data[$leave_type_name][$month_name] = $april_count;
                } else if ($month_name == 'May') {
                    # code...
                    $may_count = $may_count + 0.5;
                    $data[$leave_type_name][$month_name] = $may_count;
                } else if ($month_name == 'June') {
                    # code...
                    $june_count = $june_count + 0.5;
                    $data[$leave_type_name][$month_name] = $june_count;
                } else if ($month_name == 'July') {
                    # code...
                    $july_count = $july_count + 0.5;
                    $data[$leave_type_name][$month_name] = $july_count;
                } else if ($month_name == 'August') {
                    # code...
                    $august_count = $august_count + 0.5;
                    $data[$leave_type_name][$month_name] = $august_count;
                } else if ($month_name == 'September') {
                    # code...
                    $september_count = $september_count + 0.5;
                    $data[$leave_type_name][$month_name] = $september_count;
                } else if ($month_name == 'October') {
                    # code...
                    $october_count = $october_count + 0.5;
                    $data[$leave_type_name][$month_name] = $october_count;
                } else if ($month_name == 'November') {
                    # code...
                    $november_count = $november_count + 0.5;
                    $data[$leave_type_name][$month_name] = $november_count;
                } else if ($month_name == 'December') {
                    # code...
                    $december_count = $december_count + 0.5;
                    $data[$leave_type_name][$month_name] = $december_count;
                }
            } else {
                while ($from_date <= $to_date) {
                    $month_name = date('F', strtotime($from_date));
                    if ($month_name == 'January') {
                        # code...
                        $data[$leave_type_name][$month_name] = $january_count++;
                    } else if ($month_name == 'February') {
                        # code...
                        $data[$leave_type_name][$month_name] = $february_count++;
                    } else if ($month_name == 'March') {
                        # code...
                        $data[$leave_type_name][$month_name] = $march_count++;
                    } else if ($month_name == 'April') {
                        # code...
                        $data[$leave_type_name][$month_name] = $april_count++;
                    } else if ($month_name == 'May') {
                        # code...
                        $data[$leave_type_name][$month_name] = $may_count++;
                    } else if ($month_name == 'June') {
                        # code...
                        $data[$leave_type_name][$month_name] = $june_count++;
                    } else if ($month_name == 'July') {
                        # code...
                        $data[$leave_type_name][$month_name] = $july_count++;
                    } else if ($month_name == 'August') {
                        # code...
                        $data[$leave_type_name][$month_name] = $august_count++;
                    } else if ($month_name == 'September') {
                        # code...
                        $data[$leave_type_name][$month_name] = $september_count++;
                    } else if ($month_name == 'October') {
                        # code...
                        $data[$leave_type_name][$month_name] = $october_count++;
                    } else if ($month_name == 'November') {
                        # code...
                        $data[$leave_type_name][$month_name] = $november_count++;
                    } else if ($month_name == 'December') {
                        # code...
                        $data[$leave_type_name][$month_name] = $december_count++;
                    }

                    $from_date = date('Y-m-d', strtotime($from_date . " +1 days"));
                }
            }
        }
        //print_r($row->employee_id);
        //print_r($data);
        return $data;
    }
    
    public function get_monthly_leave_annual_taken($user_id,$year){
		$january_count=1;
		$february_count = 1;
		$march_count = 1;
		$april_count = 1;
		$may_count = 1;
		$june_count = 1;
		$july_count = 1;
		$august_count = 1;
		$september_count = 1;
		$october_count = 1;
		$november_count = 1;
		$december_count = 1;
		$data = array();

		$sql = "SELECT id,leave_type_id,employee_id,from_date,to_date from xin_annual_leave_applications WHERE YEAR(from_date) = '$year' and employee_id='$user_id'";

		//print_r($sql);

		$query1 = $this->db->query($sql);

			# code...
		foreach ($query1->result() as $row) {

		//get leave type name
			$sqll = "SELECT type_name from xin_leave_type WHERE leave_type_id = '$row->leave_type_id'";
			$leave_type_name = $this->db->query($sqll);
			$leave_type_name = $leave_type_name->row_array();
			$leave_type_name = $leave_type_name['type_name'];
			//get leave type name
			# code...
			$from_date = $row->from_date;
			$to_date = $row->to_date;

			if ($from_date == $to_date) {
				$january_count=0.5;
				$february_count = 0.5;
				$march_count = 0.5;
				$april_count = 0.5;
				$may_count = 0.5;
				$june_count = 0.5;
				$july_count = 0.5;
				$august_count = 0.5;
				$september_count = 0.5;
				$october_count = 0.5;
				$november_count = 0.5;
				$december_count = 0.5;
				# code...
				$month_name = date('F', strtotime( $from_date));
				if ($month_name == 'January') {
					# code...
					$january_count = $january_count + 0.5;
					$data[$leave_type_name][$month_name] = $january_count;
				}
				else if ($month_name == 'February') {
					# code...
					$february_count = $february_count + 0.5;
					$data[$leave_type_name][$month_name] = $february_count;
				}
				else if ($month_name == 'March') {
					# code...
					$march_count = $march_count + 0.5;
					$data[$leave_type_name][$month_name] = $march_count;
				}
				else if ($month_name == 'April') {
					# code...
					$april_count = $april_count + 0.5;
					$data[$leave_type_name][$month_name] = $april_count;
				}
				else if ($month_name == 'May') {
					# code...
					$may_count = $may_count + 0.5;
					$data[$leave_type_name][$month_name] = $may_count;
				}
				else if ($month_name == 'June') {
					# code...
					$june_count = $june_count + 0.5;
					$data[$leave_type_name][$month_name] = $june_count;
				}
				else if ($month_name == 'July') {
					# code...
					$july_count = $july_count + 0.5;
					$data[$leave_type_name][$month_name] = $july_count;
				}
				else if ($month_name == 'August') {
					# code...
					$august_count = $august_count + 0.5;
					$data[$leave_type_name][$month_name] = $august_count;
				}
				else if ($month_name == 'September') {
					# code...
					$september_count = $september_count + 0.5;
					$data[$leave_type_name][$month_name] = $september_count;
				}
				else if ($month_name == 'October') {
					# code...
					$october_count = $october_count + 0.5;
					$data[$leave_type_name][$month_name] = $october_count;
				}
				else if ($month_name == 'November') {
					# code...
					$november_count = $november_count + 0.5;
					$data[$leave_type_name][$month_name] = $november_count;
				}
				else if ($month_name == 'December') {
					# code...
					$december_count = $december_count + 0.5;
					$data[$leave_type_name][$month_name] = $december_count;
				}
			}
			else{
				while ( $from_date<= $to_date) {
				$month_name = date('F', strtotime( $from_date));
				if ($month_name == 'January') {
					# code...
					$data[$leave_type_name][$month_name] = $january_count++;
				}
				else if ($month_name == 'February') {
					# code...
					$data[$leave_type_name][$month_name] = $february_count++;
				}
				else if ($month_name == 'March') {
					# code...
					$data[$leave_type_name][$month_name] = $march_count++;
				}
				else if ($month_name == 'April') {
					# code...
					$data[$leave_type_name][$month_name] = $april_count++;
				}
				else if ($month_name == 'May') {
					# code...
					$data[$leave_type_name][$month_name] = $may_count++;
				}
				else if ($month_name == 'June') {
					# code...
					$data[$leave_type_name][$month_name] = $june_count++;
				}
				else if ($month_name == 'July') {
					# code...
					$data[$leave_type_name][$month_name] = $july_count++;
				}
				else if ($month_name == 'August') {
					# code...
					$data[$leave_type_name][$month_name] = $august_count++;
				}
				else if ($month_name == 'September') {
					# code...
					$data[$leave_type_name][$month_name] = $september_count++;
				}
				else if ($month_name == 'October') {
					# code...
					$data[$leave_type_name][$month_name] = $october_count++;
				}
				else if ($month_name == 'November') {
					# code...
					$data[$leave_type_name][$month_name] = $november_count++;
				}
				else if ($month_name == 'December') {
					# code...
					$data[$leave_type_name][$month_name] = $december_count++;
				}
				
				$from_date = date('Y-m-d', strtotime( $from_date . " +1 days"));
			}
			}
		}	
		//print_r($row->employee_id);
		//print_r($data);
	    return $data;
	}

    public function employee_advance_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status)
    {

        if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.employee_id IN($employee_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_employees.e_status IN($status) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.month_year,xin_advance_salaries.monthly_installment,xin_advance_salaries.status,xin_advance_salaries.end_date,SUM(xin_advance_deductions_monthwise.amount) AS Total_advance_amount from xin_employees JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id WHERE xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        }
    }

    public function get_Total_deducted_amount_loan_report($user_id)
    {
        $sql = "SELECT SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_deducted_amount from xin_salary_loan_deductions_monthwise JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_salary_loan_deductions_monthwise.employee_id WHERE xin_salary_loan_deductions.status = '1' and xin_salary_loan_deductions.employee_id = '$user_id'";

        $query = $this->db->query($sql);
        return $query;
    }

    public function employee_loan_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status)
    {
        if ($company_id != 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.employee_id IN($employee_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.e_status IN($status) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            //print_r($from_date);print_r($to_date);exit();
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT xin_employees.company_id,xin_employees.user_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_title,xin_salary_loan_deductions.loan_deduction_amount,xin_salary_loan_deductions.start_date,xin_salary_loan_deductions.status,xin_salary_loan_deductions.end_date,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_employees.e_status IN($status) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1  GROUP BY xin_salary_loan_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        }
    }

    public function employee_advance_loan_outstanding_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status)
    {
        if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date == 0 && $to_date == 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id != 0 && $location_id == 0 && $from_date == 0 && $to_date == 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.employee_id IN($employee_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.employee_id IN($employee_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id != 0 && $from_date == 0 && $to_date == 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_employees.e_status IN($status) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_employees.e_status IN($status) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT 'xin_salary_loan_deductions_monthwise' AS table_name,xin_employees.company_id,xin_salary_loan_deductions.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year,SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_advance_salaries.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year,SUM(xin_advance_deductions_monthwise.amount) AS Total_loan_amount from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        }
    }

    public function get_Total_deducted_advance_loan_report($user_id, $table_name)
    {

        if ($table_name == 'xin_salary_loan_deductions_monthwise') {
            # code...
            $sql = "SELECT SUM(xin_salary_loan_deductions_monthwise.amount) AS Total_deducted_amount from xin_salary_loan_deductions_monthwise JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_salary_loan_deductions_monthwise.employee_id WHERE xin_salary_loan_deductions.status = '1' and xin_salary_loan_deductions.employee_id = '$user_id'";
            $query = $this->db->query($sql);
            return $query->result();
        } else if ($table_name == 'xin_advance_deductions_monthwise') {
            # code...
            $sql = "SELECT SUM(xin_advance_deductions_monthwise.amount) AS Total_deducted_amount from xin_advance_deductions_monthwise JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_advance_deductions_monthwise.employee_id WHERE xin_advance_salaries.status = '1' and xin_advance_salaries.employee_id = '$user_id'";
            $query = $this->db->query($sql);
            return $query->result();
        }
    }

    public function get_advance_loan_employee($employee_id, $helper_id, $table_name)
    {
        if ($table_name == 'xin_salary_loan_deductions_monthwise') {
            # code...
            $sql = 'SELECT month_year,amount AS monthly_installment from xin_salary_loan_deductions_monthwise where loan_id = ? and employee_id = ?';
            $binds = array($helper_id, $employee_id);
            $query = $this->db->query($sql, $binds);
            return $query->result();
        } else if ($table_name == 'xin_advance_deductions_monthwise') {
            # code...
            $sql = "SELECT month_year,amount AS monthly_installment from xin_advance_deductions_monthwise WHERE advance_id= ? and employee_id = ?";
            $binds = array($helper_id, $employee_id);
            $query = $this->db->query($sql, $binds);
            return $query->result();
        }
    }

    public function employee_advance_loan_register_report($company_id, $employee_id, $location_id, $from_date, $to_date, $status)
    {
        if ($company_id != 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) AND xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) AND xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1  GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.employee_id IN($employee_id) AND xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.employee_id IN($employee_id) AND xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) AND xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.location_id IN($location_id) AND xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.e_status='$status' AND xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.e_status='$status' AND xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) AND xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) AND xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) AND xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) AND xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id != 0 && $employee_id != 0 && $location_id != 0 && $from_date != 0 && $to_date != 0 && $status != 0) {
            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_employees.e_status='$status' and xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_employees.company_id IN($company_id) and xin_employees.employee_id IN($employee_id) and xin_employees.location_id IN($location_id) and xin_employees.e_status='$status' and xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        } else if ($company_id == 0 && $employee_id == 0 && $location_id == 0 && $from_date != 0 && $to_date != 0 && $status == 0) {
            // $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.end_date BETWEEN '$from_date' and '$to_date' GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
            // 	UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.end_date BETWEEN '$from_date' and '$to_date' GROUP BY xin_advance_deductions_monthwise.employee_id";

            // $query = $this->db->query($sql);
            // return $query;


            $sql = "SELECT 'xin_salary_loan_deductions' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_salary_loan_deductions.loan_deduction_id AS advance_or_loan_count_helper_id,xin_salary_loan_deductions.loan_deduction_amount AS monthly_installment,xin_salary_loan_deductions.monthly_installment AS Amount,xin_salary_loan_deductions.start_date AS month_year from xin_employees JOIN xin_salary_loan_deductions_monthwise on xin_salary_loan_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_salary_loan_deductions on xin_salary_loan_deductions.employee_id=xin_employees.user_id WHERE xin_salary_loan_deductions.start_date >= '$from_date' AND xin_salary_loan_deductions.end_date <= '$to_date' AND xin_salary_loan_deductions.final_approval = 1 GROUP BY xin_salary_loan_deductions_monthwise.employee_id 
				UNION ALL SELECT 'xin_advance_deductions_monthwise' AS table_name,xin_employees.company_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_advance_salaries.advance_salary_id AS advance_or_loan_count_helper_id,xin_advance_salaries.monthly_installment AS monthly_installment,xin_advance_salaries.advance_amount AS Amount,xin_advance_salaries.start_date AS month_year from xin_employees JOIN xin_advance_deductions_monthwise on xin_advance_deductions_monthwise.employee_id=xin_employees.user_id JOIN xin_advance_salaries on xin_advance_salaries.employee_id=xin_employees.user_id WHERE xin_advance_salaries.start_date >= '$from_date' AND xin_advance_salaries.end_date <= '$to_date' AND xin_advance_salaries.final_approval = 1 GROUP BY xin_advance_deductions_monthwise.employee_id";

            $query = $this->db->query($sql);
            return $query;
        }
    }

    public function read_number_of_installment_of_advance_or_loan($advance_or_loan_count_helper_id, $table_name)
    {
        if ($table_name == 'xin_salary_loan_deductions') {
            # code...
            $sql = 'SELECT loan_time AS number_of_installment from xin_salary_loan_deductions where loan_deduction_id  = ?';
            $binds = array($advance_or_loan_count_helper_id);
            $query = $this->db->query($sql, $binds);
            return $query->result();
        } else if ($table_name == 'xin_advance_deductions_monthwise') {
            # code...
            $sql = "SELECT COUNT(*) AS number_of_installment from xin_advance_deductions_monthwise WHERE advance_id='$advance_or_loan_count_helper_id' GROUP BY advance_id";
            $query = $this->db->query($sql);
            return $query->result();
        }
    }

	public function employee_late_in_request_status_report($aj_company,$aj_department,$location_id,$emp_id,$from_date,$to_date){
                    if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($emp_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($emp_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $department_str $location_str $employee_str Group by xin_attendance_time.attendance_date";

            $query = $this->db->query($sql);
            return $query;
	}


	public function employee_late_in_request_status_report_count($aj_company,$aj_department,$location_id,$emp_id,$from_date,$to_date){

		            if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($emp_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($emp_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $department_str $location_str $employee_str Group by xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
		  
	}
	
	public function employee_early_out_request_status_get($aj_company,$aj_department,$location_id,$emp_id,$from_date,$to_date){

            if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($emp_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($emp_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $department_str $location_str $employee_str";

            $query = $this->db->query($sql);
            return $query;
		 
	}


	public function employee_early_out_request_status_get_count($aj_company,$aj_department,$location_id,$emp_id,$from_date,$to_date){

		    if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($emp_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($emp_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $department_str $location_str $employee_str Group by xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;

	}

    public function check_employee_leave($user_id, $att_date)
    {
        // $sql = 'SELECT * from xin_leave_applications where  employee_id = ? and status = 2 and ((from_date >=  ? and to_date <= ?) )';

        $sql = "SELECT * from xin_leave_applications where  employee_id = '$user_id' and status = 2 and '$att_date' BETWEEN from_date AND to_date";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    public function read_employee_office_shift($office_shift_id)
    {
        $sql = "SELECT * from xin_office_shift WHERE office_shift_id ='$office_shift_id'";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_clock_in_time($user_id, $att_date)
    {
        $i = 0;
        $data = array();

        $sql = "SELECT employee_id,clock_in from xin_attendance_time WHERE employee_id = '$user_id' AND DATE(clock_in) = '$att_date'";
        //print_r($sql);
        $query = $this->db->query($sql);
        foreach ($query->result() as $row) {
            # code...
            $data[$i++] =  $row->clock_in;
        }
        //print_r($data[0]);
        return $data[0];
    }

    public function get_clock_out_time($user_id, $att_date)
    {
        $i = 0;
        $data = array();

        $sql = "SELECT employee_id,clock_out from xin_attendance_time WHERE employee_id = '$user_id' AND DATE(clock_in) = '$att_date'";
        //print_r($sql);
        $query = $this->db->query($sql);
        //print_r($query->result());
        //reverse the array to ghet last clock out
        $result = array_reverse($query->result());
        foreach ($result as $row) {
            # code...
            $data[$i++] =  $row->clock_out;
        }
        //print_r($data[0]);exit();
        return $data[0];
    }

    public function employee_daily_attendance_report_result($company_id,$department_id,$employee_id,$location_id,$from_date,$to_date){

			            if($company_id!='')
            {
                $company_str="AND xin_employees.company_id IN($company_id)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT DISTINCT xin_employees.company_id,xin_employees.department_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' $company_str $department_str $location_str $employee_str Group by xin_employees.department_id";

            $query = $this->db->query($sql);
            return $query;

	}


	public function employee_daily_attendance_report_result_count($company_id,$department_id,$employee_id,$location_id,$from_date,$to_date){

			            if($company_id!='')
            {
                $company_str="AND xin_employees.company_id IN($company_id)";
            }else{
                $company_str="";
            }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($employee_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($employee_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT DISTINCT xin_employees.company_id,xin_employees.department_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' $company_str $department_str $location_str $employee_str Group by xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;

	}
	
	public function get_early_leave_data($user_id, $att_date){

		$sql = "SELECT * from xin_attendance_time_total WHERE employee_id = '$user_id' AND date = '$att_date'";
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}

	}

    public function get_all_attendance_date($user_id, $from_date, $to_date)
    {
        $data=array();
        $i = 0;
        while ($from_date <= $to_date) {
            // 	# code...

            $sql = "SELECT attendance_date,attendance_status from xin_attendance_time WHERE employee_id = '$user_id' AND attendance_date = '$from_date' limit 1";
            $query = $this->db->query($sql);

            if ($query->num_rows() > 0) {
                $data[$user_id][$i++] = $query->result();
            }
            //add one day to from_date
            $from_date = date('Y-m-d', strtotime($from_date . " +1 days"));
        }
        return $data;
    }

    public function get_total_work_hours($user_id, $att_date)
    {
        //print_r($user_id);print_r($att_date);exit();
        $sql = "SELECT * from xin_attendance_time_total WHERE employee_id ='$user_id' and `date`='$att_date'";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function calculate_employee_odd_punch($user_id, $att_date)
    {
        //odd punch is zero when clockin count and clockout count become equal
        $sql1 = "SELECT COUNT(*) AS clockin_count from xin_attendance_time WHERE employee_id ='$user_id' and DATE(clock_in) = '$att_date'";
        $query1 = $this->db->query($sql1)->row_array();
        $clockin_count = $query1['clockin_count'];

        $sql2 = "SELECT COUNT(*) AS clockout_count from xin_attendance_time WHERE employee_id ='$user_id' and DATE(clock_out) = '$att_date'";
        $query2 = $this->db->query($sql2)->row_array();
        $clockout_count = $query2['clockout_count'];

        return $odd_punch = $clockin_count - $clockout_count;
    }

	public function employee_starting_checkin_checkout_report($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date){

		             if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($emp_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($emp_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.user_id,xin_attendance_time.attendance_date, xin_attendance_time.clock_in_time, xin_attendance_time.clock_out_time from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $department_str $location_str $employee_str";

            $query = $this->db->query($sql);
            return $query;
	
	}
	

	public function employee_starting_checkin_checkout_report_count($aj_company, $aj_department, $location_id, $emp_id, $from_date, $to_date){

		    if($aj_company!='')
            {
                $company_str="AND xin_employees.company_id IN($aj_company)";
            }else{
                $company_str="";
            }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            if($emp_id!='')
            {
                $employee_str="AND xin_employees.user_id IN($emp_id)";
            }else{
                $employee_str="";
            }


            $sql = "SELECT xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name, xin_employees.last_name, xin_employees.department_id, xin_employees.user_id,xin_attendance_time.attendance_date, xin_attendance_time.clock_in_time, xin_attendance_time.clock_out_time from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $department_str $location_str $employee_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
	
	}


    public function read_clockin_datetime($user_id, $from_date, $to_date)
    {

        //print_r($from_date);exit();
        $i = 0;
        $result = array();
        $new_array = array();
        while ($from_date <= $to_date) {
            // 	# code...

            $sql1 = "SELECT employee_id,clock_in,attendance_date from xin_attendance_time WHERE employee_id = '$user_id' AND DATE(clock_in) = '$from_date' ORDER BY clock_in DESC LIMIT 1";

            //print_r($sql1);
            $query = $this->db->query($sql1);
            //print_r($query->result());
            foreach ($query->result() as $row) {
                # code...
                $sql2 = "SELECT clock_out from xin_attendance_time WHERE employee_id = '$user_id' AND attendance_date = '$row->attendance_date' ORDER BY clock_out DESC LIMIT 1";
                $query2 = $this->db->query($sql2);
                //print_r($query2->result());
                $array = array_merge($query->result(), $query2->result());
                //print_r($array);
                //Join one array with multiple index as single indexed new array

                foreach ($array as $value) {
                    foreach ($value as $k => $v) {
                        $new_array[$k] = $v;
                    }
                }
                //print_r($new_array);
                $data[$user_id][$i++] = $new_array;
            }
            //add one day to from_date
            $from_date = date('Y-m-d', strtotime($from_date . " +1 days"));
            //array_merge() 
        }
        //print_r($data);
        $result = array();
        foreach ($data as $array) {
            $result = array_merge($result, $array);
            //print_r($result);
        }
        return $result;
    }


    public function salary_progression_history_report($aj_company, $aj_department, $location_id, $paysheet_employee_id, $year){
		
		    if($aj_company!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($aj_company)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($paysheet_employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($paysheet_employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }



            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employees.company_id FROM `xin_employee_salary_history` JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM xin_employee_salary_history.date)='$year' AND xin_employee_salary_history.inc_amt > 0 AND xin_employee_salary_history.inc_or_dec = 'inc' AND xin_employees.user_id != 1 $company_str $employees_str $department_str $location_str Group by xin_employee_salary_history.employee_id";

            $query = $this->db->query($sql);
            return $query;

	}


	public function salary_progression_history_report_count($aj_company, $aj_department, $location_id, $paysheet_employee_id, $year){
		
		    if($aj_company!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($aj_company)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($paysheet_employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($paysheet_employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }



            $sql = "SELECT xin_employee_salary_history.employee_id, xin_employees.company_id FROM `xin_employee_salary_history` JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE EXTRACT(YEAR FROM xin_employee_salary_history.date)='$year' AND xin_employee_salary_history.inc_amt > 0 AND xin_employee_salary_history.inc_or_dec != '' $company_str $employees_str $department_str $location_str Group by xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
	}

    public function get_allowance_titles($year)
    {
        $sql = "SELECT DISTINCT xin_salary_allowances.allowance_title from xin_salary_allowances JOIN xin_employee_salary_history ON xin_employee_salary_history.allowance_id=xin_salary_allowances.allowance_id  WHERE xin_employee_salary_history.inc_or_dec='inc' AND EXTRACT(YEAR FROM xin_employee_salary_history.date)='$year'";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_allowance_amount($allowance_title)
    {
        $sql = "SELECT allowance_amount from xin_salary_allowances WHERE allowance_title='$allowance_title'";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function get_employee_basic_salary($user_id)
    {
        $sql = "SELECT DISTINCT amount,inc_amt,history_type,allowance_id,`date` AS progression_date from xin_employee_salary_history WHERE employee_id='$user_id' AND inc_or_dec='inc' ORDER BY `date`";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function salary_latest_progression_history_report($company_id, $employee_id, $department_id, $location_id, $year){

		    if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }



            $sql = "SELECT * from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' AND xin_employees.user_id != 1 $company_str $employees_str $department_str $location_str GROUP BY xin_employees.department_id";

            $query = $this->db->query($sql);
            return $query;
			
		}
		
	public function salary_latest_progression_history_report_count($company_id, $employee_id, $department_id, $location_id, $year){

		if($company_id!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($department_id!='')
            {
                $department_str="AND xin_employees.department_id IN($department_id)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }



            $sql = "SELECT * from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' $company_str $employees_str $department_str $location_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array();
            return $query;
			
	}

	public function basic_sum($depart_main_id_data, $year){
	    


		$sql = "SELECT SUM(xin_employees.basic_salary) as basic_sum_data from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employees.department_id = $depart_main_id_data";
		$query = $this->db->query($sql);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function basic_progress_sum($depart_main_id_data, $year){

		$sql = "SELECT SUM(xin_employee_salary_history.amount) as basic_progress_sum_data from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employee_salary_history.history_type = 1 and xin_employees.department_id = $depart_main_id_data";
		$query = $this->db->query($sql);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function allowance_progress_sum($depart_main_id_data, $year, $allowance_id){


		$sql = "SELECT SUM(xin_employee_salary_history.amount) as allowance_progress_sum_data from xin_employee_salary_history JOIN xin_employees ON xin_employees.user_id = xin_employee_salary_history.employee_id WHERE inc_or_dec='inc' AND EXTRACT(YEAR FROM `date`)='$year' and xin_employee_salary_history.history_type = 2 and xin_employees.department_id = $depart_main_id_data and xin_employee_salary_history.allowance_id = $allowance_id;";
		$query = $this->db->query($sql);
		//print_r($query->result());
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

    public function get_allowance_progress_amount($all_id, $user_id)
    {
        $sql = "SELECT DISTINCT employee_id,amount,`date`,allowance_id,inc_amt from xin_employee_salary_history WHERE employee_id='$user_id' AND allowance_id='$all_id' AND inc_amt != '0'";
        //print_r($sql);
        $query = $this->db->query($sql);
        $amount = $query->result();
        //print_r($inc_amount);
        if (!empty($amount)) {
            $amount = $amount[0]->amount;
            return $amount;
        } else {
            $amount = 0;
            return $amount;
        }
    }
    /////////////////////////////////////////////////////////////////////////department wise employee pdf//////////////////////////////////////////////
    public function department_wise_employee_reports_pdf($company_id, $department_id, $location_id, $status)
    {
		if($company_id!='')
	    {
	        $company_str="AND xin_employees.company_id IN($company_id)";
	    }else{
	        $company_str="";
	    }
	    if($department_id!='')
	    {
	        $department_str="AND xin_employees.department_id IN($department_id)";
	    }else{
	        $department_str="";
	    }
	    if($location_id!='')
	    {
	        $location_str="AND xin_employees.location_id IN($location_id)";
	    }else{
	        $location_str="";
	    }
	    if($status!='all')
	    {
	        $status_str="AND xin_employees.is_active IN($status)";
	    }else{
	        $status_str="";
	    }
	    $designation = "SELECT xin_employees.company_id,xin_departments.department_name,xin_employees.department_id from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE xin_employees.user_id != '' $company_str $department_str $location_str $status_str GROUP BY xin_employees.department_id";
	    $designation_query = $this->db->query($designation)->result_array();
	   
	    foreach($designation_query as $key => $val) {
	        $sql = "SELECT xin_employees.designation_id,xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_companies.name, xin_departments.department_name from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE xin_employees.user_id != '1' AND xin_employees.department_id =".$val['department_id']."  ORDER BY xin_companies.`name` ASC,xin_departments.`department_name` ASC";
            $query = $this->db->query($sql)->result_array();
            $designation_query[$key]['list']=$query;
	    }
	   //  var_dump($designation_query);die();
        // $sql = "SELECT xin_employees.designation_id,xin_employees.employee_id, xin_employees.company_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_companies.name, xin_departments.department_name from xin_employees JOIN xin_departments on xin_departments.department_id=xin_employees.department_id JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE xin_employees.user_id != '' $company_str $department_str $location_str $status_str ORDER BY xin_companies.`name` ASC,xin_departments.`department_name` ASC";
        // $query = $this->db->query($sql);
        return $designation_query;

    }
    
    public function employee_shift_allocation_get($aj_company,$aj_department,$location_id,$employee_id,$from_date,$to_date){
        

	        if($aj_company!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($aj_company)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }

            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $employees_str $department_str $location_str GROUP BY xin_employees.department_id";

            $query = $this->db->query($sql); 
            return $query; 

	}

	public function employee_shift_allocation_get_count($aj_company,$aj_department,$location_id,$employee_id,$from_date,$to_date){

	    if($aj_company!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($aj_company)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($employee_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($employee_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }




            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $employees_str $department_str $location_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 

	}
	
	public function employee_daily_punch_summary_report($aj_company,$aj_department,$location_id,$emp_id,$from_date,$to_date){

         if($aj_company!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($aj_company)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }


            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $employees_str $department_str $location_str GROUP BY xin_employees.department_id";

            $query = $this->db->query($sql); 
            return $query; 
         
    }


    public function employee_daily_punch_summary_report_count($aj_company,$aj_department,$location_id,$emp_id,$from_date,$to_date){

         if($aj_company!='')
    	    {
    	        $company_str="AND xin_employees.company_id IN($aj_company)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($emp_id!='')
    	    {
    	        $employees_str="AND xin_employees.user_id IN($emp_id)";
    	    }else{
    	        $employees_str="";
    	    }

            if($aj_department!='')
            {
                $department_str="AND xin_employees.department_id IN($aj_department)";
            }else{
                $department_str="";
            }

            if($location_id!='')
            {
                $location_str="AND xin_employees.location_id IN($location_id)";
            }else{
                $location_str="";
            }


            $sql = "SELECT * from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' $company_str $employees_str $department_str $location_str GROUP BY xin_employees.company_id";

            $query = $this->db->query($sql)->result_array(); 
            return $query; 

    }
     public function designation_wise_employee_reports_pdf($company_id, $designation_id, $location_id, $status, $department_id)
    {

        if($company_id!=0)
        {
            $company_str="AND xin_designations.company_id IN($company_id)";
        }else{
            $company_str="";
        }

        if($designation_id!=0)
        {
            $designation_str="AND xin_designations.designation_id IN($designation_id)";
        }else{
            $designation_str="";
        }

        if($location_id!=0)
        {
            $location_str="AND xin_employees.location_id IN($location_id)";
        }else{
            $location_str="";
        }
        
        if($department_id!='')
    	{
    	    $department_str="AND xin_designations.department_id IN($department_id)";
    	}else{
    	    $department_str="";
    	}

        if($status!='all')
        {
            $status_str="AND xin_employees.is_active IN($status)";
        }else{
            $status_str="";
        }
        
        $sql = "SELECT xin_employees.company_id, xin_designations.designation_name,xin_employees.designation_id from xin_employees JOIN xin_designations on xin_designations.designation_id=xin_employees.designation_id JOIN xin_departments on xin_departments.department_id =xin_employees.department_id   JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE user_id != '' $company_str $designation_str $location_str $department_str $status_str GROUP BY xin_employees.designation_id";
        $designations = $this->db->query($sql)->result_array();
        
       
        foreach ($designations as $key => $value) {
             $sql = "SELECT xin_departments.department_name as department_name,xin_employees.employee_id, xin_employees.first_name,xin_employees.last_name, xin_employees.date_of_joining,xin_employees.is_active,xin_employees.company_id, xin_designations.designation_name from xin_employees JOIN xin_designations on xin_designations.designation_id=xin_employees.designation_id JOIN xin_departments on xin_departments.department_id =xin_employees.department_id   JOIN xin_companies on xin_companies.company_id=xin_employees.company_id WHERE user_id != '1' AND xin_employees.designation_id=".$value['designation_id']." ORDER BY xin_companies.`name` ASC,xin_designations.`designation_name` ASC";
            $query = $this->db->query($sql)->result_array();
            $designations[$key]['list']=$query;
        }
        return $designations;


    }
    
    ////////////////////////////////////////////////////////report for filter/////////////////////////////////////////////////////////
    
    public function get_department_new($company_id, $location_id) {
            if($company_id!='')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($location_id!='')
    	    {
    	        $location_str="AND location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }
    	    
		$sql = "SELECT * FROM xin_departments WHERE department_id!='' AND  location_id!='' $company_str $location_str GROUP BY department_id";
		$query = $this->db->query($sql);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	
	public function get_location_new($company_id) {
	    if($company_id != ''){
	    
	        if($company_id!='0')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    
    	    $sql = "SELECT * FROM xin_office_location WHERE location_id != '' $company_str GROUP BY location_id";
		    $query = $this->db->query($sql);
		
    		if ($query->num_rows() > 0) {
    			return $query->result();
    		} else {
    			return null;
    		}
	    } else{
	        $sql = "SELECT * FROM xin_office_location GROUP BY location_name";
		    $query = $this->db->query($sql);
		
    		if ($query->num_rows() > 0) {
    			return $query->result();
    		} else {
    			return null;
    		}
	    }
	
	}
	
	public function get_employee_new($company_id, $department_id, $location_id) {
	    if($location_id != ''){
	    
	        if($company_id!='0')
    	    {
    	        $company_str="AND xin_employees.company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($department_id!='')
    	    {
    	        $department_str="AND xin_employees.department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }
    	    
    	    if($location_id!='')
    	    {
    	        $location_str="AND xin_employees.location_id IN($location_id)";
    	    }else{
    	        $location_str="";
    	    }
    	    
	        $sql = "SELECT xin_employees.user_id, xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_departments.department_name, xin_departments.department_id, xin_office_location.location_id, xin_office_location.location_name  FROM xin_employees JOIN xin_departments on xin_departments.department_id = xin_employees.department_id JOIN xin_office_location on xin_office_location.location_id = xin_employees.location_id WHERE user_role_id!='1' $company_str $department_str $location_str GROUP BY xin_employees.user_id";
		    $query = $this->db->query($sql);
		
		    if ($query->num_rows() > 0) {
			return $query->result();
		    } else {
			return null;
		    }
		
	   } else {
	        $sql = "SELECT * FROM xin_employees GROUP BY xin_employees.user_id";
		    $query = $this->db->query($sql);
		
		    if ($query->num_rows() > 0) {
			return $query->result();
		    } else {
			return null;
		    }
	   }
	}
	
	
	public function get_employee_designation_new($company_id, $department_id) {
	    
	        if($company_id!='0')
    	    {
    	        $company_str="AND company_id IN($company_id)";
    	    }else{
    	        $company_str="";
    	    }
    	    
    	    if($department_id!='')
    	    {
    	        $department_str="AND department_id IN($department_id)";
    	    }else{
    	        $department_str="";
    	    }
    	    
    	    
	        $sql = "SELECT * FROM `xin_designations` WHERE designation_id != '' $company_str $department_str GROUP BY designation_id";
		    $query = $this->db->query($sql);
		
		    if ($query->num_rows() > 0) {
			return $query->result();
		    } else {
			return null;
		    }
		
	}
    
    ////////////////////////////////////////////////////////report for filter end/////////////////////////////////////////////////////////
    
    
    
     //////////////////////////////////////new///////////////////////////////////////////
    public function get_other_payments($depart_id, $month_year)
    {
        $this->db->select('xin_salary_payslips.payslip_id');
        $this->db->where('department_id',$depart_id);
        $this->db->where('salary_month',$month_year);
        $data=$this->db->get('xin_salary_payslips')->result_array();
        $other_payments=0;
        foreach ($data as $key => $value) {
            $res=$this->db->select('xin_salary_payslip_other_payments.payments_amount')->where('xin_salary_payslip_other_payments.payslip_id',$value['payslip_id'])->get('xin_salary_payslip_other_payments')->result_array();
            foreach ($res as $k1 => $v1) {
                $other_payments+=(float)$v1['payments_amount'];
            }

        }
        return $other_payments;
    }
    
    
    public function empdtwise_increment_list_query($start_date,$end_date){

		$sql = "SELECT xin_employees.user_id, xin_employees.company_id, xin_employees.first_name, xin_employees.last_name FROM `xin_employee_salary_history` JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE date >= '$start_date-01-01' AND date <= '$end_date-12-31' AND inc_amt > 0 AND inc_or_dec != '' GROUP BY xin_employee_salary_history.employee_id";

			  $query = $this->db->query($sql);
			  return $query;

	}


	public function empdtwise_increment_list_query_count($start_date,$end_date){

		$sql = "SELECT xin_employees.company_id FROM `xin_employee_salary_history` JOIN xin_employees ON xin_employee_salary_history.employee_id = xin_employees.user_id WHERE date >= '$start_date-01-01' AND date <= '$end_date-12-31' AND inc_amt > 0 AND inc_or_dec != '' GROUP BY xin_employees.company_id";

			  $query = $this->db->query($sql)->result_array();
			  return $query;
		
	}
	
	
	//custom shift
	public function get_custom_shift_data($empid,$date) {
        $months=explode('-', $date);
        $month=$months[0].'-'.$months[1];
        $data=$this->db->select('*')->where('employee_id',$empid)->where('month',$month)->get('xin_office_shift_custom')->row_array();
        return $data;
    }


	public function get_employees_indemnity_reports($company, $department_id, $designation_id, $employee_id, $from_date,$to_date)
	{
		$this->db->select('xin_employee_indemnity.*,
		xin_employees.company_id,xin_employees.designation_id,
		xin_employees.department_id,xin_employees.location_id,
		xin_employees.first_name,xin_employees.last_name,');
		$this->db->from('xin_employee_indemnity');
		$this->db->join('xin_employees', 'xin_employees.user_id = xin_employee_indemnity.employee_id','left');
		if(!empty($company)){
			$this->db->where('xin_employees.company_id',$company);
		}
		if(!empty($department_id)){
			$this->db->where('xin_employees.department_id',$department_id);
		}
		if(!empty($designation_id)){
			$this->db->where('xin_employees.designation_id',$designation_id);
		}
		if(!empty($employee_id)){
			$this->db->where('xin_employees.user_id',$employee_id);
		}
		$i = '';
		if ($from_date != '' && $to_date != ''){
			$i = 1;
			$this->db->group_start();
			$this->db->where("xin_employee_indemnity.from_date BETWEEN '$from_date' AND '$to_date'");
			$this->db->or_where("xin_employee_indemnity.to_date BETWEEN '$from_date' AND '$to_date'");
			$this->db->group_end();
		} else if($from_date != ''){
			$i = 2;
			$this->db->where('xin_employee_indemnity.from_date >=', $from_date);
		}

		if($i > 1 && $to_date != ''){
			$this->db->where('xin_employee_indemnity.to_date <=', $to_date);
		}

		$query = $this->db->get();
		return $query;

	}
	
    
    
    
    
}
