<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Timesheet_model extends CI_Model
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	// get office shifts
	public function get_office_shifts()
	{
		return $this->db->get("xin_office_shift");
	}

	// get all tasks
	public function get_tasks()
	{
		return $this->db->get("xin_tasks");
	}

	// get all project tasks
	public function get_project_tasks($id)
	{
		$sql = 'SELECT * FROM xin_tasks WHERE project_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// get all project variations
	public function get_project_variations($id)
	{
		$sql = 'SELECT * FROM xin_project_variations WHERE project_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		return $query;
	}


	public function filter_get_annual_emp($company_id, $employee_id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ?';
		$binds = array($company_id, $employee_id);
		$query = $this->db->query($sql, $binds);
		//print_r($query);exit();
		return $query;


	}

	public function emp_leave_duplication_check($empid, $startdate, $enddate)
	{
		$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and from_date = ? and to_date = ?';
		$binds = array($empid, $startdate, $enddate);
		$query = $this->db->query($sql, $binds);

		return $query->num_rows();
	}

	public function get_annual_leaves_approval()
	{


		$sql = "SELECT * FROM xin_annual_leave_applications WHERE status ='2'";

		$query = $this->db->query($sql);
		return $query;


	}

	public function get_annual_leaves_cancel()
	{


		$sql = "SELECT * FROM xin_annual_leave_applications WHERE leave_cancel_status ='Y'";

		$query = $this->db->query($sql);
		return $query;


	}

	public function get_leaves_cancel()
	{


		$sql = "SELECT * FROM xin_leave_applications WHERE leave_cancel_status ='Y'";

		$query = $this->db->query($sql);
		return $query;


	}


	public function filter_get_annual_cmp($company_id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		//print_r($query);exit();
		return $query;


	}

	public function filter_get_annual_status($status)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE  status_p_un = ?';
		$binds = array($status);
		$query = $this->db->query($sql, $binds);
		return $query;


	}

	public function filter_get_annual_all($company_id, $employee_id, $status)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ? and status_p_un = ?';
		$binds = array($company_id, $employee_id, $status);
		$query = $this->db->query($sql, $binds);
		//print_r($query);exit();
		return $query;


	}

	// check if check-in available
	public function attendance_first_in_check($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? limit 1';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function attendance_this_month_value_last($employee_id, $attendance_date)
	{
		$sql = "SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date LIKE '%$attendance_date%' order by attendance_date desc limit 1";
		$binds = array($employee_id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}


	// get user attendance
	public function attendance_time_check($employee_id)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ?';
		$binds = array($employee_id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}

	public function get_attendance_record($id)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE time_attendance_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}

	// check if check-in available
	public function attendance_first_in($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ?';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function attendance_last_out($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? ORDER BY time_attendance_id DESC limit 1';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// check if check-out available
	public function attendance_first_out_check($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? order by time_attendance_id desc limit 1';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// get leave types
	public function all_leave_types()
	{
		$query = $this->db->get("xin_leave_type");
		return $query->result();
	}

	// get company offshifts
	public function get_company_shifts($company_id)
	{

		$sql = 'SELECT * FROM xin_office_shift WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get company holidays
	public function get_company_holidays($company_id)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// filter company holidays
	public function filter_company_holidays($company_id)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// filter company|status holidays
	public function filter_company_publish_holidays($company_id, $is_publish)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE company_id = ? and is_publish = ?';
		$binds = array($company_id, $is_publish);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// filter company|status holidays
	public function filter_notcompany_publish_holidays($is_publish)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE is_publish = ?';
		$binds = array($is_publish);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get company leaves
	public function get_company_leaves($company_id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? order by applied_on desc';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_first_record($empid, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? AND attendance_date = ? limit 1';
		$binds = array($empid, $attendance_date);
		$query = $this->db->query($sql, $binds);
		return $query->result();

	}

	public function get_company_leaves_new($company_id, $approval_stage = '')
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? order by applied_on desc';
		if ($approval_stage == 'first') {

			$sql .= ' AND first_approval = 0';

		} else if ($approval_stage == 'last') {

			$sql .= ' AND first_approval = 1 AND final_approval = 0';

		}
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	public function get_company_leaves_new_list($company_id, $approval_stage = '')
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ?';
		/*if ($approval_stage == 'first') {

	 		$sql .= ' AND first_approval = 0';

	 	} else if ($approval_stage == 'second') {

	 		$sql .= ' AND first_approval = 1 AND second_approval = 0 AND final_approval = 0';

	 	} else if ($approval_stage == 'last') {

	 		$sql .= ' AND first_approval = 1 AND second_approval = 1 AND final_approval = 0';

	 	}*/
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get multi company leaves
	public function get_multi_company_leaves($company_ids)
	{

		$sql = 'SELECT * FROM xin_leave_applications where company_id IN ?';
		$binds = array($company_ids);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get company tasks
	public function get_company_tasks($company_id)
	{

		$sql = 'SELECT * FROM xin_tasks WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get employee tasks
	public function get_employee_tasks($id)
	{

		$sql = "SELECT * FROM `xin_tasks` where assigned_to like '%$id,%' or assigned_to like '%,$id%' or assigned_to = '$id'";
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// check if check-out available
	public function attendance_first_out($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? order by time_attendance_id desc limit 1';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// get total hours work > attendance
	public function total_hours_worked_attendance($id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and total_work != ""';
		$binds = array($id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// get total rest > attendance
	public function total_rest_attendance($id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and total_rest != ""';
		$binds = array($id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// check if holiday available
	public function holiday_date_check($attendance_date)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE (start_date between start_date and end_date) or (start_date = ? or end_date = ?) limit 1';
		$binds = array($attendance_date, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function holiday_date_check_payroll($start_date_p, $end_date_p)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE (start_date between start_date and end_date) or (start_date = ? or end_date = ?) and is_publish = 1';
		$binds = array($start_date_p, $end_date_p);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function holiday_date_check_payroll_new($start_date_p, $end_date_p, $company_id)
	{

		//$sql = 'SELECT * FROM xin_holidays WHERE ((start_date between start_date and end_date) or (start_date = ? or end_date = ?)) and  company_id = ?';
		$sql = 'SELECT * FROM xin_holidays WHERE  (start_date >= ? and end_date <= ?) and company_id = ? and is_publish = 1';
		$binds = array($start_date_p, $end_date_p, $company_id);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function holiday_date_payroll_new($start_date_p, $end_date_p, $company_id)
	{

		//$sql = 'SELECT * FROM xin_holidays WHERE ((start_date between start_date and end_date) or (start_date = ? or end_date = ?)) and company_id = ? ';
		$sql = 'SELECT * FROM xin_holidays WHERE  (start_date >= ? and end_date <= ?) and company_id = ? and is_publish = 1';
		$binds = array($start_date_p, $end_date_p, $company_id);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function holiday_date_payroll($start_date_p, $end_date_p)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE (start_date between start_date and end_date) or (start_date = ? or end_date = ?) and is_publish = 1';
		$binds = array($start_date_p, $end_date_p);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// get all leaves
	public function get_leaves()
	{
		$this->db->order_by('applied_on', 'desc');
		return $this->db->get("xin_leave_applications");
	}

	// get company leaves
	public function filter_company_leaves($company_id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? order by applied_on desc';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get company|employees leaves
	public function filter_company_employees_leaves($company_id, $employee_id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and employee_id = ? order by applied_on desc';
		$binds = array($company_id, $employee_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get company|employees leaves
	public function filter_company_employees_status_leaves($company_id, $status)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and status = ?';
		$binds = array($company_id, $status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_leaves_new($company_id, $employee_id, $status)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and status = ? and employee_id = ? order by applied_on desc';
		$binds = array($company_id, $status, $employee_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get company|employees leaves
	public function filter_company_only_status_leaves($company_id, $status)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and status = ? order by applied_on desc';
		$binds = array($company_id, $status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_only_status_leaves($status)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE status = ? order by applied_on desc';
		$binds = array($status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get all employee leaves
	public function get_employee_leaves($id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? order by applied_on desc';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_approved_employee_leaves($id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE status=2 and employee_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	public function filter_company_annual_leaves_cancel($company_id)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and leave_cancel_status =Y order by applied_on desc';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	public function filter_company_employees_annual_leaves_cancel($company_id, $employee_id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ?  and leave_cancel_status =Y order by applied_on desc';
		$binds = array($company_id, $employee_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_leaves_annuval_cancel($company_id, $employee_id, $status)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ?  and status = ? and leave_cancel_status =Y order by applied_on desc';
		$binds = array($company_id, $employee_id, $status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_annual_leaves_cancel($company_id, $status)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ?  and status = ? and leave_cancel_status =Y order by applied_on desc';
		$binds = array($company_id, $status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	public function filter_company_annual_leaves_cancel_get($company_id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	public function filter_company_employees_annual_leaves_cancel_get($company_id, $employee_id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ?  and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $employee_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_leaves_annuval_cancel_get($company_id, $employee_id, $status)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ?  and status = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $employee_id, $status, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_annual_leaves_cancel_get($company_id, $status)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ?  and status = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $status, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	public function get_company_leaves_new_annual_cancel($company_id, $approval_stage = '', $current_user)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and leave_cancel_status = ? order by applied_on desc';
		if ($approval_stage == 'first') {

			$sql .= ' AND first_approval = 0';

		} else if ($approval_stage == 'last') {

			$sql .= ' AND first_approval = 1 AND final_approval = 0';

		}
		$sql .= ' OR employee_id = ?';
		$binds = array($company_id, $current_user, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_company_annual_leaves_cancel($company_id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_employee_annual_leaves_cancel($id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE employee_id = ?  and leave_cancel_status = ? order by applied_on desc';
		$binds = array($id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_leaves_cancel($company_id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_leaves_cancel($company_id, $employee_id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and employee_id = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $employee_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_leaves_new_cancel($company_id, $employee_id, $status)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and status = ? and employee_id = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $status, $employee_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_only_status_leaves_cancel($company_id, $status)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and status = ?  and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $status, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_only_status_leaves_cancel($status)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE status = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($status, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_company_leaves_new_cancel($company_id, $approval_stage = '')
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ? and leave_cancel_status = ? order by applied_on desc';
		if ($approval_stage == 'first') {

			$sql .= ' AND first_approval = 0';

		} else if ($approval_stage == 'last') {

			$sql .= ' AND first_approval = 1 AND final_approval = 0';

		}
		$binds = array($company_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_company_leaves_cancel($company_id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE company_id = ?  and leave_cancel_status = ? order by applied_on desc';
		$binds = array($company_id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_employee_leaves_cancel($id)
	{
		$cancel_s = 'Y';
		$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and leave_cancel_status = ? order by applied_on desc';
		$binds = array($id, $cancel_s);
		$query = $this->db->query($sql, $binds);
		return $query;
	}


	// check if holiday available
	public function holiday_date($attendance_date)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE (start_date between start_date and end_date) or (start_date = ? or end_date = ?) limit 1';
		$binds = array($attendance_date, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// get all holidays
	public function get_holidays()
	{
		return $this->db->get("xin_holidays");
	}

	// get all holidays>calendar
	public function get_holidays_calendar()
	{

		$sql = 'SELECT * FROM xin_holidays WHERE is_publish = ?';
		$binds = array(1);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// get all leaves>calendar
	public function get_leaves_request_calendar()
	{
		return $query = $this->db->query("SELECT * from xin_leave_applications");
	}

	// check if leave available
	public function leave_date_check($emp_id, $attendance_date)
	{
		$sql = 'SELECT * from xin_leave_applications where  employee_id = ? and status = 2 and is_half_day = 0 and (( from_date >=  ? or to_date <= ? ) or (from_date between from_date and to_date) ) limit 1';
		$binds = array($emp_id, $attendance_date, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function leave_date_check_new($emp_id, $start_date_p, $end_date_p)
	{
		$month = date('m', strtotime($start_date_p));
		$year = date('Y', strtotime($start_date_p));
		$sql = 'SELECT * from xin_leave_applications where employee_id = ? and status = 2 and (MONTH(from_date) = ? or MONTH(to_date) = ?) and (YEAR(from_date) = ? or YEAR(to_date) = ?)';
		$binds = array($emp_id, $month, $month, $year, $year);

// 		$sql = 'SELECT * from xin_leave_applications where  employee_id = ? and status = 2 and ((from_date >=  ? and to_date <= ?) )';
// 		$binds = array($emp_id, $start_date_p, $end_date_p);

		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function leave_date_new($emp_id, $start_date_p, $end_date_p)
	{

		$sql = 'SELECT *,SUM(days) as total_leaves from xin_leave_applications where  employee_id = ? and status = 2 and (from_date >=  ? and to_date <= ?)';
		$binds = array($emp_id, $start_date_p, $end_date_p);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// check if leave available
	public function leave_date($emp_id, $attendance_date)
	{

		$sql = 'SELECT * from xin_leave_applications where  employee_id = ? and status = 2 and ((from_date >=  ? or to_date <= ? or (from_date between from_date and to_date) )) limit 1';
		$binds = array($emp_id, $attendance_date, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// get total number of leave > employee
	public function count_total_leaves($leave_type_id, $employee_id)
	{

		//$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and leave_type_id = ? and status = ? and created_at >= DATE_SUB(NOW(),INTERVAL 1 YEAR)';
		$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and leave_type_id = ? and status = ?';
		$binds = array($employee_id, $leave_type_id, 2);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}


	// get payroll templates > NOT USED
	public function attendance_employee_with_date($emp_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time where attendance_date = ? and employee_id = ?';
		$binds = array($attendance_date, $emp_id);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// get record of office shift > by id
	public function read_office_shift_information($id)
	{

		$sql = 'SELECT * FROM xin_office_shift WHERE office_shift_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// get record of leave > by id
	public function read_leave_information($id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE leave_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// get leave type by id
	public function read_leave_type_information($id)
	{

		$sql = 'SELECT * FROM xin_leave_type WHERE leave_type_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function count_leave_type($id)
	{

		$sql = 'SELECT * FROM xin_leave_type WHERE leave_type_id = ? ';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function xin_count_leave_type($leave_cat, $employee_id)
	{

		$sql = 'SELECT sum(days) as leave_count FROM xin_leave_applications WHERE leave_type_id = ? and employee_id=?';
		$binds = array($leave_cat, $employee_id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// Function to add record in table
	public function add_employee_attendance($data)
	{
		$this->db->insert('xin_attendance_time', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	public function carry_insert($data)
	{
		$this->db->insert('carry_leaves', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	public function carry_update($data, $id)
	{
		$this->db->where('id', $id);
		if ($this->db->update('carry_leaves', $data)) {
			return true;
		} else {
			return false;
		}
	}


	// Function to add record in table
	public function add_leave_record($data)
	{
		$this->db->insert('xin_leave_applications', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// Function to add record in table
	public function add_task_record($data)
	{
		$this->db->insert('xin_tasks', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// Function to add record in table
	public function add_project_variations($data)
	{
		$this->db->insert('xin_project_variations', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// Function to add record in table
	public function add_office_shift_record($data)
	{
		$this->db->insert('xin_office_shift', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// Function to add record in table
	public function add_holiday_record($data)
	{
		$this->db->insert('xin_holidays', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// get record of task by id
	public function read_task_information($id)
	{

		$sql = 'SELECT * FROM xin_tasks WHERE task_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// get record of variation by id
	public function read_variation_information($id)
	{

		$sql = 'SELECT * FROM xin_project_variations WHERE variation_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// get record of holiday by id
	public function read_holiday_information($id)
	{

		$sql = 'SELECT * FROM xin_holidays WHERE holiday_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// get record of attendance by id
	public function read_attendance_information($id)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE time_attendance_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	// Function to Delete selected record from table
	public function delete_attendance_record($id)
	{
		$this->db->where('time_attendance_id', $id);
		$this->db->delete('xin_attendance_time');
	}

	// Function to Delete selected record from table
	public function delete_task_record($id)
	{
		$this->db->where('task_id', $id);
		$this->db->delete('xin_tasks');
	}

	// Function to Delete selected record from table
	public function delete_variation_record($id)
	{
		$this->db->where('variation_id', $id);
		$this->db->delete('xin_project_variations');
	}

	// Function to Delete selected record from table
	public function delete_holiday_record($id)
	{
		$this->db->where('holiday_id', $id);
		$this->db->delete('xin_holidays');
	}

	// Function to Delete selected record from table
	public function delete_shift_record($id)
	{
		$this->db->where('office_shift_id', $id);
		$this->db->delete('xin_office_shift');
	}

	// Function to Delete selected record from table
	public function delete_leave_record($id)
	{
		$this->db->where('leave_id', $id);
		$this->db->delete('xin_leave_applications');
	}

	// Function to update record in table
	public function update_task_record($data, $id)
	{
		$this->db->where('task_id', $id);
		if ($this->db->update('xin_tasks', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_project_variations($data, $id)
	{
		$this->db->where('variation_id', $id);
		if ($this->db->update('xin_project_variations', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_leave_record($data, $id)
	{
		$this->db->where('leave_id', $id);
		if ($this->db->update('xin_leave_applications', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_holiday_record($data, $id)
	{
		$this->db->where('holiday_id', $id);
		if ($this->db->update('xin_holidays', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_attendance_record($data, $id)
	{
		$this->db->where('time_attendance_id', $id);
		if ($this->db->update('xin_attendance_time', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_shift_record($data, $id)
	{
		$this->db->where('office_shift_id', $id);
		if ($this->db->update('xin_office_shift', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_default_shift_record($data, $id)
	{
		$this->db->where('office_shift_id', $id);
		if ($this->db->update('xin_office_shift', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function update_default_shift_zero($data)
	{
		$this->db->where("office_shift_id!=''");
		if ($this->db->update('xin_office_shift', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// Function to update record in table
	public function assign_task_user($data, $id)
	{
		$this->db->where('task_id', $id);
		if ($this->db->update('xin_tasks', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// get comments
	public function get_comments($id)
	{

		$sql = 'SELECT * FROM xin_tasks_comments WHERE task_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// get comments
	public function get_attachments($id)
	{

		$sql = 'SELECT * FROM xin_tasks_attachment WHERE task_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// Function to add record in table > add comment
	public function add_comment($data)
	{
		$this->db->insert('xin_tasks_comments', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// Function to Delete selected record from table
	public function delete_comment_record($id)
	{
		$this->db->where('comment_id', $id);
		$this->db->delete('xin_tasks_comments');
	}

	// Function to Delete selected record from table
	public function delete_attachment_record($id)
	{
		$this->db->where('task_attachment_id', $id);
		$this->db->delete('xin_tasks_attachment');
	}

	// Function to add record in table > add attachment
	public function add_new_attachment($data)
	{
		$this->db->insert('xin_tasks_attachment', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// check user attendance 
	public function check_user_attendance($today_date = '')
	{
		if ($today_date == '')
			$today_date = date('Y-m-d');
		$session = $this->session->userdata('username');
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? and `attendance_date` = ? order by time_attendance_id desc limit 1';
		$binds = array($session['user_id'], $today_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// check user attendance 
	public function check_user_attendance_clockout()
	{
		$today_date = date('Y-m-d');
		$session = $this->session->userdata('username');
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? and `attendance_date` = ? and clock_out = ? order by time_attendance_id desc limit 1';
		$binds = array($session['user_id'], $today_date, '');
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	//  set clock in- attendance > user
	public function add_new_attendance($data)
	{
		$this->db->insert('xin_attendance_time', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	// get last user attendance 
	public function get_last_user_attendance()
	{

		$session = $this->session->userdata('username');
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? order by time_attendance_id desc limit 1';
		$binds = array($session['user_id']);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	// get last user attendance > check if loged in-
	public function attendance_time_checks($id)
	{

		$session = $this->session->userdata('username');
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? and clock_out = ? order by time_attendance_id desc limit 1';
		$binds = array($id, '');
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	// Function to update record in table > update attendace.
	public function update_attendance_clockedout($data, $id)
	{
		//$this->db->where("time_attendance_id!=''");
		$this->db->where('time_attendance_id', $id);
		if ($this->db->update('xin_attendance_time', $data)) {
			return true;
		} else {
			return false;
		}
	}

	// get employees > active
	public function get_xin_employees()
	{

		$sql = 'SELECT * FROM xin_employees WHERE is_active = ? and user_role_id!=1';
		$binds = array(1);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	// get all employee leaves>department wise
	public function get_employee_leaves_department_wise($department_id)
	{

		$sql = 'SELECT * FROM xin_leave_applications WHERE department_id = ?';
		$binds = array($department_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	// get total number of leave > employee
	public function employee_count_total_leaves($leave_type_id, $employee_id)
	{

		//$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and leave_type_id = ? and status = ? and created_at >= DATE_SUB(NOW(),INTERVAL 1 YEAR)';
		$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and leave_type_id = ?';
		$binds = array($employee_id, $leave_type_id);
		$query = $this->db->query($sql, $binds);

		$count = $query->num_rows();

		if ($leave_type_id != 2)
			return $count;

		$employee_under_probation = $this->Employees_model->employee_under_probation($employee_id);

		if ($employee_under_probation) {
			$type = $this->Timesheet_model->read_leave_type_information($leave_type_id);
			return $type[0]->days_per_year;
		}

		return $count;
	}

	// get total number of leave > employee
	public function employee_show_last_leave($employee_id, $leave_id)
	{
		$sql = "SELECT * FROM xin_leave_applications WHERE leave_id != '" . $leave_id . "' and employee_id = ? order by leave_id desc limit 1";
		$binds = array($employee_id);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function joining_date($id)
	{
		$sql = "SELECT date_of_joining,ethnicity_type FROM xin_employees  where user_id=?";
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function update_leave_readrecord($data, $id)
	{
		$this->db->where('leave_id', $id);
		if ($this->db->update('xin_leave_applications', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function update_annualleave_readrecord($data, $id)
	{
		$this->db->where('id', $id);
		if ($this->db->update('xin_annual_leave_applications', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function available_leaves_emp($id)
	{

		$sql = 'SELECT * FROM employee_leave   WHERE employee_id = ? GROUP BY leave_type';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function auto_insert($data)
	{
		$this->db->insert('employee_leave', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	public function auto_insert1($data)
	{
		$this->db->insert('employee_leave', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	public function auto_update($data, $id, $type)
	{
		$this->db->where('employee_id', $id);
		$this->db->where('leave_type', $type);
		if ($this->db->update('employee_leave', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function auto_update3($data, $id, $type)
	{
		$this->db->where('employee_id', $id);
		$this->db->where('leave_type', $type);
		if ($this->db->update('employee_leave', $data)) {
			return true;
		} else {
			return false;
		}
	}


	public function add_annuval_leave_record($data)
	{
		$this->db->insert('xin_annual_leave_applications', $data);
		if ($this->db->affected_rows() > 0) {
			$insert_id = $this->db->insert_id();
			return $insert_id;
		} else {
			return false;
		}
	}

	public function get_annual_leaves()
	{
		$this->db->order_by('applied_on', 'desc');
		return $this->db->get("xin_annual_leave_applications");
	}

	public function get_company_annual_leaves($company_id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? order by applied_on desc';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function delete_annual_leave_record($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('xin_annual_leave_applications');
	}

	public function read_annual_leave_information($id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function update_annual_leave_record($data, $id)
	{
		$this->db->where('id', $id);
		if ($this->db->update('xin_annual_leave_applications', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function update_annual_encashment_record($data, $id)
	{
		$this->db->where('id', $id);
		if ($this->db->update('xin_encashment', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function deleteencsahmentLeaves($id)
	{
		$this->db->where('id', $id);
		if ($this->db->delete('xin_encashment')) {
			return true;
		} else {
			return false;
		}

	}

	public function filter_get_annual_encashment_cmp($company_id)
	{
		$sql = 'SELECT * FROM xin_encashment WHERE company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;

	}

	public function filter_get_annual_encashment_emp($company_id, $employee_id)
	{
		$sql = 'SELECT * FROM xin_encashment WHERE company_id = ? and employee_id = ?';
		$binds = array($company_id, $employee_id);
		$query = $this->db->query($sql, $binds);
		//print_r($query);exit();
		return $query;

	}

	public function filter_get_annual_encashment_all($company_id, $employee_id, $status)
	{
		$sql = 'SELECT * FROM xin_encashment WHERE company_id = ? and employee_id = ? and status = ?';
		$binds = array($company_id, $employee_id, $status);
		$query = $this->db->query($sql, $binds);
		//print_r($query);exit();
		return $query;
	}

	public function filter_get_annual_encashment_status($status)
	{
		$sql = 'SELECT * FROM xin_encashment WHERE  status = ?';
		$binds = array($status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_annual_encashment()
	{
		$sql = "SELECT * FROM xin_encashment ";
		$query = $this->db->query($sql);
		return $query;
	}

	public function get_annual_encashment_employee_id($id)
	{
		$sql = "SELECT * FROM xin_encashment where employee_id='$id'";
		$query = $this->db->query($sql);
		return $query;
	}

	public function get_annual_encashment_id($ecash_id)
	{
		$sql = "SELECT * FROM xin_encashment where id='$ecash_id'";
		$query = $this->db->query($sql);
		return $query->result();
	}

	public function filter_company_annual_leaves($company_id)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? order by applied_on desc';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_annual_leaves($company_id, $employee_id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ? order by applied_on desc';
		$binds = array($company_id, $employee_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_annual_leaves($company_id, $status)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ?  and status = ? order by applied_on desc';
		$binds = array($company_id, $status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_leaves_annuval($company_id, $employee_id, $status)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? and employee_id = ?  and status = ? order by applied_on desc';
		$binds = array($company_id, $employee_id, $status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function filter_company_employees_status_annual($status)
	{
		$sql = 'SELECT * FROM  xin_annual_leave_applications WHERE status = ? order by applied_on desc';
		$binds = array($status);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_employee_annual_leaves($id)
	{

		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE employee_id = ? order by applied_on desc';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function xin_count_annual_leave_type($employee_id)
	{

		$sql = 'SELECT sum(days) as leave_count FROM xin_annual_leave_applications WHERE employee_id=?';
		$binds = array($employee_id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function getDatesFromRange($start, $end, $format = 'Y-m-d')
	{

		// Declare an empty array
		$array = array();

		// Variable that store the date interval
		// of period 1 day
		$interval = new DateInterval('P1D');

		$realEnd = new DateTime($end);
		$realEnd->add($interval);

		$period = new DatePeriod(new DateTime($start), $interval, $realEnd);

		// Use loop to store date into array
		foreach ($period as $date) {
			$array[] = $date->format($format);
		}

		// Return the array elements
		return $array;
	}

	public function calculateSatuSundDaysInMonth($year = '', $month = '', $off_day_arr)
	{
		//in case no values are passed to the function, use the current month and year
		if ($year == '') {
			$year = date('Y');
		}
		if ($month == '') {
			$month = date('m');
		}
		//create a start and an end datetime value based on the input year 
		$startdate = strtotime($year . '-' . $month . '-01');
		$Todaysdate = strtotime(date('Y-m-d'));

		$enddate = strtotime('+' . (date('t', $startdate) - 1) . ' days', $startdate);
		$currentdate = $startdate;
		//get the total number of days in the month	
		$return = 0;
		//$return = intval((date('t',$startdate)),10);
		//loop through the dates, from the start date to the end date
		while ($currentdate <= $Todaysdate) {
			//if($currentdate <= $Todaysdate ){
			//if you encounter a Saturday or Sunday, remove from the total days count
			if ((in_array(date('D', $currentdate), $off_day_arr))) {
				$return += 1;
			}
			$currentdate = strtotime('+1 day', $currentdate);
			//}

		} //end date walk loop
		//return the number of working days
		return $return;
	}

	// check if check-in available
	public function attendance_first_in_check_status($employee_id, $attendance_date, $status)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status= ? limit 1';
		$binds = array($employee_id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function attendance_first_in_status($employee_id, $attendance_date, $status)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status= ?';
		$binds = array($employee_id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function attendance_status_in($employee_id, $attendance_date, $status)
	{
		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status=?';
		$binds = array($employee_id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			//   print_r($query->result());exit;
			return $query->result();
		} else {
			return false;
		}
	}

	public function attendance_first_out_check_status($employee_id, $attendance_date, $status)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status =? order by time_attendance_id desc limit 1';
		$binds = array($employee_id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function attendance_first_out_status($employee_id, $attendance_date, $status)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status = ? order by time_attendance_id desc limit 1';
		$binds = array($employee_id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function total_hours_worked_attendance_status($id, $attendance_date, $status)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status = ? and total_work != ""';
		$binds = array($id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function total_rest_attendance_status($id, $attendance_date, $status)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? and attendance_status = ? and total_rest != ""';
		$binds = array($id, $attendance_date, $status);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function get_company_shifts_id($company_id)
	{

		$sql = 'SELECT * FROM xin_office_shift WHERE company_id = ?';
		$binds = array($company_id);
		// 		$query = $this->db->query($sql, $binds);
		// 		return $query;
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function get_time_id($id, $date)
	{
		$sql = 'SELECT clock_in FROM xin_attendance_time WHERE employee_id = ? and attendance_date =?';
		$binds = array($id, $date);
		//$query = $this->db->query($sql, $binds);
		//return $query;
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function get_time_out($id, $date)
	{
		$sql = 'SELECT clock_out FROM xin_attendance_time WHERE employee_id = ? and attendance_date =?';
		$binds = array($id, $date);
		//$query = $this->db->query($sql, $binds);
		//return $query;
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	/*public function read_emp_leave_types_information($id,$leave_type) {
		if($leave_type == 3|| $leave_type == 4){
			$sql = 'SELECT * FROM employee_leave   WHERE employee_id = ? and leave_type = ? GROUP BY leave_type' ;
			$binds = array($id,$leave_type);
		}else{
			$sql = 'SELECT * FROM employee_leave   WHERE employee_id = ? GROUP BY leave_type' ;
			$binds = array($id);
		}
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}*/
	public function read_emp_leave_types_information($id, $leave_type)
	{
		$sql = 'SELECT * FROM employee_leave   WHERE employee_id = ? and leave_type = ? GROUP BY leave_type';
		$binds = array($id, $leave_type);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function get_employee_extra_remaining_leaves($emp_id, $leave_id)
	{
		$current_year = date('Y');
		$start_start = $current_year . '-01-01';
		$end_date = $current_year . '-12-31';
		if ($leave_id == 4 || $leave_id == 3) {
			$sql = 'SELECT * FROM carry_leaves   WHERE employee_id = ? and leave_type_id = ? and (create_date >= ? and create_date <= ?) GROUP BY leave_type_id';
			$binds = array($emp_id, $leave_id, $start_start, $end_date);
		} else {
			$sql = 'SELECT * FROM carry_leaves   WHERE employee_id = ? and leave_type_id = ? GROUP BY leave_type_id';
			$binds = array($emp_id, $leave_id);
		}
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function get_employee_extra_remaining_leaves_nums($emp_id, $leave_id, $yr)
	{
		$current_year = $yr;
		$start_start = $current_year . '-01-01';
		$end_date = $current_year . '-12-31';
		$this->db->where('employee_id', $emp_id);
		$this->db->where('leave_type_id', $leave_id);
		if ($leave_id == 4 || $leave_id == 3) {
			$this->db->where('create_date >=', $start_start);
			$this->db->where('create_date <=', $end_date);
		}
		return $this->db->get('carry_leaves');
	}

	public function getAnnualUnpaidLeaves($annual_id)
	{
		$sql = 'SELECT * FROM xin_leave_applications  WHERE is_annual = ?  GROUP BY leave_type_id';
		$binds = array($annual_id);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	/*public function annual_leave_availablefor_emp($id,$leave_type) {
		if($leave_type == 3|| $leave_type == 4){
			$sql = 'SELECT * FROM employee_leave  WHERE employee_id = ?  and leave_type = ? GROUP BY leave_type' ;
			$binds = array($id,$leave_type);
		}else{
			$sql = 'SELECT * FROM employee_leave  WHERE employee_id = ?   GROUP BY leave_type' ;
			$binds = array($id);
		}
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}*/
	public function annual_leave_availablefor_emp($id, $leave_type)
	{
		$sql = 'SELECT * FROM employee_leave  WHERE employee_id = ?  and leave_type = ?  order by created_at desc limit 1';
		$binds = array($id, $leave_type);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function deleteUnpaidLeaves($id)
	{
		$this->db->where('is_annual', $id);
		$this->db->delete('xin_leave_applications');
	}

	public function add_leave_record_new($data)
	{
		$this->db->insert('xin_leave_applications', $data);
		if ($this->db->affected_rows() > 0) {
			$insert_id = $this->db->insert_id();
			return $insert_id;
		} else {
			return false;
		}
	}

	public function add_leave_history_record($data)
	{
		$this->db->insert('xin_employee_leave_applications_history', $data);
		if ($this->db->affected_rows() > 0) {
			$insert_id = $this->db->insert_id();
			return $insert_id;
		} else {
			return false;
		}
	}


	public function edit_leave_history_record($data, $id)
	{
		$this->db->where('leave_id', $id);
		if ($this->db->update('xin_employee_leave_applications_history', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function getNormalUnpaidLeaves($id)
	{
		$sql = 'SELECT * FROM xin_leave_applications  WHERE leave_unpaid_auto = ?  GROUP BY leave_type_id';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function deleteUnpaidLeavesNormal($id)
	{
		$this->db->where('leave_unpaid_auto', $id);
		$this->db->delete('xin_leave_applications');
	}

	public function carryLeavesData($emp_id, $leave_id, $start_start, $end_date)
	{
		$sql = 'SELECT * FROM carry_leaves   WHERE employee_id = ? and leave_type_id = ? and (create_date >= ? and create_date <= ?) GROUP BY leave_type_id';
		$binds = array($emp_id, $leave_id, $start_start, $end_date);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function GetCarrySingleData($carry_id)
	{
		$sql = 'SELECT * FROM carry_leaves WHERE id = ?';
		$binds = array($carry_id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function emp_leave_update($data, $id)
	{
		$this->db->where('id', $id);
		if ($this->db->update('employee_leave', $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function annual_leave_availablefor_emp_limt($id, $leave_type)
	{
		$sql = 'SELECT * FROM employee_leave  WHERE employee_id = ?  and leave_type = ? order by created_at desc limit 1 ';
		$binds = array($id, $leave_type);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function annual_leave_date_check_new($emp_id, $start_date_p, $end_date_p)
	{

		//	$sql = 'SELECT * from xin_annual_leave_applications where  employee_id = ? and status = 2 and ((from_date >=  ? and to_date <= ?) )';
		$sql = 'SELECT * from xin_annual_leave_applications where  employee_id = ? and status = 2 and ((date(from_date) BETWEEN ? and ?) OR (date(to_date) BETWEEN ? and ?) OR ((from_date >=  ? and to_date <= ?) ))';
		$binds = array($emp_id, $start_date_p, $end_date_p, $start_date_p, $end_date_p, $start_date_p, $end_date_p);
		$query = $this->db->query($sql, $binds);
	}

	public function annual_leave_date_new($emp_id, $start_date_p, $end_date_p)
	{
		$sql = 'SELECT * from xin_annual_leave_applications where  employee_id = ? and status = 2 and (from_date >=  ? and to_date <= ?)';
		$binds = array($emp_id, $start_date_p, $end_date_p);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function get_leave_employees($id)
	{

		$sql = 'SELECT * FROM employee_leave left join xin_leave_type on leave_type=leave_type_id WHERE employee_id = ? ';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_em($id)
	{
		$sql = 'SELECT * FROM  xin_employees WHERE user_id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function get($id)
	{
		$sql = 'SELECT * FROM employee_leave left join xin_leave_type on leave_type=leave_type_id WHERE id = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function get_duty($employee_id)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? ';
		$binds = array($employee_id);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function get_timetable()
	{

		$sql = 'SELECT * FROM xin_attendance_time  ';
		$binds = array();
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function attendance_first_all($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? ';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function attendance_first_out_all($employee_id, $attendance_date)
	{

		$sql = 'SELECT * FROM xin_attendance_time WHERE employee_id = ? and attendance_date = ? order by time_attendance_id ';
		$binds = array($employee_id, $attendance_date);
		$query = $this->db->query($sql, $binds);

		return $query->result();
	}

	public function get_datas($start_date, $employee_id, $end_date)
	{
		// echo$start_date;

		$sql = "SELECT attendance_date, timetable, on_duty, off_duty, late, absent, clock_in, clock_out FROM xin_attendance_time WHERE attendance_date BETWEEN '$start_date' AND '$end_date' AND employee_id = $employee_id 
		        UNION ALL
		        SELECT attendance_date, timetable, on_duty, off_duty, late, absent, clock_in, clock_out FROM new_attendance_time WHERE attendance_date BETWEEN '$start_date' AND '$end_date' AND employee_id = $employee_id order by attendance_date";
		// 	SELECT * FROM `xin_attendance_time` WHERE attendance_date BETWEEN '2021-07-01' AND '2021-07-08' AND
		// 	`employee_id`=11 UNION ALL SELECT * FROM `new_attendance_time` WHERE attendance_date BETWEEN '2021-07-01' AND '2021-07-08' AND `employee_id`=11    	
		//	$binds = array($start_date,$employee_id,$end_date);
		$query = $this->db->query($sql);
		//print_r($sql);

		return $query->result();
	}

	public function leave_update($data, $id)
	{
		$values = serialize($data);
		$this->db->set('local_store', $values);
		$this->db->where('id', $id);
		if ($this->db->update('employee_leave')) {
			return true;
		} else {
			return false;
		}
// 		$this->db->where('id', $id);
// 		if ($this->db->update('employee_leave', $data)) {
// 			return true;
// 		} else {
// 			return false;
// 		}
	}

	public function get_id($id)
	{

		$sql = 'SELECT * FROM  xin_leave_type  WHERE type_name = ? limit 1';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function get_leave_employees_new($id)
	{

		$sql = 'SELECT * FROM employee_leave left join xin_leave_type on leave_type=leave_type_id WHERE employee_id = ? and (leave_type != 3 and leave_type != 4)';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_leave_employees_new_Cron($id, $leave)
	{
		$sql = "SELECT * FROM employee_leave left join xin_leave_type on leave_type=leave_type_id WHERE employee_id = ? and leave_type = ?  order by employee_leave.created_at desc limit 1";
		$binds = array($id, $leave);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function date_exist($id, $date)
	{
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? and `attendance_date` = ?';
		$binds = array($id, $date);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	public function annual_leaves_exitsBased_onEmp($id, $emp_id)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE id != ? and employee_id = ? and status = ? order by id desc limit 1';
		$binds = array($id, $emp_id, 2);
		$query = $this->db->query($sql, $binds);

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function check_sick_leave_exceeded($emp_id)
	{
		$sql = 'SELECT * FROM xin_leave_applications WHERE employee_id = ? and status = ? and sick_leave_noti = ?';
		$binds = array($emp_id, 2, 'Y');
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function insert_common($table, $data)
	{
		$this->db->insert($table, $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}

	public function common_select($table, $con)
	{
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where($con);
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function update_common($table, $data, $id)
	{
		$this->db->where('id', $id);
		if ($this->db->update($table, $data)) {
			return true;
		} else {
			return false;
		}
	}

	public function select_leave_paid_list($empid, $yr_check)
	{
		$sql = "SELECT *,SUM(total_paid_count) as total_paid_counts,SUM(total_half_paid_count) as total_half_paid_counts,SUM(total_unpaid_count) as total_unpaid_counts FROM `xin_emp_sickleave_manage` where YEAR(date) = ? and emp_id = '$empid' and status = 'Y'";
		$binds = array($yr_check);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function select_leave_paid_list_new($empid, $yr_check, $leave_id)
	{
		$sql = "SELECT * FROM `xin_emp_sickleave_manage` where YEAR(date) = ? and emp_id = '$empid' and status = 'Y' and leave_id = ? ";
		$binds = array($yr_check, $leave_id);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}

	public function delete_common($table, $cond)
	{
		$this->db->where('leave_id', $cond);
		$this->db->delete($table);
	}

	public function get_attendance_details($id)
	{
		$sql = 'SELECT * FROM xin_attendance_time where time_attendance_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function get_employees_overtime_details()
	{

		$sql = 'SELECT * FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies
    ON  xin_companies.company_id = xin_employees.company_id WHERE xin_attendance_time.ot = "yes" ORDER BY xin_attendance_time.attendance_date ';
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}

	}

	public function getemployees_overtime_details()
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_companies.trading_name, xin_attendance_time.attendance_date, xin_attendance_time.attendance_date, xin_attendance_time.clock_in, xin_attendance_time.clock_out, xin_attendance_time.normal_ot_hours, xin_attendance_time.extra_ot_hours, xin_attendance_time.ot_amount FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies
    ON  xin_companies.company_id = xin_employees.company_id WHERE xin_attendance_time.ot = "yes" ORDER BY xin_attendance_time.attendance_date ';
		$query = $this->db->query($sql);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}

	}

	public function get_allemployees_datewise_overtime_details($start, $end, $compid)
	{

		$sql = 'SELECT * FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies
    ON  xin_companies.company_id = xin_employees.company_id WHERE xin_attendance_time.attendance_date >= ? AND xin_attendance_time.attendance_date <= ? AND xin_employees.company_id = ? AND xin_attendance_time.ot = "yes" ORDER BY xin_attendance_time.attendance_date';
		$binds = array($start, $end, $compid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	/*public function getallemployees_datewise_overtime_details($start,$end,$compid) {
		
		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id, xin_companies.trading_name, xin_attendance_time.attendance_date, xin_attendance_time.attendance_date, xin_attendance_time.clock_in, xin_attendance_time.clock_out, xin_attendance_time.normal_ot_hours, xin_attendance_time.extra_ot_hours, xin_attendance_time.ot_amount FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies
    ON  xin_companies.company_id = xin_employees.company_id WHERE xin_attendance_time.attendance_date >= ? AND xin_attendance_time.attendance_date <= ? AND xin_employees.company_id = ? AND xin_attendance_time.ot = "yes" ORDER BY xin_attendance_time.attendance_date';
		$binds = array($start,$end,$compid);
		$query = $this->db->query($sql,$binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}*/
	public function getallemployees_datewise_overtime_details($start, $end)
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id,  xin_attendance_time_total.date, xin_attendance_time_total.ot_seconds, xin_attendance_time_total.normal_ot_seconds, xin_attendance_time_total.extra_ot_seconds FROM xin_employees left join xin_attendance_time_total on xin_employees.user_id= xin_attendance_time_total.employee_id WHERE xin_attendance_time_total.date >= ? AND xin_attendance_time_total.date <= ? AND xin_attendance_time_total.ot_seconds > 0 ORDER BY xin_attendance_time_total.date';
		$binds = array($start, $end);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	public function getemployees_datewise_overtime_details_new($start_date, $end_date, $company_id, $employee_id, $location_id)
	{


		if ($company_id != '') {
			$company_str = "AND xin_employees.company_id IN($company_id)";
		} else {
			$company_str = "";
		}

		if ($location_id != '') {
			$location_str = "AND xin_employees.location_id IN($location_id)";
		} else {
			$location_str = "";
		}

		if ($employee_id != '') {
			$employee_str = "AND xin_employees.user_id IN($employee_id)";
		} else {
			$employee_str = "";
		}


		$sql = "SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id,  xin_attendance_time_total.date, xin_attendance_time_total.ot_seconds, xin_attendance_time_total.normal_ot_seconds, xin_attendance_time_total.extra_ot_seconds FROM xin_employees left join xin_attendance_time_total on xin_employees.user_id= xin_attendance_time_total.employee_id WHERE xin_attendance_time_total.date >= ? AND xin_attendance_time_total.date <= ? AND xin_attendance_time_total.ot_seconds > 0 $company_str $location_str $employee_str ORDER BY xin_attendance_time_total.date";
		$binds = array($start_date, $end_date);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}

	}

	public function getallemployees_datewise_overtime_details_new($start_date, $end_date, $company_id, $location_id)
	{


		if ($company_id != '') {
			$company_str = "AND xin_employees.company_id IN($company_id)";
		} else {
			$company_str = "";
		}

		if ($location_id != '') {
			$location_str = "AND xin_employees.location_id IN($location_id)";
		} else {
			$location_str = "";
		}


		$sql = "SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id,  xin_attendance_time_total.date, xin_attendance_time_total.ot_seconds, xin_attendance_time_total.normal_ot_seconds, xin_attendance_time_total.extra_ot_seconds FROM xin_employees left join xin_attendance_time_total on xin_employees.user_id= xin_attendance_time_total.employee_id WHERE xin_attendance_time_total.date >= ? AND xin_attendance_time_total.date <= ? AND xin_attendance_time_total.ot_seconds > 0 $company_str $location_str ORDER BY xin_attendance_time_total.date";
		$binds = array($start_date, $end_date);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}

	}

	public function get_employees_datewise_overtime_details($start, $end, $compid, $empid)
	{

		$sql = 'SELECT * FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies
    ON  xin_companies.company_id = xin_employees.company_id WHERE  xin_attendance_time.attendance_date >= ? AND xin_attendance_time.attendance_date <= ? AND xin_employees.company_id = ? AND xin_employees.user_id = ? AND xin_attendance_time.ot = "yes" ORDER BY xin_attendance_time.attendance_date';
		$binds = array($start, $end, $compid, $empid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	/*public function getemployees_datewise_overtime_details($start,$end,$compid,$empid) {

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id, xin_companies.trading_name, xin_attendance_time.attendance_date, xin_attendance_time.attendance_date, xin_attendance_time.clock_in, xin_attendance_time.clock_out, xin_attendance_time.normal_ot_hours, xin_attendance_time.extra_ot_hours, xin_attendance_time.ot_amount FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies
    ON  xin_companies.company_id = xin_employees.company_id WHERE  xin_attendance_time.attendance_date >= ? AND xin_attendance_time.attendance_date <= ? AND xin_employees.company_id = ? AND xin_employees.user_id = ? AND xin_attendance_time.ot = "yes" ORDER BY xin_attendance_time.attendance_date';
		$binds = array($start,$end,$compid,$empid);
		$query = $this->db->query($sql,$binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}*/

	public function getemployees_datewise_overtime_details($start, $end, $empid)
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.employee_id, xin_employees.user_id, xin_attendance_time_total.date, xin_attendance_time_total.ot_seconds, xin_attendance_time_total.normal_ot_seconds, xin_attendance_time_total.extra_ot_seconds FROM xin_employees left join xin_attendance_time_total on xin_employees.user_id= xin_attendance_time_total.employee_id WHERE xin_attendance_time_total.date >= ? AND xin_attendance_time_total.date <= ? AND xin_employees.user_id = ? AND xin_attendance_time_total.ot_seconds > 0 ORDER BY xin_attendance_time_total.date';
		$binds = array($start, $end, $empid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}


	public function getallemployees_datewise_loan_details($start, $end, $compid)
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_salary_loan_deductions.loan_deduction_id, xin_salary_loan_deductions.employee_id, xin_salary_loan_deductions.loan_deduction_title, xin_salary_loan_deductions.start_date, xin_salary_loan_deductions.end_date, xin_salary_loan_deductions.monthly_installment, xin_salary_loan_deductions.status FROM xin_employees left join xin_salary_loan_deductions on xin_employees.user_id= xin_salary_loan_deductions.employee_id WHERE xin_salary_loan_deductions.start_date >= ? AND xin_salary_loan_deductions.start_date <= ? AND xin_employees.company_id = ? AND xin_salary_loan_deductions.final_approval = 1 ORDER BY xin_salary_loan_deductions.start_date';
		$binds = array($start, $end, $compid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	public function getemployees_datewise_loan_details($start, $end, $compid, $empid)
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_salary_loan_deductions.loan_deduction_id, xin_salary_loan_deductions.employee_id, xin_salary_loan_deductions.loan_deduction_title, xin_salary_loan_deductions.start_date, xin_salary_loan_deductions.end_date, xin_salary_loan_deductions.monthly_installment, xin_salary_loan_deductions.status FROM xin_employees left join xin_salary_loan_deductions on xin_employees.user_id= xin_salary_loan_deductions.employee_id WHERE xin_salary_loan_deductions.start_date >= ? AND xin_salary_loan_deductions.start_date <= ? AND xin_employees.company_id = ? AND xin_employees.user_id = ? AND xin_salary_loan_deductions.final_approval = 1 ORDER BY xin_salary_loan_deductions.start_date';
		$binds = array($start, $end, $compid, $empid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	public function get_loanpaid($empid, $loanid)
	{

		$sql = "SELECT sum(loan_amount) as loan_paid FROM xin_salary_payslip_loan WHERE employee_id='$empid' AND loan_id='$loanid'";
		$query = $this->db->query($sql);
		return $query->result();

	}

	public function getallemployees_datewise_advance_details($start, $end, $compid)
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_advance_salaries.employee_id, xin_advance_salaries.start_date, xin_advance_salaries.end_date, xin_advance_salaries.advance_amount, xin_advance_salaries.total_paid, xin_advance_salaries.status FROM xin_employees left join xin_advance_salaries on xin_employees.user_id= xin_advance_salaries.employee_id WHERE xin_advance_salaries.start_date >= ? AND xin_advance_salaries.start_date <= ? AND xin_employees.company_id = ? AND xin_advance_salaries.status = 1 ORDER BY xin_advance_salaries.start_date';
		$binds = array($start, $end, $compid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	public function getemployees_datewise_advance_details($start, $end, $compid, $empid)
	{

		$sql = 'SELECT xin_employees.first_name, xin_employees.last_name, xin_advance_salaries.employee_id, xin_advance_salaries.start_date, xin_advance_salaries.end_date, xin_advance_salaries.advance_amount, xin_advance_salaries.total_paid, xin_advance_salaries.status FROM xin_employees left join xin_advance_salaries on xin_employees.user_id= xin_advance_salaries.employee_id WHERE xin_advance_salaries.start_date >= ? AND xin_advance_salaries.start_date <= ? AND xin_employees.company_id = ? AND xin_employees.user_id = ? AND xin_advance_salaries.status = 1 ORDER BY xin_advance_salaries.start_date';
		$binds = array($start, $end, $compid, $empid);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}


	public function leave_date_check_new_annual($emp_id, $start_date_p, $end_date_p)
	{
		//$sql = 'SELECT * from xin_annual_leave_applications where  employee_id = ? and status = 2 and ((date(from_date) BETWEEN ? and ?) OR (date(to_date) BETWEEN ? and ?)) OR ((from_date >=  ? and to_date <= ?) )';
		$sql = 'SELECT * from xin_annual_leave_applications where  employee_id = ? and status = 2 and ((date(from_date) BETWEEN ? and ?)) ';

		$binds = array($emp_id, $start_date_p, $end_date_p);
		$query = $this->db->query($sql, $binds);

		return $query;
	}

	public function annual_leave_availablefor_emp_carry($id, $leave_type)
	{
		$sql = 'SELECT * FROM carry_leaves  WHERE employee_id = ?  and leave_type_id = ?  order by create_date desc limit 1';
		$binds = array($id, $leave_type);
		$query = $this->db->query($sql, $binds);
		return $query->result();
	}

	public function delete_common_de($table, $cond)
	{
		$this->db->where('id', $cond);
		$this->db->delete($table);
	}

	public function get_employee_extra_remaining_leaves_nums_new($emp_id, $leave_id, $start_start, $end_date)
	{
		//$current_year =  $yr;
		//$start_start = $current_year . '-01-01';
		//$end_date = $current_year . '-12-31';
		$this->db->where('employee_id', $emp_id);
		$this->db->where('leave_type_id', $leave_id);
		if ($leave_id != 6) {
			$this->db->where('create_date >=', $start_start);
			$this->db->where('create_date <=', $end_date);
		}
		$this->db->order_by("id", "desc");
		return $this->db->get('carry_leaves');
	}

	public function get_company_leaves_new_annual($company_id, $approval_stage = '', $current_user)
	{
		$sql = 'SELECT * FROM xin_annual_leave_applications WHERE company_id = ? order by applied_on desc';
		if ($approval_stage == 'first') {

			$sql .= ' AND first_approval = 0';

		} else if ($approval_stage == 'last') {

			$sql .= ' AND first_approval = 1 AND final_approval = 0';

		}
		$sql .= ' OR employee_id = ?';
		$binds = array($company_id, $current_user);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_employee_extra_remaining_leaves_nums_starndrd($emp_id, $leave_id, $start_start, $end_date)
	{
		//$current_year =  $yr;
		//$start_start = $current_year . '-01-01';
		//$end_date = $current_year . '-12-31';
		$this->db->where('employee_id', $emp_id);
		$this->db->where('leave_type_id', $leave_id);
		/*if ($leave_id != 6) {
			$this->db->where('create_date >=', $start_start);
			$this->db->where('create_date <=', $end_date);
		}*/
		$this->db->order_by("create_date", "desc");
		$this->db->limit(1);
		return $this->db->get('carry_leaves');
	}


	//new

	public function getallemployees_datewise_overtime_details_payroll_report($start_date, $end_date, $company_id, $employee_id)
	{

		if ($company_id != '') {
			$company_str = "AND xin_employees.company_id IN($company_id)";
		} else {
			$company_str = "";
		}

		if ($employee_id != 0) {
			$employee_str = "AND xin_employees.user_id IN($employee_id)";
		} else {
			$employee_str = "";
		}

		$sql = "SELECT * FROM xin_employees left join xin_attendance_time on xin_employees.user_id= xin_attendance_time.employee_id  left join xin_companies ON  xin_companies.company_id = xin_employees.company_id WHERE xin_attendance_time.attendance_date >= ? AND xin_attendance_time.attendance_date <= ? $company_str $employee_str AND xin_attendance_time.ot = 'yes' ORDER BY xin_attendance_time.attendance_date";
		$binds = array($start_date, $end_date);
		$query = $this->db->query($sql, $binds);
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return null;
		}
	}

	public function get_all_employees_datewise_advance_details2($start, $end, $compid, $empid)
	{

		if ($compid != '') {
			$company_str = "AND xin_employees.company_id IN($compid)";
		} else {
			$company_str = "";
		}

		if ($empid != '') {
			$employee_str = "AND xin_employees.user_id IN($empid)";
		} else {
			$employee_str = "";
		}

		$sql = "SELECT xin_employees.first_name, xin_employees.last_name, xin_employees.company_id, xin_advance_salaries.employee_id, xin_advance_salaries.start_date, xin_advance_salaries.end_date, xin_advance_salaries.advance_amount, xin_advance_salaries.total_paid, xin_advance_salaries.status FROM xin_employees left join xin_advance_salaries on xin_employees.user_id= xin_advance_salaries.employee_id WHERE xin_advance_salaries.start_date >= ? AND xin_advance_salaries.start_date <= ? $company_str $employee_str AND xin_advance_salaries.status = 1 ORDER BY xin_advance_salaries.start_date";
		$binds = array($start, $end);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function get_all_employees_datewise_advance_details_count2($start, $end, $compid, $empid)
	{

		if ($compid != '') {
			$company_str = "AND xin_employees.company_id IN($compid)";
		} else {
			$company_str = "";
		}

		if ($empid != '') {
			$employee_str = "AND xin_employees.user_id IN($empid)";
		} else {
			$employee_str = "";
		}

		$sql = "SELECT xin_employees.company_id FROM xin_employees left join xin_advance_salaries on xin_employees.user_id= xin_advance_salaries.employee_id WHERE xin_advance_salaries.start_date >= ? AND xin_advance_salaries.start_date <= ? $company_str $employee_str AND xin_advance_salaries.status = 1 GROUP BY xin_employees.company_id";
		$binds = array($start, $end);
		$query = $this->db->query($sql, $binds)->result_array();
		return $query;
	}

	//holiday data get
	public function get_holidays_current_month_wise($current_month)
	{
		$sql = "SELECT * FROM `xin_holidays` WHERE start_date BETWEEN '$current_month-01' and '$current_month-31' ORDER BY start_date DESC";
		$query = $this->db->query($sql);
		return $query;
	}

	public function get_holidays_full_list_wise($current_month)
	{
		$current_year = date('Y');
		$sql = "SELECT * FROM `xin_holidays` WHERE (`start_date` NOT BETWEEN '$current_month-01' and '$current_month-31') AND YEAR(start_date) = '$current_year'";
		$query = $this->db->query($sql);
		return $query;
	}

	public function get_this_month_holiday_count($current_month, $last_date)
	{
		$sql = "SELECT  COUNT(start_date) as not_count FROM `xin_holidays` WHERE start_date BETWEEN '$current_month' and '$last_date-31'";
		$query = $this->db->query($sql);
		return $query->result_array();
	}
	//holiday data get end

	public function user_attendance($attendance_date,$user_id)
	{
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? and `attendance_date` = ? order by time_attendance_id desc limit 1';
		$binds = array($user_id, $attendance_date);
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function user_attendance_clockout($attendance_date,$user_id)
	{
		$sql = 'SELECT * FROM xin_attendance_time where `employee_id` = ? and `attendance_date` = ? and clock_out = ? order by time_attendance_id desc limit 1';
		$binds = array($user_id, $attendance_date, '');
		$query = $this->db->query($sql, $binds);
		return $query;
	}

	public function insert($data, $table)
	{
		$this->db->insert($table, $data);
		$insert_id = $this->db->insert_id();
		if ($this->db->affected_rows() > 0) {
			$insert_id = $this->db->insert_id();
		} else {
			$insert_id = '';
		}
		return $insert_id;
	}

	public function get_data($table, $condition)
	{
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where($condition);
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}

	public function get_data_ordered($table, $condition, $order_field, $order_by)
	{
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where($condition);
		$this->db->order_by($order_field, $order_by);
		$query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}

	public function update_data($table, $condition, $data)
	{
		$this->db->where($condition);
		if ($this->db->update($table, $data)) {
			return true;
		} else {
			return false;
		}
	}


}
