<div class="row m-b-1">
	<div class="col-md-4">
		<div class="card">
			<div class="card-header with-elements">
				<span class="card-header-title mr-2">
					<strong><?=$heading?></strong>
				</span>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-md-12">
						<?php if (isset($form_error)):?>
							<div class="alert alert-danger"><?=$form_error?></div>
						<?php endif;?>
						<?php if ($this->session->flashdata('form_success')):?>
							<div class="alert alert-success"><?=$this->session->flashdata('form_success')?></div>
						<?php endif;?>
						<?php
						if ($leave_salary->id == 0) {
							echo form_open('admin/leave_salary/set', array(
								'name' => 'leave_salary_set',
							));
						} else {
							echo form_open('admin/leave_salary/edit/' . $leave_salary->id, array(
								'name' => 'leave_salary_set',
							));
						}
						?>
						<div class="form-group">
							<label for="category">Category</label>
							<select class="form-control" name="category" id="category" data-plugin="select_hrm" data-placeholder="Category" required <?php if ($leave_salary->id > 0):?> readonly disabled <?php endif;?>>
								<option value=""></option>
								<option value="expat"<?php if ($leave_salary->category == 'expat'):?> selected <?php endif;?>>Expat</option>
								<option value="bahraini"<?php if ($leave_salary->category == 'bahraini'):?> selected <?php endif;?>>Bahraini</option>
		                  	</select>
		                </div>
		                <div class="form-group allowances">
							<label for="allowances">Allowances</label>
							<?php foreach ($allowances as $key => $allowance):?>
								<div class="form-check">
									<input type="checkbox" id="allow_<?=$key?>" name="allowances[]" value="<?=$allowance->id?>"<?php if (in_array($allowance->id, $leave_salary->allowances)):?> checked <?php endif;?>>
									<label class="form-check-label" for="allow_<?=$key?>"><?=$allowance->name?></label>
								</div>
							<?php endforeach;?>
						</div>
						<div class="form-group allowances">
							<label for="commissions">Commissions</label>
							<?php foreach ($commissions as $key => $commissions):?>
								<div class="form-check">
									<input type="checkbox" id="commissions_<?=$key?>" name="commissions[]" value="<?=$commissions->id?>"<?php if (in_array($commissions->id, $leave_salary->commissions)):?> checked <?php endif;?>>
									<label class="form-check-label" for="commissions_<?=$key?>"><?=$commissions->name?></label>
								</div>
							<?php endforeach;?>
						</div>
						<div class="form-group deductions">
							<label for="deductions">Deductions</label>
							<?php foreach ($deductions as $key => $deduction):?>
								<div class="form-check">
									<input type="checkbox" id="dedu_<?=$key?>" name="deductions[]" value="<?=$deduction->id?>"<?php if (in_array($deduction->id, $leave_salary->deductions)):?> checked <?php endif;?>>
									<label class="form-check-label" for="dedu_<?=$key?>"><?=$deduction->name?></label>
								</div>
							<?php endforeach;?>
						</div>
						<div class="form-group allowances">
							<label for="other_payments">Other payments</label>
							<?php foreach ($other_payments as $key => $other_payments):?>
								<div class="form-check">
									<input type="checkbox" id="other_payments_<?=$key?>" name="other_payments[]" value="<?=$other_payments->id?>"<?php if (in_array($other_payments->id, $leave_salary->other_payments)):?> checked <?php endif;?>>
									<label class="form-check-label" for="other_payments_<?=$key?>"><?=$other_payments->name?></label>
								</div>
							<?php endforeach;?>
						</div>
						<div class="form-group allowances">
							<label for="other_payments">Loan</label>
							<?php foreach ($loan as $key => $loan):?>
								<div class="form-check">
									<input type="checkbox" id="loan_<?=$key?>" name="loan[]" value="<?=$loan->id?>"<?php if (in_array($loan->id, $leave_salary->loan)):?> checked <?php endif;?>>
									<label class="form-check-label" for="loan_<?=$key?>"><?=$loan->name?></label>
								</div>
							<?php endforeach;?>
						</div>
						<div class="form-actions box-footer">
							<button type="submit" class="btn btn-primary">
								<i class="fa fa-check-square-o"></i>
								<?php if ($leave_salary->id == 0):?> Save
								<?php else:?> Save Changes
								<?php endif;?>
							</button>
							<?php if ($leave_salary->id > 0):?>
								<a href="<?=base_url('admin/leave_salary/set')?>" class="btn btn-default">Cancel</a>
							<?php endif;?>
						</div>
						<input type="hidden" name="submit" value="submit">
						<?php echo form_close(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-8">
    	<div class="card mb-4">
    		<div class="card-header with-elements">
    			<span class="card-header-title mr-2">
    				<strong>Leave Salaries</strong>
    			</span>
    		</div>
			<div class="card-body">
				<?php if ($this->session->flashdata('success')):?>
					<div class="alert alert-success"><?=$this->session->flashdata('success')?></div>
				<?php endif;?>
				<?php if ($this->session->flashdata('error')):?>
					<div class="alert alert-danger"><?=$this->session->flashdata('error')?></div>
				<?php endif;?>
				<div class="box-datatable table-responsive">
					<table class="datatables-demo table table-striped table-bordered" id="xin_table">
						<thead>
							<tr>
								<th>Category</th>
								<th>Allowances</th>
								<th>Deductions</th>
								<th>Commissions</th>
								<th>Other payments</th>
								<th>Loans</th>
								<th></th>
							</tr>
						</thead>
					</table>
				</div>
			</div>
    	</div>
    </div>
</div>

<div class="modal fadeInLeft delete-ls-modal animated" role="dialog" aria-modal="true">
	<div class="modal-dialog">
    	<div class="modal-content">
    		<div class="modal-header">
    			<button type="button" aria-label="Close" data-dismiss="modal" class="close">
    				<span aria-hidden="true">×</span>
    			</button>
    			<strong class="modal-title">Are you sure you want to delete this record?</strong>
    		</div>
    		<div class="alert alert-danger">
    			<strong>Record deleted can't be restored!!!</strong>
    		</div>
    		<?php
    		echo form_open('admin/leave_salary/delete', array(
				'name' => 'leave_salary_delete',
				'id' => 'leave_salary_delete',
			));
			?>
			<input type="hidden" name="id" id="id">
    		<div class="modal-footer">
    			<input type="hidden" name="token_type" value="0" id="token_type">
    			<button type="button" data-dismiss="modal" class="btn btn-secondary">
    				<i class="fa far fa-check-square"></i> Close
    			</button>
    			<button name="hrsale_form" type="submit" class="btn btn-primary ladda-button" data-style="expand-right">
    				<span class="ladda-label"><i class="fa far fa-check-square"></i> Confirm</span>
    				<span class="ladda-spinner"></span>
    			</button>
    		</div>
    		<?php echo form_close();?>
    	</div>
    </div>
</div>