<!DOCTYPE html>
<html lang="en">

<head>
    <title>Daily Attendance Sheet Report</title>
  <style type="text/css">
    body {
      position: relative;
      width: 21cm;
      height: 29.7cm;
      margin: 0 auto;
      font-family: Verdana, sans-serif;
      font-size: 12px;
      font-family: Verdana;
    }

    #page_1 {
      position: relative;
      overflow: hidden;
      padding: 0px;
      border: none;
    }

    #page_1 #id1_1 {
      border: none;
      border: none;
      overflow: hidden;
    }

    #page_1 #id1_2 {
      border: none;
      margin: 20px 0px 0px 0px;
      padding: 0px;
      border: none;
      width: 790px;
      overflow: hidden;
    }

    #page_1 #p1dimg1 {
      position: absolute;
      top: 55px;
      left: 52px;
      z-index: -1;
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1dimg1 #p1img1 {
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1inl_img1 {
      position: relative;
      width: 56px;
      height: 14px;
    }



    .ft0 {
      font: bold 15px 'Helvetica';
      line-height: 18px;
    }

    .ft1 {
      font: 13px 'Helvetica';
      line-height: 16px;
    }

    .ft2 {
      font: bold 21px 'Arial';
      line-height: 24px;
    }

    .ft3 {
      font: bold 12px 'Arial';
      line-height: 16px;
    }

    .ft4 {
      font: 13px 'Arial';
      line-height: 16px;
    }

    .p0 {
      text-align: left;
      padding-left: 1px;
      margin-top: 0px;
      margin-bottom: 0px;
    }

    .p1 {
      text-align: left;
      padding-left: 63px;
      margin-top: 1px;
      margin-bottom: 0px;
    }

    .p2 {
      text-align: left;
      padding-left: 297px;
      margin-top: 46px;
      margin-bottom: 0px;
    }

    .p3 {
      text-align: left;
      padding-left: 258px;
      margin-top: 8px;
      margin-bottom: 0px;
    }



    table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 5px;
      margin-bottom: 30px;
      margin-top: 30px;

    }

    td {
      padding: 3px;
      text-align: center;
    }


    th {
      padding: 10px;
    }
    
    @media print {
             #page_1 {
                border: 1px solid white;
                height: 99%;
                page-break-after: avoid;
             }
    }
  </style>
</head>

  <body>
      
      <div class="empty_data">
      <span style="text-align:left"><?php echo $logo; ?></span>
      <h2 style="text-align:center;"><b><?php echo $company_name; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $header_string; ?></b></p>
      <p style="text-align: center; font-size: 20px; margin-top: 10%;"><b><?php echo $empty_text; ?></b></p>
    </div>

<?php foreach ($depart_main_id_count as $values) { ?>
<div id="page_1">
    <header class="clearfix">
      <span style="text-align:left"><img src="<?php echo $values['logo']; ?>" style="width:25%;"></span>
      <h2 style="text-align:center;"><b><?php echo $values['company_name']; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $values['header_string']; ?></b></p>
      
      <p style="text-align:center;"><b>Daily Attendance Sheet Report</b></p>

      <p align="center"> <span class="ft3">From <?php echo date('d', strtotime($from_date)); ?>/<?php echo date('F', strtotime($from_date)); ?>/<?php echo date('Y', strtotime($from_date)); ?></span>

        <span class="ft3">To <?php echo date('d', strtotime($to_date)); ?>/<?php echo date('F', strtotime($to_date)); ?>/<?php echo date('Y', strtotime($to_date)); ?></span> </p>
    </header>

        <?php $from_date = $from_date;
              $to_date = $to_date; 
              $employee_id = $employee_id; ?>
        

        <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
          <thead>
            <tr style='background-color: #ADD8E6;'>
                        <th>Date</th>
                        <th>Shift Name</th>
                        <th>Shift Start</th>
                        <th>Shift End</th>
                        <th>Late In Grace Time</th>
                        <th>Day Type</th>
                        <th>Clock In</th>
                        <th>Clock Out</th>
                        <th>Late In (hh.mm)</th>
                        <th>Early Out (hh.mm)</th>
                        <th>Odd Punch (day)</th>
                        <th>Absent (day)</th>
                        <th>Shift Hours</th>
                        <th>Working Hours (hh.mm)</th>
                        <th>Original OT (hh.mm)</th>
            </tr>
          </thead>
          <tbody>

          
<?php

foreach ($main_data as $depart_main_id_get) {
  if($values['company_id']==$depart_main_id_get['company_id']){

    $depart_id_data = $depart_main_id_get['department_id'];
    $user_id_data = $depart_main_id_get['user_id'];

        //get department
            $department_name = $this->Xin_model->read_department_info($depart_id_data);
              if(!is_null($department_name)){
                  $dept_name = $department_name[0]->department_name;
                  $dept_code = $department_name[0]->department_code;
              } else {
                  $dept_name = '--';  
                  $dept_code = '--'; 
              }

      if($employee_id == 0){

        $sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_employees.department_id = $depart_id_data Group by xin_attendance_time.employee_id";
          $emp_main_id = $this->db->query($sql_data);

      }else{

        $sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_employees.user_id IN($employee_id) Group by xin_attendance_time.employee_id";
          $emp_main_id = $this->db->query($sql_data);

      }

?>

              <tr style='background-color: #E0E0EB;'>
                <td colspan="2"><b>Department :</b></td>
                <td colspan="13" style=" text-align: left;">&#160;&#160;&#160;&#160;&#160; <?php echo $dept_name ;?></td>
              </tr>

<?php

  foreach ($emp_main_id->result() as $emp_main_id_get) {


          $employee_info = $this->Xin_model->read_employee_info($emp_main_id_get->user_id)[0];
      
          if (! empty($employee_info))
          {
            $full_name_info = $employee_info->first_name." ".$employee_info->last_name;
            $emp_code = $employee_info->employee_id;
            $emp_join_date = $employee_info->date_of_joining;
            $emp_depart_id = $employee_info->department_id;
          }
          else
          {
              $full_name_info = '--';
              $emp_code = '--';
              $emp_join_date = '--';
              $emp_depart_id = '0';
          }

?>
              <tr style='background-color: #E0E0EB;'>
                <td colspan="2"><b>Employee :</b></td>
                <td colspan="13" style=" text-align: left;">&#160;&#160;&#160;&#160;&#160;[<?php echo $emp_code ;?>] <?php echo $full_name_info ;?></td>
              </tr>

<?php

          $emp_main_id_data = $emp_main_id_get->user_id;


      $sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.clock_in >= '$from_date' AND xin_attendance_time.clock_out <= '$to_date' and xin_attendance_time.employee_id = $emp_main_id_data Group by xin_attendance_time.employee_id";
        $employee = $this->db->query($sql_data);

    $late_total = array();
    $early_out_total = array();
    $odd_punch_total = array();
    $absent_total = array();
    $shift_hours_total = array();
    $work_total = array();
    $ot_total = array();

        if($employee->num_rows() > 0){
    foreach ($employee->result() as $r) {
      //get company
      $company = $this->Xin_model->read_company_info($r->company_id);
      if(!is_null($company)){
        $comp_name = $company[0]->name;
      } else {
        $comp_name = '--';  
      }

      $full_name = $r->first_name.' '.$r->last_name;

      $attendance_date = $this->Reports_model->get_all_attendance_date($r->user_id, $from_date, $to_date);

      foreach ($attendance_date as $att) {
        # code...
        foreach ($att as $date) {

          foreach ($date as $key) {

            $att_date = $key->attendance_date;
              //------------------

                $clkInLast = $clkOutLast = '-';

                $this->db->where('employee_id', $r->user_id);
                $this->db->where('attendance_date', $att_date);
                $this->db->order_by('time_attendance_id', 'asc');
                $attendance = $this->db->get('xin_attendance_time');
                
                if ($attendance->num_rows() > 0)
                {
                    
                    foreach ($attendance->result() as $att)
                    {
                      $clock_in = date("H:i",strtotime($att->clock_in));
                      $clock_out = date("H:i",strtotime($att->clock_out));
                        if ($clock_in != '0:00' && $clock_out != '0:00')
                        {
                            if ($clkInLast == '-')
                                $clkInLast = $clock_in;
                            
                            $clkOutLast = $clock_out;
                        }
                    }
                }


                if ($clkInLast != '-')
                {
                    $clkInLast = $this->Misc_model->time_24_to_12($clkInLast);
                }
                if ($clkOutLast != '-' && ! is_null($clkOutLast))
                {
                    $clkOutLast = $this->Misc_model->time_24_to_12($clkOutLast);
                }

              //-----------------

                $clock_in = $clkInLast;
                $clock_out = $clkOutLast;

            $att_status = $key->attendance_status;

            $get_day = strtotime($att_date);
            $day = date('l', $get_day);

            $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

            $working_hours = $this->Reports_model->get_total_work_hours($r->user_id, $att_date);
      
            $odd_punch = $this->Reports_model->calculate_employee_odd_punch($r->user_id, $att_date);
              # code...
            if($day == 'Monday') {
              if(isset($office_shift[0]->monday_in_time)!=''){
                $in_time = $office_shift[0]->monday_in_time;
                $out_time = $office_shift[0]->monday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '00:00:00';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            } else if($day == 'Tuesday') {
              if(isset($office_shift[0]->tuesday_in_time)!=''){
                $in_time = $office_shift[0]->tuesday_in_time;
                $out_time = $office_shift[0]->tuesday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '00:00:00';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            } else if($day == 'Wednesday') {
              if(isset($office_shift[0]->wednesday_in_time)!=''){
                $in_time = $office_shift[0]->wednesday_in_time;
                $out_time = $office_shift[0]->wednesday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '00:00:00';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            } else if($day == 'Thursday') {
              if(isset($office_shift[0]->thursday_in_time)!=''){
                $in_time = $office_shift[0]->thursday_in_time;
                $out_time = $office_shift[0]->thursday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '00:00:00';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            } else if($day == 'Friday') {
              if(isset($office_shift[0]->friday_in_time)!=''){
                $in_time = $office_shift[0]->friday_in_time;
                $out_time = $office_shift[0]->friday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '00:00:00';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            } else if($day == 'Saturday') {
              if(isset($office_shift[0]->saturday_in_time)!=''){

                $in_time = $office_shift[0]->saturday_in_time;
                $out_time = $office_shift[0]->saturday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '00:00:00';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            } else if($day == 'Sunday') {
              if(isset($office_shift[0]->sunday_in_time)!=''){

                $in_time = $office_shift[0]->sunday_in_time;
                $out_time = $office_shift[0]->sunday_out_time;
                $late_in_grace_time_min = $office_shift[0]->late_allowed_till;
                $clock_in_data = $clock_in;
                $clock_out_data = $clock_out;
                $shift_hours = round(abs(strtotime($out_time) - strtotime($in_time)) / 3600,2);
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              } else {
                $in_time = '00:00:00';
                $out_time = '00:00:00';
                $clock_in_data = '00:00:00';
                $clock_out_data = '00:00:00';
                $shift_hours = '0';
                $late_in_grace_time_min = '00:00:00';
                if (isset($office_shift[0]->shift_name)) {
                  # code...
                  $shift_name = $office_shift[0]->shift_name;
                }
                else{
                  $shift_name = '--';
                }
              }
            }

            $early_out_grace_time_min = '00:00';

            //daily attendance info data get
            $attendance_data = $this->Reports_model->get_early_leave_data($r->user_id, $att_date);
            if(!is_null($attendance_data)){
              $early_leave_data_get = $attendance_data[0]->early_leaving; 
              $late_data_get = $attendance_data[0]->late; 
              $work_data_get = $attendance_data[0]->work; 
              $ot_data_get = $attendance_data[0]->overtime; 
            } else {
              $early_leave_data_get = '00:00';
              $late_data_get = '00:00'; 
              $work_data_get = '00:00'; 
              $ot_data_get = '00:00';
            }

            if($att_status == 'Present'){
              if($clock_out_data == ''){
                $odd_punch = 1;
              }else{
                $odd_punch = 0;
              }
              $absent_day = 0;
            }else{
              $odd_punch = 0;
              $absent_day = 1;
            }

            //employee wise total get
            $odd_punch_total[] = $odd_punch;
            $absent_total[] = $absent_day;
            // $shift_hours_total[] = $shift_hours;

            $late_val = $late_data_get;
            $late_val_get = (explode(":",$late_val));
            $late_val_imp = $late_val_get;
            $late_val_final = implode(".",$late_val_imp);
            $late_total[] = $late_val_final;

            $early_val = $early_leave_data_get;
            $early_val_get = (explode(":",$early_val));
            $early_val_imp = $early_val_get;
            $early_val_final = implode(".",$early_val_imp);
            $early_out_total[] = $early_val_final;

            $work_val = $work_data_get;
            $work_val_get = (explode(":",$work_val));
            $work_val_imp = $work_val_get;
            $work_val_final = implode(".",$work_val_imp);
            $work_total[] = $work_val_final;

            $ot_val = $ot_data_get;
            $ot_val_get = (explode(":",$ot_val));
            $ot_val_imp = $ot_val_get;
            $ot_val_final = implode(".",$ot_val_imp);
            $ot_total[] = $ot_val_final;
            //employee wise total get end

            $attendance_date_get = date("d-m-Y", strtotime($att_date)).' ('.$day.')';
            
            if($in_time == ''){
              $shift_in_time = 'Holiday';
            }else{
              $shift_in_time = date('h:i A', strtotime($in_time));
            }

            if($out_time == ''){
              $shift_out_time  = 'Holiday';
            }else{
              $shift_out_time  = date('h:i A', strtotime($out_time));
            }

?>
            <?php 
                if($r->office_shift_id==0)
                {
                    $custom_shift_data=$this->Reports_model->get_custom_shift_data($r->user_id,$att_date);
                    if(!empty($custom_shift_data))
                    {
                        $shift_name=$custom_shift_data['name'];
                        $cust_day=explode('-', $att_date);
                        for ($i=1; $i <= 31; $i++) { 
                            if($cust_day[2]==$i)
                            {
                                if($custom_shift_data[$i.'_in']!=NULL && $custom_shift_data[$i.'_out'] !=NULL)
                                {
                                    $cust_day_in_res=explode(' ', $custom_shift_data[$i.'_in']);
                                    $cust_day_out_res=explode(' ', $custom_shift_data[$i.'_out']);

                                    $shift_hours = round(abs(strtotime($cust_day_out_res[1]) - strtotime($cust_day_in_res[1])) / 3600,2);

                                    $shift_in_time=date('h:i A', strtotime($cust_day_in_res[1]));
                                    $shift_out_time=date('h:i A', strtotime($cust_day_out_res[1]));
                                }else{
                                    $shift_hours=0;
                                    $shift_in_time=0;
                                    $shift_out_time=0;
                                }
                               
                            }
                        }
                        $late_in_grace_time_min=$custom_shift_data['late_allowed_till'].' min';
                        $clock_in_data=$clock_in;
                        $clock_out_data=$clock_out;
                    }else{
                        $shift_name='--';
                        $shift_hours=0;
                        $shift_in_time=0;
                        $shift_out_time=0;
                    }
                }
                $shift_hours_total[] = $shift_hours;
             ?>
                <tr>

                    <td><?php echo $attendance_date_get ;?></td>
                    <td><?php echo $shift_name ;?></td>
                    <td><?php echo $shift_in_time ;?></td>
                    <td><?php echo $shift_out_time ;?></td>
                    <td><?php echo $late_in_grace_time_min ;?></td>
                    <td><?php echo $att_status ;?></td>
                    <td><?php echo $clock_in_data ;?></td>
                    <td><?php echo $clock_out_data ;?></td>
                    <td><?php echo $late_data_get ;?></td>
                    <td><?php echo $early_leave_data_get ;?></td>
                    <td><?php echo $odd_punch ;?></td>
                    <td><?php echo $absent_day ;?></td>
                    <td><?php echo $shift_hours ;?> Hours</td>
                    <td><?php echo $work_data_get ;?></td>
                    <td><?php echo $ot_data_get ;?></td>

                </tr>

<?php

          }
        }
      }
    }   
  }

?>
                      <tr>

                          <td colspan="8"><b>Employee Wise Total :</b></td>
                          <td style='border-right-width: 0px;'><b><?php echo array_sum($late_total) ;?></b></td>
                          <td style='border-right-width: 0px;'><b><?php echo array_sum($early_out_total) ;?></b></td>
                          <td style='border-right-width: 0px;'><b><?php echo array_sum($odd_punch_total) ;?></b></td>
                          <td style='border-right-width: 0px;'><b><?php echo array_sum($absent_total) ;?></b></td>
                          <td style='border-right-width: 0px;'><b><?php echo array_sum($shift_hours_total) ;?></b></td>
                          <td style='border-right-width: 0px;'><b><?php echo array_sum($work_total) ;?></b></td>
                          <td><b><?php echo array_sum($ot_total) ;?></b></td>

                      </tr>

<?php

}

}

}

?>
          

        </tbody>
      </table>

</div>

<?php } ?>
 
</body>

</html>