<!DOCTYPE html>
<html lang="en">

<head>
    <title>Employees Shift Allocation Report</title>
  <style type="text/css">
    body {
      position: relative;
      width: 21cm;
      height: 29.7cm;
      margin: 0 auto;
      font-family: Verdana, sans-serif;
      font-size: 12px;
      font-family: Verdana;
    }

    #page_1 {
      position: relative;
      overflow: hidden;
      padding: 0px;
      border: none;
    }

    #page_1 #id1_1 {
      border: none;
      border: none;
      overflow: hidden;
    }

    #page_1 #id1_2 {
      border: none;
      margin: 20px 0px 0px 0px;
      padding: 0px;
      border: none;
      width: 790px;
      overflow: hidden;
    }

    #page_1 #p1dimg1 {
      position: absolute;
      top: 55px;
      left: 52px;
      z-index: -1;
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1dimg1 #p1img1 {
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1inl_img1 {
      position: relative;
      width: 56px;
      height: 14px;
    }



    .ft0 {
      font: bold 15px 'Helvetica';
      line-height: 18px;
    }

    .ft1 {
      font: 13px 'Helvetica';
      line-height: 16px;
    }

    .ft2 {
      font: bold 21px 'Arial';
      line-height: 24px;
    }

    .ft3 {
      font: bold 12px 'Arial';
      line-height: 16px;
    }

    .ft4 {
      font: 13px 'Arial';
      line-height: 16px;
    }

    .p0 {
      text-align: left;
      padding-left: 1px;
      margin-top: 0px;
      margin-bottom: 0px;
    }

    .p1 {
      text-align: left;
      padding-left: 63px;
      margin-top: 1px;
      margin-bottom: 0px;
    }

    .p2 {
      text-align: left;
      padding-left: 297px;
      margin-top: 46px;
      margin-bottom: 0px;
    }

    .p3 {
      text-align: left;
      padding-left: 258px;
      margin-top: 8px;
      margin-bottom: 0px;
    }



    table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 5px;
      margin-bottom: 30px;
      margin-top: 30px;

    }

    td {
      padding: 3px;
      text-align: center;
    }


    th {
      padding: 10px;
    }

    @media print {
             #page_1 {
                border: 1px solid white;
                height: 99%;
                page-break-after: avoid;
             }
    }
  </style>
</head>

  <body>

<div class="empty_data">
  <span style="text-align:left"><?php echo $logo; ?></span>
  <h2 style="text-align:center;"><b><?php echo $company_name; ?></b></h2>
  <p style="text-align:center;"><b><?php echo $header_string; ?></b></p>
  <p style="text-align: center; font-size: 20px; margin-top: 10%;"><b><?php echo $empty_text; ?></b></p>
</div>

<?php foreach ($depart_main_id_count as $values) { ?>
<div id="page_1">
    <header class="clearfix">
      <span style="text-align:left"><img src="<?php echo $values['logo']; ?>" style="width:25%;"></span>
      <h2 style="text-align:center;"><b><?php echo $values['company_name']; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $values['header_string']; ?></b></p>
      
      <p style="text-align:center;"><b>Employees Shift Allocation Report</b></p>
        <p align="center"> <span class="ft3">From <?php echo date('d', strtotime($from_date)); ?>/<?php echo date('F', strtotime($from_date)); ?>/<?php echo date('Y', strtotime($from_date)); ?></span>

        <span class="ft3">To <?php echo date('d', strtotime($to_date)); ?>/<?php echo date('F', strtotime($to_date)); ?>/<?php echo date('Y', strtotime($to_date)); ?></span>
      </p>
    </header>

        <?php $from_date = $from_date;
              $to_date = $to_date; 
              $employee_id = $employee_id; ?>
        

        <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
          <thead>
            <tr style='background-color: #ADD8E6;'>
                        <th>Emp. Code</th>
                        <th>Emp. Name</th>
                        <th>Date</th>
                        <th>Shift Name</th>
                        <th>Shift In</th>
                        <th>Shift Out</th>
                        <th>Late In Grace Time</th>
                        <th>Shift Hours (hh:mm)</th>
            </tr>
          </thead>
          <tbody>
<?php

  foreach ($main_data as $depart_main_id_get) {
    if($values['company_id']==$depart_main_id_get['company_id']){

    $depart_main_id_data = $depart_main_id_get['department_id'];
    $user_id_data = $depart_main_id_get['user_id'];

            //get department
            $department_name = $this->Xin_model->read_department_info($depart_main_id_data);
              if(!is_null($department_name)){
                  $dept_name = $department_name[0]->department_name;
                  $dept_code = $department_name[0]->department_code;
              } else {
                  $dept_name = '--';  
                  $dept_code = '--'; 
              }

      if($employee_id == 0){

        $sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.department_id = $depart_main_id_data";
          $employee = $this->db->query($sql_data);

      }else{

        $sql_data = "SELECT DISTINCT xin_employees.company_id,xin_employees.office_shift_id,xin_employees.employee_id,xin_employees.first_name, xin_employees.last_name,xin_employees.user_id,xin_employees.department_id, xin_attendance_time.attendance_date from xin_employees JOIN xin_attendance_time on xin_attendance_time.employee_id=xin_employees.user_id WHERE xin_attendance_time.attendance_date >= '$from_date' AND xin_attendance_time.attendance_date <= '$to_date' and xin_employees.user_id IN($employee_id)";
          $employee = $this->db->query($sql_data);

      } 

?>

        <tr style='background-color: #E0E0EB;'>
                <td colspan="2"><b>Department :</b></td>
                <td colspan="6" style=" text-align: left;">&#160;&#160;&#160;&#160;&#160;<?php echo $dept_name ;?></td>
        </tr>

<?php

    foreach ($employee->result() as $r) {


      $att_date = $r->attendance_date;
      $get_day = strtotime($att_date);
      $day = date('l', $get_day);

      $office_shift = $this->Reports_model->read_employee_office_shift($r->office_shift_id);

      if(isset($office_shift[0]->shift_name)!=''){
        $shift_name = $office_shift[0]->shift_name;
      }
      else{
        $shift_name = '--';
      }

      if($day == 'Monday') {
        if(isset($office_shift[0]->monday_in_time)!='' && isset($office_shift[0]->monday_out_time)!=''){
          $shift_in_time = $office_shift[0]->monday_in_time;
          $shift_out_time = $office_shift[0]->monday_out_time;
          $late_allowed_till = $office_shift[0]->late_allowed_till;
        }
        else{
          $late_allowed_till = '00:00';
          $shift_in_time = '';
          $shift_out_time = '';
        }
        
      } else if($day == 'Tuesday') {
        if(isset($office_shift[0]->tuesday_in_time)!='' && isset($office_shift[0]->tuesday_out_time)!=''){
          $shift_in_time = $office_shift[0]->tuesday_in_time;
          $shift_out_time = $office_shift[0]->tuesday_out_time;
          $late_allowed_till = $office_shift[0]->late_allowed_till;
        }
        else{
          $late_allowed_till = '00:00';
          $shift_in_time = '';
          $shift_out_time = '';
        }

      } else if($day == 'Wednesday') {
        if(isset($office_shift[0]->wednesday_in_time)!='' && isset($office_shift[0]->wednesday_out_time)!=''){
          $shift_in_time = $office_shift[0]->wednesday_in_time;
          $shift_out_time = $office_shift[0]->wednesday_out_time;
          $late_allowed_till = $office_shift[0]->late_allowed_till;
        }
        else{
          $late_allowed_till = '00:00';
          $shift_in_time = '';
          $shift_out_time = '';
        }
      } else if($day == 'Thursday') {
        if(isset($office_shift[0]->thursday_in_time)!='' && isset($office_shift[0]->thursday_out_time)!=''){
          $shift_in_time = $office_shift[0]->thursday_in_time;
          $shift_out_time = $office_shift[0]->thursday_out_time;
          $late_allowed_till = $office_shift[0]->late_allowed_till;
        }
        else{
          $late_allowed_till = '00:00';
          $shift_in_time = '';
          $shift_out_time = '';
        }

      } else if($day == 'Friday') {
        if(isset($office_shift[0]->friday_in_time)!='' && isset($office_shift[0]->friday_out_time)!=''){
          $shift_in_time = $office_shift[0]->friday_in_time;
          $shift_out_time = $office_shift[0]->friday_out_time;
          $late_allowed_till = 'Holiday';
        }
        else{
          $late_allowed_till = 'Holiday';
          $shift_in_time = '';
          $shift_out_time = '';
        }

      } else if($day == 'Saturday') {
        if(isset($office_shift[0]->saturday_in_time)!='' && isset($office_shift[0]->saturday_out_time)!=''){
          $shift_in_time = $office_shift[0]->saturday_in_time;
          $shift_out_time = $office_shift[0]->saturday_out_time;
          $late_allowed_till = $office_shift[0]->late_allowed_till;
        }
        else{
          $late_allowed_till = '00:00';
          $shift_in_time = '';
          $shift_out_time = '';
        }

      } else if($day == 'Sunday') {
        if(isset($office_shift[0]->sunday_in_time)!='' && isset($office_shift[0]->sunday_out_time)!=''){
          $shift_in_time = $office_shift[0]->sunday_in_time;
          $shift_out_time = $office_shift[0]->sunday_out_time;
          $late_allowed_till = $office_shift[0]->late_allowed_till;
        }
        else{
          $late_allowed_till = '00:00';
          $shift_in_time = '';
          $shift_out_time = '';
        }

      }
          $full_name = $r->first_name.' '.$r->last_name;

            $attendance_date_get = date("d-m-Y", strtotime($r->attendance_date)). '('.$day.')';

            if($shift_in_time == ''){
              $shift_in_time_get = 'Holiday';
              $shift_in_total = '00:00';
            }else{
              $shift_in_time_get = date('h:i A', strtotime($shift_in_time));
              $shift_in_total = $shift_in_time;
            }

            if($shift_out_time == ''){
              $shift_out_time_get  = 'Holiday';
              $shift_out_total = '00:00';
            }else{
              $shift_out_time_get  = date('h:i A', strtotime($shift_out_time));
              $shift_out_total = $shift_out_time;
            }

            //total shift hour get
            $shift_in_time_dif = new DateTime($shift_in_total);
            $shift_out_time_dif = new DateTime($shift_out_total);
            $shift_time_diff = $shift_in_time_dif->diff($shift_out_time_dif);
            $final_shift_hour = $shift_time_diff->h.':'.$shift_time_diff->i;

            //get employee info
            $employee_info = $this->Xin_model->read_employee_info($r->user_id)[0];
              if (!empty($employee_info))
              {
                  $emp_code = $employee_info->employee_id;
              }
              else
              {
                  $emp_code = '--';
              }
              
            //custom shift get code
		    if($r->office_shift_id==0) {
                $custom_shift_data=$this->Reports_model->get_custom_shift_data($r->user_id,$r->attendance_date);
                if(!empty($custom_shift_data))
                {
                    $shift_name=$custom_shift_data['name'];
                    $cust_day=explode('-', $r->attendance_date);
                    for ($i=1; $i <= 31; $i++) { 
                        if($cust_day[2]==$i)
                        {
                            if($custom_shift_data[$i.'_in']!=NULL && $custom_shift_data[$i.'_out'] !=NULL)
                            {
                                $cust_day_in_res=explode(' ', $custom_shift_data[$i.'_in']);
                                $cust_day_out_res=explode(' ', $custom_shift_data[$i.'_out']);
                                
                                $shift_date_in= $cust_day_in_res[0];
                                $shift_date_out= $cust_day_out_res[0];

                                $shift_hours = round(abs(strtotime($cust_day_out_res[1]) - strtotime($cust_day_in_res[1])) / 3600,2);

                                $shift_in_time_get=date('h:i A', strtotime($cust_day_in_res[1]));
                                $shift_in_total = date('h:i A', strtotime($cust_day_in_res[1]));
                                
                                $shift_out_time_get=date('h:i A', strtotime($cust_day_out_res[1]));
                                $shift_out_total = date('h:i A', strtotime($cust_day_out_res[1]));
                            }else{
                                $shift_hours=0;
                                $shift_in_time_get=0;
                                $shift_out_time_get=0;
                                $shift_date_in= '';
                                $shift_date_out= '';
                            }
                           
                        }
                    }
                    $late_allowed_till=$custom_shift_data['late_allowed_till'].' min';
                }else{
                    $shift_name='--';
                    $shift_hours=0;
                    $shift_in_time_get=0;
                    $shift_out_time_get=0;
                }
            }
            //custom shift get code end
            
            //total shift hour get
            $shift_date_in = $r->attendance_date;
            if($shift_name == 'Night'){
                $shift_date_out = date('Y-m-d', strtotime($r->attendance_date . " +1 days"));
            }else{
                $shift_date_out = $r->attendance_date;
            }
            $datetime1 = new DateTime($shift_date_in. $shift_in_total);
            $datetime2 = new DateTime($shift_date_out. $shift_out_total);
            $interval = $datetime1->diff($datetime2);
            $final_shift_hour = $interval->format('%h')." Hours ".$interval->format('%i')." Minutes";
            //total shift hour get end

?>

              <tr>
                            <td><?php echo $emp_code ;?></td>
                            <td><?php echo $full_name ;?></td>
                            <td><?php echo $attendance_date_get ;?></td>
                            <td><?php echo $shift_name ;?></td>
                            <td><?php echo $shift_in_time_get ;?></td>
                            <td><?php echo $shift_out_time_get ;?></td>
                            <td><?php echo $late_allowed_till ;?></td>
                            <td><?php echo $final_shift_hour ;?></td>";
              </tr>

<?php

    }
  
}

}  

?>
          

        </tbody>
      </table>

      </div>

<?php } ?>
 
</body>

</html>