<!DOCTYPE html>
<html lang="en">

<head>
    <title>Monthly Earning Deduction Report</title>
  <style type="text/css">
    body {
      position: relative;
      width: 21cm;
      height: 29.7cm;
      margin: 0 auto;
      font-family: Verdana, sans-serif;
      font-size: 12px;
      font-family: Verdana;
    }

    #page_1 {
      position: relative;
      overflow: hidden;
      padding: 0px;
      border: none;
    }

    #page_1 #id1_1 {
      border: none;
      border: none;
      overflow: hidden;
    }

    #page_1 #id1_2 {
      border: none;
      margin: 20px 0px 0px 0px;
      padding: 0px;
      border: none;
      width: 790px;
      overflow: hidden;
    }

    #page_1 #p1dimg1 {
      position: absolute;
      top: 55px;
      left: 52px;
      z-index: -1;
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1dimg1 #p1img1 {
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1inl_img1 {
      position: relative;
      width: 56px;
      height: 14px;
    }



    .ft0 {
      font: bold 15px 'Helvetica';
      line-height: 18px;
    }

    .ft1 {
      font: 13px 'Helvetica';
      line-height: 16px;
    }

    .ft2 {
      font: bold 21px 'Arial';
      line-height: 24px;
    }

    .ft3 {
      font: bold 12px 'Arial';
      line-height: 16px;
    }

    .ft4 {
      font: 13px 'Arial';
      line-height: 16px;
    }

    .p0 {
      text-align: left;
      padding-left: 1px;
      margin-top: 0px;
      margin-bottom: 0px;
    }

    .p1 {
      text-align: left;
      padding-left: 63px;
      margin-top: 1px;
      margin-bottom: 0px;
    }

    .p2 {
      text-align: left;
      padding-left: 297px;
      margin-top: 46px;
      margin-bottom: 0px;
    }

    .p3 {
      text-align: left;
      padding-left: 258px;
      margin-top: 8px;
      margin-bottom: 0px;
    }



    table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 5px;
      margin-bottom: 30px;
      margin-top: 30px;

    }

    td {
      padding: 3px;
      text-align: center;
    }


    th {
      padding: 10px;
    }
    @media print {
             #page_1 {
                border: 1px solid white;
                height: 99%;
                page-break-after: avoid;
             }
    }
  </style>
</head>

  <body>
<div id="page_1">
    <header class="clearfix">
      <span style="text-align:left"><img src="<?php echo $logo; ?>" style="width:25%;"></span>
      <h2 style="text-align:center;"><b><?php echo $company_name; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $header_string; ?></b></p>
      
      <p style="text-align:center;font-size: 15px;"><b>Monthly Earning Deduction Report</b></p>
      <p align="center" style="font-size: 15px;"> <span class="ft3" style="font-size: 15px;">Month <?php echo $month_year ; ?></span>
    </header>


<!--content-->

              <?php

                    $aj_company = $aj_company;
                    $aj_department = $aj_department;
                    $location_id = $location_id;
                    $paysheet_employee_id = $paysheet_employee_id;
                    $month_year = $month_year;

                    $monthly_earning_deduction_get_data = $this->Reports_model->monthly_earning_deduction_get_data($aj_company, $aj_department, $location_id, $paysheet_employee_id, $month_year);
                    $total_amount = array();

                    //current date
                    $month_year_cur = $month_year;
                    $year_month_spilt_cur = explode("-", $month_year_cur);
                    $year_cur = $year_month_spilt_cur[0];
                    $month_cur = $year_month_spilt_cur[1];

                    //month character decrease
                    $monthName_cur = date("F", mktime(0, 0, 0, $month_cur, 1));
                    $month_name_cur_get = substr($monthName_cur, 0, 3);
                    $month_year_cur_get = $month_name_cur_get . ', ' . $year_cur;

              ?>

        <!---------------table 1 earning-->
                        <?php
                        $this->db->where('type_id',1);
                        $this->db->or_where('type_id',2);
                        $this->db->or_where('type_id',5);
                        $allowance = $this->db->get('allowance');
                        $allowance_count = count($allowance->result());
                        $total_count_a = $allowance_count + 5;
                        ?>
        <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
        <thead>
                      <tr><th colspan='<?php echo $total_count_a ;?>' style='text-align:center;'>Employees Wise Earning Details</th></tr>
                      
                      <tr>
                      <th>Emp. Code</th>
                      <th>Employee Name</th>
                      <th>Payable Basic</th>
                      <?php
                      $allowances = $this->db->get('allowance');
                      foreach($allowances->result() as $allowance){
                            if($allowance->type_id == 1 || $allowance->type_id == 2  || $allowance->type_id == 5){ 
                                $total_amount[$allowance->id] = 0;
                                $earning_header = ucfirst(strtolower($allowance->name)); 
                       ?>
                                <th><?php echo $earning_header ;?></th>
                      <?php   
                            }
                      }
                      ?>
                      <th>Overtime</th>
                      <th>Gross Salary</th>
                      </tr>

        </thead>
        <tbody>

        <?php
        $basic_salary_total = '0';
        $ot_amount_total = '0';
        $net_pay_total = '0';
        $amount_total = '0';
        
        foreach ($monthly_earning_deduction_get_data->result() as $value_e) {
            

            $emp_main_id = $value_e->employee_id;
            $e_gross_salary = $value_e->basic_salary;
            $net_salary_final_data_e = $value_e->net_salary;
            
            $basic_salary_total += $e_gross_salary;
            $net_pay_total += $net_salary_final_data_e;

            $employee_main_id = $this->Reports_model->read_employee_info($emp_main_id);
            if (!is_null($employee_main_id)) {
                $emp_id = $employee_main_id[0]->employee_id;
                $emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
            } else {
                $emp_id = '--';
                $emp_name = '--';
            }
            
            //overtime get
            $overtime_data = $value_e->total_overtime;
            if (!empty($overtime_data)) {
                $ot_amount = $overtime_data;
            } else {
                $ot_amount = "0";
            }
            $ot_amount_total += $ot_amount;
            print_r($emp_id);
            ?>
        
            <tr>
                
                 <td><?php echo $emp_id ;?></td>
                 <td><?php echo $emp_name ;?></td>
                 <td><?php echo $e_gross_salary ;?></td>
            <?php
                 
            //-------------------allowance get
                
                foreach ($allowances->result() as $allowance) {
                $amount = "0";

                    if ($allowance->type_id == 1) {
                        
                        $sql = "SELECT allowance_amount FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.user_id = ?";
                        $binds = array($allowance->id, $month_year, $emp_main_id);
                        $payslip_allowance = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_allowance)) {

                            $amount_data = $payslip_allowance->allowance_amount;
                            if ($amount_data != '') {
                                $amount = $payslip_allowance->allowance_amount;
                                $amount_total = $payslip_allowance->allowance_amount;
                                $total_amount[$allowance->id] += $amount_total;
                            } else {
                                $amount = 0;
                                $amount_total = 0;
                                $total_amount[$allowance->id] += 0;
                            }
                        }
                        ?>

                        
                        <td><?php echo $amount ;?></td>

                    <?php   
                    } else if ($allowance->type_id == 2) {

                        $sql = "SELECT commission_amount  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.user_id = ?";
                        $binds = array($allowance->id, $month_year, $emp_main_id);
                        $payslip_commission = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_commission)) {

                            $amount_data = $payslip_commission->commission_amount;
                            if ($amount_data != '') {
                                $amount = $payslip_commission->commission_amount;
                                $amount_total = $payslip_commission->commission_amount;
                                $total_amount[$allowance->id] += $amount_total;
                            } else {
                                $amount = 0;
                                $amount_total = 0;
                                $total_amount[$allowance->id] += 0;
                            }
                        }
                    ?>
                        
                        <td><?php echo $amount ;?></td>

                    <?php
                    }
                      
                    else if ($allowance->type_id == 5) {

                        $sql = "SELECT payments_amount FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.user_id = ? ";
                        $binds = array($allowance->id, $month_year, $emp_main_id);
                        $payslip_other_payments = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_other_payments)) {

                            $amount_data = $payslip_other_payments->payments_amount;
                            if ($amount_data != '') {
                                $amount = $payslip_other_payments->payments_amount;
                                $amount_total = $payslip_other_payments->payments_amount;
                                $total_amount[$allowance->id] += $amount_total;
                            } else {
                                $amount = 0;
                                $amount_total = 0;
                                $total_amount[$allowance->id] += 0;
                            }
                        }
                    ?>

                        <td><?php echo $amount ;?></td>

                    <?php
                    }
                }
            //-----------------------------------allowance get end
                ?>
                
                        <td><?php echo $ot_amount ;?></td>
                        <td><?php echo $net_salary_final_data_e ;?></td>
            </tr>

                <?php
                    }
                ?>
                    
                        <tr style='background-color: #E0E0EB;'>
                            <th colspan='2'>Grand Total :</th>
                            <th><?php echo round($basic_salary_total, 3) ;?></th>
                            <?php
                            foreach($total_amount as $key=> $val){ 
                            ?>
                                <th><?php echo round($val, 3) ;?></th>
                            <?php
                            }
                            ?>
                            <th><?php echo round($ot_amount_total, 3) ;?></th>
                            <th><?php echo round($net_pay_total, 3) ;?></th>
                        </tr>
            
        </tbody>
        </table>
        
<!------------------table 2 Deduction-->
                <?php
                        $this->db->where('type_id',3);
                        $this->db->or_where('type_id',4);
                        $deduction = $this->db->get('allowance');
                        $deduction_count = count($deduction->result());
                        $total_count_d = $deduction_count + 8;
                ?>
                <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
                <thead>
                      <tr><th colspan="<?php echo $total_count_d ;?>" style='text-align:center;'>Employees Wise Deduction Details</th></tr>
                      <tr>
                      <th>Emp. Code</th>
                      <th>Employee Name</th>
                      <?php
                      $allowances = $this->db->get('allowance');
                      foreach($allowances->result() as $allowance){
                            if($allowance->type_id == 3 || $allowance->type_id == 4){
                                $total_amount_d[$allowance->id] = 0;
                                $deduction_header = ucfirst(strtolower($allowance->name));
                      ?>
                                <th><?php echo $deduction_header ;?></th>
                      <?php
                             }
                      }
                      ?>

                        <th>Late Deduction</th>
                        <th>Loan Deduction</th>
                        <th>Leave Deduction</th>
                        <th>Advance Salary</th>
                        <th>Total Deduction</th>
                        <th>Net Payable</th>
                        </tr>

                </thead>
                <tbody>

                    <?php
                    $amount_total_d = '0';
                    $late_deduction_total = 0;
                    $loan_data_total = 0;
                    $leave_total = 0;
                    $adv_total = 0;
                    $total_deduction_value_total = 0;
                    $net_pay_total = 0;

                    foreach ($monthly_earning_deduction_get_data->result() as $value_d) {
                        $emp_main_id = $value_d->employee_id;
                        $d_gross_salary = $value_d->basic_salary;
                        $net_salary_final_data = $value_d->net_salary;

                        $net_pay_total += $net_salary_final_data;

                        $employee_main_id = $this->Reports_model->read_employee_info($emp_main_id);
                        if (!is_null($employee_main_id)) {
                            $emp_id = $employee_main_id[0]->employee_id;
                            $emp_name = $employee_main_id[0]->first_name . ' ' . $employee_main_id[0]->last_name;
                        } else {
                            $emp_id = '--';
                            $emp_name = '--';
                        }
                    ?>


                                <tr>
                                    <td><?php echo $emp_id ;?></td>
                                    <td><?php echo $emp_name ;?></td>

                        <?php
                        //-----------------------Deduction get
                            $deduction_total = "0";
                            foreach ($allowances->result() as $allowance) {
                            $amount = "0";

                                if ($allowance->type_id == 3) {

                                    $sql = "SELECT deduction_amount FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.user_id = ?";
                                    $binds = array($allowance->id, $month_year, $emp_main_id);
                                    $statutory_deduction = $this->db->query($sql, $binds)->row();

                                    if (!empty($statutory_deduction)) {

                                        $amount_data = $statutory_deduction->deduction_amount;
                                        if ($amount_data != '') {
                                            $amount = $statutory_deduction->deduction_amount;
                                            $amount_total_d = $statutory_deduction->deduction_amount;
                                            $total_amount_d[$allowance->id] += $amount_total_d;
                                            $deduction_total += $statutory_deduction->deduction_amount;
                                        } else {
                                            $amount = 0;
                                            $amount_total_d = 0;
                                            $total_amount_d[$allowance->id] += 0;
                                            $deduction_total += 0;
                                        }
                                    }
                        ?>

                                    <td><?php echo $amount ;?></td>
                        <?php            
                            
                                } else if ($allowance->type_id == 4) {

                                    $sql = "SELECT loan_amount FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.user_id = ?";
                                    $binds = array($month_year, $emp_main_id);
                                    $payslip_loan = $this->db->query($sql, $binds)->row();

                                    if (!empty($payslip_loan)) {

                                        $amount_data = $payslip_loan->loan_amount;
                                        if ($amount_data != '') {
                                            $amount = $payslip_loan->loan_amount;
                                            $amount_total_d = $payslip_loan->loan_amount;
                                            $total_amount_d[$allowance->id] += $amount_total_d;
                                            $deduction_total += $payslip_loan->loan_amount;
                                        } else {
                                            $amount = 0;
                                            $amount_total_d = 0;
                                            $total_amount_d[$allowance->id] += 0;
                                            $deduction_total += 0;
                                        }
                                    }
                        ?>
                                    <td><?php echo $amount ;?></td>
                        <?php
                                    
                                }
                            }

                            //-----------------------Deduction get end
                            
                            //Late Deduction
                            $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id ";
                            $late_deduction_data = $this->db->query($sql_late)->row();
                            if (!empty($late_deduction_data)) {
                                $late_deduction_data_get = $late_deduction_data->total_late_deduction;
                            } else {
                                $late_deduction_data_get = 0;
                            }

                            $late_deduction_total += $late_deduction_data_get;
                            
                            //loan Deduction
                            $sql_loan = "SELECT total_loan FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";
                            $loan_data = $this->db->query($sql_loan)->row();
                            if (!empty($loan_data)) {
                                $loan_data_get = $loan_data->total_loan;
                            } else {
                                $loan_data_get = 0;
                            }

                            $loan_data_total += $loan_data_get;

                            //Leave Deduction
                            $sql_leave = "SELECT leave_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";
                            $leave_data = $this->db->query($sql_leave)->row();
                            if (!empty($leave_data)) {
                                $leave_amount = $leave_data->leave_deduction;
                            } else {
                                $leave_amount = 0;
                            }

                            $leave_total += $leave_amount;

                            //Advance Salary
                            $sql_adv = "SELECT advance_salary_amount FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";
                            $adv_data = $this->db->query($sql_adv)->row();
                            if (!empty($adv_data)) {
                                $adv_amount = $adv_data->advance_salary_amount;
                            } else {
                                $adv_amount = 0;
                            }

                            $adv_total += $adv_amount;
                            
                            
                            $total_deduction_value_get = $deduction_total + $late_deduction_data_get + $loan_data_get + $leave_amount + $adv_amount;

                            $total_deduction_value_total += $total_deduction_value_get;

                        ?>
                    
                                     <td><?php echo $late_deduction_data_get ?></td>
                                     <td><?php echo $loan_data_get ?></td>
                                     <td><?php echo $leave_amount ?></td>
                                     <td><?php echo $adv_amount ?></td>
                                     <td><?php echo $total_deduction_value_get ?></td>
                                     <td><?php echo $net_salary_final_data ?></td>
                                   </tr>
                        <?php
                    }
                        ?>

                                        <tr style='background-color: #E0E0EB;'>
                                          <th colspan='2'>Grand Total :</th>
                                          <?php
                                          foreach($total_amount_d as $key=> $val){
                                          ?>
                                             <th><?php echo round($val, 3) ;?></th>
                                          <?php
                                          }
                                          ?>
                                           <th><?php echo round($late_deduction_total, 3) ;?></th>
                                           <th><?php echo round($loan_data_total, 3) ;?></th>
                                           <th><?php echo round($leave_total, 3) ;?></th>
                                           <th><?php echo round($adv_total, 3) ;?></th>
                                           <th><?php echo round($total_deduction_value_total, 3) ;?></th>
                                           <th><?php echo round($net_pay_total, 3) ;?></th>
                                        </tr>

                </tbody>
                </table>

<!--content end-->


</div>
  </body>

</html>