<!DOCTYPE html>
<html lang="en">

<head>
    <title>Monthly Salary Setup Report</title>
  <style type="text/css">
    body {
      position: relative;
      width: 21cm;
      height: 29.7cm;
      margin: 0 auto;
      font-family: Verdana, sans-serif;
      font-size: 12px;
      font-family: Verdana;
    }

    #page_1 {
      position: relative;
      overflow: hidden;
      padding: 0px;
      border: none;
    }

    #page_1 #id1_1 {
      border: none;
      border: none;
      overflow: hidden;
    }

    #page_1 #id1_2 {
      border: none;
      margin: 20px 0px 0px 0px;
      padding: 0px;
      border: none;
      width: 790px;
      overflow: hidden;
    }

    #page_1 #p1dimg1 {
      position: absolute;
      top: 55px;
      left: 52px;
      z-index: -1;
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1dimg1 #p1img1 {
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1inl_img1 {
      position: relative;
      width: 56px;
      height: 14px;
    }



    .ft0 {
      font: bold 15px 'Helvetica';
      line-height: 18px;
    }

    .ft1 {
      font: 13px 'Helvetica';
      line-height: 16px;
    }

    .ft2 {
      font: bold 21px 'Arial';
      line-height: 24px;
    }

    .ft3 {
      font: bold 12px 'Arial';
      line-height: 16px;
    }

    .ft4 {
      font: 13px 'Arial';
      line-height: 16px;
    }

    .p0 {
      text-align: left;
      padding-left: 1px;
      margin-top: 0px;
      margin-bottom: 0px;
    }

    .p1 {
      text-align: left;
      padding-left: 63px;
      margin-top: 1px;
      margin-bottom: 0px;
    }

    .p2 {
      text-align: left;
      padding-left: 297px;
      margin-top: 46px;
      margin-bottom: 0px;
    }

    .p3 {
      text-align: left;
      padding-left: 258px;
      margin-top: 8px;
      margin-bottom: 0px;
    }



    table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 5px;
      margin-bottom: 30px;
      margin-top: 30px;

    }

    td {
      padding: 3px;
      text-align: center;
      font-size: 20px;
    }


    th {
      padding: 10px;
      font-size: 20px;
    }
    
    @media print {
             #page_1 {
                border: 1px solid white;
                height: 99%;
                page-break-after: avoid;
             }
    }
  </style>
</head>

<body>
    
    <div class="empty_data">
      <span style="text-align:left"><?php echo $logo; ?></span>
      <h2 style="text-align:center;"><b><?php echo $company_name; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $header_string; ?></b></p>
      <p style="text-align: center; font-size: 20px; margin-top: 10%;"><b><?php echo $empty_text; ?></b></p>
    </div>

<?php foreach ($payslip_re_count as $values) { ?>
    <div id="page_1">
      <header class="clearfix">
      <span style="text-align:left"><img src="<?php echo $values['logo']; ?>" style="width:25%;"></span>
      <h2 style="text-align:center;"><b><?php echo $values['company_name']; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $values['header_string']; ?></b></p>
      
      <p style="text-align:center;"><b>Monthly Salary Setup Report</b></p>
      <p align="center"><span class="ft3">Month <?php echo date('F', strtotime($month_year)); ?>/<?php echo date('Y', strtotime($month_year)); ?></span></p>

    </header>

      <?php  $month_year = $month_year; 
             $employee_id = $employee_id; ?>
        

        <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
          <thead>
            <tr>
                <th><?php echo 'Department';?></th>
                <th><?php echo 'No Of Employee';?></th>
                <th><?php echo 'Basic pay';?></th>
                <?php
                $allowances = $this->db->get('allowance');
                foreach($allowances->result() as $allowance):
                $tittle = $allowance->name;
                $tittle_get = strtolower($tittle);?>
                <th style="text-transform: capitalize"><?php echo $tittle_get;?></th>
                <?php endforeach;?>
                <th><?php echo 'Loan Amount';?></th>
                <th><?php echo 'Other Payments';?></th>
                <th><?php echo 'Late Deduction';?></th>
                <th><?php echo 'Leave Deduction';?></th>
                <th><?php echo 'Overtime';?></th>
                <th><?php echo 'Advance Salary';?></th>
                <th><?php echo 'Net Pay';?></th>
            </tr>
          </thead>

          <tbody>
              
<?php if($employee_id == ''){ ?>

<!--/////////-->

 <?php 
          foreach ($main_data as $value) { 
          if($values['company_id']==$value['company_id']){
    ?>
<tr>


<?php

        // department
            $department = $this->Department_model->read_department_information($value['department_id']);
            if(!is_null($department)){
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';   
            } 
              
              
            //get head count
      $head_count = $this->Reports_model->get_head_count('', $value['department_id'], $month_year);
      if(!is_null($head_count)){
        $head_count_get = $head_count[0]->headcount;
      } else {
          $head_count_get = '--';  
      }
      
       //get basic salary
      $basic_salary = $this->Reports_model->get_basic_salary('', $value['department_id'], $month_year);
      if(!is_null($basic_salary)){
        $basic_salary_data = $basic_salary[0]->total_salary;
      } else {
          $basic_salary_data = '--';   
      } 
      
      $basic_salary_value = number_format((float)$basic_salary_data, 2, '.', '');
      
      ?>

            <td><?php echo $department_name;?></td>
            <td><?php echo $head_count_get;?></td>
            <td><?php echo $basic_salary_value;?></td>


       <?php         $gross_salary = $basic_salary_data;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance)

                {

                    if ($allowance->type_id == 1)

                    {

                        $sql = 'SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.department_id = ?';

                    $binds = array($allowance->id, $month_year, $value['department_id']);

                    $payslip_allowance = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_allowance))

                    {

                        $amount_data = $payslip_allowance->allowance_amount_total;

                        $gross_salary += $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_allowance->allowance_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 2)

                    {

                        $sql = 'SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.department_id = ?';

                    $binds = array($allowance->id, $month_year, $value['department_id']);

                    $payslip_commission = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_commission))

                    {

                        $amount_data = $payslip_commission->commission_amount_total;

                        $gross_salary += $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_commission->commission_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 3)

                    {

                        $sql = 'SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.department_id = ?';

                    $binds = array($allowance->id, $month_year, $value['department_id']);

                    $statutory_deduction = $this->db->query($sql, $binds)->row();

                    if (! empty($statutory_deduction))

                    {

                        $amount_data = $statutory_deduction->deduction_amount_total;

                        $gross_salary -= $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $statutory_deduction->deduction_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 4)

                    {

                        $sql = 'SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.department_id = ?';

                    $binds = array($allowance->id, $month_year, $value['department_id']);

                    $payslip_other_payments = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_other_payments))

                    {

                        $amount_data = $payslip_other_payments->payments_amount_total;

                        $gross_salary += $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_other_payments->payments_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 5)

                    {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.department_id = ?";

                    $binds = array($month_year, $value['department_id']);

                    $payslip_loan = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_loan))

                    {

                        $amount_data = $payslip_loan->loan_amount_total;

                        $gross_salary -= $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_loan->loan_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    } 
                    
                     $amount_value = number_format((float)$amount, 2, '.', '');
                    ?>

                    <td><?php echo $amount_value;?></td>
     
          <?php      }

          $department_id = $value['department_id'];
                
            //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $department_id";

                    $late_deduction_data = $this->db->query($sql_late)->row();
                    if (!empty($late_deduction_data))
                    {
                        $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                    }else{
                        $late_deduction_data_get = '0';
                        } 
                
                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $department_id";
                $leave_data = $this->db->query($sql_leave)->row();
                
                if (!empty($leave_data)) {
                        $leave_amount = $leave_data->total_leave_deduction_amt;
                    }else{
                        $leave_amount = "0";
                        }
                        
                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $department_id";
                $overtime_data = $this->db->query($sql_ot)->row();
                
                if (!empty($overtime_data)) {
                        $ot_amount = $overtime_data->total_ot_amt;
                    }else{
                        $ot_amount = "0";
                        }
                        
                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $department_id";
                $adv_data = $this->db->query($sql_adv)->row();
                
                if (!empty($adv_data)) {
                        $adv_amount = $adv_data->total_adv_amt;
                    }else{
                        $adv_amount = "0";
                        }
                        
                //Loan
                $sql_loan = "SELECT SUM(total_loan) as total_loan_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $department_id";
                $loan_data = $this->db->query($sql_loan)->row();
                
                if (!empty($loan_data)) {
                        $loan_amount = $loan_data->total_loan_amt;
                    }else{
                        $loan_amount = "0";
                }
                
                //other payments
                $sql_op = "SELECT SUM(total_other_payments) as total_other_payments FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and department_id = $department_id";
                $op_data = $this->db->query($sql_op)->row();
                
                if (!empty($op_data)) {
                        $op_amount = $op_data->total_other_payments;
                    }else{
                        $op_amount = "0";
                }
                
                //get Gross salary
              $gross_salary = $this->Reports_model->get_gross_salary('', $value['department_id'], $month_year);
              if(!is_null($gross_salary)){
                $gross_salary_data = $gross_salary[0]->gross_salary;
              } else {
                  $gross_salary_data = '--';   
              }
            
            $loan_amount_value = number_format((float)$loan_amount, 2, '.', '');
          $op_amount_value = number_format((float)$op_amount, 2, '.', '');
          $late_deduction_value = number_format((float)$late_deduction_data_get, 2, '.', '');
          $leave_amount_value = number_format((float)$leave_amount, 2, '.', '');
          $ot_amount_value = number_format((float)$ot_amount, 2, '.', '');
          $adv_amount_value = number_format((float)$adv_amount, 2, '.', '');
            
            ?>

            <td><?php echo $loan_amount_value;?></td>
            <td><?php echo $op_amount_value;?></td>
            <td><?php echo $late_deduction_value;?></td>
            <td><?php echo $leave_amount_value;?></td>
            <td><?php echo $ot_amount_value;?></td>
            <td><?php echo $adv_amount_value;?></td>
            <td><?php echo round($gross_salary_data, 3);?></td>

          </tr>

    <?php } } ?>
    
<!--///////////-->
    
<?php }else{ ?>

<!--///////////-->


 <?php 
          foreach ($main_data as $value) { 
          if($values['company_id']==$value['company_id']){
    ?>
    
            <tr>


<?php

        // department
            $department = $this->Department_model->read_department_information($value['department_id']);
            if(!is_null($department)){
                $department_name = $department[0]->department_name;
            } else {
                $department_name = '--';   
            } 
              
              
            //get head count
      $head_count = $this->Reports_model->get_head_count_emp($employee_id, $month_year);
      if(!is_null($head_count)){
        $head_count_get = $head_count[0]->headcount;
      } else {
          $head_count_get = '--';  
      }
      
       //get basic salary
      $basic_salary = $this->Reports_model->get_basic_salary_emp($employee_id, $month_year);
      if(!is_null($basic_salary)){
        $basic_salary_data = $basic_salary[0]->total_salary;
      } else {
          $basic_salary_data = '--';   
      }

$basic_salary_value = number_format((float)$basic_salary_data, 2, '.', '');

       ?>

            <td><?php echo $department_name;?></td>
            <td><?php echo $head_count_get;?></td>
            <td><?php echo $basic_salary_value;?></td>


       <?php         $gross_salary = $basic_salary_data;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance)

                {

                    if ($allowance->type_id == 1)

                    {

                        $sql = "SELECT SUM(allowance_amount) as allowance_amount_total FROM xin_salary_payslip_allowances INNER JOIN xin_employees ON xin_salary_payslip_allowances.employee_id = xin_employees.user_id WHERE xin_salary_payslip_allowances.allowance_title= ? and xin_salary_payslip_allowances.salary_month=? and xin_employees.user_id IN($employee_id)";

                    $binds = array($allowance->id, $month_year);

                    $payslip_allowance = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_allowance))

                    {

                        $amount_data = $payslip_allowance->allowance_amount_total;

                        $gross_salary += $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_allowance->allowance_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 2)

                    {

                        $sql = "SELECT SUM(commission_amount) as commission_amount_total  FROM xin_salary_payslip_commissions INNER JOIN xin_employees ON xin_salary_payslip_commissions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_commissions.commission_title= ? and xin_salary_payslip_commissions.salary_month=? and xin_employees.user_id IN($employee_id)";

                    $binds = array($allowance->id, $month_year);

                    $payslip_commission = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_commission))

                    {

                        $amount_data = $payslip_commission->commission_amount_total;

                        $gross_salary += $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_commission->commission_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 3)

                    {

                        $sql = "SELECT SUM(deduction_amount) as deduction_amount_total FROM xin_salary_payslip_statutory_deductions INNER JOIN xin_employees ON xin_salary_payslip_statutory_deductions.employee_id = xin_employees.user_id WHERE xin_salary_payslip_statutory_deductions.deduction_title= ? and xin_salary_payslip_statutory_deductions.salary_month=? and xin_employees.user_id IN($employee_id)";

                    $binds = array($allowance->id, $month_year);

                    $statutory_deduction = $this->db->query($sql, $binds)->row();

                    if (! empty($statutory_deduction))

                    {

                        $amount_data = $statutory_deduction->deduction_amount_total;

                        $gross_salary -= $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $statutory_deduction->deduction_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 4)

                    {

                        $sql = "SELECT SUM(payments_amount) as payments_amount_total FROM xin_salary_payslip_other_payments INNER JOIN xin_employees ON xin_salary_payslip_other_payments.employee_id = xin_employees.user_id WHERE xin_salary_payslip_other_payments.payments_title= ? and xin_salary_payslip_other_payments.salary_month=? and xin_employees.user_id IN($employee_id)";

                    $binds = array($allowance->id, $month_year);

                    $payslip_other_payments = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_other_payments))

                    {

                        $amount_data = $payslip_other_payments->payments_amount_total;

                        $gross_salary += $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_other_payments->payments_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    }

                    else if ($allowance->type_id == 5)

                    {

                        $sql = "SELECT SUM(loan_amount) as loan_amount_total FROM xin_salary_payslip_loan INNER JOIN xin_employees ON xin_salary_payslip_loan.employee_id = xin_employees.user_id WHERE xin_salary_payslip_loan.salary_month=? and xin_employees.user_id IN($employee_id)";

                    $binds = array($month_year);

                    $payslip_loan = $this->db->query($sql, $binds)->row();

                    if (! empty($payslip_loan))

                    {

                        $amount_data = $payslip_loan->loan_amount_total;

                        $gross_salary -= $amount_data;
                        
                        if($amount_data != ''){
                          $amount = $payslip_loan->loan_amount_total;
                        }else{
                          $amount = '0'; }

                    }

                    } 

                       $amount_value = number_format((float)$amount, 2, '.', '');
                    ?>

                    <td><?php echo $amount_value;?></td>
     
          <?php      }

          $department_id = $value['department_id'];

          $user_id = $value['user_id'];
                
            //Late Deduction
                $sql_late = "SELECT SUM(total_late_deduction) as total_late_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";

                    $late_deduction_data = $this->db->query($sql_late)->row();
                    if (!empty($late_deduction_data))
                    {
                        $late_deduction_data_get = $late_deduction_data->total_late_deduction_amt;
                    }else{
                        $late_deduction_data_get = '0';
                        } 
                
                //Leave Deduction
                $sql_leave = "SELECT SUM(leave_deduction) as total_leave_deduction_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
                $leave_data = $this->db->query($sql_leave)->row();
                
                if (!empty($leave_data)) {
                        $leave_amount = $leave_data->total_leave_deduction_amt;
                    }else{
                        $leave_amount = "0";
                        }
                        
                //overtime get
                $sql_ot = "SELECT SUM(total_overtime) as total_ot_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
                $overtime_data = $this->db->query($sql_ot)->row();
                
                if (!empty($overtime_data)) {
                        $ot_amount = $overtime_data->total_ot_amt;
                    }else{
                        $ot_amount = "0";
                        }
                        
                //Advance Salary
                $sql_adv = "SELECT SUM(advance_salary_amount) as total_adv_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
                $adv_data = $this->db->query($sql_adv)->row();
                
                if (!empty($adv_data)) {
                        $adv_amount = $adv_data->total_adv_amt;
                    }else{
                        $adv_amount = "0";
                        }
                        
                //Loan
                $sql_loan = "SELECT SUM(total_loan) as total_loan_amt FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
                $loan_data = $this->db->query($sql_loan)->row();
                
                if (!empty($loan_data)) {
                        $loan_amount = $loan_data->total_loan_amt;
                    }else{
                        $loan_amount = "0";
                }
                
                //other payments
                $sql_op = "SELECT SUM(total_other_payments) as total_other_payments FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id IN($employee_id)";
                $op_data = $this->db->query($sql_op)->row();
                
                if (!empty($op_data)) {
                        $op_amount = $op_data->total_other_payments;
                    }else{
                        $op_amount = "0";
                }
                
                //get Gross salary
          $gross_salary = $this->Reports_model->get_gross_salary_emp($employee_id, $month_year);
          if(!is_null($gross_salary)){
            $gross_salary_data = $gross_salary[0]->gross_salary;
          } else {
              $gross_salary_data = '--';   
          }

          $loan_amount_value = number_format((float)$loan_amount, 2, '.', '');
          $op_amount_value = number_format((float)$op_amount, 2, '.', '');
          $late_deduction_value = number_format((float)$late_deduction_data_get, 2, '.', '');
          $leave_amount_value = number_format((float)$leave_amount, 2, '.', '');
          $ot_amount_value = number_format((float)$ot_amount, 2, '.', '');
          $adv_amount_value = number_format((float)$adv_amount, 2, '.', '');
            
            ?>

            <td><?php echo $loan_amount_value;?></td>
            <td><?php echo $op_amount_value;?></td>
            <td><?php echo $late_deduction_value;?></td>
            <td><?php echo $leave_amount_value;?></td>
            <td><?php echo $ot_amount_value;?></td>
            <td><?php echo $adv_amount_value;?></td>
            <td><?php echo $gross_salary_data;?></td>

          </tr>

    <?php } } ?>

<!--//////////-->
    
<?php } ?>




   

          </tbody>

        </table>
    </div>
<?php } ?>

 
</body>

</html>