<!DOCTYPE html>
<html lang="en">

<head>
    <title>Pay Sheet of a Period</title>
  <style type="text/css">
    body {
      position: relative;
      width: 21cm;
      height: 29.7cm;
      margin: 0 auto;
      font-family: Verdana, sans-serif;
      font-size: 12px;
      font-family: Verdana;
    }

    #page_1 {
      position: relative;
      overflow: hidden;
      padding: 0px;
      border: none;
    }

    #page_1 #id1_1 {
      border: none;
      border: none;
      overflow: hidden;
    }

    #page_1 #id1_2 {
      border: none;
      margin: 20px 0px 0px 0px;
      padding: 0px;
      border: none;
      width: 790px;
      overflow: hidden;
    }

    #page_1 #p1dimg1 {
      position: absolute;
      top: 55px;
      left: 52px;
      z-index: -1;
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1dimg1 #p1img1 {
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1inl_img1 {
      position: relative;
      width: 56px;
      height: 14px;
    }



    .ft0 {
      font: bold 15px 'Helvetica';
      line-height: 18px;
    }

    .ft1 {
      font: 13px 'Helvetica';
      line-height: 16px;
    }

    .ft2 {
      font: bold 21px 'Arial';
      line-height: 24px;
    }

    .ft3 {
      font: bold 12px 'Arial';
      line-height: 16px;
    }

    .ft4 {
      font: 13px 'Arial';
      line-height: 16px;
    }

    .p0 {
      text-align: left;
      padding-left: 1px;
      margin-top: 0px;
      margin-bottom: 0px;
    }

    .p1 {
      text-align: left;
      padding-left: 63px;
      margin-top: 1px;
      margin-bottom: 0px;
    }

    .p2 {
      text-align: left;
      padding-left: 297px;
      margin-top: 46px;
      margin-bottom: 0px;
    }

    .p3 {
      text-align: left;
      padding-left: 258px;
      margin-top: 8px;
      margin-bottom: 0px;
    }



    table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 5px;
      margin-bottom: 30px;
      margin-top: 30px;

    }

    td {
      padding: 3px;
      text-align: center;
    }


    th {
      padding: 10px;
    }
    @media print {
             #page_1 {
                border: 1px solid white;
                height: 99%;
                page-break-after: avoid;
             }
    }
  </style>
</head>

  <body>
<div id="page_1">
    <header class="clearfix">
      <span style="text-align:left margin-top:-5%;"><img src="<?php echo $logo; ?>" style="width:25%;"></span>
      <h2 style="text-align:center; margin-top:-1%;"><b><?php echo $company_name; ?></b></h2>
      <p style="text-align:center;"><b><?php echo $header_string; ?></b></p>
      
      <p style="text-align:center;font-size: 15px;"><b>Pay Sheet of a Period</b></p>
      <p align="center" style="font-size: 15px;"> 
        <span class="ft3" style="font-size: 15px;">From <?php echo $from_month_year ; ?></span> / <span class="ft3" style="font-size: 15px;">To <?php echo $to_month_year ; ?></span>
      </p>
    </header>


<!--content-->

              <?php
                    $aj_company = $aj_company;
                    $location_id = $location_id;
                    $aj_department = $aj_department;
                    $paysheet_employee_id = $paysheet_employee_id;
                    $from_month_year = $from_month_year;
                    $to_month_year = $to_month_year;
              ?>

      <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
        <thead>
                      <tr>
                          <th><?php echo 'ID & Name';?></th>
                          <th><?php echo 'Month Year';?></th>
                          <th class="title-space"><?php echo 'Present[P] & Absent[A]';?></th>
                          <th><?php echo 'Basic';?></th>
                          <th><?php echo 'LOP';?></th>
                          <?php
                          $allowances = $this->db->get('allowance');
                          foreach($allowances->result() as $allowance):?>
                          <th><?php echo $allowance->name;?></th>
                          <?php endforeach;?>
                          <th><?php echo 'Leave Encashment';?></th>
                          <th><?php echo 'Overtime';?></th>
                          <th><?php echo 'Salary Advance';?></th>
                          <th><?php echo 'Indemnity';?></th>
                          <th><?php echo 'Loan Deductions';?></th>
                          <th><?php echo 'Leave Deductions';?></th>
                          <th><?php echo 'Late Deductions';?></th>
                          <th><?php echo 'Net Pay';?></th>
                      </tr>
        </thead>
        <tbody>

<!--backend code -->

<?php

$payslip_re = $this->Reports_model->pay_sheet_period_data_get($aj_company, $aj_department, $location_id, $paysheet_employee_id, $from_month_year, $to_month_year);


            foreach ($payslip_re as $value) {
                
                ?>
            
            <tr>
                
                <?php

                $employee = $this->Reports_model->read_employee_info($value->employee_id);

                if (!is_null($employee)) {

                    $full_name = $employee[0]->first_name . ' ' . $employee[0]->last_name;

                    $emp_id = $employee[0]->employee_id;

                    $date_of_joining = $employee[0]->date_of_joining;

                    $basic_salary = $employee[0]->basic_salary;
                } else {

                    $full_name = '--';

                    $emp_id = '--';

                    $date_of_joining = '--';

                    $basic_salary = '--';
                }

                $month_year = $from_month_year;

                $date = strtotime(date("Y-m-d"));

                if (!isset($month_year)) {

                    $day = date('d', $date);

                    $month = date('m', $date);

                    $year = date('Y', $date);

                    $month_year = date('Y-m');
                } else {

                    $imonth_year = explode('-', $month_year);

                    $day = date('d', $date);

                    $month = date($imonth_year[1], $date);

                    $year = date($imonth_year[0], $date);

                    $month_year = $month_year;
                }

                $daysInMonth = date('t', mktime(0, 0, 0, $month, 1, $year));

                $start_date_y_m = date('Y-m', strtotime($month_year));

                $work_day = $this->Reports_model->work_day($year, $month);


                // $emp_leave_in_month = $this->Reports_model->month_leave($value->employee_id, $year, $month);

                // if ($emp_leave_in_month != '') {

                //     $lop = $emp_leave_in_month[0]->monthly_leaves;
                // } else {

                //     $lop = '--';
                // }

                    $emp_leave_in_month = $this->Reports_model->lop_days_get($value->employee_id, date('m',strtotime($value->salary_month)), date('Y',strtotime($value->salary_month)));
                    if ($emp_leave_in_month != '') {
                        $lop = $emp_leave_in_month[0]->total_unpaid_count;
                    } else {
                        $lop = '0';
                    }

                //test
                $sql1 = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ?';
                $binds1 = array($value->employee_id);
                $payslip_allowance = $this->db->query($sql1, $binds1)->row();

                if (!empty($payslip_allowance)) {
                    $amount1 = $payslip_allowance->allowance_amount;
                } else {
                    $amount1 = '0';
                }

                $sql2 = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ?';
                $binds2 = array($value->employee_id);
                $payslip_commission = $this->db->query($sql2, $binds2)->row();

                if (!empty($payslip_commission)) {
                    $amount2 = $payslip_commission->commission_amount;
                } else {
                    $amount2 = '0';
                }

                $sql3 = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ?';
                $binds3 = array($value->employee_id);
                $payslip_other_payments = $this->db->query($sql3, $binds3)->row();

                if (!empty($payslip_other_payments)) {
                    $amount3 = $payslip_other_payments->payments_amount;
                } else {
                    $amount3 = '0';
                }

                //get carry leave
                $carry_leaves = $this->Reports_model->get_carry_leaves($value->employee_id);
                if (!is_null($carry_leaves)) {
                    $carry_leaves_get = $carry_leaves[0]->remaing_leave_count;
                } else {
                    $carry_leaves_get = '0';
                }

                $month_year = $value->salary_month;
                $year_month_spilt = explode("-", $month_year);
                $year = $year_month_spilt[0];
                $month = $year_month_spilt[1];
                $month_days = cal_days_in_month(CAL_GREGORIAN, $month, $year);

                //$absent_days =  $month_days - $value->monthy_present_days;
                
                $employee_leave = $this->Reports_model->get_employee_leave_payslip($value->employee_id, $value->salary_month, $value->company_id);
                if (!is_null($employee_leave)) {
                    $leave_count = $employee_leave;
                } else {
                    $leave_count = '0';
                }

                //month character decrease
                $monthName = date("F", mktime(0, 0, 0, $month, 1));
                $month_name_get = substr($monthName, 0, 3);

                $p_a_days = '(P:' . $value->monthy_present_days . ')<br>' . '(A:' . $leave_count.' )';

                $month_total_allo = $value->basic_salary + $amount1 + $amount2 + $amount3;

                $emp_info = '('.$emp_id . ')<br>' . $full_name;
                
                $emp_name_info = '['.$emp_id . ']<br>' . $full_name;

                $month_year_get = $month_name_get . ',' . $year;
                
                ?>

                    <td><?php echo $emp_info ;?></td>

                    <td><?php echo $month_year_get ;?></td>

                    <td><?php echo $p_a_days ;?></td>

                    <td><?php echo $value->basic_salary ;?></td>

                    <td><?php echo $lop ;?></td>

              <?php

                $gross_salary = $value->basic_salary;

                $allowances = $this->db->get('allowance');

                foreach ($allowances->result() as $allowance) {

                    if ($allowance->type_id == 1) {

                        $sql = 'SELECT * FROM xin_salary_payslip_allowances WHERE employee_id = ? and allowance_title=? and salary_month=?';

                        $binds = array($value->employee_id, $allowance->id, $month_year);

                        $payslip_allowance = $this->db->query($sql, $binds)->row();



                        if (!empty($payslip_allowance)) {

                            $amount = $payslip_allowance->allowance_amount;

                            $gross_salary += $amount;
                        } else

                            $amount = '0';
                    } else if ($allowance->type_id == 2) {

                        $sql = 'SELECT * FROM xin_salary_payslip_commissions WHERE employee_id = ? and commission_title=? and salary_month=?';

                        $binds = array($value->employee_id, $allowance->id, $month_year);

                        $payslip_commission = $this->db->query($sql, $binds)->row();



                        if (!empty($payslip_commission)) {

                            $amount = $payslip_commission->commission_amount;

                            $gross_salary += $amount;
                        } else

                            $amount = '0';
                    } else if ($allowance->type_id == 3) {

                        $sql = 'SELECT * FROM xin_salary_payslip_statutory_deductions WHERE employee_id = ? and deduction_title=? and salary_month=?';

                        $binds = array($value->employee_id, $allowance->id, $month_year);

                        $statutory_deduction = $this->db->query($sql, $binds)->row();

                        if (!empty($statutory_deduction)) {

                            $amount = $statutory_deduction->deduction_amount;

                            $gross_salary -= $amount;
                        } else

                            $amount = '0';
                    }  else if ($allowance->type_id == 4) {

                        $sql = 'SELECT * FROM xin_salary_payslip_loan WHERE employee_id = ? and salary_month=?';

                        $binds = array($value->employee_id, $month_year);

                        $payslip_loan = $this->db->query($sql, $binds)->row();

                        if (!empty($payslip_loan)) {

                            $amount = $payslip_loan->loan_amount;

                            $gross_salary -= $amount;
                        } else

                            $amount = '0';
                    } else if ($allowance->type_id == 5) {

                        $sql = 'SELECT * FROM xin_salary_payslip_other_payments WHERE employee_id = ? and salary_month=?';

                        $binds = array($value->employee_id, $month_year);

                        $payslip_other_payments = $this->db->query($sql, $binds)->row();



                        if (!empty($payslip_other_payments)) {

                            $amount = $payslip_other_payments->payments_amount;

                            $gross_salary += $amount;
                        } else

                            $amount = '0';
                    }

                    ?>

                     <td><?php echo $amount ;?></td>

                    <?php
                }


                //late deduction
                $emp_main_id = $value->employee_id;
                $sql_late = "SELECT total_late_deduction FROM `xin_salary_payslips` WHERE salary_month = '$month_year' and employee_id = $emp_main_id";

                $late_deduction_data = $this->db->query($sql_late)->row();
                if (!empty($late_deduction_data)) {
                    $late_deduction_data_get = $late_deduction_data->total_late_deduction;
                } else {
                    $late_deduction_data_get = '0';
                }
                
                if($value->amt_leave_encashment != ''){
                    $amt_leave_encashment = $value->amt_leave_encashment;
                }else{
                    $amt_leave_encashment = 0;
                }

                ?>

                    <td><?php echo $amt_leave_encashment ;?></td>
                    <td><?php echo $value->total_overtime ;?></td>
                    <td><?php echo $value->advance_salary_amount ;?></td>
                    <td><?php echo $value->amt_indemnity ;?></td>
                    <td><?php echo $value->total_loan ;?></td>
                    <td><?php echo $value->leave_deduction ;?></td>
                    <td><?php echo $late_deduction_data_get ;?></td>
                    <td><?php echo $value->net_salary ;?></td>
                    
                    </tr>

                <?php

            }
        

        ?>

<!--backend code end -->


        </tbody>
      </table>

<!--content end-->


</div>
  </body>

</html>