<!DOCTYPE html>
<html lang="en">

<head>
    <title>Monthly Pay Slip</title>
  <style type="text/css">
    body {
      position: relative;
      width: 21cm;
      height: 29.7cm;
      margin: 0 auto;
      font-family: Verdana, sans-serif;
      font-size: 12px;
      font-family: Verdana;
    }

    #page_1 {
      position: relative;
      overflow: hidden;
      padding: 0px;
      border: none;
    }

    #page_1 #id1_1 {
      border: none;
      border: none;
      overflow: hidden;
    }

    #page_1 #id1_2 {
      border: none;
      margin: 20px 0px 0px 0px;
      padding: 0px;
      border: none;
      width: 790px;
      overflow: hidden;
    }

    #page_1 #p1dimg1 {
      position: absolute;
      top: 55px;
      left: 52px;
      z-index: -1;
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1dimg1 #p1img1 {
      width: 682px;
      height: 1012px;
    }

    #page_1 #p1inl_img1 {
      position: relative;
      width: 56px;
      height: 14px;
    }



    .ft0 {
      font: bold 15px 'Helvetica';
      line-height: 18px;
    }

    .ft1 {
      font: 13px 'Helvetica';
      line-height: 16px;
    }

    .ft2 {
      font: bold 21px 'Arial';
      line-height: 24px;
    }

    .ft3 {
      font: bold 13px 'Arial';
      line-height: 16px;
    }

    .ft4 {
      font: 13px 'Arial';
      line-height: 16px;
    }

    .p0 {
      margin-top: 0px;
      margin-bottom: 0px;
    }

    .p1 {
      margin-top: 1px;
      margin-bottom: 0px;
    }

    .p2 {
      margin-top: 46px;
      margin-bottom: 0px;
      font-size: 15px;
    }

    .p3 {
      margin-top: 8px;
      margin-bottom: 0px;
    }



    table {
      width: 100%;
      border-collapse: collapse;
      border-spacing: 5px;
      margin-bottom: 30px;
      margin-top: 30px;

    }

    td {
      padding: 3px;
    }


    th {
      padding: 10px;
    }
    
    @media print {
         #page_1 {
            border: 1px solid white;
            height: 99%;
            page-break-after: avoid;
            page-break-before: avoid;
         }
    }

  </style>
</head>

<body>
  <?php foreach ($lists as $val) {
    $bank_details = explode("&", $val['bank_acc_details']);

  ?>
    <div id="page_1">
      <div id="id1_1">
        <img src="<?php echo $logo; ?>" id="p1inl_img1" style="width:25%;">
        <p class="p0 ft0" align="center"><?php echo $company_name; ?></p>
        <p class="p1 ft1" align="center"><?php echo $header_string ?></p>
        <p class="p2 ft2" align="center">Monthly Pay Slip</p>
        <p class="p3 ft4" align="center">Year & Date: <span class="ft3"><?php echo date('F', strtotime($month_year)); ?> <?php echo date('Y', strtotime($month_year)); ?></span></p>
        <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
          <thead>
            <tr>
              <th colspan="4" style="background: #69e48a;">Employee Details</th>
            </tr>
          </thead>
          <tbody>

            <tr>
              <td>Name</td>
              <td><?php echo $val['full_name']; ?></td>
              <td>Employee ID </td>
              <td><?php echo $val['employee_id']; ?></td>
            </tr>
            <tr>
              <td>Department</td>
              <td><?php echo $val['department_name']; ?></td>
              <td>Designation </td>
              <td><?php echo $val['designation_name']; ?></td>
            </tr>
            <tr>
              <td>Date of Joining</td>
              <td><?php echo $val['date_of_joining']; ?></td>
              <td>Worked Days </td>
              <td><?php echo $val['monthy_present_days']; ?></td>
            </tr>
            <tr>
              <td>Office Shift</td>
              <td><?php echo $val['office_shift']; ?></td>
              <td>Total Leave </td>
              <td><?php echo $val['leave_count']; ?></td>
            </tr>
            <tr>
              <td>Bank Account Number</td>
              <?php
                if(!empty($bank_details[1])){
                    $bank_details_get = $bank_details[1];
                }else{
                    $bank_details_get = '';
                }
                
                if(!empty($bank_details[0])){
                    $bank_details_get2 = $bank_details[0];
                }else{
                    $bank_details_get2 = '';
                }
              ?>
              <td><?php echo $bank_details_get; ?></td>
              <td>Bank Name </td>
              <td><?php echo $bank_details_get2; ?></td>
            </tr>
          </tbody>
        </table>
         <?php echo $val['tbl1_lv']; ?>
        <table border="1" cellspacing="0" cellpadding="0" style="width:100%">
          <thead>
            <tr>
              <th colspan="2" style="background: #69e48a;">Description</th>
              <th style="background: #69e48a;">Earnings</th>
              <th style="background: #69e48a;">Deductions</th>
            </tr>
          </thead>
          <tbody>
            <?php echo $val['basic_salary_amt_get']; ?>
            <?php echo $val['earning_details']; ?>
            <?php echo $val['deduction_details']; ?>
            <?php echo $val['total_other_payments_get']; ?>
            <?php echo $val['late_deduction_data_get']; ?>
            <?php echo $val['leave_amount']; ?>
            <?php echo $val['ot_amount']; ?>
            <?php echo $val['adv_amount']; ?>
            <?php echo $val['loan_amount']; ?>
            <tr>
              <td colspan="2" style="text-align: center;"><b>Total</b></td>
              <td style="text-align: center;"><b><?php echo $this->Xin_model->currency_sign($val['earning_amount']); ?></b> </td>
              <td style="text-align: center;"><b><?php echo $this->Xin_model->currency_sign($val['deduction_amount']); ?></b> </td>
            </tr>
            <tr>
              <td colspan="2" style="text-align: center;"></td>
              <td colspan="2" style="background: #69e48a;text-align: center;"><b>NET PAY</b></td>
            </tr>
            <tr>
                <?php 
                
                    $split_val = explode(".", $val['net_salary']);
        			if (count($split_val) > 1) {
        				$word_amt = $this->Xin_model->wholeconvertNumberToWord($split_val[0],$split_val[1],'Bahraini Dinars','& Fils','Only');
        			} else {
        				$word_amt = $this->Xin_model->wholeconvertNumberToWord($val['net_salary'],'','','','');
        			}
                
                ?>
              <td colspan="2" style="text-align: center; text-transform: capitalize;"><?php echo ucwords($word_amt); ?></td>
              <td colspan="2" style="text-align: center;"><b><?php echo $this->Xin_model->currency_sign($val['net_salary']); ?></b></td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  <?php } ?>
</body>

</html>