<?php
$get_animate = $this->Xin_model->get_content_animate();
$session = $this->session->userdata('username');
$days_in_month = date('t', strtotime($office_shift['month']));
?>
<div class="card mb-4 <?php echo $get_animate;?>">
    <div id="accordion">
        <div class="card-header with-elements">
            <span class="card-header-title mr-2">
                <strong>Edit</strong> <?php echo $this->lang->line('left_office_shift');?>
            </span>
        </div>
        
        <div id="add_shift_form" class="collapse add-form show <?php echo $get_animate;?>" data-parent="#accordion" style="">
            <div class="card-body">
                <?php $attributes = array('name' => 'edit_office_shift', 'id' => 'form-office-shift-edit', 'autocomplete' => 'off');?>
                <?php $hidden = array('user_id' => $session['user_id'], 'employee_id' => $employee[0]->user_id, 'month' => $office_shift['month']);?>
                <?php echo form_open('admin/timesheet/office_shift_custom_update_validate/'.$office_shift['id'], $attributes, $hidden);?>
                <input type="hidden" name="pop_office_shift_ids_edit" id="pop_office_shift_ids_edit" value="<?php echo $office_shift['id']; ?>">
                <div class="bg-white">
                    <div class="box-block">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="employee_id">Employee<span class="text_field">*</span></label>
                                    <p class="form-control-static"><?=$employee[0]->first_name?> <?=$employee[0]->last_name?></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name"><?php echo $this->lang->line('xin_shift_name');?><span class="text_field">*</span></label>
                                    <input type="text" name="name" id="name" class="form-control" placeholder="<?php echo $this->lang->line('xin_shift_name');?>" value="<?=$office_shift['name']?>">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="month">Month<span class="text_field">*</span></label>
                                    <p class="form-control-static"><?=$office_shift['month']?></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="late_allowed_till">Late allowed till ( in minutes )</label>
                                    <input type="number" name="late_allowed_till" id="late_allowed_till" class="form-control" placeholder="Late allowed till" value="<?=$office_shift['late_allowed_till']?>" >
                                </div>
                            </div>
                        </div>
                        
                        <div id="shift-timings">
                            <div class="row">
                                <div class="col-md-2">&nbsp;</div>
                                <div class="col-md-3"><h5>Shift start</h5></div>
                                <div class="col-md-3"><h5>Shift end</h5></div>
                                <div class="col-md-2"><h5>Total Hours</h5></div>
                            </div>
                            <?php for($i = 1;$i <= $days_in_month;$i++):
                                $in_date = $out_date = $office_shift['month'].'-'.str_pad($i, 2, 0, STR_PAD_LEFT);
                                $in_time = $out_time = $hours = '';
                                
                                if ($office_shift[$i.'_in'])
                                {
                                    $in_date = date('Y-m-d', strtotime($office_shift[$i.'_in']));
                                    $in_time = date('H:i', strtotime($office_shift[$i.'_in']));
                                }
                                
                                if ($office_shift[$i.'_out'])
                                {
                                    $out_date = date('Y-m-d', strtotime($office_shift[$i.'_out']));
                                    $out_time = date('H:i', strtotime($office_shift[$i.'_out']));
                                }

                                $hours = $office_shift[$i.'_hrs'];
                                
                                $date = "$office_shift[month]-$i";
                                $weekday_label = date('M d l', strtotime($date));
                            ?>
                            <div class="form-group row">
                                <label for="time" class="col-md-2"><?=$weekday_label;?></label>
                                <div class="col-md-3">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input class="form-control date" ="" readonly name="<?=$i?>_in[date]" type="text" value="<?=$in_date?>">
                                        </div>
                                        <div class="col-md-6"> 
                                            <input class="form-control timepicker time_in_class time_in_class_<?=$i?> clear-<?=$i?>" ="" data-time_id="<?=$i?>" placeholder="" readonly name="<?=$i?>_in[time]" type="text" value="<?=$in_time?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <input class="form-control date" readonly name="<?=$i?>_out[date]" ="" type="text" value="<?=$out_date?>">
                                        </div>
                                        <div class="col-md-6">
                                            <input class="form-control timepicker time_out_class time_out_class_<?=$i?> clear-<?=$i?>" ="" data-time_id="<?=$i?>" placeholder="" readonly name="<?=$i?>_out[time]" type="text" value="<?=$out_time?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <input class="form-control" name="<?=$i?>_hrs" type="text" value="<?=$hours?>">
                                </div>
                                <div class="col-md-2">
                                    <button type="button" class="btn btn-primary clear-time" data-clear-id="<?=$i?>"><?=$this->lang->line('xin_clear')?></button>
                                </div>
                            </div>
                            <?php endfor;?>
                        </div>
                    </div>
                    <?php $add = 'Add Office Shift'; ?>
                    <input type="hidden" id="form_id" value="form-office-shift-edit">
                    <div class="form-actions box-footer">
                        <a href="/admin/timesheet/office_shift_custom" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-check-square"></i> <?php echo $add;?>
                        </button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<style type="text/css">
.hide-calendar .ui-datepicker-calendar { display:none !important; }
.hide-calendar .ui-priority-secondary { display:none !important; }
</style>
<script>
// $(function(){
//     $('#month').datepicker({
// 		changeMonth: true,
// 		changeYear: true,
// 		showButtonPanel: true,
// 		dateFormat:'yy-mm',
// 		yearRange: '2021:' + (new Date().getFullYear() + 15),
// 		beforeShow: function(input) {
// 			$(input).datepicker("widget").addClass('hide-calendar');
// 		},
// 		onClose: function(dateText, inst) {
// 			var month = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
// 			var year = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
// 			$(this).datepicker('setDate', new Date(year, month, 1));
// 			$(this).datepicker('widget').removeClass('hide-calendar');
// 			$(this).datepicker('widget').hide();
			
// 			/*$("#shift-timings").html("Loading...");
// 			var month = $('#month').val();
// 			$.get(base_url + '/office_shift_custom_elements/'+month, function(data){
// 			    $("#shift-timings").html(data);
//                 $('.timepicker').bootstrapMaterialDatePicker({
//                     date: false,
//                     shortTime: true,
//                     format: 'HH:mm'
//                 });
//                 $(".clear-time").click(function(){
//                     var clear_id = $(this).attr("data-clear-id");
//                     $("input.clear-"+clear_id).val("");
//                 });
// 			});*/
// 		}
// 	});
// 	$("form#form-office-shift-edit").on("submit", function(e){
// 	    e.preventDefault();
// 	    var obj = $(this), action = obj.attr('name');
// 		$('.save').prop('disabled', true);
// 		$.ajax({
// 			type: "POST",
// 			url: e.target.action,
// 			data: obj.serialize()+"&is_ajax=1&add_type=office_shift&form="+action,
// 			cache: false,
// 			success: function (JSON) {
// 			    $('input[name="csrf_hrsale"]').val(JSON.csrf_hash);
			    
// 				if (JSON.error != '') {
// 					toastr.error(JSON.error);
// 					Ladda.stopAll();
// 				} else {
// 				    toastr.success(JSON.result);
// 				    Ladda.stopAll();
// 				}
				
// 				$('.save').prop('disabled', false);
// 			}
// 		});
// 	});
// });
</script>
