var leaves_assigned_table;
var leaves_assigned_table_added;
var leaves_history_table_added;
$(document).ready(function(){
    var leave_history_employee_id = $('#leave_history_employee_id').val();
    leaves_assigned_table = $(".leaves_assigned_table").dataTable({});
    leaves_assigned_table_added = $(".leaves_assigned_table_added").dataTable({});
    leaves_history_table_added = $(".leaves_history_table_added").dataTable({
        
            "bDestroy": true,
            "ajax": {
                url : site_url+"/history/leaves_history_added_view/"+leave_history_employee_id+"/",
                type : 'GET'
            },
            "fnDrawCallback": function(settings){
                $('[data-toggle="tooltip"]').tooltip();
            }
        });
    $("select[name=created_at]").on("change", function(){
        var created_at = $(this).val();
        
        if (created_at === '') {
            return false;
        }
        
        var employee_id = $(this).attr("data-emp_id");
        leaves_assigned_table = $(".leaves_assigned_table").dataTable({
            "bDestroy": true,
            "ajax": {
                url : site_url+"/history/leaves_assigned/"+employee_id+"/"+created_at+"/",
                type : 'GET'
            },
            "fnDrawCallback": function(settings){
                $('[data-toggle="tooltip"]').tooltip();
            }
        });
        leaves_assigned_table_added = $(".leaves_assigned_table_added").dataTable({
            "bDestroy": true,
            "ajax": {
                url : site_url+"/history/leaves_assigned_added/"+employee_id+"/"+created_at+"/",
                type : 'GET'
            },
            "fnDrawCallback": function(settings){
                $('[data-toggle="tooltip"]').tooltip();
            }
        });
        
    });
    
    $("form#form-leave-assign").on("submit", function(e){
        e.preventDefault();
        var obj = $(this);
        $.ajax({
            type: "POST",
            url: e.target.action,
            data: obj.serialize()+"&is_ajax=1",
            cache: false,
            success: function (JSON) {
            	if (JSON.error !== '') {
            		toastr.error(JSON.error);
            	} else {
            		toastr.success(JSON.result);
            		leaves_assigned_table.api().ajax.reload(function(){ }, true);
            	}
            	
            	$('form#form-leave-assign')[0].reset();
            	$('input[name="csrf_hrsale"]').val(JSON.csrf_hash);
            	Ladda.stopAll();
            }
        });
    });
    
    $("form#delete_leave_assigned").on("submit", function(e){
        e.preventDefault();
        var obj = $(this);
        $.ajax({
            type: "POST",
            url: e.target.action,
            data: obj.serialize()+"&is_ajax=1",
            cache: false,
            success: function (JSON) {
            	if (JSON.error !== '') {
            		toastr.error(JSON.error);
            	} else {
            		toastr.success(JSON.result);
            		leaves_assigned_table.api().ajax.reload(function(){ }, true);
            	}
            	
            	$(".delete-leave-counts-modal").modal("hide");
            	$('input[name="csrf_hrsale"]').val(JSON.csrf_hash);
            	Ladda.stopAll();
            }
        });
    });
    

    
    $("form#delete_leave_history").on("submit", function(e){
        e.preventDefault();
        var obj = $(this);
        $.ajax({
            type: "POST",
            url: e.target.action,
            data: obj.serialize()+"&is_ajax=1",
            cache: false,
            success: function (JSON) {
            	if (JSON.error !== '') {
            		toastr.error(JSON.error);
            	} else {
            		toastr.success(JSON.result);
            		leaves_history_table_added.api().ajax.reload(function(){ }, true);
            	}
            	
            	$(".delete-leave-history-modal").modal("toggle");
            	$('input[name="csrf_hrsale"]').val(JSON.csrf_hash);
            	Ladda.stopAll();
            }
        });
    });
    
    $("#form-leave-add select[name=create_date]").on("change", function(){
        var year = $(this).val();
        $("#form-leave-add").find("input[name=start_date]").val(year);
        $("#form-leave-add").find("input[name=end_date]").val(year);
        var employee_id = $("select[name=create_date]").attr("data-emp_id");
        $.get(site_url+"history/leaves_types_assigned_options/"+employee_id+"/"+year+"/").done(function(options){
            $("select[name=leave_type]").html(options).prop("disabled", false);
        });
    });
    
    $("form#form-leave-add").on("submit", function(e){
        e.preventDefault();
        var obj = $(this);
        $.ajax({
            type: "POST",
            url: e.target.action,
            data: obj.serialize()+"&is_ajax=1",
            cache: false,
            success: function (JSON) {
            	if (JSON.error !== '') {
            		toastr.error(JSON.error);
            	} else {
            		toastr.success(JSON.result);
            	}
            	
            	$('form#form-leave-add')[0].reset();
            	$('input[name="csrf_hrsale"]').val(JSON.csrf_hash);
            	Ladda.stopAll();
            }
        });
    });
    
    
    $("form#form-leave-history-add").on("submit", function(e){
        e.preventDefault();
        var obj = $(this);
        $.ajax({
            type: "POST",
            url: e.target.action,
            data: obj.serialize()+"&is_ajax=1",
            cache: false,
            success: function (JSON) {
            	if (JSON.error !== '') {
            		toastr.error(JSON.error);
            	} else {
            		toastr.success(JSON.result);
            		leaves_history_table_added.api().ajax.reload(function(){ }, true);
            	}
            	
            	$('form#form-leave-history-add')[0].reset();
            	$('input[name="csrf_hrsale"]').val(JSON.csrf_hash);
            	Ladda.stopAll();
            }
        });
    });
    
	$('.edit-history-modal-data').on('show.bs.modal', function (event) {

		var button = $(event.relatedTarget);

		var field_id = button.data('field_id');

		var field_tpe = button.data('field_type');

		if(field_tpe == 'leavehistory_view'){

			var leave_history_id = button.data('field_id');
			
			var leave_type_id =  button.data('leave_type_id');
			
			var employee_id = button.data('employee_id');

			var from_date = button.data('from_date');

			var to_date = button.data('to_date');

			var leave_half_day = button.data('leave_half_day');

			var reason = button.data('reason');

			var remark = button.data('remark');

			var field_add = '&data=leavehistory&type=leavehistory&leave_history_id='+leave_history_id+'&leave_type_id='+leave_type_id+'&employee_id='+employee_id+'&from_date='+from_date+'&to_date='+to_date+'&leave_half_day='+leave_half_day+'&reason='+reason+'&remark='+remark+'&';

		}

		var modal = $(this);

		$.ajax({

			url: site_url+'history/dialog_'+field_tpe+'/',

			type: "GET",

			data: 'jd=1'+field_add+'field_id='+field_id,

			success: function (response) {

				if(response) {

					$("#ajax_history_modal").html(response);

				}

			}

		});		

   });

});

$('body').on('click', '.delete_leave_history_btn', function() {
	var leave_history_id = $(this).data('record-id');
	$("#delete_leave_history_id").val(leave_history_id);

});


