$(function () {
    var xin_table = $('#xin_table').dataTable({
        "bDestroy": true,
        "scrollX": true,
        "ajax": {
            url: site_url + "timesheet/office_shift_custom_list/",
            type: 'GET'
        },
        "fnDrawCallback": function (settings) {
            $('[data-toggle="tooltip"]').tooltip();
        }
    });

    $('#month').datepicker({
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'yy-mm',
        yearRange: '2021:' + (new Date().getFullYear() + 15),
        beforeShow: function (input) {
            $(input).datepicker("widget").addClass('hide-calendar');
        },
        onClose: function (dateText, inst) {
            var month = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
            var year = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
            $(this).datepicker('setDate', new Date(year, month, 1));
            $(this).datepicker('widget').removeClass('hide-calendar');
            $(this).datepicker('widget').hide();

            $("#shift-timings").html("Loading...");
            var month = $('#month').val();
            $.get(base_url + '/office_shift_custom_elements/' + month, function (data) {
                $("#shift-timings").html(data);
                $('.timepicker').bootstrapMaterialDatePicker({
                    date: false,
                    shortTime: true,
                    format: 'HH:mm'
                });
                $('.date').bootstrapMaterialDatePicker({
                    weekStart: 0,
                    time: false,
                    clearButton: false,
                    format: 'YYYY-MM-DD'
                });
                $(".clear-time").click(function () {
                    var clear_id = $(this).attr("data-clear-id");
                    $("input.clear-" + clear_id).val("");
                });
            });
        }
    });
     $("form#form-office-shift").on("submit", function (e) {
        e.preventDefault();

        let total_in_count = 0;
        let total_out_count = 0;
        $('.time_in_class').each(function (i, obj) {
            var id = $(this).data('time_id');
            var time_in = $('.time_in_class_' + id).val();
            if (time_in) {
                var time_out = $('.time_out_class_' + id).val();
                if (time_out == '') {
                    total_out_count = parseInt(total_out_count) + parseInt(1);
                }
            }
        });


        $('.time_out_class').each(function (i, obj) {
            var id = $(this).data('time_id');
            var time_out = $('.time_out_class_' + id).val();
            if (time_out) {
                var time_in = $('.time_in_class_' + id).val();
                if (time_in == '') {
                    total_in_count = parseInt(total_in_count) + parseInt(1);
                }
            }
        });
        if ((total_in_count > 0) || (total_out_count > 0)) {
            toastr.error('Please Fill The Shift start & end timings');
            Ladda.stopAll();
        } else {
            var obj = $(this), action = obj.attr('name');
            $('.save').prop('disabled', true);
            $.ajax({
                type: "POST",
                url: base_url+'/office_shift_custom_add_validate/',
                data: obj.serialize() + "&is_ajax=1&add_type=office_shift&form=" + action,
                cache: false,
                success: function (JSON) {
                    $('input[name="csrf_hrsale"]').val(JSON.csrf_hash);

                    if (JSON.error != '') {
                        toastr.error(JSON.error);
                        Ladda.stopAll();
                    } else {
                        $('#modal-confirm-add-shift_custom').modal('show');
                        // toastr.success(JSON.result);
                        Ladda.stopAll();

                        // xin_table.api().ajax.reload(function () {
                        // }, true);

                        // $('.add-form').removeClass('show');
                        // $('form#form-office-shift')[0].reset(); // To reset form fields
                    }

                    $('.save').prop('disabled', false);
                }
            });
        }
    });
    // $("form#form-office-shift").on("submit", function (e) {
    //     e.preventDefault();

    //     let total_in_count = 0;
    //     let total_out_count = 0;
    //     $('.time_in_class').each(function (i, obj) {
    //         var id = $(this).data('time_id');
    //         var time_in = $('.time_in_class_' + id).val();
    //         if (time_in) {
    //             var time_out = $('.time_out_class_' + id).val();
    //             if (time_out == '') {
    //                 total_out_count = parseInt(total_out_count) + parseInt(1);
    //             }
    //         }
    //     });


    //     $('.time_out_class').each(function (i, obj) {
    //         var id = $(this).data('time_id');
    //         var time_out = $('.time_out_class_' + id).val();
    //         if (time_out) {
    //             var time_in = $('.time_in_class_' + id).val();
    //             if (time_in == '') {
    //                 total_in_count = parseInt(total_in_count) + parseInt(1);
    //             }
    //         }
    //     });
    //     if ((total_in_count > 0) || (total_out_count > 0)) {
    //         toastr.error('Please Fill The Shift start & end timings');
    //         Ladda.stopAll();
    //     } else {
    //         var obj = $(this), action = obj.attr('name');
    //         $('.save').prop('disabled', true);
    //         $.ajax({
    //             type: "POST",
    //             url: e.target.action,
    //             data: obj.serialize() + "&is_ajax=1&add_type=office_shift&form=" + action,
    //             cache: false,
    //             success: function (JSON) {
    //                 $('input[name="csrf_hrsale"]').val(JSON.csrf_hash);

    //                 if (JSON.error != '') {
    //                     toastr.error(JSON.error);
    //                     Ladda.stopAll();
    //                 } else {
    //                     toastr.success(JSON.result);
    //                     Ladda.stopAll();

    //                     xin_table.api().ajax.reload(function () {
    //                     }, true);

    //                     $('.add-form').removeClass('show');
    //                     $('form#form-office-shift')[0].reset(); // To reset form fields
    //                 }

    //                 $('.save').prop('disabled', false);
    //             }
    //         });
    //     }
    // });


    $('.delete-modal').on('shown.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var shift_id = button.data('record-id');
        $("form#delete_record").find("input#shift_id").remove();
        $("form#delete_record").append('<input type="hidden" name="shift_id" id="shift_id" value="' + shift_id + '">');
    });
    $(document).on("submit", "form#delete_record", function (e) {
        e.preventDefault();
        var obj = $(this), action = obj.attr('name');
        $.ajax({
            type: "POST",
            url: base_url + "/office_shift_custom_delete",
            data: obj.serialize() + "&is_ajax=1&form=" + action,
            cache: false,
            success: function (JSON) {
                $('input[name="csrf_hrsale"]').val(JSON.csrf_hash);

                if (JSON.error != '') {
                    toastr.error(JSON.error);
                    Ladda.stopAll();
                } else {
                    toastr.success(JSON.result);
                    Ladda.stopAll();

                    xin_table.api().ajax.reload(function () {
                    }, true);
                }

                $(".delete-modal").modal("hide");
            }
        });
    });

    $('body').on('change', '.time_in_class', function () {
        var id = $(this).data('time_id');
        var time_in = $('.time_in_class_' + id).val();
        var time_out = $('.time_out_class_' + id).val();
        if(time_in && time_out){
            var st = minFromMidnight(time_in);
            var et = minFromMidnight(time_out);
            if (st > et) {
                alert("End time must be greater than start time");
                $('.time_out_class_' + id).val('');
            }
        }
        
    });

    $('body').on('change', '.time_out_class', function () {
        var id = $(this).data('time_id');
        var time_in = $('.time_in_class_' + id).val();
        var time_out = $('.time_out_class_' + id).val();
        var date_in = $('.date_in_' + id).val();

        var date_out = $('.date_out_' + id).val();

        console.log('date_out  ' +date_out);

        console.log('date_in  ' +date_in);

        console.log('time_in  ' +time_in);

        console.log('time_out ' +time_out);

        if((time_in && time_out)&&(date_in ==date_out)){
    
        if(time_in && time_out){
            var st = minFromMidnight(time_in);
            var et = minFromMidnight(time_out);
            if (st > et) {
                alert("End time must be greater than start time");
                $('.time_out_class_' + id).val('');
            }
        }
    }
    });


    function minFromMidnight(tm) {
        var ampm = tm.substr(-2)
        var clk = tm.substr(0, 5);
        var m = parseInt(clk.match(/\d+$/)[0], 10);
        var h = parseInt(clk.match(/^\d+/)[0], 10);
        h += (ampm.match(/pm/i)) ? 12 : 0;
        return h * 60 + m;
    }
});