$(document).ready(function(){
    $(document).on('change', '#leave_count_report select#employee_id', function(e) {
        var employee_id = $(this).val();
        $.get(base_url + '/date_ranges/'+ employee_id +'/', function(data){
            $("select#year").html(data);
        });
    });
    
    $(document).on('change', '#leave_count_report select#year', function(e) {
        var year = $(this).val();
        var employee_id = $('select#employee_id').val();
        $.get(base_url + '/assigned_leaves/'+ employee_id +'/'+ year +'/', function(data){
            $("select#leave_type").html(data);
        });
    });
    
    $("form#leave_count_report").on("submit", function(e){
        e.preventDefault();
        
        var employee_id = $('select#employee_id').val();
        var year = $('select#year').val();
        //alert(year);
        var year_range = $('select#year option:selected').html();
        var leave_type = $('select#leave_type').val();
        //alert(base_url+"/list_leaves_assigned/"+employee_id+"/"+year+"/"+leave_type+"/?year_range="+year_range);
        $("#xin_table_detailed_leave_count_report").dataTable({
            "bDestroy": true,
            "ajax": {
                url : base_url+"/list_leaves_assigned/"+employee_id+"/"+year+"/"+leave_type+"/?year_range="+year_range,
                type : 'GET',
                dataSrc: function(headerdata){
                    $('input[name="csrf_hrsale"]').val(headerdata.csrf_hash);
                     return headerdata.data;
                }
            },
            dom: 'lBfrtip',
            // "buttons": [{
            //     extend: 'csv',
            //     exportOptions: {
            //         columns: [ 0, 1, 2, 3, 4, 5]
            //     }
            // }, {
            //     extend: 'excel',
            //     exportOptions: {
            //         columns: [ 0, 1, 2, 3, 4, 5]
            //     }
            // }, {
            //     extend: 'pdfHtml5',
            //     exportOptions: {
            //       columns: [ 0, 1, 2, 3, 4, 5]
            //     }
            // }, {
            //     extend: 'print',
            //     exportOptions: {
            //         columns: [ 0, 1, 2, 3, 4, 5]
            //     }
            // },], // colvis > if needed
            "buttons": [
                {
                    extend: 'pdf',
                    attr:  {
                        title: 'Pdf',
                        id: 'pdf_download'
                    },
                    action: function pdf_download() {
                        $('#p_company_id').val($('#aj_company').val());
                        $('#p_employee_id').val($('#employee_id').val());
                        $('#p_year').val($('#year').val());
                        $('#p_leave_type').val($('#leave_type').val());
                        $('#detailed_leave_count_pdf').submit();
                    }
                }, {
                extend: 'excel',
                exportOptions: {
                    columns: [ 0, 1, 2, 3]
                }
                }],
            "fnDrawCallback": function(settings){
                $('[data-toggle="tooltip"]').tooltip();
            }
        });
        
        Ladda.stopAll();
    });
});