<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Uniform_model extends CI_Model
	{
 
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
	public function get_uniform_categories() {
	  return $this->db->get("uniform_category");
	}
	
	public function add_uniform_category($data){
		$this->db->insert('uniform_category', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}
		public function read_uniform_category_info($id) {
	
		$sql = 'SELECT * FROM uniform_category WHERE uniform_category_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
		public function update_uniform_category_record($data, $id){
		$this->db->where('uniform_category_id', $id);
		if( $this->db->update('uniform_category',$data)) {
			return true;
		} else {
			return false;
		}		
	}
		public function delete_uniform_category_record($id){
		$this->db->where('uniform_category_id', $id);
		$this->db->delete('uniform_category');
		
	}	public function delete_uniform_return($id){
		$this->db->where('id', $id);
		$this->db->delete('return_quantity');
		
	}
		public function delete_uniform($id){
		$this->db->where('uniform_id', $id);
		$this->db->delete('uniform_employee');
		
	}
	public function get_all_uniform_categories() {
	  $query = $this->db->get("uniform_category");
	  return $query->result();
	}
	public function get_uniform() {
	  return $this->db->group_by('uniform_employee_id') ->group_by('uniform_cat_id')->get("uniform_employee");
	}
	public function get_company_uniform($company_id) {
	
		$sql = 'SELECT * FROM uniform_employee WHERE uniform_company_id = ?';
		$binds = array($company_id);
		$query = $this->db->query($sql, $binds);
		return $query;
	}public function get_employee_uniform($id) {
		
		//$id = $this->db->escape($id);
		$sql = 'SELECT * FROM uniform_employee WHERE uniform_employee_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
	 	return $query;
	}
	public function read_uniform_cat_info($id) {
	
		$sql = 'SELECT * FROM uniform_category WHERE uniform_category_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
		public function add_uniform($data){
		$this->db->insert('uniform_employee', $data);
		if ($this->db->affected_rows() > 0) {
			return $this->db->insert_id();
		} else {
			return false;
		}
	}
	public function read_uniform_info($id) {
	
		$sql = 'SELECT * FROM uniform_employee WHERE uniform_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}	public function read_uniform_return_info($id) {
	
		$sql = 'SELECT * FROM uniform_employee left join return_quantity  on uniform_id=u_id WHERE id = ?';
		$binds = array($id);
	//	$query = $this->db->query($sql, $binds);
		print_r($query);
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
	 	public function update_uniform_record($data, $id){
		$this->db->where('uniform_id', $id);
		if( $this->db->update('uniform_employee',$data)) {
			return true;
		} else {
			return false;
		}		
	}
		public function delete_uniform_record($id){
		$this->db->where('uniform_id', $id);
		$this->db->delete('uniform_employee');
		
	}
		public function get_details($id,$cat) {
	
		$sql = 'SELECT * FROM uniform_employee WHERE uniform_employee_id = ? and uniform_cat_id =?';
		$binds = array($id,$cat);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
		}
	public function count_quantity($id,$cat) {
	
		$sql = 'SELECT SUM(quentity) as total FROM uniform_employee where uniform_employee_id=? and uniform_cat_id=?';
		$binds = array($id,$cat);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
	public function ajax_employee_cat_info($id){
	    	//$sql = "SELECT * FROM xin_employees WHERE company_id = ? and user_role_id!='1' and is_logged_in='1'";
		$sql = "SELECT * FROM `uniform_employee` left join uniform_category on uniform_cat_id=uniform_category_id where uniform_employee_id=? GROUP BY uniform_category_name";
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return null;
		}
	}
	public function list_all_uniform_employee($company_id,$employee_id,$cat_id) {

		

		$sql = 'SELECT * FROM `uniform_employee` left join uniform_category on uniform_cat_id=uniform_category_id left join return_quantity on u_id=uniform_id where uniform_company_id=? and uniform_employee_id=? and uniform_cat_id=?';

		$binds = array($company_id,$employee_id,$cat_id);

		$query = $this->db->query($sql, $binds); 

		return $query;

	}
	public function update_uniform_return($data, $id){
		$this->db->where('uniform_id', $id);
		if( $this->db->update('uniform_employee',$data)) {
			return true;
		} else {
			return false;
		}		
	}
	public function get_uniform_return() {
	  return $this->db->where('r_status','return')->join('uniform_employee', 'u_id = uniform_id', 'left')->get("return_quantity");
	}
	public function get_cat_name($cat) {
	
		$sql = 'SELECT * FROM uniform_category where  uniform_category_id=?';
		$binds = array($cat);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}public function get_company_name($com) {
	
		$sql = 'SELECT * FROM xin_companies where  company_id=?';
		$binds = array($com);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
	public function get_employee_name($eid) {
	
		$sql = 'SELECT * FROM xin_employees where  user_id=?';
		$binds = array($eid);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}	public function insert_uniform_return($data){
		$this->db->insert('return_quantity', $data);
		if ($this->db->affected_rows() > 0) {
			return true;
		} else {
			return false;
		}
	}public function check_exist($uid) {
	
		$sql = 'SELECT  SUM(return_q)as total FROM return_quantity where  u_id=?';
		$binds = array($uid);
		$query = $this->db->query($sql, $binds);
	//	print_r($query);exit;
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}public function check_remain_exist($uid) {
	
		$sql = 'SELECT SUM(remain)as r  FROM return_quantity where  u_id=?';
		$binds = array($uid);
		$query = $this->db->query($sql, $binds);
	//	print_r($query);exit;
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
	public function get_r($uid) {
	
		$sql = 'SELECT remain FROM return_quantity where  u_id=?';
		$binds = array($uid);
		$query = $this->db->query($sql, $binds);
	//	print_r($query);exit;
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
	public function all_details_employee($id) {
	
		$sql = 'SELECT * FROM uniform_employee WHERE uniform_id = ?';
		$binds = array($id);
		$query = $this->db->query($sql, $binds);
		
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return false;
		}
	}
}
	?>